// spreadsort on a mostly sorted array example.
//
//  Copyright Steven Ross 2009-2014.
//
// Distributed under the Boost Software License, Version 1.0.
//    (See accompanying file LICENSE_1_0.txt or copy at
//          http://www.boost.org/LICENSE_1_0.txt)

//  See http://www.boost.org/libs/sort for library home page.

#include <boost/sort/spreadsort/spreadsort.hpp>
#include <time.h>
#include <stdio.h>
#include <stdlib.h>
#include <algorithm>
#include <vector>
#include <string>
#include <fstream>
#include <sstream>
#include <iostream>
using namespace boost::sort::spreadsort;

#define DATA_TYPE int

unsigned
get_index(unsigned count)
{
  unsigned result = unsigned((rand() % (1 << 16))*uint64_t(count)/(1 << 16));
  if (result >= count || result < 0)
    result = count - 1;
  return result;
}

//Pass in an argument to test std::sort
int main(int argc, const char ** argv) {
  srand(1);
  size_t uCount,uSize=sizeof(DATA_TYPE);
  bool stdSort = false;
  unsigned loopCount = 1;
  for (int u = 1; u < argc; ++u) {
    if (std::string(argv[u]) == "-std")
      stdSort = true;
    else
      loopCount = atoi(argv[u]);
  }
  //Sorts the data once, then times sorting of already-sorted data
  loopCount += 1;
  std::ifstream input("input.txt", std::ios_base::in | std::ios_base::binary);
  if (input.fail()) {
    printf("input.txt could not be opened\n");
    return 1;
  }
  double total = 0.0;
  std::vector<DATA_TYPE> array;
  input.seekg (0, std::ios_base::end);
    size_t length = input.tellg();
  uCount = length/uSize;
  input.seekg (0, std::ios_base::beg);
  //Conversion to a vector
  array.resize(uCount);
  unsigned v = 0;
  while (input.good() && v < uCount) // EOF or failure stops the reading
    input.read(reinterpret_cast<char *>(&(array[v++])), uSize );
  //Run multiple loops, if requested
  for (unsigned u = 0; u < loopCount; ++u) {
    for (unsigned v = 0; v < uCount/10; ++v)
      std::swap(array[get_index(uCount)], array[get_index(uCount)]);
    clock_t start, end;
    double elapsed;
    start = clock();
    if (stdSort)
      //std::sort(&(array[0]), &(array[0]) + uCount);
      std::sort(array.begin(), array.end());
    else
      //integer_sort(&(array[0]), &(array[0]) + uCount);
      integer_sort(array.begin(), array.end());
    end = clock();
    elapsed = static_cast<double>(end - start) ;
    std::ofstream ofile;
    if (stdSort)
      ofile.open("standard_sort_out.txt", std::ios_base::out |
                 std::ios_base::binary | std::ios_base::trunc);
    else
      ofile.open("boost_sort_out.txt", std::ios_base::out |
                 std::ios_base::binary | std::ios_base::trunc);
    if (ofile.good()) {
      for (unsigned v = 0; v < array.size(); ++v) {
        ofile.write(reinterpret_cast<char *>(&(array[v])), sizeof(array[v]) );
      }
      ofile.close();
    }
    if (u)
      total += elapsed;
  }
  if (stdSort)
    printf("std::sort elapsed time %f\n", total / CLOCKS_PER_SEC);
  else
    printf("spreadsort elapsed time %f\n", total / CLOCKS_PER_SEC);
  return 0;
}
