package network

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator 0.17.0.0
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.

import (
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/to"
	"net/http"
)

// ApplicationGatewayCookieBasedAffinity enumerates the values for application
// gateway cookie based affinity.
type ApplicationGatewayCookieBasedAffinity string

const (
	// Disabled specifies the disabled state for application gateway cookie
	// based affinity.
	Disabled ApplicationGatewayCookieBasedAffinity = "Disabled"
	// Enabled specifies the enabled state for application gateway cookie
	// based affinity.
	Enabled ApplicationGatewayCookieBasedAffinity = "Enabled"
)

// ApplicationGatewayOperationalState enumerates the values for application
// gateway operational state.
type ApplicationGatewayOperationalState string

const (
	// Running specifies the running state for application gateway operational
	// state.
	Running ApplicationGatewayOperationalState = "Running"
	// Starting specifies the starting state for application gateway
	// operational state.
	Starting ApplicationGatewayOperationalState = "Starting"
	// Stopped specifies the stopped state for application gateway operational
	// state.
	Stopped ApplicationGatewayOperationalState = "Stopped"
	// Stopping specifies the stopping state for application gateway
	// operational state.
	Stopping ApplicationGatewayOperationalState = "Stopping"
)

// ApplicationGatewayProtocol enumerates the values for application gateway
// protocol.
type ApplicationGatewayProtocol string

const (
	// HTTP specifies the http state for application gateway protocol.
	HTTP ApplicationGatewayProtocol = "Http"
	// HTTPS specifies the https state for application gateway protocol.
	HTTPS ApplicationGatewayProtocol = "Https"
)

// ApplicationGatewayRequestRoutingRuleType enumerates the values for
// application gateway request routing rule type.
type ApplicationGatewayRequestRoutingRuleType string

const (
	// Basic specifies the basic state for application gateway request routing
	// rule type.
	Basic ApplicationGatewayRequestRoutingRuleType = "Basic"
	// PathBasedRouting specifies the path based routing state for application
	// gateway request routing rule type.
	PathBasedRouting ApplicationGatewayRequestRoutingRuleType = "PathBasedRouting"
)

// ApplicationGatewaySkuName enumerates the values for application gateway sku
// name.
type ApplicationGatewaySkuName string

const (
	// StandardLarge specifies the standard large state for application
	// gateway sku name.
	StandardLarge ApplicationGatewaySkuName = "Standard_Large"
	// StandardMedium specifies the standard medium state for application
	// gateway sku name.
	StandardMedium ApplicationGatewaySkuName = "Standard_Medium"
	// StandardSmall specifies the standard small state for application
	// gateway sku name.
	StandardSmall ApplicationGatewaySkuName = "Standard_Small"
)

// ApplicationGatewaySslProtocol enumerates the values for application gateway
// ssl protocol.
type ApplicationGatewaySslProtocol string

const (
	// TLSv10 specifies the tl sv 10 state for application gateway ssl
	// protocol.
	TLSv10 ApplicationGatewaySslProtocol = "TLSv1_0"
	// TLSv11 specifies the tl sv 11 state for application gateway ssl
	// protocol.
	TLSv11 ApplicationGatewaySslProtocol = "TLSv1_1"
	// TLSv12 specifies the tl sv 12 state for application gateway ssl
	// protocol.
	TLSv12 ApplicationGatewaySslProtocol = "TLSv1_2"
)

// ApplicationGatewayTier enumerates the values for application gateway tier.
type ApplicationGatewayTier string

const (
	// Standard specifies the standard state for application gateway tier.
	Standard ApplicationGatewayTier = "Standard"
)

// AuthorizationUseStatus enumerates the values for authorization use status.
type AuthorizationUseStatus string

const (
	// Available specifies the available state for authorization use status.
	Available AuthorizationUseStatus = "Available"
	// InUse specifies the in use state for authorization use status.
	InUse AuthorizationUseStatus = "InUse"
)

// EffectiveRouteSource enumerates the values for effective route source.
type EffectiveRouteSource string

const (
	// EffectiveRouteSourceDefault specifies the effective route source
	// default state for effective route source.
	EffectiveRouteSourceDefault EffectiveRouteSource = "Default"
	// EffectiveRouteSourceUnknown specifies the effective route source
	// unknown state for effective route source.
	EffectiveRouteSourceUnknown EffectiveRouteSource = "Unknown"
	// EffectiveRouteSourceUser specifies the effective route source user
	// state for effective route source.
	EffectiveRouteSourceUser EffectiveRouteSource = "User"
	// EffectiveRouteSourceVirtualNetworkGateway specifies the effective route
	// source virtual network gateway state for effective route source.
	EffectiveRouteSourceVirtualNetworkGateway EffectiveRouteSource = "VirtualNetworkGateway"
)

// EffectiveRouteState enumerates the values for effective route state.
type EffectiveRouteState string

const (
	// Active specifies the active state for effective route state.
	Active EffectiveRouteState = "Active"
	// Invalid specifies the invalid state for effective route state.
	Invalid EffectiveRouteState = "Invalid"
)

// ExpressRouteCircuitPeeringAdvertisedPublicPrefixState enumerates the values
// for express route circuit peering advertised public prefix state.
type ExpressRouteCircuitPeeringAdvertisedPublicPrefixState string

const (
	// Configured specifies the configured state for express route circuit
	// peering advertised public prefix state.
	Configured ExpressRouteCircuitPeeringAdvertisedPublicPrefixState = "Configured"
	// Configuring specifies the configuring state for express route circuit
	// peering advertised public prefix state.
	Configuring ExpressRouteCircuitPeeringAdvertisedPublicPrefixState = "Configuring"
	// NotConfigured specifies the not configured state for express route
	// circuit peering advertised public prefix state.
	NotConfigured ExpressRouteCircuitPeeringAdvertisedPublicPrefixState = "NotConfigured"
	// ValidationNeeded specifies the validation needed state for express
	// route circuit peering advertised public prefix state.
	ValidationNeeded ExpressRouteCircuitPeeringAdvertisedPublicPrefixState = "ValidationNeeded"
)

// ExpressRouteCircuitPeeringState enumerates the values for express route
// circuit peering state.
type ExpressRouteCircuitPeeringState string

const (
	// ExpressRouteCircuitPeeringStateDisabled specifies the express route
	// circuit peering state disabled state for express route circuit peering
	// state.
	ExpressRouteCircuitPeeringStateDisabled ExpressRouteCircuitPeeringState = "Disabled"
	// ExpressRouteCircuitPeeringStateEnabled specifies the express route
	// circuit peering state enabled state for express route circuit peering
	// state.
	ExpressRouteCircuitPeeringStateEnabled ExpressRouteCircuitPeeringState = "Enabled"
)

// ExpressRouteCircuitPeeringType enumerates the values for express route
// circuit peering type.
type ExpressRouteCircuitPeeringType string

const (
	// AzurePrivatePeering specifies the azure private peering state for
	// express route circuit peering type.
	AzurePrivatePeering ExpressRouteCircuitPeeringType = "AzurePrivatePeering"
	// AzurePublicPeering specifies the azure public peering state for express
	// route circuit peering type.
	AzurePublicPeering ExpressRouteCircuitPeeringType = "AzurePublicPeering"
	// MicrosoftPeering specifies the microsoft peering state for express
	// route circuit peering type.
	MicrosoftPeering ExpressRouteCircuitPeeringType = "MicrosoftPeering"
)

// ExpressRouteCircuitSkuFamily enumerates the values for express route
// circuit sku family.
type ExpressRouteCircuitSkuFamily string

const (
	// MeteredData specifies the metered data state for express route circuit
	// sku family.
	MeteredData ExpressRouteCircuitSkuFamily = "MeteredData"
	// UnlimitedData specifies the unlimited data state for express route
	// circuit sku family.
	UnlimitedData ExpressRouteCircuitSkuFamily = "UnlimitedData"
)

// ExpressRouteCircuitSkuTier enumerates the values for express route circuit
// sku tier.
type ExpressRouteCircuitSkuTier string

const (
	// ExpressRouteCircuitSkuTierPremium specifies the express route circuit
	// sku tier premium state for express route circuit sku tier.
	ExpressRouteCircuitSkuTierPremium ExpressRouteCircuitSkuTier = "Premium"
	// ExpressRouteCircuitSkuTierStandard specifies the express route circuit
	// sku tier standard state for express route circuit sku tier.
	ExpressRouteCircuitSkuTierStandard ExpressRouteCircuitSkuTier = "Standard"
)

// IPAllocationMethod enumerates the values for ip allocation method.
type IPAllocationMethod string

const (
	// Dynamic specifies the dynamic state for ip allocation method.
	Dynamic IPAllocationMethod = "Dynamic"
	// Static specifies the static state for ip allocation method.
	Static IPAllocationMethod = "Static"
)

// IPVersion enumerates the values for ip version.
type IPVersion string

const (
	// IPv4 specifies the i pv 4 state for ip version.
	IPv4 IPVersion = "IPv4"
	// IPv6 specifies the i pv 6 state for ip version.
	IPv6 IPVersion = "IPv6"
)

// LoadDistribution enumerates the values for load distribution.
type LoadDistribution string

const (
	// Default specifies the default state for load distribution.
	Default LoadDistribution = "Default"
	// SourceIP specifies the source ip state for load distribution.
	SourceIP LoadDistribution = "SourceIP"
	// SourceIPProtocol specifies the source ip protocol state for load
	// distribution.
	SourceIPProtocol LoadDistribution = "SourceIPProtocol"
)

// OperationStatus enumerates the values for operation status.
type OperationStatus string

const (
	// Failed specifies the failed state for operation status.
	Failed OperationStatus = "Failed"
	// InProgress specifies the in progress state for operation status.
	InProgress OperationStatus = "InProgress"
	// Succeeded specifies the succeeded state for operation status.
	Succeeded OperationStatus = "Succeeded"
)

// ProbeProtocol enumerates the values for probe protocol.
type ProbeProtocol string

const (
	// ProbeProtocolHTTP specifies the probe protocol http state for probe
	// protocol.
	ProbeProtocolHTTP ProbeProtocol = "Http"
	// ProbeProtocolTCP specifies the probe protocol tcp state for probe
	// protocol.
	ProbeProtocolTCP ProbeProtocol = "Tcp"
)

// ProcessorArchitecture enumerates the values for processor architecture.
type ProcessorArchitecture string

const (
	// Amd64 specifies the amd 64 state for processor architecture.
	Amd64 ProcessorArchitecture = "Amd64"
	// X86 specifies the x86 state for processor architecture.
	X86 ProcessorArchitecture = "X86"
)

// RouteNextHopType enumerates the values for route next hop type.
type RouteNextHopType string

const (
	// RouteNextHopTypeInternet specifies the route next hop type internet
	// state for route next hop type.
	RouteNextHopTypeInternet RouteNextHopType = "Internet"
	// RouteNextHopTypeNone specifies the route next hop type none state for
	// route next hop type.
	RouteNextHopTypeNone RouteNextHopType = "None"
	// RouteNextHopTypeVirtualAppliance specifies the route next hop type
	// virtual appliance state for route next hop type.
	RouteNextHopTypeVirtualAppliance RouteNextHopType = "VirtualAppliance"
	// RouteNextHopTypeVirtualNetworkGateway specifies the route next hop type
	// virtual network gateway state for route next hop type.
	RouteNextHopTypeVirtualNetworkGateway RouteNextHopType = "VirtualNetworkGateway"
	// RouteNextHopTypeVnetLocal specifies the route next hop type vnet local
	// state for route next hop type.
	RouteNextHopTypeVnetLocal RouteNextHopType = "VnetLocal"
)

// SecurityRuleAccess enumerates the values for security rule access.
type SecurityRuleAccess string

const (
	// Allow specifies the allow state for security rule access.
	Allow SecurityRuleAccess = "Allow"
	// Deny specifies the deny state for security rule access.
	Deny SecurityRuleAccess = "Deny"
)

// SecurityRuleDirection enumerates the values for security rule direction.
type SecurityRuleDirection string

const (
	// Inbound specifies the inbound state for security rule direction.
	Inbound SecurityRuleDirection = "Inbound"
	// Outbound specifies the outbound state for security rule direction.
	Outbound SecurityRuleDirection = "Outbound"
)

// SecurityRuleProtocol enumerates the values for security rule protocol.
type SecurityRuleProtocol string

const (
	// Asterisk specifies the asterisk state for security rule protocol.
	Asterisk SecurityRuleProtocol = "*"
	// TCP specifies the tcp state for security rule protocol.
	TCP SecurityRuleProtocol = "Tcp"
	// UDP specifies the udp state for security rule protocol.
	UDP SecurityRuleProtocol = "Udp"
)

// ServiceProviderProvisioningState enumerates the values for service provider
// provisioning state.
type ServiceProviderProvisioningState string

const (
	// Deprovisioning specifies the deprovisioning state for service provider
	// provisioning state.
	Deprovisioning ServiceProviderProvisioningState = "Deprovisioning"
	// NotProvisioned specifies the not provisioned state for service provider
	// provisioning state.
	NotProvisioned ServiceProviderProvisioningState = "NotProvisioned"
	// Provisioned specifies the provisioned state for service provider
	// provisioning state.
	Provisioned ServiceProviderProvisioningState = "Provisioned"
	// Provisioning specifies the provisioning state for service provider
	// provisioning state.
	Provisioning ServiceProviderProvisioningState = "Provisioning"
)

// TransportProtocol enumerates the values for transport protocol.
type TransportProtocol string

const (
	// TransportProtocolTCP specifies the transport protocol tcp state for
	// transport protocol.
	TransportProtocolTCP TransportProtocol = "Tcp"
	// TransportProtocolUDP specifies the transport protocol udp state for
	// transport protocol.
	TransportProtocolUDP TransportProtocol = "Udp"
)

// VirtualNetworkGatewayConnectionStatus enumerates the values for virtual
// network gateway connection status.
type VirtualNetworkGatewayConnectionStatus string

const (
	// Connected specifies the connected state for virtual network gateway
	// connection status.
	Connected VirtualNetworkGatewayConnectionStatus = "Connected"
	// Connecting specifies the connecting state for virtual network gateway
	// connection status.
	Connecting VirtualNetworkGatewayConnectionStatus = "Connecting"
	// NotConnected specifies the not connected state for virtual network
	// gateway connection status.
	NotConnected VirtualNetworkGatewayConnectionStatus = "NotConnected"
	// Unknown specifies the unknown state for virtual network gateway
	// connection status.
	Unknown VirtualNetworkGatewayConnectionStatus = "Unknown"
)

// VirtualNetworkGatewayConnectionType enumerates the values for virtual
// network gateway connection type.
type VirtualNetworkGatewayConnectionType string

const (
	// ExpressRoute specifies the express route state for virtual network
	// gateway connection type.
	ExpressRoute VirtualNetworkGatewayConnectionType = "ExpressRoute"
	// IPsec specifies the i psec state for virtual network gateway connection
	// type.
	IPsec VirtualNetworkGatewayConnectionType = "IPsec"
	// Vnet2Vnet specifies the vnet 2 vnet state for virtual network gateway
	// connection type.
	Vnet2Vnet VirtualNetworkGatewayConnectionType = "Vnet2Vnet"
	// VPNClient specifies the vpn client state for virtual network gateway
	// connection type.
	VPNClient VirtualNetworkGatewayConnectionType = "VPNClient"
)

// VirtualNetworkGatewaySkuName enumerates the values for virtual network
// gateway sku name.
type VirtualNetworkGatewaySkuName string

const (
	// VirtualNetworkGatewaySkuNameBasic specifies the virtual network gateway
	// sku name basic state for virtual network gateway sku name.
	VirtualNetworkGatewaySkuNameBasic VirtualNetworkGatewaySkuName = "Basic"
	// VirtualNetworkGatewaySkuNameHighPerformance specifies the virtual
	// network gateway sku name high performance state for virtual network
	// gateway sku name.
	VirtualNetworkGatewaySkuNameHighPerformance VirtualNetworkGatewaySkuName = "HighPerformance"
	// VirtualNetworkGatewaySkuNameStandard specifies the virtual network
	// gateway sku name standard state for virtual network gateway sku name.
	VirtualNetworkGatewaySkuNameStandard VirtualNetworkGatewaySkuName = "Standard"
)

// VirtualNetworkGatewaySkuTier enumerates the values for virtual network
// gateway sku tier.
type VirtualNetworkGatewaySkuTier string

const (
	// VirtualNetworkGatewaySkuTierBasic specifies the virtual network gateway
	// sku tier basic state for virtual network gateway sku tier.
	VirtualNetworkGatewaySkuTierBasic VirtualNetworkGatewaySkuTier = "Basic"
	// VirtualNetworkGatewaySkuTierHighPerformance specifies the virtual
	// network gateway sku tier high performance state for virtual network
	// gateway sku tier.
	VirtualNetworkGatewaySkuTierHighPerformance VirtualNetworkGatewaySkuTier = "HighPerformance"
	// VirtualNetworkGatewaySkuTierStandard specifies the virtual network
	// gateway sku tier standard state for virtual network gateway sku tier.
	VirtualNetworkGatewaySkuTierStandard VirtualNetworkGatewaySkuTier = "Standard"
)

// VirtualNetworkGatewayType enumerates the values for virtual network gateway
// type.
type VirtualNetworkGatewayType string

const (
	// VirtualNetworkGatewayTypeExpressRoute specifies the virtual network
	// gateway type express route state for virtual network gateway type.
	VirtualNetworkGatewayTypeExpressRoute VirtualNetworkGatewayType = "ExpressRoute"
	// VirtualNetworkGatewayTypeVpn specifies the virtual network gateway type
	// vpn state for virtual network gateway type.
	VirtualNetworkGatewayTypeVpn VirtualNetworkGatewayType = "Vpn"
)

// VirtualNetworkPeeringState enumerates the values for virtual network
// peering state.
type VirtualNetworkPeeringState string

const (
	// VirtualNetworkPeeringStateConnected specifies the virtual network
	// peering state connected state for virtual network peering state.
	VirtualNetworkPeeringStateConnected VirtualNetworkPeeringState = "Connected"
	// VirtualNetworkPeeringStateDisconnected specifies the virtual network
	// peering state disconnected state for virtual network peering state.
	VirtualNetworkPeeringStateDisconnected VirtualNetworkPeeringState = "Disconnected"
	// VirtualNetworkPeeringStateInitiated specifies the virtual network
	// peering state initiated state for virtual network peering state.
	VirtualNetworkPeeringStateInitiated VirtualNetworkPeeringState = "Initiated"
)

// VpnType enumerates the values for vpn type.
type VpnType string

const (
	// PolicyBased specifies the policy based state for vpn type.
	PolicyBased VpnType = "PolicyBased"
	// RouteBased specifies the route based state for vpn type.
	RouteBased VpnType = "RouteBased"
)

// AddressSpace is addressSpace contains an array of IP address ranges that
// can be used by subnets
type AddressSpace struct {
	AddressPrefixes *[]string `json:"addressPrefixes,omitempty"`
}

// ApplicationGateway is applicationGateways resource
type ApplicationGateway struct {
	autorest.Response `json:"-"`
	ID                *string                             `json:"id,omitempty"`
	Name              *string                             `json:"name,omitempty"`
	Type              *string                             `json:"type,omitempty"`
	Location          *string                             `json:"location,omitempty"`
	Tags              *map[string]*string                 `json:"tags,omitempty"`
	Properties        *ApplicationGatewayPropertiesFormat `json:"properties,omitempty"`
	Etag              *string                             `json:"etag,omitempty"`
}

// ApplicationGatewayAuthenticationCertificate is authentication certificates
// of application gateway
type ApplicationGatewayAuthenticationCertificate struct {
	ID         *string                                                      `json:"id,omitempty"`
	Properties *ApplicationGatewayAuthenticationCertificatePropertiesFormat `json:"properties,omitempty"`
	Name       *string                                                      `json:"name,omitempty"`
	Etag       *string                                                      `json:"etag,omitempty"`
}

// ApplicationGatewayAuthenticationCertificatePropertiesFormat is properties
// of Authentication certificates of application gateway
type ApplicationGatewayAuthenticationCertificatePropertiesFormat struct {
	Data              *string `json:"data,omitempty"`
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// ApplicationGatewayBackendAddress is backend Address of application gateway
type ApplicationGatewayBackendAddress struct {
	Fqdn      *string `json:"fqdn,omitempty"`
	IPAddress *string `json:"ipAddress,omitempty"`
}

// ApplicationGatewayBackendAddressPool is backend Address Pool of application
// gateway
type ApplicationGatewayBackendAddressPool struct {
	ID         *string                                               `json:"id,omitempty"`
	Properties *ApplicationGatewayBackendAddressPoolPropertiesFormat `json:"properties,omitempty"`
	Name       *string                                               `json:"name,omitempty"`
	Etag       *string                                               `json:"etag,omitempty"`
}

// ApplicationGatewayBackendAddressPoolPropertiesFormat is properties of
// Backend Address Pool of application gateway
type ApplicationGatewayBackendAddressPoolPropertiesFormat struct {
	BackendIPConfigurations *[]InterfaceIPConfiguration         `json:"backendIPConfigurations,omitempty"`
	BackendAddresses        *[]ApplicationGatewayBackendAddress `json:"backendAddresses,omitempty"`
	ProvisioningState       *string                             `json:"provisioningState,omitempty"`
}

// ApplicationGatewayBackendHTTPSettings is backend address pool settings of
// application gateway
type ApplicationGatewayBackendHTTPSettings struct {
	ID         *string                                                `json:"id,omitempty"`
	Properties *ApplicationGatewayBackendHTTPSettingsPropertiesFormat `json:"properties,omitempty"`
	Name       *string                                                `json:"name,omitempty"`
	Etag       *string                                                `json:"etag,omitempty"`
}

// ApplicationGatewayBackendHTTPSettingsPropertiesFormat is properties of
// Backend address pool settings of application gateway
type ApplicationGatewayBackendHTTPSettingsPropertiesFormat struct {
	Port                       *int32                                `json:"port,omitempty"`
	Protocol                   ApplicationGatewayProtocol            `json:"protocol,omitempty"`
	CookieBasedAffinity        ApplicationGatewayCookieBasedAffinity `json:"cookieBasedAffinity,omitempty"`
	RequestTimeout             *int32                                `json:"requestTimeout,omitempty"`
	Probe                      *SubResource                          `json:"probe,omitempty"`
	AuthenticationCertificates *[]SubResource                        `json:"authenticationCertificates,omitempty"`
	ProvisioningState          *string                               `json:"provisioningState,omitempty"`
}

// ApplicationGatewayFrontendIPConfiguration is frontend IP configuration of
// application gateway
type ApplicationGatewayFrontendIPConfiguration struct {
	ID         *string                                                    `json:"id,omitempty"`
	Properties *ApplicationGatewayFrontendIPConfigurationPropertiesFormat `json:"properties,omitempty"`
	Name       *string                                                    `json:"name,omitempty"`
	Etag       *string                                                    `json:"etag,omitempty"`
}

// ApplicationGatewayFrontendIPConfigurationPropertiesFormat is properties of
// Frontend IP configuration of application gateway
type ApplicationGatewayFrontendIPConfigurationPropertiesFormat struct {
	PrivateIPAddress          *string            `json:"privateIPAddress,omitempty"`
	PrivateIPAllocationMethod IPAllocationMethod `json:"privateIPAllocationMethod,omitempty"`
	Subnet                    *SubResource       `json:"subnet,omitempty"`
	PublicIPAddress           *SubResource       `json:"publicIPAddress,omitempty"`
	ProvisioningState         *string            `json:"provisioningState,omitempty"`
}

// ApplicationGatewayFrontendPort is frontend Port of application gateway
type ApplicationGatewayFrontendPort struct {
	ID         *string                                         `json:"id,omitempty"`
	Properties *ApplicationGatewayFrontendPortPropertiesFormat `json:"properties,omitempty"`
	Name       *string                                         `json:"name,omitempty"`
	Etag       *string                                         `json:"etag,omitempty"`
}

// ApplicationGatewayFrontendPortPropertiesFormat is properties of Frontend
// Port of application gateway
type ApplicationGatewayFrontendPortPropertiesFormat struct {
	Port              *int32  `json:"port,omitempty"`
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// ApplicationGatewayHTTPListener is http listener of application gateway
type ApplicationGatewayHTTPListener struct {
	ID         *string                                         `json:"id,omitempty"`
	Properties *ApplicationGatewayHTTPListenerPropertiesFormat `json:"properties,omitempty"`
	Name       *string                                         `json:"name,omitempty"`
	Etag       *string                                         `json:"etag,omitempty"`
}

// ApplicationGatewayHTTPListenerPropertiesFormat is properties of Http
// listener of application gateway
type ApplicationGatewayHTTPListenerPropertiesFormat struct {
	FrontendIPConfiguration     *SubResource               `json:"frontendIPConfiguration,omitempty"`
	FrontendPort                *SubResource               `json:"frontendPort,omitempty"`
	Protocol                    ApplicationGatewayProtocol `json:"protocol,omitempty"`
	HostName                    *string                    `json:"hostName,omitempty"`
	SslCertificate              *SubResource               `json:"sslCertificate,omitempty"`
	RequireServerNameIndication *bool                      `json:"requireServerNameIndication,omitempty"`
	ProvisioningState           *string                    `json:"provisioningState,omitempty"`
}

// ApplicationGatewayIPConfiguration is iP configuration of application gateway
type ApplicationGatewayIPConfiguration struct {
	ID         *string                                            `json:"id,omitempty"`
	Properties *ApplicationGatewayIPConfigurationPropertiesFormat `json:"properties,omitempty"`
	Name       *string                                            `json:"name,omitempty"`
	Etag       *string                                            `json:"etag,omitempty"`
}

// ApplicationGatewayIPConfigurationPropertiesFormat is properties of IP
// configuration of application gateway
type ApplicationGatewayIPConfigurationPropertiesFormat struct {
	Subnet            *SubResource `json:"subnet,omitempty"`
	ProvisioningState *string      `json:"provisioningState,omitempty"`
}

// ApplicationGatewayListResult is response for ListApplicationGateways Api
// service call
type ApplicationGatewayListResult struct {
	autorest.Response `json:"-"`
	Value             *[]ApplicationGateway `json:"value,omitempty"`
	NextLink          *string               `json:"nextLink,omitempty"`
}

// ApplicationGatewayListResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client ApplicationGatewayListResult) ApplicationGatewayListResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// ApplicationGatewayPathRule is path rule of URL path map of application
// gateway
type ApplicationGatewayPathRule struct {
	ID         *string                                     `json:"id,omitempty"`
	Properties *ApplicationGatewayPathRulePropertiesFormat `json:"properties,omitempty"`
	Name       *string                                     `json:"name,omitempty"`
	Etag       *string                                     `json:"etag,omitempty"`
}

// ApplicationGatewayPathRulePropertiesFormat is properties of probe of
// application gateway
type ApplicationGatewayPathRulePropertiesFormat struct {
	Paths               *[]string    `json:"paths,omitempty"`
	BackendAddressPool  *SubResource `json:"backendAddressPool,omitempty"`
	BackendHTTPSettings *SubResource `json:"backendHttpSettings,omitempty"`
	ProvisioningState   *string      `json:"provisioningState,omitempty"`
}

// ApplicationGatewayProbe is probe of application gateway
type ApplicationGatewayProbe struct {
	ID         *string                                  `json:"id,omitempty"`
	Properties *ApplicationGatewayProbePropertiesFormat `json:"properties,omitempty"`
	Name       *string                                  `json:"name,omitempty"`
	Etag       *string                                  `json:"etag,omitempty"`
}

// ApplicationGatewayProbePropertiesFormat is properties of probe of
// application gateway
type ApplicationGatewayProbePropertiesFormat struct {
	Protocol           ApplicationGatewayProtocol `json:"protocol,omitempty"`
	Host               *string                    `json:"host,omitempty"`
	Path               *string                    `json:"path,omitempty"`
	Interval           *int32                     `json:"interval,omitempty"`
	Timeout            *int32                     `json:"timeout,omitempty"`
	UnhealthyThreshold *int32                     `json:"unhealthyThreshold,omitempty"`
	ProvisioningState  *string                    `json:"provisioningState,omitempty"`
}

// ApplicationGatewayPropertiesFormat is properties of Application Gateway
type ApplicationGatewayPropertiesFormat struct {
	Sku                           *ApplicationGatewaySku                         `json:"sku,omitempty"`
	SslPolicy                     *ApplicationGatewaySslPolicy                   `json:"sslPolicy,omitempty"`
	OperationalState              ApplicationGatewayOperationalState             `json:"operationalState,omitempty"`
	GatewayIPConfigurations       *[]ApplicationGatewayIPConfiguration           `json:"gatewayIPConfigurations,omitempty"`
	AuthenticationCertificates    *[]ApplicationGatewayAuthenticationCertificate `json:"authenticationCertificates,omitempty"`
	SslCertificates               *[]ApplicationGatewaySslCertificate            `json:"sslCertificates,omitempty"`
	FrontendIPConfigurations      *[]ApplicationGatewayFrontendIPConfiguration   `json:"frontendIPConfigurations,omitempty"`
	FrontendPorts                 *[]ApplicationGatewayFrontendPort              `json:"frontendPorts,omitempty"`
	Probes                        *[]ApplicationGatewayProbe                     `json:"probes,omitempty"`
	BackendAddressPools           *[]ApplicationGatewayBackendAddressPool        `json:"backendAddressPools,omitempty"`
	BackendHTTPSettingsCollection *[]ApplicationGatewayBackendHTTPSettings       `json:"backendHttpSettingsCollection,omitempty"`
	HTTPListeners                 *[]ApplicationGatewayHTTPListener              `json:"httpListeners,omitempty"`
	URLPathMaps                   *[]ApplicationGatewayURLPathMap                `json:"urlPathMaps,omitempty"`
	RequestRoutingRules           *[]ApplicationGatewayRequestRoutingRule        `json:"requestRoutingRules,omitempty"`
	ResourceGUID                  *string                                        `json:"resourceGuid,omitempty"`
	ProvisioningState             *string                                        `json:"provisioningState,omitempty"`
}

// ApplicationGatewayRequestRoutingRule is request routing rule of application
// gateway
type ApplicationGatewayRequestRoutingRule struct {
	ID         *string                                               `json:"id,omitempty"`
	Properties *ApplicationGatewayRequestRoutingRulePropertiesFormat `json:"properties,omitempty"`
	Name       *string                                               `json:"name,omitempty"`
	Etag       *string                                               `json:"etag,omitempty"`
}

// ApplicationGatewayRequestRoutingRulePropertiesFormat is properties of
// Request routing rule of application gateway
type ApplicationGatewayRequestRoutingRulePropertiesFormat struct {
	RuleType            ApplicationGatewayRequestRoutingRuleType `json:"ruleType,omitempty"`
	BackendAddressPool  *SubResource                             `json:"backendAddressPool,omitempty"`
	BackendHTTPSettings *SubResource                             `json:"backendHttpSettings,omitempty"`
	HTTPListener        *SubResource                             `json:"httpListener,omitempty"`
	URLPathMap          *SubResource                             `json:"urlPathMap,omitempty"`
	ProvisioningState   *string                                  `json:"provisioningState,omitempty"`
}

// ApplicationGatewaySku is sKU of application gateway
type ApplicationGatewaySku struct {
	Name     ApplicationGatewaySkuName `json:"name,omitempty"`
	Tier     ApplicationGatewayTier    `json:"tier,omitempty"`
	Capacity *int32                    `json:"capacity,omitempty"`
}

// ApplicationGatewaySslCertificate is sSL certificates of application gateway
type ApplicationGatewaySslCertificate struct {
	ID         *string                                           `json:"id,omitempty"`
	Properties *ApplicationGatewaySslCertificatePropertiesFormat `json:"properties,omitempty"`
	Name       *string                                           `json:"name,omitempty"`
	Etag       *string                                           `json:"etag,omitempty"`
}

// ApplicationGatewaySslCertificatePropertiesFormat is properties of SSL
// certificates of application gateway
type ApplicationGatewaySslCertificatePropertiesFormat struct {
	Data              *string `json:"data,omitempty"`
	Password          *string `json:"password,omitempty"`
	PublicCertData    *string `json:"publicCertData,omitempty"`
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// ApplicationGatewaySslPolicy is application gateway SSL policy
type ApplicationGatewaySslPolicy struct {
	DisabledSslProtocols *[]ApplicationGatewaySslProtocol `json:"disabledSslProtocols,omitempty"`
}

// ApplicationGatewayURLPathMap is urlPathMap of application gateway
type ApplicationGatewayURLPathMap struct {
	ID         *string                                       `json:"id,omitempty"`
	Properties *ApplicationGatewayURLPathMapPropertiesFormat `json:"properties,omitempty"`
	Name       *string                                       `json:"name,omitempty"`
	Etag       *string                                       `json:"etag,omitempty"`
}

// ApplicationGatewayURLPathMapPropertiesFormat is properties of UrlPathMap of
// application gateway
type ApplicationGatewayURLPathMapPropertiesFormat struct {
	DefaultBackendAddressPool  *SubResource                  `json:"defaultBackendAddressPool,omitempty"`
	DefaultBackendHTTPSettings *SubResource                  `json:"defaultBackendHttpSettings,omitempty"`
	PathRules                  *[]ApplicationGatewayPathRule `json:"pathRules,omitempty"`
	ProvisioningState          *string                       `json:"provisioningState,omitempty"`
}

// AuthorizationListResult is response for ListAuthorizations Api service
// callRetrieves all authorizations that belongs to an ExpressRouteCircuit
type AuthorizationListResult struct {
	autorest.Response `json:"-"`
	Value             *[]ExpressRouteCircuitAuthorization `json:"value,omitempty"`
	NextLink          *string                             `json:"nextLink,omitempty"`
}

// AuthorizationListResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client AuthorizationListResult) AuthorizationListResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// AuthorizationPropertiesFormat is
type AuthorizationPropertiesFormat struct {
	AuthorizationKey       *string                `json:"authorizationKey,omitempty"`
	AuthorizationUseStatus AuthorizationUseStatus `json:"authorizationUseStatus,omitempty"`
	ProvisioningState      *string                `json:"provisioningState,omitempty"`
}

// AzureAsyncOperationResult is the response body contains the status of the
// specified asynchronous operation, indicating whether it has succeeded, is
// inprogress, or has failed. Note that this status is distinct from the HTTP
// status code returned for the Get Operation Status operation itself. If the
// asynchronous operation succeeded, the response body includes the HTTP
// status code for the successful request. If the asynchronous operation
// failed, the response body includes the HTTP status code for the failed
// request and error information regarding the failure.
type AzureAsyncOperationResult struct {
	Status OperationStatus `json:"status,omitempty"`
	Error  *Error          `json:"error,omitempty"`
}

// BackendAddressPool is pool of backend IP addresseses
type BackendAddressPool struct {
	ID         *string                             `json:"id,omitempty"`
	Properties *BackendAddressPoolPropertiesFormat `json:"properties,omitempty"`
	Name       *string                             `json:"name,omitempty"`
	Etag       *string                             `json:"etag,omitempty"`
}

// BackendAddressPoolPropertiesFormat is properties of BackendAddressPool
type BackendAddressPoolPropertiesFormat struct {
	BackendIPConfigurations *[]InterfaceIPConfiguration `json:"backendIPConfigurations,omitempty"`
	LoadBalancingRules      *[]SubResource              `json:"loadBalancingRules,omitempty"`
	OutboundNatRule         *SubResource                `json:"outboundNatRule,omitempty"`
	ProvisioningState       *string                     `json:"provisioningState,omitempty"`
}

// BgpSettings is
type BgpSettings struct {
	Asn               *int64  `json:"asn,omitempty"`
	BgpPeeringAddress *string `json:"bgpPeeringAddress,omitempty"`
	PeerWeight        *int32  `json:"peerWeight,omitempty"`
}

// ConnectionResetSharedKey is
type ConnectionResetSharedKey struct {
	autorest.Response `json:"-"`
	KeyLength         *int64 `json:"keyLength,omitempty"`
}

// ConnectionSharedKey is response for GetConnectionSharedKey Api servive call
type ConnectionSharedKey struct {
	autorest.Response `json:"-"`
	Value             *string `json:"value,omitempty"`
}

// ConnectionSharedKeyResult is response for CheckConnectionSharedKey Api
// servive call
type ConnectionSharedKeyResult struct {
	autorest.Response `json:"-"`
	Value             *string `json:"value,omitempty"`
}

// DhcpOptions is dHCPOptions contains an array of DNS servers available to
// VMs deployed in the virtual networkStandard DHCP option for a subnet
// overrides VNET DHCP options.
type DhcpOptions struct {
	DNSServers *[]string `json:"dnsServers,omitempty"`
}

// DNSNameAvailabilityResult is response for CheckDnsNameAvailability Api
// servive call
type DNSNameAvailabilityResult struct {
	autorest.Response `json:"-"`
	Available         *bool `json:"available,omitempty"`
}

// EffectiveNetworkSecurityGroup is effective NetworkSecurityGroup
type EffectiveNetworkSecurityGroup struct {
	NetworkSecurityGroup   *SubResource                              `json:"networkSecurityGroup,omitempty"`
	Association            *EffectiveNetworkSecurityGroupAssociation `json:"association,omitempty"`
	EffectiveSecurityRules *[]EffectiveNetworkSecurityRule           `json:"effectiveSecurityRules,omitempty"`
}

// EffectiveNetworkSecurityGroupAssociation is effective NetworkSecurityGroup
// association
type EffectiveNetworkSecurityGroupAssociation struct {
	Subnet           *SubResource `json:"subnet,omitempty"`
	NetworkInterface *SubResource `json:"networkInterface,omitempty"`
}

// EffectiveNetworkSecurityGroupListResult is response for list effective
// network security groups api servive call
type EffectiveNetworkSecurityGroupListResult struct {
	autorest.Response `json:"-"`
	Value             *[]EffectiveNetworkSecurityGroup `json:"value,omitempty"`
	NextLink          *string                          `json:"nextLink,omitempty"`
}

// EffectiveNetworkSecurityRule is effective NetworkSecurityRules
type EffectiveNetworkSecurityRule struct {
	Name                             *string               `json:"name,omitempty"`
	Protocol                         SecurityRuleProtocol  `json:"protocol,omitempty"`
	SourcePortRange                  *string               `json:"sourcePortRange,omitempty"`
	DestinationPortRange             *string               `json:"destinationPortRange,omitempty"`
	SourceAddressPrefix              *string               `json:"sourceAddressPrefix,omitempty"`
	DestinationAddressPrefix         *string               `json:"destinationAddressPrefix,omitempty"`
	ExpandedSourceAddressPrefix      *[]string             `json:"expandedSourceAddressPrefix,omitempty"`
	ExpandedDestinationAddressPrefix *[]string             `json:"expandedDestinationAddressPrefix,omitempty"`
	Access                           SecurityRuleAccess    `json:"access,omitempty"`
	Priority                         *int32                `json:"priority,omitempty"`
	Direction                        SecurityRuleDirection `json:"direction,omitempty"`
}

// EffectiveRoute is effective Route
type EffectiveRoute struct {
	Name             *string              `json:"name,omitempty"`
	Source           EffectiveRouteSource `json:"source,omitempty"`
	State            EffectiveRouteState  `json:"state,omitempty"`
	AddressPrefix    *[]string            `json:"addressPrefix,omitempty"`
	NextHopIPAddress *[]string            `json:"nextHopIpAddress,omitempty"`
	NextHopType      RouteNextHopType     `json:"nextHopType,omitempty"`
}

// EffectiveRouteListResult is response for list effective route api servive
// call
type EffectiveRouteListResult struct {
	autorest.Response `json:"-"`
	Value             *[]EffectiveRoute `json:"value,omitempty"`
	NextLink          *string           `json:"nextLink,omitempty"`
}

// Error is
type Error struct {
	Code       *string         `json:"code,omitempty"`
	Message    *string         `json:"message,omitempty"`
	Target     *string         `json:"target,omitempty"`
	Details    *[]ErrorDetails `json:"details,omitempty"`
	InnerError *string         `json:"innerError,omitempty"`
}

// ErrorDetails is
type ErrorDetails struct {
	Code    *string `json:"code,omitempty"`
	Target  *string `json:"target,omitempty"`
	Message *string `json:"message,omitempty"`
}

// ExpressRouteCircuit is expressRouteCircuit resource
type ExpressRouteCircuit struct {
	autorest.Response `json:"-"`
	ID                *string                              `json:"id,omitempty"`
	Name              *string                              `json:"name,omitempty"`
	Type              *string                              `json:"type,omitempty"`
	Location          *string                              `json:"location,omitempty"`
	Tags              *map[string]*string                  `json:"tags,omitempty"`
	Sku               *ExpressRouteCircuitSku              `json:"sku,omitempty"`
	Properties        *ExpressRouteCircuitPropertiesFormat `json:"properties,omitempty"`
	Etag              *string                              `json:"etag,omitempty"`
}

// ExpressRouteCircuitArpTable is the arp table associated with the
// ExpressRouteCircuit
type ExpressRouteCircuitArpTable struct {
	Age        *int32  `json:"age,omitempty"`
	Interface  *string `json:"interface,omitempty"`
	IPAddress  *string `json:"ipAddress,omitempty"`
	MacAddress *string `json:"macAddress,omitempty"`
}

// ExpressRouteCircuitAuthorization is authorization in a ExpressRouteCircuit
// resource
type ExpressRouteCircuitAuthorization struct {
	autorest.Response `json:"-"`
	ID                *string                        `json:"id,omitempty"`
	Properties        *AuthorizationPropertiesFormat `json:"properties,omitempty"`
	Name              *string                        `json:"name,omitempty"`
	Etag              *string                        `json:"etag,omitempty"`
}

// ExpressRouteCircuitListResult is response for ListExpressRouteCircuit Api
// service call
type ExpressRouteCircuitListResult struct {
	autorest.Response `json:"-"`
	Value             *[]ExpressRouteCircuit `json:"value,omitempty"`
	NextLink          *string                `json:"nextLink,omitempty"`
}

// ExpressRouteCircuitListResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client ExpressRouteCircuitListResult) ExpressRouteCircuitListResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// ExpressRouteCircuitPeering is peering in a ExpressRouteCircuit resource
type ExpressRouteCircuitPeering struct {
	autorest.Response `json:"-"`
	ID                *string                                     `json:"id,omitempty"`
	Properties        *ExpressRouteCircuitPeeringPropertiesFormat `json:"properties,omitempty"`
	Name              *string                                     `json:"name,omitempty"`
	Etag              *string                                     `json:"etag,omitempty"`
}

// ExpressRouteCircuitPeeringConfig is specfies the peering config
type ExpressRouteCircuitPeeringConfig struct {
	AdvertisedPublicPrefixes      *[]string                                             `json:"advertisedPublicPrefixes,omitempty"`
	AdvertisedPublicPrefixesState ExpressRouteCircuitPeeringAdvertisedPublicPrefixState `json:"advertisedPublicPrefixesState,omitempty"`
	CustomerASN                   *int32                                                `json:"customerASN,omitempty"`
	RoutingRegistryName           *string                                               `json:"routingRegistryName,omitempty"`
}

// ExpressRouteCircuitPeeringListResult is response for ListPeering Api
// service callRetrieves all Peerings that belongs to an ExpressRouteCircuit
type ExpressRouteCircuitPeeringListResult struct {
	autorest.Response `json:"-"`
	Value             *[]ExpressRouteCircuitPeering `json:"value,omitempty"`
	NextLink          *string                       `json:"nextLink,omitempty"`
}

// ExpressRouteCircuitPeeringListResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client ExpressRouteCircuitPeeringListResult) ExpressRouteCircuitPeeringListResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// ExpressRouteCircuitPeeringPropertiesFormat is
type ExpressRouteCircuitPeeringPropertiesFormat struct {
	PeeringType                ExpressRouteCircuitPeeringType    `json:"peeringType,omitempty"`
	State                      ExpressRouteCircuitPeeringState   `json:"state,omitempty"`
	AzureASN                   *int32                            `json:"azureASN,omitempty"`
	PeerASN                    *int32                            `json:"peerASN,omitempty"`
	PrimaryPeerAddressPrefix   *string                           `json:"primaryPeerAddressPrefix,omitempty"`
	SecondaryPeerAddressPrefix *string                           `json:"secondaryPeerAddressPrefix,omitempty"`
	PrimaryAzurePort           *string                           `json:"primaryAzurePort,omitempty"`
	SecondaryAzurePort         *string                           `json:"secondaryAzurePort,omitempty"`
	SharedKey                  *string                           `json:"sharedKey,omitempty"`
	VlanID                     *int32                            `json:"vlanId,omitempty"`
	MicrosoftPeeringConfig     *ExpressRouteCircuitPeeringConfig `json:"microsoftPeeringConfig,omitempty"`
	Stats                      *ExpressRouteCircuitStats         `json:"stats,omitempty"`
	ProvisioningState          *string                           `json:"provisioningState,omitempty"`
	GatewayManagerEtag         *string                           `json:"gatewayManagerEtag,omitempty"`
	LastModifiedBy             *string                           `json:"lastModifiedBy,omitempty"`
}

// ExpressRouteCircuitPropertiesFormat is properties of ExpressRouteCircuit
type ExpressRouteCircuitPropertiesFormat struct {
	AllowClassicOperations           *bool                                         `json:"allowClassicOperations,omitempty"`
	CircuitProvisioningState         *string                                       `json:"circuitProvisioningState,omitempty"`
	ServiceProviderProvisioningState ServiceProviderProvisioningState              `json:"serviceProviderProvisioningState,omitempty"`
	Authorizations                   *[]ExpressRouteCircuitAuthorization           `json:"authorizations,omitempty"`
	Peerings                         *[]ExpressRouteCircuitPeering                 `json:"peerings,omitempty"`
	ServiceKey                       *string                                       `json:"serviceKey,omitempty"`
	ServiceProviderNotes             *string                                       `json:"serviceProviderNotes,omitempty"`
	ServiceProviderProperties        *ExpressRouteCircuitServiceProviderProperties `json:"serviceProviderProperties,omitempty"`
	ProvisioningState                *string                                       `json:"provisioningState,omitempty"`
	GatewayManagerEtag               *string                                       `json:"gatewayManagerEtag,omitempty"`
}

// ExpressRouteCircuitRoutesTable is the routes table associated with the
// ExpressRouteCircuit
type ExpressRouteCircuitRoutesTable struct {
	Network *string `json:"network,omitempty"`
	NextHop *string `json:"nextHop,omitempty"`
	LocPrf  *string `json:"locPrf,omitempty"`
	Weight  *int32  `json:"weight,omitempty"`
	Path    *string `json:"path,omitempty"`
}

// ExpressRouteCircuitRoutesTableSummary is the routes table associated with
// the ExpressRouteCircuit
type ExpressRouteCircuitRoutesTableSummary struct {
	Neighbor    *string `json:"neighbor,omitempty"`
	V           *int32  `json:"v,omitempty"`
	As          *int32  `json:"as,omitempty"`
	UpDown      *string `json:"upDown,omitempty"`
	StatePfxRcd *string `json:"statePfxRcd,omitempty"`
}

// ExpressRouteCircuitsArpTableListResult is response for ListArpTable
// associated with the Express Route Circuits Api
type ExpressRouteCircuitsArpTableListResult struct {
	autorest.Response `json:"-"`
	Value             *[]ExpressRouteCircuitArpTable `json:"value,omitempty"`
	NextLink          *string                        `json:"nextLink,omitempty"`
}

// ExpressRouteCircuitServiceProviderProperties is contains
// ServiceProviderProperties in an ExpressRouteCircuit
type ExpressRouteCircuitServiceProviderProperties struct {
	ServiceProviderName *string `json:"serviceProviderName,omitempty"`
	PeeringLocation     *string `json:"peeringLocation,omitempty"`
	BandwidthInMbps     *int32  `json:"bandwidthInMbps,omitempty"`
}

// ExpressRouteCircuitSku is contains sku in an ExpressRouteCircuit
type ExpressRouteCircuitSku struct {
	Name   *string                      `json:"name,omitempty"`
	Tier   ExpressRouteCircuitSkuTier   `json:"tier,omitempty"`
	Family ExpressRouteCircuitSkuFamily `json:"family,omitempty"`
}

// ExpressRouteCircuitsRoutesTableListResult is response for ListRoutesTable
// associated with the Express Route Circuits Api
type ExpressRouteCircuitsRoutesTableListResult struct {
	autorest.Response `json:"-"`
	Value             *[]ExpressRouteCircuitRoutesTable `json:"value,omitempty"`
	NextLink          *string                           `json:"nextLink,omitempty"`
}

// ExpressRouteCircuitsRoutesTableSummaryListResult is response for
// ListRoutesTable associated with the Express Route Circuits Api
type ExpressRouteCircuitsRoutesTableSummaryListResult struct {
	autorest.Response `json:"-"`
	Value             *[]ExpressRouteCircuitRoutesTableSummary `json:"value,omitempty"`
	NextLink          *string                                  `json:"nextLink,omitempty"`
}

// ExpressRouteCircuitStats is contains Stats associated with the peering
type ExpressRouteCircuitStats struct {
	autorest.Response `json:"-"`
	PrimarybytesIn    *int64 `json:"primarybytesIn,omitempty"`
	PrimarybytesOut   *int64 `json:"primarybytesOut,omitempty"`
	SecondarybytesIn  *int64 `json:"secondarybytesIn,omitempty"`
	SecondarybytesOut *int64 `json:"secondarybytesOut,omitempty"`
}

// ExpressRouteServiceProvider is expressRouteResourceProvider object
type ExpressRouteServiceProvider struct {
	ID         *string                                      `json:"id,omitempty"`
	Name       *string                                      `json:"name,omitempty"`
	Type       *string                                      `json:"type,omitempty"`
	Location   *string                                      `json:"location,omitempty"`
	Tags       *map[string]*string                          `json:"tags,omitempty"`
	Properties *ExpressRouteServiceProviderPropertiesFormat `json:"properties,omitempty"`
}

// ExpressRouteServiceProviderBandwidthsOffered is contains Bandwidths offered
// in ExpressRouteServiceProviders
type ExpressRouteServiceProviderBandwidthsOffered struct {
	OfferName   *string `json:"offerName,omitempty"`
	ValueInMbps *int32  `json:"valueInMbps,omitempty"`
}

// ExpressRouteServiceProviderListResult is response for
// ListExpressRouteServiceProvider Api service call
type ExpressRouteServiceProviderListResult struct {
	autorest.Response `json:"-"`
	Value             *[]ExpressRouteServiceProvider `json:"value,omitempty"`
	NextLink          *string                        `json:"nextLink,omitempty"`
}

// ExpressRouteServiceProviderListResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client ExpressRouteServiceProviderListResult) ExpressRouteServiceProviderListResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// ExpressRouteServiceProviderPropertiesFormat is properties of
// ExpressRouteServiceProvider
type ExpressRouteServiceProviderPropertiesFormat struct {
	PeeringLocations  *[]string                                       `json:"peeringLocations,omitempty"`
	BandwidthsOffered *[]ExpressRouteServiceProviderBandwidthsOffered `json:"bandwidthsOffered,omitempty"`
	ProvisioningState *string                                         `json:"provisioningState,omitempty"`
}

// FrontendIPConfiguration is frontend IP address of the load balancer
type FrontendIPConfiguration struct {
	ID         *string                                  `json:"id,omitempty"`
	Properties *FrontendIPConfigurationPropertiesFormat `json:"properties,omitempty"`
	Name       *string                                  `json:"name,omitempty"`
	Etag       *string                                  `json:"etag,omitempty"`
}

// FrontendIPConfigurationPropertiesFormat is properties of Frontend IP
// Configuration of the load balancer
type FrontendIPConfigurationPropertiesFormat struct {
	InboundNatRules           *[]SubResource     `json:"inboundNatRules,omitempty"`
	InboundNatPools           *[]SubResource     `json:"inboundNatPools,omitempty"`
	OutboundNatRules          *[]SubResource     `json:"outboundNatRules,omitempty"`
	LoadBalancingRules        *[]SubResource     `json:"loadBalancingRules,omitempty"`
	PrivateIPAddress          *string            `json:"privateIPAddress,omitempty"`
	PrivateIPAllocationMethod IPAllocationMethod `json:"privateIPAllocationMethod,omitempty"`
	Subnet                    *Subnet            `json:"subnet,omitempty"`
	PublicIPAddress           *PublicIPAddress   `json:"publicIPAddress,omitempty"`
	ProvisioningState         *string            `json:"provisioningState,omitempty"`
}

// InboundNatPool is inbound NAT pool of the loadbalancer
type InboundNatPool struct {
	ID         *string                         `json:"id,omitempty"`
	Properties *InboundNatPoolPropertiesFormat `json:"properties,omitempty"`
	Name       *string                         `json:"name,omitempty"`
	Etag       *string                         `json:"etag,omitempty"`
}

// InboundNatPoolPropertiesFormat is properties of Inbound NAT pool
type InboundNatPoolPropertiesFormat struct {
	FrontendIPConfiguration *SubResource      `json:"frontendIPConfiguration,omitempty"`
	Protocol                TransportProtocol `json:"protocol,omitempty"`
	FrontendPortRangeStart  *int32            `json:"frontendPortRangeStart,omitempty"`
	FrontendPortRangeEnd    *int32            `json:"frontendPortRangeEnd,omitempty"`
	BackendPort             *int32            `json:"backendPort,omitempty"`
	ProvisioningState       *string           `json:"provisioningState,omitempty"`
}

// InboundNatRule is inbound NAT rule of the loadbalancer
type InboundNatRule struct {
	ID         *string                         `json:"id,omitempty"`
	Properties *InboundNatRulePropertiesFormat `json:"properties,omitempty"`
	Name       *string                         `json:"name,omitempty"`
	Etag       *string                         `json:"etag,omitempty"`
}

// InboundNatRulePropertiesFormat is properties of Inbound NAT rule
type InboundNatRulePropertiesFormat struct {
	FrontendIPConfiguration *SubResource              `json:"frontendIPConfiguration,omitempty"`
	BackendIPConfiguration  *InterfaceIPConfiguration `json:"backendIPConfiguration,omitempty"`
	Protocol                TransportProtocol         `json:"protocol,omitempty"`
	FrontendPort            *int32                    `json:"frontendPort,omitempty"`
	BackendPort             *int32                    `json:"backendPort,omitempty"`
	IdleTimeoutInMinutes    *int32                    `json:"idleTimeoutInMinutes,omitempty"`
	EnableFloatingIP        *bool                     `json:"enableFloatingIP,omitempty"`
	ProvisioningState       *string                   `json:"provisioningState,omitempty"`
}

// Interface is a NetworkInterface in a resource group
type Interface struct {
	autorest.Response `json:"-"`
	ID                *string                    `json:"id,omitempty"`
	Name              *string                    `json:"name,omitempty"`
	Type              *string                    `json:"type,omitempty"`
	Location          *string                    `json:"location,omitempty"`
	Tags              *map[string]*string        `json:"tags,omitempty"`
	Properties        *InterfacePropertiesFormat `json:"properties,omitempty"`
	Etag              *string                    `json:"etag,omitempty"`
}

// InterfaceDNSSettings is dns settings of a network interface
type InterfaceDNSSettings struct {
	DNSServers               *[]string `json:"dnsServers,omitempty"`
	AppliedDNSServers        *[]string `json:"appliedDnsServers,omitempty"`
	InternalDNSNameLabel     *string   `json:"internalDnsNameLabel,omitempty"`
	InternalFqdn             *string   `json:"internalFqdn,omitempty"`
	InternalDomainNameSuffix *string   `json:"internalDomainNameSuffix,omitempty"`
}

// InterfaceIPConfiguration is iPConfiguration in a NetworkInterface
type InterfaceIPConfiguration struct {
	ID         *string                                   `json:"id,omitempty"`
	Properties *InterfaceIPConfigurationPropertiesFormat `json:"properties,omitempty"`
	Name       *string                                   `json:"name,omitempty"`
	Etag       *string                                   `json:"etag,omitempty"`
}

// InterfaceIPConfigurationPropertiesFormat is properties of IPConfiguration
type InterfaceIPConfigurationPropertiesFormat struct {
	ApplicationGatewayBackendAddressPools *[]ApplicationGatewayBackendAddressPool `json:"applicationGatewayBackendAddressPools,omitempty"`
	LoadBalancerBackendAddressPools       *[]BackendAddressPool                   `json:"loadBalancerBackendAddressPools,omitempty"`
	LoadBalancerInboundNatRules           *[]InboundNatRule                       `json:"loadBalancerInboundNatRules,omitempty"`
	PrivateIPAddress                      *string                                 `json:"privateIPAddress,omitempty"`
	PrivateIPAllocationMethod             IPAllocationMethod                      `json:"privateIPAllocationMethod,omitempty"`
	PrivateIPAddressVersion               IPVersion                               `json:"privateIPAddressVersion,omitempty"`
	Subnet                                *Subnet                                 `json:"subnet,omitempty"`
	Primary                               *bool                                   `json:"primary,omitempty"`
	PublicIPAddress                       *PublicIPAddress                        `json:"publicIPAddress,omitempty"`
	ProvisioningState                     *string                                 `json:"provisioningState,omitempty"`
}

// InterfaceListResult is response for ListNetworkInterface Api service call
type InterfaceListResult struct {
	autorest.Response `json:"-"`
	Value             *[]Interface `json:"value,omitempty"`
	NextLink          *string      `json:"nextLink,omitempty"`
}

// InterfaceListResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client InterfaceListResult) InterfaceListResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// InterfacePropertiesFormat is networkInterface properties.
type InterfacePropertiesFormat struct {
	VirtualMachine       *SubResource                `json:"virtualMachine,omitempty"`
	NetworkSecurityGroup *SecurityGroup              `json:"networkSecurityGroup,omitempty"`
	IPConfigurations     *[]InterfaceIPConfiguration `json:"ipConfigurations,omitempty"`
	DNSSettings          *InterfaceDNSSettings       `json:"dnsSettings,omitempty"`
	MacAddress           *string                     `json:"macAddress,omitempty"`
	Primary              *bool                       `json:"primary,omitempty"`
	EnableIPForwarding   *bool                       `json:"enableIPForwarding,omitempty"`
	ResourceGUID         *string                     `json:"resourceGuid,omitempty"`
	ProvisioningState    *string                     `json:"provisioningState,omitempty"`
}

// IPAddressAvailabilityResult is response for CheckIPAddressAvailability Api
// service call
type IPAddressAvailabilityResult struct {
	autorest.Response    `json:"-"`
	Available            *bool     `json:"available,omitempty"`
	AvailableIPAddresses *[]string `json:"availableIPAddresses,omitempty"`
}

// IPConfiguration is iPConfiguration
type IPConfiguration struct {
	ID         *string                          `json:"id,omitempty"`
	Properties *IPConfigurationPropertiesFormat `json:"properties,omitempty"`
	Name       *string                          `json:"name,omitempty"`
	Etag       *string                          `json:"etag,omitempty"`
}

// IPConfigurationPropertiesFormat is properties of IPConfiguration
type IPConfigurationPropertiesFormat struct {
	PrivateIPAddress          *string            `json:"privateIPAddress,omitempty"`
	PrivateIPAllocationMethod IPAllocationMethod `json:"privateIPAllocationMethod,omitempty"`
	Subnet                    *Subnet            `json:"subnet,omitempty"`
	PublicIPAddress           *PublicIPAddress   `json:"publicIPAddress,omitempty"`
	ProvisioningState         *string            `json:"provisioningState,omitempty"`
}

// LoadBalancer is loadBalancer resource
type LoadBalancer struct {
	autorest.Response `json:"-"`
	ID                *string                       `json:"id,omitempty"`
	Name              *string                       `json:"name,omitempty"`
	Type              *string                       `json:"type,omitempty"`
	Location          *string                       `json:"location,omitempty"`
	Tags              *map[string]*string           `json:"tags,omitempty"`
	Properties        *LoadBalancerPropertiesFormat `json:"properties,omitempty"`
	Etag              *string                       `json:"etag,omitempty"`
}

// LoadBalancerListResult is response for ListLoadBalancers Api service call
type LoadBalancerListResult struct {
	autorest.Response `json:"-"`
	Value             *[]LoadBalancer `json:"value,omitempty"`
	NextLink          *string         `json:"nextLink,omitempty"`
}

// LoadBalancerListResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client LoadBalancerListResult) LoadBalancerListResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// LoadBalancerPropertiesFormat is properties of Load Balancer
type LoadBalancerPropertiesFormat struct {
	FrontendIPConfigurations *[]FrontendIPConfiguration `json:"frontendIPConfigurations,omitempty"`
	BackendAddressPools      *[]BackendAddressPool      `json:"backendAddressPools,omitempty"`
	LoadBalancingRules       *[]LoadBalancingRule       `json:"loadBalancingRules,omitempty"`
	Probes                   *[]Probe                   `json:"probes,omitempty"`
	InboundNatRules          *[]InboundNatRule          `json:"inboundNatRules,omitempty"`
	InboundNatPools          *[]InboundNatPool          `json:"inboundNatPools,omitempty"`
	OutboundNatRules         *[]OutboundNatRule         `json:"outboundNatRules,omitempty"`
	ResourceGUID             *string                    `json:"resourceGuid,omitempty"`
	ProvisioningState        *string                    `json:"provisioningState,omitempty"`
}

// LoadBalancingRule is rules of the load balancer
type LoadBalancingRule struct {
	ID         *string                            `json:"id,omitempty"`
	Properties *LoadBalancingRulePropertiesFormat `json:"properties,omitempty"`
	Name       *string                            `json:"name,omitempty"`
	Etag       *string                            `json:"etag,omitempty"`
}

// LoadBalancingRulePropertiesFormat is properties of the load balancer
type LoadBalancingRulePropertiesFormat struct {
	FrontendIPConfiguration *SubResource      `json:"frontendIPConfiguration,omitempty"`
	BackendAddressPool      *SubResource      `json:"backendAddressPool,omitempty"`
	Probe                   *SubResource      `json:"probe,omitempty"`
	Protocol                TransportProtocol `json:"protocol,omitempty"`
	LoadDistribution        LoadDistribution  `json:"loadDistribution,omitempty"`
	FrontendPort            *int32            `json:"frontendPort,omitempty"`
	BackendPort             *int32            `json:"backendPort,omitempty"`
	IdleTimeoutInMinutes    *int32            `json:"idleTimeoutInMinutes,omitempty"`
	EnableFloatingIP        *bool             `json:"enableFloatingIP,omitempty"`
	ProvisioningState       *string           `json:"provisioningState,omitempty"`
}

// LocalNetworkGateway is a common class for general resource information
type LocalNetworkGateway struct {
	autorest.Response `json:"-"`
	ID                *string                              `json:"id,omitempty"`
	Name              *string                              `json:"name,omitempty"`
	Type              *string                              `json:"type,omitempty"`
	Location          *string                              `json:"location,omitempty"`
	Tags              *map[string]*string                  `json:"tags,omitempty"`
	Properties        *LocalNetworkGatewayPropertiesFormat `json:"properties,omitempty"`
	Etag              *string                              `json:"etag,omitempty"`
}

// LocalNetworkGatewayListResult is response for ListLocalNetworkGateways Api
// service call
type LocalNetworkGatewayListResult struct {
	autorest.Response `json:"-"`
	Value             *[]LocalNetworkGateway `json:"value,omitempty"`
	NextLink          *string                `json:"nextLink,omitempty"`
}

// LocalNetworkGatewayListResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client LocalNetworkGatewayListResult) LocalNetworkGatewayListResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// LocalNetworkGatewayPropertiesFormat is localNetworkGateway properties
type LocalNetworkGatewayPropertiesFormat struct {
	LocalNetworkAddressSpace *AddressSpace `json:"localNetworkAddressSpace,omitempty"`
	GatewayIPAddress         *string       `json:"gatewayIpAddress,omitempty"`
	BgpSettings              *BgpSettings  `json:"bgpSettings,omitempty"`
	ResourceGUID             *string       `json:"resourceGuid,omitempty"`
	ProvisioningState        *string       `json:"provisioningState,omitempty"`
}

// OutboundNatRule is outbound NAT pool of the loadbalancer
type OutboundNatRule struct {
	ID         *string                          `json:"id,omitempty"`
	Properties *OutboundNatRulePropertiesFormat `json:"properties,omitempty"`
	Name       *string                          `json:"name,omitempty"`
	Etag       *string                          `json:"etag,omitempty"`
}

// OutboundNatRulePropertiesFormat is outbound NAT pool of the loadbalancer
type OutboundNatRulePropertiesFormat struct {
	AllocatedOutboundPorts   *int32         `json:"allocatedOutboundPorts,omitempty"`
	FrontendIPConfigurations *[]SubResource `json:"frontendIPConfigurations,omitempty"`
	BackendAddressPool       *SubResource   `json:"backendAddressPool,omitempty"`
	ProvisioningState        *string        `json:"provisioningState,omitempty"`
}

// Probe is load balancer Probe
type Probe struct {
	ID         *string                `json:"id,omitempty"`
	Properties *ProbePropertiesFormat `json:"properties,omitempty"`
	Name       *string                `json:"name,omitempty"`
	Etag       *string                `json:"etag,omitempty"`
}

// ProbePropertiesFormat is
type ProbePropertiesFormat struct {
	LoadBalancingRules *[]SubResource `json:"loadBalancingRules,omitempty"`
	Protocol           ProbeProtocol  `json:"protocol,omitempty"`
	Port               *int32         `json:"port,omitempty"`
	IntervalInSeconds  *int32         `json:"intervalInSeconds,omitempty"`
	NumberOfProbes     *int32         `json:"numberOfProbes,omitempty"`
	RequestPath        *string        `json:"requestPath,omitempty"`
	ProvisioningState  *string        `json:"provisioningState,omitempty"`
}

// PublicIPAddress is publicIPAddress resource
type PublicIPAddress struct {
	autorest.Response `json:"-"`
	ID                *string                          `json:"id,omitempty"`
	Name              *string                          `json:"name,omitempty"`
	Type              *string                          `json:"type,omitempty"`
	Location          *string                          `json:"location,omitempty"`
	Tags              *map[string]*string              `json:"tags,omitempty"`
	Properties        *PublicIPAddressPropertiesFormat `json:"properties,omitempty"`
	Etag              *string                          `json:"etag,omitempty"`
}

// PublicIPAddressDNSSettings is contains FQDN of the DNS record associated
// with the public IP address
type PublicIPAddressDNSSettings struct {
	DomainNameLabel *string `json:"domainNameLabel,omitempty"`
	Fqdn            *string `json:"fqdn,omitempty"`
	ReverseFqdn     *string `json:"reverseFqdn,omitempty"`
}

// PublicIPAddressListResult is response for ListPublicIpAddresses Api service
// call
type PublicIPAddressListResult struct {
	autorest.Response `json:"-"`
	Value             *[]PublicIPAddress `json:"value,omitempty"`
	NextLink          *string            `json:"nextLink,omitempty"`
}

// PublicIPAddressListResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client PublicIPAddressListResult) PublicIPAddressListResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// PublicIPAddressPropertiesFormat is publicIpAddress properties
type PublicIPAddressPropertiesFormat struct {
	PublicIPAllocationMethod IPAllocationMethod          `json:"publicIPAllocationMethod,omitempty"`
	PublicIPAddressVersion   IPVersion                   `json:"publicIPAddressVersion,omitempty"`
	IPConfiguration          *IPConfiguration            `json:"ipConfiguration,omitempty"`
	DNSSettings              *PublicIPAddressDNSSettings `json:"dnsSettings,omitempty"`
	IPAddress                *string                     `json:"ipAddress,omitempty"`
	IdleTimeoutInMinutes     *int32                      `json:"idleTimeoutInMinutes,omitempty"`
	ResourceGUID             *string                     `json:"resourceGuid,omitempty"`
	ProvisioningState        *string                     `json:"provisioningState,omitempty"`
}

// Resource is
type Resource struct {
	ID       *string             `json:"id,omitempty"`
	Name     *string             `json:"name,omitempty"`
	Type     *string             `json:"type,omitempty"`
	Location *string             `json:"location,omitempty"`
	Tags     *map[string]*string `json:"tags,omitempty"`
}

// ResourceNavigationLink is resourceNavigationLink resource
type ResourceNavigationLink struct {
	ID         *string                       `json:"id,omitempty"`
	Properties *ResourceNavigationLinkFormat `json:"properties,omitempty"`
	Name       *string                       `json:"name,omitempty"`
	Etag       *string                       `json:"etag,omitempty"`
}

// ResourceNavigationLinkFormat is properties of ResourceNavigationLink
type ResourceNavigationLinkFormat struct {
	LinkedResourceType *string `json:"linkedResourceType,omitempty"`
	Link               *string `json:"link,omitempty"`
	ProvisioningState  *string `json:"provisioningState,omitempty"`
}

// Route is route resource
type Route struct {
	autorest.Response `json:"-"`
	ID                *string                `json:"id,omitempty"`
	Properties        *RoutePropertiesFormat `json:"properties,omitempty"`
	Name              *string                `json:"name,omitempty"`
	Etag              *string                `json:"etag,omitempty"`
}

// RouteListResult is response for ListRoute Api servive call
type RouteListResult struct {
	autorest.Response `json:"-"`
	Value             *[]Route `json:"value,omitempty"`
	NextLink          *string  `json:"nextLink,omitempty"`
}

// RouteListResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client RouteListResult) RouteListResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// RoutePropertiesFormat is route resource
type RoutePropertiesFormat struct {
	AddressPrefix     *string          `json:"addressPrefix,omitempty"`
	NextHopType       RouteNextHopType `json:"nextHopType,omitempty"`
	NextHopIPAddress  *string          `json:"nextHopIpAddress,omitempty"`
	ProvisioningState *string          `json:"provisioningState,omitempty"`
}

// RouteTable is routeTable resource
type RouteTable struct {
	autorest.Response `json:"-"`
	ID                *string                     `json:"id,omitempty"`
	Name              *string                     `json:"name,omitempty"`
	Type              *string                     `json:"type,omitempty"`
	Location          *string                     `json:"location,omitempty"`
	Tags              *map[string]*string         `json:"tags,omitempty"`
	Properties        *RouteTablePropertiesFormat `json:"properties,omitempty"`
	Etag              *string                     `json:"etag,omitempty"`
}

// RouteTableListResult is response for ListRouteTable Api servive call
type RouteTableListResult struct {
	autorest.Response `json:"-"`
	Value             *[]RouteTable `json:"value,omitempty"`
	NextLink          *string       `json:"nextLink,omitempty"`
}

// RouteTableListResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client RouteTableListResult) RouteTableListResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// RouteTablePropertiesFormat is route Table resource
type RouteTablePropertiesFormat struct {
	Routes            *[]Route  `json:"routes,omitempty"`
	Subnets           *[]Subnet `json:"subnets,omitempty"`
	ProvisioningState *string   `json:"provisioningState,omitempty"`
}

// SecurityGroup is networkSecurityGroup resource
type SecurityGroup struct {
	autorest.Response `json:"-"`
	ID                *string                        `json:"id,omitempty"`
	Name              *string                        `json:"name,omitempty"`
	Type              *string                        `json:"type,omitempty"`
	Location          *string                        `json:"location,omitempty"`
	Tags              *map[string]*string            `json:"tags,omitempty"`
	Properties        *SecurityGroupPropertiesFormat `json:"properties,omitempty"`
	Etag              *string                        `json:"etag,omitempty"`
}

// SecurityGroupListResult is response for ListNetworkSecurityGroups Api
// servive call
type SecurityGroupListResult struct {
	autorest.Response `json:"-"`
	Value             *[]SecurityGroup `json:"value,omitempty"`
	NextLink          *string          `json:"nextLink,omitempty"`
}

// SecurityGroupListResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client SecurityGroupListResult) SecurityGroupListResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// SecurityGroupPropertiesFormat is network Security Group resource
type SecurityGroupPropertiesFormat struct {
	SecurityRules        *[]SecurityRule `json:"securityRules,omitempty"`
	DefaultSecurityRules *[]SecurityRule `json:"defaultSecurityRules,omitempty"`
	NetworkInterfaces    *[]Interface    `json:"networkInterfaces,omitempty"`
	Subnets              *[]Subnet       `json:"subnets,omitempty"`
	ResourceGUID         *string         `json:"resourceGuid,omitempty"`
	ProvisioningState    *string         `json:"provisioningState,omitempty"`
}

// SecurityRule is network security rule
type SecurityRule struct {
	autorest.Response `json:"-"`
	ID                *string                       `json:"id,omitempty"`
	Properties        *SecurityRulePropertiesFormat `json:"properties,omitempty"`
	Name              *string                       `json:"name,omitempty"`
	Etag              *string                       `json:"etag,omitempty"`
}

// SecurityRuleListResult is response for ListSecurityRule Api service
// callRetrieves all security rules that belongs to a network security group
type SecurityRuleListResult struct {
	autorest.Response `json:"-"`
	Value             *[]SecurityRule `json:"value,omitempty"`
	NextLink          *string         `json:"nextLink,omitempty"`
}

// SecurityRuleListResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client SecurityRuleListResult) SecurityRuleListResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// SecurityRulePropertiesFormat is
type SecurityRulePropertiesFormat struct {
	Description              *string               `json:"description,omitempty"`
	Protocol                 SecurityRuleProtocol  `json:"protocol,omitempty"`
	SourcePortRange          *string               `json:"sourcePortRange,omitempty"`
	DestinationPortRange     *string               `json:"destinationPortRange,omitempty"`
	SourceAddressPrefix      *string               `json:"sourceAddressPrefix,omitempty"`
	DestinationAddressPrefix *string               `json:"destinationAddressPrefix,omitempty"`
	Access                   SecurityRuleAccess    `json:"access,omitempty"`
	Priority                 *int32                `json:"priority,omitempty"`
	Direction                SecurityRuleDirection `json:"direction,omitempty"`
	ProvisioningState        *string               `json:"provisioningState,omitempty"`
}

// String is
type String struct {
	autorest.Response `json:"-"`
	Value             *string `json:"value,omitempty"`
}

// Subnet is subnet in a VirtualNework resource
type Subnet struct {
	autorest.Response `json:"-"`
	ID                *string                 `json:"id,omitempty"`
	Properties        *SubnetPropertiesFormat `json:"properties,omitempty"`
	Name              *string                 `json:"name,omitempty"`
	Etag              *string                 `json:"etag,omitempty"`
}

// SubnetListResult is response for ListSubnets Api service callRetrieves all
// subnet that belongs to a virtual network
type SubnetListResult struct {
	autorest.Response `json:"-"`
	Value             *[]Subnet `json:"value,omitempty"`
	NextLink          *string   `json:"nextLink,omitempty"`
}

// SubnetListResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client SubnetListResult) SubnetListResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// SubnetPropertiesFormat is
type SubnetPropertiesFormat struct {
	AddressPrefix           *string                   `json:"addressPrefix,omitempty"`
	NetworkSecurityGroup    *SecurityGroup            `json:"networkSecurityGroup,omitempty"`
	RouteTable              *RouteTable               `json:"routeTable,omitempty"`
	IPConfigurations        *[]IPConfiguration        `json:"ipConfigurations,omitempty"`
	ResourceNavigationLinks *[]ResourceNavigationLink `json:"resourceNavigationLinks,omitempty"`
	ProvisioningState       *string                   `json:"provisioningState,omitempty"`
}

// SubResource is
type SubResource struct {
	ID *string `json:"id,omitempty"`
}

// Usage is describes Network Resource Usage.
type Usage struct {
	Unit         *string    `json:"unit,omitempty"`
	CurrentValue *int64     `json:"currentValue,omitempty"`
	Limit        *int64     `json:"limit,omitempty"`
	Name         *UsageName `json:"name,omitempty"`
}

// UsageName is the Usage Names.
type UsageName struct {
	Value          *string `json:"value,omitempty"`
	LocalizedValue *string `json:"localizedValue,omitempty"`
}

// UsagesListResult is the List Usages operation response.
type UsagesListResult struct {
	autorest.Response `json:"-"`
	Value             *[]Usage `json:"value,omitempty"`
	NextLink          *string  `json:"nextLink,omitempty"`
}

// UsagesListResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client UsagesListResult) UsagesListResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// VirtualNetwork is virtual Network resource
type VirtualNetwork struct {
	autorest.Response `json:"-"`
	ID                *string                         `json:"id,omitempty"`
	Name              *string                         `json:"name,omitempty"`
	Type              *string                         `json:"type,omitempty"`
	Location          *string                         `json:"location,omitempty"`
	Tags              *map[string]*string             `json:"tags,omitempty"`
	Properties        *VirtualNetworkPropertiesFormat `json:"properties,omitempty"`
	Etag              *string                         `json:"etag,omitempty"`
}

// VirtualNetworkGateway is a common class for general resource information
type VirtualNetworkGateway struct {
	autorest.Response `json:"-"`
	ID                *string                                `json:"id,omitempty"`
	Name              *string                                `json:"name,omitempty"`
	Type              *string                                `json:"type,omitempty"`
	Location          *string                                `json:"location,omitempty"`
	Tags              *map[string]*string                    `json:"tags,omitempty"`
	Properties        *VirtualNetworkGatewayPropertiesFormat `json:"properties,omitempty"`
	Etag              *string                                `json:"etag,omitempty"`
}

// VirtualNetworkGatewayConnection is a common class for general resource
// information
type VirtualNetworkGatewayConnection struct {
	autorest.Response `json:"-"`
	ID                *string                                          `json:"id,omitempty"`
	Name              *string                                          `json:"name,omitempty"`
	Type              *string                                          `json:"type,omitempty"`
	Location          *string                                          `json:"location,omitempty"`
	Tags              *map[string]*string                              `json:"tags,omitempty"`
	Properties        *VirtualNetworkGatewayConnectionPropertiesFormat `json:"properties,omitempty"`
	Etag              *string                                          `json:"etag,omitempty"`
}

// VirtualNetworkGatewayConnectionListResult is response for
// ListVirtualNetworkGatewayConnections Api service call
type VirtualNetworkGatewayConnectionListResult struct {
	autorest.Response `json:"-"`
	Value             *[]VirtualNetworkGatewayConnection `json:"value,omitempty"`
	NextLink          *string                            `json:"nextLink,omitempty"`
}

// VirtualNetworkGatewayConnectionListResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client VirtualNetworkGatewayConnectionListResult) VirtualNetworkGatewayConnectionListResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// VirtualNetworkGatewayConnectionPropertiesFormat is
// virtualNeworkGatewayConnection properties
type VirtualNetworkGatewayConnectionPropertiesFormat struct {
	AuthorizationKey        *string                               `json:"authorizationKey,omitempty"`
	VirtualNetworkGateway1  *VirtualNetworkGateway                `json:"virtualNetworkGateway1,omitempty"`
	VirtualNetworkGateway2  *VirtualNetworkGateway                `json:"virtualNetworkGateway2,omitempty"`
	LocalNetworkGateway2    *LocalNetworkGateway                  `json:"localNetworkGateway2,omitempty"`
	ConnectionType          VirtualNetworkGatewayConnectionType   `json:"connectionType,omitempty"`
	RoutingWeight           *int32                                `json:"routingWeight,omitempty"`
	SharedKey               *string                               `json:"sharedKey,omitempty"`
	ConnectionStatus        VirtualNetworkGatewayConnectionStatus `json:"connectionStatus,omitempty"`
	EgressBytesTransferred  *int64                                `json:"egressBytesTransferred,omitempty"`
	IngressBytesTransferred *int64                                `json:"ingressBytesTransferred,omitempty"`
	Peer                    *SubResource                          `json:"peer,omitempty"`
	EnableBgp               *bool                                 `json:"enableBgp,omitempty"`
	ResourceGUID            *string                               `json:"resourceGuid,omitempty"`
	ProvisioningState       *string                               `json:"provisioningState,omitempty"`
}

// VirtualNetworkGatewayIPConfiguration is ipConfiguration for Virtual network
// gateway
type VirtualNetworkGatewayIPConfiguration struct {
	ID         *string                                               `json:"id,omitempty"`
	Properties *VirtualNetworkGatewayIPConfigurationPropertiesFormat `json:"properties,omitempty"`
	Name       *string                                               `json:"name,omitempty"`
	Etag       *string                                               `json:"etag,omitempty"`
}

// VirtualNetworkGatewayIPConfigurationPropertiesFormat is properties of
// VirtualNetworkGatewayIPConfiguration
type VirtualNetworkGatewayIPConfigurationPropertiesFormat struct {
	PrivateIPAllocationMethod IPAllocationMethod `json:"privateIPAllocationMethod,omitempty"`
	Subnet                    *SubResource       `json:"subnet,omitempty"`
	PublicIPAddress           *SubResource       `json:"publicIPAddress,omitempty"`
	ProvisioningState         *string            `json:"provisioningState,omitempty"`
}

// VirtualNetworkGatewayListResult is response for ListVirtualNetworkGateways
// Api service call
type VirtualNetworkGatewayListResult struct {
	autorest.Response `json:"-"`
	Value             *[]VirtualNetworkGateway `json:"value,omitempty"`
	NextLink          *string                  `json:"nextLink,omitempty"`
}

// VirtualNetworkGatewayListResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client VirtualNetworkGatewayListResult) VirtualNetworkGatewayListResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// VirtualNetworkGatewayPropertiesFormat is virtualNeworkGateay properties
type VirtualNetworkGatewayPropertiesFormat struct {
	IPConfigurations       *[]VirtualNetworkGatewayIPConfiguration `json:"ipConfigurations,omitempty"`
	GatewayType            VirtualNetworkGatewayType               `json:"gatewayType,omitempty"`
	VpnType                VpnType                                 `json:"vpnType,omitempty"`
	EnableBgp              *bool                                   `json:"enableBgp,omitempty"`
	GatewayDefaultSite     *SubResource                            `json:"gatewayDefaultSite,omitempty"`
	Sku                    *VirtualNetworkGatewaySku               `json:"sku,omitempty"`
	VpnClientConfiguration *VpnClientConfiguration                 `json:"vpnClientConfiguration,omitempty"`
	BgpSettings            *BgpSettings                            `json:"bgpSettings,omitempty"`
	ResourceGUID           *string                                 `json:"resourceGuid,omitempty"`
	ProvisioningState      *string                                 `json:"provisioningState,omitempty"`
}

// VirtualNetworkGatewaySku is virtualNetworkGatewaySku details
type VirtualNetworkGatewaySku struct {
	Name     VirtualNetworkGatewaySkuName `json:"name,omitempty"`
	Tier     VirtualNetworkGatewaySkuTier `json:"tier,omitempty"`
	Capacity *int32                       `json:"capacity,omitempty"`
}

// VirtualNetworkListResult is response for ListVirtualNetworks Api servive
// call
type VirtualNetworkListResult struct {
	autorest.Response `json:"-"`
	Value             *[]VirtualNetwork `json:"value,omitempty"`
	NextLink          *string           `json:"nextLink,omitempty"`
}

// VirtualNetworkListResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client VirtualNetworkListResult) VirtualNetworkListResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// VirtualNetworkPeering is peerings in a VirtualNework resource
type VirtualNetworkPeering struct {
	autorest.Response `json:"-"`
	ID                *string                                `json:"id,omitempty"`
	Properties        *VirtualNetworkPeeringPropertiesFormat `json:"properties,omitempty"`
	Name              *string                                `json:"name,omitempty"`
	Etag              *string                                `json:"etag,omitempty"`
}

// VirtualNetworkPeeringListResult is response for ListSubnets Api service
// callRetrieves all subnet that belongs to a virtual network
type VirtualNetworkPeeringListResult struct {
	autorest.Response `json:"-"`
	Value             *[]VirtualNetworkPeering `json:"value,omitempty"`
	NextLink          *string                  `json:"nextLink,omitempty"`
}

// VirtualNetworkPeeringListResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client VirtualNetworkPeeringListResult) VirtualNetworkPeeringListResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// VirtualNetworkPeeringPropertiesFormat is
type VirtualNetworkPeeringPropertiesFormat struct {
	AllowVirtualNetworkAccess *bool                      `json:"allowVirtualNetworkAccess,omitempty"`
	AllowForwardedTraffic     *bool                      `json:"allowForwardedTraffic,omitempty"`
	AllowGatewayTransit       *bool                      `json:"allowGatewayTransit,omitempty"`
	UseRemoteGateways         *bool                      `json:"useRemoteGateways,omitempty"`
	RemoteVirtualNetwork      *SubResource               `json:"remoteVirtualNetwork,omitempty"`
	PeeringState              VirtualNetworkPeeringState `json:"peeringState,omitempty"`
	ProvisioningState         *string                    `json:"provisioningState,omitempty"`
}

// VirtualNetworkPropertiesFormat is
type VirtualNetworkPropertiesFormat struct {
	AddressSpace           *AddressSpace            `json:"addressSpace,omitempty"`
	DhcpOptions            *DhcpOptions             `json:"dhcpOptions,omitempty"`
	Subnets                *[]Subnet                `json:"subnets,omitempty"`
	VirtualNetworkPeerings *[]VirtualNetworkPeering `json:"VirtualNetworkPeerings,omitempty"`
	ResourceGUID           *string                  `json:"resourceGuid,omitempty"`
	ProvisioningState      *string                  `json:"provisioningState,omitempty"`
}

// VpnClientConfiguration is vpnClientConfiguration for P2S client
type VpnClientConfiguration struct {
	VpnClientAddressPool         *AddressSpace                  `json:"vpnClientAddressPool,omitempty"`
	VpnClientRootCertificates    *[]VpnClientRootCertificate    `json:"vpnClientRootCertificates,omitempty"`
	VpnClientRevokedCertificates *[]VpnClientRevokedCertificate `json:"vpnClientRevokedCertificates,omitempty"`
}

// VpnClientParameters is vpnClientParameters
type VpnClientParameters struct {
	ProcessorArchitecture ProcessorArchitecture `json:"ProcessorArchitecture,omitempty"`
}

// VpnClientRevokedCertificate is vPN client revoked certificate of virtual
// network gateway
type VpnClientRevokedCertificate struct {
	ID         *string                                      `json:"id,omitempty"`
	Properties *VpnClientRevokedCertificatePropertiesFormat `json:"properties,omitempty"`
	Name       *string                                      `json:"name,omitempty"`
	Etag       *string                                      `json:"etag,omitempty"`
}

// VpnClientRevokedCertificatePropertiesFormat is properties of the revoked
// VPN client certificate of virtual network gateway
type VpnClientRevokedCertificatePropertiesFormat struct {
	Thumbprint        *string `json:"thumbprint,omitempty"`
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// VpnClientRootCertificate is vPN client root certificate of virtual network
// gateway
type VpnClientRootCertificate struct {
	ID         *string                                   `json:"id,omitempty"`
	Properties *VpnClientRootCertificatePropertiesFormat `json:"properties,omitempty"`
	Name       *string                                   `json:"name,omitempty"`
	Etag       *string                                   `json:"etag,omitempty"`
}

// VpnClientRootCertificatePropertiesFormat is properties of SSL certificates
// of application gateway
type VpnClientRootCertificatePropertiesFormat struct {
	PublicCertData    *string `json:"publicCertData,omitempty"`
	ProvisioningState *string `json:"provisioningState,omitempty"`
}
