// This file was generated by gir (https://github.com/gtk-rs/gir)
// from
// from gir-files (https://github.com/gtk-rs/gir-files.git)
// DO NOT EDIT

use crate::{ffi, LocationLevel};
use glib::{prelude::*, translate::*};
use std::boxed::Box as Box_;

glib::wrapper! {
    #[doc(alias = "GWeatherLocation")]
    pub struct Location(Object<ffi::GWeatherLocation, ffi::GWeatherLocationClass>);

    match fn {
        type_ => || ffi::gweather_location_get_type(),
    }
}

impl Location {
    #[doc(alias = "gweather_location_new_detached")]
    pub fn new_detached(name: &str, icao: Option<&str>, latitude: f64, longitude: f64) -> Location {
        assert_initialized_main_thread!();
        unsafe {
            from_glib_full(ffi::gweather_location_new_detached(
                name.to_glib_none().0,
                icao.to_glib_none().0,
                latitude,
                longitude,
            ))
        }
    }

    #[doc(alias = "gweather_location_deserialize")]
    #[must_use]
    pub fn deserialize(&self, serialized: &glib::Variant) -> Location {
        unsafe {
            from_glib_full(ffi::gweather_location_deserialize(
                self.to_glib_none().0,
                serialized.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gweather_location_equal")]
    pub fn equal(&self, two: &Location) -> bool {
        unsafe {
            from_glib(ffi::gweather_location_equal(
                self.to_glib_none().0,
                two.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gweather_location_find_by_country_code")]
    #[must_use]
    pub fn find_by_country_code(&self, country_code: &str) -> Location {
        unsafe {
            from_glib_full(ffi::gweather_location_find_by_country_code(
                self.to_glib_none().0,
                country_code.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gweather_location_find_by_station_code")]
    #[must_use]
    pub fn find_by_station_code(&self, station_code: &str) -> Option<Location> {
        unsafe {
            from_glib_full(ffi::gweather_location_find_by_station_code(
                self.to_glib_none().0,
                station_code.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gweather_location_find_nearest_city")]
    #[must_use]
    pub fn find_nearest_city(&self, lat: f64, lon: f64) -> Location {
        unsafe {
            from_glib_full(ffi::gweather_location_find_nearest_city(
                self.to_glib_none().0,
                lat,
                lon,
            ))
        }
    }

    #[doc(alias = "gweather_location_find_nearest_city_full")]
    #[must_use]
    pub fn find_nearest_city_full(
        &self,
        lat: f64,
        lon: f64,
        func: Option<Box_<dyn Fn(&Location) -> bool + 'static>>,
    ) -> Location {
        let func_data: Box_<Option<Box_<dyn Fn(&Location) -> bool + 'static>>> = Box_::new(func);
        unsafe extern "C" fn func_func(
            location: *mut ffi::GWeatherLocation,
            user_data: glib::ffi::gpointer,
        ) -> glib::ffi::gboolean {
            let location = from_glib_borrow(location);
            let callback = &*(user_data as *mut Option<Box_<dyn Fn(&Location) -> bool + 'static>>);
            if let Some(ref callback) = *callback {
                callback(&location)
            } else {
                panic!("cannot get closure...")
            }
            .into_glib()
        }
        let func = if func_data.is_some() {
            Some(func_func as _)
        } else {
            None
        };
        unsafe extern "C" fn destroy_func(data: glib::ffi::gpointer) {
            let _callback =
                Box_::from_raw(data as *mut Option<Box_<dyn Fn(&Location) -> bool + 'static>>);
        }
        let destroy_call5 = Some(destroy_func as _);
        let super_callback0: Box_<Option<Box_<dyn Fn(&Location) -> bool + 'static>>> = func_data;
        unsafe {
            from_glib_full(ffi::gweather_location_find_nearest_city_full(
                self.to_glib_none().0,
                lat,
                lon,
                func,
                Box_::into_raw(super_callback0) as *mut _,
                destroy_call5,
            ))
        }
    }

    #[doc(alias = "gweather_location_get_city_name")]
    #[doc(alias = "get_city_name")]
    pub fn city_name(&self) -> Option<glib::GString> {
        unsafe { from_glib_full(ffi::gweather_location_get_city_name(self.to_glib_none().0)) }
    }

    #[doc(alias = "gweather_location_get_code")]
    #[doc(alias = "get_code")]
    pub fn code(&self) -> Option<glib::GString> {
        unsafe { from_glib_none(ffi::gweather_location_get_code(self.to_glib_none().0)) }
    }

    #[doc(alias = "gweather_location_get_coords")]
    #[doc(alias = "get_coords")]
    pub fn coords(&self) -> (f64, f64) {
        unsafe {
            let mut latitude = std::mem::MaybeUninit::uninit();
            let mut longitude = std::mem::MaybeUninit::uninit();
            ffi::gweather_location_get_coords(
                self.to_glib_none().0,
                latitude.as_mut_ptr(),
                longitude.as_mut_ptr(),
            );
            (latitude.assume_init(), longitude.assume_init())
        }
    }

    #[doc(alias = "gweather_location_get_country")]
    #[doc(alias = "get_country")]
    pub fn country(&self) -> Option<glib::GString> {
        unsafe { from_glib_none(ffi::gweather_location_get_country(self.to_glib_none().0)) }
    }

    #[doc(alias = "gweather_location_get_country_name")]
    #[doc(alias = "get_country_name")]
    pub fn country_name(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_full(ffi::gweather_location_get_country_name(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gweather_location_get_distance")]
    #[doc(alias = "get_distance")]
    pub fn distance(&self, loc2: &Location) -> f64 {
        unsafe { ffi::gweather_location_get_distance(self.to_glib_none().0, loc2.to_glib_none().0) }
    }

    #[doc(alias = "gweather_location_get_english_name")]
    #[doc(alias = "get_english_name")]
    pub fn english_name(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_none(ffi::gweather_location_get_english_name(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gweather_location_get_english_sort_name")]
    #[doc(alias = "get_english_sort_name")]
    pub fn english_sort_name(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_none(ffi::gweather_location_get_english_sort_name(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gweather_location_get_level")]
    #[doc(alias = "get_level")]
    pub fn level(&self) -> LocationLevel {
        unsafe { from_glib(ffi::gweather_location_get_level(self.to_glib_none().0)) }
    }

    #[doc(alias = "gweather_location_get_name")]
    #[doc(alias = "get_name")]
    pub fn name(&self) -> Option<glib::GString> {
        unsafe { from_glib_none(ffi::gweather_location_get_name(self.to_glib_none().0)) }
    }

    #[doc(alias = "gweather_location_get_parent")]
    #[doc(alias = "get_parent")]
    #[must_use]
    pub fn parent(&self) -> Option<Location> {
        unsafe { from_glib_full(ffi::gweather_location_get_parent(self.to_glib_none().0)) }
    }

    #[doc(alias = "gweather_location_get_sort_name")]
    #[doc(alias = "get_sort_name")]
    pub fn sort_name(&self) -> Option<glib::GString> {
        unsafe { from_glib_none(ffi::gweather_location_get_sort_name(self.to_glib_none().0)) }
    }

    #[doc(alias = "gweather_location_get_timezone")]
    #[doc(alias = "get_timezone")]
    pub fn timezone(&self) -> Option<glib::TimeZone> {
        unsafe { from_glib_none(ffi::gweather_location_get_timezone(self.to_glib_none().0)) }
    }

    #[doc(alias = "gweather_location_get_timezone_str")]
    #[doc(alias = "get_timezone_str")]
    pub fn timezone_str(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_none(ffi::gweather_location_get_timezone_str(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gweather_location_get_timezones")]
    #[doc(alias = "get_timezones")]
    pub fn timezones(&self) -> Vec<glib::TimeZone> {
        unsafe {
            FromGlibPtrContainer::from_glib_full(ffi::gweather_location_get_timezones(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gweather_location_has_coords")]
    pub fn has_coords(&self) -> bool {
        unsafe { from_glib(ffi::gweather_location_has_coords(self.to_glib_none().0)) }
    }

    #[doc(alias = "gweather_location_has_timezone")]
    pub fn has_timezone(&self) -> bool {
        unsafe { from_glib(ffi::gweather_location_has_timezone(self.to_glib_none().0)) }
    }

    #[doc(alias = "gweather_location_next_child")]
    #[must_use]
    pub fn next_child(&self, child: Option<Location>) -> Option<Location> {
        unsafe {
            from_glib_full(ffi::gweather_location_next_child(
                self.to_glib_none().0,
                child.into_glib_ptr(),
            ))
        }
    }

    #[doc(alias = "gweather_location_serialize")]
    pub fn serialize(&self) -> glib::Variant {
        unsafe { from_glib_none(ffi::gweather_location_serialize(self.to_glib_none().0)) }
    }

    #[doc(alias = "gweather_location_get_world")]
    #[doc(alias = "get_world")]
    pub fn world() -> Option<Location> {
        assert_initialized_main_thread!();
        unsafe { from_glib_full(ffi::gweather_location_get_world()) }
    }
}
