/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.type;

import java.util.regex.Pattern;
import org.odftoolkit.odfdom.type.OdfDataType;

public class Vector3D
implements OdfDataType {
    private String mVector3D;
    private static final Pattern vector3DPattern = Pattern.compile("^\\([ ]*-?([0-9]+(\\.[0-9]*)?|\\.[0-9]+)([ ]+-?([0-9]+(\\.[0-9]*)?|\\.[0-9]+)){2}[ ]*\\)$");

    public Vector3D(String vector3D) {
        if (!Vector3D.isValid(vector3D)) {
            throw new IllegalArgumentException("parameter is invalid for datatype Vector3D");
        }
        this.mVector3D = vector3D;
    }

    public String toString() {
        return this.mVector3D;
    }

    public static Vector3D valueOf(String stringValue) {
        return new Vector3D(stringValue);
    }

    public static boolean isValid(String stringValue) {
        return stringValue != null && vector3DPattern.matcher(stringValue).matches();
    }
}

