/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
 * This file is part of the LibreOffice project.
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * This file incorporates work covered by the following license notice:
 *
 *   Licensed to the Apache Software Foundation (ASF) under one or more
 *   contributor license agreements. See the NOTICE file distributed
 *   with this work for additional information regarding copyright
 *   ownership. The ASF licenses this file to you under the Apache
 *   License, Version 2.0 (the "License"); you may not use this file
 *   except in compliance with the License. You may obtain a copy of
 *   the License at http://www.apache.org/licenses/LICENSE-2.0 .
 */

#include <rtl/ustring.hxx>
#include <svtools/rtfkeywd.hxx>
#include <svtools/rtftoken.h>

#include <algorithm>
#include <string_view>

namespace {

// the table is still to be sorted
struct RTF_TokenEntry
{
    std::u16string_view sToken;
    int nToken;
};

}

// Flag: RTF-token table has been sorted
static bool bSortKeyWords = false;

static RTF_TokenEntry aRTFTokenTab[] = {
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_IGNORE),        RTF_IGNOREFLAG},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_RTF),           RTF_RTF},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_ANSI),          RTF_ANSITYPE},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_MAC),           RTF_MACTYPE},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_PC),            RTF_PCTYPE},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_PCA),           RTF_PCATYPE},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_NEXTCSET),      RTF_NEXTTYPE},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_STYLESHEET),    RTF_STYLESHEET},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_SBASEDON),      RTF_SBASEDON},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_SNEXT),         RTF_SNEXT},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_FONTTBL),       RTF_FONTTBL},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_DEFF),          RTF_DEFF},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_FNIL),          RTF_FNIL},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_FROMAN),        RTF_FROMAN},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_FSWISS),        RTF_FSWISS},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_FMODERN),       RTF_FMODERN},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_FSCRIPT),       RTF_FSCRIPT},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_FDECOR),        RTF_FDECOR},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_FTECH),         RTF_FTECH},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_FCHARSET),     RTF_FCHARSET},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_FALT),         RTF_FALT},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_FPRQ),         RTF_FPRQ},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_COLORTBL),      RTF_COLORTBL},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_RED),           RTF_RED},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_GREEN),         RTF_GREEN},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_BLUE),          RTF_BLUE},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_CF),            RTF_CF},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_CB),            RTF_CB},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_INFO),          RTF_INFO},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_TITLE),         RTF_TITLE},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_SUBJECT),       RTF_SUBJECT},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_AUTHOR),        RTF_AUTHOR},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_OPERATOR),      RTF_OPERATOR},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_KEYWORDS),      RTF_KEYWORDS},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_COMMENT),       RTF_COMMENT},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_VERSION),       RTF_VERSION},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_DOCCOMM),       RTF_DOCCOMM},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_VERN),          RTF_VERN},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_CREATIM),       RTF_CREATIM},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_REVTIM),        RTF_REVTIM},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_PRINTIM),       RTF_PRINTIM},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_BUPTIM),        RTF_BUPTIM},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_EDMINS),        RTF_EDMINS},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_NOFPAGES),      RTF_NOFPAGES},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_NOFWORDS),      RTF_NOFWORDS},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_NOFCHARS),      RTF_NOFCHARS},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_ID),            RTF_ID},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_YR),            RTF_YR},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_MO),            RTF_MO},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_DY),            RTF_DY},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_HR),            RTF_HR},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_MIN),           RTF_MIN},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_ANNOTATION),    RTF_ANNOTATION},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_ATNID),         RTF_ATNID},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_FOOTNOTE),      RTF_FOOTNOTE},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_FOOTER),        RTF_FOOTER},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_FOOTERL),       RTF_FOOTERL},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_FOOTERR),       RTF_FOOTERR},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_FOOTERF),       RTF_FOOTERF},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_HEADER),        RTF_HEADER},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_HEADERL),       RTF_HEADERL},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_HEADERR),       RTF_HEADERR},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_HEADERF),       RTF_HEADERF},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_XE),            RTF_XE},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_BXE),           RTF_BXE},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_IXE),           RTF_IXE},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_RXE),           RTF_RXE},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_TXE),           RTF_TXE},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_TC),            RTF_TC},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_TCF),           RTF_TCF},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_TCL),           RTF_TCL},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_BKMKSTART),     RTF_BKMKSTART},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_BKMKEND),       RTF_BKMKEND},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_PICT),          RTF_PICT},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_PICW),          RTF_PICW},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_PICH),          RTF_PICH},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_WBMBITSPIXEL),  RTF_WBMBITSPIXEL},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_WBMPLANES),     RTF_WBMPLANES},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_WBMWIDTHBYTES), RTF_WBMWIDTHBYTES},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_PICWGOAL),      RTF_PICWGOAL},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_PICHGOAL),      RTF_PICHGOAL},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_BIN),           RTF_BIN},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_PICSCALEX),     RTF_PICSCALEX},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_PICSCALEY),     RTF_PICSCALEY},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_PICSCALED),     RTF_PICSCALED},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_WBITMAP),       RTF_WBITMAP},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_WMETAFILE),     RTF_WMETAFILE},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_MACPICT),       RTF_MACPICT},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_PICCROPT),      RTF_PICCROPT},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_PICCROPB),      RTF_PICCROPB},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_PICCROPL),      RTF_PICCROPL},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_PICCROPR),      RTF_PICCROPR},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_FIELD),         RTF_FIELD},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_FLDDIRTY),      RTF_FLDDIRTY},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_FLDEDIT),       RTF_FLDEDIT},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_FLDLOCK),       RTF_FLDLOCK},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_FLDPRIV),       RTF_FLDPRIV},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_FLDINST),       RTF_FLDINST},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_FLDRSLT),       RTF_FLDRSLT},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_PAPERW),        RTF_PAPERW},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_PAPERH),        RTF_PAPERH},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_MARGL),         RTF_MARGL},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_MARGR),         RTF_MARGR},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_MARGT),         RTF_MARGT},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_MARGB),         RTF_MARGB},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_FACINGP),       RTF_FACINGP},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_GUTTER),        RTF_GUTTER},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_DEFTAB),        RTF_DEFTAB},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_WIDOWCTRL),     RTF_WIDOWCTRL},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_HYPHHOTZ),      RTF_HYPHHOTZ},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_FTNSEP),        RTF_FTNSEP},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_FTNSEPC),       RTF_FTNSEPC},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_FTNCN),         RTF_FTNCN},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_ENDNOTES),      RTF_ENDNOTES},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_ENDDOC),        RTF_ENDDOC},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_FTNTJ),         RTF_FTNTJ},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_FTNBJ),         RTF_FTNBJ},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_FTNSTART),      RTF_FTNSTART},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_FTNRESTART),    RTF_FTNRESTART},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_PGNSTART),      RTF_PGNSTART},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_LINESTART),     RTF_LINESTART},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_LANDSCAPE),     RTF_LANDSCAPE},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_FRACWIDTH),     RTF_FRACWIDTH},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_NEXTFILE),      RTF_NEXTFILE},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_TEMPLATE),      RTF_TEMPLATE},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_MAKEBACKUP),    RTF_MAKEBACKUP},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_DEFFORMAT),     RTF_DEFFORMAT},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_REVISIONS),     RTF_REVISIONS},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_MARGMIRROR),    RTF_MARGMIRROR},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_REVPROP),       RTF_REVPROP},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_REVBAR),        RTF_REVBAR},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_SECTD),         RTF_SECTD},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_SBKNONE),       RTF_SBKNONE},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_SBKCOL),        RTF_SBKCOL},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_SBKPAGE),       RTF_SBKPAGE},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_SBKEVEN),       RTF_SBKEVEN},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_SBKODD),        RTF_SBKODD},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_PGNSTARTS),     RTF_PGNSTARTS},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_PGNCONT),       RTF_PGNCONT},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_PGNRESTART),    RTF_PGNRESTART},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_PGNDEC),        RTF_PGNDEC},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_PGNUCRM),       RTF_PGNUCRM},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_PGNLCRM),       RTF_PGNLCRM},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_PGNUCLTR),      RTF_PGNUCLTR},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_PGNLCLTR),      RTF_PGNLCLTR},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_PGNX),          RTF_PGNX},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_PGNY),          RTF_PGNY},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_HEADERY),       RTF_HEADERY},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_FOOTERY),       RTF_FOOTERY},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_LINEMOD),       RTF_LINEMOD},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_LINEX),         RTF_LINEX},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_LINESTARTS),    RTF_LINESTARTS},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_LINERESTART),   RTF_LINERESTART},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_LINEPPAGE),     RTF_LINEPAGE},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_LINECONT),      RTF_LINECONT},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_VERTALT),       RTF_VERTALT},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_VERTALB),       RTF_VERTALB},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_VERTALC),       RTF_VERTALC},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_VERTALJ),       RTF_VERTALJ},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_COLS),          RTF_COLS},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_COLSX),         RTF_COLSX},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_COLNO),            RTF_COLNO},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_COLSR),            RTF_COLSR},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_COLW),         RTF_COLW},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_LINEBETCOL),    RTF_LINEBETCOL},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_ENDNHERE),      RTF_ENDNHERE},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_TITLEPG),       RTF_TITLEPG},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_PARD),          RTF_PARD},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_S),             RTF_S},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_QL),            RTF_QL},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_QR),            RTF_QR},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_QJ),            RTF_QJ},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_QC),            RTF_QC},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_FI),            RTF_FI},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_LI),            RTF_LI},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_LIN),           RTF_LIN},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_RI),            RTF_RI},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_RIN),           RTF_RIN},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_SB),            RTF_SB},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_SA),            RTF_SA},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_SL),            RTF_SL},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_INTBL),         RTF_INTBL},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_KEEP),          RTF_KEEP},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_KEEPN),         RTF_KEEPN},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_LEVEL),            RTF_LEVEL},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_SBYS),          RTF_SBYS},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_PAGEBB),        RTF_PAGEBB},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_NOLINE),        RTF_NOLINE},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_TX),            RTF_TX},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_TQL),           RTF_TQL},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_TQR),           RTF_TQR},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_TQC),           RTF_TQC},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_TQDEC),         RTF_TQDEC},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_TB),            RTF_TB},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_BRDRT),         RTF_BRDRT},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_BRDRB),         RTF_BRDRB},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_BRDRL),         RTF_BRDRL},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_BRDRR),         RTF_BRDRR},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_BOX),           RTF_BOX},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_BRDRS),         RTF_BRDRS},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_BRDRTH),        RTF_BRDRTH},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_BRDRSH),        RTF_BRDRSH},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_BRDRDB),        RTF_BRDRDB},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_BRDRDOT),       RTF_BRDRDOT},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_BRDRHAIR),      RTF_BRDRHAIR},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_BRSP),          RTF_BRSP},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_TLDOT),         RTF_TLDOT},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_TLHYPH),        RTF_TLHYPH},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_TLUL),          RTF_TLUL},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_TLTH),          RTF_TLTH},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_POSX),          RTF_POSX},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_POSXC),         RTF_POSXC},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_POSXI),         RTF_POSXI},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_POSXL),         RTF_POSXL},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_POSXO),         RTF_POSXO},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_POSXR),         RTF_POSXR},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_POSY),          RTF_POSY},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_POSYIL),        RTF_POSYIL},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_POSYT),         RTF_POSYT},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_POSYC),         RTF_POSYC},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_POSYB),         RTF_POSYB},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_ABSW),          RTF_ABSW},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_DXFRTEXT),      RTF_DXFRTEXT},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_PVMRG),         RTF_PVMRG},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_PVPG),          RTF_PVPG},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_PHMRG),         RTF_PHMRG},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_PHPG),          RTF_PHPG},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_PHCOL),         RTF_PHCOL},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_CLBRDRB),       RTF_CLBRDRB},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_CLBRDRT),       RTF_CLBRDRT},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_CLBRDRL),       RTF_CLBRDRL},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_CLBRDRR),       RTF_CLBRDRR},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_CLPADL),        RTF_CLPADL},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_CLPADT),        RTF_CLPADT},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_CLPADB),        RTF_CLPADB},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_CLPADR),        RTF_CLPADR},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_CLPADFL),       RTF_CLPADFL},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_CLPADFT),       RTF_CLPADFT},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_CLPADFB),       RTF_CLPADFB},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_CLPADFR),       RTF_CLPADFR},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_TROWD),         RTF_TROWD},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_TRQL),          RTF_TRQL},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_TRQR),          RTF_TRQR},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_TRQC),          RTF_TRQC},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_TRGAPH),        RTF_TRGAPH},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_TRRH),          RTF_TRRH},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_TRLEFT),        RTF_TRLEFT},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_CELLX),         RTF_CELLX},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_CLMGF),         RTF_CLMGF},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_CLMRG),         RTF_CLMRG},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_PLAIN),         RTF_PLAIN},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_B),             RTF_B},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_I),             RTF_I},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_STRIKE),        RTF_STRIKE},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_OUTL),          RTF_OUTL},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_SHAD),          RTF_SHAD},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_SCAPS),         RTF_SCAPS},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_CAPS),          RTF_CAPS},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_V),             RTF_V},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_F),             RTF_F},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_FS),            RTF_FS},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_EXPND),         RTF_EXPND},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_EXPNDTW),       RTF_EXPNDTW},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_KERNING),       RTF_KERNING},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_UL),            RTF_UL},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_ULW),           RTF_ULW},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_ULD),           RTF_ULD},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_ULDB),          RTF_ULDB},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_ULNONE),        RTF_ULNONE},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_UP),            RTF_UP},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_DN),            RTF_DN},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_REVISED),       RTF_REVISED},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_SUB),          RTF_SUB},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_NOSUPERSUB),   RTF_NOSUPERSUB},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_SUPER),            RTF_SUPER},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_CHDATE),        RTF_CHDATE},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_CHTIME),        RTF_CHTIME},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_CHPGN),         RTF_CHPGN},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_CHFTN),         RTF_CHFTN},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_CHATN),         RTF_CHATN},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_CHFTNSEP),      RTF_CHFTNSEP},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_CHFTNSEPC),     RTF_CHFTNSEPC},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_FORMULA),       RTF_FORMULA},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_NOBREAK),       RTF_NONBREAKINGSPACE},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_OPTHYPH),       RTF_OPTIONALHYPHEN},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_NOBRKHYPH),     RTF_NONBREAKINGHYPHEN},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_HEXCHAR),       RTF_HEX},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_CELL),          RTF_CELL},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_ROW),           RTF_ROW},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_PAR),           RTF_PAR},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_SECT),          RTF_SECT},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_PAGE),          RTF_PAGE},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_COLUMN),        RTF_COLUM},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_LINE),          RTF_LINE},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_TAB),           RTF_TAB},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_SUBENTRY),      RTF_SUBENTRYINDEX},

{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_DEFLANG),       RTF_DEFLANG},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_LANG),          RTF_LANG},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_PMMETAFILE),    RTF_OSMETAFILE},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_DIBITMAP),      RTF_DIBITMAP},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_KEYCODE),       RTF_KEYCODE},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_FN),            RTF_FNKEY},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_ALT),           RTF_ALTKEY},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_SHIFT),         RTF_SHIFTKEY},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_CTRL),          RTF_CTRLKEY},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_CHDPL),         RTF_CHDATEL},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_CHDPA),         RTF_CHDATEA},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_EMDASH),        RTF_EMDASH},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_ENDASH),        RTF_ENDASH},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_BULLET),        RTF_BULLET},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_LQUOTE),        RTF_LQUOTE},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_RQUOTE),        RTF_RQUOTE},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_LDBLQUOTE),     RTF_LDBLQUOTE},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_RDBLQUOTE),     RTF_RDBLQUOTE},

{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_BKMKCOLF),      RTF_BKMKCOLF},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_BKMKCOLL),      RTF_BKMKCOLL},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_PSOVER),        RTF_PSOVER},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_DOCTEMP),       RTF_DOCTEMP},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_BINFSXN),       RTF_BINFSXN},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_BINSXN),        RTF_BINSXN},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_PGWSXN),        RTF_PGWSXN},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_PGHSXN),        RTF_PGHSXN},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_MARGLSXN),      RTF_MARGLSXN},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_MARGRSXN),      RTF_MARGRSXN},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_MARGTSXN),      RTF_MARGTSXN},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_MARGBSXN),      RTF_MARGBSXN},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_GUTTERSXN),     RTF_GUTTERSXN},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_LNDSCPSXN),     RTF_LNDSCPSXN},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_FACPGSXN),      RTF_FACPGSXN},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_TLEQ),          RTF_TLEQ},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_BRDRBTW),       RTF_BRDRBTW},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_BRDRBAR),       RTF_BRDRBAR},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_BRDRW),         RTF_BRDRW},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_BRDRCF),        RTF_BRDRCF},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_ABSH),          RTF_ABSH},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_PVPARA),        RTF_PVPARA},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_NOWRAP),        RTF_NOWRAP},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_DFRMTXTX),      RTF_DFRMTXTX},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_DFRMTXTY),      RTF_DFRMTXTY},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_DROPCAPLI),     RTF_DROPCAPLI},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_DROPCAPT),      RTF_DROPCAPT},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_ABSNOOVRLP),    RTF_ABSNOOVRLP},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_POSNEGX),       RTF_POSNEGX},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_POSNEGY),       RTF_POSNEGY},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_DELETED),       RTF_DELETED},

{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_SHADING),       RTF_SHADING},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_BGHORIZ),       RTF_BGHORIZ},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_BGVERT),        RTF_BGVERT},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_BGFDIAG),       RTF_BGFDIAG},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_BGBDIAG),       RTF_BGBDIAG},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_BGCROSS),       RTF_BGCROSS},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_BGDCROSS),      RTF_BGDCROSS},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_BGDKHORIZ),     RTF_BGDKHORIZ},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_BGDKVERT),      RTF_BGDKVERT},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_BGDKFDIAG),     RTF_BGDKFDIAG},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_BGDKBDIAG),     RTF_BGDKBDIAG},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_BGDKCROSS),     RTF_BGDKCROSS},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_BGDKDCROSS),    RTF_BGDKDCROSS},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_CFPAT),         RTF_CFPAT},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_CBPAT),         RTF_CBPAT},

{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_CLSHDNG),       RTF_CLSHDNG},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_CLBGHORIZ),     RTF_CLBGHORIZ},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_CLBGVERT),      RTF_CLBGVERT},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_CLBGFDIAG),     RTF_CLBGFDIAG},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_CLBGBDIAG),     RTF_CLBGBDIAG},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_CLBGCROSS),     RTF_CLBGCROSS},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_CLBGDCROSS),    RTF_CLBGDCROSS},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_CLBGDKHOR),    RTF_CLBGDKHOR},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_CLBGDKVERT),    RTF_CLBGDKVERT},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_CLBGDKFDIAG),   RTF_CLBGDKFDIAG},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_CLBGDKBDIAG),   RTF_CLBGDKBDIAG},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_CLBGDKCROSS),   RTF_CLBGDKCROSS},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_CLBGDKDCROSS),  RTF_CLBGDKDCROSS},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_CLCFPAT),       RTF_CLCFPAT},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_CLCBPAT),       RTF_CLCBPAT},

{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_AB),           RTF_AB},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_ACAPS),            RTF_ACAPS},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_ACF),          RTF_ACF},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_ADDITIVE),     RTF_ADDITIVE},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_ADN),          RTF_ADN},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_AENDDOC),      RTF_AENDDOC},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_AENDNOTES),        RTF_AENDNOTES},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_AEXPND),       RTF_AEXPND},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_AF),           RTF_AF},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_AFS),          RTF_AFS},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_AFTNBJ),       RTF_AFTNBJ},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_AFTNCN),       RTF_AFTNCN},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_AFTNNALC),     RTF_AFTNNALC},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_AFTNNAR),      RTF_AFTNNAR},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_AFTNNAUC),     RTF_AFTNNAUC},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_AFTNNCHI),     RTF_AFTNNCHI},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_AFTNNRLC),     RTF_AFTNNRLC},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_AFTNNRUC),     RTF_AFTNNRUC},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_AFTNRESTART),  RTF_AFTNRESTART},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_AFTNRSTCONT),  RTF_AFTNRSTCONT},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_AFTNSEP),      RTF_AFTNSEP},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_AFTNSEPC),     RTF_AFTNSEPC},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_AFTNSTART),        RTF_AFTNSTART},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_AFTNTJ),       RTF_AFTNTJ},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_AI),           RTF_AI},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_ALANG),            RTF_ALANG},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_ALLPROT),      RTF_ALLPROT},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_ANNOTPROT),        RTF_ANNOTPROT},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_AOUTL),            RTF_AOUTL},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_ASCAPS),       RTF_ASCAPS},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_ASHAD),            RTF_ASHAD},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_ASTRIKE),      RTF_ASTRIKE},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_ATNAUTHOR),        RTF_ATNAUTHOR},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_ATNICN),       RTF_ATNICN},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_ATNREF),       RTF_ATNREF},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_ATNTIME),      RTF_ATNTIME},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_ATRFEND),      RTF_ATRFEND},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_ATRFSTART),        RTF_ATRFSTART},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_AUL),          RTF_AUL},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_AULD),         RTF_AULD},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_AULDB),            RTF_AULDB},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_AULNONE),      RTF_AULNONE},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_AULW),         RTF_AULW},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_AUP),          RTF_AUP},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_BKMKPUB),      RTF_BKMKPUB},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_BRDRDASH),     RTF_BRDRDASH},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_BRKFRM),       RTF_BRKFRM},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_CCHS),         RTF_CCHS},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_CPG),          RTF_CPG},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_CS),           RTF_CS},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_CVMME),            RTF_CVMME},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_DATAFIELD),        RTF_DATAFIELD},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_DO),           RTF_DO},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_DOBXCOLUMN),   RTF_DOBXCOLUMN},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_DOBXMARGIN),   RTF_DOBXMARGIN},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_DOBXPAGE),     RTF_DOBXPAGE},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_DOBYMARGIN),   RTF_DOBYMARGIN},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_DOBYPAGE),     RTF_DOBYPAGE},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_DOBYPARA),     RTF_DOBYPARA},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_DODHGT),       RTF_DODHGT},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_DOLOCK),       RTF_DOLOCK},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_DPAENDHOL),        RTF_DPAENDHOL},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_DPAENDL),      RTF_DPAENDL},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_DPAENDSOL),        RTF_DPAENDSOL},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_DPAENDW),      RTF_DPAENDW},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_DPARC),            RTF_DPARC},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_DPARCFLIPX),   RTF_DPARCFLIPX},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_DPARCFLIPY),   RTF_DPARCFLIPY},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_DPASTARTHOL),  RTF_DPASTARTHOL},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_DPASTARTL),        RTF_DPASTARTL},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_DPASTARTSOL),  RTF_DPASTARTSOL},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_DPASTARTW),        RTF_DPASTARTW},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_DPCALLOUT),        RTF_DPCALLOUT},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_DPCOA),            RTF_DPCOA},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_DPCOACCENT),   RTF_DPCOACCENT},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_DPCOBESTFIT),  RTF_DPCOBESTFIT},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_DPCOBORDER),   RTF_DPCOBORDER},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_DPCODABS),     RTF_DPCODABS},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_DPCODBOTTOM),  RTF_DPCODBOTTOM},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_DPCODCENTER),  RTF_DPCODCENTER},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_DPCODTOP),     RTF_DPCODTOP},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_DPCOLENGTH),   RTF_DPCOLENGTH},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_DPCOMINUSX),   RTF_DPCOMINUSX},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_DPCOMINUSY),   RTF_DPCOMINUSY},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_DPCOOFFSET),   RTF_DPCOOFFSET},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_DPCOSMARTA),   RTF_DPCOSMARTA},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_DPCOTDOUBLE),  RTF_DPCOTDOUBLE},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_DPCOTRIGHT),   RTF_DPCOTRIGHT},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_DPCOTSINGLE),  RTF_DPCOTSINGLE},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_DPCOTTRIPLE),  RTF_DPCOTTRIPLE},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_DPCOUNT),      RTF_DPCOUNT},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_DPELLIPSE),        RTF_DPELLIPSE},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_DPENDGROUP),   RTF_DPENDGROUP},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_DPFILLBGCB),   RTF_DPFILLBGCB},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_DPFILLBGCG),   RTF_DPFILLBGCG},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_DPFILLBGCR),   RTF_DPFILLBGCR},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_DPFILLBGGRAY), RTF_DPFILLBGGRAY},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_DPFILLBGPAL),  RTF_DPFILLBGPAL},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_DPFILLFGCB),   RTF_DPFILLFGCB},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_DPFILLFGCG),   RTF_DPFILLFGCG},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_DPFILLFGCR),   RTF_DPFILLFGCR},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_DPFILLFGGRAY), RTF_DPFILLFGGRAY},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_DPFILLFGPAL),  RTF_DPFILLFGPAL},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_DPFILLPAT),        RTF_DPFILLPAT},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_DPGROUP),      RTF_DPGROUP},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_DPLINE),       RTF_DPLINE},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_DPLINECOB),        RTF_DPLINECOB},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_DPLINECOG),        RTF_DPLINECOG},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_DPLINECOR),        RTF_DPLINECOR},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_DPLINEDADO),   RTF_DPLINEDADO},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_DPLINEDADODO), RTF_DPLINEDADODO},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_DPLINEDASH),   RTF_DPLINEDASH},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_DPLINEDOT),        RTF_DPLINEDOT},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_DPLINEGRAY),   RTF_DPLINEGRAY},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_DPLINEHOLLOW), RTF_DPLINEHOLLOW},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_DPLINEPAL),        RTF_DPLINEPAL},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_DPLINESOLID),  RTF_DPLINESOLID},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_DPLINEW),      RTF_DPLINEW},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_DPPOLYCOUNT),  RTF_DPPOLYCOUNT},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_DPPOLYGON),        RTF_DPPOLYGON},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_DPPOLYLINE),   RTF_DPPOLYLINE},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_DPPTX),            RTF_DPPTX},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_DPPTY),            RTF_DPPTY},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_DPRECT),       RTF_DPRECT},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_DPROUNDR),     RTF_DPROUNDR},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_DPSHADOW),     RTF_DPSHADOW},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_DPSHADX),      RTF_DPSHADX},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_DPSHADY),      RTF_DPSHADY},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_DPTXBX),       RTF_DPTXBX},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_DPTXBXMAR),        RTF_DPTXBXMAR},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_DPTXBXTEXT),   RTF_DPTXBXTEXT},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_DPX),          RTF_DPX},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_DPXSIZE),      RTF_DPXSIZE},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_DPY),          RTF_DPY},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_DPYSIZE),      RTF_DPYSIZE},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_DS),           RTF_DS},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_EMSPACE),      RTF_EMSPACE},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_ENSPACE),      RTF_ENSPACE},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_FBIDI),            RTF_FBIDI},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_FET),          RTF_FET},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_FID),          RTF_FID},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_FILE),         RTF_FILE},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_FILETBL),      RTF_FILETBL},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_FLDALT),       RTF_FLDALT},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_FNETWORK),     RTF_FNETWORK},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_FONTEMB),      RTF_FONTEMB},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_FONTFILE),     RTF_FONTFILE},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_FORMDISP),     RTF_FORMDISP},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_FORMPROT),     RTF_FORMPROT},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_FORMSHADE),        RTF_FORMSHADE},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_FOSNUM),       RTF_FOSNUM},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_FRELATIVE),        RTF_FRELATIVE},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_FTNALT),       RTF_FTNALT},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_FTNIL),            RTF_FTNIL},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_FTNNALC),      RTF_FTNNALC},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_FTNNAR),       RTF_FTNNAR},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_FTNNAUC),      RTF_FTNNAUC},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_FTNNCHI),      RTF_FTNNCHI},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_FTNNRLC),      RTF_FTNNRLC},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_FTNNRUC),      RTF_FTNNRUC},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_FTNRSTCONT),   RTF_FTNRSTCONT},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_FTNRSTPG),     RTF_FTNRSTPG},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_FTTRUETYPE),   RTF_FTTRUETYPE},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_FVALIDDOS),        RTF_FVALIDDOS},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_FVALIDHPFS),   RTF_FVALIDHPFS},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_FVALIDMAC),        RTF_FVALIDMAC},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_FVALIDNTFS),   RTF_FVALIDNTFS},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_HYPHAUTO),     RTF_HYPHAUTO},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_HYPHCAPS),     RTF_HYPHCAPS},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_HYPHCONSEC),   RTF_HYPHCONSEC},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_HYPHPAR),      RTF_HYPHPAR},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_LINKSELF),     RTF_LINKSELF},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_LINKSTYLES),   RTF_LINKSTYLES},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_LTRCH),            RTF_LTRCH},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_LTRDOC),       RTF_LTRDOC},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_LTRMARK),      RTF_LTRMARK},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_LTRPAR),       RTF_LTRPAR},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_LTRROW),       RTF_LTRROW},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_LTRSECT),      RTF_LTRSECT},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_NOCOLBAL),     RTF_NOCOLBAL},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_NOEXTRASPRL),  RTF_NOEXTRASPRL},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_NOTABIND),     RTF_NOTABIND},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_NOWIDCTLPAR),  RTF_NOWIDCTLPAR},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_OBJALIAS),     RTF_OBJALIAS},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_OBJALIGN),     RTF_OBJALIGN},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_OBJAUTLINK),   RTF_OBJAUTLINK},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_OBJCLASS),     RTF_OBJCLASS},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_OBJCROPB),     RTF_OBJCROPB},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_OBJCROPL),     RTF_OBJCROPL},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_OBJCROPR),     RTF_OBJCROPR},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_OBJCROPT),     RTF_OBJCROPT},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_OBJDATA),      RTF_OBJDATA},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_OBJECT),       RTF_OBJECT},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_OBJEMB),       RTF_OBJEMB},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_OBJH),         RTF_OBJH},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_OBJICEMB),     RTF_OBJICEMB},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_OBJLINK),      RTF_OBJLINK},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_OBJLOCK),      RTF_OBJLOCK},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_OBJNAME),      RTF_OBJNAME},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_OBJPUB),       RTF_OBJPUB},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_OBJSCALEX),        RTF_OBJSCALEX},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_OBJSCALEY),        RTF_OBJSCALEY},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_OBJSECT),      RTF_OBJSECT},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_OBJSETSIZE),   RTF_OBJSETSIZE},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_OBJSUB),       RTF_OBJSUB},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_OBJTIME),      RTF_OBJTIME},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_OBJTRANSY),        RTF_OBJTRANSY},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_OBJUPDATE),        RTF_OBJUPDATE},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_OBJW),         RTF_OBJW},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_OTBLRUL),      RTF_OTBLRUL},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_PGNHN),            RTF_PGNHN},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_PGNHNSC),      RTF_PGNHNSC},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_PGNHNSH),      RTF_PGNHNSH},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_PGNHNSM),      RTF_PGNHNSM},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_PGNHNSN),      RTF_PGNHNSN},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_PGNHNSP),      RTF_PGNHNSP},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_PICBMP),       RTF_PICBMP},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_PICBPP),       RTF_PICBPP},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_PN),           RTF_PN},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_PNACROSS),     RTF_PNACROSS},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_PNB),          RTF_PNB},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_PNCAPS),       RTF_PNCAPS},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_PNCARD),       RTF_PNCARD},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_PNCF),         RTF_PNCF},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_PNDEC),            RTF_PNDEC},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_PNF),          RTF_PNF},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_PNFS),         RTF_PNFS},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_PNHANG),       RTF_PNHANG},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_PNI),          RTF_PNI},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_PNINDENT),     RTF_PNINDENT},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_PNLCLTR),      RTF_PNLCLTR},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_PNLCRM),       RTF_PNLCRM},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_PNLVL),            RTF_PNLVL},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_PNLVLBLT),     RTF_PNLVLBLT},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_PNLVLBODY),        RTF_PNLVLBODY},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_PNLVLCONT),        RTF_PNLVLCONT},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_PNNUMONCE),        RTF_PNNUMONCE},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_PNORD),            RTF_PNORD},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_PNORDT),       RTF_PNORDT},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_PNPREV),       RTF_PNPREV},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_PNQC),         RTF_PNQC},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_PNQL),         RTF_PNQL},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_PNQR),         RTF_PNQR},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_PNRESTART),        RTF_PNRESTART},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_PNSCAPS),      RTF_PNSCAPS},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_PNSECLVL),     RTF_PNSECLVL},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_PNSP),         RTF_PNSP},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_PNSTART),      RTF_PNSTART},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_PNSTRIKE),     RTF_PNSTRIKE},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_PNTEXT),       RTF_PNTEXT},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_PNTXTA),       RTF_PNTXTA},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_PNTXTB),       RTF_PNTXTB},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_PNUCLTR),      RTF_PNUCLTR},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_PNUCRM),       RTF_PNUCRM},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_PNUL),         RTF_PNUL},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_PNULD),            RTF_PNULD},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_PNULDB),       RTF_PNULDB},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_PNULNONE),     RTF_PNULNONE},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_PNULW),            RTF_PNULW},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_PRCOLBL),      RTF_PRCOLBL},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_PRINTDATA),        RTF_PRINTDATA},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_PSZ),          RTF_PSZ},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_PUBAUTO),      RTF_PUBAUTO},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_RESULT),       RTF_RESULT},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_REVAUTH),      RTF_REVAUTH},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_REVDTTM),      RTF_REVDTTM},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_REVPROT),      RTF_REVPROT},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_REVTBL),       RTF_REVTBL},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_RSLTBMP),      RTF_RSLTBMP},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_RSLTMERGE),        RTF_RSLTMERGE},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_RSLTPICT),     RTF_RSLTPICT},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_RSLTRTF),      RTF_RSLTRTF},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_RSLTTXT),      RTF_RSLTTXT},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_RTLCH),            RTF_RTLCH},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_RTLDOC),       RTF_RTLDOC},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_RTLMARK),      RTF_RTLMARK},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_RTLPAR),       RTF_RTLPAR},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_RTLROW),       RTF_RTLROW},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_RTLSECT),      RTF_RTLSECT},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_SEC),          RTF_SEC},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_SECTNUM),      RTF_SECTNUM},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_SECTUNLOCKED), RTF_SECTUNLOCKED},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_SLMULT),       RTF_SLMULT},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_SOFTCOL),      RTF_SOFTCOL},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_SOFTLHEIGHT),  RTF_SOFTLHEIGHT},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_SOFTLINE),     RTF_SOFTLINE},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_SOFTPAGE),     RTF_SOFTPAGE},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_SPRSSPBF),     RTF_SPRSSPBF},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_SPRSTSP),      RTF_SPRSTSP},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_SUBDOCUMENT),  RTF_SUBDOCUMENT},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_SWPBDR),       RTF_SWPBDR},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_TCN),          RTF_TCN},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_TRANSMF),      RTF_TRANSMF},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_TRBRDRB),      RTF_TRBRDRB},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_TRBRDRH),      RTF_TRBRDRH},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_TRBRDRL),      RTF_TRBRDRL},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_TRBRDRR),      RTF_TRBRDRR},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_TRBRDRT),      RTF_TRBRDRT},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_TRBRDRV),      RTF_TRBRDRV},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_TRHDR),            RTF_TRHDR},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_TRKEEP),       RTF_TRKEEP},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_TRPADDB),      RTF_TRPADDB},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_TRPADDL),      RTF_TRPADDL},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_TRPADDR),      RTF_TRPADDR},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_TRPADDT),      RTF_TRPADDT},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_TRPADDFB),      RTF_TRPADDFB},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_TRPADDFL),      RTF_TRPADDFL},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_TRPADDFR),      RTF_TRPADDFR},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_TRPADDFT),      RTF_TRPADDFT},


{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_WRAPTRSP),     RTF_WRAPTRSP},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_XEF),          RTF_XEF},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_ZWJ),          RTF_ZWJ},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_ZWNJ),         RTF_ZWNJ},


{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_ABSLOCK),      RTF_ABSLOCK},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_ADJUSTRIGHT),  RTF_ADJUSTRIGHT},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_AFTNNCHOSUNG), RTF_AFTNNCHOSUNG},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_AFTNNCNUM),        RTF_AFTNNCNUM},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_AFTNNDBAR),        RTF_AFTNNDBAR},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_AFTNNDBNUM),   RTF_AFTNNDBNUM},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_AFTNNDBNUMD),  RTF_AFTNNDBNUMD},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_AFTNNDBNUMK),  RTF_AFTNNDBNUMK},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_AFTNNDBNUMT),  RTF_AFTNNDBNUMT},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_AFTNNGANADA),  RTF_AFTNNGANADA},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_AFTNNGBNUM),   RTF_AFTNNGBNUM},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_AFTNNGBNUMD),  RTF_AFTNNGBNUMD},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_AFTNNGBNUMK),  RTF_AFTNNGBNUMK},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_AFTNNGBNUML),  RTF_AFTNNGBNUML},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_AFTNNZODIAC),  RTF_AFTNNZODIAC},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_AFTNNZODIACD), RTF_AFTNNZODIACD},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_AFTNNZODIACL), RTF_AFTNNZODIACL},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_ANIMTEXT),     RTF_ANIMTEXT},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_ANSICPG),      RTF_ANSICPG},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_BACKGROUND),   RTF_BACKGROUND},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_BDBFHDR),      RTF_BDBFHDR},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_BLIPTAG),      RTF_BLIPTAG},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_BLIPUID),      RTF_BLIPUID},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_BLIPUPI),      RTF_BLIPUPI},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_BRDRART),      RTF_BRDRART},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_BRDRDASHD),        RTF_BRDRDASHD},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_BRDRDASHDD),   RTF_BRDRDASHDD},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_BRDRDASHDOTSTR),RTF_BRDRDASHDOTSTR},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_BRDRDASHSM),   RTF_BRDRDASHSM},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_BRDRINSET),    RTF_BRDRINSET},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_BRDROUTSET),   RTF_BRDROUTSET},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_BRDREMBOSS),   RTF_BRDREMBOSS},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_BRDRENGRAVE),  RTF_BRDRENGRAVE},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_BRDRFRAME),        RTF_BRDRFRAME},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_BRDRTHTNLG),   RTF_BRDRTHTNLG},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_BRDRTHTNMG),   RTF_BRDRTHTNMG},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_BRDRTHTNSG),   RTF_BRDRTHTNSG},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_BRDRTNTHLG),   RTF_BRDRTNTHLG},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_BRDRTNTHMG),   RTF_BRDRTNTHMG},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_BRDRTNTHSG),   RTF_BRDRTNTHSG},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_BRDRTNTHTNLG), RTF_BRDRTNTHTNLG},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_BRDRTNTHTNMG), RTF_BRDRTNTHTNMG},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_BRDRTNTHTNSG), RTF_BRDRTNTHTNSG},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_BRDRTRIPLE),   RTF_BRDRTRIPLE},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_BRDRWAVY),     RTF_BRDRWAVY},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_BRDRWAVYDB),   RTF_BRDRWAVYDB},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_CATEGORY),     RTF_CATEGORY},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_CGRID),            RTF_CGRID},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_CHARSCALEX),   RTF_CHARSCALEX},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_CHBGBDIAG),        RTF_CHBGBDIAG},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_CHBGCROSS),        RTF_CHBGCROSS},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_CHBGDCROSS),   RTF_CHBGDCROSS},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_CHBGDKBDIAG),  RTF_CHBGDKBDIAG},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_CHBGDKCROSS),  RTF_CHBGDKCROSS},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_CHBGDKDCROSS), RTF_CHBGDKDCROSS},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_CHBGDKFDIAG),  RTF_CHBGDKFDIAG},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_CHBGDKHORIZ),  RTF_CHBGDKHORIZ},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_CHBGDKVERT),   RTF_CHBGDKVERT},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_CHBGFDIAG),        RTF_CHBGFDIAG},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_CHBGHORIZ),        RTF_CHBGHORIZ},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_CHBGVERT),     RTF_CHBGVERT},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_CHBRDR),       RTF_CHBRDR},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_CHCBPAT),      RTF_CHCBPAT},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_CHCFPAT),      RTF_CHCFPAT},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_CHSHDNG),      RTF_CHSHDNG},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_CLTXLRTB),     RTF_CLTXLRTB},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_CLTXTBRL),     RTF_CLTXTBRL},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_CLVERTALB),        RTF_CLVERTALB},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_CLVERTALC),        RTF_CLVERTALC},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_CLVERTALT),        RTF_CLVERTALT},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_CLVMGF),       RTF_CLVMGF},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_CLVMRG),       RTF_CLVMRG},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_CLTXTBRLV),    RTF_CLTXTBRLV},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_CLTXBTLR),         RTF_CLTXBTLR},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_CLTXLRTBV),        RTF_CLTXLRTBV},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_COMPANY),      RTF_COMPANY},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_CRAUTH),       RTF_CRAUTH},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_CRDATE),       RTF_CRDATE},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_DATE),         RTF_DATE},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_DEFLANGFE),        RTF_DEFLANGFE},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_DFRAUTH),      RTF_DFRAUTH},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_DFRDATE),      RTF_DFRDATE},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_DFRSTART),     RTF_DFRSTART},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_DFRSTOP),      RTF_DFRSTOP},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_DFRXST),       RTF_DFRXST},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_DGMARGIN),     RTF_DGMARGIN},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_DNTBLNSBDB),   RTF_DNTBLNSBDB},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_DOCTYPE),      RTF_DOCTYPE},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_DOCVAR),       RTF_DOCVAR},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_DPCODESCENT),  RTF_DPCODESCENT},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_EMBO),         RTF_EMBO},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_EMFBLIP),      RTF_EMFBLIP},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_EXPSHRTN),     RTF_EXPSHRTN},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_FAAUTO),       RTF_FAAUTO},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_FBIAS),            RTF_FBIAS},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_FFDEFRES),     RTF_FFDEFRES},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_FFDEFTEXT),        RTF_FFDEFTEXT},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_FFENTRYMCR),   RTF_FFENTRYMCR},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_FFEXITMCR),        RTF_FFEXITMCR},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_FFFORMAT),     RTF_FFFORMAT},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_FFHASLISTBOX), RTF_FFHASLISTBOX},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_FFHELPTEXT),   RTF_FFHELPTEXT},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_FFHPS),            RTF_FFHPS},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_FFL),          RTF_FFL},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_FFMAXLEN),     RTF_FFMAXLEN},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_FFNAME),       RTF_FFNAME},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_FFOWNHELP),        RTF_FFOWNHELP},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_FFOWNSTAT),        RTF_FFOWNSTAT},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_FFPROT),       RTF_FFPROT},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_FFRECALC),     RTF_FFRECALC},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_FFRES),            RTF_FFRES},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_FFSIZE),       RTF_FFSIZE},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_FFSTATTEXT),   RTF_FFSTATTEXT},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_FFTYPE),       RTF_FFTYPE},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_FFTYPETXT),        RTF_FFTYPETXT},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_FLDTYPE),      RTF_FLDTYPE},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_FNAME),            RTF_FNAME},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_FORMFIELD),        RTF_FORMFIELD},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_FROMTEXT),     RTF_FROMTEXT},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_FTNNCHOSUNG),  RTF_FTNNCHOSUNG},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_FTNNCNUM),     RTF_FTNNCNUM},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_FTNNDBAR),     RTF_FTNNDBAR},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_FTNNDBNUM),        RTF_FTNNDBNUM},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_FTNNDBNUMD),   RTF_FTNNDBNUMD},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_FTNNDBNUMK),   RTF_FTNNDBNUMK},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_FTNNDBNUMT),   RTF_FTNNDBNUMT},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_FTNNGANADA),   RTF_FTNNGANADA},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_FTNNGBNUM),        RTF_FTNNGBNUM},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_FTNNGBNUMD),   RTF_FTNNGBNUMD},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_FTNNGBNUMK),   RTF_FTNNGBNUMK},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_FTNNGBNUML),   RTF_FTNNGBNUML},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_FTNNZODIAC),   RTF_FTNNZODIAC},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_FTNNZODIACD),  RTF_FTNNZODIACD},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_FTNNZODIACL),  RTF_FTNNZODIACL},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_G),                RTF_G},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_GCW),          RTF_GCW},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_GRIDTBL),      RTF_GRIDTBL},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_HIGHLIGHT),        RTF_HIGHLIGHT},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_HLFR),         RTF_HLFR},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_HLINKBASE),        RTF_HLINKBASE},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_HLLOC),            RTF_HLLOC},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_HLSRC),            RTF_HLSRC},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_ILVL),         RTF_ILVL},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_IMPR),         RTF_IMPR},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_JPEGBLIP),     RTF_JPEGBLIP},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_LEVELFOLLOW),  RTF_LEVELFOLLOW},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_LEVELINDENT),  RTF_LEVELINDENT},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_LEVELJC),      RTF_LEVELJC},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_LEVELLEGAL),   RTF_LEVELLEGAL},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_LEVELNFC),     RTF_LEVELNFC},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_LEVELNORESTART),RTF_LEVELNORESTART},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_LEVELNUMBERS), RTF_LEVELNUMBERS},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_LEVELOLD),     RTF_LEVELOLD},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_LEVELPREV),        RTF_LEVELPREV},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_LEVELPREVSPACE),RTF_LEVELPREVSPACE},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_LEVELSPACE),   RTF_LEVELSPACE},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_LEVELSTARTAT), RTF_LEVELSTARTAT},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_LEVELTEXT),        RTF_LEVELTEXT},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_LINKVAL),      RTF_LINKVAL},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_LIST),         RTF_LIST},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_LISTID),       RTF_LISTID},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_LISTLEVEL),     RTF_LISTLEVEL},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_LISTNAME),     RTF_LISTNAME},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_LISTOVERRIDE), RTF_LISTOVERRIDE},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_LISTOVERRIDECOUNT),        RTF_LISTOVERRIDECOUNT},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_LISTOVERRIDEFORMAT),   RTF_LISTOVERRIDEFORMAT},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_LISTOVERRIDESTART),        RTF_LISTOVERRIDESTART},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_LISTOVERRIDETABLE),        RTF_LISTOVERRIDETABLE},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_LISTRESTARTHDN),RTF_LISTRESTARTHDN},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_LISTSIMPLE),   RTF_LISTSIMPLE},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_LISTTABLE),        RTF_LISTTABLE},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_LISTTEMPLATEID),RTF_LISTTEMPLATEID},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_LISTTEXT),     RTF_LISTTEXT},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_LS),           RTF_LS},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_LYTEXCTTP),        RTF_LYTEXCTTP},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_LYTPRTMET),        RTF_LYTPRTMET},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_MANAGER),      RTF_MANAGER},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_MSMCAP),       RTF_MSMCAP},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_NOFCHARSWS),   RTF_NOFCHARSWS},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_NOLEAD),       RTF_NOLEAD},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_NONSHPPICT),   RTF_NONSHPPICT},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_NOSECTEXPAND), RTF_NOSECTEXPAND},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_NOSNAPLINEGRID),RTF_NOSNAPLINEGRID},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_NOSPACEFORUL), RTF_NOSPACEFORUL},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_NOULTRLSPC),   RTF_NOULTRLSPC},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_NOXLATTOYEN),  RTF_NOXLATTOYEN},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_OBJATTPH),     RTF_OBJATTPH},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_OBJHTML),      RTF_OBJHTML},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_OBJOCX),       RTF_OBJOCX},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_OLDLINEWRAP),  RTF_OLDLINEWRAP},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_OUTLINELEVEL), RTF_OUTLINELEVEL},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_OVERLAY),      RTF_OVERLAY},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_PANOSE),       RTF_PANOSE},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_PGBRDRB),      RTF_PGBRDRB},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_PGBRDRFOOT),   RTF_PGBRDRFOOT},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_PGBRDRHEAD),   RTF_PGBRDRHEAD},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_PGBRDRL),      RTF_PGBRDRL},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_PGBRDROPT),        RTF_PGBRDROPT},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_PGBRDRR),      RTF_PGBRDRR},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_PGBRDRSNAP),   RTF_PGBRDRSNAP},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_PGBRDRT),      RTF_PGBRDRT},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_PGNCHOSUNG),   RTF_PGNCHOSUNG},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_PGNCNUM),      RTF_PGNCNUM},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_PGNDBNUMK),        RTF_PGNDBNUMK},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_PGNDBNUMT),        RTF_PGNDBNUMT},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_PGNGANADA),        RTF_PGNGANADA},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_PGNGBNUM),     RTF_PGNGBNUM},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_PGNGBNUMD),        RTF_PGNGBNUMD},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_PGNGBNUMK),        RTF_PGNGBNUMK},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_PGNGBNUML),        RTF_PGNGBNUML},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_PGNZODIAC),        RTF_PGNZODIAC},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_PGNZODIACD),   RTF_PGNZODIACD},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_PGNZODIACL),   RTF_PGNZODIACL},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_PICPROP),      RTF_PICPROP},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_PNAIUEO),      RTF_PNAIUEO},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_PNAIUEOD),     RTF_PNAIUEOD},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_PNCHOSUNG),        RTF_PNCHOSUNG},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_PNDBNUMD),     RTF_PNDBNUMD},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_PNDBNUMK),     RTF_PNDBNUMK},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_PNDBNUML),     RTF_PNDBNUML},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_PNDBNUMT),     RTF_PNDBNUMT},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_PNGANADA),     RTF_PNGANADA},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_PNGBLIP),      RTF_PNGBLIP},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_PNGBNUM),      RTF_PNGBNUM},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_PNGBNUMD),     RTF_PNGBNUMD},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_PNGBNUMK),     RTF_PNGBNUMK},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_PNGBNUML),     RTF_PNGBNUML},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_PNRAUTH),      RTF_PNRAUTH},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_PNRDATE),      RTF_PNRDATE},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_PNRNFC),       RTF_PNRNFC},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_PNRNOT),       RTF_PNRNOT},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_PNRPNBR),      RTF_PNRPNBR},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_PNRRGB),       RTF_PNRRGB},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_PNRSTART),     RTF_PNRSTART},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_PNRSTOP),      RTF_PNRSTOP},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_PNRXST),       RTF_PNRXST},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_PNZODIAC),     RTF_PNZODIAC},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_PNZODIACD),        RTF_PNZODIACD},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_PNZODIACL),        RTF_PNZODIACL},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_LFOLEVEL),     RTF_LFOLEVEL},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_POSYIN),       RTF_POSYIN},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_POSYOUT),      RTF_POSYOUT},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_PRIVATE),      RTF_PRIVATE},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_PROPNAME),     RTF_PROPNAME},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_PROPTYPE),     RTF_PROPTYPE},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_REVAUTHDEL),   RTF_REVAUTHDEL},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_REVDTTMDEL),   RTF_REVDTTMDEL},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_SAUTOUPD),     RTF_SAUTOUPD},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_SECTDEFAULTCL),    RTF_SECTDEFAULTCL},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_SECTEXPAND),   RTF_SECTEXPAND},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_SECTLINEGRID), RTF_SECTLINEGRID},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_SECTSPECIFYCL),    RTF_SECTSPECIFYCL},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_SECTSPECIFYL), RTF_SECTSPECIFYL},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_SHIDDEN),      RTF_SHIDDEN},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_SHPBOTTOM),        RTF_SHPBOTTOM},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_SHPBXCOLUMN),  RTF_SHPBXCOLUMN},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_SHPBXMARGIN),  RTF_SHPBXMARGIN},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_SHPBXPAGE),        RTF_SHPBXPAGE},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_SHPBYMARGIN),  RTF_SHPBYMARGIN},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_SHPBYPAGE),        RTF_SHPBYPAGE},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_SHPBYPARA),        RTF_SHPBYPARA},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_SHPFBLWTXT),   RTF_SHPFBLWTXT},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_SHPFHDR),      RTF_SHPFHDR},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_SHPGRP),       RTF_SHPGRP},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_SHPINST),      RTF_SHPINST},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_SHPLEFT),      RTF_SHPLEFT},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_SHPLID),       RTF_SHPLID},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_SHPLOCKANCHOR),    RTF_SHPLOCKANCHOR},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_SHPPICT),      RTF_SHPPICT},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_SHPRIGHT),     RTF_SHPRIGHT},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_SHPRSLT),      RTF_SHPRSLT},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_SHPTOP),       RTF_SHPTOP},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_SHPTXT),       RTF_SHPTXT},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_SHPWRK),       RTF_SHPWRK},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_SHPWR),            RTF_SHPWR},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_SHPZ),         RTF_SHPZ},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_SPRSBSP),      RTF_SPRSBSP},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_SPRSLNSP),     RTF_SPRSLNSP},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_SPRSTSM),      RTF_SPRSTSM},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_STATICVAL),        RTF_STATICVAL},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_STEXTFLOW),        RTF_STEXTFLOW},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_STRIKED),      RTF_STRIKED},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_SUBFONTBYSIZE),    RTF_SUBFONTBYSIZE},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_TCELLD),       RTF_TCELLD},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_TIME),         RTF_TIME},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_TRUNCATEFONTHEIGHT),   RTF_TRUNCATEFONTHEIGHT},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_UC),           RTF_UC},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_UD),           RTF_UD},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_ULDASH),       RTF_ULDASH},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_ULDASHD),      RTF_ULDASHD},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_ULDASHDD),     RTF_ULDASHDD},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_ULTH),         RTF_ULTH},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_ULWAVE),       RTF_ULWAVE},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_ULC),          RTF_ULC},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_U),                RTF_U},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_UPR),          RTF_UPR},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_USERPROPS),        RTF_USERPROPS},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_VIEWKIND),     RTF_VIEWKIND},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_VIEWSCALE),        RTF_VIEWSCALE},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_VIEWZK),       RTF_VIEWZK},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_WIDCTLPAR),        RTF_WIDCTLPAR},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_WINDOWCAPTION),    RTF_WINDOWCAPTION},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_WPEQN),            RTF_WPEQN},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_WPJST),            RTF_WPJST},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_WPSP),         RTF_WPSP},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_YXE),          RTF_YXE},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_FRMTXLRTB),    RTF_FRMTXLRTB},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_FRMTXTBRL),    RTF_FRMTXTBRL},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_FRMTXBTLR),    RTF_FRMTXBTLR},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_FRMTXLRTBV),   RTF_FRMTXLRTBV},
{std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_FRMTXTBRLV),   RTF_FRMTXTBRLV},

// MS-2000 Tokens
        {std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_ULTHD),         RTF_ULTHD},
        {std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_ULTHDASH),      RTF_ULTHDASH},
        {std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_ULLDASH),       RTF_ULLDASH},
        {std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_ULTHLDASH),     RTF_ULTHLDASH},
        {std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_ULTHDASHD),     RTF_ULTHDASHD},
        {std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_ULTHDASHDD),    RTF_ULTHDASHDD},
        {std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_ULHWAVE),       RTF_ULHWAVE},
        {std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_ULULDBWAVE),    RTF_ULULDBWAVE},

        {std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_LOCH),         RTF_LOCH},
        {std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_HICH),         RTF_HICH},
        {std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_DBCH),         RTF_DBCH},
        {std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_LANGFE),       RTF_LANGFE},
        {std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_ADEFLANG),     RTF_ADEFLANG},
        {std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_ADEFF),            RTF_ADEFF},
        {std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_ACCNONE),      RTF_ACCNONE},
        {std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_ACCDOT),       RTF_ACCDOT},
        {std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_ACCCOMMA),     RTF_ACCCOMMA},
        {std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_TWOINONE),     RTF_TWOINONE},
        {std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_HORZVERT),     RTF_HORZVERT},
        {std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_FAHANG),       RTF_FAHANG},
        {std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_FAVAR),            RTF_FAVAR},
        {std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_FACENTER),     RTF_FACENTER},
        {std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_FAROMAN),      RTF_FAROMAN},
        {std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_FAFIXED),      RTF_FAFIXED},
        {std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_NOCWRAP),       RTF_NOCWRAP},
        {std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_NOOVERFLOW),    RTF_NOOVERFLOW},
        {std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_ASPALPHA),      RTF_ASPALPHA},

// SWG specific attributes
        {std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_GRFALIGNV),     RTF_GRF_ALIGNV},
        {std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_GRFALIGNH),     RTF_GRF_ALIGNH},
        {std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_GRFMIRROR),     RTF_GRF_MIRROR},
        {std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_HEADERYB),      RTF_HEADER_YB},
        {std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_HEADERXL),      RTF_HEADER_XL},
        {std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_HEADERXR),      RTF_HEADER_XR},
        {std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_FOOTERYT),      RTF_FOOTER_YT},
        {std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_FOOTERXL),      RTF_FOOTER_XL},
        {std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_FOOTERXR),      RTF_FOOTER_XR},
        {std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_HEADERYH),      RTF_HEADER_YH},
        {std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_FOOTERYH),      RTF_FOOTER_YH},
        {std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_BALANCEDCOLUMN),RTF_BALANCED_COLUMN},
        {std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_UPDNPROP),      RTF_SWG_ESCPROP},
        {std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_PRTDATA),       RTF_SWG_PRTDATA},
        {std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_BKMKKEY),       RTF_BKMK_KEY},

// Attributes for fly frames
        {std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_FLYPRINT),      RTF_FLYPRINT},
        {std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_FLYOPAQUE),     RTF_FLYOPAQUE},
        {std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_FLYPRTCTD),     RTF_FLYPRTCTD},
        {std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_FLYMAINCNT),    RTF_FLYMAINCNT},
        {std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_FLYVERT),       RTF_FLYVERT},
        {std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_FLYHORZ),       RTF_FLYHORZ},
        {std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_DFRMTXTL),      RTF_FLYOUTLEFT},
        {std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_DFRMTXTR),      RTF_FLYOUTRIGHT},
        {std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_DFRMTXTU),      RTF_FLYOUTUPPER},
        {std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_DFRMTXTW),      RTF_FLYOUTLOWER},
        {std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_FLYANCHOR),     RTF_FLYANCHOR},
        {std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_FLYCNTNT),      RTF_FLY_CNTNT},
        {std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_FLYCOLUMN),     RTF_FLY_COLUMN},
        {std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_FLYPAGE),       RTF_FLY_PAGE},

        {std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_BRDBOX),        RTF_BRDBOX},
        {std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_BRDLNCOL),      RTF_BRDLINE_COL},
        {std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_BRDLNIN),       RTF_BRDLINE_IN},
        {std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_BRDLNOUT),      RTF_BRDLINE_OUT},
        {std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_BRDLNDIST),     RTF_BRDLINE_DIST},

        {std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_SHADOW),        RTF_SHADOW},
        {std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_SHDWDIST),      RTF_SHDW_DIST},
        {std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_SHDWSTYLE),     RTF_SHDW_STYLE},
        {std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_SHDWCOL),       RTF_SHDW_COL},
        {std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_SHDWFCOL),      RTF_SHDW_FCOL},

        {std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_FLYINPARA),     RTF_FLY_INPARA},

        {std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_PGDSCTBL),      RTF_PGDSCTBL},
        {std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_PGDSC),         RTF_PGDSC},
        {std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_PGDSCUSE),      RTF_PGDSCUSE},
        {std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_PGDSCNXT),      RTF_PGDSCNXT},

        {std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_HYPHEN),        RTF_HYPHEN},
        {std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_HYPHLEAD),      RTF_HYPHLEAD},
        {std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_HYPHTRAIL),     RTF_HYPHTRAIL},
        {std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_HYPHMAX),       RTF_HYPHMAX},

        {std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_TLSWG),         RTF_TLSWG},
        {std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_PGBRK),         RTF_PGBRK},

        {std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_PGDSCNO),       RTF_PGDSCNO},
        {std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_SOUTLVL),       RTF_SOUTLVL},

        {std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_SHP),       RTF_SHP},
        /*
        {OUStringLiteral(OOO_STRING_SVTOOLS_RTF_SHPLEFT),       RTF_SHPLEFT}
        {OUStringLiteral(OOO_STRING_SVTOOLS_RTF_SHPTOP),       RTF_SHPTOP}
        {OUStringLiteral(OOO_STRING_SVTOOLS_RTF_SHPBOTTOM),       RTF_SHPBOTTOM}
        {OUStringLiteral(OOO_STRING_SVTOOLS_RTF_SHPRIGHT),       RTF_SHPRIGHT}
        */
        {std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_SN),       RTF_SN},
        {std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_SV),       RTF_SV},
        {std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_SP),       RTF_SP},

// Support for overline attributes
        {std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_OL),           RTF_OL},
        {std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_OLW),          RTF_OLW},
        {std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_OLD),          RTF_OLD},
        {std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_OLDB),         RTF_OLDB},
        {std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_OLNONE),       RTF_OLNONE},
        {std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_OLDASH),       RTF_OLDASH},
        {std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_OLDASHD),      RTF_OLDASHD},
        {std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_OLDASHDD),     RTF_OLDASHDD},
        {std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_OLTH),         RTF_OLTH},
        {std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_OLWAVE),       RTF_OLWAVE},
        {std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_OLC),          RTF_OLC},
        {std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_OLTHD),            RTF_OLTHD},
        {std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_OLTHDASH),     RTF_OLTHDASH},
        {std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_OLLDASH),      RTF_OLLDASH},
        {std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_OLTHLDASH),        RTF_OLTHLDASH},
        {std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_OLTHDASHD),        RTF_OLTHDASHD},
        {std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_OLTHDASHDD),   RTF_OLTHDASHDD},
        {std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_OLHWAVE),      RTF_OLHWAVE},
        {std::u16string_view(u"" OOO_STRING_SVTOOLS_RTF_OLOLDBWAVE),   RTF_OLOLDBWAVE}
};


int GetRTFToken( const OUString& rSearch )
{
    if( !bSortKeyWords )
    {
        std::sort( std::begin(aRTFTokenTab), std::end(aRTFTokenTab),
                    [](const RTF_TokenEntry & lhs, const RTF_TokenEntry & rhs)
                    {
                        return lhs.sToken < rhs.sToken;
                    } );
        bSortKeyWords = true;
    }

    auto findCompare = [](const RTF_TokenEntry & lhs, const OUString & s)
        {
            return s.compareToIgnoreAsciiCase(lhs.sToken) > 0;
        };
    auto findIt = std::lower_bound( std::begin(aRTFTokenTab), std::end(aRTFTokenTab), rSearch, findCompare);
    if (findIt != std::end(aRTFTokenTab) && rSearch.compareToIgnoreAsciiCase(findIt->sToken)==0)
        return findIt->nToken;

    return 0;
}

/* vim:set shiftwidth=4 softtabstop=4 expandtab: */
