#include <gio/gio.h>

#include "unity-webapps-application-collector.h"
#include "unity-webapps-local-url-index.h"
#include "unity-webapps-debug.h"

typedef struct _ManifestTestFixture {
  UnityWebappsApplicationCollector *collector;
  UnityWebappsLocalUrlIndex *index;
} ManifestTestFixture;


static void
setup_fixture_simple (ManifestTestFixture *fixture, gconstpointer user_data)
{
  const gchar *path[] = {TEST_DATA, NULL};
  fixture->collector = unity_webapps_application_collector_new (path);
  fixture->index = (UnityWebappsLocalUrlIndex *) unity_webapps_local_url_index_new (fixture->collector);
  
  g_assert (unity_webapps_local_url_index_load_applications (fixture->index));
}


static void
teardown_fixture_simple (ManifestTestFixture *fixture, gconstpointer user_data)
{
  g_object_unref (G_OBJECT (fixture->index));
}

static void
test_query_simple_collection_1 (ManifestTestFixture *fixture, gconstpointer user_data)
{
  GList *applications;
  UnityWebappsAvailableApplication *app;
  
  applications = unity_webapps_url_index_lookup_url (UNITY_WEBAPPS_URL_INDEX (fixture->index), "https://docs.google.com/");
  g_assert (g_list_length (applications) == 1);
  
  app = (UnityWebappsAvailableApplication *)applications->data;
  
  g_assert_cmpstr ("unity-webapps-google-docs", ==, unity_webapps_available_application_get_name (app));
}

int 
main (int argc, char **argv)
{
  g_type_init ();
  g_test_init (&argc, &argv, NULL);
  
  unity_webapps_debug_initialize_flags ();
  
  g_test_add("/Applications/Index/Local/Query", ManifestTestFixture, NULL,
	     setup_fixture_simple, test_query_simple_collection_1, teardown_fixture_simple);
  
  return g_test_run ();
}
