/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.standard;

import java.util.Set;
import org.jhotdraw.framework.Drawing;
import org.jhotdraw.framework.Figure;
import org.jhotdraw.framework.FigureChangeListener;
import org.jhotdraw.framework.FigureEnumeration;
import org.jhotdraw.framework.FigureVisitor;
import org.jhotdraw.framework.Handle;
import org.jhotdraw.standard.FigureEnumerator;
import org.jhotdraw.util.CollectionsFactory;

public class InsertIntoDrawingVisitor
implements FigureVisitor {
    private Set myInsertedFigures = CollectionsFactory.current().createSet();
    private Drawing myDrawing;

    public InsertIntoDrawingVisitor(Drawing drawing) {
        this.setDrawing(drawing);
    }

    private void setDrawing(Drawing drawing) {
        this.myDrawing = drawing;
    }

    protected Drawing getDrawing() {
        return this.myDrawing;
    }

    public void visitFigure(Figure figure) {
        if (!this.myInsertedFigures.contains(figure) && !this.getDrawing().includes(figure)) {
            Figure figure2 = this.getDrawing().add(figure);
            this.myInsertedFigures.add(figure2);
        }
    }

    public void visitHandle(Handle handle) {
    }

    public void visitFigureChangeListener(FigureChangeListener figureChangeListener) {
    }

    public FigureEnumeration getInsertedFigures() {
        return new FigureEnumerator(this.myInsertedFigures);
    }
}

