//------------------------------------------------------------------------------
// <copyright file="AutoGeneratedFieldProperties.cs" company="Microsoft">
//     Copyright (c) Microsoft Corporation.  All rights reserved.
// </copyright>                                                                
//------------------------------------------------------------------------------

namespace System.Web.UI.WebControls {

    using System;
    using System.ComponentModel;
    using System.Reflection;
    using System.Web.Util;

    /// <devdoc>
    ///    <para>
    ///       Stores the properties for an AutoGeneratedField.
    ///    </para>
    /// </devdoc>
    public sealed class AutoGeneratedFieldProperties : IStateManager {
        private bool _isTracking;
        private StateBag _statebag;


        public AutoGeneratedFieldProperties() {
            _statebag = new StateBag();
        }
                

        public string DataField {
            get {
                object o = ViewState["DataField"];
                if (o != null) {
                    return (string)o;
                }
                return String.Empty;
            }
            set {
                ViewState["DataField"] = value;
            }
        }


        public bool IsReadOnly {
            get {
                object o = ViewState["IsReadOnly"];
                if (o != null) {
                    return (bool)o;
                }
                return false;
            }
            set {
                ViewState["IsReadOnly"] = value;
            }
        }
        

        public string Name {
            get {
                object o = ViewState["Name"];
                if (o != null) {
                    return (string)o;
                }
                return String.Empty;
            }
            set {
                ViewState["Name"] = value;
            }
        }


        public Type Type {
            get {
                object o = ViewState["Type"];
                if (o != null) {
                    return (Type)o;
                }
                return null;
            }
            set {
                ViewState["Type"] = value;
            }
        }

        /// <devdoc>
        /// <para>Gets the statebag for the AutoGeneratedFieldProperties. This property is read-only.</para>
        /// </devdoc>
        private StateBag ViewState {
            get {
                return _statebag;
            }
        }


        #region IStateManager implementation

        /// <internalonly/>
        bool IStateManager.IsTrackingViewState {
            get {
                return _isTracking;
            }
        }


        /// <internalonly/>
        void IStateManager.LoadViewState(object state) {
            if (state != null) {
                ((IStateManager)ViewState).LoadViewState(state);
            }
        }


        /// <internalonly/>
        object IStateManager.SaveViewState() {
            object state = ((IStateManager)ViewState).SaveViewState();
            return state;
        }


        /// <internalonly/>
        void IStateManager.TrackViewState() {
            _isTracking = true;
            ViewState.TrackViewState();
        }
        #endregion
    }
}

