// WARNING: This file is auto-generated by crates/ast/generate_ast.py.

use crate::SourceLocation;
use crate::arena;
use crate::types::*;
use std::borrow::{Borrow, BorrowMut};

pub trait SourceLocationAccessor {
    fn set_loc(&mut self, start: SourceLocation, end: SourceLocation);
    fn get_loc(&self) -> SourceLocation;
}
impl<'alloc> SourceLocationAccessor for Argument<'alloc> {
    fn set_loc(&mut self, start: SourceLocation, end: SourceLocation) {
        match self {
            Argument::SpreadElement(content) => { content.set_loc(start, end) }
            Argument::Expression(content) => { content.set_loc(start, end) }
        }
    }

    fn get_loc(&self) -> SourceLocation {
        match self {
            Argument::SpreadElement(content) => { content.get_loc() }
            Argument::Expression(content) => { content.get_loc() }
        }
    }
}

impl<'alloc> SourceLocationAccessor for Arguments<'alloc> {
    fn set_loc(&mut self, start: SourceLocation, end: SourceLocation) {
        self.loc.start = start.start;
        self.loc.end = end.end;
    }

    fn get_loc(&self) -> SourceLocation {
        self.loc
    }
}

impl<'alloc> SourceLocationAccessor for ArrayAssignmentTarget<'alloc> {
    fn set_loc(&mut self, start: SourceLocation, end: SourceLocation) {
        self.loc.start = start.start;
        self.loc.end = end.end;
    }

    fn get_loc(&self) -> SourceLocation {
        self.loc
    }
}

impl<'alloc> SourceLocationAccessor for ArrayBinding<'alloc> {
    fn set_loc(&mut self, start: SourceLocation, end: SourceLocation) {
        self.loc.start = start.start;
        self.loc.end = end.end;
    }

    fn get_loc(&self) -> SourceLocation {
        self.loc
    }
}

impl<'alloc> SourceLocationAccessor for ArrayExpression<'alloc> {
    fn set_loc(&mut self, start: SourceLocation, end: SourceLocation) {
        self.loc.start = start.start;
        self.loc.end = end.end;
    }

    fn get_loc(&self) -> SourceLocation {
        self.loc
    }
}

impl<'alloc> SourceLocationAccessor for ArrayExpressionElement<'alloc> {
    fn set_loc(&mut self, start: SourceLocation, end: SourceLocation) {
        match self {
            ArrayExpressionElement::SpreadElement(content) => { content.set_loc(start, end) }
            ArrayExpressionElement::Expression(content) => { content.set_loc(start, end) }
            ArrayExpressionElement::Elision { mut loc } => {
                loc.start = start.start;
                loc.end = end.end;
            }
        }
    }

    fn get_loc(&self) -> SourceLocation {
        match self {
            ArrayExpressionElement::SpreadElement(content) => { content.get_loc() }
            ArrayExpressionElement::Expression(content) => { content.get_loc() }
            ArrayExpressionElement::Elision { loc } => {
                *loc
            }
        }
    }
}

impl<'alloc> SourceLocationAccessor for ArrowExpressionBody<'alloc> {
    fn set_loc(&mut self, start: SourceLocation, end: SourceLocation) {
        match self {
            ArrowExpressionBody::FunctionBody(content) => { content.set_loc(start, end) }
            ArrowExpressionBody::Expression(content) => { content.set_loc(start, end) }
        }
    }

    fn get_loc(&self) -> SourceLocation {
        match self {
            ArrowExpressionBody::FunctionBody(content) => { content.get_loc() }
            ArrowExpressionBody::Expression(content) => { content.get_loc() }
        }
    }
}

impl<'alloc> SourceLocationAccessor for AssignmentTarget<'alloc> {
    fn set_loc(&mut self, start: SourceLocation, end: SourceLocation) {
        match self {
            AssignmentTarget::AssignmentTargetPattern(content) => { content.set_loc(start, end) }
            AssignmentTarget::SimpleAssignmentTarget(content) => { content.set_loc(start, end) }
        }
    }

    fn get_loc(&self) -> SourceLocation {
        match self {
            AssignmentTarget::AssignmentTargetPattern(content) => { content.get_loc() }
            AssignmentTarget::SimpleAssignmentTarget(content) => { content.get_loc() }
        }
    }
}

impl<'alloc> SourceLocationAccessor for AssignmentTargetIdentifier {
    fn set_loc(&mut self, start: SourceLocation, end: SourceLocation) {
        self.loc.start = start.start;
        self.loc.end = end.end;
    }

    fn get_loc(&self) -> SourceLocation {
        self.loc
    }
}

impl<'alloc> SourceLocationAccessor for AssignmentTargetMaybeDefault<'alloc> {
    fn set_loc(&mut self, start: SourceLocation, end: SourceLocation) {
        match self {
            AssignmentTargetMaybeDefault::AssignmentTarget(content) => { content.set_loc(start, end) }
            AssignmentTargetMaybeDefault::AssignmentTargetWithDefault(content) => { content.set_loc(start, end) }
        }
    }

    fn get_loc(&self) -> SourceLocation {
        match self {
            AssignmentTargetMaybeDefault::AssignmentTarget(content) => { content.get_loc() }
            AssignmentTargetMaybeDefault::AssignmentTargetWithDefault(content) => { content.get_loc() }
        }
    }
}

impl<'alloc> SourceLocationAccessor for AssignmentTargetPattern<'alloc> {
    fn set_loc(&mut self, start: SourceLocation, end: SourceLocation) {
        match self {
            AssignmentTargetPattern::ArrayAssignmentTarget(content) => { content.set_loc(start, end) }
            AssignmentTargetPattern::ObjectAssignmentTarget(content) => { content.set_loc(start, end) }
        }
    }

    fn get_loc(&self) -> SourceLocation {
        match self {
            AssignmentTargetPattern::ArrayAssignmentTarget(content) => { content.get_loc() }
            AssignmentTargetPattern::ObjectAssignmentTarget(content) => { content.get_loc() }
        }
    }
}

impl<'alloc> SourceLocationAccessor for AssignmentTargetProperty<'alloc> {
    fn set_loc(&mut self, start: SourceLocation, end: SourceLocation) {
        match self {
            AssignmentTargetProperty::AssignmentTargetPropertyIdentifier(content) => { content.set_loc(start, end) }
            AssignmentTargetProperty::AssignmentTargetPropertyProperty(content) => { content.set_loc(start, end) }
        }
    }

    fn get_loc(&self) -> SourceLocation {
        match self {
            AssignmentTargetProperty::AssignmentTargetPropertyIdentifier(content) => { content.get_loc() }
            AssignmentTargetProperty::AssignmentTargetPropertyProperty(content) => { content.get_loc() }
        }
    }
}

impl<'alloc> SourceLocationAccessor for AssignmentTargetPropertyIdentifier<'alloc> {
    fn set_loc(&mut self, start: SourceLocation, end: SourceLocation) {
        self.loc.start = start.start;
        self.loc.end = end.end;
    }

    fn get_loc(&self) -> SourceLocation {
        self.loc
    }
}

impl<'alloc> SourceLocationAccessor for AssignmentTargetPropertyProperty<'alloc> {
    fn set_loc(&mut self, start: SourceLocation, end: SourceLocation) {
        self.loc.start = start.start;
        self.loc.end = end.end;
    }

    fn get_loc(&self) -> SourceLocation {
        self.loc
    }
}

impl<'alloc> SourceLocationAccessor for AssignmentTargetWithDefault<'alloc> {
    fn set_loc(&mut self, start: SourceLocation, end: SourceLocation) {
        self.loc.start = start.start;
        self.loc.end = end.end;
    }

    fn get_loc(&self) -> SourceLocation {
        self.loc
    }
}

impl<'alloc> SourceLocationAccessor for BinaryOperator {
    fn set_loc(&mut self, start: SourceLocation, end: SourceLocation) {
        match self {
            BinaryOperator::Equals { mut loc } => {
                loc.start = start.start;
                loc.end = end.end;
            }
            BinaryOperator::NotEquals { mut loc } => {
                loc.start = start.start;
                loc.end = end.end;
            }
            BinaryOperator::StrictEquals { mut loc } => {
                loc.start = start.start;
                loc.end = end.end;
            }
            BinaryOperator::StrictNotEquals { mut loc } => {
                loc.start = start.start;
                loc.end = end.end;
            }
            BinaryOperator::LessThan { mut loc } => {
                loc.start = start.start;
                loc.end = end.end;
            }
            BinaryOperator::LessThanOrEqual { mut loc } => {
                loc.start = start.start;
                loc.end = end.end;
            }
            BinaryOperator::GreaterThan { mut loc } => {
                loc.start = start.start;
                loc.end = end.end;
            }
            BinaryOperator::GreaterThanOrEqual { mut loc } => {
                loc.start = start.start;
                loc.end = end.end;
            }
            BinaryOperator::In { mut loc } => {
                loc.start = start.start;
                loc.end = end.end;
            }
            BinaryOperator::Instanceof { mut loc } => {
                loc.start = start.start;
                loc.end = end.end;
            }
            BinaryOperator::LeftShift { mut loc } => {
                loc.start = start.start;
                loc.end = end.end;
            }
            BinaryOperator::RightShift { mut loc } => {
                loc.start = start.start;
                loc.end = end.end;
            }
            BinaryOperator::RightShiftExt { mut loc } => {
                loc.start = start.start;
                loc.end = end.end;
            }
            BinaryOperator::Add { mut loc } => {
                loc.start = start.start;
                loc.end = end.end;
            }
            BinaryOperator::Sub { mut loc } => {
                loc.start = start.start;
                loc.end = end.end;
            }
            BinaryOperator::Mul { mut loc } => {
                loc.start = start.start;
                loc.end = end.end;
            }
            BinaryOperator::Div { mut loc } => {
                loc.start = start.start;
                loc.end = end.end;
            }
            BinaryOperator::Mod { mut loc } => {
                loc.start = start.start;
                loc.end = end.end;
            }
            BinaryOperator::Pow { mut loc } => {
                loc.start = start.start;
                loc.end = end.end;
            }
            BinaryOperator::Comma { mut loc } => {
                loc.start = start.start;
                loc.end = end.end;
            }
            BinaryOperator::Coalesce { mut loc } => {
                loc.start = start.start;
                loc.end = end.end;
            }
            BinaryOperator::LogicalOr { mut loc } => {
                loc.start = start.start;
                loc.end = end.end;
            }
            BinaryOperator::LogicalAnd { mut loc } => {
                loc.start = start.start;
                loc.end = end.end;
            }
            BinaryOperator::BitwiseOr { mut loc } => {
                loc.start = start.start;
                loc.end = end.end;
            }
            BinaryOperator::BitwiseXor { mut loc } => {
                loc.start = start.start;
                loc.end = end.end;
            }
            BinaryOperator::BitwiseAnd { mut loc } => {
                loc.start = start.start;
                loc.end = end.end;
            }
        }
    }

    fn get_loc(&self) -> SourceLocation {
        match self {
            BinaryOperator::Equals { loc } => {
                *loc
            }
            BinaryOperator::NotEquals { loc } => {
                *loc
            }
            BinaryOperator::StrictEquals { loc } => {
                *loc
            }
            BinaryOperator::StrictNotEquals { loc } => {
                *loc
            }
            BinaryOperator::LessThan { loc } => {
                *loc
            }
            BinaryOperator::LessThanOrEqual { loc } => {
                *loc
            }
            BinaryOperator::GreaterThan { loc } => {
                *loc
            }
            BinaryOperator::GreaterThanOrEqual { loc } => {
                *loc
            }
            BinaryOperator::In { loc } => {
                *loc
            }
            BinaryOperator::Instanceof { loc } => {
                *loc
            }
            BinaryOperator::LeftShift { loc } => {
                *loc
            }
            BinaryOperator::RightShift { loc } => {
                *loc
            }
            BinaryOperator::RightShiftExt { loc } => {
                *loc
            }
            BinaryOperator::Add { loc } => {
                *loc
            }
            BinaryOperator::Sub { loc } => {
                *loc
            }
            BinaryOperator::Mul { loc } => {
                *loc
            }
            BinaryOperator::Div { loc } => {
                *loc
            }
            BinaryOperator::Mod { loc } => {
                *loc
            }
            BinaryOperator::Pow { loc } => {
                *loc
            }
            BinaryOperator::Comma { loc } => {
                *loc
            }
            BinaryOperator::Coalesce { loc } => {
                *loc
            }
            BinaryOperator::LogicalOr { loc } => {
                *loc
            }
            BinaryOperator::LogicalAnd { loc } => {
                *loc
            }
            BinaryOperator::BitwiseOr { loc } => {
                *loc
            }
            BinaryOperator::BitwiseXor { loc } => {
                *loc
            }
            BinaryOperator::BitwiseAnd { loc } => {
                *loc
            }
        }
    }
}

impl<'alloc> SourceLocationAccessor for Binding<'alloc> {
    fn set_loc(&mut self, start: SourceLocation, end: SourceLocation) {
        match self {
            Binding::BindingPattern(content) => { content.set_loc(start, end) }
            Binding::BindingIdentifier(content) => { content.set_loc(start, end) }
        }
    }

    fn get_loc(&self) -> SourceLocation {
        match self {
            Binding::BindingPattern(content) => { content.get_loc() }
            Binding::BindingIdentifier(content) => { content.get_loc() }
        }
    }
}

impl<'alloc> SourceLocationAccessor for BindingIdentifier {
    fn set_loc(&mut self, start: SourceLocation, end: SourceLocation) {
        self.loc.start = start.start;
        self.loc.end = end.end;
    }

    fn get_loc(&self) -> SourceLocation {
        self.loc
    }
}

impl<'alloc> SourceLocationAccessor for BindingPattern<'alloc> {
    fn set_loc(&mut self, start: SourceLocation, end: SourceLocation) {
        match self {
            BindingPattern::ObjectBinding(content) => { content.set_loc(start, end) }
            BindingPattern::ArrayBinding(content) => { content.set_loc(start, end) }
        }
    }

    fn get_loc(&self) -> SourceLocation {
        match self {
            BindingPattern::ObjectBinding(content) => { content.get_loc() }
            BindingPattern::ArrayBinding(content) => { content.get_loc() }
        }
    }
}

impl<'alloc> SourceLocationAccessor for BindingProperty<'alloc> {
    fn set_loc(&mut self, start: SourceLocation, end: SourceLocation) {
        match self {
            BindingProperty::BindingPropertyIdentifier(content) => { content.set_loc(start, end) }
            BindingProperty::BindingPropertyProperty(content) => { content.set_loc(start, end) }
        }
    }

    fn get_loc(&self) -> SourceLocation {
        match self {
            BindingProperty::BindingPropertyIdentifier(content) => { content.get_loc() }
            BindingProperty::BindingPropertyProperty(content) => { content.get_loc() }
        }
    }
}

impl<'alloc> SourceLocationAccessor for BindingPropertyIdentifier<'alloc> {
    fn set_loc(&mut self, start: SourceLocation, end: SourceLocation) {
        self.loc.start = start.start;
        self.loc.end = end.end;
    }

    fn get_loc(&self) -> SourceLocation {
        self.loc
    }
}

impl<'alloc> SourceLocationAccessor for BindingPropertyProperty<'alloc> {
    fn set_loc(&mut self, start: SourceLocation, end: SourceLocation) {
        self.loc.start = start.start;
        self.loc.end = end.end;
    }

    fn get_loc(&self) -> SourceLocation {
        self.loc
    }
}

impl<'alloc> SourceLocationAccessor for BindingWithDefault<'alloc> {
    fn set_loc(&mut self, start: SourceLocation, end: SourceLocation) {
        self.loc.start = start.start;
        self.loc.end = end.end;
    }

    fn get_loc(&self) -> SourceLocation {
        self.loc
    }
}

impl<'alloc> SourceLocationAccessor for Block<'alloc> {
    fn set_loc(&mut self, start: SourceLocation, end: SourceLocation) {
        self.loc.start = start.start;
        self.loc.end = end.end;
    }

    fn get_loc(&self) -> SourceLocation {
        self.loc
    }
}

impl<'alloc> SourceLocationAccessor for CallExpression<'alloc> {
    fn set_loc(&mut self, start: SourceLocation, end: SourceLocation) {
        self.loc.start = start.start;
        self.loc.end = end.end;
    }

    fn get_loc(&self) -> SourceLocation {
        self.loc
    }
}

impl<'alloc> SourceLocationAccessor for CatchClause<'alloc> {
    fn set_loc(&mut self, start: SourceLocation, end: SourceLocation) {
        self.loc.start = start.start;
        self.loc.end = end.end;
    }

    fn get_loc(&self) -> SourceLocation {
        self.loc
    }
}

impl<'alloc> SourceLocationAccessor for ClassDeclaration<'alloc> {
    fn set_loc(&mut self, start: SourceLocation, end: SourceLocation) {
        self.loc.start = start.start;
        self.loc.end = end.end;
    }

    fn get_loc(&self) -> SourceLocation {
        self.loc
    }
}

impl<'alloc> SourceLocationAccessor for ClassElement<'alloc> {
    fn set_loc(&mut self, start: SourceLocation, end: SourceLocation) {
        match self {
            ClassElement::MethodDefinition { mut loc, .. } => {
                loc.start = start.start;
                loc.end = end.end;
            }
            ClassElement::FieldDefinition { mut loc, .. } => {
                loc.start = start.start;
                loc.end = end.end;
            }
        }
    }

    fn get_loc(&self) -> SourceLocation {
        match self {
            ClassElement::MethodDefinition { loc, .. } => {
                *loc
            }
            ClassElement::FieldDefinition { loc, .. } => {
                *loc
            }
        }
    }
}

impl<'alloc> SourceLocationAccessor for ClassElementName<'alloc> {
    fn set_loc(&mut self, start: SourceLocation, end: SourceLocation) {
        match self {
            ClassElementName::ComputedPropertyName(content) => { content.set_loc(start, end) }
            ClassElementName::StaticPropertyName(content) => { content.set_loc(start, end) }
            ClassElementName::StaticNumericPropertyName(content) => { content.set_loc(start, end) }
            ClassElementName::PrivateFieldName(content) => { content.set_loc(start, end) }
        }
    }

    fn get_loc(&self) -> SourceLocation {
        match self {
            ClassElementName::ComputedPropertyName(content) => { content.get_loc() }
            ClassElementName::StaticPropertyName(content) => { content.get_loc() }
            ClassElementName::StaticNumericPropertyName(content) => { content.get_loc() }
            ClassElementName::PrivateFieldName(content) => { content.get_loc() }
        }
    }
}

impl<'alloc> SourceLocationAccessor for ClassExpression<'alloc> {
    fn set_loc(&mut self, start: SourceLocation, end: SourceLocation) {
        self.loc.start = start.start;
        self.loc.end = end.end;
    }

    fn get_loc(&self) -> SourceLocation {
        self.loc
    }
}

impl<'alloc> SourceLocationAccessor for CompoundAssignmentOperator {
    fn set_loc(&mut self, start: SourceLocation, end: SourceLocation) {
        match self {
            CompoundAssignmentOperator::LogicalOr { mut loc } => {
                loc.start = start.start;
                loc.end = end.end;
            }
            CompoundAssignmentOperator::LogicalAnd { mut loc } => {
                loc.start = start.start;
                loc.end = end.end;
            }
            CompoundAssignmentOperator::Coalesce { mut loc } => {
                loc.start = start.start;
                loc.end = end.end;
            }
            CompoundAssignmentOperator::Add { mut loc } => {
                loc.start = start.start;
                loc.end = end.end;
            }
            CompoundAssignmentOperator::Sub { mut loc } => {
                loc.start = start.start;
                loc.end = end.end;
            }
            CompoundAssignmentOperator::Mul { mut loc } => {
                loc.start = start.start;
                loc.end = end.end;
            }
            CompoundAssignmentOperator::Div { mut loc } => {
                loc.start = start.start;
                loc.end = end.end;
            }
            CompoundAssignmentOperator::Mod { mut loc } => {
                loc.start = start.start;
                loc.end = end.end;
            }
            CompoundAssignmentOperator::Pow { mut loc } => {
                loc.start = start.start;
                loc.end = end.end;
            }
            CompoundAssignmentOperator::LeftShift { mut loc } => {
                loc.start = start.start;
                loc.end = end.end;
            }
            CompoundAssignmentOperator::RightShift { mut loc } => {
                loc.start = start.start;
                loc.end = end.end;
            }
            CompoundAssignmentOperator::RightShiftExt { mut loc } => {
                loc.start = start.start;
                loc.end = end.end;
            }
            CompoundAssignmentOperator::Or { mut loc } => {
                loc.start = start.start;
                loc.end = end.end;
            }
            CompoundAssignmentOperator::Xor { mut loc } => {
                loc.start = start.start;
                loc.end = end.end;
            }
            CompoundAssignmentOperator::And { mut loc } => {
                loc.start = start.start;
                loc.end = end.end;
            }
        }
    }

    fn get_loc(&self) -> SourceLocation {
        match self {
            CompoundAssignmentOperator::LogicalOr { loc } => {
                *loc
            }
            CompoundAssignmentOperator::LogicalAnd { loc } => {
                *loc
            }
            CompoundAssignmentOperator::Coalesce { loc } => {
                *loc
            }
            CompoundAssignmentOperator::Add { loc } => {
                *loc
            }
            CompoundAssignmentOperator::Sub { loc } => {
                *loc
            }
            CompoundAssignmentOperator::Mul { loc } => {
                *loc
            }
            CompoundAssignmentOperator::Div { loc } => {
                *loc
            }
            CompoundAssignmentOperator::Mod { loc } => {
                *loc
            }
            CompoundAssignmentOperator::Pow { loc } => {
                *loc
            }
            CompoundAssignmentOperator::LeftShift { loc } => {
                *loc
            }
            CompoundAssignmentOperator::RightShift { loc } => {
                *loc
            }
            CompoundAssignmentOperator::RightShiftExt { loc } => {
                *loc
            }
            CompoundAssignmentOperator::Or { loc } => {
                *loc
            }
            CompoundAssignmentOperator::Xor { loc } => {
                *loc
            }
            CompoundAssignmentOperator::And { loc } => {
                *loc
            }
        }
    }
}

impl<'alloc> SourceLocationAccessor for ComputedMemberAssignmentTarget<'alloc> {
    fn set_loc(&mut self, start: SourceLocation, end: SourceLocation) {
        self.loc.start = start.start;
        self.loc.end = end.end;
    }

    fn get_loc(&self) -> SourceLocation {
        self.loc
    }
}

impl<'alloc> SourceLocationAccessor for ComputedMemberExpression<'alloc> {
    fn set_loc(&mut self, start: SourceLocation, end: SourceLocation) {
        self.loc.start = start.start;
        self.loc.end = end.end;
    }

    fn get_loc(&self) -> SourceLocation {
        self.loc
    }
}

impl<'alloc> SourceLocationAccessor for ComputedPropertyName<'alloc> {
    fn set_loc(&mut self, start: SourceLocation, end: SourceLocation) {
        self.loc.start = start.start;
        self.loc.end = end.end;
    }

    fn get_loc(&self) -> SourceLocation {
        self.loc
    }
}

impl<'alloc> SourceLocationAccessor for CoverParenthesized<'alloc> {
    fn set_loc(&mut self, start: SourceLocation, end: SourceLocation) {
        match self {
            CoverParenthesized::Expression { mut loc, .. } => {
                loc.start = start.start;
                loc.end = end.end;
            }
            CoverParenthesized::Parameters(content) => { content.set_loc(start, end) }
        }
    }

    fn get_loc(&self) -> SourceLocation {
        match self {
            CoverParenthesized::Expression { loc, .. } => {
                *loc
            }
            CoverParenthesized::Parameters(content) => { content.get_loc() }
        }
    }
}

impl<'alloc> SourceLocationAccessor for DataProperty<'alloc> {
    fn set_loc(&mut self, start: SourceLocation, end: SourceLocation) {
        self.loc.start = start.start;
        self.loc.end = end.end;
    }

    fn get_loc(&self) -> SourceLocation {
        self.loc
    }
}

impl<'alloc> SourceLocationAccessor for Directive {
    fn set_loc(&mut self, start: SourceLocation, end: SourceLocation) {
        self.loc.start = start.start;
        self.loc.end = end.end;
    }

    fn get_loc(&self) -> SourceLocation {
        self.loc
    }
}

impl<'alloc> SourceLocationAccessor for Export<'alloc> {
    fn set_loc(&mut self, start: SourceLocation, end: SourceLocation) {
        match self {
            Export::FunctionDeclaration(content) => { content.set_loc(start, end) }
            Export::ClassDeclaration(content) => { content.set_loc(start, end) }
            Export::VariableDeclaration(content) => { content.set_loc(start, end) }
        }
    }

    fn get_loc(&self) -> SourceLocation {
        match self {
            Export::FunctionDeclaration(content) => { content.get_loc() }
            Export::ClassDeclaration(content) => { content.get_loc() }
            Export::VariableDeclaration(content) => { content.get_loc() }
        }
    }
}

impl<'alloc> SourceLocationAccessor for ExportAllFrom {
    fn set_loc(&mut self, start: SourceLocation, end: SourceLocation) {
        self.loc.start = start.start;
        self.loc.end = end.end;
    }

    fn get_loc(&self) -> SourceLocation {
        self.loc
    }
}

impl<'alloc> SourceLocationAccessor for ExportDeclaration<'alloc> {
    fn set_loc(&mut self, start: SourceLocation, end: SourceLocation) {
        match self {
            ExportDeclaration::ExportAllFrom(content) => { content.set_loc(start, end) }
            ExportDeclaration::ExportFrom(content) => { content.set_loc(start, end) }
            ExportDeclaration::ExportLocals(content) => { content.set_loc(start, end) }
            ExportDeclaration::Export(content) => { content.set_loc(start, end) }
            ExportDeclaration::ExportDefault(content) => { content.set_loc(start, end) }
        }
    }

    fn get_loc(&self) -> SourceLocation {
        match self {
            ExportDeclaration::ExportAllFrom(content) => { content.get_loc() }
            ExportDeclaration::ExportFrom(content) => { content.get_loc() }
            ExportDeclaration::ExportLocals(content) => { content.get_loc() }
            ExportDeclaration::Export(content) => { content.get_loc() }
            ExportDeclaration::ExportDefault(content) => { content.get_loc() }
        }
    }
}

impl<'alloc> SourceLocationAccessor for ExportDefault<'alloc> {
    fn set_loc(&mut self, start: SourceLocation, end: SourceLocation) {
        match self {
            ExportDefault::FunctionDeclaration(content) => { content.set_loc(start, end) }
            ExportDefault::ClassDeclaration(content) => { content.set_loc(start, end) }
            ExportDefault::Expression(content) => { content.set_loc(start, end) }
        }
    }

    fn get_loc(&self) -> SourceLocation {
        match self {
            ExportDefault::FunctionDeclaration(content) => { content.get_loc() }
            ExportDefault::ClassDeclaration(content) => { content.get_loc() }
            ExportDefault::Expression(content) => { content.get_loc() }
        }
    }
}

impl<'alloc> SourceLocationAccessor for ExportFrom<'alloc> {
    fn set_loc(&mut self, start: SourceLocation, end: SourceLocation) {
        self.loc.start = start.start;
        self.loc.end = end.end;
    }

    fn get_loc(&self) -> SourceLocation {
        self.loc
    }
}

impl<'alloc> SourceLocationAccessor for ExportFromSpecifier {
    fn set_loc(&mut self, start: SourceLocation, end: SourceLocation) {
        self.loc.start = start.start;
        self.loc.end = end.end;
    }

    fn get_loc(&self) -> SourceLocation {
        self.loc
    }
}

impl<'alloc> SourceLocationAccessor for ExportLocalSpecifier {
    fn set_loc(&mut self, start: SourceLocation, end: SourceLocation) {
        self.loc.start = start.start;
        self.loc.end = end.end;
    }

    fn get_loc(&self) -> SourceLocation {
        self.loc
    }
}

impl<'alloc> SourceLocationAccessor for ExportLocals<'alloc> {
    fn set_loc(&mut self, start: SourceLocation, end: SourceLocation) {
        self.loc.start = start.start;
        self.loc.end = end.end;
    }

    fn get_loc(&self) -> SourceLocation {
        self.loc
    }
}

impl<'alloc> SourceLocationAccessor for Expression<'alloc> {
    fn set_loc(&mut self, start: SourceLocation, end: SourceLocation) {
        match self {
            Expression::MemberExpression(content) => { content.set_loc(start, end) }
            Expression::ClassExpression(content) => { content.set_loc(start, end) }
            Expression::LiteralBooleanExpression { mut loc, .. } => {
                loc.start = start.start;
                loc.end = end.end;
            }
            Expression::LiteralInfinityExpression { mut loc } => {
                loc.start = start.start;
                loc.end = end.end;
            }
            Expression::LiteralNullExpression { mut loc } => {
                loc.start = start.start;
                loc.end = end.end;
            }
            Expression::LiteralNumericExpression(content) => { content.set_loc(start, end) }
            Expression::LiteralRegExpExpression { mut loc, .. } => {
                loc.start = start.start;
                loc.end = end.end;
            }
            Expression::LiteralStringExpression { mut loc, .. } => {
                loc.start = start.start;
                loc.end = end.end;
            }
            Expression::ArrayExpression(content) => { content.set_loc(start, end) }
            Expression::ArrowExpression { mut loc, .. } => {
                loc.start = start.start;
                loc.end = end.end;
            }
            Expression::AssignmentExpression { mut loc, .. } => {
                loc.start = start.start;
                loc.end = end.end;
            }
            Expression::BinaryExpression { mut loc, .. } => {
                loc.start = start.start;
                loc.end = end.end;
            }
            Expression::CallExpression(content) => { content.set_loc(start, end) }
            Expression::CompoundAssignmentExpression { mut loc, .. } => {
                loc.start = start.start;
                loc.end = end.end;
            }
            Expression::ConditionalExpression { mut loc, .. } => {
                loc.start = start.start;
                loc.end = end.end;
            }
            Expression::FunctionExpression(content) => { content.set_loc(start, end) }
            Expression::IdentifierExpression(content) => { content.set_loc(start, end) }
            Expression::NewExpression { mut loc, .. } => {
                loc.start = start.start;
                loc.end = end.end;
            }
            Expression::NewTargetExpression { mut loc } => {
                loc.start = start.start;
                loc.end = end.end;
            }
            Expression::ObjectExpression(content) => { content.set_loc(start, end) }
            Expression::OptionalExpression { mut loc, .. } => {
                loc.start = start.start;
                loc.end = end.end;
            }
            Expression::OptionalChain(content) => { content.set_loc(start, end) }
            Expression::UnaryExpression { mut loc, .. } => {
                loc.start = start.start;
                loc.end = end.end;
            }
            Expression::TemplateExpression(content) => { content.set_loc(start, end) }
            Expression::ThisExpression { mut loc } => {
                loc.start = start.start;
                loc.end = end.end;
            }
            Expression::UpdateExpression { mut loc, .. } => {
                loc.start = start.start;
                loc.end = end.end;
            }
            Expression::YieldExpression { mut loc, .. } => {
                loc.start = start.start;
                loc.end = end.end;
            }
            Expression::YieldGeneratorExpression { mut loc, .. } => {
                loc.start = start.start;
                loc.end = end.end;
            }
            Expression::AwaitExpression { mut loc, .. } => {
                loc.start = start.start;
                loc.end = end.end;
            }
            Expression::ImportCallExpression { mut loc, .. } => {
                loc.start = start.start;
                loc.end = end.end;
            }
        }
    }

    fn get_loc(&self) -> SourceLocation {
        match self {
            Expression::MemberExpression(content) => { content.get_loc() }
            Expression::ClassExpression(content) => { content.get_loc() }
            Expression::LiteralBooleanExpression { loc, .. } => {
                *loc
            }
            Expression::LiteralInfinityExpression { loc } => {
                *loc
            }
            Expression::LiteralNullExpression { loc } => {
                *loc
            }
            Expression::LiteralNumericExpression(content) => { content.get_loc() }
            Expression::LiteralRegExpExpression { loc, .. } => {
                *loc
            }
            Expression::LiteralStringExpression { loc, .. } => {
                *loc
            }
            Expression::ArrayExpression(content) => { content.get_loc() }
            Expression::ArrowExpression { loc, .. } => {
                *loc
            }
            Expression::AssignmentExpression { loc, .. } => {
                *loc
            }
            Expression::BinaryExpression { loc, .. } => {
                *loc
            }
            Expression::CallExpression(content) => { content.get_loc() }
            Expression::CompoundAssignmentExpression { loc, .. } => {
                *loc
            }
            Expression::ConditionalExpression { loc, .. } => {
                *loc
            }
            Expression::FunctionExpression(content) => { content.get_loc() }
            Expression::IdentifierExpression(content) => { content.get_loc() }
            Expression::NewExpression { loc, .. } => {
                *loc
            }
            Expression::NewTargetExpression { loc } => {
                *loc
            }
            Expression::ObjectExpression(content) => { content.get_loc() }
            Expression::OptionalExpression { loc, .. } => {
                *loc
            }
            Expression::OptionalChain(content) => { content.get_loc() }
            Expression::UnaryExpression { loc, .. } => {
                *loc
            }
            Expression::TemplateExpression(content) => { content.get_loc() }
            Expression::ThisExpression { loc } => {
                *loc
            }
            Expression::UpdateExpression { loc, .. } => {
                *loc
            }
            Expression::YieldExpression { loc, .. } => {
                *loc
            }
            Expression::YieldGeneratorExpression { loc, .. } => {
                *loc
            }
            Expression::AwaitExpression { loc, .. } => {
                *loc
            }
            Expression::ImportCallExpression { loc, .. } => {
                *loc
            }
        }
    }
}

impl<'alloc> SourceLocationAccessor for ExpressionOrSuper<'alloc> {
    fn set_loc(&mut self, start: SourceLocation, end: SourceLocation) {
        match self {
            ExpressionOrSuper::Expression(content) => { content.set_loc(start, end) }
            ExpressionOrSuper::Super { mut loc } => {
                loc.start = start.start;
                loc.end = end.end;
            }
        }
    }

    fn get_loc(&self) -> SourceLocation {
        match self {
            ExpressionOrSuper::Expression(content) => { content.get_loc() }
            ExpressionOrSuper::Super { loc } => {
                *loc
            }
        }
    }
}

impl<'alloc> SourceLocationAccessor for FormalParameters<'alloc> {
    fn set_loc(&mut self, start: SourceLocation, end: SourceLocation) {
        self.loc.start = start.start;
        self.loc.end = end.end;
    }

    fn get_loc(&self) -> SourceLocation {
        self.loc
    }
}

impl<'alloc> SourceLocationAccessor for Function<'alloc> {
    fn set_loc(&mut self, start: SourceLocation, end: SourceLocation) {
        self.loc.start = start.start;
        self.loc.end = end.end;
    }

    fn get_loc(&self) -> SourceLocation {
        self.loc
    }
}

impl<'alloc> SourceLocationAccessor for FunctionBody<'alloc> {
    fn set_loc(&mut self, start: SourceLocation, end: SourceLocation) {
        self.loc.start = start.start;
        self.loc.end = end.end;
    }

    fn get_loc(&self) -> SourceLocation {
        self.loc
    }
}

impl<'alloc> SourceLocationAccessor for Getter<'alloc> {
    fn set_loc(&mut self, start: SourceLocation, end: SourceLocation) {
        self.loc.start = start.start;
        self.loc.end = end.end;
    }

    fn get_loc(&self) -> SourceLocation {
        self.loc
    }
}

impl<'alloc> SourceLocationAccessor for Identifier {
    fn set_loc(&mut self, start: SourceLocation, end: SourceLocation) {
        self.loc.start = start.start;
        self.loc.end = end.end;
    }

    fn get_loc(&self) -> SourceLocation {
        self.loc
    }
}

impl<'alloc> SourceLocationAccessor for IdentifierExpression {
    fn set_loc(&mut self, start: SourceLocation, end: SourceLocation) {
        self.loc.start = start.start;
        self.loc.end = end.end;
    }

    fn get_loc(&self) -> SourceLocation {
        self.loc
    }
}

impl<'alloc> SourceLocationAccessor for IdentifierName {
    fn set_loc(&mut self, start: SourceLocation, end: SourceLocation) {
        self.loc.start = start.start;
        self.loc.end = end.end;
    }

    fn get_loc(&self) -> SourceLocation {
        self.loc
    }
}

impl<'alloc> SourceLocationAccessor for IfStatement<'alloc> {
    fn set_loc(&mut self, start: SourceLocation, end: SourceLocation) {
        self.loc.start = start.start;
        self.loc.end = end.end;
    }

    fn get_loc(&self) -> SourceLocation {
        self.loc
    }
}

impl<'alloc> SourceLocationAccessor for Import<'alloc> {
    fn set_loc(&mut self, start: SourceLocation, end: SourceLocation) {
        self.loc.start = start.start;
        self.loc.end = end.end;
    }

    fn get_loc(&self) -> SourceLocation {
        self.loc
    }
}

impl<'alloc> SourceLocationAccessor for ImportDeclaration<'alloc> {
    fn set_loc(&mut self, start: SourceLocation, end: SourceLocation) {
        match self {
            ImportDeclaration::Import(content) => { content.set_loc(start, end) }
            ImportDeclaration::ImportNamespace(content) => { content.set_loc(start, end) }
        }
    }

    fn get_loc(&self) -> SourceLocation {
        match self {
            ImportDeclaration::Import(content) => { content.get_loc() }
            ImportDeclaration::ImportNamespace(content) => { content.get_loc() }
        }
    }
}

impl<'alloc> SourceLocationAccessor for ImportNamespace {
    fn set_loc(&mut self, start: SourceLocation, end: SourceLocation) {
        self.loc.start = start.start;
        self.loc.end = end.end;
    }

    fn get_loc(&self) -> SourceLocation {
        self.loc
    }
}

impl<'alloc> SourceLocationAccessor for ImportSpecifier {
    fn set_loc(&mut self, start: SourceLocation, end: SourceLocation) {
        self.loc.start = start.start;
        self.loc.end = end.end;
    }

    fn get_loc(&self) -> SourceLocation {
        self.loc
    }
}

impl<'alloc> SourceLocationAccessor for Label {
    fn set_loc(&mut self, start: SourceLocation, end: SourceLocation) {
        self.loc.start = start.start;
        self.loc.end = end.end;
    }

    fn get_loc(&self) -> SourceLocation {
        self.loc
    }
}

impl<'alloc> SourceLocationAccessor for MemberAssignmentTarget<'alloc> {
    fn set_loc(&mut self, start: SourceLocation, end: SourceLocation) {
        match self {
            MemberAssignmentTarget::ComputedMemberAssignmentTarget(content) => { content.set_loc(start, end) }
            MemberAssignmentTarget::PrivateFieldAssignmentTarget(content) => { content.set_loc(start, end) }
            MemberAssignmentTarget::StaticMemberAssignmentTarget(content) => { content.set_loc(start, end) }
        }
    }

    fn get_loc(&self) -> SourceLocation {
        match self {
            MemberAssignmentTarget::ComputedMemberAssignmentTarget(content) => { content.get_loc() }
            MemberAssignmentTarget::PrivateFieldAssignmentTarget(content) => { content.get_loc() }
            MemberAssignmentTarget::StaticMemberAssignmentTarget(content) => { content.get_loc() }
        }
    }
}

impl<'alloc> SourceLocationAccessor for MemberExpression<'alloc> {
    fn set_loc(&mut self, start: SourceLocation, end: SourceLocation) {
        match self {
            MemberExpression::ComputedMemberExpression(content) => { content.set_loc(start, end) }
            MemberExpression::StaticMemberExpression(content) => { content.set_loc(start, end) }
            MemberExpression::PrivateFieldExpression(content) => { content.set_loc(start, end) }
        }
    }

    fn get_loc(&self) -> SourceLocation {
        match self {
            MemberExpression::ComputedMemberExpression(content) => { content.get_loc() }
            MemberExpression::StaticMemberExpression(content) => { content.get_loc() }
            MemberExpression::PrivateFieldExpression(content) => { content.get_loc() }
        }
    }
}

impl<'alloc> SourceLocationAccessor for Method<'alloc> {
    fn set_loc(&mut self, start: SourceLocation, end: SourceLocation) {
        self.loc.start = start.start;
        self.loc.end = end.end;
    }

    fn get_loc(&self) -> SourceLocation {
        self.loc
    }
}

impl<'alloc> SourceLocationAccessor for MethodDefinition<'alloc> {
    fn set_loc(&mut self, start: SourceLocation, end: SourceLocation) {
        match self {
            MethodDefinition::Method(content) => { content.set_loc(start, end) }
            MethodDefinition::Getter(content) => { content.set_loc(start, end) }
            MethodDefinition::Setter(content) => { content.set_loc(start, end) }
        }
    }

    fn get_loc(&self) -> SourceLocation {
        match self {
            MethodDefinition::Method(content) => { content.get_loc() }
            MethodDefinition::Getter(content) => { content.get_loc() }
            MethodDefinition::Setter(content) => { content.get_loc() }
        }
    }
}

impl<'alloc> SourceLocationAccessor for Module<'alloc> {
    fn set_loc(&mut self, start: SourceLocation, end: SourceLocation) {
        self.loc.start = start.start;
        self.loc.end = end.end;
    }

    fn get_loc(&self) -> SourceLocation {
        self.loc
    }
}

impl<'alloc> SourceLocationAccessor for ModuleItems<'alloc> {
    fn set_loc(&mut self, start: SourceLocation, end: SourceLocation) {
        match self {
            ModuleItems::ImportDeclaration(content) => { content.set_loc(start, end) }
            ModuleItems::ExportDeclaration(content) => { content.set_loc(start, end) }
            ModuleItems::Statement(content) => { content.set_loc(start, end) }
        }
    }

    fn get_loc(&self) -> SourceLocation {
        match self {
            ModuleItems::ImportDeclaration(content) => { content.get_loc() }
            ModuleItems::ExportDeclaration(content) => { content.get_loc() }
            ModuleItems::Statement(content) => { content.get_loc() }
        }
    }
}

impl<'alloc> SourceLocationAccessor for NamedObjectProperty<'alloc> {
    fn set_loc(&mut self, start: SourceLocation, end: SourceLocation) {
        match self {
            NamedObjectProperty::MethodDefinition(content) => { content.set_loc(start, end) }
            NamedObjectProperty::DataProperty(content) => { content.set_loc(start, end) }
        }
    }

    fn get_loc(&self) -> SourceLocation {
        match self {
            NamedObjectProperty::MethodDefinition(content) => { content.get_loc() }
            NamedObjectProperty::DataProperty(content) => { content.get_loc() }
        }
    }
}

impl<'alloc> SourceLocationAccessor for NumericLiteral {
    fn set_loc(&mut self, start: SourceLocation, end: SourceLocation) {
        self.loc.start = start.start;
        self.loc.end = end.end;
    }

    fn get_loc(&self) -> SourceLocation {
        self.loc
    }
}

impl<'alloc> SourceLocationAccessor for ObjectAssignmentTarget<'alloc> {
    fn set_loc(&mut self, start: SourceLocation, end: SourceLocation) {
        self.loc.start = start.start;
        self.loc.end = end.end;
    }

    fn get_loc(&self) -> SourceLocation {
        self.loc
    }
}

impl<'alloc> SourceLocationAccessor for ObjectBinding<'alloc> {
    fn set_loc(&mut self, start: SourceLocation, end: SourceLocation) {
        self.loc.start = start.start;
        self.loc.end = end.end;
    }

    fn get_loc(&self) -> SourceLocation {
        self.loc
    }
}

impl<'alloc> SourceLocationAccessor for ObjectExpression<'alloc> {
    fn set_loc(&mut self, start: SourceLocation, end: SourceLocation) {
        self.loc.start = start.start;
        self.loc.end = end.end;
    }

    fn get_loc(&self) -> SourceLocation {
        self.loc
    }
}

impl<'alloc> SourceLocationAccessor for ObjectProperty<'alloc> {
    fn set_loc(&mut self, start: SourceLocation, end: SourceLocation) {
        match self {
            ObjectProperty::NamedObjectProperty(content) => { content.set_loc(start, end) }
            ObjectProperty::ShorthandProperty(content) => { content.set_loc(start, end) }
            ObjectProperty::SpreadProperty(content) => { content.set_loc(start, end) }
        }
    }

    fn get_loc(&self) -> SourceLocation {
        match self {
            ObjectProperty::NamedObjectProperty(content) => { content.get_loc() }
            ObjectProperty::ShorthandProperty(content) => { content.get_loc() }
            ObjectProperty::SpreadProperty(content) => { content.get_loc() }
        }
    }
}

impl<'alloc> SourceLocationAccessor for OptionalChain<'alloc> {
    fn set_loc(&mut self, start: SourceLocation, end: SourceLocation) {
        match self {
            OptionalChain::ComputedMemberExpressionTail { mut loc, .. } => {
                loc.start = start.start;
                loc.end = end.end;
            }
            OptionalChain::StaticMemberExpressionTail { mut loc, .. } => {
                loc.start = start.start;
                loc.end = end.end;
            }
            OptionalChain::PrivateFieldExpressionTail { mut loc, .. } => {
                loc.start = start.start;
                loc.end = end.end;
            }
            OptionalChain::CallExpressionTail { mut loc, .. } => {
                loc.start = start.start;
                loc.end = end.end;
            }
            OptionalChain::ComputedMemberExpression(content) => { content.set_loc(start, end) }
            OptionalChain::StaticMemberExpression(content) => { content.set_loc(start, end) }
            OptionalChain::PrivateFieldExpression(content) => { content.set_loc(start, end) }
            OptionalChain::CallExpression(content) => { content.set_loc(start, end) }
        }
    }

    fn get_loc(&self) -> SourceLocation {
        match self {
            OptionalChain::ComputedMemberExpressionTail { loc, .. } => {
                *loc
            }
            OptionalChain::StaticMemberExpressionTail { loc, .. } => {
                *loc
            }
            OptionalChain::PrivateFieldExpressionTail { loc, .. } => {
                *loc
            }
            OptionalChain::CallExpressionTail { loc, .. } => {
                *loc
            }
            OptionalChain::ComputedMemberExpression(content) => { content.get_loc() }
            OptionalChain::StaticMemberExpression(content) => { content.get_loc() }
            OptionalChain::PrivateFieldExpression(content) => { content.get_loc() }
            OptionalChain::CallExpression(content) => { content.get_loc() }
        }
    }
}

impl<'alloc> SourceLocationAccessor for Parameter<'alloc> {
    fn set_loc(&mut self, start: SourceLocation, end: SourceLocation) {
        match self {
            Parameter::Binding(content) => { content.set_loc(start, end) }
            Parameter::BindingWithDefault(content) => { content.set_loc(start, end) }
        }
    }

    fn get_loc(&self) -> SourceLocation {
        match self {
            Parameter::Binding(content) => { content.get_loc() }
            Parameter::BindingWithDefault(content) => { content.get_loc() }
        }
    }
}

impl<'alloc> SourceLocationAccessor for PrivateFieldAssignmentTarget<'alloc> {
    fn set_loc(&mut self, start: SourceLocation, end: SourceLocation) {
        self.loc.start = start.start;
        self.loc.end = end.end;
    }

    fn get_loc(&self) -> SourceLocation {
        self.loc
    }
}

impl<'alloc> SourceLocationAccessor for PrivateFieldExpression<'alloc> {
    fn set_loc(&mut self, start: SourceLocation, end: SourceLocation) {
        self.loc.start = start.start;
        self.loc.end = end.end;
    }

    fn get_loc(&self) -> SourceLocation {
        self.loc
    }
}

impl<'alloc> SourceLocationAccessor for PrivateIdentifier {
    fn set_loc(&mut self, start: SourceLocation, end: SourceLocation) {
        self.loc.start = start.start;
        self.loc.end = end.end;
    }

    fn get_loc(&self) -> SourceLocation {
        self.loc
    }
}

impl<'alloc> SourceLocationAccessor for Program<'alloc> {
    fn set_loc(&mut self, start: SourceLocation, end: SourceLocation) {
        match self {
            Program::Module(content) => { content.set_loc(start, end) }
            Program::Script(content) => { content.set_loc(start, end) }
        }
    }

    fn get_loc(&self) -> SourceLocation {
        match self {
            Program::Module(content) => { content.get_loc() }
            Program::Script(content) => { content.get_loc() }
        }
    }
}

impl<'alloc> SourceLocationAccessor for PropertyName<'alloc> {
    fn set_loc(&mut self, start: SourceLocation, end: SourceLocation) {
        match self {
            PropertyName::ComputedPropertyName(content) => { content.set_loc(start, end) }
            PropertyName::StaticPropertyName(content) => { content.set_loc(start, end) }
            PropertyName::StaticNumericPropertyName(content) => { content.set_loc(start, end) }
        }
    }

    fn get_loc(&self) -> SourceLocation {
        match self {
            PropertyName::ComputedPropertyName(content) => { content.get_loc() }
            PropertyName::StaticPropertyName(content) => { content.get_loc() }
            PropertyName::StaticNumericPropertyName(content) => { content.get_loc() }
        }
    }
}

impl<'alloc> SourceLocationAccessor for Script<'alloc> {
    fn set_loc(&mut self, start: SourceLocation, end: SourceLocation) {
        self.loc.start = start.start;
        self.loc.end = end.end;
    }

    fn get_loc(&self) -> SourceLocation {
        self.loc
    }
}

impl<'alloc> SourceLocationAccessor for Setter<'alloc> {
    fn set_loc(&mut self, start: SourceLocation, end: SourceLocation) {
        self.loc.start = start.start;
        self.loc.end = end.end;
    }

    fn get_loc(&self) -> SourceLocation {
        self.loc
    }
}

impl<'alloc> SourceLocationAccessor for ShorthandProperty {
    fn set_loc(&mut self, start: SourceLocation, end: SourceLocation) {
        self.loc.start = start.start;
        self.loc.end = end.end;
    }

    fn get_loc(&self) -> SourceLocation {
        self.loc
    }
}

impl<'alloc> SourceLocationAccessor for SimpleAssignmentTarget<'alloc> {
    fn set_loc(&mut self, start: SourceLocation, end: SourceLocation) {
        match self {
            SimpleAssignmentTarget::AssignmentTargetIdentifier(content) => { content.set_loc(start, end) }
            SimpleAssignmentTarget::MemberAssignmentTarget(content) => { content.set_loc(start, end) }
        }
    }

    fn get_loc(&self) -> SourceLocation {
        match self {
            SimpleAssignmentTarget::AssignmentTargetIdentifier(content) => { content.get_loc() }
            SimpleAssignmentTarget::MemberAssignmentTarget(content) => { content.get_loc() }
        }
    }
}

impl<'alloc> SourceLocationAccessor for Statement<'alloc> {
    fn set_loc(&mut self, start: SourceLocation, end: SourceLocation) {
        match self {
            Statement::BlockStatement { mut loc, .. } => {
                loc.start = start.start;
                loc.end = end.end;
            }
            Statement::BreakStatement { mut loc, .. } => {
                loc.start = start.start;
                loc.end = end.end;
            }
            Statement::ContinueStatement { mut loc, .. } => {
                loc.start = start.start;
                loc.end = end.end;
            }
            Statement::DebuggerStatement { mut loc } => {
                loc.start = start.start;
                loc.end = end.end;
            }
            Statement::DoWhileStatement { mut loc, .. } => {
                loc.start = start.start;
                loc.end = end.end;
            }
            Statement::EmptyStatement { mut loc } => {
                loc.start = start.start;
                loc.end = end.end;
            }
            Statement::ExpressionStatement(content) => { content.set_loc(start, end) }
            Statement::ForInStatement { mut loc, .. } => {
                loc.start = start.start;
                loc.end = end.end;
            }
            Statement::ForOfStatement { mut loc, .. } => {
                loc.start = start.start;
                loc.end = end.end;
            }
            Statement::ForStatement { mut loc, .. } => {
                loc.start = start.start;
                loc.end = end.end;
            }
            Statement::IfStatement(content) => { content.set_loc(start, end) }
            Statement::LabelledStatement { mut loc, .. } => {
                loc.start = start.start;
                loc.end = end.end;
            }
            Statement::ReturnStatement { mut loc, .. } => {
                loc.start = start.start;
                loc.end = end.end;
            }
            Statement::SwitchStatement { mut loc, .. } => {
                loc.start = start.start;
                loc.end = end.end;
            }
            Statement::SwitchStatementWithDefault { mut loc, .. } => {
                loc.start = start.start;
                loc.end = end.end;
            }
            Statement::ThrowStatement { mut loc, .. } => {
                loc.start = start.start;
                loc.end = end.end;
            }
            Statement::TryCatchStatement { mut loc, .. } => {
                loc.start = start.start;
                loc.end = end.end;
            }
            Statement::TryFinallyStatement { mut loc, .. } => {
                loc.start = start.start;
                loc.end = end.end;
            }
            Statement::WhileStatement { mut loc, .. } => {
                loc.start = start.start;
                loc.end = end.end;
            }
            Statement::WithStatement { mut loc, .. } => {
                loc.start = start.start;
                loc.end = end.end;
            }
            Statement::VariableDeclarationStatement(content) => { content.set_loc(start, end) }
            Statement::FunctionDeclaration(content) => { content.set_loc(start, end) }
            Statement::ClassDeclaration(content) => { content.set_loc(start, end) }
        }
    }

    fn get_loc(&self) -> SourceLocation {
        match self {
            Statement::BlockStatement { loc, .. } => {
                *loc
            }
            Statement::BreakStatement { loc, .. } => {
                *loc
            }
            Statement::ContinueStatement { loc, .. } => {
                *loc
            }
            Statement::DebuggerStatement { loc } => {
                *loc
            }
            Statement::DoWhileStatement { loc, .. } => {
                *loc
            }
            Statement::EmptyStatement { loc } => {
                *loc
            }
            Statement::ExpressionStatement(content) => { content.get_loc() }
            Statement::ForInStatement { loc, .. } => {
                *loc
            }
            Statement::ForOfStatement { loc, .. } => {
                *loc
            }
            Statement::ForStatement { loc, .. } => {
                *loc
            }
            Statement::IfStatement(content) => { content.get_loc() }
            Statement::LabelledStatement { loc, .. } => {
                *loc
            }
            Statement::ReturnStatement { loc, .. } => {
                *loc
            }
            Statement::SwitchStatement { loc, .. } => {
                *loc
            }
            Statement::SwitchStatementWithDefault { loc, .. } => {
                *loc
            }
            Statement::ThrowStatement { loc, .. } => {
                *loc
            }
            Statement::TryCatchStatement { loc, .. } => {
                *loc
            }
            Statement::TryFinallyStatement { loc, .. } => {
                *loc
            }
            Statement::WhileStatement { loc, .. } => {
                *loc
            }
            Statement::WithStatement { loc, .. } => {
                *loc
            }
            Statement::VariableDeclarationStatement(content) => { content.get_loc() }
            Statement::FunctionDeclaration(content) => { content.get_loc() }
            Statement::ClassDeclaration(content) => { content.get_loc() }
        }
    }
}

impl<'alloc> SourceLocationAccessor for StaticMemberAssignmentTarget<'alloc> {
    fn set_loc(&mut self, start: SourceLocation, end: SourceLocation) {
        self.loc.start = start.start;
        self.loc.end = end.end;
    }

    fn get_loc(&self) -> SourceLocation {
        self.loc
    }
}

impl<'alloc> SourceLocationAccessor for StaticMemberExpression<'alloc> {
    fn set_loc(&mut self, start: SourceLocation, end: SourceLocation) {
        self.loc.start = start.start;
        self.loc.end = end.end;
    }

    fn get_loc(&self) -> SourceLocation {
        self.loc
    }
}

impl<'alloc> SourceLocationAccessor for StaticPropertyName {
    fn set_loc(&mut self, start: SourceLocation, end: SourceLocation) {
        self.loc.start = start.start;
        self.loc.end = end.end;
    }

    fn get_loc(&self) -> SourceLocation {
        self.loc
    }
}

impl<'alloc> SourceLocationAccessor for SwitchCase<'alloc> {
    fn set_loc(&mut self, start: SourceLocation, end: SourceLocation) {
        self.loc.start = start.start;
        self.loc.end = end.end;
    }

    fn get_loc(&self) -> SourceLocation {
        self.loc
    }
}

impl<'alloc> SourceLocationAccessor for SwitchDefault<'alloc> {
    fn set_loc(&mut self, start: SourceLocation, end: SourceLocation) {
        self.loc.start = start.start;
        self.loc.end = end.end;
    }

    fn get_loc(&self) -> SourceLocation {
        self.loc
    }
}

impl<'alloc> SourceLocationAccessor for TemplateElement {
    fn set_loc(&mut self, start: SourceLocation, end: SourceLocation) {
        self.loc.start = start.start;
        self.loc.end = end.end;
    }

    fn get_loc(&self) -> SourceLocation {
        self.loc
    }
}

impl<'alloc> SourceLocationAccessor for TemplateExpression<'alloc> {
    fn set_loc(&mut self, start: SourceLocation, end: SourceLocation) {
        self.loc.start = start.start;
        self.loc.end = end.end;
    }

    fn get_loc(&self) -> SourceLocation {
        self.loc
    }
}

impl<'alloc> SourceLocationAccessor for TemplateExpressionElement<'alloc> {
    fn set_loc(&mut self, start: SourceLocation, end: SourceLocation) {
        match self {
            TemplateExpressionElement::Expression(content) => { content.set_loc(start, end) }
            TemplateExpressionElement::TemplateElement(content) => { content.set_loc(start, end) }
        }
    }

    fn get_loc(&self) -> SourceLocation {
        match self {
            TemplateExpressionElement::Expression(content) => { content.get_loc() }
            TemplateExpressionElement::TemplateElement(content) => { content.get_loc() }
        }
    }
}

impl<'alloc> SourceLocationAccessor for UnaryOperator {
    fn set_loc(&mut self, start: SourceLocation, end: SourceLocation) {
        match self {
            UnaryOperator::Plus { mut loc } => {
                loc.start = start.start;
                loc.end = end.end;
            }
            UnaryOperator::Minus { mut loc } => {
                loc.start = start.start;
                loc.end = end.end;
            }
            UnaryOperator::LogicalNot { mut loc } => {
                loc.start = start.start;
                loc.end = end.end;
            }
            UnaryOperator::BitwiseNot { mut loc } => {
                loc.start = start.start;
                loc.end = end.end;
            }
            UnaryOperator::Typeof { mut loc } => {
                loc.start = start.start;
                loc.end = end.end;
            }
            UnaryOperator::Void { mut loc } => {
                loc.start = start.start;
                loc.end = end.end;
            }
            UnaryOperator::Delete { mut loc } => {
                loc.start = start.start;
                loc.end = end.end;
            }
        }
    }

    fn get_loc(&self) -> SourceLocation {
        match self {
            UnaryOperator::Plus { loc } => {
                *loc
            }
            UnaryOperator::Minus { loc } => {
                *loc
            }
            UnaryOperator::LogicalNot { loc } => {
                *loc
            }
            UnaryOperator::BitwiseNot { loc } => {
                *loc
            }
            UnaryOperator::Typeof { loc } => {
                *loc
            }
            UnaryOperator::Void { loc } => {
                *loc
            }
            UnaryOperator::Delete { loc } => {
                *loc
            }
        }
    }
}

impl<'alloc> SourceLocationAccessor for UpdateOperator {
    fn set_loc(&mut self, start: SourceLocation, end: SourceLocation) {
        match self {
            UpdateOperator::Increment { mut loc } => {
                loc.start = start.start;
                loc.end = end.end;
            }
            UpdateOperator::Decrement { mut loc } => {
                loc.start = start.start;
                loc.end = end.end;
            }
        }
    }

    fn get_loc(&self) -> SourceLocation {
        match self {
            UpdateOperator::Increment { loc } => {
                *loc
            }
            UpdateOperator::Decrement { loc } => {
                *loc
            }
        }
    }
}

impl<'alloc> SourceLocationAccessor for VariableDeclaration<'alloc> {
    fn set_loc(&mut self, start: SourceLocation, end: SourceLocation) {
        self.loc.start = start.start;
        self.loc.end = end.end;
    }

    fn get_loc(&self) -> SourceLocation {
        self.loc
    }
}

impl<'alloc> SourceLocationAccessor for VariableDeclarationKind {
    fn set_loc(&mut self, start: SourceLocation, end: SourceLocation) {
        match self {
            VariableDeclarationKind::Var { mut loc } => {
                loc.start = start.start;
                loc.end = end.end;
            }
            VariableDeclarationKind::Let { mut loc } => {
                loc.start = start.start;
                loc.end = end.end;
            }
            VariableDeclarationKind::Const { mut loc } => {
                loc.start = start.start;
                loc.end = end.end;
            }
        }
    }

    fn get_loc(&self) -> SourceLocation {
        match self {
            VariableDeclarationKind::Var { loc } => {
                *loc
            }
            VariableDeclarationKind::Let { loc } => {
                *loc
            }
            VariableDeclarationKind::Const { loc } => {
                *loc
            }
        }
    }
}

impl<'alloc> SourceLocationAccessor for VariableDeclarationOrAssignmentTarget<'alloc> {
    fn set_loc(&mut self, start: SourceLocation, end: SourceLocation) {
        match self {
            VariableDeclarationOrAssignmentTarget::VariableDeclaration(content) => { content.set_loc(start, end) }
            VariableDeclarationOrAssignmentTarget::AssignmentTarget(content) => { content.set_loc(start, end) }
        }
    }

    fn get_loc(&self) -> SourceLocation {
        match self {
            VariableDeclarationOrAssignmentTarget::VariableDeclaration(content) => { content.get_loc() }
            VariableDeclarationOrAssignmentTarget::AssignmentTarget(content) => { content.get_loc() }
        }
    }
}

impl<'alloc> SourceLocationAccessor for VariableDeclarationOrExpression<'alloc> {
    fn set_loc(&mut self, start: SourceLocation, end: SourceLocation) {
        match self {
            VariableDeclarationOrExpression::VariableDeclaration(content) => { content.set_loc(start, end) }
            VariableDeclarationOrExpression::Expression(content) => { content.set_loc(start, end) }
        }
    }

    fn get_loc(&self) -> SourceLocation {
        match self {
            VariableDeclarationOrExpression::VariableDeclaration(content) => { content.get_loc() }
            VariableDeclarationOrExpression::Expression(content) => { content.get_loc() }
        }
    }
}

impl<'alloc> SourceLocationAccessor for VariableDeclarator<'alloc> {
    fn set_loc(&mut self, start: SourceLocation, end: SourceLocation) {
        self.loc.start = start.start;
        self.loc.end = end.end;
    }

    fn get_loc(&self) -> SourceLocation {
        self.loc
    }
}

impl<'alloc> SourceLocationAccessor for VariableReference {
    fn set_loc(&mut self, start: SourceLocation, end: SourceLocation) {
        match self {
            VariableReference::BindingIdentifier(content) => { content.set_loc(start, end) }
            VariableReference::AssignmentTargetIdentifier(content) => { content.set_loc(start, end) }
        }
    }

    fn get_loc(&self) -> SourceLocation {
        match self {
            VariableReference::BindingIdentifier(content) => { content.get_loc() }
            VariableReference::AssignmentTargetIdentifier(content) => { content.get_loc() }
        }
    }
}

impl<'alloc, T> SourceLocationAccessor for arena::Box<'alloc, T>
where
    T: SourceLocationAccessor,
{
    fn set_loc(&mut self, start: SourceLocation, end: SourceLocation) {
        (self.borrow_mut() as &mut T).set_loc(start, end)
    }

    fn get_loc(&self) -> SourceLocation {
        (self.borrow() as &T).get_loc()
    }
}
