// Copyright 2015 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CONTENT_PUBLIC_RENDERER_WEBRTC_IP_HANDLING_POLICY_H_
#define CONTENT_PUBLIC_RENDERER_WEBRTC_IP_HANDLING_POLICY_H_

#include "content/common/content_export.h"

namespace content {

// This is the default behavior of Chrome. Currently, WebRTC has the right to
// enumerate all interfaces and bind them to discover public interfaces.
CONTENT_EXPORT extern const char kWebRTCIPHandlingDefault[];

// WebRTC should only use the default route used by http. This also exposes the
// associated default private address. Default route is the route chosen by the
// OS on a multi-homed endpoint.
CONTENT_EXPORT extern const char
    kWebRTCIPHandlingDefaultPublicAndPrivateInterfaces[];

// WebRTC should only use the default route used by http. This doesn't expose
// any local addresses.
CONTENT_EXPORT extern const char kWebRTCIPHandlingDefaultPublicInterfaceOnly[];

// WebRTC should only use TCP to contact peers or servers unless the proxy
// server supports UDP. This doesn't expose any local addresses either.
CONTENT_EXPORT extern const char kWebRTCIPHandlingDisableNonProxiedUdp[];

}  // namespace content

#endif  // CONTENT_PUBLIC_RENDERER_WEBRTC_IP_HANDLING_POLICY_H_
