/*
 * Copyright (C) 2024 Alexander Borisov
 *
 * Author: Alexander Borisov <borisov@lexbor.com>
 */

/*
 * Caution!
 * This file generated by the script "utils/lexbor/encoding/multi-byte.py"!
 * Do not change this file!
 */

#include "lexbor/encoding/base.h"

#include "lexbor/core/shs.h"


LXB_API const lxb_encoding_multi_index_t lxb_encoding_multi_index_euc_kr[23750] = 
{
    {{'\xea', '\xb0', '\x82'}, 3, 0xAC02}, /* (HANGUL SYLLABLE GAGG) */
    {{'\xea', '\xb0', '\x83'}, 3, 0xAC03}, /* (HANGUL SYLLABLE GAGS) */
    {{'\xea', '\xb0', '\x85'}, 3, 0xAC05}, /* (HANGUL SYLLABLE GANJ) */
    {{'\xea', '\xb0', '\x86'}, 3, 0xAC06}, /* (HANGUL SYLLABLE GANH) */
    {{'\xea', '\xb0', '\x8b'}, 3, 0xAC0B}, /* (HANGUL SYLLABLE GALB) */
    {{'\xea', '\xb0', '\x8c'}, 3, 0xAC0C}, /* (HANGUL SYLLABLE GALS) */
    {{'\xea', '\xb0', '\x8d'}, 3, 0xAC0D}, /* (HANGUL SYLLABLE GALT) */
    {{'\xea', '\xb0', '\x8e'}, 3, 0xAC0E}, /* (HANGUL SYLLABLE GALP) */
    {{'\xea', '\xb0', '\x8f'}, 3, 0xAC0F}, /* (HANGUL SYLLABLE GALH) */
    {{'\xea', '\xb0', '\x98'}, 3, 0xAC18}, /* (HANGUL SYLLABLE GAK) */
    {{'\xea', '\xb0', '\x9e'}, 3, 0xAC1E}, /* (HANGUL SYLLABLE GAEGG) */
    {{'\xea', '\xb0', '\x9f'}, 3, 0xAC1F}, /* (HANGUL SYLLABLE GAEGS) */
    {{'\xea', '\xb0', '\xa1'}, 3, 0xAC21}, /* (HANGUL SYLLABLE GAENJ) */
    {{'\xea', '\xb0', '\xa2'}, 3, 0xAC22}, /* (HANGUL SYLLABLE GAENH) */
    {{'\xea', '\xb0', '\xa3'}, 3, 0xAC23}, /* (HANGUL SYLLABLE GAED) */
    {{'\xea', '\xb0', '\xa5'}, 3, 0xAC25}, /* (HANGUL SYLLABLE GAELG) */
    {{'\xea', '\xb0', '\xa6'}, 3, 0xAC26}, /* (HANGUL SYLLABLE GAELM) */
    {{'\xea', '\xb0', '\xa7'}, 3, 0xAC27}, /* (HANGUL SYLLABLE GAELB) */
    {{'\xea', '\xb0', '\xa8'}, 3, 0xAC28}, /* (HANGUL SYLLABLE GAELS) */
    {{'\xea', '\xb0', '\xa9'}, 3, 0xAC29}, /* (HANGUL SYLLABLE GAELT) */
    {{'\xea', '\xb0', '\xaa'}, 3, 0xAC2A}, /* (HANGUL SYLLABLE GAELP) */
    {{'\xea', '\xb0', '\xab'}, 3, 0xAC2B}, /* (HANGUL SYLLABLE GAELH) */
    {{'\xea', '\xb0', '\xae'}, 3, 0xAC2E}, /* (HANGUL SYLLABLE GAEBS) */
    {{'\xea', '\xb0', '\xb2'}, 3, 0xAC32}, /* (HANGUL SYLLABLE GAEJ) */
    {{'\xea', '\xb0', '\xb3'}, 3, 0xAC33}, /* (HANGUL SYLLABLE GAEC) */
    {{'\xea', '\xb0', '\xb4'}, 3, 0xAC34}, /* (HANGUL SYLLABLE GAEK) */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{'\xea', '\xb0', '\xb5'}, 3, 0xAC35}, /* (HANGUL SYLLABLE GAET) */
    {{'\xea', '\xb0', '\xb6'}, 3, 0xAC36}, /* (HANGUL SYLLABLE GAEP) */
    {{'\xea', '\xb0', '\xb7'}, 3, 0xAC37}, /* (HANGUL SYLLABLE GAEH) */
    {{'\xea', '\xb0', '\xba'}, 3, 0xAC3A}, /* (HANGUL SYLLABLE GYAGG) */
    {{'\xea', '\xb0', '\xbb'}, 3, 0xAC3B}, /* (HANGUL SYLLABLE GYAGS) */
    {{'\xea', '\xb0', '\xbd'}, 3, 0xAC3D}, /* (HANGUL SYLLABLE GYANJ) */
    {{'\xea', '\xb0', '\xbe'}, 3, 0xAC3E}, /* (HANGUL SYLLABLE GYANH) */
    {{'\xea', '\xb0', '\xbf'}, 3, 0xAC3F}, /* (HANGUL SYLLABLE GYAD) */
    {{'\xea', '\xb1', '\x81'}, 3, 0xAC41}, /* (HANGUL SYLLABLE GYALG) */
    {{'\xea', '\xb1', '\x82'}, 3, 0xAC42}, /* (HANGUL SYLLABLE GYALM) */
    {{'\xea', '\xb1', '\x83'}, 3, 0xAC43}, /* (HANGUL SYLLABLE GYALB) */
    {{'\xea', '\xb1', '\x84'}, 3, 0xAC44}, /* (HANGUL SYLLABLE GYALS) */
    {{'\xea', '\xb1', '\x85'}, 3, 0xAC45}, /* (HANGUL SYLLABLE GYALT) */
    {{'\xea', '\xb1', '\x86'}, 3, 0xAC46}, /* (HANGUL SYLLABLE GYALP) */
    {{'\xea', '\xb1', '\x87'}, 3, 0xAC47}, /* (HANGUL SYLLABLE GYALH) */
    {{'\xea', '\xb1', '\x88'}, 3, 0xAC48}, /* (HANGUL SYLLABLE GYAM) */
    {{'\xea', '\xb1', '\x89'}, 3, 0xAC49}, /* (HANGUL SYLLABLE GYAB) */
    {{'\xea', '\xb1', '\x8a'}, 3, 0xAC4A}, /* (HANGUL SYLLABLE GYABS) */
    {{'\xea', '\xb1', '\x8c'}, 3, 0xAC4C}, /* (HANGUL SYLLABLE GYASS) */
    {{'\xea', '\xb1', '\x8e'}, 3, 0xAC4E}, /* (HANGUL SYLLABLE GYAJ) */
    {{'\xea', '\xb1', '\x8f'}, 3, 0xAC4F}, /* (HANGUL SYLLABLE GYAC) */
    {{'\xea', '\xb1', '\x90'}, 3, 0xAC50}, /* (HANGUL SYLLABLE GYAK) */
    {{'\xea', '\xb1', '\x91'}, 3, 0xAC51}, /* (HANGUL SYLLABLE GYAT) */
    {{'\xea', '\xb1', '\x92'}, 3, 0xAC52}, /* (HANGUL SYLLABLE GYAP) */
    {{'\xea', '\xb1', '\x93'}, 3, 0xAC53}, /* (HANGUL SYLLABLE GYAH) */
    {{'\xea', '\xb1', '\x95'}, 3, 0xAC55}, /* (HANGUL SYLLABLE GYAEG) */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{'\xea', '\xb1', '\x96'}, 3, 0xAC56}, /* (HANGUL SYLLABLE GYAEGG) */
    {{'\xea', '\xb1', '\x97'}, 3, 0xAC57}, /* (HANGUL SYLLABLE GYAEGS) */
    {{'\xea', '\xb1', '\x99'}, 3, 0xAC59}, /* (HANGUL SYLLABLE GYAENJ) */
    {{'\xea', '\xb1', '\x9a'}, 3, 0xAC5A}, /* (HANGUL SYLLABLE GYAENH) */
    {{'\xea', '\xb1', '\x9b'}, 3, 0xAC5B}, /* (HANGUL SYLLABLE GYAED) */
    {{'\xea', '\xb1', '\x9d'}, 3, 0xAC5D}, /* (HANGUL SYLLABLE GYAELG) */
    {{'\xea', '\xb1', '\x9e'}, 3, 0xAC5E}, /* (HANGUL SYLLABLE GYAELM) */
    {{'\xea', '\xb1', '\x9f'}, 3, 0xAC5F}, /* (HANGUL SYLLABLE GYAELB) */
    {{'\xea', '\xb1', '\xa0'}, 3, 0xAC60}, /* (HANGUL SYLLABLE GYAELS) */
    {{'\xea', '\xb1', '\xa1'}, 3, 0xAC61}, /* (HANGUL SYLLABLE GYAELT) */
    {{'\xea', '\xb1', '\xa2'}, 3, 0xAC62}, /* (HANGUL SYLLABLE GYAELP) */
    {{'\xea', '\xb1', '\xa3'}, 3, 0xAC63}, /* (HANGUL SYLLABLE GYAELH) */
    {{'\xea', '\xb1', '\xa4'}, 3, 0xAC64}, /* (HANGUL SYLLABLE GYAEM) */
    {{'\xea', '\xb1', '\xa5'}, 3, 0xAC65}, /* (HANGUL SYLLABLE GYAEB) */
    {{'\xea', '\xb1', '\xa6'}, 3, 0xAC66}, /* (HANGUL SYLLABLE GYAEBS) */
    {{'\xea', '\xb1', '\xa7'}, 3, 0xAC67}, /* (HANGUL SYLLABLE GYAES) */
    {{'\xea', '\xb1', '\xa8'}, 3, 0xAC68}, /* (HANGUL SYLLABLE GYAESS) */
    {{'\xea', '\xb1', '\xa9'}, 3, 0xAC69}, /* (HANGUL SYLLABLE GYAENG) */
    {{'\xea', '\xb1', '\xaa'}, 3, 0xAC6A}, /* (HANGUL SYLLABLE GYAEJ) */
    {{'\xea', '\xb1', '\xab'}, 3, 0xAC6B}, /* (HANGUL SYLLABLE GYAEC) */
    {{'\xea', '\xb1', '\xac'}, 3, 0xAC6C}, /* (HANGUL SYLLABLE GYAEK) */
    {{'\xea', '\xb1', '\xad'}, 3, 0xAC6D}, /* (HANGUL SYLLABLE GYAET) */
    {{'\xea', '\xb1', '\xae'}, 3, 0xAC6E}, /* (HANGUL SYLLABLE GYAEP) */
    {{'\xea', '\xb1', '\xaf'}, 3, 0xAC6F}, /* (HANGUL SYLLABLE GYAEH) */
    {{'\xea', '\xb1', '\xb2'}, 3, 0xAC72}, /* (HANGUL SYLLABLE GEOGG) */
    {{'\xea', '\xb1', '\xb3'}, 3, 0xAC73}, /* (HANGUL SYLLABLE GEOGS) */
    {{'\xea', '\xb1', '\xb5'}, 3, 0xAC75}, /* (HANGUL SYLLABLE GEONJ) */
    {{'\xea', '\xb1', '\xb6'}, 3, 0xAC76}, /* (HANGUL SYLLABLE GEONH) */
    {{'\xea', '\xb1', '\xb9'}, 3, 0xAC79}, /* (HANGUL SYLLABLE GEOLG) */
    {{'\xea', '\xb1', '\xbb'}, 3, 0xAC7B}, /* (HANGUL SYLLABLE GEOLB) */
    {{'\xea', '\xb1', '\xbc'}, 3, 0xAC7C}, /* (HANGUL SYLLABLE GEOLS) */
    {{'\xea', '\xb1', '\xbd'}, 3, 0xAC7D}, /* (HANGUL SYLLABLE GEOLT) */
    {{'\xea', '\xb1', '\xbe'}, 3, 0xAC7E}, /* (HANGUL SYLLABLE GEOLP) */
    {{'\xea', '\xb1', '\xbf'}, 3, 0xAC7F}, /* (HANGUL SYLLABLE GEOLH) */
    {{'\xea', '\xb2', '\x82'}, 3, 0xAC82}, /* (HANGUL SYLLABLE GEOBS) */
    {{'\xea', '\xb2', '\x87'}, 3, 0xAC87}, /* (HANGUL SYLLABLE GEOC) */
    {{'\xea', '\xb2', '\x88'}, 3, 0xAC88}, /* (HANGUL SYLLABLE GEOK) */
    {{'\xea', '\xb2', '\x8d'}, 3, 0xAC8D}, /* (HANGUL SYLLABLE GEG) */
    {{'\xea', '\xb2', '\x8e'}, 3, 0xAC8E}, /* (HANGUL SYLLABLE GEGG) */
    {{'\xea', '\xb2', '\x8f'}, 3, 0xAC8F}, /* (HANGUL SYLLABLE GEGS) */
    {{'\xea', '\xb2', '\x91'}, 3, 0xAC91}, /* (HANGUL SYLLABLE GENJ) */
    {{'\xea', '\xb2', '\x92'}, 3, 0xAC92}, /* (HANGUL SYLLABLE GENH) */
    {{'\xea', '\xb2', '\x93'}, 3, 0xAC93}, /* (HANGUL SYLLABLE GED) */
    {{'\xea', '\xb2', '\x95'}, 3, 0xAC95}, /* (HANGUL SYLLABLE GELG) */
    {{'\xea', '\xb2', '\x96'}, 3, 0xAC96}, /* (HANGUL SYLLABLE GELM) */
    {{'\xea', '\xb2', '\x97'}, 3, 0xAC97}, /* (HANGUL SYLLABLE GELB) */
    {{'\xea', '\xb2', '\x98'}, 3, 0xAC98}, /* (HANGUL SYLLABLE GELS) */
    {{'\xea', '\xb2', '\x99'}, 3, 0xAC99}, /* (HANGUL SYLLABLE GELT) */
    {{'\xea', '\xb2', '\x9a'}, 3, 0xAC9A}, /* (HANGUL SYLLABLE GELP) */
    {{'\xea', '\xb2', '\x9b'}, 3, 0xAC9B}, /* (HANGUL SYLLABLE GELH) */
    {{'\xea', '\xb2', '\x9e'}, 3, 0xAC9E}, /* (HANGUL SYLLABLE GEBS) */
    {{'\xea', '\xb2', '\xa2'}, 3, 0xACA2}, /* (HANGUL SYLLABLE GEJ) */
    {{'\xea', '\xb2', '\xa3'}, 3, 0xACA3}, /* (HANGUL SYLLABLE GEC) */
    {{'\xea', '\xb2', '\xa4'}, 3, 0xACA4}, /* (HANGUL SYLLABLE GEK) */
    {{'\xea', '\xb2', '\xa5'}, 3, 0xACA5}, /* (HANGUL SYLLABLE GET) */
    {{'\xea', '\xb2', '\xa6'}, 3, 0xACA6}, /* (HANGUL SYLLABLE GEP) */
    {{'\xea', '\xb2', '\xa7'}, 3, 0xACA7}, /* (HANGUL SYLLABLE GEH) */
    {{'\xea', '\xb2', '\xab'}, 3, 0xACAB}, /* (HANGUL SYLLABLE GYEOGS) */
    {{'\xea', '\xb2', '\xad'}, 3, 0xACAD}, /* (HANGUL SYLLABLE GYEONJ) */
    {{'\xea', '\xb2', '\xae'}, 3, 0xACAE}, /* (HANGUL SYLLABLE GYEONH) */
    {{'\xea', '\xb2', '\xb1'}, 3, 0xACB1}, /* (HANGUL SYLLABLE GYEOLG) */
    {{'\xea', '\xb2', '\xb2'}, 3, 0xACB2}, /* (HANGUL SYLLABLE GYEOLM) */
    {{'\xea', '\xb2', '\xb3'}, 3, 0xACB3}, /* (HANGUL SYLLABLE GYEOLB) */
    {{'\xea', '\xb2', '\xb4'}, 3, 0xACB4}, /* (HANGUL SYLLABLE GYEOLS) */
    {{'\xea', '\xb2', '\xb5'}, 3, 0xACB5}, /* (HANGUL SYLLABLE GYEOLT) */
    {{'\xea', '\xb2', '\xb6'}, 3, 0xACB6}, /* (HANGUL SYLLABLE GYEOLP) */
    {{'\xea', '\xb2', '\xb7'}, 3, 0xACB7}, /* (HANGUL SYLLABLE GYEOLH) */
    {{'\xea', '\xb2', '\xba'}, 3, 0xACBA}, /* (HANGUL SYLLABLE GYEOBS) */
    {{'\xea', '\xb2', '\xbe'}, 3, 0xACBE}, /* (HANGUL SYLLABLE GYEOJ) */
    {{'\xea', '\xb2', '\xbf'}, 3, 0xACBF}, /* (HANGUL SYLLABLE GYEOC) */
    {{'\xea', '\xb3', '\x80'}, 3, 0xACC0}, /* (HANGUL SYLLABLE GYEOK) */
    {{'\xea', '\xb3', '\x82'}, 3, 0xACC2}, /* (HANGUL SYLLABLE GYEOP) */
    {{'\xea', '\xb3', '\x83'}, 3, 0xACC3}, /* (HANGUL SYLLABLE GYEOH) */
    {{'\xea', '\xb3', '\x85'}, 3, 0xACC5}, /* (HANGUL SYLLABLE GYEG) */
    {{'\xea', '\xb3', '\x86'}, 3, 0xACC6}, /* (HANGUL SYLLABLE GYEGG) */
    {{'\xea', '\xb3', '\x87'}, 3, 0xACC7}, /* (HANGUL SYLLABLE GYEGS) */
    {{'\xea', '\xb3', '\x89'}, 3, 0xACC9}, /* (HANGUL SYLLABLE GYENJ) */
    {{'\xea', '\xb3', '\x8a'}, 3, 0xACCA}, /* (HANGUL SYLLABLE GYENH) */
    {{'\xea', '\xb3', '\x8b'}, 3, 0xACCB}, /* (HANGUL SYLLABLE GYED) */
    {{'\xea', '\xb3', '\x8d'}, 3, 0xACCD}, /* (HANGUL SYLLABLE GYELG) */
    {{'\xea', '\xb3', '\x8e'}, 3, 0xACCE}, /* (HANGUL SYLLABLE GYELM) */
    {{'\xea', '\xb3', '\x8f'}, 3, 0xACCF}, /* (HANGUL SYLLABLE GYELB) */
    {{'\xea', '\xb3', '\x90'}, 3, 0xACD0}, /* (HANGUL SYLLABLE GYELS) */
    {{'\xea', '\xb3', '\x91'}, 3, 0xACD1}, /* (HANGUL SYLLABLE GYELT) */
    {{'\xea', '\xb3', '\x92'}, 3, 0xACD2}, /* (HANGUL SYLLABLE GYELP) */
    {{'\xea', '\xb3', '\x93'}, 3, 0xACD3}, /* (HANGUL SYLLABLE GYELH) */
    {{'\xea', '\xb3', '\x94'}, 3, 0xACD4}, /* (HANGUL SYLLABLE GYEM) */
    {{'\xea', '\xb3', '\x96'}, 3, 0xACD6}, /* (HANGUL SYLLABLE GYEBS) */
    {{'\xea', '\xb3', '\x98'}, 3, 0xACD8}, /* (HANGUL SYLLABLE GYESS) */
    {{'\xea', '\xb3', '\x99'}, 3, 0xACD9}, /* (HANGUL SYLLABLE GYENG) */
    {{'\xea', '\xb3', '\x9a'}, 3, 0xACDA}, /* (HANGUL SYLLABLE GYEJ) */
    {{'\xea', '\xb3', '\x9b'}, 3, 0xACDB}, /* (HANGUL SYLLABLE GYEC) */
    {{'\xea', '\xb3', '\x9c'}, 3, 0xACDC}, /* (HANGUL SYLLABLE GYEK) */
    {{'\xea', '\xb3', '\x9d'}, 3, 0xACDD}, /* (HANGUL SYLLABLE GYET) */
    {{'\xea', '\xb3', '\x9e'}, 3, 0xACDE}, /* (HANGUL SYLLABLE GYEP) */
    {{'\xea', '\xb3', '\x9f'}, 3, 0xACDF}, /* (HANGUL SYLLABLE GYEH) */
    {{'\xea', '\xb3', '\xa2'}, 3, 0xACE2}, /* (HANGUL SYLLABLE GOGG) */
    {{'\xea', '\xb3', '\xa3'}, 3, 0xACE3}, /* (HANGUL SYLLABLE GOGS) */
    {{'\xea', '\xb3', '\xa5'}, 3, 0xACE5}, /* (HANGUL SYLLABLE GONJ) */
    {{'\xea', '\xb3', '\xa6'}, 3, 0xACE6}, /* (HANGUL SYLLABLE GONH) */
    {{'\xea', '\xb3', '\xa9'}, 3, 0xACE9}, /* (HANGUL SYLLABLE GOLG) */
    {{'\xea', '\xb3', '\xab'}, 3, 0xACEB}, /* (HANGUL SYLLABLE GOLB) */
    {{'\xea', '\xb3', '\xad'}, 3, 0xACED}, /* (HANGUL SYLLABLE GOLT) */
    {{'\xea', '\xb3', '\xae'}, 3, 0xACEE}, /* (HANGUL SYLLABLE GOLP) */
    {{'\xea', '\xb3', '\xb2'}, 3, 0xACF2}, /* (HANGUL SYLLABLE GOBS) */
    {{'\xea', '\xb3', '\xb4'}, 3, 0xACF4}, /* (HANGUL SYLLABLE GOSS) */
    {{'\xea', '\xb3', '\xb7'}, 3, 0xACF7}, /* (HANGUL SYLLABLE GOC) */
    {{'\xea', '\xb3', '\xb8'}, 3, 0xACF8}, /* (HANGUL SYLLABLE GOK) */
    {{'\xea', '\xb3', '\xb9'}, 3, 0xACF9}, /* (HANGUL SYLLABLE GOT) */
    {{'\xea', '\xb3', '\xba'}, 3, 0xACFA}, /* (HANGUL SYLLABLE GOP) */
    {{'\xea', '\xb3', '\xbb'}, 3, 0xACFB}, /* (HANGUL SYLLABLE GOH) */
    {{'\xea', '\xb3', '\xbe'}, 3, 0xACFE}, /* (HANGUL SYLLABLE GWAGG) */
    {{'\xea', '\xb3', '\xbf'}, 3, 0xACFF}, /* (HANGUL SYLLABLE GWAGS) */
    {{'\xea', '\xb4', '\x81'}, 3, 0xAD01}, /* (HANGUL SYLLABLE GWANJ) */
    {{'\xea', '\xb4', '\x82'}, 3, 0xAD02}, /* (HANGUL SYLLABLE GWANH) */
    {{'\xea', '\xb4', '\x83'}, 3, 0xAD03}, /* (HANGUL SYLLABLE GWAD) */
    {{'\xea', '\xb4', '\x85'}, 3, 0xAD05}, /* (HANGUL SYLLABLE GWALG) */
    {{'\xea', '\xb4', '\x87'}, 3, 0xAD07}, /* (HANGUL SYLLABLE GWALB) */
    {{'\xea', '\xb4', '\x88'}, 3, 0xAD08}, /* (HANGUL SYLLABLE GWALS) */
    {{'\xea', '\xb4', '\x89'}, 3, 0xAD09}, /* (HANGUL SYLLABLE GWALT) */
    {{'\xea', '\xb4', '\x8a'}, 3, 0xAD0A}, /* (HANGUL SYLLABLE GWALP) */
    {{'\xea', '\xb4', '\x8b'}, 3, 0xAD0B}, /* (HANGUL SYLLABLE GWALH) */
    {{'\xea', '\xb4', '\x8e'}, 3, 0xAD0E}, /* (HANGUL SYLLABLE GWABS) */
    {{'\xea', '\xb4', '\x90'}, 3, 0xAD10}, /* (HANGUL SYLLABLE GWASS) */
    {{'\xea', '\xb4', '\x92'}, 3, 0xAD12}, /* (HANGUL SYLLABLE GWAJ) */
    {{'\xea', '\xb4', '\x93'}, 3, 0xAD13}, /* (HANGUL SYLLABLE GWAC) */
    {{'\xea', '\xb4', '\x94'}, 3, 0xAD14}, /* (HANGUL SYLLABLE GWAK) */
    {{'\xea', '\xb4', '\x95'}, 3, 0xAD15}, /* (HANGUL SYLLABLE GWAT) */
    {{'\xea', '\xb4', '\x96'}, 3, 0xAD16}, /* (HANGUL SYLLABLE GWAP) */
    {{'\xea', '\xb4', '\x97'}, 3, 0xAD17}, /* (HANGUL SYLLABLE GWAH) */
    {{'\xea', '\xb4', '\x99'}, 3, 0xAD19}, /* (HANGUL SYLLABLE GWAEG) */
    {{'\xea', '\xb4', '\x9a'}, 3, 0xAD1A}, /* (HANGUL SYLLABLE GWAEGG) */
    {{'\xea', '\xb4', '\x9b'}, 3, 0xAD1B}, /* (HANGUL SYLLABLE GWAEGS) */
    {{'\xea', '\xb4', '\x9d'}, 3, 0xAD1D}, /* (HANGUL SYLLABLE GWAENJ) */
    {{'\xea', '\xb4', '\x9e'}, 3, 0xAD1E}, /* (HANGUL SYLLABLE GWAENH) */
    {{'\xea', '\xb4', '\x9f'}, 3, 0xAD1F}, /* (HANGUL SYLLABLE GWAED) */
    {{'\xea', '\xb4', '\xa1'}, 3, 0xAD21}, /* (HANGUL SYLLABLE GWAELG) */
    {{'\xea', '\xb4', '\xa2'}, 3, 0xAD22}, /* (HANGUL SYLLABLE GWAELM) */
    {{'\xea', '\xb4', '\xa3'}, 3, 0xAD23}, /* (HANGUL SYLLABLE GWAELB) */
    {{'\xea', '\xb4', '\xa4'}, 3, 0xAD24}, /* (HANGUL SYLLABLE GWAELS) */
    {{'\xea', '\xb4', '\xa5'}, 3, 0xAD25}, /* (HANGUL SYLLABLE GWAELT) */
    {{'\xea', '\xb4', '\xa6'}, 3, 0xAD26}, /* (HANGUL SYLLABLE GWAELP) */
    {{'\xea', '\xb4', '\xa7'}, 3, 0xAD27}, /* (HANGUL SYLLABLE GWAELH) */
    {{'\xea', '\xb4', '\xa8'}, 3, 0xAD28}, /* (HANGUL SYLLABLE GWAEM) */
    {{'\xea', '\xb4', '\xaa'}, 3, 0xAD2A}, /* (HANGUL SYLLABLE GWAEBS) */
    {{'\xea', '\xb4', '\xab'}, 3, 0xAD2B}, /* (HANGUL SYLLABLE GWAES) */
    {{'\xea', '\xb4', '\xae'}, 3, 0xAD2E}, /* (HANGUL SYLLABLE GWAEJ) */
    {{'\xea', '\xb4', '\xaf'}, 3, 0xAD2F}, /* (HANGUL SYLLABLE GWAEC) */
    {{'\xea', '\xb4', '\xb0'}, 3, 0xAD30}, /* (HANGUL SYLLABLE GWAEK) */
    {{'\xea', '\xb4', '\xb1'}, 3, 0xAD31}, /* (HANGUL SYLLABLE GWAET) */
    {{'\xea', '\xb4', '\xb2'}, 3, 0xAD32}, /* (HANGUL SYLLABLE GWAEP) */
    {{'\xea', '\xb4', '\xb3'}, 3, 0xAD33}, /* (HANGUL SYLLABLE GWAEH) */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{'\xea', '\xb4', '\xb6'}, 3, 0xAD36}, /* (HANGUL SYLLABLE GOEGG) */
    {{'\xea', '\xb4', '\xb7'}, 3, 0xAD37}, /* (HANGUL SYLLABLE GOEGS) */
    {{'\xea', '\xb4', '\xb9'}, 3, 0xAD39}, /* (HANGUL SYLLABLE GOENJ) */
    {{'\xea', '\xb4', '\xba'}, 3, 0xAD3A}, /* (HANGUL SYLLABLE GOENH) */
    {{'\xea', '\xb4', '\xbb'}, 3, 0xAD3B}, /* (HANGUL SYLLABLE GOED) */
    {{'\xea', '\xb4', '\xbd'}, 3, 0xAD3D}, /* (HANGUL SYLLABLE GOELG) */
    {{'\xea', '\xb4', '\xbe'}, 3, 0xAD3E}, /* (HANGUL SYLLABLE GOELM) */
    {{'\xea', '\xb4', '\xbf'}, 3, 0xAD3F}, /* (HANGUL SYLLABLE GOELB) */
    {{'\xea', '\xb5', '\x80'}, 3, 0xAD40}, /* (HANGUL SYLLABLE GOELS) */
    {{'\xea', '\xb5', '\x81'}, 3, 0xAD41}, /* (HANGUL SYLLABLE GOELT) */
    {{'\xea', '\xb5', '\x82'}, 3, 0xAD42}, /* (HANGUL SYLLABLE GOELP) */
    {{'\xea', '\xb5', '\x83'}, 3, 0xAD43}, /* (HANGUL SYLLABLE GOELH) */
    {{'\xea', '\xb5', '\x86'}, 3, 0xAD46}, /* (HANGUL SYLLABLE GOEBS) */
    {{'\xea', '\xb5', '\x88'}, 3, 0xAD48}, /* (HANGUL SYLLABLE GOESS) */
    {{'\xea', '\xb5', '\x8a'}, 3, 0xAD4A}, /* (HANGUL SYLLABLE GOEJ) */
    {{'\xea', '\xb5', '\x8b'}, 3, 0xAD4B}, /* (HANGUL SYLLABLE GOEC) */
    {{'\xea', '\xb5', '\x8c'}, 3, 0xAD4C}, /* (HANGUL SYLLABLE GOEK) */
    {{'\xea', '\xb5', '\x8d'}, 3, 0xAD4D}, /* (HANGUL SYLLABLE GOET) */
    {{'\xea', '\xb5', '\x8e'}, 3, 0xAD4E}, /* (HANGUL SYLLABLE GOEP) */
    {{'\xea', '\xb5', '\x8f'}, 3, 0xAD4F}, /* (HANGUL SYLLABLE GOEH) */
    {{'\xea', '\xb5', '\x91'}, 3, 0xAD51}, /* (HANGUL SYLLABLE GYOG) */
    {{'\xea', '\xb5', '\x92'}, 3, 0xAD52}, /* (HANGUL SYLLABLE GYOGG) */
    {{'\xea', '\xb5', '\x93'}, 3, 0xAD53}, /* (HANGUL SYLLABLE GYOGS) */
    {{'\xea', '\xb5', '\x95'}, 3, 0xAD55}, /* (HANGUL SYLLABLE GYONJ) */
    {{'\xea', '\xb5', '\x96'}, 3, 0xAD56}, /* (HANGUL SYLLABLE GYONH) */
    {{'\xea', '\xb5', '\x97'}, 3, 0xAD57}, /* (HANGUL SYLLABLE GYOD) */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{'\xea', '\xb5', '\x99'}, 3, 0xAD59}, /* (HANGUL SYLLABLE GYOLG) */
    {{'\xea', '\xb5', '\x9a'}, 3, 0xAD5A}, /* (HANGUL SYLLABLE GYOLM) */
    {{'\xea', '\xb5', '\x9b'}, 3, 0xAD5B}, /* (HANGUL SYLLABLE GYOLB) */
    {{'\xea', '\xb5', '\x9c'}, 3, 0xAD5C}, /* (HANGUL SYLLABLE GYOLS) */
    {{'\xea', '\xb5', '\x9d'}, 3, 0xAD5D}, /* (HANGUL SYLLABLE GYOLT) */
    {{'\xea', '\xb5', '\x9e'}, 3, 0xAD5E}, /* (HANGUL SYLLABLE GYOLP) */
    {{'\xea', '\xb5', '\x9f'}, 3, 0xAD5F}, /* (HANGUL SYLLABLE GYOLH) */
    {{'\xea', '\xb5', '\xa0'}, 3, 0xAD60}, /* (HANGUL SYLLABLE GYOM) */
    {{'\xea', '\xb5', '\xa2'}, 3, 0xAD62}, /* (HANGUL SYLLABLE GYOBS) */
    {{'\xea', '\xb5', '\xa4'}, 3, 0xAD64}, /* (HANGUL SYLLABLE GYOSS) */
    {{'\xea', '\xb5', '\xa5'}, 3, 0xAD65}, /* (HANGUL SYLLABLE GYONG) */
    {{'\xea', '\xb5', '\xa6'}, 3, 0xAD66}, /* (HANGUL SYLLABLE GYOJ) */
    {{'\xea', '\xb5', '\xa7'}, 3, 0xAD67}, /* (HANGUL SYLLABLE GYOC) */
    {{'\xea', '\xb5', '\xa8'}, 3, 0xAD68}, /* (HANGUL SYLLABLE GYOK) */
    {{'\xea', '\xb5', '\xa9'}, 3, 0xAD69}, /* (HANGUL SYLLABLE GYOT) */
    {{'\xea', '\xb5', '\xaa'}, 3, 0xAD6A}, /* (HANGUL SYLLABLE GYOP) */
    {{'\xea', '\xb5', '\xab'}, 3, 0xAD6B}, /* (HANGUL SYLLABLE GYOH) */
    {{'\xea', '\xb5', '\xae'}, 3, 0xAD6E}, /* (HANGUL SYLLABLE GUGG) */
    {{'\xea', '\xb5', '\xaf'}, 3, 0xAD6F}, /* (HANGUL SYLLABLE GUGS) */
    {{'\xea', '\xb5', '\xb1'}, 3, 0xAD71}, /* (HANGUL SYLLABLE GUNJ) */
    {{'\xea', '\xb5', '\xb2'}, 3, 0xAD72}, /* (HANGUL SYLLABLE GUNH) */
    {{'\xea', '\xb5', '\xb7'}, 3, 0xAD77}, /* (HANGUL SYLLABLE GULB) */
    {{'\xea', '\xb5', '\xb8'}, 3, 0xAD78}, /* (HANGUL SYLLABLE GULS) */
    {{'\xea', '\xb5', '\xb9'}, 3, 0xAD79}, /* (HANGUL SYLLABLE GULT) */
    {{'\xea', '\xb5', '\xba'}, 3, 0xAD7A}, /* (HANGUL SYLLABLE GULP) */
    {{'\xea', '\xb5', '\xbe'}, 3, 0xAD7E}, /* (HANGUL SYLLABLE GUBS) */
    {{'\xea', '\xb6', '\x80'}, 3, 0xAD80}, /* (HANGUL SYLLABLE GUSS) */
    {{'\xea', '\xb6', '\x83'}, 3, 0xAD83}, /* (HANGUL SYLLABLE GUC) */
    {{'\xea', '\xb6', '\x84'}, 3, 0xAD84}, /* (HANGUL SYLLABLE GUK) */
    {{'\xea', '\xb6', '\x85'}, 3, 0xAD85}, /* (HANGUL SYLLABLE GUT) */
    {{'\xea', '\xb6', '\x86'}, 3, 0xAD86}, /* (HANGUL SYLLABLE GUP) */
    {{'\xea', '\xb6', '\x87'}, 3, 0xAD87}, /* (HANGUL SYLLABLE GUH) */
    {{'\xea', '\xb6', '\x8a'}, 3, 0xAD8A}, /* (HANGUL SYLLABLE GWEOGG) */
    {{'\xea', '\xb6', '\x8b'}, 3, 0xAD8B}, /* (HANGUL SYLLABLE GWEOGS) */
    {{'\xea', '\xb6', '\x8d'}, 3, 0xAD8D}, /* (HANGUL SYLLABLE GWEONJ) */
    {{'\xea', '\xb6', '\x8e'}, 3, 0xAD8E}, /* (HANGUL SYLLABLE GWEONH) */
    {{'\xea', '\xb6', '\x8f'}, 3, 0xAD8F}, /* (HANGUL SYLLABLE GWEOD) */
    {{'\xea', '\xb6', '\x91'}, 3, 0xAD91}, /* (HANGUL SYLLABLE GWEOLG) */
    {{'\xea', '\xb6', '\x92'}, 3, 0xAD92}, /* (HANGUL SYLLABLE GWEOLM) */
    {{'\xea', '\xb6', '\x93'}, 3, 0xAD93}, /* (HANGUL SYLLABLE GWEOLB) */
    {{'\xea', '\xb6', '\x94'}, 3, 0xAD94}, /* (HANGUL SYLLABLE GWEOLS) */
    {{'\xea', '\xb6', '\x95'}, 3, 0xAD95}, /* (HANGUL SYLLABLE GWEOLT) */
    {{'\xea', '\xb6', '\x96'}, 3, 0xAD96}, /* (HANGUL SYLLABLE GWEOLP) */
    {{'\xea', '\xb6', '\x97'}, 3, 0xAD97}, /* (HANGUL SYLLABLE GWEOLH) */
    {{'\xea', '\xb6', '\x98'}, 3, 0xAD98}, /* (HANGUL SYLLABLE GWEOM) */
    {{'\xea', '\xb6', '\x99'}, 3, 0xAD99}, /* (HANGUL SYLLABLE GWEOB) */
    {{'\xea', '\xb6', '\x9a'}, 3, 0xAD9A}, /* (HANGUL SYLLABLE GWEOBS) */
    {{'\xea', '\xb6', '\x9b'}, 3, 0xAD9B}, /* (HANGUL SYLLABLE GWEOS) */
    {{'\xea', '\xb6', '\x9e'}, 3, 0xAD9E}, /* (HANGUL SYLLABLE GWEOJ) */
    {{'\xea', '\xb6', '\x9f'}, 3, 0xAD9F}, /* (HANGUL SYLLABLE GWEOC) */
    {{'\xea', '\xb6', '\xa0'}, 3, 0xADA0}, /* (HANGUL SYLLABLE GWEOK) */
    {{'\xea', '\xb6', '\xa1'}, 3, 0xADA1}, /* (HANGUL SYLLABLE GWEOT) */
    {{'\xea', '\xb6', '\xa2'}, 3, 0xADA2}, /* (HANGUL SYLLABLE GWEOP) */
    {{'\xea', '\xb6', '\xa3'}, 3, 0xADA3}, /* (HANGUL SYLLABLE GWEOH) */
    {{'\xea', '\xb6', '\xa5'}, 3, 0xADA5}, /* (HANGUL SYLLABLE GWEG) */
    {{'\xea', '\xb6', '\xa6'}, 3, 0xADA6}, /* (HANGUL SYLLABLE GWEGG) */
    {{'\xea', '\xb6', '\xa7'}, 3, 0xADA7}, /* (HANGUL SYLLABLE GWEGS) */
    {{'\xea', '\xb6', '\xa8'}, 3, 0xADA8}, /* (HANGUL SYLLABLE GWEN) */
    {{'\xea', '\xb6', '\xa9'}, 3, 0xADA9}, /* (HANGUL SYLLABLE GWENJ) */
    {{'\xea', '\xb6', '\xaa'}, 3, 0xADAA}, /* (HANGUL SYLLABLE GWENH) */
    {{'\xea', '\xb6', '\xab'}, 3, 0xADAB}, /* (HANGUL SYLLABLE GWED) */
    {{'\xea', '\xb6', '\xac'}, 3, 0xADAC}, /* (HANGUL SYLLABLE GWEL) */
    {{'\xea', '\xb6', '\xad'}, 3, 0xADAD}, /* (HANGUL SYLLABLE GWELG) */
    {{'\xea', '\xb6', '\xae'}, 3, 0xADAE}, /* (HANGUL SYLLABLE GWELM) */
    {{'\xea', '\xb6', '\xaf'}, 3, 0xADAF}, /* (HANGUL SYLLABLE GWELB) */
    {{'\xea', '\xb6', '\xb0'}, 3, 0xADB0}, /* (HANGUL SYLLABLE GWELS) */
    {{'\xea', '\xb6', '\xb1'}, 3, 0xADB1}, /* (HANGUL SYLLABLE GWELT) */
    {{'\xea', '\xb6', '\xb2'}, 3, 0xADB2}, /* (HANGUL SYLLABLE GWELP) */
    {{'\xea', '\xb6', '\xb3'}, 3, 0xADB3}, /* (HANGUL SYLLABLE GWELH) */
    {{'\xea', '\xb6', '\xb4'}, 3, 0xADB4}, /* (HANGUL SYLLABLE GWEM) */
    {{'\xea', '\xb6', '\xb5'}, 3, 0xADB5}, /* (HANGUL SYLLABLE GWEB) */
    {{'\xea', '\xb6', '\xb6'}, 3, 0xADB6}, /* (HANGUL SYLLABLE GWEBS) */
    {{'\xea', '\xb6', '\xb8'}, 3, 0xADB8}, /* (HANGUL SYLLABLE GWESS) */
    {{'\xea', '\xb6', '\xb9'}, 3, 0xADB9}, /* (HANGUL SYLLABLE GWENG) */
    {{'\xea', '\xb6', '\xba'}, 3, 0xADBA}, /* (HANGUL SYLLABLE GWEJ) */
    {{'\xea', '\xb6', '\xbb'}, 3, 0xADBB}, /* (HANGUL SYLLABLE GWEC) */
    {{'\xea', '\xb6', '\xbc'}, 3, 0xADBC}, /* (HANGUL SYLLABLE GWEK) */
    {{'\xea', '\xb6', '\xbd'}, 3, 0xADBD}, /* (HANGUL SYLLABLE GWET) */
    {{'\xea', '\xb6', '\xbe'}, 3, 0xADBE}, /* (HANGUL SYLLABLE GWEP) */
    {{'\xea', '\xb6', '\xbf'}, 3, 0xADBF}, /* (HANGUL SYLLABLE GWEH) */
    {{'\xea', '\xb7', '\x82'}, 3, 0xADC2}, /* (HANGUL SYLLABLE GWIGG) */
    {{'\xea', '\xb7', '\x83'}, 3, 0xADC3}, /* (HANGUL SYLLABLE GWIGS) */
    {{'\xea', '\xb7', '\x85'}, 3, 0xADC5}, /* (HANGUL SYLLABLE GWINJ) */
    {{'\xea', '\xb7', '\x86'}, 3, 0xADC6}, /* (HANGUL SYLLABLE GWINH) */
    {{'\xea', '\xb7', '\x87'}, 3, 0xADC7}, /* (HANGUL SYLLABLE GWID) */
    {{'\xea', '\xb7', '\x89'}, 3, 0xADC9}, /* (HANGUL SYLLABLE GWILG) */
    {{'\xea', '\xb7', '\x8a'}, 3, 0xADCA}, /* (HANGUL SYLLABLE GWILM) */
    {{'\xea', '\xb7', '\x8b'}, 3, 0xADCB}, /* (HANGUL SYLLABLE GWILB) */
    {{'\xea', '\xb7', '\x8c'}, 3, 0xADCC}, /* (HANGUL SYLLABLE GWILS) */
    {{'\xea', '\xb7', '\x8d'}, 3, 0xADCD}, /* (HANGUL SYLLABLE GWILT) */
    {{'\xea', '\xb7', '\x8e'}, 3, 0xADCE}, /* (HANGUL SYLLABLE GWILP) */
    {{'\xea', '\xb7', '\x8f'}, 3, 0xADCF}, /* (HANGUL SYLLABLE GWILH) */
    {{'\xea', '\xb7', '\x92'}, 3, 0xADD2}, /* (HANGUL SYLLABLE GWIBS) */
    {{'\xea', '\xb7', '\x94'}, 3, 0xADD4}, /* (HANGUL SYLLABLE GWISS) */
    {{'\xea', '\xb7', '\x95'}, 3, 0xADD5}, /* (HANGUL SYLLABLE GWING) */
    {{'\xea', '\xb7', '\x96'}, 3, 0xADD6}, /* (HANGUL SYLLABLE GWIJ) */
    {{'\xea', '\xb7', '\x97'}, 3, 0xADD7}, /* (HANGUL SYLLABLE GWIC) */
    {{'\xea', '\xb7', '\x98'}, 3, 0xADD8}, /* (HANGUL SYLLABLE GWIK) */
    {{'\xea', '\xb7', '\x99'}, 3, 0xADD9}, /* (HANGUL SYLLABLE GWIT) */
    {{'\xea', '\xb7', '\x9a'}, 3, 0xADDA}, /* (HANGUL SYLLABLE GWIP) */
    {{'\xea', '\xb7', '\x9b'}, 3, 0xADDB}, /* (HANGUL SYLLABLE GWIH) */
    {{'\xea', '\xb7', '\x9d'}, 3, 0xADDD}, /* (HANGUL SYLLABLE GYUG) */
    {{'\xea', '\xb7', '\x9e'}, 3, 0xADDE}, /* (HANGUL SYLLABLE GYUGG) */
    {{'\xea', '\xb7', '\x9f'}, 3, 0xADDF}, /* (HANGUL SYLLABLE GYUGS) */
    {{'\xea', '\xb7', '\xa1'}, 3, 0xADE1}, /* (HANGUL SYLLABLE GYUNJ) */
    {{'\xea', '\xb7', '\xa2'}, 3, 0xADE2}, /* (HANGUL SYLLABLE GYUNH) */
    {{'\xea', '\xb7', '\xa3'}, 3, 0xADE3}, /* (HANGUL SYLLABLE GYUD) */
    {{'\xea', '\xb7', '\xa5'}, 3, 0xADE5}, /* (HANGUL SYLLABLE GYULG) */
    {{'\xea', '\xb7', '\xa6'}, 3, 0xADE6}, /* (HANGUL SYLLABLE GYULM) */
    {{'\xea', '\xb7', '\xa7'}, 3, 0xADE7}, /* (HANGUL SYLLABLE GYULB) */
    {{'\xea', '\xb7', '\xa8'}, 3, 0xADE8}, /* (HANGUL SYLLABLE GYULS) */
    {{'\xea', '\xb7', '\xa9'}, 3, 0xADE9}, /* (HANGUL SYLLABLE GYULT) */
    {{'\xea', '\xb7', '\xaa'}, 3, 0xADEA}, /* (HANGUL SYLLABLE GYULP) */
    {{'\xea', '\xb7', '\xab'}, 3, 0xADEB}, /* (HANGUL SYLLABLE GYULH) */
    {{'\xea', '\xb7', '\xac'}, 3, 0xADEC}, /* (HANGUL SYLLABLE GYUM) */
    {{'\xea', '\xb7', '\xad'}, 3, 0xADED}, /* (HANGUL SYLLABLE GYUB) */
    {{'\xea', '\xb7', '\xae'}, 3, 0xADEE}, /* (HANGUL SYLLABLE GYUBS) */
    {{'\xea', '\xb7', '\xaf'}, 3, 0xADEF}, /* (HANGUL SYLLABLE GYUS) */
    {{'\xea', '\xb7', '\xb0'}, 3, 0xADF0}, /* (HANGUL SYLLABLE GYUSS) */
    {{'\xea', '\xb7', '\xb1'}, 3, 0xADF1}, /* (HANGUL SYLLABLE GYUNG) */
    {{'\xea', '\xb7', '\xb2'}, 3, 0xADF2}, /* (HANGUL SYLLABLE GYUJ) */
    {{'\xea', '\xb7', '\xb3'}, 3, 0xADF3}, /* (HANGUL SYLLABLE GYUC) */
    {{'\xea', '\xb7', '\xb4'}, 3, 0xADF4}, /* (HANGUL SYLLABLE GYUK) */
    {{'\xea', '\xb7', '\xb5'}, 3, 0xADF5}, /* (HANGUL SYLLABLE GYUT) */
    {{'\xea', '\xb7', '\xb6'}, 3, 0xADF6}, /* (HANGUL SYLLABLE GYUP) */
    {{'\xea', '\xb7', '\xb7'}, 3, 0xADF7}, /* (HANGUL SYLLABLE GYUH) */
    {{'\xea', '\xb7', '\xba'}, 3, 0xADFA}, /* (HANGUL SYLLABLE GEUGG) */
    {{'\xea', '\xb7', '\xbb'}, 3, 0xADFB}, /* (HANGUL SYLLABLE GEUGS) */
    {{'\xea', '\xb7', '\xbd'}, 3, 0xADFD}, /* (HANGUL SYLLABLE GEUNJ) */
    {{'\xea', '\xb7', '\xbe'}, 3, 0xADFE}, /* (HANGUL SYLLABLE GEUNH) */
    {{'\xea', '\xb8', '\x82'}, 3, 0xAE02}, /* (HANGUL SYLLABLE GEULM) */
    {{'\xea', '\xb8', '\x83'}, 3, 0xAE03}, /* (HANGUL SYLLABLE GEULB) */
    {{'\xea', '\xb8', '\x84'}, 3, 0xAE04}, /* (HANGUL SYLLABLE GEULS) */
    {{'\xea', '\xb8', '\x85'}, 3, 0xAE05}, /* (HANGUL SYLLABLE GEULT) */
    {{'\xea', '\xb8', '\x86'}, 3, 0xAE06}, /* (HANGUL SYLLABLE GEULP) */
    {{'\xea', '\xb8', '\x87'}, 3, 0xAE07}, /* (HANGUL SYLLABLE GEULH) */
    {{'\xea', '\xb8', '\x8a'}, 3, 0xAE0A}, /* (HANGUL SYLLABLE GEUBS) */
    {{'\xea', '\xb8', '\x8c'}, 3, 0xAE0C}, /* (HANGUL SYLLABLE GEUSS) */
    {{'\xea', '\xb8', '\x8e'}, 3, 0xAE0E}, /* (HANGUL SYLLABLE GEUJ) */
    {{'\xea', '\xb8', '\x8f'}, 3, 0xAE0F}, /* (HANGUL SYLLABLE GEUC) */
    {{'\xea', '\xb8', '\x90'}, 3, 0xAE10}, /* (HANGUL SYLLABLE GEUK) */
    {{'\xea', '\xb8', '\x91'}, 3, 0xAE11}, /* (HANGUL SYLLABLE GEUT) */
    {{'\xea', '\xb8', '\x92'}, 3, 0xAE12}, /* (HANGUL SYLLABLE GEUP) */
    {{'\xea', '\xb8', '\x93'}, 3, 0xAE13}, /* (HANGUL SYLLABLE GEUH) */
    {{'\xea', '\xb8', '\x95'}, 3, 0xAE15}, /* (HANGUL SYLLABLE GYIG) */
    {{'\xea', '\xb8', '\x96'}, 3, 0xAE16}, /* (HANGUL SYLLABLE GYIGG) */
    {{'\xea', '\xb8', '\x97'}, 3, 0xAE17}, /* (HANGUL SYLLABLE GYIGS) */
    {{'\xea', '\xb8', '\x98'}, 3, 0xAE18}, /* (HANGUL SYLLABLE GYIN) */
    {{'\xea', '\xb8', '\x99'}, 3, 0xAE19}, /* (HANGUL SYLLABLE GYINJ) */
    {{'\xea', '\xb8', '\x9a'}, 3, 0xAE1A}, /* (HANGUL SYLLABLE GYINH) */
    {{'\xea', '\xb8', '\x9b'}, 3, 0xAE1B}, /* (HANGUL SYLLABLE GYID) */
    {{'\xea', '\xb8', '\x9c'}, 3, 0xAE1C}, /* (HANGUL SYLLABLE GYIL) */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{'\xea', '\xb8', '\x9d'}, 3, 0xAE1D}, /* (HANGUL SYLLABLE GYILG) */
    {{'\xea', '\xb8', '\x9e'}, 3, 0xAE1E}, /* (HANGUL SYLLABLE GYILM) */
    {{'\xea', '\xb8', '\x9f'}, 3, 0xAE1F}, /* (HANGUL SYLLABLE GYILB) */
    {{'\xea', '\xb8', '\xa0'}, 3, 0xAE20}, /* (HANGUL SYLLABLE GYILS) */
    {{'\xea', '\xb8', '\xa1'}, 3, 0xAE21}, /* (HANGUL SYLLABLE GYILT) */
    {{'\xea', '\xb8', '\xa2'}, 3, 0xAE22}, /* (HANGUL SYLLABLE GYILP) */
    {{'\xea', '\xb8', '\xa3'}, 3, 0xAE23}, /* (HANGUL SYLLABLE GYILH) */
    {{'\xea', '\xb8', '\xa4'}, 3, 0xAE24}, /* (HANGUL SYLLABLE GYIM) */
    {{'\xea', '\xb8', '\xa5'}, 3, 0xAE25}, /* (HANGUL SYLLABLE GYIB) */
    {{'\xea', '\xb8', '\xa6'}, 3, 0xAE26}, /* (HANGUL SYLLABLE GYIBS) */
    {{'\xea', '\xb8', '\xa7'}, 3, 0xAE27}, /* (HANGUL SYLLABLE GYIS) */
    {{'\xea', '\xb8', '\xa8'}, 3, 0xAE28}, /* (HANGUL SYLLABLE GYISS) */
    {{'\xea', '\xb8', '\xa9'}, 3, 0xAE29}, /* (HANGUL SYLLABLE GYING) */
    {{'\xea', '\xb8', '\xaa'}, 3, 0xAE2A}, /* (HANGUL SYLLABLE GYIJ) */
    {{'\xea', '\xb8', '\xab'}, 3, 0xAE2B}, /* (HANGUL SYLLABLE GYIC) */
    {{'\xea', '\xb8', '\xac'}, 3, 0xAE2C}, /* (HANGUL SYLLABLE GYIK) */
    {{'\xea', '\xb8', '\xad'}, 3, 0xAE2D}, /* (HANGUL SYLLABLE GYIT) */
    {{'\xea', '\xb8', '\xae'}, 3, 0xAE2E}, /* (HANGUL SYLLABLE GYIP) */
    {{'\xea', '\xb8', '\xaf'}, 3, 0xAE2F}, /* (HANGUL SYLLABLE GYIH) */
    {{'\xea', '\xb8', '\xb2'}, 3, 0xAE32}, /* (HANGUL SYLLABLE GIGG) */
    {{'\xea', '\xb8', '\xb3'}, 3, 0xAE33}, /* (HANGUL SYLLABLE GIGS) */
    {{'\xea', '\xb8', '\xb5'}, 3, 0xAE35}, /* (HANGUL SYLLABLE GINJ) */
    {{'\xea', '\xb8', '\xb6'}, 3, 0xAE36}, /* (HANGUL SYLLABLE GINH) */
    {{'\xea', '\xb8', '\xb9'}, 3, 0xAE39}, /* (HANGUL SYLLABLE GILG) */
    {{'\xea', '\xb8', '\xbb'}, 3, 0xAE3B}, /* (HANGUL SYLLABLE GILB) */
    {{'\xea', '\xb8', '\xbc'}, 3, 0xAE3C}, /* (HANGUL SYLLABLE GILS) */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{'\xea', '\xb8', '\xbd'}, 3, 0xAE3D}, /* (HANGUL SYLLABLE GILT) */
    {{'\xea', '\xb8', '\xbe'}, 3, 0xAE3E}, /* (HANGUL SYLLABLE GILP) */
    {{'\xea', '\xb8', '\xbf'}, 3, 0xAE3F}, /* (HANGUL SYLLABLE GILH) */
    {{'\xea', '\xb9', '\x82'}, 3, 0xAE42}, /* (HANGUL SYLLABLE GIBS) */
    {{'\xea', '\xb9', '\x84'}, 3, 0xAE44}, /* (HANGUL SYLLABLE GISS) */
    {{'\xea', '\xb9', '\x87'}, 3, 0xAE47}, /* (HANGUL SYLLABLE GIC) */
    {{'\xea', '\xb9', '\x88'}, 3, 0xAE48}, /* (HANGUL SYLLABLE GIK) */
    {{'\xea', '\xb9', '\x89'}, 3, 0xAE49}, /* (HANGUL SYLLABLE GIT) */
    {{'\xea', '\xb9', '\x8b'}, 3, 0xAE4B}, /* (HANGUL SYLLABLE GIH) */
    {{'\xea', '\xb9', '\x8f'}, 3, 0xAE4F}, /* (HANGUL SYLLABLE GGAGS) */
    {{'\xea', '\xb9', '\x91'}, 3, 0xAE51}, /* (HANGUL SYLLABLE GGANJ) */
    {{'\xea', '\xb9', '\x92'}, 3, 0xAE52}, /* (HANGUL SYLLABLE GGANH) */
    {{'\xea', '\xb9', '\x93'}, 3, 0xAE53}, /* (HANGUL SYLLABLE GGAD) */
    {{'\xea', '\xb9', '\x95'}, 3, 0xAE55}, /* (HANGUL SYLLABLE GGALG) */
    {{'\xea', '\xb9', '\x97'}, 3, 0xAE57}, /* (HANGUL SYLLABLE GGALB) */
    {{'\xea', '\xb9', '\x98'}, 3, 0xAE58}, /* (HANGUL SYLLABLE GGALS) */
    {{'\xea', '\xb9', '\x99'}, 3, 0xAE59}, /* (HANGUL SYLLABLE GGALT) */
    {{'\xea', '\xb9', '\x9a'}, 3, 0xAE5A}, /* (HANGUL SYLLABLE GGALP) */
    {{'\xea', '\xb9', '\x9b'}, 3, 0xAE5B}, /* (HANGUL SYLLABLE GGALH) */
    {{'\xea', '\xb9', '\x9e'}, 3, 0xAE5E}, /* (HANGUL SYLLABLE GGABS) */
    {{'\xea', '\xb9', '\xa2'}, 3, 0xAE62}, /* (HANGUL SYLLABLE GGAJ) */
    {{'\xea', '\xb9', '\xa3'}, 3, 0xAE63}, /* (HANGUL SYLLABLE GGAC) */
    {{'\xea', '\xb9', '\xa4'}, 3, 0xAE64}, /* (HANGUL SYLLABLE GGAK) */
    {{'\xea', '\xb9', '\xa6'}, 3, 0xAE66}, /* (HANGUL SYLLABLE GGAP) */
    {{'\xea', '\xb9', '\xa7'}, 3, 0xAE67}, /* (HANGUL SYLLABLE GGAH) */
    {{'\xea', '\xb9', '\xaa'}, 3, 0xAE6A}, /* (HANGUL SYLLABLE GGAEGG) */
    {{'\xea', '\xb9', '\xab'}, 3, 0xAE6B}, /* (HANGUL SYLLABLE GGAEGS) */
    {{'\xea', '\xb9', '\xad'}, 3, 0xAE6D}, /* (HANGUL SYLLABLE GGAENJ) */
    {{'\xea', '\xb9', '\xae'}, 3, 0xAE6E}, /* (HANGUL SYLLABLE GGAENH) */
    {{'\xea', '\xb9', '\xaf'}, 3, 0xAE6F}, /* (HANGUL SYLLABLE GGAED) */
    {{'\xea', '\xb9', '\xb1'}, 3, 0xAE71}, /* (HANGUL SYLLABLE GGAELG) */
    {{'\xea', '\xb9', '\xb2'}, 3, 0xAE72}, /* (HANGUL SYLLABLE GGAELM) */
    {{'\xea', '\xb9', '\xb3'}, 3, 0xAE73}, /* (HANGUL SYLLABLE GGAELB) */
    {{'\xea', '\xb9', '\xb4'}, 3, 0xAE74}, /* (HANGUL SYLLABLE GGAELS) */
    {{'\xea', '\xb9', '\xb5'}, 3, 0xAE75}, /* (HANGUL SYLLABLE GGAELT) */
    {{'\xea', '\xb9', '\xb6'}, 3, 0xAE76}, /* (HANGUL SYLLABLE GGAELP) */
    {{'\xea', '\xb9', '\xb7'}, 3, 0xAE77}, /* (HANGUL SYLLABLE GGAELH) */
    {{'\xea', '\xb9', '\xba'}, 3, 0xAE7A}, /* (HANGUL SYLLABLE GGAEBS) */
    {{'\xea', '\xb9', '\xbe'}, 3, 0xAE7E}, /* (HANGUL SYLLABLE GGAEJ) */
    {{'\xea', '\xb9', '\xbf'}, 3, 0xAE7F}, /* (HANGUL SYLLABLE GGAEC) */
    {{'\xea', '\xba', '\x80'}, 3, 0xAE80}, /* (HANGUL SYLLABLE GGAEK) */
    {{'\xea', '\xba', '\x81'}, 3, 0xAE81}, /* (HANGUL SYLLABLE GGAET) */
    {{'\xea', '\xba', '\x82'}, 3, 0xAE82}, /* (HANGUL SYLLABLE GGAEP) */
    {{'\xea', '\xba', '\x83'}, 3, 0xAE83}, /* (HANGUL SYLLABLE GGAEH) */
    {{'\xea', '\xba', '\x86'}, 3, 0xAE86}, /* (HANGUL SYLLABLE GGYAGG) */
    {{'\xea', '\xba', '\x87'}, 3, 0xAE87}, /* (HANGUL SYLLABLE GGYAGS) */
    {{'\xea', '\xba', '\x88'}, 3, 0xAE88}, /* (HANGUL SYLLABLE GGYAN) */
    {{'\xea', '\xba', '\x89'}, 3, 0xAE89}, /* (HANGUL SYLLABLE GGYANJ) */
    {{'\xea', '\xba', '\x8a'}, 3, 0xAE8A}, /* (HANGUL SYLLABLE GGYANH) */
    {{'\xea', '\xba', '\x8b'}, 3, 0xAE8B}, /* (HANGUL SYLLABLE GGYAD) */
    {{'\xea', '\xba', '\x8d'}, 3, 0xAE8D}, /* (HANGUL SYLLABLE GGYALG) */
    {{'\xea', '\xba', '\x8e'}, 3, 0xAE8E}, /* (HANGUL SYLLABLE GGYALM) */
    {{'\xea', '\xba', '\x8f'}, 3, 0xAE8F}, /* (HANGUL SYLLABLE GGYALB) */
    {{'\xea', '\xba', '\x90'}, 3, 0xAE90}, /* (HANGUL SYLLABLE GGYALS) */
    {{'\xea', '\xba', '\x91'}, 3, 0xAE91}, /* (HANGUL SYLLABLE GGYALT) */
    {{'\xea', '\xba', '\x92'}, 3, 0xAE92}, /* (HANGUL SYLLABLE GGYALP) */
    {{'\xea', '\xba', '\x93'}, 3, 0xAE93}, /* (HANGUL SYLLABLE GGYALH) */
    {{'\xea', '\xba', '\x94'}, 3, 0xAE94}, /* (HANGUL SYLLABLE GGYAM) */
    {{'\xea', '\xba', '\x95'}, 3, 0xAE95}, /* (HANGUL SYLLABLE GGYAB) */
    {{'\xea', '\xba', '\x96'}, 3, 0xAE96}, /* (HANGUL SYLLABLE GGYABS) */
    {{'\xea', '\xba', '\x97'}, 3, 0xAE97}, /* (HANGUL SYLLABLE GGYAS) */
    {{'\xea', '\xba', '\x98'}, 3, 0xAE98}, /* (HANGUL SYLLABLE GGYASS) */
    {{'\xea', '\xba', '\x99'}, 3, 0xAE99}, /* (HANGUL SYLLABLE GGYANG) */
    {{'\xea', '\xba', '\x9a'}, 3, 0xAE9A}, /* (HANGUL SYLLABLE GGYAJ) */
    {{'\xea', '\xba', '\x9b'}, 3, 0xAE9B}, /* (HANGUL SYLLABLE GGYAC) */
    {{'\xea', '\xba', '\x9c'}, 3, 0xAE9C}, /* (HANGUL SYLLABLE GGYAK) */
    {{'\xea', '\xba', '\x9d'}, 3, 0xAE9D}, /* (HANGUL SYLLABLE GGYAT) */
    {{'\xea', '\xba', '\x9e'}, 3, 0xAE9E}, /* (HANGUL SYLLABLE GGYAP) */
    {{'\xea', '\xba', '\x9f'}, 3, 0xAE9F}, /* (HANGUL SYLLABLE GGYAH) */
    {{'\xea', '\xba', '\xa0'}, 3, 0xAEA0}, /* (HANGUL SYLLABLE GGYAE) */
    {{'\xea', '\xba', '\xa1'}, 3, 0xAEA1}, /* (HANGUL SYLLABLE GGYAEG) */
    {{'\xea', '\xba', '\xa2'}, 3, 0xAEA2}, /* (HANGUL SYLLABLE GGYAEGG) */
    {{'\xea', '\xba', '\xa3'}, 3, 0xAEA3}, /* (HANGUL SYLLABLE GGYAEGS) */
    {{'\xea', '\xba', '\xa4'}, 3, 0xAEA4}, /* (HANGUL SYLLABLE GGYAEN) */
    {{'\xea', '\xba', '\xa5'}, 3, 0xAEA5}, /* (HANGUL SYLLABLE GGYAENJ) */
    {{'\xea', '\xba', '\xa6'}, 3, 0xAEA6}, /* (HANGUL SYLLABLE GGYAENH) */
    {{'\xea', '\xba', '\xa7'}, 3, 0xAEA7}, /* (HANGUL SYLLABLE GGYAED) */
    {{'\xea', '\xba', '\xa8'}, 3, 0xAEA8}, /* (HANGUL SYLLABLE GGYAEL) */
    {{'\xea', '\xba', '\xa9'}, 3, 0xAEA9}, /* (HANGUL SYLLABLE GGYAELG) */
    {{'\xea', '\xba', '\xaa'}, 3, 0xAEAA}, /* (HANGUL SYLLABLE GGYAELM) */
    {{'\xea', '\xba', '\xab'}, 3, 0xAEAB}, /* (HANGUL SYLLABLE GGYAELB) */
    {{'\xea', '\xba', '\xac'}, 3, 0xAEAC}, /* (HANGUL SYLLABLE GGYAELS) */
    {{'\xea', '\xba', '\xad'}, 3, 0xAEAD}, /* (HANGUL SYLLABLE GGYAELT) */
    {{'\xea', '\xba', '\xae'}, 3, 0xAEAE}, /* (HANGUL SYLLABLE GGYAELP) */
    {{'\xea', '\xba', '\xaf'}, 3, 0xAEAF}, /* (HANGUL SYLLABLE GGYAELH) */
    {{'\xea', '\xba', '\xb0'}, 3, 0xAEB0}, /* (HANGUL SYLLABLE GGYAEM) */
    {{'\xea', '\xba', '\xb1'}, 3, 0xAEB1}, /* (HANGUL SYLLABLE GGYAEB) */
    {{'\xea', '\xba', '\xb2'}, 3, 0xAEB2}, /* (HANGUL SYLLABLE GGYAEBS) */
    {{'\xea', '\xba', '\xb3'}, 3, 0xAEB3}, /* (HANGUL SYLLABLE GGYAES) */
    {{'\xea', '\xba', '\xb4'}, 3, 0xAEB4}, /* (HANGUL SYLLABLE GGYAESS) */
    {{'\xea', '\xba', '\xb5'}, 3, 0xAEB5}, /* (HANGUL SYLLABLE GGYAENG) */
    {{'\xea', '\xba', '\xb6'}, 3, 0xAEB6}, /* (HANGUL SYLLABLE GGYAEJ) */
    {{'\xea', '\xba', '\xb7'}, 3, 0xAEB7}, /* (HANGUL SYLLABLE GGYAEC) */
    {{'\xea', '\xba', '\xb8'}, 3, 0xAEB8}, /* (HANGUL SYLLABLE GGYAEK) */
    {{'\xea', '\xba', '\xb9'}, 3, 0xAEB9}, /* (HANGUL SYLLABLE GGYAET) */
    {{'\xea', '\xba', '\xba'}, 3, 0xAEBA}, /* (HANGUL SYLLABLE GGYAEP) */
    {{'\xea', '\xba', '\xbb'}, 3, 0xAEBB}, /* (HANGUL SYLLABLE GGYAEH) */
    {{'\xea', '\xba', '\xbf'}, 3, 0xAEBF}, /* (HANGUL SYLLABLE GGEOGS) */
    {{'\xea', '\xbb', '\x81'}, 3, 0xAEC1}, /* (HANGUL SYLLABLE GGEONJ) */
    {{'\xea', '\xbb', '\x82'}, 3, 0xAEC2}, /* (HANGUL SYLLABLE GGEONH) */
    {{'\xea', '\xbb', '\x83'}, 3, 0xAEC3}, /* (HANGUL SYLLABLE GGEOD) */
    {{'\xea', '\xbb', '\x85'}, 3, 0xAEC5}, /* (HANGUL SYLLABLE GGEOLG) */
    {{'\xea', '\xbb', '\x86'}, 3, 0xAEC6}, /* (HANGUL SYLLABLE GGEOLM) */
    {{'\xea', '\xbb', '\x87'}, 3, 0xAEC7}, /* (HANGUL SYLLABLE GGEOLB) */
    {{'\xea', '\xbb', '\x88'}, 3, 0xAEC8}, /* (HANGUL SYLLABLE GGEOLS) */
    {{'\xea', '\xbb', '\x89'}, 3, 0xAEC9}, /* (HANGUL SYLLABLE GGEOLT) */
    {{'\xea', '\xbb', '\x8a'}, 3, 0xAECA}, /* (HANGUL SYLLABLE GGEOLP) */
    {{'\xea', '\xbb', '\x8b'}, 3, 0xAECB}, /* (HANGUL SYLLABLE GGEOLH) */
    {{'\xea', '\xbb', '\x8e'}, 3, 0xAECE}, /* (HANGUL SYLLABLE GGEOBS) */
    {{'\xea', '\xbb', '\x92'}, 3, 0xAED2}, /* (HANGUL SYLLABLE GGEOJ) */
    {{'\xea', '\xbb', '\x93'}, 3, 0xAED3}, /* (HANGUL SYLLABLE GGEOC) */
    {{'\xea', '\xbb', '\x94'}, 3, 0xAED4}, /* (HANGUL SYLLABLE GGEOK) */
    {{'\xea', '\xbb', '\x95'}, 3, 0xAED5}, /* (HANGUL SYLLABLE GGEOT) */
    {{'\xea', '\xbb', '\x96'}, 3, 0xAED6}, /* (HANGUL SYLLABLE GGEOP) */
    {{'\xea', '\xbb', '\x97'}, 3, 0xAED7}, /* (HANGUL SYLLABLE GGEOH) */
    {{'\xea', '\xbb', '\x9a'}, 3, 0xAEDA}, /* (HANGUL SYLLABLE GGEGG) */
    {{'\xea', '\xbb', '\x9b'}, 3, 0xAEDB}, /* (HANGUL SYLLABLE GGEGS) */
    {{'\xea', '\xbb', '\x9d'}, 3, 0xAEDD}, /* (HANGUL SYLLABLE GGENJ) */
    {{'\xea', '\xbb', '\x9e'}, 3, 0xAEDE}, /* (HANGUL SYLLABLE GGENH) */
    {{'\xea', '\xbb', '\x9f'}, 3, 0xAEDF}, /* (HANGUL SYLLABLE GGED) */
    {{'\xea', '\xbb', '\xa0'}, 3, 0xAEE0}, /* (HANGUL SYLLABLE GGEL) */
    {{'\xea', '\xbb', '\xa1'}, 3, 0xAEE1}, /* (HANGUL SYLLABLE GGELG) */
    {{'\xea', '\xbb', '\xa2'}, 3, 0xAEE2}, /* (HANGUL SYLLABLE GGELM) */
    {{'\xea', '\xbb', '\xa3'}, 3, 0xAEE3}, /* (HANGUL SYLLABLE GGELB) */
    {{'\xea', '\xbb', '\xa4'}, 3, 0xAEE4}, /* (HANGUL SYLLABLE GGELS) */
    {{'\xea', '\xbb', '\xa5'}, 3, 0xAEE5}, /* (HANGUL SYLLABLE GGELT) */
    {{'\xea', '\xbb', '\xa6'}, 3, 0xAEE6}, /* (HANGUL SYLLABLE GGELP) */
    {{'\xea', '\xbb', '\xa7'}, 3, 0xAEE7}, /* (HANGUL SYLLABLE GGELH) */
    {{'\xea', '\xbb', '\xa9'}, 3, 0xAEE9}, /* (HANGUL SYLLABLE GGEB) */
    {{'\xea', '\xbb', '\xaa'}, 3, 0xAEEA}, /* (HANGUL SYLLABLE GGEBS) */
    {{'\xea', '\xbb', '\xac'}, 3, 0xAEEC}, /* (HANGUL SYLLABLE GGESS) */
    {{'\xea', '\xbb', '\xae'}, 3, 0xAEEE}, /* (HANGUL SYLLABLE GGEJ) */
    {{'\xea', '\xbb', '\xaf'}, 3, 0xAEEF}, /* (HANGUL SYLLABLE GGEC) */
    {{'\xea', '\xbb', '\xb0'}, 3, 0xAEF0}, /* (HANGUL SYLLABLE GGEK) */
    {{'\xea', '\xbb', '\xb1'}, 3, 0xAEF1}, /* (HANGUL SYLLABLE GGET) */
    {{'\xea', '\xbb', '\xb2'}, 3, 0xAEF2}, /* (HANGUL SYLLABLE GGEP) */
    {{'\xea', '\xbb', '\xb3'}, 3, 0xAEF3}, /* (HANGUL SYLLABLE GGEH) */
    {{'\xea', '\xbb', '\xb5'}, 3, 0xAEF5}, /* (HANGUL SYLLABLE GGYEOG) */
    {{'\xea', '\xbb', '\xb6'}, 3, 0xAEF6}, /* (HANGUL SYLLABLE GGYEOGG) */
    {{'\xea', '\xbb', '\xb7'}, 3, 0xAEF7}, /* (HANGUL SYLLABLE GGYEOGS) */
    {{'\xea', '\xbb', '\xb9'}, 3, 0xAEF9}, /* (HANGUL SYLLABLE GGYEONJ) */
    {{'\xea', '\xbb', '\xba'}, 3, 0xAEFA}, /* (HANGUL SYLLABLE GGYEONH) */
    {{'\xea', '\xbb', '\xbb'}, 3, 0xAEFB}, /* (HANGUL SYLLABLE GGYEOD) */
    {{'\xea', '\xbb', '\xbd'}, 3, 0xAEFD}, /* (HANGUL SYLLABLE GGYEOLG) */
    {{'\xea', '\xbb', '\xbe'}, 3, 0xAEFE}, /* (HANGUL SYLLABLE GGYEOLM) */
    {{'\xea', '\xbb', '\xbf'}, 3, 0xAEFF}, /* (HANGUL SYLLABLE GGYEOLB) */
    {{'\xea', '\xbc', '\x80'}, 3, 0xAF00}, /* (HANGUL SYLLABLE GGYEOLS) */
    {{'\xea', '\xbc', '\x81'}, 3, 0xAF01}, /* (HANGUL SYLLABLE GGYEOLT) */
    {{'\xea', '\xbc', '\x82'}, 3, 0xAF02}, /* (HANGUL SYLLABLE GGYEOLP) */
    {{'\xea', '\xbc', '\x83'}, 3, 0xAF03}, /* (HANGUL SYLLABLE GGYEOLH) */
    {{'\xea', '\xbc', '\x84'}, 3, 0xAF04}, /* (HANGUL SYLLABLE GGYEOM) */
    {{'\xea', '\xbc', '\x85'}, 3, 0xAF05}, /* (HANGUL SYLLABLE GGYEOB) */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{'\xea', '\xbc', '\x86'}, 3, 0xAF06}, /* (HANGUL SYLLABLE GGYEOBS) */
    {{'\xea', '\xbc', '\x89'}, 3, 0xAF09}, /* (HANGUL SYLLABLE GGYEONG) */
    {{'\xea', '\xbc', '\x8a'}, 3, 0xAF0A}, /* (HANGUL SYLLABLE GGYEOJ) */
    {{'\xea', '\xbc', '\x8b'}, 3, 0xAF0B}, /* (HANGUL SYLLABLE GGYEOC) */
    {{'\xea', '\xbc', '\x8c'}, 3, 0xAF0C}, /* (HANGUL SYLLABLE GGYEOK) */
    {{'\xea', '\xbc', '\x8e'}, 3, 0xAF0E}, /* (HANGUL SYLLABLE GGYEOP) */
    {{'\xea', '\xbc', '\x8f'}, 3, 0xAF0F}, /* (HANGUL SYLLABLE GGYEOH) */
    {{'\xea', '\xbc', '\x91'}, 3, 0xAF11}, /* (HANGUL SYLLABLE GGYEG) */
    {{'\xea', '\xbc', '\x92'}, 3, 0xAF12}, /* (HANGUL SYLLABLE GGYEGG) */
    {{'\xea', '\xbc', '\x93'}, 3, 0xAF13}, /* (HANGUL SYLLABLE GGYEGS) */
    {{'\xea', '\xbc', '\x94'}, 3, 0xAF14}, /* (HANGUL SYLLABLE GGYEN) */
    {{'\xea', '\xbc', '\x95'}, 3, 0xAF15}, /* (HANGUL SYLLABLE GGYENJ) */
    {{'\xea', '\xbc', '\x96'}, 3, 0xAF16}, /* (HANGUL SYLLABLE GGYENH) */
    {{'\xea', '\xbc', '\x97'}, 3, 0xAF17}, /* (HANGUL SYLLABLE GGYED) */
    {{'\xea', '\xbc', '\x98'}, 3, 0xAF18}, /* (HANGUL SYLLABLE GGYEL) */
    {{'\xea', '\xbc', '\x99'}, 3, 0xAF19}, /* (HANGUL SYLLABLE GGYELG) */
    {{'\xea', '\xbc', '\x9a'}, 3, 0xAF1A}, /* (HANGUL SYLLABLE GGYELM) */
    {{'\xea', '\xbc', '\x9b'}, 3, 0xAF1B}, /* (HANGUL SYLLABLE GGYELB) */
    {{'\xea', '\xbc', '\x9c'}, 3, 0xAF1C}, /* (HANGUL SYLLABLE GGYELS) */
    {{'\xea', '\xbc', '\x9d'}, 3, 0xAF1D}, /* (HANGUL SYLLABLE GGYELT) */
    {{'\xea', '\xbc', '\x9e'}, 3, 0xAF1E}, /* (HANGUL SYLLABLE GGYELP) */
    {{'\xea', '\xbc', '\x9f'}, 3, 0xAF1F}, /* (HANGUL SYLLABLE GGYELH) */
    {{'\xea', '\xbc', '\xa0'}, 3, 0xAF20}, /* (HANGUL SYLLABLE GGYEM) */
    {{'\xea', '\xbc', '\xa1'}, 3, 0xAF21}, /* (HANGUL SYLLABLE GGYEB) */
    {{'\xea', '\xbc', '\xa2'}, 3, 0xAF22}, /* (HANGUL SYLLABLE GGYEBS) */
    {{'\xea', '\xbc', '\xa3'}, 3, 0xAF23}, /* (HANGUL SYLLABLE GGYES) */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{'\xea', '\xbc', '\xa4'}, 3, 0xAF24}, /* (HANGUL SYLLABLE GGYESS) */
    {{'\xea', '\xbc', '\xa5'}, 3, 0xAF25}, /* (HANGUL SYLLABLE GGYENG) */
    {{'\xea', '\xbc', '\xa6'}, 3, 0xAF26}, /* (HANGUL SYLLABLE GGYEJ) */
    {{'\xea', '\xbc', '\xa7'}, 3, 0xAF27}, /* (HANGUL SYLLABLE GGYEC) */
    {{'\xea', '\xbc', '\xa8'}, 3, 0xAF28}, /* (HANGUL SYLLABLE GGYEK) */
    {{'\xea', '\xbc', '\xa9'}, 3, 0xAF29}, /* (HANGUL SYLLABLE GGYET) */
    {{'\xea', '\xbc', '\xaa'}, 3, 0xAF2A}, /* (HANGUL SYLLABLE GGYEP) */
    {{'\xea', '\xbc', '\xab'}, 3, 0xAF2B}, /* (HANGUL SYLLABLE GGYEH) */
    {{'\xea', '\xbc', '\xae'}, 3, 0xAF2E}, /* (HANGUL SYLLABLE GGOGG) */
    {{'\xea', '\xbc', '\xaf'}, 3, 0xAF2F}, /* (HANGUL SYLLABLE GGOGS) */
    {{'\xea', '\xbc', '\xb1'}, 3, 0xAF31}, /* (HANGUL SYLLABLE GGONJ) */
    {{'\xea', '\xbc', '\xb3'}, 3, 0xAF33}, /* (HANGUL SYLLABLE GGOD) */
    {{'\xea', '\xbc', '\xb5'}, 3, 0xAF35}, /* (HANGUL SYLLABLE GGOLG) */
    {{'\xea', '\xbc', '\xb6'}, 3, 0xAF36}, /* (HANGUL SYLLABLE GGOLM) */
    {{'\xea', '\xbc', '\xb7'}, 3, 0xAF37}, /* (HANGUL SYLLABLE GGOLB) */
    {{'\xea', '\xbc', '\xb8'}, 3, 0xAF38}, /* (HANGUL SYLLABLE GGOLS) */
    {{'\xea', '\xbc', '\xb9'}, 3, 0xAF39}, /* (HANGUL SYLLABLE GGOLT) */
    {{'\xea', '\xbc', '\xba'}, 3, 0xAF3A}, /* (HANGUL SYLLABLE GGOLP) */
    {{'\xea', '\xbc', '\xbb'}, 3, 0xAF3B}, /* (HANGUL SYLLABLE GGOLH) */
    {{'\xea', '\xbc', '\xbe'}, 3, 0xAF3E}, /* (HANGUL SYLLABLE GGOBS) */
    {{'\xea', '\xbd', '\x80'}, 3, 0xAF40}, /* (HANGUL SYLLABLE GGOSS) */
    {{'\xea', '\xbd', '\x84'}, 3, 0xAF44}, /* (HANGUL SYLLABLE GGOK) */
    {{'\xea', '\xbd', '\x85'}, 3, 0xAF45}, /* (HANGUL SYLLABLE GGOT) */
    {{'\xea', '\xbd', '\x86'}, 3, 0xAF46}, /* (HANGUL SYLLABLE GGOP) */
    {{'\xea', '\xbd', '\x87'}, 3, 0xAF47}, /* (HANGUL SYLLABLE GGOH) */
    {{'\xea', '\xbd', '\x8a'}, 3, 0xAF4A}, /* (HANGUL SYLLABLE GGWAGG) */
    {{'\xea', '\xbd', '\x8b'}, 3, 0xAF4B}, /* (HANGUL SYLLABLE GGWAGS) */
    {{'\xea', '\xbd', '\x8c'}, 3, 0xAF4C}, /* (HANGUL SYLLABLE GGWAN) */
    {{'\xea', '\xbd', '\x8d'}, 3, 0xAF4D}, /* (HANGUL SYLLABLE GGWANJ) */
    {{'\xea', '\xbd', '\x8e'}, 3, 0xAF4E}, /* (HANGUL SYLLABLE GGWANH) */
    {{'\xea', '\xbd', '\x8f'}, 3, 0xAF4F}, /* (HANGUL SYLLABLE GGWAD) */
    {{'\xea', '\xbd', '\x91'}, 3, 0xAF51}, /* (HANGUL SYLLABLE GGWALG) */
    {{'\xea', '\xbd', '\x92'}, 3, 0xAF52}, /* (HANGUL SYLLABLE GGWALM) */
    {{'\xea', '\xbd', '\x93'}, 3, 0xAF53}, /* (HANGUL SYLLABLE GGWALB) */
    {{'\xea', '\xbd', '\x94'}, 3, 0xAF54}, /* (HANGUL SYLLABLE GGWALS) */
    {{'\xea', '\xbd', '\x95'}, 3, 0xAF55}, /* (HANGUL SYLLABLE GGWALT) */
    {{'\xea', '\xbd', '\x96'}, 3, 0xAF56}, /* (HANGUL SYLLABLE GGWALP) */
    {{'\xea', '\xbd', '\x97'}, 3, 0xAF57}, /* (HANGUL SYLLABLE GGWALH) */
    {{'\xea', '\xbd', '\x98'}, 3, 0xAF58}, /* (HANGUL SYLLABLE GGWAM) */
    {{'\xea', '\xbd', '\x99'}, 3, 0xAF59}, /* (HANGUL SYLLABLE GGWAB) */
    {{'\xea', '\xbd', '\x9a'}, 3, 0xAF5A}, /* (HANGUL SYLLABLE GGWABS) */
    {{'\xea', '\xbd', '\x9b'}, 3, 0xAF5B}, /* (HANGUL SYLLABLE GGWAS) */
    {{'\xea', '\xbd', '\x9e'}, 3, 0xAF5E}, /* (HANGUL SYLLABLE GGWAJ) */
    {{'\xea', '\xbd', '\x9f'}, 3, 0xAF5F}, /* (HANGUL SYLLABLE GGWAC) */
    {{'\xea', '\xbd', '\xa0'}, 3, 0xAF60}, /* (HANGUL SYLLABLE GGWAK) */
    {{'\xea', '\xbd', '\xa1'}, 3, 0xAF61}, /* (HANGUL SYLLABLE GGWAT) */
    {{'\xea', '\xbd', '\xa2'}, 3, 0xAF62}, /* (HANGUL SYLLABLE GGWAP) */
    {{'\xea', '\xbd', '\xa3'}, 3, 0xAF63}, /* (HANGUL SYLLABLE GGWAH) */
    {{'\xea', '\xbd', '\xa6'}, 3, 0xAF66}, /* (HANGUL SYLLABLE GGWAEGG) */
    {{'\xea', '\xbd', '\xa7'}, 3, 0xAF67}, /* (HANGUL SYLLABLE GGWAEGS) */
    {{'\xea', '\xbd', '\xa8'}, 3, 0xAF68}, /* (HANGUL SYLLABLE GGWAEN) */
    {{'\xea', '\xbd', '\xa9'}, 3, 0xAF69}, /* (HANGUL SYLLABLE GGWAENJ) */
    {{'\xea', '\xbd', '\xaa'}, 3, 0xAF6A}, /* (HANGUL SYLLABLE GGWAENH) */
    {{'\xea', '\xbd', '\xab'}, 3, 0xAF6B}, /* (HANGUL SYLLABLE GGWAED) */
    {{'\xea', '\xbd', '\xac'}, 3, 0xAF6C}, /* (HANGUL SYLLABLE GGWAEL) */
    {{'\xea', '\xbd', '\xad'}, 3, 0xAF6D}, /* (HANGUL SYLLABLE GGWAELG) */
    {{'\xea', '\xbd', '\xae'}, 3, 0xAF6E}, /* (HANGUL SYLLABLE GGWAELM) */
    {{'\xea', '\xbd', '\xaf'}, 3, 0xAF6F}, /* (HANGUL SYLLABLE GGWAELB) */
    {{'\xea', '\xbd', '\xb0'}, 3, 0xAF70}, /* (HANGUL SYLLABLE GGWAELS) */
    {{'\xea', '\xbd', '\xb1'}, 3, 0xAF71}, /* (HANGUL SYLLABLE GGWAELT) */
    {{'\xea', '\xbd', '\xb2'}, 3, 0xAF72}, /* (HANGUL SYLLABLE GGWAELP) */
    {{'\xea', '\xbd', '\xb3'}, 3, 0xAF73}, /* (HANGUL SYLLABLE GGWAELH) */
    {{'\xea', '\xbd', '\xb4'}, 3, 0xAF74}, /* (HANGUL SYLLABLE GGWAEM) */
    {{'\xea', '\xbd', '\xb5'}, 3, 0xAF75}, /* (HANGUL SYLLABLE GGWAEB) */
    {{'\xea', '\xbd', '\xb6'}, 3, 0xAF76}, /* (HANGUL SYLLABLE GGWAEBS) */
    {{'\xea', '\xbd', '\xb7'}, 3, 0xAF77}, /* (HANGUL SYLLABLE GGWAES) */
    {{'\xea', '\xbd', '\xb8'}, 3, 0xAF78}, /* (HANGUL SYLLABLE GGWAESS) */
    {{'\xea', '\xbd', '\xba'}, 3, 0xAF7A}, /* (HANGUL SYLLABLE GGWAEJ) */
    {{'\xea', '\xbd', '\xbb'}, 3, 0xAF7B}, /* (HANGUL SYLLABLE GGWAEC) */
    {{'\xea', '\xbd', '\xbc'}, 3, 0xAF7C}, /* (HANGUL SYLLABLE GGWAEK) */
    {{'\xea', '\xbd', '\xbd'}, 3, 0xAF7D}, /* (HANGUL SYLLABLE GGWAET) */
    {{'\xea', '\xbd', '\xbe'}, 3, 0xAF7E}, /* (HANGUL SYLLABLE GGWAEP) */
    {{'\xea', '\xbd', '\xbf'}, 3, 0xAF7F}, /* (HANGUL SYLLABLE GGWAEH) */
    {{'\xea', '\xbe', '\x81'}, 3, 0xAF81}, /* (HANGUL SYLLABLE GGOEG) */
    {{'\xea', '\xbe', '\x82'}, 3, 0xAF82}, /* (HANGUL SYLLABLE GGOEGG) */
    {{'\xea', '\xbe', '\x83'}, 3, 0xAF83}, /* (HANGUL SYLLABLE GGOEGS) */
    {{'\xea', '\xbe', '\x85'}, 3, 0xAF85}, /* (HANGUL SYLLABLE GGOENJ) */
    {{'\xea', '\xbe', '\x86'}, 3, 0xAF86}, /* (HANGUL SYLLABLE GGOENH) */
    {{'\xea', '\xbe', '\x87'}, 3, 0xAF87}, /* (HANGUL SYLLABLE GGOED) */
    {{'\xea', '\xbe', '\x89'}, 3, 0xAF89}, /* (HANGUL SYLLABLE GGOELG) */
    {{'\xea', '\xbe', '\x8a'}, 3, 0xAF8A}, /* (HANGUL SYLLABLE GGOELM) */
    {{'\xea', '\xbe', '\x8b'}, 3, 0xAF8B}, /* (HANGUL SYLLABLE GGOELB) */
    {{'\xea', '\xbe', '\x8c'}, 3, 0xAF8C}, /* (HANGUL SYLLABLE GGOELS) */
    {{'\xea', '\xbe', '\x8d'}, 3, 0xAF8D}, /* (HANGUL SYLLABLE GGOELT) */
    {{'\xea', '\xbe', '\x8e'}, 3, 0xAF8E}, /* (HANGUL SYLLABLE GGOELP) */
    {{'\xea', '\xbe', '\x8f'}, 3, 0xAF8F}, /* (HANGUL SYLLABLE GGOELH) */
    {{'\xea', '\xbe', '\x92'}, 3, 0xAF92}, /* (HANGUL SYLLABLE GGOEBS) */
    {{'\xea', '\xbe', '\x93'}, 3, 0xAF93}, /* (HANGUL SYLLABLE GGOES) */
    {{'\xea', '\xbe', '\x94'}, 3, 0xAF94}, /* (HANGUL SYLLABLE GGOESS) */
    {{'\xea', '\xbe', '\x96'}, 3, 0xAF96}, /* (HANGUL SYLLABLE GGOEJ) */
    {{'\xea', '\xbe', '\x97'}, 3, 0xAF97}, /* (HANGUL SYLLABLE GGOEC) */
    {{'\xea', '\xbe', '\x98'}, 3, 0xAF98}, /* (HANGUL SYLLABLE GGOEK) */
    {{'\xea', '\xbe', '\x99'}, 3, 0xAF99}, /* (HANGUL SYLLABLE GGOET) */
    {{'\xea', '\xbe', '\x9a'}, 3, 0xAF9A}, /* (HANGUL SYLLABLE GGOEP) */
    {{'\xea', '\xbe', '\x9b'}, 3, 0xAF9B}, /* (HANGUL SYLLABLE GGOEH) */
    {{'\xea', '\xbe', '\x9d'}, 3, 0xAF9D}, /* (HANGUL SYLLABLE GGYOG) */
    {{'\xea', '\xbe', '\x9e'}, 3, 0xAF9E}, /* (HANGUL SYLLABLE GGYOGG) */
    {{'\xea', '\xbe', '\x9f'}, 3, 0xAF9F}, /* (HANGUL SYLLABLE GGYOGS) */
    {{'\xea', '\xbe', '\xa0'}, 3, 0xAFA0}, /* (HANGUL SYLLABLE GGYON) */
    {{'\xea', '\xbe', '\xa1'}, 3, 0xAFA1}, /* (HANGUL SYLLABLE GGYONJ) */
    {{'\xea', '\xbe', '\xa2'}, 3, 0xAFA2}, /* (HANGUL SYLLABLE GGYONH) */
    {{'\xea', '\xbe', '\xa3'}, 3, 0xAFA3}, /* (HANGUL SYLLABLE GGYOD) */
    {{'\xea', '\xbe', '\xa4'}, 3, 0xAFA4}, /* (HANGUL SYLLABLE GGYOL) */
    {{'\xea', '\xbe', '\xa5'}, 3, 0xAFA5}, /* (HANGUL SYLLABLE GGYOLG) */
    {{'\xea', '\xbe', '\xa6'}, 3, 0xAFA6}, /* (HANGUL SYLLABLE GGYOLM) */
    {{'\xea', '\xbe', '\xa7'}, 3, 0xAFA7}, /* (HANGUL SYLLABLE GGYOLB) */
    {{'\xea', '\xbe', '\xa8'}, 3, 0xAFA8}, /* (HANGUL SYLLABLE GGYOLS) */
    {{'\xea', '\xbe', '\xa9'}, 3, 0xAFA9}, /* (HANGUL SYLLABLE GGYOLT) */
    {{'\xea', '\xbe', '\xaa'}, 3, 0xAFAA}, /* (HANGUL SYLLABLE GGYOLP) */
    {{'\xea', '\xbe', '\xab'}, 3, 0xAFAB}, /* (HANGUL SYLLABLE GGYOLH) */
    {{'\xea', '\xbe', '\xac'}, 3, 0xAFAC}, /* (HANGUL SYLLABLE GGYOM) */
    {{'\xea', '\xbe', '\xad'}, 3, 0xAFAD}, /* (HANGUL SYLLABLE GGYOB) */
    {{'\xea', '\xbe', '\xae'}, 3, 0xAFAE}, /* (HANGUL SYLLABLE GGYOBS) */
    {{'\xea', '\xbe', '\xaf'}, 3, 0xAFAF}, /* (HANGUL SYLLABLE GGYOS) */
    {{'\xea', '\xbe', '\xb0'}, 3, 0xAFB0}, /* (HANGUL SYLLABLE GGYOSS) */
    {{'\xea', '\xbe', '\xb1'}, 3, 0xAFB1}, /* (HANGUL SYLLABLE GGYONG) */
    {{'\xea', '\xbe', '\xb2'}, 3, 0xAFB2}, /* (HANGUL SYLLABLE GGYOJ) */
    {{'\xea', '\xbe', '\xb3'}, 3, 0xAFB3}, /* (HANGUL SYLLABLE GGYOC) */
    {{'\xea', '\xbe', '\xb4'}, 3, 0xAFB4}, /* (HANGUL SYLLABLE GGYOK) */
    {{'\xea', '\xbe', '\xb5'}, 3, 0xAFB5}, /* (HANGUL SYLLABLE GGYOT) */
    {{'\xea', '\xbe', '\xb6'}, 3, 0xAFB6}, /* (HANGUL SYLLABLE GGYOP) */
    {{'\xea', '\xbe', '\xb7'}, 3, 0xAFB7}, /* (HANGUL SYLLABLE GGYOH) */
    {{'\xea', '\xbe', '\xba'}, 3, 0xAFBA}, /* (HANGUL SYLLABLE GGUGG) */
    {{'\xea', '\xbe', '\xbb'}, 3, 0xAFBB}, /* (HANGUL SYLLABLE GGUGS) */
    {{'\xea', '\xbe', '\xbd'}, 3, 0xAFBD}, /* (HANGUL SYLLABLE GGUNJ) */
    {{'\xea', '\xbe', '\xbe'}, 3, 0xAFBE}, /* (HANGUL SYLLABLE GGUNH) */
    {{'\xea', '\xbe', '\xbf'}, 3, 0xAFBF}, /* (HANGUL SYLLABLE GGUD) */
    {{'\xea', '\xbf', '\x81'}, 3, 0xAFC1}, /* (HANGUL SYLLABLE GGULG) */
    {{'\xea', '\xbf', '\x82'}, 3, 0xAFC2}, /* (HANGUL SYLLABLE GGULM) */
    {{'\xea', '\xbf', '\x83'}, 3, 0xAFC3}, /* (HANGUL SYLLABLE GGULB) */
    {{'\xea', '\xbf', '\x84'}, 3, 0xAFC4}, /* (HANGUL SYLLABLE GGULS) */
    {{'\xea', '\xbf', '\x85'}, 3, 0xAFC5}, /* (HANGUL SYLLABLE GGULT) */
    {{'\xea', '\xbf', '\x86'}, 3, 0xAFC6}, /* (HANGUL SYLLABLE GGULP) */
    {{'\xea', '\xbf', '\x8a'}, 3, 0xAFCA}, /* (HANGUL SYLLABLE GGUBS) */
    {{'\xea', '\xbf', '\x8c'}, 3, 0xAFCC}, /* (HANGUL SYLLABLE GGUSS) */
    {{'\xea', '\xbf', '\x8f'}, 3, 0xAFCF}, /* (HANGUL SYLLABLE GGUC) */
    {{'\xea', '\xbf', '\x90'}, 3, 0xAFD0}, /* (HANGUL SYLLABLE GGUK) */
    {{'\xea', '\xbf', '\x91'}, 3, 0xAFD1}, /* (HANGUL SYLLABLE GGUT) */
    {{'\xea', '\xbf', '\x92'}, 3, 0xAFD2}, /* (HANGUL SYLLABLE GGUP) */
    {{'\xea', '\xbf', '\x93'}, 3, 0xAFD3}, /* (HANGUL SYLLABLE GGUH) */
    {{'\xea', '\xbf', '\x95'}, 3, 0xAFD5}, /* (HANGUL SYLLABLE GGWEOG) */
    {{'\xea', '\xbf', '\x96'}, 3, 0xAFD6}, /* (HANGUL SYLLABLE GGWEOGG) */
    {{'\xea', '\xbf', '\x97'}, 3, 0xAFD7}, /* (HANGUL SYLLABLE GGWEOGS) */
    {{'\xea', '\xbf', '\x98'}, 3, 0xAFD8}, /* (HANGUL SYLLABLE GGWEON) */
    {{'\xea', '\xbf', '\x99'}, 3, 0xAFD9}, /* (HANGUL SYLLABLE GGWEONJ) */
    {{'\xea', '\xbf', '\x9a'}, 3, 0xAFDA}, /* (HANGUL SYLLABLE GGWEONH) */
    {{'\xea', '\xbf', '\x9b'}, 3, 0xAFDB}, /* (HANGUL SYLLABLE GGWEOD) */
    {{'\xea', '\xbf', '\x9d'}, 3, 0xAFDD}, /* (HANGUL SYLLABLE GGWEOLG) */
    {{'\xea', '\xbf', '\x9e'}, 3, 0xAFDE}, /* (HANGUL SYLLABLE GGWEOLM) */
    {{'\xea', '\xbf', '\x9f'}, 3, 0xAFDF}, /* (HANGUL SYLLABLE GGWEOLB) */
    {{'\xea', '\xbf', '\xa0'}, 3, 0xAFE0}, /* (HANGUL SYLLABLE GGWEOLS) */
    {{'\xea', '\xbf', '\xa1'}, 3, 0xAFE1}, /* (HANGUL SYLLABLE GGWEOLT) */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{'\xea', '\xbf', '\xa2'}, 3, 0xAFE2}, /* (HANGUL SYLLABLE GGWEOLP) */
    {{'\xea', '\xbf', '\xa3'}, 3, 0xAFE3}, /* (HANGUL SYLLABLE GGWEOLH) */
    {{'\xea', '\xbf', '\xa4'}, 3, 0xAFE4}, /* (HANGUL SYLLABLE GGWEOM) */
    {{'\xea', '\xbf', '\xa5'}, 3, 0xAFE5}, /* (HANGUL SYLLABLE GGWEOB) */
    {{'\xea', '\xbf', '\xa6'}, 3, 0xAFE6}, /* (HANGUL SYLLABLE GGWEOBS) */
    {{'\xea', '\xbf', '\xa7'}, 3, 0xAFE7}, /* (HANGUL SYLLABLE GGWEOS) */
    {{'\xea', '\xbf', '\xaa'}, 3, 0xAFEA}, /* (HANGUL SYLLABLE GGWEOJ) */
    {{'\xea', '\xbf', '\xab'}, 3, 0xAFEB}, /* (HANGUL SYLLABLE GGWEOC) */
    {{'\xea', '\xbf', '\xac'}, 3, 0xAFEC}, /* (HANGUL SYLLABLE GGWEOK) */
    {{'\xea', '\xbf', '\xad'}, 3, 0xAFED}, /* (HANGUL SYLLABLE GGWEOT) */
    {{'\xea', '\xbf', '\xae'}, 3, 0xAFEE}, /* (HANGUL SYLLABLE GGWEOP) */
    {{'\xea', '\xbf', '\xaf'}, 3, 0xAFEF}, /* (HANGUL SYLLABLE GGWEOH) */
    {{'\xea', '\xbf', '\xb2'}, 3, 0xAFF2}, /* (HANGUL SYLLABLE GGWEGG) */
    {{'\xea', '\xbf', '\xb3'}, 3, 0xAFF3}, /* (HANGUL SYLLABLE GGWEGS) */
    {{'\xea', '\xbf', '\xb5'}, 3, 0xAFF5}, /* (HANGUL SYLLABLE GGWENJ) */
    {{'\xea', '\xbf', '\xb6'}, 3, 0xAFF6}, /* (HANGUL SYLLABLE GGWENH) */
    {{'\xea', '\xbf', '\xb7'}, 3, 0xAFF7}, /* (HANGUL SYLLABLE GGWED) */
    {{'\xea', '\xbf', '\xb9'}, 3, 0xAFF9}, /* (HANGUL SYLLABLE GGWELG) */
    {{'\xea', '\xbf', '\xba'}, 3, 0xAFFA}, /* (HANGUL SYLLABLE GGWELM) */
    {{'\xea', '\xbf', '\xbb'}, 3, 0xAFFB}, /* (HANGUL SYLLABLE GGWELB) */
    {{'\xea', '\xbf', '\xbc'}, 3, 0xAFFC}, /* (HANGUL SYLLABLE GGWELS) */
    {{'\xea', '\xbf', '\xbd'}, 3, 0xAFFD}, /* (HANGUL SYLLABLE GGWELT) */
    {{'\xea', '\xbf', '\xbe'}, 3, 0xAFFE}, /* (HANGUL SYLLABLE GGWELP) */
    {{'\xea', '\xbf', '\xbf'}, 3, 0xAFFF}, /* (HANGUL SYLLABLE GGWELH) */
    {{'\xeb', '\x80', '\x82'}, 3, 0xB002}, /* (HANGUL SYLLABLE GGWEBS) */
    {{'\xeb', '\x80', '\x83'}, 3, 0xB003}, /* (HANGUL SYLLABLE GGWES) */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{'\xeb', '\x80', '\x85'}, 3, 0xB005}, /* (HANGUL SYLLABLE GGWENG) */
    {{'\xeb', '\x80', '\x86'}, 3, 0xB006}, /* (HANGUL SYLLABLE GGWEJ) */
    {{'\xeb', '\x80', '\x87'}, 3, 0xB007}, /* (HANGUL SYLLABLE GGWEC) */
    {{'\xeb', '\x80', '\x88'}, 3, 0xB008}, /* (HANGUL SYLLABLE GGWEK) */
    {{'\xeb', '\x80', '\x89'}, 3, 0xB009}, /* (HANGUL SYLLABLE GGWET) */
    {{'\xeb', '\x80', '\x8a'}, 3, 0xB00A}, /* (HANGUL SYLLABLE GGWEP) */
    {{'\xeb', '\x80', '\x8b'}, 3, 0xB00B}, /* (HANGUL SYLLABLE GGWEH) */
    {{'\xeb', '\x80', '\x8d'}, 3, 0xB00D}, /* (HANGUL SYLLABLE GGWIG) */
    {{'\xeb', '\x80', '\x8e'}, 3, 0xB00E}, /* (HANGUL SYLLABLE GGWIGG) */
    {{'\xeb', '\x80', '\x8f'}, 3, 0xB00F}, /* (HANGUL SYLLABLE GGWIGS) */
    {{'\xeb', '\x80', '\x91'}, 3, 0xB011}, /* (HANGUL SYLLABLE GGWINJ) */
    {{'\xeb', '\x80', '\x92'}, 3, 0xB012}, /* (HANGUL SYLLABLE GGWINH) */
    {{'\xeb', '\x80', '\x93'}, 3, 0xB013}, /* (HANGUL SYLLABLE GGWID) */
    {{'\xeb', '\x80', '\x95'}, 3, 0xB015}, /* (HANGUL SYLLABLE GGWILG) */
    {{'\xeb', '\x80', '\x96'}, 3, 0xB016}, /* (HANGUL SYLLABLE GGWILM) */
    {{'\xeb', '\x80', '\x97'}, 3, 0xB017}, /* (HANGUL SYLLABLE GGWILB) */
    {{'\xeb', '\x80', '\x98'}, 3, 0xB018}, /* (HANGUL SYLLABLE GGWILS) */
    {{'\xeb', '\x80', '\x99'}, 3, 0xB019}, /* (HANGUL SYLLABLE GGWILT) */
    {{'\xeb', '\x80', '\x9a'}, 3, 0xB01A}, /* (HANGUL SYLLABLE GGWILP) */
    {{'\xeb', '\x80', '\x9b'}, 3, 0xB01B}, /* (HANGUL SYLLABLE GGWILH) */
    {{'\xeb', '\x80', '\x9e'}, 3, 0xB01E}, /* (HANGUL SYLLABLE GGWIBS) */
    {{'\xeb', '\x80', '\x9f'}, 3, 0xB01F}, /* (HANGUL SYLLABLE GGWIS) */
    {{'\xeb', '\x80', '\xa0'}, 3, 0xB020}, /* (HANGUL SYLLABLE GGWISS) */
    {{'\xeb', '\x80', '\xa1'}, 3, 0xB021}, /* (HANGUL SYLLABLE GGWING) */
    {{'\xeb', '\x80', '\xa2'}, 3, 0xB022}, /* (HANGUL SYLLABLE GGWIJ) */
    {{'\xeb', '\x80', '\xa3'}, 3, 0xB023}, /* (HANGUL SYLLABLE GGWIC) */
    {{'\xeb', '\x80', '\xa4'}, 3, 0xB024}, /* (HANGUL SYLLABLE GGWIK) */
    {{'\xeb', '\x80', '\xa5'}, 3, 0xB025}, /* (HANGUL SYLLABLE GGWIT) */
    {{'\xeb', '\x80', '\xa6'}, 3, 0xB026}, /* (HANGUL SYLLABLE GGWIP) */
    {{'\xeb', '\x80', '\xa7'}, 3, 0xB027}, /* (HANGUL SYLLABLE GGWIH) */
    {{'\xeb', '\x80', '\xa9'}, 3, 0xB029}, /* (HANGUL SYLLABLE GGYUG) */
    {{'\xeb', '\x80', '\xaa'}, 3, 0xB02A}, /* (HANGUL SYLLABLE GGYUGG) */
    {{'\xeb', '\x80', '\xab'}, 3, 0xB02B}, /* (HANGUL SYLLABLE GGYUGS) */
    {{'\xeb', '\x80', '\xac'}, 3, 0xB02C}, /* (HANGUL SYLLABLE GGYUN) */
    {{'\xeb', '\x80', '\xad'}, 3, 0xB02D}, /* (HANGUL SYLLABLE GGYUNJ) */
    {{'\xeb', '\x80', '\xae'}, 3, 0xB02E}, /* (HANGUL SYLLABLE GGYUNH) */
    {{'\xeb', '\x80', '\xaf'}, 3, 0xB02F}, /* (HANGUL SYLLABLE GGYUD) */
    {{'\xeb', '\x80', '\xb0'}, 3, 0xB030}, /* (HANGUL SYLLABLE GGYUL) */
    {{'\xeb', '\x80', '\xb1'}, 3, 0xB031}, /* (HANGUL SYLLABLE GGYULG) */
    {{'\xeb', '\x80', '\xb2'}, 3, 0xB032}, /* (HANGUL SYLLABLE GGYULM) */
    {{'\xeb', '\x80', '\xb3'}, 3, 0xB033}, /* (HANGUL SYLLABLE GGYULB) */
    {{'\xeb', '\x80', '\xb4'}, 3, 0xB034}, /* (HANGUL SYLLABLE GGYULS) */
    {{'\xeb', '\x80', '\xb5'}, 3, 0xB035}, /* (HANGUL SYLLABLE GGYULT) */
    {{'\xeb', '\x80', '\xb6'}, 3, 0xB036}, /* (HANGUL SYLLABLE GGYULP) */
    {{'\xeb', '\x80', '\xb7'}, 3, 0xB037}, /* (HANGUL SYLLABLE GGYULH) */
    {{'\xeb', '\x80', '\xb8'}, 3, 0xB038}, /* (HANGUL SYLLABLE GGYUM) */
    {{'\xeb', '\x80', '\xb9'}, 3, 0xB039}, /* (HANGUL SYLLABLE GGYUB) */
    {{'\xeb', '\x80', '\xba'}, 3, 0xB03A}, /* (HANGUL SYLLABLE GGYUBS) */
    {{'\xeb', '\x80', '\xbb'}, 3, 0xB03B}, /* (HANGUL SYLLABLE GGYUS) */
    {{'\xeb', '\x80', '\xbc'}, 3, 0xB03C}, /* (HANGUL SYLLABLE GGYUSS) */
    {{'\xeb', '\x80', '\xbd'}, 3, 0xB03D}, /* (HANGUL SYLLABLE GGYUNG) */
    {{'\xeb', '\x80', '\xbe'}, 3, 0xB03E}, /* (HANGUL SYLLABLE GGYUJ) */
    {{'\xeb', '\x80', '\xbf'}, 3, 0xB03F}, /* (HANGUL SYLLABLE GGYUC) */
    {{'\xeb', '\x81', '\x80'}, 3, 0xB040}, /* (HANGUL SYLLABLE GGYUK) */
    {{'\xeb', '\x81', '\x81'}, 3, 0xB041}, /* (HANGUL SYLLABLE GGYUT) */
    {{'\xeb', '\x81', '\x82'}, 3, 0xB042}, /* (HANGUL SYLLABLE GGYUP) */
    {{'\xeb', '\x81', '\x83'}, 3, 0xB043}, /* (HANGUL SYLLABLE GGYUH) */
    {{'\xeb', '\x81', '\x86'}, 3, 0xB046}, /* (HANGUL SYLLABLE GGEUGG) */
    {{'\xeb', '\x81', '\x87'}, 3, 0xB047}, /* (HANGUL SYLLABLE GGEUGS) */
    {{'\xeb', '\x81', '\x89'}, 3, 0xB049}, /* (HANGUL SYLLABLE GGEUNJ) */
    {{'\xeb', '\x81', '\x8b'}, 3, 0xB04B}, /* (HANGUL SYLLABLE GGEUD) */
    {{'\xeb', '\x81', '\x8d'}, 3, 0xB04D}, /* (HANGUL SYLLABLE GGEULG) */
    {{'\xeb', '\x81', '\x8f'}, 3, 0xB04F}, /* (HANGUL SYLLABLE GGEULB) */
    {{'\xeb', '\x81', '\x90'}, 3, 0xB050}, /* (HANGUL SYLLABLE GGEULS) */
    {{'\xeb', '\x81', '\x91'}, 3, 0xB051}, /* (HANGUL SYLLABLE GGEULT) */
    {{'\xeb', '\x81', '\x92'}, 3, 0xB052}, /* (HANGUL SYLLABLE GGEULP) */
    {{'\xeb', '\x81', '\x96'}, 3, 0xB056}, /* (HANGUL SYLLABLE GGEUBS) */
    {{'\xeb', '\x81', '\x98'}, 3, 0xB058}, /* (HANGUL SYLLABLE GGEUSS) */
    {{'\xeb', '\x81', '\x9a'}, 3, 0xB05A}, /* (HANGUL SYLLABLE GGEUJ) */
    {{'\xeb', '\x81', '\x9b'}, 3, 0xB05B}, /* (HANGUL SYLLABLE GGEUC) */
    {{'\xeb', '\x81', '\x9c'}, 3, 0xB05C}, /* (HANGUL SYLLABLE GGEUK) */
    {{'\xeb', '\x81', '\x9e'}, 3, 0xB05E}, /* (HANGUL SYLLABLE GGEUP) */
    {{'\xeb', '\x81', '\x9f'}, 3, 0xB05F}, /* (HANGUL SYLLABLE GGEUH) */
    {{'\xeb', '\x81', '\xa0'}, 3, 0xB060}, /* (HANGUL SYLLABLE GGYI) */
    {{'\xeb', '\x81', '\xa1'}, 3, 0xB061}, /* (HANGUL SYLLABLE GGYIG) */
    {{'\xeb', '\x81', '\xa2'}, 3, 0xB062}, /* (HANGUL SYLLABLE GGYIGG) */
    {{'\xeb', '\x81', '\xa3'}, 3, 0xB063}, /* (HANGUL SYLLABLE GGYIGS) */
    {{'\xeb', '\x81', '\xa4'}, 3, 0xB064}, /* (HANGUL SYLLABLE GGYIN) */
    {{'\xeb', '\x81', '\xa5'}, 3, 0xB065}, /* (HANGUL SYLLABLE GGYINJ) */
    {{'\xeb', '\x81', '\xa6'}, 3, 0xB066}, /* (HANGUL SYLLABLE GGYINH) */
    {{'\xeb', '\x81', '\xa7'}, 3, 0xB067}, /* (HANGUL SYLLABLE GGYID) */
    {{'\xeb', '\x81', '\xa8'}, 3, 0xB068}, /* (HANGUL SYLLABLE GGYIL) */
    {{'\xeb', '\x81', '\xa9'}, 3, 0xB069}, /* (HANGUL SYLLABLE GGYILG) */
    {{'\xeb', '\x81', '\xaa'}, 3, 0xB06A}, /* (HANGUL SYLLABLE GGYILM) */
    {{'\xeb', '\x81', '\xab'}, 3, 0xB06B}, /* (HANGUL SYLLABLE GGYILB) */
    {{'\xeb', '\x81', '\xac'}, 3, 0xB06C}, /* (HANGUL SYLLABLE GGYILS) */
    {{'\xeb', '\x81', '\xad'}, 3, 0xB06D}, /* (HANGUL SYLLABLE GGYILT) */
    {{'\xeb', '\x81', '\xae'}, 3, 0xB06E}, /* (HANGUL SYLLABLE GGYILP) */
    {{'\xeb', '\x81', '\xaf'}, 3, 0xB06F}, /* (HANGUL SYLLABLE GGYILH) */
    {{'\xeb', '\x81', '\xb0'}, 3, 0xB070}, /* (HANGUL SYLLABLE GGYIM) */
    {{'\xeb', '\x81', '\xb1'}, 3, 0xB071}, /* (HANGUL SYLLABLE GGYIB) */
    {{'\xeb', '\x81', '\xb2'}, 3, 0xB072}, /* (HANGUL SYLLABLE GGYIBS) */
    {{'\xeb', '\x81', '\xb3'}, 3, 0xB073}, /* (HANGUL SYLLABLE GGYIS) */
    {{'\xeb', '\x81', '\xb4'}, 3, 0xB074}, /* (HANGUL SYLLABLE GGYISS) */
    {{'\xeb', '\x81', '\xb5'}, 3, 0xB075}, /* (HANGUL SYLLABLE GGYING) */
    {{'\xeb', '\x81', '\xb6'}, 3, 0xB076}, /* (HANGUL SYLLABLE GGYIJ) */
    {{'\xeb', '\x81', '\xb7'}, 3, 0xB077}, /* (HANGUL SYLLABLE GGYIC) */
    {{'\xeb', '\x81', '\xb8'}, 3, 0xB078}, /* (HANGUL SYLLABLE GGYIK) */
    {{'\xeb', '\x81', '\xb9'}, 3, 0xB079}, /* (HANGUL SYLLABLE GGYIT) */
    {{'\xeb', '\x81', '\xba'}, 3, 0xB07A}, /* (HANGUL SYLLABLE GGYIP) */
    {{'\xeb', '\x81', '\xbb'}, 3, 0xB07B}, /* (HANGUL SYLLABLE GGYIH) */
    {{'\xeb', '\x81', '\xbe'}, 3, 0xB07E}, /* (HANGUL SYLLABLE GGIGG) */
    {{'\xeb', '\x81', '\xbf'}, 3, 0xB07F}, /* (HANGUL SYLLABLE GGIGS) */
    {{'\xeb', '\x82', '\x81'}, 3, 0xB081}, /* (HANGUL SYLLABLE GGINJ) */
    {{'\xeb', '\x82', '\x82'}, 3, 0xB082}, /* (HANGUL SYLLABLE GGINH) */
    {{'\xeb', '\x82', '\x83'}, 3, 0xB083}, /* (HANGUL SYLLABLE GGID) */
    {{'\xeb', '\x82', '\x85'}, 3, 0xB085}, /* (HANGUL SYLLABLE GGILG) */
    {{'\xeb', '\x82', '\x86'}, 3, 0xB086}, /* (HANGUL SYLLABLE GGILM) */
    {{'\xeb', '\x82', '\x87'}, 3, 0xB087}, /* (HANGUL SYLLABLE GGILB) */
    {{'\xeb', '\x82', '\x88'}, 3, 0xB088}, /* (HANGUL SYLLABLE GGILS) */
    {{'\xeb', '\x82', '\x89'}, 3, 0xB089}, /* (HANGUL SYLLABLE GGILT) */
    {{'\xeb', '\x82', '\x8a'}, 3, 0xB08A}, /* (HANGUL SYLLABLE GGILP) */
    {{'\xeb', '\x82', '\x8b'}, 3, 0xB08B}, /* (HANGUL SYLLABLE GGILH) */
    {{'\xeb', '\x82', '\x8e'}, 3, 0xB08E}, /* (HANGUL SYLLABLE GGIBS) */
    {{'\xeb', '\x82', '\x90'}, 3, 0xB090}, /* (HANGUL SYLLABLE GGISS) */
    {{'\xeb', '\x82', '\x92'}, 3, 0xB092}, /* (HANGUL SYLLABLE GGIJ) */
    {{'\xeb', '\x82', '\x93'}, 3, 0xB093}, /* (HANGUL SYLLABLE GGIC) */
    {{'\xeb', '\x82', '\x94'}, 3, 0xB094}, /* (HANGUL SYLLABLE GGIK) */
    {{'\xeb', '\x82', '\x95'}, 3, 0xB095}, /* (HANGUL SYLLABLE GGIT) */
    {{'\xeb', '\x82', '\x96'}, 3, 0xB096}, /* (HANGUL SYLLABLE GGIP) */
    {{'\xeb', '\x82', '\x97'}, 3, 0xB097}, /* (HANGUL SYLLABLE GGIH) */
    {{'\xeb', '\x82', '\x9b'}, 3, 0xB09B}, /* (HANGUL SYLLABLE NAGS) */
    {{'\xeb', '\x82', '\x9d'}, 3, 0xB09D}, /* (HANGUL SYLLABLE NANJ) */
    {{'\xeb', '\x82', '\x9e'}, 3, 0xB09E}, /* (HANGUL SYLLABLE NANH) */
    {{'\xeb', '\x82', '\xa3'}, 3, 0xB0A3}, /* (HANGUL SYLLABLE NALB) */
    {{'\xeb', '\x82', '\xa4'}, 3, 0xB0A4}, /* (HANGUL SYLLABLE NALS) */
    {{'\xeb', '\x82', '\xa5'}, 3, 0xB0A5}, /* (HANGUL SYLLABLE NALT) */
    {{'\xeb', '\x82', '\xa6'}, 3, 0xB0A6}, /* (HANGUL SYLLABLE NALP) */
    {{'\xeb', '\x82', '\xa7'}, 3, 0xB0A7}, /* (HANGUL SYLLABLE NALH) */
    {{'\xeb', '\x82', '\xaa'}, 3, 0xB0AA}, /* (HANGUL SYLLABLE NABS) */
    {{'\xeb', '\x82', '\xb0'}, 3, 0xB0B0}, /* (HANGUL SYLLABLE NAK) */
    {{'\xeb', '\x82', '\xb2'}, 3, 0xB0B2}, /* (HANGUL SYLLABLE NAP) */
    {{'\xeb', '\x82', '\xb6'}, 3, 0xB0B6}, /* (HANGUL SYLLABLE NAEGG) */
    {{'\xeb', '\x82', '\xb7'}, 3, 0xB0B7}, /* (HANGUL SYLLABLE NAEGS) */
    {{'\xeb', '\x82', '\xb9'}, 3, 0xB0B9}, /* (HANGUL SYLLABLE NAENJ) */
    {{'\xeb', '\x82', '\xba'}, 3, 0xB0BA}, /* (HANGUL SYLLABLE NAENH) */
    {{'\xeb', '\x82', '\xbb'}, 3, 0xB0BB}, /* (HANGUL SYLLABLE NAED) */
    {{'\xeb', '\x82', '\xbd'}, 3, 0xB0BD}, /* (HANGUL SYLLABLE NAELG) */
    {{'\xeb', '\x82', '\xbe'}, 3, 0xB0BE}, /* (HANGUL SYLLABLE NAELM) */
    {{'\xeb', '\x82', '\xbf'}, 3, 0xB0BF}, /* (HANGUL SYLLABLE NAELB) */
    {{'\xeb', '\x83', '\x80'}, 3, 0xB0C0}, /* (HANGUL SYLLABLE NAELS) */
    {{'\xeb', '\x83', '\x81'}, 3, 0xB0C1}, /* (HANGUL SYLLABLE NAELT) */
    {{'\xeb', '\x83', '\x82'}, 3, 0xB0C2}, /* (HANGUL SYLLABLE NAELP) */
    {{'\xeb', '\x83', '\x83'}, 3, 0xB0C3}, /* (HANGUL SYLLABLE NAELH) */
    {{'\xeb', '\x83', '\x86'}, 3, 0xB0C6}, /* (HANGUL SYLLABLE NAEBS) */
    {{'\xeb', '\x83', '\x8a'}, 3, 0xB0CA}, /* (HANGUL SYLLABLE NAEJ) */
    {{'\xeb', '\x83', '\x8b'}, 3, 0xB0CB}, /* (HANGUL SYLLABLE NAEC) */
    {{'\xeb', '\x83', '\x8c'}, 3, 0xB0CC}, /* (HANGUL SYLLABLE NAEK) */
    {{'\xeb', '\x83', '\x8d'}, 3, 0xB0CD}, /* (HANGUL SYLLABLE NAET) */
    {{'\xeb', '\x83', '\x8e'}, 3, 0xB0CE}, /* (HANGUL SYLLABLE NAEP) */
    {{'\xeb', '\x83', '\x8f'}, 3, 0xB0CF}, /* (HANGUL SYLLABLE NAEH) */
    {{'\xeb', '\x83', '\x92'}, 3, 0xB0D2}, /* (HANGUL SYLLABLE NYAGG) */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{'\xeb', '\x83', '\x93'}, 3, 0xB0D3}, /* (HANGUL SYLLABLE NYAGS) */
    {{'\xeb', '\x83', '\x95'}, 3, 0xB0D5}, /* (HANGUL SYLLABLE NYANJ) */
    {{'\xeb', '\x83', '\x96'}, 3, 0xB0D6}, /* (HANGUL SYLLABLE NYANH) */
    {{'\xeb', '\x83', '\x97'}, 3, 0xB0D7}, /* (HANGUL SYLLABLE NYAD) */
    {{'\xeb', '\x83', '\x99'}, 3, 0xB0D9}, /* (HANGUL SYLLABLE NYALG) */
    {{'\xeb', '\x83', '\x9a'}, 3, 0xB0DA}, /* (HANGUL SYLLABLE NYALM) */
    {{'\xeb', '\x83', '\x9b'}, 3, 0xB0DB}, /* (HANGUL SYLLABLE NYALB) */
    {{'\xeb', '\x83', '\x9c'}, 3, 0xB0DC}, /* (HANGUL SYLLABLE NYALS) */
    {{'\xeb', '\x83', '\x9d'}, 3, 0xB0DD}, /* (HANGUL SYLLABLE NYALT) */
    {{'\xeb', '\x83', '\x9e'}, 3, 0xB0DE}, /* (HANGUL SYLLABLE NYALP) */
    {{'\xeb', '\x83', '\x9f'}, 3, 0xB0DF}, /* (HANGUL SYLLABLE NYALH) */
    {{'\xeb', '\x83', '\xa1'}, 3, 0xB0E1}, /* (HANGUL SYLLABLE NYAB) */
    {{'\xeb', '\x83', '\xa2'}, 3, 0xB0E2}, /* (HANGUL SYLLABLE NYABS) */
    {{'\xeb', '\x83', '\xa3'}, 3, 0xB0E3}, /* (HANGUL SYLLABLE NYAS) */
    {{'\xeb', '\x83', '\xa4'}, 3, 0xB0E4}, /* (HANGUL SYLLABLE NYASS) */
    {{'\xeb', '\x83', '\xa6'}, 3, 0xB0E6}, /* (HANGUL SYLLABLE NYAJ) */
    {{'\xeb', '\x83', '\xa7'}, 3, 0xB0E7}, /* (HANGUL SYLLABLE NYAC) */
    {{'\xeb', '\x83', '\xa8'}, 3, 0xB0E8}, /* (HANGUL SYLLABLE NYAK) */
    {{'\xeb', '\x83', '\xa9'}, 3, 0xB0E9}, /* (HANGUL SYLLABLE NYAT) */
    {{'\xeb', '\x83', '\xaa'}, 3, 0xB0EA}, /* (HANGUL SYLLABLE NYAP) */
    {{'\xeb', '\x83', '\xab'}, 3, 0xB0EB}, /* (HANGUL SYLLABLE NYAH) */
    {{'\xeb', '\x83', '\xac'}, 3, 0xB0EC}, /* (HANGUL SYLLABLE NYAE) */
    {{'\xeb', '\x83', '\xad'}, 3, 0xB0ED}, /* (HANGUL SYLLABLE NYAEG) */
    {{'\xeb', '\x83', '\xae'}, 3, 0xB0EE}, /* (HANGUL SYLLABLE NYAEGG) */
    {{'\xeb', '\x83', '\xaf'}, 3, 0xB0EF}, /* (HANGUL SYLLABLE NYAEGS) */
    {{'\xeb', '\x83', '\xb0'}, 3, 0xB0F0}, /* (HANGUL SYLLABLE NYAEN) */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{'\xeb', '\x83', '\xb1'}, 3, 0xB0F1}, /* (HANGUL SYLLABLE NYAENJ) */
    {{'\xeb', '\x83', '\xb2'}, 3, 0xB0F2}, /* (HANGUL SYLLABLE NYAENH) */
    {{'\xeb', '\x83', '\xb3'}, 3, 0xB0F3}, /* (HANGUL SYLLABLE NYAED) */
    {{'\xeb', '\x83', '\xb4'}, 3, 0xB0F4}, /* (HANGUL SYLLABLE NYAEL) */
    {{'\xeb', '\x83', '\xb5'}, 3, 0xB0F5}, /* (HANGUL SYLLABLE NYAELG) */
    {{'\xeb', '\x83', '\xb6'}, 3, 0xB0F6}, /* (HANGUL SYLLABLE NYAELM) */
    {{'\xeb', '\x83', '\xb7'}, 3, 0xB0F7}, /* (HANGUL SYLLABLE NYAELB) */
    {{'\xeb', '\x83', '\xb8'}, 3, 0xB0F8}, /* (HANGUL SYLLABLE NYAELS) */
    {{'\xeb', '\x83', '\xb9'}, 3, 0xB0F9}, /* (HANGUL SYLLABLE NYAELT) */
    {{'\xeb', '\x83', '\xba'}, 3, 0xB0FA}, /* (HANGUL SYLLABLE NYAELP) */
    {{'\xeb', '\x83', '\xbb'}, 3, 0xB0FB}, /* (HANGUL SYLLABLE NYAELH) */
    {{'\xeb', '\x83', '\xbc'}, 3, 0xB0FC}, /* (HANGUL SYLLABLE NYAEM) */
    {{'\xeb', '\x83', '\xbd'}, 3, 0xB0FD}, /* (HANGUL SYLLABLE NYAEB) */
    {{'\xeb', '\x83', '\xbe'}, 3, 0xB0FE}, /* (HANGUL SYLLABLE NYAEBS) */
    {{'\xeb', '\x83', '\xbf'}, 3, 0xB0FF}, /* (HANGUL SYLLABLE NYAES) */
    {{'\xeb', '\x84', '\x80'}, 3, 0xB100}, /* (HANGUL SYLLABLE NYAESS) */
    {{'\xeb', '\x84', '\x81'}, 3, 0xB101}, /* (HANGUL SYLLABLE NYAENG) */
    {{'\xeb', '\x84', '\x82'}, 3, 0xB102}, /* (HANGUL SYLLABLE NYAEJ) */
    {{'\xeb', '\x84', '\x83'}, 3, 0xB103}, /* (HANGUL SYLLABLE NYAEC) */
    {{'\xeb', '\x84', '\x84'}, 3, 0xB104}, /* (HANGUL SYLLABLE NYAEK) */
    {{'\xeb', '\x84', '\x85'}, 3, 0xB105}, /* (HANGUL SYLLABLE NYAET) */
    {{'\xeb', '\x84', '\x86'}, 3, 0xB106}, /* (HANGUL SYLLABLE NYAEP) */
    {{'\xeb', '\x84', '\x87'}, 3, 0xB107}, /* (HANGUL SYLLABLE NYAEH) */
    {{'\xeb', '\x84', '\x8a'}, 3, 0xB10A}, /* (HANGUL SYLLABLE NEOGG) */
    {{'\xeb', '\x84', '\x8d'}, 3, 0xB10D}, /* (HANGUL SYLLABLE NEONJ) */
    {{'\xeb', '\x84', '\x8e'}, 3, 0xB10E}, /* (HANGUL SYLLABLE NEONH) */
    {{'\xeb', '\x84', '\x8f'}, 3, 0xB10F}, /* (HANGUL SYLLABLE NEOD) */
    {{'\xeb', '\x84', '\x91'}, 3, 0xB111}, /* (HANGUL SYLLABLE NEOLG) */
    {{'\xeb', '\x84', '\x94'}, 3, 0xB114}, /* (HANGUL SYLLABLE NEOLS) */
    {{'\xeb', '\x84', '\x95'}, 3, 0xB115}, /* (HANGUL SYLLABLE NEOLT) */
    {{'\xeb', '\x84', '\x96'}, 3, 0xB116}, /* (HANGUL SYLLABLE NEOLP) */
    {{'\xeb', '\x84', '\x97'}, 3, 0xB117}, /* (HANGUL SYLLABLE NEOLH) */
    {{'\xeb', '\x84', '\x9a'}, 3, 0xB11A}, /* (HANGUL SYLLABLE NEOBS) */
    {{'\xeb', '\x84', '\x9e'}, 3, 0xB11E}, /* (HANGUL SYLLABLE NEOJ) */
    {{'\xeb', '\x84', '\x9f'}, 3, 0xB11F}, /* (HANGUL SYLLABLE NEOC) */
    {{'\xeb', '\x84', '\xa0'}, 3, 0xB120}, /* (HANGUL SYLLABLE NEOK) */
    {{'\xeb', '\x84', '\xa1'}, 3, 0xB121}, /* (HANGUL SYLLABLE NEOT) */
    {{'\xeb', '\x84', '\xa2'}, 3, 0xB122}, /* (HANGUL SYLLABLE NEOP) */
    {{'\xeb', '\x84', '\xa6'}, 3, 0xB126}, /* (HANGUL SYLLABLE NEGG) */
    {{'\xeb', '\x84', '\xa7'}, 3, 0xB127}, /* (HANGUL SYLLABLE NEGS) */
    {{'\xeb', '\x84', '\xa9'}, 3, 0xB129}, /* (HANGUL SYLLABLE NENJ) */
    {{'\xeb', '\x84', '\xaa'}, 3, 0xB12A}, /* (HANGUL SYLLABLE NENH) */
    {{'\xeb', '\x84', '\xab'}, 3, 0xB12B}, /* (HANGUL SYLLABLE NED) */
    {{'\xeb', '\x84', '\xad'}, 3, 0xB12D}, /* (HANGUL SYLLABLE NELG) */
    {{'\xeb', '\x84', '\xae'}, 3, 0xB12E}, /* (HANGUL SYLLABLE NELM) */
    {{'\xeb', '\x84', '\xaf'}, 3, 0xB12F}, /* (HANGUL SYLLABLE NELB) */
    {{'\xeb', '\x84', '\xb0'}, 3, 0xB130}, /* (HANGUL SYLLABLE NELS) */
    {{'\xeb', '\x84', '\xb1'}, 3, 0xB131}, /* (HANGUL SYLLABLE NELT) */
    {{'\xeb', '\x84', '\xb2'}, 3, 0xB132}, /* (HANGUL SYLLABLE NELP) */
    {{'\xeb', '\x84', '\xb3'}, 3, 0xB133}, /* (HANGUL SYLLABLE NELH) */
    {{'\xeb', '\x84', '\xb6'}, 3, 0xB136}, /* (HANGUL SYLLABLE NEBS) */
    {{'\xeb', '\x84', '\xba'}, 3, 0xB13A}, /* (HANGUL SYLLABLE NEJ) */
    {{'\xeb', '\x84', '\xbb'}, 3, 0xB13B}, /* (HANGUL SYLLABLE NEC) */
    {{'\xeb', '\x84', '\xbc'}, 3, 0xB13C}, /* (HANGUL SYLLABLE NEK) */
    {{'\xeb', '\x84', '\xbd'}, 3, 0xB13D}, /* (HANGUL SYLLABLE NET) */
    {{'\xeb', '\x84', '\xbe'}, 3, 0xB13E}, /* (HANGUL SYLLABLE NEP) */
    {{'\xeb', '\x84', '\xbf'}, 3, 0xB13F}, /* (HANGUL SYLLABLE NEH) */
    {{'\xeb', '\x85', '\x82'}, 3, 0xB142}, /* (HANGUL SYLLABLE NYEOGG) */
    {{'\xeb', '\x85', '\x83'}, 3, 0xB143}, /* (HANGUL SYLLABLE NYEOGS) */
    {{'\xeb', '\x85', '\x85'}, 3, 0xB145}, /* (HANGUL SYLLABLE NYEONJ) */
    {{'\xeb', '\x85', '\x86'}, 3, 0xB146}, /* (HANGUL SYLLABLE NYEONH) */
    {{'\xeb', '\x85', '\x87'}, 3, 0xB147}, /* (HANGUL SYLLABLE NYEOD) */
    {{'\xeb', '\x85', '\x89'}, 3, 0xB149}, /* (HANGUL SYLLABLE NYEOLG) */
    {{'\xeb', '\x85', '\x8a'}, 3, 0xB14A}, /* (HANGUL SYLLABLE NYEOLM) */
    {{'\xeb', '\x85', '\x8b'}, 3, 0xB14B}, /* (HANGUL SYLLABLE NYEOLB) */
    {{'\xeb', '\x85', '\x8c'}, 3, 0xB14C}, /* (HANGUL SYLLABLE NYEOLS) */
    {{'\xeb', '\x85', '\x8d'}, 3, 0xB14D}, /* (HANGUL SYLLABLE NYEOLT) */
    {{'\xeb', '\x85', '\x8e'}, 3, 0xB14E}, /* (HANGUL SYLLABLE NYEOLP) */
    {{'\xeb', '\x85', '\x8f'}, 3, 0xB14F}, /* (HANGUL SYLLABLE NYEOLH) */
    {{'\xeb', '\x85', '\x92'}, 3, 0xB152}, /* (HANGUL SYLLABLE NYEOBS) */
    {{'\xeb', '\x85', '\x93'}, 3, 0xB153}, /* (HANGUL SYLLABLE NYEOS) */
    {{'\xeb', '\x85', '\x96'}, 3, 0xB156}, /* (HANGUL SYLLABLE NYEOJ) */
    {{'\xeb', '\x85', '\x97'}, 3, 0xB157}, /* (HANGUL SYLLABLE NYEOC) */
    {{'\xeb', '\x85', '\x99'}, 3, 0xB159}, /* (HANGUL SYLLABLE NYEOT) */
    {{'\xeb', '\x85', '\x9a'}, 3, 0xB15A}, /* (HANGUL SYLLABLE NYEOP) */
    {{'\xeb', '\x85', '\x9b'}, 3, 0xB15B}, /* (HANGUL SYLLABLE NYEOH) */
    {{'\xeb', '\x85', '\x9d'}, 3, 0xB15D}, /* (HANGUL SYLLABLE NYEG) */
    {{'\xeb', '\x85', '\x9e'}, 3, 0xB15E}, /* (HANGUL SYLLABLE NYEGG) */
    {{'\xeb', '\x85', '\x9f'}, 3, 0xB15F}, /* (HANGUL SYLLABLE NYEGS) */
    {{'\xeb', '\x85', '\xa1'}, 3, 0xB161}, /* (HANGUL SYLLABLE NYENJ) */
    {{'\xeb', '\x85', '\xa2'}, 3, 0xB162}, /* (HANGUL SYLLABLE NYENH) */
    {{'\xeb', '\x85', '\xa3'}, 3, 0xB163}, /* (HANGUL SYLLABLE NYED) */
    {{'\xeb', '\x85', '\xa4'}, 3, 0xB164}, /* (HANGUL SYLLABLE NYEL) */
    {{'\xeb', '\x85', '\xa5'}, 3, 0xB165}, /* (HANGUL SYLLABLE NYELG) */
    {{'\xeb', '\x85', '\xa6'}, 3, 0xB166}, /* (HANGUL SYLLABLE NYELM) */
    {{'\xeb', '\x85', '\xa7'}, 3, 0xB167}, /* (HANGUL SYLLABLE NYELB) */
    {{'\xeb', '\x85', '\xa8'}, 3, 0xB168}, /* (HANGUL SYLLABLE NYELS) */
    {{'\xeb', '\x85', '\xa9'}, 3, 0xB169}, /* (HANGUL SYLLABLE NYELT) */
    {{'\xeb', '\x85', '\xaa'}, 3, 0xB16A}, /* (HANGUL SYLLABLE NYELP) */
    {{'\xeb', '\x85', '\xab'}, 3, 0xB16B}, /* (HANGUL SYLLABLE NYELH) */
    {{'\xeb', '\x85', '\xac'}, 3, 0xB16C}, /* (HANGUL SYLLABLE NYEM) */
    {{'\xeb', '\x85', '\xad'}, 3, 0xB16D}, /* (HANGUL SYLLABLE NYEB) */
    {{'\xeb', '\x85', '\xae'}, 3, 0xB16E}, /* (HANGUL SYLLABLE NYEBS) */
    {{'\xeb', '\x85', '\xaf'}, 3, 0xB16F}, /* (HANGUL SYLLABLE NYES) */
    {{'\xeb', '\x85', '\xb0'}, 3, 0xB170}, /* (HANGUL SYLLABLE NYESS) */
    {{'\xeb', '\x85', '\xb1'}, 3, 0xB171}, /* (HANGUL SYLLABLE NYENG) */
    {{'\xeb', '\x85', '\xb2'}, 3, 0xB172}, /* (HANGUL SYLLABLE NYEJ) */
    {{'\xeb', '\x85', '\xb3'}, 3, 0xB173}, /* (HANGUL SYLLABLE NYEC) */
    {{'\xeb', '\x85', '\xb4'}, 3, 0xB174}, /* (HANGUL SYLLABLE NYEK) */
    {{'\xeb', '\x85', '\xb5'}, 3, 0xB175}, /* (HANGUL SYLLABLE NYET) */
    {{'\xeb', '\x85', '\xb6'}, 3, 0xB176}, /* (HANGUL SYLLABLE NYEP) */
    {{'\xeb', '\x85', '\xb7'}, 3, 0xB177}, /* (HANGUL SYLLABLE NYEH) */
    {{'\xeb', '\x85', '\xba'}, 3, 0xB17A}, /* (HANGUL SYLLABLE NOGG) */
    {{'\xeb', '\x85', '\xbb'}, 3, 0xB17B}, /* (HANGUL SYLLABLE NOGS) */
    {{'\xeb', '\x85', '\xbd'}, 3, 0xB17D}, /* (HANGUL SYLLABLE NONJ) */
    {{'\xeb', '\x85', '\xbe'}, 3, 0xB17E}, /* (HANGUL SYLLABLE NONH) */
    {{'\xeb', '\x85', '\xbf'}, 3, 0xB17F}, /* (HANGUL SYLLABLE NOD) */
    {{'\xeb', '\x86', '\x81'}, 3, 0xB181}, /* (HANGUL SYLLABLE NOLG) */
    {{'\xeb', '\x86', '\x83'}, 3, 0xB183}, /* (HANGUL SYLLABLE NOLB) */
    {{'\xeb', '\x86', '\x84'}, 3, 0xB184}, /* (HANGUL SYLLABLE NOLS) */
    {{'\xeb', '\x86', '\x85'}, 3, 0xB185}, /* (HANGUL SYLLABLE NOLT) */
    {{'\xeb', '\x86', '\x86'}, 3, 0xB186}, /* (HANGUL SYLLABLE NOLP) */
    {{'\xeb', '\x86', '\x87'}, 3, 0xB187}, /* (HANGUL SYLLABLE NOLH) */
    {{'\xeb', '\x86', '\x8a'}, 3, 0xB18A}, /* (HANGUL SYLLABLE NOBS) */
    {{'\xeb', '\x86', '\x8c'}, 3, 0xB18C}, /* (HANGUL SYLLABLE NOSS) */
    {{'\xeb', '\x86', '\x8e'}, 3, 0xB18E}, /* (HANGUL SYLLABLE NOJ) */
    {{'\xeb', '\x86', '\x8f'}, 3, 0xB18F}, /* (HANGUL SYLLABLE NOC) */
    {{'\xeb', '\x86', '\x90'}, 3, 0xB190}, /* (HANGUL SYLLABLE NOK) */
    {{'\xeb', '\x86', '\x91'}, 3, 0xB191}, /* (HANGUL SYLLABLE NOT) */
    {{'\xeb', '\x86', '\x95'}, 3, 0xB195}, /* (HANGUL SYLLABLE NWAG) */
    {{'\xeb', '\x86', '\x96'}, 3, 0xB196}, /* (HANGUL SYLLABLE NWAGG) */
    {{'\xeb', '\x86', '\x97'}, 3, 0xB197}, /* (HANGUL SYLLABLE NWAGS) */
    {{'\xeb', '\x86', '\x99'}, 3, 0xB199}, /* (HANGUL SYLLABLE NWANJ) */
    {{'\xeb', '\x86', '\x9a'}, 3, 0xB19A}, /* (HANGUL SYLLABLE NWANH) */
    {{'\xeb', '\x86', '\x9b'}, 3, 0xB19B}, /* (HANGUL SYLLABLE NWAD) */
    {{'\xeb', '\x86', '\x9d'}, 3, 0xB19D}, /* (HANGUL SYLLABLE NWALG) */
    {{'\xeb', '\x86', '\x9e'}, 3, 0xB19E}, /* (HANGUL SYLLABLE NWALM) */
    {{'\xeb', '\x86', '\x9f'}, 3, 0xB19F}, /* (HANGUL SYLLABLE NWALB) */
    {{'\xeb', '\x86', '\xa0'}, 3, 0xB1A0}, /* (HANGUL SYLLABLE NWALS) */
    {{'\xeb', '\x86', '\xa1'}, 3, 0xB1A1}, /* (HANGUL SYLLABLE NWALT) */
    {{'\xeb', '\x86', '\xa2'}, 3, 0xB1A2}, /* (HANGUL SYLLABLE NWALP) */
    {{'\xeb', '\x86', '\xa3'}, 3, 0xB1A3}, /* (HANGUL SYLLABLE NWALH) */
    {{'\xeb', '\x86', '\xa4'}, 3, 0xB1A4}, /* (HANGUL SYLLABLE NWAM) */
    {{'\xeb', '\x86', '\xa5'}, 3, 0xB1A5}, /* (HANGUL SYLLABLE NWAB) */
    {{'\xeb', '\x86', '\xa6'}, 3, 0xB1A6}, /* (HANGUL SYLLABLE NWABS) */
    {{'\xeb', '\x86', '\xa7'}, 3, 0xB1A7}, /* (HANGUL SYLLABLE NWAS) */
    {{'\xeb', '\x86', '\xa9'}, 3, 0xB1A9}, /* (HANGUL SYLLABLE NWANG) */
    {{'\xeb', '\x86', '\xaa'}, 3, 0xB1AA}, /* (HANGUL SYLLABLE NWAJ) */
    {{'\xeb', '\x86', '\xab'}, 3, 0xB1AB}, /* (HANGUL SYLLABLE NWAC) */
    {{'\xeb', '\x86', '\xac'}, 3, 0xB1AC}, /* (HANGUL SYLLABLE NWAK) */
    {{'\xeb', '\x86', '\xad'}, 3, 0xB1AD}, /* (HANGUL SYLLABLE NWAT) */
    {{'\xeb', '\x86', '\xae'}, 3, 0xB1AE}, /* (HANGUL SYLLABLE NWAP) */
    {{'\xeb', '\x86', '\xaf'}, 3, 0xB1AF}, /* (HANGUL SYLLABLE NWAH) */
    {{'\xeb', '\x86', '\xb0'}, 3, 0xB1B0}, /* (HANGUL SYLLABLE NWAE) */
    {{'\xeb', '\x86', '\xb1'}, 3, 0xB1B1}, /* (HANGUL SYLLABLE NWAEG) */
    {{'\xeb', '\x86', '\xb2'}, 3, 0xB1B2}, /* (HANGUL SYLLABLE NWAEGG) */
    {{'\xeb', '\x86', '\xb3'}, 3, 0xB1B3}, /* (HANGUL SYLLABLE NWAEGS) */
    {{'\xeb', '\x86', '\xb4'}, 3, 0xB1B4}, /* (HANGUL SYLLABLE NWAEN) */
    {{'\xeb', '\x86', '\xb5'}, 3, 0xB1B5}, /* (HANGUL SYLLABLE NWAENJ) */
    {{'\xeb', '\x86', '\xb6'}, 3, 0xB1B6}, /* (HANGUL SYLLABLE NWAENH) */
    {{'\xeb', '\x86', '\xb7'}, 3, 0xB1B7}, /* (HANGUL SYLLABLE NWAED) */
    {{'\xeb', '\x86', '\xb8'}, 3, 0xB1B8}, /* (HANGUL SYLLABLE NWAEL) */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{'\xeb', '\x86', '\xb9'}, 3, 0xB1B9}, /* (HANGUL SYLLABLE NWAELG) */
    {{'\xeb', '\x86', '\xba'}, 3, 0xB1BA}, /* (HANGUL SYLLABLE NWAELM) */
    {{'\xeb', '\x86', '\xbb'}, 3, 0xB1BB}, /* (HANGUL SYLLABLE NWAELB) */
    {{'\xeb', '\x86', '\xbc'}, 3, 0xB1BC}, /* (HANGUL SYLLABLE NWAELS) */
    {{'\xeb', '\x86', '\xbd'}, 3, 0xB1BD}, /* (HANGUL SYLLABLE NWAELT) */
    {{'\xeb', '\x86', '\xbe'}, 3, 0xB1BE}, /* (HANGUL SYLLABLE NWAELP) */
    {{'\xeb', '\x86', '\xbf'}, 3, 0xB1BF}, /* (HANGUL SYLLABLE NWAELH) */
    {{'\xeb', '\x87', '\x80'}, 3, 0xB1C0}, /* (HANGUL SYLLABLE NWAEM) */
    {{'\xeb', '\x87', '\x81'}, 3, 0xB1C1}, /* (HANGUL SYLLABLE NWAEB) */
    {{'\xeb', '\x87', '\x82'}, 3, 0xB1C2}, /* (HANGUL SYLLABLE NWAEBS) */
    {{'\xeb', '\x87', '\x83'}, 3, 0xB1C3}, /* (HANGUL SYLLABLE NWAES) */
    {{'\xeb', '\x87', '\x84'}, 3, 0xB1C4}, /* (HANGUL SYLLABLE NWAESS) */
    {{'\xeb', '\x87', '\x85'}, 3, 0xB1C5}, /* (HANGUL SYLLABLE NWAENG) */
    {{'\xeb', '\x87', '\x86'}, 3, 0xB1C6}, /* (HANGUL SYLLABLE NWAEJ) */
    {{'\xeb', '\x87', '\x87'}, 3, 0xB1C7}, /* (HANGUL SYLLABLE NWAEC) */
    {{'\xeb', '\x87', '\x88'}, 3, 0xB1C8}, /* (HANGUL SYLLABLE NWAEK) */
    {{'\xeb', '\x87', '\x89'}, 3, 0xB1C9}, /* (HANGUL SYLLABLE NWAET) */
    {{'\xeb', '\x87', '\x8a'}, 3, 0xB1CA}, /* (HANGUL SYLLABLE NWAEP) */
    {{'\xeb', '\x87', '\x8b'}, 3, 0xB1CB}, /* (HANGUL SYLLABLE NWAEH) */
    {{'\xeb', '\x87', '\x8d'}, 3, 0xB1CD}, /* (HANGUL SYLLABLE NOEG) */
    {{'\xeb', '\x87', '\x8e'}, 3, 0xB1CE}, /* (HANGUL SYLLABLE NOEGG) */
    {{'\xeb', '\x87', '\x8f'}, 3, 0xB1CF}, /* (HANGUL SYLLABLE NOEGS) */
    {{'\xeb', '\x87', '\x91'}, 3, 0xB1D1}, /* (HANGUL SYLLABLE NOENJ) */
    {{'\xeb', '\x87', '\x92'}, 3, 0xB1D2}, /* (HANGUL SYLLABLE NOENH) */
    {{'\xeb', '\x87', '\x93'}, 3, 0xB1D3}, /* (HANGUL SYLLABLE NOED) */
    {{'\xeb', '\x87', '\x95'}, 3, 0xB1D5}, /* (HANGUL SYLLABLE NOELG) */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{'\xeb', '\x87', '\x96'}, 3, 0xB1D6}, /* (HANGUL SYLLABLE NOELM) */
    {{'\xeb', '\x87', '\x97'}, 3, 0xB1D7}, /* (HANGUL SYLLABLE NOELB) */
    {{'\xeb', '\x87', '\x98'}, 3, 0xB1D8}, /* (HANGUL SYLLABLE NOELS) */
    {{'\xeb', '\x87', '\x99'}, 3, 0xB1D9}, /* (HANGUL SYLLABLE NOELT) */
    {{'\xeb', '\x87', '\x9a'}, 3, 0xB1DA}, /* (HANGUL SYLLABLE NOELP) */
    {{'\xeb', '\x87', '\x9b'}, 3, 0xB1DB}, /* (HANGUL SYLLABLE NOELH) */
    {{'\xeb', '\x87', '\x9e'}, 3, 0xB1DE}, /* (HANGUL SYLLABLE NOEBS) */
    {{'\xeb', '\x87', '\xa0'}, 3, 0xB1E0}, /* (HANGUL SYLLABLE NOESS) */
    {{'\xeb', '\x87', '\xa1'}, 3, 0xB1E1}, /* (HANGUL SYLLABLE NOENG) */
    {{'\xeb', '\x87', '\xa2'}, 3, 0xB1E2}, /* (HANGUL SYLLABLE NOEJ) */
    {{'\xeb', '\x87', '\xa3'}, 3, 0xB1E3}, /* (HANGUL SYLLABLE NOEC) */
    {{'\xeb', '\x87', '\xa4'}, 3, 0xB1E4}, /* (HANGUL SYLLABLE NOEK) */
    {{'\xeb', '\x87', '\xa5'}, 3, 0xB1E5}, /* (HANGUL SYLLABLE NOET) */
    {{'\xeb', '\x87', '\xa6'}, 3, 0xB1E6}, /* (HANGUL SYLLABLE NOEP) */
    {{'\xeb', '\x87', '\xa7'}, 3, 0xB1E7}, /* (HANGUL SYLLABLE NOEH) */
    {{'\xeb', '\x87', '\xaa'}, 3, 0xB1EA}, /* (HANGUL SYLLABLE NYOGG) */
    {{'\xeb', '\x87', '\xab'}, 3, 0xB1EB}, /* (HANGUL SYLLABLE NYOGS) */
    {{'\xeb', '\x87', '\xad'}, 3, 0xB1ED}, /* (HANGUL SYLLABLE NYONJ) */
    {{'\xeb', '\x87', '\xae'}, 3, 0xB1EE}, /* (HANGUL SYLLABLE NYONH) */
    {{'\xeb', '\x87', '\xaf'}, 3, 0xB1EF}, /* (HANGUL SYLLABLE NYOD) */
    {{'\xeb', '\x87', '\xb1'}, 3, 0xB1F1}, /* (HANGUL SYLLABLE NYOLG) */
    {{'\xeb', '\x87', '\xb2'}, 3, 0xB1F2}, /* (HANGUL SYLLABLE NYOLM) */
    {{'\xeb', '\x87', '\xb3'}, 3, 0xB1F3}, /* (HANGUL SYLLABLE NYOLB) */
    {{'\xeb', '\x87', '\xb4'}, 3, 0xB1F4}, /* (HANGUL SYLLABLE NYOLS) */
    {{'\xeb', '\x87', '\xb5'}, 3, 0xB1F5}, /* (HANGUL SYLLABLE NYOLT) */
    {{'\xeb', '\x87', '\xb6'}, 3, 0xB1F6}, /* (HANGUL SYLLABLE NYOLP) */
    {{'\xeb', '\x87', '\xb7'}, 3, 0xB1F7}, /* (HANGUL SYLLABLE NYOLH) */
    {{'\xeb', '\x87', '\xb8'}, 3, 0xB1F8}, /* (HANGUL SYLLABLE NYOM) */
    {{'\xeb', '\x87', '\xba'}, 3, 0xB1FA}, /* (HANGUL SYLLABLE NYOBS) */
    {{'\xeb', '\x87', '\xbc'}, 3, 0xB1FC}, /* (HANGUL SYLLABLE NYOSS) */
    {{'\xeb', '\x87', '\xbe'}, 3, 0xB1FE}, /* (HANGUL SYLLABLE NYOJ) */
    {{'\xeb', '\x87', '\xbf'}, 3, 0xB1FF}, /* (HANGUL SYLLABLE NYOC) */
    {{'\xeb', '\x88', '\x80'}, 3, 0xB200}, /* (HANGUL SYLLABLE NYOK) */
    {{'\xeb', '\x88', '\x81'}, 3, 0xB201}, /* (HANGUL SYLLABLE NYOT) */
    {{'\xeb', '\x88', '\x82'}, 3, 0xB202}, /* (HANGUL SYLLABLE NYOP) */
    {{'\xeb', '\x88', '\x83'}, 3, 0xB203}, /* (HANGUL SYLLABLE NYOH) */
    {{'\xeb', '\x88', '\x86'}, 3, 0xB206}, /* (HANGUL SYLLABLE NUGG) */
    {{'\xeb', '\x88', '\x87'}, 3, 0xB207}, /* (HANGUL SYLLABLE NUGS) */
    {{'\xeb', '\x88', '\x89'}, 3, 0xB209}, /* (HANGUL SYLLABLE NUNJ) */
    {{'\xeb', '\x88', '\x8a'}, 3, 0xB20A}, /* (HANGUL SYLLABLE NUNH) */
    {{'\xeb', '\x88', '\x8d'}, 3, 0xB20D}, /* (HANGUL SYLLABLE NULG) */
    {{'\xeb', '\x88', '\x8e'}, 3, 0xB20E}, /* (HANGUL SYLLABLE NULM) */
    {{'\xeb', '\x88', '\x8f'}, 3, 0xB20F}, /* (HANGUL SYLLABLE NULB) */
    {{'\xeb', '\x88', '\x90'}, 3, 0xB210}, /* (HANGUL SYLLABLE NULS) */
    {{'\xeb', '\x88', '\x91'}, 3, 0xB211}, /* (HANGUL SYLLABLE NULT) */
    {{'\xeb', '\x88', '\x92'}, 3, 0xB212}, /* (HANGUL SYLLABLE NULP) */
    {{'\xeb', '\x88', '\x93'}, 3, 0xB213}, /* (HANGUL SYLLABLE NULH) */
    {{'\xeb', '\x88', '\x96'}, 3, 0xB216}, /* (HANGUL SYLLABLE NUBS) */
    {{'\xeb', '\x88', '\x98'}, 3, 0xB218}, /* (HANGUL SYLLABLE NUSS) */
    {{'\xeb', '\x88', '\x9a'}, 3, 0xB21A}, /* (HANGUL SYLLABLE NUJ) */
    {{'\xeb', '\x88', '\x9b'}, 3, 0xB21B}, /* (HANGUL SYLLABLE NUC) */
    {{'\xeb', '\x88', '\x9c'}, 3, 0xB21C}, /* (HANGUL SYLLABLE NUK) */
    {{'\xeb', '\x88', '\x9d'}, 3, 0xB21D}, /* (HANGUL SYLLABLE NUT) */
    {{'\xeb', '\x88', '\x9e'}, 3, 0xB21E}, /* (HANGUL SYLLABLE NUP) */
    {{'\xeb', '\x88', '\x9f'}, 3, 0xB21F}, /* (HANGUL SYLLABLE NUH) */
    {{'\xeb', '\x88', '\xa1'}, 3, 0xB221}, /* (HANGUL SYLLABLE NWEOG) */
    {{'\xeb', '\x88', '\xa2'}, 3, 0xB222}, /* (HANGUL SYLLABLE NWEOGG) */
    {{'\xeb', '\x88', '\xa3'}, 3, 0xB223}, /* (HANGUL SYLLABLE NWEOGS) */
    {{'\xeb', '\x88', '\xa4'}, 3, 0xB224}, /* (HANGUL SYLLABLE NWEON) */
    {{'\xeb', '\x88', '\xa5'}, 3, 0xB225}, /* (HANGUL SYLLABLE NWEONJ) */
    {{'\xeb', '\x88', '\xa6'}, 3, 0xB226}, /* (HANGUL SYLLABLE NWEONH) */
    {{'\xeb', '\x88', '\xa7'}, 3, 0xB227}, /* (HANGUL SYLLABLE NWEOD) */
    {{'\xeb', '\x88', '\xa8'}, 3, 0xB228}, /* (HANGUL SYLLABLE NWEOL) */
    {{'\xeb', '\x88', '\xa9'}, 3, 0xB229}, /* (HANGUL SYLLABLE NWEOLG) */
    {{'\xeb', '\x88', '\xaa'}, 3, 0xB22A}, /* (HANGUL SYLLABLE NWEOLM) */
    {{'\xeb', '\x88', '\xab'}, 3, 0xB22B}, /* (HANGUL SYLLABLE NWEOLB) */
    {{'\xeb', '\x88', '\xac'}, 3, 0xB22C}, /* (HANGUL SYLLABLE NWEOLS) */
    {{'\xeb', '\x88', '\xad'}, 3, 0xB22D}, /* (HANGUL SYLLABLE NWEOLT) */
    {{'\xeb', '\x88', '\xae'}, 3, 0xB22E}, /* (HANGUL SYLLABLE NWEOLP) */
    {{'\xeb', '\x88', '\xaf'}, 3, 0xB22F}, /* (HANGUL SYLLABLE NWEOLH) */
    {{'\xeb', '\x88', '\xb0'}, 3, 0xB230}, /* (HANGUL SYLLABLE NWEOM) */
    {{'\xeb', '\x88', '\xb1'}, 3, 0xB231}, /* (HANGUL SYLLABLE NWEOB) */
    {{'\xeb', '\x88', '\xb2'}, 3, 0xB232}, /* (HANGUL SYLLABLE NWEOBS) */
    {{'\xeb', '\x88', '\xb3'}, 3, 0xB233}, /* (HANGUL SYLLABLE NWEOS) */
    {{'\xeb', '\x88', '\xb5'}, 3, 0xB235}, /* (HANGUL SYLLABLE NWEONG) */
    {{'\xeb', '\x88', '\xb6'}, 3, 0xB236}, /* (HANGUL SYLLABLE NWEOJ) */
    {{'\xeb', '\x88', '\xb7'}, 3, 0xB237}, /* (HANGUL SYLLABLE NWEOC) */
    {{'\xeb', '\x88', '\xb8'}, 3, 0xB238}, /* (HANGUL SYLLABLE NWEOK) */
    {{'\xeb', '\x88', '\xb9'}, 3, 0xB239}, /* (HANGUL SYLLABLE NWEOT) */
    {{'\xeb', '\x88', '\xba'}, 3, 0xB23A}, /* (HANGUL SYLLABLE NWEOP) */
    {{'\xeb', '\x88', '\xbb'}, 3, 0xB23B}, /* (HANGUL SYLLABLE NWEOH) */
    {{'\xeb', '\x88', '\xbd'}, 3, 0xB23D}, /* (HANGUL SYLLABLE NWEG) */
    {{'\xeb', '\x88', '\xbe'}, 3, 0xB23E}, /* (HANGUL SYLLABLE NWEGG) */
    {{'\xeb', '\x88', '\xbf'}, 3, 0xB23F}, /* (HANGUL SYLLABLE NWEGS) */
    {{'\xeb', '\x89', '\x80'}, 3, 0xB240}, /* (HANGUL SYLLABLE NWEN) */
    {{'\xeb', '\x89', '\x81'}, 3, 0xB241}, /* (HANGUL SYLLABLE NWENJ) */
    {{'\xeb', '\x89', '\x82'}, 3, 0xB242}, /* (HANGUL SYLLABLE NWENH) */
    {{'\xeb', '\x89', '\x83'}, 3, 0xB243}, /* (HANGUL SYLLABLE NWED) */
    {{'\xeb', '\x89', '\x84'}, 3, 0xB244}, /* (HANGUL SYLLABLE NWEL) */
    {{'\xeb', '\x89', '\x85'}, 3, 0xB245}, /* (HANGUL SYLLABLE NWELG) */
    {{'\xeb', '\x89', '\x86'}, 3, 0xB246}, /* (HANGUL SYLLABLE NWELM) */
    {{'\xeb', '\x89', '\x87'}, 3, 0xB247}, /* (HANGUL SYLLABLE NWELB) */
    {{'\xeb', '\x89', '\x88'}, 3, 0xB248}, /* (HANGUL SYLLABLE NWELS) */
    {{'\xeb', '\x89', '\x89'}, 3, 0xB249}, /* (HANGUL SYLLABLE NWELT) */
    {{'\xeb', '\x89', '\x8a'}, 3, 0xB24A}, /* (HANGUL SYLLABLE NWELP) */
    {{'\xeb', '\x89', '\x8b'}, 3, 0xB24B}, /* (HANGUL SYLLABLE NWELH) */
    {{'\xeb', '\x89', '\x8c'}, 3, 0xB24C}, /* (HANGUL SYLLABLE NWEM) */
    {{'\xeb', '\x89', '\x8d'}, 3, 0xB24D}, /* (HANGUL SYLLABLE NWEB) */
    {{'\xeb', '\x89', '\x8e'}, 3, 0xB24E}, /* (HANGUL SYLLABLE NWEBS) */
    {{'\xeb', '\x89', '\x8f'}, 3, 0xB24F}, /* (HANGUL SYLLABLE NWES) */
    {{'\xeb', '\x89', '\x90'}, 3, 0xB250}, /* (HANGUL SYLLABLE NWESS) */
    {{'\xeb', '\x89', '\x91'}, 3, 0xB251}, /* (HANGUL SYLLABLE NWENG) */
    {{'\xeb', '\x89', '\x92'}, 3, 0xB252}, /* (HANGUL SYLLABLE NWEJ) */
    {{'\xeb', '\x89', '\x93'}, 3, 0xB253}, /* (HANGUL SYLLABLE NWEC) */
    {{'\xeb', '\x89', '\x94'}, 3, 0xB254}, /* (HANGUL SYLLABLE NWEK) */
    {{'\xeb', '\x89', '\x95'}, 3, 0xB255}, /* (HANGUL SYLLABLE NWET) */
    {{'\xeb', '\x89', '\x96'}, 3, 0xB256}, /* (HANGUL SYLLABLE NWEP) */
    {{'\xeb', '\x89', '\x97'}, 3, 0xB257}, /* (HANGUL SYLLABLE NWEH) */
    {{'\xeb', '\x89', '\x99'}, 3, 0xB259}, /* (HANGUL SYLLABLE NWIG) */
    {{'\xeb', '\x89', '\x9a'}, 3, 0xB25A}, /* (HANGUL SYLLABLE NWIGG) */
    {{'\xeb', '\x89', '\x9b'}, 3, 0xB25B}, /* (HANGUL SYLLABLE NWIGS) */
    {{'\xeb', '\x89', '\x9d'}, 3, 0xB25D}, /* (HANGUL SYLLABLE NWINJ) */
    {{'\xeb', '\x89', '\x9e'}, 3, 0xB25E}, /* (HANGUL SYLLABLE NWINH) */
    {{'\xeb', '\x89', '\x9f'}, 3, 0xB25F}, /* (HANGUL SYLLABLE NWID) */
    {{'\xeb', '\x89', '\xa1'}, 3, 0xB261}, /* (HANGUL SYLLABLE NWILG) */
    {{'\xeb', '\x89', '\xa2'}, 3, 0xB262}, /* (HANGUL SYLLABLE NWILM) */
    {{'\xeb', '\x89', '\xa3'}, 3, 0xB263}, /* (HANGUL SYLLABLE NWILB) */
    {{'\xeb', '\x89', '\xa4'}, 3, 0xB264}, /* (HANGUL SYLLABLE NWILS) */
    {{'\xeb', '\x89', '\xa5'}, 3, 0xB265}, /* (HANGUL SYLLABLE NWILT) */
    {{'\xeb', '\x89', '\xa6'}, 3, 0xB266}, /* (HANGUL SYLLABLE NWILP) */
    {{'\xeb', '\x89', '\xa7'}, 3, 0xB267}, /* (HANGUL SYLLABLE NWILH) */
    {{'\xeb', '\x89', '\xaa'}, 3, 0xB26A}, /* (HANGUL SYLLABLE NWIBS) */
    {{'\xeb', '\x89', '\xab'}, 3, 0xB26B}, /* (HANGUL SYLLABLE NWIS) */
    {{'\xeb', '\x89', '\xac'}, 3, 0xB26C}, /* (HANGUL SYLLABLE NWISS) */
    {{'\xeb', '\x89', '\xad'}, 3, 0xB26D}, /* (HANGUL SYLLABLE NWING) */
    {{'\xeb', '\x89', '\xae'}, 3, 0xB26E}, /* (HANGUL SYLLABLE NWIJ) */
    {{'\xeb', '\x89', '\xaf'}, 3, 0xB26F}, /* (HANGUL SYLLABLE NWIC) */
    {{'\xeb', '\x89', '\xb0'}, 3, 0xB270}, /* (HANGUL SYLLABLE NWIK) */
    {{'\xeb', '\x89', '\xb1'}, 3, 0xB271}, /* (HANGUL SYLLABLE NWIT) */
    {{'\xeb', '\x89', '\xb2'}, 3, 0xB272}, /* (HANGUL SYLLABLE NWIP) */
    {{'\xeb', '\x89', '\xb3'}, 3, 0xB273}, /* (HANGUL SYLLABLE NWIH) */
    {{'\xeb', '\x89', '\xb6'}, 3, 0xB276}, /* (HANGUL SYLLABLE NYUGG) */
    {{'\xeb', '\x89', '\xb7'}, 3, 0xB277}, /* (HANGUL SYLLABLE NYUGS) */
    {{'\xeb', '\x89', '\xb8'}, 3, 0xB278}, /* (HANGUL SYLLABLE NYUN) */
    {{'\xeb', '\x89', '\xb9'}, 3, 0xB279}, /* (HANGUL SYLLABLE NYUNJ) */
    {{'\xeb', '\x89', '\xba'}, 3, 0xB27A}, /* (HANGUL SYLLABLE NYUNH) */
    {{'\xeb', '\x89', '\xbb'}, 3, 0xB27B}, /* (HANGUL SYLLABLE NYUD) */
    {{'\xeb', '\x89', '\xbd'}, 3, 0xB27D}, /* (HANGUL SYLLABLE NYULG) */
    {{'\xeb', '\x89', '\xbe'}, 3, 0xB27E}, /* (HANGUL SYLLABLE NYULM) */
    {{'\xeb', '\x89', '\xbf'}, 3, 0xB27F}, /* (HANGUL SYLLABLE NYULB) */
    {{'\xeb', '\x8a', '\x80'}, 3, 0xB280}, /* (HANGUL SYLLABLE NYULS) */
    {{'\xeb', '\x8a', '\x81'}, 3, 0xB281}, /* (HANGUL SYLLABLE NYULT) */
    {{'\xeb', '\x8a', '\x82'}, 3, 0xB282}, /* (HANGUL SYLLABLE NYULP) */
    {{'\xeb', '\x8a', '\x83'}, 3, 0xB283}, /* (HANGUL SYLLABLE NYULH) */
    {{'\xeb', '\x8a', '\x86'}, 3, 0xB286}, /* (HANGUL SYLLABLE NYUBS) */
    {{'\xeb', '\x8a', '\x87'}, 3, 0xB287}, /* (HANGUL SYLLABLE NYUS) */
    {{'\xeb', '\x8a', '\x88'}, 3, 0xB288}, /* (HANGUL SYLLABLE NYUSS) */
    {{'\xeb', '\x8a', '\x8a'}, 3, 0xB28A}, /* (HANGUL SYLLABLE NYUJ) */
    {{'\xeb', '\x8a', '\x8b'}, 3, 0xB28B}, /* (HANGUL SYLLABLE NYUC) */
    {{'\xeb', '\x8a', '\x8c'}, 3, 0xB28C}, /* (HANGUL SYLLABLE NYUK) */
    {{'\xeb', '\x8a', '\x8d'}, 3, 0xB28D}, /* (HANGUL SYLLABLE NYUT) */
    {{'\xeb', '\x8a', '\x8e'}, 3, 0xB28E}, /* (HANGUL SYLLABLE NYUP) */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{'\xeb', '\x8a', '\x8f'}, 3, 0xB28F}, /* (HANGUL SYLLABLE NYUH) */
    {{'\xeb', '\x8a', '\x92'}, 3, 0xB292}, /* (HANGUL SYLLABLE NEUGG) */
    {{'\xeb', '\x8a', '\x93'}, 3, 0xB293}, /* (HANGUL SYLLABLE NEUGS) */
    {{'\xeb', '\x8a', '\x95'}, 3, 0xB295}, /* (HANGUL SYLLABLE NEUNJ) */
    {{'\xeb', '\x8a', '\x96'}, 3, 0xB296}, /* (HANGUL SYLLABLE NEUNH) */
    {{'\xeb', '\x8a', '\x97'}, 3, 0xB297}, /* (HANGUL SYLLABLE NEUD) */
    {{'\xeb', '\x8a', '\x9b'}, 3, 0xB29B}, /* (HANGUL SYLLABLE NEULB) */
    {{'\xeb', '\x8a', '\x9c'}, 3, 0xB29C}, /* (HANGUL SYLLABLE NEULS) */
    {{'\xeb', '\x8a', '\x9d'}, 3, 0xB29D}, /* (HANGUL SYLLABLE NEULT) */
    {{'\xeb', '\x8a', '\x9e'}, 3, 0xB29E}, /* (HANGUL SYLLABLE NEULP) */
    {{'\xeb', '\x8a', '\x9f'}, 3, 0xB29F}, /* (HANGUL SYLLABLE NEULH) */
    {{'\xeb', '\x8a', '\xa2'}, 3, 0xB2A2}, /* (HANGUL SYLLABLE NEUBS) */
    {{'\xeb', '\x8a', '\xa4'}, 3, 0xB2A4}, /* (HANGUL SYLLABLE NEUSS) */
    {{'\xeb', '\x8a', '\xa7'}, 3, 0xB2A7}, /* (HANGUL SYLLABLE NEUC) */
    {{'\xeb', '\x8a', '\xa8'}, 3, 0xB2A8}, /* (HANGUL SYLLABLE NEUK) */
    {{'\xeb', '\x8a', '\xa9'}, 3, 0xB2A9}, /* (HANGUL SYLLABLE NEUT) */
    {{'\xeb', '\x8a', '\xab'}, 3, 0xB2AB}, /* (HANGUL SYLLABLE NEUH) */
    {{'\xeb', '\x8a', '\xad'}, 3, 0xB2AD}, /* (HANGUL SYLLABLE NYIG) */
    {{'\xeb', '\x8a', '\xae'}, 3, 0xB2AE}, /* (HANGUL SYLLABLE NYIGG) */
    {{'\xeb', '\x8a', '\xaf'}, 3, 0xB2AF}, /* (HANGUL SYLLABLE NYIGS) */
    {{'\xeb', '\x8a', '\xb1'}, 3, 0xB2B1}, /* (HANGUL SYLLABLE NYINJ) */
    {{'\xeb', '\x8a', '\xb2'}, 3, 0xB2B2}, /* (HANGUL SYLLABLE NYINH) */
    {{'\xeb', '\x8a', '\xb3'}, 3, 0xB2B3}, /* (HANGUL SYLLABLE NYID) */
    {{'\xeb', '\x8a', '\xb5'}, 3, 0xB2B5}, /* (HANGUL SYLLABLE NYILG) */
    {{'\xeb', '\x8a', '\xb6'}, 3, 0xB2B6}, /* (HANGUL SYLLABLE NYILM) */
    {{'\xeb', '\x8a', '\xb7'}, 3, 0xB2B7}, /* (HANGUL SYLLABLE NYILB) */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{'\xeb', '\x8a', '\xb8'}, 3, 0xB2B8}, /* (HANGUL SYLLABLE NYILS) */
    {{'\xeb', '\x8a', '\xb9'}, 3, 0xB2B9}, /* (HANGUL SYLLABLE NYILT) */
    {{'\xeb', '\x8a', '\xba'}, 3, 0xB2BA}, /* (HANGUL SYLLABLE NYILP) */
    {{'\xeb', '\x8a', '\xbb'}, 3, 0xB2BB}, /* (HANGUL SYLLABLE NYILH) */
    {{'\xeb', '\x8a', '\xbc'}, 3, 0xB2BC}, /* (HANGUL SYLLABLE NYIM) */
    {{'\xeb', '\x8a', '\xbd'}, 3, 0xB2BD}, /* (HANGUL SYLLABLE NYIB) */
    {{'\xeb', '\x8a', '\xbe'}, 3, 0xB2BE}, /* (HANGUL SYLLABLE NYIBS) */
    {{'\xeb', '\x8a', '\xbf'}, 3, 0xB2BF}, /* (HANGUL SYLLABLE NYIS) */
    {{'\xeb', '\x8b', '\x80'}, 3, 0xB2C0}, /* (HANGUL SYLLABLE NYISS) */
    {{'\xeb', '\x8b', '\x81'}, 3, 0xB2C1}, /* (HANGUL SYLLABLE NYING) */
    {{'\xeb', '\x8b', '\x82'}, 3, 0xB2C2}, /* (HANGUL SYLLABLE NYIJ) */
    {{'\xeb', '\x8b', '\x83'}, 3, 0xB2C3}, /* (HANGUL SYLLABLE NYIC) */
    {{'\xeb', '\x8b', '\x84'}, 3, 0xB2C4}, /* (HANGUL SYLLABLE NYIK) */
    {{'\xeb', '\x8b', '\x85'}, 3, 0xB2C5}, /* (HANGUL SYLLABLE NYIT) */
    {{'\xeb', '\x8b', '\x86'}, 3, 0xB2C6}, /* (HANGUL SYLLABLE NYIP) */
    {{'\xeb', '\x8b', '\x87'}, 3, 0xB2C7}, /* (HANGUL SYLLABLE NYIH) */
    {{'\xeb', '\x8b', '\x8a'}, 3, 0xB2CA}, /* (HANGUL SYLLABLE NIGG) */
    {{'\xeb', '\x8b', '\x8b'}, 3, 0xB2CB}, /* (HANGUL SYLLABLE NIGS) */
    {{'\xeb', '\x8b', '\x8d'}, 3, 0xB2CD}, /* (HANGUL SYLLABLE NINJ) */
    {{'\xeb', '\x8b', '\x8e'}, 3, 0xB2CE}, /* (HANGUL SYLLABLE NINH) */
    {{'\xeb', '\x8b', '\x8f'}, 3, 0xB2CF}, /* (HANGUL SYLLABLE NID) */
    {{'\xeb', '\x8b', '\x91'}, 3, 0xB2D1}, /* (HANGUL SYLLABLE NILG) */
    {{'\xeb', '\x8b', '\x93'}, 3, 0xB2D3}, /* (HANGUL SYLLABLE NILB) */
    {{'\xeb', '\x8b', '\x94'}, 3, 0xB2D4}, /* (HANGUL SYLLABLE NILS) */
    {{'\xeb', '\x8b', '\x95'}, 3, 0xB2D5}, /* (HANGUL SYLLABLE NILT) */
    {{'\xeb', '\x8b', '\x96'}, 3, 0xB2D6}, /* (HANGUL SYLLABLE NILP) */
    {{'\xeb', '\x8b', '\x97'}, 3, 0xB2D7}, /* (HANGUL SYLLABLE NILH) */
    {{'\xeb', '\x8b', '\x9a'}, 3, 0xB2DA}, /* (HANGUL SYLLABLE NIBS) */
    {{'\xeb', '\x8b', '\x9c'}, 3, 0xB2DC}, /* (HANGUL SYLLABLE NISS) */
    {{'\xeb', '\x8b', '\x9e'}, 3, 0xB2DE}, /* (HANGUL SYLLABLE NIJ) */
    {{'\xeb', '\x8b', '\x9f'}, 3, 0xB2DF}, /* (HANGUL SYLLABLE NIC) */
    {{'\xeb', '\x8b', '\xa0'}, 3, 0xB2E0}, /* (HANGUL SYLLABLE NIK) */
    {{'\xeb', '\x8b', '\xa1'}, 3, 0xB2E1}, /* (HANGUL SYLLABLE NIT) */
    {{'\xeb', '\x8b', '\xa3'}, 3, 0xB2E3}, /* (HANGUL SYLLABLE NIH) */
    {{'\xeb', '\x8b', '\xa7'}, 3, 0xB2E7}, /* (HANGUL SYLLABLE DAGS) */
    {{'\xeb', '\x8b', '\xa9'}, 3, 0xB2E9}, /* (HANGUL SYLLABLE DANJ) */
    {{'\xeb', '\x8b', '\xaa'}, 3, 0xB2EA}, /* (HANGUL SYLLABLE DANH) */
    {{'\xeb', '\x8b', '\xb0'}, 3, 0xB2F0}, /* (HANGUL SYLLABLE DALS) */
    {{'\xeb', '\x8b', '\xb1'}, 3, 0xB2F1}, /* (HANGUL SYLLABLE DALT) */
    {{'\xeb', '\x8b', '\xb2'}, 3, 0xB2F2}, /* (HANGUL SYLLABLE DALP) */
    {{'\xeb', '\x8b', '\xb6'}, 3, 0xB2F6}, /* (HANGUL SYLLABLE DABS) */
    {{'\xeb', '\x8b', '\xbc'}, 3, 0xB2FC}, /* (HANGUL SYLLABLE DAK) */
    {{'\xeb', '\x8b', '\xbd'}, 3, 0xB2FD}, /* (HANGUL SYLLABLE DAT) */
    {{'\xeb', '\x8b', '\xbe'}, 3, 0xB2FE}, /* (HANGUL SYLLABLE DAP) */
    {{'\xeb', '\x8c', '\x82'}, 3, 0xB302}, /* (HANGUL SYLLABLE DAEGG) */
    {{'\xeb', '\x8c', '\x83'}, 3, 0xB303}, /* (HANGUL SYLLABLE DAEGS) */
    {{'\xeb', '\x8c', '\x85'}, 3, 0xB305}, /* (HANGUL SYLLABLE DAENJ) */
    {{'\xeb', '\x8c', '\x86'}, 3, 0xB306}, /* (HANGUL SYLLABLE DAENH) */
    {{'\xeb', '\x8c', '\x87'}, 3, 0xB307}, /* (HANGUL SYLLABLE DAED) */
    {{'\xeb', '\x8c', '\x89'}, 3, 0xB309}, /* (HANGUL SYLLABLE DAELG) */
    {{'\xeb', '\x8c', '\x8a'}, 3, 0xB30A}, /* (HANGUL SYLLABLE DAELM) */
    {{'\xeb', '\x8c', '\x8b'}, 3, 0xB30B}, /* (HANGUL SYLLABLE DAELB) */
    {{'\xeb', '\x8c', '\x8c'}, 3, 0xB30C}, /* (HANGUL SYLLABLE DAELS) */
    {{'\xeb', '\x8c', '\x8d'}, 3, 0xB30D}, /* (HANGUL SYLLABLE DAELT) */
    {{'\xeb', '\x8c', '\x8e'}, 3, 0xB30E}, /* (HANGUL SYLLABLE DAELP) */
    {{'\xeb', '\x8c', '\x8f'}, 3, 0xB30F}, /* (HANGUL SYLLABLE DAELH) */
    {{'\xeb', '\x8c', '\x92'}, 3, 0xB312}, /* (HANGUL SYLLABLE DAEBS) */
    {{'\xeb', '\x8c', '\x96'}, 3, 0xB316}, /* (HANGUL SYLLABLE DAEJ) */
    {{'\xeb', '\x8c', '\x97'}, 3, 0xB317}, /* (HANGUL SYLLABLE DAEC) */
    {{'\xeb', '\x8c', '\x98'}, 3, 0xB318}, /* (HANGUL SYLLABLE DAEK) */
    {{'\xeb', '\x8c', '\x99'}, 3, 0xB319}, /* (HANGUL SYLLABLE DAET) */
    {{'\xeb', '\x8c', '\x9a'}, 3, 0xB31A}, /* (HANGUL SYLLABLE DAEP) */
    {{'\xeb', '\x8c', '\x9b'}, 3, 0xB31B}, /* (HANGUL SYLLABLE DAEH) */
    {{'\xeb', '\x8c', '\x9d'}, 3, 0xB31D}, /* (HANGUL SYLLABLE DYAG) */
    {{'\xeb', '\x8c', '\x9e'}, 3, 0xB31E}, /* (HANGUL SYLLABLE DYAGG) */
    {{'\xeb', '\x8c', '\x9f'}, 3, 0xB31F}, /* (HANGUL SYLLABLE DYAGS) */
    {{'\xeb', '\x8c', '\xa0'}, 3, 0xB320}, /* (HANGUL SYLLABLE DYAN) */
    {{'\xeb', '\x8c', '\xa1'}, 3, 0xB321}, /* (HANGUL SYLLABLE DYANJ) */
    {{'\xeb', '\x8c', '\xa2'}, 3, 0xB322}, /* (HANGUL SYLLABLE DYANH) */
    {{'\xeb', '\x8c', '\xa3'}, 3, 0xB323}, /* (HANGUL SYLLABLE DYAD) */
    {{'\xeb', '\x8c', '\xa4'}, 3, 0xB324}, /* (HANGUL SYLLABLE DYAL) */
    {{'\xeb', '\x8c', '\xa5'}, 3, 0xB325}, /* (HANGUL SYLLABLE DYALG) */
    {{'\xeb', '\x8c', '\xa6'}, 3, 0xB326}, /* (HANGUL SYLLABLE DYALM) */
    {{'\xeb', '\x8c', '\xa7'}, 3, 0xB327}, /* (HANGUL SYLLABLE DYALB) */
    {{'\xeb', '\x8c', '\xa8'}, 3, 0xB328}, /* (HANGUL SYLLABLE DYALS) */
    {{'\xeb', '\x8c', '\xa9'}, 3, 0xB329}, /* (HANGUL SYLLABLE DYALT) */
    {{'\xeb', '\x8c', '\xaa'}, 3, 0xB32A}, /* (HANGUL SYLLABLE DYALP) */
    {{'\xeb', '\x8c', '\xab'}, 3, 0xB32B}, /* (HANGUL SYLLABLE DYALH) */
    {{'\xeb', '\x8c', '\xac'}, 3, 0xB32C}, /* (HANGUL SYLLABLE DYAM) */
    {{'\xeb', '\x8c', '\xad'}, 3, 0xB32D}, /* (HANGUL SYLLABLE DYAB) */
    {{'\xeb', '\x8c', '\xae'}, 3, 0xB32E}, /* (HANGUL SYLLABLE DYABS) */
    {{'\xeb', '\x8c', '\xaf'}, 3, 0xB32F}, /* (HANGUL SYLLABLE DYAS) */
    {{'\xeb', '\x8c', '\xb0'}, 3, 0xB330}, /* (HANGUL SYLLABLE DYASS) */
    {{'\xeb', '\x8c', '\xb1'}, 3, 0xB331}, /* (HANGUL SYLLABLE DYANG) */
    {{'\xeb', '\x8c', '\xb2'}, 3, 0xB332}, /* (HANGUL SYLLABLE DYAJ) */
    {{'\xeb', '\x8c', '\xb3'}, 3, 0xB333}, /* (HANGUL SYLLABLE DYAC) */
    {{'\xeb', '\x8c', '\xb4'}, 3, 0xB334}, /* (HANGUL SYLLABLE DYAK) */
    {{'\xeb', '\x8c', '\xb5'}, 3, 0xB335}, /* (HANGUL SYLLABLE DYAT) */
    {{'\xeb', '\x8c', '\xb6'}, 3, 0xB336}, /* (HANGUL SYLLABLE DYAP) */
    {{'\xeb', '\x8c', '\xb7'}, 3, 0xB337}, /* (HANGUL SYLLABLE DYAH) */
    {{'\xeb', '\x8c', '\xb8'}, 3, 0xB338}, /* (HANGUL SYLLABLE DYAE) */
    {{'\xeb', '\x8c', '\xb9'}, 3, 0xB339}, /* (HANGUL SYLLABLE DYAEG) */
    {{'\xeb', '\x8c', '\xba'}, 3, 0xB33A}, /* (HANGUL SYLLABLE DYAEGG) */
    {{'\xeb', '\x8c', '\xbb'}, 3, 0xB33B}, /* (HANGUL SYLLABLE DYAEGS) */
    {{'\xeb', '\x8c', '\xbc'}, 3, 0xB33C}, /* (HANGUL SYLLABLE DYAEN) */
    {{'\xeb', '\x8c', '\xbd'}, 3, 0xB33D}, /* (HANGUL SYLLABLE DYAENJ) */
    {{'\xeb', '\x8c', '\xbe'}, 3, 0xB33E}, /* (HANGUL SYLLABLE DYAENH) */
    {{'\xeb', '\x8c', '\xbf'}, 3, 0xB33F}, /* (HANGUL SYLLABLE DYAED) */
    {{'\xeb', '\x8d', '\x80'}, 3, 0xB340}, /* (HANGUL SYLLABLE DYAEL) */
    {{'\xeb', '\x8d', '\x81'}, 3, 0xB341}, /* (HANGUL SYLLABLE DYAELG) */
    {{'\xeb', '\x8d', '\x82'}, 3, 0xB342}, /* (HANGUL SYLLABLE DYAELM) */
    {{'\xeb', '\x8d', '\x83'}, 3, 0xB343}, /* (HANGUL SYLLABLE DYAELB) */
    {{'\xeb', '\x8d', '\x84'}, 3, 0xB344}, /* (HANGUL SYLLABLE DYAELS) */
    {{'\xeb', '\x8d', '\x85'}, 3, 0xB345}, /* (HANGUL SYLLABLE DYAELT) */
    {{'\xeb', '\x8d', '\x86'}, 3, 0xB346}, /* (HANGUL SYLLABLE DYAELP) */
    {{'\xeb', '\x8d', '\x87'}, 3, 0xB347}, /* (HANGUL SYLLABLE DYAELH) */
    {{'\xeb', '\x8d', '\x88'}, 3, 0xB348}, /* (HANGUL SYLLABLE DYAEM) */
    {{'\xeb', '\x8d', '\x89'}, 3, 0xB349}, /* (HANGUL SYLLABLE DYAEB) */
    {{'\xeb', '\x8d', '\x8a'}, 3, 0xB34A}, /* (HANGUL SYLLABLE DYAEBS) */
    {{'\xeb', '\x8d', '\x8b'}, 3, 0xB34B}, /* (HANGUL SYLLABLE DYAES) */
    {{'\xeb', '\x8d', '\x8c'}, 3, 0xB34C}, /* (HANGUL SYLLABLE DYAESS) */
    {{'\xeb', '\x8d', '\x8d'}, 3, 0xB34D}, /* (HANGUL SYLLABLE DYAENG) */
    {{'\xeb', '\x8d', '\x8e'}, 3, 0xB34E}, /* (HANGUL SYLLABLE DYAEJ) */
    {{'\xeb', '\x8d', '\x8f'}, 3, 0xB34F}, /* (HANGUL SYLLABLE DYAEC) */
    {{'\xeb', '\x8d', '\x90'}, 3, 0xB350}, /* (HANGUL SYLLABLE DYAEK) */
    {{'\xeb', '\x8d', '\x91'}, 3, 0xB351}, /* (HANGUL SYLLABLE DYAET) */
    {{'\xeb', '\x8d', '\x92'}, 3, 0xB352}, /* (HANGUL SYLLABLE DYAEP) */
    {{'\xeb', '\x8d', '\x93'}, 3, 0xB353}, /* (HANGUL SYLLABLE DYAEH) */
    {{'\xeb', '\x8d', '\x97'}, 3, 0xB357}, /* (HANGUL SYLLABLE DEOGS) */
    {{'\xeb', '\x8d', '\x99'}, 3, 0xB359}, /* (HANGUL SYLLABLE DEONJ) */
    {{'\xeb', '\x8d', '\x9a'}, 3, 0xB35A}, /* (HANGUL SYLLABLE DEONH) */
    {{'\xeb', '\x8d', '\x9d'}, 3, 0xB35D}, /* (HANGUL SYLLABLE DEOLG) */
    {{'\xeb', '\x8d', '\xa0'}, 3, 0xB360}, /* (HANGUL SYLLABLE DEOLS) */
    {{'\xeb', '\x8d', '\xa1'}, 3, 0xB361}, /* (HANGUL SYLLABLE DEOLT) */
    {{'\xeb', '\x8d', '\xa2'}, 3, 0xB362}, /* (HANGUL SYLLABLE DEOLP) */
    {{'\xeb', '\x8d', '\xa3'}, 3, 0xB363}, /* (HANGUL SYLLABLE DEOLH) */
    {{'\xeb', '\x8d', '\xa6'}, 3, 0xB366}, /* (HANGUL SYLLABLE DEOBS) */
    {{'\xeb', '\x8d', '\xa8'}, 3, 0xB368}, /* (HANGUL SYLLABLE DEOSS) */
    {{'\xeb', '\x8d', '\xaa'}, 3, 0xB36A}, /* (HANGUL SYLLABLE DEOJ) */
    {{'\xeb', '\x8d', '\xac'}, 3, 0xB36C}, /* (HANGUL SYLLABLE DEOK) */
    {{'\xeb', '\x8d', '\xad'}, 3, 0xB36D}, /* (HANGUL SYLLABLE DEOT) */
    {{'\xeb', '\x8d', '\xaf'}, 3, 0xB36F}, /* (HANGUL SYLLABLE DEOH) */
    {{'\xeb', '\x8d', '\xb2'}, 3, 0xB372}, /* (HANGUL SYLLABLE DEGG) */
    {{'\xeb', '\x8d', '\xb3'}, 3, 0xB373}, /* (HANGUL SYLLABLE DEGS) */
    {{'\xeb', '\x8d', '\xb5'}, 3, 0xB375}, /* (HANGUL SYLLABLE DENJ) */
    {{'\xeb', '\x8d', '\xb6'}, 3, 0xB376}, /* (HANGUL SYLLABLE DENH) */
    {{'\xeb', '\x8d', '\xb7'}, 3, 0xB377}, /* (HANGUL SYLLABLE DED) */
    {{'\xeb', '\x8d', '\xb9'}, 3, 0xB379}, /* (HANGUL SYLLABLE DELG) */
    {{'\xeb', '\x8d', '\xba'}, 3, 0xB37A}, /* (HANGUL SYLLABLE DELM) */
    {{'\xeb', '\x8d', '\xbb'}, 3, 0xB37B}, /* (HANGUL SYLLABLE DELB) */
    {{'\xeb', '\x8d', '\xbc'}, 3, 0xB37C}, /* (HANGUL SYLLABLE DELS) */
    {{'\xeb', '\x8d', '\xbd'}, 3, 0xB37D}, /* (HANGUL SYLLABLE DELT) */
    {{'\xeb', '\x8d', '\xbe'}, 3, 0xB37E}, /* (HANGUL SYLLABLE DELP) */
    {{'\xeb', '\x8d', '\xbf'}, 3, 0xB37F}, /* (HANGUL SYLLABLE DELH) */
    {{'\xeb', '\x8e', '\x82'}, 3, 0xB382}, /* (HANGUL SYLLABLE DEBS) */
    {{'\xeb', '\x8e', '\x86'}, 3, 0xB386}, /* (HANGUL SYLLABLE DEJ) */
    {{'\xeb', '\x8e', '\x87'}, 3, 0xB387}, /* (HANGUL SYLLABLE DEC) */
    {{'\xeb', '\x8e', '\x88'}, 3, 0xB388}, /* (HANGUL SYLLABLE DEK) */
    {{'\xeb', '\x8e', '\x89'}, 3, 0xB389}, /* (HANGUL SYLLABLE DET) */
    {{'\xeb', '\x8e', '\x8a'}, 3, 0xB38A}, /* (HANGUL SYLLABLE DEP) */
    {{'\xeb', '\x8e', '\x8b'}, 3, 0xB38B}, /* (HANGUL SYLLABLE DEH) */
    {{'\xeb', '\x8e', '\x8d'}, 3, 0xB38D}, /* (HANGUL SYLLABLE DYEOG) */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{'\xeb', '\x8e', '\x8e'}, 3, 0xB38E}, /* (HANGUL SYLLABLE DYEOGG) */
    {{'\xeb', '\x8e', '\x8f'}, 3, 0xB38F}, /* (HANGUL SYLLABLE DYEOGS) */
    {{'\xeb', '\x8e', '\x91'}, 3, 0xB391}, /* (HANGUL SYLLABLE DYEONJ) */
    {{'\xeb', '\x8e', '\x92'}, 3, 0xB392}, /* (HANGUL SYLLABLE DYEONH) */
    {{'\xeb', '\x8e', '\x93'}, 3, 0xB393}, /* (HANGUL SYLLABLE DYEOD) */
    {{'\xeb', '\x8e', '\x95'}, 3, 0xB395}, /* (HANGUL SYLLABLE DYEOLG) */
    {{'\xeb', '\x8e', '\x96'}, 3, 0xB396}, /* (HANGUL SYLLABLE DYEOLM) */
    {{'\xeb', '\x8e', '\x97'}, 3, 0xB397}, /* (HANGUL SYLLABLE DYEOLB) */
    {{'\xeb', '\x8e', '\x98'}, 3, 0xB398}, /* (HANGUL SYLLABLE DYEOLS) */
    {{'\xeb', '\x8e', '\x99'}, 3, 0xB399}, /* (HANGUL SYLLABLE DYEOLT) */
    {{'\xeb', '\x8e', '\x9a'}, 3, 0xB39A}, /* (HANGUL SYLLABLE DYEOLP) */
    {{'\xeb', '\x8e', '\x9b'}, 3, 0xB39B}, /* (HANGUL SYLLABLE DYEOLH) */
    {{'\xeb', '\x8e', '\x9c'}, 3, 0xB39C}, /* (HANGUL SYLLABLE DYEOM) */
    {{'\xeb', '\x8e', '\x9d'}, 3, 0xB39D}, /* (HANGUL SYLLABLE DYEOB) */
    {{'\xeb', '\x8e', '\x9e'}, 3, 0xB39E}, /* (HANGUL SYLLABLE DYEOBS) */
    {{'\xeb', '\x8e', '\x9f'}, 3, 0xB39F}, /* (HANGUL SYLLABLE DYEOS) */
    {{'\xeb', '\x8e', '\xa2'}, 3, 0xB3A2}, /* (HANGUL SYLLABLE DYEOJ) */
    {{'\xeb', '\x8e', '\xa3'}, 3, 0xB3A3}, /* (HANGUL SYLLABLE DYEOC) */
    {{'\xeb', '\x8e', '\xa4'}, 3, 0xB3A4}, /* (HANGUL SYLLABLE DYEOK) */
    {{'\xeb', '\x8e', '\xa5'}, 3, 0xB3A5}, /* (HANGUL SYLLABLE DYEOT) */
    {{'\xeb', '\x8e', '\xa6'}, 3, 0xB3A6}, /* (HANGUL SYLLABLE DYEOP) */
    {{'\xeb', '\x8e', '\xa7'}, 3, 0xB3A7}, /* (HANGUL SYLLABLE DYEOH) */
    {{'\xeb', '\x8e', '\xa9'}, 3, 0xB3A9}, /* (HANGUL SYLLABLE DYEG) */
    {{'\xeb', '\x8e', '\xaa'}, 3, 0xB3AA}, /* (HANGUL SYLLABLE DYEGG) */
    {{'\xeb', '\x8e', '\xab'}, 3, 0xB3AB}, /* (HANGUL SYLLABLE DYEGS) */
    {{'\xeb', '\x8e', '\xad'}, 3, 0xB3AD}, /* (HANGUL SYLLABLE DYENJ) */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{'\xeb', '\x8e', '\xae'}, 3, 0xB3AE}, /* (HANGUL SYLLABLE DYENH) */
    {{'\xeb', '\x8e', '\xaf'}, 3, 0xB3AF}, /* (HANGUL SYLLABLE DYED) */
    {{'\xeb', '\x8e', '\xb0'}, 3, 0xB3B0}, /* (HANGUL SYLLABLE DYEL) */
    {{'\xeb', '\x8e', '\xb1'}, 3, 0xB3B1}, /* (HANGUL SYLLABLE DYELG) */
    {{'\xeb', '\x8e', '\xb2'}, 3, 0xB3B2}, /* (HANGUL SYLLABLE DYELM) */
    {{'\xeb', '\x8e', '\xb3'}, 3, 0xB3B3}, /* (HANGUL SYLLABLE DYELB) */
    {{'\xeb', '\x8e', '\xb4'}, 3, 0xB3B4}, /* (HANGUL SYLLABLE DYELS) */
    {{'\xeb', '\x8e', '\xb5'}, 3, 0xB3B5}, /* (HANGUL SYLLABLE DYELT) */
    {{'\xeb', '\x8e', '\xb6'}, 3, 0xB3B6}, /* (HANGUL SYLLABLE DYELP) */
    {{'\xeb', '\x8e', '\xb7'}, 3, 0xB3B7}, /* (HANGUL SYLLABLE DYELH) */
    {{'\xeb', '\x8e', '\xb8'}, 3, 0xB3B8}, /* (HANGUL SYLLABLE DYEM) */
    {{'\xeb', '\x8e', '\xb9'}, 3, 0xB3B9}, /* (HANGUL SYLLABLE DYEB) */
    {{'\xeb', '\x8e', '\xba'}, 3, 0xB3BA}, /* (HANGUL SYLLABLE DYEBS) */
    {{'\xeb', '\x8e', '\xbb'}, 3, 0xB3BB}, /* (HANGUL SYLLABLE DYES) */
    {{'\xeb', '\x8e', '\xbc'}, 3, 0xB3BC}, /* (HANGUL SYLLABLE DYESS) */
    {{'\xeb', '\x8e', '\xbd'}, 3, 0xB3BD}, /* (HANGUL SYLLABLE DYENG) */
    {{'\xeb', '\x8e', '\xbe'}, 3, 0xB3BE}, /* (HANGUL SYLLABLE DYEJ) */
    {{'\xeb', '\x8e', '\xbf'}, 3, 0xB3BF}, /* (HANGUL SYLLABLE DYEC) */
    {{'\xeb', '\x8f', '\x80'}, 3, 0xB3C0}, /* (HANGUL SYLLABLE DYEK) */
    {{'\xeb', '\x8f', '\x81'}, 3, 0xB3C1}, /* (HANGUL SYLLABLE DYET) */
    {{'\xeb', '\x8f', '\x82'}, 3, 0xB3C2}, /* (HANGUL SYLLABLE DYEP) */
    {{'\xeb', '\x8f', '\x83'}, 3, 0xB3C3}, /* (HANGUL SYLLABLE DYEH) */
    {{'\xeb', '\x8f', '\x86'}, 3, 0xB3C6}, /* (HANGUL SYLLABLE DOGG) */
    {{'\xeb', '\x8f', '\x87'}, 3, 0xB3C7}, /* (HANGUL SYLLABLE DOGS) */
    {{'\xeb', '\x8f', '\x89'}, 3, 0xB3C9}, /* (HANGUL SYLLABLE DONJ) */
    {{'\xeb', '\x8f', '\x8a'}, 3, 0xB3CA}, /* (HANGUL SYLLABLE DONH) */
    {{'\xeb', '\x8f', '\x8d'}, 3, 0xB3CD}, /* (HANGUL SYLLABLE DOLG) */
    {{'\xeb', '\x8f', '\x8f'}, 3, 0xB3CF}, /* (HANGUL SYLLABLE DOLB) */
    {{'\xeb', '\x8f', '\x91'}, 3, 0xB3D1}, /* (HANGUL SYLLABLE DOLT) */
    {{'\xeb', '\x8f', '\x92'}, 3, 0xB3D2}, /* (HANGUL SYLLABLE DOLP) */
    {{'\xeb', '\x8f', '\x93'}, 3, 0xB3D3}, /* (HANGUL SYLLABLE DOLH) */
    {{'\xeb', '\x8f', '\x96'}, 3, 0xB3D6}, /* (HANGUL SYLLABLE DOBS) */
    {{'\xeb', '\x8f', '\x98'}, 3, 0xB3D8}, /* (HANGUL SYLLABLE DOSS) */
    {{'\xeb', '\x8f', '\x9a'}, 3, 0xB3DA}, /* (HANGUL SYLLABLE DOJ) */
    {{'\xeb', '\x8f', '\x9c'}, 3, 0xB3DC}, /* (HANGUL SYLLABLE DOK) */
    {{'\xeb', '\x8f', '\x9e'}, 3, 0xB3DE}, /* (HANGUL SYLLABLE DOP) */
    {{'\xeb', '\x8f', '\x9f'}, 3, 0xB3DF}, /* (HANGUL SYLLABLE DOH) */
    {{'\xeb', '\x8f', '\xa1'}, 3, 0xB3E1}, /* (HANGUL SYLLABLE DWAG) */
    {{'\xeb', '\x8f', '\xa2'}, 3, 0xB3E2}, /* (HANGUL SYLLABLE DWAGG) */
    {{'\xeb', '\x8f', '\xa3'}, 3, 0xB3E3}, /* (HANGUL SYLLABLE DWAGS) */
    {{'\xeb', '\x8f', '\xa5'}, 3, 0xB3E5}, /* (HANGUL SYLLABLE DWANJ) */
    {{'\xeb', '\x8f', '\xa6'}, 3, 0xB3E6}, /* (HANGUL SYLLABLE DWANH) */
    {{'\xeb', '\x8f', '\xa7'}, 3, 0xB3E7}, /* (HANGUL SYLLABLE DWAD) */
    {{'\xeb', '\x8f', '\xa9'}, 3, 0xB3E9}, /* (HANGUL SYLLABLE DWALG) */
    {{'\xeb', '\x8f', '\xaa'}, 3, 0xB3EA}, /* (HANGUL SYLLABLE DWALM) */
    {{'\xeb', '\x8f', '\xab'}, 3, 0xB3EB}, /* (HANGUL SYLLABLE DWALB) */
    {{'\xeb', '\x8f', '\xac'}, 3, 0xB3EC}, /* (HANGUL SYLLABLE DWALS) */
    {{'\xeb', '\x8f', '\xad'}, 3, 0xB3ED}, /* (HANGUL SYLLABLE DWALT) */
    {{'\xeb', '\x8f', '\xae'}, 3, 0xB3EE}, /* (HANGUL SYLLABLE DWALP) */
    {{'\xeb', '\x8f', '\xaf'}, 3, 0xB3EF}, /* (HANGUL SYLLABLE DWALH) */
    {{'\xeb', '\x8f', '\xb0'}, 3, 0xB3F0}, /* (HANGUL SYLLABLE DWAM) */
    {{'\xeb', '\x8f', '\xb1'}, 3, 0xB3F1}, /* (HANGUL SYLLABLE DWAB) */
    {{'\xeb', '\x8f', '\xb2'}, 3, 0xB3F2}, /* (HANGUL SYLLABLE DWABS) */
    {{'\xeb', '\x8f', '\xb3'}, 3, 0xB3F3}, /* (HANGUL SYLLABLE DWAS) */
    {{'\xeb', '\x8f', '\xb4'}, 3, 0xB3F4}, /* (HANGUL SYLLABLE DWASS) */
    {{'\xeb', '\x8f', '\xb5'}, 3, 0xB3F5}, /* (HANGUL SYLLABLE DWANG) */
    {{'\xeb', '\x8f', '\xb6'}, 3, 0xB3F6}, /* (HANGUL SYLLABLE DWAJ) */
    {{'\xeb', '\x8f', '\xb7'}, 3, 0xB3F7}, /* (HANGUL SYLLABLE DWAC) */
    {{'\xeb', '\x8f', '\xb8'}, 3, 0xB3F8}, /* (HANGUL SYLLABLE DWAK) */
    {{'\xeb', '\x8f', '\xb9'}, 3, 0xB3F9}, /* (HANGUL SYLLABLE DWAT) */
    {{'\xeb', '\x8f', '\xba'}, 3, 0xB3FA}, /* (HANGUL SYLLABLE DWAP) */
    {{'\xeb', '\x8f', '\xbb'}, 3, 0xB3FB}, /* (HANGUL SYLLABLE DWAH) */
    {{'\xeb', '\x8f', '\xbd'}, 3, 0xB3FD}, /* (HANGUL SYLLABLE DWAEG) */
    {{'\xeb', '\x8f', '\xbe'}, 3, 0xB3FE}, /* (HANGUL SYLLABLE DWAEGG) */
    {{'\xeb', '\x8f', '\xbf'}, 3, 0xB3FF}, /* (HANGUL SYLLABLE DWAEGS) */
    {{'\xeb', '\x90', '\x80'}, 3, 0xB400}, /* (HANGUL SYLLABLE DWAEN) */
    {{'\xeb', '\x90', '\x81'}, 3, 0xB401}, /* (HANGUL SYLLABLE DWAENJ) */
    {{'\xeb', '\x90', '\x82'}, 3, 0xB402}, /* (HANGUL SYLLABLE DWAENH) */
    {{'\xeb', '\x90', '\x83'}, 3, 0xB403}, /* (HANGUL SYLLABLE DWAED) */
    {{'\xeb', '\x90', '\x84'}, 3, 0xB404}, /* (HANGUL SYLLABLE DWAEL) */
    {{'\xeb', '\x90', '\x85'}, 3, 0xB405}, /* (HANGUL SYLLABLE DWAELG) */
    {{'\xeb', '\x90', '\x86'}, 3, 0xB406}, /* (HANGUL SYLLABLE DWAELM) */
    {{'\xeb', '\x90', '\x87'}, 3, 0xB407}, /* (HANGUL SYLLABLE DWAELB) */
    {{'\xeb', '\x90', '\x88'}, 3, 0xB408}, /* (HANGUL SYLLABLE DWAELS) */
    {{'\xeb', '\x90', '\x89'}, 3, 0xB409}, /* (HANGUL SYLLABLE DWAELT) */
    {{'\xeb', '\x90', '\x8a'}, 3, 0xB40A}, /* (HANGUL SYLLABLE DWAELP) */
    {{'\xeb', '\x90', '\x8b'}, 3, 0xB40B}, /* (HANGUL SYLLABLE DWAELH) */
    {{'\xeb', '\x90', '\x8c'}, 3, 0xB40C}, /* (HANGUL SYLLABLE DWAEM) */
    {{'\xeb', '\x90', '\x8d'}, 3, 0xB40D}, /* (HANGUL SYLLABLE DWAEB) */
    {{'\xeb', '\x90', '\x8e'}, 3, 0xB40E}, /* (HANGUL SYLLABLE DWAEBS) */
    {{'\xeb', '\x90', '\x8f'}, 3, 0xB40F}, /* (HANGUL SYLLABLE DWAES) */
    {{'\xeb', '\x90', '\x91'}, 3, 0xB411}, /* (HANGUL SYLLABLE DWAENG) */
    {{'\xeb', '\x90', '\x92'}, 3, 0xB412}, /* (HANGUL SYLLABLE DWAEJ) */
    {{'\xeb', '\x90', '\x93'}, 3, 0xB413}, /* (HANGUL SYLLABLE DWAEC) */
    {{'\xeb', '\x90', '\x94'}, 3, 0xB414}, /* (HANGUL SYLLABLE DWAEK) */
    {{'\xeb', '\x90', '\x95'}, 3, 0xB415}, /* (HANGUL SYLLABLE DWAET) */
    {{'\xeb', '\x90', '\x96'}, 3, 0xB416}, /* (HANGUL SYLLABLE DWAEP) */
    {{'\xeb', '\x90', '\x97'}, 3, 0xB417}, /* (HANGUL SYLLABLE DWAEH) */
    {{'\xeb', '\x90', '\x99'}, 3, 0xB419}, /* (HANGUL SYLLABLE DOEG) */
    {{'\xeb', '\x90', '\x9a'}, 3, 0xB41A}, /* (HANGUL SYLLABLE DOEGG) */
    {{'\xeb', '\x90', '\x9b'}, 3, 0xB41B}, /* (HANGUL SYLLABLE DOEGS) */
    {{'\xeb', '\x90', '\x9d'}, 3, 0xB41D}, /* (HANGUL SYLLABLE DOENJ) */
    {{'\xeb', '\x90', '\x9e'}, 3, 0xB41E}, /* (HANGUL SYLLABLE DOENH) */
    {{'\xeb', '\x90', '\x9f'}, 3, 0xB41F}, /* (HANGUL SYLLABLE DOED) */
    {{'\xeb', '\x90', '\xa1'}, 3, 0xB421}, /* (HANGUL SYLLABLE DOELG) */
    {{'\xeb', '\x90', '\xa2'}, 3, 0xB422}, /* (HANGUL SYLLABLE DOELM) */
    {{'\xeb', '\x90', '\xa3'}, 3, 0xB423}, /* (HANGUL SYLLABLE DOELB) */
    {{'\xeb', '\x90', '\xa4'}, 3, 0xB424}, /* (HANGUL SYLLABLE DOELS) */
    {{'\xeb', '\x90', '\xa5'}, 3, 0xB425}, /* (HANGUL SYLLABLE DOELT) */
    {{'\xeb', '\x90', '\xa6'}, 3, 0xB426}, /* (HANGUL SYLLABLE DOELP) */
    {{'\xeb', '\x90', '\xa7'}, 3, 0xB427}, /* (HANGUL SYLLABLE DOELH) */
    {{'\xeb', '\x90', '\xaa'}, 3, 0xB42A}, /* (HANGUL SYLLABLE DOEBS) */
    {{'\xeb', '\x90', '\xac'}, 3, 0xB42C}, /* (HANGUL SYLLABLE DOESS) */
    {{'\xeb', '\x90', '\xad'}, 3, 0xB42D}, /* (HANGUL SYLLABLE DOENG) */
    {{'\xeb', '\x90', '\xae'}, 3, 0xB42E}, /* (HANGUL SYLLABLE DOEJ) */
    {{'\xeb', '\x90', '\xaf'}, 3, 0xB42F}, /* (HANGUL SYLLABLE DOEC) */
    {{'\xeb', '\x90', '\xb0'}, 3, 0xB430}, /* (HANGUL SYLLABLE DOEK) */
    {{'\xeb', '\x90', '\xb1'}, 3, 0xB431}, /* (HANGUL SYLLABLE DOET) */
    {{'\xeb', '\x90', '\xb2'}, 3, 0xB432}, /* (HANGUL SYLLABLE DOEP) */
    {{'\xeb', '\x90', '\xb3'}, 3, 0xB433}, /* (HANGUL SYLLABLE DOEH) */
    {{'\xeb', '\x90', '\xb5'}, 3, 0xB435}, /* (HANGUL SYLLABLE DYOG) */
    {{'\xeb', '\x90', '\xb6'}, 3, 0xB436}, /* (HANGUL SYLLABLE DYOGG) */
    {{'\xeb', '\x90', '\xb7'}, 3, 0xB437}, /* (HANGUL SYLLABLE DYOGS) */
    {{'\xeb', '\x90', '\xb8'}, 3, 0xB438}, /* (HANGUL SYLLABLE DYON) */
    {{'\xeb', '\x90', '\xb9'}, 3, 0xB439}, /* (HANGUL SYLLABLE DYONJ) */
    {{'\xeb', '\x90', '\xba'}, 3, 0xB43A}, /* (HANGUL SYLLABLE DYONH) */
    {{'\xeb', '\x90', '\xbb'}, 3, 0xB43B}, /* (HANGUL SYLLABLE DYOD) */
    {{'\xeb', '\x90', '\xbc'}, 3, 0xB43C}, /* (HANGUL SYLLABLE DYOL) */
    {{'\xeb', '\x90', '\xbd'}, 3, 0xB43D}, /* (HANGUL SYLLABLE DYOLG) */
    {{'\xeb', '\x90', '\xbe'}, 3, 0xB43E}, /* (HANGUL SYLLABLE DYOLM) */
    {{'\xeb', '\x90', '\xbf'}, 3, 0xB43F}, /* (HANGUL SYLLABLE DYOLB) */
    {{'\xeb', '\x91', '\x80'}, 3, 0xB440}, /* (HANGUL SYLLABLE DYOLS) */
    {{'\xeb', '\x91', '\x81'}, 3, 0xB441}, /* (HANGUL SYLLABLE DYOLT) */
    {{'\xeb', '\x91', '\x82'}, 3, 0xB442}, /* (HANGUL SYLLABLE DYOLP) */
    {{'\xeb', '\x91', '\x83'}, 3, 0xB443}, /* (HANGUL SYLLABLE DYOLH) */
    {{'\xeb', '\x91', '\x84'}, 3, 0xB444}, /* (HANGUL SYLLABLE DYOM) */
    {{'\xeb', '\x91', '\x85'}, 3, 0xB445}, /* (HANGUL SYLLABLE DYOB) */
    {{'\xeb', '\x91', '\x86'}, 3, 0xB446}, /* (HANGUL SYLLABLE DYOBS) */
    {{'\xeb', '\x91', '\x87'}, 3, 0xB447}, /* (HANGUL SYLLABLE DYOS) */
    {{'\xeb', '\x91', '\x88'}, 3, 0xB448}, /* (HANGUL SYLLABLE DYOSS) */
    {{'\xeb', '\x91', '\x89'}, 3, 0xB449}, /* (HANGUL SYLLABLE DYONG) */
    {{'\xeb', '\x91', '\x8a'}, 3, 0xB44A}, /* (HANGUL SYLLABLE DYOJ) */
    {{'\xeb', '\x91', '\x8b'}, 3, 0xB44B}, /* (HANGUL SYLLABLE DYOC) */
    {{'\xeb', '\x91', '\x8c'}, 3, 0xB44C}, /* (HANGUL SYLLABLE DYOK) */
    {{'\xeb', '\x91', '\x8d'}, 3, 0xB44D}, /* (HANGUL SYLLABLE DYOT) */
    {{'\xeb', '\x91', '\x8e'}, 3, 0xB44E}, /* (HANGUL SYLLABLE DYOP) */
    {{'\xeb', '\x91', '\x8f'}, 3, 0xB44F}, /* (HANGUL SYLLABLE DYOH) */
    {{'\xeb', '\x91', '\x92'}, 3, 0xB452}, /* (HANGUL SYLLABLE DUGG) */
    {{'\xeb', '\x91', '\x93'}, 3, 0xB453}, /* (HANGUL SYLLABLE DUGS) */
    {{'\xeb', '\x91', '\x95'}, 3, 0xB455}, /* (HANGUL SYLLABLE DUNJ) */
    {{'\xeb', '\x91', '\x96'}, 3, 0xB456}, /* (HANGUL SYLLABLE DUNH) */
    {{'\xeb', '\x91', '\x97'}, 3, 0xB457}, /* (HANGUL SYLLABLE DUD) */
    {{'\xeb', '\x91', '\x99'}, 3, 0xB459}, /* (HANGUL SYLLABLE DULG) */
    {{'\xeb', '\x91', '\x9a'}, 3, 0xB45A}, /* (HANGUL SYLLABLE DULM) */
    {{'\xeb', '\x91', '\x9b'}, 3, 0xB45B}, /* (HANGUL SYLLABLE DULB) */
    {{'\xeb', '\x91', '\x9c'}, 3, 0xB45C}, /* (HANGUL SYLLABLE DULS) */
    {{'\xeb', '\x91', '\x9d'}, 3, 0xB45D}, /* (HANGUL SYLLABLE DULT) */
    {{'\xeb', '\x91', '\x9e'}, 3, 0xB45E}, /* (HANGUL SYLLABLE DULP) */
    {{'\xeb', '\x91', '\x9f'}, 3, 0xB45F}, /* (HANGUL SYLLABLE DULH) */
    {{'\xeb', '\x91', '\xa2'}, 3, 0xB462}, /* (HANGUL SYLLABLE DUBS) */
    {{'\xeb', '\x91', '\xa4'}, 3, 0xB464}, /* (HANGUL SYLLABLE DUSS) */
    {{'\xeb', '\x91', '\xa6'}, 3, 0xB466}, /* (HANGUL SYLLABLE DUJ) */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{'\xeb', '\x91', '\xa7'}, 3, 0xB467}, /* (HANGUL SYLLABLE DUC) */
    {{'\xeb', '\x91', '\xa8'}, 3, 0xB468}, /* (HANGUL SYLLABLE DUK) */
    {{'\xeb', '\x91', '\xa9'}, 3, 0xB469}, /* (HANGUL SYLLABLE DUT) */
    {{'\xeb', '\x91', '\xaa'}, 3, 0xB46A}, /* (HANGUL SYLLABLE DUP) */
    {{'\xeb', '\x91', '\xab'}, 3, 0xB46B}, /* (HANGUL SYLLABLE DUH) */
    {{'\xeb', '\x91', '\xad'}, 3, 0xB46D}, /* (HANGUL SYLLABLE DWEOG) */
    {{'\xeb', '\x91', '\xae'}, 3, 0xB46E}, /* (HANGUL SYLLABLE DWEOGG) */
    {{'\xeb', '\x91', '\xaf'}, 3, 0xB46F}, /* (HANGUL SYLLABLE DWEOGS) */
    {{'\xeb', '\x91', '\xb0'}, 3, 0xB470}, /* (HANGUL SYLLABLE DWEON) */
    {{'\xeb', '\x91', '\xb1'}, 3, 0xB471}, /* (HANGUL SYLLABLE DWEONJ) */
    {{'\xeb', '\x91', '\xb2'}, 3, 0xB472}, /* (HANGUL SYLLABLE DWEONH) */
    {{'\xeb', '\x91', '\xb3'}, 3, 0xB473}, /* (HANGUL SYLLABLE DWEOD) */
    {{'\xeb', '\x91', '\xb4'}, 3, 0xB474}, /* (HANGUL SYLLABLE DWEOL) */
    {{'\xeb', '\x91', '\xb5'}, 3, 0xB475}, /* (HANGUL SYLLABLE DWEOLG) */
    {{'\xeb', '\x91', '\xb6'}, 3, 0xB476}, /* (HANGUL SYLLABLE DWEOLM) */
    {{'\xeb', '\x91', '\xb7'}, 3, 0xB477}, /* (HANGUL SYLLABLE DWEOLB) */
    {{'\xeb', '\x91', '\xb8'}, 3, 0xB478}, /* (HANGUL SYLLABLE DWEOLS) */
    {{'\xeb', '\x91', '\xb9'}, 3, 0xB479}, /* (HANGUL SYLLABLE DWEOLT) */
    {{'\xeb', '\x91', '\xba'}, 3, 0xB47A}, /* (HANGUL SYLLABLE DWEOLP) */
    {{'\xeb', '\x91', '\xbb'}, 3, 0xB47B}, /* (HANGUL SYLLABLE DWEOLH) */
    {{'\xeb', '\x91', '\xbc'}, 3, 0xB47C}, /* (HANGUL SYLLABLE DWEOM) */
    {{'\xeb', '\x91', '\xbd'}, 3, 0xB47D}, /* (HANGUL SYLLABLE DWEOB) */
    {{'\xeb', '\x91', '\xbe'}, 3, 0xB47E}, /* (HANGUL SYLLABLE DWEOBS) */
    {{'\xeb', '\x91', '\xbf'}, 3, 0xB47F}, /* (HANGUL SYLLABLE DWEOS) */
    {{'\xeb', '\x92', '\x81'}, 3, 0xB481}, /* (HANGUL SYLLABLE DWEONG) */
    {{'\xeb', '\x92', '\x82'}, 3, 0xB482}, /* (HANGUL SYLLABLE DWEOJ) */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{'\xeb', '\x92', '\x83'}, 3, 0xB483}, /* (HANGUL SYLLABLE DWEOC) */
    {{'\xeb', '\x92', '\x84'}, 3, 0xB484}, /* (HANGUL SYLLABLE DWEOK) */
    {{'\xeb', '\x92', '\x85'}, 3, 0xB485}, /* (HANGUL SYLLABLE DWEOT) */
    {{'\xeb', '\x92', '\x86'}, 3, 0xB486}, /* (HANGUL SYLLABLE DWEOP) */
    {{'\xeb', '\x92', '\x87'}, 3, 0xB487}, /* (HANGUL SYLLABLE DWEOH) */
    {{'\xeb', '\x92', '\x89'}, 3, 0xB489}, /* (HANGUL SYLLABLE DWEG) */
    {{'\xeb', '\x92', '\x8a'}, 3, 0xB48A}, /* (HANGUL SYLLABLE DWEGG) */
    {{'\xeb', '\x92', '\x8b'}, 3, 0xB48B}, /* (HANGUL SYLLABLE DWEGS) */
    {{'\xeb', '\x92', '\x8c'}, 3, 0xB48C}, /* (HANGUL SYLLABLE DWEN) */
    {{'\xeb', '\x92', '\x8d'}, 3, 0xB48D}, /* (HANGUL SYLLABLE DWENJ) */
    {{'\xeb', '\x92', '\x8e'}, 3, 0xB48E}, /* (HANGUL SYLLABLE DWENH) */
    {{'\xeb', '\x92', '\x8f'}, 3, 0xB48F}, /* (HANGUL SYLLABLE DWED) */
    {{'\xeb', '\x92', '\x90'}, 3, 0xB490}, /* (HANGUL SYLLABLE DWEL) */
    {{'\xeb', '\x92', '\x91'}, 3, 0xB491}, /* (HANGUL SYLLABLE DWELG) */
    {{'\xeb', '\x92', '\x92'}, 3, 0xB492}, /* (HANGUL SYLLABLE DWELM) */
    {{'\xeb', '\x92', '\x93'}, 3, 0xB493}, /* (HANGUL SYLLABLE DWELB) */
    {{'\xeb', '\x92', '\x94'}, 3, 0xB494}, /* (HANGUL SYLLABLE DWELS) */
    {{'\xeb', '\x92', '\x95'}, 3, 0xB495}, /* (HANGUL SYLLABLE DWELT) */
    {{'\xeb', '\x92', '\x96'}, 3, 0xB496}, /* (HANGUL SYLLABLE DWELP) */
    {{'\xeb', '\x92', '\x97'}, 3, 0xB497}, /* (HANGUL SYLLABLE DWELH) */
    {{'\xeb', '\x92', '\x98'}, 3, 0xB498}, /* (HANGUL SYLLABLE DWEM) */
    {{'\xeb', '\x92', '\x99'}, 3, 0xB499}, /* (HANGUL SYLLABLE DWEB) */
    {{'\xeb', '\x92', '\x9a'}, 3, 0xB49A}, /* (HANGUL SYLLABLE DWEBS) */
    {{'\xeb', '\x92', '\x9b'}, 3, 0xB49B}, /* (HANGUL SYLLABLE DWES) */
    {{'\xeb', '\x92', '\x9c'}, 3, 0xB49C}, /* (HANGUL SYLLABLE DWESS) */
    {{'\xeb', '\x92', '\x9e'}, 3, 0xB49E}, /* (HANGUL SYLLABLE DWEJ) */
    {{'\xeb', '\x92', '\x9f'}, 3, 0xB49F}, /* (HANGUL SYLLABLE DWEC) */
    {{'\xeb', '\x92', '\xa0'}, 3, 0xB4A0}, /* (HANGUL SYLLABLE DWEK) */
    {{'\xeb', '\x92', '\xa1'}, 3, 0xB4A1}, /* (HANGUL SYLLABLE DWET) */
    {{'\xeb', '\x92', '\xa2'}, 3, 0xB4A2}, /* (HANGUL SYLLABLE DWEP) */
    {{'\xeb', '\x92', '\xa3'}, 3, 0xB4A3}, /* (HANGUL SYLLABLE DWEH) */
    {{'\xeb', '\x92', '\xa5'}, 3, 0xB4A5}, /* (HANGUL SYLLABLE DWIG) */
    {{'\xeb', '\x92', '\xa6'}, 3, 0xB4A6}, /* (HANGUL SYLLABLE DWIGG) */
    {{'\xeb', '\x92', '\xa7'}, 3, 0xB4A7}, /* (HANGUL SYLLABLE DWIGS) */
    {{'\xeb', '\x92', '\xa9'}, 3, 0xB4A9}, /* (HANGUL SYLLABLE DWINJ) */
    {{'\xeb', '\x92', '\xaa'}, 3, 0xB4AA}, /* (HANGUL SYLLABLE DWINH) */
    {{'\xeb', '\x92', '\xab'}, 3, 0xB4AB}, /* (HANGUL SYLLABLE DWID) */
    {{'\xeb', '\x92', '\xad'}, 3, 0xB4AD}, /* (HANGUL SYLLABLE DWILG) */
    {{'\xeb', '\x92', '\xae'}, 3, 0xB4AE}, /* (HANGUL SYLLABLE DWILM) */
    {{'\xeb', '\x92', '\xaf'}, 3, 0xB4AF}, /* (HANGUL SYLLABLE DWILB) */
    {{'\xeb', '\x92', '\xb0'}, 3, 0xB4B0}, /* (HANGUL SYLLABLE DWILS) */
    {{'\xeb', '\x92', '\xb1'}, 3, 0xB4B1}, /* (HANGUL SYLLABLE DWILT) */
    {{'\xeb', '\x92', '\xb2'}, 3, 0xB4B2}, /* (HANGUL SYLLABLE DWILP) */
    {{'\xeb', '\x92', '\xb3'}, 3, 0xB4B3}, /* (HANGUL SYLLABLE DWILH) */
    {{'\xeb', '\x92', '\xb4'}, 3, 0xB4B4}, /* (HANGUL SYLLABLE DWIM) */
    {{'\xeb', '\x92', '\xb6'}, 3, 0xB4B6}, /* (HANGUL SYLLABLE DWIBS) */
    {{'\xeb', '\x92', '\xb8'}, 3, 0xB4B8}, /* (HANGUL SYLLABLE DWISS) */
    {{'\xeb', '\x92', '\xba'}, 3, 0xB4BA}, /* (HANGUL SYLLABLE DWIJ) */
    {{'\xeb', '\x92', '\xbb'}, 3, 0xB4BB}, /* (HANGUL SYLLABLE DWIC) */
    {{'\xeb', '\x92', '\xbc'}, 3, 0xB4BC}, /* (HANGUL SYLLABLE DWIK) */
    {{'\xeb', '\x92', '\xbd'}, 3, 0xB4BD}, /* (HANGUL SYLLABLE DWIT) */
    {{'\xeb', '\x92', '\xbe'}, 3, 0xB4BE}, /* (HANGUL SYLLABLE DWIP) */
    {{'\xeb', '\x92', '\xbf'}, 3, 0xB4BF}, /* (HANGUL SYLLABLE DWIH) */
    {{'\xeb', '\x93', '\x81'}, 3, 0xB4C1}, /* (HANGUL SYLLABLE DYUG) */
    {{'\xeb', '\x93', '\x82'}, 3, 0xB4C2}, /* (HANGUL SYLLABLE DYUGG) */
    {{'\xeb', '\x93', '\x83'}, 3, 0xB4C3}, /* (HANGUL SYLLABLE DYUGS) */
    {{'\xeb', '\x93', '\x85'}, 3, 0xB4C5}, /* (HANGUL SYLLABLE DYUNJ) */
    {{'\xeb', '\x93', '\x86'}, 3, 0xB4C6}, /* (HANGUL SYLLABLE DYUNH) */
    {{'\xeb', '\x93', '\x87'}, 3, 0xB4C7}, /* (HANGUL SYLLABLE DYUD) */
    {{'\xeb', '\x93', '\x89'}, 3, 0xB4C9}, /* (HANGUL SYLLABLE DYULG) */
    {{'\xeb', '\x93', '\x8a'}, 3, 0xB4CA}, /* (HANGUL SYLLABLE DYULM) */
    {{'\xeb', '\x93', '\x8b'}, 3, 0xB4CB}, /* (HANGUL SYLLABLE DYULB) */
    {{'\xeb', '\x93', '\x8c'}, 3, 0xB4CC}, /* (HANGUL SYLLABLE DYULS) */
    {{'\xeb', '\x93', '\x8d'}, 3, 0xB4CD}, /* (HANGUL SYLLABLE DYULT) */
    {{'\xeb', '\x93', '\x8e'}, 3, 0xB4CE}, /* (HANGUL SYLLABLE DYULP) */
    {{'\xeb', '\x93', '\x8f'}, 3, 0xB4CF}, /* (HANGUL SYLLABLE DYULH) */
    {{'\xeb', '\x93', '\x91'}, 3, 0xB4D1}, /* (HANGUL SYLLABLE DYUB) */
    {{'\xeb', '\x93', '\x92'}, 3, 0xB4D2}, /* (HANGUL SYLLABLE DYUBS) */
    {{'\xeb', '\x93', '\x93'}, 3, 0xB4D3}, /* (HANGUL SYLLABLE DYUS) */
    {{'\xeb', '\x93', '\x94'}, 3, 0xB4D4}, /* (HANGUL SYLLABLE DYUSS) */
    {{'\xeb', '\x93', '\x96'}, 3, 0xB4D6}, /* (HANGUL SYLLABLE DYUJ) */
    {{'\xeb', '\x93', '\x97'}, 3, 0xB4D7}, /* (HANGUL SYLLABLE DYUC) */
    {{'\xeb', '\x93', '\x98'}, 3, 0xB4D8}, /* (HANGUL SYLLABLE DYUK) */
    {{'\xeb', '\x93', '\x99'}, 3, 0xB4D9}, /* (HANGUL SYLLABLE DYUT) */
    {{'\xeb', '\x93', '\x9a'}, 3, 0xB4DA}, /* (HANGUL SYLLABLE DYUP) */
    {{'\xeb', '\x93', '\x9b'}, 3, 0xB4DB}, /* (HANGUL SYLLABLE DYUH) */
    {{'\xeb', '\x93', '\x9e'}, 3, 0xB4DE}, /* (HANGUL SYLLABLE DEUGG) */
    {{'\xeb', '\x93', '\x9f'}, 3, 0xB4DF}, /* (HANGUL SYLLABLE DEUGS) */
    {{'\xeb', '\x93', '\xa1'}, 3, 0xB4E1}, /* (HANGUL SYLLABLE DEUNJ) */
    {{'\xeb', '\x93', '\xa2'}, 3, 0xB4E2}, /* (HANGUL SYLLABLE DEUNH) */
    {{'\xeb', '\x93', '\xa5'}, 3, 0xB4E5}, /* (HANGUL SYLLABLE DEULG) */
    {{'\xeb', '\x93', '\xa7'}, 3, 0xB4E7}, /* (HANGUL SYLLABLE DEULB) */
    {{'\xeb', '\x93', '\xa8'}, 3, 0xB4E8}, /* (HANGUL SYLLABLE DEULS) */
    {{'\xeb', '\x93', '\xa9'}, 3, 0xB4E9}, /* (HANGUL SYLLABLE DEULT) */
    {{'\xeb', '\x93', '\xaa'}, 3, 0xB4EA}, /* (HANGUL SYLLABLE DEULP) */
    {{'\xeb', '\x93', '\xab'}, 3, 0xB4EB}, /* (HANGUL SYLLABLE DEULH) */
    {{'\xeb', '\x93', '\xae'}, 3, 0xB4EE}, /* (HANGUL SYLLABLE DEUBS) */
    {{'\xeb', '\x93', '\xb0'}, 3, 0xB4F0}, /* (HANGUL SYLLABLE DEUSS) */
    {{'\xeb', '\x93', '\xb2'}, 3, 0xB4F2}, /* (HANGUL SYLLABLE DEUJ) */
    {{'\xeb', '\x93', '\xb3'}, 3, 0xB4F3}, /* (HANGUL SYLLABLE DEUC) */
    {{'\xeb', '\x93', '\xb4'}, 3, 0xB4F4}, /* (HANGUL SYLLABLE DEUK) */
    {{'\xeb', '\x93', '\xb5'}, 3, 0xB4F5}, /* (HANGUL SYLLABLE DEUT) */
    {{'\xeb', '\x93', '\xb6'}, 3, 0xB4F6}, /* (HANGUL SYLLABLE DEUP) */
    {{'\xeb', '\x93', '\xb7'}, 3, 0xB4F7}, /* (HANGUL SYLLABLE DEUH) */
    {{'\xeb', '\x93', '\xb9'}, 3, 0xB4F9}, /* (HANGUL SYLLABLE DYIG) */
    {{'\xeb', '\x93', '\xba'}, 3, 0xB4FA}, /* (HANGUL SYLLABLE DYIGG) */
    {{'\xeb', '\x93', '\xbb'}, 3, 0xB4FB}, /* (HANGUL SYLLABLE DYIGS) */
    {{'\xeb', '\x93', '\xbc'}, 3, 0xB4FC}, /* (HANGUL SYLLABLE DYIN) */
    {{'\xeb', '\x93', '\xbd'}, 3, 0xB4FD}, /* (HANGUL SYLLABLE DYINJ) */
    {{'\xeb', '\x93', '\xbe'}, 3, 0xB4FE}, /* (HANGUL SYLLABLE DYINH) */
    {{'\xeb', '\x93', '\xbf'}, 3, 0xB4FF}, /* (HANGUL SYLLABLE DYID) */
    {{'\xeb', '\x94', '\x80'}, 3, 0xB500}, /* (HANGUL SYLLABLE DYIL) */
    {{'\xeb', '\x94', '\x81'}, 3, 0xB501}, /* (HANGUL SYLLABLE DYILG) */
    {{'\xeb', '\x94', '\x82'}, 3, 0xB502}, /* (HANGUL SYLLABLE DYILM) */
    {{'\xeb', '\x94', '\x83'}, 3, 0xB503}, /* (HANGUL SYLLABLE DYILB) */
    {{'\xeb', '\x94', '\x84'}, 3, 0xB504}, /* (HANGUL SYLLABLE DYILS) */
    {{'\xeb', '\x94', '\x85'}, 3, 0xB505}, /* (HANGUL SYLLABLE DYILT) */
    {{'\xeb', '\x94', '\x86'}, 3, 0xB506}, /* (HANGUL SYLLABLE DYILP) */
    {{'\xeb', '\x94', '\x87'}, 3, 0xB507}, /* (HANGUL SYLLABLE DYILH) */
    {{'\xeb', '\x94', '\x88'}, 3, 0xB508}, /* (HANGUL SYLLABLE DYIM) */
    {{'\xeb', '\x94', '\x89'}, 3, 0xB509}, /* (HANGUL SYLLABLE DYIB) */
    {{'\xeb', '\x94', '\x8a'}, 3, 0xB50A}, /* (HANGUL SYLLABLE DYIBS) */
    {{'\xeb', '\x94', '\x8b'}, 3, 0xB50B}, /* (HANGUL SYLLABLE DYIS) */
    {{'\xeb', '\x94', '\x8c'}, 3, 0xB50C}, /* (HANGUL SYLLABLE DYISS) */
    {{'\xeb', '\x94', '\x8d'}, 3, 0xB50D}, /* (HANGUL SYLLABLE DYING) */
    {{'\xeb', '\x94', '\x8e'}, 3, 0xB50E}, /* (HANGUL SYLLABLE DYIJ) */
    {{'\xeb', '\x94', '\x8f'}, 3, 0xB50F}, /* (HANGUL SYLLABLE DYIC) */
    {{'\xeb', '\x94', '\x90'}, 3, 0xB510}, /* (HANGUL SYLLABLE DYIK) */
    {{'\xeb', '\x94', '\x91'}, 3, 0xB511}, /* (HANGUL SYLLABLE DYIT) */
    {{'\xeb', '\x94', '\x92'}, 3, 0xB512}, /* (HANGUL SYLLABLE DYIP) */
    {{'\xeb', '\x94', '\x93'}, 3, 0xB513}, /* (HANGUL SYLLABLE DYIH) */
    {{'\xeb', '\x94', '\x96'}, 3, 0xB516}, /* (HANGUL SYLLABLE DIGG) */
    {{'\xeb', '\x94', '\x97'}, 3, 0xB517}, /* (HANGUL SYLLABLE DIGS) */
    {{'\xeb', '\x94', '\x99'}, 3, 0xB519}, /* (HANGUL SYLLABLE DINJ) */
    {{'\xeb', '\x94', '\x9a'}, 3, 0xB51A}, /* (HANGUL SYLLABLE DINH) */
    {{'\xeb', '\x94', '\x9d'}, 3, 0xB51D}, /* (HANGUL SYLLABLE DILG) */
    {{'\xeb', '\x94', '\x9e'}, 3, 0xB51E}, /* (HANGUL SYLLABLE DILM) */
    {{'\xeb', '\x94', '\x9f'}, 3, 0xB51F}, /* (HANGUL SYLLABLE DILB) */
    {{'\xeb', '\x94', '\xa0'}, 3, 0xB520}, /* (HANGUL SYLLABLE DILS) */
    {{'\xeb', '\x94', '\xa1'}, 3, 0xB521}, /* (HANGUL SYLLABLE DILT) */
    {{'\xeb', '\x94', '\xa2'}, 3, 0xB522}, /* (HANGUL SYLLABLE DILP) */
    {{'\xeb', '\x94', '\xa3'}, 3, 0xB523}, /* (HANGUL SYLLABLE DILH) */
    {{'\xeb', '\x94', '\xa6'}, 3, 0xB526}, /* (HANGUL SYLLABLE DIBS) */
    {{'\xeb', '\x94', '\xab'}, 3, 0xB52B}, /* (HANGUL SYLLABLE DIC) */
    {{'\xeb', '\x94', '\xac'}, 3, 0xB52C}, /* (HANGUL SYLLABLE DIK) */
    {{'\xeb', '\x94', '\xad'}, 3, 0xB52D}, /* (HANGUL SYLLABLE DIT) */
    {{'\xeb', '\x94', '\xae'}, 3, 0xB52E}, /* (HANGUL SYLLABLE DIP) */
    {{'\xeb', '\x94', '\xaf'}, 3, 0xB52F}, /* (HANGUL SYLLABLE DIH) */
    {{'\xeb', '\x94', '\xb2'}, 3, 0xB532}, /* (HANGUL SYLLABLE DDAGG) */
    {{'\xeb', '\x94', '\xb3'}, 3, 0xB533}, /* (HANGUL SYLLABLE DDAGS) */
    {{'\xeb', '\x94', '\xb5'}, 3, 0xB535}, /* (HANGUL SYLLABLE DDANJ) */
    {{'\xeb', '\x94', '\xb6'}, 3, 0xB536}, /* (HANGUL SYLLABLE DDANH) */
    {{'\xeb', '\x94', '\xb7'}, 3, 0xB537}, /* (HANGUL SYLLABLE DDAD) */
    {{'\xeb', '\x94', '\xb9'}, 3, 0xB539}, /* (HANGUL SYLLABLE DDALG) */
    {{'\xeb', '\x94', '\xba'}, 3, 0xB53A}, /* (HANGUL SYLLABLE DDALM) */
    {{'\xeb', '\x94', '\xbb'}, 3, 0xB53B}, /* (HANGUL SYLLABLE DDALB) */
    {{'\xeb', '\x94', '\xbc'}, 3, 0xB53C}, /* (HANGUL SYLLABLE DDALS) */
    {{'\xeb', '\x94', '\xbd'}, 3, 0xB53D}, /* (HANGUL SYLLABLE DDALT) */
    {{'\xeb', '\x94', '\xbe'}, 3, 0xB53E}, /* (HANGUL SYLLABLE DDALP) */
    {{'\xeb', '\x94', '\xbf'}, 3, 0xB53F}, /* (HANGUL SYLLABLE DDALH) */
    {{'\xeb', '\x95', '\x82'}, 3, 0xB542}, /* (HANGUL SYLLABLE DDABS) */
    {{'\xeb', '\x95', '\x86'}, 3, 0xB546}, /* (HANGUL SYLLABLE DDAJ) */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{'\xeb', '\x95', '\x87'}, 3, 0xB547}, /* (HANGUL SYLLABLE DDAC) */
    {{'\xeb', '\x95', '\x88'}, 3, 0xB548}, /* (HANGUL SYLLABLE DDAK) */
    {{'\xeb', '\x95', '\x89'}, 3, 0xB549}, /* (HANGUL SYLLABLE DDAT) */
    {{'\xeb', '\x95', '\x8a'}, 3, 0xB54A}, /* (HANGUL SYLLABLE DDAP) */
    {{'\xeb', '\x95', '\x8e'}, 3, 0xB54E}, /* (HANGUL SYLLABLE DDAEGG) */
    {{'\xeb', '\x95', '\x8f'}, 3, 0xB54F}, /* (HANGUL SYLLABLE DDAEGS) */
    {{'\xeb', '\x95', '\x91'}, 3, 0xB551}, /* (HANGUL SYLLABLE DDAENJ) */
    {{'\xeb', '\x95', '\x92'}, 3, 0xB552}, /* (HANGUL SYLLABLE DDAENH) */
    {{'\xeb', '\x95', '\x93'}, 3, 0xB553}, /* (HANGUL SYLLABLE DDAED) */
    {{'\xeb', '\x95', '\x95'}, 3, 0xB555}, /* (HANGUL SYLLABLE DDAELG) */
    {{'\xeb', '\x95', '\x96'}, 3, 0xB556}, /* (HANGUL SYLLABLE DDAELM) */
    {{'\xeb', '\x95', '\x97'}, 3, 0xB557}, /* (HANGUL SYLLABLE DDAELB) */
    {{'\xeb', '\x95', '\x98'}, 3, 0xB558}, /* (HANGUL SYLLABLE DDAELS) */
    {{'\xeb', '\x95', '\x99'}, 3, 0xB559}, /* (HANGUL SYLLABLE DDAELT) */
    {{'\xeb', '\x95', '\x9a'}, 3, 0xB55A}, /* (HANGUL SYLLABLE DDAELP) */
    {{'\xeb', '\x95', '\x9b'}, 3, 0xB55B}, /* (HANGUL SYLLABLE DDAELH) */
    {{'\xeb', '\x95', '\x9e'}, 3, 0xB55E}, /* (HANGUL SYLLABLE DDAEBS) */
    {{'\xeb', '\x95', '\xa2'}, 3, 0xB562}, /* (HANGUL SYLLABLE DDAEJ) */
    {{'\xeb', '\x95', '\xa3'}, 3, 0xB563}, /* (HANGUL SYLLABLE DDAEC) */
    {{'\xeb', '\x95', '\xa4'}, 3, 0xB564}, /* (HANGUL SYLLABLE DDAEK) */
    {{'\xeb', '\x95', '\xa5'}, 3, 0xB565}, /* (HANGUL SYLLABLE DDAET) */
    {{'\xeb', '\x95', '\xa6'}, 3, 0xB566}, /* (HANGUL SYLLABLE DDAEP) */
    {{'\xeb', '\x95', '\xa7'}, 3, 0xB567}, /* (HANGUL SYLLABLE DDAEH) */
    {{'\xeb', '\x95', '\xa8'}, 3, 0xB568}, /* (HANGUL SYLLABLE DDYA) */
    {{'\xeb', '\x95', '\xa9'}, 3, 0xB569}, /* (HANGUL SYLLABLE DDYAG) */
    {{'\xeb', '\x95', '\xaa'}, 3, 0xB56A}, /* (HANGUL SYLLABLE DDYAGG) */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{'\xeb', '\x95', '\xab'}, 3, 0xB56B}, /* (HANGUL SYLLABLE DDYAGS) */
    {{'\xeb', '\x95', '\xac'}, 3, 0xB56C}, /* (HANGUL SYLLABLE DDYAN) */
    {{'\xeb', '\x95', '\xad'}, 3, 0xB56D}, /* (HANGUL SYLLABLE DDYANJ) */
    {{'\xeb', '\x95', '\xae'}, 3, 0xB56E}, /* (HANGUL SYLLABLE DDYANH) */
    {{'\xeb', '\x95', '\xaf'}, 3, 0xB56F}, /* (HANGUL SYLLABLE DDYAD) */
    {{'\xeb', '\x95', '\xb0'}, 3, 0xB570}, /* (HANGUL SYLLABLE DDYAL) */
    {{'\xeb', '\x95', '\xb1'}, 3, 0xB571}, /* (HANGUL SYLLABLE DDYALG) */
    {{'\xeb', '\x95', '\xb2'}, 3, 0xB572}, /* (HANGUL SYLLABLE DDYALM) */
    {{'\xeb', '\x95', '\xb3'}, 3, 0xB573}, /* (HANGUL SYLLABLE DDYALB) */
    {{'\xeb', '\x95', '\xb4'}, 3, 0xB574}, /* (HANGUL SYLLABLE DDYALS) */
    {{'\xeb', '\x95', '\xb5'}, 3, 0xB575}, /* (HANGUL SYLLABLE DDYALT) */
    {{'\xeb', '\x95', '\xb6'}, 3, 0xB576}, /* (HANGUL SYLLABLE DDYALP) */
    {{'\xeb', '\x95', '\xb7'}, 3, 0xB577}, /* (HANGUL SYLLABLE DDYALH) */
    {{'\xeb', '\x95', '\xb8'}, 3, 0xB578}, /* (HANGUL SYLLABLE DDYAM) */
    {{'\xeb', '\x95', '\xb9'}, 3, 0xB579}, /* (HANGUL SYLLABLE DDYAB) */
    {{'\xeb', '\x95', '\xba'}, 3, 0xB57A}, /* (HANGUL SYLLABLE DDYABS) */
    {{'\xeb', '\x95', '\xbb'}, 3, 0xB57B}, /* (HANGUL SYLLABLE DDYAS) */
    {{'\xeb', '\x95', '\xbc'}, 3, 0xB57C}, /* (HANGUL SYLLABLE DDYASS) */
    {{'\xeb', '\x95', '\xbd'}, 3, 0xB57D}, /* (HANGUL SYLLABLE DDYANG) */
    {{'\xeb', '\x95', '\xbe'}, 3, 0xB57E}, /* (HANGUL SYLLABLE DDYAJ) */
    {{'\xeb', '\x95', '\xbf'}, 3, 0xB57F}, /* (HANGUL SYLLABLE DDYAC) */
    {{'\xeb', '\x96', '\x80'}, 3, 0xB580}, /* (HANGUL SYLLABLE DDYAK) */
    {{'\xeb', '\x96', '\x81'}, 3, 0xB581}, /* (HANGUL SYLLABLE DDYAT) */
    {{'\xeb', '\x96', '\x82'}, 3, 0xB582}, /* (HANGUL SYLLABLE DDYAP) */
    {{'\xeb', '\x96', '\x83'}, 3, 0xB583}, /* (HANGUL SYLLABLE DDYAH) */
    {{'\xeb', '\x96', '\x84'}, 3, 0xB584}, /* (HANGUL SYLLABLE DDYAE) */
    {{'\xeb', '\x96', '\x85'}, 3, 0xB585}, /* (HANGUL SYLLABLE DDYAEG) */
    {{'\xeb', '\x96', '\x86'}, 3, 0xB586}, /* (HANGUL SYLLABLE DDYAEGG) */
    {{'\xeb', '\x96', '\x87'}, 3, 0xB587}, /* (HANGUL SYLLABLE DDYAEGS) */
    {{'\xeb', '\x96', '\x88'}, 3, 0xB588}, /* (HANGUL SYLLABLE DDYAEN) */
    {{'\xeb', '\x96', '\x89'}, 3, 0xB589}, /* (HANGUL SYLLABLE DDYAENJ) */
    {{'\xeb', '\x96', '\x8a'}, 3, 0xB58A}, /* (HANGUL SYLLABLE DDYAENH) */
    {{'\xeb', '\x96', '\x8b'}, 3, 0xB58B}, /* (HANGUL SYLLABLE DDYAED) */
    {{'\xeb', '\x96', '\x8c'}, 3, 0xB58C}, /* (HANGUL SYLLABLE DDYAEL) */
    {{'\xeb', '\x96', '\x8d'}, 3, 0xB58D}, /* (HANGUL SYLLABLE DDYAELG) */
    {{'\xeb', '\x96', '\x8e'}, 3, 0xB58E}, /* (HANGUL SYLLABLE DDYAELM) */
    {{'\xeb', '\x96', '\x8f'}, 3, 0xB58F}, /* (HANGUL SYLLABLE DDYAELB) */
    {{'\xeb', '\x96', '\x90'}, 3, 0xB590}, /* (HANGUL SYLLABLE DDYAELS) */
    {{'\xeb', '\x96', '\x91'}, 3, 0xB591}, /* (HANGUL SYLLABLE DDYAELT) */
    {{'\xeb', '\x96', '\x92'}, 3, 0xB592}, /* (HANGUL SYLLABLE DDYAELP) */
    {{'\xeb', '\x96', '\x93'}, 3, 0xB593}, /* (HANGUL SYLLABLE DDYAELH) */
    {{'\xeb', '\x96', '\x94'}, 3, 0xB594}, /* (HANGUL SYLLABLE DDYAEM) */
    {{'\xeb', '\x96', '\x95'}, 3, 0xB595}, /* (HANGUL SYLLABLE DDYAEB) */
    {{'\xeb', '\x96', '\x96'}, 3, 0xB596}, /* (HANGUL SYLLABLE DDYAEBS) */
    {{'\xeb', '\x96', '\x97'}, 3, 0xB597}, /* (HANGUL SYLLABLE DDYAES) */
    {{'\xeb', '\x96', '\x98'}, 3, 0xB598}, /* (HANGUL SYLLABLE DDYAESS) */
    {{'\xeb', '\x96', '\x99'}, 3, 0xB599}, /* (HANGUL SYLLABLE DDYAENG) */
    {{'\xeb', '\x96', '\x9a'}, 3, 0xB59A}, /* (HANGUL SYLLABLE DDYAEJ) */
    {{'\xeb', '\x96', '\x9b'}, 3, 0xB59B}, /* (HANGUL SYLLABLE DDYAEC) */
    {{'\xeb', '\x96', '\x9c'}, 3, 0xB59C}, /* (HANGUL SYLLABLE DDYAEK) */
    {{'\xeb', '\x96', '\x9d'}, 3, 0xB59D}, /* (HANGUL SYLLABLE DDYAET) */
    {{'\xeb', '\x96', '\x9e'}, 3, 0xB59E}, /* (HANGUL SYLLABLE DDYAEP) */
    {{'\xeb', '\x96', '\x9f'}, 3, 0xB59F}, /* (HANGUL SYLLABLE DDYAEH) */
    {{'\xeb', '\x96', '\xa2'}, 3, 0xB5A2}, /* (HANGUL SYLLABLE DDEOGG) */
    {{'\xeb', '\x96', '\xa3'}, 3, 0xB5A3}, /* (HANGUL SYLLABLE DDEOGS) */
    {{'\xeb', '\x96', '\xa5'}, 3, 0xB5A5}, /* (HANGUL SYLLABLE DDEONJ) */
    {{'\xeb', '\x96', '\xa6'}, 3, 0xB5A6}, /* (HANGUL SYLLABLE DDEONH) */
    {{'\xeb', '\x96', '\xa7'}, 3, 0xB5A7}, /* (HANGUL SYLLABLE DDEOD) */
    {{'\xeb', '\x96', '\xa9'}, 3, 0xB5A9}, /* (HANGUL SYLLABLE DDEOLG) */
    {{'\xeb', '\x96', '\xac'}, 3, 0xB5AC}, /* (HANGUL SYLLABLE DDEOLS) */
    {{'\xeb', '\x96', '\xad'}, 3, 0xB5AD}, /* (HANGUL SYLLABLE DDEOLT) */
    {{'\xeb', '\x96', '\xae'}, 3, 0xB5AE}, /* (HANGUL SYLLABLE DDEOLP) */
    {{'\xeb', '\x96', '\xaf'}, 3, 0xB5AF}, /* (HANGUL SYLLABLE DDEOLH) */
    {{'\xeb', '\x96', '\xb2'}, 3, 0xB5B2}, /* (HANGUL SYLLABLE DDEOBS) */
    {{'\xeb', '\x96', '\xb6'}, 3, 0xB5B6}, /* (HANGUL SYLLABLE DDEOJ) */
    {{'\xeb', '\x96', '\xb7'}, 3, 0xB5B7}, /* (HANGUL SYLLABLE DDEOC) */
    {{'\xeb', '\x96', '\xb8'}, 3, 0xB5B8}, /* (HANGUL SYLLABLE DDEOK) */
    {{'\xeb', '\x96', '\xb9'}, 3, 0xB5B9}, /* (HANGUL SYLLABLE DDEOT) */
    {{'\xeb', '\x96', '\xba'}, 3, 0xB5BA}, /* (HANGUL SYLLABLE DDEOP) */
    {{'\xeb', '\x96', '\xbe'}, 3, 0xB5BE}, /* (HANGUL SYLLABLE DDEGG) */
    {{'\xeb', '\x96', '\xbf'}, 3, 0xB5BF}, /* (HANGUL SYLLABLE DDEGS) */
    {{'\xeb', '\x97', '\x81'}, 3, 0xB5C1}, /* (HANGUL SYLLABLE DDENJ) */
    {{'\xeb', '\x97', '\x82'}, 3, 0xB5C2}, /* (HANGUL SYLLABLE DDENH) */
    {{'\xeb', '\x97', '\x83'}, 3, 0xB5C3}, /* (HANGUL SYLLABLE DDED) */
    {{'\xeb', '\x97', '\x85'}, 3, 0xB5C5}, /* (HANGUL SYLLABLE DDELG) */
    {{'\xeb', '\x97', '\x86'}, 3, 0xB5C6}, /* (HANGUL SYLLABLE DDELM) */
    {{'\xeb', '\x97', '\x87'}, 3, 0xB5C7}, /* (HANGUL SYLLABLE DDELB) */
    {{'\xeb', '\x97', '\x88'}, 3, 0xB5C8}, /* (HANGUL SYLLABLE DDELS) */
    {{'\xeb', '\x97', '\x89'}, 3, 0xB5C9}, /* (HANGUL SYLLABLE DDELT) */
    {{'\xeb', '\x97', '\x8a'}, 3, 0xB5CA}, /* (HANGUL SYLLABLE DDELP) */
    {{'\xeb', '\x97', '\x8b'}, 3, 0xB5CB}, /* (HANGUL SYLLABLE DDELH) */
    {{'\xeb', '\x97', '\x8e'}, 3, 0xB5CE}, /* (HANGUL SYLLABLE DDEBS) */
    {{'\xeb', '\x97', '\x92'}, 3, 0xB5D2}, /* (HANGUL SYLLABLE DDEJ) */
    {{'\xeb', '\x97', '\x93'}, 3, 0xB5D3}, /* (HANGUL SYLLABLE DDEC) */
    {{'\xeb', '\x97', '\x94'}, 3, 0xB5D4}, /* (HANGUL SYLLABLE DDEK) */
    {{'\xeb', '\x97', '\x95'}, 3, 0xB5D5}, /* (HANGUL SYLLABLE DDET) */
    {{'\xeb', '\x97', '\x96'}, 3, 0xB5D6}, /* (HANGUL SYLLABLE DDEP) */
    {{'\xeb', '\x97', '\x97'}, 3, 0xB5D7}, /* (HANGUL SYLLABLE DDEH) */
    {{'\xeb', '\x97', '\x99'}, 3, 0xB5D9}, /* (HANGUL SYLLABLE DDYEOG) */
    {{'\xeb', '\x97', '\x9a'}, 3, 0xB5DA}, /* (HANGUL SYLLABLE DDYEOGG) */
    {{'\xeb', '\x97', '\x9b'}, 3, 0xB5DB}, /* (HANGUL SYLLABLE DDYEOGS) */
    {{'\xeb', '\x97', '\x9c'}, 3, 0xB5DC}, /* (HANGUL SYLLABLE DDYEON) */
    {{'\xeb', '\x97', '\x9d'}, 3, 0xB5DD}, /* (HANGUL SYLLABLE DDYEONJ) */
    {{'\xeb', '\x97', '\x9e'}, 3, 0xB5DE}, /* (HANGUL SYLLABLE DDYEONH) */
    {{'\xeb', '\x97', '\x9f'}, 3, 0xB5DF}, /* (HANGUL SYLLABLE DDYEOD) */
    {{'\xeb', '\x97', '\xa0'}, 3, 0xB5E0}, /* (HANGUL SYLLABLE DDYEOL) */
    {{'\xeb', '\x97', '\xa1'}, 3, 0xB5E1}, /* (HANGUL SYLLABLE DDYEOLG) */
    {{'\xeb', '\x97', '\xa2'}, 3, 0xB5E2}, /* (HANGUL SYLLABLE DDYEOLM) */
    {{'\xeb', '\x97', '\xa3'}, 3, 0xB5E3}, /* (HANGUL SYLLABLE DDYEOLB) */
    {{'\xeb', '\x97', '\xa4'}, 3, 0xB5E4}, /* (HANGUL SYLLABLE DDYEOLS) */
    {{'\xeb', '\x97', '\xa5'}, 3, 0xB5E5}, /* (HANGUL SYLLABLE DDYEOLT) */
    {{'\xeb', '\x97', '\xa6'}, 3, 0xB5E6}, /* (HANGUL SYLLABLE DDYEOLP) */
    {{'\xeb', '\x97', '\xa7'}, 3, 0xB5E7}, /* (HANGUL SYLLABLE DDYEOLH) */
    {{'\xeb', '\x97', '\xa8'}, 3, 0xB5E8}, /* (HANGUL SYLLABLE DDYEOM) */
    {{'\xeb', '\x97', '\xa9'}, 3, 0xB5E9}, /* (HANGUL SYLLABLE DDYEOB) */
    {{'\xeb', '\x97', '\xaa'}, 3, 0xB5EA}, /* (HANGUL SYLLABLE DDYEOBS) */
    {{'\xeb', '\x97', '\xab'}, 3, 0xB5EB}, /* (HANGUL SYLLABLE DDYEOS) */
    {{'\xeb', '\x97', '\xad'}, 3, 0xB5ED}, /* (HANGUL SYLLABLE DDYEONG) */
    {{'\xeb', '\x97', '\xae'}, 3, 0xB5EE}, /* (HANGUL SYLLABLE DDYEOJ) */
    {{'\xeb', '\x97', '\xaf'}, 3, 0xB5EF}, /* (HANGUL SYLLABLE DDYEOC) */
    {{'\xeb', '\x97', '\xb0'}, 3, 0xB5F0}, /* (HANGUL SYLLABLE DDYEOK) */
    {{'\xeb', '\x97', '\xb1'}, 3, 0xB5F1}, /* (HANGUL SYLLABLE DDYEOT) */
    {{'\xeb', '\x97', '\xb2'}, 3, 0xB5F2}, /* (HANGUL SYLLABLE DDYEOP) */
    {{'\xeb', '\x97', '\xb3'}, 3, 0xB5F3}, /* (HANGUL SYLLABLE DDYEOH) */
    {{'\xeb', '\x97', '\xb4'}, 3, 0xB5F4}, /* (HANGUL SYLLABLE DDYE) */
    {{'\xeb', '\x97', '\xb5'}, 3, 0xB5F5}, /* (HANGUL SYLLABLE DDYEG) */
    {{'\xeb', '\x97', '\xb6'}, 3, 0xB5F6}, /* (HANGUL SYLLABLE DDYEGG) */
    {{'\xeb', '\x97', '\xb7'}, 3, 0xB5F7}, /* (HANGUL SYLLABLE DDYEGS) */
    {{'\xeb', '\x97', '\xb8'}, 3, 0xB5F8}, /* (HANGUL SYLLABLE DDYEN) */
    {{'\xeb', '\x97', '\xb9'}, 3, 0xB5F9}, /* (HANGUL SYLLABLE DDYENJ) */
    {{'\xeb', '\x97', '\xba'}, 3, 0xB5FA}, /* (HANGUL SYLLABLE DDYENH) */
    {{'\xeb', '\x97', '\xbb'}, 3, 0xB5FB}, /* (HANGUL SYLLABLE DDYED) */
    {{'\xeb', '\x97', '\xbc'}, 3, 0xB5FC}, /* (HANGUL SYLLABLE DDYEL) */
    {{'\xeb', '\x97', '\xbd'}, 3, 0xB5FD}, /* (HANGUL SYLLABLE DDYELG) */
    {{'\xeb', '\x97', '\xbe'}, 3, 0xB5FE}, /* (HANGUL SYLLABLE DDYELM) */
    {{'\xeb', '\x97', '\xbf'}, 3, 0xB5FF}, /* (HANGUL SYLLABLE DDYELB) */
    {{'\xeb', '\x98', '\x80'}, 3, 0xB600}, /* (HANGUL SYLLABLE DDYELS) */
    {{'\xeb', '\x98', '\x81'}, 3, 0xB601}, /* (HANGUL SYLLABLE DDYELT) */
    {{'\xeb', '\x98', '\x82'}, 3, 0xB602}, /* (HANGUL SYLLABLE DDYELP) */
    {{'\xeb', '\x98', '\x83'}, 3, 0xB603}, /* (HANGUL SYLLABLE DDYELH) */
    {{'\xeb', '\x98', '\x84'}, 3, 0xB604}, /* (HANGUL SYLLABLE DDYEM) */
    {{'\xeb', '\x98', '\x85'}, 3, 0xB605}, /* (HANGUL SYLLABLE DDYEB) */
    {{'\xeb', '\x98', '\x86'}, 3, 0xB606}, /* (HANGUL SYLLABLE DDYEBS) */
    {{'\xeb', '\x98', '\x87'}, 3, 0xB607}, /* (HANGUL SYLLABLE DDYES) */
    {{'\xeb', '\x98', '\x88'}, 3, 0xB608}, /* (HANGUL SYLLABLE DDYESS) */
    {{'\xeb', '\x98', '\x89'}, 3, 0xB609}, /* (HANGUL SYLLABLE DDYENG) */
    {{'\xeb', '\x98', '\x8a'}, 3, 0xB60A}, /* (HANGUL SYLLABLE DDYEJ) */
    {{'\xeb', '\x98', '\x8b'}, 3, 0xB60B}, /* (HANGUL SYLLABLE DDYEC) */
    {{'\xeb', '\x98', '\x8c'}, 3, 0xB60C}, /* (HANGUL SYLLABLE DDYEK) */
    {{'\xeb', '\x98', '\x8d'}, 3, 0xB60D}, /* (HANGUL SYLLABLE DDYET) */
    {{'\xeb', '\x98', '\x8e'}, 3, 0xB60E}, /* (HANGUL SYLLABLE DDYEP) */
    {{'\xeb', '\x98', '\x8f'}, 3, 0xB60F}, /* (HANGUL SYLLABLE DDYEH) */
    {{'\xeb', '\x98', '\x92'}, 3, 0xB612}, /* (HANGUL SYLLABLE DDOGG) */
    {{'\xeb', '\x98', '\x93'}, 3, 0xB613}, /* (HANGUL SYLLABLE DDOGS) */
    {{'\xeb', '\x98', '\x95'}, 3, 0xB615}, /* (HANGUL SYLLABLE DDONJ) */
    {{'\xeb', '\x98', '\x96'}, 3, 0xB616}, /* (HANGUL SYLLABLE DDONH) */
    {{'\xeb', '\x98', '\x97'}, 3, 0xB617}, /* (HANGUL SYLLABLE DDOD) */
    {{'\xeb', '\x98', '\x99'}, 3, 0xB619}, /* (HANGUL SYLLABLE DDOLG) */
    {{'\xeb', '\x98', '\x9a'}, 3, 0xB61A}, /* (HANGUL SYLLABLE DDOLM) */
    {{'\xeb', '\x98', '\x9b'}, 3, 0xB61B}, /* (HANGUL SYLLABLE DDOLB) */
    {{'\xeb', '\x98', '\x9c'}, 3, 0xB61C}, /* (HANGUL SYLLABLE DDOLS) */
    {{'\xeb', '\x98', '\x9d'}, 3, 0xB61D}, /* (HANGUL SYLLABLE DDOLT) */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{'\xeb', '\x98', '\x9e'}, 3, 0xB61E}, /* (HANGUL SYLLABLE DDOLP) */
    {{'\xeb', '\x98', '\x9f'}, 3, 0xB61F}, /* (HANGUL SYLLABLE DDOLH) */
    {{'\xeb', '\x98', '\xa0'}, 3, 0xB620}, /* (HANGUL SYLLABLE DDOM) */
    {{'\xeb', '\x98', '\xa1'}, 3, 0xB621}, /* (HANGUL SYLLABLE DDOB) */
    {{'\xeb', '\x98', '\xa2'}, 3, 0xB622}, /* (HANGUL SYLLABLE DDOBS) */
    {{'\xeb', '\x98', '\xa3'}, 3, 0xB623}, /* (HANGUL SYLLABLE DDOS) */
    {{'\xeb', '\x98', '\xa4'}, 3, 0xB624}, /* (HANGUL SYLLABLE DDOSS) */
    {{'\xeb', '\x98', '\xa6'}, 3, 0xB626}, /* (HANGUL SYLLABLE DDOJ) */
    {{'\xeb', '\x98', '\xa7'}, 3, 0xB627}, /* (HANGUL SYLLABLE DDOC) */
    {{'\xeb', '\x98', '\xa8'}, 3, 0xB628}, /* (HANGUL SYLLABLE DDOK) */
    {{'\xeb', '\x98', '\xa9'}, 3, 0xB629}, /* (HANGUL SYLLABLE DDOT) */
    {{'\xeb', '\x98', '\xaa'}, 3, 0xB62A}, /* (HANGUL SYLLABLE DDOP) */
    {{'\xeb', '\x98', '\xab'}, 3, 0xB62B}, /* (HANGUL SYLLABLE DDOH) */
    {{'\xeb', '\x98', '\xad'}, 3, 0xB62D}, /* (HANGUL SYLLABLE DDWAG) */
    {{'\xeb', '\x98', '\xae'}, 3, 0xB62E}, /* (HANGUL SYLLABLE DDWAGG) */
    {{'\xeb', '\x98', '\xaf'}, 3, 0xB62F}, /* (HANGUL SYLLABLE DDWAGS) */
    {{'\xeb', '\x98', '\xb0'}, 3, 0xB630}, /* (HANGUL SYLLABLE DDWAN) */
    {{'\xeb', '\x98', '\xb1'}, 3, 0xB631}, /* (HANGUL SYLLABLE DDWANJ) */
    {{'\xeb', '\x98', '\xb2'}, 3, 0xB632}, /* (HANGUL SYLLABLE DDWANH) */
    {{'\xeb', '\x98', '\xb3'}, 3, 0xB633}, /* (HANGUL SYLLABLE DDWAD) */
    {{'\xeb', '\x98', '\xb5'}, 3, 0xB635}, /* (HANGUL SYLLABLE DDWALG) */
    {{'\xeb', '\x98', '\xb6'}, 3, 0xB636}, /* (HANGUL SYLLABLE DDWALM) */
    {{'\xeb', '\x98', '\xb7'}, 3, 0xB637}, /* (HANGUL SYLLABLE DDWALB) */
    {{'\xeb', '\x98', '\xb8'}, 3, 0xB638}, /* (HANGUL SYLLABLE DDWALS) */
    {{'\xeb', '\x98', '\xb9'}, 3, 0xB639}, /* (HANGUL SYLLABLE DDWALT) */
    {{'\xeb', '\x98', '\xba'}, 3, 0xB63A}, /* (HANGUL SYLLABLE DDWALP) */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{'\xeb', '\x98', '\xbb'}, 3, 0xB63B}, /* (HANGUL SYLLABLE DDWALH) */
    {{'\xeb', '\x98', '\xbc'}, 3, 0xB63C}, /* (HANGUL SYLLABLE DDWAM) */
    {{'\xeb', '\x98', '\xbd'}, 3, 0xB63D}, /* (HANGUL SYLLABLE DDWAB) */
    {{'\xeb', '\x98', '\xbe'}, 3, 0xB63E}, /* (HANGUL SYLLABLE DDWABS) */
    {{'\xeb', '\x98', '\xbf'}, 3, 0xB63F}, /* (HANGUL SYLLABLE DDWAS) */
    {{'\xeb', '\x99', '\x80'}, 3, 0xB640}, /* (HANGUL SYLLABLE DDWASS) */
    {{'\xeb', '\x99', '\x81'}, 3, 0xB641}, /* (HANGUL SYLLABLE DDWANG) */
    {{'\xeb', '\x99', '\x82'}, 3, 0xB642}, /* (HANGUL SYLLABLE DDWAJ) */
    {{'\xeb', '\x99', '\x83'}, 3, 0xB643}, /* (HANGUL SYLLABLE DDWAC) */
    {{'\xeb', '\x99', '\x84'}, 3, 0xB644}, /* (HANGUL SYLLABLE DDWAK) */
    {{'\xeb', '\x99', '\x85'}, 3, 0xB645}, /* (HANGUL SYLLABLE DDWAT) */
    {{'\xeb', '\x99', '\x86'}, 3, 0xB646}, /* (HANGUL SYLLABLE DDWAP) */
    {{'\xeb', '\x99', '\x87'}, 3, 0xB647}, /* (HANGUL SYLLABLE DDWAH) */
    {{'\xeb', '\x99', '\x89'}, 3, 0xB649}, /* (HANGUL SYLLABLE DDWAEG) */
    {{'\xeb', '\x99', '\x8a'}, 3, 0xB64A}, /* (HANGUL SYLLABLE DDWAEGG) */
    {{'\xeb', '\x99', '\x8b'}, 3, 0xB64B}, /* (HANGUL SYLLABLE DDWAEGS) */
    {{'\xeb', '\x99', '\x8c'}, 3, 0xB64C}, /* (HANGUL SYLLABLE DDWAEN) */
    {{'\xeb', '\x99', '\x8d'}, 3, 0xB64D}, /* (HANGUL SYLLABLE DDWAENJ) */
    {{'\xeb', '\x99', '\x8e'}, 3, 0xB64E}, /* (HANGUL SYLLABLE DDWAENH) */
    {{'\xeb', '\x99', '\x8f'}, 3, 0xB64F}, /* (HANGUL SYLLABLE DDWAED) */
    {{'\xeb', '\x99', '\x90'}, 3, 0xB650}, /* (HANGUL SYLLABLE DDWAEL) */
    {{'\xeb', '\x99', '\x91'}, 3, 0xB651}, /* (HANGUL SYLLABLE DDWAELG) */
    {{'\xeb', '\x99', '\x92'}, 3, 0xB652}, /* (HANGUL SYLLABLE DDWAELM) */
    {{'\xeb', '\x99', '\x93'}, 3, 0xB653}, /* (HANGUL SYLLABLE DDWAELB) */
    {{'\xeb', '\x99', '\x94'}, 3, 0xB654}, /* (HANGUL SYLLABLE DDWAELS) */
    {{'\xeb', '\x99', '\x95'}, 3, 0xB655}, /* (HANGUL SYLLABLE DDWAELT) */
    {{'\xeb', '\x99', '\x96'}, 3, 0xB656}, /* (HANGUL SYLLABLE DDWAELP) */
    {{'\xeb', '\x99', '\x97'}, 3, 0xB657}, /* (HANGUL SYLLABLE DDWAELH) */
    {{'\xeb', '\x99', '\x98'}, 3, 0xB658}, /* (HANGUL SYLLABLE DDWAEM) */
    {{'\xeb', '\x99', '\x99'}, 3, 0xB659}, /* (HANGUL SYLLABLE DDWAEB) */
    {{'\xeb', '\x99', '\x9a'}, 3, 0xB65A}, /* (HANGUL SYLLABLE DDWAEBS) */
    {{'\xeb', '\x99', '\x9b'}, 3, 0xB65B}, /* (HANGUL SYLLABLE DDWAES) */
    {{'\xeb', '\x99', '\x9c'}, 3, 0xB65C}, /* (HANGUL SYLLABLE DDWAESS) */
    {{'\xeb', '\x99', '\x9d'}, 3, 0xB65D}, /* (HANGUL SYLLABLE DDWAENG) */
    {{'\xeb', '\x99', '\x9e'}, 3, 0xB65E}, /* (HANGUL SYLLABLE DDWAEJ) */
    {{'\xeb', '\x99', '\x9f'}, 3, 0xB65F}, /* (HANGUL SYLLABLE DDWAEC) */
    {{'\xeb', '\x99', '\xa0'}, 3, 0xB660}, /* (HANGUL SYLLABLE DDWAEK) */
    {{'\xeb', '\x99', '\xa1'}, 3, 0xB661}, /* (HANGUL SYLLABLE DDWAET) */
    {{'\xeb', '\x99', '\xa2'}, 3, 0xB662}, /* (HANGUL SYLLABLE DDWAEP) */
    {{'\xeb', '\x99', '\xa3'}, 3, 0xB663}, /* (HANGUL SYLLABLE DDWAEH) */
    {{'\xeb', '\x99', '\xa5'}, 3, 0xB665}, /* (HANGUL SYLLABLE DDOEG) */
    {{'\xeb', '\x99', '\xa6'}, 3, 0xB666}, /* (HANGUL SYLLABLE DDOEGG) */
    {{'\xeb', '\x99', '\xa7'}, 3, 0xB667}, /* (HANGUL SYLLABLE DDOEGS) */
    {{'\xeb', '\x99', '\xa9'}, 3, 0xB669}, /* (HANGUL SYLLABLE DDOENJ) */
    {{'\xeb', '\x99', '\xaa'}, 3, 0xB66A}, /* (HANGUL SYLLABLE DDOENH) */
    {{'\xeb', '\x99', '\xab'}, 3, 0xB66B}, /* (HANGUL SYLLABLE DDOED) */
    {{'\xeb', '\x99', '\xac'}, 3, 0xB66C}, /* (HANGUL SYLLABLE DDOEL) */
    {{'\xeb', '\x99', '\xad'}, 3, 0xB66D}, /* (HANGUL SYLLABLE DDOELG) */
    {{'\xeb', '\x99', '\xae'}, 3, 0xB66E}, /* (HANGUL SYLLABLE DDOELM) */
    {{'\xeb', '\x99', '\xaf'}, 3, 0xB66F}, /* (HANGUL SYLLABLE DDOELB) */
    {{'\xeb', '\x99', '\xb0'}, 3, 0xB670}, /* (HANGUL SYLLABLE DDOELS) */
    {{'\xeb', '\x99', '\xb1'}, 3, 0xB671}, /* (HANGUL SYLLABLE DDOELT) */
    {{'\xeb', '\x99', '\xb2'}, 3, 0xB672}, /* (HANGUL SYLLABLE DDOELP) */
    {{'\xeb', '\x99', '\xb3'}, 3, 0xB673}, /* (HANGUL SYLLABLE DDOELH) */
    {{'\xeb', '\x99', '\xb4'}, 3, 0xB674}, /* (HANGUL SYLLABLE DDOEM) */
    {{'\xeb', '\x99', '\xb5'}, 3, 0xB675}, /* (HANGUL SYLLABLE DDOEB) */
    {{'\xeb', '\x99', '\xb6'}, 3, 0xB676}, /* (HANGUL SYLLABLE DDOEBS) */
    {{'\xeb', '\x99', '\xb7'}, 3, 0xB677}, /* (HANGUL SYLLABLE DDOES) */
    {{'\xeb', '\x99', '\xb8'}, 3, 0xB678}, /* (HANGUL SYLLABLE DDOESS) */
    {{'\xeb', '\x99', '\xb9'}, 3, 0xB679}, /* (HANGUL SYLLABLE DDOENG) */
    {{'\xeb', '\x99', '\xba'}, 3, 0xB67A}, /* (HANGUL SYLLABLE DDOEJ) */
    {{'\xeb', '\x99', '\xbb'}, 3, 0xB67B}, /* (HANGUL SYLLABLE DDOEC) */
    {{'\xeb', '\x99', '\xbc'}, 3, 0xB67C}, /* (HANGUL SYLLABLE DDOEK) */
    {{'\xeb', '\x99', '\xbd'}, 3, 0xB67D}, /* (HANGUL SYLLABLE DDOET) */
    {{'\xeb', '\x99', '\xbe'}, 3, 0xB67E}, /* (HANGUL SYLLABLE DDOEP) */
    {{'\xeb', '\x99', '\xbf'}, 3, 0xB67F}, /* (HANGUL SYLLABLE DDOEH) */
    {{'\xeb', '\x9a', '\x80'}, 3, 0xB680}, /* (HANGUL SYLLABLE DDYO) */
    {{'\xeb', '\x9a', '\x81'}, 3, 0xB681}, /* (HANGUL SYLLABLE DDYOG) */
    {{'\xeb', '\x9a', '\x82'}, 3, 0xB682}, /* (HANGUL SYLLABLE DDYOGG) */
    {{'\xeb', '\x9a', '\x83'}, 3, 0xB683}, /* (HANGUL SYLLABLE DDYOGS) */
    {{'\xeb', '\x9a', '\x84'}, 3, 0xB684}, /* (HANGUL SYLLABLE DDYON) */
    {{'\xeb', '\x9a', '\x85'}, 3, 0xB685}, /* (HANGUL SYLLABLE DDYONJ) */
    {{'\xeb', '\x9a', '\x86'}, 3, 0xB686}, /* (HANGUL SYLLABLE DDYONH) */
    {{'\xeb', '\x9a', '\x87'}, 3, 0xB687}, /* (HANGUL SYLLABLE DDYOD) */
    {{'\xeb', '\x9a', '\x88'}, 3, 0xB688}, /* (HANGUL SYLLABLE DDYOL) */
    {{'\xeb', '\x9a', '\x89'}, 3, 0xB689}, /* (HANGUL SYLLABLE DDYOLG) */
    {{'\xeb', '\x9a', '\x8a'}, 3, 0xB68A}, /* (HANGUL SYLLABLE DDYOLM) */
    {{'\xeb', '\x9a', '\x8b'}, 3, 0xB68B}, /* (HANGUL SYLLABLE DDYOLB) */
    {{'\xeb', '\x9a', '\x8c'}, 3, 0xB68C}, /* (HANGUL SYLLABLE DDYOLS) */
    {{'\xeb', '\x9a', '\x8d'}, 3, 0xB68D}, /* (HANGUL SYLLABLE DDYOLT) */
    {{'\xeb', '\x9a', '\x8e'}, 3, 0xB68E}, /* (HANGUL SYLLABLE DDYOLP) */
    {{'\xeb', '\x9a', '\x8f'}, 3, 0xB68F}, /* (HANGUL SYLLABLE DDYOLH) */
    {{'\xeb', '\x9a', '\x90'}, 3, 0xB690}, /* (HANGUL SYLLABLE DDYOM) */
    {{'\xeb', '\x9a', '\x91'}, 3, 0xB691}, /* (HANGUL SYLLABLE DDYOB) */
    {{'\xeb', '\x9a', '\x92'}, 3, 0xB692}, /* (HANGUL SYLLABLE DDYOBS) */
    {{'\xeb', '\x9a', '\x93'}, 3, 0xB693}, /* (HANGUL SYLLABLE DDYOS) */
    {{'\xeb', '\x9a', '\x94'}, 3, 0xB694}, /* (HANGUL SYLLABLE DDYOSS) */
    {{'\xeb', '\x9a', '\x95'}, 3, 0xB695}, /* (HANGUL SYLLABLE DDYONG) */
    {{'\xeb', '\x9a', '\x96'}, 3, 0xB696}, /* (HANGUL SYLLABLE DDYOJ) */
    {{'\xeb', '\x9a', '\x97'}, 3, 0xB697}, /* (HANGUL SYLLABLE DDYOC) */
    {{'\xeb', '\x9a', '\x98'}, 3, 0xB698}, /* (HANGUL SYLLABLE DDYOK) */
    {{'\xeb', '\x9a', '\x99'}, 3, 0xB699}, /* (HANGUL SYLLABLE DDYOT) */
    {{'\xeb', '\x9a', '\x9a'}, 3, 0xB69A}, /* (HANGUL SYLLABLE DDYOP) */
    {{'\xeb', '\x9a', '\x9b'}, 3, 0xB69B}, /* (HANGUL SYLLABLE DDYOH) */
    {{'\xeb', '\x9a', '\x9e'}, 3, 0xB69E}, /* (HANGUL SYLLABLE DDUGG) */
    {{'\xeb', '\x9a', '\x9f'}, 3, 0xB69F}, /* (HANGUL SYLLABLE DDUGS) */
    {{'\xeb', '\x9a', '\xa1'}, 3, 0xB6A1}, /* (HANGUL SYLLABLE DDUNJ) */
    {{'\xeb', '\x9a', '\xa2'}, 3, 0xB6A2}, /* (HANGUL SYLLABLE DDUNH) */
    {{'\xeb', '\x9a', '\xa3'}, 3, 0xB6A3}, /* (HANGUL SYLLABLE DDUD) */
    {{'\xeb', '\x9a', '\xa5'}, 3, 0xB6A5}, /* (HANGUL SYLLABLE DDULG) */
    {{'\xeb', '\x9a', '\xa6'}, 3, 0xB6A6}, /* (HANGUL SYLLABLE DDULM) */
    {{'\xeb', '\x9a', '\xa7'}, 3, 0xB6A7}, /* (HANGUL SYLLABLE DDULB) */
    {{'\xeb', '\x9a', '\xa8'}, 3, 0xB6A8}, /* (HANGUL SYLLABLE DDULS) */
    {{'\xeb', '\x9a', '\xa9'}, 3, 0xB6A9}, /* (HANGUL SYLLABLE DDULT) */
    {{'\xeb', '\x9a', '\xaa'}, 3, 0xB6AA}, /* (HANGUL SYLLABLE DDULP) */
    {{'\xeb', '\x9a', '\xad'}, 3, 0xB6AD}, /* (HANGUL SYLLABLE DDUB) */
    {{'\xeb', '\x9a', '\xae'}, 3, 0xB6AE}, /* (HANGUL SYLLABLE DDUBS) */
    {{'\xeb', '\x9a', '\xaf'}, 3, 0xB6AF}, /* (HANGUL SYLLABLE DDUS) */
    {{'\xeb', '\x9a', '\xb0'}, 3, 0xB6B0}, /* (HANGUL SYLLABLE DDUSS) */
    {{'\xeb', '\x9a', '\xb2'}, 3, 0xB6B2}, /* (HANGUL SYLLABLE DDUJ) */
    {{'\xeb', '\x9a', '\xb3'}, 3, 0xB6B3}, /* (HANGUL SYLLABLE DDUC) */
    {{'\xeb', '\x9a', '\xb4'}, 3, 0xB6B4}, /* (HANGUL SYLLABLE DDUK) */
    {{'\xeb', '\x9a', '\xb5'}, 3, 0xB6B5}, /* (HANGUL SYLLABLE DDUT) */
    {{'\xeb', '\x9a', '\xb6'}, 3, 0xB6B6}, /* (HANGUL SYLLABLE DDUP) */
    {{'\xeb', '\x9a', '\xb7'}, 3, 0xB6B7}, /* (HANGUL SYLLABLE DDUH) */
    {{'\xeb', '\x9a', '\xb8'}, 3, 0xB6B8}, /* (HANGUL SYLLABLE DDWEO) */
    {{'\xeb', '\x9a', '\xb9'}, 3, 0xB6B9}, /* (HANGUL SYLLABLE DDWEOG) */
    {{'\xeb', '\x9a', '\xba'}, 3, 0xB6BA}, /* (HANGUL SYLLABLE DDWEOGG) */
    {{'\xeb', '\x9a', '\xbb'}, 3, 0xB6BB}, /* (HANGUL SYLLABLE DDWEOGS) */
    {{'\xeb', '\x9a', '\xbc'}, 3, 0xB6BC}, /* (HANGUL SYLLABLE DDWEON) */
    {{'\xeb', '\x9a', '\xbd'}, 3, 0xB6BD}, /* (HANGUL SYLLABLE DDWEONJ) */
    {{'\xeb', '\x9a', '\xbe'}, 3, 0xB6BE}, /* (HANGUL SYLLABLE DDWEONH) */
    {{'\xeb', '\x9a', '\xbf'}, 3, 0xB6BF}, /* (HANGUL SYLLABLE DDWEOD) */
    {{'\xeb', '\x9b', '\x80'}, 3, 0xB6C0}, /* (HANGUL SYLLABLE DDWEOL) */
    {{'\xeb', '\x9b', '\x81'}, 3, 0xB6C1}, /* (HANGUL SYLLABLE DDWEOLG) */
    {{'\xeb', '\x9b', '\x82'}, 3, 0xB6C2}, /* (HANGUL SYLLABLE DDWEOLM) */
    {{'\xeb', '\x9b', '\x83'}, 3, 0xB6C3}, /* (HANGUL SYLLABLE DDWEOLB) */
    {{'\xeb', '\x9b', '\x84'}, 3, 0xB6C4}, /* (HANGUL SYLLABLE DDWEOLS) */
    {{'\xeb', '\x9b', '\x85'}, 3, 0xB6C5}, /* (HANGUL SYLLABLE DDWEOLT) */
    {{'\xeb', '\x9b', '\x86'}, 3, 0xB6C6}, /* (HANGUL SYLLABLE DDWEOLP) */
    {{'\xeb', '\x9b', '\x87'}, 3, 0xB6C7}, /* (HANGUL SYLLABLE DDWEOLH) */
    {{'\xeb', '\x9b', '\x88'}, 3, 0xB6C8}, /* (HANGUL SYLLABLE DDWEOM) */
    {{'\xeb', '\x9b', '\x89'}, 3, 0xB6C9}, /* (HANGUL SYLLABLE DDWEOB) */
    {{'\xeb', '\x9b', '\x8a'}, 3, 0xB6CA}, /* (HANGUL SYLLABLE DDWEOBS) */
    {{'\xeb', '\x9b', '\x8b'}, 3, 0xB6CB}, /* (HANGUL SYLLABLE DDWEOS) */
    {{'\xeb', '\x9b', '\x8c'}, 3, 0xB6CC}, /* (HANGUL SYLLABLE DDWEOSS) */
    {{'\xeb', '\x9b', '\x8d'}, 3, 0xB6CD}, /* (HANGUL SYLLABLE DDWEONG) */
    {{'\xeb', '\x9b', '\x8e'}, 3, 0xB6CE}, /* (HANGUL SYLLABLE DDWEOJ) */
    {{'\xeb', '\x9b', '\x8f'}, 3, 0xB6CF}, /* (HANGUL SYLLABLE DDWEOC) */
    {{'\xeb', '\x9b', '\x90'}, 3, 0xB6D0}, /* (HANGUL SYLLABLE DDWEOK) */
    {{'\xeb', '\x9b', '\x91'}, 3, 0xB6D1}, /* (HANGUL SYLLABLE DDWEOT) */
    {{'\xeb', '\x9b', '\x92'}, 3, 0xB6D2}, /* (HANGUL SYLLABLE DDWEOP) */
    {{'\xeb', '\x9b', '\x93'}, 3, 0xB6D3}, /* (HANGUL SYLLABLE DDWEOH) */
    {{'\xeb', '\x9b', '\x95'}, 3, 0xB6D5}, /* (HANGUL SYLLABLE DDWEG) */
    {{'\xeb', '\x9b', '\x96'}, 3, 0xB6D6}, /* (HANGUL SYLLABLE DDWEGG) */
    {{'\xeb', '\x9b', '\x97'}, 3, 0xB6D7}, /* (HANGUL SYLLABLE DDWEGS) */
    {{'\xeb', '\x9b', '\x98'}, 3, 0xB6D8}, /* (HANGUL SYLLABLE DDWEN) */
    {{'\xeb', '\x9b', '\x99'}, 3, 0xB6D9}, /* (HANGUL SYLLABLE DDWENJ) */
    {{'\xeb', '\x9b', '\x9a'}, 3, 0xB6DA}, /* (HANGUL SYLLABLE DDWENH) */
    {{'\xeb', '\x9b', '\x9b'}, 3, 0xB6DB}, /* (HANGUL SYLLABLE DDWED) */
    {{'\xeb', '\x9b', '\x9c'}, 3, 0xB6DC}, /* (HANGUL SYLLABLE DDWEL) */
    {{'\xeb', '\x9b', '\x9d'}, 3, 0xB6DD}, /* (HANGUL SYLLABLE DDWELG) */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{'\xeb', '\x9b', '\x9e'}, 3, 0xB6DE}, /* (HANGUL SYLLABLE DDWELM) */
    {{'\xeb', '\x9b', '\x9f'}, 3, 0xB6DF}, /* (HANGUL SYLLABLE DDWELB) */
    {{'\xeb', '\x9b', '\xa0'}, 3, 0xB6E0}, /* (HANGUL SYLLABLE DDWELS) */
    {{'\xeb', '\x9b', '\xa1'}, 3, 0xB6E1}, /* (HANGUL SYLLABLE DDWELT) */
    {{'\xeb', '\x9b', '\xa2'}, 3, 0xB6E2}, /* (HANGUL SYLLABLE DDWELP) */
    {{'\xeb', '\x9b', '\xa3'}, 3, 0xB6E3}, /* (HANGUL SYLLABLE DDWELH) */
    {{'\xeb', '\x9b', '\xa4'}, 3, 0xB6E4}, /* (HANGUL SYLLABLE DDWEM) */
    {{'\xeb', '\x9b', '\xa5'}, 3, 0xB6E5}, /* (HANGUL SYLLABLE DDWEB) */
    {{'\xeb', '\x9b', '\xa6'}, 3, 0xB6E6}, /* (HANGUL SYLLABLE DDWEBS) */
    {{'\xeb', '\x9b', '\xa7'}, 3, 0xB6E7}, /* (HANGUL SYLLABLE DDWES) */
    {{'\xeb', '\x9b', '\xa8'}, 3, 0xB6E8}, /* (HANGUL SYLLABLE DDWESS) */
    {{'\xeb', '\x9b', '\xa9'}, 3, 0xB6E9}, /* (HANGUL SYLLABLE DDWENG) */
    {{'\xeb', '\x9b', '\xaa'}, 3, 0xB6EA}, /* (HANGUL SYLLABLE DDWEJ) */
    {{'\xeb', '\x9b', '\xab'}, 3, 0xB6EB}, /* (HANGUL SYLLABLE DDWEC) */
    {{'\xeb', '\x9b', '\xac'}, 3, 0xB6EC}, /* (HANGUL SYLLABLE DDWEK) */
    {{'\xeb', '\x9b', '\xad'}, 3, 0xB6ED}, /* (HANGUL SYLLABLE DDWET) */
    {{'\xeb', '\x9b', '\xae'}, 3, 0xB6EE}, /* (HANGUL SYLLABLE DDWEP) */
    {{'\xeb', '\x9b', '\xaf'}, 3, 0xB6EF}, /* (HANGUL SYLLABLE DDWEH) */
    {{'\xeb', '\x9b', '\xb1'}, 3, 0xB6F1}, /* (HANGUL SYLLABLE DDWIG) */
    {{'\xeb', '\x9b', '\xb2'}, 3, 0xB6F2}, /* (HANGUL SYLLABLE DDWIGG) */
    {{'\xeb', '\x9b', '\xb3'}, 3, 0xB6F3}, /* (HANGUL SYLLABLE DDWIGS) */
    {{'\xeb', '\x9b', '\xb5'}, 3, 0xB6F5}, /* (HANGUL SYLLABLE DDWINJ) */
    {{'\xeb', '\x9b', '\xb6'}, 3, 0xB6F6}, /* (HANGUL SYLLABLE DDWINH) */
    {{'\xeb', '\x9b', '\xb7'}, 3, 0xB6F7}, /* (HANGUL SYLLABLE DDWID) */
    {{'\xeb', '\x9b', '\xb9'}, 3, 0xB6F9}, /* (HANGUL SYLLABLE DDWILG) */
    {{'\xeb', '\x9b', '\xba'}, 3, 0xB6FA}, /* (HANGUL SYLLABLE DDWILM) */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{'\xeb', '\x9b', '\xbb'}, 3, 0xB6FB}, /* (HANGUL SYLLABLE DDWILB) */
    {{'\xeb', '\x9b', '\xbc'}, 3, 0xB6FC}, /* (HANGUL SYLLABLE DDWILS) */
    {{'\xeb', '\x9b', '\xbd'}, 3, 0xB6FD}, /* (HANGUL SYLLABLE DDWILT) */
    {{'\xeb', '\x9b', '\xbe'}, 3, 0xB6FE}, /* (HANGUL SYLLABLE DDWILP) */
    {{'\xeb', '\x9b', '\xbf'}, 3, 0xB6FF}, /* (HANGUL SYLLABLE DDWILH) */
    {{'\xeb', '\x9c', '\x82'}, 3, 0xB702}, /* (HANGUL SYLLABLE DDWIBS) */
    {{'\xeb', '\x9c', '\x83'}, 3, 0xB703}, /* (HANGUL SYLLABLE DDWIS) */
    {{'\xeb', '\x9c', '\x84'}, 3, 0xB704}, /* (HANGUL SYLLABLE DDWISS) */
    {{'\xeb', '\x9c', '\x86'}, 3, 0xB706}, /* (HANGUL SYLLABLE DDWIJ) */
    {{'\xeb', '\x9c', '\x87'}, 3, 0xB707}, /* (HANGUL SYLLABLE DDWIC) */
    {{'\xeb', '\x9c', '\x88'}, 3, 0xB708}, /* (HANGUL SYLLABLE DDWIK) */
    {{'\xeb', '\x9c', '\x89'}, 3, 0xB709}, /* (HANGUL SYLLABLE DDWIT) */
    {{'\xeb', '\x9c', '\x8a'}, 3, 0xB70A}, /* (HANGUL SYLLABLE DDWIP) */
    {{'\xeb', '\x9c', '\x8b'}, 3, 0xB70B}, /* (HANGUL SYLLABLE DDWIH) */
    {{'\xeb', '\x9c', '\x8c'}, 3, 0xB70C}, /* (HANGUL SYLLABLE DDYU) */
    {{'\xeb', '\x9c', '\x8d'}, 3, 0xB70D}, /* (HANGUL SYLLABLE DDYUG) */
    {{'\xeb', '\x9c', '\x8e'}, 3, 0xB70E}, /* (HANGUL SYLLABLE DDYUGG) */
    {{'\xeb', '\x9c', '\x8f'}, 3, 0xB70F}, /* (HANGUL SYLLABLE DDYUGS) */
    {{'\xeb', '\x9c', '\x90'}, 3, 0xB710}, /* (HANGUL SYLLABLE DDYUN) */
    {{'\xeb', '\x9c', '\x91'}, 3, 0xB711}, /* (HANGUL SYLLABLE DDYUNJ) */
    {{'\xeb', '\x9c', '\x92'}, 3, 0xB712}, /* (HANGUL SYLLABLE DDYUNH) */
    {{'\xeb', '\x9c', '\x93'}, 3, 0xB713}, /* (HANGUL SYLLABLE DDYUD) */
    {{'\xeb', '\x9c', '\x94'}, 3, 0xB714}, /* (HANGUL SYLLABLE DDYUL) */
    {{'\xeb', '\x9c', '\x95'}, 3, 0xB715}, /* (HANGUL SYLLABLE DDYULG) */
    {{'\xeb', '\x9c', '\x96'}, 3, 0xB716}, /* (HANGUL SYLLABLE DDYULM) */
    {{'\xeb', '\x9c', '\x97'}, 3, 0xB717}, /* (HANGUL SYLLABLE DDYULB) */
    {{'\xeb', '\x9c', '\x98'}, 3, 0xB718}, /* (HANGUL SYLLABLE DDYULS) */
    {{'\xeb', '\x9c', '\x99'}, 3, 0xB719}, /* (HANGUL SYLLABLE DDYULT) */
    {{'\xeb', '\x9c', '\x9a'}, 3, 0xB71A}, /* (HANGUL SYLLABLE DDYULP) */
    {{'\xeb', '\x9c', '\x9b'}, 3, 0xB71B}, /* (HANGUL SYLLABLE DDYULH) */
    {{'\xeb', '\x9c', '\x9c'}, 3, 0xB71C}, /* (HANGUL SYLLABLE DDYUM) */
    {{'\xeb', '\x9c', '\x9d'}, 3, 0xB71D}, /* (HANGUL SYLLABLE DDYUB) */
    {{'\xeb', '\x9c', '\x9e'}, 3, 0xB71E}, /* (HANGUL SYLLABLE DDYUBS) */
    {{'\xeb', '\x9c', '\x9f'}, 3, 0xB71F}, /* (HANGUL SYLLABLE DDYUS) */
    {{'\xeb', '\x9c', '\xa0'}, 3, 0xB720}, /* (HANGUL SYLLABLE DDYUSS) */
    {{'\xeb', '\x9c', '\xa1'}, 3, 0xB721}, /* (HANGUL SYLLABLE DDYUNG) */
    {{'\xeb', '\x9c', '\xa2'}, 3, 0xB722}, /* (HANGUL SYLLABLE DDYUJ) */
    {{'\xeb', '\x9c', '\xa3'}, 3, 0xB723}, /* (HANGUL SYLLABLE DDYUC) */
    {{'\xeb', '\x9c', '\xa4'}, 3, 0xB724}, /* (HANGUL SYLLABLE DDYUK) */
    {{'\xeb', '\x9c', '\xa5'}, 3, 0xB725}, /* (HANGUL SYLLABLE DDYUT) */
    {{'\xeb', '\x9c', '\xa6'}, 3, 0xB726}, /* (HANGUL SYLLABLE DDYUP) */
    {{'\xeb', '\x9c', '\xa7'}, 3, 0xB727}, /* (HANGUL SYLLABLE DDYUH) */
    {{'\xeb', '\x9c', '\xaa'}, 3, 0xB72A}, /* (HANGUL SYLLABLE DDEUGG) */
    {{'\xeb', '\x9c', '\xab'}, 3, 0xB72B}, /* (HANGUL SYLLABLE DDEUGS) */
    {{'\xeb', '\x9c', '\xad'}, 3, 0xB72D}, /* (HANGUL SYLLABLE DDEUNJ) */
    {{'\xeb', '\x9c', '\xae'}, 3, 0xB72E}, /* (HANGUL SYLLABLE DDEUNH) */
    {{'\xeb', '\x9c', '\xb1'}, 3, 0xB731}, /* (HANGUL SYLLABLE DDEULG) */
    {{'\xeb', '\x9c', '\xb2'}, 3, 0xB732}, /* (HANGUL SYLLABLE DDEULM) */
    {{'\xeb', '\x9c', '\xb3'}, 3, 0xB733}, /* (HANGUL SYLLABLE DDEULB) */
    {{'\xeb', '\x9c', '\xb4'}, 3, 0xB734}, /* (HANGUL SYLLABLE DDEULS) */
    {{'\xeb', '\x9c', '\xb5'}, 3, 0xB735}, /* (HANGUL SYLLABLE DDEULT) */
    {{'\xeb', '\x9c', '\xb6'}, 3, 0xB736}, /* (HANGUL SYLLABLE DDEULP) */
    {{'\xeb', '\x9c', '\xb7'}, 3, 0xB737}, /* (HANGUL SYLLABLE DDEULH) */
    {{'\xeb', '\x9c', '\xba'}, 3, 0xB73A}, /* (HANGUL SYLLABLE DDEUBS) */
    {{'\xeb', '\x9c', '\xbc'}, 3, 0xB73C}, /* (HANGUL SYLLABLE DDEUSS) */
    {{'\xeb', '\x9c', '\xbd'}, 3, 0xB73D}, /* (HANGUL SYLLABLE DDEUNG) */
    {{'\xeb', '\x9c', '\xbe'}, 3, 0xB73E}, /* (HANGUL SYLLABLE DDEUJ) */
    {{'\xeb', '\x9c', '\xbf'}, 3, 0xB73F}, /* (HANGUL SYLLABLE DDEUC) */
    {{'\xeb', '\x9d', '\x80'}, 3, 0xB740}, /* (HANGUL SYLLABLE DDEUK) */
    {{'\xeb', '\x9d', '\x81'}, 3, 0xB741}, /* (HANGUL SYLLABLE DDEUT) */
    {{'\xeb', '\x9d', '\x82'}, 3, 0xB742}, /* (HANGUL SYLLABLE DDEUP) */
    {{'\xeb', '\x9d', '\x83'}, 3, 0xB743}, /* (HANGUL SYLLABLE DDEUH) */
    {{'\xeb', '\x9d', '\x85'}, 3, 0xB745}, /* (HANGUL SYLLABLE DDYIG) */
    {{'\xeb', '\x9d', '\x86'}, 3, 0xB746}, /* (HANGUL SYLLABLE DDYIGG) */
    {{'\xeb', '\x9d', '\x87'}, 3, 0xB747}, /* (HANGUL SYLLABLE DDYIGS) */
    {{'\xeb', '\x9d', '\x89'}, 3, 0xB749}, /* (HANGUL SYLLABLE DDYINJ) */
    {{'\xeb', '\x9d', '\x8a'}, 3, 0xB74A}, /* (HANGUL SYLLABLE DDYINH) */
    {{'\xeb', '\x9d', '\x8b'}, 3, 0xB74B}, /* (HANGUL SYLLABLE DDYID) */
    {{'\xeb', '\x9d', '\x8d'}, 3, 0xB74D}, /* (HANGUL SYLLABLE DDYILG) */
    {{'\xeb', '\x9d', '\x8e'}, 3, 0xB74E}, /* (HANGUL SYLLABLE DDYILM) */
    {{'\xeb', '\x9d', '\x8f'}, 3, 0xB74F}, /* (HANGUL SYLLABLE DDYILB) */
    {{'\xeb', '\x9d', '\x90'}, 3, 0xB750}, /* (HANGUL SYLLABLE DDYILS) */
    {{'\xeb', '\x9d', '\x91'}, 3, 0xB751}, /* (HANGUL SYLLABLE DDYILT) */
    {{'\xeb', '\x9d', '\x92'}, 3, 0xB752}, /* (HANGUL SYLLABLE DDYILP) */
    {{'\xeb', '\x9d', '\x93'}, 3, 0xB753}, /* (HANGUL SYLLABLE DDYILH) */
    {{'\xeb', '\x9d', '\x96'}, 3, 0xB756}, /* (HANGUL SYLLABLE DDYIBS) */
    {{'\xeb', '\x9d', '\x97'}, 3, 0xB757}, /* (HANGUL SYLLABLE DDYIS) */
    {{'\xeb', '\x9d', '\x98'}, 3, 0xB758}, /* (HANGUL SYLLABLE DDYISS) */
    {{'\xeb', '\x9d', '\x99'}, 3, 0xB759}, /* (HANGUL SYLLABLE DDYING) */
    {{'\xeb', '\x9d', '\x9a'}, 3, 0xB75A}, /* (HANGUL SYLLABLE DDYIJ) */
    {{'\xeb', '\x9d', '\x9b'}, 3, 0xB75B}, /* (HANGUL SYLLABLE DDYIC) */
    {{'\xeb', '\x9d', '\x9c'}, 3, 0xB75C}, /* (HANGUL SYLLABLE DDYIK) */
    {{'\xeb', '\x9d', '\x9d'}, 3, 0xB75D}, /* (HANGUL SYLLABLE DDYIT) */
    {{'\xeb', '\x9d', '\x9e'}, 3, 0xB75E}, /* (HANGUL SYLLABLE DDYIP) */
    {{'\xeb', '\x9d', '\x9f'}, 3, 0xB75F}, /* (HANGUL SYLLABLE DDYIH) */
    {{'\xeb', '\x9d', '\xa1'}, 3, 0xB761}, /* (HANGUL SYLLABLE DDIG) */
    {{'\xeb', '\x9d', '\xa2'}, 3, 0xB762}, /* (HANGUL SYLLABLE DDIGG) */
    {{'\xeb', '\x9d', '\xa3'}, 3, 0xB763}, /* (HANGUL SYLLABLE DDIGS) */
    {{'\xeb', '\x9d', '\xa5'}, 3, 0xB765}, /* (HANGUL SYLLABLE DDINJ) */
    {{'\xeb', '\x9d', '\xa6'}, 3, 0xB766}, /* (HANGUL SYLLABLE DDINH) */
    {{'\xeb', '\x9d', '\xa7'}, 3, 0xB767}, /* (HANGUL SYLLABLE DDID) */
    {{'\xeb', '\x9d', '\xa9'}, 3, 0xB769}, /* (HANGUL SYLLABLE DDILG) */
    {{'\xeb', '\x9d', '\xaa'}, 3, 0xB76A}, /* (HANGUL SYLLABLE DDILM) */
    {{'\xeb', '\x9d', '\xab'}, 3, 0xB76B}, /* (HANGUL SYLLABLE DDILB) */
    {{'\xeb', '\x9d', '\xac'}, 3, 0xB76C}, /* (HANGUL SYLLABLE DDILS) */
    {{'\xeb', '\x9d', '\xad'}, 3, 0xB76D}, /* (HANGUL SYLLABLE DDILT) */
    {{'\xeb', '\x9d', '\xae'}, 3, 0xB76E}, /* (HANGUL SYLLABLE DDILP) */
    {{'\xeb', '\x9d', '\xaf'}, 3, 0xB76F}, /* (HANGUL SYLLABLE DDILH) */
    {{'\xeb', '\x9d', '\xb2'}, 3, 0xB772}, /* (HANGUL SYLLABLE DDIBS) */
    {{'\xeb', '\x9d', '\xb4'}, 3, 0xB774}, /* (HANGUL SYLLABLE DDISS) */
    {{'\xeb', '\x9d', '\xb6'}, 3, 0xB776}, /* (HANGUL SYLLABLE DDIJ) */
    {{'\xeb', '\x9d', '\xb7'}, 3, 0xB777}, /* (HANGUL SYLLABLE DDIC) */
    {{'\xeb', '\x9d', '\xb8'}, 3, 0xB778}, /* (HANGUL SYLLABLE DDIK) */
    {{'\xeb', '\x9d', '\xb9'}, 3, 0xB779}, /* (HANGUL SYLLABLE DDIT) */
    {{'\xeb', '\x9d', '\xba'}, 3, 0xB77A}, /* (HANGUL SYLLABLE DDIP) */
    {{'\xeb', '\x9d', '\xbb'}, 3, 0xB77B}, /* (HANGUL SYLLABLE DDIH) */
    {{'\xeb', '\x9d', '\xbe'}, 3, 0xB77E}, /* (HANGUL SYLLABLE RAGG) */
    {{'\xeb', '\x9d', '\xbf'}, 3, 0xB77F}, /* (HANGUL SYLLABLE RAGS) */
    {{'\xeb', '\x9e', '\x81'}, 3, 0xB781}, /* (HANGUL SYLLABLE RANJ) */
    {{'\xeb', '\x9e', '\x82'}, 3, 0xB782}, /* (HANGUL SYLLABLE RANH) */
    {{'\xeb', '\x9e', '\x83'}, 3, 0xB783}, /* (HANGUL SYLLABLE RAD) */
    {{'\xeb', '\x9e', '\x85'}, 3, 0xB785}, /* (HANGUL SYLLABLE RALG) */
    {{'\xeb', '\x9e', '\x86'}, 3, 0xB786}, /* (HANGUL SYLLABLE RALM) */
    {{'\xeb', '\x9e', '\x87'}, 3, 0xB787}, /* (HANGUL SYLLABLE RALB) */
    {{'\xeb', '\x9e', '\x88'}, 3, 0xB788}, /* (HANGUL SYLLABLE RALS) */
    {{'\xeb', '\x9e', '\x89'}, 3, 0xB789}, /* (HANGUL SYLLABLE RALT) */
    {{'\xeb', '\x9e', '\x8a'}, 3, 0xB78A}, /* (HANGUL SYLLABLE RALP) */
    {{'\xeb', '\x9e', '\x8b'}, 3, 0xB78B}, /* (HANGUL SYLLABLE RALH) */
    {{'\xeb', '\x9e', '\x8e'}, 3, 0xB78E}, /* (HANGUL SYLLABLE RABS) */
    {{'\xeb', '\x9e', '\x93'}, 3, 0xB793}, /* (HANGUL SYLLABLE RAC) */
    {{'\xeb', '\x9e', '\x94'}, 3, 0xB794}, /* (HANGUL SYLLABLE RAK) */
    {{'\xeb', '\x9e', '\x95'}, 3, 0xB795}, /* (HANGUL SYLLABLE RAT) */
    {{'\xeb', '\x9e', '\x9a'}, 3, 0xB79A}, /* (HANGUL SYLLABLE RAEGG) */
    {{'\xeb', '\x9e', '\x9b'}, 3, 0xB79B}, /* (HANGUL SYLLABLE RAEGS) */
    {{'\xeb', '\x9e', '\x9d'}, 3, 0xB79D}, /* (HANGUL SYLLABLE RAENJ) */
    {{'\xeb', '\x9e', '\x9e'}, 3, 0xB79E}, /* (HANGUL SYLLABLE RAENH) */
    {{'\xeb', '\x9e', '\x9f'}, 3, 0xB79F}, /* (HANGUL SYLLABLE RAED) */
    {{'\xeb', '\x9e', '\xa1'}, 3, 0xB7A1}, /* (HANGUL SYLLABLE RAELG) */
    {{'\xeb', '\x9e', '\xa2'}, 3, 0xB7A2}, /* (HANGUL SYLLABLE RAELM) */
    {{'\xeb', '\x9e', '\xa3'}, 3, 0xB7A3}, /* (HANGUL SYLLABLE RAELB) */
    {{'\xeb', '\x9e', '\xa4'}, 3, 0xB7A4}, /* (HANGUL SYLLABLE RAELS) */
    {{'\xeb', '\x9e', '\xa5'}, 3, 0xB7A5}, /* (HANGUL SYLLABLE RAELT) */
    {{'\xeb', '\x9e', '\xa6'}, 3, 0xB7A6}, /* (HANGUL SYLLABLE RAELP) */
    {{'\xeb', '\x9e', '\xa7'}, 3, 0xB7A7}, /* (HANGUL SYLLABLE RAELH) */
    {{'\xeb', '\x9e', '\xaa'}, 3, 0xB7AA}, /* (HANGUL SYLLABLE RAEBS) */
    {{'\xeb', '\x9e', '\xae'}, 3, 0xB7AE}, /* (HANGUL SYLLABLE RAEJ) */
    {{'\xeb', '\x9e', '\xaf'}, 3, 0xB7AF}, /* (HANGUL SYLLABLE RAEC) */
    {{'\xeb', '\x9e', '\xb0'}, 3, 0xB7B0}, /* (HANGUL SYLLABLE RAEK) */
    {{'\xeb', '\x9e', '\xb1'}, 3, 0xB7B1}, /* (HANGUL SYLLABLE RAET) */
    {{'\xeb', '\x9e', '\xb2'}, 3, 0xB7B2}, /* (HANGUL SYLLABLE RAEP) */
    {{'\xeb', '\x9e', '\xb3'}, 3, 0xB7B3}, /* (HANGUL SYLLABLE RAEH) */
    {{'\xeb', '\x9e', '\xb6'}, 3, 0xB7B6}, /* (HANGUL SYLLABLE RYAGG) */
    {{'\xeb', '\x9e', '\xb7'}, 3, 0xB7B7}, /* (HANGUL SYLLABLE RYAGS) */
    {{'\xeb', '\x9e', '\xb9'}, 3, 0xB7B9}, /* (HANGUL SYLLABLE RYANJ) */
    {{'\xeb', '\x9e', '\xba'}, 3, 0xB7BA}, /* (HANGUL SYLLABLE RYANH) */
    {{'\xeb', '\x9e', '\xbb'}, 3, 0xB7BB}, /* (HANGUL SYLLABLE RYAD) */
    {{'\xeb', '\x9e', '\xbc'}, 3, 0xB7BC}, /* (HANGUL SYLLABLE RYAL) */
    {{'\xeb', '\x9e', '\xbd'}, 3, 0xB7BD}, /* (HANGUL SYLLABLE RYALG) */
    {{'\xeb', '\x9e', '\xbe'}, 3, 0xB7BE}, /* (HANGUL SYLLABLE RYALM) */
    {{'\xeb', '\x9e', '\xbf'}, 3, 0xB7BF}, /* (HANGUL SYLLABLE RYALB) */
    {{'\xeb', '\x9f', '\x80'}, 3, 0xB7C0}, /* (HANGUL SYLLABLE RYALS) */
    {{'\xeb', '\x9f', '\x81'}, 3, 0xB7C1}, /* (HANGUL SYLLABLE RYALT) */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{'\xeb', '\x9f', '\x82'}, 3, 0xB7C2}, /* (HANGUL SYLLABLE RYALP) */
    {{'\xeb', '\x9f', '\x83'}, 3, 0xB7C3}, /* (HANGUL SYLLABLE RYALH) */
    {{'\xeb', '\x9f', '\x84'}, 3, 0xB7C4}, /* (HANGUL SYLLABLE RYAM) */
    {{'\xeb', '\x9f', '\x85'}, 3, 0xB7C5}, /* (HANGUL SYLLABLE RYAB) */
    {{'\xeb', '\x9f', '\x86'}, 3, 0xB7C6}, /* (HANGUL SYLLABLE RYABS) */
    {{'\xeb', '\x9f', '\x88'}, 3, 0xB7C8}, /* (HANGUL SYLLABLE RYASS) */
    {{'\xeb', '\x9f', '\x8a'}, 3, 0xB7CA}, /* (HANGUL SYLLABLE RYAJ) */
    {{'\xeb', '\x9f', '\x8b'}, 3, 0xB7CB}, /* (HANGUL SYLLABLE RYAC) */
    {{'\xeb', '\x9f', '\x8c'}, 3, 0xB7CC}, /* (HANGUL SYLLABLE RYAK) */
    {{'\xeb', '\x9f', '\x8d'}, 3, 0xB7CD}, /* (HANGUL SYLLABLE RYAT) */
    {{'\xeb', '\x9f', '\x8e'}, 3, 0xB7CE}, /* (HANGUL SYLLABLE RYAP) */
    {{'\xeb', '\x9f', '\x8f'}, 3, 0xB7CF}, /* (HANGUL SYLLABLE RYAH) */
    {{'\xeb', '\x9f', '\x90'}, 3, 0xB7D0}, /* (HANGUL SYLLABLE RYAE) */
    {{'\xeb', '\x9f', '\x91'}, 3, 0xB7D1}, /* (HANGUL SYLLABLE RYAEG) */
    {{'\xeb', '\x9f', '\x92'}, 3, 0xB7D2}, /* (HANGUL SYLLABLE RYAEGG) */
    {{'\xeb', '\x9f', '\x93'}, 3, 0xB7D3}, /* (HANGUL SYLLABLE RYAEGS) */
    {{'\xeb', '\x9f', '\x94'}, 3, 0xB7D4}, /* (HANGUL SYLLABLE RYAEN) */
    {{'\xeb', '\x9f', '\x95'}, 3, 0xB7D5}, /* (HANGUL SYLLABLE RYAENJ) */
    {{'\xeb', '\x9f', '\x96'}, 3, 0xB7D6}, /* (HANGUL SYLLABLE RYAENH) */
    {{'\xeb', '\x9f', '\x97'}, 3, 0xB7D7}, /* (HANGUL SYLLABLE RYAED) */
    {{'\xeb', '\x9f', '\x98'}, 3, 0xB7D8}, /* (HANGUL SYLLABLE RYAEL) */
    {{'\xeb', '\x9f', '\x99'}, 3, 0xB7D9}, /* (HANGUL SYLLABLE RYAELG) */
    {{'\xeb', '\x9f', '\x9a'}, 3, 0xB7DA}, /* (HANGUL SYLLABLE RYAELM) */
    {{'\xeb', '\x9f', '\x9b'}, 3, 0xB7DB}, /* (HANGUL SYLLABLE RYAELB) */
    {{'\xeb', '\x9f', '\x9c'}, 3, 0xB7DC}, /* (HANGUL SYLLABLE RYAELS) */
    {{'\xeb', '\x9f', '\x9d'}, 3, 0xB7DD}, /* (HANGUL SYLLABLE RYAELT) */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{'\xeb', '\x9f', '\x9e'}, 3, 0xB7DE}, /* (HANGUL SYLLABLE RYAELP) */
    {{'\xeb', '\x9f', '\x9f'}, 3, 0xB7DF}, /* (HANGUL SYLLABLE RYAELH) */
    {{'\xeb', '\x9f', '\xa0'}, 3, 0xB7E0}, /* (HANGUL SYLLABLE RYAEM) */
    {{'\xeb', '\x9f', '\xa1'}, 3, 0xB7E1}, /* (HANGUL SYLLABLE RYAEB) */
    {{'\xeb', '\x9f', '\xa2'}, 3, 0xB7E2}, /* (HANGUL SYLLABLE RYAEBS) */
    {{'\xeb', '\x9f', '\xa3'}, 3, 0xB7E3}, /* (HANGUL SYLLABLE RYAES) */
    {{'\xeb', '\x9f', '\xa4'}, 3, 0xB7E4}, /* (HANGUL SYLLABLE RYAESS) */
    {{'\xeb', '\x9f', '\xa5'}, 3, 0xB7E5}, /* (HANGUL SYLLABLE RYAENG) */
    {{'\xeb', '\x9f', '\xa6'}, 3, 0xB7E6}, /* (HANGUL SYLLABLE RYAEJ) */
    {{'\xeb', '\x9f', '\xa7'}, 3, 0xB7E7}, /* (HANGUL SYLLABLE RYAEC) */
    {{'\xeb', '\x9f', '\xa8'}, 3, 0xB7E8}, /* (HANGUL SYLLABLE RYAEK) */
    {{'\xeb', '\x9f', '\xa9'}, 3, 0xB7E9}, /* (HANGUL SYLLABLE RYAET) */
    {{'\xeb', '\x9f', '\xaa'}, 3, 0xB7EA}, /* (HANGUL SYLLABLE RYAEP) */
    {{'\xeb', '\x9f', '\xab'}, 3, 0xB7EB}, /* (HANGUL SYLLABLE RYAEH) */
    {{'\xeb', '\x9f', '\xae'}, 3, 0xB7EE}, /* (HANGUL SYLLABLE REOGG) */
    {{'\xeb', '\x9f', '\xaf'}, 3, 0xB7EF}, /* (HANGUL SYLLABLE REOGS) */
    {{'\xeb', '\x9f', '\xb1'}, 3, 0xB7F1}, /* (HANGUL SYLLABLE REONJ) */
    {{'\xeb', '\x9f', '\xb2'}, 3, 0xB7F2}, /* (HANGUL SYLLABLE REONH) */
    {{'\xeb', '\x9f', '\xb3'}, 3, 0xB7F3}, /* (HANGUL SYLLABLE REOD) */
    {{'\xeb', '\x9f', '\xb5'}, 3, 0xB7F5}, /* (HANGUL SYLLABLE REOLG) */
    {{'\xeb', '\x9f', '\xb6'}, 3, 0xB7F6}, /* (HANGUL SYLLABLE REOLM) */
    {{'\xeb', '\x9f', '\xb7'}, 3, 0xB7F7}, /* (HANGUL SYLLABLE REOLB) */
    {{'\xeb', '\x9f', '\xb8'}, 3, 0xB7F8}, /* (HANGUL SYLLABLE REOLS) */
    {{'\xeb', '\x9f', '\xb9'}, 3, 0xB7F9}, /* (HANGUL SYLLABLE REOLT) */
    {{'\xeb', '\x9f', '\xba'}, 3, 0xB7FA}, /* (HANGUL SYLLABLE REOLP) */
    {{'\xeb', '\x9f', '\xbb'}, 3, 0xB7FB}, /* (HANGUL SYLLABLE REOLH) */
    {{'\xeb', '\x9f', '\xbe'}, 3, 0xB7FE}, /* (HANGUL SYLLABLE REOBS) */
    {{'\xeb', '\xa0', '\x82'}, 3, 0xB802}, /* (HANGUL SYLLABLE REOJ) */
    {{'\xeb', '\xa0', '\x83'}, 3, 0xB803}, /* (HANGUL SYLLABLE REOC) */
    {{'\xeb', '\xa0', '\x84'}, 3, 0xB804}, /* (HANGUL SYLLABLE REOK) */
    {{'\xeb', '\xa0', '\x85'}, 3, 0xB805}, /* (HANGUL SYLLABLE REOT) */
    {{'\xeb', '\xa0', '\x86'}, 3, 0xB806}, /* (HANGUL SYLLABLE REOP) */
    {{'\xeb', '\xa0', '\x8a'}, 3, 0xB80A}, /* (HANGUL SYLLABLE REGG) */
    {{'\xeb', '\xa0', '\x8b'}, 3, 0xB80B}, /* (HANGUL SYLLABLE REGS) */
    {{'\xeb', '\xa0', '\x8d'}, 3, 0xB80D}, /* (HANGUL SYLLABLE RENJ) */
    {{'\xeb', '\xa0', '\x8e'}, 3, 0xB80E}, /* (HANGUL SYLLABLE RENH) */
    {{'\xeb', '\xa0', '\x8f'}, 3, 0xB80F}, /* (HANGUL SYLLABLE RED) */
    {{'\xeb', '\xa0', '\x91'}, 3, 0xB811}, /* (HANGUL SYLLABLE RELG) */
    {{'\xeb', '\xa0', '\x92'}, 3, 0xB812}, /* (HANGUL SYLLABLE RELM) */
    {{'\xeb', '\xa0', '\x93'}, 3, 0xB813}, /* (HANGUL SYLLABLE RELB) */
    {{'\xeb', '\xa0', '\x94'}, 3, 0xB814}, /* (HANGUL SYLLABLE RELS) */
    {{'\xeb', '\xa0', '\x95'}, 3, 0xB815}, /* (HANGUL SYLLABLE RELT) */
    {{'\xeb', '\xa0', '\x96'}, 3, 0xB816}, /* (HANGUL SYLLABLE RELP) */
    {{'\xeb', '\xa0', '\x97'}, 3, 0xB817}, /* (HANGUL SYLLABLE RELH) */
    {{'\xeb', '\xa0', '\x9a'}, 3, 0xB81A}, /* (HANGUL SYLLABLE REBS) */
    {{'\xeb', '\xa0', '\x9c'}, 3, 0xB81C}, /* (HANGUL SYLLABLE RESS) */
    {{'\xeb', '\xa0', '\x9e'}, 3, 0xB81E}, /* (HANGUL SYLLABLE REJ) */
    {{'\xeb', '\xa0', '\x9f'}, 3, 0xB81F}, /* (HANGUL SYLLABLE REC) */
    {{'\xeb', '\xa0', '\xa0'}, 3, 0xB820}, /* (HANGUL SYLLABLE REK) */
    {{'\xeb', '\xa0', '\xa1'}, 3, 0xB821}, /* (HANGUL SYLLABLE RET) */
    {{'\xeb', '\xa0', '\xa2'}, 3, 0xB822}, /* (HANGUL SYLLABLE REP) */
    {{'\xeb', '\xa0', '\xa3'}, 3, 0xB823}, /* (HANGUL SYLLABLE REH) */
    {{'\xeb', '\xa0', '\xa6'}, 3, 0xB826}, /* (HANGUL SYLLABLE RYEOGG) */
    {{'\xeb', '\xa0', '\xa7'}, 3, 0xB827}, /* (HANGUL SYLLABLE RYEOGS) */
    {{'\xeb', '\xa0', '\xa9'}, 3, 0xB829}, /* (HANGUL SYLLABLE RYEONJ) */
    {{'\xeb', '\xa0', '\xaa'}, 3, 0xB82A}, /* (HANGUL SYLLABLE RYEONH) */
    {{'\xeb', '\xa0', '\xab'}, 3, 0xB82B}, /* (HANGUL SYLLABLE RYEOD) */
    {{'\xeb', '\xa0', '\xad'}, 3, 0xB82D}, /* (HANGUL SYLLABLE RYEOLG) */
    {{'\xeb', '\xa0', '\xae'}, 3, 0xB82E}, /* (HANGUL SYLLABLE RYEOLM) */
    {{'\xeb', '\xa0', '\xaf'}, 3, 0xB82F}, /* (HANGUL SYLLABLE RYEOLB) */
    {{'\xeb', '\xa0', '\xb0'}, 3, 0xB830}, /* (HANGUL SYLLABLE RYEOLS) */
    {{'\xeb', '\xa0', '\xb1'}, 3, 0xB831}, /* (HANGUL SYLLABLE RYEOLT) */
    {{'\xeb', '\xa0', '\xb2'}, 3, 0xB832}, /* (HANGUL SYLLABLE RYEOLP) */
    {{'\xeb', '\xa0', '\xb3'}, 3, 0xB833}, /* (HANGUL SYLLABLE RYEOLH) */
    {{'\xeb', '\xa0', '\xb6'}, 3, 0xB836}, /* (HANGUL SYLLABLE RYEOBS) */
    {{'\xeb', '\xa0', '\xba'}, 3, 0xB83A}, /* (HANGUL SYLLABLE RYEOJ) */
    {{'\xeb', '\xa0', '\xbb'}, 3, 0xB83B}, /* (HANGUL SYLLABLE RYEOC) */
    {{'\xeb', '\xa0', '\xbc'}, 3, 0xB83C}, /* (HANGUL SYLLABLE RYEOK) */
    {{'\xeb', '\xa0', '\xbd'}, 3, 0xB83D}, /* (HANGUL SYLLABLE RYEOT) */
    {{'\xeb', '\xa0', '\xbe'}, 3, 0xB83E}, /* (HANGUL SYLLABLE RYEOP) */
    {{'\xeb', '\xa0', '\xbf'}, 3, 0xB83F}, /* (HANGUL SYLLABLE RYEOH) */
    {{'\xeb', '\xa1', '\x81'}, 3, 0xB841}, /* (HANGUL SYLLABLE RYEG) */
    {{'\xeb', '\xa1', '\x82'}, 3, 0xB842}, /* (HANGUL SYLLABLE RYEGG) */
    {{'\xeb', '\xa1', '\x83'}, 3, 0xB843}, /* (HANGUL SYLLABLE RYEGS) */
    {{'\xeb', '\xa1', '\x85'}, 3, 0xB845}, /* (HANGUL SYLLABLE RYENJ) */
    {{'\xeb', '\xa1', '\x86'}, 3, 0xB846}, /* (HANGUL SYLLABLE RYENH) */
    {{'\xeb', '\xa1', '\x87'}, 3, 0xB847}, /* (HANGUL SYLLABLE RYED) */
    {{'\xeb', '\xa1', '\x88'}, 3, 0xB848}, /* (HANGUL SYLLABLE RYEL) */
    {{'\xeb', '\xa1', '\x89'}, 3, 0xB849}, /* (HANGUL SYLLABLE RYELG) */
    {{'\xeb', '\xa1', '\x8a'}, 3, 0xB84A}, /* (HANGUL SYLLABLE RYELM) */
    {{'\xeb', '\xa1', '\x8b'}, 3, 0xB84B}, /* (HANGUL SYLLABLE RYELB) */
    {{'\xeb', '\xa1', '\x8c'}, 3, 0xB84C}, /* (HANGUL SYLLABLE RYELS) */
    {{'\xeb', '\xa1', '\x8d'}, 3, 0xB84D}, /* (HANGUL SYLLABLE RYELT) */
    {{'\xeb', '\xa1', '\x8e'}, 3, 0xB84E}, /* (HANGUL SYLLABLE RYELP) */
    {{'\xeb', '\xa1', '\x8f'}, 3, 0xB84F}, /* (HANGUL SYLLABLE RYELH) */
    {{'\xeb', '\xa1', '\x90'}, 3, 0xB850}, /* (HANGUL SYLLABLE RYEM) */
    {{'\xeb', '\xa1', '\x92'}, 3, 0xB852}, /* (HANGUL SYLLABLE RYEBS) */
    {{'\xeb', '\xa1', '\x94'}, 3, 0xB854}, /* (HANGUL SYLLABLE RYESS) */
    {{'\xeb', '\xa1', '\x95'}, 3, 0xB855}, /* (HANGUL SYLLABLE RYENG) */
    {{'\xeb', '\xa1', '\x96'}, 3, 0xB856}, /* (HANGUL SYLLABLE RYEJ) */
    {{'\xeb', '\xa1', '\x97'}, 3, 0xB857}, /* (HANGUL SYLLABLE RYEC) */
    {{'\xeb', '\xa1', '\x98'}, 3, 0xB858}, /* (HANGUL SYLLABLE RYEK) */
    {{'\xeb', '\xa1', '\x99'}, 3, 0xB859}, /* (HANGUL SYLLABLE RYET) */
    {{'\xeb', '\xa1', '\x9a'}, 3, 0xB85A}, /* (HANGUL SYLLABLE RYEP) */
    {{'\xeb', '\xa1', '\x9b'}, 3, 0xB85B}, /* (HANGUL SYLLABLE RYEH) */
    {{'\xeb', '\xa1', '\x9e'}, 3, 0xB85E}, /* (HANGUL SYLLABLE ROGG) */
    {{'\xeb', '\xa1', '\x9f'}, 3, 0xB85F}, /* (HANGUL SYLLABLE ROGS) */
    {{'\xeb', '\xa1', '\xa1'}, 3, 0xB861}, /* (HANGUL SYLLABLE RONJ) */
    {{'\xeb', '\xa1', '\xa2'}, 3, 0xB862}, /* (HANGUL SYLLABLE RONH) */
    {{'\xeb', '\xa1', '\xa3'}, 3, 0xB863}, /* (HANGUL SYLLABLE ROD) */
    {{'\xeb', '\xa1', '\xa5'}, 3, 0xB865}, /* (HANGUL SYLLABLE ROLG) */
    {{'\xeb', '\xa1', '\xa6'}, 3, 0xB866}, /* (HANGUL SYLLABLE ROLM) */
    {{'\xeb', '\xa1', '\xa7'}, 3, 0xB867}, /* (HANGUL SYLLABLE ROLB) */
    {{'\xeb', '\xa1', '\xa8'}, 3, 0xB868}, /* (HANGUL SYLLABLE ROLS) */
    {{'\xeb', '\xa1', '\xa9'}, 3, 0xB869}, /* (HANGUL SYLLABLE ROLT) */
    {{'\xeb', '\xa1', '\xaa'}, 3, 0xB86A}, /* (HANGUL SYLLABLE ROLP) */
    {{'\xeb', '\xa1', '\xab'}, 3, 0xB86B}, /* (HANGUL SYLLABLE ROLH) */
    {{'\xeb', '\xa1', '\xae'}, 3, 0xB86E}, /* (HANGUL SYLLABLE ROBS) */
    {{'\xeb', '\xa1', '\xb0'}, 3, 0xB870}, /* (HANGUL SYLLABLE ROSS) */
    {{'\xeb', '\xa1', '\xb2'}, 3, 0xB872}, /* (HANGUL SYLLABLE ROJ) */
    {{'\xeb', '\xa1', '\xb3'}, 3, 0xB873}, /* (HANGUL SYLLABLE ROC) */
    {{'\xeb', '\xa1', '\xb4'}, 3, 0xB874}, /* (HANGUL SYLLABLE ROK) */
    {{'\xeb', '\xa1', '\xb5'}, 3, 0xB875}, /* (HANGUL SYLLABLE ROT) */
    {{'\xeb', '\xa1', '\xb6'}, 3, 0xB876}, /* (HANGUL SYLLABLE ROP) */
    {{'\xeb', '\xa1', '\xb7'}, 3, 0xB877}, /* (HANGUL SYLLABLE ROH) */
    {{'\xeb', '\xa1', '\xb9'}, 3, 0xB879}, /* (HANGUL SYLLABLE RWAG) */
    {{'\xeb', '\xa1', '\xba'}, 3, 0xB87A}, /* (HANGUL SYLLABLE RWAGG) */
    {{'\xeb', '\xa1', '\xbb'}, 3, 0xB87B}, /* (HANGUL SYLLABLE RWAGS) */
    {{'\xeb', '\xa1', '\xbd'}, 3, 0xB87D}, /* (HANGUL SYLLABLE RWANJ) */
    {{'\xeb', '\xa1', '\xbe'}, 3, 0xB87E}, /* (HANGUL SYLLABLE RWANH) */
    {{'\xeb', '\xa1', '\xbf'}, 3, 0xB87F}, /* (HANGUL SYLLABLE RWAD) */
    {{'\xeb', '\xa2', '\x80'}, 3, 0xB880}, /* (HANGUL SYLLABLE RWAL) */
    {{'\xeb', '\xa2', '\x81'}, 3, 0xB881}, /* (HANGUL SYLLABLE RWALG) */
    {{'\xeb', '\xa2', '\x82'}, 3, 0xB882}, /* (HANGUL SYLLABLE RWALM) */
    {{'\xeb', '\xa2', '\x83'}, 3, 0xB883}, /* (HANGUL SYLLABLE RWALB) */
    {{'\xeb', '\xa2', '\x84'}, 3, 0xB884}, /* (HANGUL SYLLABLE RWALS) */
    {{'\xeb', '\xa2', '\x85'}, 3, 0xB885}, /* (HANGUL SYLLABLE RWALT) */
    {{'\xeb', '\xa2', '\x86'}, 3, 0xB886}, /* (HANGUL SYLLABLE RWALP) */
    {{'\xeb', '\xa2', '\x87'}, 3, 0xB887}, /* (HANGUL SYLLABLE RWALH) */
    {{'\xeb', '\xa2', '\x88'}, 3, 0xB888}, /* (HANGUL SYLLABLE RWAM) */
    {{'\xeb', '\xa2', '\x89'}, 3, 0xB889}, /* (HANGUL SYLLABLE RWAB) */
    {{'\xeb', '\xa2', '\x8a'}, 3, 0xB88A}, /* (HANGUL SYLLABLE RWABS) */
    {{'\xeb', '\xa2', '\x8b'}, 3, 0xB88B}, /* (HANGUL SYLLABLE RWAS) */
    {{'\xeb', '\xa2', '\x8c'}, 3, 0xB88C}, /* (HANGUL SYLLABLE RWASS) */
    {{'\xeb', '\xa2', '\x8e'}, 3, 0xB88E}, /* (HANGUL SYLLABLE RWAJ) */
    {{'\xeb', '\xa2', '\x8f'}, 3, 0xB88F}, /* (HANGUL SYLLABLE RWAC) */
    {{'\xeb', '\xa2', '\x90'}, 3, 0xB890}, /* (HANGUL SYLLABLE RWAK) */
    {{'\xeb', '\xa2', '\x91'}, 3, 0xB891}, /* (HANGUL SYLLABLE RWAT) */
    {{'\xeb', '\xa2', '\x92'}, 3, 0xB892}, /* (HANGUL SYLLABLE RWAP) */
    {{'\xeb', '\xa2', '\x93'}, 3, 0xB893}, /* (HANGUL SYLLABLE RWAH) */
    {{'\xeb', '\xa2', '\x94'}, 3, 0xB894}, /* (HANGUL SYLLABLE RWAE) */
    {{'\xeb', '\xa2', '\x95'}, 3, 0xB895}, /* (HANGUL SYLLABLE RWAEG) */
    {{'\xeb', '\xa2', '\x96'}, 3, 0xB896}, /* (HANGUL SYLLABLE RWAEGG) */
    {{'\xeb', '\xa2', '\x97'}, 3, 0xB897}, /* (HANGUL SYLLABLE RWAEGS) */
    {{'\xeb', '\xa2', '\x98'}, 3, 0xB898}, /* (HANGUL SYLLABLE RWAEN) */
    {{'\xeb', '\xa2', '\x99'}, 3, 0xB899}, /* (HANGUL SYLLABLE RWAENJ) */
    {{'\xeb', '\xa2', '\x9a'}, 3, 0xB89A}, /* (HANGUL SYLLABLE RWAENH) */
    {{'\xeb', '\xa2', '\x9b'}, 3, 0xB89B}, /* (HANGUL SYLLABLE RWAED) */
    {{'\xeb', '\xa2', '\x9c'}, 3, 0xB89C}, /* (HANGUL SYLLABLE RWAEL) */
    {{'\xeb', '\xa2', '\x9d'}, 3, 0xB89D}, /* (HANGUL SYLLABLE RWAELG) */
    {{'\xeb', '\xa2', '\x9e'}, 3, 0xB89E}, /* (HANGUL SYLLABLE RWAELM) */
    {{'\xeb', '\xa2', '\x9f'}, 3, 0xB89F}, /* (HANGUL SYLLABLE RWAELB) */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{'\xeb', '\xa2', '\xa0'}, 3, 0xB8A0}, /* (HANGUL SYLLABLE RWAELS) */
    {{'\xeb', '\xa2', '\xa1'}, 3, 0xB8A1}, /* (HANGUL SYLLABLE RWAELT) */
    {{'\xeb', '\xa2', '\xa2'}, 3, 0xB8A2}, /* (HANGUL SYLLABLE RWAELP) */
    {{'\xeb', '\xa2', '\xa3'}, 3, 0xB8A3}, /* (HANGUL SYLLABLE RWAELH) */
    {{'\xeb', '\xa2', '\xa4'}, 3, 0xB8A4}, /* (HANGUL SYLLABLE RWAEM) */
    {{'\xeb', '\xa2', '\xa5'}, 3, 0xB8A5}, /* (HANGUL SYLLABLE RWAEB) */
    {{'\xeb', '\xa2', '\xa6'}, 3, 0xB8A6}, /* (HANGUL SYLLABLE RWAEBS) */
    {{'\xeb', '\xa2', '\xa7'}, 3, 0xB8A7}, /* (HANGUL SYLLABLE RWAES) */
    {{'\xeb', '\xa2', '\xa9'}, 3, 0xB8A9}, /* (HANGUL SYLLABLE RWAENG) */
    {{'\xeb', '\xa2', '\xaa'}, 3, 0xB8AA}, /* (HANGUL SYLLABLE RWAEJ) */
    {{'\xeb', '\xa2', '\xab'}, 3, 0xB8AB}, /* (HANGUL SYLLABLE RWAEC) */
    {{'\xeb', '\xa2', '\xac'}, 3, 0xB8AC}, /* (HANGUL SYLLABLE RWAEK) */
    {{'\xeb', '\xa2', '\xad'}, 3, 0xB8AD}, /* (HANGUL SYLLABLE RWAET) */
    {{'\xeb', '\xa2', '\xae'}, 3, 0xB8AE}, /* (HANGUL SYLLABLE RWAEP) */
    {{'\xeb', '\xa2', '\xaf'}, 3, 0xB8AF}, /* (HANGUL SYLLABLE RWAEH) */
    {{'\xeb', '\xa2', '\xb1'}, 3, 0xB8B1}, /* (HANGUL SYLLABLE ROEG) */
    {{'\xeb', '\xa2', '\xb2'}, 3, 0xB8B2}, /* (HANGUL SYLLABLE ROEGG) */
    {{'\xeb', '\xa2', '\xb3'}, 3, 0xB8B3}, /* (HANGUL SYLLABLE ROEGS) */
    {{'\xeb', '\xa2', '\xb5'}, 3, 0xB8B5}, /* (HANGUL SYLLABLE ROENJ) */
    {{'\xeb', '\xa2', '\xb6'}, 3, 0xB8B6}, /* (HANGUL SYLLABLE ROENH) */
    {{'\xeb', '\xa2', '\xb7'}, 3, 0xB8B7}, /* (HANGUL SYLLABLE ROED) */
    {{'\xeb', '\xa2', '\xb9'}, 3, 0xB8B9}, /* (HANGUL SYLLABLE ROELG) */
    {{'\xeb', '\xa2', '\xba'}, 3, 0xB8BA}, /* (HANGUL SYLLABLE ROELM) */
    {{'\xeb', '\xa2', '\xbb'}, 3, 0xB8BB}, /* (HANGUL SYLLABLE ROELB) */
    {{'\xeb', '\xa2', '\xbc'}, 3, 0xB8BC}, /* (HANGUL SYLLABLE ROELS) */
    {{'\xeb', '\xa2', '\xbd'}, 3, 0xB8BD}, /* (HANGUL SYLLABLE ROELT) */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{'\xeb', '\xa2', '\xbe'}, 3, 0xB8BE}, /* (HANGUL SYLLABLE ROELP) */
    {{'\xeb', '\xa2', '\xbf'}, 3, 0xB8BF}, /* (HANGUL SYLLABLE ROELH) */
    {{'\xeb', '\xa3', '\x82'}, 3, 0xB8C2}, /* (HANGUL SYLLABLE ROEBS) */
    {{'\xeb', '\xa3', '\x84'}, 3, 0xB8C4}, /* (HANGUL SYLLABLE ROESS) */
    {{'\xeb', '\xa3', '\x86'}, 3, 0xB8C6}, /* (HANGUL SYLLABLE ROEJ) */
    {{'\xeb', '\xa3', '\x87'}, 3, 0xB8C7}, /* (HANGUL SYLLABLE ROEC) */
    {{'\xeb', '\xa3', '\x88'}, 3, 0xB8C8}, /* (HANGUL SYLLABLE ROEK) */
    {{'\xeb', '\xa3', '\x89'}, 3, 0xB8C9}, /* (HANGUL SYLLABLE ROET) */
    {{'\xeb', '\xa3', '\x8a'}, 3, 0xB8CA}, /* (HANGUL SYLLABLE ROEP) */
    {{'\xeb', '\xa3', '\x8b'}, 3, 0xB8CB}, /* (HANGUL SYLLABLE ROEH) */
    {{'\xeb', '\xa3', '\x8d'}, 3, 0xB8CD}, /* (HANGUL SYLLABLE RYOG) */
    {{'\xeb', '\xa3', '\x8e'}, 3, 0xB8CE}, /* (HANGUL SYLLABLE RYOGG) */
    {{'\xeb', '\xa3', '\x8f'}, 3, 0xB8CF}, /* (HANGUL SYLLABLE RYOGS) */
    {{'\xeb', '\xa3', '\x91'}, 3, 0xB8D1}, /* (HANGUL SYLLABLE RYONJ) */
    {{'\xeb', '\xa3', '\x92'}, 3, 0xB8D2}, /* (HANGUL SYLLABLE RYONH) */
    {{'\xeb', '\xa3', '\x93'}, 3, 0xB8D3}, /* (HANGUL SYLLABLE RYOD) */
    {{'\xeb', '\xa3', '\x95'}, 3, 0xB8D5}, /* (HANGUL SYLLABLE RYOLG) */
    {{'\xeb', '\xa3', '\x96'}, 3, 0xB8D6}, /* (HANGUL SYLLABLE RYOLM) */
    {{'\xeb', '\xa3', '\x97'}, 3, 0xB8D7}, /* (HANGUL SYLLABLE RYOLB) */
    {{'\xeb', '\xa3', '\x98'}, 3, 0xB8D8}, /* (HANGUL SYLLABLE RYOLS) */
    {{'\xeb', '\xa3', '\x99'}, 3, 0xB8D9}, /* (HANGUL SYLLABLE RYOLT) */
    {{'\xeb', '\xa3', '\x9a'}, 3, 0xB8DA}, /* (HANGUL SYLLABLE RYOLP) */
    {{'\xeb', '\xa3', '\x9b'}, 3, 0xB8DB}, /* (HANGUL SYLLABLE RYOLH) */
    {{'\xeb', '\xa3', '\x9c'}, 3, 0xB8DC}, /* (HANGUL SYLLABLE RYOM) */
    {{'\xeb', '\xa3', '\x9e'}, 3, 0xB8DE}, /* (HANGUL SYLLABLE RYOBS) */
    {{'\xeb', '\xa3', '\xa0'}, 3, 0xB8E0}, /* (HANGUL SYLLABLE RYOSS) */
    {{'\xeb', '\xa3', '\xa2'}, 3, 0xB8E2}, /* (HANGUL SYLLABLE RYOJ) */
    {{'\xeb', '\xa3', '\xa3'}, 3, 0xB8E3}, /* (HANGUL SYLLABLE RYOC) */
    {{'\xeb', '\xa3', '\xa4'}, 3, 0xB8E4}, /* (HANGUL SYLLABLE RYOK) */
    {{'\xeb', '\xa3', '\xa5'}, 3, 0xB8E5}, /* (HANGUL SYLLABLE RYOT) */
    {{'\xeb', '\xa3', '\xa6'}, 3, 0xB8E6}, /* (HANGUL SYLLABLE RYOP) */
    {{'\xeb', '\xa3', '\xa7'}, 3, 0xB8E7}, /* (HANGUL SYLLABLE RYOH) */
    {{'\xeb', '\xa3', '\xaa'}, 3, 0xB8EA}, /* (HANGUL SYLLABLE RUGG) */
    {{'\xeb', '\xa3', '\xab'}, 3, 0xB8EB}, /* (HANGUL SYLLABLE RUGS) */
    {{'\xeb', '\xa3', '\xad'}, 3, 0xB8ED}, /* (HANGUL SYLLABLE RUNJ) */
    {{'\xeb', '\xa3', '\xae'}, 3, 0xB8EE}, /* (HANGUL SYLLABLE RUNH) */
    {{'\xeb', '\xa3', '\xaf'}, 3, 0xB8EF}, /* (HANGUL SYLLABLE RUD) */
    {{'\xeb', '\xa3', '\xb1'}, 3, 0xB8F1}, /* (HANGUL SYLLABLE RULG) */
    {{'\xeb', '\xa3', '\xb2'}, 3, 0xB8F2}, /* (HANGUL SYLLABLE RULM) */
    {{'\xeb', '\xa3', '\xb3'}, 3, 0xB8F3}, /* (HANGUL SYLLABLE RULB) */
    {{'\xeb', '\xa3', '\xb4'}, 3, 0xB8F4}, /* (HANGUL SYLLABLE RULS) */
    {{'\xeb', '\xa3', '\xb5'}, 3, 0xB8F5}, /* (HANGUL SYLLABLE RULT) */
    {{'\xeb', '\xa3', '\xb6'}, 3, 0xB8F6}, /* (HANGUL SYLLABLE RULP) */
    {{'\xeb', '\xa3', '\xb7'}, 3, 0xB8F7}, /* (HANGUL SYLLABLE RULH) */
    {{'\xeb', '\xa3', '\xba'}, 3, 0xB8FA}, /* (HANGUL SYLLABLE RUBS) */
    {{'\xeb', '\xa3', '\xbc'}, 3, 0xB8FC}, /* (HANGUL SYLLABLE RUSS) */
    {{'\xeb', '\xa3', '\xbe'}, 3, 0xB8FE}, /* (HANGUL SYLLABLE RUJ) */
    {{'\xeb', '\xa3', '\xbf'}, 3, 0xB8FF}, /* (HANGUL SYLLABLE RUC) */
    {{'\xeb', '\xa4', '\x80'}, 3, 0xB900}, /* (HANGUL SYLLABLE RUK) */
    {{'\xeb', '\xa4', '\x81'}, 3, 0xB901}, /* (HANGUL SYLLABLE RUT) */
    {{'\xeb', '\xa4', '\x82'}, 3, 0xB902}, /* (HANGUL SYLLABLE RUP) */
    {{'\xeb', '\xa4', '\x83'}, 3, 0xB903}, /* (HANGUL SYLLABLE RUH) */
    {{'\xeb', '\xa4', '\x85'}, 3, 0xB905}, /* (HANGUL SYLLABLE RWEOG) */
    {{'\xeb', '\xa4', '\x86'}, 3, 0xB906}, /* (HANGUL SYLLABLE RWEOGG) */
    {{'\xeb', '\xa4', '\x87'}, 3, 0xB907}, /* (HANGUL SYLLABLE RWEOGS) */
    {{'\xeb', '\xa4', '\x88'}, 3, 0xB908}, /* (HANGUL SYLLABLE RWEON) */
    {{'\xeb', '\xa4', '\x89'}, 3, 0xB909}, /* (HANGUL SYLLABLE RWEONJ) */
    {{'\xeb', '\xa4', '\x8a'}, 3, 0xB90A}, /* (HANGUL SYLLABLE RWEONH) */
    {{'\xeb', '\xa4', '\x8b'}, 3, 0xB90B}, /* (HANGUL SYLLABLE RWEOD) */
    {{'\xeb', '\xa4', '\x8c'}, 3, 0xB90C}, /* (HANGUL SYLLABLE RWEOL) */
    {{'\xeb', '\xa4', '\x8d'}, 3, 0xB90D}, /* (HANGUL SYLLABLE RWEOLG) */
    {{'\xeb', '\xa4', '\x8e'}, 3, 0xB90E}, /* (HANGUL SYLLABLE RWEOLM) */
    {{'\xeb', '\xa4', '\x8f'}, 3, 0xB90F}, /* (HANGUL SYLLABLE RWEOLB) */
    {{'\xeb', '\xa4', '\x90'}, 3, 0xB910}, /* (HANGUL SYLLABLE RWEOLS) */
    {{'\xeb', '\xa4', '\x91'}, 3, 0xB911}, /* (HANGUL SYLLABLE RWEOLT) */
    {{'\xeb', '\xa4', '\x92'}, 3, 0xB912}, /* (HANGUL SYLLABLE RWEOLP) */
    {{'\xeb', '\xa4', '\x93'}, 3, 0xB913}, /* (HANGUL SYLLABLE RWEOLH) */
    {{'\xeb', '\xa4', '\x94'}, 3, 0xB914}, /* (HANGUL SYLLABLE RWEOM) */
    {{'\xeb', '\xa4', '\x95'}, 3, 0xB915}, /* (HANGUL SYLLABLE RWEOB) */
    {{'\xeb', '\xa4', '\x96'}, 3, 0xB916}, /* (HANGUL SYLLABLE RWEOBS) */
    {{'\xeb', '\xa4', '\x97'}, 3, 0xB917}, /* (HANGUL SYLLABLE RWEOS) */
    {{'\xeb', '\xa4', '\x99'}, 3, 0xB919}, /* (HANGUL SYLLABLE RWEONG) */
    {{'\xeb', '\xa4', '\x9a'}, 3, 0xB91A}, /* (HANGUL SYLLABLE RWEOJ) */
    {{'\xeb', '\xa4', '\x9b'}, 3, 0xB91B}, /* (HANGUL SYLLABLE RWEOC) */
    {{'\xeb', '\xa4', '\x9c'}, 3, 0xB91C}, /* (HANGUL SYLLABLE RWEOK) */
    {{'\xeb', '\xa4', '\x9d'}, 3, 0xB91D}, /* (HANGUL SYLLABLE RWEOT) */
    {{'\xeb', '\xa4', '\x9e'}, 3, 0xB91E}, /* (HANGUL SYLLABLE RWEOP) */
    {{'\xeb', '\xa4', '\x9f'}, 3, 0xB91F}, /* (HANGUL SYLLABLE RWEOH) */
    {{'\xeb', '\xa4', '\xa1'}, 3, 0xB921}, /* (HANGUL SYLLABLE RWEG) */
    {{'\xeb', '\xa4', '\xa2'}, 3, 0xB922}, /* (HANGUL SYLLABLE RWEGG) */
    {{'\xeb', '\xa4', '\xa3'}, 3, 0xB923}, /* (HANGUL SYLLABLE RWEGS) */
    {{'\xeb', '\xa4', '\xa4'}, 3, 0xB924}, /* (HANGUL SYLLABLE RWEN) */
    {{'\xeb', '\xa4', '\xa5'}, 3, 0xB925}, /* (HANGUL SYLLABLE RWENJ) */
    {{'\xeb', '\xa4', '\xa6'}, 3, 0xB926}, /* (HANGUL SYLLABLE RWENH) */
    {{'\xeb', '\xa4', '\xa7'}, 3, 0xB927}, /* (HANGUL SYLLABLE RWED) */
    {{'\xeb', '\xa4', '\xa8'}, 3, 0xB928}, /* (HANGUL SYLLABLE RWEL) */
    {{'\xeb', '\xa4', '\xa9'}, 3, 0xB929}, /* (HANGUL SYLLABLE RWELG) */
    {{'\xeb', '\xa4', '\xaa'}, 3, 0xB92A}, /* (HANGUL SYLLABLE RWELM) */
    {{'\xeb', '\xa4', '\xab'}, 3, 0xB92B}, /* (HANGUL SYLLABLE RWELB) */
    {{'\xeb', '\xa4', '\xac'}, 3, 0xB92C}, /* (HANGUL SYLLABLE RWELS) */
    {{'\xeb', '\xa4', '\xad'}, 3, 0xB92D}, /* (HANGUL SYLLABLE RWELT) */
    {{'\xeb', '\xa4', '\xae'}, 3, 0xB92E}, /* (HANGUL SYLLABLE RWELP) */
    {{'\xeb', '\xa4', '\xaf'}, 3, 0xB92F}, /* (HANGUL SYLLABLE RWELH) */
    {{'\xeb', '\xa4', '\xb0'}, 3, 0xB930}, /* (HANGUL SYLLABLE RWEM) */
    {{'\xeb', '\xa4', '\xb1'}, 3, 0xB931}, /* (HANGUL SYLLABLE RWEB) */
    {{'\xeb', '\xa4', '\xb2'}, 3, 0xB932}, /* (HANGUL SYLLABLE RWEBS) */
    {{'\xeb', '\xa4', '\xb3'}, 3, 0xB933}, /* (HANGUL SYLLABLE RWES) */
    {{'\xeb', '\xa4', '\xb4'}, 3, 0xB934}, /* (HANGUL SYLLABLE RWESS) */
    {{'\xeb', '\xa4', '\xb5'}, 3, 0xB935}, /* (HANGUL SYLLABLE RWENG) */
    {{'\xeb', '\xa4', '\xb6'}, 3, 0xB936}, /* (HANGUL SYLLABLE RWEJ) */
    {{'\xeb', '\xa4', '\xb7'}, 3, 0xB937}, /* (HANGUL SYLLABLE RWEC) */
    {{'\xeb', '\xa4', '\xb8'}, 3, 0xB938}, /* (HANGUL SYLLABLE RWEK) */
    {{'\xeb', '\xa4', '\xb9'}, 3, 0xB939}, /* (HANGUL SYLLABLE RWET) */
    {{'\xeb', '\xa4', '\xba'}, 3, 0xB93A}, /* (HANGUL SYLLABLE RWEP) */
    {{'\xeb', '\xa4', '\xbb'}, 3, 0xB93B}, /* (HANGUL SYLLABLE RWEH) */
    {{'\xeb', '\xa4', '\xbe'}, 3, 0xB93E}, /* (HANGUL SYLLABLE RWIGG) */
    {{'\xeb', '\xa4', '\xbf'}, 3, 0xB93F}, /* (HANGUL SYLLABLE RWIGS) */
    {{'\xeb', '\xa5', '\x81'}, 3, 0xB941}, /* (HANGUL SYLLABLE RWINJ) */
    {{'\xeb', '\xa5', '\x82'}, 3, 0xB942}, /* (HANGUL SYLLABLE RWINH) */
    {{'\xeb', '\xa5', '\x83'}, 3, 0xB943}, /* (HANGUL SYLLABLE RWID) */
    {{'\xeb', '\xa5', '\x85'}, 3, 0xB945}, /* (HANGUL SYLLABLE RWILG) */
    {{'\xeb', '\xa5', '\x86'}, 3, 0xB946}, /* (HANGUL SYLLABLE RWILM) */
    {{'\xeb', '\xa5', '\x87'}, 3, 0xB947}, /* (HANGUL SYLLABLE RWILB) */
    {{'\xeb', '\xa5', '\x88'}, 3, 0xB948}, /* (HANGUL SYLLABLE RWILS) */
    {{'\xeb', '\xa5', '\x89'}, 3, 0xB949}, /* (HANGUL SYLLABLE RWILT) */
    {{'\xeb', '\xa5', '\x8a'}, 3, 0xB94A}, /* (HANGUL SYLLABLE RWILP) */
    {{'\xeb', '\xa5', '\x8b'}, 3, 0xB94B}, /* (HANGUL SYLLABLE RWILH) */
    {{'\xeb', '\xa5', '\x8d'}, 3, 0xB94D}, /* (HANGUL SYLLABLE RWIB) */
    {{'\xeb', '\xa5', '\x8e'}, 3, 0xB94E}, /* (HANGUL SYLLABLE RWIBS) */
    {{'\xeb', '\xa5', '\x90'}, 3, 0xB950}, /* (HANGUL SYLLABLE RWISS) */
    {{'\xeb', '\xa5', '\x92'}, 3, 0xB952}, /* (HANGUL SYLLABLE RWIJ) */
    {{'\xeb', '\xa5', '\x93'}, 3, 0xB953}, /* (HANGUL SYLLABLE RWIC) */
    {{'\xeb', '\xa5', '\x94'}, 3, 0xB954}, /* (HANGUL SYLLABLE RWIK) */
    {{'\xeb', '\xa5', '\x95'}, 3, 0xB955}, /* (HANGUL SYLLABLE RWIT) */
    {{'\xeb', '\xa5', '\x96'}, 3, 0xB956}, /* (HANGUL SYLLABLE RWIP) */
    {{'\xeb', '\xa5', '\x97'}, 3, 0xB957}, /* (HANGUL SYLLABLE RWIH) */
    {{'\xeb', '\xa5', '\x9a'}, 3, 0xB95A}, /* (HANGUL SYLLABLE RYUGG) */
    {{'\xeb', '\xa5', '\x9b'}, 3, 0xB95B}, /* (HANGUL SYLLABLE RYUGS) */
    {{'\xeb', '\xa5', '\x9d'}, 3, 0xB95D}, /* (HANGUL SYLLABLE RYUNJ) */
    {{'\xeb', '\xa5', '\x9e'}, 3, 0xB95E}, /* (HANGUL SYLLABLE RYUNH) */
    {{'\xeb', '\xa5', '\x9f'}, 3, 0xB95F}, /* (HANGUL SYLLABLE RYUD) */
    {{'\xeb', '\xa5', '\xa1'}, 3, 0xB961}, /* (HANGUL SYLLABLE RYULG) */
    {{'\xeb', '\xa5', '\xa2'}, 3, 0xB962}, /* (HANGUL SYLLABLE RYULM) */
    {{'\xeb', '\xa5', '\xa3'}, 3, 0xB963}, /* (HANGUL SYLLABLE RYULB) */
    {{'\xeb', '\xa5', '\xa4'}, 3, 0xB964}, /* (HANGUL SYLLABLE RYULS) */
    {{'\xeb', '\xa5', '\xa5'}, 3, 0xB965}, /* (HANGUL SYLLABLE RYULT) */
    {{'\xeb', '\xa5', '\xa6'}, 3, 0xB966}, /* (HANGUL SYLLABLE RYULP) */
    {{'\xeb', '\xa5', '\xa7'}, 3, 0xB967}, /* (HANGUL SYLLABLE RYULH) */
    {{'\xeb', '\xa5', '\xaa'}, 3, 0xB96A}, /* (HANGUL SYLLABLE RYUBS) */
    {{'\xeb', '\xa5', '\xac'}, 3, 0xB96C}, /* (HANGUL SYLLABLE RYUSS) */
    {{'\xeb', '\xa5', '\xae'}, 3, 0xB96E}, /* (HANGUL SYLLABLE RYUJ) */
    {{'\xeb', '\xa5', '\xaf'}, 3, 0xB96F}, /* (HANGUL SYLLABLE RYUC) */
    {{'\xeb', '\xa5', '\xb0'}, 3, 0xB970}, /* (HANGUL SYLLABLE RYUK) */
    {{'\xeb', '\xa5', '\xb1'}, 3, 0xB971}, /* (HANGUL SYLLABLE RYUT) */
    {{'\xeb', '\xa5', '\xb2'}, 3, 0xB972}, /* (HANGUL SYLLABLE RYUP) */
    {{'\xeb', '\xa5', '\xb3'}, 3, 0xB973}, /* (HANGUL SYLLABLE RYUH) */
    {{'\xeb', '\xa5', '\xb6'}, 3, 0xB976}, /* (HANGUL SYLLABLE REUGG) */
    {{'\xeb', '\xa5', '\xb7'}, 3, 0xB977}, /* (HANGUL SYLLABLE REUGS) */
    {{'\xeb', '\xa5', '\xb9'}, 3, 0xB979}, /* (HANGUL SYLLABLE REUNJ) */
    {{'\xeb', '\xa5', '\xba'}, 3, 0xB97A}, /* (HANGUL SYLLABLE REUNH) */
    {{'\xeb', '\xa5', '\xbb'}, 3, 0xB97B}, /* (HANGUL SYLLABLE REUD) */
    {{'\xeb', '\xa5', '\xbd'}, 3, 0xB97D}, /* (HANGUL SYLLABLE REULG) */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{'\xeb', '\xa5', '\xbe'}, 3, 0xB97E}, /* (HANGUL SYLLABLE REULM) */
    {{'\xeb', '\xa5', '\xbf'}, 3, 0xB97F}, /* (HANGUL SYLLABLE REULB) */
    {{'\xeb', '\xa6', '\x80'}, 3, 0xB980}, /* (HANGUL SYLLABLE REULS) */
    {{'\xeb', '\xa6', '\x81'}, 3, 0xB981}, /* (HANGUL SYLLABLE REULT) */
    {{'\xeb', '\xa6', '\x82'}, 3, 0xB982}, /* (HANGUL SYLLABLE REULP) */
    {{'\xeb', '\xa6', '\x83'}, 3, 0xB983}, /* (HANGUL SYLLABLE REULH) */
    {{'\xeb', '\xa6', '\x86'}, 3, 0xB986}, /* (HANGUL SYLLABLE REUBS) */
    {{'\xeb', '\xa6', '\x88'}, 3, 0xB988}, /* (HANGUL SYLLABLE REUSS) */
    {{'\xeb', '\xa6', '\x8b'}, 3, 0xB98B}, /* (HANGUL SYLLABLE REUC) */
    {{'\xeb', '\xa6', '\x8c'}, 3, 0xB98C}, /* (HANGUL SYLLABLE REUK) */
    {{'\xeb', '\xa6', '\x8f'}, 3, 0xB98F}, /* (HANGUL SYLLABLE REUH) */
    {{'\xeb', '\xa6', '\x90'}, 3, 0xB990}, /* (HANGUL SYLLABLE RYI) */
    {{'\xeb', '\xa6', '\x91'}, 3, 0xB991}, /* (HANGUL SYLLABLE RYIG) */
    {{'\xeb', '\xa6', '\x92'}, 3, 0xB992}, /* (HANGUL SYLLABLE RYIGG) */
    {{'\xeb', '\xa6', '\x93'}, 3, 0xB993}, /* (HANGUL SYLLABLE RYIGS) */
    {{'\xeb', '\xa6', '\x94'}, 3, 0xB994}, /* (HANGUL SYLLABLE RYIN) */
    {{'\xeb', '\xa6', '\x95'}, 3, 0xB995}, /* (HANGUL SYLLABLE RYINJ) */
    {{'\xeb', '\xa6', '\x96'}, 3, 0xB996}, /* (HANGUL SYLLABLE RYINH) */
    {{'\xeb', '\xa6', '\x97'}, 3, 0xB997}, /* (HANGUL SYLLABLE RYID) */
    {{'\xeb', '\xa6', '\x98'}, 3, 0xB998}, /* (HANGUL SYLLABLE RYIL) */
    {{'\xeb', '\xa6', '\x99'}, 3, 0xB999}, /* (HANGUL SYLLABLE RYILG) */
    {{'\xeb', '\xa6', '\x9a'}, 3, 0xB99A}, /* (HANGUL SYLLABLE RYILM) */
    {{'\xeb', '\xa6', '\x9b'}, 3, 0xB99B}, /* (HANGUL SYLLABLE RYILB) */
    {{'\xeb', '\xa6', '\x9c'}, 3, 0xB99C}, /* (HANGUL SYLLABLE RYILS) */
    {{'\xeb', '\xa6', '\x9d'}, 3, 0xB99D}, /* (HANGUL SYLLABLE RYILT) */
    {{'\xeb', '\xa6', '\x9e'}, 3, 0xB99E}, /* (HANGUL SYLLABLE RYILP) */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{'\xeb', '\xa6', '\x9f'}, 3, 0xB99F}, /* (HANGUL SYLLABLE RYILH) */
    {{'\xeb', '\xa6', '\xa0'}, 3, 0xB9A0}, /* (HANGUL SYLLABLE RYIM) */
    {{'\xeb', '\xa6', '\xa1'}, 3, 0xB9A1}, /* (HANGUL SYLLABLE RYIB) */
    {{'\xeb', '\xa6', '\xa2'}, 3, 0xB9A2}, /* (HANGUL SYLLABLE RYIBS) */
    {{'\xeb', '\xa6', '\xa3'}, 3, 0xB9A3}, /* (HANGUL SYLLABLE RYIS) */
    {{'\xeb', '\xa6', '\xa4'}, 3, 0xB9A4}, /* (HANGUL SYLLABLE RYISS) */
    {{'\xeb', '\xa6', '\xa5'}, 3, 0xB9A5}, /* (HANGUL SYLLABLE RYING) */
    {{'\xeb', '\xa6', '\xa6'}, 3, 0xB9A6}, /* (HANGUL SYLLABLE RYIJ) */
    {{'\xeb', '\xa6', '\xa7'}, 3, 0xB9A7}, /* (HANGUL SYLLABLE RYIC) */
    {{'\xeb', '\xa6', '\xa8'}, 3, 0xB9A8}, /* (HANGUL SYLLABLE RYIK) */
    {{'\xeb', '\xa6', '\xa9'}, 3, 0xB9A9}, /* (HANGUL SYLLABLE RYIT) */
    {{'\xeb', '\xa6', '\xaa'}, 3, 0xB9AA}, /* (HANGUL SYLLABLE RYIP) */
    {{'\xeb', '\xa6', '\xab'}, 3, 0xB9AB}, /* (HANGUL SYLLABLE RYIH) */
    {{'\xeb', '\xa6', '\xae'}, 3, 0xB9AE}, /* (HANGUL SYLLABLE RIGG) */
    {{'\xeb', '\xa6', '\xaf'}, 3, 0xB9AF}, /* (HANGUL SYLLABLE RIGS) */
    {{'\xeb', '\xa6', '\xb1'}, 3, 0xB9B1}, /* (HANGUL SYLLABLE RINJ) */
    {{'\xeb', '\xa6', '\xb2'}, 3, 0xB9B2}, /* (HANGUL SYLLABLE RINH) */
    {{'\xeb', '\xa6', '\xb3'}, 3, 0xB9B3}, /* (HANGUL SYLLABLE RID) */
    {{'\xeb', '\xa6', '\xb5'}, 3, 0xB9B5}, /* (HANGUL SYLLABLE RILG) */
    {{'\xeb', '\xa6', '\xb6'}, 3, 0xB9B6}, /* (HANGUL SYLLABLE RILM) */
    {{'\xeb', '\xa6', '\xb7'}, 3, 0xB9B7}, /* (HANGUL SYLLABLE RILB) */
    {{'\xeb', '\xa6', '\xb8'}, 3, 0xB9B8}, /* (HANGUL SYLLABLE RILS) */
    {{'\xeb', '\xa6', '\xb9'}, 3, 0xB9B9}, /* (HANGUL SYLLABLE RILT) */
    {{'\xeb', '\xa6', '\xba'}, 3, 0xB9BA}, /* (HANGUL SYLLABLE RILP) */
    {{'\xeb', '\xa6', '\xbb'}, 3, 0xB9BB}, /* (HANGUL SYLLABLE RILH) */
    {{'\xeb', '\xa6', '\xbe'}, 3, 0xB9BE}, /* (HANGUL SYLLABLE RIBS) */
    {{'\xeb', '\xa7', '\x80'}, 3, 0xB9C0}, /* (HANGUL SYLLABLE RISS) */
    {{'\xeb', '\xa7', '\x82'}, 3, 0xB9C2}, /* (HANGUL SYLLABLE RIJ) */
    {{'\xeb', '\xa7', '\x83'}, 3, 0xB9C3}, /* (HANGUL SYLLABLE RIC) */
    {{'\xeb', '\xa7', '\x84'}, 3, 0xB9C4}, /* (HANGUL SYLLABLE RIK) */
    {{'\xeb', '\xa7', '\x85'}, 3, 0xB9C5}, /* (HANGUL SYLLABLE RIT) */
    {{'\xeb', '\xa7', '\x86'}, 3, 0xB9C6}, /* (HANGUL SYLLABLE RIP) */
    {{'\xeb', '\xa7', '\x87'}, 3, 0xB9C7}, /* (HANGUL SYLLABLE RIH) */
    {{'\xeb', '\xa7', '\x8a'}, 3, 0xB9CA}, /* (HANGUL SYLLABLE MAGG) */
    {{'\xeb', '\xa7', '\x8b'}, 3, 0xB9CB}, /* (HANGUL SYLLABLE MAGS) */
    {{'\xeb', '\xa7', '\x8d'}, 3, 0xB9CD}, /* (HANGUL SYLLABLE MANJ) */
    {{'\xeb', '\xa7', '\x93'}, 3, 0xB9D3}, /* (HANGUL SYLLABLE MALB) */
    {{'\xeb', '\xa7', '\x94'}, 3, 0xB9D4}, /* (HANGUL SYLLABLE MALS) */
    {{'\xeb', '\xa7', '\x95'}, 3, 0xB9D5}, /* (HANGUL SYLLABLE MALT) */
    {{'\xeb', '\xa7', '\x96'}, 3, 0xB9D6}, /* (HANGUL SYLLABLE MALP) */
    {{'\xeb', '\xa7', '\x97'}, 3, 0xB9D7}, /* (HANGUL SYLLABLE MALH) */
    {{'\xeb', '\xa7', '\x9a'}, 3, 0xB9DA}, /* (HANGUL SYLLABLE MABS) */
    {{'\xeb', '\xa7', '\x9c'}, 3, 0xB9DC}, /* (HANGUL SYLLABLE MASS) */
    {{'\xeb', '\xa7', '\x9f'}, 3, 0xB9DF}, /* (HANGUL SYLLABLE MAC) */
    {{'\xeb', '\xa7', '\xa0'}, 3, 0xB9E0}, /* (HANGUL SYLLABLE MAK) */
    {{'\xeb', '\xa7', '\xa2'}, 3, 0xB9E2}, /* (HANGUL SYLLABLE MAP) */
    {{'\xeb', '\xa7', '\xa6'}, 3, 0xB9E6}, /* (HANGUL SYLLABLE MAEGG) */
    {{'\xeb', '\xa7', '\xa7'}, 3, 0xB9E7}, /* (HANGUL SYLLABLE MAEGS) */
    {{'\xeb', '\xa7', '\xa9'}, 3, 0xB9E9}, /* (HANGUL SYLLABLE MAENJ) */
    {{'\xeb', '\xa7', '\xaa'}, 3, 0xB9EA}, /* (HANGUL SYLLABLE MAENH) */
    {{'\xeb', '\xa7', '\xab'}, 3, 0xB9EB}, /* (HANGUL SYLLABLE MAED) */
    {{'\xeb', '\xa7', '\xad'}, 3, 0xB9ED}, /* (HANGUL SYLLABLE MAELG) */
    {{'\xeb', '\xa7', '\xae'}, 3, 0xB9EE}, /* (HANGUL SYLLABLE MAELM) */
    {{'\xeb', '\xa7', '\xaf'}, 3, 0xB9EF}, /* (HANGUL SYLLABLE MAELB) */
    {{'\xeb', '\xa7', '\xb0'}, 3, 0xB9F0}, /* (HANGUL SYLLABLE MAELS) */
    {{'\xeb', '\xa7', '\xb1'}, 3, 0xB9F1}, /* (HANGUL SYLLABLE MAELT) */
    {{'\xeb', '\xa7', '\xb2'}, 3, 0xB9F2}, /* (HANGUL SYLLABLE MAELP) */
    {{'\xeb', '\xa7', '\xb3'}, 3, 0xB9F3}, /* (HANGUL SYLLABLE MAELH) */
    {{'\xeb', '\xa7', '\xb6'}, 3, 0xB9F6}, /* (HANGUL SYLLABLE MAEBS) */
    {{'\xeb', '\xa7', '\xbb'}, 3, 0xB9FB}, /* (HANGUL SYLLABLE MAEC) */
    {{'\xeb', '\xa7', '\xbc'}, 3, 0xB9FC}, /* (HANGUL SYLLABLE MAEK) */
    {{'\xeb', '\xa7', '\xbd'}, 3, 0xB9FD}, /* (HANGUL SYLLABLE MAET) */
    {{'\xeb', '\xa7', '\xbe'}, 3, 0xB9FE}, /* (HANGUL SYLLABLE MAEP) */
    {{'\xeb', '\xa7', '\xbf'}, 3, 0xB9FF}, /* (HANGUL SYLLABLE MAEH) */
    {{'\xeb', '\xa8', '\x82'}, 3, 0xBA02}, /* (HANGUL SYLLABLE MYAGG) */
    {{'\xeb', '\xa8', '\x83'}, 3, 0xBA03}, /* (HANGUL SYLLABLE MYAGS) */
    {{'\xeb', '\xa8', '\x84'}, 3, 0xBA04}, /* (HANGUL SYLLABLE MYAN) */
    {{'\xeb', '\xa8', '\x85'}, 3, 0xBA05}, /* (HANGUL SYLLABLE MYANJ) */
    {{'\xeb', '\xa8', '\x86'}, 3, 0xBA06}, /* (HANGUL SYLLABLE MYANH) */
    {{'\xeb', '\xa8', '\x87'}, 3, 0xBA07}, /* (HANGUL SYLLABLE MYAD) */
    {{'\xeb', '\xa8', '\x89'}, 3, 0xBA09}, /* (HANGUL SYLLABLE MYALG) */
    {{'\xeb', '\xa8', '\x8a'}, 3, 0xBA0A}, /* (HANGUL SYLLABLE MYALM) */
    {{'\xeb', '\xa8', '\x8b'}, 3, 0xBA0B}, /* (HANGUL SYLLABLE MYALB) */
    {{'\xeb', '\xa8', '\x8c'}, 3, 0xBA0C}, /* (HANGUL SYLLABLE MYALS) */
    {{'\xeb', '\xa8', '\x8d'}, 3, 0xBA0D}, /* (HANGUL SYLLABLE MYALT) */
    {{'\xeb', '\xa8', '\x8e'}, 3, 0xBA0E}, /* (HANGUL SYLLABLE MYALP) */
    {{'\xeb', '\xa8', '\x8f'}, 3, 0xBA0F}, /* (HANGUL SYLLABLE MYALH) */
    {{'\xeb', '\xa8', '\x90'}, 3, 0xBA10}, /* (HANGUL SYLLABLE MYAM) */
    {{'\xeb', '\xa8', '\x91'}, 3, 0xBA11}, /* (HANGUL SYLLABLE MYAB) */
    {{'\xeb', '\xa8', '\x92'}, 3, 0xBA12}, /* (HANGUL SYLLABLE MYABS) */
    {{'\xeb', '\xa8', '\x93'}, 3, 0xBA13}, /* (HANGUL SYLLABLE MYAS) */
    {{'\xeb', '\xa8', '\x94'}, 3, 0xBA14}, /* (HANGUL SYLLABLE MYASS) */
    {{'\xeb', '\xa8', '\x96'}, 3, 0xBA16}, /* (HANGUL SYLLABLE MYAJ) */
    {{'\xeb', '\xa8', '\x97'}, 3, 0xBA17}, /* (HANGUL SYLLABLE MYAC) */
    {{'\xeb', '\xa8', '\x98'}, 3, 0xBA18}, /* (HANGUL SYLLABLE MYAK) */
    {{'\xeb', '\xa8', '\x99'}, 3, 0xBA19}, /* (HANGUL SYLLABLE MYAT) */
    {{'\xeb', '\xa8', '\x9a'}, 3, 0xBA1A}, /* (HANGUL SYLLABLE MYAP) */
    {{'\xeb', '\xa8', '\x9b'}, 3, 0xBA1B}, /* (HANGUL SYLLABLE MYAH) */
    {{'\xeb', '\xa8', '\x9c'}, 3, 0xBA1C}, /* (HANGUL SYLLABLE MYAE) */
    {{'\xeb', '\xa8', '\x9d'}, 3, 0xBA1D}, /* (HANGUL SYLLABLE MYAEG) */
    {{'\xeb', '\xa8', '\x9e'}, 3, 0xBA1E}, /* (HANGUL SYLLABLE MYAEGG) */
    {{'\xeb', '\xa8', '\x9f'}, 3, 0xBA1F}, /* (HANGUL SYLLABLE MYAEGS) */
    {{'\xeb', '\xa8', '\xa0'}, 3, 0xBA20}, /* (HANGUL SYLLABLE MYAEN) */
    {{'\xeb', '\xa8', '\xa1'}, 3, 0xBA21}, /* (HANGUL SYLLABLE MYAENJ) */
    {{'\xeb', '\xa8', '\xa2'}, 3, 0xBA22}, /* (HANGUL SYLLABLE MYAENH) */
    {{'\xeb', '\xa8', '\xa3'}, 3, 0xBA23}, /* (HANGUL SYLLABLE MYAED) */
    {{'\xeb', '\xa8', '\xa4'}, 3, 0xBA24}, /* (HANGUL SYLLABLE MYAEL) */
    {{'\xeb', '\xa8', '\xa5'}, 3, 0xBA25}, /* (HANGUL SYLLABLE MYAELG) */
    {{'\xeb', '\xa8', '\xa6'}, 3, 0xBA26}, /* (HANGUL SYLLABLE MYAELM) */
    {{'\xeb', '\xa8', '\xa7'}, 3, 0xBA27}, /* (HANGUL SYLLABLE MYAELB) */
    {{'\xeb', '\xa8', '\xa8'}, 3, 0xBA28}, /* (HANGUL SYLLABLE MYAELS) */
    {{'\xeb', '\xa8', '\xa9'}, 3, 0xBA29}, /* (HANGUL SYLLABLE MYAELT) */
    {{'\xeb', '\xa8', '\xaa'}, 3, 0xBA2A}, /* (HANGUL SYLLABLE MYAELP) */
    {{'\xeb', '\xa8', '\xab'}, 3, 0xBA2B}, /* (HANGUL SYLLABLE MYAELH) */
    {{'\xeb', '\xa8', '\xac'}, 3, 0xBA2C}, /* (HANGUL SYLLABLE MYAEM) */
    {{'\xeb', '\xa8', '\xad'}, 3, 0xBA2D}, /* (HANGUL SYLLABLE MYAEB) */
    {{'\xeb', '\xa8', '\xae'}, 3, 0xBA2E}, /* (HANGUL SYLLABLE MYAEBS) */
    {{'\xeb', '\xa8', '\xaf'}, 3, 0xBA2F}, /* (HANGUL SYLLABLE MYAES) */
    {{'\xeb', '\xa8', '\xb0'}, 3, 0xBA30}, /* (HANGUL SYLLABLE MYAESS) */
    {{'\xeb', '\xa8', '\xb1'}, 3, 0xBA31}, /* (HANGUL SYLLABLE MYAENG) */
    {{'\xeb', '\xa8', '\xb2'}, 3, 0xBA32}, /* (HANGUL SYLLABLE MYAEJ) */
    {{'\xeb', '\xa8', '\xb3'}, 3, 0xBA33}, /* (HANGUL SYLLABLE MYAEC) */
    {{'\xeb', '\xa8', '\xb4'}, 3, 0xBA34}, /* (HANGUL SYLLABLE MYAEK) */
    {{'\xeb', '\xa8', '\xb5'}, 3, 0xBA35}, /* (HANGUL SYLLABLE MYAET) */
    {{'\xeb', '\xa8', '\xb6'}, 3, 0xBA36}, /* (HANGUL SYLLABLE MYAEP) */
    {{'\xeb', '\xa8', '\xb7'}, 3, 0xBA37}, /* (HANGUL SYLLABLE MYAEH) */
    {{'\xeb', '\xa8', '\xba'}, 3, 0xBA3A}, /* (HANGUL SYLLABLE MEOGG) */
    {{'\xeb', '\xa8', '\xbb'}, 3, 0xBA3B}, /* (HANGUL SYLLABLE MEOGS) */
    {{'\xeb', '\xa8', '\xbd'}, 3, 0xBA3D}, /* (HANGUL SYLLABLE MEONJ) */
    {{'\xeb', '\xa8', '\xbe'}, 3, 0xBA3E}, /* (HANGUL SYLLABLE MEONH) */
    {{'\xeb', '\xa8', '\xbf'}, 3, 0xBA3F}, /* (HANGUL SYLLABLE MEOD) */
    {{'\xeb', '\xa9', '\x81'}, 3, 0xBA41}, /* (HANGUL SYLLABLE MEOLG) */
    {{'\xeb', '\xa9', '\x83'}, 3, 0xBA43}, /* (HANGUL SYLLABLE MEOLB) */
    {{'\xeb', '\xa9', '\x84'}, 3, 0xBA44}, /* (HANGUL SYLLABLE MEOLS) */
    {{'\xeb', '\xa9', '\x85'}, 3, 0xBA45}, /* (HANGUL SYLLABLE MEOLT) */
    {{'\xeb', '\xa9', '\x86'}, 3, 0xBA46}, /* (HANGUL SYLLABLE MEOLP) */
    {{'\xeb', '\xa9', '\x87'}, 3, 0xBA47}, /* (HANGUL SYLLABLE MEOLH) */
    {{'\xeb', '\xa9', '\x8a'}, 3, 0xBA4A}, /* (HANGUL SYLLABLE MEOBS) */
    {{'\xeb', '\xa9', '\x8c'}, 3, 0xBA4C}, /* (HANGUL SYLLABLE MEOSS) */
    {{'\xeb', '\xa9', '\x8f'}, 3, 0xBA4F}, /* (HANGUL SYLLABLE MEOC) */
    {{'\xeb', '\xa9', '\x90'}, 3, 0xBA50}, /* (HANGUL SYLLABLE MEOK) */
    {{'\xeb', '\xa9', '\x91'}, 3, 0xBA51}, /* (HANGUL SYLLABLE MEOT) */
    {{'\xeb', '\xa9', '\x92'}, 3, 0xBA52}, /* (HANGUL SYLLABLE MEOP) */
    {{'\xeb', '\xa9', '\x96'}, 3, 0xBA56}, /* (HANGUL SYLLABLE MEGG) */
    {{'\xeb', '\xa9', '\x97'}, 3, 0xBA57}, /* (HANGUL SYLLABLE MEGS) */
    {{'\xeb', '\xa9', '\x99'}, 3, 0xBA59}, /* (HANGUL SYLLABLE MENJ) */
    {{'\xeb', '\xa9', '\x9a'}, 3, 0xBA5A}, /* (HANGUL SYLLABLE MENH) */
    {{'\xeb', '\xa9', '\x9b'}, 3, 0xBA5B}, /* (HANGUL SYLLABLE MED) */
    {{'\xeb', '\xa9', '\x9d'}, 3, 0xBA5D}, /* (HANGUL SYLLABLE MELG) */
    {{'\xeb', '\xa9', '\x9e'}, 3, 0xBA5E}, /* (HANGUL SYLLABLE MELM) */
    {{'\xeb', '\xa9', '\x9f'}, 3, 0xBA5F}, /* (HANGUL SYLLABLE MELB) */
    {{'\xeb', '\xa9', '\xa0'}, 3, 0xBA60}, /* (HANGUL SYLLABLE MELS) */
    {{'\xeb', '\xa9', '\xa1'}, 3, 0xBA61}, /* (HANGUL SYLLABLE MELT) */
    {{'\xeb', '\xa9', '\xa2'}, 3, 0xBA62}, /* (HANGUL SYLLABLE MELP) */
    {{'\xeb', '\xa9', '\xa3'}, 3, 0xBA63}, /* (HANGUL SYLLABLE MELH) */
    {{'\xeb', '\xa9', '\xa6'}, 3, 0xBA66}, /* (HANGUL SYLLABLE MEBS) */
    {{'\xeb', '\xa9', '\xaa'}, 3, 0xBA6A}, /* (HANGUL SYLLABLE MEJ) */
    {{'\xeb', '\xa9', '\xab'}, 3, 0xBA6B}, /* (HANGUL SYLLABLE MEC) */
    {{'\xeb', '\xa9', '\xac'}, 3, 0xBA6C}, /* (HANGUL SYLLABLE MEK) */
    {{'\xeb', '\xa9', '\xad'}, 3, 0xBA6D}, /* (HANGUL SYLLABLE MET) */
    {{'\xeb', '\xa9', '\xae'}, 3, 0xBA6E}, /* (HANGUL SYLLABLE MEP) */
    {{'\xeb', '\xa9', '\xaf'}, 3, 0xBA6F}, /* (HANGUL SYLLABLE MEH) */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{'\xeb', '\xa9', '\xb2'}, 3, 0xBA72}, /* (HANGUL SYLLABLE MYEOGG) */
    {{'\xeb', '\xa9', '\xb3'}, 3, 0xBA73}, /* (HANGUL SYLLABLE MYEOGS) */
    {{'\xeb', '\xa9', '\xb5'}, 3, 0xBA75}, /* (HANGUL SYLLABLE MYEONJ) */
    {{'\xeb', '\xa9', '\xb6'}, 3, 0xBA76}, /* (HANGUL SYLLABLE MYEONH) */
    {{'\xeb', '\xa9', '\xb7'}, 3, 0xBA77}, /* (HANGUL SYLLABLE MYEOD) */
    {{'\xeb', '\xa9', '\xb9'}, 3, 0xBA79}, /* (HANGUL SYLLABLE MYEOLG) */
    {{'\xeb', '\xa9', '\xba'}, 3, 0xBA7A}, /* (HANGUL SYLLABLE MYEOLM) */
    {{'\xeb', '\xa9', '\xbb'}, 3, 0xBA7B}, /* (HANGUL SYLLABLE MYEOLB) */
    {{'\xeb', '\xa9', '\xbc'}, 3, 0xBA7C}, /* (HANGUL SYLLABLE MYEOLS) */
    {{'\xeb', '\xa9', '\xbd'}, 3, 0xBA7D}, /* (HANGUL SYLLABLE MYEOLT) */
    {{'\xeb', '\xa9', '\xbe'}, 3, 0xBA7E}, /* (HANGUL SYLLABLE MYEOLP) */
    {{'\xeb', '\xa9', '\xbf'}, 3, 0xBA7F}, /* (HANGUL SYLLABLE MYEOLH) */
    {{'\xeb', '\xaa', '\x80'}, 3, 0xBA80}, /* (HANGUL SYLLABLE MYEOM) */
    {{'\xeb', '\xaa', '\x81'}, 3, 0xBA81}, /* (HANGUL SYLLABLE MYEOB) */
    {{'\xeb', '\xaa', '\x82'}, 3, 0xBA82}, /* (HANGUL SYLLABLE MYEOBS) */
    {{'\xeb', '\xaa', '\x86'}, 3, 0xBA86}, /* (HANGUL SYLLABLE MYEOJ) */
    {{'\xeb', '\xaa', '\x88'}, 3, 0xBA88}, /* (HANGUL SYLLABLE MYEOK) */
    {{'\xeb', '\xaa', '\x89'}, 3, 0xBA89}, /* (HANGUL SYLLABLE MYEOT) */
    {{'\xeb', '\xaa', '\x8a'}, 3, 0xBA8A}, /* (HANGUL SYLLABLE MYEOP) */
    {{'\xeb', '\xaa', '\x8b'}, 3, 0xBA8B}, /* (HANGUL SYLLABLE MYEOH) */
    {{'\xeb', '\xaa', '\x8d'}, 3, 0xBA8D}, /* (HANGUL SYLLABLE MYEG) */
    {{'\xeb', '\xaa', '\x8e'}, 3, 0xBA8E}, /* (HANGUL SYLLABLE MYEGG) */
    {{'\xeb', '\xaa', '\x8f'}, 3, 0xBA8F}, /* (HANGUL SYLLABLE MYEGS) */
    {{'\xeb', '\xaa', '\x90'}, 3, 0xBA90}, /* (HANGUL SYLLABLE MYEN) */
    {{'\xeb', '\xaa', '\x91'}, 3, 0xBA91}, /* (HANGUL SYLLABLE MYENJ) */
    {{'\xeb', '\xaa', '\x92'}, 3, 0xBA92}, /* (HANGUL SYLLABLE MYENH) */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{'\xeb', '\xaa', '\x93'}, 3, 0xBA93}, /* (HANGUL SYLLABLE MYED) */
    {{'\xeb', '\xaa', '\x94'}, 3, 0xBA94}, /* (HANGUL SYLLABLE MYEL) */
    {{'\xeb', '\xaa', '\x95'}, 3, 0xBA95}, /* (HANGUL SYLLABLE MYELG) */
    {{'\xeb', '\xaa', '\x96'}, 3, 0xBA96}, /* (HANGUL SYLLABLE MYELM) */
    {{'\xeb', '\xaa', '\x97'}, 3, 0xBA97}, /* (HANGUL SYLLABLE MYELB) */
    {{'\xeb', '\xaa', '\x98'}, 3, 0xBA98}, /* (HANGUL SYLLABLE MYELS) */
    {{'\xeb', '\xaa', '\x99'}, 3, 0xBA99}, /* (HANGUL SYLLABLE MYELT) */
    {{'\xeb', '\xaa', '\x9a'}, 3, 0xBA9A}, /* (HANGUL SYLLABLE MYELP) */
    {{'\xeb', '\xaa', '\x9b'}, 3, 0xBA9B}, /* (HANGUL SYLLABLE MYELH) */
    {{'\xeb', '\xaa', '\x9c'}, 3, 0xBA9C}, /* (HANGUL SYLLABLE MYEM) */
    {{'\xeb', '\xaa', '\x9d'}, 3, 0xBA9D}, /* (HANGUL SYLLABLE MYEB) */
    {{'\xeb', '\xaa', '\x9e'}, 3, 0xBA9E}, /* (HANGUL SYLLABLE MYEBS) */
    {{'\xeb', '\xaa', '\x9f'}, 3, 0xBA9F}, /* (HANGUL SYLLABLE MYES) */
    {{'\xeb', '\xaa', '\xa0'}, 3, 0xBAA0}, /* (HANGUL SYLLABLE MYESS) */
    {{'\xeb', '\xaa', '\xa1'}, 3, 0xBAA1}, /* (HANGUL SYLLABLE MYENG) */
    {{'\xeb', '\xaa', '\xa2'}, 3, 0xBAA2}, /* (HANGUL SYLLABLE MYEJ) */
    {{'\xeb', '\xaa', '\xa3'}, 3, 0xBAA3}, /* (HANGUL SYLLABLE MYEC) */
    {{'\xeb', '\xaa', '\xa4'}, 3, 0xBAA4}, /* (HANGUL SYLLABLE MYEK) */
    {{'\xeb', '\xaa', '\xa5'}, 3, 0xBAA5}, /* (HANGUL SYLLABLE MYET) */
    {{'\xeb', '\xaa', '\xa6'}, 3, 0xBAA6}, /* (HANGUL SYLLABLE MYEP) */
    {{'\xeb', '\xaa', '\xa7'}, 3, 0xBAA7}, /* (HANGUL SYLLABLE MYEH) */
    {{'\xeb', '\xaa', '\xaa'}, 3, 0xBAAA}, /* (HANGUL SYLLABLE MOGG) */
    {{'\xeb', '\xaa', '\xad'}, 3, 0xBAAD}, /* (HANGUL SYLLABLE MONJ) */
    {{'\xeb', '\xaa', '\xae'}, 3, 0xBAAE}, /* (HANGUL SYLLABLE MONH) */
    {{'\xeb', '\xaa', '\xaf'}, 3, 0xBAAF}, /* (HANGUL SYLLABLE MOD) */
    {{'\xeb', '\xaa', '\xb1'}, 3, 0xBAB1}, /* (HANGUL SYLLABLE MOLG) */
    {{'\xeb', '\xaa', '\xb3'}, 3, 0xBAB3}, /* (HANGUL SYLLABLE MOLB) */
    {{'\xeb', '\xaa', '\xb4'}, 3, 0xBAB4}, /* (HANGUL SYLLABLE MOLS) */
    {{'\xeb', '\xaa', '\xb5'}, 3, 0xBAB5}, /* (HANGUL SYLLABLE MOLT) */
    {{'\xeb', '\xaa', '\xb6'}, 3, 0xBAB6}, /* (HANGUL SYLLABLE MOLP) */
    {{'\xeb', '\xaa', '\xb7'}, 3, 0xBAB7}, /* (HANGUL SYLLABLE MOLH) */
    {{'\xeb', '\xaa', '\xba'}, 3, 0xBABA}, /* (HANGUL SYLLABLE MOBS) */
    {{'\xeb', '\xaa', '\xbc'}, 3, 0xBABC}, /* (HANGUL SYLLABLE MOSS) */
    {{'\xeb', '\xaa', '\xbe'}, 3, 0xBABE}, /* (HANGUL SYLLABLE MOJ) */
    {{'\xeb', '\xaa', '\xbf'}, 3, 0xBABF}, /* (HANGUL SYLLABLE MOC) */
    {{'\xeb', '\xab', '\x80'}, 3, 0xBAC0}, /* (HANGUL SYLLABLE MOK) */
    {{'\xeb', '\xab', '\x81'}, 3, 0xBAC1}, /* (HANGUL SYLLABLE MOT) */
    {{'\xeb', '\xab', '\x82'}, 3, 0xBAC2}, /* (HANGUL SYLLABLE MOP) */
    {{'\xeb', '\xab', '\x83'}, 3, 0xBAC3}, /* (HANGUL SYLLABLE MOH) */
    {{'\xeb', '\xab', '\x85'}, 3, 0xBAC5}, /* (HANGUL SYLLABLE MWAG) */
    {{'\xeb', '\xab', '\x86'}, 3, 0xBAC6}, /* (HANGUL SYLLABLE MWAGG) */
    {{'\xeb', '\xab', '\x87'}, 3, 0xBAC7}, /* (HANGUL SYLLABLE MWAGS) */
    {{'\xeb', '\xab', '\x89'}, 3, 0xBAC9}, /* (HANGUL SYLLABLE MWANJ) */
    {{'\xeb', '\xab', '\x8a'}, 3, 0xBACA}, /* (HANGUL SYLLABLE MWANH) */
    {{'\xeb', '\xab', '\x8b'}, 3, 0xBACB}, /* (HANGUL SYLLABLE MWAD) */
    {{'\xeb', '\xab', '\x8c'}, 3, 0xBACC}, /* (HANGUL SYLLABLE MWAL) */
    {{'\xeb', '\xab', '\x8d'}, 3, 0xBACD}, /* (HANGUL SYLLABLE MWALG) */
    {{'\xeb', '\xab', '\x8e'}, 3, 0xBACE}, /* (HANGUL SYLLABLE MWALM) */
    {{'\xeb', '\xab', '\x8f'}, 3, 0xBACF}, /* (HANGUL SYLLABLE MWALB) */
    {{'\xeb', '\xab', '\x90'}, 3, 0xBAD0}, /* (HANGUL SYLLABLE MWALS) */
    {{'\xeb', '\xab', '\x91'}, 3, 0xBAD1}, /* (HANGUL SYLLABLE MWALT) */
    {{'\xeb', '\xab', '\x92'}, 3, 0xBAD2}, /* (HANGUL SYLLABLE MWALP) */
    {{'\xeb', '\xab', '\x93'}, 3, 0xBAD3}, /* (HANGUL SYLLABLE MWALH) */
    {{'\xeb', '\xab', '\x94'}, 3, 0xBAD4}, /* (HANGUL SYLLABLE MWAM) */
    {{'\xeb', '\xab', '\x95'}, 3, 0xBAD5}, /* (HANGUL SYLLABLE MWAB) */
    {{'\xeb', '\xab', '\x96'}, 3, 0xBAD6}, /* (HANGUL SYLLABLE MWABS) */
    {{'\xeb', '\xab', '\x97'}, 3, 0xBAD7}, /* (HANGUL SYLLABLE MWAS) */
    {{'\xeb', '\xab', '\x9a'}, 3, 0xBADA}, /* (HANGUL SYLLABLE MWAJ) */
    {{'\xeb', '\xab', '\x9b'}, 3, 0xBADB}, /* (HANGUL SYLLABLE MWAC) */
    {{'\xeb', '\xab', '\x9c'}, 3, 0xBADC}, /* (HANGUL SYLLABLE MWAK) */
    {{'\xeb', '\xab', '\x9d'}, 3, 0xBADD}, /* (HANGUL SYLLABLE MWAT) */
    {{'\xeb', '\xab', '\x9e'}, 3, 0xBADE}, /* (HANGUL SYLLABLE MWAP) */
    {{'\xeb', '\xab', '\x9f'}, 3, 0xBADF}, /* (HANGUL SYLLABLE MWAH) */
    {{'\xeb', '\xab', '\xa0'}, 3, 0xBAE0}, /* (HANGUL SYLLABLE MWAE) */
    {{'\xeb', '\xab', '\xa1'}, 3, 0xBAE1}, /* (HANGUL SYLLABLE MWAEG) */
    {{'\xeb', '\xab', '\xa2'}, 3, 0xBAE2}, /* (HANGUL SYLLABLE MWAEGG) */
    {{'\xeb', '\xab', '\xa3'}, 3, 0xBAE3}, /* (HANGUL SYLLABLE MWAEGS) */
    {{'\xeb', '\xab', '\xa4'}, 3, 0xBAE4}, /* (HANGUL SYLLABLE MWAEN) */
    {{'\xeb', '\xab', '\xa5'}, 3, 0xBAE5}, /* (HANGUL SYLLABLE MWAENJ) */
    {{'\xeb', '\xab', '\xa6'}, 3, 0xBAE6}, /* (HANGUL SYLLABLE MWAENH) */
    {{'\xeb', '\xab', '\xa7'}, 3, 0xBAE7}, /* (HANGUL SYLLABLE MWAED) */
    {{'\xeb', '\xab', '\xa8'}, 3, 0xBAE8}, /* (HANGUL SYLLABLE MWAEL) */
    {{'\xeb', '\xab', '\xa9'}, 3, 0xBAE9}, /* (HANGUL SYLLABLE MWAELG) */
    {{'\xeb', '\xab', '\xaa'}, 3, 0xBAEA}, /* (HANGUL SYLLABLE MWAELM) */
    {{'\xeb', '\xab', '\xab'}, 3, 0xBAEB}, /* (HANGUL SYLLABLE MWAELB) */
    {{'\xeb', '\xab', '\xac'}, 3, 0xBAEC}, /* (HANGUL SYLLABLE MWAELS) */
    {{'\xeb', '\xab', '\xad'}, 3, 0xBAED}, /* (HANGUL SYLLABLE MWAELT) */
    {{'\xeb', '\xab', '\xae'}, 3, 0xBAEE}, /* (HANGUL SYLLABLE MWAELP) */
    {{'\xeb', '\xab', '\xaf'}, 3, 0xBAEF}, /* (HANGUL SYLLABLE MWAELH) */
    {{'\xeb', '\xab', '\xb0'}, 3, 0xBAF0}, /* (HANGUL SYLLABLE MWAEM) */
    {{'\xeb', '\xab', '\xb1'}, 3, 0xBAF1}, /* (HANGUL SYLLABLE MWAEB) */
    {{'\xeb', '\xab', '\xb2'}, 3, 0xBAF2}, /* (HANGUL SYLLABLE MWAEBS) */
    {{'\xeb', '\xab', '\xb3'}, 3, 0xBAF3}, /* (HANGUL SYLLABLE MWAES) */
    {{'\xeb', '\xab', '\xb4'}, 3, 0xBAF4}, /* (HANGUL SYLLABLE MWAESS) */
    {{'\xeb', '\xab', '\xb5'}, 3, 0xBAF5}, /* (HANGUL SYLLABLE MWAENG) */
    {{'\xeb', '\xab', '\xb6'}, 3, 0xBAF6}, /* (HANGUL SYLLABLE MWAEJ) */
    {{'\xeb', '\xab', '\xb7'}, 3, 0xBAF7}, /* (HANGUL SYLLABLE MWAEC) */
    {{'\xeb', '\xab', '\xb8'}, 3, 0xBAF8}, /* (HANGUL SYLLABLE MWAEK) */
    {{'\xeb', '\xab', '\xb9'}, 3, 0xBAF9}, /* (HANGUL SYLLABLE MWAET) */
    {{'\xeb', '\xab', '\xba'}, 3, 0xBAFA}, /* (HANGUL SYLLABLE MWAEP) */
    {{'\xeb', '\xab', '\xbb'}, 3, 0xBAFB}, /* (HANGUL SYLLABLE MWAEH) */
    {{'\xeb', '\xab', '\xbd'}, 3, 0xBAFD}, /* (HANGUL SYLLABLE MOEG) */
    {{'\xeb', '\xab', '\xbe'}, 3, 0xBAFE}, /* (HANGUL SYLLABLE MOEGG) */
    {{'\xeb', '\xab', '\xbf'}, 3, 0xBAFF}, /* (HANGUL SYLLABLE MOEGS) */
    {{'\xeb', '\xac', '\x81'}, 3, 0xBB01}, /* (HANGUL SYLLABLE MOENJ) */
    {{'\xeb', '\xac', '\x82'}, 3, 0xBB02}, /* (HANGUL SYLLABLE MOENH) */
    {{'\xeb', '\xac', '\x83'}, 3, 0xBB03}, /* (HANGUL SYLLABLE MOED) */
    {{'\xeb', '\xac', '\x85'}, 3, 0xBB05}, /* (HANGUL SYLLABLE MOELG) */
    {{'\xeb', '\xac', '\x86'}, 3, 0xBB06}, /* (HANGUL SYLLABLE MOELM) */
    {{'\xeb', '\xac', '\x87'}, 3, 0xBB07}, /* (HANGUL SYLLABLE MOELB) */
    {{'\xeb', '\xac', '\x88'}, 3, 0xBB08}, /* (HANGUL SYLLABLE MOELS) */
    {{'\xeb', '\xac', '\x89'}, 3, 0xBB09}, /* (HANGUL SYLLABLE MOELT) */
    {{'\xeb', '\xac', '\x8a'}, 3, 0xBB0A}, /* (HANGUL SYLLABLE MOELP) */
    {{'\xeb', '\xac', '\x8b'}, 3, 0xBB0B}, /* (HANGUL SYLLABLE MOELH) */
    {{'\xeb', '\xac', '\x8c'}, 3, 0xBB0C}, /* (HANGUL SYLLABLE MOEM) */
    {{'\xeb', '\xac', '\x8e'}, 3, 0xBB0E}, /* (HANGUL SYLLABLE MOEBS) */
    {{'\xeb', '\xac', '\x90'}, 3, 0xBB10}, /* (HANGUL SYLLABLE MOESS) */
    {{'\xeb', '\xac', '\x92'}, 3, 0xBB12}, /* (HANGUL SYLLABLE MOEJ) */
    {{'\xeb', '\xac', '\x93'}, 3, 0xBB13}, /* (HANGUL SYLLABLE MOEC) */
    {{'\xeb', '\xac', '\x94'}, 3, 0xBB14}, /* (HANGUL SYLLABLE MOEK) */
    {{'\xeb', '\xac', '\x95'}, 3, 0xBB15}, /* (HANGUL SYLLABLE MOET) */
    {{'\xeb', '\xac', '\x96'}, 3, 0xBB16}, /* (HANGUL SYLLABLE MOEP) */
    {{'\xeb', '\xac', '\x97'}, 3, 0xBB17}, /* (HANGUL SYLLABLE MOEH) */
    {{'\xeb', '\xac', '\x99'}, 3, 0xBB19}, /* (HANGUL SYLLABLE MYOG) */
    {{'\xeb', '\xac', '\x9a'}, 3, 0xBB1A}, /* (HANGUL SYLLABLE MYOGG) */
    {{'\xeb', '\xac', '\x9b'}, 3, 0xBB1B}, /* (HANGUL SYLLABLE MYOGS) */
    {{'\xeb', '\xac', '\x9d'}, 3, 0xBB1D}, /* (HANGUL SYLLABLE MYONJ) */
    {{'\xeb', '\xac', '\x9e'}, 3, 0xBB1E}, /* (HANGUL SYLLABLE MYONH) */
    {{'\xeb', '\xac', '\x9f'}, 3, 0xBB1F}, /* (HANGUL SYLLABLE MYOD) */
    {{'\xeb', '\xac', '\xa1'}, 3, 0xBB21}, /* (HANGUL SYLLABLE MYOLG) */
    {{'\xeb', '\xac', '\xa2'}, 3, 0xBB22}, /* (HANGUL SYLLABLE MYOLM) */
    {{'\xeb', '\xac', '\xa3'}, 3, 0xBB23}, /* (HANGUL SYLLABLE MYOLB) */
    {{'\xeb', '\xac', '\xa4'}, 3, 0xBB24}, /* (HANGUL SYLLABLE MYOLS) */
    {{'\xeb', '\xac', '\xa5'}, 3, 0xBB25}, /* (HANGUL SYLLABLE MYOLT) */
    {{'\xeb', '\xac', '\xa6'}, 3, 0xBB26}, /* (HANGUL SYLLABLE MYOLP) */
    {{'\xeb', '\xac', '\xa7'}, 3, 0xBB27}, /* (HANGUL SYLLABLE MYOLH) */
    {{'\xeb', '\xac', '\xa8'}, 3, 0xBB28}, /* (HANGUL SYLLABLE MYOM) */
    {{'\xeb', '\xac', '\xaa'}, 3, 0xBB2A}, /* (HANGUL SYLLABLE MYOBS) */
    {{'\xeb', '\xac', '\xac'}, 3, 0xBB2C}, /* (HANGUL SYLLABLE MYOSS) */
    {{'\xeb', '\xac', '\xad'}, 3, 0xBB2D}, /* (HANGUL SYLLABLE MYONG) */
    {{'\xeb', '\xac', '\xae'}, 3, 0xBB2E}, /* (HANGUL SYLLABLE MYOJ) */
    {{'\xeb', '\xac', '\xaf'}, 3, 0xBB2F}, /* (HANGUL SYLLABLE MYOC) */
    {{'\xeb', '\xac', '\xb0'}, 3, 0xBB30}, /* (HANGUL SYLLABLE MYOK) */
    {{'\xeb', '\xac', '\xb1'}, 3, 0xBB31}, /* (HANGUL SYLLABLE MYOT) */
    {{'\xeb', '\xac', '\xb2'}, 3, 0xBB32}, /* (HANGUL SYLLABLE MYOP) */
    {{'\xeb', '\xac', '\xb3'}, 3, 0xBB33}, /* (HANGUL SYLLABLE MYOH) */
    {{'\xeb', '\xac', '\xb7'}, 3, 0xBB37}, /* (HANGUL SYLLABLE MUGS) */
    {{'\xeb', '\xac', '\xb9'}, 3, 0xBB39}, /* (HANGUL SYLLABLE MUNJ) */
    {{'\xeb', '\xac', '\xba'}, 3, 0xBB3A}, /* (HANGUL SYLLABLE MUNH) */
    {{'\xeb', '\xac', '\xbf'}, 3, 0xBB3F}, /* (HANGUL SYLLABLE MULB) */
    {{'\xeb', '\xad', '\x80'}, 3, 0xBB40}, /* (HANGUL SYLLABLE MULS) */
    {{'\xeb', '\xad', '\x81'}, 3, 0xBB41}, /* (HANGUL SYLLABLE MULT) */
    {{'\xeb', '\xad', '\x82'}, 3, 0xBB42}, /* (HANGUL SYLLABLE MULP) */
    {{'\xeb', '\xad', '\x83'}, 3, 0xBB43}, /* (HANGUL SYLLABLE MULH) */
    {{'\xeb', '\xad', '\x86'}, 3, 0xBB46}, /* (HANGUL SYLLABLE MUBS) */
    {{'\xeb', '\xad', '\x88'}, 3, 0xBB48}, /* (HANGUL SYLLABLE MUSS) */
    {{'\xeb', '\xad', '\x8a'}, 3, 0xBB4A}, /* (HANGUL SYLLABLE MUJ) */
    {{'\xeb', '\xad', '\x8b'}, 3, 0xBB4B}, /* (HANGUL SYLLABLE MUC) */
    {{'\xeb', '\xad', '\x8c'}, 3, 0xBB4C}, /* (HANGUL SYLLABLE MUK) */
    {{'\xeb', '\xad', '\x8e'}, 3, 0xBB4E}, /* (HANGUL SYLLABLE MUP) */
    {{'\xeb', '\xad', '\x91'}, 3, 0xBB51}, /* (HANGUL SYLLABLE MWEOG) */
    {{'\xeb', '\xad', '\x92'}, 3, 0xBB52}, /* (HANGUL SYLLABLE MWEOGG) */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{'\xeb', '\xad', '\x93'}, 3, 0xBB53}, /* (HANGUL SYLLABLE MWEOGS) */
    {{'\xeb', '\xad', '\x95'}, 3, 0xBB55}, /* (HANGUL SYLLABLE MWEONJ) */
    {{'\xeb', '\xad', '\x96'}, 3, 0xBB56}, /* (HANGUL SYLLABLE MWEONH) */
    {{'\xeb', '\xad', '\x97'}, 3, 0xBB57}, /* (HANGUL SYLLABLE MWEOD) */
    {{'\xeb', '\xad', '\x99'}, 3, 0xBB59}, /* (HANGUL SYLLABLE MWEOLG) */
    {{'\xeb', '\xad', '\x9a'}, 3, 0xBB5A}, /* (HANGUL SYLLABLE MWEOLM) */
    {{'\xeb', '\xad', '\x9b'}, 3, 0xBB5B}, /* (HANGUL SYLLABLE MWEOLB) */
    {{'\xeb', '\xad', '\x9c'}, 3, 0xBB5C}, /* (HANGUL SYLLABLE MWEOLS) */
    {{'\xeb', '\xad', '\x9d'}, 3, 0xBB5D}, /* (HANGUL SYLLABLE MWEOLT) */
    {{'\xeb', '\xad', '\x9e'}, 3, 0xBB5E}, /* (HANGUL SYLLABLE MWEOLP) */
    {{'\xeb', '\xad', '\x9f'}, 3, 0xBB5F}, /* (HANGUL SYLLABLE MWEOLH) */
    {{'\xeb', '\xad', '\xa0'}, 3, 0xBB60}, /* (HANGUL SYLLABLE MWEOM) */
    {{'\xeb', '\xad', '\xa2'}, 3, 0xBB62}, /* (HANGUL SYLLABLE MWEOBS) */
    {{'\xeb', '\xad', '\xa4'}, 3, 0xBB64}, /* (HANGUL SYLLABLE MWEOSS) */
    {{'\xeb', '\xad', '\xa5'}, 3, 0xBB65}, /* (HANGUL SYLLABLE MWEONG) */
    {{'\xeb', '\xad', '\xa6'}, 3, 0xBB66}, /* (HANGUL SYLLABLE MWEOJ) */
    {{'\xeb', '\xad', '\xa7'}, 3, 0xBB67}, /* (HANGUL SYLLABLE MWEOC) */
    {{'\xeb', '\xad', '\xa8'}, 3, 0xBB68}, /* (HANGUL SYLLABLE MWEOK) */
    {{'\xeb', '\xad', '\xa9'}, 3, 0xBB69}, /* (HANGUL SYLLABLE MWEOT) */
    {{'\xeb', '\xad', '\xaa'}, 3, 0xBB6A}, /* (HANGUL SYLLABLE MWEOP) */
    {{'\xeb', '\xad', '\xab'}, 3, 0xBB6B}, /* (HANGUL SYLLABLE MWEOH) */
    {{'\xeb', '\xad', '\xad'}, 3, 0xBB6D}, /* (HANGUL SYLLABLE MWEG) */
    {{'\xeb', '\xad', '\xae'}, 3, 0xBB6E}, /* (HANGUL SYLLABLE MWEGG) */
    {{'\xeb', '\xad', '\xaf'}, 3, 0xBB6F}, /* (HANGUL SYLLABLE MWEGS) */
    {{'\xeb', '\xad', '\xb0'}, 3, 0xBB70}, /* (HANGUL SYLLABLE MWEN) */
    {{'\xeb', '\xad', '\xb1'}, 3, 0xBB71}, /* (HANGUL SYLLABLE MWENJ) */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{'\xeb', '\xad', '\xb2'}, 3, 0xBB72}, /* (HANGUL SYLLABLE MWENH) */
    {{'\xeb', '\xad', '\xb3'}, 3, 0xBB73}, /* (HANGUL SYLLABLE MWED) */
    {{'\xeb', '\xad', '\xb4'}, 3, 0xBB74}, /* (HANGUL SYLLABLE MWEL) */
    {{'\xeb', '\xad', '\xb5'}, 3, 0xBB75}, /* (HANGUL SYLLABLE MWELG) */
    {{'\xeb', '\xad', '\xb6'}, 3, 0xBB76}, /* (HANGUL SYLLABLE MWELM) */
    {{'\xeb', '\xad', '\xb7'}, 3, 0xBB77}, /* (HANGUL SYLLABLE MWELB) */
    {{'\xeb', '\xad', '\xb8'}, 3, 0xBB78}, /* (HANGUL SYLLABLE MWELS) */
    {{'\xeb', '\xad', '\xb9'}, 3, 0xBB79}, /* (HANGUL SYLLABLE MWELT) */
    {{'\xeb', '\xad', '\xba'}, 3, 0xBB7A}, /* (HANGUL SYLLABLE MWELP) */
    {{'\xeb', '\xad', '\xbb'}, 3, 0xBB7B}, /* (HANGUL SYLLABLE MWELH) */
    {{'\xeb', '\xad', '\xbc'}, 3, 0xBB7C}, /* (HANGUL SYLLABLE MWEM) */
    {{'\xeb', '\xad', '\xbd'}, 3, 0xBB7D}, /* (HANGUL SYLLABLE MWEB) */
    {{'\xeb', '\xad', '\xbe'}, 3, 0xBB7E}, /* (HANGUL SYLLABLE MWEBS) */
    {{'\xeb', '\xad', '\xbf'}, 3, 0xBB7F}, /* (HANGUL SYLLABLE MWES) */
    {{'\xeb', '\xae', '\x80'}, 3, 0xBB80}, /* (HANGUL SYLLABLE MWESS) */
    {{'\xeb', '\xae', '\x81'}, 3, 0xBB81}, /* (HANGUL SYLLABLE MWENG) */
    {{'\xeb', '\xae', '\x82'}, 3, 0xBB82}, /* (HANGUL SYLLABLE MWEJ) */
    {{'\xeb', '\xae', '\x83'}, 3, 0xBB83}, /* (HANGUL SYLLABLE MWEC) */
    {{'\xeb', '\xae', '\x84'}, 3, 0xBB84}, /* (HANGUL SYLLABLE MWEK) */
    {{'\xeb', '\xae', '\x85'}, 3, 0xBB85}, /* (HANGUL SYLLABLE MWET) */
    {{'\xeb', '\xae', '\x86'}, 3, 0xBB86}, /* (HANGUL SYLLABLE MWEP) */
    {{'\xeb', '\xae', '\x87'}, 3, 0xBB87}, /* (HANGUL SYLLABLE MWEH) */
    {{'\xeb', '\xae', '\x89'}, 3, 0xBB89}, /* (HANGUL SYLLABLE MWIG) */
    {{'\xeb', '\xae', '\x8a'}, 3, 0xBB8A}, /* (HANGUL SYLLABLE MWIGG) */
    {{'\xeb', '\xae', '\x8b'}, 3, 0xBB8B}, /* (HANGUL SYLLABLE MWIGS) */
    {{'\xeb', '\xae', '\x8d'}, 3, 0xBB8D}, /* (HANGUL SYLLABLE MWINJ) */
    {{'\xeb', '\xae', '\x8e'}, 3, 0xBB8E}, /* (HANGUL SYLLABLE MWINH) */
    {{'\xeb', '\xae', '\x8f'}, 3, 0xBB8F}, /* (HANGUL SYLLABLE MWID) */
    {{'\xeb', '\xae', '\x91'}, 3, 0xBB91}, /* (HANGUL SYLLABLE MWILG) */
    {{'\xeb', '\xae', '\x92'}, 3, 0xBB92}, /* (HANGUL SYLLABLE MWILM) */
    {{'\xeb', '\xae', '\x93'}, 3, 0xBB93}, /* (HANGUL SYLLABLE MWILB) */
    {{'\xeb', '\xae', '\x94'}, 3, 0xBB94}, /* (HANGUL SYLLABLE MWILS) */
    {{'\xeb', '\xae', '\x95'}, 3, 0xBB95}, /* (HANGUL SYLLABLE MWILT) */
    {{'\xeb', '\xae', '\x96'}, 3, 0xBB96}, /* (HANGUL SYLLABLE MWILP) */
    {{'\xeb', '\xae', '\x97'}, 3, 0xBB97}, /* (HANGUL SYLLABLE MWILH) */
    {{'\xeb', '\xae', '\x98'}, 3, 0xBB98}, /* (HANGUL SYLLABLE MWIM) */
    {{'\xeb', '\xae', '\x99'}, 3, 0xBB99}, /* (HANGUL SYLLABLE MWIB) */
    {{'\xeb', '\xae', '\x9a'}, 3, 0xBB9A}, /* (HANGUL SYLLABLE MWIBS) */
    {{'\xeb', '\xae', '\x9b'}, 3, 0xBB9B}, /* (HANGUL SYLLABLE MWIS) */
    {{'\xeb', '\xae', '\x9c'}, 3, 0xBB9C}, /* (HANGUL SYLLABLE MWISS) */
    {{'\xeb', '\xae', '\x9d'}, 3, 0xBB9D}, /* (HANGUL SYLLABLE MWING) */
    {{'\xeb', '\xae', '\x9e'}, 3, 0xBB9E}, /* (HANGUL SYLLABLE MWIJ) */
    {{'\xeb', '\xae', '\x9f'}, 3, 0xBB9F}, /* (HANGUL SYLLABLE MWIC) */
    {{'\xeb', '\xae', '\xa0'}, 3, 0xBBA0}, /* (HANGUL SYLLABLE MWIK) */
    {{'\xeb', '\xae', '\xa1'}, 3, 0xBBA1}, /* (HANGUL SYLLABLE MWIT) */
    {{'\xeb', '\xae', '\xa2'}, 3, 0xBBA2}, /* (HANGUL SYLLABLE MWIP) */
    {{'\xeb', '\xae', '\xa3'}, 3, 0xBBA3}, /* (HANGUL SYLLABLE MWIH) */
    {{'\xeb', '\xae', '\xa5'}, 3, 0xBBA5}, /* (HANGUL SYLLABLE MYUG) */
    {{'\xeb', '\xae', '\xa6'}, 3, 0xBBA6}, /* (HANGUL SYLLABLE MYUGG) */
    {{'\xeb', '\xae', '\xa7'}, 3, 0xBBA7}, /* (HANGUL SYLLABLE MYUGS) */
    {{'\xeb', '\xae', '\xa9'}, 3, 0xBBA9}, /* (HANGUL SYLLABLE MYUNJ) */
    {{'\xeb', '\xae', '\xaa'}, 3, 0xBBAA}, /* (HANGUL SYLLABLE MYUNH) */
    {{'\xeb', '\xae', '\xab'}, 3, 0xBBAB}, /* (HANGUL SYLLABLE MYUD) */
    {{'\xeb', '\xae', '\xad'}, 3, 0xBBAD}, /* (HANGUL SYLLABLE MYULG) */
    {{'\xeb', '\xae', '\xae'}, 3, 0xBBAE}, /* (HANGUL SYLLABLE MYULM) */
    {{'\xeb', '\xae', '\xaf'}, 3, 0xBBAF}, /* (HANGUL SYLLABLE MYULB) */
    {{'\xeb', '\xae', '\xb0'}, 3, 0xBBB0}, /* (HANGUL SYLLABLE MYULS) */
    {{'\xeb', '\xae', '\xb1'}, 3, 0xBBB1}, /* (HANGUL SYLLABLE MYULT) */
    {{'\xeb', '\xae', '\xb2'}, 3, 0xBBB2}, /* (HANGUL SYLLABLE MYULP) */
    {{'\xeb', '\xae', '\xb3'}, 3, 0xBBB3}, /* (HANGUL SYLLABLE MYULH) */
    {{'\xeb', '\xae', '\xb5'}, 3, 0xBBB5}, /* (HANGUL SYLLABLE MYUB) */
    {{'\xeb', '\xae', '\xb6'}, 3, 0xBBB6}, /* (HANGUL SYLLABLE MYUBS) */
    {{'\xeb', '\xae', '\xb8'}, 3, 0xBBB8}, /* (HANGUL SYLLABLE MYUSS) */
    {{'\xeb', '\xae', '\xb9'}, 3, 0xBBB9}, /* (HANGUL SYLLABLE MYUNG) */
    {{'\xeb', '\xae', '\xba'}, 3, 0xBBBA}, /* (HANGUL SYLLABLE MYUJ) */
    {{'\xeb', '\xae', '\xbb'}, 3, 0xBBBB}, /* (HANGUL SYLLABLE MYUC) */
    {{'\xeb', '\xae', '\xbc'}, 3, 0xBBBC}, /* (HANGUL SYLLABLE MYUK) */
    {{'\xeb', '\xae', '\xbd'}, 3, 0xBBBD}, /* (HANGUL SYLLABLE MYUT) */
    {{'\xeb', '\xae', '\xbe'}, 3, 0xBBBE}, /* (HANGUL SYLLABLE MYUP) */
    {{'\xeb', '\xae', '\xbf'}, 3, 0xBBBF}, /* (HANGUL SYLLABLE MYUH) */
    {{'\xeb', '\xaf', '\x81'}, 3, 0xBBC1}, /* (HANGUL SYLLABLE MEUG) */
    {{'\xeb', '\xaf', '\x82'}, 3, 0xBBC2}, /* (HANGUL SYLLABLE MEUGG) */
    {{'\xeb', '\xaf', '\x83'}, 3, 0xBBC3}, /* (HANGUL SYLLABLE MEUGS) */
    {{'\xeb', '\xaf', '\x85'}, 3, 0xBBC5}, /* (HANGUL SYLLABLE MEUNJ) */
    {{'\xeb', '\xaf', '\x86'}, 3, 0xBBC6}, /* (HANGUL SYLLABLE MEUNH) */
    {{'\xeb', '\xaf', '\x87'}, 3, 0xBBC7}, /* (HANGUL SYLLABLE MEUD) */
    {{'\xeb', '\xaf', '\x89'}, 3, 0xBBC9}, /* (HANGUL SYLLABLE MEULG) */
    {{'\xeb', '\xaf', '\x8a'}, 3, 0xBBCA}, /* (HANGUL SYLLABLE MEULM) */
    {{'\xeb', '\xaf', '\x8b'}, 3, 0xBBCB}, /* (HANGUL SYLLABLE MEULB) */
    {{'\xeb', '\xaf', '\x8c'}, 3, 0xBBCC}, /* (HANGUL SYLLABLE MEULS) */
    {{'\xeb', '\xaf', '\x8d'}, 3, 0xBBCD}, /* (HANGUL SYLLABLE MEULT) */
    {{'\xeb', '\xaf', '\x8e'}, 3, 0xBBCE}, /* (HANGUL SYLLABLE MEULP) */
    {{'\xeb', '\xaf', '\x8f'}, 3, 0xBBCF}, /* (HANGUL SYLLABLE MEULH) */
    {{'\xeb', '\xaf', '\x91'}, 3, 0xBBD1}, /* (HANGUL SYLLABLE MEUB) */
    {{'\xeb', '\xaf', '\x92'}, 3, 0xBBD2}, /* (HANGUL SYLLABLE MEUBS) */
    {{'\xeb', '\xaf', '\x94'}, 3, 0xBBD4}, /* (HANGUL SYLLABLE MEUSS) */
    {{'\xeb', '\xaf', '\x95'}, 3, 0xBBD5}, /* (HANGUL SYLLABLE MEUNG) */
    {{'\xeb', '\xaf', '\x96'}, 3, 0xBBD6}, /* (HANGUL SYLLABLE MEUJ) */
    {{'\xeb', '\xaf', '\x97'}, 3, 0xBBD7}, /* (HANGUL SYLLABLE MEUC) */
    {{'\xeb', '\xaf', '\x98'}, 3, 0xBBD8}, /* (HANGUL SYLLABLE MEUK) */
    {{'\xeb', '\xaf', '\x99'}, 3, 0xBBD9}, /* (HANGUL SYLLABLE MEUT) */
    {{'\xeb', '\xaf', '\x9a'}, 3, 0xBBDA}, /* (HANGUL SYLLABLE MEUP) */
    {{'\xeb', '\xaf', '\x9b'}, 3, 0xBBDB}, /* (HANGUL SYLLABLE MEUH) */
    {{'\xeb', '\xaf', '\x9c'}, 3, 0xBBDC}, /* (HANGUL SYLLABLE MYI) */
    {{'\xeb', '\xaf', '\x9d'}, 3, 0xBBDD}, /* (HANGUL SYLLABLE MYIG) */
    {{'\xeb', '\xaf', '\x9e'}, 3, 0xBBDE}, /* (HANGUL SYLLABLE MYIGG) */
    {{'\xeb', '\xaf', '\x9f'}, 3, 0xBBDF}, /* (HANGUL SYLLABLE MYIGS) */
    {{'\xeb', '\xaf', '\xa0'}, 3, 0xBBE0}, /* (HANGUL SYLLABLE MYIN) */
    {{'\xeb', '\xaf', '\xa1'}, 3, 0xBBE1}, /* (HANGUL SYLLABLE MYINJ) */
    {{'\xeb', '\xaf', '\xa2'}, 3, 0xBBE2}, /* (HANGUL SYLLABLE MYINH) */
    {{'\xeb', '\xaf', '\xa3'}, 3, 0xBBE3}, /* (HANGUL SYLLABLE MYID) */
    {{'\xeb', '\xaf', '\xa4'}, 3, 0xBBE4}, /* (HANGUL SYLLABLE MYIL) */
    {{'\xeb', '\xaf', '\xa5'}, 3, 0xBBE5}, /* (HANGUL SYLLABLE MYILG) */
    {{'\xeb', '\xaf', '\xa6'}, 3, 0xBBE6}, /* (HANGUL SYLLABLE MYILM) */
    {{'\xeb', '\xaf', '\xa7'}, 3, 0xBBE7}, /* (HANGUL SYLLABLE MYILB) */
    {{'\xeb', '\xaf', '\xa8'}, 3, 0xBBE8}, /* (HANGUL SYLLABLE MYILS) */
    {{'\xeb', '\xaf', '\xa9'}, 3, 0xBBE9}, /* (HANGUL SYLLABLE MYILT) */
    {{'\xeb', '\xaf', '\xaa'}, 3, 0xBBEA}, /* (HANGUL SYLLABLE MYILP) */
    {{'\xeb', '\xaf', '\xab'}, 3, 0xBBEB}, /* (HANGUL SYLLABLE MYILH) */
    {{'\xeb', '\xaf', '\xac'}, 3, 0xBBEC}, /* (HANGUL SYLLABLE MYIM) */
    {{'\xeb', '\xaf', '\xad'}, 3, 0xBBED}, /* (HANGUL SYLLABLE MYIB) */
    {{'\xeb', '\xaf', '\xae'}, 3, 0xBBEE}, /* (HANGUL SYLLABLE MYIBS) */
    {{'\xeb', '\xaf', '\xaf'}, 3, 0xBBEF}, /* (HANGUL SYLLABLE MYIS) */
    {{'\xeb', '\xaf', '\xb0'}, 3, 0xBBF0}, /* (HANGUL SYLLABLE MYISS) */
    {{'\xeb', '\xaf', '\xb1'}, 3, 0xBBF1}, /* (HANGUL SYLLABLE MYING) */
    {{'\xeb', '\xaf', '\xb2'}, 3, 0xBBF2}, /* (HANGUL SYLLABLE MYIJ) */
    {{'\xeb', '\xaf', '\xb3'}, 3, 0xBBF3}, /* (HANGUL SYLLABLE MYIC) */
    {{'\xeb', '\xaf', '\xb4'}, 3, 0xBBF4}, /* (HANGUL SYLLABLE MYIK) */
    {{'\xeb', '\xaf', '\xb5'}, 3, 0xBBF5}, /* (HANGUL SYLLABLE MYIT) */
    {{'\xeb', '\xaf', '\xb6'}, 3, 0xBBF6}, /* (HANGUL SYLLABLE MYIP) */
    {{'\xeb', '\xaf', '\xb7'}, 3, 0xBBF7}, /* (HANGUL SYLLABLE MYIH) */
    {{'\xeb', '\xaf', '\xba'}, 3, 0xBBFA}, /* (HANGUL SYLLABLE MIGG) */
    {{'\xeb', '\xaf', '\xbb'}, 3, 0xBBFB}, /* (HANGUL SYLLABLE MIGS) */
    {{'\xeb', '\xaf', '\xbd'}, 3, 0xBBFD}, /* (HANGUL SYLLABLE MINJ) */
    {{'\xeb', '\xaf', '\xbe'}, 3, 0xBBFE}, /* (HANGUL SYLLABLE MINH) */
    {{'\xeb', '\xb0', '\x81'}, 3, 0xBC01}, /* (HANGUL SYLLABLE MILG) */
    {{'\xeb', '\xb0', '\x83'}, 3, 0xBC03}, /* (HANGUL SYLLABLE MILB) */
    {{'\xeb', '\xb0', '\x84'}, 3, 0xBC04}, /* (HANGUL SYLLABLE MILS) */
    {{'\xeb', '\xb0', '\x85'}, 3, 0xBC05}, /* (HANGUL SYLLABLE MILT) */
    {{'\xeb', '\xb0', '\x86'}, 3, 0xBC06}, /* (HANGUL SYLLABLE MILP) */
    {{'\xeb', '\xb0', '\x87'}, 3, 0xBC07}, /* (HANGUL SYLLABLE MILH) */
    {{'\xeb', '\xb0', '\x8a'}, 3, 0xBC0A}, /* (HANGUL SYLLABLE MIBS) */
    {{'\xeb', '\xb0', '\x8e'}, 3, 0xBC0E}, /* (HANGUL SYLLABLE MIJ) */
    {{'\xeb', '\xb0', '\x90'}, 3, 0xBC10}, /* (HANGUL SYLLABLE MIK) */
    {{'\xeb', '\xb0', '\x92'}, 3, 0xBC12}, /* (HANGUL SYLLABLE MIP) */
    {{'\xeb', '\xb0', '\x93'}, 3, 0xBC13}, /* (HANGUL SYLLABLE MIH) */
    {{'\xeb', '\xb0', '\x99'}, 3, 0xBC19}, /* (HANGUL SYLLABLE BANJ) */
    {{'\xeb', '\xb0', '\x9a'}, 3, 0xBC1A}, /* (HANGUL SYLLABLE BANH) */
    {{'\xeb', '\xb0', '\xa0'}, 3, 0xBC20}, /* (HANGUL SYLLABLE BALS) */
    {{'\xeb', '\xb0', '\xa1'}, 3, 0xBC21}, /* (HANGUL SYLLABLE BALT) */
    {{'\xeb', '\xb0', '\xa2'}, 3, 0xBC22}, /* (HANGUL SYLLABLE BALP) */
    {{'\xeb', '\xb0', '\xa3'}, 3, 0xBC23}, /* (HANGUL SYLLABLE BALH) */
    {{'\xeb', '\xb0', '\xa6'}, 3, 0xBC26}, /* (HANGUL SYLLABLE BABS) */
    {{'\xeb', '\xb0', '\xa8'}, 3, 0xBC28}, /* (HANGUL SYLLABLE BASS) */
    {{'\xeb', '\xb0', '\xaa'}, 3, 0xBC2A}, /* (HANGUL SYLLABLE BAJ) */
    {{'\xeb', '\xb0', '\xab'}, 3, 0xBC2B}, /* (HANGUL SYLLABLE BAC) */
    {{'\xeb', '\xb0', '\xac'}, 3, 0xBC2C}, /* (HANGUL SYLLABLE BAK) */
    {{'\xeb', '\xb0', '\xae'}, 3, 0xBC2E}, /* (HANGUL SYLLABLE BAP) */
    {{'\xeb', '\xb0', '\xaf'}, 3, 0xBC2F}, /* (HANGUL SYLLABLE BAH) */
    {{'\xeb', '\xb0', '\xb2'}, 3, 0xBC32}, /* (HANGUL SYLLABLE BAEGG) */
    {{'\xeb', '\xb0', '\xb3'}, 3, 0xBC33}, /* (HANGUL SYLLABLE BAEGS) */
    {{'\xeb', '\xb0', '\xb5'}, 3, 0xBC35}, /* (HANGUL SYLLABLE BAENJ) */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{'\xeb', '\xb0', '\xb6'}, 3, 0xBC36}, /* (HANGUL SYLLABLE BAENH) */
    {{'\xeb', '\xb0', '\xb7'}, 3, 0xBC37}, /* (HANGUL SYLLABLE BAED) */
    {{'\xeb', '\xb0', '\xb9'}, 3, 0xBC39}, /* (HANGUL SYLLABLE BAELG) */
    {{'\xeb', '\xb0', '\xba'}, 3, 0xBC3A}, /* (HANGUL SYLLABLE BAELM) */
    {{'\xeb', '\xb0', '\xbb'}, 3, 0xBC3B}, /* (HANGUL SYLLABLE BAELB) */
    {{'\xeb', '\xb0', '\xbc'}, 3, 0xBC3C}, /* (HANGUL SYLLABLE BAELS) */
    {{'\xeb', '\xb0', '\xbd'}, 3, 0xBC3D}, /* (HANGUL SYLLABLE BAELT) */
    {{'\xeb', '\xb0', '\xbe'}, 3, 0xBC3E}, /* (HANGUL SYLLABLE BAELP) */
    {{'\xeb', '\xb0', '\xbf'}, 3, 0xBC3F}, /* (HANGUL SYLLABLE BAELH) */
    {{'\xeb', '\xb1', '\x82'}, 3, 0xBC42}, /* (HANGUL SYLLABLE BAEBS) */
    {{'\xeb', '\xb1', '\x86'}, 3, 0xBC46}, /* (HANGUL SYLLABLE BAEJ) */
    {{'\xeb', '\xb1', '\x87'}, 3, 0xBC47}, /* (HANGUL SYLLABLE BAEC) */
    {{'\xeb', '\xb1', '\x88'}, 3, 0xBC48}, /* (HANGUL SYLLABLE BAEK) */
    {{'\xeb', '\xb1', '\x8a'}, 3, 0xBC4A}, /* (HANGUL SYLLABLE BAEP) */
    {{'\xeb', '\xb1', '\x8b'}, 3, 0xBC4B}, /* (HANGUL SYLLABLE BAEH) */
    {{'\xeb', '\xb1', '\x8e'}, 3, 0xBC4E}, /* (HANGUL SYLLABLE BYAGG) */
    {{'\xeb', '\xb1', '\x8f'}, 3, 0xBC4F}, /* (HANGUL SYLLABLE BYAGS) */
    {{'\xeb', '\xb1', '\x91'}, 3, 0xBC51}, /* (HANGUL SYLLABLE BYANJ) */
    {{'\xeb', '\xb1', '\x92'}, 3, 0xBC52}, /* (HANGUL SYLLABLE BYANH) */
    {{'\xeb', '\xb1', '\x93'}, 3, 0xBC53}, /* (HANGUL SYLLABLE BYAD) */
    {{'\xeb', '\xb1', '\x94'}, 3, 0xBC54}, /* (HANGUL SYLLABLE BYAL) */
    {{'\xeb', '\xb1', '\x95'}, 3, 0xBC55}, /* (HANGUL SYLLABLE BYALG) */
    {{'\xeb', '\xb1', '\x96'}, 3, 0xBC56}, /* (HANGUL SYLLABLE BYALM) */
    {{'\xeb', '\xb1', '\x97'}, 3, 0xBC57}, /* (HANGUL SYLLABLE BYALB) */
    {{'\xeb', '\xb1', '\x98'}, 3, 0xBC58}, /* (HANGUL SYLLABLE BYALS) */
    {{'\xeb', '\xb1', '\x99'}, 3, 0xBC59}, /* (HANGUL SYLLABLE BYALT) */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{'\xeb', '\xb1', '\x9a'}, 3, 0xBC5A}, /* (HANGUL SYLLABLE BYALP) */
    {{'\xeb', '\xb1', '\x9b'}, 3, 0xBC5B}, /* (HANGUL SYLLABLE BYALH) */
    {{'\xeb', '\xb1', '\x9c'}, 3, 0xBC5C}, /* (HANGUL SYLLABLE BYAM) */
    {{'\xeb', '\xb1', '\x9e'}, 3, 0xBC5E}, /* (HANGUL SYLLABLE BYABS) */
    {{'\xeb', '\xb1', '\x9f'}, 3, 0xBC5F}, /* (HANGUL SYLLABLE BYAS) */
    {{'\xeb', '\xb1', '\xa0'}, 3, 0xBC60}, /* (HANGUL SYLLABLE BYASS) */
    {{'\xeb', '\xb1', '\xa1'}, 3, 0xBC61}, /* (HANGUL SYLLABLE BYANG) */
    {{'\xeb', '\xb1', '\xa2'}, 3, 0xBC62}, /* (HANGUL SYLLABLE BYAJ) */
    {{'\xeb', '\xb1', '\xa3'}, 3, 0xBC63}, /* (HANGUL SYLLABLE BYAC) */
    {{'\xeb', '\xb1', '\xa4'}, 3, 0xBC64}, /* (HANGUL SYLLABLE BYAK) */
    {{'\xeb', '\xb1', '\xa5'}, 3, 0xBC65}, /* (HANGUL SYLLABLE BYAT) */
    {{'\xeb', '\xb1', '\xa6'}, 3, 0xBC66}, /* (HANGUL SYLLABLE BYAP) */
    {{'\xeb', '\xb1', '\xa7'}, 3, 0xBC67}, /* (HANGUL SYLLABLE BYAH) */
    {{'\xeb', '\xb1', '\xa8'}, 3, 0xBC68}, /* (HANGUL SYLLABLE BYAE) */
    {{'\xeb', '\xb1', '\xa9'}, 3, 0xBC69}, /* (HANGUL SYLLABLE BYAEG) */
    {{'\xeb', '\xb1', '\xaa'}, 3, 0xBC6A}, /* (HANGUL SYLLABLE BYAEGG) */
    {{'\xeb', '\xb1', '\xab'}, 3, 0xBC6B}, /* (HANGUL SYLLABLE BYAEGS) */
    {{'\xeb', '\xb1', '\xac'}, 3, 0xBC6C}, /* (HANGUL SYLLABLE BYAEN) */
    {{'\xeb', '\xb1', '\xad'}, 3, 0xBC6D}, /* (HANGUL SYLLABLE BYAENJ) */
    {{'\xeb', '\xb1', '\xae'}, 3, 0xBC6E}, /* (HANGUL SYLLABLE BYAENH) */
    {{'\xeb', '\xb1', '\xaf'}, 3, 0xBC6F}, /* (HANGUL SYLLABLE BYAED) */
    {{'\xeb', '\xb1', '\xb0'}, 3, 0xBC70}, /* (HANGUL SYLLABLE BYAEL) */
    {{'\xeb', '\xb1', '\xb1'}, 3, 0xBC71}, /* (HANGUL SYLLABLE BYAELG) */
    {{'\xeb', '\xb1', '\xb2'}, 3, 0xBC72}, /* (HANGUL SYLLABLE BYAELM) */
    {{'\xeb', '\xb1', '\xb3'}, 3, 0xBC73}, /* (HANGUL SYLLABLE BYAELB) */
    {{'\xeb', '\xb1', '\xb4'}, 3, 0xBC74}, /* (HANGUL SYLLABLE BYAELS) */
    {{'\xeb', '\xb1', '\xb5'}, 3, 0xBC75}, /* (HANGUL SYLLABLE BYAELT) */
    {{'\xeb', '\xb1', '\xb6'}, 3, 0xBC76}, /* (HANGUL SYLLABLE BYAELP) */
    {{'\xeb', '\xb1', '\xb7'}, 3, 0xBC77}, /* (HANGUL SYLLABLE BYAELH) */
    {{'\xeb', '\xb1', '\xb8'}, 3, 0xBC78}, /* (HANGUL SYLLABLE BYAEM) */
    {{'\xeb', '\xb1', '\xb9'}, 3, 0xBC79}, /* (HANGUL SYLLABLE BYAEB) */
    {{'\xeb', '\xb1', '\xba'}, 3, 0xBC7A}, /* (HANGUL SYLLABLE BYAEBS) */
    {{'\xeb', '\xb1', '\xbb'}, 3, 0xBC7B}, /* (HANGUL SYLLABLE BYAES) */
    {{'\xeb', '\xb1', '\xbc'}, 3, 0xBC7C}, /* (HANGUL SYLLABLE BYAESS) */
    {{'\xeb', '\xb1', '\xbd'}, 3, 0xBC7D}, /* (HANGUL SYLLABLE BYAENG) */
    {{'\xeb', '\xb1', '\xbe'}, 3, 0xBC7E}, /* (HANGUL SYLLABLE BYAEJ) */
    {{'\xeb', '\xb1', '\xbf'}, 3, 0xBC7F}, /* (HANGUL SYLLABLE BYAEC) */
    {{'\xeb', '\xb2', '\x80'}, 3, 0xBC80}, /* (HANGUL SYLLABLE BYAEK) */
    {{'\xeb', '\xb2', '\x81'}, 3, 0xBC81}, /* (HANGUL SYLLABLE BYAET) */
    {{'\xeb', '\xb2', '\x82'}, 3, 0xBC82}, /* (HANGUL SYLLABLE BYAEP) */
    {{'\xeb', '\xb2', '\x83'}, 3, 0xBC83}, /* (HANGUL SYLLABLE BYAEH) */
    {{'\xeb', '\xb2', '\x86'}, 3, 0xBC86}, /* (HANGUL SYLLABLE BEOGG) */
    {{'\xeb', '\xb2', '\x87'}, 3, 0xBC87}, /* (HANGUL SYLLABLE BEOGS) */
    {{'\xeb', '\xb2', '\x89'}, 3, 0xBC89}, /* (HANGUL SYLLABLE BEONJ) */
    {{'\xeb', '\xb2', '\x8a'}, 3, 0xBC8A}, /* (HANGUL SYLLABLE BEONH) */
    {{'\xeb', '\xb2', '\x8d'}, 3, 0xBC8D}, /* (HANGUL SYLLABLE BEOLG) */
    {{'\xeb', '\xb2', '\x8f'}, 3, 0xBC8F}, /* (HANGUL SYLLABLE BEOLB) */
    {{'\xeb', '\xb2', '\x90'}, 3, 0xBC90}, /* (HANGUL SYLLABLE BEOLS) */
    {{'\xeb', '\xb2', '\x91'}, 3, 0xBC91}, /* (HANGUL SYLLABLE BEOLT) */
    {{'\xeb', '\xb2', '\x92'}, 3, 0xBC92}, /* (HANGUL SYLLABLE BEOLP) */
    {{'\xeb', '\xb2', '\x93'}, 3, 0xBC93}, /* (HANGUL SYLLABLE BEOLH) */
    {{'\xeb', '\xb2', '\x96'}, 3, 0xBC96}, /* (HANGUL SYLLABLE BEOBS) */
    {{'\xeb', '\xb2', '\x98'}, 3, 0xBC98}, /* (HANGUL SYLLABLE BEOSS) */
    {{'\xeb', '\xb2', '\x9b'}, 3, 0xBC9B}, /* (HANGUL SYLLABLE BEOC) */
    {{'\xeb', '\xb2', '\x9c'}, 3, 0xBC9C}, /* (HANGUL SYLLABLE BEOK) */
    {{'\xeb', '\xb2', '\x9d'}, 3, 0xBC9D}, /* (HANGUL SYLLABLE BEOT) */
    {{'\xeb', '\xb2', '\x9e'}, 3, 0xBC9E}, /* (HANGUL SYLLABLE BEOP) */
    {{'\xeb', '\xb2', '\x9f'}, 3, 0xBC9F}, /* (HANGUL SYLLABLE BEOH) */
    {{'\xeb', '\xb2', '\xa2'}, 3, 0xBCA2}, /* (HANGUL SYLLABLE BEGG) */
    {{'\xeb', '\xb2', '\xa3'}, 3, 0xBCA3}, /* (HANGUL SYLLABLE BEGS) */
    {{'\xeb', '\xb2', '\xa5'}, 3, 0xBCA5}, /* (HANGUL SYLLABLE BENJ) */
    {{'\xeb', '\xb2', '\xa6'}, 3, 0xBCA6}, /* (HANGUL SYLLABLE BENH) */
    {{'\xeb', '\xb2', '\xa9'}, 3, 0xBCA9}, /* (HANGUL SYLLABLE BELG) */
    {{'\xeb', '\xb2', '\xaa'}, 3, 0xBCAA}, /* (HANGUL SYLLABLE BELM) */
    {{'\xeb', '\xb2', '\xab'}, 3, 0xBCAB}, /* (HANGUL SYLLABLE BELB) */
    {{'\xeb', '\xb2', '\xac'}, 3, 0xBCAC}, /* (HANGUL SYLLABLE BELS) */
    {{'\xeb', '\xb2', '\xad'}, 3, 0xBCAD}, /* (HANGUL SYLLABLE BELT) */
    {{'\xeb', '\xb2', '\xae'}, 3, 0xBCAE}, /* (HANGUL SYLLABLE BELP) */
    {{'\xeb', '\xb2', '\xaf'}, 3, 0xBCAF}, /* (HANGUL SYLLABLE BELH) */
    {{'\xeb', '\xb2', '\xb2'}, 3, 0xBCB2}, /* (HANGUL SYLLABLE BEBS) */
    {{'\xeb', '\xb2', '\xb6'}, 3, 0xBCB6}, /* (HANGUL SYLLABLE BEJ) */
    {{'\xeb', '\xb2', '\xb7'}, 3, 0xBCB7}, /* (HANGUL SYLLABLE BEC) */
    {{'\xeb', '\xb2', '\xb8'}, 3, 0xBCB8}, /* (HANGUL SYLLABLE BEK) */
    {{'\xeb', '\xb2', '\xb9'}, 3, 0xBCB9}, /* (HANGUL SYLLABLE BET) */
    {{'\xeb', '\xb2', '\xba'}, 3, 0xBCBA}, /* (HANGUL SYLLABLE BEP) */
    {{'\xeb', '\xb2', '\xbb'}, 3, 0xBCBB}, /* (HANGUL SYLLABLE BEH) */
    {{'\xeb', '\xb2', '\xbe'}, 3, 0xBCBE}, /* (HANGUL SYLLABLE BYEOGG) */
    {{'\xeb', '\xb2', '\xbf'}, 3, 0xBCBF}, /* (HANGUL SYLLABLE BYEOGS) */
    {{'\xeb', '\xb3', '\x81'}, 3, 0xBCC1}, /* (HANGUL SYLLABLE BYEONJ) */
    {{'\xeb', '\xb3', '\x82'}, 3, 0xBCC2}, /* (HANGUL SYLLABLE BYEONH) */
    {{'\xeb', '\xb3', '\x83'}, 3, 0xBCC3}, /* (HANGUL SYLLABLE BYEOD) */
    {{'\xeb', '\xb3', '\x85'}, 3, 0xBCC5}, /* (HANGUL SYLLABLE BYEOLG) */
    {{'\xeb', '\xb3', '\x86'}, 3, 0xBCC6}, /* (HANGUL SYLLABLE BYEOLM) */
    {{'\xeb', '\xb3', '\x87'}, 3, 0xBCC7}, /* (HANGUL SYLLABLE BYEOLB) */
    {{'\xeb', '\xb3', '\x88'}, 3, 0xBCC8}, /* (HANGUL SYLLABLE BYEOLS) */
    {{'\xeb', '\xb3', '\x89'}, 3, 0xBCC9}, /* (HANGUL SYLLABLE BYEOLT) */
    {{'\xeb', '\xb3', '\x8a'}, 3, 0xBCCA}, /* (HANGUL SYLLABLE BYEOLP) */
    {{'\xeb', '\xb3', '\x8b'}, 3, 0xBCCB}, /* (HANGUL SYLLABLE BYEOLH) */
    {{'\xeb', '\xb3', '\x8c'}, 3, 0xBCCC}, /* (HANGUL SYLLABLE BYEOM) */
    {{'\xeb', '\xb3', '\x8e'}, 3, 0xBCCE}, /* (HANGUL SYLLABLE BYEOBS) */
    {{'\xeb', '\xb3', '\x92'}, 3, 0xBCD2}, /* (HANGUL SYLLABLE BYEOJ) */
    {{'\xeb', '\xb3', '\x93'}, 3, 0xBCD3}, /* (HANGUL SYLLABLE BYEOC) */
    {{'\xeb', '\xb3', '\x94'}, 3, 0xBCD4}, /* (HANGUL SYLLABLE BYEOK) */
    {{'\xeb', '\xb3', '\x96'}, 3, 0xBCD6}, /* (HANGUL SYLLABLE BYEOP) */
    {{'\xeb', '\xb3', '\x97'}, 3, 0xBCD7}, /* (HANGUL SYLLABLE BYEOH) */
    {{'\xeb', '\xb3', '\x99'}, 3, 0xBCD9}, /* (HANGUL SYLLABLE BYEG) */
    {{'\xeb', '\xb3', '\x9a'}, 3, 0xBCDA}, /* (HANGUL SYLLABLE BYEGG) */
    {{'\xeb', '\xb3', '\x9b'}, 3, 0xBCDB}, /* (HANGUL SYLLABLE BYEGS) */
    {{'\xeb', '\xb3', '\x9d'}, 3, 0xBCDD}, /* (HANGUL SYLLABLE BYENJ) */
    {{'\xeb', '\xb3', '\x9e'}, 3, 0xBCDE}, /* (HANGUL SYLLABLE BYENH) */
    {{'\xeb', '\xb3', '\x9f'}, 3, 0xBCDF}, /* (HANGUL SYLLABLE BYED) */
    {{'\xeb', '\xb3', '\xa0'}, 3, 0xBCE0}, /* (HANGUL SYLLABLE BYEL) */
    {{'\xeb', '\xb3', '\xa1'}, 3, 0xBCE1}, /* (HANGUL SYLLABLE BYELG) */
    {{'\xeb', '\xb3', '\xa2'}, 3, 0xBCE2}, /* (HANGUL SYLLABLE BYELM) */
    {{'\xeb', '\xb3', '\xa3'}, 3, 0xBCE3}, /* (HANGUL SYLLABLE BYELB) */
    {{'\xeb', '\xb3', '\xa4'}, 3, 0xBCE4}, /* (HANGUL SYLLABLE BYELS) */
    {{'\xeb', '\xb3', '\xa5'}, 3, 0xBCE5}, /* (HANGUL SYLLABLE BYELT) */
    {{'\xeb', '\xb3', '\xa6'}, 3, 0xBCE6}, /* (HANGUL SYLLABLE BYELP) */
    {{'\xeb', '\xb3', '\xa7'}, 3, 0xBCE7}, /* (HANGUL SYLLABLE BYELH) */
    {{'\xeb', '\xb3', '\xa8'}, 3, 0xBCE8}, /* (HANGUL SYLLABLE BYEM) */
    {{'\xeb', '\xb3', '\xa9'}, 3, 0xBCE9}, /* (HANGUL SYLLABLE BYEB) */
    {{'\xeb', '\xb3', '\xaa'}, 3, 0xBCEA}, /* (HANGUL SYLLABLE BYEBS) */
    {{'\xeb', '\xb3', '\xab'}, 3, 0xBCEB}, /* (HANGUL SYLLABLE BYES) */
    {{'\xeb', '\xb3', '\xac'}, 3, 0xBCEC}, /* (HANGUL SYLLABLE BYESS) */
    {{'\xeb', '\xb3', '\xad'}, 3, 0xBCED}, /* (HANGUL SYLLABLE BYENG) */
    {{'\xeb', '\xb3', '\xae'}, 3, 0xBCEE}, /* (HANGUL SYLLABLE BYEJ) */
    {{'\xeb', '\xb3', '\xaf'}, 3, 0xBCEF}, /* (HANGUL SYLLABLE BYEC) */
    {{'\xeb', '\xb3', '\xb0'}, 3, 0xBCF0}, /* (HANGUL SYLLABLE BYEK) */
    {{'\xeb', '\xb3', '\xb1'}, 3, 0xBCF1}, /* (HANGUL SYLLABLE BYET) */
    {{'\xeb', '\xb3', '\xb2'}, 3, 0xBCF2}, /* (HANGUL SYLLABLE BYEP) */
    {{'\xeb', '\xb3', '\xb3'}, 3, 0xBCF3}, /* (HANGUL SYLLABLE BYEH) */
    {{'\xeb', '\xb3', '\xb7'}, 3, 0xBCF7}, /* (HANGUL SYLLABLE BOGS) */
    {{'\xeb', '\xb3', '\xb9'}, 3, 0xBCF9}, /* (HANGUL SYLLABLE BONJ) */
    {{'\xeb', '\xb3', '\xba'}, 3, 0xBCFA}, /* (HANGUL SYLLABLE BONH) */
    {{'\xeb', '\xb3', '\xbb'}, 3, 0xBCFB}, /* (HANGUL SYLLABLE BOD) */
    {{'\xeb', '\xb3', '\xbd'}, 3, 0xBCFD}, /* (HANGUL SYLLABLE BOLG) */
    {{'\xeb', '\xb3', '\xbe'}, 3, 0xBCFE}, /* (HANGUL SYLLABLE BOLM) */
    {{'\xeb', '\xb3', '\xbf'}, 3, 0xBCFF}, /* (HANGUL SYLLABLE BOLB) */
    {{'\xeb', '\xb4', '\x80'}, 3, 0xBD00}, /* (HANGUL SYLLABLE BOLS) */
    {{'\xeb', '\xb4', '\x81'}, 3, 0xBD01}, /* (HANGUL SYLLABLE BOLT) */
    {{'\xeb', '\xb4', '\x82'}, 3, 0xBD02}, /* (HANGUL SYLLABLE BOLP) */
    {{'\xeb', '\xb4', '\x83'}, 3, 0xBD03}, /* (HANGUL SYLLABLE BOLH) */
    {{'\xeb', '\xb4', '\x86'}, 3, 0xBD06}, /* (HANGUL SYLLABLE BOBS) */
    {{'\xeb', '\xb4', '\x88'}, 3, 0xBD08}, /* (HANGUL SYLLABLE BOSS) */
    {{'\xeb', '\xb4', '\x8a'}, 3, 0xBD0A}, /* (HANGUL SYLLABLE BOJ) */
    {{'\xeb', '\xb4', '\x8b'}, 3, 0xBD0B}, /* (HANGUL SYLLABLE BOC) */
    {{'\xeb', '\xb4', '\x8c'}, 3, 0xBD0C}, /* (HANGUL SYLLABLE BOK) */
    {{'\xeb', '\xb4', '\x8d'}, 3, 0xBD0D}, /* (HANGUL SYLLABLE BOT) */
    {{'\xeb', '\xb4', '\x8e'}, 3, 0xBD0E}, /* (HANGUL SYLLABLE BOP) */
    {{'\xeb', '\xb4', '\x8f'}, 3, 0xBD0F}, /* (HANGUL SYLLABLE BOH) */
    {{'\xeb', '\xb4', '\x91'}, 3, 0xBD11}, /* (HANGUL SYLLABLE BWAG) */
    {{'\xeb', '\xb4', '\x92'}, 3, 0xBD12}, /* (HANGUL SYLLABLE BWAGG) */
    {{'\xeb', '\xb4', '\x93'}, 3, 0xBD13}, /* (HANGUL SYLLABLE BWAGS) */
    {{'\xeb', '\xb4', '\x95'}, 3, 0xBD15}, /* (HANGUL SYLLABLE BWANJ) */
    {{'\xeb', '\xb4', '\x96'}, 3, 0xBD16}, /* (HANGUL SYLLABLE BWANH) */
    {{'\xeb', '\xb4', '\x97'}, 3, 0xBD17}, /* (HANGUL SYLLABLE BWAD) */
    {{'\xeb', '\xb4', '\x98'}, 3, 0xBD18}, /* (HANGUL SYLLABLE BWAL) */
    {{'\xeb', '\xb4', '\x99'}, 3, 0xBD19}, /* (HANGUL SYLLABLE BWALG) */
    {{'\xeb', '\xb4', '\x9a'}, 3, 0xBD1A}, /* (HANGUL SYLLABLE BWALM) */
    {{'\xeb', '\xb4', '\x9b'}, 3, 0xBD1B}, /* (HANGUL SYLLABLE BWALB) */
    {{'\xeb', '\xb4', '\x9c'}, 3, 0xBD1C}, /* (HANGUL SYLLABLE BWALS) */
    {{'\xeb', '\xb4', '\x9d'}, 3, 0xBD1D}, /* (HANGUL SYLLABLE BWALT) */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{'\xeb', '\xb4', '\x9e'}, 3, 0xBD1E}, /* (HANGUL SYLLABLE BWALP) */
    {{'\xeb', '\xb4', '\x9f'}, 3, 0xBD1F}, /* (HANGUL SYLLABLE BWALH) */
    {{'\xeb', '\xb4', '\xa0'}, 3, 0xBD20}, /* (HANGUL SYLLABLE BWAM) */
    {{'\xeb', '\xb4', '\xa1'}, 3, 0xBD21}, /* (HANGUL SYLLABLE BWAB) */
    {{'\xeb', '\xb4', '\xa2'}, 3, 0xBD22}, /* (HANGUL SYLLABLE BWABS) */
    {{'\xeb', '\xb4', '\xa3'}, 3, 0xBD23}, /* (HANGUL SYLLABLE BWAS) */
    {{'\xeb', '\xb4', '\xa5'}, 3, 0xBD25}, /* (HANGUL SYLLABLE BWANG) */
    {{'\xeb', '\xb4', '\xa6'}, 3, 0xBD26}, /* (HANGUL SYLLABLE BWAJ) */
    {{'\xeb', '\xb4', '\xa7'}, 3, 0xBD27}, /* (HANGUL SYLLABLE BWAC) */
    {{'\xeb', '\xb4', '\xa8'}, 3, 0xBD28}, /* (HANGUL SYLLABLE BWAK) */
    {{'\xeb', '\xb4', '\xa9'}, 3, 0xBD29}, /* (HANGUL SYLLABLE BWAT) */
    {{'\xeb', '\xb4', '\xaa'}, 3, 0xBD2A}, /* (HANGUL SYLLABLE BWAP) */
    {{'\xeb', '\xb4', '\xab'}, 3, 0xBD2B}, /* (HANGUL SYLLABLE BWAH) */
    {{'\xeb', '\xb4', '\xad'}, 3, 0xBD2D}, /* (HANGUL SYLLABLE BWAEG) */
    {{'\xeb', '\xb4', '\xae'}, 3, 0xBD2E}, /* (HANGUL SYLLABLE BWAEGG) */
    {{'\xeb', '\xb4', '\xaf'}, 3, 0xBD2F}, /* (HANGUL SYLLABLE BWAEGS) */
    {{'\xeb', '\xb4', '\xb0'}, 3, 0xBD30}, /* (HANGUL SYLLABLE BWAEN) */
    {{'\xeb', '\xb4', '\xb1'}, 3, 0xBD31}, /* (HANGUL SYLLABLE BWAENJ) */
    {{'\xeb', '\xb4', '\xb2'}, 3, 0xBD32}, /* (HANGUL SYLLABLE BWAENH) */
    {{'\xeb', '\xb4', '\xb3'}, 3, 0xBD33}, /* (HANGUL SYLLABLE BWAED) */
    {{'\xeb', '\xb4', '\xb4'}, 3, 0xBD34}, /* (HANGUL SYLLABLE BWAEL) */
    {{'\xeb', '\xb4', '\xb5'}, 3, 0xBD35}, /* (HANGUL SYLLABLE BWAELG) */
    {{'\xeb', '\xb4', '\xb6'}, 3, 0xBD36}, /* (HANGUL SYLLABLE BWAELM) */
    {{'\xeb', '\xb4', '\xb7'}, 3, 0xBD37}, /* (HANGUL SYLLABLE BWAELB) */
    {{'\xeb', '\xb4', '\xb8'}, 3, 0xBD38}, /* (HANGUL SYLLABLE BWAELS) */
    {{'\xeb', '\xb4', '\xb9'}, 3, 0xBD39}, /* (HANGUL SYLLABLE BWAELT) */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{'\xeb', '\xb4', '\xba'}, 3, 0xBD3A}, /* (HANGUL SYLLABLE BWAELP) */
    {{'\xeb', '\xb4', '\xbb'}, 3, 0xBD3B}, /* (HANGUL SYLLABLE BWAELH) */
    {{'\xeb', '\xb4', '\xbc'}, 3, 0xBD3C}, /* (HANGUL SYLLABLE BWAEM) */
    {{'\xeb', '\xb4', '\xbd'}, 3, 0xBD3D}, /* (HANGUL SYLLABLE BWAEB) */
    {{'\xeb', '\xb4', '\xbe'}, 3, 0xBD3E}, /* (HANGUL SYLLABLE BWAEBS) */
    {{'\xeb', '\xb4', '\xbf'}, 3, 0xBD3F}, /* (HANGUL SYLLABLE BWAES) */
    {{'\xeb', '\xb5', '\x81'}, 3, 0xBD41}, /* (HANGUL SYLLABLE BWAENG) */
    {{'\xeb', '\xb5', '\x82'}, 3, 0xBD42}, /* (HANGUL SYLLABLE BWAEJ) */
    {{'\xeb', '\xb5', '\x83'}, 3, 0xBD43}, /* (HANGUL SYLLABLE BWAEC) */
    {{'\xeb', '\xb5', '\x84'}, 3, 0xBD44}, /* (HANGUL SYLLABLE BWAEK) */
    {{'\xeb', '\xb5', '\x85'}, 3, 0xBD45}, /* (HANGUL SYLLABLE BWAET) */
    {{'\xeb', '\xb5', '\x86'}, 3, 0xBD46}, /* (HANGUL SYLLABLE BWAEP) */
    {{'\xeb', '\xb5', '\x87'}, 3, 0xBD47}, /* (HANGUL SYLLABLE BWAEH) */
    {{'\xeb', '\xb5', '\x8a'}, 3, 0xBD4A}, /* (HANGUL SYLLABLE BOEGG) */
    {{'\xeb', '\xb5', '\x8b'}, 3, 0xBD4B}, /* (HANGUL SYLLABLE BOEGS) */
    {{'\xeb', '\xb5', '\x8d'}, 3, 0xBD4D}, /* (HANGUL SYLLABLE BOENJ) */
    {{'\xeb', '\xb5', '\x8e'}, 3, 0xBD4E}, /* (HANGUL SYLLABLE BOENH) */
    {{'\xeb', '\xb5', '\x8f'}, 3, 0xBD4F}, /* (HANGUL SYLLABLE BOED) */
    {{'\xeb', '\xb5', '\x91'}, 3, 0xBD51}, /* (HANGUL SYLLABLE BOELG) */
    {{'\xeb', '\xb5', '\x92'}, 3, 0xBD52}, /* (HANGUL SYLLABLE BOELM) */
    {{'\xeb', '\xb5', '\x93'}, 3, 0xBD53}, /* (HANGUL SYLLABLE BOELB) */
    {{'\xeb', '\xb5', '\x94'}, 3, 0xBD54}, /* (HANGUL SYLLABLE BOELS) */
    {{'\xeb', '\xb5', '\x95'}, 3, 0xBD55}, /* (HANGUL SYLLABLE BOELT) */
    {{'\xeb', '\xb5', '\x96'}, 3, 0xBD56}, /* (HANGUL SYLLABLE BOELP) */
    {{'\xeb', '\xb5', '\x97'}, 3, 0xBD57}, /* (HANGUL SYLLABLE BOELH) */
    {{'\xeb', '\xb5', '\x9a'}, 3, 0xBD5A}, /* (HANGUL SYLLABLE BOEBS) */
    {{'\xeb', '\xb5', '\x9b'}, 3, 0xBD5B}, /* (HANGUL SYLLABLE BOES) */
    {{'\xeb', '\xb5', '\x9c'}, 3, 0xBD5C}, /* (HANGUL SYLLABLE BOESS) */
    {{'\xeb', '\xb5', '\x9d'}, 3, 0xBD5D}, /* (HANGUL SYLLABLE BOENG) */
    {{'\xeb', '\xb5', '\x9e'}, 3, 0xBD5E}, /* (HANGUL SYLLABLE BOEJ) */
    {{'\xeb', '\xb5', '\x9f'}, 3, 0xBD5F}, /* (HANGUL SYLLABLE BOEC) */
    {{'\xeb', '\xb5', '\xa0'}, 3, 0xBD60}, /* (HANGUL SYLLABLE BOEK) */
    {{'\xeb', '\xb5', '\xa1'}, 3, 0xBD61}, /* (HANGUL SYLLABLE BOET) */
    {{'\xeb', '\xb5', '\xa2'}, 3, 0xBD62}, /* (HANGUL SYLLABLE BOEP) */
    {{'\xeb', '\xb5', '\xa3'}, 3, 0xBD63}, /* (HANGUL SYLLABLE BOEH) */
    {{'\xeb', '\xb5', '\xa5'}, 3, 0xBD65}, /* (HANGUL SYLLABLE BYOG) */
    {{'\xeb', '\xb5', '\xa6'}, 3, 0xBD66}, /* (HANGUL SYLLABLE BYOGG) */
    {{'\xeb', '\xb5', '\xa7'}, 3, 0xBD67}, /* (HANGUL SYLLABLE BYOGS) */
    {{'\xeb', '\xb5', '\xa9'}, 3, 0xBD69}, /* (HANGUL SYLLABLE BYONJ) */
    {{'\xeb', '\xb5', '\xaa'}, 3, 0xBD6A}, /* (HANGUL SYLLABLE BYONH) */
    {{'\xeb', '\xb5', '\xab'}, 3, 0xBD6B}, /* (HANGUL SYLLABLE BYOD) */
    {{'\xeb', '\xb5', '\xac'}, 3, 0xBD6C}, /* (HANGUL SYLLABLE BYOL) */
    {{'\xeb', '\xb5', '\xad'}, 3, 0xBD6D}, /* (HANGUL SYLLABLE BYOLG) */
    {{'\xeb', '\xb5', '\xae'}, 3, 0xBD6E}, /* (HANGUL SYLLABLE BYOLM) */
    {{'\xeb', '\xb5', '\xaf'}, 3, 0xBD6F}, /* (HANGUL SYLLABLE BYOLB) */
    {{'\xeb', '\xb5', '\xb0'}, 3, 0xBD70}, /* (HANGUL SYLLABLE BYOLS) */
    {{'\xeb', '\xb5', '\xb1'}, 3, 0xBD71}, /* (HANGUL SYLLABLE BYOLT) */
    {{'\xeb', '\xb5', '\xb2'}, 3, 0xBD72}, /* (HANGUL SYLLABLE BYOLP) */
    {{'\xeb', '\xb5', '\xb3'}, 3, 0xBD73}, /* (HANGUL SYLLABLE BYOLH) */
    {{'\xeb', '\xb5', '\xb4'}, 3, 0xBD74}, /* (HANGUL SYLLABLE BYOM) */
    {{'\xeb', '\xb5', '\xb5'}, 3, 0xBD75}, /* (HANGUL SYLLABLE BYOB) */
    {{'\xeb', '\xb5', '\xb6'}, 3, 0xBD76}, /* (HANGUL SYLLABLE BYOBS) */
    {{'\xeb', '\xb5', '\xb7'}, 3, 0xBD77}, /* (HANGUL SYLLABLE BYOS) */
    {{'\xeb', '\xb5', '\xb8'}, 3, 0xBD78}, /* (HANGUL SYLLABLE BYOSS) */
    {{'\xeb', '\xb5', '\xb9'}, 3, 0xBD79}, /* (HANGUL SYLLABLE BYONG) */
    {{'\xeb', '\xb5', '\xba'}, 3, 0xBD7A}, /* (HANGUL SYLLABLE BYOJ) */
    {{'\xeb', '\xb5', '\xbb'}, 3, 0xBD7B}, /* (HANGUL SYLLABLE BYOC) */
    {{'\xeb', '\xb5', '\xbc'}, 3, 0xBD7C}, /* (HANGUL SYLLABLE BYOK) */
    {{'\xeb', '\xb5', '\xbd'}, 3, 0xBD7D}, /* (HANGUL SYLLABLE BYOT) */
    {{'\xeb', '\xb5', '\xbe'}, 3, 0xBD7E}, /* (HANGUL SYLLABLE BYOP) */
    {{'\xeb', '\xb5', '\xbf'}, 3, 0xBD7F}, /* (HANGUL SYLLABLE BYOH) */
    {{'\xeb', '\xb6', '\x82'}, 3, 0xBD82}, /* (HANGUL SYLLABLE BUGG) */
    {{'\xeb', '\xb6', '\x83'}, 3, 0xBD83}, /* (HANGUL SYLLABLE BUGS) */
    {{'\xeb', '\xb6', '\x85'}, 3, 0xBD85}, /* (HANGUL SYLLABLE BUNJ) */
    {{'\xeb', '\xb6', '\x86'}, 3, 0xBD86}, /* (HANGUL SYLLABLE BUNH) */
    {{'\xeb', '\xb6', '\x8b'}, 3, 0xBD8B}, /* (HANGUL SYLLABLE BULB) */
    {{'\xeb', '\xb6', '\x8c'}, 3, 0xBD8C}, /* (HANGUL SYLLABLE BULS) */
    {{'\xeb', '\xb6', '\x8d'}, 3, 0xBD8D}, /* (HANGUL SYLLABLE BULT) */
    {{'\xeb', '\xb6', '\x8e'}, 3, 0xBD8E}, /* (HANGUL SYLLABLE BULP) */
    {{'\xeb', '\xb6', '\x8f'}, 3, 0xBD8F}, /* (HANGUL SYLLABLE BULH) */
    {{'\xeb', '\xb6', '\x92'}, 3, 0xBD92}, /* (HANGUL SYLLABLE BUBS) */
    {{'\xeb', '\xb6', '\x94'}, 3, 0xBD94}, /* (HANGUL SYLLABLE BUSS) */
    {{'\xeb', '\xb6', '\x96'}, 3, 0xBD96}, /* (HANGUL SYLLABLE BUJ) */
    {{'\xeb', '\xb6', '\x97'}, 3, 0xBD97}, /* (HANGUL SYLLABLE BUC) */
    {{'\xeb', '\xb6', '\x98'}, 3, 0xBD98}, /* (HANGUL SYLLABLE BUK) */
    {{'\xeb', '\xb6', '\x9b'}, 3, 0xBD9B}, /* (HANGUL SYLLABLE BUH) */
    {{'\xeb', '\xb6', '\x9d'}, 3, 0xBD9D}, /* (HANGUL SYLLABLE BWEOG) */
    {{'\xeb', '\xb6', '\x9e'}, 3, 0xBD9E}, /* (HANGUL SYLLABLE BWEOGG) */
    {{'\xeb', '\xb6', '\x9f'}, 3, 0xBD9F}, /* (HANGUL SYLLABLE BWEOGS) */
    {{'\xeb', '\xb6', '\xa0'}, 3, 0xBDA0}, /* (HANGUL SYLLABLE BWEON) */
    {{'\xeb', '\xb6', '\xa1'}, 3, 0xBDA1}, /* (HANGUL SYLLABLE BWEONJ) */
    {{'\xeb', '\xb6', '\xa2'}, 3, 0xBDA2}, /* (HANGUL SYLLABLE BWEONH) */
    {{'\xeb', '\xb6', '\xa3'}, 3, 0xBDA3}, /* (HANGUL SYLLABLE BWEOD) */
    {{'\xeb', '\xb6', '\xa5'}, 3, 0xBDA5}, /* (HANGUL SYLLABLE BWEOLG) */
    {{'\xeb', '\xb6', '\xa6'}, 3, 0xBDA6}, /* (HANGUL SYLLABLE BWEOLM) */
    {{'\xeb', '\xb6', '\xa7'}, 3, 0xBDA7}, /* (HANGUL SYLLABLE BWEOLB) */
    {{'\xeb', '\xb6', '\xa8'}, 3, 0xBDA8}, /* (HANGUL SYLLABLE BWEOLS) */
    {{'\xeb', '\xb6', '\xa9'}, 3, 0xBDA9}, /* (HANGUL SYLLABLE BWEOLT) */
    {{'\xeb', '\xb6', '\xaa'}, 3, 0xBDAA}, /* (HANGUL SYLLABLE BWEOLP) */
    {{'\xeb', '\xb6', '\xab'}, 3, 0xBDAB}, /* (HANGUL SYLLABLE BWEOLH) */
    {{'\xeb', '\xb6', '\xac'}, 3, 0xBDAC}, /* (HANGUL SYLLABLE BWEOM) */
    {{'\xeb', '\xb6', '\xad'}, 3, 0xBDAD}, /* (HANGUL SYLLABLE BWEOB) */
    {{'\xeb', '\xb6', '\xae'}, 3, 0xBDAE}, /* (HANGUL SYLLABLE BWEOBS) */
    {{'\xeb', '\xb6', '\xaf'}, 3, 0xBDAF}, /* (HANGUL SYLLABLE BWEOS) */
    {{'\xeb', '\xb6', '\xb1'}, 3, 0xBDB1}, /* (HANGUL SYLLABLE BWEONG) */
    {{'\xeb', '\xb6', '\xb2'}, 3, 0xBDB2}, /* (HANGUL SYLLABLE BWEOJ) */
    {{'\xeb', '\xb6', '\xb3'}, 3, 0xBDB3}, /* (HANGUL SYLLABLE BWEOC) */
    {{'\xeb', '\xb6', '\xb4'}, 3, 0xBDB4}, /* (HANGUL SYLLABLE BWEOK) */
    {{'\xeb', '\xb6', '\xb5'}, 3, 0xBDB5}, /* (HANGUL SYLLABLE BWEOT) */
    {{'\xeb', '\xb6', '\xb6'}, 3, 0xBDB6}, /* (HANGUL SYLLABLE BWEOP) */
    {{'\xeb', '\xb6', '\xb7'}, 3, 0xBDB7}, /* (HANGUL SYLLABLE BWEOH) */
    {{'\xeb', '\xb6', '\xb9'}, 3, 0xBDB9}, /* (HANGUL SYLLABLE BWEG) */
    {{'\xeb', '\xb6', '\xba'}, 3, 0xBDBA}, /* (HANGUL SYLLABLE BWEGG) */
    {{'\xeb', '\xb6', '\xbb'}, 3, 0xBDBB}, /* (HANGUL SYLLABLE BWEGS) */
    {{'\xeb', '\xb6', '\xbc'}, 3, 0xBDBC}, /* (HANGUL SYLLABLE BWEN) */
    {{'\xeb', '\xb6', '\xbd'}, 3, 0xBDBD}, /* (HANGUL SYLLABLE BWENJ) */
    {{'\xeb', '\xb6', '\xbe'}, 3, 0xBDBE}, /* (HANGUL SYLLABLE BWENH) */
    {{'\xeb', '\xb6', '\xbf'}, 3, 0xBDBF}, /* (HANGUL SYLLABLE BWED) */
    {{'\xeb', '\xb7', '\x80'}, 3, 0xBDC0}, /* (HANGUL SYLLABLE BWEL) */
    {{'\xeb', '\xb7', '\x81'}, 3, 0xBDC1}, /* (HANGUL SYLLABLE BWELG) */
    {{'\xeb', '\xb7', '\x82'}, 3, 0xBDC2}, /* (HANGUL SYLLABLE BWELM) */
    {{'\xeb', '\xb7', '\x83'}, 3, 0xBDC3}, /* (HANGUL SYLLABLE BWELB) */
    {{'\xeb', '\xb7', '\x84'}, 3, 0xBDC4}, /* (HANGUL SYLLABLE BWELS) */
    {{'\xeb', '\xb7', '\x85'}, 3, 0xBDC5}, /* (HANGUL SYLLABLE BWELT) */
    {{'\xeb', '\xb7', '\x86'}, 3, 0xBDC6}, /* (HANGUL SYLLABLE BWELP) */
    {{'\xeb', '\xb7', '\x87'}, 3, 0xBDC7}, /* (HANGUL SYLLABLE BWELH) */
    {{'\xeb', '\xb7', '\x88'}, 3, 0xBDC8}, /* (HANGUL SYLLABLE BWEM) */
    {{'\xeb', '\xb7', '\x89'}, 3, 0xBDC9}, /* (HANGUL SYLLABLE BWEB) */
    {{'\xeb', '\xb7', '\x8a'}, 3, 0xBDCA}, /* (HANGUL SYLLABLE BWEBS) */
    {{'\xeb', '\xb7', '\x8b'}, 3, 0xBDCB}, /* (HANGUL SYLLABLE BWES) */
    {{'\xeb', '\xb7', '\x8c'}, 3, 0xBDCC}, /* (HANGUL SYLLABLE BWESS) */
    {{'\xeb', '\xb7', '\x8d'}, 3, 0xBDCD}, /* (HANGUL SYLLABLE BWENG) */
    {{'\xeb', '\xb7', '\x8e'}, 3, 0xBDCE}, /* (HANGUL SYLLABLE BWEJ) */
    {{'\xeb', '\xb7', '\x8f'}, 3, 0xBDCF}, /* (HANGUL SYLLABLE BWEC) */
    {{'\xeb', '\xb7', '\x90'}, 3, 0xBDD0}, /* (HANGUL SYLLABLE BWEK) */
    {{'\xeb', '\xb7', '\x91'}, 3, 0xBDD1}, /* (HANGUL SYLLABLE BWET) */
    {{'\xeb', '\xb7', '\x92'}, 3, 0xBDD2}, /* (HANGUL SYLLABLE BWEP) */
    {{'\xeb', '\xb7', '\x93'}, 3, 0xBDD3}, /* (HANGUL SYLLABLE BWEH) */
    {{'\xeb', '\xb7', '\x96'}, 3, 0xBDD6}, /* (HANGUL SYLLABLE BWIGG) */
    {{'\xeb', '\xb7', '\x97'}, 3, 0xBDD7}, /* (HANGUL SYLLABLE BWIGS) */
    {{'\xeb', '\xb7', '\x99'}, 3, 0xBDD9}, /* (HANGUL SYLLABLE BWINJ) */
    {{'\xeb', '\xb7', '\x9a'}, 3, 0xBDDA}, /* (HANGUL SYLLABLE BWINH) */
    {{'\xeb', '\xb7', '\x9b'}, 3, 0xBDDB}, /* (HANGUL SYLLABLE BWID) */
    {{'\xeb', '\xb7', '\x9d'}, 3, 0xBDDD}, /* (HANGUL SYLLABLE BWILG) */
    {{'\xeb', '\xb7', '\x9e'}, 3, 0xBDDE}, /* (HANGUL SYLLABLE BWILM) */
    {{'\xeb', '\xb7', '\x9f'}, 3, 0xBDDF}, /* (HANGUL SYLLABLE BWILB) */
    {{'\xeb', '\xb7', '\xa0'}, 3, 0xBDE0}, /* (HANGUL SYLLABLE BWILS) */
    {{'\xeb', '\xb7', '\xa1'}, 3, 0xBDE1}, /* (HANGUL SYLLABLE BWILT) */
    {{'\xeb', '\xb7', '\xa2'}, 3, 0xBDE2}, /* (HANGUL SYLLABLE BWILP) */
    {{'\xeb', '\xb7', '\xa3'}, 3, 0xBDE3}, /* (HANGUL SYLLABLE BWILH) */
    {{'\xeb', '\xb7', '\xa4'}, 3, 0xBDE4}, /* (HANGUL SYLLABLE BWIM) */
    {{'\xeb', '\xb7', '\xa5'}, 3, 0xBDE5}, /* (HANGUL SYLLABLE BWIB) */
    {{'\xeb', '\xb7', '\xa6'}, 3, 0xBDE6}, /* (HANGUL SYLLABLE BWIBS) */
    {{'\xeb', '\xb7', '\xa7'}, 3, 0xBDE7}, /* (HANGUL SYLLABLE BWIS) */
    {{'\xeb', '\xb7', '\xa8'}, 3, 0xBDE8}, /* (HANGUL SYLLABLE BWISS) */
    {{'\xeb', '\xb7', '\xaa'}, 3, 0xBDEA}, /* (HANGUL SYLLABLE BWIJ) */
    {{'\xeb', '\xb7', '\xab'}, 3, 0xBDEB}, /* (HANGUL SYLLABLE BWIC) */
    {{'\xeb', '\xb7', '\xac'}, 3, 0xBDEC}, /* (HANGUL SYLLABLE BWIK) */
    {{'\xeb', '\xb7', '\xad'}, 3, 0xBDED}, /* (HANGUL SYLLABLE BWIT) */
    {{'\xeb', '\xb7', '\xae'}, 3, 0xBDEE}, /* (HANGUL SYLLABLE BWIP) */
    {{'\xeb', '\xb7', '\xaf'}, 3, 0xBDEF}, /* (HANGUL SYLLABLE BWIH) */
    {{'\xeb', '\xb7', '\xb1'}, 3, 0xBDF1}, /* (HANGUL SYLLABLE BYUG) */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{'\xeb', '\xb7', '\xb2'}, 3, 0xBDF2}, /* (HANGUL SYLLABLE BYUGG) */
    {{'\xeb', '\xb7', '\xb3'}, 3, 0xBDF3}, /* (HANGUL SYLLABLE BYUGS) */
    {{'\xeb', '\xb7', '\xb5'}, 3, 0xBDF5}, /* (HANGUL SYLLABLE BYUNJ) */
    {{'\xeb', '\xb7', '\xb6'}, 3, 0xBDF6}, /* (HANGUL SYLLABLE BYUNH) */
    {{'\xeb', '\xb7', '\xb7'}, 3, 0xBDF7}, /* (HANGUL SYLLABLE BYUD) */
    {{'\xeb', '\xb7', '\xb9'}, 3, 0xBDF9}, /* (HANGUL SYLLABLE BYULG) */
    {{'\xeb', '\xb7', '\xba'}, 3, 0xBDFA}, /* (HANGUL SYLLABLE BYULM) */
    {{'\xeb', '\xb7', '\xbb'}, 3, 0xBDFB}, /* (HANGUL SYLLABLE BYULB) */
    {{'\xeb', '\xb7', '\xbc'}, 3, 0xBDFC}, /* (HANGUL SYLLABLE BYULS) */
    {{'\xeb', '\xb7', '\xbd'}, 3, 0xBDFD}, /* (HANGUL SYLLABLE BYULT) */
    {{'\xeb', '\xb7', '\xbe'}, 3, 0xBDFE}, /* (HANGUL SYLLABLE BYULP) */
    {{'\xeb', '\xb7', '\xbf'}, 3, 0xBDFF}, /* (HANGUL SYLLABLE BYULH) */
    {{'\xeb', '\xb8', '\x81'}, 3, 0xBE01}, /* (HANGUL SYLLABLE BYUB) */
    {{'\xeb', '\xb8', '\x82'}, 3, 0xBE02}, /* (HANGUL SYLLABLE BYUBS) */
    {{'\xeb', '\xb8', '\x84'}, 3, 0xBE04}, /* (HANGUL SYLLABLE BYUSS) */
    {{'\xeb', '\xb8', '\x86'}, 3, 0xBE06}, /* (HANGUL SYLLABLE BYUJ) */
    {{'\xeb', '\xb8', '\x87'}, 3, 0xBE07}, /* (HANGUL SYLLABLE BYUC) */
    {{'\xeb', '\xb8', '\x88'}, 3, 0xBE08}, /* (HANGUL SYLLABLE BYUK) */
    {{'\xeb', '\xb8', '\x89'}, 3, 0xBE09}, /* (HANGUL SYLLABLE BYUT) */
    {{'\xeb', '\xb8', '\x8a'}, 3, 0xBE0A}, /* (HANGUL SYLLABLE BYUP) */
    {{'\xeb', '\xb8', '\x8b'}, 3, 0xBE0B}, /* (HANGUL SYLLABLE BYUH) */
    {{'\xeb', '\xb8', '\x8e'}, 3, 0xBE0E}, /* (HANGUL SYLLABLE BEUGG) */
    {{'\xeb', '\xb8', '\x8f'}, 3, 0xBE0F}, /* (HANGUL SYLLABLE BEUGS) */
    {{'\xeb', '\xb8', '\x91'}, 3, 0xBE11}, /* (HANGUL SYLLABLE BEUNJ) */
    {{'\xeb', '\xb8', '\x92'}, 3, 0xBE12}, /* (HANGUL SYLLABLE BEUNH) */
    {{'\xeb', '\xb8', '\x93'}, 3, 0xBE13}, /* (HANGUL SYLLABLE BEUD) */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{'\xeb', '\xb8', '\x95'}, 3, 0xBE15}, /* (HANGUL SYLLABLE BEULG) */
    {{'\xeb', '\xb8', '\x96'}, 3, 0xBE16}, /* (HANGUL SYLLABLE BEULM) */
    {{'\xeb', '\xb8', '\x97'}, 3, 0xBE17}, /* (HANGUL SYLLABLE BEULB) */
    {{'\xeb', '\xb8', '\x98'}, 3, 0xBE18}, /* (HANGUL SYLLABLE BEULS) */
    {{'\xeb', '\xb8', '\x99'}, 3, 0xBE19}, /* (HANGUL SYLLABLE BEULT) */
    {{'\xeb', '\xb8', '\x9a'}, 3, 0xBE1A}, /* (HANGUL SYLLABLE BEULP) */
    {{'\xeb', '\xb8', '\x9b'}, 3, 0xBE1B}, /* (HANGUL SYLLABLE BEULH) */
    {{'\xeb', '\xb8', '\x9e'}, 3, 0xBE1E}, /* (HANGUL SYLLABLE BEUBS) */
    {{'\xeb', '\xb8', '\xa0'}, 3, 0xBE20}, /* (HANGUL SYLLABLE BEUSS) */
    {{'\xeb', '\xb8', '\xa1'}, 3, 0xBE21}, /* (HANGUL SYLLABLE BEUNG) */
    {{'\xeb', '\xb8', '\xa2'}, 3, 0xBE22}, /* (HANGUL SYLLABLE BEUJ) */
    {{'\xeb', '\xb8', '\xa3'}, 3, 0xBE23}, /* (HANGUL SYLLABLE BEUC) */
    {{'\xeb', '\xb8', '\xa4'}, 3, 0xBE24}, /* (HANGUL SYLLABLE BEUK) */
    {{'\xeb', '\xb8', '\xa5'}, 3, 0xBE25}, /* (HANGUL SYLLABLE BEUT) */
    {{'\xeb', '\xb8', '\xa6'}, 3, 0xBE26}, /* (HANGUL SYLLABLE BEUP) */
    {{'\xeb', '\xb8', '\xa7'}, 3, 0xBE27}, /* (HANGUL SYLLABLE BEUH) */
    {{'\xeb', '\xb8', '\xa8'}, 3, 0xBE28}, /* (HANGUL SYLLABLE BYI) */
    {{'\xeb', '\xb8', '\xa9'}, 3, 0xBE29}, /* (HANGUL SYLLABLE BYIG) */
    {{'\xeb', '\xb8', '\xaa'}, 3, 0xBE2A}, /* (HANGUL SYLLABLE BYIGG) */
    {{'\xeb', '\xb8', '\xab'}, 3, 0xBE2B}, /* (HANGUL SYLLABLE BYIGS) */
    {{'\xeb', '\xb8', '\xac'}, 3, 0xBE2C}, /* (HANGUL SYLLABLE BYIN) */
    {{'\xeb', '\xb8', '\xad'}, 3, 0xBE2D}, /* (HANGUL SYLLABLE BYINJ) */
    {{'\xeb', '\xb8', '\xae'}, 3, 0xBE2E}, /* (HANGUL SYLLABLE BYINH) */
    {{'\xeb', '\xb8', '\xaf'}, 3, 0xBE2F}, /* (HANGUL SYLLABLE BYID) */
    {{'\xeb', '\xb8', '\xb0'}, 3, 0xBE30}, /* (HANGUL SYLLABLE BYIL) */
    {{'\xeb', '\xb8', '\xb1'}, 3, 0xBE31}, /* (HANGUL SYLLABLE BYILG) */
    {{'\xeb', '\xb8', '\xb2'}, 3, 0xBE32}, /* (HANGUL SYLLABLE BYILM) */
    {{'\xeb', '\xb8', '\xb3'}, 3, 0xBE33}, /* (HANGUL SYLLABLE BYILB) */
    {{'\xeb', '\xb8', '\xb4'}, 3, 0xBE34}, /* (HANGUL SYLLABLE BYILS) */
    {{'\xeb', '\xb8', '\xb5'}, 3, 0xBE35}, /* (HANGUL SYLLABLE BYILT) */
    {{'\xeb', '\xb8', '\xb6'}, 3, 0xBE36}, /* (HANGUL SYLLABLE BYILP) */
    {{'\xeb', '\xb8', '\xb7'}, 3, 0xBE37}, /* (HANGUL SYLLABLE BYILH) */
    {{'\xeb', '\xb8', '\xb8'}, 3, 0xBE38}, /* (HANGUL SYLLABLE BYIM) */
    {{'\xeb', '\xb8', '\xb9'}, 3, 0xBE39}, /* (HANGUL SYLLABLE BYIB) */
    {{'\xeb', '\xb8', '\xba'}, 3, 0xBE3A}, /* (HANGUL SYLLABLE BYIBS) */
    {{'\xeb', '\xb8', '\xbb'}, 3, 0xBE3B}, /* (HANGUL SYLLABLE BYIS) */
    {{'\xeb', '\xb8', '\xbc'}, 3, 0xBE3C}, /* (HANGUL SYLLABLE BYISS) */
    {{'\xeb', '\xb8', '\xbd'}, 3, 0xBE3D}, /* (HANGUL SYLLABLE BYING) */
    {{'\xeb', '\xb8', '\xbe'}, 3, 0xBE3E}, /* (HANGUL SYLLABLE BYIJ) */
    {{'\xeb', '\xb8', '\xbf'}, 3, 0xBE3F}, /* (HANGUL SYLLABLE BYIC) */
    {{'\xeb', '\xb9', '\x80'}, 3, 0xBE40}, /* (HANGUL SYLLABLE BYIK) */
    {{'\xeb', '\xb9', '\x81'}, 3, 0xBE41}, /* (HANGUL SYLLABLE BYIT) */
    {{'\xeb', '\xb9', '\x82'}, 3, 0xBE42}, /* (HANGUL SYLLABLE BYIP) */
    {{'\xeb', '\xb9', '\x83'}, 3, 0xBE43}, /* (HANGUL SYLLABLE BYIH) */
    {{'\xeb', '\xb9', '\x86'}, 3, 0xBE46}, /* (HANGUL SYLLABLE BIGG) */
    {{'\xeb', '\xb9', '\x87'}, 3, 0xBE47}, /* (HANGUL SYLLABLE BIGS) */
    {{'\xeb', '\xb9', '\x89'}, 3, 0xBE49}, /* (HANGUL SYLLABLE BINJ) */
    {{'\xeb', '\xb9', '\x8a'}, 3, 0xBE4A}, /* (HANGUL SYLLABLE BINH) */
    {{'\xeb', '\xb9', '\x8b'}, 3, 0xBE4B}, /* (HANGUL SYLLABLE BID) */
    {{'\xeb', '\xb9', '\x8d'}, 3, 0xBE4D}, /* (HANGUL SYLLABLE BILG) */
    {{'\xeb', '\xb9', '\x8f'}, 3, 0xBE4F}, /* (HANGUL SYLLABLE BILB) */
    {{'\xeb', '\xb9', '\x90'}, 3, 0xBE50}, /* (HANGUL SYLLABLE BILS) */
    {{'\xeb', '\xb9', '\x91'}, 3, 0xBE51}, /* (HANGUL SYLLABLE BILT) */
    {{'\xeb', '\xb9', '\x92'}, 3, 0xBE52}, /* (HANGUL SYLLABLE BILP) */
    {{'\xeb', '\xb9', '\x93'}, 3, 0xBE53}, /* (HANGUL SYLLABLE BILH) */
    {{'\xeb', '\xb9', '\x96'}, 3, 0xBE56}, /* (HANGUL SYLLABLE BIBS) */
    {{'\xeb', '\xb9', '\x98'}, 3, 0xBE58}, /* (HANGUL SYLLABLE BISS) */
    {{'\xeb', '\xb9', '\x9c'}, 3, 0xBE5C}, /* (HANGUL SYLLABLE BIK) */
    {{'\xeb', '\xb9', '\x9d'}, 3, 0xBE5D}, /* (HANGUL SYLLABLE BIT) */
    {{'\xeb', '\xb9', '\x9e'}, 3, 0xBE5E}, /* (HANGUL SYLLABLE BIP) */
    {{'\xeb', '\xb9', '\x9f'}, 3, 0xBE5F}, /* (HANGUL SYLLABLE BIH) */
    {{'\xeb', '\xb9', '\xa2'}, 3, 0xBE62}, /* (HANGUL SYLLABLE BBAGG) */
    {{'\xeb', '\xb9', '\xa3'}, 3, 0xBE63}, /* (HANGUL SYLLABLE BBAGS) */
    {{'\xeb', '\xb9', '\xa5'}, 3, 0xBE65}, /* (HANGUL SYLLABLE BBANJ) */
    {{'\xeb', '\xb9', '\xa6'}, 3, 0xBE66}, /* (HANGUL SYLLABLE BBANH) */
    {{'\xeb', '\xb9', '\xa7'}, 3, 0xBE67}, /* (HANGUL SYLLABLE BBAD) */
    {{'\xeb', '\xb9', '\xa9'}, 3, 0xBE69}, /* (HANGUL SYLLABLE BBALG) */
    {{'\xeb', '\xb9', '\xab'}, 3, 0xBE6B}, /* (HANGUL SYLLABLE BBALB) */
    {{'\xeb', '\xb9', '\xac'}, 3, 0xBE6C}, /* (HANGUL SYLLABLE BBALS) */
    {{'\xeb', '\xb9', '\xad'}, 3, 0xBE6D}, /* (HANGUL SYLLABLE BBALT) */
    {{'\xeb', '\xb9', '\xae'}, 3, 0xBE6E}, /* (HANGUL SYLLABLE BBALP) */
    {{'\xeb', '\xb9', '\xaf'}, 3, 0xBE6F}, /* (HANGUL SYLLABLE BBALH) */
    {{'\xeb', '\xb9', '\xb2'}, 3, 0xBE72}, /* (HANGUL SYLLABLE BBABS) */
    {{'\xeb', '\xb9', '\xb6'}, 3, 0xBE76}, /* (HANGUL SYLLABLE BBAJ) */
    {{'\xeb', '\xb9', '\xb7'}, 3, 0xBE77}, /* (HANGUL SYLLABLE BBAC) */
    {{'\xeb', '\xb9', '\xb8'}, 3, 0xBE78}, /* (HANGUL SYLLABLE BBAK) */
    {{'\xeb', '\xb9', '\xb9'}, 3, 0xBE79}, /* (HANGUL SYLLABLE BBAT) */
    {{'\xeb', '\xb9', '\xba'}, 3, 0xBE7A}, /* (HANGUL SYLLABLE BBAP) */
    {{'\xeb', '\xb9', '\xbe'}, 3, 0xBE7E}, /* (HANGUL SYLLABLE BBAEGG) */
    {{'\xeb', '\xb9', '\xbf'}, 3, 0xBE7F}, /* (HANGUL SYLLABLE BBAEGS) */
    {{'\xeb', '\xba', '\x81'}, 3, 0xBE81}, /* (HANGUL SYLLABLE BBAENJ) */
    {{'\xeb', '\xba', '\x82'}, 3, 0xBE82}, /* (HANGUL SYLLABLE BBAENH) */
    {{'\xeb', '\xba', '\x83'}, 3, 0xBE83}, /* (HANGUL SYLLABLE BBAED) */
    {{'\xeb', '\xba', '\x85'}, 3, 0xBE85}, /* (HANGUL SYLLABLE BBAELG) */
    {{'\xeb', '\xba', '\x86'}, 3, 0xBE86}, /* (HANGUL SYLLABLE BBAELM) */
    {{'\xeb', '\xba', '\x87'}, 3, 0xBE87}, /* (HANGUL SYLLABLE BBAELB) */
    {{'\xeb', '\xba', '\x88'}, 3, 0xBE88}, /* (HANGUL SYLLABLE BBAELS) */
    {{'\xeb', '\xba', '\x89'}, 3, 0xBE89}, /* (HANGUL SYLLABLE BBAELT) */
    {{'\xeb', '\xba', '\x8a'}, 3, 0xBE8A}, /* (HANGUL SYLLABLE BBAELP) */
    {{'\xeb', '\xba', '\x8b'}, 3, 0xBE8B}, /* (HANGUL SYLLABLE BBAELH) */
    {{'\xeb', '\xba', '\x8e'}, 3, 0xBE8E}, /* (HANGUL SYLLABLE BBAEBS) */
    {{'\xeb', '\xba', '\x92'}, 3, 0xBE92}, /* (HANGUL SYLLABLE BBAEJ) */
    {{'\xeb', '\xba', '\x93'}, 3, 0xBE93}, /* (HANGUL SYLLABLE BBAEC) */
    {{'\xeb', '\xba', '\x94'}, 3, 0xBE94}, /* (HANGUL SYLLABLE BBAEK) */
    {{'\xeb', '\xba', '\x95'}, 3, 0xBE95}, /* (HANGUL SYLLABLE BBAET) */
    {{'\xeb', '\xba', '\x96'}, 3, 0xBE96}, /* (HANGUL SYLLABLE BBAEP) */
    {{'\xeb', '\xba', '\x97'}, 3, 0xBE97}, /* (HANGUL SYLLABLE BBAEH) */
    {{'\xeb', '\xba', '\x9a'}, 3, 0xBE9A}, /* (HANGUL SYLLABLE BBYAGG) */
    {{'\xeb', '\xba', '\x9b'}, 3, 0xBE9B}, /* (HANGUL SYLLABLE BBYAGS) */
    {{'\xeb', '\xba', '\x9c'}, 3, 0xBE9C}, /* (HANGUL SYLLABLE BBYAN) */
    {{'\xeb', '\xba', '\x9d'}, 3, 0xBE9D}, /* (HANGUL SYLLABLE BBYANJ) */
    {{'\xeb', '\xba', '\x9e'}, 3, 0xBE9E}, /* (HANGUL SYLLABLE BBYANH) */
    {{'\xeb', '\xba', '\x9f'}, 3, 0xBE9F}, /* (HANGUL SYLLABLE BBYAD) */
    {{'\xeb', '\xba', '\xa0'}, 3, 0xBEA0}, /* (HANGUL SYLLABLE BBYAL) */
    {{'\xeb', '\xba', '\xa1'}, 3, 0xBEA1}, /* (HANGUL SYLLABLE BBYALG) */
    {{'\xeb', '\xba', '\xa2'}, 3, 0xBEA2}, /* (HANGUL SYLLABLE BBYALM) */
    {{'\xeb', '\xba', '\xa3'}, 3, 0xBEA3}, /* (HANGUL SYLLABLE BBYALB) */
    {{'\xeb', '\xba', '\xa4'}, 3, 0xBEA4}, /* (HANGUL SYLLABLE BBYALS) */
    {{'\xeb', '\xba', '\xa5'}, 3, 0xBEA5}, /* (HANGUL SYLLABLE BBYALT) */
    {{'\xeb', '\xba', '\xa6'}, 3, 0xBEA6}, /* (HANGUL SYLLABLE BBYALP) */
    {{'\xeb', '\xba', '\xa7'}, 3, 0xBEA7}, /* (HANGUL SYLLABLE BBYALH) */
    {{'\xeb', '\xba', '\xa9'}, 3, 0xBEA9}, /* (HANGUL SYLLABLE BBYAB) */
    {{'\xeb', '\xba', '\xaa'}, 3, 0xBEAA}, /* (HANGUL SYLLABLE BBYABS) */
    {{'\xeb', '\xba', '\xab'}, 3, 0xBEAB}, /* (HANGUL SYLLABLE BBYAS) */
    {{'\xeb', '\xba', '\xac'}, 3, 0xBEAC}, /* (HANGUL SYLLABLE BBYASS) */
    {{'\xeb', '\xba', '\xad'}, 3, 0xBEAD}, /* (HANGUL SYLLABLE BBYANG) */
    {{'\xeb', '\xba', '\xae'}, 3, 0xBEAE}, /* (HANGUL SYLLABLE BBYAJ) */
    {{'\xeb', '\xba', '\xaf'}, 3, 0xBEAF}, /* (HANGUL SYLLABLE BBYAC) */
    {{'\xeb', '\xba', '\xb0'}, 3, 0xBEB0}, /* (HANGUL SYLLABLE BBYAK) */
    {{'\xeb', '\xba', '\xb1'}, 3, 0xBEB1}, /* (HANGUL SYLLABLE BBYAT) */
    {{'\xeb', '\xba', '\xb2'}, 3, 0xBEB2}, /* (HANGUL SYLLABLE BBYAP) */
    {{'\xeb', '\xba', '\xb3'}, 3, 0xBEB3}, /* (HANGUL SYLLABLE BBYAH) */
    {{'\xeb', '\xba', '\xb4'}, 3, 0xBEB4}, /* (HANGUL SYLLABLE BBYAE) */
    {{'\xeb', '\xba', '\xb5'}, 3, 0xBEB5}, /* (HANGUL SYLLABLE BBYAEG) */
    {{'\xeb', '\xba', '\xb6'}, 3, 0xBEB6}, /* (HANGUL SYLLABLE BBYAEGG) */
    {{'\xeb', '\xba', '\xb7'}, 3, 0xBEB7}, /* (HANGUL SYLLABLE BBYAEGS) */
    {{'\xeb', '\xba', '\xb8'}, 3, 0xBEB8}, /* (HANGUL SYLLABLE BBYAEN) */
    {{'\xeb', '\xba', '\xb9'}, 3, 0xBEB9}, /* (HANGUL SYLLABLE BBYAENJ) */
    {{'\xeb', '\xba', '\xba'}, 3, 0xBEBA}, /* (HANGUL SYLLABLE BBYAENH) */
    {{'\xeb', '\xba', '\xbb'}, 3, 0xBEBB}, /* (HANGUL SYLLABLE BBYAED) */
    {{'\xeb', '\xba', '\xbc'}, 3, 0xBEBC}, /* (HANGUL SYLLABLE BBYAEL) */
    {{'\xeb', '\xba', '\xbd'}, 3, 0xBEBD}, /* (HANGUL SYLLABLE BBYAELG) */
    {{'\xeb', '\xba', '\xbe'}, 3, 0xBEBE}, /* (HANGUL SYLLABLE BBYAELM) */
    {{'\xeb', '\xba', '\xbf'}, 3, 0xBEBF}, /* (HANGUL SYLLABLE BBYAELB) */
    {{'\xeb', '\xbb', '\x80'}, 3, 0xBEC0}, /* (HANGUL SYLLABLE BBYAELS) */
    {{'\xeb', '\xbb', '\x81'}, 3, 0xBEC1}, /* (HANGUL SYLLABLE BBYAELT) */
    {{'\xeb', '\xbb', '\x82'}, 3, 0xBEC2}, /* (HANGUL SYLLABLE BBYAELP) */
    {{'\xeb', '\xbb', '\x83'}, 3, 0xBEC3}, /* (HANGUL SYLLABLE BBYAELH) */
    {{'\xeb', '\xbb', '\x84'}, 3, 0xBEC4}, /* (HANGUL SYLLABLE BBYAEM) */
    {{'\xeb', '\xbb', '\x85'}, 3, 0xBEC5}, /* (HANGUL SYLLABLE BBYAEB) */
    {{'\xeb', '\xbb', '\x86'}, 3, 0xBEC6}, /* (HANGUL SYLLABLE BBYAEBS) */
    {{'\xeb', '\xbb', '\x87'}, 3, 0xBEC7}, /* (HANGUL SYLLABLE BBYAES) */
    {{'\xeb', '\xbb', '\x88'}, 3, 0xBEC8}, /* (HANGUL SYLLABLE BBYAESS) */
    {{'\xeb', '\xbb', '\x89'}, 3, 0xBEC9}, /* (HANGUL SYLLABLE BBYAENG) */
    {{'\xeb', '\xbb', '\x8a'}, 3, 0xBECA}, /* (HANGUL SYLLABLE BBYAEJ) */
    {{'\xeb', '\xbb', '\x8b'}, 3, 0xBECB}, /* (HANGUL SYLLABLE BBYAEC) */
    {{'\xeb', '\xbb', '\x8c'}, 3, 0xBECC}, /* (HANGUL SYLLABLE BBYAEK) */
    {{'\xeb', '\xbb', '\x8d'}, 3, 0xBECD}, /* (HANGUL SYLLABLE BBYAET) */
    {{'\xeb', '\xbb', '\x8e'}, 3, 0xBECE}, /* (HANGUL SYLLABLE BBYAEP) */
    {{'\xeb', '\xbb', '\x8f'}, 3, 0xBECF}, /* (HANGUL SYLLABLE BBYAEH) */
    {{'\xeb', '\xbb', '\x92'}, 3, 0xBED2}, /* (HANGUL SYLLABLE BBEOGG) */
    {{'\xeb', '\xbb', '\x93'}, 3, 0xBED3}, /* (HANGUL SYLLABLE BBEOGS) */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{'\xeb', '\xbb', '\x95'}, 3, 0xBED5}, /* (HANGUL SYLLABLE BBEONJ) */
    {{'\xeb', '\xbb', '\x96'}, 3, 0xBED6}, /* (HANGUL SYLLABLE BBEONH) */
    {{'\xeb', '\xbb', '\x99'}, 3, 0xBED9}, /* (HANGUL SYLLABLE BBEOLG) */
    {{'\xeb', '\xbb', '\x9a'}, 3, 0xBEDA}, /* (HANGUL SYLLABLE BBEOLM) */
    {{'\xeb', '\xbb', '\x9b'}, 3, 0xBEDB}, /* (HANGUL SYLLABLE BBEOLB) */
    {{'\xeb', '\xbb', '\x9c'}, 3, 0xBEDC}, /* (HANGUL SYLLABLE BBEOLS) */
    {{'\xeb', '\xbb', '\x9d'}, 3, 0xBEDD}, /* (HANGUL SYLLABLE BBEOLT) */
    {{'\xeb', '\xbb', '\x9e'}, 3, 0xBEDE}, /* (HANGUL SYLLABLE BBEOLP) */
    {{'\xeb', '\xbb', '\x9f'}, 3, 0xBEDF}, /* (HANGUL SYLLABLE BBEOLH) */
    {{'\xeb', '\xbb', '\xa1'}, 3, 0xBEE1}, /* (HANGUL SYLLABLE BBEOB) */
    {{'\xeb', '\xbb', '\xa2'}, 3, 0xBEE2}, /* (HANGUL SYLLABLE BBEOBS) */
    {{'\xeb', '\xbb', '\xa6'}, 3, 0xBEE6}, /* (HANGUL SYLLABLE BBEOJ) */
    {{'\xeb', '\xbb', '\xa7'}, 3, 0xBEE7}, /* (HANGUL SYLLABLE BBEOC) */
    {{'\xeb', '\xbb', '\xa8'}, 3, 0xBEE8}, /* (HANGUL SYLLABLE BBEOK) */
    {{'\xeb', '\xbb', '\xa9'}, 3, 0xBEE9}, /* (HANGUL SYLLABLE BBEOT) */
    {{'\xeb', '\xbb', '\xaa'}, 3, 0xBEEA}, /* (HANGUL SYLLABLE BBEOP) */
    {{'\xeb', '\xbb', '\xab'}, 3, 0xBEEB}, /* (HANGUL SYLLABLE BBEOH) */
    {{'\xeb', '\xbb', '\xad'}, 3, 0xBEED}, /* (HANGUL SYLLABLE BBEG) */
    {{'\xeb', '\xbb', '\xae'}, 3, 0xBEEE}, /* (HANGUL SYLLABLE BBEGG) */
    {{'\xeb', '\xbb', '\xaf'}, 3, 0xBEEF}, /* (HANGUL SYLLABLE BBEGS) */
    {{'\xeb', '\xbb', '\xb0'}, 3, 0xBEF0}, /* (HANGUL SYLLABLE BBEN) */
    {{'\xeb', '\xbb', '\xb1'}, 3, 0xBEF1}, /* (HANGUL SYLLABLE BBENJ) */
    {{'\xeb', '\xbb', '\xb2'}, 3, 0xBEF2}, /* (HANGUL SYLLABLE BBENH) */
    {{'\xeb', '\xbb', '\xb3'}, 3, 0xBEF3}, /* (HANGUL SYLLABLE BBED) */
    {{'\xeb', '\xbb', '\xb4'}, 3, 0xBEF4}, /* (HANGUL SYLLABLE BBEL) */
    {{'\xeb', '\xbb', '\xb5'}, 3, 0xBEF5}, /* (HANGUL SYLLABLE BBELG) */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{'\xeb', '\xbb', '\xb6'}, 3, 0xBEF6}, /* (HANGUL SYLLABLE BBELM) */
    {{'\xeb', '\xbb', '\xb7'}, 3, 0xBEF7}, /* (HANGUL SYLLABLE BBELB) */
    {{'\xeb', '\xbb', '\xb8'}, 3, 0xBEF8}, /* (HANGUL SYLLABLE BBELS) */
    {{'\xeb', '\xbb', '\xb9'}, 3, 0xBEF9}, /* (HANGUL SYLLABLE BBELT) */
    {{'\xeb', '\xbb', '\xba'}, 3, 0xBEFA}, /* (HANGUL SYLLABLE BBELP) */
    {{'\xeb', '\xbb', '\xbb'}, 3, 0xBEFB}, /* (HANGUL SYLLABLE BBELH) */
    {{'\xeb', '\xbb', '\xbc'}, 3, 0xBEFC}, /* (HANGUL SYLLABLE BBEM) */
    {{'\xeb', '\xbb', '\xbd'}, 3, 0xBEFD}, /* (HANGUL SYLLABLE BBEB) */
    {{'\xeb', '\xbb', '\xbe'}, 3, 0xBEFE}, /* (HANGUL SYLLABLE BBEBS) */
    {{'\xeb', '\xbb', '\xbf'}, 3, 0xBEFF}, /* (HANGUL SYLLABLE BBES) */
    {{'\xeb', '\xbc', '\x80'}, 3, 0xBF00}, /* (HANGUL SYLLABLE BBESS) */
    {{'\xeb', '\xbc', '\x82'}, 3, 0xBF02}, /* (HANGUL SYLLABLE BBEJ) */
    {{'\xeb', '\xbc', '\x83'}, 3, 0xBF03}, /* (HANGUL SYLLABLE BBEC) */
    {{'\xeb', '\xbc', '\x84'}, 3, 0xBF04}, /* (HANGUL SYLLABLE BBEK) */
    {{'\xeb', '\xbc', '\x85'}, 3, 0xBF05}, /* (HANGUL SYLLABLE BBET) */
    {{'\xeb', '\xbc', '\x86'}, 3, 0xBF06}, /* (HANGUL SYLLABLE BBEP) */
    {{'\xeb', '\xbc', '\x87'}, 3, 0xBF07}, /* (HANGUL SYLLABLE BBEH) */
    {{'\xeb', '\xbc', '\x8a'}, 3, 0xBF0A}, /* (HANGUL SYLLABLE BBYEOGG) */
    {{'\xeb', '\xbc', '\x8b'}, 3, 0xBF0B}, /* (HANGUL SYLLABLE BBYEOGS) */
    {{'\xeb', '\xbc', '\x8c'}, 3, 0xBF0C}, /* (HANGUL SYLLABLE BBYEON) */
    {{'\xeb', '\xbc', '\x8d'}, 3, 0xBF0D}, /* (HANGUL SYLLABLE BBYEONJ) */
    {{'\xeb', '\xbc', '\x8e'}, 3, 0xBF0E}, /* (HANGUL SYLLABLE BBYEONH) */
    {{'\xeb', '\xbc', '\x8f'}, 3, 0xBF0F}, /* (HANGUL SYLLABLE BBYEOD) */
    {{'\xeb', '\xbc', '\x90'}, 3, 0xBF10}, /* (HANGUL SYLLABLE BBYEOL) */
    {{'\xeb', '\xbc', '\x91'}, 3, 0xBF11}, /* (HANGUL SYLLABLE BBYEOLG) */
    {{'\xeb', '\xbc', '\x92'}, 3, 0xBF12}, /* (HANGUL SYLLABLE BBYEOLM) */
    {{'\xeb', '\xbc', '\x93'}, 3, 0xBF13}, /* (HANGUL SYLLABLE BBYEOLB) */
    {{'\xeb', '\xbc', '\x94'}, 3, 0xBF14}, /* (HANGUL SYLLABLE BBYEOLS) */
    {{'\xeb', '\xbc', '\x95'}, 3, 0xBF15}, /* (HANGUL SYLLABLE BBYEOLT) */
    {{'\xeb', '\xbc', '\x96'}, 3, 0xBF16}, /* (HANGUL SYLLABLE BBYEOLP) */
    {{'\xeb', '\xbc', '\x97'}, 3, 0xBF17}, /* (HANGUL SYLLABLE BBYEOLH) */
    {{'\xeb', '\xbc', '\x9a'}, 3, 0xBF1A}, /* (HANGUL SYLLABLE BBYEOBS) */
    {{'\xeb', '\xbc', '\x9e'}, 3, 0xBF1E}, /* (HANGUL SYLLABLE BBYEOJ) */
    {{'\xeb', '\xbc', '\x9f'}, 3, 0xBF1F}, /* (HANGUL SYLLABLE BBYEOC) */
    {{'\xeb', '\xbc', '\xa0'}, 3, 0xBF20}, /* (HANGUL SYLLABLE BBYEOK) */
    {{'\xeb', '\xbc', '\xa1'}, 3, 0xBF21}, /* (HANGUL SYLLABLE BBYEOT) */
    {{'\xeb', '\xbc', '\xa2'}, 3, 0xBF22}, /* (HANGUL SYLLABLE BBYEOP) */
    {{'\xeb', '\xbc', '\xa3'}, 3, 0xBF23}, /* (HANGUL SYLLABLE BBYEOH) */
    {{'\xeb', '\xbc', '\xa4'}, 3, 0xBF24}, /* (HANGUL SYLLABLE BBYE) */
    {{'\xeb', '\xbc', '\xa5'}, 3, 0xBF25}, /* (HANGUL SYLLABLE BBYEG) */
    {{'\xeb', '\xbc', '\xa6'}, 3, 0xBF26}, /* (HANGUL SYLLABLE BBYEGG) */
    {{'\xeb', '\xbc', '\xa7'}, 3, 0xBF27}, /* (HANGUL SYLLABLE BBYEGS) */
    {{'\xeb', '\xbc', '\xa8'}, 3, 0xBF28}, /* (HANGUL SYLLABLE BBYEN) */
    {{'\xeb', '\xbc', '\xa9'}, 3, 0xBF29}, /* (HANGUL SYLLABLE BBYENJ) */
    {{'\xeb', '\xbc', '\xaa'}, 3, 0xBF2A}, /* (HANGUL SYLLABLE BBYENH) */
    {{'\xeb', '\xbc', '\xab'}, 3, 0xBF2B}, /* (HANGUL SYLLABLE BBYED) */
    {{'\xeb', '\xbc', '\xac'}, 3, 0xBF2C}, /* (HANGUL SYLLABLE BBYEL) */
    {{'\xeb', '\xbc', '\xad'}, 3, 0xBF2D}, /* (HANGUL SYLLABLE BBYELG) */
    {{'\xeb', '\xbc', '\xae'}, 3, 0xBF2E}, /* (HANGUL SYLLABLE BBYELM) */
    {{'\xeb', '\xbc', '\xaf'}, 3, 0xBF2F}, /* (HANGUL SYLLABLE BBYELB) */
    {{'\xeb', '\xbc', '\xb0'}, 3, 0xBF30}, /* (HANGUL SYLLABLE BBYELS) */
    {{'\xeb', '\xbc', '\xb1'}, 3, 0xBF31}, /* (HANGUL SYLLABLE BBYELT) */
    {{'\xeb', '\xbc', '\xb2'}, 3, 0xBF32}, /* (HANGUL SYLLABLE BBYELP) */
    {{'\xeb', '\xbc', '\xb3'}, 3, 0xBF33}, /* (HANGUL SYLLABLE BBYELH) */
    {{'\xeb', '\xbc', '\xb4'}, 3, 0xBF34}, /* (HANGUL SYLLABLE BBYEM) */
    {{'\xeb', '\xbc', '\xb5'}, 3, 0xBF35}, /* (HANGUL SYLLABLE BBYEB) */
    {{'\xeb', '\xbc', '\xb6'}, 3, 0xBF36}, /* (HANGUL SYLLABLE BBYEBS) */
    {{'\xeb', '\xbc', '\xb7'}, 3, 0xBF37}, /* (HANGUL SYLLABLE BBYES) */
    {{'\xeb', '\xbc', '\xb8'}, 3, 0xBF38}, /* (HANGUL SYLLABLE BBYESS) */
    {{'\xeb', '\xbc', '\xb9'}, 3, 0xBF39}, /* (HANGUL SYLLABLE BBYENG) */
    {{'\xeb', '\xbc', '\xba'}, 3, 0xBF3A}, /* (HANGUL SYLLABLE BBYEJ) */
    {{'\xeb', '\xbc', '\xbb'}, 3, 0xBF3B}, /* (HANGUL SYLLABLE BBYEC) */
    {{'\xeb', '\xbc', '\xbc'}, 3, 0xBF3C}, /* (HANGUL SYLLABLE BBYEK) */
    {{'\xeb', '\xbc', '\xbd'}, 3, 0xBF3D}, /* (HANGUL SYLLABLE BBYET) */
    {{'\xeb', '\xbc', '\xbe'}, 3, 0xBF3E}, /* (HANGUL SYLLABLE BBYEP) */
    {{'\xeb', '\xbc', '\xbf'}, 3, 0xBF3F}, /* (HANGUL SYLLABLE BBYEH) */
    {{'\xeb', '\xbd', '\x82'}, 3, 0xBF42}, /* (HANGUL SYLLABLE BBOGG) */
    {{'\xeb', '\xbd', '\x83'}, 3, 0xBF43}, /* (HANGUL SYLLABLE BBOGS) */
    {{'\xeb', '\xbd', '\x85'}, 3, 0xBF45}, /* (HANGUL SYLLABLE BBONJ) */
    {{'\xeb', '\xbd', '\x86'}, 3, 0xBF46}, /* (HANGUL SYLLABLE BBONH) */
    {{'\xeb', '\xbd', '\x87'}, 3, 0xBF47}, /* (HANGUL SYLLABLE BBOD) */
    {{'\xeb', '\xbd', '\x89'}, 3, 0xBF49}, /* (HANGUL SYLLABLE BBOLG) */
    {{'\xeb', '\xbd', '\x8a'}, 3, 0xBF4A}, /* (HANGUL SYLLABLE BBOLM) */
    {{'\xeb', '\xbd', '\x8b'}, 3, 0xBF4B}, /* (HANGUL SYLLABLE BBOLB) */
    {{'\xeb', '\xbd', '\x8c'}, 3, 0xBF4C}, /* (HANGUL SYLLABLE BBOLS) */
    {{'\xeb', '\xbd', '\x8d'}, 3, 0xBF4D}, /* (HANGUL SYLLABLE BBOLT) */
    {{'\xeb', '\xbd', '\x8e'}, 3, 0xBF4E}, /* (HANGUL SYLLABLE BBOLP) */
    {{'\xeb', '\xbd', '\x8f'}, 3, 0xBF4F}, /* (HANGUL SYLLABLE BBOLH) */
    {{'\xeb', '\xbd', '\x92'}, 3, 0xBF52}, /* (HANGUL SYLLABLE BBOBS) */
    {{'\xeb', '\xbd', '\x93'}, 3, 0xBF53}, /* (HANGUL SYLLABLE BBOS) */
    {{'\xeb', '\xbd', '\x94'}, 3, 0xBF54}, /* (HANGUL SYLLABLE BBOSS) */
    {{'\xeb', '\xbd', '\x96'}, 3, 0xBF56}, /* (HANGUL SYLLABLE BBOJ) */
    {{'\xeb', '\xbd', '\x97'}, 3, 0xBF57}, /* (HANGUL SYLLABLE BBOC) */
    {{'\xeb', '\xbd', '\x98'}, 3, 0xBF58}, /* (HANGUL SYLLABLE BBOK) */
    {{'\xeb', '\xbd', '\x99'}, 3, 0xBF59}, /* (HANGUL SYLLABLE BBOT) */
    {{'\xeb', '\xbd', '\x9a'}, 3, 0xBF5A}, /* (HANGUL SYLLABLE BBOP) */
    {{'\xeb', '\xbd', '\x9b'}, 3, 0xBF5B}, /* (HANGUL SYLLABLE BBOH) */
    {{'\xeb', '\xbd', '\x9c'}, 3, 0xBF5C}, /* (HANGUL SYLLABLE BBWA) */
    {{'\xeb', '\xbd', '\x9d'}, 3, 0xBF5D}, /* (HANGUL SYLLABLE BBWAG) */
    {{'\xeb', '\xbd', '\x9e'}, 3, 0xBF5E}, /* (HANGUL SYLLABLE BBWAGG) */
    {{'\xeb', '\xbd', '\x9f'}, 3, 0xBF5F}, /* (HANGUL SYLLABLE BBWAGS) */
    {{'\xeb', '\xbd', '\xa0'}, 3, 0xBF60}, /* (HANGUL SYLLABLE BBWAN) */
    {{'\xeb', '\xbd', '\xa1'}, 3, 0xBF61}, /* (HANGUL SYLLABLE BBWANJ) */
    {{'\xeb', '\xbd', '\xa2'}, 3, 0xBF62}, /* (HANGUL SYLLABLE BBWANH) */
    {{'\xeb', '\xbd', '\xa3'}, 3, 0xBF63}, /* (HANGUL SYLLABLE BBWAD) */
    {{'\xeb', '\xbd', '\xa4'}, 3, 0xBF64}, /* (HANGUL SYLLABLE BBWAL) */
    {{'\xeb', '\xbd', '\xa5'}, 3, 0xBF65}, /* (HANGUL SYLLABLE BBWALG) */
    {{'\xeb', '\xbd', '\xa6'}, 3, 0xBF66}, /* (HANGUL SYLLABLE BBWALM) */
    {{'\xeb', '\xbd', '\xa7'}, 3, 0xBF67}, /* (HANGUL SYLLABLE BBWALB) */
    {{'\xeb', '\xbd', '\xa8'}, 3, 0xBF68}, /* (HANGUL SYLLABLE BBWALS) */
    {{'\xeb', '\xbd', '\xa9'}, 3, 0xBF69}, /* (HANGUL SYLLABLE BBWALT) */
    {{'\xeb', '\xbd', '\xaa'}, 3, 0xBF6A}, /* (HANGUL SYLLABLE BBWALP) */
    {{'\xeb', '\xbd', '\xab'}, 3, 0xBF6B}, /* (HANGUL SYLLABLE BBWALH) */
    {{'\xeb', '\xbd', '\xac'}, 3, 0xBF6C}, /* (HANGUL SYLLABLE BBWAM) */
    {{'\xeb', '\xbd', '\xad'}, 3, 0xBF6D}, /* (HANGUL SYLLABLE BBWAB) */
    {{'\xeb', '\xbd', '\xae'}, 3, 0xBF6E}, /* (HANGUL SYLLABLE BBWABS) */
    {{'\xeb', '\xbd', '\xaf'}, 3, 0xBF6F}, /* (HANGUL SYLLABLE BBWAS) */
    {{'\xeb', '\xbd', '\xb0'}, 3, 0xBF70}, /* (HANGUL SYLLABLE BBWASS) */
    {{'\xeb', '\xbd', '\xb1'}, 3, 0xBF71}, /* (HANGUL SYLLABLE BBWANG) */
    {{'\xeb', '\xbd', '\xb2'}, 3, 0xBF72}, /* (HANGUL SYLLABLE BBWAJ) */
    {{'\xeb', '\xbd', '\xb3'}, 3, 0xBF73}, /* (HANGUL SYLLABLE BBWAC) */
    {{'\xeb', '\xbd', '\xb4'}, 3, 0xBF74}, /* (HANGUL SYLLABLE BBWAK) */
    {{'\xeb', '\xbd', '\xb5'}, 3, 0xBF75}, /* (HANGUL SYLLABLE BBWAT) */
    {{'\xeb', '\xbd', '\xb6'}, 3, 0xBF76}, /* (HANGUL SYLLABLE BBWAP) */
    {{'\xeb', '\xbd', '\xb7'}, 3, 0xBF77}, /* (HANGUL SYLLABLE BBWAH) */
    {{'\xeb', '\xbd', '\xb8'}, 3, 0xBF78}, /* (HANGUL SYLLABLE BBWAE) */
    {{'\xeb', '\xbd', '\xb9'}, 3, 0xBF79}, /* (HANGUL SYLLABLE BBWAEG) */
    {{'\xeb', '\xbd', '\xba'}, 3, 0xBF7A}, /* (HANGUL SYLLABLE BBWAEGG) */
    {{'\xeb', '\xbd', '\xbb'}, 3, 0xBF7B}, /* (HANGUL SYLLABLE BBWAEGS) */
    {{'\xeb', '\xbd', '\xbc'}, 3, 0xBF7C}, /* (HANGUL SYLLABLE BBWAEN) */
    {{'\xeb', '\xbd', '\xbd'}, 3, 0xBF7D}, /* (HANGUL SYLLABLE BBWAENJ) */
    {{'\xeb', '\xbd', '\xbe'}, 3, 0xBF7E}, /* (HANGUL SYLLABLE BBWAENH) */
    {{'\xeb', '\xbd', '\xbf'}, 3, 0xBF7F}, /* (HANGUL SYLLABLE BBWAED) */
    {{'\xeb', '\xbe', '\x80'}, 3, 0xBF80}, /* (HANGUL SYLLABLE BBWAEL) */
    {{'\xeb', '\xbe', '\x81'}, 3, 0xBF81}, /* (HANGUL SYLLABLE BBWAELG) */
    {{'\xeb', '\xbe', '\x82'}, 3, 0xBF82}, /* (HANGUL SYLLABLE BBWAELM) */
    {{'\xeb', '\xbe', '\x83'}, 3, 0xBF83}, /* (HANGUL SYLLABLE BBWAELB) */
    {{'\xeb', '\xbe', '\x84'}, 3, 0xBF84}, /* (HANGUL SYLLABLE BBWAELS) */
    {{'\xeb', '\xbe', '\x85'}, 3, 0xBF85}, /* (HANGUL SYLLABLE BBWAELT) */
    {{'\xeb', '\xbe', '\x86'}, 3, 0xBF86}, /* (HANGUL SYLLABLE BBWAELP) */
    {{'\xeb', '\xbe', '\x87'}, 3, 0xBF87}, /* (HANGUL SYLLABLE BBWAELH) */
    {{'\xeb', '\xbe', '\x88'}, 3, 0xBF88}, /* (HANGUL SYLLABLE BBWAEM) */
    {{'\xeb', '\xbe', '\x89'}, 3, 0xBF89}, /* (HANGUL SYLLABLE BBWAEB) */
    {{'\xeb', '\xbe', '\x8a'}, 3, 0xBF8A}, /* (HANGUL SYLLABLE BBWAEBS) */
    {{'\xeb', '\xbe', '\x8b'}, 3, 0xBF8B}, /* (HANGUL SYLLABLE BBWAES) */
    {{'\xeb', '\xbe', '\x8c'}, 3, 0xBF8C}, /* (HANGUL SYLLABLE BBWAESS) */
    {{'\xeb', '\xbe', '\x8d'}, 3, 0xBF8D}, /* (HANGUL SYLLABLE BBWAENG) */
    {{'\xeb', '\xbe', '\x8e'}, 3, 0xBF8E}, /* (HANGUL SYLLABLE BBWAEJ) */
    {{'\xeb', '\xbe', '\x8f'}, 3, 0xBF8F}, /* (HANGUL SYLLABLE BBWAEC) */
    {{'\xeb', '\xbe', '\x90'}, 3, 0xBF90}, /* (HANGUL SYLLABLE BBWAEK) */
    {{'\xeb', '\xbe', '\x91'}, 3, 0xBF91}, /* (HANGUL SYLLABLE BBWAET) */
    {{'\xeb', '\xbe', '\x92'}, 3, 0xBF92}, /* (HANGUL SYLLABLE BBWAEP) */
    {{'\xeb', '\xbe', '\x93'}, 3, 0xBF93}, /* (HANGUL SYLLABLE BBWAEH) */
    {{'\xeb', '\xbe', '\x95'}, 3, 0xBF95}, /* (HANGUL SYLLABLE BBOEG) */
    {{'\xeb', '\xbe', '\x96'}, 3, 0xBF96}, /* (HANGUL SYLLABLE BBOEGG) */
    {{'\xeb', '\xbe', '\x97'}, 3, 0xBF97}, /* (HANGUL SYLLABLE BBOEGS) */
    {{'\xeb', '\xbe', '\x98'}, 3, 0xBF98}, /* (HANGUL SYLLABLE BBOEN) */
    {{'\xeb', '\xbe', '\x99'}, 3, 0xBF99}, /* (HANGUL SYLLABLE BBOENJ) */
    {{'\xeb', '\xbe', '\x9a'}, 3, 0xBF9A}, /* (HANGUL SYLLABLE BBOENH) */
    {{'\xeb', '\xbe', '\x9b'}, 3, 0xBF9B}, /* (HANGUL SYLLABLE BBOED) */
    {{'\xeb', '\xbe', '\x9c'}, 3, 0xBF9C}, /* (HANGUL SYLLABLE BBOEL) */
    {{'\xeb', '\xbe', '\x9d'}, 3, 0xBF9D}, /* (HANGUL SYLLABLE BBOELG) */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{'\xeb', '\xbe', '\x9e'}, 3, 0xBF9E}, /* (HANGUL SYLLABLE BBOELM) */
    {{'\xeb', '\xbe', '\x9f'}, 3, 0xBF9F}, /* (HANGUL SYLLABLE BBOELB) */
    {{'\xeb', '\xbe', '\xa0'}, 3, 0xBFA0}, /* (HANGUL SYLLABLE BBOELS) */
    {{'\xeb', '\xbe', '\xa1'}, 3, 0xBFA1}, /* (HANGUL SYLLABLE BBOELT) */
    {{'\xeb', '\xbe', '\xa2'}, 3, 0xBFA2}, /* (HANGUL SYLLABLE BBOELP) */
    {{'\xeb', '\xbe', '\xa3'}, 3, 0xBFA3}, /* (HANGUL SYLLABLE BBOELH) */
    {{'\xeb', '\xbe', '\xa4'}, 3, 0xBFA4}, /* (HANGUL SYLLABLE BBOEM) */
    {{'\xeb', '\xbe', '\xa5'}, 3, 0xBFA5}, /* (HANGUL SYLLABLE BBOEB) */
    {{'\xeb', '\xbe', '\xa6'}, 3, 0xBFA6}, /* (HANGUL SYLLABLE BBOEBS) */
    {{'\xeb', '\xbe', '\xa7'}, 3, 0xBFA7}, /* (HANGUL SYLLABLE BBOES) */
    {{'\xeb', '\xbe', '\xa8'}, 3, 0xBFA8}, /* (HANGUL SYLLABLE BBOESS) */
    {{'\xeb', '\xbe', '\xa9'}, 3, 0xBFA9}, /* (HANGUL SYLLABLE BBOENG) */
    {{'\xeb', '\xbe', '\xaa'}, 3, 0xBFAA}, /* (HANGUL SYLLABLE BBOEJ) */
    {{'\xeb', '\xbe', '\xab'}, 3, 0xBFAB}, /* (HANGUL SYLLABLE BBOEC) */
    {{'\xeb', '\xbe', '\xac'}, 3, 0xBFAC}, /* (HANGUL SYLLABLE BBOEK) */
    {{'\xeb', '\xbe', '\xad'}, 3, 0xBFAD}, /* (HANGUL SYLLABLE BBOET) */
    {{'\xeb', '\xbe', '\xae'}, 3, 0xBFAE}, /* (HANGUL SYLLABLE BBOEP) */
    {{'\xeb', '\xbe', '\xaf'}, 3, 0xBFAF}, /* (HANGUL SYLLABLE BBOEH) */
    {{'\xeb', '\xbe', '\xb1'}, 3, 0xBFB1}, /* (HANGUL SYLLABLE BBYOG) */
    {{'\xeb', '\xbe', '\xb2'}, 3, 0xBFB2}, /* (HANGUL SYLLABLE BBYOGG) */
    {{'\xeb', '\xbe', '\xb3'}, 3, 0xBFB3}, /* (HANGUL SYLLABLE BBYOGS) */
    {{'\xeb', '\xbe', '\xb4'}, 3, 0xBFB4}, /* (HANGUL SYLLABLE BBYON) */
    {{'\xeb', '\xbe', '\xb5'}, 3, 0xBFB5}, /* (HANGUL SYLLABLE BBYONJ) */
    {{'\xeb', '\xbe', '\xb6'}, 3, 0xBFB6}, /* (HANGUL SYLLABLE BBYONH) */
    {{'\xeb', '\xbe', '\xb7'}, 3, 0xBFB7}, /* (HANGUL SYLLABLE BBYOD) */
    {{'\xeb', '\xbe', '\xb8'}, 3, 0xBFB8}, /* (HANGUL SYLLABLE BBYOL) */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{'\xeb', '\xbe', '\xb9'}, 3, 0xBFB9}, /* (HANGUL SYLLABLE BBYOLG) */
    {{'\xeb', '\xbe', '\xba'}, 3, 0xBFBA}, /* (HANGUL SYLLABLE BBYOLM) */
    {{'\xeb', '\xbe', '\xbb'}, 3, 0xBFBB}, /* (HANGUL SYLLABLE BBYOLB) */
    {{'\xeb', '\xbe', '\xbc'}, 3, 0xBFBC}, /* (HANGUL SYLLABLE BBYOLS) */
    {{'\xeb', '\xbe', '\xbd'}, 3, 0xBFBD}, /* (HANGUL SYLLABLE BBYOLT) */
    {{'\xeb', '\xbe', '\xbe'}, 3, 0xBFBE}, /* (HANGUL SYLLABLE BBYOLP) */
    {{'\xeb', '\xbe', '\xbf'}, 3, 0xBFBF}, /* (HANGUL SYLLABLE BBYOLH) */
    {{'\xeb', '\xbf', '\x80'}, 3, 0xBFC0}, /* (HANGUL SYLLABLE BBYOM) */
    {{'\xeb', '\xbf', '\x81'}, 3, 0xBFC1}, /* (HANGUL SYLLABLE BBYOB) */
    {{'\xeb', '\xbf', '\x82'}, 3, 0xBFC2}, /* (HANGUL SYLLABLE BBYOBS) */
    {{'\xeb', '\xbf', '\x83'}, 3, 0xBFC3}, /* (HANGUL SYLLABLE BBYOS) */
    {{'\xeb', '\xbf', '\x84'}, 3, 0xBFC4}, /* (HANGUL SYLLABLE BBYOSS) */
    {{'\xeb', '\xbf', '\x86'}, 3, 0xBFC6}, /* (HANGUL SYLLABLE BBYOJ) */
    {{'\xeb', '\xbf', '\x87'}, 3, 0xBFC7}, /* (HANGUL SYLLABLE BBYOC) */
    {{'\xeb', '\xbf', '\x88'}, 3, 0xBFC8}, /* (HANGUL SYLLABLE BBYOK) */
    {{'\xeb', '\xbf', '\x89'}, 3, 0xBFC9}, /* (HANGUL SYLLABLE BBYOT) */
    {{'\xeb', '\xbf', '\x8a'}, 3, 0xBFCA}, /* (HANGUL SYLLABLE BBYOP) */
    {{'\xeb', '\xbf', '\x8b'}, 3, 0xBFCB}, /* (HANGUL SYLLABLE BBYOH) */
    {{'\xeb', '\xbf', '\x8e'}, 3, 0xBFCE}, /* (HANGUL SYLLABLE BBUGG) */
    {{'\xeb', '\xbf', '\x8f'}, 3, 0xBFCF}, /* (HANGUL SYLLABLE BBUGS) */
    {{'\xeb', '\xbf', '\x91'}, 3, 0xBFD1}, /* (HANGUL SYLLABLE BBUNJ) */
    {{'\xeb', '\xbf', '\x92'}, 3, 0xBFD2}, /* (HANGUL SYLLABLE BBUNH) */
    {{'\xeb', '\xbf', '\x93'}, 3, 0xBFD3}, /* (HANGUL SYLLABLE BBUD) */
    {{'\xeb', '\xbf', '\x95'}, 3, 0xBFD5}, /* (HANGUL SYLLABLE BBULG) */
    {{'\xeb', '\xbf', '\x96'}, 3, 0xBFD6}, /* (HANGUL SYLLABLE BBULM) */
    {{'\xeb', '\xbf', '\x97'}, 3, 0xBFD7}, /* (HANGUL SYLLABLE BBULB) */
    {{'\xeb', '\xbf', '\x98'}, 3, 0xBFD8}, /* (HANGUL SYLLABLE BBULS) */
    {{'\xeb', '\xbf', '\x99'}, 3, 0xBFD9}, /* (HANGUL SYLLABLE BBULT) */
    {{'\xeb', '\xbf', '\x9a'}, 3, 0xBFDA}, /* (HANGUL SYLLABLE BBULP) */
    {{'\xeb', '\xbf', '\x9b'}, 3, 0xBFDB}, /* (HANGUL SYLLABLE BBULH) */
    {{'\xeb', '\xbf', '\x9d'}, 3, 0xBFDD}, /* (HANGUL SYLLABLE BBUB) */
    {{'\xeb', '\xbf', '\x9e'}, 3, 0xBFDE}, /* (HANGUL SYLLABLE BBUBS) */
    {{'\xeb', '\xbf', '\xa0'}, 3, 0xBFE0}, /* (HANGUL SYLLABLE BBUSS) */
    {{'\xeb', '\xbf', '\xa2'}, 3, 0xBFE2}, /* (HANGUL SYLLABLE BBUJ) */
    {{'\xeb', '\xbf', '\xa3'}, 3, 0xBFE3}, /* (HANGUL SYLLABLE BBUC) */
    {{'\xeb', '\xbf', '\xa4'}, 3, 0xBFE4}, /* (HANGUL SYLLABLE BBUK) */
    {{'\xeb', '\xbf', '\xa5'}, 3, 0xBFE5}, /* (HANGUL SYLLABLE BBUT) */
    {{'\xeb', '\xbf', '\xa6'}, 3, 0xBFE6}, /* (HANGUL SYLLABLE BBUP) */
    {{'\xeb', '\xbf', '\xa7'}, 3, 0xBFE7}, /* (HANGUL SYLLABLE BBUH) */
    {{'\xeb', '\xbf', '\xa8'}, 3, 0xBFE8}, /* (HANGUL SYLLABLE BBWEO) */
    {{'\xeb', '\xbf', '\xa9'}, 3, 0xBFE9}, /* (HANGUL SYLLABLE BBWEOG) */
    {{'\xeb', '\xbf', '\xaa'}, 3, 0xBFEA}, /* (HANGUL SYLLABLE BBWEOGG) */
    {{'\xeb', '\xbf', '\xab'}, 3, 0xBFEB}, /* (HANGUL SYLLABLE BBWEOGS) */
    {{'\xeb', '\xbf', '\xac'}, 3, 0xBFEC}, /* (HANGUL SYLLABLE BBWEON) */
    {{'\xeb', '\xbf', '\xad'}, 3, 0xBFED}, /* (HANGUL SYLLABLE BBWEONJ) */
    {{'\xeb', '\xbf', '\xae'}, 3, 0xBFEE}, /* (HANGUL SYLLABLE BBWEONH) */
    {{'\xeb', '\xbf', '\xaf'}, 3, 0xBFEF}, /* (HANGUL SYLLABLE BBWEOD) */
    {{'\xeb', '\xbf', '\xb0'}, 3, 0xBFF0}, /* (HANGUL SYLLABLE BBWEOL) */
    {{'\xeb', '\xbf', '\xb1'}, 3, 0xBFF1}, /* (HANGUL SYLLABLE BBWEOLG) */
    {{'\xeb', '\xbf', '\xb2'}, 3, 0xBFF2}, /* (HANGUL SYLLABLE BBWEOLM) */
    {{'\xeb', '\xbf', '\xb3'}, 3, 0xBFF3}, /* (HANGUL SYLLABLE BBWEOLB) */
    {{'\xeb', '\xbf', '\xb4'}, 3, 0xBFF4}, /* (HANGUL SYLLABLE BBWEOLS) */
    {{'\xeb', '\xbf', '\xb5'}, 3, 0xBFF5}, /* (HANGUL SYLLABLE BBWEOLT) */
    {{'\xeb', '\xbf', '\xb6'}, 3, 0xBFF6}, /* (HANGUL SYLLABLE BBWEOLP) */
    {{'\xeb', '\xbf', '\xb7'}, 3, 0xBFF7}, /* (HANGUL SYLLABLE BBWEOLH) */
    {{'\xeb', '\xbf', '\xb8'}, 3, 0xBFF8}, /* (HANGUL SYLLABLE BBWEOM) */
    {{'\xeb', '\xbf', '\xb9'}, 3, 0xBFF9}, /* (HANGUL SYLLABLE BBWEOB) */
    {{'\xeb', '\xbf', '\xba'}, 3, 0xBFFA}, /* (HANGUL SYLLABLE BBWEOBS) */
    {{'\xeb', '\xbf', '\xbb'}, 3, 0xBFFB}, /* (HANGUL SYLLABLE BBWEOS) */
    {{'\xeb', '\xbf', '\xbc'}, 3, 0xBFFC}, /* (HANGUL SYLLABLE BBWEOSS) */
    {{'\xeb', '\xbf', '\xbd'}, 3, 0xBFFD}, /* (HANGUL SYLLABLE BBWEONG) */
    {{'\xeb', '\xbf', '\xbe'}, 3, 0xBFFE}, /* (HANGUL SYLLABLE BBWEOJ) */
    {{'\xeb', '\xbf', '\xbf'}, 3, 0xBFFF}, /* (HANGUL SYLLABLE BBWEOC) */
    {{'\xec', '\x80', '\x80'}, 3, 0xC000}, /* (HANGUL SYLLABLE BBWEOK) */
    {{'\xec', '\x80', '\x81'}, 3, 0xC001}, /* (HANGUL SYLLABLE BBWEOT) */
    {{'\xec', '\x80', '\x82'}, 3, 0xC002}, /* (HANGUL SYLLABLE BBWEOP) */
    {{'\xec', '\x80', '\x83'}, 3, 0xC003}, /* (HANGUL SYLLABLE BBWEOH) */
    {{'\xec', '\x80', '\x84'}, 3, 0xC004}, /* (HANGUL SYLLABLE BBWE) */
    {{'\xec', '\x80', '\x85'}, 3, 0xC005}, /* (HANGUL SYLLABLE BBWEG) */
    {{'\xec', '\x80', '\x86'}, 3, 0xC006}, /* (HANGUL SYLLABLE BBWEGG) */
    {{'\xec', '\x80', '\x87'}, 3, 0xC007}, /* (HANGUL SYLLABLE BBWEGS) */
    {{'\xec', '\x80', '\x88'}, 3, 0xC008}, /* (HANGUL SYLLABLE BBWEN) */
    {{'\xec', '\x80', '\x89'}, 3, 0xC009}, /* (HANGUL SYLLABLE BBWENJ) */
    {{'\xec', '\x80', '\x8a'}, 3, 0xC00A}, /* (HANGUL SYLLABLE BBWENH) */
    {{'\xec', '\x80', '\x8b'}, 3, 0xC00B}, /* (HANGUL SYLLABLE BBWED) */
    {{'\xec', '\x80', '\x8c'}, 3, 0xC00C}, /* (HANGUL SYLLABLE BBWEL) */
    {{'\xec', '\x80', '\x8d'}, 3, 0xC00D}, /* (HANGUL SYLLABLE BBWELG) */
    {{'\xec', '\x80', '\x8e'}, 3, 0xC00E}, /* (HANGUL SYLLABLE BBWELM) */
    {{'\xec', '\x80', '\x8f'}, 3, 0xC00F}, /* (HANGUL SYLLABLE BBWELB) */
    {{'\xec', '\x80', '\x90'}, 3, 0xC010}, /* (HANGUL SYLLABLE BBWELS) */
    {{'\xec', '\x80', '\x91'}, 3, 0xC011}, /* (HANGUL SYLLABLE BBWELT) */
    {{'\xec', '\x80', '\x92'}, 3, 0xC012}, /* (HANGUL SYLLABLE BBWELP) */
    {{'\xec', '\x80', '\x93'}, 3, 0xC013}, /* (HANGUL SYLLABLE BBWELH) */
    {{'\xec', '\x80', '\x94'}, 3, 0xC014}, /* (HANGUL SYLLABLE BBWEM) */
    {{'\xec', '\x80', '\x95'}, 3, 0xC015}, /* (HANGUL SYLLABLE BBWEB) */
    {{'\xec', '\x80', '\x96'}, 3, 0xC016}, /* (HANGUL SYLLABLE BBWEBS) */
    {{'\xec', '\x80', '\x97'}, 3, 0xC017}, /* (HANGUL SYLLABLE BBWES) */
    {{'\xec', '\x80', '\x98'}, 3, 0xC018}, /* (HANGUL SYLLABLE BBWESS) */
    {{'\xec', '\x80', '\x99'}, 3, 0xC019}, /* (HANGUL SYLLABLE BBWENG) */
    {{'\xec', '\x80', '\x9a'}, 3, 0xC01A}, /* (HANGUL SYLLABLE BBWEJ) */
    {{'\xec', '\x80', '\x9b'}, 3, 0xC01B}, /* (HANGUL SYLLABLE BBWEC) */
    {{'\xec', '\x80', '\x9c'}, 3, 0xC01C}, /* (HANGUL SYLLABLE BBWEK) */
    {{'\xec', '\x80', '\x9d'}, 3, 0xC01D}, /* (HANGUL SYLLABLE BBWET) */
    {{'\xec', '\x80', '\x9e'}, 3, 0xC01E}, /* (HANGUL SYLLABLE BBWEP) */
    {{'\xec', '\x80', '\x9f'}, 3, 0xC01F}, /* (HANGUL SYLLABLE BBWEH) */
    {{'\xec', '\x80', '\xa0'}, 3, 0xC020}, /* (HANGUL SYLLABLE BBWI) */
    {{'\xec', '\x80', '\xa1'}, 3, 0xC021}, /* (HANGUL SYLLABLE BBWIG) */
    {{'\xec', '\x80', '\xa2'}, 3, 0xC022}, /* (HANGUL SYLLABLE BBWIGG) */
    {{'\xec', '\x80', '\xa3'}, 3, 0xC023}, /* (HANGUL SYLLABLE BBWIGS) */
    {{'\xec', '\x80', '\xa4'}, 3, 0xC024}, /* (HANGUL SYLLABLE BBWIN) */
    {{'\xec', '\x80', '\xa5'}, 3, 0xC025}, /* (HANGUL SYLLABLE BBWINJ) */
    {{'\xec', '\x80', '\xa6'}, 3, 0xC026}, /* (HANGUL SYLLABLE BBWINH) */
    {{'\xec', '\x80', '\xa7'}, 3, 0xC027}, /* (HANGUL SYLLABLE BBWID) */
    {{'\xec', '\x80', '\xa8'}, 3, 0xC028}, /* (HANGUL SYLLABLE BBWIL) */
    {{'\xec', '\x80', '\xa9'}, 3, 0xC029}, /* (HANGUL SYLLABLE BBWILG) */
    {{'\xec', '\x80', '\xaa'}, 3, 0xC02A}, /* (HANGUL SYLLABLE BBWILM) */
    {{'\xec', '\x80', '\xab'}, 3, 0xC02B}, /* (HANGUL SYLLABLE BBWILB) */
    {{'\xec', '\x80', '\xac'}, 3, 0xC02C}, /* (HANGUL SYLLABLE BBWILS) */
    {{'\xec', '\x80', '\xad'}, 3, 0xC02D}, /* (HANGUL SYLLABLE BBWILT) */
    {{'\xec', '\x80', '\xae'}, 3, 0xC02E}, /* (HANGUL SYLLABLE BBWILP) */
    {{'\xec', '\x80', '\xaf'}, 3, 0xC02F}, /* (HANGUL SYLLABLE BBWILH) */
    {{'\xec', '\x80', '\xb0'}, 3, 0xC030}, /* (HANGUL SYLLABLE BBWIM) */
    {{'\xec', '\x80', '\xb1'}, 3, 0xC031}, /* (HANGUL SYLLABLE BBWIB) */
    {{'\xec', '\x80', '\xb2'}, 3, 0xC032}, /* (HANGUL SYLLABLE BBWIBS) */
    {{'\xec', '\x80', '\xb3'}, 3, 0xC033}, /* (HANGUL SYLLABLE BBWIS) */
    {{'\xec', '\x80', '\xb4'}, 3, 0xC034}, /* (HANGUL SYLLABLE BBWISS) */
    {{'\xec', '\x80', '\xb5'}, 3, 0xC035}, /* (HANGUL SYLLABLE BBWING) */
    {{'\xec', '\x80', '\xb6'}, 3, 0xC036}, /* (HANGUL SYLLABLE BBWIJ) */
    {{'\xec', '\x80', '\xb7'}, 3, 0xC037}, /* (HANGUL SYLLABLE BBWIC) */
    {{'\xec', '\x80', '\xb8'}, 3, 0xC038}, /* (HANGUL SYLLABLE BBWIK) */
    {{'\xec', '\x80', '\xb9'}, 3, 0xC039}, /* (HANGUL SYLLABLE BBWIT) */
    {{'\xec', '\x80', '\xba'}, 3, 0xC03A}, /* (HANGUL SYLLABLE BBWIP) */
    {{'\xec', '\x80', '\xbb'}, 3, 0xC03B}, /* (HANGUL SYLLABLE BBWIH) */
    {{'\xec', '\x80', '\xbd'}, 3, 0xC03D}, /* (HANGUL SYLLABLE BBYUG) */
    {{'\xec', '\x80', '\xbe'}, 3, 0xC03E}, /* (HANGUL SYLLABLE BBYUGG) */
    {{'\xec', '\x80', '\xbf'}, 3, 0xC03F}, /* (HANGUL SYLLABLE BBYUGS) */
    {{'\xec', '\x81', '\x80'}, 3, 0xC040}, /* (HANGUL SYLLABLE BBYUN) */
    {{'\xec', '\x81', '\x81'}, 3, 0xC041}, /* (HANGUL SYLLABLE BBYUNJ) */
    {{'\xec', '\x81', '\x82'}, 3, 0xC042}, /* (HANGUL SYLLABLE BBYUNH) */
    {{'\xec', '\x81', '\x83'}, 3, 0xC043}, /* (HANGUL SYLLABLE BBYUD) */
    {{'\xec', '\x81', '\x84'}, 3, 0xC044}, /* (HANGUL SYLLABLE BBYUL) */
    {{'\xec', '\x81', '\x85'}, 3, 0xC045}, /* (HANGUL SYLLABLE BBYULG) */
    {{'\xec', '\x81', '\x86'}, 3, 0xC046}, /* (HANGUL SYLLABLE BBYULM) */
    {{'\xec', '\x81', '\x87'}, 3, 0xC047}, /* (HANGUL SYLLABLE BBYULB) */
    {{'\xec', '\x81', '\x88'}, 3, 0xC048}, /* (HANGUL SYLLABLE BBYULS) */
    {{'\xec', '\x81', '\x89'}, 3, 0xC049}, /* (HANGUL SYLLABLE BBYULT) */
    {{'\xec', '\x81', '\x8a'}, 3, 0xC04A}, /* (HANGUL SYLLABLE BBYULP) */
    {{'\xec', '\x81', '\x8b'}, 3, 0xC04B}, /* (HANGUL SYLLABLE BBYULH) */
    {{'\xec', '\x81', '\x8c'}, 3, 0xC04C}, /* (HANGUL SYLLABLE BBYUM) */
    {{'\xec', '\x81', '\x8d'}, 3, 0xC04D}, /* (HANGUL SYLLABLE BBYUB) */
    {{'\xec', '\x81', '\x8e'}, 3, 0xC04E}, /* (HANGUL SYLLABLE BBYUBS) */
    {{'\xec', '\x81', '\x8f'}, 3, 0xC04F}, /* (HANGUL SYLLABLE BBYUS) */
    {{'\xec', '\x81', '\x90'}, 3, 0xC050}, /* (HANGUL SYLLABLE BBYUSS) */
    {{'\xec', '\x81', '\x92'}, 3, 0xC052}, /* (HANGUL SYLLABLE BBYUJ) */
    {{'\xec', '\x81', '\x93'}, 3, 0xC053}, /* (HANGUL SYLLABLE BBYUC) */
    {{'\xec', '\x81', '\x94'}, 3, 0xC054}, /* (HANGUL SYLLABLE BBYUK) */
    {{'\xec', '\x81', '\x95'}, 3, 0xC055}, /* (HANGUL SYLLABLE BBYUT) */
    {{'\xec', '\x81', '\x96'}, 3, 0xC056}, /* (HANGUL SYLLABLE BBYUP) */
    {{'\xec', '\x81', '\x97'}, 3, 0xC057}, /* (HANGUL SYLLABLE BBYUH) */
    {{'\xec', '\x81', '\x99'}, 3, 0xC059}, /* (HANGUL SYLLABLE BBEUG) */
    {{'\xec', '\x81', '\x9a'}, 3, 0xC05A}, /* (HANGUL SYLLABLE BBEUGG) */
    {{'\xec', '\x81', '\x9b'}, 3, 0xC05B}, /* (HANGUL SYLLABLE BBEUGS) */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{'\xec', '\x81', '\x9d'}, 3, 0xC05D}, /* (HANGUL SYLLABLE BBEUNJ) */
    {{'\xec', '\x81', '\x9e'}, 3, 0xC05E}, /* (HANGUL SYLLABLE BBEUNH) */
    {{'\xec', '\x81', '\x9f'}, 3, 0xC05F}, /* (HANGUL SYLLABLE BBEUD) */
    {{'\xec', '\x81', '\xa1'}, 3, 0xC061}, /* (HANGUL SYLLABLE BBEULG) */
    {{'\xec', '\x81', '\xa2'}, 3, 0xC062}, /* (HANGUL SYLLABLE BBEULM) */
    {{'\xec', '\x81', '\xa3'}, 3, 0xC063}, /* (HANGUL SYLLABLE BBEULB) */
    {{'\xec', '\x81', '\xa4'}, 3, 0xC064}, /* (HANGUL SYLLABLE BBEULS) */
    {{'\xec', '\x81', '\xa5'}, 3, 0xC065}, /* (HANGUL SYLLABLE BBEULT) */
    {{'\xec', '\x81', '\xa6'}, 3, 0xC066}, /* (HANGUL SYLLABLE BBEULP) */
    {{'\xec', '\x81', '\xa7'}, 3, 0xC067}, /* (HANGUL SYLLABLE BBEULH) */
    {{'\xec', '\x81', '\xaa'}, 3, 0xC06A}, /* (HANGUL SYLLABLE BBEUBS) */
    {{'\xec', '\x81', '\xab'}, 3, 0xC06B}, /* (HANGUL SYLLABLE BBEUS) */
    {{'\xec', '\x81', '\xac'}, 3, 0xC06C}, /* (HANGUL SYLLABLE BBEUSS) */
    {{'\xec', '\x81', '\xad'}, 3, 0xC06D}, /* (HANGUL SYLLABLE BBEUNG) */
    {{'\xec', '\x81', '\xae'}, 3, 0xC06E}, /* (HANGUL SYLLABLE BBEUJ) */
    {{'\xec', '\x81', '\xaf'}, 3, 0xC06F}, /* (HANGUL SYLLABLE BBEUC) */
    {{'\xec', '\x81', '\xb0'}, 3, 0xC070}, /* (HANGUL SYLLABLE BBEUK) */
    {{'\xec', '\x81', '\xb1'}, 3, 0xC071}, /* (HANGUL SYLLABLE BBEUT) */
    {{'\xec', '\x81', '\xb2'}, 3, 0xC072}, /* (HANGUL SYLLABLE BBEUP) */
    {{'\xec', '\x81', '\xb3'}, 3, 0xC073}, /* (HANGUL SYLLABLE BBEUH) */
    {{'\xec', '\x81', '\xb4'}, 3, 0xC074}, /* (HANGUL SYLLABLE BBYI) */
    {{'\xec', '\x81', '\xb5'}, 3, 0xC075}, /* (HANGUL SYLLABLE BBYIG) */
    {{'\xec', '\x81', '\xb6'}, 3, 0xC076}, /* (HANGUL SYLLABLE BBYIGG) */
    {{'\xec', '\x81', '\xb7'}, 3, 0xC077}, /* (HANGUL SYLLABLE BBYIGS) */
    {{'\xec', '\x81', '\xb8'}, 3, 0xC078}, /* (HANGUL SYLLABLE BBYIN) */
    {{'\xec', '\x81', '\xb9'}, 3, 0xC079}, /* (HANGUL SYLLABLE BBYINJ) */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{'\xec', '\x81', '\xba'}, 3, 0xC07A}, /* (HANGUL SYLLABLE BBYINH) */
    {{'\xec', '\x81', '\xbb'}, 3, 0xC07B}, /* (HANGUL SYLLABLE BBYID) */
    {{'\xec', '\x81', '\xbc'}, 3, 0xC07C}, /* (HANGUL SYLLABLE BBYIL) */
    {{'\xec', '\x81', '\xbd'}, 3, 0xC07D}, /* (HANGUL SYLLABLE BBYILG) */
    {{'\xec', '\x81', '\xbe'}, 3, 0xC07E}, /* (HANGUL SYLLABLE BBYILM) */
    {{'\xec', '\x81', '\xbf'}, 3, 0xC07F}, /* (HANGUL SYLLABLE BBYILB) */
    {{'\xec', '\x82', '\x80'}, 3, 0xC080}, /* (HANGUL SYLLABLE BBYILS) */
    {{'\xec', '\x82', '\x81'}, 3, 0xC081}, /* (HANGUL SYLLABLE BBYILT) */
    {{'\xec', '\x82', '\x82'}, 3, 0xC082}, /* (HANGUL SYLLABLE BBYILP) */
    {{'\xec', '\x82', '\x83'}, 3, 0xC083}, /* (HANGUL SYLLABLE BBYILH) */
    {{'\xec', '\x82', '\x84'}, 3, 0xC084}, /* (HANGUL SYLLABLE BBYIM) */
    {{'\xec', '\x82', '\x85'}, 3, 0xC085}, /* (HANGUL SYLLABLE BBYIB) */
    {{'\xec', '\x82', '\x86'}, 3, 0xC086}, /* (HANGUL SYLLABLE BBYIBS) */
    {{'\xec', '\x82', '\x87'}, 3, 0xC087}, /* (HANGUL SYLLABLE BBYIS) */
    {{'\xec', '\x82', '\x88'}, 3, 0xC088}, /* (HANGUL SYLLABLE BBYISS) */
    {{'\xec', '\x82', '\x89'}, 3, 0xC089}, /* (HANGUL SYLLABLE BBYING) */
    {{'\xec', '\x82', '\x8a'}, 3, 0xC08A}, /* (HANGUL SYLLABLE BBYIJ) */
    {{'\xec', '\x82', '\x8b'}, 3, 0xC08B}, /* (HANGUL SYLLABLE BBYIC) */
    {{'\xec', '\x82', '\x8c'}, 3, 0xC08C}, /* (HANGUL SYLLABLE BBYIK) */
    {{'\xec', '\x82', '\x8d'}, 3, 0xC08D}, /* (HANGUL SYLLABLE BBYIT) */
    {{'\xec', '\x82', '\x8e'}, 3, 0xC08E}, /* (HANGUL SYLLABLE BBYIP) */
    {{'\xec', '\x82', '\x8f'}, 3, 0xC08F}, /* (HANGUL SYLLABLE BBYIH) */
    {{'\xec', '\x82', '\x92'}, 3, 0xC092}, /* (HANGUL SYLLABLE BBIGG) */
    {{'\xec', '\x82', '\x93'}, 3, 0xC093}, /* (HANGUL SYLLABLE BBIGS) */
    {{'\xec', '\x82', '\x95'}, 3, 0xC095}, /* (HANGUL SYLLABLE BBINJ) */
    {{'\xec', '\x82', '\x96'}, 3, 0xC096}, /* (HANGUL SYLLABLE BBINH) */
    {{'\xec', '\x82', '\x97'}, 3, 0xC097}, /* (HANGUL SYLLABLE BBID) */
    {{'\xec', '\x82', '\x99'}, 3, 0xC099}, /* (HANGUL SYLLABLE BBILG) */
    {{'\xec', '\x82', '\x9a'}, 3, 0xC09A}, /* (HANGUL SYLLABLE BBILM) */
    {{'\xec', '\x82', '\x9b'}, 3, 0xC09B}, /* (HANGUL SYLLABLE BBILB) */
    {{'\xec', '\x82', '\x9c'}, 3, 0xC09C}, /* (HANGUL SYLLABLE BBILS) */
    {{'\xec', '\x82', '\x9d'}, 3, 0xC09D}, /* (HANGUL SYLLABLE BBILT) */
    {{'\xec', '\x82', '\x9e'}, 3, 0xC09E}, /* (HANGUL SYLLABLE BBILP) */
    {{'\xec', '\x82', '\x9f'}, 3, 0xC09F}, /* (HANGUL SYLLABLE BBILH) */
    {{'\xec', '\x82', '\xa2'}, 3, 0xC0A2}, /* (HANGUL SYLLABLE BBIBS) */
    {{'\xec', '\x82', '\xa4'}, 3, 0xC0A4}, /* (HANGUL SYLLABLE BBISS) */
    {{'\xec', '\x82', '\xa6'}, 3, 0xC0A6}, /* (HANGUL SYLLABLE BBIJ) */
    {{'\xec', '\x82', '\xa7'}, 3, 0xC0A7}, /* (HANGUL SYLLABLE BBIC) */
    {{'\xec', '\x82', '\xa8'}, 3, 0xC0A8}, /* (HANGUL SYLLABLE BBIK) */
    {{'\xec', '\x82', '\xa9'}, 3, 0xC0A9}, /* (HANGUL SYLLABLE BBIT) */
    {{'\xec', '\x82', '\xaa'}, 3, 0xC0AA}, /* (HANGUL SYLLABLE BBIP) */
    {{'\xec', '\x82', '\xab'}, 3, 0xC0AB}, /* (HANGUL SYLLABLE BBIH) */
    {{'\xec', '\x82', '\xae'}, 3, 0xC0AE}, /* (HANGUL SYLLABLE SAGG) */
    {{'\xec', '\x82', '\xb1'}, 3, 0xC0B1}, /* (HANGUL SYLLABLE SANJ) */
    {{'\xec', '\x82', '\xb2'}, 3, 0xC0B2}, /* (HANGUL SYLLABLE SANH) */
    {{'\xec', '\x82', '\xb7'}, 3, 0xC0B7}, /* (HANGUL SYLLABLE SALB) */
    {{'\xec', '\x82', '\xb8'}, 3, 0xC0B8}, /* (HANGUL SYLLABLE SALS) */
    {{'\xec', '\x82', '\xb9'}, 3, 0xC0B9}, /* (HANGUL SYLLABLE SALT) */
    {{'\xec', '\x82', '\xba'}, 3, 0xC0BA}, /* (HANGUL SYLLABLE SALP) */
    {{'\xec', '\x82', '\xbb'}, 3, 0xC0BB}, /* (HANGUL SYLLABLE SALH) */
    {{'\xec', '\x82', '\xbe'}, 3, 0xC0BE}, /* (HANGUL SYLLABLE SABS) */
    {{'\xec', '\x83', '\x82'}, 3, 0xC0C2}, /* (HANGUL SYLLABLE SAJ) */
    {{'\xec', '\x83', '\x83'}, 3, 0xC0C3}, /* (HANGUL SYLLABLE SAC) */
    {{'\xec', '\x83', '\x84'}, 3, 0xC0C4}, /* (HANGUL SYLLABLE SAK) */
    {{'\xec', '\x83', '\x86'}, 3, 0xC0C6}, /* (HANGUL SYLLABLE SAP) */
    {{'\xec', '\x83', '\x87'}, 3, 0xC0C7}, /* (HANGUL SYLLABLE SAH) */
    {{'\xec', '\x83', '\x8a'}, 3, 0xC0CA}, /* (HANGUL SYLLABLE SAEGG) */
    {{'\xec', '\x83', '\x8b'}, 3, 0xC0CB}, /* (HANGUL SYLLABLE SAEGS) */
    {{'\xec', '\x83', '\x8d'}, 3, 0xC0CD}, /* (HANGUL SYLLABLE SAENJ) */
    {{'\xec', '\x83', '\x8e'}, 3, 0xC0CE}, /* (HANGUL SYLLABLE SAENH) */
    {{'\xec', '\x83', '\x8f'}, 3, 0xC0CF}, /* (HANGUL SYLLABLE SAED) */
    {{'\xec', '\x83', '\x91'}, 3, 0xC0D1}, /* (HANGUL SYLLABLE SAELG) */
    {{'\xec', '\x83', '\x92'}, 3, 0xC0D2}, /* (HANGUL SYLLABLE SAELM) */
    {{'\xec', '\x83', '\x93'}, 3, 0xC0D3}, /* (HANGUL SYLLABLE SAELB) */
    {{'\xec', '\x83', '\x94'}, 3, 0xC0D4}, /* (HANGUL SYLLABLE SAELS) */
    {{'\xec', '\x83', '\x95'}, 3, 0xC0D5}, /* (HANGUL SYLLABLE SAELT) */
    {{'\xec', '\x83', '\x96'}, 3, 0xC0D6}, /* (HANGUL SYLLABLE SAELP) */
    {{'\xec', '\x83', '\x97'}, 3, 0xC0D7}, /* (HANGUL SYLLABLE SAELH) */
    {{'\xec', '\x83', '\x9a'}, 3, 0xC0DA}, /* (HANGUL SYLLABLE SAEBS) */
    {{'\xec', '\x83', '\x9e'}, 3, 0xC0DE}, /* (HANGUL SYLLABLE SAEJ) */
    {{'\xec', '\x83', '\x9f'}, 3, 0xC0DF}, /* (HANGUL SYLLABLE SAEC) */
    {{'\xec', '\x83', '\xa0'}, 3, 0xC0E0}, /* (HANGUL SYLLABLE SAEK) */
    {{'\xec', '\x83', '\xa1'}, 3, 0xC0E1}, /* (HANGUL SYLLABLE SAET) */
    {{'\xec', '\x83', '\xa2'}, 3, 0xC0E2}, /* (HANGUL SYLLABLE SAEP) */
    {{'\xec', '\x83', '\xa3'}, 3, 0xC0E3}, /* (HANGUL SYLLABLE SAEH) */
    {{'\xec', '\x83', '\xa6'}, 3, 0xC0E6}, /* (HANGUL SYLLABLE SYAGG) */
    {{'\xec', '\x83', '\xa7'}, 3, 0xC0E7}, /* (HANGUL SYLLABLE SYAGS) */
    {{'\xec', '\x83', '\xa9'}, 3, 0xC0E9}, /* (HANGUL SYLLABLE SYANJ) */
    {{'\xec', '\x83', '\xaa'}, 3, 0xC0EA}, /* (HANGUL SYLLABLE SYANH) */
    {{'\xec', '\x83', '\xab'}, 3, 0xC0EB}, /* (HANGUL SYLLABLE SYAD) */
    {{'\xec', '\x83', '\xad'}, 3, 0xC0ED}, /* (HANGUL SYLLABLE SYALG) */
    {{'\xec', '\x83', '\xae'}, 3, 0xC0EE}, /* (HANGUL SYLLABLE SYALM) */
    {{'\xec', '\x83', '\xaf'}, 3, 0xC0EF}, /* (HANGUL SYLLABLE SYALB) */
    {{'\xec', '\x83', '\xb0'}, 3, 0xC0F0}, /* (HANGUL SYLLABLE SYALS) */
    {{'\xec', '\x83', '\xb1'}, 3, 0xC0F1}, /* (HANGUL SYLLABLE SYALT) */
    {{'\xec', '\x83', '\xb2'}, 3, 0xC0F2}, /* (HANGUL SYLLABLE SYALP) */
    {{'\xec', '\x83', '\xb3'}, 3, 0xC0F3}, /* (HANGUL SYLLABLE SYALH) */
    {{'\xec', '\x83', '\xb6'}, 3, 0xC0F6}, /* (HANGUL SYLLABLE SYABS) */
    {{'\xec', '\x83', '\xb8'}, 3, 0xC0F8}, /* (HANGUL SYLLABLE SYASS) */
    {{'\xec', '\x83', '\xba'}, 3, 0xC0FA}, /* (HANGUL SYLLABLE SYAJ) */
    {{'\xec', '\x83', '\xbb'}, 3, 0xC0FB}, /* (HANGUL SYLLABLE SYAC) */
    {{'\xec', '\x83', '\xbc'}, 3, 0xC0FC}, /* (HANGUL SYLLABLE SYAK) */
    {{'\xec', '\x83', '\xbd'}, 3, 0xC0FD}, /* (HANGUL SYLLABLE SYAT) */
    {{'\xec', '\x83', '\xbe'}, 3, 0xC0FE}, /* (HANGUL SYLLABLE SYAP) */
    {{'\xec', '\x83', '\xbf'}, 3, 0xC0FF}, /* (HANGUL SYLLABLE SYAH) */
    {{'\xec', '\x84', '\x81'}, 3, 0xC101}, /* (HANGUL SYLLABLE SYAEG) */
    {{'\xec', '\x84', '\x82'}, 3, 0xC102}, /* (HANGUL SYLLABLE SYAEGG) */
    {{'\xec', '\x84', '\x83'}, 3, 0xC103}, /* (HANGUL SYLLABLE SYAEGS) */
    {{'\xec', '\x84', '\x85'}, 3, 0xC105}, /* (HANGUL SYLLABLE SYAENJ) */
    {{'\xec', '\x84', '\x86'}, 3, 0xC106}, /* (HANGUL SYLLABLE SYAENH) */
    {{'\xec', '\x84', '\x87'}, 3, 0xC107}, /* (HANGUL SYLLABLE SYAED) */
    {{'\xec', '\x84', '\x89'}, 3, 0xC109}, /* (HANGUL SYLLABLE SYAELG) */
    {{'\xec', '\x84', '\x8a'}, 3, 0xC10A}, /* (HANGUL SYLLABLE SYAELM) */
    {{'\xec', '\x84', '\x8b'}, 3, 0xC10B}, /* (HANGUL SYLLABLE SYAELB) */
    {{'\xec', '\x84', '\x8c'}, 3, 0xC10C}, /* (HANGUL SYLLABLE SYAELS) */
    {{'\xec', '\x84', '\x8d'}, 3, 0xC10D}, /* (HANGUL SYLLABLE SYAELT) */
    {{'\xec', '\x84', '\x8e'}, 3, 0xC10E}, /* (HANGUL SYLLABLE SYAELP) */
    {{'\xec', '\x84', '\x8f'}, 3, 0xC10F}, /* (HANGUL SYLLABLE SYAELH) */
    {{'\xec', '\x84', '\x91'}, 3, 0xC111}, /* (HANGUL SYLLABLE SYAEB) */
    {{'\xec', '\x84', '\x92'}, 3, 0xC112}, /* (HANGUL SYLLABLE SYAEBS) */
    {{'\xec', '\x84', '\x93'}, 3, 0xC113}, /* (HANGUL SYLLABLE SYAES) */
    {{'\xec', '\x84', '\x94'}, 3, 0xC114}, /* (HANGUL SYLLABLE SYAESS) */
    {{'\xec', '\x84', '\x96'}, 3, 0xC116}, /* (HANGUL SYLLABLE SYAEJ) */
    {{'\xec', '\x84', '\x97'}, 3, 0xC117}, /* (HANGUL SYLLABLE SYAEC) */
    {{'\xec', '\x84', '\x98'}, 3, 0xC118}, /* (HANGUL SYLLABLE SYAEK) */
    {{'\xec', '\x84', '\x99'}, 3, 0xC119}, /* (HANGUL SYLLABLE SYAET) */
    {{'\xec', '\x84', '\x9a'}, 3, 0xC11A}, /* (HANGUL SYLLABLE SYAEP) */
    {{'\xec', '\x84', '\x9b'}, 3, 0xC11B}, /* (HANGUL SYLLABLE SYAEH) */
    {{'\xec', '\x84', '\xa1'}, 3, 0xC121}, /* (HANGUL SYLLABLE SEONJ) */
    {{'\xec', '\x84', '\xa2'}, 3, 0xC122}, /* (HANGUL SYLLABLE SEONH) */
    {{'\xec', '\x84', '\xa5'}, 3, 0xC125}, /* (HANGUL SYLLABLE SEOLG) */
    {{'\xec', '\x84', '\xa8'}, 3, 0xC128}, /* (HANGUL SYLLABLE SEOLS) */
    {{'\xec', '\x84', '\xa9'}, 3, 0xC129}, /* (HANGUL SYLLABLE SEOLT) */
    {{'\xec', '\x84', '\xaa'}, 3, 0xC12A}, /* (HANGUL SYLLABLE SEOLP) */
    {{'\xec', '\x84', '\xab'}, 3, 0xC12B}, /* (HANGUL SYLLABLE SEOLH) */
    {{'\xec', '\x84', '\xae'}, 3, 0xC12E}, /* (HANGUL SYLLABLE SEOBS) */
    {{'\xec', '\x84', '\xb2'}, 3, 0xC132}, /* (HANGUL SYLLABLE SEOJ) */
    {{'\xec', '\x84', '\xb3'}, 3, 0xC133}, /* (HANGUL SYLLABLE SEOC) */
    {{'\xec', '\x84', '\xb4'}, 3, 0xC134}, /* (HANGUL SYLLABLE SEOK) */
    {{'\xec', '\x84', '\xb5'}, 3, 0xC135}, /* (HANGUL SYLLABLE SEOT) */
    {{'\xec', '\x84', '\xb7'}, 3, 0xC137}, /* (HANGUL SYLLABLE SEOH) */
    {{'\xec', '\x84', '\xba'}, 3, 0xC13A}, /* (HANGUL SYLLABLE SEGG) */
    {{'\xec', '\x84', '\xbb'}, 3, 0xC13B}, /* (HANGUL SYLLABLE SEGS) */
    {{'\xec', '\x84', '\xbd'}, 3, 0xC13D}, /* (HANGUL SYLLABLE SENJ) */
    {{'\xec', '\x84', '\xbe'}, 3, 0xC13E}, /* (HANGUL SYLLABLE SENH) */
    {{'\xec', '\x84', '\xbf'}, 3, 0xC13F}, /* (HANGUL SYLLABLE SED) */
    {{'\xec', '\x85', '\x81'}, 3, 0xC141}, /* (HANGUL SYLLABLE SELG) */
    {{'\xec', '\x85', '\x82'}, 3, 0xC142}, /* (HANGUL SYLLABLE SELM) */
    {{'\xec', '\x85', '\x83'}, 3, 0xC143}, /* (HANGUL SYLLABLE SELB) */
    {{'\xec', '\x85', '\x84'}, 3, 0xC144}, /* (HANGUL SYLLABLE SELS) */
    {{'\xec', '\x85', '\x85'}, 3, 0xC145}, /* (HANGUL SYLLABLE SELT) */
    {{'\xec', '\x85', '\x86'}, 3, 0xC146}, /* (HANGUL SYLLABLE SELP) */
    {{'\xec', '\x85', '\x87'}, 3, 0xC147}, /* (HANGUL SYLLABLE SELH) */
    {{'\xec', '\x85', '\x8a'}, 3, 0xC14A}, /* (HANGUL SYLLABLE SEBS) */
    {{'\xec', '\x85', '\x8e'}, 3, 0xC14E}, /* (HANGUL SYLLABLE SEJ) */
    {{'\xec', '\x85', '\x8f'}, 3, 0xC14F}, /* (HANGUL SYLLABLE SEC) */
    {{'\xec', '\x85', '\x90'}, 3, 0xC150}, /* (HANGUL SYLLABLE SEK) */
    {{'\xec', '\x85', '\x91'}, 3, 0xC151}, /* (HANGUL SYLLABLE SET) */
    {{'\xec', '\x85', '\x92'}, 3, 0xC152}, /* (HANGUL SYLLABLE SEP) */
    {{'\xec', '\x85', '\x93'}, 3, 0xC153}, /* (HANGUL SYLLABLE SEH) */
    {{'\xec', '\x85', '\x96'}, 3, 0xC156}, /* (HANGUL SYLLABLE SYEOGG) */
    {{'\xec', '\x85', '\x97'}, 3, 0xC157}, /* (HANGUL SYLLABLE SYEOGS) */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{'\xec', '\x85', '\x99'}, 3, 0xC159}, /* (HANGUL SYLLABLE SYEONJ) */
    {{'\xec', '\x85', '\x9a'}, 3, 0xC15A}, /* (HANGUL SYLLABLE SYEONH) */
    {{'\xec', '\x85', '\x9b'}, 3, 0xC15B}, /* (HANGUL SYLLABLE SYEOD) */
    {{'\xec', '\x85', '\x9d'}, 3, 0xC15D}, /* (HANGUL SYLLABLE SYEOLG) */
    {{'\xec', '\x85', '\x9e'}, 3, 0xC15E}, /* (HANGUL SYLLABLE SYEOLM) */
    {{'\xec', '\x85', '\x9f'}, 3, 0xC15F}, /* (HANGUL SYLLABLE SYEOLB) */
    {{'\xec', '\x85', '\xa0'}, 3, 0xC160}, /* (HANGUL SYLLABLE SYEOLS) */
    {{'\xec', '\x85', '\xa1'}, 3, 0xC161}, /* (HANGUL SYLLABLE SYEOLT) */
    {{'\xec', '\x85', '\xa2'}, 3, 0xC162}, /* (HANGUL SYLLABLE SYEOLP) */
    {{'\xec', '\x85', '\xa3'}, 3, 0xC163}, /* (HANGUL SYLLABLE SYEOLH) */
    {{'\xec', '\x85', '\xa6'}, 3, 0xC166}, /* (HANGUL SYLLABLE SYEOBS) */
    {{'\xec', '\x85', '\xaa'}, 3, 0xC16A}, /* (HANGUL SYLLABLE SYEOJ) */
    {{'\xec', '\x85', '\xab'}, 3, 0xC16B}, /* (HANGUL SYLLABLE SYEOC) */
    {{'\xec', '\x85', '\xac'}, 3, 0xC16C}, /* (HANGUL SYLLABLE SYEOK) */
    {{'\xec', '\x85', '\xad'}, 3, 0xC16D}, /* (HANGUL SYLLABLE SYEOT) */
    {{'\xec', '\x85', '\xae'}, 3, 0xC16E}, /* (HANGUL SYLLABLE SYEOP) */
    {{'\xec', '\x85', '\xaf'}, 3, 0xC16F}, /* (HANGUL SYLLABLE SYEOH) */
    {{'\xec', '\x85', '\xb1'}, 3, 0xC171}, /* (HANGUL SYLLABLE SYEG) */
    {{'\xec', '\x85', '\xb2'}, 3, 0xC172}, /* (HANGUL SYLLABLE SYEGG) */
    {{'\xec', '\x85', '\xb3'}, 3, 0xC173}, /* (HANGUL SYLLABLE SYEGS) */
    {{'\xec', '\x85', '\xb5'}, 3, 0xC175}, /* (HANGUL SYLLABLE SYENJ) */
    {{'\xec', '\x85', '\xb6'}, 3, 0xC176}, /* (HANGUL SYLLABLE SYENH) */
    {{'\xec', '\x85', '\xb7'}, 3, 0xC177}, /* (HANGUL SYLLABLE SYED) */
    {{'\xec', '\x85', '\xb9'}, 3, 0xC179}, /* (HANGUL SYLLABLE SYELG) */
    {{'\xec', '\x85', '\xba'}, 3, 0xC17A}, /* (HANGUL SYLLABLE SYELM) */
    {{'\xec', '\x85', '\xbb'}, 3, 0xC17B}, /* (HANGUL SYLLABLE SYELB) */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{'\xec', '\x85', '\xbc'}, 3, 0xC17C}, /* (HANGUL SYLLABLE SYELS) */
    {{'\xec', '\x85', '\xbd'}, 3, 0xC17D}, /* (HANGUL SYLLABLE SYELT) */
    {{'\xec', '\x85', '\xbe'}, 3, 0xC17E}, /* (HANGUL SYLLABLE SYELP) */
    {{'\xec', '\x85', '\xbf'}, 3, 0xC17F}, /* (HANGUL SYLLABLE SYELH) */
    {{'\xec', '\x86', '\x80'}, 3, 0xC180}, /* (HANGUL SYLLABLE SYEM) */
    {{'\xec', '\x86', '\x81'}, 3, 0xC181}, /* (HANGUL SYLLABLE SYEB) */
    {{'\xec', '\x86', '\x82'}, 3, 0xC182}, /* (HANGUL SYLLABLE SYEBS) */
    {{'\xec', '\x86', '\x83'}, 3, 0xC183}, /* (HANGUL SYLLABLE SYES) */
    {{'\xec', '\x86', '\x84'}, 3, 0xC184}, /* (HANGUL SYLLABLE SYESS) */
    {{'\xec', '\x86', '\x86'}, 3, 0xC186}, /* (HANGUL SYLLABLE SYEJ) */
    {{'\xec', '\x86', '\x87'}, 3, 0xC187}, /* (HANGUL SYLLABLE SYEC) */
    {{'\xec', '\x86', '\x88'}, 3, 0xC188}, /* (HANGUL SYLLABLE SYEK) */
    {{'\xec', '\x86', '\x89'}, 3, 0xC189}, /* (HANGUL SYLLABLE SYET) */
    {{'\xec', '\x86', '\x8a'}, 3, 0xC18A}, /* (HANGUL SYLLABLE SYEP) */
    {{'\xec', '\x86', '\x8b'}, 3, 0xC18B}, /* (HANGUL SYLLABLE SYEH) */
    {{'\xec', '\x86', '\x8f'}, 3, 0xC18F}, /* (HANGUL SYLLABLE SOGS) */
    {{'\xec', '\x86', '\x91'}, 3, 0xC191}, /* (HANGUL SYLLABLE SONJ) */
    {{'\xec', '\x86', '\x92'}, 3, 0xC192}, /* (HANGUL SYLLABLE SONH) */
    {{'\xec', '\x86', '\x93'}, 3, 0xC193}, /* (HANGUL SYLLABLE SOD) */
    {{'\xec', '\x86', '\x95'}, 3, 0xC195}, /* (HANGUL SYLLABLE SOLG) */
    {{'\xec', '\x86', '\x97'}, 3, 0xC197}, /* (HANGUL SYLLABLE SOLB) */
    {{'\xec', '\x86', '\x98'}, 3, 0xC198}, /* (HANGUL SYLLABLE SOLS) */
    {{'\xec', '\x86', '\x99'}, 3, 0xC199}, /* (HANGUL SYLLABLE SOLT) */
    {{'\xec', '\x86', '\x9a'}, 3, 0xC19A}, /* (HANGUL SYLLABLE SOLP) */
    {{'\xec', '\x86', '\x9b'}, 3, 0xC19B}, /* (HANGUL SYLLABLE SOLH) */
    {{'\xec', '\x86', '\x9e'}, 3, 0xC19E}, /* (HANGUL SYLLABLE SOBS) */
    {{'\xec', '\x86', '\xa0'}, 3, 0xC1A0}, /* (HANGUL SYLLABLE SOSS) */
    {{'\xec', '\x86', '\xa2'}, 3, 0xC1A2}, /* (HANGUL SYLLABLE SOJ) */
    {{'\xec', '\x86', '\xa3'}, 3, 0xC1A3}, /* (HANGUL SYLLABLE SOC) */
    {{'\xec', '\x86', '\xa4'}, 3, 0xC1A4}, /* (HANGUL SYLLABLE SOK) */
    {{'\xec', '\x86', '\xa6'}, 3, 0xC1A6}, /* (HANGUL SYLLABLE SOP) */
    {{'\xec', '\x86', '\xa7'}, 3, 0xC1A7}, /* (HANGUL SYLLABLE SOH) */
    {{'\xec', '\x86', '\xaa'}, 3, 0xC1AA}, /* (HANGUL SYLLABLE SWAGG) */
    {{'\xec', '\x86', '\xab'}, 3, 0xC1AB}, /* (HANGUL SYLLABLE SWAGS) */
    {{'\xec', '\x86', '\xad'}, 3, 0xC1AD}, /* (HANGUL SYLLABLE SWANJ) */
    {{'\xec', '\x86', '\xae'}, 3, 0xC1AE}, /* (HANGUL SYLLABLE SWANH) */
    {{'\xec', '\x86', '\xaf'}, 3, 0xC1AF}, /* (HANGUL SYLLABLE SWAD) */
    {{'\xec', '\x86', '\xb1'}, 3, 0xC1B1}, /* (HANGUL SYLLABLE SWALG) */
    {{'\xec', '\x86', '\xb2'}, 3, 0xC1B2}, /* (HANGUL SYLLABLE SWALM) */
    {{'\xec', '\x86', '\xb3'}, 3, 0xC1B3}, /* (HANGUL SYLLABLE SWALB) */
    {{'\xec', '\x86', '\xb4'}, 3, 0xC1B4}, /* (HANGUL SYLLABLE SWALS) */
    {{'\xec', '\x86', '\xb5'}, 3, 0xC1B5}, /* (HANGUL SYLLABLE SWALT) */
    {{'\xec', '\x86', '\xb6'}, 3, 0xC1B6}, /* (HANGUL SYLLABLE SWALP) */
    {{'\xec', '\x86', '\xb7'}, 3, 0xC1B7}, /* (HANGUL SYLLABLE SWALH) */
    {{'\xec', '\x86', '\xb8'}, 3, 0xC1B8}, /* (HANGUL SYLLABLE SWAM) */
    {{'\xec', '\x86', '\xb9'}, 3, 0xC1B9}, /* (HANGUL SYLLABLE SWAB) */
    {{'\xec', '\x86', '\xba'}, 3, 0xC1BA}, /* (HANGUL SYLLABLE SWABS) */
    {{'\xec', '\x86', '\xbb'}, 3, 0xC1BB}, /* (HANGUL SYLLABLE SWAS) */
    {{'\xec', '\x86', '\xbc'}, 3, 0xC1BC}, /* (HANGUL SYLLABLE SWASS) */
    {{'\xec', '\x86', '\xbe'}, 3, 0xC1BE}, /* (HANGUL SYLLABLE SWAJ) */
    {{'\xec', '\x86', '\xbf'}, 3, 0xC1BF}, /* (HANGUL SYLLABLE SWAC) */
    {{'\xec', '\x87', '\x80'}, 3, 0xC1C0}, /* (HANGUL SYLLABLE SWAK) */
    {{'\xec', '\x87', '\x81'}, 3, 0xC1C1}, /* (HANGUL SYLLABLE SWAT) */
    {{'\xec', '\x87', '\x82'}, 3, 0xC1C2}, /* (HANGUL SYLLABLE SWAP) */
    {{'\xec', '\x87', '\x83'}, 3, 0xC1C3}, /* (HANGUL SYLLABLE SWAH) */
    {{'\xec', '\x87', '\x85'}, 3, 0xC1C5}, /* (HANGUL SYLLABLE SWAEG) */
    {{'\xec', '\x87', '\x86'}, 3, 0xC1C6}, /* (HANGUL SYLLABLE SWAEGG) */
    {{'\xec', '\x87', '\x87'}, 3, 0xC1C7}, /* (HANGUL SYLLABLE SWAEGS) */
    {{'\xec', '\x87', '\x89'}, 3, 0xC1C9}, /* (HANGUL SYLLABLE SWAENJ) */
    {{'\xec', '\x87', '\x8a'}, 3, 0xC1CA}, /* (HANGUL SYLLABLE SWAENH) */
    {{'\xec', '\x87', '\x8b'}, 3, 0xC1CB}, /* (HANGUL SYLLABLE SWAED) */
    {{'\xec', '\x87', '\x8d'}, 3, 0xC1CD}, /* (HANGUL SYLLABLE SWAELG) */
    {{'\xec', '\x87', '\x8e'}, 3, 0xC1CE}, /* (HANGUL SYLLABLE SWAELM) */
    {{'\xec', '\x87', '\x8f'}, 3, 0xC1CF}, /* (HANGUL SYLLABLE SWAELB) */
    {{'\xec', '\x87', '\x90'}, 3, 0xC1D0}, /* (HANGUL SYLLABLE SWAELS) */
    {{'\xec', '\x87', '\x91'}, 3, 0xC1D1}, /* (HANGUL SYLLABLE SWAELT) */
    {{'\xec', '\x87', '\x92'}, 3, 0xC1D2}, /* (HANGUL SYLLABLE SWAELP) */
    {{'\xec', '\x87', '\x93'}, 3, 0xC1D3}, /* (HANGUL SYLLABLE SWAELH) */
    {{'\xec', '\x87', '\x95'}, 3, 0xC1D5}, /* (HANGUL SYLLABLE SWAEB) */
    {{'\xec', '\x87', '\x96'}, 3, 0xC1D6}, /* (HANGUL SYLLABLE SWAEBS) */
    {{'\xec', '\x87', '\x99'}, 3, 0xC1D9}, /* (HANGUL SYLLABLE SWAENG) */
    {{'\xec', '\x87', '\x9a'}, 3, 0xC1DA}, /* (HANGUL SYLLABLE SWAEJ) */
    {{'\xec', '\x87', '\x9b'}, 3, 0xC1DB}, /* (HANGUL SYLLABLE SWAEC) */
    {{'\xec', '\x87', '\x9c'}, 3, 0xC1DC}, /* (HANGUL SYLLABLE SWAEK) */
    {{'\xec', '\x87', '\x9d'}, 3, 0xC1DD}, /* (HANGUL SYLLABLE SWAET) */
    {{'\xec', '\x87', '\x9e'}, 3, 0xC1DE}, /* (HANGUL SYLLABLE SWAEP) */
    {{'\xec', '\x87', '\x9f'}, 3, 0xC1DF}, /* (HANGUL SYLLABLE SWAEH) */
    {{'\xec', '\x87', '\xa1'}, 3, 0xC1E1}, /* (HANGUL SYLLABLE SOEG) */
    {{'\xec', '\x87', '\xa2'}, 3, 0xC1E2}, /* (HANGUL SYLLABLE SOEGG) */
    {{'\xec', '\x87', '\xa3'}, 3, 0xC1E3}, /* (HANGUL SYLLABLE SOEGS) */
    {{'\xec', '\x87', '\xa5'}, 3, 0xC1E5}, /* (HANGUL SYLLABLE SOENJ) */
    {{'\xec', '\x87', '\xa6'}, 3, 0xC1E6}, /* (HANGUL SYLLABLE SOENH) */
    {{'\xec', '\x87', '\xa7'}, 3, 0xC1E7}, /* (HANGUL SYLLABLE SOED) */
    {{'\xec', '\x87', '\xa9'}, 3, 0xC1E9}, /* (HANGUL SYLLABLE SOELG) */
    {{'\xec', '\x87', '\xaa'}, 3, 0xC1EA}, /* (HANGUL SYLLABLE SOELM) */
    {{'\xec', '\x87', '\xab'}, 3, 0xC1EB}, /* (HANGUL SYLLABLE SOELB) */
    {{'\xec', '\x87', '\xac'}, 3, 0xC1EC}, /* (HANGUL SYLLABLE SOELS) */
    {{'\xec', '\x87', '\xad'}, 3, 0xC1ED}, /* (HANGUL SYLLABLE SOELT) */
    {{'\xec', '\x87', '\xae'}, 3, 0xC1EE}, /* (HANGUL SYLLABLE SOELP) */
    {{'\xec', '\x87', '\xaf'}, 3, 0xC1EF}, /* (HANGUL SYLLABLE SOELH) */
    {{'\xec', '\x87', '\xb2'}, 3, 0xC1F2}, /* (HANGUL SYLLABLE SOEBS) */
    {{'\xec', '\x87', '\xb4'}, 3, 0xC1F4}, /* (HANGUL SYLLABLE SOESS) */
    {{'\xec', '\x87', '\xb5'}, 3, 0xC1F5}, /* (HANGUL SYLLABLE SOENG) */
    {{'\xec', '\x87', '\xb6'}, 3, 0xC1F6}, /* (HANGUL SYLLABLE SOEJ) */
    {{'\xec', '\x87', '\xb7'}, 3, 0xC1F7}, /* (HANGUL SYLLABLE SOEC) */
    {{'\xec', '\x87', '\xb8'}, 3, 0xC1F8}, /* (HANGUL SYLLABLE SOEK) */
    {{'\xec', '\x87', '\xb9'}, 3, 0xC1F9}, /* (HANGUL SYLLABLE SOET) */
    {{'\xec', '\x87', '\xba'}, 3, 0xC1FA}, /* (HANGUL SYLLABLE SOEP) */
    {{'\xec', '\x87', '\xbb'}, 3, 0xC1FB}, /* (HANGUL SYLLABLE SOEH) */
    {{'\xec', '\x87', '\xbe'}, 3, 0xC1FE}, /* (HANGUL SYLLABLE SYOGG) */
    {{'\xec', '\x87', '\xbf'}, 3, 0xC1FF}, /* (HANGUL SYLLABLE SYOGS) */
    {{'\xec', '\x88', '\x81'}, 3, 0xC201}, /* (HANGUL SYLLABLE SYONJ) */
    {{'\xec', '\x88', '\x82'}, 3, 0xC202}, /* (HANGUL SYLLABLE SYONH) */
    {{'\xec', '\x88', '\x83'}, 3, 0xC203}, /* (HANGUL SYLLABLE SYOD) */
    {{'\xec', '\x88', '\x85'}, 3, 0xC205}, /* (HANGUL SYLLABLE SYOLG) */
    {{'\xec', '\x88', '\x86'}, 3, 0xC206}, /* (HANGUL SYLLABLE SYOLM) */
    {{'\xec', '\x88', '\x87'}, 3, 0xC207}, /* (HANGUL SYLLABLE SYOLB) */
    {{'\xec', '\x88', '\x88'}, 3, 0xC208}, /* (HANGUL SYLLABLE SYOLS) */
    {{'\xec', '\x88', '\x89'}, 3, 0xC209}, /* (HANGUL SYLLABLE SYOLT) */
    {{'\xec', '\x88', '\x8a'}, 3, 0xC20A}, /* (HANGUL SYLLABLE SYOLP) */
    {{'\xec', '\x88', '\x8b'}, 3, 0xC20B}, /* (HANGUL SYLLABLE SYOLH) */
    {{'\xec', '\x88', '\x8e'}, 3, 0xC20E}, /* (HANGUL SYLLABLE SYOBS) */
    {{'\xec', '\x88', '\x90'}, 3, 0xC210}, /* (HANGUL SYLLABLE SYOSS) */
    {{'\xec', '\x88', '\x92'}, 3, 0xC212}, /* (HANGUL SYLLABLE SYOJ) */
    {{'\xec', '\x88', '\x93'}, 3, 0xC213}, /* (HANGUL SYLLABLE SYOC) */
    {{'\xec', '\x88', '\x94'}, 3, 0xC214}, /* (HANGUL SYLLABLE SYOK) */
    {{'\xec', '\x88', '\x95'}, 3, 0xC215}, /* (HANGUL SYLLABLE SYOT) */
    {{'\xec', '\x88', '\x96'}, 3, 0xC216}, /* (HANGUL SYLLABLE SYOP) */
    {{'\xec', '\x88', '\x97'}, 3, 0xC217}, /* (HANGUL SYLLABLE SYOH) */
    {{'\xec', '\x88', '\x9a'}, 3, 0xC21A}, /* (HANGUL SYLLABLE SUGG) */
    {{'\xec', '\x88', '\x9b'}, 3, 0xC21B}, /* (HANGUL SYLLABLE SUGS) */
    {{'\xec', '\x88', '\x9d'}, 3, 0xC21D}, /* (HANGUL SYLLABLE SUNJ) */
    {{'\xec', '\x88', '\x9e'}, 3, 0xC21E}, /* (HANGUL SYLLABLE SUNH) */
    {{'\xec', '\x88', '\xa1'}, 3, 0xC221}, /* (HANGUL SYLLABLE SULG) */
    {{'\xec', '\x88', '\xa2'}, 3, 0xC222}, /* (HANGUL SYLLABLE SULM) */
    {{'\xec', '\x88', '\xa3'}, 3, 0xC223}, /* (HANGUL SYLLABLE SULB) */
    {{'\xec', '\x88', '\xa4'}, 3, 0xC224}, /* (HANGUL SYLLABLE SULS) */
    {{'\xec', '\x88', '\xa5'}, 3, 0xC225}, /* (HANGUL SYLLABLE SULT) */
    {{'\xec', '\x88', '\xa6'}, 3, 0xC226}, /* (HANGUL SYLLABLE SULP) */
    {{'\xec', '\x88', '\xa7'}, 3, 0xC227}, /* (HANGUL SYLLABLE SULH) */
    {{'\xec', '\x88', '\xaa'}, 3, 0xC22A}, /* (HANGUL SYLLABLE SUBS) */
    {{'\xec', '\x88', '\xac'}, 3, 0xC22C}, /* (HANGUL SYLLABLE SUSS) */
    {{'\xec', '\x88', '\xae'}, 3, 0xC22E}, /* (HANGUL SYLLABLE SUJ) */
    {{'\xec', '\x88', '\xb0'}, 3, 0xC230}, /* (HANGUL SYLLABLE SUK) */
    {{'\xec', '\x88', '\xb3'}, 3, 0xC233}, /* (HANGUL SYLLABLE SUH) */
    {{'\xec', '\x88', '\xb5'}, 3, 0xC235}, /* (HANGUL SYLLABLE SWEOG) */
    {{'\xec', '\x88', '\xb6'}, 3, 0xC236}, /* (HANGUL SYLLABLE SWEOGG) */
    {{'\xec', '\x88', '\xb7'}, 3, 0xC237}, /* (HANGUL SYLLABLE SWEOGS) */
    {{'\xec', '\x88', '\xb8'}, 3, 0xC238}, /* (HANGUL SYLLABLE SWEON) */
    {{'\xec', '\x88', '\xb9'}, 3, 0xC239}, /* (HANGUL SYLLABLE SWEONJ) */
    {{'\xec', '\x88', '\xba'}, 3, 0xC23A}, /* (HANGUL SYLLABLE SWEONH) */
    {{'\xec', '\x88', '\xbb'}, 3, 0xC23B}, /* (HANGUL SYLLABLE SWEOD) */
    {{'\xec', '\x88', '\xbc'}, 3, 0xC23C}, /* (HANGUL SYLLABLE SWEOL) */
    {{'\xec', '\x88', '\xbd'}, 3, 0xC23D}, /* (HANGUL SYLLABLE SWEOLG) */
    {{'\xec', '\x88', '\xbe'}, 3, 0xC23E}, /* (HANGUL SYLLABLE SWEOLM) */
    {{'\xec', '\x88', '\xbf'}, 3, 0xC23F}, /* (HANGUL SYLLABLE SWEOLB) */
    {{'\xec', '\x89', '\x80'}, 3, 0xC240}, /* (HANGUL SYLLABLE SWEOLS) */
    {{'\xec', '\x89', '\x81'}, 3, 0xC241}, /* (HANGUL SYLLABLE SWEOLT) */
    {{'\xec', '\x89', '\x82'}, 3, 0xC242}, /* (HANGUL SYLLABLE SWEOLP) */
    {{'\xec', '\x89', '\x83'}, 3, 0xC243}, /* (HANGUL SYLLABLE SWEOLH) */
    {{'\xec', '\x89', '\x84'}, 3, 0xC244}, /* (HANGUL SYLLABLE SWEOM) */
    {{'\xec', '\x89', '\x85'}, 3, 0xC245}, /* (HANGUL SYLLABLE SWEOB) */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{'\xec', '\x89', '\x86'}, 3, 0xC246}, /* (HANGUL SYLLABLE SWEOBS) */
    {{'\xec', '\x89', '\x87'}, 3, 0xC247}, /* (HANGUL SYLLABLE SWEOS) */
    {{'\xec', '\x89', '\x89'}, 3, 0xC249}, /* (HANGUL SYLLABLE SWEONG) */
    {{'\xec', '\x89', '\x8a'}, 3, 0xC24A}, /* (HANGUL SYLLABLE SWEOJ) */
    {{'\xec', '\x89', '\x8b'}, 3, 0xC24B}, /* (HANGUL SYLLABLE SWEOC) */
    {{'\xec', '\x89', '\x8c'}, 3, 0xC24C}, /* (HANGUL SYLLABLE SWEOK) */
    {{'\xec', '\x89', '\x8d'}, 3, 0xC24D}, /* (HANGUL SYLLABLE SWEOT) */
    {{'\xec', '\x89', '\x8e'}, 3, 0xC24E}, /* (HANGUL SYLLABLE SWEOP) */
    {{'\xec', '\x89', '\x8f'}, 3, 0xC24F}, /* (HANGUL SYLLABLE SWEOH) */
    {{'\xec', '\x89', '\x92'}, 3, 0xC252}, /* (HANGUL SYLLABLE SWEGG) */
    {{'\xec', '\x89', '\x93'}, 3, 0xC253}, /* (HANGUL SYLLABLE SWEGS) */
    {{'\xec', '\x89', '\x95'}, 3, 0xC255}, /* (HANGUL SYLLABLE SWENJ) */
    {{'\xec', '\x89', '\x96'}, 3, 0xC256}, /* (HANGUL SYLLABLE SWENH) */
    {{'\xec', '\x89', '\x97'}, 3, 0xC257}, /* (HANGUL SYLLABLE SWED) */
    {{'\xec', '\x89', '\x99'}, 3, 0xC259}, /* (HANGUL SYLLABLE SWELG) */
    {{'\xec', '\x89', '\x9a'}, 3, 0xC25A}, /* (HANGUL SYLLABLE SWELM) */
    {{'\xec', '\x89', '\x9b'}, 3, 0xC25B}, /* (HANGUL SYLLABLE SWELB) */
    {{'\xec', '\x89', '\x9c'}, 3, 0xC25C}, /* (HANGUL SYLLABLE SWELS) */
    {{'\xec', '\x89', '\x9d'}, 3, 0xC25D}, /* (HANGUL SYLLABLE SWELT) */
    {{'\xec', '\x89', '\x9e'}, 3, 0xC25E}, /* (HANGUL SYLLABLE SWELP) */
    {{'\xec', '\x89', '\x9f'}, 3, 0xC25F}, /* (HANGUL SYLLABLE SWELH) */
    {{'\xec', '\x89', '\xa1'}, 3, 0xC261}, /* (HANGUL SYLLABLE SWEB) */
    {{'\xec', '\x89', '\xa2'}, 3, 0xC262}, /* (HANGUL SYLLABLE SWEBS) */
    {{'\xec', '\x89', '\xa3'}, 3, 0xC263}, /* (HANGUL SYLLABLE SWES) */
    {{'\xec', '\x89', '\xa4'}, 3, 0xC264}, /* (HANGUL SYLLABLE SWESS) */
    {{'\xec', '\x89', '\xa6'}, 3, 0xC266}, /* (HANGUL SYLLABLE SWEJ) */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{'\xec', '\x89', '\xa7'}, 3, 0xC267}, /* (HANGUL SYLLABLE SWEC) */
    {{'\xec', '\x89', '\xa8'}, 3, 0xC268}, /* (HANGUL SYLLABLE SWEK) */
    {{'\xec', '\x89', '\xa9'}, 3, 0xC269}, /* (HANGUL SYLLABLE SWET) */
    {{'\xec', '\x89', '\xaa'}, 3, 0xC26A}, /* (HANGUL SYLLABLE SWEP) */
    {{'\xec', '\x89', '\xab'}, 3, 0xC26B}, /* (HANGUL SYLLABLE SWEH) */
    {{'\xec', '\x89', '\xae'}, 3, 0xC26E}, /* (HANGUL SYLLABLE SWIGG) */
    {{'\xec', '\x89', '\xaf'}, 3, 0xC26F}, /* (HANGUL SYLLABLE SWIGS) */
    {{'\xec', '\x89', '\xb1'}, 3, 0xC271}, /* (HANGUL SYLLABLE SWINJ) */
    {{'\xec', '\x89', '\xb2'}, 3, 0xC272}, /* (HANGUL SYLLABLE SWINH) */
    {{'\xec', '\x89', '\xb3'}, 3, 0xC273}, /* (HANGUL SYLLABLE SWID) */
    {{'\xec', '\x89', '\xb5'}, 3, 0xC275}, /* (HANGUL SYLLABLE SWILG) */
    {{'\xec', '\x89', '\xb6'}, 3, 0xC276}, /* (HANGUL SYLLABLE SWILM) */
    {{'\xec', '\x89', '\xb7'}, 3, 0xC277}, /* (HANGUL SYLLABLE SWILB) */
    {{'\xec', '\x89', '\xb8'}, 3, 0xC278}, /* (HANGUL SYLLABLE SWILS) */
    {{'\xec', '\x89', '\xb9'}, 3, 0xC279}, /* (HANGUL SYLLABLE SWILT) */
    {{'\xec', '\x89', '\xba'}, 3, 0xC27A}, /* (HANGUL SYLLABLE SWILP) */
    {{'\xec', '\x89', '\xbb'}, 3, 0xC27B}, /* (HANGUL SYLLABLE SWILH) */
    {{'\xec', '\x89', '\xbe'}, 3, 0xC27E}, /* (HANGUL SYLLABLE SWIBS) */
    {{'\xec', '\x8a', '\x80'}, 3, 0xC280}, /* (HANGUL SYLLABLE SWISS) */
    {{'\xec', '\x8a', '\x82'}, 3, 0xC282}, /* (HANGUL SYLLABLE SWIJ) */
    {{'\xec', '\x8a', '\x83'}, 3, 0xC283}, /* (HANGUL SYLLABLE SWIC) */
    {{'\xec', '\x8a', '\x84'}, 3, 0xC284}, /* (HANGUL SYLLABLE SWIK) */
    {{'\xec', '\x8a', '\x85'}, 3, 0xC285}, /* (HANGUL SYLLABLE SWIT) */
    {{'\xec', '\x8a', '\x86'}, 3, 0xC286}, /* (HANGUL SYLLABLE SWIP) */
    {{'\xec', '\x8a', '\x87'}, 3, 0xC287}, /* (HANGUL SYLLABLE SWIH) */
    {{'\xec', '\x8a', '\x8a'}, 3, 0xC28A}, /* (HANGUL SYLLABLE SYUGG) */
    {{'\xec', '\x8a', '\x8b'}, 3, 0xC28B}, /* (HANGUL SYLLABLE SYUGS) */
    {{'\xec', '\x8a', '\x8c'}, 3, 0xC28C}, /* (HANGUL SYLLABLE SYUN) */
    {{'\xec', '\x8a', '\x8d'}, 3, 0xC28D}, /* (HANGUL SYLLABLE SYUNJ) */
    {{'\xec', '\x8a', '\x8e'}, 3, 0xC28E}, /* (HANGUL SYLLABLE SYUNH) */
    {{'\xec', '\x8a', '\x8f'}, 3, 0xC28F}, /* (HANGUL SYLLABLE SYUD) */
    {{'\xec', '\x8a', '\x91'}, 3, 0xC291}, /* (HANGUL SYLLABLE SYULG) */
    {{'\xec', '\x8a', '\x92'}, 3, 0xC292}, /* (HANGUL SYLLABLE SYULM) */
    {{'\xec', '\x8a', '\x93'}, 3, 0xC293}, /* (HANGUL SYLLABLE SYULB) */
    {{'\xec', '\x8a', '\x94'}, 3, 0xC294}, /* (HANGUL SYLLABLE SYULS) */
    {{'\xec', '\x8a', '\x95'}, 3, 0xC295}, /* (HANGUL SYLLABLE SYULT) */
    {{'\xec', '\x8a', '\x96'}, 3, 0xC296}, /* (HANGUL SYLLABLE SYULP) */
    {{'\xec', '\x8a', '\x97'}, 3, 0xC297}, /* (HANGUL SYLLABLE SYULH) */
    {{'\xec', '\x8a', '\x99'}, 3, 0xC299}, /* (HANGUL SYLLABLE SYUB) */
    {{'\xec', '\x8a', '\x9a'}, 3, 0xC29A}, /* (HANGUL SYLLABLE SYUBS) */
    {{'\xec', '\x8a', '\x9c'}, 3, 0xC29C}, /* (HANGUL SYLLABLE SYUSS) */
    {{'\xec', '\x8a', '\x9e'}, 3, 0xC29E}, /* (HANGUL SYLLABLE SYUJ) */
    {{'\xec', '\x8a', '\x9f'}, 3, 0xC29F}, /* (HANGUL SYLLABLE SYUC) */
    {{'\xec', '\x8a', '\xa0'}, 3, 0xC2A0}, /* (HANGUL SYLLABLE SYUK) */
    {{'\xec', '\x8a', '\xa1'}, 3, 0xC2A1}, /* (HANGUL SYLLABLE SYUT) */
    {{'\xec', '\x8a', '\xa2'}, 3, 0xC2A2}, /* (HANGUL SYLLABLE SYUP) */
    {{'\xec', '\x8a', '\xa3'}, 3, 0xC2A3}, /* (HANGUL SYLLABLE SYUH) */
    {{'\xec', '\x8a', '\xa6'}, 3, 0xC2A6}, /* (HANGUL SYLLABLE SEUGG) */
    {{'\xec', '\x8a', '\xa7'}, 3, 0xC2A7}, /* (HANGUL SYLLABLE SEUGS) */
    {{'\xec', '\x8a', '\xa9'}, 3, 0xC2A9}, /* (HANGUL SYLLABLE SEUNJ) */
    {{'\xec', '\x8a', '\xaa'}, 3, 0xC2AA}, /* (HANGUL SYLLABLE SEUNH) */
    {{'\xec', '\x8a', '\xab'}, 3, 0xC2AB}, /* (HANGUL SYLLABLE SEUD) */
    {{'\xec', '\x8a', '\xae'}, 3, 0xC2AE}, /* (HANGUL SYLLABLE SEULM) */
    {{'\xec', '\x8a', '\xaf'}, 3, 0xC2AF}, /* (HANGUL SYLLABLE SEULB) */
    {{'\xec', '\x8a', '\xb0'}, 3, 0xC2B0}, /* (HANGUL SYLLABLE SEULS) */
    {{'\xec', '\x8a', '\xb1'}, 3, 0xC2B1}, /* (HANGUL SYLLABLE SEULT) */
    {{'\xec', '\x8a', '\xb2'}, 3, 0xC2B2}, /* (HANGUL SYLLABLE SEULP) */
    {{'\xec', '\x8a', '\xb3'}, 3, 0xC2B3}, /* (HANGUL SYLLABLE SEULH) */
    {{'\xec', '\x8a', '\xb6'}, 3, 0xC2B6}, /* (HANGUL SYLLABLE SEUBS) */
    {{'\xec', '\x8a', '\xb8'}, 3, 0xC2B8}, /* (HANGUL SYLLABLE SEUSS) */
    {{'\xec', '\x8a', '\xba'}, 3, 0xC2BA}, /* (HANGUL SYLLABLE SEUJ) */
    {{'\xec', '\x8a', '\xbb'}, 3, 0xC2BB}, /* (HANGUL SYLLABLE SEUC) */
    {{'\xec', '\x8a', '\xbc'}, 3, 0xC2BC}, /* (HANGUL SYLLABLE SEUK) */
    {{'\xec', '\x8a', '\xbd'}, 3, 0xC2BD}, /* (HANGUL SYLLABLE SEUT) */
    {{'\xec', '\x8a', '\xbe'}, 3, 0xC2BE}, /* (HANGUL SYLLABLE SEUP) */
    {{'\xec', '\x8a', '\xbf'}, 3, 0xC2BF}, /* (HANGUL SYLLABLE SEUH) */
    {{'\xec', '\x8b', '\x80'}, 3, 0xC2C0}, /* (HANGUL SYLLABLE SYI) */
    {{'\xec', '\x8b', '\x81'}, 3, 0xC2C1}, /* (HANGUL SYLLABLE SYIG) */
    {{'\xec', '\x8b', '\x82'}, 3, 0xC2C2}, /* (HANGUL SYLLABLE SYIGG) */
    {{'\xec', '\x8b', '\x83'}, 3, 0xC2C3}, /* (HANGUL SYLLABLE SYIGS) */
    {{'\xec', '\x8b', '\x84'}, 3, 0xC2C4}, /* (HANGUL SYLLABLE SYIN) */
    {{'\xec', '\x8b', '\x85'}, 3, 0xC2C5}, /* (HANGUL SYLLABLE SYINJ) */
    {{'\xec', '\x8b', '\x86'}, 3, 0xC2C6}, /* (HANGUL SYLLABLE SYINH) */
    {{'\xec', '\x8b', '\x87'}, 3, 0xC2C7}, /* (HANGUL SYLLABLE SYID) */
    {{'\xec', '\x8b', '\x88'}, 3, 0xC2C8}, /* (HANGUL SYLLABLE SYIL) */
    {{'\xec', '\x8b', '\x89'}, 3, 0xC2C9}, /* (HANGUL SYLLABLE SYILG) */
    {{'\xec', '\x8b', '\x8a'}, 3, 0xC2CA}, /* (HANGUL SYLLABLE SYILM) */
    {{'\xec', '\x8b', '\x8b'}, 3, 0xC2CB}, /* (HANGUL SYLLABLE SYILB) */
    {{'\xec', '\x8b', '\x8c'}, 3, 0xC2CC}, /* (HANGUL SYLLABLE SYILS) */
    {{'\xec', '\x8b', '\x8d'}, 3, 0xC2CD}, /* (HANGUL SYLLABLE SYILT) */
    {{'\xec', '\x8b', '\x8e'}, 3, 0xC2CE}, /* (HANGUL SYLLABLE SYILP) */
    {{'\xec', '\x8b', '\x8f'}, 3, 0xC2CF}, /* (HANGUL SYLLABLE SYILH) */
    {{'\xec', '\x8b', '\x90'}, 3, 0xC2D0}, /* (HANGUL SYLLABLE SYIM) */
    {{'\xec', '\x8b', '\x91'}, 3, 0xC2D1}, /* (HANGUL SYLLABLE SYIB) */
    {{'\xec', '\x8b', '\x92'}, 3, 0xC2D2}, /* (HANGUL SYLLABLE SYIBS) */
    {{'\xec', '\x8b', '\x93'}, 3, 0xC2D3}, /* (HANGUL SYLLABLE SYIS) */
    {{'\xec', '\x8b', '\x94'}, 3, 0xC2D4}, /* (HANGUL SYLLABLE SYISS) */
    {{'\xec', '\x8b', '\x95'}, 3, 0xC2D5}, /* (HANGUL SYLLABLE SYING) */
    {{'\xec', '\x8b', '\x96'}, 3, 0xC2D6}, /* (HANGUL SYLLABLE SYIJ) */
    {{'\xec', '\x8b', '\x97'}, 3, 0xC2D7}, /* (HANGUL SYLLABLE SYIC) */
    {{'\xec', '\x8b', '\x98'}, 3, 0xC2D8}, /* (HANGUL SYLLABLE SYIK) */
    {{'\xec', '\x8b', '\x99'}, 3, 0xC2D9}, /* (HANGUL SYLLABLE SYIT) */
    {{'\xec', '\x8b', '\x9a'}, 3, 0xC2DA}, /* (HANGUL SYLLABLE SYIP) */
    {{'\xec', '\x8b', '\x9b'}, 3, 0xC2DB}, /* (HANGUL SYLLABLE SYIH) */
    {{'\xec', '\x8b', '\x9e'}, 3, 0xC2DE}, /* (HANGUL SYLLABLE SIGG) */
    {{'\xec', '\x8b', '\x9f'}, 3, 0xC2DF}, /* (HANGUL SYLLABLE SIGS) */
    {{'\xec', '\x8b', '\xa1'}, 3, 0xC2E1}, /* (HANGUL SYLLABLE SINJ) */
    {{'\xec', '\x8b', '\xa2'}, 3, 0xC2E2}, /* (HANGUL SYLLABLE SINH) */
    {{'\xec', '\x8b', '\xa5'}, 3, 0xC2E5}, /* (HANGUL SYLLABLE SILG) */
    {{'\xec', '\x8b', '\xa6'}, 3, 0xC2E6}, /* (HANGUL SYLLABLE SILM) */
    {{'\xec', '\x8b', '\xa7'}, 3, 0xC2E7}, /* (HANGUL SYLLABLE SILB) */
    {{'\xec', '\x8b', '\xa8'}, 3, 0xC2E8}, /* (HANGUL SYLLABLE SILS) */
    {{'\xec', '\x8b', '\xa9'}, 3, 0xC2E9}, /* (HANGUL SYLLABLE SILT) */
    {{'\xec', '\x8b', '\xaa'}, 3, 0xC2EA}, /* (HANGUL SYLLABLE SILP) */
    {{'\xec', '\x8b', '\xae'}, 3, 0xC2EE}, /* (HANGUL SYLLABLE SIBS) */
    {{'\xec', '\x8b', '\xb0'}, 3, 0xC2F0}, /* (HANGUL SYLLABLE SISS) */
    {{'\xec', '\x8b', '\xb2'}, 3, 0xC2F2}, /* (HANGUL SYLLABLE SIJ) */
    {{'\xec', '\x8b', '\xb3'}, 3, 0xC2F3}, /* (HANGUL SYLLABLE SIC) */
    {{'\xec', '\x8b', '\xb4'}, 3, 0xC2F4}, /* (HANGUL SYLLABLE SIK) */
    {{'\xec', '\x8b', '\xb5'}, 3, 0xC2F5}, /* (HANGUL SYLLABLE SIT) */
    {{'\xec', '\x8b', '\xb7'}, 3, 0xC2F7}, /* (HANGUL SYLLABLE SIH) */
    {{'\xec', '\x8b', '\xba'}, 3, 0xC2FA}, /* (HANGUL SYLLABLE SSAGG) */
    {{'\xec', '\x8b', '\xbd'}, 3, 0xC2FD}, /* (HANGUL SYLLABLE SSANJ) */
    {{'\xec', '\x8b', '\xbe'}, 3, 0xC2FE}, /* (HANGUL SYLLABLE SSANH) */
    {{'\xec', '\x8b', '\xbf'}, 3, 0xC2FF}, /* (HANGUL SYLLABLE SSAD) */
    {{'\xec', '\x8c', '\x81'}, 3, 0xC301}, /* (HANGUL SYLLABLE SSALG) */
    {{'\xec', '\x8c', '\x82'}, 3, 0xC302}, /* (HANGUL SYLLABLE SSALM) */
    {{'\xec', '\x8c', '\x83'}, 3, 0xC303}, /* (HANGUL SYLLABLE SSALB) */
    {{'\xec', '\x8c', '\x84'}, 3, 0xC304}, /* (HANGUL SYLLABLE SSALS) */
    {{'\xec', '\x8c', '\x85'}, 3, 0xC305}, /* (HANGUL SYLLABLE SSALT) */
    {{'\xec', '\x8c', '\x86'}, 3, 0xC306}, /* (HANGUL SYLLABLE SSALP) */
    {{'\xec', '\x8c', '\x87'}, 3, 0xC307}, /* (HANGUL SYLLABLE SSALH) */
    {{'\xec', '\x8c', '\x8a'}, 3, 0xC30A}, /* (HANGUL SYLLABLE SSABS) */
    {{'\xec', '\x8c', '\x8b'}, 3, 0xC30B}, /* (HANGUL SYLLABLE SSAS) */
    {{'\xec', '\x8c', '\x8e'}, 3, 0xC30E}, /* (HANGUL SYLLABLE SSAJ) */
    {{'\xec', '\x8c', '\x8f'}, 3, 0xC30F}, /* (HANGUL SYLLABLE SSAC) */
    {{'\xec', '\x8c', '\x90'}, 3, 0xC310}, /* (HANGUL SYLLABLE SSAK) */
    {{'\xec', '\x8c', '\x91'}, 3, 0xC311}, /* (HANGUL SYLLABLE SSAT) */
    {{'\xec', '\x8c', '\x92'}, 3, 0xC312}, /* (HANGUL SYLLABLE SSAP) */
    {{'\xec', '\x8c', '\x96'}, 3, 0xC316}, /* (HANGUL SYLLABLE SSAEGG) */
    {{'\xec', '\x8c', '\x97'}, 3, 0xC317}, /* (HANGUL SYLLABLE SSAEGS) */
    {{'\xec', '\x8c', '\x99'}, 3, 0xC319}, /* (HANGUL SYLLABLE SSAENJ) */
    {{'\xec', '\x8c', '\x9a'}, 3, 0xC31A}, /* (HANGUL SYLLABLE SSAENH) */
    {{'\xec', '\x8c', '\x9b'}, 3, 0xC31B}, /* (HANGUL SYLLABLE SSAED) */
    {{'\xec', '\x8c', '\x9d'}, 3, 0xC31D}, /* (HANGUL SYLLABLE SSAELG) */
    {{'\xec', '\x8c', '\x9e'}, 3, 0xC31E}, /* (HANGUL SYLLABLE SSAELM) */
    {{'\xec', '\x8c', '\x9f'}, 3, 0xC31F}, /* (HANGUL SYLLABLE SSAELB) */
    {{'\xec', '\x8c', '\xa0'}, 3, 0xC320}, /* (HANGUL SYLLABLE SSAELS) */
    {{'\xec', '\x8c', '\xa1'}, 3, 0xC321}, /* (HANGUL SYLLABLE SSAELT) */
    {{'\xec', '\x8c', '\xa2'}, 3, 0xC322}, /* (HANGUL SYLLABLE SSAELP) */
    {{'\xec', '\x8c', '\xa3'}, 3, 0xC323}, /* (HANGUL SYLLABLE SSAELH) */
    {{'\xec', '\x8c', '\xa6'}, 3, 0xC326}, /* (HANGUL SYLLABLE SSAEBS) */
    {{'\xec', '\x8c', '\xa7'}, 3, 0xC327}, /* (HANGUL SYLLABLE SSAES) */
    {{'\xec', '\x8c', '\xaa'}, 3, 0xC32A}, /* (HANGUL SYLLABLE SSAEJ) */
    {{'\xec', '\x8c', '\xab'}, 3, 0xC32B}, /* (HANGUL SYLLABLE SSAEC) */
    {{'\xec', '\x8c', '\xac'}, 3, 0xC32C}, /* (HANGUL SYLLABLE SSAEK) */
    {{'\xec', '\x8c', '\xad'}, 3, 0xC32D}, /* (HANGUL SYLLABLE SSAET) */
    {{'\xec', '\x8c', '\xae'}, 3, 0xC32E}, /* (HANGUL SYLLABLE SSAEP) */
    {{'\xec', '\x8c', '\xaf'}, 3, 0xC32F}, /* (HANGUL SYLLABLE SSAEH) */
    {{'\xec', '\x8c', '\xb0'}, 3, 0xC330}, /* (HANGUL SYLLABLE SSYA) */
    {{'\xec', '\x8c', '\xb1'}, 3, 0xC331}, /* (HANGUL SYLLABLE SSYAG) */
    {{'\xec', '\x8c', '\xb2'}, 3, 0xC332}, /* (HANGUL SYLLABLE SSYAGG) */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{'\xec', '\x8c', '\xb3'}, 3, 0xC333}, /* (HANGUL SYLLABLE SSYAGS) */
    {{'\xec', '\x8c', '\xb4'}, 3, 0xC334}, /* (HANGUL SYLLABLE SSYAN) */
    {{'\xec', '\x8c', '\xb5'}, 3, 0xC335}, /* (HANGUL SYLLABLE SSYANJ) */
    {{'\xec', '\x8c', '\xb6'}, 3, 0xC336}, /* (HANGUL SYLLABLE SSYANH) */
    {{'\xec', '\x8c', '\xb7'}, 3, 0xC337}, /* (HANGUL SYLLABLE SSYAD) */
    {{'\xec', '\x8c', '\xb8'}, 3, 0xC338}, /* (HANGUL SYLLABLE SSYAL) */
    {{'\xec', '\x8c', '\xb9'}, 3, 0xC339}, /* (HANGUL SYLLABLE SSYALG) */
    {{'\xec', '\x8c', '\xba'}, 3, 0xC33A}, /* (HANGUL SYLLABLE SSYALM) */
    {{'\xec', '\x8c', '\xbb'}, 3, 0xC33B}, /* (HANGUL SYLLABLE SSYALB) */
    {{'\xec', '\x8c', '\xbc'}, 3, 0xC33C}, /* (HANGUL SYLLABLE SSYALS) */
    {{'\xec', '\x8c', '\xbd'}, 3, 0xC33D}, /* (HANGUL SYLLABLE SSYALT) */
    {{'\xec', '\x8c', '\xbe'}, 3, 0xC33E}, /* (HANGUL SYLLABLE SSYALP) */
    {{'\xec', '\x8c', '\xbf'}, 3, 0xC33F}, /* (HANGUL SYLLABLE SSYALH) */
    {{'\xec', '\x8d', '\x80'}, 3, 0xC340}, /* (HANGUL SYLLABLE SSYAM) */
    {{'\xec', '\x8d', '\x81'}, 3, 0xC341}, /* (HANGUL SYLLABLE SSYAB) */
    {{'\xec', '\x8d', '\x82'}, 3, 0xC342}, /* (HANGUL SYLLABLE SSYABS) */
    {{'\xec', '\x8d', '\x83'}, 3, 0xC343}, /* (HANGUL SYLLABLE SSYAS) */
    {{'\xec', '\x8d', '\x84'}, 3, 0xC344}, /* (HANGUL SYLLABLE SSYASS) */
    {{'\xec', '\x8d', '\x86'}, 3, 0xC346}, /* (HANGUL SYLLABLE SSYAJ) */
    {{'\xec', '\x8d', '\x87'}, 3, 0xC347}, /* (HANGUL SYLLABLE SSYAC) */
    {{'\xec', '\x8d', '\x88'}, 3, 0xC348}, /* (HANGUL SYLLABLE SSYAK) */
    {{'\xec', '\x8d', '\x89'}, 3, 0xC349}, /* (HANGUL SYLLABLE SSYAT) */
    {{'\xec', '\x8d', '\x8a'}, 3, 0xC34A}, /* (HANGUL SYLLABLE SSYAP) */
    {{'\xec', '\x8d', '\x8b'}, 3, 0xC34B}, /* (HANGUL SYLLABLE SSYAH) */
    {{'\xec', '\x8d', '\x8c'}, 3, 0xC34C}, /* (HANGUL SYLLABLE SSYAE) */
    {{'\xec', '\x8d', '\x8d'}, 3, 0xC34D}, /* (HANGUL SYLLABLE SSYAEG) */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{'\xec', '\x8d', '\x8e'}, 3, 0xC34E}, /* (HANGUL SYLLABLE SSYAEGG) */
    {{'\xec', '\x8d', '\x8f'}, 3, 0xC34F}, /* (HANGUL SYLLABLE SSYAEGS) */
    {{'\xec', '\x8d', '\x90'}, 3, 0xC350}, /* (HANGUL SYLLABLE SSYAEN) */
    {{'\xec', '\x8d', '\x91'}, 3, 0xC351}, /* (HANGUL SYLLABLE SSYAENJ) */
    {{'\xec', '\x8d', '\x92'}, 3, 0xC352}, /* (HANGUL SYLLABLE SSYAENH) */
    {{'\xec', '\x8d', '\x93'}, 3, 0xC353}, /* (HANGUL SYLLABLE SSYAED) */
    {{'\xec', '\x8d', '\x94'}, 3, 0xC354}, /* (HANGUL SYLLABLE SSYAEL) */
    {{'\xec', '\x8d', '\x95'}, 3, 0xC355}, /* (HANGUL SYLLABLE SSYAELG) */
    {{'\xec', '\x8d', '\x96'}, 3, 0xC356}, /* (HANGUL SYLLABLE SSYAELM) */
    {{'\xec', '\x8d', '\x97'}, 3, 0xC357}, /* (HANGUL SYLLABLE SSYAELB) */
    {{'\xec', '\x8d', '\x98'}, 3, 0xC358}, /* (HANGUL SYLLABLE SSYAELS) */
    {{'\xec', '\x8d', '\x99'}, 3, 0xC359}, /* (HANGUL SYLLABLE SSYAELT) */
    {{'\xec', '\x8d', '\x9a'}, 3, 0xC35A}, /* (HANGUL SYLLABLE SSYAELP) */
    {{'\xec', '\x8d', '\x9b'}, 3, 0xC35B}, /* (HANGUL SYLLABLE SSYAELH) */
    {{'\xec', '\x8d', '\x9c'}, 3, 0xC35C}, /* (HANGUL SYLLABLE SSYAEM) */
    {{'\xec', '\x8d', '\x9d'}, 3, 0xC35D}, /* (HANGUL SYLLABLE SSYAEB) */
    {{'\xec', '\x8d', '\x9e'}, 3, 0xC35E}, /* (HANGUL SYLLABLE SSYAEBS) */
    {{'\xec', '\x8d', '\x9f'}, 3, 0xC35F}, /* (HANGUL SYLLABLE SSYAES) */
    {{'\xec', '\x8d', '\xa0'}, 3, 0xC360}, /* (HANGUL SYLLABLE SSYAESS) */
    {{'\xec', '\x8d', '\xa1'}, 3, 0xC361}, /* (HANGUL SYLLABLE SSYAENG) */
    {{'\xec', '\x8d', '\xa2'}, 3, 0xC362}, /* (HANGUL SYLLABLE SSYAEJ) */
    {{'\xec', '\x8d', '\xa3'}, 3, 0xC363}, /* (HANGUL SYLLABLE SSYAEC) */
    {{'\xec', '\x8d', '\xa4'}, 3, 0xC364}, /* (HANGUL SYLLABLE SSYAEK) */
    {{'\xec', '\x8d', '\xa5'}, 3, 0xC365}, /* (HANGUL SYLLABLE SSYAET) */
    {{'\xec', '\x8d', '\xa6'}, 3, 0xC366}, /* (HANGUL SYLLABLE SSYAEP) */
    {{'\xec', '\x8d', '\xa7'}, 3, 0xC367}, /* (HANGUL SYLLABLE SSYAEH) */
    {{'\xec', '\x8d', '\xaa'}, 3, 0xC36A}, /* (HANGUL SYLLABLE SSEOGG) */
    {{'\xec', '\x8d', '\xab'}, 3, 0xC36B}, /* (HANGUL SYLLABLE SSEOGS) */
    {{'\xec', '\x8d', '\xad'}, 3, 0xC36D}, /* (HANGUL SYLLABLE SSEONJ) */
    {{'\xec', '\x8d', '\xae'}, 3, 0xC36E}, /* (HANGUL SYLLABLE SSEONH) */
    {{'\xec', '\x8d', '\xaf'}, 3, 0xC36F}, /* (HANGUL SYLLABLE SSEOD) */
    {{'\xec', '\x8d', '\xb1'}, 3, 0xC371}, /* (HANGUL SYLLABLE SSEOLG) */
    {{'\xec', '\x8d', '\xb3'}, 3, 0xC373}, /* (HANGUL SYLLABLE SSEOLB) */
    {{'\xec', '\x8d', '\xb4'}, 3, 0xC374}, /* (HANGUL SYLLABLE SSEOLS) */
    {{'\xec', '\x8d', '\xb5'}, 3, 0xC375}, /* (HANGUL SYLLABLE SSEOLT) */
    {{'\xec', '\x8d', '\xb6'}, 3, 0xC376}, /* (HANGUL SYLLABLE SSEOLP) */
    {{'\xec', '\x8d', '\xb7'}, 3, 0xC377}, /* (HANGUL SYLLABLE SSEOLH) */
    {{'\xec', '\x8d', '\xba'}, 3, 0xC37A}, /* (HANGUL SYLLABLE SSEOBS) */
    {{'\xec', '\x8d', '\xbb'}, 3, 0xC37B}, /* (HANGUL SYLLABLE SSEOS) */
    {{'\xec', '\x8d', '\xbe'}, 3, 0xC37E}, /* (HANGUL SYLLABLE SSEOJ) */
    {{'\xec', '\x8d', '\xbf'}, 3, 0xC37F}, /* (HANGUL SYLLABLE SSEOC) */
    {{'\xec', '\x8e', '\x80'}, 3, 0xC380}, /* (HANGUL SYLLABLE SSEOK) */
    {{'\xec', '\x8e', '\x81'}, 3, 0xC381}, /* (HANGUL SYLLABLE SSEOT) */
    {{'\xec', '\x8e', '\x82'}, 3, 0xC382}, /* (HANGUL SYLLABLE SSEOP) */
    {{'\xec', '\x8e', '\x83'}, 3, 0xC383}, /* (HANGUL SYLLABLE SSEOH) */
    {{'\xec', '\x8e', '\x85'}, 3, 0xC385}, /* (HANGUL SYLLABLE SSEG) */
    {{'\xec', '\x8e', '\x86'}, 3, 0xC386}, /* (HANGUL SYLLABLE SSEGG) */
    {{'\xec', '\x8e', '\x87'}, 3, 0xC387}, /* (HANGUL SYLLABLE SSEGS) */
    {{'\xec', '\x8e', '\x89'}, 3, 0xC389}, /* (HANGUL SYLLABLE SSENJ) */
    {{'\xec', '\x8e', '\x8a'}, 3, 0xC38A}, /* (HANGUL SYLLABLE SSENH) */
    {{'\xec', '\x8e', '\x8b'}, 3, 0xC38B}, /* (HANGUL SYLLABLE SSED) */
    {{'\xec', '\x8e', '\x8d'}, 3, 0xC38D}, /* (HANGUL SYLLABLE SSELG) */
    {{'\xec', '\x8e', '\x8e'}, 3, 0xC38E}, /* (HANGUL SYLLABLE SSELM) */
    {{'\xec', '\x8e', '\x8f'}, 3, 0xC38F}, /* (HANGUL SYLLABLE SSELB) */
    {{'\xec', '\x8e', '\x90'}, 3, 0xC390}, /* (HANGUL SYLLABLE SSELS) */
    {{'\xec', '\x8e', '\x91'}, 3, 0xC391}, /* (HANGUL SYLLABLE SSELT) */
    {{'\xec', '\x8e', '\x92'}, 3, 0xC392}, /* (HANGUL SYLLABLE SSELP) */
    {{'\xec', '\x8e', '\x93'}, 3, 0xC393}, /* (HANGUL SYLLABLE SSELH) */
    {{'\xec', '\x8e', '\x94'}, 3, 0xC394}, /* (HANGUL SYLLABLE SSEM) */
    {{'\xec', '\x8e', '\x95'}, 3, 0xC395}, /* (HANGUL SYLLABLE SSEB) */
    {{'\xec', '\x8e', '\x96'}, 3, 0xC396}, /* (HANGUL SYLLABLE SSEBS) */
    {{'\xec', '\x8e', '\x97'}, 3, 0xC397}, /* (HANGUL SYLLABLE SSES) */
    {{'\xec', '\x8e', '\x98'}, 3, 0xC398}, /* (HANGUL SYLLABLE SSESS) */
    {{'\xec', '\x8e', '\x99'}, 3, 0xC399}, /* (HANGUL SYLLABLE SSENG) */
    {{'\xec', '\x8e', '\x9a'}, 3, 0xC39A}, /* (HANGUL SYLLABLE SSEJ) */
    {{'\xec', '\x8e', '\x9b'}, 3, 0xC39B}, /* (HANGUL SYLLABLE SSEC) */
    {{'\xec', '\x8e', '\x9c'}, 3, 0xC39C}, /* (HANGUL SYLLABLE SSEK) */
    {{'\xec', '\x8e', '\x9d'}, 3, 0xC39D}, /* (HANGUL SYLLABLE SSET) */
    {{'\xec', '\x8e', '\x9e'}, 3, 0xC39E}, /* (HANGUL SYLLABLE SSEP) */
    {{'\xec', '\x8e', '\x9f'}, 3, 0xC39F}, /* (HANGUL SYLLABLE SSEH) */
    {{'\xec', '\x8e', '\xa0'}, 3, 0xC3A0}, /* (HANGUL SYLLABLE SSYEO) */
    {{'\xec', '\x8e', '\xa1'}, 3, 0xC3A1}, /* (HANGUL SYLLABLE SSYEOG) */
    {{'\xec', '\x8e', '\xa2'}, 3, 0xC3A2}, /* (HANGUL SYLLABLE SSYEOGG) */
    {{'\xec', '\x8e', '\xa3'}, 3, 0xC3A3}, /* (HANGUL SYLLABLE SSYEOGS) */
    {{'\xec', '\x8e', '\xa4'}, 3, 0xC3A4}, /* (HANGUL SYLLABLE SSYEON) */
    {{'\xec', '\x8e', '\xa5'}, 3, 0xC3A5}, /* (HANGUL SYLLABLE SSYEONJ) */
    {{'\xec', '\x8e', '\xa6'}, 3, 0xC3A6}, /* (HANGUL SYLLABLE SSYEONH) */
    {{'\xec', '\x8e', '\xa7'}, 3, 0xC3A7}, /* (HANGUL SYLLABLE SSYEOD) */
    {{'\xec', '\x8e', '\xa8'}, 3, 0xC3A8}, /* (HANGUL SYLLABLE SSYEOL) */
    {{'\xec', '\x8e', '\xa9'}, 3, 0xC3A9}, /* (HANGUL SYLLABLE SSYEOLG) */
    {{'\xec', '\x8e', '\xaa'}, 3, 0xC3AA}, /* (HANGUL SYLLABLE SSYEOLM) */
    {{'\xec', '\x8e', '\xab'}, 3, 0xC3AB}, /* (HANGUL SYLLABLE SSYEOLB) */
    {{'\xec', '\x8e', '\xac'}, 3, 0xC3AC}, /* (HANGUL SYLLABLE SSYEOLS) */
    {{'\xec', '\x8e', '\xad'}, 3, 0xC3AD}, /* (HANGUL SYLLABLE SSYEOLT) */
    {{'\xec', '\x8e', '\xae'}, 3, 0xC3AE}, /* (HANGUL SYLLABLE SSYEOLP) */
    {{'\xec', '\x8e', '\xaf'}, 3, 0xC3AF}, /* (HANGUL SYLLABLE SSYEOLH) */
    {{'\xec', '\x8e', '\xb0'}, 3, 0xC3B0}, /* (HANGUL SYLLABLE SSYEOM) */
    {{'\xec', '\x8e', '\xb1'}, 3, 0xC3B1}, /* (HANGUL SYLLABLE SSYEOB) */
    {{'\xec', '\x8e', '\xb2'}, 3, 0xC3B2}, /* (HANGUL SYLLABLE SSYEOBS) */
    {{'\xec', '\x8e', '\xb3'}, 3, 0xC3B3}, /* (HANGUL SYLLABLE SSYEOS) */
    {{'\xec', '\x8e', '\xb4'}, 3, 0xC3B4}, /* (HANGUL SYLLABLE SSYEOSS) */
    {{'\xec', '\x8e', '\xb5'}, 3, 0xC3B5}, /* (HANGUL SYLLABLE SSYEONG) */
    {{'\xec', '\x8e', '\xb6'}, 3, 0xC3B6}, /* (HANGUL SYLLABLE SSYEOJ) */
    {{'\xec', '\x8e', '\xb7'}, 3, 0xC3B7}, /* (HANGUL SYLLABLE SSYEOC) */
    {{'\xec', '\x8e', '\xb8'}, 3, 0xC3B8}, /* (HANGUL SYLLABLE SSYEOK) */
    {{'\xec', '\x8e', '\xb9'}, 3, 0xC3B9}, /* (HANGUL SYLLABLE SSYEOT) */
    {{'\xec', '\x8e', '\xba'}, 3, 0xC3BA}, /* (HANGUL SYLLABLE SSYEOP) */
    {{'\xec', '\x8e', '\xbb'}, 3, 0xC3BB}, /* (HANGUL SYLLABLE SSYEOH) */
    {{'\xec', '\x8e', '\xbc'}, 3, 0xC3BC}, /* (HANGUL SYLLABLE SSYE) */
    {{'\xec', '\x8e', '\xbd'}, 3, 0xC3BD}, /* (HANGUL SYLLABLE SSYEG) */
    {{'\xec', '\x8e', '\xbe'}, 3, 0xC3BE}, /* (HANGUL SYLLABLE SSYEGG) */
    {{'\xec', '\x8e', '\xbf'}, 3, 0xC3BF}, /* (HANGUL SYLLABLE SSYEGS) */
    {{'\xec', '\x8f', '\x81'}, 3, 0xC3C1}, /* (HANGUL SYLLABLE SSYENJ) */
    {{'\xec', '\x8f', '\x82'}, 3, 0xC3C2}, /* (HANGUL SYLLABLE SSYENH) */
    {{'\xec', '\x8f', '\x83'}, 3, 0xC3C3}, /* (HANGUL SYLLABLE SSYED) */
    {{'\xec', '\x8f', '\x84'}, 3, 0xC3C4}, /* (HANGUL SYLLABLE SSYEL) */
    {{'\xec', '\x8f', '\x85'}, 3, 0xC3C5}, /* (HANGUL SYLLABLE SSYELG) */
    {{'\xec', '\x8f', '\x86'}, 3, 0xC3C6}, /* (HANGUL SYLLABLE SSYELM) */
    {{'\xec', '\x8f', '\x87'}, 3, 0xC3C7}, /* (HANGUL SYLLABLE SSYELB) */
    {{'\xec', '\x8f', '\x88'}, 3, 0xC3C8}, /* (HANGUL SYLLABLE SSYELS) */
    {{'\xec', '\x8f', '\x89'}, 3, 0xC3C9}, /* (HANGUL SYLLABLE SSYELT) */
    {{'\xec', '\x8f', '\x8a'}, 3, 0xC3CA}, /* (HANGUL SYLLABLE SSYELP) */
    {{'\xec', '\x8f', '\x8b'}, 3, 0xC3CB}, /* (HANGUL SYLLABLE SSYELH) */
    {{'\xec', '\x8f', '\x8c'}, 3, 0xC3CC}, /* (HANGUL SYLLABLE SSYEM) */
    {{'\xec', '\x8f', '\x8d'}, 3, 0xC3CD}, /* (HANGUL SYLLABLE SSYEB) */
    {{'\xec', '\x8f', '\x8e'}, 3, 0xC3CE}, /* (HANGUL SYLLABLE SSYEBS) */
    {{'\xec', '\x8f', '\x8f'}, 3, 0xC3CF}, /* (HANGUL SYLLABLE SSYES) */
    {{'\xec', '\x8f', '\x90'}, 3, 0xC3D0}, /* (HANGUL SYLLABLE SSYESS) */
    {{'\xec', '\x8f', '\x91'}, 3, 0xC3D1}, /* (HANGUL SYLLABLE SSYENG) */
    {{'\xec', '\x8f', '\x92'}, 3, 0xC3D2}, /* (HANGUL SYLLABLE SSYEJ) */
    {{'\xec', '\x8f', '\x93'}, 3, 0xC3D3}, /* (HANGUL SYLLABLE SSYEC) */
    {{'\xec', '\x8f', '\x94'}, 3, 0xC3D4}, /* (HANGUL SYLLABLE SSYEK) */
    {{'\xec', '\x8f', '\x95'}, 3, 0xC3D5}, /* (HANGUL SYLLABLE SSYET) */
    {{'\xec', '\x8f', '\x96'}, 3, 0xC3D6}, /* (HANGUL SYLLABLE SSYEP) */
    {{'\xec', '\x8f', '\x97'}, 3, 0xC3D7}, /* (HANGUL SYLLABLE SSYEH) */
    {{'\xec', '\x8f', '\x9a'}, 3, 0xC3DA}, /* (HANGUL SYLLABLE SSOGG) */
    {{'\xec', '\x8f', '\x9b'}, 3, 0xC3DB}, /* (HANGUL SYLLABLE SSOGS) */
    {{'\xec', '\x8f', '\x9d'}, 3, 0xC3DD}, /* (HANGUL SYLLABLE SSONJ) */
    {{'\xec', '\x8f', '\x9e'}, 3, 0xC3DE}, /* (HANGUL SYLLABLE SSONH) */
    {{'\xec', '\x8f', '\xa1'}, 3, 0xC3E1}, /* (HANGUL SYLLABLE SSOLG) */
    {{'\xec', '\x8f', '\xa3'}, 3, 0xC3E3}, /* (HANGUL SYLLABLE SSOLB) */
    {{'\xec', '\x8f', '\xa4'}, 3, 0xC3E4}, /* (HANGUL SYLLABLE SSOLS) */
    {{'\xec', '\x8f', '\xa5'}, 3, 0xC3E5}, /* (HANGUL SYLLABLE SSOLT) */
    {{'\xec', '\x8f', '\xa6'}, 3, 0xC3E6}, /* (HANGUL SYLLABLE SSOLP) */
    {{'\xec', '\x8f', '\xa7'}, 3, 0xC3E7}, /* (HANGUL SYLLABLE SSOLH) */
    {{'\xec', '\x8f', '\xaa'}, 3, 0xC3EA}, /* (HANGUL SYLLABLE SSOBS) */
    {{'\xec', '\x8f', '\xab'}, 3, 0xC3EB}, /* (HANGUL SYLLABLE SSOS) */
    {{'\xec', '\x8f', '\xac'}, 3, 0xC3EC}, /* (HANGUL SYLLABLE SSOSS) */
    {{'\xec', '\x8f', '\xae'}, 3, 0xC3EE}, /* (HANGUL SYLLABLE SSOJ) */
    {{'\xec', '\x8f', '\xaf'}, 3, 0xC3EF}, /* (HANGUL SYLLABLE SSOC) */
    {{'\xec', '\x8f', '\xb0'}, 3, 0xC3F0}, /* (HANGUL SYLLABLE SSOK) */
    {{'\xec', '\x8f', '\xb1'}, 3, 0xC3F1}, /* (HANGUL SYLLABLE SSOT) */
    {{'\xec', '\x8f', '\xb2'}, 3, 0xC3F2}, /* (HANGUL SYLLABLE SSOP) */
    {{'\xec', '\x8f', '\xb3'}, 3, 0xC3F3}, /* (HANGUL SYLLABLE SSOH) */
    {{'\xec', '\x8f', '\xb6'}, 3, 0xC3F6}, /* (HANGUL SYLLABLE SSWAGG) */
    {{'\xec', '\x8f', '\xb7'}, 3, 0xC3F7}, /* (HANGUL SYLLABLE SSWAGS) */
    {{'\xec', '\x8f', '\xb9'}, 3, 0xC3F9}, /* (HANGUL SYLLABLE SSWANJ) */
    {{'\xec', '\x8f', '\xba'}, 3, 0xC3FA}, /* (HANGUL SYLLABLE SSWANH) */
    {{'\xec', '\x8f', '\xbb'}, 3, 0xC3FB}, /* (HANGUL SYLLABLE SSWAD) */
    {{'\xec', '\x8f', '\xbc'}, 3, 0xC3FC}, /* (HANGUL SYLLABLE SSWAL) */
    {{'\xec', '\x8f', '\xbd'}, 3, 0xC3FD}, /* (HANGUL SYLLABLE SSWALG) */
    {{'\xec', '\x8f', '\xbe'}, 3, 0xC3FE}, /* (HANGUL SYLLABLE SSWALM) */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{'\xec', '\x8f', '\xbf'}, 3, 0xC3FF}, /* (HANGUL SYLLABLE SSWALB) */
    {{'\xec', '\x90', '\x80'}, 3, 0xC400}, /* (HANGUL SYLLABLE SSWALS) */
    {{'\xec', '\x90', '\x81'}, 3, 0xC401}, /* (HANGUL SYLLABLE SSWALT) */
    {{'\xec', '\x90', '\x82'}, 3, 0xC402}, /* (HANGUL SYLLABLE SSWALP) */
    {{'\xec', '\x90', '\x83'}, 3, 0xC403}, /* (HANGUL SYLLABLE SSWALH) */
    {{'\xec', '\x90', '\x84'}, 3, 0xC404}, /* (HANGUL SYLLABLE SSWAM) */
    {{'\xec', '\x90', '\x85'}, 3, 0xC405}, /* (HANGUL SYLLABLE SSWAB) */
    {{'\xec', '\x90', '\x86'}, 3, 0xC406}, /* (HANGUL SYLLABLE SSWABS) */
    {{'\xec', '\x90', '\x87'}, 3, 0xC407}, /* (HANGUL SYLLABLE SSWAS) */
    {{'\xec', '\x90', '\x89'}, 3, 0xC409}, /* (HANGUL SYLLABLE SSWANG) */
    {{'\xec', '\x90', '\x8a'}, 3, 0xC40A}, /* (HANGUL SYLLABLE SSWAJ) */
    {{'\xec', '\x90', '\x8b'}, 3, 0xC40B}, /* (HANGUL SYLLABLE SSWAC) */
    {{'\xec', '\x90', '\x8c'}, 3, 0xC40C}, /* (HANGUL SYLLABLE SSWAK) */
    {{'\xec', '\x90', '\x8d'}, 3, 0xC40D}, /* (HANGUL SYLLABLE SSWAT) */
    {{'\xec', '\x90', '\x8e'}, 3, 0xC40E}, /* (HANGUL SYLLABLE SSWAP) */
    {{'\xec', '\x90', '\x8f'}, 3, 0xC40F}, /* (HANGUL SYLLABLE SSWAH) */
    {{'\xec', '\x90', '\x91'}, 3, 0xC411}, /* (HANGUL SYLLABLE SSWAEG) */
    {{'\xec', '\x90', '\x92'}, 3, 0xC412}, /* (HANGUL SYLLABLE SSWAEGG) */
    {{'\xec', '\x90', '\x93'}, 3, 0xC413}, /* (HANGUL SYLLABLE SSWAEGS) */
    {{'\xec', '\x90', '\x94'}, 3, 0xC414}, /* (HANGUL SYLLABLE SSWAEN) */
    {{'\xec', '\x90', '\x95'}, 3, 0xC415}, /* (HANGUL SYLLABLE SSWAENJ) */
    {{'\xec', '\x90', '\x96'}, 3, 0xC416}, /* (HANGUL SYLLABLE SSWAENH) */
    {{'\xec', '\x90', '\x97'}, 3, 0xC417}, /* (HANGUL SYLLABLE SSWAED) */
    {{'\xec', '\x90', '\x98'}, 3, 0xC418}, /* (HANGUL SYLLABLE SSWAEL) */
    {{'\xec', '\x90', '\x99'}, 3, 0xC419}, /* (HANGUL SYLLABLE SSWAELG) */
    {{'\xec', '\x90', '\x9a'}, 3, 0xC41A}, /* (HANGUL SYLLABLE SSWAELM) */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{'\xec', '\x90', '\x9b'}, 3, 0xC41B}, /* (HANGUL SYLLABLE SSWAELB) */
    {{'\xec', '\x90', '\x9c'}, 3, 0xC41C}, /* (HANGUL SYLLABLE SSWAELS) */
    {{'\xec', '\x90', '\x9d'}, 3, 0xC41D}, /* (HANGUL SYLLABLE SSWAELT) */
    {{'\xec', '\x90', '\x9e'}, 3, 0xC41E}, /* (HANGUL SYLLABLE SSWAELP) */
    {{'\xec', '\x90', '\x9f'}, 3, 0xC41F}, /* (HANGUL SYLLABLE SSWAELH) */
    {{'\xec', '\x90', '\xa0'}, 3, 0xC420}, /* (HANGUL SYLLABLE SSWAEM) */
    {{'\xec', '\x90', '\xa1'}, 3, 0xC421}, /* (HANGUL SYLLABLE SSWAEB) */
    {{'\xec', '\x90', '\xa2'}, 3, 0xC422}, /* (HANGUL SYLLABLE SSWAEBS) */
    {{'\xec', '\x90', '\xa3'}, 3, 0xC423}, /* (HANGUL SYLLABLE SSWAES) */
    {{'\xec', '\x90', '\xa5'}, 3, 0xC425}, /* (HANGUL SYLLABLE SSWAENG) */
    {{'\xec', '\x90', '\xa6'}, 3, 0xC426}, /* (HANGUL SYLLABLE SSWAEJ) */
    {{'\xec', '\x90', '\xa7'}, 3, 0xC427}, /* (HANGUL SYLLABLE SSWAEC) */
    {{'\xec', '\x90', '\xa8'}, 3, 0xC428}, /* (HANGUL SYLLABLE SSWAEK) */
    {{'\xec', '\x90', '\xa9'}, 3, 0xC429}, /* (HANGUL SYLLABLE SSWAET) */
    {{'\xec', '\x90', '\xaa'}, 3, 0xC42A}, /* (HANGUL SYLLABLE SSWAEP) */
    {{'\xec', '\x90', '\xab'}, 3, 0xC42B}, /* (HANGUL SYLLABLE SSWAEH) */
    {{'\xec', '\x90', '\xad'}, 3, 0xC42D}, /* (HANGUL SYLLABLE SSOEG) */
    {{'\xec', '\x90', '\xae'}, 3, 0xC42E}, /* (HANGUL SYLLABLE SSOEGG) */
    {{'\xec', '\x90', '\xaf'}, 3, 0xC42F}, /* (HANGUL SYLLABLE SSOEGS) */
    {{'\xec', '\x90', '\xb1'}, 3, 0xC431}, /* (HANGUL SYLLABLE SSOENJ) */
    {{'\xec', '\x90', '\xb2'}, 3, 0xC432}, /* (HANGUL SYLLABLE SSOENH) */
    {{'\xec', '\x90', '\xb3'}, 3, 0xC433}, /* (HANGUL SYLLABLE SSOED) */
    {{'\xec', '\x90', '\xb5'}, 3, 0xC435}, /* (HANGUL SYLLABLE SSOELG) */
    {{'\xec', '\x90', '\xb6'}, 3, 0xC436}, /* (HANGUL SYLLABLE SSOELM) */
    {{'\xec', '\x90', '\xb7'}, 3, 0xC437}, /* (HANGUL SYLLABLE SSOELB) */
    {{'\xec', '\x90', '\xb8'}, 3, 0xC438}, /* (HANGUL SYLLABLE SSOELS) */
    {{'\xec', '\x90', '\xb9'}, 3, 0xC439}, /* (HANGUL SYLLABLE SSOELT) */
    {{'\xec', '\x90', '\xba'}, 3, 0xC43A}, /* (HANGUL SYLLABLE SSOELP) */
    {{'\xec', '\x90', '\xbb'}, 3, 0xC43B}, /* (HANGUL SYLLABLE SSOELH) */
    {{'\xec', '\x90', '\xbe'}, 3, 0xC43E}, /* (HANGUL SYLLABLE SSOEBS) */
    {{'\xec', '\x90', '\xbf'}, 3, 0xC43F}, /* (HANGUL SYLLABLE SSOES) */
    {{'\xec', '\x91', '\x80'}, 3, 0xC440}, /* (HANGUL SYLLABLE SSOESS) */
    {{'\xec', '\x91', '\x81'}, 3, 0xC441}, /* (HANGUL SYLLABLE SSOENG) */
    {{'\xec', '\x91', '\x82'}, 3, 0xC442}, /* (HANGUL SYLLABLE SSOEJ) */
    {{'\xec', '\x91', '\x83'}, 3, 0xC443}, /* (HANGUL SYLLABLE SSOEC) */
    {{'\xec', '\x91', '\x84'}, 3, 0xC444}, /* (HANGUL SYLLABLE SSOEK) */
    {{'\xec', '\x91', '\x85'}, 3, 0xC445}, /* (HANGUL SYLLABLE SSOET) */
    {{'\xec', '\x91', '\x86'}, 3, 0xC446}, /* (HANGUL SYLLABLE SSOEP) */
    {{'\xec', '\x91', '\x87'}, 3, 0xC447}, /* (HANGUL SYLLABLE SSOEH) */
    {{'\xec', '\x91', '\x89'}, 3, 0xC449}, /* (HANGUL SYLLABLE SSYOG) */
    {{'\xec', '\x91', '\x8a'}, 3, 0xC44A}, /* (HANGUL SYLLABLE SSYOGG) */
    {{'\xec', '\x91', '\x8b'}, 3, 0xC44B}, /* (HANGUL SYLLABLE SSYOGS) */
    {{'\xec', '\x91', '\x8c'}, 3, 0xC44C}, /* (HANGUL SYLLABLE SSYON) */
    {{'\xec', '\x91', '\x8d'}, 3, 0xC44D}, /* (HANGUL SYLLABLE SSYONJ) */
    {{'\xec', '\x91', '\x8e'}, 3, 0xC44E}, /* (HANGUL SYLLABLE SSYONH) */
    {{'\xec', '\x91', '\x8f'}, 3, 0xC44F}, /* (HANGUL SYLLABLE SSYOD) */
    {{'\xec', '\x91', '\x90'}, 3, 0xC450}, /* (HANGUL SYLLABLE SSYOL) */
    {{'\xec', '\x91', '\x91'}, 3, 0xC451}, /* (HANGUL SYLLABLE SSYOLG) */
    {{'\xec', '\x91', '\x92'}, 3, 0xC452}, /* (HANGUL SYLLABLE SSYOLM) */
    {{'\xec', '\x91', '\x93'}, 3, 0xC453}, /* (HANGUL SYLLABLE SSYOLB) */
    {{'\xec', '\x91', '\x94'}, 3, 0xC454}, /* (HANGUL SYLLABLE SSYOLS) */
    {{'\xec', '\x91', '\x95'}, 3, 0xC455}, /* (HANGUL SYLLABLE SSYOLT) */
    {{'\xec', '\x91', '\x96'}, 3, 0xC456}, /* (HANGUL SYLLABLE SSYOLP) */
    {{'\xec', '\x91', '\x97'}, 3, 0xC457}, /* (HANGUL SYLLABLE SSYOLH) */
    {{'\xec', '\x91', '\x98'}, 3, 0xC458}, /* (HANGUL SYLLABLE SSYOM) */
    {{'\xec', '\x91', '\x99'}, 3, 0xC459}, /* (HANGUL SYLLABLE SSYOB) */
    {{'\xec', '\x91', '\x9a'}, 3, 0xC45A}, /* (HANGUL SYLLABLE SSYOBS) */
    {{'\xec', '\x91', '\x9b'}, 3, 0xC45B}, /* (HANGUL SYLLABLE SSYOS) */
    {{'\xec', '\x91', '\x9c'}, 3, 0xC45C}, /* (HANGUL SYLLABLE SSYOSS) */
    {{'\xec', '\x91', '\x9d'}, 3, 0xC45D}, /* (HANGUL SYLLABLE SSYONG) */
    {{'\xec', '\x91', '\x9e'}, 3, 0xC45E}, /* (HANGUL SYLLABLE SSYOJ) */
    {{'\xec', '\x91', '\x9f'}, 3, 0xC45F}, /* (HANGUL SYLLABLE SSYOC) */
    {{'\xec', '\x91', '\xa0'}, 3, 0xC460}, /* (HANGUL SYLLABLE SSYOK) */
    {{'\xec', '\x91', '\xa1'}, 3, 0xC461}, /* (HANGUL SYLLABLE SSYOT) */
    {{'\xec', '\x91', '\xa2'}, 3, 0xC462}, /* (HANGUL SYLLABLE SSYOP) */
    {{'\xec', '\x91', '\xa3'}, 3, 0xC463}, /* (HANGUL SYLLABLE SSYOH) */
    {{'\xec', '\x91', '\xa6'}, 3, 0xC466}, /* (HANGUL SYLLABLE SSUGG) */
    {{'\xec', '\x91', '\xa7'}, 3, 0xC467}, /* (HANGUL SYLLABLE SSUGS) */
    {{'\xec', '\x91', '\xa9'}, 3, 0xC469}, /* (HANGUL SYLLABLE SSUNJ) */
    {{'\xec', '\x91', '\xaa'}, 3, 0xC46A}, /* (HANGUL SYLLABLE SSUNH) */
    {{'\xec', '\x91', '\xab'}, 3, 0xC46B}, /* (HANGUL SYLLABLE SSUD) */
    {{'\xec', '\x91', '\xad'}, 3, 0xC46D}, /* (HANGUL SYLLABLE SSULG) */
    {{'\xec', '\x91', '\xae'}, 3, 0xC46E}, /* (HANGUL SYLLABLE SSULM) */
    {{'\xec', '\x91', '\xaf'}, 3, 0xC46F}, /* (HANGUL SYLLABLE SSULB) */
    {{'\xec', '\x91', '\xb0'}, 3, 0xC470}, /* (HANGUL SYLLABLE SSULS) */
    {{'\xec', '\x91', '\xb1'}, 3, 0xC471}, /* (HANGUL SYLLABLE SSULT) */
    {{'\xec', '\x91', '\xb2'}, 3, 0xC472}, /* (HANGUL SYLLABLE SSULP) */
    {{'\xec', '\x91', '\xb3'}, 3, 0xC473}, /* (HANGUL SYLLABLE SSULH) */
    {{'\xec', '\x91', '\xb6'}, 3, 0xC476}, /* (HANGUL SYLLABLE SSUBS) */
    {{'\xec', '\x91', '\xb7'}, 3, 0xC477}, /* (HANGUL SYLLABLE SSUS) */
    {{'\xec', '\x91', '\xb8'}, 3, 0xC478}, /* (HANGUL SYLLABLE SSUSS) */
    {{'\xec', '\x91', '\xba'}, 3, 0xC47A}, /* (HANGUL SYLLABLE SSUJ) */
    {{'\xec', '\x91', '\xbb'}, 3, 0xC47B}, /* (HANGUL SYLLABLE SSUC) */
    {{'\xec', '\x91', '\xbc'}, 3, 0xC47C}, /* (HANGUL SYLLABLE SSUK) */
    {{'\xec', '\x91', '\xbd'}, 3, 0xC47D}, /* (HANGUL SYLLABLE SSUT) */
    {{'\xec', '\x91', '\xbe'}, 3, 0xC47E}, /* (HANGUL SYLLABLE SSUP) */
    {{'\xec', '\x91', '\xbf'}, 3, 0xC47F}, /* (HANGUL SYLLABLE SSUH) */
    {{'\xec', '\x92', '\x81'}, 3, 0xC481}, /* (HANGUL SYLLABLE SSWEOG) */
    {{'\xec', '\x92', '\x82'}, 3, 0xC482}, /* (HANGUL SYLLABLE SSWEOGG) */
    {{'\xec', '\x92', '\x83'}, 3, 0xC483}, /* (HANGUL SYLLABLE SSWEOGS) */
    {{'\xec', '\x92', '\x84'}, 3, 0xC484}, /* (HANGUL SYLLABLE SSWEON) */
    {{'\xec', '\x92', '\x85'}, 3, 0xC485}, /* (HANGUL SYLLABLE SSWEONJ) */
    {{'\xec', '\x92', '\x86'}, 3, 0xC486}, /* (HANGUL SYLLABLE SSWEONH) */
    {{'\xec', '\x92', '\x87'}, 3, 0xC487}, /* (HANGUL SYLLABLE SSWEOD) */
    {{'\xec', '\x92', '\x88'}, 3, 0xC488}, /* (HANGUL SYLLABLE SSWEOL) */
    {{'\xec', '\x92', '\x89'}, 3, 0xC489}, /* (HANGUL SYLLABLE SSWEOLG) */
    {{'\xec', '\x92', '\x8a'}, 3, 0xC48A}, /* (HANGUL SYLLABLE SSWEOLM) */
    {{'\xec', '\x92', '\x8b'}, 3, 0xC48B}, /* (HANGUL SYLLABLE SSWEOLB) */
    {{'\xec', '\x92', '\x8c'}, 3, 0xC48C}, /* (HANGUL SYLLABLE SSWEOLS) */
    {{'\xec', '\x92', '\x8d'}, 3, 0xC48D}, /* (HANGUL SYLLABLE SSWEOLT) */
    {{'\xec', '\x92', '\x8e'}, 3, 0xC48E}, /* (HANGUL SYLLABLE SSWEOLP) */
    {{'\xec', '\x92', '\x8f'}, 3, 0xC48F}, /* (HANGUL SYLLABLE SSWEOLH) */
    {{'\xec', '\x92', '\x90'}, 3, 0xC490}, /* (HANGUL SYLLABLE SSWEOM) */
    {{'\xec', '\x92', '\x91'}, 3, 0xC491}, /* (HANGUL SYLLABLE SSWEOB) */
    {{'\xec', '\x92', '\x92'}, 3, 0xC492}, /* (HANGUL SYLLABLE SSWEOBS) */
    {{'\xec', '\x92', '\x93'}, 3, 0xC493}, /* (HANGUL SYLLABLE SSWEOS) */
    {{'\xec', '\x92', '\x95'}, 3, 0xC495}, /* (HANGUL SYLLABLE SSWEONG) */
    {{'\xec', '\x92', '\x96'}, 3, 0xC496}, /* (HANGUL SYLLABLE SSWEOJ) */
    {{'\xec', '\x92', '\x97'}, 3, 0xC497}, /* (HANGUL SYLLABLE SSWEOC) */
    {{'\xec', '\x92', '\x98'}, 3, 0xC498}, /* (HANGUL SYLLABLE SSWEOK) */
    {{'\xec', '\x92', '\x99'}, 3, 0xC499}, /* (HANGUL SYLLABLE SSWEOT) */
    {{'\xec', '\x92', '\x9a'}, 3, 0xC49A}, /* (HANGUL SYLLABLE SSWEOP) */
    {{'\xec', '\x92', '\x9b'}, 3, 0xC49B}, /* (HANGUL SYLLABLE SSWEOH) */
    {{'\xec', '\x92', '\x9d'}, 3, 0xC49D}, /* (HANGUL SYLLABLE SSWEG) */
    {{'\xec', '\x92', '\x9e'}, 3, 0xC49E}, /* (HANGUL SYLLABLE SSWEGG) */
    {{'\xec', '\x92', '\x9f'}, 3, 0xC49F}, /* (HANGUL SYLLABLE SSWEGS) */
    {{'\xec', '\x92', '\xa0'}, 3, 0xC4A0}, /* (HANGUL SYLLABLE SSWEN) */
    {{'\xec', '\x92', '\xa1'}, 3, 0xC4A1}, /* (HANGUL SYLLABLE SSWENJ) */
    {{'\xec', '\x92', '\xa2'}, 3, 0xC4A2}, /* (HANGUL SYLLABLE SSWENH) */
    {{'\xec', '\x92', '\xa3'}, 3, 0xC4A3}, /* (HANGUL SYLLABLE SSWED) */
    {{'\xec', '\x92', '\xa4'}, 3, 0xC4A4}, /* (HANGUL SYLLABLE SSWEL) */
    {{'\xec', '\x92', '\xa5'}, 3, 0xC4A5}, /* (HANGUL SYLLABLE SSWELG) */
    {{'\xec', '\x92', '\xa6'}, 3, 0xC4A6}, /* (HANGUL SYLLABLE SSWELM) */
    {{'\xec', '\x92', '\xa7'}, 3, 0xC4A7}, /* (HANGUL SYLLABLE SSWELB) */
    {{'\xec', '\x92', '\xa8'}, 3, 0xC4A8}, /* (HANGUL SYLLABLE SSWELS) */
    {{'\xec', '\x92', '\xa9'}, 3, 0xC4A9}, /* (HANGUL SYLLABLE SSWELT) */
    {{'\xec', '\x92', '\xaa'}, 3, 0xC4AA}, /* (HANGUL SYLLABLE SSWELP) */
    {{'\xec', '\x92', '\xab'}, 3, 0xC4AB}, /* (HANGUL SYLLABLE SSWELH) */
    {{'\xec', '\x92', '\xac'}, 3, 0xC4AC}, /* (HANGUL SYLLABLE SSWEM) */
    {{'\xec', '\x92', '\xad'}, 3, 0xC4AD}, /* (HANGUL SYLLABLE SSWEB) */
    {{'\xec', '\x92', '\xae'}, 3, 0xC4AE}, /* (HANGUL SYLLABLE SSWEBS) */
    {{'\xec', '\x92', '\xaf'}, 3, 0xC4AF}, /* (HANGUL SYLLABLE SSWES) */
    {{'\xec', '\x92', '\xb0'}, 3, 0xC4B0}, /* (HANGUL SYLLABLE SSWESS) */
    {{'\xec', '\x92', '\xb1'}, 3, 0xC4B1}, /* (HANGUL SYLLABLE SSWENG) */
    {{'\xec', '\x92', '\xb2'}, 3, 0xC4B2}, /* (HANGUL SYLLABLE SSWEJ) */
    {{'\xec', '\x92', '\xb3'}, 3, 0xC4B3}, /* (HANGUL SYLLABLE SSWEC) */
    {{'\xec', '\x92', '\xb4'}, 3, 0xC4B4}, /* (HANGUL SYLLABLE SSWEK) */
    {{'\xec', '\x92', '\xb5'}, 3, 0xC4B5}, /* (HANGUL SYLLABLE SSWET) */
    {{'\xec', '\x92', '\xb6'}, 3, 0xC4B6}, /* (HANGUL SYLLABLE SSWEP) */
    {{'\xec', '\x92', '\xb7'}, 3, 0xC4B7}, /* (HANGUL SYLLABLE SSWEH) */
    {{'\xec', '\x92', '\xb9'}, 3, 0xC4B9}, /* (HANGUL SYLLABLE SSWIG) */
    {{'\xec', '\x92', '\xba'}, 3, 0xC4BA}, /* (HANGUL SYLLABLE SSWIGG) */
    {{'\xec', '\x92', '\xbb'}, 3, 0xC4BB}, /* (HANGUL SYLLABLE SSWIGS) */
    {{'\xec', '\x92', '\xbd'}, 3, 0xC4BD}, /* (HANGUL SYLLABLE SSWINJ) */
    {{'\xec', '\x92', '\xbe'}, 3, 0xC4BE}, /* (HANGUL SYLLABLE SSWINH) */
    {{'\xec', '\x92', '\xbf'}, 3, 0xC4BF}, /* (HANGUL SYLLABLE SSWID) */
    {{'\xec', '\x93', '\x80'}, 3, 0xC4C0}, /* (HANGUL SYLLABLE SSWIL) */
    {{'\xec', '\x93', '\x81'}, 3, 0xC4C1}, /* (HANGUL SYLLABLE SSWILG) */
    {{'\xec', '\x93', '\x82'}, 3, 0xC4C2}, /* (HANGUL SYLLABLE SSWILM) */
    {{'\xec', '\x93', '\x83'}, 3, 0xC4C3}, /* (HANGUL SYLLABLE SSWILB) */
    {{'\xec', '\x93', '\x84'}, 3, 0xC4C4}, /* (HANGUL SYLLABLE SSWILS) */
    {{'\xec', '\x93', '\x85'}, 3, 0xC4C5}, /* (HANGUL SYLLABLE SSWILT) */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{'\xec', '\x93', '\x86'}, 3, 0xC4C6}, /* (HANGUL SYLLABLE SSWILP) */
    {{'\xec', '\x93', '\x87'}, 3, 0xC4C7}, /* (HANGUL SYLLABLE SSWILH) */
    {{'\xec', '\x93', '\x88'}, 3, 0xC4C8}, /* (HANGUL SYLLABLE SSWIM) */
    {{'\xec', '\x93', '\x89'}, 3, 0xC4C9}, /* (HANGUL SYLLABLE SSWIB) */
    {{'\xec', '\x93', '\x8a'}, 3, 0xC4CA}, /* (HANGUL SYLLABLE SSWIBS) */
    {{'\xec', '\x93', '\x8b'}, 3, 0xC4CB}, /* (HANGUL SYLLABLE SSWIS) */
    {{'\xec', '\x93', '\x8c'}, 3, 0xC4CC}, /* (HANGUL SYLLABLE SSWISS) */
    {{'\xec', '\x93', '\x8d'}, 3, 0xC4CD}, /* (HANGUL SYLLABLE SSWING) */
    {{'\xec', '\x93', '\x8e'}, 3, 0xC4CE}, /* (HANGUL SYLLABLE SSWIJ) */
    {{'\xec', '\x93', '\x8f'}, 3, 0xC4CF}, /* (HANGUL SYLLABLE SSWIC) */
    {{'\xec', '\x93', '\x90'}, 3, 0xC4D0}, /* (HANGUL SYLLABLE SSWIK) */
    {{'\xec', '\x93', '\x91'}, 3, 0xC4D1}, /* (HANGUL SYLLABLE SSWIT) */
    {{'\xec', '\x93', '\x92'}, 3, 0xC4D2}, /* (HANGUL SYLLABLE SSWIP) */
    {{'\xec', '\x93', '\x93'}, 3, 0xC4D3}, /* (HANGUL SYLLABLE SSWIH) */
    {{'\xec', '\x93', '\x94'}, 3, 0xC4D4}, /* (HANGUL SYLLABLE SSYU) */
    {{'\xec', '\x93', '\x95'}, 3, 0xC4D5}, /* (HANGUL SYLLABLE SSYUG) */
    {{'\xec', '\x93', '\x96'}, 3, 0xC4D6}, /* (HANGUL SYLLABLE SSYUGG) */
    {{'\xec', '\x93', '\x97'}, 3, 0xC4D7}, /* (HANGUL SYLLABLE SSYUGS) */
    {{'\xec', '\x93', '\x98'}, 3, 0xC4D8}, /* (HANGUL SYLLABLE SSYUN) */
    {{'\xec', '\x93', '\x99'}, 3, 0xC4D9}, /* (HANGUL SYLLABLE SSYUNJ) */
    {{'\xec', '\x93', '\x9a'}, 3, 0xC4DA}, /* (HANGUL SYLLABLE SSYUNH) */
    {{'\xec', '\x93', '\x9b'}, 3, 0xC4DB}, /* (HANGUL SYLLABLE SSYUD) */
    {{'\xec', '\x93', '\x9c'}, 3, 0xC4DC}, /* (HANGUL SYLLABLE SSYUL) */
    {{'\xec', '\x93', '\x9d'}, 3, 0xC4DD}, /* (HANGUL SYLLABLE SSYULG) */
    {{'\xec', '\x93', '\x9e'}, 3, 0xC4DE}, /* (HANGUL SYLLABLE SSYULM) */
    {{'\xec', '\x93', '\x9f'}, 3, 0xC4DF}, /* (HANGUL SYLLABLE SSYULB) */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{'\xec', '\x93', '\xa0'}, 3, 0xC4E0}, /* (HANGUL SYLLABLE SSYULS) */
    {{'\xec', '\x93', '\xa1'}, 3, 0xC4E1}, /* (HANGUL SYLLABLE SSYULT) */
    {{'\xec', '\x93', '\xa2'}, 3, 0xC4E2}, /* (HANGUL SYLLABLE SSYULP) */
    {{'\xec', '\x93', '\xa3'}, 3, 0xC4E3}, /* (HANGUL SYLLABLE SSYULH) */
    {{'\xec', '\x93', '\xa4'}, 3, 0xC4E4}, /* (HANGUL SYLLABLE SSYUM) */
    {{'\xec', '\x93', '\xa5'}, 3, 0xC4E5}, /* (HANGUL SYLLABLE SSYUB) */
    {{'\xec', '\x93', '\xa6'}, 3, 0xC4E6}, /* (HANGUL SYLLABLE SSYUBS) */
    {{'\xec', '\x93', '\xa7'}, 3, 0xC4E7}, /* (HANGUL SYLLABLE SSYUS) */
    {{'\xec', '\x93', '\xa8'}, 3, 0xC4E8}, /* (HANGUL SYLLABLE SSYUSS) */
    {{'\xec', '\x93', '\xaa'}, 3, 0xC4EA}, /* (HANGUL SYLLABLE SSYUJ) */
    {{'\xec', '\x93', '\xab'}, 3, 0xC4EB}, /* (HANGUL SYLLABLE SSYUC) */
    {{'\xec', '\x93', '\xac'}, 3, 0xC4EC}, /* (HANGUL SYLLABLE SSYUK) */
    {{'\xec', '\x93', '\xad'}, 3, 0xC4ED}, /* (HANGUL SYLLABLE SSYUT) */
    {{'\xec', '\x93', '\xae'}, 3, 0xC4EE}, /* (HANGUL SYLLABLE SSYUP) */
    {{'\xec', '\x93', '\xaf'}, 3, 0xC4EF}, /* (HANGUL SYLLABLE SSYUH) */
    {{'\xec', '\x93', '\xb2'}, 3, 0xC4F2}, /* (HANGUL SYLLABLE SSEUGG) */
    {{'\xec', '\x93', '\xb3'}, 3, 0xC4F3}, /* (HANGUL SYLLABLE SSEUGS) */
    {{'\xec', '\x93', '\xb5'}, 3, 0xC4F5}, /* (HANGUL SYLLABLE SSEUNJ) */
    {{'\xec', '\x93', '\xb6'}, 3, 0xC4F6}, /* (HANGUL SYLLABLE SSEUNH) */
    {{'\xec', '\x93', '\xb7'}, 3, 0xC4F7}, /* (HANGUL SYLLABLE SSEUD) */
    {{'\xec', '\x93', '\xb9'}, 3, 0xC4F9}, /* (HANGUL SYLLABLE SSEULG) */
    {{'\xec', '\x93', '\xbb'}, 3, 0xC4FB}, /* (HANGUL SYLLABLE SSEULB) */
    {{'\xec', '\x93', '\xbc'}, 3, 0xC4FC}, /* (HANGUL SYLLABLE SSEULS) */
    {{'\xec', '\x93', '\xbd'}, 3, 0xC4FD}, /* (HANGUL SYLLABLE SSEULT) */
    {{'\xec', '\x93', '\xbe'}, 3, 0xC4FE}, /* (HANGUL SYLLABLE SSEULP) */
    {{'\xec', '\x94', '\x82'}, 3, 0xC502}, /* (HANGUL SYLLABLE SSEUBS) */
    {{'\xec', '\x94', '\x83'}, 3, 0xC503}, /* (HANGUL SYLLABLE SSEUS) */
    {{'\xec', '\x94', '\x84'}, 3, 0xC504}, /* (HANGUL SYLLABLE SSEUSS) */
    {{'\xec', '\x94', '\x85'}, 3, 0xC505}, /* (HANGUL SYLLABLE SSEUNG) */
    {{'\xec', '\x94', '\x86'}, 3, 0xC506}, /* (HANGUL SYLLABLE SSEUJ) */
    {{'\xec', '\x94', '\x87'}, 3, 0xC507}, /* (HANGUL SYLLABLE SSEUC) */
    {{'\xec', '\x94', '\x88'}, 3, 0xC508}, /* (HANGUL SYLLABLE SSEUK) */
    {{'\xec', '\x94', '\x89'}, 3, 0xC509}, /* (HANGUL SYLLABLE SSEUT) */
    {{'\xec', '\x94', '\x8a'}, 3, 0xC50A}, /* (HANGUL SYLLABLE SSEUP) */
    {{'\xec', '\x94', '\x8b'}, 3, 0xC50B}, /* (HANGUL SYLLABLE SSEUH) */
    {{'\xec', '\x94', '\x8d'}, 3, 0xC50D}, /* (HANGUL SYLLABLE SSYIG) */
    {{'\xec', '\x94', '\x8e'}, 3, 0xC50E}, /* (HANGUL SYLLABLE SSYIGG) */
    {{'\xec', '\x94', '\x8f'}, 3, 0xC50F}, /* (HANGUL SYLLABLE SSYIGS) */
    {{'\xec', '\x94', '\x91'}, 3, 0xC511}, /* (HANGUL SYLLABLE SSYINJ) */
    {{'\xec', '\x94', '\x92'}, 3, 0xC512}, /* (HANGUL SYLLABLE SSYINH) */
    {{'\xec', '\x94', '\x93'}, 3, 0xC513}, /* (HANGUL SYLLABLE SSYID) */
    {{'\xec', '\x94', '\x95'}, 3, 0xC515}, /* (HANGUL SYLLABLE SSYILG) */
    {{'\xec', '\x94', '\x96'}, 3, 0xC516}, /* (HANGUL SYLLABLE SSYILM) */
    {{'\xec', '\x94', '\x97'}, 3, 0xC517}, /* (HANGUL SYLLABLE SSYILB) */
    {{'\xec', '\x94', '\x98'}, 3, 0xC518}, /* (HANGUL SYLLABLE SSYILS) */
    {{'\xec', '\x94', '\x99'}, 3, 0xC519}, /* (HANGUL SYLLABLE SSYILT) */
    {{'\xec', '\x94', '\x9a'}, 3, 0xC51A}, /* (HANGUL SYLLABLE SSYILP) */
    {{'\xec', '\x94', '\x9b'}, 3, 0xC51B}, /* (HANGUL SYLLABLE SSYILH) */
    {{'\xec', '\x94', '\x9d'}, 3, 0xC51D}, /* (HANGUL SYLLABLE SSYIB) */
    {{'\xec', '\x94', '\x9e'}, 3, 0xC51E}, /* (HANGUL SYLLABLE SSYIBS) */
    {{'\xec', '\x94', '\x9f'}, 3, 0xC51F}, /* (HANGUL SYLLABLE SSYIS) */
    {{'\xec', '\x94', '\xa0'}, 3, 0xC520}, /* (HANGUL SYLLABLE SSYISS) */
    {{'\xec', '\x94', '\xa1'}, 3, 0xC521}, /* (HANGUL SYLLABLE SSYING) */
    {{'\xec', '\x94', '\xa2'}, 3, 0xC522}, /* (HANGUL SYLLABLE SSYIJ) */
    {{'\xec', '\x94', '\xa3'}, 3, 0xC523}, /* (HANGUL SYLLABLE SSYIC) */
    {{'\xec', '\x94', '\xa4'}, 3, 0xC524}, /* (HANGUL SYLLABLE SSYIK) */
    {{'\xec', '\x94', '\xa5'}, 3, 0xC525}, /* (HANGUL SYLLABLE SSYIT) */
    {{'\xec', '\x94', '\xa6'}, 3, 0xC526}, /* (HANGUL SYLLABLE SSYIP) */
    {{'\xec', '\x94', '\xa7'}, 3, 0xC527}, /* (HANGUL SYLLABLE SSYIH) */
    {{'\xec', '\x94', '\xaa'}, 3, 0xC52A}, /* (HANGUL SYLLABLE SSIGG) */
    {{'\xec', '\x94', '\xab'}, 3, 0xC52B}, /* (HANGUL SYLLABLE SSIGS) */
    {{'\xec', '\x94', '\xad'}, 3, 0xC52D}, /* (HANGUL SYLLABLE SSINJ) */
    {{'\xec', '\x94', '\xae'}, 3, 0xC52E}, /* (HANGUL SYLLABLE SSINH) */
    {{'\xec', '\x94', '\xaf'}, 3, 0xC52F}, /* (HANGUL SYLLABLE SSID) */
    {{'\xec', '\x94', '\xb1'}, 3, 0xC531}, /* (HANGUL SYLLABLE SSILG) */
    {{'\xec', '\x94', '\xb2'}, 3, 0xC532}, /* (HANGUL SYLLABLE SSILM) */
    {{'\xec', '\x94', '\xb3'}, 3, 0xC533}, /* (HANGUL SYLLABLE SSILB) */
    {{'\xec', '\x94', '\xb4'}, 3, 0xC534}, /* (HANGUL SYLLABLE SSILS) */
    {{'\xec', '\x94', '\xb5'}, 3, 0xC535}, /* (HANGUL SYLLABLE SSILT) */
    {{'\xec', '\x94', '\xb6'}, 3, 0xC536}, /* (HANGUL SYLLABLE SSILP) */
    {{'\xec', '\x94', '\xb7'}, 3, 0xC537}, /* (HANGUL SYLLABLE SSILH) */
    {{'\xec', '\x94', '\xba'}, 3, 0xC53A}, /* (HANGUL SYLLABLE SSIBS) */
    {{'\xec', '\x94', '\xbc'}, 3, 0xC53C}, /* (HANGUL SYLLABLE SSISS) */
    {{'\xec', '\x94', '\xbe'}, 3, 0xC53E}, /* (HANGUL SYLLABLE SSIJ) */
    {{'\xec', '\x94', '\xbf'}, 3, 0xC53F}, /* (HANGUL SYLLABLE SSIC) */
    {{'\xec', '\x95', '\x80'}, 3, 0xC540}, /* (HANGUL SYLLABLE SSIK) */
    {{'\xec', '\x95', '\x81'}, 3, 0xC541}, /* (HANGUL SYLLABLE SSIT) */
    {{'\xec', '\x95', '\x82'}, 3, 0xC542}, /* (HANGUL SYLLABLE SSIP) */
    {{'\xec', '\x95', '\x83'}, 3, 0xC543}, /* (HANGUL SYLLABLE SSIH) */
    {{'\xec', '\x95', '\x86'}, 3, 0xC546}, /* (HANGUL SYLLABLE AGG) */
    {{'\xec', '\x95', '\x87'}, 3, 0xC547}, /* (HANGUL SYLLABLE AGS) */
    {{'\xec', '\x95', '\x8b'}, 3, 0xC54B}, /* (HANGUL SYLLABLE AD) */
    {{'\xec', '\x95', '\x8f'}, 3, 0xC54F}, /* (HANGUL SYLLABLE ALB) */
    {{'\xec', '\x95', '\x90'}, 3, 0xC550}, /* (HANGUL SYLLABLE ALS) */
    {{'\xec', '\x95', '\x91'}, 3, 0xC551}, /* (HANGUL SYLLABLE ALT) */
    {{'\xec', '\x95', '\x92'}, 3, 0xC552}, /* (HANGUL SYLLABLE ALP) */
    {{'\xec', '\x95', '\x96'}, 3, 0xC556}, /* (HANGUL SYLLABLE ABS) */
    {{'\xec', '\x95', '\x9a'}, 3, 0xC55A}, /* (HANGUL SYLLABLE AJ) */
    {{'\xec', '\x95', '\x9b'}, 3, 0xC55B}, /* (HANGUL SYLLABLE AC) */
    {{'\xec', '\x95', '\x9c'}, 3, 0xC55C}, /* (HANGUL SYLLABLE AK) */
    {{'\xec', '\x95', '\x9f'}, 3, 0xC55F}, /* (HANGUL SYLLABLE AH) */
    {{'\xec', '\x95', '\xa2'}, 3, 0xC562}, /* (HANGUL SYLLABLE AEGG) */
    {{'\xec', '\x95', '\xa3'}, 3, 0xC563}, /* (HANGUL SYLLABLE AEGS) */
    {{'\xec', '\x95', '\xa5'}, 3, 0xC565}, /* (HANGUL SYLLABLE AENJ) */
    {{'\xec', '\x95', '\xa6'}, 3, 0xC566}, /* (HANGUL SYLLABLE AENH) */
    {{'\xec', '\x95', '\xa7'}, 3, 0xC567}, /* (HANGUL SYLLABLE AED) */
    {{'\xec', '\x95', '\xa9'}, 3, 0xC569}, /* (HANGUL SYLLABLE AELG) */
    {{'\xec', '\x95', '\xaa'}, 3, 0xC56A}, /* (HANGUL SYLLABLE AELM) */
    {{'\xec', '\x95', '\xab'}, 3, 0xC56B}, /* (HANGUL SYLLABLE AELB) */
    {{'\xec', '\x95', '\xac'}, 3, 0xC56C}, /* (HANGUL SYLLABLE AELS) */
    {{'\xec', '\x95', '\xad'}, 3, 0xC56D}, /* (HANGUL SYLLABLE AELT) */
    {{'\xec', '\x95', '\xae'}, 3, 0xC56E}, /* (HANGUL SYLLABLE AELP) */
    {{'\xec', '\x95', '\xaf'}, 3, 0xC56F}, /* (HANGUL SYLLABLE AELH) */
    {{'\xec', '\x95', '\xb2'}, 3, 0xC572}, /* (HANGUL SYLLABLE AEBS) */
    {{'\xec', '\x95', '\xb6'}, 3, 0xC576}, /* (HANGUL SYLLABLE AEJ) */
    {{'\xec', '\x95', '\xb7'}, 3, 0xC577}, /* (HANGUL SYLLABLE AEC) */
    {{'\xec', '\x95', '\xb8'}, 3, 0xC578}, /* (HANGUL SYLLABLE AEK) */
    {{'\xec', '\x95', '\xb9'}, 3, 0xC579}, /* (HANGUL SYLLABLE AET) */
    {{'\xec', '\x95', '\xba'}, 3, 0xC57A}, /* (HANGUL SYLLABLE AEP) */
    {{'\xec', '\x95', '\xbb'}, 3, 0xC57B}, /* (HANGUL SYLLABLE AEH) */
    {{'\xec', '\x95', '\xbe'}, 3, 0xC57E}, /* (HANGUL SYLLABLE YAGG) */
    {{'\xec', '\x95', '\xbf'}, 3, 0xC57F}, /* (HANGUL SYLLABLE YAGS) */
    {{'\xec', '\x96', '\x81'}, 3, 0xC581}, /* (HANGUL SYLLABLE YANJ) */
    {{'\xec', '\x96', '\x82'}, 3, 0xC582}, /* (HANGUL SYLLABLE YANH) */
    {{'\xec', '\x96', '\x83'}, 3, 0xC583}, /* (HANGUL SYLLABLE YAD) */
    {{'\xec', '\x96', '\x85'}, 3, 0xC585}, /* (HANGUL SYLLABLE YALG) */
    {{'\xec', '\x96', '\x86'}, 3, 0xC586}, /* (HANGUL SYLLABLE YALM) */
    {{'\xec', '\x96', '\x88'}, 3, 0xC588}, /* (HANGUL SYLLABLE YALS) */
    {{'\xec', '\x96', '\x89'}, 3, 0xC589}, /* (HANGUL SYLLABLE YALT) */
    {{'\xec', '\x96', '\x8a'}, 3, 0xC58A}, /* (HANGUL SYLLABLE YALP) */
    {{'\xec', '\x96', '\x8b'}, 3, 0xC58B}, /* (HANGUL SYLLABLE YALH) */
    {{'\xec', '\x96', '\x8e'}, 3, 0xC58E}, /* (HANGUL SYLLABLE YABS) */
    {{'\xec', '\x96', '\x90'}, 3, 0xC590}, /* (HANGUL SYLLABLE YASS) */
    {{'\xec', '\x96', '\x92'}, 3, 0xC592}, /* (HANGUL SYLLABLE YAJ) */
    {{'\xec', '\x96', '\x93'}, 3, 0xC593}, /* (HANGUL SYLLABLE YAC) */
    {{'\xec', '\x96', '\x94'}, 3, 0xC594}, /* (HANGUL SYLLABLE YAK) */
    {{'\xec', '\x96', '\x96'}, 3, 0xC596}, /* (HANGUL SYLLABLE YAP) */
    {{'\xec', '\x96', '\x99'}, 3, 0xC599}, /* (HANGUL SYLLABLE YAEG) */
    {{'\xec', '\x96', '\x9a'}, 3, 0xC59A}, /* (HANGUL SYLLABLE YAEGG) */
    {{'\xec', '\x96', '\x9b'}, 3, 0xC59B}, /* (HANGUL SYLLABLE YAEGS) */
    {{'\xec', '\x96', '\x9d'}, 3, 0xC59D}, /* (HANGUL SYLLABLE YAENJ) */
    {{'\xec', '\x96', '\x9e'}, 3, 0xC59E}, /* (HANGUL SYLLABLE YAENH) */
    {{'\xec', '\x96', '\x9f'}, 3, 0xC59F}, /* (HANGUL SYLLABLE YAED) */
    {{'\xec', '\x96', '\xa1'}, 3, 0xC5A1}, /* (HANGUL SYLLABLE YAELG) */
    {{'\xec', '\x96', '\xa2'}, 3, 0xC5A2}, /* (HANGUL SYLLABLE YAELM) */
    {{'\xec', '\x96', '\xa3'}, 3, 0xC5A3}, /* (HANGUL SYLLABLE YAELB) */
    {{'\xec', '\x96', '\xa4'}, 3, 0xC5A4}, /* (HANGUL SYLLABLE YAELS) */
    {{'\xec', '\x96', '\xa5'}, 3, 0xC5A5}, /* (HANGUL SYLLABLE YAELT) */
    {{'\xec', '\x96', '\xa6'}, 3, 0xC5A6}, /* (HANGUL SYLLABLE YAELP) */
    {{'\xec', '\x96', '\xa7'}, 3, 0xC5A7}, /* (HANGUL SYLLABLE YAELH) */
    {{'\xec', '\x96', '\xa8'}, 3, 0xC5A8}, /* (HANGUL SYLLABLE YAEM) */
    {{'\xec', '\x96', '\xaa'}, 3, 0xC5AA}, /* (HANGUL SYLLABLE YAEBS) */
    {{'\xec', '\x96', '\xab'}, 3, 0xC5AB}, /* (HANGUL SYLLABLE YAES) */
    {{'\xec', '\x96', '\xac'}, 3, 0xC5AC}, /* (HANGUL SYLLABLE YAESS) */
    {{'\xec', '\x96', '\xad'}, 3, 0xC5AD}, /* (HANGUL SYLLABLE YAENG) */
    {{'\xec', '\x96', '\xae'}, 3, 0xC5AE}, /* (HANGUL SYLLABLE YAEJ) */
    {{'\xec', '\x96', '\xaf'}, 3, 0xC5AF}, /* (HANGUL SYLLABLE YAEC) */
    {{'\xec', '\x96', '\xb0'}, 3, 0xC5B0}, /* (HANGUL SYLLABLE YAEK) */
    {{'\xec', '\x96', '\xb1'}, 3, 0xC5B1}, /* (HANGUL SYLLABLE YAET) */
    {{'\xec', '\x96', '\xb2'}, 3, 0xC5B2}, /* (HANGUL SYLLABLE YAEP) */
    {{'\xec', '\x96', '\xb3'}, 3, 0xC5B3}, /* (HANGUL SYLLABLE YAEH) */
    {{'\xec', '\x96', '\xb6'}, 3, 0xC5B6}, /* (HANGUL SYLLABLE EOGG) */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{'\xec', '\x96', '\xb7'}, 3, 0xC5B7}, /* (HANGUL SYLLABLE EOGS) */
    {{'\xec', '\x96', '\xba'}, 3, 0xC5BA}, /* (HANGUL SYLLABLE EONH) */
    {{'\xec', '\x96', '\xbf'}, 3, 0xC5BF}, /* (HANGUL SYLLABLE EOLB) */
    {{'\xec', '\x97', '\x80'}, 3, 0xC5C0}, /* (HANGUL SYLLABLE EOLS) */
    {{'\xec', '\x97', '\x81'}, 3, 0xC5C1}, /* (HANGUL SYLLABLE EOLT) */
    {{'\xec', '\x97', '\x82'}, 3, 0xC5C2}, /* (HANGUL SYLLABLE EOLP) */
    {{'\xec', '\x97', '\x83'}, 3, 0xC5C3}, /* (HANGUL SYLLABLE EOLH) */
    {{'\xec', '\x97', '\x8b'}, 3, 0xC5CB}, /* (HANGUL SYLLABLE EOC) */
    {{'\xec', '\x97', '\x8d'}, 3, 0xC5CD}, /* (HANGUL SYLLABLE EOT) */
    {{'\xec', '\x97', '\x8f'}, 3, 0xC5CF}, /* (HANGUL SYLLABLE EOH) */
    {{'\xec', '\x97', '\x92'}, 3, 0xC5D2}, /* (HANGUL SYLLABLE EGG) */
    {{'\xec', '\x97', '\x93'}, 3, 0xC5D3}, /* (HANGUL SYLLABLE EGS) */
    {{'\xec', '\x97', '\x95'}, 3, 0xC5D5}, /* (HANGUL SYLLABLE ENJ) */
    {{'\xec', '\x97', '\x96'}, 3, 0xC5D6}, /* (HANGUL SYLLABLE ENH) */
    {{'\xec', '\x97', '\x97'}, 3, 0xC5D7}, /* (HANGUL SYLLABLE ED) */
    {{'\xec', '\x97', '\x99'}, 3, 0xC5D9}, /* (HANGUL SYLLABLE ELG) */
    {{'\xec', '\x97', '\x9a'}, 3, 0xC5DA}, /* (HANGUL SYLLABLE ELM) */
    {{'\xec', '\x97', '\x9b'}, 3, 0xC5DB}, /* (HANGUL SYLLABLE ELB) */
    {{'\xec', '\x97', '\x9c'}, 3, 0xC5DC}, /* (HANGUL SYLLABLE ELS) */
    {{'\xec', '\x97', '\x9d'}, 3, 0xC5DD}, /* (HANGUL SYLLABLE ELT) */
    {{'\xec', '\x97', '\x9e'}, 3, 0xC5DE}, /* (HANGUL SYLLABLE ELP) */
    {{'\xec', '\x97', '\x9f'}, 3, 0xC5DF}, /* (HANGUL SYLLABLE ELH) */
    {{'\xec', '\x97', '\xa2'}, 3, 0xC5E2}, /* (HANGUL SYLLABLE EBS) */
    {{'\xec', '\x97', '\xa4'}, 3, 0xC5E4}, /* (HANGUL SYLLABLE ESS) */
    {{'\xec', '\x97', '\xa6'}, 3, 0xC5E6}, /* (HANGUL SYLLABLE EJ) */
    {{'\xec', '\x97', '\xa7'}, 3, 0xC5E7}, /* (HANGUL SYLLABLE EC) */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{'\xec', '\x97', '\xa8'}, 3, 0xC5E8}, /* (HANGUL SYLLABLE EK) */
    {{'\xec', '\x97', '\xa9'}, 3, 0xC5E9}, /* (HANGUL SYLLABLE ET) */
    {{'\xec', '\x97', '\xaa'}, 3, 0xC5EA}, /* (HANGUL SYLLABLE EP) */
    {{'\xec', '\x97', '\xab'}, 3, 0xC5EB}, /* (HANGUL SYLLABLE EH) */
    {{'\xec', '\x97', '\xaf'}, 3, 0xC5EF}, /* (HANGUL SYLLABLE YEOGS) */
    {{'\xec', '\x97', '\xb1'}, 3, 0xC5F1}, /* (HANGUL SYLLABLE YEONJ) */
    {{'\xec', '\x97', '\xb2'}, 3, 0xC5F2}, /* (HANGUL SYLLABLE YEONH) */
    {{'\xec', '\x97', '\xb3'}, 3, 0xC5F3}, /* (HANGUL SYLLABLE YEOD) */
    {{'\xec', '\x97', '\xb5'}, 3, 0xC5F5}, /* (HANGUL SYLLABLE YEOLG) */
    {{'\xec', '\x97', '\xb8'}, 3, 0xC5F8}, /* (HANGUL SYLLABLE YEOLS) */
    {{'\xec', '\x97', '\xb9'}, 3, 0xC5F9}, /* (HANGUL SYLLABLE YEOLT) */
    {{'\xec', '\x97', '\xba'}, 3, 0xC5FA}, /* (HANGUL SYLLABLE YEOLP) */
    {{'\xec', '\x97', '\xbb'}, 3, 0xC5FB}, /* (HANGUL SYLLABLE YEOLH) */
    {{'\xec', '\x98', '\x82'}, 3, 0xC602}, /* (HANGUL SYLLABLE YEOJ) */
    {{'\xec', '\x98', '\x83'}, 3, 0xC603}, /* (HANGUL SYLLABLE YEOC) */
    {{'\xec', '\x98', '\x84'}, 3, 0xC604}, /* (HANGUL SYLLABLE YEOK) */
    {{'\xec', '\x98', '\x89'}, 3, 0xC609}, /* (HANGUL SYLLABLE YEG) */
    {{'\xec', '\x98', '\x8a'}, 3, 0xC60A}, /* (HANGUL SYLLABLE YEGG) */
    {{'\xec', '\x98', '\x8b'}, 3, 0xC60B}, /* (HANGUL SYLLABLE YEGS) */
    {{'\xec', '\x98', '\x8d'}, 3, 0xC60D}, /* (HANGUL SYLLABLE YENJ) */
    {{'\xec', '\x98', '\x8e'}, 3, 0xC60E}, /* (HANGUL SYLLABLE YENH) */
    {{'\xec', '\x98', '\x8f'}, 3, 0xC60F}, /* (HANGUL SYLLABLE YED) */
    {{'\xec', '\x98', '\x91'}, 3, 0xC611}, /* (HANGUL SYLLABLE YELG) */
    {{'\xec', '\x98', '\x92'}, 3, 0xC612}, /* (HANGUL SYLLABLE YELM) */
    {{'\xec', '\x98', '\x93'}, 3, 0xC613}, /* (HANGUL SYLLABLE YELB) */
    {{'\xec', '\x98', '\x94'}, 3, 0xC614}, /* (HANGUL SYLLABLE YELS) */
    {{'\xec', '\x98', '\x95'}, 3, 0xC615}, /* (HANGUL SYLLABLE YELT) */
    {{'\xec', '\x98', '\x96'}, 3, 0xC616}, /* (HANGUL SYLLABLE YELP) */
    {{'\xec', '\x98', '\x97'}, 3, 0xC617}, /* (HANGUL SYLLABLE YELH) */
    {{'\xec', '\x98', '\x9a'}, 3, 0xC61A}, /* (HANGUL SYLLABLE YEBS) */
    {{'\xec', '\x98', '\x9d'}, 3, 0xC61D}, /* (HANGUL SYLLABLE YENG) */
    {{'\xec', '\x98', '\x9e'}, 3, 0xC61E}, /* (HANGUL SYLLABLE YEJ) */
    {{'\xec', '\x98', '\x9f'}, 3, 0xC61F}, /* (HANGUL SYLLABLE YEC) */
    {{'\xec', '\x98', '\xa0'}, 3, 0xC620}, /* (HANGUL SYLLABLE YEK) */
    {{'\xec', '\x98', '\xa1'}, 3, 0xC621}, /* (HANGUL SYLLABLE YET) */
    {{'\xec', '\x98', '\xa2'}, 3, 0xC622}, /* (HANGUL SYLLABLE YEP) */
    {{'\xec', '\x98', '\xa3'}, 3, 0xC623}, /* (HANGUL SYLLABLE YEH) */
    {{'\xec', '\x98', '\xa6'}, 3, 0xC626}, /* (HANGUL SYLLABLE OGG) */
    {{'\xec', '\x98', '\xa7'}, 3, 0xC627}, /* (HANGUL SYLLABLE OGS) */
    {{'\xec', '\x98', '\xa9'}, 3, 0xC629}, /* (HANGUL SYLLABLE ONJ) */
    {{'\xec', '\x98', '\xaa'}, 3, 0xC62A}, /* (HANGUL SYLLABLE ONH) */
    {{'\xec', '\x98', '\xab'}, 3, 0xC62B}, /* (HANGUL SYLLABLE OD) */
    {{'\xec', '\x98', '\xaf'}, 3, 0xC62F}, /* (HANGUL SYLLABLE OLB) */
    {{'\xec', '\x98', '\xb1'}, 3, 0xC631}, /* (HANGUL SYLLABLE OLT) */
    {{'\xec', '\x98', '\xb2'}, 3, 0xC632}, /* (HANGUL SYLLABLE OLP) */
    {{'\xec', '\x98', '\xb6'}, 3, 0xC636}, /* (HANGUL SYLLABLE OBS) */
    {{'\xec', '\x98', '\xb8'}, 3, 0xC638}, /* (HANGUL SYLLABLE OSS) */
    {{'\xec', '\x98', '\xba'}, 3, 0xC63A}, /* (HANGUL SYLLABLE OJ) */
    {{'\xec', '\x98', '\xbc'}, 3, 0xC63C}, /* (HANGUL SYLLABLE OK) */
    {{'\xec', '\x98', '\xbd'}, 3, 0xC63D}, /* (HANGUL SYLLABLE OT) */
    {{'\xec', '\x98', '\xbe'}, 3, 0xC63E}, /* (HANGUL SYLLABLE OP) */
    {{'\xec', '\x98', '\xbf'}, 3, 0xC63F}, /* (HANGUL SYLLABLE OH) */
    {{'\xec', '\x99', '\x82'}, 3, 0xC642}, /* (HANGUL SYLLABLE WAGG) */
    {{'\xec', '\x99', '\x83'}, 3, 0xC643}, /* (HANGUL SYLLABLE WAGS) */
    {{'\xec', '\x99', '\x85'}, 3, 0xC645}, /* (HANGUL SYLLABLE WANJ) */
    {{'\xec', '\x99', '\x86'}, 3, 0xC646}, /* (HANGUL SYLLABLE WANH) */
    {{'\xec', '\x99', '\x87'}, 3, 0xC647}, /* (HANGUL SYLLABLE WAD) */
    {{'\xec', '\x99', '\x89'}, 3, 0xC649}, /* (HANGUL SYLLABLE WALG) */
    {{'\xec', '\x99', '\x8a'}, 3, 0xC64A}, /* (HANGUL SYLLABLE WALM) */
    {{'\xec', '\x99', '\x8b'}, 3, 0xC64B}, /* (HANGUL SYLLABLE WALB) */
    {{'\xec', '\x99', '\x8c'}, 3, 0xC64C}, /* (HANGUL SYLLABLE WALS) */
    {{'\xec', '\x99', '\x8d'}, 3, 0xC64D}, /* (HANGUL SYLLABLE WALT) */
    {{'\xec', '\x99', '\x8e'}, 3, 0xC64E}, /* (HANGUL SYLLABLE WALP) */
    {{'\xec', '\x99', '\x8f'}, 3, 0xC64F}, /* (HANGUL SYLLABLE WALH) */
    {{'\xec', '\x99', '\x92'}, 3, 0xC652}, /* (HANGUL SYLLABLE WABS) */
    {{'\xec', '\x99', '\x96'}, 3, 0xC656}, /* (HANGUL SYLLABLE WAJ) */
    {{'\xec', '\x99', '\x97'}, 3, 0xC657}, /* (HANGUL SYLLABLE WAC) */
    {{'\xec', '\x99', '\x98'}, 3, 0xC658}, /* (HANGUL SYLLABLE WAK) */
    {{'\xec', '\x99', '\x99'}, 3, 0xC659}, /* (HANGUL SYLLABLE WAT) */
    {{'\xec', '\x99', '\x9a'}, 3, 0xC65A}, /* (HANGUL SYLLABLE WAP) */
    {{'\xec', '\x99', '\x9b'}, 3, 0xC65B}, /* (HANGUL SYLLABLE WAH) */
    {{'\xec', '\x99', '\x9e'}, 3, 0xC65E}, /* (HANGUL SYLLABLE WAEGG) */
    {{'\xec', '\x99', '\x9f'}, 3, 0xC65F}, /* (HANGUL SYLLABLE WAEGS) */
    {{'\xec', '\x99', '\xa1'}, 3, 0xC661}, /* (HANGUL SYLLABLE WAENJ) */
    {{'\xec', '\x99', '\xa2'}, 3, 0xC662}, /* (HANGUL SYLLABLE WAENH) */
    {{'\xec', '\x99', '\xa3'}, 3, 0xC663}, /* (HANGUL SYLLABLE WAED) */
    {{'\xec', '\x99', '\xa4'}, 3, 0xC664}, /* (HANGUL SYLLABLE WAEL) */
    {{'\xec', '\x99', '\xa5'}, 3, 0xC665}, /* (HANGUL SYLLABLE WAELG) */
    {{'\xec', '\x99', '\xa6'}, 3, 0xC666}, /* (HANGUL SYLLABLE WAELM) */
    {{'\xec', '\x99', '\xa7'}, 3, 0xC667}, /* (HANGUL SYLLABLE WAELB) */
    {{'\xec', '\x99', '\xa8'}, 3, 0xC668}, /* (HANGUL SYLLABLE WAELS) */
    {{'\xec', '\x99', '\xa9'}, 3, 0xC669}, /* (HANGUL SYLLABLE WAELT) */
    {{'\xec', '\x99', '\xaa'}, 3, 0xC66A}, /* (HANGUL SYLLABLE WAELP) */
    {{'\xec', '\x99', '\xab'}, 3, 0xC66B}, /* (HANGUL SYLLABLE WAELH) */
    {{'\xec', '\x99', '\xad'}, 3, 0xC66D}, /* (HANGUL SYLLABLE WAEB) */
    {{'\xec', '\x99', '\xae'}, 3, 0xC66E}, /* (HANGUL SYLLABLE WAEBS) */
    {{'\xec', '\x99', '\xb0'}, 3, 0xC670}, /* (HANGUL SYLLABLE WAESS) */
    {{'\xec', '\x99', '\xb2'}, 3, 0xC672}, /* (HANGUL SYLLABLE WAEJ) */
    {{'\xec', '\x99', '\xb3'}, 3, 0xC673}, /* (HANGUL SYLLABLE WAEC) */
    {{'\xec', '\x99', '\xb4'}, 3, 0xC674}, /* (HANGUL SYLLABLE WAEK) */
    {{'\xec', '\x99', '\xb5'}, 3, 0xC675}, /* (HANGUL SYLLABLE WAET) */
    {{'\xec', '\x99', '\xb6'}, 3, 0xC676}, /* (HANGUL SYLLABLE WAEP) */
    {{'\xec', '\x99', '\xb7'}, 3, 0xC677}, /* (HANGUL SYLLABLE WAEH) */
    {{'\xec', '\x99', '\xba'}, 3, 0xC67A}, /* (HANGUL SYLLABLE OEGG) */
    {{'\xec', '\x99', '\xbb'}, 3, 0xC67B}, /* (HANGUL SYLLABLE OEGS) */
    {{'\xec', '\x99', '\xbd'}, 3, 0xC67D}, /* (HANGUL SYLLABLE OENJ) */
    {{'\xec', '\x99', '\xbe'}, 3, 0xC67E}, /* (HANGUL SYLLABLE OENH) */
    {{'\xec', '\x99', '\xbf'}, 3, 0xC67F}, /* (HANGUL SYLLABLE OED) */
    {{'\xec', '\x9a', '\x81'}, 3, 0xC681}, /* (HANGUL SYLLABLE OELG) */
    {{'\xec', '\x9a', '\x82'}, 3, 0xC682}, /* (HANGUL SYLLABLE OELM) */
    {{'\xec', '\x9a', '\x83'}, 3, 0xC683}, /* (HANGUL SYLLABLE OELB) */
    {{'\xec', '\x9a', '\x84'}, 3, 0xC684}, /* (HANGUL SYLLABLE OELS) */
    {{'\xec', '\x9a', '\x85'}, 3, 0xC685}, /* (HANGUL SYLLABLE OELT) */
    {{'\xec', '\x9a', '\x86'}, 3, 0xC686}, /* (HANGUL SYLLABLE OELP) */
    {{'\xec', '\x9a', '\x87'}, 3, 0xC687}, /* (HANGUL SYLLABLE OELH) */
    {{'\xec', '\x9a', '\x8a'}, 3, 0xC68A}, /* (HANGUL SYLLABLE OEBS) */
    {{'\xec', '\x9a', '\x8c'}, 3, 0xC68C}, /* (HANGUL SYLLABLE OESS) */
    {{'\xec', '\x9a', '\x8e'}, 3, 0xC68E}, /* (HANGUL SYLLABLE OEJ) */
    {{'\xec', '\x9a', '\x8f'}, 3, 0xC68F}, /* (HANGUL SYLLABLE OEC) */
    {{'\xec', '\x9a', '\x90'}, 3, 0xC690}, /* (HANGUL SYLLABLE OEK) */
    {{'\xec', '\x9a', '\x91'}, 3, 0xC691}, /* (HANGUL SYLLABLE OET) */
    {{'\xec', '\x9a', '\x92'}, 3, 0xC692}, /* (HANGUL SYLLABLE OEP) */
    {{'\xec', '\x9a', '\x93'}, 3, 0xC693}, /* (HANGUL SYLLABLE OEH) */
    {{'\xec', '\x9a', '\x96'}, 3, 0xC696}, /* (HANGUL SYLLABLE YOGG) */
    {{'\xec', '\x9a', '\x97'}, 3, 0xC697}, /* (HANGUL SYLLABLE YOGS) */
    {{'\xec', '\x9a', '\x99'}, 3, 0xC699}, /* (HANGUL SYLLABLE YONJ) */
    {{'\xec', '\x9a', '\x9a'}, 3, 0xC69A}, /* (HANGUL SYLLABLE YONH) */
    {{'\xec', '\x9a', '\x9b'}, 3, 0xC69B}, /* (HANGUL SYLLABLE YOD) */
    {{'\xec', '\x9a', '\x9d'}, 3, 0xC69D}, /* (HANGUL SYLLABLE YOLG) */
    {{'\xec', '\x9a', '\x9e'}, 3, 0xC69E}, /* (HANGUL SYLLABLE YOLM) */
    {{'\xec', '\x9a', '\x9f'}, 3, 0xC69F}, /* (HANGUL SYLLABLE YOLB) */
    {{'\xec', '\x9a', '\xa0'}, 3, 0xC6A0}, /* (HANGUL SYLLABLE YOLS) */
    {{'\xec', '\x9a', '\xa1'}, 3, 0xC6A1}, /* (HANGUL SYLLABLE YOLT) */
    {{'\xec', '\x9a', '\xa2'}, 3, 0xC6A2}, /* (HANGUL SYLLABLE YOLP) */
    {{'\xec', '\x9a', '\xa3'}, 3, 0xC6A3}, /* (HANGUL SYLLABLE YOLH) */
    {{'\xec', '\x9a', '\xa6'}, 3, 0xC6A6}, /* (HANGUL SYLLABLE YOBS) */
    {{'\xec', '\x9a', '\xa8'}, 3, 0xC6A8}, /* (HANGUL SYLLABLE YOSS) */
    {{'\xec', '\x9a', '\xaa'}, 3, 0xC6AA}, /* (HANGUL SYLLABLE YOJ) */
    {{'\xec', '\x9a', '\xab'}, 3, 0xC6AB}, /* (HANGUL SYLLABLE YOC) */
    {{'\xec', '\x9a', '\xac'}, 3, 0xC6AC}, /* (HANGUL SYLLABLE YOK) */
    {{'\xec', '\x9a', '\xad'}, 3, 0xC6AD}, /* (HANGUL SYLLABLE YOT) */
    {{'\xec', '\x9a', '\xae'}, 3, 0xC6AE}, /* (HANGUL SYLLABLE YOP) */
    {{'\xec', '\x9a', '\xaf'}, 3, 0xC6AF}, /* (HANGUL SYLLABLE YOH) */
    {{'\xec', '\x9a', '\xb2'}, 3, 0xC6B2}, /* (HANGUL SYLLABLE UGG) */
    {{'\xec', '\x9a', '\xb3'}, 3, 0xC6B3}, /* (HANGUL SYLLABLE UGS) */
    {{'\xec', '\x9a', '\xb5'}, 3, 0xC6B5}, /* (HANGUL SYLLABLE UNJ) */
    {{'\xec', '\x9a', '\xb6'}, 3, 0xC6B6}, /* (HANGUL SYLLABLE UNH) */
    {{'\xec', '\x9a', '\xb7'}, 3, 0xC6B7}, /* (HANGUL SYLLABLE UD) */
    {{'\xec', '\x9a', '\xbb'}, 3, 0xC6BB}, /* (HANGUL SYLLABLE ULB) */
    {{'\xec', '\x9a', '\xbc'}, 3, 0xC6BC}, /* (HANGUL SYLLABLE ULS) */
    {{'\xec', '\x9a', '\xbd'}, 3, 0xC6BD}, /* (HANGUL SYLLABLE ULT) */
    {{'\xec', '\x9a', '\xbe'}, 3, 0xC6BE}, /* (HANGUL SYLLABLE ULP) */
    {{'\xec', '\x9a', '\xbf'}, 3, 0xC6BF}, /* (HANGUL SYLLABLE ULH) */
    {{'\xec', '\x9b', '\x82'}, 3, 0xC6C2}, /* (HANGUL SYLLABLE UBS) */
    {{'\xec', '\x9b', '\x84'}, 3, 0xC6C4}, /* (HANGUL SYLLABLE USS) */
    {{'\xec', '\x9b', '\x86'}, 3, 0xC6C6}, /* (HANGUL SYLLABLE UJ) */
    {{'\xec', '\x9b', '\x87'}, 3, 0xC6C7}, /* (HANGUL SYLLABLE UC) */
    {{'\xec', '\x9b', '\x88'}, 3, 0xC6C8}, /* (HANGUL SYLLABLE UK) */
    {{'\xec', '\x9b', '\x89'}, 3, 0xC6C9}, /* (HANGUL SYLLABLE UT) */
    {{'\xec', '\x9b', '\x8a'}, 3, 0xC6CA}, /* (HANGUL SYLLABLE UP) */
    {{'\xec', '\x9b', '\x8b'}, 3, 0xC6CB}, /* (HANGUL SYLLABLE UH) */
    {{'\xec', '\x9b', '\x8e'}, 3, 0xC6CE}, /* (HANGUL SYLLABLE WEOGG) */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{'\xec', '\x9b', '\x8f'}, 3, 0xC6CF}, /* (HANGUL SYLLABLE WEOGS) */
    {{'\xec', '\x9b', '\x91'}, 3, 0xC6D1}, /* (HANGUL SYLLABLE WEONJ) */
    {{'\xec', '\x9b', '\x92'}, 3, 0xC6D2}, /* (HANGUL SYLLABLE WEONH) */
    {{'\xec', '\x9b', '\x93'}, 3, 0xC6D3}, /* (HANGUL SYLLABLE WEOD) */
    {{'\xec', '\x9b', '\x95'}, 3, 0xC6D5}, /* (HANGUL SYLLABLE WEOLG) */
    {{'\xec', '\x9b', '\x96'}, 3, 0xC6D6}, /* (HANGUL SYLLABLE WEOLM) */
    {{'\xec', '\x9b', '\x97'}, 3, 0xC6D7}, /* (HANGUL SYLLABLE WEOLB) */
    {{'\xec', '\x9b', '\x98'}, 3, 0xC6D8}, /* (HANGUL SYLLABLE WEOLS) */
    {{'\xec', '\x9b', '\x99'}, 3, 0xC6D9}, /* (HANGUL SYLLABLE WEOLT) */
    {{'\xec', '\x9b', '\x9a'}, 3, 0xC6DA}, /* (HANGUL SYLLABLE WEOLP) */
    {{'\xec', '\x9b', '\x9b'}, 3, 0xC6DB}, /* (HANGUL SYLLABLE WEOLH) */
    {{'\xec', '\x9b', '\x9e'}, 3, 0xC6DE}, /* (HANGUL SYLLABLE WEOBS) */
    {{'\xec', '\x9b', '\x9f'}, 3, 0xC6DF}, /* (HANGUL SYLLABLE WEOS) */
    {{'\xec', '\x9b', '\xa2'}, 3, 0xC6E2}, /* (HANGUL SYLLABLE WEOJ) */
    {{'\xec', '\x9b', '\xa3'}, 3, 0xC6E3}, /* (HANGUL SYLLABLE WEOC) */
    {{'\xec', '\x9b', '\xa4'}, 3, 0xC6E4}, /* (HANGUL SYLLABLE WEOK) */
    {{'\xec', '\x9b', '\xa5'}, 3, 0xC6E5}, /* (HANGUL SYLLABLE WEOT) */
    {{'\xec', '\x9b', '\xa6'}, 3, 0xC6E6}, /* (HANGUL SYLLABLE WEOP) */
    {{'\xec', '\x9b', '\xa7'}, 3, 0xC6E7}, /* (HANGUL SYLLABLE WEOH) */
    {{'\xec', '\x9b', '\xaa'}, 3, 0xC6EA}, /* (HANGUL SYLLABLE WEGG) */
    {{'\xec', '\x9b', '\xab'}, 3, 0xC6EB}, /* (HANGUL SYLLABLE WEGS) */
    {{'\xec', '\x9b', '\xad'}, 3, 0xC6ED}, /* (HANGUL SYLLABLE WENJ) */
    {{'\xec', '\x9b', '\xae'}, 3, 0xC6EE}, /* (HANGUL SYLLABLE WENH) */
    {{'\xec', '\x9b', '\xaf'}, 3, 0xC6EF}, /* (HANGUL SYLLABLE WED) */
    {{'\xec', '\x9b', '\xb1'}, 3, 0xC6F1}, /* (HANGUL SYLLABLE WELG) */
    {{'\xec', '\x9b', '\xb2'}, 3, 0xC6F2}, /* (HANGUL SYLLABLE WELM) */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{'\xec', '\x9b', '\xb3'}, 3, 0xC6F3}, /* (HANGUL SYLLABLE WELB) */
    {{'\xec', '\x9b', '\xb4'}, 3, 0xC6F4}, /* (HANGUL SYLLABLE WELS) */
    {{'\xec', '\x9b', '\xb5'}, 3, 0xC6F5}, /* (HANGUL SYLLABLE WELT) */
    {{'\xec', '\x9b', '\xb6'}, 3, 0xC6F6}, /* (HANGUL SYLLABLE WELP) */
    {{'\xec', '\x9b', '\xb7'}, 3, 0xC6F7}, /* (HANGUL SYLLABLE WELH) */
    {{'\xec', '\x9b', '\xba'}, 3, 0xC6FA}, /* (HANGUL SYLLABLE WEBS) */
    {{'\xec', '\x9b', '\xbb'}, 3, 0xC6FB}, /* (HANGUL SYLLABLE WES) */
    {{'\xec', '\x9b', '\xbc'}, 3, 0xC6FC}, /* (HANGUL SYLLABLE WESS) */
    {{'\xec', '\x9b', '\xbe'}, 3, 0xC6FE}, /* (HANGUL SYLLABLE WEJ) */
    {{'\xec', '\x9b', '\xbf'}, 3, 0xC6FF}, /* (HANGUL SYLLABLE WEC) */
    {{'\xec', '\x9c', '\x80'}, 3, 0xC700}, /* (HANGUL SYLLABLE WEK) */
    {{'\xec', '\x9c', '\x81'}, 3, 0xC701}, /* (HANGUL SYLLABLE WET) */
    {{'\xec', '\x9c', '\x82'}, 3, 0xC702}, /* (HANGUL SYLLABLE WEP) */
    {{'\xec', '\x9c', '\x83'}, 3, 0xC703}, /* (HANGUL SYLLABLE WEH) */
    {{'\xec', '\x9c', '\x86'}, 3, 0xC706}, /* (HANGUL SYLLABLE WIGG) */
    {{'\xec', '\x9c', '\x87'}, 3, 0xC707}, /* (HANGUL SYLLABLE WIGS) */
    {{'\xec', '\x9c', '\x89'}, 3, 0xC709}, /* (HANGUL SYLLABLE WINJ) */
    {{'\xec', '\x9c', '\x8a'}, 3, 0xC70A}, /* (HANGUL SYLLABLE WINH) */
    {{'\xec', '\x9c', '\x8b'}, 3, 0xC70B}, /* (HANGUL SYLLABLE WID) */
    {{'\xec', '\x9c', '\x8d'}, 3, 0xC70D}, /* (HANGUL SYLLABLE WILG) */
    {{'\xec', '\x9c', '\x8e'}, 3, 0xC70E}, /* (HANGUL SYLLABLE WILM) */
    {{'\xec', '\x9c', '\x8f'}, 3, 0xC70F}, /* (HANGUL SYLLABLE WILB) */
    {{'\xec', '\x9c', '\x90'}, 3, 0xC710}, /* (HANGUL SYLLABLE WILS) */
    {{'\xec', '\x9c', '\x91'}, 3, 0xC711}, /* (HANGUL SYLLABLE WILT) */
    {{'\xec', '\x9c', '\x92'}, 3, 0xC712}, /* (HANGUL SYLLABLE WILP) */
    {{'\xec', '\x9c', '\x93'}, 3, 0xC713}, /* (HANGUL SYLLABLE WILH) */
    {{'\xec', '\x9c', '\x96'}, 3, 0xC716}, /* (HANGUL SYLLABLE WIBS) */
    {{'\xec', '\x9c', '\x98'}, 3, 0xC718}, /* (HANGUL SYLLABLE WISS) */
    {{'\xec', '\x9c', '\x9a'}, 3, 0xC71A}, /* (HANGUL SYLLABLE WIJ) */
    {{'\xec', '\x9c', '\x9b'}, 3, 0xC71B}, /* (HANGUL SYLLABLE WIC) */
    {{'\xec', '\x9c', '\x9c'}, 3, 0xC71C}, /* (HANGUL SYLLABLE WIK) */
    {{'\xec', '\x9c', '\x9d'}, 3, 0xC71D}, /* (HANGUL SYLLABLE WIT) */
    {{'\xec', '\x9c', '\x9e'}, 3, 0xC71E}, /* (HANGUL SYLLABLE WIP) */
    {{'\xec', '\x9c', '\x9f'}, 3, 0xC71F}, /* (HANGUL SYLLABLE WIH) */
    {{'\xec', '\x9c', '\xa2'}, 3, 0xC722}, /* (HANGUL SYLLABLE YUGG) */
    {{'\xec', '\x9c', '\xa3'}, 3, 0xC723}, /* (HANGUL SYLLABLE YUGS) */
    {{'\xec', '\x9c', '\xa5'}, 3, 0xC725}, /* (HANGUL SYLLABLE YUNJ) */
    {{'\xec', '\x9c', '\xa6'}, 3, 0xC726}, /* (HANGUL SYLLABLE YUNH) */
    {{'\xec', '\x9c', '\xa7'}, 3, 0xC727}, /* (HANGUL SYLLABLE YUD) */
    {{'\xec', '\x9c', '\xa9'}, 3, 0xC729}, /* (HANGUL SYLLABLE YULG) */
    {{'\xec', '\x9c', '\xaa'}, 3, 0xC72A}, /* (HANGUL SYLLABLE YULM) */
    {{'\xec', '\x9c', '\xab'}, 3, 0xC72B}, /* (HANGUL SYLLABLE YULB) */
    {{'\xec', '\x9c', '\xac'}, 3, 0xC72C}, /* (HANGUL SYLLABLE YULS) */
    {{'\xec', '\x9c', '\xad'}, 3, 0xC72D}, /* (HANGUL SYLLABLE YULT) */
    {{'\xec', '\x9c', '\xae'}, 3, 0xC72E}, /* (HANGUL SYLLABLE YULP) */
    {{'\xec', '\x9c', '\xaf'}, 3, 0xC72F}, /* (HANGUL SYLLABLE YULH) */
    {{'\xec', '\x9c', '\xb2'}, 3, 0xC732}, /* (HANGUL SYLLABLE YUBS) */
    {{'\xec', '\x9c', '\xb4'}, 3, 0xC734}, /* (HANGUL SYLLABLE YUSS) */
    {{'\xec', '\x9c', '\xb6'}, 3, 0xC736}, /* (HANGUL SYLLABLE YUJ) */
    {{'\xec', '\x9c', '\xb8'}, 3, 0xC738}, /* (HANGUL SYLLABLE YUK) */
    {{'\xec', '\x9c', '\xb9'}, 3, 0xC739}, /* (HANGUL SYLLABLE YUT) */
    {{'\xec', '\x9c', '\xba'}, 3, 0xC73A}, /* (HANGUL SYLLABLE YUP) */
    {{'\xec', '\x9c', '\xbb'}, 3, 0xC73B}, /* (HANGUL SYLLABLE YUH) */
    {{'\xec', '\x9c', '\xbe'}, 3, 0xC73E}, /* (HANGUL SYLLABLE EUGG) */
    {{'\xec', '\x9c', '\xbf'}, 3, 0xC73F}, /* (HANGUL SYLLABLE EUGS) */
    {{'\xec', '\x9d', '\x81'}, 3, 0xC741}, /* (HANGUL SYLLABLE EUNJ) */
    {{'\xec', '\x9d', '\x82'}, 3, 0xC742}, /* (HANGUL SYLLABLE EUNH) */
    {{'\xec', '\x9d', '\x83'}, 3, 0xC743}, /* (HANGUL SYLLABLE EUD) */
    {{'\xec', '\x9d', '\x85'}, 3, 0xC745}, /* (HANGUL SYLLABLE EULG) */
    {{'\xec', '\x9d', '\x86'}, 3, 0xC746}, /* (HANGUL SYLLABLE EULM) */
    {{'\xec', '\x9d', '\x87'}, 3, 0xC747}, /* (HANGUL SYLLABLE EULB) */
    {{'\xec', '\x9d', '\x88'}, 3, 0xC748}, /* (HANGUL SYLLABLE EULS) */
    {{'\xec', '\x9d', '\x89'}, 3, 0xC749}, /* (HANGUL SYLLABLE EULT) */
    {{'\xec', '\x9d', '\x8b'}, 3, 0xC74B}, /* (HANGUL SYLLABLE EULH) */
    {{'\xec', '\x9d', '\x8e'}, 3, 0xC74E}, /* (HANGUL SYLLABLE EUBS) */
    {{'\xec', '\x9d', '\x90'}, 3, 0xC750}, /* (HANGUL SYLLABLE EUSS) */
    {{'\xec', '\x9d', '\x99'}, 3, 0xC759}, /* (HANGUL SYLLABLE YIG) */
    {{'\xec', '\x9d', '\x9a'}, 3, 0xC75A}, /* (HANGUL SYLLABLE YIGG) */
    {{'\xec', '\x9d', '\x9b'}, 3, 0xC75B}, /* (HANGUL SYLLABLE YIGS) */
    {{'\xec', '\x9d', '\x9d'}, 3, 0xC75D}, /* (HANGUL SYLLABLE YINJ) */
    {{'\xec', '\x9d', '\x9e'}, 3, 0xC75E}, /* (HANGUL SYLLABLE YINH) */
    {{'\xec', '\x9d', '\x9f'}, 3, 0xC75F}, /* (HANGUL SYLLABLE YID) */
    {{'\xec', '\x9d', '\xa1'}, 3, 0xC761}, /* (HANGUL SYLLABLE YILG) */
    {{'\xec', '\x9d', '\xa2'}, 3, 0xC762}, /* (HANGUL SYLLABLE YILM) */
    {{'\xec', '\x9d', '\xa3'}, 3, 0xC763}, /* (HANGUL SYLLABLE YILB) */
    {{'\xec', '\x9d', '\xa4'}, 3, 0xC764}, /* (HANGUL SYLLABLE YILS) */
    {{'\xec', '\x9d', '\xa5'}, 3, 0xC765}, /* (HANGUL SYLLABLE YILT) */
    {{'\xec', '\x9d', '\xa6'}, 3, 0xC766}, /* (HANGUL SYLLABLE YILP) */
    {{'\xec', '\x9d', '\xa7'}, 3, 0xC767}, /* (HANGUL SYLLABLE YILH) */
    {{'\xec', '\x9d', '\xa9'}, 3, 0xC769}, /* (HANGUL SYLLABLE YIB) */
    {{'\xec', '\x9d', '\xaa'}, 3, 0xC76A}, /* (HANGUL SYLLABLE YIBS) */
    {{'\xec', '\x9d', '\xac'}, 3, 0xC76C}, /* (HANGUL SYLLABLE YISS) */
    {{'\xec', '\x9d', '\xad'}, 3, 0xC76D}, /* (HANGUL SYLLABLE YING) */
    {{'\xec', '\x9d', '\xae'}, 3, 0xC76E}, /* (HANGUL SYLLABLE YIJ) */
    {{'\xec', '\x9d', '\xaf'}, 3, 0xC76F}, /* (HANGUL SYLLABLE YIC) */
    {{'\xec', '\x9d', '\xb0'}, 3, 0xC770}, /* (HANGUL SYLLABLE YIK) */
    {{'\xec', '\x9d', '\xb1'}, 3, 0xC771}, /* (HANGUL SYLLABLE YIT) */
    {{'\xec', '\x9d', '\xb2'}, 3, 0xC772}, /* (HANGUL SYLLABLE YIP) */
    {{'\xec', '\x9d', '\xb3'}, 3, 0xC773}, /* (HANGUL SYLLABLE YIH) */
    {{'\xec', '\x9d', '\xb6'}, 3, 0xC776}, /* (HANGUL SYLLABLE IGG) */
    {{'\xec', '\x9d', '\xb7'}, 3, 0xC777}, /* (HANGUL SYLLABLE IGS) */
    {{'\xec', '\x9d', '\xb9'}, 3, 0xC779}, /* (HANGUL SYLLABLE INJ) */
    {{'\xec', '\x9d', '\xba'}, 3, 0xC77A}, /* (HANGUL SYLLABLE INH) */
    {{'\xec', '\x9d', '\xbb'}, 3, 0xC77B}, /* (HANGUL SYLLABLE ID) */
    {{'\xec', '\x9d', '\xbf'}, 3, 0xC77F}, /* (HANGUL SYLLABLE ILB) */
    {{'\xec', '\x9e', '\x80'}, 3, 0xC780}, /* (HANGUL SYLLABLE ILS) */
    {{'\xec', '\x9e', '\x81'}, 3, 0xC781}, /* (HANGUL SYLLABLE ILT) */
    {{'\xec', '\x9e', '\x82'}, 3, 0xC782}, /* (HANGUL SYLLABLE ILP) */
    {{'\xec', '\x9e', '\x86'}, 3, 0xC786}, /* (HANGUL SYLLABLE IBS) */
    {{'\xec', '\x9e', '\x8b'}, 3, 0xC78B}, /* (HANGUL SYLLABLE IC) */
    {{'\xec', '\x9e', '\x8c'}, 3, 0xC78C}, /* (HANGUL SYLLABLE IK) */
    {{'\xec', '\x9e', '\x8d'}, 3, 0xC78D}, /* (HANGUL SYLLABLE IT) */
    {{'\xec', '\x9e', '\x8f'}, 3, 0xC78F}, /* (HANGUL SYLLABLE IH) */
    {{'\xec', '\x9e', '\x92'}, 3, 0xC792}, /* (HANGUL SYLLABLE JAGG) */
    {{'\xec', '\x9e', '\x93'}, 3, 0xC793}, /* (HANGUL SYLLABLE JAGS) */
    {{'\xec', '\x9e', '\x95'}, 3, 0xC795}, /* (HANGUL SYLLABLE JANJ) */
    {{'\xec', '\x9e', '\x99'}, 3, 0xC799}, /* (HANGUL SYLLABLE JALG) */
    {{'\xec', '\x9e', '\x9b'}, 3, 0xC79B}, /* (HANGUL SYLLABLE JALB) */
    {{'\xec', '\x9e', '\x9c'}, 3, 0xC79C}, /* (HANGUL SYLLABLE JALS) */
    {{'\xec', '\x9e', '\x9d'}, 3, 0xC79D}, /* (HANGUL SYLLABLE JALT) */
    {{'\xec', '\x9e', '\x9e'}, 3, 0xC79E}, /* (HANGUL SYLLABLE JALP) */
    {{'\xec', '\x9e', '\x9f'}, 3, 0xC79F}, /* (HANGUL SYLLABLE JALH) */
    {{'\xec', '\x9e', '\xa2'}, 3, 0xC7A2}, /* (HANGUL SYLLABLE JABS) */
    {{'\xec', '\x9e', '\xa7'}, 3, 0xC7A7}, /* (HANGUL SYLLABLE JAC) */
    {{'\xec', '\x9e', '\xa8'}, 3, 0xC7A8}, /* (HANGUL SYLLABLE JAK) */
    {{'\xec', '\x9e', '\xa9'}, 3, 0xC7A9}, /* (HANGUL SYLLABLE JAT) */
    {{'\xec', '\x9e', '\xaa'}, 3, 0xC7AA}, /* (HANGUL SYLLABLE JAP) */
    {{'\xec', '\x9e', '\xab'}, 3, 0xC7AB}, /* (HANGUL SYLLABLE JAH) */
    {{'\xec', '\x9e', '\xae'}, 3, 0xC7AE}, /* (HANGUL SYLLABLE JAEGG) */
    {{'\xec', '\x9e', '\xaf'}, 3, 0xC7AF}, /* (HANGUL SYLLABLE JAEGS) */
    {{'\xec', '\x9e', '\xb1'}, 3, 0xC7B1}, /* (HANGUL SYLLABLE JAENJ) */
    {{'\xec', '\x9e', '\xb2'}, 3, 0xC7B2}, /* (HANGUL SYLLABLE JAENH) */
    {{'\xec', '\x9e', '\xb3'}, 3, 0xC7B3}, /* (HANGUL SYLLABLE JAED) */
    {{'\xec', '\x9e', '\xb5'}, 3, 0xC7B5}, /* (HANGUL SYLLABLE JAELG) */
    {{'\xec', '\x9e', '\xb6'}, 3, 0xC7B6}, /* (HANGUL SYLLABLE JAELM) */
    {{'\xec', '\x9e', '\xb7'}, 3, 0xC7B7}, /* (HANGUL SYLLABLE JAELB) */
    {{'\xec', '\x9e', '\xb8'}, 3, 0xC7B8}, /* (HANGUL SYLLABLE JAELS) */
    {{'\xec', '\x9e', '\xb9'}, 3, 0xC7B9}, /* (HANGUL SYLLABLE JAELT) */
    {{'\xec', '\x9e', '\xba'}, 3, 0xC7BA}, /* (HANGUL SYLLABLE JAELP) */
    {{'\xec', '\x9e', '\xbb'}, 3, 0xC7BB}, /* (HANGUL SYLLABLE JAELH) */
    {{'\xec', '\x9e', '\xbe'}, 3, 0xC7BE}, /* (HANGUL SYLLABLE JAEBS) */
    {{'\xec', '\x9f', '\x82'}, 3, 0xC7C2}, /* (HANGUL SYLLABLE JAEJ) */
    {{'\xec', '\x9f', '\x83'}, 3, 0xC7C3}, /* (HANGUL SYLLABLE JAEC) */
    {{'\xec', '\x9f', '\x84'}, 3, 0xC7C4}, /* (HANGUL SYLLABLE JAEK) */
    {{'\xec', '\x9f', '\x85'}, 3, 0xC7C5}, /* (HANGUL SYLLABLE JAET) */
    {{'\xec', '\x9f', '\x86'}, 3, 0xC7C6}, /* (HANGUL SYLLABLE JAEP) */
    {{'\xec', '\x9f', '\x87'}, 3, 0xC7C7}, /* (HANGUL SYLLABLE JAEH) */
    {{'\xec', '\x9f', '\x8a'}, 3, 0xC7CA}, /* (HANGUL SYLLABLE JYAGG) */
    {{'\xec', '\x9f', '\x8b'}, 3, 0xC7CB}, /* (HANGUL SYLLABLE JYAGS) */
    {{'\xec', '\x9f', '\x8d'}, 3, 0xC7CD}, /* (HANGUL SYLLABLE JYANJ) */
    {{'\xec', '\x9f', '\x8f'}, 3, 0xC7CF}, /* (HANGUL SYLLABLE JYAD) */
    {{'\xec', '\x9f', '\x91'}, 3, 0xC7D1}, /* (HANGUL SYLLABLE JYALG) */
    {{'\xec', '\x9f', '\x92'}, 3, 0xC7D2}, /* (HANGUL SYLLABLE JYALM) */
    {{'\xec', '\x9f', '\x93'}, 3, 0xC7D3}, /* (HANGUL SYLLABLE JYALB) */
    {{'\xec', '\x9f', '\x94'}, 3, 0xC7D4}, /* (HANGUL SYLLABLE JYALS) */
    {{'\xec', '\x9f', '\x95'}, 3, 0xC7D5}, /* (HANGUL SYLLABLE JYALT) */
    {{'\xec', '\x9f', '\x96'}, 3, 0xC7D6}, /* (HANGUL SYLLABLE JYALP) */
    {{'\xec', '\x9f', '\x97'}, 3, 0xC7D7}, /* (HANGUL SYLLABLE JYALH) */
    {{'\xec', '\x9f', '\x99'}, 3, 0xC7D9}, /* (HANGUL SYLLABLE JYAB) */
    {{'\xec', '\x9f', '\x9a'}, 3, 0xC7DA}, /* (HANGUL SYLLABLE JYABS) */
    {{'\xec', '\x9f', '\x9b'}, 3, 0xC7DB}, /* (HANGUL SYLLABLE JYAS) */
    {{'\xec', '\x9f', '\x9c'}, 3, 0xC7DC}, /* (HANGUL SYLLABLE JYASS) */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{'\xec', '\x9f', '\x9e'}, 3, 0xC7DE}, /* (HANGUL SYLLABLE JYAJ) */
    {{'\xec', '\x9f', '\x9f'}, 3, 0xC7DF}, /* (HANGUL SYLLABLE JYAC) */
    {{'\xec', '\x9f', '\xa0'}, 3, 0xC7E0}, /* (HANGUL SYLLABLE JYAK) */
    {{'\xec', '\x9f', '\xa1'}, 3, 0xC7E1}, /* (HANGUL SYLLABLE JYAT) */
    {{'\xec', '\x9f', '\xa2'}, 3, 0xC7E2}, /* (HANGUL SYLLABLE JYAP) */
    {{'\xec', '\x9f', '\xa3'}, 3, 0xC7E3}, /* (HANGUL SYLLABLE JYAH) */
    {{'\xec', '\x9f', '\xa5'}, 3, 0xC7E5}, /* (HANGUL SYLLABLE JYAEG) */
    {{'\xec', '\x9f', '\xa6'}, 3, 0xC7E6}, /* (HANGUL SYLLABLE JYAEGG) */
    {{'\xec', '\x9f', '\xa7'}, 3, 0xC7E7}, /* (HANGUL SYLLABLE JYAEGS) */
    {{'\xec', '\x9f', '\xa9'}, 3, 0xC7E9}, /* (HANGUL SYLLABLE JYAENJ) */
    {{'\xec', '\x9f', '\xaa'}, 3, 0xC7EA}, /* (HANGUL SYLLABLE JYAENH) */
    {{'\xec', '\x9f', '\xab'}, 3, 0xC7EB}, /* (HANGUL SYLLABLE JYAED) */
    {{'\xec', '\x9f', '\xad'}, 3, 0xC7ED}, /* (HANGUL SYLLABLE JYAELG) */
    {{'\xec', '\x9f', '\xae'}, 3, 0xC7EE}, /* (HANGUL SYLLABLE JYAELM) */
    {{'\xec', '\x9f', '\xaf'}, 3, 0xC7EF}, /* (HANGUL SYLLABLE JYAELB) */
    {{'\xec', '\x9f', '\xb0'}, 3, 0xC7F0}, /* (HANGUL SYLLABLE JYAELS) */
    {{'\xec', '\x9f', '\xb1'}, 3, 0xC7F1}, /* (HANGUL SYLLABLE JYAELT) */
    {{'\xec', '\x9f', '\xb2'}, 3, 0xC7F2}, /* (HANGUL SYLLABLE JYAELP) */
    {{'\xec', '\x9f', '\xb3'}, 3, 0xC7F3}, /* (HANGUL SYLLABLE JYAELH) */
    {{'\xec', '\x9f', '\xb4'}, 3, 0xC7F4}, /* (HANGUL SYLLABLE JYAEM) */
    {{'\xec', '\x9f', '\xb5'}, 3, 0xC7F5}, /* (HANGUL SYLLABLE JYAEB) */
    {{'\xec', '\x9f', '\xb6'}, 3, 0xC7F6}, /* (HANGUL SYLLABLE JYAEBS) */
    {{'\xec', '\x9f', '\xb7'}, 3, 0xC7F7}, /* (HANGUL SYLLABLE JYAES) */
    {{'\xec', '\x9f', '\xb8'}, 3, 0xC7F8}, /* (HANGUL SYLLABLE JYAESS) */
    {{'\xec', '\x9f', '\xb9'}, 3, 0xC7F9}, /* (HANGUL SYLLABLE JYAENG) */
    {{'\xec', '\x9f', '\xba'}, 3, 0xC7FA}, /* (HANGUL SYLLABLE JYAEJ) */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{'\xec', '\x9f', '\xbb'}, 3, 0xC7FB}, /* (HANGUL SYLLABLE JYAEC) */
    {{'\xec', '\x9f', '\xbc'}, 3, 0xC7FC}, /* (HANGUL SYLLABLE JYAEK) */
    {{'\xec', '\x9f', '\xbd'}, 3, 0xC7FD}, /* (HANGUL SYLLABLE JYAET) */
    {{'\xec', '\x9f', '\xbe'}, 3, 0xC7FE}, /* (HANGUL SYLLABLE JYAEP) */
    {{'\xec', '\x9f', '\xbf'}, 3, 0xC7FF}, /* (HANGUL SYLLABLE JYAEH) */
    {{'\xec', '\xa0', '\x82'}, 3, 0xC802}, /* (HANGUL SYLLABLE JEOGG) */
    {{'\xec', '\xa0', '\x83'}, 3, 0xC803}, /* (HANGUL SYLLABLE JEOGS) */
    {{'\xec', '\xa0', '\x85'}, 3, 0xC805}, /* (HANGUL SYLLABLE JEONJ) */
    {{'\xec', '\xa0', '\x86'}, 3, 0xC806}, /* (HANGUL SYLLABLE JEONH) */
    {{'\xec', '\xa0', '\x87'}, 3, 0xC807}, /* (HANGUL SYLLABLE JEOD) */
    {{'\xec', '\xa0', '\x89'}, 3, 0xC809}, /* (HANGUL SYLLABLE JEOLG) */
    {{'\xec', '\xa0', '\x8b'}, 3, 0xC80B}, /* (HANGUL SYLLABLE JEOLB) */
    {{'\xec', '\xa0', '\x8c'}, 3, 0xC80C}, /* (HANGUL SYLLABLE JEOLS) */
    {{'\xec', '\xa0', '\x8d'}, 3, 0xC80D}, /* (HANGUL SYLLABLE JEOLT) */
    {{'\xec', '\xa0', '\x8e'}, 3, 0xC80E}, /* (HANGUL SYLLABLE JEOLP) */
    {{'\xec', '\xa0', '\x8f'}, 3, 0xC80F}, /* (HANGUL SYLLABLE JEOLH) */
    {{'\xec', '\xa0', '\x92'}, 3, 0xC812}, /* (HANGUL SYLLABLE JEOBS) */
    {{'\xec', '\xa0', '\x94'}, 3, 0xC814}, /* (HANGUL SYLLABLE JEOSS) */
    {{'\xec', '\xa0', '\x97'}, 3, 0xC817}, /* (HANGUL SYLLABLE JEOC) */
    {{'\xec', '\xa0', '\x98'}, 3, 0xC818}, /* (HANGUL SYLLABLE JEOK) */
    {{'\xec', '\xa0', '\x99'}, 3, 0xC819}, /* (HANGUL SYLLABLE JEOT) */
    {{'\xec', '\xa0', '\x9a'}, 3, 0xC81A}, /* (HANGUL SYLLABLE JEOP) */
    {{'\xec', '\xa0', '\x9b'}, 3, 0xC81B}, /* (HANGUL SYLLABLE JEOH) */
    {{'\xec', '\xa0', '\x9e'}, 3, 0xC81E}, /* (HANGUL SYLLABLE JEGG) */
    {{'\xec', '\xa0', '\x9f'}, 3, 0xC81F}, /* (HANGUL SYLLABLE JEGS) */
    {{'\xec', '\xa0', '\xa1'}, 3, 0xC821}, /* (HANGUL SYLLABLE JENJ) */
    {{'\xec', '\xa0', '\xa2'}, 3, 0xC822}, /* (HANGUL SYLLABLE JENH) */
    {{'\xec', '\xa0', '\xa3'}, 3, 0xC823}, /* (HANGUL SYLLABLE JED) */
    {{'\xec', '\xa0', '\xa5'}, 3, 0xC825}, /* (HANGUL SYLLABLE JELG) */
    {{'\xec', '\xa0', '\xa6'}, 3, 0xC826}, /* (HANGUL SYLLABLE JELM) */
    {{'\xec', '\xa0', '\xa7'}, 3, 0xC827}, /* (HANGUL SYLLABLE JELB) */
    {{'\xec', '\xa0', '\xa8'}, 3, 0xC828}, /* (HANGUL SYLLABLE JELS) */
    {{'\xec', '\xa0', '\xa9'}, 3, 0xC829}, /* (HANGUL SYLLABLE JELT) */
    {{'\xec', '\xa0', '\xaa'}, 3, 0xC82A}, /* (HANGUL SYLLABLE JELP) */
    {{'\xec', '\xa0', '\xab'}, 3, 0xC82B}, /* (HANGUL SYLLABLE JELH) */
    {{'\xec', '\xa0', '\xae'}, 3, 0xC82E}, /* (HANGUL SYLLABLE JEBS) */
    {{'\xec', '\xa0', '\xb0'}, 3, 0xC830}, /* (HANGUL SYLLABLE JESS) */
    {{'\xec', '\xa0', '\xb2'}, 3, 0xC832}, /* (HANGUL SYLLABLE JEJ) */
    {{'\xec', '\xa0', '\xb3'}, 3, 0xC833}, /* (HANGUL SYLLABLE JEC) */
    {{'\xec', '\xa0', '\xb4'}, 3, 0xC834}, /* (HANGUL SYLLABLE JEK) */
    {{'\xec', '\xa0', '\xb5'}, 3, 0xC835}, /* (HANGUL SYLLABLE JET) */
    {{'\xec', '\xa0', '\xb6'}, 3, 0xC836}, /* (HANGUL SYLLABLE JEP) */
    {{'\xec', '\xa0', '\xb7'}, 3, 0xC837}, /* (HANGUL SYLLABLE JEH) */
    {{'\xec', '\xa0', '\xb9'}, 3, 0xC839}, /* (HANGUL SYLLABLE JYEOG) */
    {{'\xec', '\xa0', '\xba'}, 3, 0xC83A}, /* (HANGUL SYLLABLE JYEOGG) */
    {{'\xec', '\xa0', '\xbb'}, 3, 0xC83B}, /* (HANGUL SYLLABLE JYEOGS) */
    {{'\xec', '\xa0', '\xbd'}, 3, 0xC83D}, /* (HANGUL SYLLABLE JYEONJ) */
    {{'\xec', '\xa0', '\xbe'}, 3, 0xC83E}, /* (HANGUL SYLLABLE JYEONH) */
    {{'\xec', '\xa0', '\xbf'}, 3, 0xC83F}, /* (HANGUL SYLLABLE JYEOD) */
    {{'\xec', '\xa1', '\x81'}, 3, 0xC841}, /* (HANGUL SYLLABLE JYEOLG) */
    {{'\xec', '\xa1', '\x82'}, 3, 0xC842}, /* (HANGUL SYLLABLE JYEOLM) */
    {{'\xec', '\xa1', '\x83'}, 3, 0xC843}, /* (HANGUL SYLLABLE JYEOLB) */
    {{'\xec', '\xa1', '\x84'}, 3, 0xC844}, /* (HANGUL SYLLABLE JYEOLS) */
    {{'\xec', '\xa1', '\x85'}, 3, 0xC845}, /* (HANGUL SYLLABLE JYEOLT) */
    {{'\xec', '\xa1', '\x86'}, 3, 0xC846}, /* (HANGUL SYLLABLE JYEOLP) */
    {{'\xec', '\xa1', '\x87'}, 3, 0xC847}, /* (HANGUL SYLLABLE JYEOLH) */
    {{'\xec', '\xa1', '\x8a'}, 3, 0xC84A}, /* (HANGUL SYLLABLE JYEOBS) */
    {{'\xec', '\xa1', '\x8b'}, 3, 0xC84B}, /* (HANGUL SYLLABLE JYEOS) */
    {{'\xec', '\xa1', '\x8e'}, 3, 0xC84E}, /* (HANGUL SYLLABLE JYEOJ) */
    {{'\xec', '\xa1', '\x8f'}, 3, 0xC84F}, /* (HANGUL SYLLABLE JYEOC) */
    {{'\xec', '\xa1', '\x90'}, 3, 0xC850}, /* (HANGUL SYLLABLE JYEOK) */
    {{'\xec', '\xa1', '\x91'}, 3, 0xC851}, /* (HANGUL SYLLABLE JYEOT) */
    {{'\xec', '\xa1', '\x92'}, 3, 0xC852}, /* (HANGUL SYLLABLE JYEOP) */
    {{'\xec', '\xa1', '\x93'}, 3, 0xC853}, /* (HANGUL SYLLABLE JYEOH) */
    {{'\xec', '\xa1', '\x95'}, 3, 0xC855}, /* (HANGUL SYLLABLE JYEG) */
    {{'\xec', '\xa1', '\x96'}, 3, 0xC856}, /* (HANGUL SYLLABLE JYEGG) */
    {{'\xec', '\xa1', '\x97'}, 3, 0xC857}, /* (HANGUL SYLLABLE JYEGS) */
    {{'\xec', '\xa1', '\x98'}, 3, 0xC858}, /* (HANGUL SYLLABLE JYEN) */
    {{'\xec', '\xa1', '\x99'}, 3, 0xC859}, /* (HANGUL SYLLABLE JYENJ) */
    {{'\xec', '\xa1', '\x9a'}, 3, 0xC85A}, /* (HANGUL SYLLABLE JYENH) */
    {{'\xec', '\xa1', '\x9b'}, 3, 0xC85B}, /* (HANGUL SYLLABLE JYED) */
    {{'\xec', '\xa1', '\x9c'}, 3, 0xC85C}, /* (HANGUL SYLLABLE JYEL) */
    {{'\xec', '\xa1', '\x9d'}, 3, 0xC85D}, /* (HANGUL SYLLABLE JYELG) */
    {{'\xec', '\xa1', '\x9e'}, 3, 0xC85E}, /* (HANGUL SYLLABLE JYELM) */
    {{'\xec', '\xa1', '\x9f'}, 3, 0xC85F}, /* (HANGUL SYLLABLE JYELB) */
    {{'\xec', '\xa1', '\xa0'}, 3, 0xC860}, /* (HANGUL SYLLABLE JYELS) */
    {{'\xec', '\xa1', '\xa1'}, 3, 0xC861}, /* (HANGUL SYLLABLE JYELT) */
    {{'\xec', '\xa1', '\xa2'}, 3, 0xC862}, /* (HANGUL SYLLABLE JYELP) */
    {{'\xec', '\xa1', '\xa3'}, 3, 0xC863}, /* (HANGUL SYLLABLE JYELH) */
    {{'\xec', '\xa1', '\xa4'}, 3, 0xC864}, /* (HANGUL SYLLABLE JYEM) */
    {{'\xec', '\xa1', '\xa5'}, 3, 0xC865}, /* (HANGUL SYLLABLE JYEB) */
    {{'\xec', '\xa1', '\xa6'}, 3, 0xC866}, /* (HANGUL SYLLABLE JYEBS) */
    {{'\xec', '\xa1', '\xa7'}, 3, 0xC867}, /* (HANGUL SYLLABLE JYES) */
    {{'\xec', '\xa1', '\xa8'}, 3, 0xC868}, /* (HANGUL SYLLABLE JYESS) */
    {{'\xec', '\xa1', '\xa9'}, 3, 0xC869}, /* (HANGUL SYLLABLE JYENG) */
    {{'\xec', '\xa1', '\xaa'}, 3, 0xC86A}, /* (HANGUL SYLLABLE JYEJ) */
    {{'\xec', '\xa1', '\xab'}, 3, 0xC86B}, /* (HANGUL SYLLABLE JYEC) */
    {{'\xec', '\xa1', '\xac'}, 3, 0xC86C}, /* (HANGUL SYLLABLE JYEK) */
    {{'\xec', '\xa1', '\xad'}, 3, 0xC86D}, /* (HANGUL SYLLABLE JYET) */
    {{'\xec', '\xa1', '\xae'}, 3, 0xC86E}, /* (HANGUL SYLLABLE JYEP) */
    {{'\xec', '\xa1', '\xaf'}, 3, 0xC86F}, /* (HANGUL SYLLABLE JYEH) */
    {{'\xec', '\xa1', '\xb2'}, 3, 0xC872}, /* (HANGUL SYLLABLE JOGG) */
    {{'\xec', '\xa1', '\xb3'}, 3, 0xC873}, /* (HANGUL SYLLABLE JOGS) */
    {{'\xec', '\xa1', '\xb5'}, 3, 0xC875}, /* (HANGUL SYLLABLE JONJ) */
    {{'\xec', '\xa1', '\xb6'}, 3, 0xC876}, /* (HANGUL SYLLABLE JONH) */
    {{'\xec', '\xa1', '\xb7'}, 3, 0xC877}, /* (HANGUL SYLLABLE JOD) */
    {{'\xec', '\xa1', '\xb9'}, 3, 0xC879}, /* (HANGUL SYLLABLE JOLG) */
    {{'\xec', '\xa1', '\xbb'}, 3, 0xC87B}, /* (HANGUL SYLLABLE JOLB) */
    {{'\xec', '\xa1', '\xbc'}, 3, 0xC87C}, /* (HANGUL SYLLABLE JOLS) */
    {{'\xec', '\xa1', '\xbd'}, 3, 0xC87D}, /* (HANGUL SYLLABLE JOLT) */
    {{'\xec', '\xa1', '\xbe'}, 3, 0xC87E}, /* (HANGUL SYLLABLE JOLP) */
    {{'\xec', '\xa1', '\xbf'}, 3, 0xC87F}, /* (HANGUL SYLLABLE JOLH) */
    {{'\xec', '\xa2', '\x82'}, 3, 0xC882}, /* (HANGUL SYLLABLE JOBS) */
    {{'\xec', '\xa2', '\x84'}, 3, 0xC884}, /* (HANGUL SYLLABLE JOSS) */
    {{'\xec', '\xa2', '\x88'}, 3, 0xC888}, /* (HANGUL SYLLABLE JOK) */
    {{'\xec', '\xa2', '\x89'}, 3, 0xC889}, /* (HANGUL SYLLABLE JOT) */
    {{'\xec', '\xa2', '\x8a'}, 3, 0xC88A}, /* (HANGUL SYLLABLE JOP) */
    {{'\xec', '\xa2', '\x8e'}, 3, 0xC88E}, /* (HANGUL SYLLABLE JWAGG) */
    {{'\xec', '\xa2', '\x8f'}, 3, 0xC88F}, /* (HANGUL SYLLABLE JWAGS) */
    {{'\xec', '\xa2', '\x90'}, 3, 0xC890}, /* (HANGUL SYLLABLE JWAN) */
    {{'\xec', '\xa2', '\x91'}, 3, 0xC891}, /* (HANGUL SYLLABLE JWANJ) */
    {{'\xec', '\xa2', '\x92'}, 3, 0xC892}, /* (HANGUL SYLLABLE JWANH) */
    {{'\xec', '\xa2', '\x93'}, 3, 0xC893}, /* (HANGUL SYLLABLE JWAD) */
    {{'\xec', '\xa2', '\x95'}, 3, 0xC895}, /* (HANGUL SYLLABLE JWALG) */
    {{'\xec', '\xa2', '\x96'}, 3, 0xC896}, /* (HANGUL SYLLABLE JWALM) */
    {{'\xec', '\xa2', '\x97'}, 3, 0xC897}, /* (HANGUL SYLLABLE JWALB) */
    {{'\xec', '\xa2', '\x98'}, 3, 0xC898}, /* (HANGUL SYLLABLE JWALS) */
    {{'\xec', '\xa2', '\x99'}, 3, 0xC899}, /* (HANGUL SYLLABLE JWALT) */
    {{'\xec', '\xa2', '\x9a'}, 3, 0xC89A}, /* (HANGUL SYLLABLE JWALP) */
    {{'\xec', '\xa2', '\x9b'}, 3, 0xC89B}, /* (HANGUL SYLLABLE JWALH) */
    {{'\xec', '\xa2', '\x9c'}, 3, 0xC89C}, /* (HANGUL SYLLABLE JWAM) */
    {{'\xec', '\xa2', '\x9e'}, 3, 0xC89E}, /* (HANGUL SYLLABLE JWABS) */
    {{'\xec', '\xa2', '\xa0'}, 3, 0xC8A0}, /* (HANGUL SYLLABLE JWASS) */
    {{'\xec', '\xa2', '\xa2'}, 3, 0xC8A2}, /* (HANGUL SYLLABLE JWAJ) */
    {{'\xec', '\xa2', '\xa3'}, 3, 0xC8A3}, /* (HANGUL SYLLABLE JWAC) */
    {{'\xec', '\xa2', '\xa4'}, 3, 0xC8A4}, /* (HANGUL SYLLABLE JWAK) */
    {{'\xec', '\xa2', '\xa5'}, 3, 0xC8A5}, /* (HANGUL SYLLABLE JWAT) */
    {{'\xec', '\xa2', '\xa6'}, 3, 0xC8A6}, /* (HANGUL SYLLABLE JWAP) */
    {{'\xec', '\xa2', '\xa7'}, 3, 0xC8A7}, /* (HANGUL SYLLABLE JWAH) */
    {{'\xec', '\xa2', '\xa9'}, 3, 0xC8A9}, /* (HANGUL SYLLABLE JWAEG) */
    {{'\xec', '\xa2', '\xaa'}, 3, 0xC8AA}, /* (HANGUL SYLLABLE JWAEGG) */
    {{'\xec', '\xa2', '\xab'}, 3, 0xC8AB}, /* (HANGUL SYLLABLE JWAEGS) */
    {{'\xec', '\xa2', '\xac'}, 3, 0xC8AC}, /* (HANGUL SYLLABLE JWAEN) */
    {{'\xec', '\xa2', '\xad'}, 3, 0xC8AD}, /* (HANGUL SYLLABLE JWAENJ) */
    {{'\xec', '\xa2', '\xae'}, 3, 0xC8AE}, /* (HANGUL SYLLABLE JWAENH) */
    {{'\xec', '\xa2', '\xaf'}, 3, 0xC8AF}, /* (HANGUL SYLLABLE JWAED) */
    {{'\xec', '\xa2', '\xb0'}, 3, 0xC8B0}, /* (HANGUL SYLLABLE JWAEL) */
    {{'\xec', '\xa2', '\xb1'}, 3, 0xC8B1}, /* (HANGUL SYLLABLE JWAELG) */
    {{'\xec', '\xa2', '\xb2'}, 3, 0xC8B2}, /* (HANGUL SYLLABLE JWAELM) */
    {{'\xec', '\xa2', '\xb3'}, 3, 0xC8B3}, /* (HANGUL SYLLABLE JWAELB) */
    {{'\xec', '\xa2', '\xb4'}, 3, 0xC8B4}, /* (HANGUL SYLLABLE JWAELS) */
    {{'\xec', '\xa2', '\xb5'}, 3, 0xC8B5}, /* (HANGUL SYLLABLE JWAELT) */
    {{'\xec', '\xa2', '\xb6'}, 3, 0xC8B6}, /* (HANGUL SYLLABLE JWAELP) */
    {{'\xec', '\xa2', '\xb7'}, 3, 0xC8B7}, /* (HANGUL SYLLABLE JWAELH) */
    {{'\xec', '\xa2', '\xb8'}, 3, 0xC8B8}, /* (HANGUL SYLLABLE JWAEM) */
    {{'\xec', '\xa2', '\xb9'}, 3, 0xC8B9}, /* (HANGUL SYLLABLE JWAEB) */
    {{'\xec', '\xa2', '\xba'}, 3, 0xC8BA}, /* (HANGUL SYLLABLE JWAEBS) */
    {{'\xec', '\xa2', '\xbb'}, 3, 0xC8BB}, /* (HANGUL SYLLABLE JWAES) */
    {{'\xec', '\xa2', '\xbe'}, 3, 0xC8BE}, /* (HANGUL SYLLABLE JWAEJ) */
    {{'\xec', '\xa2', '\xbf'}, 3, 0xC8BF}, /* (HANGUL SYLLABLE JWAEC) */
    {{'\xec', '\xa3', '\x80'}, 3, 0xC8C0}, /* (HANGUL SYLLABLE JWAEK) */
    {{'\xec', '\xa3', '\x81'}, 3, 0xC8C1}, /* (HANGUL SYLLABLE JWAET) */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{'\xec', '\xa3', '\x82'}, 3, 0xC8C2}, /* (HANGUL SYLLABLE JWAEP) */
    {{'\xec', '\xa3', '\x83'}, 3, 0xC8C3}, /* (HANGUL SYLLABLE JWAEH) */
    {{'\xec', '\xa3', '\x85'}, 3, 0xC8C5}, /* (HANGUL SYLLABLE JOEG) */
    {{'\xec', '\xa3', '\x86'}, 3, 0xC8C6}, /* (HANGUL SYLLABLE JOEGG) */
    {{'\xec', '\xa3', '\x87'}, 3, 0xC8C7}, /* (HANGUL SYLLABLE JOEGS) */
    {{'\xec', '\xa3', '\x89'}, 3, 0xC8C9}, /* (HANGUL SYLLABLE JOENJ) */
    {{'\xec', '\xa3', '\x8a'}, 3, 0xC8CA}, /* (HANGUL SYLLABLE JOENH) */
    {{'\xec', '\xa3', '\x8b'}, 3, 0xC8CB}, /* (HANGUL SYLLABLE JOED) */
    {{'\xec', '\xa3', '\x8d'}, 3, 0xC8CD}, /* (HANGUL SYLLABLE JOELG) */
    {{'\xec', '\xa3', '\x8e'}, 3, 0xC8CE}, /* (HANGUL SYLLABLE JOELM) */
    {{'\xec', '\xa3', '\x8f'}, 3, 0xC8CF}, /* (HANGUL SYLLABLE JOELB) */
    {{'\xec', '\xa3', '\x90'}, 3, 0xC8D0}, /* (HANGUL SYLLABLE JOELS) */
    {{'\xec', '\xa3', '\x91'}, 3, 0xC8D1}, /* (HANGUL SYLLABLE JOELT) */
    {{'\xec', '\xa3', '\x92'}, 3, 0xC8D2}, /* (HANGUL SYLLABLE JOELP) */
    {{'\xec', '\xa3', '\x93'}, 3, 0xC8D3}, /* (HANGUL SYLLABLE JOELH) */
    {{'\xec', '\xa3', '\x96'}, 3, 0xC8D6}, /* (HANGUL SYLLABLE JOEBS) */
    {{'\xec', '\xa3', '\x98'}, 3, 0xC8D8}, /* (HANGUL SYLLABLE JOESS) */
    {{'\xec', '\xa3', '\x9a'}, 3, 0xC8DA}, /* (HANGUL SYLLABLE JOEJ) */
    {{'\xec', '\xa3', '\x9b'}, 3, 0xC8DB}, /* (HANGUL SYLLABLE JOEC) */
    {{'\xec', '\xa3', '\x9c'}, 3, 0xC8DC}, /* (HANGUL SYLLABLE JOEK) */
    {{'\xec', '\xa3', '\x9d'}, 3, 0xC8DD}, /* (HANGUL SYLLABLE JOET) */
    {{'\xec', '\xa3', '\x9e'}, 3, 0xC8DE}, /* (HANGUL SYLLABLE JOEP) */
    {{'\xec', '\xa3', '\x9f'}, 3, 0xC8DF}, /* (HANGUL SYLLABLE JOEH) */
    {{'\xec', '\xa3', '\xa2'}, 3, 0xC8E2}, /* (HANGUL SYLLABLE JYOGG) */
    {{'\xec', '\xa3', '\xa3'}, 3, 0xC8E3}, /* (HANGUL SYLLABLE JYOGS) */
    {{'\xec', '\xa3', '\xa5'}, 3, 0xC8E5}, /* (HANGUL SYLLABLE JYONJ) */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{'\xec', '\xa3', '\xa6'}, 3, 0xC8E6}, /* (HANGUL SYLLABLE JYONH) */
    {{'\xec', '\xa3', '\xa7'}, 3, 0xC8E7}, /* (HANGUL SYLLABLE JYOD) */
    {{'\xec', '\xa3', '\xa8'}, 3, 0xC8E8}, /* (HANGUL SYLLABLE JYOL) */
    {{'\xec', '\xa3', '\xa9'}, 3, 0xC8E9}, /* (HANGUL SYLLABLE JYOLG) */
    {{'\xec', '\xa3', '\xaa'}, 3, 0xC8EA}, /* (HANGUL SYLLABLE JYOLM) */
    {{'\xec', '\xa3', '\xab'}, 3, 0xC8EB}, /* (HANGUL SYLLABLE JYOLB) */
    {{'\xec', '\xa3', '\xac'}, 3, 0xC8EC}, /* (HANGUL SYLLABLE JYOLS) */
    {{'\xec', '\xa3', '\xad'}, 3, 0xC8ED}, /* (HANGUL SYLLABLE JYOLT) */
    {{'\xec', '\xa3', '\xae'}, 3, 0xC8EE}, /* (HANGUL SYLLABLE JYOLP) */
    {{'\xec', '\xa3', '\xaf'}, 3, 0xC8EF}, /* (HANGUL SYLLABLE JYOLH) */
    {{'\xec', '\xa3', '\xb0'}, 3, 0xC8F0}, /* (HANGUL SYLLABLE JYOM) */
    {{'\xec', '\xa3', '\xb1'}, 3, 0xC8F1}, /* (HANGUL SYLLABLE JYOB) */
    {{'\xec', '\xa3', '\xb2'}, 3, 0xC8F2}, /* (HANGUL SYLLABLE JYOBS) */
    {{'\xec', '\xa3', '\xb3'}, 3, 0xC8F3}, /* (HANGUL SYLLABLE JYOS) */
    {{'\xec', '\xa3', '\xb4'}, 3, 0xC8F4}, /* (HANGUL SYLLABLE JYOSS) */
    {{'\xec', '\xa3', '\xb6'}, 3, 0xC8F6}, /* (HANGUL SYLLABLE JYOJ) */
    {{'\xec', '\xa3', '\xb7'}, 3, 0xC8F7}, /* (HANGUL SYLLABLE JYOC) */
    {{'\xec', '\xa3', '\xb8'}, 3, 0xC8F8}, /* (HANGUL SYLLABLE JYOK) */
    {{'\xec', '\xa3', '\xb9'}, 3, 0xC8F9}, /* (HANGUL SYLLABLE JYOT) */
    {{'\xec', '\xa3', '\xba'}, 3, 0xC8FA}, /* (HANGUL SYLLABLE JYOP) */
    {{'\xec', '\xa3', '\xbb'}, 3, 0xC8FB}, /* (HANGUL SYLLABLE JYOH) */
    {{'\xec', '\xa3', '\xbe'}, 3, 0xC8FE}, /* (HANGUL SYLLABLE JUGG) */
    {{'\xec', '\xa3', '\xbf'}, 3, 0xC8FF}, /* (HANGUL SYLLABLE JUGS) */
    {{'\xec', '\xa4', '\x81'}, 3, 0xC901}, /* (HANGUL SYLLABLE JUNJ) */
    {{'\xec', '\xa4', '\x82'}, 3, 0xC902}, /* (HANGUL SYLLABLE JUNH) */
    {{'\xec', '\xa4', '\x83'}, 3, 0xC903}, /* (HANGUL SYLLABLE JUD) */
    {{'\xec', '\xa4', '\x87'}, 3, 0xC907}, /* (HANGUL SYLLABLE JULB) */
    {{'\xec', '\xa4', '\x88'}, 3, 0xC908}, /* (HANGUL SYLLABLE JULS) */
    {{'\xec', '\xa4', '\x89'}, 3, 0xC909}, /* (HANGUL SYLLABLE JULT) */
    {{'\xec', '\xa4', '\x8a'}, 3, 0xC90A}, /* (HANGUL SYLLABLE JULP) */
    {{'\xec', '\xa4', '\x8b'}, 3, 0xC90B}, /* (HANGUL SYLLABLE JULH) */
    {{'\xec', '\xa4', '\x8e'}, 3, 0xC90E}, /* (HANGUL SYLLABLE JUBS) */
    {{'\xe3', '\x80', '\x80'}, 3, 0x3000}, /* (IDEOGRAPHIC SPACE) */
    {{'\xe3', '\x80', '\x81'}, 3, 0x3001}, /* (IDEOGRAPHIC COMMA) */
    {{'\xe3', '\x80', '\x82'}, 3, 0x3002}, /* (IDEOGRAPHIC FULL STOP) */
    {{'\xc2', '\xb7'}, 2, 0x00B7}, /* (MIDDLE DOT) */
    {{'\xe2', '\x80', '\xa5'}, 3, 0x2025}, /* (TWO DOT LEADER) */
    {{'\xe2', '\x80', '\xa6'}, 3, 0x2026}, /* (HORIZONTAL ELLIPSIS) */
    {{'\xc2', '\xa8'}, 2, 0x00A8}, /* (DIAERESIS) */
    {{'\xe3', '\x80', '\x83'}, 3, 0x3003}, /* (DITTO MARK) */
    {{'\xc2', '\xad'}, 2, 0x00AD}, /* (SOFT HYPHEN) */
    {{'\xe2', '\x80', '\x95'}, 3, 0x2015}, /* (HORIZONTAL BAR) */
    {{'\xe2', '\x88', '\xa5'}, 3, 0x2225}, /* (PARALLEL TO) */
    {{'\xef', '\xbc', '\xbc'}, 3, 0xFF3C}, /* (FULLWIDTH REVERSE SOLIDUS) */
    {{'\xe2', '\x88', '\xbc'}, 3, 0x223C}, /* (TILDE OPERATOR) */
    {{'\xe2', '\x80', '\x98'}, 3, 0x2018}, /* (LEFT SINGLE QUOTATION MARK) */
    {{'\xe2', '\x80', '\x99'}, 3, 0x2019}, /* (RIGHT SINGLE QUOTATION MARK) */
    {{'\xe2', '\x80', '\x9c'}, 3, 0x201C}, /* (LEFT DOUBLE QUOTATION MARK) */
    {{'\xe2', '\x80', '\x9d'}, 3, 0x201D}, /* (RIGHT DOUBLE QUOTATION MARK) */
    {{'\xe3', '\x80', '\x94'}, 3, 0x3014}, /* (LEFT TORTOISE SHELL BRACKET) */
    {{'\xe3', '\x80', '\x95'}, 3, 0x3015}, /* (RIGHT TORTOISE SHELL BRACKET) */
    {{'\xe3', '\x80', '\x88'}, 3, 0x3008}, /* (LEFT ANGLE BRACKET) */
    {{'\xe3', '\x80', '\x89'}, 3, 0x3009}, /* (RIGHT ANGLE BRACKET) */
    {{'\xe3', '\x80', '\x8a'}, 3, 0x300A}, /* (LEFT DOUBLE ANGLE BRACKET) */
    {{'\xe3', '\x80', '\x8b'}, 3, 0x300B}, /* (RIGHT DOUBLE ANGLE BRACKET) */
    {{'\xe3', '\x80', '\x8c'}, 3, 0x300C}, /* (LEFT CORNER BRACKET) */
    {{'\xe3', '\x80', '\x8d'}, 3, 0x300D}, /* (RIGHT CORNER BRACKET) */
    {{'\xe3', '\x80', '\x8e'}, 3, 0x300E}, /* (LEFT WHITE CORNER BRACKET) */
    {{'\xe3', '\x80', '\x8f'}, 3, 0x300F}, /* (RIGHT WHITE CORNER BRACKET) */
    {{'\xe3', '\x80', '\x90'}, 3, 0x3010}, /* (LEFT BLACK LENTICULAR BRACKET) */
    {{'\xe3', '\x80', '\x91'}, 3, 0x3011}, /* (RIGHT BLACK LENTICULAR BRACKET) */
    {{'\xc2', '\xb1'}, 2, 0x00B1}, /* (PLUS-MINUS SIGN) */
    {{'\xc3', '\x97'}, 2, 0x00D7}, /* (MULTIPLICATION SIGN) */
    {{'\xc3', '\xb7'}, 2, 0x00F7}, /* (DIVISION SIGN) */
    {{'\xe2', '\x89', '\xa0'}, 3, 0x2260}, /* (NOT EQUAL TO) */
    {{'\xe2', '\x89', '\xa4'}, 3, 0x2264}, /* (LESS-THAN OR EQUAL TO) */
    {{'\xe2', '\x89', '\xa5'}, 3, 0x2265}, /* (GREATER-THAN OR EQUAL TO) */
    {{'\xe2', '\x88', '\x9e'}, 3, 0x221E}, /* (INFINITY) */
    {{'\xe2', '\x88', '\xb4'}, 3, 0x2234}, /* (THEREFORE) */
    {{'\xc2', '\xb0'}, 2, 0x00B0}, /* (DEGREE SIGN) */
    {{'\xe2', '\x80', '\xb2'}, 3, 0x2032}, /* (PRIME) */
    {{'\xe2', '\x80', '\xb3'}, 3, 0x2033}, /* (DOUBLE PRIME) */
    {{'\xe2', '\x84', '\x83'}, 3, 0x2103}, /* (DEGREE CELSIUS) */
    {{'\xe2', '\x84', '\xab'}, 3, 0x212B}, /* (ANGSTROM SIGN) */
    {{'\xef', '\xbf', '\xa0'}, 3, 0xFFE0}, /* (FULLWIDTH CENT SIGN) */
    {{'\xef', '\xbf', '\xa1'}, 3, 0xFFE1}, /* (FULLWIDTH POUND SIGN) */
    {{'\xef', '\xbf', '\xa5'}, 3, 0xFFE5}, /* (FULLWIDTH YEN SIGN) */
    {{'\xe2', '\x99', '\x82'}, 3, 0x2642}, /* (MALE SIGN) */
    {{'\xe2', '\x99', '\x80'}, 3, 0x2640}, /* (FEMALE SIGN) */
    {{'\xe2', '\x88', '\xa0'}, 3, 0x2220}, /* (ANGLE) */
    {{'\xe2', '\x8a', '\xa5'}, 3, 0x22A5}, /* (UP TACK) */
    {{'\xe2', '\x8c', '\x92'}, 3, 0x2312}, /* (ARC) */
    {{'\xe2', '\x88', '\x82'}, 3, 0x2202}, /* (PARTIAL DIFFERENTIAL) */
    {{'\xe2', '\x88', '\x87'}, 3, 0x2207}, /* (NABLA) */
    {{'\xe2', '\x89', '\xa1'}, 3, 0x2261}, /* (IDENTICAL TO) */
    {{'\xe2', '\x89', '\x92'}, 3, 0x2252}, /* (APPROXIMATELY EQUAL TO OR THE IMAGE OF) */
    {{'\xc2', '\xa7'}, 2, 0x00A7}, /* (SECTION SIGN) */
    {{'\xe2', '\x80', '\xbb'}, 3, 0x203B}, /* (REFERENCE MARK) */
    {{'\xe2', '\x98', '\x86'}, 3, 0x2606}, /* (WHITE STAR) */
    {{'\xe2', '\x98', '\x85'}, 3, 0x2605}, /* (BLACK STAR) */
    {{'\xe2', '\x97', '\x8b'}, 3, 0x25CB}, /* (WHITE CIRCLE) */
    {{'\xe2', '\x97', '\x8f'}, 3, 0x25CF}, /* (BLACK CIRCLE) */
    {{'\xe2', '\x97', '\x8e'}, 3, 0x25CE}, /* (BULLSEYE) */
    {{'\xe2', '\x97', '\x87'}, 3, 0x25C7}, /* (WHITE DIAMOND) */
    {{'\xe2', '\x97', '\x86'}, 3, 0x25C6}, /* (BLACK DIAMOND) */
    {{'\xe2', '\x96', '\xa1'}, 3, 0x25A1}, /* (WHITE SQUARE) */
    {{'\xe2', '\x96', '\xa0'}, 3, 0x25A0}, /* (BLACK SQUARE) */
    {{'\xe2', '\x96', '\xb3'}, 3, 0x25B3}, /* (WHITE UP-POINTING TRIANGLE) */
    {{'\xe2', '\x96', '\xb2'}, 3, 0x25B2}, /* (BLACK UP-POINTING TRIANGLE) */
    {{'\xe2', '\x96', '\xbd'}, 3, 0x25BD}, /* (WHITE DOWN-POINTING TRIANGLE) */
    {{'\xe2', '\x96', '\xbc'}, 3, 0x25BC}, /* (BLACK DOWN-POINTING TRIANGLE) */
    {{'\xe2', '\x86', '\x92'}, 3, 0x2192}, /* (RIGHTWARDS ARROW) */
    {{'\xe2', '\x86', '\x90'}, 3, 0x2190}, /* (LEFTWARDS ARROW) */
    {{'\xe2', '\x86', '\x91'}, 3, 0x2191}, /* (UPWARDS ARROW) */
    {{'\xe2', '\x86', '\x93'}, 3, 0x2193}, /* (DOWNWARDS ARROW) */
    {{'\xe2', '\x86', '\x94'}, 3, 0x2194}, /* (LEFT RIGHT ARROW) */
    {{'\xe3', '\x80', '\x93'}, 3, 0x3013}, /* (GETA MARK) */
    {{'\xe2', '\x89', '\xaa'}, 3, 0x226A}, /* (MUCH LESS-THAN) */
    {{'\xe2', '\x89', '\xab'}, 3, 0x226B}, /* (MUCH GREATER-THAN) */
    {{'\xe2', '\x88', '\x9a'}, 3, 0x221A}, /* (SQUARE ROOT) */
    {{'\xe2', '\x88', '\xbd'}, 3, 0x223D}, /* (REVERSED TILDE) */
    {{'\xe2', '\x88', '\x9d'}, 3, 0x221D}, /* (PROPORTIONAL TO) */
    {{'\xe2', '\x88', '\xb5'}, 3, 0x2235}, /* (BECAUSE) */
    {{'\xe2', '\x88', '\xab'}, 3, 0x222B}, /* (INTEGRAL) */
    {{'\xe2', '\x88', '\xac'}, 3, 0x222C}, /* (DOUBLE INTEGRAL) */
    {{'\xe2', '\x88', '\x88'}, 3, 0x2208}, /* (ELEMENT OF) */
    {{'\xe2', '\x88', '\x8b'}, 3, 0x220B}, /* (CONTAINS AS MEMBER) */
    {{'\xe2', '\x8a', '\x86'}, 3, 0x2286}, /* (SUBSET OF OR EQUAL TO) */
    {{'\xe2', '\x8a', '\x87'}, 3, 0x2287}, /* (SUPERSET OF OR EQUAL TO) */
    {{'\xe2', '\x8a', '\x82'}, 3, 0x2282}, /* (SUBSET OF) */
    {{'\xe2', '\x8a', '\x83'}, 3, 0x2283}, /* (SUPERSET OF) */
    {{'\xe2', '\x88', '\xaa'}, 3, 0x222A}, /* (UNION) */
    {{'\xe2', '\x88', '\xa9'}, 3, 0x2229}, /* (INTERSECTION) */
    {{'\xe2', '\x88', '\xa7'}, 3, 0x2227}, /* (LOGICAL AND) */
    {{'\xe2', '\x88', '\xa8'}, 3, 0x2228}, /* (LOGICAL OR) */
    {{'\xef', '\xbf', '\xa2'}, 3, 0xFFE2}, /* (FULLWIDTH NOT SIGN) */
    {{'\xec', '\xa4', '\x90'}, 3, 0xC910}, /* (HANGUL SYLLABLE JUSS) */
    {{'\xec', '\xa4', '\x92'}, 3, 0xC912}, /* (HANGUL SYLLABLE JUJ) */
    {{'\xec', '\xa4', '\x93'}, 3, 0xC913}, /* (HANGUL SYLLABLE JUC) */
    {{'\xec', '\xa4', '\x94'}, 3, 0xC914}, /* (HANGUL SYLLABLE JUK) */
    {{'\xec', '\xa4', '\x95'}, 3, 0xC915}, /* (HANGUL SYLLABLE JUT) */
    {{'\xec', '\xa4', '\x96'}, 3, 0xC916}, /* (HANGUL SYLLABLE JUP) */
    {{'\xec', '\xa4', '\x97'}, 3, 0xC917}, /* (HANGUL SYLLABLE JUH) */
    {{'\xec', '\xa4', '\x99'}, 3, 0xC919}, /* (HANGUL SYLLABLE JWEOG) */
    {{'\xec', '\xa4', '\x9a'}, 3, 0xC91A}, /* (HANGUL SYLLABLE JWEOGG) */
    {{'\xec', '\xa4', '\x9b'}, 3, 0xC91B}, /* (HANGUL SYLLABLE JWEOGS) */
    {{'\xec', '\xa4', '\x9c'}, 3, 0xC91C}, /* (HANGUL SYLLABLE JWEON) */
    {{'\xec', '\xa4', '\x9d'}, 3, 0xC91D}, /* (HANGUL SYLLABLE JWEONJ) */
    {{'\xec', '\xa4', '\x9e'}, 3, 0xC91E}, /* (HANGUL SYLLABLE JWEONH) */
    {{'\xec', '\xa4', '\x9f'}, 3, 0xC91F}, /* (HANGUL SYLLABLE JWEOD) */
    {{'\xec', '\xa4', '\xa0'}, 3, 0xC920}, /* (HANGUL SYLLABLE JWEOL) */
    {{'\xec', '\xa4', '\xa1'}, 3, 0xC921}, /* (HANGUL SYLLABLE JWEOLG) */
    {{'\xec', '\xa4', '\xa2'}, 3, 0xC922}, /* (HANGUL SYLLABLE JWEOLM) */
    {{'\xec', '\xa4', '\xa3'}, 3, 0xC923}, /* (HANGUL SYLLABLE JWEOLB) */
    {{'\xec', '\xa4', '\xa4'}, 3, 0xC924}, /* (HANGUL SYLLABLE JWEOLS) */
    {{'\xec', '\xa4', '\xa5'}, 3, 0xC925}, /* (HANGUL SYLLABLE JWEOLT) */
    {{'\xec', '\xa4', '\xa6'}, 3, 0xC926}, /* (HANGUL SYLLABLE JWEOLP) */
    {{'\xec', '\xa4', '\xa7'}, 3, 0xC927}, /* (HANGUL SYLLABLE JWEOLH) */
    {{'\xec', '\xa4', '\xa8'}, 3, 0xC928}, /* (HANGUL SYLLABLE JWEOM) */
    {{'\xec', '\xa4', '\xa9'}, 3, 0xC929}, /* (HANGUL SYLLABLE JWEOB) */
    {{'\xec', '\xa4', '\xaa'}, 3, 0xC92A}, /* (HANGUL SYLLABLE JWEOBS) */
    {{'\xec', '\xa4', '\xab'}, 3, 0xC92B}, /* (HANGUL SYLLABLE JWEOS) */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{'\xec', '\xa4', '\xad'}, 3, 0xC92D}, /* (HANGUL SYLLABLE JWEONG) */
    {{'\xec', '\xa4', '\xae'}, 3, 0xC92E}, /* (HANGUL SYLLABLE JWEOJ) */
    {{'\xec', '\xa4', '\xaf'}, 3, 0xC92F}, /* (HANGUL SYLLABLE JWEOC) */
    {{'\xec', '\xa4', '\xb0'}, 3, 0xC930}, /* (HANGUL SYLLABLE JWEOK) */
    {{'\xec', '\xa4', '\xb1'}, 3, 0xC931}, /* (HANGUL SYLLABLE JWEOT) */
    {{'\xec', '\xa4', '\xb2'}, 3, 0xC932}, /* (HANGUL SYLLABLE JWEOP) */
    {{'\xec', '\xa4', '\xb3'}, 3, 0xC933}, /* (HANGUL SYLLABLE JWEOH) */
    {{'\xec', '\xa4', '\xb5'}, 3, 0xC935}, /* (HANGUL SYLLABLE JWEG) */
    {{'\xec', '\xa4', '\xb6'}, 3, 0xC936}, /* (HANGUL SYLLABLE JWEGG) */
    {{'\xec', '\xa4', '\xb7'}, 3, 0xC937}, /* (HANGUL SYLLABLE JWEGS) */
    {{'\xec', '\xa4', '\xb8'}, 3, 0xC938}, /* (HANGUL SYLLABLE JWEN) */
    {{'\xec', '\xa4', '\xb9'}, 3, 0xC939}, /* (HANGUL SYLLABLE JWENJ) */
    {{'\xec', '\xa4', '\xba'}, 3, 0xC93A}, /* (HANGUL SYLLABLE JWENH) */
    {{'\xec', '\xa4', '\xbb'}, 3, 0xC93B}, /* (HANGUL SYLLABLE JWED) */
    {{'\xec', '\xa4', '\xbc'}, 3, 0xC93C}, /* (HANGUL SYLLABLE JWEL) */
    {{'\xec', '\xa4', '\xbd'}, 3, 0xC93D}, /* (HANGUL SYLLABLE JWELG) */
    {{'\xec', '\xa4', '\xbe'}, 3, 0xC93E}, /* (HANGUL SYLLABLE JWELM) */
    {{'\xec', '\xa4', '\xbf'}, 3, 0xC93F}, /* (HANGUL SYLLABLE JWELB) */
    {{'\xec', '\xa5', '\x80'}, 3, 0xC940}, /* (HANGUL SYLLABLE JWELS) */
    {{'\xec', '\xa5', '\x81'}, 3, 0xC941}, /* (HANGUL SYLLABLE JWELT) */
    {{'\xec', '\xa5', '\x82'}, 3, 0xC942}, /* (HANGUL SYLLABLE JWELP) */
    {{'\xec', '\xa5', '\x83'}, 3, 0xC943}, /* (HANGUL SYLLABLE JWELH) */
    {{'\xec', '\xa5', '\x84'}, 3, 0xC944}, /* (HANGUL SYLLABLE JWEM) */
    {{'\xec', '\xa5', '\x85'}, 3, 0xC945}, /* (HANGUL SYLLABLE JWEB) */
    {{'\xec', '\xa5', '\x86'}, 3, 0xC946}, /* (HANGUL SYLLABLE JWEBS) */
    {{'\xec', '\xa5', '\x87'}, 3, 0xC947}, /* (HANGUL SYLLABLE JWES) */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{'\xec', '\xa5', '\x88'}, 3, 0xC948}, /* (HANGUL SYLLABLE JWESS) */
    {{'\xec', '\xa5', '\x89'}, 3, 0xC949}, /* (HANGUL SYLLABLE JWENG) */
    {{'\xec', '\xa5', '\x8a'}, 3, 0xC94A}, /* (HANGUL SYLLABLE JWEJ) */
    {{'\xec', '\xa5', '\x8b'}, 3, 0xC94B}, /* (HANGUL SYLLABLE JWEC) */
    {{'\xec', '\xa5', '\x8c'}, 3, 0xC94C}, /* (HANGUL SYLLABLE JWEK) */
    {{'\xec', '\xa5', '\x8d'}, 3, 0xC94D}, /* (HANGUL SYLLABLE JWET) */
    {{'\xec', '\xa5', '\x8e'}, 3, 0xC94E}, /* (HANGUL SYLLABLE JWEP) */
    {{'\xec', '\xa5', '\x8f'}, 3, 0xC94F}, /* (HANGUL SYLLABLE JWEH) */
    {{'\xec', '\xa5', '\x92'}, 3, 0xC952}, /* (HANGUL SYLLABLE JWIGG) */
    {{'\xec', '\xa5', '\x93'}, 3, 0xC953}, /* (HANGUL SYLLABLE JWIGS) */
    {{'\xec', '\xa5', '\x95'}, 3, 0xC955}, /* (HANGUL SYLLABLE JWINJ) */
    {{'\xec', '\xa5', '\x96'}, 3, 0xC956}, /* (HANGUL SYLLABLE JWINH) */
    {{'\xec', '\xa5', '\x97'}, 3, 0xC957}, /* (HANGUL SYLLABLE JWID) */
    {{'\xec', '\xa5', '\x99'}, 3, 0xC959}, /* (HANGUL SYLLABLE JWILG) */
    {{'\xec', '\xa5', '\x9a'}, 3, 0xC95A}, /* (HANGUL SYLLABLE JWILM) */
    {{'\xec', '\xa5', '\x9b'}, 3, 0xC95B}, /* (HANGUL SYLLABLE JWILB) */
    {{'\xec', '\xa5', '\x9c'}, 3, 0xC95C}, /* (HANGUL SYLLABLE JWILS) */
    {{'\xec', '\xa5', '\x9d'}, 3, 0xC95D}, /* (HANGUL SYLLABLE JWILT) */
    {{'\xec', '\xa5', '\x9e'}, 3, 0xC95E}, /* (HANGUL SYLLABLE JWILP) */
    {{'\xec', '\xa5', '\x9f'}, 3, 0xC95F}, /* (HANGUL SYLLABLE JWILH) */
    {{'\xec', '\xa5', '\xa2'}, 3, 0xC962}, /* (HANGUL SYLLABLE JWIBS) */
    {{'\xec', '\xa5', '\xa4'}, 3, 0xC964}, /* (HANGUL SYLLABLE JWISS) */
    {{'\xec', '\xa5', '\xa5'}, 3, 0xC965}, /* (HANGUL SYLLABLE JWING) */
    {{'\xec', '\xa5', '\xa6'}, 3, 0xC966}, /* (HANGUL SYLLABLE JWIJ) */
    {{'\xec', '\xa5', '\xa7'}, 3, 0xC967}, /* (HANGUL SYLLABLE JWIC) */
    {{'\xec', '\xa5', '\xa8'}, 3, 0xC968}, /* (HANGUL SYLLABLE JWIK) */
    {{'\xec', '\xa5', '\xa9'}, 3, 0xC969}, /* (HANGUL SYLLABLE JWIT) */
    {{'\xec', '\xa5', '\xaa'}, 3, 0xC96A}, /* (HANGUL SYLLABLE JWIP) */
    {{'\xec', '\xa5', '\xab'}, 3, 0xC96B}, /* (HANGUL SYLLABLE JWIH) */
    {{'\xec', '\xa5', '\xad'}, 3, 0xC96D}, /* (HANGUL SYLLABLE JYUG) */
    {{'\xec', '\xa5', '\xae'}, 3, 0xC96E}, /* (HANGUL SYLLABLE JYUGG) */
    {{'\xec', '\xa5', '\xaf'}, 3, 0xC96F}, /* (HANGUL SYLLABLE JYUGS) */
    {{'\xe2', '\x87', '\x92'}, 3, 0x21D2}, /* (RIGHTWARDS DOUBLE ARROW) */
    {{'\xe2', '\x87', '\x94'}, 3, 0x21D4}, /* (LEFT RIGHT DOUBLE ARROW) */
    {{'\xe2', '\x88', '\x80'}, 3, 0x2200}, /* (FOR ALL) */
    {{'\xe2', '\x88', '\x83'}, 3, 0x2203}, /* (THERE EXISTS) */
    {{'\xc2', '\xb4'}, 2, 0x00B4}, /* (ACUTE ACCENT) */
    {{'\xef', '\xbd', '\x9e'}, 3, 0xFF5E}, /* (FULLWIDTH TILDE) */
    {{'\xcb', '\x87'}, 2, 0x02C7}, /* (CARON) */
    {{'\xcb', '\x98'}, 2, 0x02D8}, /* (BREVE) */
    {{'\xcb', '\x9d'}, 2, 0x02DD}, /* (DOUBLE ACUTE ACCENT) */
    {{'\xcb', '\x9a'}, 2, 0x02DA}, /* (RING ABOVE) */
    {{'\xcb', '\x99'}, 2, 0x02D9}, /* (DOT ABOVE) */
    {{'\xc2', '\xb8'}, 2, 0x00B8}, /* (CEDILLA) */
    {{'\xcb', '\x9b'}, 2, 0x02DB}, /* (OGONEK) */
    {{'\xc2', '\xa1'}, 2, 0x00A1}, /* (INVERTED EXCLAMATION MARK) */
    {{'\xc2', '\xbf'}, 2, 0x00BF}, /* (INVERTED QUESTION MARK) */
    {{'\xcb', '\x90'}, 2, 0x02D0}, /* (MODIFIER LETTER TRIANGULAR COLON) */
    {{'\xe2', '\x88', '\xae'}, 3, 0x222E}, /* (CONTOUR INTEGRAL) */
    {{'\xe2', '\x88', '\x91'}, 3, 0x2211}, /* (N-ARY SUMMATION) */
    {{'\xe2', '\x88', '\x8f'}, 3, 0x220F}, /* (N-ARY PRODUCT) */
    {{'\xc2', '\xa4'}, 2, 0x00A4}, /* (CURRENCY SIGN) */
    {{'\xe2', '\x84', '\x89'}, 3, 0x2109}, /* (DEGREE FAHRENHEIT) */
    {{'\xe2', '\x80', '\xb0'}, 3, 0x2030}, /* (PER MILLE SIGN) */
    {{'\xe2', '\x97', '\x81'}, 3, 0x25C1}, /* (WHITE LEFT-POINTING TRIANGLE) */
    {{'\xe2', '\x97', '\x80'}, 3, 0x25C0}, /* (BLACK LEFT-POINTING TRIANGLE) */
    {{'\xe2', '\x96', '\xb7'}, 3, 0x25B7}, /* (WHITE RIGHT-POINTING TRIANGLE) */
    {{'\xe2', '\x96', '\xb6'}, 3, 0x25B6}, /* (BLACK RIGHT-POINTING TRIANGLE) */
    {{'\xe2', '\x99', '\xa4'}, 3, 0x2664}, /* (WHITE SPADE SUIT) */
    {{'\xe2', '\x99', '\xa0'}, 3, 0x2660}, /* (BLACK SPADE SUIT) */
    {{'\xe2', '\x99', '\xa1'}, 3, 0x2661}, /* (WHITE HEART SUIT) */
    {{'\xe2', '\x99', '\xa5'}, 3, 0x2665}, /* (BLACK HEART SUIT) */
    {{'\xe2', '\x99', '\xa7'}, 3, 0x2667}, /* (WHITE CLUB SUIT) */
    {{'\xe2', '\x99', '\xa3'}, 3, 0x2663}, /* (BLACK CLUB SUIT) */
    {{'\xe2', '\x8a', '\x99'}, 3, 0x2299}, /* (CIRCLED DOT OPERATOR) */
    {{'\xe2', '\x97', '\x88'}, 3, 0x25C8}, /* (WHITE DIAMOND CONTAINING BLACK SMALL DIAMOND) */
    {{'\xe2', '\x96', '\xa3'}, 3, 0x25A3}, /* (WHITE SQUARE CONTAINING BLACK SMALL SQUARE) */
    {{'\xe2', '\x97', '\x90'}, 3, 0x25D0}, /* (CIRCLE WITH LEFT HALF BLACK) */
    {{'\xe2', '\x97', '\x91'}, 3, 0x25D1}, /* (CIRCLE WITH RIGHT HALF BLACK) */
    {{'\xe2', '\x96', '\x92'}, 3, 0x2592}, /* (MEDIUM SHADE) */
    {{'\xe2', '\x96', '\xa4'}, 3, 0x25A4}, /* (SQUARE WITH HORIZONTAL FILL) */
    {{'\xe2', '\x96', '\xa5'}, 3, 0x25A5}, /* (SQUARE WITH VERTICAL FILL) */
    {{'\xe2', '\x96', '\xa8'}, 3, 0x25A8}, /* (SQUARE WITH UPPER RIGHT TO LOWER LEFT FILL) */
    {{'\xe2', '\x96', '\xa7'}, 3, 0x25A7}, /* (SQUARE WITH UPPER LEFT TO LOWER RIGHT FILL) */
    {{'\xe2', '\x96', '\xa6'}, 3, 0x25A6}, /* (SQUARE WITH ORTHOGONAL CROSSHATCH FILL) */
    {{'\xe2', '\x96', '\xa9'}, 3, 0x25A9}, /* (SQUARE WITH DIAGONAL CROSSHATCH FILL) */
    {{'\xe2', '\x99', '\xa8'}, 3, 0x2668}, /* (HOT SPRINGS) */
    {{'\xe2', '\x98', '\x8f'}, 3, 0x260F}, /* (WHITE TELEPHONE) */
    {{'\xe2', '\x98', '\x8e'}, 3, 0x260E}, /* (BLACK TELEPHONE) */
    {{'\xe2', '\x98', '\x9c'}, 3, 0x261C}, /* (WHITE LEFT POINTING INDEX) */
    {{'\xe2', '\x98', '\x9e'}, 3, 0x261E}, /* (WHITE RIGHT POINTING INDEX) */
    {{'\xc2', '\xb6'}, 2, 0x00B6}, /* (PILCROW SIGN) */
    {{'\xe2', '\x80', '\xa0'}, 3, 0x2020}, /* (DAGGER) */
    {{'\xe2', '\x80', '\xa1'}, 3, 0x2021}, /* (DOUBLE DAGGER) */
    {{'\xe2', '\x86', '\x95'}, 3, 0x2195}, /* (UP DOWN ARROW) */
    {{'\xe2', '\x86', '\x97'}, 3, 0x2197}, /* (NORTH EAST ARROW) */
    {{'\xe2', '\x86', '\x99'}, 3, 0x2199}, /* (SOUTH WEST ARROW) */
    {{'\xe2', '\x86', '\x96'}, 3, 0x2196}, /* (NORTH WEST ARROW) */
    {{'\xe2', '\x86', '\x98'}, 3, 0x2198}, /* (SOUTH EAST ARROW) */
    {{'\xe2', '\x99', '\xad'}, 3, 0x266D}, /* (MUSIC FLAT SIGN) */
    {{'\xe2', '\x99', '\xa9'}, 3, 0x2669}, /* (QUARTER NOTE) */
    {{'\xe2', '\x99', '\xaa'}, 3, 0x266A}, /* (EIGHTH NOTE) */
    {{'\xe2', '\x99', '\xac'}, 3, 0x266C}, /* (BEAMED SIXTEENTH NOTES) */
    {{'\xe3', '\x89', '\xbf'}, 3, 0x327F}, /* (KOREAN STANDARD SYMBOL) */
    {{'\xe3', '\x88', '\x9c'}, 3, 0x321C}, /* (PARENTHESIZED HANGUL CIEUC U) */
    {{'\xe2', '\x84', '\x96'}, 3, 0x2116}, /* (NUMERO SIGN) */
    {{'\xe3', '\x8f', '\x87'}, 3, 0x33C7}, /* (SQUARE CO) */
    {{'\xe2', '\x84', '\xa2'}, 3, 0x2122}, /* (TRADE MARK SIGN) */
    {{'\xe3', '\x8f', '\x82'}, 3, 0x33C2}, /* (SQUARE AM) */
    {{'\xe3', '\x8f', '\x98'}, 3, 0x33D8}, /* (SQUARE PM) */
    {{'\xe2', '\x84', '\xa1'}, 3, 0x2121}, /* (TELEPHONE SIGN) */
    {{'\xe2', '\x82', '\xac'}, 3, 0x20AC}, /* (EURO SIGN) */
    {{'\xc2', '\xae'}, 2, 0x00AE}, /* (REGISTERED SIGN) */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{'\xec', '\xa5', '\xb1'}, 3, 0xC971}, /* (HANGUL SYLLABLE JYUNJ) */
    {{'\xec', '\xa5', '\xb2'}, 3, 0xC972}, /* (HANGUL SYLLABLE JYUNH) */
    {{'\xec', '\xa5', '\xb3'}, 3, 0xC973}, /* (HANGUL SYLLABLE JYUD) */
    {{'\xec', '\xa5', '\xb5'}, 3, 0xC975}, /* (HANGUL SYLLABLE JYULG) */
    {{'\xec', '\xa5', '\xb6'}, 3, 0xC976}, /* (HANGUL SYLLABLE JYULM) */
    {{'\xec', '\xa5', '\xb7'}, 3, 0xC977}, /* (HANGUL SYLLABLE JYULB) */
    {{'\xec', '\xa5', '\xb8'}, 3, 0xC978}, /* (HANGUL SYLLABLE JYULS) */
    {{'\xec', '\xa5', '\xb9'}, 3, 0xC979}, /* (HANGUL SYLLABLE JYULT) */
    {{'\xec', '\xa5', '\xba'}, 3, 0xC97A}, /* (HANGUL SYLLABLE JYULP) */
    {{'\xec', '\xa5', '\xbb'}, 3, 0xC97B}, /* (HANGUL SYLLABLE JYULH) */
    {{'\xec', '\xa5', '\xbd'}, 3, 0xC97D}, /* (HANGUL SYLLABLE JYUB) */
    {{'\xec', '\xa5', '\xbe'}, 3, 0xC97E}, /* (HANGUL SYLLABLE JYUBS) */
    {{'\xec', '\xa5', '\xbf'}, 3, 0xC97F}, /* (HANGUL SYLLABLE JYUS) */
    {{'\xec', '\xa6', '\x80'}, 3, 0xC980}, /* (HANGUL SYLLABLE JYUSS) */
    {{'\xec', '\xa6', '\x81'}, 3, 0xC981}, /* (HANGUL SYLLABLE JYUNG) */
    {{'\xec', '\xa6', '\x82'}, 3, 0xC982}, /* (HANGUL SYLLABLE JYUJ) */
    {{'\xec', '\xa6', '\x83'}, 3, 0xC983}, /* (HANGUL SYLLABLE JYUC) */
    {{'\xec', '\xa6', '\x84'}, 3, 0xC984}, /* (HANGUL SYLLABLE JYUK) */
    {{'\xec', '\xa6', '\x85'}, 3, 0xC985}, /* (HANGUL SYLLABLE JYUT) */
    {{'\xec', '\xa6', '\x86'}, 3, 0xC986}, /* (HANGUL SYLLABLE JYUP) */
    {{'\xec', '\xa6', '\x87'}, 3, 0xC987}, /* (HANGUL SYLLABLE JYUH) */
    {{'\xec', '\xa6', '\x8a'}, 3, 0xC98A}, /* (HANGUL SYLLABLE JEUGG) */
    {{'\xec', '\xa6', '\x8b'}, 3, 0xC98B}, /* (HANGUL SYLLABLE JEUGS) */
    {{'\xec', '\xa6', '\x8d'}, 3, 0xC98D}, /* (HANGUL SYLLABLE JEUNJ) */
    {{'\xec', '\xa6', '\x8e'}, 3, 0xC98E}, /* (HANGUL SYLLABLE JEUNH) */
    {{'\xec', '\xa6', '\x8f'}, 3, 0xC98F}, /* (HANGUL SYLLABLE JEUD) */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{'\xec', '\xa6', '\x91'}, 3, 0xC991}, /* (HANGUL SYLLABLE JEULG) */
    {{'\xec', '\xa6', '\x92'}, 3, 0xC992}, /* (HANGUL SYLLABLE JEULM) */
    {{'\xec', '\xa6', '\x93'}, 3, 0xC993}, /* (HANGUL SYLLABLE JEULB) */
    {{'\xec', '\xa6', '\x94'}, 3, 0xC994}, /* (HANGUL SYLLABLE JEULS) */
    {{'\xec', '\xa6', '\x95'}, 3, 0xC995}, /* (HANGUL SYLLABLE JEULT) */
    {{'\xec', '\xa6', '\x96'}, 3, 0xC996}, /* (HANGUL SYLLABLE JEULP) */
    {{'\xec', '\xa6', '\x97'}, 3, 0xC997}, /* (HANGUL SYLLABLE JEULH) */
    {{'\xec', '\xa6', '\x9a'}, 3, 0xC99A}, /* (HANGUL SYLLABLE JEUBS) */
    {{'\xec', '\xa6', '\x9c'}, 3, 0xC99C}, /* (HANGUL SYLLABLE JEUSS) */
    {{'\xec', '\xa6', '\x9e'}, 3, 0xC99E}, /* (HANGUL SYLLABLE JEUJ) */
    {{'\xec', '\xa6', '\x9f'}, 3, 0xC99F}, /* (HANGUL SYLLABLE JEUC) */
    {{'\xec', '\xa6', '\xa0'}, 3, 0xC9A0}, /* (HANGUL SYLLABLE JEUK) */
    {{'\xec', '\xa6', '\xa1'}, 3, 0xC9A1}, /* (HANGUL SYLLABLE JEUT) */
    {{'\xec', '\xa6', '\xa2'}, 3, 0xC9A2}, /* (HANGUL SYLLABLE JEUP) */
    {{'\xec', '\xa6', '\xa3'}, 3, 0xC9A3}, /* (HANGUL SYLLABLE JEUH) */
    {{'\xec', '\xa6', '\xa4'}, 3, 0xC9A4}, /* (HANGUL SYLLABLE JYI) */
    {{'\xec', '\xa6', '\xa5'}, 3, 0xC9A5}, /* (HANGUL SYLLABLE JYIG) */
    {{'\xec', '\xa6', '\xa6'}, 3, 0xC9A6}, /* (HANGUL SYLLABLE JYIGG) */
    {{'\xec', '\xa6', '\xa7'}, 3, 0xC9A7}, /* (HANGUL SYLLABLE JYIGS) */
    {{'\xec', '\xa6', '\xa8'}, 3, 0xC9A8}, /* (HANGUL SYLLABLE JYIN) */
    {{'\xec', '\xa6', '\xa9'}, 3, 0xC9A9}, /* (HANGUL SYLLABLE JYINJ) */
    {{'\xec', '\xa6', '\xaa'}, 3, 0xC9AA}, /* (HANGUL SYLLABLE JYINH) */
    {{'\xec', '\xa6', '\xab'}, 3, 0xC9AB}, /* (HANGUL SYLLABLE JYID) */
    {{'\xec', '\xa6', '\xac'}, 3, 0xC9AC}, /* (HANGUL SYLLABLE JYIL) */
    {{'\xec', '\xa6', '\xad'}, 3, 0xC9AD}, /* (HANGUL SYLLABLE JYILG) */
    {{'\xec', '\xa6', '\xae'}, 3, 0xC9AE}, /* (HANGUL SYLLABLE JYILM) */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{'\xec', '\xa6', '\xaf'}, 3, 0xC9AF}, /* (HANGUL SYLLABLE JYILB) */
    {{'\xec', '\xa6', '\xb0'}, 3, 0xC9B0}, /* (HANGUL SYLLABLE JYILS) */
    {{'\xec', '\xa6', '\xb1'}, 3, 0xC9B1}, /* (HANGUL SYLLABLE JYILT) */
    {{'\xec', '\xa6', '\xb2'}, 3, 0xC9B2}, /* (HANGUL SYLLABLE JYILP) */
    {{'\xec', '\xa6', '\xb3'}, 3, 0xC9B3}, /* (HANGUL SYLLABLE JYILH) */
    {{'\xec', '\xa6', '\xb4'}, 3, 0xC9B4}, /* (HANGUL SYLLABLE JYIM) */
    {{'\xec', '\xa6', '\xb5'}, 3, 0xC9B5}, /* (HANGUL SYLLABLE JYIB) */
    {{'\xec', '\xa6', '\xb6'}, 3, 0xC9B6}, /* (HANGUL SYLLABLE JYIBS) */
    {{'\xec', '\xa6', '\xb7'}, 3, 0xC9B7}, /* (HANGUL SYLLABLE JYIS) */
    {{'\xec', '\xa6', '\xb8'}, 3, 0xC9B8}, /* (HANGUL SYLLABLE JYISS) */
    {{'\xec', '\xa6', '\xb9'}, 3, 0xC9B9}, /* (HANGUL SYLLABLE JYING) */
    {{'\xec', '\xa6', '\xba'}, 3, 0xC9BA}, /* (HANGUL SYLLABLE JYIJ) */
    {{'\xec', '\xa6', '\xbb'}, 3, 0xC9BB}, /* (HANGUL SYLLABLE JYIC) */
    {{'\xec', '\xa6', '\xbc'}, 3, 0xC9BC}, /* (HANGUL SYLLABLE JYIK) */
    {{'\xec', '\xa6', '\xbd'}, 3, 0xC9BD}, /* (HANGUL SYLLABLE JYIT) */
    {{'\xec', '\xa6', '\xbe'}, 3, 0xC9BE}, /* (HANGUL SYLLABLE JYIP) */
    {{'\xec', '\xa6', '\xbf'}, 3, 0xC9BF}, /* (HANGUL SYLLABLE JYIH) */
    {{'\xec', '\xa7', '\x82'}, 3, 0xC9C2}, /* (HANGUL SYLLABLE JIGG) */
    {{'\xec', '\xa7', '\x83'}, 3, 0xC9C3}, /* (HANGUL SYLLABLE JIGS) */
    {{'\xec', '\xa7', '\x85'}, 3, 0xC9C5}, /* (HANGUL SYLLABLE JINJ) */
    {{'\xec', '\xa7', '\x86'}, 3, 0xC9C6}, /* (HANGUL SYLLABLE JINH) */
    {{'\xec', '\xa7', '\x89'}, 3, 0xC9C9}, /* (HANGUL SYLLABLE JILG) */
    {{'\xec', '\xa7', '\x8b'}, 3, 0xC9CB}, /* (HANGUL SYLLABLE JILB) */
    {{'\xec', '\xa7', '\x8c'}, 3, 0xC9CC}, /* (HANGUL SYLLABLE JILS) */
    {{'\xec', '\xa7', '\x8d'}, 3, 0xC9CD}, /* (HANGUL SYLLABLE JILT) */
    {{'\xec', '\xa7', '\x8e'}, 3, 0xC9CE}, /* (HANGUL SYLLABLE JILP) */
    {{'\xec', '\xa7', '\x8f'}, 3, 0xC9CF}, /* (HANGUL SYLLABLE JILH) */
    {{'\xec', '\xa7', '\x92'}, 3, 0xC9D2}, /* (HANGUL SYLLABLE JIBS) */
    {{'\xec', '\xa7', '\x94'}, 3, 0xC9D4}, /* (HANGUL SYLLABLE JISS) */
    {{'\xec', '\xa7', '\x97'}, 3, 0xC9D7}, /* (HANGUL SYLLABLE JIC) */
    {{'\xec', '\xa7', '\x98'}, 3, 0xC9D8}, /* (HANGUL SYLLABLE JIK) */
    {{'\xec', '\xa7', '\x9b'}, 3, 0xC9DB}, /* (HANGUL SYLLABLE JIH) */
    {{'\xef', '\xbc', '\x81'}, 3, 0xFF01}, /* (FULLWIDTH EXCLAMATION MARK) */
    {{'\xef', '\xbc', '\x82'}, 3, 0xFF02}, /* (FULLWIDTH QUOTATION MARK) */
    {{'\xef', '\xbc', '\x83'}, 3, 0xFF03}, /* (FULLWIDTH NUMBER SIGN) */
    {{'\xef', '\xbc', '\x84'}, 3, 0xFF04}, /* (FULLWIDTH DOLLAR SIGN) */
    {{'\xef', '\xbc', '\x85'}, 3, 0xFF05}, /* (FULLWIDTH PERCENT SIGN) */
    {{'\xef', '\xbc', '\x86'}, 3, 0xFF06}, /* (FULLWIDTH AMPERSAND) */
    {{'\xef', '\xbc', '\x87'}, 3, 0xFF07}, /* (FULLWIDTH APOSTROPHE) */
    {{'\xef', '\xbc', '\x88'}, 3, 0xFF08}, /* (FULLWIDTH LEFT PARENTHESIS) */
    {{'\xef', '\xbc', '\x89'}, 3, 0xFF09}, /* (FULLWIDTH RIGHT PARENTHESIS) */
    {{'\xef', '\xbc', '\x8a'}, 3, 0xFF0A}, /* (FULLWIDTH ASTERISK) */
    {{'\xef', '\xbc', '\x8b'}, 3, 0xFF0B}, /* (FULLWIDTH PLUS SIGN) */
    {{'\xef', '\xbc', '\x8c'}, 3, 0xFF0C}, /* (FULLWIDTH COMMA) */
    {{'\xef', '\xbc', '\x8d'}, 3, 0xFF0D}, /* (FULLWIDTH HYPHEN-MINUS) */
    {{'\xef', '\xbc', '\x8e'}, 3, 0xFF0E}, /* (FULLWIDTH FULL STOP) */
    {{'\xef', '\xbc', '\x8f'}, 3, 0xFF0F}, /* (FULLWIDTH SOLIDUS) */
    {{'\xef', '\xbc', '\x90'}, 3, 0xFF10}, /* (FULLWIDTH DIGIT ZERO) */
    {{'\xef', '\xbc', '\x91'}, 3, 0xFF11}, /* (FULLWIDTH DIGIT ONE) */
    {{'\xef', '\xbc', '\x92'}, 3, 0xFF12}, /* (FULLWIDTH DIGIT TWO) */
    {{'\xef', '\xbc', '\x93'}, 3, 0xFF13}, /* (FULLWIDTH DIGIT THREE) */
    {{'\xef', '\xbc', '\x94'}, 3, 0xFF14}, /* (FULLWIDTH DIGIT FOUR) */
    {{'\xef', '\xbc', '\x95'}, 3, 0xFF15}, /* (FULLWIDTH DIGIT FIVE) */
    {{'\xef', '\xbc', '\x96'}, 3, 0xFF16}, /* (FULLWIDTH DIGIT SIX) */
    {{'\xef', '\xbc', '\x97'}, 3, 0xFF17}, /* (FULLWIDTH DIGIT SEVEN) */
    {{'\xef', '\xbc', '\x98'}, 3, 0xFF18}, /* (FULLWIDTH DIGIT EIGHT) */
    {{'\xef', '\xbc', '\x99'}, 3, 0xFF19}, /* (FULLWIDTH DIGIT NINE) */
    {{'\xef', '\xbc', '\x9a'}, 3, 0xFF1A}, /* (FULLWIDTH COLON) */
    {{'\xef', '\xbc', '\x9b'}, 3, 0xFF1B}, /* (FULLWIDTH SEMICOLON) */
    {{'\xef', '\xbc', '\x9c'}, 3, 0xFF1C}, /* (FULLWIDTH LESS-THAN SIGN) */
    {{'\xef', '\xbc', '\x9d'}, 3, 0xFF1D}, /* (FULLWIDTH EQUALS SIGN) */
    {{'\xef', '\xbc', '\x9e'}, 3, 0xFF1E}, /* (FULLWIDTH GREATER-THAN SIGN) */
    {{'\xef', '\xbc', '\x9f'}, 3, 0xFF1F}, /* (FULLWIDTH QUESTION MARK) */
    {{'\xef', '\xbc', '\xa0'}, 3, 0xFF20}, /* (FULLWIDTH COMMERCIAL AT) */
    {{'\xef', '\xbc', '\xa1'}, 3, 0xFF21}, /* (FULLWIDTH LATIN CAPITAL LETTER A) */
    {{'\xef', '\xbc', '\xa2'}, 3, 0xFF22}, /* (FULLWIDTH LATIN CAPITAL LETTER B) */
    {{'\xef', '\xbc', '\xa3'}, 3, 0xFF23}, /* (FULLWIDTH LATIN CAPITAL LETTER C) */
    {{'\xef', '\xbc', '\xa4'}, 3, 0xFF24}, /* (FULLWIDTH LATIN CAPITAL LETTER D) */
    {{'\xef', '\xbc', '\xa5'}, 3, 0xFF25}, /* (FULLWIDTH LATIN CAPITAL LETTER E) */
    {{'\xef', '\xbc', '\xa6'}, 3, 0xFF26}, /* (FULLWIDTH LATIN CAPITAL LETTER F) */
    {{'\xef', '\xbc', '\xa7'}, 3, 0xFF27}, /* (FULLWIDTH LATIN CAPITAL LETTER G) */
    {{'\xef', '\xbc', '\xa8'}, 3, 0xFF28}, /* (FULLWIDTH LATIN CAPITAL LETTER H) */
    {{'\xef', '\xbc', '\xa9'}, 3, 0xFF29}, /* (FULLWIDTH LATIN CAPITAL LETTER I) */
    {{'\xef', '\xbc', '\xaa'}, 3, 0xFF2A}, /* (FULLWIDTH LATIN CAPITAL LETTER J) */
    {{'\xef', '\xbc', '\xab'}, 3, 0xFF2B}, /* (FULLWIDTH LATIN CAPITAL LETTER K) */
    {{'\xef', '\xbc', '\xac'}, 3, 0xFF2C}, /* (FULLWIDTH LATIN CAPITAL LETTER L) */
    {{'\xef', '\xbc', '\xad'}, 3, 0xFF2D}, /* (FULLWIDTH LATIN CAPITAL LETTER M) */
    {{'\xef', '\xbc', '\xae'}, 3, 0xFF2E}, /* (FULLWIDTH LATIN CAPITAL LETTER N) */
    {{'\xef', '\xbc', '\xaf'}, 3, 0xFF2F}, /* (FULLWIDTH LATIN CAPITAL LETTER O) */
    {{'\xef', '\xbc', '\xb0'}, 3, 0xFF30}, /* (FULLWIDTH LATIN CAPITAL LETTER P) */
    {{'\xef', '\xbc', '\xb1'}, 3, 0xFF31}, /* (FULLWIDTH LATIN CAPITAL LETTER Q) */
    {{'\xef', '\xbc', '\xb2'}, 3, 0xFF32}, /* (FULLWIDTH LATIN CAPITAL LETTER R) */
    {{'\xef', '\xbc', '\xb3'}, 3, 0xFF33}, /* (FULLWIDTH LATIN CAPITAL LETTER S) */
    {{'\xef', '\xbc', '\xb4'}, 3, 0xFF34}, /* (FULLWIDTH LATIN CAPITAL LETTER T) */
    {{'\xef', '\xbc', '\xb5'}, 3, 0xFF35}, /* (FULLWIDTH LATIN CAPITAL LETTER U) */
    {{'\xef', '\xbc', '\xb6'}, 3, 0xFF36}, /* (FULLWIDTH LATIN CAPITAL LETTER V) */
    {{'\xef', '\xbc', '\xb7'}, 3, 0xFF37}, /* (FULLWIDTH LATIN CAPITAL LETTER W) */
    {{'\xef', '\xbc', '\xb8'}, 3, 0xFF38}, /* (FULLWIDTH LATIN CAPITAL LETTER X) */
    {{'\xef', '\xbc', '\xb9'}, 3, 0xFF39}, /* (FULLWIDTH LATIN CAPITAL LETTER Y) */
    {{'\xef', '\xbc', '\xba'}, 3, 0xFF3A}, /* (FULLWIDTH LATIN CAPITAL LETTER Z) */
    {{'\xef', '\xbc', '\xbb'}, 3, 0xFF3B}, /* (FULLWIDTH LEFT SQUARE BRACKET) */
    {{'\xef', '\xbf', '\xa6'}, 3, 0xFFE6}, /* (FULLWIDTH WON SIGN) */
    {{'\xef', '\xbc', '\xbd'}, 3, 0xFF3D}, /* (FULLWIDTH RIGHT SQUARE BRACKET) */
    {{'\xef', '\xbc', '\xbe'}, 3, 0xFF3E}, /* (FULLWIDTH CIRCUMFLEX ACCENT) */
    {{'\xef', '\xbc', '\xbf'}, 3, 0xFF3F}, /* (FULLWIDTH LOW LINE) */
    {{'\xef', '\xbd', '\x80'}, 3, 0xFF40}, /* (FULLWIDTH GRAVE ACCENT) */
    {{'\xef', '\xbd', '\x81'}, 3, 0xFF41}, /* (FULLWIDTH LATIN SMALL LETTER A) */
    {{'\xef', '\xbd', '\x82'}, 3, 0xFF42}, /* (FULLWIDTH LATIN SMALL LETTER B) */
    {{'\xef', '\xbd', '\x83'}, 3, 0xFF43}, /* (FULLWIDTH LATIN SMALL LETTER C) */
    {{'\xef', '\xbd', '\x84'}, 3, 0xFF44}, /* (FULLWIDTH LATIN SMALL LETTER D) */
    {{'\xef', '\xbd', '\x85'}, 3, 0xFF45}, /* (FULLWIDTH LATIN SMALL LETTER E) */
    {{'\xef', '\xbd', '\x86'}, 3, 0xFF46}, /* (FULLWIDTH LATIN SMALL LETTER F) */
    {{'\xef', '\xbd', '\x87'}, 3, 0xFF47}, /* (FULLWIDTH LATIN SMALL LETTER G) */
    {{'\xef', '\xbd', '\x88'}, 3, 0xFF48}, /* (FULLWIDTH LATIN SMALL LETTER H) */
    {{'\xef', '\xbd', '\x89'}, 3, 0xFF49}, /* (FULLWIDTH LATIN SMALL LETTER I) */
    {{'\xef', '\xbd', '\x8a'}, 3, 0xFF4A}, /* (FULLWIDTH LATIN SMALL LETTER J) */
    {{'\xef', '\xbd', '\x8b'}, 3, 0xFF4B}, /* (FULLWIDTH LATIN SMALL LETTER K) */
    {{'\xef', '\xbd', '\x8c'}, 3, 0xFF4C}, /* (FULLWIDTH LATIN SMALL LETTER L) */
    {{'\xef', '\xbd', '\x8d'}, 3, 0xFF4D}, /* (FULLWIDTH LATIN SMALL LETTER M) */
    {{'\xef', '\xbd', '\x8e'}, 3, 0xFF4E}, /* (FULLWIDTH LATIN SMALL LETTER N) */
    {{'\xef', '\xbd', '\x8f'}, 3, 0xFF4F}, /* (FULLWIDTH LATIN SMALL LETTER O) */
    {{'\xef', '\xbd', '\x90'}, 3, 0xFF50}, /* (FULLWIDTH LATIN SMALL LETTER P) */
    {{'\xef', '\xbd', '\x91'}, 3, 0xFF51}, /* (FULLWIDTH LATIN SMALL LETTER Q) */
    {{'\xef', '\xbd', '\x92'}, 3, 0xFF52}, /* (FULLWIDTH LATIN SMALL LETTER R) */
    {{'\xef', '\xbd', '\x93'}, 3, 0xFF53}, /* (FULLWIDTH LATIN SMALL LETTER S) */
    {{'\xef', '\xbd', '\x94'}, 3, 0xFF54}, /* (FULLWIDTH LATIN SMALL LETTER T) */
    {{'\xef', '\xbd', '\x95'}, 3, 0xFF55}, /* (FULLWIDTH LATIN SMALL LETTER U) */
    {{'\xef', '\xbd', '\x96'}, 3, 0xFF56}, /* (FULLWIDTH LATIN SMALL LETTER V) */
    {{'\xef', '\xbd', '\x97'}, 3, 0xFF57}, /* (FULLWIDTH LATIN SMALL LETTER W) */
    {{'\xef', '\xbd', '\x98'}, 3, 0xFF58}, /* (FULLWIDTH LATIN SMALL LETTER X) */
    {{'\xef', '\xbd', '\x99'}, 3, 0xFF59}, /* (FULLWIDTH LATIN SMALL LETTER Y) */
    {{'\xef', '\xbd', '\x9a'}, 3, 0xFF5A}, /* (FULLWIDTH LATIN SMALL LETTER Z) */
    {{'\xef', '\xbd', '\x9b'}, 3, 0xFF5B}, /* (FULLWIDTH LEFT CURLY BRACKET) */
    {{'\xef', '\xbd', '\x9c'}, 3, 0xFF5C}, /* (FULLWIDTH VERTICAL LINE) */
    {{'\xef', '\xbd', '\x9d'}, 3, 0xFF5D}, /* (FULLWIDTH RIGHT CURLY BRACKET) */
    {{'\xef', '\xbf', '\xa3'}, 3, 0xFFE3}, /* (FULLWIDTH MACRON) */
    {{'\xec', '\xa7', '\x9e'}, 3, 0xC9DE}, /* (HANGUL SYLLABLE JJAGG) */
    {{'\xec', '\xa7', '\x9f'}, 3, 0xC9DF}, /* (HANGUL SYLLABLE JJAGS) */
    {{'\xec', '\xa7', '\xa1'}, 3, 0xC9E1}, /* (HANGUL SYLLABLE JJANJ) */
    {{'\xec', '\xa7', '\xa3'}, 3, 0xC9E3}, /* (HANGUL SYLLABLE JJAD) */
    {{'\xec', '\xa7', '\xa5'}, 3, 0xC9E5}, /* (HANGUL SYLLABLE JJALG) */
    {{'\xec', '\xa7', '\xa6'}, 3, 0xC9E6}, /* (HANGUL SYLLABLE JJALM) */
    {{'\xec', '\xa7', '\xa8'}, 3, 0xC9E8}, /* (HANGUL SYLLABLE JJALS) */
    {{'\xec', '\xa7', '\xa9'}, 3, 0xC9E9}, /* (HANGUL SYLLABLE JJALT) */
    {{'\xec', '\xa7', '\xaa'}, 3, 0xC9EA}, /* (HANGUL SYLLABLE JJALP) */
    {{'\xec', '\xa7', '\xab'}, 3, 0xC9EB}, /* (HANGUL SYLLABLE JJALH) */
    {{'\xec', '\xa7', '\xae'}, 3, 0xC9EE}, /* (HANGUL SYLLABLE JJABS) */
    {{'\xec', '\xa7', '\xb2'}, 3, 0xC9F2}, /* (HANGUL SYLLABLE JJAJ) */
    {{'\xec', '\xa7', '\xb3'}, 3, 0xC9F3}, /* (HANGUL SYLLABLE JJAC) */
    {{'\xec', '\xa7', '\xb4'}, 3, 0xC9F4}, /* (HANGUL SYLLABLE JJAK) */
    {{'\xec', '\xa7', '\xb5'}, 3, 0xC9F5}, /* (HANGUL SYLLABLE JJAT) */
    {{'\xec', '\xa7', '\xb6'}, 3, 0xC9F6}, /* (HANGUL SYLLABLE JJAP) */
    {{'\xec', '\xa7', '\xb7'}, 3, 0xC9F7}, /* (HANGUL SYLLABLE JJAH) */
    {{'\xec', '\xa7', '\xba'}, 3, 0xC9FA}, /* (HANGUL SYLLABLE JJAEGG) */
    {{'\xec', '\xa7', '\xbb'}, 3, 0xC9FB}, /* (HANGUL SYLLABLE JJAEGS) */
    {{'\xec', '\xa7', '\xbd'}, 3, 0xC9FD}, /* (HANGUL SYLLABLE JJAENJ) */
    {{'\xec', '\xa7', '\xbe'}, 3, 0xC9FE}, /* (HANGUL SYLLABLE JJAENH) */
    {{'\xec', '\xa7', '\xbf'}, 3, 0xC9FF}, /* (HANGUL SYLLABLE JJAED) */
    {{'\xec', '\xa8', '\x81'}, 3, 0xCA01}, /* (HANGUL SYLLABLE JJAELG) */
    {{'\xec', '\xa8', '\x82'}, 3, 0xCA02}, /* (HANGUL SYLLABLE JJAELM) */
    {{'\xec', '\xa8', '\x83'}, 3, 0xCA03}, /* (HANGUL SYLLABLE JJAELB) */
    {{'\xec', '\xa8', '\x84'}, 3, 0xCA04}, /* (HANGUL SYLLABLE JJAELS) */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{'\xec', '\xa8', '\x85'}, 3, 0xCA05}, /* (HANGUL SYLLABLE JJAELT) */
    {{'\xec', '\xa8', '\x86'}, 3, 0xCA06}, /* (HANGUL SYLLABLE JJAELP) */
    {{'\xec', '\xa8', '\x87'}, 3, 0xCA07}, /* (HANGUL SYLLABLE JJAELH) */
    {{'\xec', '\xa8', '\x8a'}, 3, 0xCA0A}, /* (HANGUL SYLLABLE JJAEBS) */
    {{'\xec', '\xa8', '\x8e'}, 3, 0xCA0E}, /* (HANGUL SYLLABLE JJAEJ) */
    {{'\xec', '\xa8', '\x8f'}, 3, 0xCA0F}, /* (HANGUL SYLLABLE JJAEC) */
    {{'\xec', '\xa8', '\x90'}, 3, 0xCA10}, /* (HANGUL SYLLABLE JJAEK) */
    {{'\xec', '\xa8', '\x91'}, 3, 0xCA11}, /* (HANGUL SYLLABLE JJAET) */
    {{'\xec', '\xa8', '\x92'}, 3, 0xCA12}, /* (HANGUL SYLLABLE JJAEP) */
    {{'\xec', '\xa8', '\x93'}, 3, 0xCA13}, /* (HANGUL SYLLABLE JJAEH) */
    {{'\xec', '\xa8', '\x95'}, 3, 0xCA15}, /* (HANGUL SYLLABLE JJYAG) */
    {{'\xec', '\xa8', '\x96'}, 3, 0xCA16}, /* (HANGUL SYLLABLE JJYAGG) */
    {{'\xec', '\xa8', '\x97'}, 3, 0xCA17}, /* (HANGUL SYLLABLE JJYAGS) */
    {{'\xec', '\xa8', '\x99'}, 3, 0xCA19}, /* (HANGUL SYLLABLE JJYANJ) */
    {{'\xec', '\xa8', '\x9a'}, 3, 0xCA1A}, /* (HANGUL SYLLABLE JJYANH) */
    {{'\xec', '\xa8', '\x9b'}, 3, 0xCA1B}, /* (HANGUL SYLLABLE JJYAD) */
    {{'\xec', '\xa8', '\x9c'}, 3, 0xCA1C}, /* (HANGUL SYLLABLE JJYAL) */
    {{'\xec', '\xa8', '\x9d'}, 3, 0xCA1D}, /* (HANGUL SYLLABLE JJYALG) */
    {{'\xec', '\xa8', '\x9e'}, 3, 0xCA1E}, /* (HANGUL SYLLABLE JJYALM) */
    {{'\xec', '\xa8', '\x9f'}, 3, 0xCA1F}, /* (HANGUL SYLLABLE JJYALB) */
    {{'\xec', '\xa8', '\xa0'}, 3, 0xCA20}, /* (HANGUL SYLLABLE JJYALS) */
    {{'\xec', '\xa8', '\xa1'}, 3, 0xCA21}, /* (HANGUL SYLLABLE JJYALT) */
    {{'\xec', '\xa8', '\xa2'}, 3, 0xCA22}, /* (HANGUL SYLLABLE JJYALP) */
    {{'\xec', '\xa8', '\xa3'}, 3, 0xCA23}, /* (HANGUL SYLLABLE JJYALH) */
    {{'\xec', '\xa8', '\xa4'}, 3, 0xCA24}, /* (HANGUL SYLLABLE JJYAM) */
    {{'\xec', '\xa8', '\xa5'}, 3, 0xCA25}, /* (HANGUL SYLLABLE JJYAB) */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{'\xec', '\xa8', '\xa6'}, 3, 0xCA26}, /* (HANGUL SYLLABLE JJYABS) */
    {{'\xec', '\xa8', '\xa7'}, 3, 0xCA27}, /* (HANGUL SYLLABLE JJYAS) */
    {{'\xec', '\xa8', '\xa8'}, 3, 0xCA28}, /* (HANGUL SYLLABLE JJYASS) */
    {{'\xec', '\xa8', '\xaa'}, 3, 0xCA2A}, /* (HANGUL SYLLABLE JJYAJ) */
    {{'\xec', '\xa8', '\xab'}, 3, 0xCA2B}, /* (HANGUL SYLLABLE JJYAC) */
    {{'\xec', '\xa8', '\xac'}, 3, 0xCA2C}, /* (HANGUL SYLLABLE JJYAK) */
    {{'\xec', '\xa8', '\xad'}, 3, 0xCA2D}, /* (HANGUL SYLLABLE JJYAT) */
    {{'\xec', '\xa8', '\xae'}, 3, 0xCA2E}, /* (HANGUL SYLLABLE JJYAP) */
    {{'\xec', '\xa8', '\xaf'}, 3, 0xCA2F}, /* (HANGUL SYLLABLE JJYAH) */
    {{'\xec', '\xa8', '\xb0'}, 3, 0xCA30}, /* (HANGUL SYLLABLE JJYAE) */
    {{'\xec', '\xa8', '\xb1'}, 3, 0xCA31}, /* (HANGUL SYLLABLE JJYAEG) */
    {{'\xec', '\xa8', '\xb2'}, 3, 0xCA32}, /* (HANGUL SYLLABLE JJYAEGG) */
    {{'\xec', '\xa8', '\xb3'}, 3, 0xCA33}, /* (HANGUL SYLLABLE JJYAEGS) */
    {{'\xec', '\xa8', '\xb4'}, 3, 0xCA34}, /* (HANGUL SYLLABLE JJYAEN) */
    {{'\xec', '\xa8', '\xb5'}, 3, 0xCA35}, /* (HANGUL SYLLABLE JJYAENJ) */
    {{'\xec', '\xa8', '\xb6'}, 3, 0xCA36}, /* (HANGUL SYLLABLE JJYAENH) */
    {{'\xec', '\xa8', '\xb7'}, 3, 0xCA37}, /* (HANGUL SYLLABLE JJYAED) */
    {{'\xec', '\xa8', '\xb8'}, 3, 0xCA38}, /* (HANGUL SYLLABLE JJYAEL) */
    {{'\xec', '\xa8', '\xb9'}, 3, 0xCA39}, /* (HANGUL SYLLABLE JJYAELG) */
    {{'\xec', '\xa8', '\xba'}, 3, 0xCA3A}, /* (HANGUL SYLLABLE JJYAELM) */
    {{'\xec', '\xa8', '\xbb'}, 3, 0xCA3B}, /* (HANGUL SYLLABLE JJYAELB) */
    {{'\xec', '\xa8', '\xbc'}, 3, 0xCA3C}, /* (HANGUL SYLLABLE JJYAELS) */
    {{'\xec', '\xa8', '\xbd'}, 3, 0xCA3D}, /* (HANGUL SYLLABLE JJYAELT) */
    {{'\xec', '\xa8', '\xbe'}, 3, 0xCA3E}, /* (HANGUL SYLLABLE JJYAELP) */
    {{'\xec', '\xa8', '\xbf'}, 3, 0xCA3F}, /* (HANGUL SYLLABLE JJYAELH) */
    {{'\xec', '\xa9', '\x80'}, 3, 0xCA40}, /* (HANGUL SYLLABLE JJYAEM) */
    {{'\xec', '\xa9', '\x81'}, 3, 0xCA41}, /* (HANGUL SYLLABLE JJYAEB) */
    {{'\xec', '\xa9', '\x82'}, 3, 0xCA42}, /* (HANGUL SYLLABLE JJYAEBS) */
    {{'\xec', '\xa9', '\x83'}, 3, 0xCA43}, /* (HANGUL SYLLABLE JJYAES) */
    {{'\xec', '\xa9', '\x84'}, 3, 0xCA44}, /* (HANGUL SYLLABLE JJYAESS) */
    {{'\xec', '\xa9', '\x85'}, 3, 0xCA45}, /* (HANGUL SYLLABLE JJYAENG) */
    {{'\xec', '\xa9', '\x86'}, 3, 0xCA46}, /* (HANGUL SYLLABLE JJYAEJ) */
    {{'\xe3', '\x84', '\xb1'}, 3, 0x3131}, /* (HANGUL LETTER KIYEOK) */
    {{'\xe3', '\x84', '\xb2'}, 3, 0x3132}, /* (HANGUL LETTER SSANGKIYEOK) */
    {{'\xe3', '\x84', '\xb3'}, 3, 0x3133}, /* (HANGUL LETTER KIYEOK-SIOS) */
    {{'\xe3', '\x84', '\xb4'}, 3, 0x3134}, /* (HANGUL LETTER NIEUN) */
    {{'\xe3', '\x84', '\xb5'}, 3, 0x3135}, /* (HANGUL LETTER NIEUN-CIEUC) */
    {{'\xe3', '\x84', '\xb6'}, 3, 0x3136}, /* (HANGUL LETTER NIEUN-HIEUH) */
    {{'\xe3', '\x84', '\xb7'}, 3, 0x3137}, /* (HANGUL LETTER TIKEUT) */
    {{'\xe3', '\x84', '\xb8'}, 3, 0x3138}, /* (HANGUL LETTER SSANGTIKEUT) */
    {{'\xe3', '\x84', '\xb9'}, 3, 0x3139}, /* (HANGUL LETTER RIEUL) */
    {{'\xe3', '\x84', '\xba'}, 3, 0x313A}, /* (HANGUL LETTER RIEUL-KIYEOK) */
    {{'\xe3', '\x84', '\xbb'}, 3, 0x313B}, /* (HANGUL LETTER RIEUL-MIEUM) */
    {{'\xe3', '\x84', '\xbc'}, 3, 0x313C}, /* (HANGUL LETTER RIEUL-PIEUP) */
    {{'\xe3', '\x84', '\xbd'}, 3, 0x313D}, /* (HANGUL LETTER RIEUL-SIOS) */
    {{'\xe3', '\x84', '\xbe'}, 3, 0x313E}, /* (HANGUL LETTER RIEUL-THIEUTH) */
    {{'\xe3', '\x84', '\xbf'}, 3, 0x313F}, /* (HANGUL LETTER RIEUL-PHIEUPH) */
    {{'\xe3', '\x85', '\x80'}, 3, 0x3140}, /* (HANGUL LETTER RIEUL-HIEUH) */
    {{'\xe3', '\x85', '\x81'}, 3, 0x3141}, /* (HANGUL LETTER MIEUM) */
    {{'\xe3', '\x85', '\x82'}, 3, 0x3142}, /* (HANGUL LETTER PIEUP) */
    {{'\xe3', '\x85', '\x83'}, 3, 0x3143}, /* (HANGUL LETTER SSANGPIEUP) */
    {{'\xe3', '\x85', '\x84'}, 3, 0x3144}, /* (HANGUL LETTER PIEUP-SIOS) */
    {{'\xe3', '\x85', '\x85'}, 3, 0x3145}, /* (HANGUL LETTER SIOS) */
    {{'\xe3', '\x85', '\x86'}, 3, 0x3146}, /* (HANGUL LETTER SSANGSIOS) */
    {{'\xe3', '\x85', '\x87'}, 3, 0x3147}, /* (HANGUL LETTER IEUNG) */
    {{'\xe3', '\x85', '\x88'}, 3, 0x3148}, /* (HANGUL LETTER CIEUC) */
    {{'\xe3', '\x85', '\x89'}, 3, 0x3149}, /* (HANGUL LETTER SSANGCIEUC) */
    {{'\xe3', '\x85', '\x8a'}, 3, 0x314A}, /* (HANGUL LETTER CHIEUCH) */
    {{'\xe3', '\x85', '\x8b'}, 3, 0x314B}, /* (HANGUL LETTER KHIEUKH) */
    {{'\xe3', '\x85', '\x8c'}, 3, 0x314C}, /* (HANGUL LETTER THIEUTH) */
    {{'\xe3', '\x85', '\x8d'}, 3, 0x314D}, /* (HANGUL LETTER PHIEUPH) */
    {{'\xe3', '\x85', '\x8e'}, 3, 0x314E}, /* (HANGUL LETTER HIEUH) */
    {{'\xe3', '\x85', '\x8f'}, 3, 0x314F}, /* (HANGUL LETTER A) */
    {{'\xe3', '\x85', '\x90'}, 3, 0x3150}, /* (HANGUL LETTER AE) */
    {{'\xe3', '\x85', '\x91'}, 3, 0x3151}, /* (HANGUL LETTER YA) */
    {{'\xe3', '\x85', '\x92'}, 3, 0x3152}, /* (HANGUL LETTER YAE) */
    {{'\xe3', '\x85', '\x93'}, 3, 0x3153}, /* (HANGUL LETTER EO) */
    {{'\xe3', '\x85', '\x94'}, 3, 0x3154}, /* (HANGUL LETTER E) */
    {{'\xe3', '\x85', '\x95'}, 3, 0x3155}, /* (HANGUL LETTER YEO) */
    {{'\xe3', '\x85', '\x96'}, 3, 0x3156}, /* (HANGUL LETTER YE) */
    {{'\xe3', '\x85', '\x97'}, 3, 0x3157}, /* (HANGUL LETTER O) */
    {{'\xe3', '\x85', '\x98'}, 3, 0x3158}, /* (HANGUL LETTER WA) */
    {{'\xe3', '\x85', '\x99'}, 3, 0x3159}, /* (HANGUL LETTER WAE) */
    {{'\xe3', '\x85', '\x9a'}, 3, 0x315A}, /* (HANGUL LETTER OE) */
    {{'\xe3', '\x85', '\x9b'}, 3, 0x315B}, /* (HANGUL LETTER YO) */
    {{'\xe3', '\x85', '\x9c'}, 3, 0x315C}, /* (HANGUL LETTER U) */
    {{'\xe3', '\x85', '\x9d'}, 3, 0x315D}, /* (HANGUL LETTER WEO) */
    {{'\xe3', '\x85', '\x9e'}, 3, 0x315E}, /* (HANGUL LETTER WE) */
    {{'\xe3', '\x85', '\x9f'}, 3, 0x315F}, /* (HANGUL LETTER WI) */
    {{'\xe3', '\x85', '\xa0'}, 3, 0x3160}, /* (HANGUL LETTER YU) */
    {{'\xe3', '\x85', '\xa1'}, 3, 0x3161}, /* (HANGUL LETTER EU) */
    {{'\xe3', '\x85', '\xa2'}, 3, 0x3162}, /* (HANGUL LETTER YI) */
    {{'\xe3', '\x85', '\xa3'}, 3, 0x3163}, /* (HANGUL LETTER I) */
    {{'\xe3', '\x85', '\xa4'}, 3, 0x3164}, /* (HANGUL FILLER) */
    {{'\xe3', '\x85', '\xa5'}, 3, 0x3165}, /* (HANGUL LETTER SSANGNIEUN) */
    {{'\xe3', '\x85', '\xa6'}, 3, 0x3166}, /* (HANGUL LETTER NIEUN-TIKEUT) */
    {{'\xe3', '\x85', '\xa7'}, 3, 0x3167}, /* (HANGUL LETTER NIEUN-SIOS) */
    {{'\xe3', '\x85', '\xa8'}, 3, 0x3168}, /* (HANGUL LETTER NIEUN-PANSIOS) */
    {{'\xe3', '\x85', '\xa9'}, 3, 0x3169}, /* (HANGUL LETTER RIEUL-KIYEOK-SIOS) */
    {{'\xe3', '\x85', '\xaa'}, 3, 0x316A}, /* (HANGUL LETTER RIEUL-TIKEUT) */
    {{'\xe3', '\x85', '\xab'}, 3, 0x316B}, /* (HANGUL LETTER RIEUL-PIEUP-SIOS) */
    {{'\xe3', '\x85', '\xac'}, 3, 0x316C}, /* (HANGUL LETTER RIEUL-PANSIOS) */
    {{'\xe3', '\x85', '\xad'}, 3, 0x316D}, /* (HANGUL LETTER RIEUL-YEORINHIEUH) */
    {{'\xe3', '\x85', '\xae'}, 3, 0x316E}, /* (HANGUL LETTER MIEUM-PIEUP) */
    {{'\xe3', '\x85', '\xaf'}, 3, 0x316F}, /* (HANGUL LETTER MIEUM-SIOS) */
    {{'\xe3', '\x85', '\xb0'}, 3, 0x3170}, /* (HANGUL LETTER MIEUM-PANSIOS) */
    {{'\xe3', '\x85', '\xb1'}, 3, 0x3171}, /* (HANGUL LETTER KAPYEOUNMIEUM) */
    {{'\xe3', '\x85', '\xb2'}, 3, 0x3172}, /* (HANGUL LETTER PIEUP-KIYEOK) */
    {{'\xe3', '\x85', '\xb3'}, 3, 0x3173}, /* (HANGUL LETTER PIEUP-TIKEUT) */
    {{'\xe3', '\x85', '\xb4'}, 3, 0x3174}, /* (HANGUL LETTER PIEUP-SIOS-KIYEOK) */
    {{'\xe3', '\x85', '\xb5'}, 3, 0x3175}, /* (HANGUL LETTER PIEUP-SIOS-TIKEUT) */
    {{'\xe3', '\x85', '\xb6'}, 3, 0x3176}, /* (HANGUL LETTER PIEUP-CIEUC) */
    {{'\xe3', '\x85', '\xb7'}, 3, 0x3177}, /* (HANGUL LETTER PIEUP-THIEUTH) */
    {{'\xe3', '\x85', '\xb8'}, 3, 0x3178}, /* (HANGUL LETTER KAPYEOUNPIEUP) */
    {{'\xe3', '\x85', '\xb9'}, 3, 0x3179}, /* (HANGUL LETTER KAPYEOUNSSANGPIEUP) */
    {{'\xe3', '\x85', '\xba'}, 3, 0x317A}, /* (HANGUL LETTER SIOS-KIYEOK) */
    {{'\xe3', '\x85', '\xbb'}, 3, 0x317B}, /* (HANGUL LETTER SIOS-NIEUN) */
    {{'\xe3', '\x85', '\xbc'}, 3, 0x317C}, /* (HANGUL LETTER SIOS-TIKEUT) */
    {{'\xe3', '\x85', '\xbd'}, 3, 0x317D}, /* (HANGUL LETTER SIOS-PIEUP) */
    {{'\xe3', '\x85', '\xbe'}, 3, 0x317E}, /* (HANGUL LETTER SIOS-CIEUC) */
    {{'\xe3', '\x85', '\xbf'}, 3, 0x317F}, /* (HANGUL LETTER PANSIOS) */
    {{'\xe3', '\x86', '\x80'}, 3, 0x3180}, /* (HANGUL LETTER SSANGIEUNG) */
    {{'\xe3', '\x86', '\x81'}, 3, 0x3181}, /* (HANGUL LETTER YESIEUNG) */
    {{'\xe3', '\x86', '\x82'}, 3, 0x3182}, /* (HANGUL LETTER YESIEUNG-SIOS) */
    {{'\xe3', '\x86', '\x83'}, 3, 0x3183}, /* (HANGUL LETTER YESIEUNG-PANSIOS) */
    {{'\xe3', '\x86', '\x84'}, 3, 0x3184}, /* (HANGUL LETTER KAPYEOUNPHIEUPH) */
    {{'\xe3', '\x86', '\x85'}, 3, 0x3185}, /* (HANGUL LETTER SSANGHIEUH) */
    {{'\xe3', '\x86', '\x86'}, 3, 0x3186}, /* (HANGUL LETTER YEORINHIEUH) */
    {{'\xe3', '\x86', '\x87'}, 3, 0x3187}, /* (HANGUL LETTER YO-YA) */
    {{'\xe3', '\x86', '\x88'}, 3, 0x3188}, /* (HANGUL LETTER YO-YAE) */
    {{'\xe3', '\x86', '\x89'}, 3, 0x3189}, /* (HANGUL LETTER YO-I) */
    {{'\xe3', '\x86', '\x8a'}, 3, 0x318A}, /* (HANGUL LETTER YU-YEO) */
    {{'\xe3', '\x86', '\x8b'}, 3, 0x318B}, /* (HANGUL LETTER YU-YE) */
    {{'\xe3', '\x86', '\x8c'}, 3, 0x318C}, /* (HANGUL LETTER YU-I) */
    {{'\xe3', '\x86', '\x8d'}, 3, 0x318D}, /* (HANGUL LETTER ARAEA) */
    {{'\xe3', '\x86', '\x8e'}, 3, 0x318E}, /* (HANGUL LETTER ARAEAE) */
    {{'\xec', '\xa9', '\x87'}, 3, 0xCA47}, /* (HANGUL SYLLABLE JJYAEC) */
    {{'\xec', '\xa9', '\x88'}, 3, 0xCA48}, /* (HANGUL SYLLABLE JJYAEK) */
    {{'\xec', '\xa9', '\x89'}, 3, 0xCA49}, /* (HANGUL SYLLABLE JJYAET) */
    {{'\xec', '\xa9', '\x8a'}, 3, 0xCA4A}, /* (HANGUL SYLLABLE JJYAEP) */
    {{'\xec', '\xa9', '\x8b'}, 3, 0xCA4B}, /* (HANGUL SYLLABLE JJYAEH) */
    {{'\xec', '\xa9', '\x8e'}, 3, 0xCA4E}, /* (HANGUL SYLLABLE JJEOGG) */
    {{'\xec', '\xa9', '\x8f'}, 3, 0xCA4F}, /* (HANGUL SYLLABLE JJEOGS) */
    {{'\xec', '\xa9', '\x91'}, 3, 0xCA51}, /* (HANGUL SYLLABLE JJEONJ) */
    {{'\xec', '\xa9', '\x92'}, 3, 0xCA52}, /* (HANGUL SYLLABLE JJEONH) */
    {{'\xec', '\xa9', '\x93'}, 3, 0xCA53}, /* (HANGUL SYLLABLE JJEOD) */
    {{'\xec', '\xa9', '\x95'}, 3, 0xCA55}, /* (HANGUL SYLLABLE JJEOLG) */
    {{'\xec', '\xa9', '\x96'}, 3, 0xCA56}, /* (HANGUL SYLLABLE JJEOLM) */
    {{'\xec', '\xa9', '\x97'}, 3, 0xCA57}, /* (HANGUL SYLLABLE JJEOLB) */
    {{'\xec', '\xa9', '\x98'}, 3, 0xCA58}, /* (HANGUL SYLLABLE JJEOLS) */
    {{'\xec', '\xa9', '\x99'}, 3, 0xCA59}, /* (HANGUL SYLLABLE JJEOLT) */
    {{'\xec', '\xa9', '\x9a'}, 3, 0xCA5A}, /* (HANGUL SYLLABLE JJEOLP) */
    {{'\xec', '\xa9', '\x9b'}, 3, 0xCA5B}, /* (HANGUL SYLLABLE JJEOLH) */
    {{'\xec', '\xa9', '\x9e'}, 3, 0xCA5E}, /* (HANGUL SYLLABLE JJEOBS) */
    {{'\xec', '\xa9', '\xa2'}, 3, 0xCA62}, /* (HANGUL SYLLABLE JJEOJ) */
    {{'\xec', '\xa9', '\xa3'}, 3, 0xCA63}, /* (HANGUL SYLLABLE JJEOC) */
    {{'\xec', '\xa9', '\xa4'}, 3, 0xCA64}, /* (HANGUL SYLLABLE JJEOK) */
    {{'\xec', '\xa9', '\xa5'}, 3, 0xCA65}, /* (HANGUL SYLLABLE JJEOT) */
    {{'\xec', '\xa9', '\xa6'}, 3, 0xCA66}, /* (HANGUL SYLLABLE JJEOP) */
    {{'\xec', '\xa9', '\xa7'}, 3, 0xCA67}, /* (HANGUL SYLLABLE JJEOH) */
    {{'\xec', '\xa9', '\xa9'}, 3, 0xCA69}, /* (HANGUL SYLLABLE JJEG) */
    {{'\xec', '\xa9', '\xaa'}, 3, 0xCA6A}, /* (HANGUL SYLLABLE JJEGG) */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{'\xec', '\xa9', '\xab'}, 3, 0xCA6B}, /* (HANGUL SYLLABLE JJEGS) */
    {{'\xec', '\xa9', '\xac'}, 3, 0xCA6C}, /* (HANGUL SYLLABLE JJEN) */
    {{'\xec', '\xa9', '\xad'}, 3, 0xCA6D}, /* (HANGUL SYLLABLE JJENJ) */
    {{'\xec', '\xa9', '\xae'}, 3, 0xCA6E}, /* (HANGUL SYLLABLE JJENH) */
    {{'\xec', '\xa9', '\xaf'}, 3, 0xCA6F}, /* (HANGUL SYLLABLE JJED) */
    {{'\xec', '\xa9', '\xb0'}, 3, 0xCA70}, /* (HANGUL SYLLABLE JJEL) */
    {{'\xec', '\xa9', '\xb1'}, 3, 0xCA71}, /* (HANGUL SYLLABLE JJELG) */
    {{'\xec', '\xa9', '\xb2'}, 3, 0xCA72}, /* (HANGUL SYLLABLE JJELM) */
    {{'\xec', '\xa9', '\xb3'}, 3, 0xCA73}, /* (HANGUL SYLLABLE JJELB) */
    {{'\xec', '\xa9', '\xb4'}, 3, 0xCA74}, /* (HANGUL SYLLABLE JJELS) */
    {{'\xec', '\xa9', '\xb5'}, 3, 0xCA75}, /* (HANGUL SYLLABLE JJELT) */
    {{'\xec', '\xa9', '\xb6'}, 3, 0xCA76}, /* (HANGUL SYLLABLE JJELP) */
    {{'\xec', '\xa9', '\xb7'}, 3, 0xCA77}, /* (HANGUL SYLLABLE JJELH) */
    {{'\xec', '\xa9', '\xb8'}, 3, 0xCA78}, /* (HANGUL SYLLABLE JJEM) */
    {{'\xec', '\xa9', '\xb9'}, 3, 0xCA79}, /* (HANGUL SYLLABLE JJEB) */
    {{'\xec', '\xa9', '\xba'}, 3, 0xCA7A}, /* (HANGUL SYLLABLE JJEBS) */
    {{'\xec', '\xa9', '\xbb'}, 3, 0xCA7B}, /* (HANGUL SYLLABLE JJES) */
    {{'\xec', '\xa9', '\xbc'}, 3, 0xCA7C}, /* (HANGUL SYLLABLE JJESS) */
    {{'\xec', '\xa9', '\xbe'}, 3, 0xCA7E}, /* (HANGUL SYLLABLE JJEJ) */
    {{'\xec', '\xa9', '\xbf'}, 3, 0xCA7F}, /* (HANGUL SYLLABLE JJEC) */
    {{'\xec', '\xaa', '\x80'}, 3, 0xCA80}, /* (HANGUL SYLLABLE JJEK) */
    {{'\xec', '\xaa', '\x81'}, 3, 0xCA81}, /* (HANGUL SYLLABLE JJET) */
    {{'\xec', '\xaa', '\x82'}, 3, 0xCA82}, /* (HANGUL SYLLABLE JJEP) */
    {{'\xec', '\xaa', '\x83'}, 3, 0xCA83}, /* (HANGUL SYLLABLE JJEH) */
    {{'\xec', '\xaa', '\x85'}, 3, 0xCA85}, /* (HANGUL SYLLABLE JJYEOG) */
    {{'\xec', '\xaa', '\x86'}, 3, 0xCA86}, /* (HANGUL SYLLABLE JJYEOGG) */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{'\xec', '\xaa', '\x87'}, 3, 0xCA87}, /* (HANGUL SYLLABLE JJYEOGS) */
    {{'\xec', '\xaa', '\x88'}, 3, 0xCA88}, /* (HANGUL SYLLABLE JJYEON) */
    {{'\xec', '\xaa', '\x89'}, 3, 0xCA89}, /* (HANGUL SYLLABLE JJYEONJ) */
    {{'\xec', '\xaa', '\x8a'}, 3, 0xCA8A}, /* (HANGUL SYLLABLE JJYEONH) */
    {{'\xec', '\xaa', '\x8b'}, 3, 0xCA8B}, /* (HANGUL SYLLABLE JJYEOD) */
    {{'\xec', '\xaa', '\x8c'}, 3, 0xCA8C}, /* (HANGUL SYLLABLE JJYEOL) */
    {{'\xec', '\xaa', '\x8d'}, 3, 0xCA8D}, /* (HANGUL SYLLABLE JJYEOLG) */
    {{'\xec', '\xaa', '\x8e'}, 3, 0xCA8E}, /* (HANGUL SYLLABLE JJYEOLM) */
    {{'\xec', '\xaa', '\x8f'}, 3, 0xCA8F}, /* (HANGUL SYLLABLE JJYEOLB) */
    {{'\xec', '\xaa', '\x90'}, 3, 0xCA90}, /* (HANGUL SYLLABLE JJYEOLS) */
    {{'\xec', '\xaa', '\x91'}, 3, 0xCA91}, /* (HANGUL SYLLABLE JJYEOLT) */
    {{'\xec', '\xaa', '\x92'}, 3, 0xCA92}, /* (HANGUL SYLLABLE JJYEOLP) */
    {{'\xec', '\xaa', '\x93'}, 3, 0xCA93}, /* (HANGUL SYLLABLE JJYEOLH) */
    {{'\xec', '\xaa', '\x94'}, 3, 0xCA94}, /* (HANGUL SYLLABLE JJYEOM) */
    {{'\xec', '\xaa', '\x95'}, 3, 0xCA95}, /* (HANGUL SYLLABLE JJYEOB) */
    {{'\xec', '\xaa', '\x96'}, 3, 0xCA96}, /* (HANGUL SYLLABLE JJYEOBS) */
    {{'\xec', '\xaa', '\x97'}, 3, 0xCA97}, /* (HANGUL SYLLABLE JJYEOS) */
    {{'\xec', '\xaa', '\x99'}, 3, 0xCA99}, /* (HANGUL SYLLABLE JJYEONG) */
    {{'\xec', '\xaa', '\x9a'}, 3, 0xCA9A}, /* (HANGUL SYLLABLE JJYEOJ) */
    {{'\xec', '\xaa', '\x9b'}, 3, 0xCA9B}, /* (HANGUL SYLLABLE JJYEOC) */
    {{'\xec', '\xaa', '\x9c'}, 3, 0xCA9C}, /* (HANGUL SYLLABLE JJYEOK) */
    {{'\xec', '\xaa', '\x9d'}, 3, 0xCA9D}, /* (HANGUL SYLLABLE JJYEOT) */
    {{'\xec', '\xaa', '\x9e'}, 3, 0xCA9E}, /* (HANGUL SYLLABLE JJYEOP) */
    {{'\xec', '\xaa', '\x9f'}, 3, 0xCA9F}, /* (HANGUL SYLLABLE JJYEOH) */
    {{'\xec', '\xaa', '\xa0'}, 3, 0xCAA0}, /* (HANGUL SYLLABLE JJYE) */
    {{'\xec', '\xaa', '\xa1'}, 3, 0xCAA1}, /* (HANGUL SYLLABLE JJYEG) */
    {{'\xec', '\xaa', '\xa2'}, 3, 0xCAA2}, /* (HANGUL SYLLABLE JJYEGG) */
    {{'\xec', '\xaa', '\xa3'}, 3, 0xCAA3}, /* (HANGUL SYLLABLE JJYEGS) */
    {{'\xec', '\xaa', '\xa4'}, 3, 0xCAA4}, /* (HANGUL SYLLABLE JJYEN) */
    {{'\xec', '\xaa', '\xa5'}, 3, 0xCAA5}, /* (HANGUL SYLLABLE JJYENJ) */
    {{'\xec', '\xaa', '\xa6'}, 3, 0xCAA6}, /* (HANGUL SYLLABLE JJYENH) */
    {{'\xec', '\xaa', '\xa7'}, 3, 0xCAA7}, /* (HANGUL SYLLABLE JJYED) */
    {{'\xe2', '\x85', '\xb0'}, 3, 0x2170}, /* (SMALL ROMAN NUMERAL ONE) */
    {{'\xe2', '\x85', '\xb1'}, 3, 0x2171}, /* (SMALL ROMAN NUMERAL TWO) */
    {{'\xe2', '\x85', '\xb2'}, 3, 0x2172}, /* (SMALL ROMAN NUMERAL THREE) */
    {{'\xe2', '\x85', '\xb3'}, 3, 0x2173}, /* (SMALL ROMAN NUMERAL FOUR) */
    {{'\xe2', '\x85', '\xb4'}, 3, 0x2174}, /* (SMALL ROMAN NUMERAL FIVE) */
    {{'\xe2', '\x85', '\xb5'}, 3, 0x2175}, /* (SMALL ROMAN NUMERAL SIX) */
    {{'\xe2', '\x85', '\xb6'}, 3, 0x2176}, /* (SMALL ROMAN NUMERAL SEVEN) */
    {{'\xe2', '\x85', '\xb7'}, 3, 0x2177}, /* (SMALL ROMAN NUMERAL EIGHT) */
    {{'\xe2', '\x85', '\xb8'}, 3, 0x2178}, /* (SMALL ROMAN NUMERAL NINE) */
    {{'\xe2', '\x85', '\xb9'}, 3, 0x2179}, /* (SMALL ROMAN NUMERAL TEN) */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{'\xe2', '\x85', '\xa0'}, 3, 0x2160}, /* (ROMAN NUMERAL ONE) */
    {{'\xe2', '\x85', '\xa1'}, 3, 0x2161}, /* (ROMAN NUMERAL TWO) */
    {{'\xe2', '\x85', '\xa2'}, 3, 0x2162}, /* (ROMAN NUMERAL THREE) */
    {{'\xe2', '\x85', '\xa3'}, 3, 0x2163}, /* (ROMAN NUMERAL FOUR) */
    {{'\xe2', '\x85', '\xa4'}, 3, 0x2164}, /* (ROMAN NUMERAL FIVE) */
    {{'\xe2', '\x85', '\xa5'}, 3, 0x2165}, /* (ROMAN NUMERAL SIX) */
    {{'\xe2', '\x85', '\xa6'}, 3, 0x2166}, /* (ROMAN NUMERAL SEVEN) */
    {{'\xe2', '\x85', '\xa7'}, 3, 0x2167}, /* (ROMAN NUMERAL EIGHT) */
    {{'\xe2', '\x85', '\xa8'}, 3, 0x2168}, /* (ROMAN NUMERAL NINE) */
    {{'\xe2', '\x85', '\xa9'}, 3, 0x2169}, /* (ROMAN NUMERAL TEN) */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{'\xce', '\x91'}, 2, 0x0391}, /* (GREEK CAPITAL LETTER ALPHA) */
    {{'\xce', '\x92'}, 2, 0x0392}, /* (GREEK CAPITAL LETTER BETA) */
    {{'\xce', '\x93'}, 2, 0x0393}, /* (GREEK CAPITAL LETTER GAMMA) */
    {{'\xce', '\x94'}, 2, 0x0394}, /* (GREEK CAPITAL LETTER DELTA) */
    {{'\xce', '\x95'}, 2, 0x0395}, /* (GREEK CAPITAL LETTER EPSILON) */
    {{'\xce', '\x96'}, 2, 0x0396}, /* (GREEK CAPITAL LETTER ZETA) */
    {{'\xce', '\x97'}, 2, 0x0397}, /* (GREEK CAPITAL LETTER ETA) */
    {{'\xce', '\x98'}, 2, 0x0398}, /* (GREEK CAPITAL LETTER THETA) */
    {{'\xce', '\x99'}, 2, 0x0399}, /* (GREEK CAPITAL LETTER IOTA) */
    {{'\xce', '\x9a'}, 2, 0x039A}, /* (GREEK CAPITAL LETTER KAPPA) */
    {{'\xce', '\x9b'}, 2, 0x039B}, /* (GREEK CAPITAL LETTER LAMDA) */
    {{'\xce', '\x9c'}, 2, 0x039C}, /* (GREEK CAPITAL LETTER MU) */
    {{'\xce', '\x9d'}, 2, 0x039D}, /* (GREEK CAPITAL LETTER NU) */
    {{'\xce', '\x9e'}, 2, 0x039E}, /* (GREEK CAPITAL LETTER XI) */
    {{'\xce', '\x9f'}, 2, 0x039F}, /* (GREEK CAPITAL LETTER OMICRON) */
    {{'\xce', '\xa0'}, 2, 0x03A0}, /* (GREEK CAPITAL LETTER PI) */
    {{'\xce', '\xa1'}, 2, 0x03A1}, /* (GREEK CAPITAL LETTER RHO) */
    {{'\xce', '\xa3'}, 2, 0x03A3}, /* (GREEK CAPITAL LETTER SIGMA) */
    {{'\xce', '\xa4'}, 2, 0x03A4}, /* (GREEK CAPITAL LETTER TAU) */
    {{'\xce', '\xa5'}, 2, 0x03A5}, /* (GREEK CAPITAL LETTER UPSILON) */
    {{'\xce', '\xa6'}, 2, 0x03A6}, /* (GREEK CAPITAL LETTER PHI) */
    {{'\xce', '\xa7'}, 2, 0x03A7}, /* (GREEK CAPITAL LETTER CHI) */
    {{'\xce', '\xa8'}, 2, 0x03A8}, /* (GREEK CAPITAL LETTER PSI) */
    {{'\xce', '\xa9'}, 2, 0x03A9}, /* (GREEK CAPITAL LETTER OMEGA) */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{'\xce', '\xb1'}, 2, 0x03B1}, /* (GREEK SMALL LETTER ALPHA) */
    {{'\xce', '\xb2'}, 2, 0x03B2}, /* (GREEK SMALL LETTER BETA) */
    {{'\xce', '\xb3'}, 2, 0x03B3}, /* (GREEK SMALL LETTER GAMMA) */
    {{'\xce', '\xb4'}, 2, 0x03B4}, /* (GREEK SMALL LETTER DELTA) */
    {{'\xce', '\xb5'}, 2, 0x03B5}, /* (GREEK SMALL LETTER EPSILON) */
    {{'\xce', '\xb6'}, 2, 0x03B6}, /* (GREEK SMALL LETTER ZETA) */
    {{'\xce', '\xb7'}, 2, 0x03B7}, /* (GREEK SMALL LETTER ETA) */
    {{'\xce', '\xb8'}, 2, 0x03B8}, /* (GREEK SMALL LETTER THETA) */
    {{'\xce', '\xb9'}, 2, 0x03B9}, /* (GREEK SMALL LETTER IOTA) */
    {{'\xce', '\xba'}, 2, 0x03BA}, /* (GREEK SMALL LETTER KAPPA) */
    {{'\xce', '\xbb'}, 2, 0x03BB}, /* (GREEK SMALL LETTER LAMDA) */
    {{'\xce', '\xbc'}, 2, 0x03BC}, /* (GREEK SMALL LETTER MU) */
    {{'\xce', '\xbd'}, 2, 0x03BD}, /* (GREEK SMALL LETTER NU) */
    {{'\xce', '\xbe'}, 2, 0x03BE}, /* (GREEK SMALL LETTER XI) */
    {{'\xce', '\xbf'}, 2, 0x03BF}, /* (GREEK SMALL LETTER OMICRON) */
    {{'\xcf', '\x80'}, 2, 0x03C0}, /* (GREEK SMALL LETTER PI) */
    {{'\xcf', '\x81'}, 2, 0x03C1}, /* (GREEK SMALL LETTER RHO) */
    {{'\xcf', '\x83'}, 2, 0x03C3}, /* (GREEK SMALL LETTER SIGMA) */
    {{'\xcf', '\x84'}, 2, 0x03C4}, /* (GREEK SMALL LETTER TAU) */
    {{'\xcf', '\x85'}, 2, 0x03C5}, /* (GREEK SMALL LETTER UPSILON) */
    {{'\xcf', '\x86'}, 2, 0x03C6}, /* (GREEK SMALL LETTER PHI) */
    {{'\xcf', '\x87'}, 2, 0x03C7}, /* (GREEK SMALL LETTER CHI) */
    {{'\xcf', '\x88'}, 2, 0x03C8}, /* (GREEK SMALL LETTER PSI) */
    {{'\xcf', '\x89'}, 2, 0x03C9}, /* (GREEK SMALL LETTER OMEGA) */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{'\xec', '\xaa', '\xa8'}, 3, 0xCAA8}, /* (HANGUL SYLLABLE JJYEL) */
    {{'\xec', '\xaa', '\xa9'}, 3, 0xCAA9}, /* (HANGUL SYLLABLE JJYELG) */
    {{'\xec', '\xaa', '\xaa'}, 3, 0xCAAA}, /* (HANGUL SYLLABLE JJYELM) */
    {{'\xec', '\xaa', '\xab'}, 3, 0xCAAB}, /* (HANGUL SYLLABLE JJYELB) */
    {{'\xec', '\xaa', '\xac'}, 3, 0xCAAC}, /* (HANGUL SYLLABLE JJYELS) */
    {{'\xec', '\xaa', '\xad'}, 3, 0xCAAD}, /* (HANGUL SYLLABLE JJYELT) */
    {{'\xec', '\xaa', '\xae'}, 3, 0xCAAE}, /* (HANGUL SYLLABLE JJYELP) */
    {{'\xec', '\xaa', '\xaf'}, 3, 0xCAAF}, /* (HANGUL SYLLABLE JJYELH) */
    {{'\xec', '\xaa', '\xb0'}, 3, 0xCAB0}, /* (HANGUL SYLLABLE JJYEM) */
    {{'\xec', '\xaa', '\xb1'}, 3, 0xCAB1}, /* (HANGUL SYLLABLE JJYEB) */
    {{'\xec', '\xaa', '\xb2'}, 3, 0xCAB2}, /* (HANGUL SYLLABLE JJYEBS) */
    {{'\xec', '\xaa', '\xb3'}, 3, 0xCAB3}, /* (HANGUL SYLLABLE JJYES) */
    {{'\xec', '\xaa', '\xb4'}, 3, 0xCAB4}, /* (HANGUL SYLLABLE JJYESS) */
    {{'\xec', '\xaa', '\xb5'}, 3, 0xCAB5}, /* (HANGUL SYLLABLE JJYENG) */
    {{'\xec', '\xaa', '\xb6'}, 3, 0xCAB6}, /* (HANGUL SYLLABLE JJYEJ) */
    {{'\xec', '\xaa', '\xb7'}, 3, 0xCAB7}, /* (HANGUL SYLLABLE JJYEC) */
    {{'\xec', '\xaa', '\xb8'}, 3, 0xCAB8}, /* (HANGUL SYLLABLE JJYEK) */
    {{'\xec', '\xaa', '\xb9'}, 3, 0xCAB9}, /* (HANGUL SYLLABLE JJYET) */
    {{'\xec', '\xaa', '\xba'}, 3, 0xCABA}, /* (HANGUL SYLLABLE JJYEP) */
    {{'\xec', '\xaa', '\xbb'}, 3, 0xCABB}, /* (HANGUL SYLLABLE JJYEH) */
    {{'\xec', '\xaa', '\xbe'}, 3, 0xCABE}, /* (HANGUL SYLLABLE JJOGG) */
    {{'\xec', '\xaa', '\xbf'}, 3, 0xCABF}, /* (HANGUL SYLLABLE JJOGS) */
    {{'\xec', '\xab', '\x81'}, 3, 0xCAC1}, /* (HANGUL SYLLABLE JJONJ) */
    {{'\xec', '\xab', '\x82'}, 3, 0xCAC2}, /* (HANGUL SYLLABLE JJONH) */
    {{'\xec', '\xab', '\x83'}, 3, 0xCAC3}, /* (HANGUL SYLLABLE JJOD) */
    {{'\xec', '\xab', '\x85'}, 3, 0xCAC5}, /* (HANGUL SYLLABLE JJOLG) */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{'\xec', '\xab', '\x86'}, 3, 0xCAC6}, /* (HANGUL SYLLABLE JJOLM) */
    {{'\xec', '\xab', '\x87'}, 3, 0xCAC7}, /* (HANGUL SYLLABLE JJOLB) */
    {{'\xec', '\xab', '\x88'}, 3, 0xCAC8}, /* (HANGUL SYLLABLE JJOLS) */
    {{'\xec', '\xab', '\x89'}, 3, 0xCAC9}, /* (HANGUL SYLLABLE JJOLT) */
    {{'\xec', '\xab', '\x8a'}, 3, 0xCACA}, /* (HANGUL SYLLABLE JJOLP) */
    {{'\xec', '\xab', '\x8b'}, 3, 0xCACB}, /* (HANGUL SYLLABLE JJOLH) */
    {{'\xec', '\xab', '\x8e'}, 3, 0xCACE}, /* (HANGUL SYLLABLE JJOBS) */
    {{'\xec', '\xab', '\x90'}, 3, 0xCAD0}, /* (HANGUL SYLLABLE JJOSS) */
    {{'\xec', '\xab', '\x92'}, 3, 0xCAD2}, /* (HANGUL SYLLABLE JJOJ) */
    {{'\xec', '\xab', '\x94'}, 3, 0xCAD4}, /* (HANGUL SYLLABLE JJOK) */
    {{'\xec', '\xab', '\x95'}, 3, 0xCAD5}, /* (HANGUL SYLLABLE JJOT) */
    {{'\xec', '\xab', '\x96'}, 3, 0xCAD6}, /* (HANGUL SYLLABLE JJOP) */
    {{'\xec', '\xab', '\x97'}, 3, 0xCAD7}, /* (HANGUL SYLLABLE JJOH) */
    {{'\xec', '\xab', '\x9a'}, 3, 0xCADA}, /* (HANGUL SYLLABLE JJWAGG) */
    {{'\xec', '\xab', '\x9b'}, 3, 0xCADB}, /* (HANGUL SYLLABLE JJWAGS) */
    {{'\xec', '\xab', '\x9c'}, 3, 0xCADC}, /* (HANGUL SYLLABLE JJWAN) */
    {{'\xec', '\xab', '\x9d'}, 3, 0xCADD}, /* (HANGUL SYLLABLE JJWANJ) */
    {{'\xec', '\xab', '\x9e'}, 3, 0xCADE}, /* (HANGUL SYLLABLE JJWANH) */
    {{'\xec', '\xab', '\x9f'}, 3, 0xCADF}, /* (HANGUL SYLLABLE JJWAD) */
    {{'\xec', '\xab', '\xa1'}, 3, 0xCAE1}, /* (HANGUL SYLLABLE JJWALG) */
    {{'\xec', '\xab', '\xa2'}, 3, 0xCAE2}, /* (HANGUL SYLLABLE JJWALM) */
    {{'\xec', '\xab', '\xa3'}, 3, 0xCAE3}, /* (HANGUL SYLLABLE JJWALB) */
    {{'\xec', '\xab', '\xa4'}, 3, 0xCAE4}, /* (HANGUL SYLLABLE JJWALS) */
    {{'\xec', '\xab', '\xa5'}, 3, 0xCAE5}, /* (HANGUL SYLLABLE JJWALT) */
    {{'\xec', '\xab', '\xa6'}, 3, 0xCAE6}, /* (HANGUL SYLLABLE JJWALP) */
    {{'\xec', '\xab', '\xa7'}, 3, 0xCAE7}, /* (HANGUL SYLLABLE JJWALH) */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{'\xec', '\xab', '\xa8'}, 3, 0xCAE8}, /* (HANGUL SYLLABLE JJWAM) */
    {{'\xec', '\xab', '\xa9'}, 3, 0xCAE9}, /* (HANGUL SYLLABLE JJWAB) */
    {{'\xec', '\xab', '\xaa'}, 3, 0xCAEA}, /* (HANGUL SYLLABLE JJWABS) */
    {{'\xec', '\xab', '\xab'}, 3, 0xCAEB}, /* (HANGUL SYLLABLE JJWAS) */
    {{'\xec', '\xab', '\xad'}, 3, 0xCAED}, /* (HANGUL SYLLABLE JJWANG) */
    {{'\xec', '\xab', '\xae'}, 3, 0xCAEE}, /* (HANGUL SYLLABLE JJWAJ) */
    {{'\xec', '\xab', '\xaf'}, 3, 0xCAEF}, /* (HANGUL SYLLABLE JJWAC) */
    {{'\xec', '\xab', '\xb0'}, 3, 0xCAF0}, /* (HANGUL SYLLABLE JJWAK) */
    {{'\xec', '\xab', '\xb1'}, 3, 0xCAF1}, /* (HANGUL SYLLABLE JJWAT) */
    {{'\xec', '\xab', '\xb2'}, 3, 0xCAF2}, /* (HANGUL SYLLABLE JJWAP) */
    {{'\xec', '\xab', '\xb3'}, 3, 0xCAF3}, /* (HANGUL SYLLABLE JJWAH) */
    {{'\xec', '\xab', '\xb5'}, 3, 0xCAF5}, /* (HANGUL SYLLABLE JJWAEG) */
    {{'\xec', '\xab', '\xb6'}, 3, 0xCAF6}, /* (HANGUL SYLLABLE JJWAEGG) */
    {{'\xec', '\xab', '\xb7'}, 3, 0xCAF7}, /* (HANGUL SYLLABLE JJWAEGS) */
    {{'\xec', '\xab', '\xb8'}, 3, 0xCAF8}, /* (HANGUL SYLLABLE JJWAEN) */
    {{'\xec', '\xab', '\xb9'}, 3, 0xCAF9}, /* (HANGUL SYLLABLE JJWAENJ) */
    {{'\xec', '\xab', '\xba'}, 3, 0xCAFA}, /* (HANGUL SYLLABLE JJWAENH) */
    {{'\xec', '\xab', '\xbb'}, 3, 0xCAFB}, /* (HANGUL SYLLABLE JJWAED) */
    {{'\xec', '\xab', '\xbc'}, 3, 0xCAFC}, /* (HANGUL SYLLABLE JJWAEL) */
    {{'\xec', '\xab', '\xbd'}, 3, 0xCAFD}, /* (HANGUL SYLLABLE JJWAELG) */
    {{'\xec', '\xab', '\xbe'}, 3, 0xCAFE}, /* (HANGUL SYLLABLE JJWAELM) */
    {{'\xec', '\xab', '\xbf'}, 3, 0xCAFF}, /* (HANGUL SYLLABLE JJWAELB) */
    {{'\xec', '\xac', '\x80'}, 3, 0xCB00}, /* (HANGUL SYLLABLE JJWAELS) */
    {{'\xec', '\xac', '\x81'}, 3, 0xCB01}, /* (HANGUL SYLLABLE JJWAELT) */
    {{'\xec', '\xac', '\x82'}, 3, 0xCB02}, /* (HANGUL SYLLABLE JJWAELP) */
    {{'\xec', '\xac', '\x83'}, 3, 0xCB03}, /* (HANGUL SYLLABLE JJWAELH) */
    {{'\xec', '\xac', '\x84'}, 3, 0xCB04}, /* (HANGUL SYLLABLE JJWAEM) */
    {{'\xec', '\xac', '\x85'}, 3, 0xCB05}, /* (HANGUL SYLLABLE JJWAEB) */
    {{'\xec', '\xac', '\x86'}, 3, 0xCB06}, /* (HANGUL SYLLABLE JJWAEBS) */
    {{'\xec', '\xac', '\x87'}, 3, 0xCB07}, /* (HANGUL SYLLABLE JJWAES) */
    {{'\xec', '\xac', '\x89'}, 3, 0xCB09}, /* (HANGUL SYLLABLE JJWAENG) */
    {{'\xec', '\xac', '\x8a'}, 3, 0xCB0A}, /* (HANGUL SYLLABLE JJWAEJ) */
    {{'\xe2', '\x94', '\x80'}, 3, 0x2500}, /* (BOX DRAWINGS LIGHT HORIZONTAL) */
    {{'\xe2', '\x94', '\x82'}, 3, 0x2502}, /* (BOX DRAWINGS LIGHT VERTICAL) */
    {{'\xe2', '\x94', '\x8c'}, 3, 0x250C}, /* (BOX DRAWINGS LIGHT DOWN AND RIGHT) */
    {{'\xe2', '\x94', '\x90'}, 3, 0x2510}, /* (BOX DRAWINGS LIGHT DOWN AND LEFT) */
    {{'\xe2', '\x94', '\x98'}, 3, 0x2518}, /* (BOX DRAWINGS LIGHT UP AND LEFT) */
    {{'\xe2', '\x94', '\x94'}, 3, 0x2514}, /* (BOX DRAWINGS LIGHT UP AND RIGHT) */
    {{'\xe2', '\x94', '\x9c'}, 3, 0x251C}, /* (BOX DRAWINGS LIGHT VERTICAL AND RIGHT) */
    {{'\xe2', '\x94', '\xac'}, 3, 0x252C}, /* (BOX DRAWINGS LIGHT DOWN AND HORIZONTAL) */
    {{'\xe2', '\x94', '\xa4'}, 3, 0x2524}, /* (BOX DRAWINGS LIGHT VERTICAL AND LEFT) */
    {{'\xe2', '\x94', '\xb4'}, 3, 0x2534}, /* (BOX DRAWINGS LIGHT UP AND HORIZONTAL) */
    {{'\xe2', '\x94', '\xbc'}, 3, 0x253C}, /* (BOX DRAWINGS LIGHT VERTICAL AND HORIZONTAL) */
    {{'\xe2', '\x94', '\x81'}, 3, 0x2501}, /* (BOX DRAWINGS HEAVY HORIZONTAL) */
    {{'\xe2', '\x94', '\x83'}, 3, 0x2503}, /* (BOX DRAWINGS HEAVY VERTICAL) */
    {{'\xe2', '\x94', '\x8f'}, 3, 0x250F}, /* (BOX DRAWINGS HEAVY DOWN AND RIGHT) */
    {{'\xe2', '\x94', '\x93'}, 3, 0x2513}, /* (BOX DRAWINGS HEAVY DOWN AND LEFT) */
    {{'\xe2', '\x94', '\x9b'}, 3, 0x251B}, /* (BOX DRAWINGS HEAVY UP AND LEFT) */
    {{'\xe2', '\x94', '\x97'}, 3, 0x2517}, /* (BOX DRAWINGS HEAVY UP AND RIGHT) */
    {{'\xe2', '\x94', '\xa3'}, 3, 0x2523}, /* (BOX DRAWINGS HEAVY VERTICAL AND RIGHT) */
    {{'\xe2', '\x94', '\xb3'}, 3, 0x2533}, /* (BOX DRAWINGS HEAVY DOWN AND HORIZONTAL) */
    {{'\xe2', '\x94', '\xab'}, 3, 0x252B}, /* (BOX DRAWINGS HEAVY VERTICAL AND LEFT) */
    {{'\xe2', '\x94', '\xbb'}, 3, 0x253B}, /* (BOX DRAWINGS HEAVY UP AND HORIZONTAL) */
    {{'\xe2', '\x95', '\x8b'}, 3, 0x254B}, /* (BOX DRAWINGS HEAVY VERTICAL AND HORIZONTAL) */
    {{'\xe2', '\x94', '\xa0'}, 3, 0x2520}, /* (BOX DRAWINGS VERTICAL HEAVY AND RIGHT LIGHT) */
    {{'\xe2', '\x94', '\xaf'}, 3, 0x252F}, /* (BOX DRAWINGS DOWN LIGHT AND HORIZONTAL HEAVY) */
    {{'\xe2', '\x94', '\xa8'}, 3, 0x2528}, /* (BOX DRAWINGS VERTICAL HEAVY AND LEFT LIGHT) */
    {{'\xe2', '\x94', '\xb7'}, 3, 0x2537}, /* (BOX DRAWINGS UP LIGHT AND HORIZONTAL HEAVY) */
    {{'\xe2', '\x94', '\xbf'}, 3, 0x253F}, /* (BOX DRAWINGS VERTICAL LIGHT AND HORIZONTAL HEAVY) */
    {{'\xe2', '\x94', '\x9d'}, 3, 0x251D}, /* (BOX DRAWINGS VERTICAL LIGHT AND RIGHT HEAVY) */
    {{'\xe2', '\x94', '\xb0'}, 3, 0x2530}, /* (BOX DRAWINGS DOWN HEAVY AND HORIZONTAL LIGHT) */
    {{'\xe2', '\x94', '\xa5'}, 3, 0x2525}, /* (BOX DRAWINGS VERTICAL LIGHT AND LEFT HEAVY) */
    {{'\xe2', '\x94', '\xb8'}, 3, 0x2538}, /* (BOX DRAWINGS UP HEAVY AND HORIZONTAL LIGHT) */
    {{'\xe2', '\x95', '\x82'}, 3, 0x2542}, /* (BOX DRAWINGS VERTICAL HEAVY AND HORIZONTAL LIGHT) */
    {{'\xe2', '\x94', '\x92'}, 3, 0x2512}, /* (BOX DRAWINGS DOWN HEAVY AND LEFT LIGHT) */
    {{'\xe2', '\x94', '\x91'}, 3, 0x2511}, /* (BOX DRAWINGS DOWN LIGHT AND LEFT HEAVY) */
    {{'\xe2', '\x94', '\x9a'}, 3, 0x251A}, /* (BOX DRAWINGS UP HEAVY AND LEFT LIGHT) */
    {{'\xe2', '\x94', '\x99'}, 3, 0x2519}, /* (BOX DRAWINGS UP LIGHT AND LEFT HEAVY) */
    {{'\xe2', '\x94', '\x96'}, 3, 0x2516}, /* (BOX DRAWINGS UP HEAVY AND RIGHT LIGHT) */
    {{'\xe2', '\x94', '\x95'}, 3, 0x2515}, /* (BOX DRAWINGS UP LIGHT AND RIGHT HEAVY) */
    {{'\xe2', '\x94', '\x8e'}, 3, 0x250E}, /* (BOX DRAWINGS DOWN HEAVY AND RIGHT LIGHT) */
    {{'\xe2', '\x94', '\x8d'}, 3, 0x250D}, /* (BOX DRAWINGS DOWN LIGHT AND RIGHT HEAVY) */
    {{'\xe2', '\x94', '\x9e'}, 3, 0x251E}, /* (BOX DRAWINGS UP HEAVY AND RIGHT DOWN LIGHT) */
    {{'\xe2', '\x94', '\x9f'}, 3, 0x251F}, /* (BOX DRAWINGS DOWN HEAVY AND RIGHT UP LIGHT) */
    {{'\xe2', '\x94', '\xa1'}, 3, 0x2521}, /* (BOX DRAWINGS DOWN LIGHT AND RIGHT UP HEAVY) */
    {{'\xe2', '\x94', '\xa2'}, 3, 0x2522}, /* (BOX DRAWINGS UP LIGHT AND RIGHT DOWN HEAVY) */
    {{'\xe2', '\x94', '\xa6'}, 3, 0x2526}, /* (BOX DRAWINGS UP HEAVY AND LEFT DOWN LIGHT) */
    {{'\xe2', '\x94', '\xa7'}, 3, 0x2527}, /* (BOX DRAWINGS DOWN HEAVY AND LEFT UP LIGHT) */
    {{'\xe2', '\x94', '\xa9'}, 3, 0x2529}, /* (BOX DRAWINGS DOWN LIGHT AND LEFT UP HEAVY) */
    {{'\xe2', '\x94', '\xaa'}, 3, 0x252A}, /* (BOX DRAWINGS UP LIGHT AND LEFT DOWN HEAVY) */
    {{'\xe2', '\x94', '\xad'}, 3, 0x252D}, /* (BOX DRAWINGS LEFT HEAVY AND RIGHT DOWN LIGHT) */
    {{'\xe2', '\x94', '\xae'}, 3, 0x252E}, /* (BOX DRAWINGS RIGHT HEAVY AND LEFT DOWN LIGHT) */
    {{'\xe2', '\x94', '\xb1'}, 3, 0x2531}, /* (BOX DRAWINGS RIGHT LIGHT AND LEFT DOWN HEAVY) */
    {{'\xe2', '\x94', '\xb2'}, 3, 0x2532}, /* (BOX DRAWINGS LEFT LIGHT AND RIGHT DOWN HEAVY) */
    {{'\xe2', '\x94', '\xb5'}, 3, 0x2535}, /* (BOX DRAWINGS LEFT HEAVY AND RIGHT UP LIGHT) */
    {{'\xe2', '\x94', '\xb6'}, 3, 0x2536}, /* (BOX DRAWINGS RIGHT HEAVY AND LEFT UP LIGHT) */
    {{'\xe2', '\x94', '\xb9'}, 3, 0x2539}, /* (BOX DRAWINGS RIGHT LIGHT AND LEFT UP HEAVY) */
    {{'\xe2', '\x94', '\xba'}, 3, 0x253A}, /* (BOX DRAWINGS LEFT LIGHT AND RIGHT UP HEAVY) */
    {{'\xe2', '\x94', '\xbd'}, 3, 0x253D}, /* (BOX DRAWINGS LEFT HEAVY AND RIGHT VERTICAL LIGHT) */
    {{'\xe2', '\x94', '\xbe'}, 3, 0x253E}, /* (BOX DRAWINGS RIGHT HEAVY AND LEFT VERTICAL LIGHT) */
    {{'\xe2', '\x95', '\x80'}, 3, 0x2540}, /* (BOX DRAWINGS UP HEAVY AND DOWN HORIZONTAL LIGHT) */
    {{'\xe2', '\x95', '\x81'}, 3, 0x2541}, /* (BOX DRAWINGS DOWN HEAVY AND UP HORIZONTAL LIGHT) */
    {{'\xe2', '\x95', '\x83'}, 3, 0x2543}, /* (BOX DRAWINGS LEFT UP HEAVY AND RIGHT DOWN LIGHT) */
    {{'\xe2', '\x95', '\x84'}, 3, 0x2544}, /* (BOX DRAWINGS RIGHT UP HEAVY AND LEFT DOWN LIGHT) */
    {{'\xe2', '\x95', '\x85'}, 3, 0x2545}, /* (BOX DRAWINGS LEFT DOWN HEAVY AND RIGHT UP LIGHT) */
    {{'\xe2', '\x95', '\x86'}, 3, 0x2546}, /* (BOX DRAWINGS RIGHT DOWN HEAVY AND LEFT UP LIGHT) */
    {{'\xe2', '\x95', '\x87'}, 3, 0x2547}, /* (BOX DRAWINGS DOWN LIGHT AND UP HORIZONTAL HEAVY) */
    {{'\xe2', '\x95', '\x88'}, 3, 0x2548}, /* (BOX DRAWINGS UP LIGHT AND DOWN HORIZONTAL HEAVY) */
    {{'\xe2', '\x95', '\x89'}, 3, 0x2549}, /* (BOX DRAWINGS RIGHT LIGHT AND LEFT VERTICAL HEAVY) */
    {{'\xe2', '\x95', '\x8a'}, 3, 0x254A}, /* (BOX DRAWINGS LEFT LIGHT AND RIGHT VERTICAL HEAVY) */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{'\xec', '\xac', '\x8b'}, 3, 0xCB0B}, /* (HANGUL SYLLABLE JJWAEC) */
    {{'\xec', '\xac', '\x8c'}, 3, 0xCB0C}, /* (HANGUL SYLLABLE JJWAEK) */
    {{'\xec', '\xac', '\x8d'}, 3, 0xCB0D}, /* (HANGUL SYLLABLE JJWAET) */
    {{'\xec', '\xac', '\x8e'}, 3, 0xCB0E}, /* (HANGUL SYLLABLE JJWAEP) */
    {{'\xec', '\xac', '\x8f'}, 3, 0xCB0F}, /* (HANGUL SYLLABLE JJWAEH) */
    {{'\xec', '\xac', '\x91'}, 3, 0xCB11}, /* (HANGUL SYLLABLE JJOEG) */
    {{'\xec', '\xac', '\x92'}, 3, 0xCB12}, /* (HANGUL SYLLABLE JJOEGG) */
    {{'\xec', '\xac', '\x93'}, 3, 0xCB13}, /* (HANGUL SYLLABLE JJOEGS) */
    {{'\xec', '\xac', '\x95'}, 3, 0xCB15}, /* (HANGUL SYLLABLE JJOENJ) */
    {{'\xec', '\xac', '\x96'}, 3, 0xCB16}, /* (HANGUL SYLLABLE JJOENH) */
    {{'\xec', '\xac', '\x97'}, 3, 0xCB17}, /* (HANGUL SYLLABLE JJOED) */
    {{'\xec', '\xac', '\x99'}, 3, 0xCB19}, /* (HANGUL SYLLABLE JJOELG) */
    {{'\xec', '\xac', '\x9a'}, 3, 0xCB1A}, /* (HANGUL SYLLABLE JJOELM) */
    {{'\xec', '\xac', '\x9b'}, 3, 0xCB1B}, /* (HANGUL SYLLABLE JJOELB) */
    {{'\xec', '\xac', '\x9c'}, 3, 0xCB1C}, /* (HANGUL SYLLABLE JJOELS) */
    {{'\xec', '\xac', '\x9d'}, 3, 0xCB1D}, /* (HANGUL SYLLABLE JJOELT) */
    {{'\xec', '\xac', '\x9e'}, 3, 0xCB1E}, /* (HANGUL SYLLABLE JJOELP) */
    {{'\xec', '\xac', '\x9f'}, 3, 0xCB1F}, /* (HANGUL SYLLABLE JJOELH) */
    {{'\xec', '\xac', '\xa2'}, 3, 0xCB22}, /* (HANGUL SYLLABLE JJOEBS) */
    {{'\xec', '\xac', '\xa3'}, 3, 0xCB23}, /* (HANGUL SYLLABLE JJOES) */
    {{'\xec', '\xac', '\xa4'}, 3, 0xCB24}, /* (HANGUL SYLLABLE JJOESS) */
    {{'\xec', '\xac', '\xa5'}, 3, 0xCB25}, /* (HANGUL SYLLABLE JJOENG) */
    {{'\xec', '\xac', '\xa6'}, 3, 0xCB26}, /* (HANGUL SYLLABLE JJOEJ) */
    {{'\xec', '\xac', '\xa7'}, 3, 0xCB27}, /* (HANGUL SYLLABLE JJOEC) */
    {{'\xec', '\xac', '\xa8'}, 3, 0xCB28}, /* (HANGUL SYLLABLE JJOEK) */
    {{'\xec', '\xac', '\xa9'}, 3, 0xCB29}, /* (HANGUL SYLLABLE JJOET) */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{'\xec', '\xac', '\xaa'}, 3, 0xCB2A}, /* (HANGUL SYLLABLE JJOEP) */
    {{'\xec', '\xac', '\xab'}, 3, 0xCB2B}, /* (HANGUL SYLLABLE JJOEH) */
    {{'\xec', '\xac', '\xac'}, 3, 0xCB2C}, /* (HANGUL SYLLABLE JJYO) */
    {{'\xec', '\xac', '\xad'}, 3, 0xCB2D}, /* (HANGUL SYLLABLE JJYOG) */
    {{'\xec', '\xac', '\xae'}, 3, 0xCB2E}, /* (HANGUL SYLLABLE JJYOGG) */
    {{'\xec', '\xac', '\xaf'}, 3, 0xCB2F}, /* (HANGUL SYLLABLE JJYOGS) */
    {{'\xec', '\xac', '\xb0'}, 3, 0xCB30}, /* (HANGUL SYLLABLE JJYON) */
    {{'\xec', '\xac', '\xb1'}, 3, 0xCB31}, /* (HANGUL SYLLABLE JJYONJ) */
    {{'\xec', '\xac', '\xb2'}, 3, 0xCB32}, /* (HANGUL SYLLABLE JJYONH) */
    {{'\xec', '\xac', '\xb3'}, 3, 0xCB33}, /* (HANGUL SYLLABLE JJYOD) */
    {{'\xec', '\xac', '\xb4'}, 3, 0xCB34}, /* (HANGUL SYLLABLE JJYOL) */
    {{'\xec', '\xac', '\xb5'}, 3, 0xCB35}, /* (HANGUL SYLLABLE JJYOLG) */
    {{'\xec', '\xac', '\xb6'}, 3, 0xCB36}, /* (HANGUL SYLLABLE JJYOLM) */
    {{'\xec', '\xac', '\xb7'}, 3, 0xCB37}, /* (HANGUL SYLLABLE JJYOLB) */
    {{'\xec', '\xac', '\xb8'}, 3, 0xCB38}, /* (HANGUL SYLLABLE JJYOLS) */
    {{'\xec', '\xac', '\xb9'}, 3, 0xCB39}, /* (HANGUL SYLLABLE JJYOLT) */
    {{'\xec', '\xac', '\xba'}, 3, 0xCB3A}, /* (HANGUL SYLLABLE JJYOLP) */
    {{'\xec', '\xac', '\xbb'}, 3, 0xCB3B}, /* (HANGUL SYLLABLE JJYOLH) */
    {{'\xec', '\xac', '\xbc'}, 3, 0xCB3C}, /* (HANGUL SYLLABLE JJYOM) */
    {{'\xec', '\xac', '\xbd'}, 3, 0xCB3D}, /* (HANGUL SYLLABLE JJYOB) */
    {{'\xec', '\xac', '\xbe'}, 3, 0xCB3E}, /* (HANGUL SYLLABLE JJYOBS) */
    {{'\xec', '\xac', '\xbf'}, 3, 0xCB3F}, /* (HANGUL SYLLABLE JJYOS) */
    {{'\xec', '\xad', '\x80'}, 3, 0xCB40}, /* (HANGUL SYLLABLE JJYOSS) */
    {{'\xec', '\xad', '\x82'}, 3, 0xCB42}, /* (HANGUL SYLLABLE JJYOJ) */
    {{'\xec', '\xad', '\x83'}, 3, 0xCB43}, /* (HANGUL SYLLABLE JJYOC) */
    {{'\xec', '\xad', '\x84'}, 3, 0xCB44}, /* (HANGUL SYLLABLE JJYOK) */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{'\xec', '\xad', '\x85'}, 3, 0xCB45}, /* (HANGUL SYLLABLE JJYOT) */
    {{'\xec', '\xad', '\x86'}, 3, 0xCB46}, /* (HANGUL SYLLABLE JJYOP) */
    {{'\xec', '\xad', '\x87'}, 3, 0xCB47}, /* (HANGUL SYLLABLE JJYOH) */
    {{'\xec', '\xad', '\x8a'}, 3, 0xCB4A}, /* (HANGUL SYLLABLE JJUGG) */
    {{'\xec', '\xad', '\x8b'}, 3, 0xCB4B}, /* (HANGUL SYLLABLE JJUGS) */
    {{'\xec', '\xad', '\x8d'}, 3, 0xCB4D}, /* (HANGUL SYLLABLE JJUNJ) */
    {{'\xec', '\xad', '\x8e'}, 3, 0xCB4E}, /* (HANGUL SYLLABLE JJUNH) */
    {{'\xec', '\xad', '\x8f'}, 3, 0xCB4F}, /* (HANGUL SYLLABLE JJUD) */
    {{'\xec', '\xad', '\x91'}, 3, 0xCB51}, /* (HANGUL SYLLABLE JJULG) */
    {{'\xec', '\xad', '\x92'}, 3, 0xCB52}, /* (HANGUL SYLLABLE JJULM) */
    {{'\xec', '\xad', '\x93'}, 3, 0xCB53}, /* (HANGUL SYLLABLE JJULB) */
    {{'\xec', '\xad', '\x94'}, 3, 0xCB54}, /* (HANGUL SYLLABLE JJULS) */
    {{'\xec', '\xad', '\x95'}, 3, 0xCB55}, /* (HANGUL SYLLABLE JJULT) */
    {{'\xec', '\xad', '\x96'}, 3, 0xCB56}, /* (HANGUL SYLLABLE JJULP) */
    {{'\xec', '\xad', '\x97'}, 3, 0xCB57}, /* (HANGUL SYLLABLE JJULH) */
    {{'\xec', '\xad', '\x9a'}, 3, 0xCB5A}, /* (HANGUL SYLLABLE JJUBS) */
    {{'\xec', '\xad', '\x9b'}, 3, 0xCB5B}, /* (HANGUL SYLLABLE JJUS) */
    {{'\xec', '\xad', '\x9c'}, 3, 0xCB5C}, /* (HANGUL SYLLABLE JJUSS) */
    {{'\xec', '\xad', '\x9e'}, 3, 0xCB5E}, /* (HANGUL SYLLABLE JJUJ) */
    {{'\xec', '\xad', '\x9f'}, 3, 0xCB5F}, /* (HANGUL SYLLABLE JJUC) */
    {{'\xec', '\xad', '\xa0'}, 3, 0xCB60}, /* (HANGUL SYLLABLE JJUK) */
    {{'\xec', '\xad', '\xa1'}, 3, 0xCB61}, /* (HANGUL SYLLABLE JJUT) */
    {{'\xec', '\xad', '\xa2'}, 3, 0xCB62}, /* (HANGUL SYLLABLE JJUP) */
    {{'\xec', '\xad', '\xa3'}, 3, 0xCB63}, /* (HANGUL SYLLABLE JJUH) */
    {{'\xec', '\xad', '\xa5'}, 3, 0xCB65}, /* (HANGUL SYLLABLE JJWEOG) */
    {{'\xec', '\xad', '\xa6'}, 3, 0xCB66}, /* (HANGUL SYLLABLE JJWEOGG) */
    {{'\xec', '\xad', '\xa7'}, 3, 0xCB67}, /* (HANGUL SYLLABLE JJWEOGS) */
    {{'\xec', '\xad', '\xa8'}, 3, 0xCB68}, /* (HANGUL SYLLABLE JJWEON) */
    {{'\xec', '\xad', '\xa9'}, 3, 0xCB69}, /* (HANGUL SYLLABLE JJWEONJ) */
    {{'\xec', '\xad', '\xaa'}, 3, 0xCB6A}, /* (HANGUL SYLLABLE JJWEONH) */
    {{'\xec', '\xad', '\xab'}, 3, 0xCB6B}, /* (HANGUL SYLLABLE JJWEOD) */
    {{'\xec', '\xad', '\xac'}, 3, 0xCB6C}, /* (HANGUL SYLLABLE JJWEOL) */
    {{'\xe3', '\x8e', '\x95'}, 3, 0x3395}, /* (SQUARE MU L) */
    {{'\xe3', '\x8e', '\x96'}, 3, 0x3396}, /* (SQUARE ML) */
    {{'\xe3', '\x8e', '\x97'}, 3, 0x3397}, /* (SQUARE DL) */
    {{'\xe2', '\x84', '\x93'}, 3, 0x2113}, /* (SCRIPT SMALL L) */
    {{'\xe3', '\x8e', '\x98'}, 3, 0x3398}, /* (SQUARE KL) */
    {{'\xe3', '\x8f', '\x84'}, 3, 0x33C4}, /* (SQUARE CC) */
    {{'\xe3', '\x8e', '\xa3'}, 3, 0x33A3}, /* (SQUARE MM CUBED) */
    {{'\xe3', '\x8e', '\xa4'}, 3, 0x33A4}, /* (SQUARE CM CUBED) */
    {{'\xe3', '\x8e', '\xa5'}, 3, 0x33A5}, /* (SQUARE M CUBED) */
    {{'\xe3', '\x8e', '\xa6'}, 3, 0x33A6}, /* (SQUARE KM CUBED) */
    {{'\xe3', '\x8e', '\x99'}, 3, 0x3399}, /* (SQUARE FM) */
    {{'\xe3', '\x8e', '\x9a'}, 3, 0x339A}, /* (SQUARE NM) */
    {{'\xe3', '\x8e', '\x9b'}, 3, 0x339B}, /* (SQUARE MU M) */
    {{'\xe3', '\x8e', '\x9c'}, 3, 0x339C}, /* (SQUARE MM) */
    {{'\xe3', '\x8e', '\x9d'}, 3, 0x339D}, /* (SQUARE CM) */
    {{'\xe3', '\x8e', '\x9e'}, 3, 0x339E}, /* (SQUARE KM) */
    {{'\xe3', '\x8e', '\x9f'}, 3, 0x339F}, /* (SQUARE MM SQUARED) */
    {{'\xe3', '\x8e', '\xa0'}, 3, 0x33A0}, /* (SQUARE CM SQUARED) */
    {{'\xe3', '\x8e', '\xa1'}, 3, 0x33A1}, /* (SQUARE M SQUARED) */
    {{'\xe3', '\x8e', '\xa2'}, 3, 0x33A2}, /* (SQUARE KM SQUARED) */
    {{'\xe3', '\x8f', '\x8a'}, 3, 0x33CA}, /* (SQUARE HA) */
    {{'\xe3', '\x8e', '\x8d'}, 3, 0x338D}, /* (SQUARE MU G) */
    {{'\xe3', '\x8e', '\x8e'}, 3, 0x338E}, /* (SQUARE MG) */
    {{'\xe3', '\x8e', '\x8f'}, 3, 0x338F}, /* (SQUARE KG) */
    {{'\xe3', '\x8f', '\x8f'}, 3, 0x33CF}, /* (SQUARE KT) */
    {{'\xe3', '\x8e', '\x88'}, 3, 0x3388}, /* (SQUARE CAL) */
    {{'\xe3', '\x8e', '\x89'}, 3, 0x3389}, /* (SQUARE KCAL) */
    {{'\xe3', '\x8f', '\x88'}, 3, 0x33C8}, /* (SQUARE DB) */
    {{'\xe3', '\x8e', '\xa7'}, 3, 0x33A7}, /* (SQUARE M OVER S) */
    {{'\xe3', '\x8e', '\xa8'}, 3, 0x33A8}, /* (SQUARE M OVER S SQUARED) */
    {{'\xe3', '\x8e', '\xb0'}, 3, 0x33B0}, /* (SQUARE PS) */
    {{'\xe3', '\x8e', '\xb1'}, 3, 0x33B1}, /* (SQUARE NS) */
    {{'\xe3', '\x8e', '\xb2'}, 3, 0x33B2}, /* (SQUARE MU S) */
    {{'\xe3', '\x8e', '\xb3'}, 3, 0x33B3}, /* (SQUARE MS) */
    {{'\xe3', '\x8e', '\xb4'}, 3, 0x33B4}, /* (SQUARE PV) */
    {{'\xe3', '\x8e', '\xb5'}, 3, 0x33B5}, /* (SQUARE NV) */
    {{'\xe3', '\x8e', '\xb6'}, 3, 0x33B6}, /* (SQUARE MU V) */
    {{'\xe3', '\x8e', '\xb7'}, 3, 0x33B7}, /* (SQUARE MV) */
    {{'\xe3', '\x8e', '\xb8'}, 3, 0x33B8}, /* (SQUARE KV) */
    {{'\xe3', '\x8e', '\xb9'}, 3, 0x33B9}, /* (SQUARE MV MEGA) */
    {{'\xe3', '\x8e', '\x80'}, 3, 0x3380}, /* (SQUARE PA AMPS) */
    {{'\xe3', '\x8e', '\x81'}, 3, 0x3381}, /* (SQUARE NA) */
    {{'\xe3', '\x8e', '\x82'}, 3, 0x3382}, /* (SQUARE MU A) */
    {{'\xe3', '\x8e', '\x83'}, 3, 0x3383}, /* (SQUARE MA) */
    {{'\xe3', '\x8e', '\x84'}, 3, 0x3384}, /* (SQUARE KA) */
    {{'\xe3', '\x8e', '\xba'}, 3, 0x33BA}, /* (SQUARE PW) */
    {{'\xe3', '\x8e', '\xbb'}, 3, 0x33BB}, /* (SQUARE NW) */
    {{'\xe3', '\x8e', '\xbc'}, 3, 0x33BC}, /* (SQUARE MU W) */
    {{'\xe3', '\x8e', '\xbd'}, 3, 0x33BD}, /* (SQUARE MW) */
    {{'\xe3', '\x8e', '\xbe'}, 3, 0x33BE}, /* (SQUARE KW) */
    {{'\xe3', '\x8e', '\xbf'}, 3, 0x33BF}, /* (SQUARE MW MEGA) */
    {{'\xe3', '\x8e', '\x90'}, 3, 0x3390}, /* (SQUARE HZ) */
    {{'\xe3', '\x8e', '\x91'}, 3, 0x3391}, /* (SQUARE KHZ) */
    {{'\xe3', '\x8e', '\x92'}, 3, 0x3392}, /* (SQUARE MHZ) */
    {{'\xe3', '\x8e', '\x93'}, 3, 0x3393}, /* (SQUARE GHZ) */
    {{'\xe3', '\x8e', '\x94'}, 3, 0x3394}, /* (SQUARE THZ) */
    {{'\xe2', '\x84', '\xa6'}, 3, 0x2126}, /* (OHM SIGN) */
    {{'\xe3', '\x8f', '\x80'}, 3, 0x33C0}, /* (SQUARE K OHM) */
    {{'\xe3', '\x8f', '\x81'}, 3, 0x33C1}, /* (SQUARE M OHM) */
    {{'\xe3', '\x8e', '\x8a'}, 3, 0x338A}, /* (SQUARE PF) */
    {{'\xe3', '\x8e', '\x8b'}, 3, 0x338B}, /* (SQUARE NF) */
    {{'\xe3', '\x8e', '\x8c'}, 3, 0x338C}, /* (SQUARE MU F) */
    {{'\xe3', '\x8f', '\x96'}, 3, 0x33D6}, /* (SQUARE MOL) */
    {{'\xe3', '\x8f', '\x85'}, 3, 0x33C5}, /* (SQUARE CD) */
    {{'\xe3', '\x8e', '\xad'}, 3, 0x33AD}, /* (SQUARE RAD) */
    {{'\xe3', '\x8e', '\xae'}, 3, 0x33AE}, /* (SQUARE RAD OVER S) */
    {{'\xe3', '\x8e', '\xaf'}, 3, 0x33AF}, /* (SQUARE RAD OVER S SQUARED) */
    {{'\xe3', '\x8f', '\x9b'}, 3, 0x33DB}, /* (SQUARE SR) */
    {{'\xe3', '\x8e', '\xa9'}, 3, 0x33A9}, /* (SQUARE PA) */
    {{'\xe3', '\x8e', '\xaa'}, 3, 0x33AA}, /* (SQUARE KPA) */
    {{'\xe3', '\x8e', '\xab'}, 3, 0x33AB}, /* (SQUARE MPA) */
    {{'\xe3', '\x8e', '\xac'}, 3, 0x33AC}, /* (SQUARE GPA) */
    {{'\xe3', '\x8f', '\x9d'}, 3, 0x33DD}, /* (SQUARE WB) */
    {{'\xe3', '\x8f', '\x90'}, 3, 0x33D0}, /* (SQUARE LM) */
    {{'\xe3', '\x8f', '\x93'}, 3, 0x33D3}, /* (SQUARE LX) */
    {{'\xe3', '\x8f', '\x83'}, 3, 0x33C3}, /* (SQUARE BQ) */
    {{'\xe3', '\x8f', '\x89'}, 3, 0x33C9}, /* (SQUARE GY) */
    {{'\xe3', '\x8f', '\x9c'}, 3, 0x33DC}, /* (SQUARE SV) */
    {{'\xe3', '\x8f', '\x86'}, 3, 0x33C6}, /* (SQUARE C OVER KG) */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{'\xec', '\xad', '\xad'}, 3, 0xCB6D}, /* (HANGUL SYLLABLE JJWEOLG) */
    {{'\xec', '\xad', '\xae'}, 3, 0xCB6E}, /* (HANGUL SYLLABLE JJWEOLM) */
    {{'\xec', '\xad', '\xaf'}, 3, 0xCB6F}, /* (HANGUL SYLLABLE JJWEOLB) */
    {{'\xec', '\xad', '\xb0'}, 3, 0xCB70}, /* (HANGUL SYLLABLE JJWEOLS) */
    {{'\xec', '\xad', '\xb1'}, 3, 0xCB71}, /* (HANGUL SYLLABLE JJWEOLT) */
    {{'\xec', '\xad', '\xb2'}, 3, 0xCB72}, /* (HANGUL SYLLABLE JJWEOLP) */
    {{'\xec', '\xad', '\xb3'}, 3, 0xCB73}, /* (HANGUL SYLLABLE JJWEOLH) */
    {{'\xec', '\xad', '\xb4'}, 3, 0xCB74}, /* (HANGUL SYLLABLE JJWEOM) */
    {{'\xec', '\xad', '\xb5'}, 3, 0xCB75}, /* (HANGUL SYLLABLE JJWEOB) */
    {{'\xec', '\xad', '\xb6'}, 3, 0xCB76}, /* (HANGUL SYLLABLE JJWEOBS) */
    {{'\xec', '\xad', '\xb7'}, 3, 0xCB77}, /* (HANGUL SYLLABLE JJWEOS) */
    {{'\xec', '\xad', '\xba'}, 3, 0xCB7A}, /* (HANGUL SYLLABLE JJWEOJ) */
    {{'\xec', '\xad', '\xbb'}, 3, 0xCB7B}, /* (HANGUL SYLLABLE JJWEOC) */
    {{'\xec', '\xad', '\xbc'}, 3, 0xCB7C}, /* (HANGUL SYLLABLE JJWEOK) */
    {{'\xec', '\xad', '\xbd'}, 3, 0xCB7D}, /* (HANGUL SYLLABLE JJWEOT) */
    {{'\xec', '\xad', '\xbe'}, 3, 0xCB7E}, /* (HANGUL SYLLABLE JJWEOP) */
    {{'\xec', '\xad', '\xbf'}, 3, 0xCB7F}, /* (HANGUL SYLLABLE JJWEOH) */
    {{'\xec', '\xae', '\x80'}, 3, 0xCB80}, /* (HANGUL SYLLABLE JJWE) */
    {{'\xec', '\xae', '\x81'}, 3, 0xCB81}, /* (HANGUL SYLLABLE JJWEG) */
    {{'\xec', '\xae', '\x82'}, 3, 0xCB82}, /* (HANGUL SYLLABLE JJWEGG) */
    {{'\xec', '\xae', '\x83'}, 3, 0xCB83}, /* (HANGUL SYLLABLE JJWEGS) */
    {{'\xec', '\xae', '\x84'}, 3, 0xCB84}, /* (HANGUL SYLLABLE JJWEN) */
    {{'\xec', '\xae', '\x85'}, 3, 0xCB85}, /* (HANGUL SYLLABLE JJWENJ) */
    {{'\xec', '\xae', '\x86'}, 3, 0xCB86}, /* (HANGUL SYLLABLE JJWENH) */
    {{'\xec', '\xae', '\x87'}, 3, 0xCB87}, /* (HANGUL SYLLABLE JJWED) */
    {{'\xec', '\xae', '\x88'}, 3, 0xCB88}, /* (HANGUL SYLLABLE JJWEL) */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{'\xec', '\xae', '\x89'}, 3, 0xCB89}, /* (HANGUL SYLLABLE JJWELG) */
    {{'\xec', '\xae', '\x8a'}, 3, 0xCB8A}, /* (HANGUL SYLLABLE JJWELM) */
    {{'\xec', '\xae', '\x8b'}, 3, 0xCB8B}, /* (HANGUL SYLLABLE JJWELB) */
    {{'\xec', '\xae', '\x8c'}, 3, 0xCB8C}, /* (HANGUL SYLLABLE JJWELS) */
    {{'\xec', '\xae', '\x8d'}, 3, 0xCB8D}, /* (HANGUL SYLLABLE JJWELT) */
    {{'\xec', '\xae', '\x8e'}, 3, 0xCB8E}, /* (HANGUL SYLLABLE JJWELP) */
    {{'\xec', '\xae', '\x8f'}, 3, 0xCB8F}, /* (HANGUL SYLLABLE JJWELH) */
    {{'\xec', '\xae', '\x90'}, 3, 0xCB90}, /* (HANGUL SYLLABLE JJWEM) */
    {{'\xec', '\xae', '\x91'}, 3, 0xCB91}, /* (HANGUL SYLLABLE JJWEB) */
    {{'\xec', '\xae', '\x92'}, 3, 0xCB92}, /* (HANGUL SYLLABLE JJWEBS) */
    {{'\xec', '\xae', '\x93'}, 3, 0xCB93}, /* (HANGUL SYLLABLE JJWES) */
    {{'\xec', '\xae', '\x94'}, 3, 0xCB94}, /* (HANGUL SYLLABLE JJWESS) */
    {{'\xec', '\xae', '\x95'}, 3, 0xCB95}, /* (HANGUL SYLLABLE JJWENG) */
    {{'\xec', '\xae', '\x96'}, 3, 0xCB96}, /* (HANGUL SYLLABLE JJWEJ) */
    {{'\xec', '\xae', '\x97'}, 3, 0xCB97}, /* (HANGUL SYLLABLE JJWEC) */
    {{'\xec', '\xae', '\x98'}, 3, 0xCB98}, /* (HANGUL SYLLABLE JJWEK) */
    {{'\xec', '\xae', '\x99'}, 3, 0xCB99}, /* (HANGUL SYLLABLE JJWET) */
    {{'\xec', '\xae', '\x9a'}, 3, 0xCB9A}, /* (HANGUL SYLLABLE JJWEP) */
    {{'\xec', '\xae', '\x9b'}, 3, 0xCB9B}, /* (HANGUL SYLLABLE JJWEH) */
    {{'\xec', '\xae', '\x9d'}, 3, 0xCB9D}, /* (HANGUL SYLLABLE JJWIG) */
    {{'\xec', '\xae', '\x9e'}, 3, 0xCB9E}, /* (HANGUL SYLLABLE JJWIGG) */
    {{'\xec', '\xae', '\x9f'}, 3, 0xCB9F}, /* (HANGUL SYLLABLE JJWIGS) */
    {{'\xec', '\xae', '\xa0'}, 3, 0xCBA0}, /* (HANGUL SYLLABLE JJWIN) */
    {{'\xec', '\xae', '\xa1'}, 3, 0xCBA1}, /* (HANGUL SYLLABLE JJWINJ) */
    {{'\xec', '\xae', '\xa2'}, 3, 0xCBA2}, /* (HANGUL SYLLABLE JJWINH) */
    {{'\xec', '\xae', '\xa3'}, 3, 0xCBA3}, /* (HANGUL SYLLABLE JJWID) */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{'\xec', '\xae', '\xa4'}, 3, 0xCBA4}, /* (HANGUL SYLLABLE JJWIL) */
    {{'\xec', '\xae', '\xa5'}, 3, 0xCBA5}, /* (HANGUL SYLLABLE JJWILG) */
    {{'\xec', '\xae', '\xa6'}, 3, 0xCBA6}, /* (HANGUL SYLLABLE JJWILM) */
    {{'\xec', '\xae', '\xa7'}, 3, 0xCBA7}, /* (HANGUL SYLLABLE JJWILB) */
    {{'\xec', '\xae', '\xa8'}, 3, 0xCBA8}, /* (HANGUL SYLLABLE JJWILS) */
    {{'\xec', '\xae', '\xa9'}, 3, 0xCBA9}, /* (HANGUL SYLLABLE JJWILT) */
    {{'\xec', '\xae', '\xaa'}, 3, 0xCBAA}, /* (HANGUL SYLLABLE JJWILP) */
    {{'\xec', '\xae', '\xab'}, 3, 0xCBAB}, /* (HANGUL SYLLABLE JJWILH) */
    {{'\xec', '\xae', '\xac'}, 3, 0xCBAC}, /* (HANGUL SYLLABLE JJWIM) */
    {{'\xec', '\xae', '\xad'}, 3, 0xCBAD}, /* (HANGUL SYLLABLE JJWIB) */
    {{'\xec', '\xae', '\xae'}, 3, 0xCBAE}, /* (HANGUL SYLLABLE JJWIBS) */
    {{'\xec', '\xae', '\xaf'}, 3, 0xCBAF}, /* (HANGUL SYLLABLE JJWIS) */
    {{'\xec', '\xae', '\xb0'}, 3, 0xCBB0}, /* (HANGUL SYLLABLE JJWISS) */
    {{'\xec', '\xae', '\xb1'}, 3, 0xCBB1}, /* (HANGUL SYLLABLE JJWING) */
    {{'\xec', '\xae', '\xb2'}, 3, 0xCBB2}, /* (HANGUL SYLLABLE JJWIJ) */
    {{'\xec', '\xae', '\xb3'}, 3, 0xCBB3}, /* (HANGUL SYLLABLE JJWIC) */
    {{'\xec', '\xae', '\xb4'}, 3, 0xCBB4}, /* (HANGUL SYLLABLE JJWIK) */
    {{'\xec', '\xae', '\xb5'}, 3, 0xCBB5}, /* (HANGUL SYLLABLE JJWIT) */
    {{'\xec', '\xae', '\xb6'}, 3, 0xCBB6}, /* (HANGUL SYLLABLE JJWIP) */
    {{'\xec', '\xae', '\xb7'}, 3, 0xCBB7}, /* (HANGUL SYLLABLE JJWIH) */
    {{'\xec', '\xae', '\xb9'}, 3, 0xCBB9}, /* (HANGUL SYLLABLE JJYUG) */
    {{'\xec', '\xae', '\xba'}, 3, 0xCBBA}, /* (HANGUL SYLLABLE JJYUGG) */
    {{'\xec', '\xae', '\xbb'}, 3, 0xCBBB}, /* (HANGUL SYLLABLE JJYUGS) */
    {{'\xec', '\xae', '\xbc'}, 3, 0xCBBC}, /* (HANGUL SYLLABLE JJYUN) */
    {{'\xec', '\xae', '\xbd'}, 3, 0xCBBD}, /* (HANGUL SYLLABLE JJYUNJ) */
    {{'\xec', '\xae', '\xbe'}, 3, 0xCBBE}, /* (HANGUL SYLLABLE JJYUNH) */
    {{'\xec', '\xae', '\xbf'}, 3, 0xCBBF}, /* (HANGUL SYLLABLE JJYUD) */
    {{'\xec', '\xaf', '\x80'}, 3, 0xCBC0}, /* (HANGUL SYLLABLE JJYUL) */
    {{'\xec', '\xaf', '\x81'}, 3, 0xCBC1}, /* (HANGUL SYLLABLE JJYULG) */
    {{'\xec', '\xaf', '\x82'}, 3, 0xCBC2}, /* (HANGUL SYLLABLE JJYULM) */
    {{'\xec', '\xaf', '\x83'}, 3, 0xCBC3}, /* (HANGUL SYLLABLE JJYULB) */
    {{'\xec', '\xaf', '\x84'}, 3, 0xCBC4}, /* (HANGUL SYLLABLE JJYULS) */
    {{'\xc3', '\x86'}, 2, 0x00C6}, /* (LATIN CAPITAL LETTER AE) */
    {{'\xc3', '\x90'}, 2, 0x00D0}, /* (LATIN CAPITAL LETTER ETH) */
    {{'\xc2', '\xaa'}, 2, 0x00AA}, /* (FEMININE ORDINAL INDICATOR) */
    {{'\xc4', '\xa6'}, 2, 0x0126}, /* (LATIN CAPITAL LETTER H WITH STROKE) */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{'\xc4', '\xb2'}, 2, 0x0132}, /* (LATIN CAPITAL LIGATURE IJ) */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{'\xc4', '\xbf'}, 2, 0x013F}, /* (LATIN CAPITAL LETTER L WITH MIDDLE DOT) */
    {{'\xc5', '\x81'}, 2, 0x0141}, /* (LATIN CAPITAL LETTER L WITH STROKE) */
    {{'\xc3', '\x98'}, 2, 0x00D8}, /* (LATIN CAPITAL LETTER O WITH STROKE) */
    {{'\xc5', '\x92'}, 2, 0x0152}, /* (LATIN CAPITAL LIGATURE OE) */
    {{'\xc2', '\xba'}, 2, 0x00BA}, /* (MASCULINE ORDINAL INDICATOR) */
    {{'\xc3', '\x9e'}, 2, 0x00DE}, /* (LATIN CAPITAL LETTER THORN) */
    {{'\xc5', '\xa6'}, 2, 0x0166}, /* (LATIN CAPITAL LETTER T WITH STROKE) */
    {{'\xc5', '\x8a'}, 2, 0x014A}, /* (LATIN CAPITAL LETTER ENG) */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{'\xe3', '\x89', '\xa0'}, 3, 0x3260}, /* (CIRCLED HANGUL KIYEOK) */
    {{'\xe3', '\x89', '\xa1'}, 3, 0x3261}, /* (CIRCLED HANGUL NIEUN) */
    {{'\xe3', '\x89', '\xa2'}, 3, 0x3262}, /* (CIRCLED HANGUL TIKEUT) */
    {{'\xe3', '\x89', '\xa3'}, 3, 0x3263}, /* (CIRCLED HANGUL RIEUL) */
    {{'\xe3', '\x89', '\xa4'}, 3, 0x3264}, /* (CIRCLED HANGUL MIEUM) */
    {{'\xe3', '\x89', '\xa5'}, 3, 0x3265}, /* (CIRCLED HANGUL PIEUP) */
    {{'\xe3', '\x89', '\xa6'}, 3, 0x3266}, /* (CIRCLED HANGUL SIOS) */
    {{'\xe3', '\x89', '\xa7'}, 3, 0x3267}, /* (CIRCLED HANGUL IEUNG) */
    {{'\xe3', '\x89', '\xa8'}, 3, 0x3268}, /* (CIRCLED HANGUL CIEUC) */
    {{'\xe3', '\x89', '\xa9'}, 3, 0x3269}, /* (CIRCLED HANGUL CHIEUCH) */
    {{'\xe3', '\x89', '\xaa'}, 3, 0x326A}, /* (CIRCLED HANGUL KHIEUKH) */
    {{'\xe3', '\x89', '\xab'}, 3, 0x326B}, /* (CIRCLED HANGUL THIEUTH) */
    {{'\xe3', '\x89', '\xac'}, 3, 0x326C}, /* (CIRCLED HANGUL PHIEUPH) */
    {{'\xe3', '\x89', '\xad'}, 3, 0x326D}, /* (CIRCLED HANGUL HIEUH) */
    {{'\xe3', '\x89', '\xae'}, 3, 0x326E}, /* (CIRCLED HANGUL KIYEOK A) */
    {{'\xe3', '\x89', '\xaf'}, 3, 0x326F}, /* (CIRCLED HANGUL NIEUN A) */
    {{'\xe3', '\x89', '\xb0'}, 3, 0x3270}, /* (CIRCLED HANGUL TIKEUT A) */
    {{'\xe3', '\x89', '\xb1'}, 3, 0x3271}, /* (CIRCLED HANGUL RIEUL A) */
    {{'\xe3', '\x89', '\xb2'}, 3, 0x3272}, /* (CIRCLED HANGUL MIEUM A) */
    {{'\xe3', '\x89', '\xb3'}, 3, 0x3273}, /* (CIRCLED HANGUL PIEUP A) */
    {{'\xe3', '\x89', '\xb4'}, 3, 0x3274}, /* (CIRCLED HANGUL SIOS A) */
    {{'\xe3', '\x89', '\xb5'}, 3, 0x3275}, /* (CIRCLED HANGUL IEUNG A) */
    {{'\xe3', '\x89', '\xb6'}, 3, 0x3276}, /* (CIRCLED HANGUL CIEUC A) */
    {{'\xe3', '\x89', '\xb7'}, 3, 0x3277}, /* (CIRCLED HANGUL CHIEUCH A) */
    {{'\xe3', '\x89', '\xb8'}, 3, 0x3278}, /* (CIRCLED HANGUL KHIEUKH A) */
    {{'\xe3', '\x89', '\xb9'}, 3, 0x3279}, /* (CIRCLED HANGUL THIEUTH A) */
    {{'\xe3', '\x89', '\xba'}, 3, 0x327A}, /* (CIRCLED HANGUL PHIEUPH A) */
    {{'\xe3', '\x89', '\xbb'}, 3, 0x327B}, /* (CIRCLED HANGUL HIEUH A) */
    {{'\xe2', '\x93', '\x90'}, 3, 0x24D0}, /* (CIRCLED LATIN SMALL LETTER A) */
    {{'\xe2', '\x93', '\x91'}, 3, 0x24D1}, /* (CIRCLED LATIN SMALL LETTER B) */
    {{'\xe2', '\x93', '\x92'}, 3, 0x24D2}, /* (CIRCLED LATIN SMALL LETTER C) */
    {{'\xe2', '\x93', '\x93'}, 3, 0x24D3}, /* (CIRCLED LATIN SMALL LETTER D) */
    {{'\xe2', '\x93', '\x94'}, 3, 0x24D4}, /* (CIRCLED LATIN SMALL LETTER E) */
    {{'\xe2', '\x93', '\x95'}, 3, 0x24D5}, /* (CIRCLED LATIN SMALL LETTER F) */
    {{'\xe2', '\x93', '\x96'}, 3, 0x24D6}, /* (CIRCLED LATIN SMALL LETTER G) */
    {{'\xe2', '\x93', '\x97'}, 3, 0x24D7}, /* (CIRCLED LATIN SMALL LETTER H) */
    {{'\xe2', '\x93', '\x98'}, 3, 0x24D8}, /* (CIRCLED LATIN SMALL LETTER I) */
    {{'\xe2', '\x93', '\x99'}, 3, 0x24D9}, /* (CIRCLED LATIN SMALL LETTER J) */
    {{'\xe2', '\x93', '\x9a'}, 3, 0x24DA}, /* (CIRCLED LATIN SMALL LETTER K) */
    {{'\xe2', '\x93', '\x9b'}, 3, 0x24DB}, /* (CIRCLED LATIN SMALL LETTER L) */
    {{'\xe2', '\x93', '\x9c'}, 3, 0x24DC}, /* (CIRCLED LATIN SMALL LETTER M) */
    {{'\xe2', '\x93', '\x9d'}, 3, 0x24DD}, /* (CIRCLED LATIN SMALL LETTER N) */
    {{'\xe2', '\x93', '\x9e'}, 3, 0x24DE}, /* (CIRCLED LATIN SMALL LETTER O) */
    {{'\xe2', '\x93', '\x9f'}, 3, 0x24DF}, /* (CIRCLED LATIN SMALL LETTER P) */
    {{'\xe2', '\x93', '\xa0'}, 3, 0x24E0}, /* (CIRCLED LATIN SMALL LETTER Q) */
    {{'\xe2', '\x93', '\xa1'}, 3, 0x24E1}, /* (CIRCLED LATIN SMALL LETTER R) */
    {{'\xe2', '\x93', '\xa2'}, 3, 0x24E2}, /* (CIRCLED LATIN SMALL LETTER S) */
    {{'\xe2', '\x93', '\xa3'}, 3, 0x24E3}, /* (CIRCLED LATIN SMALL LETTER T) */
    {{'\xe2', '\x93', '\xa4'}, 3, 0x24E4}, /* (CIRCLED LATIN SMALL LETTER U) */
    {{'\xe2', '\x93', '\xa5'}, 3, 0x24E5}, /* (CIRCLED LATIN SMALL LETTER V) */
    {{'\xe2', '\x93', '\xa6'}, 3, 0x24E6}, /* (CIRCLED LATIN SMALL LETTER W) */
    {{'\xe2', '\x93', '\xa7'}, 3, 0x24E7}, /* (CIRCLED LATIN SMALL LETTER X) */
    {{'\xe2', '\x93', '\xa8'}, 3, 0x24E8}, /* (CIRCLED LATIN SMALL LETTER Y) */
    {{'\xe2', '\x93', '\xa9'}, 3, 0x24E9}, /* (CIRCLED LATIN SMALL LETTER Z) */
    {{'\xe2', '\x91', '\xa0'}, 3, 0x2460}, /* (CIRCLED DIGIT ONE) */
    {{'\xe2', '\x91', '\xa1'}, 3, 0x2461}, /* (CIRCLED DIGIT TWO) */
    {{'\xe2', '\x91', '\xa2'}, 3, 0x2462}, /* (CIRCLED DIGIT THREE) */
    {{'\xe2', '\x91', '\xa3'}, 3, 0x2463}, /* (CIRCLED DIGIT FOUR) */
    {{'\xe2', '\x91', '\xa4'}, 3, 0x2464}, /* (CIRCLED DIGIT FIVE) */
    {{'\xe2', '\x91', '\xa5'}, 3, 0x2465}, /* (CIRCLED DIGIT SIX) */
    {{'\xe2', '\x91', '\xa6'}, 3, 0x2466}, /* (CIRCLED DIGIT SEVEN) */
    {{'\xe2', '\x91', '\xa7'}, 3, 0x2467}, /* (CIRCLED DIGIT EIGHT) */
    {{'\xe2', '\x91', '\xa8'}, 3, 0x2468}, /* (CIRCLED DIGIT NINE) */
    {{'\xe2', '\x91', '\xa9'}, 3, 0x2469}, /* (CIRCLED NUMBER TEN) */
    {{'\xe2', '\x91', '\xaa'}, 3, 0x246A}, /* (CIRCLED NUMBER ELEVEN) */
    {{'\xe2', '\x91', '\xab'}, 3, 0x246B}, /* (CIRCLED NUMBER TWELVE) */
    {{'\xe2', '\x91', '\xac'}, 3, 0x246C}, /* (CIRCLED NUMBER THIRTEEN) */
    {{'\xe2', '\x91', '\xad'}, 3, 0x246D}, /* (CIRCLED NUMBER FOURTEEN) */
    {{'\xe2', '\x91', '\xae'}, 3, 0x246E}, /* (CIRCLED NUMBER FIFTEEN) */
    {{'\xc2', '\xbd'}, 2, 0x00BD}, /* (VULGAR FRACTION ONE HALF) */
    {{'\xe2', '\x85', '\x93'}, 3, 0x2153}, /* (VULGAR FRACTION ONE THIRD) */
    {{'\xe2', '\x85', '\x94'}, 3, 0x2154}, /* (VULGAR FRACTION TWO THIRDS) */
    {{'\xc2', '\xbc'}, 2, 0x00BC}, /* (VULGAR FRACTION ONE QUARTER) */
    {{'\xc2', '\xbe'}, 2, 0x00BE}, /* (VULGAR FRACTION THREE QUARTERS) */
    {{'\xe2', '\x85', '\x9b'}, 3, 0x215B}, /* (VULGAR FRACTION ONE EIGHTH) */
    {{'\xe2', '\x85', '\x9c'}, 3, 0x215C}, /* (VULGAR FRACTION THREE EIGHTHS) */
    {{'\xe2', '\x85', '\x9d'}, 3, 0x215D}, /* (VULGAR FRACTION FIVE EIGHTHS) */
    {{'\xe2', '\x85', '\x9e'}, 3, 0x215E}, /* (VULGAR FRACTION SEVEN EIGHTHS) */
    {{'\xec', '\xaf', '\x85'}, 3, 0xCBC5}, /* (HANGUL SYLLABLE JJYULT) */
    {{'\xec', '\xaf', '\x86'}, 3, 0xCBC6}, /* (HANGUL SYLLABLE JJYULP) */
    {{'\xec', '\xaf', '\x87'}, 3, 0xCBC7}, /* (HANGUL SYLLABLE JJYULH) */
    {{'\xec', '\xaf', '\x88'}, 3, 0xCBC8}, /* (HANGUL SYLLABLE JJYUM) */
    {{'\xec', '\xaf', '\x89'}, 3, 0xCBC9}, /* (HANGUL SYLLABLE JJYUB) */
    {{'\xec', '\xaf', '\x8a'}, 3, 0xCBCA}, /* (HANGUL SYLLABLE JJYUBS) */
    {{'\xec', '\xaf', '\x8b'}, 3, 0xCBCB}, /* (HANGUL SYLLABLE JJYUS) */
    {{'\xec', '\xaf', '\x8c'}, 3, 0xCBCC}, /* (HANGUL SYLLABLE JJYUSS) */
    {{'\xec', '\xaf', '\x8d'}, 3, 0xCBCD}, /* (HANGUL SYLLABLE JJYUNG) */
    {{'\xec', '\xaf', '\x8e'}, 3, 0xCBCE}, /* (HANGUL SYLLABLE JJYUJ) */
    {{'\xec', '\xaf', '\x8f'}, 3, 0xCBCF}, /* (HANGUL SYLLABLE JJYUC) */
    {{'\xec', '\xaf', '\x90'}, 3, 0xCBD0}, /* (HANGUL SYLLABLE JJYUK) */
    {{'\xec', '\xaf', '\x91'}, 3, 0xCBD1}, /* (HANGUL SYLLABLE JJYUT) */
    {{'\xec', '\xaf', '\x92'}, 3, 0xCBD2}, /* (HANGUL SYLLABLE JJYUP) */
    {{'\xec', '\xaf', '\x93'}, 3, 0xCBD3}, /* (HANGUL SYLLABLE JJYUH) */
    {{'\xec', '\xaf', '\x95'}, 3, 0xCBD5}, /* (HANGUL SYLLABLE JJEUG) */
    {{'\xec', '\xaf', '\x96'}, 3, 0xCBD6}, /* (HANGUL SYLLABLE JJEUGG) */
    {{'\xec', '\xaf', '\x97'}, 3, 0xCBD7}, /* (HANGUL SYLLABLE JJEUGS) */
    {{'\xec', '\xaf', '\x98'}, 3, 0xCBD8}, /* (HANGUL SYLLABLE JJEUN) */
    {{'\xec', '\xaf', '\x99'}, 3, 0xCBD9}, /* (HANGUL SYLLABLE JJEUNJ) */
    {{'\xec', '\xaf', '\x9a'}, 3, 0xCBDA}, /* (HANGUL SYLLABLE JJEUNH) */
    {{'\xec', '\xaf', '\x9b'}, 3, 0xCBDB}, /* (HANGUL SYLLABLE JJEUD) */
    {{'\xec', '\xaf', '\x9c'}, 3, 0xCBDC}, /* (HANGUL SYLLABLE JJEUL) */
    {{'\xec', '\xaf', '\x9d'}, 3, 0xCBDD}, /* (HANGUL SYLLABLE JJEULG) */
    {{'\xec', '\xaf', '\x9e'}, 3, 0xCBDE}, /* (HANGUL SYLLABLE JJEULM) */
    {{'\xec', '\xaf', '\x9f'}, 3, 0xCBDF}, /* (HANGUL SYLLABLE JJEULB) */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{'\xec', '\xaf', '\xa0'}, 3, 0xCBE0}, /* (HANGUL SYLLABLE JJEULS) */
    {{'\xec', '\xaf', '\xa1'}, 3, 0xCBE1}, /* (HANGUL SYLLABLE JJEULT) */
    {{'\xec', '\xaf', '\xa2'}, 3, 0xCBE2}, /* (HANGUL SYLLABLE JJEULP) */
    {{'\xec', '\xaf', '\xa3'}, 3, 0xCBE3}, /* (HANGUL SYLLABLE JJEULH) */
    {{'\xec', '\xaf', '\xa5'}, 3, 0xCBE5}, /* (HANGUL SYLLABLE JJEUB) */
    {{'\xec', '\xaf', '\xa6'}, 3, 0xCBE6}, /* (HANGUL SYLLABLE JJEUBS) */
    {{'\xec', '\xaf', '\xa8'}, 3, 0xCBE8}, /* (HANGUL SYLLABLE JJEUSS) */
    {{'\xec', '\xaf', '\xaa'}, 3, 0xCBEA}, /* (HANGUL SYLLABLE JJEUJ) */
    {{'\xec', '\xaf', '\xab'}, 3, 0xCBEB}, /* (HANGUL SYLLABLE JJEUC) */
    {{'\xec', '\xaf', '\xac'}, 3, 0xCBEC}, /* (HANGUL SYLLABLE JJEUK) */
    {{'\xec', '\xaf', '\xad'}, 3, 0xCBED}, /* (HANGUL SYLLABLE JJEUT) */
    {{'\xec', '\xaf', '\xae'}, 3, 0xCBEE}, /* (HANGUL SYLLABLE JJEUP) */
    {{'\xec', '\xaf', '\xaf'}, 3, 0xCBEF}, /* (HANGUL SYLLABLE JJEUH) */
    {{'\xec', '\xaf', '\xb0'}, 3, 0xCBF0}, /* (HANGUL SYLLABLE JJYI) */
    {{'\xec', '\xaf', '\xb1'}, 3, 0xCBF1}, /* (HANGUL SYLLABLE JJYIG) */
    {{'\xec', '\xaf', '\xb2'}, 3, 0xCBF2}, /* (HANGUL SYLLABLE JJYIGG) */
    {{'\xec', '\xaf', '\xb3'}, 3, 0xCBF3}, /* (HANGUL SYLLABLE JJYIGS) */
    {{'\xec', '\xaf', '\xb4'}, 3, 0xCBF4}, /* (HANGUL SYLLABLE JJYIN) */
    {{'\xec', '\xaf', '\xb5'}, 3, 0xCBF5}, /* (HANGUL SYLLABLE JJYINJ) */
    {{'\xec', '\xaf', '\xb6'}, 3, 0xCBF6}, /* (HANGUL SYLLABLE JJYINH) */
    {{'\xec', '\xaf', '\xb7'}, 3, 0xCBF7}, /* (HANGUL SYLLABLE JJYID) */
    {{'\xec', '\xaf', '\xb8'}, 3, 0xCBF8}, /* (HANGUL SYLLABLE JJYIL) */
    {{'\xec', '\xaf', '\xb9'}, 3, 0xCBF9}, /* (HANGUL SYLLABLE JJYILG) */
    {{'\xec', '\xaf', '\xba'}, 3, 0xCBFA}, /* (HANGUL SYLLABLE JJYILM) */
    {{'\xec', '\xaf', '\xbb'}, 3, 0xCBFB}, /* (HANGUL SYLLABLE JJYILB) */
    {{'\xec', '\xaf', '\xbc'}, 3, 0xCBFC}, /* (HANGUL SYLLABLE JJYILS) */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{'\xec', '\xaf', '\xbd'}, 3, 0xCBFD}, /* (HANGUL SYLLABLE JJYILT) */
    {{'\xec', '\xaf', '\xbe'}, 3, 0xCBFE}, /* (HANGUL SYLLABLE JJYILP) */
    {{'\xec', '\xaf', '\xbf'}, 3, 0xCBFF}, /* (HANGUL SYLLABLE JJYILH) */
    {{'\xec', '\xb0', '\x80'}, 3, 0xCC00}, /* (HANGUL SYLLABLE JJYIM) */
    {{'\xec', '\xb0', '\x81'}, 3, 0xCC01}, /* (HANGUL SYLLABLE JJYIB) */
    {{'\xec', '\xb0', '\x82'}, 3, 0xCC02}, /* (HANGUL SYLLABLE JJYIBS) */
    {{'\xec', '\xb0', '\x83'}, 3, 0xCC03}, /* (HANGUL SYLLABLE JJYIS) */
    {{'\xec', '\xb0', '\x84'}, 3, 0xCC04}, /* (HANGUL SYLLABLE JJYISS) */
    {{'\xec', '\xb0', '\x85'}, 3, 0xCC05}, /* (HANGUL SYLLABLE JJYING) */
    {{'\xec', '\xb0', '\x86'}, 3, 0xCC06}, /* (HANGUL SYLLABLE JJYIJ) */
    {{'\xec', '\xb0', '\x87'}, 3, 0xCC07}, /* (HANGUL SYLLABLE JJYIC) */
    {{'\xec', '\xb0', '\x88'}, 3, 0xCC08}, /* (HANGUL SYLLABLE JJYIK) */
    {{'\xec', '\xb0', '\x89'}, 3, 0xCC09}, /* (HANGUL SYLLABLE JJYIT) */
    {{'\xec', '\xb0', '\x8a'}, 3, 0xCC0A}, /* (HANGUL SYLLABLE JJYIP) */
    {{'\xec', '\xb0', '\x8b'}, 3, 0xCC0B}, /* (HANGUL SYLLABLE JJYIH) */
    {{'\xec', '\xb0', '\x8e'}, 3, 0xCC0E}, /* (HANGUL SYLLABLE JJIGG) */
    {{'\xec', '\xb0', '\x8f'}, 3, 0xCC0F}, /* (HANGUL SYLLABLE JJIGS) */
    {{'\xec', '\xb0', '\x91'}, 3, 0xCC11}, /* (HANGUL SYLLABLE JJINJ) */
    {{'\xec', '\xb0', '\x92'}, 3, 0xCC12}, /* (HANGUL SYLLABLE JJINH) */
    {{'\xec', '\xb0', '\x93'}, 3, 0xCC13}, /* (HANGUL SYLLABLE JJID) */
    {{'\xec', '\xb0', '\x95'}, 3, 0xCC15}, /* (HANGUL SYLLABLE JJILG) */
    {{'\xec', '\xb0', '\x96'}, 3, 0xCC16}, /* (HANGUL SYLLABLE JJILM) */
    {{'\xec', '\xb0', '\x97'}, 3, 0xCC17}, /* (HANGUL SYLLABLE JJILB) */
    {{'\xec', '\xb0', '\x98'}, 3, 0xCC18}, /* (HANGUL SYLLABLE JJILS) */
    {{'\xec', '\xb0', '\x99'}, 3, 0xCC19}, /* (HANGUL SYLLABLE JJILT) */
    {{'\xec', '\xb0', '\x9a'}, 3, 0xCC1A}, /* (HANGUL SYLLABLE JJILP) */
    {{'\xec', '\xb0', '\x9b'}, 3, 0xCC1B}, /* (HANGUL SYLLABLE JJILH) */
    {{'\xec', '\xb0', '\x9e'}, 3, 0xCC1E}, /* (HANGUL SYLLABLE JJIBS) */
    {{'\xec', '\xb0', '\x9f'}, 3, 0xCC1F}, /* (HANGUL SYLLABLE JJIS) */
    {{'\xec', '\xb0', '\xa0'}, 3, 0xCC20}, /* (HANGUL SYLLABLE JJISS) */
    {{'\xec', '\xb0', '\xa3'}, 3, 0xCC23}, /* (HANGUL SYLLABLE JJIC) */
    {{'\xec', '\xb0', '\xa4'}, 3, 0xCC24}, /* (HANGUL SYLLABLE JJIK) */
    {{'\xc3', '\xa6'}, 2, 0x00E6}, /* (LATIN SMALL LETTER AE) */
    {{'\xc4', '\x91'}, 2, 0x0111}, /* (LATIN SMALL LETTER D WITH STROKE) */
    {{'\xc3', '\xb0'}, 2, 0x00F0}, /* (LATIN SMALL LETTER ETH) */
    {{'\xc4', '\xa7'}, 2, 0x0127}, /* (LATIN SMALL LETTER H WITH STROKE) */
    {{'\xc4', '\xb1'}, 2, 0x0131}, /* (LATIN SMALL LETTER DOTLESS I) */
    {{'\xc4', '\xb3'}, 2, 0x0133}, /* (LATIN SMALL LIGATURE IJ) */
    {{'\xc4', '\xb8'}, 2, 0x0138}, /* (LATIN SMALL LETTER KRA) */
    {{'\xc5', '\x80'}, 2, 0x0140}, /* (LATIN SMALL LETTER L WITH MIDDLE DOT) */
    {{'\xc5', '\x82'}, 2, 0x0142}, /* (LATIN SMALL LETTER L WITH STROKE) */
    {{'\xc3', '\xb8'}, 2, 0x00F8}, /* (LATIN SMALL LETTER O WITH STROKE) */
    {{'\xc5', '\x93'}, 2, 0x0153}, /* (LATIN SMALL LIGATURE OE) */
    {{'\xc3', '\x9f'}, 2, 0x00DF}, /* (LATIN SMALL LETTER SHARP S) */
    {{'\xc3', '\xbe'}, 2, 0x00FE}, /* (LATIN SMALL LETTER THORN) */
    {{'\xc5', '\xa7'}, 2, 0x0167}, /* (LATIN SMALL LETTER T WITH STROKE) */
    {{'\xc5', '\x8b'}, 2, 0x014B}, /* (LATIN SMALL LETTER ENG) */
    {{'\xc5', '\x89'}, 2, 0x0149}, /* (LATIN SMALL LETTER N PRECEDED BY APOSTROPHE) */
    {{'\xe3', '\x88', '\x80'}, 3, 0x3200}, /* (PARENTHESIZED HANGUL KIYEOK) */
    {{'\xe3', '\x88', '\x81'}, 3, 0x3201}, /* (PARENTHESIZED HANGUL NIEUN) */
    {{'\xe3', '\x88', '\x82'}, 3, 0x3202}, /* (PARENTHESIZED HANGUL TIKEUT) */
    {{'\xe3', '\x88', '\x83'}, 3, 0x3203}, /* (PARENTHESIZED HANGUL RIEUL) */
    {{'\xe3', '\x88', '\x84'}, 3, 0x3204}, /* (PARENTHESIZED HANGUL MIEUM) */
    {{'\xe3', '\x88', '\x85'}, 3, 0x3205}, /* (PARENTHESIZED HANGUL PIEUP) */
    {{'\xe3', '\x88', '\x86'}, 3, 0x3206}, /* (PARENTHESIZED HANGUL SIOS) */
    {{'\xe3', '\x88', '\x87'}, 3, 0x3207}, /* (PARENTHESIZED HANGUL IEUNG) */
    {{'\xe3', '\x88', '\x88'}, 3, 0x3208}, /* (PARENTHESIZED HANGUL CIEUC) */
    {{'\xe3', '\x88', '\x89'}, 3, 0x3209}, /* (PARENTHESIZED HANGUL CHIEUCH) */
    {{'\xe3', '\x88', '\x8a'}, 3, 0x320A}, /* (PARENTHESIZED HANGUL KHIEUKH) */
    {{'\xe3', '\x88', '\x8b'}, 3, 0x320B}, /* (PARENTHESIZED HANGUL THIEUTH) */
    {{'\xe3', '\x88', '\x8c'}, 3, 0x320C}, /* (PARENTHESIZED HANGUL PHIEUPH) */
    {{'\xe3', '\x88', '\x8d'}, 3, 0x320D}, /* (PARENTHESIZED HANGUL HIEUH) */
    {{'\xe3', '\x88', '\x8e'}, 3, 0x320E}, /* (PARENTHESIZED HANGUL KIYEOK A) */
    {{'\xe3', '\x88', '\x8f'}, 3, 0x320F}, /* (PARENTHESIZED HANGUL NIEUN A) */
    {{'\xe3', '\x88', '\x90'}, 3, 0x3210}, /* (PARENTHESIZED HANGUL TIKEUT A) */
    {{'\xe3', '\x88', '\x91'}, 3, 0x3211}, /* (PARENTHESIZED HANGUL RIEUL A) */
    {{'\xe3', '\x88', '\x92'}, 3, 0x3212}, /* (PARENTHESIZED HANGUL MIEUM A) */
    {{'\xe3', '\x88', '\x93'}, 3, 0x3213}, /* (PARENTHESIZED HANGUL PIEUP A) */
    {{'\xe3', '\x88', '\x94'}, 3, 0x3214}, /* (PARENTHESIZED HANGUL SIOS A) */
    {{'\xe3', '\x88', '\x95'}, 3, 0x3215}, /* (PARENTHESIZED HANGUL IEUNG A) */
    {{'\xe3', '\x88', '\x96'}, 3, 0x3216}, /* (PARENTHESIZED HANGUL CIEUC A) */
    {{'\xe3', '\x88', '\x97'}, 3, 0x3217}, /* (PARENTHESIZED HANGUL CHIEUCH A) */
    {{'\xe3', '\x88', '\x98'}, 3, 0x3218}, /* (PARENTHESIZED HANGUL KHIEUKH A) */
    {{'\xe3', '\x88', '\x99'}, 3, 0x3219}, /* (PARENTHESIZED HANGUL THIEUTH A) */
    {{'\xe3', '\x88', '\x9a'}, 3, 0x321A}, /* (PARENTHESIZED HANGUL PHIEUPH A) */
    {{'\xe3', '\x88', '\x9b'}, 3, 0x321B}, /* (PARENTHESIZED HANGUL HIEUH A) */
    {{'\xe2', '\x92', '\x9c'}, 3, 0x249C}, /* (PARENTHESIZED LATIN SMALL LETTER A) */
    {{'\xe2', '\x92', '\x9d'}, 3, 0x249D}, /* (PARENTHESIZED LATIN SMALL LETTER B) */
    {{'\xe2', '\x92', '\x9e'}, 3, 0x249E}, /* (PARENTHESIZED LATIN SMALL LETTER C) */
    {{'\xe2', '\x92', '\x9f'}, 3, 0x249F}, /* (PARENTHESIZED LATIN SMALL LETTER D) */
    {{'\xe2', '\x92', '\xa0'}, 3, 0x24A0}, /* (PARENTHESIZED LATIN SMALL LETTER E) */
    {{'\xe2', '\x92', '\xa1'}, 3, 0x24A1}, /* (PARENTHESIZED LATIN SMALL LETTER F) */
    {{'\xe2', '\x92', '\xa2'}, 3, 0x24A2}, /* (PARENTHESIZED LATIN SMALL LETTER G) */
    {{'\xe2', '\x92', '\xa3'}, 3, 0x24A3}, /* (PARENTHESIZED LATIN SMALL LETTER H) */
    {{'\xe2', '\x92', '\xa4'}, 3, 0x24A4}, /* (PARENTHESIZED LATIN SMALL LETTER I) */
    {{'\xe2', '\x92', '\xa5'}, 3, 0x24A5}, /* (PARENTHESIZED LATIN SMALL LETTER J) */
    {{'\xe2', '\x92', '\xa6'}, 3, 0x24A6}, /* (PARENTHESIZED LATIN SMALL LETTER K) */
    {{'\xe2', '\x92', '\xa7'}, 3, 0x24A7}, /* (PARENTHESIZED LATIN SMALL LETTER L) */
    {{'\xe2', '\x92', '\xa8'}, 3, 0x24A8}, /* (PARENTHESIZED LATIN SMALL LETTER M) */
    {{'\xe2', '\x92', '\xa9'}, 3, 0x24A9}, /* (PARENTHESIZED LATIN SMALL LETTER N) */
    {{'\xe2', '\x92', '\xaa'}, 3, 0x24AA}, /* (PARENTHESIZED LATIN SMALL LETTER O) */
    {{'\xe2', '\x92', '\xab'}, 3, 0x24AB}, /* (PARENTHESIZED LATIN SMALL LETTER P) */
    {{'\xe2', '\x92', '\xac'}, 3, 0x24AC}, /* (PARENTHESIZED LATIN SMALL LETTER Q) */
    {{'\xe2', '\x92', '\xad'}, 3, 0x24AD}, /* (PARENTHESIZED LATIN SMALL LETTER R) */
    {{'\xe2', '\x92', '\xae'}, 3, 0x24AE}, /* (PARENTHESIZED LATIN SMALL LETTER S) */
    {{'\xe2', '\x92', '\xaf'}, 3, 0x24AF}, /* (PARENTHESIZED LATIN SMALL LETTER T) */
    {{'\xe2', '\x92', '\xb0'}, 3, 0x24B0}, /* (PARENTHESIZED LATIN SMALL LETTER U) */
    {{'\xe2', '\x92', '\xb1'}, 3, 0x24B1}, /* (PARENTHESIZED LATIN SMALL LETTER V) */
    {{'\xe2', '\x92', '\xb2'}, 3, 0x24B2}, /* (PARENTHESIZED LATIN SMALL LETTER W) */
    {{'\xe2', '\x92', '\xb3'}, 3, 0x24B3}, /* (PARENTHESIZED LATIN SMALL LETTER X) */
    {{'\xe2', '\x92', '\xb4'}, 3, 0x24B4}, /* (PARENTHESIZED LATIN SMALL LETTER Y) */
    {{'\xe2', '\x92', '\xb5'}, 3, 0x24B5}, /* (PARENTHESIZED LATIN SMALL LETTER Z) */
    {{'\xe2', '\x91', '\xb4'}, 3, 0x2474}, /* (PARENTHESIZED DIGIT ONE) */
    {{'\xe2', '\x91', '\xb5'}, 3, 0x2475}, /* (PARENTHESIZED DIGIT TWO) */
    {{'\xe2', '\x91', '\xb6'}, 3, 0x2476}, /* (PARENTHESIZED DIGIT THREE) */
    {{'\xe2', '\x91', '\xb7'}, 3, 0x2477}, /* (PARENTHESIZED DIGIT FOUR) */
    {{'\xe2', '\x91', '\xb8'}, 3, 0x2478}, /* (PARENTHESIZED DIGIT FIVE) */
    {{'\xe2', '\x91', '\xb9'}, 3, 0x2479}, /* (PARENTHESIZED DIGIT SIX) */
    {{'\xe2', '\x91', '\xba'}, 3, 0x247A}, /* (PARENTHESIZED DIGIT SEVEN) */
    {{'\xe2', '\x91', '\xbb'}, 3, 0x247B}, /* (PARENTHESIZED DIGIT EIGHT) */
    {{'\xe2', '\x91', '\xbc'}, 3, 0x247C}, /* (PARENTHESIZED DIGIT NINE) */
    {{'\xe2', '\x91', '\xbd'}, 3, 0x247D}, /* (PARENTHESIZED NUMBER TEN) */
    {{'\xe2', '\x91', '\xbe'}, 3, 0x247E}, /* (PARENTHESIZED NUMBER ELEVEN) */
    {{'\xe2', '\x91', '\xbf'}, 3, 0x247F}, /* (PARENTHESIZED NUMBER TWELVE) */
    {{'\xe2', '\x92', '\x80'}, 3, 0x2480}, /* (PARENTHESIZED NUMBER THIRTEEN) */
    {{'\xe2', '\x92', '\x81'}, 3, 0x2481}, /* (PARENTHESIZED NUMBER FOURTEEN) */
    {{'\xe2', '\x92', '\x82'}, 3, 0x2482}, /* (PARENTHESIZED NUMBER FIFTEEN) */
    {{'\xc2', '\xb9'}, 2, 0x00B9}, /* (SUPERSCRIPT ONE) */
    {{'\xc2', '\xb2'}, 2, 0x00B2}, /* (SUPERSCRIPT TWO) */
    {{'\xc2', '\xb3'}, 2, 0x00B3}, /* (SUPERSCRIPT THREE) */
    {{'\xe2', '\x81', '\xb4'}, 3, 0x2074}, /* (SUPERSCRIPT FOUR) */
    {{'\xe2', '\x81', '\xbf'}, 3, 0x207F}, /* (SUPERSCRIPT LATIN SMALL LETTER N) */
    {{'\xe2', '\x82', '\x81'}, 3, 0x2081}, /* (SUBSCRIPT ONE) */
    {{'\xe2', '\x82', '\x82'}, 3, 0x2082}, /* (SUBSCRIPT TWO) */
    {{'\xe2', '\x82', '\x83'}, 3, 0x2083}, /* (SUBSCRIPT THREE) */
    {{'\xe2', '\x82', '\x84'}, 3, 0x2084}, /* (SUBSCRIPT FOUR) */
    {{'\xec', '\xb0', '\xa5'}, 3, 0xCC25}, /* (HANGUL SYLLABLE JJIT) */
    {{'\xec', '\xb0', '\xa6'}, 3, 0xCC26}, /* (HANGUL SYLLABLE JJIP) */
    {{'\xec', '\xb0', '\xaa'}, 3, 0xCC2A}, /* (HANGUL SYLLABLE CAGG) */
    {{'\xec', '\xb0', '\xab'}, 3, 0xCC2B}, /* (HANGUL SYLLABLE CAGS) */
    {{'\xec', '\xb0', '\xad'}, 3, 0xCC2D}, /* (HANGUL SYLLABLE CANJ) */
    {{'\xec', '\xb0', '\xaf'}, 3, 0xCC2F}, /* (HANGUL SYLLABLE CAD) */
    {{'\xec', '\xb0', '\xb1'}, 3, 0xCC31}, /* (HANGUL SYLLABLE CALG) */
    {{'\xec', '\xb0', '\xb2'}, 3, 0xCC32}, /* (HANGUL SYLLABLE CALM) */
    {{'\xec', '\xb0', '\xb3'}, 3, 0xCC33}, /* (HANGUL SYLLABLE CALB) */
    {{'\xec', '\xb0', '\xb4'}, 3, 0xCC34}, /* (HANGUL SYLLABLE CALS) */
    {{'\xec', '\xb0', '\xb5'}, 3, 0xCC35}, /* (HANGUL SYLLABLE CALT) */
    {{'\xec', '\xb0', '\xb6'}, 3, 0xCC36}, /* (HANGUL SYLLABLE CALP) */
    {{'\xec', '\xb0', '\xb7'}, 3, 0xCC37}, /* (HANGUL SYLLABLE CALH) */
    {{'\xec', '\xb0', '\xba'}, 3, 0xCC3A}, /* (HANGUL SYLLABLE CABS) */
    {{'\xec', '\xb0', '\xbf'}, 3, 0xCC3F}, /* (HANGUL SYLLABLE CAC) */
    {{'\xec', '\xb1', '\x80'}, 3, 0xCC40}, /* (HANGUL SYLLABLE CAK) */
    {{'\xec', '\xb1', '\x81'}, 3, 0xCC41}, /* (HANGUL SYLLABLE CAT) */
    {{'\xec', '\xb1', '\x82'}, 3, 0xCC42}, /* (HANGUL SYLLABLE CAP) */
    {{'\xec', '\xb1', '\x83'}, 3, 0xCC43}, /* (HANGUL SYLLABLE CAH) */
    {{'\xec', '\xb1', '\x86'}, 3, 0xCC46}, /* (HANGUL SYLLABLE CAEGG) */
    {{'\xec', '\xb1', '\x87'}, 3, 0xCC47}, /* (HANGUL SYLLABLE CAEGS) */
    {{'\xec', '\xb1', '\x89'}, 3, 0xCC49}, /* (HANGUL SYLLABLE CAENJ) */
    {{'\xec', '\xb1', '\x8a'}, 3, 0xCC4A}, /* (HANGUL SYLLABLE CAENH) */
    {{'\xec', '\xb1', '\x8b'}, 3, 0xCC4B}, /* (HANGUL SYLLABLE CAED) */
    {{'\xec', '\xb1', '\x8d'}, 3, 0xCC4D}, /* (HANGUL SYLLABLE CAELG) */
    {{'\xec', '\xb1', '\x8e'}, 3, 0xCC4E}, /* (HANGUL SYLLABLE CAELM) */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{'\xec', '\xb1', '\x8f'}, 3, 0xCC4F}, /* (HANGUL SYLLABLE CAELB) */
    {{'\xec', '\xb1', '\x90'}, 3, 0xCC50}, /* (HANGUL SYLLABLE CAELS) */
    {{'\xec', '\xb1', '\x91'}, 3, 0xCC51}, /* (HANGUL SYLLABLE CAELT) */
    {{'\xec', '\xb1', '\x92'}, 3, 0xCC52}, /* (HANGUL SYLLABLE CAELP) */
    {{'\xec', '\xb1', '\x93'}, 3, 0xCC53}, /* (HANGUL SYLLABLE CAELH) */
    {{'\xec', '\xb1', '\x96'}, 3, 0xCC56}, /* (HANGUL SYLLABLE CAEBS) */
    {{'\xec', '\xb1', '\x9a'}, 3, 0xCC5A}, /* (HANGUL SYLLABLE CAEJ) */
    {{'\xec', '\xb1', '\x9b'}, 3, 0xCC5B}, /* (HANGUL SYLLABLE CAEC) */
    {{'\xec', '\xb1', '\x9c'}, 3, 0xCC5C}, /* (HANGUL SYLLABLE CAEK) */
    {{'\xec', '\xb1', '\x9d'}, 3, 0xCC5D}, /* (HANGUL SYLLABLE CAET) */
    {{'\xec', '\xb1', '\x9e'}, 3, 0xCC5E}, /* (HANGUL SYLLABLE CAEP) */
    {{'\xec', '\xb1', '\x9f'}, 3, 0xCC5F}, /* (HANGUL SYLLABLE CAEH) */
    {{'\xec', '\xb1', '\xa1'}, 3, 0xCC61}, /* (HANGUL SYLLABLE CYAG) */
    {{'\xec', '\xb1', '\xa2'}, 3, 0xCC62}, /* (HANGUL SYLLABLE CYAGG) */
    {{'\xec', '\xb1', '\xa3'}, 3, 0xCC63}, /* (HANGUL SYLLABLE CYAGS) */
    {{'\xec', '\xb1', '\xa5'}, 3, 0xCC65}, /* (HANGUL SYLLABLE CYANJ) */
    {{'\xec', '\xb1', '\xa7'}, 3, 0xCC67}, /* (HANGUL SYLLABLE CYAD) */
    {{'\xec', '\xb1', '\xa9'}, 3, 0xCC69}, /* (HANGUL SYLLABLE CYALG) */
    {{'\xec', '\xb1', '\xaa'}, 3, 0xCC6A}, /* (HANGUL SYLLABLE CYALM) */
    {{'\xec', '\xb1', '\xab'}, 3, 0xCC6B}, /* (HANGUL SYLLABLE CYALB) */
    {{'\xec', '\xb1', '\xac'}, 3, 0xCC6C}, /* (HANGUL SYLLABLE CYALS) */
    {{'\xec', '\xb1', '\xad'}, 3, 0xCC6D}, /* (HANGUL SYLLABLE CYALT) */
    {{'\xec', '\xb1', '\xae'}, 3, 0xCC6E}, /* (HANGUL SYLLABLE CYALP) */
    {{'\xec', '\xb1', '\xaf'}, 3, 0xCC6F}, /* (HANGUL SYLLABLE CYALH) */
    {{'\xec', '\xb1', '\xb1'}, 3, 0xCC71}, /* (HANGUL SYLLABLE CYAB) */
    {{'\xec', '\xb1', '\xb2'}, 3, 0xCC72}, /* (HANGUL SYLLABLE CYABS) */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{'\xec', '\xb1', '\xb3'}, 3, 0xCC73}, /* (HANGUL SYLLABLE CYAS) */
    {{'\xec', '\xb1', '\xb4'}, 3, 0xCC74}, /* (HANGUL SYLLABLE CYASS) */
    {{'\xec', '\xb1', '\xb6'}, 3, 0xCC76}, /* (HANGUL SYLLABLE CYAJ) */
    {{'\xec', '\xb1', '\xb7'}, 3, 0xCC77}, /* (HANGUL SYLLABLE CYAC) */
    {{'\xec', '\xb1', '\xb8'}, 3, 0xCC78}, /* (HANGUL SYLLABLE CYAK) */
    {{'\xec', '\xb1', '\xb9'}, 3, 0xCC79}, /* (HANGUL SYLLABLE CYAT) */
    {{'\xec', '\xb1', '\xba'}, 3, 0xCC7A}, /* (HANGUL SYLLABLE CYAP) */
    {{'\xec', '\xb1', '\xbb'}, 3, 0xCC7B}, /* (HANGUL SYLLABLE CYAH) */
    {{'\xec', '\xb1', '\xbc'}, 3, 0xCC7C}, /* (HANGUL SYLLABLE CYAE) */
    {{'\xec', '\xb1', '\xbd'}, 3, 0xCC7D}, /* (HANGUL SYLLABLE CYAEG) */
    {{'\xec', '\xb1', '\xbe'}, 3, 0xCC7E}, /* (HANGUL SYLLABLE CYAEGG) */
    {{'\xec', '\xb1', '\xbf'}, 3, 0xCC7F}, /* (HANGUL SYLLABLE CYAEGS) */
    {{'\xec', '\xb2', '\x80'}, 3, 0xCC80}, /* (HANGUL SYLLABLE CYAEN) */
    {{'\xec', '\xb2', '\x81'}, 3, 0xCC81}, /* (HANGUL SYLLABLE CYAENJ) */
    {{'\xec', '\xb2', '\x82'}, 3, 0xCC82}, /* (HANGUL SYLLABLE CYAENH) */
    {{'\xec', '\xb2', '\x83'}, 3, 0xCC83}, /* (HANGUL SYLLABLE CYAED) */
    {{'\xec', '\xb2', '\x84'}, 3, 0xCC84}, /* (HANGUL SYLLABLE CYAEL) */
    {{'\xec', '\xb2', '\x85'}, 3, 0xCC85}, /* (HANGUL SYLLABLE CYAELG) */
    {{'\xec', '\xb2', '\x86'}, 3, 0xCC86}, /* (HANGUL SYLLABLE CYAELM) */
    {{'\xec', '\xb2', '\x87'}, 3, 0xCC87}, /* (HANGUL SYLLABLE CYAELB) */
    {{'\xec', '\xb2', '\x88'}, 3, 0xCC88}, /* (HANGUL SYLLABLE CYAELS) */
    {{'\xec', '\xb2', '\x89'}, 3, 0xCC89}, /* (HANGUL SYLLABLE CYAELT) */
    {{'\xec', '\xb2', '\x8a'}, 3, 0xCC8A}, /* (HANGUL SYLLABLE CYAELP) */
    {{'\xec', '\xb2', '\x8b'}, 3, 0xCC8B}, /* (HANGUL SYLLABLE CYAELH) */
    {{'\xec', '\xb2', '\x8c'}, 3, 0xCC8C}, /* (HANGUL SYLLABLE CYAEM) */
    {{'\xec', '\xb2', '\x8d'}, 3, 0xCC8D}, /* (HANGUL SYLLABLE CYAEB) */
    {{'\xec', '\xb2', '\x8e'}, 3, 0xCC8E}, /* (HANGUL SYLLABLE CYAEBS) */
    {{'\xec', '\xb2', '\x8f'}, 3, 0xCC8F}, /* (HANGUL SYLLABLE CYAES) */
    {{'\xec', '\xb2', '\x90'}, 3, 0xCC90}, /* (HANGUL SYLLABLE CYAESS) */
    {{'\xec', '\xb2', '\x91'}, 3, 0xCC91}, /* (HANGUL SYLLABLE CYAENG) */
    {{'\xec', '\xb2', '\x92'}, 3, 0xCC92}, /* (HANGUL SYLLABLE CYAEJ) */
    {{'\xec', '\xb2', '\x93'}, 3, 0xCC93}, /* (HANGUL SYLLABLE CYAEC) */
    {{'\xe3', '\x81', '\x81'}, 3, 0x3041}, /* (HIRAGANA LETTER SMALL A) */
    {{'\xe3', '\x81', '\x82'}, 3, 0x3042}, /* (HIRAGANA LETTER A) */
    {{'\xe3', '\x81', '\x83'}, 3, 0x3043}, /* (HIRAGANA LETTER SMALL I) */
    {{'\xe3', '\x81', '\x84'}, 3, 0x3044}, /* (HIRAGANA LETTER I) */
    {{'\xe3', '\x81', '\x85'}, 3, 0x3045}, /* (HIRAGANA LETTER SMALL U) */
    {{'\xe3', '\x81', '\x86'}, 3, 0x3046}, /* (HIRAGANA LETTER U) */
    {{'\xe3', '\x81', '\x87'}, 3, 0x3047}, /* (HIRAGANA LETTER SMALL E) */
    {{'\xe3', '\x81', '\x88'}, 3, 0x3048}, /* (HIRAGANA LETTER E) */
    {{'\xe3', '\x81', '\x89'}, 3, 0x3049}, /* (HIRAGANA LETTER SMALL O) */
    {{'\xe3', '\x81', '\x8a'}, 3, 0x304A}, /* (HIRAGANA LETTER O) */
    {{'\xe3', '\x81', '\x8b'}, 3, 0x304B}, /* (HIRAGANA LETTER KA) */
    {{'\xe3', '\x81', '\x8c'}, 3, 0x304C}, /* (HIRAGANA LETTER GA) */
    {{'\xe3', '\x81', '\x8d'}, 3, 0x304D}, /* (HIRAGANA LETTER KI) */
    {{'\xe3', '\x81', '\x8e'}, 3, 0x304E}, /* (HIRAGANA LETTER GI) */
    {{'\xe3', '\x81', '\x8f'}, 3, 0x304F}, /* (HIRAGANA LETTER KU) */
    {{'\xe3', '\x81', '\x90'}, 3, 0x3050}, /* (HIRAGANA LETTER GU) */
    {{'\xe3', '\x81', '\x91'}, 3, 0x3051}, /* (HIRAGANA LETTER KE) */
    {{'\xe3', '\x81', '\x92'}, 3, 0x3052}, /* (HIRAGANA LETTER GE) */
    {{'\xe3', '\x81', '\x93'}, 3, 0x3053}, /* (HIRAGANA LETTER KO) */
    {{'\xe3', '\x81', '\x94'}, 3, 0x3054}, /* (HIRAGANA LETTER GO) */
    {{'\xe3', '\x81', '\x95'}, 3, 0x3055}, /* (HIRAGANA LETTER SA) */
    {{'\xe3', '\x81', '\x96'}, 3, 0x3056}, /* (HIRAGANA LETTER ZA) */
    {{'\xe3', '\x81', '\x97'}, 3, 0x3057}, /* (HIRAGANA LETTER SI) */
    {{'\xe3', '\x81', '\x98'}, 3, 0x3058}, /* (HIRAGANA LETTER ZI) */
    {{'\xe3', '\x81', '\x99'}, 3, 0x3059}, /* (HIRAGANA LETTER SU) */
    {{'\xe3', '\x81', '\x9a'}, 3, 0x305A}, /* (HIRAGANA LETTER ZU) */
    {{'\xe3', '\x81', '\x9b'}, 3, 0x305B}, /* (HIRAGANA LETTER SE) */
    {{'\xe3', '\x81', '\x9c'}, 3, 0x305C}, /* (HIRAGANA LETTER ZE) */
    {{'\xe3', '\x81', '\x9d'}, 3, 0x305D}, /* (HIRAGANA LETTER SO) */
    {{'\xe3', '\x81', '\x9e'}, 3, 0x305E}, /* (HIRAGANA LETTER ZO) */
    {{'\xe3', '\x81', '\x9f'}, 3, 0x305F}, /* (HIRAGANA LETTER TA) */
    {{'\xe3', '\x81', '\xa0'}, 3, 0x3060}, /* (HIRAGANA LETTER DA) */
    {{'\xe3', '\x81', '\xa1'}, 3, 0x3061}, /* (HIRAGANA LETTER TI) */
    {{'\xe3', '\x81', '\xa2'}, 3, 0x3062}, /* (HIRAGANA LETTER DI) */
    {{'\xe3', '\x81', '\xa3'}, 3, 0x3063}, /* (HIRAGANA LETTER SMALL TU) */
    {{'\xe3', '\x81', '\xa4'}, 3, 0x3064}, /* (HIRAGANA LETTER TU) */
    {{'\xe3', '\x81', '\xa5'}, 3, 0x3065}, /* (HIRAGANA LETTER DU) */
    {{'\xe3', '\x81', '\xa6'}, 3, 0x3066}, /* (HIRAGANA LETTER TE) */
    {{'\xe3', '\x81', '\xa7'}, 3, 0x3067}, /* (HIRAGANA LETTER DE) */
    {{'\xe3', '\x81', '\xa8'}, 3, 0x3068}, /* (HIRAGANA LETTER TO) */
    {{'\xe3', '\x81', '\xa9'}, 3, 0x3069}, /* (HIRAGANA LETTER DO) */
    {{'\xe3', '\x81', '\xaa'}, 3, 0x306A}, /* (HIRAGANA LETTER NA) */
    {{'\xe3', '\x81', '\xab'}, 3, 0x306B}, /* (HIRAGANA LETTER NI) */
    {{'\xe3', '\x81', '\xac'}, 3, 0x306C}, /* (HIRAGANA LETTER NU) */
    {{'\xe3', '\x81', '\xad'}, 3, 0x306D}, /* (HIRAGANA LETTER NE) */
    {{'\xe3', '\x81', '\xae'}, 3, 0x306E}, /* (HIRAGANA LETTER NO) */
    {{'\xe3', '\x81', '\xaf'}, 3, 0x306F}, /* (HIRAGANA LETTER HA) */
    {{'\xe3', '\x81', '\xb0'}, 3, 0x3070}, /* (HIRAGANA LETTER BA) */
    {{'\xe3', '\x81', '\xb1'}, 3, 0x3071}, /* (HIRAGANA LETTER PA) */
    {{'\xe3', '\x81', '\xb2'}, 3, 0x3072}, /* (HIRAGANA LETTER HI) */
    {{'\xe3', '\x81', '\xb3'}, 3, 0x3073}, /* (HIRAGANA LETTER BI) */
    {{'\xe3', '\x81', '\xb4'}, 3, 0x3074}, /* (HIRAGANA LETTER PI) */
    {{'\xe3', '\x81', '\xb5'}, 3, 0x3075}, /* (HIRAGANA LETTER HU) */
    {{'\xe3', '\x81', '\xb6'}, 3, 0x3076}, /* (HIRAGANA LETTER BU) */
    {{'\xe3', '\x81', '\xb7'}, 3, 0x3077}, /* (HIRAGANA LETTER PU) */
    {{'\xe3', '\x81', '\xb8'}, 3, 0x3078}, /* (HIRAGANA LETTER HE) */
    {{'\xe3', '\x81', '\xb9'}, 3, 0x3079}, /* (HIRAGANA LETTER BE) */
    {{'\xe3', '\x81', '\xba'}, 3, 0x307A}, /* (HIRAGANA LETTER PE) */
    {{'\xe3', '\x81', '\xbb'}, 3, 0x307B}, /* (HIRAGANA LETTER HO) */
    {{'\xe3', '\x81', '\xbc'}, 3, 0x307C}, /* (HIRAGANA LETTER BO) */
    {{'\xe3', '\x81', '\xbd'}, 3, 0x307D}, /* (HIRAGANA LETTER PO) */
    {{'\xe3', '\x81', '\xbe'}, 3, 0x307E}, /* (HIRAGANA LETTER MA) */
    {{'\xe3', '\x81', '\xbf'}, 3, 0x307F}, /* (HIRAGANA LETTER MI) */
    {{'\xe3', '\x82', '\x80'}, 3, 0x3080}, /* (HIRAGANA LETTER MU) */
    {{'\xe3', '\x82', '\x81'}, 3, 0x3081}, /* (HIRAGANA LETTER ME) */
    {{'\xe3', '\x82', '\x82'}, 3, 0x3082}, /* (HIRAGANA LETTER MO) */
    {{'\xe3', '\x82', '\x83'}, 3, 0x3083}, /* (HIRAGANA LETTER SMALL YA) */
    {{'\xe3', '\x82', '\x84'}, 3, 0x3084}, /* (HIRAGANA LETTER YA) */
    {{'\xe3', '\x82', '\x85'}, 3, 0x3085}, /* (HIRAGANA LETTER SMALL YU) */
    {{'\xe3', '\x82', '\x86'}, 3, 0x3086}, /* (HIRAGANA LETTER YU) */
    {{'\xe3', '\x82', '\x87'}, 3, 0x3087}, /* (HIRAGANA LETTER SMALL YO) */
    {{'\xe3', '\x82', '\x88'}, 3, 0x3088}, /* (HIRAGANA LETTER YO) */
    {{'\xe3', '\x82', '\x89'}, 3, 0x3089}, /* (HIRAGANA LETTER RA) */
    {{'\xe3', '\x82', '\x8a'}, 3, 0x308A}, /* (HIRAGANA LETTER RI) */
    {{'\xe3', '\x82', '\x8b'}, 3, 0x308B}, /* (HIRAGANA LETTER RU) */
    {{'\xe3', '\x82', '\x8c'}, 3, 0x308C}, /* (HIRAGANA LETTER RE) */
    {{'\xe3', '\x82', '\x8d'}, 3, 0x308D}, /* (HIRAGANA LETTER RO) */
    {{'\xe3', '\x82', '\x8e'}, 3, 0x308E}, /* (HIRAGANA LETTER SMALL WA) */
    {{'\xe3', '\x82', '\x8f'}, 3, 0x308F}, /* (HIRAGANA LETTER WA) */
    {{'\xe3', '\x82', '\x90'}, 3, 0x3090}, /* (HIRAGANA LETTER WI) */
    {{'\xe3', '\x82', '\x91'}, 3, 0x3091}, /* (HIRAGANA LETTER WE) */
    {{'\xe3', '\x82', '\x92'}, 3, 0x3092}, /* (HIRAGANA LETTER WO) */
    {{'\xe3', '\x82', '\x93'}, 3, 0x3093}, /* (HIRAGANA LETTER N) */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{'\xec', '\xb2', '\x94'}, 3, 0xCC94}, /* (HANGUL SYLLABLE CYAEK) */
    {{'\xec', '\xb2', '\x95'}, 3, 0xCC95}, /* (HANGUL SYLLABLE CYAET) */
    {{'\xec', '\xb2', '\x96'}, 3, 0xCC96}, /* (HANGUL SYLLABLE CYAEP) */
    {{'\xec', '\xb2', '\x97'}, 3, 0xCC97}, /* (HANGUL SYLLABLE CYAEH) */
    {{'\xec', '\xb2', '\x9a'}, 3, 0xCC9A}, /* (HANGUL SYLLABLE CEOGG) */
    {{'\xec', '\xb2', '\x9b'}, 3, 0xCC9B}, /* (HANGUL SYLLABLE CEOGS) */
    {{'\xec', '\xb2', '\x9d'}, 3, 0xCC9D}, /* (HANGUL SYLLABLE CEONJ) */
    {{'\xec', '\xb2', '\x9e'}, 3, 0xCC9E}, /* (HANGUL SYLLABLE CEONH) */
    {{'\xec', '\xb2', '\x9f'}, 3, 0xCC9F}, /* (HANGUL SYLLABLE CEOD) */
    {{'\xec', '\xb2', '\xa1'}, 3, 0xCCA1}, /* (HANGUL SYLLABLE CEOLG) */
    {{'\xec', '\xb2', '\xa2'}, 3, 0xCCA2}, /* (HANGUL SYLLABLE CEOLM) */
    {{'\xec', '\xb2', '\xa3'}, 3, 0xCCA3}, /* (HANGUL SYLLABLE CEOLB) */
    {{'\xec', '\xb2', '\xa4'}, 3, 0xCCA4}, /* (HANGUL SYLLABLE CEOLS) */
    {{'\xec', '\xb2', '\xa5'}, 3, 0xCCA5}, /* (HANGUL SYLLABLE CEOLT) */
    {{'\xec', '\xb2', '\xa6'}, 3, 0xCCA6}, /* (HANGUL SYLLABLE CEOLP) */
    {{'\xec', '\xb2', '\xa7'}, 3, 0xCCA7}, /* (HANGUL SYLLABLE CEOLH) */
    {{'\xec', '\xb2', '\xaa'}, 3, 0xCCAA}, /* (HANGUL SYLLABLE CEOBS) */
    {{'\xec', '\xb2', '\xae'}, 3, 0xCCAE}, /* (HANGUL SYLLABLE CEOJ) */
    {{'\xec', '\xb2', '\xaf'}, 3, 0xCCAF}, /* (HANGUL SYLLABLE CEOC) */
    {{'\xec', '\xb2', '\xb0'}, 3, 0xCCB0}, /* (HANGUL SYLLABLE CEOK) */
    {{'\xec', '\xb2', '\xb1'}, 3, 0xCCB1}, /* (HANGUL SYLLABLE CEOT) */
    {{'\xec', '\xb2', '\xb2'}, 3, 0xCCB2}, /* (HANGUL SYLLABLE CEOP) */
    {{'\xec', '\xb2', '\xb3'}, 3, 0xCCB3}, /* (HANGUL SYLLABLE CEOH) */
    {{'\xec', '\xb2', '\xb6'}, 3, 0xCCB6}, /* (HANGUL SYLLABLE CEGG) */
    {{'\xec', '\xb2', '\xb7'}, 3, 0xCCB7}, /* (HANGUL SYLLABLE CEGS) */
    {{'\xec', '\xb2', '\xb9'}, 3, 0xCCB9}, /* (HANGUL SYLLABLE CENJ) */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{'\xec', '\xb2', '\xba'}, 3, 0xCCBA}, /* (HANGUL SYLLABLE CENH) */
    {{'\xec', '\xb2', '\xbb'}, 3, 0xCCBB}, /* (HANGUL SYLLABLE CED) */
    {{'\xec', '\xb2', '\xbd'}, 3, 0xCCBD}, /* (HANGUL SYLLABLE CELG) */
    {{'\xec', '\xb2', '\xbe'}, 3, 0xCCBE}, /* (HANGUL SYLLABLE CELM) */
    {{'\xec', '\xb2', '\xbf'}, 3, 0xCCBF}, /* (HANGUL SYLLABLE CELB) */
    {{'\xec', '\xb3', '\x80'}, 3, 0xCCC0}, /* (HANGUL SYLLABLE CELS) */
    {{'\xec', '\xb3', '\x81'}, 3, 0xCCC1}, /* (HANGUL SYLLABLE CELT) */
    {{'\xec', '\xb3', '\x82'}, 3, 0xCCC2}, /* (HANGUL SYLLABLE CELP) */
    {{'\xec', '\xb3', '\x83'}, 3, 0xCCC3}, /* (HANGUL SYLLABLE CELH) */
    {{'\xec', '\xb3', '\x86'}, 3, 0xCCC6}, /* (HANGUL SYLLABLE CEBS) */
    {{'\xec', '\xb3', '\x88'}, 3, 0xCCC8}, /* (HANGUL SYLLABLE CESS) */
    {{'\xec', '\xb3', '\x8a'}, 3, 0xCCCA}, /* (HANGUL SYLLABLE CEJ) */
    {{'\xec', '\xb3', '\x8b'}, 3, 0xCCCB}, /* (HANGUL SYLLABLE CEC) */
    {{'\xec', '\xb3', '\x8c'}, 3, 0xCCCC}, /* (HANGUL SYLLABLE CEK) */
    {{'\xec', '\xb3', '\x8d'}, 3, 0xCCCD}, /* (HANGUL SYLLABLE CET) */
    {{'\xec', '\xb3', '\x8e'}, 3, 0xCCCE}, /* (HANGUL SYLLABLE CEP) */
    {{'\xec', '\xb3', '\x8f'}, 3, 0xCCCF}, /* (HANGUL SYLLABLE CEH) */
    {{'\xec', '\xb3', '\x91'}, 3, 0xCCD1}, /* (HANGUL SYLLABLE CYEOG) */
    {{'\xec', '\xb3', '\x92'}, 3, 0xCCD2}, /* (HANGUL SYLLABLE CYEOGG) */
    {{'\xec', '\xb3', '\x93'}, 3, 0xCCD3}, /* (HANGUL SYLLABLE CYEOGS) */
    {{'\xec', '\xb3', '\x95'}, 3, 0xCCD5}, /* (HANGUL SYLLABLE CYEONJ) */
    {{'\xec', '\xb3', '\x96'}, 3, 0xCCD6}, /* (HANGUL SYLLABLE CYEONH) */
    {{'\xec', '\xb3', '\x97'}, 3, 0xCCD7}, /* (HANGUL SYLLABLE CYEOD) */
    {{'\xec', '\xb3', '\x98'}, 3, 0xCCD8}, /* (HANGUL SYLLABLE CYEOL) */
    {{'\xec', '\xb3', '\x99'}, 3, 0xCCD9}, /* (HANGUL SYLLABLE CYEOLG) */
    {{'\xec', '\xb3', '\x9a'}, 3, 0xCCDA}, /* (HANGUL SYLLABLE CYEOLM) */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{'\xec', '\xb3', '\x9b'}, 3, 0xCCDB}, /* (HANGUL SYLLABLE CYEOLB) */
    {{'\xec', '\xb3', '\x9c'}, 3, 0xCCDC}, /* (HANGUL SYLLABLE CYEOLS) */
    {{'\xec', '\xb3', '\x9d'}, 3, 0xCCDD}, /* (HANGUL SYLLABLE CYEOLT) */
    {{'\xec', '\xb3', '\x9e'}, 3, 0xCCDE}, /* (HANGUL SYLLABLE CYEOLP) */
    {{'\xec', '\xb3', '\x9f'}, 3, 0xCCDF}, /* (HANGUL SYLLABLE CYEOLH) */
    {{'\xec', '\xb3', '\xa0'}, 3, 0xCCE0}, /* (HANGUL SYLLABLE CYEOM) */
    {{'\xec', '\xb3', '\xa1'}, 3, 0xCCE1}, /* (HANGUL SYLLABLE CYEOB) */
    {{'\xec', '\xb3', '\xa2'}, 3, 0xCCE2}, /* (HANGUL SYLLABLE CYEOBS) */
    {{'\xec', '\xb3', '\xa3'}, 3, 0xCCE3}, /* (HANGUL SYLLABLE CYEOS) */
    {{'\xec', '\xb3', '\xa5'}, 3, 0xCCE5}, /* (HANGUL SYLLABLE CYEONG) */
    {{'\xec', '\xb3', '\xa6'}, 3, 0xCCE6}, /* (HANGUL SYLLABLE CYEOJ) */
    {{'\xec', '\xb3', '\xa7'}, 3, 0xCCE7}, /* (HANGUL SYLLABLE CYEOC) */
    {{'\xec', '\xb3', '\xa8'}, 3, 0xCCE8}, /* (HANGUL SYLLABLE CYEOK) */
    {{'\xec', '\xb3', '\xa9'}, 3, 0xCCE9}, /* (HANGUL SYLLABLE CYEOT) */
    {{'\xec', '\xb3', '\xaa'}, 3, 0xCCEA}, /* (HANGUL SYLLABLE CYEOP) */
    {{'\xec', '\xb3', '\xab'}, 3, 0xCCEB}, /* (HANGUL SYLLABLE CYEOH) */
    {{'\xec', '\xb3', '\xad'}, 3, 0xCCED}, /* (HANGUL SYLLABLE CYEG) */
    {{'\xec', '\xb3', '\xae'}, 3, 0xCCEE}, /* (HANGUL SYLLABLE CYEGG) */
    {{'\xec', '\xb3', '\xaf'}, 3, 0xCCEF}, /* (HANGUL SYLLABLE CYEGS) */
    {{'\xec', '\xb3', '\xb1'}, 3, 0xCCF1}, /* (HANGUL SYLLABLE CYENJ) */
    {{'\xec', '\xb3', '\xb2'}, 3, 0xCCF2}, /* (HANGUL SYLLABLE CYENH) */
    {{'\xec', '\xb3', '\xb3'}, 3, 0xCCF3}, /* (HANGUL SYLLABLE CYED) */
    {{'\xec', '\xb3', '\xb4'}, 3, 0xCCF4}, /* (HANGUL SYLLABLE CYEL) */
    {{'\xec', '\xb3', '\xb5'}, 3, 0xCCF5}, /* (HANGUL SYLLABLE CYELG) */
    {{'\xec', '\xb3', '\xb6'}, 3, 0xCCF6}, /* (HANGUL SYLLABLE CYELM) */
    {{'\xec', '\xb3', '\xb7'}, 3, 0xCCF7}, /* (HANGUL SYLLABLE CYELB) */
    {{'\xec', '\xb3', '\xb8'}, 3, 0xCCF8}, /* (HANGUL SYLLABLE CYELS) */
    {{'\xec', '\xb3', '\xb9'}, 3, 0xCCF9}, /* (HANGUL SYLLABLE CYELT) */
    {{'\xec', '\xb3', '\xba'}, 3, 0xCCFA}, /* (HANGUL SYLLABLE CYELP) */
    {{'\xec', '\xb3', '\xbb'}, 3, 0xCCFB}, /* (HANGUL SYLLABLE CYELH) */
    {{'\xec', '\xb3', '\xbc'}, 3, 0xCCFC}, /* (HANGUL SYLLABLE CYEM) */
    {{'\xec', '\xb3', '\xbd'}, 3, 0xCCFD}, /* (HANGUL SYLLABLE CYEB) */
    {{'\xe3', '\x82', '\xa1'}, 3, 0x30A1}, /* (KATAKANA LETTER SMALL A) */
    {{'\xe3', '\x82', '\xa2'}, 3, 0x30A2}, /* (KATAKANA LETTER A) */
    {{'\xe3', '\x82', '\xa3'}, 3, 0x30A3}, /* (KATAKANA LETTER SMALL I) */
    {{'\xe3', '\x82', '\xa4'}, 3, 0x30A4}, /* (KATAKANA LETTER I) */
    {{'\xe3', '\x82', '\xa5'}, 3, 0x30A5}, /* (KATAKANA LETTER SMALL U) */
    {{'\xe3', '\x82', '\xa6'}, 3, 0x30A6}, /* (KATAKANA LETTER U) */
    {{'\xe3', '\x82', '\xa7'}, 3, 0x30A7}, /* (KATAKANA LETTER SMALL E) */
    {{'\xe3', '\x82', '\xa8'}, 3, 0x30A8}, /* (KATAKANA LETTER E) */
    {{'\xe3', '\x82', '\xa9'}, 3, 0x30A9}, /* (KATAKANA LETTER SMALL O) */
    {{'\xe3', '\x82', '\xaa'}, 3, 0x30AA}, /* (KATAKANA LETTER O) */
    {{'\xe3', '\x82', '\xab'}, 3, 0x30AB}, /* (KATAKANA LETTER KA) */
    {{'\xe3', '\x82', '\xac'}, 3, 0x30AC}, /* (KATAKANA LETTER GA) */
    {{'\xe3', '\x82', '\xad'}, 3, 0x30AD}, /* (KATAKANA LETTER KI) */
    {{'\xe3', '\x82', '\xae'}, 3, 0x30AE}, /* (KATAKANA LETTER GI) */
    {{'\xe3', '\x82', '\xaf'}, 3, 0x30AF}, /* (KATAKANA LETTER KU) */
    {{'\xe3', '\x82', '\xb0'}, 3, 0x30B0}, /* (KATAKANA LETTER GU) */
    {{'\xe3', '\x82', '\xb1'}, 3, 0x30B1}, /* (KATAKANA LETTER KE) */
    {{'\xe3', '\x82', '\xb2'}, 3, 0x30B2}, /* (KATAKANA LETTER GE) */
    {{'\xe3', '\x82', '\xb3'}, 3, 0x30B3}, /* (KATAKANA LETTER KO) */
    {{'\xe3', '\x82', '\xb4'}, 3, 0x30B4}, /* (KATAKANA LETTER GO) */
    {{'\xe3', '\x82', '\xb5'}, 3, 0x30B5}, /* (KATAKANA LETTER SA) */
    {{'\xe3', '\x82', '\xb6'}, 3, 0x30B6}, /* (KATAKANA LETTER ZA) */
    {{'\xe3', '\x82', '\xb7'}, 3, 0x30B7}, /* (KATAKANA LETTER SI) */
    {{'\xe3', '\x82', '\xb8'}, 3, 0x30B8}, /* (KATAKANA LETTER ZI) */
    {{'\xe3', '\x82', '\xb9'}, 3, 0x30B9}, /* (KATAKANA LETTER SU) */
    {{'\xe3', '\x82', '\xba'}, 3, 0x30BA}, /* (KATAKANA LETTER ZU) */
    {{'\xe3', '\x82', '\xbb'}, 3, 0x30BB}, /* (KATAKANA LETTER SE) */
    {{'\xe3', '\x82', '\xbc'}, 3, 0x30BC}, /* (KATAKANA LETTER ZE) */
    {{'\xe3', '\x82', '\xbd'}, 3, 0x30BD}, /* (KATAKANA LETTER SO) */
    {{'\xe3', '\x82', '\xbe'}, 3, 0x30BE}, /* (KATAKANA LETTER ZO) */
    {{'\xe3', '\x82', '\xbf'}, 3, 0x30BF}, /* (KATAKANA LETTER TA) */
    {{'\xe3', '\x83', '\x80'}, 3, 0x30C0}, /* (KATAKANA LETTER DA) */
    {{'\xe3', '\x83', '\x81'}, 3, 0x30C1}, /* (KATAKANA LETTER TI) */
    {{'\xe3', '\x83', '\x82'}, 3, 0x30C2}, /* (KATAKANA LETTER DI) */
    {{'\xe3', '\x83', '\x83'}, 3, 0x30C3}, /* (KATAKANA LETTER SMALL TU) */
    {{'\xe3', '\x83', '\x84'}, 3, 0x30C4}, /* (KATAKANA LETTER TU) */
    {{'\xe3', '\x83', '\x85'}, 3, 0x30C5}, /* (KATAKANA LETTER DU) */
    {{'\xe3', '\x83', '\x86'}, 3, 0x30C6}, /* (KATAKANA LETTER TE) */
    {{'\xe3', '\x83', '\x87'}, 3, 0x30C7}, /* (KATAKANA LETTER DE) */
    {{'\xe3', '\x83', '\x88'}, 3, 0x30C8}, /* (KATAKANA LETTER TO) */
    {{'\xe3', '\x83', '\x89'}, 3, 0x30C9}, /* (KATAKANA LETTER DO) */
    {{'\xe3', '\x83', '\x8a'}, 3, 0x30CA}, /* (KATAKANA LETTER NA) */
    {{'\xe3', '\x83', '\x8b'}, 3, 0x30CB}, /* (KATAKANA LETTER NI) */
    {{'\xe3', '\x83', '\x8c'}, 3, 0x30CC}, /* (KATAKANA LETTER NU) */
    {{'\xe3', '\x83', '\x8d'}, 3, 0x30CD}, /* (KATAKANA LETTER NE) */
    {{'\xe3', '\x83', '\x8e'}, 3, 0x30CE}, /* (KATAKANA LETTER NO) */
    {{'\xe3', '\x83', '\x8f'}, 3, 0x30CF}, /* (KATAKANA LETTER HA) */
    {{'\xe3', '\x83', '\x90'}, 3, 0x30D0}, /* (KATAKANA LETTER BA) */
    {{'\xe3', '\x83', '\x91'}, 3, 0x30D1}, /* (KATAKANA LETTER PA) */
    {{'\xe3', '\x83', '\x92'}, 3, 0x30D2}, /* (KATAKANA LETTER HI) */
    {{'\xe3', '\x83', '\x93'}, 3, 0x30D3}, /* (KATAKANA LETTER BI) */
    {{'\xe3', '\x83', '\x94'}, 3, 0x30D4}, /* (KATAKANA LETTER PI) */
    {{'\xe3', '\x83', '\x95'}, 3, 0x30D5}, /* (KATAKANA LETTER HU) */
    {{'\xe3', '\x83', '\x96'}, 3, 0x30D6}, /* (KATAKANA LETTER BU) */
    {{'\xe3', '\x83', '\x97'}, 3, 0x30D7}, /* (KATAKANA LETTER PU) */
    {{'\xe3', '\x83', '\x98'}, 3, 0x30D8}, /* (KATAKANA LETTER HE) */
    {{'\xe3', '\x83', '\x99'}, 3, 0x30D9}, /* (KATAKANA LETTER BE) */
    {{'\xe3', '\x83', '\x9a'}, 3, 0x30DA}, /* (KATAKANA LETTER PE) */
    {{'\xe3', '\x83', '\x9b'}, 3, 0x30DB}, /* (KATAKANA LETTER HO) */
    {{'\xe3', '\x83', '\x9c'}, 3, 0x30DC}, /* (KATAKANA LETTER BO) */
    {{'\xe3', '\x83', '\x9d'}, 3, 0x30DD}, /* (KATAKANA LETTER PO) */
    {{'\xe3', '\x83', '\x9e'}, 3, 0x30DE}, /* (KATAKANA LETTER MA) */
    {{'\xe3', '\x83', '\x9f'}, 3, 0x30DF}, /* (KATAKANA LETTER MI) */
    {{'\xe3', '\x83', '\xa0'}, 3, 0x30E0}, /* (KATAKANA LETTER MU) */
    {{'\xe3', '\x83', '\xa1'}, 3, 0x30E1}, /* (KATAKANA LETTER ME) */
    {{'\xe3', '\x83', '\xa2'}, 3, 0x30E2}, /* (KATAKANA LETTER MO) */
    {{'\xe3', '\x83', '\xa3'}, 3, 0x30E3}, /* (KATAKANA LETTER SMALL YA) */
    {{'\xe3', '\x83', '\xa4'}, 3, 0x30E4}, /* (KATAKANA LETTER YA) */
    {{'\xe3', '\x83', '\xa5'}, 3, 0x30E5}, /* (KATAKANA LETTER SMALL YU) */
    {{'\xe3', '\x83', '\xa6'}, 3, 0x30E6}, /* (KATAKANA LETTER YU) */
    {{'\xe3', '\x83', '\xa7'}, 3, 0x30E7}, /* (KATAKANA LETTER SMALL YO) */
    {{'\xe3', '\x83', '\xa8'}, 3, 0x30E8}, /* (KATAKANA LETTER YO) */
    {{'\xe3', '\x83', '\xa9'}, 3, 0x30E9}, /* (KATAKANA LETTER RA) */
    {{'\xe3', '\x83', '\xaa'}, 3, 0x30EA}, /* (KATAKANA LETTER RI) */
    {{'\xe3', '\x83', '\xab'}, 3, 0x30EB}, /* (KATAKANA LETTER RU) */
    {{'\xe3', '\x83', '\xac'}, 3, 0x30EC}, /* (KATAKANA LETTER RE) */
    {{'\xe3', '\x83', '\xad'}, 3, 0x30ED}, /* (KATAKANA LETTER RO) */
    {{'\xe3', '\x83', '\xae'}, 3, 0x30EE}, /* (KATAKANA LETTER SMALL WA) */
    {{'\xe3', '\x83', '\xaf'}, 3, 0x30EF}, /* (KATAKANA LETTER WA) */
    {{'\xe3', '\x83', '\xb0'}, 3, 0x30F0}, /* (KATAKANA LETTER WI) */
    {{'\xe3', '\x83', '\xb1'}, 3, 0x30F1}, /* (KATAKANA LETTER WE) */
    {{'\xe3', '\x83', '\xb2'}, 3, 0x30F2}, /* (KATAKANA LETTER WO) */
    {{'\xe3', '\x83', '\xb3'}, 3, 0x30F3}, /* (KATAKANA LETTER N) */
    {{'\xe3', '\x83', '\xb4'}, 3, 0x30F4}, /* (KATAKANA LETTER VU) */
    {{'\xe3', '\x83', '\xb5'}, 3, 0x30F5}, /* (KATAKANA LETTER SMALL KA) */
    {{'\xe3', '\x83', '\xb6'}, 3, 0x30F6}, /* (KATAKANA LETTER SMALL KE) */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{'\xec', '\xb3', '\xbe'}, 3, 0xCCFE}, /* (HANGUL SYLLABLE CYEBS) */
    {{'\xec', '\xb3', '\xbf'}, 3, 0xCCFF}, /* (HANGUL SYLLABLE CYES) */
    {{'\xec', '\xb4', '\x80'}, 3, 0xCD00}, /* (HANGUL SYLLABLE CYESS) */
    {{'\xec', '\xb4', '\x82'}, 3, 0xCD02}, /* (HANGUL SYLLABLE CYEJ) */
    {{'\xec', '\xb4', '\x83'}, 3, 0xCD03}, /* (HANGUL SYLLABLE CYEC) */
    {{'\xec', '\xb4', '\x84'}, 3, 0xCD04}, /* (HANGUL SYLLABLE CYEK) */
    {{'\xec', '\xb4', '\x85'}, 3, 0xCD05}, /* (HANGUL SYLLABLE CYET) */
    {{'\xec', '\xb4', '\x86'}, 3, 0xCD06}, /* (HANGUL SYLLABLE CYEP) */
    {{'\xec', '\xb4', '\x87'}, 3, 0xCD07}, /* (HANGUL SYLLABLE CYEH) */
    {{'\xec', '\xb4', '\x8a'}, 3, 0xCD0A}, /* (HANGUL SYLLABLE COGG) */
    {{'\xec', '\xb4', '\x8b'}, 3, 0xCD0B}, /* (HANGUL SYLLABLE COGS) */
    {{'\xec', '\xb4', '\x8d'}, 3, 0xCD0D}, /* (HANGUL SYLLABLE CONJ) */
    {{'\xec', '\xb4', '\x8e'}, 3, 0xCD0E}, /* (HANGUL SYLLABLE CONH) */
    {{'\xec', '\xb4', '\x8f'}, 3, 0xCD0F}, /* (HANGUL SYLLABLE COD) */
    {{'\xec', '\xb4', '\x91'}, 3, 0xCD11}, /* (HANGUL SYLLABLE COLG) */
    {{'\xec', '\xb4', '\x92'}, 3, 0xCD12}, /* (HANGUL SYLLABLE COLM) */
    {{'\xec', '\xb4', '\x93'}, 3, 0xCD13}, /* (HANGUL SYLLABLE COLB) */
    {{'\xec', '\xb4', '\x94'}, 3, 0xCD14}, /* (HANGUL SYLLABLE COLS) */
    {{'\xec', '\xb4', '\x95'}, 3, 0xCD15}, /* (HANGUL SYLLABLE COLT) */
    {{'\xec', '\xb4', '\x96'}, 3, 0xCD16}, /* (HANGUL SYLLABLE COLP) */
    {{'\xec', '\xb4', '\x97'}, 3, 0xCD17}, /* (HANGUL SYLLABLE COLH) */
    {{'\xec', '\xb4', '\x9a'}, 3, 0xCD1A}, /* (HANGUL SYLLABLE COBS) */
    {{'\xec', '\xb4', '\x9c'}, 3, 0xCD1C}, /* (HANGUL SYLLABLE COSS) */
    {{'\xec', '\xb4', '\x9e'}, 3, 0xCD1E}, /* (HANGUL SYLLABLE COJ) */
    {{'\xec', '\xb4', '\x9f'}, 3, 0xCD1F}, /* (HANGUL SYLLABLE COC) */
    {{'\xec', '\xb4', '\xa0'}, 3, 0xCD20}, /* (HANGUL SYLLABLE COK) */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{'\xec', '\xb4', '\xa1'}, 3, 0xCD21}, /* (HANGUL SYLLABLE COT) */
    {{'\xec', '\xb4', '\xa2'}, 3, 0xCD22}, /* (HANGUL SYLLABLE COP) */
    {{'\xec', '\xb4', '\xa3'}, 3, 0xCD23}, /* (HANGUL SYLLABLE COH) */
    {{'\xec', '\xb4', '\xa5'}, 3, 0xCD25}, /* (HANGUL SYLLABLE CWAG) */
    {{'\xec', '\xb4', '\xa6'}, 3, 0xCD26}, /* (HANGUL SYLLABLE CWAGG) */
    {{'\xec', '\xb4', '\xa7'}, 3, 0xCD27}, /* (HANGUL SYLLABLE CWAGS) */
    {{'\xec', '\xb4', '\xa9'}, 3, 0xCD29}, /* (HANGUL SYLLABLE CWANJ) */
    {{'\xec', '\xb4', '\xaa'}, 3, 0xCD2A}, /* (HANGUL SYLLABLE CWANH) */
    {{'\xec', '\xb4', '\xab'}, 3, 0xCD2B}, /* (HANGUL SYLLABLE CWAD) */
    {{'\xec', '\xb4', '\xad'}, 3, 0xCD2D}, /* (HANGUL SYLLABLE CWALG) */
    {{'\xec', '\xb4', '\xae'}, 3, 0xCD2E}, /* (HANGUL SYLLABLE CWALM) */
    {{'\xec', '\xb4', '\xaf'}, 3, 0xCD2F}, /* (HANGUL SYLLABLE CWALB) */
    {{'\xec', '\xb4', '\xb0'}, 3, 0xCD30}, /* (HANGUL SYLLABLE CWALS) */
    {{'\xec', '\xb4', '\xb1'}, 3, 0xCD31}, /* (HANGUL SYLLABLE CWALT) */
    {{'\xec', '\xb4', '\xb2'}, 3, 0xCD32}, /* (HANGUL SYLLABLE CWALP) */
    {{'\xec', '\xb4', '\xb3'}, 3, 0xCD33}, /* (HANGUL SYLLABLE CWALH) */
    {{'\xec', '\xb4', '\xb4'}, 3, 0xCD34}, /* (HANGUL SYLLABLE CWAM) */
    {{'\xec', '\xb4', '\xb5'}, 3, 0xCD35}, /* (HANGUL SYLLABLE CWAB) */
    {{'\xec', '\xb4', '\xb6'}, 3, 0xCD36}, /* (HANGUL SYLLABLE CWABS) */
    {{'\xec', '\xb4', '\xb7'}, 3, 0xCD37}, /* (HANGUL SYLLABLE CWAS) */
    {{'\xec', '\xb4', '\xb8'}, 3, 0xCD38}, /* (HANGUL SYLLABLE CWASS) */
    {{'\xec', '\xb4', '\xba'}, 3, 0xCD3A}, /* (HANGUL SYLLABLE CWAJ) */
    {{'\xec', '\xb4', '\xbb'}, 3, 0xCD3B}, /* (HANGUL SYLLABLE CWAC) */
    {{'\xec', '\xb4', '\xbc'}, 3, 0xCD3C}, /* (HANGUL SYLLABLE CWAK) */
    {{'\xec', '\xb4', '\xbd'}, 3, 0xCD3D}, /* (HANGUL SYLLABLE CWAT) */
    {{'\xec', '\xb4', '\xbe'}, 3, 0xCD3E}, /* (HANGUL SYLLABLE CWAP) */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{'\xec', '\xb4', '\xbf'}, 3, 0xCD3F}, /* (HANGUL SYLLABLE CWAH) */
    {{'\xec', '\xb5', '\x80'}, 3, 0xCD40}, /* (HANGUL SYLLABLE CWAE) */
    {{'\xec', '\xb5', '\x81'}, 3, 0xCD41}, /* (HANGUL SYLLABLE CWAEG) */
    {{'\xec', '\xb5', '\x82'}, 3, 0xCD42}, /* (HANGUL SYLLABLE CWAEGG) */
    {{'\xec', '\xb5', '\x83'}, 3, 0xCD43}, /* (HANGUL SYLLABLE CWAEGS) */
    {{'\xec', '\xb5', '\x84'}, 3, 0xCD44}, /* (HANGUL SYLLABLE CWAEN) */
    {{'\xec', '\xb5', '\x85'}, 3, 0xCD45}, /* (HANGUL SYLLABLE CWAENJ) */
    {{'\xec', '\xb5', '\x86'}, 3, 0xCD46}, /* (HANGUL SYLLABLE CWAENH) */
    {{'\xec', '\xb5', '\x87'}, 3, 0xCD47}, /* (HANGUL SYLLABLE CWAED) */
    {{'\xec', '\xb5', '\x88'}, 3, 0xCD48}, /* (HANGUL SYLLABLE CWAEL) */
    {{'\xec', '\xb5', '\x89'}, 3, 0xCD49}, /* (HANGUL SYLLABLE CWAELG) */
    {{'\xec', '\xb5', '\x8a'}, 3, 0xCD4A}, /* (HANGUL SYLLABLE CWAELM) */
    {{'\xec', '\xb5', '\x8b'}, 3, 0xCD4B}, /* (HANGUL SYLLABLE CWAELB) */
    {{'\xec', '\xb5', '\x8c'}, 3, 0xCD4C}, /* (HANGUL SYLLABLE CWAELS) */
    {{'\xec', '\xb5', '\x8d'}, 3, 0xCD4D}, /* (HANGUL SYLLABLE CWAELT) */
    {{'\xec', '\xb5', '\x8e'}, 3, 0xCD4E}, /* (HANGUL SYLLABLE CWAELP) */
    {{'\xec', '\xb5', '\x8f'}, 3, 0xCD4F}, /* (HANGUL SYLLABLE CWAELH) */
    {{'\xec', '\xb5', '\x90'}, 3, 0xCD50}, /* (HANGUL SYLLABLE CWAEM) */
    {{'\xec', '\xb5', '\x91'}, 3, 0xCD51}, /* (HANGUL SYLLABLE CWAEB) */
    {{'\xec', '\xb5', '\x92'}, 3, 0xCD52}, /* (HANGUL SYLLABLE CWAEBS) */
    {{'\xec', '\xb5', '\x93'}, 3, 0xCD53}, /* (HANGUL SYLLABLE CWAES) */
    {{'\xec', '\xb5', '\x94'}, 3, 0xCD54}, /* (HANGUL SYLLABLE CWAESS) */
    {{'\xec', '\xb5', '\x95'}, 3, 0xCD55}, /* (HANGUL SYLLABLE CWAENG) */
    {{'\xec', '\xb5', '\x96'}, 3, 0xCD56}, /* (HANGUL SYLLABLE CWAEJ) */
    {{'\xec', '\xb5', '\x97'}, 3, 0xCD57}, /* (HANGUL SYLLABLE CWAEC) */
    {{'\xec', '\xb5', '\x98'}, 3, 0xCD58}, /* (HANGUL SYLLABLE CWAEK) */
    {{'\xec', '\xb5', '\x99'}, 3, 0xCD59}, /* (HANGUL SYLLABLE CWAET) */
    {{'\xec', '\xb5', '\x9a'}, 3, 0xCD5A}, /* (HANGUL SYLLABLE CWAEP) */
    {{'\xec', '\xb5', '\x9b'}, 3, 0xCD5B}, /* (HANGUL SYLLABLE CWAEH) */
    {{'\xec', '\xb5', '\x9d'}, 3, 0xCD5D}, /* (HANGUL SYLLABLE COEG) */
    {{'\xec', '\xb5', '\x9e'}, 3, 0xCD5E}, /* (HANGUL SYLLABLE COEGG) */
    {{'\xec', '\xb5', '\x9f'}, 3, 0xCD5F}, /* (HANGUL SYLLABLE COEGS) */
    {{'\xd0', '\x90'}, 2, 0x0410}, /* (CYRILLIC CAPITAL LETTER A) */
    {{'\xd0', '\x91'}, 2, 0x0411}, /* (CYRILLIC CAPITAL LETTER BE) */
    {{'\xd0', '\x92'}, 2, 0x0412}, /* (CYRILLIC CAPITAL LETTER VE) */
    {{'\xd0', '\x93'}, 2, 0x0413}, /* (CYRILLIC CAPITAL LETTER GHE) */
    {{'\xd0', '\x94'}, 2, 0x0414}, /* (CYRILLIC CAPITAL LETTER DE) */
    {{'\xd0', '\x95'}, 2, 0x0415}, /* (CYRILLIC CAPITAL LETTER IE) */
    {{'\xd0', '\x81'}, 2, 0x0401}, /* (CYRILLIC CAPITAL LETTER IO) */
    {{'\xd0', '\x96'}, 2, 0x0416}, /* (CYRILLIC CAPITAL LETTER ZHE) */
    {{'\xd0', '\x97'}, 2, 0x0417}, /* (CYRILLIC CAPITAL LETTER ZE) */
    {{'\xd0', '\x98'}, 2, 0x0418}, /* (CYRILLIC CAPITAL LETTER I) */
    {{'\xd0', '\x99'}, 2, 0x0419}, /* (CYRILLIC CAPITAL LETTER SHORT I) */
    {{'\xd0', '\x9a'}, 2, 0x041A}, /* (CYRILLIC CAPITAL LETTER KA) */
    {{'\xd0', '\x9b'}, 2, 0x041B}, /* (CYRILLIC CAPITAL LETTER EL) */
    {{'\xd0', '\x9c'}, 2, 0x041C}, /* (CYRILLIC CAPITAL LETTER EM) */
    {{'\xd0', '\x9d'}, 2, 0x041D}, /* (CYRILLIC CAPITAL LETTER EN) */
    {{'\xd0', '\x9e'}, 2, 0x041E}, /* (CYRILLIC CAPITAL LETTER O) */
    {{'\xd0', '\x9f'}, 2, 0x041F}, /* (CYRILLIC CAPITAL LETTER PE) */
    {{'\xd0', '\xa0'}, 2, 0x0420}, /* (CYRILLIC CAPITAL LETTER ER) */
    {{'\xd0', '\xa1'}, 2, 0x0421}, /* (CYRILLIC CAPITAL LETTER ES) */
    {{'\xd0', '\xa2'}, 2, 0x0422}, /* (CYRILLIC CAPITAL LETTER TE) */
    {{'\xd0', '\xa3'}, 2, 0x0423}, /* (CYRILLIC CAPITAL LETTER U) */
    {{'\xd0', '\xa4'}, 2, 0x0424}, /* (CYRILLIC CAPITAL LETTER EF) */
    {{'\xd0', '\xa5'}, 2, 0x0425}, /* (CYRILLIC CAPITAL LETTER HA) */
    {{'\xd0', '\xa6'}, 2, 0x0426}, /* (CYRILLIC CAPITAL LETTER TSE) */
    {{'\xd0', '\xa7'}, 2, 0x0427}, /* (CYRILLIC CAPITAL LETTER CHE) */
    {{'\xd0', '\xa8'}, 2, 0x0428}, /* (CYRILLIC CAPITAL LETTER SHA) */
    {{'\xd0', '\xa9'}, 2, 0x0429}, /* (CYRILLIC CAPITAL LETTER SHCHA) */
    {{'\xd0', '\xaa'}, 2, 0x042A}, /* (CYRILLIC CAPITAL LETTER HARD SIGN) */
    {{'\xd0', '\xab'}, 2, 0x042B}, /* (CYRILLIC CAPITAL LETTER YERU) */
    {{'\xd0', '\xac'}, 2, 0x042C}, /* (CYRILLIC CAPITAL LETTER SOFT SIGN) */
    {{'\xd0', '\xad'}, 2, 0x042D}, /* (CYRILLIC CAPITAL LETTER E) */
    {{'\xd0', '\xae'}, 2, 0x042E}, /* (CYRILLIC CAPITAL LETTER YU) */
    {{'\xd0', '\xaf'}, 2, 0x042F}, /* (CYRILLIC CAPITAL LETTER YA) */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{'\xd0', '\xb0'}, 2, 0x0430}, /* (CYRILLIC SMALL LETTER A) */
    {{'\xd0', '\xb1'}, 2, 0x0431}, /* (CYRILLIC SMALL LETTER BE) */
    {{'\xd0', '\xb2'}, 2, 0x0432}, /* (CYRILLIC SMALL LETTER VE) */
    {{'\xd0', '\xb3'}, 2, 0x0433}, /* (CYRILLIC SMALL LETTER GHE) */
    {{'\xd0', '\xb4'}, 2, 0x0434}, /* (CYRILLIC SMALL LETTER DE) */
    {{'\xd0', '\xb5'}, 2, 0x0435}, /* (CYRILLIC SMALL LETTER IE) */
    {{'\xd1', '\x91'}, 2, 0x0451}, /* (CYRILLIC SMALL LETTER IO) */
    {{'\xd0', '\xb6'}, 2, 0x0436}, /* (CYRILLIC SMALL LETTER ZHE) */
    {{'\xd0', '\xb7'}, 2, 0x0437}, /* (CYRILLIC SMALL LETTER ZE) */
    {{'\xd0', '\xb8'}, 2, 0x0438}, /* (CYRILLIC SMALL LETTER I) */
    {{'\xd0', '\xb9'}, 2, 0x0439}, /* (CYRILLIC SMALL LETTER SHORT I) */
    {{'\xd0', '\xba'}, 2, 0x043A}, /* (CYRILLIC SMALL LETTER KA) */
    {{'\xd0', '\xbb'}, 2, 0x043B}, /* (CYRILLIC SMALL LETTER EL) */
    {{'\xd0', '\xbc'}, 2, 0x043C}, /* (CYRILLIC SMALL LETTER EM) */
    {{'\xd0', '\xbd'}, 2, 0x043D}, /* (CYRILLIC SMALL LETTER EN) */
    {{'\xd0', '\xbe'}, 2, 0x043E}, /* (CYRILLIC SMALL LETTER O) */
    {{'\xd0', '\xbf'}, 2, 0x043F}, /* (CYRILLIC SMALL LETTER PE) */
    {{'\xd1', '\x80'}, 2, 0x0440}, /* (CYRILLIC SMALL LETTER ER) */
    {{'\xd1', '\x81'}, 2, 0x0441}, /* (CYRILLIC SMALL LETTER ES) */
    {{'\xd1', '\x82'}, 2, 0x0442}, /* (CYRILLIC SMALL LETTER TE) */
    {{'\xd1', '\x83'}, 2, 0x0443}, /* (CYRILLIC SMALL LETTER U) */
    {{'\xd1', '\x84'}, 2, 0x0444}, /* (CYRILLIC SMALL LETTER EF) */
    {{'\xd1', '\x85'}, 2, 0x0445}, /* (CYRILLIC SMALL LETTER HA) */
    {{'\xd1', '\x86'}, 2, 0x0446}, /* (CYRILLIC SMALL LETTER TSE) */
    {{'\xd1', '\x87'}, 2, 0x0447}, /* (CYRILLIC SMALL LETTER CHE) */
    {{'\xd1', '\x88'}, 2, 0x0448}, /* (CYRILLIC SMALL LETTER SHA) */
    {{'\xd1', '\x89'}, 2, 0x0449}, /* (CYRILLIC SMALL LETTER SHCHA) */
    {{'\xd1', '\x8a'}, 2, 0x044A}, /* (CYRILLIC SMALL LETTER HARD SIGN) */
    {{'\xd1', '\x8b'}, 2, 0x044B}, /* (CYRILLIC SMALL LETTER YERU) */
    {{'\xd1', '\x8c'}, 2, 0x044C}, /* (CYRILLIC SMALL LETTER SOFT SIGN) */
    {{'\xd1', '\x8d'}, 2, 0x044D}, /* (CYRILLIC SMALL LETTER E) */
    {{'\xd1', '\x8e'}, 2, 0x044E}, /* (CYRILLIC SMALL LETTER YU) */
    {{'\xd1', '\x8f'}, 2, 0x044F}, /* (CYRILLIC SMALL LETTER YA) */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{'\xec', '\xb5', '\xa1'}, 3, 0xCD61}, /* (HANGUL SYLLABLE COENJ) */
    {{'\xec', '\xb5', '\xa2'}, 3, 0xCD62}, /* (HANGUL SYLLABLE COENH) */
    {{'\xec', '\xb5', '\xa3'}, 3, 0xCD63}, /* (HANGUL SYLLABLE COED) */
    {{'\xec', '\xb5', '\xa5'}, 3, 0xCD65}, /* (HANGUL SYLLABLE COELG) */
    {{'\xec', '\xb5', '\xa6'}, 3, 0xCD66}, /* (HANGUL SYLLABLE COELM) */
    {{'\xec', '\xb5', '\xa7'}, 3, 0xCD67}, /* (HANGUL SYLLABLE COELB) */
    {{'\xec', '\xb5', '\xa8'}, 3, 0xCD68}, /* (HANGUL SYLLABLE COELS) */
    {{'\xec', '\xb5', '\xa9'}, 3, 0xCD69}, /* (HANGUL SYLLABLE COELT) */
    {{'\xec', '\xb5', '\xaa'}, 3, 0xCD6A}, /* (HANGUL SYLLABLE COELP) */
    {{'\xec', '\xb5', '\xab'}, 3, 0xCD6B}, /* (HANGUL SYLLABLE COELH) */
    {{'\xec', '\xb5', '\xae'}, 3, 0xCD6E}, /* (HANGUL SYLLABLE COEBS) */
    {{'\xec', '\xb5', '\xb0'}, 3, 0xCD70}, /* (HANGUL SYLLABLE COESS) */
    {{'\xec', '\xb5', '\xb2'}, 3, 0xCD72}, /* (HANGUL SYLLABLE COEJ) */
    {{'\xec', '\xb5', '\xb3'}, 3, 0xCD73}, /* (HANGUL SYLLABLE COEC) */
    {{'\xec', '\xb5', '\xb4'}, 3, 0xCD74}, /* (HANGUL SYLLABLE COEK) */
    {{'\xec', '\xb5', '\xb5'}, 3, 0xCD75}, /* (HANGUL SYLLABLE COET) */
    {{'\xec', '\xb5', '\xb6'}, 3, 0xCD76}, /* (HANGUL SYLLABLE COEP) */
    {{'\xec', '\xb5', '\xb7'}, 3, 0xCD77}, /* (HANGUL SYLLABLE COEH) */
    {{'\xec', '\xb5', '\xb9'}, 3, 0xCD79}, /* (HANGUL SYLLABLE CYOG) */
    {{'\xec', '\xb5', '\xba'}, 3, 0xCD7A}, /* (HANGUL SYLLABLE CYOGG) */
    {{'\xec', '\xb5', '\xbb'}, 3, 0xCD7B}, /* (HANGUL SYLLABLE CYOGS) */
    {{'\xec', '\xb5', '\xbc'}, 3, 0xCD7C}, /* (HANGUL SYLLABLE CYON) */
    {{'\xec', '\xb5', '\xbd'}, 3, 0xCD7D}, /* (HANGUL SYLLABLE CYONJ) */
    {{'\xec', '\xb5', '\xbe'}, 3, 0xCD7E}, /* (HANGUL SYLLABLE CYONH) */
    {{'\xec', '\xb5', '\xbf'}, 3, 0xCD7F}, /* (HANGUL SYLLABLE CYOD) */
    {{'\xec', '\xb6', '\x80'}, 3, 0xCD80}, /* (HANGUL SYLLABLE CYOL) */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{'\xec', '\xb6', '\x81'}, 3, 0xCD81}, /* (HANGUL SYLLABLE CYOLG) */
    {{'\xec', '\xb6', '\x82'}, 3, 0xCD82}, /* (HANGUL SYLLABLE CYOLM) */
    {{'\xec', '\xb6', '\x83'}, 3, 0xCD83}, /* (HANGUL SYLLABLE CYOLB) */
    {{'\xec', '\xb6', '\x84'}, 3, 0xCD84}, /* (HANGUL SYLLABLE CYOLS) */
    {{'\xec', '\xb6', '\x85'}, 3, 0xCD85}, /* (HANGUL SYLLABLE CYOLT) */
    {{'\xec', '\xb6', '\x86'}, 3, 0xCD86}, /* (HANGUL SYLLABLE CYOLP) */
    {{'\xec', '\xb6', '\x87'}, 3, 0xCD87}, /* (HANGUL SYLLABLE CYOLH) */
    {{'\xec', '\xb6', '\x89'}, 3, 0xCD89}, /* (HANGUL SYLLABLE CYOB) */
    {{'\xec', '\xb6', '\x8a'}, 3, 0xCD8A}, /* (HANGUL SYLLABLE CYOBS) */
    {{'\xec', '\xb6', '\x8b'}, 3, 0xCD8B}, /* (HANGUL SYLLABLE CYOS) */
    {{'\xec', '\xb6', '\x8c'}, 3, 0xCD8C}, /* (HANGUL SYLLABLE CYOSS) */
    {{'\xec', '\xb6', '\x8d'}, 3, 0xCD8D}, /* (HANGUL SYLLABLE CYONG) */
    {{'\xec', '\xb6', '\x8e'}, 3, 0xCD8E}, /* (HANGUL SYLLABLE CYOJ) */
    {{'\xec', '\xb6', '\x8f'}, 3, 0xCD8F}, /* (HANGUL SYLLABLE CYOC) */
    {{'\xec', '\xb6', '\x90'}, 3, 0xCD90}, /* (HANGUL SYLLABLE CYOK) */
    {{'\xec', '\xb6', '\x91'}, 3, 0xCD91}, /* (HANGUL SYLLABLE CYOT) */
    {{'\xec', '\xb6', '\x92'}, 3, 0xCD92}, /* (HANGUL SYLLABLE CYOP) */
    {{'\xec', '\xb6', '\x93'}, 3, 0xCD93}, /* (HANGUL SYLLABLE CYOH) */
    {{'\xec', '\xb6', '\x96'}, 3, 0xCD96}, /* (HANGUL SYLLABLE CUGG) */
    {{'\xec', '\xb6', '\x97'}, 3, 0xCD97}, /* (HANGUL SYLLABLE CUGS) */
    {{'\xec', '\xb6', '\x99'}, 3, 0xCD99}, /* (HANGUL SYLLABLE CUNJ) */
    {{'\xec', '\xb6', '\x9a'}, 3, 0xCD9A}, /* (HANGUL SYLLABLE CUNH) */
    {{'\xec', '\xb6', '\x9b'}, 3, 0xCD9B}, /* (HANGUL SYLLABLE CUD) */
    {{'\xec', '\xb6', '\x9d'}, 3, 0xCD9D}, /* (HANGUL SYLLABLE CULG) */
    {{'\xec', '\xb6', '\x9e'}, 3, 0xCD9E}, /* (HANGUL SYLLABLE CULM) */
    {{'\xec', '\xb6', '\x9f'}, 3, 0xCD9F}, /* (HANGUL SYLLABLE CULB) */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{'\xec', '\xb6', '\xa0'}, 3, 0xCDA0}, /* (HANGUL SYLLABLE CULS) */
    {{'\xec', '\xb6', '\xa1'}, 3, 0xCDA1}, /* (HANGUL SYLLABLE CULT) */
    {{'\xec', '\xb6', '\xa2'}, 3, 0xCDA2}, /* (HANGUL SYLLABLE CULP) */
    {{'\xec', '\xb6', '\xa3'}, 3, 0xCDA3}, /* (HANGUL SYLLABLE CULH) */
    {{'\xec', '\xb6', '\xa6'}, 3, 0xCDA6}, /* (HANGUL SYLLABLE CUBS) */
    {{'\xec', '\xb6', '\xa8'}, 3, 0xCDA8}, /* (HANGUL SYLLABLE CUSS) */
    {{'\xec', '\xb6', '\xaa'}, 3, 0xCDAA}, /* (HANGUL SYLLABLE CUJ) */
    {{'\xec', '\xb6', '\xab'}, 3, 0xCDAB}, /* (HANGUL SYLLABLE CUC) */
    {{'\xec', '\xb6', '\xac'}, 3, 0xCDAC}, /* (HANGUL SYLLABLE CUK) */
    {{'\xec', '\xb6', '\xad'}, 3, 0xCDAD}, /* (HANGUL SYLLABLE CUT) */
    {{'\xec', '\xb6', '\xae'}, 3, 0xCDAE}, /* (HANGUL SYLLABLE CUP) */
    {{'\xec', '\xb6', '\xaf'}, 3, 0xCDAF}, /* (HANGUL SYLLABLE CUH) */
    {{'\xec', '\xb6', '\xb1'}, 3, 0xCDB1}, /* (HANGUL SYLLABLE CWEOG) */
    {{'\xec', '\xb6', '\xb2'}, 3, 0xCDB2}, /* (HANGUL SYLLABLE CWEOGG) */
    {{'\xec', '\xb6', '\xb3'}, 3, 0xCDB3}, /* (HANGUL SYLLABLE CWEOGS) */
    {{'\xec', '\xb6', '\xb4'}, 3, 0xCDB4}, /* (HANGUL SYLLABLE CWEON) */
    {{'\xec', '\xb6', '\xb5'}, 3, 0xCDB5}, /* (HANGUL SYLLABLE CWEONJ) */
    {{'\xec', '\xb6', '\xb6'}, 3, 0xCDB6}, /* (HANGUL SYLLABLE CWEONH) */
    {{'\xec', '\xb6', '\xb7'}, 3, 0xCDB7}, /* (HANGUL SYLLABLE CWEOD) */
    {{'\xec', '\xb6', '\xb8'}, 3, 0xCDB8}, /* (HANGUL SYLLABLE CWEOL) */
    {{'\xec', '\xb6', '\xb9'}, 3, 0xCDB9}, /* (HANGUL SYLLABLE CWEOLG) */
    {{'\xec', '\xb6', '\xba'}, 3, 0xCDBA}, /* (HANGUL SYLLABLE CWEOLM) */
    {{'\xec', '\xb6', '\xbb'}, 3, 0xCDBB}, /* (HANGUL SYLLABLE CWEOLB) */
    {{'\xec', '\xb6', '\xbc'}, 3, 0xCDBC}, /* (HANGUL SYLLABLE CWEOLS) */
    {{'\xec', '\xb6', '\xbd'}, 3, 0xCDBD}, /* (HANGUL SYLLABLE CWEOLT) */
    {{'\xec', '\xb6', '\xbe'}, 3, 0xCDBE}, /* (HANGUL SYLLABLE CWEOLP) */
    {{'\xec', '\xb6', '\xbf'}, 3, 0xCDBF}, /* (HANGUL SYLLABLE CWEOLH) */
    {{'\xec', '\xb7', '\x80'}, 3, 0xCDC0}, /* (HANGUL SYLLABLE CWEOM) */
    {{'\xec', '\xb7', '\x81'}, 3, 0xCDC1}, /* (HANGUL SYLLABLE CWEOB) */
    {{'\xec', '\xb7', '\x82'}, 3, 0xCDC2}, /* (HANGUL SYLLABLE CWEOBS) */
    {{'\xec', '\xb7', '\x83'}, 3, 0xCDC3}, /* (HANGUL SYLLABLE CWEOS) */
    {{'\xec', '\xb7', '\x85'}, 3, 0xCDC5}, /* (HANGUL SYLLABLE CWEONG) */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{'\xec', '\xb7', '\x86'}, 3, 0xCDC6}, /* (HANGUL SYLLABLE CWEOJ) */
    {{'\xec', '\xb7', '\x87'}, 3, 0xCDC7}, /* (HANGUL SYLLABLE CWEOC) */
    {{'\xec', '\xb7', '\x88'}, 3, 0xCDC8}, /* (HANGUL SYLLABLE CWEOK) */
    {{'\xec', '\xb7', '\x89'}, 3, 0xCDC9}, /* (HANGUL SYLLABLE CWEOT) */
    {{'\xec', '\xb7', '\x8a'}, 3, 0xCDCA}, /* (HANGUL SYLLABLE CWEOP) */
    {{'\xec', '\xb7', '\x8b'}, 3, 0xCDCB}, /* (HANGUL SYLLABLE CWEOH) */
    {{'\xec', '\xb7', '\x8d'}, 3, 0xCDCD}, /* (HANGUL SYLLABLE CWEG) */
    {{'\xec', '\xb7', '\x8e'}, 3, 0xCDCE}, /* (HANGUL SYLLABLE CWEGG) */
    {{'\xec', '\xb7', '\x8f'}, 3, 0xCDCF}, /* (HANGUL SYLLABLE CWEGS) */
    {{'\xec', '\xb7', '\x91'}, 3, 0xCDD1}, /* (HANGUL SYLLABLE CWENJ) */
    {{'\xec', '\xb7', '\x92'}, 3, 0xCDD2}, /* (HANGUL SYLLABLE CWENH) */
    {{'\xec', '\xb7', '\x93'}, 3, 0xCDD3}, /* (HANGUL SYLLABLE CWED) */
    {{'\xec', '\xb7', '\x94'}, 3, 0xCDD4}, /* (HANGUL SYLLABLE CWEL) */
    {{'\xec', '\xb7', '\x95'}, 3, 0xCDD5}, /* (HANGUL SYLLABLE CWELG) */
    {{'\xec', '\xb7', '\x96'}, 3, 0xCDD6}, /* (HANGUL SYLLABLE CWELM) */
    {{'\xec', '\xb7', '\x97'}, 3, 0xCDD7}, /* (HANGUL SYLLABLE CWELB) */
    {{'\xec', '\xb7', '\x98'}, 3, 0xCDD8}, /* (HANGUL SYLLABLE CWELS) */
    {{'\xec', '\xb7', '\x99'}, 3, 0xCDD9}, /* (HANGUL SYLLABLE CWELT) */
    {{'\xec', '\xb7', '\x9a'}, 3, 0xCDDA}, /* (HANGUL SYLLABLE CWELP) */
    {{'\xec', '\xb7', '\x9b'}, 3, 0xCDDB}, /* (HANGUL SYLLABLE CWELH) */
    {{'\xec', '\xb7', '\x9c'}, 3, 0xCDDC}, /* (HANGUL SYLLABLE CWEM) */
    {{'\xec', '\xb7', '\x9d'}, 3, 0xCDDD}, /* (HANGUL SYLLABLE CWEB) */
    {{'\xec', '\xb7', '\x9e'}, 3, 0xCDDE}, /* (HANGUL SYLLABLE CWEBS) */
    {{'\xec', '\xb7', '\x9f'}, 3, 0xCDDF}, /* (HANGUL SYLLABLE CWES) */
    {{'\xec', '\xb7', '\xa0'}, 3, 0xCDE0}, /* (HANGUL SYLLABLE CWESS) */
    {{'\xec', '\xb7', '\xa1'}, 3, 0xCDE1}, /* (HANGUL SYLLABLE CWENG) */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{'\xec', '\xb7', '\xa2'}, 3, 0xCDE2}, /* (HANGUL SYLLABLE CWEJ) */
    {{'\xec', '\xb7', '\xa3'}, 3, 0xCDE3}, /* (HANGUL SYLLABLE CWEC) */
    {{'\xec', '\xb7', '\xa4'}, 3, 0xCDE4}, /* (HANGUL SYLLABLE CWEK) */
    {{'\xec', '\xb7', '\xa5'}, 3, 0xCDE5}, /* (HANGUL SYLLABLE CWET) */
    {{'\xec', '\xb7', '\xa6'}, 3, 0xCDE6}, /* (HANGUL SYLLABLE CWEP) */
    {{'\xec', '\xb7', '\xa7'}, 3, 0xCDE7}, /* (HANGUL SYLLABLE CWEH) */
    {{'\xec', '\xb7', '\xa9'}, 3, 0xCDE9}, /* (HANGUL SYLLABLE CWIG) */
    {{'\xec', '\xb7', '\xaa'}, 3, 0xCDEA}, /* (HANGUL SYLLABLE CWIGG) */
    {{'\xec', '\xb7', '\xab'}, 3, 0xCDEB}, /* (HANGUL SYLLABLE CWIGS) */
    {{'\xec', '\xb7', '\xad'}, 3, 0xCDED}, /* (HANGUL SYLLABLE CWINJ) */
    {{'\xec', '\xb7', '\xae'}, 3, 0xCDEE}, /* (HANGUL SYLLABLE CWINH) */
    {{'\xec', '\xb7', '\xaf'}, 3, 0xCDEF}, /* (HANGUL SYLLABLE CWID) */
    {{'\xec', '\xb7', '\xb1'}, 3, 0xCDF1}, /* (HANGUL SYLLABLE CWILG) */
    {{'\xec', '\xb7', '\xb2'}, 3, 0xCDF2}, /* (HANGUL SYLLABLE CWILM) */
    {{'\xec', '\xb7', '\xb3'}, 3, 0xCDF3}, /* (HANGUL SYLLABLE CWILB) */
    {{'\xec', '\xb7', '\xb4'}, 3, 0xCDF4}, /* (HANGUL SYLLABLE CWILS) */
    {{'\xec', '\xb7', '\xb5'}, 3, 0xCDF5}, /* (HANGUL SYLLABLE CWILT) */
    {{'\xec', '\xb7', '\xb6'}, 3, 0xCDF6}, /* (HANGUL SYLLABLE CWILP) */
    {{'\xec', '\xb7', '\xb7'}, 3, 0xCDF7}, /* (HANGUL SYLLABLE CWILH) */
    {{'\xec', '\xb7', '\xba'}, 3, 0xCDFA}, /* (HANGUL SYLLABLE CWIBS) */
    {{'\xec', '\xb7', '\xbc'}, 3, 0xCDFC}, /* (HANGUL SYLLABLE CWISS) */
    {{'\xec', '\xb7', '\xbe'}, 3, 0xCDFE}, /* (HANGUL SYLLABLE CWIJ) */
    {{'\xec', '\xb7', '\xbf'}, 3, 0xCDFF}, /* (HANGUL SYLLABLE CWIC) */
    {{'\xec', '\xb8', '\x80'}, 3, 0xCE00}, /* (HANGUL SYLLABLE CWIK) */
    {{'\xec', '\xb8', '\x81'}, 3, 0xCE01}, /* (HANGUL SYLLABLE CWIT) */
    {{'\xec', '\xb8', '\x82'}, 3, 0xCE02}, /* (HANGUL SYLLABLE CWIP) */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{'\xec', '\xb8', '\x83'}, 3, 0xCE03}, /* (HANGUL SYLLABLE CWIH) */
    {{'\xec', '\xb8', '\x85'}, 3, 0xCE05}, /* (HANGUL SYLLABLE CYUG) */
    {{'\xec', '\xb8', '\x86'}, 3, 0xCE06}, /* (HANGUL SYLLABLE CYUGG) */
    {{'\xec', '\xb8', '\x87'}, 3, 0xCE07}, /* (HANGUL SYLLABLE CYUGS) */
    {{'\xec', '\xb8', '\x89'}, 3, 0xCE09}, /* (HANGUL SYLLABLE CYUNJ) */
    {{'\xec', '\xb8', '\x8a'}, 3, 0xCE0A}, /* (HANGUL SYLLABLE CYUNH) */
    {{'\xec', '\xb8', '\x8b'}, 3, 0xCE0B}, /* (HANGUL SYLLABLE CYUD) */
    {{'\xec', '\xb8', '\x8d'}, 3, 0xCE0D}, /* (HANGUL SYLLABLE CYULG) */
    {{'\xec', '\xb8', '\x8e'}, 3, 0xCE0E}, /* (HANGUL SYLLABLE CYULM) */
    {{'\xec', '\xb8', '\x8f'}, 3, 0xCE0F}, /* (HANGUL SYLLABLE CYULB) */
    {{'\xec', '\xb8', '\x90'}, 3, 0xCE10}, /* (HANGUL SYLLABLE CYULS) */
    {{'\xec', '\xb8', '\x91'}, 3, 0xCE11}, /* (HANGUL SYLLABLE CYULT) */
    {{'\xec', '\xb8', '\x92'}, 3, 0xCE12}, /* (HANGUL SYLLABLE CYULP) */
    {{'\xec', '\xb8', '\x93'}, 3, 0xCE13}, /* (HANGUL SYLLABLE CYULH) */
    {{'\xec', '\xb8', '\x95'}, 3, 0xCE15}, /* (HANGUL SYLLABLE CYUB) */
    {{'\xec', '\xb8', '\x96'}, 3, 0xCE16}, /* (HANGUL SYLLABLE CYUBS) */
    {{'\xec', '\xb8', '\x97'}, 3, 0xCE17}, /* (HANGUL SYLLABLE CYUS) */
    {{'\xec', '\xb8', '\x98'}, 3, 0xCE18}, /* (HANGUL SYLLABLE CYUSS) */
    {{'\xec', '\xb8', '\x9a'}, 3, 0xCE1A}, /* (HANGUL SYLLABLE CYUJ) */
    {{'\xec', '\xb8', '\x9b'}, 3, 0xCE1B}, /* (HANGUL SYLLABLE CYUC) */
    {{'\xec', '\xb8', '\x9c'}, 3, 0xCE1C}, /* (HANGUL SYLLABLE CYUK) */
    {{'\xec', '\xb8', '\x9d'}, 3, 0xCE1D}, /* (HANGUL SYLLABLE CYUT) */
    {{'\xec', '\xb8', '\x9e'}, 3, 0xCE1E}, /* (HANGUL SYLLABLE CYUP) */
    {{'\xec', '\xb8', '\x9f'}, 3, 0xCE1F}, /* (HANGUL SYLLABLE CYUH) */
    {{'\xec', '\xb8', '\xa2'}, 3, 0xCE22}, /* (HANGUL SYLLABLE CEUGG) */
    {{'\xec', '\xb8', '\xa3'}, 3, 0xCE23}, /* (HANGUL SYLLABLE CEUGS) */
    {{'\xec', '\xb8', '\xa5'}, 3, 0xCE25}, /* (HANGUL SYLLABLE CEUNJ) */
    {{'\xec', '\xb8', '\xa6'}, 3, 0xCE26}, /* (HANGUL SYLLABLE CEUNH) */
    {{'\xec', '\xb8', '\xa7'}, 3, 0xCE27}, /* (HANGUL SYLLABLE CEUD) */
    {{'\xec', '\xb8', '\xa9'}, 3, 0xCE29}, /* (HANGUL SYLLABLE CEULG) */
    {{'\xec', '\xb8', '\xaa'}, 3, 0xCE2A}, /* (HANGUL SYLLABLE CEULM) */
    {{'\xec', '\xb8', '\xab'}, 3, 0xCE2B}, /* (HANGUL SYLLABLE CEULB) */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{'\xec', '\xb8', '\xac'}, 3, 0xCE2C}, /* (HANGUL SYLLABLE CEULS) */
    {{'\xec', '\xb8', '\xad'}, 3, 0xCE2D}, /* (HANGUL SYLLABLE CEULT) */
    {{'\xec', '\xb8', '\xae'}, 3, 0xCE2E}, /* (HANGUL SYLLABLE CEULP) */
    {{'\xec', '\xb8', '\xaf'}, 3, 0xCE2F}, /* (HANGUL SYLLABLE CEULH) */
    {{'\xec', '\xb8', '\xb2'}, 3, 0xCE32}, /* (HANGUL SYLLABLE CEUBS) */
    {{'\xec', '\xb8', '\xb4'}, 3, 0xCE34}, /* (HANGUL SYLLABLE CEUSS) */
    {{'\xec', '\xb8', '\xb6'}, 3, 0xCE36}, /* (HANGUL SYLLABLE CEUJ) */
    {{'\xec', '\xb8', '\xb7'}, 3, 0xCE37}, /* (HANGUL SYLLABLE CEUC) */
    {{'\xec', '\xb8', '\xb8'}, 3, 0xCE38}, /* (HANGUL SYLLABLE CEUK) */
    {{'\xec', '\xb8', '\xb9'}, 3, 0xCE39}, /* (HANGUL SYLLABLE CEUT) */
    {{'\xec', '\xb8', '\xba'}, 3, 0xCE3A}, /* (HANGUL SYLLABLE CEUP) */
    {{'\xec', '\xb8', '\xbb'}, 3, 0xCE3B}, /* (HANGUL SYLLABLE CEUH) */
    {{'\xec', '\xb8', '\xbc'}, 3, 0xCE3C}, /* (HANGUL SYLLABLE CYI) */
    {{'\xec', '\xb8', '\xbd'}, 3, 0xCE3D}, /* (HANGUL SYLLABLE CYIG) */
    {{'\xec', '\xb8', '\xbe'}, 3, 0xCE3E}, /* (HANGUL SYLLABLE CYIGG) */
    {{'\xec', '\xb8', '\xbf'}, 3, 0xCE3F}, /* (HANGUL SYLLABLE CYIGS) */
    {{'\xec', '\xb9', '\x80'}, 3, 0xCE40}, /* (HANGUL SYLLABLE CYIN) */
    {{'\xec', '\xb9', '\x81'}, 3, 0xCE41}, /* (HANGUL SYLLABLE CYINJ) */
    {{'\xec', '\xb9', '\x82'}, 3, 0xCE42}, /* (HANGUL SYLLABLE CYINH) */
    {{'\xec', '\xb9', '\x83'}, 3, 0xCE43}, /* (HANGUL SYLLABLE CYID) */
    {{'\xec', '\xb9', '\x84'}, 3, 0xCE44}, /* (HANGUL SYLLABLE CYIL) */
    {{'\xec', '\xb9', '\x85'}, 3, 0xCE45}, /* (HANGUL SYLLABLE CYILG) */
    {{'\xec', '\xb9', '\x86'}, 3, 0xCE46}, /* (HANGUL SYLLABLE CYILM) */
    {{'\xec', '\xb9', '\x87'}, 3, 0xCE47}, /* (HANGUL SYLLABLE CYILB) */
    {{'\xec', '\xb9', '\x88'}, 3, 0xCE48}, /* (HANGUL SYLLABLE CYILS) */
    {{'\xec', '\xb9', '\x89'}, 3, 0xCE49}, /* (HANGUL SYLLABLE CYILT) */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{'\xec', '\xb9', '\x8a'}, 3, 0xCE4A}, /* (HANGUL SYLLABLE CYILP) */
    {{'\xec', '\xb9', '\x8b'}, 3, 0xCE4B}, /* (HANGUL SYLLABLE CYILH) */
    {{'\xec', '\xb9', '\x8c'}, 3, 0xCE4C}, /* (HANGUL SYLLABLE CYIM) */
    {{'\xec', '\xb9', '\x8d'}, 3, 0xCE4D}, /* (HANGUL SYLLABLE CYIB) */
    {{'\xec', '\xb9', '\x8e'}, 3, 0xCE4E}, /* (HANGUL SYLLABLE CYIBS) */
    {{'\xec', '\xb9', '\x8f'}, 3, 0xCE4F}, /* (HANGUL SYLLABLE CYIS) */
    {{'\xec', '\xb9', '\x90'}, 3, 0xCE50}, /* (HANGUL SYLLABLE CYISS) */
    {{'\xec', '\xb9', '\x91'}, 3, 0xCE51}, /* (HANGUL SYLLABLE CYING) */
    {{'\xec', '\xb9', '\x92'}, 3, 0xCE52}, /* (HANGUL SYLLABLE CYIJ) */
    {{'\xec', '\xb9', '\x93'}, 3, 0xCE53}, /* (HANGUL SYLLABLE CYIC) */
    {{'\xec', '\xb9', '\x94'}, 3, 0xCE54}, /* (HANGUL SYLLABLE CYIK) */
    {{'\xec', '\xb9', '\x95'}, 3, 0xCE55}, /* (HANGUL SYLLABLE CYIT) */
    {{'\xec', '\xb9', '\x96'}, 3, 0xCE56}, /* (HANGUL SYLLABLE CYIP) */
    {{'\xec', '\xb9', '\x97'}, 3, 0xCE57}, /* (HANGUL SYLLABLE CYIH) */
    {{'\xec', '\xb9', '\x9a'}, 3, 0xCE5A}, /* (HANGUL SYLLABLE CIGG) */
    {{'\xec', '\xb9', '\x9b'}, 3, 0xCE5B}, /* (HANGUL SYLLABLE CIGS) */
    {{'\xec', '\xb9', '\x9d'}, 3, 0xCE5D}, /* (HANGUL SYLLABLE CINJ) */
    {{'\xec', '\xb9', '\x9e'}, 3, 0xCE5E}, /* (HANGUL SYLLABLE CINH) */
    {{'\xec', '\xb9', '\xa2'}, 3, 0xCE62}, /* (HANGUL SYLLABLE CILM) */
    {{'\xec', '\xb9', '\xa3'}, 3, 0xCE63}, /* (HANGUL SYLLABLE CILB) */
    {{'\xec', '\xb9', '\xa4'}, 3, 0xCE64}, /* (HANGUL SYLLABLE CILS) */
    {{'\xec', '\xb9', '\xa5'}, 3, 0xCE65}, /* (HANGUL SYLLABLE CILT) */
    {{'\xec', '\xb9', '\xa6'}, 3, 0xCE66}, /* (HANGUL SYLLABLE CILP) */
    {{'\xec', '\xb9', '\xa7'}, 3, 0xCE67}, /* (HANGUL SYLLABLE CILH) */
    {{'\xec', '\xb9', '\xaa'}, 3, 0xCE6A}, /* (HANGUL SYLLABLE CIBS) */
    {{'\xec', '\xb9', '\xac'}, 3, 0xCE6C}, /* (HANGUL SYLLABLE CISS) */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{'\xec', '\xb9', '\xae'}, 3, 0xCE6E}, /* (HANGUL SYLLABLE CIJ) */
    {{'\xec', '\xb9', '\xaf'}, 3, 0xCE6F}, /* (HANGUL SYLLABLE CIC) */
    {{'\xec', '\xb9', '\xb0'}, 3, 0xCE70}, /* (HANGUL SYLLABLE CIK) */
    {{'\xec', '\xb9', '\xb1'}, 3, 0xCE71}, /* (HANGUL SYLLABLE CIT) */
    {{'\xec', '\xb9', '\xb2'}, 3, 0xCE72}, /* (HANGUL SYLLABLE CIP) */
    {{'\xec', '\xb9', '\xb3'}, 3, 0xCE73}, /* (HANGUL SYLLABLE CIH) */
    {{'\xec', '\xb9', '\xb6'}, 3, 0xCE76}, /* (HANGUL SYLLABLE KAGG) */
    {{'\xec', '\xb9', '\xb7'}, 3, 0xCE77}, /* (HANGUL SYLLABLE KAGS) */
    {{'\xec', '\xb9', '\xb9'}, 3, 0xCE79}, /* (HANGUL SYLLABLE KANJ) */
    {{'\xec', '\xb9', '\xba'}, 3, 0xCE7A}, /* (HANGUL SYLLABLE KANH) */
    {{'\xec', '\xb9', '\xbb'}, 3, 0xCE7B}, /* (HANGUL SYLLABLE KAD) */
    {{'\xec', '\xb9', '\xbd'}, 3, 0xCE7D}, /* (HANGUL SYLLABLE KALG) */
    {{'\xec', '\xb9', '\xbe'}, 3, 0xCE7E}, /* (HANGUL SYLLABLE KALM) */
    {{'\xec', '\xb9', '\xbf'}, 3, 0xCE7F}, /* (HANGUL SYLLABLE KALB) */
    {{'\xec', '\xba', '\x80'}, 3, 0xCE80}, /* (HANGUL SYLLABLE KALS) */
    {{'\xec', '\xba', '\x81'}, 3, 0xCE81}, /* (HANGUL SYLLABLE KALT) */
    {{'\xec', '\xba', '\x82'}, 3, 0xCE82}, /* (HANGUL SYLLABLE KALP) */
    {{'\xec', '\xba', '\x83'}, 3, 0xCE83}, /* (HANGUL SYLLABLE KALH) */
    {{'\xec', '\xba', '\x86'}, 3, 0xCE86}, /* (HANGUL SYLLABLE KABS) */
    {{'\xec', '\xba', '\x88'}, 3, 0xCE88}, /* (HANGUL SYLLABLE KASS) */
    {{'\xec', '\xba', '\x8a'}, 3, 0xCE8A}, /* (HANGUL SYLLABLE KAJ) */
    {{'\xec', '\xba', '\x8b'}, 3, 0xCE8B}, /* (HANGUL SYLLABLE KAC) */
    {{'\xec', '\xba', '\x8c'}, 3, 0xCE8C}, /* (HANGUL SYLLABLE KAK) */
    {{'\xec', '\xba', '\x8d'}, 3, 0xCE8D}, /* (HANGUL SYLLABLE KAT) */
    {{'\xec', '\xba', '\x8e'}, 3, 0xCE8E}, /* (HANGUL SYLLABLE KAP) */
    {{'\xec', '\xba', '\x8f'}, 3, 0xCE8F}, /* (HANGUL SYLLABLE KAH) */
    {{'\xec', '\xba', '\x92'}, 3, 0xCE92}, /* (HANGUL SYLLABLE KAEGG) */
    {{'\xec', '\xba', '\x93'}, 3, 0xCE93}, /* (HANGUL SYLLABLE KAEGS) */
    {{'\xec', '\xba', '\x95'}, 3, 0xCE95}, /* (HANGUL SYLLABLE KAENJ) */
    {{'\xec', '\xba', '\x96'}, 3, 0xCE96}, /* (HANGUL SYLLABLE KAENH) */
    {{'\xec', '\xba', '\x97'}, 3, 0xCE97}, /* (HANGUL SYLLABLE KAED) */
    {{'\xec', '\xba', '\x99'}, 3, 0xCE99}, /* (HANGUL SYLLABLE KAELG) */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{'\xec', '\xba', '\x9a'}, 3, 0xCE9A}, /* (HANGUL SYLLABLE KAELM) */
    {{'\xec', '\xba', '\x9b'}, 3, 0xCE9B}, /* (HANGUL SYLLABLE KAELB) */
    {{'\xec', '\xba', '\x9c'}, 3, 0xCE9C}, /* (HANGUL SYLLABLE KAELS) */
    {{'\xec', '\xba', '\x9d'}, 3, 0xCE9D}, /* (HANGUL SYLLABLE KAELT) */
    {{'\xec', '\xba', '\x9e'}, 3, 0xCE9E}, /* (HANGUL SYLLABLE KAELP) */
    {{'\xec', '\xba', '\x9f'}, 3, 0xCE9F}, /* (HANGUL SYLLABLE KAELH) */
    {{'\xec', '\xba', '\xa2'}, 3, 0xCEA2}, /* (HANGUL SYLLABLE KAEBS) */
    {{'\xec', '\xba', '\xa6'}, 3, 0xCEA6}, /* (HANGUL SYLLABLE KAEJ) */
    {{'\xec', '\xba', '\xa7'}, 3, 0xCEA7}, /* (HANGUL SYLLABLE KAEC) */
    {{'\xec', '\xba', '\xa8'}, 3, 0xCEA8}, /* (HANGUL SYLLABLE KAEK) */
    {{'\xec', '\xba', '\xa9'}, 3, 0xCEA9}, /* (HANGUL SYLLABLE KAET) */
    {{'\xec', '\xba', '\xaa'}, 3, 0xCEAA}, /* (HANGUL SYLLABLE KAEP) */
    {{'\xec', '\xba', '\xab'}, 3, 0xCEAB}, /* (HANGUL SYLLABLE KAEH) */
    {{'\xec', '\xba', '\xae'}, 3, 0xCEAE}, /* (HANGUL SYLLABLE KYAGG) */
    {{'\xec', '\xba', '\xaf'}, 3, 0xCEAF}, /* (HANGUL SYLLABLE KYAGS) */
    {{'\xec', '\xba', '\xb0'}, 3, 0xCEB0}, /* (HANGUL SYLLABLE KYAN) */
    {{'\xec', '\xba', '\xb1'}, 3, 0xCEB1}, /* (HANGUL SYLLABLE KYANJ) */
    {{'\xec', '\xba', '\xb2'}, 3, 0xCEB2}, /* (HANGUL SYLLABLE KYANH) */
    {{'\xec', '\xba', '\xb3'}, 3, 0xCEB3}, /* (HANGUL SYLLABLE KYAD) */
    {{'\xec', '\xba', '\xb4'}, 3, 0xCEB4}, /* (HANGUL SYLLABLE KYAL) */
    {{'\xec', '\xba', '\xb5'}, 3, 0xCEB5}, /* (HANGUL SYLLABLE KYALG) */
    {{'\xec', '\xba', '\xb6'}, 3, 0xCEB6}, /* (HANGUL SYLLABLE KYALM) */
    {{'\xec', '\xba', '\xb7'}, 3, 0xCEB7}, /* (HANGUL SYLLABLE KYALB) */
    {{'\xec', '\xba', '\xb8'}, 3, 0xCEB8}, /* (HANGUL SYLLABLE KYALS) */
    {{'\xec', '\xba', '\xb9'}, 3, 0xCEB9}, /* (HANGUL SYLLABLE KYALT) */
    {{'\xec', '\xba', '\xba'}, 3, 0xCEBA}, /* (HANGUL SYLLABLE KYALP) */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{'\xec', '\xba', '\xbb'}, 3, 0xCEBB}, /* (HANGUL SYLLABLE KYALH) */
    {{'\xec', '\xba', '\xbc'}, 3, 0xCEBC}, /* (HANGUL SYLLABLE KYAM) */
    {{'\xec', '\xba', '\xbd'}, 3, 0xCEBD}, /* (HANGUL SYLLABLE KYAB) */
    {{'\xec', '\xba', '\xbe'}, 3, 0xCEBE}, /* (HANGUL SYLLABLE KYABS) */
    {{'\xec', '\xba', '\xbf'}, 3, 0xCEBF}, /* (HANGUL SYLLABLE KYAS) */
    {{'\xec', '\xbb', '\x80'}, 3, 0xCEC0}, /* (HANGUL SYLLABLE KYASS) */
    {{'\xec', '\xbb', '\x82'}, 3, 0xCEC2}, /* (HANGUL SYLLABLE KYAJ) */
    {{'\xec', '\xbb', '\x83'}, 3, 0xCEC3}, /* (HANGUL SYLLABLE KYAC) */
    {{'\xec', '\xbb', '\x84'}, 3, 0xCEC4}, /* (HANGUL SYLLABLE KYAK) */
    {{'\xec', '\xbb', '\x85'}, 3, 0xCEC5}, /* (HANGUL SYLLABLE KYAT) */
    {{'\xec', '\xbb', '\x86'}, 3, 0xCEC6}, /* (HANGUL SYLLABLE KYAP) */
    {{'\xec', '\xbb', '\x87'}, 3, 0xCEC7}, /* (HANGUL SYLLABLE KYAH) */
    {{'\xec', '\xbb', '\x88'}, 3, 0xCEC8}, /* (HANGUL SYLLABLE KYAE) */
    {{'\xec', '\xbb', '\x89'}, 3, 0xCEC9}, /* (HANGUL SYLLABLE KYAEG) */
    {{'\xec', '\xbb', '\x8a'}, 3, 0xCECA}, /* (HANGUL SYLLABLE KYAEGG) */
    {{'\xec', '\xbb', '\x8b'}, 3, 0xCECB}, /* (HANGUL SYLLABLE KYAEGS) */
    {{'\xec', '\xbb', '\x8c'}, 3, 0xCECC}, /* (HANGUL SYLLABLE KYAEN) */
    {{'\xec', '\xbb', '\x8d'}, 3, 0xCECD}, /* (HANGUL SYLLABLE KYAENJ) */
    {{'\xec', '\xbb', '\x8e'}, 3, 0xCECE}, /* (HANGUL SYLLABLE KYAENH) */
    {{'\xec', '\xbb', '\x8f'}, 3, 0xCECF}, /* (HANGUL SYLLABLE KYAED) */
    {{'\xec', '\xbb', '\x90'}, 3, 0xCED0}, /* (HANGUL SYLLABLE KYAEL) */
    {{'\xec', '\xbb', '\x91'}, 3, 0xCED1}, /* (HANGUL SYLLABLE KYAELG) */
    {{'\xec', '\xbb', '\x92'}, 3, 0xCED2}, /* (HANGUL SYLLABLE KYAELM) */
    {{'\xec', '\xbb', '\x93'}, 3, 0xCED3}, /* (HANGUL SYLLABLE KYAELB) */
    {{'\xec', '\xbb', '\x94'}, 3, 0xCED4}, /* (HANGUL SYLLABLE KYAELS) */
    {{'\xec', '\xbb', '\x95'}, 3, 0xCED5}, /* (HANGUL SYLLABLE KYAELT) */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{'\xec', '\xbb', '\x96'}, 3, 0xCED6}, /* (HANGUL SYLLABLE KYAELP) */
    {{'\xec', '\xbb', '\x97'}, 3, 0xCED7}, /* (HANGUL SYLLABLE KYAELH) */
    {{'\xec', '\xbb', '\x98'}, 3, 0xCED8}, /* (HANGUL SYLLABLE KYAEM) */
    {{'\xec', '\xbb', '\x99'}, 3, 0xCED9}, /* (HANGUL SYLLABLE KYAEB) */
    {{'\xec', '\xbb', '\x9a'}, 3, 0xCEDA}, /* (HANGUL SYLLABLE KYAEBS) */
    {{'\xec', '\xbb', '\x9b'}, 3, 0xCEDB}, /* (HANGUL SYLLABLE KYAES) */
    {{'\xec', '\xbb', '\x9c'}, 3, 0xCEDC}, /* (HANGUL SYLLABLE KYAESS) */
    {{'\xec', '\xbb', '\x9d'}, 3, 0xCEDD}, /* (HANGUL SYLLABLE KYAENG) */
    {{'\xec', '\xbb', '\x9e'}, 3, 0xCEDE}, /* (HANGUL SYLLABLE KYAEJ) */
    {{'\xec', '\xbb', '\x9f'}, 3, 0xCEDF}, /* (HANGUL SYLLABLE KYAEC) */
    {{'\xec', '\xbb', '\xa0'}, 3, 0xCEE0}, /* (HANGUL SYLLABLE KYAEK) */
    {{'\xec', '\xbb', '\xa1'}, 3, 0xCEE1}, /* (HANGUL SYLLABLE KYAET) */
    {{'\xec', '\xbb', '\xa2'}, 3, 0xCEE2}, /* (HANGUL SYLLABLE KYAEP) */
    {{'\xec', '\xbb', '\xa3'}, 3, 0xCEE3}, /* (HANGUL SYLLABLE KYAEH) */
    {{'\xec', '\xbb', '\xa6'}, 3, 0xCEE6}, /* (HANGUL SYLLABLE KEOGG) */
    {{'\xec', '\xbb', '\xa7'}, 3, 0xCEE7}, /* (HANGUL SYLLABLE KEOGS) */
    {{'\xec', '\xbb', '\xa9'}, 3, 0xCEE9}, /* (HANGUL SYLLABLE KEONJ) */
    {{'\xec', '\xbb', '\xaa'}, 3, 0xCEEA}, /* (HANGUL SYLLABLE KEONH) */
    {{'\xec', '\xbb', '\xad'}, 3, 0xCEED}, /* (HANGUL SYLLABLE KEOLG) */
    {{'\xec', '\xbb', '\xae'}, 3, 0xCEEE}, /* (HANGUL SYLLABLE KEOLM) */
    {{'\xec', '\xbb', '\xaf'}, 3, 0xCEEF}, /* (HANGUL SYLLABLE KEOLB) */
    {{'\xec', '\xbb', '\xb0'}, 3, 0xCEF0}, /* (HANGUL SYLLABLE KEOLS) */
    {{'\xec', '\xbb', '\xb1'}, 3, 0xCEF1}, /* (HANGUL SYLLABLE KEOLT) */
    {{'\xec', '\xbb', '\xb2'}, 3, 0xCEF2}, /* (HANGUL SYLLABLE KEOLP) */
    {{'\xec', '\xbb', '\xb3'}, 3, 0xCEF3}, /* (HANGUL SYLLABLE KEOLH) */
    {{'\xec', '\xbb', '\xb6'}, 3, 0xCEF6}, /* (HANGUL SYLLABLE KEOBS) */
    {{'\xec', '\xbb', '\xba'}, 3, 0xCEFA}, /* (HANGUL SYLLABLE KEOJ) */
    {{'\xec', '\xbb', '\xbb'}, 3, 0xCEFB}, /* (HANGUL SYLLABLE KEOC) */
    {{'\xec', '\xbb', '\xbc'}, 3, 0xCEFC}, /* (HANGUL SYLLABLE KEOK) */
    {{'\xec', '\xbb', '\xbd'}, 3, 0xCEFD}, /* (HANGUL SYLLABLE KEOT) */
    {{'\xec', '\xbb', '\xbe'}, 3, 0xCEFE}, /* (HANGUL SYLLABLE KEOP) */
    {{'\xec', '\xbb', '\xbf'}, 3, 0xCEFF}, /* (HANGUL SYLLABLE KEOH) */
    {{'\xea', '\xb0', '\x80'}, 3, 0xAC00}, /* (HANGUL SYLLABLE GA) */
    {{'\xea', '\xb0', '\x81'}, 3, 0xAC01}, /* (HANGUL SYLLABLE GAG) */
    {{'\xea', '\xb0', '\x84'}, 3, 0xAC04}, /* (HANGUL SYLLABLE GAN) */
    {{'\xea', '\xb0', '\x87'}, 3, 0xAC07}, /* (HANGUL SYLLABLE GAD) */
    {{'\xea', '\xb0', '\x88'}, 3, 0xAC08}, /* (HANGUL SYLLABLE GAL) */
    {{'\xea', '\xb0', '\x89'}, 3, 0xAC09}, /* (HANGUL SYLLABLE GALG) */
    {{'\xea', '\xb0', '\x8a'}, 3, 0xAC0A}, /* (HANGUL SYLLABLE GALM) */
    {{'\xea', '\xb0', '\x90'}, 3, 0xAC10}, /* (HANGUL SYLLABLE GAM) */
    {{'\xea', '\xb0', '\x91'}, 3, 0xAC11}, /* (HANGUL SYLLABLE GAB) */
    {{'\xea', '\xb0', '\x92'}, 3, 0xAC12}, /* (HANGUL SYLLABLE GABS) */
    {{'\xea', '\xb0', '\x93'}, 3, 0xAC13}, /* (HANGUL SYLLABLE GAS) */
    {{'\xea', '\xb0', '\x94'}, 3, 0xAC14}, /* (HANGUL SYLLABLE GASS) */
    {{'\xea', '\xb0', '\x95'}, 3, 0xAC15}, /* (HANGUL SYLLABLE GANG) */
    {{'\xea', '\xb0', '\x96'}, 3, 0xAC16}, /* (HANGUL SYLLABLE GAJ) */
    {{'\xea', '\xb0', '\x97'}, 3, 0xAC17}, /* (HANGUL SYLLABLE GAC) */
    {{'\xea', '\xb0', '\x99'}, 3, 0xAC19}, /* (HANGUL SYLLABLE GAT) */
    {{'\xea', '\xb0', '\x9a'}, 3, 0xAC1A}, /* (HANGUL SYLLABLE GAP) */
    {{'\xea', '\xb0', '\x9b'}, 3, 0xAC1B}, /* (HANGUL SYLLABLE GAH) */
    {{'\xea', '\xb0', '\x9c'}, 3, 0xAC1C}, /* (HANGUL SYLLABLE GAE) */
    {{'\xea', '\xb0', '\x9d'}, 3, 0xAC1D}, /* (HANGUL SYLLABLE GAEG) */
    {{'\xea', '\xb0', '\xa0'}, 3, 0xAC20}, /* (HANGUL SYLLABLE GAEN) */
    {{'\xea', '\xb0', '\xa4'}, 3, 0xAC24}, /* (HANGUL SYLLABLE GAEL) */
    {{'\xea', '\xb0', '\xac'}, 3, 0xAC2C}, /* (HANGUL SYLLABLE GAEM) */
    {{'\xea', '\xb0', '\xad'}, 3, 0xAC2D}, /* (HANGUL SYLLABLE GAEB) */
    {{'\xea', '\xb0', '\xaf'}, 3, 0xAC2F}, /* (HANGUL SYLLABLE GAES) */
    {{'\xea', '\xb0', '\xb0'}, 3, 0xAC30}, /* (HANGUL SYLLABLE GAESS) */
    {{'\xea', '\xb0', '\xb1'}, 3, 0xAC31}, /* (HANGUL SYLLABLE GAENG) */
    {{'\xea', '\xb0', '\xb8'}, 3, 0xAC38}, /* (HANGUL SYLLABLE GYA) */
    {{'\xea', '\xb0', '\xb9'}, 3, 0xAC39}, /* (HANGUL SYLLABLE GYAG) */
    {{'\xea', '\xb0', '\xbc'}, 3, 0xAC3C}, /* (HANGUL SYLLABLE GYAN) */
    {{'\xea', '\xb1', '\x80'}, 3, 0xAC40}, /* (HANGUL SYLLABLE GYAL) */
    {{'\xea', '\xb1', '\x8b'}, 3, 0xAC4B}, /* (HANGUL SYLLABLE GYAS) */
    {{'\xea', '\xb1', '\x8d'}, 3, 0xAC4D}, /* (HANGUL SYLLABLE GYANG) */
    {{'\xea', '\xb1', '\x94'}, 3, 0xAC54}, /* (HANGUL SYLLABLE GYAE) */
    {{'\xea', '\xb1', '\x98'}, 3, 0xAC58}, /* (HANGUL SYLLABLE GYAEN) */
    {{'\xea', '\xb1', '\x9c'}, 3, 0xAC5C}, /* (HANGUL SYLLABLE GYAEL) */
    {{'\xea', '\xb1', '\xb0'}, 3, 0xAC70}, /* (HANGUL SYLLABLE GEO) */
    {{'\xea', '\xb1', '\xb1'}, 3, 0xAC71}, /* (HANGUL SYLLABLE GEOG) */
    {{'\xea', '\xb1', '\xb4'}, 3, 0xAC74}, /* (HANGUL SYLLABLE GEON) */
    {{'\xea', '\xb1', '\xb7'}, 3, 0xAC77}, /* (HANGUL SYLLABLE GEOD) */
    {{'\xea', '\xb1', '\xb8'}, 3, 0xAC78}, /* (HANGUL SYLLABLE GEOL) */
    {{'\xea', '\xb1', '\xba'}, 3, 0xAC7A}, /* (HANGUL SYLLABLE GEOLM) */
    {{'\xea', '\xb2', '\x80'}, 3, 0xAC80}, /* (HANGUL SYLLABLE GEOM) */
    {{'\xea', '\xb2', '\x81'}, 3, 0xAC81}, /* (HANGUL SYLLABLE GEOB) */
    {{'\xea', '\xb2', '\x83'}, 3, 0xAC83}, /* (HANGUL SYLLABLE GEOS) */
    {{'\xea', '\xb2', '\x84'}, 3, 0xAC84}, /* (HANGUL SYLLABLE GEOSS) */
    {{'\xea', '\xb2', '\x85'}, 3, 0xAC85}, /* (HANGUL SYLLABLE GEONG) */
    {{'\xea', '\xb2', '\x86'}, 3, 0xAC86}, /* (HANGUL SYLLABLE GEOJ) */
    {{'\xea', '\xb2', '\x89'}, 3, 0xAC89}, /* (HANGUL SYLLABLE GEOT) */
    {{'\xea', '\xb2', '\x8a'}, 3, 0xAC8A}, /* (HANGUL SYLLABLE GEOP) */
    {{'\xea', '\xb2', '\x8b'}, 3, 0xAC8B}, /* (HANGUL SYLLABLE GEOH) */
    {{'\xea', '\xb2', '\x8c'}, 3, 0xAC8C}, /* (HANGUL SYLLABLE GE) */
    {{'\xea', '\xb2', '\x90'}, 3, 0xAC90}, /* (HANGUL SYLLABLE GEN) */
    {{'\xea', '\xb2', '\x94'}, 3, 0xAC94}, /* (HANGUL SYLLABLE GEL) */
    {{'\xea', '\xb2', '\x9c'}, 3, 0xAC9C}, /* (HANGUL SYLLABLE GEM) */
    {{'\xea', '\xb2', '\x9d'}, 3, 0xAC9D}, /* (HANGUL SYLLABLE GEB) */
    {{'\xea', '\xb2', '\x9f'}, 3, 0xAC9F}, /* (HANGUL SYLLABLE GES) */
    {{'\xea', '\xb2', '\xa0'}, 3, 0xACA0}, /* (HANGUL SYLLABLE GESS) */
    {{'\xea', '\xb2', '\xa1'}, 3, 0xACA1}, /* (HANGUL SYLLABLE GENG) */
    {{'\xea', '\xb2', '\xa8'}, 3, 0xACA8}, /* (HANGUL SYLLABLE GYEO) */
    {{'\xea', '\xb2', '\xa9'}, 3, 0xACA9}, /* (HANGUL SYLLABLE GYEOG) */
    {{'\xea', '\xb2', '\xaa'}, 3, 0xACAA}, /* (HANGUL SYLLABLE GYEOGG) */
    {{'\xea', '\xb2', '\xac'}, 3, 0xACAC}, /* (HANGUL SYLLABLE GYEON) */
    {{'\xea', '\xb2', '\xaf'}, 3, 0xACAF}, /* (HANGUL SYLLABLE GYEOD) */
    {{'\xea', '\xb2', '\xb0'}, 3, 0xACB0}, /* (HANGUL SYLLABLE GYEOL) */
    {{'\xea', '\xb2', '\xb8'}, 3, 0xACB8}, /* (HANGUL SYLLABLE GYEOM) */
    {{'\xea', '\xb2', '\xb9'}, 3, 0xACB9}, /* (HANGUL SYLLABLE GYEOB) */
    {{'\xea', '\xb2', '\xbb'}, 3, 0xACBB}, /* (HANGUL SYLLABLE GYEOS) */
    {{'\xea', '\xb2', '\xbc'}, 3, 0xACBC}, /* (HANGUL SYLLABLE GYEOSS) */
    {{'\xea', '\xb2', '\xbd'}, 3, 0xACBD}, /* (HANGUL SYLLABLE GYEONG) */
    {{'\xea', '\xb3', '\x81'}, 3, 0xACC1}, /* (HANGUL SYLLABLE GYEOT) */
    {{'\xea', '\xb3', '\x84'}, 3, 0xACC4}, /* (HANGUL SYLLABLE GYE) */
    {{'\xea', '\xb3', '\x88'}, 3, 0xACC8}, /* (HANGUL SYLLABLE GYEN) */
    {{'\xea', '\xb3', '\x8c'}, 3, 0xACCC}, /* (HANGUL SYLLABLE GYEL) */
    {{'\xea', '\xb3', '\x95'}, 3, 0xACD5}, /* (HANGUL SYLLABLE GYEB) */
    {{'\xea', '\xb3', '\x97'}, 3, 0xACD7}, /* (HANGUL SYLLABLE GYES) */
    {{'\xea', '\xb3', '\xa0'}, 3, 0xACE0}, /* (HANGUL SYLLABLE GO) */
    {{'\xea', '\xb3', '\xa1'}, 3, 0xACE1}, /* (HANGUL SYLLABLE GOG) */
    {{'\xea', '\xb3', '\xa4'}, 3, 0xACE4}, /* (HANGUL SYLLABLE GON) */
    {{'\xea', '\xb3', '\xa7'}, 3, 0xACE7}, /* (HANGUL SYLLABLE GOD) */
    {{'\xea', '\xb3', '\xa8'}, 3, 0xACE8}, /* (HANGUL SYLLABLE GOL) */
    {{'\xea', '\xb3', '\xaa'}, 3, 0xACEA}, /* (HANGUL SYLLABLE GOLM) */
    {{'\xea', '\xb3', '\xac'}, 3, 0xACEC}, /* (HANGUL SYLLABLE GOLS) */
    {{'\xea', '\xb3', '\xaf'}, 3, 0xACEF}, /* (HANGUL SYLLABLE GOLH) */
    {{'\xea', '\xb3', '\xb0'}, 3, 0xACF0}, /* (HANGUL SYLLABLE GOM) */
    {{'\xea', '\xb3', '\xb1'}, 3, 0xACF1}, /* (HANGUL SYLLABLE GOB) */
    {{'\xea', '\xb3', '\xb3'}, 3, 0xACF3}, /* (HANGUL SYLLABLE GOS) */
    {{'\xea', '\xb3', '\xb5'}, 3, 0xACF5}, /* (HANGUL SYLLABLE GONG) */
    {{'\xea', '\xb3', '\xb6'}, 3, 0xACF6}, /* (HANGUL SYLLABLE GOJ) */
    {{'\xea', '\xb3', '\xbc'}, 3, 0xACFC}, /* (HANGUL SYLLABLE GWA) */
    {{'\xea', '\xb3', '\xbd'}, 3, 0xACFD}, /* (HANGUL SYLLABLE GWAG) */
    {{'\xea', '\xb4', '\x80'}, 3, 0xAD00}, /* (HANGUL SYLLABLE GWAN) */
    {{'\xea', '\xb4', '\x84'}, 3, 0xAD04}, /* (HANGUL SYLLABLE GWAL) */
    {{'\xea', '\xb4', '\x86'}, 3, 0xAD06}, /* (HANGUL SYLLABLE GWALM) */
    {{'\xec', '\xbc', '\x82'}, 3, 0xCF02}, /* (HANGUL SYLLABLE KEGG) */
    {{'\xec', '\xbc', '\x83'}, 3, 0xCF03}, /* (HANGUL SYLLABLE KEGS) */
    {{'\xec', '\xbc', '\x85'}, 3, 0xCF05}, /* (HANGUL SYLLABLE KENJ) */
    {{'\xec', '\xbc', '\x86'}, 3, 0xCF06}, /* (HANGUL SYLLABLE KENH) */
    {{'\xec', '\xbc', '\x87'}, 3, 0xCF07}, /* (HANGUL SYLLABLE KED) */
    {{'\xec', '\xbc', '\x89'}, 3, 0xCF09}, /* (HANGUL SYLLABLE KELG) */
    {{'\xec', '\xbc', '\x8a'}, 3, 0xCF0A}, /* (HANGUL SYLLABLE KELM) */
    {{'\xec', '\xbc', '\x8b'}, 3, 0xCF0B}, /* (HANGUL SYLLABLE KELB) */
    {{'\xec', '\xbc', '\x8c'}, 3, 0xCF0C}, /* (HANGUL SYLLABLE KELS) */
    {{'\xec', '\xbc', '\x8d'}, 3, 0xCF0D}, /* (HANGUL SYLLABLE KELT) */
    {{'\xec', '\xbc', '\x8e'}, 3, 0xCF0E}, /* (HANGUL SYLLABLE KELP) */
    {{'\xec', '\xbc', '\x8f'}, 3, 0xCF0F}, /* (HANGUL SYLLABLE KELH) */
    {{'\xec', '\xbc', '\x92'}, 3, 0xCF12}, /* (HANGUL SYLLABLE KEBS) */
    {{'\xec', '\xbc', '\x94'}, 3, 0xCF14}, /* (HANGUL SYLLABLE KESS) */
    {{'\xec', '\xbc', '\x96'}, 3, 0xCF16}, /* (HANGUL SYLLABLE KEJ) */
    {{'\xec', '\xbc', '\x97'}, 3, 0xCF17}, /* (HANGUL SYLLABLE KEC) */
    {{'\xec', '\xbc', '\x98'}, 3, 0xCF18}, /* (HANGUL SYLLABLE KEK) */
    {{'\xec', '\xbc', '\x99'}, 3, 0xCF19}, /* (HANGUL SYLLABLE KET) */
    {{'\xec', '\xbc', '\x9a'}, 3, 0xCF1A}, /* (HANGUL SYLLABLE KEP) */
    {{'\xec', '\xbc', '\x9b'}, 3, 0xCF1B}, /* (HANGUL SYLLABLE KEH) */
    {{'\xec', '\xbc', '\x9d'}, 3, 0xCF1D}, /* (HANGUL SYLLABLE KYEOG) */
    {{'\xec', '\xbc', '\x9e'}, 3, 0xCF1E}, /* (HANGUL SYLLABLE KYEOGG) */
    {{'\xec', '\xbc', '\x9f'}, 3, 0xCF1F}, /* (HANGUL SYLLABLE KYEOGS) */
    {{'\xec', '\xbc', '\xa1'}, 3, 0xCF21}, /* (HANGUL SYLLABLE KYEONJ) */
    {{'\xec', '\xbc', '\xa2'}, 3, 0xCF22}, /* (HANGUL SYLLABLE KYEONH) */
    {{'\xec', '\xbc', '\xa3'}, 3, 0xCF23}, /* (HANGUL SYLLABLE KYEOD) */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{'\xec', '\xbc', '\xa5'}, 3, 0xCF25}, /* (HANGUL SYLLABLE KYEOLG) */
    {{'\xec', '\xbc', '\xa6'}, 3, 0xCF26}, /* (HANGUL SYLLABLE KYEOLM) */
    {{'\xec', '\xbc', '\xa7'}, 3, 0xCF27}, /* (HANGUL SYLLABLE KYEOLB) */
    {{'\xec', '\xbc', '\xa8'}, 3, 0xCF28}, /* (HANGUL SYLLABLE KYEOLS) */
    {{'\xec', '\xbc', '\xa9'}, 3, 0xCF29}, /* (HANGUL SYLLABLE KYEOLT) */
    {{'\xec', '\xbc', '\xaa'}, 3, 0xCF2A}, /* (HANGUL SYLLABLE KYEOLP) */
    {{'\xec', '\xbc', '\xab'}, 3, 0xCF2B}, /* (HANGUL SYLLABLE KYEOLH) */
    {{'\xec', '\xbc', '\xae'}, 3, 0xCF2E}, /* (HANGUL SYLLABLE KYEOBS) */
    {{'\xec', '\xbc', '\xb2'}, 3, 0xCF32}, /* (HANGUL SYLLABLE KYEOJ) */
    {{'\xec', '\xbc', '\xb3'}, 3, 0xCF33}, /* (HANGUL SYLLABLE KYEOC) */
    {{'\xec', '\xbc', '\xb4'}, 3, 0xCF34}, /* (HANGUL SYLLABLE KYEOK) */
    {{'\xec', '\xbc', '\xb5'}, 3, 0xCF35}, /* (HANGUL SYLLABLE KYEOT) */
    {{'\xec', '\xbc', '\xb6'}, 3, 0xCF36}, /* (HANGUL SYLLABLE KYEOP) */
    {{'\xec', '\xbc', '\xb7'}, 3, 0xCF37}, /* (HANGUL SYLLABLE KYEOH) */
    {{'\xec', '\xbc', '\xb9'}, 3, 0xCF39}, /* (HANGUL SYLLABLE KYEG) */
    {{'\xec', '\xbc', '\xba'}, 3, 0xCF3A}, /* (HANGUL SYLLABLE KYEGG) */
    {{'\xec', '\xbc', '\xbb'}, 3, 0xCF3B}, /* (HANGUL SYLLABLE KYEGS) */
    {{'\xec', '\xbc', '\xbc'}, 3, 0xCF3C}, /* (HANGUL SYLLABLE KYEN) */
    {{'\xec', '\xbc', '\xbd'}, 3, 0xCF3D}, /* (HANGUL SYLLABLE KYENJ) */
    {{'\xec', '\xbc', '\xbe'}, 3, 0xCF3E}, /* (HANGUL SYLLABLE KYENH) */
    {{'\xec', '\xbc', '\xbf'}, 3, 0xCF3F}, /* (HANGUL SYLLABLE KYED) */
    {{'\xec', '\xbd', '\x80'}, 3, 0xCF40}, /* (HANGUL SYLLABLE KYEL) */
    {{'\xec', '\xbd', '\x81'}, 3, 0xCF41}, /* (HANGUL SYLLABLE KYELG) */
    {{'\xec', '\xbd', '\x82'}, 3, 0xCF42}, /* (HANGUL SYLLABLE KYELM) */
    {{'\xec', '\xbd', '\x83'}, 3, 0xCF43}, /* (HANGUL SYLLABLE KYELB) */
    {{'\xec', '\xbd', '\x84'}, 3, 0xCF44}, /* (HANGUL SYLLABLE KYELS) */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{'\xec', '\xbd', '\x85'}, 3, 0xCF45}, /* (HANGUL SYLLABLE KYELT) */
    {{'\xec', '\xbd', '\x86'}, 3, 0xCF46}, /* (HANGUL SYLLABLE KYELP) */
    {{'\xec', '\xbd', '\x87'}, 3, 0xCF47}, /* (HANGUL SYLLABLE KYELH) */
    {{'\xec', '\xbd', '\x88'}, 3, 0xCF48}, /* (HANGUL SYLLABLE KYEM) */
    {{'\xec', '\xbd', '\x89'}, 3, 0xCF49}, /* (HANGUL SYLLABLE KYEB) */
    {{'\xec', '\xbd', '\x8a'}, 3, 0xCF4A}, /* (HANGUL SYLLABLE KYEBS) */
    {{'\xec', '\xbd', '\x8b'}, 3, 0xCF4B}, /* (HANGUL SYLLABLE KYES) */
    {{'\xec', '\xbd', '\x8c'}, 3, 0xCF4C}, /* (HANGUL SYLLABLE KYESS) */
    {{'\xec', '\xbd', '\x8d'}, 3, 0xCF4D}, /* (HANGUL SYLLABLE KYENG) */
    {{'\xec', '\xbd', '\x8e'}, 3, 0xCF4E}, /* (HANGUL SYLLABLE KYEJ) */
    {{'\xec', '\xbd', '\x8f'}, 3, 0xCF4F}, /* (HANGUL SYLLABLE KYEC) */
    {{'\xec', '\xbd', '\x90'}, 3, 0xCF50}, /* (HANGUL SYLLABLE KYEK) */
    {{'\xec', '\xbd', '\x91'}, 3, 0xCF51}, /* (HANGUL SYLLABLE KYET) */
    {{'\xec', '\xbd', '\x92'}, 3, 0xCF52}, /* (HANGUL SYLLABLE KYEP) */
    {{'\xec', '\xbd', '\x93'}, 3, 0xCF53}, /* (HANGUL SYLLABLE KYEH) */
    {{'\xec', '\xbd', '\x96'}, 3, 0xCF56}, /* (HANGUL SYLLABLE KOGG) */
    {{'\xec', '\xbd', '\x97'}, 3, 0xCF57}, /* (HANGUL SYLLABLE KOGS) */
    {{'\xec', '\xbd', '\x99'}, 3, 0xCF59}, /* (HANGUL SYLLABLE KONJ) */
    {{'\xec', '\xbd', '\x9a'}, 3, 0xCF5A}, /* (HANGUL SYLLABLE KONH) */
    {{'\xec', '\xbd', '\x9b'}, 3, 0xCF5B}, /* (HANGUL SYLLABLE KOD) */
    {{'\xec', '\xbd', '\x9d'}, 3, 0xCF5D}, /* (HANGUL SYLLABLE KOLG) */
    {{'\xec', '\xbd', '\x9e'}, 3, 0xCF5E}, /* (HANGUL SYLLABLE KOLM) */
    {{'\xec', '\xbd', '\x9f'}, 3, 0xCF5F}, /* (HANGUL SYLLABLE KOLB) */
    {{'\xec', '\xbd', '\xa0'}, 3, 0xCF60}, /* (HANGUL SYLLABLE KOLS) */
    {{'\xec', '\xbd', '\xa1'}, 3, 0xCF61}, /* (HANGUL SYLLABLE KOLT) */
    {{'\xec', '\xbd', '\xa2'}, 3, 0xCF62}, /* (HANGUL SYLLABLE KOLP) */
    {{'\xec', '\xbd', '\xa3'}, 3, 0xCF63}, /* (HANGUL SYLLABLE KOLH) */
    {{'\xec', '\xbd', '\xa6'}, 3, 0xCF66}, /* (HANGUL SYLLABLE KOBS) */
    {{'\xec', '\xbd', '\xa8'}, 3, 0xCF68}, /* (HANGUL SYLLABLE KOSS) */
    {{'\xec', '\xbd', '\xaa'}, 3, 0xCF6A}, /* (HANGUL SYLLABLE KOJ) */
    {{'\xec', '\xbd', '\xab'}, 3, 0xCF6B}, /* (HANGUL SYLLABLE KOC) */
    {{'\xec', '\xbd', '\xac'}, 3, 0xCF6C}, /* (HANGUL SYLLABLE KOK) */
    {{'\xea', '\xb4', '\x8c'}, 3, 0xAD0C}, /* (HANGUL SYLLABLE GWAM) */
    {{'\xea', '\xb4', '\x8d'}, 3, 0xAD0D}, /* (HANGUL SYLLABLE GWAB) */
    {{'\xea', '\xb4', '\x8f'}, 3, 0xAD0F}, /* (HANGUL SYLLABLE GWAS) */
    {{'\xea', '\xb4', '\x91'}, 3, 0xAD11}, /* (HANGUL SYLLABLE GWANG) */
    {{'\xea', '\xb4', '\x98'}, 3, 0xAD18}, /* (HANGUL SYLLABLE GWAE) */
    {{'\xea', '\xb4', '\x9c'}, 3, 0xAD1C}, /* (HANGUL SYLLABLE GWAEN) */
    {{'\xea', '\xb4', '\xa0'}, 3, 0xAD20}, /* (HANGUL SYLLABLE GWAEL) */
    {{'\xea', '\xb4', '\xa9'}, 3, 0xAD29}, /* (HANGUL SYLLABLE GWAEB) */
    {{'\xea', '\xb4', '\xac'}, 3, 0xAD2C}, /* (HANGUL SYLLABLE GWAESS) */
    {{'\xea', '\xb4', '\xad'}, 3, 0xAD2D}, /* (HANGUL SYLLABLE GWAENG) */
    {{'\xea', '\xb4', '\xb4'}, 3, 0xAD34}, /* (HANGUL SYLLABLE GOE) */
    {{'\xea', '\xb4', '\xb5'}, 3, 0xAD35}, /* (HANGUL SYLLABLE GOEG) */
    {{'\xea', '\xb4', '\xb8'}, 3, 0xAD38}, /* (HANGUL SYLLABLE GOEN) */
    {{'\xea', '\xb4', '\xbc'}, 3, 0xAD3C}, /* (HANGUL SYLLABLE GOEL) */
    {{'\xea', '\xb5', '\x84'}, 3, 0xAD44}, /* (HANGUL SYLLABLE GOEM) */
    {{'\xea', '\xb5', '\x85'}, 3, 0xAD45}, /* (HANGUL SYLLABLE GOEB) */
    {{'\xea', '\xb5', '\x87'}, 3, 0xAD47}, /* (HANGUL SYLLABLE GOES) */
    {{'\xea', '\xb5', '\x89'}, 3, 0xAD49}, /* (HANGUL SYLLABLE GOENG) */
    {{'\xea', '\xb5', '\x90'}, 3, 0xAD50}, /* (HANGUL SYLLABLE GYO) */
    {{'\xea', '\xb5', '\x94'}, 3, 0xAD54}, /* (HANGUL SYLLABLE GYON) */
    {{'\xea', '\xb5', '\x98'}, 3, 0xAD58}, /* (HANGUL SYLLABLE GYOL) */
    {{'\xea', '\xb5', '\xa1'}, 3, 0xAD61}, /* (HANGUL SYLLABLE GYOB) */
    {{'\xea', '\xb5', '\xa3'}, 3, 0xAD63}, /* (HANGUL SYLLABLE GYOS) */
    {{'\xea', '\xb5', '\xac'}, 3, 0xAD6C}, /* (HANGUL SYLLABLE GU) */
    {{'\xea', '\xb5', '\xad'}, 3, 0xAD6D}, /* (HANGUL SYLLABLE GUG) */
    {{'\xea', '\xb5', '\xb0'}, 3, 0xAD70}, /* (HANGUL SYLLABLE GUN) */
    {{'\xea', '\xb5', '\xb3'}, 3, 0xAD73}, /* (HANGUL SYLLABLE GUD) */
    {{'\xea', '\xb5', '\xb4'}, 3, 0xAD74}, /* (HANGUL SYLLABLE GUL) */
    {{'\xea', '\xb5', '\xb5'}, 3, 0xAD75}, /* (HANGUL SYLLABLE GULG) */
    {{'\xea', '\xb5', '\xb6'}, 3, 0xAD76}, /* (HANGUL SYLLABLE GULM) */
    {{'\xea', '\xb5', '\xbb'}, 3, 0xAD7B}, /* (HANGUL SYLLABLE GULH) */
    {{'\xea', '\xb5', '\xbc'}, 3, 0xAD7C}, /* (HANGUL SYLLABLE GUM) */
    {{'\xea', '\xb5', '\xbd'}, 3, 0xAD7D}, /* (HANGUL SYLLABLE GUB) */
    {{'\xea', '\xb5', '\xbf'}, 3, 0xAD7F}, /* (HANGUL SYLLABLE GUS) */
    {{'\xea', '\xb6', '\x81'}, 3, 0xAD81}, /* (HANGUL SYLLABLE GUNG) */
    {{'\xea', '\xb6', '\x82'}, 3, 0xAD82}, /* (HANGUL SYLLABLE GUJ) */
    {{'\xea', '\xb6', '\x88'}, 3, 0xAD88}, /* (HANGUL SYLLABLE GWEO) */
    {{'\xea', '\xb6', '\x89'}, 3, 0xAD89}, /* (HANGUL SYLLABLE GWEOG) */
    {{'\xea', '\xb6', '\x8c'}, 3, 0xAD8C}, /* (HANGUL SYLLABLE GWEON) */
    {{'\xea', '\xb6', '\x90'}, 3, 0xAD90}, /* (HANGUL SYLLABLE GWEOL) */
    {{'\xea', '\xb6', '\x9c'}, 3, 0xAD9C}, /* (HANGUL SYLLABLE GWEOSS) */
    {{'\xea', '\xb6', '\x9d'}, 3, 0xAD9D}, /* (HANGUL SYLLABLE GWEONG) */
    {{'\xea', '\xb6', '\xa4'}, 3, 0xADA4}, /* (HANGUL SYLLABLE GWE) */
    {{'\xea', '\xb6', '\xb7'}, 3, 0xADB7}, /* (HANGUL SYLLABLE GWES) */
    {{'\xea', '\xb7', '\x80'}, 3, 0xADC0}, /* (HANGUL SYLLABLE GWI) */
    {{'\xea', '\xb7', '\x81'}, 3, 0xADC1}, /* (HANGUL SYLLABLE GWIG) */
    {{'\xea', '\xb7', '\x84'}, 3, 0xADC4}, /* (HANGUL SYLLABLE GWIN) */
    {{'\xea', '\xb7', '\x88'}, 3, 0xADC8}, /* (HANGUL SYLLABLE GWIL) */
    {{'\xea', '\xb7', '\x90'}, 3, 0xADD0}, /* (HANGUL SYLLABLE GWIM) */
    {{'\xea', '\xb7', '\x91'}, 3, 0xADD1}, /* (HANGUL SYLLABLE GWIB) */
    {{'\xea', '\xb7', '\x93'}, 3, 0xADD3}, /* (HANGUL SYLLABLE GWIS) */
    {{'\xea', '\xb7', '\x9c'}, 3, 0xADDC}, /* (HANGUL SYLLABLE GYU) */
    {{'\xea', '\xb7', '\xa0'}, 3, 0xADE0}, /* (HANGUL SYLLABLE GYUN) */
    {{'\xea', '\xb7', '\xa4'}, 3, 0xADE4}, /* (HANGUL SYLLABLE GYUL) */
    {{'\xea', '\xb7', '\xb8'}, 3, 0xADF8}, /* (HANGUL SYLLABLE GEU) */
    {{'\xea', '\xb7', '\xb9'}, 3, 0xADF9}, /* (HANGUL SYLLABLE GEUG) */
    {{'\xea', '\xb7', '\xbc'}, 3, 0xADFC}, /* (HANGUL SYLLABLE GEUN) */
    {{'\xea', '\xb7', '\xbf'}, 3, 0xADFF}, /* (HANGUL SYLLABLE GEUD) */
    {{'\xea', '\xb8', '\x80'}, 3, 0xAE00}, /* (HANGUL SYLLABLE GEUL) */
    {{'\xea', '\xb8', '\x81'}, 3, 0xAE01}, /* (HANGUL SYLLABLE GEULG) */
    {{'\xea', '\xb8', '\x88'}, 3, 0xAE08}, /* (HANGUL SYLLABLE GEUM) */
    {{'\xea', '\xb8', '\x89'}, 3, 0xAE09}, /* (HANGUL SYLLABLE GEUB) */
    {{'\xea', '\xb8', '\x8b'}, 3, 0xAE0B}, /* (HANGUL SYLLABLE GEUS) */
    {{'\xea', '\xb8', '\x8d'}, 3, 0xAE0D}, /* (HANGUL SYLLABLE GEUNG) */
    {{'\xea', '\xb8', '\x94'}, 3, 0xAE14}, /* (HANGUL SYLLABLE GYI) */
    {{'\xea', '\xb8', '\xb0'}, 3, 0xAE30}, /* (HANGUL SYLLABLE GI) */
    {{'\xea', '\xb8', '\xb1'}, 3, 0xAE31}, /* (HANGUL SYLLABLE GIG) */
    {{'\xea', '\xb8', '\xb4'}, 3, 0xAE34}, /* (HANGUL SYLLABLE GIN) */
    {{'\xea', '\xb8', '\xb7'}, 3, 0xAE37}, /* (HANGUL SYLLABLE GID) */
    {{'\xea', '\xb8', '\xb8'}, 3, 0xAE38}, /* (HANGUL SYLLABLE GIL) */
    {{'\xea', '\xb8', '\xba'}, 3, 0xAE3A}, /* (HANGUL SYLLABLE GILM) */
    {{'\xea', '\xb9', '\x80'}, 3, 0xAE40}, /* (HANGUL SYLLABLE GIM) */
    {{'\xea', '\xb9', '\x81'}, 3, 0xAE41}, /* (HANGUL SYLLABLE GIB) */
    {{'\xea', '\xb9', '\x83'}, 3, 0xAE43}, /* (HANGUL SYLLABLE GIS) */
    {{'\xea', '\xb9', '\x85'}, 3, 0xAE45}, /* (HANGUL SYLLABLE GING) */
    {{'\xea', '\xb9', '\x86'}, 3, 0xAE46}, /* (HANGUL SYLLABLE GIJ) */
    {{'\xea', '\xb9', '\x8a'}, 3, 0xAE4A}, /* (HANGUL SYLLABLE GIP) */
    {{'\xea', '\xb9', '\x8c'}, 3, 0xAE4C}, /* (HANGUL SYLLABLE GGA) */
    {{'\xea', '\xb9', '\x8d'}, 3, 0xAE4D}, /* (HANGUL SYLLABLE GGAG) */
    {{'\xea', '\xb9', '\x8e'}, 3, 0xAE4E}, /* (HANGUL SYLLABLE GGAGG) */
    {{'\xea', '\xb9', '\x90'}, 3, 0xAE50}, /* (HANGUL SYLLABLE GGAN) */
    {{'\xea', '\xb9', '\x94'}, 3, 0xAE54}, /* (HANGUL SYLLABLE GGAL) */
    {{'\xea', '\xb9', '\x96'}, 3, 0xAE56}, /* (HANGUL SYLLABLE GGALM) */
    {{'\xea', '\xb9', '\x9c'}, 3, 0xAE5C}, /* (HANGUL SYLLABLE GGAM) */
    {{'\xea', '\xb9', '\x9d'}, 3, 0xAE5D}, /* (HANGUL SYLLABLE GGAB) */
    {{'\xea', '\xb9', '\x9f'}, 3, 0xAE5F}, /* (HANGUL SYLLABLE GGAS) */
    {{'\xea', '\xb9', '\xa0'}, 3, 0xAE60}, /* (HANGUL SYLLABLE GGASS) */
    {{'\xea', '\xb9', '\xa1'}, 3, 0xAE61}, /* (HANGUL SYLLABLE GGANG) */
    {{'\xea', '\xb9', '\xa5'}, 3, 0xAE65}, /* (HANGUL SYLLABLE GGAT) */
    {{'\xea', '\xb9', '\xa8'}, 3, 0xAE68}, /* (HANGUL SYLLABLE GGAE) */
    {{'\xea', '\xb9', '\xa9'}, 3, 0xAE69}, /* (HANGUL SYLLABLE GGAEG) */
    {{'\xea', '\xb9', '\xac'}, 3, 0xAE6C}, /* (HANGUL SYLLABLE GGAEN) */
    {{'\xea', '\xb9', '\xb0'}, 3, 0xAE70}, /* (HANGUL SYLLABLE GGAEL) */
    {{'\xea', '\xb9', '\xb8'}, 3, 0xAE78}, /* (HANGUL SYLLABLE GGAEM) */
    {{'\xec', '\xbd', '\xad'}, 3, 0xCF6D}, /* (HANGUL SYLLABLE KOT) */
    {{'\xec', '\xbd', '\xae'}, 3, 0xCF6E}, /* (HANGUL SYLLABLE KOP) */
    {{'\xec', '\xbd', '\xaf'}, 3, 0xCF6F}, /* (HANGUL SYLLABLE KOH) */
    {{'\xec', '\xbd', '\xb2'}, 3, 0xCF72}, /* (HANGUL SYLLABLE KWAGG) */
    {{'\xec', '\xbd', '\xb3'}, 3, 0xCF73}, /* (HANGUL SYLLABLE KWAGS) */
    {{'\xec', '\xbd', '\xb5'}, 3, 0xCF75}, /* (HANGUL SYLLABLE KWANJ) */
    {{'\xec', '\xbd', '\xb6'}, 3, 0xCF76}, /* (HANGUL SYLLABLE KWANH) */
    {{'\xec', '\xbd', '\xb7'}, 3, 0xCF77}, /* (HANGUL SYLLABLE KWAD) */
    {{'\xec', '\xbd', '\xb9'}, 3, 0xCF79}, /* (HANGUL SYLLABLE KWALG) */
    {{'\xec', '\xbd', '\xba'}, 3, 0xCF7A}, /* (HANGUL SYLLABLE KWALM) */
    {{'\xec', '\xbd', '\xbb'}, 3, 0xCF7B}, /* (HANGUL SYLLABLE KWALB) */
    {{'\xec', '\xbd', '\xbc'}, 3, 0xCF7C}, /* (HANGUL SYLLABLE KWALS) */
    {{'\xec', '\xbd', '\xbd'}, 3, 0xCF7D}, /* (HANGUL SYLLABLE KWALT) */
    {{'\xec', '\xbd', '\xbe'}, 3, 0xCF7E}, /* (HANGUL SYLLABLE KWALP) */
    {{'\xec', '\xbd', '\xbf'}, 3, 0xCF7F}, /* (HANGUL SYLLABLE KWALH) */
    {{'\xec', '\xbe', '\x81'}, 3, 0xCF81}, /* (HANGUL SYLLABLE KWAB) */
    {{'\xec', '\xbe', '\x82'}, 3, 0xCF82}, /* (HANGUL SYLLABLE KWABS) */
    {{'\xec', '\xbe', '\x83'}, 3, 0xCF83}, /* (HANGUL SYLLABLE KWAS) */
    {{'\xec', '\xbe', '\x84'}, 3, 0xCF84}, /* (HANGUL SYLLABLE KWASS) */
    {{'\xec', '\xbe', '\x86'}, 3, 0xCF86}, /* (HANGUL SYLLABLE KWAJ) */
    {{'\xec', '\xbe', '\x87'}, 3, 0xCF87}, /* (HANGUL SYLLABLE KWAC) */
    {{'\xec', '\xbe', '\x88'}, 3, 0xCF88}, /* (HANGUL SYLLABLE KWAK) */
    {{'\xec', '\xbe', '\x89'}, 3, 0xCF89}, /* (HANGUL SYLLABLE KWAT) */
    {{'\xec', '\xbe', '\x8a'}, 3, 0xCF8A}, /* (HANGUL SYLLABLE KWAP) */
    {{'\xec', '\xbe', '\x8b'}, 3, 0xCF8B}, /* (HANGUL SYLLABLE KWAH) */
    {{'\xec', '\xbe', '\x8d'}, 3, 0xCF8D}, /* (HANGUL SYLLABLE KWAEG) */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{'\xec', '\xbe', '\x8e'}, 3, 0xCF8E}, /* (HANGUL SYLLABLE KWAEGG) */
    {{'\xec', '\xbe', '\x8f'}, 3, 0xCF8F}, /* (HANGUL SYLLABLE KWAEGS) */
    {{'\xec', '\xbe', '\x90'}, 3, 0xCF90}, /* (HANGUL SYLLABLE KWAEN) */
    {{'\xec', '\xbe', '\x91'}, 3, 0xCF91}, /* (HANGUL SYLLABLE KWAENJ) */
    {{'\xec', '\xbe', '\x92'}, 3, 0xCF92}, /* (HANGUL SYLLABLE KWAENH) */
    {{'\xec', '\xbe', '\x93'}, 3, 0xCF93}, /* (HANGUL SYLLABLE KWAED) */
    {{'\xec', '\xbe', '\x94'}, 3, 0xCF94}, /* (HANGUL SYLLABLE KWAEL) */
    {{'\xec', '\xbe', '\x95'}, 3, 0xCF95}, /* (HANGUL SYLLABLE KWAELG) */
    {{'\xec', '\xbe', '\x96'}, 3, 0xCF96}, /* (HANGUL SYLLABLE KWAELM) */
    {{'\xec', '\xbe', '\x97'}, 3, 0xCF97}, /* (HANGUL SYLLABLE KWAELB) */
    {{'\xec', '\xbe', '\x98'}, 3, 0xCF98}, /* (HANGUL SYLLABLE KWAELS) */
    {{'\xec', '\xbe', '\x99'}, 3, 0xCF99}, /* (HANGUL SYLLABLE KWAELT) */
    {{'\xec', '\xbe', '\x9a'}, 3, 0xCF9A}, /* (HANGUL SYLLABLE KWAELP) */
    {{'\xec', '\xbe', '\x9b'}, 3, 0xCF9B}, /* (HANGUL SYLLABLE KWAELH) */
    {{'\xec', '\xbe', '\x9c'}, 3, 0xCF9C}, /* (HANGUL SYLLABLE KWAEM) */
    {{'\xec', '\xbe', '\x9d'}, 3, 0xCF9D}, /* (HANGUL SYLLABLE KWAEB) */
    {{'\xec', '\xbe', '\x9e'}, 3, 0xCF9E}, /* (HANGUL SYLLABLE KWAEBS) */
    {{'\xec', '\xbe', '\x9f'}, 3, 0xCF9F}, /* (HANGUL SYLLABLE KWAES) */
    {{'\xec', '\xbe', '\xa0'}, 3, 0xCFA0}, /* (HANGUL SYLLABLE KWAESS) */
    {{'\xec', '\xbe', '\xa2'}, 3, 0xCFA2}, /* (HANGUL SYLLABLE KWAEJ) */
    {{'\xec', '\xbe', '\xa3'}, 3, 0xCFA3}, /* (HANGUL SYLLABLE KWAEC) */
    {{'\xec', '\xbe', '\xa4'}, 3, 0xCFA4}, /* (HANGUL SYLLABLE KWAEK) */
    {{'\xec', '\xbe', '\xa5'}, 3, 0xCFA5}, /* (HANGUL SYLLABLE KWAET) */
    {{'\xec', '\xbe', '\xa6'}, 3, 0xCFA6}, /* (HANGUL SYLLABLE KWAEP) */
    {{'\xec', '\xbe', '\xa7'}, 3, 0xCFA7}, /* (HANGUL SYLLABLE KWAEH) */
    {{'\xec', '\xbe', '\xa9'}, 3, 0xCFA9}, /* (HANGUL SYLLABLE KOEG) */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{'\xec', '\xbe', '\xaa'}, 3, 0xCFAA}, /* (HANGUL SYLLABLE KOEGG) */
    {{'\xec', '\xbe', '\xab'}, 3, 0xCFAB}, /* (HANGUL SYLLABLE KOEGS) */
    {{'\xec', '\xbe', '\xac'}, 3, 0xCFAC}, /* (HANGUL SYLLABLE KOEN) */
    {{'\xec', '\xbe', '\xad'}, 3, 0xCFAD}, /* (HANGUL SYLLABLE KOENJ) */
    {{'\xec', '\xbe', '\xae'}, 3, 0xCFAE}, /* (HANGUL SYLLABLE KOENH) */
    {{'\xec', '\xbe', '\xaf'}, 3, 0xCFAF}, /* (HANGUL SYLLABLE KOED) */
    {{'\xec', '\xbe', '\xb1'}, 3, 0xCFB1}, /* (HANGUL SYLLABLE KOELG) */
    {{'\xec', '\xbe', '\xb2'}, 3, 0xCFB2}, /* (HANGUL SYLLABLE KOELM) */
    {{'\xec', '\xbe', '\xb3'}, 3, 0xCFB3}, /* (HANGUL SYLLABLE KOELB) */
    {{'\xec', '\xbe', '\xb4'}, 3, 0xCFB4}, /* (HANGUL SYLLABLE KOELS) */
    {{'\xec', '\xbe', '\xb5'}, 3, 0xCFB5}, /* (HANGUL SYLLABLE KOELT) */
    {{'\xec', '\xbe', '\xb6'}, 3, 0xCFB6}, /* (HANGUL SYLLABLE KOELP) */
    {{'\xec', '\xbe', '\xb7'}, 3, 0xCFB7}, /* (HANGUL SYLLABLE KOELH) */
    {{'\xec', '\xbe', '\xb8'}, 3, 0xCFB8}, /* (HANGUL SYLLABLE KOEM) */
    {{'\xec', '\xbe', '\xb9'}, 3, 0xCFB9}, /* (HANGUL SYLLABLE KOEB) */
    {{'\xec', '\xbe', '\xba'}, 3, 0xCFBA}, /* (HANGUL SYLLABLE KOEBS) */
    {{'\xec', '\xbe', '\xbb'}, 3, 0xCFBB}, /* (HANGUL SYLLABLE KOES) */
    {{'\xec', '\xbe', '\xbc'}, 3, 0xCFBC}, /* (HANGUL SYLLABLE KOESS) */
    {{'\xec', '\xbe', '\xbd'}, 3, 0xCFBD}, /* (HANGUL SYLLABLE KOENG) */
    {{'\xec', '\xbe', '\xbe'}, 3, 0xCFBE}, /* (HANGUL SYLLABLE KOEJ) */
    {{'\xec', '\xbe', '\xbf'}, 3, 0xCFBF}, /* (HANGUL SYLLABLE KOEC) */
    {{'\xec', '\xbf', '\x80'}, 3, 0xCFC0}, /* (HANGUL SYLLABLE KOEK) */
    {{'\xec', '\xbf', '\x81'}, 3, 0xCFC1}, /* (HANGUL SYLLABLE KOET) */
    {{'\xec', '\xbf', '\x82'}, 3, 0xCFC2}, /* (HANGUL SYLLABLE KOEP) */
    {{'\xec', '\xbf', '\x83'}, 3, 0xCFC3}, /* (HANGUL SYLLABLE KOEH) */
    {{'\xec', '\xbf', '\x85'}, 3, 0xCFC5}, /* (HANGUL SYLLABLE KYOG) */
    {{'\xec', '\xbf', '\x86'}, 3, 0xCFC6}, /* (HANGUL SYLLABLE KYOGG) */
    {{'\xec', '\xbf', '\x87'}, 3, 0xCFC7}, /* (HANGUL SYLLABLE KYOGS) */
    {{'\xec', '\xbf', '\x88'}, 3, 0xCFC8}, /* (HANGUL SYLLABLE KYON) */
    {{'\xec', '\xbf', '\x89'}, 3, 0xCFC9}, /* (HANGUL SYLLABLE KYONJ) */
    {{'\xec', '\xbf', '\x8a'}, 3, 0xCFCA}, /* (HANGUL SYLLABLE KYONH) */
    {{'\xec', '\xbf', '\x8b'}, 3, 0xCFCB}, /* (HANGUL SYLLABLE KYOD) */
    {{'\xea', '\xb9', '\xb9'}, 3, 0xAE79}, /* (HANGUL SYLLABLE GGAEB) */
    {{'\xea', '\xb9', '\xbb'}, 3, 0xAE7B}, /* (HANGUL SYLLABLE GGAES) */
    {{'\xea', '\xb9', '\xbc'}, 3, 0xAE7C}, /* (HANGUL SYLLABLE GGAESS) */
    {{'\xea', '\xb9', '\xbd'}, 3, 0xAE7D}, /* (HANGUL SYLLABLE GGAENG) */
    {{'\xea', '\xba', '\x84'}, 3, 0xAE84}, /* (HANGUL SYLLABLE GGYA) */
    {{'\xea', '\xba', '\x85'}, 3, 0xAE85}, /* (HANGUL SYLLABLE GGYAG) */
    {{'\xea', '\xba', '\x8c'}, 3, 0xAE8C}, /* (HANGUL SYLLABLE GGYAL) */
    {{'\xea', '\xba', '\xbc'}, 3, 0xAEBC}, /* (HANGUL SYLLABLE GGEO) */
    {{'\xea', '\xba', '\xbd'}, 3, 0xAEBD}, /* (HANGUL SYLLABLE GGEOG) */
    {{'\xea', '\xba', '\xbe'}, 3, 0xAEBE}, /* (HANGUL SYLLABLE GGEOGG) */
    {{'\xea', '\xbb', '\x80'}, 3, 0xAEC0}, /* (HANGUL SYLLABLE GGEON) */
    {{'\xea', '\xbb', '\x84'}, 3, 0xAEC4}, /* (HANGUL SYLLABLE GGEOL) */
    {{'\xea', '\xbb', '\x8c'}, 3, 0xAECC}, /* (HANGUL SYLLABLE GGEOM) */
    {{'\xea', '\xbb', '\x8d'}, 3, 0xAECD}, /* (HANGUL SYLLABLE GGEOB) */
    {{'\xea', '\xbb', '\x8f'}, 3, 0xAECF}, /* (HANGUL SYLLABLE GGEOS) */
    {{'\xea', '\xbb', '\x90'}, 3, 0xAED0}, /* (HANGUL SYLLABLE GGEOSS) */
    {{'\xea', '\xbb', '\x91'}, 3, 0xAED1}, /* (HANGUL SYLLABLE GGEONG) */
    {{'\xea', '\xbb', '\x98'}, 3, 0xAED8}, /* (HANGUL SYLLABLE GGE) */
    {{'\xea', '\xbb', '\x99'}, 3, 0xAED9}, /* (HANGUL SYLLABLE GGEG) */
    {{'\xea', '\xbb', '\x9c'}, 3, 0xAEDC}, /* (HANGUL SYLLABLE GGEN) */
    {{'\xea', '\xbb', '\xa8'}, 3, 0xAEE8}, /* (HANGUL SYLLABLE GGEM) */
    {{'\xea', '\xbb', '\xab'}, 3, 0xAEEB}, /* (HANGUL SYLLABLE GGES) */
    {{'\xea', '\xbb', '\xad'}, 3, 0xAEED}, /* (HANGUL SYLLABLE GGENG) */
    {{'\xea', '\xbb', '\xb4'}, 3, 0xAEF4}, /* (HANGUL SYLLABLE GGYEO) */
    {{'\xea', '\xbb', '\xb8'}, 3, 0xAEF8}, /* (HANGUL SYLLABLE GGYEON) */
    {{'\xea', '\xbb', '\xbc'}, 3, 0xAEFC}, /* (HANGUL SYLLABLE GGYEOL) */
    {{'\xea', '\xbc', '\x87'}, 3, 0xAF07}, /* (HANGUL SYLLABLE GGYEOS) */
    {{'\xea', '\xbc', '\x88'}, 3, 0xAF08}, /* (HANGUL SYLLABLE GGYEOSS) */
    {{'\xea', '\xbc', '\x8d'}, 3, 0xAF0D}, /* (HANGUL SYLLABLE GGYEOT) */
    {{'\xea', '\xbc', '\x90'}, 3, 0xAF10}, /* (HANGUL SYLLABLE GGYE) */
    {{'\xea', '\xbc', '\xac'}, 3, 0xAF2C}, /* (HANGUL SYLLABLE GGO) */
    {{'\xea', '\xbc', '\xad'}, 3, 0xAF2D}, /* (HANGUL SYLLABLE GGOG) */
    {{'\xea', '\xbc', '\xb0'}, 3, 0xAF30}, /* (HANGUL SYLLABLE GGON) */
    {{'\xea', '\xbc', '\xb2'}, 3, 0xAF32}, /* (HANGUL SYLLABLE GGONH) */
    {{'\xea', '\xbc', '\xb4'}, 3, 0xAF34}, /* (HANGUL SYLLABLE GGOL) */
    {{'\xea', '\xbc', '\xbc'}, 3, 0xAF3C}, /* (HANGUL SYLLABLE GGOM) */
    {{'\xea', '\xbc', '\xbd'}, 3, 0xAF3D}, /* (HANGUL SYLLABLE GGOB) */
    {{'\xea', '\xbc', '\xbf'}, 3, 0xAF3F}, /* (HANGUL SYLLABLE GGOS) */
    {{'\xea', '\xbd', '\x81'}, 3, 0xAF41}, /* (HANGUL SYLLABLE GGONG) */
    {{'\xea', '\xbd', '\x82'}, 3, 0xAF42}, /* (HANGUL SYLLABLE GGOJ) */
    {{'\xea', '\xbd', '\x83'}, 3, 0xAF43}, /* (HANGUL SYLLABLE GGOC) */
    {{'\xea', '\xbd', '\x88'}, 3, 0xAF48}, /* (HANGUL SYLLABLE GGWA) */
    {{'\xea', '\xbd', '\x89'}, 3, 0xAF49}, /* (HANGUL SYLLABLE GGWAG) */
    {{'\xea', '\xbd', '\x90'}, 3, 0xAF50}, /* (HANGUL SYLLABLE GGWAL) */
    {{'\xea', '\xbd', '\x9c'}, 3, 0xAF5C}, /* (HANGUL SYLLABLE GGWASS) */
    {{'\xea', '\xbd', '\x9d'}, 3, 0xAF5D}, /* (HANGUL SYLLABLE GGWANG) */
    {{'\xea', '\xbd', '\xa4'}, 3, 0xAF64}, /* (HANGUL SYLLABLE GGWAE) */
    {{'\xea', '\xbd', '\xa5'}, 3, 0xAF65}, /* (HANGUL SYLLABLE GGWAEG) */
    {{'\xea', '\xbd', '\xb9'}, 3, 0xAF79}, /* (HANGUL SYLLABLE GGWAENG) */
    {{'\xea', '\xbe', '\x80'}, 3, 0xAF80}, /* (HANGUL SYLLABLE GGOE) */
    {{'\xea', '\xbe', '\x84'}, 3, 0xAF84}, /* (HANGUL SYLLABLE GGOEN) */
    {{'\xea', '\xbe', '\x88'}, 3, 0xAF88}, /* (HANGUL SYLLABLE GGOEL) */
    {{'\xea', '\xbe', '\x90'}, 3, 0xAF90}, /* (HANGUL SYLLABLE GGOEM) */
    {{'\xea', '\xbe', '\x91'}, 3, 0xAF91}, /* (HANGUL SYLLABLE GGOEB) */
    {{'\xea', '\xbe', '\x95'}, 3, 0xAF95}, /* (HANGUL SYLLABLE GGOENG) */
    {{'\xea', '\xbe', '\x9c'}, 3, 0xAF9C}, /* (HANGUL SYLLABLE GGYO) */
    {{'\xea', '\xbe', '\xb8'}, 3, 0xAFB8}, /* (HANGUL SYLLABLE GGU) */
    {{'\xea', '\xbe', '\xb9'}, 3, 0xAFB9}, /* (HANGUL SYLLABLE GGUG) */
    {{'\xea', '\xbe', '\xbc'}, 3, 0xAFBC}, /* (HANGUL SYLLABLE GGUN) */
    {{'\xea', '\xbf', '\x80'}, 3, 0xAFC0}, /* (HANGUL SYLLABLE GGUL) */
    {{'\xea', '\xbf', '\x87'}, 3, 0xAFC7}, /* (HANGUL SYLLABLE GGULH) */
    {{'\xea', '\xbf', '\x88'}, 3, 0xAFC8}, /* (HANGUL SYLLABLE GGUM) */
    {{'\xea', '\xbf', '\x89'}, 3, 0xAFC9}, /* (HANGUL SYLLABLE GGUB) */
    {{'\xea', '\xbf', '\x8b'}, 3, 0xAFCB}, /* (HANGUL SYLLABLE GGUS) */
    {{'\xea', '\xbf', '\x8d'}, 3, 0xAFCD}, /* (HANGUL SYLLABLE GGUNG) */
    {{'\xea', '\xbf', '\x8e'}, 3, 0xAFCE}, /* (HANGUL SYLLABLE GGUJ) */
    {{'\xea', '\xbf', '\x94'}, 3, 0xAFD4}, /* (HANGUL SYLLABLE GGWEO) */
    {{'\xea', '\xbf', '\x9c'}, 3, 0xAFDC}, /* (HANGUL SYLLABLE GGWEOL) */
    {{'\xea', '\xbf', '\xa8'}, 3, 0xAFE8}, /* (HANGUL SYLLABLE GGWEOSS) */
    {{'\xea', '\xbf', '\xa9'}, 3, 0xAFE9}, /* (HANGUL SYLLABLE GGWEONG) */
    {{'\xea', '\xbf', '\xb0'}, 3, 0xAFF0}, /* (HANGUL SYLLABLE GGWE) */
    {{'\xea', '\xbf', '\xb1'}, 3, 0xAFF1}, /* (HANGUL SYLLABLE GGWEG) */
    {{'\xea', '\xbf', '\xb4'}, 3, 0xAFF4}, /* (HANGUL SYLLABLE GGWEN) */
    {{'\xea', '\xbf', '\xb8'}, 3, 0xAFF8}, /* (HANGUL SYLLABLE GGWEL) */
    {{'\xeb', '\x80', '\x80'}, 3, 0xB000}, /* (HANGUL SYLLABLE GGWEM) */
    {{'\xeb', '\x80', '\x81'}, 3, 0xB001}, /* (HANGUL SYLLABLE GGWEB) */
    {{'\xeb', '\x80', '\x84'}, 3, 0xB004}, /* (HANGUL SYLLABLE GGWESS) */
    {{'\xeb', '\x80', '\x8c'}, 3, 0xB00C}, /* (HANGUL SYLLABLE GGWI) */
    {{'\xeb', '\x80', '\x90'}, 3, 0xB010}, /* (HANGUL SYLLABLE GGWIN) */
    {{'\xeb', '\x80', '\x94'}, 3, 0xB014}, /* (HANGUL SYLLABLE GGWIL) */
    {{'\xeb', '\x80', '\x9c'}, 3, 0xB01C}, /* (HANGUL SYLLABLE GGWIM) */
    {{'\xeb', '\x80', '\x9d'}, 3, 0xB01D}, /* (HANGUL SYLLABLE GGWIB) */
    {{'\xeb', '\x80', '\xa8'}, 3, 0xB028}, /* (HANGUL SYLLABLE GGYU) */
    {{'\xeb', '\x81', '\x84'}, 3, 0xB044}, /* (HANGUL SYLLABLE GGEU) */
    {{'\xeb', '\x81', '\x85'}, 3, 0xB045}, /* (HANGUL SYLLABLE GGEUG) */
    {{'\xeb', '\x81', '\x88'}, 3, 0xB048}, /* (HANGUL SYLLABLE GGEUN) */
    {{'\xeb', '\x81', '\x8a'}, 3, 0xB04A}, /* (HANGUL SYLLABLE GGEUNH) */
    {{'\xeb', '\x81', '\x8c'}, 3, 0xB04C}, /* (HANGUL SYLLABLE GGEUL) */
    {{'\xeb', '\x81', '\x8e'}, 3, 0xB04E}, /* (HANGUL SYLLABLE GGEULM) */
    {{'\xeb', '\x81', '\x93'}, 3, 0xB053}, /* (HANGUL SYLLABLE GGEULH) */
    {{'\xeb', '\x81', '\x94'}, 3, 0xB054}, /* (HANGUL SYLLABLE GGEUM) */
    {{'\xeb', '\x81', '\x95'}, 3, 0xB055}, /* (HANGUL SYLLABLE GGEUB) */
    {{'\xeb', '\x81', '\x97'}, 3, 0xB057}, /* (HANGUL SYLLABLE GGEUS) */
    {{'\xeb', '\x81', '\x99'}, 3, 0xB059}, /* (HANGUL SYLLABLE GGEUNG) */
    {{'\xec', '\xbf', '\x8c'}, 3, 0xCFCC}, /* (HANGUL SYLLABLE KYOL) */
    {{'\xec', '\xbf', '\x8d'}, 3, 0xCFCD}, /* (HANGUL SYLLABLE KYOLG) */
    {{'\xec', '\xbf', '\x8e'}, 3, 0xCFCE}, /* (HANGUL SYLLABLE KYOLM) */
    {{'\xec', '\xbf', '\x8f'}, 3, 0xCFCF}, /* (HANGUL SYLLABLE KYOLB) */
    {{'\xec', '\xbf', '\x90'}, 3, 0xCFD0}, /* (HANGUL SYLLABLE KYOLS) */
    {{'\xec', '\xbf', '\x91'}, 3, 0xCFD1}, /* (HANGUL SYLLABLE KYOLT) */
    {{'\xec', '\xbf', '\x92'}, 3, 0xCFD2}, /* (HANGUL SYLLABLE KYOLP) */
    {{'\xec', '\xbf', '\x93'}, 3, 0xCFD3}, /* (HANGUL SYLLABLE KYOLH) */
    {{'\xec', '\xbf', '\x94'}, 3, 0xCFD4}, /* (HANGUL SYLLABLE KYOM) */
    {{'\xec', '\xbf', '\x95'}, 3, 0xCFD5}, /* (HANGUL SYLLABLE KYOB) */
    {{'\xec', '\xbf', '\x96'}, 3, 0xCFD6}, /* (HANGUL SYLLABLE KYOBS) */
    {{'\xec', '\xbf', '\x97'}, 3, 0xCFD7}, /* (HANGUL SYLLABLE KYOS) */
    {{'\xec', '\xbf', '\x98'}, 3, 0xCFD8}, /* (HANGUL SYLLABLE KYOSS) */
    {{'\xec', '\xbf', '\x99'}, 3, 0xCFD9}, /* (HANGUL SYLLABLE KYONG) */
    {{'\xec', '\xbf', '\x9a'}, 3, 0xCFDA}, /* (HANGUL SYLLABLE KYOJ) */
    {{'\xec', '\xbf', '\x9b'}, 3, 0xCFDB}, /* (HANGUL SYLLABLE KYOC) */
    {{'\xec', '\xbf', '\x9c'}, 3, 0xCFDC}, /* (HANGUL SYLLABLE KYOK) */
    {{'\xec', '\xbf', '\x9d'}, 3, 0xCFDD}, /* (HANGUL SYLLABLE KYOT) */
    {{'\xec', '\xbf', '\x9e'}, 3, 0xCFDE}, /* (HANGUL SYLLABLE KYOP) */
    {{'\xec', '\xbf', '\x9f'}, 3, 0xCFDF}, /* (HANGUL SYLLABLE KYOH) */
    {{'\xec', '\xbf', '\xa2'}, 3, 0xCFE2}, /* (HANGUL SYLLABLE KUGG) */
    {{'\xec', '\xbf', '\xa3'}, 3, 0xCFE3}, /* (HANGUL SYLLABLE KUGS) */
    {{'\xec', '\xbf', '\xa5'}, 3, 0xCFE5}, /* (HANGUL SYLLABLE KUNJ) */
    {{'\xec', '\xbf', '\xa6'}, 3, 0xCFE6}, /* (HANGUL SYLLABLE KUNH) */
    {{'\xec', '\xbf', '\xa7'}, 3, 0xCFE7}, /* (HANGUL SYLLABLE KUD) */
    {{'\xec', '\xbf', '\xa9'}, 3, 0xCFE9}, /* (HANGUL SYLLABLE KULG) */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{'\xec', '\xbf', '\xaa'}, 3, 0xCFEA}, /* (HANGUL SYLLABLE KULM) */
    {{'\xec', '\xbf', '\xab'}, 3, 0xCFEB}, /* (HANGUL SYLLABLE KULB) */
    {{'\xec', '\xbf', '\xac'}, 3, 0xCFEC}, /* (HANGUL SYLLABLE KULS) */
    {{'\xec', '\xbf', '\xad'}, 3, 0xCFED}, /* (HANGUL SYLLABLE KULT) */
    {{'\xec', '\xbf', '\xae'}, 3, 0xCFEE}, /* (HANGUL SYLLABLE KULP) */
    {{'\xec', '\xbf', '\xaf'}, 3, 0xCFEF}, /* (HANGUL SYLLABLE KULH) */
    {{'\xec', '\xbf', '\xb2'}, 3, 0xCFF2}, /* (HANGUL SYLLABLE KUBS) */
    {{'\xec', '\xbf', '\xb4'}, 3, 0xCFF4}, /* (HANGUL SYLLABLE KUSS) */
    {{'\xec', '\xbf', '\xb6'}, 3, 0xCFF6}, /* (HANGUL SYLLABLE KUJ) */
    {{'\xec', '\xbf', '\xb7'}, 3, 0xCFF7}, /* (HANGUL SYLLABLE KUC) */
    {{'\xec', '\xbf', '\xb8'}, 3, 0xCFF8}, /* (HANGUL SYLLABLE KUK) */
    {{'\xec', '\xbf', '\xb9'}, 3, 0xCFF9}, /* (HANGUL SYLLABLE KUT) */
    {{'\xec', '\xbf', '\xba'}, 3, 0xCFFA}, /* (HANGUL SYLLABLE KUP) */
    {{'\xec', '\xbf', '\xbb'}, 3, 0xCFFB}, /* (HANGUL SYLLABLE KUH) */
    {{'\xec', '\xbf', '\xbd'}, 3, 0xCFFD}, /* (HANGUL SYLLABLE KWEOG) */
    {{'\xec', '\xbf', '\xbe'}, 3, 0xCFFE}, /* (HANGUL SYLLABLE KWEOGG) */
    {{'\xec', '\xbf', '\xbf'}, 3, 0xCFFF}, /* (HANGUL SYLLABLE KWEOGS) */
    {{'\xed', '\x80', '\x81'}, 3, 0xD001}, /* (HANGUL SYLLABLE KWEONJ) */
    {{'\xed', '\x80', '\x82'}, 3, 0xD002}, /* (HANGUL SYLLABLE KWEONH) */
    {{'\xed', '\x80', '\x83'}, 3, 0xD003}, /* (HANGUL SYLLABLE KWEOD) */
    {{'\xed', '\x80', '\x85'}, 3, 0xD005}, /* (HANGUL SYLLABLE KWEOLG) */
    {{'\xed', '\x80', '\x86'}, 3, 0xD006}, /* (HANGUL SYLLABLE KWEOLM) */
    {{'\xed', '\x80', '\x87'}, 3, 0xD007}, /* (HANGUL SYLLABLE KWEOLB) */
    {{'\xed', '\x80', '\x88'}, 3, 0xD008}, /* (HANGUL SYLLABLE KWEOLS) */
    {{'\xed', '\x80', '\x89'}, 3, 0xD009}, /* (HANGUL SYLLABLE KWEOLT) */
    {{'\xed', '\x80', '\x8a'}, 3, 0xD00A}, /* (HANGUL SYLLABLE KWEOLP) */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{'\xed', '\x80', '\x8b'}, 3, 0xD00B}, /* (HANGUL SYLLABLE KWEOLH) */
    {{'\xed', '\x80', '\x8c'}, 3, 0xD00C}, /* (HANGUL SYLLABLE KWEOM) */
    {{'\xed', '\x80', '\x8d'}, 3, 0xD00D}, /* (HANGUL SYLLABLE KWEOB) */
    {{'\xed', '\x80', '\x8e'}, 3, 0xD00E}, /* (HANGUL SYLLABLE KWEOBS) */
    {{'\xed', '\x80', '\x8f'}, 3, 0xD00F}, /* (HANGUL SYLLABLE KWEOS) */
    {{'\xed', '\x80', '\x90'}, 3, 0xD010}, /* (HANGUL SYLLABLE KWEOSS) */
    {{'\xed', '\x80', '\x92'}, 3, 0xD012}, /* (HANGUL SYLLABLE KWEOJ) */
    {{'\xed', '\x80', '\x93'}, 3, 0xD013}, /* (HANGUL SYLLABLE KWEOC) */
    {{'\xed', '\x80', '\x94'}, 3, 0xD014}, /* (HANGUL SYLLABLE KWEOK) */
    {{'\xed', '\x80', '\x95'}, 3, 0xD015}, /* (HANGUL SYLLABLE KWEOT) */
    {{'\xed', '\x80', '\x96'}, 3, 0xD016}, /* (HANGUL SYLLABLE KWEOP) */
    {{'\xed', '\x80', '\x97'}, 3, 0xD017}, /* (HANGUL SYLLABLE KWEOH) */
    {{'\xed', '\x80', '\x99'}, 3, 0xD019}, /* (HANGUL SYLLABLE KWEG) */
    {{'\xed', '\x80', '\x9a'}, 3, 0xD01A}, /* (HANGUL SYLLABLE KWEGG) */
    {{'\xed', '\x80', '\x9b'}, 3, 0xD01B}, /* (HANGUL SYLLABLE KWEGS) */
    {{'\xed', '\x80', '\x9c'}, 3, 0xD01C}, /* (HANGUL SYLLABLE KWEN) */
    {{'\xed', '\x80', '\x9d'}, 3, 0xD01D}, /* (HANGUL SYLLABLE KWENJ) */
    {{'\xed', '\x80', '\x9e'}, 3, 0xD01E}, /* (HANGUL SYLLABLE KWENH) */
    {{'\xed', '\x80', '\x9f'}, 3, 0xD01F}, /* (HANGUL SYLLABLE KWED) */
    {{'\xed', '\x80', '\xa0'}, 3, 0xD020}, /* (HANGUL SYLLABLE KWEL) */
    {{'\xed', '\x80', '\xa1'}, 3, 0xD021}, /* (HANGUL SYLLABLE KWELG) */
    {{'\xed', '\x80', '\xa2'}, 3, 0xD022}, /* (HANGUL SYLLABLE KWELM) */
    {{'\xed', '\x80', '\xa3'}, 3, 0xD023}, /* (HANGUL SYLLABLE KWELB) */
    {{'\xed', '\x80', '\xa4'}, 3, 0xD024}, /* (HANGUL SYLLABLE KWELS) */
    {{'\xed', '\x80', '\xa5'}, 3, 0xD025}, /* (HANGUL SYLLABLE KWELT) */
    {{'\xed', '\x80', '\xa6'}, 3, 0xD026}, /* (HANGUL SYLLABLE KWELP) */
    {{'\xed', '\x80', '\xa7'}, 3, 0xD027}, /* (HANGUL SYLLABLE KWELH) */
    {{'\xed', '\x80', '\xa8'}, 3, 0xD028}, /* (HANGUL SYLLABLE KWEM) */
    {{'\xed', '\x80', '\xa9'}, 3, 0xD029}, /* (HANGUL SYLLABLE KWEB) */
    {{'\xed', '\x80', '\xaa'}, 3, 0xD02A}, /* (HANGUL SYLLABLE KWEBS) */
    {{'\xed', '\x80', '\xab'}, 3, 0xD02B}, /* (HANGUL SYLLABLE KWES) */
    {{'\xed', '\x80', '\xac'}, 3, 0xD02C}, /* (HANGUL SYLLABLE KWESS) */
    {{'\xeb', '\x81', '\x9d'}, 3, 0xB05D}, /* (HANGUL SYLLABLE GGEUT) */
    {{'\xeb', '\x81', '\xbc'}, 3, 0xB07C}, /* (HANGUL SYLLABLE GGI) */
    {{'\xeb', '\x81', '\xbd'}, 3, 0xB07D}, /* (HANGUL SYLLABLE GGIG) */
    {{'\xeb', '\x82', '\x80'}, 3, 0xB080}, /* (HANGUL SYLLABLE GGIN) */
    {{'\xeb', '\x82', '\x84'}, 3, 0xB084}, /* (HANGUL SYLLABLE GGIL) */
    {{'\xeb', '\x82', '\x8c'}, 3, 0xB08C}, /* (HANGUL SYLLABLE GGIM) */
    {{'\xeb', '\x82', '\x8d'}, 3, 0xB08D}, /* (HANGUL SYLLABLE GGIB) */
    {{'\xeb', '\x82', '\x8f'}, 3, 0xB08F}, /* (HANGUL SYLLABLE GGIS) */
    {{'\xeb', '\x82', '\x91'}, 3, 0xB091}, /* (HANGUL SYLLABLE GGING) */
    {{'\xeb', '\x82', '\x98'}, 3, 0xB098}, /* (HANGUL SYLLABLE NA) */
    {{'\xeb', '\x82', '\x99'}, 3, 0xB099}, /* (HANGUL SYLLABLE NAG) */
    {{'\xeb', '\x82', '\x9a'}, 3, 0xB09A}, /* (HANGUL SYLLABLE NAGG) */
    {{'\xeb', '\x82', '\x9c'}, 3, 0xB09C}, /* (HANGUL SYLLABLE NAN) */
    {{'\xeb', '\x82', '\x9f'}, 3, 0xB09F}, /* (HANGUL SYLLABLE NAD) */
    {{'\xeb', '\x82', '\xa0'}, 3, 0xB0A0}, /* (HANGUL SYLLABLE NAL) */
    {{'\xeb', '\x82', '\xa1'}, 3, 0xB0A1}, /* (HANGUL SYLLABLE NALG) */
    {{'\xeb', '\x82', '\xa2'}, 3, 0xB0A2}, /* (HANGUL SYLLABLE NALM) */
    {{'\xeb', '\x82', '\xa8'}, 3, 0xB0A8}, /* (HANGUL SYLLABLE NAM) */
    {{'\xeb', '\x82', '\xa9'}, 3, 0xB0A9}, /* (HANGUL SYLLABLE NAB) */
    {{'\xeb', '\x82', '\xab'}, 3, 0xB0AB}, /* (HANGUL SYLLABLE NAS) */
    {{'\xeb', '\x82', '\xac'}, 3, 0xB0AC}, /* (HANGUL SYLLABLE NASS) */
    {{'\xeb', '\x82', '\xad'}, 3, 0xB0AD}, /* (HANGUL SYLLABLE NANG) */
    {{'\xeb', '\x82', '\xae'}, 3, 0xB0AE}, /* (HANGUL SYLLABLE NAJ) */
    {{'\xeb', '\x82', '\xaf'}, 3, 0xB0AF}, /* (HANGUL SYLLABLE NAC) */
    {{'\xeb', '\x82', '\xb1'}, 3, 0xB0B1}, /* (HANGUL SYLLABLE NAT) */
    {{'\xeb', '\x82', '\xb3'}, 3, 0xB0B3}, /* (HANGUL SYLLABLE NAH) */
    {{'\xeb', '\x82', '\xb4'}, 3, 0xB0B4}, /* (HANGUL SYLLABLE NAE) */
    {{'\xeb', '\x82', '\xb5'}, 3, 0xB0B5}, /* (HANGUL SYLLABLE NAEG) */
    {{'\xeb', '\x82', '\xb8'}, 3, 0xB0B8}, /* (HANGUL SYLLABLE NAEN) */
    {{'\xeb', '\x82', '\xbc'}, 3, 0xB0BC}, /* (HANGUL SYLLABLE NAEL) */
    {{'\xeb', '\x83', '\x84'}, 3, 0xB0C4}, /* (HANGUL SYLLABLE NAEM) */
    {{'\xeb', '\x83', '\x85'}, 3, 0xB0C5}, /* (HANGUL SYLLABLE NAEB) */
    {{'\xeb', '\x83', '\x87'}, 3, 0xB0C7}, /* (HANGUL SYLLABLE NAES) */
    {{'\xeb', '\x83', '\x88'}, 3, 0xB0C8}, /* (HANGUL SYLLABLE NAESS) */
    {{'\xeb', '\x83', '\x89'}, 3, 0xB0C9}, /* (HANGUL SYLLABLE NAENG) */
    {{'\xeb', '\x83', '\x90'}, 3, 0xB0D0}, /* (HANGUL SYLLABLE NYA) */
    {{'\xeb', '\x83', '\x91'}, 3, 0xB0D1}, /* (HANGUL SYLLABLE NYAG) */
    {{'\xeb', '\x83', '\x94'}, 3, 0xB0D4}, /* (HANGUL SYLLABLE NYAN) */
    {{'\xeb', '\x83', '\x98'}, 3, 0xB0D8}, /* (HANGUL SYLLABLE NYAL) */
    {{'\xeb', '\x83', '\xa0'}, 3, 0xB0E0}, /* (HANGUL SYLLABLE NYAM) */
    {{'\xeb', '\x83', '\xa5'}, 3, 0xB0E5}, /* (HANGUL SYLLABLE NYANG) */
    {{'\xeb', '\x84', '\x88'}, 3, 0xB108}, /* (HANGUL SYLLABLE NEO) */
    {{'\xeb', '\x84', '\x89'}, 3, 0xB109}, /* (HANGUL SYLLABLE NEOG) */
    {{'\xeb', '\x84', '\x8b'}, 3, 0xB10B}, /* (HANGUL SYLLABLE NEOGS) */
    {{'\xeb', '\x84', '\x8c'}, 3, 0xB10C}, /* (HANGUL SYLLABLE NEON) */
    {{'\xeb', '\x84', '\x90'}, 3, 0xB110}, /* (HANGUL SYLLABLE NEOL) */
    {{'\xeb', '\x84', '\x92'}, 3, 0xB112}, /* (HANGUL SYLLABLE NEOLM) */
    {{'\xeb', '\x84', '\x93'}, 3, 0xB113}, /* (HANGUL SYLLABLE NEOLB) */
    {{'\xeb', '\x84', '\x98'}, 3, 0xB118}, /* (HANGUL SYLLABLE NEOM) */
    {{'\xeb', '\x84', '\x99'}, 3, 0xB119}, /* (HANGUL SYLLABLE NEOB) */
    {{'\xeb', '\x84', '\x9b'}, 3, 0xB11B}, /* (HANGUL SYLLABLE NEOS) */
    {{'\xeb', '\x84', '\x9c'}, 3, 0xB11C}, /* (HANGUL SYLLABLE NEOSS) */
    {{'\xeb', '\x84', '\x9d'}, 3, 0xB11D}, /* (HANGUL SYLLABLE NEONG) */
    {{'\xeb', '\x84', '\xa3'}, 3, 0xB123}, /* (HANGUL SYLLABLE NEOH) */
    {{'\xeb', '\x84', '\xa4'}, 3, 0xB124}, /* (HANGUL SYLLABLE NE) */
    {{'\xeb', '\x84', '\xa5'}, 3, 0xB125}, /* (HANGUL SYLLABLE NEG) */
    {{'\xeb', '\x84', '\xa8'}, 3, 0xB128}, /* (HANGUL SYLLABLE NEN) */
    {{'\xeb', '\x84', '\xac'}, 3, 0xB12C}, /* (HANGUL SYLLABLE NEL) */
    {{'\xeb', '\x84', '\xb4'}, 3, 0xB134}, /* (HANGUL SYLLABLE NEM) */
    {{'\xeb', '\x84', '\xb5'}, 3, 0xB135}, /* (HANGUL SYLLABLE NEB) */
    {{'\xeb', '\x84', '\xb7'}, 3, 0xB137}, /* (HANGUL SYLLABLE NES) */
    {{'\xeb', '\x84', '\xb8'}, 3, 0xB138}, /* (HANGUL SYLLABLE NESS) */
    {{'\xeb', '\x84', '\xb9'}, 3, 0xB139}, /* (HANGUL SYLLABLE NENG) */
    {{'\xeb', '\x85', '\x80'}, 3, 0xB140}, /* (HANGUL SYLLABLE NYEO) */
    {{'\xeb', '\x85', '\x81'}, 3, 0xB141}, /* (HANGUL SYLLABLE NYEOG) */
    {{'\xeb', '\x85', '\x84'}, 3, 0xB144}, /* (HANGUL SYLLABLE NYEON) */
    {{'\xeb', '\x85', '\x88'}, 3, 0xB148}, /* (HANGUL SYLLABLE NYEOL) */
    {{'\xeb', '\x85', '\x90'}, 3, 0xB150}, /* (HANGUL SYLLABLE NYEOM) */
    {{'\xeb', '\x85', '\x91'}, 3, 0xB151}, /* (HANGUL SYLLABLE NYEOB) */
    {{'\xeb', '\x85', '\x94'}, 3, 0xB154}, /* (HANGUL SYLLABLE NYEOSS) */
    {{'\xeb', '\x85', '\x95'}, 3, 0xB155}, /* (HANGUL SYLLABLE NYEONG) */
    {{'\xeb', '\x85', '\x98'}, 3, 0xB158}, /* (HANGUL SYLLABLE NYEOK) */
    {{'\xeb', '\x85', '\x9c'}, 3, 0xB15C}, /* (HANGUL SYLLABLE NYE) */
    {{'\xeb', '\x85', '\xa0'}, 3, 0xB160}, /* (HANGUL SYLLABLE NYEN) */
    {{'\xeb', '\x85', '\xb8'}, 3, 0xB178}, /* (HANGUL SYLLABLE NO) */
    {{'\xeb', '\x85', '\xb9'}, 3, 0xB179}, /* (HANGUL SYLLABLE NOG) */
    {{'\xeb', '\x85', '\xbc'}, 3, 0xB17C}, /* (HANGUL SYLLABLE NON) */
    {{'\xeb', '\x86', '\x80'}, 3, 0xB180}, /* (HANGUL SYLLABLE NOL) */
    {{'\xeb', '\x86', '\x82'}, 3, 0xB182}, /* (HANGUL SYLLABLE NOLM) */
    {{'\xeb', '\x86', '\x88'}, 3, 0xB188}, /* (HANGUL SYLLABLE NOM) */
    {{'\xeb', '\x86', '\x89'}, 3, 0xB189}, /* (HANGUL SYLLABLE NOB) */
    {{'\xeb', '\x86', '\x8b'}, 3, 0xB18B}, /* (HANGUL SYLLABLE NOS) */
    {{'\xeb', '\x86', '\x8d'}, 3, 0xB18D}, /* (HANGUL SYLLABLE NONG) */
    {{'\xeb', '\x86', '\x92'}, 3, 0xB192}, /* (HANGUL SYLLABLE NOP) */
    {{'\xeb', '\x86', '\x93'}, 3, 0xB193}, /* (HANGUL SYLLABLE NOH) */
    {{'\xeb', '\x86', '\x94'}, 3, 0xB194}, /* (HANGUL SYLLABLE NWA) */
    {{'\xeb', '\x86', '\x98'}, 3, 0xB198}, /* (HANGUL SYLLABLE NWAN) */
    {{'\xeb', '\x86', '\x9c'}, 3, 0xB19C}, /* (HANGUL SYLLABLE NWAL) */
    {{'\xeb', '\x86', '\xa8'}, 3, 0xB1A8}, /* (HANGUL SYLLABLE NWASS) */
    {{'\xeb', '\x87', '\x8c'}, 3, 0xB1CC}, /* (HANGUL SYLLABLE NOE) */
    {{'\xeb', '\x87', '\x90'}, 3, 0xB1D0}, /* (HANGUL SYLLABLE NOEN) */
    {{'\xeb', '\x87', '\x94'}, 3, 0xB1D4}, /* (HANGUL SYLLABLE NOEL) */
    {{'\xeb', '\x87', '\x9c'}, 3, 0xB1DC}, /* (HANGUL SYLLABLE NOEM) */
    {{'\xeb', '\x87', '\x9d'}, 3, 0xB1DD}, /* (HANGUL SYLLABLE NOEB) */
    {{'\xed', '\x80', '\xae'}, 3, 0xD02E}, /* (HANGUL SYLLABLE KWEJ) */
    {{'\xed', '\x80', '\xaf'}, 3, 0xD02F}, /* (HANGUL SYLLABLE KWEC) */
    {{'\xed', '\x80', '\xb0'}, 3, 0xD030}, /* (HANGUL SYLLABLE KWEK) */
    {{'\xed', '\x80', '\xb1'}, 3, 0xD031}, /* (HANGUL SYLLABLE KWET) */
    {{'\xed', '\x80', '\xb2'}, 3, 0xD032}, /* (HANGUL SYLLABLE KWEP) */
    {{'\xed', '\x80', '\xb3'}, 3, 0xD033}, /* (HANGUL SYLLABLE KWEH) */
    {{'\xed', '\x80', '\xb6'}, 3, 0xD036}, /* (HANGUL SYLLABLE KWIGG) */
    {{'\xed', '\x80', '\xb7'}, 3, 0xD037}, /* (HANGUL SYLLABLE KWIGS) */
    {{'\xed', '\x80', '\xb9'}, 3, 0xD039}, /* (HANGUL SYLLABLE KWINJ) */
    {{'\xed', '\x80', '\xba'}, 3, 0xD03A}, /* (HANGUL SYLLABLE KWINH) */
    {{'\xed', '\x80', '\xbb'}, 3, 0xD03B}, /* (HANGUL SYLLABLE KWID) */
    {{'\xed', '\x80', '\xbd'}, 3, 0xD03D}, /* (HANGUL SYLLABLE KWILG) */
    {{'\xed', '\x80', '\xbe'}, 3, 0xD03E}, /* (HANGUL SYLLABLE KWILM) */
    {{'\xed', '\x80', '\xbf'}, 3, 0xD03F}, /* (HANGUL SYLLABLE KWILB) */
    {{'\xed', '\x81', '\x80'}, 3, 0xD040}, /* (HANGUL SYLLABLE KWILS) */
    {{'\xed', '\x81', '\x81'}, 3, 0xD041}, /* (HANGUL SYLLABLE KWILT) */
    {{'\xed', '\x81', '\x82'}, 3, 0xD042}, /* (HANGUL SYLLABLE KWILP) */
    {{'\xed', '\x81', '\x83'}, 3, 0xD043}, /* (HANGUL SYLLABLE KWILH) */
    {{'\xed', '\x81', '\x86'}, 3, 0xD046}, /* (HANGUL SYLLABLE KWIBS) */
    {{'\xed', '\x81', '\x88'}, 3, 0xD048}, /* (HANGUL SYLLABLE KWISS) */
    {{'\xed', '\x81', '\x8a'}, 3, 0xD04A}, /* (HANGUL SYLLABLE KWIJ) */
    {{'\xed', '\x81', '\x8b'}, 3, 0xD04B}, /* (HANGUL SYLLABLE KWIC) */
    {{'\xed', '\x81', '\x8c'}, 3, 0xD04C}, /* (HANGUL SYLLABLE KWIK) */
    {{'\xed', '\x81', '\x8d'}, 3, 0xD04D}, /* (HANGUL SYLLABLE KWIT) */
    {{'\xed', '\x81', '\x8e'}, 3, 0xD04E}, /* (HANGUL SYLLABLE KWIP) */
    {{'\xed', '\x81', '\x8f'}, 3, 0xD04F}, /* (HANGUL SYLLABLE KWIH) */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{'\xed', '\x81', '\x91'}, 3, 0xD051}, /* (HANGUL SYLLABLE KYUG) */
    {{'\xed', '\x81', '\x92'}, 3, 0xD052}, /* (HANGUL SYLLABLE KYUGG) */
    {{'\xed', '\x81', '\x93'}, 3, 0xD053}, /* (HANGUL SYLLABLE KYUGS) */
    {{'\xed', '\x81', '\x95'}, 3, 0xD055}, /* (HANGUL SYLLABLE KYUNJ) */
    {{'\xed', '\x81', '\x96'}, 3, 0xD056}, /* (HANGUL SYLLABLE KYUNH) */
    {{'\xed', '\x81', '\x97'}, 3, 0xD057}, /* (HANGUL SYLLABLE KYUD) */
    {{'\xed', '\x81', '\x99'}, 3, 0xD059}, /* (HANGUL SYLLABLE KYULG) */
    {{'\xed', '\x81', '\x9a'}, 3, 0xD05A}, /* (HANGUL SYLLABLE KYULM) */
    {{'\xed', '\x81', '\x9b'}, 3, 0xD05B}, /* (HANGUL SYLLABLE KYULB) */
    {{'\xed', '\x81', '\x9c'}, 3, 0xD05C}, /* (HANGUL SYLLABLE KYULS) */
    {{'\xed', '\x81', '\x9d'}, 3, 0xD05D}, /* (HANGUL SYLLABLE KYULT) */
    {{'\xed', '\x81', '\x9e'}, 3, 0xD05E}, /* (HANGUL SYLLABLE KYULP) */
    {{'\xed', '\x81', '\x9f'}, 3, 0xD05F}, /* (HANGUL SYLLABLE KYULH) */
    {{'\xed', '\x81', '\xa1'}, 3, 0xD061}, /* (HANGUL SYLLABLE KYUB) */
    {{'\xed', '\x81', '\xa2'}, 3, 0xD062}, /* (HANGUL SYLLABLE KYUBS) */
    {{'\xed', '\x81', '\xa3'}, 3, 0xD063}, /* (HANGUL SYLLABLE KYUS) */
    {{'\xed', '\x81', '\xa4'}, 3, 0xD064}, /* (HANGUL SYLLABLE KYUSS) */
    {{'\xed', '\x81', '\xa5'}, 3, 0xD065}, /* (HANGUL SYLLABLE KYUNG) */
    {{'\xed', '\x81', '\xa6'}, 3, 0xD066}, /* (HANGUL SYLLABLE KYUJ) */
    {{'\xed', '\x81', '\xa7'}, 3, 0xD067}, /* (HANGUL SYLLABLE KYUC) */
    {{'\xed', '\x81', '\xa8'}, 3, 0xD068}, /* (HANGUL SYLLABLE KYUK) */
    {{'\xed', '\x81', '\xa9'}, 3, 0xD069}, /* (HANGUL SYLLABLE KYUT) */
    {{'\xed', '\x81', '\xaa'}, 3, 0xD06A}, /* (HANGUL SYLLABLE KYUP) */
    {{'\xed', '\x81', '\xab'}, 3, 0xD06B}, /* (HANGUL SYLLABLE KYUH) */
    {{'\xed', '\x81', '\xae'}, 3, 0xD06E}, /* (HANGUL SYLLABLE KEUGG) */
    {{'\xed', '\x81', '\xaf'}, 3, 0xD06F}, /* (HANGUL SYLLABLE KEUGS) */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{'\xed', '\x81', '\xb1'}, 3, 0xD071}, /* (HANGUL SYLLABLE KEUNJ) */
    {{'\xed', '\x81', '\xb2'}, 3, 0xD072}, /* (HANGUL SYLLABLE KEUNH) */
    {{'\xed', '\x81', '\xb3'}, 3, 0xD073}, /* (HANGUL SYLLABLE KEUD) */
    {{'\xed', '\x81', '\xb5'}, 3, 0xD075}, /* (HANGUL SYLLABLE KEULG) */
    {{'\xed', '\x81', '\xb6'}, 3, 0xD076}, /* (HANGUL SYLLABLE KEULM) */
    {{'\xed', '\x81', '\xb7'}, 3, 0xD077}, /* (HANGUL SYLLABLE KEULB) */
    {{'\xed', '\x81', '\xb8'}, 3, 0xD078}, /* (HANGUL SYLLABLE KEULS) */
    {{'\xed', '\x81', '\xb9'}, 3, 0xD079}, /* (HANGUL SYLLABLE KEULT) */
    {{'\xed', '\x81', '\xba'}, 3, 0xD07A}, /* (HANGUL SYLLABLE KEULP) */
    {{'\xed', '\x81', '\xbb'}, 3, 0xD07B}, /* (HANGUL SYLLABLE KEULH) */
    {{'\xed', '\x81', '\xbe'}, 3, 0xD07E}, /* (HANGUL SYLLABLE KEUBS) */
    {{'\xed', '\x81', '\xbf'}, 3, 0xD07F}, /* (HANGUL SYLLABLE KEUS) */
    {{'\xed', '\x82', '\x80'}, 3, 0xD080}, /* (HANGUL SYLLABLE KEUSS) */
    {{'\xed', '\x82', '\x82'}, 3, 0xD082}, /* (HANGUL SYLLABLE KEUJ) */
    {{'\xed', '\x82', '\x83'}, 3, 0xD083}, /* (HANGUL SYLLABLE KEUC) */
    {{'\xed', '\x82', '\x84'}, 3, 0xD084}, /* (HANGUL SYLLABLE KEUK) */
    {{'\xed', '\x82', '\x85'}, 3, 0xD085}, /* (HANGUL SYLLABLE KEUT) */
    {{'\xed', '\x82', '\x86'}, 3, 0xD086}, /* (HANGUL SYLLABLE KEUP) */
    {{'\xed', '\x82', '\x87'}, 3, 0xD087}, /* (HANGUL SYLLABLE KEUH) */
    {{'\xed', '\x82', '\x88'}, 3, 0xD088}, /* (HANGUL SYLLABLE KYI) */
    {{'\xed', '\x82', '\x89'}, 3, 0xD089}, /* (HANGUL SYLLABLE KYIG) */
    {{'\xed', '\x82', '\x8a'}, 3, 0xD08A}, /* (HANGUL SYLLABLE KYIGG) */
    {{'\xed', '\x82', '\x8b'}, 3, 0xD08B}, /* (HANGUL SYLLABLE KYIGS) */
    {{'\xed', '\x82', '\x8c'}, 3, 0xD08C}, /* (HANGUL SYLLABLE KYIN) */
    {{'\xed', '\x82', '\x8d'}, 3, 0xD08D}, /* (HANGUL SYLLABLE KYINJ) */
    {{'\xed', '\x82', '\x8e'}, 3, 0xD08E}, /* (HANGUL SYLLABLE KYINH) */
    {{'\xed', '\x82', '\x8f'}, 3, 0xD08F}, /* (HANGUL SYLLABLE KYID) */
    {{'\xed', '\x82', '\x90'}, 3, 0xD090}, /* (HANGUL SYLLABLE KYIL) */
    {{'\xed', '\x82', '\x91'}, 3, 0xD091}, /* (HANGUL SYLLABLE KYILG) */
    {{'\xed', '\x82', '\x92'}, 3, 0xD092}, /* (HANGUL SYLLABLE KYILM) */
    {{'\xed', '\x82', '\x93'}, 3, 0xD093}, /* (HANGUL SYLLABLE KYILB) */
    {{'\xed', '\x82', '\x94'}, 3, 0xD094}, /* (HANGUL SYLLABLE KYILS) */
    {{'\xeb', '\x87', '\x9f'}, 3, 0xB1DF}, /* (HANGUL SYLLABLE NOES) */
    {{'\xeb', '\x87', '\xa8'}, 3, 0xB1E8}, /* (HANGUL SYLLABLE NYO) */
    {{'\xeb', '\x87', '\xa9'}, 3, 0xB1E9}, /* (HANGUL SYLLABLE NYOG) */
    {{'\xeb', '\x87', '\xac'}, 3, 0xB1EC}, /* (HANGUL SYLLABLE NYON) */
    {{'\xeb', '\x87', '\xb0'}, 3, 0xB1F0}, /* (HANGUL SYLLABLE NYOL) */
    {{'\xeb', '\x87', '\xb9'}, 3, 0xB1F9}, /* (HANGUL SYLLABLE NYOB) */
    {{'\xeb', '\x87', '\xbb'}, 3, 0xB1FB}, /* (HANGUL SYLLABLE NYOS) */
    {{'\xeb', '\x87', '\xbd'}, 3, 0xB1FD}, /* (HANGUL SYLLABLE NYONG) */
    {{'\xeb', '\x88', '\x84'}, 3, 0xB204}, /* (HANGUL SYLLABLE NU) */
    {{'\xeb', '\x88', '\x85'}, 3, 0xB205}, /* (HANGUL SYLLABLE NUG) */
    {{'\xeb', '\x88', '\x88'}, 3, 0xB208}, /* (HANGUL SYLLABLE NUN) */
    {{'\xeb', '\x88', '\x8b'}, 3, 0xB20B}, /* (HANGUL SYLLABLE NUD) */
    {{'\xeb', '\x88', '\x8c'}, 3, 0xB20C}, /* (HANGUL SYLLABLE NUL) */
    {{'\xeb', '\x88', '\x94'}, 3, 0xB214}, /* (HANGUL SYLLABLE NUM) */
    {{'\xeb', '\x88', '\x95'}, 3, 0xB215}, /* (HANGUL SYLLABLE NUB) */
    {{'\xeb', '\x88', '\x97'}, 3, 0xB217}, /* (HANGUL SYLLABLE NUS) */
    {{'\xeb', '\x88', '\x99'}, 3, 0xB219}, /* (HANGUL SYLLABLE NUNG) */
    {{'\xeb', '\x88', '\xa0'}, 3, 0xB220}, /* (HANGUL SYLLABLE NWEO) */
    {{'\xeb', '\x88', '\xb4'}, 3, 0xB234}, /* (HANGUL SYLLABLE NWEOSS) */
    {{'\xeb', '\x88', '\xbc'}, 3, 0xB23C}, /* (HANGUL SYLLABLE NWE) */
    {{'\xeb', '\x89', '\x98'}, 3, 0xB258}, /* (HANGUL SYLLABLE NWI) */
    {{'\xeb', '\x89', '\x9c'}, 3, 0xB25C}, /* (HANGUL SYLLABLE NWIN) */
    {{'\xeb', '\x89', '\xa0'}, 3, 0xB260}, /* (HANGUL SYLLABLE NWIL) */
    {{'\xeb', '\x89', '\xa8'}, 3, 0xB268}, /* (HANGUL SYLLABLE NWIM) */
    {{'\xeb', '\x89', '\xa9'}, 3, 0xB269}, /* (HANGUL SYLLABLE NWIB) */
    {{'\xeb', '\x89', '\xb4'}, 3, 0xB274}, /* (HANGUL SYLLABLE NYU) */
    {{'\xeb', '\x89', '\xb5'}, 3, 0xB275}, /* (HANGUL SYLLABLE NYUG) */
    {{'\xeb', '\x89', '\xbc'}, 3, 0xB27C}, /* (HANGUL SYLLABLE NYUL) */
    {{'\xeb', '\x8a', '\x84'}, 3, 0xB284}, /* (HANGUL SYLLABLE NYUM) */
    {{'\xeb', '\x8a', '\x85'}, 3, 0xB285}, /* (HANGUL SYLLABLE NYUB) */
    {{'\xeb', '\x8a', '\x89'}, 3, 0xB289}, /* (HANGUL SYLLABLE NYUNG) */
    {{'\xeb', '\x8a', '\x90'}, 3, 0xB290}, /* (HANGUL SYLLABLE NEU) */
    {{'\xeb', '\x8a', '\x91'}, 3, 0xB291}, /* (HANGUL SYLLABLE NEUG) */
    {{'\xeb', '\x8a', '\x94'}, 3, 0xB294}, /* (HANGUL SYLLABLE NEUN) */
    {{'\xeb', '\x8a', '\x98'}, 3, 0xB298}, /* (HANGUL SYLLABLE NEUL) */
    {{'\xeb', '\x8a', '\x99'}, 3, 0xB299}, /* (HANGUL SYLLABLE NEULG) */
    {{'\xeb', '\x8a', '\x9a'}, 3, 0xB29A}, /* (HANGUL SYLLABLE NEULM) */
    {{'\xeb', '\x8a', '\xa0'}, 3, 0xB2A0}, /* (HANGUL SYLLABLE NEUM) */
    {{'\xeb', '\x8a', '\xa1'}, 3, 0xB2A1}, /* (HANGUL SYLLABLE NEUB) */
    {{'\xeb', '\x8a', '\xa3'}, 3, 0xB2A3}, /* (HANGUL SYLLABLE NEUS) */
    {{'\xeb', '\x8a', '\xa5'}, 3, 0xB2A5}, /* (HANGUL SYLLABLE NEUNG) */
    {{'\xeb', '\x8a', '\xa6'}, 3, 0xB2A6}, /* (HANGUL SYLLABLE NEUJ) */
    {{'\xeb', '\x8a', '\xaa'}, 3, 0xB2AA}, /* (HANGUL SYLLABLE NEUP) */
    {{'\xeb', '\x8a', '\xac'}, 3, 0xB2AC}, /* (HANGUL SYLLABLE NYI) */
    {{'\xeb', '\x8a', '\xb0'}, 3, 0xB2B0}, /* (HANGUL SYLLABLE NYIN) */
    {{'\xeb', '\x8a', '\xb4'}, 3, 0xB2B4}, /* (HANGUL SYLLABLE NYIL) */
    {{'\xeb', '\x8b', '\x88'}, 3, 0xB2C8}, /* (HANGUL SYLLABLE NI) */
    {{'\xeb', '\x8b', '\x89'}, 3, 0xB2C9}, /* (HANGUL SYLLABLE NIG) */
    {{'\xeb', '\x8b', '\x8c'}, 3, 0xB2CC}, /* (HANGUL SYLLABLE NIN) */
    {{'\xeb', '\x8b', '\x90'}, 3, 0xB2D0}, /* (HANGUL SYLLABLE NIL) */
    {{'\xeb', '\x8b', '\x92'}, 3, 0xB2D2}, /* (HANGUL SYLLABLE NILM) */
    {{'\xeb', '\x8b', '\x98'}, 3, 0xB2D8}, /* (HANGUL SYLLABLE NIM) */
    {{'\xeb', '\x8b', '\x99'}, 3, 0xB2D9}, /* (HANGUL SYLLABLE NIB) */
    {{'\xeb', '\x8b', '\x9b'}, 3, 0xB2DB}, /* (HANGUL SYLLABLE NIS) */
    {{'\xeb', '\x8b', '\x9d'}, 3, 0xB2DD}, /* (HANGUL SYLLABLE NING) */
    {{'\xeb', '\x8b', '\xa2'}, 3, 0xB2E2}, /* (HANGUL SYLLABLE NIP) */
    {{'\xeb', '\x8b', '\xa4'}, 3, 0xB2E4}, /* (HANGUL SYLLABLE DA) */
    {{'\xeb', '\x8b', '\xa5'}, 3, 0xB2E5}, /* (HANGUL SYLLABLE DAG) */
    {{'\xeb', '\x8b', '\xa6'}, 3, 0xB2E6}, /* (HANGUL SYLLABLE DAGG) */
    {{'\xeb', '\x8b', '\xa8'}, 3, 0xB2E8}, /* (HANGUL SYLLABLE DAN) */
    {{'\xeb', '\x8b', '\xab'}, 3, 0xB2EB}, /* (HANGUL SYLLABLE DAD) */
    {{'\xeb', '\x8b', '\xac'}, 3, 0xB2EC}, /* (HANGUL SYLLABLE DAL) */
    {{'\xeb', '\x8b', '\xad'}, 3, 0xB2ED}, /* (HANGUL SYLLABLE DALG) */
    {{'\xeb', '\x8b', '\xae'}, 3, 0xB2EE}, /* (HANGUL SYLLABLE DALM) */
    {{'\xeb', '\x8b', '\xaf'}, 3, 0xB2EF}, /* (HANGUL SYLLABLE DALB) */
    {{'\xeb', '\x8b', '\xb3'}, 3, 0xB2F3}, /* (HANGUL SYLLABLE DALH) */
    {{'\xeb', '\x8b', '\xb4'}, 3, 0xB2F4}, /* (HANGUL SYLLABLE DAM) */
    {{'\xeb', '\x8b', '\xb5'}, 3, 0xB2F5}, /* (HANGUL SYLLABLE DAB) */
    {{'\xeb', '\x8b', '\xb7'}, 3, 0xB2F7}, /* (HANGUL SYLLABLE DAS) */
    {{'\xeb', '\x8b', '\xb8'}, 3, 0xB2F8}, /* (HANGUL SYLLABLE DASS) */
    {{'\xeb', '\x8b', '\xb9'}, 3, 0xB2F9}, /* (HANGUL SYLLABLE DANG) */
    {{'\xeb', '\x8b', '\xba'}, 3, 0xB2FA}, /* (HANGUL SYLLABLE DAJ) */
    {{'\xeb', '\x8b', '\xbb'}, 3, 0xB2FB}, /* (HANGUL SYLLABLE DAC) */
    {{'\xeb', '\x8b', '\xbf'}, 3, 0xB2FF}, /* (HANGUL SYLLABLE DAH) */
    {{'\xeb', '\x8c', '\x80'}, 3, 0xB300}, /* (HANGUL SYLLABLE DAE) */
    {{'\xeb', '\x8c', '\x81'}, 3, 0xB301}, /* (HANGUL SYLLABLE DAEG) */
    {{'\xeb', '\x8c', '\x84'}, 3, 0xB304}, /* (HANGUL SYLLABLE DAEN) */
    {{'\xeb', '\x8c', '\x88'}, 3, 0xB308}, /* (HANGUL SYLLABLE DAEL) */
    {{'\xeb', '\x8c', '\x90'}, 3, 0xB310}, /* (HANGUL SYLLABLE DAEM) */
    {{'\xeb', '\x8c', '\x91'}, 3, 0xB311}, /* (HANGUL SYLLABLE DAEB) */
    {{'\xeb', '\x8c', '\x93'}, 3, 0xB313}, /* (HANGUL SYLLABLE DAES) */
    {{'\xeb', '\x8c', '\x94'}, 3, 0xB314}, /* (HANGUL SYLLABLE DAESS) */
    {{'\xeb', '\x8c', '\x95'}, 3, 0xB315}, /* (HANGUL SYLLABLE DAENG) */
    {{'\xeb', '\x8c', '\x9c'}, 3, 0xB31C}, /* (HANGUL SYLLABLE DYA) */
    {{'\xeb', '\x8d', '\x94'}, 3, 0xB354}, /* (HANGUL SYLLABLE DEO) */
    {{'\xeb', '\x8d', '\x95'}, 3, 0xB355}, /* (HANGUL SYLLABLE DEOG) */
    {{'\xeb', '\x8d', '\x96'}, 3, 0xB356}, /* (HANGUL SYLLABLE DEOGG) */
    {{'\xeb', '\x8d', '\x98'}, 3, 0xB358}, /* (HANGUL SYLLABLE DEON) */
    {{'\xeb', '\x8d', '\x9b'}, 3, 0xB35B}, /* (HANGUL SYLLABLE DEOD) */
    {{'\xeb', '\x8d', '\x9c'}, 3, 0xB35C}, /* (HANGUL SYLLABLE DEOL) */
    {{'\xeb', '\x8d', '\x9e'}, 3, 0xB35E}, /* (HANGUL SYLLABLE DEOLM) */
    {{'\xeb', '\x8d', '\x9f'}, 3, 0xB35F}, /* (HANGUL SYLLABLE DEOLB) */
    {{'\xeb', '\x8d', '\xa4'}, 3, 0xB364}, /* (HANGUL SYLLABLE DEOM) */
    {{'\xeb', '\x8d', '\xa5'}, 3, 0xB365}, /* (HANGUL SYLLABLE DEOB) */
    {{'\xed', '\x82', '\x95'}, 3, 0xD095}, /* (HANGUL SYLLABLE KYILT) */
    {{'\xed', '\x82', '\x96'}, 3, 0xD096}, /* (HANGUL SYLLABLE KYILP) */
    {{'\xed', '\x82', '\x97'}, 3, 0xD097}, /* (HANGUL SYLLABLE KYILH) */
    {{'\xed', '\x82', '\x98'}, 3, 0xD098}, /* (HANGUL SYLLABLE KYIM) */
    {{'\xed', '\x82', '\x99'}, 3, 0xD099}, /* (HANGUL SYLLABLE KYIB) */
    {{'\xed', '\x82', '\x9a'}, 3, 0xD09A}, /* (HANGUL SYLLABLE KYIBS) */
    {{'\xed', '\x82', '\x9b'}, 3, 0xD09B}, /* (HANGUL SYLLABLE KYIS) */
    {{'\xed', '\x82', '\x9c'}, 3, 0xD09C}, /* (HANGUL SYLLABLE KYISS) */
    {{'\xed', '\x82', '\x9d'}, 3, 0xD09D}, /* (HANGUL SYLLABLE KYING) */
    {{'\xed', '\x82', '\x9e'}, 3, 0xD09E}, /* (HANGUL SYLLABLE KYIJ) */
    {{'\xed', '\x82', '\x9f'}, 3, 0xD09F}, /* (HANGUL SYLLABLE KYIC) */
    {{'\xed', '\x82', '\xa0'}, 3, 0xD0A0}, /* (HANGUL SYLLABLE KYIK) */
    {{'\xed', '\x82', '\xa1'}, 3, 0xD0A1}, /* (HANGUL SYLLABLE KYIT) */
    {{'\xed', '\x82', '\xa2'}, 3, 0xD0A2}, /* (HANGUL SYLLABLE KYIP) */
    {{'\xed', '\x82', '\xa3'}, 3, 0xD0A3}, /* (HANGUL SYLLABLE KYIH) */
    {{'\xed', '\x82', '\xa6'}, 3, 0xD0A6}, /* (HANGUL SYLLABLE KIGG) */
    {{'\xed', '\x82', '\xa7'}, 3, 0xD0A7}, /* (HANGUL SYLLABLE KIGS) */
    {{'\xed', '\x82', '\xa9'}, 3, 0xD0A9}, /* (HANGUL SYLLABLE KINJ) */
    {{'\xed', '\x82', '\xaa'}, 3, 0xD0AA}, /* (HANGUL SYLLABLE KINH) */
    {{'\xed', '\x82', '\xab'}, 3, 0xD0AB}, /* (HANGUL SYLLABLE KID) */
    {{'\xed', '\x82', '\xad'}, 3, 0xD0AD}, /* (HANGUL SYLLABLE KILG) */
    {{'\xed', '\x82', '\xae'}, 3, 0xD0AE}, /* (HANGUL SYLLABLE KILM) */
    {{'\xed', '\x82', '\xaf'}, 3, 0xD0AF}, /* (HANGUL SYLLABLE KILB) */
    {{'\xed', '\x82', '\xb0'}, 3, 0xD0B0}, /* (HANGUL SYLLABLE KILS) */
    {{'\xed', '\x82', '\xb1'}, 3, 0xD0B1}, /* (HANGUL SYLLABLE KILT) */
    {{'\xed', '\x82', '\xb2'}, 3, 0xD0B2}, /* (HANGUL SYLLABLE KILP) */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{'\xed', '\x82', '\xb3'}, 3, 0xD0B3}, /* (HANGUL SYLLABLE KILH) */
    {{'\xed', '\x82', '\xb6'}, 3, 0xD0B6}, /* (HANGUL SYLLABLE KIBS) */
    {{'\xed', '\x82', '\xb8'}, 3, 0xD0B8}, /* (HANGUL SYLLABLE KISS) */
    {{'\xed', '\x82', '\xba'}, 3, 0xD0BA}, /* (HANGUL SYLLABLE KIJ) */
    {{'\xed', '\x82', '\xbb'}, 3, 0xD0BB}, /* (HANGUL SYLLABLE KIC) */
    {{'\xed', '\x82', '\xbc'}, 3, 0xD0BC}, /* (HANGUL SYLLABLE KIK) */
    {{'\xed', '\x82', '\xbd'}, 3, 0xD0BD}, /* (HANGUL SYLLABLE KIT) */
    {{'\xed', '\x82', '\xbe'}, 3, 0xD0BE}, /* (HANGUL SYLLABLE KIP) */
    {{'\xed', '\x82', '\xbf'}, 3, 0xD0BF}, /* (HANGUL SYLLABLE KIH) */
    {{'\xed', '\x83', '\x82'}, 3, 0xD0C2}, /* (HANGUL SYLLABLE TAGG) */
    {{'\xed', '\x83', '\x83'}, 3, 0xD0C3}, /* (HANGUL SYLLABLE TAGS) */
    {{'\xed', '\x83', '\x85'}, 3, 0xD0C5}, /* (HANGUL SYLLABLE TANJ) */
    {{'\xed', '\x83', '\x86'}, 3, 0xD0C6}, /* (HANGUL SYLLABLE TANH) */
    {{'\xed', '\x83', '\x87'}, 3, 0xD0C7}, /* (HANGUL SYLLABLE TAD) */
    {{'\xed', '\x83', '\x8a'}, 3, 0xD0CA}, /* (HANGUL SYLLABLE TALM) */
    {{'\xed', '\x83', '\x8b'}, 3, 0xD0CB}, /* (HANGUL SYLLABLE TALB) */
    {{'\xed', '\x83', '\x8c'}, 3, 0xD0CC}, /* (HANGUL SYLLABLE TALS) */
    {{'\xed', '\x83', '\x8d'}, 3, 0xD0CD}, /* (HANGUL SYLLABLE TALT) */
    {{'\xed', '\x83', '\x8e'}, 3, 0xD0CE}, /* (HANGUL SYLLABLE TALP) */
    {{'\xed', '\x83', '\x8f'}, 3, 0xD0CF}, /* (HANGUL SYLLABLE TALH) */
    {{'\xed', '\x83', '\x92'}, 3, 0xD0D2}, /* (HANGUL SYLLABLE TABS) */
    {{'\xed', '\x83', '\x96'}, 3, 0xD0D6}, /* (HANGUL SYLLABLE TAJ) */
    {{'\xed', '\x83', '\x97'}, 3, 0xD0D7}, /* (HANGUL SYLLABLE TAC) */
    {{'\xed', '\x83', '\x98'}, 3, 0xD0D8}, /* (HANGUL SYLLABLE TAK) */
    {{'\xed', '\x83', '\x99'}, 3, 0xD0D9}, /* (HANGUL SYLLABLE TAT) */
    {{'\xed', '\x83', '\x9a'}, 3, 0xD0DA}, /* (HANGUL SYLLABLE TAP) */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{'\xed', '\x83', '\x9b'}, 3, 0xD0DB}, /* (HANGUL SYLLABLE TAH) */
    {{'\xed', '\x83', '\x9e'}, 3, 0xD0DE}, /* (HANGUL SYLLABLE TAEGG) */
    {{'\xed', '\x83', '\x9f'}, 3, 0xD0DF}, /* (HANGUL SYLLABLE TAEGS) */
    {{'\xed', '\x83', '\xa1'}, 3, 0xD0E1}, /* (HANGUL SYLLABLE TAENJ) */
    {{'\xed', '\x83', '\xa2'}, 3, 0xD0E2}, /* (HANGUL SYLLABLE TAENH) */
    {{'\xed', '\x83', '\xa3'}, 3, 0xD0E3}, /* (HANGUL SYLLABLE TAED) */
    {{'\xed', '\x83', '\xa5'}, 3, 0xD0E5}, /* (HANGUL SYLLABLE TAELG) */
    {{'\xed', '\x83', '\xa6'}, 3, 0xD0E6}, /* (HANGUL SYLLABLE TAELM) */
    {{'\xed', '\x83', '\xa7'}, 3, 0xD0E7}, /* (HANGUL SYLLABLE TAELB) */
    {{'\xed', '\x83', '\xa8'}, 3, 0xD0E8}, /* (HANGUL SYLLABLE TAELS) */
    {{'\xed', '\x83', '\xa9'}, 3, 0xD0E9}, /* (HANGUL SYLLABLE TAELT) */
    {{'\xed', '\x83', '\xaa'}, 3, 0xD0EA}, /* (HANGUL SYLLABLE TAELP) */
    {{'\xed', '\x83', '\xab'}, 3, 0xD0EB}, /* (HANGUL SYLLABLE TAELH) */
    {{'\xed', '\x83', '\xae'}, 3, 0xD0EE}, /* (HANGUL SYLLABLE TAEBS) */
    {{'\xed', '\x83', '\xb2'}, 3, 0xD0F2}, /* (HANGUL SYLLABLE TAEJ) */
    {{'\xed', '\x83', '\xb3'}, 3, 0xD0F3}, /* (HANGUL SYLLABLE TAEC) */
    {{'\xed', '\x83', '\xb4'}, 3, 0xD0F4}, /* (HANGUL SYLLABLE TAEK) */
    {{'\xed', '\x83', '\xb5'}, 3, 0xD0F5}, /* (HANGUL SYLLABLE TAET) */
    {{'\xed', '\x83', '\xb6'}, 3, 0xD0F6}, /* (HANGUL SYLLABLE TAEP) */
    {{'\xed', '\x83', '\xb7'}, 3, 0xD0F7}, /* (HANGUL SYLLABLE TAEH) */
    {{'\xed', '\x83', '\xb9'}, 3, 0xD0F9}, /* (HANGUL SYLLABLE TYAG) */
    {{'\xed', '\x83', '\xba'}, 3, 0xD0FA}, /* (HANGUL SYLLABLE TYAGG) */
    {{'\xed', '\x83', '\xbb'}, 3, 0xD0FB}, /* (HANGUL SYLLABLE TYAGS) */
    {{'\xed', '\x83', '\xbc'}, 3, 0xD0FC}, /* (HANGUL SYLLABLE TYAN) */
    {{'\xed', '\x83', '\xbd'}, 3, 0xD0FD}, /* (HANGUL SYLLABLE TYANJ) */
    {{'\xed', '\x83', '\xbe'}, 3, 0xD0FE}, /* (HANGUL SYLLABLE TYANH) */
    {{'\xed', '\x83', '\xbf'}, 3, 0xD0FF}, /* (HANGUL SYLLABLE TYAD) */
    {{'\xed', '\x84', '\x80'}, 3, 0xD100}, /* (HANGUL SYLLABLE TYAL) */
    {{'\xed', '\x84', '\x81'}, 3, 0xD101}, /* (HANGUL SYLLABLE TYALG) */
    {{'\xed', '\x84', '\x82'}, 3, 0xD102}, /* (HANGUL SYLLABLE TYALM) */
    {{'\xed', '\x84', '\x83'}, 3, 0xD103}, /* (HANGUL SYLLABLE TYALB) */
    {{'\xed', '\x84', '\x84'}, 3, 0xD104}, /* (HANGUL SYLLABLE TYALS) */
    {{'\xeb', '\x8d', '\xa7'}, 3, 0xB367}, /* (HANGUL SYLLABLE DEOS) */
    {{'\xeb', '\x8d', '\xa9'}, 3, 0xB369}, /* (HANGUL SYLLABLE DEONG) */
    {{'\xeb', '\x8d', '\xab'}, 3, 0xB36B}, /* (HANGUL SYLLABLE DEOC) */
    {{'\xeb', '\x8d', '\xae'}, 3, 0xB36E}, /* (HANGUL SYLLABLE DEOP) */
    {{'\xeb', '\x8d', '\xb0'}, 3, 0xB370}, /* (HANGUL SYLLABLE DE) */
    {{'\xeb', '\x8d', '\xb1'}, 3, 0xB371}, /* (HANGUL SYLLABLE DEG) */
    {{'\xeb', '\x8d', '\xb4'}, 3, 0xB374}, /* (HANGUL SYLLABLE DEN) */
    {{'\xeb', '\x8d', '\xb8'}, 3, 0xB378}, /* (HANGUL SYLLABLE DEL) */
    {{'\xeb', '\x8e', '\x80'}, 3, 0xB380}, /* (HANGUL SYLLABLE DEM) */
    {{'\xeb', '\x8e', '\x81'}, 3, 0xB381}, /* (HANGUL SYLLABLE DEB) */
    {{'\xeb', '\x8e', '\x83'}, 3, 0xB383}, /* (HANGUL SYLLABLE DES) */
    {{'\xeb', '\x8e', '\x84'}, 3, 0xB384}, /* (HANGUL SYLLABLE DESS) */
    {{'\xeb', '\x8e', '\x85'}, 3, 0xB385}, /* (HANGUL SYLLABLE DENG) */
    {{'\xeb', '\x8e', '\x8c'}, 3, 0xB38C}, /* (HANGUL SYLLABLE DYEO) */
    {{'\xeb', '\x8e', '\x90'}, 3, 0xB390}, /* (HANGUL SYLLABLE DYEON) */
    {{'\xeb', '\x8e', '\x94'}, 3, 0xB394}, /* (HANGUL SYLLABLE DYEOL) */
    {{'\xeb', '\x8e', '\xa0'}, 3, 0xB3A0}, /* (HANGUL SYLLABLE DYEOSS) */
    {{'\xeb', '\x8e', '\xa1'}, 3, 0xB3A1}, /* (HANGUL SYLLABLE DYEONG) */
    {{'\xeb', '\x8e', '\xa8'}, 3, 0xB3A8}, /* (HANGUL SYLLABLE DYE) */
    {{'\xeb', '\x8e', '\xac'}, 3, 0xB3AC}, /* (HANGUL SYLLABLE DYEN) */
    {{'\xeb', '\x8f', '\x84'}, 3, 0xB3C4}, /* (HANGUL SYLLABLE DO) */
    {{'\xeb', '\x8f', '\x85'}, 3, 0xB3C5}, /* (HANGUL SYLLABLE DOG) */
    {{'\xeb', '\x8f', '\x88'}, 3, 0xB3C8}, /* (HANGUL SYLLABLE DON) */
    {{'\xeb', '\x8f', '\x8b'}, 3, 0xB3CB}, /* (HANGUL SYLLABLE DOD) */
    {{'\xeb', '\x8f', '\x8c'}, 3, 0xB3CC}, /* (HANGUL SYLLABLE DOL) */
    {{'\xeb', '\x8f', '\x8e'}, 3, 0xB3CE}, /* (HANGUL SYLLABLE DOLM) */
    {{'\xeb', '\x8f', '\x90'}, 3, 0xB3D0}, /* (HANGUL SYLLABLE DOLS) */
    {{'\xeb', '\x8f', '\x94'}, 3, 0xB3D4}, /* (HANGUL SYLLABLE DOM) */
    {{'\xeb', '\x8f', '\x95'}, 3, 0xB3D5}, /* (HANGUL SYLLABLE DOB) */
    {{'\xeb', '\x8f', '\x97'}, 3, 0xB3D7}, /* (HANGUL SYLLABLE DOS) */
    {{'\xeb', '\x8f', '\x99'}, 3, 0xB3D9}, /* (HANGUL SYLLABLE DONG) */
    {{'\xeb', '\x8f', '\x9b'}, 3, 0xB3DB}, /* (HANGUL SYLLABLE DOC) */
    {{'\xeb', '\x8f', '\x9d'}, 3, 0xB3DD}, /* (HANGUL SYLLABLE DOT) */
    {{'\xeb', '\x8f', '\xa0'}, 3, 0xB3E0}, /* (HANGUL SYLLABLE DWA) */
    {{'\xeb', '\x8f', '\xa4'}, 3, 0xB3E4}, /* (HANGUL SYLLABLE DWAN) */
    {{'\xeb', '\x8f', '\xa8'}, 3, 0xB3E8}, /* (HANGUL SYLLABLE DWAL) */
    {{'\xeb', '\x8f', '\xbc'}, 3, 0xB3FC}, /* (HANGUL SYLLABLE DWAE) */
    {{'\xeb', '\x90', '\x90'}, 3, 0xB410}, /* (HANGUL SYLLABLE DWAESS) */
    {{'\xeb', '\x90', '\x98'}, 3, 0xB418}, /* (HANGUL SYLLABLE DOE) */
    {{'\xeb', '\x90', '\x9c'}, 3, 0xB41C}, /* (HANGUL SYLLABLE DOEN) */
    {{'\xeb', '\x90', '\xa0'}, 3, 0xB420}, /* (HANGUL SYLLABLE DOEL) */
    {{'\xeb', '\x90', '\xa8'}, 3, 0xB428}, /* (HANGUL SYLLABLE DOEM) */
    {{'\xeb', '\x90', '\xa9'}, 3, 0xB429}, /* (HANGUL SYLLABLE DOEB) */
    {{'\xeb', '\x90', '\xab'}, 3, 0xB42B}, /* (HANGUL SYLLABLE DOES) */
    {{'\xeb', '\x90', '\xb4'}, 3, 0xB434}, /* (HANGUL SYLLABLE DYO) */
    {{'\xeb', '\x91', '\x90'}, 3, 0xB450}, /* (HANGUL SYLLABLE DU) */
    {{'\xeb', '\x91', '\x91'}, 3, 0xB451}, /* (HANGUL SYLLABLE DUG) */
    {{'\xeb', '\x91', '\x94'}, 3, 0xB454}, /* (HANGUL SYLLABLE DUN) */
    {{'\xeb', '\x91', '\x98'}, 3, 0xB458}, /* (HANGUL SYLLABLE DUL) */
    {{'\xeb', '\x91', '\xa0'}, 3, 0xB460}, /* (HANGUL SYLLABLE DUM) */
    {{'\xeb', '\x91', '\xa1'}, 3, 0xB461}, /* (HANGUL SYLLABLE DUB) */
    {{'\xeb', '\x91', '\xa3'}, 3, 0xB463}, /* (HANGUL SYLLABLE DUS) */
    {{'\xeb', '\x91', '\xa5'}, 3, 0xB465}, /* (HANGUL SYLLABLE DUNG) */
    {{'\xeb', '\x91', '\xac'}, 3, 0xB46C}, /* (HANGUL SYLLABLE DWEO) */
    {{'\xeb', '\x92', '\x80'}, 3, 0xB480}, /* (HANGUL SYLLABLE DWEOSS) */
    {{'\xeb', '\x92', '\x88'}, 3, 0xB488}, /* (HANGUL SYLLABLE DWE) */
    {{'\xeb', '\x92', '\x9d'}, 3, 0xB49D}, /* (HANGUL SYLLABLE DWENG) */
    {{'\xeb', '\x92', '\xa4'}, 3, 0xB4A4}, /* (HANGUL SYLLABLE DWI) */
    {{'\xeb', '\x92', '\xa8'}, 3, 0xB4A8}, /* (HANGUL SYLLABLE DWIN) */
    {{'\xeb', '\x92', '\xac'}, 3, 0xB4AC}, /* (HANGUL SYLLABLE DWIL) */
    {{'\xeb', '\x92', '\xb5'}, 3, 0xB4B5}, /* (HANGUL SYLLABLE DWIB) */
    {{'\xeb', '\x92', '\xb7'}, 3, 0xB4B7}, /* (HANGUL SYLLABLE DWIS) */
    {{'\xeb', '\x92', '\xb9'}, 3, 0xB4B9}, /* (HANGUL SYLLABLE DWING) */
    {{'\xeb', '\x93', '\x80'}, 3, 0xB4C0}, /* (HANGUL SYLLABLE DYU) */
    {{'\xeb', '\x93', '\x84'}, 3, 0xB4C4}, /* (HANGUL SYLLABLE DYUN) */
    {{'\xeb', '\x93', '\x88'}, 3, 0xB4C8}, /* (HANGUL SYLLABLE DYUL) */
    {{'\xeb', '\x93', '\x90'}, 3, 0xB4D0}, /* (HANGUL SYLLABLE DYUM) */
    {{'\xeb', '\x93', '\x95'}, 3, 0xB4D5}, /* (HANGUL SYLLABLE DYUNG) */
    {{'\xeb', '\x93', '\x9c'}, 3, 0xB4DC}, /* (HANGUL SYLLABLE DEU) */
    {{'\xeb', '\x93', '\x9d'}, 3, 0xB4DD}, /* (HANGUL SYLLABLE DEUG) */
    {{'\xeb', '\x93', '\xa0'}, 3, 0xB4E0}, /* (HANGUL SYLLABLE DEUN) */
    {{'\xeb', '\x93', '\xa3'}, 3, 0xB4E3}, /* (HANGUL SYLLABLE DEUD) */
    {{'\xeb', '\x93', '\xa4'}, 3, 0xB4E4}, /* (HANGUL SYLLABLE DEUL) */
    {{'\xeb', '\x93', '\xa6'}, 3, 0xB4E6}, /* (HANGUL SYLLABLE DEULM) */
    {{'\xeb', '\x93', '\xac'}, 3, 0xB4EC}, /* (HANGUL SYLLABLE DEUM) */
    {{'\xeb', '\x93', '\xad'}, 3, 0xB4ED}, /* (HANGUL SYLLABLE DEUB) */
    {{'\xeb', '\x93', '\xaf'}, 3, 0xB4EF}, /* (HANGUL SYLLABLE DEUS) */
    {{'\xeb', '\x93', '\xb1'}, 3, 0xB4F1}, /* (HANGUL SYLLABLE DEUNG) */
    {{'\xeb', '\x93', '\xb8'}, 3, 0xB4F8}, /* (HANGUL SYLLABLE DYI) */
    {{'\xeb', '\x94', '\x94'}, 3, 0xB514}, /* (HANGUL SYLLABLE DI) */
    {{'\xeb', '\x94', '\x95'}, 3, 0xB515}, /* (HANGUL SYLLABLE DIG) */
    {{'\xeb', '\x94', '\x98'}, 3, 0xB518}, /* (HANGUL SYLLABLE DIN) */
    {{'\xeb', '\x94', '\x9b'}, 3, 0xB51B}, /* (HANGUL SYLLABLE DID) */
    {{'\xeb', '\x94', '\x9c'}, 3, 0xB51C}, /* (HANGUL SYLLABLE DIL) */
    {{'\xeb', '\x94', '\xa4'}, 3, 0xB524}, /* (HANGUL SYLLABLE DIM) */
    {{'\xeb', '\x94', '\xa5'}, 3, 0xB525}, /* (HANGUL SYLLABLE DIB) */
    {{'\xeb', '\x94', '\xa7'}, 3, 0xB527}, /* (HANGUL SYLLABLE DIS) */
    {{'\xeb', '\x94', '\xa8'}, 3, 0xB528}, /* (HANGUL SYLLABLE DISS) */
    {{'\xeb', '\x94', '\xa9'}, 3, 0xB529}, /* (HANGUL SYLLABLE DING) */
    {{'\xeb', '\x94', '\xaa'}, 3, 0xB52A}, /* (HANGUL SYLLABLE DIJ) */
    {{'\xeb', '\x94', '\xb0'}, 3, 0xB530}, /* (HANGUL SYLLABLE DDA) */
    {{'\xeb', '\x94', '\xb1'}, 3, 0xB531}, /* (HANGUL SYLLABLE DDAG) */
    {{'\xeb', '\x94', '\xb4'}, 3, 0xB534}, /* (HANGUL SYLLABLE DDAN) */
    {{'\xeb', '\x94', '\xb8'}, 3, 0xB538}, /* (HANGUL SYLLABLE DDAL) */
    {{'\xed', '\x84', '\x85'}, 3, 0xD105}, /* (HANGUL SYLLABLE TYALT) */
    {{'\xed', '\x84', '\x86'}, 3, 0xD106}, /* (HANGUL SYLLABLE TYALP) */
    {{'\xed', '\x84', '\x87'}, 3, 0xD107}, /* (HANGUL SYLLABLE TYALH) */
    {{'\xed', '\x84', '\x88'}, 3, 0xD108}, /* (HANGUL SYLLABLE TYAM) */
    {{'\xed', '\x84', '\x89'}, 3, 0xD109}, /* (HANGUL SYLLABLE TYAB) */
    {{'\xed', '\x84', '\x8a'}, 3, 0xD10A}, /* (HANGUL SYLLABLE TYABS) */
    {{'\xed', '\x84', '\x8b'}, 3, 0xD10B}, /* (HANGUL SYLLABLE TYAS) */
    {{'\xed', '\x84', '\x8c'}, 3, 0xD10C}, /* (HANGUL SYLLABLE TYASS) */
    {{'\xed', '\x84', '\x8e'}, 3, 0xD10E}, /* (HANGUL SYLLABLE TYAJ) */
    {{'\xed', '\x84', '\x8f'}, 3, 0xD10F}, /* (HANGUL SYLLABLE TYAC) */
    {{'\xed', '\x84', '\x90'}, 3, 0xD110}, /* (HANGUL SYLLABLE TYAK) */
    {{'\xed', '\x84', '\x91'}, 3, 0xD111}, /* (HANGUL SYLLABLE TYAT) */
    {{'\xed', '\x84', '\x92'}, 3, 0xD112}, /* (HANGUL SYLLABLE TYAP) */
    {{'\xed', '\x84', '\x93'}, 3, 0xD113}, /* (HANGUL SYLLABLE TYAH) */
    {{'\xed', '\x84', '\x94'}, 3, 0xD114}, /* (HANGUL SYLLABLE TYAE) */
    {{'\xed', '\x84', '\x95'}, 3, 0xD115}, /* (HANGUL SYLLABLE TYAEG) */
    {{'\xed', '\x84', '\x96'}, 3, 0xD116}, /* (HANGUL SYLLABLE TYAEGG) */
    {{'\xed', '\x84', '\x97'}, 3, 0xD117}, /* (HANGUL SYLLABLE TYAEGS) */
    {{'\xed', '\x84', '\x98'}, 3, 0xD118}, /* (HANGUL SYLLABLE TYAEN) */
    {{'\xed', '\x84', '\x99'}, 3, 0xD119}, /* (HANGUL SYLLABLE TYAENJ) */
    {{'\xed', '\x84', '\x9a'}, 3, 0xD11A}, /* (HANGUL SYLLABLE TYAENH) */
    {{'\xed', '\x84', '\x9b'}, 3, 0xD11B}, /* (HANGUL SYLLABLE TYAED) */
    {{'\xed', '\x84', '\x9c'}, 3, 0xD11C}, /* (HANGUL SYLLABLE TYAEL) */
    {{'\xed', '\x84', '\x9d'}, 3, 0xD11D}, /* (HANGUL SYLLABLE TYAELG) */
    {{'\xed', '\x84', '\x9e'}, 3, 0xD11E}, /* (HANGUL SYLLABLE TYAELM) */
    {{'\xed', '\x84', '\x9f'}, 3, 0xD11F}, /* (HANGUL SYLLABLE TYAELB) */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{'\xed', '\x84', '\xa0'}, 3, 0xD120}, /* (HANGUL SYLLABLE TYAELS) */
    {{'\xed', '\x84', '\xa1'}, 3, 0xD121}, /* (HANGUL SYLLABLE TYAELT) */
    {{'\xed', '\x84', '\xa2'}, 3, 0xD122}, /* (HANGUL SYLLABLE TYAELP) */
    {{'\xed', '\x84', '\xa3'}, 3, 0xD123}, /* (HANGUL SYLLABLE TYAELH) */
    {{'\xed', '\x84', '\xa4'}, 3, 0xD124}, /* (HANGUL SYLLABLE TYAEM) */
    {{'\xed', '\x84', '\xa5'}, 3, 0xD125}, /* (HANGUL SYLLABLE TYAEB) */
    {{'\xed', '\x84', '\xa6'}, 3, 0xD126}, /* (HANGUL SYLLABLE TYAEBS) */
    {{'\xed', '\x84', '\xa7'}, 3, 0xD127}, /* (HANGUL SYLLABLE TYAES) */
    {{'\xed', '\x84', '\xa8'}, 3, 0xD128}, /* (HANGUL SYLLABLE TYAESS) */
    {{'\xed', '\x84', '\xa9'}, 3, 0xD129}, /* (HANGUL SYLLABLE TYAENG) */
    {{'\xed', '\x84', '\xaa'}, 3, 0xD12A}, /* (HANGUL SYLLABLE TYAEJ) */
    {{'\xed', '\x84', '\xab'}, 3, 0xD12B}, /* (HANGUL SYLLABLE TYAEC) */
    {{'\xed', '\x84', '\xac'}, 3, 0xD12C}, /* (HANGUL SYLLABLE TYAEK) */
    {{'\xed', '\x84', '\xad'}, 3, 0xD12D}, /* (HANGUL SYLLABLE TYAET) */
    {{'\xed', '\x84', '\xae'}, 3, 0xD12E}, /* (HANGUL SYLLABLE TYAEP) */
    {{'\xed', '\x84', '\xaf'}, 3, 0xD12F}, /* (HANGUL SYLLABLE TYAEH) */
    {{'\xed', '\x84', '\xb2'}, 3, 0xD132}, /* (HANGUL SYLLABLE TEOGG) */
    {{'\xed', '\x84', '\xb3'}, 3, 0xD133}, /* (HANGUL SYLLABLE TEOGS) */
    {{'\xed', '\x84', '\xb5'}, 3, 0xD135}, /* (HANGUL SYLLABLE TEONJ) */
    {{'\xed', '\x84', '\xb6'}, 3, 0xD136}, /* (HANGUL SYLLABLE TEONH) */
    {{'\xed', '\x84', '\xb7'}, 3, 0xD137}, /* (HANGUL SYLLABLE TEOD) */
    {{'\xed', '\x84', '\xb9'}, 3, 0xD139}, /* (HANGUL SYLLABLE TEOLG) */
    {{'\xed', '\x84', '\xbb'}, 3, 0xD13B}, /* (HANGUL SYLLABLE TEOLB) */
    {{'\xed', '\x84', '\xbc'}, 3, 0xD13C}, /* (HANGUL SYLLABLE TEOLS) */
    {{'\xed', '\x84', '\xbd'}, 3, 0xD13D}, /* (HANGUL SYLLABLE TEOLT) */
    {{'\xed', '\x84', '\xbe'}, 3, 0xD13E}, /* (HANGUL SYLLABLE TEOLP) */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{'\xed', '\x84', '\xbf'}, 3, 0xD13F}, /* (HANGUL SYLLABLE TEOLH) */
    {{'\xed', '\x85', '\x82'}, 3, 0xD142}, /* (HANGUL SYLLABLE TEOBS) */
    {{'\xed', '\x85', '\x86'}, 3, 0xD146}, /* (HANGUL SYLLABLE TEOJ) */
    {{'\xed', '\x85', '\x87'}, 3, 0xD147}, /* (HANGUL SYLLABLE TEOC) */
    {{'\xed', '\x85', '\x88'}, 3, 0xD148}, /* (HANGUL SYLLABLE TEOK) */
    {{'\xed', '\x85', '\x89'}, 3, 0xD149}, /* (HANGUL SYLLABLE TEOT) */
    {{'\xed', '\x85', '\x8a'}, 3, 0xD14A}, /* (HANGUL SYLLABLE TEOP) */
    {{'\xed', '\x85', '\x8b'}, 3, 0xD14B}, /* (HANGUL SYLLABLE TEOH) */
    {{'\xed', '\x85', '\x8e'}, 3, 0xD14E}, /* (HANGUL SYLLABLE TEGG) */
    {{'\xed', '\x85', '\x8f'}, 3, 0xD14F}, /* (HANGUL SYLLABLE TEGS) */
    {{'\xed', '\x85', '\x91'}, 3, 0xD151}, /* (HANGUL SYLLABLE TENJ) */
    {{'\xed', '\x85', '\x92'}, 3, 0xD152}, /* (HANGUL SYLLABLE TENH) */
    {{'\xed', '\x85', '\x93'}, 3, 0xD153}, /* (HANGUL SYLLABLE TED) */
    {{'\xed', '\x85', '\x95'}, 3, 0xD155}, /* (HANGUL SYLLABLE TELG) */
    {{'\xed', '\x85', '\x96'}, 3, 0xD156}, /* (HANGUL SYLLABLE TELM) */
    {{'\xed', '\x85', '\x97'}, 3, 0xD157}, /* (HANGUL SYLLABLE TELB) */
    {{'\xed', '\x85', '\x98'}, 3, 0xD158}, /* (HANGUL SYLLABLE TELS) */
    {{'\xed', '\x85', '\x99'}, 3, 0xD159}, /* (HANGUL SYLLABLE TELT) */
    {{'\xed', '\x85', '\x9a'}, 3, 0xD15A}, /* (HANGUL SYLLABLE TELP) */
    {{'\xed', '\x85', '\x9b'}, 3, 0xD15B}, /* (HANGUL SYLLABLE TELH) */
    {{'\xed', '\x85', '\x9e'}, 3, 0xD15E}, /* (HANGUL SYLLABLE TEBS) */
    {{'\xed', '\x85', '\xa0'}, 3, 0xD160}, /* (HANGUL SYLLABLE TESS) */
    {{'\xed', '\x85', '\xa2'}, 3, 0xD162}, /* (HANGUL SYLLABLE TEJ) */
    {{'\xed', '\x85', '\xa3'}, 3, 0xD163}, /* (HANGUL SYLLABLE TEC) */
    {{'\xed', '\x85', '\xa4'}, 3, 0xD164}, /* (HANGUL SYLLABLE TEK) */
    {{'\xed', '\x85', '\xa5'}, 3, 0xD165}, /* (HANGUL SYLLABLE TET) */
    {{'\xed', '\x85', '\xa6'}, 3, 0xD166}, /* (HANGUL SYLLABLE TEP) */
    {{'\xed', '\x85', '\xa7'}, 3, 0xD167}, /* (HANGUL SYLLABLE TEH) */
    {{'\xed', '\x85', '\xa9'}, 3, 0xD169}, /* (HANGUL SYLLABLE TYEOG) */
    {{'\xed', '\x85', '\xaa'}, 3, 0xD16A}, /* (HANGUL SYLLABLE TYEOGG) */
    {{'\xed', '\x85', '\xab'}, 3, 0xD16B}, /* (HANGUL SYLLABLE TYEOGS) */
    {{'\xed', '\x85', '\xad'}, 3, 0xD16D}, /* (HANGUL SYLLABLE TYEONJ) */
    {{'\xeb', '\x95', '\x80'}, 3, 0xB540}, /* (HANGUL SYLLABLE DDAM) */
    {{'\xeb', '\x95', '\x81'}, 3, 0xB541}, /* (HANGUL SYLLABLE DDAB) */
    {{'\xeb', '\x95', '\x83'}, 3, 0xB543}, /* (HANGUL SYLLABLE DDAS) */
    {{'\xeb', '\x95', '\x84'}, 3, 0xB544}, /* (HANGUL SYLLABLE DDASS) */
    {{'\xeb', '\x95', '\x85'}, 3, 0xB545}, /* (HANGUL SYLLABLE DDANG) */
    {{'\xeb', '\x95', '\x8b'}, 3, 0xB54B}, /* (HANGUL SYLLABLE DDAH) */
    {{'\xeb', '\x95', '\x8c'}, 3, 0xB54C}, /* (HANGUL SYLLABLE DDAE) */
    {{'\xeb', '\x95', '\x8d'}, 3, 0xB54D}, /* (HANGUL SYLLABLE DDAEG) */
    {{'\xeb', '\x95', '\x90'}, 3, 0xB550}, /* (HANGUL SYLLABLE DDAEN) */
    {{'\xeb', '\x95', '\x94'}, 3, 0xB554}, /* (HANGUL SYLLABLE DDAEL) */
    {{'\xeb', '\x95', '\x9c'}, 3, 0xB55C}, /* (HANGUL SYLLABLE DDAEM) */
    {{'\xeb', '\x95', '\x9d'}, 3, 0xB55D}, /* (HANGUL SYLLABLE DDAEB) */
    {{'\xeb', '\x95', '\x9f'}, 3, 0xB55F}, /* (HANGUL SYLLABLE DDAES) */
    {{'\xeb', '\x95', '\xa0'}, 3, 0xB560}, /* (HANGUL SYLLABLE DDAESS) */
    {{'\xeb', '\x95', '\xa1'}, 3, 0xB561}, /* (HANGUL SYLLABLE DDAENG) */
    {{'\xeb', '\x96', '\xa0'}, 3, 0xB5A0}, /* (HANGUL SYLLABLE DDEO) */
    {{'\xeb', '\x96', '\xa1'}, 3, 0xB5A1}, /* (HANGUL SYLLABLE DDEOG) */
    {{'\xeb', '\x96', '\xa4'}, 3, 0xB5A4}, /* (HANGUL SYLLABLE DDEON) */
    {{'\xeb', '\x96', '\xa8'}, 3, 0xB5A8}, /* (HANGUL SYLLABLE DDEOL) */
    {{'\xeb', '\x96', '\xaa'}, 3, 0xB5AA}, /* (HANGUL SYLLABLE DDEOLM) */
    {{'\xeb', '\x96', '\xab'}, 3, 0xB5AB}, /* (HANGUL SYLLABLE DDEOLB) */
    {{'\xeb', '\x96', '\xb0'}, 3, 0xB5B0}, /* (HANGUL SYLLABLE DDEOM) */
    {{'\xeb', '\x96', '\xb1'}, 3, 0xB5B1}, /* (HANGUL SYLLABLE DDEOB) */
    {{'\xeb', '\x96', '\xb3'}, 3, 0xB5B3}, /* (HANGUL SYLLABLE DDEOS) */
    {{'\xeb', '\x96', '\xb4'}, 3, 0xB5B4}, /* (HANGUL SYLLABLE DDEOSS) */
    {{'\xeb', '\x96', '\xb5'}, 3, 0xB5B5}, /* (HANGUL SYLLABLE DDEONG) */
    {{'\xeb', '\x96', '\xbb'}, 3, 0xB5BB}, /* (HANGUL SYLLABLE DDEOH) */
    {{'\xeb', '\x96', '\xbc'}, 3, 0xB5BC}, /* (HANGUL SYLLABLE DDE) */
    {{'\xeb', '\x96', '\xbd'}, 3, 0xB5BD}, /* (HANGUL SYLLABLE DDEG) */
    {{'\xeb', '\x97', '\x80'}, 3, 0xB5C0}, /* (HANGUL SYLLABLE DDEN) */
    {{'\xeb', '\x97', '\x84'}, 3, 0xB5C4}, /* (HANGUL SYLLABLE DDEL) */
    {{'\xeb', '\x97', '\x8c'}, 3, 0xB5CC}, /* (HANGUL SYLLABLE DDEM) */
    {{'\xeb', '\x97', '\x8d'}, 3, 0xB5CD}, /* (HANGUL SYLLABLE DDEB) */
    {{'\xeb', '\x97', '\x8f'}, 3, 0xB5CF}, /* (HANGUL SYLLABLE DDES) */
    {{'\xeb', '\x97', '\x90'}, 3, 0xB5D0}, /* (HANGUL SYLLABLE DDESS) */
    {{'\xeb', '\x97', '\x91'}, 3, 0xB5D1}, /* (HANGUL SYLLABLE DDENG) */
    {{'\xeb', '\x97', '\x98'}, 3, 0xB5D8}, /* (HANGUL SYLLABLE DDYEO) */
    {{'\xeb', '\x97', '\xac'}, 3, 0xB5EC}, /* (HANGUL SYLLABLE DDYEOSS) */
    {{'\xeb', '\x98', '\x90'}, 3, 0xB610}, /* (HANGUL SYLLABLE DDO) */
    {{'\xeb', '\x98', '\x91'}, 3, 0xB611}, /* (HANGUL SYLLABLE DDOG) */
    {{'\xeb', '\x98', '\x94'}, 3, 0xB614}, /* (HANGUL SYLLABLE DDON) */
    {{'\xeb', '\x98', '\x98'}, 3, 0xB618}, /* (HANGUL SYLLABLE DDOL) */
    {{'\xeb', '\x98', '\xa5'}, 3, 0xB625}, /* (HANGUL SYLLABLE DDONG) */
    {{'\xeb', '\x98', '\xac'}, 3, 0xB62C}, /* (HANGUL SYLLABLE DDWA) */
    {{'\xeb', '\x98', '\xb4'}, 3, 0xB634}, /* (HANGUL SYLLABLE DDWAL) */
    {{'\xeb', '\x99', '\x88'}, 3, 0xB648}, /* (HANGUL SYLLABLE DDWAE) */
    {{'\xeb', '\x99', '\xa4'}, 3, 0xB664}, /* (HANGUL SYLLABLE DDOE) */
    {{'\xeb', '\x99', '\xa8'}, 3, 0xB668}, /* (HANGUL SYLLABLE DDOEN) */
    {{'\xeb', '\x9a', '\x9c'}, 3, 0xB69C}, /* (HANGUL SYLLABLE DDU) */
    {{'\xeb', '\x9a', '\x9d'}, 3, 0xB69D}, /* (HANGUL SYLLABLE DDUG) */
    {{'\xeb', '\x9a', '\xa0'}, 3, 0xB6A0}, /* (HANGUL SYLLABLE DDUN) */
    {{'\xeb', '\x9a', '\xa4'}, 3, 0xB6A4}, /* (HANGUL SYLLABLE DDUL) */
    {{'\xeb', '\x9a', '\xab'}, 3, 0xB6AB}, /* (HANGUL SYLLABLE DDULH) */
    {{'\xeb', '\x9a', '\xac'}, 3, 0xB6AC}, /* (HANGUL SYLLABLE DDUM) */
    {{'\xeb', '\x9a', '\xb1'}, 3, 0xB6B1}, /* (HANGUL SYLLABLE DDUNG) */
    {{'\xeb', '\x9b', '\x94'}, 3, 0xB6D4}, /* (HANGUL SYLLABLE DDWE) */
    {{'\xeb', '\x9b', '\xb0'}, 3, 0xB6F0}, /* (HANGUL SYLLABLE DDWI) */
    {{'\xeb', '\x9b', '\xb4'}, 3, 0xB6F4}, /* (HANGUL SYLLABLE DDWIN) */
    {{'\xeb', '\x9b', '\xb8'}, 3, 0xB6F8}, /* (HANGUL SYLLABLE DDWIL) */
    {{'\xeb', '\x9c', '\x80'}, 3, 0xB700}, /* (HANGUL SYLLABLE DDWIM) */
    {{'\xeb', '\x9c', '\x81'}, 3, 0xB701}, /* (HANGUL SYLLABLE DDWIB) */
    {{'\xeb', '\x9c', '\x85'}, 3, 0xB705}, /* (HANGUL SYLLABLE DDWING) */
    {{'\xeb', '\x9c', '\xa8'}, 3, 0xB728}, /* (HANGUL SYLLABLE DDEU) */
    {{'\xeb', '\x9c', '\xa9'}, 3, 0xB729}, /* (HANGUL SYLLABLE DDEUG) */
    {{'\xeb', '\x9c', '\xac'}, 3, 0xB72C}, /* (HANGUL SYLLABLE DDEUN) */
    {{'\xeb', '\x9c', '\xaf'}, 3, 0xB72F}, /* (HANGUL SYLLABLE DDEUD) */
    {{'\xeb', '\x9c', '\xb0'}, 3, 0xB730}, /* (HANGUL SYLLABLE DDEUL) */
    {{'\xeb', '\x9c', '\xb8'}, 3, 0xB738}, /* (HANGUL SYLLABLE DDEUM) */
    {{'\xeb', '\x9c', '\xb9'}, 3, 0xB739}, /* (HANGUL SYLLABLE DDEUB) */
    {{'\xeb', '\x9c', '\xbb'}, 3, 0xB73B}, /* (HANGUL SYLLABLE DDEUS) */
    {{'\xeb', '\x9d', '\x84'}, 3, 0xB744}, /* (HANGUL SYLLABLE DDYI) */
    {{'\xeb', '\x9d', '\x88'}, 3, 0xB748}, /* (HANGUL SYLLABLE DDYIN) */
    {{'\xeb', '\x9d', '\x8c'}, 3, 0xB74C}, /* (HANGUL SYLLABLE DDYIL) */
    {{'\xeb', '\x9d', '\x94'}, 3, 0xB754}, /* (HANGUL SYLLABLE DDYIM) */
    {{'\xeb', '\x9d', '\x95'}, 3, 0xB755}, /* (HANGUL SYLLABLE DDYIB) */
    {{'\xeb', '\x9d', '\xa0'}, 3, 0xB760}, /* (HANGUL SYLLABLE DDI) */
    {{'\xeb', '\x9d', '\xa4'}, 3, 0xB764}, /* (HANGUL SYLLABLE DDIN) */
    {{'\xeb', '\x9d', '\xa8'}, 3, 0xB768}, /* (HANGUL SYLLABLE DDIL) */
    {{'\xeb', '\x9d', '\xb0'}, 3, 0xB770}, /* (HANGUL SYLLABLE DDIM) */
    {{'\xeb', '\x9d', '\xb1'}, 3, 0xB771}, /* (HANGUL SYLLABLE DDIB) */
    {{'\xeb', '\x9d', '\xb3'}, 3, 0xB773}, /* (HANGUL SYLLABLE DDIS) */
    {{'\xeb', '\x9d', '\xb5'}, 3, 0xB775}, /* (HANGUL SYLLABLE DDING) */
    {{'\xeb', '\x9d', '\xbc'}, 3, 0xB77C}, /* (HANGUL SYLLABLE RA) */
    {{'\xeb', '\x9d', '\xbd'}, 3, 0xB77D}, /* (HANGUL SYLLABLE RAG) */
    {{'\xeb', '\x9e', '\x80'}, 3, 0xB780}, /* (HANGUL SYLLABLE RAN) */
    {{'\xeb', '\x9e', '\x84'}, 3, 0xB784}, /* (HANGUL SYLLABLE RAL) */
    {{'\xeb', '\x9e', '\x8c'}, 3, 0xB78C}, /* (HANGUL SYLLABLE RAM) */
    {{'\xeb', '\x9e', '\x8d'}, 3, 0xB78D}, /* (HANGUL SYLLABLE RAB) */
    {{'\xeb', '\x9e', '\x8f'}, 3, 0xB78F}, /* (HANGUL SYLLABLE RAS) */
    {{'\xeb', '\x9e', '\x90'}, 3, 0xB790}, /* (HANGUL SYLLABLE RASS) */
    {{'\xeb', '\x9e', '\x91'}, 3, 0xB791}, /* (HANGUL SYLLABLE RANG) */
    {{'\xeb', '\x9e', '\x92'}, 3, 0xB792}, /* (HANGUL SYLLABLE RAJ) */
    {{'\xeb', '\x9e', '\x96'}, 3, 0xB796}, /* (HANGUL SYLLABLE RAP) */
    {{'\xeb', '\x9e', '\x97'}, 3, 0xB797}, /* (HANGUL SYLLABLE RAH) */
    {{'\xed', '\x85', '\xae'}, 3, 0xD16E}, /* (HANGUL SYLLABLE TYEONH) */
    {{'\xed', '\x85', '\xaf'}, 3, 0xD16F}, /* (HANGUL SYLLABLE TYEOD) */
    {{'\xed', '\x85', '\xb0'}, 3, 0xD170}, /* (HANGUL SYLLABLE TYEOL) */
    {{'\xed', '\x85', '\xb1'}, 3, 0xD171}, /* (HANGUL SYLLABLE TYEOLG) */
    {{'\xed', '\x85', '\xb2'}, 3, 0xD172}, /* (HANGUL SYLLABLE TYEOLM) */
    {{'\xed', '\x85', '\xb3'}, 3, 0xD173}, /* (HANGUL SYLLABLE TYEOLB) */
    {{'\xed', '\x85', '\xb4'}, 3, 0xD174}, /* (HANGUL SYLLABLE TYEOLS) */
    {{'\xed', '\x85', '\xb5'}, 3, 0xD175}, /* (HANGUL SYLLABLE TYEOLT) */
    {{'\xed', '\x85', '\xb6'}, 3, 0xD176}, /* (HANGUL SYLLABLE TYEOLP) */
    {{'\xed', '\x85', '\xb7'}, 3, 0xD177}, /* (HANGUL SYLLABLE TYEOLH) */
    {{'\xed', '\x85', '\xb8'}, 3, 0xD178}, /* (HANGUL SYLLABLE TYEOM) */
    {{'\xed', '\x85', '\xb9'}, 3, 0xD179}, /* (HANGUL SYLLABLE TYEOB) */
    {{'\xed', '\x85', '\xba'}, 3, 0xD17A}, /* (HANGUL SYLLABLE TYEOBS) */
    {{'\xed', '\x85', '\xbb'}, 3, 0xD17B}, /* (HANGUL SYLLABLE TYEOS) */
    {{'\xed', '\x85', '\xbd'}, 3, 0xD17D}, /* (HANGUL SYLLABLE TYEONG) */
    {{'\xed', '\x85', '\xbe'}, 3, 0xD17E}, /* (HANGUL SYLLABLE TYEOJ) */
    {{'\xed', '\x85', '\xbf'}, 3, 0xD17F}, /* (HANGUL SYLLABLE TYEOC) */
    {{'\xed', '\x86', '\x80'}, 3, 0xD180}, /* (HANGUL SYLLABLE TYEOK) */
    {{'\xed', '\x86', '\x81'}, 3, 0xD181}, /* (HANGUL SYLLABLE TYEOT) */
    {{'\xed', '\x86', '\x82'}, 3, 0xD182}, /* (HANGUL SYLLABLE TYEOP) */
    {{'\xed', '\x86', '\x83'}, 3, 0xD183}, /* (HANGUL SYLLABLE TYEOH) */
    {{'\xed', '\x86', '\x85'}, 3, 0xD185}, /* (HANGUL SYLLABLE TYEG) */
    {{'\xed', '\x86', '\x86'}, 3, 0xD186}, /* (HANGUL SYLLABLE TYEGG) */
    {{'\xed', '\x86', '\x87'}, 3, 0xD187}, /* (HANGUL SYLLABLE TYEGS) */
    {{'\xed', '\x86', '\x89'}, 3, 0xD189}, /* (HANGUL SYLLABLE TYENJ) */
    {{'\xed', '\x86', '\x8a'}, 3, 0xD18A}, /* (HANGUL SYLLABLE TYENH) */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{'\xed', '\x86', '\x8b'}, 3, 0xD18B}, /* (HANGUL SYLLABLE TYED) */
    {{'\xed', '\x86', '\x8c'}, 3, 0xD18C}, /* (HANGUL SYLLABLE TYEL) */
    {{'\xed', '\x86', '\x8d'}, 3, 0xD18D}, /* (HANGUL SYLLABLE TYELG) */
    {{'\xed', '\x86', '\x8e'}, 3, 0xD18E}, /* (HANGUL SYLLABLE TYELM) */
    {{'\xed', '\x86', '\x8f'}, 3, 0xD18F}, /* (HANGUL SYLLABLE TYELB) */
    {{'\xed', '\x86', '\x90'}, 3, 0xD190}, /* (HANGUL SYLLABLE TYELS) */
    {{'\xed', '\x86', '\x91'}, 3, 0xD191}, /* (HANGUL SYLLABLE TYELT) */
    {{'\xed', '\x86', '\x92'}, 3, 0xD192}, /* (HANGUL SYLLABLE TYELP) */
    {{'\xed', '\x86', '\x93'}, 3, 0xD193}, /* (HANGUL SYLLABLE TYELH) */
    {{'\xed', '\x86', '\x94'}, 3, 0xD194}, /* (HANGUL SYLLABLE TYEM) */
    {{'\xed', '\x86', '\x95'}, 3, 0xD195}, /* (HANGUL SYLLABLE TYEB) */
    {{'\xed', '\x86', '\x96'}, 3, 0xD196}, /* (HANGUL SYLLABLE TYEBS) */
    {{'\xed', '\x86', '\x97'}, 3, 0xD197}, /* (HANGUL SYLLABLE TYES) */
    {{'\xed', '\x86', '\x98'}, 3, 0xD198}, /* (HANGUL SYLLABLE TYESS) */
    {{'\xed', '\x86', '\x99'}, 3, 0xD199}, /* (HANGUL SYLLABLE TYENG) */
    {{'\xed', '\x86', '\x9a'}, 3, 0xD19A}, /* (HANGUL SYLLABLE TYEJ) */
    {{'\xed', '\x86', '\x9b'}, 3, 0xD19B}, /* (HANGUL SYLLABLE TYEC) */
    {{'\xed', '\x86', '\x9c'}, 3, 0xD19C}, /* (HANGUL SYLLABLE TYEK) */
    {{'\xed', '\x86', '\x9d'}, 3, 0xD19D}, /* (HANGUL SYLLABLE TYET) */
    {{'\xed', '\x86', '\x9e'}, 3, 0xD19E}, /* (HANGUL SYLLABLE TYEP) */
    {{'\xed', '\x86', '\x9f'}, 3, 0xD19F}, /* (HANGUL SYLLABLE TYEH) */
    {{'\xed', '\x86', '\xa2'}, 3, 0xD1A2}, /* (HANGUL SYLLABLE TOGG) */
    {{'\xed', '\x86', '\xa3'}, 3, 0xD1A3}, /* (HANGUL SYLLABLE TOGS) */
    {{'\xed', '\x86', '\xa5'}, 3, 0xD1A5}, /* (HANGUL SYLLABLE TONJ) */
    {{'\xed', '\x86', '\xa6'}, 3, 0xD1A6}, /* (HANGUL SYLLABLE TONH) */
    {{'\xed', '\x86', '\xa7'}, 3, 0xD1A7}, /* (HANGUL SYLLABLE TOD) */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{'\xed', '\x86', '\xa9'}, 3, 0xD1A9}, /* (HANGUL SYLLABLE TOLG) */
    {{'\xed', '\x86', '\xaa'}, 3, 0xD1AA}, /* (HANGUL SYLLABLE TOLM) */
    {{'\xed', '\x86', '\xab'}, 3, 0xD1AB}, /* (HANGUL SYLLABLE TOLB) */
    {{'\xed', '\x86', '\xac'}, 3, 0xD1AC}, /* (HANGUL SYLLABLE TOLS) */
    {{'\xed', '\x86', '\xad'}, 3, 0xD1AD}, /* (HANGUL SYLLABLE TOLT) */
    {{'\xed', '\x86', '\xae'}, 3, 0xD1AE}, /* (HANGUL SYLLABLE TOLP) */
    {{'\xed', '\x86', '\xaf'}, 3, 0xD1AF}, /* (HANGUL SYLLABLE TOLH) */
    {{'\xed', '\x86', '\xb2'}, 3, 0xD1B2}, /* (HANGUL SYLLABLE TOBS) */
    {{'\xed', '\x86', '\xb4'}, 3, 0xD1B4}, /* (HANGUL SYLLABLE TOSS) */
    {{'\xed', '\x86', '\xb6'}, 3, 0xD1B6}, /* (HANGUL SYLLABLE TOJ) */
    {{'\xed', '\x86', '\xb7'}, 3, 0xD1B7}, /* (HANGUL SYLLABLE TOC) */
    {{'\xed', '\x86', '\xb8'}, 3, 0xD1B8}, /* (HANGUL SYLLABLE TOK) */
    {{'\xed', '\x86', '\xb9'}, 3, 0xD1B9}, /* (HANGUL SYLLABLE TOT) */
    {{'\xed', '\x86', '\xbb'}, 3, 0xD1BB}, /* (HANGUL SYLLABLE TOH) */
    {{'\xed', '\x86', '\xbd'}, 3, 0xD1BD}, /* (HANGUL SYLLABLE TWAG) */
    {{'\xed', '\x86', '\xbe'}, 3, 0xD1BE}, /* (HANGUL SYLLABLE TWAGG) */
    {{'\xed', '\x86', '\xbf'}, 3, 0xD1BF}, /* (HANGUL SYLLABLE TWAGS) */
    {{'\xed', '\x87', '\x81'}, 3, 0xD1C1}, /* (HANGUL SYLLABLE TWANJ) */
    {{'\xed', '\x87', '\x82'}, 3, 0xD1C2}, /* (HANGUL SYLLABLE TWANH) */
    {{'\xed', '\x87', '\x83'}, 3, 0xD1C3}, /* (HANGUL SYLLABLE TWAD) */
    {{'\xed', '\x87', '\x84'}, 3, 0xD1C4}, /* (HANGUL SYLLABLE TWAL) */
    {{'\xed', '\x87', '\x85'}, 3, 0xD1C5}, /* (HANGUL SYLLABLE TWALG) */
    {{'\xed', '\x87', '\x86'}, 3, 0xD1C6}, /* (HANGUL SYLLABLE TWALM) */
    {{'\xed', '\x87', '\x87'}, 3, 0xD1C7}, /* (HANGUL SYLLABLE TWALB) */
    {{'\xed', '\x87', '\x88'}, 3, 0xD1C8}, /* (HANGUL SYLLABLE TWALS) */
    {{'\xed', '\x87', '\x89'}, 3, 0xD1C9}, /* (HANGUL SYLLABLE TWALT) */
    {{'\xed', '\x87', '\x8a'}, 3, 0xD1CA}, /* (HANGUL SYLLABLE TWALP) */
    {{'\xed', '\x87', '\x8b'}, 3, 0xD1CB}, /* (HANGUL SYLLABLE TWALH) */
    {{'\xed', '\x87', '\x8c'}, 3, 0xD1CC}, /* (HANGUL SYLLABLE TWAM) */
    {{'\xed', '\x87', '\x8d'}, 3, 0xD1CD}, /* (HANGUL SYLLABLE TWAB) */
    {{'\xed', '\x87', '\x8e'}, 3, 0xD1CE}, /* (HANGUL SYLLABLE TWABS) */
    {{'\xed', '\x87', '\x8f'}, 3, 0xD1CF}, /* (HANGUL SYLLABLE TWAS) */
    {{'\xeb', '\x9e', '\x98'}, 3, 0xB798}, /* (HANGUL SYLLABLE RAE) */
    {{'\xeb', '\x9e', '\x99'}, 3, 0xB799}, /* (HANGUL SYLLABLE RAEG) */
    {{'\xeb', '\x9e', '\x9c'}, 3, 0xB79C}, /* (HANGUL SYLLABLE RAEN) */
    {{'\xeb', '\x9e', '\xa0'}, 3, 0xB7A0}, /* (HANGUL SYLLABLE RAEL) */
    {{'\xeb', '\x9e', '\xa8'}, 3, 0xB7A8}, /* (HANGUL SYLLABLE RAEM) */
    {{'\xeb', '\x9e', '\xa9'}, 3, 0xB7A9}, /* (HANGUL SYLLABLE RAEB) */
    {{'\xeb', '\x9e', '\xab'}, 3, 0xB7AB}, /* (HANGUL SYLLABLE RAES) */
    {{'\xeb', '\x9e', '\xac'}, 3, 0xB7AC}, /* (HANGUL SYLLABLE RAESS) */
    {{'\xeb', '\x9e', '\xad'}, 3, 0xB7AD}, /* (HANGUL SYLLABLE RAENG) */
    {{'\xeb', '\x9e', '\xb4'}, 3, 0xB7B4}, /* (HANGUL SYLLABLE RYA) */
    {{'\xeb', '\x9e', '\xb5'}, 3, 0xB7B5}, /* (HANGUL SYLLABLE RYAG) */
    {{'\xeb', '\x9e', '\xb8'}, 3, 0xB7B8}, /* (HANGUL SYLLABLE RYAN) */
    {{'\xeb', '\x9f', '\x87'}, 3, 0xB7C7}, /* (HANGUL SYLLABLE RYAS) */
    {{'\xeb', '\x9f', '\x89'}, 3, 0xB7C9}, /* (HANGUL SYLLABLE RYANG) */
    {{'\xeb', '\x9f', '\xac'}, 3, 0xB7EC}, /* (HANGUL SYLLABLE REO) */
    {{'\xeb', '\x9f', '\xad'}, 3, 0xB7ED}, /* (HANGUL SYLLABLE REOG) */
    {{'\xeb', '\x9f', '\xb0'}, 3, 0xB7F0}, /* (HANGUL SYLLABLE REON) */
    {{'\xeb', '\x9f', '\xb4'}, 3, 0xB7F4}, /* (HANGUL SYLLABLE REOL) */
    {{'\xeb', '\x9f', '\xbc'}, 3, 0xB7FC}, /* (HANGUL SYLLABLE REOM) */
    {{'\xeb', '\x9f', '\xbd'}, 3, 0xB7FD}, /* (HANGUL SYLLABLE REOB) */
    {{'\xeb', '\x9f', '\xbf'}, 3, 0xB7FF}, /* (HANGUL SYLLABLE REOS) */
    {{'\xeb', '\xa0', '\x80'}, 3, 0xB800}, /* (HANGUL SYLLABLE REOSS) */
    {{'\xeb', '\xa0', '\x81'}, 3, 0xB801}, /* (HANGUL SYLLABLE REONG) */
    {{'\xeb', '\xa0', '\x87'}, 3, 0xB807}, /* (HANGUL SYLLABLE REOH) */
    {{'\xeb', '\xa0', '\x88'}, 3, 0xB808}, /* (HANGUL SYLLABLE RE) */
    {{'\xeb', '\xa0', '\x89'}, 3, 0xB809}, /* (HANGUL SYLLABLE REG) */
    {{'\xeb', '\xa0', '\x8c'}, 3, 0xB80C}, /* (HANGUL SYLLABLE REN) */
    {{'\xeb', '\xa0', '\x90'}, 3, 0xB810}, /* (HANGUL SYLLABLE REL) */
    {{'\xeb', '\xa0', '\x98'}, 3, 0xB818}, /* (HANGUL SYLLABLE REM) */
    {{'\xeb', '\xa0', '\x99'}, 3, 0xB819}, /* (HANGUL SYLLABLE REB) */
    {{'\xeb', '\xa0', '\x9b'}, 3, 0xB81B}, /* (HANGUL SYLLABLE RES) */
    {{'\xeb', '\xa0', '\x9d'}, 3, 0xB81D}, /* (HANGUL SYLLABLE RENG) */
    {{'\xeb', '\xa0', '\xa4'}, 3, 0xB824}, /* (HANGUL SYLLABLE RYEO) */
    {{'\xeb', '\xa0', '\xa5'}, 3, 0xB825}, /* (HANGUL SYLLABLE RYEOG) */
    {{'\xeb', '\xa0', '\xa8'}, 3, 0xB828}, /* (HANGUL SYLLABLE RYEON) */
    {{'\xeb', '\xa0', '\xac'}, 3, 0xB82C}, /* (HANGUL SYLLABLE RYEOL) */
    {{'\xeb', '\xa0', '\xb4'}, 3, 0xB834}, /* (HANGUL SYLLABLE RYEOM) */
    {{'\xeb', '\xa0', '\xb5'}, 3, 0xB835}, /* (HANGUL SYLLABLE RYEOB) */
    {{'\xeb', '\xa0', '\xb7'}, 3, 0xB837}, /* (HANGUL SYLLABLE RYEOS) */
    {{'\xeb', '\xa0', '\xb8'}, 3, 0xB838}, /* (HANGUL SYLLABLE RYEOSS) */
    {{'\xeb', '\xa0', '\xb9'}, 3, 0xB839}, /* (HANGUL SYLLABLE RYEONG) */
    {{'\xeb', '\xa1', '\x80'}, 3, 0xB840}, /* (HANGUL SYLLABLE RYE) */
    {{'\xeb', '\xa1', '\x84'}, 3, 0xB844}, /* (HANGUL SYLLABLE RYEN) */
    {{'\xeb', '\xa1', '\x91'}, 3, 0xB851}, /* (HANGUL SYLLABLE RYEB) */
    {{'\xeb', '\xa1', '\x93'}, 3, 0xB853}, /* (HANGUL SYLLABLE RYES) */
    {{'\xeb', '\xa1', '\x9c'}, 3, 0xB85C}, /* (HANGUL SYLLABLE RO) */
    {{'\xeb', '\xa1', '\x9d'}, 3, 0xB85D}, /* (HANGUL SYLLABLE ROG) */
    {{'\xeb', '\xa1', '\xa0'}, 3, 0xB860}, /* (HANGUL SYLLABLE RON) */
    {{'\xeb', '\xa1', '\xa4'}, 3, 0xB864}, /* (HANGUL SYLLABLE ROL) */
    {{'\xeb', '\xa1', '\xac'}, 3, 0xB86C}, /* (HANGUL SYLLABLE ROM) */
    {{'\xeb', '\xa1', '\xad'}, 3, 0xB86D}, /* (HANGUL SYLLABLE ROB) */
    {{'\xeb', '\xa1', '\xaf'}, 3, 0xB86F}, /* (HANGUL SYLLABLE ROS) */
    {{'\xeb', '\xa1', '\xb1'}, 3, 0xB871}, /* (HANGUL SYLLABLE RONG) */
    {{'\xeb', '\xa1', '\xb8'}, 3, 0xB878}, /* (HANGUL SYLLABLE RWA) */
    {{'\xeb', '\xa1', '\xbc'}, 3, 0xB87C}, /* (HANGUL SYLLABLE RWAN) */
    {{'\xeb', '\xa2', '\x8d'}, 3, 0xB88D}, /* (HANGUL SYLLABLE RWANG) */
    {{'\xeb', '\xa2', '\xa8'}, 3, 0xB8A8}, /* (HANGUL SYLLABLE RWAESS) */
    {{'\xeb', '\xa2', '\xb0'}, 3, 0xB8B0}, /* (HANGUL SYLLABLE ROE) */
    {{'\xeb', '\xa2', '\xb4'}, 3, 0xB8B4}, /* (HANGUL SYLLABLE ROEN) */
    {{'\xeb', '\xa2', '\xb8'}, 3, 0xB8B8}, /* (HANGUL SYLLABLE ROEL) */
    {{'\xeb', '\xa3', '\x80'}, 3, 0xB8C0}, /* (HANGUL SYLLABLE ROEM) */
    {{'\xeb', '\xa3', '\x81'}, 3, 0xB8C1}, /* (HANGUL SYLLABLE ROEB) */
    {{'\xeb', '\xa3', '\x83'}, 3, 0xB8C3}, /* (HANGUL SYLLABLE ROES) */
    {{'\xeb', '\xa3', '\x85'}, 3, 0xB8C5}, /* (HANGUL SYLLABLE ROENG) */
    {{'\xeb', '\xa3', '\x8c'}, 3, 0xB8CC}, /* (HANGUL SYLLABLE RYO) */
    {{'\xeb', '\xa3', '\x90'}, 3, 0xB8D0}, /* (HANGUL SYLLABLE RYON) */
    {{'\xeb', '\xa3', '\x94'}, 3, 0xB8D4}, /* (HANGUL SYLLABLE RYOL) */
    {{'\xeb', '\xa3', '\x9d'}, 3, 0xB8DD}, /* (HANGUL SYLLABLE RYOB) */
    {{'\xeb', '\xa3', '\x9f'}, 3, 0xB8DF}, /* (HANGUL SYLLABLE RYOS) */
    {{'\xeb', '\xa3', '\xa1'}, 3, 0xB8E1}, /* (HANGUL SYLLABLE RYONG) */
    {{'\xeb', '\xa3', '\xa8'}, 3, 0xB8E8}, /* (HANGUL SYLLABLE RU) */
    {{'\xeb', '\xa3', '\xa9'}, 3, 0xB8E9}, /* (HANGUL SYLLABLE RUG) */
    {{'\xeb', '\xa3', '\xac'}, 3, 0xB8EC}, /* (HANGUL SYLLABLE RUN) */
    {{'\xeb', '\xa3', '\xb0'}, 3, 0xB8F0}, /* (HANGUL SYLLABLE RUL) */
    {{'\xeb', '\xa3', '\xb8'}, 3, 0xB8F8}, /* (HANGUL SYLLABLE RUM) */
    {{'\xeb', '\xa3', '\xb9'}, 3, 0xB8F9}, /* (HANGUL SYLLABLE RUB) */
    {{'\xeb', '\xa3', '\xbb'}, 3, 0xB8FB}, /* (HANGUL SYLLABLE RUS) */
    {{'\xeb', '\xa3', '\xbd'}, 3, 0xB8FD}, /* (HANGUL SYLLABLE RUNG) */
    {{'\xeb', '\xa4', '\x84'}, 3, 0xB904}, /* (HANGUL SYLLABLE RWEO) */
    {{'\xeb', '\xa4', '\x98'}, 3, 0xB918}, /* (HANGUL SYLLABLE RWEOSS) */
    {{'\xeb', '\xa4', '\xa0'}, 3, 0xB920}, /* (HANGUL SYLLABLE RWE) */
    {{'\xeb', '\xa4', '\xbc'}, 3, 0xB93C}, /* (HANGUL SYLLABLE RWI) */
    {{'\xeb', '\xa4', '\xbd'}, 3, 0xB93D}, /* (HANGUL SYLLABLE RWIG) */
    {{'\xeb', '\xa5', '\x80'}, 3, 0xB940}, /* (HANGUL SYLLABLE RWIN) */
    {{'\xeb', '\xa5', '\x84'}, 3, 0xB944}, /* (HANGUL SYLLABLE RWIL) */
    {{'\xeb', '\xa5', '\x8c'}, 3, 0xB94C}, /* (HANGUL SYLLABLE RWIM) */
    {{'\xeb', '\xa5', '\x8f'}, 3, 0xB94F}, /* (HANGUL SYLLABLE RWIS) */
    {{'\xeb', '\xa5', '\x91'}, 3, 0xB951}, /* (HANGUL SYLLABLE RWING) */
    {{'\xeb', '\xa5', '\x98'}, 3, 0xB958}, /* (HANGUL SYLLABLE RYU) */
    {{'\xeb', '\xa5', '\x99'}, 3, 0xB959}, /* (HANGUL SYLLABLE RYUG) */
    {{'\xeb', '\xa5', '\x9c'}, 3, 0xB95C}, /* (HANGUL SYLLABLE RYUN) */
    {{'\xeb', '\xa5', '\xa0'}, 3, 0xB960}, /* (HANGUL SYLLABLE RYUL) */
    {{'\xeb', '\xa5', '\xa8'}, 3, 0xB968}, /* (HANGUL SYLLABLE RYUM) */
    {{'\xeb', '\xa5', '\xa9'}, 3, 0xB969}, /* (HANGUL SYLLABLE RYUB) */
    {{'\xed', '\x87', '\x90'}, 3, 0xD1D0}, /* (HANGUL SYLLABLE TWASS) */
    {{'\xed', '\x87', '\x91'}, 3, 0xD1D1}, /* (HANGUL SYLLABLE TWANG) */
    {{'\xed', '\x87', '\x92'}, 3, 0xD1D2}, /* (HANGUL SYLLABLE TWAJ) */
    {{'\xed', '\x87', '\x93'}, 3, 0xD1D3}, /* (HANGUL SYLLABLE TWAC) */
    {{'\xed', '\x87', '\x94'}, 3, 0xD1D4}, /* (HANGUL SYLLABLE TWAK) */
    {{'\xed', '\x87', '\x95'}, 3, 0xD1D5}, /* (HANGUL SYLLABLE TWAT) */
    {{'\xed', '\x87', '\x96'}, 3, 0xD1D6}, /* (HANGUL SYLLABLE TWAP) */
    {{'\xed', '\x87', '\x97'}, 3, 0xD1D7}, /* (HANGUL SYLLABLE TWAH) */
    {{'\xed', '\x87', '\x99'}, 3, 0xD1D9}, /* (HANGUL SYLLABLE TWAEG) */
    {{'\xed', '\x87', '\x9a'}, 3, 0xD1DA}, /* (HANGUL SYLLABLE TWAEGG) */
    {{'\xed', '\x87', '\x9b'}, 3, 0xD1DB}, /* (HANGUL SYLLABLE TWAEGS) */
    {{'\xed', '\x87', '\x9c'}, 3, 0xD1DC}, /* (HANGUL SYLLABLE TWAEN) */
    {{'\xed', '\x87', '\x9d'}, 3, 0xD1DD}, /* (HANGUL SYLLABLE TWAENJ) */
    {{'\xed', '\x87', '\x9e'}, 3, 0xD1DE}, /* (HANGUL SYLLABLE TWAENH) */
    {{'\xed', '\x87', '\x9f'}, 3, 0xD1DF}, /* (HANGUL SYLLABLE TWAED) */
    {{'\xed', '\x87', '\xa0'}, 3, 0xD1E0}, /* (HANGUL SYLLABLE TWAEL) */
    {{'\xed', '\x87', '\xa1'}, 3, 0xD1E1}, /* (HANGUL SYLLABLE TWAELG) */
    {{'\xed', '\x87', '\xa2'}, 3, 0xD1E2}, /* (HANGUL SYLLABLE TWAELM) */
    {{'\xed', '\x87', '\xa3'}, 3, 0xD1E3}, /* (HANGUL SYLLABLE TWAELB) */
    {{'\xed', '\x87', '\xa4'}, 3, 0xD1E4}, /* (HANGUL SYLLABLE TWAELS) */
    {{'\xed', '\x87', '\xa5'}, 3, 0xD1E5}, /* (HANGUL SYLLABLE TWAELT) */
    {{'\xed', '\x87', '\xa6'}, 3, 0xD1E6}, /* (HANGUL SYLLABLE TWAELP) */
    {{'\xed', '\x87', '\xa7'}, 3, 0xD1E7}, /* (HANGUL SYLLABLE TWAELH) */
    {{'\xed', '\x87', '\xa8'}, 3, 0xD1E8}, /* (HANGUL SYLLABLE TWAEM) */
    {{'\xed', '\x87', '\xa9'}, 3, 0xD1E9}, /* (HANGUL SYLLABLE TWAEB) */
    {{'\xed', '\x87', '\xaa'}, 3, 0xD1EA}, /* (HANGUL SYLLABLE TWAEBS) */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{'\xed', '\x87', '\xab'}, 3, 0xD1EB}, /* (HANGUL SYLLABLE TWAES) */
    {{'\xed', '\x87', '\xac'}, 3, 0xD1EC}, /* (HANGUL SYLLABLE TWAESS) */
    {{'\xed', '\x87', '\xad'}, 3, 0xD1ED}, /* (HANGUL SYLLABLE TWAENG) */
    {{'\xed', '\x87', '\xae'}, 3, 0xD1EE}, /* (HANGUL SYLLABLE TWAEJ) */
    {{'\xed', '\x87', '\xaf'}, 3, 0xD1EF}, /* (HANGUL SYLLABLE TWAEC) */
    {{'\xed', '\x87', '\xb0'}, 3, 0xD1F0}, /* (HANGUL SYLLABLE TWAEK) */
    {{'\xed', '\x87', '\xb1'}, 3, 0xD1F1}, /* (HANGUL SYLLABLE TWAET) */
    {{'\xed', '\x87', '\xb2'}, 3, 0xD1F2}, /* (HANGUL SYLLABLE TWAEP) */
    {{'\xed', '\x87', '\xb3'}, 3, 0xD1F3}, /* (HANGUL SYLLABLE TWAEH) */
    {{'\xed', '\x87', '\xb5'}, 3, 0xD1F5}, /* (HANGUL SYLLABLE TOEG) */
    {{'\xed', '\x87', '\xb6'}, 3, 0xD1F6}, /* (HANGUL SYLLABLE TOEGG) */
    {{'\xed', '\x87', '\xb7'}, 3, 0xD1F7}, /* (HANGUL SYLLABLE TOEGS) */
    {{'\xed', '\x87', '\xb9'}, 3, 0xD1F9}, /* (HANGUL SYLLABLE TOENJ) */
    {{'\xed', '\x87', '\xba'}, 3, 0xD1FA}, /* (HANGUL SYLLABLE TOENH) */
    {{'\xed', '\x87', '\xbb'}, 3, 0xD1FB}, /* (HANGUL SYLLABLE TOED) */
    {{'\xed', '\x87', '\xbc'}, 3, 0xD1FC}, /* (HANGUL SYLLABLE TOEL) */
    {{'\xed', '\x87', '\xbd'}, 3, 0xD1FD}, /* (HANGUL SYLLABLE TOELG) */
    {{'\xed', '\x87', '\xbe'}, 3, 0xD1FE}, /* (HANGUL SYLLABLE TOELM) */
    {{'\xed', '\x87', '\xbf'}, 3, 0xD1FF}, /* (HANGUL SYLLABLE TOELB) */
    {{'\xed', '\x88', '\x80'}, 3, 0xD200}, /* (HANGUL SYLLABLE TOELS) */
    {{'\xed', '\x88', '\x81'}, 3, 0xD201}, /* (HANGUL SYLLABLE TOELT) */
    {{'\xed', '\x88', '\x82'}, 3, 0xD202}, /* (HANGUL SYLLABLE TOELP) */
    {{'\xed', '\x88', '\x83'}, 3, 0xD203}, /* (HANGUL SYLLABLE TOELH) */
    {{'\xed', '\x88', '\x84'}, 3, 0xD204}, /* (HANGUL SYLLABLE TOEM) */
    {{'\xed', '\x88', '\x85'}, 3, 0xD205}, /* (HANGUL SYLLABLE TOEB) */
    {{'\xed', '\x88', '\x86'}, 3, 0xD206}, /* (HANGUL SYLLABLE TOEBS) */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{'\xed', '\x88', '\x88'}, 3, 0xD208}, /* (HANGUL SYLLABLE TOESS) */
    {{'\xed', '\x88', '\x8a'}, 3, 0xD20A}, /* (HANGUL SYLLABLE TOEJ) */
    {{'\xed', '\x88', '\x8b'}, 3, 0xD20B}, /* (HANGUL SYLLABLE TOEC) */
    {{'\xed', '\x88', '\x8c'}, 3, 0xD20C}, /* (HANGUL SYLLABLE TOEK) */
    {{'\xed', '\x88', '\x8d'}, 3, 0xD20D}, /* (HANGUL SYLLABLE TOET) */
    {{'\xed', '\x88', '\x8e'}, 3, 0xD20E}, /* (HANGUL SYLLABLE TOEP) */
    {{'\xed', '\x88', '\x8f'}, 3, 0xD20F}, /* (HANGUL SYLLABLE TOEH) */
    {{'\xed', '\x88', '\x91'}, 3, 0xD211}, /* (HANGUL SYLLABLE TYOG) */
    {{'\xed', '\x88', '\x92'}, 3, 0xD212}, /* (HANGUL SYLLABLE TYOGG) */
    {{'\xed', '\x88', '\x93'}, 3, 0xD213}, /* (HANGUL SYLLABLE TYOGS) */
    {{'\xed', '\x88', '\x94'}, 3, 0xD214}, /* (HANGUL SYLLABLE TYON) */
    {{'\xed', '\x88', '\x95'}, 3, 0xD215}, /* (HANGUL SYLLABLE TYONJ) */
    {{'\xed', '\x88', '\x96'}, 3, 0xD216}, /* (HANGUL SYLLABLE TYONH) */
    {{'\xed', '\x88', '\x97'}, 3, 0xD217}, /* (HANGUL SYLLABLE TYOD) */
    {{'\xed', '\x88', '\x98'}, 3, 0xD218}, /* (HANGUL SYLLABLE TYOL) */
    {{'\xed', '\x88', '\x99'}, 3, 0xD219}, /* (HANGUL SYLLABLE TYOLG) */
    {{'\xed', '\x88', '\x9a'}, 3, 0xD21A}, /* (HANGUL SYLLABLE TYOLM) */
    {{'\xed', '\x88', '\x9b'}, 3, 0xD21B}, /* (HANGUL SYLLABLE TYOLB) */
    {{'\xed', '\x88', '\x9c'}, 3, 0xD21C}, /* (HANGUL SYLLABLE TYOLS) */
    {{'\xed', '\x88', '\x9d'}, 3, 0xD21D}, /* (HANGUL SYLLABLE TYOLT) */
    {{'\xed', '\x88', '\x9e'}, 3, 0xD21E}, /* (HANGUL SYLLABLE TYOLP) */
    {{'\xed', '\x88', '\x9f'}, 3, 0xD21F}, /* (HANGUL SYLLABLE TYOLH) */
    {{'\xed', '\x88', '\xa0'}, 3, 0xD220}, /* (HANGUL SYLLABLE TYOM) */
    {{'\xed', '\x88', '\xa1'}, 3, 0xD221}, /* (HANGUL SYLLABLE TYOB) */
    {{'\xed', '\x88', '\xa2'}, 3, 0xD222}, /* (HANGUL SYLLABLE TYOBS) */
    {{'\xed', '\x88', '\xa3'}, 3, 0xD223}, /* (HANGUL SYLLABLE TYOS) */
    {{'\xed', '\x88', '\xa4'}, 3, 0xD224}, /* (HANGUL SYLLABLE TYOSS) */
    {{'\xed', '\x88', '\xa5'}, 3, 0xD225}, /* (HANGUL SYLLABLE TYONG) */
    {{'\xed', '\x88', '\xa6'}, 3, 0xD226}, /* (HANGUL SYLLABLE TYOJ) */
    {{'\xed', '\x88', '\xa7'}, 3, 0xD227}, /* (HANGUL SYLLABLE TYOC) */
    {{'\xed', '\x88', '\xa8'}, 3, 0xD228}, /* (HANGUL SYLLABLE TYOK) */
    {{'\xed', '\x88', '\xa9'}, 3, 0xD229}, /* (HANGUL SYLLABLE TYOT) */
    {{'\xeb', '\xa5', '\xab'}, 3, 0xB96B}, /* (HANGUL SYLLABLE RYUS) */
    {{'\xeb', '\xa5', '\xad'}, 3, 0xB96D}, /* (HANGUL SYLLABLE RYUNG) */
    {{'\xeb', '\xa5', '\xb4'}, 3, 0xB974}, /* (HANGUL SYLLABLE REU) */
    {{'\xeb', '\xa5', '\xb5'}, 3, 0xB975}, /* (HANGUL SYLLABLE REUG) */
    {{'\xeb', '\xa5', '\xb8'}, 3, 0xB978}, /* (HANGUL SYLLABLE REUN) */
    {{'\xeb', '\xa5', '\xbc'}, 3, 0xB97C}, /* (HANGUL SYLLABLE REUL) */
    {{'\xeb', '\xa6', '\x84'}, 3, 0xB984}, /* (HANGUL SYLLABLE REUM) */
    {{'\xeb', '\xa6', '\x85'}, 3, 0xB985}, /* (HANGUL SYLLABLE REUB) */
    {{'\xeb', '\xa6', '\x87'}, 3, 0xB987}, /* (HANGUL SYLLABLE REUS) */
    {{'\xeb', '\xa6', '\x89'}, 3, 0xB989}, /* (HANGUL SYLLABLE REUNG) */
    {{'\xeb', '\xa6', '\x8a'}, 3, 0xB98A}, /* (HANGUL SYLLABLE REUJ) */
    {{'\xeb', '\xa6', '\x8d'}, 3, 0xB98D}, /* (HANGUL SYLLABLE REUT) */
    {{'\xeb', '\xa6', '\x8e'}, 3, 0xB98E}, /* (HANGUL SYLLABLE REUP) */
    {{'\xeb', '\xa6', '\xac'}, 3, 0xB9AC}, /* (HANGUL SYLLABLE RI) */
    {{'\xeb', '\xa6', '\xad'}, 3, 0xB9AD}, /* (HANGUL SYLLABLE RIG) */
    {{'\xeb', '\xa6', '\xb0'}, 3, 0xB9B0}, /* (HANGUL SYLLABLE RIN) */
    {{'\xeb', '\xa6', '\xb4'}, 3, 0xB9B4}, /* (HANGUL SYLLABLE RIL) */
    {{'\xeb', '\xa6', '\xbc'}, 3, 0xB9BC}, /* (HANGUL SYLLABLE RIM) */
    {{'\xeb', '\xa6', '\xbd'}, 3, 0xB9BD}, /* (HANGUL SYLLABLE RIB) */
    {{'\xeb', '\xa6', '\xbf'}, 3, 0xB9BF}, /* (HANGUL SYLLABLE RIS) */
    {{'\xeb', '\xa7', '\x81'}, 3, 0xB9C1}, /* (HANGUL SYLLABLE RING) */
    {{'\xeb', '\xa7', '\x88'}, 3, 0xB9C8}, /* (HANGUL SYLLABLE MA) */
    {{'\xeb', '\xa7', '\x89'}, 3, 0xB9C9}, /* (HANGUL SYLLABLE MAG) */
    {{'\xeb', '\xa7', '\x8c'}, 3, 0xB9CC}, /* (HANGUL SYLLABLE MAN) */
    {{'\xeb', '\xa7', '\x8e'}, 3, 0xB9CE}, /* (HANGUL SYLLABLE MANH) */
    {{'\xeb', '\xa7', '\x8f'}, 3, 0xB9CF}, /* (HANGUL SYLLABLE MAD) */
    {{'\xeb', '\xa7', '\x90'}, 3, 0xB9D0}, /* (HANGUL SYLLABLE MAL) */
    {{'\xeb', '\xa7', '\x91'}, 3, 0xB9D1}, /* (HANGUL SYLLABLE MALG) */
    {{'\xeb', '\xa7', '\x92'}, 3, 0xB9D2}, /* (HANGUL SYLLABLE MALM) */
    {{'\xeb', '\xa7', '\x98'}, 3, 0xB9D8}, /* (HANGUL SYLLABLE MAM) */
    {{'\xeb', '\xa7', '\x99'}, 3, 0xB9D9}, /* (HANGUL SYLLABLE MAB) */
    {{'\xeb', '\xa7', '\x9b'}, 3, 0xB9DB}, /* (HANGUL SYLLABLE MAS) */
    {{'\xeb', '\xa7', '\x9d'}, 3, 0xB9DD}, /* (HANGUL SYLLABLE MANG) */
    {{'\xeb', '\xa7', '\x9e'}, 3, 0xB9DE}, /* (HANGUL SYLLABLE MAJ) */
    {{'\xeb', '\xa7', '\xa1'}, 3, 0xB9E1}, /* (HANGUL SYLLABLE MAT) */
    {{'\xeb', '\xa7', '\xa3'}, 3, 0xB9E3}, /* (HANGUL SYLLABLE MAH) */
    {{'\xeb', '\xa7', '\xa4'}, 3, 0xB9E4}, /* (HANGUL SYLLABLE MAE) */
    {{'\xeb', '\xa7', '\xa5'}, 3, 0xB9E5}, /* (HANGUL SYLLABLE MAEG) */
    {{'\xeb', '\xa7', '\xa8'}, 3, 0xB9E8}, /* (HANGUL SYLLABLE MAEN) */
    {{'\xeb', '\xa7', '\xac'}, 3, 0xB9EC}, /* (HANGUL SYLLABLE MAEL) */
    {{'\xeb', '\xa7', '\xb4'}, 3, 0xB9F4}, /* (HANGUL SYLLABLE MAEM) */
    {{'\xeb', '\xa7', '\xb5'}, 3, 0xB9F5}, /* (HANGUL SYLLABLE MAEB) */
    {{'\xeb', '\xa7', '\xb7'}, 3, 0xB9F7}, /* (HANGUL SYLLABLE MAES) */
    {{'\xeb', '\xa7', '\xb8'}, 3, 0xB9F8}, /* (HANGUL SYLLABLE MAESS) */
    {{'\xeb', '\xa7', '\xb9'}, 3, 0xB9F9}, /* (HANGUL SYLLABLE MAENG) */
    {{'\xeb', '\xa7', '\xba'}, 3, 0xB9FA}, /* (HANGUL SYLLABLE MAEJ) */
    {{'\xeb', '\xa8', '\x80'}, 3, 0xBA00}, /* (HANGUL SYLLABLE MYA) */
    {{'\xeb', '\xa8', '\x81'}, 3, 0xBA01}, /* (HANGUL SYLLABLE MYAG) */
    {{'\xeb', '\xa8', '\x88'}, 3, 0xBA08}, /* (HANGUL SYLLABLE MYAL) */
    {{'\xeb', '\xa8', '\x95'}, 3, 0xBA15}, /* (HANGUL SYLLABLE MYANG) */
    {{'\xeb', '\xa8', '\xb8'}, 3, 0xBA38}, /* (HANGUL SYLLABLE MEO) */
    {{'\xeb', '\xa8', '\xb9'}, 3, 0xBA39}, /* (HANGUL SYLLABLE MEOG) */
    {{'\xeb', '\xa8', '\xbc'}, 3, 0xBA3C}, /* (HANGUL SYLLABLE MEON) */
    {{'\xeb', '\xa9', '\x80'}, 3, 0xBA40}, /* (HANGUL SYLLABLE MEOL) */
    {{'\xeb', '\xa9', '\x82'}, 3, 0xBA42}, /* (HANGUL SYLLABLE MEOLM) */
    {{'\xeb', '\xa9', '\x88'}, 3, 0xBA48}, /* (HANGUL SYLLABLE MEOM) */
    {{'\xeb', '\xa9', '\x89'}, 3, 0xBA49}, /* (HANGUL SYLLABLE MEOB) */
    {{'\xeb', '\xa9', '\x8b'}, 3, 0xBA4B}, /* (HANGUL SYLLABLE MEOS) */
    {{'\xeb', '\xa9', '\x8d'}, 3, 0xBA4D}, /* (HANGUL SYLLABLE MEONG) */
    {{'\xeb', '\xa9', '\x8e'}, 3, 0xBA4E}, /* (HANGUL SYLLABLE MEOJ) */
    {{'\xeb', '\xa9', '\x93'}, 3, 0xBA53}, /* (HANGUL SYLLABLE MEOH) */
    {{'\xeb', '\xa9', '\x94'}, 3, 0xBA54}, /* (HANGUL SYLLABLE ME) */
    {{'\xeb', '\xa9', '\x95'}, 3, 0xBA55}, /* (HANGUL SYLLABLE MEG) */
    {{'\xeb', '\xa9', '\x98'}, 3, 0xBA58}, /* (HANGUL SYLLABLE MEN) */
    {{'\xeb', '\xa9', '\x9c'}, 3, 0xBA5C}, /* (HANGUL SYLLABLE MEL) */
    {{'\xeb', '\xa9', '\xa4'}, 3, 0xBA64}, /* (HANGUL SYLLABLE MEM) */
    {{'\xeb', '\xa9', '\xa5'}, 3, 0xBA65}, /* (HANGUL SYLLABLE MEB) */
    {{'\xeb', '\xa9', '\xa7'}, 3, 0xBA67}, /* (HANGUL SYLLABLE MES) */
    {{'\xeb', '\xa9', '\xa8'}, 3, 0xBA68}, /* (HANGUL SYLLABLE MESS) */
    {{'\xeb', '\xa9', '\xa9'}, 3, 0xBA69}, /* (HANGUL SYLLABLE MENG) */
    {{'\xeb', '\xa9', '\xb0'}, 3, 0xBA70}, /* (HANGUL SYLLABLE MYEO) */
    {{'\xeb', '\xa9', '\xb1'}, 3, 0xBA71}, /* (HANGUL SYLLABLE MYEOG) */
    {{'\xeb', '\xa9', '\xb4'}, 3, 0xBA74}, /* (HANGUL SYLLABLE MYEON) */
    {{'\xeb', '\xa9', '\xb8'}, 3, 0xBA78}, /* (HANGUL SYLLABLE MYEOL) */
    {{'\xeb', '\xaa', '\x83'}, 3, 0xBA83}, /* (HANGUL SYLLABLE MYEOS) */
    {{'\xeb', '\xaa', '\x84'}, 3, 0xBA84}, /* (HANGUL SYLLABLE MYEOSS) */
    {{'\xeb', '\xaa', '\x85'}, 3, 0xBA85}, /* (HANGUL SYLLABLE MYEONG) */
    {{'\xeb', '\xaa', '\x87'}, 3, 0xBA87}, /* (HANGUL SYLLABLE MYEOC) */
    {{'\xeb', '\xaa', '\x8c'}, 3, 0xBA8C}, /* (HANGUL SYLLABLE MYE) */
    {{'\xeb', '\xaa', '\xa8'}, 3, 0xBAA8}, /* (HANGUL SYLLABLE MO) */
    {{'\xeb', '\xaa', '\xa9'}, 3, 0xBAA9}, /* (HANGUL SYLLABLE MOG) */
    {{'\xeb', '\xaa', '\xab'}, 3, 0xBAAB}, /* (HANGUL SYLLABLE MOGS) */
    {{'\xeb', '\xaa', '\xac'}, 3, 0xBAAC}, /* (HANGUL SYLLABLE MON) */
    {{'\xeb', '\xaa', '\xb0'}, 3, 0xBAB0}, /* (HANGUL SYLLABLE MOL) */
    {{'\xeb', '\xaa', '\xb2'}, 3, 0xBAB2}, /* (HANGUL SYLLABLE MOLM) */
    {{'\xeb', '\xaa', '\xb8'}, 3, 0xBAB8}, /* (HANGUL SYLLABLE MOM) */
    {{'\xeb', '\xaa', '\xb9'}, 3, 0xBAB9}, /* (HANGUL SYLLABLE MOB) */
    {{'\xeb', '\xaa', '\xbb'}, 3, 0xBABB}, /* (HANGUL SYLLABLE MOS) */
    {{'\xeb', '\xaa', '\xbd'}, 3, 0xBABD}, /* (HANGUL SYLLABLE MONG) */
    {{'\xeb', '\xab', '\x84'}, 3, 0xBAC4}, /* (HANGUL SYLLABLE MWA) */
    {{'\xeb', '\xab', '\x88'}, 3, 0xBAC8}, /* (HANGUL SYLLABLE MWAN) */
    {{'\xeb', '\xab', '\x98'}, 3, 0xBAD8}, /* (HANGUL SYLLABLE MWASS) */
    {{'\xeb', '\xab', '\x99'}, 3, 0xBAD9}, /* (HANGUL SYLLABLE MWANG) */
    {{'\xeb', '\xab', '\xbc'}, 3, 0xBAFC}, /* (HANGUL SYLLABLE MOE) */
    {{'\xed', '\x88', '\xaa'}, 3, 0xD22A}, /* (HANGUL SYLLABLE TYOP) */
    {{'\xed', '\x88', '\xab'}, 3, 0xD22B}, /* (HANGUL SYLLABLE TYOH) */
    {{'\xed', '\x88', '\xae'}, 3, 0xD22E}, /* (HANGUL SYLLABLE TUGG) */
    {{'\xed', '\x88', '\xaf'}, 3, 0xD22F}, /* (HANGUL SYLLABLE TUGS) */
    {{'\xed', '\x88', '\xb1'}, 3, 0xD231}, /* (HANGUL SYLLABLE TUNJ) */
    {{'\xed', '\x88', '\xb2'}, 3, 0xD232}, /* (HANGUL SYLLABLE TUNH) */
    {{'\xed', '\x88', '\xb3'}, 3, 0xD233}, /* (HANGUL SYLLABLE TUD) */
    {{'\xed', '\x88', '\xb5'}, 3, 0xD235}, /* (HANGUL SYLLABLE TULG) */
    {{'\xed', '\x88', '\xb6'}, 3, 0xD236}, /* (HANGUL SYLLABLE TULM) */
    {{'\xed', '\x88', '\xb7'}, 3, 0xD237}, /* (HANGUL SYLLABLE TULB) */
    {{'\xed', '\x88', '\xb8'}, 3, 0xD238}, /* (HANGUL SYLLABLE TULS) */
    {{'\xed', '\x88', '\xb9'}, 3, 0xD239}, /* (HANGUL SYLLABLE TULT) */
    {{'\xed', '\x88', '\xba'}, 3, 0xD23A}, /* (HANGUL SYLLABLE TULP) */
    {{'\xed', '\x88', '\xbb'}, 3, 0xD23B}, /* (HANGUL SYLLABLE TULH) */
    {{'\xed', '\x88', '\xbe'}, 3, 0xD23E}, /* (HANGUL SYLLABLE TUBS) */
    {{'\xed', '\x89', '\x80'}, 3, 0xD240}, /* (HANGUL SYLLABLE TUSS) */
    {{'\xed', '\x89', '\x82'}, 3, 0xD242}, /* (HANGUL SYLLABLE TUJ) */
    {{'\xed', '\x89', '\x83'}, 3, 0xD243}, /* (HANGUL SYLLABLE TUC) */
    {{'\xed', '\x89', '\x84'}, 3, 0xD244}, /* (HANGUL SYLLABLE TUK) */
    {{'\xed', '\x89', '\x85'}, 3, 0xD245}, /* (HANGUL SYLLABLE TUT) */
    {{'\xed', '\x89', '\x86'}, 3, 0xD246}, /* (HANGUL SYLLABLE TUP) */
    {{'\xed', '\x89', '\x87'}, 3, 0xD247}, /* (HANGUL SYLLABLE TUH) */
    {{'\xed', '\x89', '\x89'}, 3, 0xD249}, /* (HANGUL SYLLABLE TWEOG) */
    {{'\xed', '\x89', '\x8a'}, 3, 0xD24A}, /* (HANGUL SYLLABLE TWEOGG) */
    {{'\xed', '\x89', '\x8b'}, 3, 0xD24B}, /* (HANGUL SYLLABLE TWEOGS) */
    {{'\xed', '\x89', '\x8c'}, 3, 0xD24C}, /* (HANGUL SYLLABLE TWEON) */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{'\xed', '\x89', '\x8d'}, 3, 0xD24D}, /* (HANGUL SYLLABLE TWEONJ) */
    {{'\xed', '\x89', '\x8e'}, 3, 0xD24E}, /* (HANGUL SYLLABLE TWEONH) */
    {{'\xed', '\x89', '\x8f'}, 3, 0xD24F}, /* (HANGUL SYLLABLE TWEOD) */
    {{'\xed', '\x89', '\x90'}, 3, 0xD250}, /* (HANGUL SYLLABLE TWEOL) */
    {{'\xed', '\x89', '\x91'}, 3, 0xD251}, /* (HANGUL SYLLABLE TWEOLG) */
    {{'\xed', '\x89', '\x92'}, 3, 0xD252}, /* (HANGUL SYLLABLE TWEOLM) */
    {{'\xed', '\x89', '\x93'}, 3, 0xD253}, /* (HANGUL SYLLABLE TWEOLB) */
    {{'\xed', '\x89', '\x94'}, 3, 0xD254}, /* (HANGUL SYLLABLE TWEOLS) */
    {{'\xed', '\x89', '\x95'}, 3, 0xD255}, /* (HANGUL SYLLABLE TWEOLT) */
    {{'\xed', '\x89', '\x96'}, 3, 0xD256}, /* (HANGUL SYLLABLE TWEOLP) */
    {{'\xed', '\x89', '\x97'}, 3, 0xD257}, /* (HANGUL SYLLABLE TWEOLH) */
    {{'\xed', '\x89', '\x98'}, 3, 0xD258}, /* (HANGUL SYLLABLE TWEOM) */
    {{'\xed', '\x89', '\x99'}, 3, 0xD259}, /* (HANGUL SYLLABLE TWEOB) */
    {{'\xed', '\x89', '\x9a'}, 3, 0xD25A}, /* (HANGUL SYLLABLE TWEOBS) */
    {{'\xed', '\x89', '\x9b'}, 3, 0xD25B}, /* (HANGUL SYLLABLE TWEOS) */
    {{'\xed', '\x89', '\x9d'}, 3, 0xD25D}, /* (HANGUL SYLLABLE TWEONG) */
    {{'\xed', '\x89', '\x9e'}, 3, 0xD25E}, /* (HANGUL SYLLABLE TWEOJ) */
    {{'\xed', '\x89', '\x9f'}, 3, 0xD25F}, /* (HANGUL SYLLABLE TWEOC) */
    {{'\xed', '\x89', '\xa0'}, 3, 0xD260}, /* (HANGUL SYLLABLE TWEOK) */
    {{'\xed', '\x89', '\xa1'}, 3, 0xD261}, /* (HANGUL SYLLABLE TWEOT) */
    {{'\xed', '\x89', '\xa2'}, 3, 0xD262}, /* (HANGUL SYLLABLE TWEOP) */
    {{'\xed', '\x89', '\xa3'}, 3, 0xD263}, /* (HANGUL SYLLABLE TWEOH) */
    {{'\xed', '\x89', '\xa5'}, 3, 0xD265}, /* (HANGUL SYLLABLE TWEG) */
    {{'\xed', '\x89', '\xa6'}, 3, 0xD266}, /* (HANGUL SYLLABLE TWEGG) */
    {{'\xed', '\x89', '\xa7'}, 3, 0xD267}, /* (HANGUL SYLLABLE TWEGS) */
    {{'\xed', '\x89', '\xa8'}, 3, 0xD268}, /* (HANGUL SYLLABLE TWEN) */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{'\xed', '\x89', '\xa9'}, 3, 0xD269}, /* (HANGUL SYLLABLE TWENJ) */
    {{'\xed', '\x89', '\xaa'}, 3, 0xD26A}, /* (HANGUL SYLLABLE TWENH) */
    {{'\xed', '\x89', '\xab'}, 3, 0xD26B}, /* (HANGUL SYLLABLE TWED) */
    {{'\xed', '\x89', '\xac'}, 3, 0xD26C}, /* (HANGUL SYLLABLE TWEL) */
    {{'\xed', '\x89', '\xad'}, 3, 0xD26D}, /* (HANGUL SYLLABLE TWELG) */
    {{'\xed', '\x89', '\xae'}, 3, 0xD26E}, /* (HANGUL SYLLABLE TWELM) */
    {{'\xed', '\x89', '\xaf'}, 3, 0xD26F}, /* (HANGUL SYLLABLE TWELB) */
    {{'\xed', '\x89', '\xb0'}, 3, 0xD270}, /* (HANGUL SYLLABLE TWELS) */
    {{'\xed', '\x89', '\xb1'}, 3, 0xD271}, /* (HANGUL SYLLABLE TWELT) */
    {{'\xed', '\x89', '\xb2'}, 3, 0xD272}, /* (HANGUL SYLLABLE TWELP) */
    {{'\xed', '\x89', '\xb3'}, 3, 0xD273}, /* (HANGUL SYLLABLE TWELH) */
    {{'\xed', '\x89', '\xb4'}, 3, 0xD274}, /* (HANGUL SYLLABLE TWEM) */
    {{'\xed', '\x89', '\xb5'}, 3, 0xD275}, /* (HANGUL SYLLABLE TWEB) */
    {{'\xed', '\x89', '\xb6'}, 3, 0xD276}, /* (HANGUL SYLLABLE TWEBS) */
    {{'\xed', '\x89', '\xb7'}, 3, 0xD277}, /* (HANGUL SYLLABLE TWES) */
    {{'\xed', '\x89', '\xb8'}, 3, 0xD278}, /* (HANGUL SYLLABLE TWESS) */
    {{'\xed', '\x89', '\xb9'}, 3, 0xD279}, /* (HANGUL SYLLABLE TWENG) */
    {{'\xed', '\x89', '\xba'}, 3, 0xD27A}, /* (HANGUL SYLLABLE TWEJ) */
    {{'\xed', '\x89', '\xbb'}, 3, 0xD27B}, /* (HANGUL SYLLABLE TWEC) */
    {{'\xed', '\x89', '\xbc'}, 3, 0xD27C}, /* (HANGUL SYLLABLE TWEK) */
    {{'\xed', '\x89', '\xbd'}, 3, 0xD27D}, /* (HANGUL SYLLABLE TWET) */
    {{'\xed', '\x89', '\xbe'}, 3, 0xD27E}, /* (HANGUL SYLLABLE TWEP) */
    {{'\xed', '\x89', '\xbf'}, 3, 0xD27F}, /* (HANGUL SYLLABLE TWEH) */
    {{'\xed', '\x8a', '\x82'}, 3, 0xD282}, /* (HANGUL SYLLABLE TWIGG) */
    {{'\xed', '\x8a', '\x83'}, 3, 0xD283}, /* (HANGUL SYLLABLE TWIGS) */
    {{'\xed', '\x8a', '\x85'}, 3, 0xD285}, /* (HANGUL SYLLABLE TWINJ) */
    {{'\xed', '\x8a', '\x86'}, 3, 0xD286}, /* (HANGUL SYLLABLE TWINH) */
    {{'\xed', '\x8a', '\x87'}, 3, 0xD287}, /* (HANGUL SYLLABLE TWID) */
    {{'\xed', '\x8a', '\x89'}, 3, 0xD289}, /* (HANGUL SYLLABLE TWILG) */
    {{'\xed', '\x8a', '\x8a'}, 3, 0xD28A}, /* (HANGUL SYLLABLE TWILM) */
    {{'\xed', '\x8a', '\x8b'}, 3, 0xD28B}, /* (HANGUL SYLLABLE TWILB) */
    {{'\xed', '\x8a', '\x8c'}, 3, 0xD28C}, /* (HANGUL SYLLABLE TWILS) */
    {{'\xeb', '\xac', '\x80'}, 3, 0xBB00}, /* (HANGUL SYLLABLE MOEN) */
    {{'\xeb', '\xac', '\x84'}, 3, 0xBB04}, /* (HANGUL SYLLABLE MOEL) */
    {{'\xeb', '\xac', '\x8d'}, 3, 0xBB0D}, /* (HANGUL SYLLABLE MOEB) */
    {{'\xeb', '\xac', '\x8f'}, 3, 0xBB0F}, /* (HANGUL SYLLABLE MOES) */
    {{'\xeb', '\xac', '\x91'}, 3, 0xBB11}, /* (HANGUL SYLLABLE MOENG) */
    {{'\xeb', '\xac', '\x98'}, 3, 0xBB18}, /* (HANGUL SYLLABLE MYO) */
    {{'\xeb', '\xac', '\x9c'}, 3, 0xBB1C}, /* (HANGUL SYLLABLE MYON) */
    {{'\xeb', '\xac', '\xa0'}, 3, 0xBB20}, /* (HANGUL SYLLABLE MYOL) */
    {{'\xeb', '\xac', '\xa9'}, 3, 0xBB29}, /* (HANGUL SYLLABLE MYOB) */
    {{'\xeb', '\xac', '\xab'}, 3, 0xBB2B}, /* (HANGUL SYLLABLE MYOS) */
    {{'\xeb', '\xac', '\xb4'}, 3, 0xBB34}, /* (HANGUL SYLLABLE MU) */
    {{'\xeb', '\xac', '\xb5'}, 3, 0xBB35}, /* (HANGUL SYLLABLE MUG) */
    {{'\xeb', '\xac', '\xb6'}, 3, 0xBB36}, /* (HANGUL SYLLABLE MUGG) */
    {{'\xeb', '\xac', '\xb8'}, 3, 0xBB38}, /* (HANGUL SYLLABLE MUN) */
    {{'\xeb', '\xac', '\xbb'}, 3, 0xBB3B}, /* (HANGUL SYLLABLE MUD) */
    {{'\xeb', '\xac', '\xbc'}, 3, 0xBB3C}, /* (HANGUL SYLLABLE MUL) */
    {{'\xeb', '\xac', '\xbd'}, 3, 0xBB3D}, /* (HANGUL SYLLABLE MULG) */
    {{'\xeb', '\xac', '\xbe'}, 3, 0xBB3E}, /* (HANGUL SYLLABLE MULM) */
    {{'\xeb', '\xad', '\x84'}, 3, 0xBB44}, /* (HANGUL SYLLABLE MUM) */
    {{'\xeb', '\xad', '\x85'}, 3, 0xBB45}, /* (HANGUL SYLLABLE MUB) */
    {{'\xeb', '\xad', '\x87'}, 3, 0xBB47}, /* (HANGUL SYLLABLE MUS) */
    {{'\xeb', '\xad', '\x89'}, 3, 0xBB49}, /* (HANGUL SYLLABLE MUNG) */
    {{'\xeb', '\xad', '\x8d'}, 3, 0xBB4D}, /* (HANGUL SYLLABLE MUT) */
    {{'\xeb', '\xad', '\x8f'}, 3, 0xBB4F}, /* (HANGUL SYLLABLE MUH) */
    {{'\xeb', '\xad', '\x90'}, 3, 0xBB50}, /* (HANGUL SYLLABLE MWEO) */
    {{'\xeb', '\xad', '\x94'}, 3, 0xBB54}, /* (HANGUL SYLLABLE MWEON) */
    {{'\xeb', '\xad', '\x98'}, 3, 0xBB58}, /* (HANGUL SYLLABLE MWEOL) */
    {{'\xeb', '\xad', '\xa1'}, 3, 0xBB61}, /* (HANGUL SYLLABLE MWEOB) */
    {{'\xeb', '\xad', '\xa3'}, 3, 0xBB63}, /* (HANGUL SYLLABLE MWEOS) */
    {{'\xeb', '\xad', '\xac'}, 3, 0xBB6C}, /* (HANGUL SYLLABLE MWE) */
    {{'\xeb', '\xae', '\x88'}, 3, 0xBB88}, /* (HANGUL SYLLABLE MWI) */
    {{'\xeb', '\xae', '\x8c'}, 3, 0xBB8C}, /* (HANGUL SYLLABLE MWIN) */
    {{'\xeb', '\xae', '\x90'}, 3, 0xBB90}, /* (HANGUL SYLLABLE MWIL) */
    {{'\xeb', '\xae', '\xa4'}, 3, 0xBBA4}, /* (HANGUL SYLLABLE MYU) */
    {{'\xeb', '\xae', '\xa8'}, 3, 0xBBA8}, /* (HANGUL SYLLABLE MYUN) */
    {{'\xeb', '\xae', '\xac'}, 3, 0xBBAC}, /* (HANGUL SYLLABLE MYUL) */
    {{'\xeb', '\xae', '\xb4'}, 3, 0xBBB4}, /* (HANGUL SYLLABLE MYUM) */
    {{'\xeb', '\xae', '\xb7'}, 3, 0xBBB7}, /* (HANGUL SYLLABLE MYUS) */
    {{'\xeb', '\xaf', '\x80'}, 3, 0xBBC0}, /* (HANGUL SYLLABLE MEU) */
    {{'\xeb', '\xaf', '\x84'}, 3, 0xBBC4}, /* (HANGUL SYLLABLE MEUN) */
    {{'\xeb', '\xaf', '\x88'}, 3, 0xBBC8}, /* (HANGUL SYLLABLE MEUL) */
    {{'\xeb', '\xaf', '\x90'}, 3, 0xBBD0}, /* (HANGUL SYLLABLE MEUM) */
    {{'\xeb', '\xaf', '\x93'}, 3, 0xBBD3}, /* (HANGUL SYLLABLE MEUS) */
    {{'\xeb', '\xaf', '\xb8'}, 3, 0xBBF8}, /* (HANGUL SYLLABLE MI) */
    {{'\xeb', '\xaf', '\xb9'}, 3, 0xBBF9}, /* (HANGUL SYLLABLE MIG) */
    {{'\xeb', '\xaf', '\xbc'}, 3, 0xBBFC}, /* (HANGUL SYLLABLE MIN) */
    {{'\xeb', '\xaf', '\xbf'}, 3, 0xBBFF}, /* (HANGUL SYLLABLE MID) */
    {{'\xeb', '\xb0', '\x80'}, 3, 0xBC00}, /* (HANGUL SYLLABLE MIL) */
    {{'\xeb', '\xb0', '\x82'}, 3, 0xBC02}, /* (HANGUL SYLLABLE MILM) */
    {{'\xeb', '\xb0', '\x88'}, 3, 0xBC08}, /* (HANGUL SYLLABLE MIM) */
    {{'\xeb', '\xb0', '\x89'}, 3, 0xBC09}, /* (HANGUL SYLLABLE MIB) */
    {{'\xeb', '\xb0', '\x8b'}, 3, 0xBC0B}, /* (HANGUL SYLLABLE MIS) */
    {{'\xeb', '\xb0', '\x8c'}, 3, 0xBC0C}, /* (HANGUL SYLLABLE MISS) */
    {{'\xeb', '\xb0', '\x8d'}, 3, 0xBC0D}, /* (HANGUL SYLLABLE MING) */
    {{'\xeb', '\xb0', '\x8f'}, 3, 0xBC0F}, /* (HANGUL SYLLABLE MIC) */
    {{'\xeb', '\xb0', '\x91'}, 3, 0xBC11}, /* (HANGUL SYLLABLE MIT) */
    {{'\xeb', '\xb0', '\x94'}, 3, 0xBC14}, /* (HANGUL SYLLABLE BA) */
    {{'\xeb', '\xb0', '\x95'}, 3, 0xBC15}, /* (HANGUL SYLLABLE BAG) */
    {{'\xeb', '\xb0', '\x96'}, 3, 0xBC16}, /* (HANGUL SYLLABLE BAGG) */
    {{'\xeb', '\xb0', '\x97'}, 3, 0xBC17}, /* (HANGUL SYLLABLE BAGS) */
    {{'\xeb', '\xb0', '\x98'}, 3, 0xBC18}, /* (HANGUL SYLLABLE BAN) */
    {{'\xeb', '\xb0', '\x9b'}, 3, 0xBC1B}, /* (HANGUL SYLLABLE BAD) */
    {{'\xeb', '\xb0', '\x9c'}, 3, 0xBC1C}, /* (HANGUL SYLLABLE BAL) */
    {{'\xeb', '\xb0', '\x9d'}, 3, 0xBC1D}, /* (HANGUL SYLLABLE BALG) */
    {{'\xeb', '\xb0', '\x9e'}, 3, 0xBC1E}, /* (HANGUL SYLLABLE BALM) */
    {{'\xeb', '\xb0', '\x9f'}, 3, 0xBC1F}, /* (HANGUL SYLLABLE BALB) */
    {{'\xeb', '\xb0', '\xa4'}, 3, 0xBC24}, /* (HANGUL SYLLABLE BAM) */
    {{'\xeb', '\xb0', '\xa5'}, 3, 0xBC25}, /* (HANGUL SYLLABLE BAB) */
    {{'\xeb', '\xb0', '\xa7'}, 3, 0xBC27}, /* (HANGUL SYLLABLE BAS) */
    {{'\xeb', '\xb0', '\xa9'}, 3, 0xBC29}, /* (HANGUL SYLLABLE BANG) */
    {{'\xeb', '\xb0', '\xad'}, 3, 0xBC2D}, /* (HANGUL SYLLABLE BAT) */
    {{'\xeb', '\xb0', '\xb0'}, 3, 0xBC30}, /* (HANGUL SYLLABLE BAE) */
    {{'\xeb', '\xb0', '\xb1'}, 3, 0xBC31}, /* (HANGUL SYLLABLE BAEG) */
    {{'\xeb', '\xb0', '\xb4'}, 3, 0xBC34}, /* (HANGUL SYLLABLE BAEN) */
    {{'\xeb', '\xb0', '\xb8'}, 3, 0xBC38}, /* (HANGUL SYLLABLE BAEL) */
    {{'\xeb', '\xb1', '\x80'}, 3, 0xBC40}, /* (HANGUL SYLLABLE BAEM) */
    {{'\xeb', '\xb1', '\x81'}, 3, 0xBC41}, /* (HANGUL SYLLABLE BAEB) */
    {{'\xeb', '\xb1', '\x83'}, 3, 0xBC43}, /* (HANGUL SYLLABLE BAES) */
    {{'\xeb', '\xb1', '\x84'}, 3, 0xBC44}, /* (HANGUL SYLLABLE BAESS) */
    {{'\xeb', '\xb1', '\x85'}, 3, 0xBC45}, /* (HANGUL SYLLABLE BAENG) */
    {{'\xeb', '\xb1', '\x89'}, 3, 0xBC49}, /* (HANGUL SYLLABLE BAET) */
    {{'\xeb', '\xb1', '\x8c'}, 3, 0xBC4C}, /* (HANGUL SYLLABLE BYA) */
    {{'\xeb', '\xb1', '\x8d'}, 3, 0xBC4D}, /* (HANGUL SYLLABLE BYAG) */
    {{'\xeb', '\xb1', '\x90'}, 3, 0xBC50}, /* (HANGUL SYLLABLE BYAN) */
    {{'\xeb', '\xb1', '\x9d'}, 3, 0xBC5D}, /* (HANGUL SYLLABLE BYAB) */
    {{'\xeb', '\xb2', '\x84'}, 3, 0xBC84}, /* (HANGUL SYLLABLE BEO) */
    {{'\xeb', '\xb2', '\x85'}, 3, 0xBC85}, /* (HANGUL SYLLABLE BEOG) */
    {{'\xeb', '\xb2', '\x88'}, 3, 0xBC88}, /* (HANGUL SYLLABLE BEON) */
    {{'\xeb', '\xb2', '\x8b'}, 3, 0xBC8B}, /* (HANGUL SYLLABLE BEOD) */
    {{'\xeb', '\xb2', '\x8c'}, 3, 0xBC8C}, /* (HANGUL SYLLABLE BEOL) */
    {{'\xeb', '\xb2', '\x8e'}, 3, 0xBC8E}, /* (HANGUL SYLLABLE BEOLM) */
    {{'\xeb', '\xb2', '\x94'}, 3, 0xBC94}, /* (HANGUL SYLLABLE BEOM) */
    {{'\xeb', '\xb2', '\x95'}, 3, 0xBC95}, /* (HANGUL SYLLABLE BEOB) */
    {{'\xeb', '\xb2', '\x97'}, 3, 0xBC97}, /* (HANGUL SYLLABLE BEOS) */
    {{'\xed', '\x8a', '\x8d'}, 3, 0xD28D}, /* (HANGUL SYLLABLE TWILT) */
    {{'\xed', '\x8a', '\x8e'}, 3, 0xD28E}, /* (HANGUL SYLLABLE TWILP) */
    {{'\xed', '\x8a', '\x8f'}, 3, 0xD28F}, /* (HANGUL SYLLABLE TWILH) */
    {{'\xed', '\x8a', '\x92'}, 3, 0xD292}, /* (HANGUL SYLLABLE TWIBS) */
    {{'\xed', '\x8a', '\x93'}, 3, 0xD293}, /* (HANGUL SYLLABLE TWIS) */
    {{'\xed', '\x8a', '\x94'}, 3, 0xD294}, /* (HANGUL SYLLABLE TWISS) */
    {{'\xed', '\x8a', '\x96'}, 3, 0xD296}, /* (HANGUL SYLLABLE TWIJ) */
    {{'\xed', '\x8a', '\x97'}, 3, 0xD297}, /* (HANGUL SYLLABLE TWIC) */
    {{'\xed', '\x8a', '\x98'}, 3, 0xD298}, /* (HANGUL SYLLABLE TWIK) */
    {{'\xed', '\x8a', '\x99'}, 3, 0xD299}, /* (HANGUL SYLLABLE TWIT) */
    {{'\xed', '\x8a', '\x9a'}, 3, 0xD29A}, /* (HANGUL SYLLABLE TWIP) */
    {{'\xed', '\x8a', '\x9b'}, 3, 0xD29B}, /* (HANGUL SYLLABLE TWIH) */
    {{'\xed', '\x8a', '\x9d'}, 3, 0xD29D}, /* (HANGUL SYLLABLE TYUG) */
    {{'\xed', '\x8a', '\x9e'}, 3, 0xD29E}, /* (HANGUL SYLLABLE TYUGG) */
    {{'\xed', '\x8a', '\x9f'}, 3, 0xD29F}, /* (HANGUL SYLLABLE TYUGS) */
    {{'\xed', '\x8a', '\xa1'}, 3, 0xD2A1}, /* (HANGUL SYLLABLE TYUNJ) */
    {{'\xed', '\x8a', '\xa2'}, 3, 0xD2A2}, /* (HANGUL SYLLABLE TYUNH) */
    {{'\xed', '\x8a', '\xa3'}, 3, 0xD2A3}, /* (HANGUL SYLLABLE TYUD) */
    {{'\xed', '\x8a', '\xa5'}, 3, 0xD2A5}, /* (HANGUL SYLLABLE TYULG) */
    {{'\xed', '\x8a', '\xa6'}, 3, 0xD2A6}, /* (HANGUL SYLLABLE TYULM) */
    {{'\xed', '\x8a', '\xa7'}, 3, 0xD2A7}, /* (HANGUL SYLLABLE TYULB) */
    {{'\xed', '\x8a', '\xa8'}, 3, 0xD2A8}, /* (HANGUL SYLLABLE TYULS) */
    {{'\xed', '\x8a', '\xa9'}, 3, 0xD2A9}, /* (HANGUL SYLLABLE TYULT) */
    {{'\xed', '\x8a', '\xaa'}, 3, 0xD2AA}, /* (HANGUL SYLLABLE TYULP) */
    {{'\xed', '\x8a', '\xab'}, 3, 0xD2AB}, /* (HANGUL SYLLABLE TYULH) */
    {{'\xed', '\x8a', '\xad'}, 3, 0xD2AD}, /* (HANGUL SYLLABLE TYUB) */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{'\xed', '\x8a', '\xae'}, 3, 0xD2AE}, /* (HANGUL SYLLABLE TYUBS) */
    {{'\xed', '\x8a', '\xaf'}, 3, 0xD2AF}, /* (HANGUL SYLLABLE TYUS) */
    {{'\xed', '\x8a', '\xb0'}, 3, 0xD2B0}, /* (HANGUL SYLLABLE TYUSS) */
    {{'\xed', '\x8a', '\xb2'}, 3, 0xD2B2}, /* (HANGUL SYLLABLE TYUJ) */
    {{'\xed', '\x8a', '\xb3'}, 3, 0xD2B3}, /* (HANGUL SYLLABLE TYUC) */
    {{'\xed', '\x8a', '\xb4'}, 3, 0xD2B4}, /* (HANGUL SYLLABLE TYUK) */
    {{'\xed', '\x8a', '\xb5'}, 3, 0xD2B5}, /* (HANGUL SYLLABLE TYUT) */
    {{'\xed', '\x8a', '\xb6'}, 3, 0xD2B6}, /* (HANGUL SYLLABLE TYUP) */
    {{'\xed', '\x8a', '\xb7'}, 3, 0xD2B7}, /* (HANGUL SYLLABLE TYUH) */
    {{'\xed', '\x8a', '\xba'}, 3, 0xD2BA}, /* (HANGUL SYLLABLE TEUGG) */
    {{'\xed', '\x8a', '\xbb'}, 3, 0xD2BB}, /* (HANGUL SYLLABLE TEUGS) */
    {{'\xed', '\x8a', '\xbd'}, 3, 0xD2BD}, /* (HANGUL SYLLABLE TEUNJ) */
    {{'\xed', '\x8a', '\xbe'}, 3, 0xD2BE}, /* (HANGUL SYLLABLE TEUNH) */
    {{'\xed', '\x8b', '\x81'}, 3, 0xD2C1}, /* (HANGUL SYLLABLE TEULG) */
    {{'\xed', '\x8b', '\x83'}, 3, 0xD2C3}, /* (HANGUL SYLLABLE TEULB) */
    {{'\xed', '\x8b', '\x84'}, 3, 0xD2C4}, /* (HANGUL SYLLABLE TEULS) */
    {{'\xed', '\x8b', '\x85'}, 3, 0xD2C5}, /* (HANGUL SYLLABLE TEULT) */
    {{'\xed', '\x8b', '\x86'}, 3, 0xD2C6}, /* (HANGUL SYLLABLE TEULP) */
    {{'\xed', '\x8b', '\x87'}, 3, 0xD2C7}, /* (HANGUL SYLLABLE TEULH) */
    {{'\xed', '\x8b', '\x8a'}, 3, 0xD2CA}, /* (HANGUL SYLLABLE TEUBS) */
    {{'\xed', '\x8b', '\x8c'}, 3, 0xD2CC}, /* (HANGUL SYLLABLE TEUSS) */
    {{'\xed', '\x8b', '\x8d'}, 3, 0xD2CD}, /* (HANGUL SYLLABLE TEUNG) */
    {{'\xed', '\x8b', '\x8e'}, 3, 0xD2CE}, /* (HANGUL SYLLABLE TEUJ) */
    {{'\xed', '\x8b', '\x8f'}, 3, 0xD2CF}, /* (HANGUL SYLLABLE TEUC) */
    {{'\xed', '\x8b', '\x90'}, 3, 0xD2D0}, /* (HANGUL SYLLABLE TEUK) */
    {{'\xed', '\x8b', '\x91'}, 3, 0xD2D1}, /* (HANGUL SYLLABLE TEUT) */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{'\xed', '\x8b', '\x92'}, 3, 0xD2D2}, /* (HANGUL SYLLABLE TEUP) */
    {{'\xed', '\x8b', '\x93'}, 3, 0xD2D3}, /* (HANGUL SYLLABLE TEUH) */
    {{'\xed', '\x8b', '\x95'}, 3, 0xD2D5}, /* (HANGUL SYLLABLE TYIG) */
    {{'\xed', '\x8b', '\x96'}, 3, 0xD2D6}, /* (HANGUL SYLLABLE TYIGG) */
    {{'\xed', '\x8b', '\x97'}, 3, 0xD2D7}, /* (HANGUL SYLLABLE TYIGS) */
    {{'\xed', '\x8b', '\x99'}, 3, 0xD2D9}, /* (HANGUL SYLLABLE TYINJ) */
    {{'\xed', '\x8b', '\x9a'}, 3, 0xD2DA}, /* (HANGUL SYLLABLE TYINH) */
    {{'\xed', '\x8b', '\x9b'}, 3, 0xD2DB}, /* (HANGUL SYLLABLE TYID) */
    {{'\xed', '\x8b', '\x9d'}, 3, 0xD2DD}, /* (HANGUL SYLLABLE TYILG) */
    {{'\xed', '\x8b', '\x9e'}, 3, 0xD2DE}, /* (HANGUL SYLLABLE TYILM) */
    {{'\xed', '\x8b', '\x9f'}, 3, 0xD2DF}, /* (HANGUL SYLLABLE TYILB) */
    {{'\xed', '\x8b', '\xa0'}, 3, 0xD2E0}, /* (HANGUL SYLLABLE TYILS) */
    {{'\xed', '\x8b', '\xa1'}, 3, 0xD2E1}, /* (HANGUL SYLLABLE TYILT) */
    {{'\xed', '\x8b', '\xa2'}, 3, 0xD2E2}, /* (HANGUL SYLLABLE TYILP) */
    {{'\xed', '\x8b', '\xa3'}, 3, 0xD2E3}, /* (HANGUL SYLLABLE TYILH) */
    {{'\xed', '\x8b', '\xa6'}, 3, 0xD2E6}, /* (HANGUL SYLLABLE TYIBS) */
    {{'\xed', '\x8b', '\xa7'}, 3, 0xD2E7}, /* (HANGUL SYLLABLE TYIS) */
    {{'\xed', '\x8b', '\xa8'}, 3, 0xD2E8}, /* (HANGUL SYLLABLE TYISS) */
    {{'\xed', '\x8b', '\xa9'}, 3, 0xD2E9}, /* (HANGUL SYLLABLE TYING) */
    {{'\xed', '\x8b', '\xaa'}, 3, 0xD2EA}, /* (HANGUL SYLLABLE TYIJ) */
    {{'\xed', '\x8b', '\xab'}, 3, 0xD2EB}, /* (HANGUL SYLLABLE TYIC) */
    {{'\xed', '\x8b', '\xac'}, 3, 0xD2EC}, /* (HANGUL SYLLABLE TYIK) */
    {{'\xed', '\x8b', '\xad'}, 3, 0xD2ED}, /* (HANGUL SYLLABLE TYIT) */
    {{'\xed', '\x8b', '\xae'}, 3, 0xD2EE}, /* (HANGUL SYLLABLE TYIP) */
    {{'\xed', '\x8b', '\xaf'}, 3, 0xD2EF}, /* (HANGUL SYLLABLE TYIH) */
    {{'\xed', '\x8b', '\xb2'}, 3, 0xD2F2}, /* (HANGUL SYLLABLE TIGG) */
    {{'\xed', '\x8b', '\xb3'}, 3, 0xD2F3}, /* (HANGUL SYLLABLE TIGS) */
    {{'\xed', '\x8b', '\xb5'}, 3, 0xD2F5}, /* (HANGUL SYLLABLE TINJ) */
    {{'\xed', '\x8b', '\xb6'}, 3, 0xD2F6}, /* (HANGUL SYLLABLE TINH) */
    {{'\xed', '\x8b', '\xb7'}, 3, 0xD2F7}, /* (HANGUL SYLLABLE TID) */
    {{'\xed', '\x8b', '\xb9'}, 3, 0xD2F9}, /* (HANGUL SYLLABLE TILG) */
    {{'\xed', '\x8b', '\xba'}, 3, 0xD2FA}, /* (HANGUL SYLLABLE TILM) */
    {{'\xeb', '\xb2', '\x99'}, 3, 0xBC99}, /* (HANGUL SYLLABLE BEONG) */
    {{'\xeb', '\xb2', '\x9a'}, 3, 0xBC9A}, /* (HANGUL SYLLABLE BEOJ) */
    {{'\xeb', '\xb2', '\xa0'}, 3, 0xBCA0}, /* (HANGUL SYLLABLE BE) */
    {{'\xeb', '\xb2', '\xa1'}, 3, 0xBCA1}, /* (HANGUL SYLLABLE BEG) */
    {{'\xeb', '\xb2', '\xa4'}, 3, 0xBCA4}, /* (HANGUL SYLLABLE BEN) */
    {{'\xeb', '\xb2', '\xa7'}, 3, 0xBCA7}, /* (HANGUL SYLLABLE BED) */
    {{'\xeb', '\xb2', '\xa8'}, 3, 0xBCA8}, /* (HANGUL SYLLABLE BEL) */
    {{'\xeb', '\xb2', '\xb0'}, 3, 0xBCB0}, /* (HANGUL SYLLABLE BEM) */
    {{'\xeb', '\xb2', '\xb1'}, 3, 0xBCB1}, /* (HANGUL SYLLABLE BEB) */
    {{'\xeb', '\xb2', '\xb3'}, 3, 0xBCB3}, /* (HANGUL SYLLABLE BES) */
    {{'\xeb', '\xb2', '\xb4'}, 3, 0xBCB4}, /* (HANGUL SYLLABLE BESS) */
    {{'\xeb', '\xb2', '\xb5'}, 3, 0xBCB5}, /* (HANGUL SYLLABLE BENG) */
    {{'\xeb', '\xb2', '\xbc'}, 3, 0xBCBC}, /* (HANGUL SYLLABLE BYEO) */
    {{'\xeb', '\xb2', '\xbd'}, 3, 0xBCBD}, /* (HANGUL SYLLABLE BYEOG) */
    {{'\xeb', '\xb3', '\x80'}, 3, 0xBCC0}, /* (HANGUL SYLLABLE BYEON) */
    {{'\xeb', '\xb3', '\x84'}, 3, 0xBCC4}, /* (HANGUL SYLLABLE BYEOL) */
    {{'\xeb', '\xb3', '\x8d'}, 3, 0xBCCD}, /* (HANGUL SYLLABLE BYEOB) */
    {{'\xeb', '\xb3', '\x8f'}, 3, 0xBCCF}, /* (HANGUL SYLLABLE BYEOS) */
    {{'\xeb', '\xb3', '\x90'}, 3, 0xBCD0}, /* (HANGUL SYLLABLE BYEOSS) */
    {{'\xeb', '\xb3', '\x91'}, 3, 0xBCD1}, /* (HANGUL SYLLABLE BYEONG) */
    {{'\xeb', '\xb3', '\x95'}, 3, 0xBCD5}, /* (HANGUL SYLLABLE BYEOT) */
    {{'\xeb', '\xb3', '\x98'}, 3, 0xBCD8}, /* (HANGUL SYLLABLE BYE) */
    {{'\xeb', '\xb3', '\x9c'}, 3, 0xBCDC}, /* (HANGUL SYLLABLE BYEN) */
    {{'\xeb', '\xb3', '\xb4'}, 3, 0xBCF4}, /* (HANGUL SYLLABLE BO) */
    {{'\xeb', '\xb3', '\xb5'}, 3, 0xBCF5}, /* (HANGUL SYLLABLE BOG) */
    {{'\xeb', '\xb3', '\xb6'}, 3, 0xBCF6}, /* (HANGUL SYLLABLE BOGG) */
    {{'\xeb', '\xb3', '\xb8'}, 3, 0xBCF8}, /* (HANGUL SYLLABLE BON) */
    {{'\xeb', '\xb3', '\xbc'}, 3, 0xBCFC}, /* (HANGUL SYLLABLE BOL) */
    {{'\xeb', '\xb4', '\x84'}, 3, 0xBD04}, /* (HANGUL SYLLABLE BOM) */
    {{'\xeb', '\xb4', '\x85'}, 3, 0xBD05}, /* (HANGUL SYLLABLE BOB) */
    {{'\xeb', '\xb4', '\x87'}, 3, 0xBD07}, /* (HANGUL SYLLABLE BOS) */
    {{'\xeb', '\xb4', '\x89'}, 3, 0xBD09}, /* (HANGUL SYLLABLE BONG) */
    {{'\xeb', '\xb4', '\x90'}, 3, 0xBD10}, /* (HANGUL SYLLABLE BWA) */
    {{'\xeb', '\xb4', '\x94'}, 3, 0xBD14}, /* (HANGUL SYLLABLE BWAN) */
    {{'\xeb', '\xb4', '\xa4'}, 3, 0xBD24}, /* (HANGUL SYLLABLE BWASS) */
    {{'\xeb', '\xb4', '\xac'}, 3, 0xBD2C}, /* (HANGUL SYLLABLE BWAE) */
    {{'\xeb', '\xb5', '\x80'}, 3, 0xBD40}, /* (HANGUL SYLLABLE BWAESS) */
    {{'\xeb', '\xb5', '\x88'}, 3, 0xBD48}, /* (HANGUL SYLLABLE BOE) */
    {{'\xeb', '\xb5', '\x89'}, 3, 0xBD49}, /* (HANGUL SYLLABLE BOEG) */
    {{'\xeb', '\xb5', '\x8c'}, 3, 0xBD4C}, /* (HANGUL SYLLABLE BOEN) */
    {{'\xeb', '\xb5', '\x90'}, 3, 0xBD50}, /* (HANGUL SYLLABLE BOEL) */
    {{'\xeb', '\xb5', '\x98'}, 3, 0xBD58}, /* (HANGUL SYLLABLE BOEM) */
    {{'\xeb', '\xb5', '\x99'}, 3, 0xBD59}, /* (HANGUL SYLLABLE BOEB) */
    {{'\xeb', '\xb5', '\xa4'}, 3, 0xBD64}, /* (HANGUL SYLLABLE BYO) */
    {{'\xeb', '\xb5', '\xa8'}, 3, 0xBD68}, /* (HANGUL SYLLABLE BYON) */
    {{'\xeb', '\xb6', '\x80'}, 3, 0xBD80}, /* (HANGUL SYLLABLE BU) */
    {{'\xeb', '\xb6', '\x81'}, 3, 0xBD81}, /* (HANGUL SYLLABLE BUG) */
    {{'\xeb', '\xb6', '\x84'}, 3, 0xBD84}, /* (HANGUL SYLLABLE BUN) */
    {{'\xeb', '\xb6', '\x87'}, 3, 0xBD87}, /* (HANGUL SYLLABLE BUD) */
    {{'\xeb', '\xb6', '\x88'}, 3, 0xBD88}, /* (HANGUL SYLLABLE BUL) */
    {{'\xeb', '\xb6', '\x89'}, 3, 0xBD89}, /* (HANGUL SYLLABLE BULG) */
    {{'\xeb', '\xb6', '\x8a'}, 3, 0xBD8A}, /* (HANGUL SYLLABLE BULM) */
    {{'\xeb', '\xb6', '\x90'}, 3, 0xBD90}, /* (HANGUL SYLLABLE BUM) */
    {{'\xeb', '\xb6', '\x91'}, 3, 0xBD91}, /* (HANGUL SYLLABLE BUB) */
    {{'\xeb', '\xb6', '\x93'}, 3, 0xBD93}, /* (HANGUL SYLLABLE BUS) */
    {{'\xeb', '\xb6', '\x95'}, 3, 0xBD95}, /* (HANGUL SYLLABLE BUNG) */
    {{'\xeb', '\xb6', '\x99'}, 3, 0xBD99}, /* (HANGUL SYLLABLE BUT) */
    {{'\xeb', '\xb6', '\x9a'}, 3, 0xBD9A}, /* (HANGUL SYLLABLE BUP) */
    {{'\xeb', '\xb6', '\x9c'}, 3, 0xBD9C}, /* (HANGUL SYLLABLE BWEO) */
    {{'\xeb', '\xb6', '\xa4'}, 3, 0xBDA4}, /* (HANGUL SYLLABLE BWEOL) */
    {{'\xeb', '\xb6', '\xb0'}, 3, 0xBDB0}, /* (HANGUL SYLLABLE BWEOSS) */
    {{'\xeb', '\xb6', '\xb8'}, 3, 0xBDB8}, /* (HANGUL SYLLABLE BWE) */
    {{'\xeb', '\xb7', '\x94'}, 3, 0xBDD4}, /* (HANGUL SYLLABLE BWI) */
    {{'\xeb', '\xb7', '\x95'}, 3, 0xBDD5}, /* (HANGUL SYLLABLE BWIG) */
    {{'\xeb', '\xb7', '\x98'}, 3, 0xBDD8}, /* (HANGUL SYLLABLE BWIN) */
    {{'\xeb', '\xb7', '\x9c'}, 3, 0xBDDC}, /* (HANGUL SYLLABLE BWIL) */
    {{'\xeb', '\xb7', '\xa9'}, 3, 0xBDE9}, /* (HANGUL SYLLABLE BWING) */
    {{'\xeb', '\xb7', '\xb0'}, 3, 0xBDF0}, /* (HANGUL SYLLABLE BYU) */
    {{'\xeb', '\xb7', '\xb4'}, 3, 0xBDF4}, /* (HANGUL SYLLABLE BYUN) */
    {{'\xeb', '\xb7', '\xb8'}, 3, 0xBDF8}, /* (HANGUL SYLLABLE BYUL) */
    {{'\xeb', '\xb8', '\x80'}, 3, 0xBE00}, /* (HANGUL SYLLABLE BYUM) */
    {{'\xeb', '\xb8', '\x83'}, 3, 0xBE03}, /* (HANGUL SYLLABLE BYUS) */
    {{'\xeb', '\xb8', '\x85'}, 3, 0xBE05}, /* (HANGUL SYLLABLE BYUNG) */
    {{'\xeb', '\xb8', '\x8c'}, 3, 0xBE0C}, /* (HANGUL SYLLABLE BEU) */
    {{'\xeb', '\xb8', '\x8d'}, 3, 0xBE0D}, /* (HANGUL SYLLABLE BEUG) */
    {{'\xeb', '\xb8', '\x90'}, 3, 0xBE10}, /* (HANGUL SYLLABLE BEUN) */
    {{'\xeb', '\xb8', '\x94'}, 3, 0xBE14}, /* (HANGUL SYLLABLE BEUL) */
    {{'\xeb', '\xb8', '\x9c'}, 3, 0xBE1C}, /* (HANGUL SYLLABLE BEUM) */
    {{'\xeb', '\xb8', '\x9d'}, 3, 0xBE1D}, /* (HANGUL SYLLABLE BEUB) */
    {{'\xeb', '\xb8', '\x9f'}, 3, 0xBE1F}, /* (HANGUL SYLLABLE BEUS) */
    {{'\xeb', '\xb9', '\x84'}, 3, 0xBE44}, /* (HANGUL SYLLABLE BI) */
    {{'\xeb', '\xb9', '\x85'}, 3, 0xBE45}, /* (HANGUL SYLLABLE BIG) */
    {{'\xeb', '\xb9', '\x88'}, 3, 0xBE48}, /* (HANGUL SYLLABLE BIN) */
    {{'\xeb', '\xb9', '\x8c'}, 3, 0xBE4C}, /* (HANGUL SYLLABLE BIL) */
    {{'\xeb', '\xb9', '\x8e'}, 3, 0xBE4E}, /* (HANGUL SYLLABLE BILM) */
    {{'\xeb', '\xb9', '\x94'}, 3, 0xBE54}, /* (HANGUL SYLLABLE BIM) */
    {{'\xeb', '\xb9', '\x95'}, 3, 0xBE55}, /* (HANGUL SYLLABLE BIB) */
    {{'\xeb', '\xb9', '\x97'}, 3, 0xBE57}, /* (HANGUL SYLLABLE BIS) */
    {{'\xeb', '\xb9', '\x99'}, 3, 0xBE59}, /* (HANGUL SYLLABLE BING) */
    {{'\xeb', '\xb9', '\x9a'}, 3, 0xBE5A}, /* (HANGUL SYLLABLE BIJ) */
    {{'\xeb', '\xb9', '\x9b'}, 3, 0xBE5B}, /* (HANGUL SYLLABLE BIC) */
    {{'\xeb', '\xb9', '\xa0'}, 3, 0xBE60}, /* (HANGUL SYLLABLE BBA) */
    {{'\xeb', '\xb9', '\xa1'}, 3, 0xBE61}, /* (HANGUL SYLLABLE BBAG) */
    {{'\xeb', '\xb9', '\xa4'}, 3, 0xBE64}, /* (HANGUL SYLLABLE BBAN) */
    {{'\xed', '\x8b', '\xbb'}, 3, 0xD2FB}, /* (HANGUL SYLLABLE TILB) */
    {{'\xed', '\x8b', '\xbc'}, 3, 0xD2FC}, /* (HANGUL SYLLABLE TILS) */
    {{'\xed', '\x8b', '\xbd'}, 3, 0xD2FD}, /* (HANGUL SYLLABLE TILT) */
    {{'\xed', '\x8b', '\xbe'}, 3, 0xD2FE}, /* (HANGUL SYLLABLE TILP) */
    {{'\xed', '\x8b', '\xbf'}, 3, 0xD2FF}, /* (HANGUL SYLLABLE TILH) */
    {{'\xed', '\x8c', '\x82'}, 3, 0xD302}, /* (HANGUL SYLLABLE TIBS) */
    {{'\xed', '\x8c', '\x84'}, 3, 0xD304}, /* (HANGUL SYLLABLE TISS) */
    {{'\xed', '\x8c', '\x86'}, 3, 0xD306}, /* (HANGUL SYLLABLE TIJ) */
    {{'\xed', '\x8c', '\x87'}, 3, 0xD307}, /* (HANGUL SYLLABLE TIC) */
    {{'\xed', '\x8c', '\x88'}, 3, 0xD308}, /* (HANGUL SYLLABLE TIK) */
    {{'\xed', '\x8c', '\x89'}, 3, 0xD309}, /* (HANGUL SYLLABLE TIT) */
    {{'\xed', '\x8c', '\x8a'}, 3, 0xD30A}, /* (HANGUL SYLLABLE TIP) */
    {{'\xed', '\x8c', '\x8b'}, 3, 0xD30B}, /* (HANGUL SYLLABLE TIH) */
    {{'\xed', '\x8c', '\x8f'}, 3, 0xD30F}, /* (HANGUL SYLLABLE PAGS) */
    {{'\xed', '\x8c', '\x91'}, 3, 0xD311}, /* (HANGUL SYLLABLE PANJ) */
    {{'\xed', '\x8c', '\x92'}, 3, 0xD312}, /* (HANGUL SYLLABLE PANH) */
    {{'\xed', '\x8c', '\x93'}, 3, 0xD313}, /* (HANGUL SYLLABLE PAD) */
    {{'\xed', '\x8c', '\x95'}, 3, 0xD315}, /* (HANGUL SYLLABLE PALG) */
    {{'\xed', '\x8c', '\x97'}, 3, 0xD317}, /* (HANGUL SYLLABLE PALB) */
    {{'\xed', '\x8c', '\x98'}, 3, 0xD318}, /* (HANGUL SYLLABLE PALS) */
    {{'\xed', '\x8c', '\x99'}, 3, 0xD319}, /* (HANGUL SYLLABLE PALT) */
    {{'\xed', '\x8c', '\x9a'}, 3, 0xD31A}, /* (HANGUL SYLLABLE PALP) */
    {{'\xed', '\x8c', '\x9b'}, 3, 0xD31B}, /* (HANGUL SYLLABLE PALH) */
    {{'\xed', '\x8c', '\x9e'}, 3, 0xD31E}, /* (HANGUL SYLLABLE PABS) */
    {{'\xed', '\x8c', '\xa2'}, 3, 0xD322}, /* (HANGUL SYLLABLE PAJ) */
    {{'\xed', '\x8c', '\xa3'}, 3, 0xD323}, /* (HANGUL SYLLABLE PAC) */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{'\xed', '\x8c', '\xa4'}, 3, 0xD324}, /* (HANGUL SYLLABLE PAK) */
    {{'\xed', '\x8c', '\xa6'}, 3, 0xD326}, /* (HANGUL SYLLABLE PAP) */
    {{'\xed', '\x8c', '\xa7'}, 3, 0xD327}, /* (HANGUL SYLLABLE PAH) */
    {{'\xed', '\x8c', '\xaa'}, 3, 0xD32A}, /* (HANGUL SYLLABLE PAEGG) */
    {{'\xed', '\x8c', '\xab'}, 3, 0xD32B}, /* (HANGUL SYLLABLE PAEGS) */
    {{'\xed', '\x8c', '\xad'}, 3, 0xD32D}, /* (HANGUL SYLLABLE PAENJ) */
    {{'\xed', '\x8c', '\xae'}, 3, 0xD32E}, /* (HANGUL SYLLABLE PAENH) */
    {{'\xed', '\x8c', '\xaf'}, 3, 0xD32F}, /* (HANGUL SYLLABLE PAED) */
    {{'\xed', '\x8c', '\xb1'}, 3, 0xD331}, /* (HANGUL SYLLABLE PAELG) */
    {{'\xed', '\x8c', '\xb2'}, 3, 0xD332}, /* (HANGUL SYLLABLE PAELM) */
    {{'\xed', '\x8c', '\xb3'}, 3, 0xD333}, /* (HANGUL SYLLABLE PAELB) */
    {{'\xed', '\x8c', '\xb4'}, 3, 0xD334}, /* (HANGUL SYLLABLE PAELS) */
    {{'\xed', '\x8c', '\xb5'}, 3, 0xD335}, /* (HANGUL SYLLABLE PAELT) */
    {{'\xed', '\x8c', '\xb6'}, 3, 0xD336}, /* (HANGUL SYLLABLE PAELP) */
    {{'\xed', '\x8c', '\xb7'}, 3, 0xD337}, /* (HANGUL SYLLABLE PAELH) */
    {{'\xed', '\x8c', '\xba'}, 3, 0xD33A}, /* (HANGUL SYLLABLE PAEBS) */
    {{'\xed', '\x8c', '\xbe'}, 3, 0xD33E}, /* (HANGUL SYLLABLE PAEJ) */
    {{'\xed', '\x8c', '\xbf'}, 3, 0xD33F}, /* (HANGUL SYLLABLE PAEC) */
    {{'\xed', '\x8d', '\x80'}, 3, 0xD340}, /* (HANGUL SYLLABLE PAEK) */
    {{'\xed', '\x8d', '\x81'}, 3, 0xD341}, /* (HANGUL SYLLABLE PAET) */
    {{'\xed', '\x8d', '\x82'}, 3, 0xD342}, /* (HANGUL SYLLABLE PAEP) */
    {{'\xed', '\x8d', '\x83'}, 3, 0xD343}, /* (HANGUL SYLLABLE PAEH) */
    {{'\xed', '\x8d', '\x86'}, 3, 0xD346}, /* (HANGUL SYLLABLE PYAGG) */
    {{'\xed', '\x8d', '\x87'}, 3, 0xD347}, /* (HANGUL SYLLABLE PYAGS) */
    {{'\xed', '\x8d', '\x88'}, 3, 0xD348}, /* (HANGUL SYLLABLE PYAN) */
    {{'\xed', '\x8d', '\x89'}, 3, 0xD349}, /* (HANGUL SYLLABLE PYANJ) */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{'\xed', '\x8d', '\x8a'}, 3, 0xD34A}, /* (HANGUL SYLLABLE PYANH) */
    {{'\xed', '\x8d', '\x8b'}, 3, 0xD34B}, /* (HANGUL SYLLABLE PYAD) */
    {{'\xed', '\x8d', '\x8c'}, 3, 0xD34C}, /* (HANGUL SYLLABLE PYAL) */
    {{'\xed', '\x8d', '\x8d'}, 3, 0xD34D}, /* (HANGUL SYLLABLE PYALG) */
    {{'\xed', '\x8d', '\x8e'}, 3, 0xD34E}, /* (HANGUL SYLLABLE PYALM) */
    {{'\xed', '\x8d', '\x8f'}, 3, 0xD34F}, /* (HANGUL SYLLABLE PYALB) */
    {{'\xed', '\x8d', '\x90'}, 3, 0xD350}, /* (HANGUL SYLLABLE PYALS) */
    {{'\xed', '\x8d', '\x91'}, 3, 0xD351}, /* (HANGUL SYLLABLE PYALT) */
    {{'\xed', '\x8d', '\x92'}, 3, 0xD352}, /* (HANGUL SYLLABLE PYALP) */
    {{'\xed', '\x8d', '\x93'}, 3, 0xD353}, /* (HANGUL SYLLABLE PYALH) */
    {{'\xed', '\x8d', '\x94'}, 3, 0xD354}, /* (HANGUL SYLLABLE PYAM) */
    {{'\xed', '\x8d', '\x95'}, 3, 0xD355}, /* (HANGUL SYLLABLE PYAB) */
    {{'\xed', '\x8d', '\x96'}, 3, 0xD356}, /* (HANGUL SYLLABLE PYABS) */
    {{'\xed', '\x8d', '\x97'}, 3, 0xD357}, /* (HANGUL SYLLABLE PYAS) */
    {{'\xed', '\x8d', '\x98'}, 3, 0xD358}, /* (HANGUL SYLLABLE PYASS) */
    {{'\xed', '\x8d', '\x99'}, 3, 0xD359}, /* (HANGUL SYLLABLE PYANG) */
    {{'\xed', '\x8d', '\x9a'}, 3, 0xD35A}, /* (HANGUL SYLLABLE PYAJ) */
    {{'\xed', '\x8d', '\x9b'}, 3, 0xD35B}, /* (HANGUL SYLLABLE PYAC) */
    {{'\xed', '\x8d', '\x9c'}, 3, 0xD35C}, /* (HANGUL SYLLABLE PYAK) */
    {{'\xed', '\x8d', '\x9d'}, 3, 0xD35D}, /* (HANGUL SYLLABLE PYAT) */
    {{'\xed', '\x8d', '\x9e'}, 3, 0xD35E}, /* (HANGUL SYLLABLE PYAP) */
    {{'\xed', '\x8d', '\x9f'}, 3, 0xD35F}, /* (HANGUL SYLLABLE PYAH) */
    {{'\xed', '\x8d', '\xa0'}, 3, 0xD360}, /* (HANGUL SYLLABLE PYAE) */
    {{'\xed', '\x8d', '\xa1'}, 3, 0xD361}, /* (HANGUL SYLLABLE PYAEG) */
    {{'\xed', '\x8d', '\xa2'}, 3, 0xD362}, /* (HANGUL SYLLABLE PYAEGG) */
    {{'\xed', '\x8d', '\xa3'}, 3, 0xD363}, /* (HANGUL SYLLABLE PYAEGS) */
    {{'\xed', '\x8d', '\xa4'}, 3, 0xD364}, /* (HANGUL SYLLABLE PYAEN) */
    {{'\xed', '\x8d', '\xa5'}, 3, 0xD365}, /* (HANGUL SYLLABLE PYAENJ) */
    {{'\xed', '\x8d', '\xa6'}, 3, 0xD366}, /* (HANGUL SYLLABLE PYAENH) */
    {{'\xed', '\x8d', '\xa7'}, 3, 0xD367}, /* (HANGUL SYLLABLE PYAED) */
    {{'\xed', '\x8d', '\xa8'}, 3, 0xD368}, /* (HANGUL SYLLABLE PYAEL) */
    {{'\xed', '\x8d', '\xa9'}, 3, 0xD369}, /* (HANGUL SYLLABLE PYAELG) */
    {{'\xeb', '\xb9', '\xa8'}, 3, 0xBE68}, /* (HANGUL SYLLABLE BBAL) */
    {{'\xeb', '\xb9', '\xaa'}, 3, 0xBE6A}, /* (HANGUL SYLLABLE BBALM) */
    {{'\xeb', '\xb9', '\xb0'}, 3, 0xBE70}, /* (HANGUL SYLLABLE BBAM) */
    {{'\xeb', '\xb9', '\xb1'}, 3, 0xBE71}, /* (HANGUL SYLLABLE BBAB) */
    {{'\xeb', '\xb9', '\xb3'}, 3, 0xBE73}, /* (HANGUL SYLLABLE BBAS) */
    {{'\xeb', '\xb9', '\xb4'}, 3, 0xBE74}, /* (HANGUL SYLLABLE BBASS) */
    {{'\xeb', '\xb9', '\xb5'}, 3, 0xBE75}, /* (HANGUL SYLLABLE BBANG) */
    {{'\xeb', '\xb9', '\xbb'}, 3, 0xBE7B}, /* (HANGUL SYLLABLE BBAH) */
    {{'\xeb', '\xb9', '\xbc'}, 3, 0xBE7C}, /* (HANGUL SYLLABLE BBAE) */
    {{'\xeb', '\xb9', '\xbd'}, 3, 0xBE7D}, /* (HANGUL SYLLABLE BBAEG) */
    {{'\xeb', '\xba', '\x80'}, 3, 0xBE80}, /* (HANGUL SYLLABLE BBAEN) */
    {{'\xeb', '\xba', '\x84'}, 3, 0xBE84}, /* (HANGUL SYLLABLE BBAEL) */
    {{'\xeb', '\xba', '\x8c'}, 3, 0xBE8C}, /* (HANGUL SYLLABLE BBAEM) */
    {{'\xeb', '\xba', '\x8d'}, 3, 0xBE8D}, /* (HANGUL SYLLABLE BBAEB) */
    {{'\xeb', '\xba', '\x8f'}, 3, 0xBE8F}, /* (HANGUL SYLLABLE BBAES) */
    {{'\xeb', '\xba', '\x90'}, 3, 0xBE90}, /* (HANGUL SYLLABLE BBAESS) */
    {{'\xeb', '\xba', '\x91'}, 3, 0xBE91}, /* (HANGUL SYLLABLE BBAENG) */
    {{'\xeb', '\xba', '\x98'}, 3, 0xBE98}, /* (HANGUL SYLLABLE BBYA) */
    {{'\xeb', '\xba', '\x99'}, 3, 0xBE99}, /* (HANGUL SYLLABLE BBYAG) */
    {{'\xeb', '\xba', '\xa8'}, 3, 0xBEA8}, /* (HANGUL SYLLABLE BBYAM) */
    {{'\xeb', '\xbb', '\x90'}, 3, 0xBED0}, /* (HANGUL SYLLABLE BBEO) */
    {{'\xeb', '\xbb', '\x91'}, 3, 0xBED1}, /* (HANGUL SYLLABLE BBEOG) */
    {{'\xeb', '\xbb', '\x94'}, 3, 0xBED4}, /* (HANGUL SYLLABLE BBEON) */
    {{'\xeb', '\xbb', '\x97'}, 3, 0xBED7}, /* (HANGUL SYLLABLE BBEOD) */
    {{'\xeb', '\xbb', '\x98'}, 3, 0xBED8}, /* (HANGUL SYLLABLE BBEOL) */
    {{'\xeb', '\xbb', '\xa0'}, 3, 0xBEE0}, /* (HANGUL SYLLABLE BBEOM) */
    {{'\xeb', '\xbb', '\xa3'}, 3, 0xBEE3}, /* (HANGUL SYLLABLE BBEOS) */
    {{'\xeb', '\xbb', '\xa4'}, 3, 0xBEE4}, /* (HANGUL SYLLABLE BBEOSS) */
    {{'\xeb', '\xbb', '\xa5'}, 3, 0xBEE5}, /* (HANGUL SYLLABLE BBEONG) */
    {{'\xeb', '\xbb', '\xac'}, 3, 0xBEEC}, /* (HANGUL SYLLABLE BBE) */
    {{'\xeb', '\xbc', '\x81'}, 3, 0xBF01}, /* (HANGUL SYLLABLE BBENG) */
    {{'\xeb', '\xbc', '\x88'}, 3, 0xBF08}, /* (HANGUL SYLLABLE BBYEO) */
    {{'\xeb', '\xbc', '\x89'}, 3, 0xBF09}, /* (HANGUL SYLLABLE BBYEOG) */
    {{'\xeb', '\xbc', '\x98'}, 3, 0xBF18}, /* (HANGUL SYLLABLE BBYEOM) */
    {{'\xeb', '\xbc', '\x99'}, 3, 0xBF19}, /* (HANGUL SYLLABLE BBYEOB) */
    {{'\xeb', '\xbc', '\x9b'}, 3, 0xBF1B}, /* (HANGUL SYLLABLE BBYEOS) */
    {{'\xeb', '\xbc', '\x9c'}, 3, 0xBF1C}, /* (HANGUL SYLLABLE BBYEOSS) */
    {{'\xeb', '\xbc', '\x9d'}, 3, 0xBF1D}, /* (HANGUL SYLLABLE BBYEONG) */
    {{'\xeb', '\xbd', '\x80'}, 3, 0xBF40}, /* (HANGUL SYLLABLE BBO) */
    {{'\xeb', '\xbd', '\x81'}, 3, 0xBF41}, /* (HANGUL SYLLABLE BBOG) */
    {{'\xeb', '\xbd', '\x84'}, 3, 0xBF44}, /* (HANGUL SYLLABLE BBON) */
    {{'\xeb', '\xbd', '\x88'}, 3, 0xBF48}, /* (HANGUL SYLLABLE BBOL) */
    {{'\xeb', '\xbd', '\x90'}, 3, 0xBF50}, /* (HANGUL SYLLABLE BBOM) */
    {{'\xeb', '\xbd', '\x91'}, 3, 0xBF51}, /* (HANGUL SYLLABLE BBOB) */
    {{'\xeb', '\xbd', '\x95'}, 3, 0xBF55}, /* (HANGUL SYLLABLE BBONG) */
    {{'\xeb', '\xbe', '\x94'}, 3, 0xBF94}, /* (HANGUL SYLLABLE BBOE) */
    {{'\xeb', '\xbe', '\xb0'}, 3, 0xBFB0}, /* (HANGUL SYLLABLE BBYO) */
    {{'\xeb', '\xbf', '\x85'}, 3, 0xBFC5}, /* (HANGUL SYLLABLE BBYONG) */
    {{'\xeb', '\xbf', '\x8c'}, 3, 0xBFCC}, /* (HANGUL SYLLABLE BBU) */
    {{'\xeb', '\xbf', '\x8d'}, 3, 0xBFCD}, /* (HANGUL SYLLABLE BBUG) */
    {{'\xeb', '\xbf', '\x90'}, 3, 0xBFD0}, /* (HANGUL SYLLABLE BBUN) */
    {{'\xeb', '\xbf', '\x94'}, 3, 0xBFD4}, /* (HANGUL SYLLABLE BBUL) */
    {{'\xeb', '\xbf', '\x9c'}, 3, 0xBFDC}, /* (HANGUL SYLLABLE BBUM) */
    {{'\xeb', '\xbf', '\x9f'}, 3, 0xBFDF}, /* (HANGUL SYLLABLE BBUS) */
    {{'\xeb', '\xbf', '\xa1'}, 3, 0xBFE1}, /* (HANGUL SYLLABLE BBUNG) */
    {{'\xec', '\x80', '\xbc'}, 3, 0xC03C}, /* (HANGUL SYLLABLE BBYU) */
    {{'\xec', '\x81', '\x91'}, 3, 0xC051}, /* (HANGUL SYLLABLE BBYUNG) */
    {{'\xec', '\x81', '\x98'}, 3, 0xC058}, /* (HANGUL SYLLABLE BBEU) */
    {{'\xec', '\x81', '\x9c'}, 3, 0xC05C}, /* (HANGUL SYLLABLE BBEUN) */
    {{'\xec', '\x81', '\xa0'}, 3, 0xC060}, /* (HANGUL SYLLABLE BBEUL) */
    {{'\xec', '\x81', '\xa8'}, 3, 0xC068}, /* (HANGUL SYLLABLE BBEUM) */
    {{'\xec', '\x81', '\xa9'}, 3, 0xC069}, /* (HANGUL SYLLABLE BBEUB) */
    {{'\xec', '\x82', '\x90'}, 3, 0xC090}, /* (HANGUL SYLLABLE BBI) */
    {{'\xec', '\x82', '\x91'}, 3, 0xC091}, /* (HANGUL SYLLABLE BBIG) */
    {{'\xec', '\x82', '\x94'}, 3, 0xC094}, /* (HANGUL SYLLABLE BBIN) */
    {{'\xec', '\x82', '\x98'}, 3, 0xC098}, /* (HANGUL SYLLABLE BBIL) */
    {{'\xec', '\x82', '\xa0'}, 3, 0xC0A0}, /* (HANGUL SYLLABLE BBIM) */
    {{'\xec', '\x82', '\xa1'}, 3, 0xC0A1}, /* (HANGUL SYLLABLE BBIB) */
    {{'\xec', '\x82', '\xa3'}, 3, 0xC0A3}, /* (HANGUL SYLLABLE BBIS) */
    {{'\xec', '\x82', '\xa5'}, 3, 0xC0A5}, /* (HANGUL SYLLABLE BBING) */
    {{'\xec', '\x82', '\xac'}, 3, 0xC0AC}, /* (HANGUL SYLLABLE SA) */
    {{'\xec', '\x82', '\xad'}, 3, 0xC0AD}, /* (HANGUL SYLLABLE SAG) */
    {{'\xec', '\x82', '\xaf'}, 3, 0xC0AF}, /* (HANGUL SYLLABLE SAGS) */
    {{'\xec', '\x82', '\xb0'}, 3, 0xC0B0}, /* (HANGUL SYLLABLE SAN) */
    {{'\xec', '\x82', '\xb3'}, 3, 0xC0B3}, /* (HANGUL SYLLABLE SAD) */
    {{'\xec', '\x82', '\xb4'}, 3, 0xC0B4}, /* (HANGUL SYLLABLE SAL) */
    {{'\xec', '\x82', '\xb5'}, 3, 0xC0B5}, /* (HANGUL SYLLABLE SALG) */
    {{'\xec', '\x82', '\xb6'}, 3, 0xC0B6}, /* (HANGUL SYLLABLE SALM) */
    {{'\xec', '\x82', '\xbc'}, 3, 0xC0BC}, /* (HANGUL SYLLABLE SAM) */
    {{'\xec', '\x82', '\xbd'}, 3, 0xC0BD}, /* (HANGUL SYLLABLE SAB) */
    {{'\xec', '\x82', '\xbf'}, 3, 0xC0BF}, /* (HANGUL SYLLABLE SAS) */
    {{'\xec', '\x83', '\x80'}, 3, 0xC0C0}, /* (HANGUL SYLLABLE SASS) */
    {{'\xec', '\x83', '\x81'}, 3, 0xC0C1}, /* (HANGUL SYLLABLE SANG) */
    {{'\xec', '\x83', '\x85'}, 3, 0xC0C5}, /* (HANGUL SYLLABLE SAT) */
    {{'\xec', '\x83', '\x88'}, 3, 0xC0C8}, /* (HANGUL SYLLABLE SAE) */
    {{'\xec', '\x83', '\x89'}, 3, 0xC0C9}, /* (HANGUL SYLLABLE SAEG) */
    {{'\xec', '\x83', '\x8c'}, 3, 0xC0CC}, /* (HANGUL SYLLABLE SAEN) */
    {{'\xec', '\x83', '\x90'}, 3, 0xC0D0}, /* (HANGUL SYLLABLE SAEL) */
    {{'\xec', '\x83', '\x98'}, 3, 0xC0D8}, /* (HANGUL SYLLABLE SAEM) */
    {{'\xec', '\x83', '\x99'}, 3, 0xC0D9}, /* (HANGUL SYLLABLE SAEB) */
    {{'\xec', '\x83', '\x9b'}, 3, 0xC0DB}, /* (HANGUL SYLLABLE SAES) */
    {{'\xec', '\x83', '\x9c'}, 3, 0xC0DC}, /* (HANGUL SYLLABLE SAESS) */
    {{'\xec', '\x83', '\x9d'}, 3, 0xC0DD}, /* (HANGUL SYLLABLE SAENG) */
    {{'\xec', '\x83', '\xa4'}, 3, 0xC0E4}, /* (HANGUL SYLLABLE SYA) */
    {{'\xed', '\x8d', '\xaa'}, 3, 0xD36A}, /* (HANGUL SYLLABLE PYAELM) */
    {{'\xed', '\x8d', '\xab'}, 3, 0xD36B}, /* (HANGUL SYLLABLE PYAELB) */
    {{'\xed', '\x8d', '\xac'}, 3, 0xD36C}, /* (HANGUL SYLLABLE PYAELS) */
    {{'\xed', '\x8d', '\xad'}, 3, 0xD36D}, /* (HANGUL SYLLABLE PYAELT) */
    {{'\xed', '\x8d', '\xae'}, 3, 0xD36E}, /* (HANGUL SYLLABLE PYAELP) */
    {{'\xed', '\x8d', '\xaf'}, 3, 0xD36F}, /* (HANGUL SYLLABLE PYAELH) */
    {{'\xed', '\x8d', '\xb0'}, 3, 0xD370}, /* (HANGUL SYLLABLE PYAEM) */
    {{'\xed', '\x8d', '\xb1'}, 3, 0xD371}, /* (HANGUL SYLLABLE PYAEB) */
    {{'\xed', '\x8d', '\xb2'}, 3, 0xD372}, /* (HANGUL SYLLABLE PYAEBS) */
    {{'\xed', '\x8d', '\xb3'}, 3, 0xD373}, /* (HANGUL SYLLABLE PYAES) */
    {{'\xed', '\x8d', '\xb4'}, 3, 0xD374}, /* (HANGUL SYLLABLE PYAESS) */
    {{'\xed', '\x8d', '\xb5'}, 3, 0xD375}, /* (HANGUL SYLLABLE PYAENG) */
    {{'\xed', '\x8d', '\xb6'}, 3, 0xD376}, /* (HANGUL SYLLABLE PYAEJ) */
    {{'\xed', '\x8d', '\xb7'}, 3, 0xD377}, /* (HANGUL SYLLABLE PYAEC) */
    {{'\xed', '\x8d', '\xb8'}, 3, 0xD378}, /* (HANGUL SYLLABLE PYAEK) */
    {{'\xed', '\x8d', '\xb9'}, 3, 0xD379}, /* (HANGUL SYLLABLE PYAET) */
    {{'\xed', '\x8d', '\xba'}, 3, 0xD37A}, /* (HANGUL SYLLABLE PYAEP) */
    {{'\xed', '\x8d', '\xbb'}, 3, 0xD37B}, /* (HANGUL SYLLABLE PYAEH) */
    {{'\xed', '\x8d', '\xbe'}, 3, 0xD37E}, /* (HANGUL SYLLABLE PEOGG) */
    {{'\xed', '\x8d', '\xbf'}, 3, 0xD37F}, /* (HANGUL SYLLABLE PEOGS) */
    {{'\xed', '\x8e', '\x81'}, 3, 0xD381}, /* (HANGUL SYLLABLE PEONJ) */
    {{'\xed', '\x8e', '\x82'}, 3, 0xD382}, /* (HANGUL SYLLABLE PEONH) */
    {{'\xed', '\x8e', '\x83'}, 3, 0xD383}, /* (HANGUL SYLLABLE PEOD) */
    {{'\xed', '\x8e', '\x85'}, 3, 0xD385}, /* (HANGUL SYLLABLE PEOLG) */
    {{'\xed', '\x8e', '\x86'}, 3, 0xD386}, /* (HANGUL SYLLABLE PEOLM) */
    {{'\xed', '\x8e', '\x87'}, 3, 0xD387}, /* (HANGUL SYLLABLE PEOLB) */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{'\xed', '\x8e', '\x88'}, 3, 0xD388}, /* (HANGUL SYLLABLE PEOLS) */
    {{'\xed', '\x8e', '\x89'}, 3, 0xD389}, /* (HANGUL SYLLABLE PEOLT) */
    {{'\xed', '\x8e', '\x8a'}, 3, 0xD38A}, /* (HANGUL SYLLABLE PEOLP) */
    {{'\xed', '\x8e', '\x8b'}, 3, 0xD38B}, /* (HANGUL SYLLABLE PEOLH) */
    {{'\xed', '\x8e', '\x8e'}, 3, 0xD38E}, /* (HANGUL SYLLABLE PEOBS) */
    {{'\xed', '\x8e', '\x92'}, 3, 0xD392}, /* (HANGUL SYLLABLE PEOJ) */
    {{'\xed', '\x8e', '\x93'}, 3, 0xD393}, /* (HANGUL SYLLABLE PEOC) */
    {{'\xed', '\x8e', '\x94'}, 3, 0xD394}, /* (HANGUL SYLLABLE PEOK) */
    {{'\xed', '\x8e', '\x95'}, 3, 0xD395}, /* (HANGUL SYLLABLE PEOT) */
    {{'\xed', '\x8e', '\x96'}, 3, 0xD396}, /* (HANGUL SYLLABLE PEOP) */
    {{'\xed', '\x8e', '\x97'}, 3, 0xD397}, /* (HANGUL SYLLABLE PEOH) */
    {{'\xed', '\x8e', '\x9a'}, 3, 0xD39A}, /* (HANGUL SYLLABLE PEGG) */
    {{'\xed', '\x8e', '\x9b'}, 3, 0xD39B}, /* (HANGUL SYLLABLE PEGS) */
    {{'\xed', '\x8e', '\x9d'}, 3, 0xD39D}, /* (HANGUL SYLLABLE PENJ) */
    {{'\xed', '\x8e', '\x9e'}, 3, 0xD39E}, /* (HANGUL SYLLABLE PENH) */
    {{'\xed', '\x8e', '\x9f'}, 3, 0xD39F}, /* (HANGUL SYLLABLE PED) */
    {{'\xed', '\x8e', '\xa1'}, 3, 0xD3A1}, /* (HANGUL SYLLABLE PELG) */
    {{'\xed', '\x8e', '\xa2'}, 3, 0xD3A2}, /* (HANGUL SYLLABLE PELM) */
    {{'\xed', '\x8e', '\xa3'}, 3, 0xD3A3}, /* (HANGUL SYLLABLE PELB) */
    {{'\xed', '\x8e', '\xa4'}, 3, 0xD3A4}, /* (HANGUL SYLLABLE PELS) */
    {{'\xed', '\x8e', '\xa5'}, 3, 0xD3A5}, /* (HANGUL SYLLABLE PELT) */
    {{'\xed', '\x8e', '\xa6'}, 3, 0xD3A6}, /* (HANGUL SYLLABLE PELP) */
    {{'\xed', '\x8e', '\xa7'}, 3, 0xD3A7}, /* (HANGUL SYLLABLE PELH) */
    {{'\xed', '\x8e', '\xaa'}, 3, 0xD3AA}, /* (HANGUL SYLLABLE PEBS) */
    {{'\xed', '\x8e', '\xac'}, 3, 0xD3AC}, /* (HANGUL SYLLABLE PESS) */
    {{'\xed', '\x8e', '\xae'}, 3, 0xD3AE}, /* (HANGUL SYLLABLE PEJ) */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{'\xed', '\x8e', '\xaf'}, 3, 0xD3AF}, /* (HANGUL SYLLABLE PEC) */
    {{'\xed', '\x8e', '\xb0'}, 3, 0xD3B0}, /* (HANGUL SYLLABLE PEK) */
    {{'\xed', '\x8e', '\xb1'}, 3, 0xD3B1}, /* (HANGUL SYLLABLE PET) */
    {{'\xed', '\x8e', '\xb2'}, 3, 0xD3B2}, /* (HANGUL SYLLABLE PEP) */
    {{'\xed', '\x8e', '\xb3'}, 3, 0xD3B3}, /* (HANGUL SYLLABLE PEH) */
    {{'\xed', '\x8e', '\xb5'}, 3, 0xD3B5}, /* (HANGUL SYLLABLE PYEOG) */
    {{'\xed', '\x8e', '\xb6'}, 3, 0xD3B6}, /* (HANGUL SYLLABLE PYEOGG) */
    {{'\xed', '\x8e', '\xb7'}, 3, 0xD3B7}, /* (HANGUL SYLLABLE PYEOGS) */
    {{'\xed', '\x8e', '\xb9'}, 3, 0xD3B9}, /* (HANGUL SYLLABLE PYEONJ) */
    {{'\xed', '\x8e', '\xba'}, 3, 0xD3BA}, /* (HANGUL SYLLABLE PYEONH) */
    {{'\xed', '\x8e', '\xbb'}, 3, 0xD3BB}, /* (HANGUL SYLLABLE PYEOD) */
    {{'\xed', '\x8e', '\xbd'}, 3, 0xD3BD}, /* (HANGUL SYLLABLE PYEOLG) */
    {{'\xed', '\x8e', '\xbe'}, 3, 0xD3BE}, /* (HANGUL SYLLABLE PYEOLM) */
    {{'\xed', '\x8e', '\xbf'}, 3, 0xD3BF}, /* (HANGUL SYLLABLE PYEOLB) */
    {{'\xed', '\x8f', '\x80'}, 3, 0xD3C0}, /* (HANGUL SYLLABLE PYEOLS) */
    {{'\xed', '\x8f', '\x81'}, 3, 0xD3C1}, /* (HANGUL SYLLABLE PYEOLT) */
    {{'\xed', '\x8f', '\x82'}, 3, 0xD3C2}, /* (HANGUL SYLLABLE PYEOLP) */
    {{'\xed', '\x8f', '\x83'}, 3, 0xD3C3}, /* (HANGUL SYLLABLE PYEOLH) */
    {{'\xed', '\x8f', '\x86'}, 3, 0xD3C6}, /* (HANGUL SYLLABLE PYEOBS) */
    {{'\xed', '\x8f', '\x87'}, 3, 0xD3C7}, /* (HANGUL SYLLABLE PYEOS) */
    {{'\xed', '\x8f', '\x8a'}, 3, 0xD3CA}, /* (HANGUL SYLLABLE PYEOJ) */
    {{'\xed', '\x8f', '\x8b'}, 3, 0xD3CB}, /* (HANGUL SYLLABLE PYEOC) */
    {{'\xed', '\x8f', '\x8c'}, 3, 0xD3CC}, /* (HANGUL SYLLABLE PYEOK) */
    {{'\xed', '\x8f', '\x8d'}, 3, 0xD3CD}, /* (HANGUL SYLLABLE PYEOT) */
    {{'\xed', '\x8f', '\x8e'}, 3, 0xD3CE}, /* (HANGUL SYLLABLE PYEOP) */
    {{'\xed', '\x8f', '\x8f'}, 3, 0xD3CF}, /* (HANGUL SYLLABLE PYEOH) */
    {{'\xed', '\x8f', '\x91'}, 3, 0xD3D1}, /* (HANGUL SYLLABLE PYEG) */
    {{'\xed', '\x8f', '\x92'}, 3, 0xD3D2}, /* (HANGUL SYLLABLE PYEGG) */
    {{'\xed', '\x8f', '\x93'}, 3, 0xD3D3}, /* (HANGUL SYLLABLE PYEGS) */
    {{'\xed', '\x8f', '\x94'}, 3, 0xD3D4}, /* (HANGUL SYLLABLE PYEN) */
    {{'\xed', '\x8f', '\x95'}, 3, 0xD3D5}, /* (HANGUL SYLLABLE PYENJ) */
    {{'\xed', '\x8f', '\x96'}, 3, 0xD3D6}, /* (HANGUL SYLLABLE PYENH) */
    {{'\xec', '\x83', '\xa5'}, 3, 0xC0E5}, /* (HANGUL SYLLABLE SYAG) */
    {{'\xec', '\x83', '\xa8'}, 3, 0xC0E8}, /* (HANGUL SYLLABLE SYAN) */
    {{'\xec', '\x83', '\xac'}, 3, 0xC0EC}, /* (HANGUL SYLLABLE SYAL) */
    {{'\xec', '\x83', '\xb4'}, 3, 0xC0F4}, /* (HANGUL SYLLABLE SYAM) */
    {{'\xec', '\x83', '\xb5'}, 3, 0xC0F5}, /* (HANGUL SYLLABLE SYAB) */
    {{'\xec', '\x83', '\xb7'}, 3, 0xC0F7}, /* (HANGUL SYLLABLE SYAS) */
    {{'\xec', '\x83', '\xb9'}, 3, 0xC0F9}, /* (HANGUL SYLLABLE SYANG) */
    {{'\xec', '\x84', '\x80'}, 3, 0xC100}, /* (HANGUL SYLLABLE SYAE) */
    {{'\xec', '\x84', '\x84'}, 3, 0xC104}, /* (HANGUL SYLLABLE SYAEN) */
    {{'\xec', '\x84', '\x88'}, 3, 0xC108}, /* (HANGUL SYLLABLE SYAEL) */
    {{'\xec', '\x84', '\x90'}, 3, 0xC110}, /* (HANGUL SYLLABLE SYAEM) */
    {{'\xec', '\x84', '\x95'}, 3, 0xC115}, /* (HANGUL SYLLABLE SYAENG) */
    {{'\xec', '\x84', '\x9c'}, 3, 0xC11C}, /* (HANGUL SYLLABLE SEO) */
    {{'\xec', '\x84', '\x9d'}, 3, 0xC11D}, /* (HANGUL SYLLABLE SEOG) */
    {{'\xec', '\x84', '\x9e'}, 3, 0xC11E}, /* (HANGUL SYLLABLE SEOGG) */
    {{'\xec', '\x84', '\x9f'}, 3, 0xC11F}, /* (HANGUL SYLLABLE SEOGS) */
    {{'\xec', '\x84', '\xa0'}, 3, 0xC120}, /* (HANGUL SYLLABLE SEON) */
    {{'\xec', '\x84', '\xa3'}, 3, 0xC123}, /* (HANGUL SYLLABLE SEOD) */
    {{'\xec', '\x84', '\xa4'}, 3, 0xC124}, /* (HANGUL SYLLABLE SEOL) */
    {{'\xec', '\x84', '\xa6'}, 3, 0xC126}, /* (HANGUL SYLLABLE SEOLM) */
    {{'\xec', '\x84', '\xa7'}, 3, 0xC127}, /* (HANGUL SYLLABLE SEOLB) */
    {{'\xec', '\x84', '\xac'}, 3, 0xC12C}, /* (HANGUL SYLLABLE SEOM) */
    {{'\xec', '\x84', '\xad'}, 3, 0xC12D}, /* (HANGUL SYLLABLE SEOB) */
    {{'\xec', '\x84', '\xaf'}, 3, 0xC12F}, /* (HANGUL SYLLABLE SEOS) */
    {{'\xec', '\x84', '\xb0'}, 3, 0xC130}, /* (HANGUL SYLLABLE SEOSS) */
    {{'\xec', '\x84', '\xb1'}, 3, 0xC131}, /* (HANGUL SYLLABLE SEONG) */
    {{'\xec', '\x84', '\xb6'}, 3, 0xC136}, /* (HANGUL SYLLABLE SEOP) */
    {{'\xec', '\x84', '\xb8'}, 3, 0xC138}, /* (HANGUL SYLLABLE SE) */
    {{'\xec', '\x84', '\xb9'}, 3, 0xC139}, /* (HANGUL SYLLABLE SEG) */
    {{'\xec', '\x84', '\xbc'}, 3, 0xC13C}, /* (HANGUL SYLLABLE SEN) */
    {{'\xec', '\x85', '\x80'}, 3, 0xC140}, /* (HANGUL SYLLABLE SEL) */
    {{'\xec', '\x85', '\x88'}, 3, 0xC148}, /* (HANGUL SYLLABLE SEM) */
    {{'\xec', '\x85', '\x89'}, 3, 0xC149}, /* (HANGUL SYLLABLE SEB) */
    {{'\xec', '\x85', '\x8b'}, 3, 0xC14B}, /* (HANGUL SYLLABLE SES) */
    {{'\xec', '\x85', '\x8c'}, 3, 0xC14C}, /* (HANGUL SYLLABLE SESS) */
    {{'\xec', '\x85', '\x8d'}, 3, 0xC14D}, /* (HANGUL SYLLABLE SENG) */
    {{'\xec', '\x85', '\x94'}, 3, 0xC154}, /* (HANGUL SYLLABLE SYEO) */
    {{'\xec', '\x85', '\x95'}, 3, 0xC155}, /* (HANGUL SYLLABLE SYEOG) */
    {{'\xec', '\x85', '\x98'}, 3, 0xC158}, /* (HANGUL SYLLABLE SYEON) */
    {{'\xec', '\x85', '\x9c'}, 3, 0xC15C}, /* (HANGUL SYLLABLE SYEOL) */
    {{'\xec', '\x85', '\xa4'}, 3, 0xC164}, /* (HANGUL SYLLABLE SYEOM) */
    {{'\xec', '\x85', '\xa5'}, 3, 0xC165}, /* (HANGUL SYLLABLE SYEOB) */
    {{'\xec', '\x85', '\xa7'}, 3, 0xC167}, /* (HANGUL SYLLABLE SYEOS) */
    {{'\xec', '\x85', '\xa8'}, 3, 0xC168}, /* (HANGUL SYLLABLE SYEOSS) */
    {{'\xec', '\x85', '\xa9'}, 3, 0xC169}, /* (HANGUL SYLLABLE SYEONG) */
    {{'\xec', '\x85', '\xb0'}, 3, 0xC170}, /* (HANGUL SYLLABLE SYE) */
    {{'\xec', '\x85', '\xb4'}, 3, 0xC174}, /* (HANGUL SYLLABLE SYEN) */
    {{'\xec', '\x85', '\xb8'}, 3, 0xC178}, /* (HANGUL SYLLABLE SYEL) */
    {{'\xec', '\x86', '\x85'}, 3, 0xC185}, /* (HANGUL SYLLABLE SYENG) */
    {{'\xec', '\x86', '\x8c'}, 3, 0xC18C}, /* (HANGUL SYLLABLE SO) */
    {{'\xec', '\x86', '\x8d'}, 3, 0xC18D}, /* (HANGUL SYLLABLE SOG) */
    {{'\xec', '\x86', '\x8e'}, 3, 0xC18E}, /* (HANGUL SYLLABLE SOGG) */
    {{'\xec', '\x86', '\x90'}, 3, 0xC190}, /* (HANGUL SYLLABLE SON) */
    {{'\xec', '\x86', '\x94'}, 3, 0xC194}, /* (HANGUL SYLLABLE SOL) */
    {{'\xec', '\x86', '\x96'}, 3, 0xC196}, /* (HANGUL SYLLABLE SOLM) */
    {{'\xec', '\x86', '\x9c'}, 3, 0xC19C}, /* (HANGUL SYLLABLE SOM) */
    {{'\xec', '\x86', '\x9d'}, 3, 0xC19D}, /* (HANGUL SYLLABLE SOB) */
    {{'\xec', '\x86', '\x9f'}, 3, 0xC19F}, /* (HANGUL SYLLABLE SOS) */
    {{'\xec', '\x86', '\xa1'}, 3, 0xC1A1}, /* (HANGUL SYLLABLE SONG) */
    {{'\xec', '\x86', '\xa5'}, 3, 0xC1A5}, /* (HANGUL SYLLABLE SOT) */
    {{'\xec', '\x86', '\xa8'}, 3, 0xC1A8}, /* (HANGUL SYLLABLE SWA) */
    {{'\xec', '\x86', '\xa9'}, 3, 0xC1A9}, /* (HANGUL SYLLABLE SWAG) */
    {{'\xec', '\x86', '\xac'}, 3, 0xC1AC}, /* (HANGUL SYLLABLE SWAN) */
    {{'\xec', '\x86', '\xb0'}, 3, 0xC1B0}, /* (HANGUL SYLLABLE SWAL) */
    {{'\xec', '\x86', '\xbd'}, 3, 0xC1BD}, /* (HANGUL SYLLABLE SWANG) */
    {{'\xec', '\x87', '\x84'}, 3, 0xC1C4}, /* (HANGUL SYLLABLE SWAE) */
    {{'\xec', '\x87', '\x88'}, 3, 0xC1C8}, /* (HANGUL SYLLABLE SWAEN) */
    {{'\xec', '\x87', '\x8c'}, 3, 0xC1CC}, /* (HANGUL SYLLABLE SWAEL) */
    {{'\xec', '\x87', '\x94'}, 3, 0xC1D4}, /* (HANGUL SYLLABLE SWAEM) */
    {{'\xec', '\x87', '\x97'}, 3, 0xC1D7}, /* (HANGUL SYLLABLE SWAES) */
    {{'\xec', '\x87', '\x98'}, 3, 0xC1D8}, /* (HANGUL SYLLABLE SWAESS) */
    {{'\xec', '\x87', '\xa0'}, 3, 0xC1E0}, /* (HANGUL SYLLABLE SOE) */
    {{'\xec', '\x87', '\xa4'}, 3, 0xC1E4}, /* (HANGUL SYLLABLE SOEN) */
    {{'\xec', '\x87', '\xa8'}, 3, 0xC1E8}, /* (HANGUL SYLLABLE SOEL) */
    {{'\xec', '\x87', '\xb0'}, 3, 0xC1F0}, /* (HANGUL SYLLABLE SOEM) */
    {{'\xec', '\x87', '\xb1'}, 3, 0xC1F1}, /* (HANGUL SYLLABLE SOEB) */
    {{'\xec', '\x87', '\xb3'}, 3, 0xC1F3}, /* (HANGUL SYLLABLE SOES) */
    {{'\xec', '\x87', '\xbc'}, 3, 0xC1FC}, /* (HANGUL SYLLABLE SYO) */
    {{'\xec', '\x87', '\xbd'}, 3, 0xC1FD}, /* (HANGUL SYLLABLE SYOG) */
    {{'\xec', '\x88', '\x80'}, 3, 0xC200}, /* (HANGUL SYLLABLE SYON) */
    {{'\xec', '\x88', '\x84'}, 3, 0xC204}, /* (HANGUL SYLLABLE SYOL) */
    {{'\xec', '\x88', '\x8c'}, 3, 0xC20C}, /* (HANGUL SYLLABLE SYOM) */
    {{'\xec', '\x88', '\x8d'}, 3, 0xC20D}, /* (HANGUL SYLLABLE SYOB) */
    {{'\xec', '\x88', '\x8f'}, 3, 0xC20F}, /* (HANGUL SYLLABLE SYOS) */
    {{'\xec', '\x88', '\x91'}, 3, 0xC211}, /* (HANGUL SYLLABLE SYONG) */
    {{'\xec', '\x88', '\x98'}, 3, 0xC218}, /* (HANGUL SYLLABLE SU) */
    {{'\xec', '\x88', '\x99'}, 3, 0xC219}, /* (HANGUL SYLLABLE SUG) */
    {{'\xec', '\x88', '\x9c'}, 3, 0xC21C}, /* (HANGUL SYLLABLE SUN) */
    {{'\xec', '\x88', '\x9f'}, 3, 0xC21F}, /* (HANGUL SYLLABLE SUD) */
    {{'\xec', '\x88', '\xa0'}, 3, 0xC220}, /* (HANGUL SYLLABLE SUL) */
    {{'\xec', '\x88', '\xa8'}, 3, 0xC228}, /* (HANGUL SYLLABLE SUM) */
    {{'\xec', '\x88', '\xa9'}, 3, 0xC229}, /* (HANGUL SYLLABLE SUB) */
    {{'\xec', '\x88', '\xab'}, 3, 0xC22B}, /* (HANGUL SYLLABLE SUS) */
    {{'\xec', '\x88', '\xad'}, 3, 0xC22D}, /* (HANGUL SYLLABLE SUNG) */
    {{'\xed', '\x8f', '\x97'}, 3, 0xD3D7}, /* (HANGUL SYLLABLE PYED) */
    {{'\xed', '\x8f', '\x99'}, 3, 0xD3D9}, /* (HANGUL SYLLABLE PYELG) */
    {{'\xed', '\x8f', '\x9a'}, 3, 0xD3DA}, /* (HANGUL SYLLABLE PYELM) */
    {{'\xed', '\x8f', '\x9b'}, 3, 0xD3DB}, /* (HANGUL SYLLABLE PYELB) */
    {{'\xed', '\x8f', '\x9c'}, 3, 0xD3DC}, /* (HANGUL SYLLABLE PYELS) */
    {{'\xed', '\x8f', '\x9d'}, 3, 0xD3DD}, /* (HANGUL SYLLABLE PYELT) */
    {{'\xed', '\x8f', '\x9e'}, 3, 0xD3DE}, /* (HANGUL SYLLABLE PYELP) */
    {{'\xed', '\x8f', '\x9f'}, 3, 0xD3DF}, /* (HANGUL SYLLABLE PYELH) */
    {{'\xed', '\x8f', '\xa0'}, 3, 0xD3E0}, /* (HANGUL SYLLABLE PYEM) */
    {{'\xed', '\x8f', '\xa2'}, 3, 0xD3E2}, /* (HANGUL SYLLABLE PYEBS) */
    {{'\xed', '\x8f', '\xa4'}, 3, 0xD3E4}, /* (HANGUL SYLLABLE PYESS) */
    {{'\xed', '\x8f', '\xa5'}, 3, 0xD3E5}, /* (HANGUL SYLLABLE PYENG) */
    {{'\xed', '\x8f', '\xa6'}, 3, 0xD3E6}, /* (HANGUL SYLLABLE PYEJ) */
    {{'\xed', '\x8f', '\xa7'}, 3, 0xD3E7}, /* (HANGUL SYLLABLE PYEC) */
    {{'\xed', '\x8f', '\xa8'}, 3, 0xD3E8}, /* (HANGUL SYLLABLE PYEK) */
    {{'\xed', '\x8f', '\xa9'}, 3, 0xD3E9}, /* (HANGUL SYLLABLE PYET) */
    {{'\xed', '\x8f', '\xaa'}, 3, 0xD3EA}, /* (HANGUL SYLLABLE PYEP) */
    {{'\xed', '\x8f', '\xab'}, 3, 0xD3EB}, /* (HANGUL SYLLABLE PYEH) */
    {{'\xed', '\x8f', '\xae'}, 3, 0xD3EE}, /* (HANGUL SYLLABLE POGG) */
    {{'\xed', '\x8f', '\xaf'}, 3, 0xD3EF}, /* (HANGUL SYLLABLE POGS) */
    {{'\xed', '\x8f', '\xb1'}, 3, 0xD3F1}, /* (HANGUL SYLLABLE PONJ) */
    {{'\xed', '\x8f', '\xb2'}, 3, 0xD3F2}, /* (HANGUL SYLLABLE PONH) */
    {{'\xed', '\x8f', '\xb3'}, 3, 0xD3F3}, /* (HANGUL SYLLABLE POD) */
    {{'\xed', '\x8f', '\xb5'}, 3, 0xD3F5}, /* (HANGUL SYLLABLE POLG) */
    {{'\xed', '\x8f', '\xb6'}, 3, 0xD3F6}, /* (HANGUL SYLLABLE POLM) */
    {{'\xed', '\x8f', '\xb7'}, 3, 0xD3F7}, /* (HANGUL SYLLABLE POLB) */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{'\xed', '\x8f', '\xb8'}, 3, 0xD3F8}, /* (HANGUL SYLLABLE POLS) */
    {{'\xed', '\x8f', '\xb9'}, 3, 0xD3F9}, /* (HANGUL SYLLABLE POLT) */
    {{'\xed', '\x8f', '\xba'}, 3, 0xD3FA}, /* (HANGUL SYLLABLE POLP) */
    {{'\xed', '\x8f', '\xbb'}, 3, 0xD3FB}, /* (HANGUL SYLLABLE POLH) */
    {{'\xed', '\x8f', '\xbe'}, 3, 0xD3FE}, /* (HANGUL SYLLABLE POBS) */
    {{'\xed', '\x90', '\x80'}, 3, 0xD400}, /* (HANGUL SYLLABLE POSS) */
    {{'\xed', '\x90', '\x82'}, 3, 0xD402}, /* (HANGUL SYLLABLE POJ) */
    {{'\xed', '\x90', '\x83'}, 3, 0xD403}, /* (HANGUL SYLLABLE POC) */
    {{'\xed', '\x90', '\x84'}, 3, 0xD404}, /* (HANGUL SYLLABLE POK) */
    {{'\xed', '\x90', '\x85'}, 3, 0xD405}, /* (HANGUL SYLLABLE POT) */
    {{'\xed', '\x90', '\x86'}, 3, 0xD406}, /* (HANGUL SYLLABLE POP) */
    {{'\xed', '\x90', '\x87'}, 3, 0xD407}, /* (HANGUL SYLLABLE POH) */
    {{'\xed', '\x90', '\x89'}, 3, 0xD409}, /* (HANGUL SYLLABLE PWAG) */
    {{'\xed', '\x90', '\x8a'}, 3, 0xD40A}, /* (HANGUL SYLLABLE PWAGG) */
    {{'\xed', '\x90', '\x8b'}, 3, 0xD40B}, /* (HANGUL SYLLABLE PWAGS) */
    {{'\xed', '\x90', '\x8c'}, 3, 0xD40C}, /* (HANGUL SYLLABLE PWAN) */
    {{'\xed', '\x90', '\x8d'}, 3, 0xD40D}, /* (HANGUL SYLLABLE PWANJ) */
    {{'\xed', '\x90', '\x8e'}, 3, 0xD40E}, /* (HANGUL SYLLABLE PWANH) */
    {{'\xed', '\x90', '\x8f'}, 3, 0xD40F}, /* (HANGUL SYLLABLE PWAD) */
    {{'\xed', '\x90', '\x90'}, 3, 0xD410}, /* (HANGUL SYLLABLE PWAL) */
    {{'\xed', '\x90', '\x91'}, 3, 0xD411}, /* (HANGUL SYLLABLE PWALG) */
    {{'\xed', '\x90', '\x92'}, 3, 0xD412}, /* (HANGUL SYLLABLE PWALM) */
    {{'\xed', '\x90', '\x93'}, 3, 0xD413}, /* (HANGUL SYLLABLE PWALB) */
    {{'\xed', '\x90', '\x94'}, 3, 0xD414}, /* (HANGUL SYLLABLE PWALS) */
    {{'\xed', '\x90', '\x95'}, 3, 0xD415}, /* (HANGUL SYLLABLE PWALT) */
    {{'\xed', '\x90', '\x96'}, 3, 0xD416}, /* (HANGUL SYLLABLE PWALP) */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{'\xed', '\x90', '\x97'}, 3, 0xD417}, /* (HANGUL SYLLABLE PWALH) */
    {{'\xed', '\x90', '\x98'}, 3, 0xD418}, /* (HANGUL SYLLABLE PWAM) */
    {{'\xed', '\x90', '\x99'}, 3, 0xD419}, /* (HANGUL SYLLABLE PWAB) */
    {{'\xed', '\x90', '\x9a'}, 3, 0xD41A}, /* (HANGUL SYLLABLE PWABS) */
    {{'\xed', '\x90', '\x9b'}, 3, 0xD41B}, /* (HANGUL SYLLABLE PWAS) */
    {{'\xed', '\x90', '\x9c'}, 3, 0xD41C}, /* (HANGUL SYLLABLE PWASS) */
    {{'\xed', '\x90', '\x9e'}, 3, 0xD41E}, /* (HANGUL SYLLABLE PWAJ) */
    {{'\xed', '\x90', '\x9f'}, 3, 0xD41F}, /* (HANGUL SYLLABLE PWAC) */
    {{'\xed', '\x90', '\xa0'}, 3, 0xD420}, /* (HANGUL SYLLABLE PWAK) */
    {{'\xed', '\x90', '\xa1'}, 3, 0xD421}, /* (HANGUL SYLLABLE PWAT) */
    {{'\xed', '\x90', '\xa2'}, 3, 0xD422}, /* (HANGUL SYLLABLE PWAP) */
    {{'\xed', '\x90', '\xa3'}, 3, 0xD423}, /* (HANGUL SYLLABLE PWAH) */
    {{'\xed', '\x90', '\xa4'}, 3, 0xD424}, /* (HANGUL SYLLABLE PWAE) */
    {{'\xed', '\x90', '\xa5'}, 3, 0xD425}, /* (HANGUL SYLLABLE PWAEG) */
    {{'\xed', '\x90', '\xa6'}, 3, 0xD426}, /* (HANGUL SYLLABLE PWAEGG) */
    {{'\xed', '\x90', '\xa7'}, 3, 0xD427}, /* (HANGUL SYLLABLE PWAEGS) */
    {{'\xed', '\x90', '\xa8'}, 3, 0xD428}, /* (HANGUL SYLLABLE PWAEN) */
    {{'\xed', '\x90', '\xa9'}, 3, 0xD429}, /* (HANGUL SYLLABLE PWAENJ) */
    {{'\xed', '\x90', '\xaa'}, 3, 0xD42A}, /* (HANGUL SYLLABLE PWAENH) */
    {{'\xed', '\x90', '\xab'}, 3, 0xD42B}, /* (HANGUL SYLLABLE PWAED) */
    {{'\xed', '\x90', '\xac'}, 3, 0xD42C}, /* (HANGUL SYLLABLE PWAEL) */
    {{'\xed', '\x90', '\xad'}, 3, 0xD42D}, /* (HANGUL SYLLABLE PWAELG) */
    {{'\xed', '\x90', '\xae'}, 3, 0xD42E}, /* (HANGUL SYLLABLE PWAELM) */
    {{'\xed', '\x90', '\xaf'}, 3, 0xD42F}, /* (HANGUL SYLLABLE PWAELB) */
    {{'\xed', '\x90', '\xb0'}, 3, 0xD430}, /* (HANGUL SYLLABLE PWAELS) */
    {{'\xed', '\x90', '\xb1'}, 3, 0xD431}, /* (HANGUL SYLLABLE PWAELT) */
    {{'\xed', '\x90', '\xb2'}, 3, 0xD432}, /* (HANGUL SYLLABLE PWAELP) */
    {{'\xed', '\x90', '\xb3'}, 3, 0xD433}, /* (HANGUL SYLLABLE PWAELH) */
    {{'\xed', '\x90', '\xb4'}, 3, 0xD434}, /* (HANGUL SYLLABLE PWAEM) */
    {{'\xed', '\x90', '\xb5'}, 3, 0xD435}, /* (HANGUL SYLLABLE PWAEB) */
    {{'\xed', '\x90', '\xb6'}, 3, 0xD436}, /* (HANGUL SYLLABLE PWAEBS) */
    {{'\xed', '\x90', '\xb7'}, 3, 0xD437}, /* (HANGUL SYLLABLE PWAES) */
    {{'\xec', '\x88', '\xaf'}, 3, 0xC22F}, /* (HANGUL SYLLABLE SUC) */
    {{'\xec', '\x88', '\xb1'}, 3, 0xC231}, /* (HANGUL SYLLABLE SUT) */
    {{'\xec', '\x88', '\xb2'}, 3, 0xC232}, /* (HANGUL SYLLABLE SUP) */
    {{'\xec', '\x88', '\xb4'}, 3, 0xC234}, /* (HANGUL SYLLABLE SWEO) */
    {{'\xec', '\x89', '\x88'}, 3, 0xC248}, /* (HANGUL SYLLABLE SWEOSS) */
    {{'\xec', '\x89', '\x90'}, 3, 0xC250}, /* (HANGUL SYLLABLE SWE) */
    {{'\xec', '\x89', '\x91'}, 3, 0xC251}, /* (HANGUL SYLLABLE SWEG) */
    {{'\xec', '\x89', '\x94'}, 3, 0xC254}, /* (HANGUL SYLLABLE SWEN) */
    {{'\xec', '\x89', '\x98'}, 3, 0xC258}, /* (HANGUL SYLLABLE SWEL) */
    {{'\xec', '\x89', '\xa0'}, 3, 0xC260}, /* (HANGUL SYLLABLE SWEM) */
    {{'\xec', '\x89', '\xa5'}, 3, 0xC265}, /* (HANGUL SYLLABLE SWENG) */
    {{'\xec', '\x89', '\xac'}, 3, 0xC26C}, /* (HANGUL SYLLABLE SWI) */
    {{'\xec', '\x89', '\xad'}, 3, 0xC26D}, /* (HANGUL SYLLABLE SWIG) */
    {{'\xec', '\x89', '\xb0'}, 3, 0xC270}, /* (HANGUL SYLLABLE SWIN) */
    {{'\xec', '\x89', '\xb4'}, 3, 0xC274}, /* (HANGUL SYLLABLE SWIL) */
    {{'\xec', '\x89', '\xbc'}, 3, 0xC27C}, /* (HANGUL SYLLABLE SWIM) */
    {{'\xec', '\x89', '\xbd'}, 3, 0xC27D}, /* (HANGUL SYLLABLE SWIB) */
    {{'\xec', '\x89', '\xbf'}, 3, 0xC27F}, /* (HANGUL SYLLABLE SWIS) */
    {{'\xec', '\x8a', '\x81'}, 3, 0xC281}, /* (HANGUL SYLLABLE SWING) */
    {{'\xec', '\x8a', '\x88'}, 3, 0xC288}, /* (HANGUL SYLLABLE SYU) */
    {{'\xec', '\x8a', '\x89'}, 3, 0xC289}, /* (HANGUL SYLLABLE SYUG) */
    {{'\xec', '\x8a', '\x90'}, 3, 0xC290}, /* (HANGUL SYLLABLE SYUL) */
    {{'\xec', '\x8a', '\x98'}, 3, 0xC298}, /* (HANGUL SYLLABLE SYUM) */
    {{'\xec', '\x8a', '\x9b'}, 3, 0xC29B}, /* (HANGUL SYLLABLE SYUS) */
    {{'\xec', '\x8a', '\x9d'}, 3, 0xC29D}, /* (HANGUL SYLLABLE SYUNG) */
    {{'\xec', '\x8a', '\xa4'}, 3, 0xC2A4}, /* (HANGUL SYLLABLE SEU) */
    {{'\xec', '\x8a', '\xa5'}, 3, 0xC2A5}, /* (HANGUL SYLLABLE SEUG) */
    {{'\xec', '\x8a', '\xa8'}, 3, 0xC2A8}, /* (HANGUL SYLLABLE SEUN) */
    {{'\xec', '\x8a', '\xac'}, 3, 0xC2AC}, /* (HANGUL SYLLABLE SEUL) */
    {{'\xec', '\x8a', '\xad'}, 3, 0xC2AD}, /* (HANGUL SYLLABLE SEULG) */
    {{'\xec', '\x8a', '\xb4'}, 3, 0xC2B4}, /* (HANGUL SYLLABLE SEUM) */
    {{'\xec', '\x8a', '\xb5'}, 3, 0xC2B5}, /* (HANGUL SYLLABLE SEUB) */
    {{'\xec', '\x8a', '\xb7'}, 3, 0xC2B7}, /* (HANGUL SYLLABLE SEUS) */
    {{'\xec', '\x8a', '\xb9'}, 3, 0xC2B9}, /* (HANGUL SYLLABLE SEUNG) */
    {{'\xec', '\x8b', '\x9c'}, 3, 0xC2DC}, /* (HANGUL SYLLABLE SI) */
    {{'\xec', '\x8b', '\x9d'}, 3, 0xC2DD}, /* (HANGUL SYLLABLE SIG) */
    {{'\xec', '\x8b', '\xa0'}, 3, 0xC2E0}, /* (HANGUL SYLLABLE SIN) */
    {{'\xec', '\x8b', '\xa3'}, 3, 0xC2E3}, /* (HANGUL SYLLABLE SID) */
    {{'\xec', '\x8b', '\xa4'}, 3, 0xC2E4}, /* (HANGUL SYLLABLE SIL) */
    {{'\xec', '\x8b', '\xab'}, 3, 0xC2EB}, /* (HANGUL SYLLABLE SILH) */
    {{'\xec', '\x8b', '\xac'}, 3, 0xC2EC}, /* (HANGUL SYLLABLE SIM) */
    {{'\xec', '\x8b', '\xad'}, 3, 0xC2ED}, /* (HANGUL SYLLABLE SIB) */
    {{'\xec', '\x8b', '\xaf'}, 3, 0xC2EF}, /* (HANGUL SYLLABLE SIS) */
    {{'\xec', '\x8b', '\xb1'}, 3, 0xC2F1}, /* (HANGUL SYLLABLE SING) */
    {{'\xec', '\x8b', '\xb6'}, 3, 0xC2F6}, /* (HANGUL SYLLABLE SIP) */
    {{'\xec', '\x8b', '\xb8'}, 3, 0xC2F8}, /* (HANGUL SYLLABLE SSA) */
    {{'\xec', '\x8b', '\xb9'}, 3, 0xC2F9}, /* (HANGUL SYLLABLE SSAG) */
    {{'\xec', '\x8b', '\xbb'}, 3, 0xC2FB}, /* (HANGUL SYLLABLE SSAGS) */
    {{'\xec', '\x8b', '\xbc'}, 3, 0xC2FC}, /* (HANGUL SYLLABLE SSAN) */
    {{'\xec', '\x8c', '\x80'}, 3, 0xC300}, /* (HANGUL SYLLABLE SSAL) */
    {{'\xec', '\x8c', '\x88'}, 3, 0xC308}, /* (HANGUL SYLLABLE SSAM) */
    {{'\xec', '\x8c', '\x89'}, 3, 0xC309}, /* (HANGUL SYLLABLE SSAB) */
    {{'\xec', '\x8c', '\x8c'}, 3, 0xC30C}, /* (HANGUL SYLLABLE SSASS) */
    {{'\xec', '\x8c', '\x8d'}, 3, 0xC30D}, /* (HANGUL SYLLABLE SSANG) */
    {{'\xec', '\x8c', '\x93'}, 3, 0xC313}, /* (HANGUL SYLLABLE SSAH) */
    {{'\xec', '\x8c', '\x94'}, 3, 0xC314}, /* (HANGUL SYLLABLE SSAE) */
    {{'\xec', '\x8c', '\x95'}, 3, 0xC315}, /* (HANGUL SYLLABLE SSAEG) */
    {{'\xec', '\x8c', '\x98'}, 3, 0xC318}, /* (HANGUL SYLLABLE SSAEN) */
    {{'\xec', '\x8c', '\x9c'}, 3, 0xC31C}, /* (HANGUL SYLLABLE SSAEL) */
    {{'\xec', '\x8c', '\xa4'}, 3, 0xC324}, /* (HANGUL SYLLABLE SSAEM) */
    {{'\xec', '\x8c', '\xa5'}, 3, 0xC325}, /* (HANGUL SYLLABLE SSAEB) */
    {{'\xec', '\x8c', '\xa8'}, 3, 0xC328}, /* (HANGUL SYLLABLE SSAESS) */
    {{'\xec', '\x8c', '\xa9'}, 3, 0xC329}, /* (HANGUL SYLLABLE SSAENG) */
    {{'\xec', '\x8d', '\x85'}, 3, 0xC345}, /* (HANGUL SYLLABLE SSYANG) */
    {{'\xec', '\x8d', '\xa8'}, 3, 0xC368}, /* (HANGUL SYLLABLE SSEO) */
    {{'\xec', '\x8d', '\xa9'}, 3, 0xC369}, /* (HANGUL SYLLABLE SSEOG) */
    {{'\xec', '\x8d', '\xac'}, 3, 0xC36C}, /* (HANGUL SYLLABLE SSEON) */
    {{'\xec', '\x8d', '\xb0'}, 3, 0xC370}, /* (HANGUL SYLLABLE SSEOL) */
    {{'\xec', '\x8d', '\xb2'}, 3, 0xC372}, /* (HANGUL SYLLABLE SSEOLM) */
    {{'\xec', '\x8d', '\xb8'}, 3, 0xC378}, /* (HANGUL SYLLABLE SSEOM) */
    {{'\xec', '\x8d', '\xb9'}, 3, 0xC379}, /* (HANGUL SYLLABLE SSEOB) */
    {{'\xec', '\x8d', '\xbc'}, 3, 0xC37C}, /* (HANGUL SYLLABLE SSEOSS) */
    {{'\xec', '\x8d', '\xbd'}, 3, 0xC37D}, /* (HANGUL SYLLABLE SSEONG) */
    {{'\xec', '\x8e', '\x84'}, 3, 0xC384}, /* (HANGUL SYLLABLE SSE) */
    {{'\xec', '\x8e', '\x88'}, 3, 0xC388}, /* (HANGUL SYLLABLE SSEN) */
    {{'\xec', '\x8e', '\x8c'}, 3, 0xC38C}, /* (HANGUL SYLLABLE SSEL) */
    {{'\xec', '\x8f', '\x80'}, 3, 0xC3C0}, /* (HANGUL SYLLABLE SSYEN) */
    {{'\xec', '\x8f', '\x98'}, 3, 0xC3D8}, /* (HANGUL SYLLABLE SSO) */
    {{'\xec', '\x8f', '\x99'}, 3, 0xC3D9}, /* (HANGUL SYLLABLE SSOG) */
    {{'\xec', '\x8f', '\x9c'}, 3, 0xC3DC}, /* (HANGUL SYLLABLE SSON) */
    {{'\xec', '\x8f', '\x9f'}, 3, 0xC3DF}, /* (HANGUL SYLLABLE SSOD) */
    {{'\xec', '\x8f', '\xa0'}, 3, 0xC3E0}, /* (HANGUL SYLLABLE SSOL) */
    {{'\xec', '\x8f', '\xa2'}, 3, 0xC3E2}, /* (HANGUL SYLLABLE SSOLM) */
    {{'\xec', '\x8f', '\xa8'}, 3, 0xC3E8}, /* (HANGUL SYLLABLE SSOM) */
    {{'\xec', '\x8f', '\xa9'}, 3, 0xC3E9}, /* (HANGUL SYLLABLE SSOB) */
    {{'\xec', '\x8f', '\xad'}, 3, 0xC3ED}, /* (HANGUL SYLLABLE SSONG) */
    {{'\xec', '\x8f', '\xb4'}, 3, 0xC3F4}, /* (HANGUL SYLLABLE SSWA) */
    {{'\xec', '\x8f', '\xb5'}, 3, 0xC3F5}, /* (HANGUL SYLLABLE SSWAG) */
    {{'\xec', '\x8f', '\xb8'}, 3, 0xC3F8}, /* (HANGUL SYLLABLE SSWAN) */
    {{'\xec', '\x90', '\x88'}, 3, 0xC408}, /* (HANGUL SYLLABLE SSWASS) */
    {{'\xec', '\x90', '\x90'}, 3, 0xC410}, /* (HANGUL SYLLABLE SSWAE) */
    {{'\xec', '\x90', '\xa4'}, 3, 0xC424}, /* (HANGUL SYLLABLE SSWAESS) */
    {{'\xec', '\x90', '\xac'}, 3, 0xC42C}, /* (HANGUL SYLLABLE SSOE) */
    {{'\xec', '\x90', '\xb0'}, 3, 0xC430}, /* (HANGUL SYLLABLE SSOEN) */
    {{'\xed', '\x90', '\xb8'}, 3, 0xD438}, /* (HANGUL SYLLABLE PWAESS) */
    {{'\xed', '\x90', '\xb9'}, 3, 0xD439}, /* (HANGUL SYLLABLE PWAENG) */
    {{'\xed', '\x90', '\xba'}, 3, 0xD43A}, /* (HANGUL SYLLABLE PWAEJ) */
    {{'\xed', '\x90', '\xbb'}, 3, 0xD43B}, /* (HANGUL SYLLABLE PWAEC) */
    {{'\xed', '\x90', '\xbc'}, 3, 0xD43C}, /* (HANGUL SYLLABLE PWAEK) */
    {{'\xed', '\x90', '\xbd'}, 3, 0xD43D}, /* (HANGUL SYLLABLE PWAET) */
    {{'\xed', '\x90', '\xbe'}, 3, 0xD43E}, /* (HANGUL SYLLABLE PWAEP) */
    {{'\xed', '\x90', '\xbf'}, 3, 0xD43F}, /* (HANGUL SYLLABLE PWAEH) */
    {{'\xed', '\x91', '\x81'}, 3, 0xD441}, /* (HANGUL SYLLABLE POEG) */
    {{'\xed', '\x91', '\x82'}, 3, 0xD442}, /* (HANGUL SYLLABLE POEGG) */
    {{'\xed', '\x91', '\x83'}, 3, 0xD443}, /* (HANGUL SYLLABLE POEGS) */
    {{'\xed', '\x91', '\x85'}, 3, 0xD445}, /* (HANGUL SYLLABLE POENJ) */
    {{'\xed', '\x91', '\x86'}, 3, 0xD446}, /* (HANGUL SYLLABLE POENH) */
    {{'\xed', '\x91', '\x87'}, 3, 0xD447}, /* (HANGUL SYLLABLE POED) */
    {{'\xed', '\x91', '\x88'}, 3, 0xD448}, /* (HANGUL SYLLABLE POEL) */
    {{'\xed', '\x91', '\x89'}, 3, 0xD449}, /* (HANGUL SYLLABLE POELG) */
    {{'\xed', '\x91', '\x8a'}, 3, 0xD44A}, /* (HANGUL SYLLABLE POELM) */
    {{'\xed', '\x91', '\x8b'}, 3, 0xD44B}, /* (HANGUL SYLLABLE POELB) */
    {{'\xed', '\x91', '\x8c'}, 3, 0xD44C}, /* (HANGUL SYLLABLE POELS) */
    {{'\xed', '\x91', '\x8d'}, 3, 0xD44D}, /* (HANGUL SYLLABLE POELT) */
    {{'\xed', '\x91', '\x8e'}, 3, 0xD44E}, /* (HANGUL SYLLABLE POELP) */
    {{'\xed', '\x91', '\x8f'}, 3, 0xD44F}, /* (HANGUL SYLLABLE POELH) */
    {{'\xed', '\x91', '\x90'}, 3, 0xD450}, /* (HANGUL SYLLABLE POEM) */
    {{'\xed', '\x91', '\x91'}, 3, 0xD451}, /* (HANGUL SYLLABLE POEB) */
    {{'\xed', '\x91', '\x92'}, 3, 0xD452}, /* (HANGUL SYLLABLE POEBS) */
    {{'\xed', '\x91', '\x93'}, 3, 0xD453}, /* (HANGUL SYLLABLE POES) */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{'\xed', '\x91', '\x94'}, 3, 0xD454}, /* (HANGUL SYLLABLE POESS) */
    {{'\xed', '\x91', '\x95'}, 3, 0xD455}, /* (HANGUL SYLLABLE POENG) */
    {{'\xed', '\x91', '\x96'}, 3, 0xD456}, /* (HANGUL SYLLABLE POEJ) */
    {{'\xed', '\x91', '\x97'}, 3, 0xD457}, /* (HANGUL SYLLABLE POEC) */
    {{'\xed', '\x91', '\x98'}, 3, 0xD458}, /* (HANGUL SYLLABLE POEK) */
    {{'\xed', '\x91', '\x99'}, 3, 0xD459}, /* (HANGUL SYLLABLE POET) */
    {{'\xed', '\x91', '\x9a'}, 3, 0xD45A}, /* (HANGUL SYLLABLE POEP) */
    {{'\xed', '\x91', '\x9b'}, 3, 0xD45B}, /* (HANGUL SYLLABLE POEH) */
    {{'\xed', '\x91', '\x9d'}, 3, 0xD45D}, /* (HANGUL SYLLABLE PYOG) */
    {{'\xed', '\x91', '\x9e'}, 3, 0xD45E}, /* (HANGUL SYLLABLE PYOGG) */
    {{'\xed', '\x91', '\x9f'}, 3, 0xD45F}, /* (HANGUL SYLLABLE PYOGS) */
    {{'\xed', '\x91', '\xa1'}, 3, 0xD461}, /* (HANGUL SYLLABLE PYONJ) */
    {{'\xed', '\x91', '\xa2'}, 3, 0xD462}, /* (HANGUL SYLLABLE PYONH) */
    {{'\xed', '\x91', '\xa3'}, 3, 0xD463}, /* (HANGUL SYLLABLE PYOD) */
    {{'\xed', '\x91', '\xa5'}, 3, 0xD465}, /* (HANGUL SYLLABLE PYOLG) */
    {{'\xed', '\x91', '\xa6'}, 3, 0xD466}, /* (HANGUL SYLLABLE PYOLM) */
    {{'\xed', '\x91', '\xa7'}, 3, 0xD467}, /* (HANGUL SYLLABLE PYOLB) */
    {{'\xed', '\x91', '\xa8'}, 3, 0xD468}, /* (HANGUL SYLLABLE PYOLS) */
    {{'\xed', '\x91', '\xa9'}, 3, 0xD469}, /* (HANGUL SYLLABLE PYOLT) */
    {{'\xed', '\x91', '\xaa'}, 3, 0xD46A}, /* (HANGUL SYLLABLE PYOLP) */
    {{'\xed', '\x91', '\xab'}, 3, 0xD46B}, /* (HANGUL SYLLABLE PYOLH) */
    {{'\xed', '\x91', '\xac'}, 3, 0xD46C}, /* (HANGUL SYLLABLE PYOM) */
    {{'\xed', '\x91', '\xae'}, 3, 0xD46E}, /* (HANGUL SYLLABLE PYOBS) */
    {{'\xed', '\x91', '\xb0'}, 3, 0xD470}, /* (HANGUL SYLLABLE PYOSS) */
    {{'\xed', '\x91', '\xb1'}, 3, 0xD471}, /* (HANGUL SYLLABLE PYONG) */
    {{'\xed', '\x91', '\xb2'}, 3, 0xD472}, /* (HANGUL SYLLABLE PYOJ) */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{'\xed', '\x91', '\xb3'}, 3, 0xD473}, /* (HANGUL SYLLABLE PYOC) */
    {{'\xed', '\x91', '\xb4'}, 3, 0xD474}, /* (HANGUL SYLLABLE PYOK) */
    {{'\xed', '\x91', '\xb5'}, 3, 0xD475}, /* (HANGUL SYLLABLE PYOT) */
    {{'\xed', '\x91', '\xb6'}, 3, 0xD476}, /* (HANGUL SYLLABLE PYOP) */
    {{'\xed', '\x91', '\xb7'}, 3, 0xD477}, /* (HANGUL SYLLABLE PYOH) */
    {{'\xed', '\x91', '\xba'}, 3, 0xD47A}, /* (HANGUL SYLLABLE PUGG) */
    {{'\xed', '\x91', '\xbb'}, 3, 0xD47B}, /* (HANGUL SYLLABLE PUGS) */
    {{'\xed', '\x91', '\xbd'}, 3, 0xD47D}, /* (HANGUL SYLLABLE PUNJ) */
    {{'\xed', '\x91', '\xbe'}, 3, 0xD47E}, /* (HANGUL SYLLABLE PUNH) */
    {{'\xed', '\x92', '\x81'}, 3, 0xD481}, /* (HANGUL SYLLABLE PULG) */
    {{'\xed', '\x92', '\x83'}, 3, 0xD483}, /* (HANGUL SYLLABLE PULB) */
    {{'\xed', '\x92', '\x84'}, 3, 0xD484}, /* (HANGUL SYLLABLE PULS) */
    {{'\xed', '\x92', '\x85'}, 3, 0xD485}, /* (HANGUL SYLLABLE PULT) */
    {{'\xed', '\x92', '\x86'}, 3, 0xD486}, /* (HANGUL SYLLABLE PULP) */
    {{'\xed', '\x92', '\x87'}, 3, 0xD487}, /* (HANGUL SYLLABLE PULH) */
    {{'\xed', '\x92', '\x8a'}, 3, 0xD48A}, /* (HANGUL SYLLABLE PUBS) */
    {{'\xed', '\x92', '\x8c'}, 3, 0xD48C}, /* (HANGUL SYLLABLE PUSS) */
    {{'\xed', '\x92', '\x8e'}, 3, 0xD48E}, /* (HANGUL SYLLABLE PUJ) */
    {{'\xed', '\x92', '\x8f'}, 3, 0xD48F}, /* (HANGUL SYLLABLE PUC) */
    {{'\xed', '\x92', '\x90'}, 3, 0xD490}, /* (HANGUL SYLLABLE PUK) */
    {{'\xed', '\x92', '\x91'}, 3, 0xD491}, /* (HANGUL SYLLABLE PUT) */
    {{'\xed', '\x92', '\x92'}, 3, 0xD492}, /* (HANGUL SYLLABLE PUP) */
    {{'\xed', '\x92', '\x93'}, 3, 0xD493}, /* (HANGUL SYLLABLE PUH) */
    {{'\xed', '\x92', '\x95'}, 3, 0xD495}, /* (HANGUL SYLLABLE PWEOG) */
    {{'\xed', '\x92', '\x96'}, 3, 0xD496}, /* (HANGUL SYLLABLE PWEOGG) */
    {{'\xed', '\x92', '\x97'}, 3, 0xD497}, /* (HANGUL SYLLABLE PWEOGS) */
    {{'\xed', '\x92', '\x98'}, 3, 0xD498}, /* (HANGUL SYLLABLE PWEON) */
    {{'\xed', '\x92', '\x99'}, 3, 0xD499}, /* (HANGUL SYLLABLE PWEONJ) */
    {{'\xed', '\x92', '\x9a'}, 3, 0xD49A}, /* (HANGUL SYLLABLE PWEONH) */
    {{'\xed', '\x92', '\x9b'}, 3, 0xD49B}, /* (HANGUL SYLLABLE PWEOD) */
    {{'\xed', '\x92', '\x9c'}, 3, 0xD49C}, /* (HANGUL SYLLABLE PWEOL) */
    {{'\xed', '\x92', '\x9d'}, 3, 0xD49D}, /* (HANGUL SYLLABLE PWEOLG) */
    {{'\xec', '\x90', '\xb4'}, 3, 0xC434}, /* (HANGUL SYLLABLE SSOEL) */
    {{'\xec', '\x90', '\xbc'}, 3, 0xC43C}, /* (HANGUL SYLLABLE SSOEM) */
    {{'\xec', '\x90', '\xbd'}, 3, 0xC43D}, /* (HANGUL SYLLABLE SSOEB) */
    {{'\xec', '\x91', '\x88'}, 3, 0xC448}, /* (HANGUL SYLLABLE SSYO) */
    {{'\xec', '\x91', '\xa4'}, 3, 0xC464}, /* (HANGUL SYLLABLE SSU) */
    {{'\xec', '\x91', '\xa5'}, 3, 0xC465}, /* (HANGUL SYLLABLE SSUG) */
    {{'\xec', '\x91', '\xa8'}, 3, 0xC468}, /* (HANGUL SYLLABLE SSUN) */
    {{'\xec', '\x91', '\xac'}, 3, 0xC46C}, /* (HANGUL SYLLABLE SSUL) */
    {{'\xec', '\x91', '\xb4'}, 3, 0xC474}, /* (HANGUL SYLLABLE SSUM) */
    {{'\xec', '\x91', '\xb5'}, 3, 0xC475}, /* (HANGUL SYLLABLE SSUB) */
    {{'\xec', '\x91', '\xb9'}, 3, 0xC479}, /* (HANGUL SYLLABLE SSUNG) */
    {{'\xec', '\x92', '\x80'}, 3, 0xC480}, /* (HANGUL SYLLABLE SSWEO) */
    {{'\xec', '\x92', '\x94'}, 3, 0xC494}, /* (HANGUL SYLLABLE SSWEOSS) */
    {{'\xec', '\x92', '\x9c'}, 3, 0xC49C}, /* (HANGUL SYLLABLE SSWE) */
    {{'\xec', '\x92', '\xb8'}, 3, 0xC4B8}, /* (HANGUL SYLLABLE SSWI) */
    {{'\xec', '\x92', '\xbc'}, 3, 0xC4BC}, /* (HANGUL SYLLABLE SSWIN) */
    {{'\xec', '\x93', '\xa9'}, 3, 0xC4E9}, /* (HANGUL SYLLABLE SSYUNG) */
    {{'\xec', '\x93', '\xb0'}, 3, 0xC4F0}, /* (HANGUL SYLLABLE SSEU) */
    {{'\xec', '\x93', '\xb1'}, 3, 0xC4F1}, /* (HANGUL SYLLABLE SSEUG) */
    {{'\xec', '\x93', '\xb4'}, 3, 0xC4F4}, /* (HANGUL SYLLABLE SSEUN) */
    {{'\xec', '\x93', '\xb8'}, 3, 0xC4F8}, /* (HANGUL SYLLABLE SSEUL) */
    {{'\xec', '\x93', '\xba'}, 3, 0xC4FA}, /* (HANGUL SYLLABLE SSEULM) */
    {{'\xec', '\x93', '\xbf'}, 3, 0xC4FF}, /* (HANGUL SYLLABLE SSEULH) */
    {{'\xec', '\x94', '\x80'}, 3, 0xC500}, /* (HANGUL SYLLABLE SSEUM) */
    {{'\xec', '\x94', '\x81'}, 3, 0xC501}, /* (HANGUL SYLLABLE SSEUB) */
    {{'\xec', '\x94', '\x8c'}, 3, 0xC50C}, /* (HANGUL SYLLABLE SSYI) */
    {{'\xec', '\x94', '\x90'}, 3, 0xC510}, /* (HANGUL SYLLABLE SSYIN) */
    {{'\xec', '\x94', '\x94'}, 3, 0xC514}, /* (HANGUL SYLLABLE SSYIL) */
    {{'\xec', '\x94', '\x9c'}, 3, 0xC51C}, /* (HANGUL SYLLABLE SSYIM) */
    {{'\xec', '\x94', '\xa8'}, 3, 0xC528}, /* (HANGUL SYLLABLE SSI) */
    {{'\xec', '\x94', '\xa9'}, 3, 0xC529}, /* (HANGUL SYLLABLE SSIG) */
    {{'\xec', '\x94', '\xac'}, 3, 0xC52C}, /* (HANGUL SYLLABLE SSIN) */
    {{'\xec', '\x94', '\xb0'}, 3, 0xC530}, /* (HANGUL SYLLABLE SSIL) */
    {{'\xec', '\x94', '\xb8'}, 3, 0xC538}, /* (HANGUL SYLLABLE SSIM) */
    {{'\xec', '\x94', '\xb9'}, 3, 0xC539}, /* (HANGUL SYLLABLE SSIB) */
    {{'\xec', '\x94', '\xbb'}, 3, 0xC53B}, /* (HANGUL SYLLABLE SSIS) */
    {{'\xec', '\x94', '\xbd'}, 3, 0xC53D}, /* (HANGUL SYLLABLE SSING) */
    {{'\xec', '\x95', '\x84'}, 3, 0xC544}, /* (HANGUL SYLLABLE A) */
    {{'\xec', '\x95', '\x85'}, 3, 0xC545}, /* (HANGUL SYLLABLE AG) */
    {{'\xec', '\x95', '\x88'}, 3, 0xC548}, /* (HANGUL SYLLABLE AN) */
    {{'\xec', '\x95', '\x89'}, 3, 0xC549}, /* (HANGUL SYLLABLE ANJ) */
    {{'\xec', '\x95', '\x8a'}, 3, 0xC54A}, /* (HANGUL SYLLABLE ANH) */
    {{'\xec', '\x95', '\x8c'}, 3, 0xC54C}, /* (HANGUL SYLLABLE AL) */
    {{'\xec', '\x95', '\x8d'}, 3, 0xC54D}, /* (HANGUL SYLLABLE ALG) */
    {{'\xec', '\x95', '\x8e'}, 3, 0xC54E}, /* (HANGUL SYLLABLE ALM) */
    {{'\xec', '\x95', '\x93'}, 3, 0xC553}, /* (HANGUL SYLLABLE ALH) */
    {{'\xec', '\x95', '\x94'}, 3, 0xC554}, /* (HANGUL SYLLABLE AM) */
    {{'\xec', '\x95', '\x95'}, 3, 0xC555}, /* (HANGUL SYLLABLE AB) */
    {{'\xec', '\x95', '\x97'}, 3, 0xC557}, /* (HANGUL SYLLABLE AS) */
    {{'\xec', '\x95', '\x98'}, 3, 0xC558}, /* (HANGUL SYLLABLE ASS) */
    {{'\xec', '\x95', '\x99'}, 3, 0xC559}, /* (HANGUL SYLLABLE ANG) */
    {{'\xec', '\x95', '\x9d'}, 3, 0xC55D}, /* (HANGUL SYLLABLE AT) */
    {{'\xec', '\x95', '\x9e'}, 3, 0xC55E}, /* (HANGUL SYLLABLE AP) */
    {{'\xec', '\x95', '\xa0'}, 3, 0xC560}, /* (HANGUL SYLLABLE AE) */
    {{'\xec', '\x95', '\xa1'}, 3, 0xC561}, /* (HANGUL SYLLABLE AEG) */
    {{'\xec', '\x95', '\xa4'}, 3, 0xC564}, /* (HANGUL SYLLABLE AEN) */
    {{'\xec', '\x95', '\xa8'}, 3, 0xC568}, /* (HANGUL SYLLABLE AEL) */
    {{'\xec', '\x95', '\xb0'}, 3, 0xC570}, /* (HANGUL SYLLABLE AEM) */
    {{'\xec', '\x95', '\xb1'}, 3, 0xC571}, /* (HANGUL SYLLABLE AEB) */
    {{'\xec', '\x95', '\xb3'}, 3, 0xC573}, /* (HANGUL SYLLABLE AES) */
    {{'\xec', '\x95', '\xb4'}, 3, 0xC574}, /* (HANGUL SYLLABLE AESS) */
    {{'\xec', '\x95', '\xb5'}, 3, 0xC575}, /* (HANGUL SYLLABLE AENG) */
    {{'\xec', '\x95', '\xbc'}, 3, 0xC57C}, /* (HANGUL SYLLABLE YA) */
    {{'\xec', '\x95', '\xbd'}, 3, 0xC57D}, /* (HANGUL SYLLABLE YAG) */
    {{'\xec', '\x96', '\x80'}, 3, 0xC580}, /* (HANGUL SYLLABLE YAN) */
    {{'\xec', '\x96', '\x84'}, 3, 0xC584}, /* (HANGUL SYLLABLE YAL) */
    {{'\xec', '\x96', '\x87'}, 3, 0xC587}, /* (HANGUL SYLLABLE YALB) */
    {{'\xec', '\x96', '\x8c'}, 3, 0xC58C}, /* (HANGUL SYLLABLE YAM) */
    {{'\xec', '\x96', '\x8d'}, 3, 0xC58D}, /* (HANGUL SYLLABLE YAB) */
    {{'\xec', '\x96', '\x8f'}, 3, 0xC58F}, /* (HANGUL SYLLABLE YAS) */
    {{'\xec', '\x96', '\x91'}, 3, 0xC591}, /* (HANGUL SYLLABLE YANG) */
    {{'\xec', '\x96', '\x95'}, 3, 0xC595}, /* (HANGUL SYLLABLE YAT) */
    {{'\xec', '\x96', '\x97'}, 3, 0xC597}, /* (HANGUL SYLLABLE YAH) */
    {{'\xec', '\x96', '\x98'}, 3, 0xC598}, /* (HANGUL SYLLABLE YAE) */
    {{'\xec', '\x96', '\x9c'}, 3, 0xC59C}, /* (HANGUL SYLLABLE YAEN) */
    {{'\xec', '\x96', '\xa0'}, 3, 0xC5A0}, /* (HANGUL SYLLABLE YAEL) */
    {{'\xec', '\x96', '\xa9'}, 3, 0xC5A9}, /* (HANGUL SYLLABLE YAEB) */
    {{'\xec', '\x96', '\xb4'}, 3, 0xC5B4}, /* (HANGUL SYLLABLE EO) */
    {{'\xec', '\x96', '\xb5'}, 3, 0xC5B5}, /* (HANGUL SYLLABLE EOG) */
    {{'\xec', '\x96', '\xb8'}, 3, 0xC5B8}, /* (HANGUL SYLLABLE EON) */
    {{'\xec', '\x96', '\xb9'}, 3, 0xC5B9}, /* (HANGUL SYLLABLE EONJ) */
    {{'\xec', '\x96', '\xbb'}, 3, 0xC5BB}, /* (HANGUL SYLLABLE EOD) */
    {{'\xec', '\x96', '\xbc'}, 3, 0xC5BC}, /* (HANGUL SYLLABLE EOL) */
    {{'\xec', '\x96', '\xbd'}, 3, 0xC5BD}, /* (HANGUL SYLLABLE EOLG) */
    {{'\xec', '\x96', '\xbe'}, 3, 0xC5BE}, /* (HANGUL SYLLABLE EOLM) */
    {{'\xec', '\x97', '\x84'}, 3, 0xC5C4}, /* (HANGUL SYLLABLE EOM) */
    {{'\xec', '\x97', '\x85'}, 3, 0xC5C5}, /* (HANGUL SYLLABLE EOB) */
    {{'\xec', '\x97', '\x86'}, 3, 0xC5C6}, /* (HANGUL SYLLABLE EOBS) */
    {{'\xec', '\x97', '\x87'}, 3, 0xC5C7}, /* (HANGUL SYLLABLE EOS) */
    {{'\xec', '\x97', '\x88'}, 3, 0xC5C8}, /* (HANGUL SYLLABLE EOSS) */
    {{'\xec', '\x97', '\x89'}, 3, 0xC5C9}, /* (HANGUL SYLLABLE EONG) */
    {{'\xec', '\x97', '\x8a'}, 3, 0xC5CA}, /* (HANGUL SYLLABLE EOJ) */
    {{'\xec', '\x97', '\x8c'}, 3, 0xC5CC}, /* (HANGUL SYLLABLE EOK) */
    {{'\xec', '\x97', '\x8e'}, 3, 0xC5CE}, /* (HANGUL SYLLABLE EOP) */
    {{'\xed', '\x92', '\x9e'}, 3, 0xD49E}, /* (HANGUL SYLLABLE PWEOLM) */
    {{'\xed', '\x92', '\x9f'}, 3, 0xD49F}, /* (HANGUL SYLLABLE PWEOLB) */
    {{'\xed', '\x92', '\xa0'}, 3, 0xD4A0}, /* (HANGUL SYLLABLE PWEOLS) */
    {{'\xed', '\x92', '\xa1'}, 3, 0xD4A1}, /* (HANGUL SYLLABLE PWEOLT) */
    {{'\xed', '\x92', '\xa2'}, 3, 0xD4A2}, /* (HANGUL SYLLABLE PWEOLP) */
    {{'\xed', '\x92', '\xa3'}, 3, 0xD4A3}, /* (HANGUL SYLLABLE PWEOLH) */
    {{'\xed', '\x92', '\xa4'}, 3, 0xD4A4}, /* (HANGUL SYLLABLE PWEOM) */
    {{'\xed', '\x92', '\xa5'}, 3, 0xD4A5}, /* (HANGUL SYLLABLE PWEOB) */
    {{'\xed', '\x92', '\xa6'}, 3, 0xD4A6}, /* (HANGUL SYLLABLE PWEOBS) */
    {{'\xed', '\x92', '\xa7'}, 3, 0xD4A7}, /* (HANGUL SYLLABLE PWEOS) */
    {{'\xed', '\x92', '\xa8'}, 3, 0xD4A8}, /* (HANGUL SYLLABLE PWEOSS) */
    {{'\xed', '\x92', '\xaa'}, 3, 0xD4AA}, /* (HANGUL SYLLABLE PWEOJ) */
    {{'\xed', '\x92', '\xab'}, 3, 0xD4AB}, /* (HANGUL SYLLABLE PWEOC) */
    {{'\xed', '\x92', '\xac'}, 3, 0xD4AC}, /* (HANGUL SYLLABLE PWEOK) */
    {{'\xed', '\x92', '\xad'}, 3, 0xD4AD}, /* (HANGUL SYLLABLE PWEOT) */
    {{'\xed', '\x92', '\xae'}, 3, 0xD4AE}, /* (HANGUL SYLLABLE PWEOP) */
    {{'\xed', '\x92', '\xaf'}, 3, 0xD4AF}, /* (HANGUL SYLLABLE PWEOH) */
    {{'\xed', '\x92', '\xb0'}, 3, 0xD4B0}, /* (HANGUL SYLLABLE PWE) */
    {{'\xed', '\x92', '\xb1'}, 3, 0xD4B1}, /* (HANGUL SYLLABLE PWEG) */
    {{'\xed', '\x92', '\xb2'}, 3, 0xD4B2}, /* (HANGUL SYLLABLE PWEGG) */
    {{'\xed', '\x92', '\xb3'}, 3, 0xD4B3}, /* (HANGUL SYLLABLE PWEGS) */
    {{'\xed', '\x92', '\xb4'}, 3, 0xD4B4}, /* (HANGUL SYLLABLE PWEN) */
    {{'\xed', '\x92', '\xb5'}, 3, 0xD4B5}, /* (HANGUL SYLLABLE PWENJ) */
    {{'\xed', '\x92', '\xb6'}, 3, 0xD4B6}, /* (HANGUL SYLLABLE PWENH) */
    {{'\xed', '\x92', '\xb7'}, 3, 0xD4B7}, /* (HANGUL SYLLABLE PWED) */
    {{'\xed', '\x92', '\xb8'}, 3, 0xD4B8}, /* (HANGUL SYLLABLE PWEL) */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{'\xed', '\x92', '\xb9'}, 3, 0xD4B9}, /* (HANGUL SYLLABLE PWELG) */
    {{'\xed', '\x92', '\xba'}, 3, 0xD4BA}, /* (HANGUL SYLLABLE PWELM) */
    {{'\xed', '\x92', '\xbb'}, 3, 0xD4BB}, /* (HANGUL SYLLABLE PWELB) */
    {{'\xed', '\x92', '\xbc'}, 3, 0xD4BC}, /* (HANGUL SYLLABLE PWELS) */
    {{'\xed', '\x92', '\xbd'}, 3, 0xD4BD}, /* (HANGUL SYLLABLE PWELT) */
    {{'\xed', '\x92', '\xbe'}, 3, 0xD4BE}, /* (HANGUL SYLLABLE PWELP) */
    {{'\xed', '\x92', '\xbf'}, 3, 0xD4BF}, /* (HANGUL SYLLABLE PWELH) */
    {{'\xed', '\x93', '\x80'}, 3, 0xD4C0}, /* (HANGUL SYLLABLE PWEM) */
    {{'\xed', '\x93', '\x81'}, 3, 0xD4C1}, /* (HANGUL SYLLABLE PWEB) */
    {{'\xed', '\x93', '\x82'}, 3, 0xD4C2}, /* (HANGUL SYLLABLE PWEBS) */
    {{'\xed', '\x93', '\x83'}, 3, 0xD4C3}, /* (HANGUL SYLLABLE PWES) */
    {{'\xed', '\x93', '\x84'}, 3, 0xD4C4}, /* (HANGUL SYLLABLE PWESS) */
    {{'\xed', '\x93', '\x85'}, 3, 0xD4C5}, /* (HANGUL SYLLABLE PWENG) */
    {{'\xed', '\x93', '\x86'}, 3, 0xD4C6}, /* (HANGUL SYLLABLE PWEJ) */
    {{'\xed', '\x93', '\x87'}, 3, 0xD4C7}, /* (HANGUL SYLLABLE PWEC) */
    {{'\xed', '\x93', '\x88'}, 3, 0xD4C8}, /* (HANGUL SYLLABLE PWEK) */
    {{'\xed', '\x93', '\x89'}, 3, 0xD4C9}, /* (HANGUL SYLLABLE PWET) */
    {{'\xed', '\x93', '\x8a'}, 3, 0xD4CA}, /* (HANGUL SYLLABLE PWEP) */
    {{'\xed', '\x93', '\x8b'}, 3, 0xD4CB}, /* (HANGUL SYLLABLE PWEH) */
    {{'\xed', '\x93', '\x8d'}, 3, 0xD4CD}, /* (HANGUL SYLLABLE PWIG) */
    {{'\xed', '\x93', '\x8e'}, 3, 0xD4CE}, /* (HANGUL SYLLABLE PWIGG) */
    {{'\xed', '\x93', '\x8f'}, 3, 0xD4CF}, /* (HANGUL SYLLABLE PWIGS) */
    {{'\xed', '\x93', '\x91'}, 3, 0xD4D1}, /* (HANGUL SYLLABLE PWINJ) */
    {{'\xed', '\x93', '\x92'}, 3, 0xD4D2}, /* (HANGUL SYLLABLE PWINH) */
    {{'\xed', '\x93', '\x93'}, 3, 0xD4D3}, /* (HANGUL SYLLABLE PWID) */
    {{'\xed', '\x93', '\x95'}, 3, 0xD4D5}, /* (HANGUL SYLLABLE PWILG) */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{'\xed', '\x93', '\x96'}, 3, 0xD4D6}, /* (HANGUL SYLLABLE PWILM) */
    {{'\xed', '\x93', '\x97'}, 3, 0xD4D7}, /* (HANGUL SYLLABLE PWILB) */
    {{'\xed', '\x93', '\x98'}, 3, 0xD4D8}, /* (HANGUL SYLLABLE PWILS) */
    {{'\xed', '\x93', '\x99'}, 3, 0xD4D9}, /* (HANGUL SYLLABLE PWILT) */
    {{'\xed', '\x93', '\x9a'}, 3, 0xD4DA}, /* (HANGUL SYLLABLE PWILP) */
    {{'\xed', '\x93', '\x9b'}, 3, 0xD4DB}, /* (HANGUL SYLLABLE PWILH) */
    {{'\xed', '\x93', '\x9d'}, 3, 0xD4DD}, /* (HANGUL SYLLABLE PWIB) */
    {{'\xed', '\x93', '\x9e'}, 3, 0xD4DE}, /* (HANGUL SYLLABLE PWIBS) */
    {{'\xed', '\x93', '\xa0'}, 3, 0xD4E0}, /* (HANGUL SYLLABLE PWISS) */
    {{'\xed', '\x93', '\xa1'}, 3, 0xD4E1}, /* (HANGUL SYLLABLE PWING) */
    {{'\xed', '\x93', '\xa2'}, 3, 0xD4E2}, /* (HANGUL SYLLABLE PWIJ) */
    {{'\xed', '\x93', '\xa3'}, 3, 0xD4E3}, /* (HANGUL SYLLABLE PWIC) */
    {{'\xed', '\x93', '\xa4'}, 3, 0xD4E4}, /* (HANGUL SYLLABLE PWIK) */
    {{'\xed', '\x93', '\xa5'}, 3, 0xD4E5}, /* (HANGUL SYLLABLE PWIT) */
    {{'\xed', '\x93', '\xa6'}, 3, 0xD4E6}, /* (HANGUL SYLLABLE PWIP) */
    {{'\xed', '\x93', '\xa7'}, 3, 0xD4E7}, /* (HANGUL SYLLABLE PWIH) */
    {{'\xed', '\x93', '\xa9'}, 3, 0xD4E9}, /* (HANGUL SYLLABLE PYUG) */
    {{'\xed', '\x93', '\xaa'}, 3, 0xD4EA}, /* (HANGUL SYLLABLE PYUGG) */
    {{'\xed', '\x93', '\xab'}, 3, 0xD4EB}, /* (HANGUL SYLLABLE PYUGS) */
    {{'\xed', '\x93', '\xad'}, 3, 0xD4ED}, /* (HANGUL SYLLABLE PYUNJ) */
    {{'\xed', '\x93', '\xae'}, 3, 0xD4EE}, /* (HANGUL SYLLABLE PYUNH) */
    {{'\xed', '\x93', '\xaf'}, 3, 0xD4EF}, /* (HANGUL SYLLABLE PYUD) */
    {{'\xed', '\x93', '\xb1'}, 3, 0xD4F1}, /* (HANGUL SYLLABLE PYULG) */
    {{'\xed', '\x93', '\xb2'}, 3, 0xD4F2}, /* (HANGUL SYLLABLE PYULM) */
    {{'\xed', '\x93', '\xb3'}, 3, 0xD4F3}, /* (HANGUL SYLLABLE PYULB) */
    {{'\xed', '\x93', '\xb4'}, 3, 0xD4F4}, /* (HANGUL SYLLABLE PYULS) */
    {{'\xed', '\x93', '\xb5'}, 3, 0xD4F5}, /* (HANGUL SYLLABLE PYULT) */
    {{'\xed', '\x93', '\xb6'}, 3, 0xD4F6}, /* (HANGUL SYLLABLE PYULP) */
    {{'\xed', '\x93', '\xb7'}, 3, 0xD4F7}, /* (HANGUL SYLLABLE PYULH) */
    {{'\xed', '\x93', '\xb9'}, 3, 0xD4F9}, /* (HANGUL SYLLABLE PYUB) */
    {{'\xed', '\x93', '\xba'}, 3, 0xD4FA}, /* (HANGUL SYLLABLE PYUBS) */
    {{'\xed', '\x93', '\xbc'}, 3, 0xD4FC}, /* (HANGUL SYLLABLE PYUSS) */
    {{'\xec', '\x97', '\x90'}, 3, 0xC5D0}, /* (HANGUL SYLLABLE E) */
    {{'\xec', '\x97', '\x91'}, 3, 0xC5D1}, /* (HANGUL SYLLABLE EG) */
    {{'\xec', '\x97', '\x94'}, 3, 0xC5D4}, /* (HANGUL SYLLABLE EN) */
    {{'\xec', '\x97', '\x98'}, 3, 0xC5D8}, /* (HANGUL SYLLABLE EL) */
    {{'\xec', '\x97', '\xa0'}, 3, 0xC5E0}, /* (HANGUL SYLLABLE EM) */
    {{'\xec', '\x97', '\xa1'}, 3, 0xC5E1}, /* (HANGUL SYLLABLE EB) */
    {{'\xec', '\x97', '\xa3'}, 3, 0xC5E3}, /* (HANGUL SYLLABLE ES) */
    {{'\xec', '\x97', '\xa5'}, 3, 0xC5E5}, /* (HANGUL SYLLABLE ENG) */
    {{'\xec', '\x97', '\xac'}, 3, 0xC5EC}, /* (HANGUL SYLLABLE YEO) */
    {{'\xec', '\x97', '\xad'}, 3, 0xC5ED}, /* (HANGUL SYLLABLE YEOG) */
    {{'\xec', '\x97', '\xae'}, 3, 0xC5EE}, /* (HANGUL SYLLABLE YEOGG) */
    {{'\xec', '\x97', '\xb0'}, 3, 0xC5F0}, /* (HANGUL SYLLABLE YEON) */
    {{'\xec', '\x97', '\xb4'}, 3, 0xC5F4}, /* (HANGUL SYLLABLE YEOL) */
    {{'\xec', '\x97', '\xb6'}, 3, 0xC5F6}, /* (HANGUL SYLLABLE YEOLM) */
    {{'\xec', '\x97', '\xb7'}, 3, 0xC5F7}, /* (HANGUL SYLLABLE YEOLB) */
    {{'\xec', '\x97', '\xbc'}, 3, 0xC5FC}, /* (HANGUL SYLLABLE YEOM) */
    {{'\xec', '\x97', '\xbd'}, 3, 0xC5FD}, /* (HANGUL SYLLABLE YEOB) */
    {{'\xec', '\x97', '\xbe'}, 3, 0xC5FE}, /* (HANGUL SYLLABLE YEOBS) */
    {{'\xec', '\x97', '\xbf'}, 3, 0xC5FF}, /* (HANGUL SYLLABLE YEOS) */
    {{'\xec', '\x98', '\x80'}, 3, 0xC600}, /* (HANGUL SYLLABLE YEOSS) */
    {{'\xec', '\x98', '\x81'}, 3, 0xC601}, /* (HANGUL SYLLABLE YEONG) */
    {{'\xec', '\x98', '\x85'}, 3, 0xC605}, /* (HANGUL SYLLABLE YEOT) */
    {{'\xec', '\x98', '\x86'}, 3, 0xC606}, /* (HANGUL SYLLABLE YEOP) */
    {{'\xec', '\x98', '\x87'}, 3, 0xC607}, /* (HANGUL SYLLABLE YEOH) */
    {{'\xec', '\x98', '\x88'}, 3, 0xC608}, /* (HANGUL SYLLABLE YE) */
    {{'\xec', '\x98', '\x8c'}, 3, 0xC60C}, /* (HANGUL SYLLABLE YEN) */
    {{'\xec', '\x98', '\x90'}, 3, 0xC610}, /* (HANGUL SYLLABLE YEL) */
    {{'\xec', '\x98', '\x98'}, 3, 0xC618}, /* (HANGUL SYLLABLE YEM) */
    {{'\xec', '\x98', '\x99'}, 3, 0xC619}, /* (HANGUL SYLLABLE YEB) */
    {{'\xec', '\x98', '\x9b'}, 3, 0xC61B}, /* (HANGUL SYLLABLE YES) */
    {{'\xec', '\x98', '\x9c'}, 3, 0xC61C}, /* (HANGUL SYLLABLE YESS) */
    {{'\xec', '\x98', '\xa4'}, 3, 0xC624}, /* (HANGUL SYLLABLE O) */
    {{'\xec', '\x98', '\xa5'}, 3, 0xC625}, /* (HANGUL SYLLABLE OG) */
    {{'\xec', '\x98', '\xa8'}, 3, 0xC628}, /* (HANGUL SYLLABLE ON) */
    {{'\xec', '\x98', '\xac'}, 3, 0xC62C}, /* (HANGUL SYLLABLE OL) */
    {{'\xec', '\x98', '\xad'}, 3, 0xC62D}, /* (HANGUL SYLLABLE OLG) */
    {{'\xec', '\x98', '\xae'}, 3, 0xC62E}, /* (HANGUL SYLLABLE OLM) */
    {{'\xec', '\x98', '\xb0'}, 3, 0xC630}, /* (HANGUL SYLLABLE OLS) */
    {{'\xec', '\x98', '\xb3'}, 3, 0xC633}, /* (HANGUL SYLLABLE OLH) */
    {{'\xec', '\x98', '\xb4'}, 3, 0xC634}, /* (HANGUL SYLLABLE OM) */
    {{'\xec', '\x98', '\xb5'}, 3, 0xC635}, /* (HANGUL SYLLABLE OB) */
    {{'\xec', '\x98', '\xb7'}, 3, 0xC637}, /* (HANGUL SYLLABLE OS) */
    {{'\xec', '\x98', '\xb9'}, 3, 0xC639}, /* (HANGUL SYLLABLE ONG) */
    {{'\xec', '\x98', '\xbb'}, 3, 0xC63B}, /* (HANGUL SYLLABLE OC) */
    {{'\xec', '\x99', '\x80'}, 3, 0xC640}, /* (HANGUL SYLLABLE WA) */
    {{'\xec', '\x99', '\x81'}, 3, 0xC641}, /* (HANGUL SYLLABLE WAG) */
    {{'\xec', '\x99', '\x84'}, 3, 0xC644}, /* (HANGUL SYLLABLE WAN) */
    {{'\xec', '\x99', '\x88'}, 3, 0xC648}, /* (HANGUL SYLLABLE WAL) */
    {{'\xec', '\x99', '\x90'}, 3, 0xC650}, /* (HANGUL SYLLABLE WAM) */
    {{'\xec', '\x99', '\x91'}, 3, 0xC651}, /* (HANGUL SYLLABLE WAB) */
    {{'\xec', '\x99', '\x93'}, 3, 0xC653}, /* (HANGUL SYLLABLE WAS) */
    {{'\xec', '\x99', '\x94'}, 3, 0xC654}, /* (HANGUL SYLLABLE WASS) */
    {{'\xec', '\x99', '\x95'}, 3, 0xC655}, /* (HANGUL SYLLABLE WANG) */
    {{'\xec', '\x99', '\x9c'}, 3, 0xC65C}, /* (HANGUL SYLLABLE WAE) */
    {{'\xec', '\x99', '\x9d'}, 3, 0xC65D}, /* (HANGUL SYLLABLE WAEG) */
    {{'\xec', '\x99', '\xa0'}, 3, 0xC660}, /* (HANGUL SYLLABLE WAEN) */
    {{'\xec', '\x99', '\xac'}, 3, 0xC66C}, /* (HANGUL SYLLABLE WAEM) */
    {{'\xec', '\x99', '\xaf'}, 3, 0xC66F}, /* (HANGUL SYLLABLE WAES) */
    {{'\xec', '\x99', '\xb1'}, 3, 0xC671}, /* (HANGUL SYLLABLE WAENG) */
    {{'\xec', '\x99', '\xb8'}, 3, 0xC678}, /* (HANGUL SYLLABLE OE) */
    {{'\xec', '\x99', '\xb9'}, 3, 0xC679}, /* (HANGUL SYLLABLE OEG) */
    {{'\xec', '\x99', '\xbc'}, 3, 0xC67C}, /* (HANGUL SYLLABLE OEN) */
    {{'\xec', '\x9a', '\x80'}, 3, 0xC680}, /* (HANGUL SYLLABLE OEL) */
    {{'\xec', '\x9a', '\x88'}, 3, 0xC688}, /* (HANGUL SYLLABLE OEM) */
    {{'\xec', '\x9a', '\x89'}, 3, 0xC689}, /* (HANGUL SYLLABLE OEB) */
    {{'\xec', '\x9a', '\x8b'}, 3, 0xC68B}, /* (HANGUL SYLLABLE OES) */
    {{'\xec', '\x9a', '\x8d'}, 3, 0xC68D}, /* (HANGUL SYLLABLE OENG) */
    {{'\xec', '\x9a', '\x94'}, 3, 0xC694}, /* (HANGUL SYLLABLE YO) */
    {{'\xec', '\x9a', '\x95'}, 3, 0xC695}, /* (HANGUL SYLLABLE YOG) */
    {{'\xec', '\x9a', '\x98'}, 3, 0xC698}, /* (HANGUL SYLLABLE YON) */
    {{'\xec', '\x9a', '\x9c'}, 3, 0xC69C}, /* (HANGUL SYLLABLE YOL) */
    {{'\xec', '\x9a', '\xa4'}, 3, 0xC6A4}, /* (HANGUL SYLLABLE YOM) */
    {{'\xec', '\x9a', '\xa5'}, 3, 0xC6A5}, /* (HANGUL SYLLABLE YOB) */
    {{'\xec', '\x9a', '\xa7'}, 3, 0xC6A7}, /* (HANGUL SYLLABLE YOS) */
    {{'\xec', '\x9a', '\xa9'}, 3, 0xC6A9}, /* (HANGUL SYLLABLE YONG) */
    {{'\xec', '\x9a', '\xb0'}, 3, 0xC6B0}, /* (HANGUL SYLLABLE U) */
    {{'\xec', '\x9a', '\xb1'}, 3, 0xC6B1}, /* (HANGUL SYLLABLE UG) */
    {{'\xec', '\x9a', '\xb4'}, 3, 0xC6B4}, /* (HANGUL SYLLABLE UN) */
    {{'\xec', '\x9a', '\xb8'}, 3, 0xC6B8}, /* (HANGUL SYLLABLE UL) */
    {{'\xec', '\x9a', '\xb9'}, 3, 0xC6B9}, /* (HANGUL SYLLABLE ULG) */
    {{'\xec', '\x9a', '\xba'}, 3, 0xC6BA}, /* (HANGUL SYLLABLE ULM) */
    {{'\xec', '\x9b', '\x80'}, 3, 0xC6C0}, /* (HANGUL SYLLABLE UM) */
    {{'\xec', '\x9b', '\x81'}, 3, 0xC6C1}, /* (HANGUL SYLLABLE UB) */
    {{'\xec', '\x9b', '\x83'}, 3, 0xC6C3}, /* (HANGUL SYLLABLE US) */
    {{'\xec', '\x9b', '\x85'}, 3, 0xC6C5}, /* (HANGUL SYLLABLE UNG) */
    {{'\xec', '\x9b', '\x8c'}, 3, 0xC6CC}, /* (HANGUL SYLLABLE WEO) */
    {{'\xec', '\x9b', '\x8d'}, 3, 0xC6CD}, /* (HANGUL SYLLABLE WEOG) */
    {{'\xec', '\x9b', '\x90'}, 3, 0xC6D0}, /* (HANGUL SYLLABLE WEON) */
    {{'\xec', '\x9b', '\x94'}, 3, 0xC6D4}, /* (HANGUL SYLLABLE WEOL) */
    {{'\xec', '\x9b', '\x9c'}, 3, 0xC6DC}, /* (HANGUL SYLLABLE WEOM) */
    {{'\xec', '\x9b', '\x9d'}, 3, 0xC6DD}, /* (HANGUL SYLLABLE WEOB) */
    {{'\xec', '\x9b', '\xa0'}, 3, 0xC6E0}, /* (HANGUL SYLLABLE WEOSS) */
    {{'\xec', '\x9b', '\xa1'}, 3, 0xC6E1}, /* (HANGUL SYLLABLE WEONG) */
    {{'\xec', '\x9b', '\xa8'}, 3, 0xC6E8}, /* (HANGUL SYLLABLE WE) */
    {{'\xed', '\x93', '\xbe'}, 3, 0xD4FE}, /* (HANGUL SYLLABLE PYUJ) */
    {{'\xed', '\x93', '\xbf'}, 3, 0xD4FF}, /* (HANGUL SYLLABLE PYUC) */
    {{'\xed', '\x94', '\x80'}, 3, 0xD500}, /* (HANGUL SYLLABLE PYUK) */
    {{'\xed', '\x94', '\x81'}, 3, 0xD501}, /* (HANGUL SYLLABLE PYUT) */
    {{'\xed', '\x94', '\x82'}, 3, 0xD502}, /* (HANGUL SYLLABLE PYUP) */
    {{'\xed', '\x94', '\x83'}, 3, 0xD503}, /* (HANGUL SYLLABLE PYUH) */
    {{'\xed', '\x94', '\x85'}, 3, 0xD505}, /* (HANGUL SYLLABLE PEUG) */
    {{'\xed', '\x94', '\x86'}, 3, 0xD506}, /* (HANGUL SYLLABLE PEUGG) */
    {{'\xed', '\x94', '\x87'}, 3, 0xD507}, /* (HANGUL SYLLABLE PEUGS) */
    {{'\xed', '\x94', '\x89'}, 3, 0xD509}, /* (HANGUL SYLLABLE PEUNJ) */
    {{'\xed', '\x94', '\x8a'}, 3, 0xD50A}, /* (HANGUL SYLLABLE PEUNH) */
    {{'\xed', '\x94', '\x8b'}, 3, 0xD50B}, /* (HANGUL SYLLABLE PEUD) */
    {{'\xed', '\x94', '\x8d'}, 3, 0xD50D}, /* (HANGUL SYLLABLE PEULG) */
    {{'\xed', '\x94', '\x8e'}, 3, 0xD50E}, /* (HANGUL SYLLABLE PEULM) */
    {{'\xed', '\x94', '\x8f'}, 3, 0xD50F}, /* (HANGUL SYLLABLE PEULB) */
    {{'\xed', '\x94', '\x90'}, 3, 0xD510}, /* (HANGUL SYLLABLE PEULS) */
    {{'\xed', '\x94', '\x91'}, 3, 0xD511}, /* (HANGUL SYLLABLE PEULT) */
    {{'\xed', '\x94', '\x92'}, 3, 0xD512}, /* (HANGUL SYLLABLE PEULP) */
    {{'\xed', '\x94', '\x93'}, 3, 0xD513}, /* (HANGUL SYLLABLE PEULH) */
    {{'\xed', '\x94', '\x96'}, 3, 0xD516}, /* (HANGUL SYLLABLE PEUBS) */
    {{'\xed', '\x94', '\x98'}, 3, 0xD518}, /* (HANGUL SYLLABLE PEUSS) */
    {{'\xed', '\x94', '\x99'}, 3, 0xD519}, /* (HANGUL SYLLABLE PEUNG) */
    {{'\xed', '\x94', '\x9a'}, 3, 0xD51A}, /* (HANGUL SYLLABLE PEUJ) */
    {{'\xed', '\x94', '\x9b'}, 3, 0xD51B}, /* (HANGUL SYLLABLE PEUC) */
    {{'\xed', '\x94', '\x9c'}, 3, 0xD51C}, /* (HANGUL SYLLABLE PEUK) */
    {{'\xed', '\x94', '\x9d'}, 3, 0xD51D}, /* (HANGUL SYLLABLE PEUT) */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{'\xed', '\x94', '\x9e'}, 3, 0xD51E}, /* (HANGUL SYLLABLE PEUP) */
    {{'\xed', '\x94', '\x9f'}, 3, 0xD51F}, /* (HANGUL SYLLABLE PEUH) */
    {{'\xed', '\x94', '\xa0'}, 3, 0xD520}, /* (HANGUL SYLLABLE PYI) */
    {{'\xed', '\x94', '\xa1'}, 3, 0xD521}, /* (HANGUL SYLLABLE PYIG) */
    {{'\xed', '\x94', '\xa2'}, 3, 0xD522}, /* (HANGUL SYLLABLE PYIGG) */
    {{'\xed', '\x94', '\xa3'}, 3, 0xD523}, /* (HANGUL SYLLABLE PYIGS) */
    {{'\xed', '\x94', '\xa4'}, 3, 0xD524}, /* (HANGUL SYLLABLE PYIN) */
    {{'\xed', '\x94', '\xa5'}, 3, 0xD525}, /* (HANGUL SYLLABLE PYINJ) */
    {{'\xed', '\x94', '\xa6'}, 3, 0xD526}, /* (HANGUL SYLLABLE PYINH) */
    {{'\xed', '\x94', '\xa7'}, 3, 0xD527}, /* (HANGUL SYLLABLE PYID) */
    {{'\xed', '\x94', '\xa8'}, 3, 0xD528}, /* (HANGUL SYLLABLE PYIL) */
    {{'\xed', '\x94', '\xa9'}, 3, 0xD529}, /* (HANGUL SYLLABLE PYILG) */
    {{'\xed', '\x94', '\xaa'}, 3, 0xD52A}, /* (HANGUL SYLLABLE PYILM) */
    {{'\xed', '\x94', '\xab'}, 3, 0xD52B}, /* (HANGUL SYLLABLE PYILB) */
    {{'\xed', '\x94', '\xac'}, 3, 0xD52C}, /* (HANGUL SYLLABLE PYILS) */
    {{'\xed', '\x94', '\xad'}, 3, 0xD52D}, /* (HANGUL SYLLABLE PYILT) */
    {{'\xed', '\x94', '\xae'}, 3, 0xD52E}, /* (HANGUL SYLLABLE PYILP) */
    {{'\xed', '\x94', '\xaf'}, 3, 0xD52F}, /* (HANGUL SYLLABLE PYILH) */
    {{'\xed', '\x94', '\xb0'}, 3, 0xD530}, /* (HANGUL SYLLABLE PYIM) */
    {{'\xed', '\x94', '\xb1'}, 3, 0xD531}, /* (HANGUL SYLLABLE PYIB) */
    {{'\xed', '\x94', '\xb2'}, 3, 0xD532}, /* (HANGUL SYLLABLE PYIBS) */
    {{'\xed', '\x94', '\xb3'}, 3, 0xD533}, /* (HANGUL SYLLABLE PYIS) */
    {{'\xed', '\x94', '\xb4'}, 3, 0xD534}, /* (HANGUL SYLLABLE PYISS) */
    {{'\xed', '\x94', '\xb5'}, 3, 0xD535}, /* (HANGUL SYLLABLE PYING) */
    {{'\xed', '\x94', '\xb6'}, 3, 0xD536}, /* (HANGUL SYLLABLE PYIJ) */
    {{'\xed', '\x94', '\xb7'}, 3, 0xD537}, /* (HANGUL SYLLABLE PYIC) */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{'\xed', '\x94', '\xb8'}, 3, 0xD538}, /* (HANGUL SYLLABLE PYIK) */
    {{'\xed', '\x94', '\xb9'}, 3, 0xD539}, /* (HANGUL SYLLABLE PYIT) */
    {{'\xed', '\x94', '\xba'}, 3, 0xD53A}, /* (HANGUL SYLLABLE PYIP) */
    {{'\xed', '\x94', '\xbb'}, 3, 0xD53B}, /* (HANGUL SYLLABLE PYIH) */
    {{'\xed', '\x94', '\xbe'}, 3, 0xD53E}, /* (HANGUL SYLLABLE PIGG) */
    {{'\xed', '\x94', '\xbf'}, 3, 0xD53F}, /* (HANGUL SYLLABLE PIGS) */
    {{'\xed', '\x95', '\x81'}, 3, 0xD541}, /* (HANGUL SYLLABLE PINJ) */
    {{'\xed', '\x95', '\x82'}, 3, 0xD542}, /* (HANGUL SYLLABLE PINH) */
    {{'\xed', '\x95', '\x83'}, 3, 0xD543}, /* (HANGUL SYLLABLE PID) */
    {{'\xed', '\x95', '\x85'}, 3, 0xD545}, /* (HANGUL SYLLABLE PILG) */
    {{'\xed', '\x95', '\x86'}, 3, 0xD546}, /* (HANGUL SYLLABLE PILM) */
    {{'\xed', '\x95', '\x87'}, 3, 0xD547}, /* (HANGUL SYLLABLE PILB) */
    {{'\xed', '\x95', '\x88'}, 3, 0xD548}, /* (HANGUL SYLLABLE PILS) */
    {{'\xed', '\x95', '\x89'}, 3, 0xD549}, /* (HANGUL SYLLABLE PILT) */
    {{'\xed', '\x95', '\x8a'}, 3, 0xD54A}, /* (HANGUL SYLLABLE PILP) */
    {{'\xed', '\x95', '\x8b'}, 3, 0xD54B}, /* (HANGUL SYLLABLE PILH) */
    {{'\xed', '\x95', '\x8e'}, 3, 0xD54E}, /* (HANGUL SYLLABLE PIBS) */
    {{'\xed', '\x95', '\x90'}, 3, 0xD550}, /* (HANGUL SYLLABLE PISS) */
    {{'\xed', '\x95', '\x92'}, 3, 0xD552}, /* (HANGUL SYLLABLE PIJ) */
    {{'\xed', '\x95', '\x93'}, 3, 0xD553}, /* (HANGUL SYLLABLE PIC) */
    {{'\xed', '\x95', '\x94'}, 3, 0xD554}, /* (HANGUL SYLLABLE PIK) */
    {{'\xed', '\x95', '\x95'}, 3, 0xD555}, /* (HANGUL SYLLABLE PIT) */
    {{'\xed', '\x95', '\x96'}, 3, 0xD556}, /* (HANGUL SYLLABLE PIP) */
    {{'\xed', '\x95', '\x97'}, 3, 0xD557}, /* (HANGUL SYLLABLE PIH) */
    {{'\xed', '\x95', '\x9a'}, 3, 0xD55A}, /* (HANGUL SYLLABLE HAGG) */
    {{'\xed', '\x95', '\x9b'}, 3, 0xD55B}, /* (HANGUL SYLLABLE HAGS) */
    {{'\xed', '\x95', '\x9d'}, 3, 0xD55D}, /* (HANGUL SYLLABLE HANJ) */
    {{'\xed', '\x95', '\x9e'}, 3, 0xD55E}, /* (HANGUL SYLLABLE HANH) */
    {{'\xed', '\x95', '\x9f'}, 3, 0xD55F}, /* (HANGUL SYLLABLE HAD) */
    {{'\xed', '\x95', '\xa1'}, 3, 0xD561}, /* (HANGUL SYLLABLE HALG) */
    {{'\xed', '\x95', '\xa2'}, 3, 0xD562}, /* (HANGUL SYLLABLE HALM) */
    {{'\xed', '\x95', '\xa3'}, 3, 0xD563}, /* (HANGUL SYLLABLE HALB) */
    {{'\xec', '\x9b', '\xa9'}, 3, 0xC6E9}, /* (HANGUL SYLLABLE WEG) */
    {{'\xec', '\x9b', '\xac'}, 3, 0xC6EC}, /* (HANGUL SYLLABLE WEN) */
    {{'\xec', '\x9b', '\xb0'}, 3, 0xC6F0}, /* (HANGUL SYLLABLE WEL) */
    {{'\xec', '\x9b', '\xb8'}, 3, 0xC6F8}, /* (HANGUL SYLLABLE WEM) */
    {{'\xec', '\x9b', '\xb9'}, 3, 0xC6F9}, /* (HANGUL SYLLABLE WEB) */
    {{'\xec', '\x9b', '\xbd'}, 3, 0xC6FD}, /* (HANGUL SYLLABLE WENG) */
    {{'\xec', '\x9c', '\x84'}, 3, 0xC704}, /* (HANGUL SYLLABLE WI) */
    {{'\xec', '\x9c', '\x85'}, 3, 0xC705}, /* (HANGUL SYLLABLE WIG) */
    {{'\xec', '\x9c', '\x88'}, 3, 0xC708}, /* (HANGUL SYLLABLE WIN) */
    {{'\xec', '\x9c', '\x8c'}, 3, 0xC70C}, /* (HANGUL SYLLABLE WIL) */
    {{'\xec', '\x9c', '\x94'}, 3, 0xC714}, /* (HANGUL SYLLABLE WIM) */
    {{'\xec', '\x9c', '\x95'}, 3, 0xC715}, /* (HANGUL SYLLABLE WIB) */
    {{'\xec', '\x9c', '\x97'}, 3, 0xC717}, /* (HANGUL SYLLABLE WIS) */
    {{'\xec', '\x9c', '\x99'}, 3, 0xC719}, /* (HANGUL SYLLABLE WING) */
    {{'\xec', '\x9c', '\xa0'}, 3, 0xC720}, /* (HANGUL SYLLABLE YU) */
    {{'\xec', '\x9c', '\xa1'}, 3, 0xC721}, /* (HANGUL SYLLABLE YUG) */
    {{'\xec', '\x9c', '\xa4'}, 3, 0xC724}, /* (HANGUL SYLLABLE YUN) */
    {{'\xec', '\x9c', '\xa8'}, 3, 0xC728}, /* (HANGUL SYLLABLE YUL) */
    {{'\xec', '\x9c', '\xb0'}, 3, 0xC730}, /* (HANGUL SYLLABLE YUM) */
    {{'\xec', '\x9c', '\xb1'}, 3, 0xC731}, /* (HANGUL SYLLABLE YUB) */
    {{'\xec', '\x9c', '\xb3'}, 3, 0xC733}, /* (HANGUL SYLLABLE YUS) */
    {{'\xec', '\x9c', '\xb5'}, 3, 0xC735}, /* (HANGUL SYLLABLE YUNG) */
    {{'\xec', '\x9c', '\xb7'}, 3, 0xC737}, /* (HANGUL SYLLABLE YUC) */
    {{'\xec', '\x9c', '\xbc'}, 3, 0xC73C}, /* (HANGUL SYLLABLE EU) */
    {{'\xec', '\x9c', '\xbd'}, 3, 0xC73D}, /* (HANGUL SYLLABLE EUG) */
    {{'\xec', '\x9d', '\x80'}, 3, 0xC740}, /* (HANGUL SYLLABLE EUN) */
    {{'\xec', '\x9d', '\x84'}, 3, 0xC744}, /* (HANGUL SYLLABLE EUL) */
    {{'\xec', '\x9d', '\x8a'}, 3, 0xC74A}, /* (HANGUL SYLLABLE EULP) */
    {{'\xec', '\x9d', '\x8c'}, 3, 0xC74C}, /* (HANGUL SYLLABLE EUM) */
    {{'\xec', '\x9d', '\x8d'}, 3, 0xC74D}, /* (HANGUL SYLLABLE EUB) */
    {{'\xec', '\x9d', '\x8f'}, 3, 0xC74F}, /* (HANGUL SYLLABLE EUS) */
    {{'\xec', '\x9d', '\x91'}, 3, 0xC751}, /* (HANGUL SYLLABLE EUNG) */
    {{'\xec', '\x9d', '\x92'}, 3, 0xC752}, /* (HANGUL SYLLABLE EUJ) */
    {{'\xec', '\x9d', '\x93'}, 3, 0xC753}, /* (HANGUL SYLLABLE EUC) */
    {{'\xec', '\x9d', '\x94'}, 3, 0xC754}, /* (HANGUL SYLLABLE EUK) */
    {{'\xec', '\x9d', '\x95'}, 3, 0xC755}, /* (HANGUL SYLLABLE EUT) */
    {{'\xec', '\x9d', '\x96'}, 3, 0xC756}, /* (HANGUL SYLLABLE EUP) */
    {{'\xec', '\x9d', '\x97'}, 3, 0xC757}, /* (HANGUL SYLLABLE EUH) */
    {{'\xec', '\x9d', '\x98'}, 3, 0xC758}, /* (HANGUL SYLLABLE YI) */
    {{'\xec', '\x9d', '\x9c'}, 3, 0xC75C}, /* (HANGUL SYLLABLE YIN) */
    {{'\xec', '\x9d', '\xa0'}, 3, 0xC760}, /* (HANGUL SYLLABLE YIL) */
    {{'\xec', '\x9d', '\xa8'}, 3, 0xC768}, /* (HANGUL SYLLABLE YIM) */
    {{'\xec', '\x9d', '\xab'}, 3, 0xC76B}, /* (HANGUL SYLLABLE YIS) */
    {{'\xec', '\x9d', '\xb4'}, 3, 0xC774}, /* (HANGUL SYLLABLE I) */
    {{'\xec', '\x9d', '\xb5'}, 3, 0xC775}, /* (HANGUL SYLLABLE IG) */
    {{'\xec', '\x9d', '\xb8'}, 3, 0xC778}, /* (HANGUL SYLLABLE IN) */
    {{'\xec', '\x9d', '\xbc'}, 3, 0xC77C}, /* (HANGUL SYLLABLE IL) */
    {{'\xec', '\x9d', '\xbd'}, 3, 0xC77D}, /* (HANGUL SYLLABLE ILG) */
    {{'\xec', '\x9d', '\xbe'}, 3, 0xC77E}, /* (HANGUL SYLLABLE ILM) */
    {{'\xec', '\x9e', '\x83'}, 3, 0xC783}, /* (HANGUL SYLLABLE ILH) */
    {{'\xec', '\x9e', '\x84'}, 3, 0xC784}, /* (HANGUL SYLLABLE IM) */
    {{'\xec', '\x9e', '\x85'}, 3, 0xC785}, /* (HANGUL SYLLABLE IB) */
    {{'\xec', '\x9e', '\x87'}, 3, 0xC787}, /* (HANGUL SYLLABLE IS) */
    {{'\xec', '\x9e', '\x88'}, 3, 0xC788}, /* (HANGUL SYLLABLE ISS) */
    {{'\xec', '\x9e', '\x89'}, 3, 0xC789}, /* (HANGUL SYLLABLE ING) */
    {{'\xec', '\x9e', '\x8a'}, 3, 0xC78A}, /* (HANGUL SYLLABLE IJ) */
    {{'\xec', '\x9e', '\x8e'}, 3, 0xC78E}, /* (HANGUL SYLLABLE IP) */
    {{'\xec', '\x9e', '\x90'}, 3, 0xC790}, /* (HANGUL SYLLABLE JA) */
    {{'\xec', '\x9e', '\x91'}, 3, 0xC791}, /* (HANGUL SYLLABLE JAG) */
    {{'\xec', '\x9e', '\x94'}, 3, 0xC794}, /* (HANGUL SYLLABLE JAN) */
    {{'\xec', '\x9e', '\x96'}, 3, 0xC796}, /* (HANGUL SYLLABLE JANH) */
    {{'\xec', '\x9e', '\x97'}, 3, 0xC797}, /* (HANGUL SYLLABLE JAD) */
    {{'\xec', '\x9e', '\x98'}, 3, 0xC798}, /* (HANGUL SYLLABLE JAL) */
    {{'\xec', '\x9e', '\x9a'}, 3, 0xC79A}, /* (HANGUL SYLLABLE JALM) */
    {{'\xec', '\x9e', '\xa0'}, 3, 0xC7A0}, /* (HANGUL SYLLABLE JAM) */
    {{'\xec', '\x9e', '\xa1'}, 3, 0xC7A1}, /* (HANGUL SYLLABLE JAB) */
    {{'\xec', '\x9e', '\xa3'}, 3, 0xC7A3}, /* (HANGUL SYLLABLE JAS) */
    {{'\xec', '\x9e', '\xa4'}, 3, 0xC7A4}, /* (HANGUL SYLLABLE JASS) */
    {{'\xec', '\x9e', '\xa5'}, 3, 0xC7A5}, /* (HANGUL SYLLABLE JANG) */
    {{'\xec', '\x9e', '\xa6'}, 3, 0xC7A6}, /* (HANGUL SYLLABLE JAJ) */
    {{'\xec', '\x9e', '\xac'}, 3, 0xC7AC}, /* (HANGUL SYLLABLE JAE) */
    {{'\xec', '\x9e', '\xad'}, 3, 0xC7AD}, /* (HANGUL SYLLABLE JAEG) */
    {{'\xec', '\x9e', '\xb0'}, 3, 0xC7B0}, /* (HANGUL SYLLABLE JAEN) */
    {{'\xec', '\x9e', '\xb4'}, 3, 0xC7B4}, /* (HANGUL SYLLABLE JAEL) */
    {{'\xec', '\x9e', '\xbc'}, 3, 0xC7BC}, /* (HANGUL SYLLABLE JAEM) */
    {{'\xec', '\x9e', '\xbd'}, 3, 0xC7BD}, /* (HANGUL SYLLABLE JAEB) */
    {{'\xec', '\x9e', '\xbf'}, 3, 0xC7BF}, /* (HANGUL SYLLABLE JAES) */
    {{'\xec', '\x9f', '\x80'}, 3, 0xC7C0}, /* (HANGUL SYLLABLE JAESS) */
    {{'\xec', '\x9f', '\x81'}, 3, 0xC7C1}, /* (HANGUL SYLLABLE JAENG) */
    {{'\xec', '\x9f', '\x88'}, 3, 0xC7C8}, /* (HANGUL SYLLABLE JYA) */
    {{'\xec', '\x9f', '\x89'}, 3, 0xC7C9}, /* (HANGUL SYLLABLE JYAG) */
    {{'\xec', '\x9f', '\x8c'}, 3, 0xC7CC}, /* (HANGUL SYLLABLE JYAN) */
    {{'\xec', '\x9f', '\x8e'}, 3, 0xC7CE}, /* (HANGUL SYLLABLE JYANH) */
    {{'\xec', '\x9f', '\x90'}, 3, 0xC7D0}, /* (HANGUL SYLLABLE JYAL) */
    {{'\xec', '\x9f', '\x98'}, 3, 0xC7D8}, /* (HANGUL SYLLABLE JYAM) */
    {{'\xec', '\x9f', '\x9d'}, 3, 0xC7DD}, /* (HANGUL SYLLABLE JYANG) */
    {{'\xec', '\x9f', '\xa4'}, 3, 0xC7E4}, /* (HANGUL SYLLABLE JYAE) */
    {{'\xec', '\x9f', '\xa8'}, 3, 0xC7E8}, /* (HANGUL SYLLABLE JYAEN) */
    {{'\xec', '\x9f', '\xac'}, 3, 0xC7EC}, /* (HANGUL SYLLABLE JYAEL) */
    {{'\xec', '\xa0', '\x80'}, 3, 0xC800}, /* (HANGUL SYLLABLE JEO) */
    {{'\xec', '\xa0', '\x81'}, 3, 0xC801}, /* (HANGUL SYLLABLE JEOG) */
    {{'\xec', '\xa0', '\x84'}, 3, 0xC804}, /* (HANGUL SYLLABLE JEON) */
    {{'\xec', '\xa0', '\x88'}, 3, 0xC808}, /* (HANGUL SYLLABLE JEOL) */
    {{'\xec', '\xa0', '\x8a'}, 3, 0xC80A}, /* (HANGUL SYLLABLE JEOLM) */
    {{'\xed', '\x95', '\xa4'}, 3, 0xD564}, /* (HANGUL SYLLABLE HALS) */
    {{'\xed', '\x95', '\xa6'}, 3, 0xD566}, /* (HANGUL SYLLABLE HALP) */
    {{'\xed', '\x95', '\xa7'}, 3, 0xD567}, /* (HANGUL SYLLABLE HALH) */
    {{'\xed', '\x95', '\xaa'}, 3, 0xD56A}, /* (HANGUL SYLLABLE HABS) */
    {{'\xed', '\x95', '\xac'}, 3, 0xD56C}, /* (HANGUL SYLLABLE HASS) */
    {{'\xed', '\x95', '\xae'}, 3, 0xD56E}, /* (HANGUL SYLLABLE HAJ) */
    {{'\xed', '\x95', '\xaf'}, 3, 0xD56F}, /* (HANGUL SYLLABLE HAC) */
    {{'\xed', '\x95', '\xb0'}, 3, 0xD570}, /* (HANGUL SYLLABLE HAK) */
    {{'\xed', '\x95', '\xb1'}, 3, 0xD571}, /* (HANGUL SYLLABLE HAT) */
    {{'\xed', '\x95', '\xb2'}, 3, 0xD572}, /* (HANGUL SYLLABLE HAP) */
    {{'\xed', '\x95', '\xb3'}, 3, 0xD573}, /* (HANGUL SYLLABLE HAH) */
    {{'\xed', '\x95', '\xb6'}, 3, 0xD576}, /* (HANGUL SYLLABLE HAEGG) */
    {{'\xed', '\x95', '\xb7'}, 3, 0xD577}, /* (HANGUL SYLLABLE HAEGS) */
    {{'\xed', '\x95', '\xb9'}, 3, 0xD579}, /* (HANGUL SYLLABLE HAENJ) */
    {{'\xed', '\x95', '\xba'}, 3, 0xD57A}, /* (HANGUL SYLLABLE HAENH) */
    {{'\xed', '\x95', '\xbb'}, 3, 0xD57B}, /* (HANGUL SYLLABLE HAED) */
    {{'\xed', '\x95', '\xbd'}, 3, 0xD57D}, /* (HANGUL SYLLABLE HAELG) */
    {{'\xed', '\x95', '\xbe'}, 3, 0xD57E}, /* (HANGUL SYLLABLE HAELM) */
    {{'\xed', '\x95', '\xbf'}, 3, 0xD57F}, /* (HANGUL SYLLABLE HAELB) */
    {{'\xed', '\x96', '\x80'}, 3, 0xD580}, /* (HANGUL SYLLABLE HAELS) */
    {{'\xed', '\x96', '\x81'}, 3, 0xD581}, /* (HANGUL SYLLABLE HAELT) */
    {{'\xed', '\x96', '\x82'}, 3, 0xD582}, /* (HANGUL SYLLABLE HAELP) */
    {{'\xed', '\x96', '\x83'}, 3, 0xD583}, /* (HANGUL SYLLABLE HAELH) */
    {{'\xed', '\x96', '\x86'}, 3, 0xD586}, /* (HANGUL SYLLABLE HAEBS) */
    {{'\xed', '\x96', '\x8a'}, 3, 0xD58A}, /* (HANGUL SYLLABLE HAEJ) */
    {{'\xed', '\x96', '\x8b'}, 3, 0xD58B}, /* (HANGUL SYLLABLE HAEC) */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{'\xed', '\x96', '\x8c'}, 3, 0xD58C}, /* (HANGUL SYLLABLE HAEK) */
    {{'\xed', '\x96', '\x8d'}, 3, 0xD58D}, /* (HANGUL SYLLABLE HAET) */
    {{'\xed', '\x96', '\x8e'}, 3, 0xD58E}, /* (HANGUL SYLLABLE HAEP) */
    {{'\xed', '\x96', '\x8f'}, 3, 0xD58F}, /* (HANGUL SYLLABLE HAEH) */
    {{'\xed', '\x96', '\x91'}, 3, 0xD591}, /* (HANGUL SYLLABLE HYAG) */
    {{'\xed', '\x96', '\x92'}, 3, 0xD592}, /* (HANGUL SYLLABLE HYAGG) */
    {{'\xed', '\x96', '\x93'}, 3, 0xD593}, /* (HANGUL SYLLABLE HYAGS) */
    {{'\xed', '\x96', '\x94'}, 3, 0xD594}, /* (HANGUL SYLLABLE HYAN) */
    {{'\xed', '\x96', '\x95'}, 3, 0xD595}, /* (HANGUL SYLLABLE HYANJ) */
    {{'\xed', '\x96', '\x96'}, 3, 0xD596}, /* (HANGUL SYLLABLE HYANH) */
    {{'\xed', '\x96', '\x97'}, 3, 0xD597}, /* (HANGUL SYLLABLE HYAD) */
    {{'\xed', '\x96', '\x98'}, 3, 0xD598}, /* (HANGUL SYLLABLE HYAL) */
    {{'\xed', '\x96', '\x99'}, 3, 0xD599}, /* (HANGUL SYLLABLE HYALG) */
    {{'\xed', '\x96', '\x9a'}, 3, 0xD59A}, /* (HANGUL SYLLABLE HYALM) */
    {{'\xed', '\x96', '\x9b'}, 3, 0xD59B}, /* (HANGUL SYLLABLE HYALB) */
    {{'\xed', '\x96', '\x9c'}, 3, 0xD59C}, /* (HANGUL SYLLABLE HYALS) */
    {{'\xed', '\x96', '\x9d'}, 3, 0xD59D}, /* (HANGUL SYLLABLE HYALT) */
    {{'\xed', '\x96', '\x9e'}, 3, 0xD59E}, /* (HANGUL SYLLABLE HYALP) */
    {{'\xed', '\x96', '\x9f'}, 3, 0xD59F}, /* (HANGUL SYLLABLE HYALH) */
    {{'\xed', '\x96', '\xa0'}, 3, 0xD5A0}, /* (HANGUL SYLLABLE HYAM) */
    {{'\xed', '\x96', '\xa1'}, 3, 0xD5A1}, /* (HANGUL SYLLABLE HYAB) */
    {{'\xed', '\x96', '\xa2'}, 3, 0xD5A2}, /* (HANGUL SYLLABLE HYABS) */
    {{'\xed', '\x96', '\xa3'}, 3, 0xD5A3}, /* (HANGUL SYLLABLE HYAS) */
    {{'\xed', '\x96', '\xa4'}, 3, 0xD5A4}, /* (HANGUL SYLLABLE HYASS) */
    {{'\xed', '\x96', '\xa6'}, 3, 0xD5A6}, /* (HANGUL SYLLABLE HYAJ) */
    {{'\xed', '\x96', '\xa7'}, 3, 0xD5A7}, /* (HANGUL SYLLABLE HYAC) */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{'\xed', '\x96', '\xa8'}, 3, 0xD5A8}, /* (HANGUL SYLLABLE HYAK) */
    {{'\xed', '\x96', '\xa9'}, 3, 0xD5A9}, /* (HANGUL SYLLABLE HYAT) */
    {{'\xed', '\x96', '\xaa'}, 3, 0xD5AA}, /* (HANGUL SYLLABLE HYAP) */
    {{'\xed', '\x96', '\xab'}, 3, 0xD5AB}, /* (HANGUL SYLLABLE HYAH) */
    {{'\xed', '\x96', '\xac'}, 3, 0xD5AC}, /* (HANGUL SYLLABLE HYAE) */
    {{'\xed', '\x96', '\xad'}, 3, 0xD5AD}, /* (HANGUL SYLLABLE HYAEG) */
    {{'\xed', '\x96', '\xae'}, 3, 0xD5AE}, /* (HANGUL SYLLABLE HYAEGG) */
    {{'\xed', '\x96', '\xaf'}, 3, 0xD5AF}, /* (HANGUL SYLLABLE HYAEGS) */
    {{'\xed', '\x96', '\xb0'}, 3, 0xD5B0}, /* (HANGUL SYLLABLE HYAEN) */
    {{'\xed', '\x96', '\xb1'}, 3, 0xD5B1}, /* (HANGUL SYLLABLE HYAENJ) */
    {{'\xed', '\x96', '\xb2'}, 3, 0xD5B2}, /* (HANGUL SYLLABLE HYAENH) */
    {{'\xed', '\x96', '\xb3'}, 3, 0xD5B3}, /* (HANGUL SYLLABLE HYAED) */
    {{'\xed', '\x96', '\xb4'}, 3, 0xD5B4}, /* (HANGUL SYLLABLE HYAEL) */
    {{'\xed', '\x96', '\xb5'}, 3, 0xD5B5}, /* (HANGUL SYLLABLE HYAELG) */
    {{'\xed', '\x96', '\xb6'}, 3, 0xD5B6}, /* (HANGUL SYLLABLE HYAELM) */
    {{'\xed', '\x96', '\xb7'}, 3, 0xD5B7}, /* (HANGUL SYLLABLE HYAELB) */
    {{'\xed', '\x96', '\xb8'}, 3, 0xD5B8}, /* (HANGUL SYLLABLE HYAELS) */
    {{'\xed', '\x96', '\xb9'}, 3, 0xD5B9}, /* (HANGUL SYLLABLE HYAELT) */
    {{'\xed', '\x96', '\xba'}, 3, 0xD5BA}, /* (HANGUL SYLLABLE HYAELP) */
    {{'\xed', '\x96', '\xbb'}, 3, 0xD5BB}, /* (HANGUL SYLLABLE HYAELH) */
    {{'\xed', '\x96', '\xbc'}, 3, 0xD5BC}, /* (HANGUL SYLLABLE HYAEM) */
    {{'\xed', '\x96', '\xbd'}, 3, 0xD5BD}, /* (HANGUL SYLLABLE HYAEB) */
    {{'\xed', '\x96', '\xbe'}, 3, 0xD5BE}, /* (HANGUL SYLLABLE HYAEBS) */
    {{'\xed', '\x96', '\xbf'}, 3, 0xD5BF}, /* (HANGUL SYLLABLE HYAES) */
    {{'\xed', '\x97', '\x80'}, 3, 0xD5C0}, /* (HANGUL SYLLABLE HYAESS) */
    {{'\xed', '\x97', '\x81'}, 3, 0xD5C1}, /* (HANGUL SYLLABLE HYAENG) */
    {{'\xed', '\x97', '\x82'}, 3, 0xD5C2}, /* (HANGUL SYLLABLE HYAEJ) */
    {{'\xed', '\x97', '\x83'}, 3, 0xD5C3}, /* (HANGUL SYLLABLE HYAEC) */
    {{'\xed', '\x97', '\x84'}, 3, 0xD5C4}, /* (HANGUL SYLLABLE HYAEK) */
    {{'\xed', '\x97', '\x85'}, 3, 0xD5C5}, /* (HANGUL SYLLABLE HYAET) */
    {{'\xed', '\x97', '\x86'}, 3, 0xD5C6}, /* (HANGUL SYLLABLE HYAEP) */
    {{'\xed', '\x97', '\x87'}, 3, 0xD5C7}, /* (HANGUL SYLLABLE HYAEH) */
    {{'\xec', '\xa0', '\x90'}, 3, 0xC810}, /* (HANGUL SYLLABLE JEOM) */
    {{'\xec', '\xa0', '\x91'}, 3, 0xC811}, /* (HANGUL SYLLABLE JEOB) */
    {{'\xec', '\xa0', '\x93'}, 3, 0xC813}, /* (HANGUL SYLLABLE JEOS) */
    {{'\xec', '\xa0', '\x95'}, 3, 0xC815}, /* (HANGUL SYLLABLE JEONG) */
    {{'\xec', '\xa0', '\x96'}, 3, 0xC816}, /* (HANGUL SYLLABLE JEOJ) */
    {{'\xec', '\xa0', '\x9c'}, 3, 0xC81C}, /* (HANGUL SYLLABLE JE) */
    {{'\xec', '\xa0', '\x9d'}, 3, 0xC81D}, /* (HANGUL SYLLABLE JEG) */
    {{'\xec', '\xa0', '\xa0'}, 3, 0xC820}, /* (HANGUL SYLLABLE JEN) */
    {{'\xec', '\xa0', '\xa4'}, 3, 0xC824}, /* (HANGUL SYLLABLE JEL) */
    {{'\xec', '\xa0', '\xac'}, 3, 0xC82C}, /* (HANGUL SYLLABLE JEM) */
    {{'\xec', '\xa0', '\xad'}, 3, 0xC82D}, /* (HANGUL SYLLABLE JEB) */
    {{'\xec', '\xa0', '\xaf'}, 3, 0xC82F}, /* (HANGUL SYLLABLE JES) */
    {{'\xec', '\xa0', '\xb1'}, 3, 0xC831}, /* (HANGUL SYLLABLE JENG) */
    {{'\xec', '\xa0', '\xb8'}, 3, 0xC838}, /* (HANGUL SYLLABLE JYEO) */
    {{'\xec', '\xa0', '\xbc'}, 3, 0xC83C}, /* (HANGUL SYLLABLE JYEON) */
    {{'\xec', '\xa1', '\x80'}, 3, 0xC840}, /* (HANGUL SYLLABLE JYEOL) */
    {{'\xec', '\xa1', '\x88'}, 3, 0xC848}, /* (HANGUL SYLLABLE JYEOM) */
    {{'\xec', '\xa1', '\x89'}, 3, 0xC849}, /* (HANGUL SYLLABLE JYEOB) */
    {{'\xec', '\xa1', '\x8c'}, 3, 0xC84C}, /* (HANGUL SYLLABLE JYEOSS) */
    {{'\xec', '\xa1', '\x8d'}, 3, 0xC84D}, /* (HANGUL SYLLABLE JYEONG) */
    {{'\xec', '\xa1', '\x94'}, 3, 0xC854}, /* (HANGUL SYLLABLE JYE) */
    {{'\xec', '\xa1', '\xb0'}, 3, 0xC870}, /* (HANGUL SYLLABLE JO) */
    {{'\xec', '\xa1', '\xb1'}, 3, 0xC871}, /* (HANGUL SYLLABLE JOG) */
    {{'\xec', '\xa1', '\xb4'}, 3, 0xC874}, /* (HANGUL SYLLABLE JON) */
    {{'\xec', '\xa1', '\xb8'}, 3, 0xC878}, /* (HANGUL SYLLABLE JOL) */
    {{'\xec', '\xa1', '\xba'}, 3, 0xC87A}, /* (HANGUL SYLLABLE JOLM) */
    {{'\xec', '\xa2', '\x80'}, 3, 0xC880}, /* (HANGUL SYLLABLE JOM) */
    {{'\xec', '\xa2', '\x81'}, 3, 0xC881}, /* (HANGUL SYLLABLE JOB) */
    {{'\xec', '\xa2', '\x83'}, 3, 0xC883}, /* (HANGUL SYLLABLE JOS) */
    {{'\xec', '\xa2', '\x85'}, 3, 0xC885}, /* (HANGUL SYLLABLE JONG) */
    {{'\xec', '\xa2', '\x86'}, 3, 0xC886}, /* (HANGUL SYLLABLE JOJ) */
    {{'\xec', '\xa2', '\x87'}, 3, 0xC887}, /* (HANGUL SYLLABLE JOC) */
    {{'\xec', '\xa2', '\x8b'}, 3, 0xC88B}, /* (HANGUL SYLLABLE JOH) */
    {{'\xec', '\xa2', '\x8c'}, 3, 0xC88C}, /* (HANGUL SYLLABLE JWA) */
    {{'\xec', '\xa2', '\x8d'}, 3, 0xC88D}, /* (HANGUL SYLLABLE JWAG) */
    {{'\xec', '\xa2', '\x94'}, 3, 0xC894}, /* (HANGUL SYLLABLE JWAL) */
    {{'\xec', '\xa2', '\x9d'}, 3, 0xC89D}, /* (HANGUL SYLLABLE JWAB) */
    {{'\xec', '\xa2', '\x9f'}, 3, 0xC89F}, /* (HANGUL SYLLABLE JWAS) */
    {{'\xec', '\xa2', '\xa1'}, 3, 0xC8A1}, /* (HANGUL SYLLABLE JWANG) */
    {{'\xec', '\xa2', '\xa8'}, 3, 0xC8A8}, /* (HANGUL SYLLABLE JWAE) */
    {{'\xec', '\xa2', '\xbc'}, 3, 0xC8BC}, /* (HANGUL SYLLABLE JWAESS) */
    {{'\xec', '\xa2', '\xbd'}, 3, 0xC8BD}, /* (HANGUL SYLLABLE JWAENG) */
    {{'\xec', '\xa3', '\x84'}, 3, 0xC8C4}, /* (HANGUL SYLLABLE JOE) */
    {{'\xec', '\xa3', '\x88'}, 3, 0xC8C8}, /* (HANGUL SYLLABLE JOEN) */
    {{'\xec', '\xa3', '\x8c'}, 3, 0xC8CC}, /* (HANGUL SYLLABLE JOEL) */
    {{'\xec', '\xa3', '\x94'}, 3, 0xC8D4}, /* (HANGUL SYLLABLE JOEM) */
    {{'\xec', '\xa3', '\x95'}, 3, 0xC8D5}, /* (HANGUL SYLLABLE JOEB) */
    {{'\xec', '\xa3', '\x97'}, 3, 0xC8D7}, /* (HANGUL SYLLABLE JOES) */
    {{'\xec', '\xa3', '\x99'}, 3, 0xC8D9}, /* (HANGUL SYLLABLE JOENG) */
    {{'\xec', '\xa3', '\xa0'}, 3, 0xC8E0}, /* (HANGUL SYLLABLE JYO) */
    {{'\xec', '\xa3', '\xa1'}, 3, 0xC8E1}, /* (HANGUL SYLLABLE JYOG) */
    {{'\xec', '\xa3', '\xa4'}, 3, 0xC8E4}, /* (HANGUL SYLLABLE JYON) */
    {{'\xec', '\xa3', '\xb5'}, 3, 0xC8F5}, /* (HANGUL SYLLABLE JYONG) */
    {{'\xec', '\xa3', '\xbc'}, 3, 0xC8FC}, /* (HANGUL SYLLABLE JU) */
    {{'\xec', '\xa3', '\xbd'}, 3, 0xC8FD}, /* (HANGUL SYLLABLE JUG) */
    {{'\xec', '\xa4', '\x80'}, 3, 0xC900}, /* (HANGUL SYLLABLE JUN) */
    {{'\xec', '\xa4', '\x84'}, 3, 0xC904}, /* (HANGUL SYLLABLE JUL) */
    {{'\xec', '\xa4', '\x85'}, 3, 0xC905}, /* (HANGUL SYLLABLE JULG) */
    {{'\xec', '\xa4', '\x86'}, 3, 0xC906}, /* (HANGUL SYLLABLE JULM) */
    {{'\xec', '\xa4', '\x8c'}, 3, 0xC90C}, /* (HANGUL SYLLABLE JUM) */
    {{'\xec', '\xa4', '\x8d'}, 3, 0xC90D}, /* (HANGUL SYLLABLE JUB) */
    {{'\xec', '\xa4', '\x8f'}, 3, 0xC90F}, /* (HANGUL SYLLABLE JUS) */
    {{'\xec', '\xa4', '\x91'}, 3, 0xC911}, /* (HANGUL SYLLABLE JUNG) */
    {{'\xec', '\xa4', '\x98'}, 3, 0xC918}, /* (HANGUL SYLLABLE JWEO) */
    {{'\xec', '\xa4', '\xac'}, 3, 0xC92C}, /* (HANGUL SYLLABLE JWEOSS) */
    {{'\xec', '\xa4', '\xb4'}, 3, 0xC934}, /* (HANGUL SYLLABLE JWE) */
    {{'\xec', '\xa5', '\x90'}, 3, 0xC950}, /* (HANGUL SYLLABLE JWI) */
    {{'\xec', '\xa5', '\x91'}, 3, 0xC951}, /* (HANGUL SYLLABLE JWIG) */
    {{'\xec', '\xa5', '\x94'}, 3, 0xC954}, /* (HANGUL SYLLABLE JWIN) */
    {{'\xec', '\xa5', '\x98'}, 3, 0xC958}, /* (HANGUL SYLLABLE JWIL) */
    {{'\xec', '\xa5', '\xa0'}, 3, 0xC960}, /* (HANGUL SYLLABLE JWIM) */
    {{'\xec', '\xa5', '\xa1'}, 3, 0xC961}, /* (HANGUL SYLLABLE JWIB) */
    {{'\xec', '\xa5', '\xa3'}, 3, 0xC963}, /* (HANGUL SYLLABLE JWIS) */
    {{'\xec', '\xa5', '\xac'}, 3, 0xC96C}, /* (HANGUL SYLLABLE JYU) */
    {{'\xec', '\xa5', '\xb0'}, 3, 0xC970}, /* (HANGUL SYLLABLE JYUN) */
    {{'\xec', '\xa5', '\xb4'}, 3, 0xC974}, /* (HANGUL SYLLABLE JYUL) */
    {{'\xec', '\xa5', '\xbc'}, 3, 0xC97C}, /* (HANGUL SYLLABLE JYUM) */
    {{'\xec', '\xa6', '\x88'}, 3, 0xC988}, /* (HANGUL SYLLABLE JEU) */
    {{'\xec', '\xa6', '\x89'}, 3, 0xC989}, /* (HANGUL SYLLABLE JEUG) */
    {{'\xec', '\xa6', '\x8c'}, 3, 0xC98C}, /* (HANGUL SYLLABLE JEUN) */
    {{'\xec', '\xa6', '\x90'}, 3, 0xC990}, /* (HANGUL SYLLABLE JEUL) */
    {{'\xec', '\xa6', '\x98'}, 3, 0xC998}, /* (HANGUL SYLLABLE JEUM) */
    {{'\xec', '\xa6', '\x99'}, 3, 0xC999}, /* (HANGUL SYLLABLE JEUB) */
    {{'\xec', '\xa6', '\x9b'}, 3, 0xC99B}, /* (HANGUL SYLLABLE JEUS) */
    {{'\xec', '\xa6', '\x9d'}, 3, 0xC99D}, /* (HANGUL SYLLABLE JEUNG) */
    {{'\xec', '\xa7', '\x80'}, 3, 0xC9C0}, /* (HANGUL SYLLABLE JI) */
    {{'\xec', '\xa7', '\x81'}, 3, 0xC9C1}, /* (HANGUL SYLLABLE JIG) */
    {{'\xec', '\xa7', '\x84'}, 3, 0xC9C4}, /* (HANGUL SYLLABLE JIN) */
    {{'\xec', '\xa7', '\x87'}, 3, 0xC9C7}, /* (HANGUL SYLLABLE JID) */
    {{'\xec', '\xa7', '\x88'}, 3, 0xC9C8}, /* (HANGUL SYLLABLE JIL) */
    {{'\xec', '\xa7', '\x8a'}, 3, 0xC9CA}, /* (HANGUL SYLLABLE JILM) */
    {{'\xec', '\xa7', '\x90'}, 3, 0xC9D0}, /* (HANGUL SYLLABLE JIM) */
    {{'\xec', '\xa7', '\x91'}, 3, 0xC9D1}, /* (HANGUL SYLLABLE JIB) */
    {{'\xec', '\xa7', '\x93'}, 3, 0xC9D3}, /* (HANGUL SYLLABLE JIS) */
    {{'\xed', '\x97', '\x8a'}, 3, 0xD5CA}, /* (HANGUL SYLLABLE HEOGG) */
    {{'\xed', '\x97', '\x8b'}, 3, 0xD5CB}, /* (HANGUL SYLLABLE HEOGS) */
    {{'\xed', '\x97', '\x8d'}, 3, 0xD5CD}, /* (HANGUL SYLLABLE HEONJ) */
    {{'\xed', '\x97', '\x8e'}, 3, 0xD5CE}, /* (HANGUL SYLLABLE HEONH) */
    {{'\xed', '\x97', '\x8f'}, 3, 0xD5CF}, /* (HANGUL SYLLABLE HEOD) */
    {{'\xed', '\x97', '\x91'}, 3, 0xD5D1}, /* (HANGUL SYLLABLE HEOLG) */
    {{'\xed', '\x97', '\x93'}, 3, 0xD5D3}, /* (HANGUL SYLLABLE HEOLB) */
    {{'\xed', '\x97', '\x94'}, 3, 0xD5D4}, /* (HANGUL SYLLABLE HEOLS) */
    {{'\xed', '\x97', '\x95'}, 3, 0xD5D5}, /* (HANGUL SYLLABLE HEOLT) */
    {{'\xed', '\x97', '\x96'}, 3, 0xD5D6}, /* (HANGUL SYLLABLE HEOLP) */
    {{'\xed', '\x97', '\x97'}, 3, 0xD5D7}, /* (HANGUL SYLLABLE HEOLH) */
    {{'\xed', '\x97', '\x9a'}, 3, 0xD5DA}, /* (HANGUL SYLLABLE HEOBS) */
    {{'\xed', '\x97', '\x9c'}, 3, 0xD5DC}, /* (HANGUL SYLLABLE HEOSS) */
    {{'\xed', '\x97', '\x9e'}, 3, 0xD5DE}, /* (HANGUL SYLLABLE HEOJ) */
    {{'\xed', '\x97', '\x9f'}, 3, 0xD5DF}, /* (HANGUL SYLLABLE HEOC) */
    {{'\xed', '\x97', '\xa0'}, 3, 0xD5E0}, /* (HANGUL SYLLABLE HEOK) */
    {{'\xed', '\x97', '\xa1'}, 3, 0xD5E1}, /* (HANGUL SYLLABLE HEOT) */
    {{'\xed', '\x97', '\xa2'}, 3, 0xD5E2}, /* (HANGUL SYLLABLE HEOP) */
    {{'\xed', '\x97', '\xa3'}, 3, 0xD5E3}, /* (HANGUL SYLLABLE HEOH) */
    {{'\xed', '\x97', '\xa6'}, 3, 0xD5E6}, /* (HANGUL SYLLABLE HEGG) */
    {{'\xed', '\x97', '\xa7'}, 3, 0xD5E7}, /* (HANGUL SYLLABLE HEGS) */
    {{'\xed', '\x97', '\xa9'}, 3, 0xD5E9}, /* (HANGUL SYLLABLE HENJ) */
    {{'\xed', '\x97', '\xaa'}, 3, 0xD5EA}, /* (HANGUL SYLLABLE HENH) */
    {{'\xed', '\x97', '\xab'}, 3, 0xD5EB}, /* (HANGUL SYLLABLE HED) */
    {{'\xed', '\x97', '\xad'}, 3, 0xD5ED}, /* (HANGUL SYLLABLE HELG) */
    {{'\xed', '\x97', '\xae'}, 3, 0xD5EE}, /* (HANGUL SYLLABLE HELM) */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{'\xed', '\x97', '\xaf'}, 3, 0xD5EF}, /* (HANGUL SYLLABLE HELB) */
    {{'\xed', '\x97', '\xb0'}, 3, 0xD5F0}, /* (HANGUL SYLLABLE HELS) */
    {{'\xed', '\x97', '\xb1'}, 3, 0xD5F1}, /* (HANGUL SYLLABLE HELT) */
    {{'\xed', '\x97', '\xb2'}, 3, 0xD5F2}, /* (HANGUL SYLLABLE HELP) */
    {{'\xed', '\x97', '\xb3'}, 3, 0xD5F3}, /* (HANGUL SYLLABLE HELH) */
    {{'\xed', '\x97', '\xb6'}, 3, 0xD5F6}, /* (HANGUL SYLLABLE HEBS) */
    {{'\xed', '\x97', '\xb8'}, 3, 0xD5F8}, /* (HANGUL SYLLABLE HESS) */
    {{'\xed', '\x97', '\xba'}, 3, 0xD5FA}, /* (HANGUL SYLLABLE HEJ) */
    {{'\xed', '\x97', '\xbb'}, 3, 0xD5FB}, /* (HANGUL SYLLABLE HEC) */
    {{'\xed', '\x97', '\xbc'}, 3, 0xD5FC}, /* (HANGUL SYLLABLE HEK) */
    {{'\xed', '\x97', '\xbd'}, 3, 0xD5FD}, /* (HANGUL SYLLABLE HET) */
    {{'\xed', '\x97', '\xbe'}, 3, 0xD5FE}, /* (HANGUL SYLLABLE HEP) */
    {{'\xed', '\x97', '\xbf'}, 3, 0xD5FF}, /* (HANGUL SYLLABLE HEH) */
    {{'\xed', '\x98', '\x82'}, 3, 0xD602}, /* (HANGUL SYLLABLE HYEOGG) */
    {{'\xed', '\x98', '\x83'}, 3, 0xD603}, /* (HANGUL SYLLABLE HYEOGS) */
    {{'\xed', '\x98', '\x85'}, 3, 0xD605}, /* (HANGUL SYLLABLE HYEONJ) */
    {{'\xed', '\x98', '\x86'}, 3, 0xD606}, /* (HANGUL SYLLABLE HYEONH) */
    {{'\xed', '\x98', '\x87'}, 3, 0xD607}, /* (HANGUL SYLLABLE HYEOD) */
    {{'\xed', '\x98', '\x89'}, 3, 0xD609}, /* (HANGUL SYLLABLE HYEOLG) */
    {{'\xed', '\x98', '\x8a'}, 3, 0xD60A}, /* (HANGUL SYLLABLE HYEOLM) */
    {{'\xed', '\x98', '\x8b'}, 3, 0xD60B}, /* (HANGUL SYLLABLE HYEOLB) */
    {{'\xed', '\x98', '\x8c'}, 3, 0xD60C}, /* (HANGUL SYLLABLE HYEOLS) */
    {{'\xed', '\x98', '\x8d'}, 3, 0xD60D}, /* (HANGUL SYLLABLE HYEOLT) */
    {{'\xed', '\x98', '\x8e'}, 3, 0xD60E}, /* (HANGUL SYLLABLE HYEOLP) */
    {{'\xed', '\x98', '\x8f'}, 3, 0xD60F}, /* (HANGUL SYLLABLE HYEOLH) */
    {{'\xed', '\x98', '\x92'}, 3, 0xD612}, /* (HANGUL SYLLABLE HYEOBS) */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{'\xed', '\x98', '\x96'}, 3, 0xD616}, /* (HANGUL SYLLABLE HYEOJ) */
    {{'\xed', '\x98', '\x97'}, 3, 0xD617}, /* (HANGUL SYLLABLE HYEOC) */
    {{'\xed', '\x98', '\x98'}, 3, 0xD618}, /* (HANGUL SYLLABLE HYEOK) */
    {{'\xed', '\x98', '\x99'}, 3, 0xD619}, /* (HANGUL SYLLABLE HYEOT) */
    {{'\xed', '\x98', '\x9a'}, 3, 0xD61A}, /* (HANGUL SYLLABLE HYEOP) */
    {{'\xed', '\x98', '\x9b'}, 3, 0xD61B}, /* (HANGUL SYLLABLE HYEOH) */
    {{'\xed', '\x98', '\x9d'}, 3, 0xD61D}, /* (HANGUL SYLLABLE HYEG) */
    {{'\xed', '\x98', '\x9e'}, 3, 0xD61E}, /* (HANGUL SYLLABLE HYEGG) */
    {{'\xed', '\x98', '\x9f'}, 3, 0xD61F}, /* (HANGUL SYLLABLE HYEGS) */
    {{'\xed', '\x98', '\xa1'}, 3, 0xD621}, /* (HANGUL SYLLABLE HYENJ) */
    {{'\xed', '\x98', '\xa2'}, 3, 0xD622}, /* (HANGUL SYLLABLE HYENH) */
    {{'\xed', '\x98', '\xa3'}, 3, 0xD623}, /* (HANGUL SYLLABLE HYED) */
    {{'\xed', '\x98', '\xa5'}, 3, 0xD625}, /* (HANGUL SYLLABLE HYELG) */
    {{'\xed', '\x98', '\xa6'}, 3, 0xD626}, /* (HANGUL SYLLABLE HYELM) */
    {{'\xed', '\x98', '\xa7'}, 3, 0xD627}, /* (HANGUL SYLLABLE HYELB) */
    {{'\xed', '\x98', '\xa8'}, 3, 0xD628}, /* (HANGUL SYLLABLE HYELS) */
    {{'\xed', '\x98', '\xa9'}, 3, 0xD629}, /* (HANGUL SYLLABLE HYELT) */
    {{'\xed', '\x98', '\xaa'}, 3, 0xD62A}, /* (HANGUL SYLLABLE HYELP) */
    {{'\xed', '\x98', '\xab'}, 3, 0xD62B}, /* (HANGUL SYLLABLE HYELH) */
    {{'\xed', '\x98', '\xac'}, 3, 0xD62C}, /* (HANGUL SYLLABLE HYEM) */
    {{'\xed', '\x98', '\xae'}, 3, 0xD62E}, /* (HANGUL SYLLABLE HYEBS) */
    {{'\xed', '\x98', '\xaf'}, 3, 0xD62F}, /* (HANGUL SYLLABLE HYES) */
    {{'\xed', '\x98', '\xb0'}, 3, 0xD630}, /* (HANGUL SYLLABLE HYESS) */
    {{'\xed', '\x98', '\xb1'}, 3, 0xD631}, /* (HANGUL SYLLABLE HYENG) */
    {{'\xed', '\x98', '\xb2'}, 3, 0xD632}, /* (HANGUL SYLLABLE HYEJ) */
    {{'\xed', '\x98', '\xb3'}, 3, 0xD633}, /* (HANGUL SYLLABLE HYEC) */
    {{'\xed', '\x98', '\xb4'}, 3, 0xD634}, /* (HANGUL SYLLABLE HYEK) */
    {{'\xed', '\x98', '\xb5'}, 3, 0xD635}, /* (HANGUL SYLLABLE HYET) */
    {{'\xed', '\x98', '\xb6'}, 3, 0xD636}, /* (HANGUL SYLLABLE HYEP) */
    {{'\xed', '\x98', '\xb7'}, 3, 0xD637}, /* (HANGUL SYLLABLE HYEH) */
    {{'\xed', '\x98', '\xba'}, 3, 0xD63A}, /* (HANGUL SYLLABLE HOGG) */
    {{'\xed', '\x98', '\xbb'}, 3, 0xD63B}, /* (HANGUL SYLLABLE HOGS) */
    {{'\xec', '\xa7', '\x95'}, 3, 0xC9D5}, /* (HANGUL SYLLABLE JING) */
    {{'\xec', '\xa7', '\x96'}, 3, 0xC9D6}, /* (HANGUL SYLLABLE JIJ) */
    {{'\xec', '\xa7', '\x99'}, 3, 0xC9D9}, /* (HANGUL SYLLABLE JIT) */
    {{'\xec', '\xa7', '\x9a'}, 3, 0xC9DA}, /* (HANGUL SYLLABLE JIP) */
    {{'\xec', '\xa7', '\x9c'}, 3, 0xC9DC}, /* (HANGUL SYLLABLE JJA) */
    {{'\xec', '\xa7', '\x9d'}, 3, 0xC9DD}, /* (HANGUL SYLLABLE JJAG) */
    {{'\xec', '\xa7', '\xa0'}, 3, 0xC9E0}, /* (HANGUL SYLLABLE JJAN) */
    {{'\xec', '\xa7', '\xa2'}, 3, 0xC9E2}, /* (HANGUL SYLLABLE JJANH) */
    {{'\xec', '\xa7', '\xa4'}, 3, 0xC9E4}, /* (HANGUL SYLLABLE JJAL) */
    {{'\xec', '\xa7', '\xa7'}, 3, 0xC9E7}, /* (HANGUL SYLLABLE JJALB) */
    {{'\xec', '\xa7', '\xac'}, 3, 0xC9EC}, /* (HANGUL SYLLABLE JJAM) */
    {{'\xec', '\xa7', '\xad'}, 3, 0xC9ED}, /* (HANGUL SYLLABLE JJAB) */
    {{'\xec', '\xa7', '\xaf'}, 3, 0xC9EF}, /* (HANGUL SYLLABLE JJAS) */
    {{'\xec', '\xa7', '\xb0'}, 3, 0xC9F0}, /* (HANGUL SYLLABLE JJASS) */
    {{'\xec', '\xa7', '\xb1'}, 3, 0xC9F1}, /* (HANGUL SYLLABLE JJANG) */
    {{'\xec', '\xa7', '\xb8'}, 3, 0xC9F8}, /* (HANGUL SYLLABLE JJAE) */
    {{'\xec', '\xa7', '\xb9'}, 3, 0xC9F9}, /* (HANGUL SYLLABLE JJAEG) */
    {{'\xec', '\xa7', '\xbc'}, 3, 0xC9FC}, /* (HANGUL SYLLABLE JJAEN) */
    {{'\xec', '\xa8', '\x80'}, 3, 0xCA00}, /* (HANGUL SYLLABLE JJAEL) */
    {{'\xec', '\xa8', '\x88'}, 3, 0xCA08}, /* (HANGUL SYLLABLE JJAEM) */
    {{'\xec', '\xa8', '\x89'}, 3, 0xCA09}, /* (HANGUL SYLLABLE JJAEB) */
    {{'\xec', '\xa8', '\x8b'}, 3, 0xCA0B}, /* (HANGUL SYLLABLE JJAES) */
    {{'\xec', '\xa8', '\x8c'}, 3, 0xCA0C}, /* (HANGUL SYLLABLE JJAESS) */
    {{'\xec', '\xa8', '\x8d'}, 3, 0xCA0D}, /* (HANGUL SYLLABLE JJAENG) */
    {{'\xec', '\xa8', '\x94'}, 3, 0xCA14}, /* (HANGUL SYLLABLE JJYA) */
    {{'\xec', '\xa8', '\x98'}, 3, 0xCA18}, /* (HANGUL SYLLABLE JJYAN) */
    {{'\xec', '\xa8', '\xa9'}, 3, 0xCA29}, /* (HANGUL SYLLABLE JJYANG) */
    {{'\xec', '\xa9', '\x8c'}, 3, 0xCA4C}, /* (HANGUL SYLLABLE JJEO) */
    {{'\xec', '\xa9', '\x8d'}, 3, 0xCA4D}, /* (HANGUL SYLLABLE JJEOG) */
    {{'\xec', '\xa9', '\x90'}, 3, 0xCA50}, /* (HANGUL SYLLABLE JJEON) */
    {{'\xec', '\xa9', '\x94'}, 3, 0xCA54}, /* (HANGUL SYLLABLE JJEOL) */
    {{'\xec', '\xa9', '\x9c'}, 3, 0xCA5C}, /* (HANGUL SYLLABLE JJEOM) */
    {{'\xec', '\xa9', '\x9d'}, 3, 0xCA5D}, /* (HANGUL SYLLABLE JJEOB) */
    {{'\xec', '\xa9', '\x9f'}, 3, 0xCA5F}, /* (HANGUL SYLLABLE JJEOS) */
    {{'\xec', '\xa9', '\xa0'}, 3, 0xCA60}, /* (HANGUL SYLLABLE JJEOSS) */
    {{'\xec', '\xa9', '\xa1'}, 3, 0xCA61}, /* (HANGUL SYLLABLE JJEONG) */
    {{'\xec', '\xa9', '\xa8'}, 3, 0xCA68}, /* (HANGUL SYLLABLE JJE) */
    {{'\xec', '\xa9', '\xbd'}, 3, 0xCA7D}, /* (HANGUL SYLLABLE JJENG) */
    {{'\xec', '\xaa', '\x84'}, 3, 0xCA84}, /* (HANGUL SYLLABLE JJYEO) */
    {{'\xec', '\xaa', '\x98'}, 3, 0xCA98}, /* (HANGUL SYLLABLE JJYEOSS) */
    {{'\xec', '\xaa', '\xbc'}, 3, 0xCABC}, /* (HANGUL SYLLABLE JJO) */
    {{'\xec', '\xaa', '\xbd'}, 3, 0xCABD}, /* (HANGUL SYLLABLE JJOG) */
    {{'\xec', '\xab', '\x80'}, 3, 0xCAC0}, /* (HANGUL SYLLABLE JJON) */
    {{'\xec', '\xab', '\x84'}, 3, 0xCAC4}, /* (HANGUL SYLLABLE JJOL) */
    {{'\xec', '\xab', '\x8c'}, 3, 0xCACC}, /* (HANGUL SYLLABLE JJOM) */
    {{'\xec', '\xab', '\x8d'}, 3, 0xCACD}, /* (HANGUL SYLLABLE JJOB) */
    {{'\xec', '\xab', '\x8f'}, 3, 0xCACF}, /* (HANGUL SYLLABLE JJOS) */
    {{'\xec', '\xab', '\x91'}, 3, 0xCAD1}, /* (HANGUL SYLLABLE JJONG) */
    {{'\xec', '\xab', '\x93'}, 3, 0xCAD3}, /* (HANGUL SYLLABLE JJOC) */
    {{'\xec', '\xab', '\x98'}, 3, 0xCAD8}, /* (HANGUL SYLLABLE JJWA) */
    {{'\xec', '\xab', '\x99'}, 3, 0xCAD9}, /* (HANGUL SYLLABLE JJWAG) */
    {{'\xec', '\xab', '\xa0'}, 3, 0xCAE0}, /* (HANGUL SYLLABLE JJWAL) */
    {{'\xec', '\xab', '\xac'}, 3, 0xCAEC}, /* (HANGUL SYLLABLE JJWASS) */
    {{'\xec', '\xab', '\xb4'}, 3, 0xCAF4}, /* (HANGUL SYLLABLE JJWAE) */
    {{'\xec', '\xac', '\x88'}, 3, 0xCB08}, /* (HANGUL SYLLABLE JJWAESS) */
    {{'\xec', '\xac', '\x90'}, 3, 0xCB10}, /* (HANGUL SYLLABLE JJOE) */
    {{'\xec', '\xac', '\x94'}, 3, 0xCB14}, /* (HANGUL SYLLABLE JJOEN) */
    {{'\xec', '\xac', '\x98'}, 3, 0xCB18}, /* (HANGUL SYLLABLE JJOEL) */
    {{'\xec', '\xac', '\xa0'}, 3, 0xCB20}, /* (HANGUL SYLLABLE JJOEM) */
    {{'\xec', '\xac', '\xa1'}, 3, 0xCB21}, /* (HANGUL SYLLABLE JJOEB) */
    {{'\xec', '\xad', '\x81'}, 3, 0xCB41}, /* (HANGUL SYLLABLE JJYONG) */
    {{'\xec', '\xad', '\x88'}, 3, 0xCB48}, /* (HANGUL SYLLABLE JJU) */
    {{'\xec', '\xad', '\x89'}, 3, 0xCB49}, /* (HANGUL SYLLABLE JJUG) */
    {{'\xec', '\xad', '\x8c'}, 3, 0xCB4C}, /* (HANGUL SYLLABLE JJUN) */
    {{'\xec', '\xad', '\x90'}, 3, 0xCB50}, /* (HANGUL SYLLABLE JJUL) */
    {{'\xec', '\xad', '\x98'}, 3, 0xCB58}, /* (HANGUL SYLLABLE JJUM) */
    {{'\xec', '\xad', '\x99'}, 3, 0xCB59}, /* (HANGUL SYLLABLE JJUB) */
    {{'\xec', '\xad', '\x9d'}, 3, 0xCB5D}, /* (HANGUL SYLLABLE JJUNG) */
    {{'\xec', '\xad', '\xa4'}, 3, 0xCB64}, /* (HANGUL SYLLABLE JJWEO) */
    {{'\xec', '\xad', '\xb8'}, 3, 0xCB78}, /* (HANGUL SYLLABLE JJWEOSS) */
    {{'\xec', '\xad', '\xb9'}, 3, 0xCB79}, /* (HANGUL SYLLABLE JJWEONG) */
    {{'\xec', '\xae', '\x9c'}, 3, 0xCB9C}, /* (HANGUL SYLLABLE JJWI) */
    {{'\xec', '\xae', '\xb8'}, 3, 0xCBB8}, /* (HANGUL SYLLABLE JJYU) */
    {{'\xec', '\xaf', '\x94'}, 3, 0xCBD4}, /* (HANGUL SYLLABLE JJEU) */
    {{'\xec', '\xaf', '\xa4'}, 3, 0xCBE4}, /* (HANGUL SYLLABLE JJEUM) */
    {{'\xec', '\xaf', '\xa7'}, 3, 0xCBE7}, /* (HANGUL SYLLABLE JJEUS) */
    {{'\xec', '\xaf', '\xa9'}, 3, 0xCBE9}, /* (HANGUL SYLLABLE JJEUNG) */
    {{'\xec', '\xb0', '\x8c'}, 3, 0xCC0C}, /* (HANGUL SYLLABLE JJI) */
    {{'\xec', '\xb0', '\x8d'}, 3, 0xCC0D}, /* (HANGUL SYLLABLE JJIG) */
    {{'\xec', '\xb0', '\x90'}, 3, 0xCC10}, /* (HANGUL SYLLABLE JJIN) */
    {{'\xec', '\xb0', '\x94'}, 3, 0xCC14}, /* (HANGUL SYLLABLE JJIL) */
    {{'\xec', '\xb0', '\x9c'}, 3, 0xCC1C}, /* (HANGUL SYLLABLE JJIM) */
    {{'\xec', '\xb0', '\x9d'}, 3, 0xCC1D}, /* (HANGUL SYLLABLE JJIB) */
    {{'\xec', '\xb0', '\xa1'}, 3, 0xCC21}, /* (HANGUL SYLLABLE JJING) */
    {{'\xec', '\xb0', '\xa2'}, 3, 0xCC22}, /* (HANGUL SYLLABLE JJIJ) */
    {{'\xec', '\xb0', '\xa7'}, 3, 0xCC27}, /* (HANGUL SYLLABLE JJIH) */
    {{'\xec', '\xb0', '\xa8'}, 3, 0xCC28}, /* (HANGUL SYLLABLE CA) */
    {{'\xec', '\xb0', '\xa9'}, 3, 0xCC29}, /* (HANGUL SYLLABLE CAG) */
    {{'\xec', '\xb0', '\xac'}, 3, 0xCC2C}, /* (HANGUL SYLLABLE CAN) */
    {{'\xec', '\xb0', '\xae'}, 3, 0xCC2E}, /* (HANGUL SYLLABLE CANH) */
    {{'\xec', '\xb0', '\xb0'}, 3, 0xCC30}, /* (HANGUL SYLLABLE CAL) */
    {{'\xec', '\xb0', '\xb8'}, 3, 0xCC38}, /* (HANGUL SYLLABLE CAM) */
    {{'\xec', '\xb0', '\xb9'}, 3, 0xCC39}, /* (HANGUL SYLLABLE CAB) */
    {{'\xec', '\xb0', '\xbb'}, 3, 0xCC3B}, /* (HANGUL SYLLABLE CAS) */
    {{'\xed', '\x98', '\xbd'}, 3, 0xD63D}, /* (HANGUL SYLLABLE HONJ) */
    {{'\xed', '\x98', '\xbe'}, 3, 0xD63E}, /* (HANGUL SYLLABLE HONH) */
    {{'\xed', '\x98', '\xbf'}, 3, 0xD63F}, /* (HANGUL SYLLABLE HOD) */
    {{'\xed', '\x99', '\x81'}, 3, 0xD641}, /* (HANGUL SYLLABLE HOLG) */
    {{'\xed', '\x99', '\x82'}, 3, 0xD642}, /* (HANGUL SYLLABLE HOLM) */
    {{'\xed', '\x99', '\x83'}, 3, 0xD643}, /* (HANGUL SYLLABLE HOLB) */
    {{'\xed', '\x99', '\x84'}, 3, 0xD644}, /* (HANGUL SYLLABLE HOLS) */
    {{'\xed', '\x99', '\x86'}, 3, 0xD646}, /* (HANGUL SYLLABLE HOLP) */
    {{'\xed', '\x99', '\x87'}, 3, 0xD647}, /* (HANGUL SYLLABLE HOLH) */
    {{'\xed', '\x99', '\x8a'}, 3, 0xD64A}, /* (HANGUL SYLLABLE HOBS) */
    {{'\xed', '\x99', '\x8c'}, 3, 0xD64C}, /* (HANGUL SYLLABLE HOSS) */
    {{'\xed', '\x99', '\x8e'}, 3, 0xD64E}, /* (HANGUL SYLLABLE HOJ) */
    {{'\xed', '\x99', '\x8f'}, 3, 0xD64F}, /* (HANGUL SYLLABLE HOC) */
    {{'\xed', '\x99', '\x90'}, 3, 0xD650}, /* (HANGUL SYLLABLE HOK) */
    {{'\xed', '\x99', '\x92'}, 3, 0xD652}, /* (HANGUL SYLLABLE HOP) */
    {{'\xed', '\x99', '\x93'}, 3, 0xD653}, /* (HANGUL SYLLABLE HOH) */
    {{'\xed', '\x99', '\x96'}, 3, 0xD656}, /* (HANGUL SYLLABLE HWAGG) */
    {{'\xed', '\x99', '\x97'}, 3, 0xD657}, /* (HANGUL SYLLABLE HWAGS) */
    {{'\xed', '\x99', '\x99'}, 3, 0xD659}, /* (HANGUL SYLLABLE HWANJ) */
    {{'\xed', '\x99', '\x9a'}, 3, 0xD65A}, /* (HANGUL SYLLABLE HWANH) */
    {{'\xed', '\x99', '\x9b'}, 3, 0xD65B}, /* (HANGUL SYLLABLE HWAD) */
    {{'\xed', '\x99', '\x9d'}, 3, 0xD65D}, /* (HANGUL SYLLABLE HWALG) */
    {{'\xed', '\x99', '\x9e'}, 3, 0xD65E}, /* (HANGUL SYLLABLE HWALM) */
    {{'\xed', '\x99', '\x9f'}, 3, 0xD65F}, /* (HANGUL SYLLABLE HWALB) */
    {{'\xed', '\x99', '\xa0'}, 3, 0xD660}, /* (HANGUL SYLLABLE HWALS) */
    {{'\xed', '\x99', '\xa1'}, 3, 0xD661}, /* (HANGUL SYLLABLE HWALT) */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{'\xed', '\x99', '\xa2'}, 3, 0xD662}, /* (HANGUL SYLLABLE HWALP) */
    {{'\xed', '\x99', '\xa3'}, 3, 0xD663}, /* (HANGUL SYLLABLE HWALH) */
    {{'\xed', '\x99', '\xa4'}, 3, 0xD664}, /* (HANGUL SYLLABLE HWAM) */
    {{'\xed', '\x99', '\xa5'}, 3, 0xD665}, /* (HANGUL SYLLABLE HWAB) */
    {{'\xed', '\x99', '\xa6'}, 3, 0xD666}, /* (HANGUL SYLLABLE HWABS) */
    {{'\xed', '\x99', '\xa8'}, 3, 0xD668}, /* (HANGUL SYLLABLE HWASS) */
    {{'\xed', '\x99', '\xaa'}, 3, 0xD66A}, /* (HANGUL SYLLABLE HWAJ) */
    {{'\xed', '\x99', '\xab'}, 3, 0xD66B}, /* (HANGUL SYLLABLE HWAC) */
    {{'\xed', '\x99', '\xac'}, 3, 0xD66C}, /* (HANGUL SYLLABLE HWAK) */
    {{'\xed', '\x99', '\xad'}, 3, 0xD66D}, /* (HANGUL SYLLABLE HWAT) */
    {{'\xed', '\x99', '\xae'}, 3, 0xD66E}, /* (HANGUL SYLLABLE HWAP) */
    {{'\xed', '\x99', '\xaf'}, 3, 0xD66F}, /* (HANGUL SYLLABLE HWAH) */
    {{'\xed', '\x99', '\xb2'}, 3, 0xD672}, /* (HANGUL SYLLABLE HWAEGG) */
    {{'\xed', '\x99', '\xb3'}, 3, 0xD673}, /* (HANGUL SYLLABLE HWAEGS) */
    {{'\xed', '\x99', '\xb5'}, 3, 0xD675}, /* (HANGUL SYLLABLE HWAENJ) */
    {{'\xed', '\x99', '\xb6'}, 3, 0xD676}, /* (HANGUL SYLLABLE HWAENH) */
    {{'\xed', '\x99', '\xb7'}, 3, 0xD677}, /* (HANGUL SYLLABLE HWAED) */
    {{'\xed', '\x99', '\xb8'}, 3, 0xD678}, /* (HANGUL SYLLABLE HWAEL) */
    {{'\xed', '\x99', '\xb9'}, 3, 0xD679}, /* (HANGUL SYLLABLE HWAELG) */
    {{'\xed', '\x99', '\xba'}, 3, 0xD67A}, /* (HANGUL SYLLABLE HWAELM) */
    {{'\xed', '\x99', '\xbb'}, 3, 0xD67B}, /* (HANGUL SYLLABLE HWAELB) */
    {{'\xed', '\x99', '\xbc'}, 3, 0xD67C}, /* (HANGUL SYLLABLE HWAELS) */
    {{'\xed', '\x99', '\xbd'}, 3, 0xD67D}, /* (HANGUL SYLLABLE HWAELT) */
    {{'\xed', '\x99', '\xbe'}, 3, 0xD67E}, /* (HANGUL SYLLABLE HWAELP) */
    {{'\xed', '\x99', '\xbf'}, 3, 0xD67F}, /* (HANGUL SYLLABLE HWAELH) */
    {{'\xed', '\x9a', '\x80'}, 3, 0xD680}, /* (HANGUL SYLLABLE HWAEM) */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{'\xed', '\x9a', '\x81'}, 3, 0xD681}, /* (HANGUL SYLLABLE HWAEB) */
    {{'\xed', '\x9a', '\x82'}, 3, 0xD682}, /* (HANGUL SYLLABLE HWAEBS) */
    {{'\xed', '\x9a', '\x84'}, 3, 0xD684}, /* (HANGUL SYLLABLE HWAESS) */
    {{'\xed', '\x9a', '\x86'}, 3, 0xD686}, /* (HANGUL SYLLABLE HWAEJ) */
    {{'\xed', '\x9a', '\x87'}, 3, 0xD687}, /* (HANGUL SYLLABLE HWAEC) */
    {{'\xed', '\x9a', '\x88'}, 3, 0xD688}, /* (HANGUL SYLLABLE HWAEK) */
    {{'\xed', '\x9a', '\x89'}, 3, 0xD689}, /* (HANGUL SYLLABLE HWAET) */
    {{'\xed', '\x9a', '\x8a'}, 3, 0xD68A}, /* (HANGUL SYLLABLE HWAEP) */
    {{'\xed', '\x9a', '\x8b'}, 3, 0xD68B}, /* (HANGUL SYLLABLE HWAEH) */
    {{'\xed', '\x9a', '\x8e'}, 3, 0xD68E}, /* (HANGUL SYLLABLE HOEGG) */
    {{'\xed', '\x9a', '\x8f'}, 3, 0xD68F}, /* (HANGUL SYLLABLE HOEGS) */
    {{'\xed', '\x9a', '\x91'}, 3, 0xD691}, /* (HANGUL SYLLABLE HOENJ) */
    {{'\xed', '\x9a', '\x92'}, 3, 0xD692}, /* (HANGUL SYLLABLE HOENH) */
    {{'\xed', '\x9a', '\x93'}, 3, 0xD693}, /* (HANGUL SYLLABLE HOED) */
    {{'\xed', '\x9a', '\x95'}, 3, 0xD695}, /* (HANGUL SYLLABLE HOELG) */
    {{'\xed', '\x9a', '\x96'}, 3, 0xD696}, /* (HANGUL SYLLABLE HOELM) */
    {{'\xed', '\x9a', '\x97'}, 3, 0xD697}, /* (HANGUL SYLLABLE HOELB) */
    {{'\xed', '\x9a', '\x98'}, 3, 0xD698}, /* (HANGUL SYLLABLE HOELS) */
    {{'\xed', '\x9a', '\x99'}, 3, 0xD699}, /* (HANGUL SYLLABLE HOELT) */
    {{'\xed', '\x9a', '\x9a'}, 3, 0xD69A}, /* (HANGUL SYLLABLE HOELP) */
    {{'\xed', '\x9a', '\x9b'}, 3, 0xD69B}, /* (HANGUL SYLLABLE HOELH) */
    {{'\xed', '\x9a', '\x9c'}, 3, 0xD69C}, /* (HANGUL SYLLABLE HOEM) */
    {{'\xed', '\x9a', '\x9e'}, 3, 0xD69E}, /* (HANGUL SYLLABLE HOEBS) */
    {{'\xed', '\x9a', '\xa0'}, 3, 0xD6A0}, /* (HANGUL SYLLABLE HOESS) */
    {{'\xed', '\x9a', '\xa2'}, 3, 0xD6A2}, /* (HANGUL SYLLABLE HOEJ) */
    {{'\xed', '\x9a', '\xa3'}, 3, 0xD6A3}, /* (HANGUL SYLLABLE HOEC) */
    {{'\xed', '\x9a', '\xa4'}, 3, 0xD6A4}, /* (HANGUL SYLLABLE HOEK) */
    {{'\xed', '\x9a', '\xa5'}, 3, 0xD6A5}, /* (HANGUL SYLLABLE HOET) */
    {{'\xed', '\x9a', '\xa6'}, 3, 0xD6A6}, /* (HANGUL SYLLABLE HOEP) */
    {{'\xed', '\x9a', '\xa7'}, 3, 0xD6A7}, /* (HANGUL SYLLABLE HOEH) */
    {{'\xed', '\x9a', '\xa9'}, 3, 0xD6A9}, /* (HANGUL SYLLABLE HYOG) */
    {{'\xed', '\x9a', '\xaa'}, 3, 0xD6AA}, /* (HANGUL SYLLABLE HYOGG) */
    {{'\xec', '\xb0', '\xbc'}, 3, 0xCC3C}, /* (HANGUL SYLLABLE CASS) */
    {{'\xec', '\xb0', '\xbd'}, 3, 0xCC3D}, /* (HANGUL SYLLABLE CANG) */
    {{'\xec', '\xb0', '\xbe'}, 3, 0xCC3E}, /* (HANGUL SYLLABLE CAJ) */
    {{'\xec', '\xb1', '\x84'}, 3, 0xCC44}, /* (HANGUL SYLLABLE CAE) */
    {{'\xec', '\xb1', '\x85'}, 3, 0xCC45}, /* (HANGUL SYLLABLE CAEG) */
    {{'\xec', '\xb1', '\x88'}, 3, 0xCC48}, /* (HANGUL SYLLABLE CAEN) */
    {{'\xec', '\xb1', '\x8c'}, 3, 0xCC4C}, /* (HANGUL SYLLABLE CAEL) */
    {{'\xec', '\xb1', '\x94'}, 3, 0xCC54}, /* (HANGUL SYLLABLE CAEM) */
    {{'\xec', '\xb1', '\x95'}, 3, 0xCC55}, /* (HANGUL SYLLABLE CAEB) */
    {{'\xec', '\xb1', '\x97'}, 3, 0xCC57}, /* (HANGUL SYLLABLE CAES) */
    {{'\xec', '\xb1', '\x98'}, 3, 0xCC58}, /* (HANGUL SYLLABLE CAESS) */
    {{'\xec', '\xb1', '\x99'}, 3, 0xCC59}, /* (HANGUL SYLLABLE CAENG) */
    {{'\xec', '\xb1', '\xa0'}, 3, 0xCC60}, /* (HANGUL SYLLABLE CYA) */
    {{'\xec', '\xb1', '\xa4'}, 3, 0xCC64}, /* (HANGUL SYLLABLE CYAN) */
    {{'\xec', '\xb1', '\xa6'}, 3, 0xCC66}, /* (HANGUL SYLLABLE CYANH) */
    {{'\xec', '\xb1', '\xa8'}, 3, 0xCC68}, /* (HANGUL SYLLABLE CYAL) */
    {{'\xec', '\xb1', '\xb0'}, 3, 0xCC70}, /* (HANGUL SYLLABLE CYAM) */
    {{'\xec', '\xb1', '\xb5'}, 3, 0xCC75}, /* (HANGUL SYLLABLE CYANG) */
    {{'\xec', '\xb2', '\x98'}, 3, 0xCC98}, /* (HANGUL SYLLABLE CEO) */
    {{'\xec', '\xb2', '\x99'}, 3, 0xCC99}, /* (HANGUL SYLLABLE CEOG) */
    {{'\xec', '\xb2', '\x9c'}, 3, 0xCC9C}, /* (HANGUL SYLLABLE CEON) */
    {{'\xec', '\xb2', '\xa0'}, 3, 0xCCA0}, /* (HANGUL SYLLABLE CEOL) */
    {{'\xec', '\xb2', '\xa8'}, 3, 0xCCA8}, /* (HANGUL SYLLABLE CEOM) */
    {{'\xec', '\xb2', '\xa9'}, 3, 0xCCA9}, /* (HANGUL SYLLABLE CEOB) */
    {{'\xec', '\xb2', '\xab'}, 3, 0xCCAB}, /* (HANGUL SYLLABLE CEOS) */
    {{'\xec', '\xb2', '\xac'}, 3, 0xCCAC}, /* (HANGUL SYLLABLE CEOSS) */
    {{'\xec', '\xb2', '\xad'}, 3, 0xCCAD}, /* (HANGUL SYLLABLE CEONG) */
    {{'\xec', '\xb2', '\xb4'}, 3, 0xCCB4}, /* (HANGUL SYLLABLE CE) */
    {{'\xec', '\xb2', '\xb5'}, 3, 0xCCB5}, /* (HANGUL SYLLABLE CEG) */
    {{'\xec', '\xb2', '\xb8'}, 3, 0xCCB8}, /* (HANGUL SYLLABLE CEN) */
    {{'\xec', '\xb2', '\xbc'}, 3, 0xCCBC}, /* (HANGUL SYLLABLE CEL) */
    {{'\xec', '\xb3', '\x84'}, 3, 0xCCC4}, /* (HANGUL SYLLABLE CEM) */
    {{'\xec', '\xb3', '\x85'}, 3, 0xCCC5}, /* (HANGUL SYLLABLE CEB) */
    {{'\xec', '\xb3', '\x87'}, 3, 0xCCC7}, /* (HANGUL SYLLABLE CES) */
    {{'\xec', '\xb3', '\x89'}, 3, 0xCCC9}, /* (HANGUL SYLLABLE CENG) */
    {{'\xec', '\xb3', '\x90'}, 3, 0xCCD0}, /* (HANGUL SYLLABLE CYEO) */
    {{'\xec', '\xb3', '\x94'}, 3, 0xCCD4}, /* (HANGUL SYLLABLE CYEON) */
    {{'\xec', '\xb3', '\xa4'}, 3, 0xCCE4}, /* (HANGUL SYLLABLE CYEOSS) */
    {{'\xec', '\xb3', '\xac'}, 3, 0xCCEC}, /* (HANGUL SYLLABLE CYE) */
    {{'\xec', '\xb3', '\xb0'}, 3, 0xCCF0}, /* (HANGUL SYLLABLE CYEN) */
    {{'\xec', '\xb4', '\x81'}, 3, 0xCD01}, /* (HANGUL SYLLABLE CYENG) */
    {{'\xec', '\xb4', '\x88'}, 3, 0xCD08}, /* (HANGUL SYLLABLE CO) */
    {{'\xec', '\xb4', '\x89'}, 3, 0xCD09}, /* (HANGUL SYLLABLE COG) */
    {{'\xec', '\xb4', '\x8c'}, 3, 0xCD0C}, /* (HANGUL SYLLABLE CON) */
    {{'\xec', '\xb4', '\x90'}, 3, 0xCD10}, /* (HANGUL SYLLABLE COL) */
    {{'\xec', '\xb4', '\x98'}, 3, 0xCD18}, /* (HANGUL SYLLABLE COM) */
    {{'\xec', '\xb4', '\x99'}, 3, 0xCD19}, /* (HANGUL SYLLABLE COB) */
    {{'\xec', '\xb4', '\x9b'}, 3, 0xCD1B}, /* (HANGUL SYLLABLE COS) */
    {{'\xec', '\xb4', '\x9d'}, 3, 0xCD1D}, /* (HANGUL SYLLABLE CONG) */
    {{'\xec', '\xb4', '\xa4'}, 3, 0xCD24}, /* (HANGUL SYLLABLE CWA) */
    {{'\xec', '\xb4', '\xa8'}, 3, 0xCD28}, /* (HANGUL SYLLABLE CWAN) */
    {{'\xec', '\xb4', '\xac'}, 3, 0xCD2C}, /* (HANGUL SYLLABLE CWAL) */
    {{'\xec', '\xb4', '\xb9'}, 3, 0xCD39}, /* (HANGUL SYLLABLE CWANG) */
    {{'\xec', '\xb5', '\x9c'}, 3, 0xCD5C}, /* (HANGUL SYLLABLE COE) */
    {{'\xec', '\xb5', '\xa0'}, 3, 0xCD60}, /* (HANGUL SYLLABLE COEN) */
    {{'\xec', '\xb5', '\xa4'}, 3, 0xCD64}, /* (HANGUL SYLLABLE COEL) */
    {{'\xec', '\xb5', '\xac'}, 3, 0xCD6C}, /* (HANGUL SYLLABLE COEM) */
    {{'\xec', '\xb5', '\xad'}, 3, 0xCD6D}, /* (HANGUL SYLLABLE COEB) */
    {{'\xec', '\xb5', '\xaf'}, 3, 0xCD6F}, /* (HANGUL SYLLABLE COES) */
    {{'\xec', '\xb5', '\xb1'}, 3, 0xCD71}, /* (HANGUL SYLLABLE COENG) */
    {{'\xec', '\xb5', '\xb8'}, 3, 0xCD78}, /* (HANGUL SYLLABLE CYO) */
    {{'\xec', '\xb6', '\x88'}, 3, 0xCD88}, /* (HANGUL SYLLABLE CYOM) */
    {{'\xec', '\xb6', '\x94'}, 3, 0xCD94}, /* (HANGUL SYLLABLE CU) */
    {{'\xec', '\xb6', '\x95'}, 3, 0xCD95}, /* (HANGUL SYLLABLE CUG) */
    {{'\xec', '\xb6', '\x98'}, 3, 0xCD98}, /* (HANGUL SYLLABLE CUN) */
    {{'\xec', '\xb6', '\x9c'}, 3, 0xCD9C}, /* (HANGUL SYLLABLE CUL) */
    {{'\xec', '\xb6', '\xa4'}, 3, 0xCDA4}, /* (HANGUL SYLLABLE CUM) */
    {{'\xec', '\xb6', '\xa5'}, 3, 0xCDA5}, /* (HANGUL SYLLABLE CUB) */
    {{'\xec', '\xb6', '\xa7'}, 3, 0xCDA7}, /* (HANGUL SYLLABLE CUS) */
    {{'\xec', '\xb6', '\xa9'}, 3, 0xCDA9}, /* (HANGUL SYLLABLE CUNG) */
    {{'\xec', '\xb6', '\xb0'}, 3, 0xCDB0}, /* (HANGUL SYLLABLE CWEO) */
    {{'\xec', '\xb7', '\x84'}, 3, 0xCDC4}, /* (HANGUL SYLLABLE CWEOSS) */
    {{'\xec', '\xb7', '\x8c'}, 3, 0xCDCC}, /* (HANGUL SYLLABLE CWE) */
    {{'\xec', '\xb7', '\x90'}, 3, 0xCDD0}, /* (HANGUL SYLLABLE CWEN) */
    {{'\xec', '\xb7', '\xa8'}, 3, 0xCDE8}, /* (HANGUL SYLLABLE CWI) */
    {{'\xec', '\xb7', '\xac'}, 3, 0xCDEC}, /* (HANGUL SYLLABLE CWIN) */
    {{'\xec', '\xb7', '\xb0'}, 3, 0xCDF0}, /* (HANGUL SYLLABLE CWIL) */
    {{'\xec', '\xb7', '\xb8'}, 3, 0xCDF8}, /* (HANGUL SYLLABLE CWIM) */
    {{'\xec', '\xb7', '\xb9'}, 3, 0xCDF9}, /* (HANGUL SYLLABLE CWIB) */
    {{'\xec', '\xb7', '\xbb'}, 3, 0xCDFB}, /* (HANGUL SYLLABLE CWIS) */
    {{'\xec', '\xb7', '\xbd'}, 3, 0xCDFD}, /* (HANGUL SYLLABLE CWING) */
    {{'\xec', '\xb8', '\x84'}, 3, 0xCE04}, /* (HANGUL SYLLABLE CYU) */
    {{'\xec', '\xb8', '\x88'}, 3, 0xCE08}, /* (HANGUL SYLLABLE CYUN) */
    {{'\xec', '\xb8', '\x8c'}, 3, 0xCE0C}, /* (HANGUL SYLLABLE CYUL) */
    {{'\xec', '\xb8', '\x94'}, 3, 0xCE14}, /* (HANGUL SYLLABLE CYUM) */
    {{'\xec', '\xb8', '\x99'}, 3, 0xCE19}, /* (HANGUL SYLLABLE CYUNG) */
    {{'\xec', '\xb8', '\xa0'}, 3, 0xCE20}, /* (HANGUL SYLLABLE CEU) */
    {{'\xec', '\xb8', '\xa1'}, 3, 0xCE21}, /* (HANGUL SYLLABLE CEUG) */
    {{'\xec', '\xb8', '\xa4'}, 3, 0xCE24}, /* (HANGUL SYLLABLE CEUN) */
    {{'\xec', '\xb8', '\xa8'}, 3, 0xCE28}, /* (HANGUL SYLLABLE CEUL) */
    {{'\xec', '\xb8', '\xb0'}, 3, 0xCE30}, /* (HANGUL SYLLABLE CEUM) */
    {{'\xec', '\xb8', '\xb1'}, 3, 0xCE31}, /* (HANGUL SYLLABLE CEUB) */
    {{'\xec', '\xb8', '\xb3'}, 3, 0xCE33}, /* (HANGUL SYLLABLE CEUS) */
    {{'\xec', '\xb8', '\xb5'}, 3, 0xCE35}, /* (HANGUL SYLLABLE CEUNG) */
    {{'\xed', '\x9a', '\xab'}, 3, 0xD6AB}, /* (HANGUL SYLLABLE HYOGS) */
    {{'\xed', '\x9a', '\xad'}, 3, 0xD6AD}, /* (HANGUL SYLLABLE HYONJ) */
    {{'\xed', '\x9a', '\xae'}, 3, 0xD6AE}, /* (HANGUL SYLLABLE HYONH) */
    {{'\xed', '\x9a', '\xaf'}, 3, 0xD6AF}, /* (HANGUL SYLLABLE HYOD) */
    {{'\xed', '\x9a', '\xb1'}, 3, 0xD6B1}, /* (HANGUL SYLLABLE HYOLG) */
    {{'\xed', '\x9a', '\xb2'}, 3, 0xD6B2}, /* (HANGUL SYLLABLE HYOLM) */
    {{'\xed', '\x9a', '\xb3'}, 3, 0xD6B3}, /* (HANGUL SYLLABLE HYOLB) */
    {{'\xed', '\x9a', '\xb4'}, 3, 0xD6B4}, /* (HANGUL SYLLABLE HYOLS) */
    {{'\xed', '\x9a', '\xb5'}, 3, 0xD6B5}, /* (HANGUL SYLLABLE HYOLT) */
    {{'\xed', '\x9a', '\xb6'}, 3, 0xD6B6}, /* (HANGUL SYLLABLE HYOLP) */
    {{'\xed', '\x9a', '\xb7'}, 3, 0xD6B7}, /* (HANGUL SYLLABLE HYOLH) */
    {{'\xed', '\x9a', '\xb8'}, 3, 0xD6B8}, /* (HANGUL SYLLABLE HYOM) */
    {{'\xed', '\x9a', '\xba'}, 3, 0xD6BA}, /* (HANGUL SYLLABLE HYOBS) */
    {{'\xed', '\x9a', '\xbc'}, 3, 0xD6BC}, /* (HANGUL SYLLABLE HYOSS) */
    {{'\xed', '\x9a', '\xbd'}, 3, 0xD6BD}, /* (HANGUL SYLLABLE HYONG) */
    {{'\xed', '\x9a', '\xbe'}, 3, 0xD6BE}, /* (HANGUL SYLLABLE HYOJ) */
    {{'\xed', '\x9a', '\xbf'}, 3, 0xD6BF}, /* (HANGUL SYLLABLE HYOC) */
    {{'\xed', '\x9b', '\x80'}, 3, 0xD6C0}, /* (HANGUL SYLLABLE HYOK) */
    {{'\xed', '\x9b', '\x81'}, 3, 0xD6C1}, /* (HANGUL SYLLABLE HYOT) */
    {{'\xed', '\x9b', '\x82'}, 3, 0xD6C2}, /* (HANGUL SYLLABLE HYOP) */
    {{'\xed', '\x9b', '\x83'}, 3, 0xD6C3}, /* (HANGUL SYLLABLE HYOH) */
    {{'\xed', '\x9b', '\x86'}, 3, 0xD6C6}, /* (HANGUL SYLLABLE HUGG) */
    {{'\xed', '\x9b', '\x87'}, 3, 0xD6C7}, /* (HANGUL SYLLABLE HUGS) */
    {{'\xed', '\x9b', '\x89'}, 3, 0xD6C9}, /* (HANGUL SYLLABLE HUNJ) */
    {{'\xed', '\x9b', '\x8a'}, 3, 0xD6CA}, /* (HANGUL SYLLABLE HUNH) */
    {{'\xed', '\x9b', '\x8b'}, 3, 0xD6CB}, /* (HANGUL SYLLABLE HUD) */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{'\xed', '\x9b', '\x8d'}, 3, 0xD6CD}, /* (HANGUL SYLLABLE HULG) */
    {{'\xed', '\x9b', '\x8e'}, 3, 0xD6CE}, /* (HANGUL SYLLABLE HULM) */
    {{'\xed', '\x9b', '\x8f'}, 3, 0xD6CF}, /* (HANGUL SYLLABLE HULB) */
    {{'\xed', '\x9b', '\x90'}, 3, 0xD6D0}, /* (HANGUL SYLLABLE HULS) */
    {{'\xed', '\x9b', '\x92'}, 3, 0xD6D2}, /* (HANGUL SYLLABLE HULP) */
    {{'\xed', '\x9b', '\x93'}, 3, 0xD6D3}, /* (HANGUL SYLLABLE HULH) */
    {{'\xed', '\x9b', '\x95'}, 3, 0xD6D5}, /* (HANGUL SYLLABLE HUB) */
    {{'\xed', '\x9b', '\x96'}, 3, 0xD6D6}, /* (HANGUL SYLLABLE HUBS) */
    {{'\xed', '\x9b', '\x98'}, 3, 0xD6D8}, /* (HANGUL SYLLABLE HUSS) */
    {{'\xed', '\x9b', '\x9a'}, 3, 0xD6DA}, /* (HANGUL SYLLABLE HUJ) */
    {{'\xed', '\x9b', '\x9b'}, 3, 0xD6DB}, /* (HANGUL SYLLABLE HUC) */
    {{'\xed', '\x9b', '\x9c'}, 3, 0xD6DC}, /* (HANGUL SYLLABLE HUK) */
    {{'\xed', '\x9b', '\x9d'}, 3, 0xD6DD}, /* (HANGUL SYLLABLE HUT) */
    {{'\xed', '\x9b', '\x9e'}, 3, 0xD6DE}, /* (HANGUL SYLLABLE HUP) */
    {{'\xed', '\x9b', '\x9f'}, 3, 0xD6DF}, /* (HANGUL SYLLABLE HUH) */
    {{'\xed', '\x9b', '\xa1'}, 3, 0xD6E1}, /* (HANGUL SYLLABLE HWEOG) */
    {{'\xed', '\x9b', '\xa2'}, 3, 0xD6E2}, /* (HANGUL SYLLABLE HWEOGG) */
    {{'\xed', '\x9b', '\xa3'}, 3, 0xD6E3}, /* (HANGUL SYLLABLE HWEOGS) */
    {{'\xed', '\x9b', '\xa5'}, 3, 0xD6E5}, /* (HANGUL SYLLABLE HWEONJ) */
    {{'\xed', '\x9b', '\xa6'}, 3, 0xD6E6}, /* (HANGUL SYLLABLE HWEONH) */
    {{'\xed', '\x9b', '\xa7'}, 3, 0xD6E7}, /* (HANGUL SYLLABLE HWEOD) */
    {{'\xed', '\x9b', '\xa9'}, 3, 0xD6E9}, /* (HANGUL SYLLABLE HWEOLG) */
    {{'\xed', '\x9b', '\xaa'}, 3, 0xD6EA}, /* (HANGUL SYLLABLE HWEOLM) */
    {{'\xed', '\x9b', '\xab'}, 3, 0xD6EB}, /* (HANGUL SYLLABLE HWEOLB) */
    {{'\xed', '\x9b', '\xac'}, 3, 0xD6EC}, /* (HANGUL SYLLABLE HWEOLS) */
    {{'\xed', '\x9b', '\xad'}, 3, 0xD6ED}, /* (HANGUL SYLLABLE HWEOLT) */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{'\xed', '\x9b', '\xae'}, 3, 0xD6EE}, /* (HANGUL SYLLABLE HWEOLP) */
    {{'\xed', '\x9b', '\xaf'}, 3, 0xD6EF}, /* (HANGUL SYLLABLE HWEOLH) */
    {{'\xed', '\x9b', '\xb1'}, 3, 0xD6F1}, /* (HANGUL SYLLABLE HWEOB) */
    {{'\xed', '\x9b', '\xb2'}, 3, 0xD6F2}, /* (HANGUL SYLLABLE HWEOBS) */
    {{'\xed', '\x9b', '\xb3'}, 3, 0xD6F3}, /* (HANGUL SYLLABLE HWEOS) */
    {{'\xed', '\x9b', '\xb4'}, 3, 0xD6F4}, /* (HANGUL SYLLABLE HWEOSS) */
    {{'\xed', '\x9b', '\xb6'}, 3, 0xD6F6}, /* (HANGUL SYLLABLE HWEOJ) */
    {{'\xed', '\x9b', '\xb7'}, 3, 0xD6F7}, /* (HANGUL SYLLABLE HWEOC) */
    {{'\xed', '\x9b', '\xb8'}, 3, 0xD6F8}, /* (HANGUL SYLLABLE HWEOK) */
    {{'\xed', '\x9b', '\xb9'}, 3, 0xD6F9}, /* (HANGUL SYLLABLE HWEOT) */
    {{'\xed', '\x9b', '\xba'}, 3, 0xD6FA}, /* (HANGUL SYLLABLE HWEOP) */
    {{'\xed', '\x9b', '\xbb'}, 3, 0xD6FB}, /* (HANGUL SYLLABLE HWEOH) */
    {{'\xed', '\x9b', '\xbe'}, 3, 0xD6FE}, /* (HANGUL SYLLABLE HWEGG) */
    {{'\xed', '\x9b', '\xbf'}, 3, 0xD6FF}, /* (HANGUL SYLLABLE HWEGS) */
    {{'\xed', '\x9c', '\x81'}, 3, 0xD701}, /* (HANGUL SYLLABLE HWENJ) */
    {{'\xed', '\x9c', '\x82'}, 3, 0xD702}, /* (HANGUL SYLLABLE HWENH) */
    {{'\xed', '\x9c', '\x83'}, 3, 0xD703}, /* (HANGUL SYLLABLE HWED) */
    {{'\xed', '\x9c', '\x85'}, 3, 0xD705}, /* (HANGUL SYLLABLE HWELG) */
    {{'\xed', '\x9c', '\x86'}, 3, 0xD706}, /* (HANGUL SYLLABLE HWELM) */
    {{'\xed', '\x9c', '\x87'}, 3, 0xD707}, /* (HANGUL SYLLABLE HWELB) */
    {{'\xed', '\x9c', '\x88'}, 3, 0xD708}, /* (HANGUL SYLLABLE HWELS) */
    {{'\xed', '\x9c', '\x89'}, 3, 0xD709}, /* (HANGUL SYLLABLE HWELT) */
    {{'\xed', '\x9c', '\x8a'}, 3, 0xD70A}, /* (HANGUL SYLLABLE HWELP) */
    {{'\xed', '\x9c', '\x8b'}, 3, 0xD70B}, /* (HANGUL SYLLABLE HWELH) */
    {{'\xed', '\x9c', '\x8c'}, 3, 0xD70C}, /* (HANGUL SYLLABLE HWEM) */
    {{'\xed', '\x9c', '\x8d'}, 3, 0xD70D}, /* (HANGUL SYLLABLE HWEB) */
    {{'\xed', '\x9c', '\x8e'}, 3, 0xD70E}, /* (HANGUL SYLLABLE HWEBS) */
    {{'\xed', '\x9c', '\x8f'}, 3, 0xD70F}, /* (HANGUL SYLLABLE HWES) */
    {{'\xed', '\x9c', '\x90'}, 3, 0xD710}, /* (HANGUL SYLLABLE HWESS) */
    {{'\xed', '\x9c', '\x92'}, 3, 0xD712}, /* (HANGUL SYLLABLE HWEJ) */
    {{'\xed', '\x9c', '\x93'}, 3, 0xD713}, /* (HANGUL SYLLABLE HWEC) */
    {{'\xed', '\x9c', '\x94'}, 3, 0xD714}, /* (HANGUL SYLLABLE HWEK) */
    {{'\xec', '\xb9', '\x98'}, 3, 0xCE58}, /* (HANGUL SYLLABLE CI) */
    {{'\xec', '\xb9', '\x99'}, 3, 0xCE59}, /* (HANGUL SYLLABLE CIG) */
    {{'\xec', '\xb9', '\x9c'}, 3, 0xCE5C}, /* (HANGUL SYLLABLE CIN) */
    {{'\xec', '\xb9', '\x9f'}, 3, 0xCE5F}, /* (HANGUL SYLLABLE CID) */
    {{'\xec', '\xb9', '\xa0'}, 3, 0xCE60}, /* (HANGUL SYLLABLE CIL) */
    {{'\xec', '\xb9', '\xa1'}, 3, 0xCE61}, /* (HANGUL SYLLABLE CILG) */
    {{'\xec', '\xb9', '\xa8'}, 3, 0xCE68}, /* (HANGUL SYLLABLE CIM) */
    {{'\xec', '\xb9', '\xa9'}, 3, 0xCE69}, /* (HANGUL SYLLABLE CIB) */
    {{'\xec', '\xb9', '\xab'}, 3, 0xCE6B}, /* (HANGUL SYLLABLE CIS) */
    {{'\xec', '\xb9', '\xad'}, 3, 0xCE6D}, /* (HANGUL SYLLABLE CING) */
    {{'\xec', '\xb9', '\xb4'}, 3, 0xCE74}, /* (HANGUL SYLLABLE KA) */
    {{'\xec', '\xb9', '\xb5'}, 3, 0xCE75}, /* (HANGUL SYLLABLE KAG) */
    {{'\xec', '\xb9', '\xb8'}, 3, 0xCE78}, /* (HANGUL SYLLABLE KAN) */
    {{'\xec', '\xb9', '\xbc'}, 3, 0xCE7C}, /* (HANGUL SYLLABLE KAL) */
    {{'\xec', '\xba', '\x84'}, 3, 0xCE84}, /* (HANGUL SYLLABLE KAM) */
    {{'\xec', '\xba', '\x85'}, 3, 0xCE85}, /* (HANGUL SYLLABLE KAB) */
    {{'\xec', '\xba', '\x87'}, 3, 0xCE87}, /* (HANGUL SYLLABLE KAS) */
    {{'\xec', '\xba', '\x89'}, 3, 0xCE89}, /* (HANGUL SYLLABLE KANG) */
    {{'\xec', '\xba', '\x90'}, 3, 0xCE90}, /* (HANGUL SYLLABLE KAE) */
    {{'\xec', '\xba', '\x91'}, 3, 0xCE91}, /* (HANGUL SYLLABLE KAEG) */
    {{'\xec', '\xba', '\x94'}, 3, 0xCE94}, /* (HANGUL SYLLABLE KAEN) */
    {{'\xec', '\xba', '\x98'}, 3, 0xCE98}, /* (HANGUL SYLLABLE KAEL) */
    {{'\xec', '\xba', '\xa0'}, 3, 0xCEA0}, /* (HANGUL SYLLABLE KAEM) */
    {{'\xec', '\xba', '\xa1'}, 3, 0xCEA1}, /* (HANGUL SYLLABLE KAEB) */
    {{'\xec', '\xba', '\xa3'}, 3, 0xCEA3}, /* (HANGUL SYLLABLE KAES) */
    {{'\xec', '\xba', '\xa4'}, 3, 0xCEA4}, /* (HANGUL SYLLABLE KAESS) */
    {{'\xec', '\xba', '\xa5'}, 3, 0xCEA5}, /* (HANGUL SYLLABLE KAENG) */
    {{'\xec', '\xba', '\xac'}, 3, 0xCEAC}, /* (HANGUL SYLLABLE KYA) */
    {{'\xec', '\xba', '\xad'}, 3, 0xCEAD}, /* (HANGUL SYLLABLE KYAG) */
    {{'\xec', '\xbb', '\x81'}, 3, 0xCEC1}, /* (HANGUL SYLLABLE KYANG) */
    {{'\xec', '\xbb', '\xa4'}, 3, 0xCEE4}, /* (HANGUL SYLLABLE KEO) */
    {{'\xec', '\xbb', '\xa5'}, 3, 0xCEE5}, /* (HANGUL SYLLABLE KEOG) */
    {{'\xec', '\xbb', '\xa8'}, 3, 0xCEE8}, /* (HANGUL SYLLABLE KEON) */
    {{'\xec', '\xbb', '\xab'}, 3, 0xCEEB}, /* (HANGUL SYLLABLE KEOD) */
    {{'\xec', '\xbb', '\xac'}, 3, 0xCEEC}, /* (HANGUL SYLLABLE KEOL) */
    {{'\xec', '\xbb', '\xb4'}, 3, 0xCEF4}, /* (HANGUL SYLLABLE KEOM) */
    {{'\xec', '\xbb', '\xb5'}, 3, 0xCEF5}, /* (HANGUL SYLLABLE KEOB) */
    {{'\xec', '\xbb', '\xb7'}, 3, 0xCEF7}, /* (HANGUL SYLLABLE KEOS) */
    {{'\xec', '\xbb', '\xb8'}, 3, 0xCEF8}, /* (HANGUL SYLLABLE KEOSS) */
    {{'\xec', '\xbb', '\xb9'}, 3, 0xCEF9}, /* (HANGUL SYLLABLE KEONG) */
    {{'\xec', '\xbc', '\x80'}, 3, 0xCF00}, /* (HANGUL SYLLABLE KE) */
    {{'\xec', '\xbc', '\x81'}, 3, 0xCF01}, /* (HANGUL SYLLABLE KEG) */
    {{'\xec', '\xbc', '\x84'}, 3, 0xCF04}, /* (HANGUL SYLLABLE KEN) */
    {{'\xec', '\xbc', '\x88'}, 3, 0xCF08}, /* (HANGUL SYLLABLE KEL) */
    {{'\xec', '\xbc', '\x90'}, 3, 0xCF10}, /* (HANGUL SYLLABLE KEM) */
    {{'\xec', '\xbc', '\x91'}, 3, 0xCF11}, /* (HANGUL SYLLABLE KEB) */
    {{'\xec', '\xbc', '\x93'}, 3, 0xCF13}, /* (HANGUL SYLLABLE KES) */
    {{'\xec', '\xbc', '\x95'}, 3, 0xCF15}, /* (HANGUL SYLLABLE KENG) */
    {{'\xec', '\xbc', '\x9c'}, 3, 0xCF1C}, /* (HANGUL SYLLABLE KYEO) */
    {{'\xec', '\xbc', '\xa0'}, 3, 0xCF20}, /* (HANGUL SYLLABLE KYEON) */
    {{'\xec', '\xbc', '\xa4'}, 3, 0xCF24}, /* (HANGUL SYLLABLE KYEOL) */
    {{'\xec', '\xbc', '\xac'}, 3, 0xCF2C}, /* (HANGUL SYLLABLE KYEOM) */
    {{'\xec', '\xbc', '\xad'}, 3, 0xCF2D}, /* (HANGUL SYLLABLE KYEOB) */
    {{'\xec', '\xbc', '\xaf'}, 3, 0xCF2F}, /* (HANGUL SYLLABLE KYEOS) */
    {{'\xec', '\xbc', '\xb0'}, 3, 0xCF30}, /* (HANGUL SYLLABLE KYEOSS) */
    {{'\xec', '\xbc', '\xb1'}, 3, 0xCF31}, /* (HANGUL SYLLABLE KYEONG) */
    {{'\xec', '\xbc', '\xb8'}, 3, 0xCF38}, /* (HANGUL SYLLABLE KYE) */
    {{'\xec', '\xbd', '\x94'}, 3, 0xCF54}, /* (HANGUL SYLLABLE KO) */
    {{'\xec', '\xbd', '\x95'}, 3, 0xCF55}, /* (HANGUL SYLLABLE KOG) */
    {{'\xec', '\xbd', '\x98'}, 3, 0xCF58}, /* (HANGUL SYLLABLE KON) */
    {{'\xec', '\xbd', '\x9c'}, 3, 0xCF5C}, /* (HANGUL SYLLABLE KOL) */
    {{'\xec', '\xbd', '\xa4'}, 3, 0xCF64}, /* (HANGUL SYLLABLE KOM) */
    {{'\xec', '\xbd', '\xa5'}, 3, 0xCF65}, /* (HANGUL SYLLABLE KOB) */
    {{'\xec', '\xbd', '\xa7'}, 3, 0xCF67}, /* (HANGUL SYLLABLE KOS) */
    {{'\xec', '\xbd', '\xa9'}, 3, 0xCF69}, /* (HANGUL SYLLABLE KONG) */
    {{'\xec', '\xbd', '\xb0'}, 3, 0xCF70}, /* (HANGUL SYLLABLE KWA) */
    {{'\xec', '\xbd', '\xb1'}, 3, 0xCF71}, /* (HANGUL SYLLABLE KWAG) */
    {{'\xec', '\xbd', '\xb4'}, 3, 0xCF74}, /* (HANGUL SYLLABLE KWAN) */
    {{'\xec', '\xbd', '\xb8'}, 3, 0xCF78}, /* (HANGUL SYLLABLE KWAL) */
    {{'\xec', '\xbe', '\x80'}, 3, 0xCF80}, /* (HANGUL SYLLABLE KWAM) */
    {{'\xec', '\xbe', '\x85'}, 3, 0xCF85}, /* (HANGUL SYLLABLE KWANG) */
    {{'\xec', '\xbe', '\x8c'}, 3, 0xCF8C}, /* (HANGUL SYLLABLE KWAE) */
    {{'\xec', '\xbe', '\xa1'}, 3, 0xCFA1}, /* (HANGUL SYLLABLE KWAENG) */
    {{'\xec', '\xbe', '\xa8'}, 3, 0xCFA8}, /* (HANGUL SYLLABLE KOE) */
    {{'\xec', '\xbe', '\xb0'}, 3, 0xCFB0}, /* (HANGUL SYLLABLE KOEL) */
    {{'\xec', '\xbf', '\x84'}, 3, 0xCFC4}, /* (HANGUL SYLLABLE KYO) */
    {{'\xec', '\xbf', '\xa0'}, 3, 0xCFE0}, /* (HANGUL SYLLABLE KU) */
    {{'\xec', '\xbf', '\xa1'}, 3, 0xCFE1}, /* (HANGUL SYLLABLE KUG) */
    {{'\xec', '\xbf', '\xa4'}, 3, 0xCFE4}, /* (HANGUL SYLLABLE KUN) */
    {{'\xec', '\xbf', '\xa8'}, 3, 0xCFE8}, /* (HANGUL SYLLABLE KUL) */
    {{'\xec', '\xbf', '\xb0'}, 3, 0xCFF0}, /* (HANGUL SYLLABLE KUM) */
    {{'\xec', '\xbf', '\xb1'}, 3, 0xCFF1}, /* (HANGUL SYLLABLE KUB) */
    {{'\xec', '\xbf', '\xb3'}, 3, 0xCFF3}, /* (HANGUL SYLLABLE KUS) */
    {{'\xec', '\xbf', '\xb5'}, 3, 0xCFF5}, /* (HANGUL SYLLABLE KUNG) */
    {{'\xec', '\xbf', '\xbc'}, 3, 0xCFFC}, /* (HANGUL SYLLABLE KWEO) */
    {{'\xed', '\x80', '\x80'}, 3, 0xD000}, /* (HANGUL SYLLABLE KWEON) */
    {{'\xed', '\x80', '\x84'}, 3, 0xD004}, /* (HANGUL SYLLABLE KWEOL) */
    {{'\xed', '\x80', '\x91'}, 3, 0xD011}, /* (HANGUL SYLLABLE KWEONG) */
    {{'\xed', '\x80', '\x98'}, 3, 0xD018}, /* (HANGUL SYLLABLE KWE) */
    {{'\xed', '\x80', '\xad'}, 3, 0xD02D}, /* (HANGUL SYLLABLE KWENG) */
    {{'\xed', '\x80', '\xb4'}, 3, 0xD034}, /* (HANGUL SYLLABLE KWI) */
    {{'\xed', '\x80', '\xb5'}, 3, 0xD035}, /* (HANGUL SYLLABLE KWIG) */
    {{'\xed', '\x80', '\xb8'}, 3, 0xD038}, /* (HANGUL SYLLABLE KWIN) */
    {{'\xed', '\x80', '\xbc'}, 3, 0xD03C}, /* (HANGUL SYLLABLE KWIL) */
    {{'\xed', '\x9c', '\x95'}, 3, 0xD715}, /* (HANGUL SYLLABLE HWET) */
    {{'\xed', '\x9c', '\x96'}, 3, 0xD716}, /* (HANGUL SYLLABLE HWEP) */
    {{'\xed', '\x9c', '\x97'}, 3, 0xD717}, /* (HANGUL SYLLABLE HWEH) */
    {{'\xed', '\x9c', '\x9a'}, 3, 0xD71A}, /* (HANGUL SYLLABLE HWIGG) */
    {{'\xed', '\x9c', '\x9b'}, 3, 0xD71B}, /* (HANGUL SYLLABLE HWIGS) */
    {{'\xed', '\x9c', '\x9d'}, 3, 0xD71D}, /* (HANGUL SYLLABLE HWINJ) */
    {{'\xed', '\x9c', '\x9e'}, 3, 0xD71E}, /* (HANGUL SYLLABLE HWINH) */
    {{'\xed', '\x9c', '\x9f'}, 3, 0xD71F}, /* (HANGUL SYLLABLE HWID) */
    {{'\xed', '\x9c', '\xa1'}, 3, 0xD721}, /* (HANGUL SYLLABLE HWILG) */
    {{'\xed', '\x9c', '\xa2'}, 3, 0xD722}, /* (HANGUL SYLLABLE HWILM) */
    {{'\xed', '\x9c', '\xa3'}, 3, 0xD723}, /* (HANGUL SYLLABLE HWILB) */
    {{'\xed', '\x9c', '\xa4'}, 3, 0xD724}, /* (HANGUL SYLLABLE HWILS) */
    {{'\xed', '\x9c', '\xa5'}, 3, 0xD725}, /* (HANGUL SYLLABLE HWILT) */
    {{'\xed', '\x9c', '\xa6'}, 3, 0xD726}, /* (HANGUL SYLLABLE HWILP) */
    {{'\xed', '\x9c', '\xa7'}, 3, 0xD727}, /* (HANGUL SYLLABLE HWILH) */
    {{'\xed', '\x9c', '\xaa'}, 3, 0xD72A}, /* (HANGUL SYLLABLE HWIBS) */
    {{'\xed', '\x9c', '\xac'}, 3, 0xD72C}, /* (HANGUL SYLLABLE HWISS) */
    {{'\xed', '\x9c', '\xae'}, 3, 0xD72E}, /* (HANGUL SYLLABLE HWIJ) */
    {{'\xed', '\x9c', '\xaf'}, 3, 0xD72F}, /* (HANGUL SYLLABLE HWIC) */
    {{'\xed', '\x9c', '\xb0'}, 3, 0xD730}, /* (HANGUL SYLLABLE HWIK) */
    {{'\xed', '\x9c', '\xb1'}, 3, 0xD731}, /* (HANGUL SYLLABLE HWIT) */
    {{'\xed', '\x9c', '\xb2'}, 3, 0xD732}, /* (HANGUL SYLLABLE HWIP) */
    {{'\xed', '\x9c', '\xb3'}, 3, 0xD733}, /* (HANGUL SYLLABLE HWIH) */
    {{'\xed', '\x9c', '\xb6'}, 3, 0xD736}, /* (HANGUL SYLLABLE HYUGG) */
    {{'\xed', '\x9c', '\xb7'}, 3, 0xD737}, /* (HANGUL SYLLABLE HYUGS) */
    {{'\xed', '\x9c', '\xb9'}, 3, 0xD739}, /* (HANGUL SYLLABLE HYUNJ) */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{'\xed', '\x9c', '\xba'}, 3, 0xD73A}, /* (HANGUL SYLLABLE HYUNH) */
    {{'\xed', '\x9c', '\xbb'}, 3, 0xD73B}, /* (HANGUL SYLLABLE HYUD) */
    {{'\xed', '\x9c', '\xbd'}, 3, 0xD73D}, /* (HANGUL SYLLABLE HYULG) */
    {{'\xed', '\x9c', '\xbe'}, 3, 0xD73E}, /* (HANGUL SYLLABLE HYULM) */
    {{'\xed', '\x9c', '\xbf'}, 3, 0xD73F}, /* (HANGUL SYLLABLE HYULB) */
    {{'\xed', '\x9d', '\x80'}, 3, 0xD740}, /* (HANGUL SYLLABLE HYULS) */
    {{'\xed', '\x9d', '\x81'}, 3, 0xD741}, /* (HANGUL SYLLABLE HYULT) */
    {{'\xed', '\x9d', '\x82'}, 3, 0xD742}, /* (HANGUL SYLLABLE HYULP) */
    {{'\xed', '\x9d', '\x83'}, 3, 0xD743}, /* (HANGUL SYLLABLE HYULH) */
    {{'\xed', '\x9d', '\x85'}, 3, 0xD745}, /* (HANGUL SYLLABLE HYUB) */
    {{'\xed', '\x9d', '\x86'}, 3, 0xD746}, /* (HANGUL SYLLABLE HYUBS) */
    {{'\xed', '\x9d', '\x88'}, 3, 0xD748}, /* (HANGUL SYLLABLE HYUSS) */
    {{'\xed', '\x9d', '\x8a'}, 3, 0xD74A}, /* (HANGUL SYLLABLE HYUJ) */
    {{'\xed', '\x9d', '\x8b'}, 3, 0xD74B}, /* (HANGUL SYLLABLE HYUC) */
    {{'\xed', '\x9d', '\x8c'}, 3, 0xD74C}, /* (HANGUL SYLLABLE HYUK) */
    {{'\xed', '\x9d', '\x8d'}, 3, 0xD74D}, /* (HANGUL SYLLABLE HYUT) */
    {{'\xed', '\x9d', '\x8e'}, 3, 0xD74E}, /* (HANGUL SYLLABLE HYUP) */
    {{'\xed', '\x9d', '\x8f'}, 3, 0xD74F}, /* (HANGUL SYLLABLE HYUH) */
    {{'\xed', '\x9d', '\x92'}, 3, 0xD752}, /* (HANGUL SYLLABLE HEUGG) */
    {{'\xed', '\x9d', '\x93'}, 3, 0xD753}, /* (HANGUL SYLLABLE HEUGS) */
    {{'\xed', '\x9d', '\x95'}, 3, 0xD755}, /* (HANGUL SYLLABLE HEUNJ) */
    {{'\xed', '\x9d', '\x9a'}, 3, 0xD75A}, /* (HANGUL SYLLABLE HEULM) */
    {{'\xed', '\x9d', '\x9b'}, 3, 0xD75B}, /* (HANGUL SYLLABLE HEULB) */
    {{'\xed', '\x9d', '\x9c'}, 3, 0xD75C}, /* (HANGUL SYLLABLE HEULS) */
    {{'\xed', '\x9d', '\x9d'}, 3, 0xD75D}, /* (HANGUL SYLLABLE HEULT) */
    {{'\xed', '\x9d', '\x9e'}, 3, 0xD75E}, /* (HANGUL SYLLABLE HEULP) */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{'\xed', '\x9d', '\x9f'}, 3, 0xD75F}, /* (HANGUL SYLLABLE HEULH) */
    {{'\xed', '\x9d', '\xa2'}, 3, 0xD762}, /* (HANGUL SYLLABLE HEUBS) */
    {{'\xed', '\x9d', '\xa4'}, 3, 0xD764}, /* (HANGUL SYLLABLE HEUSS) */
    {{'\xed', '\x9d', '\xa6'}, 3, 0xD766}, /* (HANGUL SYLLABLE HEUJ) */
    {{'\xed', '\x9d', '\xa7'}, 3, 0xD767}, /* (HANGUL SYLLABLE HEUC) */
    {{'\xed', '\x9d', '\xa8'}, 3, 0xD768}, /* (HANGUL SYLLABLE HEUK) */
    {{'\xed', '\x9d', '\xaa'}, 3, 0xD76A}, /* (HANGUL SYLLABLE HEUP) */
    {{'\xed', '\x9d', '\xab'}, 3, 0xD76B}, /* (HANGUL SYLLABLE HEUH) */
    {{'\xed', '\x9d', '\xad'}, 3, 0xD76D}, /* (HANGUL SYLLABLE HYIG) */
    {{'\xed', '\x9d', '\xae'}, 3, 0xD76E}, /* (HANGUL SYLLABLE HYIGG) */
    {{'\xed', '\x9d', '\xaf'}, 3, 0xD76F}, /* (HANGUL SYLLABLE HYIGS) */
    {{'\xed', '\x9d', '\xb1'}, 3, 0xD771}, /* (HANGUL SYLLABLE HYINJ) */
    {{'\xed', '\x9d', '\xb2'}, 3, 0xD772}, /* (HANGUL SYLLABLE HYINH) */
    {{'\xed', '\x9d', '\xb3'}, 3, 0xD773}, /* (HANGUL SYLLABLE HYID) */
    {{'\xed', '\x9d', '\xb5'}, 3, 0xD775}, /* (HANGUL SYLLABLE HYILG) */
    {{'\xed', '\x9d', '\xb6'}, 3, 0xD776}, /* (HANGUL SYLLABLE HYILM) */
    {{'\xed', '\x9d', '\xb7'}, 3, 0xD777}, /* (HANGUL SYLLABLE HYILB) */
    {{'\xed', '\x9d', '\xb8'}, 3, 0xD778}, /* (HANGUL SYLLABLE HYILS) */
    {{'\xed', '\x9d', '\xb9'}, 3, 0xD779}, /* (HANGUL SYLLABLE HYILT) */
    {{'\xed', '\x9d', '\xba'}, 3, 0xD77A}, /* (HANGUL SYLLABLE HYILP) */
    {{'\xed', '\x9d', '\xbb'}, 3, 0xD77B}, /* (HANGUL SYLLABLE HYILH) */
    {{'\xed', '\x9d', '\xbe'}, 3, 0xD77E}, /* (HANGUL SYLLABLE HYIBS) */
    {{'\xed', '\x9d', '\xbf'}, 3, 0xD77F}, /* (HANGUL SYLLABLE HYIS) */
    {{'\xed', '\x9e', '\x80'}, 3, 0xD780}, /* (HANGUL SYLLABLE HYISS) */
    {{'\xed', '\x9e', '\x82'}, 3, 0xD782}, /* (HANGUL SYLLABLE HYIJ) */
    {{'\xed', '\x9e', '\x83'}, 3, 0xD783}, /* (HANGUL SYLLABLE HYIC) */
    {{'\xed', '\x9e', '\x84'}, 3, 0xD784}, /* (HANGUL SYLLABLE HYIK) */
    {{'\xed', '\x9e', '\x85'}, 3, 0xD785}, /* (HANGUL SYLLABLE HYIT) */
    {{'\xed', '\x9e', '\x86'}, 3, 0xD786}, /* (HANGUL SYLLABLE HYIP) */
    {{'\xed', '\x9e', '\x87'}, 3, 0xD787}, /* (HANGUL SYLLABLE HYIH) */
    {{'\xed', '\x9e', '\x8a'}, 3, 0xD78A}, /* (HANGUL SYLLABLE HIGG) */
    {{'\xed', '\x9e', '\x8b'}, 3, 0xD78B}, /* (HANGUL SYLLABLE HIGS) */
    {{'\xed', '\x81', '\x84'}, 3, 0xD044}, /* (HANGUL SYLLABLE KWIM) */
    {{'\xed', '\x81', '\x85'}, 3, 0xD045}, /* (HANGUL SYLLABLE KWIB) */
    {{'\xed', '\x81', '\x87'}, 3, 0xD047}, /* (HANGUL SYLLABLE KWIS) */
    {{'\xed', '\x81', '\x89'}, 3, 0xD049}, /* (HANGUL SYLLABLE KWING) */
    {{'\xed', '\x81', '\x90'}, 3, 0xD050}, /* (HANGUL SYLLABLE KYU) */
    {{'\xed', '\x81', '\x94'}, 3, 0xD054}, /* (HANGUL SYLLABLE KYUN) */
    {{'\xed', '\x81', '\x98'}, 3, 0xD058}, /* (HANGUL SYLLABLE KYUL) */
    {{'\xed', '\x81', '\xa0'}, 3, 0xD060}, /* (HANGUL SYLLABLE KYUM) */
    {{'\xed', '\x81', '\xac'}, 3, 0xD06C}, /* (HANGUL SYLLABLE KEU) */
    {{'\xed', '\x81', '\xad'}, 3, 0xD06D}, /* (HANGUL SYLLABLE KEUG) */
    {{'\xed', '\x81', '\xb0'}, 3, 0xD070}, /* (HANGUL SYLLABLE KEUN) */
    {{'\xed', '\x81', '\xb4'}, 3, 0xD074}, /* (HANGUL SYLLABLE KEUL) */
    {{'\xed', '\x81', '\xbc'}, 3, 0xD07C}, /* (HANGUL SYLLABLE KEUM) */
    {{'\xed', '\x81', '\xbd'}, 3, 0xD07D}, /* (HANGUL SYLLABLE KEUB) */
    {{'\xed', '\x82', '\x81'}, 3, 0xD081}, /* (HANGUL SYLLABLE KEUNG) */
    {{'\xed', '\x82', '\xa4'}, 3, 0xD0A4}, /* (HANGUL SYLLABLE KI) */
    {{'\xed', '\x82', '\xa5'}, 3, 0xD0A5}, /* (HANGUL SYLLABLE KIG) */
    {{'\xed', '\x82', '\xa8'}, 3, 0xD0A8}, /* (HANGUL SYLLABLE KIN) */
    {{'\xed', '\x82', '\xac'}, 3, 0xD0AC}, /* (HANGUL SYLLABLE KIL) */
    {{'\xed', '\x82', '\xb4'}, 3, 0xD0B4}, /* (HANGUL SYLLABLE KIM) */
    {{'\xed', '\x82', '\xb5'}, 3, 0xD0B5}, /* (HANGUL SYLLABLE KIB) */
    {{'\xed', '\x82', '\xb7'}, 3, 0xD0B7}, /* (HANGUL SYLLABLE KIS) */
    {{'\xed', '\x82', '\xb9'}, 3, 0xD0B9}, /* (HANGUL SYLLABLE KING) */
    {{'\xed', '\x83', '\x80'}, 3, 0xD0C0}, /* (HANGUL SYLLABLE TA) */
    {{'\xed', '\x83', '\x81'}, 3, 0xD0C1}, /* (HANGUL SYLLABLE TAG) */
    {{'\xed', '\x83', '\x84'}, 3, 0xD0C4}, /* (HANGUL SYLLABLE TAN) */
    {{'\xed', '\x83', '\x88'}, 3, 0xD0C8}, /* (HANGUL SYLLABLE TAL) */
    {{'\xed', '\x83', '\x89'}, 3, 0xD0C9}, /* (HANGUL SYLLABLE TALG) */
    {{'\xed', '\x83', '\x90'}, 3, 0xD0D0}, /* (HANGUL SYLLABLE TAM) */
    {{'\xed', '\x83', '\x91'}, 3, 0xD0D1}, /* (HANGUL SYLLABLE TAB) */
    {{'\xed', '\x83', '\x93'}, 3, 0xD0D3}, /* (HANGUL SYLLABLE TAS) */
    {{'\xed', '\x83', '\x94'}, 3, 0xD0D4}, /* (HANGUL SYLLABLE TASS) */
    {{'\xed', '\x83', '\x95'}, 3, 0xD0D5}, /* (HANGUL SYLLABLE TANG) */
    {{'\xed', '\x83', '\x9c'}, 3, 0xD0DC}, /* (HANGUL SYLLABLE TAE) */
    {{'\xed', '\x83', '\x9d'}, 3, 0xD0DD}, /* (HANGUL SYLLABLE TAEG) */
    {{'\xed', '\x83', '\xa0'}, 3, 0xD0E0}, /* (HANGUL SYLLABLE TAEN) */
    {{'\xed', '\x83', '\xa4'}, 3, 0xD0E4}, /* (HANGUL SYLLABLE TAEL) */
    {{'\xed', '\x83', '\xac'}, 3, 0xD0EC}, /* (HANGUL SYLLABLE TAEM) */
    {{'\xed', '\x83', '\xad'}, 3, 0xD0ED}, /* (HANGUL SYLLABLE TAEB) */
    {{'\xed', '\x83', '\xaf'}, 3, 0xD0EF}, /* (HANGUL SYLLABLE TAES) */
    {{'\xed', '\x83', '\xb0'}, 3, 0xD0F0}, /* (HANGUL SYLLABLE TAESS) */
    {{'\xed', '\x83', '\xb1'}, 3, 0xD0F1}, /* (HANGUL SYLLABLE TAENG) */
    {{'\xed', '\x83', '\xb8'}, 3, 0xD0F8}, /* (HANGUL SYLLABLE TYA) */
    {{'\xed', '\x84', '\x8d'}, 3, 0xD10D}, /* (HANGUL SYLLABLE TYANG) */
    {{'\xed', '\x84', '\xb0'}, 3, 0xD130}, /* (HANGUL SYLLABLE TEO) */
    {{'\xed', '\x84', '\xb1'}, 3, 0xD131}, /* (HANGUL SYLLABLE TEOG) */
    {{'\xed', '\x84', '\xb4'}, 3, 0xD134}, /* (HANGUL SYLLABLE TEON) */
    {{'\xed', '\x84', '\xb8'}, 3, 0xD138}, /* (HANGUL SYLLABLE TEOL) */
    {{'\xed', '\x84', '\xba'}, 3, 0xD13A}, /* (HANGUL SYLLABLE TEOLM) */
    {{'\xed', '\x85', '\x80'}, 3, 0xD140}, /* (HANGUL SYLLABLE TEOM) */
    {{'\xed', '\x85', '\x81'}, 3, 0xD141}, /* (HANGUL SYLLABLE TEOB) */
    {{'\xed', '\x85', '\x83'}, 3, 0xD143}, /* (HANGUL SYLLABLE TEOS) */
    {{'\xed', '\x85', '\x84'}, 3, 0xD144}, /* (HANGUL SYLLABLE TEOSS) */
    {{'\xed', '\x85', '\x85'}, 3, 0xD145}, /* (HANGUL SYLLABLE TEONG) */
    {{'\xed', '\x85', '\x8c'}, 3, 0xD14C}, /* (HANGUL SYLLABLE TE) */
    {{'\xed', '\x85', '\x8d'}, 3, 0xD14D}, /* (HANGUL SYLLABLE TEG) */
    {{'\xed', '\x85', '\x90'}, 3, 0xD150}, /* (HANGUL SYLLABLE TEN) */
    {{'\xed', '\x85', '\x94'}, 3, 0xD154}, /* (HANGUL SYLLABLE TEL) */
    {{'\xed', '\x85', '\x9c'}, 3, 0xD15C}, /* (HANGUL SYLLABLE TEM) */
    {{'\xed', '\x85', '\x9d'}, 3, 0xD15D}, /* (HANGUL SYLLABLE TEB) */
    {{'\xed', '\x85', '\x9f'}, 3, 0xD15F}, /* (HANGUL SYLLABLE TES) */
    {{'\xed', '\x85', '\xa1'}, 3, 0xD161}, /* (HANGUL SYLLABLE TENG) */
    {{'\xed', '\x85', '\xa8'}, 3, 0xD168}, /* (HANGUL SYLLABLE TYEO) */
    {{'\xed', '\x85', '\xac'}, 3, 0xD16C}, /* (HANGUL SYLLABLE TYEON) */
    {{'\xed', '\x85', '\xbc'}, 3, 0xD17C}, /* (HANGUL SYLLABLE TYEOSS) */
    {{'\xed', '\x86', '\x84'}, 3, 0xD184}, /* (HANGUL SYLLABLE TYE) */
    {{'\xed', '\x86', '\x88'}, 3, 0xD188}, /* (HANGUL SYLLABLE TYEN) */
    {{'\xed', '\x86', '\xa0'}, 3, 0xD1A0}, /* (HANGUL SYLLABLE TO) */
    {{'\xed', '\x86', '\xa1'}, 3, 0xD1A1}, /* (HANGUL SYLLABLE TOG) */
    {{'\xed', '\x86', '\xa4'}, 3, 0xD1A4}, /* (HANGUL SYLLABLE TON) */
    {{'\xed', '\x86', '\xa8'}, 3, 0xD1A8}, /* (HANGUL SYLLABLE TOL) */
    {{'\xed', '\x86', '\xb0'}, 3, 0xD1B0}, /* (HANGUL SYLLABLE TOM) */
    {{'\xed', '\x86', '\xb1'}, 3, 0xD1B1}, /* (HANGUL SYLLABLE TOB) */
    {{'\xed', '\x86', '\xb3'}, 3, 0xD1B3}, /* (HANGUL SYLLABLE TOS) */
    {{'\xed', '\x86', '\xb5'}, 3, 0xD1B5}, /* (HANGUL SYLLABLE TONG) */
    {{'\xed', '\x86', '\xba'}, 3, 0xD1BA}, /* (HANGUL SYLLABLE TOP) */
    {{'\xed', '\x86', '\xbc'}, 3, 0xD1BC}, /* (HANGUL SYLLABLE TWA) */
    {{'\xed', '\x87', '\x80'}, 3, 0xD1C0}, /* (HANGUL SYLLABLE TWAN) */
    {{'\xed', '\x87', '\x98'}, 3, 0xD1D8}, /* (HANGUL SYLLABLE TWAE) */
    {{'\xed', '\x87', '\xb4'}, 3, 0xD1F4}, /* (HANGUL SYLLABLE TOE) */
    {{'\xed', '\x87', '\xb8'}, 3, 0xD1F8}, /* (HANGUL SYLLABLE TOEN) */
    {{'\xed', '\x88', '\x87'}, 3, 0xD207}, /* (HANGUL SYLLABLE TOES) */
    {{'\xed', '\x88', '\x89'}, 3, 0xD209}, /* (HANGUL SYLLABLE TOENG) */
    {{'\xed', '\x88', '\x90'}, 3, 0xD210}, /* (HANGUL SYLLABLE TYO) */
    {{'\xed', '\x88', '\xac'}, 3, 0xD22C}, /* (HANGUL SYLLABLE TU) */
    {{'\xed', '\x88', '\xad'}, 3, 0xD22D}, /* (HANGUL SYLLABLE TUG) */
    {{'\xed', '\x88', '\xb0'}, 3, 0xD230}, /* (HANGUL SYLLABLE TUN) */
    {{'\xed', '\x88', '\xb4'}, 3, 0xD234}, /* (HANGUL SYLLABLE TUL) */
    {{'\xed', '\x88', '\xbc'}, 3, 0xD23C}, /* (HANGUL SYLLABLE TUM) */
    {{'\xed', '\x88', '\xbd'}, 3, 0xD23D}, /* (HANGUL SYLLABLE TUB) */
    {{'\xed', '\x88', '\xbf'}, 3, 0xD23F}, /* (HANGUL SYLLABLE TUS) */
    {{'\xed', '\x89', '\x81'}, 3, 0xD241}, /* (HANGUL SYLLABLE TUNG) */
    {{'\xed', '\x89', '\x88'}, 3, 0xD248}, /* (HANGUL SYLLABLE TWEO) */
    {{'\xed', '\x89', '\x9c'}, 3, 0xD25C}, /* (HANGUL SYLLABLE TWEOSS) */
    {{'\xed', '\x9e', '\x8d'}, 3, 0xD78D}, /* (HANGUL SYLLABLE HINJ) */
    {{'\xed', '\x9e', '\x8e'}, 3, 0xD78E}, /* (HANGUL SYLLABLE HINH) */
    {{'\xed', '\x9e', '\x8f'}, 3, 0xD78F}, /* (HANGUL SYLLABLE HID) */
    {{'\xed', '\x9e', '\x91'}, 3, 0xD791}, /* (HANGUL SYLLABLE HILG) */
    {{'\xed', '\x9e', '\x92'}, 3, 0xD792}, /* (HANGUL SYLLABLE HILM) */
    {{'\xed', '\x9e', '\x93'}, 3, 0xD793}, /* (HANGUL SYLLABLE HILB) */
    {{'\xed', '\x9e', '\x94'}, 3, 0xD794}, /* (HANGUL SYLLABLE HILS) */
    {{'\xed', '\x9e', '\x95'}, 3, 0xD795}, /* (HANGUL SYLLABLE HILT) */
    {{'\xed', '\x9e', '\x96'}, 3, 0xD796}, /* (HANGUL SYLLABLE HILP) */
    {{'\xed', '\x9e', '\x97'}, 3, 0xD797}, /* (HANGUL SYLLABLE HILH) */
    {{'\xed', '\x9e', '\x9a'}, 3, 0xD79A}, /* (HANGUL SYLLABLE HIBS) */
    {{'\xed', '\x9e', '\x9c'}, 3, 0xD79C}, /* (HANGUL SYLLABLE HISS) */
    {{'\xed', '\x9e', '\x9e'}, 3, 0xD79E}, /* (HANGUL SYLLABLE HIJ) */
    {{'\xed', '\x9e', '\x9f'}, 3, 0xD79F}, /* (HANGUL SYLLABLE HIC) */
    {{'\xed', '\x9e', '\xa0'}, 3, 0xD7A0}, /* (HANGUL SYLLABLE HIK) */
    {{'\xed', '\x9e', '\xa1'}, 3, 0xD7A1}, /* (HANGUL SYLLABLE HIT) */
    {{'\xed', '\x9e', '\xa2'}, 3, 0xD7A2}, /* (HANGUL SYLLABLE HIP) */
    {{'\xed', '\x9e', '\xa3'}, 3, 0xD7A3}, /* (HANGUL SYLLABLE HIH) */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{'\xed', '\x89', '\xa4'}, 3, 0xD264}, /* (HANGUL SYLLABLE TWE) */
    {{'\xed', '\x8a', '\x80'}, 3, 0xD280}, /* (HANGUL SYLLABLE TWI) */
    {{'\xed', '\x8a', '\x81'}, 3, 0xD281}, /* (HANGUL SYLLABLE TWIG) */
    {{'\xed', '\x8a', '\x84'}, 3, 0xD284}, /* (HANGUL SYLLABLE TWIN) */
    {{'\xed', '\x8a', '\x88'}, 3, 0xD288}, /* (HANGUL SYLLABLE TWIL) */
    {{'\xed', '\x8a', '\x90'}, 3, 0xD290}, /* (HANGUL SYLLABLE TWIM) */
    {{'\xed', '\x8a', '\x91'}, 3, 0xD291}, /* (HANGUL SYLLABLE TWIB) */
    {{'\xed', '\x8a', '\x95'}, 3, 0xD295}, /* (HANGUL SYLLABLE TWING) */
    {{'\xed', '\x8a', '\x9c'}, 3, 0xD29C}, /* (HANGUL SYLLABLE TYU) */
    {{'\xed', '\x8a', '\xa0'}, 3, 0xD2A0}, /* (HANGUL SYLLABLE TYUN) */
    {{'\xed', '\x8a', '\xa4'}, 3, 0xD2A4}, /* (HANGUL SYLLABLE TYUL) */
    {{'\xed', '\x8a', '\xac'}, 3, 0xD2AC}, /* (HANGUL SYLLABLE TYUM) */
    {{'\xed', '\x8a', '\xb1'}, 3, 0xD2B1}, /* (HANGUL SYLLABLE TYUNG) */
    {{'\xed', '\x8a', '\xb8'}, 3, 0xD2B8}, /* (HANGUL SYLLABLE TEU) */
    {{'\xed', '\x8a', '\xb9'}, 3, 0xD2B9}, /* (HANGUL SYLLABLE TEUG) */
    {{'\xed', '\x8a', '\xbc'}, 3, 0xD2BC}, /* (HANGUL SYLLABLE TEUN) */
    {{'\xed', '\x8a', '\xbf'}, 3, 0xD2BF}, /* (HANGUL SYLLABLE TEUD) */
    {{'\xed', '\x8b', '\x80'}, 3, 0xD2C0}, /* (HANGUL SYLLABLE TEUL) */
    {{'\xed', '\x8b', '\x82'}, 3, 0xD2C2}, /* (HANGUL SYLLABLE TEULM) */
    {{'\xed', '\x8b', '\x88'}, 3, 0xD2C8}, /* (HANGUL SYLLABLE TEUM) */
    {{'\xed', '\x8b', '\x89'}, 3, 0xD2C9}, /* (HANGUL SYLLABLE TEUB) */
    {{'\xed', '\x8b', '\x8b'}, 3, 0xD2CB}, /* (HANGUL SYLLABLE TEUS) */
    {{'\xed', '\x8b', '\x94'}, 3, 0xD2D4}, /* (HANGUL SYLLABLE TYI) */
    {{'\xed', '\x8b', '\x98'}, 3, 0xD2D8}, /* (HANGUL SYLLABLE TYIN) */
    {{'\xed', '\x8b', '\x9c'}, 3, 0xD2DC}, /* (HANGUL SYLLABLE TYIL) */
    {{'\xed', '\x8b', '\xa4'}, 3, 0xD2E4}, /* (HANGUL SYLLABLE TYIM) */
    {{'\xed', '\x8b', '\xa5'}, 3, 0xD2E5}, /* (HANGUL SYLLABLE TYIB) */
    {{'\xed', '\x8b', '\xb0'}, 3, 0xD2F0}, /* (HANGUL SYLLABLE TI) */
    {{'\xed', '\x8b', '\xb1'}, 3, 0xD2F1}, /* (HANGUL SYLLABLE TIG) */
    {{'\xed', '\x8b', '\xb4'}, 3, 0xD2F4}, /* (HANGUL SYLLABLE TIN) */
    {{'\xed', '\x8b', '\xb8'}, 3, 0xD2F8}, /* (HANGUL SYLLABLE TIL) */
    {{'\xed', '\x8c', '\x80'}, 3, 0xD300}, /* (HANGUL SYLLABLE TIM) */
    {{'\xed', '\x8c', '\x81'}, 3, 0xD301}, /* (HANGUL SYLLABLE TIB) */
    {{'\xed', '\x8c', '\x83'}, 3, 0xD303}, /* (HANGUL SYLLABLE TIS) */
    {{'\xed', '\x8c', '\x85'}, 3, 0xD305}, /* (HANGUL SYLLABLE TING) */
    {{'\xed', '\x8c', '\x8c'}, 3, 0xD30C}, /* (HANGUL SYLLABLE PA) */
    {{'\xed', '\x8c', '\x8d'}, 3, 0xD30D}, /* (HANGUL SYLLABLE PAG) */
    {{'\xed', '\x8c', '\x8e'}, 3, 0xD30E}, /* (HANGUL SYLLABLE PAGG) */
    {{'\xed', '\x8c', '\x90'}, 3, 0xD310}, /* (HANGUL SYLLABLE PAN) */
    {{'\xed', '\x8c', '\x94'}, 3, 0xD314}, /* (HANGUL SYLLABLE PAL) */
    {{'\xed', '\x8c', '\x96'}, 3, 0xD316}, /* (HANGUL SYLLABLE PALM) */
    {{'\xed', '\x8c', '\x9c'}, 3, 0xD31C}, /* (HANGUL SYLLABLE PAM) */
    {{'\xed', '\x8c', '\x9d'}, 3, 0xD31D}, /* (HANGUL SYLLABLE PAB) */
    {{'\xed', '\x8c', '\x9f'}, 3, 0xD31F}, /* (HANGUL SYLLABLE PAS) */
    {{'\xed', '\x8c', '\xa0'}, 3, 0xD320}, /* (HANGUL SYLLABLE PASS) */
    {{'\xed', '\x8c', '\xa1'}, 3, 0xD321}, /* (HANGUL SYLLABLE PANG) */
    {{'\xed', '\x8c', '\xa5'}, 3, 0xD325}, /* (HANGUL SYLLABLE PAT) */
    {{'\xed', '\x8c', '\xa8'}, 3, 0xD328}, /* (HANGUL SYLLABLE PAE) */
    {{'\xed', '\x8c', '\xa9'}, 3, 0xD329}, /* (HANGUL SYLLABLE PAEG) */
    {{'\xed', '\x8c', '\xac'}, 3, 0xD32C}, /* (HANGUL SYLLABLE PAEN) */
    {{'\xed', '\x8c', '\xb0'}, 3, 0xD330}, /* (HANGUL SYLLABLE PAEL) */
    {{'\xed', '\x8c', '\xb8'}, 3, 0xD338}, /* (HANGUL SYLLABLE PAEM) */
    {{'\xed', '\x8c', '\xb9'}, 3, 0xD339}, /* (HANGUL SYLLABLE PAEB) */
    {{'\xed', '\x8c', '\xbb'}, 3, 0xD33B}, /* (HANGUL SYLLABLE PAES) */
    {{'\xed', '\x8c', '\xbc'}, 3, 0xD33C}, /* (HANGUL SYLLABLE PAESS) */
    {{'\xed', '\x8c', '\xbd'}, 3, 0xD33D}, /* (HANGUL SYLLABLE PAENG) */
    {{'\xed', '\x8d', '\x84'}, 3, 0xD344}, /* (HANGUL SYLLABLE PYA) */
    {{'\xed', '\x8d', '\x85'}, 3, 0xD345}, /* (HANGUL SYLLABLE PYAG) */
    {{'\xed', '\x8d', '\xbc'}, 3, 0xD37C}, /* (HANGUL SYLLABLE PEO) */
    {{'\xed', '\x8d', '\xbd'}, 3, 0xD37D}, /* (HANGUL SYLLABLE PEOG) */
    {{'\xed', '\x8e', '\x80'}, 3, 0xD380}, /* (HANGUL SYLLABLE PEON) */
    {{'\xed', '\x8e', '\x84'}, 3, 0xD384}, /* (HANGUL SYLLABLE PEOL) */
    {{'\xed', '\x8e', '\x8c'}, 3, 0xD38C}, /* (HANGUL SYLLABLE PEOM) */
    {{'\xed', '\x8e', '\x8d'}, 3, 0xD38D}, /* (HANGUL SYLLABLE PEOB) */
    {{'\xed', '\x8e', '\x8f'}, 3, 0xD38F}, /* (HANGUL SYLLABLE PEOS) */
    {{'\xed', '\x8e', '\x90'}, 3, 0xD390}, /* (HANGUL SYLLABLE PEOSS) */
    {{'\xed', '\x8e', '\x91'}, 3, 0xD391}, /* (HANGUL SYLLABLE PEONG) */
    {{'\xed', '\x8e', '\x98'}, 3, 0xD398}, /* (HANGUL SYLLABLE PE) */
    {{'\xed', '\x8e', '\x99'}, 3, 0xD399}, /* (HANGUL SYLLABLE PEG) */
    {{'\xed', '\x8e', '\x9c'}, 3, 0xD39C}, /* (HANGUL SYLLABLE PEN) */
    {{'\xed', '\x8e', '\xa0'}, 3, 0xD3A0}, /* (HANGUL SYLLABLE PEL) */
    {{'\xed', '\x8e', '\xa8'}, 3, 0xD3A8}, /* (HANGUL SYLLABLE PEM) */
    {{'\xed', '\x8e', '\xa9'}, 3, 0xD3A9}, /* (HANGUL SYLLABLE PEB) */
    {{'\xed', '\x8e', '\xab'}, 3, 0xD3AB}, /* (HANGUL SYLLABLE PES) */
    {{'\xed', '\x8e', '\xad'}, 3, 0xD3AD}, /* (HANGUL SYLLABLE PENG) */
    {{'\xed', '\x8e', '\xb4'}, 3, 0xD3B4}, /* (HANGUL SYLLABLE PYEO) */
    {{'\xed', '\x8e', '\xb8'}, 3, 0xD3B8}, /* (HANGUL SYLLABLE PYEON) */
    {{'\xed', '\x8e', '\xbc'}, 3, 0xD3BC}, /* (HANGUL SYLLABLE PYEOL) */
    {{'\xed', '\x8f', '\x84'}, 3, 0xD3C4}, /* (HANGUL SYLLABLE PYEOM) */
    {{'\xed', '\x8f', '\x85'}, 3, 0xD3C5}, /* (HANGUL SYLLABLE PYEOB) */
    {{'\xed', '\x8f', '\x88'}, 3, 0xD3C8}, /* (HANGUL SYLLABLE PYEOSS) */
    {{'\xed', '\x8f', '\x89'}, 3, 0xD3C9}, /* (HANGUL SYLLABLE PYEONG) */
    {{'\xed', '\x8f', '\x90'}, 3, 0xD3D0}, /* (HANGUL SYLLABLE PYE) */
    {{'\xed', '\x8f', '\x98'}, 3, 0xD3D8}, /* (HANGUL SYLLABLE PYEL) */
    {{'\xed', '\x8f', '\xa1'}, 3, 0xD3E1}, /* (HANGUL SYLLABLE PYEB) */
    {{'\xed', '\x8f', '\xa3'}, 3, 0xD3E3}, /* (HANGUL SYLLABLE PYES) */
    {{'\xed', '\x8f', '\xac'}, 3, 0xD3EC}, /* (HANGUL SYLLABLE PO) */
    {{'\xed', '\x8f', '\xad'}, 3, 0xD3ED}, /* (HANGUL SYLLABLE POG) */
    {{'\xed', '\x8f', '\xb0'}, 3, 0xD3F0}, /* (HANGUL SYLLABLE PON) */
    {{'\xed', '\x8f', '\xb4'}, 3, 0xD3F4}, /* (HANGUL SYLLABLE POL) */
    {{'\xed', '\x8f', '\xbc'}, 3, 0xD3FC}, /* (HANGUL SYLLABLE POM) */
    {{'\xed', '\x8f', '\xbd'}, 3, 0xD3FD}, /* (HANGUL SYLLABLE POB) */
    {{'\xed', '\x8f', '\xbf'}, 3, 0xD3FF}, /* (HANGUL SYLLABLE POS) */
    {{'\xed', '\x90', '\x81'}, 3, 0xD401}, /* (HANGUL SYLLABLE PONG) */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{'\xed', '\x90', '\x88'}, 3, 0xD408}, /* (HANGUL SYLLABLE PWA) */
    {{'\xed', '\x90', '\x9d'}, 3, 0xD41D}, /* (HANGUL SYLLABLE PWANG) */
    {{'\xed', '\x91', '\x80'}, 3, 0xD440}, /* (HANGUL SYLLABLE POE) */
    {{'\xed', '\x91', '\x84'}, 3, 0xD444}, /* (HANGUL SYLLABLE POEN) */
    {{'\xed', '\x91', '\x9c'}, 3, 0xD45C}, /* (HANGUL SYLLABLE PYO) */
    {{'\xed', '\x91', '\xa0'}, 3, 0xD460}, /* (HANGUL SYLLABLE PYON) */
    {{'\xed', '\x91', '\xa4'}, 3, 0xD464}, /* (HANGUL SYLLABLE PYOL) */
    {{'\xed', '\x91', '\xad'}, 3, 0xD46D}, /* (HANGUL SYLLABLE PYOB) */
    {{'\xed', '\x91', '\xaf'}, 3, 0xD46F}, /* (HANGUL SYLLABLE PYOS) */
    {{'\xed', '\x91', '\xb8'}, 3, 0xD478}, /* (HANGUL SYLLABLE PU) */
    {{'\xed', '\x91', '\xb9'}, 3, 0xD479}, /* (HANGUL SYLLABLE PUG) */
    {{'\xed', '\x91', '\xbc'}, 3, 0xD47C}, /* (HANGUL SYLLABLE PUN) */
    {{'\xed', '\x91', '\xbf'}, 3, 0xD47F}, /* (HANGUL SYLLABLE PUD) */
    {{'\xed', '\x92', '\x80'}, 3, 0xD480}, /* (HANGUL SYLLABLE PUL) */
    {{'\xed', '\x92', '\x82'}, 3, 0xD482}, /* (HANGUL SYLLABLE PULM) */
    {{'\xed', '\x92', '\x88'}, 3, 0xD488}, /* (HANGUL SYLLABLE PUM) */
    {{'\xed', '\x92', '\x89'}, 3, 0xD489}, /* (HANGUL SYLLABLE PUB) */
    {{'\xed', '\x92', '\x8b'}, 3, 0xD48B}, /* (HANGUL SYLLABLE PUS) */
    {{'\xed', '\x92', '\x8d'}, 3, 0xD48D}, /* (HANGUL SYLLABLE PUNG) */
    {{'\xed', '\x92', '\x94'}, 3, 0xD494}, /* (HANGUL SYLLABLE PWEO) */
    {{'\xed', '\x92', '\xa9'}, 3, 0xD4A9}, /* (HANGUL SYLLABLE PWEONG) */
    {{'\xed', '\x93', '\x8c'}, 3, 0xD4CC}, /* (HANGUL SYLLABLE PWI) */
    {{'\xed', '\x93', '\x90'}, 3, 0xD4D0}, /* (HANGUL SYLLABLE PWIN) */
    {{'\xed', '\x93', '\x94'}, 3, 0xD4D4}, /* (HANGUL SYLLABLE PWIL) */
    {{'\xed', '\x93', '\x9c'}, 3, 0xD4DC}, /* (HANGUL SYLLABLE PWIM) */
    {{'\xed', '\x93', '\x9f'}, 3, 0xD4DF}, /* (HANGUL SYLLABLE PWIS) */
    {{'\xed', '\x93', '\xa8'}, 3, 0xD4E8}, /* (HANGUL SYLLABLE PYU) */
    {{'\xed', '\x93', '\xac'}, 3, 0xD4EC}, /* (HANGUL SYLLABLE PYUN) */
    {{'\xed', '\x93', '\xb0'}, 3, 0xD4F0}, /* (HANGUL SYLLABLE PYUL) */
    {{'\xed', '\x93', '\xb8'}, 3, 0xD4F8}, /* (HANGUL SYLLABLE PYUM) */
    {{'\xed', '\x93', '\xbb'}, 3, 0xD4FB}, /* (HANGUL SYLLABLE PYUS) */
    {{'\xed', '\x93', '\xbd'}, 3, 0xD4FD}, /* (HANGUL SYLLABLE PYUNG) */
    {{'\xed', '\x94', '\x84'}, 3, 0xD504}, /* (HANGUL SYLLABLE PEU) */
    {{'\xed', '\x94', '\x88'}, 3, 0xD508}, /* (HANGUL SYLLABLE PEUN) */
    {{'\xed', '\x94', '\x8c'}, 3, 0xD50C}, /* (HANGUL SYLLABLE PEUL) */
    {{'\xed', '\x94', '\x94'}, 3, 0xD514}, /* (HANGUL SYLLABLE PEUM) */
    {{'\xed', '\x94', '\x95'}, 3, 0xD515}, /* (HANGUL SYLLABLE PEUB) */
    {{'\xed', '\x94', '\x97'}, 3, 0xD517}, /* (HANGUL SYLLABLE PEUS) */
    {{'\xed', '\x94', '\xbc'}, 3, 0xD53C}, /* (HANGUL SYLLABLE PI) */
    {{'\xed', '\x94', '\xbd'}, 3, 0xD53D}, /* (HANGUL SYLLABLE PIG) */
    {{'\xed', '\x95', '\x80'}, 3, 0xD540}, /* (HANGUL SYLLABLE PIN) */
    {{'\xed', '\x95', '\x84'}, 3, 0xD544}, /* (HANGUL SYLLABLE PIL) */
    {{'\xed', '\x95', '\x8c'}, 3, 0xD54C}, /* (HANGUL SYLLABLE PIM) */
    {{'\xed', '\x95', '\x8d'}, 3, 0xD54D}, /* (HANGUL SYLLABLE PIB) */
    {{'\xed', '\x95', '\x8f'}, 3, 0xD54F}, /* (HANGUL SYLLABLE PIS) */
    {{'\xed', '\x95', '\x91'}, 3, 0xD551}, /* (HANGUL SYLLABLE PING) */
    {{'\xed', '\x95', '\x98'}, 3, 0xD558}, /* (HANGUL SYLLABLE HA) */
    {{'\xed', '\x95', '\x99'}, 3, 0xD559}, /* (HANGUL SYLLABLE HAG) */
    {{'\xed', '\x95', '\x9c'}, 3, 0xD55C}, /* (HANGUL SYLLABLE HAN) */
    {{'\xed', '\x95', '\xa0'}, 3, 0xD560}, /* (HANGUL SYLLABLE HAL) */
    {{'\xed', '\x95', '\xa5'}, 3, 0xD565}, /* (HANGUL SYLLABLE HALT) */
    {{'\xed', '\x95', '\xa8'}, 3, 0xD568}, /* (HANGUL SYLLABLE HAM) */
    {{'\xed', '\x95', '\xa9'}, 3, 0xD569}, /* (HANGUL SYLLABLE HAB) */
    {{'\xed', '\x95', '\xab'}, 3, 0xD56B}, /* (HANGUL SYLLABLE HAS) */
    {{'\xed', '\x95', '\xad'}, 3, 0xD56D}, /* (HANGUL SYLLABLE HANG) */
    {{'\xed', '\x95', '\xb4'}, 3, 0xD574}, /* (HANGUL SYLLABLE HAE) */
    {{'\xed', '\x95', '\xb5'}, 3, 0xD575}, /* (HANGUL SYLLABLE HAEG) */
    {{'\xed', '\x95', '\xb8'}, 3, 0xD578}, /* (HANGUL SYLLABLE HAEN) */
    {{'\xed', '\x95', '\xbc'}, 3, 0xD57C}, /* (HANGUL SYLLABLE HAEL) */
    {{'\xed', '\x96', '\x84'}, 3, 0xD584}, /* (HANGUL SYLLABLE HAEM) */
    {{'\xed', '\x96', '\x85'}, 3, 0xD585}, /* (HANGUL SYLLABLE HAEB) */
    {{'\xed', '\x96', '\x87'}, 3, 0xD587}, /* (HANGUL SYLLABLE HAES) */
    {{'\xed', '\x96', '\x88'}, 3, 0xD588}, /* (HANGUL SYLLABLE HAESS) */
    {{'\xed', '\x96', '\x89'}, 3, 0xD589}, /* (HANGUL SYLLABLE HAENG) */
    {{'\xed', '\x96', '\x90'}, 3, 0xD590}, /* (HANGUL SYLLABLE HYA) */
    {{'\xed', '\x96', '\xa5'}, 3, 0xD5A5}, /* (HANGUL SYLLABLE HYANG) */
    {{'\xed', '\x97', '\x88'}, 3, 0xD5C8}, /* (HANGUL SYLLABLE HEO) */
    {{'\xed', '\x97', '\x89'}, 3, 0xD5C9}, /* (HANGUL SYLLABLE HEOG) */
    {{'\xed', '\x97', '\x8c'}, 3, 0xD5CC}, /* (HANGUL SYLLABLE HEON) */
    {{'\xed', '\x97', '\x90'}, 3, 0xD5D0}, /* (HANGUL SYLLABLE HEOL) */
    {{'\xed', '\x97', '\x92'}, 3, 0xD5D2}, /* (HANGUL SYLLABLE HEOLM) */
    {{'\xed', '\x97', '\x98'}, 3, 0xD5D8}, /* (HANGUL SYLLABLE HEOM) */
    {{'\xed', '\x97', '\x99'}, 3, 0xD5D9}, /* (HANGUL SYLLABLE HEOB) */
    {{'\xed', '\x97', '\x9b'}, 3, 0xD5DB}, /* (HANGUL SYLLABLE HEOS) */
    {{'\xed', '\x97', '\x9d'}, 3, 0xD5DD}, /* (HANGUL SYLLABLE HEONG) */
    {{'\xed', '\x97', '\xa4'}, 3, 0xD5E4}, /* (HANGUL SYLLABLE HE) */
    {{'\xed', '\x97', '\xa5'}, 3, 0xD5E5}, /* (HANGUL SYLLABLE HEG) */
    {{'\xed', '\x97', '\xa8'}, 3, 0xD5E8}, /* (HANGUL SYLLABLE HEN) */
    {{'\xed', '\x97', '\xac'}, 3, 0xD5EC}, /* (HANGUL SYLLABLE HEL) */
    {{'\xed', '\x97', '\xb4'}, 3, 0xD5F4}, /* (HANGUL SYLLABLE HEM) */
    {{'\xed', '\x97', '\xb5'}, 3, 0xD5F5}, /* (HANGUL SYLLABLE HEB) */
    {{'\xed', '\x97', '\xb7'}, 3, 0xD5F7}, /* (HANGUL SYLLABLE HES) */
    {{'\xed', '\x97', '\xb9'}, 3, 0xD5F9}, /* (HANGUL SYLLABLE HENG) */
    {{'\xed', '\x98', '\x80'}, 3, 0xD600}, /* (HANGUL SYLLABLE HYEO) */
    {{'\xed', '\x98', '\x81'}, 3, 0xD601}, /* (HANGUL SYLLABLE HYEOG) */
    {{'\xed', '\x98', '\x84'}, 3, 0xD604}, /* (HANGUL SYLLABLE HYEON) */
    {{'\xed', '\x98', '\x88'}, 3, 0xD608}, /* (HANGUL SYLLABLE HYEOL) */
    {{'\xed', '\x98', '\x90'}, 3, 0xD610}, /* (HANGUL SYLLABLE HYEOM) */
    {{'\xed', '\x98', '\x91'}, 3, 0xD611}, /* (HANGUL SYLLABLE HYEOB) */
    {{'\xed', '\x98', '\x93'}, 3, 0xD613}, /* (HANGUL SYLLABLE HYEOS) */
    {{'\xed', '\x98', '\x94'}, 3, 0xD614}, /* (HANGUL SYLLABLE HYEOSS) */
    {{'\xed', '\x98', '\x95'}, 3, 0xD615}, /* (HANGUL SYLLABLE HYEONG) */
    {{'\xed', '\x98', '\x9c'}, 3, 0xD61C}, /* (HANGUL SYLLABLE HYE) */
    {{'\xed', '\x98', '\xa0'}, 3, 0xD620}, /* (HANGUL SYLLABLE HYEN) */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{'\xed', '\x98', '\xa4'}, 3, 0xD624}, /* (HANGUL SYLLABLE HYEL) */
    {{'\xed', '\x98', '\xad'}, 3, 0xD62D}, /* (HANGUL SYLLABLE HYEB) */
    {{'\xed', '\x98', '\xb8'}, 3, 0xD638}, /* (HANGUL SYLLABLE HO) */
    {{'\xed', '\x98', '\xb9'}, 3, 0xD639}, /* (HANGUL SYLLABLE HOG) */
    {{'\xed', '\x98', '\xbc'}, 3, 0xD63C}, /* (HANGUL SYLLABLE HON) */
    {{'\xed', '\x99', '\x80'}, 3, 0xD640}, /* (HANGUL SYLLABLE HOL) */
    {{'\xed', '\x99', '\x85'}, 3, 0xD645}, /* (HANGUL SYLLABLE HOLT) */
    {{'\xed', '\x99', '\x88'}, 3, 0xD648}, /* (HANGUL SYLLABLE HOM) */
    {{'\xed', '\x99', '\x89'}, 3, 0xD649}, /* (HANGUL SYLLABLE HOB) */
    {{'\xed', '\x99', '\x8b'}, 3, 0xD64B}, /* (HANGUL SYLLABLE HOS) */
    {{'\xed', '\x99', '\x8d'}, 3, 0xD64D}, /* (HANGUL SYLLABLE HONG) */
    {{'\xed', '\x99', '\x91'}, 3, 0xD651}, /* (HANGUL SYLLABLE HOT) */
    {{'\xed', '\x99', '\x94'}, 3, 0xD654}, /* (HANGUL SYLLABLE HWA) */
    {{'\xed', '\x99', '\x95'}, 3, 0xD655}, /* (HANGUL SYLLABLE HWAG) */
    {{'\xed', '\x99', '\x98'}, 3, 0xD658}, /* (HANGUL SYLLABLE HWAN) */
    {{'\xed', '\x99', '\x9c'}, 3, 0xD65C}, /* (HANGUL SYLLABLE HWAL) */
    {{'\xed', '\x99', '\xa7'}, 3, 0xD667}, /* (HANGUL SYLLABLE HWAS) */
    {{'\xed', '\x99', '\xa9'}, 3, 0xD669}, /* (HANGUL SYLLABLE HWANG) */
    {{'\xed', '\x99', '\xb0'}, 3, 0xD670}, /* (HANGUL SYLLABLE HWAE) */
    {{'\xed', '\x99', '\xb1'}, 3, 0xD671}, /* (HANGUL SYLLABLE HWAEG) */
    {{'\xed', '\x99', '\xb4'}, 3, 0xD674}, /* (HANGUL SYLLABLE HWAEN) */
    {{'\xed', '\x9a', '\x83'}, 3, 0xD683}, /* (HANGUL SYLLABLE HWAES) */
    {{'\xed', '\x9a', '\x85'}, 3, 0xD685}, /* (HANGUL SYLLABLE HWAENG) */
    {{'\xed', '\x9a', '\x8c'}, 3, 0xD68C}, /* (HANGUL SYLLABLE HOE) */
    {{'\xed', '\x9a', '\x8d'}, 3, 0xD68D}, /* (HANGUL SYLLABLE HOEG) */
    {{'\xed', '\x9a', '\x90'}, 3, 0xD690}, /* (HANGUL SYLLABLE HOEN) */
    {{'\xed', '\x9a', '\x94'}, 3, 0xD694}, /* (HANGUL SYLLABLE HOEL) */
    {{'\xed', '\x9a', '\x9d'}, 3, 0xD69D}, /* (HANGUL SYLLABLE HOEB) */
    {{'\xed', '\x9a', '\x9f'}, 3, 0xD69F}, /* (HANGUL SYLLABLE HOES) */
    {{'\xed', '\x9a', '\xa1'}, 3, 0xD6A1}, /* (HANGUL SYLLABLE HOENG) */
    {{'\xed', '\x9a', '\xa8'}, 3, 0xD6A8}, /* (HANGUL SYLLABLE HYO) */
    {{'\xed', '\x9a', '\xac'}, 3, 0xD6AC}, /* (HANGUL SYLLABLE HYON) */
    {{'\xed', '\x9a', '\xb0'}, 3, 0xD6B0}, /* (HANGUL SYLLABLE HYOL) */
    {{'\xed', '\x9a', '\xb9'}, 3, 0xD6B9}, /* (HANGUL SYLLABLE HYOB) */
    {{'\xed', '\x9a', '\xbb'}, 3, 0xD6BB}, /* (HANGUL SYLLABLE HYOS) */
    {{'\xed', '\x9b', '\x84'}, 3, 0xD6C4}, /* (HANGUL SYLLABLE HU) */
    {{'\xed', '\x9b', '\x85'}, 3, 0xD6C5}, /* (HANGUL SYLLABLE HUG) */
    {{'\xed', '\x9b', '\x88'}, 3, 0xD6C8}, /* (HANGUL SYLLABLE HUN) */
    {{'\xed', '\x9b', '\x8c'}, 3, 0xD6CC}, /* (HANGUL SYLLABLE HUL) */
    {{'\xed', '\x9b', '\x91'}, 3, 0xD6D1}, /* (HANGUL SYLLABLE HULT) */
    {{'\xed', '\x9b', '\x94'}, 3, 0xD6D4}, /* (HANGUL SYLLABLE HUM) */
    {{'\xed', '\x9b', '\x97'}, 3, 0xD6D7}, /* (HANGUL SYLLABLE HUS) */
    {{'\xed', '\x9b', '\x99'}, 3, 0xD6D9}, /* (HANGUL SYLLABLE HUNG) */
    {{'\xed', '\x9b', '\xa0'}, 3, 0xD6E0}, /* (HANGUL SYLLABLE HWEO) */
    {{'\xed', '\x9b', '\xa4'}, 3, 0xD6E4}, /* (HANGUL SYLLABLE HWEON) */
    {{'\xed', '\x9b', '\xa8'}, 3, 0xD6E8}, /* (HANGUL SYLLABLE HWEOL) */
    {{'\xed', '\x9b', '\xb0'}, 3, 0xD6F0}, /* (HANGUL SYLLABLE HWEOM) */
    {{'\xed', '\x9b', '\xb5'}, 3, 0xD6F5}, /* (HANGUL SYLLABLE HWEONG) */
    {{'\xed', '\x9b', '\xbc'}, 3, 0xD6FC}, /* (HANGUL SYLLABLE HWE) */
    {{'\xed', '\x9b', '\xbd'}, 3, 0xD6FD}, /* (HANGUL SYLLABLE HWEG) */
    {{'\xed', '\x9c', '\x80'}, 3, 0xD700}, /* (HANGUL SYLLABLE HWEN) */
    {{'\xed', '\x9c', '\x84'}, 3, 0xD704}, /* (HANGUL SYLLABLE HWEL) */
    {{'\xed', '\x9c', '\x91'}, 3, 0xD711}, /* (HANGUL SYLLABLE HWENG) */
    {{'\xed', '\x9c', '\x98'}, 3, 0xD718}, /* (HANGUL SYLLABLE HWI) */
    {{'\xed', '\x9c', '\x99'}, 3, 0xD719}, /* (HANGUL SYLLABLE HWIG) */
    {{'\xed', '\x9c', '\x9c'}, 3, 0xD71C}, /* (HANGUL SYLLABLE HWIN) */
    {{'\xed', '\x9c', '\xa0'}, 3, 0xD720}, /* (HANGUL SYLLABLE HWIL) */
    {{'\xed', '\x9c', '\xa8'}, 3, 0xD728}, /* (HANGUL SYLLABLE HWIM) */
    {{'\xed', '\x9c', '\xa9'}, 3, 0xD729}, /* (HANGUL SYLLABLE HWIB) */
    {{'\xed', '\x9c', '\xab'}, 3, 0xD72B}, /* (HANGUL SYLLABLE HWIS) */
    {{'\xed', '\x9c', '\xad'}, 3, 0xD72D}, /* (HANGUL SYLLABLE HWING) */
    {{'\xed', '\x9c', '\xb4'}, 3, 0xD734}, /* (HANGUL SYLLABLE HYU) */
    {{'\xed', '\x9c', '\xb5'}, 3, 0xD735}, /* (HANGUL SYLLABLE HYUG) */
    {{'\xed', '\x9c', '\xb8'}, 3, 0xD738}, /* (HANGUL SYLLABLE HYUN) */
    {{'\xed', '\x9c', '\xbc'}, 3, 0xD73C}, /* (HANGUL SYLLABLE HYUL) */
    {{'\xed', '\x9d', '\x84'}, 3, 0xD744}, /* (HANGUL SYLLABLE HYUM) */
    {{'\xed', '\x9d', '\x87'}, 3, 0xD747}, /* (HANGUL SYLLABLE HYUS) */
    {{'\xed', '\x9d', '\x89'}, 3, 0xD749}, /* (HANGUL SYLLABLE HYUNG) */
    {{'\xed', '\x9d', '\x90'}, 3, 0xD750}, /* (HANGUL SYLLABLE HEU) */
    {{'\xed', '\x9d', '\x91'}, 3, 0xD751}, /* (HANGUL SYLLABLE HEUG) */
    {{'\xed', '\x9d', '\x94'}, 3, 0xD754}, /* (HANGUL SYLLABLE HEUN) */
    {{'\xed', '\x9d', '\x96'}, 3, 0xD756}, /* (HANGUL SYLLABLE HEUNH) */
    {{'\xed', '\x9d', '\x97'}, 3, 0xD757}, /* (HANGUL SYLLABLE HEUD) */
    {{'\xed', '\x9d', '\x98'}, 3, 0xD758}, /* (HANGUL SYLLABLE HEUL) */
    {{'\xed', '\x9d', '\x99'}, 3, 0xD759}, /* (HANGUL SYLLABLE HEULG) */
    {{'\xed', '\x9d', '\xa0'}, 3, 0xD760}, /* (HANGUL SYLLABLE HEUM) */
    {{'\xed', '\x9d', '\xa1'}, 3, 0xD761}, /* (HANGUL SYLLABLE HEUB) */
    {{'\xed', '\x9d', '\xa3'}, 3, 0xD763}, /* (HANGUL SYLLABLE HEUS) */
    {{'\xed', '\x9d', '\xa5'}, 3, 0xD765}, /* (HANGUL SYLLABLE HEUNG) */
    {{'\xed', '\x9d', '\xa9'}, 3, 0xD769}, /* (HANGUL SYLLABLE HEUT) */
    {{'\xed', '\x9d', '\xac'}, 3, 0xD76C}, /* (HANGUL SYLLABLE HYI) */
    {{'\xed', '\x9d', '\xb0'}, 3, 0xD770}, /* (HANGUL SYLLABLE HYIN) */
    {{'\xed', '\x9d', '\xb4'}, 3, 0xD774}, /* (HANGUL SYLLABLE HYIL) */
    {{'\xed', '\x9d', '\xbc'}, 3, 0xD77C}, /* (HANGUL SYLLABLE HYIM) */
    {{'\xed', '\x9d', '\xbd'}, 3, 0xD77D}, /* (HANGUL SYLLABLE HYIB) */
    {{'\xed', '\x9e', '\x81'}, 3, 0xD781}, /* (HANGUL SYLLABLE HYING) */
    {{'\xed', '\x9e', '\x88'}, 3, 0xD788}, /* (HANGUL SYLLABLE HI) */
    {{'\xed', '\x9e', '\x89'}, 3, 0xD789}, /* (HANGUL SYLLABLE HIG) */
    {{'\xed', '\x9e', '\x8c'}, 3, 0xD78C}, /* (HANGUL SYLLABLE HIN) */
    {{'\xed', '\x9e', '\x90'}, 3, 0xD790}, /* (HANGUL SYLLABLE HIL) */
    {{'\xed', '\x9e', '\x98'}, 3, 0xD798}, /* (HANGUL SYLLABLE HIM) */
    {{'\xed', '\x9e', '\x99'}, 3, 0xD799}, /* (HANGUL SYLLABLE HIB) */
    {{'\xed', '\x9e', '\x9b'}, 3, 0xD79B}, /* (HANGUL SYLLABLE HIS) */
    {{'\xed', '\x9e', '\x9d'}, 3, 0xD79D}, /* (HANGUL SYLLABLE HING) */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{'\xe4', '\xbc', '\xbd'}, 3, 0x4F3D}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xbd', '\xb3'}, 3, 0x4F73}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x81', '\x87'}, 3, 0x5047}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x83', '\xb9'}, 3, 0x50F9}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x8a', '\xa0'}, 3, 0x52A0}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x8f', '\xaf'}, 3, 0x53EF}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x91', '\xb5'}, 3, 0x5475}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x93', '\xa5'}, 3, 0x54E5}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x98', '\x89'}, 3, 0x5609}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xab', '\x81'}, 3, 0x5AC1}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xae', '\xb6'}, 3, 0x5BB6}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x9a', '\x87'}, 3, 0x6687}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x9e', '\xb6'}, 3, 0x67B6}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x9e', '\xb7'}, 3, 0x67B7}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x9f', '\xaf'}, 3, 0x67EF}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xad', '\x8c'}, 3, 0x6B4C}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x8f', '\x82'}, 3, 0x73C2}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x97', '\x82'}, 3, 0x75C2}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xa8', '\xbc'}, 3, 0x7A3C}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x8b', '\x9b'}, 3, 0x82DB}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x8c', '\x84'}, 3, 0x8304}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa1', '\x97'}, 3, 0x8857}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa2', '\x88'}, 3, 0x8888}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa8', '\xb6'}, 3, 0x8A36}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xb3', '\x88'}, 3, 0x8CC8}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xb7', '\x8f'}, 3, 0x8DCF}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xbb', '\xbb'}, 3, 0x8EFB}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xbf', '\xa6'}, 3, 0x8FE6}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xa7', '\x95'}, 3, 0x99D5}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x88', '\xbb'}, 3, 0x523B}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x8d', '\xb4'}, 3, 0x5374}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x90', '\x84'}, 3, 0x5404}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x81', '\xaa'}, 3, 0x606A}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x85', '\xa4'}, 3, 0x6164}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xae', '\xbc'}, 3, 0x6BBC}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x8f', '\x8f'}, 3, 0x73CF}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x84', '\x9a'}, 3, 0x811A}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa6', '\xba'}, 3, 0x89BA}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa7', '\x92'}, 3, 0x89D2}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x96', '\xa3'}, 3, 0x95A3}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xbe', '\x83'}, 3, 0x4F83}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x88', '\x8a'}, 3, 0x520A}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa2', '\xbe'}, 3, 0x58BE}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa5', '\xb8'}, 3, 0x5978}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa7', '\xa6'}, 3, 0x59E6}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb9', '\xb2'}, 3, 0x5E72}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb9', '\xb9'}, 3, 0x5E79}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x87', '\x87'}, 3, 0x61C7}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x8f', '\x80'}, 3, 0x63C0}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x9d', '\x86'}, 3, 0x6746}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x9f', '\xac'}, 3, 0x67EC}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa1', '\xbf'}, 3, 0x687F}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xbe', '\x97'}, 3, 0x6F97}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x99', '\x8e'}, 3, 0x764E}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x9c', '\x8b'}, 3, 0x770B}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xa3', '\xb5'}, 3, 0x78F5}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xa8', '\x88'}, 3, 0x7A08}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xab', '\xbf'}, 3, 0x7AFF}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb0', '\xa1'}, 3, 0x7C21}, /* (<CJK Ideograph