# SPDX-License-Identifier: BSD-3-Clause
# Copyright 2016-2018, Intel Corporation
#
#
# pmempool_transform/TEST4 -- test for checking pmempool transform;
#                             pmem/issues#261
#

. ..\unittest\unittest.ps1

require_test_type medium
require_fs_type any

setup

$LOG = "out${Env:UNITTEST_NUM}.log"
$LOG_TEMP = "out${Env:UNITTEST_NUM}_part.log"
rm $LOG -Force -ea si
touch $LOG
rm $LOG_TEMP -Force -ea si
touch $LOG_TEMP

$LAYOUT = "OBJ_LAYOUT${Env:$SUFFIX}"
$POOLSET_IN = "$DIR\poolset.in"
$POOLSET_OUT1 = "$DIR\poolset.out1"
$POOLSET_OUT2 = "$DIR\poolset.out2"

# Create poolset files
create_poolset $POOLSET_IN `
	20M:$DIR\part00:x `
	20M:$DIR\part01:x `
	r `
	15M:$DIR\part10:x `
	15M:$DIR\part11:x

create_poolset $POOLSET_OUT1 `
	20M:$DIR\part00:x `
	20M:$DIR\part01:x

create_poolset $POOLSET_OUT2 `
	20M:$DIR\part00:x `
	20M:$DIR\part01:x `
	r `
	15M:$DIR\part10:x `
	15M:$DIR\part11:x `
	20M:$DIR\part12:x

# CLI script for writing some data hitting all the parts
$WRITE_SCRIPT = "$DIR\write_data"
echo @"
pr 25M
srcp 0 TestOK111
srcp 21M TestOK222
"@ | out-file -encoding ASCII -literalpath $WRITE_SCRIPT

# CLI script for reading 9 characters from all the parts
$READ_SCRIPT = "$DIR\read_data"
echo @"
srpr 0 9
srpr 21M 9
"@ | out-file -encoding ASCII -literalpath $READ_SCRIPT

# Log poolset structures
echo poolset_in >> $LOG_TEMP
cat $POOLSET_IN >> $LOG_TEMP
echo "" >> $LOG_TEMP
echo poolset_out1 >> $LOG_TEMP
cat $POOLSET_OUT1 >> $LOG_TEMP
echo "" >> $LOG_TEMP
echo poolset_out2 >> $LOG_TEMP
cat $POOLSET_OUT2 >> $LOG_TEMP
echo "" >> $LOG_TEMP

# Create a pool
expect_normal_exit $PMEMPOOL create --layout=$LAYOUT obj $POOLSET_IN
cat $LOG >> $LOG_TEMP

# Write some data into the pool, hitting two part files
expect_normal_exit $PMEMOBJCLI -s $WRITE_SCRIPT $POOLSET_IN >> $LOG_TEMP

# Check if correctly written
expect_normal_exit $PMEMOBJCLI -s $READ_SCRIPT $POOLSET_IN >> $LOG_TEMP

# Transform poolset - remove the smaller replica
expect_normal_exit $PMEMPOOL transform $POOLSET_IN $POOLSET_OUT1 >> $LOG_TEMP

# Check if correctly read
expect_normal_exit $PMEMOBJCLI -s $READ_SCRIPT $POOLSET_OUT1 >> $LOG_TEMP

# Transform poolset - add a larger replica
expect_normal_exit $PMEMPOOL transform $POOLSET_OUT1 $POOLSET_OUT2 >> $LOG_TEMP

# Check if correctly read
expect_normal_exit $PMEMOBJCLI -s $READ_SCRIPT $POOLSET_OUT2 >> $LOG_TEMP

# Check metadata by pmempool info
dump_pool_info $POOLSET_OUT2 >> $LOG_TEMP
dump_pool_info $DIR\part00 >> $LOG_TEMP
dump_pool_info $DIR\part01 >> $LOG_TEMP
dump_pool_info $DIR\part10 >> $LOG_TEMP
dump_pool_info $DIR\part11 >> $LOG_TEMP
dump_pool_info $DIR\part12 >> $LOG_TEMP

mv -Force $LOG_TEMP $LOG
check

pass
