/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gatk.utils.nanoScheduler;

import org.broadinstitute.gatk.utils.collections.ExpandingArrayList;
import org.broadinstitute.gatk.utils.nanoScheduler.MapResult;

public class MapResultsQueue<MapType> {
    final ExpandingArrayList<MapResult<MapType>> queue = new ExpandingArrayList(10000);
    int prevJobID = -1;

    public synchronized void put(MapResult<MapType> mapResult) {
        if (mapResult == null) {
            throw new IllegalArgumentException("mapResult cannot be null");
        }
        assert (this.queue.size() < mapResult.getJobID() || this.queue.get(mapResult.getJobID()) == null);
        this.queue.set(mapResult.getJobID(), mapResult);
    }

    public synchronized boolean nextValueIsAvailable() {
        MapResult<MapType> nextMapResult = this.queue.get(this.nextJobID());
        if (nextMapResult == null) {
            return false;
        }
        if (nextMapResult.getJobID() != this.nextJobID()) {
            throw new IllegalStateException("Next job ID " + nextMapResult.getJobID() + " is not == previous job id " + this.prevJobID + " + 1");
        }
        return true;
    }

    private int nextJobID() {
        return this.prevJobID + 1;
    }

    public synchronized MapResult<MapType> take() throws InterruptedException {
        MapResult<MapType> result = this.queue.get(this.nextJobID());
        assert (result.getJobID() == this.nextJobID());
        this.prevJobID = result.getJobID();
        this.queue.set(this.prevJobID, null);
        return result;
    }
}

