#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2022 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Vagrus: The Riven Realms
# send your bug reports to bugs@dotslashplay.it
###

script_version=20251014.3

PLAYIT_COMPATIBILITY_LEVEL='2.33'

GAME_ID='vagrus-the-riven-realms'
GAME_NAME='Vagrus: The Riven Realms'

GAME_ID_PROLOGUE="${GAME_ID}-prologue"
GAME_NAME_PROLOGUE="${GAME_NAME} - Prologue"

ARCHIVE_BASE_PROLOGUE_GOG_1_NAME='vagrus_the_riven_realms_prologue_1_1340522l_64815.sh'
ARCHIVE_BASE_PROLOGUE_GOG_1_MD5='b4c4735a13144974da57e73038c29e88'
ARCHIVE_BASE_PROLOGUE_GOG_1_SIZE='2659242'
ARCHIVE_BASE_PROLOGUE_GOG_1_VERSION='1.1.34-gog64815'
ARCHIVE_BASE_PROLOGUE_GOG_1_URL='https://www.gog.com/game/vagrus_the_riven_realms_prologue'

ARCHIVE_BASE_PROLOGUE_GOG_0_NAME='vagrus_the_riven_realms_prologue_1_1150613h_56533.sh'
ARCHIVE_BASE_PROLOGUE_GOG_0_MD5='b1c3ec004b8d49d9d40a7f54b12fea21'
ARCHIVE_BASE_PROLOGUE_GOG_0_SIZE='5500000'
ARCHIVE_BASE_PROLOGUE_GOG_0_VERSION='1.1.15-gog56533'

ARCHIVE_BASE_PROLOGUE_ITCH_0_NAME='vagrus-demolinux.zip'
ARCHIVE_BASE_PROLOGUE_ITCH_0_MD5='4bddf380ed1355b455802cfd615d9ec7'
ARCHIVE_BASE_PROLOGUE_ITCH_0_SIZE='3800000'
ARCHIVE_BASE_PROLOGUE_ITCH_0_VERSION='0.5.31-itch.2021.05.12'
ARCHIVE_BASE_PROLOGUE_ITCH_0_URL='https://lostpilgrims.itch.io/vagrus'

UNITY3D_NAME='Vagrus'

CONTENT_PATH_DEFAULT_PROLOGUE_GOG='data/noarch/game'
CONTENT_PATH_DEFAULT_PROLOGUE_ITCH='.'

PACKAGES_LIST='
PKG_BIN
PKG_DATA'

PKG_BIN_ARCH='64'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_DATA'
PKG_BIN_DEPENDENCIES_LIBRARIES='
libc.so.6
libdl.so.2
libgcc_s.so.1
libm.so.6
libpthread.so.0
librt.so.1
libz.so.1'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_ID_PROLOGUE="${GAME_ID_PROLOGUE}-data"
PKG_DATA_DESCRIPTION='data'

# Load common functions.

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run default initialisation actions.

initialization_default "$@"

# Extract game data.

archive_extraction_default
## Prevent inclusion of Steam libraries.
rm --recursive "${PLAYIT_WORKDIR}/gamedata/$(content_path_default)/$(unity3d_name)_Data/Plugins"

# Include game data.

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers.

launchers_generation

# Build packages.

packages_generation
print_instructions

# Clean up.

working_directory_cleanup

exit 0
