/*
 * SPDX-FileCopyrightText: Copyright (c) 2008-2022 NVIDIA CORPORATION & AFFILIATES. All rights reserved.
 * SPDX-License-Identifier: MIT
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */
/*
 * WARNING: This is an autogenerated file. DO NOT EDIT.
 * This file is generated using below files:
 * template file: kernel/inc/vgpu/gt_rpc-structures.h
 * definition file: kernel/inc/vgpu/rpc-structures.def
 */


#ifdef RPC_STRUCTURES
// These structures will be used for the communication between the vmioplugin & guest RM.
#define SDK_STRUCTURES
#include "g_sdk-structures.h"
#undef SDK_STRUCTURES
typedef struct rpc_set_guest_system_info_v03_00
{
    NvU32      vgxVersionMajorNum;
    NvU32      vgxVersionMinorNum;
    NvU32      guestDriverVersionBufferLength;
    NvU32      guestVersionBufferLength;
    NvU32      guestTitleBufferLength;
    NvU32      guestClNum;
    char       guestDriverVersion[0x100];
    char       guestVersion[0x100];
    char       guestTitle[0x100];
} rpc_set_guest_system_info_v03_00;

typedef rpc_set_guest_system_info_v03_00 rpc_set_guest_system_info_v;

typedef struct rpc_alloc_memory_v13_01
{
    NvHandle   hClient;
    NvHandle   hDevice;
    NvHandle   hMemory;
    NvU32      hClass;
    NvU32      flags;
    NvU32      pteAdjust;
    NvU32      format;
    NvU64      length NV_ALIGN_BYTES(8);
    NvU32      pageCount;
    struct pte_desc pteDesc;
} rpc_alloc_memory_v13_01;

typedef rpc_alloc_memory_v13_01 rpc_alloc_memory_v;

typedef struct rpc_free_v03_00
{
    NVOS00_PARAMETERS_v03_00 params;
} rpc_free_v03_00;

typedef rpc_free_v03_00 rpc_free_v;

typedef struct rpc_map_memory_dma_v03_00
{
    NVOS46_PARAMETERS_v03_00 params;
} rpc_map_memory_dma_v03_00;

typedef rpc_map_memory_dma_v03_00 rpc_map_memory_dma_v;

typedef struct rpc_unmap_memory_dma_v03_00
{
    NVOS47_PARAMETERS_v03_00 params;
} rpc_unmap_memory_dma_v03_00;

typedef rpc_unmap_memory_dma_v03_00 rpc_unmap_memory_dma_v;

typedef struct rpc_dup_object_v03_00
{
    NVOS55_PARAMETERS_v03_00 params;
} rpc_dup_object_v03_00;

typedef rpc_dup_object_v03_00 rpc_dup_object_v;

typedef struct rpc_idle_channels_v03_00
{
    NvU32      flags;
    NvU32      timeout;
    NvU32      nchannels;
    idle_channel_list_v03_00 channel_list[];
} rpc_idle_channels_v03_00;

typedef rpc_idle_channels_v03_00 rpc_idle_channels_v;

typedef struct rpc_unloading_guest_driver_v1F_07
{
    NvBool     bInPMTransition;
    NvBool     bGc6Entering;
    NvU32      newLevel;
} rpc_unloading_guest_driver_v1F_07;

typedef rpc_unloading_guest_driver_v1F_07 rpc_unloading_guest_driver_v;

typedef struct rpc_gpu_exec_reg_ops_v12_01
{
    NvHandle   hClient;
    NvHandle   hObject;
    gpu_exec_reg_ops_v12_01 params;
} rpc_gpu_exec_reg_ops_v12_01;

typedef rpc_gpu_exec_reg_ops_v12_01 rpc_gpu_exec_reg_ops_v;

typedef struct rpc_set_page_directory_v03_00
{
    NvHandle   hClient;
    NvHandle   hDevice;
    NV0080_CTRL_DMA_SET_PAGE_DIRECTORY_PARAMS_v03_00 params;
} rpc_set_page_directory_v03_00;

typedef struct rpc_set_page_directory_v1E_05
{
    NvHandle   hClient;
    NvHandle   hDevice;
    NvU32      pasid;
    NV0080_CTRL_DMA_SET_PAGE_DIRECTORY_PARAMS_v1E_05 params;
} rpc_set_page_directory_v1E_05;

typedef rpc_set_page_directory_v1E_05 rpc_set_page_directory_v;

typedef struct rpc_unset_page_directory_v03_00
{
    NvHandle   hClient;
    NvHandle   hDevice;
    NV0080_CTRL_DMA_UNSET_PAGE_DIRECTORY_PARAMS_v03_00 params;
} rpc_unset_page_directory_v03_00;

typedef struct rpc_unset_page_directory_v1E_05
{
    NvHandle   hClient;
    NvHandle   hDevice;
    NV0080_CTRL_DMA_UNSET_PAGE_DIRECTORY_PARAMS_v1E_05 params;
} rpc_unset_page_directory_v1E_05;

typedef rpc_unset_page_directory_v1E_05 rpc_unset_page_directory_v;

typedef struct rpc_get_gsp_static_info_v14_00
{
    NvU32      data;
} rpc_get_gsp_static_info_v14_00;

typedef rpc_get_gsp_static_info_v14_00 rpc_get_gsp_static_info_v;

typedef struct rpc_update_bar_pde_v15_00
{
    UpdateBarPde_v15_00 info;
} rpc_update_bar_pde_v15_00;

typedef rpc_update_bar_pde_v15_00 rpc_update_bar_pde_v;

typedef struct rpc_vgpu_pf_reg_read32_v15_00
{
    NvU64      address NV_ALIGN_BYTES(8);
    NvU32      value;
    NvU32      grEngId;
} rpc_vgpu_pf_reg_read32_v15_00;

typedef rpc_vgpu_pf_reg_read32_v15_00 rpc_vgpu_pf_reg_read32_v;

typedef struct rpc_ctrl_subdevice_get_p2p_caps_v21_02
{
    NV2080_CTRL_GET_P2P_CAPS_PARAMS_v21_02 ctrlParams;
} rpc_ctrl_subdevice_get_p2p_caps_v21_02;

typedef rpc_ctrl_subdevice_get_p2p_caps_v21_02 rpc_ctrl_subdevice_get_p2p_caps_v;

typedef struct rpc_ctrl_bus_set_p2p_mapping_v21_03
{
    NvHandle   hClient;
    NvHandle   hObject;
    NV2080_CTRL_BUS_SET_P2P_MAPPING_PARAMS_v21_03 params;
} rpc_ctrl_bus_set_p2p_mapping_v21_03;

typedef rpc_ctrl_bus_set_p2p_mapping_v21_03 rpc_ctrl_bus_set_p2p_mapping_v;

typedef struct rpc_ctrl_bus_unset_p2p_mapping_v21_03
{
    NvHandle   hClient;
    NvHandle   hObject;
    NV2080_CTRL_BUS_UNSET_P2P_MAPPING_PARAMS_v21_03 params;
} rpc_ctrl_bus_unset_p2p_mapping_v21_03;

typedef rpc_ctrl_bus_unset_p2p_mapping_v21_03 rpc_ctrl_bus_unset_p2p_mapping_v;

typedef struct rpc_rmfs_init_v15_00
{
    NvU64      statusQueuePhysAddr NV_ALIGN_BYTES(8);
} rpc_rmfs_init_v15_00;

typedef rpc_rmfs_init_v15_00 rpc_rmfs_init_v;

typedef struct rpc_rmfs_test_v15_00
{
    NvU32      numReps;
    NvU32      flags;
    NvU32      testData1;
    NvU32      testData2;
} rpc_rmfs_test_v15_00;

typedef rpc_rmfs_test_v15_00 rpc_rmfs_test_v;

typedef struct rpc_gsp_set_system_info_v17_00
{
    NvU32      data;
} rpc_gsp_set_system_info_v17_00;

typedef rpc_gsp_set_system_info_v17_00 rpc_gsp_set_system_info_v;

typedef struct rpc_gsp_rm_alloc_v03_00
{
    NvHandle   hClient;
    NvHandle   hParent;
    NvHandle   hObject;
    NvU32      hClass;
    NvU32      status;
    NvU32      paramsSize;
    NvU8       params[];
} rpc_gsp_rm_alloc_v03_00;

typedef rpc_gsp_rm_alloc_v03_00 rpc_gsp_rm_alloc_v;

typedef struct rpc_gsp_rm_control_v03_00
{
    NvHandle   hClient;
    NvHandle   hObject;
    NvU32      cmd;
    NvU32      status;
    NvU32      paramsSize;
    NvBool     serialized;
    NvBool     copyOutOnError;
    NvU8       reserved[2];
    NvU8       params[];
} rpc_gsp_rm_control_v03_00;

typedef rpc_gsp_rm_control_v03_00 rpc_gsp_rm_control_v;

typedef struct rpc_dump_protobuf_component_v18_12
{
    NvU16      component;
    NvU8       nvDumpType;
    NvBool     countOnly;
    NvU32      bugCheckCode;
    NvU32      internalCode;
    NvU32      bufferSize;
    NvU8       blob[];
} rpc_dump_protobuf_component_v18_12;

typedef rpc_dump_protobuf_component_v18_12 rpc_dump_protobuf_component_v;

typedef struct rpc_run_cpu_sequencer_v17_00
{
    NvU32      bufferSizeDWord;
    NvU32      cmdIndex;
    NvU32      regSaveArea[8];
    NvU32      commandBuffer[];
} rpc_run_cpu_sequencer_v17_00;

typedef rpc_run_cpu_sequencer_v17_00 rpc_run_cpu_sequencer_v;

typedef struct rpc_post_event_v17_00
{
    NvHandle   hClient;
    NvHandle   hEvent;
    NvU32      notifyIndex;
    NvU32      data;
    NvU32      status;
    NvU32      eventDataSize;
    NvBool     bNotifyList;
    NvU8       eventData[];
} rpc_post_event_v17_00;

typedef rpc_post_event_v17_00 rpc_post_event_v;

typedef struct rpc_rc_triggered_v17_02
{
    NvU32      nv2080EngineType;
    NvU32      chid;
    NvU32      exceptType;
    NvU32      scope;
    NvU16      partitionAttributionId;
} rpc_rc_triggered_v17_02;

typedef rpc_rc_triggered_v17_02 rpc_rc_triggered_v;

typedef struct rpc_os_error_log_v17_00
{
    NvU32      exceptType;
    NvU32      runlistId;
    NvU32      chid;
    char       errString[0x100];
} rpc_os_error_log_v17_00;

typedef rpc_os_error_log_v17_00 rpc_os_error_log_v;

typedef struct rpc_rg_line_intr_v17_00
{
    NvU32      head;
    NvU32      rgIntr;
} rpc_rg_line_intr_v17_00;

typedef rpc_rg_line_intr_v17_00 rpc_rg_line_intr_v;

typedef struct rpc_display_modeset_v01_00
{
    NvBool     bModesetStart;
    NvU32      minRequiredIsoBandwidthKBPS;
    NvU32      minRequiredFloorBandwidthKBPS;
} rpc_display_modeset_v01_00;

typedef rpc_display_modeset_v01_00 rpc_display_modeset_v;

typedef struct rpc_gpuacct_perfmon_util_samples_v17_00
{
    NV2080_CTRL_PERF_GET_GPUMON_PERFMON_UTIL_SAMPLES_V2_PARAMS_v17_00 params;
} rpc_gpuacct_perfmon_util_samples_v17_00;

typedef rpc_gpuacct_perfmon_util_samples_v17_00 rpc_gpuacct_perfmon_util_samples_v;

typedef struct rpc_vgpu_gsp_plugin_triggered_v17_00
{
    NvU32      gfid;
    NvU32      notifyIndex;
} rpc_vgpu_gsp_plugin_triggered_v17_00;

typedef rpc_vgpu_gsp_plugin_triggered_v17_00 rpc_vgpu_gsp_plugin_triggered_v;

typedef struct rpc_vgpu_config_event_v17_00
{
    NvU32      notifyIndex;
} rpc_vgpu_config_event_v17_00;

typedef rpc_vgpu_config_event_v17_00 rpc_vgpu_config_event_v;

typedef struct rpc_dce_rm_init_v01_00
{
    NvBool     bInit;
} rpc_dce_rm_init_v01_00;

typedef rpc_dce_rm_init_v01_00 rpc_dce_rm_init_v;

typedef struct rpc_sim_read_v1E_01
{
    char       path[0x100];
    NvU32      index;
    NvU32      count;
} rpc_sim_read_v1E_01;

typedef rpc_sim_read_v1E_01 rpc_sim_read_v;

typedef struct rpc_sim_write_v1E_01
{
    char       path[0x100];
    NvU32      index;
    NvU32      count;
    NvU32      data;
} rpc_sim_write_v1E_01;

typedef rpc_sim_write_v1E_01 rpc_sim_write_v;

typedef struct rpc_ucode_libos_print_v1E_08
{
    NvU32      ucodeEngDesc;
    NvU32      libosPrintBufSize;
    NvU8       libosPrintBuf[];
} rpc_ucode_libos_print_v1E_08;

typedef rpc_ucode_libos_print_v1E_08 rpc_ucode_libos_print_v;

typedef struct rpc_init_done_v17_00
{
    NvU32      not_used;
} rpc_init_done_v17_00;

typedef rpc_init_done_v17_00 rpc_init_done_v;

typedef struct rpc_semaphore_schedule_callback_v17_00
{
    NvU64      GPUVA NV_ALIGN_BYTES(8);
    NvU32      hVASpace;
    NvU32      ReleaseValue;
    NvU32      Flags;
    NvU32      completionStatus;
    NvHandle   hClient;
    NvHandle   hEvent;
} rpc_semaphore_schedule_callback_v17_00;

typedef rpc_semaphore_schedule_callback_v17_00 rpc_semaphore_schedule_callback_v;

typedef struct rpc_timed_semaphore_release_v01_00
{
    NvU64      semaphoreVA NV_ALIGN_BYTES(8);
    NvU64      notifierVA NV_ALIGN_BYTES(8);
    NvU32      hVASpace;
    NvU32      releaseValue;
    NvU32      completionStatus;
    NvHandle   hClient;
} rpc_timed_semaphore_release_v01_00;

typedef rpc_timed_semaphore_release_v01_00 rpc_timed_semaphore_release_v;

typedef struct rpc_perf_gpu_boost_sync_limits_callback_v17_00
{
    NV2080_CTRL_INTERNAL_PERF_GPU_BOOST_SYNC_SET_LIMITS_PARAMS_v17_00 params;
} rpc_perf_gpu_boost_sync_limits_callback_v17_00;

typedef rpc_perf_gpu_boost_sync_limits_callback_v17_00 rpc_perf_gpu_boost_sync_limits_callback_v;

typedef struct rpc_perf_bridgeless_info_update_v17_00
{
    NvU64      bBridgeless NV_ALIGN_BYTES(8);
} rpc_perf_bridgeless_info_update_v17_00;

typedef rpc_perf_bridgeless_info_update_v17_00 rpc_perf_bridgeless_info_update_v;

typedef struct rpc_nvlink_fault_up_v17_00
{
    NvU32      linkId;
} rpc_nvlink_fault_up_v17_00;

typedef rpc_nvlink_fault_up_v17_00 rpc_nvlink_fault_up_v;

typedef struct rpc_nvlink_inband_received_data_256_v17_00
{
    NV2080_CTRL_NVLINK_INBAND_RECEIVED_DATA_256_PARAMS_v17_00 params;
} rpc_nvlink_inband_received_data_256_v17_00;

typedef rpc_nvlink_inband_received_data_256_v17_00 rpc_nvlink_inband_received_data_256_v;

typedef struct rpc_nvlink_inband_received_data_512_v17_00
{
    NV2080_CTRL_NVLINK_INBAND_RECEIVED_DATA_512_PARAMS_v17_00 params;
} rpc_nvlink_inband_received_data_512_v17_00;

typedef rpc_nvlink_inband_received_data_512_v17_00 rpc_nvlink_inband_received_data_512_v;

typedef struct rpc_nvlink_inband_received_data_1024_v17_00
{
    NV2080_CTRL_NVLINK_INBAND_RECEIVED_DATA_1024_PARAMS_v17_00 params;
} rpc_nvlink_inband_received_data_1024_v17_00;

typedef rpc_nvlink_inband_received_data_1024_v17_00 rpc_nvlink_inband_received_data_1024_v;

typedef struct rpc_nvlink_inband_received_data_2048_v17_00
{
    NV2080_CTRL_NVLINK_INBAND_RECEIVED_DATA_2048_PARAMS_v17_00 params;
} rpc_nvlink_inband_received_data_2048_v17_00;

typedef rpc_nvlink_inband_received_data_2048_v17_00 rpc_nvlink_inband_received_data_2048_v;

typedef struct rpc_nvlink_inband_received_data_4096_v17_00
{
    NV2080_CTRL_NVLINK_INBAND_RECEIVED_DATA_4096_PARAMS_v17_00 params;
} rpc_nvlink_inband_received_data_4096_v17_00;

typedef rpc_nvlink_inband_received_data_4096_v17_00 rpc_nvlink_inband_received_data_4096_v;

typedef struct rpc_nvlink_is_gpu_degraded_v17_00
{
    NV2080_CTRL_NVLINK_IS_GPU_DEGRADED_PARAMS_v17_00 params;
} rpc_nvlink_is_gpu_degraded_v17_00;

typedef rpc_nvlink_is_gpu_degraded_v17_00 rpc_nvlink_is_gpu_degraded_v;

typedef struct rpc_gsp_send_user_shared_data_v17_00
{
    NvU32      data;
} rpc_gsp_send_user_shared_data_v17_00;

typedef rpc_gsp_send_user_shared_data_v17_00 rpc_gsp_send_user_shared_data_v;

typedef struct rpc_set_sysmem_dirty_page_tracking_buffer_v20_00
{
    NvU32      sysmemPfnBitmapRing;
    NvU32      sysmemPfnBitmapRingHi;
    NvU32      sysmemPfnBitmap;
} rpc_set_sysmem_dirty_page_tracking_buffer_v20_00;

typedef rpc_set_sysmem_dirty_page_tracking_buffer_v20_00 rpc_set_sysmem_dirty_page_tracking_buffer_v;

typedef struct rpc_extdev_intr_service_v17_00
{
    NvU8       lossRegStatus;
    NvU8       gainRegStatus;
    NvU8       miscRegStatus;
    NvBool     rmStatus;
} rpc_extdev_intr_service_v17_00;

typedef rpc_extdev_intr_service_v17_00 rpc_extdev_intr_service_v;

typedef struct rpc_pfm_req_hndlr_state_sync_callback_v21_04
{
    NV2080_CTRL_INTERNAL_PFM_REQ_HNDLR_STATE_SYNC_PARAMS_v21_04 params;
} rpc_pfm_req_hndlr_state_sync_callback_v21_04;

typedef rpc_pfm_req_hndlr_state_sync_callback_v21_04 rpc_pfm_req_hndlr_state_sync_callback_v;

typedef struct rpc_gsp_lockdown_notice_v17_00
{
    NvBool     bLockdownEngaging;
} rpc_gsp_lockdown_notice_v17_00;

typedef rpc_gsp_lockdown_notice_v17_00 rpc_gsp_lockdown_notice_v;


#endif

#ifdef RPC_DEBUG_PRINT_STRUCTURES
// These are printable definitions of above structures. These will be used for RPC logging in the vmioplugin.
#define SDK_DEBUG_PRINT_STRUCTURES
#include "g_sdk-structures.h"
#undef SDK_DEBUG_PRINT_STRUCTURES

#ifndef SKIP_PRINT_rpc_nop_v03_00
static vmiopd_fdesc_t vmiopd_fdesc_t_rpc_nop_v03_00[] = {
    {
        .vtype        = vt_end
    }
};

static vmiopd_mdesc_t vmiopd_mdesc_t_rpc_nop_v03_00 = {
    .name = "rpc_nop",
    .fdesc = vmiopd_fdesc_t_rpc_nop_v03_00
};
#endif

#ifndef SKIP_PRINT_rpc_set_guest_system_info_v03_00
static vmiopd_fdesc_t vmiopd_fdesc_t_rpc_set_guest_system_info_v03_00[] = {
    {
        .vtype                = vtype_NvU32,
        .offset               = NV_OFFSETOF(rpc_set_guest_system_info_v03_00, vgxVersionMajorNum),
        .name                 = "vgxVersionMajorNum"
    },
    {
        .vtype                = vtype_NvU32,
        .offset               = NV_OFFSETOF(rpc_set_guest_system_info_v03_00, vgxVersionMinorNum),
        .name                 = "vgxVersionMinorNum"
    },
    {
        .vtype                = vtype_NvU32,
        .offset               = NV_OFFSETOF(rpc_set_guest_system_info_v03_00, guestDriverVersionBufferLength),
        .name                 = "guestDriverVersionBufferLength"
    },
    {
        .vtype                = vtype_NvU32,
        .offset               = NV_OFFSETOF(rpc_set_guest_system_info_v03_00, guestVersionBufferLength),
        .name                 = "guestVersionBufferLength"
    },
    {
        .vtype                = vtype_NvU32,
        .offset               = NV_OFFSETOF(rpc_set_guest_system_info_v03_00, guestTitleBufferLength),
        .name                 = "guestTitleBufferLength"
    },
    {
        .vtype                = vtype_NvU32,
        .offset               = NV_OFFSETOF(rpc_set_guest_system_info_v03_00, guestClNum),
        .name                 = "guestClNum"
    },
    {
        .vtype                = vtype_char_array,
        .offset               = NV_OFFSETOF(rpc_set_guest_system_info_v03_00, guestDriverVersion),
        .array_length         = 0x100,
        .name                 = "guestDriverVersion"
    },
    {
        .vtype                = vtype_char_array,
        .offset               = NV_OFFSETOF(rpc_set_guest_system_info_v03_00, guestVersion),
        .array_length         = 0x100,
        .name                 = "guestVersion"
    },
    {
        .vtype                = vtype_char_array,
        .offset               = NV_OFFSETOF(rpc_set_guest_system_info_v03_00, guestTitle),
        .array_length         = 0x100,
        .name                 = "guestTitle"
    },
    {
        .vtype        = vt_end
    }
};

static vmiopd_mdesc_t vmiopd_mdesc_t_rpc_set_guest_system_info_v03_00 = {
    .name = "rpc_set_guest_system_info",
    .header_length = NV_SIZEOF32(rpc_set_guest_system_info_v03_00),
    .fdesc = vmiopd_fdesc_t_rpc_set_guest_system_info_v03_00
};
#endif

#ifndef SKIP_PRINT_rpc_alloc_memory_v13_01
static vmiopd_fdesc_t vmiopd_fdesc_t_rpc_alloc_memory_v13_01[] = {
    {
        .vtype                = vtype_NvHandle,
        .offset               = NV_OFFSETOF(rpc_alloc_memory_v13_01, hClient),
        .name                 = "hClient"
    },
    {
        .vtype                = vtype_NvHandle,
        .offset               = NV_OFFSETOF(rpc_alloc_memory_v13_01, hDevice),
        .name                 = "hDevice"
    },
    {
        .vtype                = vtype_NvHandle,
        .offset               = NV_OFFSETOF(rpc_alloc_memory_v13_01, hMemory),
        .name                 = "hMemory"
    },
    {
        .vtype                = vtype_NvU32,
        .offset               = NV_OFFSETOF(rpc_alloc_memory_v13_01, hClass),
        .name                 = "hClass"
    },
    {
        .vtype                = vtype_NvU32,
        .offset               = NV_OFFSETOF(rpc_alloc_memory_v13_01, flags),
        .name                 = "flags"
    },
    {
        .vtype                = vtype_NvU32,
        .offset               = NV_OFFSETOF(rpc_alloc_memory_v13_01, pteAdjust),
        .name                 = "pteAdjust"
    },
    {
        .vtype                = vtype_NvU32,
        .offset               = NV_OFFSETOF(rpc_alloc_memory_v13_01, format),
        .name                 = "format"
    },
    {
        .vtype                = vtype_NvU64,
        .offset               = NV_OFFSETOF(rpc_alloc_memory_v13_01, length),
        .name                 = "length"
    },
    {
        .vtype                = vtype_NvU32,
        .offset               = NV_OFFSETOF(rpc_alloc_memory_v13_01, pageCount),
        .name                 = "pageCount"
    },
    {
        .vtype                = vtype_struct_pte_desc,
        .offset               = NV_OFFSETOF(rpc_alloc_memory_v13_01, pteDesc),
        .name                 = "pteDesc"
    },
    {
        .vtype        = vt_end
    }
};

static vmiopd_mdesc_t vmiopd_mdesc_t_rpc_alloc_memory_v13_01 = {
    .name = "rpc_alloc_memory",
    .header_length = NV_SIZEOF32(rpc_alloc_memory_v13_01),
    .fdesc = vmiopd_fdesc_t_rpc_alloc_memory_v13_01
};
#endif

#ifndef SKIP_PRINT_rpc_free_v03_00
static vmiopd_fdesc_t vmiopd_fdesc_t_rpc_free_v03_00[] = {
    {
        .vtype                = vtype_NVOS00_PARAMETERS_v03_00,
        .offset               = NV_OFFSETOF(rpc_free_v03_00, params),
        .name                 = "params"
    },
    {
        .vtype        = vt_end
    }
};

static vmiopd_mdesc_t vmiopd_mdesc_t_rpc_free_v03_00 = {
    .name = "rpc_free",
    .header_length = NV_SIZEOF32(rpc_free_v03_00),
    .fdesc = vmiopd_fdesc_t_rpc_free_v03_00
};
#endif

#ifndef SKIP_PRINT_rpc_map_memory_dma_v03_00
static vmiopd_fdesc_t vmiopd_fdesc_t_rpc_map_memory_dma_v03_00[] = {
    {
        .vtype                = vtype_NVOS46_PARAMETERS_v03_00,
        .offset               = NV_OFFSETOF(rpc_map_memory_dma_v03_00, params),
        .name                 = "params"
    },
    {
        .vtype        = vt_end
    }
};

static vmiopd_mdesc_t vmiopd_mdesc_t_rpc_map_memory_dma_v03_00 = {
    .name = "rpc_map_memory_dma",
    .header_length = NV_SIZEOF32(rpc_map_memory_dma_v03_00),
    .fdesc = vmiopd_fdesc_t_rpc_map_memory_dma_v03_00
};
#endif

#ifndef SKIP_PRINT_rpc_unmap_memory_dma_v03_00
static vmiopd_fdesc_t vmiopd_fdesc_t_rpc_unmap_memory_dma_v03_00[] = {
    {
        .vtype                = vtype_NVOS47_PARAMETERS_v03_00,
        .offset               = NV_OFFSETOF(rpc_unmap_memory_dma_v03_00, params),
        .name                 = "params"
    },
    {
        .vtype        = vt_end
    }
};

static vmiopd_mdesc_t vmiopd_mdesc_t_rpc_unmap_memory_dma_v03_00 = {
    .name = "rpc_unmap_memory_dma",
    .header_length = NV_SIZEOF32(rpc_unmap_memory_dma_v03_00),
    .fdesc = vmiopd_fdesc_t_rpc_unmap_memory_dma_v03_00
};
#endif

#ifndef SKIP_PRINT_rpc_dup_object_v03_00
static vmiopd_fdesc_t vmiopd_fdesc_t_rpc_dup_object_v03_00[] = {
    {
        .vtype                = vtype_NVOS55_PARAMETERS_v03_00,
        .offset               = NV_OFFSETOF(rpc_dup_object_v03_00, params),
        .name                 = "params"
    },
    {
        .vtype        = vt_end
    }
};

static vmiopd_mdesc_t vmiopd_mdesc_t_rpc_dup_object_v03_00 = {
    .name = "rpc_dup_object",
    .header_length = NV_SIZEOF32(rpc_dup_object_v03_00),
    .fdesc = vmiopd_fdesc_t_rpc_dup_object_v03_00
};
#endif

#ifndef SKIP_PRINT_rpc_idle_channels_v03_00
static vmiopd_fdesc_t vmiopd_fdesc_t_rpc_idle_channels_v03_00[] = {
    {
        .vtype                = vtype_NvU32,
        .offset               = NV_OFFSETOF(rpc_idle_channels_v03_00, flags),
        .name                 = "flags"
    },
    {
        .vtype                = vtype_NvU32,
        .offset               = NV_OFFSETOF(rpc_idle_channels_v03_00, timeout),
        .name                 = "timeout"
    },
    {
        .vtype                = vtype_NvU32,
        .offset               = NV_OFFSETOF(rpc_idle_channels_v03_00, nchannels),
        .name                 = "nchannels"
    },
    {
        .vtype                = vtype_idle_channel_list_v03_00_array,
        .offset               = NV_OFFSETOF(rpc_idle_channels_v03_00, channel_list),
        .array_length         = 0,
        .array_length_fn      = get_array_length_rpc_idle_channels_v03_00_channel_list,
        .name                 = "channel_list"
    },
    {
        .vtype        = vt_end
    }
};

static vmiopd_mdesc_t vmiopd_mdesc_t_rpc_idle_channels_v03_00 = {
    .name = "rpc_idle_channels",
    .header_length = NV_SIZEOF32(rpc_idle_channels_v03_00),
    .fdesc = vmiopd_fdesc_t_rpc_idle_channels_v03_00
};
#endif

#ifndef SKIP_PRINT_rpc_unloading_guest_driver_v03_00
static vmiopd_fdesc_t vmiopd_fdesc_t_rpc_unloading_guest_driver_v03_00[] = {
    {
        .vtype        = vt_end
    }
};

static vmiopd_mdesc_t vmiopd_mdesc_t_rpc_unloading_guest_driver_v03_00 = {
    .name = "rpc_unloading_guest_driver",
    .fdesc = vmiopd_fdesc_t_rpc_unloading_guest_driver_v03_00
};
#endif

#ifndef SKIP_PRINT_rpc_unloading_guest_driver_v1F_07
static vmiopd_fdesc_t vmiopd_fdesc_t_rpc_unloading_guest_driver_v1F_07[] = {
    {
        .vtype                = vtype_NvBool,
        .offset               = NV_OFFSETOF(rpc_unloading_guest_driver_v1F_07, bInPMTransition),
        .name                 = "bInPMTransition"
    },
    {
        .vtype                = vtype_NvBool,
        .offset               = NV_OFFSETOF(rpc_unloading_guest_driver_v1F_07, bGc6Entering),
        .name                 = "bGc6Entering"
    },
    {
        .vtype                = vtype_NvU32,
        .offset               = NV_OFFSETOF(rpc_unloading_guest_driver_v1F_07, newLevel),
        .name                 = "newLevel"
    },
    {
        .vtype        = vt_end
    }
};

static vmiopd_mdesc_t vmiopd_mdesc_t_rpc_unloading_guest_driver_v1F_07 = {
    .name = "rpc_unloading_guest_driver",
    .header_length = NV_SIZEOF32(rpc_unloading_guest_driver_v1F_07),
    .fdesc = vmiopd_fdesc_t_rpc_unloading_guest_driver_v1F_07
};
#endif

#ifndef SKIP_PRINT_rpc_gpu_exec_reg_ops_v12_01
static vmiopd_fdesc_t vmiopd_fdesc_t_rpc_gpu_exec_reg_ops_v12_01[] = {
    {
        .vtype                = vtype_NvHandle,
        .offset               = NV_OFFSETOF(rpc_gpu_exec_reg_ops_v12_01, hClient),
        .name                 = "hClient"
    },
    {
        .vtype                = vtype_NvHandle,
        .offset               = NV_OFFSETOF(rpc_gpu_exec_reg_ops_v12_01, hObject),
        .name                 = "hObject"
    },
    {
        .vtype                = vtype_gpu_exec_reg_ops_v12_01,
        .offset               = NV_OFFSETOF(rpc_gpu_exec_reg_ops_v12_01, params),
        .name                 = "params"
    },
    {
        .vtype        = vt_end
    }
};

static vmiopd_mdesc_t vmiopd_mdesc_t_rpc_gpu_exec_reg_ops_v12_01 = {
    .name = "rpc_gpu_exec_reg_ops",
    .header_length = NV_SIZEOF32(rpc_gpu_exec_reg_ops_v12_01),
    .fdesc = vmiopd_fdesc_t_rpc_gpu_exec_reg_ops_v12_01
};
#endif

#ifndef SKIP_PRINT_rpc_set_page_directory_v1E_05
static vmiopd_fdesc_t vmiopd_fdesc_t_rpc_set_page_directory_v1E_05[] = {
    {
        .vtype                = vtype_NvHandle,
        .offset               = NV_OFFSETOF(rpc_set_page_directory_v1E_05, hClient),
        .name                 = "hClient"
    },
    {
        .vtype                = vtype_NvHandle,
        .offset               = NV_OFFSETOF(rpc_set_page_directory_v1E_05, hDevice),
        .name                 = "hDevice"
    },
    {
        .vtype                = vtype_NvU32,
        .offset               = NV_OFFSETOF(rpc_set_page_directory_v1E_05, pasid),
        .name                 = "pasid"
    },
    {
        .vtype                = vtype_NV0080_CTRL_DMA_SET_PAGE_DIRECTORY_PARAMS_v1E_05,
        .offset               = NV_OFFSETOF(rpc_set_page_directory_v1E_05, params),
        .name                 = "params"
    },
    {
        .vtype        = vt_end
    }
};

static vmiopd_mdesc_t vmiopd_mdesc_t_rpc_set_page_directory_v1E_05 = {
    .name = "rpc_set_page_directory",
    .header_length = NV_SIZEOF32(rpc_set_page_directory_v1E_05),
    .fdesc = vmiopd_fdesc_t_rpc_set_page_directory_v1E_05
};
#endif

#ifndef SKIP_PRINT_rpc_set_page_directory_v03_00
static vmiopd_fdesc_t vmiopd_fdesc_t_rpc_set_page_directory_v03_00[] = {
    {
        .vtype                = vtype_NvHandle,
        .offset               = NV_OFFSETOF(rpc_set_page_directory_v03_00, hClient),
        .name                 = "hClient"
    },
    {
        .vtype                = vtype_NvHandle,
        .offset               = NV_OFFSETOF(rpc_set_page_directory_v03_00, hDevice),
        .name                 = "hDevice"
    },
    {
        .vtype                = vtype_NV0080_CTRL_DMA_SET_PAGE_DIRECTORY_PARAMS_v03_00,
        .offset               = NV_OFFSETOF(rpc_set_page_directory_v03_00, params),
        .name                 = "params"
    },
    {
        .vtype        = vt_end
    }
};

static vmiopd_mdesc_t vmiopd_mdesc_t_rpc_set_page_directory_v03_00 = {
    .name = "rpc_set_page_directory",
    .header_length = NV_SIZEOF32(rpc_set_page_directory_v03_00),
    .fdesc = vmiopd_fdesc_t_rpc_set_page_directory_v03_00
};
#endif

#ifndef SKIP_PRINT_rpc_unset_page_directory_v1E_05
static vmiopd_fdesc_t vmiopd_fdesc_t_rpc_unset_page_directory_v1E_05[] = {
    {
        .vtype                = vtype_NvHandle,
        .offset               = NV_OFFSETOF(rpc_unset_page_directory_v1E_05, hClient),
        .name                 = "hClient"
    },
    {
        .vtype                = vtype_NvHandle,
        .offset               = NV_OFFSETOF(rpc_unset_page_directory_v1E_05, hDevice),
        .name                 = "hDevice"
    },
    {
        .vtype                = vtype_NV0080_CTRL_DMA_UNSET_PAGE_DIRECTORY_PARAMS_v1E_05,
        .offset               = NV_OFFSETOF(rpc_unset_page_directory_v1E_05, params),
        .name                 = "params"
    },
    {
        .vtype        = vt_end
    }
};

static vmiopd_mdesc_t vmiopd_mdesc_t_rpc_unset_page_directory_v1E_05 = {
    .name = "rpc_unset_page_directory",
    .header_length = NV_SIZEOF32(rpc_unset_page_directory_v1E_05),
    .fdesc = vmiopd_fdesc_t_rpc_unset_page_directory_v1E_05
};
#endif

#ifndef SKIP_PRINT_rpc_unset_page_directory_v03_00
static vmiopd_fdesc_t vmiopd_fdesc_t_rpc_unset_page_directory_v03_00[] = {
    {
        .vtype                = vtype_NvHandle,
        .offset               = NV_OFFSETOF(rpc_unset_page_directory_v03_00, hClient),
        .name                 = "hClient"
    },
    {
        .vtype                = vtype_NvHandle,
        .offset               = NV_OFFSETOF(rpc_unset_page_directory_v03_00, hDevice),
        .name                 = "hDevice"
    },
    {
        .vtype                = vtype_NV0080_CTRL_DMA_UNSET_PAGE_DIRECTORY_PARAMS_v03_00,
        .offset               = NV_OFFSETOF(rpc_unset_page_directory_v03_00, params),
        .name                 = "params"
    },
    {
        .vtype        = vt_end
    }
};

static vmiopd_mdesc_t vmiopd_mdesc_t_rpc_unset_page_directory_v03_00 = {
    .name = "rpc_unset_page_directory",
    .header_length = NV_SIZEOF32(rpc_unset_page_directory_v03_00),
    .fdesc = vmiopd_fdesc_t_rpc_unset_page_directory_v03_00
};
#endif

#ifndef SKIP_PRINT_rpc_get_gsp_static_info_v14_00
static vmiopd_fdesc_t vmiopd_fdesc_t_rpc_get_gsp_static_info_v14_00[] = {
    {
        .vtype                = vtype_NvU32,
        .offset               = NV_OFFSETOF(rpc_get_gsp_static_info_v14_00, data),
        .name                 = "data"
    },
    {
        .vtype        = vt_end
    }
};

static vmiopd_mdesc_t vmiopd_mdesc_t_rpc_get_gsp_static_info_v14_00 = {
    .name = "rpc_get_gsp_static_info",
    .header_length = NV_SIZEOF32(rpc_get_gsp_static_info_v14_00),
    .fdesc = vmiopd_fdesc_t_rpc_get_gsp_static_info_v14_00
};
#endif

#ifndef SKIP_PRINT_rpc_update_bar_pde_v15_00
static vmiopd_fdesc_t vmiopd_fdesc_t_rpc_update_bar_pde_v15_00[] = {
    {
        .vtype                = vtype_UpdateBarPde_v15_00,
        .offset               = NV_OFFSETOF(rpc_update_bar_pde_v15_00, info),
        .name                 = "info"
    },
    {
        .vtype        = vt_end
    }
};

static vmiopd_mdesc_t vmiopd_mdesc_t_rpc_update_bar_pde_v15_00 = {
    .name = "rpc_update_bar_pde",
    .header_length = NV_SIZEOF32(rpc_update_bar_pde_v15_00),
    .fdesc = vmiopd_fdesc_t_rpc_update_bar_pde_v15_00
};
#endif

#ifndef SKIP_PRINT_rpc_vgpu_pf_reg_read32_v15_00
static vmiopd_fdesc_t vmiopd_fdesc_t_rpc_vgpu_pf_reg_read32_v15_00[] = {
    {
        .vtype                = vtype_NvU64,
        .offset               = NV_OFFSETOF(rpc_vgpu_pf_reg_read32_v15_00, address),
        .name                 = "address"
    },
    {
        .vtype                = vtype_NvU32,
        .offset               = NV_OFFSETOF(rpc_vgpu_pf_reg_read32_v15_00, value),
        .name                 = "value"
    },
    {
        .vtype                = vtype_NvU32,
        .offset               = NV_OFFSETOF(rpc_vgpu_pf_reg_read32_v15_00, grEngId),
        .name                 = "grEngId"
    },
    {
        .vtype        = vt_end
    }
};

static vmiopd_mdesc_t vmiopd_mdesc_t_rpc_vgpu_pf_reg_read32_v15_00 = {
    .name = "rpc_vgpu_pf_reg_read32",
    .header_length = NV_SIZEOF32(rpc_vgpu_pf_reg_read32_v15_00),
    .fdesc = vmiopd_fdesc_t_rpc_vgpu_pf_reg_read32_v15_00
};
#endif

#ifndef SKIP_PRINT_rpc_ctrl_subdevice_get_p2p_caps_v21_02
static vmiopd_fdesc_t vmiopd_fdesc_t_rpc_ctrl_subdevice_get_p2p_caps_v21_02[] = {
    {
        .vtype                = vtype_NV2080_CTRL_GET_P2P_CAPS_PARAMS_v21_02,
        .offset               = NV_OFFSETOF(rpc_ctrl_subdevice_get_p2p_caps_v21_02, ctrlParams),
        .name                 = "ctrlParams"
    },
    {
        .vtype        = vt_end
    }
};

static vmiopd_mdesc_t vmiopd_mdesc_t_rpc_ctrl_subdevice_get_p2p_caps_v21_02 = {
    .name = "rpc_ctrl_subdevice_get_p2p_caps",
    .header_length = NV_SIZEOF32(rpc_ctrl_subdevice_get_p2p_caps_v21_02),
    .fdesc = vmiopd_fdesc_t_rpc_ctrl_subdevice_get_p2p_caps_v21_02
};
#endif

#ifndef SKIP_PRINT_rpc_ctrl_bus_set_p2p_mapping_v21_03
static vmiopd_fdesc_t vmiopd_fdesc_t_rpc_ctrl_bus_set_p2p_mapping_v21_03[] = {
    {
        .vtype                = vtype_NvHandle,
        .offset               = NV_OFFSETOF(rpc_ctrl_bus_set_p2p_mapping_v21_03, hClient),
        .name                 = "hClient"
    },
    {
        .vtype                = vtype_NvHandle,
        .offset               = NV_OFFSETOF(rpc_ctrl_bus_set_p2p_mapping_v21_03, hObject),
        .name                 = "hObject"
    },
    {
        .vtype                = vtype_NV2080_CTRL_BUS_SET_P2P_MAPPING_PARAMS_v21_03,
        .offset               = NV_OFFSETOF(rpc_ctrl_bus_set_p2p_mapping_v21_03, params),
        .name                 = "params"
    },
    {
        .vtype        = vt_end
    }
};

static vmiopd_mdesc_t vmiopd_mdesc_t_rpc_ctrl_bus_set_p2p_mapping_v21_03 = {
    .name = "rpc_ctrl_bus_set_p2p_mapping",
    .header_length = NV_SIZEOF32(rpc_ctrl_bus_set_p2p_mapping_v21_03),
    .fdesc = vmiopd_fdesc_t_rpc_ctrl_bus_set_p2p_mapping_v21_03
};
#endif

#ifndef SKIP_PRINT_rpc_ctrl_bus_unset_p2p_mapping_v21_03
static vmiopd_fdesc_t vmiopd_fdesc_t_rpc_ctrl_bus_unset_p2p_mapping_v21_03[] = {
    {
        .vtype                = vtype_NvHandle,
        .offset               = NV_OFFSETOF(rpc_ctrl_bus_unset_p2p_mapping_v21_03, hClient),
        .name                 = "hClient"
    },
    {
        .vtype                = vtype_NvHandle,
        .offset               = NV_OFFSETOF(rpc_ctrl_bus_unset_p2p_mapping_v21_03, hObject),
        .name                 = "hObject"
    },
    {
        .vtype                = vtype_NV2080_CTRL_BUS_UNSET_P2P_MAPPING_PARAMS_v21_03,
        .offset               = NV_OFFSETOF(rpc_ctrl_bus_unset_p2p_mapping_v21_03, params),
        .name                 = "params"
    },
    {
        .vtype        = vt_end
    }
};

static vmiopd_mdesc_t vmiopd_mdesc_t_rpc_ctrl_bus_unset_p2p_mapping_v21_03 = {
    .name = "rpc_ctrl_bus_unset_p2p_mapping",
    .header_length = NV_SIZEOF32(rpc_ctrl_bus_unset_p2p_mapping_v21_03),
    .fdesc = vmiopd_fdesc_t_rpc_ctrl_bus_unset_p2p_mapping_v21_03
};
#endif

#ifndef SKIP_PRINT_rpc_rmfs_init_v15_00
static vmiopd_fdesc_t vmiopd_fdesc_t_rpc_rmfs_init_v15_00[] = {
    {
        .vtype                = vtype_NvU64,
        .offset               = NV_OFFSETOF(rpc_rmfs_init_v15_00, statusQueuePhysAddr),
        .name                 = "statusQueuePhysAddr"
    },
    {
        .vtype        = vt_end
    }
};

static vmiopd_mdesc_t vmiopd_mdesc_t_rpc_rmfs_init_v15_00 = {
    .name = "rpc_rmfs_init",
    .header_length = NV_SIZEOF32(rpc_rmfs_init_v15_00),
    .fdesc = vmiopd_fdesc_t_rpc_rmfs_init_v15_00
};
#endif

#ifndef SKIP_PRINT_rpc_rmfs_close_queue_v15_00
static vmiopd_fdesc_t vmiopd_fdesc_t_rpc_rmfs_close_queue_v15_00[] = {
    {
        .vtype        = vt_end
    }
};

static vmiopd_mdesc_t vmiopd_mdesc_t_rpc_rmfs_close_queue_v15_00 = {
    .name = "rpc_rmfs_close_queue",
    .fdesc = vmiopd_fdesc_t_rpc_rmfs_close_queue_v15_00
};
#endif

#ifndef SKIP_PRINT_rpc_rmfs_cleanup_v15_00
static vmiopd_fdesc_t vmiopd_fdesc_t_rpc_rmfs_cleanup_v15_00[] = {
    {
        .vtype        = vt_end
    }
};

static vmiopd_mdesc_t vmiopd_mdesc_t_rpc_rmfs_cleanup_v15_00 = {
    .name = "rpc_rmfs_cleanup",
    .fdesc = vmiopd_fdesc_t_rpc_rmfs_cleanup_v15_00
};
#endif

#ifndef SKIP_PRINT_rpc_rmfs_test_v15_00
static vmiopd_fdesc_t vmiopd_fdesc_t_rpc_rmfs_test_v15_00[] = {
    {
        .vtype                = vtype_NvU32,
        .offset               = NV_OFFSETOF(rpc_rmfs_test_v15_00, numReps),
        .name                 = "numReps"
    },
    {
        .vtype                = vtype_NvU32,
        .offset               = NV_OFFSETOF(rpc_rmfs_test_v15_00, flags),
        .name                 = "flags"
    },
    {
        .vtype                = vtype_NvU32,
        .offset               = NV_OFFSETOF(rpc_rmfs_test_v15_00, testData1),
        .name                 = "testData1"
    },
    {
        .vtype                = vtype_NvU32,
        .offset               = NV_OFFSETOF(rpc_rmfs_test_v15_00, testData2),
        .name                 = "testData2"
    },
    {
        .vtype        = vt_end
    }
};

static vmiopd_mdesc_t vmiopd_mdesc_t_rpc_rmfs_test_v15_00 = {
    .name = "rpc_rmfs_test",
    .header_length = NV_SIZEOF32(rpc_rmfs_test_v15_00),
    .fdesc = vmiopd_fdesc_t_rpc_rmfs_test_v15_00
};
#endif

#ifndef SKIP_PRINT_rpc_gsp_set_system_info_v17_00
static vmiopd_fdesc_t vmiopd_fdesc_t_rpc_gsp_set_system_info_v17_00[] = {
    {
        .vtype                = vtype_NvU32,
        .offset               = NV_OFFSETOF(rpc_gsp_set_system_info_v17_00, data),
        .name                 = "data"
    },
    {
        .vtype        = vt_end
    }
};

static vmiopd_mdesc_t vmiopd_mdesc_t_rpc_gsp_set_system_info_v17_00 = {
    .name = "rpc_gsp_set_system_info",
    .header_length = NV_SIZEOF32(rpc_gsp_set_system_info_v17_00),
    .fdesc = vmiopd_fdesc_t_rpc_gsp_set_system_info_v17_00
};
#endif

#ifndef SKIP_PRINT_rpc_set_registry_v17_00
static vmiopd_fdesc_t vmiopd_fdesc_t_rpc_set_registry_v17_00[] = {
    {
        .vtype        = vt_end
    }
};

static vmiopd_mdesc_t vmiopd_mdesc_t_rpc_set_registry_v17_00 = {
    .name = "rpc_set_registry",
    .fdesc = vmiopd_fdesc_t_rpc_set_registry_v17_00
};
#endif

#ifndef SKIP_PRINT_rpc_gsp_rm_alloc_v03_00
static vmiopd_fdesc_t vmiopd_fdesc_t_rpc_gsp_rm_alloc_v03_00[] = {
    {
        .vtype                = vtype_NvHandle,
        .offset               = NV_OFFSETOF(rpc_gsp_rm_alloc_v03_00, hClient),
        .name                 = "hClient"
    },
    {
        .vtype                = vtype_NvHandle,
        .offset               = NV_OFFSETOF(rpc_gsp_rm_alloc_v03_00, hParent),
        .name                 = "hParent"
    },
    {
        .vtype                = vtype_NvHandle,
        .offset               = NV_OFFSETOF(rpc_gsp_rm_alloc_v03_00, hObject),
        .name                 = "hObject"
    },
    {
        .vtype                = vtype_NvU32,
        .offset               = NV_OFFSETOF(rpc_gsp_rm_alloc_v03_00, hClass),
        .name                 = "hClass"
    },
    {
        .vtype                = vtype_NvU32,
        .offset               = NV_OFFSETOF(rpc_gsp_rm_alloc_v03_00, status),
        .name                 = "status"
    },
    {
        .vtype                = vtype_NvU32,
        .offset               = NV_OFFSETOF(rpc_gsp_rm_alloc_v03_00, paramsSize),
        .name                 = "paramsSize"
    },
    {
        .vtype                = vtype_NvU8_array,
        .offset               = NV_OFFSETOF(rpc_gsp_rm_alloc_v03_00, params),
        .array_length         = 0,
        .name                 = "params"
    },
    {
        .vtype        = vt_end
    }
};

static vmiopd_mdesc_t vmiopd_mdesc_t_rpc_gsp_rm_alloc_v03_00 = {
    .name = "rpc_gsp_rm_alloc",
    .header_length = NV_SIZEOF32(rpc_gsp_rm_alloc_v03_00),
    .fdesc = vmiopd_fdesc_t_rpc_gsp_rm_alloc_v03_00
};
#endif

#ifndef SKIP_PRINT_rpc_gsp_rm_control_v03_00
static vmiopd_fdesc_t vmiopd_fdesc_t_rpc_gsp_rm_control_v03_00[] = {
    {
        .vtype                = vtype_NvHandle,
        .offset               = NV_OFFSETOF(rpc_gsp_rm_control_v03_00, hClient),
        .name                 = "hClient"
    },
    {
        .vtype                = vtype_NvHandle,
        .offset               = NV_OFFSETOF(rpc_gsp_rm_control_v03_00, hObject),
        .name                 = "hObject"
    },
    {
        .vtype                = vtype_NvU32,
        .offset               = NV_OFFSETOF(rpc_gsp_rm_control_v03_00, cmd),
        .name                 = "cmd"
    },
    {
        .vtype                = vtype_NvU32,
        .offset               = NV_OFFSETOF(rpc_gsp_rm_control_v03_00, status),
        .name                 = "status"
    },
    {
        .vtype                = vtype_NvU32,
        .offset               = NV_OFFSETOF(rpc_gsp_rm_control_v03_00, paramsSize),
        .name                 = "paramsSize"
    },
    {
        .vtype                = vtype_NvBool,
        .offset               = NV_OFFSETOF(rpc_gsp_rm_control_v03_00, serialized),
        .name                 = "serialized"
    },
    {
        .vtype                = vtype_NvBool,
        .offset               = NV_OFFSETOF(rpc_gsp_rm_control_v03_00, copyOutOnError),
        .name                 = "copyOutOnError"
    },
    {
        .vtype                = vtype_NvU8_array,
        .offset               = NV_OFFSETOF(rpc_gsp_rm_control_v03_00, reserved),
        .array_length         = 2,
        .name                 = "reserved"
    },
    {
        .vtype                = vtype_NvU8_array,
        .offset               = NV_OFFSETOF(rpc_gsp_rm_control_v03_00, params),
        .array_length         = 0,
        .name                 = "params"
    },
    {
        .vtype        = vt_end
    }
};

static vmiopd_mdesc_t vmiopd_mdesc_t_rpc_gsp_rm_control_v03_00 = {
    .name = "rpc_gsp_rm_control",
    .header_length = NV_SIZEOF32(rpc_gsp_rm_control_v03_00),
    .fdesc = vmiopd_fdesc_t_rpc_gsp_rm_control_v03_00
};
#endif

#ifndef SKIP_PRINT_rpc_dump_protobuf_component_v18_12
static vmiopd_fdesc_t vmiopd_fdesc_t_rpc_dump_protobuf_component_v18_12[] = {
    {
        .vtype                = vtype_NvU16,
        .offset               = NV_OFFSETOF(rpc_dump_protobuf_component_v18_12, component),
        .name                 = "component"
    },
    {
        .vtype                = vtype_NvU8,
        .offset               = NV_OFFSETOF(rpc_dump_protobuf_component_v18_12, nvDumpType),
        .name                 = "nvDumpType"
    },
    {
        .vtype                = vtype_NvBool,
        .offset               = NV_OFFSETOF(rpc_dump_protobuf_component_v18_12, countOnly),
        .name                 = "countOnly"
    },
    {
        .vtype                = vtype_NvU32,
        .offset               = NV_OFFSETOF(rpc_dump_protobuf_component_v18_12, bugCheckCode),
        .name                 = "bugCheckCode"
    },
    {
        .vtype                = vtype_NvU32,
        .offset               = NV_OFFSETOF(rpc_dump_protobuf_component_v18_12, internalCode),
        .name                 = "internalCode"
    },
    {
        .vtype                = vtype_NvU32,
        .offset               = NV_OFFSETOF(rpc_dump_protobuf_component_v18_12, bufferSize),
        .name                 = "bufferSize"
    },
    {
        .vtype                = vtype_NvU8_array,
        .offset               = NV_OFFSETOF(rpc_dump_protobuf_component_v18_12, blob),
        .array_length         = 0,
        .name                 = "blob"
    },
    {
        .vtype        = vt_end
    }
};

static vmiopd_mdesc_t vmiopd_mdesc_t_rpc_dump_protobuf_component_v18_12 = {
    .name = "rpc_dump_protobuf_component",
    .header_length = NV_SIZEOF32(rpc_dump_protobuf_component_v18_12),
    .fdesc = vmiopd_fdesc_t_rpc_dump_protobuf_component_v18_12
};
#endif

#ifndef SKIP_PRINT_rpc_run_cpu_sequencer_v17_00
static vmiopd_fdesc_t vmiopd_fdesc_t_rpc_run_cpu_sequencer_v17_00[] = {
    {
        .vtype                = vtype_NvU32,
        .offset               = NV_OFFSETOF(rpc_run_cpu_sequencer_v17_00, bufferSizeDWord),
        .name                 = "bufferSizeDWord"
    },
    {
        .vtype                = vtype_NvU32,
        .offset               = NV_OFFSETOF(rpc_run_cpu_sequencer_v17_00, cmdIndex),
        .name                 = "cmdIndex"
    },
    {
        .vtype                = vtype_NvU32_array,
        .offset               = NV_OFFSETOF(rpc_run_cpu_sequencer_v17_00, regSaveArea),
        .array_length         = 8,
        .name                 = "regSaveArea"
    },
    {
        .vtype                = vtype_NvU32_array,
        .offset               = NV_OFFSETOF(rpc_run_cpu_sequencer_v17_00, commandBuffer),
        .array_length         = 0,
        .name                 = "commandBuffer"
    },
    {
        .vtype        = vt_end
    }
};

static vmiopd_mdesc_t vmiopd_mdesc_t_rpc_run_cpu_sequencer_v17_00 = {
    .name = "rpc_run_cpu_sequencer",
    .header_length = NV_SIZEOF32(rpc_run_cpu_sequencer_v17_00),
    .fdesc = vmiopd_fdesc_t_rpc_run_cpu_sequencer_v17_00
};
#endif

#ifndef SKIP_PRINT_rpc_post_event_v17_00
static vmiopd_fdesc_t vmiopd_fdesc_t_rpc_post_event_v17_00[] = {
    {
        .vtype                = vtype_NvHandle,
        .offset               = NV_OFFSETOF(rpc_post_event_v17_00, hClient),
        .name                 = "hClient"
    },
    {
        .vtype                = vtype_NvHandle,
        .offset               = NV_OFFSETOF(rpc_post_event_v17_00, hEvent),
        .name                 = "hEvent"
    },
    {
        .vtype                = vtype_NvU32,
        .offset               = NV_OFFSETOF(rpc_post_event_v17_00, notifyIndex),
        .name                 = "notifyIndex"
    },
    {
        .vtype                = vtype_NvU32,
        .offset               = NV_OFFSETOF(rpc_post_event_v17_00, data),
        .name                 = "data"
    },
    {
        .vtype                = vtype_NvU32,
        .offset               = NV_OFFSETOF(rpc_post_event_v17_00, status),
        .name                 = "status"
    },
    {
        .vtype                = vtype_NvU32,
        .offset               = NV_OFFSETOF(rpc_post_event_v17_00, eventDataSize),
        .name                 = "eventDataSize"
    },
    {
        .vtype                = vtype_NvBool,
        .offset               = NV_OFFSETOF(rpc_post_event_v17_00, bNotifyList),
        .name                 = "bNotifyList"
    },
    {
        .vtype                = vtype_NvU8_array,
        .offset               = NV_OFFSETOF(rpc_post_event_v17_00, eventData),
        .array_length         = 0,
        .name                 = "eventData"
    },
    {
        .vtype        = vt_end
    }
};

static vmiopd_mdesc_t vmiopd_mdesc_t_rpc_post_event_v17_00 = {
    .name = "rpc_post_event",
    .header_length = NV_SIZEOF32(rpc_post_event_v17_00),
    .fdesc = vmiopd_fdesc_t_rpc_post_event_v17_00
};
#endif

#ifndef SKIP_PRINT_rpc_rc_triggered_v17_02
static vmiopd_fdesc_t vmiopd_fdesc_t_rpc_rc_triggered_v17_02[] = {
    {
        .vtype                = vtype_NvU32,
        .offset               = NV_OFFSETOF(rpc_rc_triggered_v17_02, nv2080EngineType),
        .name                 = "nv2080EngineType"
    },
    {
        .vtype                = vtype_NvU32,
        .offset               = NV_OFFSETOF(rpc_rc_triggered_v17_02, chid),
        .name                 = "chid"
    },
    {
        .vtype                = vtype_NvU32,
        .offset               = NV_OFFSETOF(rpc_rc_triggered_v17_02, exceptType),
        .name                 = "exceptType"
    },
    {
        .vtype                = vtype_NvU32,
        .offset               = NV_OFFSETOF(rpc_rc_triggered_v17_02, scope),
        .name                 = "scope"
    },
    {
        .vtype                = vtype_NvU16,
        .offset               = NV_OFFSETOF(rpc_rc_triggered_v17_02, partitionAttributionId),
        .name                 = "partitionAttributionId"
    },
    {
        .vtype        = vt_end
    }
};

static vmiopd_mdesc_t vmiopd_mdesc_t_rpc_rc_triggered_v17_02 = {
    .name = "rpc_rc_triggered",
    .header_length = NV_SIZEOF32(rpc_rc_triggered_v17_02),
    .fdesc = vmiopd_fdesc_t_rpc_rc_triggered_v17_02
};
#endif

#ifndef SKIP_PRINT_rpc_os_error_log_v17_00
static vmiopd_fdesc_t vmiopd_fdesc_t_rpc_os_error_log_v17_00[] = {
    {
        .vtype                = vtype_NvU32,
        .offset               = NV_OFFSETOF(rpc_os_error_log_v17_00, exceptType),
        .name                 = "exceptType"
    },
    {
        .vtype                = vtype_NvU32,
        .offset               = NV_OFFSETOF(rpc_os_error_log_v17_00, runlistId),
        .name                 = "runlistId"
    },
    {
        .vtype                = vtype_NvU32,
        .offset               = NV_OFFSETOF(rpc_os_error_log_v17_00, chid),
        .name                 = "chid"
    },
    {
        .vtype                = vtype_char_array,
        .offset               = NV_OFFSETOF(rpc_os_error_log_v17_00, errString),
        .array_length         = 0x100,
        .name                 = "errString"
    },
    {
        .vtype        = vt_end
    }
};

static vmiopd_mdesc_t vmiopd_mdesc_t_rpc_os_error_log_v17_00 = {
    .name = "rpc_os_error_log",
    .header_length = NV_SIZEOF32(rpc_os_error_log_v17_00),
    .fdesc = vmiopd_fdesc_t_rpc_os_error_log_v17_00
};
#endif

#ifndef SKIP_PRINT_rpc_rg_line_intr_v17_00
static vmiopd_fdesc_t vmiopd_fdesc_t_rpc_rg_line_intr_v17_00[] = {
    {
        .vtype                = vtype_NvU32,
        .offset               = NV_OFFSETOF(rpc_rg_line_intr_v17_00, head),
        .name                 = "head"
    },
    {
        .vtype                = vtype_NvU32,
        .offset               = NV_OFFSETOF(rpc_rg_line_intr_v17_00, rgIntr),
        .name                 = "rgIntr"
    },
    {
        .vtype        = vt_end
    }
};

static vmiopd_mdesc_t vmiopd_mdesc_t_rpc_rg_line_intr_v17_00 = {
    .name = "rpc_rg_line_intr",
    .header_length = NV_SIZEOF32(rpc_rg_line_intr_v17_00),
    .fdesc = vmiopd_fdesc_t_rpc_rg_line_intr_v17_00
};
#endif

#ifndef SKIP_PRINT_rpc_display_modeset_v01_00
static vmiopd_fdesc_t vmiopd_fdesc_t_rpc_display_modeset_v01_00[] = {
    {
        .vtype                = vtype_NvBool,
        .offset               = NV_OFFSETOF(rpc_display_modeset_v01_00, bModesetStart),
        .name                 = "bModesetStart"
    },
    {
        .vtype                = vtype_NvU32,
        .offset               = NV_OFFSETOF(rpc_display_modeset_v01_00, minRequiredIsoBandwidthKBPS),
        .name                 = "minRequiredIsoBandwidthKBPS"
    },
    {
        .vtype                = vtype_NvU32,
        .offset               = NV_OFFSETOF(rpc_display_modeset_v01_00, minRequiredFloorBandwidthKBPS),
        .name                 = "minRequiredFloorBandwidthKBPS"
    },
    {
        .vtype        = vt_end
    }
};

static vmiopd_mdesc_t vmiopd_mdesc_t_rpc_display_modeset_v01_00 = {
    .name = "rpc_display_modeset",
    .header_length = NV_SIZEOF32(rpc_display_modeset_v01_00),
    .fdesc = vmiopd_fdesc_t_rpc_display_modeset_v01_00
};
#endif

#ifndef SKIP_PRINT_rpc_gpuacct_perfmon_util_samples_v17_00
static vmiopd_fdesc_t vmiopd_fdesc_t_rpc_gpuacct_perfmon_util_samples_v17_00[] = {
    {
        .vtype                = vtype_NV2080_CTRL_PERF_GET_GPUMON_PERFMON_UTIL_SAMPLES_V2_PARAMS_v17_00,
        .offset               = NV_OFFSETOF(rpc_gpuacct_perfmon_util_samples_v17_00, params),
        .name                 = "params"
    },
    {
        .vtype        = vt_end
    }
};

static vmiopd_mdesc_t vmiopd_mdesc_t_rpc_gpuacct_perfmon_util_samples_v17_00 = {
    .name = "rpc_gpuacct_perfmon_util_samples",
    .header_length = NV_SIZEOF32(rpc_gpuacct_perfmon_util_samples_v17_00),
    .fdesc = vmiopd_fdesc_t_rpc_gpuacct_perfmon_util_samples_v17_00
};
#endif

#ifndef SKIP_PRINT_rpc_vgpu_gsp_plugin_triggered_v17_00
static vmiopd_fdesc_t vmiopd_fdesc_t_rpc_vgpu_gsp_plugin_triggered_v17_00[] = {
    {
        .vtype                = vtype_NvU32,
        .offset               = NV_OFFSETOF(rpc_vgpu_gsp_plugin_triggered_v17_00, gfid),
        .name                 = "gfid"
    },
    {
        .vtype                = vtype_NvU32,
        .offset               = NV_OFFSETOF(rpc_vgpu_gsp_plugin_triggered_v17_00, notifyIndex),
        .name                 = "notifyIndex"
    },
    {
        .vtype        = vt_end
    }
};

static vmiopd_mdesc_t vmiopd_mdesc_t_rpc_vgpu_gsp_plugin_triggered_v17_00 = {
    .name = "rpc_vgpu_gsp_plugin_triggered",
    .header_length = NV_SIZEOF32(rpc_vgpu_gsp_plugin_triggered_v17_00),
    .fdesc = vmiopd_fdesc_t_rpc_vgpu_gsp_plugin_triggered_v17_00
};
#endif

#ifndef SKIP_PRINT_rpc_vgpu_config_event_v17_00
static vmiopd_fdesc_t vmiopd_fdesc_t_rpc_vgpu_config_event_v17_00[] = {
    {
        .vtype                = vtype_NvU32,
        .offset               = NV_OFFSETOF(rpc_vgpu_config_event_v17_00, notifyIndex),
        .name                 = "notifyIndex"
    },
    {
        .vtype        = vt_end
    }
};

static vmiopd_mdesc_t vmiopd_mdesc_t_rpc_vgpu_config_event_v17_00 = {
    .name = "rpc_vgpu_config_event",
    .header_length = NV_SIZEOF32(rpc_vgpu_config_event_v17_00),
    .fdesc = vmiopd_fdesc_t_rpc_vgpu_config_event_v17_00
};
#endif

#ifndef SKIP_PRINT_rpc_dce_rm_init_v01_00
static vmiopd_fdesc_t vmiopd_fdesc_t_rpc_dce_rm_init_v01_00[] = {
    {
        .vtype                = vtype_NvBool,
        .offset               = NV_OFFSETOF(rpc_dce_rm_init_v01_00, bInit),
        .name                 = "bInit"
    },
    {
        .vtype        = vt_end
    }
};

static vmiopd_mdesc_t vmiopd_mdesc_t_rpc_dce_rm_init_v01_00 = {
    .name = "rpc_dce_rm_init",
    .header_length = NV_SIZEOF32(rpc_dce_rm_init_v01_00),
    .fdesc = vmiopd_fdesc_t_rpc_dce_rm_init_v01_00
};
#endif

#ifndef SKIP_PRINT_rpc_sim_read_v1E_01
static vmiopd_fdesc_t vmiopd_fdesc_t_rpc_sim_read_v1E_01[] = {
    {
        .vtype                = vtype_char_array,
        .offset               = NV_OFFSETOF(rpc_sim_read_v1E_01, path),
        .array_length         = 0x100,
        .name                 = "path"
    },
    {
        .vtype                = vtype_NvU32,
        .offset               = NV_OFFSETOF(rpc_sim_read_v1E_01, index),
        .name                 = "index"
    },
    {
        .vtype                = vtype_NvU32,
        .offset               = NV_OFFSETOF(rpc_sim_read_v1E_01, count),
        .name                 = "count"
    },
    {
        .vtype        = vt_end
    }
};

static vmiopd_mdesc_t vmiopd_mdesc_t_rpc_sim_read_v1E_01 = {
    .name = "rpc_sim_read",
    .header_length = NV_SIZEOF32(rpc_sim_read_v1E_01),
    .fdesc = vmiopd_fdesc_t_rpc_sim_read_v1E_01
};
#endif

#ifndef SKIP_PRINT_rpc_sim_write_v1E_01
static vmiopd_fdesc_t vmiopd_fdesc_t_rpc_sim_write_v1E_01[] = {
    {
        .vtype                = vtype_char_array,
        .offset               = NV_OFFSETOF(rpc_sim_write_v1E_01, path),
        .array_length         = 0x100,
        .name                 = "path"
    },
    {
        .vtype                = vtype_NvU32,
        .offset               = NV_OFFSETOF(rpc_sim_write_v1E_01, index),
        .name                 = "index"
    },
    {
        .vtype                = vtype_NvU32,
        .offset               = NV_OFFSETOF(rpc_sim_write_v1E_01, count),
        .name                 = "count"
    },
    {
        .vtype                = vtype_NvU32,
        .offset               = NV_OFFSETOF(rpc_sim_write_v1E_01, data),
        .name                 = "data"
    },
    {
        .vtype        = vt_end
    }
};

static vmiopd_mdesc_t vmiopd_mdesc_t_rpc_sim_write_v1E_01 = {
    .name = "rpc_sim_write",
    .header_length = NV_SIZEOF32(rpc_sim_write_v1E_01),
    .fdesc = vmiopd_fdesc_t_rpc_sim_write_v1E_01
};
#endif

#ifndef SKIP_PRINT_rpc_ucode_libos_print_v1E_08
static vmiopd_fdesc_t vmiopd_fdesc_t_rpc_ucode_libos_print_v1E_08[] = {
    {
        .vtype                = vtype_NvU32,
        .offset               = NV_OFFSETOF(rpc_ucode_libos_print_v1E_08, ucodeEngDesc),
        .name                 = "ucodeEngDesc"
    },
    {
        .vtype                = vtype_NvU32,
        .offset               = NV_OFFSETOF(rpc_ucode_libos_print_v1E_08, libosPrintBufSize),
        .name                 = "libosPrintBufSize"
    },
    {
        .vtype                = vtype_NvU8_array,
        .offset               = NV_OFFSETOF(rpc_ucode_libos_print_v1E_08, libosPrintBuf),
        .array_length         = 0,
        .name                 = "libosPrintBuf"
    },
    {
        .vtype        = vt_end
    }
};

static vmiopd_mdesc_t vmiopd_mdesc_t_rpc_ucode_libos_print_v1E_08 = {
    .name = "rpc_ucode_libos_print",
    .header_length = NV_SIZEOF32(rpc_ucode_libos_print_v1E_08),
    .fdesc = vmiopd_fdesc_t_rpc_ucode_libos_print_v1E_08
};
#endif

#ifndef SKIP_PRINT_rpc_init_done_v17_00
static vmiopd_fdesc_t vmiopd_fdesc_t_rpc_init_done_v17_00[] = {
    {
        .vtype                = vtype_NvU32,
        .offset               = NV_OFFSETOF(rpc_init_done_v17_00, not_used),
        .name                 = "not_used"
    },
    {
        .vtype        = vt_end
    }
};

static vmiopd_mdesc_t vmiopd_mdesc_t_rpc_init_done_v17_00 = {
    .name = "rpc_init_done",
    .header_length = NV_SIZEOF32(rpc_init_done_v17_00),
    .fdesc = vmiopd_fdesc_t_rpc_init_done_v17_00
};
#endif

#ifndef SKIP_PRINT_rpc_semaphore_schedule_callback_v17_00
static vmiopd_fdesc_t vmiopd_fdesc_t_rpc_semaphore_schedule_callback_v17_00[] = {
    {
        .vtype                = vtype_NvU64,
        .offset               = NV_OFFSETOF(rpc_semaphore_schedule_callback_v17_00, GPUVA),
        .name                 = "GPUVA"
    },
    {
        .vtype                = vtype_NvU32,
        .offset               = NV_OFFSETOF(rpc_semaphore_schedule_callback_v17_00, hVASpace),
        .name                 = "hVASpace"
    },
    {
        .vtype                = vtype_NvU32,
        .offset               = NV_OFFSETOF(rpc_semaphore_schedule_callback_v17_00, ReleaseValue),
        .name                 = "ReleaseValue"
    },
    {
        .vtype                = vtype_NvU32,
        .offset               = NV_OFFSETOF(rpc_semaphore_schedule_callback_v17_00, Flags),
        .name                 = "Flags"
    },
    {
        .vtype                = vtype_NvU32,
        .offset               = NV_OFFSETOF(rpc_semaphore_schedule_callback_v17_00, completionStatus),
        .name                 = "completionStatus"
    },
    {
        .vtype                = vtype_NvHandle,
        .offset               = NV_OFFSETOF(rpc_semaphore_schedule_callback_v17_00, hClient),
        .name                 = "hClient"
    },
    {
        .vtype                = vtype_NvHandle,
        .offset               = NV_OFFSETOF(rpc_semaphore_schedule_callback_v17_00, hEvent),
        .name                 = "hEvent"
    },
    {
        .vtype        = vt_end
    }
};

static vmiopd_mdesc_t vmiopd_mdesc_t_rpc_semaphore_schedule_callback_v17_00 = {
    .name = "rpc_semaphore_schedule_callback",
    .header_length = NV_SIZEOF32(rpc_semaphore_schedule_callback_v17_00),
    .fdesc = vmiopd_fdesc_t_rpc_semaphore_schedule_callback_v17_00
};
#endif

#ifndef SKIP_PRINT_rpc_timed_semaphore_release_v01_00
static vmiopd_fdesc_t vmiopd_fdesc_t_rpc_timed_semaphore_release_v01_00[] = {
    {
        .vtype                = vtype_NvU64,
        .offset               = NV_OFFSETOF(rpc_timed_semaphore_release_v01_00, semaphoreVA),
        .name                 = "semaphoreVA"
    },
    {
        .vtype                = vtype_NvU64,
        .offset               = NV_OFFSETOF(rpc_timed_semaphore_release_v01_00, notifierVA),
        .name                 = "notifierVA"
    },
    {
        .vtype                = vtype_NvU32,
        .offset               = NV_OFFSETOF(rpc_timed_semaphore_release_v01_00, hVASpace),
        .name                 = "hVASpace"
    },
    {
        .vtype                = vtype_NvU32,
        .offset               = NV_OFFSETOF(rpc_timed_semaphore_release_v01_00, releaseValue),
        .name                 = "releaseValue"
    },
    {
        .vtype                = vtype_NvU32,
        .offset               = NV_OFFSETOF(rpc_timed_semaphore_release_v01_00, completionStatus),
        .name                 = "completionStatus"
    },
    {
        .vtype                = vtype_NvHandle,
        .offset               = NV_OFFSETOF(rpc_timed_semaphore_release_v01_00, hClient),
        .name                 = "hClient"
    },
    {
        .vtype        = vt_end
    }
};

static vmiopd_mdesc_t vmiopd_mdesc_t_rpc_timed_semaphore_release_v01_00 = {
    .name = "rpc_timed_semaphore_release",
    .header_length = NV_SIZEOF32(rpc_timed_semaphore_release_v01_00),
    .fdesc = vmiopd_fdesc_t_rpc_timed_semaphore_release_v01_00
};
#endif

#ifndef SKIP_PRINT_rpc_perf_gpu_boost_sync_limits_callback_v17_00
static vmiopd_fdesc_t vmiopd_fdesc_t_rpc_perf_gpu_boost_sync_limits_callback_v17_00[] = {
    {
        .vtype                = vtype_NV2080_CTRL_INTERNAL_PERF_GPU_BOOST_SYNC_SET_LIMITS_PARAMS_v17_00,
        .offset               = NV_OFFSETOF(rpc_perf_gpu_boost_sync_limits_callback_v17_00, params),
        .name                 = "params"
    },
    {
        .vtype        = vt_end
    }
};

static vmiopd_mdesc_t vmiopd_mdesc_t_rpc_perf_gpu_boost_sync_limits_callback_v17_00 = {
    .name = "rpc_perf_gpu_boost_sync_limits_callback",
    .header_length = NV_SIZEOF32(rpc_perf_gpu_boost_sync_limits_callback_v17_00),
    .fdesc = vmiopd_fdesc_t_rpc_perf_gpu_boost_sync_limits_callback_v17_00
};
#endif

#ifndef SKIP_PRINT_rpc_perf_bridgeless_info_update_v17_00
static vmiopd_fdesc_t vmiopd_fdesc_t_rpc_perf_bridgeless_info_update_v17_00[] = {
    {
        .vtype                = vtype_NvU64,
        .offset               = NV_OFFSETOF(rpc_perf_bridgeless_info_update_v17_00, bBridgeless),
        .name                 = "bBridgeless"
    },
    {
        .vtype        = vt_end
    }
};

static vmiopd_mdesc_t vmiopd_mdesc_t_rpc_perf_bridgeless_info_update_v17_00 = {
    .name = "rpc_perf_bridgeless_info_update",
    .header_length = NV_SIZEOF32(rpc_perf_bridgeless_info_update_v17_00),
    .fdesc = vmiopd_fdesc_t_rpc_perf_bridgeless_info_update_v17_00
};
#endif

#ifndef SKIP_PRINT_rpc_nvlink_fault_up_v17_00
static vmiopd_fdesc_t vmiopd_fdesc_t_rpc_nvlink_fault_up_v17_00[] = {
    {
        .vtype                = vtype_NvU32,
        .offset               = NV_OFFSETOF(rpc_nvlink_fault_up_v17_00, linkId),
        .name                 = "linkId"
    },
    {
        .vtype        = vt_end
    }
};

static vmiopd_mdesc_t vmiopd_mdesc_t_rpc_nvlink_fault_up_v17_00 = {
    .name = "rpc_nvlink_fault_up",
    .header_length = NV_SIZEOF32(rpc_nvlink_fault_up_v17_00),
    .fdesc = vmiopd_fdesc_t_rpc_nvlink_fault_up_v17_00
};
#endif

#ifndef SKIP_PRINT_rpc_nvlink_inband_received_data_256_v17_00
static vmiopd_fdesc_t vmiopd_fdesc_t_rpc_nvlink_inband_received_data_256_v17_00[] = {
    {
        .vtype                = vtype_NV2080_CTRL_NVLINK_INBAND_RECEIVED_DATA_256_PARAMS_v17_00,
        .offset               = NV_OFFSETOF(rpc_nvlink_inband_received_data_256_v17_00, params),
        .name                 = "params"
    },
    {
        .vtype        = vt_end
    }
};

static vmiopd_mdesc_t vmiopd_mdesc_t_rpc_nvlink_inband_received_data_256_v17_00 = {
    .name = "rpc_nvlink_inband_received_data_256",
    .header_length = NV_SIZEOF32(rpc_nvlink_inband_received_data_256_v17_00),
    .fdesc = vmiopd_fdesc_t_rpc_nvlink_inband_received_data_256_v17_00
};
#endif

#ifndef SKIP_PRINT_rpc_nvlink_inband_received_data_512_v17_00
static vmiopd_fdesc_t vmiopd_fdesc_t_rpc_nvlink_inband_received_data_512_v17_00[] = {
    {
        .vtype                = vtype_NV2080_CTRL_NVLINK_INBAND_RECEIVED_DATA_512_PARAMS_v17_00,
        .offset               = NV_OFFSETOF(rpc_nvlink_inband_received_data_512_v17_00, params),
        .name                 = "params"
    },
    {
        .vtype        = vt_end
    }
};

static vmiopd_mdesc_t vmiopd_mdesc_t_rpc_nvlink_inband_received_data_512_v17_00 = {
    .name = "rpc_nvlink_inband_received_data_512",
    .header_length = NV_SIZEOF32(rpc_nvlink_inband_received_data_512_v17_00),
    .fdesc = vmiopd_fdesc_t_rpc_nvlink_inband_received_data_512_v17_00
};
#endif

#ifndef SKIP_PRINT_rpc_nvlink_inband_received_data_1024_v17_00
static vmiopd_fdesc_t vmiopd_fdesc_t_rpc_nvlink_inband_received_data_1024_v17_00[] = {
    {
        .vtype                = vtype_NV2080_CTRL_NVLINK_INBAND_RECEIVED_DATA_1024_PARAMS_v17_00,
        .offset               = NV_OFFSETOF(rpc_nvlink_inband_received_data_1024_v17_00, params),
        .name                 = "params"
    },
    {
        .vtype        = vt_end
    }
};

static vmiopd_mdesc_t vmiopd_mdesc_t_rpc_nvlink_inband_received_data_1024_v17_00 = {
    .name = "rpc_nvlink_inband_received_data_1024",
    .header_length = NV_SIZEOF32(rpc_nvlink_inband_received_data_1024_v17_00),
    .fdesc = vmiopd_fdesc_t_rpc_nvlink_inband_received_data_1024_v17_00
};
#endif

#ifndef SKIP_PRINT_rpc_nvlink_inband_received_data_2048_v17_00
static vmiopd_fdesc_t vmiopd_fdesc_t_rpc_nvlink_inband_received_data_2048_v17_00[] = {
    {
        .vtype                = vtype_NV2080_CTRL_NVLINK_INBAND_RECEIVED_DATA_2048_PARAMS_v17_00,
        .offset               = NV_OFFSETOF(rpc_nvlink_inband_received_data_2048_v17_00, params),
        .name                 = "params"
    },
    {
        .vtype        = vt_end
    }
};

static vmiopd_mdesc_t vmiopd_mdesc_t_rpc_nvlink_inband_received_data_2048_v17_00 = {
    .name = "rpc_nvlink_inband_received_data_2048",
    .header_length = NV_SIZEOF32(rpc_nvlink_inband_received_data_2048_v17_00),
    .fdesc = vmiopd_fdesc_t_rpc_nvlink_inband_received_data_2048_v17_00
};
#endif

#ifndef SKIP_PRINT_rpc_nvlink_inband_received_data_4096_v17_00
static vmiopd_fdesc_t vmiopd_fdesc_t_rpc_nvlink_inband_received_data_4096_v17_00[] = {
    {
        .vtype                = vtype_NV2080_CTRL_NVLINK_INBAND_RECEIVED_DATA_4096_PARAMS_v17_00,
        .offset               = NV_OFFSETOF(rpc_nvlink_inband_received_data_4096_v17_00, params),
        .name                 = "params"
    },
    {
        .vtype        = vt_end
    }
};

static vmiopd_mdesc_t vmiopd_mdesc_t_rpc_nvlink_inband_received_data_4096_v17_00 = {
    .name = "rpc_nvlink_inband_received_data_4096",
    .header_length = NV_SIZEOF32(rpc_nvlink_inband_received_data_4096_v17_00),
    .fdesc = vmiopd_fdesc_t_rpc_nvlink_inband_received_data_4096_v17_00
};
#endif

#ifndef SKIP_PRINT_rpc_nvlink_is_gpu_degraded_v17_00
static vmiopd_fdesc_t vmiopd_fdesc_t_rpc_nvlink_is_gpu_degraded_v17_00[] = {
    {
        .vtype                = vtype_NV2080_CTRL_NVLINK_IS_GPU_DEGRADED_PARAMS_v17_00,
        .offset               = NV_OFFSETOF(rpc_nvlink_is_gpu_degraded_v17_00, params),
        .name                 = "params"
    },
    {
        .vtype        = vt_end
    }
};

static vmiopd_mdesc_t vmiopd_mdesc_t_rpc_nvlink_is_gpu_degraded_v17_00 = {
    .name = "rpc_nvlink_is_gpu_degraded",
    .header_length = NV_SIZEOF32(rpc_nvlink_is_gpu_degraded_v17_00),
    .fdesc = vmiopd_fdesc_t_rpc_nvlink_is_gpu_degraded_v17_00
};
#endif

#ifndef SKIP_PRINT_rpc_gsp_send_user_shared_data_v17_00
static vmiopd_fdesc_t vmiopd_fdesc_t_rpc_gsp_send_user_shared_data_v17_00[] = {
    {
        .vtype                = vtype_NvU32,
        .offset               = NV_OFFSETOF(rpc_gsp_send_user_shared_data_v17_00, data),
        .name                 = "data"
    },
    {
        .vtype        = vt_end
    }
};

static vmiopd_mdesc_t vmiopd_mdesc_t_rpc_gsp_send_user_shared_data_v17_00 = {
    .name = "rpc_gsp_send_user_shared_data",
    .header_length = NV_SIZEOF32(rpc_gsp_send_user_shared_data_v17_00),
    .fdesc = vmiopd_fdesc_t_rpc_gsp_send_user_shared_data_v17_00
};
#endif

#ifndef SKIP_PRINT_rpc_set_sysmem_dirty_page_tracking_buffer_v20_00
static vmiopd_fdesc_t vmiopd_fdesc_t_rpc_set_sysmem_dirty_page_tracking_buffer_v20_00[] = {
    {
        .vtype                = vtype_NvU32,
        .offset               = NV_OFFSETOF(rpc_set_sysmem_dirty_page_tracking_buffer_v20_00, sysmemPfnBitmapRing),
        .name                 = "sysmemPfnBitmapRing"
    },
    {
        .vtype                = vtype_NvU32,
        .offset               = NV_OFFSETOF(rpc_set_sysmem_dirty_page_tracking_buffer_v20_00, sysmemPfnBitmapRingHi),
        .name                 = "sysmemPfnBitmapRingHi"
    },
    {
        .vtype                = vtype_NvU32,
        .offset               = NV_OFFSETOF(rpc_set_sysmem_dirty_page_tracking_buffer_v20_00, sysmemPfnBitmap),
        .name                 = "sysmemPfnBitmap"
    },
    {
        .vtype        = vt_end
    }
};

static vmiopd_mdesc_t vmiopd_mdesc_t_rpc_set_sysmem_dirty_page_tracking_buffer_v20_00 = {
    .name = "rpc_set_sysmem_dirty_page_tracking_buffer",
    .header_length = NV_SIZEOF32(rpc_set_sysmem_dirty_page_tracking_buffer_v20_00),
    .fdesc = vmiopd_fdesc_t_rpc_set_sysmem_dirty_page_tracking_buffer_v20_00
};
#endif

#ifndef SKIP_PRINT_rpc_extdev_intr_service_v17_00
static vmiopd_fdesc_t vmiopd_fdesc_t_rpc_extdev_intr_service_v17_00[] = {
    {
        .vtype                = vtype_NvU8,
        .offset               = NV_OFFSETOF(rpc_extdev_intr_service_v17_00, lossRegStatus),
        .name                 = "lossRegStatus"
    },
    {
        .vtype                = vtype_NvU8,
        .offset               = NV_OFFSETOF(rpc_extdev_intr_service_v17_00, gainRegStatus),
        .name                 = "gainRegStatus"
    },
    {
        .vtype                = vtype_NvU8,
        .offset               = NV_OFFSETOF(rpc_extdev_intr_service_v17_00, miscRegStatus),
        .name                 = "miscRegStatus"
    },
    {
        .vtype                = vtype_NvBool,
        .offset               = NV_OFFSETOF(rpc_extdev_intr_service_v17_00, rmStatus),
        .name                 = "rmStatus"
    },
    {
        .vtype        = vt_end
    }
};

static vmiopd_mdesc_t vmiopd_mdesc_t_rpc_extdev_intr_service_v17_00 = {
    .name = "rpc_extdev_intr_service",
    .header_length = NV_SIZEOF32(rpc_extdev_intr_service_v17_00),
    .fdesc = vmiopd_fdesc_t_rpc_extdev_intr_service_v17_00
};
#endif

#ifndef SKIP_PRINT_rpc_pfm_req_hndlr_state_sync_callback_v21_04
static vmiopd_fdesc_t vmiopd_fdesc_t_rpc_pfm_req_hndlr_state_sync_callback_v21_04[] = {
    {
        .vtype                = vtype_NV2080_CTRL_INTERNAL_PFM_REQ_HNDLR_STATE_SYNC_PARAMS_v21_04,
        .offset               = NV_OFFSETOF(rpc_pfm_req_hndlr_state_sync_callback_v21_04, params),
        .name                 = "params"
    },
    {
        .vtype        = vt_end
    }
};

static vmiopd_mdesc_t vmiopd_mdesc_t_rpc_pfm_req_hndlr_state_sync_callback_v21_04 = {
    .name = "rpc_pfm_req_hndlr_state_sync_callback",
    .header_length = NV_SIZEOF32(rpc_pfm_req_hndlr_state_sync_callback_v21_04),
    .fdesc = vmiopd_fdesc_t_rpc_pfm_req_hndlr_state_sync_callback_v21_04
};
#endif

#ifndef SKIP_PRINT_rpc_gsp_lockdown_notice_v17_00
static vmiopd_fdesc_t vmiopd_fdesc_t_rpc_gsp_lockdown_notice_v17_00[] = {
    {
        .vtype                = vtype_NvBool,
        .offset               = NV_OFFSETOF(rpc_gsp_lockdown_notice_v17_00, bLockdownEngaging),
        .name                 = "bLockdownEngaging"
    },
    {
        .vtype        = vt_end
    }
};

static vmiopd_mdesc_t vmiopd_mdesc_t_rpc_gsp_lockdown_notice_v17_00 = {
    .name = "rpc_gsp_lockdown_notice",
    .header_length = NV_SIZEOF32(rpc_gsp_lockdown_notice_v17_00),
    .fdesc = vmiopd_fdesc_t_rpc_gsp_lockdown_notice_v17_00
};
#endif

#endif

#ifdef RPC_DEBUG_PRINT_FUNCTIONS
// These are definitions for versioned functions. These will be used for RPC logging in the vmioplugin.
#define SDK_DEBUG_PRINT_FUNCTIONS
#include "g_sdk-structures.h"
#undef SDK_DEBUG_PRINT_FUNCTIONS
#ifndef SKIP_PRINT_rpc_nop_v03_00
vmiopd_mdesc_t *rpcdebugNop_v03_00(void)
{
    return &vmiopd_mdesc_t_rpc_nop_v03_00;
}
#endif

#ifndef SKIP_PRINT_rpc_set_guest_system_info_v03_00
vmiopd_mdesc_t *rpcdebugSetGuestSystemInfo_v03_00(void)
{
    return &vmiopd_mdesc_t_rpc_set_guest_system_info_v03_00;
}
#endif

#ifndef SKIP_PRINT_rpc_alloc_memory_v13_01
vmiopd_mdesc_t *rpcdebugAllocMemory_v13_01(void)
{
    return &vmiopd_mdesc_t_rpc_alloc_memory_v13_01;
}
#endif

#ifndef SKIP_PRINT_rpc_free_v03_00
vmiopd_mdesc_t *rpcdebugFree_v03_00(void)
{
    return &vmiopd_mdesc_t_rpc_free_v03_00;
}
#endif

#ifndef SKIP_PRINT_rpc_map_memory_dma_v03_00
vmiopd_mdesc_t *rpcdebugMapMemoryDma_v03_00(void)
{
    return &vmiopd_mdesc_t_rpc_map_memory_dma_v03_00;
}
#endif

#ifndef SKIP_PRINT_rpc_unmap_memory_dma_v03_00
vmiopd_mdesc_t *rpcdebugUnmapMemoryDma_v03_00(void)
{
    return &vmiopd_mdesc_t_rpc_unmap_memory_dma_v03_00;
}
#endif

#ifndef SKIP_PRINT_rpc_dup_object_v03_00
vmiopd_mdesc_t *rpcdebugDupObject_v03_00(void)
{
    return &vmiopd_mdesc_t_rpc_dup_object_v03_00;
}
#endif

#ifndef SKIP_PRINT_rpc_idle_channels_v03_00
vmiopd_mdesc_t *rpcdebugIdleChannels_v03_00(void)
{
    return &vmiopd_mdesc_t_rpc_idle_channels_v03_00;
}
#endif

#ifndef SKIP_PRINT_rpc_unloading_guest_driver_v03_00
vmiopd_mdesc_t *rpcdebugUnloadingGuestDriver_v03_00(void)
{
    return &vmiopd_mdesc_t_rpc_unloading_guest_driver_v03_00;
}
#endif

#ifndef SKIP_PRINT_rpc_unloading_guest_driver_v1F_07
vmiopd_mdesc_t *rpcdebugUnloadingGuestDriver_v1F_07(void)
{
    return &vmiopd_mdesc_t_rpc_unloading_guest_driver_v1F_07;
}
#endif

#ifndef SKIP_PRINT_rpc_gpu_exec_reg_ops_v12_01
vmiopd_mdesc_t *rpcdebugGpuExecRegOps_v12_01(void)
{
    return &vmiopd_mdesc_t_rpc_gpu_exec_reg_ops_v12_01;
}
#endif

#ifndef SKIP_PRINT_rpc_set_page_directory_v1E_05
vmiopd_mdesc_t *rpcdebugSetPageDirectory_v1E_05(void)
{
    return &vmiopd_mdesc_t_rpc_set_page_directory_v1E_05;
}
#endif

#ifndef SKIP_PRINT_rpc_set_page_directory_v03_00
vmiopd_mdesc_t *rpcdebugSetPageDirectory_v03_00(void)
{
    return &vmiopd_mdesc_t_rpc_set_page_directory_v03_00;
}
#endif

#ifndef SKIP_PRINT_rpc_unset_page_directory_v1E_05
vmiopd_mdesc_t *rpcdebugUnsetPageDirectory_v1E_05(void)
{
    return &vmiopd_mdesc_t_rpc_unset_page_directory_v1E_05;
}
#endif

#ifndef SKIP_PRINT_rpc_unset_page_directory_v03_00
vmiopd_mdesc_t *rpcdebugUnsetPageDirectory_v03_00(void)
{
    return &vmiopd_mdesc_t_rpc_unset_page_directory_v03_00;
}
#endif

#ifndef SKIP_PRINT_rpc_get_gsp_static_info_v14_00
vmiopd_mdesc_t *rpcdebugGetGspStaticInfo_v14_00(void)
{
    return &vmiopd_mdesc_t_rpc_get_gsp_static_info_v14_00;
}
#endif

#ifndef SKIP_PRINT_rpc_update_bar_pde_v15_00
vmiopd_mdesc_t *rpcdebugUpdateBarPde_v15_00(void)
{
    return &vmiopd_mdesc_t_rpc_update_bar_pde_v15_00;
}
#endif

#ifndef SKIP_PRINT_rpc_vgpu_pf_reg_read32_v15_00
vmiopd_mdesc_t *rpcdebugVgpuPfRegRead32_v15_00(void)
{
    return &vmiopd_mdesc_t_rpc_vgpu_pf_reg_read32_v15_00;
}
#endif

#ifndef SKIP_PRINT_rpc_ctrl_subdevice_get_p2p_caps_v21_02
vmiopd_mdesc_t *rpcdebugCtrlSubdeviceGetP2pCaps_v21_02(void)
{
    return &vmiopd_mdesc_t_rpc_ctrl_subdevice_get_p2p_caps_v21_02;
}
#endif

#ifndef SKIP_PRINT_rpc_ctrl_bus_set_p2p_mapping_v21_03
vmiopd_mdesc_t *rpcdebugCtrlBusSetP2pMapping_v21_03(void)
{
    return &vmiopd_mdesc_t_rpc_ctrl_bus_set_p2p_mapping_v21_03;
}
#endif

#ifndef SKIP_PRINT_rpc_ctrl_bus_unset_p2p_mapping_v21_03
vmiopd_mdesc_t *rpcdebugCtrlBusUnsetP2pMapping_v21_03(void)
{
    return &vmiopd_mdesc_t_rpc_ctrl_bus_unset_p2p_mapping_v21_03;
}
#endif

#ifndef SKIP_PRINT_rpc_rmfs_init_v15_00
vmiopd_mdesc_t *rpcdebugRmfsInit_v15_00(void)
{
    return &vmiopd_mdesc_t_rpc_rmfs_init_v15_00;
}
#endif

#ifndef SKIP_PRINT_rpc_rmfs_close_queue_v15_00
vmiopd_mdesc_t *rpcdebugRmfsCloseQueue_v15_00(void)
{
    return &vmiopd_mdesc_t_rpc_rmfs_close_queue_v15_00;
}
#endif

#ifndef SKIP_PRINT_rpc_rmfs_cleanup_v15_00
vmiopd_mdesc_t *rpcdebugRmfsCleanup_v15_00(void)
{
    return &vmiopd_mdesc_t_rpc_rmfs_cleanup_v15_00;
}
#endif

#ifndef SKIP_PRINT_rpc_rmfs_test_v15_00
vmiopd_mdesc_t *rpcdebugRmfsTest_v15_00(void)
{
    return &vmiopd_mdesc_t_rpc_rmfs_test_v15_00;
}
#endif

#ifndef SKIP_PRINT_rpc_gsp_set_system_info_v17_00
vmiopd_mdesc_t *rpcdebugGspSetSystemInfo_v17_00(void)
{
    return &vmiopd_mdesc_t_rpc_gsp_set_system_info_v17_00;
}
#endif

#ifndef SKIP_PRINT_rpc_set_registry_v17_00
vmiopd_mdesc_t *rpcdebugSetRegistry_v17_00(void)
{
    return &vmiopd_mdesc_t_rpc_set_registry_v17_00;
}
#endif

#ifndef SKIP_PRINT_rpc_gsp_rm_alloc_v03_00
vmiopd_mdesc_t *rpcdebugGspRmAlloc_v03_00(void)
{
    return &vmiopd_mdesc_t_rpc_gsp_rm_alloc_v03_00;
}
#endif

#ifndef SKIP_PRINT_rpc_gsp_rm_control_v03_00
vmiopd_mdesc_t *rpcdebugGspRmControl_v03_00(void)
{
    return &vmiopd_mdesc_t_rpc_gsp_rm_control_v03_00;
}
#endif

#ifndef SKIP_PRINT_rpc_dump_protobuf_component_v18_12
vmiopd_mdesc_t *rpcdebugDumpProtobufComponent_v18_12(void)
{
    return &vmiopd_mdesc_t_rpc_dump_protobuf_component_v18_12;
}
#endif

#ifndef SKIP_PRINT_rpc_run_cpu_sequencer_v17_00
vmiopd_mdesc_t *rpcdebugRunCpuSequencer_v17_00(void)
{
    return &vmiopd_mdesc_t_rpc_run_cpu_sequencer_v17_00;
}
#endif

#ifndef SKIP_PRINT_rpc_post_event_v17_00
vmiopd_mdesc_t *rpcdebugPostEvent_v17_00(void)
{
    return &vmiopd_mdesc_t_rpc_post_event_v17_00;
}
#endif

#ifndef SKIP_PRINT_rpc_rc_triggered_v17_02
vmiopd_mdesc_t *rpcdebugRcTriggered_v17_02(void)
{
    return &vmiopd_mdesc_t_rpc_rc_triggered_v17_02;
}
#endif

#ifndef SKIP_PRINT_rpc_os_error_log_v17_00
vmiopd_mdesc_t *rpcdebugOsErrorLog_v17_00(void)
{
    return &vmiopd_mdesc_t_rpc_os_error_log_v17_00;
}
#endif

#ifndef SKIP_PRINT_rpc_rg_line_intr_v17_00
vmiopd_mdesc_t *rpcdebugRgLineIntr_v17_00(void)
{
    return &vmiopd_mdesc_t_rpc_rg_line_intr_v17_00;
}
#endif

#ifndef SKIP_PRINT_rpc_display_modeset_v01_00
vmiopd_mdesc_t *rpcdebugDisplayModeset_v01_00(void)
{
    return &vmiopd_mdesc_t_rpc_display_modeset_v01_00;
}
#endif

#ifndef SKIP_PRINT_rpc_gpuacct_perfmon_util_samples_v17_00
vmiopd_mdesc_t *rpcdebugGpuacctPerfmonUtilSamples_v17_00(void)
{
    return &vmiopd_mdesc_t_rpc_gpuacct_perfmon_util_samples_v17_00;
}
#endif

#ifndef SKIP_PRINT_rpc_vgpu_gsp_plugin_triggered_v17_00
vmiopd_mdesc_t *rpcdebugVgpuGspPluginTriggered_v17_00(void)
{
    return &vmiopd_mdesc_t_rpc_vgpu_gsp_plugin_triggered_v17_00;
}
#endif

#ifndef SKIP_PRINT_rpc_vgpu_config_event_v17_00
vmiopd_mdesc_t *rpcdebugVgpuConfigEvent_v17_00(void)
{
    return &vmiopd_mdesc_t_rpc_vgpu_config_event_v17_00;
}
#endif

#ifndef SKIP_PRINT_rpc_dce_rm_init_v01_00
vmiopd_mdesc_t *rpcdebugDceRmInit_v01_00(void)
{
    return &vmiopd_mdesc_t_rpc_dce_rm_init_v01_00;
}
#endif

#ifndef SKIP_PRINT_rpc_sim_read_v1E_01
vmiopd_mdesc_t *rpcdebugSimRead_v1E_01(void)
{
    return &vmiopd_mdesc_t_rpc_sim_read_v1E_01;
}
#endif

#ifndef SKIP_PRINT_rpc_sim_write_v1E_01
vmiopd_mdesc_t *rpcdebugSimWrite_v1E_01(void)
{
    return &vmiopd_mdesc_t_rpc_sim_write_v1E_01;
}
#endif

#ifndef SKIP_PRINT_rpc_ucode_libos_print_v1E_08
vmiopd_mdesc_t *rpcdebugUcodeLibosPrint_v1E_08(void)
{
    return &vmiopd_mdesc_t_rpc_ucode_libos_print_v1E_08;
}
#endif

#ifndef SKIP_PRINT_rpc_init_done_v17_00
vmiopd_mdesc_t *rpcdebugInitDone_v17_00(void)
{
    return &vmiopd_mdesc_t_rpc_init_done_v17_00;
}
#endif

#ifndef SKIP_PRINT_rpc_semaphore_schedule_callback_v17_00
vmiopd_mdesc_t *rpcdebugSemaphoreScheduleCallback_v17_00(void)
{
    return &vmiopd_mdesc_t_rpc_semaphore_schedule_callback_v17_00;
}
#endif

#ifndef SKIP_PRINT_rpc_timed_semaphore_release_v01_00
vmiopd_mdesc_t *rpcdebugTimedSemaphoreRelease_v01_00(void)
{
    return &vmiopd_mdesc_t_rpc_timed_semaphore_release_v01_00;
}
#endif

#ifndef SKIP_PRINT_rpc_perf_gpu_boost_sync_limits_callback_v17_00
vmiopd_mdesc_t *rpcdebugPerfGpuBoostSyncLimitsCallback_v17_00(void)
{
    return &vmiopd_mdesc_t_rpc_perf_gpu_boost_sync_limits_callback_v17_00;
}
#endif

#ifndef SKIP_PRINT_rpc_perf_bridgeless_info_update_v17_00
vmiopd_mdesc_t *rpcdebugPerfBridgelessInfoUpdate_v17_00(void)
{
    return &vmiopd_mdesc_t_rpc_perf_bridgeless_info_update_v17_00;
}
#endif

#ifndef SKIP_PRINT_rpc_nvlink_fault_up_v17_00
vmiopd_mdesc_t *rpcdebugNvlinkFaultUp_v17_00(void)
{
    return &vmiopd_mdesc_t_rpc_nvlink_fault_up_v17_00;
}
#endif

#ifndef SKIP_PRINT_rpc_nvlink_inband_received_data_256_v17_00
vmiopd_mdesc_t *rpcdebugNvlinkInbandReceivedData256_v17_00(void)
{
    return &vmiopd_mdesc_t_rpc_nvlink_inband_received_data_256_v17_00;
}
#endif

#ifndef SKIP_PRINT_rpc_nvlink_inband_received_data_512_v17_00
vmiopd_mdesc_t *rpcdebugNvlinkInbandReceivedData512_v17_00(void)
{
    return &vmiopd_mdesc_t_rpc_nvlink_inband_received_data_512_v17_00;
}
#endif

#ifndef SKIP_PRINT_rpc_nvlink_inband_received_data_1024_v17_00
vmiopd_mdesc_t *rpcdebugNvlinkInbandReceivedData1024_v17_00(void)
{
    return &vmiopd_mdesc_t_rpc_nvlink_inband_received_data_1024_v17_00;
}
#endif

#ifndef SKIP_PRINT_rpc_nvlink_inband_received_data_2048_v17_00
vmiopd_mdesc_t *rpcdebugNvlinkInbandReceivedData2048_v17_00(void)
{
    return &vmiopd_mdesc_t_rpc_nvlink_inband_received_data_2048_v17_00;
}
#endif

#ifndef SKIP_PRINT_rpc_nvlink_inband_received_data_4096_v17_00
vmiopd_mdesc_t *rpcdebugNvlinkInbandReceivedData4096_v17_00(void)
{
    return &vmiopd_mdesc_t_rpc_nvlink_inband_received_data_4096_v17_00;
}
#endif

#ifndef SKIP_PRINT_rpc_nvlink_is_gpu_degraded_v17_00
vmiopd_mdesc_t *rpcdebugNvlinkIsGpuDegraded_v17_00(void)
{
    return &vmiopd_mdesc_t_rpc_nvlink_is_gpu_degraded_v17_00;
}
#endif

#ifndef SKIP_PRINT_rpc_gsp_send_user_shared_data_v17_00
vmiopd_mdesc_t *rpcdebugGspSendUserSharedData_v17_00(void)
{
    return &vmiopd_mdesc_t_rpc_gsp_send_user_shared_data_v17_00;
}
#endif

#ifndef SKIP_PRINT_rpc_set_sysmem_dirty_page_tracking_buffer_v20_00
vmiopd_mdesc_t *rpcdebugSetSysmemDirtyPageTrackingBuffer_v20_00(void)
{
    return &vmiopd_mdesc_t_rpc_set_sysmem_dirty_page_tracking_buffer_v20_00;
}
#endif

#ifndef SKIP_PRINT_rpc_extdev_intr_service_v17_00
vmiopd_mdesc_t *rpcdebugExtdevIntrService_v17_00(void)
{
    return &vmiopd_mdesc_t_rpc_extdev_intr_service_v17_00;
}
#endif

#ifndef SKIP_PRINT_rpc_pfm_req_hndlr_state_sync_callback_v21_04
vmiopd_mdesc_t *rpcdebugPfmReqHndlrStateSyncCallback_v21_04(void)
{
    return &vmiopd_mdesc_t_rpc_pfm_req_hndlr_state_sync_callback_v21_04;
}
#endif

#ifndef SKIP_PRINT_rpc_gsp_lockdown_notice_v17_00
vmiopd_mdesc_t *rpcdebugGspLockdownNotice_v17_00(void)
{
    return &vmiopd_mdesc_t_rpc_gsp_lockdown_notice_v17_00;
}
#endif


#endif

#ifdef RPC_GENERIC_UNION
// This is a generic union, that will be used for the communication between the vmioplugin & guest RM.
typedef union rpc_generic_union {
    rpc_set_guest_system_info_v03_00 set_guest_system_info_v03_00;
    rpc_set_guest_system_info_v set_guest_system_info_v;
    rpc_alloc_memory_v13_01 alloc_memory_v13_01;
    rpc_alloc_memory_v alloc_memory_v;
    rpc_free_v03_00 free_v03_00;
    rpc_free_v free_v;
    rpc_map_memory_dma_v03_00 map_memory_dma_v03_00;
    rpc_map_memory_dma_v map_memory_dma_v;
    rpc_unmap_memory_dma_v03_00 unmap_memory_dma_v03_00;
    rpc_unmap_memory_dma_v unmap_memory_dma_v;
    rpc_dup_object_v03_00 dup_object_v03_00;
    rpc_dup_object_v dup_object_v;
    rpc_idle_channels_v03_00 idle_channels_v03_00;
    rpc_idle_channels_v idle_channels_v;
    rpc_unloading_guest_driver_v1F_07 unloading_guest_driver_v1F_07;
    rpc_unloading_guest_driver_v unloading_guest_driver_v;
    rpc_gpu_exec_reg_ops_v12_01 gpu_exec_reg_ops_v12_01;
    rpc_gpu_exec_reg_ops_v gpu_exec_reg_ops_v;
    rpc_set_page_directory_v1E_05 set_page_directory_v1E_05;
    rpc_set_page_directory_v03_00 set_page_directory_v03_00;
    rpc_set_page_directory_v set_page_directory_v;
    rpc_unset_page_directory_v1E_05 unset_page_directory_v1E_05;
    rpc_unset_page_directory_v03_00 unset_page_directory_v03_00;
    rpc_unset_page_directory_v unset_page_directory_v;
    rpc_get_gsp_static_info_v14_00 get_gsp_static_info_v14_00;
    rpc_get_gsp_static_info_v get_gsp_static_info_v;
    rpc_update_bar_pde_v15_00 update_bar_pde_v15_00;
    rpc_update_bar_pde_v update_bar_pde_v;
    rpc_vgpu_pf_reg_read32_v15_00 vgpu_pf_reg_read32_v15_00;
    rpc_vgpu_pf_reg_read32_v vgpu_pf_reg_read32_v;
    rpc_ctrl_subdevice_get_p2p_caps_v21_02 ctrl_subdevice_get_p2p_caps_v21_02;
    rpc_ctrl_subdevice_get_p2p_caps_v ctrl_subdevice_get_p2p_caps_v;
    rpc_ctrl_bus_set_p2p_mapping_v21_03 ctrl_bus_set_p2p_mapping_v21_03;
    rpc_ctrl_bus_set_p2p_mapping_v ctrl_bus_set_p2p_mapping_v;
    rpc_ctrl_bus_unset_p2p_mapping_v21_03 ctrl_bus_unset_p2p_mapping_v21_03;
    rpc_ctrl_bus_unset_p2p_mapping_v ctrl_bus_unset_p2p_mapping_v;
    rpc_rmfs_init_v15_00 rmfs_init_v15_00;
    rpc_rmfs_init_v rmfs_init_v;
    rpc_rmfs_test_v15_00 rmfs_test_v15_00;
    rpc_rmfs_test_v rmfs_test_v;
    rpc_gsp_set_system_info_v17_00 gsp_set_system_info_v17_00;
    rpc_gsp_set_system_info_v gsp_set_system_info_v;
    rpc_gsp_rm_alloc_v03_00 gsp_rm_alloc_v03_00;
    rpc_gsp_rm_alloc_v gsp_rm_alloc_v;
    rpc_gsp_rm_control_v03_00 gsp_rm_control_v03_00;
    rpc_gsp_rm_control_v gsp_rm_control_v;
    rpc_dump_protobuf_component_v18_12 dump_protobuf_component_v18_12;
    rpc_dump_protobuf_component_v dump_protobuf_component_v;
    rpc_run_cpu_sequencer_v17_00 run_cpu_sequencer_v17_00;
    rpc_run_cpu_sequencer_v run_cpu_sequencer_v;
    rpc_post_event_v17_00 post_event_v17_00;
    rpc_post_event_v post_event_v;
    rpc_rc_triggered_v17_02 rc_triggered_v17_02;
    rpc_rc_triggered_v rc_triggered_v;
    rpc_os_error_log_v17_00 os_error_log_v17_00;
    rpc_os_error_log_v os_error_log_v;
    rpc_rg_line_intr_v17_00 rg_line_intr_v17_00;
    rpc_rg_line_intr_v rg_line_intr_v;
    rpc_display_modeset_v01_00 display_modeset_v01_00;
    rpc_display_modeset_v display_modeset_v;
    rpc_gpuacct_perfmon_util_samples_v17_00 gpuacct_perfmon_util_samples_v17_00;
    rpc_gpuacct_perfmon_util_samples_v gpuacct_perfmon_util_samples_v;
    rpc_vgpu_gsp_plugin_triggered_v17_00 vgpu_gsp_plugin_triggered_v17_00;
    rpc_vgpu_gsp_plugin_triggered_v vgpu_gsp_plugin_triggered_v;
    rpc_vgpu_config_event_v17_00 vgpu_config_event_v17_00;
    rpc_vgpu_config_event_v vgpu_config_event_v;
    rpc_dce_rm_init_v01_00 dce_rm_init_v01_00;
    rpc_dce_rm_init_v dce_rm_init_v;
    rpc_sim_read_v1E_01 sim_read_v1E_01;
    rpc_sim_read_v sim_read_v;
    rpc_sim_write_v1E_01 sim_write_v1E_01;
    rpc_sim_write_v sim_write_v;
    rpc_ucode_libos_print_v1E_08 ucode_libos_print_v1E_08;
    rpc_ucode_libos_print_v ucode_libos_print_v;
    rpc_init_done_v17_00 init_done_v17_00;
    rpc_init_done_v init_done_v;
    rpc_semaphore_schedule_callback_v17_00 semaphore_schedule_callback_v17_00;
    rpc_semaphore_schedule_callback_v semaphore_schedule_callback_v;
    rpc_timed_semaphore_release_v01_00 timed_semaphore_release_v01_00;
    rpc_timed_semaphore_release_v timed_semaphore_release_v;
    rpc_perf_gpu_boost_sync_limits_callback_v17_00 perf_gpu_boost_sync_limits_callback_v17_00;
    rpc_perf_gpu_boost_sync_limits_callback_v perf_gpu_boost_sync_limits_callback_v;
    rpc_perf_bridgeless_info_update_v17_00 perf_bridgeless_info_update_v17_00;
    rpc_perf_bridgeless_info_update_v perf_bridgeless_info_update_v;
    rpc_nvlink_fault_up_v17_00 nvlink_fault_up_v17_00;
    rpc_nvlink_fault_up_v nvlink_fault_up_v;
    rpc_nvlink_inband_received_data_256_v17_00 nvlink_inband_received_data_256_v17_00;
    rpc_nvlink_inband_received_data_256_v nvlink_inband_received_data_256_v;
    rpc_nvlink_inband_received_data_512_v17_00 nvlink_inband_received_data_512_v17_00;
    rpc_nvlink_inband_received_data_512_v nvlink_inband_received_data_512_v;
    rpc_nvlink_inband_received_data_1024_v17_00 nvlink_inband_received_data_1024_v17_00;
    rpc_nvlink_inband_received_data_1024_v nvlink_inband_received_data_1024_v;
    rpc_nvlink_inband_received_data_2048_v17_00 nvlink_inband_received_data_2048_v17_00;
    rpc_nvlink_inband_received_data_2048_v nvlink_inband_received_data_2048_v;
    rpc_nvlink_inband_received_data_4096_v17_00 nvlink_inband_received_data_4096_v17_00;
    rpc_nvlink_inband_received_data_4096_v nvlink_inband_received_data_4096_v;
    rpc_nvlink_is_gpu_degraded_v17_00 nvlink_is_gpu_degraded_v17_00;
    rpc_nvlink_is_gpu_degraded_v nvlink_is_gpu_degraded_v;
    rpc_gsp_send_user_shared_data_v17_00 gsp_send_user_shared_data_v17_00;
    rpc_gsp_send_user_shared_data_v gsp_send_user_shared_data_v;
    rpc_set_sysmem_dirty_page_tracking_buffer_v20_00 set_sysmem_dirty_page_tracking_buffer_v20_00;
    rpc_set_sysmem_dirty_page_tracking_buffer_v set_sysmem_dirty_page_tracking_buffer_v;
    rpc_extdev_intr_service_v17_00 extdev_intr_service_v17_00;
    rpc_extdev_intr_service_v extdev_intr_service_v;
    rpc_pfm_req_hndlr_state_sync_callback_v21_04 pfm_req_hndlr_state_sync_callback_v21_04;
    rpc_pfm_req_hndlr_state_sync_callback_v pfm_req_hndlr_state_sync_callback_v;
    rpc_gsp_lockdown_notice_v17_00 gsp_lockdown_notice_v17_00;
    rpc_gsp_lockdown_notice_v gsp_lockdown_notice_v;
} rpc_generic_union;

#endif

#ifdef RPC_UNION_MEMBER_NAME_FUNCTIONS_CMD
#define SDK_UNION_MEMBER_NAME_FUNCTIONS_CMD
#include "g_sdk-structures.h"
#undef SDK_UNION_MEMBER_NAME_FUNCTIONS_CMD

#endif


#ifdef RPC_ARRAY_LENGTH_FUNCTIONS
#define SDK_ARRAY_LENGTH_FUNCTIONS
#include "g_sdk-structures.h"
#undef SDK_ARRAY_LENGTH_FUNCTIONS

// Array length functions for IDLE_CHANNELS:
static NV_STATUS get_array_length_rpc_idle_channels_v03_00_channel_list(void *msg, NvS32 bytes_remaining, uint32_t* length)
{
    rpc_idle_channels_v03_00 *param = msg;

    if ((NvS32)(NV_OFFSETOF(rpc_idle_channels_v03_00, nchannels) + sizeof(param->nchannels)) > bytes_remaining)
        return NV_ERR_BUFFER_TOO_SMALL;

    *length = param->nchannels;
    return NV_OK;
}

#endif

#ifdef AUTOGENERATE_RPC_MIN_SUPPORTED_VERSION_INFORMATION
#define NV_VGPU_GRIDSW_VERSION_MIN_SUPPORTED_INTERNAL_MAJOR 0x18
#define NV_VGPU_GRIDSW_VERSION_MIN_SUPPORTED_INTERNAL_MINOR 0x00
#endif
