
#include <Vlib.h>
#include <VFont.h>
#include <VRoman.h>
/*ARGSUSED */
int
VFontWidthPixels(Viewport * v, int scale)
{
	return VRomanGlyph['A'].glyph_width * scale / 25600;
}

void
VDrawStrokeString(Viewport * v, int x, int y,
				  unsigned char *str, int len, int scale, ZInfo * zinfo)
{

	register int c, i, k, m;
	register VGlyphVertex *p;
	register int x1, y1, x2, y2;

	for (; len > 0; --len) {

		if ((c = *str++) < 128) {
			k = VRomanGlyph[c].path_start;
			for (i = 0; i < VRomanGlyph[c].path_count; ++i, ++k) {
				p = &VRomanVertex[VRomanPath[k].vertex_start];
				x1 = p->x * scale / 25600 + x;
				y1 = y - p->y * scale / 25600;
				++p;
				for (m = 1; m < VRomanPath[k].vertex_count; ++m, ++p) {
					x2 = p->x * scale / 25600 + x;
					y2 = y - p->y * scale / 25600;
					v->DrawLine(v, x1, y1, x2, y2, zinfo->color);
					x1 = x2;
					y1 = y2;
				}
			}

			x += VRomanGlyph[c].glyph_width * scale / 25600;

		}
	}
}

void
VGetStrokeString(Viewport * v, int x, int y, Segment * seg, int *nseg,
				 unsigned char *str, int len, int scale)
{

	register int c, i, k, m, count;
	register VGlyphVertex *p;
	register int x1, y1, x2, y2;
	Segment  *pseg;

	count = *nseg;

	for (; len > 0; --len) {

		if ((c = *str++) < 128) {
			k = VRomanGlyph[c].path_start;
			for (i = 0; i < VRomanGlyph[c].path_count; ++i, ++k) {
				p = &VRomanVertex[VRomanPath[k].vertex_start];
				x1 = p->x * scale / 25600 + x;
				y1 = y - p->y * scale / 25600;
				++p;
				for (m = 1; m < VRomanPath[k].vertex_count; ++m, ++p) {
					x2 = p->x * scale / 25600 + x;
					y2 = y - p->y * scale / 25600;
					pseg = &seg[count++];
					pseg->x1 = x1;
					pseg->x2 = x2;
					pseg->y1 = y1;
					pseg->y2 = y2;
					x1 = x2;
					y1 = y2;
				}
			}

			x += VRomanGlyph[c].glyph_width * scale / 25600;

		}
	}

	*nseg = count;
}
