// ---------------------------------------------------------------------------
// - Basexx.hpp                                                              -
// - afnix:uri service - base 16/32/64 codec class definition                -
// ---------------------------------------------------------------------------
// - This program is free software;  you can redistribute it  and/or  modify -
// - it provided that this copyright notice is kept intact.                  -
// -                                                                         -
// - This program  is  distributed in  the hope  that it will be useful, but -
// - without  any  warranty;  without  even   the   implied    warranty   of -
// - merchantability or fitness for a particular purpose.  In no event shall -
// - the copyright holder be liable for any  direct, indirect, incidental or -
// - special damages arising in any way out of the use of this software.     -
// ---------------------------------------------------------------------------
// - copyright (c) 1999-2019 amaury darsch                                   -
// ---------------------------------------------------------------------------

#ifndef  AFNIX_BASEXX_HPP
#define  AFNIX_BASEXX_HPP

#ifndef  AFNIX_CODEC_HPP
#include "Codec.hpp"
#endif

namespace afnix {

  /// The Basexx class is a codec that implements the rfc 4648 for
  /// base 64/32/16 encoding. The operation of the base codec are governed
  /// by the type of encoding selected which is the standard base 64 by
  /// default.
  /// @author amaury darsch

  class Basexx : public Codec {
  public:
    enum t_base
      {
       BASE_SC64, // standard base 64
       BASE_UC64, // url encoding base 64
       BASE_SC32, // standard base 32
       BASE_EC32, // extended encoding base 32
       BASE_SC16  // standard base 16
      };
    
  private:
    /// the base encoding
    t_base d_base;
    /// the private codec
    struct s_codc* p_codc;
    
  public:
    /// create a default base codec
    Basexx (void);

    /// create a base codec by type
    /// @param  base the base type
    Basexx (const t_base base);

    /// destroy this base codec
    ~Basexx (void);
    
    /// @return the class name
    String repr (void) const;

    /// reset the base codec
    void reset (void);

    /// clear the base codec
    void clear (void);

  protected:
    /// encode an input buffer into an output buffer
    /// @param ob the output buffer to write
    /// @param ib the input  buffer to read
    /// @return the number of processed bytes
    long encode (Buffer& ob, Buffer& ib);

    /// encode an input stream into an output buffer
    /// @param ob the output buffer to write
    /// @param is the input  stream to read
    /// @return the number of processed bytes
    long encode (Buffer& ob, InputStream& is);

    /// encode an input stream into an output stream
    /// @param os the output stream to write
    /// @param is the input stream to read
    /// @return the number of processed bytes
    long encode (OutputStream& os, InputStream& is);

    /// decode an input buffer into an output buffer
    /// @param ob the output buffer to write
    /// @param ib the input  buffer to read
    /// @return the number of processed bytes
    long decode (Buffer& ob, Buffer& ib);

    /// decode an input stream into an output buffer
    /// @param ob the output buffer to write
    /// @param is the input  stream to read
    /// @return the number of processed bytes
    long decode (Buffer& ob, InputStream& is);

    /// decode an input stream into an output stream
    /// @param os the output stream to write
    /// @param is the input stream to read
    /// @return the number of processed bytes
    long decode (OutputStream& os, InputStream& is);

  private:
    // make the copy constructor private
    Basexx (const Basexx&) =delete;
    // make the assignement operator private
    Basexx& operator = (const Basexx&) =delete;

  public:
    /// evaluate an object data member
    /// @param robj  the current runnable
    /// @param nset  the current nameset
    /// @param quark the quark to evaluate
    static Object* meval (Runnable* robj, Nameset* nset, const long quark);

    /// create a new object in a generic way
    /// @param argv the argument vector
    static Object* mknew (Vector* argv);
  };
}

#endif
