      INTEGER FUNCTION MSSTOP(ISTOP,ITERS,ITMAX,ERRTOL,STPTST,IERROR,
     2   R,S,Z,N,RNORM,SNORM,ZNORM,DENOM,CONDA,IDO)
C***BEGIN PROLOGUE  MSSTOP
C***REFER TO  SCGDRV
C***ROUTINES CALLED  
C***REVISION DATE  900210   (YYMMDD)
C***END PROLOGUE  MSSTOP
C
C     STOPPING CRITERION MENU
C        ISTOP = 0  ||E||/||E0||      <= ERRTOL  (DEFAULT)
C        ISTOP = 1  ||R||             <= ERRTOL 
C        ISTOP = 2  ||R||/||B||       <= ERRTOL
C        ISTOP = 3  ||C*R||           <= ERRTOL
C        ISTOP = 4  ||C*R||/||C*B||   <= ERRTOL
C     WHERE E=ERROR, R=RESIDUAL, B=RIGHT HAND SIDE OF A*X=B, 
C     AND C IS THE PRECONDITIONING MATRIX OR PRECONDITIONING 
C     POLYNOMIAL (OR BOTH.) 
C     NOTE: IF ISTOP=0 IS SELECTED BY THE USER, THEN ERRTOL 
C     IS THE AMOUNT BY WHICH THE INITIAL ERROR IS TO BE 
C     REDUCED.  BY ESTIMATING THE CONDITION NUMBER OF THE 
C     ITERATION MATRIX, THE CODE ATTEMPTS TO GUARANTEE THAT 
C     THE FINAL RELATIVE ERROR IS .LE. ERRTOL.  SEE THE LONG 
C     DESCRIPTION OF SCGDRV FOR DETAILS.
C
C     NOTE:  ISTOP,ITERS,ITMAX,ERRTOL,STPTST,IERROR ARE AS DESCRIBED
C               IN THE DOCUMENTATION OF SCGDRV.
C            R,S,Z ARE RESIDUAL VECTORS.
C            N IS THE LENGTH OF R,S,Z.
C            RNORM,SNORM,ZNORM ARE THE NORMS OF R,S,Z IF THE ROUTINE
C               HAS HAD TO COMPUTE THEM IN ITS ALGORITHM ALREADY.
C            DENOM IS THE APPROPRIATE DENOMINATOR FOR THE STOPPING 
C               CRITERION STPTST IF ISTOP=0,2,4 IS SELECTED.
C            CONDA IS THE CONDITION ESTIMATE IF ISTOP=0 IS SELECTED.
C            IDO IS A FLAG TO DETERMINE IF ONE OF RNORM,SNORM, OR
C               ZNORM HAS BEEN COMPUTED OR STILL NEEDS TO BE COMPUTED.
C
C     NOTE:  THE FLAG ISTOP IS INTERPRETED AS:
C            IF (ISTOP .EQ. 0) MSSTOP = SNRM2(N,Z,1)*CONDA/DENOM
C            IF (ISTOP .EQ. 1) MSSTOP = SNRM2(N,R,1)
C            IF (ISTOP .EQ. 2) MSSTOP = SNRM2(N,R,1)/DENOM
C            IF (ISTOP .EQ. 3) MSSTOP = SNRM2(N,S,1)
C            IF (ISTOP .EQ. 4) MSSTOP = SNRM2(N,S,1)/DENOM
C
C     NOTE:  THE FLAG IDO IS INTERPRETED AS:
C            IF (IDO .EQ. 1) THEN THE CALLING ROUTINE HAS ALREADY
C               COMPUTED THE APPROPRIATE NUMERATOR QUANTITY, AND IT'S 
C               VALUE IS CONTAINED IN THE PARAMETER DETERMINED BY ISTOP;
C               EITHER RNORM,SNORM, OR ZNORM.
C            IF (IDO .EQ. 0) THEN THE CALLING ROUTINE REQUESTS THAT
C               ROUTINE MSSTOP COMPUTE THE APPROPRIATE QUANTITY,
C               FROM ONE OF R,S, OR Z.
C
C     *** DECLARATIONS ***
CCCCCCIMPLICIT  DOUBLE PRECISION(A-H,O-Z)
      DIMENSION R(*),S(*),Z(*)
C
C***FIRST EXECUTABLE STATEMENT  MSSTOP
 1    CONTINUE
C
C     *** COMPUTE STPTST ***
      IF (IDO .EQ. 0) THEN
         IF (ISTOP .EQ. 0) ZNORM = SNRM2(N,Z,1)
         IF ((ISTOP .EQ. 1) .OR. (ISTOP .EQ. 2)) RNORM = SNRM2(N,R,1)
         IF ((ISTOP .EQ. 3) .OR. (ISTOP .EQ. 4)) SNORM = SNRM2(N,S,1)
      ENDIF
      IF (ISTOP .EQ. 0) STPTST = ZNORM*CONDA/DENOM
      IF (ISTOP .EQ. 1) STPTST = RNORM
      IF (ISTOP .EQ. 2) STPTST = RNORM/DENOM
      IF (ISTOP .EQ. 3) STPTST = SNORM
      IF (ISTOP .EQ. 4) STPTST = SNORM/DENOM
C
C     *** CHECK THE STOPPING CRITERION ***
      MSSTOP = 0
      IF (STPTST .LE. ERRTOL) THEN
         MSSTOP = 1
         RETURN
      ENDIF
      IF (ITERS .GE. ITMAX) THEN
         IERROR = -1000
         MSSTOP = 1
         RETURN
      ENDIF
C
      RETURN
      END
