/* Bindings of osmesa.ldg
 * Compile this module and link it with the application client
 */

#include <gem.h>
#include <stdlib.h>
#include <ldg.h>
#define NFOSMESA_NO_MANGLE
#include <ldg/osmesa.h>

#ifndef TRUE
# define TRUE 1
# define FALSE 0
#endif

struct _gl_osmesa gl;

#if defined(__PUREC__) && !defined(__AHCC__)
/*
 * Pure-C is not able to compile the result if you enable it,
 * probable the function gets too large
 */
# define GL_CHECK(x)
#else
# define GL_CHECK(x) if (x == 0) result = FALSE
#endif


static APIENTRY OSMESAproc real_OSMesaGetProcAddress(const char *funcname)
{
	unsigned int func = (unsigned int)((*gl.__old_OSMesaGetProcAddress)(funcname));
	if (func == 0 || func > gl.__numfuncs)
		return 0;
	--func;
	return (OSMESAproc)(((void **)(&gl))[func]);
}


int ldg_init_osmesa(LDG *lib)
{
	int result = TRUE;
	struct _gl_osmesa *glp = &gl;
	
#undef glClearDepth
#undef glFrustum
#undef glOrtho
#undef gluLookAt
	glp->GetString = (const GLubyte * APIENTRY (*)(GLenum name)) ldg_find("glGetString", lib);
	GL_CHECK(glp->GetString);
	glp->OSMesaCreateContext = (OSMesaContext APIENTRY (*)(GLenum format, OSMesaContext sharelist)) ldg_find("OSMesaCreateContext", lib);
	GL_CHECK(glp->OSMesaCreateContext);
	glp->OSMesaCreateContextExt = (OSMesaContext APIENTRY (*)(GLenum format, GLint depthBits, GLint stencilBits, GLint accumBits, OSMesaContext sharelist)) ldg_find("OSMesaCreateContextExt", lib);
	GL_CHECK(glp->OSMesaCreateContextExt);
	glp->OSMesaDestroyContext = (void APIENTRY (*)(OSMesaContext ctx)) ldg_find("OSMesaDestroyContext", lib);
	GL_CHECK(glp->OSMesaDestroyContext);
	glp->OSMesaMakeCurrent = (GLboolean APIENTRY (*)(OSMesaContext ctx, void *buffer, GLenum type, GLsizei width, GLsizei height)) ldg_find("OSMesaMakeCurrent", lib);
	GL_CHECK(glp->OSMesaMakeCurrent);
	glp->OSMesaGetCurrentContext = (OSMesaContext APIENTRY (*)(void)) ldg_find("OSMesaGetCurrentContext", lib);
	GL_CHECK(glp->OSMesaGetCurrentContext);
	glp->OSMesaPixelStore = (void APIENTRY (*)(GLint pname, GLint value)) ldg_find("OSMesaPixelStore", lib);
	GL_CHECK(glp->OSMesaPixelStore);
	glp->OSMesaGetIntegerv = (void APIENTRY (*)(GLint pname, GLint *value)) ldg_find("OSMesaGetIntegerv", lib);
	GL_CHECK(glp->OSMesaGetIntegerv);
	glp->OSMesaGetDepthBuffer = (GLboolean APIENTRY (*)(OSMesaContext c, GLint *width, GLint *height, GLint *bytesPerValue, void * *buffer)) ldg_find("OSMesaGetDepthBuffer", lib);
	GL_CHECK(glp->OSMesaGetDepthBuffer);
	glp->OSMesaGetColorBuffer = (GLboolean APIENTRY (*)(OSMesaContext c, GLint *width, GLint *height, GLint *format, void * *buffer)) ldg_find("OSMesaGetColorBuffer", lib);
	GL_CHECK(glp->OSMesaGetColorBuffer);
	glp->OSMesaGetProcAddress = (OSMESAproc APIENTRY (*)(const char *funcName)) ldg_find("OSMesaGetProcAddress", lib);
	GL_CHECK(glp->OSMesaGetProcAddress);
	glp->ClearIndex = (void APIENTRY (*)(GLfloat c)) ldg_find("glClearIndex", lib);
	GL_CHECK(glp->ClearIndex);
	glp->ClearColor = (void APIENTRY (*)(GLclampf red, GLclampf green, GLclampf blue, GLclampf alpha)) ldg_find("glClearColor", lib);
	GL_CHECK(glp->ClearColor);
	glp->Clear = (void APIENTRY (*)(GLbitfield mask)) ldg_find("glClear", lib);
	GL_CHECK(glp->Clear);
	glp->IndexMask = (void APIENTRY (*)(GLuint mask)) ldg_find("glIndexMask", lib);
	GL_CHECK(glp->IndexMask);
	glp->ColorMask = (void APIENTRY (*)(GLboolean32 red, GLboolean32 green, GLboolean32 blue, GLboolean32 alpha)) ldg_find("glColorMask", lib);
	GL_CHECK(glp->ColorMask);
	glp->AlphaFunc = (void APIENTRY (*)(GLenum func, GLclampf ref)) ldg_find("glAlphaFunc", lib);
	GL_CHECK(glp->AlphaFunc);
	glp->BlendFunc = (void APIENTRY (*)(GLenum sfactor, GLenum dfactor)) ldg_find("glBlendFunc", lib);
	GL_CHECK(glp->BlendFunc);
	glp->LogicOp = (void APIENTRY (*)(GLenum opcode)) ldg_find("glLogicOp", lib);
	GL_CHECK(glp->LogicOp);
	glp->CullFace = (void APIENTRY (*)(GLenum mode)) ldg_find("glCullFace", lib);
	GL_CHECK(glp->CullFace);
	glp->FrontFace = (void APIENTRY (*)(GLenum mode)) ldg_find("glFrontFace", lib);
	GL_CHECK(glp->FrontFace);
	glp->PointSize = (void APIENTRY (*)(GLfloat size)) ldg_find("glPointSize", lib);
	GL_CHECK(glp->PointSize);
	glp->LineWidth = (void APIENTRY (*)(GLfloat width)) ldg_find("glLineWidth", lib);
	GL_CHECK(glp->LineWidth);
	glp->LineStipple = (void APIENTRY (*)(GLint factor, GLushort32 pattern)) ldg_find("glLineStipple", lib);
	GL_CHECK(glp->LineStipple);
	glp->PolygonMode = (void APIENTRY (*)(GLenum face, GLenum mode)) ldg_find("glPolygonMode", lib);
	GL_CHECK(glp->PolygonMode);
	glp->PolygonOffset = (void APIENTRY (*)(GLfloat factor, GLfloat units)) ldg_find("glPolygonOffset", lib);
	GL_CHECK(glp->PolygonOffset);
	glp->PolygonStipple = (void APIENTRY (*)(const GLubyte *mask)) ldg_find("glPolygonStipple", lib);
	GL_CHECK(glp->PolygonStipple);
	glp->GetPolygonStipple = (void APIENTRY (*)(GLubyte *mask)) ldg_find("glGetPolygonStipple", lib);
	GL_CHECK(glp->GetPolygonStipple);
	glp->EdgeFlag = (void APIENTRY (*)(GLboolean32 flag)) ldg_find("glEdgeFlag", lib);
	GL_CHECK(glp->EdgeFlag);
	glp->EdgeFlagv = (void APIENTRY (*)(const GLboolean *flag)) ldg_find("glEdgeFlagv", lib);
	GL_CHECK(glp->EdgeFlagv);
	glp->Scissor = (void APIENTRY (*)(GLint x, GLint y, GLsizei width, GLsizei height)) ldg_find("glScissor", lib);
	GL_CHECK(glp->Scissor);
	glp->ClipPlane = (void APIENTRY (*)(GLenum plane, const GLdouble *equation)) ldg_find("glClipPlane", lib);
	GL_CHECK(glp->ClipPlane);
	glp->GetClipPlane = (void APIENTRY (*)(GLenum plane, GLdouble *equation)) ldg_find("glGetClipPlane", lib);
	GL_CHECK(glp->GetClipPlane);
	glp->DrawBuffer = (void APIENTRY (*)(GLenum mode)) ldg_find("glDrawBuffer", lib);
	GL_CHECK(glp->DrawBuffer);
	glp->ReadBuffer = (void APIENTRY (*)(GLenum mode)) ldg_find("glReadBuffer", lib);
	GL_CHECK(glp->ReadBuffer);
	glp->Enable = (void APIENTRY (*)(GLenum cap)) ldg_find("glEnable", lib);
	GL_CHECK(glp->Enable);
	glp->Disable = (void APIENTRY (*)(GLenum cap)) ldg_find("glDisable", lib);
	GL_CHECK(glp->Disable);
	glp->IsEnabled = (GLboolean APIENTRY (*)(GLenum cap)) ldg_find("glIsEnabled", lib);
	GL_CHECK(glp->IsEnabled);
	glp->EnableClientState = (void APIENTRY (*)(GLenum array)) ldg_find("glEnableClientState", lib);
	GL_CHECK(glp->EnableClientState);
	glp->DisableClientState = (void APIENTRY (*)(GLenum array)) ldg_find("glDisableClientState", lib);
	GL_CHECK(glp->DisableClientState);
	glp->GetBooleanv = (void APIENTRY (*)(GLenum pname, GLboolean *params)) ldg_find("glGetBooleanv", lib);
	GL_CHECK(glp->GetBooleanv);
	glp->GetDoublev = (void APIENTRY (*)(GLenum pname, GLdouble *params)) ldg_find("glGetDoublev", lib);
	GL_CHECK(glp->GetDoublev);
	glp->GetFloatv = (void APIENTRY (*)(GLenum pname, GLfloat *params)) ldg_find("glGetFloatv", lib);
	GL_CHECK(glp->GetFloatv);
	glp->GetIntegerv = (void APIENTRY (*)(GLenum pname, GLint *params)) ldg_find("glGetIntegerv", lib);
	GL_CHECK(glp->GetIntegerv);
	glp->PushAttrib = (void APIENTRY (*)(GLbitfield mask)) ldg_find("glPushAttrib", lib);
	GL_CHECK(glp->PushAttrib);
	glp->PopAttrib = (void APIENTRY (*)(void)) ldg_find("glPopAttrib", lib);
	GL_CHECK(glp->PopAttrib);
	glp->PushClientAttrib = (void APIENTRY (*)(GLbitfield mask)) ldg_find("glPushClientAttrib", lib);
	GL_CHECK(glp->PushClientAttrib);
	glp->PopClientAttrib = (void APIENTRY (*)(void)) ldg_find("glPopClientAttrib", lib);
	GL_CHECK(glp->PopClientAttrib);
	glp->RenderMode = (GLint APIENTRY (*)(GLenum mode)) ldg_find("glRenderMode", lib);
	GL_CHECK(glp->RenderMode);
	glp->GetError = (GLenum APIENTRY (*)(void)) ldg_find("glGetError", lib);
	GL_CHECK(glp->GetError);
	glp->Finish = (void APIENTRY (*)(void)) ldg_find("glFinish", lib);
	GL_CHECK(glp->Finish);
	glp->Flush = (void APIENTRY (*)(void)) ldg_find("glFlush", lib);
	GL_CHECK(glp->Flush);
	glp->Hint = (void APIENTRY (*)(GLenum target, GLenum mode)) ldg_find("glHint", lib);
	GL_CHECK(glp->Hint);
	glp->ClearDepth = (void APIENTRY (*)(GLclampd depth)) ldg_find("glClearDepthd", lib);
	GL_CHECK(glp->ClearDepth);
	glp->DepthFunc = (void APIENTRY (*)(GLenum func)) ldg_find("glDepthFunc", lib);
	GL_CHECK(glp->DepthFunc);
	glp->DepthMask = (void APIENTRY (*)(GLboolean32 flag)) ldg_find("glDepthMask", lib);
	GL_CHECK(glp->DepthMask);
	glp->DepthRange = (void APIENTRY (*)(GLclampd zNear, GLclampd zFar)) ldg_find("glDepthRange", lib);
	GL_CHECK(glp->DepthRange);
	glp->ClearAccum = (void APIENTRY (*)(GLfloat red, GLfloat green, GLfloat blue, GLfloat alpha)) ldg_find("glClearAccum", lib);
	GL_CHECK(glp->ClearAccum);
	glp->Accum = (void APIENTRY (*)(GLenum op, GLfloat value)) ldg_find("glAccum", lib);
	GL_CHECK(glp->Accum);
	glp->MatrixMode = (void APIENTRY (*)(GLenum mode)) ldg_find("glMatrixMode", lib);
	GL_CHECK(glp->MatrixMode);
	glp->Ortho = (void APIENTRY (*)(GLdouble left, GLdouble right, GLdouble bottom, GLdouble top, GLdouble zNear, GLdouble zFar)) ldg_find("glOrthod", lib);
	GL_CHECK(glp->Ortho);
	glp->Frustum = (void APIENTRY (*)(GLdouble left, GLdouble right, GLdouble bottom, GLdouble top, GLdouble zNear, GLdouble zFar)) ldg_find("glFrustumd", lib);
	GL_CHECK(glp->Frustum);
	glp->Viewport = (void APIENTRY (*)(GLint x, GLint y, GLsizei width, GLsizei height)) ldg_find("glViewport", lib);
	GL_CHECK(glp->Viewport);
	glp->PushMatrix = (void APIENTRY (*)(void)) ldg_find("glPushMatrix", lib);
	GL_CHECK(glp->PushMatrix);
	glp->PopMatrix = (void APIENTRY (*)(void)) ldg_find("glPopMatrix", lib);
	GL_CHECK(glp->PopMatrix);
	glp->LoadIdentity = (void APIENTRY (*)(void)) ldg_find("glLoadIdentity", lib);
	GL_CHECK(glp->LoadIdentity);
	glp->LoadMatrixd = (void APIENTRY (*)(const GLdouble *m)) ldg_find("glLoadMatrixd", lib);
	GL_CHECK(glp->LoadMatrixd);
	glp->LoadMatrixf = (void APIENTRY (*)(const GLfloat *m)) ldg_find("glLoadMatrixf", lib);
	GL_CHECK(glp->LoadMatrixf);
	glp->MultMatrixd = (void APIENTRY (*)(const GLdouble *m)) ldg_find("glMultMatrixd", lib);
	GL_CHECK(glp->MultMatrixd);
	glp->MultMatrixf = (void APIENTRY (*)(const GLfloat *m)) ldg_find("glMultMatrixf", lib);
	GL_CHECK(glp->MultMatrixf);
	glp->Rotated = (void APIENTRY (*)(GLdouble angle, GLdouble x, GLdouble y, GLdouble z)) ldg_find("glRotated", lib);
	GL_CHECK(glp->Rotated);
	glp->Rotatef = (void APIENTRY (*)(GLfloat angle, GLfloat x, GLfloat y, GLfloat z)) ldg_find("glRotatef", lib);
	GL_CHECK(glp->Rotatef);
	glp->Scaled = (void APIENTRY (*)(GLdouble x, GLdouble y, GLdouble z)) ldg_find("glScaled", lib);
	GL_CHECK(glp->Scaled);
	glp->Scalef = (void APIENTRY (*)(GLfloat x, GLfloat y, GLfloat z)) ldg_find("glScalef", lib);
	GL_CHECK(glp->Scalef);
	glp->Translated = (void APIENTRY (*)(GLdouble x, GLdouble y, GLdouble z)) ldg_find("glTranslated", lib);
	GL_CHECK(glp->Translated);
	glp->Translatef = (void APIENTRY (*)(GLfloat x, GLfloat y, GLfloat z)) ldg_find("glTranslatef", lib);
	GL_CHECK(glp->Translatef);
	glp->IsList = (GLboolean APIENTRY (*)(GLuint list)) ldg_find("glIsList", lib);
	GL_CHECK(glp->IsList);
	glp->DeleteLists = (void APIENTRY (*)(GLuint list, GLsizei range)) ldg_find("glDeleteLists", lib);
	GL_CHECK(glp->DeleteLists);
	glp->GenLists = (GLuint APIENTRY (*)(GLsizei range)) ldg_find("glGenLists", lib);
	GL_CHECK(glp->GenLists);
	glp->NewList = (void APIENTRY (*)(GLuint list, GLenum mode)) ldg_find("glNewList", lib);
	GL_CHECK(glp->NewList);
	glp->EndList = (void APIENTRY (*)(void)) ldg_find("glEndList", lib);
	GL_CHECK(glp->EndList);
	glp->CallList = (void APIENTRY (*)(GLuint list)) ldg_find("glCallList", lib);
	GL_CHECK(glp->CallList);
	glp->CallLists = (void APIENTRY (*)(GLsizei n, GLenum type, const GLvoid *lists)) ldg_find("glCallLists", lib);
	GL_CHECK(glp->CallLists);
	glp->ListBase = (void APIENTRY (*)(GLuint base)) ldg_find("glListBase", lib);
	GL_CHECK(glp->ListBase);
	glp->Begin = (void APIENTRY (*)(GLenum mode)) ldg_find("glBegin", lib);
	GL_CHECK(glp->Begin);
	glp->End = (void APIENTRY (*)(void)) ldg_find("glEnd", lib);
	GL_CHECK(glp->End);
	glp->Vertex2d = (void APIENTRY (*)(GLdouble x, GLdouble y)) ldg_find("glVertex2d", lib);
	GL_CHECK(glp->Vertex2d);
	glp->Vertex2f = (void APIENTRY (*)(GLfloat x, GLfloat y)) ldg_find("glVertex2f", lib);
	GL_CHECK(glp->Vertex2f);
	glp->Vertex2i = (void APIENTRY (*)(GLint x, GLint y)) ldg_find("glVertex2i", lib);
	GL_CHECK(glp->Vertex2i);
	glp->Vertex2s = (void APIENTRY (*)(GLshort32 x, GLshort32 y)) ldg_find("glVertex2s", lib);
	GL_CHECK(glp->Vertex2s);
	glp->Vertex3d = (void APIENTRY (*)(GLdouble x, GLdouble y, GLdouble z)) ldg_find("glVertex3d", lib);
	GL_CHECK(glp->Vertex3d);
	glp->Vertex3f = (void APIENTRY (*)(GLfloat x, GLfloat y, GLfloat z)) ldg_find("glVertex3f", lib);
	GL_CHECK(glp->Vertex3f);
	glp->Vertex3i = (void APIENTRY (*)(GLint x, GLint y, GLint z)) ldg_find("glVertex3i", lib);
	GL_CHECK(glp->Vertex3i);
	glp->Vertex3s = (void APIENTRY (*)(GLshort32 x, GLshort32 y, GLshort32 z)) ldg_find("glVertex3s", lib);
	GL_CHECK(glp->Vertex3s);
	glp->Vertex4d = (void APIENTRY (*)(GLdouble x, GLdouble y, GLdouble z, GLdouble w)) ldg_find("glVertex4d", lib);
	GL_CHECK(glp->Vertex4d);
	glp->Vertex4f = (void APIENTRY (*)(GLfloat x, GLfloat y, GLfloat z, GLfloat w)) ldg_find("glVertex4f", lib);
	GL_CHECK(glp->Vertex4f);
	glp->Vertex4i = (void APIENTRY (*)(GLint x, GLint y, GLint z, GLint w)) ldg_find("glVertex4i", lib);
	GL_CHECK(glp->Vertex4i);
	glp->Vertex4s = (void APIENTRY (*)(GLshort32 x, GLshort32 y, GLshort32 z, GLshort32 w)) ldg_find("glVertex4s", lib);
	GL_CHECK(glp->Vertex4s);
	glp->Vertex2dv = (void APIENTRY (*)(const GLdouble *v)) ldg_find("glVertex2dv", lib);
	GL_CHECK(glp->Vertex2dv);
	glp->Vertex2fv = (void APIENTRY (*)(const GLfloat *v)) ldg_find("glVertex2fv", lib);
	GL_CHECK(glp->Vertex2fv);
	glp->Vertex2iv = (void APIENTRY (*)(const GLint *v)) ldg_find("glVertex2iv", lib);
	GL_CHECK(glp->Vertex2iv);
	glp->Vertex2sv = (void APIENTRY (*)(const GLshort *v)) ldg_find("glVertex2sv", lib);
	GL_CHECK(glp->Vertex2sv);
	glp->Vertex3dv = (void APIENTRY (*)(const GLdouble *v)) ldg_find("glVertex3dv", lib);
	GL_CHECK(glp->Vertex3dv);
	glp->Vertex3fv = (void APIENTRY (*)(const GLfloat *v)) ldg_find("glVertex3fv", lib);
	GL_CHECK(glp->Vertex3fv);
	glp->Vertex3iv = (void APIENTRY (*)(const GLint *v)) ldg_find("glVertex3iv", lib);
	GL_CHECK(glp->Vertex3iv);
	glp->Vertex3sv = (void APIENTRY (*)(const GLshort *v)) ldg_find("glVertex3sv", lib);
	GL_CHECK(glp->Vertex3sv);
	glp->Vertex4dv = (void APIENTRY (*)(const GLdouble *v)) ldg_find("glVertex4dv", lib);
	GL_CHECK(glp->Vertex4dv);
	glp->Vertex4fv = (void APIENTRY (*)(const GLfloat *v)) ldg_find("glVertex4fv", lib);
	GL_CHECK(glp->Vertex4fv);
	glp->Vertex4iv = (void APIENTRY (*)(const GLint *v)) ldg_find("glVertex4iv", lib);
	GL_CHECK(glp->Vertex4iv);
	glp->Vertex4sv = (void APIENTRY (*)(const GLshort *v)) ldg_find("glVertex4sv", lib);
	GL_CHECK(glp->Vertex4sv);
	glp->Normal3b = (void APIENTRY (*)(GLbyte32 nx, GLbyte32 ny, GLbyte32 nz)) ldg_find("glNormal3b", lib);
	GL_CHECK(glp->Normal3b);
	glp->Normal3d = (void APIENTRY (*)(GLdouble nx, GLdouble ny, GLdouble nz)) ldg_find("glNormal3d", lib);
	GL_CHECK(glp->Normal3d);
	glp->Normal3f = (void APIENTRY (*)(GLfloat nx, GLfloat ny, GLfloat nz)) ldg_find("glNormal3f", lib);
	GL_CHECK(glp->Normal3f);
	glp->Normal3i = (void APIENTRY (*)(GLint nx, GLint ny, GLint nz)) ldg_find("glNormal3i", lib);
	GL_CHECK(glp->Normal3i);
	glp->Normal3s = (void APIENTRY (*)(GLshort32 nx, GLshort32 ny, GLshort32 nz)) ldg_find("glNormal3s", lib);
	GL_CHECK(glp->Normal3s);
	glp->Normal3bv = (void APIENTRY (*)(const GLbyte *v)) ldg_find("glNormal3bv", lib);
	GL_CHECK(glp->Normal3bv);
	glp->Normal3dv = (void APIENTRY (*)(const GLdouble *v)) ldg_find("glNormal3dv", lib);
	GL_CHECK(glp->Normal3dv);
	glp->Normal3fv = (void APIENTRY (*)(const GLfloat *v)) ldg_find("glNormal3fv", lib);
	GL_CHECK(glp->Normal3fv);
	glp->Normal3iv = (void APIENTRY (*)(const GLint *v)) ldg_find("glNormal3iv", lib);
	GL_CHECK(glp->Normal3iv);
	glp->Normal3sv = (void APIENTRY (*)(const GLshort *v)) ldg_find("glNormal3sv", lib);
	GL_CHECK(glp->Normal3sv);
	glp->Indexd = (void APIENTRY (*)(GLdouble c)) ldg_find("glIndexd", lib);
	GL_CHECK(glp->Indexd);
	glp->Indexf = (void APIENTRY (*)(GLfloat c)) ldg_find("glIndexf", lib);
	GL_CHECK(glp->Indexf);
	glp->Indexi = (void APIENTRY (*)(GLint c)) ldg_find("glIndexi", lib);
	GL_CHECK(glp->Indexi);
	glp->Indexs = (void APIENTRY (*)(GLshort32 c)) ldg_find("glIndexs", lib);
	GL_CHECK(glp->Indexs);
	glp->Indexub = (void APIENTRY (*)(GLubyte32 c)) ldg_find("glIndexub", lib);
	GL_CHECK(glp->Indexub);
	glp->Indexdv = (void APIENTRY (*)(const GLdouble *c)) ldg_find("glIndexdv", lib);
	GL_CHECK(glp->Indexdv);
	glp->Indexfv = (void APIENTRY (*)(const GLfloat *c)) ldg_find("glIndexfv", lib);
	GL_CHECK(glp->Indexfv);
	glp->Indexiv = (void APIENTRY (*)(const GLint *c)) ldg_find("glIndexiv", lib);
	GL_CHECK(glp->Indexiv);
	glp->Indexsv = (void APIENTRY (*)(const GLshort *c)) ldg_find("glIndexsv", lib);
	GL_CHECK(glp->Indexsv);
	glp->Indexubv = (void APIENTRY (*)(const GLubyte *c)) ldg_find("glIndexubv", lib);
	GL_CHECK(glp->Indexubv);
	glp->Color3b = (void APIENTRY (*)(GLbyte32 red, GLbyte32 green, GLbyte32 blue)) ldg_find("glColor3b", lib);
	GL_CHECK(glp->Color3b);
	glp->Color3d = (void APIENTRY (*)(GLdouble red, GLdouble green, GLdouble blue)) ldg_find("glColor3d", lib);
	GL_CHECK(glp->Color3d);
	glp->Color3f = (void APIENTRY (*)(GLfloat red, GLfloat green, GLfloat blue)) ldg_find("glColor3f", lib);
	GL_CHECK(glp->Color3f);
	glp->Color3i = (void APIENTRY (*)(GLint red, GLint green, GLint blue)) ldg_find("glColor3i", lib);
	GL_CHECK(glp->Color3i);
	glp->Color3s = (void APIENTRY (*)(GLshort32 red, GLshort32 green, GLshort32 blue)) ldg_find("glColor3s", lib);
	GL_CHECK(glp->Color3s);
	glp->Color3ub = (void APIENTRY (*)(GLubyte32 red, GLubyte32 green, GLubyte32 blue)) ldg_find("glColor3ub", lib);
	GL_CHECK(glp->Color3ub);
	glp->Color3ui = (void APIENTRY (*)(GLuint red, GLuint green, GLuint blue)) ldg_find("glColor3ui", lib);
	GL_CHECK(glp->Color3ui);
	glp->Color3us = (void APIENTRY (*)(GLushort32 red, GLushort32 green, GLushort32 blue)) ldg_find("glColor3us", lib);
	GL_CHECK(glp->Color3us);
	glp->Color4b = (void APIENTRY (*)(GLbyte32 red, GLbyte32 green, GLbyte32 blue, GLbyte32 alpha)) ldg_find("glColor4b", lib);
	GL_CHECK(glp->Color4b);
	glp->Color4d = (void APIENTRY (*)(GLdouble red, GLdouble green, GLdouble blue, GLdouble alpha)) ldg_find("glColor4d", lib);
	GL_CHECK(glp->Color4d);
	glp->Color4f = (void APIENTRY (*)(GLfloat red, GLfloat green, GLfloat blue, GLfloat alpha)) ldg_find("glColor4f", lib);
	GL_CHECK(glp->Color4f);
	glp->Color4i = (void APIENTRY (*)(GLint red, GLint green, GLint blue, GLint alpha)) ldg_find("glColor4i", lib);
	GL_CHECK(glp->Color4i);
	glp->Color4s = (void APIENTRY (*)(GLshort32 red, GLshort32 green, GLshort32 blue, GLshort32 alpha)) ldg_find("glColor4s", lib);
	GL_CHECK(glp->Color4s);
	glp->Color4ub = (void APIENTRY (*)(GLubyte32 red, GLubyte32 green, GLubyte32 blue, GLubyte32 alpha)) ldg_find("glColor4ub", lib);
	GL_CHECK(glp->Color4ub);
	glp->Color4ui = (void APIENTRY (*)(GLuint red, GLuint green, GLuint blue, GLuint alpha)) ldg_find("glColor4ui", lib);
	GL_CHECK(glp->Color4ui);
	glp->Color4us = (void APIENTRY (*)(GLushort32 red, GLushort32 green, GLushort32 blue, GLushort32 alpha)) ldg_find("glColor4us", lib);
	GL_CHECK(glp->Color4us);
	glp->Color3bv = (void APIENTRY (*)(const GLbyte *v)) ldg_find("glColor3bv", lib);
	GL_CHECK(glp->Color3bv);
	glp->Color3dv = (void APIENTRY (*)(const GLdouble *v)) ldg_find("glColor3dv", lib);
	GL_CHECK(glp->Color3dv);
	glp->Color3fv = (void APIENTRY (*)(const GLfloat *v)) ldg_find("glColor3fv", lib);
	GL_CHECK(glp->Color3fv);
	glp->Color3iv = (void APIENTRY (*)(const GLint *v)) ldg_find("glColor3iv", lib);
	GL_CHECK(glp->Color3iv);
	glp->Color3sv = (void APIENTRY (*)(const GLshort *v)) ldg_find("glColor3sv", lib);
	GL_CHECK(glp->Color3sv);
	glp->Color3ubv = (void APIENTRY (*)(const GLubyte *v)) ldg_find("glColor3ubv", lib);
	GL_CHECK(glp->Color3ubv);
	glp->Color3uiv = (void APIENTRY (*)(const GLuint *v)) ldg_find("glColor3uiv", lib);
	GL_CHECK(glp->Color3uiv);
	glp->Color3usv = (void APIENTRY (*)(const GLushort *v)) ldg_find("glColor3usv", lib);
	GL_CHECK(glp->Color3usv);
	glp->Color4bv = (void APIENTRY (*)(const GLbyte *v)) ldg_find("glColor4bv", lib);
	GL_CHECK(glp->Color4bv);
	glp->Color4dv = (void APIENTRY (*)(const GLdouble *v)) ldg_find("glColor4dv", lib);
	GL_CHECK(glp->Color4dv);
	glp->Color4fv = (void APIENTRY (*)(const GLfloat *v)) ldg_find("glColor4fv", lib);
	GL_CHECK(glp->Color4fv);
	glp->Color4iv = (void APIENTRY (*)(const GLint *v)) ldg_find("glColor4iv", lib);
	GL_CHECK(glp->Color4iv);
	glp->Color4sv = (void APIENTRY (*)(const GLshort *v)) ldg_find("glColor4sv", lib);
	GL_CHECK(glp->Color4sv);
	glp->Color4ubv = (void APIENTRY (*)(const GLubyte *v)) ldg_find("glColor4ubv", lib);
	GL_CHECK(glp->Color4ubv);
	glp->Color4uiv = (void APIENTRY (*)(const GLuint *v)) ldg_find("glColor4uiv", lib);
	GL_CHECK(glp->Color4uiv);
	glp->Color4usv = (void APIENTRY (*)(const GLushort *v)) ldg_find("glColor4usv", lib);
	GL_CHECK(glp->Color4usv);
	glp->TexCoord1d = (void APIENTRY (*)(GLdouble s)) ldg_find("glTexCoord1d", lib);
	GL_CHECK(glp->TexCoord1d);
	glp->TexCoord1f = (void APIENTRY (*)(GLfloat s)) ldg_find("glTexCoord1f", lib);
	GL_CHECK(glp->TexCoord1f);
	glp->TexCoord1i = (void APIENTRY (*)(GLint s)) ldg_find("glTexCoord1i", lib);
	GL_CHECK(glp->TexCoord1i);
	glp->TexCoord1s = (void APIENTRY (*)(GLshort32 s)) ldg_find("glTexCoord1s", lib);
	GL_CHECK(glp->TexCoord1s);
	glp->TexCoord2d = (void APIENTRY (*)(GLdouble s, GLdouble t)) ldg_find("glTexCoord2d", lib);
	GL_CHECK(glp->TexCoord2d);
	glp->TexCoord2f = (void APIENTRY (*)(GLfloat s, GLfloat t)) ldg_find("glTexCoord2f", lib);
	GL_CHECK(glp->TexCoord2f);
	glp->TexCoord2i = (void APIENTRY (*)(GLint s, GLint t)) ldg_find("glTexCoord2i", lib);
	GL_CHECK(glp->TexCoord2i);
	glp->TexCoord2s = (void APIENTRY (*)(GLshort32 s, GLshort32 t)) ldg_find("glTexCoord2s", lib);
	GL_CHECK(glp->TexCoord2s);
	glp->TexCoord3d = (void APIENTRY (*)(GLdouble s, GLdouble t, GLdouble r)) ldg_find("glTexCoord3d", lib);
	GL_CHECK(glp->TexCoord3d);
	glp->TexCoord3f = (void APIENTRY (*)(GLfloat s, GLfloat t, GLfloat r)) ldg_find("glTexCoord3f", lib);
	GL_CHECK(glp->TexCoord3f);
	glp->TexCoord3i = (void APIENTRY (*)(GLint s, GLint t, GLint r)) ldg_find("glTexCoord3i", lib);
	GL_CHECK(glp->TexCoord3i);
	glp->TexCoord3s = (void APIENTRY (*)(GLshort32 s, GLshort32 t, GLshort32 r)) ldg_find("glTexCoord3s", lib);
	GL_CHECK(glp->TexCoord3s);
	glp->TexCoord4d = (void APIENTRY (*)(GLdouble s, GLdouble t, GLdouble r, GLdouble q)) ldg_find("glTexCoord4d", lib);
	GL_CHECK(glp->TexCoord4d);
	glp->TexCoord4f = (void APIENTRY (*)(GLfloat s, GLfloat t, GLfloat r, GLfloat q)) ldg_find("glTexCoord4f", lib);
	GL_CHECK(glp->TexCoord4f);
	glp->TexCoord4i = (void APIENTRY (*)(GLint s, GLint t, GLint r, GLint q)) ldg_find("glTexCoord4i", lib);
	GL_CHECK(glp->TexCoord4i);
	glp->TexCoord4s = (void APIENTRY (*)(GLshort32 s, GLshort32 t, GLshort32 r, GLshort32 q)) ldg_find("glTexCoord4s", lib);
	GL_CHECK(glp->TexCoord4s);
	glp->TexCoord1dv = (void APIENTRY (*)(const GLdouble *v)) ldg_find("glTexCoord1dv", lib);
	GL_CHECK(glp->TexCoord1dv);
	glp->TexCoord1fv = (void APIENTRY (*)(const GLfloat *v)) ldg_find("glTexCoord1fv", lib);
	GL_CHECK(glp->TexCoord1fv);
	glp->TexCoord1iv = (void APIENTRY (*)(const GLint *v)) ldg_find("glTexCoord1iv", lib);
	GL_CHECK(glp->TexCoord1iv);
	glp->TexCoord1sv = (void APIENTRY (*)(const GLshort *v)) ldg_find("glTexCoord1sv", lib);
	GL_CHECK(glp->TexCoord1sv);
	glp->TexCoord2dv = (void APIENTRY (*)(const GLdouble *v)) ldg_find("glTexCoord2dv", lib);
	GL_CHECK(glp->TexCoord2dv);
	glp->TexCoord2fv = (void APIENTRY (*)(const GLfloat *v)) ldg_find("glTexCoord2fv", lib);
	GL_CHECK(glp->TexCoord2fv);
	glp->TexCoord2iv = (void APIENTRY (*)(const GLint *v)) ldg_find("glTexCoord2iv", lib);
	GL_CHECK(glp->TexCoord2iv);
	glp->TexCoord2sv = (void APIENTRY (*)(const GLshort *v)) ldg_find("glTexCoord2sv", lib);
	GL_CHECK(glp->TexCoord2sv);
	glp->TexCoord3dv = (void APIENTRY (*)(const GLdouble *v)) ldg_find("glTexCoord3dv", lib);
	GL_CHECK(glp->TexCoord3dv);
	glp->TexCoord3fv = (void APIENTRY (*)(const GLfloat *v)) ldg_find("glTexCoord3fv", lib);
	GL_CHECK(glp->TexCoord3fv);
	glp->TexCoord3iv = (void APIENTRY (*)(const GLint *v)) ldg_find("glTexCoord3iv", lib);
	GL_CHECK(glp->TexCoord3iv);
	glp->TexCoord3sv = (void APIENTRY (*)(const GLshort *v)) ldg_find("glTexCoord3sv", lib);
	GL_CHECK(glp->TexCoord3sv);
	glp->TexCoord4dv = (void APIENTRY (*)(const GLdouble *v)) ldg_find("glTexCoord4dv", lib);
	GL_CHECK(glp->TexCoord4dv);
	glp->TexCoord4fv = (void APIENTRY (*)(const GLfloat *v)) ldg_find("glTexCoord4fv", lib);
	GL_CHECK(glp->TexCoord4fv);
	glp->TexCoord4iv = (void APIENTRY (*)(const GLint *v)) ldg_find("glTexCoord4iv", lib);
	GL_CHECK(glp->TexCoord4iv);
	glp->TexCoord4sv = (void APIENTRY (*)(const GLshort *v)) ldg_find("glTexCoord4sv", lib);
	GL_CHECK(glp->TexCoord4sv);
	glp->RasterPos2d = (void APIENTRY (*)(GLdouble x, GLdouble y)) ldg_find("glRasterPos2d", lib);
	GL_CHECK(glp->RasterPos2d);
	glp->RasterPos2f = (void APIENTRY (*)(GLfloat x, GLfloat y)) ldg_find("glRasterPos2f", lib);
	GL_CHECK(glp->RasterPos2f);
	glp->RasterPos2i = (void APIENTRY (*)(GLint x, GLint y)) ldg_find("glRasterPos2i", lib);
	GL_CHECK(glp->RasterPos2i);
	glp->RasterPos2s = (void APIENTRY (*)(GLshort32 x, GLshort32 y)) ldg_find("glRasterPos2s", lib);
	GL_CHECK(glp->RasterPos2s);
	glp->RasterPos3d = (void APIENTRY (*)(GLdouble x, GLdouble y, GLdouble z)) ldg_find("glRasterPos3d", lib);
	GL_CHECK(glp->RasterPos3d);
	glp->RasterPos3f = (void APIENTRY (*)(GLfloat x, GLfloat y, GLfloat z)) ldg_find("glRasterPos3f", lib);
	GL_CHECK(glp->RasterPos3f);
	glp->RasterPos3i = (void APIENTRY (*)(GLint x, GLint y, GLint z)) ldg_find("glRasterPos3i", lib);
	GL_CHECK(glp->RasterPos3i);
	glp->RasterPos3s = (void APIENTRY (*)(GLshort32 x, GLshort32 y, GLshort32 z)) ldg_find("glRasterPos3s", lib);
	GL_CHECK(glp->RasterPos3s);
	glp->RasterPos4d = (void APIENTRY (*)(GLdouble x, GLdouble y, GLdouble z, GLdouble w)) ldg_find("glRasterPos4d", lib);
	GL_CHECK(glp->RasterPos4d);
	glp->RasterPos4f = (void APIENTRY (*)(GLfloat x, GLfloat y, GLfloat z, GLfloat w)) ldg_find("glRasterPos4f", lib);
	GL_CHECK(glp->RasterPos4f);
	glp->RasterPos4i = (void APIENTRY (*)(GLint x, GLint y, GLint z, GLint w)) ldg_find("glRasterPos4i", lib);
	GL_CHECK(glp->RasterPos4i);
	glp->RasterPos4s = (void APIENTRY (*)(GLshort32 x, GLshort32 y, GLshort32 z, GLshort32 w)) ldg_find("glRasterPos4s", lib);
	GL_CHECK(glp->RasterPos4s);
	glp->RasterPos2dv = (void APIENTRY (*)(const GLdouble *v)) ldg_find("glRasterPos2dv", lib);
	GL_CHECK(glp->RasterPos2dv);
	glp->RasterPos2fv = (void APIENTRY (*)(const GLfloat *v)) ldg_find("glRasterPos2fv", lib);
	GL_CHECK(glp->RasterPos2fv);
	glp->RasterPos2iv = (void APIENTRY (*)(const GLint *v)) ldg_find("glRasterPos2iv", lib);
	GL_CHECK(glp->RasterPos2iv);
	glp->RasterPos2sv = (void APIENTRY (*)(const GLshort *v)) ldg_find("glRasterPos2sv", lib);
	GL_CHECK(glp->RasterPos2sv);
	glp->RasterPos3dv = (void APIENTRY (*)(const GLdouble *v)) ldg_find("glRasterPos3dv", lib);
	GL_CHECK(glp->RasterPos3dv);
	glp->RasterPos3fv = (void APIENTRY (*)(const GLfloat *v)) ldg_find("glRasterPos3fv", lib);
	GL_CHECK(glp->RasterPos3fv);
	glp->RasterPos3iv = (void APIENTRY (*)(const GLint *v)) ldg_find("glRasterPos3iv", lib);
	GL_CHECK(glp->RasterPos3iv);
	glp->RasterPos3sv = (void APIENTRY (*)(const GLshort *v)) ldg_find("glRasterPos3sv", lib);
	GL_CHECK(glp->RasterPos3sv);
	glp->RasterPos4dv = (void APIENTRY (*)(const GLdouble *v)) ldg_find("glRasterPos4dv", lib);
	GL_CHECK(glp->RasterPos4dv);
	glp->RasterPos4fv = (void APIENTRY (*)(const GLfloat *v)) ldg_find("glRasterPos4fv", lib);
	GL_CHECK(glp->RasterPos4fv);
	glp->RasterPos4iv = (void APIENTRY (*)(const GLint *v)) ldg_find("glRasterPos4iv", lib);
	GL_CHECK(glp->RasterPos4iv);
	glp->RasterPos4sv = (void APIENTRY (*)(const GLshort *v)) ldg_find("glRasterPos4sv", lib);
	GL_CHECK(glp->RasterPos4sv);
	glp->Rectd = (void APIENTRY (*)(GLdouble x1, GLdouble y1, GLdouble x2, GLdouble y2)) ldg_find("glRectd", lib);
	GL_CHECK(glp->Rectd);
	glp->Rectf = (void APIENTRY (*)(GLfloat x1, GLfloat y1, GLfloat x2, GLfloat y2)) ldg_find("glRectf", lib);
	GL_CHECK(glp->Rectf);
	glp->Recti = (void APIENTRY (*)(GLint x1, GLint y1, GLint x2, GLint y2)) ldg_find("glRecti", lib);
	GL_CHECK(glp->Recti);
	glp->Rects = (void APIENTRY (*)(GLshort32 x1, GLshort32 y1, GLshort32 x2, GLshort32 y2)) ldg_find("glRects", lib);
	GL_CHECK(glp->Rects);
	glp->Rectdv = (void APIENTRY (*)(const GLdouble *v1, const GLdouble *v2)) ldg_find("glRectdv", lib);
	GL_CHECK(glp->Rectdv);
	glp->Rectfv = (void APIENTRY (*)(const GLfloat *v1, const GLfloat *v2)) ldg_find("glRectfv", lib);
	GL_CHECK(glp->Rectfv);
	glp->Rectiv = (void APIENTRY (*)(const GLint *v1, const GLint *v2)) ldg_find("glRectiv", lib);
	GL_CHECK(glp->Rectiv);
	glp->Rectsv = (void APIENTRY (*)(const GLshort *v1, const GLshort *v2)) ldg_find("glRectsv", lib);
	GL_CHECK(glp->Rectsv);
	glp->VertexPointer = (void APIENTRY (*)(GLint size, GLenum type, GLsizei stride, const GLvoid *pointer)) ldg_find("glVertexPointer", lib);
	GL_CHECK(glp->VertexPointer);
	glp->NormalPointer = (void APIENTRY (*)(GLenum type, GLsizei stride, const GLvoid *pointer)) ldg_find("glNormalPointer", lib);
	GL_CHECK(glp->NormalPointer);
	glp->ColorPointer = (void APIENTRY (*)(GLint size, GLenum type, GLsizei stride, const GLvoid *pointer)) ldg_find("glColorPointer", lib);
	GL_CHECK(glp->ColorPointer);
	glp->IndexPointer = (void APIENTRY (*)(GLenum type, GLsizei stride, const GLvoid *pointer)) ldg_find("glIndexPointer", lib);
	GL_CHECK(glp->IndexPointer);
	glp->TexCoordPointer = (void APIENTRY (*)(GLint size, GLenum type, GLsizei stride, const GLvoid *pointer)) ldg_find("glTexCoordPointer", lib);
	GL_CHECK(glp->TexCoordPointer);
	glp->EdgeFlagPointer = (void APIENTRY (*)(GLsizei stride, const GLvoid *pointer)) ldg_find("glEdgeFlagPointer", lib);
	GL_CHECK(glp->EdgeFlagPointer);
	glp->GetPointerv = (void APIENTRY (*)(GLenum pname, GLvoid* *params)) ldg_find("glGetPointerv", lib);
	GL_CHECK(glp->GetPointerv);
	glp->ArrayElement = (void APIENTRY (*)(GLint i)) ldg_find("glArrayElement", lib);
	GL_CHECK(glp->ArrayElement);
	glp->DrawArrays = (void APIENTRY (*)(GLenum mode, GLint first, GLsizei count)) ldg_find("glDrawArrays", lib);
	GL_CHECK(glp->DrawArrays);
	glp->DrawElements = (void APIENTRY (*)(GLenum mode, GLsizei count, GLenum type, const GLvoid *indices)) ldg_find("glDrawElements", lib);
	GL_CHECK(glp->DrawElements);
	glp->InterleavedArrays = (void APIENTRY (*)(GLenum format, GLsizei stride, const GLvoid *pointer)) ldg_find("glInterleavedArrays", lib);
	GL_CHECK(glp->InterleavedArrays);
	glp->ShadeModel = (void APIENTRY (*)(GLenum mode)) ldg_find("glShadeModel", lib);
	GL_CHECK(glp->ShadeModel);
	glp->Lightf = (void APIENTRY (*)(GLenum light, GLenum pname, GLfloat param)) ldg_find("glLightf", lib);
	GL_CHECK(glp->Lightf);
	glp->Lighti = (void APIENTRY (*)(GLenum light, GLenum pname, GLint param)) ldg_find("glLighti", lib);
	GL_CHECK(glp->Lighti);
	glp->Lightfv = (void APIENTRY (*)(GLenum light, GLenum pname, const GLfloat *params)) ldg_find("glLightfv", lib);
	GL_CHECK(glp->Lightfv);
	glp->Lightiv = (void APIENTRY (*)(GLenum light, GLenum pname, const GLint *params)) ldg_find("glLightiv", lib);
	GL_CHECK(glp->Lightiv);
	glp->GetLightfv = (void APIENTRY (*)(GLenum light, GLenum pname, GLfloat *params)) ldg_find("glGetLightfv", lib);
	GL_CHECK(glp->GetLightfv);
	glp->GetLightiv = (void APIENTRY (*)(GLenum light, GLenum pname, GLint *params)) ldg_find("glGetLightiv", lib);
	GL_CHECK(glp->GetLightiv);
	glp->LightModelf = (void APIENTRY (*)(GLenum pname, GLfloat param)) ldg_find("glLightModelf", lib);
	GL_CHECK(glp->LightModelf);
	glp->LightModeli = (void APIENTRY (*)(GLenum pname, GLint param)) ldg_find("glLightModeli", lib);
	GL_CHECK(glp->LightModeli);
	glp->LightModelfv = (void APIENTRY (*)(GLenum pname, const GLfloat *params)) ldg_find("glLightModelfv", lib);
	GL_CHECK(glp->LightModelfv);
	glp->LightModeliv = (void APIENTRY (*)(GLenum pname, const GLint *params)) ldg_find("glLightModeliv", lib);
	GL_CHECK(glp->LightModeliv);
	glp->Materialf = (void APIENTRY (*)(GLenum face, GLenum pname, GLfloat param)) ldg_find("glMaterialf", lib);
	GL_CHECK(glp->Materialf);
	glp->Materiali = (void APIENTRY (*)(GLenum face, GLenum pname, GLint param)) ldg_find("glMateriali", lib);
	GL_CHECK(glp->Materiali);
	glp->Materialfv = (void APIENTRY (*)(GLenum face, GLenum pname, const GLfloat *params)) ldg_find("glMaterialfv", lib);
	GL_CHECK(glp->Materialfv);
	glp->Materialiv = (void APIENTRY (*)(GLenum face, GLenum pname, const GLint *params)) ldg_find("glMaterialiv", lib);
	GL_CHECK(glp->Materialiv);
	glp->GetMaterialfv = (void APIENTRY (*)(GLenum face, GLenum pname, GLfloat *params)) ldg_find("glGetMaterialfv", lib);
	GL_CHECK(glp->GetMaterialfv);
	glp->GetMaterialiv = (void APIENTRY (*)(GLenum face, GLenum pname, GLint *params)) ldg_find("glGetMaterialiv", lib);
	GL_CHECK(glp->GetMaterialiv);
	glp->ColorMaterial = (void APIENTRY (*)(GLenum face, GLenum mode)) ldg_find("glColorMaterial", lib);
	GL_CHECK(glp->ColorMaterial);
	glp->PixelZoom = (void APIENTRY (*)(GLfloat xfactor, GLfloat yfactor)) ldg_find("glPixelZoom", lib);
	GL_CHECK(glp->PixelZoom);
	glp->PixelStoref = (void APIENTRY (*)(GLenum pname, GLfloat param)) ldg_find("glPixelStoref", lib);
	GL_CHECK(glp->PixelStoref);
	glp->PixelStorei = (void APIENTRY (*)(GLenum pname, GLint param)) ldg_find("glPixelStorei", lib);
	GL_CHECK(glp->PixelStorei);
	glp->PixelTransferf = (void APIENTRY (*)(GLenum pname, GLfloat param)) ldg_find("glPixelTransferf", lib);
	GL_CHECK(glp->PixelTransferf);
	glp->PixelTransferi = (void APIENTRY (*)(GLenum pname, GLint param)) ldg_find("glPixelTransferi", lib);
	GL_CHECK(glp->PixelTransferi);
	glp->PixelMapfv = (void APIENTRY (*)(GLenum map, GLsizei mapsize, const GLfloat *values)) ldg_find("glPixelMapfv", lib);
	GL_CHECK(glp->PixelMapfv);
	glp->PixelMapuiv = (void APIENTRY (*)(GLenum map, GLsizei mapsize, const GLuint *values)) ldg_find("glPixelMapuiv", lib);
	GL_CHECK(glp->PixelMapuiv);
	glp->PixelMapusv = (void APIENTRY (*)(GLenum map, GLsizei mapsize, const GLushort *values)) ldg_find("glPixelMapusv", lib);
	GL_CHECK(glp->PixelMapusv);
	glp->GetPixelMapfv = (void APIENTRY (*)(GLenum map, GLfloat *values)) ldg_find("glGetPixelMapfv", lib);
	GL_CHECK(glp->GetPixelMapfv);
	glp->GetPixelMapuiv = (void APIENTRY (*)(GLenum map, GLuint *values)) ldg_find("glGetPixelMapuiv", lib);
	GL_CHECK(glp->GetPixelMapuiv);
	glp->GetPixelMapusv = (void APIENTRY (*)(GLenum map, GLushort *values)) ldg_find("glGetPixelMapusv", lib);
	GL_CHECK(glp->GetPixelMapusv);
	glp->Bitmap = (void APIENTRY (*)(GLsizei width, GLsizei height, GLfloat xorig, GLfloat yorig, GLfloat xmove, GLfloat ymove, const GLubyte *bitmap)) ldg_find("glBitmap", lib);
	GL_CHECK(glp->Bitmap);
	glp->ReadPixels = (void APIENTRY (*)(GLint x, GLint y, GLsizei width, GLsizei height, GLenum format, GLenum type, GLvoid *pixels)) ldg_find("glReadPixels", lib);
	GL_CHECK(glp->ReadPixels);
	glp->DrawPixels = (void APIENTRY (*)(GLsizei width, GLsizei height, GLenum format, GLenum type, const GLvoid *pixels)) ldg_find("glDrawPixels", lib);
	GL_CHECK(glp->DrawPixels);
	glp->CopyPixels = (void APIENTRY (*)(GLint x, GLint y, GLsizei width, GLsizei height, GLenum type)) ldg_find("glCopyPixels", lib);
	GL_CHECK(glp->CopyPixels);
	glp->StencilFunc = (void APIENTRY (*)(GLenum func, GLint ref, GLuint mask)) ldg_find("glStencilFunc", lib);
	GL_CHECK(glp->StencilFunc);
	glp->StencilMask = (void APIENTRY (*)(GLuint mask)) ldg_find("glStencilMask", lib);
	GL_CHECK(glp->StencilMask);
	glp->StencilOp = (void APIENTRY (*)(GLenum fail, GLenum zfail, GLenum zpass)) ldg_find("glStencilOp", lib);
	GL_CHECK(glp->StencilOp);
	glp->ClearStencil = (void APIENTRY (*)(GLint s)) ldg_find("glClearStencil", lib);
	GL_CHECK(glp->ClearStencil);
	glp->TexGend = (void APIENTRY (*)(GLenum coord, GLenum pname, GLdouble param)) ldg_find("glTexGend", lib);
	GL_CHECK(glp->TexGend);
	glp->TexGenf = (void APIENTRY (*)(GLenum coord, GLenum pname, GLfloat param)) ldg_find("glTexGenf", lib);
	GL_CHECK(glp->TexGenf);
	glp->TexGeni = (void APIENTRY (*)(GLenum coord, GLenum pname, GLint param)) ldg_find("glTexGeni", lib);
	GL_CHECK(glp->TexGeni);
	glp->TexGendv = (void APIENTRY (*)(GLenum coord, GLenum pname, const GLdouble *params)) ldg_find("glTexGendv", lib);
	GL_CHECK(glp->TexGendv);
	glp->TexGenfv = (void APIENTRY (*)(GLenum coord, GLenum pname, const GLfloat *params)) ldg_find("glTexGenfv", lib);
	GL_CHECK(glp->TexGenfv);
	glp->TexGeniv = (void APIENTRY (*)(GLenum coord, GLenum pname, const GLint *params)) ldg_find("glTexGeniv", lib);
	GL_CHECK(glp->TexGeniv);
	glp->GetTexGendv = (void APIENTRY (*)(GLenum coord, GLenum pname, GLdouble *params)) ldg_find("glGetTexGendv", lib);
	GL_CHECK(glp->GetTexGendv);
	glp->GetTexGenfv = (void APIENTRY (*)(GLenum coord, GLenum pname, GLfloat *params)) ldg_find("glGetTexGenfv", lib);
	GL_CHECK(glp->GetTexGenfv);
	glp->GetTexGeniv = (void APIENTRY (*)(GLenum coord, GLenum pname, GLint *params)) ldg_find("glGetTexGeniv", lib);
	GL_CHECK(glp->GetTexGeniv);
	glp->TexEnvf = (void APIENTRY (*)(GLenum target, GLenum pname, GLfloat param)) ldg_find("glTexEnvf", lib);
	GL_CHECK(glp->TexEnvf);
	glp->TexEnvi = (void APIENTRY (*)(GLenum target, GLenum pname, GLint param)) ldg_find("glTexEnvi", lib);
	GL_CHECK(glp->TexEnvi);
	glp->TexEnvfv = (void APIENTRY (*)(GLenum target, GLenum pname, const GLfloat *params)) ldg_find("glTexEnvfv", lib);
	GL_CHECK(glp->TexEnvfv);
	glp->TexEnviv = (void APIENTRY (*)(GLenum target, GLenum pname, const GLint *params)) ldg_find("glTexEnviv", lib);
	GL_CHECK(glp->TexEnviv);
	glp->GetTexEnvfv = (void APIENTRY (*)(GLenum target, GLenum pname, GLfloat *params)) ldg_find("glGetTexEnvfv", lib);
	GL_CHECK(glp->GetTexEnvfv);
	glp->GetTexEnviv = (void APIENTRY (*)(GLenum target, GLenum pname, GLint *params)) ldg_find("glGetTexEnviv", lib);
	GL_CHECK(glp->GetTexEnviv);
	glp->TexParameterf = (void APIENTRY (*)(GLenum target, GLenum pname, GLfloat param)) ldg_find("glTexParameterf", lib);
	GL_CHECK(glp->TexParameterf);
	glp->TexParameteri = (void APIENTRY (*)(GLenum target, GLenum pname, GLint param)) ldg_find("glTexParameteri", lib);
	GL_CHECK(glp->TexParameteri);
	glp->TexParameterfv = (void APIENTRY (*)(GLenum target, GLenum pname, const GLfloat *params)) ldg_find("glTexParameterfv", lib);
	GL_CHECK(glp->TexParameterfv);
	glp->TexParameteriv = (void APIENTRY (*)(GLenum target, GLenum pname, const GLint *params)) ldg_find("glTexParameteriv", lib);
	GL_CHECK(glp->TexParameteriv);
	glp->GetTexParameterfv = (void APIENTRY (*)(GLenum target, GLenum pname, GLfloat *params)) ldg_find("glGetTexParameterfv", lib);
	GL_CHECK(glp->GetTexParameterfv);
	glp->GetTexParameteriv = (void APIENTRY (*)(GLenum target, GLenum pname, GLint *params)) ldg_find("glGetTexParameteriv", lib);
	GL_CHECK(glp->GetTexParameteriv);
	glp->GetTexLevelParameterfv = (void APIENTRY (*)(GLenum target, GLint level, GLenum pname, GLfloat *params)) ldg_find("glGetTexLevelParameterfv", lib);
	GL_CHECK(glp->GetTexLevelParameterfv);
	glp->GetTexLevelParameteriv = (void APIENTRY (*)(GLenum target, GLint level, GLenum pname, GLint *params)) ldg_find("glGetTexLevelParameteriv", lib);
	GL_CHECK(glp->GetTexLevelParameteriv);
	glp->TexImage1D = (void APIENTRY (*)(GLenum target, GLint level, GLint internalformat, GLsizei width, GLint border, GLenum format, GLenum type, const GLvoid *pixels)) ldg_find("glTexImage1D", lib);
	GL_CHECK(glp->TexImage1D);
	glp->TexImage2D = (void APIENTRY (*)(GLenum target, GLint level, GLint internalformat, GLsizei width, GLsizei height, GLint border, GLenum format, GLenum type, const GLvoid *pixels)) ldg_find("glTexImage2D", lib);
	GL_CHECK(glp->TexImage2D);
	glp->GetTexImage = (void APIENTRY (*)(GLenum target, GLint level, GLenum format, GLenum type, GLvoid *pixels)) ldg_find("glGetTexImage", lib);
	GL_CHECK(glp->GetTexImage);
	glp->GenTextures = (void APIENTRY (*)(GLsizei n, GLuint *textures)) ldg_find("glGenTextures", lib);
	GL_CHECK(glp->GenTextures);
	glp->DeleteTextures = (void APIENTRY (*)(GLsizei n, const GLuint *textures)) ldg_find("glDeleteTextures", lib);
	GL_CHECK(glp->DeleteTextures);
	glp->BindTexture = (void APIENTRY (*)(GLenum target, GLuint texture)) ldg_find("glBindTexture", lib);
	GL_CHECK(glp->BindTexture);
	glp->PrioritizeTextures = (void APIENTRY (*)(GLsizei n, const GLuint *textures, const GLclampf *priorities)) ldg_find("glPrioritizeTextures", lib);
	GL_CHECK(glp->PrioritizeTextures);
	glp->AreTexturesResident = (GLboolean APIENTRY (*)(GLsizei n, const GLuint *textures, GLboolean *residences)) ldg_find("glAreTexturesResident", lib);
	GL_CHECK(glp->AreTexturesResident);
	glp->IsTexture = (GLboolean APIENTRY (*)(GLuint texture)) ldg_find("glIsTexture", lib);
	GL_CHECK(glp->IsTexture);
	glp->TexSubImage1D = (void APIENTRY (*)(GLenum target, GLint level, GLint xoffset, GLsizei width, GLenum format, GLenum type, const GLvoid *pixels)) ldg_find("glTexSubImage1D", lib);
	GL_CHECK(glp->TexSubImage1D);
	glp->TexSubImage2D = (void APIENTRY (*)(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLenum type, const GLvoid *pixels)) ldg_find("glTexSubImage2D", lib);
	GL_CHECK(glp->TexSubImage2D);
	glp->CopyTexImage1D = (void APIENTRY (*)(GLenum target, GLint level, GLenum internalformat, GLint x, GLint y, GLsizei width, GLint border)) ldg_find("glCopyTexImage1D", lib);
	GL_CHECK(glp->CopyTexImage1D);
	glp->CopyTexImage2D = (void APIENTRY (*)(GLenum target, GLint level, GLenum internalformat, GLint x, GLint y, GLsizei width, GLsizei height, GLint border)) ldg_find("glCopyTexImage2D", lib);
	GL_CHECK(glp->CopyTexImage2D);
	glp->CopyTexSubImage1D = (void APIENTRY (*)(GLenum target, GLint level, GLint xoffset, GLint x, GLint y, GLsizei width)) ldg_find("glCopyTexSubImage1D", lib);
	GL_CHECK(glp->CopyTexSubImage1D);
	glp->CopyTexSubImage2D = (void APIENTRY (*)(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint x, GLint y, GLsizei width, GLsizei height)) ldg_find("glCopyTexSubImage2D", lib);
	GL_CHECK(glp->CopyTexSubImage2D);
	glp->Map1d = (void APIENTRY (*)(GLenum target, GLdouble u1, GLdouble u2, GLint stride, GLint order, const GLdouble *points)) ldg_find("glMap1d", lib);
	GL_CHECK(glp->Map1d);
	glp->Map1f = (void APIENTRY (*)(GLenum target, GLfloat u1, GLfloat u2, GLint stride, GLint order, const GLfloat *points)) ldg_find("glMap1f", lib);
	GL_CHECK(glp->Map1f);
	glp->Map2d = (void APIENTRY (*)(GLenum target, GLdouble u1, GLdouble u2, GLint ustride, GLint uorder, GLdouble v1, GLdouble v2, GLint vstride, GLint vorder, const GLdouble *points)) ldg_find("glMap2d", lib);
	GL_CHECK(glp->Map2d);
	glp->Map2f = (void APIENTRY (*)(GLenum target, GLfloat u1, GLfloat u2, GLint ustride, GLint uorder, GLfloat v1, GLfloat v2, GLint vstride, GLint vorder, const GLfloat *points)) ldg_find("glMap2f", lib);
	GL_CHECK(glp->Map2f);
	glp->GetMapdv = (void APIENTRY (*)(GLenum target, GLenum query, GLdouble *v)) ldg_find("glGetMapdv", lib);
	GL_CHECK(glp->GetMapdv);
	glp->GetMapfv = (void APIENTRY (*)(GLenum target, GLenum query, GLfloat *v)) ldg_find("glGetMapfv", lib);
	GL_CHECK(glp->GetMapfv);
	glp->GetMapiv = (void APIENTRY (*)(GLenum target, GLenum query, GLint *v)) ldg_find("glGetMapiv", lib);
	GL_CHECK(glp->GetMapiv);
	glp->EvalCoord1d = (void APIENTRY (*)(GLdouble u)) ldg_find("glEvalCoord1d", lib);
	GL_CHECK(glp->EvalCoord1d);
	glp->EvalCoord1f = (void APIENTRY (*)(GLfloat u)) ldg_find("glEvalCoord1f", lib);
	GL_CHECK(glp->EvalCoord1f);
	glp->EvalCoord1dv = (void APIENTRY (*)(const GLdouble *u)) ldg_find("glEvalCoord1dv", lib);
	GL_CHECK(glp->EvalCoord1dv);
	glp->EvalCoord1fv = (void APIENTRY (*)(const GLfloat *u)) ldg_find("glEvalCoord1fv", lib);
	GL_CHECK(glp->EvalCoord1fv);
	glp->EvalCoord2d = (void APIENTRY (*)(GLdouble u, GLdouble v)) ldg_find("glEvalCoord2d", lib);
	GL_CHECK(glp->EvalCoord2d);
	glp->EvalCoord2f = (void APIENTRY (*)(GLfloat u, GLfloat v)) ldg_find("glEvalCoord2f", lib);
	GL_CHECK(glp->EvalCoord2f);
	glp->EvalCoord2dv = (void APIENTRY (*)(const GLdouble *u)) ldg_find("glEvalCoord2dv", lib);
	GL_CHECK(glp->EvalCoord2dv);
	glp->EvalCoord2fv = (void APIENTRY (*)(const GLfloat *u)) ldg_find("glEvalCoord2fv", lib);
	GL_CHECK(glp->EvalCoord2fv);
	glp->MapGrid1d = (void APIENTRY (*)(GLint un, GLdouble u1, GLdouble u2)) ldg_find("glMapGrid1d", lib);
	GL_CHECK(glp->MapGrid1d);
	glp->MapGrid1f = (void APIENTRY (*)(GLint un, GLfloat u1, GLfloat u2)) ldg_find("glMapGrid1f", lib);
	GL_CHECK(glp->MapGrid1f);
	glp->MapGrid2d = (void APIENTRY (*)(GLint un, GLdouble u1, GLdouble u2, GLint vn, GLdouble v1, GLdouble v2)) ldg_find("glMapGrid2d", lib);
	GL_CHECK(glp->MapGrid2d);
	glp->MapGrid2f = (void APIENTRY (*)(GLint un, GLfloat u1, GLfloat u2, GLint vn, GLfloat v1, GLfloat v2)) ldg_find("glMapGrid2f", lib);
	GL_CHECK(glp->MapGrid2f);
	glp->EvalPoint1 = (void APIENTRY (*)(GLint i)) ldg_find("glEvalPoint1", lib);
	GL_CHECK(glp->EvalPoint1);
	glp->EvalPoint2 = (void APIENTRY (*)(GLint i, GLint j)) ldg_find("glEvalPoint2", lib);
	GL_CHECK(glp->EvalPoint2);
	glp->EvalMesh1 = (void APIENTRY (*)(GLenum mode, GLint i1, GLint i2)) ldg_find("glEvalMesh1", lib);
	GL_CHECK(glp->EvalMesh1);
	glp->EvalMesh2 = (void APIENTRY (*)(GLenum mode, GLint i1, GLint i2, GLint j1, GLint j2)) ldg_find("glEvalMesh2", lib);
	GL_CHECK(glp->EvalMesh2);
	glp->Fogf = (void APIENTRY (*)(GLenum pname, GLfloat param)) ldg_find("glFogf", lib);
	GL_CHECK(glp->Fogf);
	glp->Fogi = (void APIENTRY (*)(GLenum pname, GLint param)) ldg_find("glFogi", lib);
	GL_CHECK(glp->Fogi);
	glp->Fogfv = (void APIENTRY (*)(GLenum pname, const GLfloat *params)) ldg_find("glFogfv", lib);
	GL_CHECK(glp->Fogfv);
	glp->Fogiv = (void APIENTRY (*)(GLenum pname, const GLint *params)) ldg_find("glFogiv", lib);
	GL_CHECK(glp->Fogiv);
	glp->FeedbackBuffer = (void APIENTRY (*)(GLsizei size, GLenum type, GLfloat *buffer)) ldg_find("glFeedbackBuffer", lib);
	GL_CHECK(glp->FeedbackBuffer);
	glp->PassThrough = (void APIENTRY (*)(GLfloat token)) ldg_find("glPassThrough", lib);
	GL_CHECK(glp->PassThrough);
	glp->SelectBuffer = (void APIENTRY (*)(GLsizei size, GLuint *buffer)) ldg_find("glSelectBuffer", lib);
	GL_CHECK(glp->SelectBuffer);
	glp->InitNames = (void APIENTRY (*)(void)) ldg_find("glInitNames", lib);
	GL_CHECK(glp->InitNames);
	glp->LoadName = (void APIENTRY (*)(GLuint name)) ldg_find("glLoadName", lib);
	GL_CHECK(glp->LoadName);
	glp->PushName = (void APIENTRY (*)(GLuint name)) ldg_find("glPushName", lib);
	GL_CHECK(glp->PushName);
	glp->PopName = (void APIENTRY (*)(void)) ldg_find("glPopName", lib);
	GL_CHECK(glp->PopName);
	glp->EnableTraceMESA = (void APIENTRY (*)(GLbitfield mask)) ldg_find("glEnableTraceMESA", lib);
	GL_CHECK(glp->EnableTraceMESA);
	glp->DisableTraceMESA = (void APIENTRY (*)(GLbitfield mask)) ldg_find("glDisableTraceMESA", lib);
	GL_CHECK(glp->DisableTraceMESA);
	glp->NewTraceMESA = (void APIENTRY (*)(GLbitfield mask, const GLubyte *traceName)) ldg_find("glNewTraceMESA", lib);
	GL_CHECK(glp->NewTraceMESA);
	glp->EndTraceMESA = (void APIENTRY (*)(void)) ldg_find("glEndTraceMESA", lib);
	GL_CHECK(glp->EndTraceMESA);
	glp->TraceAssertAttribMESA = (void APIENTRY (*)(GLbitfield attribMask)) ldg_find("glTraceAssertAttribMESA", lib);
	GL_CHECK(glp->TraceAssertAttribMESA);
	glp->TraceCommentMESA = (void APIENTRY (*)(const GLubyte *comment)) ldg_find("glTraceCommentMESA", lib);
	GL_CHECK(glp->TraceCommentMESA);
	glp->TraceTextureMESA = (void APIENTRY (*)(GLuint name, const GLubyte *comment)) ldg_find("glTraceTextureMESA", lib);
	GL_CHECK(glp->TraceTextureMESA);
	glp->TraceListMESA = (void APIENTRY (*)(GLuint name, const GLubyte *comment)) ldg_find("glTraceListMESA", lib);
	GL_CHECK(glp->TraceListMESA);
	glp->TracePointerMESA = (void APIENTRY (*)(GLvoid *pointer, const GLubyte *comment)) ldg_find("glTracePointerMESA", lib);
	GL_CHECK(glp->TracePointerMESA);
	glp->TracePointerRangeMESA = (void APIENTRY (*)(const GLvoid *first, const GLvoid *last, const GLubyte *comment)) ldg_find("glTracePointerRangeMESA", lib);
	GL_CHECK(glp->TracePointerRangeMESA);
	glp->BlendEquationSeparateATI = (void APIENTRY (*)(GLenum equationRGB, GLenum equationAlpha)) ldg_find("glBlendEquationSeparateATI", lib);
	GL_CHECK(glp->BlendEquationSeparateATI);
	glp->BlendColor = (void APIENTRY (*)(GLfloat red, GLfloat green, GLfloat blue, GLfloat alpha)) ldg_find("glBlendColor", lib);
	GL_CHECK(glp->BlendColor);
	glp->BlendEquation = (void APIENTRY (*)(GLenum mode)) ldg_find("glBlendEquation", lib);
	GL_CHECK(glp->BlendEquation);
	glp->DrawRangeElements = (void APIENTRY (*)(GLenum mode, GLuint start, GLuint end, GLsizei count, GLenum type, const void *indices)) ldg_find("glDrawRangeElements", lib);
	GL_CHECK(glp->DrawRangeElements);
	glp->ColorTable = (void APIENTRY (*)(GLenum target, GLenum internalformat, GLsizei width, GLenum format, GLenum type, const void *table)) ldg_find("glColorTable", lib);
	GL_CHECK(glp->ColorTable);
	glp->ColorTableParameterfv = (void APIENTRY (*)(GLenum target, GLenum pname, const GLfloat *params)) ldg_find("glColorTableParameterfv", lib);
	GL_CHECK(glp->ColorTableParameterfv);
	glp->ColorTableParameteriv = (void APIENTRY (*)(GLenum target, GLenum pname, const GLint *params)) ldg_find("glColorTableParameteriv", lib);
	GL_CHECK(glp->ColorTableParameteriv);
	glp->CopyColorTable = (void APIENTRY (*)(GLenum target, GLenum internalformat, GLint x, GLint y, GLsizei width)) ldg_find("glCopyColorTable", lib);
	GL_CHECK(glp->CopyColorTable);
	glp->GetColorTable = (void APIENTRY (*)(GLenum target, GLenum format, GLenum type, void *table)) ldg_find("glGetColorTable", lib);
	GL_CHECK(glp->GetColorTable);
	glp->GetColorTableParameterfv = (void APIENTRY (*)(GLenum target, GLenum pname, GLfloat *params)) ldg_find("glGetColorTableParameterfv", lib);
	GL_CHECK(glp->GetColorTableParameterfv);
	glp->GetColorTableParameteriv = (void APIENTRY (*)(GLenum target, GLenum pname, GLint *params)) ldg_find("glGetColorTableParameteriv", lib);
	GL_CHECK(glp->GetColorTableParameteriv);
	glp->ColorSubTable = (void APIENTRY (*)(GLenum target, GLsizei start, GLsizei count, GLenum format, GLenum type, const void *data)) ldg_find("glColorSubTable", lib);
	GL_CHECK(glp->ColorSubTable);
	glp->CopyColorSubTable = (void APIENTRY (*)(GLenum target, GLsizei start, GLint x, GLint y, GLsizei width)) ldg_find("glCopyColorSubTable", lib);
	GL_CHECK(glp->CopyColorSubTable);
	glp->ConvolutionFilter1D = (void APIENTRY (*)(GLenum target, GLenum internalformat, GLsizei width, GLenum format, GLenum type, const void *image)) ldg_find("glConvolutionFilter1D", lib);
	GL_CHECK(glp->ConvolutionFilter1D);
	glp->ConvolutionFilter2D = (void APIENTRY (*)(GLenum target, GLenum internalformat, GLsizei width, GLsizei height, GLenum format, GLenum type, const void *image)) ldg_find("glConvolutionFilter2D", lib);
	GL_CHECK(glp->ConvolutionFilter2D);
	glp->ConvolutionParameterf = (void APIENTRY (*)(GLenum target, GLenum pname, GLfloat params)) ldg_find("glConvolutionParameterf", lib);
	GL_CHECK(glp->ConvolutionParameterf);
	glp->ConvolutionParameterfv = (void APIENTRY (*)(GLenum target, GLenum pname, const GLfloat *params)) ldg_find("glConvolutionParameterfv", lib);
	GL_CHECK(glp->ConvolutionParameterfv);
	glp->ConvolutionParameteri = (void APIENTRY (*)(GLenum target, GLenum pname, GLint params)) ldg_find("glConvolutionParameteri", lib);
	GL_CHECK(glp->ConvolutionParameteri);
	glp->ConvolutionParameteriv = (void APIENTRY (*)(GLenum target, GLenum pname, const GLint *params)) ldg_find("glConvolutionParameteriv", lib);
	GL_CHECK(glp->ConvolutionParameteriv);
	glp->CopyConvolutionFilter1D = (void APIENTRY (*)(GLenum target, GLenum internalformat, GLint x, GLint y, GLsizei width)) ldg_find("glCopyConvolutionFilter1D", lib);
	GL_CHECK(glp->CopyConvolutionFilter1D);
	glp->CopyConvolutionFilter2D = (void APIENTRY (*)(GLenum target, GLenum internalformat, GLint x, GLint y, GLsizei width, GLsizei height)) ldg_find("glCopyConvolutionFilter2D", lib);
	GL_CHECK(glp->CopyConvolutionFilter2D);
	glp->GetConvolutionFilter = (void APIENTRY (*)(GLenum target, GLenum format, GLenum type, void *image)) ldg_find("glGetConvolutionFilter", lib);
	GL_CHECK(glp->GetConvolutionFilter);
	glp->GetConvolutionParameterfv = (void APIENTRY (*)(GLenum target, GLenum pname, GLfloat *params)) ldg_find("glGetConvolutionParameterfv", lib);
	GL_CHECK(glp->GetConvolutionParameterfv);
	glp->GetConvolutionParameteriv = (void APIENTRY (*)(GLenum target, GLenum pname, GLint *params)) ldg_find("glGetConvolutionParameteriv", lib);
	GL_CHECK(glp->GetConvolutionParameteriv);
	glp->GetSeparableFilter = (void APIENTRY (*)(GLenum target, GLenum format, GLenum type, void *row, void *column, void *span)) ldg_find("glGetSeparableFilter", lib);
	GL_CHECK(glp->GetSeparableFilter);
	glp->SeparableFilter2D = (void APIENTRY (*)(GLenum target, GLenum internalformat, GLsizei width, GLsizei height, GLenum format, GLenum type, const void *row, const void *column)) ldg_find("glSeparableFilter2D", lib);
	GL_CHECK(glp->SeparableFilter2D);
	glp->GetHistogram = (void APIENTRY (*)(GLenum target, GLboolean32 reset, GLenum format, GLenum type, void *values)) ldg_find("glGetHistogram", lib);
	GL_CHECK(glp->GetHistogram);
	glp->GetHistogramParameterfv = (void APIENTRY (*)(GLenum target, GLenum pname, GLfloat *params)) ldg_find("glGetHistogramParameterfv", lib);
	GL_CHECK(glp->GetHistogramParameterfv);
	glp->GetHistogramParameteriv = (void APIENTRY (*)(GLenum target, GLenum pname, GLint *params)) ldg_find("glGetHistogramParameteriv", lib);
	GL_CHECK(glp->GetHistogramParameteriv);
	glp->GetMinmax = (void APIENTRY (*)(GLenum target, GLboolean32 reset, GLenum format, GLenum type, void *values)) ldg_find("glGetMinmax", lib);
	GL_CHECK(glp->GetMinmax);
	glp->GetMinmaxParameterfv = (void APIENTRY (*)(GLenum target, GLenum pname, GLfloat *params)) ldg_find("glGetMinmaxParameterfv", lib);
	GL_CHECK(glp->GetMinmaxParameterfv);
	glp->GetMinmaxParameteriv = (void APIENTRY (*)(GLenum target, GLenum pname, GLint *params)) ldg_find("glGetMinmaxParameteriv", lib);
	GL_CHECK(glp->GetMinmaxParameteriv);
	glp->Histogram = (void APIENTRY (*)(GLenum target, GLsizei width, GLenum internalformat, GLboolean32 sink)) ldg_find("glHistogram", lib);
	GL_CHECK(glp->Histogram);
	glp->Minmax = (void APIENTRY (*)(GLenum target, GLenum internalformat, GLboolean32 sink)) ldg_find("glMinmax", lib);
	GL_CHECK(glp->Minmax);
	glp->ResetHistogram = (void APIENTRY (*)(GLenum target)) ldg_find("glResetHistogram", lib);
	GL_CHECK(glp->ResetHistogram);
	glp->ResetMinmax = (void APIENTRY (*)(GLenum target)) ldg_find("glResetMinmax", lib);
	GL_CHECK(glp->ResetMinmax);
	glp->TexImage3D = (void APIENTRY (*)(GLenum target, GLint level, GLint internalformat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLenum format, GLenum type, const void *pixels)) ldg_find("glTexImage3D", lib);
	GL_CHECK(glp->TexImage3D);
	glp->TexSubImage3D = (void APIENTRY (*)(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLenum type, const void *pixels)) ldg_find("glTexSubImage3D", lib);
	GL_CHECK(glp->TexSubImage3D);
	glp->CopyTexSubImage3D = (void APIENTRY (*)(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLint x, GLint y, GLsizei width, GLsizei height)) ldg_find("glCopyTexSubImage3D", lib);
	GL_CHECK(glp->CopyTexSubImage3D);
	glp->ActiveTexture = (void APIENTRY (*)(GLenum texture)) ldg_find("glActiveTexture", lib);
	GL_CHECK(glp->ActiveTexture);
	glp->ClientActiveTexture = (void APIENTRY (*)(GLenum texture)) ldg_find("glClientActiveTexture", lib);
	GL_CHECK(glp->ClientActiveTexture);
	glp->MultiTexCoord1d = (void APIENTRY (*)(GLenum target, GLdouble s)) ldg_find("glMultiTexCoord1d", lib);
	GL_CHECK(glp->MultiTexCoord1d);
	glp->MultiTexCoord1dv = (void APIENTRY (*)(GLenum target, const GLdouble *v)) ldg_find("glMultiTexCoord1dv", lib);
	GL_CHECK(glp->MultiTexCoord1dv);
	glp->MultiTexCoord1f = (void APIENTRY (*)(GLenum target, GLfloat s)) ldg_find("glMultiTexCoord1f", lib);
	GL_CHECK(glp->MultiTexCoord1f);
	glp->MultiTexCoord1fv = (void APIENTRY (*)(GLenum target, const GLfloat *v)) ldg_find("glMultiTexCoord1fv", lib);
	GL_CHECK(glp->MultiTexCoord1fv);
	glp->MultiTexCoord1i = (void APIENTRY (*)(GLenum target, GLint s)) ldg_find("glMultiTexCoord1i", lib);
	GL_CHECK(glp->MultiTexCoord1i);
	glp->MultiTexCoord1iv = (void APIENTRY (*)(GLenum target, const GLint *v)) ldg_find("glMultiTexCoord1iv", lib);
	GL_CHECK(glp->MultiTexCoord1iv);
	glp->MultiTexCoord1s = (void APIENTRY (*)(GLenum target, GLshort32 s)) ldg_find("glMultiTexCoord1s", lib);
	GL_CHECK(glp->MultiTexCoord1s);
	glp->MultiTexCoord1sv = (void APIENTRY (*)(GLenum target, const GLshort *v)) ldg_find("glMultiTexCoord1sv", lib);
	GL_CHECK(glp->MultiTexCoord1sv);
	glp->MultiTexCoord2d = (void APIENTRY (*)(GLenum target, GLdouble s, GLdouble t)) ldg_find("glMultiTexCoord2d", lib);
	GL_CHECK(glp->MultiTexCoord2d);
	glp->MultiTexCoord2dv = (void APIENTRY (*)(GLenum target, const GLdouble *v)) ldg_find("glMultiTexCoord2dv", lib);
	GL_CHECK(glp->MultiTexCoord2dv);
	glp->MultiTexCoord2f = (void APIENTRY (*)(GLenum target, GLfloat s, GLfloat t)) ldg_find("glMultiTexCoord2f", lib);
	GL_CHECK(glp->MultiTexCoord2f);
	glp->MultiTexCoord2fv = (void APIENTRY (*)(GLenum target, const GLfloat *v)) ldg_find("glMultiTexCoord2fv", lib);
	GL_CHECK(glp->MultiTexCoord2fv);
	glp->MultiTexCoord2i = (void APIENTRY (*)(GLenum target, GLint s, GLint t)) ldg_find("glMultiTexCoord2i", lib);
	GL_CHECK(glp->MultiTexCoord2i);
	glp->MultiTexCoord2iv = (void APIENTRY (*)(GLenum target, const GLint *v)) ldg_find("glMultiTexCoord2iv", lib);
	GL_CHECK(glp->MultiTexCoord2iv);
	glp->MultiTexCoord2s = (void APIENTRY (*)(GLenum target, GLshort32 s, GLshort32 t)) ldg_find("glMultiTexCoord2s", lib);
	GL_CHECK(glp->MultiTexCoord2s);
	glp->MultiTexCoord2sv = (void APIENTRY (*)(GLenum target, const GLshort *v)) ldg_find("glMultiTexCoord2sv", lib);
	GL_CHECK(glp->MultiTexCoord2sv);
	glp->MultiTexCoord3d = (void APIENTRY (*)(GLenum target, GLdouble s, GLdouble t, GLdouble r)) ldg_find("glMultiTexCoord3d", lib);
	GL_CHECK(glp->MultiTexCoord3d);
	glp->MultiTexCoord3dv = (void APIENTRY (*)(GLenum target, const GLdouble *v)) ldg_find("glMultiTexCoord3dv", lib);
	GL_CHECK(glp->MultiTexCoord3dv);
	glp->MultiTexCoord3f = (void APIENTRY (*)(GLenum target, GLfloat s, GLfloat t, GLfloat r)) ldg_find("glMultiTexCoord3f", lib);
	GL_CHECK(glp->MultiTexCoord3f);
	glp->MultiTexCoord3fv = (void APIENTRY (*)(GLenum target, const GLfloat *v)) ldg_find("glMultiTexCoord3fv", lib);
	GL_CHECK(glp->MultiTexCoord3fv);
	glp->MultiTexCoord3i = (void APIENTRY (*)(GLenum target, GLint s, GLint t, GLint r)) ldg_find("glMultiTexCoord3i", lib);
	GL_CHECK(glp->MultiTexCoord3i);
	glp->MultiTexCoord3iv = (void APIENTRY (*)(GLenum target, const GLint *v)) ldg_find("glMultiTexCoord3iv", lib);
	GL_CHECK(glp->MultiTexCoord3iv);
	glp->MultiTexCoord3s = (void APIENTRY (*)(GLenum target, GLshort32 s, GLshort32 t, GLshort32 r)) ldg_find("glMultiTexCoord3s", lib);
	GL_CHECK(glp->MultiTexCoord3s);
	glp->MultiTexCoord3sv = (void APIENTRY (*)(GLenum target, const GLshort *v)) ldg_find("glMultiTexCoord3sv", lib);
	GL_CHECK(glp->MultiTexCoord3sv);
	glp->MultiTexCoord4d = (void APIENTRY (*)(GLenum target, GLdouble s, GLdouble t, GLdouble r, GLdouble q)) ldg_find("glMultiTexCoord4d", lib);
	GL_CHECK(glp->MultiTexCoord4d);
	glp->MultiTexCoord4dv = (void APIENTRY (*)(GLenum target, const GLdouble *v)) ldg_find("glMultiTexCoord4dv", lib);
	GL_CHECK(glp->MultiTexCoord4dv);
	glp->MultiTexCoord4f = (void APIENTRY (*)(GLenum target, GLfloat s, GLfloat t, GLfloat r, GLfloat q)) ldg_find("glMultiTexCoord4f", lib);
	GL_CHECK(glp->MultiTexCoord4f);
	glp->MultiTexCoord4fv = (void APIENTRY (*)(GLenum target, const GLfloat *v)) ldg_find("glMultiTexCoord4fv", lib);
	GL_CHECK(glp->MultiTexCoord4fv);
	glp->MultiTexCoord4i = (void APIENTRY (*)(GLenum target, GLint s, GLint t, GLint r, GLint q)) ldg_find("glMultiTexCoord4i", lib);
	GL_CHECK(glp->MultiTexCoord4i);
	glp->MultiTexCoord4iv = (void APIENTRY (*)(GLenum target, const GLint *v)) ldg_find("glMultiTexCoord4iv", lib);
	GL_CHECK(glp->MultiTexCoord4iv);
	glp->MultiTexCoord4s = (void APIENTRY (*)(GLenum target, GLshort32 s, GLshort32 t, GLshort32 r, GLshort32 q)) ldg_find("glMultiTexCoord4s", lib);
	GL_CHECK(glp->MultiTexCoord4s);
	glp->MultiTexCoord4sv = (void APIENTRY (*)(GLenum target, const GLshort *v)) ldg_find("glMultiTexCoord4sv", lib);
	GL_CHECK(glp->MultiTexCoord4sv);
	glp->LoadTransposeMatrixf = (void APIENTRY (*)(const GLfloat *m)) ldg_find("glLoadTransposeMatrixf", lib);
	GL_CHECK(glp->LoadTransposeMatrixf);
	glp->LoadTransposeMatrixd = (void APIENTRY (*)(const GLdouble *m)) ldg_find("glLoadTransposeMatrixd", lib);
	GL_CHECK(glp->LoadTransposeMatrixd);
	glp->MultTransposeMatrixf = (void APIENTRY (*)(const GLfloat *m)) ldg_find("glMultTransposeMatrixf", lib);
	GL_CHECK(glp->MultTransposeMatrixf);
	glp->MultTransposeMatrixd = (void APIENTRY (*)(const GLdouble *m)) ldg_find("glMultTransposeMatrixd", lib);
	GL_CHECK(glp->MultTransposeMatrixd);
	glp->SampleCoverage = (void APIENTRY (*)(GLfloat value, GLboolean32 invert)) ldg_find("glSampleCoverage", lib);
	GL_CHECK(glp->SampleCoverage);
	glp->CompressedTexImage3D = (void APIENTRY (*)(GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLsizei imageSize, const void *data)) ldg_find("glCompressedTexImage3D", lib);
	GL_CHECK(glp->CompressedTexImage3D);
	glp->CompressedTexImage2D = (void APIENTRY (*)(GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLint border, GLsizei imageSize, const void *data)) ldg_find("glCompressedTexImage2D", lib);
	GL_CHECK(glp->CompressedTexImage2D);
	glp->CompressedTexImage1D = (void APIENTRY (*)(GLenum target, GLint level, GLenum internalformat, GLsizei width, GLint border, GLsizei imageSize, const void *data)) ldg_find("glCompressedTexImage1D", lib);
	GL_CHECK(glp->CompressedTexImage1D);
	glp->CompressedTexSubImage3D = (void APIENTRY (*)(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLsizei imageSize, const void *data)) ldg_find("glCompressedTexSubImage3D", lib);
	GL_CHECK(glp->CompressedTexSubImage3D);
	glp->CompressedTexSubImage2D = (void APIENTRY (*)(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLsizei imageSize, const void *data)) ldg_find("glCompressedTexSubImage2D", lib);
	GL_CHECK(glp->CompressedTexSubImage2D);
	glp->CompressedTexSubImage1D = (void APIENTRY (*)(GLenum target, GLint level, GLint xoffset, GLsizei width, GLenum format, GLsizei imageSize, const void *data)) ldg_find("glCompressedTexSubImage1D", lib);
	GL_CHECK(glp->CompressedTexSubImage1D);
	glp->GetCompressedTexImage = (void APIENTRY (*)(GLenum target, GLint level, void *img)) ldg_find("glGetCompressedTexImage", lib);
	GL_CHECK(glp->GetCompressedTexImage);
	glp->BlendFuncSeparate = (void APIENTRY (*)(GLenum sfactorRGB, GLenum dfactorRGB, GLenum sfactorAlpha, GLenum dfactorAlpha)) ldg_find("glBlendFuncSeparate", lib);
	GL_CHECK(glp->BlendFuncSeparate);
	glp->FogCoordf = (void APIENTRY (*)(GLfloat coord)) ldg_find("glFogCoordf", lib);
	GL_CHECK(glp->FogCoordf);
	glp->FogCoordfv = (void APIENTRY (*)(const GLfloat *coord)) ldg_find("glFogCoordfv", lib);
	GL_CHECK(glp->FogCoordfv);
	glp->FogCoordd = (void APIENTRY (*)(GLdouble coord)) ldg_find("glFogCoordd", lib);
	GL_CHECK(glp->FogCoordd);
	glp->FogCoorddv = (void APIENTRY (*)(const GLdouble *coord)) ldg_find("glFogCoorddv", lib);
	GL_CHECK(glp->FogCoorddv);
	glp->FogCoordPointer = (void APIENTRY (*)(GLenum type, GLsizei stride, const void *pointer)) ldg_find("glFogCoordPointer", lib);
	GL_CHECK(glp->FogCoordPointer);
	glp->MultiDrawArrays = (void APIENTRY (*)(GLenum mode, const GLint *first, const GLsizei *count, GLsizei drawcount)) ldg_find("glMultiDrawArrays", lib);
	GL_CHECK(glp->MultiDrawArrays);
	glp->MultiDrawElements = (void APIENTRY (*)(GLenum mode, const GLsizei *count, GLenum type, const void *const *indices, GLsizei drawcount)) ldg_find("glMultiDrawElements", lib);
	GL_CHECK(glp->MultiDrawElements);
	glp->PointParameterf = (void APIENTRY (*)(GLenum pname, GLfloat param)) ldg_find("glPointParameterf", lib);
	GL_CHECK(glp->PointParameterf);
	glp->PointParameterfv = (void APIENTRY (*)(GLenum pname, const GLfloat *params)) ldg_find("glPointParameterfv", lib);
	GL_CHECK(glp->PointParameterfv);
	glp->PointParameteri = (void APIENTRY (*)(GLenum pname, GLint param)) ldg_find("glPointParameteri", lib);
	GL_CHECK(glp->PointParameteri);
	glp->PointParameteriv = (void APIENTRY (*)(GLenum pname, const GLint *params)) ldg_find("glPointParameteriv", lib);
	GL_CHECK(glp->PointParameteriv);
	glp->SecondaryColor3b = (void APIENTRY (*)(GLbyte32 red, GLbyte32 green, GLbyte32 blue)) ldg_find("glSecondaryColor3b", lib);
	GL_CHECK(glp->SecondaryColor3b);
	glp->SecondaryColor3bv = (void APIENTRY (*)(const GLbyte *v)) ldg_find("glSecondaryColor3bv", lib);
	GL_CHECK(glp->SecondaryColor3bv);
	glp->SecondaryColor3d = (void APIENTRY (*)(GLdouble red, GLdouble green, GLdouble blue)) ldg_find("glSecondaryColor3d", lib);
	GL_CHECK(glp->SecondaryColor3d);
	glp->SecondaryColor3dv = (void APIENTRY (*)(const GLdouble *v)) ldg_find("glSecondaryColor3dv", lib);
	GL_CHECK(glp->SecondaryColor3dv);
	glp->SecondaryColor3f = (void APIENTRY (*)(GLfloat red, GLfloat green, GLfloat blue)) ldg_find("glSecondaryColor3f", lib);
	GL_CHECK(glp->SecondaryColor3f);
	glp->SecondaryColor3fv = (void APIENTRY (*)(const GLfloat *v)) ldg_find("glSecondaryColor3fv", lib);
	GL_CHECK(glp->SecondaryColor3fv);
	glp->SecondaryColor3i = (void APIENTRY (*)(GLint red, GLint green, GLint blue)) ldg_find("glSecondaryColor3i", lib);
	GL_CHECK(glp->SecondaryColor3i);
	glp->SecondaryColor3iv = (void APIENTRY (*)(const GLint *v)) ldg_find("glSecondaryColor3iv", lib);
	GL_CHECK(glp->SecondaryColor3iv);
	glp->SecondaryColor3s = (void APIENTRY (*)(GLshort32 red, GLshort32 green, GLshort32 blue)) ldg_find("glSecondaryColor3s", lib);
	GL_CHECK(glp->SecondaryColor3s);
	glp->SecondaryColor3sv = (void APIENTRY (*)(const GLshort *v)) ldg_find("glSecondaryColor3sv", lib);
	GL_CHECK(glp->SecondaryColor3sv);
	glp->SecondaryColor3ub = (void APIENTRY (*)(GLubyte32 red, GLubyte32 green, GLubyte32 blue)) ldg_find("glSecondaryColor3ub", lib);
	GL_CHECK(glp->SecondaryColor3ub);
	glp->SecondaryColor3ubv = (void APIENTRY (*)(const GLubyte *v)) ldg_find("glSecondaryColor3ubv", lib);
	GL_CHECK(glp->SecondaryColor3ubv);
	glp->SecondaryColor3ui = (void APIENTRY (*)(GLuint red, GLuint green, GLuint blue)) ldg_find("glSecondaryColor3ui", lib);
	GL_CHECK(glp->SecondaryColor3ui);
	glp->SecondaryColor3uiv = (void APIENTRY (*)(const GLuint *v)) ldg_find("glSecondaryColor3uiv", lib);
	GL_CHECK(glp->SecondaryColor3uiv);
	glp->SecondaryColor3us = (void APIENTRY (*)(GLushort32 red, GLushort32 green, GLushort32 blue)) ldg_find("glSecondaryColor3us", lib);
	GL_CHECK(glp->SecondaryColor3us);
	glp->SecondaryColor3usv = (void APIENTRY (*)(const GLushort *v)) ldg_find("glSecondaryColor3usv", lib);
	GL_CHECK(glp->SecondaryColor3usv);
	glp->SecondaryColorPointer = (void APIENTRY (*)(GLint size, GLenum type, GLsizei stride, const void *pointer)) ldg_find("glSecondaryColorPointer", lib);
	GL_CHECK(glp->SecondaryColorPointer);
	glp->WindowPos2d = (void APIENTRY (*)(GLdouble x, GLdouble y)) ldg_find("glWindowPos2d", lib);
	GL_CHECK(glp->WindowPos2d);
	glp->WindowPos2dv = (void APIENTRY (*)(const GLdouble *v)) ldg_find("glWindowPos2dv", lib);
	GL_CHECK(glp->WindowPos2dv);
	glp->WindowPos2f = (void APIENTRY (*)(GLfloat x, GLfloat y)) ldg_find("glWindowPos2f", lib);
	GL_CHECK(glp->WindowPos2f);
	glp->WindowPos2fv = (void APIENTRY (*)(const GLfloat *v)) ldg_find("glWindowPos2fv", lib);
	GL_CHECK(glp->WindowPos2fv);
	glp->WindowPos2i = (void APIENTRY (*)(GLint x, GLint y)) ldg_find("glWindowPos2i", lib);
	GL_CHECK(glp->WindowPos2i);
	glp->WindowPos2iv = (void APIENTRY (*)(const GLint *v)) ldg_find("glWindowPos2iv", lib);
	GL_CHECK(glp->WindowPos2iv);
	glp->WindowPos2s = (void APIENTRY (*)(GLshort32 x, GLshort32 y)) ldg_find("glWindowPos2s", lib);
	GL_CHECK(glp->WindowPos2s);
	glp->WindowPos2sv = (void APIENTRY (*)(const GLshort *v)) ldg_find("glWindowPos2sv", lib);
	GL_CHECK(glp->WindowPos2sv);
	glp->WindowPos3d = (void APIENTRY (*)(GLdouble x, GLdouble y, GLdouble z)) ldg_find("glWindowPos3d", lib);
	GL_CHECK(glp->WindowPos3d);
	glp->WindowPos3dv = (void APIENTRY (*)(const GLdouble *v)) ldg_find("glWindowPos3dv", lib);
	GL_CHECK(glp->WindowPos3dv);
	glp->WindowPos3f = (void APIENTRY (*)(GLfloat x, GLfloat y, GLfloat z)) ldg_find("glWindowPos3f", lib);
	GL_CHECK(glp->WindowPos3f);
	glp->WindowPos3fv = (void APIENTRY (*)(const GLfloat *v)) ldg_find("glWindowPos3fv", lib);
	GL_CHECK(glp->WindowPos3fv);
	glp->WindowPos3i = (void APIENTRY (*)(GLint x, GLint y, GLint z)) ldg_find("glWindowPos3i", lib);
	GL_CHECK(glp->WindowPos3i);
	glp->WindowPos3iv = (void APIENTRY (*)(const GLint *v)) ldg_find("glWindowPos3iv", lib);
	GL_CHECK(glp->WindowPos3iv);
	glp->WindowPos3s = (void APIENTRY (*)(GLshort32 x, GLshort32 y, GLshort32 z)) ldg_find("glWindowPos3s", lib);
	GL_CHECK(glp->WindowPos3s);
	glp->WindowPos3sv = (void APIENTRY (*)(const GLshort *v)) ldg_find("glWindowPos3sv", lib);
	GL_CHECK(glp->WindowPos3sv);
	glp->GenQueries = (void APIENTRY (*)(GLsizei n, GLuint *ids)) ldg_find("glGenQueries", lib);
	GL_CHECK(glp->GenQueries);
	glp->DeleteQueries = (void APIENTRY (*)(GLsizei n, const GLuint *ids)) ldg_find("glDeleteQueries", lib);
	GL_CHECK(glp->DeleteQueries);
	glp->IsQuery = (GLboolean APIENTRY (*)(GLuint id)) ldg_find("glIsQuery", lib);
	GL_CHECK(glp->IsQuery);
	glp->BeginQuery = (void APIENTRY (*)(GLenum target, GLuint id)) ldg_find("glBeginQuery", lib);
	GL_CHECK(glp->BeginQuery);
	glp->EndQuery = (void APIENTRY (*)(GLenum target)) ldg_find("glEndQuery", lib);
	GL_CHECK(glp->EndQuery);
	glp->GetQueryiv = (void APIENTRY (*)(GLenum target, GLenum pname, GLint *params)) ldg_find("glGetQueryiv", lib);
	GL_CHECK(glp->GetQueryiv);
	glp->GetQueryObjectiv = (void APIENTRY (*)(GLuint id, GLenum pname, GLint *params)) ldg_find("glGetQueryObjectiv", lib);
	GL_CHECK(glp->GetQueryObjectiv);
	glp->GetQueryObjectuiv = (void APIENTRY (*)(GLuint id, GLenum pname, GLuint *params)) ldg_find("glGetQueryObjectuiv", lib);
	GL_CHECK(glp->GetQueryObjectuiv);
	glp->BindBuffer = (void APIENTRY (*)(GLenum target, GLuint buffer)) ldg_find("glBindBuffer", lib);
	GL_CHECK(glp->BindBuffer);
	glp->DeleteBuffers = (void APIENTRY (*)(GLsizei n, const GLuint *buffers)) ldg_find("glDeleteBuffers", lib);
	GL_CHECK(glp->DeleteBuffers);
	glp->GenBuffers = (void APIENTRY (*)(GLsizei n, GLuint *buffers)) ldg_find("glGenBuffers", lib);
	GL_CHECK(glp->GenBuffers);
	glp->IsBuffer = (GLboolean APIENTRY (*)(GLuint buffer)) ldg_find("glIsBuffer", lib);
	GL_CHECK(glp->IsBuffer);
	glp->BufferData = (void APIENTRY (*)(GLenum target, GLsizeiptr size, const void *data, GLenum usage)) ldg_find("glBufferData", lib);
	GL_CHECK(glp->BufferData);
	glp->BufferSubData = (void APIENTRY (*)(GLenum target, GLintptr offset, GLsizeiptr size, const void *data)) ldg_find("glBufferSubData", lib);
	GL_CHECK(glp->BufferSubData);
	glp->GetBufferSubData = (void APIENTRY (*)(GLenum target, GLintptr offset, GLsizeiptr size, void *data)) ldg_find("glGetBufferSubData", lib);
	GL_CHECK(glp->GetBufferSubData);
	glp->MapBuffer = (void * APIENTRY (*)(GLenum target, GLenum access)) ldg_find("glMapBuffer", lib);
	GL_CHECK(glp->MapBuffer);
	glp->UnmapBuffer = (GLboolean APIENTRY (*)(GLenum target)) ldg_find("glUnmapBuffer", lib);
	GL_CHECK(glp->UnmapBuffer);
	glp->GetBufferParameteriv = (void APIENTRY (*)(GLenum target, GLenum pname, GLint *params)) ldg_find("glGetBufferParameteriv", lib);
	GL_CHECK(glp->GetBufferParameteriv);
	glp->GetBufferPointerv = (void APIENTRY (*)(GLenum target, GLenum pname, void * *params)) ldg_find("glGetBufferPointerv", lib);
	GL_CHECK(glp->GetBufferPointerv);
	glp->ActiveTextureARB = (void APIENTRY (*)(GLenum texture)) ldg_find("glActiveTextureARB", lib);
	GL_CHECK(glp->ActiveTextureARB);
	glp->ClientActiveTextureARB = (void APIENTRY (*)(GLenum texture)) ldg_find("glClientActiveTextureARB", lib);
	GL_CHECK(glp->ClientActiveTextureARB);
	glp->MultiTexCoord1dARB = (void APIENTRY (*)(GLenum target, GLdouble s)) ldg_find("glMultiTexCoord1dARB", lib);
	GL_CHECK(glp->MultiTexCoord1dARB);
	glp->MultiTexCoord1dvARB = (void APIENTRY (*)(GLenum target, const GLdouble *v)) ldg_find("glMultiTexCoord1dvARB", lib);
	GL_CHECK(glp->MultiTexCoord1dvARB);
	glp->MultiTexCoord1fARB = (void APIENTRY (*)(GLenum target, GLfloat s)) ldg_find("glMultiTexCoord1fARB", lib);
	GL_CHECK(glp->MultiTexCoord1fARB);
	glp->MultiTexCoord1fvARB = (void APIENTRY (*)(GLenum target, const GLfloat *v)) ldg_find("glMultiTexCoord1fvARB", lib);
	GL_CHECK(glp->MultiTexCoord1fvARB);
	glp->MultiTexCoord1iARB = (void APIENTRY (*)(GLenum target, GLint s)) ldg_find("glMultiTexCoord1iARB", lib);
	GL_CHECK(glp->MultiTexCoord1iARB);
	glp->MultiTexCoord1ivARB = (void APIENTRY (*)(GLenum target, const GLint *v)) ldg_find("glMultiTexCoord1ivARB", lib);
	GL_CHECK(glp->MultiTexCoord1ivARB);
	glp->MultiTexCoord1sARB = (void APIENTRY (*)(GLenum target, GLshort32 s)) ldg_find("glMultiTexCoord1sARB", lib);
	GL_CHECK(glp->MultiTexCoord1sARB);
	glp->MultiTexCoord1svARB = (void APIENTRY (*)(GLenum target, const GLshort *v)) ldg_find("glMultiTexCoord1svARB", lib);
	GL_CHECK(glp->MultiTexCoord1svARB);
	glp->MultiTexCoord2dARB = (void APIENTRY (*)(GLenum target, GLdouble s, GLdouble t)) ldg_find("glMultiTexCoord2dARB", lib);
	GL_CHECK(glp->MultiTexCoord2dARB);
	glp->MultiTexCoord2dvARB = (void APIENTRY (*)(GLenum target, const GLdouble *v)) ldg_find("glMultiTexCoord2dvARB", lib);
	GL_CHECK(glp->MultiTexCoord2dvARB);
	glp->MultiTexCoord2fARB = (void APIENTRY (*)(GLenum target, GLfloat s, GLfloat t)) ldg_find("glMultiTexCoord2fARB", lib);
	GL_CHECK(glp->MultiTexCoord2fARB);
	glp->MultiTexCoord2fvARB = (void APIENTRY (*)(GLenum target, const GLfloat *v)) ldg_find("glMultiTexCoord2fvARB", lib);
	GL_CHECK(glp->MultiTexCoord2fvARB);
	glp->MultiTexCoord2iARB = (void APIENTRY (*)(GLenum target, GLint s, GLint t)) ldg_find("glMultiTexCoord2iARB", lib);
	GL_CHECK(glp->MultiTexCoord2iARB);
	glp->MultiTexCoord2ivARB = (void APIENTRY (*)(GLenum target, const GLint *v)) ldg_find("glMultiTexCoord2ivARB", lib);
	GL_CHECK(glp->MultiTexCoord2ivARB);
	glp->MultiTexCoord2sARB = (void APIENTRY (*)(GLenum target, GLshort32 s, GLshort32 t)) ldg_find("glMultiTexCoord2sARB", lib);
	GL_CHECK(glp->MultiTexCoord2sARB);
	glp->MultiTexCoord2svARB = (void APIENTRY (*)(GLenum target, const GLshort *v)) ldg_find("glMultiTexCoord2svARB", lib);
	GL_CHECK(glp->MultiTexCoord2svARB);
	glp->MultiTexCoord3dARB = (void APIENTRY (*)(GLenum target, GLdouble s, GLdouble t, GLdouble r)) ldg_find("glMultiTexCoord3dARB", lib);
	GL_CHECK(glp->MultiTexCoord3dARB);
	glp->MultiTexCoord3dvARB = (void APIENTRY (*)(GLenum target, const GLdouble *v)) ldg_find("glMultiTexCoord3dvARB", lib);
	GL_CHECK(glp->MultiTexCoord3dvARB);
	glp->MultiTexCoord3fARB = (void APIENTRY (*)(GLenum target, GLfloat s, GLfloat t, GLfloat r)) ldg_find("glMultiTexCoord3fARB", lib);
	GL_CHECK(glp->MultiTexCoord3fARB);
	glp->MultiTexCoord3fvARB = (void APIENTRY (*)(GLenum target, const GLfloat *v)) ldg_find("glMultiTexCoord3fvARB", lib);
	GL_CHECK(glp->MultiTexCoord3fvARB);
	glp->MultiTexCoord3iARB = (void APIENTRY (*)(GLenum target, GLint s, GLint t, GLint r)) ldg_find("glMultiTexCoord3iARB", lib);
	GL_CHECK(glp->MultiTexCoord3iARB);
	glp->MultiTexCoord3ivARB = (void APIENTRY (*)(GLenum target, const GLint *v)) ldg_find("glMultiTexCoord3ivARB", lib);
	GL_CHECK(glp->MultiTexCoord3ivARB);
	glp->MultiTexCoord3sARB = (void APIENTRY (*)(GLenum target, GLshort32 s, GLshort32 t, GLshort32 r)) ldg_find("glMultiTexCoord3sARB", lib);
	GL_CHECK(glp->MultiTexCoord3sARB);
	glp->MultiTexCoord3svARB = (void APIENTRY (*)(GLenum target, const GLshort *v)) ldg_find("glMultiTexCoord3svARB", lib);
	GL_CHECK(glp->MultiTexCoord3svARB);
	glp->MultiTexCoord4dARB = (void APIENTRY (*)(GLenum target, GLdouble s, GLdouble t, GLdouble r, GLdouble q)) ldg_find("glMultiTexCoord4dARB", lib);
	GL_CHECK(glp->MultiTexCoord4dARB);
	glp->MultiTexCoord4dvARB = (void APIENTRY (*)(GLenum target, const GLdouble *v)) ldg_find("glMultiTexCoord4dvARB", lib);
	GL_CHECK(glp->MultiTexCoord4dvARB);
	glp->MultiTexCoord4fARB = (void APIENTRY (*)(GLenum target, GLfloat s, GLfloat t, GLfloat r, GLfloat q)) ldg_find("glMultiTexCoord4fARB", lib);
	GL_CHECK(glp->MultiTexCoord4fARB);
	glp->MultiTexCoord4fvARB = (void APIENTRY (*)(GLenum target, const GLfloat *v)) ldg_find("glMultiTexCoord4fvARB", lib);
	GL_CHECK(glp->MultiTexCoord4fvARB);
	glp->MultiTexCoord4iARB = (void APIENTRY (*)(GLenum target, GLint s, GLint t, GLint r, GLint q)) ldg_find("glMultiTexCoord4iARB", lib);
	GL_CHECK(glp->MultiTexCoord4iARB);
	glp->MultiTexCoord4ivARB = (void APIENTRY (*)(GLenum target, const GLint *v)) ldg_find("glMultiTexCoord4ivARB", lib);
	GL_CHECK(glp->MultiTexCoord4ivARB);
	glp->MultiTexCoord4sARB = (void APIENTRY (*)(GLenum target, GLshort32 s, GLshort32 t, GLshort32 r, GLshort32 q)) ldg_find("glMultiTexCoord4sARB", lib);
	GL_CHECK(glp->MultiTexCoord4sARB);
	glp->MultiTexCoord4svARB = (void APIENTRY (*)(GLenum target, const GLshort *v)) ldg_find("glMultiTexCoord4svARB", lib);
	GL_CHECK(glp->MultiTexCoord4svARB);
	glp->LoadTransposeMatrixfARB = (void APIENTRY (*)(const GLfloat *m)) ldg_find("glLoadTransposeMatrixfARB", lib);
	GL_CHECK(glp->LoadTransposeMatrixfARB);
	glp->LoadTransposeMatrixdARB = (void APIENTRY (*)(const GLdouble *m)) ldg_find("glLoadTransposeMatrixdARB", lib);
	GL_CHECK(glp->LoadTransposeMatrixdARB);
	glp->MultTransposeMatrixfARB = (void APIENTRY (*)(const GLfloat *m)) ldg_find("glMultTransposeMatrixfARB", lib);
	GL_CHECK(glp->MultTransposeMatrixfARB);
	glp->MultTransposeMatrixdARB = (void APIENTRY (*)(const GLdouble *m)) ldg_find("glMultTransposeMatrixdARB", lib);
	GL_CHECK(glp->MultTransposeMatrixdARB);
	glp->SampleCoverageARB = (void APIENTRY (*)(GLfloat value, GLboolean32 invert)) ldg_find("glSampleCoverageARB", lib);
	GL_CHECK(glp->SampleCoverageARB);
	glp->CompressedTexImage3DARB = (void APIENTRY (*)(GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLsizei imageSize, const void *data)) ldg_find("glCompressedTexImage3DARB", lib);
	GL_CHECK(glp->CompressedTexImage3DARB);
	glp->CompressedTexImage2DARB = (void APIENTRY (*)(GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLint border, GLsizei imageSize, const void *data)) ldg_find("glCompressedTexImage2DARB", lib);
	GL_CHECK(glp->CompressedTexImage2DARB);
	glp->CompressedTexImage1DARB = (void APIENTRY (*)(GLenum target, GLint level, GLenum internalformat, GLsizei width, GLint border, GLsizei imageSize, const void *data)) ldg_find("glCompressedTexImage1DARB", lib);
	GL_CHECK(glp->CompressedTexImage1DARB);
	glp->CompressedTexSubImage3DARB = (void APIENTRY (*)(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLsizei imageSize, const void *data)) ldg_find("glCompressedTexSubImage3DARB", lib);
	GL_CHECK(glp->CompressedTexSubImage3DARB);
	glp->CompressedTexSubImage2DARB = (void APIENTRY (*)(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLsizei imageSize, const void *data)) ldg_find("glCompressedTexSubImage2DARB", lib);
	GL_CHECK(glp->CompressedTexSubImage2DARB);
	glp->CompressedTexSubImage1DARB = (void APIENTRY (*)(GLenum target, GLint level, GLint xoffset, GLsizei width, GLenum format, GLsizei imageSize, const void *data)) ldg_find("glCompressedTexSubImage1DARB", lib);
	GL_CHECK(glp->CompressedTexSubImage1DARB);
	glp->GetCompressedTexImageARB = (void APIENTRY (*)(GLenum target, GLint level, void *img)) ldg_find("glGetCompressedTexImageARB", lib);
	GL_CHECK(glp->GetCompressedTexImageARB);
	glp->PointParameterfARB = (void APIENTRY (*)(GLenum pname, GLfloat param)) ldg_find("glPointParameterfARB", lib);
	GL_CHECK(glp->PointParameterfARB);
	glp->PointParameterfvARB = (void APIENTRY (*)(GLenum pname, const GLfloat *params)) ldg_find("glPointParameterfvARB", lib);
	GL_CHECK(glp->PointParameterfvARB);
	glp->WeightbvARB = (void APIENTRY (*)(GLint size, const GLbyte *weights)) ldg_find("glWeightbvARB", lib);
	GL_CHECK(glp->WeightbvARB);
	glp->WeightsvARB = (void APIENTRY (*)(GLint size, const GLshort *weights)) ldg_find("glWeightsvARB", lib);
	GL_CHECK(glp->WeightsvARB);
	glp->WeightivARB = (void APIENTRY (*)(GLint size, const GLint *weights)) ldg_find("glWeightivARB", lib);
	GL_CHECK(glp->WeightivARB);
	glp->WeightfvARB = (void APIENTRY (*)(GLint size, const GLfloat *weights)) ldg_find("glWeightfvARB", lib);
	GL_CHECK(glp->WeightfvARB);
	glp->WeightdvARB = (void APIENTRY (*)(GLint size, const GLdouble *weights)) ldg_find("glWeightdvARB", lib);
	GL_CHECK(glp->WeightdvARB);
	glp->WeightubvARB = (void APIENTRY (*)(GLint size, const GLubyte *weights)) ldg_find("glWeightubvARB", lib);
	GL_CHECK(glp->WeightubvARB);
	glp->WeightusvARB = (void APIENTRY (*)(GLint size, const GLushort *weights)) ldg_find("glWeightusvARB", lib);
	GL_CHECK(glp->WeightusvARB);
	glp->WeightuivARB = (void APIENTRY (*)(GLint size, const GLuint *weights)) ldg_find("glWeightuivARB", lib);
	GL_CHECK(glp->WeightuivARB);
	glp->WeightPointerARB = (void APIENTRY (*)(GLint size, GLenum type, GLsizei stride, const void *pointer)) ldg_find("glWeightPointerARB", lib);
	GL_CHECK(glp->WeightPointerARB);
	glp->VertexBlendARB = (void APIENTRY (*)(GLint count)) ldg_find("glVertexBlendARB", lib);
	GL_CHECK(glp->VertexBlendARB);
	glp->CurrentPaletteMatrixARB = (void APIENTRY (*)(GLint index)) ldg_find("glCurrentPaletteMatrixARB", lib);
	GL_CHECK(glp->CurrentPaletteMatrixARB);
	glp->MatrixIndexubvARB = (void APIENTRY (*)(GLint size, const GLubyte *indices)) ldg_find("glMatrixIndexubvARB", lib);
	GL_CHECK(glp->MatrixIndexubvARB);
	glp->MatrixIndexusvARB = (void APIENTRY (*)(GLint size, const GLushort *indices)) ldg_find("glMatrixIndexusvARB", lib);
	GL_CHECK(glp->MatrixIndexusvARB);
	glp->MatrixIndexuivARB = (void APIENTRY (*)(GLint size, const GLuint *indices)) ldg_find("glMatrixIndexuivARB", lib);
	GL_CHECK(glp->MatrixIndexuivARB);
	glp->MatrixIndexPointerARB = (void APIENTRY (*)(GLint size, GLenum type, GLsizei stride, const void *pointer)) ldg_find("glMatrixIndexPointerARB", lib);
	GL_CHECK(glp->MatrixIndexPointerARB);
	glp->WindowPos2dARB = (void APIENTRY (*)(GLdouble x, GLdouble y)) ldg_find("glWindowPos2dARB", lib);
	GL_CHECK(glp->WindowPos2dARB);
	glp->WindowPos2dvARB = (void APIENTRY (*)(const GLdouble *v)) ldg_find("glWindowPos2dvARB", lib);
	GL_CHECK(glp->WindowPos2dvARB);
	glp->WindowPos2fARB = (void APIENTRY (*)(GLfloat x, GLfloat y)) ldg_find("glWindowPos2fARB", lib);
	GL_CHECK(glp->WindowPos2fARB);
	glp->WindowPos2fvARB = (void APIENTRY (*)(const GLfloat *v)) ldg_find("glWindowPos2fvARB", lib);
	GL_CHECK(glp->WindowPos2fvARB);
	glp->WindowPos2iARB = (void APIENTRY (*)(GLint x, GLint y)) ldg_find("glWindowPos2iARB", lib);
	GL_CHECK(glp->WindowPos2iARB);
	glp->WindowPos2ivARB = (void APIENTRY (*)(const GLint *v)) ldg_find("glWindowPos2ivARB", lib);
	GL_CHECK(glp->WindowPos2ivARB);
	glp->WindowPos2sARB = (void APIENTRY (*)(GLshort32 x, GLshort32 y)) ldg_find("glWindowPos2sARB", lib);
	GL_CHECK(glp->WindowPos2sARB);
	glp->WindowPos2svARB = (void APIENTRY (*)(const GLshort *v)) ldg_find("glWindowPos2svARB", lib);
	GL_CHECK(glp->WindowPos2svARB);
	glp->WindowPos3dARB = (void APIENTRY (*)(GLdouble x, GLdouble y, GLdouble z)) ldg_find("glWindowPos3dARB", lib);
	GL_CHECK(glp->WindowPos3dARB);
	glp->WindowPos3dvARB = (void APIENTRY (*)(const GLdouble *v)) ldg_find("glWindowPos3dvARB", lib);
	GL_CHECK(glp->WindowPos3dvARB);
	glp->WindowPos3fARB = (void APIENTRY (*)(GLfloat x, GLfloat y, GLfloat z)) ldg_find("glWindowPos3fARB", lib);
	GL_CHECK(glp->WindowPos3fARB);
	glp->WindowPos3fvARB = (void APIENTRY (*)(const GLfloat *v)) ldg_find("glWindowPos3fvARB", lib);
	GL_CHECK(glp->WindowPos3fvARB);
	glp->WindowPos3iARB = (void APIENTRY (*)(GLint x, GLint y, GLint z)) ldg_find("glWindowPos3iARB", lib);
	GL_CHECK(glp->WindowPos3iARB);
	glp->WindowPos3ivARB = (void APIENTRY (*)(const GLint *v)) ldg_find("glWindowPos3ivARB", lib);
	GL_CHECK(glp->WindowPos3ivARB);
	glp->WindowPos3sARB = (void APIENTRY (*)(GLshort32 x, GLshort32 y, GLshort32 z)) ldg_find("glWindowPos3sARB", lib);
	GL_CHECK(glp->WindowPos3sARB);
	glp->WindowPos3svARB = (void APIENTRY (*)(const GLshort *v)) ldg_find("glWindowPos3svARB", lib);
	GL_CHECK(glp->WindowPos3svARB);
	glp->VertexAttrib1dARB = (void APIENTRY (*)(GLuint index, GLdouble x)) ldg_find("glVertexAttrib1dARB", lib);
	GL_CHECK(glp->VertexAttrib1dARB);
	glp->VertexAttrib1dvARB = (void APIENTRY (*)(GLuint index, const GLdouble *v)) ldg_find("glVertexAttrib1dvARB", lib);
	GL_CHECK(glp->VertexAttrib1dvARB);
	glp->VertexAttrib1fARB = (void APIENTRY (*)(GLuint index, GLfloat x)) ldg_find("glVertexAttrib1fARB", lib);
	GL_CHECK(glp->VertexAttrib1fARB);
	glp->VertexAttrib1fvARB = (void APIENTRY (*)(GLuint index, const GLfloat *v)) ldg_find("glVertexAttrib1fvARB", lib);
	GL_CHECK(glp->VertexAttrib1fvARB);
	glp->VertexAttrib1sARB = (void APIENTRY (*)(GLuint index, GLshort32 x)) ldg_find("glVertexAttrib1sARB", lib);
	GL_CHECK(glp->VertexAttrib1sARB);
	glp->VertexAttrib1svARB = (void APIENTRY (*)(GLuint index, const GLshort *v)) ldg_find("glVertexAttrib1svARB", lib);
	GL_CHECK(glp->VertexAttrib1svARB);
	glp->VertexAttrib2dARB = (void APIENTRY (*)(GLuint index, GLdouble x, GLdouble y)) ldg_find("glVertexAttrib2dARB", lib);
	GL_CHECK(glp->VertexAttrib2dARB);
	glp->VertexAttrib2dvARB = (void APIENTRY (*)(GLuint index, const GLdouble *v)) ldg_find("glVertexAttrib2dvARB", lib);
	GL_CHECK(glp->VertexAttrib2dvARB);
	glp->VertexAttrib2fARB = (void APIENTRY (*)(GLuint index, GLfloat x, GLfloat y)) ldg_find("glVertexAttrib2fARB", lib);
	GL_CHECK(glp->VertexAttrib2fARB);
	glp->VertexAttrib2fvARB = (void APIENTRY (*)(GLuint index, const GLfloat *v)) ldg_find("glVertexAttrib2fvARB", lib);
	GL_CHECK(glp->VertexAttrib2fvARB);
	glp->VertexAttrib2sARB = (void APIENTRY (*)(GLuint index, GLshort32 x, GLshort32 y)) ldg_find("glVertexAttrib2sARB", lib);
	GL_CHECK(glp->VertexAttrib2sARB);
	glp->VertexAttrib2svARB = (void APIENTRY (*)(GLuint index, const GLshort *v)) ldg_find("glVertexAttrib2svARB", lib);
	GL_CHECK(glp->VertexAttrib2svARB);
	glp->VertexAttrib3dARB = (void APIENTRY (*)(GLuint index, GLdouble x, GLdouble y, GLdouble z)) ldg_find("glVertexAttrib3dARB", lib);
	GL_CHECK(glp->VertexAttrib3dARB);
	glp->VertexAttrib3dvARB = (void APIENTRY (*)(GLuint index, const GLdouble *v)) ldg_find("glVertexAttrib3dvARB", lib);
	GL_CHECK(glp->VertexAttrib3dvARB);
	glp->VertexAttrib3fARB = (void APIENTRY (*)(GLuint index, GLfloat x, GLfloat y, GLfloat z)) ldg_find("glVertexAttrib3fARB", lib);
	GL_CHECK(glp->VertexAttrib3fARB);
	glp->VertexAttrib3fvARB = (void APIENTRY (*)(GLuint index, const GLfloat *v)) ldg_find("glVertexAttrib3fvARB", lib);
	GL_CHECK(glp->VertexAttrib3fvARB);
	glp->VertexAttrib3sARB = (void APIENTRY (*)(GLuint index, GLshort32 x, GLshort32 y, GLshort32 z)) ldg_find("glVertexAttrib3sARB", lib);
	GL_CHECK(glp->VertexAttrib3sARB);
	glp->VertexAttrib3svARB = (void APIENTRY (*)(GLuint index, const GLshort *v)) ldg_find("glVertexAttrib3svARB", lib);
	GL_CHECK(glp->VertexAttrib3svARB);
	glp->VertexAttrib4NbvARB = (void APIENTRY (*)(GLuint index, const GLbyte *v)) ldg_find("glVertexAttrib4NbvARB", lib);
	GL_CHECK(glp->VertexAttrib4NbvARB);
	glp->VertexAttrib4NivARB = (void APIENTRY (*)(GLuint index, const GLint *v)) ldg_find("glVertexAttrib4NivARB", lib);
	GL_CHECK(glp->VertexAttrib4NivARB);
	glp->VertexAttrib4NsvARB = (void APIENTRY (*)(GLuint index, const GLshort *v)) ldg_find("glVertexAttrib4NsvARB", lib);
	GL_CHECK(glp->VertexAttrib4NsvARB);
	glp->VertexAttrib4NubARB = (void APIENTRY (*)(GLuint index, GLubyte32 x, GLubyte32 y, GLubyte32 z, GLubyte32 w)) ldg_find("glVertexAttrib4NubARB", lib);
	GL_CHECK(glp->VertexAttrib4NubARB);
	glp->VertexAttrib4NubvARB = (void APIENTRY (*)(GLuint index, const GLubyte *v)) ldg_find("glVertexAttrib4NubvARB", lib);
	GL_CHECK(glp->VertexAttrib4NubvARB);
	glp->VertexAttrib4NuivARB = (void APIENTRY (*)(GLuint index, const GLuint *v)) ldg_find("glVertexAttrib4NuivARB", lib);
	GL_CHECK(glp->VertexAttrib4NuivARB);
	glp->VertexAttrib4NusvARB = (void APIENTRY (*)(GLuint index, const GLushort *v)) ldg_find("glVertexAttrib4NusvARB", lib);
	GL_CHECK(glp->VertexAttrib4NusvARB);
	glp->VertexAttrib4bvARB = (void APIENTRY (*)(GLuint index, const GLbyte *v)) ldg_find("glVertexAttrib4bvARB", lib);
	GL_CHECK(glp->VertexAttrib4bvARB);
	glp->VertexAttrib4dARB = (void APIENTRY (*)(GLuint index, GLdouble x, GLdouble y, GLdouble z, GLdouble w)) ldg_find("glVertexAttrib4dARB", lib);
	GL_CHECK(glp->VertexAttrib4dARB);
	glp->VertexAttrib4dvARB = (void APIENTRY (*)(GLuint index, const GLdouble *v)) ldg_find("glVertexAttrib4dvARB", lib);
	GL_CHECK(glp->VertexAttrib4dvARB);
	glp->VertexAttrib4fARB = (void APIENTRY (*)(GLuint index, GLfloat x, GLfloat y, GLfloat z, GLfloat w)) ldg_find("glVertexAttrib4fARB", lib);
	GL_CHECK(glp->VertexAttrib4fARB);
	glp->VertexAttrib4fvARB = (void APIENTRY (*)(GLuint index, const GLfloat *v)) ldg_find("glVertexAttrib4fvARB", lib);
	GL_CHECK(glp->VertexAttrib4fvARB);
	glp->VertexAttrib4ivARB = (void APIENTRY (*)(GLuint index, const GLint *v)) ldg_find("glVertexAttrib4ivARB", lib);
	GL_CHECK(glp->VertexAttrib4ivARB);
	glp->VertexAttrib4sARB = (void APIENTRY (*)(GLuint index, GLshort32 x, GLshort32 y, GLshort32 z, GLshort32 w)) ldg_find("glVertexAttrib4sARB", lib);
	GL_CHECK(glp->VertexAttrib4sARB);
	glp->VertexAttrib4svARB = (void APIENTRY (*)(GLuint index, const GLshort *v)) ldg_find("glVertexAttrib4svARB", lib);
	GL_CHECK(glp->VertexAttrib4svARB);
	glp->VertexAttrib4ubvARB = (void APIENTRY (*)(GLuint index, const GLubyte *v)) ldg_find("glVertexAttrib4ubvARB", lib);
	GL_CHECK(glp->VertexAttrib4ubvARB);
	glp->VertexAttrib4uivARB = (void APIENTRY (*)(GLuint index, const GLuint *v)) ldg_find("glVertexAttrib4uivARB", lib);
	GL_CHECK(glp->VertexAttrib4uivARB);
	glp->VertexAttrib4usvARB = (void APIENTRY (*)(GLuint index, const GLushort *v)) ldg_find("glVertexAttrib4usvARB", lib);
	GL_CHECK(glp->VertexAttrib4usvARB);
	glp->VertexAttribPointerARB = (void APIENTRY (*)(GLuint index, GLint size, GLenum type, GLboolean32 normalized, GLsizei stride, const void *pointer)) ldg_find("glVertexAttribPointerARB", lib);
	GL_CHECK(glp->VertexAttribPointerARB);
	glp->EnableVertexAttribArrayARB = (void APIENTRY (*)(GLuint index)) ldg_find("glEnableVertexAttribArrayARB", lib);
	GL_CHECK(glp->EnableVertexAttribArrayARB);
	glp->DisableVertexAttribArrayARB = (void APIENTRY (*)(GLuint index)) ldg_find("glDisableVertexAttribArrayARB", lib);
	GL_CHECK(glp->DisableVertexAttribArrayARB);
	glp->ProgramStringARB = (void APIENTRY (*)(GLenum target, GLenum format, GLsizei len, const void *string)) ldg_find("glProgramStringARB", lib);
	GL_CHECK(glp->ProgramStringARB);
	glp->BindProgramARB = (void APIENTRY (*)(GLenum target, GLuint program)) ldg_find("glBindProgramARB", lib);
	GL_CHECK(glp->BindProgramARB);
	glp->DeleteProgramsARB = (void APIENTRY (*)(GLsizei n, const GLuint *programs)) ldg_find("glDeleteProgramsARB", lib);
	GL_CHECK(glp->DeleteProgramsARB);
	glp->GenProgramsARB = (void APIENTRY (*)(GLsizei n, GLuint *programs)) ldg_find("glGenProgramsARB", lib);
	GL_CHECK(glp->GenProgramsARB);
	glp->ProgramEnvParameter4dARB = (void APIENTRY (*)(GLenum target, GLuint index, GLdouble x, GLdouble y, GLdouble z, GLdouble w)) ldg_find("glProgramEnvParameter4dARB", lib);
	GL_CHECK(glp->ProgramEnvParameter4dARB);
	glp->ProgramEnvParameter4dvARB = (void APIENTRY (*)(GLenum target, GLuint index, const GLdouble *params)) ldg_find("glProgramEnvParameter4dvARB", lib);
	GL_CHECK(glp->ProgramEnvParameter4dvARB);
	glp->ProgramEnvParameter4fARB = (void APIENTRY (*)(GLenum target, GLuint index, GLfloat x, GLfloat y, GLfloat z, GLfloat w)) ldg_find("glProgramEnvParameter4fARB", lib);
	GL_CHECK(glp->ProgramEnvParameter4fARB);
	glp->ProgramEnvParameter4fvARB = (void APIENTRY (*)(GLenum target, GLuint index, const GLfloat *params)) ldg_find("glProgramEnvParameter4fvARB", lib);
	GL_CHECK(glp->ProgramEnvParameter4fvARB);
	glp->ProgramLocalParameter4dARB = (void APIENTRY (*)(GLenum target, GLuint index, GLdouble x, GLdouble y, GLdouble z, GLdouble w)) ldg_find("glProgramLocalParameter4dARB", lib);
	GL_CHECK(glp->ProgramLocalParameter4dARB);
	glp->ProgramLocalParameter4dvARB = (void APIENTRY (*)(GLenum target, GLuint index, const GLdouble *params)) ldg_find("glProgramLocalParameter4dvARB", lib);
	GL_CHECK(glp->ProgramLocalParameter4dvARB);
	glp->ProgramLocalParameter4fARB = (void APIENTRY (*)(GLenum target, GLuint index, GLfloat x, GLfloat y, GLfloat z, GLfloat w)) ldg_find("glProgramLocalParameter4fARB", lib);
	GL_CHECK(glp->ProgramLocalParameter4fARB);
	glp->ProgramLocalParameter4fvARB = (void APIENTRY (*)(GLenum target, GLuint index, const GLfloat *params)) ldg_find("glProgramLocalParameter4fvARB", lib);
	GL_CHECK(glp->ProgramLocalParameter4fvARB);
	glp->GetProgramEnvParameterdvARB = (void APIENTRY (*)(GLenum target, GLuint index, GLdouble *params)) ldg_find("glGetProgramEnvParameterdvARB", lib);
	GL_CHECK(glp->GetProgramEnvParameterdvARB);
	glp->GetProgramEnvParameterfvARB = (void APIENTRY (*)(GLenum target, GLuint index, GLfloat *params)) ldg_find("glGetProgramEnvParameterfvARB", lib);
	GL_CHECK(glp->GetProgramEnvParameterfvARB);
	glp->GetProgramLocalParameterdvARB = (void APIENTRY (*)(GLenum target, GLuint index, GLdouble *params)) ldg_find("glGetProgramLocalParameterdvARB", lib);
	GL_CHECK(glp->GetProgramLocalParameterdvARB);
	glp->GetProgramLocalParameterfvARB = (void APIENTRY (*)(GLenum target, GLuint index, GLfloat *params)) ldg_find("glGetProgramLocalParameterfvARB", lib);
	GL_CHECK(glp->GetProgramLocalParameterfvARB);
	glp->GetProgramivARB = (void APIENTRY (*)(GLenum target, GLenum pname, GLint *params)) ldg_find("glGetProgramivARB", lib);
	GL_CHECK(glp->GetProgramivARB);
	glp->GetProgramStringARB = (void APIENTRY (*)(GLenum target, GLenum pname, void *string)) ldg_find("glGetProgramStringARB", lib);
	GL_CHECK(glp->GetProgramStringARB);
	glp->GetVertexAttribdvARB = (void APIENTRY (*)(GLuint index, GLenum pname, GLdouble *params)) ldg_find("glGetVertexAttribdvARB", lib);
	GL_CHECK(glp->GetVertexAttribdvARB);
	glp->GetVertexAttribfvARB = (void APIENTRY (*)(GLuint index, GLenum pname, GLfloat *params)) ldg_find("glGetVertexAttribfvARB", lib);
	GL_CHECK(glp->GetVertexAttribfvARB);
	glp->GetVertexAttribivARB = (void APIENTRY (*)(GLuint index, GLenum pname, GLint *params)) ldg_find("glGetVertexAttribivARB", lib);
	GL_CHECK(glp->GetVertexAttribivARB);
	glp->GetVertexAttribPointervARB = (void APIENTRY (*)(GLuint index, GLenum pname, void * *pointer)) ldg_find("glGetVertexAttribPointervARB", lib);
	GL_CHECK(glp->GetVertexAttribPointervARB);
	glp->IsProgramARB = (GLboolean APIENTRY (*)(GLuint program)) ldg_find("glIsProgramARB", lib);
	GL_CHECK(glp->IsProgramARB);
	glp->BindBufferARB = (void APIENTRY (*)(GLenum target, GLuint buffer)) ldg_find("glBindBufferARB", lib);
	GL_CHECK(glp->BindBufferARB);
	glp->DeleteBuffersARB = (void APIENTRY (*)(GLsizei n, const GLuint *buffers)) ldg_find("glDeleteBuffersARB", lib);
	GL_CHECK(glp->DeleteBuffersARB);
	glp->GenBuffersARB = (void APIENTRY (*)(GLsizei n, GLuint *buffers)) ldg_find("glGenBuffersARB", lib);
	GL_CHECK(glp->GenBuffersARB);
	glp->IsBufferARB = (GLboolean APIENTRY (*)(GLuint buffer)) ldg_find("glIsBufferARB", lib);
	GL_CHECK(glp->IsBufferARB);
	glp->BufferDataARB = (void APIENTRY (*)(GLenum target, GLsizeiptrARB size, const void *data, GLenum usage)) ldg_find("glBufferDataARB", lib);
	GL_CHECK(glp->BufferDataARB);
	glp->BufferSubDataARB = (void APIENTRY (*)(GLenum target, GLintptrARB offset, GLsizeiptrARB size, const void *data)) ldg_find("glBufferSubDataARB", lib);
	GL_CHECK(glp->BufferSubDataARB);
	glp->GetBufferSubDataARB = (void APIENTRY (*)(GLenum target, GLintptrARB offset, GLsizeiptrARB size, void *data)) ldg_find("glGetBufferSubDataARB", lib);
	GL_CHECK(glp->GetBufferSubDataARB);
	glp->MapBufferARB = (void * APIENTRY (*)(GLenum target, GLenum access)) ldg_find("glMapBufferARB", lib);
	GL_CHECK(glp->MapBufferARB);
	glp->UnmapBufferARB = (GLboolean APIENTRY (*)(GLenum target)) ldg_find("glUnmapBufferARB", lib);
	GL_CHECK(glp->UnmapBufferARB);
	glp->GetBufferParameterivARB = (void APIENTRY (*)(GLenum target, GLenum pname, GLint *params)) ldg_find("glGetBufferParameterivARB", lib);
	GL_CHECK(glp->GetBufferParameterivARB);
	glp->GetBufferPointervARB = (void APIENTRY (*)(GLenum target, GLenum pname, void * *params)) ldg_find("glGetBufferPointervARB", lib);
	GL_CHECK(glp->GetBufferPointervARB);
	glp->GenQueriesARB = (void APIENTRY (*)(GLsizei n, GLuint *ids)) ldg_find("glGenQueriesARB", lib);
	GL_CHECK(glp->GenQueriesARB);
	glp->DeleteQueriesARB = (void APIENTRY (*)(GLsizei n, const GLuint *ids)) ldg_find("glDeleteQueriesARB", lib);
	GL_CHECK(glp->DeleteQueriesARB);
	glp->IsQueryARB = (GLboolean APIENTRY (*)(GLuint id)) ldg_find("glIsQueryARB", lib);
	GL_CHECK(glp->IsQueryARB);
	glp->BeginQueryARB = (void APIENTRY (*)(GLenum target, GLuint id)) ldg_find("glBeginQueryARB", lib);
	GL_CHECK(glp->BeginQueryARB);
	glp->EndQueryARB = (void APIENTRY (*)(GLenum target)) ldg_find("glEndQueryARB", lib);
	GL_CHECK(glp->EndQueryARB);
	glp->GetQueryivARB = (void APIENTRY (*)(GLenum target, GLenum pname, GLint *params)) ldg_find("glGetQueryivARB", lib);
	GL_CHECK(glp->GetQueryivARB);
	glp->GetQueryObjectivARB = (void APIENTRY (*)(GLuint id, GLenum pname, GLint *params)) ldg_find("glGetQueryObjectivARB", lib);
	GL_CHECK(glp->GetQueryObjectivARB);
	glp->GetQueryObjectuivARB = (void APIENTRY (*)(GLuint id, GLenum pname, GLuint *params)) ldg_find("glGetQueryObjectuivARB", lib);
	GL_CHECK(glp->GetQueryObjectuivARB);
	glp->DeleteObjectARB = (void APIENTRY (*)(GLhandleARB obj)) ldg_find("glDeleteObjectARB", lib);
	GL_CHECK(glp->DeleteObjectARB);
	glp->GetHandleARB = (GLhandleARB APIENTRY (*)(GLenum pname)) ldg_find("glGetHandleARB", lib);
	GL_CHECK(glp->GetHandleARB);
	glp->DetachObjectARB = (void APIENTRY (*)(GLhandleARB containerObj, GLhandleARB attachedObj)) ldg_find("glDetachObjectARB", lib);
	GL_CHECK(glp->DetachObjectARB);
	glp->CreateShaderObjectARB = (GLhandleARB APIENTRY (*)(GLenum shaderType)) ldg_find("glCreateShaderObjectARB", lib);
	GL_CHECK(glp->CreateShaderObjectARB);
	glp->ShaderSourceARB = (void APIENTRY (*)(GLhandleARB shaderObj, GLsizei count, const GLcharARB * *string, const GLint *length)) ldg_find("glShaderSourceARB", lib);
	GL_CHECK(glp->ShaderSourceARB);
	glp->CompileShaderARB = (void APIENTRY (*)(GLhandleARB shaderObj)) ldg_find("glCompileShaderARB", lib);
	GL_CHECK(glp->CompileShaderARB);
	glp->CreateProgramObjectARB = (GLhandleARB APIENTRY (*)(void)) ldg_find("glCreateProgramObjectARB", lib);
	GL_CHECK(glp->CreateProgramObjectARB);
	glp->AttachObjectARB = (void APIENTRY (*)(GLhandleARB containerObj, GLhandleARB obj)) ldg_find("glAttachObjectARB", lib);
	GL_CHECK(glp->AttachObjectARB);
	glp->LinkProgramARB = (void APIENTRY (*)(GLhandleARB programObj)) ldg_find("glLinkProgramARB", lib);
	GL_CHECK(glp->LinkProgramARB);
	glp->UseProgramObjectARB = (void APIENTRY (*)(GLhandleARB programObj)) ldg_find("glUseProgramObjectARB", lib);
	GL_CHECK(glp->UseProgramObjectARB);
	glp->ValidateProgramARB = (void APIENTRY (*)(GLhandleARB programObj)) ldg_find("glValidateProgramARB", lib);
	GL_CHECK(glp->ValidateProgramARB);
	glp->Uniform1fARB = (void APIENTRY (*)(GLint location, GLfloat v0)) ldg_find("glUniform1fARB", lib);
	GL_CHECK(glp->Uniform1fARB);
	glp->Uniform2fARB = (void APIENTRY (*)(GLint location, GLfloat v0, GLfloat v1)) ldg_find("glUniform2fARB", lib);
	GL_CHECK(glp->Uniform2fARB);
	glp->Uniform3fARB = (void APIENTRY (*)(GLint location, GLfloat v0, GLfloat v1, GLfloat v2)) ldg_find("glUniform3fARB", lib);
	GL_CHECK(glp->Uniform3fARB);
	glp->Uniform4fARB = (void APIENTRY (*)(GLint location, GLfloat v0, GLfloat v1, GLfloat v2, GLfloat v3)) ldg_find("glUniform4fARB", lib);
	GL_CHECK(glp->Uniform4fARB);
	glp->Uniform1iARB = (void APIENTRY (*)(GLint location, GLint v0)) ldg_find("glUniform1iARB", lib);
	GL_CHECK(glp->Uniform1iARB);
	glp->Uniform2iARB = (void APIENTRY (*)(GLint location, GLint v0, GLint v1)) ldg_find("glUniform2iARB", lib);
	GL_CHECK(glp->Uniform2iARB);
	glp->Uniform3iARB = (void APIENTRY (*)(GLint location, GLint v0, GLint v1, GLint v2)) ldg_find("glUniform3iARB", lib);
	GL_CHECK(glp->Uniform3iARB);
	glp->Uniform4iARB = (void APIENTRY (*)(GLint location, GLint v0, GLint v1, GLint v2, GLint v3)) ldg_find("glUniform4iARB", lib);
	GL_CHECK(glp->Uniform4iARB);
	glp->Uniform1fvARB = (void APIENTRY (*)(GLint location, GLsizei count, const GLfloat *value)) ldg_find("glUniform1fvARB", lib);
	GL_CHECK(glp->Uniform1fvARB);
	glp->Uniform2fvARB = (void APIENTRY (*)(GLint location, GLsizei count, const GLfloat *value)) ldg_find("glUniform2fvARB", lib);
	GL_CHECK(glp->Uniform2fvARB);
	glp->Uniform3fvARB = (void APIENTRY (*)(GLint location, GLsizei count, const GLfloat *value)) ldg_find("glUniform3fvARB", lib);
	GL_CHECK(glp->Uniform3fvARB);
	glp->Uniform4fvARB = (void APIENTRY (*)(GLint location, GLsizei count, const GLfloat *value)) ldg_find("glUniform4fvARB", lib);
	GL_CHECK(glp->Uniform4fvARB);
	glp->Uniform1ivARB = (void APIENTRY (*)(GLint location, GLsizei count, const GLint *value)) ldg_find("glUniform1ivARB", lib);
	GL_CHECK(glp->Uniform1ivARB);
	glp->Uniform2ivARB = (void APIENTRY (*)(GLint location, GLsizei count, const GLint *value)) ldg_find("glUniform2ivARB", lib);
	GL_CHECK(glp->Uniform2ivARB);
	glp->Uniform3ivARB = (void APIENTRY (*)(GLint location, GLsizei count, const GLint *value)) ldg_find("glUniform3ivARB", lib);
	GL_CHECK(glp->Uniform3ivARB);
	glp->Uniform4ivARB = (void APIENTRY (*)(GLint location, GLsizei count, const GLint *value)) ldg_find("glUniform4ivARB", lib);
	GL_CHECK(glp->Uniform4ivARB);
	glp->UniformMatrix2fvARB = (void APIENTRY (*)(GLint location, GLsizei count, GLboolean32 transpose, const GLfloat *value)) ldg_find("glUniformMatrix2fvARB", lib);
	GL_CHECK(glp->UniformMatrix2fvARB);
	glp->UniformMatrix3fvARB = (void APIENTRY (*)(GLint location, GLsizei count, GLboolean32 transpose, const GLfloat *value)) ldg_find("glUniformMatrix3fvARB", lib);
	GL_CHECK(glp->UniformMatrix3fvARB);
	glp->UniformMatrix4fvARB = (void APIENTRY (*)(GLint location, GLsizei count, GLboolean32 transpose, const GLfloat *value)) ldg_find("glUniformMatrix4fvARB", lib);
	GL_CHECK(glp->UniformMatrix4fvARB);
	glp->GetObjectParameterfvARB = (void APIENTRY (*)(GLhandleARB obj, GLenum pname, GLfloat *params)) ldg_find("glGetObjectParameterfvARB", lib);
	GL_CHECK(glp->GetObjectParameterfvARB);
	glp->GetObjectParameterivARB = (void APIENTRY (*)(GLhandleARB obj, GLenum pname, GLint *params)) ldg_find("glGetObjectParameterivARB", lib);
	GL_CHECK(glp->GetObjectParameterivARB);
	glp->GetInfoLogARB = (void APIENTRY (*)(GLhandleARB obj, GLsizei maxLength, GLsizei *length, GLcharARB *infoLog)) ldg_find("glGetInfoLogARB", lib);
	GL_CHECK(glp->GetInfoLogARB);
	glp->GetAttachedObjectsARB = (void APIENTRY (*)(GLhandleARB containerObj, GLsizei maxCount, GLsizei *count, GLhandleARB *obj)) ldg_find("glGetAttachedObjectsARB", lib);
	GL_CHECK(glp->GetAttachedObjectsARB);
	glp->GetUniformLocationARB = (GLint APIENTRY (*)(GLhandleARB programObj, const GLcharARB *name)) ldg_find("glGetUniformLocationARB", lib);
	GL_CHECK(glp->GetUniformLocationARB);
	glp->GetActiveUniformARB = (void APIENTRY (*)(GLhandleARB programObj, GLuint index, GLsizei maxLength, GLsizei *length, GLint *size, GLenum *type, GLcharARB *name)) ldg_find("glGetActiveUniformARB", lib);
	GL_CHECK(glp->GetActiveUniformARB);
	glp->GetUniformfvARB = (void APIENTRY (*)(GLhandleARB programObj, GLint location, GLfloat *params)) ldg_find("glGetUniformfvARB", lib);
	GL_CHECK(glp->GetUniformfvARB);
	glp->GetUniformivARB = (void APIENTRY (*)(GLhandleARB programObj, GLint location, GLint *params)) ldg_find("glGetUniformivARB", lib);
	GL_CHECK(glp->GetUniformivARB);
	glp->GetShaderSourceARB = (void APIENTRY (*)(GLhandleARB obj, GLsizei maxLength, GLsizei *length, GLcharARB *source)) ldg_find("glGetShaderSourceARB", lib);
	GL_CHECK(glp->GetShaderSourceARB);
	glp->BindAttribLocationARB = (void APIENTRY (*)(GLhandleARB programObj, GLuint index, const GLcharARB *name)) ldg_find("glBindAttribLocationARB", lib);
	GL_CHECK(glp->BindAttribLocationARB);
	glp->GetActiveAttribARB = (void APIENTRY (*)(GLhandleARB programObj, GLuint index, GLsizei maxLength, GLsizei *length, GLint *size, GLenum *type, GLcharARB *name)) ldg_find("glGetActiveAttribARB", lib);
	GL_CHECK(glp->GetActiveAttribARB);
	glp->GetAttribLocationARB = (GLint APIENTRY (*)(GLhandleARB programObj, const GLcharARB *name)) ldg_find("glGetAttribLocationARB", lib);
	GL_CHECK(glp->GetAttribLocationARB);
	glp->DrawBuffersARB = (void APIENTRY (*)(GLsizei n, const GLenum *bufs)) ldg_find("glDrawBuffersARB", lib);
	GL_CHECK(glp->DrawBuffersARB);
	glp->BlendColorEXT = (void APIENTRY (*)(GLfloat red, GLfloat green, GLfloat blue, GLfloat alpha)) ldg_find("glBlendColorEXT", lib);
	GL_CHECK(glp->BlendColorEXT);
	glp->PolygonOffsetEXT = (void APIENTRY (*)(GLfloat factor, GLfloat bias)) ldg_find("glPolygonOffsetEXT", lib);
	GL_CHECK(glp->PolygonOffsetEXT);
	glp->TexImage3DEXT = (void APIENTRY (*)(GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLenum format, GLenum type, const void *pixels)) ldg_find("glTexImage3DEXT", lib);
	GL_CHECK(glp->TexImage3DEXT);
	glp->TexSubImage3DEXT = (void APIENTRY (*)(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLenum type, const void *pixels)) ldg_find("glTexSubImage3DEXT", lib);
	GL_CHECK(glp->TexSubImage3DEXT);
	glp->GetTexFilterFuncSGIS = (void APIENTRY (*)(GLenum target, GLenum filter, GLfloat *weights)) ldg_find("glGetTexFilterFuncSGIS", lib);
	GL_CHECK(glp->GetTexFilterFuncSGIS);
	glp->TexFilterFuncSGIS = (void APIENTRY (*)(GLenum target, GLenum filter, GLsizei n, const GLfloat *weights)) ldg_find("glTexFilterFuncSGIS", lib);
	GL_CHECK(glp->TexFilterFuncSGIS);
	glp->TexSubImage1DEXT = (void APIENTRY (*)(GLenum target, GLint level, GLint xoffset, GLsizei width, GLenum format, GLenum type, const void *pixels)) ldg_find("glTexSubImage1DEXT", lib);
	GL_CHECK(glp->TexSubImage1DEXT);
	glp->TexSubImage2DEXT = (void APIENTRY (*)(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLenum type, const void *pixels)) ldg_find("glTexSubImage2DEXT", lib);
	GL_CHECK(glp->TexSubImage2DEXT);
	glp->CopyTexImage1DEXT = (void APIENTRY (*)(GLenum target, GLint level, GLenum internalformat, GLint x, GLint y, GLsizei width, GLint border)) ldg_find("glCopyTexImage1DEXT", lib);
	GL_CHECK(glp->CopyTexImage1DEXT);
	glp->CopyTexImage2DEXT = (void APIENTRY (*)(GLenum target, GLint level, GLenum internalformat, GLint x, GLint y, GLsizei width, GLsizei height, GLint border)) ldg_find("glCopyTexImage2DEXT", lib);
	GL_CHECK(glp->CopyTexImage2DEXT);
	glp->CopyTexSubImage1DEXT = (void APIENTRY (*)(GLenum target, GLint level, GLint xoffset, GLint x, GLint y, GLsizei width)) ldg_find("glCopyTexSubImage1DEXT", lib);
	GL_CHECK(glp->CopyTexSubImage1DEXT);
	glp->CopyTexSubImage2DEXT = (void APIENTRY (*)(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint x, GLint y, GLsizei width, GLsizei height)) ldg_find("glCopyTexSubImage2DEXT", lib);
	GL_CHECK(glp->CopyTexSubImage2DEXT);
	glp->CopyTexSubImage3DEXT = (void APIENTRY (*)(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLint x, GLint y, GLsizei width, GLsizei height)) ldg_find("glCopyTexSubImage3DEXT", lib);
	GL_CHECK(glp->CopyTexSubImage3DEXT);
	glp->GetHistogramEXT = (void APIENTRY (*)(GLenum target, GLboolean32 reset, GLenum format, GLenum type, void *values)) ldg_find("glGetHistogramEXT", lib);
	GL_CHECK(glp->GetHistogramEXT);
	glp->GetHistogramParameterfvEXT = (void APIENTRY (*)(GLenum target, GLenum pname, GLfloat *params)) ldg_find("glGetHistogramParameterfvEXT", lib);
	GL_CHECK(glp->GetHistogramParameterfvEXT);
	glp->GetHistogramParameterivEXT = (void APIENTRY (*)(GLenum target, GLenum pname, GLint *params)) ldg_find("glGetHistogramParameterivEXT", lib);
	GL_CHECK(glp->GetHistogramParameterivEXT);
	glp->GetMinmaxEXT = (void APIENTRY (*)(GLenum target, GLboolean32 reset, GLenum format, GLenum type, void *values)) ldg_find("glGetMinmaxEXT", lib);
	GL_CHECK(glp->GetMinmaxEXT);
	glp->GetMinmaxParameterfvEXT = (void APIENTRY (*)(GLenum target, GLenum pname, GLfloat *params)) ldg_find("glGetMinmaxParameterfvEXT", lib);
	GL_CHECK(glp->GetMinmaxParameterfvEXT);
	glp->GetMinmaxParameterivEXT = (void APIENTRY (*)(GLenum target, GLenum pname, GLint *params)) ldg_find("glGetMinmaxParameterivEXT", lib);
	GL_CHECK(glp->GetMinmaxParameterivEXT);
	glp->HistogramEXT = (void APIENTRY (*)(GLenum target, GLsizei width, GLenum internalformat, GLboolean32 sink)) ldg_find("glHistogramEXT", lib);
	GL_CHECK(glp->HistogramEXT);
	glp->MinmaxEXT = (void APIENTRY (*)(GLenum target, GLenum internalformat, GLboolean32 sink)) ldg_find("glMinmaxEXT", lib);
	GL_CHECK(glp->MinmaxEXT);
	glp->ResetHistogramEXT = (void APIENTRY (*)(GLenum target)) ldg_find("glResetHistogramEXT", lib);
	GL_CHECK(glp->ResetHistogramEXT);
	glp->ResetMinmaxEXT = (void APIENTRY (*)(GLenum target)) ldg_find("glResetMinmaxEXT", lib);
	GL_CHECK(glp->ResetMinmaxEXT);
	glp->ConvolutionFilter1DEXT = (void APIENTRY (*)(GLenum target, GLenum internalformat, GLsizei width, GLenum format, GLenum type, const void *image)) ldg_find("glConvolutionFilter1DEXT", lib);
	GL_CHECK(glp->ConvolutionFilter1DEXT);
	glp->ConvolutionFilter2DEXT = (void APIENTRY (*)(GLenum target, GLenum internalformat, GLsizei width, GLsizei height, GLenum format, GLenum type, const void *image)) ldg_find("glConvolutionFilter2DEXT", lib);
	GL_CHECK(glp->ConvolutionFilter2DEXT);
	glp->ConvolutionParameterfEXT = (void APIENTRY (*)(GLenum target, GLenum pname, GLfloat params)) ldg_find("glConvolutionParameterfEXT", lib);
	GL_CHECK(glp->ConvolutionParameterfEXT);
	glp->ConvolutionParameterfvEXT = (void APIENTRY (*)(GLenum target, GLenum pname, const GLfloat *params)) ldg_find("glConvolutionParameterfvEXT", lib);
	GL_CHECK(glp->ConvolutionParameterfvEXT);
	glp->ConvolutionParameteriEXT = (void APIENTRY (*)(GLenum target, GLenum pname, GLint params)) ldg_find("glConvolutionParameteriEXT", lib);
	GL_CHECK(glp->ConvolutionParameteriEXT);
	glp->ConvolutionParameterivEXT = (void APIENTRY (*)(GLenum target, GLenum pname, const GLint *params)) ldg_find("glConvolutionParameterivEXT", lib);
	GL_CHECK(glp->ConvolutionParameterivEXT);
	glp->CopyConvolutionFilter1DEXT = (void APIENTRY (*)(GLenum target, GLenum internalformat, GLint x, GLint y, GLsizei width)) ldg_find("glCopyConvolutionFilter1DEXT", lib);
	GL_CHECK(glp->CopyConvolutionFilter1DEXT);
	glp->CopyConvolutionFilter2DEXT = (void APIENTRY (*)(GLenum target, GLenum internalformat, GLint x, GLint y, GLsizei width, GLsizei height)) ldg_find("glCopyConvolutionFilter2DEXT", lib);
	GL_CHECK(glp->CopyConvolutionFilter2DEXT);
	glp->GetConvolutionFilterEXT = (void APIENTRY (*)(GLenum target, GLenum format, GLenum type, void *image)) ldg_find("glGetConvolutionFilterEXT", lib);
	GL_CHECK(glp->GetConvolutionFilterEXT);
	glp->GetConvolutionParameterfvEXT = (void APIENTRY (*)(GLenum target, GLenum pname, GLfloat *params)) ldg_find("glGetConvolutionParameterfvEXT", lib);
	GL_CHECK(glp->GetConvolutionParameterfvEXT);
	glp->GetConvolutionParameterivEXT = (void APIENTRY (*)(GLenum target, GLenum pname, GLint *params)) ldg_find("glGetConvolutionParameterivEXT", lib);
	GL_CHECK(glp->GetConvolutionParameterivEXT);
	glp->GetSeparableFilterEXT = (void APIENTRY (*)(GLenum target, GLenum format, GLenum type, void *row, void *column, void *span)) ldg_find("glGetSeparableFilterEXT", lib);
	GL_CHECK(glp->GetSeparableFilterEXT);
	glp->SeparableFilter2DEXT = (void APIENTRY (*)(GLenum target, GLenum internalformat, GLsizei width, GLsizei height, GLenum format, GLenum type, const void *row, const void *column)) ldg_find("glSeparableFilter2DEXT", lib);
	GL_CHECK(glp->SeparableFilter2DEXT);
	glp->ColorTableSGI = (void APIENTRY (*)(GLenum target, GLenum internalformat, GLsizei width, GLenum format, GLenum type, const void *table)) ldg_find("glColorTableSGI", lib);
	GL_CHECK(glp->ColorTableSGI);
	glp->ColorTableParameterfvSGI = (void APIENTRY (*)(GLenum target, GLenum pname, const GLfloat *params)) ldg_find("glColorTableParameterfvSGI", lib);
	GL_CHECK(glp->ColorTableParameterfvSGI);
	glp->ColorTableParameterivSGI = (void APIENTRY (*)(GLenum target, GLenum pname, const GLint *params)) ldg_find("glColorTableParameterivSGI", lib);
	GL_CHECK(glp->ColorTableParameterivSGI);
	glp->CopyColorTableSGI = (void APIENTRY (*)(GLenum target, GLenum internalformat, GLint x, GLint y, GLsizei width)) ldg_find("glCopyColorTableSGI", lib);
	GL_CHECK(glp->CopyColorTableSGI);
	glp->GetColorTableSGI = (void APIENTRY (*)(GLenum target, GLenum format, GLenum type, void *table)) ldg_find("glGetColorTableSGI", lib);
	GL_CHECK(glp->GetColorTableSGI);
	glp->GetColorTableParameterfvSGI = (void APIENTRY (*)(GLenum target, GLenum pname, GLfloat *params)) ldg_find("glGetColorTableParameterfvSGI", lib);
	GL_CHECK(glp->GetColorTableParameterfvSGI);
	glp->GetColorTableParameterivSGI = (void APIENTRY (*)(GLenum target, GLenum pname, GLint *params)) ldg_find("glGetColorTableParameterivSGI", lib);
	GL_CHECK(glp->GetColorTableParameterivSGI);
	glp->PixelTexGenSGIX = (void APIENTRY (*)(GLenum mode)) ldg_find("glPixelTexGenSGIX", lib);
	GL_CHECK(glp->PixelTexGenSGIX);
	glp->PixelTexGenParameteriSGIS = (void APIENTRY (*)(GLenum pname, GLint param)) ldg_find("glPixelTexGenParameteriSGIS", lib);
	GL_CHECK(glp->PixelTexGenParameteriSGIS);
	glp->PixelTexGenParameterivSGIS = (void APIENTRY (*)(GLenum pname, const GLint *params)) ldg_find("glPixelTexGenParameterivSGIS", lib);
	GL_CHECK(glp->PixelTexGenParameterivSGIS);
	glp->PixelTexGenParameterfSGIS = (void APIENTRY (*)(GLenum pname, GLfloat param)) ldg_find("glPixelTexGenParameterfSGIS", lib);
	GL_CHECK(glp->PixelTexGenParameterfSGIS);
	glp->PixelTexGenParameterfvSGIS = (void APIENTRY (*)(GLenum pname, const GLfloat *params)) ldg_find("glPixelTexGenParameterfvSGIS", lib);
	GL_CHECK(glp->PixelTexGenParameterfvSGIS);
	glp->GetPixelTexGenParameterivSGIS = (void APIENTRY (*)(GLenum pname, GLint *params)) ldg_find("glGetPixelTexGenParameterivSGIS", lib);
	GL_CHECK(glp->GetPixelTexGenParameterivSGIS);
	glp->GetPixelTexGenParameterfvSGIS = (void APIENTRY (*)(GLenum pname, GLfloat *params)) ldg_find("glGetPixelTexGenParameterfvSGIS", lib);
	GL_CHECK(glp->GetPixelTexGenParameterfvSGIS);
	glp->TexImage4DSGIS = (void APIENTRY (*)(GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, GLsizei size4d, GLint border, GLenum format, GLenum type, const void *pixels)) ldg_find("glTexImage4DSGIS", lib);
	GL_CHECK(glp->TexImage4DSGIS);
	glp->TexSubImage4DSGIS = (void APIENTRY (*)(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLint woffset, GLsizei width, GLsizei height, GLsizei depth, GLsizei size4d, GLenum format, GLenum type, const void *pixels)) ldg_find("glTexSubImage4DSGIS", lib);
	GL_CHECK(glp->TexSubImage4DSGIS);
	glp->AreTexturesResidentEXT = (GLboolean APIENTRY (*)(GLsizei n, const GLuint *textures, GLboolean *residences)) ldg_find("glAreTexturesResidentEXT", lib);
	GL_CHECK(glp->AreTexturesResidentEXT);
	glp->BindTextureEXT = (void APIENTRY (*)(GLenum target, GLuint texture)) ldg_find("glBindTextureEXT", lib);
	GL_CHECK(glp->BindTextureEXT);
	glp->DeleteTexturesEXT = (void APIENTRY (*)(GLsizei n, const GLuint *textures)) ldg_find("glDeleteTexturesEXT", lib);
	GL_CHECK(glp->DeleteTexturesEXT);
	glp->GenTexturesEXT = (void APIENTRY (*)(GLsizei n, GLuint *textures)) ldg_find("glGenTexturesEXT", lib);
	GL_CHECK(glp->GenTexturesEXT);
	glp->IsTextureEXT = (GLboolean APIENTRY (*)(GLuint texture)) ldg_find("glIsTextureEXT", lib);
	GL_CHECK(glp->IsTextureEXT);
	glp->PrioritizeTexturesEXT = (void APIENTRY (*)(GLsizei n, const GLuint *textures, const GLclampf *priorities)) ldg_find("glPrioritizeTexturesEXT", lib);
	GL_CHECK(glp->PrioritizeTexturesEXT);
	glp->DetailTexFuncSGIS = (void APIENTRY (*)(GLenum target, GLsizei n, const GLfloat *points)) ldg_find("glDetailTexFuncSGIS", lib);
	GL_CHECK(glp->DetailTexFuncSGIS);
	glp->GetDetailTexFuncSGIS = (void APIENTRY (*)(GLenum target, GLfloat *points)) ldg_find("glGetDetailTexFuncSGIS", lib);
	GL_CHECK(glp->GetDetailTexFuncSGIS);
	glp->SharpenTexFuncSGIS = (void APIENTRY (*)(GLenum target, GLsizei n, const GLfloat *points)) ldg_find("glSharpenTexFuncSGIS", lib);
	GL_CHECK(glp->SharpenTexFuncSGIS);
	glp->GetSharpenTexFuncSGIS = (void APIENTRY (*)(GLenum target, GLfloat *points)) ldg_find("glGetSharpenTexFuncSGIS", lib);
	GL_CHECK(glp->GetSharpenTexFuncSGIS);
	glp->SampleMaskSGIS = (void APIENTRY (*)(GLclampf value, GLboolean32 invert)) ldg_find("glSampleMaskSGIS", lib);
	GL_CHECK(glp->SampleMaskSGIS);
	glp->SamplePatternSGIS = (void APIENTRY (*)(GLenum pattern)) ldg_find("glSamplePatternSGIS", lib);
	GL_CHECK(glp->SamplePatternSGIS);
	glp->ArrayElementEXT = (void APIENTRY (*)(GLint i)) ldg_find("glArrayElementEXT", lib);
	GL_CHECK(glp->ArrayElementEXT);
	glp->ColorPointerEXT = (void APIENTRY (*)(GLint size, GLenum type, GLsizei stride, GLsizei count, const void *pointer)) ldg_find("glColorPointerEXT", lib);
	GL_CHECK(glp->ColorPointerEXT);
	glp->DrawArraysEXT = (void APIENTRY (*)(GLenum mode, GLint first, GLsizei count)) ldg_find("glDrawArraysEXT", lib);
	GL_CHECK(glp->DrawArraysEXT);
	glp->EdgeFlagPointerEXT = (void APIENTRY (*)(GLsizei stride, GLsizei count, const GLboolean *pointer)) ldg_find("glEdgeFlagPointerEXT", lib);
	GL_CHECK(glp->EdgeFlagPointerEXT);
	glp->GetPointervEXT = (void APIENTRY (*)(GLenum pname, void * *params)) ldg_find("glGetPointervEXT", lib);
	GL_CHECK(glp->GetPointervEXT);
	glp->IndexPointerEXT = (void APIENTRY (*)(GLenum type, GLsizei stride, GLsizei count, const void *pointer)) ldg_find("glIndexPointerEXT", lib);
	GL_CHECK(glp->IndexPointerEXT);
	glp->NormalPointerEXT = (void APIENTRY (*)(GLenum type, GLsizei stride, GLsizei count, const void *pointer)) ldg_find("glNormalPointerEXT", lib);
	GL_CHECK(glp->NormalPointerEXT);
	glp->TexCoordPointerEXT = (void APIENTRY (*)(GLint size, GLenum type, GLsizei stride, GLsizei count, const void *pointer)) ldg_find("glTexCoordPointerEXT", lib);
	GL_CHECK(glp->TexCoordPointerEXT);
	glp->VertexPointerEXT = (void APIENTRY (*)(GLint size, GLenum type, GLsizei stride, GLsizei count, const void *pointer)) ldg_find("glVertexPointerEXT", lib);
	GL_CHECK(glp->VertexPointerEXT);
	glp->BlendEquationEXT = (void APIENTRY (*)(GLenum mode)) ldg_find("glBlendEquationEXT", lib);
	GL_CHECK(glp->BlendEquationEXT);
	glp->SpriteParameterfSGIX = (void APIENTRY (*)(GLenum pname, GLfloat param)) ldg_find("glSpriteParameterfSGIX", lib);
	GL_CHECK(glp->SpriteParameterfSGIX);
	glp->SpriteParameterfvSGIX = (void APIENTRY (*)(GLenum pname, const GLfloat *params)) ldg_find("glSpriteParameterfvSGIX", lib);
	GL_CHECK(glp->SpriteParameterfvSGIX);
	glp->SpriteParameteriSGIX = (void APIENTRY (*)(GLenum pname, GLint param)) ldg_find("glSpriteParameteriSGIX", lib);
	GL_CHECK(glp->SpriteParameteriSGIX);
	glp->SpriteParameterivSGIX = (void APIENTRY (*)(GLenum pname, const GLint *params)) ldg_find("glSpriteParameterivSGIX", lib);
	GL_CHECK(glp->SpriteParameterivSGIX);
	glp->PointParameterfEXT = (void APIENTRY (*)(GLenum pname, GLfloat param)) ldg_find("glPointParameterfEXT", lib);
	GL_CHECK(glp->PointParameterfEXT);
	glp->PointParameterfvEXT = (void APIENTRY (*)(GLenum pname, const GLfloat *params)) ldg_find("glPointParameterfvEXT", lib);
	GL_CHECK(glp->PointParameterfvEXT);
	glp->PointParameterfSGIS = (void APIENTRY (*)(GLenum pname, GLfloat param)) ldg_find("glPointParameterfSGIS", lib);
	GL_CHECK(glp->PointParameterfSGIS);
	glp->PointParameterfvSGIS = (void APIENTRY (*)(GLenum pname, const GLfloat *params)) ldg_find("glPointParameterfvSGIS", lib);
	GL_CHECK(glp->PointParameterfvSGIS);
	glp->GetInstrumentsSGIX = (GLint APIENTRY (*)(void)) ldg_find("glGetInstrumentsSGIX", lib);
	GL_CHECK(glp->GetInstrumentsSGIX);
	glp->InstrumentsBufferSGIX = (void APIENTRY (*)(GLsizei size, GLint *buffer)) ldg_find("glInstrumentsBufferSGIX", lib);
	GL_CHECK(glp->InstrumentsBufferSGIX);
	glp->PollInstrumentsSGIX = (GLint APIENTRY (*)(GLint *marker_p)) ldg_find("glPollInstrumentsSGIX", lib);
	GL_CHECK(glp->PollInstrumentsSGIX);
	glp->ReadInstrumentsSGIX = (void APIENTRY (*)(GLint marker)) ldg_find("glReadInstrumentsSGIX", lib);
	GL_CHECK(glp->ReadInstrumentsSGIX);
	glp->StartInstrumentsSGIX = (void APIENTRY (*)(void)) ldg_find("glStartInstrumentsSGIX", lib);
	GL_CHECK(glp->StartInstrumentsSGIX);
	glp->StopInstrumentsSGIX = (void APIENTRY (*)(GLint marker)) ldg_find("glStopInstrumentsSGIX", lib);
	GL_CHECK(glp->StopInstrumentsSGIX);
	glp->FrameZoomSGIX = (void APIENTRY (*)(GLint factor)) ldg_find("glFrameZoomSGIX", lib);
	GL_CHECK(glp->FrameZoomSGIX);
	glp->TagSampleBufferSGIX = (void APIENTRY (*)(void)) ldg_find("glTagSampleBufferSGIX", lib);
	GL_CHECK(glp->TagSampleBufferSGIX);
	glp->DeformationMap3dSGIX = (void APIENTRY (*)(GLenum target, GLdouble u1, GLdouble u2, GLint ustride, GLint uorder, GLdouble v1, GLdouble v2, GLint vstride, GLint vorder, GLdouble w1, GLdouble w2, GLint wstride, GLint worder, const GLdouble *points)) ldg_find("glDeformationMap3dSGIX", lib);
	GL_CHECK(glp->DeformationMap3dSGIX);
	glp->DeformationMap3fSGIX = (void APIENTRY (*)(GLenum target, GLfloat u1, GLfloat u2, GLint ustride, GLint uorder, GLfloat v1, GLfloat v2, GLint vstride, GLint vorder, GLfloat w1, GLfloat w2, GLint wstride, GLint worder, const GLfloat *points)) ldg_find("glDeformationMap3fSGIX", lib);
	GL_CHECK(glp->DeformationMap3fSGIX);
	glp->DeformSGIX = (void APIENTRY (*)(GLbitfield mask)) ldg_find("glDeformSGIX", lib);
	GL_CHECK(glp->DeformSGIX);
	glp->LoadIdentityDeformationMapSGIX = (void APIENTRY (*)(GLbitfield mask)) ldg_find("glLoadIdentityDeformationMapSGIX", lib);
	GL_CHECK(glp->LoadIdentityDeformationMapSGIX);
	glp->ReferencePlaneSGIX = (void APIENTRY (*)(const GLdouble *equation)) ldg_find("glReferencePlaneSGIX", lib);
	GL_CHECK(glp->ReferencePlaneSGIX);
	glp->FlushRasterSGIX = (void APIENTRY (*)(void)) ldg_find("glFlushRasterSGIX", lib);
	GL_CHECK(glp->FlushRasterSGIX);
	glp->FogFuncSGIS = (void APIENTRY (*)(GLsizei n, const GLfloat *points)) ldg_find("glFogFuncSGIS", lib);
	GL_CHECK(glp->FogFuncSGIS);
	glp->GetFogFuncSGIS = (void APIENTRY (*)(GLfloat *points)) ldg_find("glGetFogFuncSGIS", lib);
	GL_CHECK(glp->GetFogFuncSGIS);
	glp->ImageTransformParameteriHP = (void APIENTRY (*)(GLenum target, GLenum pname, GLint param)) ldg_find("glImageTransformParameteriHP", lib);
	GL_CHECK(glp->ImageTransformParameteriHP);
	glp->ImageTransformParameterfHP = (void APIENTRY (*)(GLenum target, GLenum pname, GLfloat param)) ldg_find("glImageTransformParameterfHP", lib);
	GL_CHECK(glp->ImageTransformParameterfHP);
	glp->ImageTransformParameterivHP = (void APIENTRY (*)(GLenum target, GLenum pname, const GLint *params)) ldg_find("glImageTransformParameterivHP", lib);
	GL_CHECK(glp->ImageTransformParameterivHP);
	glp->ImageTransformParameterfvHP = (void APIENTRY (*)(GLenum target, GLenum pname, const GLfloat *params)) ldg_find("glImageTransformParameterfvHP", lib);
	GL_CHECK(glp->ImageTransformParameterfvHP);
	glp->GetImageTransformParameterivHP = (void APIENTRY (*)(GLenum target, GLenum pname, GLint *params)) ldg_find("glGetImageTransformParameterivHP", lib);
	GL_CHECK(glp->GetImageTransformParameterivHP);
	glp->GetImageTransformParameterfvHP = (void APIENTRY (*)(GLenum target, GLenum pname, GLfloat *params)) ldg_find("glGetImageTransformParameterfvHP", lib);
	GL_CHECK(glp->GetImageTransformParameterfvHP);
	glp->ColorSubTableEXT = (void APIENTRY (*)(GLenum target, GLsizei start, GLsizei count, GLenum format, GLenum type, const void *data)) ldg_find("glColorSubTableEXT", lib);
	GL_CHECK(glp->ColorSubTableEXT);
	glp->CopyColorSubTableEXT = (void APIENTRY (*)(GLenum target, GLsizei start, GLint x, GLint y, GLsizei width)) ldg_find("glCopyColorSubTableEXT", lib);
	GL_CHECK(glp->CopyColorSubTableEXT);
	glp->HintPGI = (void APIENTRY (*)(GLenum target, GLint mode)) ldg_find("glHintPGI", lib);
	GL_CHECK(glp->HintPGI);
	glp->ColorTableEXT = (void APIENTRY (*)(GLenum target, GLenum internalFormat, GLsizei width, GLenum format, GLenum type, const void *table)) ldg_find("glColorTableEXT", lib);
	GL_CHECK(glp->ColorTableEXT);
	glp->GetColorTableEXT = (void APIENTRY (*)(GLenum target, GLenum format, GLenum type, void *data)) ldg_find("glGetColorTableEXT", lib);
	GL_CHECK(glp->GetColorTableEXT);
	glp->GetColorTableParameterivEXT = (void APIENTRY (*)(GLenum target, GLenum pname, GLint *params)) ldg_find("glGetColorTableParameterivEXT", lib);
	GL_CHECK(glp->GetColorTableParameterivEXT);
	glp->GetColorTableParameterfvEXT = (void APIENTRY (*)(GLenum target, GLenum pname, GLfloat *params)) ldg_find("glGetColorTableParameterfvEXT", lib);
	GL_CHECK(glp->GetColorTableParameterfvEXT);
	glp->GetListParameterfvSGIX = (void APIENTRY (*)(GLuint list, GLenum pname, GLfloat *params)) ldg_find("glGetListParameterfvSGIX", lib);
	GL_CHECK(glp->GetListParameterfvSGIX);
	glp->GetListParameterivSGIX = (void APIENTRY (*)(GLuint list, GLenum pname, GLint *params)) ldg_find("glGetListParameterivSGIX", lib);
	GL_CHECK(glp->GetListParameterivSGIX);
	glp->ListParameterfSGIX = (void APIENTRY (*)(GLuint list, GLenum pname, GLfloat param)) ldg_find("glListParameterfSGIX", lib);
	GL_CHECK(glp->ListParameterfSGIX);
	glp->ListParameterfvSGIX = (void APIENTRY (*)(GLuint list, GLenum pname, const GLfloat *params)) ldg_find("glListParameterfvSGIX", lib);
	GL_CHECK(glp->ListParameterfvSGIX);
	glp->ListParameteriSGIX = (void APIENTRY (*)(GLuint list, GLenum pname, GLint param)) ldg_find("glListParameteriSGIX", lib);
	GL_CHECK(glp->ListParameteriSGIX);
	glp->ListParameterivSGIX = (void APIENTRY (*)(GLuint list, GLenum pname, const GLint *params)) ldg_find("glListParameterivSGIX", lib);
	GL_CHECK(glp->ListParameterivSGIX);
	glp->IndexMaterialEXT = (void APIENTRY (*)(GLenum face, GLenum mode)) ldg_find("glIndexMaterialEXT", lib);
	GL_CHECK(glp->IndexMaterialEXT);
	glp->IndexFuncEXT = (void APIENTRY (*)(GLenum func, GLclampf ref)) ldg_find("glIndexFuncEXT", lib);
	GL_CHECK(glp->IndexFuncEXT);
	glp->LockArraysEXT = (void APIENTRY (*)(GLint first, GLsizei count)) ldg_find("glLockArraysEXT", lib);
	GL_CHECK(glp->LockArraysEXT);
	glp->UnlockArraysEXT = (void APIENTRY (*)(void)) ldg_find("glUnlockArraysEXT", lib);
	GL_CHECK(glp->UnlockArraysEXT);
	glp->CullParameterdvEXT = (void APIENTRY (*)(GLenum pname, GLdouble *params)) ldg_find("glCullParameterdvEXT", lib);
	GL_CHECK(glp->CullParameterdvEXT);
	glp->CullParameterfvEXT = (void APIENTRY (*)(GLenum pname, GLfloat *params)) ldg_find("glCullParameterfvEXT", lib);
	GL_CHECK(glp->CullParameterfvEXT);
	glp->FragmentColorMaterialSGIX = (void APIENTRY (*)(GLenum face, GLenum mode)) ldg_find("glFragmentColorMaterialSGIX", lib);
	GL_CHECK(glp->FragmentColorMaterialSGIX);
	glp->FragmentLightfSGIX = (void APIENTRY (*)(GLenum light, GLenum pname, GLfloat param)) ldg_find("glFragmentLightfSGIX", lib);
	GL_CHECK(glp->FragmentLightfSGIX);
	glp->FragmentLightfvSGIX = (void APIENTRY (*)(GLenum light, GLenum pname, const GLfloat *params)) ldg_find("glFragmentLightfvSGIX", lib);
	GL_CHECK(glp->FragmentLightfvSGIX);
	glp->FragmentLightiSGIX = (void APIENTRY (*)(GLenum light, GLenum pname, GLint param)) ldg_find("glFragmentLightiSGIX", lib);
	GL_CHECK(glp->FragmentLightiSGIX);
	glp->FragmentLightivSGIX = (void APIENTRY (*)(GLenum light, GLenum pname, const GLint *params)) ldg_find("glFragmentLightivSGIX", lib);
	GL_CHECK(glp->FragmentLightivSGIX);
	glp->FragmentLightModelfSGIX = (void APIENTRY (*)(GLenum pname, GLfloat param)) ldg_find("glFragmentLightModelfSGIX", lib);
	GL_CHECK(glp->FragmentLightModelfSGIX);
	glp->FragmentLightModelfvSGIX = (void APIENTRY (*)(GLenum pname, const GLfloat *params)) ldg_find("glFragmentLightModelfvSGIX", lib);
	GL_CHECK(glp->FragmentLightModelfvSGIX);
	glp->FragmentLightModeliSGIX = (void APIENTRY (*)(GLenum pname, GLint param)) ldg_find("glFragmentLightModeliSGIX", lib);
	GL_CHECK(glp->FragmentLightModeliSGIX);
	glp->FragmentLightModelivSGIX = (void APIENTRY (*)(GLenum pname, const GLint *params)) ldg_find("glFragmentLightModelivSGIX", lib);
	GL_CHECK(glp->FragmentLightModelivSGIX);
	glp->FragmentMaterialfSGIX = (void APIENTRY (*)(GLenum face, GLenum pname, GLfloat param)) ldg_find("glFragmentMaterialfSGIX", lib);
	GL_CHECK(glp->FragmentMaterialfSGIX);
	glp->FragmentMaterialfvSGIX = (void APIENTRY (*)(GLenum face, GLenum pname, const GLfloat *params)) ldg_find("glFragmentMaterialfvSGIX", lib);
	GL_CHECK(glp->FragmentMaterialfvSGIX);
	glp->FragmentMaterialiSGIX = (void APIENTRY (*)(GLenum face, GLenum pname, GLint param)) ldg_find("glFragmentMaterialiSGIX", lib);
	GL_CHECK(glp->FragmentMaterialiSGIX);
	glp->FragmentMaterialivSGIX = (void APIENTRY (*)(GLenum face, GLenum pname, const GLint *params)) ldg_find("glFragmentMaterialivSGIX", lib);
	GL_CHECK(glp->FragmentMaterialivSGIX);
	glp->GetFragmentLightfvSGIX = (void APIENTRY (*)(GLenum light, GLenum pname, GLfloat *params)) ldg_find("glGetFragmentLightfvSGIX", lib);
	GL_CHECK(glp->GetFragmentLightfvSGIX);
	glp->GetFragmentLightivSGIX = (void APIENTRY (*)(GLenum light, GLenum pname, GLint *params)) ldg_find("glGetFragmentLightivSGIX", lib);
	GL_CHECK(glp->GetFragmentLightivSGIX);
	glp->GetFragmentMaterialfvSGIX = (void APIENTRY (*)(GLenum face, GLenum pname, GLfloat *params)) ldg_find("glGetFragmentMaterialfvSGIX", lib);
	GL_CHECK(glp->GetFragmentMaterialfvSGIX);
	glp->GetFragmentMaterialivSGIX = (void APIENTRY (*)(GLenum face, GLenum pname, GLint *params)) ldg_find("glGetFragmentMaterialivSGIX", lib);
	GL_CHECK(glp->GetFragmentMaterialivSGIX);
	glp->LightEnviSGIX = (void APIENTRY (*)(GLenum pname, GLint param)) ldg_find("glLightEnviSGIX", lib);
	GL_CHECK(glp->LightEnviSGIX);
	glp->DrawRangeElementsEXT = (void APIENTRY (*)(GLenum mode, GLuint start, GLuint end, GLsizei count, GLenum type, const void *indices)) ldg_find("glDrawRangeElementsEXT", lib);
	GL_CHECK(glp->DrawRangeElementsEXT);
	glp->ApplyTextureEXT = (void APIENTRY (*)(GLenum mode)) ldg_find("glApplyTextureEXT", lib);
	GL_CHECK(glp->ApplyTextureEXT);
	glp->TextureLightEXT = (void APIENTRY (*)(GLenum pname)) ldg_find("glTextureLightEXT", lib);
	GL_CHECK(glp->TextureLightEXT);
	glp->TextureMaterialEXT = (void APIENTRY (*)(GLenum face, GLenum mode)) ldg_find("glTextureMaterialEXT", lib);
	GL_CHECK(glp->TextureMaterialEXT);
	glp->AsyncMarkerSGIX = (void APIENTRY (*)(GLuint marker)) ldg_find("glAsyncMarkerSGIX", lib);
	GL_CHECK(glp->AsyncMarkerSGIX);
	glp->FinishAsyncSGIX = (GLint APIENTRY (*)(GLuint *markerp)) ldg_find("glFinishAsyncSGIX", lib);
	GL_CHECK(glp->FinishAsyncSGIX);
	glp->PollAsyncSGIX = (GLint APIENTRY (*)(GLuint *markerp)) ldg_find("glPollAsyncSGIX", lib);
	GL_CHECK(glp->PollAsyncSGIX);
	glp->GenAsyncMarkersSGIX = (GLuint APIENTRY (*)(GLsizei range)) ldg_find("glGenAsyncMarkersSGIX", lib);
	GL_CHECK(glp->GenAsyncMarkersSGIX);
	glp->DeleteAsyncMarkersSGIX = (void APIENTRY (*)(GLuint marker, GLsizei range)) ldg_find("glDeleteAsyncMarkersSGIX", lib);
	GL_CHECK(glp->DeleteAsyncMarkersSGIX);
	glp->IsAsyncMarkerSGIX = (GLboolean APIENTRY (*)(GLuint marker)) ldg_find("glIsAsyncMarkerSGIX", lib);
	GL_CHECK(glp->IsAsyncMarkerSGIX);
	glp->VertexPointervINTEL = (void APIENTRY (*)(GLint size, GLenum type, const void * *pointer)) ldg_find("glVertexPointervINTEL", lib);
	GL_CHECK(glp->VertexPointervINTEL);
	glp->NormalPointervINTEL = (void APIENTRY (*)(GLenum type, const void * *pointer)) ldg_find("glNormalPointervINTEL", lib);
	GL_CHECK(glp->NormalPointervINTEL);
	glp->ColorPointervINTEL = (void APIENTRY (*)(GLint size, GLenum type, const void * *pointer)) ldg_find("glColorPointervINTEL", lib);
	GL_CHECK(glp->ColorPointervINTEL);
	glp->TexCoordPointervINTEL = (void APIENTRY (*)(GLint size, GLenum type, const void * *pointer)) ldg_find("glTexCoordPointervINTEL", lib);
	GL_CHECK(glp->TexCoordPointervINTEL);
	glp->PixelTransformParameteriEXT = (void APIENTRY (*)(GLenum target, GLenum pname, GLint param)) ldg_find("glPixelTransformParameteriEXT", lib);
	GL_CHECK(glp->PixelTransformParameteriEXT);
	glp->PixelTransformParameterfEXT = (void APIENTRY (*)(GLenum target, GLenum pname, GLfloat param)) ldg_find("glPixelTransformParameterfEXT", lib);
	GL_CHECK(glp->PixelTransformParameterfEXT);
	glp->PixelTransformParameterivEXT = (void APIENTRY (*)(GLenum target, GLenum pname, const GLint *params)) ldg_find("glPixelTransformParameterivEXT", lib);
	GL_CHECK(glp->PixelTransformParameterivEXT);
	glp->PixelTransformParameterfvEXT = (void APIENTRY (*)(GLenum target, GLenum pname, const GLfloat *params)) ldg_find("glPixelTransformParameterfvEXT", lib);
	GL_CHECK(glp->PixelTransformParameterfvEXT);
	glp->SecondaryColor3bEXT = (void APIENTRY (*)(GLbyte32 red, GLbyte32 green, GLbyte32 blue)) ldg_find("glSecondaryColor3bEXT", lib);
	GL_CHECK(glp->SecondaryColor3bEXT);
	glp->SecondaryColor3bvEXT = (void APIENTRY (*)(const GLbyte *v)) ldg_find("glSecondaryColor3bvEXT", lib);
	GL_CHECK(glp->SecondaryColor3bvEXT);
	glp->SecondaryColor3dEXT = (void APIENTRY (*)(GLdouble red, GLdouble green, GLdouble blue)) ldg_find("glSecondaryColor3dEXT", lib);
	GL_CHECK(glp->SecondaryColor3dEXT);
	glp->SecondaryColor3dvEXT = (void APIENTRY (*)(const GLdouble *v)) ldg_find("glSecondaryColor3dvEXT", lib);
	GL_CHECK(glp->SecondaryColor3dvEXT);
	glp->SecondaryColor3fEXT = (void APIENTRY (*)(GLfloat red, GLfloat green, GLfloat blue)) ldg_find("glSecondaryColor3fEXT", lib);
	GL_CHECK(glp->SecondaryColor3fEXT);
	glp->SecondaryColor3fvEXT = (void APIENTRY (*)(const GLfloat *v)) ldg_find("glSecondaryColor3fvEXT", lib);
	GL_CHECK(glp->SecondaryColor3fvEXT);
	glp->SecondaryColor3iEXT = (void APIENTRY (*)(GLint red, GLint green, GLint blue)) ldg_find("glSecondaryColor3iEXT", lib);
	GL_CHECK(glp->SecondaryColor3iEXT);
	glp->SecondaryColor3ivEXT = (void APIENTRY (*)(const GLint *v)) ldg_find("glSecondaryColor3ivEXT", lib);
	GL_CHECK(glp->SecondaryColor3ivEXT);
	glp->SecondaryColor3sEXT = (void APIENTRY (*)(GLshort32 red, GLshort32 green, GLshort32 blue)) ldg_find("glSecondaryColor3sEXT", lib);
	GL_CHECK(glp->SecondaryColor3sEXT);
	glp->SecondaryColor3svEXT = (void APIENTRY (*)(const GLshort *v)) ldg_find("glSecondaryColor3svEXT", lib);
	GL_CHECK(glp->SecondaryColor3svEXT);
	glp->SecondaryColor3ubEXT = (void APIENTRY (*)(GLubyte32 red, GLubyte32 green, GLubyte32 blue)) ldg_find("glSecondaryColor3ubEXT", lib);
	GL_CHECK(glp->SecondaryColor3ubEXT);
	glp->SecondaryColor3ubvEXT = (void APIENTRY (*)(const GLubyte *v)) ldg_find("glSecondaryColor3ubvEXT", lib);
	GL_CHECK(glp->SecondaryColor3ubvEXT);
	glp->SecondaryColor3uiEXT = (void APIENTRY (*)(GLuint red, GLuint green, GLuint blue)) ldg_find("glSecondaryColor3uiEXT", lib);
	GL_CHECK(glp->SecondaryColor3uiEXT);
	glp->SecondaryColor3uivEXT = (void APIENTRY (*)(const GLuint *v)) ldg_find("glSecondaryColor3uivEXT", lib);
	GL_CHECK(glp->SecondaryColor3uivEXT);
	glp->SecondaryColor3usEXT = (void APIENTRY (*)(GLushort32 red, GLushort32 green, GLushort32 blue)) ldg_find("glSecondaryColor3usEXT", lib);
	GL_CHECK(glp->SecondaryColor3usEXT);
	glp->SecondaryColor3usvEXT = (void APIENTRY (*)(const GLushort *v)) ldg_find("glSecondaryColor3usvEXT", lib);
	GL_CHECK(glp->SecondaryColor3usvEXT);
	glp->SecondaryColorPointerEXT = (void APIENTRY (*)(GLint size, GLenum type, GLsizei stride, const void *pointer)) ldg_find("glSecondaryColorPointerEXT", lib);
	GL_CHECK(glp->SecondaryColorPointerEXT);
	glp->TextureNormalEXT = (void APIENTRY (*)(GLenum mode)) ldg_find("glTextureNormalEXT", lib);
	GL_CHECK(glp->TextureNormalEXT);
	glp->MultiDrawArraysEXT = (void APIENTRY (*)(GLenum mode, const GLint *first, const GLsizei *count, GLsizei primcount)) ldg_find("glMultiDrawArraysEXT", lib);
	GL_CHECK(glp->MultiDrawArraysEXT);
	glp->MultiDrawElementsEXT = (void APIENTRY (*)(GLenum mode, const GLsizei *count, GLenum type, const void *const *indices, GLsizei primcount)) ldg_find("glMultiDrawElementsEXT", lib);
	GL_CHECK(glp->MultiDrawElementsEXT);
	glp->FogCoordfEXT = (void APIENTRY (*)(GLfloat coord)) ldg_find("glFogCoordfEXT", lib);
	GL_CHECK(glp->FogCoordfEXT);
	glp->FogCoordfvEXT = (void APIENTRY (*)(const GLfloat *coord)) ldg_find("glFogCoordfvEXT", lib);
	GL_CHECK(glp->FogCoordfvEXT);
	glp->FogCoorddEXT = (void APIENTRY (*)(GLdouble coord)) ldg_find("glFogCoorddEXT", lib);
	GL_CHECK(glp->FogCoorddEXT);
	glp->FogCoorddvEXT = (void APIENTRY (*)(const GLdouble *coord)) ldg_find("glFogCoorddvEXT", lib);
	GL_CHECK(glp->FogCoorddvEXT);
	glp->FogCoordPointerEXT = (void APIENTRY (*)(GLenum type, GLsizei stride, const void *pointer)) ldg_find("glFogCoordPointerEXT", lib);
	GL_CHECK(glp->FogCoordPointerEXT);
	glp->Tangent3bEXT = (void APIENTRY (*)(GLbyte32 tx, GLbyte32 ty, GLbyte32 tz)) ldg_find("glTangent3bEXT", lib);
	GL_CHECK(glp->Tangent3bEXT);
	glp->Tangent3bvEXT = (void APIENTRY (*)(const GLbyte *v)) ldg_find("glTangent3bvEXT", lib);
	GL_CHECK(glp->Tangent3bvEXT);
	glp->Tangent3dEXT = (void APIENTRY (*)(GLdouble tx, GLdouble ty, GLdouble tz)) ldg_find("glTangent3dEXT", lib);
	GL_CHECK(glp->Tangent3dEXT);
	glp->Tangent3dvEXT = (void APIENTRY (*)(const GLdouble *v)) ldg_find("glTangent3dvEXT", lib);
	GL_CHECK(glp->Tangent3dvEXT);
	glp->Tangent3fEXT = (void APIENTRY (*)(GLfloat tx, GLfloat ty, GLfloat tz)) ldg_find("glTangent3fEXT", lib);
	GL_CHECK(glp->Tangent3fEXT);
	glp->Tangent3fvEXT = (void APIENTRY (*)(const GLfloat *v)) ldg_find("glTangent3fvEXT", lib);
	GL_CHECK(glp->Tangent3fvEXT);
	glp->Tangent3iEXT = (void APIENTRY (*)(GLint tx, GLint ty, GLint tz)) ldg_find("glTangent3iEXT", lib);
	GL_CHECK(glp->Tangent3iEXT);
	glp->Tangent3ivEXT = (void APIENTRY (*)(const GLint *v)) ldg_find("glTangent3ivEXT", lib);
	GL_CHECK(glp->Tangent3ivEXT);
	glp->Tangent3sEXT = (void APIENTRY (*)(GLshort32 tx, GLshort32 ty, GLshort32 tz)) ldg_find("glTangent3sEXT", lib);
	GL_CHECK(glp->Tangent3sEXT);
	glp->Tangent3svEXT = (void APIENTRY (*)(const GLshort *v)) ldg_find("glTangent3svEXT", lib);
	GL_CHECK(glp->Tangent3svEXT);
	glp->Binormal3bEXT = (void APIENTRY (*)(GLbyte32 bx, GLbyte32 by, GLbyte32 bz)) ldg_find("glBinormal3bEXT", lib);
	GL_CHECK(glp->Binormal3bEXT);
	glp->Binormal3bvEXT = (void APIENTRY (*)(const GLbyte *v)) ldg_find("glBinormal3bvEXT", lib);
	GL_CHECK(glp->Binormal3bvEXT);
	glp->Binormal3dEXT = (void APIENTRY (*)(GLdouble bx, GLdouble by, GLdouble bz)) ldg_find("glBinormal3dEXT", lib);
	GL_CHECK(glp->Binormal3dEXT);
	glp->Binormal3dvEXT = (void APIENTRY (*)(const GLdouble *v)) ldg_find("glBinormal3dvEXT", lib);
	GL_CHECK(glp->Binormal3dvEXT);
	glp->Binormal3fEXT = (void APIENTRY (*)(GLfloat bx, GLfloat by, GLfloat bz)) ldg_find("glBinormal3fEXT", lib);
	GL_CHECK(glp->Binormal3fEXT);
	glp->Binormal3fvEXT = (void APIENTRY (*)(const GLfloat *v)) ldg_find("glBinormal3fvEXT", lib);
	GL_CHECK(glp->Binormal3fvEXT);
	glp->Binormal3iEXT = (void APIENTRY (*)(GLint bx, GLint by, GLint bz)) ldg_find("glBinormal3iEXT", lib);
	GL_CHECK(glp->Binormal3iEXT);
	glp->Binormal3ivEXT = (void APIENTRY (*)(const GLint *v)) ldg_find("glBinormal3ivEXT", lib);
	GL_CHECK(glp->Binormal3ivEXT);
	glp->Binormal3sEXT = (void APIENTRY (*)(GLshort32 bx, GLshort32 by, GLshort32 bz)) ldg_find("glBinormal3sEXT", lib);
	GL_CHECK(glp->Binormal3sEXT);
	glp->Binormal3svEXT = (void APIENTRY (*)(const GLshort *v)) ldg_find("glBinormal3svEXT", lib);
	GL_CHECK(glp->Binormal3svEXT);
	glp->TangentPointerEXT = (void APIENTRY (*)(GLenum type, GLsizei stride, const void *pointer)) ldg_find("glTangentPointerEXT", lib);
	GL_CHECK(glp->TangentPointerEXT);
	glp->BinormalPointerEXT = (void APIENTRY (*)(GLenum type, GLsizei stride, const void *pointer)) ldg_find("glBinormalPointerEXT", lib);
	GL_CHECK(glp->BinormalPointerEXT);
	glp->FinishTextureSUNX = (void APIENTRY (*)(void)) ldg_find("glFinishTextureSUNX", lib);
	GL_CHECK(glp->FinishTextureSUNX);
	glp->GlobalAlphaFactorbSUN = (void APIENTRY (*)(GLbyte32 factor)) ldg_find("glGlobalAlphaFactorbSUN", lib);
	GL_CHECK(glp->GlobalAlphaFactorbSUN);
	glp->GlobalAlphaFactorsSUN = (void APIENTRY (*)(GLshort32 factor)) ldg_find("glGlobalAlphaFactorsSUN", lib);
	GL_CHECK(glp->GlobalAlphaFactorsSUN);
	glp->GlobalAlphaFactoriSUN = (void APIENTRY (*)(GLint factor)) ldg_find("glGlobalAlphaFactoriSUN", lib);
	GL_CHECK(glp->GlobalAlphaFactoriSUN);
	glp->GlobalAlphaFactorfSUN = (void APIENTRY (*)(GLfloat factor)) ldg_find("glGlobalAlphaFactorfSUN", lib);
	GL_CHECK(glp->GlobalAlphaFactorfSUN);
	glp->GlobalAlphaFactordSUN = (void APIENTRY (*)(GLdouble factor)) ldg_find("glGlobalAlphaFactordSUN", lib);
	GL_CHECK(glp->GlobalAlphaFactordSUN);
	glp->GlobalAlphaFactorubSUN = (void APIENTRY (*)(GLubyte32 factor)) ldg_find("glGlobalAlphaFactorubSUN", lib);
	GL_CHECK(glp->GlobalAlphaFactorubSUN);
	glp->GlobalAlphaFactorusSUN = (void APIENTRY (*)(GLushort32 factor)) ldg_find("glGlobalAlphaFactorusSUN", lib);
	GL_CHECK(glp->GlobalAlphaFactorusSUN);
	glp->GlobalAlphaFactoruiSUN = (void APIENTRY (*)(GLuint factor)) ldg_find("glGlobalAlphaFactoruiSUN", lib);
	GL_CHECK(glp->GlobalAlphaFactoruiSUN);
	glp->ReplacementCodeuiSUN = (void APIENTRY (*)(GLuint code)) ldg_find("glReplacementCodeuiSUN", lib);
	GL_CHECK(glp->ReplacementCodeuiSUN);
	glp->ReplacementCodeusSUN = (void APIENTRY (*)(GLushort32 code)) ldg_find("glReplacementCodeusSUN", lib);
	GL_CHECK(glp->ReplacementCodeusSUN);
	glp->ReplacementCodeubSUN = (void APIENTRY (*)(GLubyte32 code)) ldg_find("glReplacementCodeubSUN", lib);
	GL_CHECK(glp->ReplacementCodeubSUN);
	glp->ReplacementCodeuivSUN = (void APIENTRY (*)(const GLuint *code)) ldg_find("glReplacementCodeuivSUN", lib);
	GL_CHECK(glp->ReplacementCodeuivSUN);
	glp->ReplacementCodeusvSUN = (void APIENTRY (*)(const GLushort *code)) ldg_find("glReplacementCodeusvSUN", lib);
	GL_CHECK(glp->ReplacementCodeusvSUN);
	glp->ReplacementCodeubvSUN = (void APIENTRY (*)(const GLubyte *code)) ldg_find("glReplacementCodeubvSUN", lib);
	GL_CHECK(glp->ReplacementCodeubvSUN);
	glp->ReplacementCodePointerSUN = (void APIENTRY (*)(GLenum type, GLsizei stride, const void * *pointer)) ldg_find("glReplacementCodePointerSUN", lib);
	GL_CHECK(glp->ReplacementCodePointerSUN);
	glp->Color4ubVertex2fSUN = (void APIENTRY (*)(GLubyte32 r, GLubyte32 g, GLubyte32 b, GLubyte32 a, GLfloat x, GLfloat y)) ldg_find("glColor4ubVertex2fSUN", lib);
	GL_CHECK(glp->Color4ubVertex2fSUN);
	glp->Color4ubVertex2fvSUN = (void APIENTRY (*)(const GLubyte *c, const GLfloat *v)) ldg_find("glColor4ubVertex2fvSUN", lib);
	GL_CHECK(glp->Color4ubVertex2fvSUN);
	glp->Color4ubVertex3fSUN = (void APIENTRY (*)(GLubyte32 r, GLubyte32 g, GLubyte32 b, GLubyte32 a, GLfloat x, GLfloat y, GLfloat z)) ldg_find("glColor4ubVertex3fSUN", lib);
	GL_CHECK(glp->Color4ubVertex3fSUN);
	glp->Color4ubVertex3fvSUN = (void APIENTRY (*)(const GLubyte *c, const GLfloat *v)) ldg_find("glColor4ubVertex3fvSUN", lib);
	GL_CHECK(glp->Color4ubVertex3fvSUN);
	glp->Color3fVertex3fSUN = (void APIENTRY (*)(GLfloat r, GLfloat g, GLfloat b, GLfloat x, GLfloat y, GLfloat z)) ldg_find("glColor3fVertex3fSUN", lib);
	GL_CHECK(glp->Color3fVertex3fSUN);
	glp->Color3fVertex3fvSUN = (void APIENTRY (*)(const GLfloat *c, const GLfloat *v)) ldg_find("glColor3fVertex3fvSUN", lib);
	GL_CHECK(glp->Color3fVertex3fvSUN);
	glp->Normal3fVertex3fSUN = (void APIENTRY (*)(GLfloat nx, GLfloat ny, GLfloat nz, GLfloat x, GLfloat y, GLfloat z)) ldg_find("glNormal3fVertex3fSUN", lib);
	GL_CHECK(glp->Normal3fVertex3fSUN);
	glp->Normal3fVertex3fvSUN = (void APIENTRY (*)(const GLfloat *n, const GLfloat *v)) ldg_find("glNormal3fVertex3fvSUN", lib);
	GL_CHECK(glp->Normal3fVertex3fvSUN);
	glp->Color4fNormal3fVertex3fSUN = (void APIENTRY (*)(GLfloat r, GLfloat g, GLfloat b, GLfloat a, GLfloat nx, GLfloat ny, GLfloat nz, GLfloat x, GLfloat y, GLfloat z)) ldg_find("glColor4fNormal3fVertex3fSUN", lib);
	GL_CHECK(glp->Color4fNormal3fVertex3fSUN);
	glp->Color4fNormal3fVertex3fvSUN = (void APIENTRY (*)(const GLfloat *c, const GLfloat *n, const GLfloat *v)) ldg_find("glColor4fNormal3fVertex3fvSUN", lib);
	GL_CHECK(glp->Color4fNormal3fVertex3fvSUN);
	glp->TexCoord2fVertex3fSUN = (void APIENTRY (*)(GLfloat s, GLfloat t, GLfloat x, GLfloat y, GLfloat z)) ldg_find("glTexCoord2fVertex3fSUN", lib);
	GL_CHECK(glp->TexCoord2fVertex3fSUN);
	glp->TexCoord2fVertex3fvSUN = (void APIENTRY (*)(const GLfloat *tc, const GLfloat *v)) ldg_find("glTexCoord2fVertex3fvSUN", lib);
	GL_CHECK(glp->TexCoord2fVertex3fvSUN);
	glp->TexCoord4fVertex4fSUN = (void APIENTRY (*)(GLfloat s, GLfloat t, GLfloat p, GLfloat q, GLfloat x, GLfloat y, GLfloat z, GLfloat w)) ldg_find("glTexCoord4fVertex4fSUN", lib);
	GL_CHECK(glp->TexCoord4fVertex4fSUN);
	glp->TexCoord4fVertex4fvSUN = (void APIENTRY (*)(const GLfloat *tc, const GLfloat *v)) ldg_find("glTexCoord4fVertex4fvSUN", lib);
	GL_CHECK(glp->TexCoord4fVertex4fvSUN);
	glp->TexCoord2fColor4ubVertex3fSUN = (void APIENTRY (*)(GLfloat s, GLfloat t, GLubyte32 r, GLubyte32 g, GLubyte32 b, GLubyte32 a, GLfloat x, GLfloat y, GLfloat z)) ldg_find("glTexCoord2fColor4ubVertex3fSUN", lib);
	GL_CHECK(glp->TexCoord2fColor4ubVertex3fSUN);
	glp->TexCoord2fColor4ubVertex3fvSUN = (void APIENTRY (*)(const GLfloat *tc, const GLubyte *c, const GLfloat *v)) ldg_find("glTexCoord2fColor4ubVertex3fvSUN", lib);
	GL_CHECK(glp->TexCoord2fColor4ubVertex3fvSUN);
	glp->TexCoord2fColor3fVertex3fSUN = (void APIENTRY (*)(GLfloat s, GLfloat t, GLfloat r, GLfloat g, GLfloat b, GLfloat x, GLfloat y, GLfloat z)) ldg_find("glTexCoord2fColor3fVertex3fSUN", lib);
	GL_CHECK(glp->TexCoord2fColor3fVertex3fSUN);
	glp->TexCoord2fColor3fVertex3fvSUN = (void APIENTRY (*)(const GLfloat *tc, const GLfloat *c, const GLfloat *v)) ldg_find("glTexCoord2fColor3fVertex3fvSUN", lib);
	GL_CHECK(glp->TexCoord2fColor3fVertex3fvSUN);
	glp->TexCoord2fNormal3fVertex3fSUN = (void APIENTRY (*)(GLfloat s, GLfloat t, GLfloat nx, GLfloat ny, GLfloat nz, GLfloat x, GLfloat y, GLfloat z)) ldg_find("glTexCoord2fNormal3fVertex3fSUN", lib);
	GL_CHECK(glp->TexCoord2fNormal3fVertex3fSUN);
	glp->TexCoord2fNormal3fVertex3fvSUN = (void APIENTRY (*)(const GLfloat *tc, const GLfloat *n, const GLfloat *v)) ldg_find("glTexCoord2fNormal3fVertex3fvSUN", lib);
	GL_CHECK(glp->TexCoord2fNormal3fVertex3fvSUN);
	glp->TexCoord2fColor4fNormal3fVertex3fSUN = (void APIENTRY (*)(GLfloat s, GLfloat t, GLfloat r, GLfloat g, GLfloat b, GLfloat a, GLfloat nx, GLfloat ny, GLfloat nz, GLfloat x, GLfloat y, GLfloat z)) ldg_find("glTexCoord2fColor4fNormal3fVertex3fSUN", lib);
	GL_CHECK(glp->TexCoord2fColor4fNormal3fVertex3fSUN);
	glp->TexCoord2fColor4fNormal3fVertex3fvSUN = (void APIENTRY (*)(const GLfloat *tc, const GLfloat *c, const GLfloat *n, const GLfloat *v)) ldg_find("glTexCoord2fColor4fNormal3fVertex3fvSUN", lib);
	GL_CHECK(glp->TexCoord2fColor4fNormal3fVertex3fvSUN);
	glp->TexCoord4fColor4fNormal3fVertex4fSUN = (void APIENTRY (*)(GLfloat s, GLfloat t, GLfloat p, GLfloat q, GLfloat r, GLfloat g, GLfloat b, GLfloat a, GLfloat nx, GLfloat ny, GLfloat nz, GLfloat x, GLfloat y, GLfloat z, GLfloat w)) ldg_find("glTexCoord4fColor4fNormal3fVertex4fSUN", lib);
	GL_CHECK(glp->TexCoord4fColor4fNormal3fVertex4fSUN);
	glp->TexCoord4fColor4fNormal3fVertex4fvSUN = (void APIENTRY (*)(const GLfloat *tc, const GLfloat *c, const GLfloat *n, const GLfloat *v)) ldg_find("glTexCoord4fColor4fNormal3fVertex4fvSUN", lib);
	GL_CHECK(glp->TexCoord4fColor4fNormal3fVertex4fvSUN);
	glp->ReplacementCodeuiVertex3fSUN = (void APIENTRY (*)(GLuint rc, GLfloat x, GLfloat y, GLfloat z)) ldg_find("glReplacementCodeuiVertex3fSUN", lib);
	GL_CHECK(glp->ReplacementCodeuiVertex3fSUN);
	glp->ReplacementCodeuiVertex3fvSUN = (void APIENTRY (*)(const GLuint *rc, const GLfloat *v)) ldg_find("glReplacementCodeuiVertex3fvSUN", lib);
	GL_CHECK(glp->ReplacementCodeuiVertex3fvSUN);
	glp->ReplacementCodeuiColor4ubVertex3fSUN = (void APIENTRY (*)(GLuint rc, GLubyte32 r, GLubyte32 g, GLubyte32 b, GLubyte32 a, GLfloat x, GLfloat y, GLfloat z)) ldg_find("glReplacementCodeuiColor4ubVertex3fSUN", lib);
	GL_CHECK(glp->ReplacementCodeuiColor4ubVertex3fSUN);
	glp->ReplacementCodeuiColor4ubVertex3fvSUN = (void APIENTRY (*)(const GLuint *rc, const GLubyte *c, const GLfloat *v)) ldg_find("glReplacementCodeuiColor4ubVertex3fvSUN", lib);
	GL_CHECK(glp->ReplacementCodeuiColor4ubVertex3fvSUN);
	glp->ReplacementCodeuiColor3fVertex3fSUN = (void APIENTRY (*)(GLuint rc, GLfloat r, GLfloat g, GLfloat b, GLfloat x, GLfloat y, GLfloat z)) ldg_find("glReplacementCodeuiColor3fVertex3fSUN", lib);
	GL_CHECK(glp->ReplacementCodeuiColor3fVertex3fSUN);
	glp->ReplacementCodeuiColor3fVertex3fvSUN = (void APIENTRY (*)(const GLuint *rc, const GLfloat *c, const GLfloat *v)) ldg_find("glReplacementCodeuiColor3fVertex3fvSUN", lib);
	GL_CHECK(glp->ReplacementCodeuiColor3fVertex3fvSUN);
	glp->ReplacementCodeuiNormal3fVertex3fSUN = (void APIENTRY (*)(GLuint rc, GLfloat nx, GLfloat ny, GLfloat nz, GLfloat x, GLfloat y, GLfloat z)) ldg_find("glReplacementCodeuiNormal3fVertex3fSUN", lib);
	GL_CHECK(glp->ReplacementCodeuiNormal3fVertex3fSUN);
	glp->ReplacementCodeuiNormal3fVertex3fvSUN = (void APIENTRY (*)(const GLuint *rc, const GLfloat *n, const GLfloat *v)) ldg_find("glReplacementCodeuiNormal3fVertex3fvSUN", lib);
	GL_CHECK(glp->ReplacementCodeuiNormal3fVertex3fvSUN);
	glp->ReplacementCodeuiColor4fNormal3fVertex3fSUN = (void APIENTRY (*)(GLuint rc, GLfloat r, GLfloat g, GLfloat b, GLfloat a, GLfloat nx, GLfloat ny, GLfloat nz, GLfloat x, GLfloat y, GLfloat z)) ldg_find("glReplacementCodeuiColor4fNormal3fVertex3fSUN", lib);
	GL_CHECK(glp->ReplacementCodeuiColor4fNormal3fVertex3fSUN);
	glp->ReplacementCodeuiColor4fNormal3fVertex3fvSUN = (void APIENTRY (*)(const GLuint *rc, const GLfloat *c, const GLfloat *n, const GLfloat *v)) ldg_find("glReplacementCodeuiColor4fNormal3fVertex3fvSUN", lib);
	GL_CHECK(glp->ReplacementCodeuiColor4fNormal3fVertex3fvSUN);
	glp->ReplacementCodeuiTexCoord2fVertex3fSUN = (void APIENTRY (*)(GLuint rc, GLfloat s, GLfloat t, GLfloat x, GLfloat y, GLfloat z)) ldg_find("glReplacementCodeuiTexCoord2fVertex3fSUN", lib);
	GL_CHECK(glp->ReplacementCodeuiTexCoord2fVertex3fSUN);
	glp->ReplacementCodeuiTexCoord2fVertex3fvSUN = (void APIENTRY (*)(const GLuint *rc, const GLfloat *tc, const GLfloat *v)) ldg_find("glReplacementCodeuiTexCoord2fVertex3fvSUN", lib);
	GL_CHECK(glp->ReplacementCodeuiTexCoord2fVertex3fvSUN);
	glp->ReplacementCodeuiTexCoord2fNormal3fVertex3fSUN = (void APIENTRY (*)(GLuint rc, GLfloat s, GLfloat t, GLfloat nx, GLfloat ny, GLfloat nz, GLfloat x, GLfloat y, GLfloat z)) ldg_find("glReplacementCodeuiTexCoord2fNormal3fVertex3fSUN", lib);
	GL_CHECK(glp->ReplacementCodeuiTexCoord2fNormal3fVertex3fSUN);
	glp->ReplacementCodeuiTexCoord2fNormal3fVertex3fvSUN = (void APIENTRY (*)(const GLuint *rc, const GLfloat *tc, const GLfloat *n, const GLfloat *v)) ldg_find("glReplacementCodeuiTexCoord2fNormal3fVertex3fvSUN", lib);
	GL_CHECK(glp->ReplacementCodeuiTexCoord2fNormal3fVertex3fvSUN);
	glp->ReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fSUN = (void APIENTRY (*)(GLuint rc, GLfloat s, GLfloat t, GLfloat r, GLfloat g, GLfloat b, GLfloat a, GLfloat nx, GLfloat ny, GLfloat nz, GLfloat x, GLfloat y, GLfloat z)) ldg_find("glReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fSUN", lib);
	GL_CHECK(glp->ReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fSUN);
	glp->ReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fvSUN = (void APIENTRY (*)(const GLuint *rc, const GLfloat *tc, const GLfloat *c, const GLfloat *n, const GLfloat *v)) ldg_find("glReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fvSUN", lib);
	GL_CHECK(glp->ReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fvSUN);
	glp->BlendFuncSeparateEXT = (void APIENTRY (*)(GLenum sfactorRGB, GLenum dfactorRGB, GLenum sfactorAlpha, GLenum dfactorAlpha)) ldg_find("glBlendFuncSeparateEXT", lib);
	GL_CHECK(glp->BlendFuncSeparateEXT);
	glp->BlendFuncSeparateINGR = (void APIENTRY (*)(GLenum sfactorRGB, GLenum dfactorRGB, GLenum sfactorAlpha, GLenum dfactorAlpha)) ldg_find("glBlendFuncSeparateINGR", lib);
	GL_CHECK(glp->BlendFuncSeparateINGR);
	glp->VertexWeightfEXT = (void APIENTRY (*)(GLfloat weight)) ldg_find("glVertexWeightfEXT", lib);
	GL_CHECK(glp->VertexWeightfEXT);
	glp->VertexWeightfvEXT = (void APIENTRY (*)(const GLfloat *weight)) ldg_find("glVertexWeightfvEXT", lib);
	GL_CHECK(glp->VertexWeightfvEXT);
	glp->VertexWeightPointerEXT = (void APIENTRY (*)(GLint size, GLenum type, GLsizei stride, const void *pointer)) ldg_find("glVertexWeightPointerEXT", lib);
	GL_CHECK(glp->VertexWeightPointerEXT);
	glp->FlushVertexArrayRangeNV = (void APIENTRY (*)(void)) ldg_find("glFlushVertexArrayRangeNV", lib);
	GL_CHECK(glp->FlushVertexArrayRangeNV);
	glp->VertexArrayRangeNV = (void APIENTRY (*)(GLsizei length, const void *pointer)) ldg_find("glVertexArrayRangeNV", lib);
	GL_CHECK(glp->VertexArrayRangeNV);
	glp->CombinerParameterfvNV = (void APIENTRY (*)(GLenum pname, const GLfloat *params)) ldg_find("glCombinerParameterfvNV", lib);
	GL_CHECK(glp->CombinerParameterfvNV);
	glp->CombinerParameterfNV = (void APIENTRY (*)(GLenum pname, GLfloat param)) ldg_find("glCombinerParameterfNV", lib);
	GL_CHECK(glp->CombinerParameterfNV);
	glp->CombinerParameterivNV = (void APIENTRY (*)(GLenum pname, const GLint *params)) ldg_find("glCombinerParameterivNV", lib);
	GL_CHECK(glp->CombinerParameterivNV);
	glp->CombinerParameteriNV = (void APIENTRY (*)(GLenum pname, GLint param)) ldg_find("glCombinerParameteriNV", lib);
	GL_CHECK(glp->CombinerParameteriNV);
	glp->CombinerInputNV = (void APIENTRY (*)(GLenum stage, GLenum portion, GLenum variable, GLenum input, GLenum mapping, GLenum componentUsage)) ldg_find("glCombinerInputNV", lib);
	GL_CHECK(glp->CombinerInputNV);
	glp->CombinerOutputNV = (void APIENTRY (*)(GLenum stage, GLenum portion, GLenum abOutput, GLenum cdOutput, GLenum sumOutput, GLenum scale, GLenum bias, GLboolean32 abDotProduct, GLboolean32 cdDotProduct, GLboolean32 muxSum)) ldg_find("glCombinerOutputNV", lib);
	GL_CHECK(glp->CombinerOutputNV);
	glp->FinalCombinerInputNV = (void APIENTRY (*)(GLenum variable, GLenum input, GLenum mapping, GLenum componentUsage)) ldg_find("glFinalCombinerInputNV", lib);
	GL_CHECK(glp->FinalCombinerInputNV);
	glp->GetCombinerInputParameterfvNV = (void APIENTRY (*)(GLenum stage, GLenum portion, GLenum variable, GLenum pname, GLfloat *params)) ldg_find("glGetCombinerInputParameterfvNV", lib);
	GL_CHECK(glp->GetCombinerInputParameterfvNV);
	glp->GetCombinerInputParameterivNV = (void APIENTRY (*)(GLenum stage, GLenum portion, GLenum variable, GLenum pname, GLint *params)) ldg_find("glGetCombinerInputParameterivNV", lib);
	GL_CHECK(glp->GetCombinerInputParameterivNV);
	glp->GetCombinerOutputParameterfvNV = (void APIENTRY (*)(GLenum stage, GLenum portion, GLenum pname, GLfloat *params)) ldg_find("glGetCombinerOutputParameterfvNV", lib);
	GL_CHECK(glp->GetCombinerOutputParameterfvNV);
	glp->GetCombinerOutputParameterivNV = (void APIENTRY (*)(GLenum stage, GLenum portion, GLenum pname, GLint *params)) ldg_find("glGetCombinerOutputParameterivNV", lib);
	GL_CHECK(glp->GetCombinerOutputParameterivNV);
	glp->GetFinalCombinerInputParameterfvNV = (void APIENTRY (*)(GLenum variable, GLenum pname, GLfloat *params)) ldg_find("glGetFinalCombinerInputParameterfvNV", lib);
	GL_CHECK(glp->GetFinalCombinerInputParameterfvNV);
	glp->GetFinalCombinerInputParameterivNV = (void APIENTRY (*)(GLenum variable, GLenum pname, GLint *params)) ldg_find("glGetFinalCombinerInputParameterivNV", lib);
	GL_CHECK(glp->GetFinalCombinerInputParameterivNV);
	glp->ResizeBuffersMESA = (void APIENTRY (*)(void)) ldg_find("glResizeBuffersMESA", lib);
	GL_CHECK(glp->ResizeBuffersMESA);
	glp->WindowPos2dMESA = (void APIENTRY (*)(GLdouble x, GLdouble y)) ldg_find("glWindowPos2dMESA", lib);
	GL_CHECK(glp->WindowPos2dMESA);
	glp->WindowPos2dvMESA = (void APIENTRY (*)(const GLdouble *v)) ldg_find("glWindowPos2dvMESA", lib);
	GL_CHECK(glp->WindowPos2dvMESA);
	glp->WindowPos2fMESA = (void APIENTRY (*)(GLfloat x, GLfloat y)) ldg_find("glWindowPos2fMESA", lib);
	GL_CHECK(glp->WindowPos2fMESA);
	glp->WindowPos2fvMESA = (void APIENTRY (*)(const GLfloat *v)) ldg_find("glWindowPos2fvMESA", lib);
	GL_CHECK(glp->WindowPos2fvMESA);
	glp->WindowPos2iMESA = (void APIENTRY (*)(GLint x, GLint y)) ldg_find("glWindowPos2iMESA", lib);
	GL_CHECK(glp->WindowPos2iMESA);
	glp->WindowPos2ivMESA = (void APIENTRY (*)(const GLint *v)) ldg_find("glWindowPos2ivMESA", lib);
	GL_CHECK(glp->WindowPos2ivMESA);
	glp->WindowPos2sMESA = (void APIENTRY (*)(GLshort32 x, GLshort32 y)) ldg_find("glWindowPos2sMESA", lib);
	GL_CHECK(glp->WindowPos2sMESA);
	glp->WindowPos2svMESA = (void APIENTRY (*)(const GLshort *v)) ldg_find("glWindowPos2svMESA", lib);
	GL_CHECK(glp->WindowPos2svMESA);
	glp->WindowPos3dMESA = (void APIENTRY (*)(GLdouble x, GLdouble y, GLdouble z)) ldg_find("glWindowPos3dMESA", lib);
	GL_CHECK(glp->WindowPos3dMESA);
	glp->WindowPos3dvMESA = (void APIENTRY (*)(const GLdouble *v)) ldg_find("glWindowPos3dvMESA", lib);
	GL_CHECK(glp->WindowPos3dvMESA);
	glp->WindowPos3fMESA = (void APIENTRY (*)(GLfloat x, GLfloat y, GLfloat z)) ldg_find("glWindowPos3fMESA", lib);
	GL_CHECK(glp->WindowPos3fMESA);
	glp->WindowPos3fvMESA = (void APIENTRY (*)(const GLfloat *v)) ldg_find("glWindowPos3fvMESA", lib);
	GL_CHECK(glp->WindowPos3fvMESA);
	glp->WindowPos3iMESA = (void APIENTRY (*)(GLint x, GLint y, GLint z)) ldg_find("glWindowPos3iMESA", lib);
	GL_CHECK(glp->WindowPos3iMESA);
	glp->WindowPos3ivMESA = (void APIENTRY (*)(const GLint *v)) ldg_find("glWindowPos3ivMESA", lib);
	GL_CHECK(glp->WindowPos3ivMESA);
	glp->WindowPos3sMESA = (void APIENTRY (*)(GLshort32 x, GLshort32 y, GLshort32 z)) ldg_find("glWindowPos3sMESA", lib);
	GL_CHECK(glp->WindowPos3sMESA);
	glp->WindowPos3svMESA = (void APIENTRY (*)(const GLshort *v)) ldg_find("glWindowPos3svMESA", lib);
	GL_CHECK(glp->WindowPos3svMESA);
	glp->WindowPos4dMESA = (void APIENTRY (*)(GLdouble x, GLdouble y, GLdouble z, GLdouble w)) ldg_find("glWindowPos4dMESA", lib);
	GL_CHECK(glp->WindowPos4dMESA);
	glp->WindowPos4dvMESA = (void APIENTRY (*)(const GLdouble *v)) ldg_find("glWindowPos4dvMESA", lib);
	GL_CHECK(glp->WindowPos4dvMESA);
	glp->WindowPos4fMESA = (void APIENTRY (*)(GLfloat x, GLfloat y, GLfloat z, GLfloat w)) ldg_find("glWindowPos4fMESA", lib);
	GL_CHECK(glp->WindowPos4fMESA);
	glp->WindowPos4fvMESA = (void APIENTRY (*)(const GLfloat *v)) ldg_find("glWindowPos4fvMESA", lib);
	GL_CHECK(glp->WindowPos4fvMESA);
	glp->WindowPos4iMESA = (void APIENTRY (*)(GLint x, GLint y, GLint z, GLint w)) ldg_find("glWindowPos4iMESA", lib);
	GL_CHECK(glp->WindowPos4iMESA);
	glp->WindowPos4ivMESA = (void APIENTRY (*)(const GLint *v)) ldg_find("glWindowPos4ivMESA", lib);
	GL_CHECK(glp->WindowPos4ivMESA);
	glp->WindowPos4sMESA = (void APIENTRY (*)(GLshort32 x, GLshort32 y, GLshort32 z, GLshort32 w)) ldg_find("glWindowPos4sMESA", lib);
	GL_CHECK(glp->WindowPos4sMESA);
	glp->WindowPos4svMESA = (void APIENTRY (*)(const GLshort *v)) ldg_find("glWindowPos4svMESA", lib);
	GL_CHECK(glp->WindowPos4svMESA);
	glp->MultiModeDrawArraysIBM = (void APIENTRY (*)(const GLenum *mode, const GLint *first, const GLsizei *count, GLsizei primcount, GLint modestride)) ldg_find("glMultiModeDrawArraysIBM", lib);
	GL_CHECK(glp->MultiModeDrawArraysIBM);
	glp->MultiModeDrawElementsIBM = (void APIENTRY (*)(const GLenum *mode, const GLsizei *count, GLenum type, const void *const *indices, GLsizei primcount, GLint modestride)) ldg_find("glMultiModeDrawElementsIBM", lib);
	GL_CHECK(glp->MultiModeDrawElementsIBM);
	glp->ColorPointerListIBM = (void APIENTRY (*)(GLint size, GLenum type, GLint stride, const void * *pointer, GLint ptrstride)) ldg_find("glColorPointerListIBM", lib);
	GL_CHECK(glp->ColorPointerListIBM);
	glp->SecondaryColorPointerListIBM = (void APIENTRY (*)(GLint size, GLenum type, GLint stride, const void * *pointer, GLint ptrstride)) ldg_find("glSecondaryColorPointerListIBM", lib);
	GL_CHECK(glp->SecondaryColorPointerListIBM);
	glp->EdgeFlagPointerListIBM = (void APIENTRY (*)(GLint stride, const GLboolean * *pointer, GLint ptrstride)) ldg_find("glEdgeFlagPointerListIBM", lib);
	GL_CHECK(glp->EdgeFlagPointerListIBM);
	glp->FogCoordPointerListIBM = (void APIENTRY (*)(GLenum type, GLint stride, const void * *pointer, GLint ptrstride)) ldg_find("glFogCoordPointerListIBM", lib);
	GL_CHECK(glp->FogCoordPointerListIBM);
	glp->IndexPointerListIBM = (void APIENTRY (*)(GLenum type, GLint stride, const void * *pointer, GLint ptrstride)) ldg_find("glIndexPointerListIBM", lib);
	GL_CHECK(glp->IndexPointerListIBM);
	glp->NormalPointerListIBM = (void APIENTRY (*)(GLenum type, GLint stride, const void * *pointer, GLint ptrstride)) ldg_find("glNormalPointerListIBM", lib);
	GL_CHECK(glp->NormalPointerListIBM);
	glp->TexCoordPointerListIBM = (void APIENTRY (*)(GLint size, GLenum type, GLint stride, const void * *pointer, GLint ptrstride)) ldg_find("glTexCoordPointerListIBM", lib);
	GL_CHECK(glp->TexCoordPointerListIBM);
	glp->VertexPointerListIBM = (void APIENTRY (*)(GLint size, GLenum type, GLint stride, const void * *pointer, GLint ptrstride)) ldg_find("glVertexPointerListIBM", lib);
	GL_CHECK(glp->VertexPointerListIBM);
	glp->TbufferMask3DFX = (void APIENTRY (*)(GLuint mask)) ldg_find("glTbufferMask3DFX", lib);
	GL_CHECK(glp->TbufferMask3DFX);
	glp->SampleMaskEXT = (void APIENTRY (*)(GLclampf value, GLboolean32 invert)) ldg_find("glSampleMaskEXT", lib);
	GL_CHECK(glp->SampleMaskEXT);
	glp->SamplePatternEXT = (void APIENTRY (*)(GLenum pattern)) ldg_find("glSamplePatternEXT", lib);
	GL_CHECK(glp->SamplePatternEXT);
	glp->TextureColorMaskSGIS = (void APIENTRY (*)(GLboolean32 red, GLboolean32 green, GLboolean32 blue, GLboolean32 alpha)) ldg_find("glTextureColorMaskSGIS", lib);
	GL_CHECK(glp->TextureColorMaskSGIS);
	glp->IglooInterfaceSGIX = (void APIENTRY (*)(GLenum pname, const void *params)) ldg_find("glIglooInterfaceSGIX", lib);
	GL_CHECK(glp->IglooInterfaceSGIX);
	glp->DeleteFencesNV = (void APIENTRY (*)(GLsizei n, const GLuint *fences)) ldg_find("glDeleteFencesNV", lib);
	GL_CHECK(glp->DeleteFencesNV);
	glp->GenFencesNV = (void APIENTRY (*)(GLsizei n, GLuint *fences)) ldg_find("glGenFencesNV", lib);
	GL_CHECK(glp->GenFencesNV);
	glp->IsFenceNV = (GLboolean APIENTRY (*)(GLuint fence)) ldg_find("glIsFenceNV", lib);
	GL_CHECK(glp->IsFenceNV);
	glp->TestFenceNV = (GLboolean APIENTRY (*)(GLuint fence)) ldg_find("glTestFenceNV", lib);
	GL_CHECK(glp->TestFenceNV);
	glp->GetFenceivNV = (void APIENTRY (*)(GLuint fence, GLenum pname, GLint *params)) ldg_find("glGetFenceivNV", lib);
	GL_CHECK(glp->GetFenceivNV);
	glp->FinishFenceNV = (void APIENTRY (*)(GLuint fence)) ldg_find("glFinishFenceNV", lib);
	GL_CHECK(glp->FinishFenceNV);
	glp->SetFenceNV = (void APIENTRY (*)(GLuint fence, GLenum condition)) ldg_find("glSetFenceNV", lib);
	GL_CHECK(glp->SetFenceNV);
	glp->MapControlPointsNV = (void APIENTRY (*)(GLenum target, GLuint index, GLenum type, GLsizei ustride, GLsizei vstride, GLint uorder, GLint vorder, GLboolean32 packed, const void *points)) ldg_find("glMapControlPointsNV", lib);
	GL_CHECK(glp->MapControlPointsNV);
	glp->MapParameterivNV = (void APIENTRY (*)(GLenum target, GLenum pname, const GLint *params)) ldg_find("glMapParameterivNV", lib);
	GL_CHECK(glp->MapParameterivNV);
	glp->MapParameterfvNV = (void APIENTRY (*)(GLenum target, GLenum pname, const GLfloat *params)) ldg_find("glMapParameterfvNV", lib);
	GL_CHECK(glp->MapParameterfvNV);
	glp->GetMapControlPointsNV = (void APIENTRY (*)(GLenum target, GLuint index, GLenum type, GLsizei ustride, GLsizei vstride, GLboolean32 packed, void *points)) ldg_find("glGetMapControlPointsNV", lib);
	GL_CHECK(glp->GetMapControlPointsNV);
	glp->GetMapParameterivNV = (void APIENTRY (*)(GLenum target, GLenum pname, GLint *params)) ldg_find("glGetMapParameterivNV", lib);
	GL_CHECK(glp->GetMapParameterivNV);
	glp->GetMapParameterfvNV = (void APIENTRY (*)(GLenum target, GLenum pname, GLfloat *params)) ldg_find("glGetMapParameterfvNV", lib);
	GL_CHECK(glp->GetMapParameterfvNV);
	glp->GetMapAttribParameterivNV = (void APIENTRY (*)(GLenum target, GLuint index, GLenum pname, GLint *params)) ldg_find("glGetMapAttribParameterivNV", lib);
	GL_CHECK(glp->GetMapAttribParameterivNV);
	glp->GetMapAttribParameterfvNV = (void APIENTRY (*)(GLenum target, GLuint index, GLenum pname, GLfloat *params)) ldg_find("glGetMapAttribParameterfvNV", lib);
	GL_CHECK(glp->GetMapAttribParameterfvNV);
	glp->EvalMapsNV = (void APIENTRY (*)(GLenum target, GLenum mode)) ldg_find("glEvalMapsNV", lib);
	GL_CHECK(glp->EvalMapsNV);
	glp->CombinerStageParameterfvNV = (void APIENTRY (*)(GLenum stage, GLenum pname, const GLfloat *params)) ldg_find("glCombinerStageParameterfvNV", lib);
	GL_CHECK(glp->CombinerStageParameterfvNV);
	glp->GetCombinerStageParameterfvNV = (void APIENTRY (*)(GLenum stage, GLenum pname, GLfloat *params)) ldg_find("glGetCombinerStageParameterfvNV", lib);
	GL_CHECK(glp->GetCombinerStageParameterfvNV);
	glp->AreProgramsResidentNV = (GLboolean APIENTRY (*)(GLsizei n, const GLuint *programs, GLboolean *residences)) ldg_find("glAreProgramsResidentNV", lib);
	GL_CHECK(glp->AreProgramsResidentNV);
	glp->BindProgramNV = (void APIENTRY (*)(GLenum target, GLuint id)) ldg_find("glBindProgramNV", lib);
	GL_CHECK(glp->BindProgramNV);
	glp->DeleteProgramsNV = (void APIENTRY (*)(GLsizei n, const GLuint *programs)) ldg_find("glDeleteProgramsNV", lib);
	GL_CHECK(glp->DeleteProgramsNV);
	glp->ExecuteProgramNV = (void APIENTRY (*)(GLenum target, GLuint id, const GLfloat *params)) ldg_find("glExecuteProgramNV", lib);
	GL_CHECK(glp->ExecuteProgramNV);
	glp->GenProgramsNV = (void APIENTRY (*)(GLsizei n, GLuint *programs)) ldg_find("glGenProgramsNV", lib);
	GL_CHECK(glp->GenProgramsNV);
	glp->GetProgramParameterdvNV = (void APIENTRY (*)(GLenum target, GLuint index, GLenum pname, GLdouble *params)) ldg_find("glGetProgramParameterdvNV", lib);
	GL_CHECK(glp->GetProgramParameterdvNV);
	glp->GetProgramParameterfvNV = (void APIENTRY (*)(GLenum target, GLuint index, GLenum pname, GLfloat *params)) ldg_find("glGetProgramParameterfvNV", lib);
	GL_CHECK(glp->GetProgramParameterfvNV);
	glp->GetProgramivNV = (void APIENTRY (*)(GLuint id, GLenum pname, GLint *params)) ldg_find("glGetProgramivNV", lib);
	GL_CHECK(glp->GetProgramivNV);
	glp->GetProgramStringNV = (void APIENTRY (*)(GLuint id, GLenum pname, GLubyte *program)) ldg_find("glGetProgramStringNV", lib);
	GL_CHECK(glp->GetProgramStringNV);
	glp->GetTrackMatrixivNV = (void APIENTRY (*)(GLenum target, GLuint address, GLenum pname, GLint *params)) ldg_find("glGetTrackMatrixivNV", lib);
	GL_CHECK(glp->GetTrackMatrixivNV);
	glp->GetVertexAttribdvNV = (void APIENTRY (*)(GLuint index, GLenum pname, GLdouble *params)) ldg_find("glGetVertexAttribdvNV", lib);
	GL_CHECK(glp->GetVertexAttribdvNV);
	glp->GetVertexAttribfvNV = (void APIENTRY (*)(GLuint index, GLenum pname, GLfloat *params)) ldg_find("glGetVertexAttribfvNV", lib);
	GL_CHECK(glp->GetVertexAttribfvNV);
	glp->GetVertexAttribivNV = (void APIENTRY (*)(GLuint index, GLenum pname, GLint *params)) ldg_find("glGetVertexAttribivNV", lib);
	GL_CHECK(glp->GetVertexAttribivNV);
	glp->GetVertexAttribPointervNV = (void APIENTRY (*)(GLuint index, GLenum pname, void * *pointer)) ldg_find("glGetVertexAttribPointervNV", lib);
	GL_CHECK(glp->GetVertexAttribPointervNV);
	glp->IsProgramNV = (GLboolean APIENTRY (*)(GLuint id)) ldg_find("glIsProgramNV", lib);
	GL_CHECK(glp->IsProgramNV);
	glp->LoadProgramNV = (void APIENTRY (*)(GLenum target, GLuint id, GLsizei len, const GLubyte *program)) ldg_find("glLoadProgramNV", lib);
	GL_CHECK(glp->LoadProgramNV);
	glp->ProgramParameter4dNV = (void APIENTRY (*)(GLenum target, GLuint index, GLdouble x, GLdouble y, GLdouble z, GLdouble w)) ldg_find("glProgramParameter4dNV", lib);
	GL_CHECK(glp->ProgramParameter4dNV);
	glp->ProgramParameter4dvNV = (void APIENTRY (*)(GLenum target, GLuint index, const GLdouble *v)) ldg_find("glProgramParameter4dvNV", lib);
	GL_CHECK(glp->ProgramParameter4dvNV);
	glp->ProgramParameter4fNV = (void APIENTRY (*)(GLenum target, GLuint index, GLfloat x, GLfloat y, GLfloat z, GLfloat w)) ldg_find("glProgramParameter4fNV", lib);
	GL_CHECK(glp->ProgramParameter4fNV);
	glp->ProgramParameter4fvNV = (void APIENTRY (*)(GLenum target, GLuint index, const GLfloat *v)) ldg_find("glProgramParameter4fvNV", lib);
	GL_CHECK(glp->ProgramParameter4fvNV);
	glp->ProgramParameters4dvNV = (void APIENTRY (*)(GLenum target, GLuint index, GLsizei count, const GLdouble *v)) ldg_find("glProgramParameters4dvNV", lib);
	GL_CHECK(glp->ProgramParameters4dvNV);
	glp->ProgramParameters4fvNV = (void APIENTRY (*)(GLenum target, GLuint index, GLsizei count, const GLfloat *v)) ldg_find("glProgramParameters4fvNV", lib);
	GL_CHECK(glp->ProgramParameters4fvNV);
	glp->RequestResidentProgramsNV = (void APIENTRY (*)(GLsizei n, const GLuint *programs)) ldg_find("glRequestResidentProgramsNV", lib);
	GL_CHECK(glp->RequestResidentProgramsNV);
	glp->TrackMatrixNV = (void APIENTRY (*)(GLenum target, GLuint address, GLenum matrix, GLenum transform)) ldg_find("glTrackMatrixNV", lib);
	GL_CHECK(glp->TrackMatrixNV);
	glp->VertexAttribPointerNV = (void APIENTRY (*)(GLuint index, GLint fsize, GLenum type, GLsizei stride, const void *pointer)) ldg_find("glVertexAttribPointerNV", lib);
	GL_CHECK(glp->VertexAttribPointerNV);
	glp->VertexAttrib1dNV = (void APIENTRY (*)(GLuint index, GLdouble x)) ldg_find("glVertexAttrib1dNV", lib);
	GL_CHECK(glp->VertexAttrib1dNV);
	glp->VertexAttrib1dvNV = (void APIENTRY (*)(GLuint index, const GLdouble *v)) ldg_find("glVertexAttrib1dvNV", lib);
	GL_CHECK(glp->VertexAttrib1dvNV);
	glp->VertexAttrib1fNV = (void APIENTRY (*)(GLuint index, GLfloat x)) ldg_find("glVertexAttrib1fNV", lib);
	GL_CHECK(glp->VertexAttrib1fNV);
	glp->VertexAttrib1fvNV = (void APIENTRY (*)(GLuint index, const GLfloat *v)) ldg_find("glVertexAttrib1fvNV", lib);
	GL_CHECK(glp->VertexAttrib1fvNV);
	glp->VertexAttrib1sNV = (void APIENTRY (*)(GLuint index, GLshort32 x)) ldg_find("glVertexAttrib1sNV", lib);
	GL_CHECK(glp->VertexAttrib1sNV);
	glp->VertexAttrib1svNV = (void APIENTRY (*)(GLuint index, const GLshort *v)) ldg_find("glVertexAttrib1svNV", lib);
	GL_CHECK(glp->VertexAttrib1svNV);
	glp->VertexAttrib2dNV = (void APIENTRY (*)(GLuint index, GLdouble x, GLdouble y)) ldg_find("glVertexAttrib2dNV", lib);
	GL_CHECK(glp->VertexAttrib2dNV);
	glp->VertexAttrib2dvNV = (void APIENTRY (*)(GLuint index, const GLdouble *v)) ldg_find("glVertexAttrib2dvNV", lib);
	GL_CHECK(glp->VertexAttrib2dvNV);
	glp->VertexAttrib2fNV = (void APIENTRY (*)(GLuint index, GLfloat x, GLfloat y)) ldg_find("glVertexAttrib2fNV", lib);
	GL_CHECK(glp->VertexAttrib2fNV);
	glp->VertexAttrib2fvNV = (void APIENTRY (*)(GLuint index, const GLfloat *v)) ldg_find("glVertexAttrib2fvNV", lib);
	GL_CHECK(glp->VertexAttrib2fvNV);
	glp->VertexAttrib2sNV = (void APIENTRY (*)(GLuint index, GLshort32 x, GLshort32 y)) ldg_find("glVertexAttrib2sNV", lib);
	GL_CHECK(glp->VertexAttrib2sNV);
	glp->VertexAttrib2svNV = (void APIENTRY (*)(GLuint index, const GLshort *v)) ldg_find("glVertexAttrib2svNV", lib);
	GL_CHECK(glp->VertexAttrib2svNV);
	glp->VertexAttrib3dNV = (void APIENTRY (*)(GLuint index, GLdouble x, GLdouble y, GLdouble z)) ldg_find("glVertexAttrib3dNV", lib);
	GL_CHECK(glp->VertexAttrib3dNV);
	glp->VertexAttrib3dvNV = (void APIENTRY (*)(GLuint index, const GLdouble *v)) ldg_find("glVertexAttrib3dvNV", lib);
	GL_CHECK(glp->VertexAttrib3dvNV);
	glp->VertexAttrib3fNV = (void APIENTRY (*)(GLuint index, GLfloat x, GLfloat y, GLfloat z)) ldg_find("glVertexAttrib3fNV", lib);
	GL_CHECK(glp->VertexAttrib3fNV);
	glp->VertexAttrib3fvNV = (void APIENTRY (*)(GLuint index, const GLfloat *v)) ldg_find("glVertexAttrib3fvNV", lib);
	GL_CHECK(glp->VertexAttrib3fvNV);
	glp->VertexAttrib3sNV = (void APIENTRY (*)(GLuint index, GLshort32 x, GLshort32 y, GLshort32 z)) ldg_find("glVertexAttrib3sNV", lib);
	GL_CHECK(glp->VertexAttrib3sNV);
	glp->VertexAttrib3svNV = (void APIENTRY (*)(GLuint index, const GLshort *v)) ldg_find("glVertexAttrib3svNV", lib);
	GL_CHECK(glp->VertexAttrib3svNV);
	glp->VertexAttrib4dNV = (void APIENTRY (*)(GLuint index, GLdouble x, GLdouble y, GLdouble z, GLdouble w)) ldg_find("glVertexAttrib4dNV", lib);
	GL_CHECK(glp->VertexAttrib4dNV);
	glp->VertexAttrib4dvNV = (void APIENTRY (*)(GLuint index, const GLdouble *v)) ldg_find("glVertexAttrib4dvNV", lib);
	GL_CHECK(glp->VertexAttrib4dvNV);
	glp->VertexAttrib4fNV = (void APIENTRY (*)(GLuint index, GLfloat x, GLfloat y, GLfloat z, GLfloat w)) ldg_find("glVertexAttrib4fNV", lib);
	GL_CHECK(glp->VertexAttrib4fNV);
	glp->VertexAttrib4fvNV = (void APIENTRY (*)(GLuint index, const GLfloat *v)) ldg_find("glVertexAttrib4fvNV", lib);
	GL_CHECK(glp->VertexAttrib4fvNV);
	glp->VertexAttrib4sNV = (void APIENTRY (*)(GLuint index, GLshort32 x, GLshort32 y, GLshort32 z, GLshort32 w)) ldg_find("glVertexAttrib4sNV", lib);
	GL_CHECK(glp->VertexAttrib4sNV);
	glp->VertexAttrib4svNV = (void APIENTRY (*)(GLuint index, const GLshort *v)) ldg_find("glVertexAttrib4svNV", lib);
	GL_CHECK(glp->VertexAttrib4svNV);
	glp->VertexAttrib4ubNV = (void APIENTRY (*)(GLuint index, GLubyte32 x, GLubyte32 y, GLubyte32 z, GLubyte32 w)) ldg_find("glVertexAttrib4ubNV", lib);
	GL_CHECK(glp->VertexAttrib4ubNV);
	glp->VertexAttrib4ubvNV = (void APIENTRY (*)(GLuint index, const GLubyte *v)) ldg_find("glVertexAttrib4ubvNV", lib);
	GL_CHECK(glp->VertexAttrib4ubvNV);
	glp->VertexAttribs1dvNV = (void APIENTRY (*)(GLuint index, GLsizei count, const GLdouble *v)) ldg_find("glVertexAttribs1dvNV", lib);
	GL_CHECK(glp->VertexAttribs1dvNV);
	glp->VertexAttribs1fvNV = (void APIENTRY (*)(GLuint index, GLsizei count, const GLfloat *v)) ldg_find("glVertexAttribs1fvNV", lib);
	GL_CHECK(glp->VertexAttribs1fvNV);
	glp->VertexAttribs1svNV = (void APIENTRY (*)(GLuint index, GLsizei count, const GLshort *v)) ldg_find("glVertexAttribs1svNV", lib);
	GL_CHECK(glp->VertexAttribs1svNV);
	glp->VertexAttribs2dvNV = (void APIENTRY (*)(GLuint index, GLsizei count, const GLdouble *v)) ldg_find("glVertexAttribs2dvNV", lib);
	GL_CHECK(glp->VertexAttribs2dvNV);
	glp->VertexAttribs2fvNV = (void APIENTRY (*)(GLuint index, GLsizei count, const GLfloat *v)) ldg_find("glVertexAttribs2fvNV", lib);
	GL_CHECK(glp->VertexAttribs2fvNV);
	glp->VertexAttribs2svNV = (void APIENTRY (*)(GLuint index, GLsizei count, const GLshort *v)) ldg_find("glVertexAttribs2svNV", lib);
	GL_CHECK(glp->VertexAttribs2svNV);
	glp->VertexAttribs3dvNV = (void APIENTRY (*)(GLuint index, GLsizei count, const GLdouble *v)) ldg_find("glVertexAttribs3dvNV", lib);
	GL_CHECK(glp->VertexAttribs3dvNV);
	glp->VertexAttribs3fvNV = (void APIENTRY (*)(GLuint index, GLsizei count, const GLfloat *v)) ldg_find("glVertexAttribs3fvNV", lib);
	GL_CHECK(glp->VertexAttribs3fvNV);
	glp->VertexAttribs3svNV = (void APIENTRY (*)(GLuint index, GLsizei count, const GLshort *v)) ldg_find("glVertexAttribs3svNV", lib);
	GL_CHECK(glp->VertexAttribs3svNV);
	glp->VertexAttribs4dvNV = (void APIENTRY (*)(GLuint index, GLsizei count, const GLdouble *v)) ldg_find("glVertexAttribs4dvNV", lib);
	GL_CHECK(glp->VertexAttribs4dvNV);
	glp->VertexAttribs4fvNV = (void APIENTRY (*)(GLuint index, GLsizei count, const GLfloat *v)) ldg_find("glVertexAttribs4fvNV", lib);
	GL_CHECK(glp->VertexAttribs4fvNV);
	glp->VertexAttribs4svNV = (void APIENTRY (*)(GLuint index, GLsizei count, const GLshort *v)) ldg_find("glVertexAttribs4svNV", lib);
	GL_CHECK(glp->VertexAttribs4svNV);
	glp->VertexAttribs4ubvNV = (void APIENTRY (*)(GLuint index, GLsizei count, const GLubyte *v)) ldg_find("glVertexAttribs4ubvNV", lib);
	GL_CHECK(glp->VertexAttribs4ubvNV);
	glp->TexBumpParameterivATI = (void APIENTRY (*)(GLenum pname, const GLint *param)) ldg_find("glTexBumpParameterivATI", lib);
	GL_CHECK(glp->TexBumpParameterivATI);
	glp->TexBumpParameterfvATI = (void APIENTRY (*)(GLenum pname, const GLfloat *param)) ldg_find("glTexBumpParameterfvATI", lib);
	GL_CHECK(glp->TexBumpParameterfvATI);
	glp->GetTexBumpParameterivATI = (void APIENTRY (*)(GLenum pname, GLint *param)) ldg_find("glGetTexBumpParameterivATI", lib);
	GL_CHECK(glp->GetTexBumpParameterivATI);
	glp->GetTexBumpParameterfvATI = (void APIENTRY (*)(GLenum pname, GLfloat *param)) ldg_find("glGetTexBumpParameterfvATI", lib);
	GL_CHECK(glp->GetTexBumpParameterfvATI);
	glp->GenFragmentShadersATI = (GLuint APIENTRY (*)(GLuint range)) ldg_find("glGenFragmentShadersATI", lib);
	GL_CHECK(glp->GenFragmentShadersATI);
	glp->BindFragmentShaderATI = (void APIENTRY (*)(GLuint id)) ldg_find("glBindFragmentShaderATI", lib);
	GL_CHECK(glp->BindFragmentShaderATI);
	glp->DeleteFragmentShaderATI = (void APIENTRY (*)(GLuint id)) ldg_find("glDeleteFragmentShaderATI", lib);
	GL_CHECK(glp->DeleteFragmentShaderATI);
	glp->BeginFragmentShaderATI = (void APIENTRY (*)(void)) ldg_find("glBeginFragmentShaderATI", lib);
	GL_CHECK(glp->BeginFragmentShaderATI);
	glp->EndFragmentShaderATI = (void APIENTRY (*)(void)) ldg_find("glEndFragmentShaderATI", lib);
	GL_CHECK(glp->EndFragmentShaderATI);
	glp->PassTexCoordATI = (void APIENTRY (*)(GLuint dst, GLuint coord, GLenum swizzle)) ldg_find("glPassTexCoordATI", lib);
	GL_CHECK(glp->PassTexCoordATI);
	glp->SampleMapATI = (void APIENTRY (*)(GLuint dst, GLuint interp, GLenum swizzle)) ldg_find("glSampleMapATI", lib);
	GL_CHECK(glp->SampleMapATI);
	glp->ColorFragmentOp1ATI = (void APIENTRY (*)(GLenum op, GLuint dst, GLuint dstMask, GLuint dstMod, GLuint arg1, GLuint arg1Rep, GLuint arg1Mod)) ldg_find("glColorFragmentOp1ATI", lib);
	GL_CHECK(glp->ColorFragmentOp1ATI);
	glp->ColorFragmentOp2ATI = (void APIENTRY (*)(GLenum op, GLuint dst, GLuint dstMask, GLuint dstMod, GLuint arg1, GLuint arg1Rep, GLuint arg1Mod, GLuint arg2, GLuint arg2Rep, GLuint arg2Mod)) ldg_find("glColorFragmentOp2ATI", lib);
	GL_CHECK(glp->ColorFragmentOp2ATI);
	glp->ColorFragmentOp3ATI = (void APIENTRY (*)(GLenum op, GLuint dst, GLuint dstMask, GLuint dstMod, GLuint arg1, GLuint arg1Rep, GLuint arg1Mod, GLuint arg2, GLuint arg2Rep, GLuint arg2Mod, GLuint arg3, GLuint arg3Rep, GLuint arg3Mod)) ldg_find("glColorFragmentOp3ATI", lib);
	GL_CHECK(glp->ColorFragmentOp3ATI);
	glp->AlphaFragmentOp1ATI = (void APIENTRY (*)(GLenum op, GLuint dst, GLuint dstMod, GLuint arg1, GLuint arg1Rep, GLuint arg1Mod)) ldg_find("glAlphaFragmentOp1ATI", lib);
	GL_CHECK(glp->AlphaFragmentOp1ATI);
	glp->AlphaFragmentOp2ATI = (void APIENTRY (*)(GLenum op, GLuint dst, GLuint dstMod, GLuint arg1, GLuint arg1Rep, GLuint arg1Mod, GLuint arg2, GLuint arg2Rep, GLuint arg2Mod)) ldg_find("glAlphaFragmentOp2ATI", lib);
	GL_CHECK(glp->AlphaFragmentOp2ATI);
	glp->AlphaFragmentOp3ATI = (void APIENTRY (*)(GLenum op, GLuint dst, GLuint dstMod, GLuint arg1, GLuint arg1Rep, GLuint arg1Mod, GLuint arg2, GLuint arg2Rep, GLuint arg2Mod, GLuint arg3, GLuint arg3Rep, GLuint arg3Mod)) ldg_find("glAlphaFragmentOp3ATI", lib);
	GL_CHECK(glp->AlphaFragmentOp3ATI);
	glp->SetFragmentShaderConstantATI = (void APIENTRY (*)(GLuint dst, const GLfloat *value)) ldg_find("glSetFragmentShaderConstantATI", lib);
	GL_CHECK(glp->SetFragmentShaderConstantATI);
	glp->PNTrianglesiATI = (void APIENTRY (*)(GLenum pname, GLint param)) ldg_find("glPNTrianglesiATI", lib);
	GL_CHECK(glp->PNTrianglesiATI);
	glp->PNTrianglesfATI = (void APIENTRY (*)(GLenum pname, GLfloat param)) ldg_find("glPNTrianglesfATI", lib);
	GL_CHECK(glp->PNTrianglesfATI);
	glp->NewObjectBufferATI = (GLuint APIENTRY (*)(GLsizei size, const void *pointer, GLenum usage)) ldg_find("glNewObjectBufferATI", lib);
	GL_CHECK(glp->NewObjectBufferATI);
	glp->IsObjectBufferATI = (GLboolean APIENTRY (*)(GLuint buffer)) ldg_find("glIsObjectBufferATI", lib);
	GL_CHECK(glp->IsObjectBufferATI);
	glp->UpdateObjectBufferATI = (void APIENTRY (*)(GLuint buffer, GLuint offset, GLsizei size, const void *pointer, GLenum preserve)) ldg_find("glUpdateObjectBufferATI", lib);
	GL_CHECK(glp->UpdateObjectBufferATI);
	glp->GetObjectBufferfvATI = (void APIENTRY (*)(GLuint buffer, GLenum pname, GLfloat *params)) ldg_find("glGetObjectBufferfvATI", lib);
	GL_CHECK(glp->GetObjectBufferfvATI);
	glp->GetObjectBufferivATI = (void APIENTRY (*)(GLuint buffer, GLenum pname, GLint *params)) ldg_find("glGetObjectBufferivATI", lib);
	GL_CHECK(glp->GetObjectBufferivATI);
	glp->FreeObjectBufferATI = (void APIENTRY (*)(GLuint buffer)) ldg_find("glFreeObjectBufferATI", lib);
	GL_CHECK(glp->FreeObjectBufferATI);
	glp->ArrayObjectATI = (void APIENTRY (*)(GLenum array, GLint size, GLenum type, GLsizei stride, GLuint buffer, GLuint offset)) ldg_find("glArrayObjectATI", lib);
	GL_CHECK(glp->ArrayObjectATI);
	glp->GetArrayObjectfvATI = (void APIENTRY (*)(GLenum array, GLenum pname, GLfloat *params)) ldg_find("glGetArrayObjectfvATI", lib);
	GL_CHECK(glp->GetArrayObjectfvATI);
	glp->GetArrayObjectivATI = (void APIENTRY (*)(GLenum array, GLenum pname, GLint *params)) ldg_find("glGetArrayObjectivATI", lib);
	GL_CHECK(glp->GetArrayObjectivATI);
	glp->VariantArrayObjectATI = (void APIENTRY (*)(GLuint id, GLenum type, GLsizei stride, GLuint buffer, GLuint offset)) ldg_find("glVariantArrayObjectATI", lib);
	GL_CHECK(glp->VariantArrayObjectATI);
	glp->GetVariantArrayObjectfvATI = (void APIENTRY (*)(GLuint id, GLenum pname, GLfloat *params)) ldg_find("glGetVariantArrayObjectfvATI", lib);
	GL_CHECK(glp->GetVariantArrayObjectfvATI);
	glp->GetVariantArrayObjectivATI = (void APIENTRY (*)(GLuint id, GLenum pname, GLint *params)) ldg_find("glGetVariantArrayObjectivATI", lib);
	GL_CHECK(glp->GetVariantArrayObjectivATI);
	glp->BeginVertexShaderEXT = (void APIENTRY (*)(void)) ldg_find("glBeginVertexShaderEXT", lib);
	GL_CHECK(glp->BeginVertexShaderEXT);
	glp->EndVertexShaderEXT = (void APIENTRY (*)(void)) ldg_find("glEndVertexShaderEXT", lib);
	GL_CHECK(glp->EndVertexShaderEXT);
	glp->BindVertexShaderEXT = (void APIENTRY (*)(GLuint id)) ldg_find("glBindVertexShaderEXT", lib);
	GL_CHECK(glp->BindVertexShaderEXT);
	glp->GenVertexShadersEXT = (GLuint APIENTRY (*)(GLuint range)) ldg_find("glGenVertexShadersEXT", lib);
	GL_CHECK(glp->GenVertexShadersEXT);
	glp->DeleteVertexShaderEXT = (void APIENTRY (*)(GLuint id)) ldg_find("glDeleteVertexShaderEXT", lib);
	GL_CHECK(glp->DeleteVertexShaderEXT);
	glp->ShaderOp1EXT = (void APIENTRY (*)(GLenum op, GLuint res, GLuint arg1)) ldg_find("glShaderOp1EXT", lib);
	GL_CHECK(glp->ShaderOp1EXT);
	glp->ShaderOp2EXT = (void APIENTRY (*)(GLenum op, GLuint res, GLuint arg1, GLuint arg2)) ldg_find("glShaderOp2EXT", lib);
	GL_CHECK(glp->ShaderOp2EXT);
	glp->ShaderOp3EXT = (void APIENTRY (*)(GLenum op, GLuint res, GLuint arg1, GLuint arg2, GLuint arg3)) ldg_find("glShaderOp3EXT", lib);
	GL_CHECK(glp->ShaderOp3EXT);
	glp->SwizzleEXT = (void APIENTRY (*)(GLuint res, GLuint in, GLenum outX, GLenum outY, GLenum outZ, GLenum outW)) ldg_find("glSwizzleEXT", lib);
	GL_CHECK(glp->SwizzleEXT);
	glp->WriteMaskEXT = (void APIENTRY (*)(GLuint res, GLuint in, GLenum outX, GLenum outY, GLenum outZ, GLenum outW)) ldg_find("glWriteMaskEXT", lib);
	GL_CHECK(glp->WriteMaskEXT);
	glp->InsertComponentEXT = (void APIENTRY (*)(GLuint res, GLuint src, GLuint num)) ldg_find("glInsertComponentEXT", lib);
	GL_CHECK(glp->InsertComponentEXT);
	glp->ExtractComponentEXT = (void APIENTRY (*)(GLuint res, GLuint src, GLuint num)) ldg_find("glExtractComponentEXT", lib);
	GL_CHECK(glp->ExtractComponentEXT);
	glp->GenSymbolsEXT = (GLuint APIENTRY (*)(GLenum datatype, GLenum storagetype, GLenum range, GLuint components)) ldg_find("glGenSymbolsEXT", lib);
	GL_CHECK(glp->GenSymbolsEXT);
	glp->SetInvariantEXT = (void APIENTRY (*)(GLuint id, GLenum type, const void *addr)) ldg_find("glSetInvariantEXT", lib);
	GL_CHECK(glp->SetInvariantEXT);
	glp->SetLocalConstantEXT = (void APIENTRY (*)(GLuint id, GLenum type, const void *addr)) ldg_find("glSetLocalConstantEXT", lib);
	GL_CHECK(glp->SetLocalConstantEXT);
	glp->VariantbvEXT = (void APIENTRY (*)(GLuint id, const GLbyte *addr)) ldg_find("glVariantbvEXT", lib);
	GL_CHECK(glp->VariantbvEXT);
	glp->VariantsvEXT = (void APIENTRY (*)(GLuint id, const GLshort *addr)) ldg_find("glVariantsvEXT", lib);
	GL_CHECK(glp->VariantsvEXT);
	glp->VariantivEXT = (void APIENTRY (*)(GLuint id, const GLint *addr)) ldg_find("glVariantivEXT", lib);
	GL_CHECK(glp->VariantivEXT);
	glp->VariantfvEXT = (void APIENTRY (*)(GLuint id, const GLfloat *addr)) ldg_find("glVariantfvEXT", lib);
	GL_CHECK(glp->VariantfvEXT);
	glp->VariantdvEXT = (void APIENTRY (*)(GLuint id, const GLdouble *addr)) ldg_find("glVariantdvEXT", lib);
	GL_CHECK(glp->VariantdvEXT);
	glp->VariantubvEXT = (void APIENTRY (*)(GLuint id, const GLubyte *addr)) ldg_find("glVariantubvEXT", lib);
	GL_CHECK(glp->VariantubvEXT);
	glp->VariantusvEXT = (void APIENTRY (*)(GLuint id, const GLushort *addr)) ldg_find("glVariantusvEXT", lib);
	GL_CHECK(glp->VariantusvEXT);
	glp->VariantuivEXT = (void APIENTRY (*)(GLuint id, const GLuint *addr)) ldg_find("glVariantuivEXT", lib);
	GL_CHECK(glp->VariantuivEXT);
	glp->VariantPointerEXT = (void APIENTRY (*)(GLuint id, GLenum type, GLuint stride, const void *addr)) ldg_find("glVariantPointerEXT", lib);
	GL_CHECK(glp->VariantPointerEXT);
	glp->EnableVariantClientStateEXT = (void APIENTRY (*)(GLuint id)) ldg_find("glEnableVariantClientStateEXT", lib);
	GL_CHECK(glp->EnableVariantClientStateEXT);
	glp->DisableVariantClientStateEXT = (void APIENTRY (*)(GLuint id)) ldg_find("glDisableVariantClientStateEXT", lib);
	GL_CHECK(glp->DisableVariantClientStateEXT);
	glp->BindLightParameterEXT = (GLuint APIENTRY (*)(GLenum light, GLenum value)) ldg_find("glBindLightParameterEXT", lib);
	GL_CHECK(glp->BindLightParameterEXT);
	glp->BindMaterialParameterEXT = (GLuint APIENTRY (*)(GLenum face, GLenum value)) ldg_find("glBindMaterialParameterEXT", lib);
	GL_CHECK(glp->BindMaterialParameterEXT);
	glp->BindTexGenParameterEXT = (GLuint APIENTRY (*)(GLenum unit, GLenum coord, GLenum value)) ldg_find("glBindTexGenParameterEXT", lib);
	GL_CHECK(glp->BindTexGenParameterEXT);
	glp->BindTextureUnitParameterEXT = (GLuint APIENTRY (*)(GLenum unit, GLenum value)) ldg_find("glBindTextureUnitParameterEXT", lib);
	GL_CHECK(glp->BindTextureUnitParameterEXT);
	glp->BindParameterEXT = (GLuint APIENTRY (*)(GLenum value)) ldg_find("glBindParameterEXT", lib);
	GL_CHECK(glp->BindParameterEXT);
	glp->IsVariantEnabledEXT = (GLboolean APIENTRY (*)(GLuint id, GLenum cap)) ldg_find("glIsVariantEnabledEXT", lib);
	GL_CHECK(glp->IsVariantEnabledEXT);
	glp->GetVariantBooleanvEXT = (void APIENTRY (*)(GLuint id, GLenum value, GLboolean *data)) ldg_find("glGetVariantBooleanvEXT", lib);
	GL_CHECK(glp->GetVariantBooleanvEXT);
	glp->GetVariantIntegervEXT = (void APIENTRY (*)(GLuint id, GLenum value, GLint *data)) ldg_find("glGetVariantIntegervEXT", lib);
	GL_CHECK(glp->GetVariantIntegervEXT);
	glp->GetVariantFloatvEXT = (void APIENTRY (*)(GLuint id, GLenum value, GLfloat *data)) ldg_find("glGetVariantFloatvEXT", lib);
	GL_CHECK(glp->GetVariantFloatvEXT);
	glp->GetVariantPointervEXT = (void APIENTRY (*)(GLuint id, GLenum value, void * *data)) ldg_find("glGetVariantPointervEXT", lib);
	GL_CHECK(glp->GetVariantPointervEXT);
	glp->GetInvariantBooleanvEXT = (void APIENTRY (*)(GLuint id, GLenum value, GLboolean *data)) ldg_find("glGetInvariantBooleanvEXT", lib);
	GL_CHECK(glp->GetInvariantBooleanvEXT);
	glp->GetInvariantIntegervEXT = (void APIENTRY (*)(GLuint id, GLenum value, GLint *data)) ldg_find("glGetInvariantIntegervEXT", lib);
	GL_CHECK(glp->GetInvariantIntegervEXT);
	glp->GetInvariantFloatvEXT = (void APIENTRY (*)(GLuint id, GLenum value, GLfloat *data)) ldg_find("glGetInvariantFloatvEXT", lib);
	GL_CHECK(glp->GetInvariantFloatvEXT);
	glp->GetLocalConstantBooleanvEXT = (void APIENTRY (*)(GLuint id, GLenum value, GLboolean *data)) ldg_find("glGetLocalConstantBooleanvEXT", lib);
	GL_CHECK(glp->GetLocalConstantBooleanvEXT);
	glp->GetLocalConstantIntegervEXT = (void APIENTRY (*)(GLuint id, GLenum value, GLint *data)) ldg_find("glGetLocalConstantIntegervEXT", lib);
	GL_CHECK(glp->GetLocalConstantIntegervEXT);
	glp->GetLocalConstantFloatvEXT = (void APIENTRY (*)(GLuint id, GLenum value, GLfloat *data)) ldg_find("glGetLocalConstantFloatvEXT", lib);
	GL_CHECK(glp->GetLocalConstantFloatvEXT);
	glp->VertexStream1sATI = (void APIENTRY (*)(GLenum stream, GLshort32 x)) ldg_find("glVertexStream1sATI", lib);
	GL_CHECK(glp->VertexStream1sATI);
	glp->VertexStream1svATI = (void APIENTRY (*)(GLenum stream, const GLshort *coords)) ldg_find("glVertexStream1svATI", lib);
	GL_CHECK(glp->VertexStream1svATI);
	glp->VertexStream1iATI = (void APIENTRY (*)(GLenum stream, GLint x)) ldg_find("glVertexStream1iATI", lib);
	GL_CHECK(glp->VertexStream1iATI);
	glp->VertexStream1ivATI = (void APIENTRY (*)(GLenum stream, const GLint *coords)) ldg_find("glVertexStream1ivATI", lib);
	GL_CHECK(glp->VertexStream1ivATI);
	glp->VertexStream1fATI = (void APIENTRY (*)(GLenum stream, GLfloat x)) ldg_find("glVertexStream1fATI", lib);
	GL_CHECK(glp->VertexStream1fATI);
	glp->VertexStream1fvATI = (void APIENTRY (*)(GLenum stream, const GLfloat *coords)) ldg_find("glVertexStream1fvATI", lib);
	GL_CHECK(glp->VertexStream1fvATI);
	glp->VertexStream1dATI = (void APIENTRY (*)(GLenum stream, GLdouble x)) ldg_find("glVertexStream1dATI", lib);
	GL_CHECK(glp->VertexStream1dATI);
	glp->VertexStream1dvATI = (void APIENTRY (*)(GLenum stream, const GLdouble *coords)) ldg_find("glVertexStream1dvATI", lib);
	GL_CHECK(glp->VertexStream1dvATI);
	glp->VertexStream2sATI = (void APIENTRY (*)(GLenum stream, GLshort32 x, GLshort32 y)) ldg_find("glVertexStream2sATI", lib);
	GL_CHECK(glp->VertexStream2sATI);
	glp->VertexStream2svATI = (void APIENTRY (*)(GLenum stream, const GLshort *coords)) ldg_find("glVertexStream2svATI", lib);
	GL_CHECK(glp->VertexStream2svATI);
	glp->VertexStream2iATI = (void APIENTRY (*)(GLenum stream, GLint x, GLint y)) ldg_find("glVertexStream2iATI", lib);
	GL_CHECK(glp->VertexStream2iATI);
	glp->VertexStream2ivATI = (void APIENTRY (*)(GLenum stream, const GLint *coords)) ldg_find("glVertexStream2ivATI", lib);
	GL_CHECK(glp->VertexStream2ivATI);
	glp->VertexStream2fATI = (void APIENTRY (*)(GLenum stream, GLfloat x, GLfloat y)) ldg_find("glVertexStream2fATI", lib);
	GL_CHECK(glp->VertexStream2fATI);
	glp->VertexStream2fvATI = (void APIENTRY (*)(GLenum stream, const GLfloat *coords)) ldg_find("glVertexStream2fvATI", lib);
	GL_CHECK(glp->VertexStream2fvATI);
	glp->VertexStream2dATI = (void APIENTRY (*)(GLenum stream, GLdouble x, GLdouble y)) ldg_find("glVertexStream2dATI", lib);
	GL_CHECK(glp->VertexStream2dATI);
	glp->VertexStream2dvATI = (void APIENTRY (*)(GLenum stream, const GLdouble *coords)) ldg_find("glVertexStream2dvATI", lib);
	GL_CHECK(glp->VertexStream2dvATI);
	glp->VertexStream3sATI = (void APIENTRY (*)(GLenum stream, GLshort32 x, GLshort32 y, GLshort32 z)) ldg_find("glVertexStream3sATI", lib);
	GL_CHECK(glp->VertexStream3sATI);
	glp->VertexStream3svATI = (void APIENTRY (*)(GLenum stream, const GLshort *coords)) ldg_find("glVertexStream3svATI", lib);
	GL_CHECK(glp->VertexStream3svATI);
	glp->VertexStream3iATI = (void APIENTRY (*)(GLenum stream, GLint x, GLint y, GLint z)) ldg_find("glVertexStream3iATI", lib);
	GL_CHECK(glp->VertexStream3iATI);
	glp->VertexStream3ivATI = (void APIENTRY (*)(GLenum stream, const GLint *coords)) ldg_find("glVertexStream3ivATI", lib);
	GL_CHECK(glp->VertexStream3ivATI);
	glp->VertexStream3fATI = (void APIENTRY (*)(GLenum stream, GLfloat x, GLfloat y, GLfloat z)) ldg_find("glVertexStream3fATI", lib);
	GL_CHECK(glp->VertexStream3fATI);
	glp->VertexStream3fvATI = (void APIENTRY (*)(GLenum stream, const GLfloat *coords)) ldg_find("glVertexStream3fvATI", lib);
	GL_CHECK(glp->VertexStream3fvATI);
	glp->VertexStream3dATI = (void APIENTRY (*)(GLenum stream, GLdouble x, GLdouble y, GLdouble z)) ldg_find("glVertexStream3dATI", lib);
	GL_CHECK(glp->VertexStream3dATI);
	glp->VertexStream3dvATI = (void APIENTRY (*)(GLenum stream, const GLdouble *coords)) ldg_find("glVertexStream3dvATI", lib);
	GL_CHECK(glp->VertexStream3dvATI);
	glp->VertexStream4sATI = (void APIENTRY (*)(GLenum stream, GLshort32 x, GLshort32 y, GLshort32 z, GLshort32 w)) ldg_find("glVertexStream4sATI", lib);
	GL_CHECK(glp->VertexStream4sATI);
	glp->VertexStream4svATI = (void APIENTRY (*)(GLenum stream, const GLshort *coords)) ldg_find("glVertexStream4svATI", lib);
	GL_CHECK(glp->VertexStream4svATI);
	glp->VertexStream4iATI = (void APIENTRY (*)(GLenum stream, GLint x, GLint y, GLint z, GLint w)) ldg_find("glVertexStream4iATI", lib);
	GL_CHECK(glp->VertexStream4iATI);
	glp->VertexStream4ivATI = (void APIENTRY (*)(GLenum stream, const GLint *coords)) ldg_find("glVertexStream4ivATI", lib);
	GL_CHECK(glp->VertexStream4ivATI);
	glp->VertexStream4fATI = (void APIENTRY (*)(GLenum stream, GLfloat x, GLfloat y, GLfloat z, GLfloat w)) ldg_find("glVertexStream4fATI", lib);
	GL_CHECK(glp->VertexStream4fATI);
	glp->VertexStream4fvATI = (void APIENTRY (*)(GLenum stream, const GLfloat *coords)) ldg_find("glVertexStream4fvATI", lib);
	GL_CHECK(glp->VertexStream4fvATI);
	glp->VertexStream4dATI = (void APIENTRY (*)(GLenum stream, GLdouble x, GLdouble y, GLdouble z, GLdouble w)) ldg_find("glVertexStream4dATI", lib);
	GL_CHECK(glp->VertexStream4dATI);
	glp->VertexStream4dvATI = (void APIENTRY (*)(GLenum stream, const GLdouble *coords)) ldg_find("glVertexStream4dvATI", lib);
	GL_CHECK(glp->VertexStream4dvATI);
	glp->NormalStream3bATI = (void APIENTRY (*)(GLenum stream, GLbyte32 nx, GLbyte32 ny, GLbyte32 nz)) ldg_find("glNormalStream3bATI", lib);
	GL_CHECK(glp->NormalStream3bATI);
	glp->NormalStream3bvATI = (void APIENTRY (*)(GLenum stream, const GLbyte *coords)) ldg_find("glNormalStream3bvATI", lib);
	GL_CHECK(glp->NormalStream3bvATI);
	glp->NormalStream3sATI = (void APIENTRY (*)(GLenum stream, GLshort32 nx, GLshort32 ny, GLshort32 nz)) ldg_find("glNormalStream3sATI", lib);
	GL_CHECK(glp->NormalStream3sATI);
	glp->NormalStream3svATI = (void APIENTRY (*)(GLenum stream, const GLshort *coords)) ldg_find("glNormalStream3svATI", lib);
	GL_CHECK(glp->NormalStream3svATI);
	glp->NormalStream3iATI = (void APIENTRY (*)(GLenum stream, GLint nx, GLint ny, GLint nz)) ldg_find("glNormalStream3iATI", lib);
	GL_CHECK(glp->NormalStream3iATI);
	glp->NormalStream3ivATI = (void APIENTRY (*)(GLenum stream, const GLint *coords)) ldg_find("glNormalStream3ivATI", lib);
	GL_CHECK(glp->NormalStream3ivATI);
	glp->NormalStream3fATI = (void APIENTRY (*)(GLenum stream, GLfloat nx, GLfloat ny, GLfloat nz)) ldg_find("glNormalStream3fATI", lib);
	GL_CHECK(glp->NormalStream3fATI);
	glp->NormalStream3fvATI = (void APIENTRY (*)(GLenum stream, const GLfloat *coords)) ldg_find("glNormalStream3fvATI", lib);
	GL_CHECK(glp->NormalStream3fvATI);
	glp->NormalStream3dATI = (void APIENTRY (*)(GLenum stream, GLdouble nx, GLdouble ny, GLdouble nz)) ldg_find("glNormalStream3dATI", lib);
	GL_CHECK(glp->NormalStream3dATI);
	glp->NormalStream3dvATI = (void APIENTRY (*)(GLenum stream, const GLdouble *coords)) ldg_find("glNormalStream3dvATI", lib);
	GL_CHECK(glp->NormalStream3dvATI);
	glp->ClientActiveVertexStreamATI = (void APIENTRY (*)(GLenum stream)) ldg_find("glClientActiveVertexStreamATI", lib);
	GL_CHECK(glp->ClientActiveVertexStreamATI);
	glp->VertexBlendEnviATI = (void APIENTRY (*)(GLenum pname, GLint param)) ldg_find("glVertexBlendEnviATI", lib);
	GL_CHECK(glp->VertexBlendEnviATI);
	glp->VertexBlendEnvfATI = (void APIENTRY (*)(GLenum pname, GLfloat param)) ldg_find("glVertexBlendEnvfATI", lib);
	GL_CHECK(glp->VertexBlendEnvfATI);
	glp->ElementPointerATI = (void APIENTRY (*)(GLenum type, const void *pointer)) ldg_find("glElementPointerATI", lib);
	GL_CHECK(glp->ElementPointerATI);
	glp->DrawElementArrayATI = (void APIENTRY (*)(GLenum mode, GLsizei count)) ldg_find("glDrawElementArrayATI", lib);
	GL_CHECK(glp->DrawElementArrayATI);
	glp->DrawRangeElementArrayATI = (void APIENTRY (*)(GLenum mode, GLuint start, GLuint end, GLsizei count)) ldg_find("glDrawRangeElementArrayATI", lib);
	GL_CHECK(glp->DrawRangeElementArrayATI);
	glp->DrawMeshArraysSUN = (void APIENTRY (*)(GLenum mode, GLint first, GLsizei count, GLsizei width)) ldg_find("glDrawMeshArraysSUN", lib);
	GL_CHECK(glp->DrawMeshArraysSUN);
	glp->GenOcclusionQueriesNV = (void APIENTRY (*)(GLsizei n, GLuint *ids)) ldg_find("glGenOcclusionQueriesNV", lib);
	GL_CHECK(glp->GenOcclusionQueriesNV);
	glp->DeleteOcclusionQueriesNV = (void APIENTRY (*)(GLsizei n, const GLuint *ids)) ldg_find("glDeleteOcclusionQueriesNV", lib);
	GL_CHECK(glp->DeleteOcclusionQueriesNV);
	glp->IsOcclusionQueryNV = (GLboolean APIENTRY (*)(GLuint id)) ldg_find("glIsOcclusionQueryNV", lib);
	GL_CHECK(glp->IsOcclusionQueryNV);
	glp->BeginOcclusionQueryNV = (void APIENTRY (*)(GLuint id)) ldg_find("glBeginOcclusionQueryNV", lib);
	GL_CHECK(glp->BeginOcclusionQueryNV);
	glp->EndOcclusionQueryNV = (void APIENTRY (*)(void)) ldg_find("glEndOcclusionQueryNV", lib);
	GL_CHECK(glp->EndOcclusionQueryNV);
	glp->GetOcclusionQueryivNV = (void APIENTRY (*)(GLuint id, GLenum pname, GLint *params)) ldg_find("glGetOcclusionQueryivNV", lib);
	GL_CHECK(glp->GetOcclusionQueryivNV);
	glp->GetOcclusionQueryuivNV = (void APIENTRY (*)(GLuint id, GLenum pname, GLuint *params)) ldg_find("glGetOcclusionQueryuivNV", lib);
	GL_CHECK(glp->GetOcclusionQueryuivNV);
	glp->PointParameteriNV = (void APIENTRY (*)(GLenum pname, GLint param)) ldg_find("glPointParameteriNV", lib);
	GL_CHECK(glp->PointParameteriNV);
	glp->PointParameterivNV = (void APIENTRY (*)(GLenum pname, const GLint *params)) ldg_find("glPointParameterivNV", lib);
	GL_CHECK(glp->PointParameterivNV);
	glp->ActiveStencilFaceEXT = (void APIENTRY (*)(GLenum face)) ldg_find("glActiveStencilFaceEXT", lib);
	GL_CHECK(glp->ActiveStencilFaceEXT);
	glp->ElementPointerAPPLE = (void APIENTRY (*)(GLenum type, const void *pointer)) ldg_find("glElementPointerAPPLE", lib);
	GL_CHECK(glp->ElementPointerAPPLE);
	glp->DrawElementArrayAPPLE = (void APIENTRY (*)(GLenum mode, GLint first, GLsizei count)) ldg_find("glDrawElementArrayAPPLE", lib);
	GL_CHECK(glp->DrawElementArrayAPPLE);
	glp->DrawRangeElementArrayAPPLE = (void APIENTRY (*)(GLenum mode, GLuint start, GLuint end, GLint first, GLsizei count)) ldg_find("glDrawRangeElementArrayAPPLE", lib);
	GL_CHECK(glp->DrawRangeElementArrayAPPLE);
	glp->MultiDrawElementArrayAPPLE = (void APIENTRY (*)(GLenum mode, const GLint *first, const GLsizei *count, GLsizei primcount)) ldg_find("glMultiDrawElementArrayAPPLE", lib);
	GL_CHECK(glp->MultiDrawElementArrayAPPLE);
	glp->MultiDrawRangeElementArrayAPPLE = (void APIENTRY (*)(GLenum mode, GLuint start, GLuint end, const GLint *first, const GLsizei *count, GLsizei primcount)) ldg_find("glMultiDrawRangeElementArrayAPPLE", lib);
	GL_CHECK(glp->MultiDrawRangeElementArrayAPPLE);
	glp->GenFencesAPPLE = (void APIENTRY (*)(GLsizei n, GLuint *fences)) ldg_find("glGenFencesAPPLE", lib);
	GL_CHECK(glp->GenFencesAPPLE);
	glp->DeleteFencesAPPLE = (void APIENTRY (*)(GLsizei n, const GLuint *fences)) ldg_find("glDeleteFencesAPPLE", lib);
	GL_CHECK(glp->DeleteFencesAPPLE);
	glp->SetFenceAPPLE = (void APIENTRY (*)(GLuint fence)) ldg_find("glSetFenceAPPLE", lib);
	GL_CHECK(glp->SetFenceAPPLE);
	glp->IsFenceAPPLE = (GLboolean APIENTRY (*)(GLuint fence)) ldg_find("glIsFenceAPPLE", lib);
	GL_CHECK(glp->IsFenceAPPLE);
	glp->TestFenceAPPLE = (GLboolean APIENTRY (*)(GLuint fence)) ldg_find("glTestFenceAPPLE", lib);
	GL_CHECK(glp->TestFenceAPPLE);
	glp->FinishFenceAPPLE = (void APIENTRY (*)(GLuint fence)) ldg_find("glFinishFenceAPPLE", lib);
	GL_CHECK(glp->FinishFenceAPPLE);
	glp->TestObjectAPPLE = (GLboolean APIENTRY (*)(GLenum object, GLuint name)) ldg_find("glTestObjectAPPLE", lib);
	GL_CHECK(glp->TestObjectAPPLE);
	glp->FinishObjectAPPLE = (void APIENTRY (*)(GLenum object, GLuint name)) ldg_find("glFinishObjectAPPLE", lib);
	GL_CHECK(glp->FinishObjectAPPLE);
	glp->BindVertexArrayAPPLE = (void APIENTRY (*)(GLuint array)) ldg_find("glBindVertexArrayAPPLE", lib);
	GL_CHECK(glp->BindVertexArrayAPPLE);
	glp->DeleteVertexArraysAPPLE = (void APIENTRY (*)(GLsizei n, const GLuint *arrays)) ldg_find("glDeleteVertexArraysAPPLE", lib);
	GL_CHECK(glp->DeleteVertexArraysAPPLE);
	glp->GenVertexArraysAPPLE = (void APIENTRY (*)(GLsizei n, GLuint *arrays)) ldg_find("glGenVertexArraysAPPLE", lib);
	GL_CHECK(glp->GenVertexArraysAPPLE);
	glp->IsVertexArrayAPPLE = (GLboolean APIENTRY (*)(GLuint array)) ldg_find("glIsVertexArrayAPPLE", lib);
	GL_CHECK(glp->IsVertexArrayAPPLE);
	glp->VertexArrayRangeAPPLE = (void APIENTRY (*)(GLsizei length, void *pointer)) ldg_find("glVertexArrayRangeAPPLE", lib);
	GL_CHECK(glp->VertexArrayRangeAPPLE);
	glp->FlushVertexArrayRangeAPPLE = (void APIENTRY (*)(GLsizei length, void *pointer)) ldg_find("glFlushVertexArrayRangeAPPLE", lib);
	GL_CHECK(glp->FlushVertexArrayRangeAPPLE);
	glp->VertexArrayParameteriAPPLE = (void APIENTRY (*)(GLenum pname, GLint param)) ldg_find("glVertexArrayParameteriAPPLE", lib);
	GL_CHECK(glp->VertexArrayParameteriAPPLE);
	glp->DrawBuffersATI = (void APIENTRY (*)(GLsizei n, const GLenum *bufs)) ldg_find("glDrawBuffersATI", lib);
	GL_CHECK(glp->DrawBuffersATI);
	glp->ProgramNamedParameter4fNV = (void APIENTRY (*)(GLuint id, GLsizei len, const GLubyte *name, GLfloat x, GLfloat y, GLfloat z, GLfloat w)) ldg_find("glProgramNamedParameter4fNV", lib);
	GL_CHECK(glp->ProgramNamedParameter4fNV);
	glp->ProgramNamedParameter4dNV = (void APIENTRY (*)(GLuint id, GLsizei len, const GLubyte *name, GLdouble x, GLdouble y, GLdouble z, GLdouble w)) ldg_find("glProgramNamedParameter4dNV", lib);
	GL_CHECK(glp->ProgramNamedParameter4dNV);
	glp->ProgramNamedParameter4fvNV = (void APIENTRY (*)(GLuint id, GLsizei len, const GLubyte *name, const GLfloat *v)) ldg_find("glProgramNamedParameter4fvNV", lib);
	GL_CHECK(glp->ProgramNamedParameter4fvNV);
	glp->ProgramNamedParameter4dvNV = (void APIENTRY (*)(GLuint id, GLsizei len, const GLubyte *name, const GLdouble *v)) ldg_find("glProgramNamedParameter4dvNV", lib);
	GL_CHECK(glp->ProgramNamedParameter4dvNV);
	glp->GetProgramNamedParameterfvNV = (void APIENTRY (*)(GLuint id, GLsizei len, const GLubyte *name, GLfloat *params)) ldg_find("glGetProgramNamedParameterfvNV", lib);
	GL_CHECK(glp->GetProgramNamedParameterfvNV);
	glp->GetProgramNamedParameterdvNV = (void APIENTRY (*)(GLuint id, GLsizei len, const GLubyte *name, GLdouble *params)) ldg_find("glGetProgramNamedParameterdvNV", lib);
	GL_CHECK(glp->GetProgramNamedParameterdvNV);
	glp->Vertex2hNV = (void APIENTRY (*)(GLhalfNV32 x, GLhalfNV32 y)) ldg_find("glVertex2hNV", lib);
	GL_CHECK(glp->Vertex2hNV);
	glp->Vertex2hvNV = (void APIENTRY (*)(const GLhalfNV *v)) ldg_find("glVertex2hvNV", lib);
	GL_CHECK(glp->Vertex2hvNV);
	glp->Vertex3hNV = (void APIENTRY (*)(GLhalfNV32 x, GLhalfNV32 y, GLhalfNV32 z)) ldg_find("glVertex3hNV", lib);
	GL_CHECK(glp->Vertex3hNV);
	glp->Vertex3hvNV = (void APIENTRY (*)(const GLhalfNV *v)) ldg_find("glVertex3hvNV", lib);
	GL_CHECK(glp->Vertex3hvNV);
	glp->Vertex4hNV = (void APIENTRY (*)(GLhalfNV32 x, GLhalfNV32 y, GLhalfNV32 z, GLhalfNV32 w)) ldg_find("glVertex4hNV", lib);
	GL_CHECK(glp->Vertex4hNV);
	glp->Vertex4hvNV = (void APIENTRY (*)(const GLhalfNV *v)) ldg_find("glVertex4hvNV", lib);
	GL_CHECK(glp->Vertex4hvNV);
	glp->Normal3hNV = (void APIENTRY (*)(GLhalfNV32 nx, GLhalfNV32 ny, GLhalfNV32 nz)) ldg_find("glNormal3hNV", lib);
	GL_CHECK(glp->Normal3hNV);
	glp->Normal3hvNV = (void APIENTRY (*)(const GLhalfNV *v)) ldg_find("glNormal3hvNV", lib);
	GL_CHECK(glp->Normal3hvNV);
	glp->Color3hNV = (void APIENTRY (*)(GLhalfNV32 red, GLhalfNV32 green, GLhalfNV32 blue)) ldg_find("glColor3hNV", lib);
	GL_CHECK(glp->Color3hNV);
	glp->Color3hvNV = (void APIENTRY (*)(const GLhalfNV *v)) ldg_find("glColor3hvNV", lib);
	GL_CHECK(glp->Color3hvNV);
	glp->Color4hNV = (void APIENTRY (*)(GLhalfNV32 red, GLhalfNV32 green, GLhalfNV32 blue, GLhalfNV32 alpha)) ldg_find("glColor4hNV", lib);
	GL_CHECK(glp->Color4hNV);
	glp->Color4hvNV = (void APIENTRY (*)(const GLhalfNV *v)) ldg_find("glColor4hvNV", lib);
	GL_CHECK(glp->Color4hvNV);
	glp->TexCoord1hNV = (void APIENTRY (*)(GLhalfNV32 s)) ldg_find("glTexCoord1hNV", lib);
	GL_CHECK(glp->TexCoord1hNV);
	glp->TexCoord1hvNV = (void APIENTRY (*)(const GLhalfNV *v)) ldg_find("glTexCoord1hvNV", lib);
	GL_CHECK(glp->TexCoord1hvNV);
	glp->TexCoord2hNV = (void APIENTRY (*)(GLhalfNV32 s, GLhalfNV32 t)) ldg_find("glTexCoord2hNV", lib);
	GL_CHECK(glp->TexCoord2hNV);
	glp->TexCoord2hvNV = (void APIENTRY (*)(const GLhalfNV *v)) ldg_find("glTexCoord2hvNV", lib);
	GL_CHECK(glp->TexCoord2hvNV);
	glp->TexCoord3hNV = (void APIENTRY (*)(GLhalfNV32 s, GLhalfNV32 t, GLhalfNV32 r)) ldg_find("glTexCoord3hNV", lib);
	GL_CHECK(glp->TexCoord3hNV);
	glp->TexCoord3hvNV = (void APIENTRY (*)(const GLhalfNV *v)) ldg_find("glTexCoord3hvNV", lib);
	GL_CHECK(glp->TexCoord3hvNV);
	glp->TexCoord4hNV = (void APIENTRY (*)(GLhalfNV32 s, GLhalfNV32 t, GLhalfNV32 r, GLhalfNV32 q)) ldg_find("glTexCoord4hNV", lib);
	GL_CHECK(glp->TexCoord4hNV);
	glp->TexCoord4hvNV = (void APIENTRY (*)(const GLhalfNV *v)) ldg_find("glTexCoord4hvNV", lib);
	GL_CHECK(glp->TexCoord4hvNV);
	glp->MultiTexCoord1hNV = (void APIENTRY (*)(GLenum target, GLhalfNV32 s)) ldg_find("glMultiTexCoord1hNV", lib);
	GL_CHECK(glp->MultiTexCoord1hNV);
	glp->MultiTexCoord1hvNV = (void APIENTRY (*)(GLenum target, const GLhalfNV *v)) ldg_find("glMultiTexCoord1hvNV", lib);
	GL_CHECK(glp->MultiTexCoord1hvNV);
	glp->MultiTexCoord2hNV = (void APIENTRY (*)(GLenum target, GLhalfNV32 s, GLhalfNV32 t)) ldg_find("glMultiTexCoord2hNV", lib);
	GL_CHECK(glp->MultiTexCoord2hNV);
	glp->MultiTexCoord2hvNV = (void APIENTRY (*)(GLenum target, const GLhalfNV *v)) ldg_find("glMultiTexCoord2hvNV", lib);
	GL_CHECK(glp->MultiTexCoord2hvNV);
	glp->MultiTexCoord3hNV = (void APIENTRY (*)(GLenum target, GLhalfNV32 s, GLhalfNV32 t, GLhalfNV32 r)) ldg_find("glMultiTexCoord3hNV", lib);
	GL_CHECK(glp->MultiTexCoord3hNV);
	glp->MultiTexCoord3hvNV = (void APIENTRY (*)(GLenum target, const GLhalfNV *v)) ldg_find("glMultiTexCoord3hvNV", lib);
	GL_CHECK(glp->MultiTexCoord3hvNV);
	glp->MultiTexCoord4hNV = (void APIENTRY (*)(GLenum target, GLhalfNV32 s, GLhalfNV32 t, GLhalfNV32 r, GLhalfNV32 q)) ldg_find("glMultiTexCoord4hNV", lib);
	GL_CHECK(glp->MultiTexCoord4hNV);
	glp->MultiTexCoord4hvNV = (void APIENTRY (*)(GLenum target, const GLhalfNV *v)) ldg_find("glMultiTexCoord4hvNV", lib);
	GL_CHECK(glp->MultiTexCoord4hvNV);
	glp->FogCoordhNV = (void APIENTRY (*)(GLhalfNV32 fog)) ldg_find("glFogCoordhNV", lib);
	GL_CHECK(glp->FogCoordhNV);
	glp->FogCoordhvNV = (void APIENTRY (*)(const GLhalfNV *fog)) ldg_find("glFogCoordhvNV", lib);
	GL_CHECK(glp->FogCoordhvNV);
	glp->SecondaryColor3hNV = (void APIENTRY (*)(GLhalfNV32 red, GLhalfNV32 green, GLhalfNV32 blue)) ldg_find("glSecondaryColor3hNV", lib);
	GL_CHECK(glp->SecondaryColor3hNV);
	glp->SecondaryColor3hvNV = (void APIENTRY (*)(const GLhalfNV *v)) ldg_find("glSecondaryColor3hvNV", lib);
	GL_CHECK(glp->SecondaryColor3hvNV);
	glp->VertexWeighthNV = (void APIENTRY (*)(GLhalfNV32 weight)) ldg_find("glVertexWeighthNV", lib);
	GL_CHECK(glp->VertexWeighthNV);
	glp->VertexWeighthvNV = (void APIENTRY (*)(const GLhalfNV *weight)) ldg_find("glVertexWeighthvNV", lib);
	GL_CHECK(glp->VertexWeighthvNV);
	glp->VertexAttrib1hNV = (void APIENTRY (*)(GLuint index, GLhalfNV32 x)) ldg_find("glVertexAttrib1hNV", lib);
	GL_CHECK(glp->VertexAttrib1hNV);
	glp->VertexAttrib1hvNV = (void APIENTRY (*)(GLuint index, const GLhalfNV *v)) ldg_find("glVertexAttrib1hvNV", lib);
	GL_CHECK(glp->VertexAttrib1hvNV);
	glp->VertexAttrib2hNV = (void APIENTRY (*)(GLuint index, GLhalfNV32 x, GLhalfNV32 y)) ldg_find("glVertexAttrib2hNV", lib);
	GL_CHECK(glp->VertexAttrib2hNV);
	glp->VertexAttrib2hvNV = (void APIENTRY (*)(GLuint index, const GLhalfNV *v)) ldg_find("glVertexAttrib2hvNV", lib);
	GL_CHECK(glp->VertexAttrib2hvNV);
	glp->VertexAttrib3hNV = (void APIENTRY (*)(GLuint index, GLhalfNV32 x, GLhalfNV32 y, GLhalfNV32 z)) ldg_find("glVertexAttrib3hNV", lib);
	GL_CHECK(glp->VertexAttrib3hNV);
	glp->VertexAttrib3hvNV = (void APIENTRY (*)(GLuint index, const GLhalfNV *v)) ldg_find("glVertexAttrib3hvNV", lib);
	GL_CHECK(glp->VertexAttrib3hvNV);
	glp->VertexAttrib4hNV = (void APIENTRY (*)(GLuint index, GLhalfNV32 x, GLhalfNV32 y, GLhalfNV32 z, GLhalfNV32 w)) ldg_find("glVertexAttrib4hNV", lib);
	GL_CHECK(glp->VertexAttrib4hNV);
	glp->VertexAttrib4hvNV = (void APIENTRY (*)(GLuint index, const GLhalfNV *v)) ldg_find("glVertexAttrib4hvNV", lib);
	GL_CHECK(glp->VertexAttrib4hvNV);
	glp->VertexAttribs1hvNV = (void APIENTRY (*)(GLuint index, GLsizei n, const GLhalfNV *v)) ldg_find("glVertexAttribs1hvNV", lib);
	GL_CHECK(glp->VertexAttribs1hvNV);
	glp->VertexAttribs2hvNV = (void APIENTRY (*)(GLuint index, GLsizei n, const GLhalfNV *v)) ldg_find("glVertexAttribs2hvNV", lib);
	GL_CHECK(glp->VertexAttribs2hvNV);
	glp->VertexAttribs3hvNV = (void APIENTRY (*)(GLuint index, GLsizei n, const GLhalfNV *v)) ldg_find("glVertexAttribs3hvNV", lib);
	GL_CHECK(glp->VertexAttribs3hvNV);
	glp->VertexAttribs4hvNV = (void APIENTRY (*)(GLuint index, GLsizei n, const GLhalfNV *v)) ldg_find("glVertexAttribs4hvNV", lib);
	GL_CHECK(glp->VertexAttribs4hvNV);
	glp->PixelDataRangeNV = (void APIENTRY (*)(GLenum target, GLsizei length, const void *pointer)) ldg_find("glPixelDataRangeNV", lib);
	GL_CHECK(glp->PixelDataRangeNV);
	glp->FlushPixelDataRangeNV = (void APIENTRY (*)(GLenum target)) ldg_find("glFlushPixelDataRangeNV", lib);
	GL_CHECK(glp->FlushPixelDataRangeNV);
	glp->PrimitiveRestartNV = (void APIENTRY (*)(void)) ldg_find("glPrimitiveRestartNV", lib);
	GL_CHECK(glp->PrimitiveRestartNV);
	glp->PrimitiveRestartIndexNV = (void APIENTRY (*)(GLuint index)) ldg_find("glPrimitiveRestartIndexNV", lib);
	GL_CHECK(glp->PrimitiveRestartIndexNV);
	glp->MapObjectBufferATI = (void * APIENTRY (*)(GLuint buffer)) ldg_find("glMapObjectBufferATI", lib);
	GL_CHECK(glp->MapObjectBufferATI);
	glp->UnmapObjectBufferATI = (void APIENTRY (*)(GLuint buffer)) ldg_find("glUnmapObjectBufferATI", lib);
	GL_CHECK(glp->UnmapObjectBufferATI);
	glp->StencilOpSeparateATI = (void APIENTRY (*)(GLenum face, GLenum sfail, GLenum dpfail, GLenum dppass)) ldg_find("glStencilOpSeparateATI", lib);
	GL_CHECK(glp->StencilOpSeparateATI);
	glp->StencilFuncSeparateATI = (void APIENTRY (*)(GLenum frontfunc, GLenum backfunc, GLint ref, GLuint mask)) ldg_find("glStencilFuncSeparateATI", lib);
	GL_CHECK(glp->StencilFuncSeparateATI);
	glp->VertexAttribArrayObjectATI = (void APIENTRY (*)(GLuint index, GLint size, GLenum type, GLboolean32 normalized, GLsizei stride, GLuint buffer, GLuint offset)) ldg_find("glVertexAttribArrayObjectATI", lib);
	GL_CHECK(glp->VertexAttribArrayObjectATI);
	glp->GetVertexAttribArrayObjectfvATI = (void APIENTRY (*)(GLuint index, GLenum pname, GLfloat *params)) ldg_find("glGetVertexAttribArrayObjectfvATI", lib);
	GL_CHECK(glp->GetVertexAttribArrayObjectfvATI);
	glp->GetVertexAttribArrayObjectivATI = (void APIENTRY (*)(GLuint index, GLenum pname, GLint *params)) ldg_find("glGetVertexAttribArrayObjectivATI", lib);
	GL_CHECK(glp->GetVertexAttribArrayObjectivATI);
	glp->DepthBoundsEXT = (void APIENTRY (*)(GLclampd zmin, GLclampd zmax)) ldg_find("glDepthBoundsEXT", lib);
	GL_CHECK(glp->DepthBoundsEXT);
	glp->BlendEquationSeparateEXT = (void APIENTRY (*)(GLenum modeRGB, GLenum modeAlpha)) ldg_find("glBlendEquationSeparateEXT", lib);
	GL_CHECK(glp->BlendEquationSeparateEXT);
	glp->OSMesaColorClamp = (void APIENTRY (*)(GLboolean32 enable)) ldg_find("OSMesaColorClamp", lib);
	GL_CHECK(glp->OSMesaColorClamp);
	glp->OSMesaPostprocess = (void APIENTRY (*)(OSMesaContext osmesa, const char *filter, GLuint enable_value)) ldg_find("OSMesaPostprocess", lib);
	GL_CHECK(glp->OSMesaPostprocess);
	glp->OSMesaCreateLDG = (void * APIENTRY (*)(GLenum format, GLenum type, GLint width, GLint height)) ldg_find("OSMesaCreateLDG", lib);
	GL_CHECK(glp->OSMesaCreateLDG);
	glp->OSMesaDestroyLDG = (void APIENTRY (*)(void)) ldg_find("OSMesaDestroyLDG", lib);
	GL_CHECK(glp->OSMesaDestroyLDG);
	glp->max_width = (GLsizei APIENTRY (*)(void)) ldg_find("max_width", lib);
	GL_CHECK(glp->max_width);
	glp->max_height = (GLsizei APIENTRY (*)(void)) ldg_find("max_height", lib);
	GL_CHECK(glp->max_height);
	glp->information = (void APIENTRY (*)(void)) ldg_find("information", lib);
	GL_CHECK(glp->information);
	glp->exception_error = (void APIENTRY (*)(void (CALLBACK *exception)(GLenum param) )) ldg_find("exception_error", lib);
	GL_CHECK(glp->exception_error);
	glp->gluLookAtf = (void APIENTRY (*)(GLfloat eyeX, GLfloat eyeY, GLfloat eyeZ, GLfloat centerX, GLfloat centerY, GLfloat centerZ, GLfloat upX, GLfloat upY, GLfloat upZ)) ldg_find("gluLookAt", lib);
	GL_CHECK(glp->gluLookAtf);
	glp->Frustumf = (void APIENTRY (*)(GLfloat left, GLfloat right, GLfloat bottom, GLfloat top, GLfloat near_val, GLfloat far_val)) ldg_find("glFrustum", lib);
	GL_CHECK(glp->Frustumf);
	glp->Orthof = (void APIENTRY (*)(GLfloat left, GLfloat right, GLfloat bottom, GLfloat top, GLfloat near_val, GLfloat far_val)) ldg_find("glOrtho", lib);
	GL_CHECK(glp->Orthof);
	glp->swapbuffer = (void APIENTRY (*)(void *buffer)) ldg_find("swapbuffer", lib);
	GL_CHECK(glp->swapbuffer);
	glp->gluLookAt = (void APIENTRY (*)(GLdouble eyeX, GLdouble eyeY, GLdouble eyeZ, GLdouble centerX, GLdouble centerY, GLdouble centerZ, GLdouble upX, GLdouble upY, GLdouble upZ)) ldg_find("gluLookAtd", lib);
	GL_CHECK(glp->gluLookAt);
	glp->AccumxOES = (void APIENTRY (*)(GLenum op, GLfixed value)) ldg_find("glAccumxOES", lib);
	GL_CHECK(glp->AccumxOES);
	glp->ActiveProgramEXT = (void APIENTRY (*)(GLuint program)) ldg_find("glActiveProgramEXT", lib);
	GL_CHECK(glp->ActiveProgramEXT);
	glp->ActiveShaderProgram = (void APIENTRY (*)(GLuint pipeline, GLuint program)) ldg_find("glActiveShaderProgram", lib);
	GL_CHECK(glp->ActiveShaderProgram);
	glp->ActiveVaryingNV = (void APIENTRY (*)(GLuint program, const GLchar *name)) ldg_find("glActiveVaryingNV", lib);
	GL_CHECK(glp->ActiveVaryingNV);
	glp->AddSwapHintRectWIN = (void APIENTRY (*)(GLint x, GLint y, GLsizei width, GLsizei height)) ldg_find("glAddSwapHintRectWIN", lib);
	GL_CHECK(glp->AddSwapHintRectWIN);
	glp->AlphaFuncxOES = (void APIENTRY (*)(GLenum func, GLfixed ref)) ldg_find("glAlphaFuncxOES", lib);
	GL_CHECK(glp->AlphaFuncxOES);
	glp->AttachShader = (void APIENTRY (*)(GLuint program, GLuint shader)) ldg_find("glAttachShader", lib);
	GL_CHECK(glp->AttachShader);
	glp->BeginConditionalRender = (void APIENTRY (*)(GLuint id, GLenum mode)) ldg_find("glBeginConditionalRender", lib);
	GL_CHECK(glp->BeginConditionalRender);
	glp->BeginConditionalRenderNV = (void APIENTRY (*)(GLuint id, GLenum mode)) ldg_find("glBeginConditionalRenderNV", lib);
	GL_CHECK(glp->BeginConditionalRenderNV);
	glp->BeginConditionalRenderNVX = (void APIENTRY (*)(GLuint id)) ldg_find("glBeginConditionalRenderNVX", lib);
	GL_CHECK(glp->BeginConditionalRenderNVX);
	glp->BeginPerfMonitorAMD = (void APIENTRY (*)(GLuint monitor)) ldg_find("glBeginPerfMonitorAMD", lib);
	GL_CHECK(glp->BeginPerfMonitorAMD);
	glp->BeginPerfQueryINTEL = (void APIENTRY (*)(GLuint queryHandle)) ldg_find("glBeginPerfQueryINTEL", lib);
	GL_CHECK(glp->BeginPerfQueryINTEL);
	glp->BeginQueryIndexed = (void APIENTRY (*)(GLenum target, GLuint index, GLuint id)) ldg_find("glBeginQueryIndexed", lib);
	GL_CHECK(glp->BeginQueryIndexed);
	glp->BeginTransformFeedback = (void APIENTRY (*)(GLenum primitiveMode)) ldg_find("glBeginTransformFeedback", lib);
	GL_CHECK(glp->BeginTransformFeedback);
	glp->BeginTransformFeedbackEXT = (void APIENTRY (*)(GLenum primitiveMode)) ldg_find("glBeginTransformFeedbackEXT", lib);
	GL_CHECK(glp->BeginTransformFeedbackEXT);
	glp->BeginTransformFeedbackNV = (void APIENTRY (*)(GLenum primitiveMode)) ldg_find("glBeginTransformFeedbackNV", lib);
	GL_CHECK(glp->BeginTransformFeedbackNV);
	glp->BeginVideoCaptureNV = (void APIENTRY (*)(GLuint video_capture_slot)) ldg_find("glBeginVideoCaptureNV", lib);
	GL_CHECK(glp->BeginVideoCaptureNV);
	glp->BindAttribLocation = (void APIENTRY (*)(GLuint program, GLuint index, const GLchar *name)) ldg_find("glBindAttribLocation", lib);
	GL_CHECK(glp->BindAttribLocation);
	glp->BindBufferBase = (void APIENTRY (*)(GLenum target, GLuint index, GLuint buffer)) ldg_find("glBindBufferBase", lib);
	GL_CHECK(glp->BindBufferBase);
	glp->BindBufferBaseEXT = (void APIENTRY (*)(GLenum target, GLuint index, GLuint buffer)) ldg_find("glBindBufferBaseEXT", lib);
	GL_CHECK(glp->BindBufferBaseEXT);
	glp->BindBufferBaseNV = (void APIENTRY (*)(GLenum target, GLuint index, GLuint buffer)) ldg_find("glBindBufferBaseNV", lib);
	GL_CHECK(glp->BindBufferBaseNV);
	glp->BindBufferOffsetEXT = (void APIENTRY (*)(GLenum target, GLuint index, GLuint buffer, GLintptr offset)) ldg_find("glBindBufferOffsetEXT", lib);
	GL_CHECK(glp->BindBufferOffsetEXT);
	glp->BindBufferOffsetNV = (void APIENTRY (*)(GLenum target, GLuint index, GLuint buffer, GLintptr offset)) ldg_find("glBindBufferOffsetNV", lib);
	GL_CHECK(glp->BindBufferOffsetNV);
	glp->BindBufferRange = (void APIENTRY (*)(GLenum target, GLuint index, GLuint buffer, GLintptr offset, GLsizeiptr size)) ldg_find("glBindBufferRange", lib);
	GL_CHECK(glp->BindBufferRange);
	glp->BindBufferRangeEXT = (void APIENTRY (*)(GLenum target, GLuint index, GLuint buffer, GLintptr offset, GLsizeiptr size)) ldg_find("glBindBufferRangeEXT", lib);
	GL_CHECK(glp->BindBufferRangeEXT);
	glp->BindBufferRangeNV = (void APIENTRY (*)(GLenum target, GLuint index, GLuint buffer, GLintptr offset, GLsizeiptr size)) ldg_find("glBindBufferRangeNV", lib);
	GL_CHECK(glp->BindBufferRangeNV);
	glp->BindBuffersBase = (void APIENTRY (*)(GLenum target, GLuint first, GLsizei count, const GLuint *buffers)) ldg_find("glBindBuffersBase", lib);
	GL_CHECK(glp->BindBuffersBase);
	glp->BindBuffersRange = (void APIENTRY (*)(GLenum target, GLuint first, GLsizei count, const GLuint *buffers, const GLintptr *offsets, const GLsizeiptr *sizes)) ldg_find("glBindBuffersRange", lib);
	GL_CHECK(glp->BindBuffersRange);
	glp->BindFragDataLocation = (void APIENTRY (*)(GLuint program, GLuint color, const GLchar *name)) ldg_find("glBindFragDataLocation", lib);
	GL_CHECK(glp->BindFragDataLocation);
	glp->BindFragDataLocationEXT = (void APIENTRY (*)(GLuint program, GLuint color, const GLchar *name)) ldg_find("glBindFragDataLocationEXT", lib);
	GL_CHECK(glp->BindFragDataLocationEXT);
	glp->BindFragDataLocationIndexed = (void APIENTRY (*)(GLuint program, GLuint colorNumber, GLuint index, const GLchar *name)) ldg_find("glBindFragDataLocationIndexed", lib);
	GL_CHECK(glp->BindFragDataLocationIndexed);
	glp->BindFramebuffer = (void APIENTRY (*)(GLenum target, GLuint framebuffer)) ldg_find("glBindFramebuffer", lib);
	GL_CHECK(glp->BindFramebuffer);
	glp->BindFramebufferEXT = (void APIENTRY (*)(GLenum target, GLuint framebuffer)) ldg_find("glBindFramebufferEXT", lib);
	GL_CHECK(glp->BindFramebufferEXT);
	glp->BindImageTexture = (void APIENTRY (*)(GLuint unit, GLuint texture, GLint level, GLboolean32 layered, GLint layer, GLenum access, GLenum format)) ldg_find("glBindImageTexture", lib);
	GL_CHECK(glp->BindImageTexture);
	glp->BindImageTextureEXT = (void APIENTRY (*)(GLuint index, GLuint texture, GLint level, GLboolean32 layered, GLint layer, GLenum access, GLint format)) ldg_find("glBindImageTextureEXT", lib);
	GL_CHECK(glp->BindImageTextureEXT);
	glp->BindImageTextures = (void APIENTRY (*)(GLuint first, GLsizei count, const GLuint *textures)) ldg_find("glBindImageTextures", lib);
	GL_CHECK(glp->BindImageTextures);
	glp->BindMultiTextureEXT = (void APIENTRY (*)(GLenum texunit, GLenum target, GLuint texture)) ldg_find("glBindMultiTextureEXT", lib);
	GL_CHECK(glp->BindMultiTextureEXT);
	glp->BindProgramPipeline = (void APIENTRY (*)(GLuint pipeline)) ldg_find("glBindProgramPipeline", lib);
	GL_CHECK(glp->BindProgramPipeline);
	glp->BindRenderbuffer = (void APIENTRY (*)(GLenum target, GLuint renderbuffer)) ldg_find("glBindRenderbuffer", lib);
	GL_CHECK(glp->BindRenderbuffer);
	glp->BindRenderbufferEXT = (void APIENTRY (*)(GLenum target, GLuint renderbuffer)) ldg_find("glBindRenderbufferEXT", lib);
	GL_CHECK(glp->BindRenderbufferEXT);
	glp->BindSampler = (void APIENTRY (*)(GLuint unit, GLuint sampler)) ldg_find("glBindSampler", lib);
	GL_CHECK(glp->BindSampler);
	glp->BindSamplers = (void APIENTRY (*)(GLuint first, GLsizei count, const GLuint *samplers)) ldg_find("glBindSamplers", lib);
	GL_CHECK(glp->BindSamplers);
	glp->BindTextures = (void APIENTRY (*)(GLuint first, GLsizei count, const GLuint *textures)) ldg_find("glBindTextures", lib);
	GL_CHECK(glp->BindTextures);
	glp->BindTransformFeedback = (void APIENTRY (*)(GLenum target, GLuint id)) ldg_find("glBindTransformFeedback", lib);
	GL_CHECK(glp->BindTransformFeedback);
	glp->BindTransformFeedbackNV = (void APIENTRY (*)(GLenum target, GLuint id)) ldg_find("glBindTransformFeedbackNV", lib);
	GL_CHECK(glp->BindTransformFeedbackNV);
	glp->BindVertexArray = (void APIENTRY (*)(GLuint array)) ldg_find("glBindVertexArray", lib);
	GL_CHECK(glp->BindVertexArray);
	glp->BindVertexBuffer = (void APIENTRY (*)(GLuint bindingindex, GLuint buffer, GLintptr offset, GLsizei stride)) ldg_find("glBindVertexBuffer", lib);
	GL_CHECK(glp->BindVertexBuffer);
	glp->BindVertexBuffers = (void APIENTRY (*)(GLuint first, GLsizei count, const GLuint *buffers, const GLintptr *offsets, const GLsizei *strides)) ldg_find("glBindVertexBuffers", lib);
	GL_CHECK(glp->BindVertexBuffers);
	glp->BindVideoCaptureStreamBufferNV = (void APIENTRY (*)(GLuint video_capture_slot, GLuint stream, GLenum frame_region, GLintptrARB offset)) ldg_find("glBindVideoCaptureStreamBufferNV", lib);
	GL_CHECK(glp->BindVideoCaptureStreamBufferNV);
	glp->BindVideoCaptureStreamTextureNV = (void APIENTRY (*)(GLuint video_capture_slot, GLuint stream, GLenum frame_region, GLenum target, GLuint texture)) ldg_find("glBindVideoCaptureStreamTextureNV", lib);
	GL_CHECK(glp->BindVideoCaptureStreamTextureNV);
	glp->BitmapxOES = (void APIENTRY (*)(GLsizei width, GLsizei height, GLfixed xorig, GLfixed yorig, GLfixed xmove, GLfixed ymove, const GLubyte *bitmap)) ldg_find("glBitmapxOES", lib);
	GL_CHECK(glp->BitmapxOES);
	glp->BlendBarrierNV = (void APIENTRY (*)(void)) ldg_find("glBlendBarrierNV", lib);
	GL_CHECK(glp->BlendBarrierNV);
	glp->BlendColorxOES = (void APIENTRY (*)(GLfixed red, GLfixed green, GLfixed blue, GLfixed alpha)) ldg_find("glBlendColorxOES", lib);
	GL_CHECK(glp->BlendColorxOES);
	glp->BlendEquationIndexedAMD = (void APIENTRY (*)(GLuint buf, GLenum mode)) ldg_find("glBlendEquationIndexedAMD", lib);
	GL_CHECK(glp->BlendEquationIndexedAMD);
	glp->BlendEquationSeparate = (void APIENTRY (*)(GLenum modeRGB, GLenum modeAlpha)) ldg_find("glBlendEquationSeparate", lib);
	GL_CHECK(glp->BlendEquationSeparate);
	glp->BlendEquationSeparateIndexedAMD = (void APIENTRY (*)(GLuint buf, GLenum modeRGB, GLenum modeAlpha)) ldg_find("glBlendEquationSeparateIndexedAMD", lib);
	GL_CHECK(glp->BlendEquationSeparateIndexedAMD);
	glp->BlendEquationSeparatei = (void APIENTRY (*)(GLuint buf, GLenum modeRGB, GLenum modeAlpha)) ldg_find("glBlendEquationSeparatei", lib);
	GL_CHECK(glp->BlendEquationSeparatei);
	glp->BlendEquationSeparateiARB = (void APIENTRY (*)(GLuint buf, GLenum modeRGB, GLenum modeAlpha)) ldg_find("glBlendEquationSeparateiARB", lib);
	GL_CHECK(glp->BlendEquationSeparateiARB);
	glp->BlendEquationi = (void APIENTRY (*)(GLuint buf, GLenum mode)) ldg_find("glBlendEquationi", lib);
	GL_CHECK(glp->BlendEquationi);
	glp->BlendEquationiARB = (void APIENTRY (*)(GLuint buf, GLenum mode)) ldg_find("glBlendEquationiARB", lib);
	GL_CHECK(glp->BlendEquationiARB);
	glp->BlendFuncIndexedAMD = (void APIENTRY (*)(GLuint buf, GLenum src, GLenum dst)) ldg_find("glBlendFuncIndexedAMD", lib);
	GL_CHECK(glp->BlendFuncIndexedAMD);
	glp->BlendFuncSeparateIndexedAMD = (void APIENTRY (*)(GLuint buf, GLenum srcRGB, GLenum dstRGB, GLenum srcAlpha, GLenum dstAlpha)) ldg_find("glBlendFuncSeparateIndexedAMD", lib);
	GL_CHECK(glp->BlendFuncSeparateIndexedAMD);
	glp->BlendFuncSeparatei = (void APIENTRY (*)(GLuint buf, GLenum srcRGB, GLenum dstRGB, GLenum srcAlpha, GLenum dstAlpha)) ldg_find("glBlendFuncSeparatei", lib);
	GL_CHECK(glp->BlendFuncSeparatei);
	glp->BlendFuncSeparateiARB = (void APIENTRY (*)(GLuint buf, GLenum srcRGB, GLenum dstRGB, GLenum srcAlpha, GLenum dstAlpha)) ldg_find("glBlendFuncSeparateiARB", lib);
	GL_CHECK(glp->BlendFuncSeparateiARB);
	glp->BlendFunci = (void APIENTRY (*)(GLuint buf, GLenum src, GLenum dst)) ldg_find("glBlendFunci", lib);
	GL_CHECK(glp->BlendFunci);
	glp->BlendFunciARB = (void APIENTRY (*)(GLuint buf, GLenum src, GLenum dst)) ldg_find("glBlendFunciARB", lib);
	GL_CHECK(glp->BlendFunciARB);
	glp->BlendParameteriNV = (void APIENTRY (*)(GLenum pname, GLint value)) ldg_find("glBlendParameteriNV", lib);
	GL_CHECK(glp->BlendParameteriNV);
	glp->BlitFramebuffer = (void APIENTRY (*)(GLint srcX0, GLint srcY0, GLint srcX1, GLint srcY1, GLint dstX0, GLint dstY0, GLint dstX1, GLint dstY1, GLbitfield mask, GLenum filter)) ldg_find("glBlitFramebuffer", lib);
	GL_CHECK(glp->BlitFramebuffer);
	glp->BlitFramebufferEXT = (void APIENTRY (*)(GLint srcX0, GLint srcY0, GLint srcX1, GLint srcY1, GLint dstX0, GLint dstY0, GLint dstX1, GLint dstY1, GLbitfield mask, GLenum filter)) ldg_find("glBlitFramebufferEXT", lib);
	GL_CHECK(glp->BlitFramebufferEXT);
	glp->BufferAddressRangeNV = (void APIENTRY (*)(GLenum pname, GLuint index, GLuint64EXT address, GLsizeiptr length)) ldg_find("glBufferAddressRangeNV", lib);
	GL_CHECK(glp->BufferAddressRangeNV);
	glp->BufferParameteriAPPLE = (void APIENTRY (*)(GLenum target, GLenum pname, GLint param)) ldg_find("glBufferParameteriAPPLE", lib);
	GL_CHECK(glp->BufferParameteriAPPLE);
	glp->BufferStorage = (void APIENTRY (*)(GLenum target, GLsizeiptr size, const void *data, GLbitfield flags)) ldg_find("glBufferStorage", lib);
	GL_CHECK(glp->BufferStorage);
	glp->CheckFramebufferStatus = (GLenum APIENTRY (*)(GLenum target)) ldg_find("glCheckFramebufferStatus", lib);
	GL_CHECK(glp->CheckFramebufferStatus);
	glp->CheckFramebufferStatusEXT = (GLenum APIENTRY (*)(GLenum target)) ldg_find("glCheckFramebufferStatusEXT", lib);
	GL_CHECK(glp->CheckFramebufferStatusEXT);
	glp->CheckNamedFramebufferStatusEXT = (GLenum APIENTRY (*)(GLuint framebuffer, GLenum target)) ldg_find("glCheckNamedFramebufferStatusEXT", lib);
	GL_CHECK(glp->CheckNamedFramebufferStatusEXT);
	glp->ClampColor = (void APIENTRY (*)(GLenum target, GLenum clamp)) ldg_find("glClampColor", lib);
	GL_CHECK(glp->ClampColor);
	glp->ClampColorARB = (void APIENTRY (*)(GLenum target, GLenum clamp)) ldg_find("glClampColorARB", lib);
	GL_CHECK(glp->ClampColorARB);
	glp->ClearAccumxOES = (void APIENTRY (*)(GLfixed red, GLfixed green, GLfixed blue, GLfixed alpha)) ldg_find("glClearAccumxOES", lib);
	GL_CHECK(glp->ClearAccumxOES);
	glp->ClearBufferData = (void APIENTRY (*)(GLenum target, GLenum internalformat, GLenum format, GLenum type, const void *data)) ldg_find("glClearBufferData", lib);
	GL_CHECK(glp->ClearBufferData);
	glp->ClearBufferSubData = (void APIENTRY (*)(GLenum target, GLenum internalformat, GLintptr offset, GLsizeiptr size, GLenum format, GLenum type, const void *data)) ldg_find("glClearBufferSubData", lib);
	GL_CHECK(glp->ClearBufferSubData);
	glp->ClearBufferfi = (void APIENTRY (*)(GLenum buffer, GLint drawbuffer, GLfloat depth, GLint stencil)) ldg_find("glClearBufferfi", lib);
	GL_CHECK(glp->ClearBufferfi);
	glp->ClearBufferfv = (void APIENTRY (*)(GLenum buffer, GLint drawbuffer, const GLfloat *value)) ldg_find("glClearBufferfv", lib);
	GL_CHECK(glp->ClearBufferfv);
	glp->ClearBufferiv = (void APIENTRY (*)(GLenum buffer, GLint drawbuffer, const GLint *value)) ldg_find("glClearBufferiv", lib);
	GL_CHECK(glp->ClearBufferiv);
	glp->ClearBufferuiv = (void APIENTRY (*)(GLenum buffer, GLint drawbuffer, const GLuint *value)) ldg_find("glClearBufferuiv", lib);
	GL_CHECK(glp->ClearBufferuiv);
	glp->ClearColorIiEXT = (void APIENTRY (*)(GLint red, GLint green, GLint blue, GLint alpha)) ldg_find("glClearColorIiEXT", lib);
	GL_CHECK(glp->ClearColorIiEXT);
	glp->ClearColorIuiEXT = (void APIENTRY (*)(GLuint red, GLuint green, GLuint blue, GLuint alpha)) ldg_find("glClearColorIuiEXT", lib);
	GL_CHECK(glp->ClearColorIuiEXT);
	glp->ClearColorxOES = (void APIENTRY (*)(GLfixed red, GLfixed green, GLfixed blue, GLfixed alpha)) ldg_find("glClearColorxOES", lib);
	GL_CHECK(glp->ClearColorxOES);
	glp->ClearDebugLogMESA = (void APIENTRY (*)(GLhandleARB obj, GLenum logType, GLenum shaderType)) ldg_find("glClearDebugLogMESA", lib);
	GL_CHECK(glp->ClearDebugLogMESA);
	glp->ClearDepthdNV = (void APIENTRY (*)(GLdouble depth)) ldg_find("glClearDepthdNV", lib);
	GL_CHECK(glp->ClearDepthdNV);
	glp->ClearDepthf = (void APIENTRY (*)(GLfloat d)) ldg_find("glClearDepth", lib);
	GL_CHECK(glp->ClearDepthf);
	glp->ClearDepthfOES = (void APIENTRY (*)(GLclampf depth)) ldg_find("glClearDepthfOES", lib);
	GL_CHECK(glp->ClearDepthfOES);
	glp->ClearDepthxOES = (void APIENTRY (*)(GLfixed depth)) ldg_find("glClearDepthxOES", lib);
	GL_CHECK(glp->ClearDepthxOES);
	glp->ClearNamedBufferDataEXT = (void APIENTRY (*)(GLuint buffer, GLenum internalformat, GLenum format, GLenum type, const void *data)) ldg_find("glClearNamedBufferDataEXT", lib);
	GL_CHECK(glp->ClearNamedBufferDataEXT);
	glp->ClearNamedBufferSubDataEXT = (void APIENTRY (*)(GLuint buffer, GLenum internalformat, GLsizeiptr offset, GLsizeiptr size, GLenum format, GLenum type, const void *data)) ldg_find("glClearNamedBufferSubDataEXT", lib);
	GL_CHECK(glp->ClearNamedBufferSubDataEXT);
	glp->ClearTexImage = (void APIENTRY (*)(GLuint texture, GLint level, GLenum format, GLenum type, const void *data)) ldg_find("glClearTexImage", lib);
	GL_CHECK(glp->ClearTexImage);
	glp->ClearTexSubImage = (void APIENTRY (*)(GLuint texture, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLenum type, const void *data)) ldg_find("glClearTexSubImage", lib);
	GL_CHECK(glp->ClearTexSubImage);
	glp->ClientAttribDefaultEXT = (void APIENTRY (*)(GLbitfield mask)) ldg_find("glClientAttribDefaultEXT", lib);
	GL_CHECK(glp->ClientAttribDefaultEXT);
	glp->ClientWaitSync = (GLenum APIENTRY (*)(GLsync sync, GLbitfield flags, GLuint64 timeout)) ldg_find("glClientWaitSync", lib);
	GL_CHECK(glp->ClientWaitSync);
	glp->ClipPlanefOES = (void APIENTRY (*)(GLenum plane, const GLfloat *equation)) ldg_find("glClipPlanefOES", lib);
	GL_CHECK(glp->ClipPlanefOES);
	glp->ClipPlanexOES = (void APIENTRY (*)(GLenum plane, const GLfixed *equation)) ldg_find("glClipPlanexOES", lib);
	GL_CHECK(glp->ClipPlanexOES);
	glp->Color3xOES = (void APIENTRY (*)(GLfixed red, GLfixed green, GLfixed blue)) ldg_find("glColor3xOES", lib);
	GL_CHECK(glp->Color3xOES);
	glp->Color3xvOES = (void APIENTRY (*)(const GLfixed *components)) ldg_find("glColor3xvOES", lib);
	GL_CHECK(glp->Color3xvOES);
	glp->Color4xOES = (void APIENTRY (*)(GLfixed red, GLfixed green, GLfixed blue, GLfixed alpha)) ldg_find("glColor4xOES", lib);
	GL_CHECK(glp->Color4xOES);
	glp->Color4xvOES = (void APIENTRY (*)(const GLfixed *components)) ldg_find("glColor4xvOES", lib);
	GL_CHECK(glp->Color4xvOES);
	glp->ColorFormatNV = (void APIENTRY (*)(GLint size, GLenum type, GLsizei stride)) ldg_find("glColorFormatNV", lib);
	GL_CHECK(glp->ColorFormatNV);
	glp->ColorMaskIndexedEXT = (void APIENTRY (*)(GLuint index, GLboolean32 r, GLboolean32 g, GLboolean32 b, GLboolean32 a)) ldg_find("glColorMaskIndexedEXT", lib);
	GL_CHECK(glp->ColorMaskIndexedEXT);
	glp->ColorMaski = (void APIENTRY (*)(GLuint index, GLboolean32 r, GLboolean32 g, GLboolean32 b, GLboolean32 a)) ldg_find("glColorMaski", lib);
	GL_CHECK(glp->ColorMaski);
	glp->ColorP3ui = (void APIENTRY (*)(GLenum type, GLuint color)) ldg_find("glColorP3ui", lib);
	GL_CHECK(glp->ColorP3ui);
	glp->ColorP3uiv = (void APIENTRY (*)(GLenum type, const GLuint *color)) ldg_find("glColorP3uiv", lib);
	GL_CHECK(glp->ColorP3uiv);
	glp->ColorP4ui = (void APIENTRY (*)(GLenum type, GLuint color)) ldg_find("glColorP4ui", lib);
	GL_CHECK(glp->ColorP4ui);
	glp->ColorP4uiv = (void APIENTRY (*)(GLenum type, const GLuint *color)) ldg_find("glColorP4uiv", lib);
	GL_CHECK(glp->ColorP4uiv);
	glp->CompileShader = (void APIENTRY (*)(GLuint shader)) ldg_find("glCompileShader", lib);
	GL_CHECK(glp->CompileShader);
	glp->CompileShaderIncludeARB = (void APIENTRY (*)(GLuint shader, GLsizei count, const GLchar *const *path, const GLint *length)) ldg_find("glCompileShaderIncludeARB", lib);
	GL_CHECK(glp->CompileShaderIncludeARB);
	glp->CompressedMultiTexImage1DEXT = (void APIENTRY (*)(GLenum texunit, GLenum target, GLint level, GLenum internalformat, GLsizei width, GLint border, GLsizei imageSize, const void *bits)) ldg_find("glCompressedMultiTexImage1DEXT", lib);
	GL_CHECK(glp->CompressedMultiTexImage1DEXT);
	glp->CompressedMultiTexImage2DEXT = (void APIENTRY (*)(GLenum texunit, GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLint border, GLsizei imageSize, const void *bits)) ldg_find("glCompressedMultiTexImage2DEXT", lib);
	GL_CHECK(glp->CompressedMultiTexImage2DEXT);
	glp->CompressedMultiTexImage3DEXT = (void APIENTRY (*)(GLenum texunit, GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLsizei imageSize, const void *bits)) ldg_find("glCompressedMultiTexImage3DEXT", lib);
	GL_CHECK(glp->CompressedMultiTexImage3DEXT);
	glp->CompressedMultiTexSubImage1DEXT = (void APIENTRY (*)(GLenum texunit, GLenum target, GLint level, GLint xoffset, GLsizei width, GLenum format, GLsizei imageSize, const void *bits)) ldg_find("glCompressedMultiTexSubImage1DEXT", lib);
	GL_CHECK(glp->CompressedMultiTexSubImage1DEXT);
	glp->CompressedMultiTexSubImage2DEXT = (void APIENTRY (*)(GLenum texunit, GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLsizei imageSize, const void *bits)) ldg_find("glCompressedMultiTexSubImage2DEXT", lib);
	GL_CHECK(glp->CompressedMultiTexSubImage2DEXT);
	glp->CompressedMultiTexSubImage3DEXT = (void APIENTRY (*)(GLenum texunit, GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLsizei imageSize, const void *bits)) ldg_find("glCompressedMultiTexSubImage3DEXT", lib);
	GL_CHECK(glp->CompressedMultiTexSubImage3DEXT);
	glp->CompressedTextureImage1DEXT = (void APIENTRY (*)(GLuint texture, GLenum target, GLint level, GLenum internalformat, GLsizei width, GLint border, GLsizei imageSize, const void *bits)) ldg_find("glCompressedTextureImage1DEXT", lib);
	GL_CHECK(glp->CompressedTextureImage1DEXT);
	glp->CompressedTextureImage2DEXT = (void APIENTRY (*)(GLuint texture, GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLint border, GLsizei imageSize, const void *bits)) ldg_find("glCompressedTextureImage2DEXT", lib);
	GL_CHECK(glp->CompressedTextureImage2DEXT);
	glp->CompressedTextureImage3DEXT = (void APIENTRY (*)(GLuint texture, GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLsizei imageSize, const void *bits)) ldg_find("glCompressedTextureImage3DEXT", lib);
	GL_CHECK(glp->CompressedTextureImage3DEXT);
	glp->CompressedTextureSubImage1DEXT = (void APIENTRY (*)(GLuint texture, GLenum target, GLint level, GLint xoffset, GLsizei width, GLenum format, GLsizei imageSize, const void *bits)) ldg_find("glCompressedTextureSubImage1DEXT", lib);
	GL_CHECK(glp->CompressedTextureSubImage1DEXT);
	glp->CompressedTextureSubImage2DEXT = (void APIENTRY (*)(GLuint texture, GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLsizei imageSize, const void *bits)) ldg_find("glCompressedTextureSubImage2DEXT", lib);
	GL_CHECK(glp->CompressedTextureSubImage2DEXT);
	glp->CompressedTextureSubImage3DEXT = (void APIENTRY (*)(GLuint texture, GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLsizei imageSize, const void *bits)) ldg_find("glCompressedTextureSubImage3DEXT", lib);
	GL_CHECK(glp->CompressedTextureSubImage3DEXT);
	glp->ConvolutionParameterxOES = (void APIENTRY (*)(GLenum target, GLenum pname, GLfixed param)) ldg_find("glConvolutionParameterxOES", lib);
	GL_CHECK(glp->ConvolutionParameterxOES);
	glp->ConvolutionParameterxvOES = (void APIENTRY (*)(GLenum target, GLenum pname, const GLfixed *params)) ldg_find("glConvolutionParameterxvOES", lib);
	GL_CHECK(glp->ConvolutionParameterxvOES);
	glp->CopyBufferSubData = (void APIENTRY (*)(GLenum readTarget, GLenum writeTarget, GLintptr readOffset, GLintptr writeOffset, GLsizeiptr size)) ldg_find("glCopyBufferSubData", lib);
	GL_CHECK(glp->CopyBufferSubData);
	glp->CopyImageSubData = (void APIENTRY (*)(GLuint srcName, GLenum srcTarget, GLint srcLevel, GLint srcX, GLint srcY, GLint srcZ, GLuint dstName, GLenum dstTarget, GLint dstLevel, GLint dstX, GLint dstY, GLint dstZ, GLsizei srcWidth, GLsizei srcHeight, GLsizei srcDepth)) ldg_find("glCopyImageSubData", lib);
	GL_CHECK(glp->CopyImageSubData);
	glp->CopyImageSubDataNV = (void APIENTRY (*)(GLuint srcName, GLenum srcTarget, GLint srcLevel, GLint srcX, GLint srcY, GLint srcZ, GLuint dstName, GLenum dstTarget, GLint dstLevel, GLint dstX, GLint dstY, GLint dstZ, GLsizei width, GLsizei height, GLsizei depth)) ldg_find("glCopyImageSubDataNV", lib);
	GL_CHECK(glp->CopyImageSubDataNV);
	glp->CopyMultiTexImage1DEXT = (void APIENTRY (*)(GLenum texunit, GLenum target, GLint level, GLenum internalformat, GLint x, GLint y, GLsizei width, GLint border)) ldg_find("glCopyMultiTexImage1DEXT", lib);
	GL_CHECK(glp->CopyMultiTexImage1DEXT);
	glp->CopyMultiTexImage2DEXT = (void APIENTRY (*)(GLenum texunit, GLenum target, GLint level, GLenum internalformat, GLint x, GLint y, GLsizei width, GLsizei height, GLint border)) ldg_find("glCopyMultiTexImage2DEXT", lib);
	GL_CHECK(glp->CopyMultiTexImage2DEXT);
	glp->CopyMultiTexSubImage1DEXT = (void APIENTRY (*)(GLenum texunit, GLenum target, GLint level, GLint xoffset, GLint x, GLint y, GLsizei width)) ldg_find("glCopyMultiTexSubImage1DEXT", lib);
	GL_CHECK(glp->CopyMultiTexSubImage1DEXT);
	glp->CopyMultiTexSubImage2DEXT = (void APIENTRY (*)(GLenum texunit, GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint x, GLint y, GLsizei width, GLsizei height)) ldg_find("glCopyMultiTexSubImage2DEXT", lib);
	GL_CHECK(glp->CopyMultiTexSubImage2DEXT);
	glp->CopyMultiTexSubImage3DEXT = (void APIENTRY (*)(GLenum texunit, GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLint x, GLint y, GLsizei width, GLsizei height)) ldg_find("glCopyMultiTexSubImage3DEXT", lib);
	GL_CHECK(glp->CopyMultiTexSubImage3DEXT);
	glp->CopyPathNV = (void APIENTRY (*)(GLuint resultPath, GLuint srcPath)) ldg_find("glCopyPathNV", lib);
	GL_CHECK(glp->CopyPathNV);
	glp->CopyTextureImage1DEXT = (void APIENTRY (*)(GLuint texture, GLenum target, GLint level, GLenum internalformat, GLint x, GLint y, GLsizei width, GLint border)) ldg_find("glCopyTextureImage1DEXT", lib);
	GL_CHECK(glp->CopyTextureImage1DEXT);
	glp->CopyTextureImage2DEXT = (void APIENTRY (*)(GLuint texture, GLenum target, GLint level, GLenum internalformat, GLint x, GLint y, GLsizei width, GLsizei height, GLint border)) ldg_find("glCopyTextureImage2DEXT", lib);
	GL_CHECK(glp->CopyTextureImage2DEXT);
	glp->CopyTextureSubImage1DEXT = (void APIENTRY (*)(GLuint texture, GLenum target, GLint level, GLint xoffset, GLint x, GLint y, GLsizei width)) ldg_find("glCopyTextureSubImage1DEXT", lib);
	GL_CHECK(glp->CopyTextureSubImage1DEXT);
	glp->CopyTextureSubImage2DEXT = (void APIENTRY (*)(GLuint texture, GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint x, GLint y, GLsizei width, GLsizei height)) ldg_find("glCopyTextureSubImage2DEXT", lib);
	GL_CHECK(glp->CopyTextureSubImage2DEXT);
	glp->CopyTextureSubImage3DEXT = (void APIENTRY (*)(GLuint texture, GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLint x, GLint y, GLsizei width, GLsizei height)) ldg_find("glCopyTextureSubImage3DEXT", lib);
	GL_CHECK(glp->CopyTextureSubImage3DEXT);
	glp->CoverFillPathInstancedNV = (void APIENTRY (*)(GLsizei numPaths, GLenum pathNameType, const void *paths, GLuint pathBase, GLenum coverMode, GLenum transformType, const GLfloat *transformValues)) ldg_find("glCoverFillPathInstancedNV", lib);
	GL_CHECK(glp->CoverFillPathInstancedNV);
	glp->CoverFillPathNV = (void APIENTRY (*)(GLuint path, GLenum coverMode)) ldg_find("glCoverFillPathNV", lib);
	GL_CHECK(glp->CoverFillPathNV);
	glp->CoverStrokePathInstancedNV = (void APIENTRY (*)(GLsizei numPaths, GLenum pathNameType, const void *paths, GLuint pathBase, GLenum coverMode, GLenum transformType, const GLfloat *transformValues)) ldg_find("glCoverStrokePathInstancedNV", lib);
	GL_CHECK(glp->CoverStrokePathInstancedNV);
	glp->CoverStrokePathNV = (void APIENTRY (*)(GLuint path, GLenum coverMode)) ldg_find("glCoverStrokePathNV", lib);
	GL_CHECK(glp->CoverStrokePathNV);
	glp->CreateDebugObjectMESA = (GLhandleARB APIENTRY (*)(void)) ldg_find("glCreateDebugObjectMESA", lib);
	GL_CHECK(glp->CreateDebugObjectMESA);
	glp->CreatePerfQueryINTEL = (void APIENTRY (*)(GLuint queryId, GLuint *queryHandle)) ldg_find("glCreatePerfQueryINTEL", lib);
	GL_CHECK(glp->CreatePerfQueryINTEL);
	glp->CreateProgram = (GLuint APIENTRY (*)(void)) ldg_find("glCreateProgram", lib);
	GL_CHECK(glp->CreateProgram);
	glp->CreateShader = (GLuint APIENTRY (*)(GLenum type)) ldg_find("glCreateShader", lib);
	GL_CHECK(glp->CreateShader);
	glp->CreateShaderProgramEXT = (GLuint APIENTRY (*)(GLenum type, const GLchar *string)) ldg_find("glCreateShaderProgramEXT", lib);
	GL_CHECK(glp->CreateShaderProgramEXT);
	glp->CreateShaderProgramv = (GLuint APIENTRY (*)(GLenum type, GLsizei count, const GLchar *const *strings)) ldg_find("glCreateShaderProgramv", lib);
	GL_CHECK(glp->CreateShaderProgramv);
	glp->CreateSyncFromCLeventARB = (GLsync APIENTRY (*)(struct _cl_context *context, struct _cl_event *event, GLbitfield flags)) ldg_find("glCreateSyncFromCLeventARB", lib);
	GL_CHECK(glp->CreateSyncFromCLeventARB);
	glp->DebugMessageCallback = (void APIENTRY (*)(GLDEBUGPROC callback, const void *userParam)) ldg_find("glDebugMessageCallback", lib);
	GL_CHECK(glp->DebugMessageCallback);
	glp->DebugMessageCallbackAMD = (void APIENTRY (*)(GLDEBUGPROCAMD callback, void *userParam)) ldg_find("glDebugMessageCallbackAMD", lib);
	GL_CHECK(glp->DebugMessageCallbackAMD);
	glp->DebugMessageCallbackARB = (void APIENTRY (*)(GLDEBUGPROCARB callback, const void *userParam)) ldg_find("glDebugMessageCallbackARB", lib);
	GL_CHECK(glp->DebugMessageCallbackARB);
	glp->DebugMessageControl = (void APIENTRY (*)(GLenum source, GLenum type, GLenum severity, GLsizei count, const GLuint *ids, GLboolean32 enabled)) ldg_find("glDebugMessageControl", lib);
	GL_CHECK(glp->DebugMessageControl);
	glp->DebugMessageControlARB = (void APIENTRY (*)(GLenum source, GLenum type, GLenum severity, GLsizei count, const GLuint *ids, GLboolean32 enabled)) ldg_find("glDebugMessageControlARB", lib);
	GL_CHECK(glp->DebugMessageControlARB);
	glp->DebugMessageEnableAMD = (void APIENTRY (*)(GLenum category, GLenum severity, GLsizei count, const GLuint *ids, GLboolean32 enabled)) ldg_find("glDebugMessageEnableAMD", lib);
	GL_CHECK(glp->DebugMessageEnableAMD);
	glp->DebugMessageInsert = (void APIENTRY (*)(GLenum source, GLenum type, GLuint id, GLenum severity, GLsizei length, const GLchar *buf)) ldg_find("glDebugMessageInsert", lib);
	GL_CHECK(glp->DebugMessageInsert);
	glp->DebugMessageInsertAMD = (void APIENTRY (*)(GLenum category, GLenum severity, GLuint id, GLsizei length, const GLchar *buf)) ldg_find("glDebugMessageInsertAMD", lib);
	GL_CHECK(glp->DebugMessageInsertAMD);
	glp->DebugMessageInsertARB = (void APIENTRY (*)(GLenum source, GLenum type, GLuint id, GLenum severity, GLsizei length, const GLchar *buf)) ldg_find("glDebugMessageInsertARB", lib);
	GL_CHECK(glp->DebugMessageInsertARB);
	glp->DeleteFramebuffers = (void APIENTRY (*)(GLsizei n, const GLuint *framebuffers)) ldg_find("glDeleteFramebuffers", lib);
	GL_CHECK(glp->DeleteFramebuffers);
	glp->DeleteFramebuffersEXT = (void APIENTRY (*)(GLsizei n, const GLuint *framebuffers)) ldg_find("glDeleteFramebuffersEXT", lib);
	GL_CHECK(glp->DeleteFramebuffersEXT);
	glp->DeleteNamedStringARB = (void APIENTRY (*)(GLint namelen, const GLchar *name)) ldg_find("glDeleteNamedStringARB", lib);
	GL_CHECK(glp->DeleteNamedStringARB);
	glp->DeleteNamesAMD = (void APIENTRY (*)(GLenum identifier, GLuint num, const GLuint *names)) ldg_find("glDeleteNamesAMD", lib);
	GL_CHECK(glp->DeleteNamesAMD);
	glp->DeleteObjectBufferATI = (void APIENTRY (*)(GLuint buffer)) ldg_find("glDeleteObjectBufferATI", lib);
	GL_CHECK(glp->DeleteObjectBufferATI);
	glp->DeletePathsNV = (void APIENTRY (*)(GLuint path, GLsizei range)) ldg_find("glDeletePathsNV", lib);
	GL_CHECK(glp->DeletePathsNV);
	glp->DeletePerfMonitorsAMD = (void APIENTRY (*)(GLsizei n, GLuint *monitors)) ldg_find("glDeletePerfMonitorsAMD", lib);
	GL_CHECK(glp->DeletePerfMonitorsAMD);
	glp->DeletePerfQueryINTEL = (void APIENTRY (*)(GLuint queryHandle)) ldg_find("glDeletePerfQueryINTEL", lib);
	GL_CHECK(glp->DeletePerfQueryINTEL);
	glp->DeleteProgram = (void APIENTRY (*)(GLuint program)) ldg_find("glDeleteProgram", lib);
	GL_CHECK(glp->DeleteProgram);
	glp->DeleteProgramPipelines = (void APIENTRY (*)(GLsizei n, const GLuint *pipelines)) ldg_find("glDeleteProgramPipelines", lib);
	GL_CHECK(glp->DeleteProgramPipelines);
	glp->DeleteRenderbuffers = (void APIENTRY (*)(GLsizei n, const GLuint *renderbuffers)) ldg_find("glDeleteRenderbuffers", lib);
	GL_CHECK(glp->DeleteRenderbuffers);
	glp->DeleteRenderbuffersEXT = (void APIENTRY (*)(GLsizei n, const GLuint *renderbuffers)) ldg_find("glDeleteRenderbuffersEXT", lib);
	GL_CHECK(glp->DeleteRenderbuffersEXT);
	glp->DeleteSamplers = (void APIENTRY (*)(GLsizei count, const GLuint *samplers)) ldg_find("glDeleteSamplers", lib);
	GL_CHECK(glp->DeleteSamplers);
	glp->DeleteShader = (void APIENTRY (*)(GLuint shader)) ldg_find("glDeleteShader", lib);
	GL_CHECK(glp->DeleteShader);
	glp->DeleteSync = (void APIENTRY (*)(GLsync sync)) ldg_find("glDeleteSync", lib);
	GL_CHECK(glp->DeleteSync);
	glp->DeleteTransformFeedbacks = (void APIENTRY (*)(GLsizei n, const GLuint *ids)) ldg_find("glDeleteTransformFeedbacks", lib);
	GL_CHECK(glp->DeleteTransformFeedbacks);
	glp->DeleteTransformFeedbacksNV = (void APIENTRY (*)(GLsizei n, const GLuint *ids)) ldg_find("glDeleteTransformFeedbacksNV", lib);
	GL_CHECK(glp->DeleteTransformFeedbacksNV);
	glp->DeleteVertexArrays = (void APIENTRY (*)(GLsizei n, const GLuint *arrays)) ldg_find("glDeleteVertexArrays", lib);
	GL_CHECK(glp->DeleteVertexArrays);
	glp->DepthBoundsdNV = (void APIENTRY (*)(GLdouble zmin, GLdouble zmax)) ldg_find("glDepthBoundsdNV", lib);
	GL_CHECK(glp->DepthBoundsdNV);
	glp->DepthRangeArrayv = (void APIENTRY (*)(GLuint first, GLsizei count, const GLdouble *v)) ldg_find("glDepthRangeArrayv", lib);
	GL_CHECK(glp->DepthRangeArrayv);
	glp->DepthRangeIndexed = (void APIENTRY (*)(GLuint index, GLdouble n, GLdouble f)) ldg_find("glDepthRangeIndexed", lib);
	GL_CHECK(glp->DepthRangeIndexed);
	glp->DepthRangedNV = (void APIENTRY (*)(GLdouble zNear, GLdouble zFar)) ldg_find("glDepthRangedNV", lib);
	GL_CHECK(glp->DepthRangedNV);
	glp->DepthRangef = (void APIENTRY (*)(GLfloat n, GLfloat f)) ldg_find("glDepthRangef", lib);
	GL_CHECK(glp->DepthRangef);
	glp->DepthRangefOES = (void APIENTRY (*)(GLclampf n, GLclampf f)) ldg_find("glDepthRangefOES", lib);
	GL_CHECK(glp->DepthRangefOES);
	glp->DepthRangexOES = (void APIENTRY (*)(GLfixed n, GLfixed f)) ldg_find("glDepthRangexOES", lib);
	GL_CHECK(glp->DepthRangexOES);
	glp->DetachShader = (void APIENTRY (*)(GLuint program, GLuint shader)) ldg_find("glDetachShader", lib);
	GL_CHECK(glp->DetachShader);
	glp->DisableClientStateIndexedEXT = (void APIENTRY (*)(GLenum array, GLuint index)) ldg_find("glDisableClientStateIndexedEXT", lib);
	GL_CHECK(glp->DisableClientStateIndexedEXT);
	glp->DisableClientStateiEXT = (void APIENTRY (*)(GLenum array, GLuint index)) ldg_find("glDisableClientStateiEXT", lib);
	GL_CHECK(glp->DisableClientStateiEXT);
	glp->DisableIndexedEXT = (void APIENTRY (*)(GLenum target, GLuint index)) ldg_find("glDisableIndexedEXT", lib);
	GL_CHECK(glp->DisableIndexedEXT);
	glp->DisableVertexArrayAttribEXT = (void APIENTRY (*)(GLuint vaobj, GLuint index)) ldg_find("glDisableVertexArrayAttribEXT", lib);
	GL_CHECK(glp->DisableVertexArrayAttribEXT);
	glp->DisableVertexArrayEXT = (void APIENTRY (*)(GLuint vaobj, GLenum array)) ldg_find("glDisableVertexArrayEXT", lib);
	GL_CHECK(glp->DisableVertexArrayEXT);
	glp->DisableVertexAttribAPPLE = (void APIENTRY (*)(GLuint index, GLenum pname)) ldg_find("glDisableVertexAttribAPPLE", lib);
	GL_CHECK(glp->DisableVertexAttribAPPLE);
	glp->DisableVertexAttribArray = (void APIENTRY (*)(GLuint index)) ldg_find("glDisableVertexAttribArray", lib);
	GL_CHECK(glp->DisableVertexAttribArray);
	glp->Disablei = (void APIENTRY (*)(GLenum target, GLuint index)) ldg_find("glDisablei", lib);
	GL_CHECK(glp->Disablei);
	glp->DispatchCompute = (void APIENTRY (*)(GLuint num_groups_x, GLuint num_groups_y, GLuint num_groups_z)) ldg_find("glDispatchCompute", lib);
	GL_CHECK(glp->DispatchCompute);
	glp->DispatchComputeGroupSizeARB = (void APIENTRY (*)(GLuint num_groups_x, GLuint num_groups_y, GLuint num_groups_z, GLuint group_size_x, GLuint group_size_y, GLuint group_size_z)) ldg_find("glDispatchComputeGroupSizeARB", lib);
	GL_CHECK(glp->DispatchComputeGroupSizeARB);
	glp->DispatchComputeIndirect = (void APIENTRY (*)(GLintptr indirect)) ldg_find("glDispatchComputeIndirect", lib);
	GL_CHECK(glp->DispatchComputeIndirect);
	glp->DrawArraysIndirect = (void APIENTRY (*)(GLenum mode, const void *indirect)) ldg_find("glDrawArraysIndirect", lib);
	GL_CHECK(glp->DrawArraysIndirect);
	glp->DrawArraysInstanced = (void APIENTRY (*)(GLenum mode, GLint first, GLsizei count, GLsizei instancecount)) ldg_find("glDrawArraysInstanced", lib);
	GL_CHECK(glp->DrawArraysInstanced);
	glp->DrawArraysInstancedARB = (void APIENTRY (*)(GLenum mode, GLint first, GLsizei count, GLsizei primcount)) ldg_find("glDrawArraysInstancedARB", lib);
	GL_CHECK(glp->DrawArraysInstancedARB);
	glp->DrawArraysInstancedBaseInstance = (void APIENTRY (*)(GLenum mode, GLint first, GLsizei count, GLsizei instancecount, GLuint baseinstance)) ldg_find("glDrawArraysInstancedBaseInstance", lib);
	GL_CHECK(glp->DrawArraysInstancedBaseInstance);
	glp->DrawArraysInstancedEXT = (void APIENTRY (*)(GLenum mode, GLint start, GLsizei count, GLsizei primcount)) ldg_find("glDrawArraysInstancedEXT", lib);
	GL_CHECK(glp->DrawArraysInstancedEXT);
	glp->DrawBuffers = (void APIENTRY (*)(GLsizei n, const GLenum *bufs)) ldg_find("glDrawBuffers", lib);
	GL_CHECK(glp->DrawBuffers);
	glp->DrawElementsBaseVertex = (void APIENTRY (*)(GLenum mode, GLsizei count, GLenum type, const void *indices, GLint basevertex)) ldg_find("glDrawElementsBaseVertex", lib);
	GL_CHECK(glp->DrawElementsBaseVertex);
	glp->DrawElementsIndirect = (void APIENTRY (*)(GLenum mode, GLenum type, const void *indirect)) ldg_find("glDrawElementsIndirect", lib);
	GL_CHECK(glp->DrawElementsIndirect);
	glp->DrawElementsInstanced = (void APIENTRY (*)(GLenum mode, GLsizei count, GLenum type, const void *indices, GLsizei instancecount)) ldg_find("glDrawElementsInstanced", lib);
	GL_CHECK(glp->DrawElementsInstanced);
	glp->DrawElementsInstancedARB = (void APIENTRY (*)(GLenum mode, GLsizei count, GLenum type, const void *indices, GLsizei primcount)) ldg_find("glDrawElementsInstancedARB", lib);
	GL_CHECK(glp->DrawElementsInstancedARB);
	glp->DrawElementsInstancedBaseInstance = (void APIENTRY (*)(GLenum mode, GLsizei count, GLenum type, const void *indices, GLsizei instancecount, GLuint baseinstance)) ldg_find("glDrawElementsInstancedBaseInstance", lib);
	GL_CHECK(glp->DrawElementsInstancedBaseInstance);
	glp->DrawElementsInstancedBaseVertex = (void APIENTRY (*)(GLenum mode, GLsizei count, GLenum type, const void *indices, GLsizei instancecount, GLint basevertex)) ldg_find("glDrawElementsInstancedBaseVertex", lib);
	GL_CHECK(glp->DrawElementsInstancedBaseVertex);
	glp->DrawElementsInstancedBaseVertexBaseInstance = (void APIENTRY (*)(GLenum mode, GLsizei count, GLenum type, const void *indices, GLsizei instancecount, GLint basevertex, GLuint baseinstance)) ldg_find("glDrawElementsInstancedBaseVertexBaseInstance", lib);
	GL_CHECK(glp->DrawElementsInstancedBaseVertexBaseInstance);
	glp->DrawElementsInstancedEXT = (void APIENTRY (*)(GLenum mode, GLsizei count, GLenum type, const void *indices, GLsizei primcount)) ldg_find("glDrawElementsInstancedEXT", lib);
	GL_CHECK(glp->DrawElementsInstancedEXT);
	glp->DrawRangeElementsBaseVertex = (void APIENTRY (*)(GLenum mode, GLuint start, GLuint end, GLsizei count, GLenum type, const void *indices, GLint basevertex)) ldg_find("glDrawRangeElementsBaseVertex", lib);
	GL_CHECK(glp->DrawRangeElementsBaseVertex);
	glp->DrawTextureNV = (void APIENTRY (*)(GLuint texture, GLuint sampler, GLfloat x0, GLfloat y0, GLfloat x1, GLfloat y1, GLfloat z, GLfloat s0, GLfloat t0, GLfloat s1, GLfloat t1)) ldg_find("glDrawTextureNV", lib);
	GL_CHECK(glp->DrawTextureNV);
	glp->DrawTransformFeedback = (void APIENTRY (*)(GLenum mode, GLuint id)) ldg_find("glDrawTransformFeedback", lib);
	GL_CHECK(glp->DrawTransformFeedback);
	glp->DrawTransformFeedbackInstanced = (void APIENTRY (*)(GLenum mode, GLuint id, GLsizei instancecount)) ldg_find("glDrawTransformFeedbackInstanced", lib);
	GL_CHECK(glp->DrawTransformFeedbackInstanced);
	glp->DrawTransformFeedbackNV = (void APIENTRY (*)(GLenum mode, GLuint id)) ldg_find("glDrawTransformFeedbackNV", lib);
	GL_CHECK(glp->DrawTransformFeedbackNV);
	glp->DrawTransformFeedbackStream = (void APIENTRY (*)(GLenum mode, GLuint id, GLuint stream)) ldg_find("glDrawTransformFeedbackStream", lib);
	GL_CHECK(glp->DrawTransformFeedbackStream);
	glp->DrawTransformFeedbackStreamInstanced = (void APIENTRY (*)(GLenum mode, GLuint id, GLuint stream, GLsizei instancecount)) ldg_find("glDrawTransformFeedbackStreamInstanced", lib);
	GL_CHECK(glp->DrawTransformFeedbackStreamInstanced);
	glp->EdgeFlagFormatNV = (void APIENTRY (*)(GLsizei stride)) ldg_find("glEdgeFlagFormatNV", lib);
	GL_CHECK(glp->EdgeFlagFormatNV);
	glp->EnableClientStateIndexedEXT = (void APIENTRY (*)(GLenum array, GLuint index)) ldg_find("glEnableClientStateIndexedEXT", lib);
	GL_CHECK(glp->EnableClientStateIndexedEXT);
	glp->EnableClientStateiEXT = (void APIENTRY (*)(GLenum array, GLuint index)) ldg_find("glEnableClientStateiEXT", lib);
	GL_CHECK(glp->EnableClientStateiEXT);
	glp->EnableIndexedEXT = (void APIENTRY (*)(GLenum target, GLuint index)) ldg_find("glEnableIndexedEXT", lib);
	GL_CHECK(glp->EnableIndexedEXT);
	glp->EnableVertexArrayAttribEXT = (void APIENTRY (*)(GLuint vaobj, GLuint index)) ldg_find("glEnableVertexArrayAttribEXT", lib);
	GL_CHECK(glp->EnableVertexArrayAttribEXT);
	glp->EnableVertexArrayEXT = (void APIENTRY (*)(GLuint vaobj, GLenum array)) ldg_find("glEnableVertexArrayEXT", lib);
	GL_CHECK(glp->EnableVertexArrayEXT);
	glp->EnableVertexAttribAPPLE = (void APIENTRY (*)(GLuint index, GLenum pname)) ldg_find("glEnableVertexAttribAPPLE", lib);
	GL_CHECK(glp->EnableVertexAttribAPPLE);
	glp->EnableVertexAttribArray = (void APIENTRY (*)(GLuint index)) ldg_find("glEnableVertexAttribArray", lib);
	GL_CHECK(glp->EnableVertexAttribArray);
	glp->Enablei = (void APIENTRY (*)(GLenum target, GLuint index)) ldg_find("glEnablei", lib);
	GL_CHECK(glp->Enablei);
	glp->EndConditionalRender = (void APIENTRY (*)(void)) ldg_find("glEndConditionalRender", lib);
	GL_CHECK(glp->EndConditionalRender);
	glp->EndConditionalRenderNV = (void APIENTRY (*)(void)) ldg_find("glEndConditionalRenderNV", lib);
	GL_CHECK(glp->EndConditionalRenderNV);
	glp->EndConditionalRenderNVX = (void APIENTRY (*)(void)) ldg_find("glEndConditionalRenderNVX", lib);
	GL_CHECK(glp->EndConditionalRenderNVX);
	glp->EndPerfMonitorAMD = (void APIENTRY (*)(GLuint monitor)) ldg_find("glEndPerfMonitorAMD", lib);
	GL_CHECK(glp->EndPerfMonitorAMD);
	glp->EndPerfQueryINTEL = (void APIENTRY (*)(GLuint queryHandle)) ldg_find("glEndPerfQueryINTEL", lib);
	GL_CHECK(glp->EndPerfQueryINTEL);
	glp->EndQueryIndexed = (void APIENTRY (*)(GLenum target, GLuint index)) ldg_find("glEndQueryIndexed", lib);
	GL_CHECK(glp->EndQueryIndexed);
	glp->EndTransformFeedback = (void APIENTRY (*)(void)) ldg_find("glEndTransformFeedback", lib);
	GL_CHECK(glp->EndTransformFeedback);
	glp->EndTransformFeedbackEXT = (void APIENTRY (*)(void)) ldg_find("glEndTransformFeedbackEXT", lib);
	GL_CHECK(glp->EndTransformFeedbackEXT);
	glp->EndTransformFeedbackNV = (void APIENTRY (*)(void)) ldg_find("glEndTransformFeedbackNV", lib);
	GL_CHECK(glp->EndTransformFeedbackNV);
	glp->EndVideoCaptureNV = (void APIENTRY (*)(GLuint video_capture_slot)) ldg_find("glEndVideoCaptureNV", lib);
	GL_CHECK(glp->EndVideoCaptureNV);
	glp->EvalCoord1xOES = (void APIENTRY (*)(GLfixed u)) ldg_find("glEvalCoord1xOES", lib);
	GL_CHECK(glp->EvalCoord1xOES);
	glp->EvalCoord1xvOES = (void APIENTRY (*)(const GLfixed *coords)) ldg_find("glEvalCoord1xvOES", lib);
	GL_CHECK(glp->EvalCoord1xvOES);
	glp->EvalCoord2xOES = (void APIENTRY (*)(GLfixed u, GLfixed v)) ldg_find("glEvalCoord2xOES", lib);
	GL_CHECK(glp->EvalCoord2xOES);
	glp->EvalCoord2xvOES = (void APIENTRY (*)(const GLfixed *coords)) ldg_find("glEvalCoord2xvOES", lib);
	GL_CHECK(glp->EvalCoord2xvOES);
	glp->FeedbackBufferxOES = (void APIENTRY (*)(GLsizei n, GLenum type, const GLfixed *buffer)) ldg_find("glFeedbackBufferxOES", lib);
	GL_CHECK(glp->FeedbackBufferxOES);
	glp->FenceSync = (GLsync APIENTRY (*)(GLenum condition, GLbitfield flags)) ldg_find("glFenceSync", lib);
	GL_CHECK(glp->FenceSync);
	glp->FinishRenderAPPLE = (void APIENTRY (*)(void)) ldg_find("glFinishRenderAPPLE", lib);
	GL_CHECK(glp->FinishRenderAPPLE);
	glp->FlushMappedBufferRange = (void APIENTRY (*)(GLenum target, GLintptr offset, GLsizeiptr length)) ldg_find("glFlushMappedBufferRange", lib);
	GL_CHECK(glp->FlushMappedBufferRange);
	glp->FlushMappedBufferRangeAPPLE = (void APIENTRY (*)(GLenum target, GLintptr offset, GLsizeiptr size)) ldg_find("glFlushMappedBufferRangeAPPLE", lib);
	GL_CHECK(glp->FlushMappedBufferRangeAPPLE);
	glp->FlushMappedNamedBufferRangeEXT = (void APIENTRY (*)(GLuint buffer, GLintptr offset, GLsizeiptr length)) ldg_find("glFlushMappedNamedBufferRangeEXT", lib);
	GL_CHECK(glp->FlushMappedNamedBufferRangeEXT);
	glp->FlushRenderAPPLE = (void APIENTRY (*)(void)) ldg_find("glFlushRenderAPPLE", lib);
	GL_CHECK(glp->FlushRenderAPPLE);
	glp->FlushStaticDataIBM = (void APIENTRY (*)(GLenum target)) ldg_find("glFlushStaticDataIBM", lib);
	GL_CHECK(glp->FlushStaticDataIBM);
	glp->FogCoordFormatNV = (void APIENTRY (*)(GLenum type, GLsizei stride)) ldg_find("glFogCoordFormatNV", lib);
	GL_CHECK(glp->FogCoordFormatNV);
	glp->FogxOES = (void APIENTRY (*)(GLenum pname, GLfixed param)) ldg_find("glFogxOES", lib);
	GL_CHECK(glp->FogxOES);
	glp->FogxvOES = (void APIENTRY (*)(GLenum pname, const GLfixed *param)) ldg_find("glFogxvOES", lib);
	GL_CHECK(glp->FogxvOES);
	glp->FrameTerminatorGREMEDY = (void APIENTRY (*)(void)) ldg_find("glFrameTerminatorGREMEDY", lib);
	GL_CHECK(glp->FrameTerminatorGREMEDY);
	glp->FramebufferDrawBufferEXT = (void APIENTRY (*)(GLuint framebuffer, GLenum mode)) ldg_find("glFramebufferDrawBufferEXT", lib);
	GL_CHECK(glp->FramebufferDrawBufferEXT);
	glp->FramebufferDrawBuffersEXT = (void APIENTRY (*)(GLuint framebuffer, GLsizei n, const GLenum *bufs)) ldg_find("glFramebufferDrawBuffersEXT", lib);
	GL_CHECK(glp->FramebufferDrawBuffersEXT);
	glp->FramebufferParameteri = (void APIENTRY (*)(GLenum target, GLenum pname, GLint param)) ldg_find("glFramebufferParameteri", lib);
	GL_CHECK(glp->FramebufferParameteri);
	glp->FramebufferReadBufferEXT = (void APIENTRY (*)(GLuint framebuffer, GLenum mode)) ldg_find("glFramebufferReadBufferEXT", lib);
	GL_CHECK(glp->FramebufferReadBufferEXT);
	glp->FramebufferRenderbuffer = (void APIENTRY (*)(GLenum target, GLenum attachment, GLenum renderbuffertarget, GLuint renderbuffer)) ldg_find("glFramebufferRenderbuffer", lib);
	GL_CHECK(glp->FramebufferRenderbuffer);
	glp->FramebufferRenderbufferEXT = (void APIENTRY (*)(GLenum target, GLenum attachment, GLenum renderbuffertarget, GLuint renderbuffer)) ldg_find("glFramebufferRenderbufferEXT", lib);
	GL_CHECK(glp->FramebufferRenderbufferEXT);
	glp->FramebufferTexture = (void APIENTRY (*)(GLenum target, GLenum attachment, GLuint texture, GLint level)) ldg_find("glFramebufferTexture", lib);
	GL_CHECK(glp->FramebufferTexture);
	glp->FramebufferTexture1D = (void APIENTRY (*)(GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level)) ldg_find("glFramebufferTexture1D", lib);
	GL_CHECK(glp->FramebufferTexture1D);
	glp->FramebufferTexture1DEXT = (void APIENTRY (*)(GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level)) ldg_find("glFramebufferTexture1DEXT", lib);
	GL_CHECK(glp->FramebufferTexture1DEXT);
	glp->FramebufferTexture2D = (void APIENTRY (*)(GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level)) ldg_find("glFramebufferTexture2D", lib);
	GL_CHECK(glp->FramebufferTexture2D);
	glp->FramebufferTexture2DEXT = (void APIENTRY (*)(GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level)) ldg_find("glFramebufferTexture2DEXT", lib);
	GL_CHECK(glp->FramebufferTexture2DEXT);
	glp->FramebufferTexture3D = (void APIENTRY (*)(GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level, GLint zoffset)) ldg_find("glFramebufferTexture3D", lib);
	GL_CHECK(glp->FramebufferTexture3D);
	glp->FramebufferTexture3DEXT = (void APIENTRY (*)(GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level, GLint zoffset)) ldg_find("glFramebufferTexture3DEXT", lib);
	GL_CHECK(glp->FramebufferTexture3DEXT);
	glp->FramebufferTextureARB = (void APIENTRY (*)(GLenum target, GLenum attachment, GLuint texture, GLint level)) ldg_find("glFramebufferTextureARB", lib);
	GL_CHECK(glp->FramebufferTextureARB);
	glp->FramebufferTextureEXT = (void APIENTRY (*)(GLenum target, GLenum attachment, GLuint texture, GLint level)) ldg_find("glFramebufferTextureEXT", lib);
	GL_CHECK(glp->FramebufferTextureEXT);
	glp->FramebufferTextureFaceARB = (void APIENTRY (*)(GLenum target, GLenum attachment, GLuint texture, GLint level, GLenum face)) ldg_find("glFramebufferTextureFaceARB", lib);
	GL_CHECK(glp->FramebufferTextureFaceARB);
	glp->FramebufferTextureFaceEXT = (void APIENTRY (*)(GLenum target, GLenum attachment, GLuint texture, GLint level, GLenum face)) ldg_find("glFramebufferTextureFaceEXT", lib);
	GL_CHECK(glp->FramebufferTextureFaceEXT);
	glp->FramebufferTextureLayer = (void APIENTRY (*)(GLenum target, GLenum attachment, GLuint texture, GLint level, GLint layer)) ldg_find("glFramebufferTextureLayer", lib);
	GL_CHECK(glp->FramebufferTextureLayer);
	glp->FramebufferTextureLayerARB = (void APIENTRY (*)(GLenum target, GLenum attachment, GLuint texture, GLint level, GLint layer)) ldg_find("glFramebufferTextureLayerARB", lib);
	GL_CHECK(glp->FramebufferTextureLayerARB);
	glp->FramebufferTextureLayerEXT = (void APIENTRY (*)(GLenum target, GLenum attachment, GLuint texture, GLint level, GLint layer)) ldg_find("glFramebufferTextureLayerEXT", lib);
	GL_CHECK(glp->FramebufferTextureLayerEXT);
	glp->FrustumfOES = (void APIENTRY (*)(GLfloat l, GLfloat r, GLfloat b, GLfloat t, GLfloat n, GLfloat f)) ldg_find("glFrustumfOES", lib);
	GL_CHECK(glp->FrustumfOES);
	glp->FrustumxOES = (void APIENTRY (*)(GLfixed l, GLfixed r, GLfixed b, GLfixed t, GLfixed n, GLfixed f)) ldg_find("glFrustumxOES", lib);
	GL_CHECK(glp->FrustumxOES);
	glp->GenFramebuffers = (void APIENTRY (*)(GLsizei n, GLuint *framebuffers)) ldg_find("glGenFramebuffers", lib);
	GL_CHECK(glp->GenFramebuffers);
	glp->GenFramebuffersEXT = (void APIENTRY (*)(GLsizei n, GLuint *framebuffers)) ldg_find("glGenFramebuffersEXT", lib);
	GL_CHECK(glp->GenFramebuffersEXT);
	glp->GenNamesAMD = (void APIENTRY (*)(GLenum identifier, GLuint num, GLuint *names)) ldg_find("glGenNamesAMD", lib);
	GL_CHECK(glp->GenNamesAMD);
	glp->GenPathsNV = (GLuint APIENTRY (*)(GLsizei range)) ldg_find("glGenPathsNV", lib);
	GL_CHECK(glp->GenPathsNV);
	glp->GenPerfMonitorsAMD = (void APIENTRY (*)(GLsizei n, GLuint *monitors)) ldg_find("glGenPerfMonitorsAMD", lib);
	GL_CHECK(glp->GenPerfMonitorsAMD);
	glp->GenProgramPipelines = (void APIENTRY (*)(GLsizei n, GLuint *pipelines)) ldg_find("glGenProgramPipelines", lib);
	GL_CHECK(glp->GenProgramPipelines);
	glp->GenRenderbuffers = (void APIENTRY (*)(GLsizei n, GLuint *renderbuffers)) ldg_find("glGenRenderbuffers", lib);
	GL_CHECK(glp->GenRenderbuffers);
	glp->GenRenderbuffersEXT = (void APIENTRY (*)(GLsizei n, GLuint *renderbuffers)) ldg_find("glGenRenderbuffersEXT", lib);
	GL_CHECK(glp->GenRenderbuffersEXT);
	glp->GenSamplers = (void APIENTRY (*)(GLsizei count, GLuint *samplers)) ldg_find("glGenSamplers", lib);
	GL_CHECK(glp->GenSamplers);
	glp->GenTransformFeedbacks = (void APIENTRY (*)(GLsizei n, GLuint *ids)) ldg_find("glGenTransformFeedbacks", lib);
	GL_CHECK(glp->GenTransformFeedbacks);
	glp->GenTransformFeedbacksNV = (void APIENTRY (*)(GLsizei n, GLuint *ids)) ldg_find("glGenTransformFeedbacksNV", lib);
	GL_CHECK(glp->GenTransformFeedbacksNV);
	glp->GenVertexArrays = (void APIENTRY (*)(GLsizei n, GLuint *arrays)) ldg_find("glGenVertexArrays", lib);
	GL_CHECK(glp->GenVertexArrays);
	glp->GenerateMipmap = (void APIENTRY (*)(GLenum target)) ldg_find("glGenerateMipmap", lib);
	GL_CHECK(glp->GenerateMipmap);
	glp->GenerateMipmapEXT = (void APIENTRY (*)(GLenum target)) ldg_find("glGenerateMipmapEXT", lib);
	GL_CHECK(glp->GenerateMipmapEXT);
	glp->GenerateMultiTexMipmapEXT = (void APIENTRY (*)(GLenum texunit, GLenum target)) ldg_find("glGenerateMultiTexMipmapEXT", lib);
	GL_CHECK(glp->GenerateMultiTexMipmapEXT);
	glp->GenerateTextureMipmapEXT = (void APIENTRY (*)(GLuint texture, GLenum target)) ldg_find("glGenerateTextureMipmapEXT", lib);
	GL_CHECK(glp->GenerateTextureMipmapEXT);
	glp->GetActiveAtomicCounterBufferiv = (void APIENTRY (*)(GLuint program, GLuint bufferIndex, GLenum pname, GLint *params)) ldg_find("glGetActiveAtomicCounterBufferiv", lib);
	GL_CHECK(glp->GetActiveAtomicCounterBufferiv);
	glp->GetActiveAttrib = (void APIENTRY (*)(GLuint program, GLuint index, GLsizei bufSize, GLsizei *length, GLint *size, GLenum *type, GLchar *name)) ldg_find("glGetActiveAttrib", lib);
	GL_CHECK(glp->GetActiveAttrib);
	glp->GetActiveSubroutineName = (void APIENTRY (*)(GLuint program, GLenum shadertype, GLuint index, GLsizei bufsize, GLsizei *length, GLchar *name)) ldg_find("glGetActiveSubroutineName", lib);
	GL_CHECK(glp->GetActiveSubroutineName);
	glp->GetActiveSubroutineUniformName = (void APIENTRY (*)(GLuint program, GLenum shadertype, GLuint index, GLsizei bufsize, GLsizei *length, GLchar *name)) ldg_find("glGetActiveSubroutineUniformName", lib);
	GL_CHECK(glp->GetActiveSubroutineUniformName);
	glp->GetActiveSubroutineUniformiv = (void APIENTRY (*)(GLuint program, GLenum shadertype, GLuint index, GLenum pname, GLint *values)) ldg_find("glGetActiveSubroutineUniformiv", lib);
	GL_CHECK(glp->GetActiveSubroutineUniformiv);
	glp->GetActiveUniform = (void APIENTRY (*)(GLuint program, GLuint index, GLsizei bufSize, GLsizei *length, GLint *size, GLenum *type, GLchar *name)) ldg_find("glGetActiveUniform", lib);
	GL_CHECK(glp->GetActiveUniform);
	glp->GetActiveUniformBlockIndex = (GLuint APIENTRY (*)(GLuint program, const GLchar *uniformBlockName)) ldg_find("glGetActiveUniformBlockIndex", lib);
	GL_CHECK(glp->GetActiveUniformBlockIndex);
	glp->GetActiveUniformBlockName = (void APIENTRY (*)(GLuint program, GLuint uniformBlockIndex, GLsizei bufSize, GLsizei *length, GLchar *uniformBlockName)) ldg_find("glGetActiveUniformBlockName", lib);
	GL_CHECK(glp->GetActiveUniformBlockName);
	glp->GetActiveUniformBlockiv = (void APIENTRY (*)(GLuint program, GLuint uniformBlockIndex, GLenum pname, GLint *params)) ldg_find("glGetActiveUniformBlockiv", lib);
	GL_CHECK(glp->GetActiveUniformBlockiv);
	glp->GetActiveUniformName = (void APIENTRY (*)(GLuint program, GLuint uniformIndex, GLsizei bufSize, GLsizei *length, GLchar *uniformName)) ldg_find("glGetActiveUniformName", lib);
	GL_CHECK(glp->GetActiveUniformName);
	glp->GetActiveUniformsiv = (void APIENTRY (*)(GLuint program, GLsizei uniformCount, const GLuint *uniformIndices, GLenum pname, GLint *params)) ldg_find("glGetActiveUniformsiv", lib);
	GL_CHECK(glp->GetActiveUniformsiv);
	glp->GetActiveVaryingNV = (void APIENTRY (*)(GLuint program, GLuint index, GLsizei bufSize, GLsizei *length, GLsizei *size, GLenum *type, GLchar *name)) ldg_find("glGetActiveVaryingNV", lib);
	GL_CHECK(glp->GetActiveVaryingNV);
	glp->GetAttachedShaders = (void APIENTRY (*)(GLuint program, GLsizei maxCount, GLsizei *count, GLuint *shaders)) ldg_find("glGetAttachedShaders", lib);
	GL_CHECK(glp->GetAttachedShaders);
	glp->GetAttribLocation = (GLint APIENTRY (*)(GLuint program, const GLchar *name)) ldg_find("glGetAttribLocation", lib);
	GL_CHECK(glp->GetAttribLocation);
	glp->GetBooleanIndexedvEXT = (void APIENTRY (*)(GLenum target, GLuint index, GLboolean *data)) ldg_find("glGetBooleanIndexedvEXT", lib);
	GL_CHECK(glp->GetBooleanIndexedvEXT);
	glp->GetBooleani_v = (void APIENTRY (*)(GLenum target, GLuint index, GLboolean *data)) ldg_find("glGetBooleani_v", lib);
	GL_CHECK(glp->GetBooleani_v);
	glp->GetBufferParameteri64v = (void APIENTRY (*)(GLenum target, GLenum pname, GLint64 *params)) ldg_find("glGetBufferParameteri64v", lib);
	GL_CHECK(glp->GetBufferParameteri64v);
	glp->GetBufferParameterui64vNV = (void APIENTRY (*)(GLenum target, GLenum pname, GLuint64EXT *params)) ldg_find("glGetBufferParameterui64vNV", lib);
	GL_CHECK(glp->GetBufferParameterui64vNV);
	glp->GetClipPlanefOES = (void APIENTRY (*)(GLenum plane, GLfloat *equation)) ldg_find("glGetClipPlanefOES", lib);
	GL_CHECK(glp->GetClipPlanefOES);
	glp->GetClipPlanexOES = (void APIENTRY (*)(GLenum plane, GLfixed *equation)) ldg_find("glGetClipPlanexOES", lib);
	GL_CHECK(glp->GetClipPlanexOES);
	glp->GetCompressedMultiTexImageEXT = (void APIENTRY (*)(GLenum texunit, GLenum target, GLint lod, void *img)) ldg_find("glGetCompressedMultiTexImageEXT", lib);
	GL_CHECK(glp->GetCompressedMultiTexImageEXT);
	glp->GetCompressedTextureImageEXT = (void APIENTRY (*)(GLuint texture, GLenum target, GLint lod, void *img)) ldg_find("glGetCompressedTextureImageEXT", lib);
	GL_CHECK(glp->GetCompressedTextureImageEXT);
	glp->GetConvolutionParameterxvOES = (void APIENTRY (*)(GLenum target, GLenum pname, GLfixed *params)) ldg_find("glGetConvolutionParameterxvOES", lib);
	GL_CHECK(glp->GetConvolutionParameterxvOES);
	glp->GetDebugLogLengthMESA = (GLsizei APIENTRY (*)(GLhandleARB obj, GLenum logType, GLenum shaderType)) ldg_find("glGetDebugLogLengthMESA", lib);
	GL_CHECK(glp->GetDebugLogLengthMESA);
	glp->GetDebugLogMESA = (void APIENTRY (*)(GLhandleARB obj, GLenum logType, GLenum shaderType, GLsizei maxLength, GLsizei *length, GLcharARB *debugLog)) ldg_find("glGetDebugLogMESA", lib);
	GL_CHECK(glp->GetDebugLogMESA);
	glp->GetDebugMessageLog = (GLuint APIENTRY (*)(GLuint count, GLsizei bufSize, GLenum *sources, GLenum *types, GLuint *ids, GLenum *severities, GLsizei *lengths, GLchar *messageLog)) ldg_find("glGetDebugMessageLog", lib);
	GL_CHECK(glp->GetDebugMessageLog);
	glp->GetDebugMessageLogAMD = (GLuint APIENTRY (*)(GLuint count, GLsizei bufsize, GLenum *categories, GLuint *severities, GLuint *ids, GLsizei *lengths, GLchar *message)) ldg_find("glGetDebugMessageLogAMD", lib);
	GL_CHECK(glp->GetDebugMessageLogAMD);
	glp->GetDebugMessageLogARB = (GLuint APIENTRY (*)(GLuint count, GLsizei bufSize, GLenum *sources, GLenum *types, GLuint *ids, GLenum *severities, GLsizei *lengths, GLchar *messageLog)) ldg_find("glGetDebugMessageLogARB", lib);
	GL_CHECK(glp->GetDebugMessageLogARB);
	glp->GetDoubleIndexedvEXT = (void APIENTRY (*)(GLenum target, GLuint index, GLdouble *data)) ldg_find("glGetDoubleIndexedvEXT", lib);
	GL_CHECK(glp->GetDoubleIndexedvEXT);
	glp->GetDoublei_v = (void APIENTRY (*)(GLenum target, GLuint index, GLdouble *data)) ldg_find("glGetDoublei_v", lib);
	GL_CHECK(glp->GetDoublei_v);
	glp->GetDoublei_vEXT = (void APIENTRY (*)(GLenum pname, GLuint index, GLdouble *params)) ldg_find("glGetDoublei_vEXT", lib);
	GL_CHECK(glp->GetDoublei_vEXT);
	glp->GetFirstPerfQueryIdINTEL = (void APIENTRY (*)(GLuint *queryId)) ldg_find("glGetFirstPerfQueryIdINTEL", lib);
	GL_CHECK(glp->GetFirstPerfQueryIdINTEL);
	glp->GetFixedvOES = (void APIENTRY (*)(GLenum pname, GLfixed *params)) ldg_find("glGetFixedvOES", lib);
	GL_CHECK(glp->GetFixedvOES);
	glp->GetFloatIndexedvEXT = (void APIENTRY (*)(GLenum target, GLuint index, GLfloat *data)) ldg_find("glGetFloatIndexedvEXT", lib);
	GL_CHECK(glp->GetFloatIndexedvEXT);
	glp->GetFloati_v = (void APIENTRY (*)(GLenum target, GLuint index, GLfloat *data)) ldg_find("glGetFloati_v", lib);
	GL_CHECK(glp->GetFloati_v);
	glp->GetFloati_vEXT = (void APIENTRY (*)(GLenum pname, GLuint index, GLfloat *params)) ldg_find("glGetFloati_vEXT", lib);
	GL_CHECK(glp->GetFloati_vEXT);
	glp->GetFragDataIndex = (GLint APIENTRY (*)(GLuint program, const GLchar *name)) ldg_find("glGetFragDataIndex", lib);
	GL_CHECK(glp->GetFragDataIndex);
	glp->GetFragDataLocation = (GLint APIENTRY (*)(GLuint program, const GLchar *name)) ldg_find("glGetFragDataLocation", lib);
	GL_CHECK(glp->GetFragDataLocation);
	glp->GetFragDataLocationEXT = (GLint APIENTRY (*)(GLuint program, const GLchar *name)) ldg_find("glGetFragDataLocationEXT", lib);
	GL_CHECK(glp->GetFragDataLocationEXT);
	glp->GetFramebufferAttachmentParameteriv = (void APIENTRY (*)(GLenum target, GLenum attachment, GLenum pname, GLint *params)) ldg_find("glGetFramebufferAttachmentParameteriv", lib);
	GL_CHECK(glp->GetFramebufferAttachmentParameteriv);
	glp->GetFramebufferAttachmentParameterivEXT = (void APIENTRY (*)(GLenum target, GLenum attachment, GLenum pname, GLint *params)) ldg_find("glGetFramebufferAttachmentParameterivEXT", lib);
	GL_CHECK(glp->GetFramebufferAttachmentParameterivEXT);
	glp->GetFramebufferParameteriv = (void APIENTRY (*)(GLenum target, GLenum pname, GLint *params)) ldg_find("glGetFramebufferParameteriv", lib);
	GL_CHECK(glp->GetFramebufferParameteriv);
	glp->GetFramebufferParameterivEXT = (void APIENTRY (*)(GLuint framebuffer, GLenum pname, GLint *params)) ldg_find("glGetFramebufferParameterivEXT", lib);
	GL_CHECK(glp->GetFramebufferParameterivEXT);
	glp->GetGraphicsResetStatusARB = (GLenum APIENTRY (*)(void)) ldg_find("glGetGraphicsResetStatusARB", lib);
	GL_CHECK(glp->GetGraphicsResetStatusARB);
	glp->GetHistogramParameterxvOES = (void APIENTRY (*)(GLenum target, GLenum pname, GLfixed *params)) ldg_find("glGetHistogramParameterxvOES", lib);
	GL_CHECK(glp->GetHistogramParameterxvOES);
	glp->GetImageHandleARB = (GLuint64 APIENTRY (*)(GLuint texture, GLint level, GLboolean32 layered, GLint layer, GLenum format)) ldg_find("glGetImageHandleARB", lib);
	GL_CHECK(glp->GetImageHandleARB);
	glp->GetImageHandleNV = (GLuint64 APIENTRY (*)(GLuint texture, GLint level, GLboolean32 layered, GLint layer, GLenum format)) ldg_find("glGetImageHandleNV", lib);
	GL_CHECK(glp->GetImageHandleNV);
	glp->GetInteger64i_v = (void APIENTRY (*)(GLenum target, GLuint index, GLint64 *data)) ldg_find("glGetInteger64i_v", lib);
	GL_CHECK(glp->GetInteger64i_v);
	glp->GetInteger64v = (void APIENTRY (*)(GLenum pname, GLint64 *data)) ldg_find("glGetInteger64v", lib);
	GL_CHECK(glp->GetInteger64v);
	glp->GetIntegerIndexedvEXT = (void APIENTRY (*)(GLenum target, GLuint index, GLint *data)) ldg_find("glGetIntegerIndexedvEXT", lib);
	GL_CHECK(glp->GetIntegerIndexedvEXT);
	glp->GetIntegeri_v = (void APIENTRY (*)(GLenum target, GLuint index, GLint *data)) ldg_find("glGetIntegeri_v", lib);
	GL_CHECK(glp->GetIntegeri_v);
	glp->GetIntegerui64i_vNV = (void APIENTRY (*)(GLenum value, GLuint index, GLuint64EXT *result)) ldg_find("glGetIntegerui64i_vNV", lib);
	GL_CHECK(glp->GetIntegerui64i_vNV);
	glp->GetIntegerui64vNV = (void APIENTRY (*)(GLenum value, GLuint64EXT *result)) ldg_find("glGetIntegerui64vNV", lib);
	GL_CHECK(glp->GetIntegerui64vNV);
	glp->GetInternalformati64v = (void APIENTRY (*)(GLenum target, GLenum internalformat, GLenum pname, GLsizei bufSize, GLint64 *params)) ldg_find("glGetInternalformati64v", lib);
	GL_CHECK(glp->GetInternalformati64v);
	glp->GetInternalformativ = (void APIENTRY (*)(GLenum target, GLenum internalformat, GLenum pname, GLsizei bufSize, GLint *params)) ldg_find("glGetInternalformativ", lib);
	GL_CHECK(glp->GetInternalformativ);
	glp->GetLightxOES = (void APIENTRY (*)(GLenum light, GLenum pname, GLfixed *params)) ldg_find("glGetLightxOES", lib);
	GL_CHECK(glp->GetLightxOES);
	glp->GetMapxvOES = (void APIENTRY (*)(GLenum target, GLenum query, GLfixed *v)) ldg_find("glGetMapxvOES", lib);
	GL_CHECK(glp->GetMapxvOES);
	glp->GetMaterialxOES = (void APIENTRY (*)(GLenum face, GLenum pname, GLfixed param)) ldg_find("glGetMaterialxOES", lib);
	GL_CHECK(glp->GetMaterialxOES);
	glp->GetMultiTexEnvfvEXT = (void APIENTRY (*)(GLenum texunit, GLenum target, GLenum pname, GLfloat *params)) ldg_find("glGetMultiTexEnvfvEXT", lib);
	GL_CHECK(glp->GetMultiTexEnvfvEXT);
	glp->GetMultiTexEnvivEXT = (void APIENTRY (*)(GLenum texunit, GLenum target, GLenum pname, GLint *params)) ldg_find("glGetMultiTexEnvivEXT", lib);
	GL_CHECK(glp->GetMultiTexEnvivEXT);
	glp->GetMultiTexGendvEXT = (void APIENTRY (*)(GLenum texunit, GLenum coord, GLenum pname, GLdouble *params)) ldg_find("glGetMultiTexGendvEXT", lib);
	GL_CHECK(glp->GetMultiTexGendvEXT);
	glp->GetMultiTexGenfvEXT = (void APIENTRY (*)(GLenum texunit, GLenum coord, GLenum pname, GLfloat *params)) ldg_find("glGetMultiTexGenfvEXT", lib);
	GL_CHECK(glp->GetMultiTexGenfvEXT);
	glp->GetMultiTexGenivEXT = (void APIENTRY (*)(GLenum texunit, GLenum coord, GLenum pname, GLint *params)) ldg_find("glGetMultiTexGenivEXT", lib);
	GL_CHECK(glp->GetMultiTexGenivEXT);
	glp->GetMultiTexImageEXT = (void APIENTRY (*)(GLenum texunit, GLenum target, GLint level, GLenum format, GLenum type, void *pixels)) ldg_find("glGetMultiTexImageEXT", lib);
	GL_CHECK(glp->GetMultiTexImageEXT);
	glp->GetMultiTexLevelParameterfvEXT = (void APIENTRY (*)(GLenum texunit, GLenum target, GLint level, GLenum pname, GLfloat *params)) ldg_find("glGetMultiTexLevelParameterfvEXT", lib);
	GL_CHECK(glp->GetMultiTexLevelParameterfvEXT);
	glp->GetMultiTexLevelParameterivEXT = (void APIENTRY (*)(GLenum texunit, GLenum target, GLint level, GLenum pname, GLint *params)) ldg_find("glGetMultiTexLevelParameterivEXT", lib);
	GL_CHECK(glp->GetMultiTexLevelParameterivEXT);
	glp->GetMultiTexParameterIivEXT = (void APIENTRY (*)(GLenum texunit, GLenum target, GLenum pname, GLint *params)) ldg_find("glGetMultiTexParameterIivEXT", lib);
	GL_CHECK(glp->GetMultiTexParameterIivEXT);
	glp->GetMultiTexParameterIuivEXT = (void APIENTRY (*)(GLenum texunit, GLenum target, GLenum pname, GLuint *params)) ldg_find("glGetMultiTexParameterIuivEXT", lib);
	GL_CHECK(glp->GetMultiTexParameterIuivEXT);
	glp->GetMultiTexParameterfvEXT = (void APIENTRY (*)(GLenum texunit, GLenum target, GLenum pname, GLfloat *params)) ldg_find("glGetMultiTexParameterfvEXT", lib);
	GL_CHECK(glp->GetMultiTexParameterfvEXT);
	glp->GetMultiTexParameterivEXT = (void APIENTRY (*)(GLenum texunit, GLenum target, GLenum pname, GLint *params)) ldg_find("glGetMultiTexParameterivEXT", lib);
	GL_CHECK(glp->GetMultiTexParameterivEXT);
	glp->GetMultisamplefv = (void APIENTRY (*)(GLenum pname, GLuint index, GLfloat *val)) ldg_find("glGetMultisamplefv", lib);
	GL_CHECK(glp->GetMultisamplefv);
	glp->GetMultisamplefvNV = (void APIENTRY (*)(GLenum pname, GLuint index, GLfloat *val)) ldg_find("glGetMultisamplefvNV", lib);
	GL_CHECK(glp->GetMultisamplefvNV);
	glp->GetNamedBufferParameterivEXT = (void APIENTRY (*)(GLuint buffer, GLenum pname, GLint *params)) ldg_find("glGetNamedBufferParameterivEXT", lib);
	GL_CHECK(glp->GetNamedBufferParameterivEXT);
	glp->GetNamedBufferParameterui64vNV = (void APIENTRY (*)(GLuint buffer, GLenum pname, GLuint64EXT *params)) ldg_find("glGetNamedBufferParameterui64vNV", lib);
	GL_CHECK(glp->GetNamedBufferParameterui64vNV);
	glp->GetNamedBufferPointervEXT = (void APIENTRY (*)(GLuint buffer, GLenum pname, void * *params)) ldg_find("glGetNamedBufferPointervEXT", lib);
	GL_CHECK(glp->GetNamedBufferPointervEXT);
	glp->GetNamedBufferSubDataEXT = (void APIENTRY (*)(GLuint buffer, GLintptr offset, GLsizeiptr size, void *data)) ldg_find("glGetNamedBufferSubDataEXT", lib);
	GL_CHECK(glp->GetNamedBufferSubDataEXT);
	glp->GetNamedFramebufferAttachmentParameterivEXT = (void APIENTRY (*)(GLuint framebuffer, GLenum attachment, GLenum pname, GLint *params)) ldg_find("glGetNamedFramebufferAttachmentParameterivEXT", lib);
	GL_CHECK(glp->GetNamedFramebufferAttachmentParameterivEXT);
	glp->GetNamedFramebufferParameterivEXT = (void APIENTRY (*)(GLuint framebuffer, GLenum pname, GLint *params)) ldg_find("glGetNamedFramebufferParameterivEXT", lib);
	GL_CHECK(glp->GetNamedFramebufferParameterivEXT);
	glp->GetNamedProgramLocalParameterIivEXT = (void APIENTRY (*)(GLuint program, GLenum target, GLuint index, GLint *params)) ldg_find("glGetNamedProgramLocalParameterIivEXT", lib);
	GL_CHECK(glp->GetNamedProgramLocalParameterIivEXT);
	glp->GetNamedProgramLocalParameterIuivEXT = (void APIENTRY (*)(GLuint program, GLenum target, GLuint index, GLuint *params)) ldg_find("glGetNamedProgramLocalParameterIuivEXT", lib);
	GL_CHECK(glp->GetNamedProgramLocalParameterIuivEXT);
	glp->GetNamedProgramLocalParameterdvEXT = (void APIENTRY (*)(GLuint program, GLenum target, GLuint index, GLdouble *params)) ldg_find("glGetNamedProgramLocalParameterdvEXT", lib);
	GL_CHECK(glp->GetNamedProgramLocalParameterdvEXT);
	glp->GetNamedProgramLocalParameterfvEXT = (void APIENTRY (*)(GLuint program, GLenum target, GLuint index, GLfloat *params)) ldg_find("glGetNamedProgramLocalParameterfvEXT", lib);
	GL_CHECK(glp->GetNamedProgramLocalParameterfvEXT);
	glp->GetNamedProgramStringEXT = (void APIENTRY (*)(GLuint program, GLenum target, GLenum pname, void *string)) ldg_find("glGetNamedProgramStringEXT", lib);
	GL_CHECK(glp->GetNamedProgramStringEXT);
	glp->GetNamedProgramivEXT = (void APIENTRY (*)(GLuint program, GLenum target, GLenum pname, GLint *params)) ldg_find("glGetNamedProgramivEXT", lib);
	GL_CHECK(glp->GetNamedProgramivEXT);
	glp->GetNamedRenderbufferParameterivEXT = (void APIENTRY (*)(GLuint renderbuffer, GLenum pname, GLint *params)) ldg_find("glGetNamedRenderbufferParameterivEXT", lib);
	GL_CHECK(glp->GetNamedRenderbufferParameterivEXT);
	glp->GetNamedStringARB = (void APIENTRY (*)(GLint namelen, const GLchar *name, GLsizei bufSize, GLint *stringlen, GLchar *string)) ldg_find("glGetNamedStringARB", lib);
	GL_CHECK(glp->GetNamedStringARB);
	glp->GetNamedStringivARB = (void APIENTRY (*)(GLint namelen, const GLchar *name, GLenum pname, GLint *params)) ldg_find("glGetNamedStringivARB", lib);
	GL_CHECK(glp->GetNamedStringivARB);
	glp->GetNextPerfQueryIdINTEL = (void APIENTRY (*)(GLuint queryId, GLuint *nextQueryId)) ldg_find("glGetNextPerfQueryIdINTEL", lib);
	GL_CHECK(glp->GetNextPerfQueryIdINTEL);
	glp->GetObjectLabel = (void APIENTRY (*)(GLenum identifier, GLuint name, GLsizei bufSize, GLsizei *length, GLchar *label)) ldg_find("glGetObjectLabel", lib);
	GL_CHECK(glp->GetObjectLabel);
	glp->GetObjectLabelEXT = (void APIENTRY (*)(GLenum type, GLuint object, GLsizei bufSize, GLsizei *length, GLchar *label)) ldg_find("glGetObjectLabelEXT", lib);
	GL_CHECK(glp->GetObjectLabelEXT);
	glp->GetObjectParameterivAPPLE = (void APIENTRY (*)(GLenum objectType, GLuint name, GLenum pname, GLint *params)) ldg_find("glGetObjectParameterivAPPLE", lib);
	GL_CHECK(glp->GetObjectParameterivAPPLE);
	glp->GetObjectPtrLabel = (void APIENTRY (*)(const void *ptr, GLsizei bufSize, GLsizei *length, GLchar *label)) ldg_find("glGetObjectPtrLabel", lib);
	GL_CHECK(glp->GetObjectPtrLabel);
	glp->GetPathColorGenfvNV = (void APIENTRY (*)(GLenum color, GLenum pname, GLfloat *value)) ldg_find("glGetPathColorGenfvNV", lib);
	GL_CHECK(glp->GetPathColorGenfvNV);
	glp->GetPathColorGenivNV = (void APIENTRY (*)(GLenum color, GLenum pname, GLint *value)) ldg_find("glGetPathColorGenivNV", lib);
	GL_CHECK(glp->GetPathColorGenivNV);
	glp->GetPathCommandsNV = (void APIENTRY (*)(GLuint path, GLubyte *commands)) ldg_find("glGetPathCommandsNV", lib);
	GL_CHECK(glp->GetPathCommandsNV);
	glp->GetPathCoordsNV = (void APIENTRY (*)(GLuint path, GLfloat *coords)) ldg_find("glGetPathCoordsNV", lib);
	GL_CHECK(glp->GetPathCoordsNV);
	glp->GetPathDashArrayNV = (void APIENTRY (*)(GLuint path, GLfloat *dashArray)) ldg_find("glGetPathDashArrayNV", lib);
	GL_CHECK(glp->GetPathDashArrayNV);
	glp->GetPathLengthNV = (GLfloat APIENTRY (*)(GLuint path, GLsizei startSegment, GLsizei numSegments)) ldg_find("glGetPathLengthNV", lib);
	GL_CHECK(glp->GetPathLengthNV);
	glp->GetPathMetricRangeNV = (void APIENTRY (*)(GLbitfield metricQueryMask, GLuint firstPathName, GLsizei numPaths, GLsizei stride, GLfloat *metrics)) ldg_find("glGetPathMetricRangeNV", lib);
	GL_CHECK(glp->GetPathMetricRangeNV);
	glp->GetPathMetricsNV = (void APIENTRY (*)(GLbitfield metricQueryMask, GLsizei numPaths, GLenum pathNameType, const void *paths, GLuint pathBase, GLsizei stride, GLfloat *metrics)) ldg_find("glGetPathMetricsNV", lib);
	GL_CHECK(glp->GetPathMetricsNV);
	glp->GetPathParameterfvNV = (void APIENTRY (*)(GLuint path, GLenum pname, GLfloat *value)) ldg_find("glGetPathParameterfvNV", lib);
	GL_CHECK(glp->GetPathParameterfvNV);
	glp->GetPathParameterivNV = (void APIENTRY (*)(GLuint path, GLenum pname, GLint *value)) ldg_find("glGetPathParameterivNV", lib);
	GL_CHECK(glp->GetPathParameterivNV);
	glp->GetPathSpacingNV = (void APIENTRY (*)(GLenum pathListMode, GLsizei numPaths, GLenum pathNameType, const void *paths, GLuint pathBase, GLfloat advanceScale, GLfloat kerningScale, GLenum transformType, GLfloat *returnedSpacing)) ldg_find("glGetPathSpacingNV", lib);
	GL_CHECK(glp->GetPathSpacingNV);
	glp->GetPathTexGenfvNV = (void APIENTRY (*)(GLenum texCoordSet, GLenum pname, GLfloat *value)) ldg_find("glGetPathTexGenfvNV", lib);
	GL_CHECK(glp->GetPathTexGenfvNV);
	glp->GetPathTexGenivNV = (void APIENTRY (*)(GLenum texCoordSet, GLenum pname, GLint *value)) ldg_find("glGetPathTexGenivNV", lib);
	GL_CHECK(glp->GetPathTexGenivNV);
	glp->GetPerfCounterInfoINTEL = (void APIENTRY (*)(GLuint queryId, GLuint counterId, GLuint counterNameLength, GLchar *counterName, GLuint counterDescLength, GLchar *counterDesc, GLuint *counterOffset, GLuint *counterDataSize, GLuint *counterTypeEnum, GLuint *counterDataTypeEnum, GLuint64 *rawCounterMaxValue)) ldg_find("glGetPerfCounterInfoINTEL", lib);
	GL_CHECK(glp->GetPerfCounterInfoINTEL);
	glp->GetPerfMonitorCounterDataAMD = (void APIENTRY (*)(GLuint monitor, GLenum pname, GLsizei dataSize, GLuint *data, GLint *bytesWritten)) ldg_find("glGetPerfMonitorCounterDataAMD", lib);
	GL_CHECK(glp->GetPerfMonitorCounterDataAMD);
	glp->GetPerfMonitorCounterInfoAMD = (void APIENTRY (*)(GLuint group, GLuint counter, GLenum pname, void *data)) ldg_find("glGetPerfMonitorCounterInfoAMD", lib);
	GL_CHECK(glp->GetPerfMonitorCounterInfoAMD);
	glp->GetPerfMonitorCounterStringAMD = (void APIENTRY (*)(GLuint group, GLuint counter, GLsizei bufSize, GLsizei *length, GLchar *counterString)) ldg_find("glGetPerfMonitorCounterStringAMD", lib);
	GL_CHECK(glp->GetPerfMonitorCounterStringAMD);
	glp->GetPerfMonitorCountersAMD = (void APIENTRY (*)(GLuint group, GLint *numCounters, GLint *maxActiveCounters, GLsizei counterSize, GLuint *counters)) ldg_find("glGetPerfMonitorCountersAMD", lib);
	GL_CHECK(glp->GetPerfMonitorCountersAMD);
	glp->GetPerfMonitorGroupStringAMD = (void APIENTRY (*)(GLuint group, GLsizei bufSize, GLsizei *length, GLchar *groupString)) ldg_find("glGetPerfMonitorGroupStringAMD", lib);
	GL_CHECK(glp->GetPerfMonitorGroupStringAMD);
	glp->GetPerfMonitorGroupsAMD = (void APIENTRY (*)(GLint *numGroups, GLsizei groupsSize, GLuint *groups)) ldg_find("glGetPerfMonitorGroupsAMD", lib);
	GL_CHECK(glp->GetPerfMonitorGroupsAMD);
	glp->GetPerfQueryDataINTEL = (void APIENTRY (*)(GLuint queryHandle, GLuint flags, GLsizei dataSize, GLvoid *data, GLuint *bytesWritten)) ldg_find("glGetPerfQueryDataINTEL", lib);
	GL_CHECK(glp->GetPerfQueryDataINTEL);
	glp->GetPerfQueryIdByNameINTEL = (void APIENTRY (*)(GLchar *queryName, GLuint *queryId)) ldg_find("glGetPerfQueryIdByNameINTEL", lib);
	GL_CHECK(glp->GetPerfQueryIdByNameINTEL);
	glp->GetPerfQueryInfoINTEL = (void APIENTRY (*)(GLuint queryId, GLuint queryNameLength, GLchar *queryName, GLuint *dataSize, GLuint *noCounters, GLuint *noInstances, GLuint *capsMask)) ldg_find("glGetPerfQueryInfoINTEL", lib);
	GL_CHECK(glp->GetPerfQueryInfoINTEL);
	glp->GetPixelMapxv = (void APIENTRY (*)(GLenum map, GLint size, GLfixed *values)) ldg_find("glGetPixelMapxv", lib);
	GL_CHECK(glp->GetPixelMapxv);
	glp->GetPixelTransformParameterfvEXT = (void APIENTRY (*)(GLenum target, GLenum pname, GLfloat *params)) ldg_find("glGetPixelTransformParameterfvEXT", lib);
	GL_CHECK(glp->GetPixelTransformParameterfvEXT);
	glp->GetPixelTransformParameterivEXT = (void APIENTRY (*)(GLenum target, GLenum pname, GLint *params)) ldg_find("glGetPixelTransformParameterivEXT", lib);
	GL_CHECK(glp->GetPixelTransformParameterivEXT);
	glp->GetPointerIndexedvEXT = (void APIENTRY (*)(GLenum target, GLuint index, void * *data)) ldg_find("glGetPointerIndexedvEXT", lib);
	GL_CHECK(glp->GetPointerIndexedvEXT);
	glp->GetPointeri_vEXT = (void APIENTRY (*)(GLenum pname, GLuint index, void * *params)) ldg_find("glGetPointeri_vEXT", lib);
	GL_CHECK(glp->GetPointeri_vEXT);
	glp->GetProgramBinary = (void APIENTRY (*)(GLuint program, GLsizei bufSize, GLsizei *length, GLenum *binaryFormat, void *binary)) ldg_find("glGetProgramBinary", lib);
	GL_CHECK(glp->GetProgramBinary);
	glp->GetProgramEnvParameterIivNV = (void APIENTRY (*)(GLenum target, GLuint index, GLint *params)) ldg_find("glGetProgramEnvParameterIivNV", lib);
	GL_CHECK(glp->GetProgramEnvParameterIivNV);
	glp->GetProgramEnvParameterIuivNV = (void APIENTRY (*)(GLenum target, GLuint index, GLuint *params)) ldg_find("glGetProgramEnvParameterIuivNV", lib);
	GL_CHECK(glp->GetProgramEnvParameterIuivNV);
	glp->GetProgramInfoLog = (void APIENTRY (*)(GLuint program, GLsizei bufSize, GLsizei *length, GLchar *infoLog)) ldg_find("glGetProgramInfoLog", lib);
	GL_CHECK(glp->GetProgramInfoLog);
	glp->GetProgramInterfaceiv = (void APIENTRY (*)(GLuint program, GLenum programInterface, GLenum pname, GLint *params)) ldg_find("glGetProgramInterfaceiv", lib);
	GL_CHECK(glp->GetProgramInterfaceiv);
	glp->GetProgramLocalParameterIivNV = (void APIENTRY (*)(GLenum target, GLuint index, GLint *params)) ldg_find("glGetProgramLocalParameterIivNV", lib);
	GL_CHECK(glp->GetProgramLocalParameterIivNV);
	glp->GetProgramLocalParameterIuivNV = (void APIENTRY (*)(GLenum target, GLuint index, GLuint *params)) ldg_find("glGetProgramLocalParameterIuivNV", lib);
	GL_CHECK(glp->GetProgramLocalParameterIuivNV);
	glp->GetProgramPipelineInfoLog = (void APIENTRY (*)(GLuint pipeline, GLsizei bufSize, GLsizei *length, GLchar *infoLog)) ldg_find("glGetProgramPipelineInfoLog", lib);
	GL_CHECK(glp->GetProgramPipelineInfoLog);
	glp->GetProgramPipelineiv = (void APIENTRY (*)(GLuint pipeline, GLenum pname, GLint *params)) ldg_find("glGetProgramPipelineiv", lib);
	GL_CHECK(glp->GetProgramPipelineiv);
	glp->GetProgramRegisterfvMESA = (void APIENTRY (*)(GLenum target, GLsizei len, const GLubyte *name, GLfloat *v)) ldg_find("glGetProgramRegisterfvMESA", lib);
	GL_CHECK(glp->GetProgramRegisterfvMESA);
	glp->GetProgramResourceIndex = (GLuint APIENTRY (*)(GLuint program, GLenum programInterface, const GLchar *name)) ldg_find("glGetProgramResourceIndex", lib);
	GL_CHECK(glp->GetProgramResourceIndex);
	glp->GetProgramResourceLocation = (GLint APIENTRY (*)(GLuint program, GLenum programInterface, const GLchar *name)) ldg_find("glGetProgramResourceLocation", lib);
	GL_CHECK(glp->GetProgramResourceLocation);
	glp->GetProgramResourceLocationIndex = (GLint APIENTRY (*)(GLuint program, GLenum programInterface, const GLchar *name)) ldg_find("glGetProgramResourceLocationIndex", lib);
	GL_CHECK(glp->GetProgramResourceLocationIndex);
	glp->GetProgramResourceName = (void APIENTRY (*)(GLuint program, GLenum programInterface, GLuint index, GLsizei bufSize, GLsizei *length, GLchar *name)) ldg_find("glGetProgramResourceName", lib);
	GL_CHECK(glp->GetProgramResourceName);
	glp->GetProgramResourceiv = (void APIENTRY (*)(GLuint program, GLenum programInterface, GLuint index, GLsizei propCount, const GLenum *props, GLsizei bufSize, GLsizei *length, GLint *params)) ldg_find("glGetProgramResourceiv", lib);
	GL_CHECK(glp->GetProgramResourceiv);
	glp->GetProgramStageiv = (void APIENTRY (*)(GLuint program, GLenum shadertype, GLenum pname, GLint *values)) ldg_find("glGetProgramStageiv", lib);
	GL_CHECK(glp->GetProgramStageiv);
	glp->GetProgramSubroutineParameteruivNV = (void APIENTRY (*)(GLenum target, GLuint index, GLuint *param)) ldg_find("glGetProgramSubroutineParameteruivNV", lib);
	GL_CHECK(glp->GetProgramSubroutineParameteruivNV);
	glp->GetProgramiv = (void APIENTRY (*)(GLuint program, GLenum pname, GLint *params)) ldg_find("glGetProgramiv", lib);
	GL_CHECK(glp->GetProgramiv);
	glp->GetQueryIndexediv = (void APIENTRY (*)(GLenum target, GLuint index, GLenum pname, GLint *params)) ldg_find("glGetQueryIndexediv", lib);
	GL_CHECK(glp->GetQueryIndexediv);
	glp->GetQueryObjecti64v = (void APIENTRY (*)(GLuint id, GLenum pname, GLint64 *params)) ldg_find("glGetQueryObjecti64v", lib);
	GL_CHECK(glp->GetQueryObjecti64v);
	glp->GetQueryObjecti64vEXT = (void APIENTRY (*)(GLuint id, GLenum pname, GLint64 *params)) ldg_find("glGetQueryObjecti64vEXT", lib);
	GL_CHECK(glp->GetQueryObjecti64vEXT);
	glp->GetQueryObjectui64v = (void APIENTRY (*)(GLuint id, GLenum pname, GLuint64 *params)) ldg_find("glGetQueryObjectui64v", lib);
	GL_CHECK(glp->GetQueryObjectui64v);
	glp->GetQueryObjectui64vEXT = (void APIENTRY (*)(GLuint id, GLenum pname, GLuint64 *params)) ldg_find("glGetQueryObjectui64vEXT", lib);
	GL_CHECK(glp->GetQueryObjectui64vEXT);
	glp->GetRenderbufferParameteriv = (void APIENTRY (*)(GLenum target, GLenum pname, GLint *params)) ldg_find("glGetRenderbufferParameteriv", lib);
	GL_CHECK(glp->GetRenderbufferParameteriv);
	glp->GetRenderbufferParameterivEXT = (void APIENTRY (*)(GLenum target, GLenum pname, GLint *params)) ldg_find("glGetRenderbufferParameterivEXT", lib);
	GL_CHECK(glp->GetRenderbufferParameterivEXT);
	glp->GetSamplerParameterIiv = (void APIENTRY (*)(GLuint sampler, GLenum pname, GLint *params)) ldg_find("glGetSamplerParameterIiv", lib);
	GL_CHECK(glp->GetSamplerParameterIiv);
	glp->GetSamplerParameterIuiv = (void APIENTRY (*)(GLuint sampler, GLenum pname, GLuint *params)) ldg_find("glGetSamplerParameterIuiv", lib);
	GL_CHECK(glp->GetSamplerParameterIuiv);
	glp->GetSamplerParameterfv = (void APIENTRY (*)(GLuint sampler, GLenum pname, GLfloat *params)) ldg_find("glGetSamplerParameterfv", lib);
	GL_CHECK(glp->GetSamplerParameterfv);
	glp->GetSamplerParameteriv = (void APIENTRY (*)(GLuint sampler, GLenum pname, GLint *params)) ldg_find("glGetSamplerParameteriv", lib);
	GL_CHECK(glp->GetSamplerParameteriv);
	glp->GetShaderInfoLog = (void APIENTRY (*)(GLuint shader, GLsizei bufSize, GLsizei *length, GLchar *infoLog)) ldg_find("glGetShaderInfoLog", lib);
	GL_CHECK(glp->GetShaderInfoLog);
	glp->GetShaderPrecisionFormat = (void APIENTRY (*)(GLenum shadertype, GLenum precisiontype, GLint *range, GLint *precision)) ldg_find("glGetShaderPrecisionFormat", lib);
	GL_CHECK(glp->GetShaderPrecisionFormat);
	glp->GetShaderSource = (void APIENTRY (*)(GLuint shader, GLsizei bufSize, GLsizei *length, GLchar *source)) ldg_find("glGetShaderSource", lib);
	GL_CHECK(glp->GetShaderSource);
	glp->GetShaderiv = (void APIENTRY (*)(GLuint shader, GLenum pname, GLint *params)) ldg_find("glGetShaderiv", lib);
	GL_CHECK(glp->GetShaderiv);
	glp->GetStringi = (const GLubyte * APIENTRY (*)(GLenum name, GLuint index)) ldg_find("glGetStringi", lib);
	GL_CHECK(glp->GetStringi);
	glp->GetSubroutineIndex = (GLuint APIENTRY (*)(GLuint program, GLenum shadertype, const GLchar *name)) ldg_find("glGetSubroutineIndex", lib);
	GL_CHECK(glp->GetSubroutineIndex);
	glp->GetSubroutineUniformLocation = (GLint APIENTRY (*)(GLuint program, GLenum shadertype, const GLchar *name)) ldg_find("glGetSubroutineUniformLocation", lib);
	GL_CHECK(glp->GetSubroutineUniformLocation);
	glp->GetSynciv = (void APIENTRY (*)(GLsync sync, GLenum pname, GLsizei bufSize, GLsizei *length, GLint *values)) ldg_find("glGetSynciv", lib);
	GL_CHECK(glp->GetSynciv);
	glp->GetTexEnvxvOES = (void APIENTRY (*)(GLenum target, GLenum pname, GLfixed *params)) ldg_find("glGetTexEnvxvOES", lib);
	GL_CHECK(glp->GetTexEnvxvOES);
	glp->GetTexGenxvOES = (void APIENTRY (*)(GLenum coord, GLenum pname, GLfixed *params)) ldg_find("glGetTexGenxvOES", lib);
	GL_CHECK(glp->GetTexGenxvOES);
	glp->GetTexLevelParameterxvOES = (void APIENTRY (*)(GLenum target, GLint level, GLenum pname, GLfixed *params)) ldg_find("glGetTexLevelParameterxvOES", lib);
	GL_CHECK(glp->GetTexLevelParameterxvOES);
	glp->GetTexParameterIiv = (void APIENTRY (*)(GLenum target, GLenum pname, GLint *params)) ldg_find("glGetTexParameterIiv", lib);
	GL_CHECK(glp->GetTexParameterIiv);
	glp->GetTexParameterIivEXT = (void APIENTRY (*)(GLenum target, GLenum pname, GLint *params)) ldg_find("glGetTexParameterIivEXT", lib);
	GL_CHECK(glp->GetTexParameterIivEXT);
	glp->GetTexParameterIuiv = (void APIENTRY (*)(GLenum target, GLenum pname, GLuint *params)) ldg_find("glGetTexParameterIuiv", lib);
	GL_CHECK(glp->GetTexParameterIuiv);
	glp->GetTexParameterIuivEXT = (void APIENTRY (*)(GLenum target, GLenum pname, GLuint *params)) ldg_find("glGetTexParameterIuivEXT", lib);
	GL_CHECK(glp->GetTexParameterIuivEXT);
	glp->GetTexParameterPointervAPPLE = (void APIENTRY (*)(GLenum target, GLenum pname, void * *params)) ldg_find("glGetTexParameterPointervAPPLE", lib);
	GL_CHECK(glp->GetTexParameterPointervAPPLE);
	glp->GetTexParameterxvOES = (void APIENTRY (*)(GLenum target, GLenum pname, GLfixed *params)) ldg_find("glGetTexParameterxvOES", lib);
	GL_CHECK(glp->GetTexParameterxvOES);
	glp->GetTextureHandleARB = (GLuint64 APIENTRY (*)(GLuint texture)) ldg_find("glGetTextureHandleARB", lib);
	GL_CHECK(glp->GetTextureHandleARB);
	glp->GetTextureHandleNV = (GLuint64 APIENTRY (*)(GLuint texture)) ldg_find("glGetTextureHandleNV", lib);
	GL_CHECK(glp->GetTextureHandleNV);
	glp->GetTextureImageEXT = (void APIENTRY (*)(GLuint texture, GLenum target, GLint level, GLenum format, GLenum type, void *pixels)) ldg_find("glGetTextureImageEXT", lib);
	GL_CHECK(glp->GetTextureImageEXT);
	glp->GetTextureLevelParameterfvEXT = (void APIENTRY (*)(GLuint texture, GLenum target, GLint level, GLenum pname, GLfloat *params)) ldg_find("glGetTextureLevelParameterfvEXT", lib);
	GL_CHECK(glp->GetTextureLevelParameterfvEXT);
	glp->GetTextureLevelParameterivEXT = (void APIENTRY (*)(GLuint texture, GLenum target, GLint level, GLenum pname, GLint *params)) ldg_find("glGetTextureLevelParameterivEXT", lib);
	GL_CHECK(glp->GetTextureLevelParameterivEXT);
	glp->GetTextureParameterIivEXT = (void APIENTRY (*)(GLuint texture, GLenum target, GLenum pname, GLint *params)) ldg_find("glGetTextureParameterIivEXT", lib);
	GL_CHECK(glp->GetTextureParameterIivEXT);
	glp->GetTextureParameterIuivEXT = (void APIENTRY (*)(GLuint texture, GLenum target, GLenum pname, GLuint *params)) ldg_find("glGetTextureParameterIuivEXT", lib);
	GL_CHECK(glp->GetTextureParameterIuivEXT);
	glp->GetTextureParameterfvEXT = (void APIENTRY (*)(GLuint texture, GLenum target, GLenum pname, GLfloat *params)) ldg_find("glGetTextureParameterfvEXT", lib);
	GL_CHECK(glp->GetTextureParameterfvEXT);
	glp->GetTextureParameterivEXT = (void APIENTRY (*)(GLuint texture, GLenum target, GLenum pname, GLint *params)) ldg_find("glGetTextureParameterivEXT", lib);
	GL_CHECK(glp->GetTextureParameterivEXT);
	glp->GetTextureSamplerHandleARB = (GLuint64 APIENTRY (*)(GLuint texture, GLuint sampler)) ldg_find("glGetTextureSamplerHandleARB", lib);
	GL_CHECK(glp->GetTextureSamplerHandleARB);
	glp->GetTextureSamplerHandleNV = (GLuint64 APIENTRY (*)(GLuint texture, GLuint sampler)) ldg_find("glGetTextureSamplerHandleNV", lib);
	GL_CHECK(glp->GetTextureSamplerHandleNV);
	glp->GetTransformFeedbackVarying = (void APIENTRY (*)(GLuint program, GLuint index, GLsizei bufSize, GLsizei *length, GLsizei *size, GLenum *type, GLchar *name)) ldg_find("glGetTransformFeedbackVarying", lib);
	GL_CHECK(glp->GetTransformFeedbackVarying);
	glp->GetTransformFeedbackVaryingEXT = (void APIENTRY (*)(GLuint program, GLuint index, GLsizei bufSize, GLsizei *length, GLsizei *size, GLenum *type, GLchar *name)) ldg_find("glGetTransformFeedbackVaryingEXT", lib);
	GL_CHECK(glp->GetTransformFeedbackVaryingEXT);
	glp->GetTransformFeedbackVaryingNV = (void APIENTRY (*)(GLuint program, GLuint index, GLint *location)) ldg_find("glGetTransformFeedbackVaryingNV", lib);
	GL_CHECK(glp->GetTransformFeedbackVaryingNV);
	glp->GetUniformBlockIndex = (GLuint APIENTRY (*)(GLuint program, const GLchar *uniformBlockName)) ldg_find("glGetUniformBlockIndex", lib);
	GL_CHECK(glp->GetUniformBlockIndex);
	glp->GetUniformBufferSizeEXT = (GLint APIENTRY (*)(GLuint program, GLint location)) ldg_find("glGetUniformBufferSizeEXT", lib);
	GL_CHECK(glp->GetUniformBufferSizeEXT);
	glp->GetUniformIndices = (void APIENTRY (*)(GLuint program, GLsizei uniformCount, const GLchar *const *uniformNames, GLuint *uniformIndices)) ldg_find("glGetUniformIndices", lib);
	GL_CHECK(glp->GetUniformIndices);
	glp->GetUniformLocation = (GLint APIENTRY (*)(GLuint program, const GLchar *name)) ldg_find("glGetUniformLocation", lib);
	GL_CHECK(glp->GetUniformLocation);
	glp->GetUniformOffsetEXT = (GLintptr APIENTRY (*)(GLuint program, GLint location)) ldg_find("glGetUniformOffsetEXT", lib);
	GL_CHECK(glp->GetUniformOffsetEXT);
	glp->GetUniformSubroutineuiv = (void APIENTRY (*)(GLenum shadertype, GLint location, GLuint *params)) ldg_find("glGetUniformSubroutineuiv", lib);
	GL_CHECK(glp->GetUniformSubroutineuiv);
	glp->GetUniformdv = (void APIENTRY (*)(GLuint program, GLint location, GLdouble *params)) ldg_find("glGetUniformdv", lib);
	GL_CHECK(glp->GetUniformdv);
	glp->GetUniformfv = (void APIENTRY (*)(GLuint program, GLint location, GLfloat *params)) ldg_find("glGetUniformfv", lib);
	GL_CHECK(glp->GetUniformfv);
	glp->GetUniformi64vNV = (void APIENTRY (*)(GLuint program, GLint location, GLint64EXT *params)) ldg_find("glGetUniformi64vNV", lib);
	GL_CHECK(glp->GetUniformi64vNV);
	glp->GetUniformiv = (void APIENTRY (*)(GLuint program, GLint location, GLint *params)) ldg_find("glGetUniformiv", lib);
	GL_CHECK(glp->GetUniformiv);
	glp->GetUniformui64vNV = (void APIENTRY (*)(GLuint program, GLint location, GLuint64EXT *params)) ldg_find("glGetUniformui64vNV", lib);
	GL_CHECK(glp->GetUniformui64vNV);
	glp->GetUniformuiv = (void APIENTRY (*)(GLuint program, GLint location, GLuint *params)) ldg_find("glGetUniformuiv", lib);
	GL_CHECK(glp->GetUniformuiv);
	glp->GetUniformuivEXT = (void APIENTRY (*)(GLuint program, GLint location, GLuint *params)) ldg_find("glGetUniformuivEXT", lib);
	GL_CHECK(glp->GetUniformuivEXT);
	glp->GetVaryingLocationNV = (GLint APIENTRY (*)(GLuint program, const GLchar *name)) ldg_find("glGetVaryingLocationNV", lib);
	GL_CHECK(glp->GetVaryingLocationNV);
	glp->GetVertexArrayIntegeri_vEXT = (void APIENTRY (*)(GLuint vaobj, GLuint index, GLenum pname, GLint *param)) ldg_find("glGetVertexArrayIntegeri_vEXT", lib);
	GL_CHECK(glp->GetVertexArrayIntegeri_vEXT);
	glp->GetVertexArrayIntegervEXT = (void APIENTRY (*)(GLuint vaobj, GLenum pname, GLint *param)) ldg_find("glGetVertexArrayIntegervEXT", lib);
	GL_CHECK(glp->GetVertexArrayIntegervEXT);
	glp->GetVertexArrayPointeri_vEXT = (void APIENTRY (*)(GLuint vaobj, GLuint index, GLenum pname, void * *param)) ldg_find("glGetVertexArrayPointeri_vEXT", lib);
	GL_CHECK(glp->GetVertexArrayPointeri_vEXT);
	glp->GetVertexArrayPointervEXT = (void APIENTRY (*)(GLuint vaobj, GLenum pname, void * *param)) ldg_find("glGetVertexArrayPointervEXT", lib);
	GL_CHECK(glp->GetVertexArrayPointervEXT);
	glp->GetVertexAttribIiv = (void APIENTRY (*)(GLuint index, GLenum pname, GLint *params)) ldg_find("glGetVertexAttribIiv", lib);
	GL_CHECK(glp->GetVertexAttribIiv);
	glp->GetVertexAttribIivEXT = (void APIENTRY (*)(GLuint index, GLenum pname, GLint *params)) ldg_find("glGetVertexAttribIivEXT", lib);
	GL_CHECK(glp->GetVertexAttribIivEXT);
	glp->GetVertexAttribIuiv = (void APIENTRY (*)(GLuint index, GLenum pname, GLuint *params)) ldg_find("glGetVertexAttribIuiv", lib);
	GL_CHECK(glp->GetVertexAttribIuiv);
	glp->GetVertexAttribIuivEXT = (void APIENTRY (*)(GLuint index, GLenum pname, GLuint *params)) ldg_find("glGetVertexAttribIuivEXT", lib);
	GL_CHECK(glp->GetVertexAttribIuivEXT);
	glp->GetVertexAttribLdv = (void APIENTRY (*)(GLuint index, GLenum pname, GLdouble *params)) ldg_find("glGetVertexAttribLdv", lib);
	GL_CHECK(glp->GetVertexAttribLdv);
	glp->GetVertexAttribLdvEXT = (void APIENTRY (*)(GLuint index, GLenum pname, GLdouble *params)) ldg_find("glGetVertexAttribLdvEXT", lib);
	GL_CHECK(glp->GetVertexAttribLdvEXT);
	glp->GetVertexAttribLi64vNV = (void APIENTRY (*)(GLuint index, GLenum pname, GLint64EXT *params)) ldg_find("glGetVertexAttribLi64vNV", lib);
	GL_CHECK(glp->GetVertexAttribLi64vNV);
	glp->GetVertexAttribLui64vARB = (void APIENTRY (*)(GLuint index, GLenum pname, GLuint64EXT *params)) ldg_find("glGetVertexAttribLui64vARB", lib);
	GL_CHECK(glp->GetVertexAttribLui64vARB);
	glp->GetVertexAttribLui64vNV = (void APIENTRY (*)(GLuint index, GLenum pname, GLuint64EXT *params)) ldg_find("glGetVertexAttribLui64vNV", lib);
	GL_CHECK(glp->GetVertexAttribLui64vNV);
	glp->GetVertexAttribPointerv = (void APIENTRY (*)(GLuint index, GLenum pname, void * *pointer)) ldg_find("glGetVertexAttribPointerv", lib);
	GL_CHECK(glp->GetVertexAttribPointerv);
	glp->GetVertexAttribdv = (void APIENTRY (*)(GLuint index, GLenum pname, GLdouble *params)) ldg_find("glGetVertexAttribdv", lib);
	GL_CHECK(glp->GetVertexAttribdv);
	glp->GetVertexAttribfv = (void APIENTRY (*)(GLuint index, GLenum pname, GLfloat *params)) ldg_find("glGetVertexAttribfv", lib);
	GL_CHECK(glp->GetVertexAttribfv);
	glp->GetVertexAttribiv = (void APIENTRY (*)(GLuint index, GLenum pname, GLint *params)) ldg_find("glGetVertexAttribiv", lib);
	GL_CHECK(glp->GetVertexAttribiv);
	glp->GetVideoCaptureStreamdvNV = (void APIENTRY (*)(GLuint video_capture_slot, GLuint stream, GLenum pname, GLdouble *params)) ldg_find("glGetVideoCaptureStreamdvNV", lib);
	GL_CHECK(glp->GetVideoCaptureStreamdvNV);
	glp->GetVideoCaptureStreamfvNV = (void APIENTRY (*)(GLuint video_capture_slot, GLuint stream, GLenum pname, GLfloat *params)) ldg_find("glGetVideoCaptureStreamfvNV", lib);
	GL_CHECK(glp->GetVideoCaptureStreamfvNV);
	glp->GetVideoCaptureStreamivNV = (void APIENTRY (*)(GLuint video_capture_slot, GLuint stream, GLenum pname, GLint *params)) ldg_find("glGetVideoCaptureStreamivNV", lib);
	GL_CHECK(glp->GetVideoCaptureStreamivNV);
	glp->GetVideoCaptureivNV = (void APIENTRY (*)(GLuint video_capture_slot, GLenum pname, GLint *params)) ldg_find("glGetVideoCaptureivNV", lib);
	GL_CHECK(glp->GetVideoCaptureivNV);
	glp->GetVideoi64vNV = (void APIENTRY (*)(GLuint video_slot, GLenum pname, GLint64EXT *params)) ldg_find("glGetVideoi64vNV", lib);
	GL_CHECK(glp->GetVideoi64vNV);
	glp->GetVideoivNV = (void APIENTRY (*)(GLuint video_slot, GLenum pname, GLint *params)) ldg_find("glGetVideoivNV", lib);
	GL_CHECK(glp->GetVideoivNV);
	glp->GetVideoui64vNV = (void APIENTRY (*)(GLuint video_slot, GLenum pname, GLuint64EXT *params)) ldg_find("glGetVideoui64vNV", lib);
	GL_CHECK(glp->GetVideoui64vNV);
	glp->GetVideouivNV = (void APIENTRY (*)(GLuint video_slot, GLenum pname, GLuint *params)) ldg_find("glGetVideouivNV", lib);
	GL_CHECK(glp->GetVideouivNV);
	glp->GetnColorTableARB = (void APIENTRY (*)(GLenum target, GLenum format, GLenum type, GLsizei bufSize, void *table)) ldg_find("glGetnColorTableARB", lib);
	GL_CHECK(glp->GetnColorTableARB);
	glp->GetnCompressedTexImageARB = (void APIENTRY (*)(GLenum target, GLint lod, GLsizei bufSize, void *img)) ldg_find("glGetnCompressedTexImageARB", lib);
	GL_CHECK(glp->GetnCompressedTexImageARB);
	glp->GetnConvolutionFilterARB = (void APIENTRY (*)(GLenum target, GLenum format, GLenum type, GLsizei bufSize, void *image)) ldg_find("glGetnConvolutionFilterARB", lib);
	GL_CHECK(glp->GetnConvolutionFilterARB);
	glp->GetnHistogramARB = (void APIENTRY (*)(GLenum target, GLboolean32 reset, GLenum format, GLenum type, GLsizei bufSize, void *values)) ldg_find("glGetnHistogramARB", lib);
	GL_CHECK(glp->GetnHistogramARB);
	glp->GetnMapdvARB = (void APIENTRY (*)(GLenum target, GLenum query, GLsizei bufSize, GLdouble *v)) ldg_find("glGetnMapdvARB", lib);
	GL_CHECK(glp->GetnMapdvARB);
	glp->GetnMapfvARB = (void APIENTRY (*)(GLenum target, GLenum query, GLsizei bufSize, GLfloat *v)) ldg_find("glGetnMapfvARB", lib);
	GL_CHECK(glp->GetnMapfvARB);
	glp->GetnMapivARB = (void APIENTRY (*)(GLenum target, GLenum query, GLsizei bufSize, GLint *v)) ldg_find("glGetnMapivARB", lib);
	GL_CHECK(glp->GetnMapivARB);
	glp->GetnMinmaxARB = (void APIENTRY (*)(GLenum target, GLboolean32 reset, GLenum format, GLenum type, GLsizei bufSize, void *values)) ldg_find("glGetnMinmaxARB", lib);
	GL_CHECK(glp->GetnMinmaxARB);
	glp->GetnPixelMapfvARB = (void APIENTRY (*)(GLenum map, GLsizei bufSize, GLfloat *values)) ldg_find("glGetnPixelMapfvARB", lib);
	GL_CHECK(glp->GetnPixelMapfvARB);
	glp->GetnPixelMapuivARB = (void APIENTRY (*)(GLenum map, GLsizei bufSize, GLuint *values)) ldg_find("glGetnPixelMapuivARB", lib);
	GL_CHECK(glp->GetnPixelMapuivARB);
	glp->GetnPixelMapusvARB = (void APIENTRY (*)(GLenum map, GLsizei bufSize, GLushort *values)) ldg_find("glGetnPixelMapusvARB", lib);
	GL_CHECK(glp->GetnPixelMapusvARB);
	glp->GetnPolygonStippleARB = (void APIENTRY (*)(GLsizei bufSize, GLubyte *pattern)) ldg_find("glGetnPolygonStippleARB", lib);
	GL_CHECK(glp->GetnPolygonStippleARB);
	glp->GetnSeparableFilterARB = (void APIENTRY (*)(GLenum target, GLenum format, GLenum type, GLsizei rowBufSize, void *row, GLsizei columnBufSize, void *column, void *span)) ldg_find("glGetnSeparableFilterARB", lib);
	GL_CHECK(glp->GetnSeparableFilterARB);
	glp->GetnTexImageARB = (void APIENTRY (*)(GLenum target, GLint level, GLenum format, GLenum type, GLsizei bufSize, void *img)) ldg_find("glGetnTexImageARB", lib);
	GL_CHECK(glp->GetnTexImageARB);
	glp->GetnUniformdvARB = (void APIENTRY (*)(GLuint program, GLint location, GLsizei bufSize, GLdouble *params)) ldg_find("glGetnUniformdvARB", lib);
	GL_CHECK(glp->GetnUniformdvARB);
	glp->GetnUniformfvARB = (void APIENTRY (*)(GLuint program, GLint location, GLsizei bufSize, GLfloat *params)) ldg_find("glGetnUniformfvARB", lib);
	GL_CHECK(glp->GetnUniformfvARB);
	glp->GetnUniformivARB = (void APIENTRY (*)(GLuint program, GLint location, GLsizei bufSize, GLint *params)) ldg_find("glGetnUniformivARB", lib);
	GL_CHECK(glp->GetnUniformivARB);
	glp->GetnUniformuivARB = (void APIENTRY (*)(GLuint program, GLint location, GLsizei bufSize, GLuint *params)) ldg_find("glGetnUniformuivARB", lib);
	GL_CHECK(glp->GetnUniformuivARB);
	glp->ImportSyncEXT = (GLsync APIENTRY (*)(GLenum external_sync_type, GLintptr external_sync, GLbitfield flags)) ldg_find("glImportSyncEXT", lib);
	GL_CHECK(glp->ImportSyncEXT);
	glp->IndexFormatNV = (void APIENTRY (*)(GLenum type, GLsizei stride)) ldg_find("glIndexFormatNV", lib);
	GL_CHECK(glp->IndexFormatNV);
	glp->IndexxOES = (void APIENTRY (*)(GLfixed component)) ldg_find("glIndexxOES", lib);
	GL_CHECK(glp->IndexxOES);
	glp->IndexxvOES = (void APIENTRY (*)(const GLfixed *component)) ldg_find("glIndexxvOES", lib);
	GL_CHECK(glp->IndexxvOES);
	glp->InsertEventMarkerEXT = (void APIENTRY (*)(GLsizei length, const GLchar *marker)) ldg_find("glInsertEventMarkerEXT", lib);
	GL_CHECK(glp->InsertEventMarkerEXT);
	glp->InterpolatePathsNV = (void APIENTRY (*)(GLuint resultPath, GLuint pathA, GLuint pathB, GLfloat weight)) ldg_find("glInterpolatePathsNV", lib);
	GL_CHECK(glp->InterpolatePathsNV);
	glp->InvalidateBufferData = (void APIENTRY (*)(GLuint buffer)) ldg_find("glInvalidateBufferData", lib);
	GL_CHECK(glp->InvalidateBufferData);
	glp->InvalidateBufferSubData = (void APIENTRY (*)(GLuint buffer, GLintptr offset, GLsizeiptr length)) ldg_find("glInvalidateBufferSubData", lib);
	GL_CHECK(glp->InvalidateBufferSubData);
	glp->InvalidateFramebuffer = (void APIENTRY (*)(GLenum target, GLsizei numAttachments, const GLenum *attachments)) ldg_find("glInvalidateFramebuffer", lib);
	GL_CHECK(glp->InvalidateFramebuffer);
	glp->InvalidateSubFramebuffer = (void APIENTRY (*)(GLenum target, GLsizei numAttachments, const GLenum *attachments, GLint x, GLint y, GLsizei width, GLsizei height)) ldg_find("glInvalidateSubFramebuffer", lib);
	GL_CHECK(glp->InvalidateSubFramebuffer);
	glp->InvalidateTexImage = (void APIENTRY (*)(GLuint texture, GLint level)) ldg_find("glInvalidateTexImage", lib);
	GL_CHECK(glp->InvalidateTexImage);
	glp->InvalidateTexSubImage = (void APIENTRY (*)(GLuint texture, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth)) ldg_find("glInvalidateTexSubImage", lib);
	GL_CHECK(glp->InvalidateTexSubImage);
	glp->IsBufferResidentNV = (GLboolean APIENTRY (*)(GLenum target)) ldg_find("glIsBufferResidentNV", lib);
	GL_CHECK(glp->IsBufferResidentNV);
	glp->IsEnabledIndexedEXT = (GLboolean APIENTRY (*)(GLenum target, GLuint index)) ldg_find("glIsEnabledIndexedEXT", lib);
	GL_CHECK(glp->IsEnabledIndexedEXT);
	glp->IsEnabledi = (GLboolean APIENTRY (*)(GLenum target, GLuint index)) ldg_find("glIsEnabledi", lib);
	GL_CHECK(glp->IsEnabledi);
	glp->IsFramebuffer = (GLboolean APIENTRY (*)(GLuint framebuffer)) ldg_find("glIsFramebuffer", lib);
	GL_CHECK(glp->IsFramebuffer);
	glp->IsFramebufferEXT = (GLboolean APIENTRY (*)(GLuint framebuffer)) ldg_find("glIsFramebufferEXT", lib);
	GL_CHECK(glp->IsFramebufferEXT);
	glp->IsImageHandleResidentARB = (GLboolean APIENTRY (*)(GLuint64 handle)) ldg_find("glIsImageHandleResidentARB", lib);
	GL_CHECK(glp->IsImageHandleResidentARB);
	glp->IsImageHandleResidentNV = (GLboolean APIENTRY (*)(GLuint64 handle)) ldg_find("glIsImageHandleResidentNV", lib);
	GL_CHECK(glp->IsImageHandleResidentNV);
	glp->IsNameAMD = (GLboolean APIENTRY (*)(GLenum identifier, GLuint name)) ldg_find("glIsNameAMD", lib);
	GL_CHECK(glp->IsNameAMD);
	glp->IsNamedBufferResidentNV = (GLboolean APIENTRY (*)(GLuint buffer)) ldg_find("glIsNamedBufferResidentNV", lib);
	GL_CHECK(glp->IsNamedBufferResidentNV);
	glp->IsNamedStringARB = (GLboolean APIENTRY (*)(GLint namelen, const GLchar *name)) ldg_find("glIsNamedStringARB", lib);
	GL_CHECK(glp->IsNamedStringARB);
	glp->IsPathNV = (GLboolean APIENTRY (*)(GLuint path)) ldg_find("glIsPathNV", lib);
	GL_CHECK(glp->IsPathNV);
	glp->IsPointInFillPathNV = (GLboolean APIENTRY (*)(GLuint path, GLuint mask, GLfloat x, GLfloat y)) ldg_find("glIsPointInFillPathNV", lib);
	GL_CHECK(glp->IsPointInFillPathNV);
	glp->IsPointInStrokePathNV = (GLboolean APIENTRY (*)(GLuint path, GLfloat x, GLfloat y)) ldg_find("glIsPointInStrokePathNV", lib);
	GL_CHECK(glp->IsPointInStrokePathNV);
	glp->IsProgram = (GLboolean APIENTRY (*)(GLuint program)) ldg_find("glIsProgram", lib);
	GL_CHECK(glp->IsProgram);
	glp->IsProgramPipeline = (GLboolean APIENTRY (*)(GLuint pipeline)) ldg_find("glIsProgramPipeline", lib);
	GL_CHECK(glp->IsProgramPipeline);
	glp->IsRenderbuffer = (GLboolean APIENTRY (*)(GLuint renderbuffer)) ldg_find("glIsRenderbuffer", lib);
	GL_CHECK(glp->IsRenderbuffer);
	glp->IsRenderbufferEXT = (GLboolean APIENTRY (*)(GLuint renderbuffer)) ldg_find("glIsRenderbufferEXT", lib);
	GL_CHECK(glp->IsRenderbufferEXT);
	glp->IsSampler = (GLboolean APIENTRY (*)(GLuint sampler)) ldg_find("glIsSampler", lib);
	GL_CHECK(glp->IsSampler);
	glp->IsShader = (GLboolean APIENTRY (*)(GLuint shader)) ldg_find("glIsShader", lib);
	GL_CHECK(glp->IsShader);
	glp->IsSync = (GLboolean APIENTRY (*)(GLsync sync)) ldg_find("glIsSync", lib);
	GL_CHECK(glp->IsSync);
	glp->IsTextureHandleResidentARB = (GLboolean APIENTRY (*)(GLuint64 handle)) ldg_find("glIsTextureHandleResidentARB", lib);
	GL_CHECK(glp->IsTextureHandleResidentARB);
	glp->IsTextureHandleResidentNV = (GLboolean APIENTRY (*)(GLuint64 handle)) ldg_find("glIsTextureHandleResidentNV", lib);
	GL_CHECK(glp->IsTextureHandleResidentNV);
	glp->IsTransformFeedback = (GLboolean APIENTRY (*)(GLuint id)) ldg_find("glIsTransformFeedback", lib);
	GL_CHECK(glp->IsTransformFeedback);
	glp->IsTransformFeedbackNV = (GLboolean APIENTRY (*)(GLuint id)) ldg_find("glIsTransformFeedbackNV", lib);
	GL_CHECK(glp->IsTransformFeedbackNV);
	glp->IsVertexArray = (GLboolean APIENTRY (*)(GLuint array)) ldg_find("glIsVertexArray", lib);
	GL_CHECK(glp->IsVertexArray);
	glp->IsVertexAttribEnabledAPPLE = (GLboolean APIENTRY (*)(GLuint index, GLenum pname)) ldg_find("glIsVertexAttribEnabledAPPLE", lib);
	GL_CHECK(glp->IsVertexAttribEnabledAPPLE);
	glp->LabelObjectEXT = (void APIENTRY (*)(GLenum type, GLuint object, GLsizei length, const GLchar *label)) ldg_find("glLabelObjectEXT", lib);
	GL_CHECK(glp->LabelObjectEXT);
	glp->LightModelxOES = (void APIENTRY (*)(GLenum pname, GLfixed param)) ldg_find("glLightModelxOES", lib);
	GL_CHECK(glp->LightModelxOES);
	glp->LightModelxvOES = (void APIENTRY (*)(GLenum pname, const GLfixed *param)) ldg_find("glLightModelxvOES", lib);
	GL_CHECK(glp->LightModelxvOES);
	glp->LightxOES = (void APIENTRY (*)(GLenum light, GLenum pname, GLfixed param)) ldg_find("glLightxOES", lib);
	GL_CHECK(glp->LightxOES);
	glp->LightxvOES = (void APIENTRY (*)(GLenum light, GLenum pname, const GLfixed *params)) ldg_find("glLightxvOES", lib);
	GL_CHECK(glp->LightxvOES);
	glp->LineWidthxOES = (void APIENTRY (*)(GLfixed width)) ldg_find("glLineWidthxOES", lib);
	GL_CHECK(glp->LineWidthxOES);
	glp->LinkProgram = (void APIENTRY (*)(GLuint program)) ldg_find("glLinkProgram", lib);
	GL_CHECK(glp->LinkProgram);
	glp->LoadMatrixxOES = (void APIENTRY (*)(const GLfixed *m)) ldg_find("glLoadMatrixxOES", lib);
	GL_CHECK(glp->LoadMatrixxOES);
	glp->LoadTransposeMatrixxOES = (void APIENTRY (*)(const GLfixed *m)) ldg_find("glLoadTransposeMatrixxOES", lib);
	GL_CHECK(glp->LoadTransposeMatrixxOES);
	glp->MakeBufferNonResidentNV = (void APIENTRY (*)(GLenum target)) ldg_find("glMakeBufferNonResidentNV", lib);
	GL_CHECK(glp->MakeBufferNonResidentNV);
	glp->MakeBufferResidentNV = (void APIENTRY (*)(GLenum target, GLenum access)) ldg_find("glMakeBufferResidentNV", lib);
	GL_CHECK(glp->MakeBufferResidentNV);
	glp->MakeImageHandleNonResidentARB = (void APIENTRY (*)(GLuint64 handle)) ldg_find("glMakeImageHandleNonResidentARB", lib);
	GL_CHECK(glp->MakeImageHandleNonResidentARB);
	glp->MakeImageHandleNonResidentNV = (void APIENTRY (*)(GLuint64 handle)) ldg_find("glMakeImageHandleNonResidentNV", lib);
	GL_CHECK(glp->MakeImageHandleNonResidentNV);
	glp->MakeImageHandleResidentARB = (void APIENTRY (*)(GLuint64 handle, GLenum access)) ldg_find("glMakeImageHandleResidentARB", lib);
	GL_CHECK(glp->MakeImageHandleResidentARB);
	glp->MakeImageHandleResidentNV = (void APIENTRY (*)(GLuint64 handle, GLenum access)) ldg_find("glMakeImageHandleResidentNV", lib);
	GL_CHECK(glp->MakeImageHandleResidentNV);
	glp->MakeNamedBufferNonResidentNV = (void APIENTRY (*)(GLuint buffer)) ldg_find("glMakeNamedBufferNonResidentNV", lib);
	GL_CHECK(glp->MakeNamedBufferNonResidentNV);
	glp->MakeNamedBufferResidentNV = (void APIENTRY (*)(GLuint buffer, GLenum access)) ldg_find("glMakeNamedBufferResidentNV", lib);
	GL_CHECK(glp->MakeNamedBufferResidentNV);
	glp->MakeTextureHandleNonResidentARB = (void APIENTRY (*)(GLuint64 handle)) ldg_find("glMakeTextureHandleNonResidentARB", lib);
	GL_CHECK(glp->MakeTextureHandleNonResidentARB);
	glp->MakeTextureHandleNonResidentNV = (void APIENTRY (*)(GLuint64 handle)) ldg_find("glMakeTextureHandleNonResidentNV", lib);
	GL_CHECK(glp->MakeTextureHandleNonResidentNV);
	glp->MakeTextureHandleResidentARB = (void APIENTRY (*)(GLuint64 handle)) ldg_find("glMakeTextureHandleResidentARB", lib);
	GL_CHECK(glp->MakeTextureHandleResidentARB);
	glp->MakeTextureHandleResidentNV = (void APIENTRY (*)(GLuint64 handle)) ldg_find("glMakeTextureHandleResidentNV", lib);
	GL_CHECK(glp->MakeTextureHandleResidentNV);
	glp->Map1xOES = (void APIENTRY (*)(GLenum target, GLfixed u1, GLfixed u2, GLint stride, GLint order, GLfixed points)) ldg_find("glMap1xOES", lib);
	GL_CHECK(glp->Map1xOES);
	glp->Map2xOES = (void APIENTRY (*)(GLenum target, GLfixed u1, GLfixed u2, GLint ustride, GLint uorder, GLfixed v1, GLfixed v2, GLint vstride, GLint vorder, GLfixed points)) ldg_find("glMap2xOES", lib);
	GL_CHECK(glp->Map2xOES);
	glp->MapBufferRange = (void * APIENTRY (*)(GLenum target, GLintptr offset, GLsizeiptr length, GLbitfield access)) ldg_find("glMapBufferRange", lib);
	GL_CHECK(glp->MapBufferRange);
	glp->MapGrid1xOES = (void APIENTRY (*)(GLint n, GLfixed u1, GLfixed u2)) ldg_find("glMapGrid1xOES", lib);
	GL_CHECK(glp->MapGrid1xOES);
	glp->MapGrid2xOES = (void APIENTRY (*)(GLint n, GLfixed u1, GLfixed u2, GLfixed v1, GLfixed v2)) ldg_find("glMapGrid2xOES", lib);
	GL_CHECK(glp->MapGrid2xOES);
	glp->MapNamedBufferEXT = (void * APIENTRY (*)(GLuint buffer, GLenum access)) ldg_find("glMapNamedBufferEXT", lib);
	GL_CHECK(glp->MapNamedBufferEXT);
	glp->MapNamedBufferRangeEXT = (void * APIENTRY (*)(GLuint buffer, GLintptr offset, GLsizeiptr length, GLbitfield access)) ldg_find("glMapNamedBufferRangeEXT", lib);
	GL_CHECK(glp->MapNamedBufferRangeEXT);
	glp->MapTexture2DINTEL = (void * APIENTRY (*)(GLuint texture, GLint level, GLbitfield access, const GLint *stride, const GLenum *layout)) ldg_find("glMapTexture2DINTEL", lib);
	GL_CHECK(glp->MapTexture2DINTEL);
	glp->MapVertexAttrib1dAPPLE = (void APIENTRY (*)(GLuint index, GLuint size, GLdouble u1, GLdouble u2, GLint stride, GLint order, const GLdouble *points)) ldg_find("glMapVertexAttrib1dAPPLE", lib);
	GL_CHECK(glp->MapVertexAttrib1dAPPLE);
	glp->MapVertexAttrib1fAPPLE = (void APIENTRY (*)(GLuint index, GLuint size, GLfloat u1, GLfloat u2, GLint stride, GLint order, const GLfloat *points)) ldg_find("glMapVertexAttrib1fAPPLE", lib);
	GL_CHECK(glp->MapVertexAttrib1fAPPLE);
	glp->MapVertexAttrib2dAPPLE = (void APIENTRY (*)(GLuint index, GLuint size, GLdouble u1, GLdouble u2, GLint ustride, GLint uorder, GLdouble v1, GLdouble v2, GLint vstride, GLint vorder, const GLdouble *points)) ldg_find("glMapVertexAttrib2dAPPLE", lib);
	GL_CHECK(glp->MapVertexAttrib2dAPPLE);
	glp->MapVertexAttrib2fAPPLE = (void APIENTRY (*)(GLuint index, GLuint size, GLfloat u1, GLfloat u2, GLint ustride, GLint uorder, GLfloat v1, GLfloat v2, GLint vstride, GLint vorder, const GLfloat *points)) ldg_find("glMapVertexAttrib2fAPPLE", lib);
	GL_CHECK(glp->MapVertexAttrib2fAPPLE);
	glp->MaterialxOES = (void APIENTRY (*)(GLenum face, GLenum pname, GLfixed param)) ldg_find("glMaterialxOES", lib);
	GL_CHECK(glp->MaterialxOES);
	glp->MaterialxvOES = (void APIENTRY (*)(GLenum face, GLenum pname, const GLfixed *param)) ldg_find("glMaterialxvOES", lib);
	GL_CHECK(glp->MaterialxvOES);
	glp->MatrixFrustumEXT = (void APIENTRY (*)(GLenum mode, GLdouble left, GLdouble right, GLdouble bottom, GLdouble top, GLdouble zNear, GLdouble zFar)) ldg_find("glMatrixFrustumEXT", lib);
	GL_CHECK(glp->MatrixFrustumEXT);
	glp->MatrixLoadIdentityEXT = (void APIENTRY (*)(GLenum mode)) ldg_find("glMatrixLoadIdentityEXT", lib);
	GL_CHECK(glp->MatrixLoadIdentityEXT);
	glp->MatrixLoadTransposedEXT = (void APIENTRY (*)(GLenum mode, const GLdouble *m)) ldg_find("glMatrixLoadTransposedEXT", lib);
	GL_CHECK(glp->MatrixLoadTransposedEXT);
	glp->MatrixLoadTransposefEXT = (void APIENTRY (*)(GLenum mode, const GLfloat *m)) ldg_find("glMatrixLoadTransposefEXT", lib);
	GL_CHECK(glp->MatrixLoadTransposefEXT);
	glp->MatrixLoaddEXT = (void APIENTRY (*)(GLenum mode, const GLdouble *m)) ldg_find("glMatrixLoaddEXT", lib);
	GL_CHECK(glp->MatrixLoaddEXT);
	glp->MatrixLoadfEXT = (void APIENTRY (*)(GLenum mode, const GLfloat *m)) ldg_find("glMatrixLoadfEXT", lib);
	GL_CHECK(glp->MatrixLoadfEXT);
	glp->MatrixMultTransposedEXT = (void APIENTRY (*)(GLenum mode, const GLdouble *m)) ldg_find("glMatrixMultTransposedEXT", lib);
	GL_CHECK(glp->MatrixMultTransposedEXT);
	glp->MatrixMultTransposefEXT = (void APIENTRY (*)(GLenum mode, const GLfloat *m)) ldg_find("glMatrixMultTransposefEXT", lib);
	GL_CHECK(glp->MatrixMultTransposefEXT);
	glp->MatrixMultdEXT = (void APIENTRY (*)(GLenum mode, const GLdouble *m)) ldg_find("glMatrixMultdEXT", lib);
	GL_CHECK(glp->MatrixMultdEXT);
	glp->MatrixMultfEXT = (void APIENTRY (*)(GLenum mode, const GLfloat *m)) ldg_find("glMatrixMultfEXT", lib);
	GL_CHECK(glp->MatrixMultfEXT);
	glp->MatrixOrthoEXT = (void APIENTRY (*)(GLenum mode, GLdouble left, GLdouble right, GLdouble bottom, GLdouble top, GLdouble zNear, GLdouble zFar)) ldg_find("glMatrixOrthoEXT", lib);
	GL_CHECK(glp->MatrixOrthoEXT);
	glp->MatrixPopEXT = (void APIENTRY (*)(GLenum mode)) ldg_find("glMatrixPopEXT", lib);
	GL_CHECK(glp->MatrixPopEXT);
	glp->MatrixPushEXT = (void APIENTRY (*)(GLenum mode)) ldg_find("glMatrixPushEXT", lib);
	GL_CHECK(glp->MatrixPushEXT);
	glp->MatrixRotatedEXT = (void APIENTRY (*)(GLenum mode, GLdouble angle, GLdouble x, GLdouble y, GLdouble z)) ldg_find("glMatrixRotatedEXT", lib);
	GL_CHECK(glp->MatrixRotatedEXT);
	glp->MatrixRotatefEXT = (void APIENTRY (*)(GLenum mode, GLfloat angle, GLfloat x, GLfloat y, GLfloat z)) ldg_find("glMatrixRotatefEXT", lib);
	GL_CHECK(glp->MatrixRotatefEXT);
	glp->MatrixScaledEXT = (void APIENTRY (*)(GLenum mode, GLdouble x, GLdouble y, GLdouble z)) ldg_find("glMatrixScaledEXT", lib);
	GL_CHECK(glp->MatrixScaledEXT);
	glp->MatrixScalefEXT = (void APIENTRY (*)(GLenum mode, GLfloat x, GLfloat y, GLfloat z)) ldg_find("glMatrixScalefEXT", lib);
	GL_CHECK(glp->MatrixScalefEXT);
	glp->MatrixTranslatedEXT = (void APIENTRY (*)(GLenum mode, GLdouble x, GLdouble y, GLdouble z)) ldg_find("glMatrixTranslatedEXT", lib);
	GL_CHECK(glp->MatrixTranslatedEXT);
	glp->MatrixTranslatefEXT = (void APIENTRY (*)(GLenum mode, GLfloat x, GLfloat y, GLfloat z)) ldg_find("glMatrixTranslatefEXT", lib);
	GL_CHECK(glp->MatrixTranslatefEXT);
	glp->MemoryBarrier = (void APIENTRY (*)(GLbitfield barriers)) ldg_find("glMemoryBarrier", lib);
	GL_CHECK(glp->MemoryBarrier);
	glp->MemoryBarrierEXT = (void APIENTRY (*)(GLbitfield barriers)) ldg_find("glMemoryBarrierEXT", lib);
	GL_CHECK(glp->MemoryBarrierEXT);
	glp->MinSampleShading = (void APIENTRY (*)(GLfloat value)) ldg_find("glMinSampleShading", lib);
	GL_CHECK(glp->MinSampleShading);
	glp->MinSampleShadingARB = (void APIENTRY (*)(GLfloat value)) ldg_find("glMinSampleShadingARB", lib);
	GL_CHECK(glp->MinSampleShadingARB);
	glp->MultMatrixxOES = (void APIENTRY (*)(const GLfixed *m)) ldg_find("glMultMatrixxOES", lib);
	GL_CHECK(glp->MultMatrixxOES);
	glp->MultTransposeMatrixxOES = (void APIENTRY (*)(const GLfixed *m)) ldg_find("glMultTransposeMatrixxOES", lib);
	GL_CHECK(glp->MultTransposeMatrixxOES);
	glp->MultiDrawArraysIndirect = (void APIENTRY (*)(GLenum mode, const void *indirect, GLsizei drawcount, GLsizei stride)) ldg_find("glMultiDrawArraysIndirect", lib);
	GL_CHECK(glp->MultiDrawArraysIndirect);
	glp->MultiDrawArraysIndirectAMD = (void APIENTRY (*)(GLenum mode, const void *indirect, GLsizei primcount, GLsizei stride)) ldg_find("glMultiDrawArraysIndirectAMD", lib);
	GL_CHECK(glp->MultiDrawArraysIndirectAMD);
	glp->MultiDrawArraysIndirectBindlessNV = (void APIENTRY (*)(GLenum mode, const void *indirect, GLsizei drawCount, GLsizei stride, GLint vertexBufferCount)) ldg_find("glMultiDrawArraysIndirectBindlessNV", lib);
	GL_CHECK(glp->MultiDrawArraysIndirectBindlessNV);
	glp->MultiDrawArraysIndirectCountARB = (void APIENTRY (*)(GLenum mode, const void *indirect, GLintptr drawcount, GLsizei maxdrawcount, GLsizei stride)) ldg_find("glMultiDrawArraysIndirectCountARB", lib);
	GL_CHECK(glp->MultiDrawArraysIndirectCountARB);
	glp->MultiDrawElementsBaseVertex = (void APIENTRY (*)(GLenum mode, const GLsizei *count, GLenum type, const void *const *indices, GLsizei drawcount, const GLint *basevertex)) ldg_find("glMultiDrawElementsBaseVertex", lib);
	GL_CHECK(glp->MultiDrawElementsBaseVertex);
	glp->MultiDrawElementsIndirect = (void APIENTRY (*)(GLenum mode, GLenum type, const void *indirect, GLsizei drawcount, GLsizei stride)) ldg_find("glMultiDrawElementsIndirect", lib);
	GL_CHECK(glp->MultiDrawElementsIndirect);
	glp->MultiDrawElementsIndirectAMD = (void APIENTRY (*)(GLenum mode, GLenum type, const void *indirect, GLsizei primcount, GLsizei stride)) ldg_find("glMultiDrawElementsIndirectAMD", lib);
	GL_CHECK(glp->MultiDrawElementsIndirectAMD);
	glp->MultiDrawElementsIndirectBindlessNV = (void APIENTRY (*)(GLenum mode, GLenum type, const void *indirect, GLsizei drawCount, GLsizei stride, GLint vertexBufferCount)) ldg_find("glMultiDrawElementsIndirectBindlessNV", lib);
	GL_CHECK(glp->MultiDrawElementsIndirectBindlessNV);
	glp->MultiDrawElementsIndirectCountARB = (void APIENTRY (*)(GLenum mode, GLenum type, const void *indirect, GLintptr drawcount, GLsizei maxdrawcount, GLsizei stride)) ldg_find("glMultiDrawElementsIndirectCountARB", lib);
	GL_CHECK(glp->MultiDrawElementsIndirectCountARB);
	glp->MultiTexBufferEXT = (void APIENTRY (*)(GLenum texunit, GLenum target, GLenum internalformat, GLuint buffer)) ldg_find("glMultiTexBufferEXT", lib);
	GL_CHECK(glp->MultiTexBufferEXT);
	glp->MultiTexCoord1bOES = (void APIENTRY (*)(GLenum texture, GLbyte32 s)) ldg_find("glMultiTexCoord1bOES", lib);
	GL_CHECK(glp->MultiTexCoord1bOES);
	glp->MultiTexCoord1bvOES = (void APIENTRY (*)(GLenum texture, const GLbyte *coords)) ldg_find("glMultiTexCoord1bvOES", lib);
	GL_CHECK(glp->MultiTexCoord1bvOES);
	glp->MultiTexCoord1xOES = (void APIENTRY (*)(GLenum texture, GLfixed s)) ldg_find("glMultiTexCoord1xOES", lib);
	GL_CHECK(glp->MultiTexCoord1xOES);
	glp->MultiTexCoord1xvOES = (void APIENTRY (*)(GLenum texture, const GLfixed *coords)) ldg_find("glMultiTexCoord1xvOES", lib);
	GL_CHECK(glp->MultiTexCoord1xvOES);
	glp->MultiTexCoord2bOES = (void APIENTRY (*)(GLenum texture, GLbyte32 s, GLbyte32 t)) ldg_find("glMultiTexCoord2bOES", lib);
	GL_CHECK(glp->MultiTexCoord2bOES);
	glp->MultiTexCoord2bvOES = (void APIENTRY (*)(GLenum texture, const GLbyte *coords)) ldg_find("glMultiTexCoord2bvOES", lib);
	GL_CHECK(glp->MultiTexCoord2bvOES);
	glp->MultiTexCoord2xOES = (void APIENTRY (*)(GLenum texture, GLfixed s, GLfixed t)) ldg_find("glMultiTexCoord2xOES", lib);
	GL_CHECK(glp->MultiTexCoord2xOES);
	glp->MultiTexCoord2xvOES = (void APIENTRY (*)(GLenum texture, const GLfixed *coords)) ldg_find("glMultiTexCoord2xvOES", lib);
	GL_CHECK(glp->MultiTexCoord2xvOES);
	glp->MultiTexCoord3bOES = (void APIENTRY (*)(GLenum texture, GLbyte32 s, GLbyte32 t, GLbyte32 r)) ldg_find("glMultiTexCoord3bOES", lib);
	GL_CHECK(glp->MultiTexCoord3bOES);
	glp->MultiTexCoord3bvOES = (void APIENTRY (*)(GLenum texture, const GLbyte *coords)) ldg_find("glMultiTexCoord3bvOES", lib);
	GL_CHECK(glp->MultiTexCoord3bvOES);
	glp->MultiTexCoord3xOES = (void APIENTRY (*)(GLenum texture, GLfixed s, GLfixed t, GLfixed r)) ldg_find("glMultiTexCoord3xOES", lib);
	GL_CHECK(glp->MultiTexCoord3xOES);
	glp->MultiTexCoord3xvOES = (void APIENTRY (*)(GLenum texture, const GLfixed *coords)) ldg_find("glMultiTexCoord3xvOES", lib);
	GL_CHECK(glp->MultiTexCoord3xvOES);
	glp->MultiTexCoord4bOES = (void APIENTRY (*)(GLenum texture, GLbyte32 s, GLbyte32 t, GLbyte32 r, GLbyte32 q)) ldg_find("glMultiTexCoord4bOES", lib);
	GL_CHECK(glp->MultiTexCoord4bOES);
	glp->MultiTexCoord4bvOES = (void APIENTRY (*)(GLenum texture, const GLbyte *coords)) ldg_find("glMultiTexCoord4bvOES", lib);
	GL_CHECK(glp->MultiTexCoord4bvOES);
	glp->MultiTexCoord4xOES = (void APIENTRY (*)(GLenum texture, GLfixed s, GLfixed t, GLfixed r, GLfixed q)) ldg_find("glMultiTexCoord4xOES", lib);
	GL_CHECK(glp->MultiTexCoord4xOES);
	glp->MultiTexCoord4xvOES = (void APIENTRY (*)(GLenum texture, const GLfixed *coords)) ldg_find("glMultiTexCoord4xvOES", lib);
	GL_CHECK(glp->MultiTexCoord4xvOES);
	glp->MultiTexCoordP1ui = (void APIENTRY (*)(GLenum texture, GLenum type, GLuint coords)) ldg_find("glMultiTexCoordP1ui", lib);
	GL_CHECK(glp->MultiTexCoordP1ui);
	glp->MultiTexCoordP1uiv = (void APIENTRY (*)(GLenum texture, GLenum type, const GLuint *coords)) ldg_find("glMultiTexCoordP1uiv", lib);
	GL_CHECK(glp->MultiTexCoordP1uiv);
	glp->MultiTexCoordP2ui = (void APIENTRY (*)(GLenum texture, GLenum type, GLuint coords)) ldg_find("glMultiTexCoordP2ui", lib);
	GL_CHECK(glp->MultiTexCoordP2ui);
	glp->MultiTexCoordP2uiv = (void APIENTRY (*)(GLenum texture, GLenum type, const GLuint *coords)) ldg_find("glMultiTexCoordP2uiv", lib);
	GL_CHECK(glp->MultiTexCoordP2uiv);
	glp->MultiTexCoordP3ui = (void APIENTRY (*)(GLenum texture, GLenum type, GLuint coords)) ldg_find("glMultiTexCoordP3ui", lib);
	GL_CHECK(glp->MultiTexCoordP3ui);
	glp->MultiTexCoordP3uiv = (void APIENTRY (*)(GLenum texture, GLenum type, const GLuint *coords)) ldg_find("glMultiTexCoordP3uiv", lib);
	GL_CHECK(glp->MultiTexCoordP3uiv);
	glp->MultiTexCoordP4ui = (void APIENTRY (*)(GLenum texture, GLenum type, GLuint coords)) ldg_find("glMultiTexCoordP4ui", lib);
	GL_CHECK(glp->MultiTexCoordP4ui);
	glp->MultiTexCoordP4uiv = (void APIENTRY (*)(GLenum texture, GLenum type, const GLuint *coords)) ldg_find("glMultiTexCoordP4uiv", lib);
	GL_CHECK(glp->MultiTexCoordP4uiv);
	glp->MultiTexCoordPointerEXT = (void APIENTRY (*)(GLenum texunit, GLint size, GLenum type, GLsizei stride, const void *pointer)) ldg_find("glMultiTexCoordPointerEXT", lib);
	GL_CHECK(glp->MultiTexCoordPointerEXT);
	glp->MultiTexEnvfEXT = (void APIENTRY (*)(GLenum texunit, GLenum target, GLenum pname, GLfloat param)) ldg_find("glMultiTexEnvfEXT", lib);
	GL_CHECK(glp->MultiTexEnvfEXT);
	glp->MultiTexEnvfvEXT = (void APIENTRY (*)(GLenum texunit, GLenum target, GLenum pname, const GLfloat *params)) ldg_find("glMultiTexEnvfvEXT", lib);
	GL_CHECK(glp->MultiTexEnvfvEXT);
	glp->MultiTexEnviEXT = (void APIENTRY (*)(GLenum texunit, GLenum target, GLenum pname, GLint param)) ldg_find("glMultiTexEnviEXT", lib);
	GL_CHECK(glp->MultiTexEnviEXT);
	glp->MultiTexEnvivEXT = (void APIENTRY (*)(GLenum texunit, GLenum target, GLenum pname, const GLint *params)) ldg_find("glMultiTexEnvivEXT", lib);
	GL_CHECK(glp->MultiTexEnvivEXT);
	glp->MultiTexGendEXT = (void APIENTRY (*)(GLenum texunit, GLenum coord, GLenum pname, GLdouble param)) ldg_find("glMultiTexGendEXT", lib);
	GL_CHECK(glp->MultiTexGendEXT);
	glp->MultiTexGendvEXT = (void APIENTRY (*)(GLenum texunit, GLenum coord, GLenum pname, const GLdouble *params)) ldg_find("glMultiTexGendvEXT", lib);
	GL_CHECK(glp->MultiTexGendvEXT);
	glp->MultiTexGenfEXT = (void APIENTRY (*)(GLenum texunit, GLenum coord, GLenum pname, GLfloat param)) ldg_find("glMultiTexGenfEXT", lib);
	GL_CHECK(glp->MultiTexGenfEXT);
	glp->MultiTexGenfvEXT = (void APIENTRY (*)(GLenum texunit, GLenum coord, GLenum pname, const GLfloat *params)) ldg_find("glMultiTexGenfvEXT", lib);
	GL_CHECK(glp->MultiTexGenfvEXT);
	glp->MultiTexGeniEXT = (void APIENTRY (*)(GLenum texunit, GLenum coord, GLenum pname, GLint param)) ldg_find("glMultiTexGeniEXT", lib);
	GL_CHECK(glp->MultiTexGeniEXT);
	glp->MultiTexGenivEXT = (void APIENTRY (*)(GLenum texunit, GLenum coord, GLenum pname, const GLint *params)) ldg_find("glMultiTexGenivEXT", lib);
	GL_CHECK(glp->MultiTexGenivEXT);
	glp->MultiTexImage1DEXT = (void APIENTRY (*)(GLenum texunit, GLenum target, GLint level, GLenum internalformat, GLsizei width, GLint border, GLenum format, GLenum type, const void *pixels)) ldg_find("glMultiTexImage1DEXT", lib);
	GL_CHECK(glp->MultiTexImage1DEXT);
	glp->MultiTexImage2DEXT = (void APIENTRY (*)(GLenum texunit, GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLint border, GLenum format, GLenum type, const void *pixels)) ldg_find("glMultiTexImage2DEXT", lib);
	GL_CHECK(glp->MultiTexImage2DEXT);
	glp->MultiTexImage3DEXT = (void APIENTRY (*)(GLenum texunit, GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLenum format, GLenum type, const void *pixels)) ldg_find("glMultiTexImage3DEXT", lib);
	GL_CHECK(glp->MultiTexImage3DEXT);
	glp->MultiTexParameterIivEXT = (void APIENTRY (*)(GLenum texunit, GLenum target, GLenum pname, const GLint *params)) ldg_find("glMultiTexParameterIivEXT", lib);
	GL_CHECK(glp->MultiTexParameterIivEXT);
	glp->MultiTexParameterIuivEXT = (void APIENTRY (*)(GLenum texunit, GLenum target, GLenum pname, const GLuint *params)) ldg_find("glMultiTexParameterIuivEXT", lib);
	GL_CHECK(glp->MultiTexParameterIuivEXT);
	glp->MultiTexParameterfEXT = (void APIENTRY (*)(GLenum texunit, GLenum target, GLenum pname, GLfloat param)) ldg_find("glMultiTexParameterfEXT", lib);
	GL_CHECK(glp->MultiTexParameterfEXT);
	glp->MultiTexParameterfvEXT = (void APIENTRY (*)(GLenum texunit, GLenum target, GLenum pname, const GLfloat *params)) ldg_find("glMultiTexParameterfvEXT", lib);
	GL_CHECK(glp->MultiTexParameterfvEXT);
	glp->MultiTexParameteriEXT = (void APIENTRY (*)(GLenum texunit, GLenum target, GLenum pname, GLint param)) ldg_find("glMultiTexParameteriEXT", lib);
	GL_CHECK(glp->MultiTexParameteriEXT);
	glp->MultiTexParameterivEXT = (void APIENTRY (*)(GLenum texunit, GLenum target, GLenum pname, const GLint *params)) ldg_find("glMultiTexParameterivEXT", lib);
	GL_CHECK(glp->MultiTexParameterivEXT);
	glp->MultiTexRenderbufferEXT = (void APIENTRY (*)(GLenum texunit, GLenum target, GLuint renderbuffer)) ldg_find("glMultiTexRenderbufferEXT", lib);
	GL_CHECK(glp->MultiTexRenderbufferEXT);
	glp->MultiTexSubImage1DEXT = (void APIENTRY (*)(GLenum texunit, GLenum target, GLint level, GLint xoffset, GLsizei width, GLenum format, GLenum type, const void *pixels)) ldg_find("glMultiTexSubImage1DEXT", lib);
	GL_CHECK(glp->MultiTexSubImage1DEXT);
	glp->MultiTexSubImage2DEXT = (void APIENTRY (*)(GLenum texunit, GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLenum type, const void *pixels)) ldg_find("glMultiTexSubImage2DEXT", lib);
	GL_CHECK(glp->MultiTexSubImage2DEXT);
	glp->MultiTexSubImage3DEXT = (void APIENTRY (*)(GLenum texunit, GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLenum type, const void *pixels)) ldg_find("glMultiTexSubImage3DEXT", lib);
	GL_CHECK(glp->MultiTexSubImage3DEXT);
	glp->NamedBufferDataEXT = (void APIENTRY (*)(GLuint buffer, GLsizeiptr size, const void *data, GLenum usage)) ldg_find("glNamedBufferDataEXT", lib);
	GL_CHECK(glp->NamedBufferDataEXT);
	glp->NamedBufferStorageEXT = (void APIENTRY (*)(GLuint buffer, GLsizeiptr size, const void *data, GLbitfield flags)) ldg_find("glNamedBufferStorageEXT", lib);
	GL_CHECK(glp->NamedBufferStorageEXT);
	glp->NamedBufferSubDataEXT = (void APIENTRY (*)(GLuint buffer, GLintptr offset, GLsizeiptr size, const void *data)) ldg_find("glNamedBufferSubDataEXT", lib);
	GL_CHECK(glp->NamedBufferSubDataEXT);
	glp->NamedCopyBufferSubDataEXT = (void APIENTRY (*)(GLuint readBuffer, GLuint writeBuffer, GLintptr readOffset, GLintptr writeOffset, GLsizeiptr size)) ldg_find("glNamedCopyBufferSubDataEXT", lib);
	GL_CHECK(glp->NamedCopyBufferSubDataEXT);
	glp->NamedFramebufferParameteriEXT = (void APIENTRY (*)(GLuint framebuffer, GLenum pname, GLint param)) ldg_find("glNamedFramebufferParameteriEXT", lib);
	GL_CHECK(glp->NamedFramebufferParameteriEXT);
	glp->NamedFramebufferRenderbufferEXT = (void APIENTRY (*)(GLuint framebuffer, GLenum attachment, GLenum renderbuffertarget, GLuint renderbuffer)) ldg_find("glNamedFramebufferRenderbufferEXT", lib);
	GL_CHECK(glp->NamedFramebufferRenderbufferEXT);
	glp->NamedFramebufferTexture1DEXT = (void APIENTRY (*)(GLuint framebuffer, GLenum attachment, GLenum textarget, GLuint texture, GLint level)) ldg_find("glNamedFramebufferTexture1DEXT", lib);
	GL_CHECK(glp->NamedFramebufferTexture1DEXT);
	glp->NamedFramebufferTexture2DEXT = (void APIENTRY (*)(GLuint framebuffer, GLenum attachment, GLenum textarget, GLuint texture, GLint level)) ldg_find("glNamedFramebufferTexture2DEXT", lib);
	GL_CHECK(glp->NamedFramebufferTexture2DEXT);
	glp->NamedFramebufferTexture3DEXT = (void APIENTRY (*)(GLuint framebuffer, GLenum attachment, GLenum textarget, GLuint texture, GLint level, GLint zoffset)) ldg_find("glNamedFramebufferTexture3DEXT", lib);
	GL_CHECK(glp->NamedFramebufferTexture3DEXT);
	glp->NamedFramebufferTextureEXT = (void APIENTRY (*)(GLuint framebuffer, GLenum attachment, GLuint texture, GLint level)) ldg_find("glNamedFramebufferTextureEXT", lib);
	GL_CHECK(glp->NamedFramebufferTextureEXT);
	glp->NamedFramebufferTextureFaceEXT = (void APIENTRY (*)(GLuint framebuffer, GLenum attachment, GLuint texture, GLint level, GLenum face)) ldg_find("glNamedFramebufferTextureFaceEXT", lib);
	GL_CHECK(glp->NamedFramebufferTextureFaceEXT);
	glp->NamedFramebufferTextureLayerEXT = (void APIENTRY (*)(GLuint framebuffer, GLenum attachment, GLuint texture, GLint level, GLint layer)) ldg_find("glNamedFramebufferTextureLayerEXT", lib);
	GL_CHECK(glp->NamedFramebufferTextureLayerEXT);
	glp->NamedProgramLocalParameter4dEXT = (void APIENTRY (*)(GLuint program, GLenum target, GLuint index, GLdouble x, GLdouble y, GLdouble z, GLdouble w)) ldg_find("glNamedProgramLocalParameter4dEXT", lib);
	GL_CHECK(glp->NamedProgramLocalParameter4dEXT);
	glp->NamedProgramLocalParameter4dvEXT = (void APIENTRY (*)(GLuint program, GLenum target, GLuint index, const GLdouble *params)) ldg_find("glNamedProgramLocalParameter4dvEXT", lib);
	GL_CHECK(glp->NamedProgramLocalParameter4dvEXT);
	glp->NamedProgramLocalParameter4fEXT = (void APIENTRY (*)(GLuint program, GLenum target, GLuint index, GLfloat x, GLfloat y, GLfloat z, GLfloat w)) ldg_find("glNamedProgramLocalParameter4fEXT", lib);
	GL_CHECK(glp->NamedProgramLocalParameter4fEXT);
	glp->NamedProgramLocalParameter4fvEXT = (void APIENTRY (*)(GLuint program, GLenum target, GLuint index, const GLfloat *params)) ldg_find("glNamedProgramLocalParameter4fvEXT", lib);
	GL_CHECK(glp->NamedProgramLocalParameter4fvEXT);
	glp->NamedProgramLocalParameterI4iEXT = (void APIENTRY (*)(GLuint program, GLenum target, GLuint index, GLint x, GLint y, GLint z, GLint w)) ldg_find("glNamedProgramLocalParameterI4iEXT", lib);
	GL_CHECK(glp->NamedProgramLocalParameterI4iEXT);
	glp->NamedProgramLocalParameterI4ivEXT = (void APIENTRY (*)(GLuint program, GLenum target, GLuint index, const GLint *params)) ldg_find("glNamedProgramLocalParameterI4ivEXT", lib);
	GL_CHECK(glp->NamedProgramLocalParameterI4ivEXT);
	glp->NamedProgramLocalParameterI4uiEXT = (void APIENTRY (*)(GLuint program, GLenum target, GLuint index, GLuint x, GLuint y, GLuint z, GLuint w)) ldg_find("glNamedProgramLocalParameterI4uiEXT", lib);
	GL_CHECK(glp->NamedProgramLocalParameterI4uiEXT);
	glp->NamedProgramLocalParameterI4uivEXT = (void APIENTRY (*)(GLuint program, GLenum target, GLuint index, const GLuint *params)) ldg_find("glNamedProgramLocalParameterI4uivEXT", lib);
	GL_CHECK(glp->NamedProgramLocalParameterI4uivEXT);
	glp->NamedProgramLocalParameters4fvEXT = (void APIENTRY (*)(GLuint program, GLenum target, GLuint index, GLsizei count, const GLfloat *params)) ldg_find("glNamedProgramLocalParameters4fvEXT", lib);
	GL_CHECK(glp->NamedProgramLocalParameters4fvEXT);
	glp->NamedProgramLocalParametersI4ivEXT = (void APIENTRY (*)(GLuint program, GLenum target, GLuint index, GLsizei count, const GLint *params)) ldg_find("glNamedProgramLocalParametersI4ivEXT", lib);
	GL_CHECK(glp->NamedProgramLocalParametersI4ivEXT);
	glp->NamedProgramLocalParametersI4uivEXT = (void APIENTRY (*)(GLuint program, GLenum target, GLuint index, GLsizei count, const GLuint *params)) ldg_find("glNamedProgramLocalParametersI4uivEXT", lib);
	GL_CHECK(glp->NamedProgramLocalParametersI4uivEXT);
	glp->NamedProgramStringEXT = (void APIENTRY (*)(GLuint program, GLenum target, GLenum format, GLsizei len, const void *string)) ldg_find("glNamedProgramStringEXT", lib);
	GL_CHECK(glp->NamedProgramStringEXT);
	glp->NamedRenderbufferStorageEXT = (void APIENTRY (*)(GLuint renderbuffer, GLenum internalformat, GLsizei width, GLsizei height)) ldg_find("glNamedRenderbufferStorageEXT", lib);
	GL_CHECK(glp->NamedRenderbufferStorageEXT);
	glp->NamedRenderbufferStorageMultisampleCoverageEXT = (void APIENTRY (*)(GLuint renderbuffer, GLsizei coverageSamples, GLsizei colorSamples, GLenum internalformat, GLsizei width, GLsizei height)) ldg_find("glNamedRenderbufferStorageMultisampleCoverageEXT", lib);
	GL_CHECK(glp->NamedRenderbufferStorageMultisampleCoverageEXT);
	glp->NamedRenderbufferStorageMultisampleEXT = (void APIENTRY (*)(GLuint renderbuffer, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height)) ldg_find("glNamedRenderbufferStorageMultisampleEXT", lib);
	GL_CHECK(glp->NamedRenderbufferStorageMultisampleEXT);
	glp->NamedStringARB = (void APIENTRY (*)(GLenum type, GLint namelen, const GLchar *name, GLint stringlen, const GLchar *string)) ldg_find("glNamedStringARB", lib);
	GL_CHECK(glp->NamedStringARB);
	glp->Normal3xOES = (void APIENTRY (*)(GLfixed nx, GLfixed ny, GLfixed nz)) ldg_find("glNormal3xOES", lib);
	GL_CHECK(glp->Normal3xOES);
	glp->Normal3xvOES = (void APIENTRY (*)(const GLfixed *coords)) ldg_find("glNormal3xvOES", lib);
	GL_CHECK(glp->Normal3xvOES);
	glp->NormalFormatNV = (void APIENTRY (*)(GLenum type, GLsizei stride)) ldg_find("glNormalFormatNV", lib);
	GL_CHECK(glp->NormalFormatNV);
	glp->NormalP3ui = (void APIENTRY (*)(GLenum type, GLuint coords)) ldg_find("glNormalP3ui", lib);
	GL_CHECK(glp->NormalP3ui);
	glp->NormalP3uiv = (void APIENTRY (*)(GLenum type, const GLuint *coords)) ldg_find("glNormalP3uiv", lib);
	GL_CHECK(glp->NormalP3uiv);
	glp->ObjectLabel = (void APIENTRY (*)(GLenum identifier, GLuint name, GLsizei length, const GLchar *label)) ldg_find("glObjectLabel", lib);
	GL_CHECK(glp->ObjectLabel);
	glp->ObjectPtrLabel = (void APIENTRY (*)(const void *ptr, GLsizei length, const GLchar *label)) ldg_find("glObjectPtrLabel", lib);
	GL_CHECK(glp->ObjectPtrLabel);
	glp->ObjectPurgeableAPPLE = (GLenum APIENTRY (*)(GLenum objectType, GLuint name, GLenum option)) ldg_find("glObjectPurgeableAPPLE", lib);
	GL_CHECK(glp->ObjectPurgeableAPPLE);
	glp->ObjectUnpurgeableAPPLE = (GLenum APIENTRY (*)(GLenum objectType, GLuint name, GLenum option)) ldg_find("glObjectUnpurgeableAPPLE", lib);
	GL_CHECK(glp->ObjectUnpurgeableAPPLE);
	glp->OrthofOES = (void APIENTRY (*)(GLfloat l, GLfloat r, GLfloat b, GLfloat t, GLfloat n, GLfloat f)) ldg_find("glOrthofOES", lib);
	GL_CHECK(glp->OrthofOES);
	glp->OrthoxOES = (void APIENTRY (*)(GLfixed l, GLfixed r, GLfixed b, GLfixed t, GLfixed n, GLfixed f)) ldg_find("glOrthoxOES", lib);
	GL_CHECK(glp->OrthoxOES);
	glp->PassThroughxOES = (void APIENTRY (*)(GLfixed token)) ldg_find("glPassThroughxOES", lib);
	GL_CHECK(glp->PassThroughxOES);
	glp->PatchParameterfv = (void APIENTRY (*)(GLenum pname, const GLfloat *values)) ldg_find("glPatchParameterfv", lib);
	GL_CHECK(glp->PatchParameterfv);
	glp->PatchParameteri = (void APIENTRY (*)(GLenum pname, GLint value)) ldg_find("glPatchParameteri", lib);
	GL_CHECK(glp->PatchParameteri);
	glp->PathColorGenNV = (void APIENTRY (*)(GLenum color, GLenum genMode, GLenum colorFormat, const GLfloat *coeffs)) ldg_find("glPathColorGenNV", lib);
	GL_CHECK(glp->PathColorGenNV);
	glp->PathCommandsNV = (void APIENTRY (*)(GLuint path, GLsizei numCommands, const GLubyte *commands, GLsizei numCoords, GLenum coordType, const void *coords)) ldg_find("glPathCommandsNV", lib);
	GL_CHECK(glp->PathCommandsNV);
	glp->PathCoordsNV = (void APIENTRY (*)(GLuint path, GLsizei numCoords, GLenum coordType, const void *coords)) ldg_find("glPathCoordsNV", lib);
	GL_CHECK(glp->PathCoordsNV);
	glp->PathCoverDepthFuncNV = (void APIENTRY (*)(GLenum func)) ldg_find("glPathCoverDepthFuncNV", lib);
	GL_CHECK(glp->PathCoverDepthFuncNV);
	glp->PathDashArrayNV = (void APIENTRY (*)(GLuint path, GLsizei dashCount, const GLfloat *dashArray)) ldg_find("glPathDashArrayNV", lib);
	GL_CHECK(glp->PathDashArrayNV);
	glp->PathFogGenNV = (void APIENTRY (*)(GLenum genMode)) ldg_find("glPathFogGenNV", lib);
	GL_CHECK(glp->PathFogGenNV);
	glp->PathGlyphRangeNV = (void APIENTRY (*)(GLuint firstPathName, GLenum fontTarget, const void *fontName, GLbitfield fontStyle, GLuint firstGlyph, GLsizei numGlyphs, GLenum handleMissingGlyphs, GLuint pathParameterTemplate, GLfloat emScale)) ldg_find("glPathGlyphRangeNV", lib);
	GL_CHECK(glp->PathGlyphRangeNV);
	glp->PathGlyphsNV = (void APIENTRY (*)(GLuint firstPathName, GLenum fontTarget, const void *fontName, GLbitfield fontStyle, GLsizei numGlyphs, GLenum type, const void *charcodes, GLenum handleMissingGlyphs, GLuint pathParameterTemplate, GLfloat emScale)) ldg_find("glPathGlyphsNV", lib);
	GL_CHECK(glp->PathGlyphsNV);
	glp->PathParameterfNV = (void APIENTRY (*)(GLuint path, GLenum pname, GLfloat value)) ldg_find("glPathParameterfNV", lib);
	GL_CHECK(glp->PathParameterfNV);
	glp->PathParameterfvNV = (void APIENTRY (*)(GLuint path, GLenum pname, const GLfloat *value)) ldg_find("glPathParameterfvNV", lib);
	GL_CHECK(glp->PathParameterfvNV);
	glp->PathParameteriNV = (void APIENTRY (*)(GLuint path, GLenum pname, GLint value)) ldg_find("glPathParameteriNV", lib);
	GL_CHECK(glp->PathParameteriNV);
	glp->PathParameterivNV = (void APIENTRY (*)(GLuint path, GLenum pname, const GLint *value)) ldg_find("glPathParameterivNV", lib);
	GL_CHECK(glp->PathParameterivNV);
	glp->PathStencilDepthOffsetNV = (void APIENTRY (*)(GLfloat factor, GLfloat units)) ldg_find("glPathStencilDepthOffsetNV", lib);
	GL_CHECK(glp->PathStencilDepthOffsetNV);
	glp->PathStencilFuncNV = (void APIENTRY (*)(GLenum func, GLint ref, GLuint mask)) ldg_find("glPathStencilFuncNV", lib);
	GL_CHECK(glp->PathStencilFuncNV);
	glp->PathStringNV = (void APIENTRY (*)(GLuint path, GLenum format, GLsizei length, const void *pathString)) ldg_find("glPathStringNV", lib);
	GL_CHECK(glp->PathStringNV);
	glp->PathSubCommandsNV = (void APIENTRY (*)(GLuint path, GLsizei commandStart, GLsizei commandsToDelete, GLsizei numCommands, const GLubyte *commands, GLsizei numCoords, GLenum coordType, const void *coords)) ldg_find("glPathSubCommandsNV", lib);
	GL_CHECK(glp->PathSubCommandsNV);
	glp->PathSubCoordsNV = (void APIENTRY (*)(GLuint path, GLsizei coordStart, GLsizei numCoords, GLenum coordType, const void *coords)) ldg_find("glPathSubCoordsNV", lib);
	GL_CHECK(glp->PathSubCoordsNV);
	glp->PathTexGenNV = (void APIENTRY (*)(GLenum texCoordSet, GLenum genMode, GLint components, const GLfloat *coeffs)) ldg_find("glPathTexGenNV", lib);
	GL_CHECK(glp->PathTexGenNV);
	glp->PauseTransformFeedback = (void APIENTRY (*)(void)) ldg_find("glPauseTransformFeedback", lib);
	GL_CHECK(glp->PauseTransformFeedback);
	glp->PauseTransformFeedbackNV = (void APIENTRY (*)(void)) ldg_find("glPauseTransformFeedbackNV", lib);
	GL_CHECK(glp->PauseTransformFeedbackNV);
	glp->PixelMapx = (void APIENTRY (*)(GLenum map, GLint size, const GLfixed *values)) ldg_find("glPixelMapx", lib);
	GL_CHECK(glp->PixelMapx);
	glp->PixelStorex = (void APIENTRY (*)(GLenum pname, GLfixed param)) ldg_find("glPixelStorex", lib);
	GL_CHECK(glp->PixelStorex);
	glp->PixelTransferxOES = (void APIENTRY (*)(GLenum pname, GLfixed param)) ldg_find("glPixelTransferxOES", lib);
	GL_CHECK(glp->PixelTransferxOES);
	glp->PixelZoomxOES = (void APIENTRY (*)(GLfixed xfactor, GLfixed yfactor)) ldg_find("glPixelZoomxOES", lib);
	GL_CHECK(glp->PixelZoomxOES);
	glp->PointAlongPathNV = (GLboolean APIENTRY (*)(GLuint path, GLsizei startSegment, GLsizei numSegments, GLfloat distance, GLfloat *x, GLfloat *y, GLfloat *tangentX, GLfloat *tangentY)) ldg_find("glPointAlongPathNV", lib);
	GL_CHECK(glp->PointAlongPathNV);
	glp->PointParameterxvOES = (void APIENTRY (*)(GLenum pname, const GLfixed *params)) ldg_find("glPointParameterxvOES", lib);
	GL_CHECK(glp->PointParameterxvOES);
	glp->PointSizePointerAPPLE = (void APIENTRY (*)(GLenum type, GLsizei stride, const GLvoid *pointer)) ldg_find("glPointSizePointerAPPLE", lib);
	GL_CHECK(glp->PointSizePointerAPPLE);
	glp->PointSizexOES = (void APIENTRY (*)(GLfixed size)) ldg_find("glPointSizexOES", lib);
	GL_CHECK(glp->PointSizexOES);
	glp->PolygonOffsetxOES = (void APIENTRY (*)(GLfixed factor, GLfixed units)) ldg_find("glPolygonOffsetxOES", lib);
	GL_CHECK(glp->PolygonOffsetxOES);
	glp->PopDebugGroup = (void APIENTRY (*)(void)) ldg_find("glPopDebugGroup", lib);
	GL_CHECK(glp->PopDebugGroup);
	glp->PopGroupMarkerEXT = (void APIENTRY (*)(void)) ldg_find("glPopGroupMarkerEXT", lib);
	GL_CHECK(glp->PopGroupMarkerEXT);
	glp->PresentFrameDualFillNV = (void APIENTRY (*)(GLuint video_slot, GLuint64EXT minPresentTime, GLuint beginPresentTimeId, GLuint presentDurationId, GLenum type, GLenum target0, GLuint fill0, GLenum target1, GLuint fill1, GLenum target2, GLuint fill2, GLenum target3, GLuint fill3)) ldg_find("glPresentFrameDualFillNV", lib);
	GL_CHECK(glp->PresentFrameDualFillNV);
	glp->PresentFrameKeyedNV = (void APIENTRY (*)(GLuint video_slot, GLuint64EXT minPresentTime, GLuint beginPresentTimeId, GLuint presentDurationId, GLenum type, GLenum target0, GLuint fill0, GLuint key0, GLenum target1, GLuint fill1, GLuint key1)) ldg_find("glPresentFrameKeyedNV", lib);
	GL_CHECK(glp->PresentFrameKeyedNV);
	glp->PrimitiveRestartIndex = (void APIENTRY (*)(GLuint index)) ldg_find("glPrimitiveRestartIndex", lib);
	GL_CHECK(glp->PrimitiveRestartIndex);
	glp->PrioritizeTexturesxOES = (void APIENTRY (*)(GLsizei n, const GLuint *textures, const GLfixed *priorities)) ldg_find("glPrioritizeTexturesxOES", lib);
	GL_CHECK(glp->PrioritizeTexturesxOES);
	glp->ProgramBinary = (void APIENTRY (*)(GLuint program, GLenum binaryFormat, const void *binary, GLsizei length)) ldg_find("glProgramBinary", lib);
	GL_CHECK(glp->ProgramBinary);
	glp->ProgramBufferParametersIivNV = (void APIENTRY (*)(GLenum target, GLuint bindingIndex, GLuint wordIndex, GLsizei count, const GLint *params)) ldg_find("glProgramBufferParametersIivNV", lib);
	GL_CHECK(glp->ProgramBufferParametersIivNV);
	glp->ProgramBufferParametersIuivNV = (void APIENTRY (*)(GLenum target, GLuint bindingIndex, GLuint wordIndex, GLsizei count, const GLuint *params)) ldg_find("glProgramBufferParametersIuivNV", lib);
	GL_CHECK(glp->ProgramBufferParametersIuivNV);
	glp->ProgramBufferParametersfvNV = (void APIENTRY (*)(GLenum target, GLuint bindingIndex, GLuint wordIndex, GLsizei count, const GLfloat *params)) ldg_find("glProgramBufferParametersfvNV", lib);
	GL_CHECK(glp->ProgramBufferParametersfvNV);
	glp->ProgramCallbackMESA = (void APIENTRY (*)(GLenum target, GLprogramcallbackMESA callback, GLvoid *data)) ldg_find("glProgramCallbackMESA", lib);
	GL_CHECK(glp->ProgramCallbackMESA);
	glp->ProgramEnvParameterI4iNV = (void APIENTRY (*)(GLenum target, GLuint index, GLint x, GLint y, GLint z, GLint w)) ldg_find("glProgramEnvParameterI4iNV", lib);
	GL_CHECK(glp->ProgramEnvParameterI4iNV);
	glp->ProgramEnvParameterI4ivNV = (void APIENTRY (*)(GLenum target, GLuint index, const GLint *params)) ldg_find("glProgramEnvParameterI4ivNV", lib);
	GL_CHECK(glp->ProgramEnvParameterI4ivNV);
	glp->ProgramEnvParameterI4uiNV = (void APIENTRY (*)(GLenum target, GLuint index, GLuint x, GLuint y, GLuint z, GLuint w)) ldg_find("glProgramEnvParameterI4uiNV", lib);
	GL_CHECK(glp->ProgramEnvParameterI4uiNV);
	glp->ProgramEnvParameterI4uivNV = (void APIENTRY (*)(GLenum target, GLuint index, const GLuint *params)) ldg_find("glProgramEnvParameterI4uivNV", lib);
	GL_CHECK(glp->ProgramEnvParameterI4uivNV);
	glp->ProgramEnvParameters4fvEXT = (void APIENTRY (*)(GLenum target, GLuint index, GLsizei count, const GLfloat *params)) ldg_find("glProgramEnvParameters4fvEXT", lib);
	GL_CHECK(glp->ProgramEnvParameters4fvEXT);
	glp->ProgramEnvParametersI4ivNV = (void APIENTRY (*)(GLenum target, GLuint index, GLsizei count, const GLint *params)) ldg_find("glProgramEnvParametersI4ivNV", lib);
	GL_CHECK(glp->ProgramEnvParametersI4ivNV);
	glp->ProgramEnvParametersI4uivNV = (void APIENTRY (*)(GLenum target, GLuint index, GLsizei count, const GLuint *params)) ldg_find("glProgramEnvParametersI4uivNV", lib);
	GL_CHECK(glp->ProgramEnvParametersI4uivNV);
	glp->ProgramLocalParameterI4iNV = (void APIENTRY (*)(GLenum target, GLuint index, GLint x, GLint y, GLint z, GLint w)) ldg_find("glProgramLocalParameterI4iNV", lib);
	GL_CHECK(glp->ProgramLocalParameterI4iNV);
	glp->ProgramLocalParameterI4ivNV = (void APIENTRY (*)(GLenum target, GLuint index, const GLint *params)) ldg_find("glProgramLocalParameterI4ivNV", lib);
	GL_CHECK(glp->ProgramLocalParameterI4ivNV);
	glp->ProgramLocalParameterI4uiNV = (void APIENTRY (*)(GLenum target, GLuint index, GLuint x, GLuint y, GLuint z, GLuint w)) ldg_find("glProgramLocalParameterI4uiNV", lib);
	GL_CHECK(glp->ProgramLocalParameterI4uiNV);
	glp->ProgramLocalParameterI4uivNV = (void APIENTRY (*)(GLenum target, GLuint index, const GLuint *params)) ldg_find("glProgramLocalParameterI4uivNV", lib);
	GL_CHECK(glp->ProgramLocalParameterI4uivNV);
	glp->ProgramLocalParameters4fvEXT = (void APIENTRY (*)(GLenum target, GLuint index, GLsizei count, const GLfloat *params)) ldg_find("glProgramLocalParameters4fvEXT", lib);
	GL_CHECK(glp->ProgramLocalParameters4fvEXT);
	glp->ProgramLocalParametersI4ivNV = (void APIENTRY (*)(GLenum target, GLuint index, GLsizei count, const GLint *params)) ldg_find("glProgramLocalParametersI4ivNV", lib);
	GL_CHECK(glp->ProgramLocalParametersI4ivNV);
	glp->ProgramLocalParametersI4uivNV = (void APIENTRY (*)(GLenum target, GLuint index, GLsizei count, const GLuint *params)) ldg_find("glProgramLocalParametersI4uivNV", lib);
	GL_CHECK(glp->ProgramLocalParametersI4uivNV);
	glp->ProgramParameteri = (void APIENTRY (*)(GLuint program, GLenum pname, GLint value)) ldg_find("glProgramParameteri", lib);
	GL_CHECK(glp->ProgramParameteri);
	glp->ProgramParameteriARB = (void APIENTRY (*)(GLuint program, GLenum pname, GLint value)) ldg_find("glProgramParameteriARB", lib);
	GL_CHECK(glp->ProgramParameteriARB);
	glp->ProgramParameteriEXT = (void APIENTRY (*)(GLuint program, GLenum pname, GLint value)) ldg_find("glProgramParameteriEXT", lib);
	GL_CHECK(glp->ProgramParameteriEXT);
	glp->ProgramSubroutineParametersuivNV = (void APIENTRY (*)(GLenum target, GLsizei count, const GLuint *params)) ldg_find("glProgramSubroutineParametersuivNV", lib);
	GL_CHECK(glp->ProgramSubroutineParametersuivNV);
	glp->ProgramUniform1d = (void APIENTRY (*)(GLuint program, GLint location, GLdouble v0)) ldg_find("glProgramUniform1d", lib);
	GL_CHECK(glp->ProgramUniform1d);
	glp->ProgramUniform1dEXT = (void APIENTRY (*)(GLuint program, GLint location, GLdouble x)) ldg_find("glProgramUniform1dEXT", lib);
	GL_CHECK(glp->ProgramUniform1dEXT);
	glp->ProgramUniform1dv = (void APIENTRY (*)(GLuint program, GLint location, GLsizei count, const GLdouble *value)) ldg_find("glProgramUniform1dv", lib);
	GL_CHECK(glp->ProgramUniform1dv);
	glp->ProgramUniform1dvEXT = (void APIENTRY (*)(GLuint program, GLint location, GLsizei count, const GLdouble *value)) ldg_find("glProgramUniform1dvEXT", lib);
	GL_CHECK(glp->ProgramUniform1dvEXT);
	glp->ProgramUniform1f = (void APIENTRY (*)(GLuint program, GLint location, GLfloat v0)) ldg_find("glProgramUniform1f", lib);
	GL_CHECK(glp->ProgramUniform1f);
	glp->ProgramUniform1fEXT = (void APIENTRY (*)(GLuint program, GLint location, GLfloat v0)) ldg_find("glProgramUniform1fEXT", lib);
	GL_CHECK(glp->ProgramUniform1fEXT);
	glp->ProgramUniform1fv = (void APIENTRY (*)(GLuint program, GLint location, GLsizei count, const GLfloat *value)) ldg_find("glProgramUniform1fv", lib);
	GL_CHECK(glp->ProgramUniform1fv);
	glp->ProgramUniform1fvEXT = (void APIENTRY (*)(GLuint program, GLint location, GLsizei count, const GLfloat *value)) ldg_find("glProgramUniform1fvEXT", lib);
	GL_CHECK(glp->ProgramUniform1fvEXT);
	glp->ProgramUniform1i = (void APIENTRY (*)(GLuint program, GLint location, GLint v0)) ldg_find("glProgramUniform1i", lib);
	GL_CHECK(glp->ProgramUniform1i);
	glp->ProgramUniform1i64NV = (void APIENTRY (*)(GLuint program, GLint location, GLint64EXT x)) ldg_find("glProgramUniform1i64NV", lib);
	GL_CHECK(glp->ProgramUniform1i64NV);
	glp->ProgramUniform1i64vNV = (void APIENTRY (*)(GLuint program, GLint location, GLsizei count, const GLint64EXT *value)) ldg_find("glProgramUniform1i64vNV", lib);
	GL_CHECK(glp->ProgramUniform1i64vNV);
	glp->ProgramUniform1iEXT = (void APIENTRY (*)(GLuint program, GLint location, GLint v0)) ldg_find("glProgramUniform1iEXT", lib);
	GL_CHECK(glp->ProgramUniform1iEXT);
	glp->ProgramUniform1iv = (void APIENTRY (*)(GLuint program, GLint location, GLsizei count, const GLint *value)) ldg_find("glProgramUniform1iv", lib);
	GL_CHECK(glp->ProgramUniform1iv);
	glp->ProgramUniform1ivEXT = (void APIENTRY (*)(GLuint program, GLint location, GLsizei count, const GLint *value)) ldg_find("glProgramUniform1ivEXT", lib);
	GL_CHECK(glp->ProgramUniform1ivEXT);
	glp->ProgramUniform1ui = (void APIENTRY (*)(GLuint program, GLint location, GLuint v0)) ldg_find("glProgramUniform1ui", lib);
	GL_CHECK(glp->ProgramUniform1ui);
	glp->ProgramUniform1ui64NV = (void APIENTRY (*)(GLuint program, GLint location, GLuint64EXT x)) ldg_find("glProgramUniform1ui64NV", lib);
	GL_CHECK(glp->ProgramUniform1ui64NV);
	glp->ProgramUniform1ui64vNV = (void APIENTRY (*)(GLuint program, GLint location, GLsizei count, const GLuint64EXT *value)) ldg_find("glProgramUniform1ui64vNV", lib);
	GL_CHECK(glp->ProgramUniform1ui64vNV);
	glp->ProgramUniform1uiEXT = (void APIENTRY (*)(GLuint program, GLint location, GLuint v0)) ldg_find("glProgramUniform1uiEXT", lib);
	GL_CHECK(glp->ProgramUniform1uiEXT);
	glp->ProgramUniform1uiv = (void APIENTRY (*)(GLuint program, GLint location, GLsizei count, const GLuint *value)) ldg_find("glProgramUniform1uiv", lib);
	GL_CHECK(glp->ProgramUniform1uiv);
	glp->ProgramUniform1uivEXT = (void APIENTRY (*)(GLuint program, GLint location, GLsizei count, const GLuint *value)) ldg_find("glProgramUniform1uivEXT", lib);
	GL_CHECK(glp->ProgramUniform1uivEXT);
	glp->ProgramUniform2d = (void APIENTRY (*)(GLuint program, GLint location, GLdouble v0, GLdouble v1)) ldg_find("glProgramUniform2d", lib);
	GL_CHECK(glp->ProgramUniform2d);
	glp->ProgramUniform2dEXT = (void APIENTRY (*)(GLuint program, GLint location, GLdouble x, GLdouble y)) ldg_find("glProgramUniform2dEXT", lib);
	GL_CHECK(glp->ProgramUniform2dEXT);
	glp->ProgramUniform2dv = (void APIENTRY (*)(GLuint program, GLint location, GLsizei count, const GLdouble *value)) ldg_find("glProgramUniform2dv", lib);
	GL_CHECK(glp->ProgramUniform2dv);
	glp->ProgramUniform2dvEXT = (void APIENTRY (*)(GLuint program, GLint location, GLsizei count, const GLdouble *value)) ldg_find("glProgramUniform2dvEXT", lib);
	GL_CHECK(glp->ProgramUniform2dvEXT);
	glp->ProgramUniform2f = (void APIENTRY (*)(GLuint program, GLint location, GLfloat v0, GLfloat v1)) ldg_find("glProgramUniform2f", lib);
	GL_CHECK(glp->ProgramUniform2f);
	glp->ProgramUniform2fEXT = (void APIENTRY (*)(GLuint program, GLint location, GLfloat v0, GLfloat v1)) ldg_find("glProgramUniform2fEXT", lib);
	GL_CHECK(glp->ProgramUniform2fEXT);
	glp->ProgramUniform2fv = (void APIENTRY (*)(GLuint program, GLint location, GLsizei count, const GLfloat *value)) ldg_find("glProgramUniform2fv", lib);
	GL_CHECK(glp->ProgramUniform2fv);
	glp->ProgramUniform2fvEXT = (void APIENTRY (*)(GLuint program, GLint location, GLsizei count, const GLfloat *value)) ldg_find("glProgramUniform2fvEXT", lib);
	GL_CHECK(glp->ProgramUniform2fvEXT);
	glp->ProgramUniform2i = (void APIENTRY (*)(GLuint program, GLint location, GLint v0, GLint v1)) ldg_find("glProgramUniform2i", lib);
	GL_CHECK(glp->ProgramUniform2i);
	glp->ProgramUniform2i64NV = (void APIENTRY (*)(GLuint program, GLint location, GLint64EXT x, GLint64EXT y)) ldg_find("glProgramUniform2i64NV", lib);
	GL_CHECK(glp->ProgramUniform2i64NV);
	glp->ProgramUniform2i64vNV = (void APIENTRY (*)(GLuint program, GLint location, GLsizei count, const GLint64EXT *value)) ldg_find("glProgramUniform2i64vNV", lib);
	GL_CHECK(glp->ProgramUniform2i64vNV);
	glp->ProgramUniform2iEXT = (void APIENTRY (*)(GLuint program, GLint location, GLint v0, GLint v1)) ldg_find("glProgramUniform2iEXT", lib);
	GL_CHECK(glp->ProgramUniform2iEXT);
	glp->ProgramUniform2iv = (void APIENTRY (*)(GLuint program, GLint location, GLsizei count, const GLint *value)) ldg_find("glProgramUniform2iv", lib);
	GL_CHECK(glp->ProgramUniform2iv);
	glp->ProgramUniform2ivEXT = (void APIENTRY (*)(GLuint program, GLint location, GLsizei count, const GLint *value)) ldg_find("glProgramUniform2ivEXT", lib);
	GL_CHECK(glp->ProgramUniform2ivEXT);
	glp->ProgramUniform2ui = (void APIENTRY (*)(GLuint program, GLint location, GLuint v0, GLuint v1)) ldg_find("glProgramUniform2ui", lib);
	GL_CHECK(glp->ProgramUniform2ui);
	glp->ProgramUniform2ui64NV = (void APIENTRY (*)(GLuint program, GLint location, GLuint64EXT x, GLuint64EXT y)) ldg_find("glProgramUniform2ui64NV", lib);
	GL_CHECK(glp->ProgramUniform2ui64NV);
	glp->ProgramUniform2ui64vNV = (void APIENTRY (*)(GLuint program, GLint location, GLsizei count, const GLuint64EXT *value)) ldg_find("glProgramUniform2ui64vNV", lib);
	GL_CHECK(glp->ProgramUniform2ui64vNV);
	glp->ProgramUniform2uiEXT = (void APIENTRY (*)(GLuint program, GLint location, GLuint v0, GLuint v1)) ldg_find("glProgramUniform2uiEXT", lib);
	GL_CHECK(glp->ProgramUniform2uiEXT);
	glp->ProgramUniform2uiv = (void APIENTRY (*)(GLuint program, GLint location, GLsizei count, const GLuint *value)) ldg_find("glProgramUniform2uiv", lib);
	GL_CHECK(glp->ProgramUniform2uiv);
	glp->ProgramUniform2uivEXT = (void APIENTRY (*)(GLuint program, GLint location, GLsizei count, const GLuint *value)) ldg_find("glProgramUniform2uivEXT", lib);
	GL_CHECK(glp->ProgramUniform2uivEXT);
	glp->ProgramUniform3d = (void APIENTRY (*)(GLuint program, GLint location, GLdouble v0, GLdouble v1, GLdouble v2)) ldg_find("glProgramUniform3d", lib);
	GL_CHECK(glp->ProgramUniform3d);
	glp->ProgramUniform3dEXT = (void APIENTRY (*)(GLuint program, GLint location, GLdouble x, GLdouble y, GLdouble z)) ldg_find("glProgramUniform3dEXT", lib);
	GL_CHECK(glp->ProgramUniform3dEXT);
	glp->ProgramUniform3dv = (void APIENTRY (*)(GLuint program, GLint location, GLsizei count, const GLdouble *value)) ldg_find("glProgramUniform3dv", lib);
	GL_CHECK(glp->ProgramUniform3dv);
	glp->ProgramUniform3dvEXT = (void APIENTRY (*)(GLuint program, GLint location, GLsizei count, const GLdouble *value)) ldg_find("glProgramUniform3dvEXT", lib);
	GL_CHECK(glp->ProgramUniform3dvEXT);
	glp->ProgramUniform3f = (void APIENTRY (*)(GLuint program, GLint location, GLfloat v0, GLfloat v1, GLfloat v2)) ldg_find("glProgramUniform3f", lib);
	GL_CHECK(glp->ProgramUniform3f);
	glp->ProgramUniform3fEXT = (void APIENTRY (*)(GLuint program, GLint location, GLfloat v0, GLfloat v1, GLfloat v2)) ldg_find("glProgramUniform3fEXT", lib);
	GL_CHECK(glp->ProgramUniform3fEXT);
	glp->ProgramUniform3fv = (void APIENTRY (*)(GLuint program, GLint location, GLsizei count, const GLfloat *value)) ldg_find("glProgramUniform3fv", lib);
	GL_CHECK(glp->ProgramUniform3fv);
	glp->ProgramUniform3fvEXT = (void APIENTRY (*)(GLuint program, GLint location, GLsizei count, const GLfloat *value)) ldg_find("glProgramUniform3fvEXT", lib);
	GL_CHECK(glp->ProgramUniform3fvEXT);
	glp->ProgramUniform3i = (void APIENTRY (*)(GLuint program, GLint location, GLint v0, GLint v1, GLint v2)) ldg_find("glProgramUniform3i", lib);
	GL_CHECK(glp->ProgramUniform3i);
	glp->ProgramUniform3i64NV = (void APIENTRY (*)(GLuint program, GLint location, GLint64EXT x, GLint64EXT y, GLint64EXT z)) ldg_find("glProgramUniform3i64NV", lib);
	GL_CHECK(glp->ProgramUniform3i64NV);
	glp->ProgramUniform3i64vNV = (void APIENTRY (*)(GLuint program, GLint location, GLsizei count, const GLint64EXT *value)) ldg_find("glProgramUniform3i64vNV", lib);
	GL_CHECK(glp->ProgramUniform3i64vNV);
	glp->ProgramUniform3iEXT = (void APIENTRY (*)(GLuint program, GLint location, GLint v0, GLint v1, GLint v2)) ldg_find("glProgramUniform3iEXT", lib);
	GL_CHECK(glp->ProgramUniform3iEXT);
	glp->ProgramUniform3iv = (void APIENTRY (*)(GLuint program, GLint location, GLsizei count, const GLint *value)) ldg_find("glProgramUniform3iv", lib);
	GL_CHECK(glp->ProgramUniform3iv);
	glp->ProgramUniform3ivEXT = (void APIENTRY (*)(GLuint program, GLint location, GLsizei count, const GLint *value)) ldg_find("glProgramUniform3ivEXT", lib);
	GL_CHECK(glp->ProgramUniform3ivEXT);
	glp->ProgramUniform3ui = (void APIENTRY (*)(GLuint program, GLint location, GLuint v0, GLuint v1, GLuint v2)) ldg_find("glProgramUniform3ui", lib);
	GL_CHECK(glp->ProgramUniform3ui);
	glp->ProgramUniform3ui64NV = (void APIENTRY (*)(GLuint program, GLint location, GLuint64EXT x, GLuint64EXT y, GLuint64EXT z)) ldg_find("glProgramUniform3ui64NV", lib);
	GL_CHECK(glp->ProgramUniform3ui64NV);
	glp->ProgramUniform3ui64vNV = (void APIENTRY (*)(GLuint program, GLint location, GLsizei count, const GLuint64EXT *value)) ldg_find("glProgramUniform3ui64vNV", lib);
	GL_CHECK(glp->ProgramUniform3ui64vNV);
	glp->ProgramUniform3uiEXT = (void APIENTRY (*)(GLuint program, GLint location, GLuint v0, GLuint v1, GLuint v2)) ldg_find("glProgramUniform3uiEXT", lib);
	GL_CHECK(glp->ProgramUniform3uiEXT);
	glp->ProgramUniform3uiv = (void APIENTRY (*)(GLuint program, GLint location, GLsizei count, const GLuint *value)) ldg_find("glProgramUniform3uiv", lib);
	GL_CHECK(glp->ProgramUniform3uiv);
	glp->ProgramUniform3uivEXT = (void APIENTRY (*)(GLuint program, GLint location, GLsizei count, const GLuint *value)) ldg_find("glProgramUniform3uivEXT", lib);
	GL_CHECK(glp->ProgramUniform3uivEXT);
	glp->ProgramUniform4d = (void APIENTRY (*)(GLuint program, GLint location, GLdouble v0, GLdouble v1, GLdouble v2, GLdouble v3)) ldg_find("glProgramUniform4d", lib);
	GL_CHECK(glp->ProgramUniform4d);
	glp->ProgramUniform4dEXT = (void APIENTRY (*)(GLuint program, GLint location, GLdouble x, GLdouble y, GLdouble z, GLdouble w)) ldg_find("glProgramUniform4dEXT", lib);
	GL_CHECK(glp->ProgramUniform4dEXT);
	glp->ProgramUniform4dv = (void APIENTRY (*)(GLuint program, GLint location, GLsizei count, const GLdouble *value)) ldg_find("glProgramUniform4dv", lib);
	GL_CHECK(glp->ProgramUniform4dv);
	glp->ProgramUniform4dvEXT = (void APIENTRY (*)(GLuint program, GLint location, GLsizei count, const GLdouble *value)) ldg_find("glProgramUniform4dvEXT", lib);
	GL_CHECK(glp->ProgramUniform4dvEXT);
	glp->ProgramUniform4f = (void APIENTRY (*)(GLuint program, GLint location, GLfloat v0, GLfloat v1, GLfloat v2, GLfloat v3)) ldg_find("glProgramUniform4f", lib);
	GL_CHECK(glp->ProgramUniform4f);
	glp->ProgramUniform4fEXT = (void APIENTRY (*)(GLuint program, GLint location, GLfloat v0, GLfloat v1, GLfloat v2, GLfloat v3)) ldg_find("glProgramUniform4fEXT", lib);
	GL_CHECK(glp->ProgramUniform4fEXT);
	glp->ProgramUniform4fv = (void APIENTRY (*)(GLuint program, GLint location, GLsizei count, const GLfloat *value)) ldg_find("glProgramUniform4fv", lib);
	GL_CHECK(glp->ProgramUniform4fv);
	glp->ProgramUniform4fvEXT = (void APIENTRY (*)(GLuint program, GLint location, GLsizei count, const GLfloat *value)) ldg_find("glProgramUniform4fvEXT", lib);
	GL_CHECK(glp->ProgramUniform4fvEXT);
	glp->ProgramUniform4i = (void APIENTRY (*)(GLuint program, GLint location, GLint v0, GLint v1, GLint v2, GLint v3)) ldg_find("glProgramUniform4i", lib);
	GL_CHECK(glp->ProgramUniform4i);
	glp->ProgramUniform4i64NV = (void APIENTRY (*)(GLuint program, GLint location, GLint64EXT x, GLint64EXT y, GLint64EXT z, GLint64EXT w)) ldg_find("glProgramUniform4i64NV", lib);
	GL_CHECK(glp->ProgramUniform4i64NV);
	glp->ProgramUniform4i64vNV = (void APIENTRY (*)(GLuint program, GLint location, GLsizei count, const GLint64EXT *value)) ldg_find("glProgramUniform4i64vNV", lib);
	GL_CHECK(glp->ProgramUniform4i64vNV);
	glp->ProgramUniform4iEXT = (void APIENTRY (*)(GLuint program, GLint location, GLint v0, GLint v1, GLint v2, GLint v3)) ldg_find("glProgramUniform4iEXT", lib);
	GL_CHECK(glp->ProgramUniform4iEXT);
	glp->ProgramUniform4iv = (void APIENTRY (*)(GLuint program, GLint location, GLsizei count, const GLint *value)) ldg_find("glProgramUniform4iv", lib);
	GL_CHECK(glp->ProgramUniform4iv);
	glp->ProgramUniform4ivEXT = (void APIENTRY (*)(GLuint program, GLint location, GLsizei count, const GLint *value)) ldg_find("glProgramUniform4ivEXT", lib);
	GL_CHECK(glp->ProgramUniform4ivEXT);
	glp->ProgramUniform4ui = (void APIENTRY (*)(GLuint program, GLint location, GLuint v0, GLuint v1, GLuint v2, GLuint v3)) ldg_find("glProgramUniform4ui", lib);
	GL_CHECK(glp->ProgramUniform4ui);
	glp->ProgramUniform4ui64NV = (void APIENTRY (*)(GLuint program, GLint location, GLuint64EXT x, GLuint64EXT y, GLuint64EXT z, GLuint64EXT w)) ldg_find("glProgramUniform4ui64NV", lib);
	GL_CHECK(glp->ProgramUniform4ui64NV);
	glp->ProgramUniform4ui64vNV = (void APIENTRY (*)(GLuint program, GLint location, GLsizei count, const GLuint64EXT *value)) ldg_find("glProgramUniform4ui64vNV", lib);
	GL_CHECK(glp->ProgramUniform4ui64vNV);
	glp->ProgramUniform4uiEXT = (void APIENTRY (*)(GLuint program, GLint location, GLuint v0, GLuint v1, GLuint v2, GLuint v3)) ldg_find("glProgramUniform4uiEXT", lib);
	GL_CHECK(glp->ProgramUniform4uiEXT);
	glp->ProgramUniform4uiv = (void APIENTRY (*)(GLuint program, GLint location, GLsizei count, const GLuint *value)) ldg_find("glProgramUniform4uiv", lib);
	GL_CHECK(glp->ProgramUniform4uiv);
	glp->ProgramUniform4uivEXT = (void APIENTRY (*)(GLuint program, GLint location, GLsizei count, const GLuint *value)) ldg_find("glProgramUniform4uivEXT", lib);
	GL_CHECK(glp->ProgramUniform4uivEXT);
	glp->ProgramUniformHandleui64ARB = (void APIENTRY (*)(GLuint program, GLint location, GLuint64 value)) ldg_find("glProgramUniformHandleui64ARB", lib);
	GL_CHECK(glp->ProgramUniformHandleui64ARB);
	glp->ProgramUniformHandleui64NV = (void APIENTRY (*)(GLuint program, GLint location, GLuint64 value)) ldg_find("glProgramUniformHandleui64NV", lib);
	GL_CHECK(glp->ProgramUniformHandleui64NV);
	glp->ProgramUniformHandleui64vARB = (void APIENTRY (*)(GLuint program, GLint location, GLsizei count, const GLuint64 *values)) ldg_find("glProgramUniformHandleui64vARB", lib);
	GL_CHECK(glp->ProgramUniformHandleui64vARB);
	glp->ProgramUniformHandleui64vNV = (void APIENTRY (*)(GLuint program, GLint location, GLsizei count, const GLuint64 *values)) ldg_find("glProgramUniformHandleui64vNV", lib);
	GL_CHECK(glp->ProgramUniformHandleui64vNV);
	glp->ProgramUniformMatrix2dv = (void APIENTRY (*)(GLuint program, GLint location, GLsizei count, GLboolean32 transpose, const GLdouble *value)) ldg_find("glProgramUniformMatrix2dv", lib);
	GL_CHECK(glp->ProgramUniformMatrix2dv);
	glp->ProgramUniformMatrix2dvEXT = (void APIENTRY (*)(GLuint program, GLint location, GLsizei count, GLboolean32 transpose, const GLdouble *value)) ldg_find("glProgramUniformMatrix2dvEXT", lib);
	GL_CHECK(glp->ProgramUniformMatrix2dvEXT);
	glp->ProgramUniformMatrix2fv = (void APIENTRY (*)(GLuint program, GLint location, GLsizei count, GLboolean32 transpose, const GLfloat *value)) ldg_find("glProgramUniformMatrix2fv", lib);
	GL_CHECK(glp->ProgramUniformMatrix2fv);
	glp->ProgramUniformMatrix2fvEXT = (void APIENTRY (*)(GLuint program, GLint location, GLsizei count, GLboolean32 transpose, const GLfloat *value)) ldg_find("glProgramUniformMatrix2fvEXT", lib);
	GL_CHECK(glp->ProgramUniformMatrix2fvEXT);
	glp->ProgramUniformMatrix2x3dv = (void APIENTRY (*)(GLuint program, GLint location, GLsizei count, GLboolean32 transpose, const GLdouble *value)) ldg_find("glProgramUniformMatrix2x3dv", lib);
	GL_CHECK(glp->ProgramUniformMatrix2x3dv);
	glp->ProgramUniformMatrix2x3dvEXT = (void APIENTRY (*)(GLuint program, GLint location, GLsizei count, GLboolean32 transpose, const GLdouble *value)) ldg_find("glProgramUniformMatrix2x3dvEXT", lib);
	GL_CHECK(glp->ProgramUniformMatrix2x3dvEXT);
	glp->ProgramUniformMatrix2x3fv = (void APIENTRY (*)(GLuint program, GLint location, GLsizei count, GLboolean32 transpose, const GLfloat *value)) ldg_find("glProgramUniformMatrix2x3fv", lib);
	GL_CHECK(glp->ProgramUniformMatrix2x3fv);
	glp->ProgramUniformMatrix2x3fvEXT = (void APIENTRY (*)(GLuint program, GLint location, GLsizei count, GLboolean32 transpose, const GLfloat *value)) ldg_find("glProgramUniformMatrix2x3fvEXT", lib);
	GL_CHECK(glp->ProgramUniformMatrix2x3fvEXT);
	glp->ProgramUniformMatrix2x4dv = (void APIENTRY (*)(GLuint program, GLint location, GLsizei count, GLboolean32 transpose, const GLdouble *value)) ldg_find("glProgramUniformMatrix2x4dv", lib);
	GL_CHECK(glp->ProgramUniformMatrix2x4dv);
	glp->ProgramUniformMatrix2x4dvEXT = (void APIENTRY (*)(GLuint program, GLint location, GLsizei count, GLboolean32 transpose, const GLdouble *value)) ldg_find("glProgramUniformMatrix2x4dvEXT", lib);
	GL_CHECK(glp->ProgramUniformMatrix2x4dvEXT);
	glp->ProgramUniformMatrix2x4fv = (void APIENTRY (*)(GLuint program, GLint location, GLsizei count, GLboolean32 transpose, const GLfloat *value)) ldg_find("glProgramUniformMatrix2x4fv", lib);
	GL_CHECK(glp->ProgramUniformMatrix2x4fv);
	glp->ProgramUniformMatrix2x4fvEXT = (void APIENTRY (*)(GLuint program, GLint location, GLsizei count, GLboolean32 transpose, const GLfloat *value)) ldg_find("glProgramUniformMatrix2x4fvEXT", lib);
	GL_CHECK(glp->ProgramUniformMatrix2x4fvEXT);
	glp->ProgramUniformMatrix3dv = (void APIENTRY (*)(GLuint program, GLint location, GLsizei count, GLboolean32 transpose, const GLdouble *value)) ldg_find("glProgramUniformMatrix3dv", lib);
	GL_CHECK(glp->ProgramUniformMatrix3dv);
	glp->ProgramUniformMatrix3dvEXT = (void APIENTRY (*)(GLuint program, GLint location, GLsizei count, GLboolean32 transpose, const GLdouble *value)) ldg_find("glProgramUniformMatrix3dvEXT", lib);
	GL_CHECK(glp->ProgramUniformMatrix3dvEXT);
	glp->ProgramUniformMatrix3fv = (void APIENTRY (*)(GLuint program, GLint location, GLsizei count, GLboolean32 transpose, const GLfloat *value)) ldg_find("glProgramUniformMatrix3fv", lib);
	GL_CHECK(glp->ProgramUniformMatrix3fv);
	glp->ProgramUniformMatrix3fvEXT = (void APIENTRY (*)(GLuint program, GLint location, GLsizei count, GLboolean32 transpose, const GLfloat *value)) ldg_find("glProgramUniformMatrix3fvEXT", lib);
	GL_CHECK(glp->ProgramUniformMatrix3fvEXT);
	glp->ProgramUniformMatrix3x2dv = (void APIENTRY (*)(GLuint program, GLint location, GLsizei count, GLboolean32 transpose, const GLdouble *value)) ldg_find("glProgramUniformMatrix3x2dv", lib);
	GL_CHECK(glp->ProgramUniformMatrix3x2dv);
	glp->ProgramUniformMatrix3x2dvEXT = (void APIENTRY (*)(GLuint program, GLint location, GLsizei count, GLboolean32 transpose, const GLdouble *value)) ldg_find("glProgramUniformMatrix3x2dvEXT", lib);
	GL_CHECK(glp->ProgramUniformMatrix3x2dvEXT);
	glp->ProgramUniformMatrix3x2fv = (void APIENTRY (*)(GLuint program, GLint location, GLsizei count, GLboolean32 transpose, const GLfloat *value)) ldg_find("glProgramUniformMatrix3x2fv", lib);
	GL_CHECK(glp->ProgramUniformMatrix3x2fv);
	glp->ProgramUniformMatrix3x2fvEXT = (void APIENTRY (*)(GLuint program, GLint location, GLsizei count, GLboolean32 transpose, const GLfloat *value)) ldg_find("glProgramUniformMatrix3x2fvEXT", lib);
	GL_CHECK(glp->ProgramUniformMatrix3x2fvEXT);
	glp->ProgramUniformMatrix3x4dv = (void APIENTRY (*)(GLuint program, GLint location, GLsizei count, GLboolean32 transpose, const GLdouble *value)) ldg_find("glProgramUniformMatrix3x4dv", lib);
	GL_CHECK(glp->ProgramUniformMatrix3x4dv);
	glp->ProgramUniformMatrix3x4dvEXT = (void APIENTRY (*)(GLuint program, GLint location, GLsizei count, GLboolean32 transpose, const GLdouble *value)) ldg_find("glProgramUniformMatrix3x4dvEXT", lib);
	GL_CHECK(glp->ProgramUniformMatrix3x4dvEXT);
	glp->ProgramUniformMatrix3x4fv = (void APIENTRY (*)(GLuint program, GLint location, GLsizei count, GLboolean32 transpose, const GLfloat *value)) ldg_find("glProgramUniformMatrix3x4fv", lib);
	GL_CHECK(glp->ProgramUniformMatrix3x4fv);
	glp->ProgramUniformMatrix3x4fvEXT = (void APIENTRY (*)(GLuint program, GLint location, GLsizei count, GLboolean32 transpose, const GLfloat *value)) ldg_find("glProgramUniformMatrix3x4fvEXT", lib);
	GL_CHECK(glp->ProgramUniformMatrix3x4fvEXT);
	glp->ProgramUniformMatrix4dv = (void APIENTRY (*)(GLuint program, GLint location, GLsizei count, GLboolean32 transpose, const GLdouble *value)) ldg_find("glProgramUniformMatrix4dv", lib);
	GL_CHECK(glp->ProgramUniformMatrix4dv);
	glp->ProgramUniformMatrix4dvEXT = (void APIENTRY (*)(GLuint program, GLint location, GLsizei count, GLboolean32 transpose, const GLdouble *value)) ldg_find("glProgramUniformMatrix4dvEXT", lib);
	GL_CHECK(glp->ProgramUniformMatrix4dvEXT);
	glp->ProgramUniformMatrix4fv = (void APIENTRY (*)(GLuint program, GLint location, GLsizei count, GLboolean32 transpose, const GLfloat *value)) ldg_find("glProgramUniformMatrix4fv", lib);
	GL_CHECK(glp->ProgramUniformMatrix4fv);
	glp->ProgramUniformMatrix4fvEXT = (void APIENTRY (*)(GLuint program, GLint location, GLsizei count, GLboolean32 transpose, const GLfloat *value)) ldg_find("glProgramUniformMatrix4fvEXT", lib);
	GL_CHECK(glp->ProgramUniformMatrix4fvEXT);
	glp->ProgramUniformMatrix4x2dv = (void APIENTRY (*)(GLuint program, GLint location, GLsizei count, GLboolean32 transpose, const GLdouble *value)) ldg_find("glProgramUniformMatrix4x2dv", lib);
	GL_CHECK(glp->ProgramUniformMatrix4x2dv);
	glp->ProgramUniformMatrix4x2dvEXT = (void APIENTRY (*)(GLuint program, GLint location, GLsizei count, GLboolean32 transpose, const GLdouble *value)) ldg_find("glProgramUniformMatrix4x2dvEXT", lib);
	GL_CHECK(glp->ProgramUniformMatrix4x2dvEXT);
	glp->ProgramUniformMatrix4x2fv = (void APIENTRY (*)(GLuint program, GLint location, GLsizei count, GLboolean32 transpose, const GLfloat *value)) ldg_find("glProgramUniformMatrix4x2fv", lib);
	GL_CHECK(glp->ProgramUniformMatrix4x2fv);
	glp->ProgramUniformMatrix4x2fvEXT = (void APIENTRY (*)(GLuint program, GLint location, GLsizei count, GLboolean32 transpose, const GLfloat *value)) ldg_find("glProgramUniformMatrix4x2fvEXT", lib);
	GL_CHECK(glp->ProgramUniformMatrix4x2fvEXT);
	glp->ProgramUniformMatrix4x3dv = (void APIENTRY (*)(GLuint program, GLint location, GLsizei count, GLboolean32 transpose, const GLdouble *value)) ldg_find("glProgramUniformMatrix4x3dv", lib);
	GL_CHECK(glp->ProgramUniformMatrix4x3dv);
	glp->ProgramUniformMatrix4x3dvEXT = (void APIENTRY (*)(GLuint program, GLint location, GLsizei count, GLboolean32 transpose, const GLdouble *value)) ldg_find("glProgramUniformMatrix4x3dvEXT", lib);
	GL_CHECK(glp->ProgramUniformMatrix4x3dvEXT);
	glp->ProgramUniformMatrix4x3fv = (void APIENTRY (*)(GLuint program, GLint location, GLsizei count, GLboolean32 transpose, const GLfloat *value)) ldg_find("glProgramUniformMatrix4x3fv", lib);
	GL_CHECK(glp->ProgramUniformMatrix4x3fv);
	glp->ProgramUniformMatrix4x3fvEXT = (void APIENTRY (*)(GLuint program, GLint location, GLsizei count, GLboolean32 transpose, const GLfloat *value)) ldg_find("glProgramUniformMatrix4x3fvEXT", lib);
	GL_CHECK(glp->ProgramUniformMatrix4x3fvEXT);
	glp->ProgramUniformui64NV = (void APIENTRY (*)(GLuint program, GLint location, GLuint64EXT value)) ldg_find("glProgramUniformui64NV", lib);
	GL_CHECK(glp->ProgramUniformui64NV);
	glp->ProgramUniformui64vNV = (void APIENTRY (*)(GLuint program, GLint location, GLsizei count, const GLuint64EXT *value)) ldg_find("glProgramUniformui64vNV", lib);
	GL_CHECK(glp->ProgramUniformui64vNV);
	glp->ProgramVertexLimitNV = (void APIENTRY (*)(GLenum target, GLint limit)) ldg_find("glProgramVertexLimitNV", lib);
	GL_CHECK(glp->ProgramVertexLimitNV);
	glp->ProvokingVertex = (void APIENTRY (*)(GLenum mode)) ldg_find("glProvokingVertex", lib);
	GL_CHECK(glp->ProvokingVertex);
	glp->ProvokingVertexEXT = (void APIENTRY (*)(GLenum mode)) ldg_find("glProvokingVertexEXT", lib);
	GL_CHECK(glp->ProvokingVertexEXT);
	glp->PushClientAttribDefaultEXT = (void APIENTRY (*)(GLbitfield mask)) ldg_find("glPushClientAttribDefaultEXT", lib);
	GL_CHECK(glp->PushClientAttribDefaultEXT);
	glp->PushDebugGroup = (void APIENTRY (*)(GLenum source, GLuint id, GLsizei length, const GLchar *message)) ldg_find("glPushDebugGroup", lib);
	GL_CHECK(glp->PushDebugGroup);
	glp->PushGroupMarkerEXT = (void APIENTRY (*)(GLsizei length, const GLchar *marker)) ldg_find("glPushGroupMarkerEXT", lib);
	GL_CHECK(glp->PushGroupMarkerEXT);
	glp->QueryCounter = (void APIENTRY (*)(GLuint id, GLenum target)) ldg_find("glQueryCounter", lib);
	GL_CHECK(glp->QueryCounter);
	glp->QueryMatrixxOES = (GLbitfield APIENTRY (*)(GLfixed *mantissa, GLint *exponent)) ldg_find("glQueryMatrixxOES", lib);
	GL_CHECK(glp->QueryMatrixxOES);
	glp->QueryObjectParameteruiAMD = (void APIENTRY (*)(GLenum target, GLuint id, GLenum pname, GLuint param)) ldg_find("glQueryObjectParameteruiAMD", lib);
	GL_CHECK(glp->QueryObjectParameteruiAMD);
	glp->RasterPos2xOES = (void APIENTRY (*)(GLfixed x, GLfixed y)) ldg_find("glRasterPos2xOES", lib);
	GL_CHECK(glp->RasterPos2xOES);
	glp->RasterPos2xvOES = (void APIENTRY (*)(const GLfixed *coords)) ldg_find("glRasterPos2xvOES", lib);
	GL_CHECK(glp->RasterPos2xvOES);
	glp->RasterPos3xOES = (void APIENTRY (*)(GLfixed x, GLfixed y, GLfixed z)) ldg_find("glRasterPos3xOES", lib);
	GL_CHECK(glp->RasterPos3xOES);
	glp->RasterPos3xvOES = (void APIENTRY (*)(const GLfixed *coords)) ldg_find("glRasterPos3xvOES", lib);
	GL_CHECK(glp->RasterPos3xvOES);
	glp->RasterPos4xOES = (void APIENTRY (*)(GLfixed x, GLfixed y, GLfixed z, GLfixed w)) ldg_find("glRasterPos4xOES", lib);
	GL_CHECK(glp->RasterPos4xOES);
	glp->RasterPos4xvOES = (void APIENTRY (*)(const GLfixed *coords)) ldg_find("glRasterPos4xvOES", lib);
	GL_CHECK(glp->RasterPos4xvOES);
	glp->ReadnPixelsARB = (void APIENTRY (*)(GLint x, GLint y, GLsizei width, GLsizei height, GLenum format, GLenum type, GLsizei bufSize, void *data)) ldg_find("glReadnPixelsARB", lib);
	GL_CHECK(glp->ReadnPixelsARB);
	glp->RectxOES = (void APIENTRY (*)(GLfixed x1, GLfixed y1, GLfixed x2, GLfixed y2)) ldg_find("glRectxOES", lib);
	GL_CHECK(glp->RectxOES);
	glp->RectxvOES = (void APIENTRY (*)(const GLfixed *v1, const GLfixed *v2)) ldg_find("glRectxvOES", lib);
	GL_CHECK(glp->RectxvOES);
	glp->ReleaseShaderCompiler = (void APIENTRY (*)(void)) ldg_find("glReleaseShaderCompiler", lib);
	GL_CHECK(glp->ReleaseShaderCompiler);
	glp->RenderbufferStorage = (void APIENTRY (*)(GLenum target, GLenum internalformat, GLsizei width, GLsizei height)) ldg_find("glRenderbufferStorage", lib);
	GL_CHECK(glp->RenderbufferStorage);
	glp->RenderbufferStorageEXT = (void APIENTRY (*)(GLenum target, GLenum internalformat, GLsizei width, GLsizei height)) ldg_find("glRenderbufferStorageEXT", lib);
	GL_CHECK(glp->RenderbufferStorageEXT);
	glp->RenderbufferStorageMultisample = (void APIENTRY (*)(GLenum target, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height)) ldg_find("glRenderbufferStorageMultisample", lib);
	GL_CHECK(glp->RenderbufferStorageMultisample);
	glp->RenderbufferStorageMultisampleCoverageNV = (void APIENTRY (*)(GLenum target, GLsizei coverageSamples, GLsizei colorSamples, GLenum internalformat, GLsizei width, GLsizei height)) ldg_find("glRenderbufferStorageMultisampleCoverageNV", lib);
	GL_CHECK(glp->RenderbufferStorageMultisampleCoverageNV);
	glp->RenderbufferStorageMultisampleEXT = (void APIENTRY (*)(GLenum target, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height)) ldg_find("glRenderbufferStorageMultisampleEXT", lib);
	GL_CHECK(glp->RenderbufferStorageMultisampleEXT);
	glp->ResumeTransformFeedback = (void APIENTRY (*)(void)) ldg_find("glResumeTransformFeedback", lib);
	GL_CHECK(glp->ResumeTransformFeedback);
	glp->ResumeTransformFeedbackNV = (void APIENTRY (*)(void)) ldg_find("glResumeTransformFeedbackNV", lib);
	GL_CHECK(glp->ResumeTransformFeedbackNV);
	glp->RotatexOES = (void APIENTRY (*)(GLfixed angle, GLfixed x, GLfixed y, GLfixed z)) ldg_find("glRotatexOES", lib);
	GL_CHECK(glp->RotatexOES);
	glp->SampleCoverageOES = (void APIENTRY (*)(GLfixed value, GLboolean32 invert)) ldg_find("glSampleCoverageOES", lib);
	GL_CHECK(glp->SampleCoverageOES);
	glp->SampleMaskIndexedNV = (void APIENTRY (*)(GLuint index, GLbitfield mask)) ldg_find("glSampleMaskIndexedNV", lib);
	GL_CHECK(glp->SampleMaskIndexedNV);
	glp->SampleMaski = (void APIENTRY (*)(GLuint maskNumber, GLbitfield mask)) ldg_find("glSampleMaski", lib);
	GL_CHECK(glp->SampleMaski);
	glp->SamplePass = (void APIENTRY (*)(GLenum mode)) ldg_find("glSamplePass", lib);
	GL_CHECK(glp->SamplePass);
	glp->SamplePassARB = (void APIENTRY (*)(GLenum mode)) ldg_find("glSamplePassARB", lib);
	GL_CHECK(glp->SamplePassARB);
	glp->SamplerParameterIiv = (void APIENTRY (*)(GLuint sampler, GLenum pname, const GLint *param)) ldg_find("glSamplerParameterIiv", lib);
	GL_CHECK(glp->SamplerParameterIiv);
	glp->SamplerParameterIuiv = (void APIENTRY (*)(GLuint sampler, GLenum pname, const GLuint *param)) ldg_find("glSamplerParameterIuiv", lib);
	GL_CHECK(glp->SamplerParameterIuiv);
	glp->SamplerParameterf = (void APIENTRY (*)(GLuint sampler, GLenum pname, GLfloat param)) ldg_find("glSamplerParameterf", lib);
	GL_CHECK(glp->SamplerParameterf);
	glp->SamplerParameterfv = (void APIENTRY (*)(GLuint sampler, GLenum pname, const GLfloat *param)) ldg_find("glSamplerParameterfv", lib);
	GL_CHECK(glp->SamplerParameterfv);
	glp->SamplerParameteri = (void APIENTRY (*)(GLuint sampler, GLenum pname, GLint param)) ldg_find("glSamplerParameteri", lib);
	GL_CHECK(glp->SamplerParameteri);
	glp->SamplerParameteriv = (void APIENTRY (*)(GLuint sampler, GLenum pname, const GLint *param)) ldg_find("glSamplerParameteriv", lib);
	GL_CHECK(glp->SamplerParameteriv);
	glp->ScalexOES = (void APIENTRY (*)(GLfixed x, GLfixed y, GLfixed z)) ldg_find("glScalexOES", lib);
	GL_CHECK(glp->ScalexOES);
	glp->ScissorArrayv = (void APIENTRY (*)(GLuint first, GLsizei count, const GLint *v)) ldg_find("glScissorArrayv", lib);
	GL_CHECK(glp->ScissorArrayv);
	glp->ScissorIndexed = (void APIENTRY (*)(GLuint index, GLint left, GLint bottom, GLsizei width, GLsizei height)) ldg_find("glScissorIndexed", lib);
	GL_CHECK(glp->ScissorIndexed);
	glp->ScissorIndexedv = (void APIENTRY (*)(GLuint index, const GLint *v)) ldg_find("glScissorIndexedv", lib);
	GL_CHECK(glp->ScissorIndexedv);
	glp->SecondaryColorFormatNV = (void APIENTRY (*)(GLint size, GLenum type, GLsizei stride)) ldg_find("glSecondaryColorFormatNV", lib);
	GL_CHECK(glp->SecondaryColorFormatNV);
	glp->SecondaryColorP3ui = (void APIENTRY (*)(GLenum type, GLuint color)) ldg_find("glSecondaryColorP3ui", lib);
	GL_CHECK(glp->SecondaryColorP3ui);
	glp->SecondaryColorP3uiv = (void APIENTRY (*)(GLenum type, const GLuint *color)) ldg_find("glSecondaryColorP3uiv", lib);
	GL_CHECK(glp->SecondaryColorP3uiv);
	glp->SelectPerfMonitorCountersAMD = (void APIENTRY (*)(GLuint monitor, GLboolean32 enable, GLuint group, GLint numCounters, GLuint *counterList)) ldg_find("glSelectPerfMonitorCountersAMD", lib);
	GL_CHECK(glp->SelectPerfMonitorCountersAMD);
	glp->SetMultisamplefvAMD = (void APIENTRY (*)(GLenum pname, GLuint index, const GLfloat *val)) ldg_find("glSetMultisamplefvAMD", lib);
	GL_CHECK(glp->SetMultisamplefvAMD);
	glp->ShaderBinary = (void APIENTRY (*)(GLsizei count, const GLuint *shaders, GLenum binaryformat, const void *binary, GLsizei length)) ldg_find("glShaderBinary", lib);
	GL_CHECK(glp->ShaderBinary);
	glp->ShaderSource = (void APIENTRY (*)(GLuint shader, GLsizei count, const GLchar *const *string, const GLint *length)) ldg_find("glShaderSource", lib);
	GL_CHECK(glp->ShaderSource);
	glp->ShaderStorageBlockBinding = (void APIENTRY (*)(GLuint program, GLuint storageBlockIndex, GLuint storageBlockBinding)) ldg_find("glShaderStorageBlockBinding", lib);
	GL_CHECK(glp->ShaderStorageBlockBinding);
	glp->StencilClearTagEXT = (void APIENTRY (*)(GLsizei stencilTagBits, GLuint stencilClearTag)) ldg_find("glStencilClearTagEXT", lib);
	GL_CHECK(glp->StencilClearTagEXT);
	glp->StencilFillPathInstancedNV = (void APIENTRY (*)(GLsizei numPaths, GLenum pathNameType, const void *paths, GLuint pathBase, GLenum fillMode, GLuint mask, GLenum transformType, const GLfloat *transformValues)) ldg_find("glStencilFillPathInstancedNV", lib);
	GL_CHECK(glp->StencilFillPathInstancedNV);
	glp->StencilFillPathNV = (void APIENTRY (*)(GLuint path, GLenum fillMode, GLuint mask)) ldg_find("glStencilFillPathNV", lib);
	GL_CHECK(glp->StencilFillPathNV);
	glp->StencilFuncSeparate = (void APIENTRY (*)(GLenum face, GLenum func, GLint ref, GLuint mask)) ldg_find("glStencilFuncSeparate", lib);
	GL_CHECK(glp->StencilFuncSeparate);
	glp->StencilMaskSeparate = (void APIENTRY (*)(GLenum face, GLuint mask)) ldg_find("glStencilMaskSeparate", lib);
	GL_CHECK(glp->StencilMaskSeparate);
	glp->StencilOpSeparate = (void APIENTRY (*)(GLenum face, GLenum sfail, GLenum dpfail, GLenum dppass)) ldg_find("glStencilOpSeparate", lib);
	GL_CHECK(glp->StencilOpSeparate);
	glp->StencilOpValueAMD = (void APIENTRY (*)(GLenum face, GLuint value)) ldg_find("glStencilOpValueAMD", lib);
	GL_CHECK(glp->StencilOpValueAMD);
	glp->StencilStrokePathInstancedNV = (void APIENTRY (*)(GLsizei numPaths, GLenum pathNameType, const void *paths, GLuint pathBase, GLint reference, GLuint mask, GLenum transformType, const GLfloat *transformValues)) ldg_find("glStencilStrokePathInstancedNV", lib);
	GL_CHECK(glp->StencilStrokePathInstancedNV);
	glp->StencilStrokePathNV = (void APIENTRY (*)(GLuint path, GLint reference, GLuint mask)) ldg_find("glStencilStrokePathNV", lib);
	GL_CHECK(glp->StencilStrokePathNV);
	glp->StringMarkerGREMEDY = (void APIENTRY (*)(GLsizei len, const void *string)) ldg_find("glStringMarkerGREMEDY", lib);
	GL_CHECK(glp->StringMarkerGREMEDY);
	glp->SwapAPPLE = (void APIENTRY (*)(void)) ldg_find("glSwapAPPLE", lib);
	GL_CHECK(glp->SwapAPPLE);
	glp->SyncTextureINTEL = (void APIENTRY (*)(GLuint texture)) ldg_find("glSyncTextureINTEL", lib);
	GL_CHECK(glp->SyncTextureINTEL);
	glp->TessellationFactorAMD = (void APIENTRY (*)(GLfloat factor)) ldg_find("glTessellationFactorAMD", lib);
	GL_CHECK(glp->TessellationFactorAMD);
	glp->TessellationModeAMD = (void APIENTRY (*)(GLenum mode)) ldg_find("glTessellationModeAMD", lib);
	GL_CHECK(glp->TessellationModeAMD);
	glp->TexBuffer = (void APIENTRY (*)(GLenum target, GLenum internalformat, GLuint buffer)) ldg_find("glTexBuffer", lib);
	GL_CHECK(glp->TexBuffer);
	glp->TexBufferARB = (void APIENTRY (*)(GLenum target, GLenum internalformat, GLuint buffer)) ldg_find("glTexBufferARB", lib);
	GL_CHECK(glp->TexBufferARB);
	glp->TexBufferEXT = (void APIENTRY (*)(GLenum target, GLenum internalformat, GLuint buffer)) ldg_find("glTexBufferEXT", lib);
	GL_CHECK(glp->TexBufferEXT);
	glp->TexBufferRange = (void APIENTRY (*)(GLenum target, GLenum internalformat, GLuint buffer, GLintptr offset, GLsizeiptr size)) ldg_find("glTexBufferRange", lib);
	GL_CHECK(glp->TexBufferRange);
	glp->TexCoord1bOES = (void APIENTRY (*)(GLbyte32 s)) ldg_find("glTexCoord1bOES", lib);
	GL_CHECK(glp->TexCoord1bOES);
	glp->TexCoord1bvOES = (void APIENTRY (*)(const GLbyte *coords)) ldg_find("glTexCoord1bvOES", lib);
	GL_CHECK(glp->TexCoord1bvOES);
	glp->TexCoord1xOES = (void APIENTRY (*)(GLfixed s)) ldg_find("glTexCoord1xOES", lib);
	GL_CHECK(glp->TexCoord1xOES);
	glp->TexCoord1xvOES = (void APIENTRY (*)(const GLfixed *coords)) ldg_find("glTexCoord1xvOES", lib);
	GL_CHECK(glp->TexCoord1xvOES);
	glp->TexCoord2bOES = (void APIENTRY (*)(GLbyte32 s, GLbyte32 t)) ldg_find("glTexCoord2bOES", lib);
	GL_CHECK(glp->TexCoord2bOES);
	glp->TexCoord2bvOES = (void APIENTRY (*)(const GLbyte *coords)) ldg_find("glTexCoord2bvOES", lib);
	GL_CHECK(glp->TexCoord2bvOES);
	glp->TexCoord2xOES = (void APIENTRY (*)(GLfixed s, GLfixed t)) ldg_find("glTexCoord2xOES", lib);
	GL_CHECK(glp->TexCoord2xOES);
	glp->TexCoord2xvOES = (void APIENTRY (*)(const GLfixed *coords)) ldg_find("glTexCoord2xvOES", lib);
	GL_CHECK(glp->TexCoord2xvOES);
	glp->TexCoord3bOES = (void APIENTRY (*)(GLbyte32 s, GLbyte32 t, GLbyte32 r)) ldg_find("glTexCoord3bOES", lib);
	GL_CHECK(glp->TexCoord3bOES);
	glp->TexCoord3bvOES = (void APIENTRY (*)(const GLbyte *coords)) ldg_find("glTexCoord3bvOES", lib);
	GL_CHECK(glp->TexCoord3bvOES);
	glp->TexCoord3xOES = (void APIENTRY (*)(GLfixed s, GLfixed t, GLfixed r)) ldg_find("glTexCoord3xOES", lib);
	GL_CHECK(glp->TexCoord3xOES);
	glp->TexCoord3xvOES = (void APIENTRY (*)(const GLfixed *coords)) ldg_find("glTexCoord3xvOES", lib);
	GL_CHECK(glp->TexCoord3xvOES);
	glp->TexCoord4bOES = (void APIENTRY (*)(GLbyte32 s, GLbyte32 t, GLbyte32 r, GLbyte32 q)) ldg_find("glTexCoord4bOES", lib);
	GL_CHECK(glp->TexCoord4bOES);
	glp->TexCoord4bvOES = (void APIENTRY (*)(const GLbyte *coords)) ldg_find("glTexCoord4bvOES", lib);
	GL_CHECK(glp->TexCoord4bvOES);
	glp->TexCoord4xOES = (void APIENTRY (*)(GLfixed s, GLfixed t, GLfixed r, GLfixed q)) ldg_find("glTexCoord4xOES", lib);
	GL_CHECK(glp->TexCoord4xOES);
	glp->TexCoord4xvOES = (void APIENTRY (*)(const GLfixed *coords)) ldg_find("glTexCoord4xvOES", lib);
	GL_CHECK(glp->TexCoord4xvOES);
	glp->TexCoordFormatNV = (void APIENTRY (*)(GLint size, GLenum type, GLsizei stride)) ldg_find("glTexCoordFormatNV", lib);
	GL_CHECK(glp->TexCoordFormatNV);
	glp->TexCoordP1ui = (void APIENTRY (*)(GLenum type, GLuint coords)) ldg_find("glTexCoordP1ui", lib);
	GL_CHECK(glp->TexCoordP1ui);
	glp->TexCoordP1uiv = (void APIENTRY (*)(GLenum type, const GLuint *coords)) ldg_find("glTexCoordP1uiv", lib);
	GL_CHECK(glp->TexCoordP1uiv);
	glp->TexCoordP2ui = (void APIENTRY (*)(GLenum type, GLuint coords)) ldg_find("glTexCoordP2ui", lib);
	GL_CHECK(glp->TexCoordP2ui);
	glp->TexCoordP2uiv = (void APIENTRY (*)(GLenum type, const GLuint *coords)) ldg_find("glTexCoordP2uiv", lib);
	GL_CHECK(glp->TexCoordP2uiv);
	glp->TexCoordP3ui = (void APIENTRY (*)(GLenum type, GLuint coords)) ldg_find("glTexCoordP3ui", lib);
	GL_CHECK(glp->TexCoordP3ui);
	glp->TexCoordP3uiv = (void APIENTRY (*)(GLenum type, const GLuint *coords)) ldg_find("glTexCoordP3uiv", lib);
	GL_CHECK(glp->TexCoordP3uiv);
	glp->TexCoordP4ui = (void APIENTRY (*)(GLenum type, GLuint coords)) ldg_find("glTexCoordP4ui", lib);
	GL_CHECK(glp->TexCoordP4ui);
	glp->TexCoordP4uiv = (void APIENTRY (*)(GLenum type, const GLuint *coords)) ldg_find("glTexCoordP4uiv", lib);
	GL_CHECK(glp->TexCoordP4uiv);
	glp->TexEnvxOES = (void APIENTRY (*)(GLenum target, GLenum pname, GLfixed param)) ldg_find("glTexEnvxOES", lib);
	GL_CHECK(glp->TexEnvxOES);
	glp->TexEnvxvOES = (void APIENTRY (*)(GLenum target, GLenum pname, const GLfixed *params)) ldg_find("glTexEnvxvOES", lib);
	GL_CHECK(glp->TexEnvxvOES);
	glp->TexGenxOES = (void APIENTRY (*)(GLenum coord, GLenum pname, GLfixed param)) ldg_find("glTexGenxOES", lib);
	GL_CHECK(glp->TexGenxOES);
	glp->TexGenxvOES = (void APIENTRY (*)(GLenum coord, GLenum pname, const GLfixed *params)) ldg_find("glTexGenxvOES", lib);
	GL_CHECK(glp->TexGenxvOES);
	glp->TexImage2DMultisample = (void APIENTRY (*)(GLenum target, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height, GLboolean32 fixedsamplelocations)) ldg_find("glTexImage2DMultisample", lib);
	GL_CHECK(glp->TexImage2DMultisample);
	glp->TexImage2DMultisampleCoverageNV = (void APIENTRY (*)(GLenum target, GLsizei coverageSamples, GLsizei colorSamples, GLint internalFormat, GLsizei width, GLsizei height, GLboolean32 fixedSampleLocations)) ldg_find("glTexImage2DMultisampleCoverageNV", lib);
	GL_CHECK(glp->TexImage2DMultisampleCoverageNV);
	glp->TexImage3DMultisample = (void APIENTRY (*)(GLenum target, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, GLboolean32 fixedsamplelocations)) ldg_find("glTexImage3DMultisample", lib);
	GL_CHECK(glp->TexImage3DMultisample);
	glp->TexImage3DMultisampleCoverageNV = (void APIENTRY (*)(GLenum target, GLsizei coverageSamples, GLsizei colorSamples, GLint internalFormat, GLsizei width, GLsizei height, GLsizei depth, GLboolean32 fixedSampleLocations)) ldg_find("glTexImage3DMultisampleCoverageNV", lib);
	GL_CHECK(glp->TexImage3DMultisampleCoverageNV);
	glp->TexPageCommitmentARB = (void APIENTRY (*)(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLboolean32 commit)) ldg_find("glTexPageCommitmentARB", lib);
	GL_CHECK(glp->TexPageCommitmentARB);
	glp->TexParameterIiv = (void APIENTRY (*)(GLenum target, GLenum pname, const GLint *params)) ldg_find("glTexParameterIiv", lib);
	GL_CHECK(glp->TexParameterIiv);
	glp->TexParameterIivEXT = (void APIENTRY (*)(GLenum target, GLenum pname, const GLint *params)) ldg_find("glTexParameterIivEXT", lib);
	GL_CHECK(glp->TexParameterIivEXT);
	glp->TexParameterIuiv = (void APIENTRY (*)(GLenum target, GLenum pname, const GLuint *params)) ldg_find("glTexParameterIuiv", lib);
	GL_CHECK(glp->TexParameterIuiv);
	glp->TexParameterIuivEXT = (void APIENTRY (*)(GLenum target, GLenum pname, const GLuint *params)) ldg_find("glTexParameterIuivEXT", lib);
	GL_CHECK(glp->TexParameterIuivEXT);
	glp->TexParameterxOES = (void APIENTRY (*)(GLenum target, GLenum pname, GLfixed param)) ldg_find("glTexParameterxOES", lib);
	GL_CHECK(glp->TexParameterxOES);
	glp->TexParameterxvOES = (void APIENTRY (*)(GLenum target, GLenum pname, const GLfixed *params)) ldg_find("glTexParameterxvOES", lib);
	GL_CHECK(glp->TexParameterxvOES);
	glp->TexRenderbufferNV = (void APIENTRY (*)(GLenum target, GLuint renderbuffer)) ldg_find("glTexRenderbufferNV", lib);
	GL_CHECK(glp->TexRenderbufferNV);
	glp->TexScissorFuncINTEL = (void APIENTRY (*)(GLenum target, GLenum lfunc, GLenum hfunc)) ldg_find("glTexScissorFuncINTEL", lib);
	GL_CHECK(glp->TexScissorFuncINTEL);
	glp->TexScissorINTEL = (void APIENTRY (*)(GLenum target, GLclampf tlow, GLclampf thigh)) ldg_find("glTexScissorINTEL", lib);
	GL_CHECK(glp->TexScissorINTEL);
	glp->TexStorage1D = (void APIENTRY (*)(GLenum target, GLsizei levels, GLenum internalformat, GLsizei width)) ldg_find("glTexStorage1D", lib);
	GL_CHECK(glp->TexStorage1D);
	glp->TexStorage2D = (void APIENTRY (*)(GLenum target, GLsizei levels, GLenum internalformat, GLsizei width, GLsizei height)) ldg_find("glTexStorage2D", lib);
	GL_CHECK(glp->TexStorage2D);
	glp->TexStorage2DMultisample = (void APIENTRY (*)(GLenum target, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height, GLboolean32 fixedsamplelocations)) ldg_find("glTexStorage2DMultisample", lib);
	GL_CHECK(glp->TexStorage2DMultisample);
	glp->TexStorage3D = (void APIENTRY (*)(GLenum target, GLsizei levels, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth)) ldg_find("glTexStorage3D", lib);
	GL_CHECK(glp->TexStorage3D);
	glp->TexStorage3DMultisample = (void APIENTRY (*)(GLenum target, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, GLboolean32 fixedsamplelocations)) ldg_find("glTexStorage3DMultisample", lib);
	GL_CHECK(glp->TexStorage3DMultisample);
	glp->TexStorageSparseAMD = (void APIENTRY (*)(GLenum target, GLenum internalFormat, GLsizei width, GLsizei height, GLsizei depth, GLsizei layers, GLbitfield flags)) ldg_find("glTexStorageSparseAMD", lib);
	GL_CHECK(glp->TexStorageSparseAMD);
	glp->TextureBarrierNV = (void APIENTRY (*)(void)) ldg_find("glTextureBarrierNV", lib);
	GL_CHECK(glp->TextureBarrierNV);
	glp->TextureBufferEXT = (void APIENTRY (*)(GLuint texture, GLenum target, GLenum internalformat, GLuint buffer)) ldg_find("glTextureBufferEXT", lib);
	GL_CHECK(glp->TextureBufferEXT);
	glp->TextureBufferRangeEXT = (void APIENTRY (*)(GLuint texture, GLenum target, GLenum internalformat, GLuint buffer, GLintptr offset, GLsizeiptr size)) ldg_find("glTextureBufferRangeEXT", lib);
	GL_CHECK(glp->TextureBufferRangeEXT);
	glp->TextureFogSGIX = (void APIENTRY (*)(GLenum pname)) ldg_find("glTextureFogSGIX", lib);
	GL_CHECK(glp->TextureFogSGIX);
	glp->TextureImage1DEXT = (void APIENTRY (*)(GLuint texture, GLenum target, GLint level, GLenum internalformat, GLsizei width, GLint border, GLenum format, GLenum type, const void *pixels)) ldg_find("glTextureImage1DEXT", lib);
	GL_CHECK(glp->TextureImage1DEXT);
	glp->TextureImage2DEXT = (void APIENTRY (*)(GLuint texture, GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLint border, GLenum format, GLenum type, const void *pixels)) ldg_find("glTextureImage2DEXT", lib);
	GL_CHECK(glp->TextureImage2DEXT);
	glp->TextureImage2DMultisampleCoverageNV = (void APIENTRY (*)(GLuint texture, GLenum target, GLsizei coverageSamples, GLsizei colorSamples, GLint internalFormat, GLsizei width, GLsizei height, GLboolean32 fixedSampleLocations)) ldg_find("glTextureImage2DMultisampleCoverageNV", lib);
	GL_CHECK(glp->TextureImage2DMultisampleCoverageNV);
	glp->TextureImage2DMultisampleNV = (void APIENTRY (*)(GLuint texture, GLenum target, GLsizei samples, GLint internalFormat, GLsizei width, GLsizei height, GLboolean32 fixedSampleLocations)) ldg_find("glTextureImage2DMultisampleNV", lib);
	GL_CHECK(glp->TextureImage2DMultisampleNV);
	glp->TextureImage3DEXT = (void APIENTRY (*)(GLuint texture, GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLenum format, GLenum type, const void *pixels)) ldg_find("glTextureImage3DEXT", lib);
	GL_CHECK(glp->TextureImage3DEXT);
	glp->TextureImage3DMultisampleCoverageNV = (void APIENTRY (*)(GLuint texture, GLenum target, GLsizei coverageSamples, GLsizei colorSamples, GLint internalFormat, GLsizei width, GLsizei height, GLsizei depth, GLboolean32 fixedSampleLocations)) ldg_find("glTextureImage3DMultisampleCoverageNV", lib);
	GL_CHECK(glp->TextureImage3DMultisampleCoverageNV);
	glp->TextureImage3DMultisampleNV = (void APIENTRY (*)(GLuint texture, GLenum target, GLsizei samples, GLint internalFormat, GLsizei width, GLsizei height, GLsizei depth, GLboolean32 fixedSampleLocations)) ldg_find("glTextureImage3DMultisampleNV", lib);
	GL_CHECK(glp->TextureImage3DMultisampleNV);
	glp->TexturePageCommitmentEXT = (void APIENTRY (*)(GLuint texture, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLboolean32 commit)) ldg_find("glTexturePageCommitmentEXT", lib);
	GL_CHECK(glp->TexturePageCommitmentEXT);
	glp->TextureParameterIivEXT = (void APIENTRY (*)(GLuint texture, GLenum target, GLenum pname, const GLint *params)) ldg_find("glTextureParameterIivEXT", lib);
	GL_CHECK(glp->TextureParameterIivEXT);
	glp->TextureParameterIuivEXT = (void APIENTRY (*)(GLuint texture, GLenum target, GLenum pname, const GLuint *params)) ldg_find("glTextureParameterIuivEXT", lib);
	GL_CHECK(glp->TextureParameterIuivEXT);
	glp->TextureParameterfEXT = (void APIENTRY (*)(GLuint texture, GLenum target, GLenum pname, GLfloat param)) ldg_find("glTextureParameterfEXT", lib);
	GL_CHECK(glp->TextureParameterfEXT);
	glp->TextureParameterfvEXT = (void APIENTRY (*)(GLuint texture, GLenum target, GLenum pname, const GLfloat *params)) ldg_find("glTextureParameterfvEXT", lib);
	GL_CHECK(glp->TextureParameterfvEXT);
	glp->TextureParameteriEXT = (void APIENTRY (*)(GLuint texture, GLenum target, GLenum pname, GLint param)) ldg_find("glTextureParameteriEXT", lib);
	GL_CHECK(glp->TextureParameteriEXT);
	glp->TextureParameterivEXT = (void APIENTRY (*)(GLuint texture, GLenum target, GLenum pname, const GLint *params)) ldg_find("glTextureParameterivEXT", lib);
	GL_CHECK(glp->TextureParameterivEXT);
	glp->TextureRangeAPPLE = (void APIENTRY (*)(GLenum target, GLsizei length, const void *pointer)) ldg_find("glTextureRangeAPPLE", lib);
	GL_CHECK(glp->TextureRangeAPPLE);
	glp->TextureRenderbufferEXT = (void APIENTRY (*)(GLuint texture, GLenum target, GLuint renderbuffer)) ldg_find("glTextureRenderbufferEXT", lib);
	GL_CHECK(glp->TextureRenderbufferEXT);
	glp->TextureStorage1DEXT = (void APIENTRY (*)(GLuint texture, GLenum target, GLsizei levels, GLenum internalformat, GLsizei width)) ldg_find("glTextureStorage1DEXT", lib);
	GL_CHECK(glp->TextureStorage1DEXT);
	glp->TextureStorage2DEXT = (void APIENTRY (*)(GLuint texture, GLenum target, GLsizei levels, GLenum internalformat, GLsizei width, GLsizei height)) ldg_find("glTextureStorage2DEXT", lib);
	GL_CHECK(glp->TextureStorage2DEXT);
	glp->TextureStorage2DMultisampleEXT = (void APIENTRY (*)(GLuint texture, GLenum target, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height, GLboolean32 fixedsamplelocations)) ldg_find("glTextureStorage2DMultisampleEXT", lib);
	GL_CHECK(glp->TextureStorage2DMultisampleEXT);
	glp->TextureStorage3DEXT = (void APIENTRY (*)(GLuint texture, GLenum target, GLsizei levels, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth)) ldg_find("glTextureStorage3DEXT", lib);
	GL_CHECK(glp->TextureStorage3DEXT);
	glp->TextureStorage3DMultisampleEXT = (void APIENTRY (*)(GLuint texture, GLenum target, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, GLboolean32 fixedsamplelocations)) ldg_find("glTextureStorage3DMultisampleEXT", lib);
	GL_CHECK(glp->TextureStorage3DMultisampleEXT);
	glp->TextureStorageSparseAMD = (void APIENTRY (*)(GLuint texture, GLenum target, GLenum internalFormat, GLsizei width, GLsizei height, GLsizei depth, GLsizei layers, GLbitfield flags)) ldg_find("glTextureStorageSparseAMD", lib);
	GL_CHECK(glp->TextureStorageSparseAMD);
	glp->TextureSubImage1DEXT = (void APIENTRY (*)(GLuint texture, GLenum target, GLint level, GLint xoffset, GLsizei width, GLenum format, GLenum type, const void *pixels)) ldg_find("glTextureSubImage1DEXT", lib);
	GL_CHECK(glp->TextureSubImage1DEXT);
	glp->TextureSubImage2DEXT = (void APIENTRY (*)(GLuint texture, GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLenum type, const void *pixels)) ldg_find("glTextureSubImage2DEXT", lib);
	GL_CHECK(glp->TextureSubImage2DEXT);
	glp->TextureSubImage3DEXT = (void APIENTRY (*)(GLuint texture, GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLenum type, const void *pixels)) ldg_find("glTextureSubImage3DEXT", lib);
	GL_CHECK(glp->TextureSubImage3DEXT);
	glp->TextureView = (void APIENTRY (*)(GLuint texture, GLenum target, GLuint origtexture, GLenum internalformat, GLuint minlevel, GLuint numlevels, GLuint minlayer, GLuint numlayers)) ldg_find("glTextureView", lib);
	GL_CHECK(glp->TextureView);
	glp->TransformFeedbackAttribsNV = (void APIENTRY (*)(GLsizei count, const GLint *attribs, GLenum bufferMode)) ldg_find("glTransformFeedbackAttribsNV", lib);
	GL_CHECK(glp->TransformFeedbackAttribsNV);
	glp->TransformFeedbackStreamAttribsNV = (void APIENTRY (*)(GLsizei count, const GLint *attribs, GLsizei nbuffers, const GLint *bufstreams, GLenum bufferMode)) ldg_find("glTransformFeedbackStreamAttribsNV", lib);
	GL_CHECK(glp->TransformFeedbackStreamAttribsNV);
	glp->TransformFeedbackVaryings = (void APIENTRY (*)(GLuint program, GLsizei count, const GLchar *const *varyings, GLenum bufferMode)) ldg_find("glTransformFeedbackVaryings", lib);
	GL_CHECK(glp->TransformFeedbackVaryings);
	glp->TransformFeedbackVaryingsEXT = (void APIENTRY (*)(GLuint program, GLsizei count, const GLchar *const *varyings, GLenum bufferMode)) ldg_find("glTransformFeedbackVaryingsEXT", lib);
	GL_CHECK(glp->TransformFeedbackVaryingsEXT);
	glp->TransformFeedbackVaryingsNV = (void APIENTRY (*)(GLuint program, GLsizei count, const GLint *locations, GLenum bufferMode)) ldg_find("glTransformFeedbackVaryingsNV", lib);
	GL_CHECK(glp->TransformFeedbackVaryingsNV);
	glp->TransformPathNV = (void APIENTRY (*)(GLuint resultPath, GLuint srcPath, GLenum transformType, const GLfloat *transformValues)) ldg_find("glTransformPathNV", lib);
	GL_CHECK(glp->TransformPathNV);
	glp->TranslatexOES = (void APIENTRY (*)(GLfixed x, GLfixed y, GLfixed z)) ldg_find("glTranslatexOES", lib);
	GL_CHECK(glp->TranslatexOES);
	glp->Uniform1d = (void APIENTRY (*)(GLint location, GLdouble x)) ldg_find("glUniform1d", lib);
	GL_CHECK(glp->Uniform1d);
	glp->Uniform1dv = (void APIENTRY (*)(GLint location, GLsizei count, const GLdouble *value)) ldg_find("glUniform1dv", lib);
	GL_CHECK(glp->Uniform1dv);
	glp->Uniform1f = (void APIENTRY (*)(GLint location, GLfloat v0)) ldg_find("glUniform1f", lib);
	GL_CHECK(glp->Uniform1f);
	glp->Uniform1fv = (void APIENTRY (*)(GLint location, GLsizei count, const GLfloat *value)) ldg_find("glUniform1fv", lib);
	GL_CHECK(glp->Uniform1fv);
	glp->Uniform1i = (void APIENTRY (*)(GLint location, GLint v0)) ldg_find("glUniform1i", lib);
	GL_CHECK(glp->Uniform1i);
	glp->Uniform1i64NV = (void APIENTRY (*)(GLint location, GLint64EXT x)) ldg_find("glUniform1i64NV", lib);
	GL_CHECK(glp->Uniform1i64NV);
	glp->Uniform1i64vNV = (void APIENTRY (*)(GLint location, GLsizei count, const GLint64EXT *value)) ldg_find("glUniform1i64vNV", lib);
	GL_CHECK(glp->Uniform1i64vNV);
	glp->Uniform1iv = (void APIENTRY (*)(GLint location, GLsizei count, const GLint *value)) ldg_find("glUniform1iv", lib);
	GL_CHECK(glp->Uniform1iv);
	glp->Uniform1ui = (void APIENTRY (*)(GLint location, GLuint v0)) ldg_find("glUniform1ui", lib);
	GL_CHECK(glp->Uniform1ui);
	glp->Uniform1ui64NV = (void APIENTRY (*)(GLint location, GLuint64EXT x)) ldg_find("glUniform1ui64NV", lib);
	GL_CHECK(glp->Uniform1ui64NV);
	glp->Uniform1ui64vNV = (void APIENTRY (*)(GLint location, GLsizei count, const GLuint64EXT *value)) ldg_find("glUniform1ui64vNV", lib);
	GL_CHECK(glp->Uniform1ui64vNV);
	glp->Uniform1uiEXT = (void APIENTRY (*)(GLint location, GLuint v0)) ldg_find("glUniform1uiEXT", lib);
	GL_CHECK(glp->Uniform1uiEXT);
	glp->Uniform1uiv = (void APIENTRY (*)(GLint location, GLsizei count, const GLuint *value)) ldg_find("glUniform1uiv", lib);
	GL_CHECK(glp->Uniform1uiv);
	glp->Uniform1uivEXT = (void APIENTRY (*)(GLint location, GLsizei count, const GLuint *value)) ldg_find("glUniform1uivEXT", lib);
	GL_CHECK(glp->Uniform1uivEXT);
	glp->Uniform2d = (void APIENTRY (*)(GLint location, GLdouble x, GLdouble y)) ldg_find("glUniform2d", lib);
	GL_CHECK(glp->Uniform2d);
	glp->Uniform2dv = (void APIENTRY (*)(GLint location, GLsizei count, const GLdouble *value)) ldg_find("glUniform2dv", lib);
	GL_CHECK(glp->Uniform2dv);
	glp->Uniform2f = (void APIENTRY (*)(GLint location, GLfloat v0, GLfloat v1)) ldg_find("glUniform2f", lib);
	GL_CHECK(glp->Uniform2f);
	glp->Uniform2fv = (void APIENTRY (*)(GLint location, GLsizei count, const GLfloat *value)) ldg_find("glUniform2fv", lib);
	GL_CHECK(glp->Uniform2fv);
	glp->Uniform2i = (void APIENTRY (*)(GLint location, GLint v0, GLint v1)) ldg_find("glUniform2i", lib);
	GL_CHECK(glp->Uniform2i);
	glp->Uniform2i64NV = (void APIENTRY (*)(GLint location, GLint64EXT x, GLint64EXT y)) ldg_find("glUniform2i64NV", lib);
	GL_CHECK(glp->Uniform2i64NV);
	glp->Uniform2i64vNV = (void APIENTRY (*)(GLint location, GLsizei count, const GLint64EXT *value)) ldg_find("glUniform2i64vNV", lib);
	GL_CHECK(glp->Uniform2i64vNV);
	glp->Uniform2iv = (void APIENTRY (*)(GLint location, GLsizei count, const GLint *value)) ldg_find("glUniform2iv", lib);
	GL_CHECK(glp->Uniform2iv);
	glp->Uniform2ui = (void APIENTRY (*)(GLint location, GLuint v0, GLuint v1)) ldg_find("glUniform2ui", lib);
	GL_CHECK(glp->Uniform2ui);
	glp->Uniform2ui64NV = (void APIENTRY (*)(GLint location, GLuint64EXT x, GLuint64EXT y)) ldg_find("glUniform2ui64NV", lib);
	GL_CHECK(glp->Uniform2ui64NV);
	glp->Uniform2ui64vNV = (void APIENTRY (*)(GLint location, GLsizei count, const GLuint64EXT *value)) ldg_find("glUniform2ui64vNV", lib);
	GL_CHECK(glp->Uniform2ui64vNV);
	glp->Uniform2uiEXT = (void APIENTRY (*)(GLint location, GLuint v0, GLuint v1)) ldg_find("glUniform2uiEXT", lib);
	GL_CHECK(glp->Uniform2uiEXT);
	glp->Uniform2uiv = (void APIENTRY (*)(GLint location, GLsizei count, const GLuint *value)) ldg_find("glUniform2uiv", lib);
	GL_CHECK(glp->Uniform2uiv);
	glp->Uniform2uivEXT = (void APIENTRY (*)(GLint location, GLsizei count, const GLuint *value)) ldg_find("glUniform2uivEXT", lib);
	GL_CHECK(glp->Uniform2uivEXT);
	glp->Uniform3d = (void APIENTRY (*)(GLint location, GLdouble x, GLdouble y, GLdouble z)) ldg_find("glUniform3d", lib);
	GL_CHECK(glp->Uniform3d);
	glp->Uniform3dv = (void APIENTRY (*)(GLint location, GLsizei count, const GLdouble *value)) ldg_find("glUniform3dv", lib);
	GL_CHECK(glp->Uniform3dv);
	glp->Uniform3f = (void APIENTRY (*)(GLint location, GLfloat v0, GLfloat v1, GLfloat v2)) ldg_find("glUniform3f", lib);
	GL_CHECK(glp->Uniform3f);
	glp->Uniform3fv = (void APIENTRY (*)(GLint location, GLsizei count, const GLfloat *value)) ldg_find("glUniform3fv", lib);
	GL_CHECK(glp->Uniform3fv);
	glp->Uniform3i = (void APIENTRY (*)(GLint location, GLint v0, GLint v1, GLint v2)) ldg_find("glUniform3i", lib);
	GL_CHECK(glp->Uniform3i);
	glp->Uniform3i64NV = (void APIENTRY (*)(GLint location, GLint64EXT x, GLint64EXT y, GLint64EXT z)) ldg_find("glUniform3i64NV", lib);
	GL_CHECK(glp->Uniform3i64NV);
	glp->Uniform3i64vNV = (void APIENTRY (*)(GLint location, GLsizei count, const GLint64EXT *value)) ldg_find("glUniform3i64vNV", lib);
	GL_CHECK(glp->Uniform3i64vNV);
	glp->Uniform3iv = (void APIENTRY (*)(GLint location, GLsizei count, const GLint *value)) ldg_find("glUniform3iv", lib);
	GL_CHECK(glp->Uniform3iv);
	glp->Uniform3ui = (void APIENTRY (*)(GLint location, GLuint v0, GLuint v1, GLuint v2)) ldg_find("glUniform3ui", lib);
	GL_CHECK(glp->Uniform3ui);
	glp->Uniform3ui64NV = (void APIENTRY (*)(GLint location, GLuint64EXT x, GLuint64EXT y, GLuint64EXT z)) ldg_find("glUniform3ui64NV", lib);
	GL_CHECK(glp->Uniform3ui64NV);
	glp->Uniform3ui64vNV = (void APIENTRY (*)(GLint location, GLsizei count, const GLuint64EXT *value)) ldg_find("glUniform3ui64vNV", lib);
	GL_CHECK(glp->Uniform3ui64vNV);
	glp->Uniform3uiEXT = (void APIENTRY (*)(GLint location, GLuint v0, GLuint v1, GLuint v2)) ldg_find("glUniform3uiEXT", lib);
	GL_CHECK(glp->Uniform3uiEXT);
	glp->Uniform3uiv = (void APIENTRY (*)(GLint location, GLsizei count, const GLuint *value)) ldg_find("glUniform3uiv", lib);
	GL_CHECK(glp->Uniform3uiv);
	glp->Uniform3uivEXT = (void APIENTRY (*)(GLint location, GLsizei count, const GLuint *value)) ldg_find("glUniform3uivEXT", lib);
	GL_CHECK(glp->Uniform3uivEXT);
	glp->Uniform4d = (void APIENTRY (*)(GLint location, GLdouble x, GLdouble y, GLdouble z, GLdouble w)) ldg_find("glUniform4d", lib);
	GL_CHECK(glp->Uniform4d);
	glp->Uniform4dv = (void APIENTRY (*)(GLint location, GLsizei count, const GLdouble *value)) ldg_find("glUniform4dv", lib);
	GL_CHECK(glp->Uniform4dv);
	glp->Uniform4f = (void APIENTRY (*)(GLint location, GLfloat v0, GLfloat v1, GLfloat v2, GLfloat v3)) ldg_find("glUniform4f", lib);
	GL_CHECK(glp->Uniform4f);
	glp->Uniform4fv = (void APIENTRY (*)(GLint location, GLsizei count, const GLfloat *value)) ldg_find("glUniform4fv", lib);
	GL_CHECK(glp->Uniform4fv);
	glp->Uniform4i = (void APIENTRY (*)(GLint location, GLint v0, GLint v1, GLint v2, GLint v3)) ldg_find("glUniform4i", lib);
	GL_CHECK(glp->Uniform4i);
	glp->Uniform4i64NV = (void APIENTRY (*)(GLint location, GLint64EXT x, GLint64EXT y, GLint64EXT z, GLint64EXT w)) ldg_find("glUniform4i64NV", lib);
	GL_CHECK(glp->Uniform4i64NV);
	glp->Uniform4i64vNV = (void APIENTRY (*)(GLint location, GLsizei count, const GLint64EXT *value)) ldg_find("glUniform4i64vNV", lib);
	GL_CHECK(glp->Uniform4i64vNV);
	glp->Uniform4iv = (void APIENTRY (*)(GLint location, GLsizei count, const GLint *value)) ldg_find("glUniform4iv", lib);
	GL_CHECK(glp->Uniform4iv);
	glp->Uniform4ui = (void APIENTRY (*)(GLint location, GLuint v0, GLuint v1, GLuint v2, GLuint v3)) ldg_find("glUniform4ui", lib);
	GL_CHECK(glp->Uniform4ui);
	glp->Uniform4ui64NV = (void APIENTRY (*)(GLint location, GLuint64EXT x, GLuint64EXT y, GLuint64EXT z, GLuint64EXT w)) ldg_find("glUniform4ui64NV", lib);
	GL_CHECK(glp->Uniform4ui64NV);
	glp->Uniform4ui64vNV = (void APIENTRY (*)(GLint location, GLsizei count, const GLuint64EXT *value)) ldg_find("glUniform4ui64vNV", lib);
	GL_CHECK(glp->Uniform4ui64vNV);
	glp->Uniform4uiEXT = (void APIENTRY (*)(GLint location, GLuint v0, GLuint v1, GLuint v2, GLuint v3)) ldg_find("glUniform4uiEXT", lib);
	GL_CHECK(glp->Uniform4uiEXT);
	glp->Uniform4uiv = (void APIENTRY (*)(GLint location, GLsizei count, const GLuint *value)) ldg_find("glUniform4uiv", lib);
	GL_CHECK(glp->Uniform4uiv);
	glp->Uniform4uivEXT = (void APIENTRY (*)(GLint location, GLsizei count, const GLuint *value)) ldg_find("glUniform4uivEXT", lib);
	GL_CHECK(glp->Uniform4uivEXT);
	glp->UniformBlockBinding = (void APIENTRY (*)(GLuint program, GLuint uniformBlockIndex, GLuint uniformBlockBinding)) ldg_find("glUniformBlockBinding", lib);
	GL_CHECK(glp->UniformBlockBinding);
	glp->UniformBufferEXT = (void APIENTRY (*)(GLuint program, GLint location, GLuint buffer)) ldg_find("glUniformBufferEXT", lib);
	GL_CHECK(glp->UniformBufferEXT);
	glp->UniformHandleui64ARB = (void APIENTRY (*)(GLint location, GLuint64 value)) ldg_find("glUniformHandleui64ARB", lib);
	GL_CHECK(glp->UniformHandleui64ARB);
	glp->UniformHandleui64NV = (void APIENTRY (*)(GLint location, GLuint64 value)) ldg_find("glUniformHandleui64NV", lib);
	GL_CHECK(glp->UniformHandleui64NV);
	glp->UniformHandleui64vARB = (void APIENTRY (*)(GLint location, GLsizei count, const GLuint64 *value)) ldg_find("glUniformHandleui64vARB", lib);
	GL_CHECK(glp->UniformHandleui64vARB);
	glp->UniformHandleui64vNV = (void APIENTRY (*)(GLint location, GLsizei count, const GLuint64 *value)) ldg_find("glUniformHandleui64vNV", lib);
	GL_CHECK(glp->UniformHandleui64vNV);
	glp->UniformMatrix2dv = (void APIENTRY (*)(GLint location, GLsizei count, GLboolean32 transpose, const GLdouble *value)) ldg_find("glUniformMatrix2dv", lib);
	GL_CHECK(glp->UniformMatrix2dv);
	glp->UniformMatrix2fv = (void APIENTRY (*)(GLint location, GLsizei count, GLboolean32 transpose, const GLfloat *value)) ldg_find("glUniformMatrix2fv", lib);
	GL_CHECK(glp->UniformMatrix2fv);
	glp->UniformMatrix2x3dv = (void APIENTRY (*)(GLint location, GLsizei count, GLboolean32 transpose, const GLdouble *value)) ldg_find("glUniformMatrix2x3dv", lib);
	GL_CHECK(glp->UniformMatrix2x3dv);
	glp->UniformMatrix2x3fv = (void APIENTRY (*)(GLint location, GLsizei count, GLboolean32 transpose, const GLfloat *value)) ldg_find("glUniformMatrix2x3fv", lib);
	GL_CHECK(glp->UniformMatrix2x3fv);
	glp->UniformMatrix2x4dv = (void APIENTRY (*)(GLint location, GLsizei count, GLboolean32 transpose, const GLdouble *value)) ldg_find("glUniformMatrix2x4dv", lib);
	GL_CHECK(glp->UniformMatrix2x4dv);
	glp->UniformMatrix2x4fv = (void APIENTRY (*)(GLint location, GLsizei count, GLboolean32 transpose, const GLfloat *value)) ldg_find("glUniformMatrix2x4fv", lib);
	GL_CHECK(glp->UniformMatrix2x4fv);
	glp->UniformMatrix3dv = (void APIENTRY (*)(GLint location, GLsizei count, GLboolean32 transpose, const GLdouble *value)) ldg_find("glUniformMatrix3dv", lib);
	GL_CHECK(glp->UniformMatrix3dv);
	glp->UniformMatrix3fv = (void APIENTRY (*)(GLint location, GLsizei count, GLboolean32 transpose, const GLfloat *value)) ldg_find("glUniformMatrix3fv", lib);
	GL_CHECK(glp->UniformMatrix3fv);
	glp->UniformMatrix3x2dv = (void APIENTRY (*)(GLint location, GLsizei count, GLboolean32 transpose, const GLdouble *value)) ldg_find("glUniformMatrix3x2dv", lib);
	GL_CHECK(glp->UniformMatrix3x2dv);
	glp->UniformMatrix3x2fv = (void APIENTRY (*)(GLint location, GLsizei count, GLboolean32 transpose, const GLfloat *value)) ldg_find("glUniformMatrix3x2fv", lib);
	GL_CHECK(glp->UniformMatrix3x2fv);
	glp->UniformMatrix3x4dv = (void APIENTRY (*)(GLint location, GLsizei count, GLboolean32 transpose, const GLdouble *value)) ldg_find("glUniformMatrix3x4dv", lib);
	GL_CHECK(glp->UniformMatrix3x4dv);
	glp->UniformMatrix3x4fv = (void APIENTRY (*)(GLint location, GLsizei count, GLboolean32 transpose, const GLfloat *value)) ldg_find("glUniformMatrix3x4fv", lib);
	GL_CHECK(glp->UniformMatrix3x4fv);
	glp->UniformMatrix4dv = (void APIENTRY (*)(GLint location, GLsizei count, GLboolean32 transpose, const GLdouble *value)) ldg_find("glUniformMatrix4dv", lib);
	GL_CHECK(glp->UniformMatrix4dv);
	glp->UniformMatrix4fv = (void APIENTRY (*)(GLint location, GLsizei count, GLboolean32 transpose, const GLfloat *value)) ldg_find("glUniformMatrix4fv", lib);
	GL_CHECK(glp->UniformMatrix4fv);
	glp->UniformMatrix4x2dv = (void APIENTRY (*)(GLint location, GLsizei count, GLboolean32 transpose, const GLdouble *value)) ldg_find("glUniformMatrix4x2dv", lib);
	GL_CHECK(glp->UniformMatrix4x2dv);
	glp->UniformMatrix4x2fv = (void APIENTRY (*)(GLint location, GLsizei count, GLboolean32 transpose, const GLfloat *value)) ldg_find("glUniformMatrix4x2fv", lib);
	GL_CHECK(glp->UniformMatrix4x2fv);
	glp->UniformMatrix4x3dv = (void APIENTRY (*)(GLint location, GLsizei count, GLboolean32 transpose, const GLdouble *value)) ldg_find("glUniformMatrix4x3dv", lib);
	GL_CHECK(glp->UniformMatrix4x3dv);
	glp->UniformMatrix4x3fv = (void APIENTRY (*)(GLint location, GLsizei count, GLboolean32 transpose, const GLfloat *value)) ldg_find("glUniformMatrix4x3fv", lib);
	GL_CHECK(glp->UniformMatrix4x3fv);
	glp->UniformSubroutinesuiv = (void APIENTRY (*)(GLenum shadertype, GLsizei count, const GLuint *indices)) ldg_find("glUniformSubroutinesuiv", lib);
	GL_CHECK(glp->UniformSubroutinesuiv);
	glp->Uniformui64NV = (void APIENTRY (*)(GLint location, GLuint64EXT value)) ldg_find("glUniformui64NV", lib);
	GL_CHECK(glp->Uniformui64NV);
	glp->Uniformui64vNV = (void APIENTRY (*)(GLint location, GLsizei count, const GLuint64EXT *value)) ldg_find("glUniformui64vNV", lib);
	GL_CHECK(glp->Uniformui64vNV);
	glp->UnmapNamedBufferEXT = (GLboolean APIENTRY (*)(GLuint buffer)) ldg_find("glUnmapNamedBufferEXT", lib);
	GL_CHECK(glp->UnmapNamedBufferEXT);
	glp->UnmapTexture2DINTEL = (void APIENTRY (*)(GLuint texture, GLint level)) ldg_find("glUnmapTexture2DINTEL", lib);
	GL_CHECK(glp->UnmapTexture2DINTEL);
	glp->UseProgram = (void APIENTRY (*)(GLuint program)) ldg_find("glUseProgram", lib);
	GL_CHECK(glp->UseProgram);
	glp->UseProgramStages = (void APIENTRY (*)(GLuint pipeline, GLbitfield stages, GLuint program)) ldg_find("glUseProgramStages", lib);
	GL_CHECK(glp->UseProgramStages);
	glp->UseShaderProgramEXT = (void APIENTRY (*)(GLenum type, GLuint program)) ldg_find("glUseShaderProgramEXT", lib);
	GL_CHECK(glp->UseShaderProgramEXT);
	glp->VDPAUFiniNV = (void APIENTRY (*)(void)) ldg_find("glVDPAUFiniNV", lib);
	GL_CHECK(glp->VDPAUFiniNV);
	glp->VDPAUGetSurfaceivNV = (void APIENTRY (*)(GLvdpauSurfaceNV surface, GLenum pname, GLsizei bufSize, GLsizei *length, GLint *values)) ldg_find("glVDPAUGetSurfaceivNV", lib);
	GL_CHECK(glp->VDPAUGetSurfaceivNV);
	glp->VDPAUInitNV = (void APIENTRY (*)(const void *vdpDevice, const void *getProcAddress)) ldg_find("glVDPAUInitNV", lib);
	GL_CHECK(glp->VDPAUInitNV);
	glp->VDPAUIsSurfaceNV = (GLboolean APIENTRY (*)(GLvdpauSurfaceNV surface)) ldg_find("glVDPAUIsSurfaceNV", lib);
	GL_CHECK(glp->VDPAUIsSurfaceNV);
	glp->VDPAUMapSurfacesNV = (void APIENTRY (*)(GLsizei numSurfaces, const GLvdpauSurfaceNV *surfaces)) ldg_find("glVDPAUMapSurfacesNV", lib);
	GL_CHECK(glp->VDPAUMapSurfacesNV);
	glp->VDPAURegisterOutputSurfaceNV = (GLvdpauSurfaceNV APIENTRY (*)(const void *vdpSurface, GLenum target, GLsizei numTextureNames, const GLuint *textureNames)) ldg_find("glVDPAURegisterOutputSurfaceNV", lib);
	GL_CHECK(glp->VDPAURegisterOutputSurfaceNV);
	glp->VDPAURegisterVideoSurfaceNV = (GLvdpauSurfaceNV APIENTRY (*)(const void *vdpSurface, GLenum target, GLsizei numTextureNames, const GLuint *textureNames)) ldg_find("glVDPAURegisterVideoSurfaceNV", lib);
	GL_CHECK(glp->VDPAURegisterVideoSurfaceNV);
	glp->VDPAUSurfaceAccessNV = (void APIENTRY (*)(GLvdpauSurfaceNV surface, GLenum access)) ldg_find("glVDPAUSurfaceAccessNV", lib);
	GL_CHECK(glp->VDPAUSurfaceAccessNV);
	glp->VDPAUUnmapSurfacesNV = (void APIENTRY (*)(GLsizei numSurface, const GLvdpauSurfaceNV *surfaces)) ldg_find("glVDPAUUnmapSurfacesNV", lib);
	GL_CHECK(glp->VDPAUUnmapSurfacesNV);
	glp->VDPAUUnregisterSurfaceNV = (void APIENTRY (*)(GLvdpauSurfaceNV surface)) ldg_find("glVDPAUUnregisterSurfaceNV", lib);
	GL_CHECK(glp->VDPAUUnregisterSurfaceNV);
	glp->ValidateProgram = (void APIENTRY (*)(GLuint program)) ldg_find("glValidateProgram", lib);
	GL_CHECK(glp->ValidateProgram);
	glp->ValidateProgramPipeline = (void APIENTRY (*)(GLuint pipeline)) ldg_find("glValidateProgramPipeline", lib);
	GL_CHECK(glp->ValidateProgramPipeline);
	glp->Vertex2bOES = (void APIENTRY (*)(GLbyte32 x, GLbyte32 y)) ldg_find("glVertex2bOES", lib);
	GL_CHECK(glp->Vertex2bOES);
	glp->Vertex2bvOES = (void APIENTRY (*)(const GLbyte *coords)) ldg_find("glVertex2bvOES", lib);
	GL_CHECK(glp->Vertex2bvOES);
	glp->Vertex2xOES = (void APIENTRY (*)(GLfixed x)) ldg_find("glVertex2xOES", lib);
	GL_CHECK(glp->Vertex2xOES);
	glp->Vertex2xvOES = (void APIENTRY (*)(const GLfixed *coords)) ldg_find("glVertex2xvOES", lib);
	GL_CHECK(glp->Vertex2xvOES);
	glp->Vertex3bOES = (void APIENTRY (*)(GLbyte32 x, GLbyte32 y, GLbyte32 z)) ldg_find("glVertex3bOES", lib);
	GL_CHECK(glp->Vertex3bOES);
	glp->Vertex3bvOES = (void APIENTRY (*)(const GLbyte *coords)) ldg_find("glVertex3bvOES", lib);
	GL_CHECK(glp->Vertex3bvOES);
	glp->Vertex3xOES = (void APIENTRY (*)(GLfixed x, GLfixed y)) ldg_find("glVertex3xOES", lib);
	GL_CHECK(glp->Vertex3xOES);
	glp->Vertex3xvOES = (void APIENTRY (*)(const GLfixed *coords)) ldg_find("glVertex3xvOES", lib);
	GL_CHECK(glp->Vertex3xvOES);
	glp->Vertex4bOES = (void APIENTRY (*)(GLbyte32 x, GLbyte32 y, GLbyte32 z, GLbyte32 w)) ldg_find("glVertex4bOES", lib);
	GL_CHECK(glp->Vertex4bOES);
	glp->Vertex4bvOES = (void APIENTRY (*)(const GLbyte *coords)) ldg_find("glVertex4bvOES", lib);
	GL_CHECK(glp->Vertex4bvOES);
	glp->Vertex4xOES = (void APIENTRY (*)(GLfixed x, GLfixed y, GLfixed z)) ldg_find("glVertex4xOES", lib);
	GL_CHECK(glp->Vertex4xOES);
	glp->Vertex4xvOES = (void APIENTRY (*)(const GLfixed *coords)) ldg_find("glVertex4xvOES", lib);
	GL_CHECK(glp->Vertex4xvOES);
	glp->VertexArrayBindVertexBufferEXT = (void APIENTRY (*)(GLuint vaobj, GLuint bindingindex, GLuint buffer, GLintptr offset, GLsizei stride)) ldg_find("glVertexArrayBindVertexBufferEXT", lib);
	GL_CHECK(glp->VertexArrayBindVertexBufferEXT);
	glp->VertexArrayColorOffsetEXT = (void APIENTRY (*)(GLuint vaobj, GLuint buffer, GLint size, GLenum type, GLsizei stride, GLintptr offset)) ldg_find("glVertexArrayColorOffsetEXT", lib);
	GL_CHECK(glp->VertexArrayColorOffsetEXT);
	glp->VertexArrayEdgeFlagOffsetEXT = (void APIENTRY (*)(GLuint vaobj, GLuint buffer, GLsizei stride, GLintptr offset)) ldg_find("glVertexArrayEdgeFlagOffsetEXT", lib);
	GL_CHECK(glp->VertexArrayEdgeFlagOffsetEXT);
	glp->VertexArrayFogCoordOffsetEXT = (void APIENTRY (*)(GLuint vaobj, GLuint buffer, GLenum type, GLsizei stride, GLintptr offset)) ldg_find("glVertexArrayFogCoordOffsetEXT", lib);
	GL_CHECK(glp->VertexArrayFogCoordOffsetEXT);
	glp->VertexArrayIndexOffsetEXT = (void APIENTRY (*)(GLuint vaobj, GLuint buffer, GLenum type, GLsizei stride, GLintptr offset)) ldg_find("glVertexArrayIndexOffsetEXT", lib);
	GL_CHECK(glp->VertexArrayIndexOffsetEXT);
	glp->VertexArrayMultiTexCoordOffsetEXT = (void APIENTRY (*)(GLuint vaobj, GLuint buffer, GLenum texunit, GLint size, GLenum type, GLsizei stride, GLintptr offset)) ldg_find("glVertexArrayMultiTexCoordOffsetEXT", lib);
	GL_CHECK(glp->VertexArrayMultiTexCoordOffsetEXT);
	glp->VertexArrayNormalOffsetEXT = (void APIENTRY (*)(GLuint vaobj, GLuint buffer, GLenum type, GLsizei stride, GLintptr offset)) ldg_find("glVertexArrayNormalOffsetEXT", lib);
	GL_CHECK(glp->VertexArrayNormalOffsetEXT);
	glp->VertexArraySecondaryColorOffsetEXT = (void APIENTRY (*)(GLuint vaobj, GLuint buffer, GLint size, GLenum type, GLsizei stride, GLintptr offset)) ldg_find("glVertexArraySecondaryColorOffsetEXT", lib);
	GL_CHECK(glp->VertexArraySecondaryColorOffsetEXT);
	glp->VertexArrayTexCoordOffsetEXT = (void APIENTRY (*)(GLuint vaobj, GLuint buffer, GLint size, GLenum type, GLsizei stride, GLintptr offset)) ldg_find("glVertexArrayTexCoordOffsetEXT", lib);
	GL_CHECK(glp->VertexArrayTexCoordOffsetEXT);
	glp->VertexArrayVertexAttribBindingEXT = (void APIENTRY (*)(GLuint vaobj, GLuint attribindex, GLuint bindingindex)) ldg_find("glVertexArrayVertexAttribBindingEXT", lib);
	GL_CHECK(glp->VertexArrayVertexAttribBindingEXT);
	glp->VertexArrayVertexAttribDivisorEXT = (void APIENTRY (*)(GLuint vaobj, GLuint index, GLuint divisor)) ldg_find("glVertexArrayVertexAttribDivisorEXT", lib);
	GL_CHECK(glp->VertexArrayVertexAttribDivisorEXT);
	glp->VertexArrayVertexAttribFormatEXT = (void APIENTRY (*)(GLuint vaobj, GLuint attribindex, GLint size, GLenum type, GLboolean32 normalized, GLuint relativeoffset)) ldg_find("glVertexArrayVertexAttribFormatEXT", lib);
	GL_CHECK(glp->VertexArrayVertexAttribFormatEXT);
	glp->VertexArrayVertexAttribIFormatEXT = (void APIENTRY (*)(GLuint vaobj, GLuint attribindex, GLint size, GLenum type, GLuint relativeoffset)) ldg_find("glVertexArrayVertexAttribIFormatEXT", lib);
	GL_CHECK(glp->VertexArrayVertexAttribIFormatEXT);
	glp->VertexArrayVertexAttribIOffsetEXT = (void APIENTRY (*)(GLuint vaobj, GLuint buffer, GLuint index, GLint size, GLenum type, GLsizei stride, GLintptr offset)) ldg_find("glVertexArrayVertexAttribIOffsetEXT", lib);
	GL_CHECK(glp->VertexArrayVertexAttribIOffsetEXT);
	glp->VertexArrayVertexAttribLFormatEXT = (void APIENTRY (*)(GLuint vaobj, GLuint attribindex, GLint size, GLenum type, GLuint relativeoffset)) ldg_find("glVertexArrayVertexAttribLFormatEXT", lib);
	GL_CHECK(glp->VertexArrayVertexAttribLFormatEXT);
	glp->VertexArrayVertexAttribLOffsetEXT = (void APIENTRY (*)(GLuint vaobj, GLuint buffer, GLuint index, GLint size, GLenum type, GLsizei stride, GLintptr offset)) ldg_find("glVertexArrayVertexAttribLOffsetEXT", lib);
	GL_CHECK(glp->VertexArrayVertexAttribLOffsetEXT);
	glp->VertexArrayVertexAttribOffsetEXT = (void APIENTRY (*)(GLuint vaobj, GLuint buffer, GLuint index, GLint size, GLenum type, GLboolean32 normalized, GLsizei stride, GLintptr offset)) ldg_find("glVertexArrayVertexAttribOffsetEXT", lib);
	GL_CHECK(glp->VertexArrayVertexAttribOffsetEXT);
	glp->VertexArrayVertexBindingDivisorEXT = (void APIENTRY (*)(GLuint vaobj, GLuint bindingindex, GLuint divisor)) ldg_find("glVertexArrayVertexBindingDivisorEXT", lib);
	GL_CHECK(glp->VertexArrayVertexBindingDivisorEXT);
	glp->VertexArrayVertexOffsetEXT = (void APIENTRY (*)(GLuint vaobj, GLuint buffer, GLint size, GLenum type, GLsizei stride, GLintptr offset)) ldg_find("glVertexArrayVertexOffsetEXT", lib);
	GL_CHECK(glp->VertexArrayVertexOffsetEXT);
	glp->VertexAttrib1d = (void APIENTRY (*)(GLuint index, GLdouble x)) ldg_find("glVertexAttrib1d", lib);
	GL_CHECK(glp->VertexAttrib1d);
	glp->VertexAttrib1dv = (void APIENTRY (*)(GLuint index, const GLdouble *v)) ldg_find("glVertexAttrib1dv", lib);
	GL_CHECK(glp->VertexAttrib1dv);
	glp->VertexAttrib1f = (void APIENTRY (*)(GLuint index, GLfloat x)) ldg_find("glVertexAttrib1f", lib);
	GL_CHECK(glp->VertexAttrib1f);
	glp->VertexAttrib1fv = (void APIENTRY (*)(GLuint index, const GLfloat *v)) ldg_find("glVertexAttrib1fv", lib);
	GL_CHECK(glp->VertexAttrib1fv);
	glp->VertexAttrib1s = (void APIENTRY (*)(GLuint index, GLshort32 x)) ldg_find("glVertexAttrib1s", lib);
	GL_CHECK(glp->VertexAttrib1s);
	glp->VertexAttrib1sv = (void APIENTRY (*)(GLuint index, const GLshort *v)) ldg_find("glVertexAttrib1sv", lib);
	GL_CHECK(glp->VertexAttrib1sv);
	glp->VertexAttrib2d = (void APIENTRY (*)(GLuint index, GLdouble x, GLdouble y)) ldg_find("glVertexAttrib2d", lib);
	GL_CHECK(glp->VertexAttrib2d);
	glp->VertexAttrib2dv = (void APIENTRY (*)(GLuint index, const GLdouble *v)) ldg_find("glVertexAttrib2dv", lib);
	GL_CHECK(glp->VertexAttrib2dv);
	glp->VertexAttrib2f = (void APIENTRY (*)(GLuint index, GLfloat x, GLfloat y)) ldg_find("glVertexAttrib2f", lib);
	GL_CHECK(glp->VertexAttrib2f);
	glp->VertexAttrib2fv = (void APIENTRY (*)(GLuint index, const GLfloat *v)) ldg_find("glVertexAttrib2fv", lib);
	GL_CHECK(glp->VertexAttrib2fv);
	glp->VertexAttrib2s = (void APIENTRY (*)(GLuint index, GLshort32 x, GLshort32 y)) ldg_find("glVertexAttrib2s", lib);
	GL_CHECK(glp->VertexAttrib2s);
	glp->VertexAttrib2sv = (void APIENTRY (*)(GLuint index, const GLshort *v)) ldg_find("glVertexAttrib2sv", lib);
	GL_CHECK(glp->VertexAttrib2sv);
	glp->VertexAttrib3d = (void APIENTRY (*)(GLuint index, GLdouble x, GLdouble y, GLdouble z)) ldg_find("glVertexAttrib3d", lib);
	GL_CHECK(glp->VertexAttrib3d);
	glp->VertexAttrib3dv = (void APIENTRY (*)(GLuint index, const GLdouble *v)) ldg_find("glVertexAttrib3dv", lib);
	GL_CHECK(glp->VertexAttrib3dv);
	glp->VertexAttrib3f = (void APIENTRY (*)(GLuint index, GLfloat x, GLfloat y, GLfloat z)) ldg_find("glVertexAttrib3f", lib);
	GL_CHECK(glp->VertexAttrib3f);
	glp->VertexAttrib3fv = (void APIENTRY (*)(GLuint index, const GLfloat *v)) ldg_find("glVertexAttrib3fv", lib);
	GL_CHECK(glp->VertexAttrib3fv);
	glp->VertexAttrib3s = (void APIENTRY (*)(GLuint index, GLshort32 x, GLshort32 y, GLshort32 z)) ldg_find("glVertexAttrib3s", lib);
	GL_CHECK(glp->VertexAttrib3s);
	glp->VertexAttrib3sv = (void APIENTRY (*)(GLuint index, const GLshort *v)) ldg_find("glVertexAttrib3sv", lib);
	GL_CHECK(glp->VertexAttrib3sv);
	glp->VertexAttrib4Nbv = (void APIENTRY (*)(GLuint index, const GLbyte *v)) ldg_find("glVertexAttrib4Nbv", lib);
	GL_CHECK(glp->VertexAttrib4Nbv);
	glp->VertexAttrib4Niv = (void APIENTRY (*)(GLuint index, const GLint *v)) ldg_find("glVertexAttrib4Niv", lib);
	GL_CHECK(glp->VertexAttrib4Niv);
	glp->VertexAttrib4Nsv = (void APIENTRY (*)(GLuint index, const GLshort *v)) ldg_find("glVertexAttrib4Nsv", lib);
	GL_CHECK(glp->VertexAttrib4Nsv);
	glp->VertexAttrib4Nub = (void APIENTRY (*)(GLuint index, GLubyte32 x, GLubyte32 y, GLubyte32 z, GLubyte32 w)) ldg_find("glVertexAttrib4Nub", lib);
	GL_CHECK(glp->VertexAttrib4Nub);
	glp->VertexAttrib4Nubv = (void APIENTRY (*)(GLuint index, const GLubyte *v)) ldg_find("glVertexAttrib4Nubv", lib);
	GL_CHECK(glp->VertexAttrib4Nubv);
	glp->VertexAttrib4Nuiv = (void APIENTRY (*)(GLuint index, const GLuint *v)) ldg_find("glVertexAttrib4Nuiv", lib);
	GL_CHECK(glp->VertexAttrib4Nuiv);
	glp->VertexAttrib4Nusv = (void APIENTRY (*)(GLuint index, const GLushort *v)) ldg_find("glVertexAttrib4Nusv", lib);
	GL_CHECK(glp->VertexAttrib4Nusv);
	glp->VertexAttrib4bv = (void APIENTRY (*)(GLuint index, const GLbyte *v)) ldg_find("glVertexAttrib4bv", lib);
	GL_CHECK(glp->VertexAttrib4bv);
	glp->VertexAttrib4d = (void APIENTRY (*)(GLuint index, GLdouble x, GLdouble y, GLdouble z, GLdouble w)) ldg_find("glVertexAttrib4d", lib);
	GL_CHECK(glp->VertexAttrib4d);
	glp->VertexAttrib4dv = (void APIENTRY (*)(GLuint index, const GLdouble *v)) ldg_find("glVertexAttrib4dv", lib);
	GL_CHECK(glp->VertexAttrib4dv);
	glp->VertexAttrib4f = (void APIENTRY (*)(GLuint index, GLfloat x, GLfloat y, GLfloat z, GLfloat w)) ldg_find("glVertexAttrib4f", lib);
	GL_CHECK(glp->VertexAttrib4f);
	glp->VertexAttrib4fv = (void APIENTRY (*)(GLuint index, const GLfloat *v)) ldg_find("glVertexAttrib4fv", lib);
	GL_CHECK(glp->VertexAttrib4fv);
	glp->VertexAttrib4iv = (void APIENTRY (*)(GLuint index, const GLint *v)) ldg_find("glVertexAttrib4iv", lib);
	GL_CHECK(glp->VertexAttrib4iv);
	glp->VertexAttrib4s = (void APIENTRY (*)(GLuint index, GLshort32 x, GLshort32 y, GLshort32 z, GLshort32 w)) ldg_find("glVertexAttrib4s", lib);
	GL_CHECK(glp->VertexAttrib4s);
	glp->VertexAttrib4sv = (void APIENTRY (*)(GLuint index, const GLshort *v)) ldg_find("glVertexAttrib4sv", lib);
	GL_CHECK(glp->VertexAttrib4sv);
	glp->VertexAttrib4ubv = (void APIENTRY (*)(GLuint index, const GLubyte *v)) ldg_find("glVertexAttrib4ubv", lib);
	GL_CHECK(glp->VertexAttrib4ubv);
	glp->VertexAttrib4uiv = (void APIENTRY (*)(GLuint index, const GLuint *v)) ldg_find("glVertexAttrib4uiv", lib);
	GL_CHECK(glp->VertexAttrib4uiv);
	glp->VertexAttrib4usv = (void APIENTRY (*)(GLuint index, const GLushort *v)) ldg_find("glVertexAttrib4usv", lib);
	GL_CHECK(glp->VertexAttrib4usv);
	glp->VertexAttribBinding = (void APIENTRY (*)(GLuint attribindex, GLuint bindingindex)) ldg_find("glVertexAttribBinding", lib);
	GL_CHECK(glp->VertexAttribBinding);
	glp->VertexAttribDivisor = (void APIENTRY (*)(GLuint index, GLuint divisor)) ldg_find("glVertexAttribDivisor", lib);
	GL_CHECK(glp->VertexAttribDivisor);
	glp->VertexAttribDivisorARB = (void APIENTRY (*)(GLuint index, GLuint divisor)) ldg_find("glVertexAttribDivisorARB", lib);
	GL_CHECK(glp->VertexAttribDivisorARB);
	glp->VertexAttribFormat = (void APIENTRY (*)(GLuint attribindex, GLint size, GLenum type, GLboolean32 normalized, GLuint relativeoffset)) ldg_find("glVertexAttribFormat", lib);
	GL_CHECK(glp->VertexAttribFormat);
	glp->VertexAttribFormatNV = (void APIENTRY (*)(GLuint index, GLint size, GLenum type, GLboolean32 normalized, GLsizei stride)) ldg_find("glVertexAttribFormatNV", lib);
	GL_CHECK(glp->VertexAttribFormatNV);
	glp->VertexAttribI1i = (void APIENTRY (*)(GLuint index, GLint x)) ldg_find("glVertexAttribI1i", lib);
	GL_CHECK(glp->VertexAttribI1i);
	glp->VertexAttribI1iEXT = (void APIENTRY (*)(GLuint index, GLint x)) ldg_find("glVertexAttribI1iEXT", lib);
	GL_CHECK(glp->VertexAttribI1iEXT);
	glp->VertexAttribI1iv = (void APIENTRY (*)(GLuint index, const GLint *v)) ldg_find("glVertexAttribI1iv", lib);
	GL_CHECK(glp->VertexAttribI1iv);
	glp->VertexAttribI1ivEXT = (void APIENTRY (*)(GLuint index, const GLint *v)) ldg_find("glVertexAttribI1ivEXT", lib);
	GL_CHECK(glp->VertexAttribI1ivEXT);
	glp->VertexAttribI1ui = (void APIENTRY (*)(GLuint index, GLuint x)) ldg_find("glVertexAttribI1ui", lib);
	GL_CHECK(glp->VertexAttribI1ui);
	glp->VertexAttribI1uiEXT = (void APIENTRY (*)(GLuint index, GLuint x)) ldg_find("glVertexAttribI1uiEXT", lib);
	GL_CHECK(glp->VertexAttribI1uiEXT);
	glp->VertexAttribI1uiv = (void APIENTRY (*)(GLuint index, const GLuint *v)) ldg_find("glVertexAttribI1uiv", lib);
	GL_CHECK(glp->VertexAttribI1uiv);
	glp->VertexAttribI1uivEXT = (void APIENTRY (*)(GLuint index, const GLuint *v)) ldg_find("glVertexAttribI1uivEXT", lib);
	GL_CHECK(glp->VertexAttribI1uivEXT);
	glp->VertexAttribI2i = (void APIENTRY (*)(GLuint index, GLint x, GLint y)) ldg_find("glVertexAttribI2i", lib);
	GL_CHECK(glp->VertexAttribI2i);
	glp->VertexAttribI2iEXT = (void APIENTRY (*)(GLuint index, GLint x, GLint y)) ldg_find("glVertexAttribI2iEXT", lib);
	GL_CHECK(glp->VertexAttribI2iEXT);
	glp->VertexAttribI2iv = (void APIENTRY (*)(GLuint index, const GLint *v)) ldg_find("glVertexAttribI2iv", lib);
	GL_CHECK(glp->VertexAttribI2iv);
	glp->VertexAttribI2ivEXT = (void APIENTRY (*)(GLuint index, const GLint *v)) ldg_find("glVertexAttribI2ivEXT", lib);
	GL_CHECK(glp->VertexAttribI2ivEXT);
	glp->VertexAttribI2ui = (void APIENTRY (*)(GLuint index, GLuint x, GLuint y)) ldg_find("glVertexAttribI2ui", lib);
	GL_CHECK(glp->VertexAttribI2ui);
	glp->VertexAttribI2uiEXT = (void APIENTRY (*)(GLuint index, GLuint x, GLuint y)) ldg_find("glVertexAttribI2uiEXT", lib);
	GL_CHECK(glp->VertexAttribI2uiEXT);
	glp->VertexAttribI2uiv = (void APIENTRY (*)(GLuint index, const GLuint *v)) ldg_find("glVertexAttribI2uiv", lib);
	GL_CHECK(glp->VertexAttribI2uiv);
	glp->VertexAttribI2uivEXT = (void APIENTRY (*)(GLuint index, const GLuint *v)) ldg_find("glVertexAttribI2uivEXT", lib);
	GL_CHECK(glp->VertexAttribI2uivEXT);
	glp->VertexAttribI3i = (void APIENTRY (*)(GLuint index, GLint x, GLint y, GLint z)) ldg_find("glVertexAttribI3i", lib);
	GL_CHECK(glp->VertexAttribI3i);
	glp->VertexAttribI3iEXT = (void APIENTRY (*)(GLuint index, GLint x, GLint y, GLint z)) ldg_find("glVertexAttribI3iEXT", lib);
	GL_CHECK(glp->VertexAttribI3iEXT);
	glp->VertexAttribI3iv = (void APIENTRY (*)(GLuint index, const GLint *v)) ldg_find("glVertexAttribI3iv", lib);
	GL_CHECK(glp->VertexAttribI3iv);
	glp->VertexAttribI3ivEXT = (void APIENTRY (*)(GLuint index, const GLint *v)) ldg_find("glVertexAttribI3ivEXT", lib);
	GL_CHECK(glp->VertexAttribI3ivEXT);
	glp->VertexAttribI3ui = (void APIENTRY (*)(GLuint index, GLuint x, GLuint y, GLuint z)) ldg_find("glVertexAttribI3ui", lib);
	GL_CHECK(glp->VertexAttribI3ui);
	glp->VertexAttribI3uiEXT = (void APIENTRY (*)(GLuint index, GLuint x, GLuint y, GLuint z)) ldg_find("glVertexAttribI3uiEXT", lib);
	GL_CHECK(glp->VertexAttribI3uiEXT);
	glp->VertexAttribI3uiv = (void APIENTRY (*)(GLuint index, const GLuint *v)) ldg_find("glVertexAttribI3uiv", lib);
	GL_CHECK(glp->VertexAttribI3uiv);
	glp->VertexAttribI3uivEXT = (void APIENTRY (*)(GLuint index, const GLuint *v)) ldg_find("glVertexAttribI3uivEXT", lib);
	GL_CHECK(glp->VertexAttribI3uivEXT);
	glp->VertexAttribI4bv = (void APIENTRY (*)(GLuint index, const GLbyte *v)) ldg_find("glVertexAttribI4bv", lib);
	GL_CHECK(glp->VertexAttribI4bv);
	glp->VertexAttribI4bvEXT = (void APIENTRY (*)(GLuint index, const GLbyte *v)) ldg_find("glVertexAttribI4bvEXT", lib);
	GL_CHECK(glp->VertexAttribI4bvEXT);
	glp->VertexAttribI4i = (void APIENTRY (*)(GLuint index, GLint x, GLint y, GLint z, GLint w)) ldg_find("glVertexAttribI4i", lib);
	GL_CHECK(glp->VertexAttribI4i);
	glp->VertexAttribI4iEXT = (void APIENTRY (*)(GLuint index, GLint x, GLint y, GLint z, GLint w)) ldg_find("glVertexAttribI4iEXT", lib);
	GL_CHECK(glp->VertexAttribI4iEXT);
	glp->VertexAttribI4iv = (void APIENTRY (*)(GLuint index, const GLint *v)) ldg_find("glVertexAttribI4iv", lib);
	GL_CHECK(glp->VertexAttribI4iv);
	glp->VertexAttribI4ivEXT = (void APIENTRY (*)(GLuint index, const GLint *v)) ldg_find("glVertexAttribI4ivEXT", lib);
	GL_CHECK(glp->VertexAttribI4ivEXT);
	glp->VertexAttribI4sv = (void APIENTRY (*)(GLuint index, const GLshort *v)) ldg_find("glVertexAttribI4sv", lib);
	GL_CHECK(glp->VertexAttribI4sv);
	glp->VertexAttribI4svEXT = (void APIENTRY (*)(GLuint index, const GLshort *v)) ldg_find("glVertexAttribI4svEXT", lib);
	GL_CHECK(glp->VertexAttribI4svEXT);
	glp->VertexAttribI4ubv = (void APIENTRY (*)(GLuint index, const GLubyte *v)) ldg_find("glVertexAttribI4ubv", lib);
	GL_CHECK(glp->VertexAttribI4ubv);
	glp->VertexAttribI4ubvEXT = (void APIENTRY (*)(GLuint index, const GLubyte *v)) ldg_find("glVertexAttribI4ubvEXT", lib);
	GL_CHECK(glp->VertexAttribI4ubvEXT);
	glp->VertexAttribI4ui = (void APIENTRY (*)(GLuint index, GLuint x, GLuint y, GLuint z, GLuint w)) ldg_find("glVertexAttribI4ui", lib);
	GL_CHECK(glp->VertexAttribI4ui);
	glp->VertexAttribI4uiEXT = (void APIENTRY (*)(GLuint index, GLuint x, GLuint y, GLuint z, GLuint w)) ldg_find("glVertexAttribI4uiEXT", lib);
	GL_CHECK(glp->VertexAttribI4uiEXT);
	glp->VertexAttribI4uiv = (void APIENTRY (*)(GLuint index, const GLuint *v)) ldg_find("glVertexAttribI4uiv", lib);
	GL_CHECK(glp->VertexAttribI4uiv);
	glp->VertexAttribI4uivEXT = (void APIENTRY (*)(GLuint index, const GLuint *v)) ldg_find("glVertexAttribI4uivEXT", lib);
	GL_CHECK(glp->VertexAttribI4uivEXT);
	glp->VertexAttribI4usv = (void APIENTRY (*)(GLuint index, const GLushort *v)) ldg_find("glVertexAttribI4usv", lib);
	GL_CHECK(glp->VertexAttribI4usv);
	glp->VertexAttribI4usvEXT = (void APIENTRY (*)(GLuint index, const GLushort *v)) ldg_find("glVertexAttribI4usvEXT", lib);
	GL_CHECK(glp->VertexAttribI4usvEXT);
	glp->VertexAttribIFormat = (void APIENTRY (*)(GLuint attribindex, GLint size, GLenum type, GLuint relativeoffset)) ldg_find("glVertexAttribIFormat", lib);
	GL_CHECK(glp->VertexAttribIFormat);
	glp->VertexAttribIFormatNV = (void APIENTRY (*)(GLuint index, GLint size, GLenum type, GLsizei stride)) ldg_find("glVertexAttribIFormatNV", lib);
	GL_CHECK(glp->VertexAttribIFormatNV);
	glp->VertexAttribIPointer = (void APIENTRY (*)(GLuint index, GLint size, GLenum type, GLsizei stride, const void *pointer)) ldg_find("glVertexAttribIPointer", lib);
	GL_CHECK(glp->VertexAttribIPointer);
	glp->VertexAttribIPointerEXT = (void APIENTRY (*)(GLuint index, GLint size, GLenum type, GLsizei stride, const void *pointer)) ldg_find("glVertexAttribIPointerEXT", lib);
	GL_CHECK(glp->VertexAttribIPointerEXT);
	glp->VertexAttribL1d = (void APIENTRY (*)(GLuint index, GLdouble x)) ldg_find("glVertexAttribL1d", lib);
	GL_CHECK(glp->VertexAttribL1d);
	glp->VertexAttribL1dEXT = (void APIENTRY (*)(GLuint index, GLdouble x)) ldg_find("glVertexAttribL1dEXT", lib);
	GL_CHECK(glp->VertexAttribL1dEXT);
	glp->VertexAttribL1dv = (void APIENTRY (*)(GLuint index, const GLdouble *v)) ldg_find("glVertexAttribL1dv", lib);
	GL_CHECK(glp->VertexAttribL1dv);
	glp->VertexAttribL1dvEXT = (void APIENTRY (*)(GLuint index, const GLdouble *v)) ldg_find("glVertexAttribL1dvEXT", lib);
	GL_CHECK(glp->VertexAttribL1dvEXT);
	glp->VertexAttribL1i64NV = (void APIENTRY (*)(GLuint index, GLint64EXT x)) ldg_find("glVertexAttribL1i64NV", lib);
	GL_CHECK(glp->VertexAttribL1i64NV);
	glp->VertexAttribL1i64vNV = (void APIENTRY (*)(GLuint index, const GLint64EXT *v)) ldg_find("glVertexAttribL1i64vNV", lib);
	GL_CHECK(glp->VertexAttribL1i64vNV);
	glp->VertexAttribL1ui64ARB = (void APIENTRY (*)(GLuint index, GLuint64EXT x)) ldg_find("glVertexAttribL1ui64ARB", lib);
	GL_CHECK(glp->VertexAttribL1ui64ARB);
	glp->VertexAttribL1ui64NV = (void APIENTRY (*)(GLuint index, GLuint64EXT x)) ldg_find("glVertexAttribL1ui64NV", lib);
	GL_CHECK(glp->VertexAttribL1ui64NV);
	glp->VertexAttribL1ui64vARB = (void APIENTRY (*)(GLuint index, const GLuint64EXT *v)) ldg_find("glVertexAttribL1ui64vARB", lib);
	GL_CHECK(glp->VertexAttribL1ui64vARB);
	glp->VertexAttribL1ui64vNV = (void APIENTRY (*)(GLuint index, const GLuint64EXT *v)) ldg_find("glVertexAttribL1ui64vNV", lib);
	GL_CHECK(glp->VertexAttribL1ui64vNV);
	glp->VertexAttribL2d = (void APIENTRY (*)(GLuint index, GLdouble x, GLdouble y)) ldg_find("glVertexAttribL2d", lib);
	GL_CHECK(glp->VertexAttribL2d);
	glp->VertexAttribL2dEXT = (void APIENTRY (*)(GLuint index, GLdouble x, GLdouble y)) ldg_find("glVertexAttribL2dEXT", lib);
	GL_CHECK(glp->VertexAttribL2dEXT);
	glp->VertexAttribL2dv = (void APIENTRY (*)(GLuint index, const GLdouble *v)) ldg_find("glVertexAttribL2dv", lib);
	GL_CHECK(glp->VertexAttribL2dv);
	glp->VertexAttribL2dvEXT = (void APIENTRY (*)(GLuint index, const GLdouble *v)) ldg_find("glVertexAttribL2dvEXT", lib);
	GL_CHECK(glp->VertexAttribL2dvEXT);
	glp->VertexAttribL2i64NV = (void APIENTRY (*)(GLuint index, GLint64EXT x, GLint64EXT y)) ldg_find("glVertexAttribL2i64NV", lib);
	GL_CHECK(glp->VertexAttribL2i64NV);
	glp->VertexAttribL2i64vNV = (void APIENTRY (*)(GLuint index, const GLint64EXT *v)) ldg_find("glVertexAttribL2i64vNV", lib);
	GL_CHECK(glp->VertexAttribL2i64vNV);
	glp->VertexAttribL2ui64NV = (void APIENTRY (*)(GLuint index, GLuint64EXT x, GLuint64EXT y)) ldg_find("glVertexAttribL2ui64NV", lib);
	GL_CHECK(glp->VertexAttribL2ui64NV);
	glp->VertexAttribL2ui64vNV = (void APIENTRY (*)(GLuint index, const GLuint64EXT *v)) ldg_find("glVertexAttribL2ui64vNV", lib);
	GL_CHECK(glp->VertexAttribL2ui64vNV);
	glp->VertexAttribL3d = (void APIENTRY (*)(GLuint index, GLdouble x, GLdouble y, GLdouble z)) ldg_find("glVertexAttribL3d", lib);
	GL_CHECK(glp->VertexAttribL3d);
	glp->VertexAttribL3dEXT = (void APIENTRY (*)(GLuint index, GLdouble x, GLdouble y, GLdouble z)) ldg_find("glVertexAttribL3dEXT", lib);
	GL_CHECK(glp->VertexAttribL3dEXT);
	glp->VertexAttribL3dv = (void APIENTRY (*)(GLuint index, const GLdouble *v)) ldg_find("glVertexAttribL3dv", lib);
	GL_CHECK(glp->VertexAttribL3dv);
	glp->VertexAttribL3dvEXT = (void APIENTRY (*)(GLuint index, const GLdouble *v)) ldg_find("glVertexAttribL3dvEXT", lib);
	GL_CHECK(glp->VertexAttribL3dvEXT);
	glp->VertexAttribL3i64NV = (void APIENTRY (*)(GLuint index, GLint64EXT x, GLint64EXT y, GLint64EXT z)) ldg_find("glVertexAttribL3i64NV", lib);
	GL_CHECK(glp->VertexAttribL3i64NV);
	glp->VertexAttribL3i64vNV = (void APIENTRY (*)(GLuint index, const GLint64EXT *v)) ldg_find("glVertexAttribL3i64vNV", lib);
	GL_CHECK(glp->VertexAttribL3i64vNV);
	glp->VertexAttribL3ui64NV = (void APIENTRY (*)(GLuint index, GLuint64EXT x, GLuint64EXT y, GLuint64EXT z)) ldg_find("glVertexAttribL3ui64NV", lib);
	GL_CHECK(glp->VertexAttribL3ui64NV);
	glp->VertexAttribL3ui64vNV = (void APIENTRY (*)(GLuint index, const GLuint64EXT *v)) ldg_find("glVertexAttribL3ui64vNV", lib);
	GL_CHECK(glp->VertexAttribL3ui64vNV);
	glp->VertexAttribL4d = (void APIENTRY (*)(GLuint index, GLdouble x, GLdouble y, GLdouble z, GLdouble w)) ldg_find("glVertexAttribL4d", lib);
	GL_CHECK(glp->VertexAttribL4d);
	glp->VertexAttribL4dEXT = (void APIENTRY (*)(GLuint index, GLdouble x, GLdouble y, GLdouble z, GLdouble w)) ldg_find("glVertexAttribL4dEXT", lib);
	GL_CHECK(glp->VertexAttribL4dEXT);
	glp->VertexAttribL4dv = (void APIENTRY (*)(GLuint index, const GLdouble *v)) ldg_find("glVertexAttribL4dv", lib);
	GL_CHECK(glp->VertexAttribL4dv);
	glp->VertexAttribL4dvEXT = (void APIENTRY (*)(GLuint index, const GLdouble *v)) ldg_find("glVertexAttribL4dvEXT", lib);
	GL_CHECK(glp->VertexAttribL4dvEXT);
	glp->VertexAttribL4i64NV = (void APIENTRY (*)(GLuint index, GLint64EXT x, GLint64EXT y, GLint64EXT z, GLint64EXT w)) ldg_find("glVertexAttribL4i64NV", lib);
	GL_CHECK(glp->VertexAttribL4i64NV);
	glp->VertexAttribL4i64vNV = (void APIENTRY (*)(GLuint index, const GLint64EXT *v)) ldg_find("glVertexAttribL4i64vNV", lib);
	GL_CHECK(glp->VertexAttribL4i64vNV);
	glp->VertexAttribL4ui64NV = (void APIENTRY (*)(GLuint index, GLuint64EXT x, GLuint64EXT y, GLuint64EXT z, GLuint64EXT w)) ldg_find("glVertexAttribL4ui64NV", lib);
	GL_CHECK(glp->VertexAttribL4ui64NV);
	glp->VertexAttribL4ui64vNV = (void APIENTRY (*)(GLuint index, const GLuint64EXT *v)) ldg_find("glVertexAttribL4ui64vNV", lib);
	GL_CHECK(glp->VertexAttribL4ui64vNV);
	glp->VertexAttribLFormat = (void APIENTRY (*)(GLuint attribindex, GLint size, GLenum type, GLuint relativeoffset)) ldg_find("glVertexAttribLFormat", lib);
	GL_CHECK(glp->VertexAttribLFormat);
	glp->VertexAttribLFormatNV = (void APIENTRY (*)(GLuint index, GLint size, GLenum type, GLsizei stride)) ldg_find("glVertexAttribLFormatNV", lib);
	GL_CHECK(glp->VertexAttribLFormatNV);
	glp->VertexAttribLPointer = (void APIENTRY (*)(GLuint index, GLint size, GLenum type, GLsizei stride, const void *pointer)) ldg_find("glVertexAttribLPointer", lib);
	GL_CHECK(glp->VertexAttribLPointer);
	glp->VertexAttribLPointerEXT = (void APIENTRY (*)(GLuint index, GLint size, GLenum type, GLsizei stride, const void *pointer)) ldg_find("glVertexAttribLPointerEXT", lib);
	GL_CHECK(glp->VertexAttribLPointerEXT);
	glp->VertexAttribP1ui = (void APIENTRY (*)(GLuint index, GLenum type, GLboolean32 normalized, GLuint value)) ldg_find("glVertexAttribP1ui", lib);
	GL_CHECK(glp->VertexAttribP1ui);
	glp->VertexAttribP1uiv = (void APIENTRY (*)(GLuint index, GLenum type, GLboolean32 normalized, const GLuint *value)) ldg_find("glVertexAttribP1uiv", lib);
	GL_CHECK(glp->VertexAttribP1uiv);
	glp->VertexAttribP2ui = (void APIENTRY (*)(GLuint index, GLenum type, GLboolean32 normalized, GLuint value)) ldg_find("glVertexAttribP2ui", lib);
	GL_CHECK(glp->VertexAttribP2ui);
	glp->VertexAttribP2uiv = (void APIENTRY (*)(GLuint index, GLenum type, GLboolean32 normalized, const GLuint *value)) ldg_find("glVertexAttribP2uiv", lib);
	GL_CHECK(glp->VertexAttribP2uiv);
	glp->VertexAttribP3ui = (void APIENTRY (*)(GLuint index, GLenum type, GLboolean32 normalized, GLuint value)) ldg_find("glVertexAttribP3ui", lib);
	GL_CHECK(glp->VertexAttribP3ui);
	glp->VertexAttribP3uiv = (void APIENTRY (*)(GLuint index, GLenum type, GLboolean32 normalized, const GLuint *value)) ldg_find("glVertexAttribP3uiv", lib);
	GL_CHECK(glp->VertexAttribP3uiv);
	glp->VertexAttribP4ui = (void APIENTRY (*)(GLuint index, GLenum type, GLboolean32 normalized, GLuint value)) ldg_find("glVertexAttribP4ui", lib);
	GL_CHECK(glp->VertexAttribP4ui);
	glp->VertexAttribP4uiv = (void APIENTRY (*)(GLuint index, GLenum type, GLboolean32 normalized, const GLuint *value)) ldg_find("glVertexAttribP4uiv", lib);
	GL_CHECK(glp->VertexAttribP4uiv);
	glp->VertexAttribParameteriAMD = (void APIENTRY (*)(GLuint index, GLenum pname, GLint param)) ldg_find("glVertexAttribParameteriAMD", lib);
	GL_CHECK(glp->VertexAttribParameteriAMD);
	glp->VertexAttribPointer = (void APIENTRY (*)(GLuint index, GLint size, GLenum type, GLboolean32 normalized, GLsizei stride, const void *pointer)) ldg_find("glVertexAttribPointer", lib);
	GL_CHECK(glp->VertexAttribPointer);
	glp->VertexBindingDivisor = (void APIENTRY (*)(GLuint bindingindex, GLuint divisor)) ldg_find("glVertexBindingDivisor", lib);
	GL_CHECK(glp->VertexBindingDivisor);
	glp->VertexFormatNV = (void APIENTRY (*)(GLint size, GLenum type, GLsizei stride)) ldg_find("glVertexFormatNV", lib);
	GL_CHECK(glp->VertexFormatNV);
	glp->VertexP2ui = (void APIENTRY (*)(GLenum type, GLuint value)) ldg_find("glVertexP2ui", lib);
	GL_CHECK(glp->VertexP2ui);
	glp->VertexP2uiv = (void APIENTRY (*)(GLenum type, const GLuint *value)) ldg_find("glVertexP2uiv", lib);
	GL_CHECK(glp->VertexP2uiv);
	glp->VertexP3ui = (void APIENTRY (*)(GLenum type, GLuint value)) ldg_find("glVertexP3ui", lib);
	GL_CHECK(glp->VertexP3ui);
	glp->VertexP3uiv = (void APIENTRY (*)(GLenum type, const GLuint *value)) ldg_find("glVertexP3uiv", lib);
	GL_CHECK(glp->VertexP3uiv);
	glp->VertexP4ui = (void APIENTRY (*)(GLenum type, GLuint value)) ldg_find("glVertexP4ui", lib);
	GL_CHECK(glp->VertexP4ui);
	glp->VertexP4uiv = (void APIENTRY (*)(GLenum type, const GLuint *value)) ldg_find("glVertexP4uiv", lib);
	GL_CHECK(glp->VertexP4uiv);
	glp->VertexPointSizefAPPLE = (void APIENTRY (*)(GLfloat size)) ldg_find("glVertexPointSizefAPPLE", lib);
	GL_CHECK(glp->VertexPointSizefAPPLE);
	glp->VideoCaptureNV = (GLenum APIENTRY (*)(GLuint video_capture_slot, GLuint *sequence_num, GLuint64EXT *capture_time)) ldg_find("glVideoCaptureNV", lib);
	GL_CHECK(glp->VideoCaptureNV);
	glp->VideoCaptureStreamParameterdvNV = (void APIENTRY (*)(GLuint video_capture_slot, GLuint stream, GLenum pname, const GLdouble *params)) ldg_find("glVideoCaptureStreamParameterdvNV", lib);
	GL_CHECK(glp->VideoCaptureStreamParameterdvNV);
	glp->VideoCaptureStreamParameterfvNV = (void APIENTRY (*)(GLuint video_capture_slot, GLuint stream, GLenum pname, const GLfloat *params)) ldg_find("glVideoCaptureStreamParameterfvNV", lib);
	GL_CHECK(glp->VideoCaptureStreamParameterfvNV);
	glp->VideoCaptureStreamParameterivNV = (void APIENTRY (*)(GLuint video_capture_slot, GLuint stream, GLenum pname, const GLint *params)) ldg_find("glVideoCaptureStreamParameterivNV", lib);
	GL_CHECK(glp->VideoCaptureStreamParameterivNV);
	glp->ViewportArrayv = (void APIENTRY (*)(GLuint first, GLsizei count, const GLfloat *v)) ldg_find("glViewportArrayv", lib);
	GL_CHECK(glp->ViewportArrayv);
	glp->ViewportIndexedf = (void APIENTRY (*)(GLuint index, GLfloat x, GLfloat y, GLfloat w, GLfloat h)) ldg_find("glViewportIndexedf", lib);
	GL_CHECK(glp->ViewportIndexedf);
	glp->ViewportIndexedfv = (void APIENTRY (*)(GLuint index, const GLfloat *v)) ldg_find("glViewportIndexedfv", lib);
	GL_CHECK(glp->ViewportIndexedfv);
	glp->WaitSync = (void APIENTRY (*)(GLsync sync, GLbitfield flags, GLuint64 timeout)) ldg_find("glWaitSync", lib);
	GL_CHECK(glp->WaitSync);
	glp->WeightPathsNV = (void APIENTRY (*)(GLuint resultPath, GLsizei numPaths, const GLuint *paths, const GLfloat *weights)) ldg_find("glWeightPathsNV", lib);
	GL_CHECK(glp->WeightPathsNV);
	glp->BindTextureUnit = (void APIENTRY (*)(GLuint unit, GLuint texture)) ldg_find("glBindTextureUnit", lib);
	GL_CHECK(glp->BindTextureUnit);
	glp->BlendBarrierKHR = (void APIENTRY (*)(void)) ldg_find("glBlendBarrierKHR", lib);
	GL_CHECK(glp->BlendBarrierKHR);
	glp->BlitNamedFramebuffer = (void APIENTRY (*)(GLuint readFramebuffer, GLuint drawFramebuffer, GLint srcX0, GLint srcY0, GLint srcX1, GLint srcY1, GLint dstX0, GLint dstY0, GLint dstX1, GLint dstY1, GLbitfield mask, GLenum filter)) ldg_find("glBlitNamedFramebuffer", lib);
	GL_CHECK(glp->BlitNamedFramebuffer);
	glp->BufferPageCommitmentARB = (void APIENTRY (*)(GLenum target, GLintptr offset, GLsizeiptr size, GLboolean32 commit)) ldg_find("glBufferPageCommitmentARB", lib);
	GL_CHECK(glp->BufferPageCommitmentARB);
	glp->CallCommandListNV = (void APIENTRY (*)(GLuint list)) ldg_find("glCallCommandListNV", lib);
	GL_CHECK(glp->CallCommandListNV);
	glp->CheckNamedFramebufferStatus = (GLenum APIENTRY (*)(GLuint framebuffer, GLenum target)) ldg_find("glCheckNamedFramebufferStatus", lib);
	GL_CHECK(glp->CheckNamedFramebufferStatus);
	glp->ClearNamedBufferData = (void APIENTRY (*)(GLuint buffer, GLenum internalformat, GLenum format, GLenum type, const void *data)) ldg_find("glClearNamedBufferData", lib);
	GL_CHECK(glp->ClearNamedBufferData);
	glp->ClearNamedBufferSubData = (void APIENTRY (*)(GLuint buffer, GLenum internalformat, GLintptr offset, GLsizeiptr size, GLenum format, GLenum type, const void *data)) ldg_find("glClearNamedBufferSubData", lib);
	GL_CHECK(glp->ClearNamedBufferSubData);
	glp->ClearNamedFramebufferfi = (void APIENTRY (*)(GLuint framebuffer, GLenum buffer, GLint drawbuffer, GLfloat depth, GLint stencil)) ldg_find("glClearNamedFramebufferfi", lib);
	GL_CHECK(glp->ClearNamedFramebufferfi);
	glp->ClearNamedFramebufferfv = (void APIENTRY (*)(GLuint framebuffer, GLenum buffer, GLint drawbuffer, const GLfloat *value)) ldg_find("glClearNamedFramebufferfv", lib);
	GL_CHECK(glp->ClearNamedFramebufferfv);
	glp->ClearNamedFramebufferiv = (void APIENTRY (*)(GLuint framebuffer, GLenum buffer, GLint drawbuffer, const GLint *value)) ldg_find("glClearNamedFramebufferiv", lib);
	GL_CHECK(glp->ClearNamedFramebufferiv);
	glp->ClearNamedFramebufferuiv = (void APIENTRY (*)(GLuint framebuffer, GLenum buffer, GLint drawbuffer, const GLuint *value)) ldg_find("glClearNamedFramebufferuiv", lib);
	GL_CHECK(glp->ClearNamedFramebufferuiv);
	glp->ClipControl = (void APIENTRY (*)(GLenum origin, GLenum depth)) ldg_find("glClipControl", lib);
	GL_CHECK(glp->ClipControl);
	glp->CommandListSegmentsNV = (void APIENTRY (*)(GLuint list, GLuint segments)) ldg_find("glCommandListSegmentsNV", lib);
	GL_CHECK(glp->CommandListSegmentsNV);
	glp->CompileCommandListNV = (void APIENTRY (*)(GLuint list)) ldg_find("glCompileCommandListNV", lib);
	GL_CHECK(glp->CompileCommandListNV);
	glp->CompressedTextureSubImage1D = (void APIENTRY (*)(GLuint texture, GLint level, GLint xoffset, GLsizei width, GLenum format, GLsizei imageSize, const void *data)) ldg_find("glCompressedTextureSubImage1D", lib);
	GL_CHECK(glp->CompressedTextureSubImage1D);
	glp->CompressedTextureSubImage2D = (void APIENTRY (*)(GLuint texture, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLsizei imageSize, const void *data)) ldg_find("glCompressedTextureSubImage2D", lib);
	GL_CHECK(glp->CompressedTextureSubImage2D);
	glp->CompressedTextureSubImage3D = (void APIENTRY (*)(GLuint texture, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLsizei imageSize, const void *data)) ldg_find("glCompressedTextureSubImage3D", lib);
	GL_CHECK(glp->CompressedTextureSubImage3D);
	glp->CopyNamedBufferSubData = (void APIENTRY (*)(GLuint readBuffer, GLuint writeBuffer, GLintptr readOffset, GLintptr writeOffset, GLsizeiptr size)) ldg_find("glCopyNamedBufferSubData", lib);
	GL_CHECK(glp->CopyNamedBufferSubData);
	glp->CopyTextureSubImage1D = (void APIENTRY (*)(GLuint texture, GLint level, GLint xoffset, GLint x, GLint y, GLsizei width)) ldg_find("glCopyTextureSubImage1D", lib);
	GL_CHECK(glp->CopyTextureSubImage1D);
	glp->CopyTextureSubImage2D = (void APIENTRY (*)(GLuint texture, GLint level, GLint xoffset, GLint yoffset, GLint x, GLint y, GLsizei width, GLsizei height)) ldg_find("glCopyTextureSubImage2D", lib);
	GL_CHECK(glp->CopyTextureSubImage2D);
	glp->CopyTextureSubImage3D = (void APIENTRY (*)(GLuint texture, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLint x, GLint y, GLsizei width, GLsizei height)) ldg_find("glCopyTextureSubImage3D", lib);
	GL_CHECK(glp->CopyTextureSubImage3D);
	glp->CoverageModulationNV = (void APIENTRY (*)(GLenum components)) ldg_find("glCoverageModulationNV", lib);
	GL_CHECK(glp->CoverageModulationNV);
	glp->CoverageModulationTableNV = (void APIENTRY (*)(GLsizei n, const GLfloat *v)) ldg_find("glCoverageModulationTableNV", lib);
	GL_CHECK(glp->CoverageModulationTableNV);
	glp->CreateBuffers = (void APIENTRY (*)(GLsizei n, GLuint *buffers)) ldg_find("glCreateBuffers", lib);
	GL_CHECK(glp->CreateBuffers);
	glp->CreateCommandListsNV = (void APIENTRY (*)(GLsizei n, GLuint *lists)) ldg_find("glCreateCommandListsNV", lib);
	GL_CHECK(glp->CreateCommandListsNV);
	glp->CreateFramebuffers = (void APIENTRY (*)(GLsizei n, GLuint *framebuffers)) ldg_find("glCreateFramebuffers", lib);
	GL_CHECK(glp->CreateFramebuffers);
	glp->CreateProgramPipelines = (void APIENTRY (*)(GLsizei n, GLuint *pipelines)) ldg_find("glCreateProgramPipelines", lib);
	GL_CHECK(glp->CreateProgramPipelines);
	glp->CreateQueries = (void APIENTRY (*)(GLenum target, GLsizei n, GLuint *ids)) ldg_find("glCreateQueries", lib);
	GL_CHECK(glp->CreateQueries);
	glp->CreateRenderbuffers = (void APIENTRY (*)(GLsizei n, GLuint *renderbuffers)) ldg_find("glCreateRenderbuffers", lib);
	GL_CHECK(glp->CreateRenderbuffers);
	glp->CreateSamplers = (void APIENTRY (*)(GLsizei n, GLuint *samplers)) ldg_find("glCreateSamplers", lib);
	GL_CHECK(glp->CreateSamplers);
	glp->CreateStatesNV = (void APIENTRY (*)(GLsizei n, GLuint *states)) ldg_find("glCreateStatesNV", lib);
	GL_CHECK(glp->CreateStatesNV);
	glp->CreateTextures = (void APIENTRY (*)(GLenum target, GLsizei n, GLuint *textures)) ldg_find("glCreateTextures", lib);
	GL_CHECK(glp->CreateTextures);
	glp->CreateTransformFeedbacks = (void APIENTRY (*)(GLsizei n, GLuint *ids)) ldg_find("glCreateTransformFeedbacks", lib);
	GL_CHECK(glp->CreateTransformFeedbacks);
	glp->CreateVertexArrays = (void APIENTRY (*)(GLsizei n, GLuint *arrays)) ldg_find("glCreateVertexArrays", lib);
	GL_CHECK(glp->CreateVertexArrays);
	glp->DeleteCommandListsNV = (void APIENTRY (*)(GLsizei n, const GLuint *lists)) ldg_find("glDeleteCommandListsNV", lib);
	GL_CHECK(glp->DeleteCommandListsNV);
	glp->DeleteStatesNV = (void APIENTRY (*)(GLsizei n, const GLuint *states)) ldg_find("glDeleteStatesNV", lib);
	GL_CHECK(glp->DeleteStatesNV);
	glp->DisableVertexArrayAttrib = (void APIENTRY (*)(GLuint vaobj, GLuint index)) ldg_find("glDisableVertexArrayAttrib", lib);
	GL_CHECK(glp->DisableVertexArrayAttrib);
	glp->DrawCommandsAddressNV = (void APIENTRY (*)(GLenum primitiveMode, const GLuint64 *indirects, const GLsizei *sizes, GLuint count)) ldg_find("glDrawCommandsAddressNV", lib);
	GL_CHECK(glp->DrawCommandsAddressNV);
	glp->DrawCommandsNV = (void APIENTRY (*)(GLenum primitiveMode, GLuint buffer, const GLintptr *indirects, const GLsizei *sizes, GLuint count)) ldg_find("glDrawCommandsNV", lib);
	GL_CHECK(glp->DrawCommandsNV);
	glp->DrawCommandsStatesAddressNV = (void APIENTRY (*)(const GLuint64 *indirects, const GLsizei *sizes, const GLuint *states, const GLuint *fbos, GLuint count)) ldg_find("glDrawCommandsStatesAddressNV", lib);
	GL_CHECK(glp->DrawCommandsStatesAddressNV);
	glp->DrawCommandsStatesNV = (void APIENTRY (*)(GLuint buffer, const GLintptr *indirects, const GLsizei *sizes, const GLuint *states, const GLuint *fbos, GLuint count)) ldg_find("glDrawCommandsStatesNV", lib);
	GL_CHECK(glp->DrawCommandsStatesNV);
	glp->EnableVertexArrayAttrib = (void APIENTRY (*)(GLuint vaobj, GLuint index)) ldg_find("glEnableVertexArrayAttrib", lib);
	GL_CHECK(glp->EnableVertexArrayAttrib);
	glp->FlushMappedNamedBufferRange = (void APIENTRY (*)(GLuint buffer, GLintptr offset, GLsizeiptr length)) ldg_find("glFlushMappedNamedBufferRange", lib);
	GL_CHECK(glp->FlushMappedNamedBufferRange);
	glp->FragmentCoverageColorNV = (void APIENTRY (*)(GLuint color)) ldg_find("glFragmentCoverageColorNV", lib);
	GL_CHECK(glp->FragmentCoverageColorNV);
	glp->FramebufferSampleLocationsfvNV = (void APIENTRY (*)(GLenum target, GLuint start, GLsizei count, const GLfloat *v)) ldg_find("glFramebufferSampleLocationsfvNV", lib);
	GL_CHECK(glp->FramebufferSampleLocationsfvNV);
	glp->FramebufferTextureMultiviewOVR = (void APIENTRY (*)(GLenum target, GLenum attachment, GLuint texture, GLint level, GLint baseViewIndex, GLsizei numViews)) ldg_find("glFramebufferTextureMultiviewOVR", lib);
	GL_CHECK(glp->FramebufferTextureMultiviewOVR);
	glp->GenerateTextureMipmap = (void APIENTRY (*)(GLuint texture)) ldg_find("glGenerateTextureMipmap", lib);
	GL_CHECK(glp->GenerateTextureMipmap);
	glp->GetCommandHeaderNV = (GLuint APIENTRY (*)(GLenum tokenID, GLuint size)) ldg_find("glGetCommandHeaderNV", lib);
	GL_CHECK(glp->GetCommandHeaderNV);
	glp->GetCompressedTextureImage = (void APIENTRY (*)(GLuint texture, GLint level, GLsizei bufSize, void *pixels)) ldg_find("glGetCompressedTextureImage", lib);
	GL_CHECK(glp->GetCompressedTextureImage);
	glp->GetCompressedTextureSubImage = (void APIENTRY (*)(GLuint texture, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLsizei bufSize, void *pixels)) ldg_find("glGetCompressedTextureSubImage", lib);
	GL_CHECK(glp->GetCompressedTextureSubImage);
	glp->GetCoverageModulationTableNV = (void APIENTRY (*)(GLsizei bufsize, GLfloat *v)) ldg_find("glGetCoverageModulationTableNV", lib);
	GL_CHECK(glp->GetCoverageModulationTableNV);
	glp->GetGraphicsResetStatus = (GLenum APIENTRY (*)(void)) ldg_find("glGetGraphicsResetStatus", lib);
	GL_CHECK(glp->GetGraphicsResetStatus);
	glp->GetInternalformatSampleivNV = (void APIENTRY (*)(GLenum target, GLenum internalformat, GLsizei samples, GLenum pname, GLsizei bufSize, GLint *params)) ldg_find("glGetInternalformatSampleivNV", lib);
	GL_CHECK(glp->GetInternalformatSampleivNV);
	glp->GetNamedBufferParameteri64v = (void APIENTRY (*)(GLuint buffer, GLenum pname, GLint64 *params)) ldg_find("glGetNamedBufferParameteri64v", lib);
	GL_CHECK(glp->GetNamedBufferParameteri64v);
	glp->GetNamedBufferParameteriv = (void APIENTRY (*)(GLuint buffer, GLenum pname, GLint *params)) ldg_find("glGetNamedBufferParameteriv", lib);
	GL_CHECK(glp->GetNamedBufferParameteriv);
	glp->GetNamedBufferPointerv = (void APIENTRY (*)(GLuint buffer, GLenum pname, void * *params)) ldg_find("glGetNamedBufferPointerv", lib);
	GL_CHECK(glp->GetNamedBufferPointerv);
	glp->GetNamedBufferSubData = (void APIENTRY (*)(GLuint buffer, GLintptr offset, GLsizeiptr size, void *data)) ldg_find("glGetNamedBufferSubData", lib);
	GL_CHECK(glp->GetNamedBufferSubData);
	glp->GetNamedFramebufferAttachmentParameteriv = (void APIENTRY (*)(GLuint framebuffer, GLenum attachment, GLenum pname, GLint *params)) ldg_find("glGetNamedFramebufferAttachmentParameteriv", lib);
	GL_CHECK(glp->GetNamedFramebufferAttachmentParameteriv);
	glp->GetNamedFramebufferParameteriv = (void APIENTRY (*)(GLuint framebuffer, GLenum pname, GLint *param)) ldg_find("glGetNamedFramebufferParameteriv", lib);
	GL_CHECK(glp->GetNamedFramebufferParameteriv);
	glp->GetNamedRenderbufferParameteriv = (void APIENTRY (*)(GLuint renderbuffer, GLenum pname, GLint *params)) ldg_find("glGetNamedRenderbufferParameteriv", lib);
	GL_CHECK(glp->GetNamedRenderbufferParameteriv);
	glp->GetProgramResourcefvNV = (void APIENTRY (*)(GLuint program, GLenum programInterface, GLuint index, GLsizei propCount, const GLenum *props, GLsizei bufSize, GLsizei *length, GLfloat *params)) ldg_find("glGetProgramResourcefvNV", lib);
	GL_CHECK(glp->GetProgramResourcefvNV);
	glp->GetQueryBufferObjecti64v = (void APIENTRY (*)(GLuint id, GLuint buffer, GLenum pname, GLintptr offset)) ldg_find("glGetQueryBufferObjecti64v", lib);
	GL_CHECK(glp->GetQueryBufferObjecti64v);
	glp->GetQueryBufferObjectiv = (void APIENTRY (*)(GLuint id, GLuint buffer, GLenum pname, GLintptr offset)) ldg_find("glGetQueryBufferObjectiv", lib);
	GL_CHECK(glp->GetQueryBufferObjectiv);
	glp->GetQueryBufferObjectui64v = (void APIENTRY (*)(GLuint id, GLuint buffer, GLenum pname, GLintptr offset)) ldg_find("glGetQueryBufferObjectui64v", lib);
	GL_CHECK(glp->GetQueryBufferObjectui64v);
	glp->GetQueryBufferObjectuiv = (void APIENTRY (*)(GLuint id, GLuint buffer, GLenum pname, GLintptr offset)) ldg_find("glGetQueryBufferObjectuiv", lib);
	GL_CHECK(glp->GetQueryBufferObjectuiv);
	glp->GetStageIndexNV = (GLushort APIENTRY (*)(GLenum shadertype)) ldg_find("glGetStageIndexNV", lib);
	GL_CHECK(glp->GetStageIndexNV);
	glp->GetTextureImage = (void APIENTRY (*)(GLuint texture, GLint level, GLenum format, GLenum type, GLsizei bufSize, void *pixels)) ldg_find("glGetTextureImage", lib);
	GL_CHECK(glp->GetTextureImage);
	glp->GetTextureLevelParameterfv = (void APIENTRY (*)(GLuint texture, GLint level, GLenum pname, GLfloat *params)) ldg_find("glGetTextureLevelParameterfv", lib);
	GL_CHECK(glp->GetTextureLevelParameterfv);
	glp->GetTextureLevelParameteriv = (void APIENTRY (*)(GLuint texture, GLint level, GLenum pname, GLint *params)) ldg_find("glGetTextureLevelParameteriv", lib);
	GL_CHECK(glp->GetTextureLevelParameteriv);
	glp->GetTextureParameterIiv = (void APIENTRY (*)(GLuint texture, GLenum pname, GLint *params)) ldg_find("glGetTextureParameterIiv", lib);
	GL_CHECK(glp->GetTextureParameterIiv);
	glp->GetTextureParameterIuiv = (void APIENTRY (*)(GLuint texture, GLenum pname, GLuint *params)) ldg_find("glGetTextureParameterIuiv", lib);
	GL_CHECK(glp->GetTextureParameterIuiv);
	glp->GetTextureParameterfv = (void APIENTRY (*)(GLuint texture, GLenum pname, GLfloat *params)) ldg_find("glGetTextureParameterfv", lib);
	GL_CHECK(glp->GetTextureParameterfv);
	glp->GetTextureParameteriv = (void APIENTRY (*)(GLuint texture, GLenum pname, GLint *params)) ldg_find("glGetTextureParameteriv", lib);
	GL_CHECK(glp->GetTextureParameteriv);
	glp->GetTextureSubImage = (void APIENTRY (*)(GLuint texture, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLenum type, GLsizei bufSize, void *pixels)) ldg_find("glGetTextureSubImage", lib);
	GL_CHECK(glp->GetTextureSubImage);
	glp->GetTransformFeedbacki64_v = (void APIENTRY (*)(GLuint xfb, GLenum pname, GLuint index, GLint64 *param)) ldg_find("glGetTransformFeedbacki64_v", lib);
	GL_CHECK(glp->GetTransformFeedbacki64_v);
	glp->GetTransformFeedbacki_v = (void APIENTRY (*)(GLuint xfb, GLenum pname, GLuint index, GLint *param)) ldg_find("glGetTransformFeedbacki_v", lib);
	GL_CHECK(glp->GetTransformFeedbacki_v);
	glp->GetTransformFeedbackiv = (void APIENTRY (*)(GLuint xfb, GLenum pname, GLint *param)) ldg_find("glGetTransformFeedbackiv", lib);
	GL_CHECK(glp->GetTransformFeedbackiv);
	glp->GetVertexArrayIndexed64iv = (void APIENTRY (*)(GLuint vaobj, GLuint index, GLenum pname, GLint64 *param)) ldg_find("glGetVertexArrayIndexed64iv", lib);
	GL_CHECK(glp->GetVertexArrayIndexed64iv);
	glp->GetVertexArrayIndexediv = (void APIENTRY (*)(GLuint vaobj, GLuint index, GLenum pname, GLint *param)) ldg_find("glGetVertexArrayIndexediv", lib);
	GL_CHECK(glp->GetVertexArrayIndexediv);
	glp->GetVertexArrayiv = (void APIENTRY (*)(GLuint vaobj, GLenum pname, GLint *param)) ldg_find("glGetVertexArrayiv", lib);
	GL_CHECK(glp->GetVertexArrayiv);
	glp->GetnColorTable = (void APIENTRY (*)(GLenum target, GLenum format, GLenum type, GLsizei bufSize, void *table)) ldg_find("glGetnColorTable", lib);
	GL_CHECK(glp->GetnColorTable);
	glp->GetnCompressedTexImage = (void APIENTRY (*)(GLenum target, GLint lod, GLsizei bufSize, void *pixels)) ldg_find("glGetnCompressedTexImage", lib);
	GL_CHECK(glp->GetnCompressedTexImage);
	glp->GetnConvolutionFilter = (void APIENTRY (*)(GLenum target, GLenum format, GLenum type, GLsizei bufSize, void *image)) ldg_find("glGetnConvolutionFilter", lib);
	GL_CHECK(glp->GetnConvolutionFilter);
	glp->GetnHistogram = (void APIENTRY (*)(GLenum target, GLboolean32 reset, GLenum format, GLenum type, GLsizei bufSize, void *values)) ldg_find("glGetnHistogram", lib);
	GL_CHECK(glp->GetnHistogram);
	glp->GetnMapdv = (void APIENTRY (*)(GLenum target, GLenum query, GLsizei bufSize, GLdouble *v)) ldg_find("glGetnMapdv", lib);
	GL_CHECK(glp->GetnMapdv);
	glp->GetnMapfv = (void APIENTRY (*)(GLenum target, GLenum query, GLsizei bufSize, GLfloat *v)) ldg_find("glGetnMapfv", lib);
	GL_CHECK(glp->GetnMapfv);
	glp->GetnMapiv = (void APIENTRY (*)(GLenum target, GLenum query, GLsizei bufSize, GLint *v)) ldg_find("glGetnMapiv", lib);
	GL_CHECK(glp->GetnMapiv);
	glp->GetnMinmax = (void APIENTRY (*)(GLenum target, GLboolean32 reset, GLenum format, GLenum type, GLsizei bufSize, void *values)) ldg_find("glGetnMinmax", lib);
	GL_CHECK(glp->GetnMinmax);
	glp->GetnPixelMapfv = (void APIENTRY (*)(GLenum map, GLsizei bufSize, GLfloat *values)) ldg_find("glGetnPixelMapfv", lib);
	GL_CHECK(glp->GetnPixelMapfv);
	glp->GetnPixelMapuiv = (void APIENTRY (*)(GLenum map, GLsizei bufSize, GLuint *values)) ldg_find("glGetnPixelMapuiv", lib);
	GL_CHECK(glp->GetnPixelMapuiv);
	glp->GetnPixelMapusv = (void APIENTRY (*)(GLenum map, GLsizei bufSize, GLushort *values)) ldg_find("glGetnPixelMapusv", lib);
	GL_CHECK(glp->GetnPixelMapusv);
	glp->GetnPolygonStipple = (void APIENTRY (*)(GLsizei bufSize, GLubyte *pattern)) ldg_find("glGetnPolygonStipple", lib);
	GL_CHECK(glp->GetnPolygonStipple);
	glp->GetnSeparableFilter = (void APIENTRY (*)(GLenum target, GLenum format, GLenum type, GLsizei rowBufSize, void *row, GLsizei columnBufSize, void *column, void *span)) ldg_find("glGetnSeparableFilter", lib);
	GL_CHECK(glp->GetnSeparableFilter);
	glp->GetnTexImage = (void APIENTRY (*)(GLenum target, GLint level, GLenum format, GLenum type, GLsizei bufSize, void *pixels)) ldg_find("glGetnTexImage", lib);
	GL_CHECK(glp->GetnTexImage);
	glp->GetnUniformdv = (void APIENTRY (*)(GLuint program, GLint location, GLsizei bufSize, GLdouble *params)) ldg_find("glGetnUniformdv", lib);
	GL_CHECK(glp->GetnUniformdv);
	glp->GetnUniformfv = (void APIENTRY (*)(GLuint program, GLint location, GLsizei bufSize, GLfloat *params)) ldg_find("glGetnUniformfv", lib);
	GL_CHECK(glp->GetnUniformfv);
	glp->GetnUniformiv = (void APIENTRY (*)(GLuint program, GLint location, GLsizei bufSize, GLint *params)) ldg_find("glGetnUniformiv", lib);
	GL_CHECK(glp->GetnUniformiv);
	glp->GetnUniformuiv = (void APIENTRY (*)(GLuint program, GLint location, GLsizei bufSize, GLuint *params)) ldg_find("glGetnUniformuiv", lib);
	GL_CHECK(glp->GetnUniformuiv);
	glp->InvalidateNamedFramebufferData = (void APIENTRY (*)(GLuint framebuffer, GLsizei numAttachments, const GLenum *attachments)) ldg_find("glInvalidateNamedFramebufferData", lib);
	GL_CHECK(glp->InvalidateNamedFramebufferData);
	glp->InvalidateNamedFramebufferSubData = (void APIENTRY (*)(GLuint framebuffer, GLsizei numAttachments, const GLenum *attachments, GLint x, GLint y, GLsizei width, GLsizei height)) ldg_find("glInvalidateNamedFramebufferSubData", lib);
	GL_CHECK(glp->InvalidateNamedFramebufferSubData);
	glp->IsCommandListNV = (GLboolean APIENTRY (*)(GLuint list)) ldg_find("glIsCommandListNV", lib);
	GL_CHECK(glp->IsCommandListNV);
	glp->IsStateNV = (GLboolean APIENTRY (*)(GLuint state)) ldg_find("glIsStateNV", lib);
	GL_CHECK(glp->IsStateNV);
	glp->ListDrawCommandsStatesClientNV = (void APIENTRY (*)(GLuint list, GLuint segment, const void * *indirects, const GLsizei *sizes, const GLuint *states, const GLuint *fbos, GLuint count)) ldg_find("glListDrawCommandsStatesClientNV", lib);
	GL_CHECK(glp->ListDrawCommandsStatesClientNV);
	glp->MapNamedBuffer = (void * APIENTRY (*)(GLuint buffer, GLenum access)) ldg_find("glMapNamedBuffer", lib);
	GL_CHECK(glp->MapNamedBuffer);
	glp->MapNamedBufferRange = (void * APIENTRY (*)(GLuint buffer, GLintptr offset, GLsizeiptr length, GLbitfield access)) ldg_find("glMapNamedBufferRange", lib);
	GL_CHECK(glp->MapNamedBufferRange);
	glp->MatrixLoad3x2fNV = (void APIENTRY (*)(GLenum matrixMode, const GLfloat *m)) ldg_find("glMatrixLoad3x2fNV", lib);
	GL_CHECK(glp->MatrixLoad3x2fNV);
	glp->MatrixLoad3x3fNV = (void APIENTRY (*)(GLenum matrixMode, const GLfloat *m)) ldg_find("glMatrixLoad3x3fNV", lib);
	GL_CHECK(glp->MatrixLoad3x3fNV);
	glp->MatrixLoadTranspose3x3fNV = (void APIENTRY (*)(GLenum matrixMode, const GLfloat *m)) ldg_find("glMatrixLoadTranspose3x3fNV", lib);
	GL_CHECK(glp->MatrixLoadTranspose3x3fNV);
	glp->MatrixMult3x2fNV = (void APIENTRY (*)(GLenum matrixMode, const GLfloat *m)) ldg_find("glMatrixMult3x2fNV", lib);
	GL_CHECK(glp->MatrixMult3x2fNV);
	glp->MatrixMult3x3fNV = (void APIENTRY (*)(GLenum matrixMode, const GLfloat *m)) ldg_find("glMatrixMult3x3fNV", lib);
	GL_CHECK(glp->MatrixMult3x3fNV);
	glp->MatrixMultTranspose3x3fNV = (void APIENTRY (*)(GLenum matrixMode, const GLfloat *m)) ldg_find("glMatrixMultTranspose3x3fNV", lib);
	GL_CHECK(glp->MatrixMultTranspose3x3fNV);
	glp->MemoryBarrierByRegion = (void APIENTRY (*)(GLbitfield barriers)) ldg_find("glMemoryBarrierByRegion", lib);
	GL_CHECK(glp->MemoryBarrierByRegion);
	glp->MultiDrawArraysIndirectBindlessCountNV = (void APIENTRY (*)(GLenum mode, const void *indirect, GLsizei drawCount, GLsizei maxDrawCount, GLsizei stride, GLint vertexBufferCount)) ldg_find("glMultiDrawArraysIndirectBindlessCountNV", lib);
	GL_CHECK(glp->MultiDrawArraysIndirectBindlessCountNV);
	glp->MultiDrawElementsIndirectBindlessCountNV = (void APIENTRY (*)(GLenum mode, GLenum type, const void *indirect, GLsizei drawCount, GLsizei maxDrawCount, GLsizei stride, GLint vertexBufferCount)) ldg_find("glMultiDrawElementsIndirectBindlessCountNV", lib);
	GL_CHECK(glp->MultiDrawElementsIndirectBindlessCountNV);
	glp->NamedBufferData = (void APIENTRY (*)(GLuint buffer, GLsizeiptr size, const void *data, GLenum usage)) ldg_find("glNamedBufferData", lib);
	GL_CHECK(glp->NamedBufferData);
	glp->NamedBufferPageCommitmentARB = (void APIENTRY (*)(GLuint buffer, GLintptr offset, GLsizeiptr size, GLboolean32 commit)) ldg_find("glNamedBufferPageCommitmentARB", lib);
	GL_CHECK(glp->NamedBufferPageCommitmentARB);
	glp->NamedBufferPageCommitmentEXT = (void APIENTRY (*)(GLuint buffer, GLintptr offset, GLsizeiptr size, GLboolean32 commit)) ldg_find("glNamedBufferPageCommitmentEXT", lib);
	GL_CHECK(glp->NamedBufferPageCommitmentEXT);
	glp->NamedBufferStorage = (void APIENTRY (*)(GLuint buffer, GLsizeiptr size, const void *data, GLbitfield flags)) ldg_find("glNamedBufferStorage", lib);
	GL_CHECK(glp->NamedBufferStorage);
	glp->NamedBufferSubData = (void APIENTRY (*)(GLuint buffer, GLintptr offset, GLsizeiptr size, const void *data)) ldg_find("glNamedBufferSubData", lib);
	GL_CHECK(glp->NamedBufferSubData);
	glp->NamedFramebufferDrawBuffer = (void APIENTRY (*)(GLuint framebuffer, GLenum buf)) ldg_find("glNamedFramebufferDrawBuffer", lib);
	GL_CHECK(glp->NamedFramebufferDrawBuffer);
	glp->NamedFramebufferDrawBuffers = (void APIENTRY (*)(GLuint framebuffer, GLsizei n, const GLenum *bufs)) ldg_find("glNamedFramebufferDrawBuffers", lib);
	GL_CHECK(glp->NamedFramebufferDrawBuffers);
	glp->NamedFramebufferParameteri = (void APIENTRY (*)(GLuint framebuffer, GLenum pname, GLint param)) ldg_find("glNamedFramebufferParameteri", lib);
	GL_CHECK(glp->NamedFramebufferParameteri);
	glp->NamedFramebufferReadBuffer = (void APIENTRY (*)(GLuint framebuffer, GLenum src)) ldg_find("glNamedFramebufferReadBuffer", lib);
	GL_CHECK(glp->NamedFramebufferReadBuffer);
	glp->NamedFramebufferRenderbuffer = (void APIENTRY (*)(GLuint framebuffer, GLenum attachment, GLenum renderbuffertarget, GLuint renderbuffer)) ldg_find("glNamedFramebufferRenderbuffer", lib);
	GL_CHECK(glp->NamedFramebufferRenderbuffer);
	glp->NamedFramebufferSampleLocationsfvNV = (void APIENTRY (*)(GLuint framebuffer, GLuint start, GLsizei count, const GLfloat *v)) ldg_find("glNamedFramebufferSampleLocationsfvNV", lib);
	GL_CHECK(glp->NamedFramebufferSampleLocationsfvNV);
	glp->NamedFramebufferTexture = (void APIENTRY (*)(GLuint framebuffer, GLenum attachment, GLuint texture, GLint level)) ldg_find("glNamedFramebufferTexture", lib);
	GL_CHECK(glp->NamedFramebufferTexture);
	glp->NamedFramebufferTextureLayer = (void APIENTRY (*)(GLuint framebuffer, GLenum attachment, GLuint texture, GLint level, GLint layer)) ldg_find("glNamedFramebufferTextureLayer", lib);
	GL_CHECK(glp->NamedFramebufferTextureLayer);
	glp->NamedRenderbufferStorage = (void APIENTRY (*)(GLuint renderbuffer, GLenum internalformat, GLsizei width, GLsizei height)) ldg_find("glNamedRenderbufferStorage", lib);
	GL_CHECK(glp->NamedRenderbufferStorage);
	glp->NamedRenderbufferStorageMultisample = (void APIENTRY (*)(GLuint renderbuffer, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height)) ldg_find("glNamedRenderbufferStorageMultisample", lib);
	GL_CHECK(glp->NamedRenderbufferStorageMultisample);
	glp->PathGlyphIndexArrayNV = (GLenum APIENTRY (*)(GLuint firstPathName, GLenum fontTarget, const void *fontName, GLbitfield fontStyle, GLuint firstGlyphIndex, GLsizei numGlyphs, GLuint pathParameterTemplate, GLfloat emScale)) ldg_find("glPathGlyphIndexArrayNV", lib);
	GL_CHECK(glp->PathGlyphIndexArrayNV);
	glp->PathGlyphIndexRangeNV = (GLenum APIENTRY (*)(GLenum fontTarget, const void *fontName, GLbitfield fontStyle, GLuint pathParameterTemplate, GLfloat emScale, GLuint *baseAndCount)) ldg_find("glPathGlyphIndexRangeNV", lib);
	GL_CHECK(glp->PathGlyphIndexRangeNV);
	glp->PathMemoryGlyphIndexArrayNV = (GLenum APIENTRY (*)(GLuint firstPathName, GLenum fontTarget, GLsizeiptr fontSize, const void *fontData, GLsizei faceIndex, GLuint firstGlyphIndex, GLsizei numGlyphs, GLuint pathParameterTemplate, GLfloat emScale)) ldg_find("glPathMemoryGlyphIndexArrayNV", lib);
	GL_CHECK(glp->PathMemoryGlyphIndexArrayNV);
	glp->PolygonOffsetClampEXT = (void APIENTRY (*)(GLfloat factor, GLfloat units, GLfloat clamp)) ldg_find("glPolygonOffsetClampEXT", lib);
	GL_CHECK(glp->PolygonOffsetClampEXT);
	glp->ProgramPathFragmentInputGenNV = (void APIENTRY (*)(GLuint program, GLint location, GLenum genMode, GLint components, const GLfloat *coeffs)) ldg_find("glProgramPathFragmentInputGenNV", lib);
	GL_CHECK(glp->ProgramPathFragmentInputGenNV);
	glp->RasterSamplesEXT = (void APIENTRY (*)(GLuint samples, GLboolean32 fixedsamplelocations)) ldg_find("glRasterSamplesEXT", lib);
	GL_CHECK(glp->RasterSamplesEXT);
	glp->ReadnPixels = (void APIENTRY (*)(GLint x, GLint y, GLsizei width, GLsizei height, GLenum format, GLenum type, GLsizei bufSize, void *data)) ldg_find("glReadnPixels", lib);
	GL_CHECK(glp->ReadnPixels);
	glp->ResolveDepthValuesNV = (void APIENTRY (*)(void)) ldg_find("glResolveDepthValuesNV", lib);
	GL_CHECK(glp->ResolveDepthValuesNV);
	glp->StateCaptureNV = (void APIENTRY (*)(GLuint state, GLenum mode)) ldg_find("glStateCaptureNV", lib);
	GL_CHECK(glp->StateCaptureNV);
	glp->StencilThenCoverFillPathInstancedNV = (void APIENTRY (*)(GLsizei numPaths, GLenum pathNameType, const void *paths, GLuint pathBase, GLenum fillMode, GLuint mask, GLenum coverMode, GLenum transformType, const GLfloat *transformValues)) ldg_find("glStencilThenCoverFillPathInstancedNV", lib);
	GL_CHECK(glp->StencilThenCoverFillPathInstancedNV);
	glp->StencilThenCoverFillPathNV = (void APIENTRY (*)(GLuint path, GLenum fillMode, GLuint mask, GLenum coverMode)) ldg_find("glStencilThenCoverFillPathNV", lib);
	GL_CHECK(glp->StencilThenCoverFillPathNV);
	glp->StencilThenCoverStrokePathInstancedNV = (void APIENTRY (*)(GLsizei numPaths, GLenum pathNameType, const void *paths, GLuint pathBase, GLint reference, GLuint mask, GLenum coverMode, GLenum transformType, const GLfloat *transformValues)) ldg_find("glStencilThenCoverStrokePathInstancedNV", lib);
	GL_CHECK(glp->StencilThenCoverStrokePathInstancedNV);
	glp->StencilThenCoverStrokePathNV = (void APIENTRY (*)(GLuint path, GLint reference, GLuint mask, GLenum coverMode)) ldg_find("glStencilThenCoverStrokePathNV", lib);
	GL_CHECK(glp->StencilThenCoverStrokePathNV);
	glp->SubpixelPrecisionBiasNV = (void APIENTRY (*)(GLuint xbits, GLuint ybits)) ldg_find("glSubpixelPrecisionBiasNV", lib);
	GL_CHECK(glp->SubpixelPrecisionBiasNV);
	glp->TextureBarrier = (void APIENTRY (*)(void)) ldg_find("glTextureBarrier", lib);
	GL_CHECK(glp->TextureBarrier);
	glp->TextureBuffer = (void APIENTRY (*)(GLuint texture, GLenum internalformat, GLuint buffer)) ldg_find("glTextureBuffer", lib);
	GL_CHECK(glp->TextureBuffer);
	glp->TextureBufferRange = (void APIENTRY (*)(GLuint texture, GLenum internalformat, GLuint buffer, GLintptr offset, GLsizeiptr size)) ldg_find("glTextureBufferRange", lib);
	GL_CHECK(glp->TextureBufferRange);
	glp->TextureParameterIiv = (void APIENTRY (*)(GLuint texture, GLenum pname, const GLint *params)) ldg_find("glTextureParameterIiv", lib);
	GL_CHECK(glp->TextureParameterIiv);
	glp->TextureParameterIuiv = (void APIENTRY (*)(GLuint texture, GLenum pname, const GLuint *params)) ldg_find("glTextureParameterIuiv", lib);
	GL_CHECK(glp->TextureParameterIuiv);
	glp->TextureParameterf = (void APIENTRY (*)(GLuint texture, GLenum pname, GLfloat param)) ldg_find("glTextureParameterf", lib);
	GL_CHECK(glp->TextureParameterf);
	glp->TextureParameterfv = (void APIENTRY (*)(GLuint texture, GLenum pname, const GLfloat *param)) ldg_find("glTextureParameterfv", lib);
	GL_CHECK(glp->TextureParameterfv);
	glp->TextureParameteri = (void APIENTRY (*)(GLuint texture, GLenum pname, GLint param)) ldg_find("glTextureParameteri", lib);
	GL_CHECK(glp->TextureParameteri);
	glp->TextureParameteriv = (void APIENTRY (*)(GLuint texture, GLenum pname, const GLint *param)) ldg_find("glTextureParameteriv", lib);
	GL_CHECK(glp->TextureParameteriv);
	glp->TextureStorage1D = (void APIENTRY (*)(GLuint texture, GLsizei levels, GLenum internalformat, GLsizei width)) ldg_find("glTextureStorage1D", lib);
	GL_CHECK(glp->TextureStorage1D);
	glp->TextureStorage2D = (void APIENTRY (*)(GLuint texture, GLsizei levels, GLenum internalformat, GLsizei width, GLsizei height)) ldg_find("glTextureStorage2D", lib);
	GL_CHECK(glp->TextureStorage2D);
	glp->TextureStorage2DMultisample = (void APIENTRY (*)(GLuint texture, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height, GLboolean32 fixedsamplelocations)) ldg_find("glTextureStorage2DMultisample", lib);
	GL_CHECK(glp->TextureStorage2DMultisample);
	glp->TextureStorage3D = (void APIENTRY (*)(GLuint texture, GLsizei levels, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth)) ldg_find("glTextureStorage3D", lib);
	GL_CHECK(glp->TextureStorage3D);
	glp->TextureStorage3DMultisample = (void APIENTRY (*)(GLuint texture, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, GLboolean32 fixedsamplelocations)) ldg_find("glTextureStorage3DMultisample", lib);
	GL_CHECK(glp->TextureStorage3DMultisample);
	glp->TextureSubImage1D = (void APIENTRY (*)(GLuint texture, GLint level, GLint xoffset, GLsizei width, GLenum format, GLenum type, const void *pixels)) ldg_find("glTextureSubImage1D", lib);
	GL_CHECK(glp->TextureSubImage1D);
	glp->TextureSubImage2D = (void APIENTRY (*)(GLuint texture, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLenum type, const void *pixels)) ldg_find("glTextureSubImage2D", lib);
	GL_CHECK(glp->TextureSubImage2D);
	glp->TextureSubImage3D = (void APIENTRY (*)(GLuint texture, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLenum type, const void *pixels)) ldg_find("glTextureSubImage3D", lib);
	GL_CHECK(glp->TextureSubImage3D);
	glp->TransformFeedbackBufferBase = (void APIENTRY (*)(GLuint xfb, GLuint index, GLuint buffer)) ldg_find("glTransformFeedbackBufferBase", lib);
	GL_CHECK(glp->TransformFeedbackBufferBase);
	glp->TransformFeedbackBufferRange = (void APIENTRY (*)(GLuint xfb, GLuint index, GLuint buffer, GLintptr offset, GLsizeiptr size)) ldg_find("glTransformFeedbackBufferRange", lib);
	GL_CHECK(glp->TransformFeedbackBufferRange);
	glp->UnmapNamedBuffer = (GLboolean APIENTRY (*)(GLuint buffer)) ldg_find("glUnmapNamedBuffer", lib);
	GL_CHECK(glp->UnmapNamedBuffer);
	glp->VertexArrayAttribBinding = (void APIENTRY (*)(GLuint vaobj, GLuint attribindex, GLuint bindingindex)) ldg_find("glVertexArrayAttribBinding", lib);
	GL_CHECK(glp->VertexArrayAttribBinding);
	glp->VertexArrayAttribFormat = (void APIENTRY (*)(GLuint vaobj, GLuint attribindex, GLint size, GLenum type, GLboolean32 normalized, GLuint relativeoffset)) ldg_find("glVertexArrayAttribFormat", lib);
	GL_CHECK(glp->VertexArrayAttribFormat);
	glp->VertexArrayAttribIFormat = (void APIENTRY (*)(GLuint vaobj, GLuint attribindex, GLint size, GLenum type, GLuint relativeoffset)) ldg_find("glVertexArrayAttribIFormat", lib);
	GL_CHECK(glp->VertexArrayAttribIFormat);
	glp->VertexArrayAttribLFormat = (void APIENTRY (*)(GLuint vaobj, GLuint attribindex, GLint size, GLenum type, GLuint relativeoffset)) ldg_find("glVertexArrayAttribLFormat", lib);
	GL_CHECK(glp->VertexArrayAttribLFormat);
	glp->VertexArrayBindingDivisor = (void APIENTRY (*)(GLuint vaobj, GLuint bindingindex, GLuint divisor)) ldg_find("glVertexArrayBindingDivisor", lib);
	GL_CHECK(glp->VertexArrayBindingDivisor);
	glp->VertexArrayElementBuffer = (void APIENTRY (*)(GLuint vaobj, GLuint buffer)) ldg_find("glVertexArrayElementBuffer", lib);
	GL_CHECK(glp->VertexArrayElementBuffer);
	glp->VertexArrayVertexBuffer = (void APIENTRY (*)(GLuint vaobj, GLuint bindingindex, GLuint buffer, GLintptr offset, GLsizei stride)) ldg_find("glVertexArrayVertexBuffer", lib);
	GL_CHECK(glp->VertexArrayVertexBuffer);
	glp->VertexArrayVertexBuffers = (void APIENTRY (*)(GLuint vaobj, GLuint first, GLsizei count, const GLuint *buffers, const GLintptr *offsets, const GLsizei *strides)) ldg_find("glVertexArrayVertexBuffers", lib);
	GL_CHECK(glp->VertexArrayVertexBuffers);
	glp->OSMesaCreateContextAttribs = (OSMesaContext APIENTRY (*)(const GLint *attribList, OSMesaContext sharelist)) ldg_find("OSMesaCreateContextAttribs", lib);
	GL_CHECK(glp->OSMesaCreateContextAttribs);
	glp->SpecializeShader = (void APIENTRY (*)(GLuint shader, const GLchar *pEntryPoint, GLuint numSpecializationConstants, const GLuint *pConstantIndex, const GLuint *pConstantValue)) ldg_find("glSpecializeShader", lib);
	GL_CHECK(glp->SpecializeShader);
	glp->SpecializeShaderARB = (void APIENTRY (*)(GLuint shader, const GLchar *pEntryPoint, GLuint numSpecializationConstants, const GLuint *pConstantIndex, const GLuint *pConstantValue)) ldg_find("glSpecializeShaderARB", lib);
	GL_CHECK(glp->SpecializeShaderARB);
	glp->MultiDrawArraysIndirectCount = (void APIENTRY (*)(GLenum mode, const void *indirect, GLintptr drawcount, GLsizei maxdrawcount, GLsizei stride)) ldg_find("glMultiDrawArraysIndirectCount", lib);
	GL_CHECK(glp->MultiDrawArraysIndirectCount);
	glp->MultiDrawElementsIndirectCount = (void APIENTRY (*)(GLenum mode, GLenum type, const void *indirect, GLintptr drawcount, GLsizei maxdrawcount, GLsizei stride)) ldg_find("glMultiDrawElementsIndirectCount", lib);
	GL_CHECK(glp->MultiDrawElementsIndirectCount);
	glp->PolygonOffsetClamp = (void APIENTRY (*)(GLfloat factor, GLfloat units, GLfloat clamp)) ldg_find("glPolygonOffsetClamp", lib);
	GL_CHECK(glp->PolygonOffsetClamp);
	glp->PrimitiveBoundingBoxARB = (void APIENTRY (*)(GLfloat minX, GLfloat minY, GLfloat minZ, GLfloat minW, GLfloat maxX, GLfloat maxY, GLfloat maxZ, GLfloat maxW)) ldg_find("glPrimitiveBoundingBoxARB", lib);
	GL_CHECK(glp->PrimitiveBoundingBoxARB);
	glp->Uniform1i64ARB = (void APIENTRY (*)(GLint location, GLint64 x)) ldg_find("glUniform1i64ARB", lib);
	GL_CHECK(glp->Uniform1i64ARB);
	glp->Uniform2i64ARB = (void APIENTRY (*)(GLint location, GLint64 x, GLint64 y)) ldg_find("glUniform2i64ARB", lib);
	GL_CHECK(glp->Uniform2i64ARB);
	glp->Uniform3i64ARB = (void APIENTRY (*)(GLint location, GLint64 x, GLint64 y, GLint64 z)) ldg_find("glUniform3i64ARB", lib);
	GL_CHECK(glp->Uniform3i64ARB);
	glp->Uniform4i64ARB = (void APIENTRY (*)(GLint location, GLint64 x, GLint64 y, GLint64 z, GLint64 w)) ldg_find("glUniform4i64ARB", lib);
	GL_CHECK(glp->Uniform4i64ARB);
	glp->Uniform1i64vARB = (void APIENTRY (*)(GLint location, GLsizei count, const GLint64 *value)) ldg_find("glUniform1i64vARB", lib);
	GL_CHECK(glp->Uniform1i64vARB);
	glp->Uniform2i64vARB = (void APIENTRY (*)(GLint location, GLsizei count, const GLint64 *value)) ldg_find("glUniform2i64vARB", lib);
	GL_CHECK(glp->Uniform2i64vARB);
	glp->Uniform3i64vARB = (void APIENTRY (*)(GLint location, GLsizei count, const GLint64 *value)) ldg_find("glUniform3i64vARB", lib);
	GL_CHECK(glp->Uniform3i64vARB);
	glp->Uniform4i64vARB = (void APIENTRY (*)(GLint location, GLsizei count, const GLint64 *value)) ldg_find("glUniform4i64vARB", lib);
	GL_CHECK(glp->Uniform4i64vARB);
	glp->Uniform1ui64ARB = (void APIENTRY (*)(GLint location, GLuint64 x)) ldg_find("glUniform1ui64ARB", lib);
	GL_CHECK(glp->Uniform1ui64ARB);
	glp->Uniform2ui64ARB = (void APIENTRY (*)(GLint location, GLuint64 x, GLuint64 y)) ldg_find("glUniform2ui64ARB", lib);
	GL_CHECK(glp->Uniform2ui64ARB);
	glp->Uniform3ui64ARB = (void APIENTRY (*)(GLint location, GLuint64 x, GLuint64 y, GLuint64 z)) ldg_find("glUniform3ui64ARB", lib);
	GL_CHECK(glp->Uniform3ui64ARB);
	glp->Uniform4ui64ARB = (void APIENTRY (*)(GLint location, GLuint64 x, GLuint64 y, GLuint64 z, GLuint64 w)) ldg_find("glUniform4ui64ARB", lib);
	GL_CHECK(glp->Uniform4ui64ARB);
	glp->Uniform1ui64vARB = (void APIENTRY (*)(GLint location, GLsizei count, const GLuint64 *value)) ldg_find("glUniform1ui64vARB", lib);
	GL_CHECK(glp->Uniform1ui64vARB);
	glp->Uniform2ui64vARB = (void APIENTRY (*)(GLint location, GLsizei count, const GLuint64 *value)) ldg_find("glUniform2ui64vARB", lib);
	GL_CHECK(glp->Uniform2ui64vARB);
	glp->Uniform3ui64vARB = (void APIENTRY (*)(GLint location, GLsizei count, const GLuint64 *value)) ldg_find("glUniform3ui64vARB", lib);
	GL_CHECK(glp->Uniform3ui64vARB);
	glp->Uniform4ui64vARB = (void APIENTRY (*)(GLint location, GLsizei count, const GLuint64 *value)) ldg_find("glUniform4ui64vARB", lib);
	GL_CHECK(glp->Uniform4ui64vARB);
	glp->GetUniformi64vARB = (void APIENTRY (*)(GLuint program, GLint location, GLint64 *params)) ldg_find("glGetUniformi64vARB", lib);
	GL_CHECK(glp->GetUniformi64vARB);
	glp->GetUniformui64vARB = (void APIENTRY (*)(GLuint program, GLint location, GLuint64 *params)) ldg_find("glGetUniformui64vARB", lib);
	GL_CHECK(glp->GetUniformui64vARB);
	glp->GetnUniformi64vARB = (void APIENTRY (*)(GLuint program, GLint location, GLsizei bufSize, GLint64 *params)) ldg_find("glGetnUniformi64vARB", lib);
	GL_CHECK(glp->GetnUniformi64vARB);
	glp->GetnUniformui64vARB = (void APIENTRY (*)(GLuint program, GLint location, GLsizei bufSize, GLuint64 *params)) ldg_find("glGetnUniformui64vARB", lib);
	GL_CHECK(glp->GetnUniformui64vARB);
	glp->ProgramUniform1i64ARB = (void APIENTRY (*)(GLuint program, GLint location, GLint64 x)) ldg_find("glProgramUniform1i64ARB", lib);
	GL_CHECK(glp->ProgramUniform1i64ARB);
	glp->ProgramUniform2i64ARB = (void APIENTRY (*)(GLuint program, GLint location, GLint64 x, GLint64 y)) ldg_find("glProgramUniform2i64ARB", lib);
	GL_CHECK(glp->ProgramUniform2i64ARB);
	glp->ProgramUniform3i64ARB = (void APIENTRY (*)(GLuint program, GLint location, GLint64 x, GLint64 y, GLint64 z)) ldg_find("glProgramUniform3i64ARB", lib);
	GL_CHECK(glp->ProgramUniform3i64ARB);
	glp->ProgramUniform4i64ARB = (void APIENTRY (*)(GLuint program, GLint location, GLint64 x, GLint64 y, GLint64 z, GLint64 w)) ldg_find("glProgramUniform4i64ARB", lib);
	GL_CHECK(glp->ProgramUniform4i64ARB);
	glp->ProgramUniform1i64vARB = (void APIENTRY (*)(GLuint program, GLint location, GLsizei count, const GLint64 *value)) ldg_find("glProgramUniform1i64vARB", lib);
	GL_CHECK(glp->ProgramUniform1i64vARB);
	glp->ProgramUniform2i64vARB = (void APIENTRY (*)(GLuint program, GLint location, GLsizei count, const GLint64 *value)) ldg_find("glProgramUniform2i64vARB", lib);
	GL_CHECK(glp->ProgramUniform2i64vARB);
	glp->ProgramUniform3i64vARB = (void APIENTRY (*)(GLuint program, GLint location, GLsizei count, const GLint64 *value)) ldg_find("glProgramUniform3i64vARB", lib);
	GL_CHECK(glp->ProgramUniform3i64vARB);
	glp->ProgramUniform4i64vARB = (void APIENTRY (*)(GLuint program, GLint location, GLsizei count, const GLint64 *value)) ldg_find("glProgramUniform4i64vARB", lib);
	GL_CHECK(glp->ProgramUniform4i64vARB);
	glp->ProgramUniform1ui64ARB = (void APIENTRY (*)(GLuint program, GLint location, GLuint64 x)) ldg_find("glProgramUniform1ui64ARB", lib);
	GL_CHECK(glp->ProgramUniform1ui64ARB);
	glp->ProgramUniform2ui64ARB = (void APIENTRY (*)(GLuint program, GLint location, GLuint64 x, GLuint64 y)) ldg_find("glProgramUniform2ui64ARB", lib);
	GL_CHECK(glp->ProgramUniform2ui64ARB);
	glp->ProgramUniform3ui64ARB = (void APIENTRY (*)(GLuint program, GLint location, GLuint64 x, GLuint64 y, GLuint64 z)) ldg_find("glProgramUniform3ui64ARB", lib);
	GL_CHECK(glp->ProgramUniform3ui64ARB);
	glp->ProgramUniform4ui64ARB = (void APIENTRY (*)(GLuint program, GLint location, GLuint64 x, GLuint64 y, GLuint64 z, GLuint64 w)) ldg_find("glProgramUniform4ui64ARB", lib);
	GL_CHECK(glp->ProgramUniform4ui64ARB);
	glp->ProgramUniform1ui64vARB = (void APIENTRY (*)(GLuint program, GLint location, GLsizei count, const GLuint64 *value)) ldg_find("glProgramUniform1ui64vARB", lib);
	GL_CHECK(glp->ProgramUniform1ui64vARB);
	glp->ProgramUniform2ui64vARB = (void APIENTRY (*)(GLuint program, GLint location, GLsizei count, const GLuint64 *value)) ldg_find("glProgramUniform2ui64vARB", lib);
	GL_CHECK(glp->ProgramUniform2ui64vARB);
	glp->ProgramUniform3ui64vARB = (void APIENTRY (*)(GLuint program, GLint location, GLsizei count, const GLuint64 *value)) ldg_find("glProgramUniform3ui64vARB", lib);
	GL_CHECK(glp->ProgramUniform3ui64vARB);
	glp->ProgramUniform4ui64vARB = (void APIENTRY (*)(GLuint program, GLint location, GLsizei count, const GLuint64 *value)) ldg_find("glProgramUniform4ui64vARB", lib);
	GL_CHECK(glp->ProgramUniform4ui64vARB);
	glp->MaxShaderCompilerThreadsARB = (void APIENTRY (*)(GLuint count)) ldg_find("glMaxShaderCompilerThreadsARB", lib);
	GL_CHECK(glp->MaxShaderCompilerThreadsARB);
	glp->FramebufferSampleLocationsfvARB = (void APIENTRY (*)(GLenum target, GLuint start, GLsizei count, const GLfloat *v)) ldg_find("glFramebufferSampleLocationsfvARB", lib);
	GL_CHECK(glp->FramebufferSampleLocationsfvARB);
	glp->NamedFramebufferSampleLocationsfvARB = (void APIENTRY (*)(GLuint framebuffer, GLuint start, GLsizei count, const GLfloat *v)) ldg_find("glNamedFramebufferSampleLocationsfvARB", lib);
	GL_CHECK(glp->NamedFramebufferSampleLocationsfvARB);
	glp->EvaluateDepthValuesARB = (void APIENTRY (*)(void)) ldg_find("glEvaluateDepthValuesARB", lib);
	GL_CHECK(glp->EvaluateDepthValuesARB);
	glp->MaxShaderCompilerThreadsKHR = (void APIENTRY (*)(GLuint count)) ldg_find("glMaxShaderCompilerThreadsKHR", lib);
	GL_CHECK(glp->MaxShaderCompilerThreadsKHR);
	glp->BufferStorageExternalEXT = (void APIENTRY (*)(GLenum target, GLintptr offset, GLsizeiptr size, GLeglClientBufferEXT clientBuffer, GLbitfield flags)) ldg_find("glBufferStorageExternalEXT", lib);
	GL_CHECK(glp->BufferStorageExternalEXT);
	glp->NamedBufferStorageExternalEXT = (void APIENTRY (*)(GLuint buffer, GLintptr offset, GLsizeiptr size, GLeglClientBufferEXT clientBuffer, GLbitfield flags)) ldg_find("glNamedBufferStorageExternalEXT", lib);
	GL_CHECK(glp->NamedBufferStorageExternalEXT);
	glp->GetUnsignedBytevEXT = (void APIENTRY (*)(GLenum pname, GLubyte *data)) ldg_find("glGetUnsignedBytevEXT", lib);
	GL_CHECK(glp->GetUnsignedBytevEXT);
	glp->GetUnsignedBytei_vEXT = (void APIENTRY (*)(GLenum target, GLuint index, GLubyte *data)) ldg_find("glGetUnsignedBytei_vEXT", lib);
	GL_CHECK(glp->GetUnsignedBytei_vEXT);
	glp->DeleteMemoryObjectsEXT = (void APIENTRY (*)(GLsizei n, const GLuint *memoryObjects)) ldg_find("glDeleteMemoryObjectsEXT", lib);
	GL_CHECK(glp->DeleteMemoryObjectsEXT);
	glp->IsMemoryObjectEXT = (GLboolean APIENTRY (*)(GLuint memoryObject)) ldg_find("glIsMemoryObjectEXT", lib);
	GL_CHECK(glp->IsMemoryObjectEXT);
	glp->CreateMemoryObjectsEXT = (void APIENTRY (*)(GLsizei n, GLuint *memoryObjects)) ldg_find("glCreateMemoryObjectsEXT", lib);
	GL_CHECK(glp->CreateMemoryObjectsEXT);
	glp->MemoryObjectParameterivEXT = (void APIENTRY (*)(GLuint memoryObject, GLenum pname, const GLint *params)) ldg_find("glMemoryObjectParameterivEXT", lib);
	GL_CHECK(glp->MemoryObjectParameterivEXT);
	glp->GetMemoryObjectParameterivEXT = (void APIENTRY (*)(GLuint memoryObject, GLenum pname, GLint *params)) ldg_find("glGetMemoryObjectParameterivEXT", lib);
	GL_CHECK(glp->GetMemoryObjectParameterivEXT);
	glp->TexStorageMem2DEXT = (void APIENTRY (*)(GLenum target, GLsizei levels, GLenum internalFormat, GLsizei width, GLsizei height, GLuint memory, GLuint64 offset)) ldg_find("glTexStorageMem2DEXT", lib);
	GL_CHECK(glp->TexStorageMem2DEXT);
	glp->TexStorageMem2DMultisampleEXT = (void APIENTRY (*)(GLenum target, GLsizei samples, GLenum internalFormat, GLsizei width, GLsizei height, GLboolean32 fixedSampleLocations, GLuint memory, GLuint64 offset)) ldg_find("glTexStorageMem2DMultisampleEXT", lib);
	GL_CHECK(glp->TexStorageMem2DMultisampleEXT);
	glp->TexStorageMem3DEXT = (void APIENTRY (*)(GLenum target, GLsizei levels, GLenum internalFormat, GLsizei width, GLsizei height, GLsizei depth, GLuint memory, GLuint64 offset)) ldg_find("glTexStorageMem3DEXT", lib);
	GL_CHECK(glp->TexStorageMem3DEXT);
	glp->TexStorageMem3DMultisampleEXT = (void APIENTRY (*)(GLenum target, GLsizei samples, GLenum internalFormat, GLsizei width, GLsizei height, GLsizei depth, GLboolean32 fixedSampleLocations, GLuint memory, GLuint64 offset)) ldg_find("glTexStorageMem3DMultisampleEXT", lib);
	GL_CHECK(glp->TexStorageMem3DMultisampleEXT);
	glp->BufferStorageMemEXT = (void APIENTRY (*)(GLenum target, GLsizeiptr size, GLuint memory, GLuint64 offset)) ldg_find("glBufferStorageMemEXT", lib);
	GL_CHECK(glp->BufferStorageMemEXT);
	glp->TextureStorageMem2DEXT = (void APIENTRY (*)(GLuint texture, GLsizei levels, GLenum internalFormat, GLsizei width, GLsizei height, GLuint memory, GLuint64 offset)) ldg_find("glTextureStorageMem2DEXT", lib);
	GL_CHECK(glp->TextureStorageMem2DEXT);
	glp->TextureStorageMem2DMultisampleEXT = (void APIENTRY (*)(GLuint texture, GLsizei samples, GLenum internalFormat, GLsizei width, GLsizei height, GLboolean32 fixedSampleLocations, GLuint memory, GLuint64 offset)) ldg_find("glTextureStorageMem2DMultisampleEXT", lib);
	GL_CHECK(glp->TextureStorageMem2DMultisampleEXT);
	glp->TextureStorageMem3DEXT = (void APIENTRY (*)(GLuint texture, GLsizei levels, GLenum internalFormat, GLsizei width, GLsizei height, GLsizei depth, GLuint memory, GLuint64 offset)) ldg_find("glTextureStorageMem3DEXT", lib);
	GL_CHECK(glp->TextureStorageMem3DEXT);
	glp->TextureStorageMem3DMultisampleEXT = (void APIENTRY (*)(GLuint texture, GLsizei samples, GLenum internalFormat, GLsizei width, GLsizei height, GLsizei depth, GLboolean32 fixedSampleLocations, GLuint memory, GLuint64 offset)) ldg_find("glTextureStorageMem3DMultisampleEXT", lib);
	GL_CHECK(glp->TextureStorageMem3DMultisampleEXT);
	glp->NamedBufferStorageMemEXT = (void APIENTRY (*)(GLuint buffer, GLsizeiptr size, GLuint memory, GLuint64 offset)) ldg_find("glNamedBufferStorageMemEXT", lib);
	GL_CHECK(glp->NamedBufferStorageMemEXT);
	glp->TexStorageMem1DEXT = (void APIENTRY (*)(GLenum target, GLsizei levels, GLenum internalFormat, GLsizei width, GLuint memory, GLuint64 offset)) ldg_find("glTexStorageMem1DEXT", lib);
	GL_CHECK(glp->TexStorageMem1DEXT);
	glp->TextureStorageMem1DEXT = (void APIENTRY (*)(GLuint texture, GLsizei levels, GLenum internalFormat, GLsizei width, GLuint memory, GLuint64 offset)) ldg_find("glTextureStorageMem1DEXT", lib);
	GL_CHECK(glp->TextureStorageMem1DEXT);
	glp->ImportMemoryFdEXT = (void APIENTRY (*)(GLuint memory, GLuint64 size, GLenum handleType, GLint fd)) ldg_find("glImportMemoryFdEXT", lib);
	GL_CHECK(glp->ImportMemoryFdEXT);
	glp->ImportMemoryWin32HandleEXT = (void APIENTRY (*)(GLuint memory, GLuint64 size, GLenum handleType, void *handle)) ldg_find("glImportMemoryWin32HandleEXT", lib);
	GL_CHECK(glp->ImportMemoryWin32HandleEXT);
	glp->ImportMemoryWin32NameEXT = (void APIENTRY (*)(GLuint memory, GLuint64 size, GLenum handleType, const void *name)) ldg_find("glImportMemoryWin32NameEXT", lib);
	GL_CHECK(glp->ImportMemoryWin32NameEXT);
	glp->GenSemaphoresEXT = (void APIENTRY (*)(GLsizei n, GLuint *semaphores)) ldg_find("glGenSemaphoresEXT", lib);
	GL_CHECK(glp->GenSemaphoresEXT);
	glp->DeleteSemaphoresEXT = (void APIENTRY (*)(GLsizei n, const GLuint *semaphores)) ldg_find("glDeleteSemaphoresEXT", lib);
	GL_CHECK(glp->DeleteSemaphoresEXT);
	glp->IsSemaphoreEXT = (GLboolean APIENTRY (*)(GLuint semaphore)) ldg_find("glIsSemaphoreEXT", lib);
	GL_CHECK(glp->IsSemaphoreEXT);
	glp->SemaphoreParameterui64vEXT = (void APIENTRY (*)(GLuint semaphore, GLenum pname, const GLuint64 *params)) ldg_find("glSemaphoreParameterui64vEXT", lib);
	GL_CHECK(glp->SemaphoreParameterui64vEXT);
	glp->GetSemaphoreParameterui64vEXT = (void APIENTRY (*)(GLuint semaphore, GLenum pname, GLuint64 *params)) ldg_find("glGetSemaphoreParameterui64vEXT", lib);
	GL_CHECK(glp->GetSemaphoreParameterui64vEXT);
	glp->WaitSemaphoreEXT = (void APIENTRY (*)(GLuint semaphore, GLuint numBufferBarriers, const GLuint *buffers, GLuint numTextureBarriers, const GLuint *textures, const GLenum *srcLayouts)) ldg_find("glWaitSemaphoreEXT", lib);
	GL_CHECK(glp->WaitSemaphoreEXT);
	glp->SignalSemaphoreEXT = (void APIENTRY (*)(GLuint semaphore, GLuint numBufferBarriers, const GLuint *buffers, GLuint numTextureBarriers, const GLuint *textures, const GLenum *dstLayouts)) ldg_find("glSignalSemaphoreEXT", lib);
	GL_CHECK(glp->SignalSemaphoreEXT);
	glp->ImportSemaphoreFdEXT = (void APIENTRY (*)(GLuint semaphore, GLenum handleType, GLint fd)) ldg_find("glImportSemaphoreFdEXT", lib);
	GL_CHECK(glp->ImportSemaphoreFdEXT);
	glp->ImportSemaphoreWin32HandleEXT = (void APIENTRY (*)(GLuint semaphore, GLenum handleType, void *handle)) ldg_find("glImportSemaphoreWin32HandleEXT", lib);
	GL_CHECK(glp->ImportSemaphoreWin32HandleEXT);
	glp->ImportSemaphoreWin32NameEXT = (void APIENTRY (*)(GLuint semaphore, GLenum handleType, const void *name)) ldg_find("glImportSemaphoreWin32NameEXT", lib);
	GL_CHECK(glp->ImportSemaphoreWin32NameEXT);
	glp->AcquireKeyedMutexWin32EXT = (GLboolean APIENTRY (*)(GLuint memory, GLuint64 key, GLuint timeout)) ldg_find("glAcquireKeyedMutexWin32EXT", lib);
	GL_CHECK(glp->AcquireKeyedMutexWin32EXT);
	glp->ReleaseKeyedMutexWin32EXT = (GLboolean APIENTRY (*)(GLuint memory, GLuint64 key)) ldg_find("glReleaseKeyedMutexWin32EXT", lib);
	GL_CHECK(glp->ReleaseKeyedMutexWin32EXT);
	glp->LGPUNamedBufferSubDataNVX = (void APIENTRY (*)(GLbitfield gpuMask, GLuint buffer, GLintptr offset, GLsizeiptr size, const void *data)) ldg_find("glLGPUNamedBufferSubDataNVX", lib);
	GL_CHECK(glp->LGPUNamedBufferSubDataNVX);
	glp->LGPUCopyImageSubDataNVX = (void APIENTRY (*)(GLuint sourceGpu, GLbitfield destinationGpuMask, GLuint srcName, GLenum srcTarget, GLint srcLevel, GLint srcX, GLint srxY, GLint srcZ, GLuint dstName, GLenum dstTarget, GLint dstLevel, GLint dstX, GLint dstY, GLint dstZ, GLsizei width, GLsizei height, GLsizei depth)) ldg_find("glLGPUCopyImageSubDataNVX", lib);
	GL_CHECK(glp->LGPUCopyImageSubDataNVX);
	glp->LGPUInterlockNVX = (void APIENTRY (*)(void)) ldg_find("glLGPUInterlockNVX", lib);
	GL_CHECK(glp->LGPUInterlockNVX);
	glp->AlphaToCoverageDitherControlNV = (void APIENTRY (*)(GLenum mode)) ldg_find("glAlphaToCoverageDitherControlNV", lib);
	GL_CHECK(glp->AlphaToCoverageDitherControlNV);
	glp->DrawVkImageNV = (void APIENTRY (*)(GLuint64 vkImage, GLuint sampler, GLfloat x0, GLfloat y0, GLfloat x1, GLfloat y1, GLfloat z, GLfloat s0, GLfloat t0, GLfloat s1, GLfloat t1)) ldg_find("glDrawVkImageNV", lib);
	GL_CHECK(glp->DrawVkImageNV);
	glp->GetVkProcAddrNV = (GLVULKANPROCNV APIENTRY (*)(const GLchar *name)) ldg_find("glGetVkProcAddrNV", lib);
	GL_CHECK(glp->GetVkProcAddrNV);
	glp->WaitVkSemaphoreNV = (void APIENTRY (*)(GLuint64 vkSemaphore)) ldg_find("glWaitVkSemaphoreNV", lib);
	GL_CHECK(glp->WaitVkSemaphoreNV);
	glp->SignalVkSemaphoreNV = (void APIENTRY (*)(GLuint64 vkSemaphore)) ldg_find("glSignalVkSemaphoreNV", lib);
	GL_CHECK(glp->SignalVkSemaphoreNV);
	glp->SignalVkFenceNV = (void APIENTRY (*)(GLuint64 vkFence)) ldg_find("glSignalVkFenceNV", lib);
	GL_CHECK(glp->SignalVkFenceNV);
	glp->RenderGpuMaskNV = (void APIENTRY (*)(GLbitfield mask)) ldg_find("glRenderGpuMaskNV", lib);
	GL_CHECK(glp->RenderGpuMaskNV);
	glp->MulticastBufferSubDataNV = (void APIENTRY (*)(GLbitfield gpuMask, GLuint buffer, GLintptr offset, GLsizeiptr size, const void *data)) ldg_find("glMulticastBufferSubDataNV", lib);
	GL_CHECK(glp->MulticastBufferSubDataNV);
	glp->MulticastCopyBufferSubDataNV = (void APIENTRY (*)(GLuint readGpu, GLbitfield writeGpuMask, GLuint readBuffer, GLuint writeBuffer, GLintptr readOffset, GLintptr writeOffset, GLsizeiptr size)) ldg_find("glMulticastCopyBufferSubDataNV", lib);
	GL_CHECK(glp->MulticastCopyBufferSubDataNV);
	glp->MulticastCopyImageSubDataNV = (void APIENTRY (*)(GLuint srcGpu, GLbitfield dstGpuMask, GLuint srcName, GLenum srcTarget, GLint srcLevel, GLint srcX, GLint srcY, GLint srcZ, GLuint dstName, GLenum dstTarget, GLint dstLevel, GLint dstX, GLint dstY, GLint dstZ, GLsizei srcWidth, GLsizei srcHeight, GLsizei srcDepth)) ldg_find("glMulticastCopyImageSubDataNV", lib);
	GL_CHECK(glp->MulticastCopyImageSubDataNV);
	glp->MulticastBlitFramebufferNV = (void APIENTRY (*)(GLuint srcGpu, GLuint dstGpu, GLint srcX0, GLint srcY0, GLint srcX1, GLint srcY1, GLint dstX0, GLint dstY0, GLint dstX1, GLint dstY1, GLbitfield mask, GLenum filter)) ldg_find("glMulticastBlitFramebufferNV", lib);
	GL_CHECK(glp->MulticastBlitFramebufferNV);
	glp->MulticastFramebufferSampleLocationsfvNV = (void APIENTRY (*)(GLuint gpu, GLuint framebuffer, GLuint start, GLsizei count, const GLfloat *v)) ldg_find("glMulticastFramebufferSampleLocationsfvNV", lib);
	GL_CHECK(glp->MulticastFramebufferSampleLocationsfvNV);
	glp->MulticastBarrierNV = (void APIENTRY (*)(void)) ldg_find("glMulticastBarrierNV", lib);
	GL_CHECK(glp->MulticastBarrierNV);
	glp->MulticastWaitSyncNV = (void APIENTRY (*)(GLuint signalGpu, GLbitfield waitGpuMask)) ldg_find("glMulticastWaitSyncNV", lib);
	GL_CHECK(glp->MulticastWaitSyncNV);
	glp->MulticastGetQueryObjectivNV = (void APIENTRY (*)(GLuint gpu, GLuint id, GLenum pname, GLint *params)) ldg_find("glMulticastGetQueryObjectivNV", lib);
	GL_CHECK(glp->MulticastGetQueryObjectivNV);
	glp->MulticastGetQueryObjectuivNV = (void APIENTRY (*)(GLuint gpu, GLuint id, GLenum pname, GLuint *params)) ldg_find("glMulticastGetQueryObjectuivNV", lib);
	GL_CHECK(glp->MulticastGetQueryObjectuivNV);
	glp->MulticastGetQueryObjecti64vNV = (void APIENTRY (*)(GLuint gpu, GLuint id, GLenum pname, GLint64 *params)) ldg_find("glMulticastGetQueryObjecti64vNV", lib);
	GL_CHECK(glp->MulticastGetQueryObjecti64vNV);
	glp->MulticastGetQueryObjectui64vNV = (void APIENTRY (*)(GLuint gpu, GLuint id, GLenum pname, GLuint64 *params)) ldg_find("glMulticastGetQueryObjectui64vNV", lib);
	GL_CHECK(glp->MulticastGetQueryObjectui64vNV);
	glp->QueryResourceNV = (GLint APIENTRY (*)(GLenum queryType, GLint tagId, GLuint bufSize, GLint *buffer)) ldg_find("glQueryResourceNV", lib);
	GL_CHECK(glp->QueryResourceNV);
	glp->GenQueryResourceTagNV = (void APIENTRY (*)(GLsizei n, GLint *tagIds)) ldg_find("glGenQueryResourceTagNV", lib);
	GL_CHECK(glp->GenQueryResourceTagNV);
	glp->DeleteQueryResourceTagNV = (void APIENTRY (*)(GLsizei n, const GLint *tagIds)) ldg_find("glDeleteQueryResourceTagNV", lib);
	GL_CHECK(glp->DeleteQueryResourceTagNV);
	glp->QueryResourceTagNV = (void APIENTRY (*)(GLint tagId, const GLchar *tagString)) ldg_find("glQueryResourceTagNV", lib);
	GL_CHECK(glp->QueryResourceTagNV);
	glp->FramebufferSamplePositionsfvAMD = (void APIENTRY (*)(GLenum target, GLuint numsamples, GLuint pixelindex, const GLfloat *values)) ldg_find("glFramebufferSamplePositionsfvAMD", lib);
	GL_CHECK(glp->FramebufferSamplePositionsfvAMD);
	glp->NamedFramebufferSamplePositionsfvAMD = (void APIENTRY (*)(GLuint framebuffer, GLuint numsamples, GLuint pixelindex, const GLfloat *values)) ldg_find("glNamedFramebufferSamplePositionsfvAMD", lib);
	GL_CHECK(glp->NamedFramebufferSamplePositionsfvAMD);
	glp->GetFramebufferParameterfvAMD = (void APIENTRY (*)(GLenum target, GLenum pname, GLuint numsamples, GLuint pixelindex, GLsizei size, GLfloat *values)) ldg_find("glGetFramebufferParameterfvAMD", lib);
	GL_CHECK(glp->GetFramebufferParameterfvAMD);
	glp->GetNamedFramebufferParameterfvAMD = (void APIENTRY (*)(GLuint framebuffer, GLenum pname, GLuint numsamples, GLuint pixelindex, GLsizei size, GLfloat *values)) ldg_find("glGetNamedFramebufferParameterfvAMD", lib);
	GL_CHECK(glp->GetNamedFramebufferParameterfvAMD);
	glp->WindowRectanglesEXT = (void APIENTRY (*)(GLenum mode, GLsizei count, const GLint *box)) ldg_find("glWindowRectanglesEXT", lib);
	GL_CHECK(glp->WindowRectanglesEXT);
	glp->ApplyFramebufferAttachmentCMAAINTEL = (void APIENTRY (*)(void)) ldg_find("glApplyFramebufferAttachmentCMAAINTEL", lib);
	GL_CHECK(glp->ApplyFramebufferAttachmentCMAAINTEL);
	glp->ViewportSwizzleNV = (void APIENTRY (*)(GLuint index, GLenum swizzlex, GLenum swizzley, GLenum swizzlez, GLenum swizzlew)) ldg_find("glViewportSwizzleNV", lib);
	GL_CHECK(glp->ViewportSwizzleNV);
	glp->ViewportPositionWScaleNV = (void APIENTRY (*)(GLuint index, GLfloat xcoeff, GLfloat ycoeff)) ldg_find("glViewportPositionWScaleNV", lib);
	GL_CHECK(glp->ViewportPositionWScaleNV);
	glp->ConservativeRasterParameterfNV = (void APIENTRY (*)(GLenum pname, GLfloat value)) ldg_find("glConservativeRasterParameterfNV", lib);
	GL_CHECK(glp->ConservativeRasterParameterfNV);
	glp->ConservativeRasterParameteriNV = (void APIENTRY (*)(GLenum pname, GLint param)) ldg_find("glConservativeRasterParameteriNV", lib);
	GL_CHECK(glp->ConservativeRasterParameteriNV);
	gl.__numfuncs = 3034;
	gl.__old_OSMesaGetProcAddress = gl.OSMesaGetProcAddress;
	gl.OSMesaGetProcAddress = real_OSMesaGetProcAddress;
	return result;
}
#undef GL_CHECK


struct gl_public *ldg_load_osmesa(const char *libname, _WORD *gl)
{
	LDG *lib;
	struct gl_public *pub = NULL;
	size_t len;
	
	if (libname == NULL)
		libname = "osmesa.ldg";
	if (gl == NULL)
		gl = ldg_global;
	lib = ldg_open(libname, gl);
	if (lib != NULL)
	{
		long APIENTRY (*glInit)(void *) = (long APIENTRY (*)(void *))ldg_find("glInit", lib);
		if (glInit)
		{
			len = (*glInit)(NULL);
		} else
		{
			len = sizeof(*pub);
		}
		pub = (struct gl_public *)calloc(1, len);
		if (pub)
		{
			pub->m_alloc = malloc;
			pub->m_free = free;
			if (glInit)
				(*glInit)(pub);
			pub->libhandle = lib;
			ldg_init_osmesa(lib);
		} else
		{
			ldg_close(lib, gl);
		}
	}
	return pub;
}


void ldg_unload_osmesa(struct gl_public *pub, _WORD *gl)
{
	if (pub != NULL)
	{
		if (pub->libhandle != NULL)
		{
			if (gl == NULL)
				gl = ldg_global;
			ldg_close((LDG *)pub->libhandle, gl);
		}
		pub->m_free(pub);
	}
}


#ifdef TEST

#include <stdio.h>
#include <stdlib.h>

int main(void)
{
	struct gl_public *pub;
	OSMESAproc p;
	OSMesaContext ctx;
	void *buffer;
	int width = 32;
	int height = 32;
	
	pub = ldg_load_osmesa(0, 0);
	if (pub == NULL)
		pub = ldg_load_osmesa("c:/gemsys/ldg/osmesa.ldg", 0);
	if (pub == NULL)
	{
		fprintf(stderr, "osmesa.ldg not found\n");
		return 1;
	}
	ctx = gl.OSMesaCreateContextExt(OSMESA_RGB, 16, 0, 0, NULL);
	if (ctx == NULL)
	{
		fprintf(stderr, "can't create context\n");
		return 1;
	}
	buffer = malloc(width * height * 4);
	gl.OSMesaMakeCurrent(ctx, buffer, OSMESA_RGB, width, height);
	printf("GL_RENDERER   = %s\n", (const char *) gl.GetString(GL_RENDERER));
	printf("GL_VERSION    = %s\n", (const char *) gl.GetString(GL_VERSION));
	printf("GL_VENDOR     = %s\n", (const char *) gl.GetString(GL_VENDOR));
	printf("GL_EXTENSIONS = %s\n", (const char *) gl.GetString(GL_EXTENSIONS));
	p = gl.OSMesaGetProcAddress("OSMesaColorClamp");
	printf("OSMesaColorClamp              : %p\n", p);
	p = gl.OSMesaGetProcAddress("OSMesaCreateContext");
	printf("OSMesaCreateContext           : %p\n", p);
	p = gl.OSMesaGetProcAddress("OSMesaCreateContextAttribs");
	printf("OSMesaCreateContextAttribs    : %p\n", p);
	p = gl.OSMesaGetProcAddress("OSMesaCreateContextExt");
	printf("OSMesaCreateContextExt        : %p\n", p);
	p = gl.OSMesaGetProcAddress("OSMesaCreateLDG");
	printf("OSMesaCreateLDG               : %p\n", p);
	p = gl.OSMesaGetProcAddress("OSMesaDestroyContext");
	printf("OSMesaDestroyContext          : %p\n", p);
	p = gl.OSMesaGetProcAddress("OSMesaDestroyLDG");
	printf("OSMesaDestroyLDG              : %p\n", p);
	p = gl.OSMesaGetProcAddress("OSMesaGetColorBuffer");
	printf("OSMesaGetColorBuffer          : %p\n", p);
	p = gl.OSMesaGetProcAddress("OSMesaGetCurrentContext");
	printf("OSMesaGetCurrentContext       : %p\n", p);
	p = gl.OSMesaGetProcAddress("OSMesaGetDepthBuffer");
	printf("OSMesaGetDepthBuffer          : %p\n", p);
	p = gl.OSMesaGetProcAddress("OSMesaGetIntegerv");
	printf("OSMesaGetIntegerv             : %p\n", p);
	p = gl.OSMesaGetProcAddress("OSMesaGetProcAddress");
	printf("OSMesaGetProcAddress          : %p\n", p);
	p = gl.OSMesaGetProcAddress("OSMesaMakeCurrent");
	printf("OSMesaMakeCurrent             : %p\n", p);
	p = gl.OSMesaGetProcAddress("OSMesaPixelStore");
	printf("OSMesaPixelStore              : %p\n", p);
	p = gl.OSMesaGetProcAddress("OSMesaPostprocess");
	printf("OSMesaPostprocess             : %p\n", p);
	p = gl.OSMesaGetProcAddress("exception_error");
	printf("exception_error               : %p\n", p);
	p = gl.OSMesaGetProcAddress("glAccum");
	printf("glAccum                       : %p\n", p);
	p = gl.OSMesaGetProcAddress("glAccumxOES");
	printf("glAccumxOES                   : %p\n", p);
	p = gl.OSMesaGetProcAddress("glAcquireKeyedMutexWin32EXT");
	printf("glAcquireKeyedMutexWin32EXT   : %p\n", p);
	p = gl.OSMesaGetProcAddress("glActiveProgramEXT");
	printf("glActiveProgramEXT            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glActiveShaderProgram");
	printf("glActiveShaderProgram         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glActiveStencilFaceEXT");
	printf("glActiveStencilFaceEXT        : %p\n", p);
	p = gl.OSMesaGetProcAddress("glActiveTexture");
	printf("glActiveTexture               : %p\n", p);
	p = gl.OSMesaGetProcAddress("glActiveTextureARB");
	printf("glActiveTextureARB            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glActiveVaryingNV");
	printf("glActiveVaryingNV             : %p\n", p);
	p = gl.OSMesaGetProcAddress("glAddSwapHintRectWIN");
	printf("glAddSwapHintRectWIN          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glAlphaFragmentOp1ATI");
	printf("glAlphaFragmentOp1ATI         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glAlphaFragmentOp2ATI");
	printf("glAlphaFragmentOp2ATI         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glAlphaFragmentOp3ATI");
	printf("glAlphaFragmentOp3ATI         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glAlphaFunc");
	printf("glAlphaFunc                   : %p\n", p);
	p = gl.OSMesaGetProcAddress("glAlphaFuncxOES");
	printf("glAlphaFuncxOES               : %p\n", p);
	p = gl.OSMesaGetProcAddress("glAlphaToCoverageDitherControlNV");
	printf("glAlphaToCoverageDitherControlNV: %p\n", p);
	p = gl.OSMesaGetProcAddress("glApplyFramebufferAttachmentCMAAINTEL");
	printf("glApplyFramebufferAttachmentCMAAINTEL: %p\n", p);
	p = gl.OSMesaGetProcAddress("glApplyTextureEXT");
	printf("glApplyTextureEXT             : %p\n", p);
	p = gl.OSMesaGetProcAddress("glAreProgramsResidentNV");
	printf("glAreProgramsResidentNV       : %p\n", p);
	p = gl.OSMesaGetProcAddress("glAreTexturesResident");
	printf("glAreTexturesResident         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glAreTexturesResidentEXT");
	printf("glAreTexturesResidentEXT      : %p\n", p);
	p = gl.OSMesaGetProcAddress("glArrayElement");
	printf("glArrayElement                : %p\n", p);
	p = gl.OSMesaGetProcAddress("glArrayElementEXT");
	printf("glArrayElementEXT             : %p\n", p);
	p = gl.OSMesaGetProcAddress("glArrayObjectATI");
	printf("glArrayObjectATI              : %p\n", p);
	p = gl.OSMesaGetProcAddress("glAsyncMarkerSGIX");
	printf("glAsyncMarkerSGIX             : %p\n", p);
	p = gl.OSMesaGetProcAddress("glAttachObjectARB");
	printf("glAttachObjectARB             : %p\n", p);
	p = gl.OSMesaGetProcAddress("glAttachShader");
	printf("glAttachShader                : %p\n", p);
	p = gl.OSMesaGetProcAddress("glBegin");
	printf("glBegin                       : %p\n", p);
	p = gl.OSMesaGetProcAddress("glBeginConditionalRender");
	printf("glBeginConditionalRender      : %p\n", p);
	p = gl.OSMesaGetProcAddress("glBeginConditionalRenderNV");
	printf("glBeginConditionalRenderNV    : %p\n", p);
	p = gl.OSMesaGetProcAddress("glBeginConditionalRenderNVX");
	printf("glBeginConditionalRenderNVX   : %p\n", p);
	p = gl.OSMesaGetProcAddress("glBeginFragmentShaderATI");
	printf("glBeginFragmentShaderATI      : %p\n", p);
	p = gl.OSMesaGetProcAddress("glBeginOcclusionQueryNV");
	printf("glBeginOcclusionQueryNV       : %p\n", p);
	p = gl.OSMesaGetProcAddress("glBeginPerfMonitorAMD");
	printf("glBeginPerfMonitorAMD         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glBeginPerfQueryINTEL");
	printf("glBeginPerfQueryINTEL         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glBeginQuery");
	printf("glBeginQuery                  : %p\n", p);
	p = gl.OSMesaGetProcAddress("glBeginQueryARB");
	printf("glBeginQueryARB               : %p\n", p);
	p = gl.OSMesaGetProcAddress("glBeginQueryIndexed");
	printf("glBeginQueryIndexed           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glBeginTransformFeedback");
	printf("glBeginTransformFeedback      : %p\n", p);
	p = gl.OSMesaGetProcAddress("glBeginTransformFeedbackEXT");
	printf("glBeginTransformFeedbackEXT   : %p\n", p);
	p = gl.OSMesaGetProcAddress("glBeginTransformFeedbackNV");
	printf("glBeginTransformFeedbackNV    : %p\n", p);
	p = gl.OSMesaGetProcAddress("glBeginVertexShaderEXT");
	printf("glBeginVertexShaderEXT        : %p\n", p);
	p = gl.OSMesaGetProcAddress("glBeginVideoCaptureNV");
	printf("glBeginVideoCaptureNV         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glBindAttribLocation");
	printf("glBindAttribLocation          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glBindAttribLocationARB");
	printf("glBindAttribLocationARB       : %p\n", p);
	p = gl.OSMesaGetProcAddress("glBindBuffer");
	printf("glBindBuffer                  : %p\n", p);
	p = gl.OSMesaGetProcAddress("glBindBufferARB");
	printf("glBindBufferARB               : %p\n", p);
	p = gl.OSMesaGetProcAddress("glBindBufferBase");
	printf("glBindBufferBase              : %p\n", p);
	p = gl.OSMesaGetProcAddress("glBindBufferBaseEXT");
	printf("glBindBufferBaseEXT           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glBindBufferBaseNV");
	printf("glBindBufferBaseNV            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glBindBufferOffsetEXT");
	printf("glBindBufferOffsetEXT         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glBindBufferOffsetNV");
	printf("glBindBufferOffsetNV          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glBindBufferRange");
	printf("glBindBufferRange             : %p\n", p);
	p = gl.OSMesaGetProcAddress("glBindBufferRangeEXT");
	printf("glBindBufferRangeEXT          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glBindBufferRangeNV");
	printf("glBindBufferRangeNV           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glBindBuffersBase");
	printf("glBindBuffersBase             : %p\n", p);
	p = gl.OSMesaGetProcAddress("glBindBuffersRange");
	printf("glBindBuffersRange            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glBindFragDataLocation");
	printf("glBindFragDataLocation        : %p\n", p);
	p = gl.OSMesaGetProcAddress("glBindFragDataLocationEXT");
	printf("glBindFragDataLocationEXT     : %p\n", p);
	p = gl.OSMesaGetProcAddress("glBindFragDataLocationIndexed");
	printf("glBindFragDataLocationIndexed : %p\n", p);
	p = gl.OSMesaGetProcAddress("glBindFragmentShaderATI");
	printf("glBindFragmentShaderATI       : %p\n", p);
	p = gl.OSMesaGetProcAddress("glBindFramebuffer");
	printf("glBindFramebuffer             : %p\n", p);
	p = gl.OSMesaGetProcAddress("glBindFramebufferEXT");
	printf("glBindFramebufferEXT          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glBindImageTexture");
	printf("glBindImageTexture            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glBindImageTextureEXT");
	printf("glBindImageTextureEXT         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glBindImageTextures");
	printf("glBindImageTextures           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glBindLightParameterEXT");
	printf("glBindLightParameterEXT       : %p\n", p);
	p = gl.OSMesaGetProcAddress("glBindMaterialParameterEXT");
	printf("glBindMaterialParameterEXT    : %p\n", p);
	p = gl.OSMesaGetProcAddress("glBindMultiTextureEXT");
	printf("glBindMultiTextureEXT         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glBindParameterEXT");
	printf("glBindParameterEXT            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glBindProgramARB");
	printf("glBindProgramARB              : %p\n", p);
	p = gl.OSMesaGetProcAddress("glBindProgramNV");
	printf("glBindProgramNV               : %p\n", p);
	p = gl.OSMesaGetProcAddress("glBindProgramPipeline");
	printf("glBindProgramPipeline         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glBindRenderbuffer");
	printf("glBindRenderbuffer            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glBindRenderbufferEXT");
	printf("glBindRenderbufferEXT         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glBindSampler");
	printf("glBindSampler                 : %p\n", p);
	p = gl.OSMesaGetProcAddress("glBindSamplers");
	printf("glBindSamplers                : %p\n", p);
	p = gl.OSMesaGetProcAddress("glBindTexGenParameterEXT");
	printf("glBindTexGenParameterEXT      : %p\n", p);
	p = gl.OSMesaGetProcAddress("glBindTexture");
	printf("glBindTexture                 : %p\n", p);
	p = gl.OSMesaGetProcAddress("glBindTextureEXT");
	printf("glBindTextureEXT              : %p\n", p);
	p = gl.OSMesaGetProcAddress("glBindTextureUnit");
	printf("glBindTextureUnit             : %p\n", p);
	p = gl.OSMesaGetProcAddress("glBindTextureUnitParameterEXT");
	printf("glBindTextureUnitParameterEXT : %p\n", p);
	p = gl.OSMesaGetProcAddress("glBindTextures");
	printf("glBindTextures                : %p\n", p);
	p = gl.OSMesaGetProcAddress("glBindTransformFeedback");
	printf("glBindTransformFeedback       : %p\n", p);
	p = gl.OSMesaGetProcAddress("glBindTransformFeedbackNV");
	printf("glBindTransformFeedbackNV     : %p\n", p);
	p = gl.OSMesaGetProcAddress("glBindVertexArray");
	printf("glBindVertexArray             : %p\n", p);
	p = gl.OSMesaGetProcAddress("glBindVertexArrayAPPLE");
	printf("glBindVertexArrayAPPLE        : %p\n", p);
	p = gl.OSMesaGetProcAddress("glBindVertexBuffer");
	printf("glBindVertexBuffer            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glBindVertexBuffers");
	printf("glBindVertexBuffers           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glBindVertexShaderEXT");
	printf("glBindVertexShaderEXT         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glBindVideoCaptureStreamBufferNV");
	printf("glBindVideoCaptureStreamBufferNV: %p\n", p);
	p = gl.OSMesaGetProcAddress("glBindVideoCaptureStreamTextureNV");
	printf("glBindVideoCaptureStreamTextureNV: %p\n", p);
	p = gl.OSMesaGetProcAddress("glBinormal3bEXT");
	printf("glBinormal3bEXT               : %p\n", p);
	p = gl.OSMesaGetProcAddress("glBinormal3bvEXT");
	printf("glBinormal3bvEXT              : %p\n", p);
	p = gl.OSMesaGetProcAddress("glBinormal3dEXT");
	printf("glBinormal3dEXT               : %p\n", p);
	p = gl.OSMesaGetProcAddress("glBinormal3dvEXT");
	printf("glBinormal3dvEXT              : %p\n", p);
	p = gl.OSMesaGetProcAddress("glBinormal3fEXT");
	printf("glBinormal3fEXT               : %p\n", p);
	p = gl.OSMesaGetProcAddress("glBinormal3fvEXT");
	printf("glBinormal3fvEXT              : %p\n", p);
	p = gl.OSMesaGetProcAddress("glBinormal3iEXT");
	printf("glBinormal3iEXT               : %p\n", p);
	p = gl.OSMesaGetProcAddress("glBinormal3ivEXT");
	printf("glBinormal3ivEXT              : %p\n", p);
	p = gl.OSMesaGetProcAddress("glBinormal3sEXT");
	printf("glBinormal3sEXT               : %p\n", p);
	p = gl.OSMesaGetProcAddress("glBinormal3svEXT");
	printf("glBinormal3svEXT              : %p\n", p);
	p = gl.OSMesaGetProcAddress("glBinormalPointerEXT");
	printf("glBinormalPointerEXT          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glBitmap");
	printf("glBitmap                      : %p\n", p);
	p = gl.OSMesaGetProcAddress("glBitmapxOES");
	printf("glBitmapxOES                  : %p\n", p);
	p = gl.OSMesaGetProcAddress("glBlendBarrierKHR");
	printf("glBlendBarrierKHR             : %p\n", p);
	p = gl.OSMesaGetProcAddress("glBlendBarrierNV");
	printf("glBlendBarrierNV              : %p\n", p);
	p = gl.OSMesaGetProcAddress("glBlendColor");
	printf("glBlendColor                  : %p\n", p);
	p = gl.OSMesaGetProcAddress("glBlendColorEXT");
	printf("glBlendColorEXT               : %p\n", p);
	p = gl.OSMesaGetProcAddress("glBlendColorxOES");
	printf("glBlendColorxOES              : %p\n", p);
	p = gl.OSMesaGetProcAddress("glBlendEquation");
	printf("glBlendEquation               : %p\n", p);
	p = gl.OSMesaGetProcAddress("glBlendEquationEXT");
	printf("glBlendEquationEXT            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glBlendEquationIndexedAMD");
	printf("glBlendEquationIndexedAMD     : %p\n", p);
	p = gl.OSMesaGetProcAddress("glBlendEquationSeparate");
	printf("glBlendEquationSeparate       : %p\n", p);
	p = gl.OSMesaGetProcAddress("glBlendEquationSeparateATI");
	printf("glBlendEquationSeparateATI    : %p\n", p);
	p = gl.OSMesaGetProcAddress("glBlendEquationSeparateEXT");
	printf("glBlendEquationSeparateEXT    : %p\n", p);
	p = gl.OSMesaGetProcAddress("glBlendEquationSeparateIndexedAMD");
	printf("glBlendEquationSeparateIndexedAMD: %p\n", p);
	p = gl.OSMesaGetProcAddress("glBlendEquationSeparatei");
	printf("glBlendEquationSeparatei      : %p\n", p);
	p = gl.OSMesaGetProcAddress("glBlendEquationSeparateiARB");
	printf("glBlendEquationSeparateiARB   : %p\n", p);
	p = gl.OSMesaGetProcAddress("glBlendEquationi");
	printf("glBlendEquationi              : %p\n", p);
	p = gl.OSMesaGetProcAddress("glBlendEquationiARB");
	printf("glBlendEquationiARB           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glBlendFunc");
	printf("glBlendFunc                   : %p\n", p);
	p = gl.OSMesaGetProcAddress("glBlendFuncIndexedAMD");
	printf("glBlendFuncIndexedAMD         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glBlendFuncSeparate");
	printf("glBlendFuncSeparate           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glBlendFuncSeparateEXT");
	printf("glBlendFuncSeparateEXT        : %p\n", p);
	p = gl.OSMesaGetProcAddress("glBlendFuncSeparateINGR");
	printf("glBlendFuncSeparateINGR       : %p\n", p);
	p = gl.OSMesaGetProcAddress("glBlendFuncSeparateIndexedAMD");
	printf("glBlendFuncSeparateIndexedAMD : %p\n", p);
	p = gl.OSMesaGetProcAddress("glBlendFuncSeparatei");
	printf("glBlendFuncSeparatei          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glBlendFuncSeparateiARB");
	printf("glBlendFuncSeparateiARB       : %p\n", p);
	p = gl.OSMesaGetProcAddress("glBlendFunci");
	printf("glBlendFunci                  : %p\n", p);
	p = gl.OSMesaGetProcAddress("glBlendFunciARB");
	printf("glBlendFunciARB               : %p\n", p);
	p = gl.OSMesaGetProcAddress("glBlendParameteriNV");
	printf("glBlendParameteriNV           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glBlitFramebuffer");
	printf("glBlitFramebuffer             : %p\n", p);
	p = gl.OSMesaGetProcAddress("glBlitFramebufferEXT");
	printf("glBlitFramebufferEXT          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glBlitNamedFramebuffer");
	printf("glBlitNamedFramebuffer        : %p\n", p);
	p = gl.OSMesaGetProcAddress("glBufferAddressRangeNV");
	printf("glBufferAddressRangeNV        : %p\n", p);
	p = gl.OSMesaGetProcAddress("glBufferData");
	printf("glBufferData                  : %p\n", p);
	p = gl.OSMesaGetProcAddress("glBufferDataARB");
	printf("glBufferDataARB               : %p\n", p);
	p = gl.OSMesaGetProcAddress("glBufferPageCommitmentARB");
	printf("glBufferPageCommitmentARB     : %p\n", p);
	p = gl.OSMesaGetProcAddress("glBufferParameteriAPPLE");
	printf("glBufferParameteriAPPLE       : %p\n", p);
	p = gl.OSMesaGetProcAddress("glBufferStorage");
	printf("glBufferStorage               : %p\n", p);
	p = gl.OSMesaGetProcAddress("glBufferStorageExternalEXT");
	printf("glBufferStorageExternalEXT    : %p\n", p);
	p = gl.OSMesaGetProcAddress("glBufferStorageMemEXT");
	printf("glBufferStorageMemEXT         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glBufferSubData");
	printf("glBufferSubData               : %p\n", p);
	p = gl.OSMesaGetProcAddress("glBufferSubDataARB");
	printf("glBufferSubDataARB            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glCallCommandListNV");
	printf("glCallCommandListNV           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glCallList");
	printf("glCallList                    : %p\n", p);
	p = gl.OSMesaGetProcAddress("glCallLists");
	printf("glCallLists                   : %p\n", p);
	p = gl.OSMesaGetProcAddress("glCheckFramebufferStatus");
	printf("glCheckFramebufferStatus      : %p\n", p);
	p = gl.OSMesaGetProcAddress("glCheckFramebufferStatusEXT");
	printf("glCheckFramebufferStatusEXT   : %p\n", p);
	p = gl.OSMesaGetProcAddress("glCheckNamedFramebufferStatus");
	printf("glCheckNamedFramebufferStatus : %p\n", p);
	p = gl.OSMesaGetProcAddress("glCheckNamedFramebufferStatusEXT");
	printf("glCheckNamedFramebufferStatusEXT: %p\n", p);
	p = gl.OSMesaGetProcAddress("glClampColor");
	printf("glClampColor                  : %p\n", p);
	p = gl.OSMesaGetProcAddress("glClampColorARB");
	printf("glClampColorARB               : %p\n", p);
	p = gl.OSMesaGetProcAddress("glClear");
	printf("glClear                       : %p\n", p);
	p = gl.OSMesaGetProcAddress("glClearAccum");
	printf("glClearAccum                  : %p\n", p);
	p = gl.OSMesaGetProcAddress("glClearAccumxOES");
	printf("glClearAccumxOES              : %p\n", p);
	p = gl.OSMesaGetProcAddress("glClearBufferData");
	printf("glClearBufferData             : %p\n", p);
	p = gl.OSMesaGetProcAddress("glClearBufferSubData");
	printf("glClearBufferSubData          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glClearBufferfi");
	printf("glClearBufferfi               : %p\n", p);
	p = gl.OSMesaGetProcAddress("glClearBufferfv");
	printf("glClearBufferfv               : %p\n", p);
	p = gl.OSMesaGetProcAddress("glClearBufferiv");
	printf("glClearBufferiv               : %p\n", p);
	p = gl.OSMesaGetProcAddress("glClearBufferuiv");
	printf("glClearBufferuiv              : %p\n", p);
	p = gl.OSMesaGetProcAddress("glClearColor");
	printf("glClearColor                  : %p\n", p);
	p = gl.OSMesaGetProcAddress("glClearColorIiEXT");
	printf("glClearColorIiEXT             : %p\n", p);
	p = gl.OSMesaGetProcAddress("glClearColorIuiEXT");
	printf("glClearColorIuiEXT            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glClearColorxOES");
	printf("glClearColorxOES              : %p\n", p);
	p = gl.OSMesaGetProcAddress("glClearDebugLogMESA");
	printf("glClearDebugLogMESA           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glClearDepth");
	printf("glClearDepth                  : %p\n", p);
	p = gl.OSMesaGetProcAddress("glClearDepthdNV");
	printf("glClearDepthdNV               : %p\n", p);
	p = gl.OSMesaGetProcAddress("glClearDepthf");
	printf("glClearDepthf                 : %p\n", p);
	p = gl.OSMesaGetProcAddress("glClearDepthfOES");
	printf("glClearDepthfOES              : %p\n", p);
	p = gl.OSMesaGetProcAddress("glClearDepthxOES");
	printf("glClearDepthxOES              : %p\n", p);
	p = gl.OSMesaGetProcAddress("glClearIndex");
	printf("glClearIndex                  : %p\n", p);
	p = gl.OSMesaGetProcAddress("glClearNamedBufferData");
	printf("glClearNamedBufferData        : %p\n", p);
	p = gl.OSMesaGetProcAddress("glClearNamedBufferDataEXT");
	printf("glClearNamedBufferDataEXT     : %p\n", p);
	p = gl.OSMesaGetProcAddress("glClearNamedBufferSubData");
	printf("glClearNamedBufferSubData     : %p\n", p);
	p = gl.OSMesaGetProcAddress("glClearNamedBufferSubDataEXT");
	printf("glClearNamedBufferSubDataEXT  : %p\n", p);
	p = gl.OSMesaGetProcAddress("glClearNamedFramebufferfi");
	printf("glClearNamedFramebufferfi     : %p\n", p);
	p = gl.OSMesaGetProcAddress("glClearNamedFramebufferfv");
	printf("glClearNamedFramebufferfv     : %p\n", p);
	p = gl.OSMesaGetProcAddress("glClearNamedFramebufferiv");
	printf("glClearNamedFramebufferiv     : %p\n", p);
	p = gl.OSMesaGetProcAddress("glClearNamedFramebufferuiv");
	printf("glClearNamedFramebufferuiv    : %p\n", p);
	p = gl.OSMesaGetProcAddress("glClearStencil");
	printf("glClearStencil                : %p\n", p);
	p = gl.OSMesaGetProcAddress("glClearTexImage");
	printf("glClearTexImage               : %p\n", p);
	p = gl.OSMesaGetProcAddress("glClearTexSubImage");
	printf("glClearTexSubImage            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glClientActiveTexture");
	printf("glClientActiveTexture         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glClientActiveTextureARB");
	printf("glClientActiveTextureARB      : %p\n", p);
	p = gl.OSMesaGetProcAddress("glClientActiveVertexStreamATI");
	printf("glClientActiveVertexStreamATI : %p\n", p);
	p = gl.OSMesaGetProcAddress("glClientAttribDefaultEXT");
	printf("glClientAttribDefaultEXT      : %p\n", p);
	p = gl.OSMesaGetProcAddress("glClientWaitSync");
	printf("glClientWaitSync              : %p\n", p);
	p = gl.OSMesaGetProcAddress("glClipControl");
	printf("glClipControl                 : %p\n", p);
	p = gl.OSMesaGetProcAddress("glClipPlane");
	printf("glClipPlane                   : %p\n", p);
	p = gl.OSMesaGetProcAddress("glClipPlanefOES");
	printf("glClipPlanefOES               : %p\n", p);
	p = gl.OSMesaGetProcAddress("glClipPlanexOES");
	printf("glClipPlanexOES               : %p\n", p);
	p = gl.OSMesaGetProcAddress("glColor3b");
	printf("glColor3b                     : %p\n", p);
	p = gl.OSMesaGetProcAddress("glColor3bv");
	printf("glColor3bv                    : %p\n", p);
	p = gl.OSMesaGetProcAddress("glColor3d");
	printf("glColor3d                     : %p\n", p);
	p = gl.OSMesaGetProcAddress("glColor3dv");
	printf("glColor3dv                    : %p\n", p);
	p = gl.OSMesaGetProcAddress("glColor3f");
	printf("glColor3f                     : %p\n", p);
	p = gl.OSMesaGetProcAddress("glColor3fVertex3fSUN");
	printf("glColor3fVertex3fSUN          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glColor3fVertex3fvSUN");
	printf("glColor3fVertex3fvSUN         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glColor3fv");
	printf("glColor3fv                    : %p\n", p);
	p = gl.OSMesaGetProcAddress("glColor3hNV");
	printf("glColor3hNV                   : %p\n", p);
	p = gl.OSMesaGetProcAddress("glColor3hvNV");
	printf("glColor3hvNV                  : %p\n", p);
	p = gl.OSMesaGetProcAddress("glColor3i");
	printf("glColor3i                     : %p\n", p);
	p = gl.OSMesaGetProcAddress("glColor3iv");
	printf("glColor3iv                    : %p\n", p);
	p = gl.OSMesaGetProcAddress("glColor3s");
	printf("glColor3s                     : %p\n", p);
	p = gl.OSMesaGetProcAddress("glColor3sv");
	printf("glColor3sv                    : %p\n", p);
	p = gl.OSMesaGetProcAddress("glColor3ub");
	printf("glColor3ub                    : %p\n", p);
	p = gl.OSMesaGetProcAddress("glColor3ubv");
	printf("glColor3ubv                   : %p\n", p);
	p = gl.OSMesaGetProcAddress("glColor3ui");
	printf("glColor3ui                    : %p\n", p);
	p = gl.OSMesaGetProcAddress("glColor3uiv");
	printf("glColor3uiv                   : %p\n", p);
	p = gl.OSMesaGetProcAddress("glColor3us");
	printf("glColor3us                    : %p\n", p);
	p = gl.OSMesaGetProcAddress("glColor3usv");
	printf("glColor3usv                   : %p\n", p);
	p = gl.OSMesaGetProcAddress("glColor3xOES");
	printf("glColor3xOES                  : %p\n", p);
	p = gl.OSMesaGetProcAddress("glColor3xvOES");
	printf("glColor3xvOES                 : %p\n", p);
	p = gl.OSMesaGetProcAddress("glColor4b");
	printf("glColor4b                     : %p\n", p);
	p = gl.OSMesaGetProcAddress("glColor4bv");
	printf("glColor4bv                    : %p\n", p);
	p = gl.OSMesaGetProcAddress("glColor4d");
	printf("glColor4d                     : %p\n", p);
	p = gl.OSMesaGetProcAddress("glColor4dv");
	printf("glColor4dv                    : %p\n", p);
	p = gl.OSMesaGetProcAddress("glColor4f");
	printf("glColor4f                     : %p\n", p);
	p = gl.OSMesaGetProcAddress("glColor4fNormal3fVertex3fSUN");
	printf("glColor4fNormal3fVertex3fSUN  : %p\n", p);
	p = gl.OSMesaGetProcAddress("glColor4fNormal3fVertex3fvSUN");
	printf("glColor4fNormal3fVertex3fvSUN : %p\n", p);
	p = gl.OSMesaGetProcAddress("glColor4fv");
	printf("glColor4fv                    : %p\n", p);
	p = gl.OSMesaGetProcAddress("glColor4hNV");
	printf("glColor4hNV                   : %p\n", p);
	p = gl.OSMesaGetProcAddress("glColor4hvNV");
	printf("glColor4hvNV                  : %p\n", p);
	p = gl.OSMesaGetProcAddress("glColor4i");
	printf("glColor4i                     : %p\n", p);
	p = gl.OSMesaGetProcAddress("glColor4iv");
	printf("glColor4iv                    : %p\n", p);
	p = gl.OSMesaGetProcAddress("glColor4s");
	printf("glColor4s                     : %p\n", p);
	p = gl.OSMesaGetProcAddress("glColor4sv");
	printf("glColor4sv                    : %p\n", p);
	p = gl.OSMesaGetProcAddress("glColor4ub");
	printf("glColor4ub                    : %p\n", p);
	p = gl.OSMesaGetProcAddress("glColor4ubVertex2fSUN");
	printf("glColor4ubVertex2fSUN         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glColor4ubVertex2fvSUN");
	printf("glColor4ubVertex2fvSUN        : %p\n", p);
	p = gl.OSMesaGetProcAddress("glColor4ubVertex3fSUN");
	printf("glColor4ubVertex3fSUN         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glColor4ubVertex3fvSUN");
	printf("glColor4ubVertex3fvSUN        : %p\n", p);
	p = gl.OSMesaGetProcAddress("glColor4ubv");
	printf("glColor4ubv                   : %p\n", p);
	p = gl.OSMesaGetProcAddress("glColor4ui");
	printf("glColor4ui                    : %p\n", p);
	p = gl.OSMesaGetProcAddress("glColor4uiv");
	printf("glColor4uiv                   : %p\n", p);
	p = gl.OSMesaGetProcAddress("glColor4us");
	printf("glColor4us                    : %p\n", p);
	p = gl.OSMesaGetProcAddress("glColor4usv");
	printf("glColor4usv                   : %p\n", p);
	p = gl.OSMesaGetProcAddress("glColor4xOES");
	printf("glColor4xOES                  : %p\n", p);
	p = gl.OSMesaGetProcAddress("glColor4xvOES");
	printf("glColor4xvOES                 : %p\n", p);
	p = gl.OSMesaGetProcAddress("glColorFormatNV");
	printf("glColorFormatNV               : %p\n", p);
	p = gl.OSMesaGetProcAddress("glColorFragmentOp1ATI");
	printf("glColorFragmentOp1ATI         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glColorFragmentOp2ATI");
	printf("glColorFragmentOp2ATI         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glColorFragmentOp3ATI");
	printf("glColorFragmentOp3ATI         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glColorMask");
	printf("glColorMask                   : %p\n", p);
	p = gl.OSMesaGetProcAddress("glColorMaskIndexedEXT");
	printf("glColorMaskIndexedEXT         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glColorMaski");
	printf("glColorMaski                  : %p\n", p);
	p = gl.OSMesaGetProcAddress("glColorMaterial");
	printf("glColorMaterial               : %p\n", p);
	p = gl.OSMesaGetProcAddress("glColorP3ui");
	printf("glColorP3ui                   : %p\n", p);
	p = gl.OSMesaGetProcAddress("glColorP3uiv");
	printf("glColorP3uiv                  : %p\n", p);
	p = gl.OSMesaGetProcAddress("glColorP4ui");
	printf("glColorP4ui                   : %p\n", p);
	p = gl.OSMesaGetProcAddress("glColorP4uiv");
	printf("glColorP4uiv                  : %p\n", p);
	p = gl.OSMesaGetProcAddress("glColorPointer");
	printf("glColorPointer                : %p\n", p);
	p = gl.OSMesaGetProcAddress("glColorPointerEXT");
	printf("glColorPointerEXT             : %p\n", p);
	p = gl.OSMesaGetProcAddress("glColorPointerListIBM");
	printf("glColorPointerListIBM         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glColorPointervINTEL");
	printf("glColorPointervINTEL          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glColorSubTable");
	printf("glColorSubTable               : %p\n", p);
	p = gl.OSMesaGetProcAddress("glColorSubTableEXT");
	printf("glColorSubTableEXT            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glColorTable");
	printf("glColorTable                  : %p\n", p);
	p = gl.OSMesaGetProcAddress("glColorTableEXT");
	printf("glColorTableEXT               : %p\n", p);
	p = gl.OSMesaGetProcAddress("glColorTableParameterfv");
	printf("glColorTableParameterfv       : %p\n", p);
	p = gl.OSMesaGetProcAddress("glColorTableParameterfvSGI");
	printf("glColorTableParameterfvSGI    : %p\n", p);
	p = gl.OSMesaGetProcAddress("glColorTableParameteriv");
	printf("glColorTableParameteriv       : %p\n", p);
	p = gl.OSMesaGetProcAddress("glColorTableParameterivSGI");
	printf("glColorTableParameterivSGI    : %p\n", p);
	p = gl.OSMesaGetProcAddress("glColorTableSGI");
	printf("glColorTableSGI               : %p\n", p);
	p = gl.OSMesaGetProcAddress("glCombinerInputNV");
	printf("glCombinerInputNV             : %p\n", p);
	p = gl.OSMesaGetProcAddress("glCombinerOutputNV");
	printf("glCombinerOutputNV            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glCombinerParameterfNV");
	printf("glCombinerParameterfNV        : %p\n", p);
	p = gl.OSMesaGetProcAddress("glCombinerParameterfvNV");
	printf("glCombinerParameterfvNV       : %p\n", p);
	p = gl.OSMesaGetProcAddress("glCombinerParameteriNV");
	printf("glCombinerParameteriNV        : %p\n", p);
	p = gl.OSMesaGetProcAddress("glCombinerParameterivNV");
	printf("glCombinerParameterivNV       : %p\n", p);
	p = gl.OSMesaGetProcAddress("glCombinerStageParameterfvNV");
	printf("glCombinerStageParameterfvNV  : %p\n", p);
	p = gl.OSMesaGetProcAddress("glCommandListSegmentsNV");
	printf("glCommandListSegmentsNV       : %p\n", p);
	p = gl.OSMesaGetProcAddress("glCompileCommandListNV");
	printf("glCompileCommandListNV        : %p\n", p);
	p = gl.OSMesaGetProcAddress("glCompileShader");
	printf("glCompileShader               : %p\n", p);
	p = gl.OSMesaGetProcAddress("glCompileShaderARB");
	printf("glCompileShaderARB            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glCompileShaderIncludeARB");
	printf("glCompileShaderIncludeARB     : %p\n", p);
	p = gl.OSMesaGetProcAddress("glCompressedMultiTexImage1DEXT");
	printf("glCompressedMultiTexImage1DEXT: %p\n", p);
	p = gl.OSMesaGetProcAddress("glCompressedMultiTexImage2DEXT");
	printf("glCompressedMultiTexImage2DEXT: %p\n", p);
	p = gl.OSMesaGetProcAddress("glCompressedMultiTexImage3DEXT");
	printf("glCompressedMultiTexImage3DEXT: %p\n", p);
	p = gl.OSMesaGetProcAddress("glCompressedMultiTexSubImage1DEXT");
	printf("glCompressedMultiTexSubImage1DEXT: %p\n", p);
	p = gl.OSMesaGetProcAddress("glCompressedMultiTexSubImage2DEXT");
	printf("glCompressedMultiTexSubImage2DEXT: %p\n", p);
	p = gl.OSMesaGetProcAddress("glCompressedMultiTexSubImage3DEXT");
	printf("glCompressedMultiTexSubImage3DEXT: %p\n", p);
	p = gl.OSMesaGetProcAddress("glCompressedTexImage1D");
	printf("glCompressedTexImage1D        : %p\n", p);
	p = gl.OSMesaGetProcAddress("glCompressedTexImage1DARB");
	printf("glCompressedTexImage1DARB     : %p\n", p);
	p = gl.OSMesaGetProcAddress("glCompressedTexImage2D");
	printf("glCompressedTexImage2D        : %p\n", p);
	p = gl.OSMesaGetProcAddress("glCompressedTexImage2DARB");
	printf("glCompressedTexImage2DARB     : %p\n", p);
	p = gl.OSMesaGetProcAddress("glCompressedTexImage3D");
	printf("glCompressedTexImage3D        : %p\n", p);
	p = gl.OSMesaGetProcAddress("glCompressedTexImage3DARB");
	printf("glCompressedTexImage3DARB     : %p\n", p);
	p = gl.OSMesaGetProcAddress("glCompressedTexSubImage1D");
	printf("glCompressedTexSubImage1D     : %p\n", p);
	p = gl.OSMesaGetProcAddress("glCompressedTexSubImage1DARB");
	printf("glCompressedTexSubImage1DARB  : %p\n", p);
	p = gl.OSMesaGetProcAddress("glCompressedTexSubImage2D");
	printf("glCompressedTexSubImage2D     : %p\n", p);
	p = gl.OSMesaGetProcAddress("glCompressedTexSubImage2DARB");
	printf("glCompressedTexSubImage2DARB  : %p\n", p);
	p = gl.OSMesaGetProcAddress("glCompressedTexSubImage3D");
	printf("glCompressedTexSubImage3D     : %p\n", p);
	p = gl.OSMesaGetProcAddress("glCompressedTexSubImage3DARB");
	printf("glCompressedTexSubImage3DARB  : %p\n", p);
	p = gl.OSMesaGetProcAddress("glCompressedTextureImage1DEXT");
	printf("glCompressedTextureImage1DEXT : %p\n", p);
	p = gl.OSMesaGetProcAddress("glCompressedTextureImage2DEXT");
	printf("glCompressedTextureImage2DEXT : %p\n", p);
	p = gl.OSMesaGetProcAddress("glCompressedTextureImage3DEXT");
	printf("glCompressedTextureImage3DEXT : %p\n", p);
	p = gl.OSMesaGetProcAddress("glCompressedTextureSubImage1D");
	printf("glCompressedTextureSubImage1D : %p\n", p);
	p = gl.OSMesaGetProcAddress("glCompressedTextureSubImage1DEXT");
	printf("glCompressedTextureSubImage1DEXT: %p\n", p);
	p = gl.OSMesaGetProcAddress("glCompressedTextureSubImage2D");
	printf("glCompressedTextureSubImage2D : %p\n", p);
	p = gl.OSMesaGetProcAddress("glCompressedTextureSubImage2DEXT");
	printf("glCompressedTextureSubImage2DEXT: %p\n", p);
	p = gl.OSMesaGetProcAddress("glCompressedTextureSubImage3D");
	printf("glCompressedTextureSubImage3D : %p\n", p);
	p = gl.OSMesaGetProcAddress("glCompressedTextureSubImage3DEXT");
	printf("glCompressedTextureSubImage3DEXT: %p\n", p);
	p = gl.OSMesaGetProcAddress("glConservativeRasterParameterfNV");
	printf("glConservativeRasterParameterfNV: %p\n", p);
	p = gl.OSMesaGetProcAddress("glConservativeRasterParameteriNV");
	printf("glConservativeRasterParameteriNV: %p\n", p);
	p = gl.OSMesaGetProcAddress("glConvolutionFilter1D");
	printf("glConvolutionFilter1D         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glConvolutionFilter1DEXT");
	printf("glConvolutionFilter1DEXT      : %p\n", p);
	p = gl.OSMesaGetProcAddress("glConvolutionFilter2D");
	printf("glConvolutionFilter2D         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glConvolutionFilter2DEXT");
	printf("glConvolutionFilter2DEXT      : %p\n", p);
	p = gl.OSMesaGetProcAddress("glConvolutionParameterf");
	printf("glConvolutionParameterf       : %p\n", p);
	p = gl.OSMesaGetProcAddress("glConvolutionParameterfEXT");
	printf("glConvolutionParameterfEXT    : %p\n", p);
	p = gl.OSMesaGetProcAddress("glConvolutionParameterfv");
	printf("glConvolutionParameterfv      : %p\n", p);
	p = gl.OSMesaGetProcAddress("glConvolutionParameterfvEXT");
	printf("glConvolutionParameterfvEXT   : %p\n", p);
	p = gl.OSMesaGetProcAddress("glConvolutionParameteri");
	printf("glConvolutionParameteri       : %p\n", p);
	p = gl.OSMesaGetProcAddress("glConvolutionParameteriEXT");
	printf("glConvolutionParameteriEXT    : %p\n", p);
	p = gl.OSMesaGetProcAddress("glConvolutionParameteriv");
	printf("glConvolutionParameteriv      : %p\n", p);
	p = gl.OSMesaGetProcAddress("glConvolutionParameterivEXT");
	printf("glConvolutionParameterivEXT   : %p\n", p);
	p = gl.OSMesaGetProcAddress("glConvolutionParameterxOES");
	printf("glConvolutionParameterxOES    : %p\n", p);
	p = gl.OSMesaGetProcAddress("glConvolutionParameterxvOES");
	printf("glConvolutionParameterxvOES   : %p\n", p);
	p = gl.OSMesaGetProcAddress("glCopyBufferSubData");
	printf("glCopyBufferSubData           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glCopyColorSubTable");
	printf("glCopyColorSubTable           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glCopyColorSubTableEXT");
	printf("glCopyColorSubTableEXT        : %p\n", p);
	p = gl.OSMesaGetProcAddress("glCopyColorTable");
	printf("glCopyColorTable              : %p\n", p);
	p = gl.OSMesaGetProcAddress("glCopyColorTableSGI");
	printf("glCopyColorTableSGI           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glCopyConvolutionFilter1D");
	printf("glCopyConvolutionFilter1D     : %p\n", p);
	p = gl.OSMesaGetProcAddress("glCopyConvolutionFilter1DEXT");
	printf("glCopyConvolutionFilter1DEXT  : %p\n", p);
	p = gl.OSMesaGetProcAddress("glCopyConvolutionFilter2D");
	printf("glCopyConvolutionFilter2D     : %p\n", p);
	p = gl.OSMesaGetProcAddress("glCopyConvolutionFilter2DEXT");
	printf("glCopyConvolutionFilter2DEXT  : %p\n", p);
	p = gl.OSMesaGetProcAddress("glCopyImageSubData");
	printf("glCopyImageSubData            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glCopyImageSubDataNV");
	printf("glCopyImageSubDataNV          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glCopyMultiTexImage1DEXT");
	printf("glCopyMultiTexImage1DEXT      : %p\n", p);
	p = gl.OSMesaGetProcAddress("glCopyMultiTexImage2DEXT");
	printf("glCopyMultiTexImage2DEXT      : %p\n", p);
	p = gl.OSMesaGetProcAddress("glCopyMultiTexSubImage1DEXT");
	printf("glCopyMultiTexSubImage1DEXT   : %p\n", p);
	p = gl.OSMesaGetProcAddress("glCopyMultiTexSubImage2DEXT");
	printf("glCopyMultiTexSubImage2DEXT   : %p\n", p);
	p = gl.OSMesaGetProcAddress("glCopyMultiTexSubImage3DEXT");
	printf("glCopyMultiTexSubImage3DEXT   : %p\n", p);
	p = gl.OSMesaGetProcAddress("glCopyNamedBufferSubData");
	printf("glCopyNamedBufferSubData      : %p\n", p);
	p = gl.OSMesaGetProcAddress("glCopyPathNV");
	printf("glCopyPathNV                  : %p\n", p);
	p = gl.OSMesaGetProcAddress("glCopyPixels");
	printf("glCopyPixels                  : %p\n", p);
	p = gl.OSMesaGetProcAddress("glCopyTexImage1D");
	printf("glCopyTexImage1D              : %p\n", p);
	p = gl.OSMesaGetProcAddress("glCopyTexImage1DEXT");
	printf("glCopyTexImage1DEXT           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glCopyTexImage2D");
	printf("glCopyTexImage2D              : %p\n", p);
	p = gl.OSMesaGetProcAddress("glCopyTexImage2DEXT");
	printf("glCopyTexImage2DEXT           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glCopyTexSubImage1D");
	printf("glCopyTexSubImage1D           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glCopyTexSubImage1DEXT");
	printf("glCopyTexSubImage1DEXT        : %p\n", p);
	p = gl.OSMesaGetProcAddress("glCopyTexSubImage2D");
	printf("glCopyTexSubImage2D           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glCopyTexSubImage2DEXT");
	printf("glCopyTexSubImage2DEXT        : %p\n", p);
	p = gl.OSMesaGetProcAddress("glCopyTexSubImage3D");
	printf("glCopyTexSubImage3D           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glCopyTexSubImage3DEXT");
	printf("glCopyTexSubImage3DEXT        : %p\n", p);
	p = gl.OSMesaGetProcAddress("glCopyTextureImage1DEXT");
	printf("glCopyTextureImage1DEXT       : %p\n", p);
	p = gl.OSMesaGetProcAddress("glCopyTextureImage2DEXT");
	printf("glCopyTextureImage2DEXT       : %p\n", p);
	p = gl.OSMesaGetProcAddress("glCopyTextureSubImage1D");
	printf("glCopyTextureSubImage1D       : %p\n", p);
	p = gl.OSMesaGetProcAddress("glCopyTextureSubImage1DEXT");
	printf("glCopyTextureSubImage1DEXT    : %p\n", p);
	p = gl.OSMesaGetProcAddress("glCopyTextureSubImage2D");
	printf("glCopyTextureSubImage2D       : %p\n", p);
	p = gl.OSMesaGetProcAddress("glCopyTextureSubImage2DEXT");
	printf("glCopyTextureSubImage2DEXT    : %p\n", p);
	p = gl.OSMesaGetProcAddress("glCopyTextureSubImage3D");
	printf("glCopyTextureSubImage3D       : %p\n", p);
	p = gl.OSMesaGetProcAddress("glCopyTextureSubImage3DEXT");
	printf("glCopyTextureSubImage3DEXT    : %p\n", p);
	p = gl.OSMesaGetProcAddress("glCoverFillPathInstancedNV");
	printf("glCoverFillPathInstancedNV    : %p\n", p);
	p = gl.OSMesaGetProcAddress("glCoverFillPathNV");
	printf("glCoverFillPathNV             : %p\n", p);
	p = gl.OSMesaGetProcAddress("glCoverStrokePathInstancedNV");
	printf("glCoverStrokePathInstancedNV  : %p\n", p);
	p = gl.OSMesaGetProcAddress("glCoverStrokePathNV");
	printf("glCoverStrokePathNV           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glCoverageModulationNV");
	printf("glCoverageModulationNV        : %p\n", p);
	p = gl.OSMesaGetProcAddress("glCoverageModulationTableNV");
	printf("glCoverageModulationTableNV   : %p\n", p);
	p = gl.OSMesaGetProcAddress("glCreateBuffers");
	printf("glCreateBuffers               : %p\n", p);
	p = gl.OSMesaGetProcAddress("glCreateCommandListsNV");
	printf("glCreateCommandListsNV        : %p\n", p);
	p = gl.OSMesaGetProcAddress("glCreateDebugObjectMESA");
	printf("glCreateDebugObjectMESA       : %p\n", p);
	p = gl.OSMesaGetProcAddress("glCreateFramebuffers");
	printf("glCreateFramebuffers          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glCreateMemoryObjectsEXT");
	printf("glCreateMemoryObjectsEXT      : %p\n", p);
	p = gl.OSMesaGetProcAddress("glCreatePerfQueryINTEL");
	printf("glCreatePerfQueryINTEL        : %p\n", p);
	p = gl.OSMesaGetProcAddress("glCreateProgram");
	printf("glCreateProgram               : %p\n", p);
	p = gl.OSMesaGetProcAddress("glCreateProgramObjectARB");
	printf("glCreateProgramObjectARB      : %p\n", p);
	p = gl.OSMesaGetProcAddress("glCreateProgramPipelines");
	printf("glCreateProgramPipelines      : %p\n", p);
	p = gl.OSMesaGetProcAddress("glCreateQueries");
	printf("glCreateQueries               : %p\n", p);
	p = gl.OSMesaGetProcAddress("glCreateRenderbuffers");
	printf("glCreateRenderbuffers         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glCreateSamplers");
	printf("glCreateSamplers              : %p\n", p);
	p = gl.OSMesaGetProcAddress("glCreateShader");
	printf("glCreateShader                : %p\n", p);
	p = gl.OSMesaGetProcAddress("glCreateShaderObjectARB");
	printf("glCreateShaderObjectARB       : %p\n", p);
	p = gl.OSMesaGetProcAddress("glCreateShaderProgramEXT");
	printf("glCreateShaderProgramEXT      : %p\n", p);
	p = gl.OSMesaGetProcAddress("glCreateShaderProgramv");
	printf("glCreateShaderProgramv        : %p\n", p);
	p = gl.OSMesaGetProcAddress("glCreateStatesNV");
	printf("glCreateStatesNV              : %p\n", p);
	p = gl.OSMesaGetProcAddress("glCreateSyncFromCLeventARB");
	printf("glCreateSyncFromCLeventARB    : %p\n", p);
	p = gl.OSMesaGetProcAddress("glCreateTextures");
	printf("glCreateTextures              : %p\n", p);
	p = gl.OSMesaGetProcAddress("glCreateTransformFeedbacks");
	printf("glCreateTransformFeedbacks    : %p\n", p);
	p = gl.OSMesaGetProcAddress("glCreateVertexArrays");
	printf("glCreateVertexArrays          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glCullFace");
	printf("glCullFace                    : %p\n", p);
	p = gl.OSMesaGetProcAddress("glCullParameterdvEXT");
	printf("glCullParameterdvEXT          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glCullParameterfvEXT");
	printf("glCullParameterfvEXT          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glCurrentPaletteMatrixARB");
	printf("glCurrentPaletteMatrixARB     : %p\n", p);
	p = gl.OSMesaGetProcAddress("glDebugMessageCallback");
	printf("glDebugMessageCallback        : %p\n", p);
	p = gl.OSMesaGetProcAddress("glDebugMessageCallbackAMD");
	printf("glDebugMessageCallbackAMD     : %p\n", p);
	p = gl.OSMesaGetProcAddress("glDebugMessageCallbackARB");
	printf("glDebugMessageCallbackARB     : %p\n", p);
	p = gl.OSMesaGetProcAddress("glDebugMessageControl");
	printf("glDebugMessageControl         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glDebugMessageControlARB");
	printf("glDebugMessageControlARB      : %p\n", p);
	p = gl.OSMesaGetProcAddress("glDebugMessageEnableAMD");
	printf("glDebugMessageEnableAMD       : %p\n", p);
	p = gl.OSMesaGetProcAddress("glDebugMessageInsert");
	printf("glDebugMessageInsert          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glDebugMessageInsertAMD");
	printf("glDebugMessageInsertAMD       : %p\n", p);
	p = gl.OSMesaGetProcAddress("glDebugMessageInsertARB");
	printf("glDebugMessageInsertARB       : %p\n", p);
	p = gl.OSMesaGetProcAddress("glDeformSGIX");
	printf("glDeformSGIX                  : %p\n", p);
	p = gl.OSMesaGetProcAddress("glDeformationMap3dSGIX");
	printf("glDeformationMap3dSGIX        : %p\n", p);
	p = gl.OSMesaGetProcAddress("glDeformationMap3fSGIX");
	printf("glDeformationMap3fSGIX        : %p\n", p);
	p = gl.OSMesaGetProcAddress("glDeleteAsyncMarkersSGIX");
	printf("glDeleteAsyncMarkersSGIX      : %p\n", p);
	p = gl.OSMesaGetProcAddress("glDeleteBuffers");
	printf("glDeleteBuffers               : %p\n", p);
	p = gl.OSMesaGetProcAddress("glDeleteBuffersARB");
	printf("glDeleteBuffersARB            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glDeleteCommandListsNV");
	printf("glDeleteCommandListsNV        : %p\n", p);
	p = gl.OSMesaGetProcAddress("glDeleteFencesAPPLE");
	printf("glDeleteFencesAPPLE           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glDeleteFencesNV");
	printf("glDeleteFencesNV              : %p\n", p);
	p = gl.OSMesaGetProcAddress("glDeleteFragmentShaderATI");
	printf("glDeleteFragmentShaderATI     : %p\n", p);
	p = gl.OSMesaGetProcAddress("glDeleteFramebuffers");
	printf("glDeleteFramebuffers          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glDeleteFramebuffersEXT");
	printf("glDeleteFramebuffersEXT       : %p\n", p);
	p = gl.OSMesaGetProcAddress("glDeleteLists");
	printf("glDeleteLists                 : %p\n", p);
	p = gl.OSMesaGetProcAddress("glDeleteMemoryObjectsEXT");
	printf("glDeleteMemoryObjectsEXT      : %p\n", p);
	p = gl.OSMesaGetProcAddress("glDeleteNamedStringARB");
	printf("glDeleteNamedStringARB        : %p\n", p);
	p = gl.OSMesaGetProcAddress("glDeleteNamesAMD");
	printf("glDeleteNamesAMD              : %p\n", p);
	p = gl.OSMesaGetProcAddress("glDeleteObjectARB");
	printf("glDeleteObjectARB             : %p\n", p);
	p = gl.OSMesaGetProcAddress("glDeleteObjectBufferATI");
	printf("glDeleteObjectBufferATI       : %p\n", p);
	p = gl.OSMesaGetProcAddress("glDeleteOcclusionQueriesNV");
	printf("glDeleteOcclusionQueriesNV    : %p\n", p);
	p = gl.OSMesaGetProcAddress("glDeletePathsNV");
	printf("glDeletePathsNV               : %p\n", p);
	p = gl.OSMesaGetProcAddress("glDeletePerfMonitorsAMD");
	printf("glDeletePerfMonitorsAMD       : %p\n", p);
	p = gl.OSMesaGetProcAddress("glDeletePerfQueryINTEL");
	printf("glDeletePerfQueryINTEL        : %p\n", p);
	p = gl.OSMesaGetProcAddress("glDeleteProgram");
	printf("glDeleteProgram               : %p\n", p);
	p = gl.OSMesaGetProcAddress("glDeleteProgramPipelines");
	printf("glDeleteProgramPipelines      : %p\n", p);
	p = gl.OSMesaGetProcAddress("glDeleteProgramsARB");
	printf("glDeleteProgramsARB           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glDeleteProgramsNV");
	printf("glDeleteProgramsNV            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glDeleteQueries");
	printf("glDeleteQueries               : %p\n", p);
	p = gl.OSMesaGetProcAddress("glDeleteQueriesARB");
	printf("glDeleteQueriesARB            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glDeleteQueryResourceTagNV");
	printf("glDeleteQueryResourceTagNV    : %p\n", p);
	p = gl.OSMesaGetProcAddress("glDeleteRenderbuffers");
	printf("glDeleteRenderbuffers         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glDeleteRenderbuffersEXT");
	printf("glDeleteRenderbuffersEXT      : %p\n", p);
	p = gl.OSMesaGetProcAddress("glDeleteSamplers");
	printf("glDeleteSamplers              : %p\n", p);
	p = gl.OSMesaGetProcAddress("glDeleteSemaphoresEXT");
	printf("glDeleteSemaphoresEXT         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glDeleteShader");
	printf("glDeleteShader                : %p\n", p);
	p = gl.OSMesaGetProcAddress("glDeleteStatesNV");
	printf("glDeleteStatesNV              : %p\n", p);
	p = gl.OSMesaGetProcAddress("glDeleteSync");
	printf("glDeleteSync                  : %p\n", p);
	p = gl.OSMesaGetProcAddress("glDeleteTextures");
	printf("glDeleteTextures              : %p\n", p);
	p = gl.OSMesaGetProcAddress("glDeleteTexturesEXT");
	printf("glDeleteTexturesEXT           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glDeleteTransformFeedbacks");
	printf("glDeleteTransformFeedbacks    : %p\n", p);
	p = gl.OSMesaGetProcAddress("glDeleteTransformFeedbacksNV");
	printf("glDeleteTransformFeedbacksNV  : %p\n", p);
	p = gl.OSMesaGetProcAddress("glDeleteVertexArrays");
	printf("glDeleteVertexArrays          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glDeleteVertexArraysAPPLE");
	printf("glDeleteVertexArraysAPPLE     : %p\n", p);
	p = gl.OSMesaGetProcAddress("glDeleteVertexShaderEXT");
	printf("glDeleteVertexShaderEXT       : %p\n", p);
	p = gl.OSMesaGetProcAddress("glDepthBoundsEXT");
	printf("glDepthBoundsEXT              : %p\n", p);
	p = gl.OSMesaGetProcAddress("glDepthBoundsdNV");
	printf("glDepthBoundsdNV              : %p\n", p);
	p = gl.OSMesaGetProcAddress("glDepthFunc");
	printf("glDepthFunc                   : %p\n", p);
	p = gl.OSMesaGetProcAddress("glDepthMask");
	printf("glDepthMask                   : %p\n", p);
	p = gl.OSMesaGetProcAddress("glDepthRange");
	printf("glDepthRange                  : %p\n", p);
	p = gl.OSMesaGetProcAddress("glDepthRangeArrayv");
	printf("glDepthRangeArrayv            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glDepthRangeIndexed");
	printf("glDepthRangeIndexed           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glDepthRangedNV");
	printf("glDepthRangedNV               : %p\n", p);
	p = gl.OSMesaGetProcAddress("glDepthRangef");
	printf("glDepthRangef                 : %p\n", p);
	p = gl.OSMesaGetProcAddress("glDepthRangefOES");
	printf("glDepthRangefOES              : %p\n", p);
	p = gl.OSMesaGetProcAddress("glDepthRangexOES");
	printf("glDepthRangexOES              : %p\n", p);
	p = gl.OSMesaGetProcAddress("glDetachObjectARB");
	printf("glDetachObjectARB             : %p\n", p);
	p = gl.OSMesaGetProcAddress("glDetachShader");
	printf("glDetachShader                : %p\n", p);
	p = gl.OSMesaGetProcAddress("glDetailTexFuncSGIS");
	printf("glDetailTexFuncSGIS           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glDisable");
	printf("glDisable                     : %p\n", p);
	p = gl.OSMesaGetProcAddress("glDisableClientState");
	printf("glDisableClientState          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glDisableClientStateIndexedEXT");
	printf("glDisableClientStateIndexedEXT: %p\n", p);
	p = gl.OSMesaGetProcAddress("glDisableClientStateiEXT");
	printf("glDisableClientStateiEXT      : %p\n", p);
	p = gl.OSMesaGetProcAddress("glDisableIndexedEXT");
	printf("glDisableIndexedEXT           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glDisableTraceMESA");
	printf("glDisableTraceMESA            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glDisableVariantClientStateEXT");
	printf("glDisableVariantClientStateEXT: %p\n", p);
	p = gl.OSMesaGetProcAddress("glDisableVertexArrayAttrib");
	printf("glDisableVertexArrayAttrib    : %p\n", p);
	p = gl.OSMesaGetProcAddress("glDisableVertexArrayAttribEXT");
	printf("glDisableVertexArrayAttribEXT : %p\n", p);
	p = gl.OSMesaGetProcAddress("glDisableVertexArrayEXT");
	printf("glDisableVertexArrayEXT       : %p\n", p);
	p = gl.OSMesaGetProcAddress("glDisableVertexAttribAPPLE");
	printf("glDisableVertexAttribAPPLE    : %p\n", p);
	p = gl.OSMesaGetProcAddress("glDisableVertexAttribArray");
	printf("glDisableVertexAttribArray    : %p\n", p);
	p = gl.OSMesaGetProcAddress("glDisableVertexAttribArrayARB");
	printf("glDisableVertexAttribArrayARB : %p\n", p);
	p = gl.OSMesaGetProcAddress("glDisablei");
	printf("glDisablei                    : %p\n", p);
	p = gl.OSMesaGetProcAddress("glDispatchCompute");
	printf("glDispatchCompute             : %p\n", p);
	p = gl.OSMesaGetProcAddress("glDispatchComputeGroupSizeARB");
	printf("glDispatchComputeGroupSizeARB : %p\n", p);
	p = gl.OSMesaGetProcAddress("glDispatchComputeIndirect");
	printf("glDispatchComputeIndirect     : %p\n", p);
	p = gl.OSMesaGetProcAddress("glDrawArrays");
	printf("glDrawArrays                  : %p\n", p);
	p = gl.OSMesaGetProcAddress("glDrawArraysEXT");
	printf("glDrawArraysEXT               : %p\n", p);
	p = gl.OSMesaGetProcAddress("glDrawArraysIndirect");
	printf("glDrawArraysIndirect          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glDrawArraysInstanced");
	printf("glDrawArraysInstanced         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glDrawArraysInstancedARB");
	printf("glDrawArraysInstancedARB      : %p\n", p);
	p = gl.OSMesaGetProcAddress("glDrawArraysInstancedBaseInstance");
	printf("glDrawArraysInstancedBaseInstance: %p\n", p);
	p = gl.OSMesaGetProcAddress("glDrawArraysInstancedEXT");
	printf("glDrawArraysInstancedEXT      : %p\n", p);
	p = gl.OSMesaGetProcAddress("glDrawBuffer");
	printf("glDrawBuffer                  : %p\n", p);
	p = gl.OSMesaGetProcAddress("glDrawBuffers");
	printf("glDrawBuffers                 : %p\n", p);
	p = gl.OSMesaGetProcAddress("glDrawBuffersARB");
	printf("glDrawBuffersARB              : %p\n", p);
	p = gl.OSMesaGetProcAddress("glDrawBuffersATI");
	printf("glDrawBuffersATI              : %p\n", p);
	p = gl.OSMesaGetProcAddress("glDrawCommandsAddressNV");
	printf("glDrawCommandsAddressNV       : %p\n", p);
	p = gl.OSMesaGetProcAddress("glDrawCommandsNV");
	printf("glDrawCommandsNV              : %p\n", p);
	p = gl.OSMesaGetProcAddress("glDrawCommandsStatesAddressNV");
	printf("glDrawCommandsStatesAddressNV : %p\n", p);
	p = gl.OSMesaGetProcAddress("glDrawCommandsStatesNV");
	printf("glDrawCommandsStatesNV        : %p\n", p);
	p = gl.OSMesaGetProcAddress("glDrawElementArrayAPPLE");
	printf("glDrawElementArrayAPPLE       : %p\n", p);
	p = gl.OSMesaGetProcAddress("glDrawElementArrayATI");
	printf("glDrawElementArrayATI         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glDrawElements");
	printf("glDrawElements                : %p\n", p);
	p = gl.OSMesaGetProcAddress("glDrawElementsBaseVertex");
	printf("glDrawElementsBaseVertex      : %p\n", p);
	p = gl.OSMesaGetProcAddress("glDrawElementsIndirect");
	printf("glDrawElementsIndirect        : %p\n", p);
	p = gl.OSMesaGetProcAddress("glDrawElementsInstanced");
	printf("glDrawElementsInstanced       : %p\n", p);
	p = gl.OSMesaGetProcAddress("glDrawElementsInstancedARB");
	printf("glDrawElementsInstancedARB    : %p\n", p);
	p = gl.OSMesaGetProcAddress("glDrawElementsInstancedBaseInstance");
	printf("glDrawElementsInstancedBaseInstance: %p\n", p);
	p = gl.OSMesaGetProcAddress("glDrawElementsInstancedBaseVertex");
	printf("glDrawElementsInstancedBaseVertex: %p\n", p);
	p = gl.OSMesaGetProcAddress("glDrawElementsInstancedBaseVertexBaseInstance");
	printf("glDrawElementsInstancedBaseVertexBaseInstance: %p\n", p);
	p = gl.OSMesaGetProcAddress("glDrawElementsInstancedEXT");
	printf("glDrawElementsInstancedEXT    : %p\n", p);
	p = gl.OSMesaGetProcAddress("glDrawMeshArraysSUN");
	printf("glDrawMeshArraysSUN           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glDrawPixels");
	printf("glDrawPixels                  : %p\n", p);
	p = gl.OSMesaGetProcAddress("glDrawRangeElementArrayAPPLE");
	printf("glDrawRangeElementArrayAPPLE  : %p\n", p);
	p = gl.OSMesaGetProcAddress("glDrawRangeElementArrayATI");
	printf("glDrawRangeElementArrayATI    : %p\n", p);
	p = gl.OSMesaGetProcAddress("glDrawRangeElements");
	printf("glDrawRangeElements           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glDrawRangeElementsBaseVertex");
	printf("glDrawRangeElementsBaseVertex : %p\n", p);
	p = gl.OSMesaGetProcAddress("glDrawRangeElementsEXT");
	printf("glDrawRangeElementsEXT        : %p\n", p);
	p = gl.OSMesaGetProcAddress("glDrawTextureNV");
	printf("glDrawTextureNV               : %p\n", p);
	p = gl.OSMesaGetProcAddress("glDrawTransformFeedback");
	printf("glDrawTransformFeedback       : %p\n", p);
	p = gl.OSMesaGetProcAddress("glDrawTransformFeedbackInstanced");
	printf("glDrawTransformFeedbackInstanced: %p\n", p);
	p = gl.OSMesaGetProcAddress("glDrawTransformFeedbackNV");
	printf("glDrawTransformFeedbackNV     : %p\n", p);
	p = gl.OSMesaGetProcAddress("glDrawTransformFeedbackStream");
	printf("glDrawTransformFeedbackStream : %p\n", p);
	p = gl.OSMesaGetProcAddress("glDrawTransformFeedbackStreamInstanced");
	printf("glDrawTransformFeedbackStreamInstanced: %p\n", p);
	p = gl.OSMesaGetProcAddress("glDrawVkImageNV");
	printf("glDrawVkImageNV               : %p\n", p);
	p = gl.OSMesaGetProcAddress("glEdgeFlag");
	printf("glEdgeFlag                    : %p\n", p);
	p = gl.OSMesaGetProcAddress("glEdgeFlagFormatNV");
	printf("glEdgeFlagFormatNV            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glEdgeFlagPointer");
	printf("glEdgeFlagPointer             : %p\n", p);
	p = gl.OSMesaGetProcAddress("glEdgeFlagPointerEXT");
	printf("glEdgeFlagPointerEXT          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glEdgeFlagPointerListIBM");
	printf("glEdgeFlagPointerListIBM      : %p\n", p);
	p = gl.OSMesaGetProcAddress("glEdgeFlagv");
	printf("glEdgeFlagv                   : %p\n", p);
	p = gl.OSMesaGetProcAddress("glElementPointerAPPLE");
	printf("glElementPointerAPPLE         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glElementPointerATI");
	printf("glElementPointerATI           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glEnable");
	printf("glEnable                      : %p\n", p);
	p = gl.OSMesaGetProcAddress("glEnableClientState");
	printf("glEnableClientState           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glEnableClientStateIndexedEXT");
	printf("glEnableClientStateIndexedEXT : %p\n", p);
	p = gl.OSMesaGetProcAddress("glEnableClientStateiEXT");
	printf("glEnableClientStateiEXT       : %p\n", p);
	p = gl.OSMesaGetProcAddress("glEnableIndexedEXT");
	printf("glEnableIndexedEXT            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glEnableTraceMESA");
	printf("glEnableTraceMESA             : %p\n", p);
	p = gl.OSMesaGetProcAddress("glEnableVariantClientStateEXT");
	printf("glEnableVariantClientStateEXT : %p\n", p);
	p = gl.OSMesaGetProcAddress("glEnableVertexArrayAttrib");
	printf("glEnableVertexArrayAttrib     : %p\n", p);
	p = gl.OSMesaGetProcAddress("glEnableVertexArrayAttribEXT");
	printf("glEnableVertexArrayAttribEXT  : %p\n", p);
	p = gl.OSMesaGetProcAddress("glEnableVertexArrayEXT");
	printf("glEnableVertexArrayEXT        : %p\n", p);
	p = gl.OSMesaGetProcAddress("glEnableVertexAttribAPPLE");
	printf("glEnableVertexAttribAPPLE     : %p\n", p);
	p = gl.OSMesaGetProcAddress("glEnableVertexAttribArray");
	printf("glEnableVertexAttribArray     : %p\n", p);
	p = gl.OSMesaGetProcAddress("glEnableVertexAttribArrayARB");
	printf("glEnableVertexAttribArrayARB  : %p\n", p);
	p = gl.OSMesaGetProcAddress("glEnablei");
	printf("glEnablei                     : %p\n", p);
	p = gl.OSMesaGetProcAddress("glEnd");
	printf("glEnd                         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glEndConditionalRender");
	printf("glEndConditionalRender        : %p\n", p);
	p = gl.OSMesaGetProcAddress("glEndConditionalRenderNV");
	printf("glEndConditionalRenderNV      : %p\n", p);
	p = gl.OSMesaGetProcAddress("glEndConditionalRenderNVX");
	printf("glEndConditionalRenderNVX     : %p\n", p);
	p = gl.OSMesaGetProcAddress("glEndFragmentShaderATI");
	printf("glEndFragmentShaderATI        : %p\n", p);
	p = gl.OSMesaGetProcAddress("glEndList");
	printf("glEndList                     : %p\n", p);
	p = gl.OSMesaGetProcAddress("glEndOcclusionQueryNV");
	printf("glEndOcclusionQueryNV         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glEndPerfMonitorAMD");
	printf("glEndPerfMonitorAMD           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glEndPerfQueryINTEL");
	printf("glEndPerfQueryINTEL           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glEndQuery");
	printf("glEndQuery                    : %p\n", p);
	p = gl.OSMesaGetProcAddress("glEndQueryARB");
	printf("glEndQueryARB                 : %p\n", p);
	p = gl.OSMesaGetProcAddress("glEndQueryIndexed");
	printf("glEndQueryIndexed             : %p\n", p);
	p = gl.OSMesaGetProcAddress("glEndTraceMESA");
	printf("glEndTraceMESA                : %p\n", p);
	p = gl.OSMesaGetProcAddress("glEndTransformFeedback");
	printf("glEndTransformFeedback        : %p\n", p);
	p = gl.OSMesaGetProcAddress("glEndTransformFeedbackEXT");
	printf("glEndTransformFeedbackEXT     : %p\n", p);
	p = gl.OSMesaGetProcAddress("glEndTransformFeedbackNV");
	printf("glEndTransformFeedbackNV      : %p\n", p);
	p = gl.OSMesaGetProcAddress("glEndVertexShaderEXT");
	printf("glEndVertexShaderEXT          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glEndVideoCaptureNV");
	printf("glEndVideoCaptureNV           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glEvalCoord1d");
	printf("glEvalCoord1d                 : %p\n", p);
	p = gl.OSMesaGetProcAddress("glEvalCoord1dv");
	printf("glEvalCoord1dv                : %p\n", p);
	p = gl.OSMesaGetProcAddress("glEvalCoord1f");
	printf("glEvalCoord1f                 : %p\n", p);
	p = gl.OSMesaGetProcAddress("glEvalCoord1fv");
	printf("glEvalCoord1fv                : %p\n", p);
	p = gl.OSMesaGetProcAddress("glEvalCoord1xOES");
	printf("glEvalCoord1xOES              : %p\n", p);
	p = gl.OSMesaGetProcAddress("glEvalCoord1xvOES");
	printf("glEvalCoord1xvOES             : %p\n", p);
	p = gl.OSMesaGetProcAddress("glEvalCoord2d");
	printf("glEvalCoord2d                 : %p\n", p);
	p = gl.OSMesaGetProcAddress("glEvalCoord2dv");
	printf("glEvalCoord2dv                : %p\n", p);
	p = gl.OSMesaGetProcAddress("glEvalCoord2f");
	printf("glEvalCoord2f                 : %p\n", p);
	p = gl.OSMesaGetProcAddress("glEvalCoord2fv");
	printf("glEvalCoord2fv                : %p\n", p);
	p = gl.OSMesaGetProcAddress("glEvalCoord2xOES");
	printf("glEvalCoord2xOES              : %p\n", p);
	p = gl.OSMesaGetProcAddress("glEvalCoord2xvOES");
	printf("glEvalCoord2xvOES             : %p\n", p);
	p = gl.OSMesaGetProcAddress("glEvalMapsNV");
	printf("glEvalMapsNV                  : %p\n", p);
	p = gl.OSMesaGetProcAddress("glEvalMesh1");
	printf("glEvalMesh1                   : %p\n", p);
	p = gl.OSMesaGetProcAddress("glEvalMesh2");
	printf("glEvalMesh2                   : %p\n", p);
	p = gl.OSMesaGetProcAddress("glEvalPoint1");
	printf("glEvalPoint1                  : %p\n", p);
	p = gl.OSMesaGetProcAddress("glEvalPoint2");
	printf("glEvalPoint2                  : %p\n", p);
	p = gl.OSMesaGetProcAddress("glEvaluateDepthValuesARB");
	printf("glEvaluateDepthValuesARB      : %p\n", p);
	p = gl.OSMesaGetProcAddress("glExecuteProgramNV");
	printf("glExecuteProgramNV            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glExtractComponentEXT");
	printf("glExtractComponentEXT         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glFeedbackBuffer");
	printf("glFeedbackBuffer              : %p\n", p);
	p = gl.OSMesaGetProcAddress("glFeedbackBufferxOES");
	printf("glFeedbackBufferxOES          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glFenceSync");
	printf("glFenceSync                   : %p\n", p);
	p = gl.OSMesaGetProcAddress("glFinalCombinerInputNV");
	printf("glFinalCombinerInputNV        : %p\n", p);
	p = gl.OSMesaGetProcAddress("glFinish");
	printf("glFinish                      : %p\n", p);
	p = gl.OSMesaGetProcAddress("glFinishAsyncSGIX");
	printf("glFinishAsyncSGIX             : %p\n", p);
	p = gl.OSMesaGetProcAddress("glFinishFenceAPPLE");
	printf("glFinishFenceAPPLE            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glFinishFenceNV");
	printf("glFinishFenceNV               : %p\n", p);
	p = gl.OSMesaGetProcAddress("glFinishObjectAPPLE");
	printf("glFinishObjectAPPLE           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glFinishRenderAPPLE");
	printf("glFinishRenderAPPLE           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glFinishTextureSUNX");
	printf("glFinishTextureSUNX           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glFlush");
	printf("glFlush                       : %p\n", p);
	p = gl.OSMesaGetProcAddress("glFlushMappedBufferRange");
	printf("glFlushMappedBufferRange      : %p\n", p);
	p = gl.OSMesaGetProcAddress("glFlushMappedBufferRangeAPPLE");
	printf("glFlushMappedBufferRangeAPPLE : %p\n", p);
	p = gl.OSMesaGetProcAddress("glFlushMappedNamedBufferRange");
	printf("glFlushMappedNamedBufferRange : %p\n", p);
	p = gl.OSMesaGetProcAddress("glFlushMappedNamedBufferRangeEXT");
	printf("glFlushMappedNamedBufferRangeEXT: %p\n", p);
	p = gl.OSMesaGetProcAddress("glFlushPixelDataRangeNV");
	printf("glFlushPixelDataRangeNV       : %p\n", p);
	p = gl.OSMesaGetProcAddress("glFlushRasterSGIX");
	printf("glFlushRasterSGIX             : %p\n", p);
	p = gl.OSMesaGetProcAddress("glFlushRenderAPPLE");
	printf("glFlushRenderAPPLE            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glFlushStaticDataIBM");
	printf("glFlushStaticDataIBM          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glFlushVertexArrayRangeAPPLE");
	printf("glFlushVertexArrayRangeAPPLE  : %p\n", p);
	p = gl.OSMesaGetProcAddress("glFlushVertexArrayRangeNV");
	printf("glFlushVertexArrayRangeNV     : %p\n", p);
	p = gl.OSMesaGetProcAddress("glFogCoordFormatNV");
	printf("glFogCoordFormatNV            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glFogCoordPointer");
	printf("glFogCoordPointer             : %p\n", p);
	p = gl.OSMesaGetProcAddress("glFogCoordPointerEXT");
	printf("glFogCoordPointerEXT          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glFogCoordPointerListIBM");
	printf("glFogCoordPointerListIBM      : %p\n", p);
	p = gl.OSMesaGetProcAddress("glFogCoordd");
	printf("glFogCoordd                   : %p\n", p);
	p = gl.OSMesaGetProcAddress("glFogCoorddEXT");
	printf("glFogCoorddEXT                : %p\n", p);
	p = gl.OSMesaGetProcAddress("glFogCoorddv");
	printf("glFogCoorddv                  : %p\n", p);
	p = gl.OSMesaGetProcAddress("glFogCoorddvEXT");
	printf("glFogCoorddvEXT               : %p\n", p);
	p = gl.OSMesaGetProcAddress("glFogCoordf");
	printf("glFogCoordf                   : %p\n", p);
	p = gl.OSMesaGetProcAddress("glFogCoordfEXT");
	printf("glFogCoordfEXT                : %p\n", p);
	p = gl.OSMesaGetProcAddress("glFogCoordfv");
	printf("glFogCoordfv                  : %p\n", p);
	p = gl.OSMesaGetProcAddress("glFogCoordfvEXT");
	printf("glFogCoordfvEXT               : %p\n", p);
	p = gl.OSMesaGetProcAddress("glFogCoordhNV");
	printf("glFogCoordhNV                 : %p\n", p);
	p = gl.OSMesaGetProcAddress("glFogCoordhvNV");
	printf("glFogCoordhvNV                : %p\n", p);
	p = gl.OSMesaGetProcAddress("glFogFuncSGIS");
	printf("glFogFuncSGIS                 : %p\n", p);
	p = gl.OSMesaGetProcAddress("glFogf");
	printf("glFogf                        : %p\n", p);
	p = gl.OSMesaGetProcAddress("glFogfv");
	printf("glFogfv                       : %p\n", p);
	p = gl.OSMesaGetProcAddress("glFogi");
	printf("glFogi                        : %p\n", p);
	p = gl.OSMesaGetProcAddress("glFogiv");
	printf("glFogiv                       : %p\n", p);
	p = gl.OSMesaGetProcAddress("glFogxOES");
	printf("glFogxOES                     : %p\n", p);
	p = gl.OSMesaGetProcAddress("glFogxvOES");
	printf("glFogxvOES                    : %p\n", p);
	p = gl.OSMesaGetProcAddress("glFragmentColorMaterialSGIX");
	printf("glFragmentColorMaterialSGIX   : %p\n", p);
	p = gl.OSMesaGetProcAddress("glFragmentCoverageColorNV");
	printf("glFragmentCoverageColorNV     : %p\n", p);
	p = gl.OSMesaGetProcAddress("glFragmentLightModelfSGIX");
	printf("glFragmentLightModelfSGIX     : %p\n", p);
	p = gl.OSMesaGetProcAddress("glFragmentLightModelfvSGIX");
	printf("glFragmentLightModelfvSGIX    : %p\n", p);
	p = gl.OSMesaGetProcAddress("glFragmentLightModeliSGIX");
	printf("glFragmentLightModeliSGIX     : %p\n", p);
	p = gl.OSMesaGetProcAddress("glFragmentLightModelivSGIX");
	printf("glFragmentLightModelivSGIX    : %p\n", p);
	p = gl.OSMesaGetProcAddress("glFragmentLightfSGIX");
	printf("glFragmentLightfSGIX          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glFragmentLightfvSGIX");
	printf("glFragmentLightfvSGIX         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glFragmentLightiSGIX");
	printf("glFragmentLightiSGIX          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glFragmentLightivSGIX");
	printf("glFragmentLightivSGIX         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glFragmentMaterialfSGIX");
	printf("glFragmentMaterialfSGIX       : %p\n", p);
	p = gl.OSMesaGetProcAddress("glFragmentMaterialfvSGIX");
	printf("glFragmentMaterialfvSGIX      : %p\n", p);
	p = gl.OSMesaGetProcAddress("glFragmentMaterialiSGIX");
	printf("glFragmentMaterialiSGIX       : %p\n", p);
	p = gl.OSMesaGetProcAddress("glFragmentMaterialivSGIX");
	printf("glFragmentMaterialivSGIX      : %p\n", p);
	p = gl.OSMesaGetProcAddress("glFrameTerminatorGREMEDY");
	printf("glFrameTerminatorGREMEDY      : %p\n", p);
	p = gl.OSMesaGetProcAddress("glFrameZoomSGIX");
	printf("glFrameZoomSGIX               : %p\n", p);
	p = gl.OSMesaGetProcAddress("glFramebufferDrawBufferEXT");
	printf("glFramebufferDrawBufferEXT    : %p\n", p);
	p = gl.OSMesaGetProcAddress("glFramebufferDrawBuffersEXT");
	printf("glFramebufferDrawBuffersEXT   : %p\n", p);
	p = gl.OSMesaGetProcAddress("glFramebufferParameteri");
	printf("glFramebufferParameteri       : %p\n", p);
	p = gl.OSMesaGetProcAddress("glFramebufferReadBufferEXT");
	printf("glFramebufferReadBufferEXT    : %p\n", p);
	p = gl.OSMesaGetProcAddress("glFramebufferRenderbuffer");
	printf("glFramebufferRenderbuffer     : %p\n", p);
	p = gl.OSMesaGetProcAddress("glFramebufferRenderbufferEXT");
	printf("glFramebufferRenderbufferEXT  : %p\n", p);
	p = gl.OSMesaGetProcAddress("glFramebufferSampleLocationsfvARB");
	printf("glFramebufferSampleLocationsfvARB: %p\n", p);
	p = gl.OSMesaGetProcAddress("glFramebufferSampleLocationsfvNV");
	printf("glFramebufferSampleLocationsfvNV: %p\n", p);
	p = gl.OSMesaGetProcAddress("glFramebufferSamplePositionsfvAMD");
	printf("glFramebufferSamplePositionsfvAMD: %p\n", p);
	p = gl.OSMesaGetProcAddress("glFramebufferTexture");
	printf("glFramebufferTexture          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glFramebufferTexture1D");
	printf("glFramebufferTexture1D        : %p\n", p);
	p = gl.OSMesaGetProcAddress("glFramebufferTexture1DEXT");
	printf("glFramebufferTexture1DEXT     : %p\n", p);
	p = gl.OSMesaGetProcAddress("glFramebufferTexture2D");
	printf("glFramebufferTexture2D        : %p\n", p);
	p = gl.OSMesaGetProcAddress("glFramebufferTexture2DEXT");
	printf("glFramebufferTexture2DEXT     : %p\n", p);
	p = gl.OSMesaGetProcAddress("glFramebufferTexture3D");
	printf("glFramebufferTexture3D        : %p\n", p);
	p = gl.OSMesaGetProcAddress("glFramebufferTexture3DEXT");
	printf("glFramebufferTexture3DEXT     : %p\n", p);
	p = gl.OSMesaGetProcAddress("glFramebufferTextureARB");
	printf("glFramebufferTextureARB       : %p\n", p);
	p = gl.OSMesaGetProcAddress("glFramebufferTextureEXT");
	printf("glFramebufferTextureEXT       : %p\n", p);
	p = gl.OSMesaGetProcAddress("glFramebufferTextureFaceARB");
	printf("glFramebufferTextureFaceARB   : %p\n", p);
	p = gl.OSMesaGetProcAddress("glFramebufferTextureFaceEXT");
	printf("glFramebufferTextureFaceEXT   : %p\n", p);
	p = gl.OSMesaGetProcAddress("glFramebufferTextureLayer");
	printf("glFramebufferTextureLayer     : %p\n", p);
	p = gl.OSMesaGetProcAddress("glFramebufferTextureLayerARB");
	printf("glFramebufferTextureLayerARB  : %p\n", p);
	p = gl.OSMesaGetProcAddress("glFramebufferTextureLayerEXT");
	printf("glFramebufferTextureLayerEXT  : %p\n", p);
	p = gl.OSMesaGetProcAddress("glFramebufferTextureMultiviewOVR");
	printf("glFramebufferTextureMultiviewOVR: %p\n", p);
	p = gl.OSMesaGetProcAddress("glFreeObjectBufferATI");
	printf("glFreeObjectBufferATI         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glFrontFace");
	printf("glFrontFace                   : %p\n", p);
	p = gl.OSMesaGetProcAddress("glFrustum");
	printf("glFrustum                     : %p\n", p);
	p = gl.OSMesaGetProcAddress("glFrustumf");
	printf("glFrustumf                    : %p\n", p);
	p = gl.OSMesaGetProcAddress("glFrustumfOES");
	printf("glFrustumfOES                 : %p\n", p);
	p = gl.OSMesaGetProcAddress("glFrustumxOES");
	printf("glFrustumxOES                 : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGenAsyncMarkersSGIX");
	printf("glGenAsyncMarkersSGIX         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGenBuffers");
	printf("glGenBuffers                  : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGenBuffersARB");
	printf("glGenBuffersARB               : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGenFencesAPPLE");
	printf("glGenFencesAPPLE              : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGenFencesNV");
	printf("glGenFencesNV                 : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGenFragmentShadersATI");
	printf("glGenFragmentShadersATI       : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGenFramebuffers");
	printf("glGenFramebuffers             : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGenFramebuffersEXT");
	printf("glGenFramebuffersEXT          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGenLists");
	printf("glGenLists                    : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGenNamesAMD");
	printf("glGenNamesAMD                 : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGenOcclusionQueriesNV");
	printf("glGenOcclusionQueriesNV       : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGenPathsNV");
	printf("glGenPathsNV                  : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGenPerfMonitorsAMD");
	printf("glGenPerfMonitorsAMD          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGenProgramPipelines");
	printf("glGenProgramPipelines         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGenProgramsARB");
	printf("glGenProgramsARB              : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGenProgramsNV");
	printf("glGenProgramsNV               : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGenQueries");
	printf("glGenQueries                  : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGenQueriesARB");
	printf("glGenQueriesARB               : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGenQueryResourceTagNV");
	printf("glGenQueryResourceTagNV       : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGenRenderbuffers");
	printf("glGenRenderbuffers            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGenRenderbuffersEXT");
	printf("glGenRenderbuffersEXT         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGenSamplers");
	printf("glGenSamplers                 : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGenSemaphoresEXT");
	printf("glGenSemaphoresEXT            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGenSymbolsEXT");
	printf("glGenSymbolsEXT               : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGenTextures");
	printf("glGenTextures                 : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGenTexturesEXT");
	printf("glGenTexturesEXT              : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGenTransformFeedbacks");
	printf("glGenTransformFeedbacks       : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGenTransformFeedbacksNV");
	printf("glGenTransformFeedbacksNV     : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGenVertexArrays");
	printf("glGenVertexArrays             : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGenVertexArraysAPPLE");
	printf("glGenVertexArraysAPPLE        : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGenVertexShadersEXT");
	printf("glGenVertexShadersEXT         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGenerateMipmap");
	printf("glGenerateMipmap              : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGenerateMipmapEXT");
	printf("glGenerateMipmapEXT           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGenerateMultiTexMipmapEXT");
	printf("glGenerateMultiTexMipmapEXT   : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGenerateTextureMipmap");
	printf("glGenerateTextureMipmap       : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGenerateTextureMipmapEXT");
	printf("glGenerateTextureMipmapEXT    : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetActiveAtomicCounterBufferiv");
	printf("glGetActiveAtomicCounterBufferiv: %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetActiveAttrib");
	printf("glGetActiveAttrib             : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetActiveAttribARB");
	printf("glGetActiveAttribARB          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetActiveSubroutineName");
	printf("glGetActiveSubroutineName     : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetActiveSubroutineUniformName");
	printf("glGetActiveSubroutineUniformName: %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetActiveSubroutineUniformiv");
	printf("glGetActiveSubroutineUniformiv: %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetActiveUniform");
	printf("glGetActiveUniform            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetActiveUniformARB");
	printf("glGetActiveUniformARB         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetActiveUniformBlockIndex");
	printf("glGetActiveUniformBlockIndex  : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetActiveUniformBlockName");
	printf("glGetActiveUniformBlockName   : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetActiveUniformBlockiv");
	printf("glGetActiveUniformBlockiv     : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetActiveUniformName");
	printf("glGetActiveUniformName        : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetActiveUniformsiv");
	printf("glGetActiveUniformsiv         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetActiveVaryingNV");
	printf("glGetActiveVaryingNV          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetArrayObjectfvATI");
	printf("glGetArrayObjectfvATI         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetArrayObjectivATI");
	printf("glGetArrayObjectivATI         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetAttachedObjectsARB");
	printf("glGetAttachedObjectsARB       : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetAttachedShaders");
	printf("glGetAttachedShaders          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetAttribLocation");
	printf("glGetAttribLocation           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetAttribLocationARB");
	printf("glGetAttribLocationARB        : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetBooleanIndexedvEXT");
	printf("glGetBooleanIndexedvEXT       : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetBooleani_v");
	printf("glGetBooleani_v               : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetBooleanv");
	printf("glGetBooleanv                 : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetBufferParameteri64v");
	printf("glGetBufferParameteri64v      : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetBufferParameteriv");
	printf("glGetBufferParameteriv        : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetBufferParameterivARB");
	printf("glGetBufferParameterivARB     : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetBufferParameterui64vNV");
	printf("glGetBufferParameterui64vNV   : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetBufferPointerv");
	printf("glGetBufferPointerv           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetBufferPointervARB");
	printf("glGetBufferPointervARB        : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetBufferSubData");
	printf("glGetBufferSubData            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetBufferSubDataARB");
	printf("glGetBufferSubDataARB         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetClipPlane");
	printf("glGetClipPlane                : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetClipPlanefOES");
	printf("glGetClipPlanefOES            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetClipPlanexOES");
	printf("glGetClipPlanexOES            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetColorTable");
	printf("glGetColorTable               : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetColorTableEXT");
	printf("glGetColorTableEXT            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetColorTableParameterfv");
	printf("glGetColorTableParameterfv    : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetColorTableParameterfvEXT");
	printf("glGetColorTableParameterfvEXT : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetColorTableParameterfvSGI");
	printf("glGetColorTableParameterfvSGI : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetColorTableParameteriv");
	printf("glGetColorTableParameteriv    : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetColorTableParameterivEXT");
	printf("glGetColorTableParameterivEXT : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetColorTableParameterivSGI");
	printf("glGetColorTableParameterivSGI : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetColorTableSGI");
	printf("glGetColorTableSGI            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetCombinerInputParameterfvNV");
	printf("glGetCombinerInputParameterfvNV: %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetCombinerInputParameterivNV");
	printf("glGetCombinerInputParameterivNV: %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetCombinerOutputParameterfvNV");
	printf("glGetCombinerOutputParameterfvNV: %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetCombinerOutputParameterivNV");
	printf("glGetCombinerOutputParameterivNV: %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetCombinerStageParameterfvNV");
	printf("glGetCombinerStageParameterfvNV: %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetCommandHeaderNV");
	printf("glGetCommandHeaderNV          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetCompressedMultiTexImageEXT");
	printf("glGetCompressedMultiTexImageEXT: %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetCompressedTexImage");
	printf("glGetCompressedTexImage       : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetCompressedTexImageARB");
	printf("glGetCompressedTexImageARB    : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetCompressedTextureImage");
	printf("glGetCompressedTextureImage   : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetCompressedTextureImageEXT");
	printf("glGetCompressedTextureImageEXT: %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetCompressedTextureSubImage");
	printf("glGetCompressedTextureSubImage: %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetConvolutionFilter");
	printf("glGetConvolutionFilter        : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetConvolutionFilterEXT");
	printf("glGetConvolutionFilterEXT     : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetConvolutionParameterfv");
	printf("glGetConvolutionParameterfv   : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetConvolutionParameterfvEXT");
	printf("glGetConvolutionParameterfvEXT: %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetConvolutionParameteriv");
	printf("glGetConvolutionParameteriv   : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetConvolutionParameterivEXT");
	printf("glGetConvolutionParameterivEXT: %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetConvolutionParameterxvOES");
	printf("glGetConvolutionParameterxvOES: %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetCoverageModulationTableNV");
	printf("glGetCoverageModulationTableNV: %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetDebugLogLengthMESA");
	printf("glGetDebugLogLengthMESA       : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetDebugLogMESA");
	printf("glGetDebugLogMESA             : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetDebugMessageLog");
	printf("glGetDebugMessageLog          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetDebugMessageLogAMD");
	printf("glGetDebugMessageLogAMD       : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetDebugMessageLogARB");
	printf("glGetDebugMessageLogARB       : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetDetailTexFuncSGIS");
	printf("glGetDetailTexFuncSGIS        : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetDoubleIndexedvEXT");
	printf("glGetDoubleIndexedvEXT        : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetDoublei_v");
	printf("glGetDoublei_v                : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetDoublei_vEXT");
	printf("glGetDoublei_vEXT             : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetDoublev");
	printf("glGetDoublev                  : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetError");
	printf("glGetError                    : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetFenceivNV");
	printf("glGetFenceivNV                : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetFinalCombinerInputParameterfvNV");
	printf("glGetFinalCombinerInputParameterfvNV: %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetFinalCombinerInputParameterivNV");
	printf("glGetFinalCombinerInputParameterivNV: %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetFirstPerfQueryIdINTEL");
	printf("glGetFirstPerfQueryIdINTEL    : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetFixedvOES");
	printf("glGetFixedvOES                : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetFloatIndexedvEXT");
	printf("glGetFloatIndexedvEXT         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetFloati_v");
	printf("glGetFloati_v                 : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetFloati_vEXT");
	printf("glGetFloati_vEXT              : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetFloatv");
	printf("glGetFloatv                   : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetFogFuncSGIS");
	printf("glGetFogFuncSGIS              : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetFragDataIndex");
	printf("glGetFragDataIndex            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetFragDataLocation");
	printf("glGetFragDataLocation         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetFragDataLocationEXT");
	printf("glGetFragDataLocationEXT      : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetFragmentLightfvSGIX");
	printf("glGetFragmentLightfvSGIX      : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetFragmentLightivSGIX");
	printf("glGetFragmentLightivSGIX      : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetFragmentMaterialfvSGIX");
	printf("glGetFragmentMaterialfvSGIX   : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetFragmentMaterialivSGIX");
	printf("glGetFragmentMaterialivSGIX   : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetFramebufferAttachmentParameteriv");
	printf("glGetFramebufferAttachmentParameteriv: %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetFramebufferAttachmentParameterivEXT");
	printf("glGetFramebufferAttachmentParameterivEXT: %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetFramebufferParameterfvAMD");
	printf("glGetFramebufferParameterfvAMD: %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetFramebufferParameteriv");
	printf("glGetFramebufferParameteriv   : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetFramebufferParameterivEXT");
	printf("glGetFramebufferParameterivEXT: %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetGraphicsResetStatus");
	printf("glGetGraphicsResetStatus      : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetGraphicsResetStatusARB");
	printf("glGetGraphicsResetStatusARB   : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetHandleARB");
	printf("glGetHandleARB                : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetHistogram");
	printf("glGetHistogram                : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetHistogramEXT");
	printf("glGetHistogramEXT             : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetHistogramParameterfv");
	printf("glGetHistogramParameterfv     : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetHistogramParameterfvEXT");
	printf("glGetHistogramParameterfvEXT  : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetHistogramParameteriv");
	printf("glGetHistogramParameteriv     : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetHistogramParameterivEXT");
	printf("glGetHistogramParameterivEXT  : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetHistogramParameterxvOES");
	printf("glGetHistogramParameterxvOES  : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetImageHandleARB");
	printf("glGetImageHandleARB           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetImageHandleNV");
	printf("glGetImageHandleNV            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetImageTransformParameterfvHP");
	printf("glGetImageTransformParameterfvHP: %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetImageTransformParameterivHP");
	printf("glGetImageTransformParameterivHP: %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetInfoLogARB");
	printf("glGetInfoLogARB               : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetInstrumentsSGIX");
	printf("glGetInstrumentsSGIX          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetInteger64i_v");
	printf("glGetInteger64i_v             : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetInteger64v");
	printf("glGetInteger64v               : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetIntegerIndexedvEXT");
	printf("glGetIntegerIndexedvEXT       : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetIntegeri_v");
	printf("glGetIntegeri_v               : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetIntegerui64i_vNV");
	printf("glGetIntegerui64i_vNV         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetIntegerui64vNV");
	printf("glGetIntegerui64vNV           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetIntegerv");
	printf("glGetIntegerv                 : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetInternalformatSampleivNV");
	printf("glGetInternalformatSampleivNV : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetInternalformati64v");
	printf("glGetInternalformati64v       : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetInternalformativ");
	printf("glGetInternalformativ         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetInvariantBooleanvEXT");
	printf("glGetInvariantBooleanvEXT     : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetInvariantFloatvEXT");
	printf("glGetInvariantFloatvEXT       : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetInvariantIntegervEXT");
	printf("glGetInvariantIntegervEXT     : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetLightfv");
	printf("glGetLightfv                  : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetLightiv");
	printf("glGetLightiv                  : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetLightxOES");
	printf("glGetLightxOES                : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetListParameterfvSGIX");
	printf("glGetListParameterfvSGIX      : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetListParameterivSGIX");
	printf("glGetListParameterivSGIX      : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetLocalConstantBooleanvEXT");
	printf("glGetLocalConstantBooleanvEXT : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetLocalConstantFloatvEXT");
	printf("glGetLocalConstantFloatvEXT   : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetLocalConstantIntegervEXT");
	printf("glGetLocalConstantIntegervEXT : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetMapAttribParameterfvNV");
	printf("glGetMapAttribParameterfvNV   : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetMapAttribParameterivNV");
	printf("glGetMapAttribParameterivNV   : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetMapControlPointsNV");
	printf("glGetMapControlPointsNV       : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetMapParameterfvNV");
	printf("glGetMapParameterfvNV         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetMapParameterivNV");
	printf("glGetMapParameterivNV         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetMapdv");
	printf("glGetMapdv                    : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetMapfv");
	printf("glGetMapfv                    : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetMapiv");
	printf("glGetMapiv                    : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetMapxvOES");
	printf("glGetMapxvOES                 : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetMaterialfv");
	printf("glGetMaterialfv               : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetMaterialiv");
	printf("glGetMaterialiv               : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetMaterialxOES");
	printf("glGetMaterialxOES             : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetMemoryObjectParameterivEXT");
	printf("glGetMemoryObjectParameterivEXT: %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetMinmax");
	printf("glGetMinmax                   : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetMinmaxEXT");
	printf("glGetMinmaxEXT                : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetMinmaxParameterfv");
	printf("glGetMinmaxParameterfv        : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetMinmaxParameterfvEXT");
	printf("glGetMinmaxParameterfvEXT     : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetMinmaxParameteriv");
	printf("glGetMinmaxParameteriv        : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetMinmaxParameterivEXT");
	printf("glGetMinmaxParameterivEXT     : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetMultiTexEnvfvEXT");
	printf("glGetMultiTexEnvfvEXT         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetMultiTexEnvivEXT");
	printf("glGetMultiTexEnvivEXT         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetMultiTexGendvEXT");
	printf("glGetMultiTexGendvEXT         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetMultiTexGenfvEXT");
	printf("glGetMultiTexGenfvEXT         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetMultiTexGenivEXT");
	printf("glGetMultiTexGenivEXT         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetMultiTexImageEXT");
	printf("glGetMultiTexImageEXT         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetMultiTexLevelParameterfvEXT");
	printf("glGetMultiTexLevelParameterfvEXT: %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetMultiTexLevelParameterivEXT");
	printf("glGetMultiTexLevelParameterivEXT: %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetMultiTexParameterIivEXT");
	printf("glGetMultiTexParameterIivEXT  : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetMultiTexParameterIuivEXT");
	printf("glGetMultiTexParameterIuivEXT : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetMultiTexParameterfvEXT");
	printf("glGetMultiTexParameterfvEXT   : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetMultiTexParameterivEXT");
	printf("glGetMultiTexParameterivEXT   : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetMultisamplefv");
	printf("glGetMultisamplefv            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetMultisamplefvNV");
	printf("glGetMultisamplefvNV          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetNamedBufferParameteri64v");
	printf("glGetNamedBufferParameteri64v : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetNamedBufferParameteriv");
	printf("glGetNamedBufferParameteriv   : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetNamedBufferParameterivEXT");
	printf("glGetNamedBufferParameterivEXT: %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetNamedBufferParameterui64vNV");
	printf("glGetNamedBufferParameterui64vNV: %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetNamedBufferPointerv");
	printf("glGetNamedBufferPointerv      : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetNamedBufferPointervEXT");
	printf("glGetNamedBufferPointervEXT   : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetNamedBufferSubData");
	printf("glGetNamedBufferSubData       : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetNamedBufferSubDataEXT");
	printf("glGetNamedBufferSubDataEXT    : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetNamedFramebufferAttachmentParameteriv");
	printf("glGetNamedFramebufferAttachmentParameteriv: %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetNamedFramebufferAttachmentParameterivEXT");
	printf("glGetNamedFramebufferAttachmentParameterivEXT: %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetNamedFramebufferParameterfvAMD");
	printf("glGetNamedFramebufferParameterfvAMD: %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetNamedFramebufferParameteriv");
	printf("glGetNamedFramebufferParameteriv: %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetNamedFramebufferParameterivEXT");
	printf("glGetNamedFramebufferParameterivEXT: %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetNamedProgramLocalParameterIivEXT");
	printf("glGetNamedProgramLocalParameterIivEXT: %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetNamedProgramLocalParameterIuivEXT");
	printf("glGetNamedProgramLocalParameterIuivEXT: %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetNamedProgramLocalParameterdvEXT");
	printf("glGetNamedProgramLocalParameterdvEXT: %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetNamedProgramLocalParameterfvEXT");
	printf("glGetNamedProgramLocalParameterfvEXT: %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetNamedProgramStringEXT");
	printf("glGetNamedProgramStringEXT    : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetNamedProgramivEXT");
	printf("glGetNamedProgramivEXT        : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetNamedRenderbufferParameteriv");
	printf("glGetNamedRenderbufferParameteriv: %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetNamedRenderbufferParameterivEXT");
	printf("glGetNamedRenderbufferParameterivEXT: %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetNamedStringARB");
	printf("glGetNamedStringARB           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetNamedStringivARB");
	printf("glGetNamedStringivARB         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetNextPerfQueryIdINTEL");
	printf("glGetNextPerfQueryIdINTEL     : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetObjectBufferfvATI");
	printf("glGetObjectBufferfvATI        : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetObjectBufferivATI");
	printf("glGetObjectBufferivATI        : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetObjectLabel");
	printf("glGetObjectLabel              : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetObjectLabelEXT");
	printf("glGetObjectLabelEXT           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetObjectParameterfvARB");
	printf("glGetObjectParameterfvARB     : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetObjectParameterivAPPLE");
	printf("glGetObjectParameterivAPPLE   : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetObjectParameterivARB");
	printf("glGetObjectParameterivARB     : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetObjectPtrLabel");
	printf("glGetObjectPtrLabel           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetOcclusionQueryivNV");
	printf("glGetOcclusionQueryivNV       : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetOcclusionQueryuivNV");
	printf("glGetOcclusionQueryuivNV      : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetPathColorGenfvNV");
	printf("glGetPathColorGenfvNV         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetPathColorGenivNV");
	printf("glGetPathColorGenivNV         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetPathCommandsNV");
	printf("glGetPathCommandsNV           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetPathCoordsNV");
	printf("glGetPathCoordsNV             : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetPathDashArrayNV");
	printf("glGetPathDashArrayNV          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetPathLengthNV");
	printf("glGetPathLengthNV             : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetPathMetricRangeNV");
	printf("glGetPathMetricRangeNV        : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetPathMetricsNV");
	printf("glGetPathMetricsNV            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetPathParameterfvNV");
	printf("glGetPathParameterfvNV        : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetPathParameterivNV");
	printf("glGetPathParameterivNV        : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetPathSpacingNV");
	printf("glGetPathSpacingNV            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetPathTexGenfvNV");
	printf("glGetPathTexGenfvNV           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetPathTexGenivNV");
	printf("glGetPathTexGenivNV           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetPerfCounterInfoINTEL");
	printf("glGetPerfCounterInfoINTEL     : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetPerfMonitorCounterDataAMD");
	printf("glGetPerfMonitorCounterDataAMD: %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetPerfMonitorCounterInfoAMD");
	printf("glGetPerfMonitorCounterInfoAMD: %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetPerfMonitorCounterStringAMD");
	printf("glGetPerfMonitorCounterStringAMD: %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetPerfMonitorCountersAMD");
	printf("glGetPerfMonitorCountersAMD   : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetPerfMonitorGroupStringAMD");
	printf("glGetPerfMonitorGroupStringAMD: %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetPerfMonitorGroupsAMD");
	printf("glGetPerfMonitorGroupsAMD     : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetPerfQueryDataINTEL");
	printf("glGetPerfQueryDataINTEL       : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetPerfQueryIdByNameINTEL");
	printf("glGetPerfQueryIdByNameINTEL   : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetPerfQueryInfoINTEL");
	printf("glGetPerfQueryInfoINTEL       : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetPixelMapfv");
	printf("glGetPixelMapfv               : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetPixelMapuiv");
	printf("glGetPixelMapuiv              : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetPixelMapusv");
	printf("glGetPixelMapusv              : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetPixelMapxv");
	printf("glGetPixelMapxv               : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetPixelTexGenParameterfvSGIS");
	printf("glGetPixelTexGenParameterfvSGIS: %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetPixelTexGenParameterivSGIS");
	printf("glGetPixelTexGenParameterivSGIS: %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetPixelTransformParameterfvEXT");
	printf("glGetPixelTransformParameterfvEXT: %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetPixelTransformParameterivEXT");
	printf("glGetPixelTransformParameterivEXT: %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetPointerIndexedvEXT");
	printf("glGetPointerIndexedvEXT       : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetPointeri_vEXT");
	printf("glGetPointeri_vEXT            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetPointerv");
	printf("glGetPointerv                 : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetPointervEXT");
	printf("glGetPointervEXT              : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetPolygonStipple");
	printf("glGetPolygonStipple           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetProgramBinary");
	printf("glGetProgramBinary            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetProgramEnvParameterIivNV");
	printf("glGetProgramEnvParameterIivNV : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetProgramEnvParameterIuivNV");
	printf("glGetProgramEnvParameterIuivNV: %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetProgramEnvParameterdvARB");
	printf("glGetProgramEnvParameterdvARB : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetProgramEnvParameterfvARB");
	printf("glGetProgramEnvParameterfvARB : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetProgramInfoLog");
	printf("glGetProgramInfoLog           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetProgramInterfaceiv");
	printf("glGetProgramInterfaceiv       : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetProgramLocalParameterIivNV");
	printf("glGetProgramLocalParameterIivNV: %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetProgramLocalParameterIuivNV");
	printf("glGetProgramLocalParameterIuivNV: %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetProgramLocalParameterdvARB");
	printf("glGetProgramLocalParameterdvARB: %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetProgramLocalParameterfvARB");
	printf("glGetProgramLocalParameterfvARB: %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetProgramNamedParameterdvNV");
	printf("glGetProgramNamedParameterdvNV: %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetProgramNamedParameterfvNV");
	printf("glGetProgramNamedParameterfvNV: %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetProgramParameterdvNV");
	printf("glGetProgramParameterdvNV     : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetProgramParameterfvNV");
	printf("glGetProgramParameterfvNV     : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetProgramPipelineInfoLog");
	printf("glGetProgramPipelineInfoLog   : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetProgramPipelineiv");
	printf("glGetProgramPipelineiv        : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetProgramRegisterfvMESA");
	printf("glGetProgramRegisterfvMESA    : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetProgramResourceIndex");
	printf("glGetProgramResourceIndex     : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetProgramResourceLocation");
	printf("glGetProgramResourceLocation  : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetProgramResourceLocationIndex");
	printf("glGetProgramResourceLocationIndex: %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetProgramResourceName");
	printf("glGetProgramResourceName      : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetProgramResourcefvNV");
	printf("glGetProgramResourcefvNV      : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetProgramResourceiv");
	printf("glGetProgramResourceiv        : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetProgramStageiv");
	printf("glGetProgramStageiv           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetProgramStringARB");
	printf("glGetProgramStringARB         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetProgramStringNV");
	printf("glGetProgramStringNV          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetProgramSubroutineParameteruivNV");
	printf("glGetProgramSubroutineParameteruivNV: %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetProgramiv");
	printf("glGetProgramiv                : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetProgramivARB");
	printf("glGetProgramivARB             : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetProgramivNV");
	printf("glGetProgramivNV              : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetQueryBufferObjecti64v");
	printf("glGetQueryBufferObjecti64v    : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetQueryBufferObjectiv");
	printf("glGetQueryBufferObjectiv      : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetQueryBufferObjectui64v");
	printf("glGetQueryBufferObjectui64v   : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetQueryBufferObjectuiv");
	printf("glGetQueryBufferObjectuiv     : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetQueryIndexediv");
	printf("glGetQueryIndexediv           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetQueryObjecti64v");
	printf("glGetQueryObjecti64v          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetQueryObjecti64vEXT");
	printf("glGetQueryObjecti64vEXT       : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetQueryObjectiv");
	printf("glGetQueryObjectiv            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetQueryObjectivARB");
	printf("glGetQueryObjectivARB         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetQueryObjectui64v");
	printf("glGetQueryObjectui64v         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetQueryObjectui64vEXT");
	printf("glGetQueryObjectui64vEXT      : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetQueryObjectuiv");
	printf("glGetQueryObjectuiv           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetQueryObjectuivARB");
	printf("glGetQueryObjectuivARB        : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetQueryiv");
	printf("glGetQueryiv                  : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetQueryivARB");
	printf("glGetQueryivARB               : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetRenderbufferParameteriv");
	printf("glGetRenderbufferParameteriv  : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetRenderbufferParameterivEXT");
	printf("glGetRenderbufferParameterivEXT: %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetSamplerParameterIiv");
	printf("glGetSamplerParameterIiv      : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetSamplerParameterIuiv");
	printf("glGetSamplerParameterIuiv     : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetSamplerParameterfv");
	printf("glGetSamplerParameterfv       : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetSamplerParameteriv");
	printf("glGetSamplerParameteriv       : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetSemaphoreParameterui64vEXT");
	printf("glGetSemaphoreParameterui64vEXT: %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetSeparableFilter");
	printf("glGetSeparableFilter          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetSeparableFilterEXT");
	printf("glGetSeparableFilterEXT       : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetShaderInfoLog");
	printf("glGetShaderInfoLog            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetShaderPrecisionFormat");
	printf("glGetShaderPrecisionFormat    : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetShaderSource");
	printf("glGetShaderSource             : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetShaderSourceARB");
	printf("glGetShaderSourceARB          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetShaderiv");
	printf("glGetShaderiv                 : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetSharpenTexFuncSGIS");
	printf("glGetSharpenTexFuncSGIS       : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetStageIndexNV");
	printf("glGetStageIndexNV             : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetString");
	printf("glGetString                   : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetStringi");
	printf("glGetStringi                  : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetSubroutineIndex");
	printf("glGetSubroutineIndex          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetSubroutineUniformLocation");
	printf("glGetSubroutineUniformLocation: %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetSynciv");
	printf("glGetSynciv                   : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetTexBumpParameterfvATI");
	printf("glGetTexBumpParameterfvATI    : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetTexBumpParameterivATI");
	printf("glGetTexBumpParameterivATI    : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetTexEnvfv");
	printf("glGetTexEnvfv                 : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetTexEnviv");
	printf("glGetTexEnviv                 : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetTexEnvxvOES");
	printf("glGetTexEnvxvOES              : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetTexFilterFuncSGIS");
	printf("glGetTexFilterFuncSGIS        : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetTexGendv");
	printf("glGetTexGendv                 : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetTexGenfv");
	printf("glGetTexGenfv                 : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetTexGeniv");
	printf("glGetTexGeniv                 : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetTexGenxvOES");
	printf("glGetTexGenxvOES              : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetTexImage");
	printf("glGetTexImage                 : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetTexLevelParameterfv");
	printf("glGetTexLevelParameterfv      : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetTexLevelParameteriv");
	printf("glGetTexLevelParameteriv      : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetTexLevelParameterxvOES");
	printf("glGetTexLevelParameterxvOES   : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetTexParameterIiv");
	printf("glGetTexParameterIiv          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetTexParameterIivEXT");
	printf("glGetTexParameterIivEXT       : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetTexParameterIuiv");
	printf("glGetTexParameterIuiv         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetTexParameterIuivEXT");
	printf("glGetTexParameterIuivEXT      : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetTexParameterPointervAPPLE");
	printf("glGetTexParameterPointervAPPLE: %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetTexParameterfv");
	printf("glGetTexParameterfv           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetTexParameteriv");
	printf("glGetTexParameteriv           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetTexParameterxvOES");
	printf("glGetTexParameterxvOES        : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetTextureHandleARB");
	printf("glGetTextureHandleARB         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetTextureHandleNV");
	printf("glGetTextureHandleNV          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetTextureImage");
	printf("glGetTextureImage             : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetTextureImageEXT");
	printf("glGetTextureImageEXT          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetTextureLevelParameterfv");
	printf("glGetTextureLevelParameterfv  : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetTextureLevelParameterfvEXT");
	printf("glGetTextureLevelParameterfvEXT: %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetTextureLevelParameteriv");
	printf("glGetTextureLevelParameteriv  : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetTextureLevelParameterivEXT");
	printf("glGetTextureLevelParameterivEXT: %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetTextureParameterIiv");
	printf("glGetTextureParameterIiv      : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetTextureParameterIivEXT");
	printf("glGetTextureParameterIivEXT   : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetTextureParameterIuiv");
	printf("glGetTextureParameterIuiv     : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetTextureParameterIuivEXT");
	printf("glGetTextureParameterIuivEXT  : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetTextureParameterfv");
	printf("glGetTextureParameterfv       : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetTextureParameterfvEXT");
	printf("glGetTextureParameterfvEXT    : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetTextureParameteriv");
	printf("glGetTextureParameteriv       : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetTextureParameterivEXT");
	printf("glGetTextureParameterivEXT    : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetTextureSamplerHandleARB");
	printf("glGetTextureSamplerHandleARB  : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetTextureSamplerHandleNV");
	printf("glGetTextureSamplerHandleNV   : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetTextureSubImage");
	printf("glGetTextureSubImage          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetTrackMatrixivNV");
	printf("glGetTrackMatrixivNV          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetTransformFeedbackVarying");
	printf("glGetTransformFeedbackVarying : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetTransformFeedbackVaryingEXT");
	printf("glGetTransformFeedbackVaryingEXT: %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetTransformFeedbackVaryingNV");
	printf("glGetTransformFeedbackVaryingNV: %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetTransformFeedbacki64_v");
	printf("glGetTransformFeedbacki64_v   : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetTransformFeedbacki_v");
	printf("glGetTransformFeedbacki_v     : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetTransformFeedbackiv");
	printf("glGetTransformFeedbackiv      : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetUniformBlockIndex");
	printf("glGetUniformBlockIndex        : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetUniformBufferSizeEXT");
	printf("glGetUniformBufferSizeEXT     : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetUniformIndices");
	printf("glGetUniformIndices           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetUniformLocation");
	printf("glGetUniformLocation          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetUniformLocationARB");
	printf("glGetUniformLocationARB       : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetUniformOffsetEXT");
	printf("glGetUniformOffsetEXT         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetUniformSubroutineuiv");
	printf("glGetUniformSubroutineuiv     : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetUniformdv");
	printf("glGetUniformdv                : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetUniformfv");
	printf("glGetUniformfv                : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetUniformfvARB");
	printf("glGetUniformfvARB             : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetUniformi64vARB");
	printf("glGetUniformi64vARB           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetUniformi64vNV");
	printf("glGetUniformi64vNV            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetUniformiv");
	printf("glGetUniformiv                : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetUniformivARB");
	printf("glGetUniformivARB             : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetUniformui64vARB");
	printf("glGetUniformui64vARB          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetUniformui64vNV");
	printf("glGetUniformui64vNV           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetUniformuiv");
	printf("glGetUniformuiv               : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetUniformuivEXT");
	printf("glGetUniformuivEXT            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetUnsignedBytei_vEXT");
	printf("glGetUnsignedBytei_vEXT       : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetUnsignedBytevEXT");
	printf("glGetUnsignedBytevEXT         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetVariantArrayObjectfvATI");
	printf("glGetVariantArrayObjectfvATI  : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetVariantArrayObjectivATI");
	printf("glGetVariantArrayObjectivATI  : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetVariantBooleanvEXT");
	printf("glGetVariantBooleanvEXT       : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetVariantFloatvEXT");
	printf("glGetVariantFloatvEXT         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetVariantIntegervEXT");
	printf("glGetVariantIntegervEXT       : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetVariantPointervEXT");
	printf("glGetVariantPointervEXT       : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetVaryingLocationNV");
	printf("glGetVaryingLocationNV        : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetVertexArrayIndexed64iv");
	printf("glGetVertexArrayIndexed64iv   : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetVertexArrayIndexediv");
	printf("glGetVertexArrayIndexediv     : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetVertexArrayIntegeri_vEXT");
	printf("glGetVertexArrayIntegeri_vEXT : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetVertexArrayIntegervEXT");
	printf("glGetVertexArrayIntegervEXT   : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetVertexArrayPointeri_vEXT");
	printf("glGetVertexArrayPointeri_vEXT : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetVertexArrayPointervEXT");
	printf("glGetVertexArrayPointervEXT   : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetVertexArrayiv");
	printf("glGetVertexArrayiv            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetVertexAttribArrayObjectfvATI");
	printf("glGetVertexAttribArrayObjectfvATI: %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetVertexAttribArrayObjectivATI");
	printf("glGetVertexAttribArrayObjectivATI: %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetVertexAttribIiv");
	printf("glGetVertexAttribIiv          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetVertexAttribIivEXT");
	printf("glGetVertexAttribIivEXT       : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetVertexAttribIuiv");
	printf("glGetVertexAttribIuiv         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetVertexAttribIuivEXT");
	printf("glGetVertexAttribIuivEXT      : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetVertexAttribLdv");
	printf("glGetVertexAttribLdv          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetVertexAttribLdvEXT");
	printf("glGetVertexAttribLdvEXT       : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetVertexAttribLi64vNV");
	printf("glGetVertexAttribLi64vNV      : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetVertexAttribLui64vARB");
	printf("glGetVertexAttribLui64vARB    : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetVertexAttribLui64vNV");
	printf("glGetVertexAttribLui64vNV     : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetVertexAttribPointerv");
	printf("glGetVertexAttribPointerv     : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetVertexAttribPointervARB");
	printf("glGetVertexAttribPointervARB  : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetVertexAttribPointervNV");
	printf("glGetVertexAttribPointervNV   : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetVertexAttribdv");
	printf("glGetVertexAttribdv           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetVertexAttribdvARB");
	printf("glGetVertexAttribdvARB        : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetVertexAttribdvNV");
	printf("glGetVertexAttribdvNV         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetVertexAttribfv");
	printf("glGetVertexAttribfv           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetVertexAttribfvARB");
	printf("glGetVertexAttribfvARB        : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetVertexAttribfvNV");
	printf("glGetVertexAttribfvNV         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetVertexAttribiv");
	printf("glGetVertexAttribiv           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetVertexAttribivARB");
	printf("glGetVertexAttribivARB        : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetVertexAttribivNV");
	printf("glGetVertexAttribivNV         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetVideoCaptureStreamdvNV");
	printf("glGetVideoCaptureStreamdvNV   : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetVideoCaptureStreamfvNV");
	printf("glGetVideoCaptureStreamfvNV   : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetVideoCaptureStreamivNV");
	printf("glGetVideoCaptureStreamivNV   : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetVideoCaptureivNV");
	printf("glGetVideoCaptureivNV         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetVideoi64vNV");
	printf("glGetVideoi64vNV              : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetVideoivNV");
	printf("glGetVideoivNV                : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetVideoui64vNV");
	printf("glGetVideoui64vNV             : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetVideouivNV");
	printf("glGetVideouivNV               : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetVkProcAddrNV");
	printf("glGetVkProcAddrNV             : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetnColorTable");
	printf("glGetnColorTable              : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetnColorTableARB");
	printf("glGetnColorTableARB           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetnCompressedTexImage");
	printf("glGetnCompressedTexImage      : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetnCompressedTexImageARB");
	printf("glGetnCompressedTexImageARB   : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetnConvolutionFilter");
	printf("glGetnConvolutionFilter       : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetnConvolutionFilterARB");
	printf("glGetnConvolutionFilterARB    : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetnHistogram");
	printf("glGetnHistogram               : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetnHistogramARB");
	printf("glGetnHistogramARB            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetnMapdv");
	printf("glGetnMapdv                   : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetnMapdvARB");
	printf("glGetnMapdvARB                : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetnMapfv");
	printf("glGetnMapfv                   : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetnMapfvARB");
	printf("glGetnMapfvARB                : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetnMapiv");
	printf("glGetnMapiv                   : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetnMapivARB");
	printf("glGetnMapivARB                : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetnMinmax");
	printf("glGetnMinmax                  : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetnMinmaxARB");
	printf("glGetnMinmaxARB               : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetnPixelMapfv");
	printf("glGetnPixelMapfv              : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetnPixelMapfvARB");
	printf("glGetnPixelMapfvARB           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetnPixelMapuiv");
	printf("glGetnPixelMapuiv             : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetnPixelMapuivARB");
	printf("glGetnPixelMapuivARB          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetnPixelMapusv");
	printf("glGetnPixelMapusv             : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetnPixelMapusvARB");
	printf("glGetnPixelMapusvARB          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetnPolygonStipple");
	printf("glGetnPolygonStipple          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetnPolygonStippleARB");
	printf("glGetnPolygonStippleARB       : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetnSeparableFilter");
	printf("glGetnSeparableFilter         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetnSeparableFilterARB");
	printf("glGetnSeparableFilterARB      : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetnTexImage");
	printf("glGetnTexImage                : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetnTexImageARB");
	printf("glGetnTexImageARB             : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetnUniformdv");
	printf("glGetnUniformdv               : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetnUniformdvARB");
	printf("glGetnUniformdvARB            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetnUniformfv");
	printf("glGetnUniformfv               : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetnUniformfvARB");
	printf("glGetnUniformfvARB            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetnUniformi64vARB");
	printf("glGetnUniformi64vARB          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetnUniformiv");
	printf("glGetnUniformiv               : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetnUniformivARB");
	printf("glGetnUniformivARB            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetnUniformui64vARB");
	printf("glGetnUniformui64vARB         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetnUniformuiv");
	printf("glGetnUniformuiv              : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGetnUniformuivARB");
	printf("glGetnUniformuivARB           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGlobalAlphaFactorbSUN");
	printf("glGlobalAlphaFactorbSUN       : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGlobalAlphaFactordSUN");
	printf("glGlobalAlphaFactordSUN       : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGlobalAlphaFactorfSUN");
	printf("glGlobalAlphaFactorfSUN       : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGlobalAlphaFactoriSUN");
	printf("glGlobalAlphaFactoriSUN       : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGlobalAlphaFactorsSUN");
	printf("glGlobalAlphaFactorsSUN       : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGlobalAlphaFactorubSUN");
	printf("glGlobalAlphaFactorubSUN      : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGlobalAlphaFactoruiSUN");
	printf("glGlobalAlphaFactoruiSUN      : %p\n", p);
	p = gl.OSMesaGetProcAddress("glGlobalAlphaFactorusSUN");
	printf("glGlobalAlphaFactorusSUN      : %p\n", p);
	p = gl.OSMesaGetProcAddress("glHint");
	printf("glHint                        : %p\n", p);
	p = gl.OSMesaGetProcAddress("glHintPGI");
	printf("glHintPGI                     : %p\n", p);
	p = gl.OSMesaGetProcAddress("glHistogram");
	printf("glHistogram                   : %p\n", p);
	p = gl.OSMesaGetProcAddress("glHistogramEXT");
	printf("glHistogramEXT                : %p\n", p);
	p = gl.OSMesaGetProcAddress("glIglooInterfaceSGIX");
	printf("glIglooInterfaceSGIX          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glImageTransformParameterfHP");
	printf("glImageTransformParameterfHP  : %p\n", p);
	p = gl.OSMesaGetProcAddress("glImageTransformParameterfvHP");
	printf("glImageTransformParameterfvHP : %p\n", p);
	p = gl.OSMesaGetProcAddress("glImageTransformParameteriHP");
	printf("glImageTransformParameteriHP  : %p\n", p);
	p = gl.OSMesaGetProcAddress("glImageTransformParameterivHP");
	printf("glImageTransformParameterivHP : %p\n", p);
	p = gl.OSMesaGetProcAddress("glImportMemoryFdEXT");
	printf("glImportMemoryFdEXT           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glImportMemoryWin32HandleEXT");
	printf("glImportMemoryWin32HandleEXT  : %p\n", p);
	p = gl.OSMesaGetProcAddress("glImportMemoryWin32NameEXT");
	printf("glImportMemoryWin32NameEXT    : %p\n", p);
	p = gl.OSMesaGetProcAddress("glImportSemaphoreFdEXT");
	printf("glImportSemaphoreFdEXT        : %p\n", p);
	p = gl.OSMesaGetProcAddress("glImportSemaphoreWin32HandleEXT");
	printf("glImportSemaphoreWin32HandleEXT: %p\n", p);
	p = gl.OSMesaGetProcAddress("glImportSemaphoreWin32NameEXT");
	printf("glImportSemaphoreWin32NameEXT : %p\n", p);
	p = gl.OSMesaGetProcAddress("glImportSyncEXT");
	printf("glImportSyncEXT               : %p\n", p);
	p = gl.OSMesaGetProcAddress("glIndexFormatNV");
	printf("glIndexFormatNV               : %p\n", p);
	p = gl.OSMesaGetProcAddress("glIndexFuncEXT");
	printf("glIndexFuncEXT                : %p\n", p);
	p = gl.OSMesaGetProcAddress("glIndexMask");
	printf("glIndexMask                   : %p\n", p);
	p = gl.OSMesaGetProcAddress("glIndexMaterialEXT");
	printf("glIndexMaterialEXT            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glIndexPointer");
	printf("glIndexPointer                : %p\n", p);
	p = gl.OSMesaGetProcAddress("glIndexPointerEXT");
	printf("glIndexPointerEXT             : %p\n", p);
	p = gl.OSMesaGetProcAddress("glIndexPointerListIBM");
	printf("glIndexPointerListIBM         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glIndexd");
	printf("glIndexd                      : %p\n", p);
	p = gl.OSMesaGetProcAddress("glIndexdv");
	printf("glIndexdv                     : %p\n", p);
	p = gl.OSMesaGetProcAddress("glIndexf");
	printf("glIndexf                      : %p\n", p);
	p = gl.OSMesaGetProcAddress("glIndexfv");
	printf("glIndexfv                     : %p\n", p);
	p = gl.OSMesaGetProcAddress("glIndexi");
	printf("glIndexi                      : %p\n", p);
	p = gl.OSMesaGetProcAddress("glIndexiv");
	printf("glIndexiv                     : %p\n", p);
	p = gl.OSMesaGetProcAddress("glIndexs");
	printf("glIndexs                      : %p\n", p);
	p = gl.OSMesaGetProcAddress("glIndexsv");
	printf("glIndexsv                     : %p\n", p);
	p = gl.OSMesaGetProcAddress("glIndexub");
	printf("glIndexub                     : %p\n", p);
	p = gl.OSMesaGetProcAddress("glIndexubv");
	printf("glIndexubv                    : %p\n", p);
	p = gl.OSMesaGetProcAddress("glIndexxOES");
	printf("glIndexxOES                   : %p\n", p);
	p = gl.OSMesaGetProcAddress("glIndexxvOES");
	printf("glIndexxvOES                  : %p\n", p);
	p = gl.OSMesaGetProcAddress("glInitNames");
	printf("glInitNames                   : %p\n", p);
	p = gl.OSMesaGetProcAddress("glInsertComponentEXT");
	printf("glInsertComponentEXT          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glInsertEventMarkerEXT");
	printf("glInsertEventMarkerEXT        : %p\n", p);
	p = gl.OSMesaGetProcAddress("glInstrumentsBufferSGIX");
	printf("glInstrumentsBufferSGIX       : %p\n", p);
	p = gl.OSMesaGetProcAddress("glInterleavedArrays");
	printf("glInterleavedArrays           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glInterpolatePathsNV");
	printf("glInterpolatePathsNV          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glInvalidateBufferData");
	printf("glInvalidateBufferData        : %p\n", p);
	p = gl.OSMesaGetProcAddress("glInvalidateBufferSubData");
	printf("glInvalidateBufferSubData     : %p\n", p);
	p = gl.OSMesaGetProcAddress("glInvalidateFramebuffer");
	printf("glInvalidateFramebuffer       : %p\n", p);
	p = gl.OSMesaGetProcAddress("glInvalidateNamedFramebufferData");
	printf("glInvalidateNamedFramebufferData: %p\n", p);
	p = gl.OSMesaGetProcAddress("glInvalidateNamedFramebufferSubData");
	printf("glInvalidateNamedFramebufferSubData: %p\n", p);
	p = gl.OSMesaGetProcAddress("glInvalidateSubFramebuffer");
	printf("glInvalidateSubFramebuffer    : %p\n", p);
	p = gl.OSMesaGetProcAddress("glInvalidateTexImage");
	printf("glInvalidateTexImage          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glInvalidateTexSubImage");
	printf("glInvalidateTexSubImage       : %p\n", p);
	p = gl.OSMesaGetProcAddress("glIsAsyncMarkerSGIX");
	printf("glIsAsyncMarkerSGIX           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glIsBuffer");
	printf("glIsBuffer                    : %p\n", p);
	p = gl.OSMesaGetProcAddress("glIsBufferARB");
	printf("glIsBufferARB                 : %p\n", p);
	p = gl.OSMesaGetProcAddress("glIsBufferResidentNV");
	printf("glIsBufferResidentNV          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glIsCommandListNV");
	printf("glIsCommandListNV             : %p\n", p);
	p = gl.OSMesaGetProcAddress("glIsEnabled");
	printf("glIsEnabled                   : %p\n", p);
	p = gl.OSMesaGetProcAddress("glIsEnabledIndexedEXT");
	printf("glIsEnabledIndexedEXT         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glIsEnabledi");
	printf("glIsEnabledi                  : %p\n", p);
	p = gl.OSMesaGetProcAddress("glIsFenceAPPLE");
	printf("glIsFenceAPPLE                : %p\n", p);
	p = gl.OSMesaGetProcAddress("glIsFenceNV");
	printf("glIsFenceNV                   : %p\n", p);
	p = gl.OSMesaGetProcAddress("glIsFramebuffer");
	printf("glIsFramebuffer               : %p\n", p);
	p = gl.OSMesaGetProcAddress("glIsFramebufferEXT");
	printf("glIsFramebufferEXT            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glIsImageHandleResidentARB");
	printf("glIsImageHandleResidentARB    : %p\n", p);
	p = gl.OSMesaGetProcAddress("glIsImageHandleResidentNV");
	printf("glIsImageHandleResidentNV     : %p\n", p);
	p = gl.OSMesaGetProcAddress("glIsList");
	printf("glIsList                      : %p\n", p);
	p = gl.OSMesaGetProcAddress("glIsMemoryObjectEXT");
	printf("glIsMemoryObjectEXT           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glIsNameAMD");
	printf("glIsNameAMD                   : %p\n", p);
	p = gl.OSMesaGetProcAddress("glIsNamedBufferResidentNV");
	printf("glIsNamedBufferResidentNV     : %p\n", p);
	p = gl.OSMesaGetProcAddress("glIsNamedStringARB");
	printf("glIsNamedStringARB            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glIsObjectBufferATI");
	printf("glIsObjectBufferATI           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glIsOcclusionQueryNV");
	printf("glIsOcclusionQueryNV          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glIsPathNV");
	printf("glIsPathNV                    : %p\n", p);
	p = gl.OSMesaGetProcAddress("glIsPointInFillPathNV");
	printf("glIsPointInFillPathNV         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glIsPointInStrokePathNV");
	printf("glIsPointInStrokePathNV       : %p\n", p);
	p = gl.OSMesaGetProcAddress("glIsProgram");
	printf("glIsProgram                   : %p\n", p);
	p = gl.OSMesaGetProcAddress("glIsProgramARB");
	printf("glIsProgramARB                : %p\n", p);
	p = gl.OSMesaGetProcAddress("glIsProgramNV");
	printf("glIsProgramNV                 : %p\n", p);
	p = gl.OSMesaGetProcAddress("glIsProgramPipeline");
	printf("glIsProgramPipeline           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glIsQuery");
	printf("glIsQuery                     : %p\n", p);
	p = gl.OSMesaGetProcAddress("glIsQueryARB");
	printf("glIsQueryARB                  : %p\n", p);
	p = gl.OSMesaGetProcAddress("glIsRenderbuffer");
	printf("glIsRenderbuffer              : %p\n", p);
	p = gl.OSMesaGetProcAddress("glIsRenderbufferEXT");
	printf("glIsRenderbufferEXT           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glIsSampler");
	printf("glIsSampler                   : %p\n", p);
	p = gl.OSMesaGetProcAddress("glIsSemaphoreEXT");
	printf("glIsSemaphoreEXT              : %p\n", p);
	p = gl.OSMesaGetProcAddress("glIsShader");
	printf("glIsShader                    : %p\n", p);
	p = gl.OSMesaGetProcAddress("glIsStateNV");
	printf("glIsStateNV                   : %p\n", p);
	p = gl.OSMesaGetProcAddress("glIsSync");
	printf("glIsSync                      : %p\n", p);
	p = gl.OSMesaGetProcAddress("glIsTexture");
	printf("glIsTexture                   : %p\n", p);
	p = gl.OSMesaGetProcAddress("glIsTextureEXT");
	printf("glIsTextureEXT                : %p\n", p);
	p = gl.OSMesaGetProcAddress("glIsTextureHandleResidentARB");
	printf("glIsTextureHandleResidentARB  : %p\n", p);
	p = gl.OSMesaGetProcAddress("glIsTextureHandleResidentNV");
	printf("glIsTextureHandleResidentNV   : %p\n", p);
	p = gl.OSMesaGetProcAddress("glIsTransformFeedback");
	printf("glIsTransformFeedback         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glIsTransformFeedbackNV");
	printf("glIsTransformFeedbackNV       : %p\n", p);
	p = gl.OSMesaGetProcAddress("glIsVariantEnabledEXT");
	printf("glIsVariantEnabledEXT         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glIsVertexArray");
	printf("glIsVertexArray               : %p\n", p);
	p = gl.OSMesaGetProcAddress("glIsVertexArrayAPPLE");
	printf("glIsVertexArrayAPPLE          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glIsVertexAttribEnabledAPPLE");
	printf("glIsVertexAttribEnabledAPPLE  : %p\n", p);
	p = gl.OSMesaGetProcAddress("glLGPUCopyImageSubDataNVX");
	printf("glLGPUCopyImageSubDataNVX     : %p\n", p);
	p = gl.OSMesaGetProcAddress("glLGPUInterlockNVX");
	printf("glLGPUInterlockNVX            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glLGPUNamedBufferSubDataNVX");
	printf("glLGPUNamedBufferSubDataNVX   : %p\n", p);
	p = gl.OSMesaGetProcAddress("glLabelObjectEXT");
	printf("glLabelObjectEXT              : %p\n", p);
	p = gl.OSMesaGetProcAddress("glLightEnviSGIX");
	printf("glLightEnviSGIX               : %p\n", p);
	p = gl.OSMesaGetProcAddress("glLightModelf");
	printf("glLightModelf                 : %p\n", p);
	p = gl.OSMesaGetProcAddress("glLightModelfv");
	printf("glLightModelfv                : %p\n", p);
	p = gl.OSMesaGetProcAddress("glLightModeli");
	printf("glLightModeli                 : %p\n", p);
	p = gl.OSMesaGetProcAddress("glLightModeliv");
	printf("glLightModeliv                : %p\n", p);
	p = gl.OSMesaGetProcAddress("glLightModelxOES");
	printf("glLightModelxOES              : %p\n", p);
	p = gl.OSMesaGetProcAddress("glLightModelxvOES");
	printf("glLightModelxvOES             : %p\n", p);
	p = gl.OSMesaGetProcAddress("glLightf");
	printf("glLightf                      : %p\n", p);
	p = gl.OSMesaGetProcAddress("glLightfv");
	printf("glLightfv                     : %p\n", p);
	p = gl.OSMesaGetProcAddress("glLighti");
	printf("glLighti                      : %p\n", p);
	p = gl.OSMesaGetProcAddress("glLightiv");
	printf("glLightiv                     : %p\n", p);
	p = gl.OSMesaGetProcAddress("glLightxOES");
	printf("glLightxOES                   : %p\n", p);
	p = gl.OSMesaGetProcAddress("glLightxvOES");
	printf("glLightxvOES                  : %p\n", p);
	p = gl.OSMesaGetProcAddress("glLineStipple");
	printf("glLineStipple                 : %p\n", p);
	p = gl.OSMesaGetProcAddress("glLineWidth");
	printf("glLineWidth                   : %p\n", p);
	p = gl.OSMesaGetProcAddress("glLineWidthxOES");
	printf("glLineWidthxOES               : %p\n", p);
	p = gl.OSMesaGetProcAddress("glLinkProgram");
	printf("glLinkProgram                 : %p\n", p);
	p = gl.OSMesaGetProcAddress("glLinkProgramARB");
	printf("glLinkProgramARB              : %p\n", p);
	p = gl.OSMesaGetProcAddress("glListBase");
	printf("glListBase                    : %p\n", p);
	p = gl.OSMesaGetProcAddress("glListDrawCommandsStatesClientNV");
	printf("glListDrawCommandsStatesClientNV: %p\n", p);
	p = gl.OSMesaGetProcAddress("glListParameterfSGIX");
	printf("glListParameterfSGIX          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glListParameterfvSGIX");
	printf("glListParameterfvSGIX         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glListParameteriSGIX");
	printf("glListParameteriSGIX          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glListParameterivSGIX");
	printf("glListParameterivSGIX         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glLoadIdentity");
	printf("glLoadIdentity                : %p\n", p);
	p = gl.OSMesaGetProcAddress("glLoadIdentityDeformationMapSGIX");
	printf("glLoadIdentityDeformationMapSGIX: %p\n", p);
	p = gl.OSMesaGetProcAddress("glLoadMatrixd");
	printf("glLoadMatrixd                 : %p\n", p);
	p = gl.OSMesaGetProcAddress("glLoadMatrixf");
	printf("glLoadMatrixf                 : %p\n", p);
	p = gl.OSMesaGetProcAddress("glLoadMatrixxOES");
	printf("glLoadMatrixxOES              : %p\n", p);
	p = gl.OSMesaGetProcAddress("glLoadName");
	printf("glLoadName                    : %p\n", p);
	p = gl.OSMesaGetProcAddress("glLoadProgramNV");
	printf("glLoadProgramNV               : %p\n", p);
	p = gl.OSMesaGetProcAddress("glLoadTransposeMatrixd");
	printf("glLoadTransposeMatrixd        : %p\n", p);
	p = gl.OSMesaGetProcAddress("glLoadTransposeMatrixdARB");
	printf("glLoadTransposeMatrixdARB     : %p\n", p);
	p = gl.OSMesaGetProcAddress("glLoadTransposeMatrixf");
	printf("glLoadTransposeMatrixf        : %p\n", p);
	p = gl.OSMesaGetProcAddress("glLoadTransposeMatrixfARB");
	printf("glLoadTransposeMatrixfARB     : %p\n", p);
	p = gl.OSMesaGetProcAddress("glLoadTransposeMatrixxOES");
	printf("glLoadTransposeMatrixxOES     : %p\n", p);
	p = gl.OSMesaGetProcAddress("glLockArraysEXT");
	printf("glLockArraysEXT               : %p\n", p);
	p = gl.OSMesaGetProcAddress("glLogicOp");
	printf("glLogicOp                     : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMakeBufferNonResidentNV");
	printf("glMakeBufferNonResidentNV     : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMakeBufferResidentNV");
	printf("glMakeBufferResidentNV        : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMakeImageHandleNonResidentARB");
	printf("glMakeImageHandleNonResidentARB: %p\n", p);
	p = gl.OSMesaGetProcAddress("glMakeImageHandleNonResidentNV");
	printf("glMakeImageHandleNonResidentNV: %p\n", p);
	p = gl.OSMesaGetProcAddress("glMakeImageHandleResidentARB");
	printf("glMakeImageHandleResidentARB  : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMakeImageHandleResidentNV");
	printf("glMakeImageHandleResidentNV   : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMakeNamedBufferNonResidentNV");
	printf("glMakeNamedBufferNonResidentNV: %p\n", p);
	p = gl.OSMesaGetProcAddress("glMakeNamedBufferResidentNV");
	printf("glMakeNamedBufferResidentNV   : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMakeTextureHandleNonResidentARB");
	printf("glMakeTextureHandleNonResidentARB: %p\n", p);
	p = gl.OSMesaGetProcAddress("glMakeTextureHandleNonResidentNV");
	printf("glMakeTextureHandleNonResidentNV: %p\n", p);
	p = gl.OSMesaGetProcAddress("glMakeTextureHandleResidentARB");
	printf("glMakeTextureHandleResidentARB: %p\n", p);
	p = gl.OSMesaGetProcAddress("glMakeTextureHandleResidentNV");
	printf("glMakeTextureHandleResidentNV : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMap1d");
	printf("glMap1d                       : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMap1f");
	printf("glMap1f                       : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMap1xOES");
	printf("glMap1xOES                    : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMap2d");
	printf("glMap2d                       : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMap2f");
	printf("glMap2f                       : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMap2xOES");
	printf("glMap2xOES                    : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMapBuffer");
	printf("glMapBuffer                   : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMapBufferARB");
	printf("glMapBufferARB                : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMapBufferRange");
	printf("glMapBufferRange              : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMapControlPointsNV");
	printf("glMapControlPointsNV          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMapGrid1d");
	printf("glMapGrid1d                   : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMapGrid1f");
	printf("glMapGrid1f                   : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMapGrid1xOES");
	printf("glMapGrid1xOES                : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMapGrid2d");
	printf("glMapGrid2d                   : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMapGrid2f");
	printf("glMapGrid2f                   : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMapGrid2xOES");
	printf("glMapGrid2xOES                : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMapNamedBuffer");
	printf("glMapNamedBuffer              : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMapNamedBufferEXT");
	printf("glMapNamedBufferEXT           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMapNamedBufferRange");
	printf("glMapNamedBufferRange         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMapNamedBufferRangeEXT");
	printf("glMapNamedBufferRangeEXT      : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMapObjectBufferATI");
	printf("glMapObjectBufferATI          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMapParameterfvNV");
	printf("glMapParameterfvNV            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMapParameterivNV");
	printf("glMapParameterivNV            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMapTexture2DINTEL");
	printf("glMapTexture2DINTEL           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMapVertexAttrib1dAPPLE");
	printf("glMapVertexAttrib1dAPPLE      : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMapVertexAttrib1fAPPLE");
	printf("glMapVertexAttrib1fAPPLE      : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMapVertexAttrib2dAPPLE");
	printf("glMapVertexAttrib2dAPPLE      : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMapVertexAttrib2fAPPLE");
	printf("glMapVertexAttrib2fAPPLE      : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMaterialf");
	printf("glMaterialf                   : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMaterialfv");
	printf("glMaterialfv                  : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMateriali");
	printf("glMateriali                   : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMaterialiv");
	printf("glMaterialiv                  : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMaterialxOES");
	printf("glMaterialxOES                : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMaterialxvOES");
	printf("glMaterialxvOES               : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMatrixFrustumEXT");
	printf("glMatrixFrustumEXT            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMatrixIndexPointerARB");
	printf("glMatrixIndexPointerARB       : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMatrixIndexubvARB");
	printf("glMatrixIndexubvARB           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMatrixIndexuivARB");
	printf("glMatrixIndexuivARB           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMatrixIndexusvARB");
	printf("glMatrixIndexusvARB           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMatrixLoad3x2fNV");
	printf("glMatrixLoad3x2fNV            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMatrixLoad3x3fNV");
	printf("glMatrixLoad3x3fNV            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMatrixLoadIdentityEXT");
	printf("glMatrixLoadIdentityEXT       : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMatrixLoadTranspose3x3fNV");
	printf("glMatrixLoadTranspose3x3fNV   : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMatrixLoadTransposedEXT");
	printf("glMatrixLoadTransposedEXT     : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMatrixLoadTransposefEXT");
	printf("glMatrixLoadTransposefEXT     : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMatrixLoaddEXT");
	printf("glMatrixLoaddEXT              : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMatrixLoadfEXT");
	printf("glMatrixLoadfEXT              : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMatrixMode");
	printf("glMatrixMode                  : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMatrixMult3x2fNV");
	printf("glMatrixMult3x2fNV            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMatrixMult3x3fNV");
	printf("glMatrixMult3x3fNV            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMatrixMultTranspose3x3fNV");
	printf("glMatrixMultTranspose3x3fNV   : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMatrixMultTransposedEXT");
	printf("glMatrixMultTransposedEXT     : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMatrixMultTransposefEXT");
	printf("glMatrixMultTransposefEXT     : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMatrixMultdEXT");
	printf("glMatrixMultdEXT              : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMatrixMultfEXT");
	printf("glMatrixMultfEXT              : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMatrixOrthoEXT");
	printf("glMatrixOrthoEXT              : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMatrixPopEXT");
	printf("glMatrixPopEXT                : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMatrixPushEXT");
	printf("glMatrixPushEXT               : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMatrixRotatedEXT");
	printf("glMatrixRotatedEXT            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMatrixRotatefEXT");
	printf("glMatrixRotatefEXT            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMatrixScaledEXT");
	printf("glMatrixScaledEXT             : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMatrixScalefEXT");
	printf("glMatrixScalefEXT             : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMatrixTranslatedEXT");
	printf("glMatrixTranslatedEXT         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMatrixTranslatefEXT");
	printf("glMatrixTranslatefEXT         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMaxShaderCompilerThreadsARB");
	printf("glMaxShaderCompilerThreadsARB : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMaxShaderCompilerThreadsKHR");
	printf("glMaxShaderCompilerThreadsKHR : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMemoryBarrier");
	printf("glMemoryBarrier               : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMemoryBarrierByRegion");
	printf("glMemoryBarrierByRegion       : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMemoryBarrierEXT");
	printf("glMemoryBarrierEXT            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMemoryObjectParameterivEXT");
	printf("glMemoryObjectParameterivEXT  : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMinSampleShading");
	printf("glMinSampleShading            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMinSampleShadingARB");
	printf("glMinSampleShadingARB         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMinmax");
	printf("glMinmax                      : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMinmaxEXT");
	printf("glMinmaxEXT                   : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMultMatrixd");
	printf("glMultMatrixd                 : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMultMatrixf");
	printf("glMultMatrixf                 : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMultMatrixxOES");
	printf("glMultMatrixxOES              : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMultTransposeMatrixd");
	printf("glMultTransposeMatrixd        : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMultTransposeMatrixdARB");
	printf("glMultTransposeMatrixdARB     : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMultTransposeMatrixf");
	printf("glMultTransposeMatrixf        : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMultTransposeMatrixfARB");
	printf("glMultTransposeMatrixfARB     : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMultTransposeMatrixxOES");
	printf("glMultTransposeMatrixxOES     : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMultiDrawArrays");
	printf("glMultiDrawArrays             : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMultiDrawArraysEXT");
	printf("glMultiDrawArraysEXT          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMultiDrawArraysIndirect");
	printf("glMultiDrawArraysIndirect     : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMultiDrawArraysIndirectAMD");
	printf("glMultiDrawArraysIndirectAMD  : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMultiDrawArraysIndirectBindlessCountNV");
	printf("glMultiDrawArraysIndirectBindlessCountNV: %p\n", p);
	p = gl.OSMesaGetProcAddress("glMultiDrawArraysIndirectBindlessNV");
	printf("glMultiDrawArraysIndirectBindlessNV: %p\n", p);
	p = gl.OSMesaGetProcAddress("glMultiDrawArraysIndirectCount");
	printf("glMultiDrawArraysIndirectCount: %p\n", p);
	p = gl.OSMesaGetProcAddress("glMultiDrawArraysIndirectCountARB");
	printf("glMultiDrawArraysIndirectCountARB: %p\n", p);
	p = gl.OSMesaGetProcAddress("glMultiDrawElementArrayAPPLE");
	printf("glMultiDrawElementArrayAPPLE  : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMultiDrawElements");
	printf("glMultiDrawElements           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMultiDrawElementsBaseVertex");
	printf("glMultiDrawElementsBaseVertex : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMultiDrawElementsEXT");
	printf("glMultiDrawElementsEXT        : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMultiDrawElementsIndirect");
	printf("glMultiDrawElementsIndirect   : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMultiDrawElementsIndirectAMD");
	printf("glMultiDrawElementsIndirectAMD: %p\n", p);
	p = gl.OSMesaGetProcAddress("glMultiDrawElementsIndirectBindlessCountNV");
	printf("glMultiDrawElementsIndirectBindlessCountNV: %p\n", p);
	p = gl.OSMesaGetProcAddress("glMultiDrawElementsIndirectBindlessNV");
	printf("glMultiDrawElementsIndirectBindlessNV: %p\n", p);
	p = gl.OSMesaGetProcAddress("glMultiDrawElementsIndirectCount");
	printf("glMultiDrawElementsIndirectCount: %p\n", p);
	p = gl.OSMesaGetProcAddress("glMultiDrawElementsIndirectCountARB");
	printf("glMultiDrawElementsIndirectCountARB: %p\n", p);
	p = gl.OSMesaGetProcAddress("glMultiDrawRangeElementArrayAPPLE");
	printf("glMultiDrawRangeElementArrayAPPLE: %p\n", p);
	p = gl.OSMesaGetProcAddress("glMultiModeDrawArraysIBM");
	printf("glMultiModeDrawArraysIBM      : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMultiModeDrawElementsIBM");
	printf("glMultiModeDrawElementsIBM    : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMultiTexBufferEXT");
	printf("glMultiTexBufferEXT           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMultiTexCoord1bOES");
	printf("glMultiTexCoord1bOES          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMultiTexCoord1bvOES");
	printf("glMultiTexCoord1bvOES         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMultiTexCoord1d");
	printf("glMultiTexCoord1d             : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMultiTexCoord1dARB");
	printf("glMultiTexCoord1dARB          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMultiTexCoord1dv");
	printf("glMultiTexCoord1dv            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMultiTexCoord1dvARB");
	printf("glMultiTexCoord1dvARB         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMultiTexCoord1f");
	printf("glMultiTexCoord1f             : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMultiTexCoord1fARB");
	printf("glMultiTexCoord1fARB          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMultiTexCoord1fv");
	printf("glMultiTexCoord1fv            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMultiTexCoord1fvARB");
	printf("glMultiTexCoord1fvARB         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMultiTexCoord1hNV");
	printf("glMultiTexCoord1hNV           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMultiTexCoord1hvNV");
	printf("glMultiTexCoord1hvNV          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMultiTexCoord1i");
	printf("glMultiTexCoord1i             : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMultiTexCoord1iARB");
	printf("glMultiTexCoord1iARB          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMultiTexCoord1iv");
	printf("glMultiTexCoord1iv            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMultiTexCoord1ivARB");
	printf("glMultiTexCoord1ivARB         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMultiTexCoord1s");
	printf("glMultiTexCoord1s             : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMultiTexCoord1sARB");
	printf("glMultiTexCoord1sARB          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMultiTexCoord1sv");
	printf("glMultiTexCoord1sv            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMultiTexCoord1svARB");
	printf("glMultiTexCoord1svARB         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMultiTexCoord1xOES");
	printf("glMultiTexCoord1xOES          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMultiTexCoord1xvOES");
	printf("glMultiTexCoord1xvOES         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMultiTexCoord2bOES");
	printf("glMultiTexCoord2bOES          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMultiTexCoord2bvOES");
	printf("glMultiTexCoord2bvOES         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMultiTexCoord2d");
	printf("glMultiTexCoord2d             : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMultiTexCoord2dARB");
	printf("glMultiTexCoord2dARB          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMultiTexCoord2dv");
	printf("glMultiTexCoord2dv            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMultiTexCoord2dvARB");
	printf("glMultiTexCoord2dvARB         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMultiTexCoord2f");
	printf("glMultiTexCoord2f             : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMultiTexCoord2fARB");
	printf("glMultiTexCoord2fARB          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMultiTexCoord2fv");
	printf("glMultiTexCoord2fv            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMultiTexCoord2fvARB");
	printf("glMultiTexCoord2fvARB         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMultiTexCoord2hNV");
	printf("glMultiTexCoord2hNV           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMultiTexCoord2hvNV");
	printf("glMultiTexCoord2hvNV          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMultiTexCoord2i");
	printf("glMultiTexCoord2i             : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMultiTexCoord2iARB");
	printf("glMultiTexCoord2iARB          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMultiTexCoord2iv");
	printf("glMultiTexCoord2iv            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMultiTexCoord2ivARB");
	printf("glMultiTexCoord2ivARB         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMultiTexCoord2s");
	printf("glMultiTexCoord2s             : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMultiTexCoord2sARB");
	printf("glMultiTexCoord2sARB          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMultiTexCoord2sv");
	printf("glMultiTexCoord2sv            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMultiTexCoord2svARB");
	printf("glMultiTexCoord2svARB         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMultiTexCoord2xOES");
	printf("glMultiTexCoord2xOES          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMultiTexCoord2xvOES");
	printf("glMultiTexCoord2xvOES         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMultiTexCoord3bOES");
	printf("glMultiTexCoord3bOES          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMultiTexCoord3bvOES");
	printf("glMultiTexCoord3bvOES         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMultiTexCoord3d");
	printf("glMultiTexCoord3d             : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMultiTexCoord3dARB");
	printf("glMultiTexCoord3dARB          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMultiTexCoord3dv");
	printf("glMultiTexCoord3dv            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMultiTexCoord3dvARB");
	printf("glMultiTexCoord3dvARB         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMultiTexCoord3f");
	printf("glMultiTexCoord3f             : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMultiTexCoord3fARB");
	printf("glMultiTexCoord3fARB          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMultiTexCoord3fv");
	printf("glMultiTexCoord3fv            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMultiTexCoord3fvARB");
	printf("glMultiTexCoord3fvARB         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMultiTexCoord3hNV");
	printf("glMultiTexCoord3hNV           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMultiTexCoord3hvNV");
	printf("glMultiTexCoord3hvNV          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMultiTexCoord3i");
	printf("glMultiTexCoord3i             : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMultiTexCoord3iARB");
	printf("glMultiTexCoord3iARB          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMultiTexCoord3iv");
	printf("glMultiTexCoord3iv            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMultiTexCoord3ivARB");
	printf("glMultiTexCoord3ivARB         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMultiTexCoord3s");
	printf("glMultiTexCoord3s             : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMultiTexCoord3sARB");
	printf("glMultiTexCoord3sARB          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMultiTexCoord3sv");
	printf("glMultiTexCoord3sv            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMultiTexCoord3svARB");
	printf("glMultiTexCoord3svARB         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMultiTexCoord3xOES");
	printf("glMultiTexCoord3xOES          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMultiTexCoord3xvOES");
	printf("glMultiTexCoord3xvOES         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMultiTexCoord4bOES");
	printf("glMultiTexCoord4bOES          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMultiTexCoord4bvOES");
	printf("glMultiTexCoord4bvOES         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMultiTexCoord4d");
	printf("glMultiTexCoord4d             : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMultiTexCoord4dARB");
	printf("glMultiTexCoord4dARB          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMultiTexCoord4dv");
	printf("glMultiTexCoord4dv            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMultiTexCoord4dvARB");
	printf("glMultiTexCoord4dvARB         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMultiTexCoord4f");
	printf("glMultiTexCoord4f             : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMultiTexCoord4fARB");
	printf("glMultiTexCoord4fARB          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMultiTexCoord4fv");
	printf("glMultiTexCoord4fv            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMultiTexCoord4fvARB");
	printf("glMultiTexCoord4fvARB         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMultiTexCoord4hNV");
	printf("glMultiTexCoord4hNV           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMultiTexCoord4hvNV");
	printf("glMultiTexCoord4hvNV          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMultiTexCoord4i");
	printf("glMultiTexCoord4i             : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMultiTexCoord4iARB");
	printf("glMultiTexCoord4iARB          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMultiTexCoord4iv");
	printf("glMultiTexCoord4iv            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMultiTexCoord4ivARB");
	printf("glMultiTexCoord4ivARB         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMultiTexCoord4s");
	printf("glMultiTexCoord4s             : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMultiTexCoord4sARB");
	printf("glMultiTexCoord4sARB          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMultiTexCoord4sv");
	printf("glMultiTexCoord4sv            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMultiTexCoord4svARB");
	printf("glMultiTexCoord4svARB         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMultiTexCoord4xOES");
	printf("glMultiTexCoord4xOES          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMultiTexCoord4xvOES");
	printf("glMultiTexCoord4xvOES         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMultiTexCoordP1ui");
	printf("glMultiTexCoordP1ui           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMultiTexCoordP1uiv");
	printf("glMultiTexCoordP1uiv          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMultiTexCoordP2ui");
	printf("glMultiTexCoordP2ui           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMultiTexCoordP2uiv");
	printf("glMultiTexCoordP2uiv          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMultiTexCoordP3ui");
	printf("glMultiTexCoordP3ui           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMultiTexCoordP3uiv");
	printf("glMultiTexCoordP3uiv          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMultiTexCoordP4ui");
	printf("glMultiTexCoordP4ui           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMultiTexCoordP4uiv");
	printf("glMultiTexCoordP4uiv          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMultiTexCoordPointerEXT");
	printf("glMultiTexCoordPointerEXT     : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMultiTexEnvfEXT");
	printf("glMultiTexEnvfEXT             : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMultiTexEnvfvEXT");
	printf("glMultiTexEnvfvEXT            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMultiTexEnviEXT");
	printf("glMultiTexEnviEXT             : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMultiTexEnvivEXT");
	printf("glMultiTexEnvivEXT            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMultiTexGendEXT");
	printf("glMultiTexGendEXT             : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMultiTexGendvEXT");
	printf("glMultiTexGendvEXT            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMultiTexGenfEXT");
	printf("glMultiTexGenfEXT             : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMultiTexGenfvEXT");
	printf("glMultiTexGenfvEXT            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMultiTexGeniEXT");
	printf("glMultiTexGeniEXT             : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMultiTexGenivEXT");
	printf("glMultiTexGenivEXT            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMultiTexImage1DEXT");
	printf("glMultiTexImage1DEXT          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMultiTexImage2DEXT");
	printf("glMultiTexImage2DEXT          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMultiTexImage3DEXT");
	printf("glMultiTexImage3DEXT          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMultiTexParameterIivEXT");
	printf("glMultiTexParameterIivEXT     : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMultiTexParameterIuivEXT");
	printf("glMultiTexParameterIuivEXT    : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMultiTexParameterfEXT");
	printf("glMultiTexParameterfEXT       : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMultiTexParameterfvEXT");
	printf("glMultiTexParameterfvEXT      : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMultiTexParameteriEXT");
	printf("glMultiTexParameteriEXT       : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMultiTexParameterivEXT");
	printf("glMultiTexParameterivEXT      : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMultiTexRenderbufferEXT");
	printf("glMultiTexRenderbufferEXT     : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMultiTexSubImage1DEXT");
	printf("glMultiTexSubImage1DEXT       : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMultiTexSubImage2DEXT");
	printf("glMultiTexSubImage2DEXT       : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMultiTexSubImage3DEXT");
	printf("glMultiTexSubImage3DEXT       : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMulticastBarrierNV");
	printf("glMulticastBarrierNV          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMulticastBlitFramebufferNV");
	printf("glMulticastBlitFramebufferNV  : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMulticastBufferSubDataNV");
	printf("glMulticastBufferSubDataNV    : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMulticastCopyBufferSubDataNV");
	printf("glMulticastCopyBufferSubDataNV: %p\n", p);
	p = gl.OSMesaGetProcAddress("glMulticastCopyImageSubDataNV");
	printf("glMulticastCopyImageSubDataNV : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMulticastFramebufferSampleLocationsfvNV");
	printf("glMulticastFramebufferSampleLocationsfvNV: %p\n", p);
	p = gl.OSMesaGetProcAddress("glMulticastGetQueryObjecti64vNV");
	printf("glMulticastGetQueryObjecti64vNV: %p\n", p);
	p = gl.OSMesaGetProcAddress("glMulticastGetQueryObjectivNV");
	printf("glMulticastGetQueryObjectivNV : %p\n", p);
	p = gl.OSMesaGetProcAddress("glMulticastGetQueryObjectui64vNV");
	printf("glMulticastGetQueryObjectui64vNV: %p\n", p);
	p = gl.OSMesaGetProcAddress("glMulticastGetQueryObjectuivNV");
	printf("glMulticastGetQueryObjectuivNV: %p\n", p);
	p = gl.OSMesaGetProcAddress("glMulticastWaitSyncNV");
	printf("glMulticastWaitSyncNV         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glNamedBufferData");
	printf("glNamedBufferData             : %p\n", p);
	p = gl.OSMesaGetProcAddress("glNamedBufferDataEXT");
	printf("glNamedBufferDataEXT          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glNamedBufferPageCommitmentARB");
	printf("glNamedBufferPageCommitmentARB: %p\n", p);
	p = gl.OSMesaGetProcAddress("glNamedBufferPageCommitmentEXT");
	printf("glNamedBufferPageCommitmentEXT: %p\n", p);
	p = gl.OSMesaGetProcAddress("glNamedBufferStorage");
	printf("glNamedBufferStorage          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glNamedBufferStorageEXT");
	printf("glNamedBufferStorageEXT       : %p\n", p);
	p = gl.OSMesaGetProcAddress("glNamedBufferStorageExternalEXT");
	printf("glNamedBufferStorageExternalEXT: %p\n", p);
	p = gl.OSMesaGetProcAddress("glNamedBufferStorageMemEXT");
	printf("glNamedBufferStorageMemEXT    : %p\n", p);
	p = gl.OSMesaGetProcAddress("glNamedBufferSubData");
	printf("glNamedBufferSubData          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glNamedBufferSubDataEXT");
	printf("glNamedBufferSubDataEXT       : %p\n", p);
	p = gl.OSMesaGetProcAddress("glNamedCopyBufferSubDataEXT");
	printf("glNamedCopyBufferSubDataEXT   : %p\n", p);
	p = gl.OSMesaGetProcAddress("glNamedFramebufferDrawBuffer");
	printf("glNamedFramebufferDrawBuffer  : %p\n", p);
	p = gl.OSMesaGetProcAddress("glNamedFramebufferDrawBuffers");
	printf("glNamedFramebufferDrawBuffers : %p\n", p);
	p = gl.OSMesaGetProcAddress("glNamedFramebufferParameteri");
	printf("glNamedFramebufferParameteri  : %p\n", p);
	p = gl.OSMesaGetProcAddress("glNamedFramebufferParameteriEXT");
	printf("glNamedFramebufferParameteriEXT: %p\n", p);
	p = gl.OSMesaGetProcAddress("glNamedFramebufferReadBuffer");
	printf("glNamedFramebufferReadBuffer  : %p\n", p);
	p = gl.OSMesaGetProcAddress("glNamedFramebufferRenderbuffer");
	printf("glNamedFramebufferRenderbuffer: %p\n", p);
	p = gl.OSMesaGetProcAddress("glNamedFramebufferRenderbufferEXT");
	printf("glNamedFramebufferRenderbufferEXT: %p\n", p);
	p = gl.OSMesaGetProcAddress("glNamedFramebufferSampleLocationsfvARB");
	printf("glNamedFramebufferSampleLocationsfvARB: %p\n", p);
	p = gl.OSMesaGetProcAddress("glNamedFramebufferSampleLocationsfvNV");
	printf("glNamedFramebufferSampleLocationsfvNV: %p\n", p);
	p = gl.OSMesaGetProcAddress("glNamedFramebufferSamplePositionsfvAMD");
	printf("glNamedFramebufferSamplePositionsfvAMD: %p\n", p);
	p = gl.OSMesaGetProcAddress("glNamedFramebufferTexture");
	printf("glNamedFramebufferTexture     : %p\n", p);
	p = gl.OSMesaGetProcAddress("glNamedFramebufferTexture1DEXT");
	printf("glNamedFramebufferTexture1DEXT: %p\n", p);
	p = gl.OSMesaGetProcAddress("glNamedFramebufferTexture2DEXT");
	printf("glNamedFramebufferTexture2DEXT: %p\n", p);
	p = gl.OSMesaGetProcAddress("glNamedFramebufferTexture3DEXT");
	printf("glNamedFramebufferTexture3DEXT: %p\n", p);
	p = gl.OSMesaGetProcAddress("glNamedFramebufferTextureEXT");
	printf("glNamedFramebufferTextureEXT  : %p\n", p);
	p = gl.OSMesaGetProcAddress("glNamedFramebufferTextureFaceEXT");
	printf("glNamedFramebufferTextureFaceEXT: %p\n", p);
	p = gl.OSMesaGetProcAddress("glNamedFramebufferTextureLayer");
	printf("glNamedFramebufferTextureLayer: %p\n", p);
	p = gl.OSMesaGetProcAddress("glNamedFramebufferTextureLayerEXT");
	printf("glNamedFramebufferTextureLayerEXT: %p\n", p);
	p = gl.OSMesaGetProcAddress("glNamedProgramLocalParameter4dEXT");
	printf("glNamedProgramLocalParameter4dEXT: %p\n", p);
	p = gl.OSMesaGetProcAddress("glNamedProgramLocalParameter4dvEXT");
	printf("glNamedProgramLocalParameter4dvEXT: %p\n", p);
	p = gl.OSMesaGetProcAddress("glNamedProgramLocalParameter4fEXT");
	printf("glNamedProgramLocalParameter4fEXT: %p\n", p);
	p = gl.OSMesaGetProcAddress("glNamedProgramLocalParameter4fvEXT");
	printf("glNamedProgramLocalParameter4fvEXT: %p\n", p);
	p = gl.OSMesaGetProcAddress("glNamedProgramLocalParameterI4iEXT");
	printf("glNamedProgramLocalParameterI4iEXT: %p\n", p);
	p = gl.OSMesaGetProcAddress("glNamedProgramLocalParameterI4ivEXT");
	printf("glNamedProgramLocalParameterI4ivEXT: %p\n", p);
	p = gl.OSMesaGetProcAddress("glNamedProgramLocalParameterI4uiEXT");
	printf("glNamedProgramLocalParameterI4uiEXT: %p\n", p);
	p = gl.OSMesaGetProcAddress("glNamedProgramLocalParameterI4uivEXT");
	printf("glNamedProgramLocalParameterI4uivEXT: %p\n", p);
	p = gl.OSMesaGetProcAddress("glNamedProgramLocalParameters4fvEXT");
	printf("glNamedProgramLocalParameters4fvEXT: %p\n", p);
	p = gl.OSMesaGetProcAddress("glNamedProgramLocalParametersI4ivEXT");
	printf("glNamedProgramLocalParametersI4ivEXT: %p\n", p);
	p = gl.OSMesaGetProcAddress("glNamedProgramLocalParametersI4uivEXT");
	printf("glNamedProgramLocalParametersI4uivEXT: %p\n", p);
	p = gl.OSMesaGetProcAddress("glNamedProgramStringEXT");
	printf("glNamedProgramStringEXT       : %p\n", p);
	p = gl.OSMesaGetProcAddress("glNamedRenderbufferStorage");
	printf("glNamedRenderbufferStorage    : %p\n", p);
	p = gl.OSMesaGetProcAddress("glNamedRenderbufferStorageEXT");
	printf("glNamedRenderbufferStorageEXT : %p\n", p);
	p = gl.OSMesaGetProcAddress("glNamedRenderbufferStorageMultisample");
	printf("glNamedRenderbufferStorageMultisample: %p\n", p);
	p = gl.OSMesaGetProcAddress("glNamedRenderbufferStorageMultisampleCoverageEXT");
	printf("glNamedRenderbufferStorageMultisampleCoverageEXT: %p\n", p);
	p = gl.OSMesaGetProcAddress("glNamedRenderbufferStorageMultisampleEXT");
	printf("glNamedRenderbufferStorageMultisampleEXT: %p\n", p);
	p = gl.OSMesaGetProcAddress("glNamedStringARB");
	printf("glNamedStringARB              : %p\n", p);
	p = gl.OSMesaGetProcAddress("glNewList");
	printf("glNewList                     : %p\n", p);
	p = gl.OSMesaGetProcAddress("glNewObjectBufferATI");
	printf("glNewObjectBufferATI          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glNewTraceMESA");
	printf("glNewTraceMESA                : %p\n", p);
	p = gl.OSMesaGetProcAddress("glNormal3b");
	printf("glNormal3b                    : %p\n", p);
	p = gl.OSMesaGetProcAddress("glNormal3bv");
	printf("glNormal3bv                   : %p\n", p);
	p = gl.OSMesaGetProcAddress("glNormal3d");
	printf("glNormal3d                    : %p\n", p);
	p = gl.OSMesaGetProcAddress("glNormal3dv");
	printf("glNormal3dv                   : %p\n", p);
	p = gl.OSMesaGetProcAddress("glNormal3f");
	printf("glNormal3f                    : %p\n", p);
	p = gl.OSMesaGetProcAddress("glNormal3fVertex3fSUN");
	printf("glNormal3fVertex3fSUN         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glNormal3fVertex3fvSUN");
	printf("glNormal3fVertex3fvSUN        : %p\n", p);
	p = gl.OSMesaGetProcAddress("glNormal3fv");
	printf("glNormal3fv                   : %p\n", p);
	p = gl.OSMesaGetProcAddress("glNormal3hNV");
	printf("glNormal3hNV                  : %p\n", p);
	p = gl.OSMesaGetProcAddress("glNormal3hvNV");
	printf("glNormal3hvNV                 : %p\n", p);
	p = gl.OSMesaGetProcAddress("glNormal3i");
	printf("glNormal3i                    : %p\n", p);
	p = gl.OSMesaGetProcAddress("glNormal3iv");
	printf("glNormal3iv                   : %p\n", p);
	p = gl.OSMesaGetProcAddress("glNormal3s");
	printf("glNormal3s                    : %p\n", p);
	p = gl.OSMesaGetProcAddress("glNormal3sv");
	printf("glNormal3sv                   : %p\n", p);
	p = gl.OSMesaGetProcAddress("glNormal3xOES");
	printf("glNormal3xOES                 : %p\n", p);
	p = gl.OSMesaGetProcAddress("glNormal3xvOES");
	printf("glNormal3xvOES                : %p\n", p);
	p = gl.OSMesaGetProcAddress("glNormalFormatNV");
	printf("glNormalFormatNV              : %p\n", p);
	p = gl.OSMesaGetProcAddress("glNormalP3ui");
	printf("glNormalP3ui                  : %p\n", p);
	p = gl.OSMesaGetProcAddress("glNormalP3uiv");
	printf("glNormalP3uiv                 : %p\n", p);
	p = gl.OSMesaGetProcAddress("glNormalPointer");
	printf("glNormalPointer               : %p\n", p);
	p = gl.OSMesaGetProcAddress("glNormalPointerEXT");
	printf("glNormalPointerEXT            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glNormalPointerListIBM");
	printf("glNormalPointerListIBM        : %p\n", p);
	p = gl.OSMesaGetProcAddress("glNormalPointervINTEL");
	printf("glNormalPointervINTEL         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glNormalStream3bATI");
	printf("glNormalStream3bATI           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glNormalStream3bvATI");
	printf("glNormalStream3bvATI          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glNormalStream3dATI");
	printf("glNormalStream3dATI           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glNormalStream3dvATI");
	printf("glNormalStream3dvATI          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glNormalStream3fATI");
	printf("glNormalStream3fATI           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glNormalStream3fvATI");
	printf("glNormalStream3fvATI          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glNormalStream3iATI");
	printf("glNormalStream3iATI           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glNormalStream3ivATI");
	printf("glNormalStream3ivATI          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glNormalStream3sATI");
	printf("glNormalStream3sATI           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glNormalStream3svATI");
	printf("glNormalStream3svATI          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glObjectLabel");
	printf("glObjectLabel                 : %p\n", p);
	p = gl.OSMesaGetProcAddress("glObjectPtrLabel");
	printf("glObjectPtrLabel              : %p\n", p);
	p = gl.OSMesaGetProcAddress("glObjectPurgeableAPPLE");
	printf("glObjectPurgeableAPPLE        : %p\n", p);
	p = gl.OSMesaGetProcAddress("glObjectUnpurgeableAPPLE");
	printf("glObjectUnpurgeableAPPLE      : %p\n", p);
	p = gl.OSMesaGetProcAddress("glOrtho");
	printf("glOrtho                       : %p\n", p);
	p = gl.OSMesaGetProcAddress("glOrthof");
	printf("glOrthof                      : %p\n", p);
	p = gl.OSMesaGetProcAddress("glOrthofOES");
	printf("glOrthofOES                   : %p\n", p);
	p = gl.OSMesaGetProcAddress("glOrthoxOES");
	printf("glOrthoxOES                   : %p\n", p);
	p = gl.OSMesaGetProcAddress("glPNTrianglesfATI");
	printf("glPNTrianglesfATI             : %p\n", p);
	p = gl.OSMesaGetProcAddress("glPNTrianglesiATI");
	printf("glPNTrianglesiATI             : %p\n", p);
	p = gl.OSMesaGetProcAddress("glPassTexCoordATI");
	printf("glPassTexCoordATI             : %p\n", p);
	p = gl.OSMesaGetProcAddress("glPassThrough");
	printf("glPassThrough                 : %p\n", p);
	p = gl.OSMesaGetProcAddress("glPassThroughxOES");
	printf("glPassThroughxOES             : %p\n", p);
	p = gl.OSMesaGetProcAddress("glPatchParameterfv");
	printf("glPatchParameterfv            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glPatchParameteri");
	printf("glPatchParameteri             : %p\n", p);
	p = gl.OSMesaGetProcAddress("glPathColorGenNV");
	printf("glPathColorGenNV              : %p\n", p);
	p = gl.OSMesaGetProcAddress("glPathCommandsNV");
	printf("glPathCommandsNV              : %p\n", p);
	p = gl.OSMesaGetProcAddress("glPathCoordsNV");
	printf("glPathCoordsNV                : %p\n", p);
	p = gl.OSMesaGetProcAddress("glPathCoverDepthFuncNV");
	printf("glPathCoverDepthFuncNV        : %p\n", p);
	p = gl.OSMesaGetProcAddress("glPathDashArrayNV");
	printf("glPathDashArrayNV             : %p\n", p);
	p = gl.OSMesaGetProcAddress("glPathFogGenNV");
	printf("glPathFogGenNV                : %p\n", p);
	p = gl.OSMesaGetProcAddress("glPathGlyphIndexArrayNV");
	printf("glPathGlyphIndexArrayNV       : %p\n", p);
	p = gl.OSMesaGetProcAddress("glPathGlyphIndexRangeNV");
	printf("glPathGlyphIndexRangeNV       : %p\n", p);
	p = gl.OSMesaGetProcAddress("glPathGlyphRangeNV");
	printf("glPathGlyphRangeNV            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glPathGlyphsNV");
	printf("glPathGlyphsNV                : %p\n", p);
	p = gl.OSMesaGetProcAddress("glPathMemoryGlyphIndexArrayNV");
	printf("glPathMemoryGlyphIndexArrayNV : %p\n", p);
	p = gl.OSMesaGetProcAddress("glPathParameterfNV");
	printf("glPathParameterfNV            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glPathParameterfvNV");
	printf("glPathParameterfvNV           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glPathParameteriNV");
	printf("glPathParameteriNV            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glPathParameterivNV");
	printf("glPathParameterivNV           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glPathStencilDepthOffsetNV");
	printf("glPathStencilDepthOffsetNV    : %p\n", p);
	p = gl.OSMesaGetProcAddress("glPathStencilFuncNV");
	printf("glPathStencilFuncNV           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glPathStringNV");
	printf("glPathStringNV                : %p\n", p);
	p = gl.OSMesaGetProcAddress("glPathSubCommandsNV");
	printf("glPathSubCommandsNV           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glPathSubCoordsNV");
	printf("glPathSubCoordsNV             : %p\n", p);
	p = gl.OSMesaGetProcAddress("glPathTexGenNV");
	printf("glPathTexGenNV                : %p\n", p);
	p = gl.OSMesaGetProcAddress("glPauseTransformFeedback");
	printf("glPauseTransformFeedback      : %p\n", p);
	p = gl.OSMesaGetProcAddress("glPauseTransformFeedbackNV");
	printf("glPauseTransformFeedbackNV    : %p\n", p);
	p = gl.OSMesaGetProcAddress("glPixelDataRangeNV");
	printf("glPixelDataRangeNV            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glPixelMapfv");
	printf("glPixelMapfv                  : %p\n", p);
	p = gl.OSMesaGetProcAddress("glPixelMapuiv");
	printf("glPixelMapuiv                 : %p\n", p);
	p = gl.OSMesaGetProcAddress("glPixelMapusv");
	printf("glPixelMapusv                 : %p\n", p);
	p = gl.OSMesaGetProcAddress("glPixelMapx");
	printf("glPixelMapx                   : %p\n", p);
	p = gl.OSMesaGetProcAddress("glPixelStoref");
	printf("glPixelStoref                 : %p\n", p);
	p = gl.OSMesaGetProcAddress("glPixelStorei");
	printf("glPixelStorei                 : %p\n", p);
	p = gl.OSMesaGetProcAddress("glPixelStorex");
	printf("glPixelStorex                 : %p\n", p);
	p = gl.OSMesaGetProcAddress("glPixelTexGenParameterfSGIS");
	printf("glPixelTexGenParameterfSGIS   : %p\n", p);
	p = gl.OSMesaGetProcAddress("glPixelTexGenParameterfvSGIS");
	printf("glPixelTexGenParameterfvSGIS  : %p\n", p);
	p = gl.OSMesaGetProcAddress("glPixelTexGenParameteriSGIS");
	printf("glPixelTexGenParameteriSGIS   : %p\n", p);
	p = gl.OSMesaGetProcAddress("glPixelTexGenParameterivSGIS");
	printf("glPixelTexGenParameterivSGIS  : %p\n", p);
	p = gl.OSMesaGetProcAddress("glPixelTexGenSGIX");
	printf("glPixelTexGenSGIX             : %p\n", p);
	p = gl.OSMesaGetProcAddress("glPixelTransferf");
	printf("glPixelTransferf              : %p\n", p);
	p = gl.OSMesaGetProcAddress("glPixelTransferi");
	printf("glPixelTransferi              : %p\n", p);
	p = gl.OSMesaGetProcAddress("glPixelTransferxOES");
	printf("glPixelTransferxOES           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glPixelTransformParameterfEXT");
	printf("glPixelTransformParameterfEXT : %p\n", p);
	p = gl.OSMesaGetProcAddress("glPixelTransformParameterfvEXT");
	printf("glPixelTransformParameterfvEXT: %p\n", p);
	p = gl.OSMesaGetProcAddress("glPixelTransformParameteriEXT");
	printf("glPixelTransformParameteriEXT : %p\n", p);
	p = gl.OSMesaGetProcAddress("glPixelTransformParameterivEXT");
	printf("glPixelTransformParameterivEXT: %p\n", p);
	p = gl.OSMesaGetProcAddress("glPixelZoom");
	printf("glPixelZoom                   : %p\n", p);
	p = gl.OSMesaGetProcAddress("glPixelZoomxOES");
	printf("glPixelZoomxOES               : %p\n", p);
	p = gl.OSMesaGetProcAddress("glPointAlongPathNV");
	printf("glPointAlongPathNV            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glPointParameterf");
	printf("glPointParameterf             : %p\n", p);
	p = gl.OSMesaGetProcAddress("glPointParameterfARB");
	printf("glPointParameterfARB          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glPointParameterfEXT");
	printf("glPointParameterfEXT          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glPointParameterfSGIS");
	printf("glPointParameterfSGIS         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glPointParameterfv");
	printf("glPointParameterfv            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glPointParameterfvARB");
	printf("glPointParameterfvARB         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glPointParameterfvEXT");
	printf("glPointParameterfvEXT         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glPointParameterfvSGIS");
	printf("glPointParameterfvSGIS        : %p\n", p);
	p = gl.OSMesaGetProcAddress("glPointParameteri");
	printf("glPointParameteri             : %p\n", p);
	p = gl.OSMesaGetProcAddress("glPointParameteriNV");
	printf("glPointParameteriNV           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glPointParameteriv");
	printf("glPointParameteriv            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glPointParameterivNV");
	printf("glPointParameterivNV          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glPointParameterxvOES");
	printf("glPointParameterxvOES         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glPointSize");
	printf("glPointSize                   : %p\n", p);
	p = gl.OSMesaGetProcAddress("glPointSizePointerAPPLE");
	printf("glPointSizePointerAPPLE       : %p\n", p);
	p = gl.OSMesaGetProcAddress("glPointSizexOES");
	printf("glPointSizexOES               : %p\n", p);
	p = gl.OSMesaGetProcAddress("glPollAsyncSGIX");
	printf("glPollAsyncSGIX               : %p\n", p);
	p = gl.OSMesaGetProcAddress("glPollInstrumentsSGIX");
	printf("glPollInstrumentsSGIX         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glPolygonMode");
	printf("glPolygonMode                 : %p\n", p);
	p = gl.OSMesaGetProcAddress("glPolygonOffset");
	printf("glPolygonOffset               : %p\n", p);
	p = gl.OSMesaGetProcAddress("glPolygonOffsetClamp");
	printf("glPolygonOffsetClamp          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glPolygonOffsetClampEXT");
	printf("glPolygonOffsetClampEXT       : %p\n", p);
	p = gl.OSMesaGetProcAddress("glPolygonOffsetEXT");
	printf("glPolygonOffsetEXT            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glPolygonOffsetxOES");
	printf("glPolygonOffsetxOES           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glPolygonStipple");
	printf("glPolygonStipple              : %p\n", p);
	p = gl.OSMesaGetProcAddress("glPopAttrib");
	printf("glPopAttrib                   : %p\n", p);
	p = gl.OSMesaGetProcAddress("glPopClientAttrib");
	printf("glPopClientAttrib             : %p\n", p);
	p = gl.OSMesaGetProcAddress("glPopDebugGroup");
	printf("glPopDebugGroup               : %p\n", p);
	p = gl.OSMesaGetProcAddress("glPopGroupMarkerEXT");
	printf("glPopGroupMarkerEXT           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glPopMatrix");
	printf("glPopMatrix                   : %p\n", p);
	p = gl.OSMesaGetProcAddress("glPopName");
	printf("glPopName                     : %p\n", p);
	p = gl.OSMesaGetProcAddress("glPresentFrameDualFillNV");
	printf("glPresentFrameDualFillNV      : %p\n", p);
	p = gl.OSMesaGetProcAddress("glPresentFrameKeyedNV");
	printf("glPresentFrameKeyedNV         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glPrimitiveBoundingBoxARB");
	printf("glPrimitiveBoundingBoxARB     : %p\n", p);
	p = gl.OSMesaGetProcAddress("glPrimitiveRestartIndex");
	printf("glPrimitiveRestartIndex       : %p\n", p);
	p = gl.OSMesaGetProcAddress("glPrimitiveRestartIndexNV");
	printf("glPrimitiveRestartIndexNV     : %p\n", p);
	p = gl.OSMesaGetProcAddress("glPrimitiveRestartNV");
	printf("glPrimitiveRestartNV          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glPrioritizeTextures");
	printf("glPrioritizeTextures          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glPrioritizeTexturesEXT");
	printf("glPrioritizeTexturesEXT       : %p\n", p);
	p = gl.OSMesaGetProcAddress("glPrioritizeTexturesxOES");
	printf("glPrioritizeTexturesxOES      : %p\n", p);
	p = gl.OSMesaGetProcAddress("glProgramBinary");
	printf("glProgramBinary               : %p\n", p);
	p = gl.OSMesaGetProcAddress("glProgramBufferParametersIivNV");
	printf("glProgramBufferParametersIivNV: %p\n", p);
	p = gl.OSMesaGetProcAddress("glProgramBufferParametersIuivNV");
	printf("glProgramBufferParametersIuivNV: %p\n", p);
	p = gl.OSMesaGetProcAddress("glProgramBufferParametersfvNV");
	printf("glProgramBufferParametersfvNV : %p\n", p);
	p = gl.OSMesaGetProcAddress("glProgramCallbackMESA");
	printf("glProgramCallbackMESA         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glProgramEnvParameter4dARB");
	printf("glProgramEnvParameter4dARB    : %p\n", p);
	p = gl.OSMesaGetProcAddress("glProgramEnvParameter4dvARB");
	printf("glProgramEnvParameter4dvARB   : %p\n", p);
	p = gl.OSMesaGetProcAddress("glProgramEnvParameter4fARB");
	printf("glProgramEnvParameter4fARB    : %p\n", p);
	p = gl.OSMesaGetProcAddress("glProgramEnvParameter4fvARB");
	printf("glProgramEnvParameter4fvARB   : %p\n", p);
	p = gl.OSMesaGetProcAddress("glProgramEnvParameterI4iNV");
	printf("glProgramEnvParameterI4iNV    : %p\n", p);
	p = gl.OSMesaGetProcAddress("glProgramEnvParameterI4ivNV");
	printf("glProgramEnvParameterI4ivNV   : %p\n", p);
	p = gl.OSMesaGetProcAddress("glProgramEnvParameterI4uiNV");
	printf("glProgramEnvParameterI4uiNV   : %p\n", p);
	p = gl.OSMesaGetProcAddress("glProgramEnvParameterI4uivNV");
	printf("glProgramEnvParameterI4uivNV  : %p\n", p);
	p = gl.OSMesaGetProcAddress("glProgramEnvParameters4fvEXT");
	printf("glProgramEnvParameters4fvEXT  : %p\n", p);
	p = gl.OSMesaGetProcAddress("glProgramEnvParametersI4ivNV");
	printf("glProgramEnvParametersI4ivNV  : %p\n", p);
	p = gl.OSMesaGetProcAddress("glProgramEnvParametersI4uivNV");
	printf("glProgramEnvParametersI4uivNV : %p\n", p);
	p = gl.OSMesaGetProcAddress("glProgramLocalParameter4dARB");
	printf("glProgramLocalParameter4dARB  : %p\n", p);
	p = gl.OSMesaGetProcAddress("glProgramLocalParameter4dvARB");
	printf("glProgramLocalParameter4dvARB : %p\n", p);
	p = gl.OSMesaGetProcAddress("glProgramLocalParameter4fARB");
	printf("glProgramLocalParameter4fARB  : %p\n", p);
	p = gl.OSMesaGetProcAddress("glProgramLocalParameter4fvARB");
	printf("glProgramLocalParameter4fvARB : %p\n", p);
	p = gl.OSMesaGetProcAddress("glProgramLocalParameterI4iNV");
	printf("glProgramLocalParameterI4iNV  : %p\n", p);
	p = gl.OSMesaGetProcAddress("glProgramLocalParameterI4ivNV");
	printf("glProgramLocalParameterI4ivNV : %p\n", p);
	p = gl.OSMesaGetProcAddress("glProgramLocalParameterI4uiNV");
	printf("glProgramLocalParameterI4uiNV : %p\n", p);
	p = gl.OSMesaGetProcAddress("glProgramLocalParameterI4uivNV");
	printf("glProgramLocalParameterI4uivNV: %p\n", p);
	p = gl.OSMesaGetProcAddress("glProgramLocalParameters4fvEXT");
	printf("glProgramLocalParameters4fvEXT: %p\n", p);
	p = gl.OSMesaGetProcAddress("glProgramLocalParametersI4ivNV");
	printf("glProgramLocalParametersI4ivNV: %p\n", p);
	p = gl.OSMesaGetProcAddress("glProgramLocalParametersI4uivNV");
	printf("glProgramLocalParametersI4uivNV: %p\n", p);
	p = gl.OSMesaGetProcAddress("glProgramNamedParameter4dNV");
	printf("glProgramNamedParameter4dNV   : %p\n", p);
	p = gl.OSMesaGetProcAddress("glProgramNamedParameter4dvNV");
	printf("glProgramNamedParameter4dvNV  : %p\n", p);
	p = gl.OSMesaGetProcAddress("glProgramNamedParameter4fNV");
	printf("glProgramNamedParameter4fNV   : %p\n", p);
	p = gl.OSMesaGetProcAddress("glProgramNamedParameter4fvNV");
	printf("glProgramNamedParameter4fvNV  : %p\n", p);
	p = gl.OSMesaGetProcAddress("glProgramParameter4dNV");
	printf("glProgramParameter4dNV        : %p\n", p);
	p = gl.OSMesaGetProcAddress("glProgramParameter4dvNV");
	printf("glProgramParameter4dvNV       : %p\n", p);
	p = gl.OSMesaGetProcAddress("glProgramParameter4fNV");
	printf("glProgramParameter4fNV        : %p\n", p);
	p = gl.OSMesaGetProcAddress("glProgramParameter4fvNV");
	printf("glProgramParameter4fvNV       : %p\n", p);
	p = gl.OSMesaGetProcAddress("glProgramParameteri");
	printf("glProgramParameteri           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glProgramParameteriARB");
	printf("glProgramParameteriARB        : %p\n", p);
	p = gl.OSMesaGetProcAddress("glProgramParameteriEXT");
	printf("glProgramParameteriEXT        : %p\n", p);
	p = gl.OSMesaGetProcAddress("glProgramParameters4dvNV");
	printf("glProgramParameters4dvNV      : %p\n", p);
	p = gl.OSMesaGetProcAddress("glProgramParameters4fvNV");
	printf("glProgramParameters4fvNV      : %p\n", p);
	p = gl.OSMesaGetProcAddress("glProgramPathFragmentInputGenNV");
	printf("glProgramPathFragmentInputGenNV: %p\n", p);
	p = gl.OSMesaGetProcAddress("glProgramStringARB");
	printf("glProgramStringARB            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glProgramSubroutineParametersuivNV");
	printf("glProgramSubroutineParametersuivNV: %p\n", p);
	p = gl.OSMesaGetProcAddress("glProgramUniform1d");
	printf("glProgramUniform1d            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glProgramUniform1dEXT");
	printf("glProgramUniform1dEXT         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glProgramUniform1dv");
	printf("glProgramUniform1dv           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glProgramUniform1dvEXT");
	printf("glProgramUniform1dvEXT        : %p\n", p);
	p = gl.OSMesaGetProcAddress("glProgramUniform1f");
	printf("glProgramUniform1f            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glProgramUniform1fEXT");
	printf("glProgramUniform1fEXT         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glProgramUniform1fv");
	printf("glProgramUniform1fv           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glProgramUniform1fvEXT");
	printf("glProgramUniform1fvEXT        : %p\n", p);
	p = gl.OSMesaGetProcAddress("glProgramUniform1i");
	printf("glProgramUniform1i            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glProgramUniform1i64ARB");
	printf("glProgramUniform1i64ARB       : %p\n", p);
	p = gl.OSMesaGetProcAddress("glProgramUniform1i64NV");
	printf("glProgramUniform1i64NV        : %p\n", p);
	p = gl.OSMesaGetProcAddress("glProgramUniform1i64vARB");
	printf("glProgramUniform1i64vARB      : %p\n", p);
	p = gl.OSMesaGetProcAddress("glProgramUniform1i64vNV");
	printf("glProgramUniform1i64vNV       : %p\n", p);
	p = gl.OSMesaGetProcAddress("glProgramUniform1iEXT");
	printf("glProgramUniform1iEXT         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glProgramUniform1iv");
	printf("glProgramUniform1iv           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glProgramUniform1ivEXT");
	printf("glProgramUniform1ivEXT        : %p\n", p);
	p = gl.OSMesaGetProcAddress("glProgramUniform1ui");
	printf("glProgramUniform1ui           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glProgramUniform1ui64ARB");
	printf("glProgramUniform1ui64ARB      : %p\n", p);
	p = gl.OSMesaGetProcAddress("glProgramUniform1ui64NV");
	printf("glProgramUniform1ui64NV       : %p\n", p);
	p = gl.OSMesaGetProcAddress("glProgramUniform1ui64vARB");
	printf("glProgramUniform1ui64vARB     : %p\n", p);
	p = gl.OSMesaGetProcAddress("glProgramUniform1ui64vNV");
	printf("glProgramUniform1ui64vNV      : %p\n", p);
	p = gl.OSMesaGetProcAddress("glProgramUniform1uiEXT");
	printf("glProgramUniform1uiEXT        : %p\n", p);
	p = gl.OSMesaGetProcAddress("glProgramUniform1uiv");
	printf("glProgramUniform1uiv          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glProgramUniform1uivEXT");
	printf("glProgramUniform1uivEXT       : %p\n", p);
	p = gl.OSMesaGetProcAddress("glProgramUniform2d");
	printf("glProgramUniform2d            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glProgramUniform2dEXT");
	printf("glProgramUniform2dEXT         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glProgramUniform2dv");
	printf("glProgramUniform2dv           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glProgramUniform2dvEXT");
	printf("glProgramUniform2dvEXT        : %p\n", p);
	p = gl.OSMesaGetProcAddress("glProgramUniform2f");
	printf("glProgramUniform2f            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glProgramUniform2fEXT");
	printf("glProgramUniform2fEXT         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glProgramUniform2fv");
	printf("glProgramUniform2fv           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glProgramUniform2fvEXT");
	printf("glProgramUniform2fvEXT        : %p\n", p);
	p = gl.OSMesaGetProcAddress("glProgramUniform2i");
	printf("glProgramUniform2i            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glProgramUniform2i64ARB");
	printf("glProgramUniform2i64ARB       : %p\n", p);
	p = gl.OSMesaGetProcAddress("glProgramUniform2i64NV");
	printf("glProgramUniform2i64NV        : %p\n", p);
	p = gl.OSMesaGetProcAddress("glProgramUniform2i64vARB");
	printf("glProgramUniform2i64vARB      : %p\n", p);
	p = gl.OSMesaGetProcAddress("glProgramUniform2i64vNV");
	printf("glProgramUniform2i64vNV       : %p\n", p);
	p = gl.OSMesaGetProcAddress("glProgramUniform2iEXT");
	printf("glProgramUniform2iEXT         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glProgramUniform2iv");
	printf("glProgramUniform2iv           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glProgramUniform2ivEXT");
	printf("glProgramUniform2ivEXT        : %p\n", p);
	p = gl.OSMesaGetProcAddress("glProgramUniform2ui");
	printf("glProgramUniform2ui           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glProgramUniform2ui64ARB");
	printf("glProgramUniform2ui64ARB      : %p\n", p);
	p = gl.OSMesaGetProcAddress("glProgramUniform2ui64NV");
	printf("glProgramUniform2ui64NV       : %p\n", p);
	p = gl.OSMesaGetProcAddress("glProgramUniform2ui64vARB");
	printf("glProgramUniform2ui64vARB     : %p\n", p);
	p = gl.OSMesaGetProcAddress("glProgramUniform2ui64vNV");
	printf("glProgramUniform2ui64vNV      : %p\n", p);
	p = gl.OSMesaGetProcAddress("glProgramUniform2uiEXT");
	printf("glProgramUniform2uiEXT        : %p\n", p);
	p = gl.OSMesaGetProcAddress("glProgramUniform2uiv");
	printf("glProgramUniform2uiv          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glProgramUniform2uivEXT");
	printf("glProgramUniform2uivEXT       : %p\n", p);
	p = gl.OSMesaGetProcAddress("glProgramUniform3d");
	printf("glProgramUniform3d            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glProgramUniform3dEXT");
	printf("glProgramUniform3dEXT         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glProgramUniform3dv");
	printf("glProgramUniform3dv           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glProgramUniform3dvEXT");
	printf("glProgramUniform3dvEXT        : %p\n", p);
	p = gl.OSMesaGetProcAddress("glProgramUniform3f");
	printf("glProgramUniform3f            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glProgramUniform3fEXT");
	printf("glProgramUniform3fEXT         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glProgramUniform3fv");
	printf("glProgramUniform3fv           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glProgramUniform3fvEXT");
	printf("glProgramUniform3fvEXT        : %p\n", p);
	p = gl.OSMesaGetProcAddress("glProgramUniform3i");
	printf("glProgramUniform3i            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glProgramUniform3i64ARB");
	printf("glProgramUniform3i64ARB       : %p\n", p);
	p = gl.OSMesaGetProcAddress("glProgramUniform3i64NV");
	printf("glProgramUniform3i64NV        : %p\n", p);
	p = gl.OSMesaGetProcAddress("glProgramUniform3i64vARB");
	printf("glProgramUniform3i64vARB      : %p\n", p);
	p = gl.OSMesaGetProcAddress("glProgramUniform3i64vNV");
	printf("glProgramUniform3i64vNV       : %p\n", p);
	p = gl.OSMesaGetProcAddress("glProgramUniform3iEXT");
	printf("glProgramUniform3iEXT         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glProgramUniform3iv");
	printf("glProgramUniform3iv           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glProgramUniform3ivEXT");
	printf("glProgramUniform3ivEXT        : %p\n", p);
	p = gl.OSMesaGetProcAddress("glProgramUniform3ui");
	printf("glProgramUniform3ui           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glProgramUniform3ui64ARB");
	printf("glProgramUniform3ui64ARB      : %p\n", p);
	p = gl.OSMesaGetProcAddress("glProgramUniform3ui64NV");
	printf("glProgramUniform3ui64NV       : %p\n", p);
	p = gl.OSMesaGetProcAddress("glProgramUniform3ui64vARB");
	printf("glProgramUniform3ui64vARB     : %p\n", p);
	p = gl.OSMesaGetProcAddress("glProgramUniform3ui64vNV");
	printf("glProgramUniform3ui64vNV      : %p\n", p);
	p = gl.OSMesaGetProcAddress("glProgramUniform3uiEXT");
	printf("glProgramUniform3uiEXT        : %p\n", p);
	p = gl.OSMesaGetProcAddress("glProgramUniform3uiv");
	printf("glProgramUniform3uiv          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glProgramUniform3uivEXT");
	printf("glProgramUniform3uivEXT       : %p\n", p);
	p = gl.OSMesaGetProcAddress("glProgramUniform4d");
	printf("glProgramUniform4d            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glProgramUniform4dEXT");
	printf("glProgramUniform4dEXT         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glProgramUniform4dv");
	printf("glProgramUniform4dv           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glProgramUniform4dvEXT");
	printf("glProgramUniform4dvEXT        : %p\n", p);
	p = gl.OSMesaGetProcAddress("glProgramUniform4f");
	printf("glProgramUniform4f            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glProgramUniform4fEXT");
	printf("glProgramUniform4fEXT         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glProgramUniform4fv");
	printf("glProgramUniform4fv           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glProgramUniform4fvEXT");
	printf("glProgramUniform4fvEXT        : %p\n", p);
	p = gl.OSMesaGetProcAddress("glProgramUniform4i");
	printf("glProgramUniform4i            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glProgramUniform4i64ARB");
	printf("glProgramUniform4i64ARB       : %p\n", p);
	p = gl.OSMesaGetProcAddress("glProgramUniform4i64NV");
	printf("glProgramUniform4i64NV        : %p\n", p);
	p = gl.OSMesaGetProcAddress("glProgramUniform4i64vARB");
	printf("glProgramUniform4i64vARB      : %p\n", p);
	p = gl.OSMesaGetProcAddress("glProgramUniform4i64vNV");
	printf("glProgramUniform4i64vNV       : %p\n", p);
	p = gl.OSMesaGetProcAddress("glProgramUniform4iEXT");
	printf("glProgramUniform4iEXT         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glProgramUniform4iv");
	printf("glProgramUniform4iv           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glProgramUniform4ivEXT");
	printf("glProgramUniform4ivEXT        : %p\n", p);
	p = gl.OSMesaGetProcAddress("glProgramUniform4ui");
	printf("glProgramUniform4ui           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glProgramUniform4ui64ARB");
	printf("glProgramUniform4ui64ARB      : %p\n", p);
	p = gl.OSMesaGetProcAddress("glProgramUniform4ui64NV");
	printf("glProgramUniform4ui64NV       : %p\n", p);
	p = gl.OSMesaGetProcAddress("glProgramUniform4ui64vARB");
	printf("glProgramUniform4ui64vARB     : %p\n", p);
	p = gl.OSMesaGetProcAddress("glProgramUniform4ui64vNV");
	printf("glProgramUniform4ui64vNV      : %p\n", p);
	p = gl.OSMesaGetProcAddress("glProgramUniform4uiEXT");
	printf("glProgramUniform4uiEXT        : %p\n", p);
	p = gl.OSMesaGetProcAddress("glProgramUniform4uiv");
	printf("glProgramUniform4uiv          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glProgramUniform4uivEXT");
	printf("glProgramUniform4uivEXT       : %p\n", p);
	p = gl.OSMesaGetProcAddress("glProgramUniformHandleui64ARB");
	printf("glProgramUniformHandleui64ARB : %p\n", p);
	p = gl.OSMesaGetProcAddress("glProgramUniformHandleui64NV");
	printf("glProgramUniformHandleui64NV  : %p\n", p);
	p = gl.OSMesaGetProcAddress("glProgramUniformHandleui64vARB");
	printf("glProgramUniformHandleui64vARB: %p\n", p);
	p = gl.OSMesaGetProcAddress("glProgramUniformHandleui64vNV");
	printf("glProgramUniformHandleui64vNV : %p\n", p);
	p = gl.OSMesaGetProcAddress("glProgramUniformMatrix2dv");
	printf("glProgramUniformMatrix2dv     : %p\n", p);
	p = gl.OSMesaGetProcAddress("glProgramUniformMatrix2dvEXT");
	printf("glProgramUniformMatrix2dvEXT  : %p\n", p);
	p = gl.OSMesaGetProcAddress("glProgramUniformMatrix2fv");
	printf("glProgramUniformMatrix2fv     : %p\n", p);
	p = gl.OSMesaGetProcAddress("glProgramUniformMatrix2fvEXT");
	printf("glProgramUniformMatrix2fvEXT  : %p\n", p);
	p = gl.OSMesaGetProcAddress("glProgramUniformMatrix2x3dv");
	printf("glProgramUniformMatrix2x3dv   : %p\n", p);
	p = gl.OSMesaGetProcAddress("glProgramUniformMatrix2x3dvEXT");
	printf("glProgramUniformMatrix2x3dvEXT: %p\n", p);
	p = gl.OSMesaGetProcAddress("glProgramUniformMatrix2x3fv");
	printf("glProgramUniformMatrix2x3fv   : %p\n", p);
	p = gl.OSMesaGetProcAddress("glProgramUniformMatrix2x3fvEXT");
	printf("glProgramUniformMatrix2x3fvEXT: %p\n", p);
	p = gl.OSMesaGetProcAddress("glProgramUniformMatrix2x4dv");
	printf("glProgramUniformMatrix2x4dv   : %p\n", p);
	p = gl.OSMesaGetProcAddress("glProgramUniformMatrix2x4dvEXT");
	printf("glProgramUniformMatrix2x4dvEXT: %p\n", p);
	p = gl.OSMesaGetProcAddress("glProgramUniformMatrix2x4fv");
	printf("glProgramUniformMatrix2x4fv   : %p\n", p);
	p = gl.OSMesaGetProcAddress("glProgramUniformMatrix2x4fvEXT");
	printf("glProgramUniformMatrix2x4fvEXT: %p\n", p);
	p = gl.OSMesaGetProcAddress("glProgramUniformMatrix3dv");
	printf("glProgramUniformMatrix3dv     : %p\n", p);
	p = gl.OSMesaGetProcAddress("glProgramUniformMatrix3dvEXT");
	printf("glProgramUniformMatrix3dvEXT  : %p\n", p);
	p = gl.OSMesaGetProcAddress("glProgramUniformMatrix3fv");
	printf("glProgramUniformMatrix3fv     : %p\n", p);
	p = gl.OSMesaGetProcAddress("glProgramUniformMatrix3fvEXT");
	printf("glProgramUniformMatrix3fvEXT  : %p\n", p);
	p = gl.OSMesaGetProcAddress("glProgramUniformMatrix3x2dv");
	printf("glProgramUniformMatrix3x2dv   : %p\n", p);
	p = gl.OSMesaGetProcAddress("glProgramUniformMatrix3x2dvEXT");
	printf("glProgramUniformMatrix3x2dvEXT: %p\n", p);
	p = gl.OSMesaGetProcAddress("glProgramUniformMatrix3x2fv");
	printf("glProgramUniformMatrix3x2fv   : %p\n", p);
	p = gl.OSMesaGetProcAddress("glProgramUniformMatrix3x2fvEXT");
	printf("glProgramUniformMatrix3x2fvEXT: %p\n", p);
	p = gl.OSMesaGetProcAddress("glProgramUniformMatrix3x4dv");
	printf("glProgramUniformMatrix3x4dv   : %p\n", p);
	p = gl.OSMesaGetProcAddress("glProgramUniformMatrix3x4dvEXT");
	printf("glProgramUniformMatrix3x4dvEXT: %p\n", p);
	p = gl.OSMesaGetProcAddress("glProgramUniformMatrix3x4fv");
	printf("glProgramUniformMatrix3x4fv   : %p\n", p);
	p = gl.OSMesaGetProcAddress("glProgramUniformMatrix3x4fvEXT");
	printf("glProgramUniformMatrix3x4fvEXT: %p\n", p);
	p = gl.OSMesaGetProcAddress("glProgramUniformMatrix4dv");
	printf("glProgramUniformMatrix4dv     : %p\n", p);
	p = gl.OSMesaGetProcAddress("glProgramUniformMatrix4dvEXT");
	printf("glProgramUniformMatrix4dvEXT  : %p\n", p);
	p = gl.OSMesaGetProcAddress("glProgramUniformMatrix4fv");
	printf("glProgramUniformMatrix4fv     : %p\n", p);
	p = gl.OSMesaGetProcAddress("glProgramUniformMatrix4fvEXT");
	printf("glProgramUniformMatrix4fvEXT  : %p\n", p);
	p = gl.OSMesaGetProcAddress("glProgramUniformMatrix4x2dv");
	printf("glProgramUniformMatrix4x2dv   : %p\n", p);
	p = gl.OSMesaGetProcAddress("glProgramUniformMatrix4x2dvEXT");
	printf("glProgramUniformMatrix4x2dvEXT: %p\n", p);
	p = gl.OSMesaGetProcAddress("glProgramUniformMatrix4x2fv");
	printf("glProgramUniformMatrix4x2fv   : %p\n", p);
	p = gl.OSMesaGetProcAddress("glProgramUniformMatrix4x2fvEXT");
	printf("glProgramUniformMatrix4x2fvEXT: %p\n", p);
	p = gl.OSMesaGetProcAddress("glProgramUniformMatrix4x3dv");
	printf("glProgramUniformMatrix4x3dv   : %p\n", p);
	p = gl.OSMesaGetProcAddress("glProgramUniformMatrix4x3dvEXT");
	printf("glProgramUniformMatrix4x3dvEXT: %p\n", p);
	p = gl.OSMesaGetProcAddress("glProgramUniformMatrix4x3fv");
	printf("glProgramUniformMatrix4x3fv   : %p\n", p);
	p = gl.OSMesaGetProcAddress("glProgramUniformMatrix4x3fvEXT");
	printf("glProgramUniformMatrix4x3fvEXT: %p\n", p);
	p = gl.OSMesaGetProcAddress("glProgramUniformui64NV");
	printf("glProgramUniformui64NV        : %p\n", p);
	p = gl.OSMesaGetProcAddress("glProgramUniformui64vNV");
	printf("glProgramUniformui64vNV       : %p\n", p);
	p = gl.OSMesaGetProcAddress("glProgramVertexLimitNV");
	printf("glProgramVertexLimitNV        : %p\n", p);
	p = gl.OSMesaGetProcAddress("glProvokingVertex");
	printf("glProvokingVertex             : %p\n", p);
	p = gl.OSMesaGetProcAddress("glProvokingVertexEXT");
	printf("glProvokingVertexEXT          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glPushAttrib");
	printf("glPushAttrib                  : %p\n", p);
	p = gl.OSMesaGetProcAddress("glPushClientAttrib");
	printf("glPushClientAttrib            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glPushClientAttribDefaultEXT");
	printf("glPushClientAttribDefaultEXT  : %p\n", p);
	p = gl.OSMesaGetProcAddress("glPushDebugGroup");
	printf("glPushDebugGroup              : %p\n", p);
	p = gl.OSMesaGetProcAddress("glPushGroupMarkerEXT");
	printf("glPushGroupMarkerEXT          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glPushMatrix");
	printf("glPushMatrix                  : %p\n", p);
	p = gl.OSMesaGetProcAddress("glPushName");
	printf("glPushName                    : %p\n", p);
	p = gl.OSMesaGetProcAddress("glQueryCounter");
	printf("glQueryCounter                : %p\n", p);
	p = gl.OSMesaGetProcAddress("glQueryMatrixxOES");
	printf("glQueryMatrixxOES             : %p\n", p);
	p = gl.OSMesaGetProcAddress("glQueryObjectParameteruiAMD");
	printf("glQueryObjectParameteruiAMD   : %p\n", p);
	p = gl.OSMesaGetProcAddress("glQueryResourceNV");
	printf("glQueryResourceNV             : %p\n", p);
	p = gl.OSMesaGetProcAddress("glQueryResourceTagNV");
	printf("glQueryResourceTagNV          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glRasterPos2d");
	printf("glRasterPos2d                 : %p\n", p);
	p = gl.OSMesaGetProcAddress("glRasterPos2dv");
	printf("glRasterPos2dv                : %p\n", p);
	p = gl.OSMesaGetProcAddress("glRasterPos2f");
	printf("glRasterPos2f                 : %p\n", p);
	p = gl.OSMesaGetProcAddress("glRasterPos2fv");
	printf("glRasterPos2fv                : %p\n", p);
	p = gl.OSMesaGetProcAddress("glRasterPos2i");
	printf("glRasterPos2i                 : %p\n", p);
	p = gl.OSMesaGetProcAddress("glRasterPos2iv");
	printf("glRasterPos2iv                : %p\n", p);
	p = gl.OSMesaGetProcAddress("glRasterPos2s");
	printf("glRasterPos2s                 : %p\n", p);
	p = gl.OSMesaGetProcAddress("glRasterPos2sv");
	printf("glRasterPos2sv                : %p\n", p);
	p = gl.OSMesaGetProcAddress("glRasterPos2xOES");
	printf("glRasterPos2xOES              : %p\n", p);
	p = gl.OSMesaGetProcAddress("glRasterPos2xvOES");
	printf("glRasterPos2xvOES             : %p\n", p);
	p = gl.OSMesaGetProcAddress("glRasterPos3d");
	printf("glRasterPos3d                 : %p\n", p);
	p = gl.OSMesaGetProcAddress("glRasterPos3dv");
	printf("glRasterPos3dv                : %p\n", p);
	p = gl.OSMesaGetProcAddress("glRasterPos3f");
	printf("glRasterPos3f                 : %p\n", p);
	p = gl.OSMesaGetProcAddress("glRasterPos3fv");
	printf("glRasterPos3fv                : %p\n", p);
	p = gl.OSMesaGetProcAddress("glRasterPos3i");
	printf("glRasterPos3i                 : %p\n", p);
	p = gl.OSMesaGetProcAddress("glRasterPos3iv");
	printf("glRasterPos3iv                : %p\n", p);
	p = gl.OSMesaGetProcAddress("glRasterPos3s");
	printf("glRasterPos3s                 : %p\n", p);
	p = gl.OSMesaGetProcAddress("glRasterPos3sv");
	printf("glRasterPos3sv                : %p\n", p);
	p = gl.OSMesaGetProcAddress("glRasterPos3xOES");
	printf("glRasterPos3xOES              : %p\n", p);
	p = gl.OSMesaGetProcAddress("glRasterPos3xvOES");
	printf("glRasterPos3xvOES             : %p\n", p);
	p = gl.OSMesaGetProcAddress("glRasterPos4d");
	printf("glRasterPos4d                 : %p\n", p);
	p = gl.OSMesaGetProcAddress("glRasterPos4dv");
	printf("glRasterPos4dv                : %p\n", p);
	p = gl.OSMesaGetProcAddress("glRasterPos4f");
	printf("glRasterPos4f                 : %p\n", p);
	p = gl.OSMesaGetProcAddress("glRasterPos4fv");
	printf("glRasterPos4fv                : %p\n", p);
	p = gl.OSMesaGetProcAddress("glRasterPos4i");
	printf("glRasterPos4i                 : %p\n", p);
	p = gl.OSMesaGetProcAddress("glRasterPos4iv");
	printf("glRasterPos4iv                : %p\n", p);
	p = gl.OSMesaGetProcAddress("glRasterPos4s");
	printf("glRasterPos4s                 : %p\n", p);
	p = gl.OSMesaGetProcAddress("glRasterPos4sv");
	printf("glRasterPos4sv                : %p\n", p);
	p = gl.OSMesaGetProcAddress("glRasterPos4xOES");
	printf("glRasterPos4xOES              : %p\n", p);
	p = gl.OSMesaGetProcAddress("glRasterPos4xvOES");
	printf("glRasterPos4xvOES             : %p\n", p);
	p = gl.OSMesaGetProcAddress("glRasterSamplesEXT");
	printf("glRasterSamplesEXT            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glReadBuffer");
	printf("glReadBuffer                  : %p\n", p);
	p = gl.OSMesaGetProcAddress("glReadInstrumentsSGIX");
	printf("glReadInstrumentsSGIX         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glReadPixels");
	printf("glReadPixels                  : %p\n", p);
	p = gl.OSMesaGetProcAddress("glReadnPixels");
	printf("glReadnPixels                 : %p\n", p);
	p = gl.OSMesaGetProcAddress("glReadnPixelsARB");
	printf("glReadnPixelsARB              : %p\n", p);
	p = gl.OSMesaGetProcAddress("glRectd");
	printf("glRectd                       : %p\n", p);
	p = gl.OSMesaGetProcAddress("glRectdv");
	printf("glRectdv                      : %p\n", p);
	p = gl.OSMesaGetProcAddress("glRectf");
	printf("glRectf                       : %p\n", p);
	p = gl.OSMesaGetProcAddress("glRectfv");
	printf("glRectfv                      : %p\n", p);
	p = gl.OSMesaGetProcAddress("glRecti");
	printf("glRecti                       : %p\n", p);
	p = gl.OSMesaGetProcAddress("glRectiv");
	printf("glRectiv                      : %p\n", p);
	p = gl.OSMesaGetProcAddress("glRects");
	printf("glRects                       : %p\n", p);
	p = gl.OSMesaGetProcAddress("glRectsv");
	printf("glRectsv                      : %p\n", p);
	p = gl.OSMesaGetProcAddress("glRectxOES");
	printf("glRectxOES                    : %p\n", p);
	p = gl.OSMesaGetProcAddress("glRectxvOES");
	printf("glRectxvOES                   : %p\n", p);
	p = gl.OSMesaGetProcAddress("glReferencePlaneSGIX");
	printf("glReferencePlaneSGIX          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glReleaseKeyedMutexWin32EXT");
	printf("glReleaseKeyedMutexWin32EXT   : %p\n", p);
	p = gl.OSMesaGetProcAddress("glReleaseShaderCompiler");
	printf("glReleaseShaderCompiler       : %p\n", p);
	p = gl.OSMesaGetProcAddress("glRenderGpuMaskNV");
	printf("glRenderGpuMaskNV             : %p\n", p);
	p = gl.OSMesaGetProcAddress("glRenderMode");
	printf("glRenderMode                  : %p\n", p);
	p = gl.OSMesaGetProcAddress("glRenderbufferStorage");
	printf("glRenderbufferStorage         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glRenderbufferStorageEXT");
	printf("glRenderbufferStorageEXT      : %p\n", p);
	p = gl.OSMesaGetProcAddress("glRenderbufferStorageMultisample");
	printf("glRenderbufferStorageMultisample: %p\n", p);
	p = gl.OSMesaGetProcAddress("glRenderbufferStorageMultisampleCoverageNV");
	printf("glRenderbufferStorageMultisampleCoverageNV: %p\n", p);
	p = gl.OSMesaGetProcAddress("glRenderbufferStorageMultisampleEXT");
	printf("glRenderbufferStorageMultisampleEXT: %p\n", p);
	p = gl.OSMesaGetProcAddress("glReplacementCodePointerSUN");
	printf("glReplacementCodePointerSUN   : %p\n", p);
	p = gl.OSMesaGetProcAddress("glReplacementCodeubSUN");
	printf("glReplacementCodeubSUN        : %p\n", p);
	p = gl.OSMesaGetProcAddress("glReplacementCodeubvSUN");
	printf("glReplacementCodeubvSUN       : %p\n", p);
	p = gl.OSMesaGetProcAddress("glReplacementCodeuiColor3fVertex3fSUN");
	printf("glReplacementCodeuiColor3fVertex3fSUN: %p\n", p);
	p = gl.OSMesaGetProcAddress("glReplacementCodeuiColor3fVertex3fvSUN");
	printf("glReplacementCodeuiColor3fVertex3fvSUN: %p\n", p);
	p = gl.OSMesaGetProcAddress("glReplacementCodeuiColor4fNormal3fVertex3fSUN");
	printf("glReplacementCodeuiColor4fNormal3fVertex3fSUN: %p\n", p);
	p = gl.OSMesaGetProcAddress("glReplacementCodeuiColor4fNormal3fVertex3fvSUN");
	printf("glReplacementCodeuiColor4fNormal3fVertex3fvSUN: %p\n", p);
	p = gl.OSMesaGetProcAddress("glReplacementCodeuiColor4ubVertex3fSUN");
	printf("glReplacementCodeuiColor4ubVertex3fSUN: %p\n", p);
	p = gl.OSMesaGetProcAddress("glReplacementCodeuiColor4ubVertex3fvSUN");
	printf("glReplacementCodeuiColor4ubVertex3fvSUN: %p\n", p);
	p = gl.OSMesaGetProcAddress("glReplacementCodeuiNormal3fVertex3fSUN");
	printf("glReplacementCodeuiNormal3fVertex3fSUN: %p\n", p);
	p = gl.OSMesaGetProcAddress("glReplacementCodeuiNormal3fVertex3fvSUN");
	printf("glReplacementCodeuiNormal3fVertex3fvSUN: %p\n", p);
	p = gl.OSMesaGetProcAddress("glReplacementCodeuiSUN");
	printf("glReplacementCodeuiSUN        : %p\n", p);
	p = gl.OSMesaGetProcAddress("glReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fSUN");
	printf("glReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fSUN: %p\n", p);
	p = gl.OSMesaGetProcAddress("glReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fvSUN");
	printf("glReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fvSUN: %p\n", p);
	p = gl.OSMesaGetProcAddress("glReplacementCodeuiTexCoord2fNormal3fVertex3fSUN");
	printf("glReplacementCodeuiTexCoord2fNormal3fVertex3fSUN: %p\n", p);
	p = gl.OSMesaGetProcAddress("glReplacementCodeuiTexCoord2fNormal3fVertex3fvSUN");
	printf("glReplacementCodeuiTexCoord2fNormal3fVertex3fvSUN: %p\n", p);
	p = gl.OSMesaGetProcAddress("glReplacementCodeuiTexCoord2fVertex3fSUN");
	printf("glReplacementCodeuiTexCoord2fVertex3fSUN: %p\n", p);
	p = gl.OSMesaGetProcAddress("glReplacementCodeuiTexCoord2fVertex3fvSUN");
	printf("glReplacementCodeuiTexCoord2fVertex3fvSUN: %p\n", p);
	p = gl.OSMesaGetProcAddress("glReplacementCodeuiVertex3fSUN");
	printf("glReplacementCodeuiVertex3fSUN: %p\n", p);
	p = gl.OSMesaGetProcAddress("glReplacementCodeuiVertex3fvSUN");
	printf("glReplacementCodeuiVertex3fvSUN: %p\n", p);
	p = gl.OSMesaGetProcAddress("glReplacementCodeuivSUN");
	printf("glReplacementCodeuivSUN       : %p\n", p);
	p = gl.OSMesaGetProcAddress("glReplacementCodeusSUN");
	printf("glReplacementCodeusSUN        : %p\n", p);
	p = gl.OSMesaGetProcAddress("glReplacementCodeusvSUN");
	printf("glReplacementCodeusvSUN       : %p\n", p);
	p = gl.OSMesaGetProcAddress("glRequestResidentProgramsNV");
	printf("glRequestResidentProgramsNV   : %p\n", p);
	p = gl.OSMesaGetProcAddress("glResetHistogram");
	printf("glResetHistogram              : %p\n", p);
	p = gl.OSMesaGetProcAddress("glResetHistogramEXT");
	printf("glResetHistogramEXT           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glResetMinmax");
	printf("glResetMinmax                 : %p\n", p);
	p = gl.OSMesaGetProcAddress("glResetMinmaxEXT");
	printf("glResetMinmaxEXT              : %p\n", p);
	p = gl.OSMesaGetProcAddress("glResizeBuffersMESA");
	printf("glResizeBuffersMESA           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glResolveDepthValuesNV");
	printf("glResolveDepthValuesNV        : %p\n", p);
	p = gl.OSMesaGetProcAddress("glResumeTransformFeedback");
	printf("glResumeTransformFeedback     : %p\n", p);
	p = gl.OSMesaGetProcAddress("glResumeTransformFeedbackNV");
	printf("glResumeTransformFeedbackNV   : %p\n", p);
	p = gl.OSMesaGetProcAddress("glRotated");
	printf("glRotated                     : %p\n", p);
	p = gl.OSMesaGetProcAddress("glRotatef");
	printf("glRotatef                     : %p\n", p);
	p = gl.OSMesaGetProcAddress("glRotatexOES");
	printf("glRotatexOES                  : %p\n", p);
	p = gl.OSMesaGetProcAddress("glSampleCoverage");
	printf("glSampleCoverage              : %p\n", p);
	p = gl.OSMesaGetProcAddress("glSampleCoverageARB");
	printf("glSampleCoverageARB           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glSampleCoverageOES");
	printf("glSampleCoverageOES           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glSampleMapATI");
	printf("glSampleMapATI                : %p\n", p);
	p = gl.OSMesaGetProcAddress("glSampleMaskEXT");
	printf("glSampleMaskEXT               : %p\n", p);
	p = gl.OSMesaGetProcAddress("glSampleMaskIndexedNV");
	printf("glSampleMaskIndexedNV         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glSampleMaskSGIS");
	printf("glSampleMaskSGIS              : %p\n", p);
	p = gl.OSMesaGetProcAddress("glSampleMaski");
	printf("glSampleMaski                 : %p\n", p);
	p = gl.OSMesaGetProcAddress("glSamplePass");
	printf("glSamplePass                  : %p\n", p);
	p = gl.OSMesaGetProcAddress("glSamplePassARB");
	printf("glSamplePassARB               : %p\n", p);
	p = gl.OSMesaGetProcAddress("glSamplePatternEXT");
	printf("glSamplePatternEXT            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glSamplePatternSGIS");
	printf("glSamplePatternSGIS           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glSamplerParameterIiv");
	printf("glSamplerParameterIiv         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glSamplerParameterIuiv");
	printf("glSamplerParameterIuiv        : %p\n", p);
	p = gl.OSMesaGetProcAddress("glSamplerParameterf");
	printf("glSamplerParameterf           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glSamplerParameterfv");
	printf("glSamplerParameterfv          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glSamplerParameteri");
	printf("glSamplerParameteri           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glSamplerParameteriv");
	printf("glSamplerParameteriv          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glScaled");
	printf("glScaled                      : %p\n", p);
	p = gl.OSMesaGetProcAddress("glScalef");
	printf("glScalef                      : %p\n", p);
	p = gl.OSMesaGetProcAddress("glScalexOES");
	printf("glScalexOES                   : %p\n", p);
	p = gl.OSMesaGetProcAddress("glScissor");
	printf("glScissor                     : %p\n", p);
	p = gl.OSMesaGetProcAddress("glScissorArrayv");
	printf("glScissorArrayv               : %p\n", p);
	p = gl.OSMesaGetProcAddress("glScissorIndexed");
	printf("glScissorIndexed              : %p\n", p);
	p = gl.OSMesaGetProcAddress("glScissorIndexedv");
	printf("glScissorIndexedv             : %p\n", p);
	p = gl.OSMesaGetProcAddress("glSecondaryColor3b");
	printf("glSecondaryColor3b            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glSecondaryColor3bEXT");
	printf("glSecondaryColor3bEXT         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glSecondaryColor3bv");
	printf("glSecondaryColor3bv           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glSecondaryColor3bvEXT");
	printf("glSecondaryColor3bvEXT        : %p\n", p);
	p = gl.OSMesaGetProcAddress("glSecondaryColor3d");
	printf("glSecondaryColor3d            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glSecondaryColor3dEXT");
	printf("glSecondaryColor3dEXT         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glSecondaryColor3dv");
	printf("glSecondaryColor3dv           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glSecondaryColor3dvEXT");
	printf("glSecondaryColor3dvEXT        : %p\n", p);
	p = gl.OSMesaGetProcAddress("glSecondaryColor3f");
	printf("glSecondaryColor3f            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glSecondaryColor3fEXT");
	printf("glSecondaryColor3fEXT         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glSecondaryColor3fv");
	printf("glSecondaryColor3fv           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glSecondaryColor3fvEXT");
	printf("glSecondaryColor3fvEXT        : %p\n", p);
	p = gl.OSMesaGetProcAddress("glSecondaryColor3hNV");
	printf("glSecondaryColor3hNV          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glSecondaryColor3hvNV");
	printf("glSecondaryColor3hvNV         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glSecondaryColor3i");
	printf("glSecondaryColor3i            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glSecondaryColor3iEXT");
	printf("glSecondaryColor3iEXT         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glSecondaryColor3iv");
	printf("glSecondaryColor3iv           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glSecondaryColor3ivEXT");
	printf("glSecondaryColor3ivEXT        : %p\n", p);
	p = gl.OSMesaGetProcAddress("glSecondaryColor3s");
	printf("glSecondaryColor3s            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glSecondaryColor3sEXT");
	printf("glSecondaryColor3sEXT         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glSecondaryColor3sv");
	printf("glSecondaryColor3sv           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glSecondaryColor3svEXT");
	printf("glSecondaryColor3svEXT        : %p\n", p);
	p = gl.OSMesaGetProcAddress("glSecondaryColor3ub");
	printf("glSecondaryColor3ub           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glSecondaryColor3ubEXT");
	printf("glSecondaryColor3ubEXT        : %p\n", p);
	p = gl.OSMesaGetProcAddress("glSecondaryColor3ubv");
	printf("glSecondaryColor3ubv          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glSecondaryColor3ubvEXT");
	printf("glSecondaryColor3ubvEXT       : %p\n", p);
	p = gl.OSMesaGetProcAddress("glSecondaryColor3ui");
	printf("glSecondaryColor3ui           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glSecondaryColor3uiEXT");
	printf("glSecondaryColor3uiEXT        : %p\n", p);
	p = gl.OSMesaGetProcAddress("glSecondaryColor3uiv");
	printf("glSecondaryColor3uiv          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glSecondaryColor3uivEXT");
	printf("glSecondaryColor3uivEXT       : %p\n", p);
	p = gl.OSMesaGetProcAddress("glSecondaryColor3us");
	printf("glSecondaryColor3us           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glSecondaryColor3usEXT");
	printf("glSecondaryColor3usEXT        : %p\n", p);
	p = gl.OSMesaGetProcAddress("glSecondaryColor3usv");
	printf("glSecondaryColor3usv          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glSecondaryColor3usvEXT");
	printf("glSecondaryColor3usvEXT       : %p\n", p);
	p = gl.OSMesaGetProcAddress("glSecondaryColorFormatNV");
	printf("glSecondaryColorFormatNV      : %p\n", p);
	p = gl.OSMesaGetProcAddress("glSecondaryColorP3ui");
	printf("glSecondaryColorP3ui          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glSecondaryColorP3uiv");
	printf("glSecondaryColorP3uiv         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glSecondaryColorPointer");
	printf("glSecondaryColorPointer       : %p\n", p);
	p = gl.OSMesaGetProcAddress("glSecondaryColorPointerEXT");
	printf("glSecondaryColorPointerEXT    : %p\n", p);
	p = gl.OSMesaGetProcAddress("glSecondaryColorPointerListIBM");
	printf("glSecondaryColorPointerListIBM: %p\n", p);
	p = gl.OSMesaGetProcAddress("glSelectBuffer");
	printf("glSelectBuffer                : %p\n", p);
	p = gl.OSMesaGetProcAddress("glSelectPerfMonitorCountersAMD");
	printf("glSelectPerfMonitorCountersAMD: %p\n", p);
	p = gl.OSMesaGetProcAddress("glSemaphoreParameterui64vEXT");
	printf("glSemaphoreParameterui64vEXT  : %p\n", p);
	p = gl.OSMesaGetProcAddress("glSeparableFilter2D");
	printf("glSeparableFilter2D           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glSeparableFilter2DEXT");
	printf("glSeparableFilter2DEXT        : %p\n", p);
	p = gl.OSMesaGetProcAddress("glSetFenceAPPLE");
	printf("glSetFenceAPPLE               : %p\n", p);
	p = gl.OSMesaGetProcAddress("glSetFenceNV");
	printf("glSetFenceNV                  : %p\n", p);
	p = gl.OSMesaGetProcAddress("glSetFragmentShaderConstantATI");
	printf("glSetFragmentShaderConstantATI: %p\n", p);
	p = gl.OSMesaGetProcAddress("glSetInvariantEXT");
	printf("glSetInvariantEXT             : %p\n", p);
	p = gl.OSMesaGetProcAddress("glSetLocalConstantEXT");
	printf("glSetLocalConstantEXT         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glSetMultisamplefvAMD");
	printf("glSetMultisamplefvAMD         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glShadeModel");
	printf("glShadeModel                  : %p\n", p);
	p = gl.OSMesaGetProcAddress("glShaderBinary");
	printf("glShaderBinary                : %p\n", p);
	p = gl.OSMesaGetProcAddress("glShaderOp1EXT");
	printf("glShaderOp1EXT                : %p\n", p);
	p = gl.OSMesaGetProcAddress("glShaderOp2EXT");
	printf("glShaderOp2EXT                : %p\n", p);
	p = gl.OSMesaGetProcAddress("glShaderOp3EXT");
	printf("glShaderOp3EXT                : %p\n", p);
	p = gl.OSMesaGetProcAddress("glShaderSource");
	printf("glShaderSource                : %p\n", p);
	p = gl.OSMesaGetProcAddress("glShaderSourceARB");
	printf("glShaderSourceARB             : %p\n", p);
	p = gl.OSMesaGetProcAddress("glShaderStorageBlockBinding");
	printf("glShaderStorageBlockBinding   : %p\n", p);
	p = gl.OSMesaGetProcAddress("glSharpenTexFuncSGIS");
	printf("glSharpenTexFuncSGIS          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glSignalSemaphoreEXT");
	printf("glSignalSemaphoreEXT          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glSignalVkFenceNV");
	printf("glSignalVkFenceNV             : %p\n", p);
	p = gl.OSMesaGetProcAddress("glSignalVkSemaphoreNV");
	printf("glSignalVkSemaphoreNV         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glSpecializeShader");
	printf("glSpecializeShader            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glSpecializeShaderARB");
	printf("glSpecializeShaderARB         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glSpriteParameterfSGIX");
	printf("glSpriteParameterfSGIX        : %p\n", p);
	p = gl.OSMesaGetProcAddress("glSpriteParameterfvSGIX");
	printf("glSpriteParameterfvSGIX       : %p\n", p);
	p = gl.OSMesaGetProcAddress("glSpriteParameteriSGIX");
	printf("glSpriteParameteriSGIX        : %p\n", p);
	p = gl.OSMesaGetProcAddress("glSpriteParameterivSGIX");
	printf("glSpriteParameterivSGIX       : %p\n", p);
	p = gl.OSMesaGetProcAddress("glStartInstrumentsSGIX");
	printf("glStartInstrumentsSGIX        : %p\n", p);
	p = gl.OSMesaGetProcAddress("glStateCaptureNV");
	printf("glStateCaptureNV              : %p\n", p);
	p = gl.OSMesaGetProcAddress("glStencilClearTagEXT");
	printf("glStencilClearTagEXT          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glStencilFillPathInstancedNV");
	printf("glStencilFillPathInstancedNV  : %p\n", p);
	p = gl.OSMesaGetProcAddress("glStencilFillPathNV");
	printf("glStencilFillPathNV           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glStencilFunc");
	printf("glStencilFunc                 : %p\n", p);
	p = gl.OSMesaGetProcAddress("glStencilFuncSeparate");
	printf("glStencilFuncSeparate         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glStencilFuncSeparateATI");
	printf("glStencilFuncSeparateATI      : %p\n", p);
	p = gl.OSMesaGetProcAddress("glStencilMask");
	printf("glStencilMask                 : %p\n", p);
	p = gl.OSMesaGetProcAddress("glStencilMaskSeparate");
	printf("glStencilMaskSeparate         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glStencilOp");
	printf("glStencilOp                   : %p\n", p);
	p = gl.OSMesaGetProcAddress("glStencilOpSeparate");
	printf("glStencilOpSeparate           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glStencilOpSeparateATI");
	printf("glStencilOpSeparateATI        : %p\n", p);
	p = gl.OSMesaGetProcAddress("glStencilOpValueAMD");
	printf("glStencilOpValueAMD           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glStencilStrokePathInstancedNV");
	printf("glStencilStrokePathInstancedNV: %p\n", p);
	p = gl.OSMesaGetProcAddress("glStencilStrokePathNV");
	printf("glStencilStrokePathNV         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glStencilThenCoverFillPathInstancedNV");
	printf("glStencilThenCoverFillPathInstancedNV: %p\n", p);
	p = gl.OSMesaGetProcAddress("glStencilThenCoverFillPathNV");
	printf("glStencilThenCoverFillPathNV  : %p\n", p);
	p = gl.OSMesaGetProcAddress("glStencilThenCoverStrokePathInstancedNV");
	printf("glStencilThenCoverStrokePathInstancedNV: %p\n", p);
	p = gl.OSMesaGetProcAddress("glStencilThenCoverStrokePathNV");
	printf("glStencilThenCoverStrokePathNV: %p\n", p);
	p = gl.OSMesaGetProcAddress("glStopInstrumentsSGIX");
	printf("glStopInstrumentsSGIX         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glStringMarkerGREMEDY");
	printf("glStringMarkerGREMEDY         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glSubpixelPrecisionBiasNV");
	printf("glSubpixelPrecisionBiasNV     : %p\n", p);
	p = gl.OSMesaGetProcAddress("glSwapAPPLE");
	printf("glSwapAPPLE                   : %p\n", p);
	p = gl.OSMesaGetProcAddress("glSwizzleEXT");
	printf("glSwizzleEXT                  : %p\n", p);
	p = gl.OSMesaGetProcAddress("glSyncTextureINTEL");
	printf("glSyncTextureINTEL            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTagSampleBufferSGIX");
	printf("glTagSampleBufferSGIX         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTangent3bEXT");
	printf("glTangent3bEXT                : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTangent3bvEXT");
	printf("glTangent3bvEXT               : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTangent3dEXT");
	printf("glTangent3dEXT                : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTangent3dvEXT");
	printf("glTangent3dvEXT               : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTangent3fEXT");
	printf("glTangent3fEXT                : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTangent3fvEXT");
	printf("glTangent3fvEXT               : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTangent3iEXT");
	printf("glTangent3iEXT                : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTangent3ivEXT");
	printf("glTangent3ivEXT               : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTangent3sEXT");
	printf("glTangent3sEXT                : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTangent3svEXT");
	printf("glTangent3svEXT               : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTangentPointerEXT");
	printf("glTangentPointerEXT           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTbufferMask3DFX");
	printf("glTbufferMask3DFX             : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTessellationFactorAMD");
	printf("glTessellationFactorAMD       : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTessellationModeAMD");
	printf("glTessellationModeAMD         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTestFenceAPPLE");
	printf("glTestFenceAPPLE              : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTestFenceNV");
	printf("glTestFenceNV                 : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTestObjectAPPLE");
	printf("glTestObjectAPPLE             : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTexBuffer");
	printf("glTexBuffer                   : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTexBufferARB");
	printf("glTexBufferARB                : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTexBufferEXT");
	printf("glTexBufferEXT                : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTexBufferRange");
	printf("glTexBufferRange              : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTexBumpParameterfvATI");
	printf("glTexBumpParameterfvATI       : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTexBumpParameterivATI");
	printf("glTexBumpParameterivATI       : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTexCoord1bOES");
	printf("glTexCoord1bOES               : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTexCoord1bvOES");
	printf("glTexCoord1bvOES              : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTexCoord1d");
	printf("glTexCoord1d                  : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTexCoord1dv");
	printf("glTexCoord1dv                 : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTexCoord1f");
	printf("glTexCoord1f                  : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTexCoord1fv");
	printf("glTexCoord1fv                 : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTexCoord1hNV");
	printf("glTexCoord1hNV                : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTexCoord1hvNV");
	printf("glTexCoord1hvNV               : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTexCoord1i");
	printf("glTexCoord1i                  : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTexCoord1iv");
	printf("glTexCoord1iv                 : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTexCoord1s");
	printf("glTexCoord1s                  : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTexCoord1sv");
	printf("glTexCoord1sv                 : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTexCoord1xOES");
	printf("glTexCoord1xOES               : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTexCoord1xvOES");
	printf("glTexCoord1xvOES              : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTexCoord2bOES");
	printf("glTexCoord2bOES               : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTexCoord2bvOES");
	printf("glTexCoord2bvOES              : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTexCoord2d");
	printf("glTexCoord2d                  : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTexCoord2dv");
	printf("glTexCoord2dv                 : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTexCoord2f");
	printf("glTexCoord2f                  : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTexCoord2fColor3fVertex3fSUN");
	printf("glTexCoord2fColor3fVertex3fSUN: %p\n", p);
	p = gl.OSMesaGetProcAddress("glTexCoord2fColor3fVertex3fvSUN");
	printf("glTexCoord2fColor3fVertex3fvSUN: %p\n", p);
	p = gl.OSMesaGetProcAddress("glTexCoord2fColor4fNormal3fVertex3fSUN");
	printf("glTexCoord2fColor4fNormal3fVertex3fSUN: %p\n", p);
	p = gl.OSMesaGetProcAddress("glTexCoord2fColor4fNormal3fVertex3fvSUN");
	printf("glTexCoord2fColor4fNormal3fVertex3fvSUN: %p\n", p);
	p = gl.OSMesaGetProcAddress("glTexCoord2fColor4ubVertex3fSUN");
	printf("glTexCoord2fColor4ubVertex3fSUN: %p\n", p);
	p = gl.OSMesaGetProcAddress("glTexCoord2fColor4ubVertex3fvSUN");
	printf("glTexCoord2fColor4ubVertex3fvSUN: %p\n", p);
	p = gl.OSMesaGetProcAddress("glTexCoord2fNormal3fVertex3fSUN");
	printf("glTexCoord2fNormal3fVertex3fSUN: %p\n", p);
	p = gl.OSMesaGetProcAddress("glTexCoord2fNormal3fVertex3fvSUN");
	printf("glTexCoord2fNormal3fVertex3fvSUN: %p\n", p);
	p = gl.OSMesaGetProcAddress("glTexCoord2fVertex3fSUN");
	printf("glTexCoord2fVertex3fSUN       : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTexCoord2fVertex3fvSUN");
	printf("glTexCoord2fVertex3fvSUN      : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTexCoord2fv");
	printf("glTexCoord2fv                 : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTexCoord2hNV");
	printf("glTexCoord2hNV                : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTexCoord2hvNV");
	printf("glTexCoord2hvNV               : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTexCoord2i");
	printf("glTexCoord2i                  : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTexCoord2iv");
	printf("glTexCoord2iv                 : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTexCoord2s");
	printf("glTexCoord2s                  : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTexCoord2sv");
	printf("glTexCoord2sv                 : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTexCoord2xOES");
	printf("glTexCoord2xOES               : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTexCoord2xvOES");
	printf("glTexCoord2xvOES              : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTexCoord3bOES");
	printf("glTexCoord3bOES               : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTexCoord3bvOES");
	printf("glTexCoord3bvOES              : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTexCoord3d");
	printf("glTexCoord3d                  : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTexCoord3dv");
	printf("glTexCoord3dv                 : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTexCoord3f");
	printf("glTexCoord3f                  : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTexCoord3fv");
	printf("glTexCoord3fv                 : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTexCoord3hNV");
	printf("glTexCoord3hNV                : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTexCoord3hvNV");
	printf("glTexCoord3hvNV               : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTexCoord3i");
	printf("glTexCoord3i                  : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTexCoord3iv");
	printf("glTexCoord3iv                 : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTexCoord3s");
	printf("glTexCoord3s                  : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTexCoord3sv");
	printf("glTexCoord3sv                 : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTexCoord3xOES");
	printf("glTexCoord3xOES               : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTexCoord3xvOES");
	printf("glTexCoord3xvOES              : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTexCoord4bOES");
	printf("glTexCoord4bOES               : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTexCoord4bvOES");
	printf("glTexCoord4bvOES              : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTexCoord4d");
	printf("glTexCoord4d                  : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTexCoord4dv");
	printf("glTexCoord4dv                 : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTexCoord4f");
	printf("glTexCoord4f                  : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTexCoord4fColor4fNormal3fVertex4fSUN");
	printf("glTexCoord4fColor4fNormal3fVertex4fSUN: %p\n", p);
	p = gl.OSMesaGetProcAddress("glTexCoord4fColor4fNormal3fVertex4fvSUN");
	printf("glTexCoord4fColor4fNormal3fVertex4fvSUN: %p\n", p);
	p = gl.OSMesaGetProcAddress("glTexCoord4fVertex4fSUN");
	printf("glTexCoord4fVertex4fSUN       : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTexCoord4fVertex4fvSUN");
	printf("glTexCoord4fVertex4fvSUN      : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTexCoord4fv");
	printf("glTexCoord4fv                 : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTexCoord4hNV");
	printf("glTexCoord4hNV                : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTexCoord4hvNV");
	printf("glTexCoord4hvNV               : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTexCoord4i");
	printf("glTexCoord4i                  : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTexCoord4iv");
	printf("glTexCoord4iv                 : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTexCoord4s");
	printf("glTexCoord4s                  : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTexCoord4sv");
	printf("glTexCoord4sv                 : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTexCoord4xOES");
	printf("glTexCoord4xOES               : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTexCoord4xvOES");
	printf("glTexCoord4xvOES              : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTexCoordFormatNV");
	printf("glTexCoordFormatNV            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTexCoordP1ui");
	printf("glTexCoordP1ui                : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTexCoordP1uiv");
	printf("glTexCoordP1uiv               : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTexCoordP2ui");
	printf("glTexCoordP2ui                : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTexCoordP2uiv");
	printf("glTexCoordP2uiv               : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTexCoordP3ui");
	printf("glTexCoordP3ui                : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTexCoordP3uiv");
	printf("glTexCoordP3uiv               : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTexCoordP4ui");
	printf("glTexCoordP4ui                : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTexCoordP4uiv");
	printf("glTexCoordP4uiv               : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTexCoordPointer");
	printf("glTexCoordPointer             : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTexCoordPointerEXT");
	printf("glTexCoordPointerEXT          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTexCoordPointerListIBM");
	printf("glTexCoordPointerListIBM      : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTexCoordPointervINTEL");
	printf("glTexCoordPointervINTEL       : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTexEnvf");
	printf("glTexEnvf                     : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTexEnvfv");
	printf("glTexEnvfv                    : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTexEnvi");
	printf("glTexEnvi                     : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTexEnviv");
	printf("glTexEnviv                    : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTexEnvxOES");
	printf("glTexEnvxOES                  : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTexEnvxvOES");
	printf("glTexEnvxvOES                 : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTexFilterFuncSGIS");
	printf("glTexFilterFuncSGIS           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTexGend");
	printf("glTexGend                     : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTexGendv");
	printf("glTexGendv                    : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTexGenf");
	printf("glTexGenf                     : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTexGenfv");
	printf("glTexGenfv                    : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTexGeni");
	printf("glTexGeni                     : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTexGeniv");
	printf("glTexGeniv                    : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTexGenxOES");
	printf("glTexGenxOES                  : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTexGenxvOES");
	printf("glTexGenxvOES                 : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTexImage1D");
	printf("glTexImage1D                  : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTexImage2D");
	printf("glTexImage2D                  : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTexImage2DMultisample");
	printf("glTexImage2DMultisample       : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTexImage2DMultisampleCoverageNV");
	printf("glTexImage2DMultisampleCoverageNV: %p\n", p);
	p = gl.OSMesaGetProcAddress("glTexImage3D");
	printf("glTexImage3D                  : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTexImage3DEXT");
	printf("glTexImage3DEXT               : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTexImage3DMultisample");
	printf("glTexImage3DMultisample       : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTexImage3DMultisampleCoverageNV");
	printf("glTexImage3DMultisampleCoverageNV: %p\n", p);
	p = gl.OSMesaGetProcAddress("glTexImage4DSGIS");
	printf("glTexImage4DSGIS              : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTexPageCommitmentARB");
	printf("glTexPageCommitmentARB        : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTexParameterIiv");
	printf("glTexParameterIiv             : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTexParameterIivEXT");
	printf("glTexParameterIivEXT          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTexParameterIuiv");
	printf("glTexParameterIuiv            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTexParameterIuivEXT");
	printf("glTexParameterIuivEXT         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTexParameterf");
	printf("glTexParameterf               : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTexParameterfv");
	printf("glTexParameterfv              : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTexParameteri");
	printf("glTexParameteri               : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTexParameteriv");
	printf("glTexParameteriv              : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTexParameterxOES");
	printf("glTexParameterxOES            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTexParameterxvOES");
	printf("glTexParameterxvOES           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTexRenderbufferNV");
	printf("glTexRenderbufferNV           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTexScissorFuncINTEL");
	printf("glTexScissorFuncINTEL         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTexScissorINTEL");
	printf("glTexScissorINTEL             : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTexStorage1D");
	printf("glTexStorage1D                : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTexStorage2D");
	printf("glTexStorage2D                : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTexStorage2DMultisample");
	printf("glTexStorage2DMultisample     : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTexStorage3D");
	printf("glTexStorage3D                : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTexStorage3DMultisample");
	printf("glTexStorage3DMultisample     : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTexStorageMem1DEXT");
	printf("glTexStorageMem1DEXT          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTexStorageMem2DEXT");
	printf("glTexStorageMem2DEXT          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTexStorageMem2DMultisampleEXT");
	printf("glTexStorageMem2DMultisampleEXT: %p\n", p);
	p = gl.OSMesaGetProcAddress("glTexStorageMem3DEXT");
	printf("glTexStorageMem3DEXT          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTexStorageMem3DMultisampleEXT");
	printf("glTexStorageMem3DMultisampleEXT: %p\n", p);
	p = gl.OSMesaGetProcAddress("glTexStorageSparseAMD");
	printf("glTexStorageSparseAMD         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTexSubImage1D");
	printf("glTexSubImage1D               : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTexSubImage1DEXT");
	printf("glTexSubImage1DEXT            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTexSubImage2D");
	printf("glTexSubImage2D               : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTexSubImage2DEXT");
	printf("glTexSubImage2DEXT            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTexSubImage3D");
	printf("glTexSubImage3D               : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTexSubImage3DEXT");
	printf("glTexSubImage3DEXT            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTexSubImage4DSGIS");
	printf("glTexSubImage4DSGIS           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTextureBarrier");
	printf("glTextureBarrier              : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTextureBarrierNV");
	printf("glTextureBarrierNV            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTextureBuffer");
	printf("glTextureBuffer               : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTextureBufferEXT");
	printf("glTextureBufferEXT            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTextureBufferRange");
	printf("glTextureBufferRange          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTextureBufferRangeEXT");
	printf("glTextureBufferRangeEXT       : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTextureColorMaskSGIS");
	printf("glTextureColorMaskSGIS        : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTextureFogSGIX");
	printf("glTextureFogSGIX              : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTextureImage1DEXT");
	printf("glTextureImage1DEXT           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTextureImage2DEXT");
	printf("glTextureImage2DEXT           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTextureImage2DMultisampleCoverageNV");
	printf("glTextureImage2DMultisampleCoverageNV: %p\n", p);
	p = gl.OSMesaGetProcAddress("glTextureImage2DMultisampleNV");
	printf("glTextureImage2DMultisampleNV : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTextureImage3DEXT");
	printf("glTextureImage3DEXT           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTextureImage3DMultisampleCoverageNV");
	printf("glTextureImage3DMultisampleCoverageNV: %p\n", p);
	p = gl.OSMesaGetProcAddress("glTextureImage3DMultisampleNV");
	printf("glTextureImage3DMultisampleNV : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTextureLightEXT");
	printf("glTextureLightEXT             : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTextureMaterialEXT");
	printf("glTextureMaterialEXT          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTextureNormalEXT");
	printf("glTextureNormalEXT            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTexturePageCommitmentEXT");
	printf("glTexturePageCommitmentEXT    : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTextureParameterIiv");
	printf("glTextureParameterIiv         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTextureParameterIivEXT");
	printf("glTextureParameterIivEXT      : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTextureParameterIuiv");
	printf("glTextureParameterIuiv        : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTextureParameterIuivEXT");
	printf("glTextureParameterIuivEXT     : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTextureParameterf");
	printf("glTextureParameterf           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTextureParameterfEXT");
	printf("glTextureParameterfEXT        : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTextureParameterfv");
	printf("glTextureParameterfv          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTextureParameterfvEXT");
	printf("glTextureParameterfvEXT       : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTextureParameteri");
	printf("glTextureParameteri           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTextureParameteriEXT");
	printf("glTextureParameteriEXT        : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTextureParameteriv");
	printf("glTextureParameteriv          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTextureParameterivEXT");
	printf("glTextureParameterivEXT       : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTextureRangeAPPLE");
	printf("glTextureRangeAPPLE           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTextureRenderbufferEXT");
	printf("glTextureRenderbufferEXT      : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTextureStorage1D");
	printf("glTextureStorage1D            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTextureStorage1DEXT");
	printf("glTextureStorage1DEXT         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTextureStorage2D");
	printf("glTextureStorage2D            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTextureStorage2DEXT");
	printf("glTextureStorage2DEXT         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTextureStorage2DMultisample");
	printf("glTextureStorage2DMultisample : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTextureStorage2DMultisampleEXT");
	printf("glTextureStorage2DMultisampleEXT: %p\n", p);
	p = gl.OSMesaGetProcAddress("glTextureStorage3D");
	printf("glTextureStorage3D            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTextureStorage3DEXT");
	printf("glTextureStorage3DEXT         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTextureStorage3DMultisample");
	printf("glTextureStorage3DMultisample : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTextureStorage3DMultisampleEXT");
	printf("glTextureStorage3DMultisampleEXT: %p\n", p);
	p = gl.OSMesaGetProcAddress("glTextureStorageMem1DEXT");
	printf("glTextureStorageMem1DEXT      : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTextureStorageMem2DEXT");
	printf("glTextureStorageMem2DEXT      : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTextureStorageMem2DMultisampleEXT");
	printf("glTextureStorageMem2DMultisampleEXT: %p\n", p);
	p = gl.OSMesaGetProcAddress("glTextureStorageMem3DEXT");
	printf("glTextureStorageMem3DEXT      : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTextureStorageMem3DMultisampleEXT");
	printf("glTextureStorageMem3DMultisampleEXT: %p\n", p);
	p = gl.OSMesaGetProcAddress("glTextureStorageSparseAMD");
	printf("glTextureStorageSparseAMD     : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTextureSubImage1D");
	printf("glTextureSubImage1D           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTextureSubImage1DEXT");
	printf("glTextureSubImage1DEXT        : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTextureSubImage2D");
	printf("glTextureSubImage2D           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTextureSubImage2DEXT");
	printf("glTextureSubImage2DEXT        : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTextureSubImage3D");
	printf("glTextureSubImage3D           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTextureSubImage3DEXT");
	printf("glTextureSubImage3DEXT        : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTextureView");
	printf("glTextureView                 : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTraceAssertAttribMESA");
	printf("glTraceAssertAttribMESA       : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTraceCommentMESA");
	printf("glTraceCommentMESA            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTraceListMESA");
	printf("glTraceListMESA               : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTracePointerMESA");
	printf("glTracePointerMESA            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTracePointerRangeMESA");
	printf("glTracePointerRangeMESA       : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTraceTextureMESA");
	printf("glTraceTextureMESA            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTrackMatrixNV");
	printf("glTrackMatrixNV               : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTransformFeedbackAttribsNV");
	printf("glTransformFeedbackAttribsNV  : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTransformFeedbackBufferBase");
	printf("glTransformFeedbackBufferBase : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTransformFeedbackBufferRange");
	printf("glTransformFeedbackBufferRange: %p\n", p);
	p = gl.OSMesaGetProcAddress("glTransformFeedbackStreamAttribsNV");
	printf("glTransformFeedbackStreamAttribsNV: %p\n", p);
	p = gl.OSMesaGetProcAddress("glTransformFeedbackVaryings");
	printf("glTransformFeedbackVaryings   : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTransformFeedbackVaryingsEXT");
	printf("glTransformFeedbackVaryingsEXT: %p\n", p);
	p = gl.OSMesaGetProcAddress("glTransformFeedbackVaryingsNV");
	printf("glTransformFeedbackVaryingsNV : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTransformPathNV");
	printf("glTransformPathNV             : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTranslated");
	printf("glTranslated                  : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTranslatef");
	printf("glTranslatef                  : %p\n", p);
	p = gl.OSMesaGetProcAddress("glTranslatexOES");
	printf("glTranslatexOES               : %p\n", p);
	p = gl.OSMesaGetProcAddress("glUniform1d");
	printf("glUniform1d                   : %p\n", p);
	p = gl.OSMesaGetProcAddress("glUniform1dv");
	printf("glUniform1dv                  : %p\n", p);
	p = gl.OSMesaGetProcAddress("glUniform1f");
	printf("glUniform1f                   : %p\n", p);
	p = gl.OSMesaGetProcAddress("glUniform1fARB");
	printf("glUniform1fARB                : %p\n", p);
	p = gl.OSMesaGetProcAddress("glUniform1fv");
	printf("glUniform1fv                  : %p\n", p);
	p = gl.OSMesaGetProcAddress("glUniform1fvARB");
	printf("glUniform1fvARB               : %p\n", p);
	p = gl.OSMesaGetProcAddress("glUniform1i");
	printf("glUniform1i                   : %p\n", p);
	p = gl.OSMesaGetProcAddress("glUniform1i64ARB");
	printf("glUniform1i64ARB              : %p\n", p);
	p = gl.OSMesaGetProcAddress("glUniform1i64NV");
	printf("glUniform1i64NV               : %p\n", p);
	p = gl.OSMesaGetProcAddress("glUniform1i64vARB");
	printf("glUniform1i64vARB             : %p\n", p);
	p = gl.OSMesaGetProcAddress("glUniform1i64vNV");
	printf("glUniform1i64vNV              : %p\n", p);
	p = gl.OSMesaGetProcAddress("glUniform1iARB");
	printf("glUniform1iARB                : %p\n", p);
	p = gl.OSMesaGetProcAddress("glUniform1iv");
	printf("glUniform1iv                  : %p\n", p);
	p = gl.OSMesaGetProcAddress("glUniform1ivARB");
	printf("glUniform1ivARB               : %p\n", p);
	p = gl.OSMesaGetProcAddress("glUniform1ui");
	printf("glUniform1ui                  : %p\n", p);
	p = gl.OSMesaGetProcAddress("glUniform1ui64ARB");
	printf("glUniform1ui64ARB             : %p\n", p);
	p = gl.OSMesaGetProcAddress("glUniform1ui64NV");
	printf("glUniform1ui64NV              : %p\n", p);
	p = gl.OSMesaGetProcAddress("glUniform1ui64vARB");
	printf("glUniform1ui64vARB            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glUniform1ui64vNV");
	printf("glUniform1ui64vNV             : %p\n", p);
	p = gl.OSMesaGetProcAddress("glUniform1uiEXT");
	printf("glUniform1uiEXT               : %p\n", p);
	p = gl.OSMesaGetProcAddress("glUniform1uiv");
	printf("glUniform1uiv                 : %p\n", p);
	p = gl.OSMesaGetProcAddress("glUniform1uivEXT");
	printf("glUniform1uivEXT              : %p\n", p);
	p = gl.OSMesaGetProcAddress("glUniform2d");
	printf("glUniform2d                   : %p\n", p);
	p = gl.OSMesaGetProcAddress("glUniform2dv");
	printf("glUniform2dv                  : %p\n", p);
	p = gl.OSMesaGetProcAddress("glUniform2f");
	printf("glUniform2f                   : %p\n", p);
	p = gl.OSMesaGetProcAddress("glUniform2fARB");
	printf("glUniform2fARB                : %p\n", p);
	p = gl.OSMesaGetProcAddress("glUniform2fv");
	printf("glUniform2fv                  : %p\n", p);
	p = gl.OSMesaGetProcAddress("glUniform2fvARB");
	printf("glUniform2fvARB               : %p\n", p);
	p = gl.OSMesaGetProcAddress("glUniform2i");
	printf("glUniform2i                   : %p\n", p);
	p = gl.OSMesaGetProcAddress("glUniform2i64ARB");
	printf("glUniform2i64ARB              : %p\n", p);
	p = gl.OSMesaGetProcAddress("glUniform2i64NV");
	printf("glUniform2i64NV               : %p\n", p);
	p = gl.OSMesaGetProcAddress("glUniform2i64vARB");
	printf("glUniform2i64vARB             : %p\n", p);
	p = gl.OSMesaGetProcAddress("glUniform2i64vNV");
	printf("glUniform2i64vNV              : %p\n", p);
	p = gl.OSMesaGetProcAddress("glUniform2iARB");
	printf("glUniform2iARB                : %p\n", p);
	p = gl.OSMesaGetProcAddress("glUniform2iv");
	printf("glUniform2iv                  : %p\n", p);
	p = gl.OSMesaGetProcAddress("glUniform2ivARB");
	printf("glUniform2ivARB               : %p\n", p);
	p = gl.OSMesaGetProcAddress("glUniform2ui");
	printf("glUniform2ui                  : %p\n", p);
	p = gl.OSMesaGetProcAddress("glUniform2ui64ARB");
	printf("glUniform2ui64ARB             : %p\n", p);
	p = gl.OSMesaGetProcAddress("glUniform2ui64NV");
	printf("glUniform2ui64NV              : %p\n", p);
	p = gl.OSMesaGetProcAddress("glUniform2ui64vARB");
	printf("glUniform2ui64vARB            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glUniform2ui64vNV");
	printf("glUniform2ui64vNV             : %p\n", p);
	p = gl.OSMesaGetProcAddress("glUniform2uiEXT");
	printf("glUniform2uiEXT               : %p\n", p);
	p = gl.OSMesaGetProcAddress("glUniform2uiv");
	printf("glUniform2uiv                 : %p\n", p);
	p = gl.OSMesaGetProcAddress("glUniform2uivEXT");
	printf("glUniform2uivEXT              : %p\n", p);
	p = gl.OSMesaGetProcAddress("glUniform3d");
	printf("glUniform3d                   : %p\n", p);
	p = gl.OSMesaGetProcAddress("glUniform3dv");
	printf("glUniform3dv                  : %p\n", p);
	p = gl.OSMesaGetProcAddress("glUniform3f");
	printf("glUniform3f                   : %p\n", p);
	p = gl.OSMesaGetProcAddress("glUniform3fARB");
	printf("glUniform3fARB                : %p\n", p);
	p = gl.OSMesaGetProcAddress("glUniform3fv");
	printf("glUniform3fv                  : %p\n", p);
	p = gl.OSMesaGetProcAddress("glUniform3fvARB");
	printf("glUniform3fvARB               : %p\n", p);
	p = gl.OSMesaGetProcAddress("glUniform3i");
	printf("glUniform3i                   : %p\n", p);
	p = gl.OSMesaGetProcAddress("glUniform3i64ARB");
	printf("glUniform3i64ARB              : %p\n", p);
	p = gl.OSMesaGetProcAddress("glUniform3i64NV");
	printf("glUniform3i64NV               : %p\n", p);
	p = gl.OSMesaGetProcAddress("glUniform3i64vARB");
	printf("glUniform3i64vARB             : %p\n", p);
	p = gl.OSMesaGetProcAddress("glUniform3i64vNV");
	printf("glUniform3i64vNV              : %p\n", p);
	p = gl.OSMesaGetProcAddress("glUniform3iARB");
	printf("glUniform3iARB                : %p\n", p);
	p = gl.OSMesaGetProcAddress("glUniform3iv");
	printf("glUniform3iv                  : %p\n", p);
	p = gl.OSMesaGetProcAddress("glUniform3ivARB");
	printf("glUniform3ivARB               : %p\n", p);
	p = gl.OSMesaGetProcAddress("glUniform3ui");
	printf("glUniform3ui                  : %p\n", p);
	p = gl.OSMesaGetProcAddress("glUniform3ui64ARB");
	printf("glUniform3ui64ARB             : %p\n", p);
	p = gl.OSMesaGetProcAddress("glUniform3ui64NV");
	printf("glUniform3ui64NV              : %p\n", p);
	p = gl.OSMesaGetProcAddress("glUniform3ui64vARB");
	printf("glUniform3ui64vARB            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glUniform3ui64vNV");
	printf("glUniform3ui64vNV             : %p\n", p);
	p = gl.OSMesaGetProcAddress("glUniform3uiEXT");
	printf("glUniform3uiEXT               : %p\n", p);
	p = gl.OSMesaGetProcAddress("glUniform3uiv");
	printf("glUniform3uiv                 : %p\n", p);
	p = gl.OSMesaGetProcAddress("glUniform3uivEXT");
	printf("glUniform3uivEXT              : %p\n", p);
	p = gl.OSMesaGetProcAddress("glUniform4d");
	printf("glUniform4d                   : %p\n", p);
	p = gl.OSMesaGetProcAddress("glUniform4dv");
	printf("glUniform4dv                  : %p\n", p);
	p = gl.OSMesaGetProcAddress("glUniform4f");
	printf("glUniform4f                   : %p\n", p);
	p = gl.OSMesaGetProcAddress("glUniform4fARB");
	printf("glUniform4fARB                : %p\n", p);
	p = gl.OSMesaGetProcAddress("glUniform4fv");
	printf("glUniform4fv                  : %p\n", p);
	p = gl.OSMesaGetProcAddress("glUniform4fvARB");
	printf("glUniform4fvARB               : %p\n", p);
	p = gl.OSMesaGetProcAddress("glUniform4i");
	printf("glUniform4i                   : %p\n", p);
	p = gl.OSMesaGetProcAddress("glUniform4i64ARB");
	printf("glUniform4i64ARB              : %p\n", p);
	p = gl.OSMesaGetProcAddress("glUniform4i64NV");
	printf("glUniform4i64NV               : %p\n", p);
	p = gl.OSMesaGetProcAddress("glUniform4i64vARB");
	printf("glUniform4i64vARB             : %p\n", p);
	p = gl.OSMesaGetProcAddress("glUniform4i64vNV");
	printf("glUniform4i64vNV              : %p\n", p);
	p = gl.OSMesaGetProcAddress("glUniform4iARB");
	printf("glUniform4iARB                : %p\n", p);
	p = gl.OSMesaGetProcAddress("glUniform4iv");
	printf("glUniform4iv                  : %p\n", p);
	p = gl.OSMesaGetProcAddress("glUniform4ivARB");
	printf("glUniform4ivARB               : %p\n", p);
	p = gl.OSMesaGetProcAddress("glUniform4ui");
	printf("glUniform4ui                  : %p\n", p);
	p = gl.OSMesaGetProcAddress("glUniform4ui64ARB");
	printf("glUniform4ui64ARB             : %p\n", p);
	p = gl.OSMesaGetProcAddress("glUniform4ui64NV");
	printf("glUniform4ui64NV              : %p\n", p);
	p = gl.OSMesaGetProcAddress("glUniform4ui64vARB");
	printf("glUniform4ui64vARB            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glUniform4ui64vNV");
	printf("glUniform4ui64vNV             : %p\n", p);
	p = gl.OSMesaGetProcAddress("glUniform4uiEXT");
	printf("glUniform4uiEXT               : %p\n", p);
	p = gl.OSMesaGetProcAddress("glUniform4uiv");
	printf("glUniform4uiv                 : %p\n", p);
	p = gl.OSMesaGetProcAddress("glUniform4uivEXT");
	printf("glUniform4uivEXT              : %p\n", p);
	p = gl.OSMesaGetProcAddress("glUniformBlockBinding");
	printf("glUniformBlockBinding         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glUniformBufferEXT");
	printf("glUniformBufferEXT            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glUniformHandleui64ARB");
	printf("glUniformHandleui64ARB        : %p\n", p);
	p = gl.OSMesaGetProcAddress("glUniformHandleui64NV");
	printf("glUniformHandleui64NV         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glUniformHandleui64vARB");
	printf("glUniformHandleui64vARB       : %p\n", p);
	p = gl.OSMesaGetProcAddress("glUniformHandleui64vNV");
	printf("glUniformHandleui64vNV        : %p\n", p);
	p = gl.OSMesaGetProcAddress("glUniformMatrix2dv");
	printf("glUniformMatrix2dv            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glUniformMatrix2fv");
	printf("glUniformMatrix2fv            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glUniformMatrix2fvARB");
	printf("glUniformMatrix2fvARB         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glUniformMatrix2x3dv");
	printf("glUniformMatrix2x3dv          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glUniformMatrix2x3fv");
	printf("glUniformMatrix2x3fv          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glUniformMatrix2x4dv");
	printf("glUniformMatrix2x4dv          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glUniformMatrix2x4fv");
	printf("glUniformMatrix2x4fv          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glUniformMatrix3dv");
	printf("glUniformMatrix3dv            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glUniformMatrix3fv");
	printf("glUniformMatrix3fv            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glUniformMatrix3fvARB");
	printf("glUniformMatrix3fvARB         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glUniformMatrix3x2dv");
	printf("glUniformMatrix3x2dv          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glUniformMatrix3x2fv");
	printf("glUniformMatrix3x2fv          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glUniformMatrix3x4dv");
	printf("glUniformMatrix3x4dv          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glUniformMatrix3x4fv");
	printf("glUniformMatrix3x4fv          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glUniformMatrix4dv");
	printf("glUniformMatrix4dv            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glUniformMatrix4fv");
	printf("glUniformMatrix4fv            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glUniformMatrix4fvARB");
	printf("glUniformMatrix4fvARB         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glUniformMatrix4x2dv");
	printf("glUniformMatrix4x2dv          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glUniformMatrix4x2fv");
	printf("glUniformMatrix4x2fv          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glUniformMatrix4x3dv");
	printf("glUniformMatrix4x3dv          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glUniformMatrix4x3fv");
	printf("glUniformMatrix4x3fv          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glUniformSubroutinesuiv");
	printf("glUniformSubroutinesuiv       : %p\n", p);
	p = gl.OSMesaGetProcAddress("glUniformui64NV");
	printf("glUniformui64NV               : %p\n", p);
	p = gl.OSMesaGetProcAddress("glUniformui64vNV");
	printf("glUniformui64vNV              : %p\n", p);
	p = gl.OSMesaGetProcAddress("glUnlockArraysEXT");
	printf("glUnlockArraysEXT             : %p\n", p);
	p = gl.OSMesaGetProcAddress("glUnmapBuffer");
	printf("glUnmapBuffer                 : %p\n", p);
	p = gl.OSMesaGetProcAddress("glUnmapBufferARB");
	printf("glUnmapBufferARB              : %p\n", p);
	p = gl.OSMesaGetProcAddress("glUnmapNamedBuffer");
	printf("glUnmapNamedBuffer            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glUnmapNamedBufferEXT");
	printf("glUnmapNamedBufferEXT         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glUnmapObjectBufferATI");
	printf("glUnmapObjectBufferATI        : %p\n", p);
	p = gl.OSMesaGetProcAddress("glUnmapTexture2DINTEL");
	printf("glUnmapTexture2DINTEL         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glUpdateObjectBufferATI");
	printf("glUpdateObjectBufferATI       : %p\n", p);
	p = gl.OSMesaGetProcAddress("glUseProgram");
	printf("glUseProgram                  : %p\n", p);
	p = gl.OSMesaGetProcAddress("glUseProgramObjectARB");
	printf("glUseProgramObjectARB         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glUseProgramStages");
	printf("glUseProgramStages            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glUseShaderProgramEXT");
	printf("glUseShaderProgramEXT         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVDPAUFiniNV");
	printf("glVDPAUFiniNV                 : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVDPAUGetSurfaceivNV");
	printf("glVDPAUGetSurfaceivNV         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVDPAUInitNV");
	printf("glVDPAUInitNV                 : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVDPAUIsSurfaceNV");
	printf("glVDPAUIsSurfaceNV            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVDPAUMapSurfacesNV");
	printf("glVDPAUMapSurfacesNV          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVDPAURegisterOutputSurfaceNV");
	printf("glVDPAURegisterOutputSurfaceNV: %p\n", p);
	p = gl.OSMesaGetProcAddress("glVDPAURegisterVideoSurfaceNV");
	printf("glVDPAURegisterVideoSurfaceNV : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVDPAUSurfaceAccessNV");
	printf("glVDPAUSurfaceAccessNV        : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVDPAUUnmapSurfacesNV");
	printf("glVDPAUUnmapSurfacesNV        : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVDPAUUnregisterSurfaceNV");
	printf("glVDPAUUnregisterSurfaceNV    : %p\n", p);
	p = gl.OSMesaGetProcAddress("glValidateProgram");
	printf("glValidateProgram             : %p\n", p);
	p = gl.OSMesaGetProcAddress("glValidateProgramARB");
	printf("glValidateProgramARB          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glValidateProgramPipeline");
	printf("glValidateProgramPipeline     : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVariantArrayObjectATI");
	printf("glVariantArrayObjectATI       : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVariantPointerEXT");
	printf("glVariantPointerEXT           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVariantbvEXT");
	printf("glVariantbvEXT                : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVariantdvEXT");
	printf("glVariantdvEXT                : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVariantfvEXT");
	printf("glVariantfvEXT                : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVariantivEXT");
	printf("glVariantivEXT                : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVariantsvEXT");
	printf("glVariantsvEXT                : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVariantubvEXT");
	printf("glVariantubvEXT               : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVariantuivEXT");
	printf("glVariantuivEXT               : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVariantusvEXT");
	printf("glVariantusvEXT               : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertex2bOES");
	printf("glVertex2bOES                 : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertex2bvOES");
	printf("glVertex2bvOES                : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertex2d");
	printf("glVertex2d                    : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertex2dv");
	printf("glVertex2dv                   : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertex2f");
	printf("glVertex2f                    : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertex2fv");
	printf("glVertex2fv                   : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertex2hNV");
	printf("glVertex2hNV                  : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertex2hvNV");
	printf("glVertex2hvNV                 : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertex2i");
	printf("glVertex2i                    : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertex2iv");
	printf("glVertex2iv                   : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertex2s");
	printf("glVertex2s                    : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertex2sv");
	printf("glVertex2sv                   : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertex2xOES");
	printf("glVertex2xOES                 : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertex2xvOES");
	printf("glVertex2xvOES                : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertex3bOES");
	printf("glVertex3bOES                 : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertex3bvOES");
	printf("glVertex3bvOES                : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertex3d");
	printf("glVertex3d                    : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertex3dv");
	printf("glVertex3dv                   : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertex3f");
	printf("glVertex3f                    : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertex3fv");
	printf("glVertex3fv                   : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertex3hNV");
	printf("glVertex3hNV                  : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertex3hvNV");
	printf("glVertex3hvNV                 : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertex3i");
	printf("glVertex3i                    : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertex3iv");
	printf("glVertex3iv                   : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertex3s");
	printf("glVertex3s                    : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertex3sv");
	printf("glVertex3sv                   : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertex3xOES");
	printf("glVertex3xOES                 : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertex3xvOES");
	printf("glVertex3xvOES                : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertex4bOES");
	printf("glVertex4bOES                 : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertex4bvOES");
	printf("glVertex4bvOES                : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertex4d");
	printf("glVertex4d                    : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertex4dv");
	printf("glVertex4dv                   : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertex4f");
	printf("glVertex4f                    : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertex4fv");
	printf("glVertex4fv                   : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertex4hNV");
	printf("glVertex4hNV                  : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertex4hvNV");
	printf("glVertex4hvNV                 : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertex4i");
	printf("glVertex4i                    : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertex4iv");
	printf("glVertex4iv                   : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertex4s");
	printf("glVertex4s                    : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertex4sv");
	printf("glVertex4sv                   : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertex4xOES");
	printf("glVertex4xOES                 : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertex4xvOES");
	printf("glVertex4xvOES                : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexArrayAttribBinding");
	printf("glVertexArrayAttribBinding    : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexArrayAttribFormat");
	printf("glVertexArrayAttribFormat     : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexArrayAttribIFormat");
	printf("glVertexArrayAttribIFormat    : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexArrayAttribLFormat");
	printf("glVertexArrayAttribLFormat    : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexArrayBindVertexBufferEXT");
	printf("glVertexArrayBindVertexBufferEXT: %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexArrayBindingDivisor");
	printf("glVertexArrayBindingDivisor   : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexArrayColorOffsetEXT");
	printf("glVertexArrayColorOffsetEXT   : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexArrayEdgeFlagOffsetEXT");
	printf("glVertexArrayEdgeFlagOffsetEXT: %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexArrayElementBuffer");
	printf("glVertexArrayElementBuffer    : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexArrayFogCoordOffsetEXT");
	printf("glVertexArrayFogCoordOffsetEXT: %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexArrayIndexOffsetEXT");
	printf("glVertexArrayIndexOffsetEXT   : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexArrayMultiTexCoordOffsetEXT");
	printf("glVertexArrayMultiTexCoordOffsetEXT: %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexArrayNormalOffsetEXT");
	printf("glVertexArrayNormalOffsetEXT  : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexArrayParameteriAPPLE");
	printf("glVertexArrayParameteriAPPLE  : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexArrayRangeAPPLE");
	printf("glVertexArrayRangeAPPLE       : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexArrayRangeNV");
	printf("glVertexArrayRangeNV          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexArraySecondaryColorOffsetEXT");
	printf("glVertexArraySecondaryColorOffsetEXT: %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexArrayTexCoordOffsetEXT");
	printf("glVertexArrayTexCoordOffsetEXT: %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexArrayVertexAttribBindingEXT");
	printf("glVertexArrayVertexAttribBindingEXT: %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexArrayVertexAttribDivisorEXT");
	printf("glVertexArrayVertexAttribDivisorEXT: %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexArrayVertexAttribFormatEXT");
	printf("glVertexArrayVertexAttribFormatEXT: %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexArrayVertexAttribIFormatEXT");
	printf("glVertexArrayVertexAttribIFormatEXT: %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexArrayVertexAttribIOffsetEXT");
	printf("glVertexArrayVertexAttribIOffsetEXT: %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexArrayVertexAttribLFormatEXT");
	printf("glVertexArrayVertexAttribLFormatEXT: %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexArrayVertexAttribLOffsetEXT");
	printf("glVertexArrayVertexAttribLOffsetEXT: %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexArrayVertexAttribOffsetEXT");
	printf("glVertexArrayVertexAttribOffsetEXT: %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexArrayVertexBindingDivisorEXT");
	printf("glVertexArrayVertexBindingDivisorEXT: %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexArrayVertexBuffer");
	printf("glVertexArrayVertexBuffer     : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexArrayVertexBuffers");
	printf("glVertexArrayVertexBuffers    : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexArrayVertexOffsetEXT");
	printf("glVertexArrayVertexOffsetEXT  : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttrib1d");
	printf("glVertexAttrib1d              : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttrib1dARB");
	printf("glVertexAttrib1dARB           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttrib1dNV");
	printf("glVertexAttrib1dNV            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttrib1dv");
	printf("glVertexAttrib1dv             : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttrib1dvARB");
	printf("glVertexAttrib1dvARB          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttrib1dvNV");
	printf("glVertexAttrib1dvNV           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttrib1f");
	printf("glVertexAttrib1f              : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttrib1fARB");
	printf("glVertexAttrib1fARB           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttrib1fNV");
	printf("glVertexAttrib1fNV            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttrib1fv");
	printf("glVertexAttrib1fv             : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttrib1fvARB");
	printf("glVertexAttrib1fvARB          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttrib1fvNV");
	printf("glVertexAttrib1fvNV           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttrib1hNV");
	printf("glVertexAttrib1hNV            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttrib1hvNV");
	printf("glVertexAttrib1hvNV           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttrib1s");
	printf("glVertexAttrib1s              : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttrib1sARB");
	printf("glVertexAttrib1sARB           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttrib1sNV");
	printf("glVertexAttrib1sNV            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttrib1sv");
	printf("glVertexAttrib1sv             : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttrib1svARB");
	printf("glVertexAttrib1svARB          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttrib1svNV");
	printf("glVertexAttrib1svNV           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttrib2d");
	printf("glVertexAttrib2d              : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttrib2dARB");
	printf("glVertexAttrib2dARB           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttrib2dNV");
	printf("glVertexAttrib2dNV            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttrib2dv");
	printf("glVertexAttrib2dv             : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttrib2dvARB");
	printf("glVertexAttrib2dvARB          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttrib2dvNV");
	printf("glVertexAttrib2dvNV           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttrib2f");
	printf("glVertexAttrib2f              : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttrib2fARB");
	printf("glVertexAttrib2fARB           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttrib2fNV");
	printf("glVertexAttrib2fNV            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttrib2fv");
	printf("glVertexAttrib2fv             : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttrib2fvARB");
	printf("glVertexAttrib2fvARB          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttrib2fvNV");
	printf("glVertexAttrib2fvNV           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttrib2hNV");
	printf("glVertexAttrib2hNV            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttrib2hvNV");
	printf("glVertexAttrib2hvNV           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttrib2s");
	printf("glVertexAttrib2s              : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttrib2sARB");
	printf("glVertexAttrib2sARB           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttrib2sNV");
	printf("glVertexAttrib2sNV            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttrib2sv");
	printf("glVertexAttrib2sv             : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttrib2svARB");
	printf("glVertexAttrib2svARB          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttrib2svNV");
	printf("glVertexAttrib2svNV           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttrib3d");
	printf("glVertexAttrib3d              : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttrib3dARB");
	printf("glVertexAttrib3dARB           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttrib3dNV");
	printf("glVertexAttrib3dNV            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttrib3dv");
	printf("glVertexAttrib3dv             : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttrib3dvARB");
	printf("glVertexAttrib3dvARB          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttrib3dvNV");
	printf("glVertexAttrib3dvNV           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttrib3f");
	printf("glVertexAttrib3f              : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttrib3fARB");
	printf("glVertexAttrib3fARB           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttrib3fNV");
	printf("glVertexAttrib3fNV            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttrib3fv");
	printf("glVertexAttrib3fv             : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttrib3fvARB");
	printf("glVertexAttrib3fvARB          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttrib3fvNV");
	printf("glVertexAttrib3fvNV           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttrib3hNV");
	printf("glVertexAttrib3hNV            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttrib3hvNV");
	printf("glVertexAttrib3hvNV           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttrib3s");
	printf("glVertexAttrib3s              : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttrib3sARB");
	printf("glVertexAttrib3sARB           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttrib3sNV");
	printf("glVertexAttrib3sNV            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttrib3sv");
	printf("glVertexAttrib3sv             : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttrib3svARB");
	printf("glVertexAttrib3svARB          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttrib3svNV");
	printf("glVertexAttrib3svNV           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttrib4Nbv");
	printf("glVertexAttrib4Nbv            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttrib4NbvARB");
	printf("glVertexAttrib4NbvARB         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttrib4Niv");
	printf("glVertexAttrib4Niv            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttrib4NivARB");
	printf("glVertexAttrib4NivARB         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttrib4Nsv");
	printf("glVertexAttrib4Nsv            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttrib4NsvARB");
	printf("glVertexAttrib4NsvARB         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttrib4Nub");
	printf("glVertexAttrib4Nub            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttrib4NubARB");
	printf("glVertexAttrib4NubARB         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttrib4Nubv");
	printf("glVertexAttrib4Nubv           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttrib4NubvARB");
	printf("glVertexAttrib4NubvARB        : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttrib4Nuiv");
	printf("glVertexAttrib4Nuiv           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttrib4NuivARB");
	printf("glVertexAttrib4NuivARB        : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttrib4Nusv");
	printf("glVertexAttrib4Nusv           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttrib4NusvARB");
	printf("glVertexAttrib4NusvARB        : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttrib4bv");
	printf("glVertexAttrib4bv             : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttrib4bvARB");
	printf("glVertexAttrib4bvARB          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttrib4d");
	printf("glVertexAttrib4d              : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttrib4dARB");
	printf("glVertexAttrib4dARB           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttrib4dNV");
	printf("glVertexAttrib4dNV            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttrib4dv");
	printf("glVertexAttrib4dv             : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttrib4dvARB");
	printf("glVertexAttrib4dvARB          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttrib4dvNV");
	printf("glVertexAttrib4dvNV           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttrib4f");
	printf("glVertexAttrib4f              : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttrib4fARB");
	printf("glVertexAttrib4fARB           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttrib4fNV");
	printf("glVertexAttrib4fNV            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttrib4fv");
	printf("glVertexAttrib4fv             : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttrib4fvARB");
	printf("glVertexAttrib4fvARB          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttrib4fvNV");
	printf("glVertexAttrib4fvNV           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttrib4hNV");
	printf("glVertexAttrib4hNV            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttrib4hvNV");
	printf("glVertexAttrib4hvNV           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttrib4iv");
	printf("glVertexAttrib4iv             : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttrib4ivARB");
	printf("glVertexAttrib4ivARB          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttrib4s");
	printf("glVertexAttrib4s              : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttrib4sARB");
	printf("glVertexAttrib4sARB           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttrib4sNV");
	printf("glVertexAttrib4sNV            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttrib4sv");
	printf("glVertexAttrib4sv             : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttrib4svARB");
	printf("glVertexAttrib4svARB          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttrib4svNV");
	printf("glVertexAttrib4svNV           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttrib4ubNV");
	printf("glVertexAttrib4ubNV           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttrib4ubv");
	printf("glVertexAttrib4ubv            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttrib4ubvARB");
	printf("glVertexAttrib4ubvARB         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttrib4ubvNV");
	printf("glVertexAttrib4ubvNV          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttrib4uiv");
	printf("glVertexAttrib4uiv            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttrib4uivARB");
	printf("glVertexAttrib4uivARB         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttrib4usv");
	printf("glVertexAttrib4usv            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttrib4usvARB");
	printf("glVertexAttrib4usvARB         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttribArrayObjectATI");
	printf("glVertexAttribArrayObjectATI  : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttribBinding");
	printf("glVertexAttribBinding         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttribDivisor");
	printf("glVertexAttribDivisor         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttribDivisorARB");
	printf("glVertexAttribDivisorARB      : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttribFormat");
	printf("glVertexAttribFormat          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttribFormatNV");
	printf("glVertexAttribFormatNV        : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttribI1i");
	printf("glVertexAttribI1i             : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttribI1iEXT");
	printf("glVertexAttribI1iEXT          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttribI1iv");
	printf("glVertexAttribI1iv            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttribI1ivEXT");
	printf("glVertexAttribI1ivEXT         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttribI1ui");
	printf("glVertexAttribI1ui            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttribI1uiEXT");
	printf("glVertexAttribI1uiEXT         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttribI1uiv");
	printf("glVertexAttribI1uiv           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttribI1uivEXT");
	printf("glVertexAttribI1uivEXT        : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttribI2i");
	printf("glVertexAttribI2i             : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttribI2iEXT");
	printf("glVertexAttribI2iEXT          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttribI2iv");
	printf("glVertexAttribI2iv            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttribI2ivEXT");
	printf("glVertexAttribI2ivEXT         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttribI2ui");
	printf("glVertexAttribI2ui            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttribI2uiEXT");
	printf("glVertexAttribI2uiEXT         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttribI2uiv");
	printf("glVertexAttribI2uiv           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttribI2uivEXT");
	printf("glVertexAttribI2uivEXT        : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttribI3i");
	printf("glVertexAttribI3i             : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttribI3iEXT");
	printf("glVertexAttribI3iEXT          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttribI3iv");
	printf("glVertexAttribI3iv            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttribI3ivEXT");
	printf("glVertexAttribI3ivEXT         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttribI3ui");
	printf("glVertexAttribI3ui            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttribI3uiEXT");
	printf("glVertexAttribI3uiEXT         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttribI3uiv");
	printf("glVertexAttribI3uiv           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttribI3uivEXT");
	printf("glVertexAttribI3uivEXT        : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttribI4bv");
	printf("glVertexAttribI4bv            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttribI4bvEXT");
	printf("glVertexAttribI4bvEXT         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttribI4i");
	printf("glVertexAttribI4i             : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttribI4iEXT");
	printf("glVertexAttribI4iEXT          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttribI4iv");
	printf("glVertexAttribI4iv            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttribI4ivEXT");
	printf("glVertexAttribI4ivEXT         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttribI4sv");
	printf("glVertexAttribI4sv            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttribI4svEXT");
	printf("glVertexAttribI4svEXT         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttribI4ubv");
	printf("glVertexAttribI4ubv           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttribI4ubvEXT");
	printf("glVertexAttribI4ubvEXT        : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttribI4ui");
	printf("glVertexAttribI4ui            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttribI4uiEXT");
	printf("glVertexAttribI4uiEXT         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttribI4uiv");
	printf("glVertexAttribI4uiv           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttribI4uivEXT");
	printf("glVertexAttribI4uivEXT        : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttribI4usv");
	printf("glVertexAttribI4usv           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttribI4usvEXT");
	printf("glVertexAttribI4usvEXT        : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttribIFormat");
	printf("glVertexAttribIFormat         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttribIFormatNV");
	printf("glVertexAttribIFormatNV       : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttribIPointer");
	printf("glVertexAttribIPointer        : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttribIPointerEXT");
	printf("glVertexAttribIPointerEXT     : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttribL1d");
	printf("glVertexAttribL1d             : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttribL1dEXT");
	printf("glVertexAttribL1dEXT          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttribL1dv");
	printf("glVertexAttribL1dv            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttribL1dvEXT");
	printf("glVertexAttribL1dvEXT         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttribL1i64NV");
	printf("glVertexAttribL1i64NV         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttribL1i64vNV");
	printf("glVertexAttribL1i64vNV        : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttribL1ui64ARB");
	printf("glVertexAttribL1ui64ARB       : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttribL1ui64NV");
	printf("glVertexAttribL1ui64NV        : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttribL1ui64vARB");
	printf("glVertexAttribL1ui64vARB      : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttribL1ui64vNV");
	printf("glVertexAttribL1ui64vNV       : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttribL2d");
	printf("glVertexAttribL2d             : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttribL2dEXT");
	printf("glVertexAttribL2dEXT          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttribL2dv");
	printf("glVertexAttribL2dv            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttribL2dvEXT");
	printf("glVertexAttribL2dvEXT         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttribL2i64NV");
	printf("glVertexAttribL2i64NV         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttribL2i64vNV");
	printf("glVertexAttribL2i64vNV        : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttribL2ui64NV");
	printf("glVertexAttribL2ui64NV        : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttribL2ui64vNV");
	printf("glVertexAttribL2ui64vNV       : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttribL3d");
	printf("glVertexAttribL3d             : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttribL3dEXT");
	printf("glVertexAttribL3dEXT          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttribL3dv");
	printf("glVertexAttribL3dv            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttribL3dvEXT");
	printf("glVertexAttribL3dvEXT         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttribL3i64NV");
	printf("glVertexAttribL3i64NV         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttribL3i64vNV");
	printf("glVertexAttribL3i64vNV        : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttribL3ui64NV");
	printf("glVertexAttribL3ui64NV        : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttribL3ui64vNV");
	printf("glVertexAttribL3ui64vNV       : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttribL4d");
	printf("glVertexAttribL4d             : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttribL4dEXT");
	printf("glVertexAttribL4dEXT          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttribL4dv");
	printf("glVertexAttribL4dv            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttribL4dvEXT");
	printf("glVertexAttribL4dvEXT         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttribL4i64NV");
	printf("glVertexAttribL4i64NV         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttribL4i64vNV");
	printf("glVertexAttribL4i64vNV        : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttribL4ui64NV");
	printf("glVertexAttribL4ui64NV        : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttribL4ui64vNV");
	printf("glVertexAttribL4ui64vNV       : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttribLFormat");
	printf("glVertexAttribLFormat         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttribLFormatNV");
	printf("glVertexAttribLFormatNV       : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttribLPointer");
	printf("glVertexAttribLPointer        : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttribLPointerEXT");
	printf("glVertexAttribLPointerEXT     : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttribP1ui");
	printf("glVertexAttribP1ui            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttribP1uiv");
	printf("glVertexAttribP1uiv           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttribP2ui");
	printf("glVertexAttribP2ui            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttribP2uiv");
	printf("glVertexAttribP2uiv           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttribP3ui");
	printf("glVertexAttribP3ui            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttribP3uiv");
	printf("glVertexAttribP3uiv           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttribP4ui");
	printf("glVertexAttribP4ui            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttribP4uiv");
	printf("glVertexAttribP4uiv           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttribParameteriAMD");
	printf("glVertexAttribParameteriAMD   : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttribPointer");
	printf("glVertexAttribPointer         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttribPointerARB");
	printf("glVertexAttribPointerARB      : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttribPointerNV");
	printf("glVertexAttribPointerNV       : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttribs1dvNV");
	printf("glVertexAttribs1dvNV          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttribs1fvNV");
	printf("glVertexAttribs1fvNV          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttribs1hvNV");
	printf("glVertexAttribs1hvNV          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttribs1svNV");
	printf("glVertexAttribs1svNV          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttribs2dvNV");
	printf("glVertexAttribs2dvNV          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttribs2fvNV");
	printf("glVertexAttribs2fvNV          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttribs2hvNV");
	printf("glVertexAttribs2hvNV          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttribs2svNV");
	printf("glVertexAttribs2svNV          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttribs3dvNV");
	printf("glVertexAttribs3dvNV          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttribs3fvNV");
	printf("glVertexAttribs3fvNV          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttribs3hvNV");
	printf("glVertexAttribs3hvNV          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttribs3svNV");
	printf("glVertexAttribs3svNV          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttribs4dvNV");
	printf("glVertexAttribs4dvNV          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttribs4fvNV");
	printf("glVertexAttribs4fvNV          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttribs4hvNV");
	printf("glVertexAttribs4hvNV          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttribs4svNV");
	printf("glVertexAttribs4svNV          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexAttribs4ubvNV");
	printf("glVertexAttribs4ubvNV         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexBindingDivisor");
	printf("glVertexBindingDivisor        : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexBlendARB");
	printf("glVertexBlendARB              : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexBlendEnvfATI");
	printf("glVertexBlendEnvfATI          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexBlendEnviATI");
	printf("glVertexBlendEnviATI          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexFormatNV");
	printf("glVertexFormatNV              : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexP2ui");
	printf("glVertexP2ui                  : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexP2uiv");
	printf("glVertexP2uiv                 : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexP3ui");
	printf("glVertexP3ui                  : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexP3uiv");
	printf("glVertexP3uiv                 : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexP4ui");
	printf("glVertexP4ui                  : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexP4uiv");
	printf("glVertexP4uiv                 : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexPointSizefAPPLE");
	printf("glVertexPointSizefAPPLE       : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexPointer");
	printf("glVertexPointer               : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexPointerEXT");
	printf("glVertexPointerEXT            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexPointerListIBM");
	printf("glVertexPointerListIBM        : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexPointervINTEL");
	printf("glVertexPointervINTEL         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexStream1dATI");
	printf("glVertexStream1dATI           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexStream1dvATI");
	printf("glVertexStream1dvATI          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexStream1fATI");
	printf("glVertexStream1fATI           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexStream1fvATI");
	printf("glVertexStream1fvATI          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexStream1iATI");
	printf("glVertexStream1iATI           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexStream1ivATI");
	printf("glVertexStream1ivATI          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexStream1sATI");
	printf("glVertexStream1sATI           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexStream1svATI");
	printf("glVertexStream1svATI          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexStream2dATI");
	printf("glVertexStream2dATI           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexStream2dvATI");
	printf("glVertexStream2dvATI          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexStream2fATI");
	printf("glVertexStream2fATI           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexStream2fvATI");
	printf("glVertexStream2fvATI          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexStream2iATI");
	printf("glVertexStream2iATI           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexStream2ivATI");
	printf("glVertexStream2ivATI          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexStream2sATI");
	printf("glVertexStream2sATI           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexStream2svATI");
	printf("glVertexStream2svATI          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexStream3dATI");
	printf("glVertexStream3dATI           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexStream3dvATI");
	printf("glVertexStream3dvATI          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexStream3fATI");
	printf("glVertexStream3fATI           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexStream3fvATI");
	printf("glVertexStream3fvATI          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexStream3iATI");
	printf("glVertexStream3iATI           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexStream3ivATI");
	printf("glVertexStream3ivATI          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexStream3sATI");
	printf("glVertexStream3sATI           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexStream3svATI");
	printf("glVertexStream3svATI          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexStream4dATI");
	printf("glVertexStream4dATI           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexStream4dvATI");
	printf("glVertexStream4dvATI          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexStream4fATI");
	printf("glVertexStream4fATI           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexStream4fvATI");
	printf("glVertexStream4fvATI          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexStream4iATI");
	printf("glVertexStream4iATI           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexStream4ivATI");
	printf("glVertexStream4ivATI          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexStream4sATI");
	printf("glVertexStream4sATI           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexStream4svATI");
	printf("glVertexStream4svATI          : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexWeightPointerEXT");
	printf("glVertexWeightPointerEXT      : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexWeightfEXT");
	printf("glVertexWeightfEXT            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexWeightfvEXT");
	printf("glVertexWeightfvEXT           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexWeighthNV");
	printf("glVertexWeighthNV             : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVertexWeighthvNV");
	printf("glVertexWeighthvNV            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVideoCaptureNV");
	printf("glVideoCaptureNV              : %p\n", p);
	p = gl.OSMesaGetProcAddress("glVideoCaptureStreamParameterdvNV");
	printf("glVideoCaptureStreamParameterdvNV: %p\n", p);
	p = gl.OSMesaGetProcAddress("glVideoCaptureStreamParameterfvNV");
	printf("glVideoCaptureStreamParameterfvNV: %p\n", p);
	p = gl.OSMesaGetProcAddress("glVideoCaptureStreamParameterivNV");
	printf("glVideoCaptureStreamParameterivNV: %p\n", p);
	p = gl.OSMesaGetProcAddress("glViewport");
	printf("glViewport                    : %p\n", p);
	p = gl.OSMesaGetProcAddress("glViewportArrayv");
	printf("glViewportArrayv              : %p\n", p);
	p = gl.OSMesaGetProcAddress("glViewportIndexedf");
	printf("glViewportIndexedf            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glViewportIndexedfv");
	printf("glViewportIndexedfv           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glViewportPositionWScaleNV");
	printf("glViewportPositionWScaleNV    : %p\n", p);
	p = gl.OSMesaGetProcAddress("glViewportSwizzleNV");
	printf("glViewportSwizzleNV           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glWaitSemaphoreEXT");
	printf("glWaitSemaphoreEXT            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glWaitSync");
	printf("glWaitSync                    : %p\n", p);
	p = gl.OSMesaGetProcAddress("glWaitVkSemaphoreNV");
	printf("glWaitVkSemaphoreNV           : %p\n", p);
	p = gl.OSMesaGetProcAddress("glWeightPathsNV");
	printf("glWeightPathsNV               : %p\n", p);
	p = gl.OSMesaGetProcAddress("glWeightPointerARB");
	printf("glWeightPointerARB            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glWeightbvARB");
	printf("glWeightbvARB                 : %p\n", p);
	p = gl.OSMesaGetProcAddress("glWeightdvARB");
	printf("glWeightdvARB                 : %p\n", p);
	p = gl.OSMesaGetProcAddress("glWeightfvARB");
	printf("glWeightfvARB                 : %p\n", p);
	p = gl.OSMesaGetProcAddress("glWeightivARB");
	printf("glWeightivARB                 : %p\n", p);
	p = gl.OSMesaGetProcAddress("glWeightsvARB");
	printf("glWeightsvARB                 : %p\n", p);
	p = gl.OSMesaGetProcAddress("glWeightubvARB");
	printf("glWeightubvARB                : %p\n", p);
	p = gl.OSMesaGetProcAddress("glWeightuivARB");
	printf("glWeightuivARB                : %p\n", p);
	p = gl.OSMesaGetProcAddress("glWeightusvARB");
	printf("glWeightusvARB                : %p\n", p);
	p = gl.OSMesaGetProcAddress("glWindowPos2d");
	printf("glWindowPos2d                 : %p\n", p);
	p = gl.OSMesaGetProcAddress("glWindowPos2dARB");
	printf("glWindowPos2dARB              : %p\n", p);
	p = gl.OSMesaGetProcAddress("glWindowPos2dMESA");
	printf("glWindowPos2dMESA             : %p\n", p);
	p = gl.OSMesaGetProcAddress("glWindowPos2dv");
	printf("glWindowPos2dv                : %p\n", p);
	p = gl.OSMesaGetProcAddress("glWindowPos2dvARB");
	printf("glWindowPos2dvARB             : %p\n", p);
	p = gl.OSMesaGetProcAddress("glWindowPos2dvMESA");
	printf("glWindowPos2dvMESA            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glWindowPos2f");
	printf("glWindowPos2f                 : %p\n", p);
	p = gl.OSMesaGetProcAddress("glWindowPos2fARB");
	printf("glWindowPos2fARB              : %p\n", p);
	p = gl.OSMesaGetProcAddress("glWindowPos2fMESA");
	printf("glWindowPos2fMESA             : %p\n", p);
	p = gl.OSMesaGetProcAddress("glWindowPos2fv");
	printf("glWindowPos2fv                : %p\n", p);
	p = gl.OSMesaGetProcAddress("glWindowPos2fvARB");
	printf("glWindowPos2fvARB             : %p\n", p);
	p = gl.OSMesaGetProcAddress("glWindowPos2fvMESA");
	printf("glWindowPos2fvMESA            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glWindowPos2i");
	printf("glWindowPos2i                 : %p\n", p);
	p = gl.OSMesaGetProcAddress("glWindowPos2iARB");
	printf("glWindowPos2iARB              : %p\n", p);
	p = gl.OSMesaGetProcAddress("glWindowPos2iMESA");
	printf("glWindowPos2iMESA             : %p\n", p);
	p = gl.OSMesaGetProcAddress("glWindowPos2iv");
	printf("glWindowPos2iv                : %p\n", p);
	p = gl.OSMesaGetProcAddress("glWindowPos2ivARB");
	printf("glWindowPos2ivARB             : %p\n", p);
	p = gl.OSMesaGetProcAddress("glWindowPos2ivMESA");
	printf("glWindowPos2ivMESA            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glWindowPos2s");
	printf("glWindowPos2s                 : %p\n", p);
	p = gl.OSMesaGetProcAddress("glWindowPos2sARB");
	printf("glWindowPos2sARB              : %p\n", p);
	p = gl.OSMesaGetProcAddress("glWindowPos2sMESA");
	printf("glWindowPos2sMESA             : %p\n", p);
	p = gl.OSMesaGetProcAddress("glWindowPos2sv");
	printf("glWindowPos2sv                : %p\n", p);
	p = gl.OSMesaGetProcAddress("glWindowPos2svARB");
	printf("glWindowPos2svARB             : %p\n", p);
	p = gl.OSMesaGetProcAddress("glWindowPos2svMESA");
	printf("glWindowPos2svMESA            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glWindowPos3d");
	printf("glWindowPos3d                 : %p\n", p);
	p = gl.OSMesaGetProcAddress("glWindowPos3dARB");
	printf("glWindowPos3dARB              : %p\n", p);
	p = gl.OSMesaGetProcAddress("glWindowPos3dMESA");
	printf("glWindowPos3dMESA             : %p\n", p);
	p = gl.OSMesaGetProcAddress("glWindowPos3dv");
	printf("glWindowPos3dv                : %p\n", p);
	p = gl.OSMesaGetProcAddress("glWindowPos3dvARB");
	printf("glWindowPos3dvARB             : %p\n", p);
	p = gl.OSMesaGetProcAddress("glWindowPos3dvMESA");
	printf("glWindowPos3dvMESA            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glWindowPos3f");
	printf("glWindowPos3f                 : %p\n", p);
	p = gl.OSMesaGetProcAddress("glWindowPos3fARB");
	printf("glWindowPos3fARB              : %p\n", p);
	p = gl.OSMesaGetProcAddress("glWindowPos3fMESA");
	printf("glWindowPos3fMESA             : %p\n", p);
	p = gl.OSMesaGetProcAddress("glWindowPos3fv");
	printf("glWindowPos3fv                : %p\n", p);
	p = gl.OSMesaGetProcAddress("glWindowPos3fvARB");
	printf("glWindowPos3fvARB             : %p\n", p);
	p = gl.OSMesaGetProcAddress("glWindowPos3fvMESA");
	printf("glWindowPos3fvMESA            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glWindowPos3i");
	printf("glWindowPos3i                 : %p\n", p);
	p = gl.OSMesaGetProcAddress("glWindowPos3iARB");
	printf("glWindowPos3iARB              : %p\n", p);
	p = gl.OSMesaGetProcAddress("glWindowPos3iMESA");
	printf("glWindowPos3iMESA             : %p\n", p);
	p = gl.OSMesaGetProcAddress("glWindowPos3iv");
	printf("glWindowPos3iv                : %p\n", p);
	p = gl.OSMesaGetProcAddress("glWindowPos3ivARB");
	printf("glWindowPos3ivARB             : %p\n", p);
	p = gl.OSMesaGetProcAddress("glWindowPos3ivMESA");
	printf("glWindowPos3ivMESA            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glWindowPos3s");
	printf("glWindowPos3s                 : %p\n", p);
	p = gl.OSMesaGetProcAddress("glWindowPos3sARB");
	printf("glWindowPos3sARB              : %p\n", p);
	p = gl.OSMesaGetProcAddress("glWindowPos3sMESA");
	printf("glWindowPos3sMESA             : %p\n", p);
	p = gl.OSMesaGetProcAddress("glWindowPos3sv");
	printf("glWindowPos3sv                : %p\n", p);
	p = gl.OSMesaGetProcAddress("glWindowPos3svARB");
	printf("glWindowPos3svARB             : %p\n", p);
	p = gl.OSMesaGetProcAddress("glWindowPos3svMESA");
	printf("glWindowPos3svMESA            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glWindowPos4dMESA");
	printf("glWindowPos4dMESA             : %p\n", p);
	p = gl.OSMesaGetProcAddress("glWindowPos4dvMESA");
	printf("glWindowPos4dvMESA            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glWindowPos4fMESA");
	printf("glWindowPos4fMESA             : %p\n", p);
	p = gl.OSMesaGetProcAddress("glWindowPos4fvMESA");
	printf("glWindowPos4fvMESA            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glWindowPos4iMESA");
	printf("glWindowPos4iMESA             : %p\n", p);
	p = gl.OSMesaGetProcAddress("glWindowPos4ivMESA");
	printf("glWindowPos4ivMESA            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glWindowPos4sMESA");
	printf("glWindowPos4sMESA             : %p\n", p);
	p = gl.OSMesaGetProcAddress("glWindowPos4svMESA");
	printf("glWindowPos4svMESA            : %p\n", p);
	p = gl.OSMesaGetProcAddress("glWindowRectanglesEXT");
	printf("glWindowRectanglesEXT         : %p\n", p);
	p = gl.OSMesaGetProcAddress("glWriteMaskEXT");
	printf("glWriteMaskEXT                : %p\n", p);
	p = gl.OSMesaGetProcAddress("gluLookAt");
	printf("gluLookAt                     : %p\n", p);
	p = gl.OSMesaGetProcAddress("gluLookAtf");
	printf("gluLookAtf                    : %p\n", p);
	p = gl.OSMesaGetProcAddress("information");
	printf("information                   : %p\n", p);
	p = gl.OSMesaGetProcAddress("max_height");
	printf("max_height                    : %p\n", p);
	p = gl.OSMesaGetProcAddress("max_width");
	printf("max_width                     : %p\n", p);
	p = gl.OSMesaGetProcAddress("swapbuffer");
	printf("swapbuffer                    : %p\n", p);
	gl.OSMesaDestroyContext(ctx);
	ldg_unload_osmesa(pub, NULL);
	return 0;
}

#endif
