#ifndef MAINFRAME_H
#define MAINFRAME_H


//(*Headers(MainFrame)
#include <wx/sizer.h>
#include <wx/menu.h>
#include <wx/filedlg.h>
#include <wx/frame.h>
#include <wx/html/htmlwin.h>
#include <wx/gauge.h>
//*)

#include "HTMLButton.h"
#include "PlatformDialog.h"
#include "progbob-armswd.h"
#include "progbob-avrisp.h"

class xhex;

class MainFrame: public wxFrame
{
    public:
        MainFrame(wxWindow* parent,wxWindowID id=wxID_ANY);
        virtual ~MainFrame();

        //(*Declarations(MainFrame)
        wxMenu* MenuHelp;
        wxMenuItem* MenuItem5;
        HTMLButton* HtmlWindowFile;
        wxMenuItem* MenuItem1;
        wxFileDialog* FileDialog1;
        wxMenu* Menu1;
        wxMenuItem* MenuItemOpen;
        wxMenuItem* MenuItemExit;
        HTMLButton* HtmlWindowPlatform;
        wxMenu* MenuFile;
        wxHtmlWindow* HtmlWindowLog;
        wxMenuBar* MenuBar1;
        wxGauge* GaugeProgress;
        HTMLButton* HtmlWindowProgram;
        //*)

        PlatformDialog *platformDialog;


        void loadFile(const wxString& name);
        void appendLogLine(const wxString& text, bool replace=false);
        void appendLogError(const wxString& text);
        void appendLogSuccess(const wxString& text);
        void startProgram();
        void doStartProgram();

        void clearLog();
        void program_AVRISP(const wxString & programmerPort, const wxString & devicePart, bool resetOnly);
        void program_ARMSWD(const wxString & programmerPort, const wxString & devicePart, bool resetOnly);
#ifdef AVRDUDE_CONF
        void program_AVRDUDE(const wxString & programmerPort, const wxString & devicePart, bool resetOnly);
#endif
        void updateGUI();

    protected:

        //(*Identifiers(MainFrame)
        static const long ID_HTMLWINDOWFILE;
        static const long ID_HTMLWINDOWPLATFORM;
        static const long ID_HTMLWINDOWPROGRAM;
        static const long ID_HTMLWINDOWLOG;
        static const long ID_GAUGE_PROGRESS;
        static const long ID_MENUITEM_OPEN;
        static const long ID_MENUITEM_RESET_MCU;
        //*)

    private:
        xhex * xhexfile;
        wxString portBackup;
        wxString m_filename;
        wxString m_flashsize;
        wxString m_eepromsize;
        wxString m_fuses;
        wxString m_log_lines;
        wxString m_log_last;
        bool isProgramming;
        ProgBob_ARMSWD * progbob_armswd;
        ProgBob_AVRISP * progbob_avrisp;

        //(*Handlers(MainFrame)
        void OnMenuItemOpenSelected(wxCommandEvent& event);
        void OnMenuItemAboutSelected(wxCommandEvent& event);
        void OnMenuItemExitSelected(wxCommandEvent& event);
        void OnButtonProgramClick(wxCommandEvent& event);
        void OnMenuItemResetMCU(wxCommandEvent& event);
        //*)
        void OnEditPlatform(wxCommandEvent& event);
        
        DECLARE_EVENT_TABLE()
        wxString getFileHTML();
};

#endif
