//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/View/Instrument/InstrumentView.h
//! @brief     Defines class InstrumentView
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifndef BORNAGAIN_GUI_VIEW_INSTRUMENT_INSTRUMENTVIEW_H
#define BORNAGAIN_GUI_VIEW_INSTRUMENT_INSTRUMENTVIEW_H

#include "GUI/Model/Project/ProjectDocument.h" // ProjectDocument::Functionalities
#include <QWidget>

class InstrumentItem;
class InstrumentListView;
class ProjectDocument;
class QCheckBox;
class QLabel;
class QMenu;
class QScrollArea;
class QWidgetAction;

class InstrumentView : public QWidget {
    Q_OBJECT
public:
    InstrumentView(QWidget* parent, ProjectDocument* document);
    void fillViewMenu(QMenu* menu);
    ProjectDocument::Functionalities functionalities() const;

private:
    void showEvent(QShowEvent*) override;
    void hideEvent(QHideEvent*) override;

    void createWidgetsForCurrentInstrument();
    void onInstrumentNameEdited(const QString& newName);
    void onInstrumentdescriptionEdited(const QString& t);
    void onInstrumentChangedByEditor();
    void onInstrumentChangedFromExternal(const InstrumentItem* instrument);
    void onSingleInstrumentModeChanged(bool newState);
    void onFunctionalityChanged();
    void updateSingleInstrumentMode();

    InstrumentListView* m_instrumentListView;
    ProjectDocument* m_document;
    QScrollArea* m_scrollArea;
    QCheckBox* gisasCheck;
    QCheckBox* offspecCheck;
    QCheckBox* specularCheck;
    QCheckBox* depthProbeCheck;
};

#endif // BORNAGAIN_GUI_VIEW_INSTRUMENT_INSTRUMENTVIEW_H
