(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      4809,        179]*)
(*NotebookOutlinePosition[      5719,        210]*)
(*  CellTagsIndexPosition[      5675,        206]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData["General Surface Plotting"], "Title",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[
"This notebook demonstrates functions for plotting surfaces from data. \nThe \
topic is described in more detail in the book:\n\n\tMathematica Graphics: \
Techniques and Applications.\n\tTom Wickham-Jones, TELOS/Springer-Verlag \
1994."], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  "This package is now updated to ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " Version 3.0."
}], "Text"],

Cell[CellGroupData[{

Cell["Installation and Initialization", "Section",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  "The ",
  StyleBox["ExtendGraphics", "Input"],
  " directory should be put in one of the canonical places for AddOns.   Two \
recommended places are first inside the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " distribution in:"
}], "Text"],

Cell[BoxData[
    \(ToFileName[\ {$TopDirectory, \ "\<AddOns\>", \ "\<Applications\>"}]\)], 
  "Input"],

Cell["a second in the preferences directory:", "Text"],

Cell[BoxData[
    \(ToFileName[
      \ {$PreferencesDirectory, \ "\<AddOns\>", \ "\<Applications\>"}]\)], 
  "Input"],

Cell[TextData[{
  "When one of these locations is used there is no need to set $Path and the \
loading instructions are identical for all versions of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "."
}], "Text"],

Cell[TextData[{
  "The ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " binary delaunay.exe is provided for the Windows95 and Macintosh versions. \
 For other versions it should be built with the mcc tools that are provided."
}], "Text"],

Cell[TextData[{
  "The  ",
  StyleBox["ExtendGraphics`SurfaceGraphics3D` ", "Input"],
  "package can  be loaded"
}], "Text"],

Cell["Needs[ \"ExtendGraphics`SurfaceGraphics3D`\"]", "Input",
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["Turn off spelling checker", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["\<\
Off[ General::spell];
Off[ General::spell1];
\
\>", "Input",
  AspectRatioFixed->True]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["General Surface Plotting"], "Section",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData["Some data is generated."], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["\<\
data =
  Table[
    Table[{r Sin[t], r Cos[t], 
\t                 Cos[2t] BesselJ[1, 7 r]},
          {t, 0, 2Pi-2Pi/( 10 r),2Pi/ (10 r)}],
      {r,5}];
      
data = Flatten[data, 1];\
\>", "Input",
  AspectRatioFixed->True],

Cell[TextData["The data is plotted."], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["surf = ListSurfacePlot3D[data];", "Input",
  AspectRatioFixed->True],

Cell[TextData["The surface is colored with a ColorFunction."], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["\<\
Show[surf, 
    MeshStyle -> GrayLevel[0.25],
    ColorFunction -> Hue];\
\>", "Input",
  AspectRatioFixed->True]
}, Closed]]
}, Open  ]]
},
FrontEndVersion->"Microsoft Windows 3.0",
ScreenRectangle->{{0, 800}, {0, 544}},
WindowToolbars->{},
CellGrouping->Automatic,
WindowSize->{496, 436},
WindowMargins->{{80, Automatic}, {Automatic, 5}},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, 128}},
ShowCellLabel->True,
ShowCellTags->False,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False},
CharacterEncoding->"NeXTAutomaticEncoding"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1731, 51, 99, 2, 105, "Title"],
Cell[1833, 55, 309, 6, 109, "Text"],
Cell[2145, 63, 134, 5, 33, "Text"],

Cell[CellGroupData[{
Cell[2304, 72, 98, 2, 53, "Section"],
Cell[2405, 76, 272, 8, 53, "Text"],
Cell[2680, 86, 103, 2, 30, "Input"],
Cell[2786, 90, 54, 0, 33, "Text"],
Cell[2843, 92, 118, 3, 50, "Input"],
Cell[2964, 97, 222, 6, 52, "Text"],
Cell[3189, 105, 244, 6, 52, "Text"],
Cell[3436, 113, 124, 4, 34, "Text"],
Cell[3563, 119, 88, 1, 30, "Input"],

Cell[CellGroupData[{
Cell[3676, 124, 95, 2, 47, "Subsection"],
Cell[3774, 128, 96, 5, 66, "Input"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[3919, 139, 101, 2, 33, "Section"],
Cell[4023, 143, 97, 2, 33, "Text"],
Cell[4123, 147, 237, 10, 156, "Input"],
Cell[4363, 159, 94, 2, 33, "Text"],
Cell[4460, 163, 74, 1, 30, "Input"],
Cell[4537, 166, 118, 2, 33, "Text"],
Cell[4658, 170, 123, 5, 66, "Input"]
}, Closed]]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

