#
# Copyright 2022 Centreon (http://www.centreon.com/)
#
# Centreon is a full-fledged industry-strength solution that meets
# the needs in IT infrastructure and application monitoring for
# service performance.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

package network::barracuda::bma::snmp::mode::storage;

use base qw(centreon::plugins::templates::counter);

use strict;
use warnings;

sub prefix_global_output {
    my ($self, %options) = @_;

    return 'Storage space ';
}

sub set_counters {
    my ($self, %options) = @_;
    
    $self->{maps_counters_type} = [
        { name => 'global', type => 0, cb_prefix_output => 'prefix_global_output', skipped_code => { -10 => 1 } }
    ];

    $self->{maps_counters}->{global} = [
        { label => 'firmware-space', nlabel => 'storage.firmware.space.usage.percentage', set => {
                key_values => [ { name => 'firmware_used' } ],
                output_template => 'firmware used: %.2f%%',
                perfdatas => [
                    { template => '%.2f', min => 0, max => 100, unit => '%' }
                ]
            }
        },
        { label => 'maillog-space', nlabel => 'storage.maillog.space.usage.percentage', set => {
                key_values => [ { name => 'maillog_used' } ],
                output_template => 'mail and logs used: %.2f%%',
                perfdatas => [
                    { template => '%.2f', min => 0, max => 100, unit => '%' }
                ]
            }
        }
    ];
}


sub new {
    my ($class, %options) = @_;
    my $self = $class->SUPER::new(package => __PACKAGE__, %options, force_new_perfdata => 1);
    bless $self, $class;
    
    $options{options}->add_options(arguments => {});

    return $self;
}

sub manage_selection {
    my ($self, %options) = @_;

    my $oid_firmware = '.1.3.6.1.4.1.20632.6.6.5'; # firmwareStorage
    my $oid_maillog = '.1.3.6.1.4.1.20632.6.6.6'; # mailLogStorage
    my $snmp_result = $options{snmp}->get_leef(
        oids => [$oid_firmware, $oid_maillog],
        nothing_quit => 1
    );

    $self->{global} = {
        firmware_used => $snmp_result->{$oid_firmware},
        maillog_used => $snmp_result->{$oid_maillog}
    };
}

1;

__END__

=head1 MODE

Check storage usage.

=over 8

=item B<--warning-*> B<--critical-*>

Thresholds.
Can be: 'firmware-space', 'maillog-space'.

=back

=cut
