/* Generated from library.scm by the CHICKEN compiler
   http://www.call-cc.org
   Version 5.2.0 (rev 317468e4)
   linux-unix-gnu-x86-64 [ 64bit dload ptables ]
   command line: library.scm -optimize-level 2 -include-path . -include-path ./ -inline -ignore-repository -feature chicken-bootstrap -no-warnings -specialize -consult-types-file ./types.db -explicit-use -no-trace -output-file library.c -no-module-registration -emit-import-library chicken.bitwise -emit-import-library chicken.blob -emit-import-library chicken.fixnum -emit-import-library chicken.flonum -emit-import-library chicken.gc -emit-import-library chicken.keyword -emit-import-library chicken.platform -emit-import-library chicken.plist -emit-import-library chicken.process-context
   unit: library
   uses: build-version
*/
#include "chicken.h"

#include <errno.h>
#include <float.h>

#ifdef HAVE_SYSEXITS_H
# include <sysexits.h>
#endif

#ifndef EX_SOFTWARE
# define EX_SOFTWARE	70
#endif

#define C_close_file(p)	      (C_fclose((C_FILEPTR)(C_port_file(p))), C_SCHEME_UNDEFINED)
#define C_a_f64peek(ptr, c, b, i)  C_flonum(ptr, ((double *)C_data_pointer(b))[ C_unfix(i) ])
#define C_fetch_c_strlen(b, i) C_fix(strlen((C_char *)C_block_item(b, C_unfix(i))))
#define C_asciiz_strlen(str) C_fix(strlen(C_c_string(str)))
#define C_peek_c_string(b, i, to, len) (C_memcpy(C_data_pointer(to), (C_char *)C_block_item(b, C_unfix(i)), C_unfix(len)), C_SCHEME_UNDEFINED)
#define C_free_mptr(p, i)     (C_free((void *)C_block_item(p, C_unfix(i))), C_SCHEME_UNDEFINED)
#define C_free_sptr(p, i)     (C_free((void *)(((C_char **)C_block_item(p, 0))[ C_unfix(i) ])), C_SCHEME_UNDEFINED)

#define C_a_get_current_seconds(ptr, c, dummy)  C_int64_to_num(ptr, time(NULL))
#define C_peek_c_string_at(ptr, i)    ((C_char *)(((C_char **)ptr)[ i ]))

static C_word
fast_read_line_from_file(C_word str, C_word port, C_word size) {
  int n = C_unfix(size);
  int i;
  int c;
  char *buf = C_c_string(str);
  C_FILEPTR fp = C_port_file(port);

  if ((c = C_getc(fp)) == EOF) {
    if (ferror(fp)) {
      clearerr(fp);
      return C_fix(-1);
    } else { /* feof (fp) */
      return C_SCHEME_END_OF_FILE;
    }
  }

  C_ungetc(c, fp);

  for (i = 0; i < n; i++) {
    c = C_getc(fp);

    if(c == EOF && ferror(fp)) {
      clearerr(fp);
      return C_fix(-(i + 1));
    }

    switch (c) {
    case '\r':	if ((c = C_getc(fp)) != '\n') C_ungetc(c, fp);
    case EOF:	clearerr(fp);
    case '\n':	return C_fix(i);
    }
    buf[i] = c;
  }
  return C_SCHEME_FALSE;
}

static C_word
fast_read_string_from_file(C_word dest, C_word port, C_word len, C_word pos)
{
  size_t m;
  int n = C_unfix (len);
  char * buf = ((char *)C_data_pointer (dest) + C_unfix (pos));
  C_FILEPTR fp = C_port_file (port);

  if(feof(fp)) return C_SCHEME_END_OF_FILE;

  m = fread (buf, sizeof (char), n, fp);

  if (m < n) {
    if (ferror(fp)) /* Report to Scheme, which may retry, so clear errors */
      clearerr(fp);
    else if (feof(fp) && 0 == m) /* eof but m > 0? Return data first, below */
      return C_SCHEME_END_OF_FILE; /* Calling again will get us here */
  }

  return C_fix (m);
}

static C_word
shallow_equal(C_word x, C_word y)
{
  /* assumes x and y are non-immediate */
  int i, len = C_header_size(x);

  if(C_header_size(y) != len) return C_SCHEME_FALSE;      
  else return C_mk_bool(!C_memcmp((void *)x, (void *)y, len * sizeof(C_word)));
}

static C_word
signal_debug_event(C_word mode, C_word msg, C_word args)
{
  C_DEBUG_INFO cell;
  C_word av[ 3 ];
  cell.enabled = 1;
  cell.event = C_DEBUG_SIGNAL;
  cell.loc = "";
  cell.val = "";
  av[ 0 ] = mode;
  av[ 1 ] = msg;
  av[ 2 ] = args;
  C_debugger(&cell, 3, av);
  return C_SCHEME_UNDEFINED;
}

#ifdef NO_DLOAD2
# define HAVE_DLOAD 0
#else
# define HAVE_DLOAD 1
#endif

#ifdef C_ENABLE_PTABLES
# define HAVE_PTABLES 1
#else
# define HAVE_PTABLES 0
#endif

#ifdef C_GC_HOOKS
# define HAVE_GCHOOKS 1
#else
# define HAVE_GCHOOKS 0
#endif

#if defined(C_CROSS_CHICKEN) && C_CROSS_CHICKEN
# define IS_CROSS_CHICKEN 1
#else
# define IS_CROSS_CHICKEN 0
#endif


#define C_chdir(str) C_fix(chdir(C_c_string(str)))
#define C_curdir(buf) (getcwd(C_c_string(buf), 1024) ? C_fix(strlen(C_c_string(buf))) : C_SCHEME_FALSE)
#define C_getenventry(i) (environ[ i ])

#ifdef HAVE_CRT_EXTERNS_H
# include <crt_externs.h>
# define environ (*_NSGetEnviron())
#else
extern char **environ;
#endif

#ifdef HAVE_SETENV
# define C_unsetenv(s)    (unsetenv((char *)C_data_pointer(s)), C_SCHEME_TRUE)
# define C_setenv(x, y)   C_fix(setenv((char *)C_data_pointer(x), (char *)C_data_pointer(y), 1))
#else
# if defined(_WIN32) && !defined(__CYGWIN__)
#  define C_unsetenv(s)   C_setenv(s, C_SCHEME_FALSE)
# else
#  define C_unsetenv(s)   C_fix(putenv((char *)C_data_pointer(s)))
# endif
static C_word C_fcall C_setenv(C_word x, C_word y) {
  char *sx = C_c_string(x),
       *sy = (y == C_SCHEME_FALSE ? "" : C_c_string(y));
  int n1 = C_strlen(sx), n2 = C_strlen(sy);
  int buf_len = n1 + n2 + 2;
  char *buf = (char *)C_malloc(buf_len);
  if(buf == NULL) return(C_fix(0));
  else {
    C_strlcpy(buf, sx, buf_len);
    C_strlcat(buf, "=", buf_len);
    C_strlcat(buf, sy, buf_len);
    return(C_fix(putenv(buf)));
  }
}
#endif



static C_PTABLE_ENTRY *create_ptable(void);
C_noret_decl(C_build_2dversion_toplevel)
C_externimport void C_ccall C_build_2dversion_toplevel(C_word c,C_word *av) C_noret;

static C_TLS C_word lf[1404];
static double C_possibly_force_alignment;
static C_char C_TLS li0[] C_aligned={C_lihdr(0,0,14),40,115,99,104,101,109,101,35,110,111,116,32,120,41,0,0};
static C_char C_TLS li1[] C_aligned={C_lihdr(0,0,19),40,115,99,104,101,109,101,35,98,111,111,108,101,97,110,63,32,120,41,0,0,0,0,0};
static C_char C_TLS li2[] C_aligned={C_lihdr(0,0,16),40,115,99,104,101,109,101,35,101,113,63,32,120,32,121,41};
static C_char C_TLS li3[] C_aligned={C_lihdr(0,0,17),40,115,99,104,101,109,101,35,101,113,118,63,32,120,32,121,41,0,0,0,0,0,0,0};
static C_char C_TLS li4[] C_aligned={C_lihdr(0,0,19),40,115,99,104,101,109,101,35,101,113,117,97,108,63,32,120,32,121,41,0,0,0,0,0};
static C_char C_TLS li5[] C_aligned={C_lihdr(0,0,16),40,115,99,104,101,109,101,35,112,97,105,114,63,32,120,41};
static C_char C_TLS li6[] C_aligned={C_lihdr(0,0,17),40,115,99,104,101,109,101,35,99,111,110,115,32,120,32,121,41,0,0,0,0,0,0,0};
static C_char C_TLS li7[] C_aligned={C_lihdr(0,0,14),40,115,99,104,101,109,101,35,99,97,114,32,120,41,0,0};
static C_char C_TLS li8[] C_aligned={C_lihdr(0,0,14),40,115,99,104,101,109,101,35,99,100,114,32,120,41,0,0};
static C_char C_TLS li9[] C_aligned={C_lihdr(0,0,21),40,115,99,104,101,109,101,35,115,101,116,45,99,97,114,33,32,120,32,121,41,0,0,0};
static C_char C_TLS li10[] C_aligned={C_lihdr(0,0,21),40,115,99,104,101,109,101,35,115,101,116,45,99,100,114,33,32,120,32,121,41,0,0,0};
static C_char C_TLS li11[] C_aligned={C_lihdr(0,0,15),40,115,99,104,101,109,101,35,99,97,100,114,32,120,41,0};
static C_char C_TLS li12[] C_aligned={C_lihdr(0,0,16),40,115,99,104,101,109,101,35,99,97,100,100,114,32,120,41};
static C_char C_TLS li13[] C_aligned={C_lihdr(0,0,17),40,115,99,104,101,109,101,35,99,97,100,100,100,114,32,120,41,0,0,0,0,0,0,0};
static C_char C_TLS li14[] C_aligned={C_lihdr(0,0,17),40,115,99,104,101,109,101,35,99,100,100,100,100,114,32,120,41,0,0,0,0,0,0,0};
static C_char C_TLS li15[] C_aligned={C_lihdr(0,0,15),40,115,99,104,101,109,101,35,99,97,97,114,32,120,41,0};
static C_char C_TLS li16[] C_aligned={C_lihdr(0,0,15),40,115,99,104,101,109,101,35,99,100,97,114,32,120,41,0};
static C_char C_TLS li17[] C_aligned={C_lihdr(0,0,15),40,115,99,104,101,109,101,35,99,100,100,114,32,120,41,0};
static C_char C_TLS li18[] C_aligned={C_lihdr(0,0,16),40,115,99,104,101,109,101,35,99,97,97,97,114,32,120,41};
static C_char C_TLS li19[] C_aligned={C_lihdr(0,0,16),40,115,99,104,101,109,101,35,99,97,97,100,114,32,120,41};
static C_char C_TLS li20[] C_aligned={C_lihdr(0,0,16),40,115,99,104,101,109,101,35,99,97,100,97,114,32,120,41};
static C_char C_TLS li21[] C_aligned={C_lihdr(0,0,16),40,115,99,104,101,109,101,35,99,100,97,97,114,32,120,41};
static C_char C_TLS li22[] C_aligned={C_lihdr(0,0,16),40,115,99,104,101,109,101,35,99,100,97,100,114,32,120,41};
static C_char C_TLS li23[] C_aligned={C_lihdr(0,0,16),40,115,99,104,101,109,101,35,99,100,100,97,114,32,120,41};
static C_char C_TLS li24[] C_aligned={C_lihdr(0,0,16),40,115,99,104,101,109,101,35,99,100,100,100,114,32,120,41};
static C_char C_TLS li25[] C_aligned={C_lihdr(0,0,17),40,115,99,104,101,109,101,35,99,97,97,97,97,114,32,120,41,0,0,0,0,0,0,0};
static C_char C_TLS li26[] C_aligned={C_lihdr(0,0,17),40,115,99,104,101,109,101,35,99,97,97,97,100,114,32,120,41,0,0,0,0,0,0,0};
static C_char C_TLS li27[] C_aligned={C_lihdr(0,0,17),40,115,99,104,101,109,101,35,99,97,97,100,97,114,32,120,41,0,0,0,0,0,0,0};
static C_char C_TLS li28[] C_aligned={C_lihdr(0,0,17),40,115,99,104,101,109,101,35,99,97,97,100,100,114,32,120,41,0,0,0,0,0,0,0};
static C_char C_TLS li29[] C_aligned={C_lihdr(0,0,17),40,115,99,104,101,109,101,35,99,97,100,97,97,114,32,120,41,0,0,0,0,0,0,0};
static C_char C_TLS li30[] C_aligned={C_lihdr(0,0,17),40,115,99,104,101,109,101,35,99,97,100,97,100,114,32,120,41,0,0,0,0,0,0,0};
static C_char C_TLS li31[] C_aligned={C_lihdr(0,0,17),40,115,99,104,101,109,101,35,99,97,100,100,97,114,32,120,41,0,0,0,0,0,0,0};
static C_char C_TLS li32[] C_aligned={C_lihdr(0,0,17),40,115,99,104,101,109,101,35,99,100,97,97,97,114,32,120,41,0,0,0,0,0,0,0};
static C_char C_TLS li33[] C_aligned={C_lihdr(0,0,17),40,115,99,104,101,109,101,35,99,100,97,97,100,114,32,120,41,0,0,0,0,0,0,0};
static C_char C_TLS li34[] C_aligned={C_lihdr(0,0,17),40,115,99,104,101,109,101,35,99,100,97,100,97,114,32,120,41,0,0,0,0,0,0,0};
static C_char C_TLS li35[] C_aligned={C_lihdr(0,0,17),40,115,99,104,101,109,101,35,99,100,97,100,100,114,32,120,41,0,0,0,0,0,0,0};
static C_char C_TLS li36[] C_aligned={C_lihdr(0,0,17),40,115,99,104,101,109,101,35,99,100,100,97,97,114,32,120,41,0,0,0,0,0,0,0};
static C_char C_TLS li37[] C_aligned={C_lihdr(0,0,17),40,115,99,104,101,109,101,35,99,100,100,97,100,114,32,120,41,0,0,0,0,0,0,0};
static C_char C_TLS li38[] C_aligned={C_lihdr(0,0,17),40,115,99,104,101,109,101,35,99,100,100,100,97,114,32,120,41,0,0,0,0,0,0,0};
static C_char C_TLS li39[] C_aligned={C_lihdr(0,0,16),40,115,99,104,101,109,101,35,110,117,108,108,63,32,120,41};
static C_char C_TLS li40[] C_aligned={C_lihdr(0,0,19),40,115,99,104,101,109,101,35,108,105,115,116,32,46,32,108,115,116,41,0,0,0,0,0};
static C_char C_TLS li41[] C_aligned={C_lihdr(0,0,19),40,115,99,104,101,109,101,35,108,101,110,103,116,104,32,108,115,116,41,0,0,0,0,0};
static C_char C_TLS li42[] C_aligned={C_lihdr(0,0,24),40,115,99,104,101,109,101,35,108,105,115,116,45,116,97,105,108,32,108,115,116,32,105,41};
static C_char C_TLS li43[] C_aligned={C_lihdr(0,0,23),40,115,99,104,101,109,101,35,108,105,115,116,45,114,101,102,32,108,115,116,32,105,41,0};
static C_char C_TLS li44[] C_aligned={C_lihdr(0,0,15),40,108,111,111,112,32,108,115,116,32,114,101,115,116,41,0};
static C_char C_TLS li45[] C_aligned={C_lihdr(0,0,21),40,115,99,104,101,109,101,35,114,101,118,101,114,115,101,32,108,115,116,48,41,0,0,0};
static C_char C_TLS li46[] C_aligned={C_lihdr(0,0,19),40,115,99,104,101,109,101,35,109,101,109,113,32,120,32,108,115,116,41,0,0,0,0,0};
static C_char C_TLS li47[] C_aligned={C_lihdr(0,0,19),40,115,99,104,101,109,101,35,109,101,109,118,32,120,32,108,115,116,41,0,0,0,0,0};
static C_char C_TLS li48[] C_aligned={C_lihdr(0,0,21),40,115,99,104,101,109,101,35,109,101,109,98,101,114,32,120,32,108,115,116,41,0,0,0};
static C_char C_TLS li49[] C_aligned={C_lihdr(0,0,19),40,115,99,104,101,109,101,35,97,115,115,113,32,120,32,108,115,116,41,0,0,0,0,0};
static C_char C_TLS li50[] C_aligned={C_lihdr(0,0,19),40,115,99,104,101,109,101,35,97,115,115,118,32,120,32,108,115,116,41,0,0,0,0,0};
static C_char C_TLS li51[] C_aligned={C_lihdr(0,0,20),40,115,99,104,101,109,101,35,97,115,115,111,99,32,120,32,108,115,116,41,0,0,0,0};
static C_char C_TLS li52[] C_aligned={C_lihdr(0,0,16),40,115,99,104,101,109,101,35,108,105,115,116,63,32,120,41};
static C_char C_TLS li53[] C_aligned={C_lihdr(0,0,18),40,115,99,104,101,109,101,35,115,116,114,105,110,103,63,32,120,41,0,0,0,0,0,0};
static C_char C_TLS li54[] C_aligned={C_lihdr(0,0,24),40,115,99,104,101,109,101,35,115,116,114,105,110,103,45,108,101,110,103,116,104,32,115,41};
static C_char C_TLS li55[] C_aligned={C_lihdr(0,0,23),40,115,99,104,101,109,101,35,115,116,114,105,110,103,45,114,101,102,32,115,32,105,41,0};
static C_char C_TLS li56[] C_aligned={C_lihdr(0,0,26),40,115,99,104,101,109,101,35,115,116,114,105,110,103,45,115,101,116,33,32,115,32,105,32,99,41,0,0,0,0,0,0};
static C_char C_TLS li57[] C_aligned={C_lihdr(0,0,21),40,115,99,104,101,109,101,35,115,116,114,105,110,103,61,63,32,120,32,121,41,0,0,0};
static C_char C_TLS li58[] C_aligned={C_lihdr(0,0,24),40,115,99,104,101,109,101,35,115,116,114,105,110,103,45,99,105,61,63,32,120,32,121,41};
static C_char C_TLS li59[] C_aligned={C_lihdr(0,0,25),40,115,99,104,101,109,101,35,101,120,97,99,116,45,62,105,110,101,120,97,99,116,32,120,41,0,0,0,0,0,0,0};
static C_char C_TLS li60[] C_aligned={C_lihdr(0,0,14),40,115,99,104,101,109,101,35,97,98,115,32,120,41,0,0};
static C_char C_TLS li61[] C_aligned={C_lihdr(0,0,6),67,95,112,108,117,115,0,0};
static C_char C_TLS li62[] C_aligned={C_lihdr(0,0,7),67,95,109,105,110,117,115,0};
static C_char C_TLS li63[] C_aligned={C_lihdr(0,0,7),67,95,116,105,109,101,115,0};
static C_char C_TLS li64[] C_aligned={C_lihdr(0,0,21),40,115,99,104,101,109,101,35,113,117,111,116,105,101,110,116,32,97,32,98,41,0,0,0};
static C_char C_TLS li65[] C_aligned={C_lihdr(0,0,22),40,115,99,104,101,109,101,35,114,101,109,97,105,110,100,101,114,32,97,32,98,41,0,0};
static C_char C_TLS li66[] C_aligned={C_lihdr(0,0,19),40,115,99,104,101,109,101,35,109,111,100,117,108,111,32,97,32,98,41,0,0,0,0,0};
static C_char C_TLS li67[] C_aligned={C_lihdr(0,0,16),40,115,99,104,101,109,101,35,101,118,101,110,63,32,110,41};
static C_char C_TLS li68[] C_aligned={C_lihdr(0,0,15),40,115,99,104,101,109,101,35,111,100,100,63,32,110,41,0};
static C_char C_TLS li69[] C_aligned={C_lihdr(0,0,9),67,95,110,101,113,117,97,108,112,0,0,0,0,0,0,0};
static C_char C_TLS li70[] C_aligned={C_lihdr(0,0,10),67,95,103,114,101,97,116,101,114,112,0,0,0,0,0,0};
static C_char C_TLS li71[] C_aligned={C_lihdr(0,0,7),67,95,108,101,115,115,112,0};
static C_char C_TLS li72[] C_aligned={C_lihdr(0,0,20),67,95,103,114,101,97,116,101,114,95,111,114,95,101,113,117,97,108,95,112,0,0,0,0};
static C_char C_TLS li73[] C_aligned={C_lihdr(0,0,17),67,95,108,101,115,115,95,111,114,95,101,113,117,97,108,95,112,0,0,0,0,0,0,0};
static C_char C_TLS li74[] C_aligned={C_lihdr(0,0,18),40,115,99,104,101,109,101,35,110,117,109,98,101,114,63,32,120,41,0,0,0,0,0,0};
static C_char C_TLS li75[] C_aligned={C_lihdr(0,0,16),40,115,99,104,101,109,101,35,114,101,97,108,63,32,120,41};
static C_char C_TLS li76[] C_aligned={C_lihdr(0,0,20),40,115,99,104,101,109,101,35,114,97,116,105,111,110,97,108,63,32,110,41,0,0,0,0};
static C_char C_TLS li77[] C_aligned={C_lihdr(0,0,19),40,115,99,104,101,109,101,35,105,110,116,101,103,101,114,63,32,120,41,0,0,0,0,0};
static C_char C_TLS li78[] C_aligned={C_lihdr(0,0,17),40,115,99,104,101,109,101,35,101,120,97,99,116,63,32,120,41,0,0,0,0,0,0,0};
static C_char C_TLS li79[] C_aligned={C_lihdr(0,0,19),40,115,99,104,101,109,101,35,105,110,101,120,97,99,116,63,32,120,41,0,0,0,0,0};
static C_char C_TLS li80[] C_aligned={C_lihdr(0,0,16),40,115,99,104,101,109,101,35,122,101,114,111,63,32,110,41};
static C_char C_TLS li81[] C_aligned={C_lihdr(0,0,20),40,115,99,104,101,109,101,35,112,111,115,105,116,105,118,101,63,32,110,41,0,0,0,0};
static C_char C_TLS li82[] C_aligned={C_lihdr(0,0,20),40,115,99,104,101,109,101,35,110,101,103,97,116,105,118,101,63,32,110,41,0,0,0,0};
static C_char C_TLS li83[] C_aligned={C_lihdr(0,0,18),67,95,110,117,109,98,101,114,95,116,111,95,115,116,114,105,110,103,0,0,0,0,0,0};
static C_char C_TLS li84[] C_aligned={C_lihdr(0,0,18),40,115,99,104,101,109,101,35,115,121,109,98,111,108,63,32,120,41,0,0,0,0,0,0};
static C_char C_TLS li85[] C_aligned={C_lihdr(0,0,18),40,115,99,104,101,109,101,35,118,101,99,116,111,114,63,32,120,41,0,0,0,0,0,0};
static C_char C_TLS li86[] C_aligned={C_lihdr(0,0,24),40,115,99,104,101,109,101,35,118,101,99,116,111,114,45,108,101,110,103,116,104,32,118,41};
static C_char C_TLS li87[] C_aligned={C_lihdr(0,0,23),40,115,99,104,101,109,101,35,118,101,99,116,111,114,45,114,101,102,32,118,32,105,41,0};
static C_char C_TLS li88[] C_aligned={C_lihdr(0,0,26),40,115,99,104,101,109,101,35,118,101,99,116,111,114,45,115,101,116,33,32,118,32,105,32,120,41,0,0,0,0,0,0};
static C_char C_TLS li89[] C_aligned={C_lihdr(0,0,16),40,115,99,104,101,109,101,35,99,104,97,114,63,32,120,41};
static C_char C_TLS li90[] C_aligned={C_lihdr(0,0,24),40,115,99,104,101,109,101,35,99,104,97,114,45,62,105,110,116,101,103,101,114,32,99,41};
static C_char C_TLS li91[] C_aligned={C_lihdr(0,0,24),40,115,99,104,101,109,101,35,105,110,116,101,103,101,114,45,62,99,104,97,114,32,110,41};
static C_char C_TLS li92[] C_aligned={C_lihdr(0,0,21),40,115,99,104,101,109,101,35,99,104,97,114,61,63,32,99,49,32,99,50,41,0,0,0};
static C_char C_TLS li93[] C_aligned={C_lihdr(0,0,21),40,115,99,104,101,109,101,35,99,104,97,114,62,63,32,99,49,32,99,50,41,0,0,0};
static C_char C_TLS li94[] C_aligned={C_lihdr(0,0,21),40,115,99,104,101,109,101,35,99,104,97,114,60,63,32,99,49,32,99,50,41,0,0,0};
static C_char C_TLS li95[] C_aligned={C_lihdr(0,0,22),40,115,99,104,101,109,101,35,99,104,97,114,62,61,63,32,99,49,32,99,50,41,0,0};
static C_char C_TLS li96[] C_aligned={C_lihdr(0,0,22),40,115,99,104,101,109,101,35,99,104,97,114,60,61,63,32,99,49,32,99,50,41,0,0};
static C_char C_TLS li97[] C_aligned={C_lihdr(0,0,22),40,115,99,104,101,109,101,35,99,104,97,114,45,117,112,99,97,115,101,32,99,41,0,0};
static C_char C_TLS li98[] C_aligned={C_lihdr(0,0,24),40,115,99,104,101,109,101,35,99,104,97,114,45,100,111,119,110,99,97,115,101,32,99,41};
static C_char C_TLS li99[] C_aligned={C_lihdr(0,0,27),40,115,99,104,101,109,101,35,99,104,97,114,45,117,112,112,101,114,45,99,97,115,101,63,32,99,41,0,0,0,0,0};
static C_char C_TLS li100[] C_aligned={C_lihdr(0,0,27),40,115,99,104,101,109,101,35,99,104,97,114,45,108,111,119,101,114,45,99,97,115,101,63,32,99,41,0,0,0,0,0};
static C_char C_TLS li101[] C_aligned={C_lihdr(0,0,24),40,115,99,104,101,109,101,35,99,104,97,114,45,110,117,109,101,114,105,99,63,32,99,41};
static C_char C_TLS li102[] C_aligned={C_lihdr(0,0,27),40,115,99,104,101,109,101,35,99,104,97,114,45,119,104,105,116,101,115,112,97,99,101,63,32,99,41,0,0,0,0,0};
static C_char C_TLS li103[] C_aligned={C_lihdr(0,0,27),40,115,99,104,101,109,101,35,99,104,97,114,45,97,108,112,104,97,98,101,116,105,99,63,32,99,41,0,0,0,0,0};
static C_char C_TLS li104[] C_aligned={C_lihdr(0,0,21),40,115,99,104,101,109,101,35,112,114,111,99,101,100,117,114,101,63,32,120,41,0,0,0};
static C_char C_TLS li105[] C_aligned={C_lihdr(0,0,7),67,95,97,112,112,108,121,0};
static C_char C_TLS li106[] C_aligned={C_lihdr(0,0,8),67,95,118,97,108,117,101,115};
static C_char C_TLS li107[] C_aligned={C_lihdr(0,0,18),67,95,99,97,108,108,95,119,105,116,104,95,118,97,108,117,101,115,0,0,0,0,0,0};
static C_char C_TLS li108[] C_aligned={C_lihdr(0,0,22),40,115,99,104,101,109,101,35,105,110,112,117,116,45,112,111,114,116,63,32,120,41,0,0};
static C_char C_TLS li109[] C_aligned={C_lihdr(0,0,23),40,115,99,104,101,109,101,35,111,117,116,112,117,116,45,112,111,114,116,63,32,120,41,0};
static C_char C_TLS li110[] C_aligned={C_lihdr(0,0,22),40,115,99,104,101,109,101,35,101,111,102,45,111,98,106,101,99,116,63,32,120,41,0,0};
static C_char C_TLS li111[] C_aligned={C_lihdr(0,0,21),40,115,99,104,101,109,101,35,101,118,97,108,32,120,32,46,32,101,110,118,41,0,0,0};
static C_char C_TLS li112[] C_aligned={C_lihdr(0,0,32),40,115,99,104,101,109,101,35,105,110,116,101,114,97,99,116,105,111,110,45,101,110,118,105,114,111,110,109,101,110,116,41};
static C_char C_TLS li113[] C_aligned={C_lihdr(0,0,36),40,115,99,104,101,109,101,35,115,99,104,101,109,101,45,114,101,112,111,114,116,45,101,110,118,105,114,111,110,109,101,110,116,32,110,41,0,0,0,0};
static C_char C_TLS li114[] C_aligned={C_lihdr(0,0,25),40,115,99,104,101,109,101,35,110,117,108,108,45,101,110,118,105,114,111,110,109,101,110,116,41,0,0,0,0,0,0,0};
static C_char C_TLS li115[] C_aligned={C_lihdr(0,0,34),40,115,99,104,101,109,101,35,108,111,97,100,32,102,105,108,101,110,97,109,101,32,46,32,101,118,97,108,117,97,116,111,114,41,0,0,0,0,0,0};
static C_char C_TLS li116[] C_aligned={C_lihdr(0,0,24),40,99,104,105,99,107,101,110,46,98,97,115,101,35,102,105,120,110,117,109,63,32,120,41};
static C_char C_TLS li117[] C_aligned={C_lihdr(0,0,24),40,99,104,105,99,107,101,110,46,98,97,115,101,35,102,108,111,110,117,109,63,32,120,41};
static C_char C_TLS li118[] C_aligned={C_lihdr(0,0,24),40,99,104,105,99,107,101,110,46,98,97,115,101,35,98,105,103,110,117,109,63,32,120,41};
static C_char C_TLS li119[] C_aligned={C_lihdr(0,0,24),40,99,104,105,99,107,101,110,46,98,97,115,101,35,114,97,116,110,117,109,63,32,120,41};
static C_char C_TLS li120[] C_aligned={C_lihdr(0,0,25),40,99,104,105,99,107,101,110,46,98,97,115,101,35,99,112,108,120,110,117,109,63,32,120,41,0,0,0,0,0,0,0};
static C_char C_TLS li121[] C_aligned={C_lihdr(0,0,31),40,99,104,105,99,107,101,110,46,98,97,115,101,35,101,120,97,99,116,45,105,110,116,101,103,101,114,63,32,120,41,0};
static C_char C_TLS li122[] C_aligned={C_lihdr(0,0,24),67,95,113,117,111,116,105,101,110,116,95,97,110,100,95,114,101,109,97,105,110,100,101,114};
static C_char C_TLS li123[] C_aligned={C_lihdr(0,0,7),40,97,57,49,57,50,41,0};
static C_char C_TLS li124[] C_aligned={C_lihdr(0,0,15),40,97,57,49,57,56,32,100,105,118,32,114,101,109,41,0};
static C_char C_TLS li125[] C_aligned={C_lihdr(0,0,34),40,99,104,105,99,107,101,110,46,98,97,115,101,35,113,117,111,116,105,101,110,116,38,109,111,100,117,108,111,32,120,32,121,41,0,0,0,0,0,0};
static C_char C_TLS li126[] C_aligned={C_lihdr(0,0,24),40,99,104,105,99,107,101,110,46,98,97,115,101,35,102,105,110,105,116,101,63,32,120,41};
static C_char C_TLS li127[] C_aligned={C_lihdr(0,0,26),40,99,104,105,99,107,101,110,46,98,97,115,101,35,105,110,102,105,110,105,116,101,63,32,120,41,0,0,0,0,0,0};
static C_char C_TLS li128[] C_aligned={C_lihdr(0,0,21),40,99,104,105,99,107,101,110,46,98,97,115,101,35,110,97,110,63,32,120,41,0,0,0};
static C_char C_TLS li129[] C_aligned={C_lihdr(0,0,8),67,95,115,105,103,110,117,109};
static C_char C_TLS li130[] C_aligned={C_lihdr(0,0,21),40,99,104,105,99,107,101,110,46,98,97,115,101,35,97,100,100,49,32,110,41,0,0,0};
static C_char C_TLS li131[] C_aligned={C_lihdr(0,0,21),40,99,104,105,99,107,101,110,46,98,97,115,101,35,115,117,98,49,32,110,41,0,0,0};
static C_char C_TLS li132[] C_aligned={C_lihdr(0,0,27),40,99,104,105,99,107,101,110,46,98,97,115,101,35,101,114,114,111,114,32,46,32,97,114,103,115,41,0,0,0,0,0};
static C_char C_TLS li133[] C_aligned={C_lihdr(0,0,23),40,99,104,105,99,107,101,110,46,98,97,115,101,35,118,111,105,100,32,46,32,95,41,0};
static C_char C_TLS li134[] C_aligned={C_lihdr(0,0,25),40,99,104,105,99,107,101,110,46,98,97,115,101,35,112,114,111,109,105,115,101,63,32,120,41,0,0,0,0,0,0,0};
static C_char C_TLS li135[] C_aligned={C_lihdr(0,0,25),40,35,35,115,121,115,35,109,97,107,101,45,112,114,111,109,105,115,101,32,112,114,111,99,41,0,0,0,0,0,0,0};
static C_char C_TLS li136[] C_aligned={C_lihdr(0,0,7),40,97,57,51,50,50,41,0};
static C_char C_TLS li137[] C_aligned={C_lihdr(0,0,31),40,99,104,105,99,107,101,110,46,98,97,115,101,35,109,97,107,101,45,112,114,111,109,105,115,101,32,111,98,106,41,0};
static C_char C_TLS li138[] C_aligned={C_lihdr(0,0,12),40,108,111,111,112,32,108,115,116,32,122,41,0,0,0,0};
static C_char C_TLS li139[] C_aligned={C_lihdr(0,0,28),40,99,104,105,99,107,101,110,46,98,97,115,101,35,102,111,108,100,108,32,102,32,122,32,108,115,116,41,0,0,0,0};
static C_char C_TLS li140[] C_aligned={C_lihdr(0,0,10),40,108,111,111,112,32,108,115,116,41,0,0,0,0,0,0};
static C_char C_TLS li141[] C_aligned={C_lihdr(0,0,28),40,99,104,105,99,107,101,110,46,98,97,115,101,35,102,111,108,100,114,32,102,32,122,32,108,115,116,41,0,0,0,0};
static C_char C_TLS li142[] C_aligned={C_lihdr(0,0,28),40,99,104,105,99,107,101,110,46,98,97,115,101,35,111,110,45,101,120,105,116,32,116,104,117,110,107,41,0,0,0,0};
static C_char C_TLS li143[] C_aligned={C_lihdr(0,0,26),40,99,104,105,99,107,101,110,46,98,97,115,101,35,101,120,105,116,32,46,32,114,101,115,116,41,0,0,0,0,0,0};
static C_char C_TLS li144[] C_aligned={C_lihdr(0,0,36),40,99,104,105,99,107,101,110,46,98,97,115,101,35,101,109,101,114,103,101,110,99,121,45,101,120,105,116,32,46,32,114,101,115,116,41,0,0,0,0};
static C_char C_TLS li145[] C_aligned={C_lihdr(0,0,25),40,99,104,105,99,107,101,110,46,98,97,115,101,35,105,100,101,110,116,105,116,121,32,120,41,0,0,0,0,0,0,0};
static C_char C_TLS li146[] C_aligned={C_lihdr(0,0,12),40,108,111,111,112,32,112,114,101,100,115,41,0,0,0,0};
static C_char C_TLS li147[] C_aligned={C_lihdr(0,0,10),40,102,95,57,52,53,50,32,120,41,0,0,0,0,0,0};
static C_char C_TLS li148[] C_aligned={C_lihdr(0,0,30),40,99,104,105,99,107,101,110,46,98,97,115,101,35,99,111,110,106,111,105,110,32,46,32,112,114,101,100,115,41,0,0};
static C_char C_TLS li149[] C_aligned={C_lihdr(0,0,12),40,108,111,111,112,32,112,114,101,100,115,41,0,0,0,0};
static C_char C_TLS li150[] C_aligned={C_lihdr(0,0,10),40,102,95,57,52,56,53,32,120,41,0,0,0,0,0,0};
static C_char C_TLS li151[] C_aligned={C_lihdr(0,0,30),40,99,104,105,99,107,101,110,46,98,97,115,101,35,100,105,115,106,111,105,110,32,46,32,112,114,101,100,115,41,0,0};
static C_char C_TLS li152[] C_aligned={C_lihdr(0,0,12),40,102,95,57,53,51,49,32,46,32,95,41,0,0,0,0};
static C_char C_TLS li153[] C_aligned={C_lihdr(0,0,12),40,102,95,57,53,51,51,32,46,32,95,41,0,0,0,0};
static C_char C_TLS li154[] C_aligned={C_lihdr(0,0,30),40,99,104,105,99,107,101,110,46,98,97,115,101,35,99,111,110,115,116,97,110,116,108,121,32,46,32,120,115,41,0,0};
static C_char C_TLS li155[] C_aligned={C_lihdr(0,0,12),40,102,95,57,53,52,51,32,120,32,121,41,0,0,0,0};
static C_char C_TLS li156[] C_aligned={C_lihdr(0,0,24),40,99,104,105,99,107,101,110,46,98,97,115,101,35,102,108,105,112,32,112,114,111,99,41};
static C_char C_TLS li157[] C_aligned={C_lihdr(0,0,15),40,102,95,57,53,53,49,32,46,32,97,114,103,115,41,0};
static C_char C_TLS li158[] C_aligned={C_lihdr(0,0,27),40,99,104,105,99,107,101,110,46,98,97,115,101,35,99,111,109,112,108,101,109,101,110,116,32,112,41,0,0,0,0,0};
static C_char C_TLS li159[] C_aligned={C_lihdr(0,0,7),40,97,57,53,55,55,41,0};
static C_char C_TLS li160[] C_aligned={C_lihdr(0,0,15),40,102,95,57,53,55,50,32,46,32,97,114,103,115,41,0};
static C_char C_TLS li161[] C_aligned={C_lihdr(0,0,14),40,114,101,99,32,102,48,32,46,32,102,110,115,41,0,0};
static C_char C_TLS li162[] C_aligned={C_lihdr(0,0,28),40,99,104,105,99,107,101,110,46,98,97,115,101,35,99,111,109,112,111,115,101,32,46,32,102,110,115,41,0,0,0,0};
static C_char C_TLS li163[] C_aligned={C_lihdr(0,0,10),40,102,95,57,54,50,51,32,120,41,0,0,0,0,0,0};
static C_char C_TLS li164[] C_aligned={C_lihdr(0,0,10),40,108,111,111,112,32,102,110,115,41,0,0,0,0,0,0};
static C_char C_TLS li165[] C_aligned={C_lihdr(0,0,22),40,99,104,105,99,107,101,110,46,98,97,115,101,35,111,32,46,32,102,110,115,41,0,0};
static C_char C_TLS li166[] C_aligned={C_lihdr(0,0,10),40,108,111,111,112,32,108,115,116,41,0,0,0,0,0,0};
static C_char C_TLS li167[] C_aligned={C_lihdr(0,0,12),40,102,95,57,54,51,56,32,108,115,116,41,0,0,0,0};
static C_char C_TLS li168[] C_aligned={C_lihdr(0,0,28),40,99,104,105,99,107,101,110,46,98,97,115,101,35,108,105,115,116,45,111,102,63,32,112,114,101,100,41,0,0,0,0};
static C_char C_TLS li169[] C_aligned={C_lihdr(0,0,12),40,102,95,57,54,56,56,32,46,32,95,41,0,0,0,0};
static C_char C_TLS li170[] C_aligned={C_lihdr(0,0,12),40,108,111,111,112,32,112,114,111,99,115,41,0,0,0,0};
static C_char C_TLS li171[] C_aligned={C_lihdr(0,0,15),40,102,95,57,55,48,50,32,46,32,97,114,103,115,41,0};
static C_char C_TLS li172[] C_aligned={C_lihdr(0,0,27),40,99,104,105,99,107,101,110,46,98,97,115,101,35,101,97,99,104,32,46,32,112,114,111,99,115,41,0,0,0,0,0};
static C_char C_TLS li173[] C_aligned={C_lihdr(0,0,22),40,99,104,105,99,107,101,110,46,98,97,115,101,35,97,116,111,109,63,32,120,41,0,0};
static C_char C_TLS li174[] C_aligned={C_lihdr(0,0,6),40,108,111,111,112,41,0,0};
static C_char C_TLS li175[] C_aligned={C_lihdr(0,0,24),40,99,104,105,99,107,101,110,46,98,97,115,101,35,116,97,105,108,63,32,120,32,121,41};
static C_char C_TLS li176[] C_aligned={C_lihdr(0,0,9),40,108,111,111,112,32,110,115,41,0,0,0,0,0,0,0};
static C_char C_TLS li177[] C_aligned={C_lihdr(0,0,32),40,99,104,105,99,107,101,110,46,98,97,115,101,35,105,110,116,101,114,115,112,101,114,115,101,32,108,115,116,32,120,41};
static C_char C_TLS li178[] C_aligned={C_lihdr(0,0,10),40,108,111,111,112,32,108,115,116,41,0,0,0,0,0,0};
static C_char C_TLS li179[] C_aligned={C_lihdr(0,0,26),40,99,104,105,99,107,101,110,46,98,97,115,101,35,98,117,116,108,97,115,116,32,108,115,116,41,0,0,0,0,0,0};
static C_char C_TLS li180[] C_aligned={C_lihdr(0,0,17),40,108,111,111,112,32,108,105,115,116,115,32,114,101,115,116,41,0,0,0,0,0,0,0};
static C_char C_TLS li181[] C_aligned={C_lihdr(0,0,31),40,99,104,105,99,107,101,110,46,98,97,115,101,35,102,108,97,116,116,101,110,32,46,32,108,105,115,116,115,48,41,0};
static C_char C_TLS li182[] C_aligned={C_lihdr(0,0,11),40,108,111,111,112,32,108,115,116,115,41,0,0,0,0,0};
static C_char C_TLS li183[] C_aligned={C_lihdr(0,0,30),40,99,104,105,99,107,101,110,46,98,97,115,101,35,106,111,105,110,32,108,115,116,115,32,46,32,108,115,116,41,0,0};
static C_char C_TLS li184[] C_aligned={C_lihdr(0,0,15),40,108,111,111,112,32,98,108,115,116,32,108,115,116,41,0};
static C_char C_TLS li185[] C_aligned={C_lihdr(0,0,32),40,99,104,105,99,107,101,110,46,98,97,115,101,35,99,111,109,112,114,101,115,115,32,98,108,115,116,32,108,115,116,41};
static C_char C_TLS li186[] C_aligned={C_lihdr(0,0,10),40,108,111,111,112,32,108,115,116,41,0,0,0,0,0,0};
static C_char C_TLS li187[] C_aligned={C_lihdr(0,0,15),40,102,95,49,48,48,52,57,32,120,32,108,115,116,41,0};
static C_char C_TLS li188[] C_aligned={C_lihdr(0,0,43),40,99,104,105,99,107,101,110,46,98,97,115,101,35,97,108,105,115,116,45,117,112,100,97,116,101,33,32,120,32,121,32,108,115,116,32,46,32,114,101,115,116,41,0,0,0,0,0};
static C_char C_TLS li189[] C_aligned={C_lihdr(0,0,10),40,108,111,111,112,32,108,115,116,41,0,0,0,0,0,0};
static C_char C_TLS li190[] C_aligned={C_lihdr(0,0,42),40,99,104,105,99,107,101,110,46,98,97,115,101,35,97,108,105,115,116,45,117,112,100,97,116,101,32,107,32,118,32,108,115,116,32,46,32,114,101,115,116,41,0,0,0,0,0,0};
static C_char C_TLS li191[] C_aligned={C_lihdr(0,0,10),40,108,111,111,112,32,108,115,116,41,0,0,0,0,0,0};
static C_char C_TLS li192[] C_aligned={C_lihdr(0,0,15),40,102,95,49,48,50,52,49,32,120,32,108,115,116,41,0};
static C_char C_TLS li193[] C_aligned={C_lihdr(0,0,37),40,99,104,105,99,107,101,110,46,98,97,115,101,35,97,108,105,115,116,45,114,101,102,32,120,32,108,115,116,32,46,32,114,101,115,116,41,0,0,0};
static C_char C_TLS li194[] C_aligned={C_lihdr(0,0,8),40,108,111,111,112,32,108,41};
static C_char C_TLS li195[] C_aligned={C_lihdr(0,0,33),40,99,104,105,99,107,101,110,46,98,97,115,101,35,114,97,115,115,111,99,32,120,32,108,115,116,32,46,32,116,115,116,41,0,0,0,0,0,0,0};
static C_char C_TLS li196[] C_aligned={C_lihdr(0,0,24),40,99,104,105,99,107,101,110,46,102,105,120,110,117,109,35,102,120,43,32,120,32,121,41};
static C_char C_TLS li197[] C_aligned={C_lihdr(0,0,24),40,99,104,105,99,107,101,110,46,102,105,120,110,117,109,35,102,120,45,32,120,32,121,41};
static C_char C_TLS li198[] C_aligned={C_lihdr(0,0,24),40,99,104,105,99,107,101,110,46,102,105,120,110,117,109,35,102,120,42,32,120,32,121,41};
static C_char C_TLS li199[] C_aligned={C_lihdr(0,0,24),40,99,104,105,99,107,101,110,46,102,105,120,110,117,109,35,102,120,61,32,120,32,121,41};
static C_char C_TLS li200[] C_aligned={C_lihdr(0,0,24),40,99,104,105,99,107,101,110,46,102,105,120,110,117,109,35,102,120,62,32,120,32,121,41};
static C_char C_TLS li201[] C_aligned={C_lihdr(0,0,24),40,99,104,105,99,107,101,110,46,102,105,120,110,117,109,35,102,120,60,32,120,32,121,41};
static C_char C_TLS li202[] C_aligned={C_lihdr(0,0,25),40,99,104,105,99,107,101,110,46,102,105,120,110,117,109,35,102,120,62,61,32,120,32,121,41,0,0,0,0,0,0,0};
static C_char C_TLS li203[] C_aligned={C_lihdr(0,0,25),40,99,104,105,99,107,101,110,46,102,105,120,110,117,109,35,102,120,60,61,32,120,32,121,41,0,0,0,0,0,0,0};
static C_char C_TLS li204[] C_aligned={C_lihdr(0,0,26),40,99,104,105,99,107,101,110,46,102,105,120,110,117,109,35,102,120,109,105,110,32,120,32,121,41,0,0,0,0,0,0};
static C_char C_TLS li205[] C_aligned={C_lihdr(0,0,26),40,99,104,105,99,107,101,110,46,102,105,120,110,117,109,35,102,120,109,97,120,32,120,32,121,41,0,0,0,0,0,0};
static C_char C_TLS li206[] C_aligned={C_lihdr(0,0,24),40,99,104,105,99,107,101,110,46,102,105,120,110,117,109,35,102,120,110,101,103,32,120,41};
static C_char C_TLS li207[] C_aligned={C_lihdr(0,0,26),40,99,104,105,99,107,101,110,46,102,105,120,110,117,109,35,102,120,97,110,100,32,120,32,121,41,0,0,0,0,0,0};
static C_char C_TLS li208[] C_aligned={C_lihdr(0,0,26),40,99,104,105,99,107,101,110,46,102,105,120,110,117,109,35,102,120,105,111,114,32,120,32,121,41,0,0,0,0,0,0};
static C_char C_TLS li209[] C_aligned={C_lihdr(0,0,26),40,99,104,105,99,107,101,110,46,102,105,120,110,117,109,35,102,120,120,111,114,32,120,32,121,41,0,0,0,0,0,0};
static C_char C_TLS li210[] C_aligned={C_lihdr(0,0,24),40,99,104,105,99,107,101,110,46,102,105,120,110,117,109,35,102,120,110,111,116,32,120,41};
static C_char C_TLS li211[] C_aligned={C_lihdr(0,0,26),40,99,104,105,99,107,101,110,46,102,105,120,110,117,109,35,102,120,115,104,108,32,120,32,121,41,0,0,0,0,0,0};
static C_char C_TLS li212[] C_aligned={C_lihdr(0,0,26),40,99,104,105,99,107,101,110,46,102,105,120,110,117,109,35,102,120,115,104,114,32,120,32,121,41,0,0,0,0,0,0};
static C_char C_TLS li213[] C_aligned={C_lihdr(0,0,25),40,99,104,105,99,107,101,110,46,102,105,120,110,117,109,35,102,120,111,100,100,63,32,120,41,0,0,0,0,0,0,0};
static C_char C_TLS li214[] C_aligned={C_lihdr(0,0,26),40,99,104,105,99,107,101,110,46,102,105,120,110,117,109,35,102,120,101,118,101,110,63,32,120,41,0,0,0,0,0,0};
static C_char C_TLS li215[] C_aligned={C_lihdr(0,0,24),40,99,104,105,99,107,101,110,46,102,105,120,110,117,109,35,102,120,108,101,110,32,120,41};
static C_char C_TLS li216[] C_aligned={C_lihdr(0,0,24),40,99,104,105,99,107,101,110,46,102,105,120,110,117,109,35,102,120,47,32,120,32,121,41};
static C_char C_TLS li217[] C_aligned={C_lihdr(0,0,26),40,99,104,105,99,107,101,110,46,102,105,120,110,117,109,35,102,120,103,99,100,32,120,32,121,41,0,0,0,0,0,0};
static C_char C_TLS li218[] C_aligned={C_lihdr(0,0,26),40,99,104,105,99,107,101,110,46,102,105,120,110,117,109,35,102,120,109,111,100,32,120,32,121,41,0,0,0,0,0,0};
static C_char C_TLS li219[] C_aligned={C_lihdr(0,0,26),40,99,104,105,99,107,101,110,46,102,105,120,110,117,109,35,102,120,114,101,109,32,120,32,121,41,0,0,0,0,0,0};
static C_char C_TLS li220[] C_aligned={C_lihdr(0,0,25),40,99,104,105,99,107,101,110,46,102,105,120,110,117,109,35,102,120,43,63,32,120,32,121,41,0,0,0,0,0,0,0};
static C_char C_TLS li221[] C_aligned={C_lihdr(0,0,25),40,99,104,105,99,107,101,110,46,102,105,120,110,117,109,35,102,120,45,63,32,120,32,121,41,0,0,0,0,0,0,0};
static C_char C_TLS li222[] C_aligned={C_lihdr(0,0,25),40,99,104,105,99,107,101,110,46,102,105,120,110,117,109,35,102,120,42,63,32,120,32,121,41,0,0,0,0,0,0,0};
static C_char C_TLS li223[] C_aligned={C_lihdr(0,0,25),40,99,104,105,99,107,101,110,46,102,105,120,110,117,109,35,102,120,47,63,32,120,32,121,41,0,0,0,0,0,0,0};
static C_char C_TLS li224[] C_aligned={C_lihdr(0,0,19),40,35,35,115,121,115,35,100,101,98,117,103,45,109,111,100,101,63,41,0,0,0,0,0};
static C_char C_TLS li225[] C_aligned={C_lihdr(0,0,33),40,99,104,105,99,107,101,110,46,98,97,115,101,35,119,97,114,110,105,110,103,32,109,115,103,32,46,32,97,114,103,115,41,0,0,0,0,0,0,0};
static C_char C_TLS li226[] C_aligned={C_lihdr(0,0,32),40,99,104,105,99,107,101,110,46,98,97,115,101,35,110,111,116,105,99,101,32,109,115,103,32,46,32,97,114,103,115,41};
static C_char C_TLS li227[] C_aligned={C_lihdr(0,0,37),40,99,104,105,99,107,101,110,46,98,97,115,101,35,101,110,97,98,108,101,45,119,97,114,110,105,110,103,115,32,46,32,98,111,111,108,41,0,0,0};
static C_char C_TLS li228[] C_aligned={C_lihdr(0,0,4),67,95,103,99,0,0,0,0};
static C_char C_TLS li229[] C_aligned={C_lihdr(0,0,21),40,35,35,115,121,115,35,115,101,116,115,108,111,116,32,120,32,105,32,121,41,0,0,0};
static C_char C_TLS li230[] C_aligned={C_lihdr(0,0,22),40,35,35,115,121,115,35,115,101,116,105,115,108,111,116,32,120,32,105,32,121,41,0,0};
static C_char C_TLS li231[] C_aligned={C_lihdr(0,0,17),67,95,97,108,108,111,99,97,116,101,95,118,101,99,116,111,114,0,0,0,0,0,0,0};
static C_char C_TLS li232[] C_aligned={C_lihdr(0,0,16),67,95,109,97,107,101,95,115,116,114,117,99,116,117,114,101};
static C_char C_TLS li233[] C_aligned={C_lihdr(0,0,21),67,95,101,110,115,117,114,101,95,104,101,97,112,95,114,101,115,101,114,118,101,0,0,0};
static C_char C_TLS li234[] C_aligned={C_lihdr(0,0,23),67,95,103,101,116,95,115,121,109,98,111,108,95,116,97,98,108,101,95,105,110,102,111,0};
static C_char C_TLS li235[] C_aligned={C_lihdr(0,0,17),67,95,103,101,116,95,109,101,109,111,114,121,95,105,110,102,111,0,0,0,0,0,0,0};
static C_char C_TLS li236[] C_aligned={C_lihdr(0,0,19),40,35,35,115,121,115,35,115,116,97,114,116,45,116,105,109,101,114,41,0,0,0,0,0};
static C_char C_TLS li237[] C_aligned={C_lihdr(0,0,12),67,95,115,116,111,112,95,116,105,109,101,114,0,0,0,0};
static C_char C_TLS li238[] C_aligned={C_lihdr(0,0,12),67,95,115,116,111,112,95,116,105,109,101,114,0,0,0,0};
static C_char C_TLS li239[] C_aligned={C_lihdr(0,0,18),40,35,35,115,121,115,35,115,116,111,112,45,116,105,109,101,114,41,0,0,0,0,0,0};
static C_char C_TLS li240[] C_aligned={C_lihdr(0,0,20),40,35,35,115,121,115,35,105,109,109,101,100,105,97,116,101,63,32,120,41,0,0,0,0};
static C_char C_TLS li241[] C_aligned={C_lihdr(0,0,19),40,35,35,115,121,115,35,109,101,115,115,97,103,101,32,115,116,114,41,0,0,0,0,0};
static C_char C_TLS li242[] C_aligned={C_lihdr(0,0,16),40,35,35,115,121,115,35,98,121,116,101,32,120,32,105,41};
static C_char C_TLS li243[] C_aligned={C_lihdr(0,0,21),40,35,35,115,121,115,35,115,101,116,98,121,116,101,32,120,32,105,32,110,41,0,0,0};
static C_char C_TLS li244[] C_aligned={C_lihdr(0,0,16),40,35,35,115,121,115,35,104,97,108,116,32,109,115,103,41};
static C_char C_TLS li245[] C_aligned={C_lihdr(0,0,8),67,95,98,101,99,111,109,101};
static C_char C_TLS li246[] C_aligned={C_lihdr(0,0,21),40,35,35,115,121,115,35,98,108,111,99,107,45,114,101,102,32,120,32,105,41,0,0,0};
static C_char C_TLS li247[] C_aligned={C_lihdr(0,0,14),67,95,97,112,112,108,121,95,118,97,108,117,101,115,0,0};
static C_char C_TLS li248[] C_aligned={C_lihdr(0,0,14),67,95,99,111,112,121,95,99,108,111,115,117,114,101,0,0};
static C_char C_TLS li249[] C_aligned={C_lihdr(0,0,24),40,35,35,115,121,115,35,98,108,111,99,107,45,115,101,116,33,32,120,32,105,32,121,41};
static C_char C_TLS li250[] C_aligned={C_lihdr(0,0,35),40,99,104,105,99,107,101,110,46,116,105,109,101,35,99,117,114,114,101,110,116,45,109,105,108,108,105,115,101,99,111,110,100,115,41,0,0,0,0,0};
static C_char C_TLS li251[] C_aligned={C_lihdr(0,0,30),40,99,104,105,99,107,101,110,46,116,105,109,101,35,99,117,114,114,101,110,116,45,115,101,99,111,110,100,115,41,0,0};
static C_char C_TLS li252[] C_aligned={C_lihdr(0,0,23),40,99,104,105,99,107,101,110,46,116,105,109,101,35,99,112,117,45,116,105,109,101,41,0};
static C_char C_TLS li253[] C_aligned={C_lihdr(0,0,33),40,35,35,115,121,115,35,99,104,101,99,107,45,115,116,114,117,99,116,117,114,101,32,120,32,121,32,46,32,108,111,99,41,0,0,0,0,0,0,0};
static C_char C_TLS li254[] C_aligned={C_lihdr(0,0,26),40,35,35,115,121,115,35,99,104,101,99,107,45,98,108,111,98,32,120,32,46,32,108,111,99,41,0,0,0,0,0,0};
static C_char C_TLS li255[] C_aligned={C_lihdr(0,0,26),40,35,35,115,121,115,35,99,104,101,99,107,45,112,97,105,114,32,120,32,46,32,108,111,99,41,0,0,0,0,0,0};
static C_char C_TLS li256[] C_aligned={C_lihdr(0,0,26),40,35,35,115,121,115,35,99,104,101,99,107,45,108,105,115,116,32,120,32,46,32,108,111,99,41,0,0,0,0,0,0};
static C_char C_TLS li257[] C_aligned={C_lihdr(0,0,28),40,35,35,115,121,115,35,99,104,101,99,107,45,115,116,114,105,110,103,32,120,32,46,32,108,111,99,41,0,0,0,0};
static C_char C_TLS li258[] C_aligned={C_lihdr(0,0,28),40,35,35,115,121,115,35,99,104,101,99,107,45,110,117,109,98,101,114,32,120,32,46,32,108,111,99,41,0,0,0,0};
static C_char C_TLS li259[] C_aligned={C_lihdr(0,0,28),40,35,35,115,121,115,35,99,104,101,99,107,45,102,105,120,110,117,109,32,120,32,46,32,108,111,99,41,0,0,0,0};
static C_char C_TLS li260[] C_aligned={C_lihdr(0,0,27),40,35,35,115,121,115,35,99,104,101,99,107,45,101,120,97,99,116,32,120,32,46,32,108,111,99,41,0,0,0,0,0};
static C_char C_TLS li261[] C_aligned={C_lihdr(0,0,29),40,35,35,115,121,115,35,99,104,101,99,107,45,105,110,101,120,97,99,116,32,120,32,46,32,108,111,99,41,0,0,0};
static C_char C_TLS li262[] C_aligned={C_lihdr(0,0,28),40,35,35,115,121,115,35,99,104,101,99,107,45,115,121,109,98,111,108,32,120,32,46,32,108,111,99,41,0,0,0,0};
static C_char C_TLS li263[] C_aligned={C_lihdr(0,0,29),40,35,35,115,121,115,35,99,104,101,99,107,45,107,101,121,119,111,114,100,32,120,32,46,32,108,111,99,41,0,0,0};
static C_char C_TLS li264[] C_aligned={C_lihdr(0,0,28),40,35,35,115,121,115,35,99,104,101,99,107,45,118,101,99,116,111,114,32,120,32,46,32,108,111,99,41,0,0,0,0};
static C_char C_TLS li265[] C_aligned={C_lihdr(0,0,26),40,35,35,115,121,115,35,99,104,101,99,107,45,99,104,97,114,32,120,32,46,32,108,111,99,41,0,0,0,0,0,0};
static C_char C_TLS li266[] C_aligned={C_lihdr(0,0,29),40,35,35,115,121,115,35,99,104,101,99,107,45,98,111,111,108,101,97,110,32,120,32,46,32,108,111,99,41,0,0,0};
static C_char C_TLS li267[] C_aligned={C_lihdr(0,0,30),40,35,35,115,121,115,35,99,104,101,99,107,45,108,111,99,97,116,105,118,101,32,120,32,46,32,108,111,99,41,0,0};
static C_char C_TLS li268[] C_aligned={C_lihdr(0,0,29),40,35,35,115,121,115,35,99,104,101,99,107,45,105,110,116,101,103,101,114,32,120,32,46,32,108,111,99,41,0,0,0};
static C_char C_TLS li269[] C_aligned={C_lihdr(0,0,35),40,35,35,115,121,115,35,99,104,101,99,107,45,101,120,97,99,116,45,105,110,116,101,103,101,114,32,120,32,46,32,108,111,99,41,0,0,0,0,0};
static C_char C_TLS li270[] C_aligned={C_lihdr(0,0,36),40,35,35,115,121,115,35,99,104,101,99,107,45,101,120,97,99,116,45,117,105,110,116,101,103,101,114,32,120,32,46,32,108,111,99,41,0,0,0,0};
static C_char C_TLS li271[] C_aligned={C_lihdr(0,0,26),40,35,35,115,121,115,35,99,104,101,99,107,45,114,101,97,108,32,120,32,46,32,108,111,99,41,0,0,0,0,0,0};
static C_char C_TLS li272[] C_aligned={C_lihdr(0,0,35),40,35,35,115,121,115,35,99,104,101,99,107,45,114,97,110,103,101,32,105,32,102,114,111,109,32,116,111,32,46,32,108,111,99,41,0,0,0,0,0};
static C_char C_TLS li273[] C_aligned={C_lihdr(0,0,31),40,35,35,115,121,115,35,99,104,101,99,107,45,115,112,101,99,105,97,108,32,112,116,114,32,46,32,108,111,99,41,0};
static C_char C_TLS li274[] C_aligned={C_lihdr(0,0,29),40,35,35,115,121,115,35,99,104,101,99,107,45,99,108,111,115,117,114,101,32,120,32,46,32,108,111,99,41,0,0,0};
static C_char C_TLS li275[] C_aligned={C_lihdr(0,0,20),40,108,112,32,112,114,111,109,105,115,101,32,102,111,114,119,97,114,100,41,0,0,0,0};
static C_char C_TLS li276[] C_aligned={C_lihdr(0,0,18),40,115,99,104,101,109,101,35,102,111,114,99,101,32,111,98,106,41,0,0,0,0,0,0};
static C_char C_TLS li277[] C_aligned={C_lihdr(0,0,7),67,95,100,108,111,97,100,0};
static C_char C_TLS li278[] C_aligned={C_lihdr(0,0,18),67,95,115,101,116,95,100,108,111,112,101,110,95,102,108,97,103,115,0,0,0,0,0,0};
static C_char C_TLS li279[] C_aligned={C_lihdr(0,0,42),40,35,35,115,121,115,35,101,114,114,111,114,45,110,111,116,45,97,45,112,114,111,112,101,114,45,108,105,115,116,32,97,114,103,32,46,32,114,101,115,116,41,0,0,0,0,0,0};
static C_char C_TLS li280[] C_aligned={C_lihdr(0,0,35),40,35,35,115,121,115,35,101,114,114,111,114,45,98,97,100,45,110,117,109,98,101,114,32,97,114,103,32,46,32,114,101,115,116,41,0,0,0,0,0};
static C_char C_TLS li281[] C_aligned={C_lihdr(0,0,36),40,35,35,115,121,115,35,101,114,114,111,114,45,98,97,100,45,105,110,116,101,103,101,114,32,97,114,103,32,46,32,114,101,115,116,41,0,0,0,0};
static C_char C_TLS li282[] C_aligned={C_lihdr(0,0,42),40,35,35,115,121,115,35,101,114,114,111,114,45,98,97,100,45,101,120,97,99,116,45,105,110,116,101,103,101,114,32,97,114,103,32,46,32,114,101,115,116,41,0,0,0,0,0,0};
static C_char C_TLS li283[] C_aligned={C_lihdr(0,0,43),40,35,35,115,121,115,35,101,114,114,111,114,45,98,97,100,45,101,120,97,99,116,45,117,105,110,116,101,103,101,114,32,97,114,103,32,46,32,114,101,115,116,41,0,0,0,0,0};
static C_char C_TLS li284[] C_aligned={C_lihdr(0,0,36),40,35,35,115,121,115,35,101,114,114,111,114,45,98,97,100,45,105,110,101,120,97,99,116,32,97,114,103,32,46,32,114,101,115,116,41,0,0,0,0};
static C_char C_TLS li285[] C_aligned={C_lihdr(0,0,33),40,35,35,115,121,115,35,101,114,114,111,114,45,98,97,100,45,114,101,97,108,32,97,114,103,32,46,32,114,101,115,116,41,0,0,0,0,0,0,0};
static C_char C_TLS li286[] C_aligned={C_lihdr(0,0,33),40,35,35,115,121,115,35,101,114,114,111,114,45,98,97,100,45,98,97,115,101,32,97,114,103,32,46,32,114,101,115,116,41,0,0,0,0,0,0,0};
static C_char C_TLS li287[] C_aligned={C_lihdr(0,0,11),40,99,111,112,121,32,110,111,100,101,41,0,0,0,0,0};
static C_char C_TLS li288[] C_aligned={C_lihdr(0,0,11),40,108,111,111,112,32,108,115,116,115,41,0,0,0,0,0};
static C_char C_TLS li289[] C_aligned={C_lihdr(0,0,22),40,115,99,104,101,109,101,35,97,112,112,101,110,100,32,46,32,108,115,116,115,41,0,0};
static C_char C_TLS li290[] C_aligned={C_lihdr(0,0,15),40,108,111,111,112,32,108,115,116,32,114,101,115,116,41,0};
static C_char C_TLS li291[] C_aligned={C_lihdr(0,0,25),40,35,35,115,121,115,35,102,97,115,116,45,114,101,118,101,114,115,101,32,108,115,116,48,41,0,0,0,0,0,0,0};
static C_char C_TLS li292[] C_aligned={C_lihdr(0,0,31),40,35,35,115,121,115,35,109,97,107,101,45,115,116,114,105,110,103,32,115,105,122,101,32,46,32,114,101,115,116,41,0};
static C_char C_TLS li293[] C_aligned={C_lihdr(0,0,32),40,115,99,104,101,109,101,35,109,97,107,101,45,115,116,114,105,110,103,32,115,105,122,101,32,46,32,102,105,108,108,41};
static C_char C_TLS li294[] C_aligned={C_lihdr(0,0,11),40,108,111,111,112,32,105,32,108,115,41,0,0,0,0,0};
static C_char C_TLS li295[] C_aligned={C_lihdr(0,0,23),40,115,99,104,101,109,101,35,115,116,114,105,110,103,45,62,108,105,115,116,32,115,41,0};
static C_char C_TLS li296[] C_aligned={C_lihdr(0,0,16),40,100,111,108,111,111,112,49,53,50,54,32,108,115,116,41};
static C_char C_TLS li297[] C_aligned={C_lihdr(0,0,26),40,115,99,104,101,109,101,35,108,105,115,116,45,62,115,116,114,105,110,103,32,108,115,116,48,41,0,0,0,0,0,0};
static C_char C_TLS li298[] C_aligned={C_lihdr(0,0,9),40,105,116,101,114,32,110,50,41,0,0,0,0,0,0,0};
static C_char C_TLS li299[] C_aligned={C_lihdr(0,0,30),40,35,35,115,121,115,35,114,101,118,101,114,115,101,45,108,105,115,116,45,62,115,116,114,105,110,103,32,108,41,0,0};
static C_char C_TLS li300[] C_aligned={C_lihdr(0,0,25),40,115,99,104,101,109,101,35,115,116,114,105,110,103,45,102,105,108,108,33,32,115,32,99,41,0,0,0,0,0,0,0};
static C_char C_TLS li301[] C_aligned={C_lihdr(0,0,22),40,115,99,104,101,109,101,35,115,116,114,105,110,103,45,99,111,112,121,32,115,41,0,0};
static C_char C_TLS li302[] C_aligned={C_lihdr(0,0,32),40,115,99,104,101,109,101,35,115,117,98,115,116,114,105,110,103,32,115,32,115,116,97,114,116,32,46,32,101,110,100,41};
static C_char C_TLS li303[] C_aligned={C_lihdr(0,0,29),40,35,35,115,121,115,35,115,117,98,115,116,114,105,110,103,32,115,32,115,116,97,114,116,32,101,110,100,41,0,0,0};
static C_char C_TLS li304[] C_aligned={C_lihdr(0,0,25),40,99,111,109,112,97,114,101,49,53,55,57,32,115,49,32,115,50,32,108,111,99,32,107,41,0,0,0,0,0,0,0};
static C_char C_TLS li305[] C_aligned={C_lihdr(0,0,22),40,97,49,49,53,56,55,32,108,101,110,49,32,108,101,110,50,32,99,109,112,41,0,0};
static C_char C_TLS li306[] C_aligned={C_lihdr(0,0,23),40,115,99,104,101,109,101,35,115,116,114,105,110,103,60,63,32,115,49,32,115,50,41,0};
static C_char C_TLS li307[] C_aligned={C_lihdr(0,0,22),40,97,49,49,54,49,49,32,108,101,110,49,32,108,101,110,50,32,99,109,112,41,0,0};
static C_char C_TLS li308[] C_aligned={C_lihdr(0,0,23),40,115,99,104,101,109,101,35,115,116,114,105,110,103,62,63,32,115,49,32,115,50,41,0};
static C_char C_TLS li309[] C_aligned={C_lihdr(0,0,22),40,97,49,49,54,51,53,32,108,101,110,49,32,108,101,110,50,32,99,109,112,41,0,0};
static C_char C_TLS li310[] C_aligned={C_lihdr(0,0,24),40,115,99,104,101,109,101,35,115,116,114,105,110,103,60,61,63,32,115,49,32,115,50,41};
static C_char C_TLS li311[] C_aligned={C_lihdr(0,0,22),40,97,49,49,54,53,54,32,108,101,110,49,32,108,101,110,50,32,99,109,112,41,0,0};
static C_char C_TLS li312[] C_aligned={C_lihdr(0,0,24),40,115,99,104,101,109,101,35,115,116,114,105,110,103,62,61,63,32,115,49,32,115,50,41};
static C_char C_TLS li313[] C_aligned={C_lihdr(0,0,25),40,99,111,109,112,97,114,101,49,54,50,50,32,115,49,32,115,50,32,108,111,99,32,107,41,0,0,0,0,0,0,0};
static C_char C_TLS li314[] C_aligned={C_lihdr(0,0,22),40,97,49,49,54,57,55,32,108,101,110,49,32,108,101,110,50,32,99,109,112,41,0,0};
static C_char C_TLS li315[] C_aligned={C_lihdr(0,0,26),40,115,99,104,101,109,101,35,115,116,114,105,110,103,45,99,105,60,63,32,115,49,32,115,50,41,0,0,0,0,0,0};
static C_char C_TLS li316[] C_aligned={C_lihdr(0,0,22),40,97,49,49,55,50,49,32,108,101,110,49,32,108,101,110,50,32,99,109,112,41,0,0};
static C_char C_TLS li317[] C_aligned={C_lihdr(0,0,26),40,115,99,104,101,109,101,35,115,116,114,105,110,103,45,99,105,62,63,32,115,49,32,115,50,41,0,0,0,0,0,0};
static C_char C_TLS li318[] C_aligned={C_lihdr(0,0,22),40,97,49,49,55,52,53,32,108,101,110,49,32,108,101,110,50,32,99,109,112,41,0,0};
static C_char C_TLS li319[] C_aligned={C_lihdr(0,0,27),40,115,99,104,101,109,101,35,115,116,114,105,110,103,45,99,105,60,61,63,32,115,49,32,115,50,41,0,0,0,0,0};
static C_char C_TLS li320[] C_aligned={C_lihdr(0,0,22),40,97,49,49,55,54,54,32,108,101,110,49,32,108,101,110,50,32,99,109,112,41,0,0};
static C_char C_TLS li321[] C_aligned={C_lihdr(0,0,27),40,115,99,104,101,109,101,35,115,116,114,105,110,103,45,99,105,62,61,63,32,115,49,32,115,50,41,0,0,0,0,0};
static C_char C_TLS li322[] C_aligned={C_lihdr(0,0,25),40,35,35,115,121,115,35,115,116,114,105,110,103,45,97,112,112,101,110,100,32,120,32,121,41,0,0,0,0,0,0,0};
static C_char C_TLS li323[] C_aligned={C_lihdr(0,0,13),40,108,111,111,112,32,115,116,114,115,32,110,41,0,0,0};
static C_char C_TLS li324[] C_aligned={C_lihdr(0,0,28),40,115,99,104,101,109,101,35,115,116,114,105,110,103,45,97,112,112,101,110,100,32,46,32,97,108,108,41,0,0,0,0};
static C_char C_TLS li325[] C_aligned={C_lihdr(0,0,23),40,115,99,104,101,109,101,35,115,116,114,105,110,103,32,46,32,99,104,97,114,115,41,0};
static C_char C_TLS li326[] C_aligned={C_lihdr(0,0,10),40,108,111,111,112,32,112,111,115,41,0,0,0,0,0,0};
static C_char C_TLS li327[] C_aligned={C_lihdr(0,0,34),40,35,35,115,121,115,35,102,114,97,103,109,101,110,116,115,45,62,115,116,114,105,110,103,32,116,111,116,97,108,32,102,115,41,0,0,0,0,0,0};
static C_char C_TLS li328[] C_aligned={C_lihdr(0,0,20),40,100,111,108,111,111,112,49,55,48,55,32,104,100,32,116,108,32,99,41,0,0,0,0};
static C_char C_TLS li329[] C_aligned={C_lihdr(0,0,12),40,108,111,111,112,32,108,115,116,32,105,41,0,0,0,0};
static C_char C_TLS li330[] C_aligned={C_lihdr(0,0,25),40,99,104,105,99,107,101,110,46,98,97,115,101,35,99,104,111,112,32,108,115,116,32,110,41,0,0,0,0,0,0,0};
static C_char C_TLS li331[] C_aligned={C_lihdr(0,0,24),40,99,104,105,99,107,101,110,46,102,108,111,110,117,109,35,102,112,43,32,120,32,121,41};
static C_char C_TLS li332[] C_aligned={C_lihdr(0,0,24),40,99,104,105,99,107,101,110,46,102,108,111,110,117,109,35,102,112,45,32,120,32,121,41};
static C_char C_TLS li333[] C_aligned={C_lihdr(0,0,24),40,99,104,105,99,107,101,110,46,102,108,111,110,117,109,35,102,112,42,32,120,32,121,41};
static C_char C_TLS li334[] C_aligned={C_lihdr(0,0,24),40,99,104,105,99,107,101,110,46,102,108,111,110,117,109,35,102,112,47,32,120,32,121,41};
static C_char C_TLS li335[] C_aligned={C_lihdr(0,0,26),40,99,104,105,99,107,101,110,46,102,108,111,110,117,109,35,102,112,103,99,100,32,120,32,121,41,0,0,0,0,0,0};
static C_char C_TLS li336[] C_aligned={C_lihdr(0,0,25),40,99,104,105,99,107,101,110,46,102,108,111,110,117,109,35,102,112,47,63,32,120,32,121,41,0,0,0,0,0,0,0};
static C_char C_TLS li337[] C_aligned={C_lihdr(0,0,24),40,99,104,105,99,107,101,110,46,102,108,111,110,117,109,35,102,112,61,32,120,32,121,41};
static C_char C_TLS li338[] C_aligned={C_lihdr(0,0,24),40,99,104,105,99,107,101,110,46,102,108,111,110,117,109,35,102,112,62,32,120,32,121,41};
static C_char C_TLS li339[] C_aligned={C_lihdr(0,0,24),40,99,104,105,99,107,101,110,46,102,108,111,110,117,109,35,102,112,60,32,120,32,121,41};
static C_char C_TLS li340[] C_aligned={C_lihdr(0,0,25),40,99,104,105,99,107,101,110,46,102,108,111,110,117,109,35,102,112,62,61,32,120,32,121,41,0,0,0,0,0,0,0};
static C_char C_TLS li341[] C_aligned={C_lihdr(0,0,25),40,99,104,105,99,107,101,110,46,102,108,111,110,117,109,35,102,112,60,61,32,120,32,121,41,0,0,0,0,0,0,0};
static C_char C_TLS li342[] C_aligned={C_lihdr(0,0,24),40,99,104,105,99,107,101,110,46,102,108,111,110,117,109,35,102,112,110,101,103,32,120,41};
static C_char C_TLS li343[] C_aligned={C_lihdr(0,0,26),40,99,104,105,99,107,101,110,46,102,108,111,110,117,109,35,102,112,109,97,120,32,120,32,121,41,0,0,0,0,0,0};
static C_char C_TLS li344[] C_aligned={C_lihdr(0,0,26),40,99,104,105,99,107,101,110,46,102,108,111,110,117,109,35,102,112,109,105,110,32,120,32,121,41,0,0,0,0,0,0};
static C_char C_TLS li345[] C_aligned={C_lihdr(0,0,26),40,99,104,105,99,107,101,110,46,102,108,111,110,117,109,35,102,112,102,108,111,111,114,32,120,41,0,0,0,0,0,0};
static C_char C_TLS li346[] C_aligned={C_lihdr(0,0,29),40,99,104,105,99,107,101,110,46,102,108,111,110,117,109,35,102,112,116,114,117,110,99,97,116,101,32,120,41,0,0,0};
static C_char C_TLS li347[] C_aligned={C_lihdr(0,0,26),40,99,104,105,99,107,101,110,46,102,108,111,110,117,109,35,102,112,114,111,117,110,100,32,120,41,0,0,0,0,0,0};
static C_char C_TLS li348[] C_aligned={C_lihdr(0,0,28),40,99,104,105,99,107,101,110,46,102,108,111,110,117,109,35,102,112,99,101,105,108,105,110,103,32,120,41,0,0,0,0};
static C_char C_TLS li349[] C_aligned={C_lihdr(0,0,24),40,99,104,105,99,107,101,110,46,102,108,111,110,117,109,35,102,112,115,105,110,32,120,41};
static C_char C_TLS li350[] C_aligned={C_lihdr(0,0,24),40,99,104,105,99,107,101,110,46,102,108,111,110,117,109,35,102,112,99,111,115,32,120,41};
static C_char C_TLS li351[] C_aligned={C_lihdr(0,0,24),40,99,104,105,99,107,101,110,46,102,108,111,110,117,109,35,102,112,116,97,110,32,120,41};
static C_char C_TLS li352[] C_aligned={C_lihdr(0,0,25),40,99,104,105,99,107,101,110,46,102,108,111,110,117,109,35,102,112,97,115,105,110,32,120,41,0,0,0,0,0,0,0};
static C_char C_TLS li353[] C_aligned={C_lihdr(0,0,25),40,99,104,105,99,107,101,110,46,102,108,111,110,117,109,35,102,112,97,99,111,115,32,120,41,0,0,0,0,0,0,0};
static C_char C_TLS li354[] C_aligned={C_lihdr(0,0,25),40,99,104,105,99,107,101,110,46,102,108,111,110,117,109,35,102,112,97,116,97,110,32,120,41,0,0,0,0,0,0,0};
static C_char C_TLS li355[] C_aligned={C_lihdr(0,0,28),40,99,104,105,99,107,101,110,46,102,108,111,110,117,109,35,102,112,97,116,97,110,50,32,120,32,121,41,0,0,0,0};
static C_char C_TLS li356[] C_aligned={C_lihdr(0,0,24),40,99,104,105,99,107,101,110,46,102,108,111,110,117,109,35,102,112,101,120,112,32,120,41};
static C_char C_TLS li357[] C_aligned={C_lihdr(0,0,27),40,99,104,105,99,107,101,110,46,102,108,111,110,117,109,35,102,112,101,120,112,116,32,120,32,121,41,0,0,0,0,0};
static C_char C_TLS li358[] C_aligned={C_lihdr(0,0,24),40,99,104,105,99,107,101,110,46,102,108,111,110,117,109,35,102,112,108,111,103,32,120,41};
static C_char C_TLS li359[] C_aligned={C_lihdr(0,0,25),40,99,104,105,99,107,101,110,46,102,108,111,110,117,109,35,102,112,115,113,114,116,32,120,41,0,0,0,0,0,0,0};
static C_char C_TLS li360[] C_aligned={C_lihdr(0,0,24),40,99,104,105,99,107,101,110,46,102,108,111,110,117,109,35,102,112,97,98,115,32,120,41};
static C_char C_TLS li361[] C_aligned={C_lihdr(0,0,29),40,99,104,105,99,107,101,110,46,102,108,111,110,117,109,35,102,112,105,110,116,101,103,101,114,63,32,120,41,0,0,0};
static C_char C_TLS li362[] C_aligned={C_lihdr(0,0,46),40,99,104,105,99,107,101,110,46,102,108,111,110,117,109,35,102,108,111,110,117,109,45,112,114,105,110,116,45,112,114,101,99,105,115,105,111,110,32,46,32,114,101,115,116,41,0,0};
static C_char C_TLS li363[] C_aligned={C_lihdr(0,0,18),40,109,97,107,101,45,99,111,109,112,108,101,120,32,114,32,105,41,0,0,0,0,0,0};
static C_char C_TLS li364[] C_aligned={C_lihdr(0,0,29),40,115,99,104,101,109,101,35,109,97,107,101,45,114,101,99,116,97,110,103,117,108,97,114,32,114,32,105,41,0,0,0};
static C_char C_TLS li365[] C_aligned={C_lihdr(0,0,25),40,115,99,104,101,109,101,35,109,97,107,101,45,112,111,108,97,114,32,114,32,112,104,105,41,0,0,0,0,0,0,0};
static C_char C_TLS li366[] C_aligned={C_lihdr(0,0,20),40,115,99,104,101,109,101,35,114,101,97,108,45,112,97,114,116,32,120,41,0,0,0,0};
static C_char C_TLS li367[] C_aligned={C_lihdr(0,0,20),40,115,99,104,101,109,101,35,105,109,97,103,45,112,97,114,116,32,120,41,0,0,0,0};
static C_char C_TLS li368[] C_aligned={C_lihdr(0,0,16),40,115,99,104,101,109,101,35,97,110,103,108,101,32,110,41};
static C_char C_TLS li369[] C_aligned={C_lihdr(0,0,20),40,115,99,104,101,109,101,35,109,97,103,110,105,116,117,100,101,32,120,41,0,0,0,0};
static C_char C_TLS li370[] C_aligned={C_lihdr(0,0,10),40,114,97,116,110,117,109,32,110,41,0,0,0,0,0,0};
static C_char C_TLS li371[] C_aligned={C_lihdr(0,0,20),40,115,99,104,101,109,101,35,110,117,109,101,114,97,116,111,114,32,110,41,0,0,0,0};
static C_char C_TLS li372[] C_aligned={C_lihdr(0,0,22),40,115,99,104,101,109,101,35,100,101,110,111,109,105,110,97,116,111,114,32,110,41,0,0};
static C_char C_TLS li373[] C_aligned={C_lihdr(0,0,25),40,35,35,115,121,115,35,101,120,116,101,110,100,101,100,45,115,105,103,110,117,109,32,120,41,0,0,0,0,0,0,0};
static C_char C_TLS li374[] C_aligned={C_lihdr(0,0,16),40,100,111,108,111,111,112,50,50,49,56,32,120,32,105,41};
static C_char C_TLS li375[] C_aligned={C_lihdr(0,0,13),40,100,101,108,105,118,101,114,32,121,32,100,41,0,0,0};
static C_char C_TLS li376[] C_aligned={C_lihdr(0,0,25),40,115,99,104,101,109,101,35,105,110,101,120,97,99,116,45,62,101,120,97,99,116,32,120,41,0,0,0,0,0,0,0};
static C_char C_TLS li377[] C_aligned={C_lihdr(0,0,13),67,95,98,105,116,119,105,115,101,95,97,110,100,0,0,0};
static C_char C_TLS li378[] C_aligned={C_lihdr(0,0,13),67,95,98,105,116,119,105,115,101,95,105,111,114,0,0,0};
static C_char C_TLS li379[] C_aligned={C_lihdr(0,0,13),67,95,98,105,116,119,105,115,101,95,120,111,114,0,0,0};
static C_char C_TLS li380[] C_aligned={C_lihdr(0,0,31),40,99,104,105,99,107,101,110,46,98,105,116,119,105,115,101,35,98,105,116,119,105,115,101,45,110,111,116,32,110,41,0};
static C_char C_TLS li381[] C_aligned={C_lihdr(0,0,34),40,99,104,105,99,107,101,110,46,98,105,116,119,105,115,101,35,98,105,116,45,62,98,111,111,108,101,97,110,32,110,32,105,41,0,0,0,0,0,0};
static C_char C_TLS li382[] C_aligned={C_lihdr(0,0,34),40,99,104,105,99,107,101,110,46,98,105,116,119,105,115,101,35,105,110,116,101,103,101,114,45,108,101,110,103,116,104,32,120,41,0,0,0,0,0,0};
static C_char C_TLS li383[] C_aligned={C_lihdr(0,0,38),40,99,104,105,99,107,101,110,46,98,105,116,119,105,115,101,35,97,114,105,116,104,109,101,116,105,99,45,115,104,105,102,116,32,110,32,109,41,0,0};
static C_char C_TLS li384[] C_aligned={C_lihdr(0,0,13),40,108,111,111,112,32,97,114,103,115,32,120,41,0,0,0};
static C_char C_TLS li385[] C_aligned={C_lihdr(0,0,22),40,115,99,104,101,109,101,35,47,32,97,114,103,49,32,46,32,97,114,103,115,41,0,0};
static C_char C_TLS li386[] C_aligned={C_lihdr(0,0,15),40,35,35,115,121,115,35,47,45,50,32,120,32,121,41,0};
static C_char C_TLS li387[] C_aligned={C_lihdr(0,0,16),40,115,99,104,101,109,101,35,102,108,111,111,114,32,120,41};
static C_char C_TLS li388[] C_aligned={C_lihdr(0,0,18),40,115,99,104,101,109,101,35,99,101,105,108,105,110,103,32,120,41,0,0,0,0,0,0};
static C_char C_TLS li389[] C_aligned={C_lihdr(0,0,19),40,115,99,104,101,109,101,35,116,114,117,110,99,97,116,101,32,120,41,0,0,0,0,0};
static C_char C_TLS li390[] C_aligned={C_lihdr(0,0,16),40,115,99,104,101,109,101,35,114,111,117,110,100,32,120,41};
static C_char C_TLS li391[] C_aligned={C_lihdr(0,0,8),40,115,114,32,120,32,121,41};
static C_char C_TLS li392[] C_aligned={C_lihdr(0,0,24),40,102,105,110,100,45,114,97,116,105,111,45,98,101,116,119,101,101,110,32,120,32,121,41};
static C_char C_TLS li393[] C_aligned={C_lihdr(0,0,24),40,115,99,104,101,109,101,35,114,97,116,105,111,110,97,108,105,122,101,32,120,32,101,41};
static C_char C_TLS li394[] C_aligned={C_lihdr(0,0,13),40,108,111,111,112,32,105,32,109,32,120,115,41,0,0,0};
static C_char C_TLS li395[] C_aligned={C_lihdr(0,0,20),40,115,99,104,101,109,101,35,109,97,120,32,120,49,32,46,32,120,115,41,0,0,0,0};
static C_char C_TLS li396[] C_aligned={C_lihdr(0,0,13),40,108,111,111,112,32,105,32,109,32,120,115,41,0,0,0};
static C_char C_TLS li397[] C_aligned={C_lihdr(0,0,20),40,115,99,104,101,109,101,35,109,105,110,32,120,49,32,46,32,120,115,41,0,0,0,0};
static C_char C_TLS li398[] C_aligned={C_lihdr(0,0,14),40,115,99,104,101,109,101,35,101,120,112,32,110,41,0,0};
static C_char C_TLS li399[] C_aligned={C_lihdr(0,0,15),40,35,35,115,121,115,35,108,111,103,45,49,32,120,41,0};
static C_char C_TLS li400[] C_aligned={C_lihdr(0,0,21),40,115,99,104,101,109,101,35,108,111,103,32,97,32,46,32,114,101,115,116,41,0,0,0};
static C_char C_TLS li401[] C_aligned={C_lihdr(0,0,14),40,115,99,104,101,109,101,35,115,105,110,32,110,41,0,0};
static C_char C_TLS li402[] C_aligned={C_lihdr(0,0,14),40,115,99,104,101,109,101,35,99,111,115,32,110,41,0,0};
static C_char C_TLS li403[] C_aligned={C_lihdr(0,0,14),40,115,99,104,101,109,101,35,116,97,110,32,110,41,0,0};
static C_char C_TLS li404[] C_aligned={C_lihdr(0,0,15),40,115,99,104,101,109,101,35,97,115,105,110,32,110,41,0};
static C_char C_TLS li405[] C_aligned={C_lihdr(0,0,15),40,115,99,104,101,109,101,35,97,99,111,115,32,110,41,0};
static C_char C_TLS li406[] C_aligned={C_lihdr(0,0,22),40,115,99,104,101,109,101,35,97,116,97,110,32,110,32,46,32,114,101,115,116,41,0,0};
static C_char C_TLS li407[] C_aligned={C_lihdr(0,0,8),40,97,49,52,51,56,55,41};
static C_char C_TLS li408[] C_aligned={C_lihdr(0,0,34),67,95,117,95,105,110,116,101,103,101,114,95,113,117,111,116,105,101,110,116,95,97,110,100,95,114,101,109,97,105,110,100,101,114,0,0,0,0,0,0};
static C_char C_TLS li409[] C_aligned={C_lihdr(0,0,8),40,97,49,52,52,49,56,41};
static C_char C_TLS li410[] C_aligned={C_lihdr(0,0,20),40,97,49,52,52,51,52,32,113,50,53,56,54,32,117,50,53,56,56,41,0,0,0,0};
static C_char C_TLS li411[] C_aligned={C_lihdr(0,0,22),40,97,49,52,52,48,49,32,115,94,50,53,54,54,32,114,94,50,53,54,56,41,0,0};
static C_char C_TLS li412[] C_aligned={C_lihdr(0,0,28),40,35,35,115,121,115,35,101,120,97,99,116,45,105,110,116,101,103,101,114,45,115,113,114,116,32,97,41,0,0,0,0};
static C_char C_TLS li413[] C_aligned={C_lihdr(0,0,35),40,99,104,105,99,107,101,110,46,98,97,115,101,35,101,120,97,99,116,45,105,110,116,101,103,101,114,45,115,113,114,116,32,120,41,0,0,0,0,0};
static C_char C_TLS li414[] C_aligned={C_lihdr(0,0,8),40,97,49,52,53,55,53,41};
static C_char C_TLS li415[] C_aligned={C_lihdr(0,0,14),40,97,49,52,53,56,49,32,115,94,50,32,114,41,0,0};
static C_char C_TLS li416[] C_aligned={C_lihdr(0,0,8),40,97,49,52,54,48,51,41};
static C_char C_TLS li417[] C_aligned={C_lihdr(0,0,8),40,97,49,52,54,50,55,41};
static C_char C_TLS li418[] C_aligned={C_lihdr(0,0,16),40,97,49,52,54,51,57,32,100,115,94,50,32,100,114,41};
static C_char C_TLS li419[] C_aligned={C_lihdr(0,0,16),40,97,49,52,54,49,53,32,110,115,94,50,32,110,114,41};
static C_char C_TLS li420[] C_aligned={C_lihdr(0,0,22),40,35,35,115,121,115,35,115,113,114,116,47,108,111,99,32,108,111,99,32,110,41,0,0};
static C_char C_TLS li421[] C_aligned={C_lihdr(0,0,15),40,115,99,104,101,109,101,35,115,113,114,116,32,120,41,0};
static C_char C_TLS li422[] C_aligned={C_lihdr(0,0,41),40,99,104,105,99,107,101,110,46,98,97,115,101,35,101,120,97,99,116,45,105,110,116,101,103,101,114,45,110,116,104,45,114,111,111,116,32,107,32,110,41,0,0,0,0,0,0,0};
static C_char C_TLS li423[] C_aligned={C_lihdr(0,0,10),40,108,112,32,103,48,32,103,49,41,0,0,0,0,0,0};
static C_char C_TLS li424[] C_aligned={C_lihdr(0,0,42),40,35,35,115,121,115,35,101,120,97,99,116,45,105,110,116,101,103,101,114,45,110,116,104,45,114,111,111,116,47,108,111,99,32,108,111,99,32,107,32,110,41,0,0,0,0,0,0};
static C_char C_TLS li425[] C_aligned={C_lihdr(0,0,11),40,108,112,32,114,101,115,32,101,50,41,0,0,0,0,0};
static C_char C_TLS li426[] C_aligned={C_lihdr(0,0,28),40,35,35,115,121,115,35,105,110,116,101,103,101,114,45,112,111,119,101,114,32,98,97,115,101,32,101,41,0,0,0,0};
static C_char C_TLS li427[] C_aligned={C_lihdr(0,0,14),40,108,111,103,45,101,120,112,116,32,97,32,98,41,0,0};
static C_char C_TLS li428[] C_aligned={C_lihdr(0,0,15),40,115,108,111,119,45,101,120,112,116,32,97,32,98,41,0};
static C_char C_TLS li429[] C_aligned={C_lihdr(0,0,8),40,97,49,52,57,57,54,41};
static C_char C_TLS li430[] C_aligned={C_lihdr(0,0,15),40,97,49,53,48,48,56,32,100,115,94,110,32,114,41,0};
static C_char C_TLS li431[] C_aligned={C_lihdr(0,0,17),40,115,99,104,101,109,101,35,101,120,112,116,32,97,32,98,41,0,0,0,0,0,0,0};
static C_char C_TLS li432[] C_aligned={C_lihdr(0,0,28),40,35,35,115,121,115,35,105,110,116,101,114,110,97,108,45,103,99,100,32,108,111,99,32,97,32,98,41,0,0,0,0};
static C_char C_TLS li433[] C_aligned={C_lihdr(0,0,15),40,35,35,115,121,115,35,103,99,100,32,97,32,98,41,0};
static C_char C_TLS li434[] C_aligned={C_lihdr(0,0,16),40,108,111,111,112,32,104,101,97,100,32,110,101,120,116,41};
static C_char C_TLS li435[] C_aligned={C_lihdr(0,0,17),40,115,99,104,101,109,101,35,103,99,100,32,46,32,110,115,41,0,0,0,0,0,0,0};
static C_char C_TLS li436[] C_aligned={C_lihdr(0,0,15),40,35,35,115,121,115,35,108,99,109,32,120,32,121,41,0};
static C_char C_TLS li437[] C_aligned={C_lihdr(0,0,16),40,108,111,111,112,32,104,101,97,100,32,110,101,120,116,41};
static C_char C_TLS li438[] C_aligned={C_lihdr(0,0,17),40,115,99,104,101,109,101,35,108,99,109,32,46,32,110,115,41,0,0,0,0,0,0,0};
static C_char C_TLS li439[] C_aligned={C_lihdr(0,0,34),67,95,117,95,105,110,116,101,103,101,114,95,113,117,111,116,105,101,110,116,95,97,110,100,95,114,101,109,97,105,110,100,101,114,0,0,0,0,0,0};
static C_char C_TLS li440[] C_aligned={C_lihdr(0,0,8),40,97,49,53,51,53,57,41};
static C_char C_TLS li441[] C_aligned={C_lihdr(0,0,22),40,97,49,53,51,54,53,32,104,105,50,55,55,49,32,108,111,50,55,55,51,41,0,0};
static C_char C_TLS li442[] C_aligned={C_lihdr(0,0,61),40,35,35,115,121,115,35,105,110,116,101,103,101,114,45,62,115,116,114,105,110,103,47,114,101,99,117,114,115,105,118,101,32,110,32,98,97,115,101,32,101,120,112,101,99,116,101,100,45,115,116,114,105,110,103,45,115,105,122,101,41,0,0,0};
static C_char C_TLS li443[] C_aligned={C_lihdr(0,0,38),40,35,35,115,121,115,35,101,120,116,101,110,100,101,100,45,110,117,109,98,101,114,45,62,115,116,114,105,110,103,32,110,32,98,97,115,101,41,0,0};
static C_char C_TLS li444[] C_aligned={C_lihdr(0,0,20),40,114,111,117,110,100,45,113,117,111,116,105,101,110,116,32,110,32,100,41,0,0,0,0};
static C_char C_TLS li445[] C_aligned={C_lihdr(0,0,13),40,103,111,45,105,110,101,120,97,99,116,33,41,0,0,0};
static C_char C_TLS li446[] C_aligned={C_lihdr(0,0,23),40,115,97,102,101,45,101,120,112,111,110,101,110,116,32,118,97,108,117,101,32,101,41,0};
static C_char C_TLS li447[] C_aligned={C_lihdr(0,0,6),40,108,112,32,105,41,0,0};
static C_char C_TLS li448[] C_aligned={C_lihdr(0,0,19),40,115,99,97,110,45,100,105,103,105,116,115,32,115,116,97,114,116,41,0,0,0,0,0};
static C_char C_TLS li449[] C_aligned={C_lihdr(0,0,6),40,108,112,32,105,41,0,0};
static C_char C_TLS li450[] C_aligned={C_lihdr(0,0,19),40,115,99,97,110,45,104,97,115,104,101,115,32,115,116,97,114,116,41,0,0,0,0,0};
static C_char C_TLS li451[] C_aligned={C_lihdr(0,0,46),40,115,99,97,110,45,100,105,103,105,116,115,43,104,97,115,104,101,115,32,115,116,97,114,116,32,110,101,103,63,32,97,108,108,45,104,97,115,104,101,115,45,111,107,63,41,0,0};
static C_char C_TLS li452[] C_aligned={C_lihdr(0,0,21),40,115,99,97,110,45,101,120,112,111,110,101,110,116,32,115,116,97,114,116,41,0,0,0};
static C_char C_TLS li453[] C_aligned={C_lihdr(0,0,43),40,115,99,97,110,45,100,101,99,105,109,97,108,45,116,97,105,108,32,115,116,97,114,116,32,110,101,103,63,32,100,101,99,105,109,97,108,45,104,101,97,100,41,0,0,0,0,0};
static C_char C_TLS li454[] C_aligned={C_lihdr(0,0,23),40,115,99,97,110,45,117,114,101,97,108,32,115,116,97,114,116,32,110,101,103,63,41,0};
static C_char C_TLS li455[] C_aligned={C_lihdr(0,0,17),40,115,99,97,110,45,114,101,97,108,32,115,116,97,114,116,41,0,0,0,0,0,0,0};
static C_char C_TLS li456[] C_aligned={C_lihdr(0,0,50),40,35,35,115,121,115,35,115,116,114,105,110,103,45,62,99,111,109,112,110,117,109,32,114,97,100,105,120,32,115,116,114,32,111,102,102,115,101,116,32,101,120,97,99,116,110,101,115,115,41,0,0,0,0,0,0};
static C_char C_TLS li457[] C_aligned={C_lihdr(0,0,32),40,115,99,97,110,45,112,114,101,102,105,120,32,105,32,101,120,110,101,115,115,32,114,97,100,105,120,32,108,101,110,41};
static C_char C_TLS li458[] C_aligned={C_lihdr(0,0,34),40,115,99,104,101,109,101,35,115,116,114,105,110,103,45,62,110,117,109,98,101,114,32,115,116,114,32,46,32,114,101,115,116,41,0,0,0,0,0,0};
static C_char C_TLS li459[] C_aligned={C_lihdr(0,0,33),40,35,35,115,121,115,35,115,116,114,105,110,103,45,62,110,117,109,98,101,114,32,115,116,114,32,46,32,114,101,115,116,41,0,0,0,0,0,0,0};
static C_char C_TLS li460[] C_aligned={C_lihdr(0,0,18),67,95,102,105,120,110,117,109,95,116,111,95,115,116,114,105,110,103,0,0,0,0,0,0};
static C_char C_TLS li461[] C_aligned={C_lihdr(0,0,18),67,95,102,108,111,110,117,109,95,116,111,95,115,116,114,105,110,103,0,0,0,0,0,0};
static C_char C_TLS li462[] C_aligned={C_lihdr(0,0,19),67,95,105,110,116,101,103,101,114,95,116,111,95,115,116,114,105,110,103,0,0,0,0,0};
static C_char C_TLS li463[] C_aligned={C_lihdr(0,0,8),40,108,111,111,112,32,105,41};
static C_char C_TLS li464[] C_aligned={C_lihdr(0,0,25),40,99,111,109,112,97,114,101,45,115,108,111,116,115,32,120,32,121,32,115,116,97,114,116,41,0,0,0,0,0,0,0};
static C_char C_TLS li465[] C_aligned={C_lihdr(0,0,10),40,119,97,108,107,32,120,32,121,41,0,0,0,0,0,0};
static C_char C_TLS li466[] C_aligned={C_lihdr(0,0,26),40,99,104,105,99,107,101,110,46,98,97,115,101,35,101,113,117,97,108,61,63,32,120,32,121,41,0,0,0,0,0,0};
static C_char C_TLS li467[] C_aligned={C_lihdr(0,0,18),67,95,115,116,114,105,110,103,95,116,111,95,115,121,109,98,111,108,0,0,0,0,0,0};
static C_char C_TLS li468[] C_aligned={C_lihdr(0,0,19),67,95,115,116,114,105,110,103,95,116,111,95,107,101,121,119,111,114,100,0,0,0,0,0};
static C_char C_TLS li469[] C_aligned={C_lihdr(0,0,26),40,35,35,115,121,115,35,105,110,116,101,114,110,101,100,45,115,121,109,98,111,108,63,32,120,41,0,0,0,0,0,0};
static C_char C_TLS li470[] C_aligned={C_lihdr(0,0,26),40,35,35,115,121,115,35,115,116,114,105,110,103,45,62,115,121,109,98,111,108,32,115,116,114,41,0,0,0,0,0,0};
static C_char C_TLS li471[] C_aligned={C_lihdr(0,0,24),40,35,35,115,121,115,35,115,121,109,98,111,108,45,62,115,116,114,105,110,103,32,115,41};
static C_char C_TLS li472[] C_aligned={C_lihdr(0,0,25),40,115,99,104,101,109,101,35,115,121,109,98,111,108,45,62,115,116,114,105,110,103,32,115,41,0,0,0,0,0,0,0};
static C_char C_TLS li473[] C_aligned={C_lihdr(0,0,27),40,115,99,104,101,109,101,35,115,116,114,105,110,103,45,62,115,121,109,98,111,108,32,115,116,114,41,0,0,0,0,0};
static C_char C_TLS li474[] C_aligned={C_lihdr(0,0,13),67,95,109,97,107,101,95,115,121,109,98,111,108,0,0,0};
static C_char C_TLS li475[] C_aligned={C_lihdr(0,0,44),40,99,104,105,99,107,101,110,46,98,97,115,101,35,115,116,114,105,110,103,45,62,117,110,105,110,116,101,114,110,101,100,45,115,121,109,98,111,108,32,115,116,114,41,0,0,0,0};
static C_char C_TLS li476[] C_aligned={C_lihdr(0,0,13),67,95,109,97,107,101,95,115,121,109,98,111,108,0,0,0};
static C_char C_TLS li477[] C_aligned={C_lihdr(0,0,34),40,99,104,105,99,107,101,110,46,98,97,115,101,35,103,101,110,115,121,109,32,46,32,115,116,114,45,111,114,45,115,121,109,41,0,0,0,0,0,0};
static C_char C_TLS li478[] C_aligned={C_lihdr(0,0,20),40,109,97,112,45,108,111,111,112,51,51,56,51,32,103,51,51,57,53,41,0,0,0,0};
static C_char C_TLS li479[] C_aligned={C_lihdr(0,0,33),40,99,104,105,99,107,101,110,46,98,97,115,101,35,115,121,109,98,111,108,45,97,112,112,101,110,100,32,46,32,115,115,41,0,0,0,0,0,0,0};
static C_char C_TLS li480[] C_aligned={C_lihdr(0,0,28),40,99,104,105,99,107,101,110,46,107,101,121,119,111,114,100,35,107,101,121,119,111,114,100,63,32,120,41,0,0,0,0};
static C_char C_TLS li481[] C_aligned={C_lihdr(0,0,35),40,99,104,105,99,107,101,110,46,107,101,121,119,111,114,100,35,115,116,114,105,110,103,45,62,107,101,121,119,111,114,100,32,115,41,0,0,0,0,0};
static C_char C_TLS li482[] C_aligned={C_lihdr(0,0,36),40,99,104,105,99,107,101,110,46,107,101,121,119,111,114,100,35,107,101,121,119,111,114,100,45,62,115,116,114,105,110,103,32,107,119,41,0,0,0,0};
static C_char C_TLS li483[] C_aligned={C_lihdr(0,0,45),40,99,104,105,99,107,101,110,46,107,101,121,119,111,114,100,35,103,101,116,45,107,101,121,119,111,114,100,32,107,101,121,32,97,114,103,115,32,46,32,114,101,115,116,41,0,0,0};
static C_char C_TLS li484[] C_aligned={C_lihdr(0,0,22),40,35,35,115,121,115,35,109,97,107,101,45,98,108,111,98,32,115,105,122,101,41,0,0};
static C_char C_TLS li485[] C_aligned={C_lihdr(0,0,29),40,99,104,105,99,107,101,110,46,98,108,111,98,35,109,97,107,101,45,98,108,111,98,32,115,105,122,101,41,0,0,0};
static C_char C_TLS li486[] C_aligned={C_lihdr(0,0,22),40,99,104,105,99,107,101,110,46,98,108,111,98,35,98,108,111,98,63,32,120,41,0,0};
static C_char C_TLS li487[] C_aligned={C_lihdr(0,0,27),40,99,104,105,99,107,101,110,46,98,108,111,98,35,98,108,111,98,45,115,105,122,101,32,98,118,41,0,0,0,0,0};
static C_char C_TLS li488[] C_aligned={C_lihdr(0,0,29),40,99,104,105,99,107,101,110,46,98,108,111,98,35,115,116,114,105,110,103,45,62,98,108,111,98,32,115,41,0,0,0};
static C_char C_TLS li489[] C_aligned={C_lihdr(0,0,30),40,99,104,105,99,107,101,110,46,98,108,111,98,35,98,108,111,98,45,62,115,116,114,105,110,103,32,98,118,41,0,0};
static C_char C_TLS li490[] C_aligned={C_lihdr(0,0,27),40,99,104,105,99,107,101,110,46,98,108,111,98,35,98,108,111,98,61,63,32,98,49,32,98,50,41,0,0,0,0,0};
static C_char C_TLS li491[] C_aligned={C_lihdr(0,0,32),40,115,99,104,101,109,101,35,109,97,107,101,45,118,101,99,116,111,114,32,115,105,122,101,32,46,32,102,105,108,108,41};
static C_char C_TLS li492[] C_aligned={C_lihdr(0,0,8),40,108,111,111,112,32,105,41};
static C_char C_TLS li493[] C_aligned={C_lihdr(0,0,26),40,115,99,104,101,109,101,35,108,105,115,116,45,62,118,101,99,116,111,114,32,108,115,116,48,41,0,0,0,0,0,0};
static C_char C_TLS li494[] C_aligned={C_lihdr(0,0,8),40,108,111,111,112,32,105,41};
static C_char C_TLS li495[] C_aligned={C_lihdr(0,0,23),40,115,99,104,101,109,101,35,118,101,99,116,111,114,45,62,108,105,115,116,32,118,41,0};
static C_char C_TLS li496[] C_aligned={C_lihdr(0,0,20),40,115,99,104,101,109,101,35,118,101,99,116,111,114,32,46,32,120,115,41,0,0,0,0};
static C_char C_TLS li497[] C_aligned={C_lihdr(0,0,12),40,100,111,108,111,111,112,51,53,50,48,41,0,0,0,0};
static C_char C_TLS li498[] C_aligned={C_lihdr(0,0,25),40,115,99,104,101,109,101,35,118,101,99,116,111,114,45,102,105,108,108,33,32,118,32,120,41,0,0,0,0,0,0,0};
static C_char C_TLS li499[] C_aligned={C_lihdr(0,0,12),40,100,111,108,111,111,112,51,53,51,50,41,0,0,0,0};
static C_char C_TLS li500[] C_aligned={C_lihdr(0,0,39),40,99,104,105,99,107,101,110,46,98,97,115,101,35,118,101,99,116,111,114,45,99,111,112,121,33,32,102,114,111,109,32,116,111,32,46,32,110,41,0};
static C_char C_TLS li501[] C_aligned={C_lihdr(0,0,12),40,100,111,108,111,111,112,51,53,54,51,41,0,0,0,0};
static C_char C_TLS li502[] C_aligned={C_lihdr(0,0,35),40,99,104,105,99,107,101,110,46,98,97,115,101,35,115,117,98,118,101,99,116,111,114,32,118,32,105,32,46,32,114,101,115,116,41,0,0,0,0,0};
static C_char C_TLS li503[] C_aligned={C_lihdr(0,0,39),40,99,104,105,99,107,101,110,46,98,97,115,101,35,118,101,99,116,111,114,45,114,101,115,105,122,101,32,118,32,110,32,46,32,114,101,115,116,41,0};
static C_char C_TLS li504[] C_aligned={C_lihdr(0,0,12),40,100,111,108,111,111,112,51,53,57,49,41,0,0,0,0};
static C_char C_TLS li505[] C_aligned={C_lihdr(0,0,30),40,35,35,115,121,115,35,118,101,99,116,111,114,45,114,101,115,105,122,101,32,118,32,110,32,105,110,105,116,41,0,0};
static C_char C_TLS li506[] C_aligned={C_lihdr(0,0,22),40,115,99,104,101,109,101,35,99,104,97,114,45,99,105,61,63,32,120,32,121,41,0,0};
static C_char C_TLS li507[] C_aligned={C_lihdr(0,0,22),40,115,99,104,101,109,101,35,99,104,97,114,45,99,105,62,63,32,120,32,121,41,0,0};
static C_char C_TLS li508[] C_aligned={C_lihdr(0,0,22),40,115,99,104,101,109,101,35,99,104,97,114,45,99,105,60,63,32,120,32,121,41,0,0};
static C_char C_TLS li509[] C_aligned={C_lihdr(0,0,23),40,115,99,104,101,109,101,35,99,104,97,114,45,99,105,62,61,63,32,120,32,121,41,0};
static C_char C_TLS li510[] C_aligned={C_lihdr(0,0,23),40,115,99,104,101,109,101,35,99,104,97,114,45,99,105,60,61,63,32,120,32,121,41,0};
static C_char C_TLS li511[] C_aligned={C_lihdr(0,0,6),40,108,111,111,112,41,0,0};
static C_char C_TLS li512[] C_aligned={C_lihdr(0,0,15),40,108,111,111,107,117,112,45,99,104,97,114,32,99,41,0};
static C_char C_TLS li513[] C_aligned={C_lihdr(0,0,30),40,99,104,105,99,107,101,110,46,98,97,115,101,35,99,104,97,114,45,110,97,109,101,32,120,32,46,32,121,41,0,0};
static C_char C_TLS li514[] C_aligned={C_lihdr(0,0,9),67,95,99,97,108,108,95,99,99,0,0,0,0,0,0,0};
static C_char C_TLS li515[] C_aligned={C_lihdr(0,0,19),67,95,99,97,108,108,95,119,105,116,104,95,99,116,104,117,108,104,117,0,0,0,0,0};
static C_char C_TLS li516[] C_aligned={C_lihdr(0,0,10),40,108,111,111,112,32,108,115,116,41,0,0,0,0,0,0};
static C_char C_TLS li517[] C_aligned={C_lihdr(0,0,23),40,35,35,115,121,115,35,102,111,114,45,101,97,99,104,32,112,32,108,115,116,48,41,0};
static C_char C_TLS li518[] C_aligned={C_lihdr(0,0,10),40,108,111,111,112,32,108,115,116,41,0,0,0,0,0,0};
static C_char C_TLS li519[] C_aligned={C_lihdr(0,0,18),40,35,35,115,121,115,35,109,97,112,32,112,32,108,115,116,48,41,0,0,0,0,0,0};
static C_char C_TLS li520[] C_aligned={C_lihdr(0,0,9),40,108,112,32,108,115,116,115,41,0,0,0,0,0,0,0};
static C_char C_TLS li521[] C_aligned={C_lihdr(0,0,14),40,97,49,56,53,49,54,32,101,109,112,116,121,41,0,0};
static C_char C_TLS li522[] C_aligned={C_lihdr(0,0,24),40,109,97,112,115,97,102,101,51,54,54,55,32,112,32,108,115,116,115,32,108,111,99,41};
static C_char C_TLS li523[] C_aligned={C_lihdr(0,0,25),40,102,111,114,45,101,97,99,104,45,108,111,111,112,51,54,56,55,32,103,51,54,57,52,41,0,0,0,0,0,0,0};
static C_char C_TLS li524[] C_aligned={C_lihdr(0,0,10),40,97,49,56,54,51,56,32,120,41,0,0,0,0,0,0};
static C_char C_TLS li525[] C_aligned={C_lihdr(0,0,10),40,97,49,56,54,52,52,32,120,41,0,0,0,0,0,0};
static C_char C_TLS li526[] C_aligned={C_lihdr(0,0,10),40,108,111,111,112,32,97,108,108,41,0,0,0,0,0,0};
static C_char C_TLS li527[] C_aligned={C_lihdr(0,0,32),40,115,99,104,101,109,101,35,102,111,114,45,101,97,99,104,32,102,110,32,108,115,116,49,32,46,32,108,115,116,115,41};
static C_char C_TLS li528[] C_aligned={C_lihdr(0,0,20),40,109,97,112,45,108,111,111,112,51,55,49,53,32,103,51,55,50,55,41,0,0,0,0};
static C_char C_TLS li529[] C_aligned={C_lihdr(0,0,10),40,97,49,56,55,51,57,32,120,41,0,0,0,0,0,0};
static C_char C_TLS li530[] C_aligned={C_lihdr(0,0,10),40,97,49,56,55,52,53,32,120,41,0,0,0,0,0,0};
static C_char C_TLS li531[] C_aligned={C_lihdr(0,0,10),40,108,111,111,112,32,97,108,108,41,0,0,0,0,0,0};
static C_char C_TLS li532[] C_aligned={C_lihdr(0,0,27),40,115,99,104,101,109,101,35,109,97,112,32,102,110,32,108,115,116,49,32,46,32,108,115,116,115,41,0,0,0,0,0};
static C_char C_TLS li533[] C_aligned={C_lihdr(0,0,18),40,97,49,56,55,54,53,32,46,32,114,101,115,117,108,116,115,41,0,0,0,0,0,0};
static C_char C_TLS li534[] C_aligned={C_lihdr(0,0,40),40,115,99,104,101,109,101,35,100,121,110,97,109,105,99,45,119,105,110,100,32,98,101,102,111,114,101,32,116,104,117,110,107,32,97,102,116,101,114,41};
static C_char C_TLS li535[] C_aligned={C_lihdr(0,0,24),40,99,111,110,116,105,110,117,97,116,105,111,110,32,46,32,114,101,115,117,108,116,115,41};
static C_char C_TLS li536[] C_aligned={C_lihdr(0,0,13),40,97,49,56,55,56,57,32,99,111,110,116,41,0,0,0};
static C_char C_TLS li537[] C_aligned={C_lihdr(0,0,44),40,115,99,104,101,109,101,35,99,97,108,108,45,119,105,116,104,45,99,117,114,114,101,110,116,45,99,111,110,116,105,110,117,97,116,105,111,110,32,112,114,111,99,41,0,0,0,0};
static C_char C_TLS li538[] C_aligned={C_lihdr(0,0,30),40,35,35,115,121,115,35,100,121,110,97,109,105,99,45,117,110,119,105,110,100,32,119,105,110,100,115,32,110,41,0,0};
static C_char C_TLS li539[] C_aligned={C_lihdr(0,0,22),40,99,104,105,99,107,101,110,46,98,97,115,101,35,112,111,114,116,63,32,120,41,0,0};
static C_char C_TLS li540[] C_aligned={C_lihdr(0,0,33),40,99,104,105,99,107,101,110,46,98,97,115,101,35,105,110,112,117,116,45,112,111,114,116,45,111,112,101,110,63,32,112,41,0,0,0,0,0,0,0};
static C_char C_TLS li541[] C_aligned={C_lihdr(0,0,34),40,99,104,105,99,107,101,110,46,98,97,115,101,35,111,117,116,112,117,116,45,112,111,114,116,45,111,112,101,110,63,32,112,41,0,0,0,0,0,0};
static C_char C_TLS li542[] C_aligned={C_lihdr(0,0,29),40,99,104,105,99,107,101,110,46,98,97,115,101,35,112,111,114,116,45,99,108,111,115,101,100,63,32,112,41,0,0,0};
static C_char C_TLS li543[] C_aligned={C_lihdr(0,0,37),40,35,35,115,121,115,35,109,97,107,101,45,112,111,114,116,32,105,47,111,32,99,108,97,115,115,32,110,97,109,101,32,116,121,112,101,41,0,0,0};
static C_char C_TLS li544[] C_aligned={C_lihdr(0,0,6),40,108,111,111,112,41,0,0};
static C_char C_TLS li545[] C_aligned={C_lihdr(0,0,10),40,97,51,50,48,55,54,32,112,41,0,0,0,0,0,0};
static C_char C_TLS li546[] C_aligned={C_lihdr(0,0,6),40,108,111,111,112,41,0,0};
static C_char C_TLS li547[] C_aligned={C_lihdr(0,0,10),40,97,51,50,49,49,54,32,112,41,0,0,0,0,0,0};
static C_char C_TLS li548[] C_aligned={C_lihdr(0,0,12),40,97,51,50,49,53,54,32,112,32,99,41,0,0,0,0};
static C_char C_TLS li549[] C_aligned={C_lihdr(0,0,12),40,97,51,50,49,53,57,32,112,32,115,41,0,0,0,0};
static C_char C_TLS li550[] C_aligned={C_lihdr(0,0,12),40,97,51,50,49,54,50,32,112,32,100,41,0,0,0,0};
static C_char C_TLS li551[] C_aligned={C_lihdr(0,0,10),40,97,51,50,49,54,56,32,112,41,0,0,0,0,0,0};
static C_char C_TLS li552[] C_aligned={C_lihdr(0,0,10),40,97,51,50,49,55,49,32,112,41,0,0,0,0,0,0};
static C_char C_TLS li553[] C_aligned={C_lihdr(0,0,8),40,97,51,50,50,48,56,41};
static C_char C_TLS li554[] C_aligned={C_lihdr(0,0,20),40,108,111,111,112,32,114,101,109,32,97,99,116,32,115,116,97,114,116,41,0,0,0,0};
static C_char C_TLS li555[] C_aligned={C_lihdr(0,0,23),40,97,51,50,49,55,52,32,112,32,110,32,100,101,115,116,32,115,116,97,114,116,41,0};
static C_char C_TLS li556[] C_aligned={C_lihdr(0,0,8),40,97,51,50,51,54,57,41};
static C_char C_TLS li557[] C_aligned={C_lihdr(0,0,32),40,108,111,111,112,32,108,101,110,32,108,105,109,105,116,32,98,117,102,102,101,114,32,114,101,115,117,108,116,32,102,41};
static C_char C_TLS li558[] C_aligned={C_lihdr(0,0,17),40,97,51,50,50,55,51,32,112,32,114,108,105,109,105,116,41,0,0,0,0,0,0,0};
static C_char C_TLS li559[] C_aligned={C_lihdr(0,0,16),67,95,111,112,101,110,95,102,105,108,101,95,112,111,114,116};
static C_char C_TLS li560[] C_aligned={C_lihdr(0,0,37),40,35,35,115,121,115,35,99,104,101,99,107,45,105,110,112,117,116,45,112,111,114,116,32,120,32,111,112,101,110,32,46,32,108,111,99,41,0,0,0};
static C_char C_TLS li561[] C_aligned={C_lihdr(0,0,38),40,35,35,115,121,115,35,99,104,101,99,107,45,111,117,116,112,117,116,45,112,111,114,116,32,120,32,111,112,101,110,32,46,32,108,111,99,41,0,0};
static C_char C_TLS li562[] C_aligned={C_lihdr(0,0,26),40,35,35,115,121,115,35,99,104,101,99,107,45,112,111,114,116,32,120,32,46,32,108,111,99,41,0,0,0,0,0,0};
static C_char C_TLS li563[] C_aligned={C_lihdr(0,0,31),40,35,35,115,121,115,35,99,104,101,99,107,45,111,112,101,110,45,112,111,114,116,32,120,32,46,32,108,111,99,41,0};
static C_char C_TLS li564[] C_aligned={C_lihdr(0,0,10),40,98,111,100,121,51,56,57,53,41,0,0,0,0,0,0};
static C_char C_TLS li565[] C_aligned={C_lihdr(0,0,34),40,115,99,104,101,109,101,35,99,117,114,114,101,110,116,45,105,110,112,117,116,45,112,111,114,116,32,46,32,97,114,103,115,41,0,0,0,0,0,0};
static C_char C_TLS li566[] C_aligned={C_lihdr(0,0,10),40,98,111,100,121,51,57,50,48,41,0,0,0,0,0,0};
static C_char C_TLS li567[] C_aligned={C_lihdr(0,0,35),40,115,99,104,101,109,101,35,99,117,114,114,101,110,116,45,111,117,116,112,117,116,45,112,111,114,116,32,46,32,97,114,103,115,41,0,0,0,0,0};
static C_char C_TLS li568[] C_aligned={C_lihdr(0,0,10),40,98,111,100,121,51,57,52,53,41,0,0,0,0,0,0};
static C_char C_TLS li569[] C_aligned={C_lihdr(0,0,40),40,99,104,105,99,107,101,110,46,98,97,115,101,35,99,117,114,114,101,110,116,45,101,114,114,111,114,45,112,111,114,116,32,46,32,97,114,103,115,41};
static C_char C_TLS li570[] C_aligned={C_lihdr(0,0,22),40,35,35,115,121,115,35,116,116,121,45,112,111,114,116,63,32,112,111,114,116,41,0,0};
static C_char C_TLS li571[] C_aligned={C_lihdr(0,0,22),40,35,35,115,121,115,35,112,111,114,116,45,100,97,116,97,32,112,111,114,116,41,0,0};
static C_char C_TLS li572[] C_aligned={C_lihdr(0,0,32),40,35,35,115,121,115,35,115,101,116,45,112,111,114,116,45,100,97,116,97,33,32,112,111,114,116,32,100,97,116,97,41};
static C_char C_TLS li573[] C_aligned={C_lihdr(0,0,18),40,100,111,108,111,111,112,51,57,56,50,32,109,111,100,101,115,41,0,0,0,0,0,0};
static C_char C_TLS li574[] C_aligned={C_lihdr(0,0,25),40,111,112,101,110,32,110,97,109,101,32,105,110,112,32,109,111,100,101,115,32,108,111,99,41,0,0,0,0,0,0,0};
static C_char C_TLS li575[] C_aligned={C_lihdr(0,0,20),40,99,108,111,115,101,32,112,111,114,116,32,105,110,112,32,108,111,99,41,0,0,0,0};
static C_char C_TLS li576[] C_aligned={C_lihdr(0,0,36),40,115,99,104,101,109,101,35,111,112,101,110,45,105,110,112,117,116,45,102,105,108,101,32,110,97,109,101,32,46,32,109,111,100,101,41,0,0,0,0};
static C_char C_TLS li577[] C_aligned={C_lihdr(0,0,37),40,115,99,104,101,109,101,35,111,112,101,110,45,111,117,116,112,117,116,45,102,105,108,101,32,110,97,109,101,32,46,32,109,111,100,101,41,0,0,0};
static C_char C_TLS li578[] C_aligned={C_lihdr(0,0,30),40,115,99,104,101,109,101,35,99,108,111,115,101,45,105,110,112,117,116,45,112,111,114,116,32,112,111,114,116,41,0,0};
static C_char C_TLS li579[] C_aligned={C_lihdr(0,0,31),40,115,99,104,101,109,101,35,99,108,111,115,101,45,111,117,116,112,117,116,45,112,111,114,116,32,112,111,114,116,41,0};
static C_char C_TLS li580[] C_aligned={C_lihdr(0,0,8),40,97,49,57,51,56,49,41};
static C_char C_TLS li581[] C_aligned={C_lihdr(0,0,18),40,97,49,57,51,56,55,32,46,32,114,101,115,117,108,116,115,41,0,0,0,0,0,0};
static C_char C_TLS li582[] C_aligned={C_lihdr(0,0,43),40,115,99,104,101,109,101,35,99,97,108,108,45,119,105,116,104,45,105,110,112,117,116,45,102,105,108,101,32,110,97,109,101,32,112,32,46,32,109,111,100,101,41,0,0,0,0,0};
static C_char C_TLS li583[] C_aligned={C_lihdr(0,0,8),40,97,49,57,52,48,53,41};
static C_char C_TLS li584[] C_aligned={C_lihdr(0,0,18),40,97,49,57,52,49,49,32,46,32,114,101,115,117,108,116,115,41,0,0,0,0,0,0};
static C_char C_TLS li585[] C_aligned={C_lihdr(0,0,44),40,115,99,104,101,109,101,35,99,97,108,108,45,119,105,116,104,45,111,117,116,112,117,116,45,102,105,108,101,32,110,97,109,101,32,112,32,46,32,109,111,100,101,41,0,0,0,0};
static C_char C_TLS li586[] C_aligned={C_lihdr(0,0,8),40,97,49,57,52,50,57,41};
static C_char C_TLS li587[] C_aligned={C_lihdr(0,0,18),40,97,49,57,52,52,48,32,46,32,114,101,115,117,108,116,115,41,0,0,0,0,0,0};
static C_char C_TLS li588[] C_aligned={C_lihdr(0,0,8),40,97,49,57,52,51,52,41};
static C_char C_TLS li589[] C_aligned={C_lihdr(0,0,8),40,97,49,57,52,52,57,41};
static C_char C_TLS li590[] C_aligned={C_lihdr(0,0,46),40,115,99,104,101,109,101,35,119,105,116,104,45,105,110,112,117,116,45,102,114,111,109,45,102,105,108,101,32,115,116,114,32,116,104,117,110,107,32,46,32,109,111,100,101,41,0,0};
static C_char C_TLS li591[] C_aligned={C_lihdr(0,0,8),40,97,49,57,52,54,51,41};
static C_char C_TLS li592[] C_aligned={C_lihdr(0,0,18),40,97,49,57,52,55,52,32,46,32,114,101,115,117,108,116,115,41,0,0,0,0,0,0};
static C_char C_TLS li593[] C_aligned={C_lihdr(0,0,8),40,97,49,57,52,54,56,41};
static C_char C_TLS li594[] C_aligned={C_lihdr(0,0,8),40,97,49,57,52,56,51,41};
static C_char C_TLS li595[] C_aligned={C_lihdr(0,0,45),40,115,99,104,101,109,101,35,119,105,116,104,45,111,117,116,112,117,116,45,116,111,45,102,105,108,101,32,115,116,114,32,116,104,117,110,107,32,46,32,109,111,100,101,41,0,0,0};
static C_char C_TLS li596[] C_aligned={C_lihdr(0,0,40),40,35,35,115,121,115,35,102,105,108,101,45,101,120,105,115,116,115,63,32,110,97,109,101,32,102,105,108,101,63,32,100,105,114,63,32,108,111,99,41};
static C_char C_TLS li597[] C_aligned={C_lihdr(0,0,25),40,35,35,115,121,115,35,102,108,117,115,104,45,111,117,116,112,117,116,32,112,111,114,116,41,0,0,0,0,0,0,0};
static C_char C_TLS li598[] C_aligned={C_lihdr(0,0,34),40,99,104,105,99,107,101,110,46,98,97,115,101,35,102,108,117,115,104,45,111,117,116,112,117,116,32,46,32,114,101,115,116,41,0,0,0,0,0,0};
static C_char C_TLS li599[] C_aligned={C_lihdr(0,0,22),40,35,35,115,121,115,35,112,111,114,116,45,108,105,110,101,32,112,111,114,116,41,0,0};
static C_char C_TLS li600[] C_aligned={C_lihdr(0,0,14),40,100,111,108,111,111,112,52,49,49,50,32,105,41,0,0};
static C_char C_TLS li601[] C_aligned={C_lihdr(0,0,8),40,108,111,111,112,32,105,41};
static C_char C_TLS li602[] C_aligned={C_lihdr(0,0,43),40,35,35,115,121,115,35,100,101,99,111,114,97,116,101,45,108,97,109,98,100,97,32,112,114,111,99,32,112,114,101,100,32,100,101,99,111,114,97,116,111,114,41,0,0,0,0,0};
static C_char C_TLS li603[] C_aligned={C_lihdr(0,0,8),40,108,111,111,112,32,105,41};
static C_char C_TLS li604[] C_aligned={C_lihdr(0,0,35),40,35,35,115,121,115,35,108,97,109,98,100,97,45,100,101,99,111,114,97,116,105,111,110,32,112,114,111,99,32,112,114,101,100,41,0,0,0,0,0};
static C_char C_TLS li605[] C_aligned={C_lihdr(0,0,28),40,35,35,115,121,115,35,109,97,107,101,45,108,97,109,98,100,97,45,105,110,102,111,32,115,116,114,41,0,0,0,0};
static C_char C_TLS li606[] C_aligned={C_lihdr(0,0,22),40,35,35,115,121,115,35,108,97,109,98,100,97,45,105,110,102,111,63,32,120,41,0,0};
static C_char C_TLS li607[] C_aligned={C_lihdr(0,0,24),40,35,35,115,121,115,35,108,97,109,98,100,97,45,105,110,102,111,32,112,114,111,99,41};
static C_char C_TLS li608[] C_aligned={C_lihdr(0,0,32),40,35,35,115,121,115,35,108,97,109,98,100,97,45,105,110,102,111,45,62,115,116,114,105,110,103,32,105,110,102,111,41};
static C_char C_TLS li609[] C_aligned={C_lihdr(0,0,38),40,99,104,105,99,107,101,110,46,98,97,115,101,35,112,114,111,99,101,100,117,114,101,45,105,110,102,111,114,109,97,116,105,111,110,32,120,41,0,0};
static C_char C_TLS li610[] C_aligned={C_lihdr(0,0,12),40,97,49,57,55,54,49,32,112,32,105,41,0,0,0,0};
static C_char C_TLS li611[] C_aligned={C_lihdr(0,0,10),40,97,49,57,55,55,49,32,120,41,0,0,0,0,0,0};
static C_char C_TLS li612[] C_aligned={C_lihdr(0,0,15),40,97,49,57,55,56,55,32,112,114,111,99,32,105,41,0};
static C_char C_TLS li613[] C_aligned={C_lihdr(0,0,48),40,99,104,105,99,107,101,110,46,98,97,115,101,35,103,101,116,116,101,114,45,119,105,116,104,45,115,101,116,116,101,114,32,103,101,116,32,115,101,116,32,46,32,114,101,115,116,41};
static C_char C_TLS li614[] C_aligned={C_lihdr(0,0,11),40,102,95,50,48,48,52,52,32,120,41,0,0,0,0,0};
static C_char C_TLS li615[] C_aligned={C_lihdr(0,0,28),40,97,115,115,105,103,110,32,118,97,108,32,110,32,99,111,110,118,101,114,116,63,32,115,101,116,63,41,0,0,0,0};
static C_char C_TLS li616[] C_aligned={C_lihdr(0,0,24),40,98,111,100,121,52,50,54,51,32,99,111,110,118,101,114,116,63,32,115,101,116,63,41};
static C_char C_TLS li617[] C_aligned={C_lihdr(0,0,24),40,100,101,102,45,115,101,116,63,52,50,54,54,32,37,99,111,110,118,101,114,116,63,41};
static C_char C_TLS li618[] C_aligned={C_lihdr(0,0,18),40,100,101,102,45,99,111,110,118,101,114,116,63,52,50,54,53,41,0,0,0,0,0,0};
static C_char C_TLS li619[] C_aligned={C_lihdr(0,0,15),40,97,49,57,57,51,53,32,46,32,97,114,103,115,41,0};
static C_char C_TLS li620[] C_aligned={C_lihdr(0,0,12),40,97,50,48,48,49,55,32,118,97,108,41,0,0,0,0};
static C_char C_TLS li621[] C_aligned={C_lihdr(0,0,41),40,99,104,105,99,107,101,110,46,98,97,115,101,35,109,97,107,101,45,112,97,114,97,109,101,116,101,114,32,105,110,105,116,32,46,32,114,101,115,116,41,0,0,0,0,0,0,0};
static C_char C_TLS li622[] C_aligned={C_lihdr(0,0,27),40,115,99,104,101,109,101,35,99,104,97,114,45,114,101,97,100,121,63,32,46,32,114,101,115,116,41,0,0,0,0,0};
static C_char C_TLS li623[] C_aligned={C_lihdr(0,0,25),40,115,99,104,101,109,101,35,114,101,97,100,45,99,104,97,114,32,46,32,114,101,115,116,41,0,0,0,0,0,0,0};
static C_char C_TLS li624[] C_aligned={C_lihdr(0,0,21),40,35,35,115,121,115,35,114,101,97,100,45,99,104,97,114,45,48,32,112,41,0,0,0};
static C_char C_TLS li625[] C_aligned={C_lihdr(0,0,27),40,35,35,115,121,115,35,114,101,97,100,45,99,104,97,114,47,112,111,114,116,32,112,111,114,116,41,0,0,0,0,0};
static C_char C_TLS li626[] C_aligned={C_lihdr(0,0,21),40,35,35,115,121,115,35,112,101,101,107,45,99,104,97,114,45,48,32,112,41,0,0,0};
static C_char C_TLS li627[] C_aligned={C_lihdr(0,0,25),40,115,99,104,101,109,101,35,112,101,101,107,45,99,104,97,114,32,46,32,114,101,115,116,41,0,0,0,0,0,0,0};
static C_char C_TLS li628[] C_aligned={C_lihdr(0,0,20),40,115,99,104,101,109,101,35,114,101,97,100,32,46,32,114,101,115,116,41,0,0,0,0};
static C_char C_TLS li629[] C_aligned={C_lihdr(0,0,24),40,35,35,115,121,115,35,114,101,97,100,45,112,114,111,109,112,116,45,104,111,111,107,41};
static C_char C_TLS li630[] C_aligned={C_lihdr(0,0,27),40,35,35,115,121,115,35,105,110,102,105,120,45,108,105,115,116,45,104,111,111,107,32,108,115,116,41,0,0,0,0,0};
static C_char C_TLS li631[] C_aligned={C_lihdr(0,0,32),40,35,35,115,121,115,35,115,104,97,114,112,45,110,117,109,98,101,114,45,104,111,111,107,32,112,111,114,116,32,110,41};
static C_char C_TLS li632[] C_aligned={C_lihdr(0,0,36),40,35,35,115,121,115,35,114,101,97,100,45,119,97,114,110,105,110,103,32,112,111,114,116,32,109,115,103,32,46,32,97,114,103,115,41,0,0,0,0};
static C_char C_TLS li633[] C_aligned={C_lihdr(0,0,34),40,35,35,115,121,115,35,114,101,97,100,45,101,114,114,111,114,32,112,111,114,116,32,109,115,103,32,46,32,97,114,103,115,41,0,0,0,0,0,0};
static C_char C_TLS li634[] C_aligned={C_lihdr(0,0,11),40,102,95,50,48,51,50,49,32,99,41,0,0,0,0,0};
static C_char C_TLS li635[] C_aligned={C_lihdr(0,0,21),40,105,110,102,111,32,99,108,97,115,115,32,100,97,116,97,32,118,97,108,41,0,0,0};
static C_char C_TLS li636[] C_aligned={C_lihdr(0,0,8),40,115,107,105,112,32,99,41};
static C_char C_TLS li637[] C_aligned={C_lihdr(0,0,13),40,115,107,105,112,45,116,111,45,101,111,108,41,0,0,0};
static C_char C_TLS li638[] C_aligned={C_lihdr(0,0,22),40,114,101,115,101,114,118,101,100,45,99,104,97,114,97,99,116,101,114,32,99,41,0,0};
static C_char C_TLS li639[] C_aligned={C_lihdr(0,0,29),40,114,101,97,100,45,117,110,114,101,115,101,114,118,101,100,45,99,104,97,114,45,48,32,112,111,114,116,41,0,0,0};
static C_char C_TLS li640[] C_aligned={C_lihdr(0,0,8),40,108,111,111,112,32,99,41};
static C_char C_TLS li641[] C_aligned={C_lihdr(0,0,10),40,114,45,115,112,97,99,101,115,41,0,0,0,0,0,0};
static C_char C_TLS li642[] C_aligned={C_lihdr(0,0,12),40,108,111,111,112,32,115,101,113,32,110,41,0,0,0,0};
static C_char C_TLS li643[] C_aligned={C_lihdr(0,0,22),40,114,45,117,115,101,113,117,101,110,99,101,32,117,32,110,32,98,97,115,101,41,0,0};
static C_char C_TLS li644[] C_aligned={C_lihdr(0,0,10),40,108,112,32,105,32,108,115,116,41,0,0,0,0,0,0};
static C_char C_TLS li645[] C_aligned={C_lihdr(0,0,25),40,114,45,99,111,110,115,45,99,111,100,101,112,111,105,110,116,32,99,112,32,108,115,116,41,0,0,0,0,0,0,0};
static C_char C_TLS li646[] C_aligned={C_lihdr(0,0,14),40,101,97,116,45,119,115,32,99,32,110,108,63,41,0,0};
static C_char C_TLS li647[] C_aligned={C_lihdr(0,0,12),40,108,111,111,112,32,99,32,108,115,116,41,0,0,0,0};
static C_char C_TLS li648[] C_aligned={C_lihdr(0,0,15),40,114,45,115,116,114,105,110,103,32,116,101,114,109,41,0};
static C_char C_TLS li649[] C_aligned={C_lihdr(0,0,19),40,115,116,97,114,116,105,110,103,45,108,105,110,101,32,109,115,103,41,0,0,0,0,0};
static C_char C_TLS li650[] C_aligned={C_lihdr(0,0,11),40,102,95,50,49,49,52,49,32,99,41,0,0,0,0,0};
static C_char C_TLS li651[] C_aligned={C_lihdr(0,0,15),40,97,50,49,50,53,54,32,116,111,107,32,107,119,41,0};
static C_char C_TLS li652[] C_aligned={C_lihdr(0,0,11),40,108,111,111,112,32,108,97,115,116,41,0,0,0,0,0};
static C_char C_TLS li653[] C_aligned={C_lihdr(0,0,15),40,97,50,49,49,51,55,32,114,101,116,117,114,110,41,0};
static C_char C_TLS li654[] C_aligned={C_lihdr(0,0,18),40,114,45,108,105,115,116,32,115,116,97,114,116,32,101,110,100,41,0,0,0,0,0,0};
static C_char C_TLS li655[] C_aligned={C_lihdr(0,0,10),40,114,45,118,101,99,116,111,114,41,0,0,0,0,0,0};
static C_char C_TLS li656[] C_aligned={C_lihdr(0,0,15),40,97,50,49,51,56,52,32,116,111,107,32,107,119,41,0};
static C_char C_TLS li657[] C_aligned={C_lihdr(0,0,26),40,114,45,110,117,109,98,101,114,32,114,97,100,105,120,32,101,120,97,99,116,110,101,115,115,41,0,0,0,0,0,0};
static C_char C_TLS li658[] C_aligned={C_lihdr(0,0,31),40,114,45,110,117,109,98,101,114,45,119,105,116,104,45,101,120,97,99,116,110,101,115,115,32,114,97,100,105,120,41,0};
static C_char C_TLS li659[] C_aligned={C_lihdr(0,0,31),40,114,45,110,117,109,98,101,114,45,119,105,116,104,45,114,97,100,105,120,32,101,120,97,99,116,110,101,115,115,41,0};
static C_char C_TLS li660[] C_aligned={C_lihdr(0,0,12),40,108,111,111,112,32,99,32,108,115,116,41,0,0,0,0};
static C_char C_TLS li661[] C_aligned={C_lihdr(0,0,9),40,114,45,116,111,107,101,110,41,0,0,0,0,0,0,0};
static C_char C_TLS li662[] C_aligned={C_lihdr(0,0,12),40,108,111,111,112,32,99,32,108,115,116,41,0,0,0,0};
static C_char C_TLS li663[] C_aligned={C_lihdr(0,0,10),40,114,45,100,105,103,105,116,115,41,0,0,0,0,0,0};
static C_char C_TLS li664[] C_aligned={C_lihdr(0,0,15),40,97,50,49,54,56,50,32,115,116,114,32,107,119,41,0};
static C_char C_TLS li665[] C_aligned={C_lihdr(0,0,10),40,114,45,115,121,109,98,111,108,41,0,0,0,0,0,0};
static C_char C_TLS li666[] C_aligned={C_lihdr(0,0,22),40,108,111,111,112,32,108,115,116,32,112,107,119,32,115,107,119,32,113,116,100,41,0,0};
static C_char C_TLS li667[] C_aligned={C_lihdr(0,0,12),40,114,45,120,116,111,107,101,110,32,107,41,0,0,0,0};
static C_char C_TLS li668[] C_aligned={C_lihdr(0,0,8),40,114,45,99,104,97,114,41};
static C_char C_TLS li669[] C_aligned={C_lihdr(0,0,8),40,108,111,111,112,32,105,41};
static C_char C_TLS li670[] C_aligned={C_lihdr(0,0,11),40,114,45,99,111,109,109,101,110,116,41,0,0,0,0,0};
static C_char C_TLS li671[] C_aligned={C_lihdr(0,0,14),40,114,45,101,120,116,45,115,121,109,98,111,108,41,0,0};
static C_char C_TLS li672[] C_aligned={C_lihdr(0,0,11),40,114,45,113,117,111,116,101,32,113,41,0,0,0,0,0};
static C_char C_TLS li673[] C_aligned={C_lihdr(0,0,8),40,97,50,50,50,56,54,41};
static C_char C_TLS li674[] C_aligned={C_lihdr(0,0,13),40,97,50,50,50,57,50,32,46,32,120,115,41,0,0,0};
static C_char C_TLS li675[] C_aligned={C_lihdr(0,0,8),40,97,50,50,52,49,51,41};
static C_char C_TLS li676[] C_aligned={C_lihdr(0,0,13),40,97,50,50,52,49,57,32,46,32,120,115,41,0,0,0};
static C_char C_TLS li677[] C_aligned={C_lihdr(0,0,8),40,97,50,50,52,56,52,41};
static C_char C_TLS li678[] C_aligned={C_lihdr(0,0,13),40,97,50,50,52,57,48,32,46,32,120,115,41,0,0,0};
static C_char C_TLS li679[] C_aligned={C_lihdr(0,0,8),40,97,50,50,53,57,56,41};
static C_char C_TLS li680[] C_aligned={C_lihdr(0,0,8),40,97,50,50,54,48,51,41};
static C_char C_TLS li681[] C_aligned={C_lihdr(0,0,8),40,97,50,50,54,48,57,41};
static C_char C_TLS li682[] C_aligned={C_lihdr(0,0,8),40,97,50,50,55,53,50,41};
static C_char C_TLS li683[] C_aligned={C_lihdr(0,0,15),40,97,50,50,55,54,51,32,115,116,114,32,107,119,41,0};
static C_char C_TLS li684[] C_aligned={C_lihdr(0,0,8),40,97,50,50,55,53,55,41};
static C_char C_TLS li685[] C_aligned={C_lihdr(0,0,8),40,97,50,50,55,57,50,41};
static C_char C_TLS li686[] C_aligned={C_lihdr(0,0,8),40,97,50,50,57,48,54,41};
static C_char C_TLS li687[] C_aligned={C_lihdr(0,0,13),40,97,50,50,57,49,50,32,46,32,120,115,41,0,0,0};
static C_char C_TLS li688[] C_aligned={C_lihdr(0,0,9),40,114,101,97,100,114,101,99,41,0,0,0,0,0,0,0};
static C_char C_TLS li689[] C_aligned={C_lihdr(0,0,29),40,35,35,115,121,115,35,114,101,97,100,32,112,111,114,116,32,105,110,102,111,104,97,110,100,108,101,114,41,0,0,0};
static C_char C_TLS li690[] C_aligned={C_lihdr(0,0,27),40,35,35,115,121,115,35,99,104,97,114,45,62,117,116,102,56,45,115,116,114,105,110,103,32,99,41,0,0,0,0,0};
static C_char C_TLS li691[] C_aligned={C_lihdr(0,0,28),40,35,35,115,121,115,35,117,110,105,99,111,100,101,45,115,117,114,114,111,103,97,116,101,63,32,110,41,0,0,0,0};
static C_char C_TLS li692[] C_aligned={C_lihdr(0,0,35),40,35,35,115,121,115,35,115,117,114,114,111,103,97,116,101,115,45,62,99,111,100,101,112,111,105,110,116,32,104,105,32,108,111,41,0,0,0,0,0};
static C_char C_TLS li693[] C_aligned={C_lihdr(0,0,7),40,104,101,120,32,99,41,0};
static C_char C_TLS li694[] C_aligned={C_lihdr(0,0,12),40,108,111,111,112,32,108,115,116,32,104,41,0,0,0,0};
static C_char C_TLS li695[] C_aligned={C_lihdr(0,0,36),40,35,35,115,121,115,35,114,101,97,100,45,98,121,116,101,118,101,99,116,111,114,45,108,105,116,101,114,97,108,32,112,111,114,116,41,0,0,0,0};
static C_char C_TLS li696[] C_aligned={C_lihdr(0,0,32),40,35,35,115,121,115,35,117,115,101,114,45,114,101,97,100,45,104,111,111,107,32,99,104,97,114,32,112,111,114,116,41};
static C_char C_TLS li697[] C_aligned={C_lihdr(0,0,24),40,35,35,115,121,115,35,119,114,105,116,101,45,99,104,97,114,45,48,32,99,32,112,41};
static C_char C_TLS li698[] C_aligned={C_lihdr(0,0,30),40,35,35,115,121,115,35,119,114,105,116,101,45,99,104,97,114,47,112,111,114,116,32,99,32,112,111,114,116,41,0,0};
static C_char C_TLS li699[] C_aligned={C_lihdr(0,0,28),40,115,99,104,101,109,101,35,119,114,105,116,101,45,99,104,97,114,32,99,32,46,32,114,101,115,116,41,0,0,0,0};
static C_char C_TLS li700[] C_aligned={C_lihdr(0,0,23),40,115,99,104,101,109,101,35,110,101,119,108,105,110,101,32,46,32,114,101,115,116,41,0};
static C_char C_TLS li701[] C_aligned={C_lihdr(0,0,23),40,115,99,104,101,109,101,35,119,114,105,116,101,32,120,32,46,32,114,101,115,116,41,0};
static C_char C_TLS li702[] C_aligned={C_lihdr(0,0,25),40,115,99,104,101,109,101,35,100,105,115,112,108,97,121,32,120,32,46,32,114,101,115,116,41,0,0,0,0,0,0,0};
static C_char C_TLS li703[] C_aligned={C_lihdr(0,0,25),40,102,111,114,45,101,97,99,104,45,108,111,111,112,53,48,54,52,32,103,53,48,55,49,41,0,0,0,0,0,0,0};
static C_char C_TLS li704[] C_aligned={C_lihdr(0,0,27),40,99,104,105,99,107,101,110,46,98,97,115,101,35,112,114,105,110,116,32,46,32,97,114,103,115,41,0,0,0,0,0};
static C_char C_TLS li705[] C_aligned={C_lihdr(0,0,25),40,102,111,114,45,101,97,99,104,45,108,111,111,112,53,48,57,54,32,103,53,49,48,51,41,0,0,0,0,0,0,0};
static C_char C_TLS li706[] C_aligned={C_lihdr(0,0,28),40,99,104,105,99,107,101,110,46,98,97,115,101,35,112,114,105,110,116,42,32,46,32,97,114,103,115,41,0,0,0,0};
static C_char C_TLS li707[] C_aligned={C_lihdr(0,0,17),40,111,117,116,115,116,114,32,112,111,114,116,32,115,116,114,41,0,0,0,0,0,0,0};
static C_char C_TLS li708[] C_aligned={C_lihdr(0,0,17),40,111,117,116,99,104,114,32,112,111,114,116,32,99,104,114,41,0,0,0,0,0,0,0};
static C_char C_TLS li709[] C_aligned={C_lihdr(0,0,17),40,111,117,116,115,121,109,32,112,111,114,116,32,115,121,109,41,0,0,0,0,0,0,0};
static C_char C_TLS li710[] C_aligned={C_lihdr(0,0,8),40,108,111,111,112,32,105,41};
static C_char C_TLS li711[] C_aligned={C_lihdr(0,0,25),40,111,117,116,114,101,97,100,97,98,108,101,115,121,109,32,112,111,114,116,32,115,116,114,41,0,0,0,0,0,0,0};
static C_char C_TLS li712[] C_aligned={C_lihdr(0,0,8),40,108,111,111,112,32,105,41};
static C_char C_TLS li713[] C_aligned={C_lihdr(0,0,22),40,115,121,109,45,105,115,45,114,101,97,100,97,98,108,101,63,32,115,116,114,41,0,0};
static C_char C_TLS li714[] C_aligned={C_lihdr(0,0,10),40,103,53,50,54,50,32,99,110,41,0,0,0,0,0,0};
static C_char C_TLS li715[] C_aligned={C_lihdr(0,0,16),40,100,111,108,111,111,112,53,50,56,51,32,105,32,99,41};
static C_char C_TLS li716[] C_aligned={C_lihdr(0,0,14),40,100,111,108,111,111,112,53,51,49,51,32,120,41,0,0};
static C_char C_TLS li717[] C_aligned={C_lihdr(0,0,14),40,100,111,108,111,111,112,53,51,50,55,32,105,41,0,0};
static C_char C_TLS li718[] C_aligned={C_lihdr(0,0,16),40,100,111,108,111,111,112,53,51,53,49,32,105,32,99,41};
static C_char C_TLS li719[] C_aligned={C_lihdr(0,0,7),40,111,117,116,32,120,41,0};
static C_char C_TLS li720[] C_aligned={C_lihdr(0,0,29),40,35,35,115,121,115,35,112,114,105,110,116,32,120,32,114,101,97,100,97,98,108,101,32,112,111,114,116,41,0,0,0};
static C_char C_TLS li721[] C_aligned={C_lihdr(0,0,27),40,35,35,115,121,115,35,112,114,111,99,101,100,117,114,101,45,62,115,116,114,105,110,103,32,120,41,0,0,0,0,0};
static C_char C_TLS li722[] C_aligned={C_lihdr(0,0,34),40,99,104,105,99,107,101,110,46,98,97,115,101,35,114,101,99,111,114,100,45,112,114,105,110,116,101,114,32,116,121,112,101,41,0,0,0,0,0,0};
static C_char C_TLS li723[] C_aligned={C_lihdr(0,0,44),40,99,104,105,99,107,101,110,46,98,97,115,101,35,115,101,116,45,114,101,99,111,114,100,45,112,114,105,110,116,101,114,33,32,116,121,112,101,32,112,114,111,99,41,0,0,0,0};
static C_char C_TLS li724[] C_aligned={C_lihdr(0,0,8),40,97,50,52,57,57,48,41};
static C_char C_TLS li725[] C_aligned={C_lihdr(0,0,11),40,97,50,52,57,56,52,32,101,120,41,0,0,0,0,0};
static C_char C_TLS li726[] C_aligned={C_lihdr(0,0,8),40,97,50,53,48,52,49,41};
static C_char C_TLS li727[] C_aligned={C_lihdr(0,0,8),40,97,50,53,48,53,54,41};
static C_char C_TLS li728[] C_aligned={C_lihdr(0,0,15),40,97,50,53,48,53,48,32,46,32,97,114,103,115,41,0};
static C_char C_TLS li729[] C_aligned={C_lihdr(0,0,8),40,97,50,53,48,51,53,41};
static C_char C_TLS li730[] C_aligned={C_lihdr(0,0,10),40,97,50,52,57,55,56,32,107,41,0,0,0,0,0,0};
static C_char C_TLS li731[] C_aligned={C_lihdr(0,0,39),40,35,35,115,121,115,35,117,115,101,114,45,112,114,105,110,116,45,104,111,111,107,32,120,32,114,101,97,100,97,98,108,101,32,112,111,114,116,41,0};
static C_char C_TLS li732[] C_aligned={C_lihdr(0,0,8),40,97,50,53,49,50,51,41};
static C_char C_TLS li733[] C_aligned={C_lihdr(0,0,8),40,97,50,53,49,54,54,41};
static C_char C_TLS li734[] C_aligned={C_lihdr(0,0,8),40,97,50,53,49,55,50,41};
static C_char C_TLS li735[] C_aligned={C_lihdr(0,0,15),40,97,50,53,49,49,55,32,114,101,116,117,114,110,41,0};
static C_char C_TLS li736[] C_aligned={C_lihdr(0,0,43),40,35,35,115,121,115,35,119,105,116,104,45,112,114,105,110,116,45,108,101,110,103,116,104,45,108,105,109,105,116,32,108,105,109,105,116,32,116,104,117,110,107,41,0,0,0,0,0};
static C_char C_TLS li737[] C_aligned={C_lihdr(0,0,15),40,99,104,101,99,107,53,52,55,49,32,112,32,110,41,0};
static C_char C_TLS li738[] C_aligned={C_lihdr(0,0,10),40,97,51,49,53,55,51,32,112,41,0,0,0,0,0,0};
static C_char C_TLS li739[] C_aligned={C_lihdr(0,0,10),40,97,51,49,53,57,56,32,112,41,0,0,0,0,0,0};
static C_char C_TLS li740[] C_aligned={C_lihdr(0,0,12),40,97,51,49,54,49,54,32,112,32,99,41,0,0,0,0};
static C_char C_TLS li741[] C_aligned={C_lihdr(0,0,14),40,97,51,49,54,51,53,32,112,32,115,116,114,41,0,0};
static C_char C_TLS li742[] C_aligned={C_lihdr(0,0,10),40,97,51,49,54,53,52,32,112,41,0,0,0,0,0,0};
static C_char C_TLS li743[] C_aligned={C_lihdr(0,0,10),40,97,51,49,54,53,55,32,112,41,0,0,0,0,0,0};
static C_char C_TLS li744[] C_aligned={C_lihdr(0,0,23),40,97,51,49,54,54,48,32,112,32,110,32,100,101,115,116,32,115,116,97,114,116,41,0};
static C_char C_TLS li745[] C_aligned={C_lihdr(0,0,12),40,97,51,49,55,51,53,32,112,111,115,41,0,0,0,0};
static C_char C_TLS li746[] C_aligned={C_lihdr(0,0,8),40,97,51,49,55,50,53,41};
static C_char C_TLS li747[] C_aligned={C_lihdr(0,0,29),40,97,51,49,55,52,52,32,110,101,120,116,32,108,105,110,101,32,102,117,108,108,45,108,105,110,101,63,41,0,0,0};
static C_char C_TLS li748[] C_aligned={C_lihdr(0,0,16),40,97,51,49,55,48,49,32,112,32,108,105,109,105,116,41};
static C_char C_TLS li749[] C_aligned={C_lihdr(0,0,10),40,97,51,49,55,56,53,32,112,41,0,0,0,0,0,0};
static C_char C_TLS li750[] C_aligned={C_lihdr(0,0,37),40,99,111,112,121,38,97,112,112,101,110,100,32,98,117,102,32,111,102,102,115,101,116,32,112,111,115,32,111,108,100,45,108,105,110,101,41,0,0,0};
static C_char C_TLS li751[] C_aligned={C_lihdr(0,0,8),40,97,50,53,50,57,48,41};
static C_char C_TLS li752[] C_aligned={C_lihdr(0,0,25),40,97,50,53,50,57,54,32,98,117,102,32,111,102,102,115,101,116,32,108,105,109,105,116,41,0,0,0,0,0,0,0};
static C_char C_TLS li753[] C_aligned={C_lihdr(0,0,8),40,97,50,53,51,53,52,41};
static C_char C_TLS li754[] C_aligned={C_lihdr(0,0,25),40,97,50,53,51,54,48,32,98,117,102,32,111,102,102,115,101,116,32,108,105,109,105,116,41,0,0,0,0,0,0,0};
static C_char C_TLS li755[] C_aligned={C_lihdr(0,0,32),40,108,111,111,112,32,98,117,102,32,111,102,102,115,101,116,32,112,111,115,32,108,105,109,105,116,32,108,105,110,101,41};
static C_char C_TLS li756[] C_aligned={C_lihdr(0,0,56),40,35,35,115,121,115,35,115,99,97,110,45,98,117,102,102,101,114,45,108,105,110,101,32,98,117,102,32,108,105,109,105,116,32,115,116,97,114,116,45,112,111,115,32,101,111,115,45,104,97,110,100,108,101,114,41};
static C_char C_TLS li757[] C_aligned={C_lihdr(0,0,39),40,99,104,105,99,107,101,110,46,98,97,115,101,35,111,112,101,110,45,105,110,112,117,116,45,115,116,114,105,110,103,32,115,116,114,105,110,103,41,0};
static C_char C_TLS li758[] C_aligned={C_lihdr(0,0,33),40,99,104,105,99,107,101,110,46,98,97,115,101,35,111,112,101,110,45,111,117,116,112,117,116,45,115,116,114,105,110,103,41,0,0,0,0,0,0,0};
static C_char C_TLS li759[] C_aligned={C_lihdr(0,0,37),40,99,104,105,99,107,101,110,46,98,97,115,101,35,103,101,116,45,111,117,116,112,117,116,45,115,116,114,105,110,103,32,112,111,114,116,41,0,0,0};
static C_char C_TLS li760[] C_aligned={C_lihdr(0,0,9),40,103,53,54,48,49,32,120,41,0,0,0,0,0,0,0};
static C_char C_TLS li761[] C_aligned={C_lihdr(0,0,25),40,102,111,114,45,101,97,99,104,45,108,111,111,112,53,54,48,48,32,103,53,54,48,55,41,0,0,0,0,0,0,0};
static C_char C_TLS li762[] C_aligned={C_lihdr(0,0,26),40,35,35,115,121,115,35,112,114,105,110,116,45,116,111,45,115,116,114,105,110,103,32,120,115,41,0,0,0,0,0,0};
static C_char C_TLS li763[] C_aligned={C_lihdr(0,0,25),40,35,35,115,121,115,35,112,111,105,110,116,101,114,45,62,115,116,114,105,110,103,32,120,41,0,0,0,0,0,0,0};
static C_char C_TLS li764[] C_aligned={C_lihdr(0,0,8),40,108,111,111,112,32,105,41};
static C_char C_TLS li765[] C_aligned={C_lihdr(0,0,36),40,99,104,105,99,107,101,110,46,98,97,115,101,35,103,101,116,45,99,97,108,108,45,99,104,97,105,110,32,46,32,114,101,115,116,41,0,0,0,0};
static C_char C_TLS li766[] C_aligned={C_lihdr(0,0,8),40,97,50,53,56,48,50,41};
static C_char C_TLS li767[] C_aligned={C_lihdr(0,0,12),40,103,53,54,54,55,32,105,110,102,111,41,0,0,0,0};
static C_char C_TLS li768[] C_aligned={C_lihdr(0,0,25),40,102,111,114,45,101,97,99,104,45,108,111,111,112,53,54,54,54,32,103,53,54,55,51,41,0,0,0,0,0,0,0};
static C_char C_TLS li769[] C_aligned={C_lihdr(0,0,49),40,35,35,115,121,115,35,114,101,97,108,108,121,45,112,114,105,110,116,45,99,97,108,108,45,99,104,97,105,110,32,112,111,114,116,32,99,104,97,105,110,32,104,101,97,100,101,114,41,0,0,0,0,0,0,0};
static C_char C_TLS li770[] C_aligned={C_lihdr(0,0,38),40,99,104,105,99,107,101,110,46,98,97,115,101,35,112,114,105,110,116,45,99,97,108,108,45,99,104,97,105,110,32,46,32,114,101,115,116,41,0,0};
static C_char C_TLS li771[] C_aligned={C_lihdr(0,0,7),40,98,114,101,97,107,41,0};
static C_char C_TLS li772[] C_aligned={C_lihdr(0,0,27),40,35,35,115,121,115,35,117,115,101,114,45,105,110,116,101,114,114,117,112,116,45,104,111,111,107,41,0,0,0,0,0};
static C_char C_TLS li773[] C_aligned={C_lihdr(0,0,25),40,102,111,114,45,101,97,99,104,45,108,111,111,112,53,55,50,54,32,103,53,55,51,51,41,0,0,0,0,0,0,0};
static C_char C_TLS li774[] C_aligned={C_lihdr(0,0,6),40,108,111,111,112,41,0,0};
static C_char C_TLS li775[] C_aligned={C_lihdr(0,0,21),40,99,108,101,97,110,117,112,45,98,101,102,111,114,101,45,101,120,105,116,41,0,0,0};
static C_char C_TLS li776[] C_aligned={C_lihdr(0,0,8),40,97,50,54,49,49,49,41};
static C_char C_TLS li777[] C_aligned={C_lihdr(0,0,25),40,102,111,114,45,101,97,99,104,45,108,111,111,112,53,55,57,52,32,103,53,56,48,49,41,0,0,0,0,0,0,0};
static C_char C_TLS li778[] C_aligned={C_lihdr(0,0,35),40,35,35,115,121,115,35,115,105,103,110,97,108,45,104,111,111,107,32,109,111,100,101,32,109,115,103,32,46,32,97,114,103,115,41,0,0,0,0,0};
static C_char C_TLS li779[] C_aligned={C_lihdr(0,0,27),40,99,104,105,99,107,101,110,46,99,111,110,100,105,116,105,111,110,35,97,98,111,114,116,32,120,41,0,0,0,0,0};
static C_char C_TLS li780[] C_aligned={C_lihdr(0,0,28),40,99,104,105,99,107,101,110,46,99,111,110,100,105,116,105,111,110,35,115,105,103,110,97,108,32,120,41,0,0,0,0};
static C_char C_TLS li781[] C_aligned={C_lihdr(0,0,35),40,35,35,115,121,115,35,99,117,114,114,101,110,116,45,101,120,99,101,112,116,105,111,110,45,104,97,110,100,108,101,114,32,99,41,0,0,0,0,0};
static C_char C_TLS li782[] C_aligned={C_lihdr(0,0,8),40,97,50,54,53,53,49,41};
static C_char C_TLS li783[] C_aligned={C_lihdr(0,0,8),40,97,50,54,53,53,53,41};
static C_char C_TLS li784[] C_aligned={C_lihdr(0,0,56),40,99,104,105,99,107,101,110,46,99,111,110,100,105,116,105,111,110,35,119,105,116,104,45,101,120,99,101,112,116,105,111,110,45,104,97,110,100,108,101,114,32,104,97,110,100,108,101,114,32,116,104,117,110,107,41};
static C_char C_TLS li785[] C_aligned={C_lihdr(0,0,10),40,98,111,100,121,53,57,53,52,41,0,0,0,0,0,0};
static C_char C_TLS li786[] C_aligned={C_lihdr(0,0,52),40,99,104,105,99,107,101,110,46,99,111,110,100,105,116,105,111,110,35,99,117,114,114,101,110,116,45,101,120,99,101,112,116,105,111,110,45,104,97,110,100,108,101,114,32,46,32,97,114,103,115,41,0,0,0,0};
static C_char C_TLS li787[] C_aligned={C_lihdr(0,0,12),40,108,111,111,112,32,112,114,111,112,115,41,0,0,0,0};
static C_char C_TLS li788[] C_aligned={C_lihdr(0,0,69),40,99,104,105,99,107,101,110,46,99,111,110,100,105,116,105,111,110,35,112,114,111,112,45,108,105,115,116,45,62,107,105,110,100,45,112,114,101,102,105,120,101,100,45,112,114,111,112,45,108,105,115,116,32,108,111,99,32,107,105,110,100,32,112,108,105,115,116,41,0,0,0};
static C_char C_TLS li789[] C_aligned={C_lihdr(0,0,56),40,99,104,105,99,107,101,110,46,99,111,110,100,105,116,105,111,110,35,109,97,107,101,45,112,114,111,112,101,114,116,121,45,99,111,110,100,105,116,105,111,110,32,107,105,110,100,32,46,32,112,114,111,112,115,41};
static C_char C_TLS li790[] C_aligned={C_lihdr(0,0,19),40,102,111,114,45,101,97,99,104,45,108,111,111,112,53,57,57,56,41,0,0,0,0,0};
static C_char C_TLS li791[] C_aligned={C_lihdr(0,0,20),40,109,97,112,45,108,111,111,112,54,48,52,51,32,103,54,48,53,53,41,0,0,0,0};
static C_char C_TLS li792[] C_aligned={C_lihdr(0,0,20),40,109,97,112,45,108,111,111,112,54,48,49,54,32,103,54,48,50,56,41,0,0,0,0};
static C_char C_TLS li793[] C_aligned={C_lihdr(0,0,55),40,99,104,105,99,107,101,110,46,99,111,110,100,105,116,105,111,110,35,109,97,107,101,45,99,111,109,112,111,115,105,116,101,45,99,111,110,100,105,116,105,111,110,32,99,49,32,46,32,99,111,110,100,115,41,0};
static C_char C_TLS li794[] C_aligned={C_lihdr(0,0,20),40,109,97,112,45,108,111,111,112,54,49,48,51,32,103,54,49,49,53,41,0,0,0,0};
static C_char C_TLS li795[] C_aligned={C_lihdr(0,0,20),40,109,97,112,45,108,111,111,112,54,48,55,54,32,103,54,48,56,56,41,0,0,0,0};
static C_char C_TLS li796[] C_aligned={C_lihdr(0,0,41),40,99,104,105,99,107,101,110,46,99,111,110,100,105,116,105,111,110,35,99,111,110,100,105,116,105,111,110,32,97,114,103,49,32,46,32,97,114,103,115,41,0,0,0,0,0,0,0};
static C_char C_TLS li797[] C_aligned={C_lihdr(0,0,32),40,99,104,105,99,107,101,110,46,99,111,110,100,105,116,105,111,110,35,99,111,110,100,105,116,105,111,110,63,32,120,41};
static C_char C_TLS li798[] C_aligned={C_lihdr(0,0,12),40,108,111,111,112,32,112,114,111,112,115,41,0,0,0,0};
static C_char C_TLS li799[] C_aligned={C_lihdr(0,0,9),40,103,54,49,51,57,32,107,41,0,0,0,0,0,0,0};
static C_char C_TLS li800[] C_aligned={C_lihdr(0,0,20),40,109,97,112,45,108,111,111,112,54,49,51,51,32,103,54,49,52,53,41,0,0,0,0};
static C_char C_TLS li801[] C_aligned={C_lihdr(0,0,37),40,99,104,105,99,107,101,110,46,99,111,110,100,105,116,105,111,110,35,99,111,110,100,105,116,105,111,110,45,62,108,105,115,116,32,120,41,0,0,0};
static C_char C_TLS li802[] C_aligned={C_lihdr(0,0,11),40,102,95,50,55,48,55,52,32,99,41,0,0,0,0,0};
static C_char C_TLS li803[] C_aligned={C_lihdr(0,0,44),40,99,104,105,99,107,101,110,46,99,111,110,100,105,116,105,111,110,35,99,111,110,100,105,116,105,111,110,45,112,114,101,100,105,99,97,116,101,32,107,105,110,100,41,0,0,0,0};
static C_char C_TLS li804[] C_aligned={C_lihdr(0,0,11),40,102,95,50,55,49,48,49,32,99,41,0,0,0,0,0};
static C_char C_TLS li805[] C_aligned={C_lihdr(0,0,67),40,99,104,105,99,107,101,110,46,99,111,110,100,105,116,105,111,110,35,99,111,110,100,105,116,105,111,110,45,112,114,111,112,101,114,116,121,45,97,99,99,101,115,115,111,114,32,107,105,110,100,32,112,114,111,112,32,46,32,101,114,114,45,100,101,102,41,0,0,0,0,0};
static C_char C_TLS li806[] C_aligned={C_lihdr(0,0,64),40,99,104,105,99,107,101,110,46,99,111,110,100,105,116,105,111,110,35,103,101,116,45,99,111,110,100,105,116,105,111,110,45,112,114,111,112,101,114,116,121,32,99,32,107,105,110,100,32,112,114,111,112,32,46,32,101,114,114,45,100,101,102,41};
static C_char C_TLS li807[] C_aligned={C_lihdr(0,0,8),40,97,50,55,49,54,55,41};
static C_char C_TLS li808[] C_aligned={C_lihdr(0,0,9),40,103,54,50,48,52,32,120,41,0,0,0,0,0,0,0};
static C_char C_TLS li809[] C_aligned={C_lihdr(0,0,25),40,102,111,114,45,101,97,99,104,45,108,111,111,112,54,50,48,51,32,103,54,50,49,48,41,0,0,0,0,0,0,0};
static C_char C_TLS li810[] C_aligned={C_lihdr(0,0,21),40,119,114,105,116,101,97,114,103,115,32,97,114,103,115,32,112,111,114,116,41,0,0,0};
static C_char C_TLS li811[] C_aligned={C_lihdr(0,0,11),40,103,54,50,52,55,32,109,115,103,41,0,0,0,0,0};
static C_char C_TLS li812[] C_aligned={C_lihdr(0,0,22),40,98,111,100,121,54,50,50,52,32,112,111,114,116,32,104,101,97,100,101,114,41,0,0};
static C_char C_TLS li813[] C_aligned={C_lihdr(0,0,22),40,100,101,102,45,104,101,97,100,101,114,54,50,50,55,32,37,112,111,114,116,41,0,0};
static C_char C_TLS li814[] C_aligned={C_lihdr(0,0,14),40,100,101,102,45,112,111,114,116,54,50,50,54,41,0,0};
static C_char C_TLS li815[] C_aligned={C_lihdr(0,0,49),40,99,104,105,99,107,101,110,46,99,111,110,100,105,116,105,111,110,35,112,114,105,110,116,45,101,114,114,111,114,45,109,101,115,115,97,103,101,32,101,120,32,46,32,97,114,103,115,41,0,0,0,0,0,0,0};
static C_char C_TLS li816[] C_aligned={C_lihdr(0,0,47),40,35,35,115,121,115,35,115,104,111,119,45,101,120,99,101,112,116,105,111,110,45,119,97,114,110,105,110,103,32,101,120,110,32,99,97,117,115,101,32,46,32,114,101,115,116,41,0};
static C_char C_TLS li817[] C_aligned={C_lihdr(0,0,34),40,35,35,115,121,115,35,101,114,114,111,114,45,104,111,111,107,32,99,111,100,101,32,108,111,99,32,46,32,97,114,103,115,41,0,0,0,0,0,0};
static C_char C_TLS li818[] C_aligned={C_lihdr(0,0,22),40,35,35,115,121,115,35,115,116,114,117,99,116,117,114,101,63,32,120,32,115,41,0,0};
static C_char C_TLS li819[] C_aligned={C_lihdr(0,0,28),40,35,35,115,121,115,35,103,101,110,101,114,105,99,45,115,116,114,117,99,116,117,114,101,63,32,120,41,0,0,0,0};
static C_char C_TLS li820[] C_aligned={C_lihdr(0,0,16),40,35,35,115,121,115,35,115,108,111,116,32,120,32,105,41};
static C_char C_TLS li821[] C_aligned={C_lihdr(0,0,14),40,35,35,115,121,115,35,115,105,122,101,32,120,41,0,0};
static C_char C_TLS li822[] C_aligned={C_lihdr(0,0,14),67,95,109,97,107,101,95,112,111,105,110,116,101,114,0,0};
static C_char C_TLS li823[] C_aligned={C_lihdr(0,0,21),67,95,109,97,107,101,95,116,97,103,103,101,100,95,112,111,105,110,116,101,114,0,0,0};
static C_char C_TLS li824[] C_aligned={C_lihdr(0,0,18),40,35,35,115,121,115,35,112,111,105,110,116,101,114,63,32,120,41,0,0,0,0,0,0};
static C_char C_TLS li825[] C_aligned={C_lihdr(0,0,37),40,35,35,115,121,115,35,115,101,116,45,112,111,105,110,116,101,114,45,97,100,100,114,101,115,115,33,32,112,116,114,32,97,100,100,114,41,0,0,0};
static C_char C_TLS li826[] C_aligned={C_lihdr(0,0,21),40,35,35,115,121,115,35,98,121,116,101,118,101,99,116,111,114,63,32,120,41,0,0,0};
static C_char C_TLS li827[] C_aligned={C_lihdr(0,0,29),40,35,35,115,121,115,35,115,116,114,105,110,103,45,62,112,98,121,116,101,118,101,99,116,111,114,32,115,41,0,0,0};
static C_char C_TLS li828[] C_aligned={C_lihdr(0,0,20),40,35,35,115,121,115,35,112,101,114,109,97,110,101,110,116,63,32,120,41,0,0,0,0};
static C_char C_TLS li829[] C_aligned={C_lihdr(0,0,23),40,35,35,115,121,115,35,98,108,111,99,107,45,97,100,100,114,101,115,115,32,120,41,0};
static C_char C_TLS li830[] C_aligned={C_lihdr(0,0,19),40,35,35,115,121,115,35,108,111,99,97,116,105,118,101,63,32,120,41,0,0,0,0,0};
static C_char C_TLS li831[] C_aligned={C_lihdr(0,0,24),40,35,35,115,121,115,35,115,114,102,105,45,52,45,118,101,99,116,111,114,63,32,120,41};
static C_char C_TLS li832[] C_aligned={C_lihdr(0,0,20),40,35,35,115,121,115,35,110,117,108,108,45,112,111,105,110,116,101,114,41,0,0,0,0};
static C_char C_TLS li833[] C_aligned={C_lihdr(0,0,23),40,35,35,115,121,115,35,110,117,108,108,45,112,111,105,110,116,101,114,63,32,120,41,0};
static C_char C_TLS li834[] C_aligned={C_lihdr(0,0,29),40,35,35,115,121,115,35,97,100,100,114,101,115,115,45,62,112,111,105,110,116,101,114,32,97,100,100,114,41,0,0,0};
static C_char C_TLS li835[] C_aligned={C_lihdr(0,0,28),40,35,35,115,121,115,35,112,111,105,110,116,101,114,45,62,97,100,100,114,101,115,115,32,112,116,114,41,0,0,0,0};
static C_char C_TLS li836[] C_aligned={C_lihdr(0,0,32),40,35,35,115,121,115,35,109,97,107,101,45,99,45,115,116,114,105,110,103,32,115,116,114,32,46,32,114,101,115,116,41};
static C_char C_TLS li837[] C_aligned={C_lihdr(0,0,21),67,95,112,101,101,107,95,115,105,103,110,101,100,95,105,110,116,101,103,101,114,0,0,0};
static C_char C_TLS li838[] C_aligned={C_lihdr(0,0,23),67,95,112,101,101,107,95,117,110,115,105,103,110,101,100,95,105,110,116,101,103,101,114,0};
static C_char C_TLS li839[] C_aligned={C_lihdr(0,0,23),40,35,35,115,121,115,35,112,101,101,107,45,102,105,120,110,117,109,32,98,32,105,41,0};
static C_char C_TLS li840[] C_aligned={C_lihdr(0,0,23),40,35,35,115,121,115,35,112,101,101,107,45,98,121,116,101,32,112,116,114,32,105,41,0};
static C_char C_TLS li841[] C_aligned={C_lihdr(0,0,30),40,35,35,115,121,115,35,118,101,99,116,111,114,45,62,115,116,114,117,99,116,117,114,101,33,32,118,101,99,41,0,0};
static C_char C_TLS li842[] C_aligned={C_lihdr(0,0,23),40,35,35,115,121,115,35,112,101,101,107,45,100,111,117,98,108,101,32,98,32,105,41,0};
static C_char C_TLS li843[] C_aligned={C_lihdr(0,0,25),40,35,35,115,121,115,35,112,101,101,107,45,99,45,115,116,114,105,110,103,32,98,32,105,41,0,0,0,0,0,0,0};
static C_char C_TLS li844[] C_aligned={C_lihdr(0,0,33),40,35,35,115,121,115,35,112,101,101,107,45,110,111,110,110,117,108,108,45,99,45,115,116,114,105,110,103,32,98,32,105,41,0,0,0,0,0,0,0};
static C_char C_TLS li845[] C_aligned={C_lihdr(0,0,34),40,35,35,115,121,115,35,112,101,101,107,45,97,110,100,45,102,114,101,101,45,99,45,115,116,114,105,110,103,32,98,32,105,41,0,0,0,0,0,0};
static C_char C_TLS li846[] C_aligned={C_lihdr(0,0,42),40,35,35,115,121,115,35,112,101,101,107,45,97,110,100,45,102,114,101,101,45,110,111,110,110,117,108,108,45,99,45,115,116,114,105,110,103,32,98,32,105,41,0,0,0,0,0,0};
static C_char C_TLS li847[] C_aligned={C_lihdr(0,0,27),40,35,35,115,121,115,35,112,111,107,101,45,99,45,115,116,114,105,110,103,32,98,32,105,32,115,41,0,0,0,0,0};
static C_char C_TLS li848[] C_aligned={C_lihdr(0,0,26),40,35,35,115,121,115,35,112,111,107,101,45,105,110,116,101,103,101,114,32,98,32,105,32,110,41,0,0,0,0,0,0};
static C_char C_TLS li849[] C_aligned={C_lihdr(0,0,25),40,35,35,115,121,115,35,112,111,107,101,45,100,111,117,98,108,101,32,98,32,105,32,110,41,0,0,0,0,0,0,0};
static C_char C_TLS li850[] C_aligned={C_lihdr(0,0,8),40,108,111,111,112,32,105,41};
static C_char C_TLS li851[] C_aligned={C_lihdr(0,0,32),40,35,35,115,121,115,35,112,101,101,107,45,99,45,115,116,114,105,110,103,45,108,105,115,116,32,112,116,114,32,110,41};
static C_char C_TLS li852[] C_aligned={C_lihdr(0,0,8),40,108,111,111,112,32,105,41};
static C_char C_TLS li853[] C_aligned={C_lihdr(0,0,41),40,35,35,115,121,115,35,112,101,101,107,45,97,110,100,45,102,114,101,101,45,99,45,115,116,114,105,110,103,45,108,105,115,116,32,112,116,114,32,110,41,0,0,0,0,0,0,0};
static C_char C_TLS li854[] C_aligned={C_lihdr(0,0,33),40,35,35,115,121,115,35,118,101,99,116,111,114,45,62,99,108,111,115,117,114,101,33,32,118,101,99,32,97,100,100,114,41,0,0,0,0,0,0,0};
static C_char C_TLS li855[] C_aligned={C_lihdr(0,0,38),40,35,35,115,121,115,35,115,121,109,98,111,108,45,104,97,115,45,116,111,112,108,101,118,101,108,45,98,105,110,100,105,110,103,63,32,115,41,0,0};
static C_char C_TLS li856[] C_aligned={C_lihdr(0,0,48),40,35,35,115,121,115,35,99,111,112,121,45,98,121,116,101,115,32,102,114,111,109,32,116,111,32,111,102,102,115,101,116,49,32,111,102,102,115,101,116,50,32,98,121,116,101,115,41};
static C_char C_TLS li857[] C_aligned={C_lihdr(0,0,48),40,35,35,115,121,115,35,99,111,112,121,45,119,111,114,100,115,32,102,114,111,109,32,116,111,32,111,102,102,115,101,116,49,32,111,102,102,115,101,116,50,32,119,111,114,100,115,41};
static C_char C_TLS li858[] C_aligned={C_lihdr(0,0,51),40,35,35,115,121,115,35,99,111,109,112,97,114,101,45,98,121,116,101,115,32,102,114,111,109,32,116,111,32,111,102,102,115,101,116,49,32,111,102,102,115,101,116,50,32,98,121,116,101,115,41,0,0,0,0,0};
static C_char C_TLS li859[] C_aligned={C_lihdr(0,0,23),40,35,35,115,121,115,35,98,108,111,99,107,45,112,111,105,110,116,101,114,32,120,41,0};
static C_char C_TLS li860[] C_aligned={C_lihdr(0,0,31),40,35,35,115,121,115,35,102,111,114,101,105,103,110,45,99,104,97,114,45,97,114,103,117,109,101,110,116,32,120,41,0};
static C_char C_TLS li861[] C_aligned={C_lihdr(0,0,33),40,35,35,115,121,115,35,102,111,114,101,105,103,110,45,102,105,120,110,117,109,45,97,114,103,117,109,101,110,116,32,120,41,0,0,0,0,0,0,0};
static C_char C_TLS li862[] C_aligned={C_lihdr(0,0,33),40,35,35,115,121,115,35,102,111,114,101,105,103,110,45,102,108,111,110,117,109,45,97,114,103,117,109,101,110,116,32,120,41,0,0,0,0,0,0,0};
static C_char C_TLS li863[] C_aligned={C_lihdr(0,0,32),40,35,35,115,121,115,35,102,111,114,101,105,103,110,45,98,108,111,99,107,45,97,114,103,117,109,101,110,116,32,120,41};
static C_char C_TLS li864[] C_aligned={C_lihdr(0,0,43),40,35,35,115,121,115,35,102,111,114,101,105,103,110,45,115,116,114,117,99,116,45,119,114,97,112,112,101,114,45,97,114,103,117,109,101,110,116,32,116,32,120,41,0,0,0,0,0};
static C_char C_TLS li865[] C_aligned={C_lihdr(0,0,33),40,35,35,115,121,115,35,102,111,114,101,105,103,110,45,115,116,114,105,110,103,45,97,114,103,117,109,101,110,116,32,120,41,0,0,0,0,0,0,0};
static C_char C_TLS li866[] C_aligned={C_lihdr(0,0,33),40,35,35,115,121,115,35,102,111,114,101,105,103,110,45,115,121,109,98,111,108,45,97,114,103,117,109,101,110,116,32,120,41,0,0,0,0,0,0,0};
static C_char C_TLS li867[] C_aligned={C_lihdr(0,0,34),40,35,35,115,121,115,35,102,111,114,101,105,103,110,45,112,111,105,110,116,101,114,45,97,114,103,117,109,101,110,116,32,120,41,0,0,0,0,0,0};
static C_char C_TLS li868[] C_aligned={C_lihdr(0,0,44),40,35,35,115,121,115,35,102,111,114,101,105,103,110,45,116,97,103,103,101,100,45,112,111,105,110,116,101,114,45,97,114,103,117,109,101,110,116,32,120,32,116,120,41,0,0,0,0};
static C_char C_TLS li869[] C_aligned={C_lihdr(0,0,48),40,35,35,115,121,115,35,102,111,114,101,105,103,110,45,114,97,110,103,101,100,45,105,110,116,101,103,101,114,45,97,114,103,117,109,101,110,116,32,111,98,106,32,115,105,122,101,41};
static C_char C_TLS li870[] C_aligned={C_lihdr(0,0,57),40,35,35,115,121,115,35,102,111,114,101,105,103,110,45,117,110,115,105,103,110,101,100,45,114,97,110,103,101,100,45,105,110,116,101,103,101,114,45,97,114,103,117,109,101,110,116,32,111,98,106,32,115,105,122,101,41,0,0,0,0,0,0,0};
static C_char C_TLS li871[] C_aligned={C_lihdr(0,0,37),40,35,35,115,121,115,35,100,101,102,97,117,108,116,45,101,120,99,101,112,116,105,111,110,45,104,97,110,100,108,101,114,32,97,114,103,41,0,0,0};
static C_char C_TLS li872[] C_aligned={C_lihdr(0,0,38),40,35,35,115,121,115,35,109,97,107,101,45,116,104,114,101,97,100,32,116,104,117,110,107,32,115,116,97,116,101,32,110,97,109,101,32,113,41,0,0};
static C_char C_TLS li873[] C_aligned={C_lihdr(0,0,27),40,35,35,115,121,115,35,109,97,107,101,45,109,117,116,101,120,32,105,100,32,111,119,110,101,114,41,0,0,0,0,0};
static C_char C_TLS li874[] C_aligned={C_lihdr(0,0,16),40,35,35,115,121,115,35,115,99,104,101,100,117,108,101,41};
static C_char C_TLS li875[] C_aligned={C_lihdr(0,0,8),40,97,50,56,53,53,55,41};
static C_char C_TLS li876[] C_aligned={C_lihdr(0,0,15),40,97,50,56,53,52,56,32,114,101,116,117,114,110,41,0};
static C_char C_TLS li877[] C_aligned={C_lihdr(0,0,21),40,35,35,115,121,115,35,116,104,114,101,97,100,45,121,105,101,108,100,33,41,0,0,0};
static C_char C_TLS li878[] C_aligned={C_lihdr(0,0,32),40,35,35,115,121,115,35,107,105,108,108,45,111,116,104,101,114,45,116,104,114,101,97,100,115,32,116,104,117,110,107,41};
static C_char C_TLS li879[] C_aligned={C_lihdr(0,0,27),40,99,104,105,99,107,101,110,46,98,97,115,101,35,115,108,101,101,112,45,104,111,111,107,32,110,41,0,0,0,0,0};
static C_char C_TLS li880[] C_aligned={C_lihdr(0,0,22),40,99,104,105,99,107,101,110,46,98,97,115,101,35,115,108,101,101,112,32,110,41,0,0};
static C_char C_TLS li881[] C_aligned={C_lihdr(0,0,16),67,95,99,111,110,116,101,120,116,95,115,119,105,116,99,104};
static C_char C_TLS li882[] C_aligned={C_lihdr(0,0,13),40,108,111,111,112,32,114,101,97,115,111,110,41,0,0,0};
static C_char C_TLS li883[] C_aligned={C_lihdr(0,0,35),40,35,35,115,121,115,35,105,110,116,101,114,114,117,112,116,45,104,111,111,107,32,114,101,97,115,111,110,32,115,116,97,116,101,41,0,0,0,0,0};
static C_char C_TLS li884[] C_aligned={C_lihdr(0,0,28),40,35,35,115,121,115,35,100,105,115,112,97,116,99,104,45,105,110,116,101,114,114,117,112,116,32,107,41,0,0,0,0};
static C_char C_TLS li885[] C_aligned={C_lihdr(0,0,20),40,35,35,115,121,115,35,117,112,100,97,116,101,45,101,114,114,110,111,41,0,0,0,0};
static C_char C_TLS li886[] C_aligned={C_lihdr(0,0,13),40,35,35,115,121,115,35,101,114,114,110,111,41,0,0,0};
static C_char C_TLS li887[] C_aligned={C_lihdr(0,0,14),40,100,111,108,111,111,112,54,54,50,54,32,99,41,0,0};
static C_char C_TLS li888[] C_aligned={C_lihdr(0,0,13),40,114,101,97,100,108,110,32,112,111,114,116,41,0,0,0};
static C_char C_TLS li889[] C_aligned={C_lihdr(0,0,6),40,108,111,111,112,41,0,0};
static C_char C_TLS li890[] C_aligned={C_lihdr(0,0,36),40,114,101,97,100,45,101,115,99,97,112,101,100,45,115,101,120,112,32,112,111,114,116,32,115,107,105,112,45,98,114,97,99,101,63,41,0,0,0,0};
static C_char C_TLS li891[] C_aligned={C_lihdr(0,0,15),40,100,111,108,111,111,112,54,54,54,49,32,108,110,41,0};
static C_char C_TLS li892[] C_aligned={C_lihdr(0,0,15),40,103,101,116,47,99,108,101,97,114,45,115,116,114,41,0};
static C_char C_TLS li893[] C_aligned={C_lihdr(0,0,27),40,108,111,111,112,50,32,108,115,116,32,110,101,120,116,45,115,116,114,105,110,103,32,97,99,99,41,0,0,0,0,0};
static C_char C_TLS li894[] C_aligned={C_lihdr(0,0,10),40,108,111,111,112,32,108,115,116,41,0,0,0,0,0,0};
static C_char C_TLS li895[] C_aligned={C_lihdr(0,0,32),40,35,35,115,121,115,35,117,115,101,114,45,114,101,97,100,45,104,111,111,107,32,99,104,97,114,32,112,111,114,116,41};
static C_char C_TLS li896[] C_aligned={C_lihdr(0,0,47),40,99,104,105,99,107,101,110,46,112,114,111,99,101,115,115,45,99,111,110,116,101,120,116,35,99,104,97,110,103,101,45,100,105,114,101,99,116,111,114,121,32,110,97,109,101,41,0};
static C_char C_TLS li897[] C_aligned={C_lihdr(0,0,33),40,35,35,115,121,115,35,99,104,97,110,103,101,45,100,105,114,101,99,116,111,114,121,45,104,111,111,107,32,100,105,114,41,0,0,0,0,0,0,0};
static C_char C_TLS li898[] C_aligned={C_lihdr(0,0,71),40,99,104,105,99,107,101,110,46,112,114,111,99,101,115,115,45,99,111,110,116,101,120,116,35,103,101,116,45,101,110,118,105,114,111,110,109,101,110,116,45,118,97,114,105,97,98,108,101,32,110,111,110,110,117,108,108,45,99,45,115,116,114,105,110,103,54,55,55,56,41,0};
static C_char C_TLS li899[] C_aligned={C_lihdr(0,0,59),40,99,104,105,99,107,101,110,46,112,114,111,99,101,115,115,45,99,111,110,116,101,120,116,35,115,101,116,45,101,110,118,105,114,111,110,109,101,110,116,45,118,97,114,105,97,98,108,101,33,32,118,97,114,32,118,97,108,41,0,0,0,0,0};
static C_char C_TLS li900[] C_aligned={C_lihdr(0,0,57),40,99,104,105,99,107,101,110,46,112,114,111,99,101,115,115,45,99,111,110,116,101,120,116,35,117,110,115,101,116,45,101,110,118,105,114,111,110,109,101,110,116,45,118,97,114,105,97,98,108,101,33,32,118,97,114,41,0,0,0,0,0,0,0};
static C_char C_TLS li901[] C_aligned={C_lihdr(0,0,8),40,115,99,97,110,32,106,41};
static C_char C_TLS li902[] C_aligned={C_lihdr(0,0,8),40,108,111,111,112,32,105,41};
static C_char C_TLS li903[] C_aligned={C_lihdr(0,0,51),40,99,104,105,99,107,101,110,46,112,114,111,99,101,115,115,45,99,111,110,116,101,120,116,35,103,101,116,45,101,110,118,105,114,111,110,109,101,110,116,45,118,97,114,105,97,98,108,101,115,41,0,0,0,0,0};
static C_char C_TLS li904[] C_aligned={C_lihdr(0,0,45),40,99,104,105,99,107,101,110,46,112,114,111,99,101,115,115,45,99,111,110,116,101,120,116,35,101,120,101,99,117,116,97,98,108,101,45,112,97,116,104,110,97,109,101,41,0,0,0};
static C_char C_TLS li905[] C_aligned={C_lihdr(0,0,35),40,99,104,105,99,107,101,110,46,112,114,111,99,101,115,115,45,99,111,110,116,101,120,116,35,97,114,103,99,43,97,114,103,118,41,0,0,0,0,0};
static C_char C_TLS li906[] C_aligned={C_lihdr(0,0,16),40,100,111,108,111,111,112,54,56,50,48,32,105,32,118,41};
static C_char C_TLS li907[] C_aligned={C_lihdr(0,0,30),40,99,104,105,99,107,101,110,46,112,114,111,99,101,115,115,45,99,111,110,116,101,120,116,35,97,114,103,118,41,0,0};
static C_char C_TLS li908[] C_aligned={C_lihdr(0,0,36),40,99,104,105,99,107,101,110,46,103,99,35,99,117,114,114,101,110,116,45,103,99,45,109,105,108,108,105,115,101,99,111,110,100,115,41,0,0,0,0};
static C_char C_TLS li909[] C_aligned={C_lihdr(0,0,32),40,99,104,105,99,107,101,110,46,103,99,35,115,101,116,45,103,99,45,114,101,112,111,114,116,33,32,102,108,97,103,41};
static C_char C_TLS li910[] C_aligned={C_lihdr(0,0,30),40,99,104,105,99,107,101,110,46,103,99,35,109,101,109,111,114,121,45,115,116,97,116,105,115,116,105,99,115,41,0,0};
static C_char C_TLS li911[] C_aligned={C_lihdr(0,0,20),67,95,114,101,103,105,115,116,101,114,95,102,105,110,97,108,105,122,101,114,0,0,0,0};
static C_char C_TLS li912[] C_aligned={C_lihdr(0,0,31),40,99,104,105,99,107,101,110,46,103,99,35,115,101,116,45,102,105,110,97,108,105,122,101,114,33,32,120,32,121,41,0};
static C_char C_TLS li913[] C_aligned={C_lihdr(0,0,8),40,97,50,57,53,57,54,41};
static C_char C_TLS li914[] C_aligned={C_lihdr(0,0,11),40,97,50,57,53,57,48,32,101,120,41,0,0,0,0,0};
static C_char C_TLS li915[] C_aligned={C_lihdr(0,0,8),40,97,50,57,54,48,56,41};
static C_char C_TLS li916[] C_aligned={C_lihdr(0,0,8),40,97,50,57,54,51,49,41};
static C_char C_TLS li917[] C_aligned={C_lihdr(0,0,15),40,97,50,57,54,50,53,32,46,32,97,114,103,115,41,0};
static C_char C_TLS li918[] C_aligned={C_lihdr(0,0,8),40,97,50,57,54,48,50,41};
static C_char C_TLS li919[] C_aligned={C_lihdr(0,0,10),40,97,50,57,53,56,52,32,107,41,0,0,0,0,0,0};
static C_char C_TLS li920[] C_aligned={C_lihdr(0,0,14),40,100,111,108,111,111,112,54,56,57,57,32,105,41,0,0};
static C_char C_TLS li921[] C_aligned={C_lihdr(0,0,36),40,35,35,115,121,115,35,114,117,110,45,112,101,110,100,105,110,103,45,102,105,110,97,108,105,122,101,114,115,32,115,116,97,116,101,41,0,0,0,0};
static C_char C_TLS li922[] C_aligned={C_lihdr(0,0,6),40,108,111,111,112,41,0,0};
static C_char C_TLS li923[] C_aligned={C_lihdr(0,0,24),40,35,35,115,121,115,35,102,111,114,99,101,45,102,105,110,97,108,105,122,101,114,115,41};
static C_char C_TLS li924[] C_aligned={C_lihdr(0,0,21),40,99,104,105,99,107,101,110,46,103,99,35,103,99,32,46,32,97,114,103,41,0,0,0};
static C_char C_TLS li925[] C_aligned={C_lihdr(0,0,41),40,35,35,115,121,115,35,109,97,107,101,45,108,111,99,97,116,105,118,101,32,111,98,106,32,105,110,100,101,120,32,119,101,97,107,63,32,108,111,99,41,0,0,0,0,0,0,0};
static C_char C_TLS li926[] C_aligned={C_lihdr(0,0,33),40,99,104,105,99,107,101,110,46,112,108,105,115,116,35,112,117,116,33,32,115,121,109,32,112,114,111,112,32,118,97,108,41,0,0,0,0,0,0,0};
static C_char C_TLS li927[] C_aligned={C_lihdr(0,0,35),40,99,104,105,99,107,101,110,46,112,108,105,115,116,35,103,101,116,32,115,121,109,32,112,114,111,112,32,46,32,114,101,115,116,41,0,0,0,0,0};
static C_char C_TLS li928[] C_aligned={C_lihdr(0,0,10),40,108,111,111,112,32,112,116,108,41,0,0,0,0,0,0};
static C_char C_TLS li929[] C_aligned={C_lihdr(0,0,33),40,99,104,105,99,107,101,110,46,112,108,105,115,116,35,114,101,109,112,114,111,112,33,32,115,121,109,32,112,114,111,112,41,0,0,0,0,0,0,0};
static C_char C_TLS li930[] C_aligned={C_lihdr(0,0,12),40,108,111,111,112,32,112,108,105,115,116,41,0,0,0,0};
static C_char C_TLS li931[] C_aligned={C_lihdr(0,0,40),40,99,104,105,99,107,101,110,46,112,108,105,115,116,35,103,101,116,45,112,114,111,112,101,114,116,105,101,115,32,115,121,109,32,112,114,111,112,115,41};
static C_char C_TLS li932[] C_aligned={C_lihdr(0,0,10),40,112,110,117,109,32,110,117,109,41,0,0,0,0,0,0};
static C_char C_TLS li933[] C_aligned={C_lihdr(0,0,14),40,114,111,117,110,100,45,116,111,32,120,32,121,41,0,0};
static C_char C_TLS li934[] C_aligned={C_lihdr(0,0,12),40,112,109,101,109,32,98,121,116,101,115,41,0,0,0,0};
static C_char C_TLS li935[] C_aligned={C_lihdr(0,0,26),40,35,35,115,121,115,35,100,105,115,112,108,97,121,45,116,105,109,101,115,32,105,110,102,111,41,0,0,0,0,0,0};
static C_char C_TLS li936[] C_aligned={C_lihdr(0,0,17),67,95,100,117,109,112,95,104,101,97,112,95,115,116,97,116,101,0,0,0,0,0,0,0};
static C_char C_TLS li937[] C_aligned={C_lihdr(0,0,21),67,95,102,105,108,116,101,114,95,104,101,97,112,95,111,98,106,101,99,116,115,0,0,0};
static C_char C_TLS li938[] C_aligned={C_lihdr(0,0,32),40,99,104,105,99,107,101,110,46,112,108,97,116,102,111,114,109,35,115,111,102,116,119,97,114,101,45,116,121,112,101,41};
static C_char C_TLS li939[] C_aligned={C_lihdr(0,0,31),40,99,104,105,99,107,101,110,46,112,108,97,116,102,111,114,109,35,109,97,99,104,105,110,101,45,116,121,112,101,41,0};
static C_char C_TLS li940[] C_aligned={C_lihdr(0,0,37),40,99,104,105,99,107,101,110,46,112,108,97,116,102,111,114,109,35,109,97,99,104,105,110,101,45,98,121,116,101,45,111,114,100,101,114,41,0,0,0};
static C_char C_TLS li941[] C_aligned={C_lihdr(0,0,35),40,99,104,105,99,107,101,110,46,112,108,97,116,102,111,114,109,35,115,111,102,116,119,97,114,101,45,118,101,114,115,105,111,110,41,0,0,0,0,0};
static C_char C_TLS li942[] C_aligned={C_lihdr(0,0,33),40,99,104,105,99,107,101,110,46,112,108,97,116,102,111,114,109,35,98,117,105,108,100,45,112,108,97,116,102,111,114,109,41,0,0,0,0,0,0,0};
static C_char C_TLS li943[] C_aligned={C_lihdr(0,0,7),40,115,116,114,32,120,41,0};
static C_char C_TLS li944[] C_aligned={C_lihdr(0,0,41),40,99,104,105,99,107,101,110,46,112,108,97,116,102,111,114,109,35,99,104,105,99,107,101,110,45,118,101,114,115,105,111,110,32,46,32,114,101,115,116,41,0,0,0,0,0,0,0};
static C_char C_TLS li945[] C_aligned={C_lihdr(0,0,31),40,99,104,105,99,107,101,110,46,112,108,97,116,102,111,114,109,35,99,104,105,99,107,101,110,45,104,111,109,101,41,0};
static C_char C_TLS li946[] C_aligned={C_lihdr(0,0,16),40,108,111,111,112,32,115,116,97,114,116,32,112,111,115,41};
static C_char C_TLS li947[] C_aligned={C_lihdr(0,0,23),40,35,35,115,121,115,35,115,112,108,105,116,45,112,97,116,104,32,112,97,116,104,41,0};
static C_char C_TLS li948[] C_aligned={C_lihdr(0,0,33),40,99,104,105,99,107,101,110,46,112,108,97,116,102,111,114,109,35,45,62,102,101,97,116,117,114,101,45,105,100,32,120,41,0,0,0,0,0,0,0};
static C_char C_TLS li949[] C_aligned={C_lihdr(0,0,9),40,99,104,101,99,107,32,102,41,0,0,0,0,0,0,0};
static C_char C_TLS li950[] C_aligned={C_lihdr(0,0,25),40,102,111,114,45,101,97,99,104,45,108,111,111,112,55,51,48,55,32,103,55,51,49,52,41,0,0,0,0,0,0,0};
static C_char C_TLS li951[] C_aligned={C_lihdr(0,0,41),40,99,104,105,99,107,101,110,46,112,108,97,116,102,111,114,109,35,114,101,103,105,115,116,101,114,45,102,101,97,116,117,114,101,33,32,46,32,102,115,41,0,0,0,0,0,0,0};
static C_char C_TLS li952[] C_aligned={C_lihdr(0,0,10),40,108,111,111,112,32,102,102,115,41,0,0,0,0,0,0};
static C_char C_TLS li953[] C_aligned={C_lihdr(0,0,20),40,109,97,112,45,108,111,111,112,55,51,51,48,32,103,55,51,52,50,41,0,0,0,0};
static C_char C_TLS li954[] C_aligned={C_lihdr(0,0,43),40,99,104,105,99,107,101,110,46,112,108,97,116,102,111,114,109,35,117,110,114,101,103,105,115,116,101,114,45,102,101,97,116,117,114,101,33,32,46,32,102,115,41,0,0,0,0,0};
static C_char C_TLS li955[] C_aligned={C_lihdr(0,0,27),40,99,104,105,99,107,101,110,46,112,108,97,116,102,111,114,109,35,102,101,97,116,117,114,101,115,41,0,0,0,0,0};
static C_char C_TLS li956[] C_aligned={C_lihdr(0,0,10),40,108,111,111,112,32,105,100,115,41,0,0,0,0,0,0};
static C_char C_TLS li957[] C_aligned={C_lihdr(0,0,33),40,99,104,105,99,107,101,110,46,112,108,97,116,102,111,114,109,35,102,101,97,116,117,114,101,63,32,46,32,105,100,115,41,0,0,0,0,0,0,0};
static C_char C_TLS li958[] C_aligned={C_lihdr(0,0,16),67,95,114,101,116,117,114,110,95,116,111,95,104,111,115,116};
static C_char C_TLS li959[] C_aligned={C_lihdr(0,0,42),40,99,104,105,99,107,101,110,46,112,108,97,116,102,111,114,109,35,115,121,115,116,101,109,45,99,111,110,102,105,103,45,100,105,114,101,99,116,111,114,121,41,0,0,0,0,0,0};
static C_char C_TLS li960[] C_aligned={C_lihdr(0,0,41),40,99,104,105,99,107,101,110,46,112,108,97,116,102,111,114,109,35,115,121,115,116,101,109,45,99,97,99,104,101,45,100,105,114,101,99,116,111,114,121,41,0,0,0,0,0,0,0};
static C_char C_TLS li961[] C_aligned={C_lihdr(0,0,19),40,102,111,114,45,101,97,99,104,45,108,111,111,112,55,50,52,57,41,0,0,0,0,0};
static C_char C_TLS li962[] C_aligned={C_lihdr(0,0,12),40,97,51,49,49,49,51,32,110,101,119,41,0,0,0,0};
static C_char C_TLS li963[] C_aligned={C_lihdr(0,0,16),67,95,98,117,105,108,100,95,112,108,97,116,102,111,114,109};
static C_char C_TLS li964[] C_aligned={C_lihdr(0,0,18),67,95,115,111,102,116,119,97,114,101,95,118,101,114,115,105,111,110,0,0,0,0,0,0};
static C_char C_TLS li965[] C_aligned={C_lihdr(0,0,20),67,95,109,97,99,104,105,110,101,95,98,121,116,101,95,111,114,100,101,114,0,0,0,0};
static C_char C_TLS li966[] C_aligned={C_lihdr(0,0,14),67,95,109,97,99,104,105,110,101,95,116,121,112,101,0,0};
static C_char C_TLS li967[] C_aligned={C_lihdr(0,0,15),67,95,115,111,102,116,119,97,114,101,95,116,121,112,101,0};
static C_char C_TLS li968[] C_aligned={C_lihdr(0,0,12),40,97,51,49,50,49,50,32,115,121,109,41,0,0,0,0};
static C_char C_TLS li969[] C_aligned={C_lihdr(0,0,16),40,97,51,49,50,50,49,32,115,121,109,32,108,115,116,41};
static C_char C_TLS li970[] C_aligned={C_lihdr(0,0,10),40,97,51,49,50,54,49,32,120,41,0,0,0,0,0,0};
static C_char C_TLS li971[] C_aligned={C_lihdr(0,0,11),40,108,111,111,112,32,97,114,103,115,41,0,0,0,0,0};
static C_char C_TLS li972[] C_aligned={C_lihdr(0,0,19),40,102,51,55,48,52,52,32,120,54,56,51,55,51,55,48,52,51,41,0,0,0,0,0};
static C_char C_TLS li973[] C_aligned={C_lihdr(0,0,19),40,102,51,55,48,53,48,32,120,54,56,50,55,51,55,48,52,57,41,0,0,0,0,0};
static C_char C_TLS li974[] C_aligned={C_lihdr(0,0,19),40,102,51,55,48,53,54,32,120,54,56,50,55,51,55,48,53,53,41,0,0,0,0,0};
static C_char C_TLS li975[] C_aligned={C_lihdr(0,0,8),40,97,51,49,51,52,54,41};
static C_char C_TLS li976[] C_aligned={C_lihdr(0,0,12),40,97,51,49,51,54,56,32,100,105,114,41,0,0,0,0};
static C_char C_TLS li977[] C_aligned={C_lihdr(0,0,25),40,102,111,114,45,101,97,99,104,45,108,111,111,112,53,56,53,57,32,103,53,56,54,54,41,0,0,0,0,0,0,0};
static C_char C_TLS li978[] C_aligned={C_lihdr(0,0,8),40,97,51,49,52,49,57,41};
static C_char C_TLS li979[] C_aligned={C_lihdr(0,0,9),40,103,53,56,57,49,32,120,41,0,0,0,0,0,0,0};
static C_char C_TLS li980[] C_aligned={C_lihdr(0,0,25),40,102,111,114,45,101,97,99,104,45,108,111,111,112,53,56,57,48,32,103,53,56,57,55,41,0,0,0,0,0,0,0};
static C_char C_TLS li981[] C_aligned={C_lihdr(0,0,15),40,97,51,49,53,51,49,32,46,32,97,114,103,115,41,0};
static C_char C_TLS li982[] C_aligned={C_lihdr(0,0,19),40,97,51,49,51,55,52,32,109,115,103,32,46,32,97,114,103,115,41,0,0,0,0,0};
static C_char C_TLS li983[] C_aligned={C_lihdr(0,0,8),40,97,51,49,53,51,52,41};
static C_char C_TLS li984[] C_aligned={C_lihdr(0,0,8),40,97,51,49,53,52,51,41};
static C_char C_TLS li985[] C_aligned={C_lihdr(0,0,15),40,97,51,49,53,52,57,32,46,32,114,101,115,116,41,0};
static C_char C_TLS li986[] C_aligned={C_lihdr(0,0,10),40,97,51,49,56,49,51,32,120,41,0,0,0,0,0,0};
static C_char C_TLS li987[] C_aligned={C_lihdr(0,0,14),40,97,51,49,56,50,50,32,120,32,105,32,121,41,0,0};
static C_char C_TLS li988[] C_aligned={C_lihdr(0,0,12),40,97,51,49,56,51,50,32,120,32,121,41,0,0,0,0};
static C_char C_TLS li989[] C_aligned={C_lihdr(0,0,12),40,97,51,49,56,52,50,32,120,32,121,41,0,0,0,0};
static C_char C_TLS li990[] C_aligned={C_lihdr(0,0,12),40,97,51,49,56,53,50,32,120,32,121,41,0,0,0,0};
static C_char C_TLS li991[] C_aligned={C_lihdr(0,0,12),40,97,51,49,56,54,50,32,120,32,121,41,0,0,0,0};
static C_char C_TLS li992[] C_aligned={C_lihdr(0,0,12),40,97,51,49,56,55,50,32,120,32,121,41,0,0,0,0};
static C_char C_TLS li993[] C_aligned={C_lihdr(0,0,12),40,97,51,49,56,56,50,32,120,32,121,41,0,0,0,0};
static C_char C_TLS li994[] C_aligned={C_lihdr(0,0,12),40,97,51,49,56,57,50,32,120,32,121,41,0,0,0,0};
static C_char C_TLS li995[] C_aligned={C_lihdr(0,0,12),40,97,51,49,57,48,50,32,120,32,121,41,0,0,0,0};
static C_char C_TLS li996[] C_aligned={C_lihdr(0,0,12),40,97,51,49,57,49,50,32,120,32,121,41,0,0,0,0};
static C_char C_TLS li997[] C_aligned={C_lihdr(0,0,12),40,97,51,49,57,50,50,32,120,32,121,41,0,0,0,0};
static C_char C_TLS li998[] C_aligned={C_lihdr(0,0,12),40,97,51,49,57,51,50,32,120,32,121,41,0,0,0,0};
static C_char C_TLS li999[] C_aligned={C_lihdr(0,0,12),40,97,51,49,57,52,50,32,120,32,121,41,0,0,0,0};
static C_char C_TLS li1000[] C_aligned={C_lihdr(0,0,10),40,97,51,49,57,55,54,32,120,41,0,0,0,0,0,0};
static C_char C_TLS li1001[] C_aligned={C_lihdr(0,0,13),40,97,51,49,57,53,50,32,112,114,111,99,41,0,0,0};
static C_char C_TLS li1002[] C_aligned={C_lihdr(0,0,10),40,97,51,49,57,57,50,32,120,41,0,0,0,0,0,0};
static C_char C_TLS li1003[] C_aligned={C_lihdr(0,0,10),40,97,51,50,48,52,55,32,120,41,0,0,0,0,0,0};
static C_char C_TLS li1004[] C_aligned={C_lihdr(0,0,15),40,97,51,50,48,54,51,32,112,114,111,99,32,105,41,0};
static C_char C_TLS li1005[] C_aligned={C_lihdr(0,0,16),40,97,51,50,48,49,56,32,103,101,116,32,115,101,116,41};
static C_char C_TLS li1006[] C_aligned={C_lihdr(0,0,15),40,97,51,50,48,48,56,32,112,114,111,99,32,105,41,0};
static C_char C_TLS li1007[] C_aligned={C_lihdr(0,0,10),40,116,111,112,108,101,118,101,108,41,0,0,0,0,0,0};


#define return(x) C_cblock C_r = (C_mpointer(&C_a,(void*)(x))); goto C_ret; C_cblockend
C_regparm static C_word C_fcall stub6816(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_word i=(C_word )(C_a0);
C_return(C_main_argv[C_unfix(i)]);
C_ret:
#undef return

return C_r;}

/* from chicken.process-context#executable-pathname in k29220 in k28583 in k28523 in k27154 in k27151 in k27148 in k26381 in k26069 in k26065 in k26061 in k24957 in k23793 in k23789 in k23785 in k20253 in k20249 in k20245 in k20241 in k20237 in k19877 in k19873 in ... */
C_regparm static C_word C_fcall stub6808(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_r=C_mpointer(&C_a,(void*)C_executable_pathname());
return C_r;}

/* from k29273 */
C_regparm static C_word C_fcall stub6796(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
C_r=C_mpointer(&C_a,(void*)C_getenventry(t0));
return C_r;}

/* from k29231 in chicken.process-context#get-environment-variable in k29220 in k28583 in k28523 in k27154 in k27151 in k27148 in k26381 in k26069 in k26065 in k26061 in k24957 in k23793 in k23789 in k23785 in k20253 in k20249 in k20245 in k20241 in k20237 in k19877 in ... */
C_regparm static C_word C_fcall stub6779(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
char * t0=(char * )C_c_string(C_a0);
C_r=C_mpointer(&C_a,(void*)C_getenv(t0));
return C_r;}

/* from k28391 */
C_regparm static C_word C_fcall stub6493(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
void * t0=(void * )C_c_pointer_or_null(C_a0);
C_free(t0);
return C_r;}

/* from k28382 */
C_regparm static C_word C_fcall stub6485(C_word C_buf,C_word C_a0,C_word C_a1){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
void * t0=(void * )C_c_pointer_or_null(C_a0);
int t1=(int )C_unfix(C_a1);
C_r=C_mpointer(&C_a,(void*)C_peek_c_string_at(t0,t1));
return C_r;}

/* from k28330 */
C_regparm static C_word C_fcall stub6466(C_word C_buf,C_word C_a0,C_word C_a1){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
void * t0=(void * )C_c_pointer_or_null(C_a0);
int t1=(int )C_unfix(C_a1);
C_r=C_mpointer(&C_a,(void*)C_peek_c_string_at(t0,t1));
return C_r;}

#define return(x) C_cblock C_r = (C_mpointer(&C_a,(void*)(x))); goto C_ret; C_cblockend
C_regparm static C_word C_fcall stub5623(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_word x=(C_word )(C_a0);
C_return((C_char *)x);
C_ret:
#undef return

return C_r;}

/* from k15571 */
C_regparm static C_word C_fcall stub2829(C_word C_buf,C_word C_a0,C_word C_a1){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
double t0=(double )C_c_double(C_a0);
int t1=(int )C_unfix(C_a1);
C_r=C_flonum(&C_a,ldexp(t0,t1));
return C_r;}

C_noret_decl(f34185)
static void C_ccall f34185(C_word c,C_word *av) C_noret;
C_noret_decl(f34740)
static void C_ccall f34740(C_word c,C_word *av) C_noret;
C_noret_decl(f34949)
static void C_ccall f34949(C_word c,C_word *av) C_noret;
C_noret_decl(f34953)
static void C_ccall f34953(C_word c,C_word *av) C_noret;
C_noret_decl(f37044)
static void C_ccall f37044(C_word c,C_word *av) C_noret;
C_noret_decl(f37050)
static void C_ccall f37050(C_word c,C_word *av) C_noret;
C_noret_decl(f37056)
static void C_ccall f37056(C_word c,C_word *av) C_noret;
C_noret_decl(f_10010)
static void C_ccall f_10010(C_word c,C_word *av) C_noret;
C_noret_decl(f_10017)
static void C_fcall f_10017(C_word t0,C_word t1) C_noret;
C_noret_decl(f_10020)
static void C_ccall f_10020(C_word c,C_word *av) C_noret;
C_noret_decl(f_10049)
static void C_ccall f_10049(C_word c,C_word *av) C_noret;
C_noret_decl(f_10055)
static void C_fcall f_10055(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_10071)
static void C_ccall f_10071(C_word c,C_word *av) C_noret;
C_noret_decl(f_10096)
static void C_ccall f_10096(C_word c,C_word *av) C_noret;
C_noret_decl(f_10105)
static void C_fcall f_10105(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_10146)
static void C_ccall f_10146(C_word c,C_word *av) C_noret;
C_noret_decl(f_10168)
static void C_ccall f_10168(C_word c,C_word *av) C_noret;
C_noret_decl(f_10200)
static void C_ccall f_10200(C_word c,C_word *av) C_noret;
C_noret_decl(f_10216)
static void C_fcall f_10216(C_word t0,C_word t1) C_noret;
C_noret_decl(f_10219)
static void C_ccall f_10219(C_word c,C_word *av) C_noret;
C_noret_decl(f_10241)
static void C_ccall f_10241(C_word c,C_word *av) C_noret;
C_noret_decl(f_10247)
static void C_fcall f_10247(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_10272)
static void C_ccall f_10272(C_word c,C_word *av) C_noret;
C_noret_decl(f_10312)
static void C_ccall f_10312(C_word c,C_word *av) C_noret;
C_noret_decl(f_10324)
static void C_fcall f_10324(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_10343)
static void C_ccall f_10343(C_word c,C_word *av) C_noret;
C_noret_decl(f_10365)
static void C_ccall f_10365(C_word c,C_word *av) C_noret;
C_noret_decl(f_10368)
static void C_ccall f_10368(C_word c,C_word *av) C_noret;
C_noret_decl(f_10371)
static void C_ccall f_10371(C_word c,C_word *av) C_noret;
C_noret_decl(f_10374)
static void C_ccall f_10374(C_word c,C_word *av) C_noret;
C_noret_decl(f_10380)
static void C_ccall f_10380(C_word c,C_word *av) C_noret;
C_noret_decl(f_10383)
static void C_ccall f_10383(C_word c,C_word *av) C_noret;
C_noret_decl(f_10386)
static void C_ccall f_10386(C_word c,C_word *av) C_noret;
C_noret_decl(f_10389)
static void C_ccall f_10389(C_word c,C_word *av) C_noret;
C_noret_decl(f_10392)
static void C_ccall f_10392(C_word c,C_word *av) C_noret;
C_noret_decl(f_10395)
static void C_ccall f_10395(C_word c,C_word *av) C_noret;
C_noret_decl(f_10398)
static void C_ccall f_10398(C_word c,C_word *av) C_noret;
C_noret_decl(f_10401)
static void C_ccall f_10401(C_word c,C_word *av) C_noret;
C_noret_decl(f_10404)
static void C_ccall f_10404(C_word c,C_word *av) C_noret;
C_noret_decl(f_10407)
static void C_ccall f_10407(C_word c,C_word *av) C_noret;
C_noret_decl(f_10410)
static void C_ccall f_10410(C_word c,C_word *av) C_noret;
C_noret_decl(f_10413)
static void C_ccall f_10413(C_word c,C_word *av) C_noret;
C_noret_decl(f_10416)
static void C_ccall f_10416(C_word c,C_word *av) C_noret;
C_noret_decl(f_10419)
static void C_ccall f_10419(C_word c,C_word *av) C_noret;
C_noret_decl(f_10422)
static void C_ccall f_10422(C_word c,C_word *av) C_noret;
C_noret_decl(f_10425)
static void C_ccall f_10425(C_word c,C_word *av) C_noret;
C_noret_decl(f_10428)
static void C_ccall f_10428(C_word c,C_word *av) C_noret;
C_noret_decl(f_10431)
static void C_ccall f_10431(C_word c,C_word *av) C_noret;
C_noret_decl(f_10434)
static void C_ccall f_10434(C_word c,C_word *av) C_noret;
C_noret_decl(f_10437)
static void C_ccall f_10437(C_word c,C_word *av) C_noret;
C_noret_decl(f_10440)
static void C_ccall f_10440(C_word c,C_word *av) C_noret;
C_noret_decl(f_10443)
static void C_ccall f_10443(C_word c,C_word *av) C_noret;
C_noret_decl(f_10446)
static void C_ccall f_10446(C_word c,C_word *av) C_noret;
C_noret_decl(f_10449)
static void C_ccall f_10449(C_word c,C_word *av) C_noret;
C_noret_decl(f_10452)
static void C_ccall f_10452(C_word c,C_word *av) C_noret;
C_noret_decl(f_10457)
static void C_ccall f_10457(C_word c,C_word *av) C_noret;
C_noret_decl(f_10466)
static void C_ccall f_10466(C_word c,C_word *av) C_noret;
C_noret_decl(f_10478)
static void C_ccall f_10478(C_word c,C_word *av) C_noret;
C_noret_decl(f_10493)
static void C_ccall f_10493(C_word c,C_word *av) C_noret;
C_noret_decl(f_10496)
static void C_ccall f_10496(C_word c,C_word *av) C_noret;
C_noret_decl(f_10504)
static void C_ccall f_10504(C_word c,C_word *av) C_noret;
C_noret_decl(f_10508)
static void C_ccall f_10508(C_word c,C_word *av) C_noret;
C_noret_decl(f_10510)
static void C_ccall f_10510(C_word c,C_word *av) C_noret;
C_noret_decl(f_10514)
static void C_ccall f_10514(C_word c,C_word *av) C_noret;
C_noret_decl(f_10517)
static void C_ccall f_10517(C_word c,C_word *av) C_noret;
C_noret_decl(f_10528)
static void C_ccall f_10528(C_word c,C_word *av) C_noret;
C_noret_decl(f_10530)
static void C_ccall f_10530(C_word c,C_word *av) C_noret;
C_noret_decl(f_10537)
static void C_ccall f_10537(C_word c,C_word *av) C_noret;
C_noret_decl(f_10540)
static void C_ccall f_10540(C_word c,C_word *av) C_noret;
C_noret_decl(f_10543)
static void C_ccall f_10543(C_word c,C_word *av) C_noret;
C_noret_decl(f_10548)
static void C_ccall f_10548(C_word c,C_word *av) C_noret;
C_noret_decl(f_10552)
static void C_ccall f_10552(C_word c,C_word *av) C_noret;
C_noret_decl(f_10557)
static void C_ccall f_10557(C_word c,C_word *av) C_noret;
C_noret_decl(f_10561)
static void C_ccall f_10561(C_word c,C_word *av) C_noret;
C_noret_decl(f_10564)
static void C_ccall f_10564(C_word c,C_word *av) C_noret;
C_noret_decl(f_10592)
static void C_ccall f_10592(C_word c,C_word *av) C_noret;
C_noret_decl(f_10595)
static void C_ccall f_10595(C_word c,C_word *av) C_noret;
C_noret_decl(f_10598)
static void C_ccall f_10598(C_word c,C_word *av) C_noret;
C_noret_decl(f_10615)
static void C_ccall f_10615(C_word c,C_word *av) C_noret;
C_noret_decl(f_10626)
static void C_ccall f_10626(C_word c,C_word *av) C_noret;
C_noret_decl(f_10638)
static void C_ccall f_10638(C_word c,C_word *av) C_noret;
C_noret_decl(f_10649)
static void C_ccall f_10649(C_word c,C_word *av) C_noret;
C_noret_decl(f_10660)
static void C_ccall f_10660(C_word c,C_word *av) C_noret;
C_noret_decl(f_10671)
static void C_ccall f_10671(C_word c,C_word *av) C_noret;
C_noret_decl(f_10682)
static void C_ccall f_10682(C_word c,C_word *av) C_noret;
C_noret_decl(f_10693)
static void C_ccall f_10693(C_word c,C_word *av) C_noret;
C_noret_decl(f_10704)
static void C_ccall f_10704(C_word c,C_word *av) C_noret;
C_noret_decl(f_10715)
static void C_ccall f_10715(C_word c,C_word *av) C_noret;
C_noret_decl(f_10726)
static void C_ccall f_10726(C_word c,C_word *av) C_noret;
C_noret_decl(f_10737)
static void C_ccall f_10737(C_word c,C_word *av) C_noret;
C_noret_decl(f_10748)
static void C_ccall f_10748(C_word c,C_word *av) C_noret;
C_noret_decl(f_10759)
static void C_ccall f_10759(C_word c,C_word *av) C_noret;
C_noret_decl(f_10770)
static void C_ccall f_10770(C_word c,C_word *av) C_noret;
C_noret_decl(f_10781)
static void C_ccall f_10781(C_word c,C_word *av) C_noret;
C_noret_decl(f_10798)
static void C_ccall f_10798(C_word c,C_word *av) C_noret;
C_noret_decl(f_10815)
static void C_ccall f_10815(C_word c,C_word *av) C_noret;
C_noret_decl(f_10839)
static void C_ccall f_10839(C_word c,C_word *av) C_noret;
C_noret_decl(f_10856)
static void C_ccall f_10856(C_word c,C_word *av) C_noret;
C_noret_decl(f_10860)
static void C_ccall f_10860(C_word c,C_word *av) C_noret;
C_noret_decl(f_10886)
static void C_ccall f_10886(C_word c,C_word *av) C_noret;
C_noret_decl(f_10906)
static void C_ccall f_10906(C_word c,C_word *av) C_noret;
C_noret_decl(f_10917)
static void C_ccall f_10917(C_word c,C_word *av) C_noret;
C_noret_decl(f_10929)
static void C_fcall f_10929(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_10963)
static void C_ccall f_10963(C_word c,C_word *av) C_noret;
C_noret_decl(f_10978)
static void C_fcall f_10978(C_word t0,C_word t1) C_noret;
C_noret_decl(f_11045)
static void C_ccall f_11045(C_word c,C_word *av) C_noret;
C_noret_decl(f_11061)
static void C_ccall f_11061(C_word c,C_word *av) C_noret;
C_noret_decl(f_11077)
static void C_ccall f_11077(C_word c,C_word *av) C_noret;
C_noret_decl(f_11093)
static void C_ccall f_11093(C_word c,C_word *av) C_noret;
C_noret_decl(f_11109)
static void C_ccall f_11109(C_word c,C_word *av) C_noret;
C_noret_decl(f_11125)
static void C_ccall f_11125(C_word c,C_word *av) C_noret;
C_noret_decl(f_11141)
static void C_ccall f_11141(C_word c,C_word *av) C_noret;
C_noret_decl(f_11157)
static void C_ccall f_11157(C_word c,C_word *av) C_noret;
C_noret_decl(f_11173)
static void C_ccall f_11173(C_word c,C_word *av) C_noret;
C_noret_decl(f_11185)
static void C_fcall f_11185(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_11204)
static void C_fcall f_11204(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_11235)
static void C_ccall f_11235(C_word c,C_word *av) C_noret;
C_noret_decl(f_11252)
static void C_ccall f_11252(C_word c,C_word *av) C_noret;
C_noret_decl(f_11258)
static void C_fcall f_11258(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_11282)
static void C_ccall f_11282(C_word c,C_word *av) C_noret;
C_noret_decl(f_11302)
static void C_ccall f_11302(C_word c,C_word *av) C_noret;
C_noret_decl(f_11306)
static void C_ccall f_11306(C_word c,C_word *av) C_noret;
C_noret_decl(f_11309)
static void C_ccall f_11309(C_word c,C_word *av) C_noret;
C_noret_decl(f_11338)
static void C_ccall f_11338(C_word c,C_word *av) C_noret;
C_noret_decl(f_11354)
static void C_fcall f_11354(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_11376)
static void C_ccall f_11376(C_word c,C_word *av) C_noret;
C_noret_decl(f_11392)
static void C_ccall f_11392(C_word c,C_word *av) C_noret;
C_noret_decl(f_11397)
static C_word C_fcall f_11397(C_word t0,C_word t1,C_word t2);
C_noret_decl(f_11428)
static void C_ccall f_11428(C_word c,C_word *av) C_noret;
C_noret_decl(f_11439)
static void C_ccall f_11439(C_word c,C_word *av) C_noret;
C_noret_decl(f_11448)
static C_word C_fcall f_11448(C_word t0,C_word t1,C_word t2);
C_noret_decl(f_11477)
static void C_ccall f_11477(C_word c,C_word *av) C_noret;
C_noret_decl(f_11490)
static void C_ccall f_11490(C_word c,C_word *av) C_noret;
C_noret_decl(f_11500)
static void C_ccall f_11500(C_word c,C_word *av) C_noret;
C_noret_decl(f_11502)
static void C_ccall f_11502(C_word c,C_word *av) C_noret;
C_noret_decl(f_11509)
static void C_ccall f_11509(C_word c,C_word *av) C_noret;
C_noret_decl(f_11512)
static void C_fcall f_11512(C_word t0,C_word t1) C_noret;
C_noret_decl(f_11521)
static void C_fcall f_11521(C_word t0,C_word t1) C_noret;
C_noret_decl(f_11547)
static void C_ccall f_11547(C_word c,C_word *av) C_noret;
C_noret_decl(f_11552)
static void C_ccall f_11552(C_word c,C_word *av) C_noret;
C_noret_decl(f_11556)
static void C_ccall f_11556(C_word c,C_word *av) C_noret;
C_noret_decl(f_11561)
static void C_ccall f_11561(C_word c,C_word *av) C_noret;
C_noret_decl(f_11582)
static void C_ccall f_11582(C_word c,C_word *av) C_noret;
C_noret_decl(f_11588)
static void C_ccall f_11588(C_word c,C_word *av) C_noret;
C_noret_decl(f_11606)
static void C_ccall f_11606(C_word c,C_word *av) C_noret;
C_noret_decl(f_11612)
static void C_ccall f_11612(C_word c,C_word *av) C_noret;
C_noret_decl(f_11630)
static void C_ccall f_11630(C_word c,C_word *av) C_noret;
C_noret_decl(f_11636)
static void C_ccall f_11636(C_word c,C_word *av) C_noret;
C_noret_decl(f_11651)
static void C_ccall f_11651(C_word c,C_word *av) C_noret;
C_noret_decl(f_11657)
static void C_ccall f_11657(C_word c,C_word *av) C_noret;
C_noret_decl(f_11671)
static void C_ccall f_11671(C_word c,C_word *av) C_noret;
C_noret_decl(f_11692)
static void C_ccall f_11692(C_word c,C_word *av) C_noret;
C_noret_decl(f_11698)
static void C_ccall f_11698(C_word c,C_word *av) C_noret;
C_noret_decl(f_11716)
static void C_ccall f_11716(C_word c,C_word *av) C_noret;
C_noret_decl(f_11722)
static void C_ccall f_11722(C_word c,C_word *av) C_noret;
C_noret_decl(f_11740)
static void C_ccall f_11740(C_word c,C_word *av) C_noret;
C_noret_decl(f_11746)
static void C_ccall f_11746(C_word c,C_word *av) C_noret;
C_noret_decl(f_11761)
static void C_ccall f_11761(C_word c,C_word *av) C_noret;
C_noret_decl(f_11767)
static void C_ccall f_11767(C_word c,C_word *av) C_noret;
C_noret_decl(f_11782)
static void C_ccall f_11782(C_word c,C_word *av) C_noret;
C_noret_decl(f_11792)
static void C_ccall f_11792(C_word c,C_word *av) C_noret;
C_noret_decl(f_11798)
static void C_ccall f_11798(C_word c,C_word *av) C_noret;
C_noret_decl(f_11802)
static void C_ccall f_11802(C_word c,C_word *av) C_noret;
C_noret_decl(f_11804)
static void C_fcall f_11804(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_11815)
static void C_ccall f_11815(C_word c,C_word *av) C_noret;
C_noret_decl(f_11827)
static void C_ccall f_11827(C_word c,C_word *av) C_noret;
C_noret_decl(f_11837)
static void C_ccall f_11837(C_word c,C_word *av) C_noret;
C_noret_decl(f_11843)
static void C_ccall f_11843(C_word c,C_word *av) C_noret;
C_noret_decl(f_11847)
static void C_ccall f_11847(C_word c,C_word *av) C_noret;
C_noret_decl(f_11852)
static C_word C_fcall f_11852(C_word t0,C_word t1,C_word t2);
C_noret_decl(f_11878)
static void C_ccall f_11878(C_word c,C_word *av) C_noret;
C_noret_decl(f_11882)
static void C_ccall f_11882(C_word c,C_word *av) C_noret;
C_noret_decl(f_11885)
static void C_ccall f_11885(C_word c,C_word *av) C_noret;
C_noret_decl(f_11893)
static void C_fcall f_11893(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_11914)
static void C_fcall f_11914(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_11928)
static void C_ccall f_11928(C_word c,C_word *av) C_noret;
C_noret_decl(f_11932)
static void C_ccall f_11932(C_word c,C_word *av) C_noret;
C_noret_decl(f_11973)
static void C_ccall f_11973(C_word c,C_word *av) C_noret;
C_noret_decl(f_11995)
static void C_ccall f_11995(C_word c,C_word *av) C_noret;
C_noret_decl(f_11997)
static void C_ccall f_11997(C_word c,C_word *av) C_noret;
C_noret_decl(f_12019)
static void C_ccall f_12019(C_word c,C_word *av) C_noret;
C_noret_decl(f_12021)
static void C_ccall f_12021(C_word c,C_word *av) C_noret;
C_noret_decl(f_12043)
static void C_ccall f_12043(C_word c,C_word *av) C_noret;
C_noret_decl(f_12045)
static void C_ccall f_12045(C_word c,C_word *av) C_noret;
C_noret_decl(f_12067)
static void C_ccall f_12067(C_word c,C_word *av) C_noret;
C_noret_decl(f_12069)
static void C_ccall f_12069(C_word c,C_word *av) C_noret;
C_noret_decl(f_12091)
static void C_ccall f_12091(C_word c,C_word *av) C_noret;
C_noret_decl(f_12093)
static void C_ccall f_12093(C_word c,C_word *av) C_noret;
C_noret_decl(f_12115)
static void C_ccall f_12115(C_word c,C_word *av) C_noret;
C_noret_decl(f_12117)
static void C_ccall f_12117(C_word c,C_word *av) C_noret;
C_noret_decl(f_12139)
static void C_ccall f_12139(C_word c,C_word *av) C_noret;
C_noret_decl(f_12141)
static void C_ccall f_12141(C_word c,C_word *av) C_noret;
C_noret_decl(f_12163)
static void C_ccall f_12163(C_word c,C_word *av) C_noret;
C_noret_decl(f_12165)
static void C_ccall f_12165(C_word c,C_word *av) C_noret;
C_noret_decl(f_12187)
static void C_ccall f_12187(C_word c,C_word *av) C_noret;
C_noret_decl(f_12189)
static void C_ccall f_12189(C_word c,C_word *av) C_noret;
C_noret_decl(f_12211)
static void C_ccall f_12211(C_word c,C_word *av) C_noret;
C_noret_decl(f_12213)
static void C_ccall f_12213(C_word c,C_word *av) C_noret;
C_noret_decl(f_12235)
static void C_ccall f_12235(C_word c,C_word *av) C_noret;
C_noret_decl(f_12237)
static void C_ccall f_12237(C_word c,C_word *av) C_noret;
C_noret_decl(f_12253)
static void C_ccall f_12253(C_word c,C_word *av) C_noret;
C_noret_decl(f_12255)
static void C_ccall f_12255(C_word c,C_word *av) C_noret;
C_noret_decl(f_12277)
static void C_ccall f_12277(C_word c,C_word *av) C_noret;
C_noret_decl(f_12279)
static void C_ccall f_12279(C_word c,C_word *av) C_noret;
C_noret_decl(f_12301)
static void C_ccall f_12301(C_word c,C_word *av) C_noret;
C_noret_decl(f_12303)
static void C_ccall f_12303(C_word c,C_word *av) C_noret;
C_noret_decl(f_12319)
static void C_ccall f_12319(C_word c,C_word *av) C_noret;
C_noret_decl(f_12321)
static void C_ccall f_12321(C_word c,C_word *av) C_noret;
C_noret_decl(f_12337)
static void C_ccall f_12337(C_word c,C_word *av) C_noret;
C_noret_decl(f_12339)
static void C_ccall f_12339(C_word c,C_word *av) C_noret;
C_noret_decl(f_12355)
static void C_ccall f_12355(C_word c,C_word *av) C_noret;
C_noret_decl(f_12357)
static void C_ccall f_12357(C_word c,C_word *av) C_noret;
C_noret_decl(f_12373)
static void C_ccall f_12373(C_word c,C_word *av) C_noret;
C_noret_decl(f_12375)
static void C_ccall f_12375(C_word c,C_word *av) C_noret;
C_noret_decl(f_12391)
static void C_ccall f_12391(C_word c,C_word *av) C_noret;
C_noret_decl(f_12393)
static void C_ccall f_12393(C_word c,C_word *av) C_noret;
C_noret_decl(f_12409)
static void C_ccall f_12409(C_word c,C_word *av) C_noret;
C_noret_decl(f_12411)
static void C_ccall f_12411(C_word c,C_word *av) C_noret;
C_noret_decl(f_12427)
static void C_ccall f_12427(C_word c,C_word *av) C_noret;
C_noret_decl(f_12429)
static void C_ccall f_12429(C_word c,C_word *av) C_noret;
C_noret_decl(f_12445)
static void C_ccall f_12445(C_word c,C_word *av) C_noret;
C_noret_decl(f_12447)
static void C_ccall f_12447(C_word c,C_word *av) C_noret;
C_noret_decl(f_12463)
static void C_ccall f_12463(C_word c,C_word *av) C_noret;
C_noret_decl(f_12465)
static void C_ccall f_12465(C_word c,C_word *av) C_noret;
C_noret_decl(f_12481)
static void C_ccall f_12481(C_word c,C_word *av) C_noret;
C_noret_decl(f_12483)
static void C_ccall f_12483(C_word c,C_word *av) C_noret;
C_noret_decl(f_12505)
static void C_ccall f_12505(C_word c,C_word *av) C_noret;
C_noret_decl(f_12507)
static void C_ccall f_12507(C_word c,C_word *av) C_noret;
C_noret_decl(f_12523)
static void C_ccall f_12523(C_word c,C_word *av) C_noret;
C_noret_decl(f_12525)
static void C_ccall f_12525(C_word c,C_word *av) C_noret;
C_noret_decl(f_12547)
static void C_ccall f_12547(C_word c,C_word *av) C_noret;
C_noret_decl(f_12549)
static void C_ccall f_12549(C_word c,C_word *av) C_noret;
C_noret_decl(f_12565)
static void C_ccall f_12565(C_word c,C_word *av) C_noret;
C_noret_decl(f_12567)
static void C_ccall f_12567(C_word c,C_word *av) C_noret;
C_noret_decl(f_12583)
static void C_ccall f_12583(C_word c,C_word *av) C_noret;
C_noret_decl(f_12585)
static void C_ccall f_12585(C_word c,C_word *av) C_noret;
C_noret_decl(f_12601)
static void C_ccall f_12601(C_word c,C_word *av) C_noret;
C_noret_decl(f_12603)
static void C_ccall f_12603(C_word c,C_word *av) C_noret;
C_noret_decl(f_12619)
static void C_ccall f_12619(C_word c,C_word *av) C_noret;
C_noret_decl(f_12621)
static void C_ccall f_12621(C_word c,C_word *av) C_noret;
C_noret_decl(f_12631)
static void C_ccall f_12631(C_word c,C_word *av) C_noret;
C_noret_decl(f_12643)
static void C_fcall f_12643(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_12653)
static void C_ccall f_12653(C_word c,C_word *av) C_noret;
C_noret_decl(f_12657)
static void C_ccall f_12657(C_word c,C_word *av) C_noret;
C_noret_decl(f_12679)
static void C_ccall f_12679(C_word c,C_word *av) C_noret;
C_noret_decl(f_12683)
static void C_ccall f_12683(C_word c,C_word *av) C_noret;
C_noret_decl(f_12686)
static void C_ccall f_12686(C_word c,C_word *av) C_noret;
C_noret_decl(f_12691)
static void C_ccall f_12691(C_word c,C_word *av) C_noret;
C_noret_decl(f_12695)
static void C_ccall f_12695(C_word c,C_word *av) C_noret;
C_noret_decl(f_12698)
static void C_ccall f_12698(C_word c,C_word *av) C_noret;
C_noret_decl(f_12701)
static void C_ccall f_12701(C_word c,C_word *av) C_noret;
C_noret_decl(f_12714)
static void C_ccall f_12714(C_word c,C_word *av) C_noret;
C_noret_decl(f_12737)
static void C_ccall f_12737(C_word c,C_word *av) C_noret;
C_noret_decl(f_12763)
static void C_ccall f_12763(C_word c,C_word *av) C_noret;
C_noret_decl(f_12772)
static void C_ccall f_12772(C_word c,C_word *av) C_noret;
C_noret_decl(f_12777)
static void C_ccall f_12777(C_word c,C_word *av) C_noret;
C_noret_decl(f_12779)
static void C_ccall f_12779(C_word c,C_word *av) C_noret;
C_noret_decl(f_12823)
static C_word C_fcall f_12823(C_word *a,C_word t0,C_word t1);
C_noret_decl(f_12869)
static void C_ccall f_12869(C_word c,C_word *av) C_noret;
C_noret_decl(f_12893)
static void C_ccall f_12893(C_word c,C_word *av) C_noret;
C_noret_decl(f_12897)
static void C_ccall f_12897(C_word c,C_word *av) C_noret;
C_noret_decl(f_12915)
static void C_ccall f_12915(C_word c,C_word *av) C_noret;
C_noret_decl(f_12939)
static void C_ccall f_12939(C_word c,C_word *av) C_noret;
C_noret_decl(f_12943)
static void C_ccall f_12943(C_word c,C_word *av) C_noret;
C_noret_decl(f_12961)
static void C_ccall f_12961(C_word c,C_word *av) C_noret;
C_noret_decl(f_13002)
static void C_fcall f_13002(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_13013)
static void C_ccall f_13013(C_word c,C_word *av) C_noret;
C_noret_decl(f_13019)
static void C_fcall f_13019(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_13023)
static void C_ccall f_13023(C_word c,C_word *av) C_noret;
C_noret_decl(f_13037)
static void C_ccall f_13037(C_word c,C_word *av) C_noret;
C_noret_decl(f_13050)
static void C_ccall f_13050(C_word c,C_word *av) C_noret;
C_noret_decl(f_13054)
static void C_ccall f_13054(C_word c,C_word *av) C_noret;
C_noret_decl(f_13071)
static void C_ccall f_13071(C_word c,C_word *av) C_noret;
C_noret_decl(f_13075)
static void C_ccall f_13075(C_word c,C_word *av) C_noret;
C_noret_decl(f_13081)
static void C_ccall f_13081(C_word c,C_word *av) C_noret;
C_noret_decl(f_13085)
static void C_ccall f_13085(C_word c,C_word *av) C_noret;
C_noret_decl(f_13125)
static void C_ccall f_13125(C_word c,C_word *av) C_noret;
C_noret_decl(f_13129)
static void C_ccall f_13129(C_word c,C_word *av) C_noret;
C_noret_decl(f_13151)
static void C_ccall f_13151(C_word c,C_word *av) C_noret;
C_noret_decl(f_13154)
static void C_ccall f_13154(C_word c,C_word *av) C_noret;
C_noret_decl(f_13157)
static void C_ccall f_13157(C_word c,C_word *av) C_noret;
C_noret_decl(f_13160)
static void C_ccall f_13160(C_word c,C_word *av) C_noret;
C_noret_decl(f_13163)
static void C_ccall f_13163(C_word c,C_word *av) C_noret;
C_noret_decl(f_13184)
static void C_ccall f_13184(C_word c,C_word *av) C_noret;
C_noret_decl(f_13186)
static void C_fcall f_13186(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_13204)
static void C_ccall f_13204(C_word c,C_word *av) C_noret;
C_noret_decl(f_13214)
static void C_ccall f_13214(C_word c,C_word *av) C_noret;
C_noret_decl(f_13218)
static void C_ccall f_13218(C_word c,C_word *av) C_noret;
C_noret_decl(f_13256)
static void C_ccall f_13256(C_word c,C_word *av) C_noret;
C_noret_decl(f_13259)
static void C_ccall f_13259(C_word c,C_word *av) C_noret;
C_noret_decl(f_13262)
static void C_ccall f_13262(C_word c,C_word *av) C_noret;
C_noret_decl(f_13265)
static void C_ccall f_13265(C_word c,C_word *av) C_noret;
C_noret_decl(f_13271)
static void C_ccall f_13271(C_word c,C_word *av) C_noret;
C_noret_decl(f_13274)
static void C_ccall f_13274(C_word c,C_word *av) C_noret;
C_noret_decl(f_13322)
static void C_ccall f_13322(C_word c,C_word *av) C_noret;
C_noret_decl(f_13326)
static void C_ccall f_13326(C_word c,C_word *av) C_noret;
C_noret_decl(f_13403)
static void C_ccall f_13403(C_word c,C_word *av) C_noret;
C_noret_decl(f_13442)
static void C_ccall f_13442(C_word c,C_word *av) C_noret;
C_noret_decl(f_13497)
static void C_ccall f_13497(C_word c,C_word *av) C_noret;
C_noret_decl(f_13542)
static void C_ccall f_13542(C_word c,C_word *av) C_noret;
C_noret_decl(f_13587)
static void C_ccall f_13587(C_word c,C_word *av) C_noret;
C_noret_decl(f_13624)
static void C_ccall f_13624(C_word c,C_word *av) C_noret;
C_noret_decl(f_13644)
static void C_ccall f_13644(C_word c,C_word *av) C_noret;
C_noret_decl(f_13668)
static void C_fcall f_13668(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_13671)
static void C_fcall f_13671(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_13675)
static void C_ccall f_13675(C_word c,C_word *av) C_noret;
C_noret_decl(f_13678)
static void C_ccall f_13678(C_word c,C_word *av) C_noret;
C_noret_decl(f_13696)
static void C_ccall f_13696(C_word c,C_word *av) C_noret;
C_noret_decl(f_13719)
static void C_ccall f_13719(C_word c,C_word *av) C_noret;
C_noret_decl(f_13723)
static void C_ccall f_13723(C_word c,C_word *av) C_noret;
C_noret_decl(f_13746)
static void C_ccall f_13746(C_word c,C_word *av) C_noret;
C_noret_decl(f_13750)
static void C_ccall f_13750(C_word c,C_word *av) C_noret;
C_noret_decl(f_13782)
static void C_ccall f_13782(C_word c,C_word *av) C_noret;
C_noret_decl(f_13818)
static void C_ccall f_13818(C_word c,C_word *av) C_noret;
C_noret_decl(f_13822)
static void C_ccall f_13822(C_word c,C_word *av) C_noret;
C_noret_decl(f_13841)
static void C_ccall f_13841(C_word c,C_word *av) C_noret;
C_noret_decl(f_13843)
static void C_ccall f_13843(C_word c,C_word *av) C_noret;
C_noret_decl(f_13850)
static void C_fcall f_13850(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_13887)
static void C_ccall f_13887(C_word c,C_word *av) C_noret;
C_noret_decl(f_13894)
static void C_fcall f_13894(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_13931)
static void C_ccall f_13931(C_word c,C_word *av) C_noret;
C_noret_decl(f_13949)
static void C_ccall f_13949(C_word c,C_word *av) C_noret;
C_noret_decl(f_13958)
static void C_ccall f_13958(C_word c,C_word *av) C_noret;
C_noret_decl(f_13963)
static void C_ccall f_13963(C_word c,C_word *av) C_noret;
C_noret_decl(f_13976)
static void C_ccall f_13976(C_word c,C_word *av) C_noret;
C_noret_decl(f_14002)
static void C_ccall f_14002(C_word c,C_word *av) C_noret;
C_noret_decl(f_14010)
static void C_ccall f_14010(C_word c,C_word *av) C_noret;
C_noret_decl(f_14014)
static void C_ccall f_14014(C_word c,C_word *av) C_noret;
C_noret_decl(f_14018)
static void C_ccall f_14018(C_word c,C_word *av) C_noret;
C_noret_decl(f_14022)
static void C_ccall f_14022(C_word c,C_word *av) C_noret;
C_noret_decl(f_14025)
static void C_ccall f_14025(C_word c,C_word *av) C_noret;
C_noret_decl(f_14039)
static void C_ccall f_14039(C_word c,C_word *av) C_noret;
C_noret_decl(f_14043)
static void C_ccall f_14043(C_word c,C_word *av) C_noret;
C_noret_decl(f_14054)
static void C_ccall f_14054(C_word c,C_word *av) C_noret;
C_noret_decl(f_14078)
static void C_ccall f_14078(C_word c,C_word *av) C_noret;
C_noret_decl(f_14082)
static void C_ccall f_14082(C_word c,C_word *av) C_noret;
C_noret_decl(f_14088)
static void C_ccall f_14088(C_word c,C_word *av) C_noret;
C_noret_decl(f_14112)
static void C_ccall f_14112(C_word c,C_word *av) C_noret;
C_noret_decl(f_14116)
static void C_ccall f_14116(C_word c,C_word *av) C_noret;
C_noret_decl(f_14122)
static void C_ccall f_14122(C_word c,C_word *av) C_noret;
C_noret_decl(f_14139)
static void C_ccall f_14139(C_word c,C_word *av) C_noret;
C_noret_decl(f_14143)
static void C_ccall f_14143(C_word c,C_word *av) C_noret;
C_noret_decl(f_14147)
static void C_ccall f_14147(C_word c,C_word *av) C_noret;
C_noret_decl(f_14157)
static void C_fcall f_14157(C_word t0,C_word t1) C_noret;
C_noret_decl(f_14163)
static void C_fcall f_14163(C_word t0,C_word t1) C_noret;
C_noret_decl(f_14170)
static void C_ccall f_14170(C_word c,C_word *av) C_noret;
C_noret_decl(f_14182)
static void C_ccall f_14182(C_word c,C_word *av) C_noret;
C_noret_decl(f_14205)
static void C_ccall f_14205(C_word c,C_word *av) C_noret;
C_noret_decl(f_14209)
static void C_ccall f_14209(C_word c,C_word *av) C_noret;
C_noret_decl(f_14219)
static void C_fcall f_14219(C_word t0,C_word t1) C_noret;
C_noret_decl(f_14225)
static void C_fcall f_14225(C_word t0,C_word t1) C_noret;
C_noret_decl(f_14232)
static void C_ccall f_14232(C_word c,C_word *av) C_noret;
C_noret_decl(f_14247)
static void C_ccall f_14247(C_word c,C_word *av) C_noret;
C_noret_decl(f_14251)
static void C_ccall f_14251(C_word c,C_word *av) C_noret;
C_noret_decl(f_14284)
static void C_ccall f_14284(C_word c,C_word *av) C_noret;
C_noret_decl(f_14288)
static void C_ccall f_14288(C_word c,C_word *av) C_noret;
C_noret_decl(f_14305)
static void C_ccall f_14305(C_word c,C_word *av) C_noret;
C_noret_decl(f_14315)
static void C_ccall f_14315(C_word c,C_word *av) C_noret;
C_noret_decl(f_14388)
static void C_ccall f_14388(C_word c,C_word *av) C_noret;
C_noret_decl(f_14402)
static void C_ccall f_14402(C_word c,C_word *av) C_noret;
C_noret_decl(f_14419)
static void C_ccall f_14419(C_word c,C_word *av) C_noret;
C_noret_decl(f_14435)
static void C_ccall f_14435(C_word c,C_word *av) C_noret;
C_noret_decl(f_14506)
static void C_ccall f_14506(C_word c,C_word *av) C_noret;
C_noret_decl(f_14510)
static void C_ccall f_14510(C_word c,C_word *av) C_noret;
C_noret_decl(f_14515)
static void C_ccall f_14515(C_word c,C_word *av) C_noret;
C_noret_decl(f_14525)
static void C_ccall f_14525(C_word c,C_word *av) C_noret;
C_noret_decl(f_14529)
static void C_ccall f_14529(C_word c,C_word *av) C_noret;
C_noret_decl(f_14544)
static void C_ccall f_14544(C_word c,C_word *av) C_noret;
C_noret_decl(f_14548)
static void C_ccall f_14548(C_word c,C_word *av) C_noret;
C_noret_decl(f_14565)
static void C_ccall f_14565(C_word c,C_word *av) C_noret;
C_noret_decl(f_14576)
static void C_ccall f_14576(C_word c,C_word *av) C_noret;
C_noret_decl(f_14582)
static void C_ccall f_14582(C_word c,C_word *av) C_noret;
C_noret_decl(f_14593)
static void C_ccall f_14593(C_word c,C_word *av) C_noret;
C_noret_decl(f_14604)
static void C_ccall f_14604(C_word c,C_word *av) C_noret;
C_noret_decl(f_14616)
static void C_ccall f_14616(C_word c,C_word *av) C_noret;
C_noret_decl(f_14628)
static void C_ccall f_14628(C_word c,C_word *av) C_noret;
C_noret_decl(f_14640)
static void C_ccall f_14640(C_word c,C_word *av) C_noret;
C_noret_decl(f_14657)
static void C_ccall f_14657(C_word c,C_word *av) C_noret;
C_noret_decl(f_14664)
static void C_ccall f_14664(C_word c,C_word *av) C_noret;
C_noret_decl(f_14668)
static void C_ccall f_14668(C_word c,C_word *av) C_noret;
C_noret_decl(f_14670)
static void C_ccall f_14670(C_word c,C_word *av) C_noret;
C_noret_decl(f_14676)
static void C_ccall f_14676(C_word c,C_word *av) C_noret;
C_noret_decl(f_14680)
static void C_ccall f_14680(C_word c,C_word *av) C_noret;
C_noret_decl(f_14683)
static void C_ccall f_14683(C_word c,C_word *av) C_noret;
C_noret_decl(f_14688)
static void C_ccall f_14688(C_word c,C_word *av) C_noret;
C_noret_decl(f_14698)
static void C_fcall f_14698(C_word t0,C_word t1) C_noret;
C_noret_decl(f_14718)
static void C_ccall f_14718(C_word c,C_word *av) C_noret;
C_noret_decl(f_14733)
static void C_fcall f_14733(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_14763)
static void C_ccall f_14763(C_word c,C_word *av) C_noret;
C_noret_decl(f_14774)
static void C_ccall f_14774(C_word c,C_word *av) C_noret;
C_noret_decl(f_14790)
static void C_ccall f_14790(C_word c,C_word *av) C_noret;
C_noret_decl(f_14794)
static void C_ccall f_14794(C_word c,C_word *av) C_noret;
C_noret_decl(f_14798)
static void C_ccall f_14798(C_word c,C_word *av) C_noret;
C_noret_decl(f_14814)
static void C_ccall f_14814(C_word c,C_word *av) C_noret;
C_noret_decl(f_14832)
static void C_ccall f_14832(C_word c,C_word *av) C_noret;
C_noret_decl(f_14843)
static void C_fcall f_14843(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_14865)
static void C_ccall f_14865(C_word c,C_word *av) C_noret;
C_noret_decl(f_14882)
static void C_ccall f_14882(C_word c,C_word *av) C_noret;
C_noret_decl(f_14885)
static void C_fcall f_14885(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_14897)
static void C_ccall f_14897(C_word c,C_word *av) C_noret;
C_noret_decl(f_14899)
static void C_fcall f_14899(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_14920)
static void C_ccall f_14920(C_word c,C_word *av) C_noret;
C_noret_decl(f_14951)
static void C_ccall f_14951(C_word c,C_word *av) C_noret;
C_noret_decl(f_14955)
static void C_ccall f_14955(C_word c,C_word *av) C_noret;
C_noret_decl(f_14990)
static void C_ccall f_14990(C_word c,C_word *av) C_noret;
C_noret_decl(f_14997)
static void C_ccall f_14997(C_word c,C_word *av) C_noret;
C_noret_decl(f_15009)
static void C_ccall f_15009(C_word c,C_word *av) C_noret;
C_noret_decl(f_15029)
static void C_ccall f_15029(C_word c,C_word *av) C_noret;
C_noret_decl(f_15033)
static void C_ccall f_15033(C_word c,C_word *av) C_noret;
C_noret_decl(f_15053)
static void C_fcall f_15053(C_word t0,C_word t1) C_noret;
C_noret_decl(f_15073)
static void C_ccall f_15073(C_word c,C_word *av) C_noret;
C_noret_decl(f_15077)
static void C_ccall f_15077(C_word c,C_word *av) C_noret;
C_noret_decl(f_15081)
static void C_ccall f_15081(C_word c,C_word *av) C_noret;
C_noret_decl(f_15088)
static void C_ccall f_15088(C_word c,C_word *av) C_noret;
C_noret_decl(f_15104)
static void C_ccall f_15104(C_word c,C_word *av) C_noret;
C_noret_decl(f_15108)
static void C_ccall f_15108(C_word c,C_word *av) C_noret;
C_noret_decl(f_15149)
static void C_fcall f_15149(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_15182)
static void C_ccall f_15182(C_word c,C_word *av) C_noret;
C_noret_decl(f_15211)
static void C_ccall f_15211(C_word c,C_word *av) C_noret;
C_noret_decl(f_15219)
static void C_ccall f_15219(C_word c,C_word *av) C_noret;
C_noret_decl(f_15225)
static void C_ccall f_15225(C_word c,C_word *av) C_noret;
C_noret_decl(f_15245)
static void C_fcall f_15245(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_15270)
static void C_ccall f_15270(C_word c,C_word *av) C_noret;
C_noret_decl(f_15276)
static void C_ccall f_15276(C_word c,C_word *av) C_noret;
C_noret_decl(f_15280)
static void C_ccall f_15280(C_word c,C_word *av) C_noret;
C_noret_decl(f_15290)
static void C_ccall f_15290(C_word c,C_word *av) C_noret;
C_noret_decl(f_15310)
static void C_fcall f_15310(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_15331)
static void C_ccall f_15331(C_word c,C_word *av) C_noret;
C_noret_decl(f_15348)
static void C_ccall f_15348(C_word c,C_word *av) C_noret;
C_noret_decl(f_15355)
static void C_ccall f_15355(C_word c,C_word *av) C_noret;
C_noret_decl(f_15360)
static void C_ccall f_15360(C_word c,C_word *av) C_noret;
C_noret_decl(f_15366)
static void C_ccall f_15366(C_word c,C_word *av) C_noret;
C_noret_decl(f_15370)
static void C_ccall f_15370(C_word c,C_word *av) C_noret;
C_noret_decl(f_15373)
static void C_ccall f_15373(C_word c,C_word *av) C_noret;
C_noret_decl(f_15380)
static void C_ccall f_15380(C_word c,C_word *av) C_noret;
C_noret_decl(f_15401)
static void C_ccall f_15401(C_word c,C_word *av) C_noret;
C_noret_decl(f_15415)
static void C_ccall f_15415(C_word c,C_word *av) C_noret;
C_noret_decl(f_15419)
static void C_ccall f_15419(C_word c,C_word *av) C_noret;
C_noret_decl(f_15456)
static void C_ccall f_15456(C_word c,C_word *av) C_noret;
C_noret_decl(f_15464)
static void C_ccall f_15464(C_word c,C_word *av) C_noret;
C_noret_decl(f_15493)
static void C_ccall f_15493(C_word c,C_word *av) C_noret;
C_noret_decl(f_15496)
static void C_ccall f_15496(C_word c,C_word *av) C_noret;
C_noret_decl(f_15511)
static void C_ccall f_15511(C_word c,C_word *av) C_noret;
C_noret_decl(f_15514)
static void C_fcall f_15514(C_word t0,C_word t1) C_noret;
C_noret_decl(f_15521)
static void C_ccall f_15521(C_word c,C_word *av) C_noret;
C_noret_decl(f_15532)
static void C_ccall f_15532(C_word c,C_word *av) C_noret;
C_noret_decl(f_15550)
static void C_ccall f_15550(C_word c,C_word *av) C_noret;
C_noret_decl(f_15575)
static void C_fcall f_15575(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_15590)
static void C_ccall f_15590(C_word c,C_word *av) C_noret;
C_noret_decl(f_15618)
static void C_fcall f_15618(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_15622)
static C_word C_fcall f_15622(C_word t0,C_word t1);
C_noret_decl(f_15636)
static void C_fcall f_15636(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_15696)
static void C_ccall f_15696(C_word c,C_word *av) C_noret;
C_noret_decl(f_15716)
static void C_fcall f_15716(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_15722)
static void C_fcall f_15722(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_15785)
static void C_fcall f_15785(C_word t0,C_word t1) C_noret;
C_noret_decl(f_15824)
static void C_fcall f_15824(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_15830)
static void C_fcall f_15830(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_15874)
static void C_fcall f_15874(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_15878)
static void C_ccall f_15878(C_word c,C_word *av) C_noret;
C_noret_decl(f_15881)
static void C_ccall f_15881(C_word c,C_word *av) C_noret;
C_noret_decl(f_15930)
static void C_fcall f_15930(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_15945)
static void C_fcall f_15945(C_word t0,C_word t1) C_noret;
C_noret_decl(f_15954)
static void C_ccall f_15954(C_word c,C_word *av) C_noret;
C_noret_decl(f_15988)
static void C_fcall f_15988(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_15998)
static void C_ccall f_15998(C_word c,C_word *av) C_noret;
C_noret_decl(f_16007)
static void C_fcall f_16007(C_word t0,C_word t1) C_noret;
C_noret_decl(f_16019)
static void C_fcall f_16019(C_word t0,C_word t1) C_noret;
C_noret_decl(f_16028)
static void C_ccall f_16028(C_word c,C_word *av) C_noret;
C_noret_decl(f_16040)
static void C_ccall f_16040(C_word c,C_word *av) C_noret;
C_noret_decl(f_16046)
static void C_fcall f_16046(C_word t0,C_word t1) C_noret;
C_noret_decl(f_16052)
static void C_ccall f_16052(C_word c,C_word *av) C_noret;
C_noret_decl(f_16094)
static void C_ccall f_16094(C_word c,C_word *av) C_noret;
C_noret_decl(f_16202)
static void C_fcall f_16202(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_16209)
static void C_fcall f_16209(C_word t0,C_word t1) C_noret;
C_noret_decl(f_16222)
static void C_ccall f_16222(C_word c,C_word *av) C_noret;
C_noret_decl(f_16280)
static void C_fcall f_16280(C_word t0,C_word t1) C_noret;
C_noret_decl(f_16298)
static void C_ccall f_16298(C_word c,C_word *av) C_noret;
C_noret_decl(f_16308)
static void C_ccall f_16308(C_word c,C_word *av) C_noret;
C_noret_decl(f_16344)
static void C_ccall f_16344(C_word c,C_word *av) C_noret;
C_noret_decl(f_16370)
static void C_ccall f_16370(C_word c,C_word *av) C_noret;
C_noret_decl(f_16381)
static void C_ccall f_16381(C_word c,C_word *av) C_noret;
C_noret_decl(f_16548)
static void C_fcall f_16548(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_16563)
static void C_fcall f_16563(C_word t0,C_word t1) C_noret;
C_noret_decl(f_16621)
static void C_fcall f_16621(C_word t0,C_word t1) C_noret;
C_noret_decl(f_16662)
static void C_ccall f_16662(C_word c,C_word *av) C_noret;
C_noret_decl(f_16740)
static void C_ccall f_16740(C_word c,C_word *av) C_noret;
C_noret_decl(f_16788)
static void C_ccall f_16788(C_word c,C_word *av) C_noret;
C_noret_decl(f_16791)
static void C_ccall f_16791(C_word c,C_word *av) C_noret;
C_noret_decl(f_16803)
static void C_ccall f_16803(C_word c,C_word *av) C_noret;
C_noret_decl(f_16890)
static void C_ccall f_16890(C_word c,C_word *av) C_noret;
C_noret_decl(f_16958)
static void C_ccall f_16958(C_word c,C_word *av) C_noret;
C_noret_decl(f_17038)
static void C_ccall f_17038(C_word c,C_word *av) C_noret;
C_noret_decl(f_17048)
static void C_ccall f_17048(C_word c,C_word *av) C_noret;
C_noret_decl(f_17057)
static void C_fcall f_17057(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5) C_noret;
C_noret_decl(f_17293)
static void C_ccall f_17293(C_word c,C_word *av) C_noret;
C_noret_decl(f_17339)
static void C_ccall f_17339(C_word c,C_word *av) C_noret;
C_noret_decl(f_17342)
static void C_fcall f_17342(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_17369)
static void C_fcall f_17369(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_17393)
static void C_ccall f_17393(C_word c,C_word *av) C_noret;
C_noret_decl(f_17410)
static void C_fcall f_17410(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_17511)
static void C_ccall f_17511(C_word c,C_word *av) C_noret;
C_noret_decl(f_17514)
static void C_ccall f_17514(C_word c,C_word *av) C_noret;
C_noret_decl(f_17523)
static void C_ccall f_17523(C_word c,C_word *av) C_noret;
C_noret_decl(f_17529)
static void C_ccall f_17529(C_word c,C_word *av) C_noret;
C_noret_decl(f_17540)
static void C_ccall f_17540(C_word c,C_word *av) C_noret;
C_noret_decl(f_17542)
static void C_ccall f_17542(C_word c,C_word *av) C_noret;
C_noret_decl(f_17553)
static void C_ccall f_17553(C_word c,C_word *av) C_noret;
C_noret_decl(f_17555)
static void C_ccall f_17555(C_word c,C_word *av) C_noret;
C_noret_decl(f_17566)
static void C_ccall f_17566(C_word c,C_word *av) C_noret;
C_noret_decl(f_17568)
static void C_ccall f_17568(C_word c,C_word *av) C_noret;
C_noret_decl(f_17585)
static void C_ccall f_17585(C_word c,C_word *av) C_noret;
C_noret_decl(f_17589)
static void C_ccall f_17589(C_word c,C_word *av) C_noret;
C_noret_decl(f_17593)
static void C_ccall f_17593(C_word c,C_word *av) C_noret;
C_noret_decl(f_17602)
static void C_ccall f_17602(C_word c,C_word *av) C_noret;
C_noret_decl(f_17622)
static void C_ccall f_17622(C_word c,C_word *av) C_noret;
C_noret_decl(f_17630)
static void C_ccall f_17630(C_word c,C_word *av) C_noret;
C_noret_decl(f_17645)
static void C_ccall f_17645(C_word c,C_word *av) C_noret;
C_noret_decl(f_17647)
static void C_fcall f_17647(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_17672)
static void C_ccall f_17672(C_word c,C_word *av) C_noret;
C_noret_decl(f_17681)
static void C_ccall f_17681(C_word c,C_word *av) C_noret;
C_noret_decl(f_17684)
static void C_ccall f_17684(C_word c,C_word *av) C_noret;
C_noret_decl(f_17693)
static void C_ccall f_17693(C_word c,C_word *av) C_noret;
C_noret_decl(f_17700)
static void C_ccall f_17700(C_word c,C_word *av) C_noret;
C_noret_decl(f_17711)
static void C_ccall f_17711(C_word c,C_word *av) C_noret;
C_noret_decl(f_17718)
static void C_ccall f_17718(C_word c,C_word *av) C_noret;
C_noret_decl(f_17742)
static void C_ccall f_17742(C_word c,C_word *av) C_noret;
C_noret_decl(f_17746)
static void C_ccall f_17746(C_word c,C_word *av) C_noret;
C_noret_decl(f_17748)
static void C_ccall f_17748(C_word c,C_word *av) C_noret;
C_noret_decl(f_17752)
static void C_ccall f_17752(C_word c,C_word *av) C_noret;
C_noret_decl(f_17757)
static void C_ccall f_17757(C_word c,C_word *av) C_noret;
C_noret_decl(f_17763)
static void C_ccall f_17763(C_word c,C_word *av) C_noret;
C_noret_decl(f_17767)
static void C_ccall f_17767(C_word c,C_word *av) C_noret;
C_noret_decl(f_17772)
static void C_ccall f_17772(C_word c,C_word *av) C_noret;
C_noret_decl(f_17782)
static void C_ccall f_17782(C_word c,C_word *av) C_noret;
C_noret_decl(f_17784)
static void C_ccall f_17784(C_word c,C_word *av) C_noret;
C_noret_decl(f_17788)
static void C_ccall f_17788(C_word c,C_word *av) C_noret;
C_noret_decl(f_17794)
static void C_ccall f_17794(C_word c,C_word *av) C_noret;
C_noret_decl(f_17796)
static void C_ccall f_17796(C_word c,C_word *av) C_noret;
C_noret_decl(f_17800)
static void C_ccall f_17800(C_word c,C_word *av) C_noret;
C_noret_decl(f_17803)
static void C_ccall f_17803(C_word c,C_word *av) C_noret;
C_noret_decl(f_17819)
static void C_ccall f_17819(C_word c,C_word *av) C_noret;
C_noret_decl(f_17823)
static void C_ccall f_17823(C_word c,C_word *av) C_noret;
C_noret_decl(f_17826)
static void C_ccall f_17826(C_word c,C_word *av) C_noret;
C_noret_decl(f_17848)
static void C_ccall f_17848(C_word c,C_word *av) C_noret;
C_noret_decl(f_17864)
static void C_ccall f_17864(C_word c,C_word *av) C_noret;
C_noret_decl(f_17869)
static C_word C_fcall f_17869(C_word t0,C_word t1,C_word t2);
C_noret_decl(f_17900)
static void C_ccall f_17900(C_word c,C_word *av) C_noret;
C_noret_decl(f_17909)
static void C_fcall f_17909(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_17927)
static void C_ccall f_17927(C_word c,C_word *av) C_noret;
C_noret_decl(f_17933)
static void C_ccall f_17933(C_word c,C_word *av) C_noret;
C_noret_decl(f_17939)
static void C_ccall f_17939(C_word c,C_word *av) C_noret;
C_noret_decl(f_17948)
static C_word C_fcall f_17948(C_word t0,C_word t1);
C_noret_decl(f_17967)
static void C_ccall f_17967(C_word c,C_word *av) C_noret;
C_noret_decl(f_17986)
static void C_ccall f_17986(C_word c,C_word *av) C_noret;
C_noret_decl(f_17989)
static void C_ccall f_17989(C_word c,C_word *av) C_noret;
C_noret_decl(f_17994)
static C_word C_fcall f_17994(C_word t0,C_word t1);
C_noret_decl(f_18036)
static void C_ccall f_18036(C_word c,C_word *av) C_noret;
C_noret_decl(f_18055)
static void C_ccall f_18055(C_word c,C_word *av) C_noret;
C_noret_decl(f_18058)
static void C_ccall f_18058(C_word c,C_word *av) C_noret;
C_noret_decl(f_18061)
static void C_ccall f_18061(C_word c,C_word *av) C_noret;
C_noret_decl(f_18066)
static C_word C_fcall f_18066(C_word t0,C_word t1);
C_noret_decl(f_18107)
static void C_ccall f_18107(C_word c,C_word *av) C_noret;
C_noret_decl(f_18117)
static void C_ccall f_18117(C_word c,C_word *av) C_noret;
C_noret_decl(f_18128)
static void C_fcall f_18128(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_18132)
static void C_ccall f_18132(C_word c,C_word *av) C_noret;
C_noret_decl(f_18135)
static void C_ccall f_18135(C_word c,C_word *av) C_noret;
C_noret_decl(f_18140)
static C_word C_fcall f_18140(C_word t0,C_word t1);
C_noret_decl(f_18167)
static void C_ccall f_18167(C_word c,C_word *av) C_noret;
C_noret_decl(f_18181)
static void C_ccall f_18181(C_word c,C_word *av) C_noret;
C_noret_decl(f_18192)
static void C_ccall f_18192(C_word c,C_word *av) C_noret;
C_noret_decl(f_18203)
static void C_ccall f_18203(C_word c,C_word *av) C_noret;
C_noret_decl(f_18214)
static void C_ccall f_18214(C_word c,C_word *av) C_noret;
C_noret_decl(f_18227)
static void C_ccall f_18227(C_word c,C_word *av) C_noret;
C_noret_decl(f_18229)
static void C_fcall f_18229(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_18242)
static C_word C_fcall f_18242(C_word t0,C_word t1);
C_noret_decl(f_18270)
static void C_ccall f_18270(C_word c,C_word *av) C_noret;
C_noret_decl(f_18283)
static void C_ccall f_18283(C_word c,C_word *av) C_noret;
C_noret_decl(f_18301)
static void C_ccall f_18301(C_word c,C_word *av) C_noret;
C_noret_decl(f_18304)
static void C_ccall f_18304(C_word c,C_word *av) C_noret;
C_noret_decl(f_18387)
static void C_ccall f_18387(C_word c,C_word *av) C_noret;
C_noret_decl(f_18390)
static void C_ccall f_18390(C_word c,C_word *av) C_noret;
C_noret_decl(f_18393)
static void C_ccall f_18393(C_word c,C_word *av) C_noret;
C_noret_decl(f_18396)
static void C_ccall f_18396(C_word c,C_word *av) C_noret;
C_noret_decl(f_18399)
static void C_ccall f_18399(C_word c,C_word *av) C_noret;
C_noret_decl(f_18402)
static void C_ccall f_18402(C_word c,C_word *av) C_noret;
C_noret_decl(f_18405)
static void C_ccall f_18405(C_word c,C_word *av) C_noret;
C_noret_decl(f_18408)
static void C_ccall f_18408(C_word c,C_word *av) C_noret;
C_noret_decl(f_18411)
static void C_ccall f_18411(C_word c,C_word *av) C_noret;
C_noret_decl(f_18414)
static void C_ccall f_18414(C_word c,C_word *av) C_noret;
C_noret_decl(f_18417)
static void C_ccall f_18417(C_word c,C_word *av) C_noret;
C_noret_decl(f_18420)
static void C_ccall f_18420(C_word c,C_word *av) C_noret;
C_noret_decl(f_18423)
static void C_ccall f_18423(C_word c,C_word *av) C_noret;
C_noret_decl(f_18426)
static void C_ccall f_18426(C_word c,C_word *av) C_noret;
C_noret_decl(f_18431)
static void C_ccall f_18431(C_word c,C_word *av) C_noret;
C_noret_decl(f_18437)
static void C_fcall f_18437(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_18453)
static void C_ccall f_18453(C_word c,C_word *av) C_noret;
C_noret_decl(f_18469)
static void C_ccall f_18469(C_word c,C_word *av) C_noret;
C_noret_decl(f_18475)
static void C_fcall f_18475(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_18495)
static void C_ccall f_18495(C_word c,C_word *av) C_noret;
C_noret_decl(f_18499)
static void C_ccall f_18499(C_word c,C_word *av) C_noret;
C_noret_decl(f_18511)
static void C_ccall f_18511(C_word c,C_word *av) C_noret;
C_noret_decl(f_18517)
static void C_ccall f_18517(C_word c,C_word *av) C_noret;
C_noret_decl(f_18523)
static void C_fcall f_18523(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_18555)
static void C_ccall f_18555(C_word c,C_word *av) C_noret;
C_noret_decl(f_18559)
static void C_ccall f_18559(C_word c,C_word *av) C_noret;
C_noret_decl(f_18569)
static void C_ccall f_18569(C_word c,C_word *av) C_noret;
C_noret_decl(f_18584)
static void C_fcall f_18584(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_18594)
static void C_ccall f_18594(C_word c,C_word *av) C_noret;
C_noret_decl(f_18614)
static void C_fcall f_18614(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_18621)
static void C_ccall f_18621(C_word c,C_word *av) C_noret;
C_noret_decl(f_18630)
static void C_ccall f_18630(C_word c,C_word *av) C_noret;
C_noret_decl(f_18637)
static void C_ccall f_18637(C_word c,C_word *av) C_noret;
C_noret_decl(f_18639)
static void C_ccall f_18639(C_word c,C_word *av) C_noret;
C_noret_decl(f_18645)
static void C_ccall f_18645(C_word c,C_word *av) C_noret;
C_noret_decl(f_18651)
static void C_ccall f_18651(C_word c,C_word *av) C_noret;
C_noret_decl(f_18669)
static void C_fcall f_18669(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_18694)
static void C_ccall f_18694(C_word c,C_word *av) C_noret;
C_noret_decl(f_18710)
static void C_fcall f_18710(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_18717)
static void C_ccall f_18717(C_word c,C_word *av) C_noret;
C_noret_decl(f_18730)
static void C_ccall f_18730(C_word c,C_word *av) C_noret;
C_noret_decl(f_18734)
static void C_ccall f_18734(C_word c,C_word *av) C_noret;
C_noret_decl(f_18738)
static void C_ccall f_18738(C_word c,C_word *av) C_noret;
C_noret_decl(f_18740)
static void C_ccall f_18740(C_word c,C_word *av) C_noret;
C_noret_decl(f_18746)
static void C_ccall f_18746(C_word c,C_word *av) C_noret;
C_noret_decl(f_18753)
static void C_ccall f_18753(C_word c,C_word *av) C_noret;
C_noret_decl(f_18757)
static void C_ccall f_18757(C_word c,C_word *av) C_noret;
C_noret_decl(f_18766)
static void C_ccall f_18766(C_word c,C_word *av) C_noret;
C_noret_decl(f_18774)
static void C_ccall f_18774(C_word c,C_word *av) C_noret;
C_noret_decl(f_18784)
static void C_ccall f_18784(C_word c,C_word *av) C_noret;
C_noret_decl(f_18790)
static void C_ccall f_18790(C_word c,C_word *av) C_noret;
C_noret_decl(f_18793)
static void C_ccall f_18793(C_word c,C_word *av) C_noret;
C_noret_decl(f_18797)
static void C_ccall f_18797(C_word c,C_word *av) C_noret;
C_noret_decl(f_18824)
static void C_fcall f_18824(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_18840)
static void C_ccall f_18840(C_word c,C_word *av) C_noret;
C_noret_decl(f_18846)
static void C_ccall f_18846(C_word c,C_word *av) C_noret;
C_noret_decl(f_18869)
static void C_ccall f_18869(C_word c,C_word *av) C_noret;
C_noret_decl(f_18882)
static void C_ccall f_18882(C_word c,C_word *av) C_noret;
C_noret_decl(f_18888)
static void C_ccall f_18888(C_word c,C_word *av) C_noret;
C_noret_decl(f_18893)
static void C_ccall f_18893(C_word c,C_word *av) C_noret;
C_noret_decl(f_18898)
static void C_ccall f_18898(C_word c,C_word *av) C_noret;
C_noret_decl(f_18902)
static void C_ccall f_18902(C_word c,C_word *av) C_noret;
C_noret_decl(f_18911)
static void C_ccall f_18911(C_word c,C_word *av) C_noret;
C_noret_decl(f_18942)
static void C_ccall f_18942(C_word c,C_word *av) C_noret;
C_noret_decl(f_18946)
static void C_ccall f_18946(C_word c,C_word *av) C_noret;
C_noret_decl(f_18950)
static void C_ccall f_18950(C_word c,C_word *av) C_noret;
C_noret_decl(f_18953)
static void C_ccall f_18953(C_word c,C_word *av) C_noret;
C_noret_decl(f_18956)
static void C_ccall f_18956(C_word c,C_word *av) C_noret;
C_noret_decl(f_18959)
static void C_ccall f_18959(C_word c,C_word *av) C_noret;
C_noret_decl(f_18961)
static void C_ccall f_18961(C_word c,C_word *av) C_noret;
C_noret_decl(f_18972)
static void C_ccall f_18972(C_word c,C_word *av) C_noret;
C_noret_decl(f_18983)
static void C_ccall f_18983(C_word c,C_word *av) C_noret;
C_noret_decl(f_18994)
static void C_ccall f_18994(C_word c,C_word *av) C_noret;
C_noret_decl(f_19005)
static void C_ccall f_19005(C_word c,C_word *av) C_noret;
C_noret_decl(f_19018)
static void C_ccall f_19018(C_word c,C_word *av) C_noret;
C_noret_decl(f_19020)
static C_word C_fcall f_19020(C_word t0,C_word t1);
C_noret_decl(f_19026)
static C_word C_fcall f_19026(C_word t0);
C_noret_decl(f_19031)
static C_word C_fcall f_19031(C_word t0);
C_noret_decl(f_19066)
static void C_ccall f_19066(C_word c,C_word *av) C_noret;
C_noret_decl(f_19079)
static void C_ccall f_19079(C_word c,C_word *av) C_noret;
C_noret_decl(f_19081)
static C_word C_fcall f_19081(C_word t0,C_word t1);
C_noret_decl(f_19087)
static C_word C_fcall f_19087(C_word t0);
C_noret_decl(f_19092)
static C_word C_fcall f_19092(C_word t0);
C_noret_decl(f_19127)
static void C_ccall f_19127(C_word c,C_word *av) C_noret;
C_noret_decl(f_19140)
static void C_ccall f_19140(C_word c,C_word *av) C_noret;
C_noret_decl(f_19142)
static C_word C_fcall f_19142(C_word t0,C_word t1);
C_noret_decl(f_19148)
static C_word C_fcall f_19148(C_word t0);
C_noret_decl(f_19153)
static C_word C_fcall f_19153(C_word t0);
C_noret_decl(f_19188)
static void C_ccall f_19188(C_word c,C_word *av) C_noret;
C_noret_decl(f_19200)
static void C_ccall f_19200(C_word c,C_word *av) C_noret;
C_noret_decl(f_19202)
static void C_ccall f_19202(C_word c,C_word *av) C_noret;
C_noret_decl(f_19208)
static void C_ccall f_19208(C_word c,C_word *av) C_noret;
C_noret_decl(f_19214)
static void C_fcall f_19214(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_19224)
static void C_ccall f_19224(C_word c,C_word *av) C_noret;
C_noret_decl(f_19227)
static void C_ccall f_19227(C_word c,C_word *av) C_noret;
C_noret_decl(f_19230)
static void C_ccall f_19230(C_word c,C_word *av) C_noret;
C_noret_decl(f_19233)
static void C_ccall f_19233(C_word c,C_word *av) C_noret;
C_noret_decl(f_19236)
static void C_ccall f_19236(C_word c,C_word *av) C_noret;
C_noret_decl(f_19243)
static void C_ccall f_19243(C_word c,C_word *av) C_noret;
C_noret_decl(f_19247)
static void C_ccall f_19247(C_word c,C_word *av) C_noret;
C_noret_decl(f_19251)
static void C_ccall f_19251(C_word c,C_word *av) C_noret;
C_noret_decl(f_19257)
static void C_fcall f_19257(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_19270)
static void C_ccall f_19270(C_word c,C_word *av) C_noret;
C_noret_decl(f_19312)
static void C_fcall f_19312(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_19316)
static void C_ccall f_19316(C_word c,C_word *av) C_noret;
C_noret_decl(f_19349)
static void C_ccall f_19349(C_word c,C_word *av) C_noret;
C_noret_decl(f_19355)
static void C_ccall f_19355(C_word c,C_word *av) C_noret;
C_noret_decl(f_19361)
static void C_ccall f_19361(C_word c,C_word *av) C_noret;
C_noret_decl(f_19367)
static void C_ccall f_19367(C_word c,C_word *av) C_noret;
C_noret_decl(f_19373)
static void C_ccall f_19373(C_word c,C_word *av) C_noret;
C_noret_decl(f_19377)
static void C_ccall f_19377(C_word c,C_word *av) C_noret;
C_noret_decl(f_19382)
static void C_ccall f_19382(C_word c,C_word *av) C_noret;
C_noret_decl(f_19388)
static void C_ccall f_19388(C_word c,C_word *av) C_noret;
C_noret_decl(f_19392)
static void C_ccall f_19392(C_word c,C_word *av) C_noret;
C_noret_decl(f_19397)
static void C_ccall f_19397(C_word c,C_word *av) C_noret;
C_noret_decl(f_19401)
static void C_ccall f_19401(C_word c,C_word *av) C_noret;
C_noret_decl(f_19406)
static void C_ccall f_19406(C_word c,C_word *av) C_noret;
C_noret_decl(f_19412)
static void C_ccall f_19412(C_word c,C_word *av) C_noret;
C_noret_decl(f_19416)
static void C_ccall f_19416(C_word c,C_word *av) C_noret;
C_noret_decl(f_19421)
static void C_ccall f_19421(C_word c,C_word *av) C_noret;
C_noret_decl(f_19425)
static void C_ccall f_19425(C_word c,C_word *av) C_noret;
C_noret_decl(f_19430)
static void C_ccall f_19430(C_word c,C_word *av) C_noret;
C_noret_decl(f_19435)
static void C_ccall f_19435(C_word c,C_word *av) C_noret;
C_noret_decl(f_19441)
static void C_ccall f_19441(C_word c,C_word *av) C_noret;
C_noret_decl(f_19445)
static void C_ccall f_19445(C_word c,C_word *av) C_noret;
C_noret_decl(f_19450)
static void C_ccall f_19450(C_word c,C_word *av) C_noret;
C_noret_decl(f_19455)
static void C_ccall f_19455(C_word c,C_word *av) C_noret;
C_noret_decl(f_19459)
static void C_ccall f_19459(C_word c,C_word *av) C_noret;
C_noret_decl(f_19464)
static void C_ccall f_19464(C_word c,C_word *av) C_noret;
C_noret_decl(f_19469)
static void C_ccall f_19469(C_word c,C_word *av) C_noret;
C_noret_decl(f_19475)
static void C_ccall f_19475(C_word c,C_word *av) C_noret;
C_noret_decl(f_19479)
static void C_ccall f_19479(C_word c,C_word *av) C_noret;
C_noret_decl(f_19484)
static void C_ccall f_19484(C_word c,C_word *av) C_noret;
C_noret_decl(f_19489)
static void C_ccall f_19489(C_word c,C_word *av) C_noret;
C_noret_decl(f_19494)
static void C_ccall f_19494(C_word c,C_word *av) C_noret;
C_noret_decl(f_19515)
static void C_ccall f_19515(C_word c,C_word *av) C_noret;
C_noret_decl(f_19522)
static void C_ccall f_19522(C_word c,C_word *av) C_noret;
C_noret_decl(f_19528)
static void C_ccall f_19528(C_word c,C_word *av) C_noret;
C_noret_decl(f_19546)
static void C_ccall f_19546(C_word c,C_word *av) C_noret;
C_noret_decl(f_19555)
static void C_ccall f_19555(C_word c,C_word *av) C_noret;
C_noret_decl(f_19568)
static void C_fcall f_19568(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_19576)
static void C_ccall f_19576(C_word c,C_word *av) C_noret;
C_noret_decl(f_19581)
static void C_fcall f_19581(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_19618)
static void C_ccall f_19618(C_word c,C_word *av) C_noret;
C_noret_decl(f_19630)
static void C_ccall f_19630(C_word c,C_word *av) C_noret;
C_noret_decl(f_19640)
static void C_fcall f_19640(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_19656)
static void C_ccall f_19656(C_word c,C_word *av) C_noret;
C_noret_decl(f_19669)
static void C_ccall f_19669(C_word c,C_word *av) C_noret;
C_noret_decl(f_19676)
static void C_ccall f_19676(C_word c,C_word *av) C_noret;
C_noret_decl(f_19678)
static void C_ccall f_19678(C_word c,C_word *av) C_noret;
C_noret_decl(f_19691)
static void C_ccall f_19691(C_word c,C_word *av) C_noret;
C_noret_decl(f_19697)
static void C_ccall f_19697(C_word c,C_word *av) C_noret;
C_noret_decl(f_19704)
static void C_ccall f_19704(C_word c,C_word *av) C_noret;
C_noret_decl(f_19706)
static void C_ccall f_19706(C_word c,C_word *av) C_noret;
C_noret_decl(f_19710)
static void C_ccall f_19710(C_word c,C_word *av) C_noret;
C_noret_decl(f_19713)
static void C_ccall f_19713(C_word c,C_word *av) C_noret;
C_noret_decl(f_19723)
static void C_ccall f_19723(C_word c,C_word *av) C_noret;
C_noret_decl(f_19727)
static void C_ccall f_19727(C_word c,C_word *av) C_noret;
C_noret_decl(f_19735)
static void C_ccall f_19735(C_word c,C_word *av) C_noret;
C_noret_decl(f_19738)
static void C_ccall f_19738(C_word c,C_word *av) C_noret;
C_noret_decl(f_19745)
static void C_ccall f_19745(C_word c,C_word *av) C_noret;
C_noret_decl(f_19748)
static void C_ccall f_19748(C_word c,C_word *av) C_noret;
C_noret_decl(f_19751)
static void C_ccall f_19751(C_word c,C_word *av) C_noret;
C_noret_decl(f_19754)
static void C_ccall f_19754(C_word c,C_word *av) C_noret;
C_noret_decl(f_19762)
static void C_ccall f_19762(C_word c,C_word *av) C_noret;
C_noret_decl(f_19770)
static void C_ccall f_19770(C_word c,C_word *av) C_noret;
C_noret_decl(f_19772)
static void C_ccall f_19772(C_word c,C_word *av) C_noret;
C_noret_decl(f_19788)
static void C_ccall f_19788(C_word c,C_word *av) C_noret;
C_noret_decl(f_19815)
static void C_ccall f_19815(C_word c,C_word *av) C_noret;
C_noret_decl(f_19819)
static void C_ccall f_19819(C_word c,C_word *av) C_noret;
C_noret_decl(f_19823)
static void C_ccall f_19823(C_word c,C_word *av) C_noret;
C_noret_decl(f_19827)
static void C_ccall f_19827(C_word c,C_word *av) C_noret;
C_noret_decl(f_19831)
static void C_ccall f_19831(C_word c,C_word *av) C_noret;
C_noret_decl(f_19835)
static void C_ccall f_19835(C_word c,C_word *av) C_noret;
C_noret_decl(f_19839)
static void C_ccall f_19839(C_word c,C_word *av) C_noret;
C_noret_decl(f_19843)
static void C_ccall f_19843(C_word c,C_word *av) C_noret;
C_noret_decl(f_19847)
static void C_ccall f_19847(C_word c,C_word *av) C_noret;
C_noret_decl(f_19851)
static void C_ccall f_19851(C_word c,C_word *av) C_noret;
C_noret_decl(f_19855)
static void C_ccall f_19855(C_word c,C_word *av) C_noret;
C_noret_decl(f_19859)
static void C_ccall f_19859(C_word c,C_word *av) C_noret;
C_noret_decl(f_19863)
static void C_ccall f_19863(C_word c,C_word *av) C_noret;
C_noret_decl(f_19867)
static void C_ccall f_19867(C_word c,C_word *av) C_noret;
C_noret_decl(f_19871)
static void C_ccall f_19871(C_word c,C_word *av) C_noret;
C_noret_decl(f_19875)
static void C_ccall f_19875(C_word c,C_word *av) C_noret;
C_noret_decl(f_19879)
static void C_ccall f_19879(C_word c,C_word *av) C_noret;
C_noret_decl(f_19886)
static void C_ccall f_19886(C_word c,C_word *av) C_noret;
C_noret_decl(f_19893)
static void C_ccall f_19893(C_word c,C_word *av) C_noret;
C_noret_decl(f_19894)
static void C_fcall f_19894(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5) C_noret;
C_noret_decl(f_19898)
static void C_fcall f_19898(C_word t0,C_word t1) C_noret;
C_noret_decl(f_19901)
static void C_ccall f_19901(C_word c,C_word *av) C_noret;
C_noret_decl(f_19917)
static void C_ccall f_19917(C_word c,C_word *av) C_noret;
C_noret_decl(f_19928)
static void C_fcall f_19928(C_word t0,C_word t1) C_noret;
C_noret_decl(f_19936)
static void C_ccall f_19936(C_word c,C_word *av) C_noret;
C_noret_decl(f_19948)
static void C_fcall f_19948(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_19957)
static void C_fcall f_19957(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_19962)
static void C_fcall f_19962(C_word t0,C_word t1) C_noret;
C_noret_decl(f_20018)
static void C_ccall f_20018(C_word c,C_word *av) C_noret;
C_noret_decl(f_20032)
static void C_ccall f_20032(C_word c,C_word *av) C_noret;
C_noret_decl(f_20044)
static void C_ccall f_20044(C_word c,C_word *av) C_noret;
C_noret_decl(f_20050)
static void C_ccall f_20050(C_word c,C_word *av) C_noret;
C_noret_decl(f_20075)
static void C_ccall f_20075(C_word c,C_word *av) C_noret;
C_noret_decl(f_20093)
static void C_ccall f_20093(C_word c,C_word *av) C_noret;
C_noret_decl(f_20097)
static void C_ccall f_20097(C_word c,C_word *av) C_noret;
C_noret_decl(f_20153)
static void C_ccall f_20153(C_word c,C_word *av) C_noret;
C_noret_decl(f_20162)
static void C_ccall f_20162(C_word c,C_word *av) C_noret;
C_noret_decl(f_20175)
static void C_ccall f_20175(C_word c,C_word *av) C_noret;
C_noret_decl(f_20187)
static void C_ccall f_20187(C_word c,C_word *av) C_noret;
C_noret_decl(f_20205)
static void C_ccall f_20205(C_word c,C_word *av) C_noret;
C_noret_decl(f_20225)
static void C_ccall f_20225(C_word c,C_word *av) C_noret;
C_noret_decl(f_20228)
static void C_ccall f_20228(C_word c,C_word *av) C_noret;
C_noret_decl(f_20231)
static void C_ccall f_20231(C_word c,C_word *av) C_noret;
C_noret_decl(f_20239)
static void C_ccall f_20239(C_word c,C_word *av) C_noret;
C_noret_decl(f_20243)
static void C_ccall f_20243(C_word c,C_word *av) C_noret;
C_noret_decl(f_20247)
static void C_ccall f_20247(C_word c,C_word *av) C_noret;
C_noret_decl(f_20251)
static void C_ccall f_20251(C_word c,C_word *av) C_noret;
C_noret_decl(f_20255)
static void C_ccall f_20255(C_word c,C_word *av) C_noret;
C_noret_decl(f_20257)
static void C_ccall f_20257(C_word c,C_word *av) C_noret;
C_noret_decl(f_20265)
static void C_ccall f_20265(C_word c,C_word *av) C_noret;
C_noret_decl(f_20268)
static void C_ccall f_20268(C_word c,C_word *av) C_noret;
C_noret_decl(f_20278)
static void C_ccall f_20278(C_word c,C_word *av) C_noret;
C_noret_decl(f_20280)
static void C_ccall f_20280(C_word c,C_word *av) C_noret;
C_noret_decl(f_20288)
static void C_ccall f_20288(C_word c,C_word *av) C_noret;
C_noret_decl(f_20291)
static void C_ccall f_20291(C_word c,C_word *av) C_noret;
C_noret_decl(f_20301)
static void C_ccall f_20301(C_word c,C_word *av) C_noret;
C_noret_decl(f_20303)
static void C_ccall f_20303(C_word c,C_word *av) C_noret;
C_noret_decl(f_20307)
static void C_ccall f_20307(C_word c,C_word *av) C_noret;
C_noret_decl(f_20310)
static void C_ccall f_20310(C_word c,C_word *av) C_noret;
C_noret_decl(f_20313)
static void C_ccall f_20313(C_word c,C_word *av) C_noret;
C_noret_decl(f_20316)
static void C_ccall f_20316(C_word c,C_word *av) C_noret;
C_noret_decl(f_20319)
static void C_ccall f_20319(C_word c,C_word *av) C_noret;
C_noret_decl(f_20321)
static void C_ccall f_20321(C_word c,C_word *av) C_noret;
C_noret_decl(f_20327)
static void C_fcall f_20327(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_20336)
static void C_fcall f_20336(C_word t0,C_word t1) C_noret;
C_noret_decl(f_20344)
static void C_ccall f_20344(C_word c,C_word *av) C_noret;
C_noret_decl(f_20346)
static void C_fcall f_20346(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_20360)
static void C_ccall f_20360(C_word c,C_word *av) C_noret;
C_noret_decl(f_20373)
static void C_fcall f_20373(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_20377)
static void C_ccall f_20377(C_word c,C_word *av) C_noret;
C_noret_decl(f_20382)
static void C_fcall f_20382(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_20386)
static void C_ccall f_20386(C_word c,C_word *av) C_noret;
C_noret_decl(f_20397)
static void C_fcall f_20397(C_word t0,C_word t1) C_noret;
C_noret_decl(f_20400)
static void C_fcall f_20400(C_word t0,C_word t1) C_noret;
C_noret_decl(f_20408)
static void C_ccall f_20408(C_word c,C_word *av) C_noret;
C_noret_decl(f_20410)
static void C_fcall f_20410(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_20423)
static void C_ccall f_20423(C_word c,C_word *av) C_noret;
C_noret_decl(f_20430)
static void C_ccall f_20430(C_word c,C_word *av) C_noret;
C_noret_decl(f_20439)
static void C_ccall f_20439(C_word c,C_word *av) C_noret;
C_noret_decl(f_20446)
static void C_ccall f_20446(C_word c,C_word *av) C_noret;
C_noret_decl(f_20448)
static void C_fcall f_20448(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_20454)
static void C_fcall f_20454(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_20464)
static void C_ccall f_20464(C_word c,C_word *av) C_noret;
C_noret_decl(f_20467)
static void C_ccall f_20467(C_word c,C_word *av) C_noret;
C_noret_decl(f_20477)
static void C_ccall f_20477(C_word c,C_word *av) C_noret;
C_noret_decl(f_20480)
static void C_ccall f_20480(C_word c,C_word *av) C_noret;
C_noret_decl(f_20508)
static void C_fcall f_20508(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_20512)
static void C_ccall f_20512(C_word c,C_word *av) C_noret;
C_noret_decl(f_20520)
static void C_fcall f_20520(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_20545)
static void C_fcall f_20545(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_20553)
static void C_ccall f_20553(C_word c,C_word *av) C_noret;
C_noret_decl(f_20555)
static void C_fcall f_20555(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_20572)
static void C_ccall f_20572(C_word c,C_word *av) C_noret;
C_noret_decl(f_20585)
static void C_ccall f_20585(C_word c,C_word *av) C_noret;
C_noret_decl(f_20602)
static void C_ccall f_20602(C_word c,C_word *av) C_noret;
C_noret_decl(f_20619)
static void C_ccall f_20619(C_word c,C_word *av) C_noret;
C_noret_decl(f_20636)
static void C_ccall f_20636(C_word c,C_word *av) C_noret;
C_noret_decl(f_20653)
static void C_ccall f_20653(C_word c,C_word *av) C_noret;
C_noret_decl(f_20670)
static void C_ccall f_20670(C_word c,C_word *av) C_noret;
C_noret_decl(f_20687)
static void C_ccall f_20687(C_word c,C_word *av) C_noret;
C_noret_decl(f_20707)
static void C_ccall f_20707(C_word c,C_word *av) C_noret;
C_noret_decl(f_20715)
static void C_ccall f_20715(C_word c,C_word *av) C_noret;
C_noret_decl(f_20724)
static void C_ccall f_20724(C_word c,C_word *av) C_noret;
C_noret_decl(f_20730)
static void C_ccall f_20730(C_word c,C_word *av) C_noret;
C_noret_decl(f_20736)
static void C_fcall f_20736(C_word t0,C_word t1) C_noret;
C_noret_decl(f_20739)
static void C_ccall f_20739(C_word c,C_word *av) C_noret;
C_noret_decl(f_20742)
static void C_ccall f_20742(C_word c,C_word *av) C_noret;
C_noret_decl(f_20752)
static void C_ccall f_20752(C_word c,C_word *av) C_noret;
C_noret_decl(f_20756)
static void C_ccall f_20756(C_word c,C_word *av) C_noret;
C_noret_decl(f_20773)
static void C_ccall f_20773(C_word c,C_word *av) C_noret;
C_noret_decl(f_20778)
static void C_ccall f_20778(C_word c,C_word *av) C_noret;
C_noret_decl(f_20785)
static void C_ccall f_20785(C_word c,C_word *av) C_noret;
C_noret_decl(f_20789)
static void C_ccall f_20789(C_word c,C_word *av) C_noret;
C_noret_decl(f_20798)
static void C_ccall f_20798(C_word c,C_word *av) C_noret;
C_noret_decl(f_20804)
static void C_ccall f_20804(C_word c,C_word *av) C_noret;
C_noret_decl(f_20814)
static void C_ccall f_20814(C_word c,C_word *av) C_noret;
C_noret_decl(f_20818)
static void C_ccall f_20818(C_word c,C_word *av) C_noret;
C_noret_decl(f_20827)
static void C_fcall f_20827(C_word t0,C_word t1) C_noret;
C_noret_decl(f_20834)
static void C_ccall f_20834(C_word c,C_word *av) C_noret;
C_noret_decl(f_20847)
static void C_fcall f_20847(C_word t0,C_word t1) C_noret;
C_noret_decl(f_20852)
static void C_fcall f_20852(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_20869)
static void C_ccall f_20869(C_word c,C_word *av) C_noret;
C_noret_decl(f_20884)
static void C_ccall f_20884(C_word c,C_word *av) C_noret;
C_noret_decl(f_20897)
static void C_ccall f_20897(C_word c,C_word *av) C_noret;
C_noret_decl(f_20919)
static void C_ccall f_20919(C_word c,C_word *av) C_noret;
C_noret_decl(f_20922)
static void C_ccall f_20922(C_word c,C_word *av) C_noret;
C_noret_decl(f_20951)
static void C_fcall f_20951(C_word t0,C_word t1) C_noret;
C_noret_decl(f_20961)
static void C_ccall f_20961(C_word c,C_word *av) C_noret;
C_noret_decl(f_20977)
static void C_ccall f_20977(C_word c,C_word *av) C_noret;
C_noret_decl(f_20988)
static void C_ccall f_20988(C_word c,C_word *av) C_noret;
C_noret_decl(f_20995)
static void C_ccall f_20995(C_word c,C_word *av) C_noret;
C_noret_decl(f_21093)
static void C_ccall f_21093(C_word c,C_word *av) C_noret;
C_noret_decl(f_21099)
static void C_fcall f_21099(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_21108)
static void C_fcall f_21108(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_21122)
static void C_ccall f_21122(C_word c,C_word *av) C_noret;
C_noret_decl(f_21125)
static void C_ccall f_21125(C_word c,C_word *av) C_noret;
C_noret_decl(f_21136)
static void C_ccall f_21136(C_word c,C_word *av) C_noret;
C_noret_decl(f_21138)
static void C_ccall f_21138(C_word c,C_word *av) C_noret;
C_noret_decl(f_21141)
static void C_ccall f_21141(C_word c,C_word *av) C_noret;
C_noret_decl(f_21158)
static void C_ccall f_21158(C_word c,C_word *av) C_noret;
C_noret_decl(f_21163)
static void C_fcall f_21163(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_21167)
static void C_ccall f_21167(C_word c,C_word *av) C_noret;
C_noret_decl(f_21170)
static void C_fcall f_21170(C_word t0,C_word t1) C_noret;
C_noret_decl(f_21173)
static void C_ccall f_21173(C_word c,C_word *av) C_noret;
C_noret_decl(f_21183)
static void C_ccall f_21183(C_word c,C_word *av) C_noret;
C_noret_decl(f_21201)
static void C_ccall f_21201(C_word c,C_word *av) C_noret;
C_noret_decl(f_21204)
static void C_ccall f_21204(C_word c,C_word *av) C_noret;
C_noret_decl(f_21213)
static void C_fcall f_21213(C_word t0,C_word t1) C_noret;
C_noret_decl(f_21216)
static void C_ccall f_21216(C_word c,C_word *av) C_noret;
C_noret_decl(f_21219)
static void C_ccall f_21219(C_word c,C_word *av) C_noret;
C_noret_decl(f_21225)
static void C_ccall f_21225(C_word c,C_word *av) C_noret;
C_noret_decl(f_21238)
static void C_ccall f_21238(C_word c,C_word *av) C_noret;
C_noret_decl(f_21242)
static void C_ccall f_21242(C_word c,C_word *av) C_noret;
C_noret_decl(f_21246)
static void C_ccall f_21246(C_word c,C_word *av) C_noret;
C_noret_decl(f_21257)
static void C_ccall f_21257(C_word c,C_word *av) C_noret;
C_noret_decl(f_21261)
static void C_ccall f_21261(C_word c,C_word *av) C_noret;
C_noret_decl(f_21264)
static void C_ccall f_21264(C_word c,C_word *av) C_noret;
C_noret_decl(f_21292)
static void C_ccall f_21292(C_word c,C_word *av) C_noret;
C_noret_decl(f_21348)
static void C_ccall f_21348(C_word c,C_word *av) C_noret;
C_noret_decl(f_21352)
static void C_ccall f_21352(C_word c,C_word *av) C_noret;
C_noret_decl(f_21359)
static void C_ccall f_21359(C_word c,C_word *av) C_noret;
C_noret_decl(f_21361)
static void C_fcall f_21361(C_word t0,C_word t1) C_noret;
C_noret_decl(f_21365)
static void C_ccall f_21365(C_word c,C_word *av) C_noret;
C_noret_decl(f_21379)
static void C_fcall f_21379(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_21385)
static void C_ccall f_21385(C_word c,C_word *av) C_noret;
C_noret_decl(f_21392)
static void C_ccall f_21392(C_word c,C_word *av) C_noret;
C_noret_decl(f_21399)
static void C_ccall f_21399(C_word c,C_word *av) C_noret;
C_noret_decl(f_21420)
static void C_ccall f_21420(C_word c,C_word *av) C_noret;
C_noret_decl(f_21449)
static void C_fcall f_21449(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_21459)
static void C_ccall f_21459(C_word c,C_word *av) C_noret;
C_noret_decl(f_21462)
static void C_ccall f_21462(C_word c,C_word *av) C_noret;
C_noret_decl(f_21498)
static void C_ccall f_21498(C_word c,C_word *av) C_noret;
C_noret_decl(f_21500)
static void C_fcall f_21500(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_21510)
static void C_ccall f_21510(C_word c,C_word *av) C_noret;
C_noret_decl(f_21513)
static void C_ccall f_21513(C_word c,C_word *av) C_noret;
C_noret_decl(f_21565)
static void C_ccall f_21565(C_word c,C_word *av) C_noret;
C_noret_decl(f_21567)
static void C_fcall f_21567(C_word t0,C_word t1) C_noret;
C_noret_decl(f_21575)
static void C_ccall f_21575(C_word c,C_word *av) C_noret;
C_noret_decl(f_21577)
static void C_fcall f_21577(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_21587)
static void C_fcall f_21587(C_word t0,C_word t1) C_noret;
C_noret_decl(f_21602)
static void C_ccall f_21602(C_word c,C_word *av) C_noret;
C_noret_decl(f_21609)
static void C_ccall f_21609(C_word c,C_word *av) C_noret;
C_noret_decl(f_21631)
static void C_fcall f_21631(C_word t0,C_word t1) C_noret;
C_noret_decl(f_21639)
static void C_ccall f_21639(C_word c,C_word *av) C_noret;
C_noret_decl(f_21641)
static void C_fcall f_21641(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_21657)
static void C_ccall f_21657(C_word c,C_word *av) C_noret;
C_noret_decl(f_21664)
static void C_ccall f_21664(C_word c,C_word *av) C_noret;
C_noret_decl(f_21677)
static void C_fcall f_21677(C_word t0,C_word t1) C_noret;
C_noret_decl(f_21683)
static void C_ccall f_21683(C_word c,C_word *av) C_noret;
C_noret_decl(f_21687)
static void C_ccall f_21687(C_word c,C_word *av) C_noret;
C_noret_decl(f_21694)
static void C_ccall f_21694(C_word c,C_word *av) C_noret;
C_noret_decl(f_21702)
static void C_fcall f_21702(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_21708)
static void C_fcall f_21708(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5) C_noret;
C_noret_decl(f_21712)
static void C_ccall f_21712(C_word c,C_word *av) C_noret;
C_noret_decl(f_21721)
static void C_fcall f_21721(C_word t0,C_word t1) C_noret;
C_noret_decl(f_21727)
static void C_fcall f_21727(C_word t0,C_word t1) C_noret;
C_noret_decl(f_21734)
static void C_ccall f_21734(C_word c,C_word *av) C_noret;
C_noret_decl(f_21745)
static void C_ccall f_21745(C_word c,C_word *av) C_noret;
C_noret_decl(f_21791)
static void C_ccall f_21791(C_word c,C_word *av) C_noret;
C_noret_decl(f_21800)
static void C_ccall f_21800(C_word c,C_word *av) C_noret;
C_noret_decl(f_21807)
static void C_ccall f_21807(C_word c,C_word *av) C_noret;
C_noret_decl(f_21811)
static void C_ccall f_21811(C_word c,C_word *av) C_noret;
C_noret_decl(f_21815)
static void C_ccall f_21815(C_word c,C_word *av) C_noret;
C_noret_decl(f_21824)
static void C_ccall f_21824(C_word c,C_word *av) C_noret;
C_noret_decl(f_21835)
static void C_ccall f_21835(C_word c,C_word *av) C_noret;
C_noret_decl(f_21847)
static void C_fcall f_21847(C_word t0,C_word t1) C_noret;
C_noret_decl(f_21878)
static void C_ccall f_21878(C_word c,C_word *av) C_noret;
C_noret_decl(f_21927)
static void C_fcall f_21927(C_word t0,C_word t1) C_noret;
C_noret_decl(f_21931)
static void C_ccall f_21931(C_word c,C_word *av) C_noret;
C_noret_decl(f_21934)
static void C_ccall f_21934(C_word c,C_word *av) C_noret;
C_noret_decl(f_21946)
static void C_ccall f_21946(C_word c,C_word *av) C_noret;
C_noret_decl(f_21966)
static void C_fcall f_21966(C_word t0,C_word t1) C_noret;
C_noret_decl(f_21972)
static void C_ccall f_21972(C_word c,C_word *av) C_noret;
C_noret_decl(f_21982)
static void C_ccall f_21982(C_word c,C_word *av) C_noret;
C_noret_decl(f_22111)
static void C_fcall f_22111(C_word t0,C_word t1) C_noret;
C_noret_decl(f_22118)
static void C_ccall f_22118(C_word c,C_word *av) C_noret;
C_noret_decl(f_22136)
static void C_fcall f_22136(C_word t0,C_word t1) C_noret;
C_noret_decl(f_22142)
static void C_fcall f_22142(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_22146)
static void C_ccall f_22146(C_word c,C_word *av) C_noret;
C_noret_decl(f_22182)
static void C_ccall f_22182(C_word c,C_word *av) C_noret;
C_noret_decl(f_22205)
static void C_ccall f_22205(C_word c,C_word *av) C_noret;
C_noret_decl(f_22223)
static void C_fcall f_22223(C_word t0,C_word t1) C_noret;
C_noret_decl(f_22227)
static void C_ccall f_22227(C_word c,C_word *av) C_noret;
C_noret_decl(f_22234)
static void C_ccall f_22234(C_word c,C_word *av) C_noret;
C_noret_decl(f_22236)
static void C_fcall f_22236(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_22240)
static void C_ccall f_22240(C_word c,C_word *av) C_noret;
C_noret_decl(f_22251)
static void C_ccall f_22251(C_word c,C_word *av) C_noret;
C_noret_decl(f_22267)
static void C_ccall f_22267(C_word c,C_word *av) C_noret;
C_noret_decl(f_22270)
static void C_ccall f_22270(C_word c,C_word *av) C_noret;
C_noret_decl(f_22273)
static void C_ccall f_22273(C_word c,C_word *av) C_noret;
C_noret_decl(f_22287)
static void C_ccall f_22287(C_word c,C_word *av) C_noret;
C_noret_decl(f_22293)
static void C_ccall f_22293(C_word c,C_word *av) C_noret;
C_noret_decl(f_22315)
static void C_ccall f_22315(C_word c,C_word *av) C_noret;
C_noret_decl(f_22327)
static void C_ccall f_22327(C_word c,C_word *av) C_noret;
C_noret_decl(f_22339)
static void C_ccall f_22339(C_word c,C_word *av) C_noret;
C_noret_decl(f_22348)
static void C_ccall f_22348(C_word c,C_word *av) C_noret;
C_noret_decl(f_22358)
static void C_ccall f_22358(C_word c,C_word *av) C_noret;
C_noret_decl(f_22367)
static void C_ccall f_22367(C_word c,C_word *av) C_noret;
C_noret_decl(f_22370)
static void C_ccall f_22370(C_word c,C_word *av) C_noret;
C_noret_decl(f_22388)
static void C_ccall f_22388(C_word c,C_word *av) C_noret;
C_noret_decl(f_22391)
static void C_ccall f_22391(C_word c,C_word *av) C_noret;
C_noret_decl(f_22414)
static void C_ccall f_22414(C_word c,C_word *av) C_noret;
C_noret_decl(f_22420)
static void C_ccall f_22420(C_word c,C_word *av) C_noret;
C_noret_decl(f_22448)
static void C_ccall f_22448(C_word c,C_word *av) C_noret;
C_noret_decl(f_22471)
static void C_ccall f_22471(C_word c,C_word *av) C_noret;
C_noret_decl(f_22485)
static void C_ccall f_22485(C_word c,C_word *av) C_noret;
C_noret_decl(f_22491)
static void C_ccall f_22491(C_word c,C_word *av) C_noret;
C_noret_decl(f_22516)
static void C_ccall f_22516(C_word c,C_word *av) C_noret;
C_noret_decl(f_22528)
static void C_ccall f_22528(C_word c,C_word *av) C_noret;
C_noret_decl(f_22540)
static void C_ccall f_22540(C_word c,C_word *av) C_noret;
C_noret_decl(f_22552)
static void C_ccall f_22552(C_word c,C_word *av) C_noret;
C_noret_decl(f_22564)
static void C_ccall f_22564(C_word c,C_word *av) C_noret;
C_noret_decl(f_22576)
static void C_ccall f_22576(C_word c,C_word *av) C_noret;
C_noret_decl(f_22588)
static void C_ccall f_22588(C_word c,C_word *av) C_noret;
C_noret_decl(f_22591)
static void C_ccall f_22591(C_word c,C_word *av) C_noret;
C_noret_decl(f_22594)
static void C_ccall f_22594(C_word c,C_word *av) C_noret;
C_noret_decl(f_22599)
static void C_ccall f_22599(C_word c,C_word *av) C_noret;
C_noret_decl(f_22604)
static void C_ccall f_22604(C_word c,C_word *av) C_noret;
C_noret_decl(f_22610)
static void C_ccall f_22610(C_word c,C_word *av) C_noret;
C_noret_decl(f_22652)
static void C_ccall f_22652(C_word c,C_word *av) C_noret;
C_noret_decl(f_22664)
static void C_ccall f_22664(C_word c,C_word *av) C_noret;
C_noret_decl(f_22667)
static void C_ccall f_22667(C_word c,C_word *av) C_noret;
C_noret_decl(f_22679)
static void C_ccall f_22679(C_word c,C_word *av) C_noret;
C_noret_decl(f_22691)
static void C_ccall f_22691(C_word c,C_word *av) C_noret;
C_noret_decl(f_22694)
static void C_ccall f_22694(C_word c,C_word *av) C_noret;
C_noret_decl(f_22706)
static void C_ccall f_22706(C_word c,C_word *av) C_noret;
C_noret_decl(f_22718)
static void C_ccall f_22718(C_word c,C_word *av) C_noret;
C_noret_decl(f_22721)
static void C_ccall f_22721(C_word c,C_word *av) C_noret;
C_noret_decl(f_22730)
static void C_ccall f_22730(C_word c,C_word *av) C_noret;
C_noret_decl(f_22745)
static void C_ccall f_22745(C_word c,C_word *av) C_noret;
C_noret_decl(f_22748)
static void C_ccall f_22748(C_word c,C_word *av) C_noret;
C_noret_decl(f_22753)
static void C_ccall f_22753(C_word c,C_word *av) C_noret;
C_noret_decl(f_22758)
static void C_ccall f_22758(C_word c,C_word *av) C_noret;
C_noret_decl(f_22764)
static void C_ccall f_22764(C_word c,C_word *av) C_noret;
C_noret_decl(f_22793)
static void C_ccall f_22793(C_word c,C_word *av) C_noret;
C_noret_decl(f_22805)
static void C_ccall f_22805(C_word c,C_word *av) C_noret;
C_noret_decl(f_22808)
static void C_ccall f_22808(C_word c,C_word *av) C_noret;
C_noret_decl(f_22811)
static void C_ccall f_22811(C_word c,C_word *av) C_noret;
C_noret_decl(f_22826)
static void C_ccall f_22826(C_word c,C_word *av) C_noret;
C_noret_decl(f_22835)
static void C_ccall f_22835(C_word c,C_word *av) C_noret;
C_noret_decl(f_22838)
static void C_ccall f_22838(C_word c,C_word *av) C_noret;
C_noret_decl(f_22844)
static void C_fcall f_22844(C_word t0,C_word t1) C_noret;
C_noret_decl(f_22847)
static void C_ccall f_22847(C_word c,C_word *av) C_noret;
C_noret_decl(f_22853)
static void C_ccall f_22853(C_word c,C_word *av) C_noret;
C_noret_decl(f_22872)
static void C_ccall f_22872(C_word c,C_word *av) C_noret;
C_noret_decl(f_22891)
static void C_ccall f_22891(C_word c,C_word *av) C_noret;
C_noret_decl(f_22907)
static void C_ccall f_22907(C_word c,C_word *av) C_noret;
C_noret_decl(f_22913)
static void C_ccall f_22913(C_word c,C_word *av) C_noret;
C_noret_decl(f_22985)
static void C_ccall f_22985(C_word c,C_word *av) C_noret;
C_noret_decl(f_22997)
static void C_ccall f_22997(C_word c,C_word *av) C_noret;
C_noret_decl(f_23075)
static void C_ccall f_23075(C_word c,C_word *av) C_noret;
C_noret_decl(f_23151)
static void C_ccall f_23151(C_word c,C_word *av) C_noret;
C_noret_decl(f_23316)
static void C_ccall f_23316(C_word c,C_word *av) C_noret;
C_noret_decl(f_23328)
static void C_ccall f_23328(C_word c,C_word *av) C_noret;
C_noret_decl(f_23390)
static void C_ccall f_23390(C_word c,C_word *av) C_noret;
C_noret_decl(f_23393)
static void C_fcall f_23393(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_23439)
static void C_fcall f_23439(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_23443)
static void C_ccall f_23443(C_word c,C_word *av) C_noret;
C_noret_decl(f_23461)
static void C_ccall f_23461(C_word c,C_word *av) C_noret;
C_noret_decl(f_23525)
static void C_ccall f_23525(C_word c,C_word *av) C_noret;
C_noret_decl(f_23536)
static void C_ccall f_23536(C_word c,C_word *av) C_noret;
C_noret_decl(f_23538)
static void C_ccall f_23538(C_word c,C_word *av) C_noret;
C_noret_decl(f_23551)
static void C_ccall f_23551(C_word c,C_word *av) C_noret;
C_noret_decl(f_23563)
static void C_ccall f_23563(C_word c,C_word *av) C_noret;
C_noret_decl(f_23583)
static void C_ccall f_23583(C_word c,C_word *av) C_noret;
C_noret_decl(f_23590)
static void C_ccall f_23590(C_word c,C_word *av) C_noret;
C_noret_decl(f_23599)
static void C_ccall f_23599(C_word c,C_word *av) C_noret;
C_noret_decl(f_23611)
static void C_ccall f_23611(C_word c,C_word *av) C_noret;
C_noret_decl(f_23632)
static void C_ccall f_23632(C_word c,C_word *av) C_noret;
C_noret_decl(f_23647)
static void C_ccall f_23647(C_word c,C_word *av) C_noret;
C_noret_decl(f_23665)
static void C_ccall f_23665(C_word c,C_word *av) C_noret;
C_noret_decl(f_23683)
static void C_ccall f_23683(C_word c,C_word *av) C_noret;
C_noret_decl(f_23702)
static void C_fcall f_23702(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_23712)
static void C_ccall f_23712(C_word c,C_word *av) C_noret;
C_noret_decl(f_23726)
static void C_ccall f_23726(C_word c,C_word *av) C_noret;
C_noret_decl(f_23729)
static void C_ccall f_23729(C_word c,C_word *av) C_noret;
C_noret_decl(f_23734)
static void C_ccall f_23734(C_word c,C_word *av) C_noret;
C_noret_decl(f_23753)
static void C_fcall f_23753(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_23763)
static void C_ccall f_23763(C_word c,C_word *av) C_noret;
C_noret_decl(f_23777)
static void C_ccall f_23777(C_word c,C_word *av) C_noret;
C_noret_decl(f_23780)
static void C_ccall f_23780(C_word c,C_word *av) C_noret;
C_noret_decl(f_23787)
static void C_ccall f_23787(C_word c,C_word *av) C_noret;
C_noret_decl(f_23791)
static void C_ccall f_23791(C_word c,C_word *av) C_noret;
C_noret_decl(f_23795)
static void C_ccall f_23795(C_word c,C_word *av) C_noret;
C_noret_decl(f_23797)
static void C_ccall f_23797(C_word c,C_word *av) C_noret;
C_noret_decl(f_23804)
static void C_ccall f_23804(C_word c,C_word *av) C_noret;
C_noret_decl(f_23807)
static void C_ccall f_23807(C_word c,C_word *av) C_noret;
C_noret_decl(f_23810)
static void C_ccall f_23810(C_word c,C_word *av) C_noret;
C_noret_decl(f_23812)
static void C_fcall f_23812(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_23822)
static void C_ccall f_23822(C_word c,C_word *av) C_noret;
C_noret_decl(f_23828)
static void C_ccall f_23828(C_word c,C_word *av) C_noret;
C_noret_decl(f_23840)
static void C_ccall f_23840(C_word c,C_word *av) C_noret;
C_noret_decl(f_23843)
static void C_ccall f_23843(C_word c,C_word *av) C_noret;
C_noret_decl(f_23846)
static void C_ccall f_23846(C_word c,C_word *av) C_noret;
C_noret_decl(f_23863)
static void C_ccall f_23863(C_word c,C_word *av) C_noret;
C_noret_decl(f_23884)
static void C_fcall f_23884(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_23888)
static void C_ccall f_23888(C_word c,C_word *av) C_noret;
C_noret_decl(f_23901)
static void C_ccall f_23901(C_word c,C_word *av) C_noret;
C_noret_decl(f_23904)
static void C_ccall f_23904(C_word c,C_word *av) C_noret;
C_noret_decl(f_23913)
static void C_ccall f_23913(C_word c,C_word *av) C_noret;
C_noret_decl(f_23916)
static void C_ccall f_23916(C_word c,C_word *av) C_noret;
C_noret_decl(f_23944)
static void C_fcall f_23944(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_23948)
static void C_ccall f_23948(C_word c,C_word *av) C_noret;
C_noret_decl(f_23957)
static void C_ccall f_23957(C_word c,C_word *av) C_noret;
C_noret_decl(f_23968)
static void C_fcall f_23968(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_23975)
static void C_ccall f_23975(C_word c,C_word *av) C_noret;
C_noret_decl(f_23980)
static void C_fcall f_23980(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_24002)
static void C_ccall f_24002(C_word c,C_word *av) C_noret;
C_noret_decl(f_24008)
static void C_ccall f_24008(C_word c,C_word *av) C_noret;
C_noret_decl(f_24011)
static void C_ccall f_24011(C_word c,C_word *av) C_noret;
C_noret_decl(f_24022)
static void C_ccall f_24022(C_word c,C_word *av) C_noret;
C_noret_decl(f_24031)
static void C_ccall f_24031(C_word c,C_word *av) C_noret;
C_noret_decl(f_24034)
static void C_ccall f_24034(C_word c,C_word *av) C_noret;
C_noret_decl(f_24057)
static void C_fcall f_24057(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_24106)
static void C_fcall f_24106(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_24122)
static void C_fcall f_24122(C_word t0,C_word t1) C_noret;
C_noret_decl(f_24129)
static void C_ccall f_24129(C_word c,C_word *av) C_noret;
C_noret_decl(f_24141)
static void C_fcall f_24141(C_word t0,C_word t1) C_noret;
C_noret_decl(f_24246)
static void C_ccall f_24246(C_word c,C_word *av) C_noret;
C_noret_decl(f_24251)
static void C_fcall f_24251(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_24300)
static void C_ccall f_24300(C_word c,C_word *av) C_noret;
C_noret_decl(f_24306)
static void C_ccall f_24306(C_word c,C_word *av) C_noret;
C_noret_decl(f_24310)
static void C_fcall f_24310(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_24333)
static void C_ccall f_24333(C_word c,C_word *av) C_noret;
C_noret_decl(f_24340)
static void C_ccall f_24340(C_word c,C_word *av) C_noret;
C_noret_decl(f_24359)
static void C_ccall f_24359(C_word c,C_word *av) C_noret;
C_noret_decl(f_24395)
static void C_ccall f_24395(C_word c,C_word *av) C_noret;
C_noret_decl(f_24407)
static void C_ccall f_24407(C_word c,C_word *av) C_noret;
C_noret_decl(f_24413)
static void C_ccall f_24413(C_word c,C_word *av) C_noret;
C_noret_decl(f_24435)
static void C_ccall f_24435(C_word c,C_word *av) C_noret;
C_noret_decl(f_24442)
static void C_ccall f_24442(C_word c,C_word *av) C_noret;
C_noret_decl(f_24452)
static void C_ccall f_24452(C_word c,C_word *av) C_noret;
C_noret_decl(f_24461)
static void C_ccall f_24461(C_word c,C_word *av) C_noret;
C_noret_decl(f_24467)
static void C_fcall f_24467(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_24480)
static void C_ccall f_24480(C_word c,C_word *av) C_noret;
C_noret_decl(f_24518)
static void C_ccall f_24518(C_word c,C_word *av) C_noret;
C_noret_decl(f_24584)
static void C_ccall f_24584(C_word c,C_word *av) C_noret;
C_noret_decl(f_24587)
static void C_ccall f_24587(C_word c,C_word *av) C_noret;
C_noret_decl(f_24594)
static void C_ccall f_24594(C_word c,C_word *av) C_noret;
C_noret_decl(f_24634)
static void C_ccall f_24634(C_word c,C_word *av) C_noret;
C_noret_decl(f_24637)
static void C_ccall f_24637(C_word c,C_word *av) C_noret;
C_noret_decl(f_24646)
static void C_fcall f_24646(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_24659)
static void C_ccall f_24659(C_word c,C_word *av) C_noret;
C_noret_decl(f_24668)
static void C_ccall f_24668(C_word c,C_word *av) C_noret;
C_noret_decl(f_24678)
static void C_ccall f_24678(C_word c,C_word *av) C_noret;
C_noret_decl(f_24681)
static void C_ccall f_24681(C_word c,C_word *av) C_noret;
C_noret_decl(f_24707)
static void C_ccall f_24707(C_word c,C_word *av) C_noret;
C_noret_decl(f_24713)
static void C_ccall f_24713(C_word c,C_word *av) C_noret;
C_noret_decl(f_24718)
static void C_fcall f_24718(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_24731)
static void C_ccall f_24731(C_word c,C_word *av) C_noret;
C_noret_decl(f_24734)
static void C_ccall f_24734(C_word c,C_word *av) C_noret;
C_noret_decl(f_24745)
static void C_ccall f_24745(C_word c,C_word *av) C_noret;
C_noret_decl(f_24767)
static void C_ccall f_24767(C_word c,C_word *av) C_noret;
C_noret_decl(f_24779)
static void C_ccall f_24779(C_word c,C_word *av) C_noret;
C_noret_decl(f_24782)
static void C_ccall f_24782(C_word c,C_word *av) C_noret;
C_noret_decl(f_24789)
static void C_ccall f_24789(C_word c,C_word *av) C_noret;
C_noret_decl(f_24798)
static void C_ccall f_24798(C_word c,C_word *av) C_noret;
C_noret_decl(f_24801)
static void C_ccall f_24801(C_word c,C_word *av) C_noret;
C_noret_decl(f_24845)
static void C_ccall f_24845(C_word c,C_word *av) C_noret;
C_noret_decl(f_24848)
static void C_ccall f_24848(C_word c,C_word *av) C_noret;
C_noret_decl(f_24857)
static void C_fcall f_24857(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_24870)
static void C_ccall f_24870(C_word c,C_word *av) C_noret;
C_noret_decl(f_24873)
static void C_ccall f_24873(C_word c,C_word *av) C_noret;
C_noret_decl(f_24898)
static void C_ccall f_24898(C_word c,C_word *av) C_noret;
C_noret_decl(f_24902)
static void C_ccall f_24902(C_word c,C_word *av) C_noret;
C_noret_decl(f_24912)
static void C_ccall f_24912(C_word c,C_word *av) C_noret;
C_noret_decl(f_24915)
static void C_ccall f_24915(C_word c,C_word *av) C_noret;
C_noret_decl(f_24930)
static void C_ccall f_24930(C_word c,C_word *av) C_noret;
C_noret_decl(f_24937)
static void C_ccall f_24937(C_word c,C_word *av) C_noret;
C_noret_decl(f_24959)
static void C_ccall f_24959(C_word c,C_word *av) C_noret;
C_noret_decl(f_24961)
static void C_ccall f_24961(C_word c,C_word *av) C_noret;
C_noret_decl(f_24974)
static void C_ccall f_24974(C_word c,C_word *av) C_noret;
C_noret_decl(f_24979)
static void C_ccall f_24979(C_word c,C_word *av) C_noret;
C_noret_decl(f_24985)
static void C_ccall f_24985(C_word c,C_word *av) C_noret;
C_noret_decl(f_24991)
static void C_ccall f_24991(C_word c,C_word *av) C_noret;
C_noret_decl(f_24995)
static void C_ccall f_24995(C_word c,C_word *av) C_noret;
C_noret_decl(f_24998)
static void C_ccall f_24998(C_word c,C_word *av) C_noret;
C_noret_decl(f_25013)
static void C_ccall f_25013(C_word c,C_word *av) C_noret;
C_noret_decl(f_25016)
static void C_ccall f_25016(C_word c,C_word *av) C_noret;
C_noret_decl(f_25034)
static void C_ccall f_25034(C_word c,C_word *av) C_noret;
C_noret_decl(f_25036)
static void C_ccall f_25036(C_word c,C_word *av) C_noret;
C_noret_decl(f_25042)
static void C_ccall f_25042(C_word c,C_word *av) C_noret;
C_noret_decl(f_25051)
static void C_ccall f_25051(C_word c,C_word *av) C_noret;
C_noret_decl(f_25057)
static void C_ccall f_25057(C_word c,C_word *av) C_noret;
C_noret_decl(f_25064)
static void C_ccall f_25064(C_word c,C_word *av) C_noret;
C_noret_decl(f_25067)
static void C_ccall f_25067(C_word c,C_word *av) C_noret;
C_noret_decl(f_25070)
static void C_ccall f_25070(C_word c,C_word *av) C_noret;
C_noret_decl(f_25079)
static void C_ccall f_25079(C_word c,C_word *av) C_noret;
C_noret_decl(f_25095)
static void C_ccall f_25095(C_word c,C_word *av) C_noret;
C_noret_decl(f_25110)
static void C_ccall f_25110(C_word c,C_word *av) C_noret;
C_noret_decl(f_25112)
static void C_ccall f_25112(C_word c,C_word *av) C_noret;
C_noret_decl(f_25118)
static void C_ccall f_25118(C_word c,C_word *av) C_noret;
C_noret_decl(f_25124)
static void C_ccall f_25124(C_word c,C_word *av) C_noret;
C_noret_decl(f_25128)
static void C_ccall f_25128(C_word c,C_word *av) C_noret;
C_noret_decl(f_25131)
static void C_ccall f_25131(C_word c,C_word *av) C_noret;
C_noret_decl(f_25134)
static void C_ccall f_25134(C_word c,C_word *av) C_noret;
C_noret_decl(f_25138)
static void C_ccall f_25138(C_word c,C_word *av) C_noret;
C_noret_decl(f_25142)
static void C_ccall f_25142(C_word c,C_word *av) C_noret;
C_noret_decl(f_25146)
static void C_ccall f_25146(C_word c,C_word *av) C_noret;
C_noret_decl(f_25149)
static void C_ccall f_25149(C_word c,C_word *av) C_noret;
C_noret_decl(f_25152)
static void C_ccall f_25152(C_word c,C_word *av) C_noret;
C_noret_decl(f_25155)
static void C_ccall f_25155(C_word c,C_word *av) C_noret;
C_noret_decl(f_25167)
static void C_ccall f_25167(C_word c,C_word *av) C_noret;
C_noret_decl(f_25173)
static void C_ccall f_25173(C_word c,C_word *av) C_noret;
C_noret_decl(f_25177)
static void C_ccall f_25177(C_word c,C_word *av) C_noret;
C_noret_decl(f_25180)
static void C_ccall f_25180(C_word c,C_word *av) C_noret;
C_noret_decl(f_25183)
static void C_ccall f_25183(C_word c,C_word *av) C_noret;
C_noret_decl(f_25186)
static void C_ccall f_25186(C_word c,C_word *av) C_noret;
C_noret_decl(f_25189)
static void C_ccall f_25189(C_word c,C_word *av) C_noret;
C_noret_decl(f_25192)
static void C_ccall f_25192(C_word c,C_word *av) C_noret;
C_noret_decl(f_25197)
static void C_ccall f_25197(C_word c,C_word *av) C_noret;
C_noret_decl(f_25219)
static void C_ccall f_25219(C_word c,C_word *av) C_noret;
C_noret_decl(f_25225)
static void C_ccall f_25225(C_word c,C_word *av) C_noret;
C_noret_decl(f_25228)
static void C_ccall f_25228(C_word c,C_word *av) C_noret;
C_noret_decl(f_25253)
static void C_ccall f_25253(C_word c,C_word *av) C_noret;
C_noret_decl(f_25256)
static void C_fcall f_25256(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_25263)
static void C_ccall f_25263(C_word c,C_word *av) C_noret;
C_noret_decl(f_25276)
static void C_fcall f_25276(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6) C_noret;
C_noret_decl(f_25286)
static void C_ccall f_25286(C_word c,C_word *av) C_noret;
C_noret_decl(f_25291)
static void C_ccall f_25291(C_word c,C_word *av) C_noret;
C_noret_decl(f_25297)
static void C_ccall f_25297(C_word c,C_word *av) C_noret;
C_noret_decl(f_25324)
static void C_ccall f_25324(C_word c,C_word *av) C_noret;
C_noret_decl(f_25330)
static void C_fcall f_25330(C_word t0,C_word t1) C_noret;
C_noret_decl(f_25341)
static void C_ccall f_25341(C_word c,C_word *av) C_noret;
C_noret_decl(f_25350)
static void C_ccall f_25350(C_word c,C_word *av) C_noret;
C_noret_decl(f_25355)
static void C_ccall f_25355(C_word c,C_word *av) C_noret;
C_noret_decl(f_25361)
static void C_ccall f_25361(C_word c,C_word *av) C_noret;
C_noret_decl(f_25385)
static void C_ccall f_25385(C_word c,C_word *av) C_noret;
C_noret_decl(f_25393)
static void C_ccall f_25393(C_word c,C_word *av) C_noret;
C_noret_decl(f_25410)
static void C_ccall f_25410(C_word c,C_word *av) C_noret;
C_noret_decl(f_25450)
static void C_ccall f_25450(C_word c,C_word *av) C_noret;
C_noret_decl(f_25457)
static void C_ccall f_25457(C_word c,C_word *av) C_noret;
C_noret_decl(f_25469)
static void C_ccall f_25469(C_word c,C_word *av) C_noret;
C_noret_decl(f_25473)
static void C_ccall f_25473(C_word c,C_word *av) C_noret;
C_noret_decl(f_25486)
static void C_ccall f_25486(C_word c,C_word *av) C_noret;
C_noret_decl(f_25488)
static void C_ccall f_25488(C_word c,C_word *av) C_noret;
C_noret_decl(f_25522)
static void C_ccall f_25522(C_word c,C_word *av) C_noret;
C_noret_decl(f_25526)
static void C_ccall f_25526(C_word c,C_word *av) C_noret;
C_noret_decl(f_25527)
static void C_fcall f_25527(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_25537)
static void C_ccall f_25537(C_word c,C_word *av) C_noret;
C_noret_decl(f_25542)
static void C_fcall f_25542(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_25552)
static void C_ccall f_25552(C_word c,C_word *av) C_noret;
C_noret_decl(f_25565)
static void C_ccall f_25565(C_word c,C_word *av) C_noret;
C_noret_decl(f_25576)
static void C_ccall f_25576(C_word c,C_word *av) C_noret;
C_noret_decl(f_25580)
static void C_ccall f_25580(C_word c,C_word *av) C_noret;
C_noret_decl(f_25584)
static void C_ccall f_25584(C_word c,C_word *av) C_noret;
C_noret_decl(f_25606)
static void C_ccall f_25606(C_word c,C_word *av) C_noret;
C_noret_decl(f_25610)
static void C_ccall f_25610(C_word c,C_word *av) C_noret;
C_noret_decl(f_25618)
static void C_ccall f_25618(C_word c,C_word *av) C_noret;
C_noret_decl(f_25634)
static void C_ccall f_25634(C_word c,C_word *av) C_noret;
C_noret_decl(f_25645)
static void C_fcall f_25645(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_25664)
static void C_fcall f_25664(C_word t0,C_word t1) C_noret;
C_noret_decl(f_25675)
static void C_ccall f_25675(C_word c,C_word *av) C_noret;
C_noret_decl(f_25683)
static void C_ccall f_25683(C_word c,C_word *av) C_noret;
C_noret_decl(f_25762)
static void C_ccall f_25762(C_word c,C_word *av) C_noret;
C_noret_decl(f_25772)
static void C_ccall f_25772(C_word c,C_word *av) C_noret;
C_noret_decl(f_25773)
static void C_fcall f_25773(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_25786)
static void C_ccall f_25786(C_word c,C_word *av) C_noret;
C_noret_decl(f_25789)
static void C_ccall f_25789(C_word c,C_word *av) C_noret;
C_noret_decl(f_25792)
static void C_ccall f_25792(C_word c,C_word *av) C_noret;
C_noret_decl(f_25795)
static void C_ccall f_25795(C_word c,C_word *av) C_noret;
C_noret_decl(f_25803)
static void C_ccall f_25803(C_word c,C_word *av) C_noret;
C_noret_decl(f_25810)
static void C_fcall f_25810(C_word t0,C_word t1) C_noret;
C_noret_decl(f_25813)
static void C_ccall f_25813(C_word c,C_word *av) C_noret;
C_noret_decl(f_25816)
static void C_ccall f_25816(C_word c,C_word *av) C_noret;
C_noret_decl(f_25839)
static void C_ccall f_25839(C_word c,C_word *av) C_noret;
C_noret_decl(f_25844)
static void C_fcall f_25844(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_25854)
static void C_ccall f_25854(C_word c,C_word *av) C_noret;
C_noret_decl(f_25867)
static void C_ccall f_25867(C_word c,C_word *av) C_noret;
C_noret_decl(f_25898)
static void C_ccall f_25898(C_word c,C_word *av) C_noret;
C_noret_decl(f_25908)
static void C_ccall f_25908(C_word c,C_word *av) C_noret;
C_noret_decl(f_25958)
static void C_ccall f_25958(C_word c,C_word *av) C_noret;
C_noret_decl(f_25961)
static void C_ccall f_25961(C_word c,C_word *av) C_noret;
C_noret_decl(f_25980)
static void C_fcall f_25980(C_word t0) C_noret;
C_noret_decl(f_25985)
static void C_ccall f_25985(C_word c,C_word *av) C_noret;
C_noret_decl(f_25991)
static void C_ccall f_25991(C_word c,C_word *av) C_noret;
C_noret_decl(f_25994)
static void C_ccall f_25994(C_word c,C_word *av) C_noret;
C_noret_decl(f_26000)
static void C_ccall f_26000(C_word c,C_word *av) C_noret;
C_noret_decl(f_26008)
static void C_fcall f_26008(C_word t0,C_word t1) C_noret;
C_noret_decl(f_26027)
static void C_ccall f_26027(C_word c,C_word *av) C_noret;
C_noret_decl(f_26032)
static void C_fcall f_26032(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_26042)
static void C_ccall f_26042(C_word c,C_word *av) C_noret;
C_noret_decl(f_26056)
static void C_ccall f_26056(C_word c,C_word *av) C_noret;
C_noret_decl(f_26063)
static void C_ccall f_26063(C_word c,C_word *av) C_noret;
C_noret_decl(f_26067)
static void C_ccall f_26067(C_word c,C_word *av) C_noret;
C_noret_decl(f_26071)
static void C_ccall f_26071(C_word c,C_word *av) C_noret;
C_noret_decl(f_26073)
static void C_ccall f_26073(C_word c,C_word *av) C_noret;
C_noret_decl(f_26099)
static void C_ccall f_26099(C_word c,C_word *av) C_noret;
C_noret_decl(f_26102)
static void C_ccall f_26102(C_word c,C_word *av) C_noret;
C_noret_decl(f_26105)
static void C_ccall f_26105(C_word c,C_word *av) C_noret;
C_noret_decl(f_26112)
static void C_ccall f_26112(C_word c,C_word *av) C_noret;
C_noret_decl(f_26116)
static void C_ccall f_26116(C_word c,C_word *av) C_noret;
C_noret_decl(f_26122)
static void C_ccall f_26122(C_word c,C_word *av) C_noret;
C_noret_decl(f_26127)
static void C_fcall f_26127(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_26137)
static void C_ccall f_26137(C_word c,C_word *av) C_noret;
C_noret_decl(f_26175)
static void C_fcall f_26175(C_word t0,C_word t1) C_noret;
C_noret_decl(f_26178)
static void C_fcall f_26178(C_word t0,C_word t1) C_noret;
C_noret_decl(f_26198)
static void C_fcall f_26198(C_word t0,C_word t1) C_noret;
C_noret_decl(f_26206)
static void C_ccall f_26206(C_word c,C_word *av) C_noret;
C_noret_decl(f_26340)
static void C_ccall f_26340(C_word c,C_word *av) C_noret;
C_noret_decl(f_26357)
static void C_ccall f_26357(C_word c,C_word *av) C_noret;
C_noret_decl(f_26361)
static void C_ccall f_26361(C_word c,C_word *av) C_noret;
C_noret_decl(f_26374)
static void C_ccall f_26374(C_word c,C_word *av) C_noret;
C_noret_decl(f_26383)
static void C_ccall f_26383(C_word c,C_word *av) C_noret;
C_noret_decl(f_26386)
static void C_ccall f_26386(C_word c,C_word *av) C_noret;
C_noret_decl(f_26390)
static void C_ccall f_26390(C_word c,C_word *av) C_noret;
C_noret_decl(f_26429)
static void C_ccall f_26429(C_word c,C_word *av) C_noret;
C_noret_decl(f_26432)
static void C_ccall f_26432(C_word c,C_word *av) C_noret;
C_noret_decl(f_26439)
static void C_ccall f_26439(C_word c,C_word *av) C_noret;
C_noret_decl(f_26443)
static void C_ccall f_26443(C_word c,C_word *av) C_noret;
C_noret_decl(f_26469)
static void C_ccall f_26469(C_word c,C_word *av) C_noret;
C_noret_decl(f_26500)
static void C_ccall f_26500(C_word c,C_word *av) C_noret;
C_noret_decl(f_26503)
static void C_ccall f_26503(C_word c,C_word *av) C_noret;
C_noret_decl(f_26515)
static void C_ccall f_26515(C_word c,C_word *av) C_noret;
C_noret_decl(f_26518)
static void C_ccall f_26518(C_word c,C_word *av) C_noret;
C_noret_decl(f_26521)
static void C_ccall f_26521(C_word c,C_word *av) C_noret;
C_noret_decl(f_26546)
static void C_ccall f_26546(C_word c,C_word *av) C_noret;
C_noret_decl(f_26552)
static void C_ccall f_26552(C_word c,C_word *av) C_noret;
C_noret_decl(f_26556)
static void C_ccall f_26556(C_word c,C_word *av) C_noret;
C_noret_decl(f_26560)
static void C_ccall f_26560(C_word c,C_word *av) C_noret;
C_noret_decl(f_26573)
static void C_ccall f_26573(C_word c,C_word *av) C_noret;
C_noret_decl(f_26575)
static C_word C_fcall f_26575(C_word t0,C_word t1);
C_noret_decl(f_26581)
static C_word C_fcall f_26581(C_word t0);
C_noret_decl(f_26586)
static C_word C_fcall f_26586(C_word t0);
C_noret_decl(f_26621)
static void C_fcall f_26621(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_26627)
static void C_fcall f_26627(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_26643)
static void C_fcall f_26643(C_word t0,C_word t1) C_noret;
C_noret_decl(f_26665)
static void C_ccall f_26665(C_word c,C_word *av) C_noret;
C_noret_decl(f_26689)
static void C_ccall f_26689(C_word c,C_word *av) C_noret;
C_noret_decl(f_26701)
static void C_ccall f_26701(C_word c,C_word *av) C_noret;
C_noret_decl(f_26703)
static void C_ccall f_26703(C_word c,C_word *av) C_noret;
C_noret_decl(f_26722)
static void C_ccall f_26722(C_word c,C_word *av) C_noret;
C_noret_decl(f_26726)
static void C_ccall f_26726(C_word c,C_word *av) C_noret;
C_noret_decl(f_26738)
static void C_ccall f_26738(C_word c,C_word *av) C_noret;
C_noret_decl(f_26740)
static void C_fcall f_26740(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_26784)
static void C_ccall f_26784(C_word c,C_word *av) C_noret;
C_noret_decl(f_26786)
static void C_fcall f_26786(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_26820)
static C_word C_fcall f_26820(C_word t0);
C_noret_decl(f_26843)
static void C_ccall f_26843(C_word c,C_word *av) C_noret;
C_noret_decl(f_26850)
static void C_ccall f_26850(C_word c,C_word *av) C_noret;
C_noret_decl(f_26860)
static void C_ccall f_26860(C_word c,C_word *av) C_noret;
C_noret_decl(f_26862)
static void C_fcall f_26862(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_26912)
static void C_ccall f_26912(C_word c,C_word *av) C_noret;
C_noret_decl(f_26914)
static void C_fcall f_26914(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_26939)
static void C_ccall f_26939(C_word c,C_word *av) C_noret;
C_noret_decl(f_26948)
static void C_ccall f_26948(C_word c,C_word *av) C_noret;
C_noret_decl(f_26954)
static void C_ccall f_26954(C_word c,C_word *av) C_noret;
C_noret_decl(f_26958)
static void C_ccall f_26958(C_word c,C_word *av) C_noret;
C_noret_decl(f_26962)
static void C_fcall f_26962(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_26970)
static void C_ccall f_26970(C_word c,C_word *av) C_noret;
C_noret_decl(f_26976)
static void C_fcall f_26976(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_27007)
static void C_ccall f_27007(C_word c,C_word *av) C_noret;
C_noret_decl(f_27032)
static void C_fcall f_27032(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_27057)
static void C_ccall f_27057(C_word c,C_word *av) C_noret;
C_noret_decl(f_27067)
static void C_ccall f_27067(C_word c,C_word *av) C_noret;
C_noret_decl(f_27072)
static void C_ccall f_27072(C_word c,C_word *av) C_noret;
C_noret_decl(f_27074)
static void C_ccall f_27074(C_word c,C_word *av) C_noret;
C_noret_decl(f_27081)
static void C_ccall f_27081(C_word c,C_word *av) C_noret;
C_noret_decl(f_27093)
static void C_ccall f_27093(C_word c,C_word *av) C_noret;
C_noret_decl(f_27101)
static void C_ccall f_27101(C_word c,C_word *av) C_noret;
C_noret_decl(f_27139)
static void C_ccall f_27139(C_word c,C_word *av) C_noret;
C_noret_decl(f_27143)
static void C_ccall f_27143(C_word c,C_word *av) C_noret;
C_noret_decl(f_27150)
static void C_ccall f_27150(C_word c,C_word *av) C_noret;
C_noret_decl(f_27153)
static void C_ccall f_27153(C_word c,C_word *av) C_noret;
C_noret_decl(f_27156)
static void C_ccall f_27156(C_word c,C_word *av) C_noret;
C_noret_decl(f_27157)
static void C_fcall f_27157(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_27159)
static void C_fcall f_27159(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_27163)
static void C_ccall f_27163(C_word c,C_word *av) C_noret;
C_noret_decl(f_27168)
static void C_ccall f_27168(C_word c,C_word *av) C_noret;
C_noret_decl(f_27180)
static void C_fcall f_27180(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_27190)
static void C_ccall f_27190(C_word c,C_word *av) C_noret;
C_noret_decl(f_27202)
static void C_ccall f_27202(C_word c,C_word *av) C_noret;
C_noret_decl(f_27204)
static void C_fcall f_27204(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_27211)
static void C_ccall f_27211(C_word c,C_word *av) C_noret;
C_noret_decl(f_27214)
static void C_ccall f_27214(C_word c,C_word *av) C_noret;
C_noret_decl(f_27223)
static void C_ccall f_27223(C_word c,C_word *av) C_noret;
C_noret_decl(f_27226)
static void C_ccall f_27226(C_word c,C_word *av) C_noret;
C_noret_decl(f_27229)
static void C_ccall f_27229(C_word c,C_word *av) C_noret;
C_noret_decl(f_27244)
static void C_ccall f_27244(C_word c,C_word *av) C_noret;
C_noret_decl(f_27250)
static void C_ccall f_27250(C_word c,C_word *av) C_noret;
C_noret_decl(f_27258)
static void C_fcall f_27258(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_27262)
static void C_ccall f_27262(C_word c,C_word *av) C_noret;
C_noret_decl(f_27265)
static void C_ccall f_27265(C_word c,C_word *av) C_noret;
C_noret_decl(f_27268)
static void C_ccall f_27268(C_word c,C_word *av) C_noret;
C_noret_decl(f_27281)
static void C_ccall f_27281(C_word c,C_word *av) C_noret;
C_noret_decl(f_27285)
static void C_ccall f_27285(C_word c,C_word *av) C_noret;
C_noret_decl(f_27306)
static void C_ccall f_27306(C_word c,C_word *av) C_noret;
C_noret_decl(f_27322)
static void C_ccall f_27322(C_word c,C_word *av) C_noret;
C_noret_decl(f_27325)
static void C_ccall f_27325(C_word c,C_word *av) C_noret;
C_noret_decl(f_27331)
static void C_ccall f_27331(C_word c,C_word *av) C_noret;
C_noret_decl(f_27353)
static void C_fcall f_27353(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_27358)
static void C_fcall f_27358(C_word t0,C_word t1) C_noret;
C_noret_decl(f_27393)
static void C_ccall f_27393(C_word c,C_word *av) C_noret;
C_noret_decl(f_27403)
static void C_ccall f_27403(C_word c,C_word *av) C_noret;
C_noret_decl(f_27406)
static void C_ccall f_27406(C_word c,C_word *av) C_noret;
C_noret_decl(f_27409)
static void C_ccall f_27409(C_word c,C_word *av) C_noret;
C_noret_decl(f_27412)
static void C_ccall f_27412(C_word c,C_word *av) C_noret;
C_noret_decl(f_27415)
static void C_ccall f_27415(C_word c,C_word *av) C_noret;
C_noret_decl(f_27418)
static void C_ccall f_27418(C_word c,C_word *av) C_noret;
C_noret_decl(f_27425)
static void C_ccall f_27425(C_word c,C_word *av) C_noret;
C_noret_decl(f_27428)
static void C_ccall f_27428(C_word c,C_word *av) C_noret;
C_noret_decl(f_27431)
static void C_ccall f_27431(C_word c,C_word *av) C_noret;
C_noret_decl(f_27442)
static void C_ccall f_27442(C_word c,C_word *av) C_noret;
C_noret_decl(f_27465)
static void C_ccall f_27465(C_word c,C_word *av) C_noret;
C_noret_decl(f_27476)
static void C_ccall f_27476(C_word c,C_word *av) C_noret;
C_noret_decl(f_27480)
static void C_ccall f_27480(C_word c,C_word *av) C_noret;
C_noret_decl(f_27502)
static void C_ccall f_27502(C_word c,C_word *av) C_noret;
C_noret_decl(f_27513)
static void C_ccall f_27513(C_word c,C_word *av) C_noret;
C_noret_decl(f_27517)
static void C_ccall f_27517(C_word c,C_word *av) C_noret;
C_noret_decl(f_28016)
static void C_ccall f_28016(C_word c,C_word *av) C_noret;
C_noret_decl(f_28027)
static void C_ccall f_28027(C_word c,C_word *av) C_noret;
C_noret_decl(f_28031)
static void C_ccall f_28031(C_word c,C_word *av) C_noret;
C_noret_decl(f_28148)
static void C_ccall f_28148(C_word c,C_word *av) C_noret;
C_noret_decl(f_28151)
static void C_ccall f_28151(C_word c,C_word *av) C_noret;
C_noret_decl(f_28154)
static void C_ccall f_28154(C_word c,C_word *av) C_noret;
C_noret_decl(f_28157)
static void C_ccall f_28157(C_word c,C_word *av) C_noret;
C_noret_decl(f_28162)
static void C_ccall f_28162(C_word c,C_word *av) C_noret;
C_noret_decl(f_28165)
static void C_ccall f_28165(C_word c,C_word *av) C_noret;
C_noret_decl(f_28168)
static void C_ccall f_28168(C_word c,C_word *av) C_noret;
C_noret_decl(f_28171)
static void C_ccall f_28171(C_word c,C_word *av) C_noret;
C_noret_decl(f_28174)
static void C_ccall f_28174(C_word c,C_word *av) C_noret;
C_noret_decl(f_28177)
static void C_ccall f_28177(C_word c,C_word *av) C_noret;
C_noret_decl(f_28180)
static void C_ccall f_28180(C_word c,C_word *av) C_noret;
C_noret_decl(f_28183)
static void C_ccall f_28183(C_word c,C_word *av) C_noret;
C_noret_decl(f_28186)
static void C_ccall f_28186(C_word c,C_word *av) C_noret;
C_noret_decl(f_28190)
static void C_ccall f_28190(C_word c,C_word *av) C_noret;
C_noret_decl(f_28192)
static void C_ccall f_28192(C_word c,C_word *av) C_noret;
C_noret_decl(f_28200)
static void C_ccall f_28200(C_word c,C_word *av) C_noret;
C_noret_decl(f_28202)
static void C_ccall f_28202(C_word c,C_word *av) C_noret;
C_noret_decl(f_28206)
static void C_ccall f_28206(C_word c,C_word *av) C_noret;
C_noret_decl(f_28208)
static void C_ccall f_28208(C_word c,C_word *av) C_noret;
C_noret_decl(f_28215)
static void C_ccall f_28215(C_word c,C_word *av) C_noret;
C_noret_decl(f_28225)
static void C_ccall f_28225(C_word c,C_word *av) C_noret;
C_noret_decl(f_28250)
static void C_ccall f_28250(C_word c,C_word *av) C_noret;
C_noret_decl(f_28253)
static void C_ccall f_28253(C_word c,C_word *av) C_noret;
C_noret_decl(f_28256)
static void C_ccall f_28256(C_word c,C_word *av) C_noret;
C_noret_decl(f_28259)
static void C_ccall f_28259(C_word c,C_word *av) C_noret;
C_noret_decl(f_28262)
static void C_ccall f_28262(C_word c,C_word *av) C_noret;
C_noret_decl(f_28272)
static void C_ccall f_28272(C_word c,C_word *av) C_noret;
C_noret_decl(f_28278)
static void C_ccall f_28278(C_word c,C_word *av) C_noret;
C_noret_decl(f_28282)
static void C_ccall f_28282(C_word c,C_word *av) C_noret;
C_noret_decl(f_28284)
static void C_ccall f_28284(C_word c,C_word *av) C_noret;
C_noret_decl(f_28294)
static void C_ccall f_28294(C_word c,C_word *av) C_noret;
C_noret_decl(f_28300)
static void C_ccall f_28300(C_word c,C_word *av) C_noret;
C_noret_decl(f_28304)
static void C_ccall f_28304(C_word c,C_word *av) C_noret;
C_noret_decl(f_28306)
static void C_ccall f_28306(C_word c,C_word *av) C_noret;
C_noret_decl(f_28311)
static void C_ccall f_28311(C_word c,C_word *av) C_noret;
C_noret_decl(f_28313)
static void C_ccall f_28313(C_word c,C_word *av) C_noret;
C_noret_decl(f_28316)
static void C_ccall f_28316(C_word c,C_word *av) C_noret;
C_noret_decl(f_28336)
static void C_ccall f_28336(C_word c,C_word *av) C_noret;
C_noret_decl(f_28342)
static void C_fcall f_28342(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_28352)
static void C_ccall f_28352(C_word c,C_word *av) C_noret;
C_noret_decl(f_28362)
static void C_ccall f_28362(C_word c,C_word *av) C_noret;
C_noret_decl(f_28397)
static void C_ccall f_28397(C_word c,C_word *av) C_noret;
C_noret_decl(f_28401)
static void C_ccall f_28401(C_word c,C_word *av) C_noret;
C_noret_decl(f_28406)
static void C_fcall f_28406(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_28416)
static void C_ccall f_28416(C_word c,C_word *av) C_noret;
C_noret_decl(f_28426)
static void C_ccall f_28426(C_word c,C_word *av) C_noret;
C_noret_decl(f_28435)
static void C_ccall f_28435(C_word c,C_word *av) C_noret;
C_noret_decl(f_28438)
static void C_ccall f_28438(C_word c,C_word *av) C_noret;
C_noret_decl(f_28441)
static void C_ccall f_28441(C_word c,C_word *av) C_noret;
C_noret_decl(f_28448)
static void C_ccall f_28448(C_word c,C_word *av) C_noret;
C_noret_decl(f_28455)
static void C_ccall f_28455(C_word c,C_word *av) C_noret;
C_noret_decl(f_28458)
static void C_ccall f_28458(C_word c,C_word *av) C_noret;
C_noret_decl(f_28462)
static void C_ccall f_28462(C_word c,C_word *av) C_noret;
C_noret_decl(f_28464)
static void C_ccall f_28464(C_word c,C_word *av) C_noret;
C_noret_decl(f_28467)
static void C_ccall f_28467(C_word c,C_word *av) C_noret;
C_noret_decl(f_28470)
static void C_ccall f_28470(C_word c,C_word *av) C_noret;
C_noret_decl(f_28473)
static void C_ccall f_28473(C_word c,C_word *av) C_noret;
C_noret_decl(f_28476)
static void C_ccall f_28476(C_word c,C_word *av) C_noret;
C_noret_decl(f_28479)
static void C_ccall f_28479(C_word c,C_word *av) C_noret;
C_noret_decl(f_28482)
static void C_ccall f_28482(C_word c,C_word *av) C_noret;
C_noret_decl(f_28485)
static void C_ccall f_28485(C_word c,C_word *av) C_noret;
C_noret_decl(f_28488)
static void C_ccall f_28488(C_word c,C_word *av) C_noret;
C_noret_decl(f_28491)
static void C_ccall f_28491(C_word c,C_word *av) C_noret;
C_noret_decl(f_28494)
static void C_ccall f_28494(C_word c,C_word *av) C_noret;
C_noret_decl(f_28498)
static void C_ccall f_28498(C_word c,C_word *av) C_noret;
C_noret_decl(f_28501)
static void C_ccall f_28501(C_word c,C_word *av) C_noret;
C_noret_decl(f_28517)
static void C_ccall f_28517(C_word c,C_word *av) C_noret;
C_noret_decl(f_28525)
static void C_ccall f_28525(C_word c,C_word *av) C_noret;
C_noret_decl(f_28528)
static void C_ccall f_28528(C_word c,C_word *av) C_noret;
C_noret_decl(f_28534)
static void C_ccall f_28534(C_word c,C_word *av) C_noret;
C_noret_decl(f_28543)
static void C_ccall f_28543(C_word c,C_word *av) C_noret;
C_noret_decl(f_28549)
static void C_ccall f_28549(C_word c,C_word *av) C_noret;
C_noret_decl(f_28558)
static void C_ccall f_28558(C_word c,C_word *av) C_noret;
C_noret_decl(f_28564)
static void C_ccall f_28564(C_word c,C_word *av) C_noret;
C_noret_decl(f_28570)
static void C_ccall f_28570(C_word c,C_word *av) C_noret;
C_noret_decl(f_28573)
static void C_ccall f_28573(C_word c,C_word *av) C_noret;
C_noret_decl(f_28577)
static void C_ccall f_28577(C_word c,C_word *av) C_noret;
C_noret_decl(f_28580)
static void C_ccall f_28580(C_word c,C_word *av) C_noret;
C_noret_decl(f_28585)
static void C_ccall f_28585(C_word c,C_word *av) C_noret;
C_noret_decl(f_28587)
static void C_ccall f_28587(C_word c,C_word *av) C_noret;
C_noret_decl(f_28591)
static void C_ccall f_28591(C_word c,C_word *av) C_noret;
C_noret_decl(f_28618)
static void C_fcall f_28618(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_28628)
static void C_ccall f_28628(C_word c,C_word *av) C_noret;
C_noret_decl(f_28637)
static void C_ccall f_28637(C_word c,C_word *av) C_noret;
C_noret_decl(f_28644)
static void C_ccall f_28644(C_word c,C_word *av) C_noret;
C_noret_decl(f_28648)
static void C_ccall f_28648(C_word c,C_word *av) C_noret;
C_noret_decl(f_28662)
static void C_fcall f_28662(C_word t0,C_word t1) C_noret;
C_noret_decl(f_28666)
static void C_ccall f_28666(C_word c,C_word *av) C_noret;
C_noret_decl(f_28673)
static void C_ccall f_28673(C_word c,C_word *av) C_noret;
C_noret_decl(f_28675)
static void C_fcall f_28675(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_28697)
static void C_ccall f_28697(C_word c,C_word *av) C_noret;
C_noret_decl(f_28704)
static void C_ccall f_28704(C_word c,C_word *av) C_noret;
C_noret_decl(f_28709)
static void C_fcall f_28709(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_28713)
static void C_ccall f_28713(C_word c,C_word *av) C_noret;
C_noret_decl(f_28716)
static void C_ccall f_28716(C_word c,C_word *av) C_noret;
C_noret_decl(f_28719)
static void C_ccall f_28719(C_word c,C_word *av) C_noret;
C_noret_decl(f_28724)
static void C_fcall f_28724(C_word t0,C_word t1) C_noret;
C_noret_decl(f_28728)
static void C_ccall f_28728(C_word c,C_word *av) C_noret;
C_noret_decl(f_28754)
static void C_ccall f_28754(C_word c,C_word *av) C_noret;
C_noret_decl(f_28767)
static void C_ccall f_28767(C_word c,C_word *av) C_noret;
C_noret_decl(f_28770)
static void C_ccall f_28770(C_word c,C_word *av) C_noret;
C_noret_decl(f_28779)
static void C_ccall f_28779(C_word c,C_word *av) C_noret;
C_noret_decl(f_28782)
static void C_ccall f_28782(C_word c,C_word *av) C_noret;
C_noret_decl(f_28785)
static void C_ccall f_28785(C_word c,C_word *av) C_noret;
C_noret_decl(f_28791)
static void C_ccall f_28791(C_word c,C_word *av) C_noret;
C_noret_decl(f_28798)
static void C_ccall f_28798(C_word c,C_word *av) C_noret;
C_noret_decl(f_28800)
static void C_fcall f_28800(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_28813)
static void C_ccall f_28813(C_word c,C_word *av) C_noret;
C_noret_decl(f_28826)
static void C_ccall f_28826(C_word c,C_word *av) C_noret;
C_noret_decl(f_28829)
static void C_ccall f_28829(C_word c,C_word *av) C_noret;
C_noret_decl(f_28832)
static void C_ccall f_28832(C_word c,C_word *av) C_noret;
C_noret_decl(f_28839)
static void C_ccall f_28839(C_word c,C_word *av) C_noret;
C_noret_decl(f_28892)
static void C_ccall f_28892(C_word c,C_word *av) C_noret;
C_noret_decl(f_28895)
static void C_ccall f_28895(C_word c,C_word *av) C_noret;
C_noret_decl(f_28898)
static void C_ccall f_28898(C_word c,C_word *av) C_noret;
C_noret_decl(f_28900)
static void C_fcall f_28900(C_word t0,C_word t1) C_noret;
C_noret_decl(f_28904)
static void C_ccall f_28904(C_word c,C_word *av) C_noret;
C_noret_decl(f_28908)
static void C_ccall f_28908(C_word c,C_word *av) C_noret;
C_noret_decl(f_28914)
static void C_ccall f_28914(C_word c,C_word *av) C_noret;
C_noret_decl(f_28919)
static void C_fcall f_28919(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_28923)
static void C_ccall f_28923(C_word c,C_word *av) C_noret;
C_noret_decl(f_28935)
static void C_ccall f_28935(C_word c,C_word *av) C_noret;
C_noret_decl(f_28947)
static void C_ccall f_28947(C_word c,C_word *av) C_noret;
C_noret_decl(f_28954)
static void C_ccall f_28954(C_word c,C_word *av) C_noret;
C_noret_decl(f_28960)
static void C_fcall f_28960(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_28974)
static void C_ccall f_28974(C_word c,C_word *av) C_noret;
C_noret_decl(f_29013)
static void C_ccall f_29013(C_word c,C_word *av) C_noret;
C_noret_decl(f_29032)
static void C_ccall f_29032(C_word c,C_word *av) C_noret;
C_noret_decl(f_29055)
static void C_ccall f_29055(C_word c,C_word *av) C_noret;
C_noret_decl(f_29064)
static void C_ccall f_29064(C_word c,C_word *av) C_noret;
C_noret_decl(f_29071)
static void C_ccall f_29071(C_word c,C_word *av) C_noret;
C_noret_decl(f_29088)
static void C_ccall f_29088(C_word c,C_word *av) C_noret;
C_noret_decl(f_29096)
static void C_ccall f_29096(C_word c,C_word *av) C_noret;
C_noret_decl(f_29107)
static void C_ccall f_29107(C_word c,C_word *av) C_noret;
C_noret_decl(f_29115)
static void C_ccall f_29115(C_word c,C_word *av) C_noret;
C_noret_decl(f_29122)
static void C_ccall f_29122(C_word c,C_word *av) C_noret;
C_noret_decl(f_29184)
static void C_ccall f_29184(C_word c,C_word *av) C_noret;
C_noret_decl(f_29191)
static void C_ccall f_29191(C_word c,C_word *av) C_noret;
C_noret_decl(f_29194)
static void C_ccall f_29194(C_word c,C_word *av) C_noret;
C_noret_decl(f_29200)
static void C_ccall f_29200(C_word c,C_word *av) C_noret;
C_noret_decl(f_29207)
static void C_ccall f_29207(C_word c,C_word *av) C_noret;
C_noret_decl(f_29211)
static void C_ccall f_29211(C_word c,C_word *av) C_noret;
C_noret_decl(f_29214)
static void C_ccall f_29214(C_word c,C_word *av) C_noret;
C_noret_decl(f_29222)
static void C_ccall f_29222(C_word c,C_word *av) C_noret;
C_noret_decl(f_29224)
static void C_ccall f_29224(C_word c,C_word *av) C_noret;
C_noret_decl(f_29233)
static void C_ccall f_29233(C_word c,C_word *av) C_noret;
C_noret_decl(f_29239)
static void C_ccall f_29239(C_word c,C_word *av) C_noret;
C_noret_decl(f_29250)
static void C_ccall f_29250(C_word c,C_word *av) C_noret;
C_noret_decl(f_29254)
static void C_ccall f_29254(C_word c,C_word *av) C_noret;
C_noret_decl(f_29256)
static void C_ccall f_29256(C_word c,C_word *av) C_noret;
C_noret_decl(f_29264)
static void C_ccall f_29264(C_word c,C_word *av) C_noret;
C_noret_decl(f_29276)
static void C_ccall f_29276(C_word c,C_word *av) C_noret;
C_noret_decl(f_29282)
static void C_fcall f_29282(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_29286)
static void C_ccall f_29286(C_word c,C_word *av) C_noret;
C_noret_decl(f_29294)
static void C_fcall f_29294(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_29312)
static void C_ccall f_29312(C_word c,C_word *av) C_noret;
C_noret_decl(f_29320)
static void C_ccall f_29320(C_word c,C_word *av) C_noret;
C_noret_decl(f_29324)
static void C_ccall f_29324(C_word c,C_word *av) C_noret;
C_noret_decl(f_29342)
static void C_ccall f_29342(C_word c,C_word *av) C_noret;
C_noret_decl(f_29349)
static void C_ccall f_29349(C_word c,C_word *av) C_noret;
C_noret_decl(f_29361)
static void C_ccall f_29361(C_word c,C_word *av) C_noret;
C_noret_decl(f_29369)
static void C_ccall f_29369(C_word c,C_word *av) C_noret;
C_noret_decl(f_29375)
static void C_fcall f_29375(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_29397)
static void C_ccall f_29397(C_word c,C_word *av) C_noret;
C_noret_decl(f_29401)
static void C_ccall f_29401(C_word c,C_word *av) C_noret;
C_noret_decl(f_29405)
static void C_ccall f_29405(C_word c,C_word *av) C_noret;
C_noret_decl(f_29407)
static void C_ccall f_29407(C_word c,C_word *av) C_noret;
C_noret_decl(f_29410)
static void C_ccall f_29410(C_word c,C_word *av) C_noret;
C_noret_decl(f_29413)
static void C_ccall f_29413(C_word c,C_word *av) C_noret;
C_noret_decl(f_29417)
static void C_ccall f_29417(C_word c,C_word *av) C_noret;
C_noret_decl(f_29420)
static void C_ccall f_29420(C_word c,C_word *av) C_noret;
C_noret_decl(f_29442)
static void C_ccall f_29442(C_word c,C_word *av) C_noret;
C_noret_decl(f_29448)
static void C_ccall f_29448(C_word c,C_word *av) C_noret;
C_noret_decl(f_29452)
static void C_ccall f_29452(C_word c,C_word *av) C_noret;
C_noret_decl(f_29469)
static void C_ccall f_29469(C_word c,C_word *av) C_noret;
C_noret_decl(f_29479)
static void C_ccall f_29479(C_word c,C_word *av) C_noret;
C_noret_decl(f_29483)
static void C_ccall f_29483(C_word c,C_word *av) C_noret;
C_noret_decl(f_29487)
static void C_ccall f_29487(C_word c,C_word *av) C_noret;
C_noret_decl(f_29499)
static void C_ccall f_29499(C_word c,C_word *av) C_noret;
C_noret_decl(f_29509)
static void C_ccall f_29509(C_word c,C_word *av) C_noret;
C_noret_decl(f_29513)
static void C_ccall f_29513(C_word c,C_word *av) C_noret;
C_noret_decl(f_29517)
static void C_ccall f_29517(C_word c,C_word *av) C_noret;
C_noret_decl(f_29548)
static void C_ccall f_29548(C_word c,C_word *av) C_noret;
C_noret_decl(f_29551)
static void C_ccall f_29551(C_word c,C_word *av) C_noret;
C_noret_decl(f_29554)
static void C_ccall f_29554(C_word c,C_word *av) C_noret;
C_noret_decl(f_29560)
static void C_fcall f_29560(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_29573)
static void C_ccall f_29573(C_word c,C_word *av) C_noret;
C_noret_decl(f_29576)
static void C_ccall f_29576(C_word c,C_word *av) C_noret;
C_noret_decl(f_29585)
static void C_ccall f_29585(C_word c,C_word *av) C_noret;
C_noret_decl(f_29591)
static void C_ccall f_29591(C_word c,C_word *av) C_noret;
C_noret_decl(f_29597)
static void C_ccall f_29597(C_word c,C_word *av) C_noret;
C_noret_decl(f_29603)
static void C_ccall f_29603(C_word c,C_word *av) C_noret;
C_noret_decl(f_29609)
static void C_ccall f_29609(C_word c,C_word *av) C_noret;
C_noret_decl(f_29626)
static void C_ccall f_29626(C_word c,C_word *av) C_noret;
C_noret_decl(f_29632)
static void C_ccall f_29632(C_word c,C_word *av) C_noret;
C_noret_decl(f_29647)
static void C_ccall f_29647(C_word c,C_word *av) C_noret;
C_noret_decl(f_29651)
static void C_ccall f_29651(C_word c,C_word *av) C_noret;
C_noret_decl(f_29655)
static void C_ccall f_29655(C_word c,C_word *av) C_noret;
C_noret_decl(f_29659)
static void C_ccall f_29659(C_word c,C_word *av) C_noret;
C_noret_decl(f_29680)
static void C_ccall f_29680(C_word c,C_word *av) C_noret;
C_noret_decl(f_29682)
static void C_ccall f_29682(C_word c,C_word *av) C_noret;
C_noret_decl(f_29688)
static void C_fcall f_29688(C_word t0,C_word t1) C_noret;
C_noret_decl(f_29692)
static void C_ccall f_29692(C_word c,C_word *av) C_noret;
C_noret_decl(f_29701)
static void C_ccall f_29701(C_word c,C_word *av) C_noret;
C_noret_decl(f_29710)
static void C_ccall f_29710(C_word c,C_word *av) C_noret;
C_noret_decl(f_29753)
static void C_ccall f_29753(C_word c,C_word *av) C_noret;
C_noret_decl(f_29775)
static void C_ccall f_29775(C_word c,C_word *av) C_noret;
C_noret_decl(f_29788)
static void C_ccall f_29788(C_word c,C_word *av) C_noret;
C_noret_decl(f_29813)
static void C_ccall f_29813(C_word c,C_word *av) C_noret;
C_noret_decl(f_29829)
static void C_ccall f_29829(C_word c,C_word *av) C_noret;
C_noret_decl(f_29845)
static void C_ccall f_29845(C_word c,C_word *av) C_noret;
C_noret_decl(f_29861)
static void C_ccall f_29861(C_word c,C_word *av) C_noret;
C_noret_decl(f_29877)
static void C_ccall f_29877(C_word c,C_word *av) C_noret;
C_noret_decl(f_29893)
static void C_ccall f_29893(C_word c,C_word *av) C_noret;
C_noret_decl(f_29909)
static void C_ccall f_29909(C_word c,C_word *av) C_noret;
C_noret_decl(f_29925)
static void C_ccall f_29925(C_word c,C_word *av) C_noret;
C_noret_decl(f_29941)
static void C_ccall f_29941(C_word c,C_word *av) C_noret;
C_noret_decl(f_29957)
static void C_ccall f_29957(C_word c,C_word *av) C_noret;
C_noret_decl(f_29964)
static void C_ccall f_29964(C_word c,C_word *av) C_noret;
C_noret_decl(f_30005)
static void C_ccall f_30005(C_word c,C_word *av) C_noret;
C_noret_decl(f_30017)
static void C_ccall f_30017(C_word c,C_word *av) C_noret;
C_noret_decl(f_30023)
static void C_ccall f_30023(C_word c,C_word *av) C_noret;
C_noret_decl(f_30042)
static void C_ccall f_30042(C_word c,C_word *av) C_noret;
C_noret_decl(f_30044)
static void C_ccall f_30044(C_word c,C_word *av) C_noret;
C_noret_decl(f_30067)
static C_word C_fcall f_30067(C_word t0,C_word t1,C_word t2);
C_noret_decl(f_30113)
static void C_ccall f_30113(C_word c,C_word *av) C_noret;
C_noret_decl(f_30115)
static void C_ccall f_30115(C_word c,C_word *av) C_noret;
C_noret_decl(f_30122)
static void C_fcall f_30122(C_word t0,C_word t1) C_noret;
C_noret_decl(f_30134)
static void C_fcall f_30134(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_30178)
static void C_ccall f_30178(C_word c,C_word *av) C_noret;
C_noret_decl(f_30193)
static void C_fcall f_30193(C_word t0,C_word t1) C_noret;
C_noret_decl(f_30201)
static void C_ccall f_30201(C_word c,C_word *av) C_noret;
C_noret_decl(f_30207)
static void C_fcall f_30207(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_30215)
static void C_ccall f_30215(C_word c,C_word *av) C_noret;
C_noret_decl(f_30219)
static void C_ccall f_30219(C_word c,C_word *av) C_noret;
C_noret_decl(f_30227)
static void C_ccall f_30227(C_word c,C_word *av) C_noret;
C_noret_decl(f_30229)
static void C_fcall f_30229(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_30239)
static void C_ccall f_30239(C_word c,C_word *av) C_noret;
C_noret_decl(f_30246)
static void C_ccall f_30246(C_word c,C_word *av) C_noret;
C_noret_decl(f_30250)
static void C_ccall f_30250(C_word c,C_word *av) C_noret;
C_noret_decl(f_30261)
static void C_ccall f_30261(C_word c,C_word *av) C_noret;
C_noret_decl(f_30268)
static void C_ccall f_30268(C_word c,C_word *av) C_noret;
C_noret_decl(f_30272)
static void C_ccall f_30272(C_word c,C_word *av) C_noret;
C_noret_decl(f_30283)
static void C_ccall f_30283(C_word c,C_word *av) C_noret;
C_noret_decl(f_30290)
static void C_ccall f_30290(C_word c,C_word *av) C_noret;
C_noret_decl(f_30294)
static void C_ccall f_30294(C_word c,C_word *av) C_noret;
C_noret_decl(f_30299)
static void C_ccall f_30299(C_word c,C_word *av) C_noret;
C_noret_decl(f_30305)
static void C_ccall f_30305(C_word c,C_word *av) C_noret;
C_noret_decl(f_30308)
static void C_ccall f_30308(C_word c,C_word *av) C_noret;
C_noret_decl(f_30311)
static void C_ccall f_30311(C_word c,C_word *av) C_noret;
C_noret_decl(f_30317)
static void C_ccall f_30317(C_word c,C_word *av) C_noret;
C_noret_decl(f_30326)
static void C_ccall f_30326(C_word c,C_word *av) C_noret;
C_noret_decl(f_30335)
static void C_ccall f_30335(C_word c,C_word *av) C_noret;
C_noret_decl(f_30341)
static void C_ccall f_30341(C_word c,C_word *av) C_noret;
C_noret_decl(f_30344)
static void C_ccall f_30344(C_word c,C_word *av) C_noret;
C_noret_decl(f_30347)
static void C_ccall f_30347(C_word c,C_word *av) C_noret;
C_noret_decl(f_30359)
static void C_ccall f_30359(C_word c,C_word *av) C_noret;
C_noret_decl(f_30362)
static void C_ccall f_30362(C_word c,C_word *av) C_noret;
C_noret_decl(f_30365)
static void C_ccall f_30365(C_word c,C_word *av) C_noret;
C_noret_decl(f_30368)
static void C_ccall f_30368(C_word c,C_word *av) C_noret;
C_noret_decl(f_30380)
static void C_ccall f_30380(C_word c,C_word *av) C_noret;
C_noret_decl(f_30383)
static void C_ccall f_30383(C_word c,C_word *av) C_noret;
C_noret_decl(f_30386)
static void C_ccall f_30386(C_word c,C_word *av) C_noret;
C_noret_decl(f_30389)
static void C_ccall f_30389(C_word c,C_word *av) C_noret;
C_noret_decl(f_30398)
static void C_ccall f_30398(C_word c,C_word *av) C_noret;
C_noret_decl(f_30401)
static void C_ccall f_30401(C_word c,C_word *av) C_noret;
C_noret_decl(f_30414)
static void C_ccall f_30414(C_word c,C_word *av) C_noret;
C_noret_decl(f_30415)
static void C_ccall f_30415(C_word c,C_word *av) C_noret;
C_noret_decl(f_30420)
static void C_ccall f_30420(C_word c,C_word *av) C_noret;
C_noret_decl(f_30421)
static void C_ccall f_30421(C_word c,C_word *av) C_noret;
C_noret_decl(f_30426)
static void C_ccall f_30426(C_word c,C_word *av) C_noret;
C_noret_decl(f_30427)
static void C_ccall f_30427(C_word c,C_word *av) C_noret;
C_noret_decl(f_30432)
static void C_ccall f_30432(C_word c,C_word *av) C_noret;
C_noret_decl(f_30433)
static void C_ccall f_30433(C_word c,C_word *av) C_noret;
C_noret_decl(f_30438)
static void C_ccall f_30438(C_word c,C_word *av) C_noret;
C_noret_decl(f_30439)
static void C_ccall f_30439(C_word c,C_word *av) C_noret;
C_noret_decl(f_30444)
static void C_fcall f_30444(C_word t0,C_word t1) C_noret;
C_noret_decl(f_30446)
static void C_ccall f_30446(C_word c,C_word *av) C_noret;
C_noret_decl(f_30456)
static void C_ccall f_30456(C_word c,C_word *av) C_noret;
C_noret_decl(f_30459)
static void C_ccall f_30459(C_word c,C_word *av) C_noret;
C_noret_decl(f_30462)
static void C_ccall f_30462(C_word c,C_word *av) C_noret;
C_noret_decl(f_30465)
static void C_ccall f_30465(C_word c,C_word *av) C_noret;
C_noret_decl(f_30467)
static void C_fcall f_30467(C_word t0,C_word t1) C_noret;
C_noret_decl(f_30481)
static void C_ccall f_30481(C_word c,C_word *av) C_noret;
C_noret_decl(f_30489)
static void C_ccall f_30489(C_word c,C_word *av) C_noret;
C_noret_decl(f_30493)
static void C_ccall f_30493(C_word c,C_word *av) C_noret;
C_noret_decl(f_30497)
static void C_ccall f_30497(C_word c,C_word *av) C_noret;
C_noret_decl(f_30501)
static void C_ccall f_30501(C_word c,C_word *av) C_noret;
C_noret_decl(f_30507)
static void C_ccall f_30507(C_word c,C_word *av) C_noret;
C_noret_decl(f_30514)
static void C_ccall f_30514(C_word c,C_word *av) C_noret;
C_noret_decl(f_30518)
static void C_ccall f_30518(C_word c,C_word *av) C_noret;
C_noret_decl(f_30522)
static void C_ccall f_30522(C_word c,C_word *av) C_noret;
C_noret_decl(f_30526)
static void C_ccall f_30526(C_word c,C_word *av) C_noret;
C_noret_decl(f_30565)
static void C_ccall f_30565(C_word c,C_word *av) C_noret;
C_noret_decl(f_30568)
static void C_ccall f_30568(C_word c,C_word *av) C_noret;
C_noret_decl(f_30571)
static void C_ccall f_30571(C_word c,C_word *av) C_noret;
C_noret_decl(f_30574)
static void C_ccall f_30574(C_word c,C_word *av) C_noret;
C_noret_decl(f_30577)
static void C_ccall f_30577(C_word c,C_word *av) C_noret;
C_noret_decl(f_30585)
static void C_ccall f_30585(C_word c,C_word *av) C_noret;
C_noret_decl(f_30589)
static void C_ccall f_30589(C_word c,C_word *av) C_noret;
C_noret_decl(f_30592)
static void C_ccall f_30592(C_word c,C_word *av) C_noret;
C_noret_decl(f_30607)
static void C_ccall f_30607(C_word c,C_word *av) C_noret;
C_noret_decl(f_30629)
static void C_ccall f_30629(C_word c,C_word *av) C_noret;
C_noret_decl(f_30635)
static void C_fcall f_30635(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_30655)
static void C_ccall f_30655(C_word c,C_word *av) C_noret;
C_noret_decl(f_30670)
static void C_ccall f_30670(C_word c,C_word *av) C_noret;
C_noret_decl(f_30674)
static void C_ccall f_30674(C_word c,C_word *av) C_noret;
C_noret_decl(f_30697)
static void C_ccall f_30697(C_word c,C_word *av) C_noret;
C_noret_decl(f_30701)
static void C_ccall f_30701(C_word c,C_word *av) C_noret;
C_noret_decl(f_30718)
static void C_ccall f_30718(C_word c,C_word *av) C_noret;
C_noret_decl(f_30725)
static void C_ccall f_30725(C_word c,C_word *av) C_noret;
C_noret_decl(f_30747)
static void C_ccall f_30747(C_word c,C_word *av) C_noret;
C_noret_decl(f_30752)
static void C_fcall f_30752(C_word t0,C_word t1) C_noret;
C_noret_decl(f_30767)
static void C_ccall f_30767(C_word c,C_word *av) C_noret;
C_noret_decl(f_30770)
static void C_ccall f_30770(C_word c,C_word *av) C_noret;
C_noret_decl(f_30773)
static void C_ccall f_30773(C_word c,C_word *av) C_noret;
C_noret_decl(f_30776)
static void C_ccall f_30776(C_word c,C_word *av) C_noret;
C_noret_decl(f_30779)
static void C_ccall f_30779(C_word c,C_word *av) C_noret;
C_noret_decl(f_30782)
static void C_ccall f_30782(C_word c,C_word *av) C_noret;
C_noret_decl(f_30785)
static void C_fcall f_30785(C_word t0,C_word t1) C_noret;
C_noret_decl(f_30788)
static void C_fcall f_30788(C_word t0,C_word t1) C_noret;
C_noret_decl(f_30791)
static void C_fcall f_30791(C_word t0,C_word t1) C_noret;
C_noret_decl(f_30794)
static void C_fcall f_30794(C_word t0,C_word t1) C_noret;
C_noret_decl(f_30797)
static void C_fcall f_30797(C_word t0,C_word t1) C_noret;
C_noret_decl(f_30801)
static void C_ccall f_30801(C_word c,C_word *av) C_noret;
C_noret_decl(f_30804)
static void C_ccall f_30804(C_word c,C_word *av) C_noret;
C_noret_decl(f_30809)
static void C_ccall f_30809(C_word c,C_word *av) C_noret;
C_noret_decl(f_30815)
static void C_ccall f_30815(C_word c,C_word *av) C_noret;
C_noret_decl(f_30828)
static void C_ccall f_30828(C_word c,C_word *av) C_noret;
C_noret_decl(f_30830)
static void C_fcall f_30830(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_30853)
static void C_ccall f_30853(C_word c,C_word *av) C_noret;
C_noret_decl(f_30860)
static void C_ccall f_30860(C_word c,C_word *av) C_noret;
C_noret_decl(f_30864)
static void C_ccall f_30864(C_word c,C_word *av) C_noret;
C_noret_decl(f_30866)
static void C_fcall f_30866(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_30895)
static void C_ccall f_30895(C_word c,C_word *av) C_noret;
C_noret_decl(f_30897)
static void C_fcall f_30897(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_30922)
static void C_ccall f_30922(C_word c,C_word *av) C_noret;
C_noret_decl(f_30931)
static void C_ccall f_30931(C_word c,C_word *av) C_noret;
C_noret_decl(f_30934)
static void C_ccall f_30934(C_word c,C_word *av) C_noret;
C_noret_decl(f_30940)
static void C_fcall f_30940(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_30964)
static void C_ccall f_30964(C_word c,C_word *av) C_noret;
C_noret_decl(f_30971)
static void C_ccall f_30971(C_word c,C_word *av) C_noret;
C_noret_decl(f_30975)
static void C_ccall f_30975(C_word c,C_word *av) C_noret;
C_noret_decl(f_30987)
static void C_ccall f_30987(C_word c,C_word *av) C_noret;
C_noret_decl(f_30995)
static void C_ccall f_30995(C_word c,C_word *av) C_noret;
C_noret_decl(f_30999)
static void C_ccall f_30999(C_word c,C_word *av) C_noret;
C_noret_decl(f_31008)
static void C_ccall f_31008(C_word c,C_word *av) C_noret;
C_noret_decl(f_31017)
static void C_ccall f_31017(C_word c,C_word *av) C_noret;
C_noret_decl(f_31027)
static void C_ccall f_31027(C_word c,C_word *av) C_noret;
C_noret_decl(f_31035)
static void C_ccall f_31035(C_word c,C_word *av) C_noret;
C_noret_decl(f_31039)
static void C_ccall f_31039(C_word c,C_word *av) C_noret;
C_noret_decl(f_31043)
static void C_ccall f_31043(C_word c,C_word *av) C_noret;
C_noret_decl(f_31073)
static void C_ccall f_31073(C_word c,C_word *av) C_noret;
C_noret_decl(f_31077)
static void C_ccall f_31077(C_word c,C_word *av) C_noret;
C_noret_decl(f_31081)
static void C_ccall f_31081(C_word c,C_word *av) C_noret;
C_noret_decl(f_31085)
static void C_ccall f_31085(C_word c,C_word *av) C_noret;
C_noret_decl(f_31089)
static void C_ccall f_31089(C_word c,C_word *av) C_noret;
C_noret_decl(f_31093)
static void C_ccall f_31093(C_word c,C_word *av) C_noret;
C_noret_decl(f_31096)
static void C_ccall f_31096(C_word c,C_word *av) C_noret;
C_noret_decl(f_31099)
static void C_ccall f_31099(C_word c,C_word *av) C_noret;
C_noret_decl(f_31109)
static void C_ccall f_31109(C_word c,C_word *av) C_noret;
C_noret_decl(f_31112)
static void C_ccall f_31112(C_word c,C_word *av) C_noret;
C_noret_decl(f_31114)
static void C_ccall f_31114(C_word c,C_word *av) C_noret;
C_noret_decl(f_31131)
static C_word C_fcall f_31131(C_word t0);
C_noret_decl(f_31158)
static void C_ccall f_31158(C_word c,C_word *av) C_noret;
C_noret_decl(f_31167)
static void C_ccall f_31167(C_word c,C_word *av) C_noret;
C_noret_decl(f_31187)
static void C_ccall f_31187(C_word c,C_word *av) C_noret;
C_noret_decl(f_31191)
static void C_ccall f_31191(C_word c,C_word *av) C_noret;
C_noret_decl(f_31195)
static void C_ccall f_31195(C_word c,C_word *av) C_noret;
C_noret_decl(f_31199)
static void C_ccall f_31199(C_word c,C_word *av) C_noret;
C_noret_decl(f_31203)
static void C_ccall f_31203(C_word c,C_word *av) C_noret;
C_noret_decl(f_31207)
static void C_ccall f_31207(C_word c,C_word *av) C_noret;
C_noret_decl(f_31211)
static void C_ccall f_31211(C_word c,C_word *av) C_noret;
C_noret_decl(f_31213)
static void C_ccall f_31213(C_word c,C_word *av) C_noret;
C_noret_decl(f_31222)
static void C_ccall f_31222(C_word c,C_word *av) C_noret;
C_noret_decl(f_31232)
static void C_ccall f_31232(C_word c,C_word *av) C_noret;
C_noret_decl(f_31257)
static void C_ccall f_31257(C_word c,C_word *av) C_noret;
C_noret_decl(f_31260)
static void C_ccall f_31260(C_word c,C_word *av) C_noret;
C_noret_decl(f_31262)
static void C_ccall f_31262(C_word c,C_word *av) C_noret;
C_noret_decl(f_31278)
static void C_fcall f_31278(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_31297)
static void C_fcall f_31297(C_word t0,C_word t1) C_noret;
C_noret_decl(f_31307)
static void C_ccall f_31307(C_word c,C_word *av) C_noret;
C_noret_decl(f_31317)
static void C_ccall f_31317(C_word c,C_word *av) C_noret;
C_noret_decl(f_31341)
static void C_ccall f_31341(C_word c,C_word *av) C_noret;
C_noret_decl(f_31345)
static void C_ccall f_31345(C_word c,C_word *av) C_noret;
C_noret_decl(f_31347)
static void C_ccall f_31347(C_word c,C_word *av) C_noret;
C_noret_decl(f_31351)
static void C_ccall f_31351(C_word c,C_word *av) C_noret;
C_noret_decl(f_31354)
static void C_ccall f_31354(C_word c,C_word *av) C_noret;
C_noret_decl(f_31369)
static void C_ccall f_31369(C_word c,C_word *av) C_noret;
C_noret_decl(f_31375)
static void C_ccall f_31375(C_word c,C_word *av) C_noret;
C_noret_decl(f_31379)
static void C_ccall f_31379(C_word c,C_word *av) C_noret;
C_noret_decl(f_31388)
static void C_ccall f_31388(C_word c,C_word *av) C_noret;
C_noret_decl(f_31391)
static void C_ccall f_31391(C_word c,C_word *av) C_noret;
C_noret_decl(f_31394)
static void C_ccall f_31394(C_word c,C_word *av) C_noret;
C_noret_decl(f_31397)
static void C_ccall f_31397(C_word c,C_word *av) C_noret;
C_noret_decl(f_31400)
static void C_ccall f_31400(C_word c,C_word *av) C_noret;
C_noret_decl(f_31406)
static void C_ccall f_31406(C_word c,C_word *av) C_noret;
C_noret_decl(f_31412)
static void C_ccall f_31412(C_word c,C_word *av) C_noret;
C_noret_decl(f_31415)
static void C_ccall f_31415(C_word c,C_word *av) C_noret;
C_noret_decl(f_31420)
static void C_ccall f_31420(C_word c,C_word *av) C_noret;
C_noret_decl(f_31430)
static void C_ccall f_31430(C_word c,C_word *av) C_noret;
C_noret_decl(f_31442)
static void C_ccall f_31442(C_word c,C_word *av) C_noret;
C_noret_decl(f_31450)
static void C_fcall f_31450(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_31460)
static void C_ccall f_31460(C_word c,C_word *av) C_noret;
C_noret_decl(f_31476)
static void C_ccall f_31476(C_word c,C_word *av) C_noret;
C_noret_decl(f_31482)
static void C_ccall f_31482(C_word c,C_word *av) C_noret;
C_noret_decl(f_31485)
static void C_ccall f_31485(C_word c,C_word *av) C_noret;
C_noret_decl(f_31488)
static void C_ccall f_31488(C_word c,C_word *av) C_noret;
C_noret_decl(f_31489)
static void C_fcall f_31489(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_31493)
static void C_ccall f_31493(C_word c,C_word *av) C_noret;
C_noret_decl(f_31499)
static void C_ccall f_31499(C_word c,C_word *av) C_noret;
C_noret_decl(f_31503)
static void C_ccall f_31503(C_word c,C_word *av) C_noret;
C_noret_decl(f_31505)
static void C_fcall f_31505(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_31515)
static void C_ccall f_31515(C_word c,C_word *av) C_noret;
C_noret_decl(f_31532)
static void C_ccall f_31532(C_word c,C_word *av) C_noret;
C_noret_decl(f_31535)
static void C_ccall f_31535(C_word c,C_word *av) C_noret;
C_noret_decl(f_31539)
static void C_ccall f_31539(C_word c,C_word *av) C_noret;
C_noret_decl(f_31544)
static void C_ccall f_31544(C_word c,C_word *av) C_noret;
C_noret_decl(f_31550)
static void C_ccall f_31550(C_word c,C_word *av) C_noret;
C_noret_decl(f_31557)
static void C_ccall f_31557(C_word c,C_word *av) C_noret;
C_noret_decl(f_31566)
static void C_ccall f_31566(C_word c,C_word *av) C_noret;
C_noret_decl(f_31574)
static void C_ccall f_31574(C_word c,C_word *av) C_noret;
C_noret_decl(f_31599)
static void C_ccall f_31599(C_word c,C_word *av) C_noret;
C_noret_decl(f_31617)
static void C_ccall f_31617(C_word c,C_word *av) C_noret;
C_noret_decl(f_31621)
static void C_ccall f_31621(C_word c,C_word *av) C_noret;
C_noret_decl(f_31636)
static void C_ccall f_31636(C_word c,C_word *av) C_noret;
C_noret_decl(f_31640)
static void C_ccall f_31640(C_word c,C_word *av) C_noret;
C_noret_decl(f_31655)
static void C_ccall f_31655(C_word c,C_word *av) C_noret;
C_noret_decl(f_31658)
static void C_ccall f_31658(C_word c,C_word *av) C_noret;
C_noret_decl(f_31661)
static void C_ccall f_31661(C_word c,C_word *av) C_noret;
C_noret_decl(f_31671)
static void C_fcall f_31671(C_word t0,C_word t1) C_noret;
C_noret_decl(f_31702)
static void C_ccall f_31702(C_word c,C_word *av) C_noret;
C_noret_decl(f_31726)
static void C_ccall f_31726(C_word c,C_word *av) C_noret;
C_noret_decl(f_31736)
static void C_ccall f_31736(C_word c,C_word *av) C_noret;
C_noret_decl(f_31745)
static void C_ccall f_31745(C_word c,C_word *av) C_noret;
C_noret_decl(f_31786)
static void C_ccall f_31786(C_word c,C_word *av) C_noret;
C_noret_decl(f_31805)
static void C_ccall f_31805(C_word c,C_word *av) C_noret;
C_noret_decl(f_31814)
static void C_ccall f_31814(C_word c,C_word *av) C_noret;
C_noret_decl(f_31818)
static void C_ccall f_31818(C_word c,C_word *av) C_noret;
C_noret_decl(f_31823)
static void C_ccall f_31823(C_word c,C_word *av) C_noret;
C_noret_decl(f_31833)
static void C_ccall f_31833(C_word c,C_word *av) C_noret;
C_noret_decl(f_31843)
static void C_ccall f_31843(C_word c,C_word *av) C_noret;
C_noret_decl(f_31853)
static void C_ccall f_31853(C_word c,C_word *av) C_noret;
C_noret_decl(f_31863)
static void C_ccall f_31863(C_word c,C_word *av) C_noret;
C_noret_decl(f_31873)
static void C_ccall f_31873(C_word c,C_word *av) C_noret;
C_noret_decl(f_31883)
static void C_ccall f_31883(C_word c,C_word *av) C_noret;
C_noret_decl(f_31893)
static void C_ccall f_31893(C_word c,C_word *av) C_noret;
C_noret_decl(f_31903)
static void C_ccall f_31903(C_word c,C_word *av) C_noret;
C_noret_decl(f_31913)
static void C_ccall f_31913(C_word c,C_word *av) C_noret;
C_noret_decl(f_31923)
static void C_ccall f_31923(C_word c,C_word *av) C_noret;
C_noret_decl(f_31933)
static void C_ccall f_31933(C_word c,C_word *av) C_noret;
C_noret_decl(f_31943)
static void C_ccall f_31943(C_word c,C_word *av) C_noret;
C_noret_decl(f_31953)
static void C_ccall f_31953(C_word c,C_word *av) C_noret;
C_noret_decl(f_31969)
static void C_ccall f_31969(C_word c,C_word *av) C_noret;
C_noret_decl(f_31977)
static void C_ccall f_31977(C_word c,C_word *av) C_noret;
C_noret_decl(f_31993)
static void C_ccall f_31993(C_word c,C_word *av) C_noret;
C_noret_decl(f_32009)
static void C_ccall f_32009(C_word c,C_word *av) C_noret;
C_noret_decl(f_32019)
static void C_ccall f_32019(C_word c,C_word *av) C_noret;
C_noret_decl(f_32029)
static void C_ccall f_32029(C_word c,C_word *av) C_noret;
C_noret_decl(f_32048)
static void C_ccall f_32048(C_word c,C_word *av) C_noret;
C_noret_decl(f_32064)
static void C_ccall f_32064(C_word c,C_word *av) C_noret;
C_noret_decl(f_32077)
static void C_ccall f_32077(C_word c,C_word *av) C_noret;
C_noret_decl(f_32083)
static void C_ccall f_32083(C_word c,C_word *av) C_noret;
C_noret_decl(f_32106)
static void C_ccall f_32106(C_word c,C_word *av) C_noret;
C_noret_decl(f_32110)
static void C_ccall f_32110(C_word c,C_word *av) C_noret;
C_noret_decl(f_32114)
static void C_ccall f_32114(C_word c,C_word *av) C_noret;
C_noret_decl(f_32117)
static void C_ccall f_32117(C_word c,C_word *av) C_noret;
C_noret_decl(f_32123)
static void C_ccall f_32123(C_word c,C_word *av) C_noret;
C_noret_decl(f_32146)
static void C_ccall f_32146(C_word c,C_word *av) C_noret;
C_noret_decl(f_32150)
static void C_ccall f_32150(C_word c,C_word *av) C_noret;
C_noret_decl(f_32154)
static void C_ccall f_32154(C_word c,C_word *av) C_noret;
C_noret_decl(f_32157)
static void C_ccall f_32157(C_word c,C_word *av) C_noret;
C_noret_decl(f_32160)
static void C_ccall f_32160(C_word c,C_word *av) C_noret;
C_noret_decl(f_32163)
static void C_ccall f_32163(C_word c,C_word *av) C_noret;
C_noret_decl(f_32169)
static void C_ccall f_32169(C_word c,C_word *av) C_noret;
C_noret_decl(f_32172)
static void C_ccall f_32172(C_word c,C_word *av) C_noret;
C_noret_decl(f_32175)
static void C_ccall f_32175(C_word c,C_word *av) C_noret;
C_noret_decl(f_32185)
static void C_fcall f_32185(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_32209)
static void C_ccall f_32209(C_word c,C_word *av) C_noret;
C_noret_decl(f_32232)
static void C_ccall f_32232(C_word c,C_word *av) C_noret;
C_noret_decl(f_32236)
static void C_ccall f_32236(C_word c,C_word *av) C_noret;
C_noret_decl(f_32240)
static void C_ccall f_32240(C_word c,C_word *av) C_noret;
C_noret_decl(f_32274)
static void C_ccall f_32274(C_word c,C_word *av) C_noret;
C_noret_decl(f_32278)
static void C_ccall f_32278(C_word c,C_word *av) C_noret;
C_noret_decl(f_32281)
static void C_fcall f_32281(C_word t0,C_word t1) C_noret;
C_noret_decl(f_32294)
static void C_fcall f_32294(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6) C_noret;
C_noret_decl(f_32327)
static void C_ccall f_32327(C_word c,C_word *av) C_noret;
C_noret_decl(f_32342)
static void C_ccall f_32342(C_word c,C_word *av) C_noret;
C_noret_decl(f_32346)
static void C_ccall f_32346(C_word c,C_word *av) C_noret;
C_noret_decl(f_32370)
static void C_ccall f_32370(C_word c,C_word *av) C_noret;
C_noret_decl(f_32378)
static void C_ccall f_32378(C_word c,C_word *av) C_noret;
C_noret_decl(f_32382)
static void C_ccall f_32382(C_word c,C_word *av) C_noret;
C_noret_decl(f_32393)
static void C_ccall f_32393(C_word c,C_word *av) C_noret;
C_noret_decl(f_32397)
static void C_ccall f_32397(C_word c,C_word *av) C_noret;
C_noret_decl(f_32401)
static void C_ccall f_32401(C_word c,C_word *av) C_noret;
C_noret_decl(f_32415)
static void C_ccall f_32415(C_word c,C_word *av) C_noret;
C_noret_decl(f_32447)
static void C_ccall f_32447(C_word c,C_word *av) C_noret;
C_noret_decl(f_8545)
static void C_ccall f_8545(C_word c,C_word *av) C_noret;
C_noret_decl(f_8547)
static void C_ccall f_8547(C_word c,C_word *av) C_noret;
C_noret_decl(f_8550)
static void C_ccall f_8550(C_word c,C_word *av) C_noret;
C_noret_decl(f_8553)
static void C_ccall f_8553(C_word c,C_word *av) C_noret;
C_noret_decl(f_8556)
static void C_ccall f_8556(C_word c,C_word *av) C_noret;
C_noret_decl(f_8559)
static void C_ccall f_8559(C_word c,C_word *av) C_noret;
C_noret_decl(f_8562)
static void C_ccall f_8562(C_word c,C_word *av) C_noret;
C_noret_decl(f_8565)
static void C_ccall f_8565(C_word c,C_word *av) C_noret;
C_noret_decl(f_8568)
static void C_ccall f_8568(C_word c,C_word *av) C_noret;
C_noret_decl(f_8571)
static void C_ccall f_8571(C_word c,C_word *av) C_noret;
C_noret_decl(f_8574)
static void C_ccall f_8574(C_word c,C_word *av) C_noret;
C_noret_decl(f_8577)
static void C_ccall f_8577(C_word c,C_word *av) C_noret;
C_noret_decl(f_8580)
static void C_ccall f_8580(C_word c,C_word *av) C_noret;
C_noret_decl(f_8583)
static void C_ccall f_8583(C_word c,C_word *av) C_noret;
C_noret_decl(f_8586)
static void C_ccall f_8586(C_word c,C_word *av) C_noret;
C_noret_decl(f_8589)
static void C_ccall f_8589(C_word c,C_word *av) C_noret;
C_noret_decl(f_8592)
static void C_ccall f_8592(C_word c,C_word *av) C_noret;
C_noret_decl(f_8595)
static void C_ccall f_8595(C_word c,C_word *av) C_noret;
C_noret_decl(f_8598)
static void C_ccall f_8598(C_word c,C_word *av) C_noret;
C_noret_decl(f_8601)
static void C_ccall f_8601(C_word c,C_word *av) C_noret;
C_noret_decl(f_8615)
static void C_ccall f_8615(C_word c,C_word *av) C_noret;
C_noret_decl(f_8622)
static void C_ccall f_8622(C_word c,C_word *av) C_noret;
C_noret_decl(f_8629)
static void C_ccall f_8629(C_word c,C_word *av) C_noret;
C_noret_decl(f_8643)
static void C_ccall f_8643(C_word c,C_word *av) C_noret;
C_noret_decl(f_8650)
static void C_ccall f_8650(C_word c,C_word *av) C_noret;
C_noret_decl(f_8664)
static void C_ccall f_8664(C_word c,C_word *av) C_noret;
C_noret_decl(f_8678)
static void C_ccall f_8678(C_word c,C_word *av) C_noret;
C_noret_decl(f_8696)
static void C_ccall f_8696(C_word c,C_word *av) C_noret;
C_noret_decl(f_8707)
static void C_ccall f_8707(C_word c,C_word *av) C_noret;
C_noret_decl(f_8718)
static void C_ccall f_8718(C_word c,C_word *av) C_noret;
C_noret_decl(f_8725)
static void C_ccall f_8725(C_word c,C_word *av) C_noret;
C_noret_decl(f_8736)
static void C_ccall f_8736(C_word c,C_word *av) C_noret;
C_noret_decl(f_8740)
static void C_ccall f_8740(C_word c,C_word *av) C_noret;
C_noret_decl(f_8747)
static void C_ccall f_8747(C_word c,C_word *av) C_noret;
C_noret_decl(f_8765)
static void C_ccall f_8765(C_word c,C_word *av) C_noret;
C_noret_decl(f_8776)
static void C_ccall f_8776(C_word c,C_word *av) C_noret;
C_noret_decl(f_8787)
static void C_ccall f_8787(C_word c,C_word *av) C_noret;
C_noret_decl(f_8794)
static void C_ccall f_8794(C_word c,C_word *av) C_noret;
C_noret_decl(f_8812)
static void C_ccall f_8812(C_word c,C_word *av) C_noret;
C_noret_decl(f_8823)
static void C_ccall f_8823(C_word c,C_word *av) C_noret;
C_noret_decl(f_8841)
static void C_ccall f_8841(C_word c,C_word *av) C_noret;
C_noret_decl(f_8847)
static void C_ccall f_8847(C_word c,C_word *av) C_noret;
C_noret_decl(f_8850)
static void C_ccall f_8850(C_word c,C_word *av) C_noret;
C_noret_decl(f_8853)
static void C_ccall f_8853(C_word c,C_word *av) C_noret;
C_noret_decl(f_8856)
static void C_ccall f_8856(C_word c,C_word *av) C_noret;
C_noret_decl(f_8859)
static void C_ccall f_8859(C_word c,C_word *av) C_noret;
C_noret_decl(f_8865)
static void C_fcall f_8865(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_8898)
static void C_ccall f_8898(C_word c,C_word *av) C_noret;
C_noret_decl(f_8901)
static void C_ccall f_8901(C_word c,C_word *av) C_noret;
C_noret_decl(f_8904)
static void C_ccall f_8904(C_word c,C_word *av) C_noret;
C_noret_decl(f_8907)
static void C_ccall f_8907(C_word c,C_word *av) C_noret;
C_noret_decl(f_8910)
static void C_ccall f_8910(C_word c,C_word *av) C_noret;
C_noret_decl(f_8913)
static void C_ccall f_8913(C_word c,C_word *av) C_noret;
C_noret_decl(f_8916)
static void C_ccall f_8916(C_word c,C_word *av) C_noret;
C_noret_decl(f_8919)
static void C_ccall f_8919(C_word c,C_word *av) C_noret;
C_noret_decl(f_8922)
static void C_ccall f_8922(C_word c,C_word *av) C_noret;
C_noret_decl(f_8925)
static void C_ccall f_8925(C_word c,C_word *av) C_noret;
C_noret_decl(f_8928)
static void C_ccall f_8928(C_word c,C_word *av) C_noret;
C_noret_decl(f_8931)
static void C_ccall f_8931(C_word c,C_word *av) C_noret;
C_noret_decl(f_8934)
static void C_ccall f_8934(C_word c,C_word *av) C_noret;
C_noret_decl(f_8938)
static void C_ccall f_8938(C_word c,C_word *av) C_noret;
C_noret_decl(f_8941)
static void C_ccall f_8941(C_word c,C_word *av) C_noret;
C_noret_decl(f_8947)
static void C_ccall f_8947(C_word c,C_word *av) C_noret;
C_noret_decl(f_8950)
static void C_ccall f_8950(C_word c,C_word *av) C_noret;
C_noret_decl(f_8953)
static void C_ccall f_8953(C_word c,C_word *av) C_noret;
C_noret_decl(f_8956)
static void C_ccall f_8956(C_word c,C_word *av) C_noret;
C_noret_decl(f_8959)
static void C_ccall f_8959(C_word c,C_word *av) C_noret;
C_noret_decl(f_8967)
static void C_ccall f_8967(C_word c,C_word *av) C_noret;
C_noret_decl(f_8971)
static void C_ccall f_8971(C_word c,C_word *av) C_noret;
C_noret_decl(f_8974)
static void C_ccall f_8974(C_word c,C_word *av) C_noret;
C_noret_decl(f_8977)
static void C_ccall f_8977(C_word c,C_word *av) C_noret;
C_noret_decl(f_8980)
static void C_ccall f_8980(C_word c,C_word *av) C_noret;
C_noret_decl(f_8983)
static void C_ccall f_8983(C_word c,C_word *av) C_noret;
C_noret_decl(f_8986)
static void C_ccall f_8986(C_word c,C_word *av) C_noret;
C_noret_decl(f_8989)
static void C_ccall f_8989(C_word c,C_word *av) C_noret;
C_noret_decl(f_8992)
static void C_ccall f_8992(C_word c,C_word *av) C_noret;
C_noret_decl(f_8996)
static void C_ccall f_8996(C_word c,C_word *av) C_noret;
C_noret_decl(f_8999)
static void C_ccall f_8999(C_word c,C_word *av) C_noret;
C_noret_decl(f_9002)
static void C_ccall f_9002(C_word c,C_word *av) C_noret;
C_noret_decl(f_9005)
static void C_ccall f_9005(C_word c,C_word *av) C_noret;
C_noret_decl(f_9008)
static void C_ccall f_9008(C_word c,C_word *av) C_noret;
C_noret_decl(f_9016)
static void C_ccall f_9016(C_word c,C_word *av) C_noret;
C_noret_decl(f_9019)
static void C_ccall f_9019(C_word c,C_word *av) C_noret;
C_noret_decl(f_9026)
static void C_ccall f_9026(C_word c,C_word *av) C_noret;
C_noret_decl(f_9030)
static void C_ccall f_9030(C_word c,C_word *av) C_noret;
C_noret_decl(f_9033)
static void C_ccall f_9033(C_word c,C_word *av) C_noret;
C_noret_decl(f_9036)
static void C_ccall f_9036(C_word c,C_word *av) C_noret;
C_noret_decl(f_9039)
static void C_ccall f_9039(C_word c,C_word *av) C_noret;
C_noret_decl(f_9042)
static void C_ccall f_9042(C_word c,C_word *av) C_noret;
C_noret_decl(f_9045)
static void C_ccall f_9045(C_word c,C_word *av) C_noret;
C_noret_decl(f_9048)
static void C_ccall f_9048(C_word c,C_word *av) C_noret;
C_noret_decl(f_9054)
static void C_ccall f_9054(C_word c,C_word *av) C_noret;
C_noret_decl(f_9065)
static void C_ccall f_9065(C_word c,C_word *av) C_noret;
C_noret_decl(f_9071)
static void C_ccall f_9071(C_word c,C_word *av) C_noret;
C_noret_decl(f_9077)
static void C_ccall f_9077(C_word c,C_word *av) C_noret;
C_noret_decl(f_9083)
static void C_ccall f_9083(C_word c,C_word *av) C_noret;
C_noret_decl(f_9089)
static void C_ccall f_9089(C_word c,C_word *av) C_noret;
C_noret_decl(f_9095)
static void C_ccall f_9095(C_word c,C_word *av) C_noret;
C_noret_decl(f_9102)
static void C_ccall f_9102(C_word c,C_word *av) C_noret;
C_noret_decl(f_9108)
static void C_ccall f_9108(C_word c,C_word *av) C_noret;
C_noret_decl(f_9124)
static void C_ccall f_9124(C_word c,C_word *av) C_noret;
C_noret_decl(f_9135)
static void C_ccall f_9135(C_word c,C_word *av) C_noret;
C_noret_decl(f_9141)
static void C_ccall f_9141(C_word c,C_word *av) C_noret;
C_noret_decl(f_9147)
static void C_ccall f_9147(C_word c,C_word *av) C_noret;
C_noret_decl(f_9153)
static void C_ccall f_9153(C_word c,C_word *av) C_noret;
C_noret_decl(f_9159)
static void C_ccall f_9159(C_word c,C_word *av) C_noret;
C_noret_decl(f_9168)
static void C_ccall f_9168(C_word c,C_word *av) C_noret;
C_noret_decl(f_9171)
static void C_ccall f_9171(C_word c,C_word *av) C_noret;
C_noret_decl(f_9174)
static void C_ccall f_9174(C_word c,C_word *av) C_noret;
C_noret_decl(f_9177)
static void C_ccall f_9177(C_word c,C_word *av) C_noret;
C_noret_decl(f_9180)
static void C_ccall f_9180(C_word c,C_word *av) C_noret;
C_noret_decl(f_9183)
static void C_ccall f_9183(C_word c,C_word *av) C_noret;
C_noret_decl(f_9187)
static void C_ccall f_9187(C_word c,C_word *av) C_noret;
C_noret_decl(f_9193)
static void C_ccall f_9193(C_word c,C_word *av) C_noret;
C_noret_decl(f_9199)
static void C_ccall f_9199(C_word c,C_word *av) C_noret;
C_noret_decl(f_9234)
static void C_ccall f_9234(C_word c,C_word *av) C_noret;
C_noret_decl(f_9237)
static void C_ccall f_9237(C_word c,C_word *av) C_noret;
C_noret_decl(f_9240)
static void C_ccall f_9240(C_word c,C_word *av) C_noret;
C_noret_decl(f_9248)
static void C_ccall f_9248(C_word c,C_word *av) C_noret;
C_noret_decl(f_9254)
static void C_ccall f_9254(C_word c,C_word *av) C_noret;
C_noret_decl(f_9261)
static void C_ccall f_9261(C_word c,C_word *av) C_noret;
C_noret_decl(f_9276)
static void C_ccall f_9276(C_word c,C_word *av) C_noret;
C_noret_decl(f_9299)
static void C_ccall f_9299(C_word c,C_word *av) C_noret;
C_noret_decl(f_9305)
static void C_ccall f_9305(C_word c,C_word *av) C_noret;
C_noret_decl(f_9311)
static void C_ccall f_9311(C_word c,C_word *av) C_noret;
C_noret_decl(f_9318)
static void C_ccall f_9318(C_word c,C_word *av) C_noret;
C_noret_decl(f_9323)
static void C_ccall f_9323(C_word c,C_word *av) C_noret;
C_noret_decl(f_9326)
static void C_ccall f_9326(C_word c,C_word *av) C_noret;
C_noret_decl(f_9335)
static void C_fcall f_9335(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_9353)
static void C_ccall f_9353(C_word c,C_word *av) C_noret;
C_noret_decl(f_9363)
static void C_ccall f_9363(C_word c,C_word *av) C_noret;
C_noret_decl(f_9372)
static void C_fcall f_9372(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_9390)
static void C_ccall f_9390(C_word c,C_word *av) C_noret;
C_noret_decl(f_9403)
static void C_ccall f_9403(C_word c,C_word *av) C_noret;
C_noret_decl(f_9410)
static void C_ccall f_9410(C_word c,C_word *av) C_noret;
C_noret_decl(f_9417)
static void C_ccall f_9417(C_word c,C_word *av) C_noret;
C_noret_decl(f_9428)
static void C_ccall f_9428(C_word c,C_word *av) C_noret;
C_noret_decl(f_9435)
static void C_ccall f_9435(C_word c,C_word *av) C_noret;
C_noret_decl(f_9447)
static void C_ccall f_9447(C_word c,C_word *av) C_noret;
C_noret_decl(f_9450)
static void C_ccall f_9450(C_word c,C_word *av) C_noret;
C_noret_decl(f_9452)
static void C_ccall f_9452(C_word c,C_word *av) C_noret;
C_noret_decl(f_9458)
static void C_fcall f_9458(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_9474)
static void C_ccall f_9474(C_word c,C_word *av) C_noret;
C_noret_decl(f_9483)
static void C_ccall f_9483(C_word c,C_word *av) C_noret;
C_noret_decl(f_9485)
static void C_ccall f_9485(C_word c,C_word *av) C_noret;
C_noret_decl(f_9491)
static void C_fcall f_9491(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_9504)
static void C_ccall f_9504(C_word c,C_word *av) C_noret;
C_noret_decl(f_9520)
static void C_ccall f_9520(C_word c,C_word *av) C_noret;
C_noret_decl(f_9531)
static void C_ccall f_9531(C_word c,C_word *av) C_noret;
C_noret_decl(f_9533)
static void C_ccall f_9533(C_word c,C_word *av) C_noret;
C_noret_decl(f_9541)
static void C_ccall f_9541(C_word c,C_word *av) C_noret;
C_noret_decl(f_9543)
static void C_ccall f_9543(C_word c,C_word *av) C_noret;
C_noret_decl(f_9549)
static void C_ccall f_9549(C_word c,C_word *av) C_noret;
C_noret_decl(f_9551)
static void C_ccall f_9551(C_word c,C_word *av) C_noret;
C_noret_decl(f_9559)
static void C_ccall f_9559(C_word c,C_word *av) C_noret;
C_noret_decl(f_9561)
static void C_ccall f_9561(C_word c,C_word *av) C_noret;
C_noret_decl(f_9564)
static void C_ccall f_9564(C_word c,C_word *av) C_noret;
C_noret_decl(f_9572)
static void C_ccall f_9572(C_word c,C_word *av) C_noret;
C_noret_decl(f_9578)
static void C_ccall f_9578(C_word c,C_word *av) C_noret;
C_noret_decl(f_9586)
static void C_ccall f_9586(C_word c,C_word *av) C_noret;
C_noret_decl(f_9597)
static void C_ccall f_9597(C_word c,C_word *av) C_noret;
C_noret_decl(f_9609)
static void C_fcall f_9609(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_9623)
static void C_ccall f_9623(C_word c,C_word *av) C_noret;
C_noret_decl(f_9631)
static void C_ccall f_9631(C_word c,C_word *av) C_noret;
C_noret_decl(f_9634)
static void C_ccall f_9634(C_word c,C_word *av) C_noret;
C_noret_decl(f_9636)
static void C_ccall f_9636(C_word c,C_word *av) C_noret;
C_noret_decl(f_9638)
static void C_ccall f_9638(C_word c,C_word *av) C_noret;
C_noret_decl(f_9644)
static void C_fcall f_9644(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_9663)
static void C_ccall f_9663(C_word c,C_word *av) C_noret;
C_noret_decl(f_9680)
static void C_ccall f_9680(C_word c,C_word *av) C_noret;
C_noret_decl(f_9688)
static void C_ccall f_9688(C_word c,C_word *av) C_noret;
C_noret_decl(f_9702)
static void C_ccall f_9702(C_word c,C_word *av) C_noret;
C_noret_decl(f_9708)
static void C_fcall f_9708(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_9727)
static void C_ccall f_9727(C_word c,C_word *av) C_noret;
C_noret_decl(f_9736)
static void C_ccall f_9736(C_word c,C_word *av) C_noret;
C_noret_decl(f_9739)
static void C_ccall f_9739(C_word c,C_word *av) C_noret;
C_noret_decl(f_9751)
static C_word C_fcall f_9751(C_word t0,C_word t1);
C_noret_decl(f_9767)
static void C_ccall f_9767(C_word c,C_word *av) C_noret;
C_noret_decl(f_9773)
static void C_fcall f_9773(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_9798)
static void C_ccall f_9798(C_word c,C_word *av) C_noret;
C_noret_decl(f_9800)
static void C_ccall f_9800(C_word c,C_word *av) C_noret;
C_noret_decl(f_9809)
static void C_fcall f_9809(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_9830)
static void C_ccall f_9830(C_word c,C_word *av) C_noret;
C_noret_decl(f_9832)
static void C_ccall f_9832(C_word c,C_word *av) C_noret;
C_noret_decl(f_9838)
static void C_fcall f_9838(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_9864)
static void C_ccall f_9864(C_word c,C_word *av) C_noret;
C_noret_decl(f_9871)
static void C_ccall f_9871(C_word c,C_word *av) C_noret;
C_noret_decl(f_9873)
static void C_ccall f_9873(C_word c,C_word *av) C_noret;
C_noret_decl(f_9885)
static void C_fcall f_9885(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_9920)
static void C_ccall f_9920(C_word c,C_word *av) C_noret;
C_noret_decl(f_9930)
static void C_ccall f_9930(C_word c,C_word *av) C_noret;
C_noret_decl(f_9939)
static void C_fcall f_9939(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_9981)
static void C_ccall f_9981(C_word c,C_word *av) C_noret;
C_noret_decl(C_library_toplevel)
C_externexport void C_ccall C_library_toplevel(C_word c,C_word *av) C_noret;

C_noret_decl(trf_10017)
static void C_ccall trf_10017(C_word c,C_word *av) C_noret;
static void C_ccall trf_10017(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_10017(t0,t1);}

C_noret_decl(trf_10055)
static void C_ccall trf_10055(C_word c,C_word *av) C_noret;
static void C_ccall trf_10055(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_10055(t0,t1,t2);}

C_noret_decl(trf_10105)
static void C_ccall trf_10105(C_word c,C_word *av) C_noret;
static void C_ccall trf_10105(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_10105(t0,t1,t2);}

C_noret_decl(trf_10216)
static void C_ccall trf_10216(C_word c,C_word *av) C_noret;
static void C_ccall trf_10216(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_10216(t0,t1);}

C_noret_decl(trf_10247)
static void C_ccall trf_10247(C_word c,C_word *av) C_noret;
static void C_ccall trf_10247(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_10247(t0,t1,t2);}

C_noret_decl(trf_10324)
static void C_ccall trf_10324(C_word c,C_word *av) C_noret;
static void C_ccall trf_10324(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_10324(t0,t1,t2);}

C_noret_decl(trf_10929)
static void C_ccall trf_10929(C_word c,C_word *av) C_noret;
static void C_ccall trf_10929(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_10929(t0,t1,t2,t3);}

C_noret_decl(trf_10978)
static void C_ccall trf_10978(C_word c,C_word *av) C_noret;
static void C_ccall trf_10978(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_10978(t0,t1);}

C_noret_decl(trf_11185)
static void C_ccall trf_11185(C_word c,C_word *av) C_noret;
static void C_ccall trf_11185(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_11185(t0,t1,t2);}

C_noret_decl(trf_11204)
static void C_ccall trf_11204(C_word c,C_word *av) C_noret;
static void C_ccall trf_11204(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_11204(t0,t1,t2);}

C_noret_decl(trf_11258)
static void C_ccall trf_11258(C_word c,C_word *av) C_noret;
static void C_ccall trf_11258(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_11258(t0,t1,t2,t3);}

C_noret_decl(trf_11354)
static void C_ccall trf_11354(C_word c,C_word *av) C_noret;
static void C_ccall trf_11354(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_11354(t0,t1,t2,t3);}

C_noret_decl(trf_11512)
static void C_ccall trf_11512(C_word c,C_word *av) C_noret;
static void C_ccall trf_11512(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_11512(t0,t1);}

C_noret_decl(trf_11521)
static void C_ccall trf_11521(C_word c,C_word *av) C_noret;
static void C_ccall trf_11521(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_11521(t0,t1);}

C_noret_decl(trf_11804)
static void C_ccall trf_11804(C_word c,C_word *av) C_noret;
static void C_ccall trf_11804(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_11804(t0,t1,t2,t3);}

C_noret_decl(trf_11893)
static void C_ccall trf_11893(C_word c,C_word *av) C_noret;
static void C_ccall trf_11893(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_11893(t0,t1,t2,t3);}

C_noret_decl(trf_11914)
static void C_ccall trf_11914(C_word c,C_word *av) C_noret;
static void C_ccall trf_11914(C_word c,C_word *av){
C_word t0=av[4];
C_word t1=av[3];
C_word t2=av[2];
C_word t3=av[1];
C_word t4=av[0];
f_11914(t0,t1,t2,t3,t4);}

C_noret_decl(trf_12643)
static void C_ccall trf_12643(C_word c,C_word *av) C_noret;
static void C_ccall trf_12643(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_12643(t0,t1,t2);}

C_noret_decl(trf_13002)
static void C_ccall trf_13002(C_word c,C_word *av) C_noret;
static void C_ccall trf_13002(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_13002(t0,t1,t2,t3);}

C_noret_decl(trf_13019)
static void C_ccall trf_13019(C_word c,C_word *av) C_noret;
static void C_ccall trf_13019(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_13019(t0,t1,t2,t3);}

C_noret_decl(trf_13186)
static void C_ccall trf_13186(C_word c,C_word *av) C_noret;
static void C_ccall trf_13186(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_13186(t0,t1,t2,t3);}

C_noret_decl(trf_13668)
static void C_ccall trf_13668(C_word c,C_word *av) C_noret;
static void C_ccall trf_13668(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_13668(t0,t1,t2);}

C_noret_decl(trf_13671)
static void C_ccall trf_13671(C_word c,C_word *av) C_noret;
static void C_ccall trf_13671(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_13671(t0,t1,t2,t3);}

C_noret_decl(trf_13850)
static void C_ccall trf_13850(C_word c,C_word *av) C_noret;
static void C_ccall trf_13850(C_word c,C_word *av){
C_word t0=av[4];
C_word t1=av[3];
C_word t2=av[2];
C_word t3=av[1];
C_word t4=av[0];
f_13850(t0,t1,t2,t3,t4);}

C_noret_decl(trf_13894)
static void C_ccall trf_13894(C_word c,C_word *av) C_noret;
static void C_ccall trf_13894(C_word c,C_word *av){
C_word t0=av[4];
C_word t1=av[3];
C_word t2=av[2];
C_word t3=av[1];
C_word t4=av[0];
f_13894(t0,t1,t2,t3,t4);}

C_noret_decl(trf_14157)
static void C_ccall trf_14157(C_word c,C_word *av) C_noret;
static void C_ccall trf_14157(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_14157(t0,t1);}

C_noret_decl(trf_14163)
static void C_ccall trf_14163(C_word c,C_word *av) C_noret;
static void C_ccall trf_14163(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_14163(t0,t1);}

C_noret_decl(trf_14219)
static void C_ccall trf_14219(C_word c,C_word *av) C_noret;
static void C_ccall trf_14219(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_14219(t0,t1);}

C_noret_decl(trf_14225)
static void C_ccall trf_14225(C_word c,C_word *av) C_noret;
static void C_ccall trf_14225(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_14225(t0,t1);}

C_noret_decl(trf_14698)
static void C_ccall trf_14698(C_word c,C_word *av) C_noret;
static void C_ccall trf_14698(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_14698(t0,t1);}

C_noret_decl(trf_14733)
static void C_ccall trf_14733(C_word c,C_word *av) C_noret;
static void C_ccall trf_14733(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_14733(t0,t1,t2,t3);}

C_noret_decl(trf_14843)
static void C_ccall trf_14843(C_word c,C_word *av) C_noret;
static void C_ccall trf_14843(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_14843(t0,t1,t2,t3);}

C_noret_decl(trf_14885)
static void C_ccall trf_14885(C_word c,C_word *av) C_noret;
static void C_ccall trf_14885(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_14885(t0,t1,t2);}

C_noret_decl(trf_14899)
static void C_ccall trf_14899(C_word c,C_word *av) C_noret;
static void C_ccall trf_14899(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_14899(t0,t1,t2);}

C_noret_decl(trf_15053)
static void C_ccall trf_15053(C_word c,C_word *av) C_noret;
static void C_ccall trf_15053(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_15053(t0,t1);}

C_noret_decl(trf_15149)
static void C_ccall trf_15149(C_word c,C_word *av) C_noret;
static void C_ccall trf_15149(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_15149(t0,t1,t2,t3);}

C_noret_decl(trf_15245)
static void C_ccall trf_15245(C_word c,C_word *av) C_noret;
static void C_ccall trf_15245(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_15245(t0,t1,t2,t3);}

C_noret_decl(trf_15310)
static void C_ccall trf_15310(C_word c,C_word *av) C_noret;
static void C_ccall trf_15310(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_15310(t0,t1,t2,t3);}

C_noret_decl(trf_15514)
static void C_ccall trf_15514(C_word c,C_word *av) C_noret;
static void C_ccall trf_15514(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_15514(t0,t1);}

C_noret_decl(trf_15575)
static void C_ccall trf_15575(C_word c,C_word *av) C_noret;
static void C_ccall trf_15575(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_15575(t0,t1,t2);}

C_noret_decl(trf_15618)
static void C_ccall trf_15618(C_word c,C_word *av) C_noret;
static void C_ccall trf_15618(C_word c,C_word *av){
C_word t0=av[4];
C_word t1=av[3];
C_word t2=av[2];
C_word t3=av[1];
C_word t4=av[0];
f_15618(t0,t1,t2,t3,t4);}

C_noret_decl(trf_15636)
static void C_ccall trf_15636(C_word c,C_word *av) C_noret;
static void C_ccall trf_15636(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_15636(t0,t1,t2,t3);}

C_noret_decl(trf_15716)
static void C_ccall trf_15716(C_word c,C_word *av) C_noret;
static void C_ccall trf_15716(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_15716(t0,t1,t2);}

C_noret_decl(trf_15722)
static void C_ccall trf_15722(C_word c,C_word *av) C_noret;
static void C_ccall trf_15722(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_15722(t0,t1,t2);}

C_noret_decl(trf_15785)
static void C_ccall trf_15785(C_word c,C_word *av) C_noret;
static void C_ccall trf_15785(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_15785(t0,t1);}

C_noret_decl(trf_15824)
static void C_ccall trf_15824(C_word c,C_word *av) C_noret;
static void C_ccall trf_15824(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_15824(t0,t1,t2);}

C_noret_decl(trf_15830)
static void C_ccall trf_15830(C_word c,C_word *av) C_noret;
static void C_ccall trf_15830(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_15830(t0,t1,t2);}

C_noret_decl(trf_15874)
static void C_ccall trf_15874(C_word c,C_word *av) C_noret;
static void C_ccall trf_15874(C_word c,C_word *av){
C_word t0=av[4];
C_word t1=av[3];
C_word t2=av[2];
C_word t3=av[1];
C_word t4=av[0];
f_15874(t0,t1,t2,t3,t4);}

C_noret_decl(trf_15930)
static void C_ccall trf_15930(C_word c,C_word *av) C_noret;
static void C_ccall trf_15930(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_15930(t0,t1,t2);}

C_noret_decl(trf_15945)
static void C_ccall trf_15945(C_word c,C_word *av) C_noret;
static void C_ccall trf_15945(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_15945(t0,t1);}

C_noret_decl(trf_15988)
static void C_ccall trf_15988(C_word c,C_word *av) C_noret;
static void C_ccall trf_15988(C_word c,C_word *av){
C_word t0=av[4];
C_word t1=av[3];
C_word t2=av[2];
C_word t3=av[1];
C_word t4=av[0];
f_15988(t0,t1,t2,t3,t4);}

C_noret_decl(trf_16007)
static void C_ccall trf_16007(C_word c,C_word *av) C_noret;
static void C_ccall trf_16007(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_16007(t0,t1);}

C_noret_decl(trf_16019)
static void C_ccall trf_16019(C_word c,C_word *av) C_noret;
static void C_ccall trf_16019(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_16019(t0,t1);}

C_noret_decl(trf_16046)
static void C_ccall trf_16046(C_word c,C_word *av) C_noret;
static void C_ccall trf_16046(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_16046(t0,t1);}

C_noret_decl(trf_16202)
static void C_ccall trf_16202(C_word c,C_word *av) C_noret;
static void C_ccall trf_16202(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_16202(t0,t1,t2,t3);}

C_noret_decl(trf_16209)
static void C_ccall trf_16209(C_word c,C_word *av) C_noret;
static void C_ccall trf_16209(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_16209(t0,t1);}

C_noret_decl(trf_16280)
static void C_ccall trf_16280(C_word c,C_word *av) C_noret;
static void C_ccall trf_16280(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_16280(t0,t1);}

C_noret_decl(trf_16548)
static void C_ccall trf_16548(C_word c,C_word *av) C_noret;
static void C_ccall trf_16548(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_16548(t0,t1,t2);}

C_noret_decl(trf_16563)
static void C_ccall trf_16563(C_word c,C_word *av) C_noret;
static void C_ccall trf_16563(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_16563(t0,t1);}

C_noret_decl(trf_16621)
static void C_ccall trf_16621(C_word c,C_word *av) C_noret;
static void C_ccall trf_16621(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_16621(t0,t1);}

C_noret_decl(trf_17057)
static void C_ccall trf_17057(C_word c,C_word *av) C_noret;
static void C_ccall trf_17057(C_word c,C_word *av){
C_word t0=av[5];
C_word t1=av[4];
C_word t2=av[3];
C_word t3=av[2];
C_word t4=av[1];
C_word t5=av[0];
f_17057(t0,t1,t2,t3,t4,t5);}

C_noret_decl(trf_17342)
static void C_ccall trf_17342(C_word c,C_word *av) C_noret;
static void C_ccall trf_17342(C_word c,C_word *av){
C_word t0=av[4];
C_word t1=av[3];
C_word t2=av[2];
C_word t3=av[1];
C_word t4=av[0];
f_17342(t0,t1,t2,t3,t4);}

C_noret_decl(trf_17369)
static void C_ccall trf_17369(C_word c,C_word *av) C_noret;
static void C_ccall trf_17369(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_17369(t0,t1,t2);}

C_noret_decl(trf_17410)
static void C_ccall trf_17410(C_word c,C_word *av) C_noret;
static void C_ccall trf_17410(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_17410(t0,t1,t2,t3);}

C_noret_decl(trf_17647)
static void C_ccall trf_17647(C_word c,C_word *av) C_noret;
static void C_ccall trf_17647(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_17647(t0,t1,t2);}

C_noret_decl(trf_17909)
static void C_ccall trf_17909(C_word c,C_word *av) C_noret;
static void C_ccall trf_17909(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_17909(t0,t1,t2);}

C_noret_decl(trf_18128)
static void C_ccall trf_18128(C_word c,C_word *av) C_noret;
static void C_ccall trf_18128(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_18128(t0,t1,t2,t3);}

C_noret_decl(trf_18229)
static void C_ccall trf_18229(C_word c,C_word *av) C_noret;
static void C_ccall trf_18229(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_18229(t0,t1,t2);}

C_noret_decl(trf_18437)
static void C_ccall trf_18437(C_word c,C_word *av) C_noret;
static void C_ccall trf_18437(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_18437(t0,t1,t2);}

C_noret_decl(trf_18475)
static void C_ccall trf_18475(C_word c,C_word *av) C_noret;
static void C_ccall trf_18475(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_18475(t0,t1,t2);}

C_noret_decl(trf_18523)
static void C_ccall trf_18523(C_word c,C_word *av) C_noret;
static void C_ccall trf_18523(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_18523(t0,t1,t2);}

C_noret_decl(trf_18584)
static void C_ccall trf_18584(C_word c,C_word *av) C_noret;
static void C_ccall trf_18584(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_18584(t0,t1,t2);}

C_noret_decl(trf_18614)
static void C_ccall trf_18614(C_word c,C_word *av) C_noret;
static void C_ccall trf_18614(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_18614(t0,t1,t2);}

C_noret_decl(trf_18669)
static void C_ccall trf_18669(C_word c,C_word *av) C_noret;
static void C_ccall trf_18669(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_18669(t0,t1,t2);}

C_noret_decl(trf_18710)
static void C_ccall trf_18710(C_word c,C_word *av) C_noret;
static void C_ccall trf_18710(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_18710(t0,t1,t2);}

C_noret_decl(trf_18824)
static void C_ccall trf_18824(C_word c,C_word *av) C_noret;
static void C_ccall trf_18824(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_18824(t0,t1,t2);}

C_noret_decl(trf_19214)
static void C_ccall trf_19214(C_word c,C_word *av) C_noret;
static void C_ccall trf_19214(C_word c,C_word *av){
C_word t0=av[4];
C_word t1=av[3];
C_word t2=av[2];
C_word t3=av[1];
C_word t4=av[0];
f_19214(t0,t1,t2,t3,t4);}

C_noret_decl(trf_19257)
static void C_ccall trf_19257(C_word c,C_word *av) C_noret;
static void C_ccall trf_19257(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_19257(t0,t1,t2);}

C_noret_decl(trf_19312)
static void C_ccall trf_19312(C_word c,C_word *av) C_noret;
static void C_ccall trf_19312(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_19312(t0,t1,t2,t3);}

C_noret_decl(trf_19568)
static void C_ccall trf_19568(C_word c,C_word *av) C_noret;
static void C_ccall trf_19568(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_19568(t0,t1,t2);}

C_noret_decl(trf_19581)
static void C_ccall trf_19581(C_word c,C_word *av) C_noret;
static void C_ccall trf_19581(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_19581(t0,t1,t2);}

C_noret_decl(trf_19640)
static void C_ccall trf_19640(C_word c,C_word *av) C_noret;
static void C_ccall trf_19640(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_19640(t0,t1,t2);}

C_noret_decl(trf_19894)
static void C_ccall trf_19894(C_word c,C_word *av) C_noret;
static void C_ccall trf_19894(C_word c,C_word *av){
C_word t0=av[5];
C_word t1=av[4];
C_word t2=av[3];
C_word t3=av[2];
C_word t4=av[1];
C_word t5=av[0];
f_19894(t0,t1,t2,t3,t4,t5);}

C_noret_decl(trf_19898)
static void C_ccall trf_19898(C_word c,C_word *av) C_noret;
static void C_ccall trf_19898(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_19898(t0,t1);}

C_noret_decl(trf_19928)
static void C_ccall trf_19928(C_word c,C_word *av) C_noret;
static void C_ccall trf_19928(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_19928(t0,t1);}

C_noret_decl(trf_19948)
static void C_ccall trf_19948(C_word c,C_word *av) C_noret;
static void C_ccall trf_19948(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_19948(t0,t1,t2,t3);}

C_noret_decl(trf_19957)
static void C_ccall trf_19957(C_word c,C_word *av) C_noret;
static void C_ccall trf_19957(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_19957(t0,t1,t2);}

C_noret_decl(trf_19962)
static void C_ccall trf_19962(C_word c,C_word *av) C_noret;
static void C_ccall trf_19962(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_19962(t0,t1);}

C_noret_decl(trf_20327)
static void C_ccall trf_20327(C_word c,C_word *av) C_noret;
static void C_ccall trf_20327(C_word c,C_word *av){
C_word t0=av[4];
C_word t1=av[3];
C_word t2=av[2];
C_word t3=av[1];
C_word t4=av[0];
f_20327(t0,t1,t2,t3,t4);}

C_noret_decl(trf_20336)
static void C_ccall trf_20336(C_word c,C_word *av) C_noret;
static void C_ccall trf_20336(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_20336(t0,t1);}

C_noret_decl(trf_20346)
static void C_ccall trf_20346(C_word c,C_word *av) C_noret;
static void C_ccall trf_20346(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_20346(t0,t1,t2);}

C_noret_decl(trf_20373)
static void C_ccall trf_20373(C_word c,C_word *av) C_noret;
static void C_ccall trf_20373(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_20373(t0,t1,t2);}

C_noret_decl(trf_20382)
static void C_ccall trf_20382(C_word c,C_word *av) C_noret;
static void C_ccall trf_20382(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_20382(t0,t1,t2);}

C_noret_decl(trf_20397)
static void C_ccall trf_20397(C_word c,C_word *av) C_noret;
static void C_ccall trf_20397(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_20397(t0,t1);}

C_noret_decl(trf_20400)
static void C_ccall trf_20400(C_word c,C_word *av) C_noret;
static void C_ccall trf_20400(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_20400(t0,t1);}

C_noret_decl(trf_20410)
static void C_ccall trf_20410(C_word c,C_word *av) C_noret;
static void C_ccall trf_20410(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_20410(t0,t1,t2);}

C_noret_decl(trf_20448)
static void C_ccall trf_20448(C_word c,C_word *av) C_noret;
static void C_ccall trf_20448(C_word c,C_word *av){
C_word t0=av[4];
C_word t1=av[3];
C_word t2=av[2];
C_word t3=av[1];
C_word t4=av[0];
f_20448(t0,t1,t2,t3,t4);}

C_noret_decl(trf_20454)
static void C_ccall trf_20454(C_word c,C_word *av) C_noret;
static void C_ccall trf_20454(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_20454(t0,t1,t2,t3);}

C_noret_decl(trf_20508)
static void C_ccall trf_20508(C_word c,C_word *av) C_noret;
static void C_ccall trf_20508(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_20508(t0,t1,t2);}

C_noret_decl(trf_20520)
static void C_ccall trf_20520(C_word c,C_word *av) C_noret;
static void C_ccall trf_20520(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_20520(t0,t1,t2,t3);}

C_noret_decl(trf_20545)
static void C_ccall trf_20545(C_word c,C_word *av) C_noret;
static void C_ccall trf_20545(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_20545(t0,t1,t2);}

C_noret_decl(trf_20555)
static void C_ccall trf_20555(C_word c,C_word *av) C_noret;
static void C_ccall trf_20555(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_20555(t0,t1,t2,t3);}

C_noret_decl(trf_20736)
static void C_ccall trf_20736(C_word c,C_word *av) C_noret;
static void C_ccall trf_20736(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_20736(t0,t1);}

C_noret_decl(trf_20827)
static void C_ccall trf_20827(C_word c,C_word *av) C_noret;
static void C_ccall trf_20827(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_20827(t0,t1);}

C_noret_decl(trf_20847)
static void C_ccall trf_20847(C_word c,C_word *av) C_noret;
static void C_ccall trf_20847(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_20847(t0,t1);}

C_noret_decl(trf_20852)
static void C_ccall trf_20852(C_word c,C_word *av) C_noret;
static void C_ccall trf_20852(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_20852(t0,t1,t2,t3);}

C_noret_decl(trf_20951)
static void C_ccall trf_20951(C_word c,C_word *av) C_noret;
static void C_ccall trf_20951(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_20951(t0,t1);}

C_noret_decl(trf_21099)
static void C_ccall trf_21099(C_word c,C_word *av) C_noret;
static void C_ccall trf_21099(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_21099(t0,t1,t2,t3);}

C_noret_decl(trf_21108)
static void C_ccall trf_21108(C_word c,C_word *av) C_noret;
static void C_ccall trf_21108(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_21108(t0,t1,t2);}

C_noret_decl(trf_21163)
static void C_ccall trf_21163(C_word c,C_word *av) C_noret;
static void C_ccall trf_21163(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_21163(t0,t1,t2);}

C_noret_decl(trf_21170)
static void C_ccall trf_21170(C_word c,C_word *av) C_noret;
static void C_ccall trf_21170(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_21170(t0,t1);}

C_noret_decl(trf_21213)
static void C_ccall trf_21213(C_word c,C_word *av) C_noret;
static void C_ccall trf_21213(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_21213(t0,t1);}

C_noret_decl(trf_21361)
static void C_ccall trf_21361(C_word c,C_word *av) C_noret;
static void C_ccall trf_21361(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_21361(t0,t1);}

C_noret_decl(trf_21379)
static void C_ccall trf_21379(C_word c,C_word *av) C_noret;
static void C_ccall trf_21379(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_21379(t0,t1,t2,t3);}

C_noret_decl(trf_21449)
static void C_ccall trf_21449(C_word c,C_word *av) C_noret;
static void C_ccall trf_21449(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_21449(t0,t1,t2);}

C_noret_decl(trf_21500)
static void C_ccall trf_21500(C_word c,C_word *av) C_noret;
static void C_ccall trf_21500(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_21500(t0,t1,t2);}

C_noret_decl(trf_21567)
static void C_ccall trf_21567(C_word c,C_word *av) C_noret;
static void C_ccall trf_21567(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_21567(t0,t1);}

C_noret_decl(trf_21577)
static void C_ccall trf_21577(C_word c,C_word *av) C_noret;
static void C_ccall trf_21577(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_21577(t0,t1,t2,t3);}

C_noret_decl(trf_21587)
static void C_ccall trf_21587(C_word c,C_word *av) C_noret;
static void C_ccall trf_21587(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_21587(t0,t1);}

C_noret_decl(trf_21631)
static void C_ccall trf_21631(C_word c,C_word *av) C_noret;
static void C_ccall trf_21631(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_21631(t0,t1);}

C_noret_decl(trf_21641)
static void C_ccall trf_21641(C_word c,C_word *av) C_noret;
static void C_ccall trf_21641(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_21641(t0,t1,t2,t3);}

C_noret_decl(trf_21677)
static void C_ccall trf_21677(C_word c,C_word *av) C_noret;
static void C_ccall trf_21677(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_21677(t0,t1);}

C_noret_decl(trf_21702)
static void C_ccall trf_21702(C_word c,C_word *av) C_noret;
static void C_ccall trf_21702(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_21702(t0,t1,t2);}

C_noret_decl(trf_21708)
static void C_ccall trf_21708(C_word c,C_word *av) C_noret;
static void C_ccall trf_21708(C_word c,C_word *av){
C_word t0=av[5];
C_word t1=av[4];
C_word t2=av[3];
C_word t3=av[2];
C_word t4=av[1];
C_word t5=av[0];
f_21708(t0,t1,t2,t3,t4,t5);}

C_noret_decl(trf_21721)
static void C_ccall trf_21721(C_word c,C_word *av) C_noret;
static void C_ccall trf_21721(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_21721(t0,t1);}

C_noret_decl(trf_21727)
static void C_ccall trf_21727(C_word c,C_word *av) C_noret;
static void C_ccall trf_21727(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_21727(t0,t1);}

C_noret_decl(trf_21847)
static void C_ccall trf_21847(C_word c,C_word *av) C_noret;
static void C_ccall trf_21847(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_21847(t0,t1);}

C_noret_decl(trf_21927)
static void C_ccall trf_21927(C_word c,C_word *av) C_noret;
static void C_ccall trf_21927(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_21927(t0,t1);}

C_noret_decl(trf_21966)
static void C_ccall trf_21966(C_word c,C_word *av) C_noret;
static void C_ccall trf_21966(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_21966(t0,t1);}

C_noret_decl(trf_22111)
static void C_ccall trf_22111(C_word c,C_word *av) C_noret;
static void C_ccall trf_22111(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_22111(t0,t1);}

C_noret_decl(trf_22136)
static void C_ccall trf_22136(C_word c,C_word *av) C_noret;
static void C_ccall trf_22136(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_22136(t0,t1);}

C_noret_decl(trf_22142)
static void C_ccall trf_22142(C_word c,C_word *av) C_noret;
static void C_ccall trf_22142(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_22142(t0,t1,t2);}

C_noret_decl(trf_22223)
static void C_ccall trf_22223(C_word c,C_word *av) C_noret;
static void C_ccall trf_22223(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_22223(t0,t1);}

C_noret_decl(trf_22236)
static void C_ccall trf_22236(C_word c,C_word *av) C_noret;
static void C_ccall trf_22236(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_22236(t0,t1,t2);}

C_noret_decl(trf_22844)
static void C_ccall trf_22844(C_word c,C_word *av) C_noret;
static void C_ccall trf_22844(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_22844(t0,t1);}

C_noret_decl(trf_23393)
static void C_ccall trf_23393(C_word c,C_word *av) C_noret;
static void C_ccall trf_23393(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_23393(t0,t1,t2);}

C_noret_decl(trf_23439)
static void C_ccall trf_23439(C_word c,C_word *av) C_noret;
static void C_ccall trf_23439(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_23439(t0,t1,t2,t3);}

C_noret_decl(trf_23702)
static void C_ccall trf_23702(C_word c,C_word *av) C_noret;
static void C_ccall trf_23702(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_23702(t0,t1,t2);}

C_noret_decl(trf_23753)
static void C_ccall trf_23753(C_word c,C_word *av) C_noret;
static void C_ccall trf_23753(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_23753(t0,t1,t2);}

C_noret_decl(trf_23812)
static void C_ccall trf_23812(C_word c,C_word *av) C_noret;
static void C_ccall trf_23812(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_23812(t0,t1,t2,t3);}

C_noret_decl(trf_23884)
static void C_ccall trf_23884(C_word c,C_word *av) C_noret;
static void C_ccall trf_23884(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_23884(t0,t1,t2,t3);}

C_noret_decl(trf_23944)
static void C_ccall trf_23944(C_word c,C_word *av) C_noret;
static void C_ccall trf_23944(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_23944(t0,t1,t2,t3);}

C_noret_decl(trf_23968)
static void C_ccall trf_23968(C_word c,C_word *av) C_noret;
static void C_ccall trf_23968(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_23968(t0,t1,t2,t3);}

C_noret_decl(trf_23980)
static void C_ccall trf_23980(C_word c,C_word *av) C_noret;
static void C_ccall trf_23980(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_23980(t0,t1,t2);}

C_noret_decl(trf_24057)
static void C_ccall trf_24057(C_word c,C_word *av) C_noret;
static void C_ccall trf_24057(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_24057(t0,t1,t2);}

C_noret_decl(trf_24106)
static void C_ccall trf_24106(C_word c,C_word *av) C_noret;
static void C_ccall trf_24106(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_24106(t0,t1,t2);}

C_noret_decl(trf_24122)
static void C_ccall trf_24122(C_word c,C_word *av) C_noret;
static void C_ccall trf_24122(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_24122(t0,t1);}

C_noret_decl(trf_24141)
static void C_ccall trf_24141(C_word c,C_word *av) C_noret;
static void C_ccall trf_24141(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_24141(t0,t1);}

C_noret_decl(trf_24251)
static void C_ccall trf_24251(C_word c,C_word *av) C_noret;
static void C_ccall trf_24251(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_24251(t0,t1,t2);}

C_noret_decl(trf_24310)
static void C_ccall trf_24310(C_word c,C_word *av) C_noret;
static void C_ccall trf_24310(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_24310(t0,t1,t2);}

C_noret_decl(trf_24467)
static void C_ccall trf_24467(C_word c,C_word *av) C_noret;
static void C_ccall trf_24467(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_24467(t0,t1,t2,t3);}

C_noret_decl(trf_24646)
static void C_ccall trf_24646(C_word c,C_word *av) C_noret;
static void C_ccall trf_24646(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_24646(t0,t1,t2);}

C_noret_decl(trf_24718)
static void C_ccall trf_24718(C_word c,C_word *av) C_noret;
static void C_ccall trf_24718(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_24718(t0,t1,t2);}

C_noret_decl(trf_24857)
static void C_ccall trf_24857(C_word c,C_word *av) C_noret;
static void C_ccall trf_24857(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_24857(t0,t1,t2,t3);}

C_noret_decl(trf_25256)
static void C_ccall trf_25256(C_word c,C_word *av) C_noret;
static void C_ccall trf_25256(C_word c,C_word *av){
C_word t0=av[4];
C_word t1=av[3];
C_word t2=av[2];
C_word t3=av[1];
C_word t4=av[0];
f_25256(t0,t1,t2,t3,t4);}

C_noret_decl(trf_25276)
static void C_ccall trf_25276(C_word c,C_word *av) C_noret;
static void C_ccall trf_25276(C_word c,C_word *av){
C_word t0=av[6];
C_word t1=av[5];
C_word t2=av[4];
C_word t3=av[3];
C_word t4=av[2];
C_word t5=av[1];
C_word t6=av[0];
f_25276(t0,t1,t2,t3,t4,t5,t6);}

C_noret_decl(trf_25330)
static void C_ccall trf_25330(C_word c,C_word *av) C_noret;
static void C_ccall trf_25330(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_25330(t0,t1);}

C_noret_decl(trf_25527)
static void C_ccall trf_25527(C_word c,C_word *av) C_noret;
static void C_ccall trf_25527(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_25527(t0,t1,t2);}

C_noret_decl(trf_25542)
static void C_ccall trf_25542(C_word c,C_word *av) C_noret;
static void C_ccall trf_25542(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_25542(t0,t1,t2);}

C_noret_decl(trf_25645)
static void C_ccall trf_25645(C_word c,C_word *av) C_noret;
static void C_ccall trf_25645(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_25645(t0,t1,t2);}

C_noret_decl(trf_25664)
static void C_ccall trf_25664(C_word c,C_word *av) C_noret;
static void C_ccall trf_25664(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_25664(t0,t1);}

C_noret_decl(trf_25773)
static void C_ccall trf_25773(C_word c,C_word *av) C_noret;
static void C_ccall trf_25773(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_25773(t0,t1,t2);}

C_noret_decl(trf_25810)
static void C_ccall trf_25810(C_word c,C_word *av) C_noret;
static void C_ccall trf_25810(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_25810(t0,t1);}

C_noret_decl(trf_25844)
static void C_ccall trf_25844(C_word c,C_word *av) C_noret;
static void C_ccall trf_25844(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_25844(t0,t1,t2);}

C_noret_decl(trf_25980)
static void C_ccall trf_25980(C_word c,C_word *av) C_noret;
static void C_ccall trf_25980(C_word c,C_word *av){
C_word t0=av[0];
f_25980(t0);}

C_noret_decl(trf_26008)
static void C_ccall trf_26008(C_word c,C_word *av) C_noret;
static void C_ccall trf_26008(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_26008(t0,t1);}

C_noret_decl(trf_26032)
static void C_ccall trf_26032(C_word c,C_word *av) C_noret;
static void C_ccall trf_26032(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_26032(t0,t1,t2);}

C_noret_decl(trf_26127)
static void C_ccall trf_26127(C_word c,C_word *av) C_noret;
static void C_ccall trf_26127(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_26127(t0,t1,t2);}

C_noret_decl(trf_26175)
static void C_ccall trf_26175(C_word c,C_word *av) C_noret;
static void C_ccall trf_26175(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_26175(t0,t1);}

C_noret_decl(trf_26178)
static void C_ccall trf_26178(C_word c,C_word *av) C_noret;
static void C_ccall trf_26178(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_26178(t0,t1);}

C_noret_decl(trf_26198)
static void C_ccall trf_26198(C_word c,C_word *av) C_noret;
static void C_ccall trf_26198(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_26198(t0,t1);}

C_noret_decl(trf_26621)
static void C_ccall trf_26621(C_word c,C_word *av) C_noret;
static void C_ccall trf_26621(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_26621(t0,t1,t2,t3);}

C_noret_decl(trf_26627)
static void C_ccall trf_26627(C_word c,C_word *av) C_noret;
static void C_ccall trf_26627(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_26627(t0,t1,t2);}

C_noret_decl(trf_26643)
static void C_ccall trf_26643(C_word c,C_word *av) C_noret;
static void C_ccall trf_26643(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_26643(t0,t1);}

C_noret_decl(trf_26740)
static void C_ccall trf_26740(C_word c,C_word *av) C_noret;
static void C_ccall trf_26740(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_26740(t0,t1,t2);}

C_noret_decl(trf_26786)
static void C_ccall trf_26786(C_word c,C_word *av) C_noret;
static void C_ccall trf_26786(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_26786(t0,t1,t2);}

C_noret_decl(trf_26862)
static void C_ccall trf_26862(C_word c,C_word *av) C_noret;
static void C_ccall trf_26862(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_26862(t0,t1,t2);}

C_noret_decl(trf_26914)
static void C_ccall trf_26914(C_word c,C_word *av) C_noret;
static void C_ccall trf_26914(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_26914(t0,t1,t2);}

C_noret_decl(trf_26962)
static void C_ccall trf_26962(C_word c,C_word *av) C_noret;
static void C_ccall trf_26962(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_26962(t0,t1,t2);}

C_noret_decl(trf_26976)
static void C_ccall trf_26976(C_word c,C_word *av) C_noret;
static void C_ccall trf_26976(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_26976(t0,t1,t2);}

C_noret_decl(trf_27032)
static void C_ccall trf_27032(C_word c,C_word *av) C_noret;
static void C_ccall trf_27032(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_27032(t0,t1,t2);}

C_noret_decl(trf_27157)
static void C_ccall trf_27157(C_word c,C_word *av) C_noret;
static void C_ccall trf_27157(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_27157(t0,t1,t2);}

C_noret_decl(trf_27159)
static void C_ccall trf_27159(C_word c,C_word *av) C_noret;
static void C_ccall trf_27159(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_27159(t0,t1,t2);}

C_noret_decl(trf_27180)
static void C_ccall trf_27180(C_word c,C_word *av) C_noret;
static void C_ccall trf_27180(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_27180(t0,t1,t2);}

C_noret_decl(trf_27204)
static void C_ccall trf_27204(C_word c,C_word *av) C_noret;
static void C_ccall trf_27204(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_27204(t0,t1,t2,t3);}

C_noret_decl(trf_27258)
static void C_ccall trf_27258(C_word c,C_word *av) C_noret;
static void C_ccall trf_27258(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_27258(t0,t1,t2);}

C_noret_decl(trf_27353)
static void C_ccall trf_27353(C_word c,C_word *av) C_noret;
static void C_ccall trf_27353(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_27353(t0,t1,t2);}

C_noret_decl(trf_27358)
static void C_ccall trf_27358(C_word c,C_word *av) C_noret;
static void C_ccall trf_27358(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_27358(t0,t1);}

C_noret_decl(trf_28342)
static void C_ccall trf_28342(C_word c,C_word *av) C_noret;
static void C_ccall trf_28342(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_28342(t0,t1,t2);}

C_noret_decl(trf_28406)
static void C_ccall trf_28406(C_word c,C_word *av) C_noret;
static void C_ccall trf_28406(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_28406(t0,t1,t2);}

C_noret_decl(trf_28618)
static void C_ccall trf_28618(C_word c,C_word *av) C_noret;
static void C_ccall trf_28618(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_28618(t0,t1,t2);}

C_noret_decl(trf_28662)
static void C_ccall trf_28662(C_word c,C_word *av) C_noret;
static void C_ccall trf_28662(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_28662(t0,t1);}

C_noret_decl(trf_28675)
static void C_ccall trf_28675(C_word c,C_word *av) C_noret;
static void C_ccall trf_28675(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_28675(t0,t1,t2);}

C_noret_decl(trf_28709)
static void C_ccall trf_28709(C_word c,C_word *av) C_noret;
static void C_ccall trf_28709(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_28709(t0,t1,t2);}

C_noret_decl(trf_28724)
static void C_ccall trf_28724(C_word c,C_word *av) C_noret;
static void C_ccall trf_28724(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_28724(t0,t1);}

C_noret_decl(trf_28800)
static void C_ccall trf_28800(C_word c,C_word *av) C_noret;
static void C_ccall trf_28800(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_28800(t0,t1,t2);}

C_noret_decl(trf_28900)
static void C_ccall trf_28900(C_word c,C_word *av) C_noret;
static void C_ccall trf_28900(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_28900(t0,t1);}

C_noret_decl(trf_28919)
static void C_ccall trf_28919(C_word c,C_word *av) C_noret;
static void C_ccall trf_28919(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_28919(t0,t1,t2);}

C_noret_decl(trf_28960)
static void C_ccall trf_28960(C_word c,C_word *av) C_noret;
static void C_ccall trf_28960(C_word c,C_word *av){
C_word t0=av[4];
C_word t1=av[3];
C_word t2=av[2];
C_word t3=av[1];
C_word t4=av[0];
f_28960(t0,t1,t2,t3,t4);}

C_noret_decl(trf_29282)
static void C_ccall trf_29282(C_word c,C_word *av) C_noret;
static void C_ccall trf_29282(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_29282(t0,t1,t2);}

C_noret_decl(trf_29294)
static void C_ccall trf_29294(C_word c,C_word *av) C_noret;
static void C_ccall trf_29294(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_29294(t0,t1,t2);}

C_noret_decl(trf_29375)
static void C_ccall trf_29375(C_word c,C_word *av) C_noret;
static void C_ccall trf_29375(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_29375(t0,t1,t2,t3);}

C_noret_decl(trf_29560)
static void C_ccall trf_29560(C_word c,C_word *av) C_noret;
static void C_ccall trf_29560(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_29560(t0,t1,t2);}

C_noret_decl(trf_29688)
static void C_ccall trf_29688(C_word c,C_word *av) C_noret;
static void C_ccall trf_29688(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_29688(t0,t1);}

C_noret_decl(trf_30122)
static void C_ccall trf_30122(C_word c,C_word *av) C_noret;
static void C_ccall trf_30122(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_30122(t0,t1);}

C_noret_decl(trf_30134)
static void C_ccall trf_30134(C_word c,C_word *av) C_noret;
static void C_ccall trf_30134(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_30134(t0,t1,t2);}

C_noret_decl(trf_30193)
static void C_ccall trf_30193(C_word c,C_word *av) C_noret;
static void C_ccall trf_30193(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_30193(t0,t1);}

C_noret_decl(trf_30207)
static void C_ccall trf_30207(C_word c,C_word *av) C_noret;
static void C_ccall trf_30207(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_30207(t0,t1,t2);}

C_noret_decl(trf_30229)
static void C_ccall trf_30229(C_word c,C_word *av) C_noret;
static void C_ccall trf_30229(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_30229(t0,t1,t2);}

C_noret_decl(trf_30444)
static void C_ccall trf_30444(C_word c,C_word *av) C_noret;
static void C_ccall trf_30444(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_30444(t0,t1);}

C_noret_decl(trf_30467)
static void C_ccall trf_30467(C_word c,C_word *av) C_noret;
static void C_ccall trf_30467(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_30467(t0,t1);}

C_noret_decl(trf_30635)
static void C_ccall trf_30635(C_word c,C_word *av) C_noret;
static void C_ccall trf_30635(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_30635(t0,t1,t2,t3);}

C_noret_decl(trf_30752)
static void C_ccall trf_30752(C_word c,C_word *av) C_noret;
static void C_ccall trf_30752(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_30752(t0,t1);}

C_noret_decl(trf_30785)
static void C_ccall trf_30785(C_word c,C_word *av) C_noret;
static void C_ccall trf_30785(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_30785(t0,t1);}

C_noret_decl(trf_30788)
static void C_ccall trf_30788(C_word c,C_word *av) C_noret;
static void C_ccall trf_30788(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_30788(t0,t1);}

C_noret_decl(trf_30791)
static void C_ccall trf_30791(C_word c,C_word *av) C_noret;
static void C_ccall trf_30791(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_30791(t0,t1);}

C_noret_decl(trf_30794)
static void C_ccall trf_30794(C_word c,C_word *av) C_noret;
static void C_ccall trf_30794(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_30794(t0,t1);}

C_noret_decl(trf_30797)
static void C_ccall trf_30797(C_word c,C_word *av) C_noret;
static void C_ccall trf_30797(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_30797(t0,t1);}

C_noret_decl(trf_30830)
static void C_ccall trf_30830(C_word c,C_word *av) C_noret;
static void C_ccall trf_30830(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_30830(t0,t1,t2);}

C_noret_decl(trf_30866)
static void C_ccall trf_30866(C_word c,C_word *av) C_noret;
static void C_ccall trf_30866(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_30866(t0,t1,t2);}

C_noret_decl(trf_30897)
static void C_ccall trf_30897(C_word c,C_word *av) C_noret;
static void C_ccall trf_30897(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_30897(t0,t1,t2);}

C_noret_decl(trf_30940)
static void C_ccall trf_30940(C_word c,C_word *av) C_noret;
static void C_ccall trf_30940(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_30940(t0,t1,t2);}

C_noret_decl(trf_31278)
static void C_ccall trf_31278(C_word c,C_word *av) C_noret;
static void C_ccall trf_31278(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_31278(t0,t1,t2);}

C_noret_decl(trf_31297)
static void C_ccall trf_31297(C_word c,C_word *av) C_noret;
static void C_ccall trf_31297(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_31297(t0,t1);}

C_noret_decl(trf_31450)
static void C_ccall trf_31450(C_word c,C_word *av) C_noret;
static void C_ccall trf_31450(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_31450(t0,t1,t2);}

C_noret_decl(trf_31489)
static void C_ccall trf_31489(C_word c,C_word *av) C_noret;
static void C_ccall trf_31489(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_31489(t0,t1,t2);}

C_noret_decl(trf_31505)
static void C_ccall trf_31505(C_word c,C_word *av) C_noret;
static void C_ccall trf_31505(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_31505(t0,t1,t2);}

C_noret_decl(trf_31671)
static void C_ccall trf_31671(C_word c,C_word *av) C_noret;
static void C_ccall trf_31671(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_31671(t0,t1);}

C_noret_decl(trf_32185)
static void C_ccall trf_32185(C_word c,C_word *av) C_noret;
static void C_ccall trf_32185(C_word c,C_word *av){
C_word t0=av[4];
C_word t1=av[3];
C_word t2=av[2];
C_word t3=av[1];
C_word t4=av[0];
f_32185(t0,t1,t2,t3,t4);}

C_noret_decl(trf_32281)
static void C_ccall trf_32281(C_word c,C_word *av) C_noret;
static void C_ccall trf_32281(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_32281(t0,t1);}

C_noret_decl(trf_32294)
static void C_ccall trf_32294(C_word c,C_word *av) C_noret;
static void C_ccall trf_32294(C_word c,C_word *av){
C_word t0=av[6];
C_word t1=av[5];
C_word t2=av[4];
C_word t3=av[3];
C_word t4=av[2];
C_word t5=av[1];
C_word t6=av[0];
f_32294(t0,t1,t2,t3,t4,t5,t6);}

C_noret_decl(trf_8865)
static void C_ccall trf_8865(C_word c,C_word *av) C_noret;
static void C_ccall trf_8865(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_8865(t0,t1,t2,t3);}

C_noret_decl(trf_9335)
static void C_ccall trf_9335(C_word c,C_word *av) C_noret;
static void C_ccall trf_9335(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_9335(t0,t1,t2,t3);}

C_noret_decl(trf_9372)
static void C_ccall trf_9372(C_word c,C_word *av) C_noret;
static void C_ccall trf_9372(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_9372(t0,t1,t2);}

C_noret_decl(trf_9458)
static void C_ccall trf_9458(C_word c,C_word *av) C_noret;
static void C_ccall trf_9458(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_9458(t0,t1,t2);}

C_noret_decl(trf_9491)
static void C_ccall trf_9491(C_word c,C_word *av) C_noret;
static void C_ccall trf_9491(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_9491(t0,t1,t2);}

C_noret_decl(trf_9609)
static void C_ccall trf_9609(C_word c,C_word *av) C_noret;
static void C_ccall trf_9609(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_9609(t0,t1,t2);}

C_noret_decl(trf_9644)
static void C_ccall trf_9644(C_word c,C_word *av) C_noret;
static void C_ccall trf_9644(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_9644(t0,t1,t2);}

C_noret_decl(trf_9708)
static void C_ccall trf_9708(C_word c,C_word *av) C_noret;
static void C_ccall trf_9708(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_9708(t0,t1,t2);}

C_noret_decl(trf_9773)
static void C_ccall trf_9773(C_word c,C_word *av) C_noret;
static void C_ccall trf_9773(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_9773(t0,t1,t2);}

C_noret_decl(trf_9809)
static void C_ccall trf_9809(C_word c,C_word *av) C_noret;
static void C_ccall trf_9809(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_9809(t0,t1,t2);}

C_noret_decl(trf_9838)
static void C_ccall trf_9838(C_word c,C_word *av) C_noret;
static void C_ccall trf_9838(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_9838(t0,t1,t2,t3);}

C_noret_decl(trf_9885)
static void C_ccall trf_9885(C_word c,C_word *av) C_noret;
static void C_ccall trf_9885(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_9885(t0,t1,t2);}

C_noret_decl(trf_9939)
static void C_ccall trf_9939(C_word c,C_word *av) C_noret;
static void C_ccall trf_9939(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_9939(t0,t1,t2,t3);}

/* f34185 in chicken.base#emergency-exit in k8543 */
static void C_ccall f34185(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f34185,c,av);}
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_exit_runtime(C_fix(0));
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* f34740 in chicken.base#exit in k8543 */
static void C_ccall f34740(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f34740,c,av);}
/* library.scm:724: g673 */
t2=t1;{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=C_fix(0);
((C_proc)(void*)(*((C_word*)t2+1)))(3,av2);}}

/* f34949 in chicken.base#gensym in k8543 */
static void C_ccall f34949(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f34949,c,av);}
/* library.scm:2717: ##sys#string-append */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[415]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[415]+1);
av2[1]=((C_word*)t0)[2];
av2[2]=lf[641];
av2[3]=t1;
tp(4,av2);}}

/* f34953 in k17600 in chicken.base#gensym in k8543 */
static void C_ccall f34953(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f34953,c,av);}
/* library.scm:2717: ##sys#string-append */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[415]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[415]+1);
av2[1]=((C_word*)t0)[2];
av2[2]=((C_word*)t0)[3];
av2[3]=t1;
tp(4,av2);}}

/* f37044 in k31255 in k29399 in k29220 in k28583 in k28523 in k27154 in k27151 in k27148 in k26381 in k26069 in k26065 in k26061 in k24957 in k23793 in k23789 in k23785 in k20253 in k20249 in k20245 in k20241 in k20237 in ... */
static void C_ccall f37044(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f37044,c,av);}
t3=C_i_check_list_2(t2,lf[1366]);
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* f37050 in k31343 in k29220 in k28583 in k28523 in k27154 in k27151 in k27148 in k26381 in k26069 in k26065 in k26061 in k24957 in k23793 in k23789 in k23785 in k20253 in k20249 in k20245 in k20241 in k20237 in k19877 in ... */
static void C_ccall f37050(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f37050,c,av);}
t3=C_i_check_string_2(t2,lf[1368]);
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* f37056 in k31339 in k31343 in k29220 in k28583 in k28523 in k27154 in k27151 in k27148 in k26381 in k26069 in k26065 in k26061 in k24957 in k23793 in k23789 in k23785 in k20253 in k20249 in k20245 in k20241 in k20237 in ... */
static void C_ccall f37056(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f37056,c,av);}
t3=C_i_check_string_2(t2,lf[1368]);
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* chicken.base#alist-update! in k8543 */
static void C_ccall f_10010(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word *a;
if(c<5) C_bad_min_argc_2(c,5,t0);
if(C_unlikely(!C_demand(C_calculate_demand(10,c,4)))){
C_save_and_reclaim((void *)f_10010,c,av);}
a=C_alloc(10);
t5=C_rest_nullp(c,5);
t6=(C_truep(t5)?*((C_word*)lf[5]+1):C_get_rest_arg(c,5,av,5,t0));
t7=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_10017,a[2]=t3,a[3]=t1,a[4]=t4,a[5]=t2,tmp=(C_word)a,a+=6,tmp);
t8=C_eqp(*((C_word*)lf[4]+1),t6);
if(C_truep(t8)){
t9=t7;
f_10017(t9,*((C_word*)lf[52]+1));}
else{
t9=C_eqp(*((C_word*)lf[5]+1),t6);
if(C_truep(t9)){
t10=t7;
f_10017(t10,*((C_word*)lf[53]+1));}
else{
t10=C_eqp(*((C_word*)lf[6]+1),t6);
t11=t7;
f_10017(t11,(C_truep(t10)?*((C_word*)lf[54]+1):(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_10049,a[2]=t6,a[3]=((C_word)li187),tmp=(C_word)a,a+=4,tmp)));}}}

/* k10015 in chicken.base#alist-update! in k8543 */
static void C_fcall f_10017(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(6,0,3)))){
C_save_and_reclaim_args((void *)trf_10017,2,t0,t1);}
a=C_alloc(6);
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_10020,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],tmp=(C_word)a,a+=6,tmp);
/* library.scm:898: aq */
t3=t1;{
C_word av2[4];
av2[0]=t3;
av2[1]=t2;
av2[2]=((C_word*)t0)[5];
av2[3]=((C_word*)t0)[4];
((C_proc)(void*)(*((C_word*)t3+1)))(4,av2);}}

/* k10018 in k10015 in chicken.base#alist-update! in k8543 */
static void C_ccall f_10020(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(6,c,1)))){
C_save_and_reclaim((void *)f_10020,c,av);}
a=C_alloc(6);
if(C_truep(t1)){
t2=C_i_setslot(t1,C_fix(1),((C_word*)t0)[2]);
t3=((C_word*)t0)[3];{
C_word *av2=av;
av2[0]=t3;
av2[1]=((C_word*)t0)[4];
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
t2=C_a_i_cons(&a,2,((C_word*)t0)[5],((C_word*)t0)[2]);
t3=((C_word*)t0)[3];{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_a_i_cons(&a,2,t2,((C_word*)t0)[4]);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}}

/* f_10049 in chicken.base#alist-update! in k8543 */
static void C_ccall f_10049(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(8,c,3)))){
C_save_and_reclaim((void *)f_10049,c,av);}
a=C_alloc(8);
t4=C_SCHEME_UNDEFINED;
t5=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t6=C_set_block_item(t5,0,(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_10055,a[2]=t5,a[3]=((C_word*)t0)[2],a[4]=t2,a[5]=((C_word)li186),tmp=(C_word)a,a+=6,tmp));
t7=((C_word*)t5)[1];
f_10055(t7,t1,t3);}

/* loop */
static void C_fcall f_10055(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
loop:
if(C_unlikely(!C_demand(C_calculate_demand(6,0,3)))){
C_save_and_reclaim_args((void *)trf_10055,3,t0,t1,t2);}
a=C_alloc(6);
if(C_truep(C_i_pairp(t2))){
t3=C_slot(t2,C_fix(0));
t4=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_10071,a[2]=t1,a[3]=t3,a[4]=((C_word*)t0)[2],a[5]=t2,tmp=(C_word)a,a+=6,tmp);
if(C_truep(C_i_pairp(t3))){
/* library.scm:895: cmp */
t5=((C_word*)t0)[3];{
C_word av2[4];
av2[0]=t5;
av2[1]=t4;
av2[2]=((C_word*)t0)[4];
av2[3]=C_slot(t3,C_fix(0));
((C_proc)C_fast_retrieve_proc(t5))(4,av2);}}
else{
/* library.scm:897: loop */
t6=t1;
t7=C_slot(t2,C_fix(1));
t1=t6;
t2=t7;
goto loop;}}
else{
t3=t1;{
C_word av2[2];
av2[0]=t3;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}}

/* k10069 in loop */
static void C_ccall f_10071(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_10071,c,av);}
if(C_truep(t1)){
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}
else{
/* library.scm:897: loop */
t2=((C_word*)((C_word*)t0)[4])[1];
f_10055(t2,((C_word*)t0)[2],C_slot(((C_word*)t0)[5],C_fix(1)));}}

/* chicken.base#alist-update in k8543 */
static void C_ccall f_10096(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a;
if(c<5) C_bad_min_argc_2(c,5,t0);
if(C_unlikely(!C_demand(C_calculate_demand(9,c,3)))){
C_save_and_reclaim((void *)f_10096,c,av);}
a=C_alloc(9);
t5=C_rest_nullp(c,5);
t6=(C_truep(t5)?*((C_word*)lf[5]+1):C_get_rest_arg(c,5,av,5,t0));
t7=C_SCHEME_UNDEFINED;
t8=(*a=C_VECTOR_TYPE|1,a[1]=t7,tmp=(C_word)a,a+=2,tmp);
t9=C_set_block_item(t8,0,(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_10105,a[2]=t2,a[3]=t3,a[4]=t8,a[5]=t6,a[6]=((C_word)li189),tmp=(C_word)a,a+=7,tmp));
t10=((C_word*)t8)[1];
f_10105(t10,t1,t4);}

/* loop in chicken.base#alist-update in k8543 */
static void C_fcall f_10105(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(8,0,4)))){
C_save_and_reclaim_args((void *)trf_10105,3,t0,t1,t2);}
a=C_alloc(8);
if(C_truep(C_i_nullp(t2))){
t3=C_a_i_cons(&a,2,((C_word*)t0)[2],((C_word*)t0)[3]);
t4=t1;{
C_word av2[2];
av2[0]=t4;
av2[1]=C_a_i_list1(&a,1,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t3=C_i_pairp(t2);
if(C_truep(C_i_not(t3))){
/* library.scm:910: chicken.base#error */
t4=*((C_word*)lf[193]+1);{
C_word av2[5];
av2[0]=t4;
av2[1]=t1;
av2[2]=lf[263];
av2[3]=lf[264];
av2[4]=t2;
((C_proc)(void*)(*((C_word*)t4+1)))(5,av2);}}
else{
t4=C_slot(t2,C_fix(0));
t5=C_i_pairp(t4);
if(C_truep(C_i_not(t5))){
/* library.scm:914: chicken.base#error */
t6=*((C_word*)lf[193]+1);{
C_word av2[5];
av2[0]=t6;
av2[1]=t1;
av2[2]=lf[263];
av2[3]=lf[265];
av2[4]=t4;
((C_proc)(void*)(*((C_word*)t6+1)))(5,av2);}}
else{
t6=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_10146,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t2,a[5]=t1,a[6]=t4,a[7]=((C_word*)t0)[4],tmp=(C_word)a,a+=8,tmp);
/* library.scm:915: cmp */
t7=((C_word*)t0)[5];{
C_word av2[4];
av2[0]=t7;
av2[1]=t6;
av2[2]=((C_word*)t0)[2];
av2[3]=C_slot(t4,C_fix(0));
((C_proc)C_fast_retrieve_proc(t7))(4,av2);}}}}}

/* k10144 in loop in chicken.base#alist-update in k8543 */
static void C_ccall f_10146(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(7,c,2)))){
C_save_and_reclaim((void *)f_10146,c,av);}
a=C_alloc(7);
if(C_truep(t1)){
t2=C_a_i_cons(&a,2,((C_word*)t0)[2],((C_word*)t0)[3]);
t3=C_slot(((C_word*)t0)[4],C_fix(1));
t4=((C_word*)t0)[5];{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_a_i_cons(&a,2,t2,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t2=C_slot(((C_word*)t0)[6],C_fix(0));
t3=C_slot(((C_word*)t0)[6],C_fix(1));
t4=C_a_i_cons(&a,2,t2,t3);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_10168,a[2]=((C_word*)t0)[5],a[3]=t4,tmp=(C_word)a,a+=4,tmp);
/* library.scm:919: loop */
t6=((C_word*)((C_word*)t0)[7])[1];
f_10105(t6,t5,C_slot(((C_word*)t0)[4],C_fix(1)));}}

/* k10166 in k10144 in loop in chicken.base#alist-update in k8543 */
static void C_ccall f_10168(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,c,1)))){
C_save_and_reclaim((void *)f_10168,c,av);}
a=C_alloc(3);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_a_i_cons(&a,2,((C_word*)t0)[3],t1);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.base#alist-ref in k8543 */
static void C_ccall f_10200(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word *a;
if(c<4) C_bad_min_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(10,c,4)))){
C_save_and_reclaim((void *)f_10200,c,av);}
a=C_alloc(10);
t4=C_rest_nullp(c,4);
t5=(C_truep(t4)?*((C_word*)lf[5]+1):C_get_rest_arg(c,4,av,4,t0));
t6=C_rest_nullp(c,4);
t7=C_rest_nullp(c,5);
t8=(C_truep(t7)?C_SCHEME_FALSE:C_get_rest_arg(c,5,av,4,t0));
t9=C_rest_nullp(c,5);
t10=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_10216,a[2]=t1,a[3]=t8,a[4]=t2,a[5]=t3,tmp=(C_word)a,a+=6,tmp);
t11=C_eqp(*((C_word*)lf[4]+1),t5);
if(C_truep(t11)){
t12=t10;
f_10216(t12,*((C_word*)lf[52]+1));}
else{
t12=C_eqp(*((C_word*)lf[5]+1),t5);
if(C_truep(t12)){
t13=t10;
f_10216(t13,*((C_word*)lf[53]+1));}
else{
t13=C_eqp(*((C_word*)lf[6]+1),t5);
t14=t10;
f_10216(t14,(C_truep(t13)?*((C_word*)lf[54]+1):(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_10241,a[2]=t5,a[3]=((C_word)li192),tmp=(C_word)a,a+=4,tmp)));}}}

/* k10214 in chicken.base#alist-ref in k8543 */
static void C_fcall f_10216(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,0,3)))){
C_save_and_reclaim_args((void *)trf_10216,2,t0,t1);}
a=C_alloc(4);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_10219,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* library.scm:937: aq */
t3=t1;{
C_word av2[4];
av2[0]=t3;
av2[1]=t2;
av2[2]=((C_word*)t0)[4];
av2[3]=((C_word*)t0)[5];
((C_proc)(void*)(*((C_word*)t3+1)))(4,av2);}}

/* k10217 in k10214 in chicken.base#alist-ref in k8543 */
static void C_ccall f_10219(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_10219,c,av);}
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=(C_truep(t1)?C_slot(t1,C_fix(1)):((C_word*)t0)[3]);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* f_10241 in chicken.base#alist-ref in k8543 */
static void C_ccall f_10241(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(8,c,3)))){
C_save_and_reclaim((void *)f_10241,c,av);}
a=C_alloc(8);
t4=C_SCHEME_UNDEFINED;
t5=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t6=C_set_block_item(t5,0,(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_10247,a[2]=t5,a[3]=((C_word*)t0)[2],a[4]=t2,a[5]=((C_word)li191),tmp=(C_word)a,a+=6,tmp));
t7=((C_word*)t5)[1];
f_10247(t7,t1,t3);}

/* loop */
static void C_fcall f_10247(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(6,0,4)))){
C_save_and_reclaim_args((void *)trf_10247,3,t0,t1,t2);}
a=C_alloc(6);
if(C_truep(C_i_nullp(t2))){
t3=t1;{
C_word av2[2];
av2[0]=t3;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
if(C_truep(C_i_pairp(t2))){
t3=C_slot(t2,C_fix(0));
t4=C_i_check_pair_2(t3,lf[267]);
t5=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_10272,a[2]=t1,a[3]=t3,a[4]=((C_word*)t0)[2],a[5]=t2,tmp=(C_word)a,a+=6,tmp);
/* library.scm:933: cmp */
t6=((C_word*)t0)[3];{
C_word av2[4];
av2[0]=t6;
av2[1]=t5;
av2[2]=((C_word*)t0)[4];
av2[3]=C_slot(t3,C_fix(0));
((C_proc)C_fast_retrieve_proc(t6))(4,av2);}}
else{
/* library.scm:936: chicken.base#error */
t3=*((C_word*)lf[193]+1);{
C_word av2[5];
av2[0]=t3;
av2[1]=t1;
av2[2]=lf[267];
av2[3]=lf[268];
av2[4]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(5,av2);}}}}

/* k10270 in loop */
static void C_ccall f_10272(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_10272,c,av);}
if(C_truep(t1)){
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}
else{
/* library.scm:935: loop */
t2=((C_word*)((C_word*)t0)[4])[1];
f_10247(t2,((C_word*)t0)[2],C_slot(((C_word*)t0)[5],C_fix(1)));}}

/* chicken.base#rassoc in k8543 */
static void C_ccall f_10312(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c<4) C_bad_min_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-4)*C_SIZEOF_PAIR +8,c,3)))){
C_save_and_reclaim((void*)f_10312,c,av);}
a=C_alloc((c-4)*C_SIZEOF_PAIR+8);
t4=C_build_rest(&a,c,4,av);
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
t5=C_i_check_list_2(t3,lf[270]);
t6=C_i_pairp(t4);
t7=(C_truep(t6)?C_get_rest_arg(c,4,av,4,t0):*((C_word*)lf[5]+1));
t8=C_SCHEME_UNDEFINED;
t9=(*a=C_VECTOR_TYPE|1,a[1]=t8,tmp=(C_word)a,a+=2,tmp);
t10=C_set_block_item(t9,0,(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_10324,a[2]=t9,a[3]=t7,a[4]=t2,a[5]=((C_word)li194),tmp=(C_word)a,a+=6,tmp));
t11=((C_word*)t9)[1];
f_10324(t11,t1,t3);}

/* loop in chicken.base#rassoc in k8543 */
static void C_fcall f_10324(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(6,0,3)))){
C_save_and_reclaim_args((void *)trf_10324,3,t0,t1,t2);}
a=C_alloc(6);
if(C_truep(C_i_pairp(t2))){
t3=C_slot(t2,C_fix(0));
t4=C_i_check_pair_2(t3,lf[270]);
t5=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_10343,a[2]=t1,a[3]=t3,a[4]=((C_word*)t0)[2],a[5]=t2,tmp=(C_word)a,a+=6,tmp);
/* library.scm:950: tst */
t6=((C_word*)t0)[3];{
C_word av2[4];
av2[0]=t6;
av2[1]=t5;
av2[2]=((C_word*)t0)[4];
av2[3]=C_slot(t3,C_fix(1));
((C_proc)C_fast_retrieve_proc(t6))(4,av2);}}
else{
t3=t1;{
C_word av2[2];
av2[0]=t3;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}}

/* k10341 in loop in chicken.base#rassoc in k8543 */
static void C_ccall f_10343(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_10343,c,av);}
if(C_truep(t1)){
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}
else{
/* library.scm:952: loop */
t2=((C_word*)((C_word*)t0)[4])[1];
f_10324(t2,((C_word*)t0)[2],C_slot(((C_word*)t0)[5],C_fix(1)));}}

/* chicken.fixnum#fx+ in k8543 */
static void C_ccall f_10365(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_10365,c,av);}
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_fixnum_plus(t2,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* chicken.fixnum#fx- in k8543 */
static void C_ccall f_10368(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_10368,c,av);}
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_fixnum_difference(t2,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* chicken.fixnum#fx* in k8543 */
static void C_ccall f_10371(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_10371,c,av);}
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_fixnum_times(t2,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* chicken.fixnum#fx= in k8543 */
static void C_ccall f_10374(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_10374,c,av);}
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_eqp(t2,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* chicken.fixnum#fx> in k8543 */
static void C_ccall f_10380(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_10380,c,av);}
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_fixnum_greaterp(t2,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* chicken.fixnum#fx< in k8543 */
static void C_ccall f_10383(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_10383,c,av);}
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_fixnum_lessp(t2,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* chicken.fixnum#fx>= in k8543 */
static void C_ccall f_10386(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_10386,c,av);}
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_fixnum_greater_or_equal_p(t2,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* chicken.fixnum#fx<= in k8543 */
static void C_ccall f_10389(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_10389,c,av);}
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_fixnum_less_or_equal_p(t2,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* chicken.fixnum#fxmin in k8543 */
static void C_ccall f_10392(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_10392,c,av);}
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_i_fixnum_min(t2,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* chicken.fixnum#fxmax in k8543 */
static void C_ccall f_10395(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_10395,c,av);}
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_i_fixnum_max(t2,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* chicken.fixnum#fxneg in k8543 */
static void C_ccall f_10398(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_10398,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_fixnum_negate(t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* chicken.fixnum#fxand in k8543 */
static void C_ccall f_10401(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_10401,c,av);}
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_fixnum_and(t2,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* chicken.fixnum#fxior in k8543 */
static void C_ccall f_10404(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_10404,c,av);}
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_fixnum_or(t2,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* chicken.fixnum#fxxor in k8543 */
static void C_ccall f_10407(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_10407,c,av);}
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_fixnum_xor(t2,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* chicken.fixnum#fxnot in k8543 */
static void C_ccall f_10410(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_10410,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_fixnum_not(t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* chicken.fixnum#fxshl in k8543 */
static void C_ccall f_10413(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_10413,c,av);}
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_fixnum_shift_left(t2,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* chicken.fixnum#fxshr in k8543 */
static void C_ccall f_10416(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_10416,c,av);}
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_fixnum_shift_right(t2,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* chicken.fixnum#fxodd? in k8543 */
static void C_ccall f_10419(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_10419,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_i_fixnumoddp(t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* chicken.fixnum#fxeven? in k8543 */
static void C_ccall f_10422(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_10422,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_i_fixnumevenp(t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* chicken.fixnum#fxlen in k8543 */
static void C_ccall f_10425(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_10425,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_i_fixnum_length(t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* chicken.fixnum#fx/ in k8543 */
static void C_ccall f_10428(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_10428,c,av);}
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_fixnum_divide(t2,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* chicken.fixnum#fxgcd in k8543 */
static void C_ccall f_10431(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_10431,c,av);}
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_i_fixnum_gcd(t2,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* chicken.fixnum#fxmod in k8543 */
static void C_ccall f_10434(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_10434,c,av);}
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_fixnum_modulo(t2,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* chicken.fixnum#fxrem in k8543 */
static void C_ccall f_10437(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_10437,c,av);}
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_i_fixnum_remainder_checked(t2,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* chicken.fixnum#fx+? in k8543 */
static void C_ccall f_10440(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_10440,c,av);}
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_i_o_fixnum_plus(t2,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* chicken.fixnum#fx-? in k8543 */
static void C_ccall f_10443(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_10443,c,av);}
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_i_o_fixnum_difference(t2,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* chicken.fixnum#fx*? in k8543 */
static void C_ccall f_10446(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_10446,c,av);}
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_i_o_fixnum_times(t2,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* chicken.fixnum#fx/? in k8543 */
static void C_ccall f_10449(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_10449,c,av);}
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_i_o_fixnum_quotient(t2,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* ##sys#debug-mode? in k8543 */
static void C_ccall f_10452(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_10452,c,av);}
t2=t1;{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_i_debug_modep();
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.base#warning in k8543 */
static void C_ccall f_10457(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +0,c,5)))){
C_save_and_reclaim((void*)f_10457,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+0);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
if(C_truep(*((C_word*)lf[306]+1))){{
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=0;
av2[1]=t1;
av2[2]=C_fast_retrieve(lf[194]);
av2[3]=lf[309];
av2[4]=t2;
av2[5]=t3;
C_apply(6,av2);}}
else{
t4=C_SCHEME_UNDEFINED;
t5=t1;{
C_word *av2=av;
av2[0]=t5;
av2[1]=t4;
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}}

/* chicken.base#notice in k8543 */
static void C_ccall f_10466(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +0,c,5)))){
C_save_and_reclaim((void*)f_10466,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+0);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
C_word t6;
t4=(C_truep(*((C_word*)lf[307]+1))?*((C_word*)lf[306]+1):C_SCHEME_FALSE);
if(C_truep(t4)){{
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=0;
av2[1]=t1;
av2[2]=C_fast_retrieve(lf[194]);
av2[3]=lf[311];
av2[4]=t2;
av2[5]=t3;
C_apply(6,av2);}}
else{
t5=C_SCHEME_UNDEFINED;
t6=t1;{
C_word *av2=av;
av2[0]=t6;
av2[1]=t5;
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}}

/* chicken.base#enable-warnings in k8543 */
static void C_ccall f_10478(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand((c-2)*C_SIZEOF_PAIR +0,c,1)))){
C_save_and_reclaim((void*)f_10478,c,av);}
a=C_alloc((c-2)*C_SIZEOF_PAIR+0);
t2=C_build_rest(&a,c,2,av);
C_word t3;
C_word t4;
if(C_truep(C_i_pairp(t2))){
t3=C_mutate((C_word*)lf[306]+1 /* (set! ##sys#warnings-enabled ...) */,C_get_rest_arg(c,2,av,2,t0));
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=t3;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t3=*((C_word*)lf[306]+1);
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=*((C_word*)lf[306]+1);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}}

/* ##sys#setslot in k8543 */
static void C_ccall f_10493(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5;
C_word *a;
if(c!=5) C_bad_argc_2(c,5,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_10493,c,av);}
t5=t1;{
C_word *av2=av;
av2[0]=t5;
av2[1]=C_i_setslot(t2,t3,t4);
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}

/* ##sys#setislot in k8543 */
static void C_ccall f_10496(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5;
C_word *a;
if(c!=5) C_bad_argc_2(c,5,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_10496,c,av);}
t5=t1;{
C_word *av2=av;
av2[0]=t5;
av2[1]=C_i_set_i_slot(t2,t3,t4);
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}

/* ##sys#start-timer in k8543 */
static void C_ccall f_10504(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(3,c,2)))){
C_save_and_reclaim((void *)f_10504,c,av);}
a=C_alloc(3);
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_10508,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* library.scm:1051: ##sys#gc */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[315]+1));
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=*((C_word*)lf[315]+1);
av2[1]=t2;
av2[2]=C_SCHEME_TRUE;
tp(3,av2);}}

/* k10506 in ##sys#start-timer in k8543 */
static void C_ccall f_10508(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_10508,c,av);}
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_start_timer();
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* ##sys#stop-timer in k8543 */
static void C_ccall f_10510(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(6,c,2)))){
C_save_and_reclaim((void *)f_10510,c,av);}
a=C_alloc(6);
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)C_stop_timer,a[2]=((C_word)li237),tmp=(C_word)a,a+=3,tmp);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_10514,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* library.scm:1055: g1206 */
t4=t2;{
C_word *av2=av;
av2[0]=t4;
av2[1]=t3;
((C_proc)C_fast_retrieve_proc(t4))(2,av2);}}

/* k10512 in ##sys#stop-timer in k8543 */
static void C_ccall f_10514(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,2)))){
C_save_and_reclaim((void *)f_10514,c,av);}
a=C_alloc(4);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_10517,a[2]=t1,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
/* library.scm:1058: ##sys#gc */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[315]+1));
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=*((C_word*)lf[315]+1);
av2[1]=t2;
av2[2]=C_SCHEME_TRUE;
tp(3,av2);}}

/* k10515 in k10512 in ##sys#stop-timer in k8543 */
static void C_ccall f_10517(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(7,c,2)))){
C_save_and_reclaim((void *)f_10517,c,av);}
a=C_alloc(7);
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)C_stop_timer,a[2]=((C_word)li238),tmp=(C_word)a,a+=3,tmp);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_10528,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* library.scm:1059: g1208 */
t4=t2;{
C_word *av2=av;
av2[0]=t4;
av2[1]=t3;
((C_proc)C_fast_retrieve_proc(t4))(2,av2);}}

/* k10526 in k10515 in k10512 in ##sys#stop-timer in k8543 */
static void C_ccall f_10528(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_10528,c,av);}
t2=C_slot(t1,C_fix(6));
t3=C_i_setslot(((C_word*)t0)[2],C_fix(6),t2);
t4=((C_word*)t0)[3];{
C_word *av2=av;
av2[0]=t4;
av2[1]=((C_word*)t0)[2];
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* ##sys#immediate? in k8543 */
static void C_ccall f_10530(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_10530,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_i_not(C_blockp(t2));
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* ##sys#message in k8543 */
static void C_ccall f_10537(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_10537,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_message(t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* ##sys#byte in k8543 */
static void C_ccall f_10540(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_10540,c,av);}
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_subbyte(t2,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* ##sys#setbyte in k8543 */
static void C_ccall f_10543(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5;
C_word *a;
if(c!=5) C_bad_argc_2(c,5,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_10543,c,av);}
t5=t1;{
C_word *av2=av;
av2[0]=t5;
av2[1]=C_setbyte(t2,t3,t4);
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}

/* ##sys#halt in k8543 */
static void C_ccall f_10548(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_10548,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_halt(t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* ##sys#block-ref in k8543 */
static void C_ccall f_10552(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_10552,c,av);}
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_i_block_ref(t2,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* ##sys#block-set! in k8543 */
static void C_ccall f_10557(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(c!=5) C_bad_argc_2(c,5,t0);
if(C_unlikely(!C_demand(C_calculate_demand(6,c,5)))){
C_save_and_reclaim((void *)f_10557,c,av);}
a=C_alloc(6);
t5=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_10561,a[2]=t1,a[3]=t2,a[4]=t3,a[5]=t4,tmp=(C_word)a,a+=6,tmp);
t6=C_i_not(C_blockp(t2));
if(C_truep(t6)){
if(C_truep(t6)){
/* library.scm:1078: ##sys#signal-hook */
t7=C_fast_retrieve(lf[194]);{
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=t7;
av2[1]=t5;
av2[2]=lf[260];
av2[3]=lf[335];
av2[4]=lf[337];
av2[5]=t2;
((C_proc)(void*)(*((C_word*)t7+1)))(6,av2);}}
else{
t7=t5;{
C_word *av2=av;
av2[0]=t7;
av2[1]=C_SCHEME_UNDEFINED;
f_10561(2,av2);}}}
else{
t7=(C_truep(C_specialp(t2))?C_eqp(t3,C_fix(0)):C_SCHEME_FALSE);
if(C_truep(t7)){
if(C_truep(t7)){
/* library.scm:1078: ##sys#signal-hook */
t8=C_fast_retrieve(lf[194]);{
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=t8;
av2[1]=t5;
av2[2]=lf[260];
av2[3]=lf[335];
av2[4]=lf[337];
av2[5]=t2;
((C_proc)(void*)(*((C_word*)t8+1)))(6,av2);}}
else{
t8=t5;{
C_word *av2=av;
av2[0]=t8;
av2[1]=C_SCHEME_UNDEFINED;
f_10561(2,av2);}}}
else{
if(C_truep(C_byteblockp(t2))){
/* library.scm:1078: ##sys#signal-hook */
t8=C_fast_retrieve(lf[194]);{
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=t8;
av2[1]=t5;
av2[2]=lf[260];
av2[3]=lf[335];
av2[4]=lf[337];
av2[5]=t2;
((C_proc)(void*)(*((C_word*)t8+1)))(6,av2);}}
else{
t8=t5;{
C_word *av2=av;
av2[0]=t8;
av2[1]=C_SCHEME_UNDEFINED;
f_10561(2,av2);}}}}}

/* k10559 in ##sys#block-set! in k8543 */
static void C_ccall f_10561(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(6,c,5)))){
C_save_and_reclaim((void *)f_10561,c,av);}
a=C_alloc(6);
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_10564,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],tmp=(C_word)a,a+=6,tmp);
/* library.scm:1079: ##sys#check-range */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[336]+1));
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=*((C_word*)lf[336]+1);
av2[1]=t2;
av2[2]=((C_word*)t0)[4];
av2[3]=C_fix(0);
av2[4]=C_block_size(((C_word*)t0)[3]);
av2[5]=lf[335];
tp(6,av2);}}

/* k10562 in k10559 in ##sys#block-set! in k8543 */
static void C_ccall f_10564(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_10564,c,av);}
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_i_setslot(((C_word*)t0)[3],((C_word*)t0)[4],((C_word*)t0)[5]);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.time#current-milliseconds in k8543 */
static void C_ccall f_10592(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(7,c,1)))){
C_save_and_reclaim((void *)f_10592,c,av);}
a=C_alloc(7);
t2=t1;{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_a_i_current_milliseconds(&a,1,C_SCHEME_FALSE);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.time#current-seconds in k8543 */
static void C_ccall f_10595(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(7,c,1)))){
C_save_and_reclaim((void *)f_10595,c,av);}
a=C_alloc(7);
t2=t1;{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_a_get_current_seconds(&a,1,C_SCHEME_FALSE);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.time#cpu-time in k8543 */
static void C_ccall f_10598(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(11,c,3)))){
C_save_and_reclaim((void *)f_10598,c,av);}
a=C_alloc(11);
t2=C_a_i_vector2(&a,2,C_SCHEME_FALSE,C_SCHEME_FALSE);
t3=C_a_i_cpu_time(&a,1,t2);
/* library.scm:1106: scheme#values */{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=0;
av2[1]=t1;
av2[2]=C_slot(t2,C_fix(0));
av2[3]=C_slot(t2,C_fix(1));
C_values(4,av2);}}

/* ##sys#check-structure in k8543 */
static void C_ccall f_10615(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c<4) C_bad_min_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-4)*C_SIZEOF_PAIR +0,c,1)))){
C_save_and_reclaim((void*)f_10615,c,av);}
a=C_alloc((c-4)*C_SIZEOF_PAIR+0);
t4=C_build_rest(&a,c,4,av);
C_word t5;
C_word t6;
t5=C_i_pairp(t4);
t6=t1;{
C_word *av2=av;
av2[0]=t6;
av2[1]=(C_truep(t5)?C_i_check_structure_2(t2,t3,C_get_rest_arg(c,4,av,4,t0)):C_i_check_structure(t2,t3));
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}

/* ##sys#check-blob in k8543 */
static void C_ccall f_10626(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +0,c,1)))){
C_save_and_reclaim((void*)f_10626,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+0);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
t4=C_i_pairp(t3);
t5=t1;{
C_word *av2=av;
av2[0]=t5;
av2[1]=(C_truep(t4)?C_i_check_bytevector_2(t2,C_get_rest_arg(c,3,av,3,t0)):C_i_check_bytevector(t2));
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}

/* ##sys#check-pair in k8543 */
static void C_ccall f_10638(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +0,c,1)))){
C_save_and_reclaim((void*)f_10638,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+0);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
t4=C_i_pairp(t3);
t5=t1;{
C_word *av2=av;
av2[0]=t5;
av2[1]=(C_truep(t4)?C_i_check_pair_2(t2,C_get_rest_arg(c,3,av,3,t0)):C_i_check_pair(t2));
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}

/* ##sys#check-list in k8543 */
static void C_ccall f_10649(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +0,c,1)))){
C_save_and_reclaim((void*)f_10649,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+0);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
t4=C_i_pairp(t3);
t5=t1;{
C_word *av2=av;
av2[0]=t5;
av2[1]=(C_truep(t4)?C_i_check_list_2(t2,C_get_rest_arg(c,3,av,3,t0)):C_i_check_list(t2));
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}

/* ##sys#check-string in k8543 */
static void C_ccall f_10660(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +0,c,1)))){
C_save_and_reclaim((void*)f_10660,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+0);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
t4=C_i_pairp(t3);
t5=t1;{
C_word *av2=av;
av2[0]=t5;
av2[1]=(C_truep(t4)?C_i_check_string_2(t2,C_get_rest_arg(c,3,av,3,t0)):C_i_check_string(t2));
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}

/* ##sys#check-number in k8543 */
static void C_ccall f_10671(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +0,c,1)))){
C_save_and_reclaim((void*)f_10671,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+0);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
t4=C_i_pairp(t3);
t5=t1;{
C_word *av2=av;
av2[0]=t5;
av2[1]=(C_truep(t4)?C_i_check_number_2(t2,C_get_rest_arg(c,3,av,3,t0)):C_i_check_number(t2));
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}

/* ##sys#check-fixnum in k8543 */
static void C_ccall f_10682(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +0,c,1)))){
C_save_and_reclaim((void*)f_10682,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+0);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
t4=C_i_pairp(t3);
t5=t1;{
C_word *av2=av;
av2[0]=t5;
av2[1]=(C_truep(t4)?C_i_check_fixnum_2(t2,C_get_rest_arg(c,3,av,3,t0)):C_i_check_fixnum(t2));
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}

/* ##sys#check-exact in k8543 */
static void C_ccall f_10693(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +0,c,1)))){
C_save_and_reclaim((void*)f_10693,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+0);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
t4=C_i_pairp(t3);
t5=t1;{
C_word *av2=av;
av2[0]=t5;
av2[1]=(C_truep(t4)?C_i_check_exact_2(t2,C_get_rest_arg(c,3,av,3,t0)):C_i_check_exact(t2));
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}

/* ##sys#check-inexact in k8543 */
static void C_ccall f_10704(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +0,c,1)))){
C_save_and_reclaim((void*)f_10704,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+0);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
t4=C_i_pairp(t3);
t5=t1;{
C_word *av2=av;
av2[0]=t5;
av2[1]=(C_truep(t4)?C_i_check_inexact_2(t2,C_get_rest_arg(c,3,av,3,t0)):C_i_check_inexact(t2));
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}

/* ##sys#check-symbol in k8543 */
static void C_ccall f_10715(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +0,c,1)))){
C_save_and_reclaim((void*)f_10715,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+0);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
t4=C_i_pairp(t3);
t5=t1;{
C_word *av2=av;
av2[0]=t5;
av2[1]=(C_truep(t4)?C_i_check_symbol_2(t2,C_get_rest_arg(c,3,av,3,t0)):C_i_check_symbol(t2));
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}

/* ##sys#check-keyword in k8543 */
static void C_ccall f_10726(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +0,c,1)))){
C_save_and_reclaim((void*)f_10726,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+0);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
t4=C_i_pairp(t3);
t5=t1;{
C_word *av2=av;
av2[0]=t5;
av2[1]=(C_truep(t4)?C_i_check_keyword_2(t2,C_get_rest_arg(c,3,av,3,t0)):C_i_check_keyword(t2));
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}

/* ##sys#check-vector in k8543 */
static void C_ccall f_10737(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +0,c,1)))){
C_save_and_reclaim((void*)f_10737,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+0);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
t4=C_i_pairp(t3);
t5=t1;{
C_word *av2=av;
av2[0]=t5;
av2[1]=(C_truep(t4)?C_i_check_vector_2(t2,C_get_rest_arg(c,3,av,3,t0)):C_i_check_vector(t2));
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}

/* ##sys#check-char in k8543 */
static void C_ccall f_10748(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +0,c,1)))){
C_save_and_reclaim((void*)f_10748,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+0);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
t4=C_i_pairp(t3);
t5=t1;{
C_word *av2=av;
av2[0]=t5;
av2[1]=(C_truep(t4)?C_i_check_char_2(t2,C_get_rest_arg(c,3,av,3,t0)):C_i_check_char(t2));
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}

/* ##sys#check-boolean in k8543 */
static void C_ccall f_10759(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +0,c,1)))){
C_save_and_reclaim((void*)f_10759,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+0);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
t4=C_i_pairp(t3);
t5=t1;{
C_word *av2=av;
av2[0]=t5;
av2[1]=(C_truep(t4)?C_i_check_boolean_2(t2,C_get_rest_arg(c,3,av,3,t0)):C_i_check_boolean(t2));
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}

/* ##sys#check-locative in k8543 */
static void C_ccall f_10770(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +0,c,1)))){
C_save_and_reclaim((void*)f_10770,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+0);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
t4=C_i_pairp(t3);
t5=t1;{
C_word *av2=av;
av2[0]=t5;
av2[1]=(C_truep(t4)?C_i_check_locative_2(t2,C_get_rest_arg(c,3,av,3,t0)):C_i_check_locative(t2));
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}

/* ##sys#check-integer in k8543 */
static void C_ccall f_10781(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +0,c,3)))){
C_save_and_reclaim((void*)f_10781,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+0);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
if(C_truep(C_i_integerp(t2))){
t4=C_SCHEME_UNDEFINED;
t5=t1;{
C_word *av2=av;
av2[0]=t5;
av2[1]=t4;
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}
else{
if(C_truep(C_i_pairp(t3))){
/* library.scm:1189: ##sys#error-bad-integer */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[358]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[358]+1);
av2[1]=t1;
av2[2]=t2;
av2[3]=C_get_rest_arg(c,3,av,3,t0);
tp(4,av2);}}
else{
/* library.scm:1189: ##sys#error-bad-integer */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[358]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[358]+1);
av2[1]=t1;
av2[2]=t2;
av2[3]=C_SCHEME_FALSE;
tp(4,av2);}}}}

/* ##sys#check-exact-integer in k8543 */
static void C_ccall f_10798(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +0,c,3)))){
C_save_and_reclaim((void*)f_10798,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+0);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
if(C_truep(C_i_exact_integerp(t2))){
t4=C_SCHEME_UNDEFINED;
t5=t1;{
C_word *av2=av;
av2[0]=t5;
av2[1]=t4;
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}
else{
if(C_truep(C_i_pairp(t3))){
/* library.scm:1193: ##sys#error-bad-exact-integer */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[360]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[360]+1);
av2[1]=t1;
av2[2]=t2;
av2[3]=C_get_rest_arg(c,3,av,3,t0);
tp(4,av2);}}
else{
/* library.scm:1193: ##sys#error-bad-exact-integer */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[360]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[360]+1);
av2[1]=t1;
av2[2]=t2;
av2[3]=C_SCHEME_FALSE;
tp(4,av2);}}}}

/* ##sys#check-exact-uinteger in k8543 */
static void C_ccall f_10815(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +0,c,3)))){
C_save_and_reclaim((void*)f_10815,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+0);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
C_word t6;
C_word t7;
t4=C_i_not(C_i_exact_integerp(t2));
t5=(C_truep(t4)?t4:C_i_integer_negativep(t2));
if(C_truep(t5)){
if(C_truep(C_i_pairp(t3))){
/* library.scm:1198: ##sys#error-bad-exact-uinteger */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[362]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[362]+1);
av2[1]=t1;
av2[2]=t2;
av2[3]=C_get_rest_arg(c,3,av,3,t0);
tp(4,av2);}}
else{
/* library.scm:1198: ##sys#error-bad-exact-uinteger */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[362]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[362]+1);
av2[1]=t1;
av2[2]=t2;
av2[3]=C_SCHEME_FALSE;
tp(4,av2);}}}
else{
t6=C_SCHEME_UNDEFINED;
t7=t1;{
C_word *av2=av;
av2[0]=t7;
av2[1]=t6;
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}}

/* ##sys#check-real in k8543 */
static void C_ccall f_10839(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +0,c,3)))){
C_save_and_reclaim((void*)f_10839,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+0);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
if(C_truep(C_i_realp(t2))){
t4=C_SCHEME_UNDEFINED;
t5=t1;{
C_word *av2=av;
av2[0]=t5;
av2[1]=t4;
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}
else{
if(C_truep(C_i_pairp(t3))){
/* library.scm:1202: ##sys#error-bad-real */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[364]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[364]+1);
av2[1]=t1;
av2[2]=t2;
av2[3]=C_get_rest_arg(c,3,av,3,t0);
tp(4,av2);}}
else{
/* library.scm:1202: ##sys#error-bad-real */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[364]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[364]+1);
av2[1]=t1;
av2[2]=t2;
av2[3]=C_SCHEME_FALSE;
tp(4,av2);}}}}

/* ##sys#check-range in k8543 */
static void C_ccall f_10856(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5;
C_word *a;
if(c<5) C_bad_min_argc_2(c,5,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-5)*C_SIZEOF_PAIR +7,c,3)))){
C_save_and_reclaim((void*)f_10856,c,av);}
a=C_alloc((c-5)*C_SIZEOF_PAIR+7);
t5=C_build_rest(&a,c,5,av);
C_word t6;
C_word t7;
t6=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_10860,a[2]=t3,a[3]=t2,a[4]=t4,a[5]=t1,a[6]=t5,tmp=(C_word)a,a+=7,tmp);
/* library.scm:1205: ##sys#check-fixnum */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[102]+1));
C_word *av2=av;
av2[0]=*((C_word*)lf[102]+1);
av2[1]=t6;
av2[2]=t2;
av2[3]=t5;
tp(4,av2);}}

/* k10858 in ##sys#check-range in k8543 */
static void C_ccall f_10860(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,6)))){
C_save_and_reclaim((void *)f_10860,c,av);}
t2=C_fixnum_less_or_equal_p(((C_word*)t0)[2],((C_word*)t0)[3]);
t3=(C_truep(t2)?C_fixnum_lessp(((C_word*)t0)[3],((C_word*)t0)[4]):C_SCHEME_FALSE);
if(C_truep(t3)){
t4=C_SCHEME_UNDEFINED;
t5=((C_word*)t0)[5];{
C_word *av2=av;
av2[0]=t5;
av2[1]=t4;
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}
else{
t4=C_fix((C_word)C_OUT_OF_RANGE_ERROR);
if(C_truep(C_i_pairp(((C_word*)t0)[6]))){
/* library.scm:1207: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[365]);
C_word *av2;
if(c >= 7) {
  av2=av;
} else {
  av2=C_alloc(7);
}
av2[0]=*((C_word*)lf[365]+1);
av2[1]=((C_word*)t0)[5];
av2[2]=t4;
av2[3]=C_u_i_car(((C_word*)t0)[6]);
av2[4]=((C_word*)t0)[3];
av2[5]=((C_word*)t0)[2];
av2[6]=((C_word*)t0)[4];
tp(7,av2);}}
else{
/* library.scm:1207: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[365]);
C_word *av2;
if(c >= 7) {
  av2=av;
} else {
  av2=C_alloc(7);
}
av2[0]=*((C_word*)lf[365]+1);
av2[1]=((C_word*)t0)[5];
av2[2]=t4;
av2[3]=C_SCHEME_FALSE;
av2[4]=((C_word*)t0)[3];
av2[5]=((C_word*)t0)[2];
av2[6]=((C_word*)t0)[4];
tp(7,av2);}}}}

/* ##sys#check-special in k8543 */
static void C_ccall f_10886(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +0,c,5)))){
C_save_and_reclaim((void*)f_10886,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+0);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
C_word t6;
t4=(C_truep(C_blockp(t2))?C_specialp(t2):C_SCHEME_FALSE);
if(C_truep(t4)){
t5=C_SCHEME_UNDEFINED;
t6=t1;{
C_word *av2=av;
av2[0]=t6;
av2[1]=t5;
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}
else{
if(C_truep(C_i_pairp(t3))){
/* library.scm:1213: ##sys#signal-hook */
t5=C_fast_retrieve(lf[194]);{
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=t5;
av2[1]=t1;
av2[2]=lf[260];
av2[3]=C_get_rest_arg(c,3,av,3,t0);
av2[4]=lf[367];
av2[5]=t2;
((C_proc)(void*)(*((C_word*)t5+1)))(6,av2);}}
else{
/* library.scm:1213: ##sys#signal-hook */
t5=C_fast_retrieve(lf[194]);{
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=t5;
av2[1]=t1;
av2[2]=lf[260];
av2[3]=C_SCHEME_FALSE;
av2[4]=lf[367];
av2[5]=t2;
((C_proc)(void*)(*((C_word*)t5+1)))(6,av2);}}}}

/* ##sys#check-closure in k8543 */
static void C_ccall f_10906(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +0,c,1)))){
C_save_and_reclaim((void*)f_10906,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+0);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
t4=C_i_pairp(t3);
t5=t1;{
C_word *av2=av;
av2[0]=t5;
av2[1]=(C_truep(t4)?C_i_check_closure_2(t2,C_get_rest_arg(c,3,av,3,t0)):C_i_check_closure(t2));
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}

/* scheme#force in k8543 */
static void C_ccall f_10917(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(6,c,4)))){
C_save_and_reclaim((void *)f_10917,c,av);}
a=C_alloc(6);
if(C_truep(C_i_structurep(t2,lf[218]))){
t3=C_SCHEME_UNDEFINED;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_set_block_item(t4,0,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_10929,a[2]=t4,a[3]=((C_word)li275),tmp=(C_word)a,a+=4,tmp));
t6=((C_word*)t4)[1];
f_10929(t6,t1,t2,C_SCHEME_FALSE);}
else{
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}}

/* lp in scheme#force in k8543 */
static void C_fcall f_10929(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a;
loop:
if(C_unlikely(!C_demand(C_calculate_demand(6,0,3)))){
C_save_and_reclaim_args((void *)trf_10929,4,t0,t1,t2,t3);}
a=C_alloc(6);
t4=C_slot(t2,C_fix(1));
if(C_truep(C_i_nullp(t4))){
/* library.scm:1226: ##sys#values */{
C_word av2[2];
av2[0]=0;
av2[1]=t1;
C_values(2,av2);}}
else{
if(C_truep(C_i_pairp(t4))){{
C_word av2[3];
av2[0]=0;
av2[1]=t1;
av2[2]=t4;
C_apply_values(3,av2);}}
else{
if(C_truep(C_i_closurep(t4))){
t5=(C_truep(t3)?C_i_setslot(t3,C_fix(1),t2):C_SCHEME_UNDEFINED);
t6=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_10963,a[2]=t2,a[3]=((C_word*)t0)[2],a[4]=t1,a[5]=t3,tmp=(C_word)a,a+=6,tmp);
/* library.scm:1230: ##sys#call-with-values */{
C_word av2[4];
av2[0]=0;
av2[1]=t6;
av2[2]=t4;
av2[3]=*((C_word*)lf[370]+1);
C_call_with_values(4,av2);}}
else{
if(C_truep(C_i_structurep(t4,lf[218]))){
/* library.scm:1242: lp */
t8=t1;
t9=t4;
t10=t3;
t1=t8;
t2=t9;
t3=t10;
goto loop;}
else{
t5=t1;{
C_word av2[2];
av2[0]=t5;
av2[1]=C_SCHEME_UNDEFINED;
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}}}}}

/* k10961 in lp in scheme#force in k8543 */
static void C_ccall f_10963(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(6,c,3)))){
C_save_and_reclaim((void *)f_10963,c,av);}
a=C_alloc(6);
t2=C_slot(((C_word*)t0)[2],C_fix(1));
t3=C_i_closurep(t2);
if(C_truep(C_i_not(t3))){
/* library.scm:1232: lp */
t4=((C_word*)((C_word*)t0)[3])[1];
f_10929(t4,((C_word*)t0)[4],((C_word*)t0)[2],((C_word*)t0)[5]);}
else{
t4=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_10978,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
t5=C_i_nullp(t1);
if(C_truep(C_i_not(t5))){
t6=C_i_cdr(t1);
t7=C_i_nullp(t6);
t8=t4;
f_10978(t8,(C_truep(t7)?C_i_structurep(C_slot(t1,C_fix(0)),lf[218]):C_SCHEME_FALSE));}
else{
t6=t4;
f_10978(t6,C_SCHEME_FALSE);}}}

/* k10976 in k10961 in lp in scheme#force in k8543 */
static void C_fcall f_10978(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,0,3)))){
C_save_and_reclaim_args((void *)trf_10978,2,t0,t1);}
if(C_truep(t1)){
t2=C_slot(((C_word*)t0)[2],C_fix(0));
t3=C_slot(t2,C_fix(1));
t4=C_i_setslot(((C_word*)t0)[3],C_fix(1),t3);
/* library.scm:1237: lp */
t5=((C_word*)((C_word*)t0)[4])[1];
f_10929(t5,((C_word*)t0)[5],((C_word*)t0)[3],t2);}
else{
t2=C_i_setslot(((C_word*)t0)[3],C_fix(1),((C_word*)t0)[2]);{
C_word av2[3];
av2[0]=0;
av2[1]=((C_word*)t0)[5];
av2[2]=((C_word*)t0)[2];
C_apply_values(3,av2);}}}

/* ##sys#error-not-a-proper-list in k8543 */
static void C_ccall f_11045(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,4)))){
C_save_and_reclaim((void *)f_11045,c,av);}
if(C_truep(C_rest_nullp(c,3))){
t3=C_fix((C_word)C_NOT_A_PROPER_LIST_ERROR);
/* library.scm:1252: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[365]);
C_word av2[5];
av2[0]=*((C_word*)lf[365]+1);
av2[1]=t1;
av2[2]=t3;
av2[3]=C_SCHEME_FALSE;
av2[4]=t2;
tp(5,av2);}}
else{
t3=C_get_rest_arg(c,3,av,3,t0);
t4=C_fix((C_word)C_NOT_A_PROPER_LIST_ERROR);
/* library.scm:1252: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[365]);
C_word av2[5];
av2[0]=*((C_word*)lf[365]+1);
av2[1]=t1;
av2[2]=t4;
av2[3]=t3;
av2[4]=t2;
tp(5,av2);}}}

/* ##sys#error-bad-number in k8543 */
static void C_ccall f_11061(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,4)))){
C_save_and_reclaim((void *)f_11061,c,av);}
if(C_truep(C_rest_nullp(c,3))){
t3=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_NUMBER_ERROR);
/* library.scm:1256: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[365]);
C_word av2[5];
av2[0]=*((C_word*)lf[365]+1);
av2[1]=t1;
av2[2]=t3;
av2[3]=C_SCHEME_FALSE;
av2[4]=t2;
tp(5,av2);}}
else{
t3=C_get_rest_arg(c,3,av,3,t0);
t4=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_NUMBER_ERROR);
/* library.scm:1256: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[365]);
C_word av2[5];
av2[0]=*((C_word*)lf[365]+1);
av2[1]=t1;
av2[2]=t4;
av2[3]=t3;
av2[4]=t2;
tp(5,av2);}}}

/* ##sys#error-bad-integer in k8543 */
static void C_ccall f_11077(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,4)))){
C_save_and_reclaim((void *)f_11077,c,av);}
if(C_truep(C_rest_nullp(c,3))){
t3=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_INTEGER_ERROR);
/* library.scm:1260: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[365]);
C_word av2[5];
av2[0]=*((C_word*)lf[365]+1);
av2[1]=t1;
av2[2]=t3;
av2[3]=C_SCHEME_FALSE;
av2[4]=t2;
tp(5,av2);}}
else{
t3=C_get_rest_arg(c,3,av,3,t0);
t4=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_INTEGER_ERROR);
/* library.scm:1260: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[365]);
C_word av2[5];
av2[0]=*((C_word*)lf[365]+1);
av2[1]=t1;
av2[2]=t4;
av2[3]=t3;
av2[4]=t2;
tp(5,av2);}}}

/* ##sys#error-bad-exact-integer in k8543 */
static void C_ccall f_11093(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,4)))){
C_save_and_reclaim((void *)f_11093,c,av);}
if(C_truep(C_rest_nullp(c,3))){
t3=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_INTEGER_ERROR);
/* library.scm:1264: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[365]);
C_word av2[5];
av2[0]=*((C_word*)lf[365]+1);
av2[1]=t1;
av2[2]=t3;
av2[3]=C_SCHEME_FALSE;
av2[4]=t2;
tp(5,av2);}}
else{
t3=C_get_rest_arg(c,3,av,3,t0);
t4=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_INTEGER_ERROR);
/* library.scm:1264: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[365]);
C_word av2[5];
av2[0]=*((C_word*)lf[365]+1);
av2[1]=t1;
av2[2]=t4;
av2[3]=t3;
av2[4]=t2;
tp(5,av2);}}}

/* ##sys#error-bad-exact-uinteger in k8543 */
static void C_ccall f_11109(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,4)))){
C_save_and_reclaim((void *)f_11109,c,av);}
if(C_truep(C_rest_nullp(c,3))){
t3=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_UINTEGER_ERROR);
/* library.scm:1268: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[365]);
C_word av2[5];
av2[0]=*((C_word*)lf[365]+1);
av2[1]=t1;
av2[2]=t3;
av2[3]=C_SCHEME_FALSE;
av2[4]=t2;
tp(5,av2);}}
else{
t3=C_get_rest_arg(c,3,av,3,t0);
t4=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_UINTEGER_ERROR);
/* library.scm:1268: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[365]);
C_word av2[5];
av2[0]=*((C_word*)lf[365]+1);
av2[1]=t1;
av2[2]=t4;
av2[3]=t3;
av2[4]=t2;
tp(5,av2);}}}

/* ##sys#error-bad-inexact in k8543 */
static void C_ccall f_11125(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,4)))){
C_save_and_reclaim((void *)f_11125,c,av);}
if(C_truep(C_rest_nullp(c,3))){
t3=C_fix((C_word)C_CANT_REPRESENT_INEXACT_ERROR);
/* library.scm:1272: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[365]);
C_word av2[5];
av2[0]=*((C_word*)lf[365]+1);
av2[1]=t1;
av2[2]=t3;
av2[3]=C_SCHEME_FALSE;
av2[4]=t2;
tp(5,av2);}}
else{
t3=C_get_rest_arg(c,3,av,3,t0);
t4=C_fix((C_word)C_CANT_REPRESENT_INEXACT_ERROR);
/* library.scm:1272: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[365]);
C_word av2[5];
av2[0]=*((C_word*)lf[365]+1);
av2[1]=t1;
av2[2]=t4;
av2[3]=t3;
av2[4]=t2;
tp(5,av2);}}}

/* ##sys#error-bad-real in k8543 */
static void C_ccall f_11141(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,4)))){
C_save_and_reclaim((void *)f_11141,c,av);}
if(C_truep(C_rest_nullp(c,3))){
t3=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_REAL_ERROR);
/* library.scm:1276: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[365]);
C_word av2[5];
av2[0]=*((C_word*)lf[365]+1);
av2[1]=t1;
av2[2]=t3;
av2[3]=C_SCHEME_FALSE;
av2[4]=t2;
tp(5,av2);}}
else{
t3=C_get_rest_arg(c,3,av,3,t0);
t4=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_REAL_ERROR);
/* library.scm:1276: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[365]);
C_word av2[5];
av2[0]=*((C_word*)lf[365]+1);
av2[1]=t1;
av2[2]=t4;
av2[3]=t3;
av2[4]=t2;
tp(5,av2);}}}

/* ##sys#error-bad-base in k8543 */
static void C_ccall f_11157(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,4)))){
C_save_and_reclaim((void *)f_11157,c,av);}
if(C_truep(C_rest_nullp(c,3))){
t3=C_fix((C_word)C_BAD_ARGUMENT_TYPE_BAD_BASE_ERROR);
/* library.scm:1280: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[365]);
C_word av2[5];
av2[0]=*((C_word*)lf[365]+1);
av2[1]=t1;
av2[2]=t3;
av2[3]=C_SCHEME_FALSE;
av2[4]=t2;
tp(5,av2);}}
else{
t3=C_get_rest_arg(c,3,av,3,t0);
t4=C_fix((C_word)C_BAD_ARGUMENT_TYPE_BAD_BASE_ERROR);
/* library.scm:1280: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[365]);
C_word av2[5];
av2[0]=*((C_word*)lf[365]+1);
av2[1]=t1;
av2[2]=t4;
av2[3]=t3;
av2[4]=t2;
tp(5,av2);}}}

/* scheme#append in k8543 */
static void C_ccall f_11173(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand((c-2)*C_SIZEOF_PAIR +6,c,3)))){
C_save_and_reclaim((void*)f_11173,c,av);}
a=C_alloc((c-2)*C_SIZEOF_PAIR+6);
t2=C_build_rest(&a,c,2,av);
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
t3=C_eqp(t2,C_SCHEME_END_OF_LIST);
if(C_truep(t3)){
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t4=C_SCHEME_UNDEFINED;
t5=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t6=C_set_block_item(t5,0,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_11185,a[2]=t5,a[3]=((C_word)li288),tmp=(C_word)a,a+=4,tmp));
t7=((C_word*)t5)[1];
f_11185(t7,t1,t2);}}

/* loop in scheme#append in k8543 */
static void C_fcall f_11185(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(8,0,3)))){
C_save_and_reclaim_args((void *)trf_11185,3,t0,t1,t2);}
a=C_alloc(8);
t3=C_slot(t2,C_fix(1));
t4=C_eqp(t3,C_SCHEME_END_OF_LIST);
if(C_truep(t4)){
t5=t1;{
C_word av2[2];
av2[0]=t5;
av2[1]=C_slot(t2,C_fix(0));
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}
else{
t5=C_slot(t2,C_fix(0));
t6=C_SCHEME_UNDEFINED;
t7=(*a=C_VECTOR_TYPE|1,a[1]=t6,tmp=(C_word)a,a+=2,tmp);
t8=C_set_block_item(t7,0,(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_11204,a[2]=((C_word*)t0)[2],a[3]=t2,a[4]=t7,a[5]=((C_word)li287),tmp=(C_word)a,a+=6,tmp));
t9=((C_word*)t7)[1];
f_11204(t9,t1,t5);}}

/* copy in loop in scheme#append in k8543 */
static void C_fcall f_11204(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
loop:
if(C_unlikely(!C_demand(C_calculate_demand(4,0,3)))){
C_save_and_reclaim_args((void *)trf_11204,3,t0,t1,t2);}
a=C_alloc(4);
t3=C_eqp(t2,C_SCHEME_END_OF_LIST);
if(C_truep(t3)){
/* library.scm:1291: loop */
t4=((C_word*)((C_word*)t0)[2])[1];
f_11185(t4,t1,C_slot(((C_word*)t0)[3],C_fix(1)));}
else{
if(C_truep(C_i_pairp(t2))){
t4=C_slot(t2,C_fix(0));
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_11235,a[2]=t1,a[3]=t4,tmp=(C_word)a,a+=4,tmp);
/* library.scm:1293: copy */
t7=t5;
t8=C_slot(t2,C_fix(1));
t1=t7;
t2=t8;
goto loop;}
else{
/* library.scm:1295: ##sys#error-not-a-proper-list */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[47]+1));
C_word av2[4];
av2[0]=*((C_word*)lf[47]+1);
av2[1]=t1;
av2[2]=C_slot(((C_word*)t0)[3],C_fix(0));
av2[3]=lf[377];
tp(4,av2);}}}}

/* k11233 in copy in loop in scheme#append in k8543 */
static void C_ccall f_11235(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,c,1)))){
C_save_and_reclaim((void *)f_11235,c,av);}
a=C_alloc(3);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_a_i_cons(&a,2,((C_word*)t0)[3],t1);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* ##sys#fast-reverse in k8543 */
static void C_ccall f_11252(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(6,c,4)))){
C_save_and_reclaim((void *)f_11252,c,av);}
a=C_alloc(6);
t3=C_SCHEME_UNDEFINED;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_set_block_item(t4,0,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_11258,a[2]=t4,a[3]=((C_word)li290),tmp=(C_word)a,a+=4,tmp));
t6=((C_word*)t4)[1];
f_11258(t6,t1,t2,C_SCHEME_END_OF_LIST);}

/* loop in ##sys#fast-reverse in k8543 */
static void C_fcall f_11258(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a;
loop:
if(C_unlikely(!C_demand(C_calculate_demand(3,0,3)))){
C_save_and_reclaim_args((void *)trf_11258,4,t0,t1,t2,t3);}
a=C_alloc(3);
if(C_truep(C_i_pairp(t2))){
t4=C_slot(t2,C_fix(1));
t5=C_slot(t2,C_fix(0));
t6=C_a_i_cons(&a,2,t5,t3);
/* library.scm:1301: loop */
t8=t1;
t9=t4;
t10=t6;
t1=t8;
t2=t9;
t3=t10;
goto loop;}
else{
t4=t1;{
C_word av2[2];
av2[0]=t4;
av2[1]=t3;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}}

/* ##sys#make-string in k8543 */
static void C_ccall f_11282(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,5)))){
C_save_and_reclaim((void *)f_11282,c,av);}
if(C_truep(C_rest_nullp(c,3))){
/* library.scm:1308: ##sys#allocate-vector */
t3=*((C_word*)lf[318]+1);{
C_word av2[6];
av2[0]=t3;
av2[1]=t1;
av2[2]=t2;
av2[3]=C_SCHEME_TRUE;
av2[4]=C_make_character(32);
av2[5]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t3+1)))(6,av2);}}
else{
/* library.scm:1308: ##sys#allocate-vector */
t3=*((C_word*)lf[318]+1);{
C_word av2[6];
av2[0]=t3;
av2[1]=t1;
av2[2]=t2;
av2[3]=C_SCHEME_TRUE;
av2[4]=C_get_rest_arg(c,3,av,3,t0);
av2[5]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t3+1)))(6,av2);}}}

/* scheme#make-string in k8543 */
static void C_ccall f_11302(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +5,c,3)))){
C_save_and_reclaim((void*)f_11302,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+5);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_11306,a[2]=t3,a[3]=t1,a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* library.scm:1315: ##sys#check-fixnum */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[102]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[102]+1);
av2[1]=t4;
av2[2]=t2;
av2[3]=lf[381];
tp(4,av2);}}

/* k11304 in scheme#make-string in k8543 */
static void C_ccall f_11306(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,c,5)))){
C_save_and_reclaim((void *)f_11306,c,av);}
a=C_alloc(5);
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_11309,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
if(C_truep(C_fixnum_lessp(((C_word*)t0)[4],C_fix(0)))){
/* library.scm:1317: ##sys#signal-hook */
t3=C_fast_retrieve(lf[194]);{
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=lf[382];
av2[3]=lf[381];
av2[4]=lf[383];
av2[5]=((C_word*)t0)[4];
((C_proc)(void*)(*((C_word*)t3+1)))(6,av2);}}
else{
t3=t2;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_SCHEME_UNDEFINED;
f_11309(2,av2);}}}

/* k11307 in k11304 in scheme#make-string in k8543 */
static void C_ccall f_11309(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,5)))){
C_save_and_reclaim((void *)f_11309,c,av);}
if(C_truep(C_i_nullp(((C_word*)t0)[2]))){
/* library.scm:1308: ##sys#allocate-vector */
t2=*((C_word*)lf[318]+1);{
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[3];
av2[2]=((C_word*)t0)[4];
av2[3]=C_SCHEME_TRUE;
av2[4]=C_make_character(32);
av2[5]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t2+1)))(6,av2);}}
else{
t2=C_i_car(((C_word*)t0)[2]);
t3=C_i_check_char_2(t2,lf[381]);
/* library.scm:1308: ##sys#allocate-vector */
t4=*((C_word*)lf[318]+1);{
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=t4;
av2[1]=((C_word*)t0)[3];
av2[2]=((C_word*)t0)[4];
av2[3]=C_SCHEME_TRUE;
av2[4]=t2;
av2[5]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t4+1)))(6,av2);}}}

/* scheme#string->list in k8543 */
static void C_ccall f_11338(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(7,c,4)))){
C_save_and_reclaim((void *)f_11338,c,av);}
a=C_alloc(7);
t3=C_i_check_string_2(t2,lf[385]);
t4=C_block_size(t2);
t5=C_fixnum_difference(t4,C_fix(1));
t6=C_SCHEME_UNDEFINED;
t7=(*a=C_VECTOR_TYPE|1,a[1]=t6,tmp=(C_word)a,a+=2,tmp);
t8=C_set_block_item(t7,0,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_11354,a[2]=t2,a[3]=t7,a[4]=((C_word)li294),tmp=(C_word)a,a+=5,tmp));
t9=((C_word*)t7)[1];
f_11354(t9,t1,t5,C_SCHEME_END_OF_LIST);}

/* loop in scheme#string->list in k8543 */
static void C_fcall f_11354(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a;
loop:
if(C_unlikely(!C_demand(C_calculate_demand(3,0,3)))){
C_save_and_reclaim_args((void *)trf_11354,4,t0,t1,t2,t3);}
a=C_alloc(3);
if(C_truep(C_fixnum_lessp(t2,C_fix(0)))){
t4=t1;{
C_word av2[2];
av2[0]=t4;
av2[1]=t3;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t4=C_fixnum_difference(t2,C_fix(1));
t5=C_subchar(((C_word*)t0)[2],t2);
t6=C_a_i_cons(&a,2,t5,t3);
/* library.scm:1333: loop */
t8=t1;
t9=t4;
t10=t6;
t1=t8;
t2=t9;
t3=t10;
goto loop;}}

/* scheme#list->string in k8543 */
static void C_ccall f_11376(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(5,c,3)))){
C_save_and_reclaim((void *)f_11376,c,av);}
a=C_alloc(5);
t3=C_i_listp(t2);
if(C_truep(C_i_not(t3))){
/* library.scm:1341: ##sys#error-not-a-proper-list */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[47]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[47]+1);
av2[1]=t1;
av2[2]=t2;
av2[3]=lf[388];
tp(4,av2);}}
else{
t4=C_i_length(t2);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_11392,a[2]=t4,a[3]=t1,a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* library.scm:1343: ##sys#make-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[379]+1));
C_word *av2=av;
av2[0]=*((C_word*)lf[379]+1);
av2[1]=t5;
av2[2]=t4;
tp(3,av2);}}}

/* k11390 in scheme#list->string in k8543 */
static void C_ccall f_11392(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,c,3)))){
C_save_and_reclaim((void *)f_11392,c,av);}
a=C_alloc(5);
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_11397,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=((C_word)li296),tmp=(C_word)a,a+=5,tmp);
t3=((C_word*)t0)[3];{
C_word *av2=av;
av2[0]=t3;
av2[1]=(
  f_11397(t2,C_fix(0),((C_word*)t0)[4])
);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* doloop1526 in k11390 in scheme#list->string in k8543 */
static C_word C_fcall f_11397(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_stack_overflow_check;
loop:{}
if(C_truep(C_fixnum_greater_or_equal_p(t1,((C_word*)t0)[2]))){
return(((C_word*)t0)[3]);}
else{
t3=C_slot(t2,C_fix(0));
t4=C_i_check_char_2(t3,lf[388]);
t5=C_setsubchar(((C_word*)t0)[3],t1,t3);
t7=C_fixnum_plus(t1,C_fix(1));
t8=C_slot(t2,C_fix(1));
t1=t7;
t2=t8;
goto loop;}}

/* ##sys#reverse-list->string in k8543 */
static void C_ccall f_11428(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(5,c,3)))){
C_save_and_reclaim((void *)f_11428,c,av);}
a=C_alloc(5);
if(C_truep(C_i_listp(t2))){
t3=C_u_i_length(t2);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_11439,a[2]=t3,a[3]=t2,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
/* library.scm:1358: ##sys#make-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[379]+1));
C_word *av2=av;
av2[0]=*((C_word*)lf[379]+1);
av2[1]=t4;
av2[2]=t3;
tp(3,av2);}}
else{
/* library.scm:1366: ##sys#error-not-a-proper-list */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[47]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[47]+1);
av2[1]=t1;
av2[2]=t2;
av2[3]=lf[391];
tp(4,av2);}}}

/* k11437 in ##sys#reverse-list->string in k8543 */
static void C_ccall f_11439(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,3)))){
C_save_and_reclaim((void *)f_11439,c,av);}
a=C_alloc(4);
t2=C_fixnum_difference(((C_word*)t0)[2],C_fix(1));
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_11448,a[2]=t1,a[3]=((C_word)li298),tmp=(C_word)a,a+=4,tmp);
t4=(
  f_11448(t3,((C_word*)t0)[3],t2)
);
t5=((C_word*)t0)[4];{
C_word *av2=av;
av2[0]=t5;
av2[1]=t1;
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}

/* iter in k11437 in ##sys#reverse-list->string in k8543 */
static C_word C_fcall f_11448(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_stack_overflow_check;
loop:{}
if(C_truep(C_fixnum_greater_or_equal_p(t2,C_fix(0)))){
t3=C_slot(t1,C_fix(0));
t4=C_i_check_char_2(t3,lf[391]);
t5=C_setsubchar(((C_word*)t0)[2],t2,t3);
t7=C_slot(t1,C_fix(1));
t8=C_fixnum_difference(t2,C_fix(1));
t1=t7;
t2=t8;
goto loop;}
else{
t3=C_SCHEME_UNDEFINED;
return(t3);}}

/* scheme#string-fill! in k8543 */
static void C_ccall f_11477(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_11477,c,av);}
t4=C_i_check_string_2(t2,lf[393]);
t5=C_i_check_char_2(t3,lf[393]);
t6=C_block_size(t2);
t7=C_set_memory(t2,t3,t6);
t8=t1;{
C_word *av2=av;
av2[0]=t8;
av2[1]=C_SCHEME_UNDEFINED;
((C_proc)(void*)(*((C_word*)t8+1)))(2,av2);}}

/* scheme#string-copy in k8543 */
static void C_ccall f_11490(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(5,c,2)))){
C_save_and_reclaim((void *)f_11490,c,av);}
a=C_alloc(5);
t3=C_i_check_string_2(t2,lf[395]);
t4=C_block_size(t2);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_11500,a[2]=t2,a[3]=t4,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
/* library.scm:1379: ##sys#make-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[379]+1));
C_word *av2=av;
av2[0]=*((C_word*)lf[379]+1);
av2[1]=t5;
av2[2]=t4;
tp(3,av2);}}

/* k11498 in scheme#string-copy in k8543 */
static void C_ccall f_11500(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_11500,c,av);}
t2=C_copy_memory(t1,((C_word*)t0)[2],((C_word*)t0)[3]);
t3=((C_word*)t0)[4];{
C_word *av2=av;
av2[0]=t3;
av2[1]=t1;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* scheme#substring in k8543 */
static void C_ccall f_11502(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c<4) C_bad_min_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-4)*C_SIZEOF_PAIR +6,c,3)))){
C_save_and_reclaim((void*)f_11502,c,av);}
a=C_alloc((c-4)*C_SIZEOF_PAIR+6);
t4=C_build_rest(&a,c,4,av);
C_word t5;
C_word t6;
C_word t7;
t5=C_i_check_string_2(t2,lf[397]);
t6=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_11509,a[2]=t2,a[3]=t1,a[4]=t3,a[5]=t4,tmp=(C_word)a,a+=6,tmp);
/* library.scm:1386: ##sys#check-fixnum */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[102]+1));
C_word *av2=av;
av2[0]=*((C_word*)lf[102]+1);
av2[1]=t6;
av2[2]=t3;
av2[3]=lf[397];
tp(4,av2);}}

/* k11507 in scheme#substring in k8543 */
static void C_ccall f_11509(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(9,c,3)))){
C_save_and_reclaim((void *)f_11509,c,av);}
a=C_alloc(9);
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_11512,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
if(C_truep(C_i_pairp(((C_word*)t0)[5]))){
t3=C_u_i_car(((C_word*)t0)[5]);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_11547,a[2]=t2,a[3]=t3,tmp=(C_word)a,a+=4,tmp);
/* library.scm:1389: ##sys#check-fixnum */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[102]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[102]+1);
av2[1]=t4;
av2[2]=t3;
av2[3]=lf[397];
tp(4,av2);}}
else{
t3=t2;
f_11512(t3,C_block_size(((C_word*)t0)[2]));}}

/* k11510 in k11507 in scheme#substring in k8543 */
static void C_fcall f_11512(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(6,0,2)))){
C_save_and_reclaim_args((void *)trf_11512,2,t0,t1);}
a=C_alloc(6);
t2=C_block_size(((C_word*)t0)[2]);
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_11521,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[4],a[5]=t1,tmp=(C_word)a,a+=6,tmp);
if(C_truep(C_fixnum_less_or_equal_p(((C_word*)t0)[4],t1))){
t4=C_fixnum_greater_or_equal_p(((C_word*)t0)[4],C_fix(0));
t5=t3;
f_11521(t5,(C_truep(t4)?C_fixnum_less_or_equal_p(t1,t2):C_SCHEME_FALSE));}
else{
t4=t3;
f_11521(t4,C_SCHEME_FALSE);}}

/* k11519 in k11510 in k11507 in scheme#substring in k8543 */
static void C_fcall f_11521(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,0,5)))){
C_save_and_reclaim_args((void *)trf_11521,2,t0,t1);}
if(C_truep(t1)){
/* library.scm:1396: ##sys#substring */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[398]+1));
C_word av2[5];
av2[0]=*((C_word*)lf[398]+1);
av2[1]=((C_word*)t0)[2];
av2[2]=((C_word*)t0)[3];
av2[3]=((C_word*)t0)[4];
av2[4]=((C_word*)t0)[5];
tp(5,av2);}}
else{
t2=C_fix((C_word)C_OUT_OF_RANGE_ERROR);
/* library.scm:1397: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[365]);
C_word av2[6];
av2[0]=*((C_word*)lf[365]+1);
av2[1]=((C_word*)t0)[2];
av2[2]=t2;
av2[3]=lf[397];
av2[4]=((C_word*)t0)[4];
av2[5]=((C_word*)t0)[5];
tp(6,av2);}}}

/* k11545 in k11507 in scheme#substring in k8543 */
static void C_ccall f_11547(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_11547,c,av);}
t2=((C_word*)t0)[2];
f_11512(t2,((C_word*)t0)[3]);}

/* ##sys#substring in k8543 */
static void C_ccall f_11552(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5;
C_word t6;
C_word *a;
if(c!=5) C_bad_argc_2(c,5,t0);
if(C_unlikely(!C_demand(C_calculate_demand(6,c,2)))){
C_save_and_reclaim((void *)f_11552,c,av);}
a=C_alloc(6);
t5=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_11556,a[2]=t2,a[3]=t3,a[4]=t4,a[5]=t1,tmp=(C_word)a,a+=6,tmp);
/* library.scm:1402: ##sys#make-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[379]+1));
C_word *av2=av;
av2[0]=*((C_word*)lf[379]+1);
av2[1]=t5;
av2[2]=C_fixnum_difference(t4,t3);
tp(3,av2);}}

/* k11554 in ##sys#substring in k8543 */
static void C_ccall f_11556(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_11556,c,av);}
t2=C_substring_copy(((C_word*)t0)[2],t1,((C_word*)t0)[3],((C_word*)t0)[4],C_fix(0));
t3=((C_word*)t0)[5];{
C_word *av2=av;
av2[0]=t3;
av2[1]=t1;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* compare1579 in k8543 */
static void C_ccall f_11561(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5=av[5];
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a;
if(c!=6) C_bad_argc_2(c,6,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,4)))){
C_save_and_reclaim((void *)f_11561,c,av);}
t6=C_i_check_string_2(t2,t4);
t7=C_i_check_string_2(t3,t4);
t8=C_block_size(t2);
t9=C_block_size(t3);
if(C_truep(C_fixnum_lessp(t8,t9))){
/* library.scm:1412: k */
t10=t5;{
C_word *av2=av;
av2[0]=t10;
av2[1]=t1;
av2[2]=t8;
av2[3]=t9;
av2[4]=C_string_compare(t2,t3,t8);
((C_proc)C_fast_retrieve_proc(t10))(5,av2);}}
else{
/* library.scm:1412: k */
t10=t5;{
C_word *av2=av;
av2[0]=t10;
av2[1]=t1;
av2[2]=t8;
av2[3]=t9;
av2[4]=C_string_compare(t2,t3,t9);
((C_proc)C_fast_retrieve_proc(t10))(5,av2);}}}

/* scheme#string<? in k8543 */
static void C_ccall f_11582(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(3,c,5)))){
C_save_and_reclaim((void *)f_11582,c,av);}
a=C_alloc(3);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11588,a[2]=((C_word)li305),tmp=(C_word)a,a+=3,tmp);
/* library.scm:1420: compare */
t5=((C_word*)((C_word*)t0)[2])[1];{
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=t5;
av2[1]=t1;
av2[2]=t2;
av2[3]=t3;
av2[4]=lf[400];
av2[5]=t4;
((C_proc)C_fast_retrieve_proc(t5))(6,av2);}}

/* a11587 in scheme#string<? in k8543 */
static void C_ccall f_11588(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(c!=5) C_bad_argc_2(c,5,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_11588,c,av);}
t5=C_fixnum_lessp(t4,C_fix(0));
if(C_truep(t5)){
t6=t1;{
C_word *av2=av;
av2[0]=t6;
av2[1]=t5;
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}
else{
t6=C_fixnum_lessp(t2,t3);
t7=t1;{
C_word *av2=av;
av2[0]=t7;
av2[1]=(C_truep(t6)?C_eqp(t4,C_fix(0)):C_SCHEME_FALSE);
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}}

/* scheme#string>? in k8543 */
static void C_ccall f_11606(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(3,c,5)))){
C_save_and_reclaim((void *)f_11606,c,av);}
a=C_alloc(3);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11612,a[2]=((C_word)li307),tmp=(C_word)a,a+=3,tmp);
/* library.scm:1427: compare */
t5=((C_word*)((C_word*)t0)[2])[1];{
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=t5;
av2[1]=t1;
av2[2]=t2;
av2[3]=t3;
av2[4]=lf[402];
av2[5]=t4;
((C_proc)C_fast_retrieve_proc(t5))(6,av2);}}

/* a11611 in scheme#string>? in k8543 */
static void C_ccall f_11612(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(c!=5) C_bad_argc_2(c,5,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_11612,c,av);}
t5=C_fixnum_greaterp(t4,C_fix(0));
if(C_truep(t5)){
t6=t1;{
C_word *av2=av;
av2[0]=t6;
av2[1]=t5;
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}
else{
t6=C_fixnum_lessp(t3,t2);
t7=t1;{
C_word *av2=av;
av2[0]=t7;
av2[1]=(C_truep(t6)?C_eqp(t4,C_fix(0)):C_SCHEME_FALSE);
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}}

/* scheme#string<=? in k8543 */
static void C_ccall f_11630(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(3,c,5)))){
C_save_and_reclaim((void *)f_11630,c,av);}
a=C_alloc(3);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11636,a[2]=((C_word)li309),tmp=(C_word)a,a+=3,tmp);
/* library.scm:1434: compare */
t5=((C_word*)((C_word*)t0)[2])[1];{
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=t5;
av2[1]=t1;
av2[2]=t2;
av2[3]=t3;
av2[4]=lf[404];
av2[5]=t4;
((C_proc)C_fast_retrieve_proc(t5))(6,av2);}}

/* a11635 in scheme#string<=? in k8543 */
static void C_ccall f_11636(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5;
C_word t6;
C_word *a;
if(c!=5) C_bad_argc_2(c,5,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_11636,c,av);}
t5=C_eqp(t4,C_fix(0));
t6=t1;{
C_word *av2=av;
av2[0]=t6;
av2[1]=(C_truep(t5)?C_fixnum_less_or_equal_p(t2,t3):C_fixnum_lessp(t4,C_fix(0)));
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}

/* scheme#string>=? in k8543 */
static void C_ccall f_11651(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(3,c,5)))){
C_save_and_reclaim((void *)f_11651,c,av);}
a=C_alloc(3);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11657,a[2]=((C_word)li311),tmp=(C_word)a,a+=3,tmp);
/* library.scm:1441: compare */
t5=((C_word*)((C_word*)t0)[2])[1];{
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=t5;
av2[1]=t1;
av2[2]=t2;
av2[3]=t3;
av2[4]=lf[406];
av2[5]=t4;
((C_proc)C_fast_retrieve_proc(t5))(6,av2);}}

/* a11656 in scheme#string>=? in k8543 */
static void C_ccall f_11657(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5;
C_word t6;
C_word *a;
if(c!=5) C_bad_argc_2(c,5,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_11657,c,av);}
t5=C_eqp(t4,C_fix(0));
t6=t1;{
C_word *av2=av;
av2[0]=t6;
av2[1]=(C_truep(t5)?C_fixnum_greater_or_equal_p(t2,t3):C_fixnum_greaterp(t4,C_fix(0)));
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}

/* compare1622 in k8543 */
static void C_ccall f_11671(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5=av[5];
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a;
if(c!=6) C_bad_argc_2(c,6,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,4)))){
C_save_and_reclaim((void *)f_11671,c,av);}
t6=C_i_check_string_2(t2,t4);
t7=C_i_check_string_2(t3,t4);
t8=C_block_size(t2);
t9=C_block_size(t3);
if(C_truep(C_fixnum_lessp(t8,t9))){
/* library.scm:1454: k */
t10=t5;{
C_word *av2=av;
av2[0]=t10;
av2[1]=t1;
av2[2]=t8;
av2[3]=t9;
av2[4]=C_string_compare_case_insensitive(t2,t3,t8);
((C_proc)C_fast_retrieve_proc(t10))(5,av2);}}
else{
/* library.scm:1454: k */
t10=t5;{
C_word *av2=av;
av2[0]=t10;
av2[1]=t1;
av2[2]=t8;
av2[3]=t9;
av2[4]=C_string_compare_case_insensitive(t2,t3,t9);
((C_proc)C_fast_retrieve_proc(t10))(5,av2);}}}

/* scheme#string-ci<? in k8543 */
static void C_ccall f_11692(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(3,c,5)))){
C_save_and_reclaim((void *)f_11692,c,av);}
a=C_alloc(3);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11698,a[2]=((C_word)li314),tmp=(C_word)a,a+=3,tmp);
/* library.scm:1462: compare */
t5=((C_word*)((C_word*)t0)[2])[1];{
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=t5;
av2[1]=t1;
av2[2]=t2;
av2[3]=t3;
av2[4]=lf[408];
av2[5]=t4;
((C_proc)C_fast_retrieve_proc(t5))(6,av2);}}

/* a11697 in scheme#string-ci<? in k8543 */
static void C_ccall f_11698(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(c!=5) C_bad_argc_2(c,5,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_11698,c,av);}
t5=C_fixnum_lessp(t4,C_fix(0));
if(C_truep(t5)){
t6=t1;{
C_word *av2=av;
av2[0]=t6;
av2[1]=t5;
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}
else{
t6=C_fixnum_lessp(t2,t3);
t7=t1;{
C_word *av2=av;
av2[0]=t7;
av2[1]=(C_truep(t6)?C_eqp(t4,C_fix(0)):C_SCHEME_FALSE);
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}}

/* scheme#string-ci>? in k8543 */
static void C_ccall f_11716(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(3,c,5)))){
C_save_and_reclaim((void *)f_11716,c,av);}
a=C_alloc(3);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11722,a[2]=((C_word)li316),tmp=(C_word)a,a+=3,tmp);
/* library.scm:1469: compare */
t5=((C_word*)((C_word*)t0)[2])[1];{
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=t5;
av2[1]=t1;
av2[2]=t2;
av2[3]=t3;
av2[4]=lf[410];
av2[5]=t4;
((C_proc)C_fast_retrieve_proc(t5))(6,av2);}}

/* a11721 in scheme#string-ci>? in k8543 */
static void C_ccall f_11722(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(c!=5) C_bad_argc_2(c,5,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_11722,c,av);}
t5=C_fixnum_greaterp(t4,C_fix(0));
if(C_truep(t5)){
t6=t1;{
C_word *av2=av;
av2[0]=t6;
av2[1]=t5;
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}
else{
t6=C_fixnum_lessp(t3,t2);
t7=t1;{
C_word *av2=av;
av2[0]=t7;
av2[1]=(C_truep(t6)?C_eqp(t4,C_fix(0)):C_SCHEME_FALSE);
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}}

/* scheme#string-ci<=? in k8543 */
static void C_ccall f_11740(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(3,c,5)))){
C_save_and_reclaim((void *)f_11740,c,av);}
a=C_alloc(3);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11746,a[2]=((C_word)li318),tmp=(C_word)a,a+=3,tmp);
/* library.scm:1476: compare */
t5=((C_word*)((C_word*)t0)[2])[1];{
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=t5;
av2[1]=t1;
av2[2]=t2;
av2[3]=t3;
av2[4]=lf[412];
av2[5]=t4;
((C_proc)C_fast_retrieve_proc(t5))(6,av2);}}

/* a11745 in scheme#string-ci<=? in k8543 */
static void C_ccall f_11746(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5;
C_word t6;
C_word *a;
if(c!=5) C_bad_argc_2(c,5,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_11746,c,av);}
t5=C_eqp(t4,C_fix(0));
t6=t1;{
C_word *av2=av;
av2[0]=t6;
av2[1]=(C_truep(t5)?C_fixnum_less_or_equal_p(t2,t3):C_fixnum_lessp(t4,C_fix(0)));
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}

/* scheme#string-ci>=? in k8543 */
static void C_ccall f_11761(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(3,c,5)))){
C_save_and_reclaim((void *)f_11761,c,av);}
a=C_alloc(3);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11767,a[2]=((C_word)li320),tmp=(C_word)a,a+=3,tmp);
/* library.scm:1483: compare */
t5=((C_word*)((C_word*)t0)[2])[1];{
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=t5;
av2[1]=t1;
av2[2]=t2;
av2[3]=t3;
av2[4]=lf[414];
av2[5]=t4;
((C_proc)C_fast_retrieve_proc(t5))(6,av2);}}

/* a11766 in scheme#string-ci>=? in k8543 */
static void C_ccall f_11767(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5;
C_word t6;
C_word *a;
if(c!=5) C_bad_argc_2(c,5,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_11767,c,av);}
t5=C_eqp(t4,C_fix(0));
t6=t1;{
C_word *av2=av;
av2[0]=t6;
av2[1]=(C_truep(t5)?C_fixnum_greater_or_equal_p(t2,t3):C_fixnum_greaterp(t4,C_fix(0)));
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}

/* ##sys#string-append in k8543 */
static void C_ccall f_11782(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(7,c,2)))){
C_save_and_reclaim((void *)f_11782,c,av);}
a=C_alloc(7);
t4=C_block_size(t2);
t5=C_block_size(t3);
t6=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_11792,a[2]=t2,a[3]=t4,a[4]=t3,a[5]=t5,a[6]=t1,tmp=(C_word)a,a+=7,tmp);
/* library.scm:1493: ##sys#make-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[379]+1));
C_word *av2=av;
av2[0]=*((C_word*)lf[379]+1);
av2[1]=t6;
av2[2]=C_fixnum_plus(t4,t5);
tp(3,av2);}}

/* k11790 in ##sys#string-append in k8543 */
static void C_ccall f_11792(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_11792,c,av);}
t2=C_substring_copy(((C_word*)t0)[2],t1,C_fix(0),((C_word*)t0)[3],C_fix(0));
t3=C_substring_copy(((C_word*)t0)[4],t1,C_fix(0),((C_word*)t0)[5],((C_word*)t0)[3]);
t4=((C_word*)t0)[6];{
C_word *av2=av;
av2[0]=t4;
av2[1]=t1;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* scheme#string-append in k8543 */
static void C_ccall f_11798(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand((c-2)*C_SIZEOF_PAIR +13,c,4)))){
C_save_and_reclaim((void*)f_11798,c,av);}
a=C_alloc((c-2)*C_SIZEOF_PAIR+13);
t2=C_build_rest(&a,c,2,av);
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
t3=C_SCHEME_FALSE;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_11802,a[2]=t1,a[3]=t4,tmp=(C_word)a,a+=4,tmp);
t6=C_SCHEME_UNDEFINED;
t7=(*a=C_VECTOR_TYPE|1,a[1]=t6,tmp=(C_word)a,a+=2,tmp);
t8=C_set_block_item(t7,0,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_11804,a[2]=t4,a[3]=t7,a[4]=((C_word)li323),tmp=(C_word)a,a+=5,tmp));
t9=((C_word*)t7)[1];
f_11804(t9,t5,t2,C_fix(0));}

/* k11800 in scheme#string-append in k8543 */
static void C_ccall f_11802(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_11802,c,av);}
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=((C_word*)((C_word*)t0)[3])[1];
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* loop in scheme#string-append in k8543 */
static void C_fcall f_11804(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word *a;
loop:
if(C_unlikely(!C_demand(C_calculate_demand(7,0,3)))){
C_save_and_reclaim_args((void *)trf_11804,4,t0,t1,t2,t3);}
a=C_alloc(7);
t4=C_eqp(t2,C_SCHEME_END_OF_LIST);
if(C_truep(t4)){
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_11815,a[2]=((C_word*)t0)[2],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* library.scm:1503: ##sys#make-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[379]+1));
C_word av2[3];
av2[0]=*((C_word*)lf[379]+1);
av2[1]=t5;
av2[2]=t3;
tp(3,av2);}}
else{
t5=C_slot(t2,C_fix(0));
t6=C_i_check_string_2(t5,lf[417]);
t7=C_block_size(t5);
t8=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_11827,a[2]=t1,a[3]=t5,a[4]=((C_word*)t0)[2],a[5]=t7,a[6]=t3,tmp=(C_word)a,a+=7,tmp);
/* library.scm:1507: loop */
t10=t8;
t11=C_slot(t2,C_fix(1));
t12=C_fixnum_plus(t3,t7);
t1=t10;
t2=t11;
t3=t12;
goto loop;}}

/* k11813 in loop in scheme#string-append in k8543 */
static void C_ccall f_11815(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_11815,c,av);}
t2=C_mutate(((C_word *)((C_word*)t0)[2])+1,t1);
t3=((C_word*)t0)[3];{
C_word *av2=av;
av2[0]=t3;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* k11825 in loop in scheme#string-append in k8543 */
static void C_ccall f_11827(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_11827,c,av);}
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_substring_copy(((C_word*)t0)[3],((C_word*)((C_word*)t0)[4])[1],C_fix(0),((C_word*)t0)[5],((C_word*)t0)[6]);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* scheme#string in k8543 */
static void C_ccall f_11837(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand((c-2)*C_SIZEOF_PAIR +0,c,2)))){
C_save_and_reclaim((void*)f_11837,c,av);}
a=C_alloc((c-2)*C_SIZEOF_PAIR+0);
t2=C_build_rest(&a,c,2,av);
C_word t3;
/* ##sys#list->string */
t3=*((C_word*)lf[389]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t3;
av2[1]=t1;
av2[2]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(3,av2);}}

/* ##sys#fragments->string in k8543 */
static void C_ccall f_11843(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(4,c,2)))){
C_save_and_reclaim((void *)f_11843,c,av);}
a=C_alloc(4);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_11847,a[2]=t1,a[3]=t3,tmp=(C_word)a,a+=4,tmp);
/* library.scm:1516: ##sys#make-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[379]+1));
C_word *av2=av;
av2[0]=*((C_word*)lf[379]+1);
av2[1]=t4;
av2[2]=t2;
tp(3,av2);}}

/* k11845 in ##sys#fragments->string in k8543 */
static void C_ccall f_11847(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,3)))){
C_save_and_reclaim((void *)f_11847,c,av);}
a=C_alloc(4);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_11852,a[2]=t1,a[3]=((C_word)li326),tmp=(C_word)a,a+=4,tmp);
t3=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t3;
av2[1]=(
  f_11852(t2,((C_word*)t0)[3],C_fix(0))
);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* loop in k11845 in ##sys#fragments->string in k8543 */
static C_word C_fcall f_11852(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_stack_overflow_check;
loop:{}
if(C_truep(C_i_nullp(t1))){
return(((C_word*)t0)[2]);}
else{
t3=C_slot(t1,C_fix(0));
t4=C_block_size(t3);
t5=C_substring_copy(t3,((C_word*)t0)[2],C_fix(0),t4,t2);
t7=C_slot(t1,C_fix(1));
t8=C_fixnum_plus(t2,t4);
t1=t7;
t2=t8;
goto loop;}}

/* chicken.base#chop in k8543 */
static void C_ccall f_11878(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(5,c,3)))){
C_save_and_reclaim((void *)f_11878,c,av);}
a=C_alloc(5);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_11882,a[2]=t2,a[3]=t3,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
/* library.scm:1527: ##sys#check-fixnum */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[102]+1));
C_word *av2=av;
av2[0]=*((C_word*)lf[102]+1);
av2[1]=t4;
av2[2]=t3;
av2[3]=lf[421];
tp(4,av2);}}

/* k11880 in chicken.base#chop in k8543 */
static void C_ccall f_11882(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,c,4)))){
C_save_and_reclaim((void *)f_11882,c,av);}
a=C_alloc(5);
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_11885,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
if(C_truep(C_fixnum_less_or_equal_p(((C_word*)t0)[3],C_fix(0)))){
/* library.scm:1528: ##sys#error */
t3=*((C_word*)lf[155]+1);{
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=lf[421];
av2[3]=lf[422];
av2[4]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t3+1)))(5,av2);}}
else{
t3=t2;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_SCHEME_UNDEFINED;
f_11885(2,av2);}}}

/* k11883 in k11880 in chicken.base#chop in k8543 */
static void C_ccall f_11885(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(7,c,4)))){
C_save_and_reclaim((void *)f_11885,c,av);}
a=C_alloc(7);
t2=C_i_length(((C_word*)t0)[2]);
t3=C_SCHEME_UNDEFINED;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_set_block_item(t4,0,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_11893,a[2]=((C_word*)t0)[3],a[3]=t4,a[4]=((C_word)li329),tmp=(C_word)a,a+=5,tmp));
t6=((C_word*)t4)[1];
f_11893(t6,((C_word*)t0)[4],((C_word*)t0)[2],t2);}

/* loop in k11883 in k11880 in chicken.base#chop in k8543 */
static void C_fcall f_11893(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(9,0,5)))){
C_save_and_reclaim_args((void *)trf_11893,4,t0,t1,t2,t3);}
a=C_alloc(9);
if(C_truep(C_i_nullp(t2))){
t4=t1;{
C_word av2[2];
av2[0]=t4;
av2[1]=C_SCHEME_END_OF_LIST;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
if(C_truep(C_fixnum_lessp(t3,((C_word*)t0)[2]))){
t4=t1;{
C_word av2[2];
av2[0]=t4;
av2[1]=C_a_i_list1(&a,1,t2);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t4=C_SCHEME_UNDEFINED;
t5=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t6=C_set_block_item(t5,0,(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_11914,a[2]=((C_word*)t0)[3],a[3]=t3,a[4]=((C_word*)t0)[2],a[5]=t5,a[6]=((C_word)li328),tmp=(C_word)a,a+=7,tmp));
t7=((C_word*)t5)[1];
f_11914(t7,t1,C_SCHEME_END_OF_LIST,t2,((C_word*)t0)[2]);}}}

/* doloop1707 in loop in k11883 in k11880 in chicken.base#chop in k8543 */
static void C_fcall f_11914(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word *a;
loop:
if(C_unlikely(!C_demand(C_calculate_demand(7,0,4)))){
C_save_and_reclaim_args((void *)trf_11914,5,t0,t1,t2,t3,t4);}
a=C_alloc(7);
t5=C_eqp(t4,C_fix(0));
if(C_truep(t5)){
t6=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_11928,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=t3,a[5]=((C_word*)t0)[3],a[6]=((C_word*)t0)[4],tmp=(C_word)a,a+=7,tmp);
/* library.scm:1538: scheme#reverse */
t7=*((C_word*)lf[46]+1);{
C_word av2[3];
av2[0]=t7;
av2[1]=t6;
av2[2]=t2;
((C_proc)(void*)(*((C_word*)t7+1)))(3,av2);}}
else{
t6=C_slot(t3,C_fix(0));
t7=C_a_i_cons(&a,2,t6,t2);
t9=t1;
t10=t7;
t11=C_slot(t3,C_fix(1));
t12=C_fixnum_difference(t4,C_fix(1));
t1=t9;
t2=t10;
t3=t11;
t4=t12;
goto loop;}}

/* k11926 in doloop1707 in loop in k11883 in k11880 in chicken.base#chop in k8543 */
static void C_ccall f_11928(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,3)))){
C_save_and_reclaim((void *)f_11928,c,av);}
a=C_alloc(4);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_11932,a[2]=((C_word*)t0)[2],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* library.scm:1538: loop */
t3=((C_word*)((C_word*)t0)[3])[1];
f_11893(t3,t2,((C_word*)t0)[4],C_fixnum_difference(((C_word*)t0)[5],((C_word*)t0)[6]));}

/* k11930 in k11926 in doloop1707 in loop in k11883 in k11880 in chicken.base#chop in k8543 */
static void C_ccall f_11932(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,c,1)))){
C_save_and_reclaim((void *)f_11932,c,av);}
a=C_alloc(3);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_a_i_cons(&a,2,((C_word*)t0)[3],t1);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.flonum#fp+ in k8543 */
static void C_ccall f_11973(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(9,c,5)))){
C_save_and_reclaim((void *)f_11973,c,av);}
a=C_alloc(9);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_11995,a[2]=t1,a[3]=t2,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
t5=C_i_flonump(t2);
t6=(C_truep(t5)?C_i_flonump(t3):C_SCHEME_FALSE);
if(C_truep(t6)){
t7=t1;{
C_word *av2=av;
av2[0]=t7;
av2[1]=C_flonum(&a,C_ub_i_flonum_plus(C_flonum_magnitude(t2),C_flonum_magnitude(t3)));
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}
else{
t7=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_FLONUM_ERROR);
/* library.scm:1569: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[365]);
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=*((C_word*)lf[365]+1);
av2[1]=t4;
av2[2]=t7;
av2[3]=lf[435];
av2[4]=t2;
av2[5]=t3;
tp(6,av2);}}}

/* k11993 in chicken.flonum#fp+ in k8543 */
static void C_ccall f_11995(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,1)))){
C_save_and_reclaim((void *)f_11995,c,av);}
a=C_alloc(4);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_flonum(&a,C_ub_i_flonum_plus(C_flonum_magnitude(((C_word*)t0)[3]),C_flonum_magnitude(((C_word*)t0)[4])));
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.flonum#fp- in k8543 */
static void C_ccall f_11997(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(9,c,5)))){
C_save_and_reclaim((void *)f_11997,c,av);}
a=C_alloc(9);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_12019,a[2]=t1,a[3]=t2,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
t5=C_i_flonump(t2);
t6=(C_truep(t5)?C_i_flonump(t3):C_SCHEME_FALSE);
if(C_truep(t6)){
t7=t1;{
C_word *av2=av;
av2[0]=t7;
av2[1]=C_flonum(&a,C_ub_i_flonum_difference(C_flonum_magnitude(t2),C_flonum_magnitude(t3)));
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}
else{
t7=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_FLONUM_ERROR);
/* library.scm:1569: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[365]);
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=*((C_word*)lf[365]+1);
av2[1]=t4;
av2[2]=t7;
av2[3]=lf[437];
av2[4]=t2;
av2[5]=t3;
tp(6,av2);}}}

/* k12017 in chicken.flonum#fp- in k8543 */
static void C_ccall f_12019(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,1)))){
C_save_and_reclaim((void *)f_12019,c,av);}
a=C_alloc(4);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_flonum(&a,C_ub_i_flonum_difference(C_flonum_magnitude(((C_word*)t0)[3]),C_flonum_magnitude(((C_word*)t0)[4])));
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.flonum#fp* in k8543 */
static void C_ccall f_12021(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(9,c,5)))){
C_save_and_reclaim((void *)f_12021,c,av);}
a=C_alloc(9);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_12043,a[2]=t1,a[3]=t2,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
t5=C_i_flonump(t2);
t6=(C_truep(t5)?C_i_flonump(t3):C_SCHEME_FALSE);
if(C_truep(t6)){
t7=t1;{
C_word *av2=av;
av2[0]=t7;
av2[1]=C_flonum(&a,C_ub_i_flonum_times(C_flonum_magnitude(t2),C_flonum_magnitude(t3)));
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}
else{
t7=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_FLONUM_ERROR);
/* library.scm:1569: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[365]);
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=*((C_word*)lf[365]+1);
av2[1]=t4;
av2[2]=t7;
av2[3]=lf[439];
av2[4]=t2;
av2[5]=t3;
tp(6,av2);}}}

/* k12041 in chicken.flonum#fp* in k8543 */
static void C_ccall f_12043(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,1)))){
C_save_and_reclaim((void *)f_12043,c,av);}
a=C_alloc(4);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_flonum(&a,C_ub_i_flonum_times(C_flonum_magnitude(((C_word*)t0)[3]),C_flonum_magnitude(((C_word*)t0)[4])));
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.flonum#fp/ in k8543 */
static void C_ccall f_12045(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(9,c,5)))){
C_save_and_reclaim((void *)f_12045,c,av);}
a=C_alloc(9);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_12067,a[2]=t1,a[3]=t2,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
t5=C_i_flonump(t2);
t6=(C_truep(t5)?C_i_flonump(t3):C_SCHEME_FALSE);
if(C_truep(t6)){
t7=t1;{
C_word *av2=av;
av2[0]=t7;
av2[1]=C_flonum(&a,C_ub_i_flonum_quotient(C_flonum_magnitude(t2),C_flonum_magnitude(t3)));
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}
else{
t7=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_FLONUM_ERROR);
/* library.scm:1569: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[365]);
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=*((C_word*)lf[365]+1);
av2[1]=t4;
av2[2]=t7;
av2[3]=lf[441];
av2[4]=t2;
av2[5]=t3;
tp(6,av2);}}}

/* k12065 in chicken.flonum#fp/ in k8543 */
static void C_ccall f_12067(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,1)))){
C_save_and_reclaim((void *)f_12067,c,av);}
a=C_alloc(4);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_flonum(&a,C_ub_i_flonum_quotient(C_flonum_magnitude(((C_word*)t0)[3]),C_flonum_magnitude(((C_word*)t0)[4])));
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.flonum#fpgcd in k8543 */
static void C_ccall f_12069(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(9,c,5)))){
C_save_and_reclaim((void *)f_12069,c,av);}
a=C_alloc(9);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_12091,a[2]=t1,a[3]=t2,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
t5=C_i_flonump(t2);
t6=(C_truep(t5)?C_i_flonump(t3):C_SCHEME_FALSE);
if(C_truep(t6)){
t7=t1;{
C_word *av2=av;
av2[0]=t7;
av2[1]=C_a_i_flonum_gcd(&a,2,t2,t3);
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}
else{
t7=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_FLONUM_ERROR);
/* library.scm:1569: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[365]);
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=*((C_word*)lf[365]+1);
av2[1]=t4;
av2[2]=t7;
av2[3]=lf[443];
av2[4]=t2;
av2[5]=t3;
tp(6,av2);}}}

/* k12089 in chicken.flonum#fpgcd in k8543 */
static void C_ccall f_12091(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,1)))){
C_save_and_reclaim((void *)f_12091,c,av);}
a=C_alloc(4);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_a_i_flonum_gcd(&a,2,((C_word*)t0)[3],((C_word*)t0)[4]);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.flonum#fp/? in k8543 */
static void C_ccall f_12093(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(9,c,5)))){
C_save_and_reclaim((void *)f_12093,c,av);}
a=C_alloc(9);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_12115,a[2]=t1,a[3]=t2,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
t5=C_i_flonump(t2);
t6=(C_truep(t5)?C_i_flonump(t3):C_SCHEME_FALSE);
if(C_truep(t6)){
t7=t1;{
C_word *av2=av;
av2[0]=t7;
av2[1]=C_a_i_flonum_quotient_checked(&a,2,t2,t3);
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}
else{
t7=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_FLONUM_ERROR);
/* library.scm:1569: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[365]);
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=*((C_word*)lf[365]+1);
av2[1]=t4;
av2[2]=t7;
av2[3]=lf[445];
av2[4]=t2;
av2[5]=t3;
tp(6,av2);}}}

/* k12113 in chicken.flonum#fp/? in k8543 */
static void C_ccall f_12115(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,1)))){
C_save_and_reclaim((void *)f_12115,c,av);}
a=C_alloc(4);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_a_i_flonum_quotient_checked(&a,2,((C_word*)t0)[3],((C_word*)t0)[4]);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.flonum#fp= in k8543 */
static void C_ccall f_12117(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(5,c,5)))){
C_save_and_reclaim((void *)f_12117,c,av);}
a=C_alloc(5);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_12139,a[2]=t1,a[3]=t2,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
t5=C_i_flonump(t2);
t6=(C_truep(t5)?C_i_flonump(t3):C_SCHEME_FALSE);
if(C_truep(t6)){
t7=t1;{
C_word *av2=av;
av2[0]=t7;
av2[1]=C_ub_i_flonum_equalp(C_flonum_magnitude(t2),C_flonum_magnitude(t3));
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}
else{
t7=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_FLONUM_ERROR);
/* library.scm:1569: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[365]);
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=*((C_word*)lf[365]+1);
av2[1]=t4;
av2[2]=t7;
av2[3]=lf[447];
av2[4]=t2;
av2[5]=t3;
tp(6,av2);}}}

/* k12137 in chicken.flonum#fp= in k8543 */
static void C_ccall f_12139(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_12139,c,av);}
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_ub_i_flonum_equalp(C_flonum_magnitude(((C_word*)t0)[3]),C_flonum_magnitude(((C_word*)t0)[4]));
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.flonum#fp> in k8543 */
static void C_ccall f_12141(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(5,c,5)))){
C_save_and_reclaim((void *)f_12141,c,av);}
a=C_alloc(5);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_12163,a[2]=t1,a[3]=t2,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
t5=C_i_flonump(t2);
t6=(C_truep(t5)?C_i_flonump(t3):C_SCHEME_FALSE);
if(C_truep(t6)){
t7=t1;{
C_word *av2=av;
av2[0]=t7;
av2[1]=C_ub_i_flonum_greaterp(C_flonum_magnitude(t2),C_flonum_magnitude(t3));
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}
else{
t7=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_FLONUM_ERROR);
/* library.scm:1569: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[365]);
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=*((C_word*)lf[365]+1);
av2[1]=t4;
av2[2]=t7;
av2[3]=lf[449];
av2[4]=t2;
av2[5]=t3;
tp(6,av2);}}}

/* k12161 in chicken.flonum#fp> in k8543 */
static void C_ccall f_12163(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_12163,c,av);}
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_ub_i_flonum_greaterp(C_flonum_magnitude(((C_word*)t0)[3]),C_flonum_magnitude(((C_word*)t0)[4]));
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.flonum#fp< in k8543 */
static void C_ccall f_12165(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(5,c,5)))){
C_save_and_reclaim((void *)f_12165,c,av);}
a=C_alloc(5);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_12187,a[2]=t1,a[3]=t2,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
t5=C_i_flonump(t2);
t6=(C_truep(t5)?C_i_flonump(t3):C_SCHEME_FALSE);
if(C_truep(t6)){
t7=t1;{
C_word *av2=av;
av2[0]=t7;
av2[1]=C_ub_i_flonum_lessp(C_flonum_magnitude(t2),C_flonum_magnitude(t3));
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}
else{
t7=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_FLONUM_ERROR);
/* library.scm:1569: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[365]);
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=*((C_word*)lf[365]+1);
av2[1]=t4;
av2[2]=t7;
av2[3]=lf[451];
av2[4]=t2;
av2[5]=t3;
tp(6,av2);}}}

/* k12185 in chicken.flonum#fp< in k8543 */
static void C_ccall f_12187(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_12187,c,av);}
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_ub_i_flonum_lessp(C_flonum_magnitude(((C_word*)t0)[3]),C_flonum_magnitude(((C_word*)t0)[4]));
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.flonum#fp>= in k8543 */
static void C_ccall f_12189(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(5,c,5)))){
C_save_and_reclaim((void *)f_12189,c,av);}
a=C_alloc(5);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_12211,a[2]=t1,a[3]=t2,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
t5=C_i_flonump(t2);
t6=(C_truep(t5)?C_i_flonump(t3):C_SCHEME_FALSE);
if(C_truep(t6)){
t7=t1;{
C_word *av2=av;
av2[0]=t7;
av2[1]=C_ub_i_flonum_greater_or_equal_p(C_flonum_magnitude(t2),C_flonum_magnitude(t3));
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}
else{
t7=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_FLONUM_ERROR);
/* library.scm:1569: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[365]);
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=*((C_word*)lf[365]+1);
av2[1]=t4;
av2[2]=t7;
av2[3]=lf[453];
av2[4]=t2;
av2[5]=t3;
tp(6,av2);}}}

/* k12209 in chicken.flonum#fp>= in k8543 */
static void C_ccall f_12211(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_12211,c,av);}
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_ub_i_flonum_greater_or_equal_p(C_flonum_magnitude(((C_word*)t0)[3]),C_flonum_magnitude(((C_word*)t0)[4]));
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.flonum#fp<= in k8543 */
static void C_ccall f_12213(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(5,c,5)))){
C_save_and_reclaim((void *)f_12213,c,av);}
a=C_alloc(5);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_12235,a[2]=t1,a[3]=t2,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
t5=C_i_flonump(t2);
t6=(C_truep(t5)?C_i_flonump(t3):C_SCHEME_FALSE);
if(C_truep(t6)){
t7=t1;{
C_word *av2=av;
av2[0]=t7;
av2[1]=C_ub_i_flonum_less_or_equal_p(C_flonum_magnitude(t2),C_flonum_magnitude(t3));
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}
else{
t7=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_FLONUM_ERROR);
/* library.scm:1569: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[365]);
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=*((C_word*)lf[365]+1);
av2[1]=t4;
av2[2]=t7;
av2[3]=lf[455];
av2[4]=t2;
av2[5]=t3;
tp(6,av2);}}}

/* k12233 in chicken.flonum#fp<= in k8543 */
static void C_ccall f_12235(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_12235,c,av);}
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_ub_i_flonum_less_or_equal_p(C_flonum_magnitude(((C_word*)t0)[3]),C_flonum_magnitude(((C_word*)t0)[4]));
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.flonum#fpneg in k8543 */
static void C_ccall f_12237(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(8,c,4)))){
C_save_and_reclaim((void *)f_12237,c,av);}
a=C_alloc(8);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_12253,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_flonump(t2))){
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_a_i_flonum_negate(&a,1,t2);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t4=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_FLONUM_ERROR);
/* library.scm:1565: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[365]);
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=*((C_word*)lf[365]+1);
av2[1]=t3;
av2[2]=t4;
av2[3]=lf[457];
av2[4]=t2;
tp(5,av2);}}}

/* k12251 in chicken.flonum#fpneg in k8543 */
static void C_ccall f_12253(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,1)))){
C_save_and_reclaim((void *)f_12253,c,av);}
a=C_alloc(4);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_a_i_flonum_negate(&a,1,((C_word*)t0)[3]);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.flonum#fpmax in k8543 */
static void C_ccall f_12255(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(5,c,5)))){
C_save_and_reclaim((void *)f_12255,c,av);}
a=C_alloc(5);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_12277,a[2]=t1,a[3]=t2,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
t5=C_i_flonump(t2);
t6=(C_truep(t5)?C_i_flonump(t3):C_SCHEME_FALSE);
if(C_truep(t6)){
t7=t1;{
C_word *av2=av;
av2[0]=t7;
av2[1]=C_i_flonum_max(t2,t3);
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}
else{
t7=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_FLONUM_ERROR);
/* library.scm:1569: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[365]);
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=*((C_word*)lf[365]+1);
av2[1]=t4;
av2[2]=t7;
av2[3]=lf[459];
av2[4]=t2;
av2[5]=t3;
tp(6,av2);}}}

/* k12275 in chicken.flonum#fpmax in k8543 */
static void C_ccall f_12277(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_12277,c,av);}
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_i_flonum_max(((C_word*)t0)[3],((C_word*)t0)[4]);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.flonum#fpmin in k8543 */
static void C_ccall f_12279(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(5,c,5)))){
C_save_and_reclaim((void *)f_12279,c,av);}
a=C_alloc(5);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_12301,a[2]=t1,a[3]=t2,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
t5=C_i_flonump(t2);
t6=(C_truep(t5)?C_i_flonump(t3):C_SCHEME_FALSE);
if(C_truep(t6)){
t7=t1;{
C_word *av2=av;
av2[0]=t7;
av2[1]=C_i_flonum_min(t2,t3);
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}
else{
t7=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_FLONUM_ERROR);
/* library.scm:1569: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[365]);
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=*((C_word*)lf[365]+1);
av2[1]=t4;
av2[2]=t7;
av2[3]=lf[461];
av2[4]=t2;
av2[5]=t3;
tp(6,av2);}}}

/* k12299 in chicken.flonum#fpmin in k8543 */
static void C_ccall f_12301(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_12301,c,av);}
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_i_flonum_min(((C_word*)t0)[3],((C_word*)t0)[4]);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.flonum#fpfloor in k8543 */
static void C_ccall f_12303(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(8,c,4)))){
C_save_and_reclaim((void *)f_12303,c,av);}
a=C_alloc(8);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_12319,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_flonump(t2))){
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_flonum(&a,C_floor(C_flonum_magnitude(t2)));
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t4=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_FLONUM_ERROR);
/* library.scm:1565: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[365]);
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=*((C_word*)lf[365]+1);
av2[1]=t3;
av2[2]=t4;
av2[3]=lf[463];
av2[4]=t2;
tp(5,av2);}}}

/* k12317 in chicken.flonum#fpfloor in k8543 */
static void C_ccall f_12319(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,1)))){
C_save_and_reclaim((void *)f_12319,c,av);}
a=C_alloc(4);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_flonum(&a,C_floor(C_flonum_magnitude(((C_word*)t0)[3])));
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.flonum#fptruncate in k8543 */
static void C_ccall f_12321(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(8,c,4)))){
C_save_and_reclaim((void *)f_12321,c,av);}
a=C_alloc(8);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_12337,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_flonump(t2))){
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_flonum(&a,C_trunc(C_flonum_magnitude(t2)));
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t4=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_FLONUM_ERROR);
/* library.scm:1565: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[365]);
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=*((C_word*)lf[365]+1);
av2[1]=t3;
av2[2]=t4;
av2[3]=lf[465];
av2[4]=t2;
tp(5,av2);}}}

/* k12335 in chicken.flonum#fptruncate in k8543 */
static void C_ccall f_12337(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,1)))){
C_save_and_reclaim((void *)f_12337,c,av);}
a=C_alloc(4);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_flonum(&a,C_trunc(C_flonum_magnitude(((C_word*)t0)[3])));
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.flonum#fpround in k8543 */
static void C_ccall f_12339(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(8,c,4)))){
C_save_and_reclaim((void *)f_12339,c,av);}
a=C_alloc(8);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_12355,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_flonump(t2))){
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_flonum(&a,C_round(C_flonum_magnitude(t2)));
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t4=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_FLONUM_ERROR);
/* library.scm:1565: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[365]);
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=*((C_word*)lf[365]+1);
av2[1]=t3;
av2[2]=t4;
av2[3]=lf[467];
av2[4]=t2;
tp(5,av2);}}}

/* k12353 in chicken.flonum#fpround in k8543 */
static void C_ccall f_12355(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,1)))){
C_save_and_reclaim((void *)f_12355,c,av);}
a=C_alloc(4);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_flonum(&a,C_round(C_flonum_magnitude(((C_word*)t0)[3])));
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.flonum#fpceiling in k8543 */
static void C_ccall f_12357(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(8,c,4)))){
C_save_and_reclaim((void *)f_12357,c,av);}
a=C_alloc(8);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_12373,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_flonump(t2))){
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_flonum(&a,C_ceil(C_flonum_magnitude(t2)));
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t4=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_FLONUM_ERROR);
/* library.scm:1565: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[365]);
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=*((C_word*)lf[365]+1);
av2[1]=t3;
av2[2]=t4;
av2[3]=lf[469];
av2[4]=t2;
tp(5,av2);}}}

/* k12371 in chicken.flonum#fpceiling in k8543 */
static void C_ccall f_12373(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,1)))){
C_save_and_reclaim((void *)f_12373,c,av);}
a=C_alloc(4);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_flonum(&a,C_ceil(C_flonum_magnitude(((C_word*)t0)[3])));
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.flonum#fpsin in k8543 */
static void C_ccall f_12375(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(8,c,4)))){
C_save_and_reclaim((void *)f_12375,c,av);}
a=C_alloc(8);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_12391,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_flonump(t2))){
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_flonum(&a,C_sin(C_flonum_magnitude(t2)));
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t4=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_FLONUM_ERROR);
/* library.scm:1565: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[365]);
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=*((C_word*)lf[365]+1);
av2[1]=t3;
av2[2]=t4;
av2[3]=lf[471];
av2[4]=t2;
tp(5,av2);}}}

/* k12389 in chicken.flonum#fpsin in k8543 */
static void C_ccall f_12391(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,1)))){
C_save_and_reclaim((void *)f_12391,c,av);}
a=C_alloc(4);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_flonum(&a,C_sin(C_flonum_magnitude(((C_word*)t0)[3])));
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.flonum#fpcos in k8543 */
static void C_ccall f_12393(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(8,c,4)))){
C_save_and_reclaim((void *)f_12393,c,av);}
a=C_alloc(8);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_12409,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_flonump(t2))){
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_flonum(&a,C_cos(C_flonum_magnitude(t2)));
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t4=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_FLONUM_ERROR);
/* library.scm:1565: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[365]);
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=*((C_word*)lf[365]+1);
av2[1]=t3;
av2[2]=t4;
av2[3]=lf[473];
av2[4]=t2;
tp(5,av2);}}}

/* k12407 in chicken.flonum#fpcos in k8543 */
static void C_ccall f_12409(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,1)))){
C_save_and_reclaim((void *)f_12409,c,av);}
a=C_alloc(4);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_flonum(&a,C_cos(C_flonum_magnitude(((C_word*)t0)[3])));
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.flonum#fptan in k8543 */
static void C_ccall f_12411(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(8,c,4)))){
C_save_and_reclaim((void *)f_12411,c,av);}
a=C_alloc(8);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_12427,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_flonump(t2))){
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_flonum(&a,C_tan(C_flonum_magnitude(t2)));
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t4=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_FLONUM_ERROR);
/* library.scm:1565: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[365]);
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=*((C_word*)lf[365]+1);
av2[1]=t3;
av2[2]=t4;
av2[3]=lf[475];
av2[4]=t2;
tp(5,av2);}}}

/* k12425 in chicken.flonum#fptan in k8543 */
static void C_ccall f_12427(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,1)))){
C_save_and_reclaim((void *)f_12427,c,av);}
a=C_alloc(4);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_flonum(&a,C_tan(C_flonum_magnitude(((C_word*)t0)[3])));
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.flonum#fpasin in k8543 */
static void C_ccall f_12429(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(8,c,4)))){
C_save_and_reclaim((void *)f_12429,c,av);}
a=C_alloc(8);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_12445,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_flonump(t2))){
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_flonum(&a,C_asin(C_flonum_magnitude(t2)));
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t4=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_FLONUM_ERROR);
/* library.scm:1565: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[365]);
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=*((C_word*)lf[365]+1);
av2[1]=t3;
av2[2]=t4;
av2[3]=lf[477];
av2[4]=t2;
tp(5,av2);}}}

/* k12443 in chicken.flonum#fpasin in k8543 */
static void C_ccall f_12445(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,1)))){
C_save_and_reclaim((void *)f_12445,c,av);}
a=C_alloc(4);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_flonum(&a,C_asin(C_flonum_magnitude(((C_word*)t0)[3])));
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.flonum#fpacos in k8543 */
static void C_ccall f_12447(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(8,c,4)))){
C_save_and_reclaim((void *)f_12447,c,av);}
a=C_alloc(8);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_12463,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_flonump(t2))){
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_flonum(&a,C_acos(C_flonum_magnitude(t2)));
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t4=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_FLONUM_ERROR);
/* library.scm:1565: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[365]);
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=*((C_word*)lf[365]+1);
av2[1]=t3;
av2[2]=t4;
av2[3]=lf[479];
av2[4]=t2;
tp(5,av2);}}}

/* k12461 in chicken.flonum#fpacos in k8543 */
static void C_ccall f_12463(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,1)))){
C_save_and_reclaim((void *)f_12463,c,av);}
a=C_alloc(4);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_flonum(&a,C_acos(C_flonum_magnitude(((C_word*)t0)[3])));
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.flonum#fpatan in k8543 */
static void C_ccall f_12465(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(8,c,4)))){
C_save_and_reclaim((void *)f_12465,c,av);}
a=C_alloc(8);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_12481,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_flonump(t2))){
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_flonum(&a,C_atan(C_flonum_magnitude(t2)));
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t4=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_FLONUM_ERROR);
/* library.scm:1565: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[365]);
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=*((C_word*)lf[365]+1);
av2[1]=t3;
av2[2]=t4;
av2[3]=lf[481];
av2[4]=t2;
tp(5,av2);}}}

/* k12479 in chicken.flonum#fpatan in k8543 */
static void C_ccall f_12481(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,1)))){
C_save_and_reclaim((void *)f_12481,c,av);}
a=C_alloc(4);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_flonum(&a,C_atan(C_flonum_magnitude(((C_word*)t0)[3])));
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.flonum#fpatan2 in k8543 */
static void C_ccall f_12483(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(9,c,5)))){
C_save_and_reclaim((void *)f_12483,c,av);}
a=C_alloc(9);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_12505,a[2]=t1,a[3]=t2,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
t5=C_i_flonump(t2);
t6=(C_truep(t5)?C_i_flonump(t3):C_SCHEME_FALSE);
if(C_truep(t6)){
t7=t1;{
C_word *av2=av;
av2[0]=t7;
av2[1]=C_flonum(&a,C_atan2(C_flonum_magnitude(t2),C_flonum_magnitude(t3)));
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}
else{
t7=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_FLONUM_ERROR);
/* library.scm:1569: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[365]);
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=*((C_word*)lf[365]+1);
av2[1]=t4;
av2[2]=t7;
av2[3]=lf[483];
av2[4]=t2;
av2[5]=t3;
tp(6,av2);}}}

/* k12503 in chicken.flonum#fpatan2 in k8543 */
static void C_ccall f_12505(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,1)))){
C_save_and_reclaim((void *)f_12505,c,av);}
a=C_alloc(4);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_flonum(&a,C_atan2(C_flonum_magnitude(((C_word*)t0)[3]),C_flonum_magnitude(((C_word*)t0)[4])));
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.flonum#fpexp in k8543 */
static void C_ccall f_12507(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(8,c,4)))){
C_save_and_reclaim((void *)f_12507,c,av);}
a=C_alloc(8);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_12523,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_flonump(t2))){
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_flonum(&a,C_exp(C_flonum_magnitude(t2)));
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t4=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_FLONUM_ERROR);
/* library.scm:1565: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[365]);
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=*((C_word*)lf[365]+1);
av2[1]=t3;
av2[2]=t4;
av2[3]=lf[485];
av2[4]=t2;
tp(5,av2);}}}

/* k12521 in chicken.flonum#fpexp in k8543 */
static void C_ccall f_12523(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,1)))){
C_save_and_reclaim((void *)f_12523,c,av);}
a=C_alloc(4);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_flonum(&a,C_exp(C_flonum_magnitude(((C_word*)t0)[3])));
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.flonum#fpexpt in k8543 */
static void C_ccall f_12525(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(9,c,5)))){
C_save_and_reclaim((void *)f_12525,c,av);}
a=C_alloc(9);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_12547,a[2]=t1,a[3]=t2,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
t5=C_i_flonump(t2);
t6=(C_truep(t5)?C_i_flonump(t3):C_SCHEME_FALSE);
if(C_truep(t6)){
t7=t1;{
C_word *av2=av;
av2[0]=t7;
av2[1]=C_a_i_flonum_expt(&a,2,t2,t3);
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}
else{
t7=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_FLONUM_ERROR);
/* library.scm:1569: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[365]);
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=*((C_word*)lf[365]+1);
av2[1]=t4;
av2[2]=t7;
av2[3]=lf[487];
av2[4]=t2;
av2[5]=t3;
tp(6,av2);}}}

/* k12545 in chicken.flonum#fpexpt in k8543 */
static void C_ccall f_12547(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,1)))){
C_save_and_reclaim((void *)f_12547,c,av);}
a=C_alloc(4);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_a_i_flonum_expt(&a,2,((C_word*)t0)[3],((C_word*)t0)[4]);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.flonum#fplog in k8543 */
static void C_ccall f_12549(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(8,c,4)))){
C_save_and_reclaim((void *)f_12549,c,av);}
a=C_alloc(8);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_12565,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_flonump(t2))){
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_flonum(&a,C_log(C_flonum_magnitude(t2)));
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t4=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_FLONUM_ERROR);
/* library.scm:1565: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[365]);
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=*((C_word*)lf[365]+1);
av2[1]=t3;
av2[2]=t4;
av2[3]=lf[489];
av2[4]=t2;
tp(5,av2);}}}

/* k12563 in chicken.flonum#fplog in k8543 */
static void C_ccall f_12565(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,1)))){
C_save_and_reclaim((void *)f_12565,c,av);}
a=C_alloc(4);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_flonum(&a,C_log(C_flonum_magnitude(((C_word*)t0)[3])));
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.flonum#fpsqrt in k8543 */
static void C_ccall f_12567(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(8,c,4)))){
C_save_and_reclaim((void *)f_12567,c,av);}
a=C_alloc(8);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_12583,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_flonump(t2))){
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_flonum(&a,C_sqrt(C_flonum_magnitude(t2)));
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t4=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_FLONUM_ERROR);
/* library.scm:1565: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[365]);
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=*((C_word*)lf[365]+1);
av2[1]=t3;
av2[2]=t4;
av2[3]=lf[491];
av2[4]=t2;
tp(5,av2);}}}

/* k12581 in chicken.flonum#fpsqrt in k8543 */
static void C_ccall f_12583(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,1)))){
C_save_and_reclaim((void *)f_12583,c,av);}
a=C_alloc(4);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_flonum(&a,C_sqrt(C_flonum_magnitude(((C_word*)t0)[3])));
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.flonum#fpabs in k8543 */
static void C_ccall f_12585(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(8,c,4)))){
C_save_and_reclaim((void *)f_12585,c,av);}
a=C_alloc(8);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_12601,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_flonump(t2))){
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_flonum(&a,C_fabs(C_flonum_magnitude(t2)));
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t4=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_FLONUM_ERROR);
/* library.scm:1565: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[365]);
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=*((C_word*)lf[365]+1);
av2[1]=t3;
av2[2]=t4;
av2[3]=lf[493];
av2[4]=t2;
tp(5,av2);}}}

/* k12599 in chicken.flonum#fpabs in k8543 */
static void C_ccall f_12601(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,1)))){
C_save_and_reclaim((void *)f_12601,c,av);}
a=C_alloc(4);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_flonum(&a,C_fabs(C_flonum_magnitude(((C_word*)t0)[3])));
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.flonum#fpinteger? in k8543 */
static void C_ccall f_12603(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(4,c,4)))){
C_save_and_reclaim((void *)f_12603,c,av);}
a=C_alloc(4);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_12619,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_flonump(t2))){
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_u_i_fpintegerp(t2);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t4=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_FLONUM_ERROR);
/* library.scm:1565: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[365]);
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=*((C_word*)lf[365]+1);
av2[1]=t3;
av2[2]=t4;
av2[3]=lf[495];
av2[4]=t2;
tp(5,av2);}}}

/* k12617 in chicken.flonum#fpinteger? in k8543 */
static void C_ccall f_12619(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_12619,c,av);}
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_u_i_fpintegerp(((C_word*)t0)[3]);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.flonum#flonum-print-precision in k8543 */
static void C_ccall f_12621(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,c,3)))){
C_save_and_reclaim((void *)f_12621,c,av);}
a=C_alloc(5);
t2=C_rest_nullp(c,2);
t3=(C_truep(t2)?C_SCHEME_FALSE:C_get_rest_arg(c,2,av,2,t0));
t4=C_get_print_precision();
if(C_truep(t3)){
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_12631,a[2]=t3,a[3]=t1,a[4]=t4,tmp=(C_word)a,a+=5,tmp);
/* library.scm:1698: ##sys#check-fixnum */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[102]+1));
C_word av2[4];
av2[0]=*((C_word*)lf[102]+1);
av2[1]=t5;
av2[2]=t3;
av2[3]=lf[497];
tp(4,av2);}}
else{
t5=t1;{
C_word *av2=av;
av2[0]=t5;
av2[1]=t4;
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}}

/* k12629 in chicken.flonum#flonum-print-precision in k8543 */
static void C_ccall f_12631(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_12631,c,av);}
t2=C_set_print_precision(((C_word*)t0)[2]);
t3=((C_word*)t0)[3];{
C_word *av2=av;
av2[0]=t3;
av2[1]=((C_word*)t0)[4];
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* make-complex in k8543 */
static void C_fcall f_12643(C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,0,3)))){
C_save_and_reclaim_args((void *)trf_12643,3,t1,t2,t3);}
a=C_alloc(5);
t4=C_eqp(t3,C_fix(0));
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_12653,a[2]=t1,a[3]=t2,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
if(C_truep(t4)){
t6=t5;{
C_word av2[2];
av2[0]=t6;
av2[1]=t4;
f_12653(2,av2);}}
else{
if(C_truep(C_i_flonump(t3))){
/* library.scm:1718: chicken.flonum#fp= */
t6=*((C_word*)lf[446]+1);{
C_word av2[4];
av2[0]=t6;
av2[1]=t5;
av2[2]=t3;
av2[3]=lf[503];
((C_proc)(void*)(*((C_word*)t6+1)))(4,av2);}}
else{
t6=t5;{
C_word av2[2];
av2[0]=t6;
av2[1]=C_SCHEME_FALSE;
f_12653(2,av2);}}}}

/* k12651 in make-complex in k8543 */
static void C_ccall f_12653(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,c,2)))){
C_save_and_reclaim((void *)f_12653,c,av);}
a=C_alloc(5);
if(C_truep(t1)){
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}
else{
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_12657,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[2],tmp=(C_word)a,a+=5,tmp);
if(C_truep(C_i_inexactp(((C_word*)t0)[4]))){
/* library.scm:1721: scheme#exact->inexact */
t3=*((C_word*)lf[62]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t3+1)))(3,av2);}}
else{
t3=t2;{
C_word *av2=av;
av2[0]=t3;
av2[1]=((C_word*)t0)[3];
f_12657(2,av2);}}}}

/* k12655 in k12651 in make-complex in k8543 */
static void C_ccall f_12657(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(14,c,1)))){
C_save_and_reclaim((void *)f_12657,c,av);}
a=C_alloc(14);
if(C_truep(C_i_inexactp(((C_word*)t0)[2]))){
t2=C_a_i_exact_to_inexact(&a,1,((C_word*)t0)[3]);
t3=C_a_i_cplxnum(&a,2,t1,t2);
t4=((C_word*)t0)[4];{
C_word *av2=av;
av2[0]=t4;
av2[1]=t3;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t2=C_a_i_cplxnum(&a,2,t1,((C_word*)t0)[3]);
t3=((C_word*)t0)[4];{
C_word *av2=av;
av2[0]=t3;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}}

/* scheme#make-rectangular in k8543 */
static void C_ccall f_12679(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(5,c,3)))){
C_save_and_reclaim((void *)f_12679,c,av);}
a=C_alloc(5);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_12683,a[2]=t1,a[3]=t2,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
/* library.scm:1726: ##sys#check-real */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[363]+1));
C_word *av2=av;
av2[0]=*((C_word*)lf[363]+1);
av2[1]=t4;
av2[2]=t2;
av2[3]=lf[505];
tp(4,av2);}}

/* k12681 in scheme#make-rectangular in k8543 */
static void C_ccall f_12683(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,c,3)))){
C_save_and_reclaim((void *)f_12683,c,av);}
a=C_alloc(5);
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_12686,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
/* library.scm:1727: ##sys#check-real */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[363]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[363]+1);
av2[1]=t2;
av2[2]=((C_word*)t0)[4];
av2[3]=lf[505];
tp(4,av2);}}

/* k12684 in k12681 in scheme#make-rectangular in k8543 */
static void C_ccall f_12686(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_12686,c,av);}
/* library.scm:1728: make-complex */
f_12643(((C_word*)t0)[2],((C_word*)t0)[3],((C_word*)t0)[4]);}

/* scheme#make-polar in k8543 */
static void C_ccall f_12691(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(5,c,3)))){
C_save_and_reclaim((void *)f_12691,c,av);}
a=C_alloc(5);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_12695,a[2]=t2,a[3]=t1,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
/* library.scm:1732: ##sys#check-real */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[363]+1));
C_word *av2=av;
av2[0]=*((C_word*)lf[363]+1);
av2[1]=t4;
av2[2]=t2;
av2[3]=lf[507];
tp(4,av2);}}

/* k12693 in scheme#make-polar in k8543 */
static void C_ccall f_12695(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,c,3)))){
C_save_and_reclaim((void *)f_12695,c,av);}
a=C_alloc(5);
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_12698,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
/* library.scm:1733: ##sys#check-real */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[363]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[363]+1);
av2[1]=t2;
av2[2]=((C_word*)t0)[4];
av2[3]=lf[507];
tp(4,av2);}}

/* k12696 in k12693 in scheme#make-polar in k8543 */
static void C_ccall f_12698(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,2)))){
C_save_and_reclaim((void *)f_12698,c,av);}
a=C_alloc(4);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_12701,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* library.scm:1734: scheme#exact->inexact */
t3=*((C_word*)lf[62]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=((C_word*)t0)[4];
((C_proc)(void*)(*((C_word*)t3+1)))(3,av2);}}

/* k12699 in k12696 in k12693 in scheme#make-polar in k8543 */
static void C_ccall f_12701(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(74,c,3)))){
C_save_and_reclaim((void *)f_12701,c,av);}
a=C_alloc(74);
t2=C_s_a_i_times(&a,2,((C_word*)t0)[2],C_a_i_cos(&a,1,t1));
t3=C_s_a_i_times(&a,2,((C_word*)t0)[2],C_a_i_sin(&a,1,t1));
/* library.scm:1735: make-complex */
f_12643(((C_word*)t0)[3],t2,t3);}

/* scheme#real-part in k8543 */
static void C_ccall f_12714(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_12714,c,av);}
if(C_truep(C_i_cplxnump(t2))){
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_u_i_cplxnum_real(t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
if(C_truep(C_i_numberp(t2))){
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
/* library.scm:1743: ##sys#error-bad-number */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[373]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[373]+1);
av2[1]=t1;
av2[2]=t2;
av2[3]=lf[509];
tp(4,av2);}}}}

/* scheme#imag-part in k8543 */
static void C_ccall f_12737(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_12737,c,av);}
if(C_truep(C_i_cplxnump(t2))){
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_u_i_cplxnum_imag(t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
if(C_truep(C_i_flonump(t2))){
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=lf[503];
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
if(C_truep(C_i_numberp(t2))){
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_fix(0);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
/* library.scm:1750: ##sys#error-bad-number */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[373]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[373]+1);
av2[1]=t1;
av2[2]=t2;
av2[3]=lf[511];
tp(4,av2);}}}}}

/* scheme#angle in k8543 */
static void C_ccall f_12763(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(4,c,2)))){
C_save_and_reclaim((void *)f_12763,c,av);}
a=C_alloc(4);
t3=C_i_check_number_2(t2,lf[513]);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_12772,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* library.scm:1756: scheme#imag-part */
t5=*((C_word*)lf[510]+1);{
C_word *av2=av;
av2[0]=t5;
av2[1]=t4;
av2[2]=t2;
((C_proc)(void*)(*((C_word*)t5+1)))(3,av2);}}

/* k12770 in scheme#angle in k8543 */
static void C_ccall f_12772(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(15,c,2)))){
C_save_and_reclaim((void *)f_12772,c,av);}
a=C_alloc(15);
t2=C_a_i_exact_to_inexact(&a,1,t1);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_12777,a[2]=((C_word*)t0)[2],a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* library.scm:1757: scheme#real-part */
t4=*((C_word*)lf[508]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t4;
av2[1]=t3;
av2[2]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t4+1)))(3,av2);}}

/* k12775 in k12770 in scheme#angle in k8543 */
static void C_ccall f_12777(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(15,c,1)))){
C_save_and_reclaim((void *)f_12777,c,av);}
a=C_alloc(15);
t2=C_a_i_exact_to_inexact(&a,1,t1);
t3=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_a_i_atan2(&a,2,((C_word*)t0)[3],t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* scheme#magnitude in k8543 */
static void C_ccall f_12779(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(95,c,3)))){
C_save_and_reclaim((void *)f_12779,c,av);}
a=C_alloc(95);
if(C_truep(C_i_cplxnump(t2))){
t3=C_u_i_cplxnum_real(t2);
t4=C_u_i_cplxnum_imag(t2);
t5=C_s_a_i_times(&a,2,t3,t3);
t6=C_s_a_i_times(&a,2,t4,t4);
t7=C_s_a_i_plus(&a,2,t5,t6);
/* library.scm:1764: scheme#sqrt */
t8=*((C_word*)lf[515]+1);{
C_word *av2=av;
av2[0]=t8;
av2[1]=t1;
av2[2]=t7;
((C_proc)(void*)(*((C_word*)t8+1)))(3,av2);}}
else{
if(C_truep(C_i_numberp(t2))){
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_s_a_i_abs(&a,1,t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
/* library.scm:1766: ##sys#error-bad-number */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[373]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[373]+1);
av2[1]=t1;
av2[2]=t2;
av2[3]=lf[516];
tp(4,av2);}}}}

/* ratnum in k8543 */
static C_word C_fcall f_12823(C_word *a,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_stack_overflow_check;{}
switch(t2){
case C_fix(1):
return(t1);
case C_fix(-1):
return(C_s_a_u_i_integer_negate(&a,1,t1));
default:
if(C_truep(C_i_negativep(t2))){
t3=C_s_a_u_i_integer_negate(&a,1,t1);
t4=C_s_a_u_i_integer_negate(&a,1,t2);
return(C_a_i_ratnum(&a,2,t3,t4));}
else{
return(C_a_i_ratnum(&a,2,t1,t2));}}}

/* scheme#numerator in k8543 */
static void C_ccall f_12869(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(6,c,5)))){
C_save_and_reclaim((void *)f_12869,c,av);}
a=C_alloc(6);
if(C_truep(C_i_exact_integerp(t2))){
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
if(C_truep(C_i_flonump(t2))){
if(C_truep(C_i_not(C_i_finitep(t2)))){
/* library.scm:1786: bad-inexact */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[519]);
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[519]+1);
av2[1]=t1;
av2[2]=lf[520];
av2[3]=t2;
tp(4,av2);}}
else{
if(C_truep(C_u_i_fpintegerp(t2))){
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12893,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12897,a[2]=t3,tmp=(C_word)a,a+=3,tmp);
/* library.scm:1788: scheme#inexact->exact */
t5=*((C_word*)lf[521]+1);{
C_word *av2=av;
av2[0]=t5;
av2[1]=t4;
av2[2]=t2;
((C_proc)(void*)(*((C_word*)t5+1)))(3,av2);}}}}
else{
if(C_truep(C_i_ratnump(t2))){
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_u_i_ratnum_num(t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
/* library.scm:1790: ##sys#signal-hook */
t3=C_fast_retrieve(lf[194]);{
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=t3;
av2[1]=t1;
av2[2]=lf[260];
av2[3]=lf[520];
av2[4]=lf[522];
av2[5]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(6,av2);}}}}}

/* k12891 in scheme#numerator in k8543 */
static void C_ccall f_12893(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(11,c,1)))){
C_save_and_reclaim((void *)f_12893,c,av);}
a=C_alloc(11);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_a_i_exact_to_inexact(&a,1,t1);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* k12895 in scheme#numerator in k8543 */
static void C_ccall f_12897(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_12897,c,av);}
/* library.scm:1788: scheme#numerator */
t2=*((C_word*)lf[518]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=t1;
((C_proc)(void*)(*((C_word*)t2+1)))(3,av2);}}

/* scheme#denominator in k8543 */
static void C_ccall f_12915(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(6,c,5)))){
C_save_and_reclaim((void *)f_12915,c,av);}
a=C_alloc(6);
if(C_truep(C_i_exact_integerp(t2))){
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_fix(1);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
if(C_truep(C_i_flonump(t2))){
if(C_truep(C_i_not(C_i_finitep(t2)))){
/* library.scm:1798: bad-inexact */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[519]);
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[519]+1);
av2[1]=t1;
av2[2]=lf[524];
av2[3]=t2;
tp(4,av2);}}
else{
if(C_truep(C_u_i_fpintegerp(t2))){
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=lf[525];
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12939,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12943,a[2]=t3,tmp=(C_word)a,a+=3,tmp);
/* library.scm:1800: scheme#inexact->exact */
t5=*((C_word*)lf[521]+1);{
C_word *av2=av;
av2[0]=t5;
av2[1]=t4;
av2[2]=t2;
((C_proc)(void*)(*((C_word*)t5+1)))(3,av2);}}}}
else{
if(C_truep(C_i_ratnump(t2))){
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_u_i_ratnum_denom(t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
/* library.scm:1802: ##sys#signal-hook */
t3=C_fast_retrieve(lf[194]);{
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=t3;
av2[1]=t1;
av2[2]=lf[260];
av2[3]=lf[520];
av2[4]=lf[526];
av2[5]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(6,av2);}}}}}

/* k12937 in scheme#denominator in k8543 */
static void C_ccall f_12939(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(11,c,1)))){
C_save_and_reclaim((void *)f_12939,c,av);}
a=C_alloc(11);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_a_i_exact_to_inexact(&a,1,t1);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* k12941 in scheme#denominator in k8543 */
static void C_ccall f_12943(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_12943,c,av);}
/* library.scm:1800: scheme#denominator */
t2=*((C_word*)lf[523]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=t1;
((C_proc)(void*)(*((C_word*)t2+1)))(3,av2);}}

/* ##sys#extended-signum in k8543 */
static void C_ccall f_12961(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(26,c,3)))){
C_save_and_reclaim((void *)f_12961,c,av);}
a=C_alloc(26);
if(C_truep(C_i_ratnump(t2))){
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_u_i_integer_signum(C_u_i_ratnum_num(t2));
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
if(C_truep(C_i_cplxnump(t2))){
t3=C_u_i_cplxnum_imag(t2);
t4=C_a_i_exact_to_inexact(&a,1,t3);
t5=C_u_i_cplxnum_real(t2);
t6=C_a_i_exact_to_inexact(&a,1,t5);
t7=C_flonum(&a,C_atan2(C_flonum_magnitude(t4),C_flonum_magnitude(t6)));
/* library.scm:1809: scheme#make-polar */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[506]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[506]+1);
av2[1]=t1;
av2[2]=C_fix(1);
av2[3]=t7;
tp(4,av2);}}
else{
/* library.scm:1810: ##sys#error-bad-number */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[373]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[373]+1);
av2[1]=t1;
av2[2]=t2;
av2[3]=lf[528];
tp(4,av2);}}}}

/* doloop2218 in deliver in scheme#inexact->exact in k8543 */
static void C_fcall f_13002(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,0,3)))){
C_save_and_reclaim_args((void *)trf_13002,4,t0,t1,t2,t3);}
a=C_alloc(5);
if(C_truep(C_u_i_fpintegerp(t2))){
t4=t1;{
C_word av2[2];
av2[0]=t4;
av2[1]=t3;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_13013,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
/* library.scm:1818: chicken.flonum#fp* */
t5=*((C_word*)lf[438]+1);{
C_word av2[4];
av2[0]=t5;
av2[1]=t4;
av2[2]=t2;
av2[3]=lf[532];
((C_proc)(void*)(*((C_word*)t5+1)))(4,av2);}}}

/* k13011 in doloop2218 in deliver in scheme#inexact->exact in k8543 */
static void C_ccall f_13013(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_13013,c,av);}
t2=((C_word*)((C_word*)t0)[2])[1];
f_13002(t2,((C_word*)t0)[3],t1,C_fixnum_plus(((C_word*)t0)[4],C_fix(1)));}

/* deliver in scheme#inexact->exact in k8543 */
static void C_fcall f_13019(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(15,0,4)))){
C_save_and_reclaim_args((void *)trf_13019,4,t0,t1,t2,t3);}
a=C_alloc(15);
t4=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_13023,a[2]=t2,a[3]=t1,a[4]=t3,a[5]=((C_word*)t0)[2],tmp=(C_word)a,a+=6,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_13054,a[2]=t4,tmp=(C_word)a,a+=3,tmp);
t6=C_SCHEME_UNDEFINED;
t7=(*a=C_VECTOR_TYPE|1,a[1]=t6,tmp=(C_word)a,a+=2,tmp);
t8=C_set_block_item(t7,0,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_13002,a[2]=t7,a[3]=((C_word)li374),tmp=(C_word)a,a+=4,tmp));
t9=((C_word*)t7)[1];
f_13002(t9,t5,t2,C_fix(0));}

/* k13021 in deliver in scheme#inexact->exact in k8543 */
static void C_ccall f_13023(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(7,c,2)))){
C_save_and_reclaim((void *)f_13023,c,av);}
a=C_alloc(7);
t2=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_13050,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=t1,a[6]=((C_word*)t0)[5],tmp=(C_word)a,a+=7,tmp);
/* library.scm:1824: scheme#exact->inexact */
t3=*((C_word*)lf[62]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=t1;
((C_proc)(void*)(*((C_word*)t3+1)))(3,av2);}}

/* k13035 in k13048 in k13021 in deliver in scheme#inexact->exact in k8543 */
static void C_ccall f_13037(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_13037,c,av);}
/* library.scm:1826: ##sys#/-2 */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[529]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[529]+1);
av2[1]=((C_word*)t0)[2];
av2[2]=t1;
av2[3]=((C_word*)t0)[3];
tp(4,av2);}}

/* k13048 in k13021 in deliver in scheme#inexact->exact in k8543 */
static void C_ccall f_13050(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(42,c,3)))){
C_save_and_reclaim((void *)f_13050,c,av);}
a=C_alloc(42);
t2=C_s_a_i_times(&a,2,((C_word*)t0)[2],t1);
if(C_truep(C_i_finitep(t2))){
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_13037,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
t4=C_s_a_u_i_flo_to_int(&a,1,t2);
/* library.scm:1826: ##sys#/-2 */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[529]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[529]+1);
av2[1]=t3;
av2[2]=t4;
av2[3]=((C_word*)t0)[5];
tp(4,av2);}}
else{
/* library.scm:1827: ##sys#error-bad-inexact */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[374]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[374]+1);
av2[1]=((C_word*)t0)[3];
av2[2]=((C_word*)t0)[6];
av2[3]=lf[530];
tp(4,av2);}}}

/* k13052 in deliver in scheme#inexact->exact in k8543 */
static void C_ccall f_13054(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_13054,c,av);}
/* library.scm:1823: ##sys#integer-power */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[531]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[531]+1);
av2[1]=((C_word*)t0)[2];
av2[2]=C_fix(2);
av2[3]=t1;
tp(4,av2);}}

/* k13069 in k13073 in k13079 in scheme#inexact->exact in k8543 */
static void C_ccall f_13071(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_13071,c,av);}
/* library.scm:1831: deliver */
t2=((C_word*)t0)[2];
f_13019(t2,((C_word*)t0)[3],((C_word*)t0)[4],t1);}

/* k13073 in k13079 in scheme#inexact->exact in k8543 */
static void C_ccall f_13075(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(38,c,3)))){
C_save_and_reclaim((void *)f_13075,c,av);}
a=C_alloc(38);
t2=C_s_a_i_times(&a,2,((C_word*)t0)[2],t1);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_13071,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* library.scm:1834: ##sys#integer-power */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[531]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[531]+1);
av2[1]=t3;
av2[2]=C_fix(2);
av2[3]=*((C_word*)lf[428]+1);
tp(4,av2);}}

/* k13079 in scheme#inexact->exact in k8543 */
static void C_ccall f_13081(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,c,3)))){
C_save_and_reclaim((void *)f_13081,c,av);}
a=C_alloc(5);
t2=(C_truep(t1)?C_ub_i_flonum_greaterp(C_flonum_magnitude(((C_word*)t0)[2]),(double)-1.0):C_SCHEME_FALSE);
if(C_truep(t2)){
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_13075,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
/* library.scm:1831: scheme#expt */
t4=*((C_word*)lf[533]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t4;
av2[1]=t3;
av2[2]=lf[532];
av2[3]=*((C_word*)lf[428]+1);
((C_proc)(void*)(*((C_word*)t4+1)))(4,av2);}}
else{
/* library.scm:1835: deliver */
t3=((C_word*)t0)[3];
f_13019(t3,((C_word*)t0)[4],((C_word*)t0)[2],C_fix(1));}}

/* scheme#inexact->exact in k8543 */
static void C_ccall f_13085(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(9,c,4)))){
C_save_and_reclaim((void *)f_13085,c,av);}
a=C_alloc(9);
if(C_truep(C_i_exactp(t2))){
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
if(C_truep(C_i_flonump(t2))){
if(C_truep(C_u_i_fpintegerp(t2))){
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_s_a_u_i_flo_to_int(&a,1,t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
if(C_truep(C_u_i_flonum_finitep(t2))){
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_13019,a[2]=t2,a[3]=((C_word)li375),tmp=(C_word)a,a+=4,tmp);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_13081,a[2]=t2,a[3]=t3,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
/* library.scm:1829: chicken.flonum#fp< */
t5=*((C_word*)lf[450]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t5;
av2[1]=t4;
av2[2]=t2;
av2[3]=lf[525];
((C_proc)(void*)(*((C_word*)t5+1)))(4,av2);}}
else{
/* library.scm:1843: ##sys#error-bad-inexact */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[374]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[374]+1);
av2[1]=t1;
av2[2]=t2;
av2[3]=lf[530];
tp(4,av2);}}}}
else{
if(C_truep(C_i_cplxnump(t2))){
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_13125,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* library.scm:1845: scheme#inexact->exact */
t4=*((C_word*)lf[521]+1);{
C_word *av2=av;
av2[0]=t4;
av2[1]=t3;
av2[2]=C_u_i_cplxnum_real(t2);
((C_proc)(void*)(*((C_word*)t4+1)))(3,av2);}}
else{
/* library.scm:1847: ##sys#error-bad-number */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[373]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[373]+1);
av2[1]=t1;
av2[2]=t2;
av2[3]=lf[530];
tp(4,av2);}}}}}

/* k13123 in scheme#inexact->exact in k8543 */
static void C_ccall f_13125(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,2)))){
C_save_and_reclaim((void *)f_13125,c,av);}
a=C_alloc(4);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_13129,a[2]=((C_word*)t0)[2],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* library.scm:1846: scheme#inexact->exact */
t3=*((C_word*)lf[521]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=C_u_i_cplxnum_imag(((C_word*)t0)[3]);
((C_proc)(void*)(*((C_word*)t3+1)))(3,av2);}}

/* k13127 in k13123 in scheme#inexact->exact in k8543 */
static void C_ccall f_13129(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_13129,c,av);}
/* library.scm:1845: make-complex */
f_12643(((C_word*)t0)[2],((C_word*)t0)[3],t1);}

/* chicken.bitwise#bitwise-not in k8543 */
static void C_ccall f_13151(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(5,c,1)))){
C_save_and_reclaim((void *)f_13151,c,av);}
a=C_alloc(5);
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_s_a_i_bitwise_not(&a,1,t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* chicken.bitwise#bit->boolean in k8543 */
static void C_ccall f_13154(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_13154,c,av);}
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_i_bit_to_bool(t2,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* chicken.bitwise#integer-length in k8543 */
static void C_ccall f_13157(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_13157,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_i_integer_length(t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* chicken.bitwise#arithmetic-shift in k8543 */
static void C_ccall f_13160(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(5,c,1)))){
C_save_and_reclaim((void *)f_13160,c,av);}
a=C_alloc(5);
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_s_a_i_arithmetic_shift(&a,2,t2,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* scheme#/ in k8543 */
static void C_ccall f_13163(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +4,c,3)))){
C_save_and_reclaim((void*)f_13163,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+4);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
C_word t6;
if(C_truep(C_rest_nullp(c,3))){
/* library.scm:1882: ##sys#/-2 */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[529]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[529]+1);
av2[1]=t1;
av2[2]=C_fix(1);
av2[3]=t2;
tp(4,av2);}}
else{
t4=C_slot(t3,C_fix(1));
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_13184,a[2]=t1,a[3]=t4,tmp=(C_word)a,a+=4,tmp);
/* library.scm:1884: ##sys#/-2 */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[529]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[529]+1);
av2[1]=t5;
av2[2]=t2;
av2[3]=C_slot(t3,C_fix(0));
tp(4,av2);}}}

/* k13182 in scheme#/ in k8543 */
static void C_ccall f_13184(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(6,c,4)))){
C_save_and_reclaim((void *)f_13184,c,av);}
a=C_alloc(6);
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_13186,a[2]=t3,a[3]=((C_word)li384),tmp=(C_word)a,a+=4,tmp));
t5=((C_word*)t3)[1];
f_13186(t5,((C_word*)t0)[2],((C_word*)t0)[3],t1);}

/* loop in k13182 in scheme#/ in k8543 */
static void C_fcall f_13186(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,0,3)))){
C_save_and_reclaim_args((void *)trf_13186,4,t0,t1,t2,t3);}
a=C_alloc(5);
if(C_truep(C_i_nullp(t2))){
t4=t1;{
C_word av2[2];
av2[0]=t4;
av2[1]=t3;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t4=C_slot(t2,C_fix(1));
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_13204,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=t4,tmp=(C_word)a,a+=5,tmp);
/* library.scm:1888: ##sys#/-2 */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[529]+1));
C_word av2[4];
av2[0]=*((C_word*)lf[529]+1);
av2[1]=t5;
av2[2]=t3;
av2[3]=C_slot(t2,C_fix(0));
tp(4,av2);}}}

/* k13202 in loop in k13182 in scheme#/ in k8543 */
static void C_ccall f_13204(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_13204,c,av);}
/* library.scm:1887: loop */
t2=((C_word*)((C_word*)t0)[2])[1];
f_13186(t2,((C_word*)t0)[3],((C_word*)t0)[4],t1);}

/* ##sys#/-2 in k8543 */
static void C_ccall f_13214(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(5,c,5)))){
C_save_and_reclaim((void *)f_13214,c,av);}
a=C_alloc(5);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_13218,a[2]=t2,a[3]=t3,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
t5=C_eqp(t3,C_fix(0));
if(C_truep(t5)){
t6=C_fix((C_word)C_DIVISION_BY_ZERO_ERROR);
/* library.scm:1895: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[365]);
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=*((C_word*)lf[365]+1);
av2[1]=t4;
av2[2]=t6;
av2[3]=lf[546];
av2[4]=t2;
av2[5]=t3;
tp(6,av2);}}
else{
t6=t4;{
C_word *av2=av;
av2[0]=t6;
av2[1]=C_SCHEME_UNDEFINED;
f_13218(2,av2);}}}

/* k13216 in ##sys#/-2 in k8543 */
static void C_ccall f_13218(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word t19;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(117,c,4)))){
C_save_and_reclaim((void *)f_13218,c,av);}
a=C_alloc(117);
t2=(C_truep(C_i_exact_integerp(((C_word*)t0)[2]))?C_i_exact_integerp(((C_word*)t0)[3]):C_SCHEME_FALSE);
if(C_truep(t2)){
t3=C_s_a_u_i_integer_gcd(&a,2,((C_word*)t0)[2],((C_word*)t0)[3]);
t4=C_s_a_u_i_integer_quotient(&a,2,((C_word*)t0)[2],t3);
t5=C_s_a_u_i_integer_quotient(&a,2,((C_word*)t0)[3],t3);
/* library.scm:1898: ratnum */
t6=((C_word*)t0)[4];{
C_word *av2=av;
av2[0]=t6;
av2[1]=(
/* library.scm:1898: ratnum */
  f_12823(C_a_i(&a,21),t4,t5)
);
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}
else{
t3=C_i_cplxnump(((C_word*)t0)[2]);
t4=(C_truep(t3)?t3:C_i_cplxnump(((C_word*)t0)[3]));
if(C_truep(t4)){
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_13256,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[2],tmp=(C_word)a,a+=5,tmp);
/* library.scm:1901: scheme#real-part */
t6=*((C_word*)lf[508]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t6;
av2[1]=t5;
av2[2]=((C_word*)t0)[2];
((C_proc)(void*)(*((C_word*)t6+1)))(3,av2);}}
else{
t5=C_i_flonump(((C_word*)t0)[2]);
t6=(C_truep(t5)?t5:C_i_flonump(((C_word*)t0)[3]));
if(C_truep(t6)){
t7=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_13322,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* library.scm:1909: scheme#exact->inexact */
t8=*((C_word*)lf[62]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t8;
av2[1]=t7;
av2[2]=((C_word*)t0)[2];
((C_proc)(void*)(*((C_word*)t8+1)))(3,av2);}}
else{
if(C_truep(C_i_ratnump(((C_word*)t0)[2]))){
if(C_truep(C_i_ratnump(((C_word*)t0)[3]))){
t7=C_u_i_ratnum_num(((C_word*)t0)[2]);
t8=C_u_i_ratnum_denom(((C_word*)t0)[2]);
t9=C_u_i_ratnum_num(((C_word*)t0)[3]);
t10=C_u_i_ratnum_denom(((C_word*)t0)[3]);
t11=C_s_a_u_i_integer_gcd(&a,2,t7,t9);
t12=C_s_a_u_i_integer_gcd(&a,2,t8,t10);
t13=C_s_a_i_quotient(&a,2,t7,t11);
t14=C_s_a_i_quotient(&a,2,t10,t12);
t15=C_s_a_i_times(&a,2,t13,t14);
t16=C_s_a_i_quotient(&a,2,t8,t12);
t17=C_s_a_i_quotient(&a,2,t9,t11);
t18=C_s_a_i_times(&a,2,t16,t17);
/* library.scm:1919: ratnum */
t19=((C_word*)t0)[4];{
C_word *av2=av;
av2[0]=t19;
av2[1]=(
/* library.scm:1919: ratnum */
  f_12823(C_a_i(&a,21),t15,t18)
);
((C_proc)(void*)(*((C_word*)t19+1)))(2,av2);}}
else{
t7=C_u_i_ratnum_num(((C_word*)t0)[2]);
t8=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_13403,a[2]=t7,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
/* library.scm:1925: ##sys#internal-gcd */
f_15149(t8,lf[546],t7,((C_word*)t0)[3]);}}
else{
if(C_truep(C_i_ratnump(((C_word*)t0)[3]))){
t7=C_u_i_ratnum_num(((C_word*)t0)[3]);
t8=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_13442,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t7,a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
/* library.scm:1936: ##sys#internal-gcd */
f_15149(t8,lf[546],((C_word*)t0)[2],t7);}
else{
t7=C_i_numberp(((C_word*)t0)[2]);
if(C_truep(C_i_not(t7))){
/* library.scm:1942: ##sys#error-bad-number */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[373]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[373]+1);
av2[1]=((C_word*)t0)[4];
av2[2]=((C_word*)t0)[2];
av2[3]=lf[546];
tp(4,av2);}}
else{
/* library.scm:1943: ##sys#error-bad-number */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[373]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[373]+1);
av2[1]=((C_word*)t0)[4];
av2[2]=((C_word*)t0)[3];
av2[3]=lf[546];
tp(4,av2);}}}}}}}}

/* k13254 in k13216 in ##sys#/-2 in k8543 */
static void C_ccall f_13256(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,c,2)))){
C_save_and_reclaim((void *)f_13256,c,av);}
a=C_alloc(5);
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_13259,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
/* library.scm:1901: scheme#imag-part */
t3=*((C_word*)lf[510]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=((C_word*)t0)[4];
((C_proc)(void*)(*((C_word*)t3+1)))(3,av2);}}

/* k13257 in k13254 in k13216 in ##sys#/-2 in k8543 */
static void C_ccall f_13259(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(6,c,2)))){
C_save_and_reclaim((void *)f_13259,c,av);}
a=C_alloc(6);
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_13262,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
/* library.scm:1902: scheme#real-part */
t3=*((C_word*)lf[508]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=((C_word*)t0)[4];
((C_proc)(void*)(*((C_word*)t3+1)))(3,av2);}}

/* k13260 in k13257 in k13254 in k13216 in ##sys#/-2 in k8543 */
static void C_ccall f_13262(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(6,c,2)))){
C_save_and_reclaim((void *)f_13262,c,av);}
a=C_alloc(6);
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_13265,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
/* library.scm:1902: scheme#imag-part */
t3=*((C_word*)lf[510]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=((C_word*)t0)[5];
((C_proc)(void*)(*((C_word*)t3+1)))(3,av2);}}

/* k13263 in k13260 in k13257 in k13254 in k13216 in ##sys#/-2 in k8543 */
static void C_ccall f_13265(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(198,c,3)))){
C_save_and_reclaim((void *)f_13265,c,av);}
a=C_alloc(198);
t2=C_s_a_i_times(&a,2,((C_word*)t0)[2],((C_word*)t0)[2]);
t3=C_s_a_i_times(&a,2,t1,t1);
t4=C_s_a_i_plus(&a,2,t2,t3);
t5=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_13271,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[2],a[5]=((C_word*)t0)[5],a[6]=t1,a[7]=t4,tmp=(C_word)a,a+=8,tmp);
t6=C_s_a_i_times(&a,2,((C_word*)t0)[5],((C_word*)t0)[2]);
t7=C_s_a_i_times(&a,2,((C_word*)t0)[4],t1);
t8=C_s_a_i_plus(&a,2,t6,t7);
/* library.scm:1904: ##sys#/-2 */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[529]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[529]+1);
av2[1]=t5;
av2[2]=t8;
av2[3]=t4;
tp(4,av2);}}

/* k13269 in k13263 in k13260 in k13257 in k13254 in k13216 in ##sys#/-2 in k8543 */
static void C_ccall f_13271(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(99,c,3)))){
C_save_and_reclaim((void *)f_13271,c,av);}
a=C_alloc(99);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_13274,a[2]=((C_word*)t0)[2],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t3=C_s_a_i_times(&a,2,((C_word*)t0)[3],((C_word*)t0)[4]);
t4=C_s_a_i_times(&a,2,((C_word*)t0)[5],((C_word*)t0)[6]);
t5=C_s_a_i_minus(&a,2,t3,t4);
/* library.scm:1905: ##sys#/-2 */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[529]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[529]+1);
av2[1]=t2;
av2[2]=t5;
av2[3]=((C_word*)t0)[7];
tp(4,av2);}}

/* k13272 in k13269 in k13263 in k13260 in k13257 in k13254 in k13216 in ##sys#/-2 in k8543 */
static void C_ccall f_13274(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_13274,c,av);}
/* library.scm:1906: make-complex */
f_12643(((C_word*)t0)[2],((C_word*)t0)[3],t1);}

/* k13320 in k13216 in ##sys#/-2 in k8543 */
static void C_ccall f_13322(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,2)))){
C_save_and_reclaim((void *)f_13322,c,av);}
a=C_alloc(4);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_13326,a[2]=((C_word*)t0)[2],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* library.scm:1909: scheme#exact->inexact */
t3=*((C_word*)lf[62]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t3+1)))(3,av2);}}

/* k13324 in k13320 in k13216 in ##sys#/-2 in k8543 */
static void C_ccall f_13326(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_13326,c,av);}
/* library.scm:1909: chicken.flonum#fp/ */
t2=*((C_word*)lf[440]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=((C_word*)t0)[3];
av2[3]=t1;
((C_proc)(void*)(*((C_word*)t2+1)))(4,av2);}}

/* k13401 in k13216 in ##sys#/-2 in k8543 */
static void C_ccall f_13403(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(64,c,3)))){
C_save_and_reclaim((void *)f_13403,c,av);}
a=C_alloc(64);
t2=C_s_a_i_quotient(&a,2,((C_word*)t0)[2],t1);
t3=C_u_i_ratnum_denom(((C_word*)t0)[3]);
t4=C_s_a_i_quotient(&a,2,((C_word*)t0)[4],t1);
t5=C_s_a_i_times(&a,2,t3,t4);
if(C_truep(C_i_flonump(t5))){
/* library.scm:1929: ##sys#/-2 */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[529]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[529]+1);
av2[1]=((C_word*)t0)[5];
av2[2]=t2;
av2[3]=t5;
tp(4,av2);}}
else{
/* library.scm:1930: ratnum */
t6=((C_word*)t0)[5];{
C_word *av2=av;
av2[0]=t6;
av2[1]=(
/* library.scm:1930: ratnum */
  f_12823(C_a_i(&a,21),t2,t5)
);
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}}

/* k13440 in k13216 in ##sys#/-2 in k8543 */
static void C_ccall f_13442(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(64,c,3)))){
C_save_and_reclaim((void *)f_13442,c,av);}
a=C_alloc(64);
t2=C_s_a_i_quotient(&a,2,((C_word*)t0)[2],t1);
t3=C_u_i_ratnum_denom(((C_word*)t0)[3]);
t4=C_s_a_i_times(&a,2,t2,t3);
t5=C_s_a_i_quotient(&a,2,((C_word*)t0)[4],t1);
if(C_truep(C_i_flonump(t5))){
/* library.scm:1940: ##sys#/-2 */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[529]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[529]+1);
av2[1]=((C_word*)t0)[5];
av2[2]=t4;
av2[3]=t5;
tp(4,av2);}}
else{
/* library.scm:1941: ratnum */
t6=((C_word*)t0)[5];{
C_word *av2=av;
av2[0]=t6;
av2[1]=(
/* library.scm:1941: ratnum */
  f_12823(C_a_i(&a,21),t4,t5)
);
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}}

/* scheme#floor in k8543 */
static void C_ccall f_13497(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(34,c,3)))){
C_save_and_reclaim((void *)f_13497,c,av);}
a=C_alloc(34);
if(C_truep(C_i_exact_integerp(t2))){
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
if(C_truep(C_i_flonump(t2))){
/* library.scm:1948: chicken.flonum#fpfloor */
t3=*((C_word*)lf[462]+1);{
C_word *av2=av;
av2[0]=t3;
av2[1]=t1;
av2[2]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(3,av2);}}
else{
if(C_truep(C_i_ratnump(t2))){
t3=C_u_i_ratnum_num(t2);
t4=C_u_i_ratnum_denom(t2);
t5=C_s_a_i_quotient(&a,2,t3,t4);
t6=C_i_greater_or_equalp(t3,C_fix(0));
t7=t1;{
C_word *av2=av;
av2[0]=t7;
av2[1]=(C_truep(t6)?t5:C_s_a_i_minus(&a,2,t5,C_fix(1)));
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}
else{
/* library.scm:1953: ##sys#error-bad-real */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[364]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[364]+1);
av2[1]=t1;
av2[2]=t2;
av2[3]=lf[548];
tp(4,av2);}}}}}

/* scheme#ceiling in k8543 */
static void C_ccall f_13542(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(34,c,3)))){
C_save_and_reclaim((void *)f_13542,c,av);}
a=C_alloc(34);
if(C_truep(C_i_exact_integerp(t2))){
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
if(C_truep(C_i_flonump(t2))){
/* library.scm:1958: chicken.flonum#fpceiling */
t3=*((C_word*)lf[468]+1);{
C_word *av2=av;
av2[0]=t3;
av2[1]=t1;
av2[2]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(3,av2);}}
else{
if(C_truep(C_i_ratnump(t2))){
t3=C_u_i_ratnum_num(t2);
t4=C_u_i_ratnum_denom(t2);
t5=C_s_a_i_quotient(&a,2,t3,t4);
t6=C_i_greater_or_equalp(t3,C_fix(0));
t7=t1;{
C_word *av2=av;
av2[0]=t7;
av2[1]=(C_truep(t6)?C_s_a_i_plus(&a,2,t5,C_fix(1)):t5);
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}
else{
/* library.scm:1963: ##sys#error-bad-real */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[364]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[364]+1);
av2[1]=t1;
av2[2]=t2;
av2[3]=lf[550];
tp(4,av2);}}}}}

/* scheme#truncate in k8543 */
static void C_ccall f_13587(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(5,c,3)))){
C_save_and_reclaim((void *)f_13587,c,av);}
a=C_alloc(5);
if(C_truep(C_i_exact_integerp(t2))){
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
if(C_truep(C_i_flonump(t2))){
/* library.scm:1968: chicken.flonum#fptruncate */
t3=*((C_word*)lf[464]+1);{
C_word *av2=av;
av2[0]=t3;
av2[1]=t1;
av2[2]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(3,av2);}}
else{
if(C_truep(C_i_ratnump(t2))){
t3=C_u_i_ratnum_num(t2);
t4=C_u_i_ratnum_denom(t2);
t5=t1;{
C_word *av2=av;
av2[0]=t5;
av2[1]=C_s_a_i_quotient(&a,2,t3,t4);
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}
else{
/* library.scm:1972: ##sys#error-bad-real */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[364]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[364]+1);
av2[1]=t1;
av2[2]=t2;
av2[3]=lf[552];
tp(4,av2);}}}}}

/* scheme#round in k8543 */
static void C_ccall f_13624(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(36,c,3)))){
C_save_and_reclaim((void *)f_13624,c,av);}
a=C_alloc(36);
if(C_truep(C_i_exact_integerp(t2))){
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
if(C_truep(C_i_flonump(t2))){
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_a_i_flonum_round_proper(&a,1,t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
if(C_truep(C_i_ratnump(t2))){
t3=C_a_i_ratnum(&a,2,C_fix(1),C_fix(2));
t4=C_s_a_i_plus(&a,2,t2,t3);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_13644,a[2]=t4,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* library.scm:1981: scheme#floor */
t6=*((C_word*)lf[547]+1);{
C_word *av2=av;
av2[0]=t6;
av2[1]=t5;
av2[2]=t4;
((C_proc)(void*)(*((C_word*)t6+1)))(3,av2);}}
else{
/* library.scm:1983: ##sys#error-bad-real */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[364]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[364]+1);
av2[1]=t1;
av2[2]=t2;
av2[3]=lf[554];
tp(4,av2);}}}}}

/* k13642 in scheme#round in k8543 */
static void C_ccall f_13644(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(29,c,1)))){
C_save_and_reclaim((void *)f_13644,c,av);}
a=C_alloc(29);
t2=C_i_nequalp(t1,((C_word*)t0)[2]);
t3=((C_word*)t0)[3];{
C_word *av2=av;
av2[0]=t3;
av2[1]=(C_truep(t2)?(C_truep(C_i_oddp(t1))?C_s_a_i_minus(&a,2,t1,C_fix(1)):t1):t1);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* find-ratio-between in k8543 */
static void C_fcall f_13668(C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word *a;
loop:
if(C_unlikely(!C_demand(C_calculate_demand(67,0,4)))){
C_save_and_reclaim_args((void *)trf_13668,3,t1,t2,t3);}
a=C_alloc(67);
t4=C_SCHEME_UNDEFINED;
t5=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t6=C_set_block_item(t5,0,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_13671,a[2]=t5,a[3]=((C_word)li391),tmp=(C_word)a,a+=4,tmp));
if(C_truep(C_i_lessp(t3,t2))){
/* library.scm:1996: find-ratio-between */
t12=t1;
t13=t3;
t14=t2;
t1=t12;
t2=t13;
t3=t14;
goto loop;}
else{
t7=C_i_lessp(t2,t3);
if(C_truep(C_i_not(t7))){
t8=t1;{
C_word av2[2];
av2[0]=t8;
av2[1]=C_a_i_list2(&a,2,t2,C_fix(1));
((C_proc)(void*)(*((C_word*)t8+1)))(2,av2);}}
else{
if(C_truep(C_i_positivep(t2))){
/* library.scm:1998: sr */
t8=((C_word*)t5)[1];
f_13671(t8,t1,t2,t3);}
else{
if(C_truep(C_i_negativep(t3))){
t8=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_13782,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
t9=C_s_a_i_negate(&a,1,t3);
t10=C_s_a_i_negate(&a,1,t2);
/* library.scm:1999: sr */
t11=((C_word*)t5)[1];
f_13671(t11,t8,t9,t10);}
else{
t8=t1;{
C_word av2[2];
av2[0]=t8;
av2[1]=lf[556];
((C_proc)(void*)(*((C_word*)t8+1)))(2,av2);}}}}}}

/* sr in find-ratio-between in k8543 */
static void C_fcall f_13671(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(9,0,2)))){
C_save_and_reclaim_args((void *)trf_13671,4,t0,t1,t2,t3);}
a=C_alloc(9);
t4=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_13675,a[2]=t2,a[3]=t1,a[4]=((C_word*)t0)[2],a[5]=t3,tmp=(C_word)a,a+=6,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_13750,a[2]=t4,tmp=(C_word)a,a+=3,tmp);
/* library.scm:1987: scheme#floor */
t6=*((C_word*)lf[547]+1);{
C_word av2[3];
av2[0]=t6;
av2[1]=t5;
av2[2]=t2;
((C_proc)(void*)(*((C_word*)t6+1)))(3,av2);}}

/* k13673 in sr in find-ratio-between in k8543 */
static void C_ccall f_13675(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(10,c,2)))){
C_save_and_reclaim((void *)f_13675,c,av);}
a=C_alloc(10);
t2=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_13678,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],tmp=(C_word)a,a+=7,tmp);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_13746,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
/* library.scm:1988: scheme#floor */
t4=*((C_word*)lf[547]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t4;
av2[1]=t3;
av2[2]=((C_word*)t0)[5];
((C_proc)(void*)(*((C_word*)t4+1)))(3,av2);}}

/* k13676 in k13673 in sr in find-ratio-between in k8543 */
static void C_ccall f_13678(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(39,c,3)))){
C_save_and_reclaim((void *)f_13678,c,av);}
a=C_alloc(39);
t2=C_i_lessp(((C_word*)t0)[2],((C_word*)t0)[3]);
if(C_truep(C_i_not(t2))){
t3=((C_word*)t0)[4];{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_a_i_list2(&a,2,((C_word*)t0)[2],C_fix(1));
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
if(C_truep(C_i_nequalp(((C_word*)t0)[2],t1))){
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_13696,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
t4=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_13719,a[2]=((C_word*)t0)[5],a[3]=t3,a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[2],tmp=(C_word)a,a+=6,tmp);
t5=C_s_a_i_minus(&a,2,((C_word*)t0)[6],t1);
/* library.scm:1991: ##sys#/-2 */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[529]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[529]+1);
av2[1]=t4;
av2[2]=C_fix(1);
av2[3]=t5;
tp(4,av2);}}
else{
t3=C_s_a_i_plus(&a,2,C_fix(1),((C_word*)t0)[2]);
t4=((C_word*)t0)[4];{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_a_i_list2(&a,2,t3,C_fix(1));
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}}}

/* k13694 in k13676 in k13673 in sr in find-ratio-between in k8543 */
static void C_ccall f_13696(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(68,c,1)))){
C_save_and_reclaim((void *)f_13696,c,av);}
a=C_alloc(68);
t2=C_i_cadr(t1);
t3=C_u_i_car(t1);
t4=C_s_a_i_times(&a,2,((C_word*)t0)[2],t3);
t5=C_s_a_i_plus(&a,2,t2,t4);
t6=C_u_i_car(t1);
t7=((C_word*)t0)[3];{
C_word *av2=av;
av2[0]=t7;
av2[1]=C_a_i_list2(&a,2,t5,t6);
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}

/* k13717 in k13676 in k13673 in sr in find-ratio-between in k8543 */
static void C_ccall f_13719(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(34,c,3)))){
C_save_and_reclaim((void *)f_13719,c,av);}
a=C_alloc(34);
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_13723,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t1,tmp=(C_word)a,a+=5,tmp);
t3=C_s_a_i_minus(&a,2,((C_word*)t0)[4],((C_word*)t0)[5]);
/* library.scm:1992: ##sys#/-2 */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[529]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[529]+1);
av2[1]=t2;
av2[2]=C_fix(1);
av2[3]=t3;
tp(4,av2);}}

/* k13721 in k13717 in k13676 in k13673 in sr in find-ratio-between in k8543 */
static void C_ccall f_13723(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_13723,c,av);}
/* library.scm:1991: sr */
t2=((C_word*)((C_word*)t0)[2])[1];
f_13671(t2,((C_word*)t0)[3],((C_word*)t0)[4],t1);}

/* k13744 in k13673 in sr in find-ratio-between in k8543 */
static void C_ccall f_13746(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_13746,c,av);}
/* library.scm:1988: scheme#inexact->exact */
t2=*((C_word*)lf[521]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=t1;
((C_proc)(void*)(*((C_word*)t2+1)))(3,av2);}}

/* k13748 in sr in find-ratio-between in k8543 */
static void C_ccall f_13750(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_13750,c,av);}
/* library.scm:1987: scheme#inexact->exact */
t2=*((C_word*)lf[521]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=t1;
((C_proc)(void*)(*((C_word*)t2+1)))(3,av2);}}

/* k13780 in find-ratio-between in k8543 */
static void C_ccall f_13782(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(35,c,1)))){
C_save_and_reclaim((void *)f_13782,c,av);}
a=C_alloc(35);
t2=C_i_car(t1);
t3=C_s_a_i_negate(&a,1,t2);
t4=C_i_cadr(t1);
t5=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t5;
av2[1]=C_a_i_list2(&a,2,t3,t4);
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}

/* scheme#rationalize in k8543 */
static void C_ccall f_13818(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(66,c,3)))){
C_save_and_reclaim((void *)f_13818,c,av);}
a=C_alloc(66);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_13822,a[2]=t2,a[3]=t1,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_13841,a[2]=t4,tmp=(C_word)a,a+=3,tmp);
t6=C_s_a_i_minus(&a,2,t2,t3);
t7=C_s_a_i_plus(&a,2,t2,t3);
/* library.scm:2003: find-ratio-between */
f_13668(t5,t6,t7);}

/* k13820 in scheme#rationalize in k8543 */
static void C_ccall f_13822(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_13822,c,av);}
t2=C_i_inexactp(((C_word*)t0)[2]);
if(C_truep(t2)){
if(C_truep(t2)){
/* library.scm:2009: scheme#exact->inexact */
t3=*((C_word*)lf[62]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t3;
av2[1]=((C_word*)t0)[3];
av2[2]=t1;
((C_proc)(void*)(*((C_word*)t3+1)))(3,av2);}}
else{
t3=((C_word*)t0)[3];{
C_word *av2=av;
av2[0]=t3;
av2[1]=t1;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}}
else{
if(C_truep(C_i_inexactp(((C_word*)t0)[4]))){
/* library.scm:2009: scheme#exact->inexact */
t3=*((C_word*)lf[62]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t3;
av2[1]=((C_word*)t0)[3];
av2[2]=t1;
((C_proc)(void*)(*((C_word*)t3+1)))(3,av2);}}
else{
t3=((C_word*)t0)[3];{
C_word *av2=av;
av2[0]=t3;
av2[1]=t1;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}}}

/* k13839 in scheme#rationalize in k8543 */
static void C_ccall f_13841(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_13841,c,av);}{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=0;
av2[1]=((C_word*)t0)[2];
av2[2]=*((C_word*)lf[529]+1);
av2[3]=t1;
C_apply(4,av2);}}

/* scheme#max in k8543 */
static void C_ccall f_13843(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +6,c,5)))){
C_save_and_reclaim((void*)f_13843,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+6);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
t4=C_i_flonump(t2);
t5=C_SCHEME_UNDEFINED;
t6=(*a=C_VECTOR_TYPE|1,a[1]=t5,tmp=(C_word)a,a+=2,tmp);
t7=C_set_block_item(t6,0,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_13850,a[2]=t6,a[3]=((C_word)li394),tmp=(C_word)a,a+=4,tmp));
t8=((C_word*)t6)[1];
f_13850(t8,t1,t4,t2,t3);}

/* loop in scheme#max in k8543 */
static void C_fcall f_13850(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word *a;
loop:
if(C_unlikely(!C_demand(C_calculate_demand(11,0,4)))){
C_save_and_reclaim_args((void *)trf_13850,5,t0,t1,t2,t3,t4);}
a=C_alloc(11);
t5=C_i_check_number_2(t3,lf[559]);
if(C_truep(C_i_nullp(t4))){
t6=t1;{
C_word av2[2];
av2[0]=t6;
av2[1]=(C_truep(t2)?C_a_i_exact_to_inexact(&a,1,t3):t3);
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}
else{
t6=C_slot(t4,C_fix(0));
t7=(C_truep(t2)?t2:C_i_flonump(t6));
t8=C_i_greaterp(t6,t3);
t9=(C_truep(t8)?t6:t3);
/* library.scm:2019: loop */
t11=t1;
t12=t7;
t13=t9;
t14=C_slot(t4,C_fix(1));
t1=t11;
t2=t12;
t3=t13;
t4=t14;
goto loop;}}

/* scheme#min in k8543 */
static void C_ccall f_13887(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +6,c,5)))){
C_save_and_reclaim((void*)f_13887,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+6);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
t4=C_i_flonump(t2);
t5=C_SCHEME_UNDEFINED;
t6=(*a=C_VECTOR_TYPE|1,a[1]=t5,tmp=(C_word)a,a+=2,tmp);
t7=C_set_block_item(t6,0,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_13894,a[2]=t6,a[3]=((C_word)li396),tmp=(C_word)a,a+=4,tmp));
t8=((C_word*)t6)[1];
f_13894(t8,t1,t4,t2,t3);}

/* loop in scheme#min in k8543 */
static void C_fcall f_13894(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word *a;
loop:
if(C_unlikely(!C_demand(C_calculate_demand(11,0,4)))){
C_save_and_reclaim_args((void *)trf_13894,5,t0,t1,t2,t3,t4);}
a=C_alloc(11);
t5=C_i_check_number_2(t3,lf[561]);
if(C_truep(C_i_nullp(t4))){
t6=t1;{
C_word av2[2];
av2[0]=t6;
av2[1]=(C_truep(t2)?C_a_i_exact_to_inexact(&a,1,t3):t3);
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}
else{
t6=C_slot(t4,C_fix(0));
t7=(C_truep(t2)?t2:C_i_flonump(t6));
t8=C_i_lessp(t6,t3);
t9=(C_truep(t8)?t6:t3);
/* library.scm:2030: loop */
t11=t1;
t12=t7;
t13=t9;
t14=C_slot(t4,C_fix(1));
t1=t11;
t2=t12;
t3=t13;
t4=t14;
goto loop;}}

/* scheme#exp in k8543 */
static void C_ccall f_13931(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(15,c,2)))){
C_save_and_reclaim((void *)f_13931,c,av);}
a=C_alloc(15);
t3=C_i_check_number_2(t2,lf[563]);
if(C_truep(C_i_cplxnump(t2))){
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_13949,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* library.scm:2039: scheme#exact->inexact */
t5=*((C_word*)lf[62]+1);{
C_word *av2=av;
av2[0]=t5;
av2[1]=t4;
av2[2]=C_u_i_cplxnum_real(t2);
((C_proc)(void*)(*((C_word*)t5+1)))(3,av2);}}
else{
t4=C_a_i_exact_to_inexact(&a,1,t2);
t5=C_flonum(&a,C_exp(C_flonum_magnitude(t4)));
t6=t1;{
C_word *av2=av;
av2[0]=t6;
av2[1]=t5;
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}}

/* k13947 in scheme#exp in k8543 */
static void C_ccall f_13949(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(12,c,2)))){
C_save_and_reclaim((void *)f_13949,c,av);}
a=C_alloc(12);
t2=C_a_i_exp(&a,1,t1);
t3=C_u_i_cplxnum_imag(((C_word*)t0)[2]);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_13958,a[2]=((C_word*)t0)[3],a[3]=t2,tmp=(C_word)a,a+=4,tmp);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_13963,a[2]=t3,a[3]=t4,tmp=(C_word)a,a+=4,tmp);
/* library.scm:2042: scheme#exact->inexact */
t6=*((C_word*)lf[62]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t6;
av2[1]=t5;
av2[2]=t3;
((C_proc)(void*)(*((C_word*)t6+1)))(3,av2);}}

/* k13956 in k13947 in scheme#exp in k8543 */
static void C_ccall f_13958(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(33,c,1)))){
C_save_and_reclaim((void *)f_13958,c,av);}
a=C_alloc(33);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_s_a_i_times(&a,2,((C_word*)t0)[3],t1);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* k13961 in k13947 in scheme#exp in k8543 */
static void C_ccall f_13963(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(19,c,3)))){
C_save_and_reclaim((void *)f_13963,c,av);}
a=C_alloc(19);
t2=C_a_i_cos(&a,1,t1);
t3=C_a_i_exact_to_inexact(&a,1,((C_word*)t0)[2]);
t4=C_a_i_sin(&a,1,t3);
/* library.scm:2041: make-complex */
f_12643(((C_word*)t0)[3],t2,t4);}

/* ##sys#log-1 in k8543 */
static void C_ccall f_13976(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(7,c,5)))){
C_save_and_reclaim((void *)f_13976,c,av);}
a=C_alloc(7);
t3=C_eqp(t2,C_fix(0));
if(C_truep(t3)){
/* library.scm:2049: ##sys#signal-hook */
t4=C_fast_retrieve(lf[194]);{
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=t4;
av2[1]=t1;
av2[2]=lf[565];
av2[3]=lf[566];
av2[4]=lf[567];
av2[5]=t2;
((C_proc)(void*)(*((C_word*)t4+1)))(6,av2);}}
else{
t4=C_i_cplxnump(t2);
t5=(C_truep(t4)?t4:C_i_negativep(t2));
if(C_truep(t5)){
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_14002,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
t7=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14018,a[2]=t6,tmp=(C_word)a,a+=3,tmp);
/* library.scm:2052: scheme#magnitude */
t8=*((C_word*)lf[514]+1);{
C_word *av2=av;
av2[0]=t8;
av2[1]=t7;
av2[2]=t2;
((C_proc)(void*)(*((C_word*)t8+1)))(3,av2);}}
else{
t6=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14022,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* library.scm:2055: scheme#exact->inexact */
t7=*((C_word*)lf[62]+1);{
C_word *av2=av;
av2[0]=t7;
av2[1]=t6;
av2[2]=t2;
((C_proc)(void*)(*((C_word*)t7+1)))(3,av2);}}}}

/* k14000 in ##sys#log-1 in k8543 */
static void C_ccall f_14002(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,c,3)))){
C_save_and_reclaim((void *)f_14002,c,av);}
a=C_alloc(5);
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_14010,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
/* library.scm:2053: make-complex */
f_12643(t2,C_fix(0),C_fix(1));}

/* k14008 in k14000 in ##sys#log-1 in k8543 */
static void C_ccall f_14010(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,c,2)))){
C_save_and_reclaim((void *)f_14010,c,av);}
a=C_alloc(5);
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_14014,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
/* library.scm:2053: scheme#angle */
t3=*((C_word*)lf[512]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=((C_word*)t0)[4];
((C_proc)(void*)(*((C_word*)t3+1)))(3,av2);}}

/* k14012 in k14008 in k14000 in ##sys#log-1 in k8543 */
static void C_ccall f_14014(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(62,c,1)))){
C_save_and_reclaim((void *)f_14014,c,av);}
a=C_alloc(62);
t2=C_s_a_i_times(&a,2,((C_word*)t0)[2],t1);
t3=((C_word*)t0)[3];{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_s_a_i_plus(&a,2,((C_word*)t0)[4],t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* k14016 in ##sys#log-1 in k8543 */
static void C_ccall f_14018(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_14018,c,av);}
/* library.scm:2052: ##sys#log-1 */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[564]+1));
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=*((C_word*)lf[564]+1);
av2[1]=((C_word*)t0)[2];
av2[2]=t1;
tp(3,av2);}}

/* k14020 in ##sys#log-1 in k8543 */
static void C_ccall f_14022(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,1)))){
C_save_and_reclaim((void *)f_14022,c,av);}
a=C_alloc(4);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_a_i_log(&a,1,t1);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* scheme#log in k8543 */
static void C_ccall f_14025(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(4,c,2)))){
C_save_and_reclaim((void *)f_14025,c,av);}
a=C_alloc(4);
t3=C_rest_nullp(c,3);
t4=(C_truep(t3)?C_SCHEME_FALSE:C_get_rest_arg(c,3,av,3,t0));
if(C_truep(t4)){
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_14039,a[2]=t1,a[3]=t4,tmp=(C_word)a,a+=4,tmp);
/* library.scm:2059: ##sys#log-1 */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[564]+1));
C_word *av2=av;
av2[0]=*((C_word*)lf[564]+1);
av2[1]=t5;
av2[2]=t2;
tp(3,av2);}}
else{
/* library.scm:2059: ##sys#log-1 */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[564]+1));
C_word *av2=av;
av2[0]=*((C_word*)lf[564]+1);
av2[1]=t1;
av2[2]=t2;
tp(3,av2);}}}

/* k14037 in scheme#log in k8543 */
static void C_ccall f_14039(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,2)))){
C_save_and_reclaim((void *)f_14039,c,av);}
a=C_alloc(4);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_14043,a[2]=((C_word*)t0)[2],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* library.scm:2059: ##sys#log-1 */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[564]+1));
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=*((C_word*)lf[564]+1);
av2[1]=t2;
av2[2]=((C_word*)t0)[3];
tp(3,av2);}}

/* k14041 in k14037 in scheme#log in k8543 */
static void C_ccall f_14043(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_14043,c,av);}
/* library.scm:2059: ##sys#/-2 */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[529]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[529]+1);
av2[1]=((C_word*)t0)[2];
av2[2]=((C_word*)t0)[3];
av2[3]=t1;
tp(4,av2);}}

/* scheme#sin in k8543 */
static void C_ccall f_14054(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(37,c,2)))){
C_save_and_reclaim((void *)f_14054,c,av);}
a=C_alloc(37);
t3=C_i_check_number_2(t2,lf[570]);
if(C_truep(C_i_cplxnump(t2))){
t4=C_s_a_i_times(&a,2,lf[571],t2);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_14078,a[2]=t1,a[3]=t4,tmp=(C_word)a,a+=4,tmp);
/* library.scm:2066: scheme#exp */
t6=*((C_word*)lf[562]+1);{
C_word *av2=av;
av2[0]=t6;
av2[1]=t5;
av2[2]=t4;
((C_proc)(void*)(*((C_word*)t6+1)))(3,av2);}}
else{
t4=C_a_i_exact_to_inexact(&a,1,t2);
t5=C_a_i_sin(&a,1,t4);
t6=t1;{
C_word *av2=av;
av2[0]=t6;
av2[1]=t5;
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}}

/* k14076 in scheme#sin in k8543 */
static void C_ccall f_14078(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(33,c,2)))){
C_save_and_reclaim((void *)f_14078,c,av);}
a=C_alloc(33);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_14082,a[2]=t1,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
t3=C_s_a_i_negate(&a,1,((C_word*)t0)[3]);
/* library.scm:2066: scheme#exp */
t4=*((C_word*)lf[562]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t4;
av2[1]=t2;
av2[2]=t3;
((C_proc)(void*)(*((C_word*)t4+1)))(3,av2);}}

/* k14080 in k14076 in scheme#sin in k8543 */
static void C_ccall f_14082(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(29,c,3)))){
C_save_and_reclaim((void *)f_14082,c,av);}
a=C_alloc(29);
t2=C_s_a_i_minus(&a,2,((C_word*)t0)[2],t1);
/* library.scm:2066: ##sys#/-2 */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[529]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[529]+1);
av2[1]=((C_word*)t0)[3];
av2[2]=t2;
av2[3]=lf[572];
tp(4,av2);}}

/* scheme#cos in k8543 */
static void C_ccall f_14088(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(37,c,2)))){
C_save_and_reclaim((void *)f_14088,c,av);}
a=C_alloc(37);
t3=C_i_check_number_2(t2,lf[574]);
if(C_truep(C_i_cplxnump(t2))){
t4=C_s_a_i_times(&a,2,lf[571],t2);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_14112,a[2]=t1,a[3]=t4,tmp=(C_word)a,a+=4,tmp);
/* library.scm:2074: scheme#exp */
t6=*((C_word*)lf[562]+1);{
C_word *av2=av;
av2[0]=t6;
av2[1]=t5;
av2[2]=t4;
((C_proc)(void*)(*((C_word*)t6+1)))(3,av2);}}
else{
t4=C_a_i_exact_to_inexact(&a,1,t2);
t5=C_a_i_cos(&a,1,t4);
t6=t1;{
C_word *av2=av;
av2[0]=t6;
av2[1]=t5;
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}}

/* k14110 in scheme#cos in k8543 */
static void C_ccall f_14112(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(33,c,2)))){
C_save_and_reclaim((void *)f_14112,c,av);}
a=C_alloc(33);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_14116,a[2]=t1,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
t3=C_s_a_i_negate(&a,1,((C_word*)t0)[3]);
/* library.scm:2074: scheme#exp */
t4=*((C_word*)lf[562]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t4;
av2[1]=t2;
av2[2]=t3;
((C_proc)(void*)(*((C_word*)t4+1)))(3,av2);}}

/* k14114 in k14110 in scheme#cos in k8543 */
static void C_ccall f_14116(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(29,c,3)))){
C_save_and_reclaim((void *)f_14116,c,av);}
a=C_alloc(29);
t2=C_s_a_i_plus(&a,2,((C_word*)t0)[2],t1);
/* library.scm:2074: ##sys#/-2 */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[529]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[529]+1);
av2[1]=((C_word*)t0)[3];
av2[2]=t2;
av2[3]=C_fix(2);
tp(4,av2);}}

/* scheme#tan in k8543 */
static void C_ccall f_14122(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(15,c,2)))){
C_save_and_reclaim((void *)f_14122,c,av);}
a=C_alloc(15);
t3=C_i_check_number_2(t2,lf[576]);
if(C_truep(C_i_cplxnump(t2))){
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_14139,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* library.scm:2081: scheme#sin */
t5=*((C_word*)lf[569]+1);{
C_word *av2=av;
av2[0]=t5;
av2[1]=t4;
av2[2]=t2;
((C_proc)(void*)(*((C_word*)t5+1)))(3,av2);}}
else{
t4=C_a_i_exact_to_inexact(&a,1,t2);
t5=C_a_i_tan(&a,1,t4);
t6=t1;{
C_word *av2=av;
av2[0]=t6;
av2[1]=t5;
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}}

/* k14137 in scheme#tan in k8543 */
static void C_ccall f_14139(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,2)))){
C_save_and_reclaim((void *)f_14139,c,av);}
a=C_alloc(4);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_14143,a[2]=((C_word*)t0)[2],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* library.scm:2081: scheme#cos */
t3=*((C_word*)lf[573]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t3+1)))(3,av2);}}

/* k14141 in k14137 in scheme#tan in k8543 */
static void C_ccall f_14143(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_14143,c,av);}
/* library.scm:2081: ##sys#/-2 */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[529]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[529]+1);
av2[1]=((C_word*)t0)[2];
av2[2]=((C_word*)t0)[3];
av2[3]=t1;
tp(4,av2);}}

/* scheme#asin in k8543 */
static void C_ccall f_14147(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(8,c,3)))){
C_save_and_reclaim((void *)f_14147,c,av);}
a=C_alloc(8);
t3=C_i_check_number_2(t2,lf[578]);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_14157,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_flonump(t2))){
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_14205,a[2]=t4,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* library.scm:2088: chicken.flonum#fp>= */
t6=*((C_word*)lf[452]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t6;
av2[1]=t5;
av2[2]=t2;
av2[3]=lf[581];
((C_proc)(void*)(*((C_word*)t6+1)))(4,av2);}}
else{
t5=t4;
f_14157(t5,C_SCHEME_FALSE);}}

/* k14155 in scheme#asin in k8543 */
static void C_fcall f_14157(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,0,2)))){
C_save_and_reclaim_args((void *)trf_14157,2,t0,t1);}
a=C_alloc(4);
if(C_truep(t1)){
t2=C_a_i_asin(&a,1,((C_word*)t0)[2]);
t3=((C_word*)t0)[3];{
C_word av2[2];
av2[0]=t3;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_14163,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_fixnump(((C_word*)t0)[2]))){
t3=C_fixnum_greater_or_equal_p(((C_word*)t0)[2],C_fix(-1));
t4=t2;
f_14163(t4,(C_truep(t3)?C_fixnum_less_or_equal_p(((C_word*)t0)[2],C_fix(1)):C_SCHEME_FALSE));}
else{
t3=t2;
f_14163(t3,C_SCHEME_FALSE);}}}

/* k14161 in k14155 in scheme#asin in k8543 */
static void C_fcall f_14163(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(102,0,3)))){
C_save_and_reclaim_args((void *)trf_14163,2,t0,t1);}
a=C_alloc(102);
if(C_truep(t1)){
t2=((C_word*)t0)[2];{
C_word av2[2];
av2[0]=t2;
av2[1]=C_a_i_asin(&a,1,C_a_i_fix_to_flo(&a,1,((C_word*)t0)[3]));
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}
else{
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14170,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t3=C_s_a_i_times(&a,2,lf[571],((C_word*)t0)[3]);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_14182,a[2]=t3,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
t5=C_s_a_i_times(&a,2,((C_word*)t0)[3],((C_word*)t0)[3]);
t6=C_s_a_i_minus(&a,2,C_fix(1),t5);
/* library.scm:2097: ##sys#sqrt/loc */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[580]+1));
C_word av2[4];
av2[0]=*((C_word*)lf[580]+1);
av2[1]=t4;
av2[2]=lf[578];
av2[3]=t6;
tp(4,av2);}}}

/* k14168 in k14161 in k14155 in scheme#asin in k8543 */
static void C_ccall f_14170(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(33,c,1)))){
C_save_and_reclaim((void *)f_14170,c,av);}
a=C_alloc(33);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_s_a_i_times(&a,2,lf[579],t1);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* k14180 in k14161 in k14155 in scheme#asin in k8543 */
static void C_ccall f_14182(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(29,c,2)))){
C_save_and_reclaim((void *)f_14182,c,av);}
a=C_alloc(29);
t2=C_s_a_i_plus(&a,2,((C_word*)t0)[2],t1);
/* library.scm:2095: ##sys#log-1 */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[564]+1));
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=*((C_word*)lf[564]+1);
av2[1]=((C_word*)t0)[3];
av2[2]=t2;
tp(3,av2);}}

/* k14203 in scheme#asin in k8543 */
static void C_ccall f_14205(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_14205,c,av);}
t2=((C_word*)t0)[2];
f_14157(t2,(C_truep(t1)?C_ub_i_flonum_less_or_equal_p(C_flonum_magnitude(((C_word*)t0)[3]),(double)1.0):C_SCHEME_FALSE));}

/* scheme#acos in k8543 */
static void C_ccall f_14209(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(9,c,3)))){
C_save_and_reclaim((void *)f_14209,c,av);}
a=C_alloc(9);
t3=C_i_check_number_2(t2,lf[583]);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_14219,a[2]=t2,a[3]=t1,a[4]=((C_word*)t0)[2],tmp=(C_word)a,a+=5,tmp);
if(C_truep(C_i_flonump(t2))){
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_14247,a[2]=t4,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* library.scm:2105: chicken.flonum#fp>= */
t6=*((C_word*)lf[452]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t6;
av2[1]=t5;
av2[2]=t2;
av2[3]=lf[581];
((C_proc)(void*)(*((C_word*)t6+1)))(4,av2);}}
else{
t5=t4;
f_14219(t5,C_SCHEME_FALSE);}}

/* k14217 in scheme#acos in k8543 */
static void C_fcall f_14219(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,0,2)))){
C_save_and_reclaim_args((void *)trf_14219,2,t0,t1);}
a=C_alloc(5);
if(C_truep(t1)){
t2=C_a_i_acos(&a,1,((C_word*)t0)[2]);
t3=((C_word*)t0)[3];{
C_word av2[2];
av2[0]=t3;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_14225,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
if(C_truep(C_fixnump(((C_word*)t0)[2]))){
t3=C_fixnum_greater_or_equal_p(((C_word*)t0)[2],C_fix(-1));
t4=t2;
f_14225(t4,(C_truep(t3)?C_fixnum_less_or_equal_p(((C_word*)t0)[2],C_fix(1)):C_SCHEME_FALSE));}
else{
t3=t2;
f_14225(t3,C_SCHEME_FALSE);}}}

/* k14223 in k14217 in scheme#acos in k8543 */
static void C_fcall f_14225(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(8,0,2)))){
C_save_and_reclaim_args((void *)trf_14225,2,t0,t1);}
a=C_alloc(8);
if(C_truep(t1)){
t2=((C_word*)t0)[2];{
C_word av2[2];
av2[0]=t2;
av2[1]=C_a_i_acos(&a,1,C_a_i_fix_to_flo(&a,1,((C_word*)t0)[3]));
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}
else{
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_14232,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
/* library.scm:2112: scheme#asin */
t3=*((C_word*)lf[577]+1);{
C_word av2[3];
av2[0]=t3;
av2[1]=t2;
av2[2]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t3+1)))(3,av2);}}}

/* k14230 in k14223 in k14217 in scheme#acos in k8543 */
static void C_ccall f_14232(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(29,c,1)))){
C_save_and_reclaim((void *)f_14232,c,av);}
a=C_alloc(29);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_s_a_i_minus(&a,2,((C_word*)t0)[3],t1);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* k14245 in scheme#acos in k8543 */
static void C_ccall f_14247(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_14247,c,av);}
t2=((C_word*)t0)[2];
f_14219(t2,(C_truep(t1)?C_ub_i_flonum_less_or_equal_p(C_flonum_magnitude(((C_word*)t0)[3]),(double)1.0):C_SCHEME_FALSE));}

/* scheme#atan in k8543 */
static void C_ccall f_14251(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(66,c,3)))){
C_save_and_reclaim((void *)f_14251,c,av);}
a=C_alloc(66);
t3=C_rest_nullp(c,3);
t4=(C_truep(t3)?C_SCHEME_FALSE:C_get_rest_arg(c,3,av,3,t0));
t5=C_i_check_number_2(t2,lf[585]);
if(C_truep(C_i_cplxnump(t2))){
if(C_truep(t4)){
/* library.scm:2119: ##sys#error-bad-real */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[364]+1));
C_word av2[4];
av2[0]=*((C_word*)lf[364]+1);
av2[1]=t1;
av2[2]=t2;
av2[3]=lf[585];
tp(4,av2);}}
else{
t6=C_s_a_i_times(&a,2,lf[571],t2);
t7=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_14284,a[2]=t1,a[3]=t6,tmp=(C_word)a,a+=4,tmp);
t8=C_s_a_i_plus(&a,2,C_fix(1),t6);
/* library.scm:2121: ##sys#log-1 */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[564]+1));
C_word *av2=av;
av2[0]=*((C_word*)lf[564]+1);
av2[1]=t7;
av2[2]=t8;
tp(3,av2);}}}
else{
if(C_truep(t4)){
t6=C_a_i_exact_to_inexact(&a,1,t2);
t7=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_14305,a[2]=t1,a[3]=t6,tmp=(C_word)a,a+=4,tmp);
/* library.scm:2125: scheme#exact->inexact */
t8=*((C_word*)lf[62]+1);{
C_word *av2=av;
av2[0]=t8;
av2[1]=t7;
av2[2]=t4;
((C_proc)(void*)(*((C_word*)t8+1)))(3,av2);}}
else{
t6=C_a_i_exact_to_inexact(&a,1,t2);
t7=t1;{
C_word *av2=av;
av2[0]=t7;
av2[1]=C_a_i_atan(&a,1,t6);
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}}}

/* k14282 in scheme#atan in k8543 */
static void C_ccall f_14284(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(33,c,2)))){
C_save_and_reclaim((void *)f_14284,c,av);}
a=C_alloc(33);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_14288,a[2]=t1,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
t3=C_s_a_i_minus(&a,2,C_fix(1),((C_word*)t0)[3]);
/* library.scm:2122: ##sys#log-1 */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[564]+1));
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=*((C_word*)lf[564]+1);
av2[1]=t2;
av2[2]=t3;
tp(3,av2);}}

/* k14286 in k14282 in scheme#atan in k8543 */
static void C_ccall f_14288(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(29,c,3)))){
C_save_and_reclaim((void *)f_14288,c,av);}
a=C_alloc(29);
t2=C_s_a_i_minus(&a,2,((C_word*)t0)[2],t1);
/* library.scm:2121: ##sys#/-2 */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[529]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[529]+1);
av2[1]=((C_word*)t0)[3];
av2[2]=t2;
av2[3]=lf[572];
tp(4,av2);}}

/* k14303 in scheme#atan in k8543 */
static void C_ccall f_14305(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,1)))){
C_save_and_reclaim((void *)f_14305,c,av);}
a=C_alloc(4);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_a_i_atan2(&a,2,((C_word*)t0)[3],t1);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* ##sys#exact-integer-sqrt in k8543 */
static void C_ccall f_14315(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(10,c,4)))){
C_save_and_reclaim((void *)f_14315,c,av);}
a=C_alloc(10);
t3=C_fixnump(t2);
t4=(C_truep(t3)?C_fixnum_less_or_equal_p(t2,C_fix(4)):C_SCHEME_FALSE);
if(C_truep(t4)){
t5=C_eqp(t2,C_fix(0));
t6=(C_truep(t5)?t5:C_eqp(t2,C_fix(1)));
if(C_truep(t6)){
/* library.scm:2137: scheme#values */{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=0;
av2[1]=t1;
av2[2]=t2;
av2[3]=C_fix(0);
C_values(4,av2);}}
else{
switch(t2){
case C_fix(2):
/* library.scm:2138: scheme#values */{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=0;
av2[1]=t1;
av2[2]=C_fix(1);
av2[3]=C_fix(1);
C_values(4,av2);}
case C_fix(3):
/* library.scm:2139: scheme#values */{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=0;
av2[1]=t1;
av2[2]=C_fix(1);
av2[3]=C_fix(2);
C_values(4,av2);}
case C_fix(4):
/* library.scm:2140: scheme#values */{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=0;
av2[1]=t1;
av2[2]=C_fix(2);
av2[3]=C_fix(0);
C_values(4,av2);}
default:
/* library.scm:2141: chicken.base#error */
t7=*((C_word*)lf[193]+1);{
C_word *av2=av;
av2[0]=t7;
av2[1]=t1;
av2[2]=lf[587];
((C_proc)(void*)(*((C_word*)t7+1)))(3,av2);}}}}
else{
t5=C_fixnum_plus(C_i_integer_length(t2),C_fix(1));
t6=C_fixnum_shift_right(t5,C_fix(2));
t7=C_fixnum_shift_left(t6,C_fix(1));
t8=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_14388,a[2]=t7,a[3]=t2,a[4]=((C_word)li407),tmp=(C_word)a,a+=5,tmp);
t9=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_14402,a[2]=t6,a[3]=t2,a[4]=((C_word)li411),tmp=(C_word)a,a+=5,tmp);
/* library.scm:2142: ##sys#call-with-values */{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=0;
av2[1]=t1;
av2[2]=t8;
av2[3]=t9;
C_call_with_values(4,av2);}}}

/* a14387 in ##sys#exact-integer-sqrt in k8543 */
static void C_ccall f_14388(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(5,c,2)))){
C_save_and_reclaim((void *)f_14388,c,av);}
a=C_alloc(5);
t2=C_fixnum_negate(((C_word*)t0)[2]);
t3=C_s_a_i_arithmetic_shift(&a,2,((C_word*)t0)[3],t2);
/* library.scm:2145: ##sys#exact-integer-sqrt */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[586]+1));
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=*((C_word*)lf[586]+1);
av2[1]=t1;
av2[2]=t3;
tp(3,av2);}}

/* a14401 in ##sys#exact-integer-sqrt in k8543 */
static void C_ccall f_14402(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(38,c,4)))){
C_save_and_reclaim((void *)f_14402,c,av);}
a=C_alloc(38);
t4=C_s_a_i_arithmetic_shift(&a,2,C_fix(1),((C_word*)t0)[2]);
t5=C_s_a_u_i_integer_minus(&a,2,t4,C_fix(1));
t6=C_s_a_i_bitwise_and(&a,2,((C_word*)t0)[3],t5);
t7=C_fixnum_negate(((C_word*)t0)[2]);
t8=C_s_a_i_arithmetic_shift(&a,2,((C_word*)t0)[3],t7);
t9=C_s_a_i_bitwise_and(&a,2,t8,t5);
t10=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_14419,a[2]=t3,a[3]=((C_word*)t0)[2],a[4]=t9,a[5]=t2,a[6]=((C_word)li409),tmp=(C_word)a,a+=7,tmp);
t11=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_14435,a[2]=t2,a[3]=((C_word*)t0)[2],a[4]=t6,a[5]=((C_word)li410),tmp=(C_word)a,a+=6,tmp);
/* library.scm:2142: ##sys#call-with-values */{
C_word *av2=av;
av2[0]=0;
av2[1]=t1;
av2[2]=t10;
av2[3]=t11;
C_call_with_values(4,av2);}}

/* a14418 in a14401 in ##sys#exact-integer-sqrt in k8543 */
static void C_ccall f_14419(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(18,c,3)))){
C_save_and_reclaim((void *)f_14419,c,av);}
a=C_alloc(18);
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)C_u_integer_quotient_and_remainder,a[2]=((C_word)li408),tmp=(C_word)a,a+=3,tmp);
t3=C_s_a_i_arithmetic_shift(&a,2,((C_word*)t0)[2],((C_word*)t0)[3]);
t4=C_s_a_u_i_integer_plus(&a,2,t3,((C_word*)t0)[4]);
t5=C_s_a_i_arithmetic_shift(&a,2,((C_word*)t0)[5],C_fix(1));
/* library.scm:2142: g2590 */
t6=t2;{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t6;
av2[1]=t1;
av2[2]=t4;
av2[3]=t5;
((C_proc)C_fast_retrieve_proc(t6))(4,av2);}}

/* a14434 in a14401 in ##sys#exact-integer-sqrt in k8543 */
static void C_ccall f_14435(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(222,c,3)))){
C_save_and_reclaim((void *)f_14435,c,av);}
a=C_alloc(222);
t4=C_s_a_i_arithmetic_shift(&a,2,((C_word*)t0)[2],((C_word*)t0)[3]);
t5=C_s_a_i_plus(&a,2,t4,t2);
t6=C_s_a_i_arithmetic_shift(&a,2,t3,((C_word*)t0)[3]);
t7=C_s_a_i_times(&a,2,t2,t2);
t8=C_s_a_i_minus(&a,2,((C_word*)t0)[4],t7);
t9=C_s_a_i_plus(&a,2,t6,t8);
if(C_truep(C_i_negativep(t9))){
t10=C_s_a_i_minus(&a,2,t5,C_fix(1));
t11=C_s_a_i_arithmetic_shift(&a,2,t5,C_fix(1));
t12=C_s_a_i_plus(&a,2,t9,t11);
t13=C_s_a_i_minus(&a,2,t12,C_fix(1));
/* library.scm:2156: scheme#values */{
C_word *av2=av;
av2[0]=0;
av2[1]=t1;
av2[2]=t10;
av2[3]=t13;
C_values(4,av2);}}
else{
/* library.scm:2158: scheme#values */{
C_word *av2=av;
av2[0]=0;
av2[1]=t1;
av2[2]=t5;
av2[3]=t9;
C_values(4,av2);}}}

/* chicken.base#exact-integer-sqrt in k8543 */
static void C_ccall f_14506(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(4,c,3)))){
C_save_and_reclaim((void *)f_14506,c,av);}
a=C_alloc(4);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_14510,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* library.scm:2162: ##sys#check-exact-uinteger */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[361]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[361]+1);
av2[1]=t3;
av2[2]=t2;
av2[3]=lf[589];
tp(4,av2);}}

/* k14508 in chicken.base#exact-integer-sqrt in k8543 */
static void C_ccall f_14510(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_14510,c,av);}
/* library.scm:2163: ##sys#exact-integer-sqrt */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[586]+1));
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=*((C_word*)lf[586]+1);
av2[1]=((C_word*)t0)[2];
av2[2]=((C_word*)t0)[3];
tp(3,av2);}}

/* ##sys#sqrt/loc in k8543 */
static void C_ccall f_14515(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(32,c,4)))){
C_save_and_reclaim((void *)f_14515,c,av);}
a=C_alloc(32);
if(C_truep(C_i_cplxnump(t3))){
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_14525,a[2]=t1,a[3]=t3,tmp=(C_word)a,a+=4,tmp);
t5=C_u_i_cplxnum_imag(t3);
t6=C_a_i_exact_to_inexact(&a,1,t5);
t7=C_u_i_cplxnum_real(t3);
t8=C_a_i_exact_to_inexact(&a,1,t7);
t9=C_flonum(&a,C_atan2(C_flonum_magnitude(t6),C_flonum_magnitude(t8)));
/* library.scm:2169: ##sys#/-2 */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[529]+1));
C_word *av2=av;
av2[0]=*((C_word*)lf[529]+1);
av2[1]=t4;
av2[2]=t9;
av2[3]=C_fix(2);
tp(4,av2);}}
else{
if(C_truep(C_i_negativep(t3))){
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14565,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
t5=C_s_a_i_negate(&a,1,t3);
/* library.scm:2174: scheme#exact->inexact */
t6=*((C_word*)lf[62]+1);{
C_word *av2=av;
av2[0]=t6;
av2[1]=t4;
av2[2]=t5;
((C_proc)(void*)(*((C_word*)t6+1)))(3,av2);}}
else{
if(C_truep(C_i_exact_integerp(t3))){
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_14576,a[2]=t3,a[3]=((C_word)li414),tmp=(C_word)a,a+=4,tmp);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_14582,a[2]=t3,a[3]=((C_word)li415),tmp=(C_word)a,a+=4,tmp);
/* library.scm:2176: ##sys#call-with-values */{
C_word *av2=av;
av2[0]=0;
av2[1]=t1;
av2[2]=t4;
av2[3]=t5;
C_call_with_values(4,av2);}}
else{
if(C_truep(C_i_ratnump(t3))){
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_14604,a[2]=t3,a[3]=((C_word)li416),tmp=(C_word)a,a+=4,tmp);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_14616,a[2]=t3,a[3]=t2,a[4]=((C_word)li419),tmp=(C_word)a,a+=5,tmp);
/* library.scm:2181: ##sys#call-with-values */{
C_word *av2=av;
av2[0]=0;
av2[1]=t1;
av2[2]=t4;
av2[3]=t5;
C_call_with_values(4,av2);}}
else{
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14668,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* library.scm:2189: scheme#exact->inexact */
t5=*((C_word*)lf[62]+1);{
C_word *av2=av;
av2[0]=t5;
av2[1]=t4;
av2[2]=t3;
((C_proc)(void*)(*((C_word*)t5+1)))(3,av2);}}}}}}

/* k14523 in ##sys#sqrt/loc in k8543 */
static void C_ccall f_14525(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,2)))){
C_save_and_reclaim((void *)f_14525,c,av);}
a=C_alloc(4);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_14529,a[2]=((C_word*)t0)[2],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* library.scm:2170: scheme#magnitude */
t3=*((C_word*)lf[514]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t3+1)))(3,av2);}}

/* k14527 in k14523 in ##sys#sqrt/loc in k8543 */
static void C_ccall f_14529(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(9,c,2)))){
C_save_and_reclaim((void *)f_14529,c,av);}
a=C_alloc(9);
t2=C_a_i_sqrt(&a,1,t1);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_14548,a[2]=t2,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
/* library.scm:2171: scheme#cos */
t4=*((C_word*)lf[573]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t4;
av2[1]=t3;
av2[2]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t4+1)))(3,av2);}}

/* k14542 in k14546 in k14527 in k14523 in ##sys#sqrt/loc in k8543 */
static void C_ccall f_14544(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(33,c,3)))){
C_save_and_reclaim((void *)f_14544,c,av);}
a=C_alloc(33);
t2=C_s_a_i_times(&a,2,((C_word*)t0)[2],t1);
/* library.scm:2171: make-complex */
f_12643(((C_word*)t0)[3],((C_word*)t0)[4],t2);}

/* k14546 in k14527 in k14523 in ##sys#sqrt/loc in k8543 */
static void C_ccall f_14548(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(38,c,2)))){
C_save_and_reclaim((void *)f_14548,c,av);}
a=C_alloc(38);
t2=C_s_a_i_times(&a,2,((C_word*)t0)[2],t1);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_14544,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* library.scm:2171: scheme#sin */
t4=*((C_word*)lf[569]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t4;
av2[1]=t3;
av2[2]=((C_word*)t0)[4];
((C_proc)(void*)(*((C_word*)t4+1)))(3,av2);}}

/* k14563 in ##sys#sqrt/loc in k8543 */
static void C_ccall f_14565(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,3)))){
C_save_and_reclaim((void *)f_14565,c,av);}
a=C_alloc(4);
t2=C_a_i_sqrt(&a,1,t1);
/* library.scm:2173: make-complex */
f_12643(((C_word*)t0)[2],lf[503],t2);}

/* a14575 in ##sys#sqrt/loc in k8543 */
static void C_ccall f_14576(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_14576,c,av);}
/* library.scm:2176: ##sys#exact-integer-sqrt */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[586]+1));
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=*((C_word*)lf[586]+1);
av2[1]=t1;
av2[2]=((C_word*)t0)[2];
tp(3,av2);}}

/* a14581 in ##sys#sqrt/loc in k8543 */
static void C_ccall f_14582(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(3,c,2)))){
C_save_and_reclaim((void *)f_14582,c,av);}
a=C_alloc(3);
t4=C_eqp(C_fix(0),t3);
if(C_truep(t4)){
t5=t1;{
C_word *av2=av;
av2[0]=t5;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}
else{
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14593,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* library.scm:2179: scheme#exact->inexact */
t6=*((C_word*)lf[62]+1);{
C_word *av2=av;
av2[0]=t6;
av2[1]=t5;
av2[2]=((C_word*)t0)[2];
((C_proc)(void*)(*((C_word*)t6+1)))(3,av2);}}}

/* k14591 in a14581 in ##sys#sqrt/loc in k8543 */
static void C_ccall f_14593(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,1)))){
C_save_and_reclaim((void *)f_14593,c,av);}
a=C_alloc(4);
t2=C_a_i_sqrt(&a,1,t1);
t3=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t3;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* a14603 in ##sys#sqrt/loc in k8543 */
static void C_ccall f_14604(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_14604,c,av);}
/* library.scm:2181: ##sys#exact-integer-sqrt */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[586]+1));
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=*((C_word*)lf[586]+1);
av2[1]=t1;
av2[2]=C_u_i_ratnum_num(((C_word*)t0)[2]);
tp(3,av2);}}

/* a14615 in ##sys#sqrt/loc in k8543 */
static void C_ccall f_14616(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(10,c,4)))){
C_save_and_reclaim((void *)f_14616,c,av);}
a=C_alloc(10);
t4=C_eqp(t3,C_fix(0));
if(C_truep(t4)){
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_14628,a[2]=((C_word*)t0)[2],a[3]=((C_word)li417),tmp=(C_word)a,a+=4,tmp);
t6=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_14640,a[2]=t2,a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[2],a[5]=((C_word)li418),tmp=(C_word)a,a+=6,tmp);
/* library.scm:2183: ##sys#call-with-values */{
C_word *av2=av;
av2[0]=0;
av2[1]=t1;
av2[2]=t5;
av2[3]=t6;
C_call_with_values(4,av2);}}
else{
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_14664,a[2]=t1,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* library.scm:2188: scheme#exact->inexact */
t6=*((C_word*)lf[62]+1);{
C_word *av2=av;
av2[0]=t6;
av2[1]=t5;
av2[2]=((C_word*)t0)[2];
((C_proc)(void*)(*((C_word*)t6+1)))(3,av2);}}}

/* a14627 in a14615 in ##sys#sqrt/loc in k8543 */
static void C_ccall f_14628(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_14628,c,av);}
/* library.scm:2184: ##sys#exact-integer-sqrt */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[586]+1));
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=*((C_word*)lf[586]+1);
av2[1]=t1;
av2[2]=C_u_i_ratnum_denom(((C_word*)t0)[2]);
tp(3,av2);}}

/* a14639 in a14615 in ##sys#sqrt/loc in k8543 */
static void C_ccall f_14640(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(4,c,3)))){
C_save_and_reclaim((void *)f_14640,c,av);}
a=C_alloc(4);
t4=C_eqp(t3,C_fix(0));
if(C_truep(t4)){
/* library.scm:2186: ##sys#/-2 */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[529]+1));
C_word *av2=av;
av2[0]=*((C_word*)lf[529]+1);
av2[1]=t1;
av2[2]=((C_word*)t0)[2];
av2[3]=t2;
tp(4,av2);}}
else{
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_14657,a[2]=t1,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* library.scm:2187: scheme#exact->inexact */
t6=*((C_word*)lf[62]+1);{
C_word *av2=av;
av2[0]=t6;
av2[1]=t5;
av2[2]=((C_word*)t0)[4];
((C_proc)(void*)(*((C_word*)t6+1)))(3,av2);}}}

/* k14655 in a14639 in a14615 in ##sys#sqrt/loc in k8543 */
static void C_ccall f_14657(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_14657,c,av);}
/* library.scm:2187: ##sys#sqrt/loc */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[580]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[580]+1);
av2[1]=((C_word*)t0)[2];
av2[2]=((C_word*)t0)[3];
av2[3]=t1;
tp(4,av2);}}

/* k14662 in a14615 in ##sys#sqrt/loc in k8543 */
static void C_ccall f_14664(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_14664,c,av);}
/* library.scm:2188: ##sys#sqrt/loc */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[580]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[580]+1);
av2[1]=((C_word*)t0)[2];
av2[2]=((C_word*)t0)[3];
av2[3]=t1;
tp(4,av2);}}

/* k14666 in ##sys#sqrt/loc in k8543 */
static void C_ccall f_14668(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,1)))){
C_save_and_reclaim((void *)f_14668,c,av);}
a=C_alloc(4);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_a_i_sqrt(&a,1,t1);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* scheme#sqrt in k8543 */
static void C_ccall f_14670(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_14670,c,av);}
/* library.scm:2191: ##sys#sqrt/loc */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[580]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[580]+1);
av2[1]=t1;
av2[2]=lf[590];
av2[3]=t2;
tp(4,av2);}}

/* chicken.base#exact-integer-nth-root in k8543 */
static void C_ccall f_14676(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(5,c,3)))){
C_save_and_reclaim((void *)f_14676,c,av);}
a=C_alloc(5);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_14680,a[2]=t1,a[3]=t2,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
/* library.scm:2195: ##sys#check-exact-uinteger */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[361]+1));
C_word *av2=av;
av2[0]=*((C_word*)lf[361]+1);
av2[1]=t4;
av2[2]=t2;
av2[3]=lf[593];
tp(4,av2);}}

/* k14678 in chicken.base#exact-integer-nth-root in k8543 */
static void C_ccall f_14680(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,c,3)))){
C_save_and_reclaim((void *)f_14680,c,av);}
a=C_alloc(5);
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_14683,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
/* library.scm:2196: ##sys#check-exact-uinteger */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[361]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[361]+1);
av2[1]=t2;
av2[2]=((C_word*)t0)[4];
av2[3]=lf[593];
tp(4,av2);}}

/* k14681 in k14678 in chicken.base#exact-integer-nth-root in k8543 */
static void C_ccall f_14683(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,4)))){
C_save_and_reclaim((void *)f_14683,c,av);}
/* library.scm:2197: ##sys#exact-integer-nth-root/loc */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[592]+1));
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=*((C_word*)lf[592]+1);
av2[1]=((C_word*)t0)[2];
av2[2]=lf[593];
av2[3]=((C_word*)t0)[3];
av2[4]=((C_word*)t0)[4];
tp(5,av2);}}

/* ##sys#exact-integer-nth-root/loc in k8543 */
static void C_ccall f_14688(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(c!=5) C_bad_argc_2(c,5,t0);
if(C_unlikely(!C_demand(C_calculate_demand(5,c,2)))){
C_save_and_reclaim((void *)f_14688,c,av);}
a=C_alloc(5);
t5=C_eqp(C_fix(0),t3);
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_14698,a[2]=t1,a[3]=t3,a[4]=t4,tmp=(C_word)a,a+=5,tmp);
if(C_truep(t5)){
t7=t6;
f_14698(t7,t5);}
else{
t7=C_eqp(C_fix(1),t3);
t8=t6;
f_14698(t8,(C_truep(t7)?t7:C_eqp(C_fix(1),t4)));}}

/* k14696 in ##sys#exact-integer-nth-root/loc in k8543 */
static void C_fcall f_14698(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(29,0,3)))){
C_save_and_reclaim_args((void *)trf_14698,2,t0,t1);}
a=C_alloc(29);
if(C_truep(t1)){
/* library.scm:2203: scheme#values */{
C_word av2[4];
av2[0]=0;
av2[1]=((C_word*)t0)[2];
av2[2]=((C_word*)t0)[3];
av2[3]=C_fix(0);
C_values(4,av2);}}
else{
t2=C_i_integer_length(((C_word*)t0)[3]);
if(C_truep(C_i_lessp(t2,((C_word*)t0)[4]))){
t3=C_s_a_i_minus(&a,2,((C_word*)t0)[3],C_fix(1));
/* library.scm:2206: scheme#values */{
C_word av2[4];
av2[0]=0;
av2[1]=((C_word*)t0)[2];
av2[2]=C_fix(1);
av2[3]=t3;
C_values(4,av2);}}
else{
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_14718,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[2],tmp=(C_word)a,a+=5,tmp);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14794,a[2]=t3,tmp=(C_word)a,a+=3,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14798,a[2]=t4,tmp=(C_word)a,a+=3,tmp);
/* ##sys#/-2 */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[529]+1));
C_word av2[4];
av2[0]=*((C_word*)lf[529]+1);
av2[1]=t5;
av2[2]=C_fixnum_plus(t2,C_fix(1));
av2[3]=((C_word*)t0)[4];
tp(4,av2);}}}}

/* k14716 in k14696 in ##sys#exact-integer-nth-root/loc in k8543 */
static void C_ccall f_14718(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(75,c,3)))){
C_save_and_reclaim((void *)f_14718,c,av);}
a=C_alloc(75);
t2=C_s_a_i_arithmetic_shift(&a,2,C_fix(1),t1);
t3=C_s_a_i_minus(&a,2,((C_word*)t0)[2],C_fix(1));
t4=C_s_a_i_times(&a,2,t3,t2);
t5=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_14790,a[2]=((C_word*)t0)[3],a[3]=t4,a[4]=((C_word*)t0)[2],a[5]=t3,a[6]=((C_word*)t0)[4],a[7]=t2,tmp=(C_word)a,a+=8,tmp);
/* library.scm:2214: ##sys#integer-power */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[531]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[531]+1);
av2[1]=t5;
av2[2]=t2;
av2[3]=t3;
tp(4,av2);}}

/* lp in k14788 in k14716 in k14696 in ##sys#exact-integer-nth-root/loc in k8543 */
static void C_fcall f_14733(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(41,0,3)))){
C_save_and_reclaim_args((void *)trf_14733,4,t0,t1,t2,t3);}
a=C_alloc(41);
if(C_truep(C_i_lessp(t3,t2))){
t4=C_s_a_i_times(&a,2,((C_word*)t0)[2],t3);
t5=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_14763,a[2]=((C_word*)t0)[3],a[3]=t4,a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=t1,a[7]=t3,tmp=(C_word)a,a+=8,tmp);
/* library.scm:2219: ##sys#integer-power */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[531]+1));
C_word av2[4];
av2[0]=*((C_word*)lf[531]+1);
av2[1]=t5;
av2[2]=t3;
av2[3]=((C_word*)t0)[2];
tp(4,av2);}}
else{
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_14774,a[2]=((C_word*)t0)[3],a[3]=t1,a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* library.scm:2221: ##sys#integer-power */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[531]+1));
C_word av2[4];
av2[0]=*((C_word*)lf[531]+1);
av2[1]=t4;
av2[2]=t2;
av2[3]=((C_word*)t0)[4];
tp(4,av2);}}}

/* k14761 in lp in k14788 in k14716 in k14696 in ##sys#exact-integer-nth-root/loc in k8543 */
static void C_ccall f_14763(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(39,c,3)))){
C_save_and_reclaim((void *)f_14763,c,av);}
a=C_alloc(39);
t2=C_s_a_i_quotient(&a,2,((C_word*)t0)[2],t1);
t3=C_s_a_i_plus(&a,2,((C_word*)t0)[3],t2);
t4=C_s_a_i_quotient(&a,2,t3,((C_word*)t0)[4]);
/* library.scm:2217: lp */
t5=((C_word*)((C_word*)t0)[5])[1];
f_14733(t5,((C_word*)t0)[6],((C_word*)t0)[7],t4);}

/* k14772 in lp in k14788 in k14716 in k14696 in ##sys#exact-integer-nth-root/loc in k8543 */
static void C_ccall f_14774(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(29,c,3)))){
C_save_and_reclaim((void *)f_14774,c,av);}
a=C_alloc(29);
t2=C_s_a_i_minus(&a,2,((C_word*)t0)[2],t1);
/* library.scm:2221: scheme#values */{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=0;
av2[1]=((C_word*)t0)[3];
av2[2]=((C_word*)t0)[4];
av2[3]=t2;
C_values(4,av2);}}

/* k14788 in k14716 in k14696 in ##sys#exact-integer-nth-root/loc in k8543 */
static void C_ccall f_14790(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(48,c,4)))){
C_save_and_reclaim((void *)f_14790,c,av);}
a=C_alloc(48);
t2=C_s_a_i_quotient(&a,2,((C_word*)t0)[2],t1);
t3=C_s_a_i_plus(&a,2,((C_word*)t0)[3],t2);
t4=C_s_a_i_quotient(&a,2,t3,((C_word*)t0)[4]);
t5=C_SCHEME_UNDEFINED;
t6=(*a=C_VECTOR_TYPE|1,a[1]=t5,tmp=(C_word)a,a+=2,tmp);
t7=C_set_block_item(t6,0,(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_14733,a[2]=((C_word*)t0)[5],a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[4],a[5]=t6,a[6]=((C_word)li423),tmp=(C_word)a,a+=7,tmp));
t8=((C_word*)t6)[1];
f_14733(t8,((C_word*)t0)[6],((C_word*)t0)[7],t4);}

/* k14792 in k14696 in ##sys#exact-integer-nth-root/loc in k8543 */
static void C_ccall f_14794(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_14794,c,av);}
/* library.scm:2208: scheme#inexact->exact */
t2=*((C_word*)lf[521]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=t1;
((C_proc)(void*)(*((C_word*)t2+1)))(3,av2);}}

/* k14796 in k14696 in ##sys#exact-integer-nth-root/loc in k8543 */
static void C_ccall f_14798(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_14798,c,av);}
/* library.scm:2208: scheme#ceiling */
t2=*((C_word*)lf[549]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=t1;
((C_proc)(void*)(*((C_word*)t2+1)))(3,av2);}}

/* ##sys#integer-power in k8543 */
static void C_ccall f_14814(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(8,c,4)))){
C_save_and_reclaim((void *)f_14814,c,av);}
a=C_alloc(8);
if(C_truep(C_i_negativep(t3))){
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14832,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
t5=C_s_a_u_i_integer_negate(&a,1,t3);
/* library.scm:2226: ##sys#integer-power */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[531]+1));
C_word *av2=av;
av2[0]=*((C_word*)lf[531]+1);
av2[1]=t4;
av2[2]=t2;
av2[3]=t5;
tp(4,av2);}}
else{
t4=C_SCHEME_UNDEFINED;
t5=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t6=C_set_block_item(t5,0,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_14843,a[2]=t5,a[3]=t2,a[4]=((C_word)li425),tmp=(C_word)a,a+=5,tmp));
t7=((C_word*)t5)[1];
f_14843(t7,t1,C_fix(1),t3);}}

/* k14830 in ##sys#integer-power in k8543 */
static void C_ccall f_14832(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_14832,c,av);}
/* library.scm:2226: ##sys#/-2 */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[529]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[529]+1);
av2[1]=((C_word*)t0)[2];
av2[2]=C_fix(1);
av2[3]=t1;
tp(4,av2);}}

/* lp in ##sys#integer-power in k8543 */
static void C_fcall f_14843(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a;
loop:
if(C_unlikely(!C_demand(C_calculate_demand(62,0,3)))){
C_save_and_reclaim_args((void *)trf_14843,4,t0,t1,t2,t3);}
a=C_alloc(62);
t4=C_eqp(t3,C_fix(0));
if(C_truep(t4)){
t5=t1;{
C_word av2[2];
av2[0]=t5;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}
else{
if(C_truep(C_i_evenp(t3))){
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_14865,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
t6=C_s_a_i_arithmetic_shift(&a,2,t3,C_fix(-1));
/* library.scm:2231: lp */
t8=t5;
t9=C_fix(1);
t10=t6;
t1=t8;
t2=t9;
t3=t10;
goto loop;}
else{
t5=C_s_a_i_times(&a,2,t2,((C_word*)t0)[3]);
t6=C_s_a_i_minus(&a,2,t3,C_fix(1));
/* library.scm:2233: lp */
t8=t1;
t9=t5;
t10=t6;
t1=t8;
t2=t9;
t3=t10;
goto loop;}}}

/* k14863 in lp in ##sys#integer-power in k8543 */
static void C_ccall f_14865(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(66,c,1)))){
C_save_and_reclaim((void *)f_14865,c,av);}
a=C_alloc(66);
t2=C_s_a_i_times(&a,2,t1,t1);
t3=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_s_a_i_times(&a,2,((C_word*)t0)[3],t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* scheme#expt in k8543 */
static void C_ccall f_14882(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(21,c,4)))){
C_save_and_reclaim((void *)f_14882,c,av);}
a=C_alloc(21);
t4=C_SCHEME_UNDEFINED;
t5=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t6=C_SCHEME_UNDEFINED;
t7=(*a=C_VECTOR_TYPE|1,a[1]=t6,tmp=(C_word)a,a+=2,tmp);
t8=C_set_block_item(t5,0,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14885,a[2]=((C_word)li427),tmp=(C_word)a,a+=3,tmp));
t9=C_set_block_item(t7,0,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14899,a[2]=((C_word)li428),tmp=(C_word)a,a+=3,tmp));
t10=C_i_numberp(t2);
if(C_truep(C_i_not(t10))){
/* library.scm:2245: ##sys#error-bad-number */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[373]+1));
C_word *av2=av;
av2[0]=*((C_word*)lf[373]+1);
av2[1]=t1;
av2[2]=t2;
av2[3]=lf[594];
tp(4,av2);}}
else{
t11=C_i_numberp(t3);
if(C_truep(C_i_not(t11))){
/* library.scm:2246: ##sys#error-bad-number */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[373]+1));
C_word *av2=av;
av2[0]=*((C_word*)lf[373]+1);
av2[1]=t1;
av2[2]=t3;
av2[3]=lf[594];
tp(4,av2);}}
else{
t12=C_i_ratnump(t2);
t13=(C_truep(t12)?C_i_not(C_i_inexactp(t3)):C_SCHEME_FALSE);
if(C_truep(t13)){
t14=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_14951,a[2]=t1,a[3]=t2,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
/* library.scm:2250: scheme#expt */
t15=*((C_word*)lf[533]+1);{
C_word *av2=av;
av2[0]=t15;
av2[1]=t14;
av2[2]=C_u_i_ratnum_num(t2);
av2[3]=t3;
((C_proc)(void*)(*((C_word*)t15+1)))(4,av2);}}
else{
if(C_truep(C_i_ratnump(t3))){
if(C_truep(C_i_exact_integerp(t2))){
if(C_truep(C_i_negativep(t2))){
t14=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_14990,a[2]=t3,a[3]=t5,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
/* library.scm:2257: scheme#exact->inexact */
t15=*((C_word*)lf[62]+1);{
C_word *av2=av;
av2[0]=t15;
av2[1]=t14;
av2[2]=t2;
((C_proc)(void*)(*((C_word*)t15+1)))(3,av2);}}
else{
t14=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_14997,a[2]=t2,a[3]=t3,a[4]=((C_word)li429),tmp=(C_word)a,a+=5,tmp);
t15=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_15009,a[2]=t3,a[3]=t2,a[4]=((C_word)li430),tmp=(C_word)a,a+=5,tmp);
/* library.scm:2258: ##sys#call-with-values */{
C_word *av2=av;
av2[0]=0;
av2[1]=t1;
av2[2]=t14;
av2[3]=t15;
C_call_with_values(4,av2);}}}
else{
if(C_truep(C_i_flonump(t2))){
t14=C_a_i_exact_to_inexact(&a,1,t3);
/* library.scm:2267: log-expt */
f_14885(t1,t2,t14);}
else{
/* library.scm:2268: slow-expt */
f_14899(t1,t2,t3);}}}
else{
t14=C_i_cplxnump(t3);
t15=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_15053,a[2]=t7,a[3]=t1,a[4]=t2,a[5]=t3,a[6]=t5,tmp=(C_word)a,a+=7,tmp);
if(C_truep(t14)){
t16=t15;
f_15053(t16,t14);}
else{
t16=C_i_cplxnump(t2);
t17=t15;
f_15053(t17,(C_truep(t16)?C_i_not(C_i_integerp(t3)):C_SCHEME_FALSE));}}}}}}

/* log-expt in scheme#expt in k8543 */
static void C_fcall f_14885(C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,0,2)))){
C_save_and_reclaim_args((void *)trf_14885,3,t1,t2,t3);}
a=C_alloc(4);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_14897,a[2]=t3,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* library.scm:2238: ##sys#log-1 */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[564]+1));
C_word av2[3];
av2[0]=*((C_word*)lf[564]+1);
av2[1]=t4;
av2[2]=t2;
tp(3,av2);}}

/* k14895 in log-expt in scheme#expt in k8543 */
static void C_ccall f_14897(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(33,c,2)))){
C_save_and_reclaim((void *)f_14897,c,av);}
a=C_alloc(33);
t2=C_s_a_i_times(&a,2,((C_word*)t0)[2],t1);
/* library.scm:2238: scheme#exp */
t3=*((C_word*)lf[562]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t3;
av2[1]=((C_word*)t0)[3];
av2[2]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(3,av2);}}

/* slow-expt in scheme#expt in k8543 */
static void C_fcall f_14899(C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,0,6)))){
C_save_and_reclaim_args((void *)trf_14899,3,t1,t2,t3);}
a=C_alloc(4);
t4=C_eqp(C_fix(0),t2);
if(C_truep(t4)){
/* library.scm:2241: ##sys#signal-hook */
t5=C_fast_retrieve(lf[194]);{
C_word av2[7];
av2[0]=t5;
av2[1]=t1;
av2[2]=lf[565];
av2[3]=lf[594];
av2[4]=lf[595];
av2[5]=t2;
av2[6]=t3;
((C_proc)(void*)(*((C_word*)t5+1)))(7,av2);}}
else{
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_14920,a[2]=t3,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* library.scm:2244: ##sys#log-1 */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[564]+1));
C_word av2[3];
av2[0]=*((C_word*)lf[564]+1);
av2[1]=t5;
av2[2]=t2;
tp(3,av2);}}}

/* k14918 in slow-expt in scheme#expt in k8543 */
static void C_ccall f_14920(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(33,c,2)))){
C_save_and_reclaim((void *)f_14920,c,av);}
a=C_alloc(33);
t2=C_s_a_i_times(&a,2,((C_word*)t0)[2],t1);
/* library.scm:2244: scheme#exp */
t3=*((C_word*)lf[562]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t3;
av2[1]=((C_word*)t0)[3];
av2[2]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(3,av2);}}

/* k14949 in scheme#expt in k8543 */
static void C_ccall f_14951(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(33,c,3)))){
C_save_and_reclaim((void *)f_14951,c,av);}
a=C_alloc(33);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_14955,a[2]=((C_word*)t0)[2],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t3=C_u_i_ratnum_denom(((C_word*)t0)[3]);
t4=C_s_a_i_negate(&a,1,((C_word*)t0)[4]);
/* library.scm:2251: scheme#expt */
t5=*((C_word*)lf[533]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t5;
av2[1]=t2;
av2[2]=t3;
av2[3]=t4;
((C_proc)(void*)(*((C_word*)t5+1)))(4,av2);}}

/* k14953 in k14949 in scheme#expt in k8543 */
static void C_ccall f_14955(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(33,c,1)))){
C_save_and_reclaim((void *)f_14955,c,av);}
a=C_alloc(33);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_s_a_i_times(&a,2,((C_word*)t0)[3],t1);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* k14988 in scheme#expt in k8543 */
static void C_ccall f_14990(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(11,c,3)))){
C_save_and_reclaim((void *)f_14990,c,av);}
a=C_alloc(11);
t2=C_a_i_exact_to_inexact(&a,1,((C_word*)t0)[2]);
/* library.scm:2257: log-expt */
f_14885(((C_word*)t0)[4],t1,t2);}

/* a14996 in scheme#expt in k8543 */
static void C_ccall f_14997(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,4)))){
C_save_and_reclaim((void *)f_14997,c,av);}
/* library.scm:2259: ##sys#exact-integer-nth-root/loc */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[592]+1));
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=*((C_word*)lf[592]+1);
av2[1]=t1;
av2[2]=lf[594];
av2[3]=((C_word*)t0)[2];
av2[4]=C_u_i_ratnum_denom(((C_word*)t0)[3]);
tp(5,av2);}}

/* a15008 in scheme#expt in k8543 */
static void C_ccall f_15009(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(4,c,3)))){
C_save_and_reclaim((void *)f_15009,c,av);}
a=C_alloc(4);
t4=C_eqp(t3,C_fix(0));
if(C_truep(t4)){
/* library.scm:2262: ##sys#integer-power */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[531]+1));
C_word *av2=av;
av2[0]=*((C_word*)lf[531]+1);
av2[1]=t1;
av2[2]=t2;
av2[3]=C_u_i_ratnum_num(((C_word*)t0)[2]);
tp(4,av2);}}
else{
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_15029,a[2]=t1,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
/* library.scm:2264: scheme#exact->inexact */
t6=*((C_word*)lf[62]+1);{
C_word *av2=av;
av2[0]=t6;
av2[1]=t5;
av2[2]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t6+1)))(3,av2);}}}

/* k15027 in a15008 in scheme#expt in k8543 */
static void C_ccall f_15029(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,2)))){
C_save_and_reclaim((void *)f_15029,c,av);}
a=C_alloc(4);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_15033,a[2]=t1,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
/* library.scm:2265: scheme#exact->inexact */
t3=*((C_word*)lf[62]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t3+1)))(3,av2);}}

/* k15031 in k15027 in a15008 in scheme#expt in k8543 */
static void C_ccall f_15033(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,1)))){
C_save_and_reclaim((void *)f_15033,c,av);}
a=C_alloc(4);
t2=C_a_i_flonum_expt(&a,2,((C_word*)t0)[2],t1);
t3=((C_word*)t0)[3];{
C_word *av2=av;
av2[0]=t3;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* k15051 in scheme#expt in k8543 */
static void C_fcall f_15053(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(7,0,3)))){
C_save_and_reclaim_args((void *)trf_15053,2,t0,t1);}
a=C_alloc(7);
if(C_truep(t1)){
/* library.scm:2270: slow-expt */
f_14899(((C_word*)t0)[3],((C_word*)t0)[4],((C_word*)t0)[5]);}
else{
t2=(C_truep(C_i_flonump(((C_word*)t0)[5]))?C_i_not(C_u_i_fpintegerp(((C_word*)t0)[5])):C_SCHEME_FALSE);
if(C_truep(t2)){
if(C_truep(C_i_negativep(((C_word*)t0)[4]))){
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_15073,a[2]=((C_word*)t0)[6],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[5],tmp=(C_word)a,a+=5,tmp);
/* library.scm:2274: scheme#exact->inexact */
t4=*((C_word*)lf[62]+1);{
C_word av2[3];
av2[0]=t4;
av2[1]=t3;
av2[2]=((C_word*)t0)[4];
((C_proc)(void*)(*((C_word*)t4+1)))(3,av2);}}
else{
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_15081,a[2]=((C_word*)t0)[5],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* library.scm:2276: scheme#exact->inexact */
t4=*((C_word*)lf[62]+1);{
C_word av2[3];
av2[0]=t4;
av2[1]=t3;
av2[2]=((C_word*)t0)[4];
((C_proc)(void*)(*((C_word*)t4+1)))(3,av2);}}}
else{
if(C_truep(C_i_flonump(((C_word*)t0)[4]))){
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_15088,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* library.scm:2278: scheme#exact->inexact */
t4=*((C_word*)lf[62]+1);{
C_word av2[3];
av2[0]=t4;
av2[1]=t3;
av2[2]=((C_word*)t0)[5];
((C_proc)(void*)(*((C_word*)t4+1)))(3,av2);}}
else{
t3=C_i_inexactp(((C_word*)t0)[4]);
t4=(C_truep(t3)?t3:C_i_inexactp(((C_word*)t0)[5]));
if(C_truep(t4)){
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_15104,a[2]=((C_word*)t0)[3],tmp=(C_word)a,a+=3,tmp);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_15108,a[2]=t5,a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
/* library.scm:2282: scheme#inexact->exact */
t7=*((C_word*)lf[521]+1);{
C_word av2[3];
av2[0]=t7;
av2[1]=t6;
av2[2]=((C_word*)t0)[5];
((C_proc)(void*)(*((C_word*)t7+1)))(3,av2);}}
else{
/* library.scm:2283: ##sys#integer-power */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[531]+1));
C_word av2[4];
av2[0]=*((C_word*)lf[531]+1);
av2[1]=((C_word*)t0)[3];
av2[2]=((C_word*)t0)[4];
av2[3]=((C_word*)t0)[5];
tp(4,av2);}}}}}}

/* k15071 in k15051 in scheme#expt in k8543 */
static void C_ccall f_15073(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,c,2)))){
C_save_and_reclaim((void *)f_15073,c,av);}
a=C_alloc(5);
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_15077,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t1,tmp=(C_word)a,a+=5,tmp);
/* library.scm:2274: scheme#exact->inexact */
t3=*((C_word*)lf[62]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=((C_word*)t0)[4];
((C_proc)(void*)(*((C_word*)t3+1)))(3,av2);}}

/* k15075 in k15071 in k15051 in scheme#expt in k8543 */
static void C_ccall f_15077(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_15077,c,av);}
/* library.scm:2274: log-expt */
f_14885(((C_word*)t0)[3],((C_word*)t0)[4],t1);}

/* k15079 in k15051 in scheme#expt in k8543 */
static void C_ccall f_15081(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,1)))){
C_save_and_reclaim((void *)f_15081,c,av);}
a=C_alloc(4);
t2=C_a_i_flonum_expt(&a,2,t1,((C_word*)t0)[2]);
t3=((C_word*)t0)[3];{
C_word *av2=av;
av2[0]=t3;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* k15086 in k15051 in scheme#expt in k8543 */
static void C_ccall f_15088(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,1)))){
C_save_and_reclaim((void *)f_15088,c,av);}
a=C_alloc(4);
t2=C_a_i_flonum_expt(&a,2,((C_word*)t0)[2],t1);
t3=((C_word*)t0)[3];{
C_word *av2=av;
av2[0]=t3;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* k15102 in k15051 in scheme#expt in k8543 */
static void C_ccall f_15104(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_15104,c,av);}
/* library.scm:2282: scheme#exact->inexact */
t2=*((C_word*)lf[62]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=t1;
((C_proc)(void*)(*((C_word*)t2+1)))(3,av2);}}

/* k15106 in k15051 in scheme#expt in k8543 */
static void C_ccall f_15108(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_15108,c,av);}
/* library.scm:2282: ##sys#integer-power */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[531]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[531]+1);
av2[1]=((C_word*)t0)[2];
av2[2]=((C_word*)t0)[3];
av2[3]=t1;
tp(4,av2);}}

/* ##sys#internal-gcd in k8543 */
static void C_fcall f_15149(C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,0,3)))){
C_save_and_reclaim_args((void *)trf_15149,4,t1,t2,t3,t4);}
a=C_alloc(5);
if(C_truep(C_i_exact_integerp(t3))){
if(C_truep(C_i_exact_integerp(t4))){
t5=t1;{
C_word av2[2];
av2[0]=t5;
av2[1]=C_s_a_u_i_integer_gcd(&a,2,t3,t4);
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}
else{
t5=(C_truep(C_i_flonump(t4))?C_u_i_fpintegerp(t4):C_SCHEME_FALSE);
if(C_truep(t5)){
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_15182,a[2]=t3,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* library.scm:2291: scheme#inexact->exact */
t7=*((C_word*)lf[521]+1);{
C_word av2[3];
av2[0]=t7;
av2[1]=t6;
av2[2]=t4;
((C_proc)(void*)(*((C_word*)t7+1)))(3,av2);}}
else{
/* library.scm:2292: ##sys#error-bad-integer */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[358]+1));
C_word av2[4];
av2[0]=*((C_word*)lf[358]+1);
av2[1]=t1;
av2[2]=t4;
av2[3]=t2;
tp(4,av2);}}}}
else{
t5=(C_truep(C_i_flonump(t3))?C_u_i_fpintegerp(t3):C_SCHEME_FALSE);
if(C_truep(t5)){
if(C_truep(C_i_flonump(t4))){
t6=C_a_i_flonum_gcd(&a,2,t3,t4);
t7=t1;{
C_word av2[2];
av2[0]=t7;
av2[1]=t6;
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}
else{
if(C_truep(C_i_exact_integerp(t4))){
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_15211,a[2]=t4,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* library.scm:2298: scheme#inexact->exact */
t7=*((C_word*)lf[521]+1);{
C_word av2[3];
av2[0]=t7;
av2[1]=t6;
av2[2]=t3;
((C_proc)(void*)(*((C_word*)t7+1)))(3,av2);}}
else{
/* library.scm:2299: ##sys#error-bad-integer */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[358]+1));
C_word av2[4];
av2[0]=*((C_word*)lf[358]+1);
av2[1]=t1;
av2[2]=t4;
av2[3]=t2;
tp(4,av2);}}}}
else{
/* library.scm:2300: ##sys#error-bad-integer */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[358]+1));
C_word av2[4];
av2[0]=*((C_word*)lf[358]+1);
av2[1]=t1;
av2[2]=t3;
av2[3]=t2;
tp(4,av2);}}}}

/* k15180 in ##sys#internal-gcd in k8543 */
static void C_ccall f_15182(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,c,2)))){
C_save_and_reclaim((void *)f_15182,c,av);}
a=C_alloc(5);
t2=C_s_a_u_i_integer_gcd(&a,2,((C_word*)t0)[2],t1);
/* library.scm:2291: scheme#exact->inexact */
t3=*((C_word*)lf[62]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t3;
av2[1]=((C_word*)t0)[3];
av2[2]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(3,av2);}}

/* k15209 in ##sys#internal-gcd in k8543 */
static void C_ccall f_15211(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,c,2)))){
C_save_and_reclaim((void *)f_15211,c,av);}
a=C_alloc(5);
t2=C_s_a_u_i_integer_gcd(&a,2,t1,((C_word*)t0)[2]);
/* library.scm:2298: scheme#exact->inexact */
t3=*((C_word*)lf[62]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t3;
av2[1]=((C_word*)t0)[3];
av2[2]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(3,av2);}}

/* ##sys#gcd in k8543 */
static void C_ccall f_15219(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,4)))){
C_save_and_reclaim((void *)f_15219,c,av);}
/* library.scm:2302: ##sys#internal-gcd */
f_15149(t1,lf[597],t2,t3);}

/* scheme#gcd in k8543 */
static void C_ccall f_15225(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand((c-2)*C_SIZEOF_PAIR +6,c,4)))){
C_save_and_reclaim((void*)f_15225,c,av);}
a=C_alloc((c-2)*C_SIZEOF_PAIR+6);
t2=C_build_rest(&a,c,2,av);
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
t3=C_eqp(t2,C_SCHEME_END_OF_LIST);
if(C_truep(t3)){
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_fix(0);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t4=C_slot(t2,C_fix(0));
t5=C_slot(t2,C_fix(1));
t6=C_SCHEME_UNDEFINED;
t7=(*a=C_VECTOR_TYPE|1,a[1]=t6,tmp=(C_word)a,a+=2,tmp);
t8=C_set_block_item(t7,0,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_15245,a[2]=t7,a[3]=((C_word)li434),tmp=(C_word)a,a+=4,tmp));
t9=((C_word*)t7)[1];
f_15245(t9,t1,t4,t5);}}

/* loop in scheme#gcd in k8543 */
static void C_fcall f_15245(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(7,0,4)))){
C_save_and_reclaim_args((void *)trf_15245,4,t0,t1,t2,t3);}
a=C_alloc(7);
if(C_truep(C_i_nullp(t3))){
if(C_truep(C_i_integerp(t2))){
t4=t1;{
C_word av2[2];
av2[0]=t4;
av2[1]=C_s_a_i_abs(&a,1,t2);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
/* library.scm:2311: ##sys#error-bad-integer */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[358]+1));
C_word av2[4];
av2[0]=*((C_word*)lf[358]+1);
av2[1]=t1;
av2[2]=t2;
av2[3]=lf[597];
tp(4,av2);}}}
else{
t4=C_slot(t3,C_fix(0));
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_15270,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
/* library.scm:2313: ##sys#internal-gcd */
f_15149(t5,lf[597],t2,t4);}}

/* k15268 in loop in scheme#gcd in k8543 */
static void C_ccall f_15270(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_15270,c,av);}
/* library.scm:2313: loop */
t2=((C_word*)((C_word*)t0)[2])[1];
f_15245(t2,((C_word*)t0)[3],t1,C_slot(((C_word*)t0)[4],C_fix(1)));}

/* ##sys#lcm in k8543 */
static void C_ccall f_15276(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(5,c,4)))){
C_save_and_reclaim((void *)f_15276,c,av);}
a=C_alloc(5);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_15280,a[2]=t2,a[3]=t3,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
/* library.scm:2317: ##sys#internal-gcd */
f_15149(t4,lf[600],t2,t3);}

/* k15278 in ##sys#lcm in k8543 */
static void C_ccall f_15280(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(45,c,1)))){
C_save_and_reclaim((void *)f_15280,c,av);}
a=C_alloc(45);
t2=C_s_a_i_times(&a,2,((C_word*)t0)[2],((C_word*)t0)[3]);
t3=C_s_a_i_quotient(&a,2,t2,t1);
t4=((C_word*)t0)[4];{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_s_a_i_abs(&a,1,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* scheme#lcm in k8543 */
static void C_ccall f_15290(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand((c-2)*C_SIZEOF_PAIR +6,c,4)))){
C_save_and_reclaim((void*)f_15290,c,av);}
a=C_alloc((c-2)*C_SIZEOF_PAIR+6);
t2=C_build_rest(&a,c,2,av);
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
if(C_truep(C_rest_nullp(c,2))){
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_fix(1);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
t3=C_slot(t2,C_fix(0));
t4=C_slot(t2,C_fix(1));
t5=C_SCHEME_UNDEFINED;
t6=(*a=C_VECTOR_TYPE|1,a[1]=t5,tmp=(C_word)a,a+=2,tmp);
t7=C_set_block_item(t6,0,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_15310,a[2]=t6,a[3]=((C_word)li437),tmp=(C_word)a,a+=4,tmp));
t8=((C_word*)t6)[1];
f_15310(t8,t1,t3,t4);}}

/* loop in scheme#lcm in k8543 */
static void C_fcall f_15310(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(7,0,4)))){
C_save_and_reclaim_args((void *)trf_15310,4,t0,t1,t2,t3);}
a=C_alloc(7);
if(C_truep(C_i_nullp(t3))){
if(C_truep(C_i_integerp(t2))){
t4=t1;{
C_word av2[2];
av2[0]=t4;
av2[1]=C_s_a_i_abs(&a,1,t2);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
/* library.scm:2327: ##sys#error-bad-integer */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[358]+1));
C_word av2[4];
av2[0]=*((C_word*)lf[358]+1);
av2[1]=t1;
av2[2]=t2;
av2[3]=lf[600];
tp(4,av2);}}}
else{
t4=C_slot(t3,C_fix(0));
t5=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_15331,a[2]=t2,a[3]=t4,a[4]=((C_word*)t0)[2],a[5]=t1,a[6]=t3,tmp=(C_word)a,a+=7,tmp);
/* library.scm:2329: ##sys#internal-gcd */
f_15149(t5,lf[600],t2,t4);}}

/* k15329 in loop in scheme#lcm in k8543 */
static void C_ccall f_15331(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(38,c,3)))){
C_save_and_reclaim((void *)f_15331,c,av);}
a=C_alloc(38);
t2=C_s_a_i_times(&a,2,((C_word*)t0)[2],((C_word*)t0)[3]);
t3=C_s_a_i_quotient(&a,2,t2,t1);
/* library.scm:2330: loop */
t4=((C_word*)((C_word*)t0)[4])[1];
f_15310(t4,((C_word*)t0)[5],t3,C_slot(((C_word*)t0)[6],C_fix(1)));}

/* ##sys#integer->string/recursive in k8543 */
static void C_ccall f_15348(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(c!=5) C_bad_argc_2(c,5,t0);
if(C_unlikely(!C_demand(C_calculate_demand(6,c,3)))){
C_save_and_reclaim((void *)f_15348,c,av);}
a=C_alloc(6);
t5=C_fixnum_plus(t4,C_fix(1));
t6=C_fixnum_shift_right(t5,C_fix(1));
t7=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_15355,a[2]=t2,a[3]=t6,a[4]=t3,a[5]=t1,tmp=(C_word)a,a+=6,tmp);
/* library.scm:2337: ##sys#integer-power */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[531]+1));
C_word *av2=av;
av2[0]=*((C_word*)lf[531]+1);
av2[1]=t7;
av2[2]=t3;
av2[3]=t6;
tp(4,av2);}}

/* k15353 in ##sys#integer->string/recursive in k8543 */
static void C_ccall f_15355(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(10,c,4)))){
C_save_and_reclaim((void *)f_15355,c,av);}
a=C_alloc(10);
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_15360,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=((C_word)li440),tmp=(C_word)a,a+=5,tmp);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_15366,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word)li441),tmp=(C_word)a,a+=5,tmp);
/* library.scm:2336: ##sys#call-with-values */{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=0;
av2[1]=((C_word*)t0)[5];
av2[2]=t2;
av2[3]=t3;
C_call_with_values(4,av2);}}

/* a15359 in k15353 in ##sys#integer->string/recursive in k8543 */
static void C_ccall f_15360(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(3,c,3)))){
C_save_and_reclaim((void *)f_15360,c,av);}
a=C_alloc(3);
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)C_u_integer_quotient_and_remainder,a[2]=((C_word)li439),tmp=(C_word)a,a+=3,tmp);
/* library.scm:2336: g2775 */
t3=t2;{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t3;
av2[1]=t1;
av2[2]=((C_word*)t0)[2];
av2[3]=((C_word*)t0)[3];
((C_proc)C_fast_retrieve_proc(t3))(4,av2);}}

/* a15365 in k15353 in ##sys#integer->string/recursive in k8543 */
static void C_ccall f_15366(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(6,c,3)))){
C_save_and_reclaim((void *)f_15366,c,av);}
a=C_alloc(6);
t4=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_15370,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=t3,a[5]=((C_word*)t0)[3],tmp=(C_word)a,a+=6,tmp);
/* ##sys#number->string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[603]+1));
C_word *av2=av;
av2[0]=*((C_word*)lf[603]+1);
av2[1]=t4;
av2[2]=t2;
av2[3]=((C_word*)t0)[3];
tp(4,av2);}}

/* k15368 in a15365 in k15353 in ##sys#integer->string/recursive in k8543 */
static void C_ccall f_15370(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(12,c,3)))){
C_save_and_reclaim((void *)f_15370,c,av);}
a=C_alloc(12);
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_15373,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
t3=C_s_a_i_abs(&a,1,((C_word*)t0)[4]);
/* ##sys#number->string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[603]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[603]+1);
av2[1]=t2;
av2[2]=t3;
av2[3]=((C_word*)t0)[5];
tp(4,av2);}}

/* k15371 in k15368 in a15365 in k15353 in ##sys#integer->string/recursive in k8543 */
static void C_ccall f_15373(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,c,3)))){
C_save_and_reclaim((void *)f_15373,c,av);}
a=C_alloc(5);
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_15380,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t1,tmp=(C_word)a,a+=5,tmp);
t3=C_block_size(t1);
/* ##sys#make-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[379]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[379]+1);
av2[1]=t2;
av2[2]=C_fixnum_difference(((C_word*)t0)[4],t3);
av2[3]=C_make_character(48);
tp(4,av2);}}

/* k15378 in k15371 in k15368 in a15365 in k15353 in ##sys#integer->string/recursive in k8543 */
static void C_ccall f_15380(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,4)))){
C_save_and_reclaim((void *)f_15380,c,av);}
/* library.scm:2342: scheme#string-append */
t2=*((C_word*)lf[416]+1);{
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=((C_word*)t0)[3];
av2[3]=t1;
av2[4]=((C_word*)t0)[4];
((C_proc)(void*)(*((C_word*)t2+1)))(5,av2);}}

/* ##sys#extended-number->string in k8543 */
static void C_ccall f_15401(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(5,c,3)))){
C_save_and_reclaim((void *)f_15401,c,av);}
a=C_alloc(5);
if(C_truep(C_i_ratnump(t2))){
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_15415,a[2]=t1,a[3]=t2,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
/* ##sys#number->string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[603]+1));
C_word *av2=av;
av2[0]=*((C_word*)lf[603]+1);
av2[1]=t4;
av2[2]=C_u_i_ratnum_num(t2);
av2[3]=t3;
tp(4,av2);}}
else{
if(C_truep(C_i_cplxnump(t2))){
t4=C_u_i_cplxnum_real(t2);
t5=C_u_i_cplxnum_imag(t2);
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_15456,a[2]=t5,a[3]=t1,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
/* ##sys#number->string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[603]+1));
C_word *av2=av;
av2[0]=*((C_word*)lf[603]+1);
av2[1]=t6;
av2[2]=t4;
av2[3]=t3;
tp(4,av2);}}
else{
/* library.scm:2364: ##sys#error-bad-number */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[373]+1));
C_word *av2=av;
av2[0]=*((C_word*)lf[373]+1);
av2[1]=t1;
av2[2]=t2;
av2[3]=lf[609];
tp(4,av2);}}}}

/* k15413 in ##sys#extended-number->string in k8543 */
static void C_ccall f_15415(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,3)))){
C_save_and_reclaim((void *)f_15415,c,av);}
a=C_alloc(4);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_15419,a[2]=((C_word*)t0)[2],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* ##sys#number->string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[603]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[603]+1);
av2[1]=t2;
av2[2]=C_u_i_ratnum_denom(((C_word*)t0)[3]);
av2[3]=((C_word*)t0)[4];
tp(4,av2);}}

/* k15417 in k15413 in ##sys#extended-number->string in k8543 */
static void C_ccall f_15419(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,4)))){
C_save_and_reclaim((void *)f_15419,c,av);}
/* library.scm:2352: string-append */
t2=*((C_word*)lf[416]+1);{
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=((C_word*)t0)[3];
av2[3]=lf[605];
av2[4]=t1;
((C_proc)(void*)(*((C_word*)t2+1)))(5,av2);}}

/* k15454 in ##sys#extended-number->string in k8543 */
static void C_ccall f_15456(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,c,3)))){
C_save_and_reclaim((void *)f_15456,c,av);}
a=C_alloc(5);
t2=(C_truep(C_i_finitep(((C_word*)t0)[2]))?(C_truep(C_i_positivep(((C_word*)t0)[2]))?lf[606]:lf[607]):lf[607]);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_15464,a[2]=((C_word*)t0)[3],a[3]=t1,a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* ##sys#number->string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[603]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[603]+1);
av2[1]=t3;
av2[2]=((C_word*)t0)[2];
av2[3]=((C_word*)t0)[4];
tp(4,av2);}}

/* k15462 in k15454 in ##sys#extended-number->string in k8543 */
static void C_ccall f_15464(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,5)))){
C_save_and_reclaim((void *)f_15464,c,av);}
/* library.scm:2359: string-append */
t2=*((C_word*)lf[416]+1);{
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=((C_word*)t0)[3];
av2[3]=((C_word*)t0)[4];
av2[4]=t1;
av2[5]=lf[608];
((C_proc)(void*)(*((C_word*)t2+1)))(6,av2);}}

/* k15491 in safe-exponent in ##sys#string->compnum in k8543 */
static void C_ccall f_15493(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(44,c,1)))){
C_save_and_reclaim((void *)f_15493,c,av);}
a=C_alloc(44);
t2=C_s_a_i_times(&a,2,((C_word*)t0)[2],t1);
t3=C_a_i_exact_to_inexact(&a,1,t2);
t4=((C_word*)t0)[3];{
C_word *av2=av;
av2[0]=t4;
av2[1]=t3;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* k15494 in safe-exponent in ##sys#string->compnum in k8543 */
static void C_ccall f_15496(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(13,c,3)))){
C_save_and_reclaim((void *)f_15496,c,av);}
a=C_alloc(13);
t2=C_fixnum_difference(C_i_integer_length(((C_word*)t0)[2]),C_i_integer_length(t1));
t3=C_fixnum_difference(t2,*((C_word*)lf[428]+1));
t4=t3;
t5=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
if(C_truep(C_fixnum_lessp(((C_word*)t5)[1],C_fix(0)))){
t6=C_fixnum_negate(((C_word*)t5)[1]);
t7=C_s_a_i_arithmetic_shift(&a,2,((C_word*)t0)[2],t6);
t8=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_15511,a[2]=t5,a[3]=((C_word*)t0)[3],a[4]=t1,a[5]=t7,tmp=(C_word)a,a+=6,tmp);
/* library.scm:2383: round-quotient */
f_15575(t8,t7,t1);}
else{
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_15550,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
/* library.scm:2390: ##sys#integer-power */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[531]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[531]+1);
av2[1]=t6;
av2[2]=C_fix(10);
av2[3]=((C_word*)t0)[4];
tp(4,av2);}}}

/* k15509 in k15494 in safe-exponent in ##sys#string->compnum in k8543 */
static void C_ccall f_15511(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(44,c,3)))){
C_save_and_reclaim((void *)f_15511,c,av);}
a=C_alloc(44);
t2=t1;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_15514,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t3,tmp=(C_word)a,a+=5,tmp);
t5=((C_word*)t3)[1];
t6=C_i_integer_length(t5);
t7=*((C_word*)lf[428]+1);
if(C_truep(C_fixnum_greaterp(t6,*((C_word*)lf[428]+1)))){
t8=C_fixnum_plus(C_fix(1),((C_word*)((C_word*)t0)[2])[1]);
t9=C_set_block_item(((C_word*)t0)[2],0,t8);
t10=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_15532,a[2]=t3,a[3]=t4,tmp=(C_word)a,a+=4,tmp);
t11=C_s_a_i_times(&a,2,((C_word*)t0)[4],C_fix(2));
/* library.scm:2387: round-quotient */
f_15575(t10,((C_word*)t0)[5],t11);}
else{
t8=t4;
f_15514(t8,C_SCHEME_UNDEFINED);}}

/* k15512 in k15509 in k15494 in safe-exponent in ##sys#string->compnum in k8543 */
static void C_fcall f_15514(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,0,2)))){
C_save_and_reclaim_args((void *)trf_15514,2,t0,t1);}
a=C_alloc(4);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_15521,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* library.scm:2388: scheme#exact->inexact */
t3=*((C_word*)lf[62]+1);{
C_word av2[3];
av2[0]=t3;
av2[1]=t2;
av2[2]=((C_word*)((C_word*)t0)[4])[1];
((C_proc)(void*)(*((C_word*)t3+1)))(3,av2);}}

/* k15519 in k15512 in k15509 in k15494 in safe-exponent in ##sys#string->compnum in k8543 */
static void C_ccall f_15521(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(6,c,1)))){
C_save_and_reclaim((void *)f_15521,c,av);}
a=C_alloc(6);
t2=((C_word*)((C_word*)t0)[2])[1];
t3=C_a_i_bytevector(&a,1,C_fix(4));
t4=((C_word*)t0)[3];{
C_word *av2=av;
av2[0]=t4;
av2[1]=stub2829(t3,C_i_foreign_flonum_argumentp(t1),C_i_foreign_fixnum_argumentp(t2));
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* k15530 in k15509 in k15494 in safe-exponent in ##sys#string->compnum in k8543 */
static void C_ccall f_15532(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_15532,c,av);}
t2=C_mutate(((C_word *)((C_word*)t0)[2])+1,t1);
t3=((C_word*)t0)[3];
f_15514(t3,t2);}

/* k15548 in k15494 in safe-exponent in ##sys#string->compnum in k8543 */
static void C_ccall f_15550(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(33,c,1)))){
C_save_and_reclaim((void *)f_15550,c,av);}
a=C_alloc(33);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_s_a_i_times(&a,2,((C_word*)t0)[3],t1);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* round-quotient in k8543 */
static void C_fcall f_15575(C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(63,0,3)))){
C_save_and_reclaim_args((void *)trf_15575,3,t1,t2,t3);}
a=C_alloc(63);
t4=C_s_a_u_i_integer_quotient(&a,2,t2,t3);
t5=(C_truep(C_i_evenp(t4))?*((C_word*)lf[73]+1):*((C_word*)lf[75]+1));
t6=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_15590,a[2]=t2,a[3]=t3,a[4]=t1,a[5]=t4,tmp=(C_word)a,a+=6,tmp);
t7=C_s_a_i_remainder(&a,2,t2,t3);
t8=C_s_a_i_abs(&a,1,t7);
t9=C_s_a_i_times(&a,2,t8,C_fix(2));
t10=C_s_a_i_abs(&a,1,t3);
/* library.scm:2397: g2842 */
t11=t5;{
C_word av2[4];
av2[0]=t11;
av2[1]=t6;
av2[2]=t9;
av2[3]=t10;
((C_proc)(void*)(*((C_word*)t11+1)))(4,av2);}}

/* k15588 in round-quotient in k8543 */
static void C_ccall f_15590(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(29,c,1)))){
C_save_and_reclaim((void *)f_15590,c,av);}
a=C_alloc(29);
if(C_truep(t1)){
t2=C_eqp(C_i_negativep(((C_word*)t0)[2]),C_i_negativep(((C_word*)t0)[3]));
t3=((C_word*)t0)[4];{
C_word *av2=av;
av2[0]=t3;
av2[1]=(C_truep(t2)?C_s_a_i_plus(&a,2,((C_word*)t0)[5],C_fix(1)):C_s_a_i_plus(&a,2,((C_word*)t0)[5],C_fix(-1)));
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
t2=((C_word*)t0)[4];{
C_word *av2=av;
av2[0]=t2;
av2[1]=((C_word*)t0)[5];
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}}

/* ##sys#string->compnum in k8543 */
static void C_fcall f_15618(C_word t1,C_word t2,C_word t3,C_word t4,C_word t5){
C_word tmp;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word t19;
C_word t20;
C_word t21;
C_word t22;
C_word t23;
C_word t24;
C_word t25;
C_word t26;
C_word t27;
C_word t28;
C_word t29;
C_word t30;
C_word t31;
C_word t32;
C_word t33;
C_word t34;
C_word t35;
C_word t36;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(87,0,5)))){
C_save_and_reclaim_args((void *)trf_15618,5,t1,t2,t3,t4,t5);}
a=C_alloc(87);
t6=(*a=C_VECTOR_TYPE|1,a[1]=t5,tmp=(C_word)a,a+=2,tmp);
t7=C_SCHEME_UNDEFINED;
t8=(*a=C_VECTOR_TYPE|1,a[1]=t7,tmp=(C_word)a,a+=2,tmp);
t9=C_SCHEME_UNDEFINED;
t10=(*a=C_VECTOR_TYPE|1,a[1]=t9,tmp=(C_word)a,a+=2,tmp);
t11=C_SCHEME_UNDEFINED;
t12=(*a=C_VECTOR_TYPE|1,a[1]=t11,tmp=(C_word)a,a+=2,tmp);
t13=C_set_block_item(t8,0,C_SCHEME_FALSE);
t14=C_set_block_item(t10,0,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_15622,a[2]=t6,a[3]=t8,a[4]=((C_word)li445),tmp=(C_word)a,a+=5,tmp));
t15=C_set_block_item(t12,0,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_15636,a[2]=t6,a[3]=((C_word)li446),tmp=(C_word)a,a+=4,tmp));
t16=C_block_size(t3);
t17=C_fixnum_difference(t2,C_fix(1));
t18=C_fixnum_plus(C_fix(48),t17);
t19=C_make_character(C_unfix(t18));
t20=C_fixnum_difference(t2,C_fix(11));
t21=C_fixnum_plus(C_fix(97),t20);
t22=C_make_character(C_unfix(t21));
t23=C_fixnum_difference(t2,C_fix(11));
t24=C_fixnum_plus(C_fix(65),t23);
t25=C_make_character(C_unfix(t24));
t26=C_SCHEME_FALSE;
t27=(*a=C_VECTOR_TYPE|1,a[1]=t26,tmp=(C_word)a,a+=2,tmp);
t28=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_15716,a[2]=t16,a[3]=t3,a[4]=t2,a[5]=t19,a[6]=t22,a[7]=t25,a[8]=((C_word)li448),tmp=(C_word)a,a+=9,tmp);
t29=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_15824,a[2]=t16,a[3]=t3,a[4]=((C_word)li450),tmp=(C_word)a,a+=5,tmp);
t30=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_15874,a[2]=t3,a[3]=t2,a[4]=t27,a[5]=t10,a[6]=t29,a[7]=t28,a[8]=((C_word)li451),tmp=(C_word)a,a+=9,tmp);
t31=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_15930,a[2]=t16,a[3]=t3,a[4]=t2,a[5]=t28,a[6]=((C_word)li452),tmp=(C_word)a,a+=7,tmp);
t32=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_15988,a[2]=t16,a[3]=t3,a[4]=t12,a[5]=t31,a[6]=t30,a[7]=((C_word)li453),tmp=(C_word)a,a+=8,tmp);
t33=(*a=C_CLOSURE_TYPE|12,a[1]=(C_word)f_16202,a[2]=t10,a[3]=t32,a[4]=t3,a[5]=t2,a[6]=t16,a[7]=t12,a[8]=t31,a[9]=t27,a[10]=t6,a[11]=t30,a[12]=((C_word)li454),tmp=(C_word)a,a+=13,tmp);
t34=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_16548,a[2]=t16,a[3]=t3,a[4]=t33,a[5]=t10,a[6]=((C_word)li455),tmp=(C_word)a,a+=7,tmp);
t35=(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_16788,a[2]=t6,a[3]=t8,a[4]=t1,a[5]=t3,a[6]=t16,a[7]=t4,a[8]=t27,a[9]=t34,tmp=(C_word)a,a+=10,tmp);
/* library.scm:2583: scan-real */
t36=t34;
f_16548(t36,t35,t4);}

/* go-inexact! in ##sys#string->compnum in k8543 */
static C_word C_fcall f_15622(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_stack_overflow_check;{}
t2=C_eqp(((C_word*)((C_word*)t0)[2])[1],lf[612]);
if(C_truep(t2)){
t3=C_SCHEME_UNDEFINED;
return(t3);}
else{
t3=C_mutate(((C_word *)((C_word*)t0)[2])+1,lf[613]);
t4=((C_word*)((C_word*)t0)[3])[1];
if(C_truep(t4)){
t5=C_mutate(((C_word *)((C_word*)t0)[3])+1,t4);
return(t5);}
else{
t5=C_mutate(((C_word *)((C_word*)t0)[3])+1,t1);
return(t5);}}}

/* safe-exponent in ##sys#string->compnum in k8543 */
static void C_fcall f_15636(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(12,0,3)))){
C_save_and_reclaim_args((void *)trf_15636,4,t0,t1,t2,t3);}
a=C_alloc(12);
if(C_truep(t3)){
if(C_truep(C_i_not(t2))){
t4=t1;{
C_word av2[2];
av2[0]=t4;
av2[1]=C_fix(0);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
if(C_truep(C_i_greaterp(t3,C_fix(10000)))){
t4=C_eqp(((C_word*)((C_word*)t0)[2])[1],lf[613]);
if(C_truep(t4)){
if(C_truep(C_i_zerop(t2))){
t5=t1;{
C_word av2[2];
av2[0]=t5;
av2[1]=lf[503];
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}
else{
t5=C_i_greaterp(t2,lf[503]);
t6=t1;{
C_word av2[2];
av2[0]=t6;
av2[1]=(C_truep(t5)?lf[614]:lf[615]);
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}}
else{
t5=t1;{
C_word av2[2];
av2[0]=t5;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}}
else{
t4=C_fixnum_negate(C_fix(10000));
if(C_truep(C_i_lessp(t3,t4))){
t5=C_eqp(((C_word*)((C_word*)t0)[2])[1],lf[613]);
t6=t1;{
C_word av2[2];
av2[0]=t6;
av2[1]=(C_truep(t5)?lf[503]:C_SCHEME_FALSE);
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}
else{
t5=C_eqp(((C_word*)((C_word*)t0)[2])[1],lf[613]);
if(C_truep(t5)){
if(C_truep(C_i_not(C_i_negativep(t3)))){
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_15493,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* library.scm:2376: ##sys#integer-power */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[531]+1));
C_word av2[4];
av2[0]=*((C_word*)lf[531]+1);
av2[1]=t6;
av2[2]=C_fix(10);
av2[3]=t3;
tp(4,av2);}}
else{
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_15496,a[2]=t2,a[3]=t1,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
t7=C_s_a_i_abs(&a,1,t3);
/* library.scm:2377: ##sys#integer-power */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[531]+1));
C_word av2[4];
av2[0]=*((C_word*)lf[531]+1);
av2[1]=t6;
av2[2]=C_fix(10);
av2[3]=t7;
tp(4,av2);}}}
else{
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_15696,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* library.scm:2422: ##sys#integer-power */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[531]+1));
C_word av2[4];
av2[0]=*((C_word*)lf[531]+1);
av2[1]=t6;
av2[2]=C_fix(10);
av2[3]=t3;
tp(4,av2);}}}}}}
else{
t4=t1;{
C_word av2[2];
av2[0]=t4;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}}

/* k15694 in safe-exponent in ##sys#string->compnum in k8543 */
static void C_ccall f_15696(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(33,c,1)))){
C_save_and_reclaim((void *)f_15696,c,av);}
a=C_alloc(33);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_s_a_i_times(&a,2,((C_word*)t0)[3],t1);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* scan-digits in ##sys#string->compnum in k8543 */
static void C_fcall f_15716(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(13,0,3)))){
C_save_and_reclaim_args((void *)trf_15716,3,t0,t1,t2);}
a=C_alloc(13);
t3=C_SCHEME_UNDEFINED;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_set_block_item(t4,0,(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f_15722,a[2]=((C_word*)t0)[2],a[3]=t2,a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],a[7]=t4,a[8]=((C_word*)t0)[6],a[9]=((C_word*)t0)[7],a[10]=((C_word)li447),tmp=(C_word)a,a+=11,tmp));
t6=((C_word*)t4)[1];
f_15722(t6,t1,t2);}

/* lp in scan-digits in ##sys#string->compnum in k8543 */
static void C_fcall f_15722(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word *a;
loop:
if(C_unlikely(!C_demand(C_calculate_demand(6,0,2)))){
C_save_and_reclaim_args((void *)trf_15722,3,t0,t1,t2);}
a=C_alloc(6);
t3=C_eqp(t2,((C_word*)t0)[2]);
if(C_truep(t3)){
t4=C_fixnum_greaterp(t2,((C_word*)t0)[3]);
t5=t1;{
C_word av2[2];
av2[0]=t5;
av2[1]=(C_truep(t4)?C_a_i_cons(&a,2,t2,C_SCHEME_FALSE):C_SCHEME_FALSE);
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}
else{
t4=C_subchar(((C_word*)t0)[4],t2);
if(C_truep(C_fixnum_less_or_equal_p(((C_word*)t0)[5],C_fix(10)))){
t5=C_i_char_greater_or_equal_p(t4,C_make_character(48));
t6=(C_truep(t5)?C_u_i_char_less_or_equal_p(t4,((C_word*)t0)[6]):C_SCHEME_FALSE);
if(C_truep(t6)){
/* library.scm:2446: lp */
t10=t1;
t11=C_fixnum_plus(t2,C_fix(1));
t1=t10;
t2=t11;
goto loop;}
else{
t7=C_fixnum_greaterp(t2,((C_word*)t0)[3]);
t8=t1;{
C_word av2[2];
av2[0]=t8;
av2[1]=(C_truep(t7)?C_a_i_cons(&a,2,t2,t2):C_SCHEME_FALSE);
((C_proc)(void*)(*((C_word*)t8+1)))(2,av2);}}}
else{
t5=C_i_char_greater_or_equal_p(t4,C_make_character(48));
t6=(C_truep(t5)?C_u_i_char_less_or_equal_p(t4,C_make_character(57)):C_SCHEME_FALSE);
t7=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_15785,a[2]=((C_word*)t0)[7],a[3]=t1,a[4]=t2,a[5]=((C_word*)t0)[3],tmp=(C_word)a,a+=6,tmp);
if(C_truep(t6)){
t8=t7;
f_15785(t8,t6);}
else{
t8=(C_truep(C_u_i_char_greater_or_equal_p(t4,C_make_character(97)))?C_u_i_char_less_or_equal_p(t4,((C_word*)t0)[8]):C_SCHEME_FALSE);
t9=t7;
f_15785(t9,(C_truep(t8)?t8:(C_truep(C_u_i_char_greater_or_equal_p(t4,C_make_character(65)))?C_u_i_char_less_or_equal_p(t4,((C_word*)t0)[9]):C_SCHEME_FALSE)));}}}}

/* k15783 in lp in scan-digits in ##sys#string->compnum in k8543 */
static void C_fcall f_15785(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,0,2)))){
C_save_and_reclaim_args((void *)trf_15785,2,t0,t1);}
a=C_alloc(3);
if(C_truep(t1)){
/* library.scm:2451: lp */
t2=((C_word*)((C_word*)t0)[2])[1];
f_15722(t2,((C_word*)t0)[3],C_fixnum_plus(((C_word*)t0)[4],C_fix(1)));}
else{
t2=C_fixnum_greaterp(((C_word*)t0)[4],((C_word*)t0)[5]);
t3=((C_word*)t0)[3];{
C_word av2[2];
av2[0]=t3;
av2[1]=(C_truep(t2)?C_a_i_cons(&a,2,((C_word*)t0)[4],((C_word*)t0)[4]):C_SCHEME_FALSE);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}}

/* scan-hashes in ##sys#string->compnum in k8543 */
static void C_fcall f_15824(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(9,0,3)))){
C_save_and_reclaim_args((void *)trf_15824,3,t0,t1,t2);}
a=C_alloc(9);
t3=C_SCHEME_UNDEFINED;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_set_block_item(t4,0,(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_15830,a[2]=((C_word*)t0)[2],a[3]=t2,a[4]=((C_word*)t0)[3],a[5]=t4,a[6]=((C_word)li449),tmp=(C_word)a,a+=7,tmp));
t6=((C_word*)t4)[1];
f_15830(t6,t1,t2);}

/* lp in scan-hashes in ##sys#string->compnum in k8543 */
static void C_fcall f_15830(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word *a;
loop:
if(C_unlikely(!C_demand(C_calculate_demand(3,0,2)))){
C_save_and_reclaim_args((void *)trf_15830,3,t0,t1,t2);}
a=C_alloc(3);
t3=C_eqp(t2,((C_word*)t0)[2]);
if(C_truep(t3)){
t4=C_fixnum_greaterp(t2,((C_word*)t0)[3]);
t5=t1;{
C_word av2[2];
av2[0]=t5;
av2[1]=(C_truep(t4)?C_a_i_cons(&a,2,t2,C_SCHEME_FALSE):C_SCHEME_FALSE);
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}
else{
t4=C_subchar(((C_word*)t0)[4],t2);
t5=C_eqp(t4,C_make_character(35));
if(C_truep(t5)){
/* library.scm:2460: lp */
t8=t1;
t9=C_fixnum_plus(t2,C_fix(1));
t1=t8;
t2=t9;
goto loop;}
else{
t6=C_fixnum_greaterp(t2,((C_word*)t0)[3]);
t7=t1;{
C_word av2[2];
av2[0]=t7;
av2[1]=(C_truep(t6)?C_a_i_cons(&a,2,t2,t2):C_SCHEME_FALSE);
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}}}

/* scan-digits+hashes in ##sys#string->compnum in k8543 */
static void C_fcall f_15874(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(11,0,2)))){
C_save_and_reclaim_args((void *)trf_15874,5,t0,t1,t2,t3,t4);}
a=C_alloc(11);
t5=(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f_15878,a[2]=((C_word*)t0)[2],a[3]=t2,a[4]=((C_word*)t0)[3],a[5]=t3,a[6]=((C_word*)t0)[4],a[7]=((C_word*)t0)[5],a[8]=t1,a[9]=((C_word*)t0)[6],a[10]=t4,tmp=(C_word)a,a+=11,tmp);
if(C_truep(C_i_not(((C_word*)((C_word*)t0)[4])[1]))){
/* library.scm:2464: scan-digits */
t6=((C_word*)t0)[7];
f_15716(t6,t5,t2);}
else{
t6=t5;{
C_word av2[2];
av2[0]=t6;
av2[1]=C_SCHEME_FALSE;
f_15878(2,av2);}}}

/* k15876 in scan-digits+hashes in ##sys#string->compnum in k8543 */
static void C_ccall f_15878(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(10,c,2)))){
C_save_and_reclaim((void *)f_15878,c,av);}
a=C_alloc(10);
t2=(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_15881,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[6],a[8]=((C_word*)t0)[7],a[9]=((C_word*)t0)[8],tmp=(C_word)a,a+=10,tmp);
if(C_truep(t1)){
if(C_truep(C_i_cdr(t1))){
/* library.scm:2466: scan-hashes */
t3=((C_word*)t0)[9];
f_15824(t3,t2,C_u_i_cdr(t1));}
else{
t3=t2;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_SCHEME_FALSE;
f_15881(2,av2);}}}
else{
if(C_truep(((C_word*)t0)[10])){
/* library.scm:2467: scan-hashes */
t3=((C_word*)t0)[9];
f_15824(t3,t2,((C_word*)t0)[3]);}
else{
t3=t2;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_SCHEME_FALSE;
f_15881(2,av2);}}}}

/* k15879 in k15876 in scan-digits+hashes in ##sys#string->compnum in k8543 */
static void C_ccall f_15881(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(9,c,1)))){
C_save_and_reclaim((void *)f_15881,c,av);}
a=C_alloc(9);
t2=(C_truep(t1)?t1:((C_word*)t0)[2]);
if(C_truep(t2)){
t3=C_i_car(t2);
t4=C_s_a_i_digits_to_integer(&a,5,((C_word*)t0)[3],((C_word*)t0)[4],t3,((C_word*)t0)[5],((C_word*)t0)[6]);
if(C_truep(t4)){
if(C_truep(t1)){
t5=C_set_block_item(((C_word*)t0)[7],0,C_SCHEME_TRUE);
t6=(
/* library.scm:2475: go-inexact! */
  f_15622(((C_word*)((C_word*)t0)[8])[1],((C_word*)t0)[6])
);
t7=C_u_i_cdr(t2);
t8=((C_word*)t0)[9];{
C_word *av2=av;
av2[0]=t8;
av2[1]=C_a_i_cons(&a,2,t4,t7);
((C_proc)(void*)(*((C_word*)t8+1)))(2,av2);}}
else{
t5=C_u_i_cdr(t2);
t6=((C_word*)t0)[9];{
C_word *av2=av;
av2[0]=t6;
av2[1]=C_a_i_cons(&a,2,t4,t5);
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}}
else{
t5=((C_word*)t0)[9];{
C_word *av2=av;
av2[0]=t5;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}}
else{
t3=((C_word*)t0)[9];{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}}

/* scan-exponent in ##sys#string->compnum in k8543 */
static void C_fcall f_15930(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(7,0,2)))){
C_save_and_reclaim_args((void *)trf_15930,3,t0,t1,t2);}
a=C_alloc(7);
if(C_truep(C_fixnum_lessp(t2,((C_word*)t0)[2]))){
t3=C_subchar(((C_word*)t0)[3],t2);
t4=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_15945,a[2]=t2,a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=t1,a[6]=((C_word*)t0)[5],tmp=(C_word)a,a+=7,tmp);
t5=C_eqp(t3,C_make_character(43));
if(C_truep(t5)){
t6=t4;
f_15945(t6,lf[617]);}
else{
t6=C_eqp(t3,C_make_character(45));
t7=t4;
f_15945(t7,(C_truep(t6)?lf[616]:C_SCHEME_FALSE));}}
else{
t3=t1;{
C_word av2[2];
av2[0]=t3;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}}

/* k15943 in scan-exponent in ##sys#string->compnum in k8543 */
static void C_fcall f_15945(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(7,0,2)))){
C_save_and_reclaim_args((void *)trf_15945,2,t0,t1);}
a=C_alloc(7);
t2=(C_truep(t1)?C_fixnum_plus(((C_word*)t0)[2],C_fix(1)):((C_word*)t0)[2]);
if(C_truep(t2)){
t3=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_15954,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=t2,a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],tmp=(C_word)a,a+=7,tmp);
/* library.scm:2483: scan-digits */
t4=((C_word*)t0)[6];
f_15716(t4,t3,t2);}
else{
t3=((C_word*)t0)[5];{
C_word av2[2];
av2[0]=t3;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}}

/* k15952 in k15943 in scan-exponent in ##sys#string->compnum in k8543 */
static void C_ccall f_15954(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(9,c,1)))){
C_save_and_reclaim((void *)f_15954,c,av);}
a=C_alloc(9);
if(C_truep(t1)){
t2=C_i_car(t1);
t3=C_eqp(((C_word*)t0)[2],lf[616]);
t4=C_s_a_i_digits_to_integer(&a,5,((C_word*)t0)[3],((C_word*)t0)[4],t2,((C_word*)t0)[5],t3);
t5=C_u_i_cdr(t1);
t6=((C_word*)t0)[6];{
C_word *av2=av;
av2[0]=t6;
av2[1]=C_a_i_cons(&a,2,t4,t5);
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}
else{
t2=((C_word*)t0)[6];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}}

/* scan-decimal-tail in ##sys#string->compnum in k8543 */
static void C_fcall f_15988(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(9,0,4)))){
C_save_and_reclaim_args((void *)trf_15988,5,t0,t1,t2,t3,t4);}
a=C_alloc(9);
if(C_truep(C_fixnum_lessp(t2,((C_word*)t0)[2]))){
t5=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_15998,a[2]=t2,a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[2],a[5]=t1,a[6]=((C_word*)t0)[4],a[7]=t4,a[8]=((C_word*)t0)[5],tmp=(C_word)a,a+=9,tmp);
/* library.scm:2491: scan-digits+hashes */
t6=((C_word*)t0)[6];
f_15874(t6,t5,t2,t3,t4);}
else{
t5=t1;{
C_word av2[2];
av2[0]=t5;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}}

/* k15996 in scan-decimal-tail in ##sys#string->compnum in k8543 */
static void C_ccall f_15998(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(11,c,2)))){
C_save_and_reclaim((void *)f_15998,c,av);}
a=C_alloc(11);
t2=(C_truep(t1)?C_i_cdr(t1):((C_word*)t0)[2]);
t3=(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f_16007,a[2]=t2,a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=t1,a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[6],a[8]=((C_word*)t0)[2],a[9]=((C_word*)t0)[7],a[10]=((C_word*)t0)[8],tmp=(C_word)a,a+=11,tmp);
if(C_truep(((C_word*)t0)[7])){
t4=t3;
f_16007(t4,((C_word*)t0)[7]);}
else{
t4=C_i_not(t2);
t5=t3;
f_16007(t5,(C_truep(t4)?t4:C_fixnum_greaterp(t2,((C_word*)t0)[2])));}}

/* k16005 in k15996 in scan-decimal-tail in ##sys#string->compnum in k8543 */
static void C_fcall f_16007(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(10,0,2)))){
C_save_and_reclaim_args((void *)trf_16007,2,t0,t1);}
a=C_alloc(10);
if(C_truep(t1)){
t2=(C_truep(((C_word*)t0)[2])?C_subchar(((C_word*)t0)[3],((C_word*)t0)[2]):C_SCHEME_FALSE);
t3=C_eqp(t2,C_make_character(101));
t4=(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_16019,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],a[7]=((C_word*)t0)[8],a[8]=((C_word*)t0)[9],a[9]=((C_word*)t0)[10],tmp=(C_word)a,a+=10,tmp);
if(C_truep(t3)){
t5=t4;
f_16019(t5,t3);}
else{
t5=C_eqp(t2,C_make_character(115));
if(C_truep(t5)){
t6=t4;
f_16019(t6,t5);}
else{
t6=C_eqp(t2,C_make_character(102));
if(C_truep(t6)){
t7=t4;
f_16019(t7,t6);}
else{
t7=C_eqp(t2,C_make_character(100));
if(C_truep(t7)){
t8=t4;
f_16019(t8,t7);}
else{
t8=C_eqp(t2,C_make_character(108));
if(C_truep(t8)){
t9=t4;
f_16019(t9,t8);}
else{
t9=C_eqp(t2,C_make_character(69));
if(C_truep(t9)){
t10=t4;
f_16019(t10,t9);}
else{
t10=C_eqp(t2,C_make_character(83));
if(C_truep(t10)){
t11=t4;
f_16019(t11,t10);}
else{
t11=C_eqp(t2,C_make_character(70));
if(C_truep(t11)){
t12=t4;
f_16019(t12,t11);}
else{
t12=C_eqp(t2,C_make_character(68));
t13=t4;
f_16019(t13,(C_truep(t12)?t12:C_eqp(t2,C_make_character(76))));}}}}}}}}}
else{
t2=((C_word*)t0)[6];{
C_word av2[2];
av2[0]=t2;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}}

/* k16017 in k16005 in k15996 in scan-decimal-tail in ##sys#string->compnum in k8543 */
static void C_fcall f_16019(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(7,0,3)))){
C_save_and_reclaim_args((void *)trf_16019,2,t0,t1);}
a=C_alloc(7);
if(C_truep(t1)){
if(C_truep(C_fixnum_greaterp(((C_word*)t0)[2],((C_word*)t0)[3]))){
t2=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_16028,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[6],a[5]=((C_word*)t0)[7],a[6]=((C_word*)t0)[8],tmp=(C_word)a,a+=7,tmp);
/* library.scm:2499: scan-exponent */
t3=((C_word*)t0)[9];
f_15930(t3,t2,C_fixnum_plus(((C_word*)t0)[3],C_fix(1)));}
else{
t2=((C_word*)t0)[5];{
C_word av2[2];
av2[0]=t2;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}}
else{
t2=(C_truep(((C_word*)t0)[3])?((C_word*)t0)[3]:((C_word*)t0)[2]);
t3=(C_truep(((C_word*)t0)[4])?C_fixnum_difference(((C_word*)t0)[7],t2):C_SCHEME_FALSE);
t4=(C_truep(((C_word*)t0)[4])?C_i_car(((C_word*)t0)[4]):C_SCHEME_FALSE);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_16094,a[2]=((C_word*)t0)[8],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
/* library.scm:2509: safe-exponent */
t6=((C_word*)((C_word*)t0)[6])[1];
f_15636(t6,t5,t4,t3);}}

/* k16026 in k16017 in k16005 in k15996 in scan-decimal-tail in ##sys#string->compnum in k8543 */
static void C_ccall f_16028(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(8,c,3)))){
C_save_and_reclaim((void *)f_16028,c,av);}
a=C_alloc(8);
if(C_truep(t1)){
t2=C_i_car(t1);
if(C_truep(t2)){
t3=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_16040,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=t2,a[7]=((C_word*)t0)[5],tmp=(C_word)a,a+=8,tmp);
/* library.scm:2501: safe-exponent */
t4=((C_word*)((C_word*)t0)[4])[1];
f_15636(t4,t3,((C_word*)t0)[6],t2);}
else{
t3=((C_word*)t0)[3];{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}}
else{
t2=((C_word*)t0)[3];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}}

/* k16038 in k16026 in k16017 in k16005 in k15996 in scan-decimal-tail in ##sys#string->compnum in k8543 */
static void C_ccall f_16040(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(7,c,2)))){
C_save_and_reclaim((void *)f_16040,c,av);}
a=C_alloc(7);
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_16046,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],tmp=(C_word)a,a+=7,tmp);
if(C_truep(((C_word*)t0)[2])){
t3=C_i_cdr(((C_word*)t0)[2]);
t4=t2;
f_16046(t4,C_fixnum_difference(((C_word*)t0)[6],C_fixnum_difference(t3,((C_word*)t0)[7])));}
else{
t3=t2;
f_16046(t3,C_SCHEME_FALSE);}}
else{
t2=((C_word*)t0)[4];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}}

/* k16044 in k16038 in k16026 in k16017 in k16005 in k15996 in scan-decimal-tail in ##sys#string->compnum in k8543 */
static void C_fcall f_16046(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,0,3)))){
C_save_and_reclaim_args((void *)trf_16046,2,t0,t1);}
a=C_alloc(5);
t2=(C_truep(((C_word*)t0)[2])?C_i_car(((C_word*)t0)[2]):C_SCHEME_FALSE);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_16052,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],tmp=(C_word)a,a+=5,tmp);
/* library.scm:2504: safe-exponent */
t4=((C_word*)((C_word*)t0)[6])[1];
f_15636(t4,t3,t2,t1);}

/* k16050 in k16044 in k16038 in k16026 in k16017 in k16005 in k15996 in scan-decimal-tail in ##sys#string->compnum in k8543 */
static void C_ccall f_16052(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(32,c,1)))){
C_save_and_reclaim((void *)f_16052,c,av);}
a=C_alloc(32);
if(C_truep(t1)){
t2=C_s_a_i_plus(&a,2,((C_word*)t0)[2],t1);
t3=C_u_i_cdr(((C_word*)t0)[3]);
t4=((C_word*)t0)[4];{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_a_i_cons(&a,2,t2,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t2=C_u_i_cdr(((C_word*)t0)[3]);
t3=((C_word*)t0)[4];{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_a_i_cons(&a,2,((C_word*)t0)[2],t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}}

/* k16092 in k16017 in k16005 in k15996 in scan-decimal-tail in ##sys#string->compnum in k8543 */
static void C_ccall f_16094(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(32,c,1)))){
C_save_and_reclaim((void *)f_16094,c,av);}
a=C_alloc(32);
t2=(C_truep(((C_word*)t0)[2])?((C_word*)t0)[2]:C_fix(0));
if(C_truep(t1)){
t3=C_s_a_i_plus(&a,2,t2,t1);
t4=((C_word*)t0)[3];{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_a_i_cons(&a,2,t3,((C_word*)t0)[4]);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t3=((C_word*)t0)[3];{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_a_i_cons(&a,2,t2,((C_word*)t0)[4]);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}}

/* scan-ureal in ##sys#string->compnum in k8543 */
static void C_fcall f_16202(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(15,0,2)))){
C_save_and_reclaim_args((void *)trf_16202,4,t0,t1,t2,t3);}
a=C_alloc(15);
t4=(*a=C_CLOSURE_TYPE|14,a[1]=(C_word)f_16209,a[2]=((C_word*)t0)[2],a[3]=t3,a[4]=((C_word*)t0)[3],a[5]=t1,a[6]=t2,a[7]=((C_word*)t0)[4],a[8]=((C_word*)t0)[5],a[9]=((C_word*)t0)[6],a[10]=((C_word*)t0)[7],a[11]=((C_word*)t0)[8],a[12]=((C_word*)t0)[9],a[13]=((C_word*)t0)[10],a[14]=((C_word*)t0)[11],tmp=(C_word)a,a+=15,tmp);
t5=C_fixnum_plus(t2,C_fix(1));
if(C_truep(C_fixnum_greaterp(((C_word*)t0)[6],t5))){
t6=C_eqp(((C_word*)t0)[5],C_fix(10));
t7=t4;
f_16209(t7,(C_truep(t6)?C_eqp(C_subchar(((C_word*)t0)[4],t2),C_make_character(46)):C_SCHEME_FALSE));}
else{
t6=t4;
f_16209(t6,C_SCHEME_FALSE);}}

/* k16207 in scan-ureal in ##sys#string->compnum in k8543 */
static void C_fcall f_16209(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(14,0,4)))){
C_save_and_reclaim_args((void *)trf_16209,2,t0,t1);}
a=C_alloc(14);
if(C_truep(t1)){
t2=(
/* library.scm:2517: go-inexact! */
  f_15622(((C_word*)((C_word*)t0)[2])[1],((C_word*)t0)[3])
);
/* library.scm:2518: scan-decimal-tail */
t3=((C_word*)t0)[4];
f_15988(t3,((C_word*)t0)[5],C_fixnum_plus(((C_word*)t0)[6],C_fix(1)),((C_word*)t0)[3],C_SCHEME_FALSE);}
else{
t2=(*a=C_CLOSURE_TYPE|13,a[1]=(C_word)f_16222,a[2]=((C_word*)t0)[7],a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[8],a[6]=((C_word*)t0)[9],a[7]=((C_word*)t0)[4],a[8]=((C_word*)t0)[5],a[9]=((C_word*)t0)[10],a[10]=((C_word*)t0)[11],a[11]=((C_word*)t0)[12],a[12]=((C_word*)t0)[13],a[13]=((C_word*)t0)[14],tmp=(C_word)a,a+=14,tmp);
/* library.scm:2519: scan-digits+hashes */
t3=((C_word*)t0)[14];
f_15874(t3,t2,((C_word*)t0)[6],((C_word*)t0)[3],C_SCHEME_FALSE);}}

/* k16220 in k16207 in scan-ureal in ##sys#string->compnum in k8543 */
static void C_ccall f_16222(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(14,c,4)))){
C_save_and_reclaim((void *)f_16222,c,av);}
a=C_alloc(14);
if(C_truep(t1)){
t2=C_i_cdr(t1);
t3=(C_truep(t2)?C_subchar(((C_word*)t0)[2],C_u_i_cdr(t1)):C_SCHEME_FALSE);
t4=C_eqp(t3,C_make_character(46));
if(C_truep(t4)){
t5=(
/* library.scm:2522: go-inexact! */
  f_15622(((C_word*)((C_word*)t0)[3])[1],((C_word*)t0)[4])
);
t6=C_eqp(((C_word*)t0)[5],C_fix(10));
if(C_truep(t6)){
t7=C_fixnum_plus(C_u_i_cdr(t1),C_fix(1));
if(C_truep(C_fixnum_greaterp(((C_word*)t0)[6],t7))){
/* library.scm:2525: scan-decimal-tail */
t8=((C_word*)t0)[7];
f_15988(t8,((C_word*)t0)[8],C_fixnum_plus(C_u_i_cdr(t1),C_fix(1)),((C_word*)t0)[4],C_u_i_car(t1));}
else{
t8=C_u_i_car(t1);
t9=((C_word*)t0)[8];{
C_word *av2=av;
av2[0]=t9;
av2[1]=C_a_i_cons(&a,2,t8,C_SCHEME_FALSE);
((C_proc)(void*)(*((C_word*)t9+1)))(2,av2);}}}
else{
t7=((C_word*)t0)[8];{
C_word *av2=av;
av2[0]=t7;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}}
else{
t5=C_eqp(t3,C_make_character(101));
t6=(*a=C_CLOSURE_TYPE|13,a[1]=(C_word)f_16280,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=t1,a[7]=((C_word*)t0)[8],a[8]=((C_word*)t0)[9],a[9]=((C_word*)t0)[10],a[10]=t3,a[11]=((C_word*)t0)[11],a[12]=((C_word*)t0)[12],a[13]=((C_word*)t0)[13],tmp=(C_word)a,a+=14,tmp);
if(C_truep(t5)){
t7=t6;
f_16280(t7,t5);}
else{
t7=C_eqp(t3,C_make_character(115));
if(C_truep(t7)){
t8=t6;
f_16280(t8,t7);}
else{
t8=C_eqp(t3,C_make_character(102));
if(C_truep(t8)){
t9=t6;
f_16280(t9,t8);}
else{
t9=C_eqp(t3,C_make_character(100));
if(C_truep(t9)){
t10=t6;
f_16280(t10,t9);}
else{
t10=C_eqp(t3,C_make_character(108));
if(C_truep(t10)){
t11=t6;
f_16280(t11,t10);}
else{
t11=C_eqp(t3,C_make_character(69));
if(C_truep(t11)){
t12=t6;
f_16280(t12,t11);}
else{
t12=C_eqp(t3,C_make_character(83));
if(C_truep(t12)){
t13=t6;
f_16280(t13,t12);}
else{
t13=C_eqp(t3,C_make_character(70));
if(C_truep(t13)){
t14=t6;
f_16280(t14,t13);}
else{
t14=C_eqp(t3,C_make_character(68));
t15=t6;
f_16280(t15,(C_truep(t14)?t14:C_eqp(t3,C_make_character(76))));}}}}}}}}}}
else{
t2=((C_word*)t0)[8];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}}

/* k16278 in k16220 in k16207 in scan-ureal in ##sys#string->compnum in k8543 */
static void C_fcall f_16280(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,0,4)))){
C_save_and_reclaim_args((void *)trf_16280,2,t0,t1);}
a=C_alloc(5);
if(C_truep(t1)){
t2=(
/* library.scm:2529: go-inexact! */
  f_15622(((C_word*)((C_word*)t0)[2])[1],((C_word*)t0)[3])
);
t3=C_eqp(((C_word*)t0)[4],C_fix(10));
if(C_truep(t3)){
if(C_truep(C_fixnum_greaterp(((C_word*)t0)[5],C_u_i_cdr(((C_word*)t0)[6])))){
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_16298,a[2]=((C_word*)t0)[6],a[3]=((C_word*)t0)[7],a[4]=((C_word*)t0)[8],tmp=(C_word)a,a+=5,tmp);
/* library.scm:2532: scan-exponent */
t5=((C_word*)t0)[9];
f_15930(t5,t4,C_fixnum_plus(C_u_i_cdr(((C_word*)t0)[6]),C_fix(1)));}
else{
t4=((C_word*)t0)[7];{
C_word av2[2];
av2[0]=t4;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}}
else{
t4=((C_word*)t0)[7];{
C_word av2[2];
av2[0]=t4;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}}
else{
t2=C_eqp(((C_word*)t0)[10],C_make_character(47));
if(C_truep(t2)){
t3=C_set_block_item(((C_word*)t0)[11],0,C_SCHEME_FALSE);
if(C_truep(C_fixnum_greaterp(((C_word*)t0)[5],C_u_i_cdr(((C_word*)t0)[6])))){
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_16344,a[2]=((C_word*)t0)[6],a[3]=((C_word*)t0)[7],a[4]=((C_word*)t0)[12],tmp=(C_word)a,a+=5,tmp);
/* library.scm:2539: scan-digits+hashes */
t5=((C_word*)t0)[13];
f_15874(t5,t4,C_fixnum_plus(C_u_i_cdr(((C_word*)t0)[6]),C_fix(1)),C_SCHEME_FALSE,C_SCHEME_FALSE);}
else{
t4=((C_word*)t0)[7];{
C_word av2[2];
av2[0]=t4;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}}
else{
t3=((C_word*)t0)[7];{
C_word av2[2];
av2[0]=t3;
av2[1]=((C_word*)t0)[6];
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}}}

/* k16296 in k16278 in k16220 in k16207 in scan-ureal in ##sys#string->compnum in k8543 */
static void C_ccall f_16298(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,3)))){
C_save_and_reclaim((void *)f_16298,c,av);}
a=C_alloc(4);
if(C_truep(t1)){
t2=C_u_i_car(((C_word*)t0)[2]);
if(C_truep(t2)){
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_16308,a[2]=t1,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* library.scm:2534: safe-exponent */
t4=((C_word*)((C_word*)t0)[4])[1];
f_15636(t4,t3,t2,C_i_car(t1));}
else{
t3=((C_word*)t0)[3];{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}}
else{
t2=((C_word*)t0)[3];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}}

/* k16306 in k16296 in k16278 in k16220 in k16207 in scan-ureal in ##sys#string->compnum in k8543 */
static void C_ccall f_16308(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,c,1)))){
C_save_and_reclaim((void *)f_16308,c,av);}
a=C_alloc(3);
if(C_truep(t1)){
t2=C_u_i_cdr(((C_word*)t0)[2]);
t3=((C_word*)t0)[3];{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_a_i_cons(&a,2,t1,t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
t2=((C_word*)t0)[3];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}}

/* k16342 in k16278 in k16220 in k16207 in scan-ureal in ##sys#string->compnum in k8543 */
static void C_ccall f_16344(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,3)))){
C_save_and_reclaim((void *)f_16344,c,av);}
a=C_alloc(4);
if(C_truep(t1)){
t2=C_u_i_car(((C_word*)t0)[2]);
if(C_truep(t2)){
t3=C_i_car(t1);
if(C_truep(t3)){
t4=C_eqp(t3,C_fix(0));
if(C_truep(C_i_not(t4))){
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_16370,a[2]=t1,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* library.scm:2543: ##sys#/-2 */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[529]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[529]+1);
av2[1]=t5;
av2[2]=t2;
av2[3]=t3;
tp(4,av2);}}
else{
t5=C_eqp(((C_word*)((C_word*)t0)[4])[1],lf[612]);
if(C_truep(C_i_not(t5))){
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_16381,a[2]=t1,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* library.scm:2547: chicken.base#signum */
t7=*((C_word*)lf[185]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t7;
av2[1]=t6;
av2[2]=t2;
((C_proc)(void*)(*((C_word*)t7+1)))(3,av2);}}
else{
t6=((C_word*)t0)[3];{
C_word *av2=av;
av2[0]=t6;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}}}
else{
t4=((C_word*)t0)[3];{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}}
else{
t3=((C_word*)t0)[3];{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}}
else{
t2=((C_word*)t0)[3];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}}

/* k16368 in k16342 in k16278 in k16220 in k16207 in scan-ureal in ##sys#string->compnum in k8543 */
static void C_ccall f_16370(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,c,1)))){
C_save_and_reclaim((void *)f_16370,c,av);}
a=C_alloc(3);
t2=C_u_i_cdr(((C_word*)t0)[2]);
t3=((C_word*)t0)[3];{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_a_i_cons(&a,2,t1,t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* k16379 in k16342 in k16278 in k16220 in k16207 in scan-ureal in ##sys#string->compnum in k8543 */
static void C_ccall f_16381(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(7,c,1)))){
C_save_and_reclaim((void *)f_16381,c,av);}
a=C_alloc(7);
switch(t1){
case C_fix(-1):
t2=C_u_i_cdr(((C_word*)t0)[2]);
t3=((C_word*)t0)[3];{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_a_i_cons(&a,2,lf[615],t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}
case C_fix(0):
t2=C_flonum(&a,C_ub_i_flonum_quotient((double)0.0,(double)0.0));
t3=C_u_i_cdr(((C_word*)t0)[2]);
t4=((C_word*)t0)[3];{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_a_i_cons(&a,2,t2,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}
case C_fix(1):
t2=C_u_i_cdr(((C_word*)t0)[2]);
t3=((C_word*)t0)[3];{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_a_i_cons(&a,2,lf[614],t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}
default:
t2=((C_word*)t0)[3];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_SCHEME_UNDEFINED;
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}}

/* scan-real in ##sys#string->compnum in k8543 */
static void C_fcall f_16548(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(8,0,2)))){
C_save_and_reclaim_args((void *)trf_16548,3,t0,t1,t2);}
a=C_alloc(8);
if(C_truep(C_fixnum_lessp(t2,((C_word*)t0)[2]))){
t3=C_subchar(((C_word*)t0)[3],t2);
t4=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_16563,a[2]=t2,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=t1,a[6]=((C_word*)t0)[4],a[7]=((C_word*)t0)[5],tmp=(C_word)a,a+=8,tmp);
t5=C_eqp(t3,C_make_character(43));
if(C_truep(t5)){
t6=t4;
f_16563(t6,lf[617]);}
else{
t6=C_eqp(t3,C_make_character(45));
t7=t4;
f_16563(t7,(C_truep(t6)?lf[616]:C_SCHEME_FALSE));}}
else{
t3=t1;{
C_word av2[2];
av2[0]=t3;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}}

/* k16561 in scan-real in ##sys#string->compnum in k8543 */
static void C_fcall f_16563(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(11,0,4)))){
C_save_and_reclaim_args((void *)trf_16563,2,t0,t1);}
a=C_alloc(11);
t2=(C_truep(t1)?C_fixnum_plus(((C_word*)t0)[2],C_fix(1)):((C_word*)t0)[2]);
if(C_truep(C_fixnum_lessp(t2,((C_word*)t0)[3]))){
t3=C_subchar(((C_word*)t0)[4],t2);
t4=C_eqp(t3,C_make_character(105));
t5=(C_truep(t4)?t4:C_eqp(t3,C_make_character(73)));
if(C_truep(t5)){
if(C_truep(t1)){
t6=C_fixnum_plus(t2,C_fix(1));
t7=C_eqp(t6,((C_word*)t0)[3]);
if(C_truep(t7)){
t8=C_eqp(t1,lf[616]);
t9=(C_truep(t8)?C_a_i_cons(&a,2,C_fix(-1),t2):C_a_i_cons(&a,2,C_fix(1),t2));
if(C_truep(t9)){
t10=((C_word*)t0)[5];{
C_word av2[2];
av2[0]=t10;
av2[1]=t9;
((C_proc)(void*)(*((C_word*)t10+1)))(2,av2);}}
else{
/* library.scm:2572: scan-ureal */
t10=((C_word*)t0)[6];
f_16202(t10,((C_word*)t0)[5],t2,C_eqp(t1,lf[616]));}}
else{
t8=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_16621,a[2]=((C_word*)t0)[7],a[3]=t1,a[4]=t2,a[5]=((C_word*)t0)[3],a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[6],tmp=(C_word)a,a+=8,tmp);
t9=C_fixnum_plus(t2,C_fix(5));
if(C_truep(C_fixnum_less_or_equal_p(t9,((C_word*)t0)[3]))){
t10=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_16662,a[2]=t8,tmp=(C_word)a,a+=3,tmp);
/* library.scm:2566: scheme#substring */
t11=*((C_word*)lf[396]+1);{
C_word av2[5];
av2[0]=t11;
av2[1]=t10;
av2[2]=((C_word*)t0)[4];
av2[3]=t2;
av2[4]=C_fixnum_plus(t2,C_fix(5));
((C_proc)(void*)(*((C_word*)t11+1)))(5,av2);}}
else{
t10=t8;
f_16621(t10,C_SCHEME_FALSE);}}}
else{
/* library.scm:2572: scan-ureal */
t6=((C_word*)t0)[6];
f_16202(t6,((C_word*)t0)[5],t2,C_eqp(t1,lf[616]));}}
else{
t6=C_eqp(t3,C_make_character(110));
t7=(C_truep(t6)?t6:C_eqp(t3,C_make_character(78)));
if(C_truep(t7)){
if(C_truep(t1)){
t8=C_fixnum_plus(t2,C_fix(5));
if(C_truep(C_fixnum_less_or_equal_p(t8,((C_word*)t0)[3]))){
t9=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_16740,a[2]=((C_word*)t0)[7],a[3]=t1,a[4]=t2,a[5]=((C_word*)t0)[3],a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[6],tmp=(C_word)a,a+=8,tmp);
/* library.scm:2576: scheme#substring */
t10=*((C_word*)lf[396]+1);{
C_word av2[5];
av2[0]=t10;
av2[1]=t9;
av2[2]=((C_word*)t0)[4];
av2[3]=t2;
av2[4]=C_fixnum_plus(t2,C_fix(5));
((C_proc)(void*)(*((C_word*)t10+1)))(5,av2);}}
else{
/* library.scm:2581: scan-ureal */
t9=((C_word*)t0)[6];
f_16202(t9,((C_word*)t0)[5],t2,C_eqp(t1,lf[616]));}}
else{
/* library.scm:2581: scan-ureal */
t8=((C_word*)t0)[6];
f_16202(t8,((C_word*)t0)[5],t2,C_eqp(t1,lf[616]));}}
else{
/* library.scm:2582: scan-ureal */
t8=((C_word*)t0)[6];
f_16202(t8,((C_word*)t0)[5],t2,C_eqp(t1,lf[616]));}}}
else{
t3=((C_word*)t0)[5];{
C_word av2[2];
av2[0]=t3;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}}

/* k16619 in k16561 in scan-real in ##sys#string->compnum in k8543 */
static void C_fcall f_16621(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,0,3)))){
C_save_and_reclaim_args((void *)trf_16621,2,t0,t1);}
a=C_alloc(3);
if(C_truep(t1)){
t2=(
/* library.scm:2567: go-inexact! */
  f_15622(((C_word*)((C_word*)t0)[2])[1],C_eqp(((C_word*)t0)[3],lf[616]))
);
t3=C_eqp(((C_word*)t0)[3],lf[616]);
t4=(C_truep(t3)?lf[615]:lf[614]);
t5=C_fixnum_plus(((C_word*)t0)[4],C_fix(5));
if(C_truep(C_fixnum_lessp(t5,((C_word*)t0)[5]))){
t6=C_fixnum_plus(((C_word*)t0)[4],C_fix(5));
t7=C_a_i_cons(&a,2,t4,t6);
if(C_truep(t7)){
t8=((C_word*)t0)[6];{
C_word av2[2];
av2[0]=t8;
av2[1]=t7;
((C_proc)(void*)(*((C_word*)t8+1)))(2,av2);}}
else{
/* library.scm:2572: scan-ureal */
t8=((C_word*)t0)[7];
f_16202(t8,((C_word*)t0)[6],((C_word*)t0)[4],C_eqp(((C_word*)t0)[3],lf[616]));}}
else{
t6=C_a_i_cons(&a,2,t4,C_SCHEME_FALSE);
if(C_truep(t6)){
t7=((C_word*)t0)[6];{
C_word av2[2];
av2[0]=t7;
av2[1]=t6;
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}
else{
/* library.scm:2572: scan-ureal */
t7=((C_word*)t0)[7];
f_16202(t7,((C_word*)t0)[6],((C_word*)t0)[4],C_eqp(((C_word*)t0)[3],lf[616]));}}}
else{
/* library.scm:2572: scan-ureal */
t2=((C_word*)t0)[7];
f_16202(t2,((C_word*)t0)[6],((C_word*)t0)[4],C_eqp(((C_word*)t0)[3],lf[616]));}}

/* k16660 in k16561 in scan-real in ##sys#string->compnum in k8543 */
static void C_ccall f_16662(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_16662,c,av);}
t2=((C_word*)t0)[2];
f_16621(t2,C_i_string_ci_equal_p(t1,lf[618]));}

/* k16738 in k16561 in scan-real in ##sys#string->compnum in k8543 */
static void C_ccall f_16740(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(7,c,3)))){
C_save_and_reclaim((void *)f_16740,c,av);}
a=C_alloc(7);
if(C_truep(C_i_string_ci_equal_p(t1,lf[619]))){
t2=(
/* library.scm:2577: go-inexact! */
  f_15622(((C_word*)((C_word*)t0)[2])[1],C_eqp(((C_word*)t0)[3],lf[616]))
);
t3=C_flonum(&a,C_ub_i_flonum_quotient((double)0.0,(double)0.0));
t4=C_fixnum_plus(((C_word*)t0)[4],C_fix(5));
if(C_truep(C_fixnum_lessp(t4,((C_word*)t0)[5]))){
t5=C_fixnum_plus(((C_word*)t0)[4],C_fix(5));
t6=C_a_i_cons(&a,2,t3,t5);
if(C_truep(t6)){
t7=((C_word*)t0)[6];{
C_word *av2=av;
av2[0]=t7;
av2[1]=t6;
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}
else{
/* library.scm:2581: scan-ureal */
t7=((C_word*)t0)[7];
f_16202(t7,((C_word*)t0)[6],((C_word*)t0)[4],C_eqp(((C_word*)t0)[3],lf[616]));}}
else{
t5=C_a_i_cons(&a,2,t3,C_SCHEME_FALSE);
if(C_truep(t5)){
t6=((C_word*)t0)[6];{
C_word *av2=av;
av2[0]=t6;
av2[1]=t5;
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}
else{
/* library.scm:2581: scan-ureal */
t6=((C_word*)t0)[7];
f_16202(t6,((C_word*)t0)[6],((C_word*)t0)[4],C_eqp(((C_word*)t0)[3],lf[616]));}}}
else{
/* library.scm:2581: scan-ureal */
t2=((C_word*)t0)[7];
f_16202(t2,((C_word*)t0)[6],((C_word*)t0)[4],C_eqp(((C_word*)t0)[3],lf[616]));}}

/* k16786 in ##sys#string->compnum in k8543 */
static void C_ccall f_16788(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(11,c,3)))){
C_save_and_reclaim((void *)f_16788,c,av);}
a=C_alloc(11);
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_16791,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
if(C_truep(t1)){
t3=C_i_cdr(t1);
t4=(C_truep(t3)?C_subchar(((C_word*)t0)[5],C_u_i_cdr(t1)):C_SCHEME_FALSE);
t5=C_eqp(t4,C_SCHEME_FALSE);
if(C_truep(t5)){
t6=t2;{
C_word *av2=av;
av2[0]=t6;
av2[1]=C_u_i_car(t1);
f_16791(2,av2);}}
else{
t6=C_eqp(t4,C_make_character(105));
t7=(C_truep(t6)?t6:C_eqp(t4,C_make_character(73)));
if(C_truep(t7)){
t8=C_fixnum_plus(C_u_i_cdr(t1),C_fix(1));
t9=C_eqp(((C_word*)t0)[6],t8);
if(C_truep(t9)){
t10=C_eqp(C_subchar(((C_word*)t0)[5],((C_word*)t0)[7]),C_make_character(43));
if(C_truep(t10)){
if(C_truep(t10)){
/* library.scm:2589: scheme#make-rectangular */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[504]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[504]+1);
av2[1]=t2;
av2[2]=C_fix(0);
av2[3]=C_u_i_car(t1);
tp(4,av2);}}
else{
t11=t2;{
C_word *av2=av;
av2[0]=t11;
av2[1]=C_SCHEME_FALSE;
f_16791(2,av2);}}}
else{
t11=C_eqp(C_subchar(((C_word*)t0)[5],((C_word*)t0)[7]),C_make_character(45));
if(C_truep(t11)){
/* library.scm:2589: scheme#make-rectangular */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[504]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[504]+1);
av2[1]=t2;
av2[2]=C_fix(0);
av2[3]=C_u_i_car(t1);
tp(4,av2);}}
else{
t12=t2;{
C_word *av2=av;
av2[0]=t12;
av2[1]=C_SCHEME_FALSE;
f_16791(2,av2);}}}}
else{
t10=t2;{
C_word *av2=av;
av2[0]=t10;
av2[1]=C_SCHEME_FALSE;
f_16791(2,av2);}}}
else{
t8=C_eqp(t4,C_make_character(43));
t9=(C_truep(t8)?t8:C_eqp(t4,C_make_character(45)));
if(C_truep(t9)){
t10=C_set_block_item(((C_word*)t0)[8],0,C_SCHEME_FALSE);
t11=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_16890,a[2]=((C_word*)t0)[6],a[3]=((C_word*)t0)[5],a[4]=t2,a[5]=t1,tmp=(C_word)a,a+=6,tmp);
/* library.scm:2592: scan-real */
t12=((C_word*)t0)[9];
f_16548(t12,t11,C_u_i_cdr(t1));}
else{
t10=C_eqp(t4,C_make_character(64));
if(C_truep(t10)){
t11=C_set_block_item(((C_word*)t0)[8],0,C_SCHEME_FALSE);
t12=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_16958,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* library.scm:2600: scan-real */
t13=((C_word*)t0)[9];
f_16548(t13,t12,C_fixnum_plus(C_u_i_cdr(t1),C_fix(1)));}
else{
t11=t2;{
C_word *av2=av;
av2[0]=t11;
av2[1]=C_SCHEME_FALSE;
f_16791(2,av2);}}}}}}
else{
t3=t2;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_SCHEME_FALSE;
f_16791(2,av2);}}}

/* k16789 in k16786 in ##sys#string->compnum in k8543 */
static void C_ccall f_16791(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,2)))){
C_save_and_reclaim((void *)f_16791,c,av);}
a=C_alloc(4);
if(C_truep(t1)){
t2=C_eqp(((C_word*)((C_word*)t0)[2])[1],lf[613]);
if(C_truep(t2)){
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_16803,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
/* library.scm:2605: scheme#exact->inexact */
t4=*((C_word*)lf[62]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t4;
av2[1]=t3;
av2[2]=t1;
((C_proc)(void*)(*((C_word*)t4+1)))(3,av2);}}
else{
t3=((C_word*)t0)[4];{
C_word *av2=av;
av2[0]=t3;
av2[1]=(C_truep(C_i_finitep(t1))?t1:C_SCHEME_FALSE);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}}
else{
t2=((C_word*)t0)[4];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}}

/* k16801 in k16789 in k16786 in ##sys#string->compnum in k8543 */
static void C_ccall f_16803(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_16803,c,av);}
if(C_truep(((C_word*)((C_word*)t0)[2])[1])){
if(C_truep(C_u_i_zerop2(t1))){
/* library.scm:2608: chicken.flonum#fpneg */
t2=*((C_word*)lf[456]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[3];
av2[2]=t1;
((C_proc)(void*)(*((C_word*)t2+1)))(3,av2);}}
else{
t2=((C_word*)t0)[3];{
C_word *av2=av;
av2[0]=t2;
av2[1]=t1;
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}}
else{
t2=((C_word*)t0)[3];{
C_word *av2=av;
av2[0]=t2;
av2[1]=t1;
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}}

/* k16888 in k16786 in ##sys#string->compnum in k8543 */
static void C_ccall f_16890(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_16890,c,av);}
if(C_truep(t1)){
if(C_truep(C_i_cdr(t1))){
t2=C_fixnum_plus(C_u_i_cdr(t1),C_fix(1));
t3=C_eqp(((C_word*)t0)[2],t2);
if(C_truep(t3)){
t4=C_u_i_cdr(t1);
t5=C_eqp(C_subchar(((C_word*)t0)[3],t4),C_make_character(105));
if(C_truep(t5)){
if(C_truep(t5)){
/* library.scm:2597: scheme#make-rectangular */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[504]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[504]+1);
av2[1]=((C_word*)t0)[4];
av2[2]=C_u_i_car(((C_word*)t0)[5]);
av2[3]=C_u_i_car(t1);
tp(4,av2);}}
else{
t6=((C_word*)t0)[4];{
C_word *av2=av;
av2[0]=t6;
av2[1]=C_SCHEME_FALSE;
f_16791(2,av2);}}}
else{
t6=C_u_i_cdr(t1);
t7=C_eqp(C_subchar(((C_word*)t0)[3],t6),C_make_character(73));
if(C_truep(t7)){
/* library.scm:2597: scheme#make-rectangular */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[504]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[504]+1);
av2[1]=((C_word*)t0)[4];
av2[2]=C_u_i_car(((C_word*)t0)[5]);
av2[3]=C_u_i_car(t1);
tp(4,av2);}}
else{
t8=((C_word*)t0)[4];{
C_word *av2=av;
av2[0]=t8;
av2[1]=C_SCHEME_FALSE;
f_16791(2,av2);}}}}
else{
t4=((C_word*)t0)[4];{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_SCHEME_FALSE;
f_16791(2,av2);}}}
else{
t2=((C_word*)t0)[4];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_SCHEME_FALSE;
f_16791(2,av2);}}}
else{
t2=((C_word*)t0)[4];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_SCHEME_FALSE;
f_16791(2,av2);}}}

/* k16956 in k16786 in ##sys#string->compnum in k8543 */
static void C_ccall f_16958(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_16958,c,av);}
if(C_truep(t1)){
t2=C_i_cdr(t1);
if(C_truep(C_i_not(t2))){
/* library.scm:2602: scheme#make-polar */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[506]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[506]+1);
av2[1]=((C_word*)t0)[2];
av2[2]=C_u_i_car(((C_word*)t0)[3]);
av2[3]=C_u_i_car(t1);
tp(4,av2);}}
else{
t3=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_SCHEME_FALSE;
f_16791(2,av2);}}}
else{
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_SCHEME_FALSE;
f_16791(2,av2);}}}

/* scheme#string->number in k8543 */
static void C_ccall f_17038(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(5,c,3)))){
C_save_and_reclaim((void *)f_17038,c,av);}
a=C_alloc(5);
t3=C_rest_nullp(c,3);
t4=(C_truep(t3)?C_fix(10):C_get_rest_arg(c,3,av,3,t0));
t5=C_i_check_string_2(t2,lf[621]);
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_17048,a[2]=t2,a[3]=t4,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
if(C_truep(C_fixnump(t4))){
if(C_truep(C_fixnum_lessp(C_fix(1),t4))){
if(C_truep(C_fixnum_lessp(t4,C_fix(37)))){
t7=t6;{
C_word *av2=av;
av2[0]=t7;
av2[1]=C_SCHEME_UNDEFINED;
f_17048(2,av2);}}
else{
/* library.scm:2617: ##sys#error-bad-base */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[375]+1));
C_word av2[4];
av2[0]=*((C_word*)lf[375]+1);
av2[1]=t6;
av2[2]=t4;
av2[3]=lf[621];
tp(4,av2);}}}
else{
/* library.scm:2617: ##sys#error-bad-base */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[375]+1));
C_word av2[4];
av2[0]=*((C_word*)lf[375]+1);
av2[1]=t6;
av2[2]=t4;
av2[3]=lf[621];
tp(4,av2);}}}
else{
/* library.scm:2617: ##sys#error-bad-base */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[375]+1));
C_word av2[4];
av2[0]=*((C_word*)lf[375]+1);
av2[1]=t6;
av2[2]=t4;
av2[3]=lf[621];
tp(4,av2);}}}

/* k17046 in scheme#string->number in k8543 */
static void C_ccall f_17048(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(8,c,6)))){
C_save_and_reclaim((void *)f_17048,c,av);}
a=C_alloc(8);
t2=C_block_size(((C_word*)t0)[2]);
t3=C_SCHEME_UNDEFINED;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_set_block_item(t4,0,(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_17057,a[2]=((C_word*)t0)[2],a[3]=t4,a[4]=((C_word*)t0)[3],a[5]=((C_word)li457),tmp=(C_word)a,a+=6,tmp));
t6=((C_word*)t4)[1];
f_17057(t6,((C_word*)t0)[4],C_fix(0),C_SCHEME_FALSE,C_SCHEME_FALSE,t2);}

/* scan-prefix in k17046 in scheme#string->number in k8543 */
static void C_fcall f_17057(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5){
C_word tmp;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word t19;
C_word t20;
C_word t21;
C_word t22;
C_word t23;
C_word t24;
C_word t25;
C_word t26;
C_word t27;
C_word t28;
C_word *a;
loop:
if(C_unlikely(!C_demand(C_calculate_demand(0,0,5)))){
C_save_and_reclaim_args((void *)trf_17057,6,t0,t1,t2,t3,t4,t5);}
t6=C_fixnum_plus(t2,C_fix(2));
t7=C_fixnum_lessp(t6,t5);
t8=(C_truep(t7)?C_eqp(C_subchar(((C_word*)t0)[2],t2),C_make_character(35)):C_SCHEME_FALSE);
if(C_truep(t8)){
t9=C_fixnum_plus(t2,C_fix(1));
t10=C_subchar(((C_word*)t0)[2],t9);
t11=C_eqp(t10,C_make_character(105));
t12=(C_truep(t11)?t11:C_eqp(t10,C_make_character(73)));
if(C_truep(t12)){
if(C_truep(C_i_not(t3))){
/* library.scm:2624: scan-prefix */
t24=t1;
t25=C_fixnum_plus(t2,C_fix(2));
t26=lf[613];
t27=t4;
t28=t5;
t1=t24;
t2=t25;
t3=t26;
t4=t27;
t5=t28;
goto loop;}
else{
t13=t1;{
C_word av2[2];
av2[0]=t13;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t13+1)))(2,av2);}}}
else{
t13=C_eqp(t10,C_make_character(101));
t14=(C_truep(t13)?t13:C_eqp(t10,C_make_character(69)));
if(C_truep(t14)){
if(C_truep(C_i_not(t3))){
/* library.scm:2625: scan-prefix */
t24=t1;
t25=C_fixnum_plus(t2,C_fix(2));
t26=lf[612];
t27=t4;
t28=t5;
t1=t24;
t2=t25;
t3=t26;
t4=t27;
t5=t28;
goto loop;}
else{
t15=t1;{
C_word av2[2];
av2[0]=t15;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t15+1)))(2,av2);}}}
else{
t15=C_eqp(t10,C_make_character(98));
t16=(C_truep(t15)?t15:C_eqp(t10,C_make_character(66)));
if(C_truep(t16)){
if(C_truep(C_i_not(t4))){
/* library.scm:2626: scan-prefix */
t24=t1;
t25=C_fixnum_plus(t2,C_fix(2));
t26=t3;
t27=C_fix(2);
t28=t5;
t1=t24;
t2=t25;
t3=t26;
t4=t27;
t5=t28;
goto loop;}
else{
t17=t1;{
C_word av2[2];
av2[0]=t17;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t17+1)))(2,av2);}}}
else{
t17=C_eqp(t10,C_make_character(111));
t18=(C_truep(t17)?t17:C_eqp(t10,C_make_character(79)));
if(C_truep(t18)){
if(C_truep(C_i_not(t4))){
/* library.scm:2627: scan-prefix */
t24=t1;
t25=C_fixnum_plus(t2,C_fix(2));
t26=t3;
t27=C_fix(8);
t28=t5;
t1=t24;
t2=t25;
t3=t26;
t4=t27;
t5=t28;
goto loop;}
else{
t19=t1;{
C_word av2[2];
av2[0]=t19;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t19+1)))(2,av2);}}}
else{
t19=C_eqp(t10,C_make_character(100));
t20=(C_truep(t19)?t19:C_eqp(t10,C_make_character(68)));
if(C_truep(t20)){
if(C_truep(C_i_not(t4))){
/* library.scm:2628: scan-prefix */
t24=t1;
t25=C_fixnum_plus(t2,C_fix(2));
t26=t3;
t27=C_fix(10);
t28=t5;
t1=t24;
t2=t25;
t3=t26;
t4=t27;
t5=t28;
goto loop;}
else{
t21=t1;{
C_word av2[2];
av2[0]=t21;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t21+1)))(2,av2);}}}
else{
t21=C_eqp(t10,C_make_character(120));
t22=(C_truep(t21)?t21:C_eqp(t10,C_make_character(88)));
if(C_truep(t22)){
if(C_truep(C_i_not(t4))){
/* library.scm:2629: scan-prefix */
t24=t1;
t25=C_fixnum_plus(t2,C_fix(2));
t26=t3;
t27=C_fix(16);
t28=t5;
t1=t24;
t2=t25;
t3=t26;
t4=t27;
t5=t28;
goto loop;}
else{
t23=t1;{
C_word av2[2];
av2[0]=t23;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t23+1)))(2,av2);}}}
else{
t23=t1;{
C_word av2[2];
av2[0]=t23;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t23+1)))(2,av2);}}}}}}}}
else{
if(C_truep(t4)){
/* library.scm:2631: ##sys#string->compnum */
f_15618(t1,t4,((C_word*)t0)[2],t2,t3);}
else{
/* library.scm:2631: ##sys#string->compnum */
f_15618(t1,((C_word*)t0)[4],((C_word*)t0)[2],t2,t3);}}}

/* ##sys#string->number in k8543 */
static void C_ccall f_17293(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,5)))){
C_save_and_reclaim((void *)f_17293,c,av);}
t3=C_rest_nullp(c,3);
t4=(C_truep(t3)?C_fix(10):C_get_rest_arg(c,3,av,3,t0));
t5=C_rest_nullp(c,3);
t6=C_rest_nullp(c,4);
t7=(C_truep(t6)?C_SCHEME_FALSE:C_get_rest_arg(c,4,av,3,t0));
if(C_truep(C_rest_nullp(c,4))){
/* library.scm:2634: ##sys#string->compnum */
f_15618(t1,t4,t2,C_fix(0),t7);}
else{
/* library.scm:2634: ##sys#string->compnum */
f_15618(t1,t4,t2,C_fix(0),t7);}}

/* chicken.base#equal=? in k8543 */
static void C_ccall f_17339(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(12,c,5)))){
C_save_and_reclaim((void *)f_17339,c,av);}
a=C_alloc(12);
t4=C_SCHEME_UNDEFINED;
t5=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t6=C_SCHEME_UNDEFINED;
t7=(*a=C_VECTOR_TYPE|1,a[1]=t6,tmp=(C_word)a,a+=2,tmp);
t8=C_set_block_item(t5,0,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_17342,a[2]=t7,a[3]=((C_word)li464),tmp=(C_word)a,a+=4,tmp));
t9=C_set_block_item(t7,0,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_17410,a[2]=t5,a[3]=((C_word)li465),tmp=(C_word)a,a+=4,tmp));
/* library.scm:2677: walk */
t10=((C_word*)t7)[1];
f_17410(t10,t1,t2,t3);}

/* compare-slots in chicken.base#equal=? in k8543 */
static void C_fcall f_17342(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(10,0,3)))){
C_save_and_reclaim_args((void *)trf_17342,5,t0,t1,t2,t3,t4);}
a=C_alloc(10);
t5=C_block_size(t2);
t6=C_block_size(t3);
t7=C_eqp(t5,t6);
if(C_truep(t7)){
t8=C_fixnum_less_or_equal_p(t5,t4);
if(C_truep(t8)){
t9=t1;{
C_word av2[2];
av2[0]=t9;
av2[1]=t8;
((C_proc)(void*)(*((C_word*)t9+1)))(2,av2);}}
else{
t9=C_fixnum_difference(t5,C_fix(1));
t10=C_SCHEME_UNDEFINED;
t11=(*a=C_VECTOR_TYPE|1,a[1]=t10,tmp=(C_word)a,a+=2,tmp);
t12=C_set_block_item(t11,0,(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_17369,a[2]=t9,a[3]=((C_word*)t0)[2],a[4]=t2,a[5]=t3,a[6]=t11,a[7]=((C_word)li463),tmp=(C_word)a,a+=8,tmp));
t13=((C_word*)t11)[1];
f_17369(t13,t1,t4);}}
else{
t8=t1;{
C_word av2[2];
av2[0]=t8;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t8+1)))(2,av2);}}}

/* loop in compare-slots in chicken.base#equal=? in k8543 */
static void C_fcall f_17369(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,0,3)))){
C_save_and_reclaim_args((void *)trf_17369,3,t0,t1,t2);}
a=C_alloc(5);
t3=C_eqp(t2,((C_word*)t0)[2]);
if(C_truep(t3)){
/* library.scm:2651: walk */
t4=((C_word*)((C_word*)t0)[3])[1];
f_17410(t4,t1,C_slot(((C_word*)t0)[4],t2),C_slot(((C_word*)t0)[5],t2));}
else{
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_17393,a[2]=((C_word*)t0)[6],a[3]=t1,a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* library.scm:2652: walk */
t5=((C_word*)((C_word*)t0)[3])[1];
f_17410(t5,t4,C_slot(((C_word*)t0)[4],t2),C_slot(((C_word*)t0)[5],t2));}}

/* k17391 in loop in compare-slots in chicken.base#equal=? in k8543 */
static void C_ccall f_17393(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_17393,c,av);}
if(C_truep(t1)){
/* library.scm:2653: loop */
t2=((C_word*)((C_word*)t0)[2])[1];
f_17369(t2,((C_word*)t0)[3],C_fixnum_plus(((C_word*)t0)[4],C_fix(1)));}
else{
t2=((C_word*)t0)[3];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}}

/* walk in chicken.base#equal=? in k8543 */
static void C_fcall f_17410(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,0,4)))){
C_save_and_reclaim_args((void *)trf_17410,4,t0,t1,t2,t3);}
t4=C_eqp(t2,t3);
if(C_truep(t4)){
t5=t1;{
C_word av2[2];
av2[0]=t5;
av2[1]=t4;
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}
else{
if(C_truep(C_i_numberp(t2))){
t5=C_i_numberp(t3);
t6=t1;{
C_word av2[2];
av2[0]=t6;
av2[1]=(C_truep(t5)?C_i_nequalp(t2,t3):C_eqp(t2,t3));
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}
else{
if(C_truep(C_i_not(C_blockp(t2)))){
t5=t1;{
C_word av2[2];
av2[0]=t5;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}
else{
if(C_truep(C_i_not(C_blockp(t3)))){
t5=t1;{
C_word av2[2];
av2[0]=t5;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}
else{
if(C_truep(C_i_not(C_sametypep(t2,t3)))){
t5=t1;{
C_word av2[2];
av2[0]=t5;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}
else{
if(C_truep(C_specialp(t2))){
if(C_truep(C_specialp(t3))){
if(C_truep(C_closurep(t2))){
t5=t1;{
C_word av2[2];
av2[0]=t5;
av2[1]=shallow_equal(t2,t3);
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}
else{
/* library.scm:2667: compare-slots */
t5=((C_word*)((C_word*)t0)[2])[1];
f_17342(t5,t1,t2,t3,C_fix(1));}}
else{
t5=t1;{
C_word av2[2];
av2[0]=t5;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}}
else{
if(C_truep(C_byteblockp(t2))){
if(C_truep(C_byteblockp(t3))){
t5=C_block_size(t2);
t6=C_block_size(t3);
t7=C_eqp(t5,t6);
t8=t1;{
C_word av2[2];
av2[0]=t8;
av2[1]=(C_truep(t7)?C_substring_compare(t2,t3,C_fix(0),C_fix(0),t5):C_SCHEME_FALSE);
((C_proc)(void*)(*((C_word*)t8+1)))(2,av2);}}
else{
t5=t1;{
C_word av2[2];
av2[0]=t5;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}}
else{
t5=C_block_size(t2);
t6=C_block_size(t3);
t7=C_eqp(t5,t6);
if(C_truep(t7)){
/* library.scm:2676: compare-slots */
t8=((C_word*)((C_word*)t0)[2])[1];
f_17342(t8,t1,t2,t3,C_fix(0));}
else{
t8=t1;{
C_word av2[2];
av2[0]=t8;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t8+1)))(2,av2);}}}}}}}}}}

/* ##sys#interned-symbol? in k8543 */
static void C_ccall f_17511(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_17511,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_lookup_symbol(t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* ##sys#string->symbol in k8543 */
static void C_ccall f_17514(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_17514,c,av);}
t3=C_i_check_string(t2);
/* library.scm:2689: ##sys#intern-symbol */{
C_word *av2=av;
av2[0]=0;
av2[1]=t1;
av2[2]=t2;
C_string_to_symbol(3,av2);}}

/* ##sys#symbol->string in k8543 */
static void C_ccall f_17523(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_17523,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_slot(t2,C_fix(1));
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* scheme#symbol->string in k8543 */
static void C_ccall f_17529(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(3,c,2)))){
C_save_and_reclaim((void *)f_17529,c,av);}
a=C_alloc(3);
t3=C_i_check_symbol_2(t2,lf[635]);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_17540,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* library.scm:2697: ##sys#symbol->string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[633]+1));
C_word *av2=av;
av2[0]=*((C_word*)lf[633]+1);
av2[1]=t4;
av2[2]=t2;
tp(3,av2);}}

/* k17538 in scheme#symbol->string in k8543 */
static void C_ccall f_17540(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_17540,c,av);}
/* library.scm:2697: scheme#string-copy */
t2=*((C_word*)lf[394]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=t1;
((C_proc)(void*)(*((C_word*)t2+1)))(3,av2);}}

/* scheme#string->symbol in k8543 */
static void C_ccall f_17542(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(3,c,2)))){
C_save_and_reclaim((void *)f_17542,c,av);}
a=C_alloc(3);
t3=C_i_check_string_2(t2,lf[637]);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_17553,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* library.scm:2703: string-copy */
t5=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t5;
av2[1]=t4;
av2[2]=t2;
((C_proc)(void*)(*((C_word*)t5+1)))(3,av2);}}

/* k17551 in scheme#string->symbol in k8543 */
static void C_ccall f_17553(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_17553,c,av);}
/* library.scm:2703: ##sys#intern-symbol */{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=0;
av2[1]=((C_word*)t0)[2];
av2[2]=t1;
C_string_to_symbol(3,av2);}}

/* chicken.base#string->uninterned-symbol in k8543 */
static void C_ccall f_17555(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(7,c,2)))){
C_save_and_reclaim((void *)f_17555,c,av);}
a=C_alloc(7);
t3=C_i_check_string_2(t2,lf[639]);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)C_make_symbol,a[2]=((C_word)li474),tmp=(C_word)a,a+=3,tmp);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_17566,a[2]=t4,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* library.scm:2709: string-copy */
t6=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t6;
av2[1]=t5;
av2[2]=t2;
((C_proc)(void*)(*((C_word*)t6+1)))(3,av2);}}

/* k17564 in chicken.base#string->uninterned-symbol in k8543 */
static void C_ccall f_17566(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_17566,c,av);}
/* library.scm:2707: g3360 */
t2=((C_word*)t0)[2];{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[3];
av2[2]=t1;
((C_proc)C_fast_retrieve_proc(t2))(3,av2);}}

/* chicken.base#gensym in k8543 */
static void C_ccall f_17568(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand((c-2)*C_SIZEOF_PAIR +17,c,5)))){
C_save_and_reclaim((void*)f_17568,c,av);}
a=C_alloc((c-2)*C_SIZEOF_PAIR+17);
t2=C_build_rest(&a,c,2,av);
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
t3=C_fixnum_plus(((C_word*)((C_word*)t0)[2])[1],C_fix(1));
t4=C_set_block_item(((C_word*)t0)[2],0,t3);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)C_make_symbol,a[2]=((C_word)li476),tmp=(C_word)a,a+=3,tmp);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_17585,a[2]=t5,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t7=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_17589,a[2]=t6,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
t8=C_eqp(t2,C_SCHEME_END_OF_LIST);
if(C_truep(t8)){
t9=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f34949,a[2]=t6,tmp=(C_word)a,a+=3,tmp);
/* library.scm:2726: ##sys#number->string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[603]+1));
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=*((C_word*)lf[603]+1);
av2[1]=t9;
av2[2]=((C_word*)((C_word*)t0)[2])[1];
tp(3,av2);}}
else{
t9=C_get_rest_arg(c,2,av,2,t0);
t10=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_17602,a[2]=t6,a[3]=((C_word*)t0)[2],a[4]=t7,a[5]=t9,tmp=(C_word)a,a+=6,tmp);
if(C_truep(C_blockp(t9))){
if(C_truep(C_stringp(t9))){
t11=t10;{
C_word *av2=av;
av2[0]=t11;
av2[1]=t9;
f_17602(2,av2);}}
else{
if(C_truep(C_symbolp(t9))){
/* library.scm:2723: ##sys#symbol->string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[633]+1));
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=*((C_word*)lf[633]+1);
av2[1]=t10;
av2[2]=t9;
tp(3,av2);}}
else{
/* library.scm:2714: ##sys#signal-hook */
t11=C_fast_retrieve(lf[194]);{
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=t11;
av2[1]=t10;
av2[2]=lf[260];
av2[3]=lf[642];
av2[4]=lf[643];
av2[5]=t9;
((C_proc)(void*)(*((C_word*)t11+1)))(6,av2);}}}}
else{
t11=t10;{
C_word *av2=av;
av2[0]=t11;
av2[1]=C_SCHEME_FALSE;
f_17602(2,av2);}}}}

/* k17583 in chicken.base#gensym in k8543 */
static void C_ccall f_17585(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_17585,c,av);}
/* library.scm:2714: g3367 */
t2=((C_word*)t0)[2];{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[3];
av2[2]=t1;
((C_proc)C_fast_retrieve_proc(t2))(3,av2);}}

/* k17587 in chicken.base#gensym in k8543 */
static void C_ccall f_17589(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,2)))){
C_save_and_reclaim((void *)f_17589,c,av);}
a=C_alloc(4);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_17593,a[2]=((C_word*)t0)[2],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* library.scm:2726: ##sys#number->string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[603]+1));
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=*((C_word*)lf[603]+1);
av2[1]=t2;
av2[2]=((C_word*)((C_word*)t0)[3])[1];
tp(3,av2);}}

/* k17591 in k17587 in chicken.base#gensym in k8543 */
static void C_ccall f_17593(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_17593,c,av);}
/* library.scm:2717: ##sys#string-append */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[415]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[415]+1);
av2[1]=((C_word*)t0)[2];
av2[2]=((C_word*)t0)[3];
av2[3]=t1;
tp(4,av2);}}

/* k17600 in chicken.base#gensym in k8543 */
static void C_ccall f_17602(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,5)))){
C_save_and_reclaim((void *)f_17602,c,av);}
a=C_alloc(4);
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f34953,a[2]=((C_word*)t0)[2],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* library.scm:2726: ##sys#number->string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[603]+1));
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=*((C_word*)lf[603]+1);
av2[1]=t2;
av2[2]=((C_word*)((C_word*)t0)[3])[1];
tp(3,av2);}}
else{
/* library.scm:2714: ##sys#signal-hook */
t2=C_fast_retrieve(lf[194]);{
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[4];
av2[2]=lf[260];
av2[3]=lf[642];
av2[4]=lf[643];
av2[5]=((C_word*)t0)[5];
((C_proc)(void*)(*((C_word*)t2+1)))(6,av2);}}}

/* chicken.base#symbol-append in k8543 */
static void C_ccall f_17622(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand((c-2)*C_SIZEOF_PAIR +20,c,3)))){
C_save_and_reclaim((void*)f_17622,c,av);}
a=C_alloc((c-2)*C_SIZEOF_PAIR+20);
t2=C_build_rest(&a,c,2,av);
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_17630,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
t4=C_a_i_cons(&a,2,C_SCHEME_UNDEFINED,C_SCHEME_END_OF_LIST);
t5=t4;
t6=(*a=C_VECTOR_TYPE|1,a[1]=t5,tmp=(C_word)a,a+=2,tmp);
t7=((C_word*)t6)[1];
t8=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_17645,a[2]=t3,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
t9=C_SCHEME_UNDEFINED;
t10=(*a=C_VECTOR_TYPE|1,a[1]=t9,tmp=(C_word)a,a+=2,tmp);
t11=C_set_block_item(t10,0,(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_17647,a[2]=t6,a[3]=t10,a[4]=t7,a[5]=((C_word)li478),tmp=(C_word)a,a+=6,tmp));
t12=((C_word*)t10)[1];
f_17647(t12,t8,t2);}

/* k17628 in chicken.base#symbol-append in k8543 */
static void C_ccall f_17630(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_17630,c,av);}
/* library.scm:2731: ##sys#intern-symbol */{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=0;
av2[1]=((C_word*)t0)[2];
av2[2]=t1;
C_string_to_symbol(3,av2);}}

/* k17643 in chicken.base#symbol-append in k8543 */
static void C_ccall f_17645(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_17645,c,av);}{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=0;
av2[1]=((C_word*)t0)[2];
av2[2]=((C_word*)t0)[3];
av2[3]=t1;
C_apply(4,av2);}}

/* map-loop3383 in chicken.base#symbol-append in k8543 */
static void C_fcall f_17647(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(6,0,2)))){
C_save_and_reclaim_args((void *)trf_17647,3,t0,t1,t2);}
a=C_alloc(6);
if(C_truep(C_i_pairp(t2))){
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_17672,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t1,a[5]=t2,tmp=(C_word)a,a+=6,tmp);
t4=C_slot(t2,C_fix(0));
t5=C_i_check_symbol_2(t4,lf[645]);
/* library.scm:2736: ##sys#symbol->string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[633]+1));
C_word av2[3];
av2[0]=*((C_word*)lf[633]+1);
av2[1]=t3;
av2[2]=t4;
tp(3,av2);}}
else{
t3=t1;{
C_word av2[2];
av2[0]=t3;
av2[1]=C_slot(((C_word*)t0)[4],C_fix(1));
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}}

/* k17670 in map-loop3383 in chicken.base#symbol-append in k8543 */
static void C_ccall f_17672(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,c,2)))){
C_save_and_reclaim((void *)f_17672,c,av);}
a=C_alloc(3);
t2=C_a_i_cons(&a,2,t1,C_SCHEME_END_OF_LIST);
t3=C_i_setslot(((C_word*)((C_word*)t0)[2])[1],C_fix(1),t2);
t4=C_mutate(((C_word *)((C_word*)t0)[2])+1,t2);
t5=((C_word*)((C_word*)t0)[3])[1];
f_17647(t5,((C_word*)t0)[4],C_slot(((C_word*)t0)[5],C_fix(1)));}

/* chicken.keyword#keyword? in k8543 */
static void C_ccall f_17681(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_17681,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_i_keywordp(t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* chicken.keyword#string->keyword in k8543 */
static void C_ccall f_17684(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_17684,c,av);}
t3=C_i_check_string_2(t2,lf[649]);
/* library.scm:2753: ##sys#intern-keyword */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[630]+1));
C_word *av2=av;
av2[0]=*((C_word*)lf[630]+1);
av2[1]=t1;
av2[2]=t2;
tp(3,av2);}}

/* chicken.keyword#keyword->string in k8543 */
static void C_ccall f_17693(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(4,c,2)))){
C_save_and_reclaim((void *)f_17693,c,av);}
a=C_alloc(4);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_17700,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* library.scm:2758: keyword? */
t4=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t4;
av2[1]=t3;
av2[2]=t2;
((C_proc)(void*)(*((C_word*)t4+1)))(3,av2);}}

/* k17698 in chicken.keyword#keyword->string in k8543 */
static void C_ccall f_17700(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,5)))){
C_save_and_reclaim((void *)f_17700,c,av);}
if(C_truep(t1)){
/* library.scm:2759: ##sys#symbol->string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[633]+1));
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=*((C_word*)lf[633]+1);
av2[1]=((C_word*)t0)[2];
av2[2]=((C_word*)t0)[3];
tp(3,av2);}}
else{
/* library.scm:2760: ##sys#signal-hook */
t2=C_fast_retrieve(lf[194]);{
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=lf[260];
av2[3]=lf[651];
av2[4]=lf[652];
av2[5]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t2+1)))(6,av2);}}}

/* chicken.keyword#get-keyword in k8543 */
static void C_ccall f_17711(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(c<4) C_bad_min_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(7,c,3)))){
C_save_and_reclaim((void *)f_17711,c,av);}
a=C_alloc(7);
t4=C_rest_nullp(c,4);
t5=(C_truep(t4)?C_SCHEME_FALSE:C_get_rest_arg(c,4,av,4,t0));
t6=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_17718,a[2]=t3,a[3]=t2,a[4]=((C_word*)t0)[2],a[5]=t5,a[6]=t1,tmp=(C_word)a,a+=7,tmp);
/* library.scm:2765: ##sys#check-keyword */
t7=*((C_word*)lf[352]+1);{
C_word *av2=av;
av2[0]=t7;
av2[1]=t6;
av2[2]=t2;
av2[3]=lf[655];
((C_proc)(void*)(*((C_word*)t7+1)))(4,av2);}}

/* k17716 in chicken.keyword#get-keyword in k8543 */
static void C_ccall f_17718(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_17718,c,av);}
t2=C_i_check_list_2(((C_word*)t0)[2],lf[655]);
t3=C_i_get_keyword(((C_word*)t0)[3],((C_word*)t0)[2],((C_word*)t0)[4]);
t4=C_eqp(t3,((C_word*)t0)[4]);
if(C_truep(t4)){
if(C_truep(((C_word*)t0)[5])){
/* library.scm:2769: thunk */
t5=((C_word*)t0)[5];{
C_word *av2=av;
av2[0]=t5;
av2[1]=((C_word*)t0)[6];
((C_proc)C_fast_retrieve_proc(t5))(2,av2);}}
else{
t5=((C_word*)t0)[6];{
C_word *av2=av;
av2[0]=t5;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}}
else{
t5=((C_word*)t0)[6];{
C_word *av2=av;
av2[0]=t5;
av2[1]=t3;
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}}

/* ##sys#make-blob in k8543 */
static void C_ccall f_17742(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(3,c,5)))){
C_save_and_reclaim((void *)f_17742,c,av);}
a=C_alloc(3);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_17746,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* library.scm:2785: ##sys#allocate-vector */
t4=*((C_word*)lf[318]+1);{
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=t4;
av2[1]=t3;
av2[2]=t2;
av2[3]=C_SCHEME_TRUE;
av2[4]=C_SCHEME_FALSE;
av2[5]=C_SCHEME_TRUE;
((C_proc)(void*)(*((C_word*)t4+1)))(6,av2);}}

/* k17744 in ##sys#make-blob in k8543 */
static void C_ccall f_17746(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_17746,c,av);}
t2=C_string_to_bytevector(t1);
t3=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t3;
av2[1]=t1;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* chicken.blob#make-blob in k8543 */
static void C_ccall f_17748(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(4,c,3)))){
C_save_and_reclaim((void *)f_17748,c,av);}
a=C_alloc(4);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_17752,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* library.scm:2790: ##sys#check-fixnum */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[102]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[102]+1);
av2[1]=t3;
av2[2]=t2;
av2[3]=lf[660];
tp(4,av2);}}

/* k17750 in chicken.blob#make-blob in k8543 */
static void C_ccall f_17752(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_17752,c,av);}
/* library.scm:2791: ##sys#make-blob */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[658]);
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=*((C_word*)lf[658]+1);
av2[1]=((C_word*)t0)[2];
av2[2]=((C_word*)t0)[3];
tp(3,av2);}}

/* chicken.blob#blob? in k8543 */
static void C_ccall f_17757(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_17757,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=(C_truep(C_blockp(t2))?C_bytevectorp(t2):C_SCHEME_FALSE);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* chicken.blob#blob-size in k8543 */
static void C_ccall f_17763(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(4,c,3)))){
C_save_and_reclaim((void *)f_17763,c,av);}
a=C_alloc(4);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_17767,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* library.scm:2798: ##sys#check-blob */
t4=*((C_word*)lf[343]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t4;
av2[1]=t3;
av2[2]=t2;
av2[3]=lf[663];
((C_proc)(void*)(*((C_word*)t4+1)))(4,av2);}}

/* k17765 in chicken.blob#blob-size in k8543 */
static void C_ccall f_17767(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_17767,c,av);}
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_block_size(((C_word*)t0)[3]);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.blob#string->blob in k8543 */
static void C_ccall f_17772(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(5,c,2)))){
C_save_and_reclaim((void *)f_17772,c,av);}
a=C_alloc(5);
t3=C_i_check_string_2(t2,lf[665]);
t4=C_block_size(t2);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_17782,a[2]=t2,a[3]=t4,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
/* library.scm:2804: ##sys#make-blob */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[658]);
C_word *av2=av;
av2[0]=*((C_word*)lf[658]+1);
av2[1]=t5;
av2[2]=t4;
tp(3,av2);}}

/* k17780 in chicken.blob#string->blob in k8543 */
static void C_ccall f_17782(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_17782,c,av);}
t2=C_copy_memory(t1,((C_word*)t0)[2],((C_word*)t0)[3]);
t3=((C_word*)t0)[4];{
C_word *av2=av;
av2[0]=t3;
av2[1]=t1;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* chicken.blob#blob->string in k8543 */
static void C_ccall f_17784(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(4,c,3)))){
C_save_and_reclaim((void *)f_17784,c,av);}
a=C_alloc(4);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_17788,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* library.scm:2809: ##sys#check-blob */
t4=*((C_word*)lf[343]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t4;
av2[1]=t3;
av2[2]=t2;
av2[3]=lf[667];
((C_proc)(void*)(*((C_word*)t4+1)))(4,av2);}}

/* k17786 in chicken.blob#blob->string in k8543 */
static void C_ccall f_17788(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,c,2)))){
C_save_and_reclaim((void *)f_17788,c,av);}
a=C_alloc(5);
t2=C_block_size(((C_word*)t0)[2]);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_17794,a[2]=((C_word*)t0)[2],a[3]=t2,a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
/* library.scm:2811: ##sys#make-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[379]+1));
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=*((C_word*)lf[379]+1);
av2[1]=t3;
av2[2]=t2;
tp(3,av2);}}

/* k17792 in k17786 in chicken.blob#blob->string in k8543 */
static void C_ccall f_17794(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_17794,c,av);}
t2=C_copy_memory(t1,((C_word*)t0)[2],((C_word*)t0)[3]);
t3=((C_word*)t0)[4];{
C_word *av2=av;
av2[0]=t3;
av2[1]=t1;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* chicken.blob#blob=? in k8543 */
static void C_ccall f_17796(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(5,c,3)))){
C_save_and_reclaim((void *)f_17796,c,av);}
a=C_alloc(5);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_17800,a[2]=t2,a[3]=t3,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
/* library.scm:2816: ##sys#check-blob */
t5=*((C_word*)lf[343]+1);{
C_word *av2=av;
av2[0]=t5;
av2[1]=t4;
av2[2]=t2;
av2[3]=lf[669];
((C_proc)(void*)(*((C_word*)t5+1)))(4,av2);}}

/* k17798 in chicken.blob#blob=? in k8543 */
static void C_ccall f_17800(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,c,3)))){
C_save_and_reclaim((void *)f_17800,c,av);}
a=C_alloc(5);
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_17803,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
/* library.scm:2817: ##sys#check-blob */
t3=*((C_word*)lf[343]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=((C_word*)t0)[3];
av2[3]=lf[669];
((C_proc)(void*)(*((C_word*)t3+1)))(4,av2);}}

/* k17801 in k17798 in chicken.blob#blob=? in k8543 */
static void C_ccall f_17803(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_17803,c,av);}
t2=C_block_size(((C_word*)t0)[2]);
t3=C_block_size(((C_word*)t0)[3]);
t4=C_eqp(t3,t2);
t5=((C_word*)t0)[4];{
C_word *av2=av;
av2[0]=t5;
av2[1]=(C_truep(t4)?C_i_zerop(C_string_compare(((C_word*)t0)[2],((C_word*)t0)[3],t2)):C_SCHEME_FALSE);
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}

/* scheme#make-vector in k8543 */
static void C_ccall f_17819(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +5,c,3)))){
C_save_and_reclaim((void*)f_17819,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+5);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_17823,a[2]=t3,a[3]=t1,a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* library.scm:2829: ##sys#check-fixnum */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[102]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[102]+1);
av2[1]=t4;
av2[2]=t2;
av2[3]=lf[670];
tp(4,av2);}}

/* k17821 in scheme#make-vector in k8543 */
static void C_ccall f_17823(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,c,4)))){
C_save_and_reclaim((void *)f_17823,c,av);}
a=C_alloc(5);
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_17826,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
if(C_truep(C_fixnum_lessp(((C_word*)t0)[4],C_fix(0)))){
/* library.scm:2830: ##sys#error */
t3=*((C_word*)lf[155]+1);{
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=lf[670];
av2[3]=lf[671];
av2[4]=((C_word*)t0)[4];
((C_proc)(void*)(*((C_word*)t3+1)))(5,av2);}}
else{
t3=t2;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_SCHEME_UNDEFINED;
f_17826(2,av2);}}}

/* k17824 in k17821 in scheme#make-vector in k8543 */
static void C_ccall f_17826(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,5)))){
C_save_and_reclaim((void *)f_17826,c,av);}
if(C_truep(C_i_nullp(((C_word*)t0)[2]))){
t2=C_SCHEME_UNDEFINED;
/* library.scm:2831: ##sys#allocate-vector */
t3=*((C_word*)lf[318]+1);{
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=t3;
av2[1]=((C_word*)t0)[3];
av2[2]=((C_word*)t0)[4];
av2[3]=C_SCHEME_FALSE;
av2[4]=t2;
av2[5]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t3+1)))(6,av2);}}
else{
/* library.scm:2831: ##sys#allocate-vector */
t2=*((C_word*)lf[318]+1);{
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[3];
av2[2]=((C_word*)t0)[4];
av2[3]=C_SCHEME_FALSE;
av2[4]=C_i_car(((C_word*)t0)[2]);
av2[5]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t2+1)))(6,av2);}}}

/* scheme#list->vector in k8543 */
static void C_ccall f_17848(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(4,c,3)))){
C_save_and_reclaim((void *)f_17848,c,av);}
a=C_alloc(4);
t3=C_i_listp(t2);
if(C_truep(C_i_not(t3))){
/* library.scm:2843: ##sys#error-not-a-proper-list */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[47]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[47]+1);
av2[1]=t1;
av2[2]=t2;
av2[3]=lf[673];
tp(4,av2);}}
else{
t4=C_i_length(t2);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_17864,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* library.scm:2845: ##sys#make-vector */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[672]+1));
C_word *av2=av;
av2[0]=*((C_word*)lf[672]+1);
av2[1]=t5;
av2[2]=t4;
tp(3,av2);}}}

/* k17862 in scheme#list->vector in k8543 */
static void C_ccall f_17864(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,3)))){
C_save_and_reclaim((void *)f_17864,c,av);}
a=C_alloc(4);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_17869,a[2]=t1,a[3]=((C_word)li492),tmp=(C_word)a,a+=4,tmp);
t3=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t3;
av2[1]=(
  f_17869(t2,((C_word*)t0)[3],C_fix(0))
);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* loop in k17862 in scheme#list->vector in k8543 */
static C_word C_fcall f_17869(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_stack_overflow_check;
loop:{}
if(C_truep(C_i_nullp(t1))){
return(((C_word*)t0)[2]);}
else{
t3=C_slot(t1,C_fix(0));
t4=C_i_setslot(((C_word*)t0)[2],t2,t3);
t6=C_slot(t1,C_fix(1));
t7=C_fixnum_plus(t2,C_fix(1));
t1=t6;
t2=t7;
goto loop;}}

/* scheme#vector->list in k8543 */
static void C_ccall f_17900(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(8,c,3)))){
C_save_and_reclaim((void *)f_17900,c,av);}
a=C_alloc(8);
t3=C_i_check_vector_2(t2,lf[674]);
t4=C_block_size(t2);
t5=C_SCHEME_UNDEFINED;
t6=(*a=C_VECTOR_TYPE|1,a[1]=t5,tmp=(C_word)a,a+=2,tmp);
t7=C_set_block_item(t6,0,(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_17909,a[2]=t4,a[3]=t2,a[4]=t6,a[5]=((C_word)li494),tmp=(C_word)a,a+=6,tmp));
t8=((C_word*)t6)[1];
f_17909(t8,t1,C_fix(0));}

/* loop in scheme#vector->list in k8543 */
static void C_fcall f_17909(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
loop:
if(C_unlikely(!C_demand(C_calculate_demand(4,0,2)))){
C_save_and_reclaim_args((void *)trf_17909,3,t0,t1,t2);}
a=C_alloc(4);
if(C_truep(C_fixnum_greater_or_equal_p(t2,((C_word*)t0)[2]))){
t3=t1;{
C_word av2[2];
av2[0]=t3;
av2[1]=C_SCHEME_END_OF_LIST;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
t3=C_slot(((C_word*)t0)[3],t2);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_17927,a[2]=t1,a[3]=t3,tmp=(C_word)a,a+=4,tmp);
/* library.scm:2862: loop */
t6=t4;
t7=C_fixnum_plus(t2,C_fix(1));
t1=t6;
t2=t7;
goto loop;}}

/* k17925 in loop in scheme#vector->list in k8543 */
static void C_ccall f_17927(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,c,1)))){
C_save_and_reclaim((void *)f_17927,c,av);}
a=C_alloc(3);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_a_i_cons(&a,2,((C_word*)t0)[3],t1);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* scheme#vector in k8543 */
static void C_ccall f_17933(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand((c-2)*C_SIZEOF_PAIR +0,c,2)))){
C_save_and_reclaim((void*)f_17933,c,av);}
a=C_alloc((c-2)*C_SIZEOF_PAIR+0);
t2=C_build_rest(&a,c,2,av);
C_word t3;
/* library.scm:2864: scheme#list->vector */
t3=*((C_word*)lf[94]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t3;
av2[1]=t1;
av2[2]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(3,av2);}}

/* scheme#vector-fill! in k8543 */
static void C_ccall f_17939(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(6,c,2)))){
C_save_and_reclaim((void *)f_17939,c,av);}
a=C_alloc(6);
t4=C_i_check_vector_2(t2,lf[675]);
t5=C_block_size(t2);
t6=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_17948,a[2]=t5,a[3]=t2,a[4]=t3,a[5]=((C_word)li497),tmp=(C_word)a,a+=6,tmp);
t7=t1;{
C_word *av2=av;
av2[0]=t7;
av2[1]=(
  f_17948(t6,C_fix(0))
);
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}

/* doloop3520 in scheme#vector-fill! in k8543 */
static C_word C_fcall f_17948(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_stack_overflow_check;
loop:{}
if(C_truep(C_fixnum_greater_or_equal_p(t1,((C_word*)t0)[2]))){
t2=C_SCHEME_UNDEFINED;
return(t2);}
else{
t2=C_i_setslot(((C_word*)t0)[3],t1,((C_word*)t0)[4]);
t4=C_fixnum_plus(t1,C_fix(1));
t1=t4;
goto loop;}}

/* chicken.base#vector-copy! in k8543 */
static void C_ccall f_17967(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c<4) C_bad_min_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-4)*C_SIZEOF_PAIR +8,c,3)))){
C_save_and_reclaim((void*)f_17967,c,av);}
a=C_alloc((c-4)*C_SIZEOF_PAIR+8);
t4=C_build_rest(&a,c,4,av);
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
t5=C_i_check_vector_2(t2,lf[676]);
t6=C_i_check_vector_2(t3,lf[676]);
t7=C_block_size(t2);
t8=C_block_size(t3);
t9=C_i_pairp(t4);
t10=(C_truep(t9)?C_get_rest_arg(c,4,av,4,t0):C_i_fixnum_min(t8,t7));
t11=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_17986,a[2]=t10,a[3]=t2,a[4]=t3,a[5]=t1,a[6]=t8,a[7]=t7,tmp=(C_word)a,a+=8,tmp);
/* library.scm:2881: ##sys#check-fixnum */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[102]+1));
C_word *av2=av;
av2[0]=*((C_word*)lf[102]+1);
av2[1]=t11;
av2[2]=t10;
av2[3]=lf[676];
tp(4,av2);}}

/* k17984 in chicken.base#vector-copy! in k8543 */
static void C_ccall f_17986(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(6,c,7)))){
C_save_and_reclaim((void *)f_17986,c,av);}
a=C_alloc(6);
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_17989,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],tmp=(C_word)a,a+=6,tmp);
t3=C_fixnum_greaterp(((C_word*)t0)[2],((C_word*)t0)[6]);
t4=(C_truep(t3)?t3:C_fixnum_greaterp(((C_word*)t0)[2],((C_word*)t0)[7]));
if(C_truep(t4)){
/* library.scm:2883: ##sys#signal-hook */
t5=C_fast_retrieve(lf[194]);{
C_word *av2;
if(c >= 8) {
  av2=av;
} else {
  av2=C_alloc(8);
}
av2[0]=t5;
av2[1]=t2;
av2[2]=lf[382];
av2[3]=lf[676];
av2[4]=lf[677];
av2[5]=((C_word*)t0)[3];
av2[6]=((C_word*)t0)[4];
av2[7]=((C_word*)t0)[2];
((C_proc)(void*)(*((C_word*)t5+1)))(8,av2);}}
else{
t5=t2;{
C_word *av2=av;
av2[0]=t5;
av2[1]=C_SCHEME_UNDEFINED;
f_17989(2,av2);}}}

/* k17987 in k17984 in chicken.base#vector-copy! in k8543 */
static void C_ccall f_17989(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(6,c,2)))){
C_save_and_reclaim((void *)f_17989,c,av);}
a=C_alloc(6);
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_17994,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word)li499),tmp=(C_word)a,a+=6,tmp);
t3=((C_word*)t0)[5];{
C_word *av2=av;
av2[0]=t3;
av2[1]=(
  f_17994(t2,C_fix(0))
);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* doloop3532 in k17987 in k17984 in chicken.base#vector-copy! in k8543 */
static C_word C_fcall f_17994(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_stack_overflow_check;
loop:{}
if(C_truep(C_fixnum_greater_or_equal_p(t1,((C_word*)t0)[2]))){
t2=C_SCHEME_UNDEFINED;
return(t2);}
else{
t2=C_slot(((C_word*)t0)[3],t1);
t3=C_i_setslot(((C_word*)t0)[4],t1,t2);
t5=C_fixnum_plus(t1,C_fix(1));
t1=t5;
goto loop;}}

/* chicken.base#subvector in k8543 */
static void C_ccall f_18036(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word *a;
if(c<4) C_bad_min_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(8,c,5)))){
C_save_and_reclaim((void *)f_18036,c,av);}
a=C_alloc(8);
t4=C_rest_nullp(c,4);
t5=(C_truep(t4)?C_SCHEME_FALSE:C_get_rest_arg(c,4,av,4,t0));
t6=C_i_check_vector_2(t2,lf[678]);
t7=C_block_size(t2);
t8=(C_truep(t5)?t5:t7);
t9=C_fixnum_difference(t8,t3);
t10=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_18055,a[2]=t9,a[3]=t3,a[4]=t2,a[5]=t1,a[6]=t8,a[7]=t7,tmp=(C_word)a,a+=8,tmp);
/* library.scm:2896: ##sys#check-range */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[336]+1));
C_word av2[6];
av2[0]=*((C_word*)lf[336]+1);
av2[1]=t10;
av2[2]=t3;
av2[3]=C_fix(0);
av2[4]=C_fixnum_plus(t7,C_fix(1));
av2[5]=lf[678];
tp(6,av2);}}

/* k18053 in chicken.base#subvector in k8543 */
static void C_ccall f_18055(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(6,c,5)))){
C_save_and_reclaim((void *)f_18055,c,av);}
a=C_alloc(6);
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_18058,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],tmp=(C_word)a,a+=6,tmp);
/* library.scm:2897: ##sys#check-range */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[336]+1));
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=*((C_word*)lf[336]+1);
av2[1]=t2;
av2[2]=((C_word*)t0)[6];
av2[3]=C_fix(0);
av2[4]=C_fixnum_plus(((C_word*)t0)[7],C_fix(1));
av2[5]=lf[678];
tp(6,av2);}}

/* k18056 in k18053 in chicken.base#subvector in k8543 */
static void C_ccall f_18058(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(6,c,2)))){
C_save_and_reclaim((void *)f_18058,c,av);}
a=C_alloc(6);
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_18061,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],tmp=(C_word)a,a+=6,tmp);
/* library.scm:2898: scheme#make-vector */
t3=*((C_word*)lf[93]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=((C_word*)t0)[2];
((C_proc)(void*)(*((C_word*)t3+1)))(3,av2);}}

/* k18059 in k18056 in k18053 in chicken.base#subvector in k8543 */
static void C_ccall f_18061(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(7,c,2)))){
C_save_and_reclaim((void *)f_18061,c,av);}
a=C_alloc(7);
t2=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_18066,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=((C_word)li501),tmp=(C_word)a,a+=7,tmp);
t3=((C_word*)t0)[5];{
C_word *av2=av;
av2[0]=t3;
av2[1]=(
  f_18066(t2,C_fix(0))
);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* doloop3563 in k18059 in k18056 in k18053 in chicken.base#subvector in k8543 */
static C_word C_fcall f_18066(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_stack_overflow_check;
loop:{}
if(C_truep(C_fixnum_greater_or_equal_p(t1,((C_word*)t0)[2]))){
return(((C_word*)t0)[3]);}
else{
t2=C_fixnum_plus(t1,((C_word*)t0)[4]);
t3=C_slot(((C_word*)t0)[5],t2);
t4=C_i_setslot(((C_word*)t0)[3],t1,t3);
t6=C_fixnum_plus(t1,C_fix(1));
t1=t6;
goto loop;}}

/* chicken.base#vector-resize in k8543 */
static void C_ccall f_18107(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(c<4) C_bad_min_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(6,c,3)))){
C_save_and_reclaim((void *)f_18107,c,av);}
a=C_alloc(6);
t4=C_rest_nullp(c,4);
t5=(C_truep(t4)?C_SCHEME_FALSE:C_get_rest_arg(c,4,av,4,t0));
t6=C_i_check_vector_2(t2,lf[679]);
t7=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_18117,a[2]=t1,a[3]=t2,a[4]=t3,a[5]=t5,tmp=(C_word)a,a+=6,tmp);
/* library.scm:2906: ##sys#check-fixnum */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[102]+1));
C_word *av2=av;
av2[0]=*((C_word*)lf[102]+1);
av2[1]=t7;
av2[2]=t3;
av2[3]=lf[679];
tp(4,av2);}}

/* k18115 in chicken.base#vector-resize in k8543 */
static void C_ccall f_18117(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,4)))){
C_save_and_reclaim((void *)f_18117,c,av);}
/* library.scm:2907: ##sys#vector-resize */
f_18128(((C_word*)t0)[2],((C_word*)t0)[3],((C_word*)t0)[4],((C_word*)t0)[5]);}

/* ##sys#vector-resize in k8543 */
static void C_fcall f_18128(C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,0,3)))){
C_save_and_reclaim_args((void *)trf_18128,4,t1,t2,t3,t4);}
a=C_alloc(5);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_18132,a[2]=t2,a[3]=t1,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
/* library.scm:2910: ##sys#make-vector */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[672]+1));
C_word av2[4];
av2[0]=*((C_word*)lf[672]+1);
av2[1]=t5;
av2[2]=t3;
av2[3]=t4;
tp(4,av2);}}

/* k18130 in ##sys#vector-resize in k8543 */
static void C_ccall f_18132(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,c,3)))){
C_save_and_reclaim((void *)f_18132,c,av);}
a=C_alloc(5);
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_18135,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
/* library.scm:2911: scheme#min */
t3=*((C_word*)lf[560]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=C_block_size(((C_word*)t0)[2]);
av2[3]=((C_word*)t0)[4];
((C_proc)(void*)(*((C_word*)t3+1)))(4,av2);}}

/* k18133 in k18130 in ##sys#vector-resize in k8543 */
static void C_ccall f_18135(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(6,c,2)))){
C_save_and_reclaim((void *)f_18135,c,av);}
a=C_alloc(6);
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_18140,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=((C_word)li504),tmp=(C_word)a,a+=6,tmp);
t3=((C_word*)t0)[4];{
C_word *av2=av;
av2[0]=t3;
av2[1]=(
  f_18140(t2,C_fix(0))
);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* doloop3591 in k18133 in k18130 in ##sys#vector-resize in k8543 */
static C_word C_fcall f_18140(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_stack_overflow_check;
loop:{}
if(C_truep(C_fixnum_greater_or_equal_p(t1,((C_word*)t0)[2]))){
return(((C_word*)t0)[3]);}
else{
t2=C_slot(((C_word*)t0)[4],t1);
t3=C_i_setslot(((C_word*)t0)[3],t1,t2);
t5=C_fixnum_plus(t1,C_fix(1));
t1=t5;
goto loop;}}

/* scheme#char-ci=? in k8543 */
static void C_ccall f_18167(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_18167,c,av);}
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_eqp(C_u_i_char_downcase(t2),C_u_i_char_downcase(t3));
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* scheme#char-ci>? in k8543 */
static void C_ccall f_18181(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_18181,c,av);}
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_u_i_char_greaterp(C_u_i_char_downcase(t2),C_u_i_char_downcase(t3));
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* scheme#char-ci<? in k8543 */
static void C_ccall f_18192(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_18192,c,av);}
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_u_i_char_lessp(C_u_i_char_downcase(t2),C_u_i_char_downcase(t3));
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* scheme#char-ci>=? in k8543 */
static void C_ccall f_18203(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_18203,c,av);}
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_u_i_char_greater_or_equal_p(C_u_i_char_downcase(t2),C_u_i_char_downcase(t3));
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* scheme#char-ci<=? in k8543 */
static void C_ccall f_18214(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_18214,c,av);}
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_u_i_char_less_or_equal_p(C_u_i_char_downcase(t2),C_u_i_char_downcase(t3));
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* k18225 in k8543 */
static void C_ccall f_18227(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(15,c,3)))){
C_save_and_reclaim((void *)f_18227,c,av);}
a=C_alloc(15);
t2=C_SCHEME_END_OF_LIST;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_18229,a[2]=t1,a[3]=((C_word)li512),tmp=(C_word)a,a+=4,tmp);
t5=C_mutate((C_word*)lf[199]+1 /* (set! chicken.base#char-name ...) */,(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_18270,a[2]=t4,a[3]=t3,a[4]=t1,a[5]=((C_word)li513),tmp=(C_word)a,a+=6,tmp));
t6=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_18387,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
/* library.scm:2980: chicken.base#char-name */
t7=*((C_word*)lf[199]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t7;
av2[1]=t6;
av2[2]=lf[1403];
av2[3]=C_make_character(32);
((C_proc)(void*)(*((C_word*)t7+1)))(4,av2);}}

/* lookup-char in k18225 in k8543 */
static void C_fcall f_18229(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,0,2)))){
C_save_and_reclaim_args((void *)trf_18229,3,t0,t1,t2);}
a=C_alloc(4);
t3=C_fix(C_character_code(t2));
t4=C_fixnum_modulo(t3,C_fix(37));
t5=C_slot(((C_word*)t0)[2],t4);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_18242,a[2]=t2,a[3]=((C_word)li511),tmp=(C_word)a,a+=4,tmp);
t7=t1;{
C_word av2[2];
av2[0]=t7;
av2[1]=(
  f_18242(t6,t5)
);
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}

/* loop in lookup-char in k18225 in k8543 */
static C_word C_fcall f_18242(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_stack_overflow_check;
loop:{}
if(C_truep(C_i_pairp(t1))){
t2=C_slot(t1,C_fix(0));
t3=C_slot(t2,C_fix(0));
t4=C_eqp(t3,((C_word*)t0)[2]);
if(C_truep(t4)){
return(t2);}
else{
t6=C_slot(t1,C_fix(1));
t1=t6;
goto loop;}}
else{
return(C_SCHEME_FALSE);}}

/* chicken.base#char-name in k18225 in k8543 */
static void C_ccall f_18270(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +8,c,5)))){
C_save_and_reclaim((void*)f_18270,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+8);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
t4=C_i_pairp(t3);
t5=(C_truep(t4)?C_get_rest_arg(c,3,av,3,t0):C_SCHEME_FALSE);
if(C_truep(C_charp(t2))){
t6=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_18283,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* library.scm:2954: lookup-char */
t7=((C_word*)t0)[2];
f_18229(t7,t6,t2);}
else{
if(C_truep(t5)){
t6=C_i_check_symbol_2(t2,lf[681]);
t7=C_i_check_char_2(t5,lf[681]);
t8=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_18301,a[2]=t2,a[3]=((C_word*)t0)[3],a[4]=t1,a[5]=t5,a[6]=((C_word*)t0)[4],a[7]=((C_word*)t0)[2],tmp=(C_word)a,a+=8,tmp);
t9=C_slot(t2,C_fix(1));
t10=C_block_size(t9);
if(C_truep(C_fixnum_lessp(t10,C_fix(2)))){
/* library.scm:2960: ##sys#signal-hook */
t11=C_fast_retrieve(lf[194]);{
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=t11;
av2[1]=t8;
av2[2]=lf[260];
av2[3]=lf[681];
av2[4]=lf[682];
av2[5]=t2;
((C_proc)(void*)(*((C_word*)t11+1)))(6,av2);}}
else{
t11=t8;{
C_word *av2=av;
av2[0]=t11;
av2[1]=C_SCHEME_UNDEFINED;
f_18301(2,av2);}}}
else{
t6=C_i_check_symbol_2(t2,lf[681]);
t7=C_i_assq(t2,((C_word*)((C_word*)t0)[3])[1]);
t8=t1;{
C_word *av2=av;
av2[0]=t8;
av2[1]=(C_truep(t7)?C_slot(t7,C_fix(1)):C_SCHEME_FALSE);
((C_proc)(void*)(*((C_word*)t8+1)))(2,av2);}}}}

/* k18281 in chicken.base#char-name in k18225 in k8543 */
static void C_ccall f_18283(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_18283,c,av);}
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=(C_truep(t1)?C_slot(t1,C_fix(1)):C_SCHEME_FALSE);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* k18299 in chicken.base#char-name in k18225 in k8543 */
static void C_ccall f_18301(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(7,c,2)))){
C_save_and_reclaim((void *)f_18301,c,av);}
a=C_alloc(7);
t2=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_18304,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],tmp=(C_word)a,a+=7,tmp);
/* library.scm:2961: lookup-char */
t3=((C_word*)t0)[7];
f_18229(t3,t2,((C_word*)t0)[5]);}

/* k18302 in k18299 in chicken.base#char-name in k18225 in k8543 */
static void C_ccall f_18304(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(12,c,1)))){
C_save_and_reclaim((void *)f_18304,c,av);}
a=C_alloc(12);
if(C_truep(t1)){
t2=C_i_assq(((C_word*)t0)[2],((C_word*)((C_word*)t0)[3])[1]);
t3=C_i_setslot(t1,C_fix(1),((C_word*)t0)[2]);
if(C_truep(t2)){
t4=((C_word*)t0)[4];{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_i_set_i_slot(t2,C_fix(1),((C_word*)t0)[5]);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t4=C_a_i_cons(&a,2,((C_word*)t0)[2],((C_word*)t0)[5]);
t5=C_a_i_cons(&a,2,t4,((C_word*)((C_word*)t0)[3])[1]);
t6=C_mutate(((C_word *)((C_word*)t0)[3])+1,t5);
t7=((C_word*)t0)[4];{
C_word *av2=av;
av2[0]=t7;
av2[1]=t6;
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}}
else{
t2=C_fix(C_character_code(((C_word*)t0)[5]));
t3=C_fixnum_modulo(t2,C_fix(37));
t4=C_a_i_cons(&a,2,((C_word*)t0)[2],((C_word*)t0)[5]);
t5=C_a_i_cons(&a,2,t4,((C_word*)((C_word*)t0)[3])[1]);
t6=C_mutate(((C_word *)((C_word*)t0)[3])+1,t5);
t7=C_a_i_cons(&a,2,((C_word*)t0)[5],((C_word*)t0)[2]);
t8=C_slot(((C_word*)t0)[6],t3);
t9=C_a_i_cons(&a,2,t7,t8);
t10=((C_word*)t0)[4];{
C_word *av2=av;
av2[0]=t10;
av2[1]=C_i_setslot(((C_word*)t0)[6],t3,t9);
((C_proc)(void*)(*((C_word*)t10+1)))(2,av2);}}}

/* k18385 in k18225 in k8543 */
static void C_ccall f_18387(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,c,3)))){
C_save_and_reclaim((void *)f_18387,c,av);}
a=C_alloc(3);
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_18390,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
/* library.scm:2981: chicken.base#char-name */
t3=*((C_word*)lf[199]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=lf[1402];
av2[3]=C_make_character(9);
((C_proc)(void*)(*((C_word*)t3+1)))(4,av2);}}

/* k18388 in k18385 in k18225 in k8543 */
static void C_ccall f_18390(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,c,3)))){
C_save_and_reclaim((void *)f_18390,c,av);}
a=C_alloc(3);
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_18393,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
/* library.scm:2982: chicken.base#char-name */
t3=*((C_word*)lf[199]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=lf[1401];
av2[3]=C_make_character(10);
((C_proc)(void*)(*((C_word*)t3+1)))(4,av2);}}

/* k18391 in k18388 in k18385 in k18225 in k8543 */
static void C_ccall f_18393(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,c,3)))){
C_save_and_reclaim((void *)f_18393,c,av);}
a=C_alloc(3);
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_18396,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
/* library.scm:2983: chicken.base#char-name */
t3=*((C_word*)lf[199]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=lf[1400];
av2[3]=C_make_character(10);
((C_proc)(void*)(*((C_word*)t3+1)))(4,av2);}}

/* k18394 in k18391 in k18388 in k18385 in k18225 in k8543 */
static void C_ccall f_18396(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,c,3)))){
C_save_and_reclaim((void *)f_18396,c,av);}
a=C_alloc(3);
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_18399,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
/* library.scm:2984: chicken.base#char-name */
t3=*((C_word*)lf[199]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=lf[1399];
av2[3]=C_make_character(11);
((C_proc)(void*)(*((C_word*)t3+1)))(4,av2);}}

/* k18397 in k18394 in k18391 in k18388 in k18385 in k18225 in k8543 */
static void C_ccall f_18399(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,c,3)))){
C_save_and_reclaim((void *)f_18399,c,av);}
a=C_alloc(3);
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_18402,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
/* library.scm:2985: chicken.base#char-name */
t3=*((C_word*)lf[199]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=lf[1398];
av2[3]=C_make_character(127);
((C_proc)(void*)(*((C_word*)t3+1)))(4,av2);}}

/* k18400 in k18397 in k18394 in k18391 in k18388 in k18385 in k18225 in k8543 */
static void C_ccall f_18402(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,c,3)))){
C_save_and_reclaim((void *)f_18402,c,av);}
a=C_alloc(3);
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_18405,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
/* library.scm:2986: chicken.base#char-name */
t3=*((C_word*)lf[199]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=lf[1397];
av2[3]=C_make_character(27);
((C_proc)(void*)(*((C_word*)t3+1)))(4,av2);}}

/* k18403 in k18400 in k18397 in k18394 in k18391 in k18388 in k18385 in k18225 in k8543 */
static void C_ccall f_18405(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,c,3)))){
C_save_and_reclaim((void *)f_18405,c,av);}
a=C_alloc(3);
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_18408,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
/* library.scm:2987: chicken.base#char-name */
t3=*((C_word*)lf[199]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=lf[1396];
av2[3]=C_make_character(27);
((C_proc)(void*)(*((C_word*)t3+1)))(4,av2);}}

/* k18406 in k18403 in k18400 in k18397 in k18394 in k18391 in k18388 in k18385 in k18225 in k8543 */
static void C_ccall f_18408(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,c,3)))){
C_save_and_reclaim((void *)f_18408,c,av);}
a=C_alloc(3);
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_18411,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
/* library.scm:2988: chicken.base#char-name */
t3=*((C_word*)lf[199]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=lf[1395];
av2[3]=C_make_character(7);
((C_proc)(void*)(*((C_word*)t3+1)))(4,av2);}}

/* k18409 in k18406 in k18403 in k18400 in k18397 in k18394 in k18391 in k18388 in k18385 in k18225 in k8543 */
static void C_ccall f_18411(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,c,3)))){
C_save_and_reclaim((void *)f_18411,c,av);}
a=C_alloc(3);
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_18414,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
/* library.scm:2989: chicken.base#char-name */
t3=*((C_word*)lf[199]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=lf[1394];
av2[3]=C_make_character(0);
((C_proc)(void*)(*((C_word*)t3+1)))(4,av2);}}

/* k18412 in k18409 in k18406 in k18403 in k18400 in k18397 in k18394 in k18391 in k18388 in k18385 in k18225 in k8543 */
static void C_ccall f_18414(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,c,3)))){
C_save_and_reclaim((void *)f_18414,c,av);}
a=C_alloc(3);
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_18417,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
/* library.scm:2990: chicken.base#char-name */
t3=*((C_word*)lf[199]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=lf[1393];
av2[3]=C_make_character(0);
((C_proc)(void*)(*((C_word*)t3+1)))(4,av2);}}

/* k18415 in k18412 in k18409 in k18406 in k18403 in k18400 in k18397 in k18394 in k18391 in k18388 in k18385 in k18225 in k8543 */
static void C_ccall f_18417(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,c,3)))){
C_save_and_reclaim((void *)f_18417,c,av);}
a=C_alloc(3);
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_18420,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
/* library.scm:2991: chicken.base#char-name */
t3=*((C_word*)lf[199]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=lf[1392];
av2[3]=C_make_character(13);
((C_proc)(void*)(*((C_word*)t3+1)))(4,av2);}}

/* k18418 in k18415 in k18412 in k18409 in k18406 in k18403 in k18400 in k18397 in k18394 in k18391 in k18388 in k18385 in k18225 in k8543 */
static void C_ccall f_18420(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,c,3)))){
C_save_and_reclaim((void *)f_18420,c,av);}
a=C_alloc(3);
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_18423,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
/* library.scm:2992: chicken.base#char-name */
t3=*((C_word*)lf[199]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=lf[1391];
av2[3]=C_make_character(12);
((C_proc)(void*)(*((C_word*)t3+1)))(4,av2);}}

/* k18421 in k18418 in k18415 in k18412 in k18409 in k18406 in k18403 in k18400 in k18397 in k18394 in k18391 in k18388 in k18385 in k18225 in k8543 */
static void C_ccall f_18423(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,c,3)))){
C_save_and_reclaim((void *)f_18423,c,av);}
a=C_alloc(3);
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_18426,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
/* library.scm:2993: chicken.base#char-name */
t3=*((C_word*)lf[199]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=lf[1390];
av2[3]=C_make_character(8);
((C_proc)(void*)(*((C_word*)t3+1)))(4,av2);}}

/* k18424 in k18421 in k18418 in k18415 in k18412 in k18409 in k18406 in k18403 in k18400 in k18397 in k18394 in k18391 in k18388 in k18385 in k18225 in k8543 */
static void C_ccall f_18426(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word t19;
C_word t20;
C_word t21;
C_word t22;
C_word t23;
C_word t24;
C_word t25;
C_word t26;
C_word t27;
C_word t28;
C_word t29;
C_word t30;
C_word t31;
C_word t32;
C_word t33;
C_word t34;
C_word t35;
C_word t36;
C_word t37;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(93,c,6)))){
C_save_and_reclaim((void *)f_18426,c,av);}
a=C_alloc(93);
t2=C_mutate((C_word*)lf[683]+1 /* (set! ##sys#call-with-current-continuation ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)C_call_cc,a[2]=((C_word)li514),tmp=(C_word)a,a+=3,tmp));
t3=C_mutate((C_word*)lf[684]+1 /* (set! ##sys#call-with-cthulhu ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)C_call_with_cthulhu,a[2]=((C_word)li515),tmp=(C_word)a,a+=3,tmp));
t4=C_mutate((C_word*)lf[685]+1 /* (set! ##sys#call-with-values ...) */,*((C_word*)lf[131]+1));
t5=C_mutate((C_word*)lf[686]+1 /* (set! ##sys#for-each ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_18431,a[2]=((C_word)li517),tmp=(C_word)a,a+=3,tmp));
t6=C_mutate((C_word*)lf[688]+1 /* (set! ##sys#map ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_18469,a[2]=((C_word)li519),tmp=(C_word)a,a+=3,tmp));
t7=C_SCHEME_UNDEFINED;
t8=(*a=C_VECTOR_TYPE|1,a[1]=t7,tmp=(C_word)a,a+=2,tmp);
t9=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_18511,a[2]=((C_word)li522),tmp=(C_word)a,a+=3,tmp);
t10=C_set_block_item(t8,0,t9);
t11=C_mutate((C_word*)lf[170]+1 /* (set! scheme#for-each ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_18569,a[2]=t8,a[3]=((C_word)li527),tmp=(C_word)a,a+=4,tmp));
t12=C_mutate((C_word*)lf[171]+1 /* (set! scheme#map ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_18651,a[2]=t8,a[3]=((C_word)li532),tmp=(C_word)a,a+=4,tmp));
t13=C_set_block_item(lf[690] /* ##sys#dynamic-winds */,0,C_SCHEME_END_OF_LIST);
t14=C_mutate((C_word*)lf[172]+1 /* (set! scheme#dynamic-wind ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_18753,a[2]=((C_word)li534),tmp=(C_word)a,a+=3,tmp));
t15=C_mutate((C_word*)lf[691]+1 /* (set! ##sys#dynamic-wind ...) */,*((C_word*)lf[172]+1));
t16=C_mutate((C_word*)lf[132]+1 /* (set! scheme#call-with-current-continuation ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_18784,a[2]=((C_word)li537),tmp=(C_word)a,a+=3,tmp));
t17=C_mutate((C_word*)lf[198]+1 /* (set! chicken.base#call/cc ...) */,*((C_word*)lf[132]+1));
t18=C_mutate(&lf[692] /* (set! ##sys#dynamic-unwind ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_18824,a[2]=((C_word)li538),tmp=(C_word)a,a+=3,tmp));
t19=C_mutate((C_word*)lf[209]+1 /* (set! chicken.base#port? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_18882,a[2]=((C_word)li539),tmp=(C_word)a,a+=3,tmp));
t20=C_mutate((C_word*)lf[211]+1 /* (set! chicken.base#input-port-open? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_18888,a[2]=((C_word)li540),tmp=(C_word)a,a+=3,tmp));
t21=C_mutate((C_word*)lf[212]+1 /* (set! chicken.base#output-port-open? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_18893,a[2]=((C_word)li541),tmp=(C_word)a,a+=3,tmp));
t22=C_mutate((C_word*)lf[210]+1 /* (set! chicken.base#port-closed? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_18898,a[2]=((C_word)li542),tmp=(C_word)a,a+=3,tmp));
t23=C_mutate((C_word*)lf[697]+1 /* (set! ##sys#make-port ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_18911,a[2]=((C_word)li543),tmp=(C_word)a,a+=3,tmp));
t24=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_32077,a[2]=((C_word)li545),tmp=(C_word)a,a+=3,tmp);
t25=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_32117,a[2]=((C_word)li547),tmp=(C_word)a,a+=3,tmp);
t26=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_32157,a[2]=((C_word)li548),tmp=(C_word)a,a+=3,tmp);
t27=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_32160,a[2]=((C_word)li549),tmp=(C_word)a,a+=3,tmp);
t28=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_32163,a[2]=((C_word)li550),tmp=(C_word)a,a+=3,tmp);
t29=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_32169,a[2]=((C_word)li551),tmp=(C_word)a,a+=3,tmp);
t30=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_32172,a[2]=((C_word)li552),tmp=(C_word)a,a+=3,tmp);
t31=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_32175,a[2]=((C_word)li555),tmp=(C_word)a,a+=3,tmp);
t32=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_32274,a[2]=((C_word)li558),tmp=(C_word)a,a+=3,tmp);
t33=C_a_i_vector(&a,10,t24,t25,t26,t27,t28,t29,t30,t31,t32,C_SCHEME_FALSE);
t34=C_mutate((C_word*)lf[711]+1 /* (set! ##sys#stream-port-class ...) */,t33);
t35=C_mutate((C_word*)lf[712]+1 /* (set! ##sys#open-file-port ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)C_open_file_port,a[2]=((C_word)li559),tmp=(C_word)a,a+=3,tmp));
t36=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_18942,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
/* library.scm:3271: ##sys#make-port */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[697]);
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=*((C_word*)lf[697]+1);
av2[1]=t36;
av2[2]=C_fix(1);
av2[3]=C_fast_retrieve(lf[711]);
av2[4]=lf[1389];
av2[5]=lf[730];
tp(6,av2);}}

/* ##sys#for-each in k18424 in k18421 in k18418 in k18415 in k18412 in k18409 in k18406 in k18403 in k18400 in k18397 in k18394 in k18391 in k18388 in k18385 in k18225 in k8543 */
static void C_ccall f_18431(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(8,c,3)))){
C_save_and_reclaim((void *)f_18431,c,av);}
a=C_alloc(8);
t4=C_SCHEME_UNDEFINED;
t5=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t6=C_set_block_item(t5,0,(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_18437,a[2]=t5,a[3]=t2,a[4]=t3,a[5]=((C_word)li516),tmp=(C_word)a,a+=6,tmp));
t7=((C_word*)t5)[1];
f_18437(t7,t1,t3);}

/* loop in ##sys#for-each in k18424 in k18421 in k18418 in k18415 in k18412 in k18409 in k18406 in k18403 in k18400 in k18397 in k18394 in k18391 in k18388 in k18385 in k18225 in k8543 */
static void C_fcall f_18437(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,0,3)))){
C_save_and_reclaim_args((void *)trf_18437,3,t0,t1,t2);}
a=C_alloc(5);
t3=C_eqp(t2,C_SCHEME_END_OF_LIST);
if(C_truep(t3)){
t4=C_SCHEME_UNDEFINED;
t5=t1;{
C_word av2[2];
av2[0]=t5;
av2[1]=t4;
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}
else{
if(C_truep(C_i_pairp(t2))){
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_18453,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* library.scm:3006: p */
t5=((C_word*)t0)[3];{
C_word av2[3];
av2[0]=t5;
av2[1]=t4;
av2[2]=C_slot(t2,C_fix(0));
((C_proc)C_fast_retrieve_proc(t5))(3,av2);}}
else{
/* library.scm:3008: ##sys#error-not-a-proper-list */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[47]+1));
C_word av2[4];
av2[0]=*((C_word*)lf[47]+1);
av2[1]=t1;
av2[2]=((C_word*)t0)[4];
av2[3]=lf[687];
tp(4,av2);}}}}

/* k18451 in loop in ##sys#for-each in k18424 in k18421 in k18418 in k18415 in k18412 in k18409 in k18406 in k18403 in k18400 in k18397 in k18394 in k18391 in k18388 in k18385 in k18225 in k8543 */
static void C_ccall f_18453(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_18453,c,av);}
/* library.scm:3007: loop */
t2=((C_word*)((C_word*)t0)[2])[1];
f_18437(t2,((C_word*)t0)[3],C_slot(((C_word*)t0)[4],C_fix(1)));}

/* ##sys#map in k18424 in k18421 in k18418 in k18415 in k18412 in k18409 in k18406 in k18403 in k18400 in k18397 in k18394 in k18391 in k18388 in k18385 in k18225 in k8543 */
static void C_ccall f_18469(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(8,c,3)))){
C_save_and_reclaim((void *)f_18469,c,av);}
a=C_alloc(8);
t4=C_SCHEME_UNDEFINED;
t5=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t6=C_set_block_item(t5,0,(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_18475,a[2]=t5,a[3]=t2,a[4]=t3,a[5]=((C_word)li518),tmp=(C_word)a,a+=6,tmp));
t7=((C_word*)t5)[1];
f_18475(t7,t1,t3);}

/* loop in ##sys#map in k18424 in k18421 in k18418 in k18415 in k18412 in k18409 in k18406 in k18403 in k18400 in k18397 in k18394 in k18391 in k18388 in k18385 in k18225 in k8543 */
static void C_fcall f_18475(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,0,3)))){
C_save_and_reclaim_args((void *)trf_18475,3,t0,t1,t2);}
a=C_alloc(5);
t3=C_eqp(t2,C_SCHEME_END_OF_LIST);
if(C_truep(t3)){
t4=t1;{
C_word av2[2];
av2[0]=t4;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
if(C_truep(C_i_pairp(t2))){
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_18495,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* library.scm:3014: p */
t5=((C_word*)t0)[3];{
C_word av2[3];
av2[0]=t5;
av2[1]=t4;
av2[2]=C_slot(t2,C_fix(0));
((C_proc)C_fast_retrieve_proc(t5))(3,av2);}}
else{
/* library.scm:3015: ##sys#error-not-a-proper-list */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[47]+1));
C_word av2[4];
av2[0]=*((C_word*)lf[47]+1);
av2[1]=t1;
av2[2]=((C_word*)t0)[4];
av2[3]=lf[689];
tp(4,av2);}}}}

/* k18493 in loop in ##sys#map in k18424 in k18421 in k18418 in k18415 in k18412 in k18409 in k18406 in k18403 in k18400 in k18397 in k18394 in k18391 in k18388 in k18385 in k18225 in k8543 */
static void C_ccall f_18495(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,2)))){
C_save_and_reclaim((void *)f_18495,c,av);}
a=C_alloc(4);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_18499,a[2]=((C_word*)t0)[2],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* library.scm:3014: loop */
t3=((C_word*)((C_word*)t0)[3])[1];
f_18475(t3,t2,C_slot(((C_word*)t0)[4],C_fix(1)));}

/* k18497 in k18493 in loop in ##sys#map in k18424 in k18421 in k18418 in k18415 in k18412 in k18409 in k18406 in k18403 in k18400 in k18397 in k18394 in k18391 in k18388 in k18385 in k18225 in k8543 */
static void C_ccall f_18499(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,c,1)))){
C_save_and_reclaim((void *)f_18499,c,av);}
a=C_alloc(3);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_a_i_cons(&a,2,((C_word*)t0)[3],t1);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* mapsafe3667 in k18424 in k18421 in k18418 in k18415 in k18412 in k18409 in k18406 in k18403 in k18400 in k18397 in k18394 in k18391 in k18388 in k18385 in k18225 in k8543 */
static void C_ccall f_18511(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5;
C_word t6;
C_word *a;
if(c!=5) C_bad_argc_2(c,5,t0);
if(C_unlikely(!C_demand(C_calculate_demand(6,c,3)))){
C_save_and_reclaim((void *)f_18511,c,av);}
a=C_alloc(6);
t5=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_18517,a[2]=t2,a[3]=t4,a[4]=t3,a[5]=((C_word)li521),tmp=(C_word)a,a+=6,tmp);
/* library.scm:3019: scheme#call-with-current-continuation */
t6=*((C_word*)lf[132]+1);{
C_word *av2=av;
av2[0]=t6;
av2[1]=t1;
av2[2]=t5;
((C_proc)(void*)(*((C_word*)t6+1)))(3,av2);}}

/* a18516 in mapsafe3667 in k18424 in k18421 in k18418 in k18415 in k18412 in k18409 in k18406 in k18403 in k18400 in k18397 in k18394 in k18391 in k18388 in k18385 in k18225 in k8543 */
static void C_ccall f_18517(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(9,c,3)))){
C_save_and_reclaim((void *)f_18517,c,av);}
a=C_alloc(9);
t3=C_SCHEME_UNDEFINED;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_set_block_item(t4,0,(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_18523,a[2]=t2,a[3]=t4,a[4]=((C_word*)t0)[2],a[5]=((C_word*)t0)[3],a[6]=((C_word)li520),tmp=(C_word)a,a+=7,tmp));
t6=((C_word*)t4)[1];
f_18523(t6,t1,((C_word*)t0)[4]);}

/* lp in a18516 in mapsafe3667 in k18424 in k18421 in k18418 in k18415 in k18412 in k18409 in k18406 in k18403 in k18400 in k18397 in k18394 in k18391 in k18388 in k18385 in k18225 in k8543 */
static void C_fcall f_18523(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,0,3)))){
C_save_and_reclaim_args((void *)trf_18523,3,t0,t1,t2);}
a=C_alloc(5);
t3=C_eqp(t2,C_SCHEME_END_OF_LIST);
if(C_truep(t3)){
t4=t1;{
C_word av2[2];
av2[0]=t4;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t4=C_slot(t2,C_fix(0));
t5=C_eqp(t4,C_SCHEME_END_OF_LIST);
if(C_truep(t5)){
/* library.scm:3025: empty */
t6=((C_word*)t0)[2];{
C_word av2[3];
av2[0]=t6;
av2[1]=t1;
av2[2]=C_SCHEME_END_OF_LIST;
((C_proc)C_fast_retrieve_proc(t6))(3,av2);}}
else{
if(C_truep(C_i_pairp(t4))){
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_18555,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* library.scm:3027: p */
t7=((C_word*)t0)[4];{
C_word av2[3];
av2[0]=t7;
av2[1]=t6;
av2[2]=t4;
((C_proc)C_fast_retrieve_proc(t7))(3,av2);}}
else{
/* library.scm:3028: ##sys#error-not-a-proper-list */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[47]+1));
C_word av2[4];
av2[0]=*((C_word*)lf[47]+1);
av2[1]=t1;
av2[2]=t4;
av2[3]=((C_word*)t0)[5];
tp(4,av2);}}}}}

/* k18553 in lp in a18516 in mapsafe3667 in k18424 in k18421 in k18418 in k18415 in k18412 in k18409 in k18406 in k18403 in k18400 in k18397 in k18394 in k18391 in k18388 in k18385 in k18225 in k8543 */
static void C_ccall f_18555(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,2)))){
C_save_and_reclaim((void *)f_18555,c,av);}
a=C_alloc(4);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_18559,a[2]=((C_word*)t0)[2],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* library.scm:3027: lp */
t3=((C_word*)((C_word*)t0)[3])[1];
f_18523(t3,t2,C_slot(((C_word*)t0)[4],C_fix(1)));}

/* k18557 in k18553 in lp in a18516 in mapsafe3667 in k18424 in k18421 in k18418 in k18415 in k18412 in k18409 in k18406 in k18403 in k18400 in k18397 in k18394 in k18391 in k18388 in k18385 in k18225 in k8543 */
static void C_ccall f_18559(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,c,1)))){
C_save_and_reclaim((void *)f_18559,c,av);}
a=C_alloc(3);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_a_i_cons(&a,2,((C_word*)t0)[3],t1);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* scheme#for-each in k18424 in k18421 in k18418 in k18415 in k18412 in k18409 in k18406 in k18403 in k18400 in k18397 in k18394 in k18391 in k18388 in k18385 in k18225 in k8543 */
static void C_ccall f_18569(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c<4) C_bad_min_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-4)*C_SIZEOF_PAIR +11,c,3)))){
C_save_and_reclaim((void*)f_18569,c,av);}
a=C_alloc((c-4)*C_SIZEOF_PAIR+11);
t4=C_build_rest(&a,c,4,av);
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
if(C_truep(C_rest_nullp(c,4))){
t5=C_i_check_list_2(t3,lf[687]);
t6=C_SCHEME_UNDEFINED;
t7=(*a=C_VECTOR_TYPE|1,a[1]=t6,tmp=(C_word)a,a+=2,tmp);
t8=C_set_block_item(t7,0,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_18584,a[2]=t7,a[3]=t2,a[4]=((C_word)li523),tmp=(C_word)a,a+=5,tmp));
t9=((C_word*)t7)[1];
f_18584(t9,t1,t3);}
else{
t5=C_a_i_cons(&a,2,t3,t4);
t6=C_SCHEME_UNDEFINED;
t7=(*a=C_VECTOR_TYPE|1,a[1]=t6,tmp=(C_word)a,a+=2,tmp);
t8=C_set_block_item(t7,0,(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_18614,a[2]=t7,a[3]=((C_word*)t0)[2],a[4]=t2,a[5]=((C_word)li526),tmp=(C_word)a,a+=6,tmp));
t9=((C_word*)t7)[1];
f_18614(t9,t1,t5);}}

/* for-each-loop3687 in scheme#for-each in k18424 in k18421 in k18418 in k18415 in k18412 in k18409 in k18406 in k18403 in k18400 in k18397 in k18394 in k18391 in k18388 in k18385 in k18225 in k8543 */
static void C_fcall f_18584(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,0,2)))){
C_save_and_reclaim_args((void *)trf_18584,3,t0,t1,t2);}
a=C_alloc(5);
if(C_truep(C_i_pairp(t2))){
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_18594,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* library.scm:3033: g3688 */
t4=((C_word*)t0)[3];{
C_word av2[3];
av2[0]=t4;
av2[1]=t3;
av2[2]=C_slot(t2,C_fix(0));
((C_proc)C_fast_retrieve_proc(t4))(3,av2);}}
else{
t3=C_SCHEME_UNDEFINED;
t4=t1;{
C_word av2[2];
av2[0]=t4;
av2[1]=t3;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}}

/* k18592 in for-each-loop3687 in scheme#for-each in k18424 in k18421 in k18418 in k18415 in k18412 in k18409 in k18406 in k18403 in k18400 in k18397 in k18394 in k18391 in k18388 in k18385 in k18225 in k8543 */
static void C_ccall f_18594(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_18594,c,av);}
t2=((C_word*)((C_word*)t0)[2])[1];
f_18584(t2,((C_word*)t0)[3],C_slot(((C_word*)t0)[4],C_fix(1)));}

/* loop in scheme#for-each in k18424 in k18421 in k18418 in k18415 in k18412 in k18409 in k18406 in k18403 in k18400 in k18397 in k18394 in k18391 in k18388 in k18385 in k18225 in k8543 */
static void C_fcall f_18614(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(10,0,4)))){
C_save_and_reclaim_args((void *)trf_18614,3,t0,t1,t2);}
a=C_alloc(10);
t3=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_18621,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=((C_word*)t0)[3],a[5]=t2,a[6]=((C_word*)t0)[4],tmp=(C_word)a,a+=7,tmp);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_18645,a[2]=((C_word)li525),tmp=(C_word)a,a+=3,tmp);
/* library.scm:3036: mapsafe */
t5=((C_word*)((C_word*)t0)[3])[1];{
C_word av2[5];
av2[0]=t5;
av2[1]=t3;
av2[2]=t4;
av2[3]=t2;
av2[4]=lf[687];
((C_proc)C_fast_retrieve_proc(t5))(5,av2);}}

/* k18619 in loop in scheme#for-each in k18424 in k18421 in k18418 in k18415 in k18412 in k18409 in k18406 in k18403 in k18400 in k18397 in k18394 in k18391 in k18388 in k18385 in k18225 in k8543 */
static void C_ccall f_18621(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(6,c,3)))){
C_save_and_reclaim((void *)f_18621,c,av);}
a=C_alloc(6);
if(C_truep(C_i_pairp(t1))){
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_18630,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],tmp=(C_word)a,a+=6,tmp);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=0;
av2[1]=t2;
av2[2]=((C_word*)t0)[6];
av2[3]=t1;
C_apply(4,av2);}}
else{
t2=C_SCHEME_UNDEFINED;
t3=((C_word*)t0)[3];{
C_word *av2=av;
av2[0]=t3;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}}

/* k18628 in k18619 in loop in scheme#for-each in k18424 in k18421 in k18418 in k18415 in k18412 in k18409 in k18406 in k18403 in k18400 in k18397 in k18394 in k18391 in k18388 in k18385 in k18225 in k8543 */
static void C_ccall f_18630(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(7,c,4)))){
C_save_and_reclaim((void *)f_18630,c,av);}
a=C_alloc(7);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_18637,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_18639,a[2]=((C_word)li524),tmp=(C_word)a,a+=3,tmp);
/* library.scm:3039: mapsafe */
t4=((C_word*)((C_word*)t0)[4])[1];{
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=t4;
av2[1]=t2;
av2[2]=t3;
av2[3]=((C_word*)t0)[5];
av2[4]=lf[687];
((C_proc)C_fast_retrieve_proc(t4))(5,av2);}}

/* k18635 in k18628 in k18619 in loop in scheme#for-each in k18424 in k18421 in k18418 in k18415 in k18412 in k18409 in k18406 in k18403 in k18400 in k18397 in k18394 in k18391 in k18388 in k18385 in k18225 in k8543 */
static void C_ccall f_18637(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_18637,c,av);}
/* library.scm:3039: loop */
t2=((C_word*)((C_word*)t0)[2])[1];
f_18614(t2,((C_word*)t0)[3],t1);}

/* a18638 in k18628 in k18619 in loop in scheme#for-each in k18424 in k18421 in k18418 in k18415 in k18412 in k18409 in k18406 in k18403 in k18400 in k18397 in k18394 in k18391 in k18388 in k18385 in k18225 in k8543 */
static void C_ccall f_18639(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_18639,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_i_cdr(t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* a18644 in loop in scheme#for-each in k18424 in k18421 in k18418 in k18415 in k18412 in k18409 in k18406 in k18403 in k18400 in k18397 in k18394 in k18391 in k18388 in k18385 in k18225 in k8543 */
static void C_ccall f_18645(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_18645,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_i_car(t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* scheme#map in k18424 in k18421 in k18418 in k18415 in k18412 in k18409 in k18406 in k18403 in k18400 in k18397 in k18394 in k18391 in k18388 in k18385 in k18225 in k8543 */
static void C_ccall f_18651(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c<4) C_bad_min_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-4)*C_SIZEOF_PAIR +14,c,3)))){
C_save_and_reclaim((void*)f_18651,c,av);}
a=C_alloc((c-4)*C_SIZEOF_PAIR+14);
t4=C_build_rest(&a,c,4,av);
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
if(C_truep(C_rest_nullp(c,4))){
t5=C_a_i_cons(&a,2,C_SCHEME_UNDEFINED,C_SCHEME_END_OF_LIST);
t6=t5;
t7=(*a=C_VECTOR_TYPE|1,a[1]=t6,tmp=(C_word)a,a+=2,tmp);
t8=((C_word*)t7)[1];
t9=C_i_check_list_2(t3,lf[689]);
t10=C_SCHEME_UNDEFINED;
t11=(*a=C_VECTOR_TYPE|1,a[1]=t10,tmp=(C_word)a,a+=2,tmp);
t12=C_set_block_item(t11,0,(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_18669,a[2]=t7,a[3]=t11,a[4]=t2,a[5]=t8,a[6]=((C_word)li528),tmp=(C_word)a,a+=7,tmp));
t13=((C_word*)t11)[1];
f_18669(t13,t1,t3);}
else{
t5=C_a_i_cons(&a,2,t3,t4);
t6=C_SCHEME_UNDEFINED;
t7=(*a=C_VECTOR_TYPE|1,a[1]=t6,tmp=(C_word)a,a+=2,tmp);
t8=C_set_block_item(t7,0,(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_18710,a[2]=t7,a[3]=((C_word*)t0)[2],a[4]=t2,a[5]=((C_word)li531),tmp=(C_word)a,a+=6,tmp));
t9=((C_word*)t7)[1];
f_18710(t9,t1,t5);}}

/* map-loop3715 in scheme#map in k18424 in k18421 in k18418 in k18415 in k18412 in k18409 in k18406 in k18403 in k18400 in k18397 in k18394 in k18391 in k18388 in k18385 in k18225 in k8543 */
static void C_fcall f_18669(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(6,0,2)))){
C_save_and_reclaim_args((void *)trf_18669,3,t0,t1,t2);}
a=C_alloc(6);
if(C_truep(C_i_pairp(t2))){
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_18694,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t1,a[5]=t2,tmp=(C_word)a,a+=6,tmp);
/* library.scm:3044: g3721 */
t4=((C_word*)t0)[4];{
C_word av2[3];
av2[0]=t4;
av2[1]=t3;
av2[2]=C_slot(t2,C_fix(0));
((C_proc)C_fast_retrieve_proc(t4))(3,av2);}}
else{
t3=t1;{
C_word av2[2];
av2[0]=t3;
av2[1]=C_slot(((C_word*)t0)[5],C_fix(1));
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}}

/* k18692 in map-loop3715 in scheme#map in k18424 in k18421 in k18418 in k18415 in k18412 in k18409 in k18406 in k18403 in k18400 in k18397 in k18394 in k18391 in k18388 in k18385 in k18225 in k8543 */
static void C_ccall f_18694(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,c,2)))){
C_save_and_reclaim((void *)f_18694,c,av);}
a=C_alloc(3);
t2=C_a_i_cons(&a,2,t1,C_SCHEME_END_OF_LIST);
t3=C_i_setslot(((C_word*)((C_word*)t0)[2])[1],C_fix(1),t2);
t4=C_mutate(((C_word *)((C_word*)t0)[2])+1,t2);
t5=((C_word*)((C_word*)t0)[3])[1];
f_18669(t5,((C_word*)t0)[4],C_slot(((C_word*)t0)[5],C_fix(1)));}

/* loop in scheme#map in k18424 in k18421 in k18418 in k18415 in k18412 in k18409 in k18406 in k18403 in k18400 in k18397 in k18394 in k18391 in k18388 in k18385 in k18225 in k8543 */
static void C_fcall f_18710(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(10,0,4)))){
C_save_and_reclaim_args((void *)trf_18710,3,t0,t1,t2);}
a=C_alloc(10);
t3=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_18717,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=t2,a[6]=((C_word*)t0)[4],tmp=(C_word)a,a+=7,tmp);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_18746,a[2]=((C_word)li530),tmp=(C_word)a,a+=3,tmp);
/* library.scm:3047: mapsafe */
t5=((C_word*)((C_word*)t0)[3])[1];{
C_word av2[5];
av2[0]=t5;
av2[1]=t3;
av2[2]=t4;
av2[3]=t2;
av2[4]=lf[689];
((C_proc)C_fast_retrieve_proc(t5))(5,av2);}}

/* k18715 in loop in scheme#map in k18424 in k18421 in k18418 in k18415 in k18412 in k18409 in k18406 in k18403 in k18400 in k18397 in k18394 in k18391 in k18388 in k18385 in k18225 in k8543 */
static void C_ccall f_18717(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(6,c,3)))){
C_save_and_reclaim((void *)f_18717,c,av);}
a=C_alloc(6);
if(C_truep(C_i_pairp(t1))){
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_18730,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],tmp=(C_word)a,a+=6,tmp);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=0;
av2[1]=t2;
av2[2]=((C_word*)t0)[6];
av2[3]=t1;
C_apply(4,av2);}}
else{
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_SCHEME_END_OF_LIST;
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}}

/* k18728 in k18715 in loop in scheme#map in k18424 in k18421 in k18418 in k18415 in k18412 in k18409 in k18406 in k18403 in k18400 in k18397 in k18394 in k18391 in k18388 in k18385 in k18225 in k8543 */
static void C_ccall f_18730(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(11,c,4)))){
C_save_and_reclaim((void *)f_18730,c,av);}
a=C_alloc(11);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_18734,a[2]=((C_word*)t0)[2],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_18738,a[2]=((C_word*)t0)[3],a[3]=t2,tmp=(C_word)a,a+=4,tmp);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_18740,a[2]=((C_word)li529),tmp=(C_word)a,a+=3,tmp);
/* library.scm:3050: mapsafe */
t5=((C_word*)((C_word*)t0)[4])[1];{
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=t5;
av2[1]=t3;
av2[2]=t4;
av2[3]=((C_word*)t0)[5];
av2[4]=lf[689];
((C_proc)C_fast_retrieve_proc(t5))(5,av2);}}

/* k18732 in k18728 in k18715 in loop in scheme#map in k18424 in k18421 in k18418 in k18415 in k18412 in k18409 in k18406 in k18403 in k18400 in k18397 in k18394 in k18391 in k18388 in k18385 in k18225 in k8543 */
static void C_ccall f_18734(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,c,1)))){
C_save_and_reclaim((void *)f_18734,c,av);}
a=C_alloc(3);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_a_i_cons(&a,2,((C_word*)t0)[3],t1);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* k18736 in k18728 in k18715 in loop in scheme#map in k18424 in k18421 in k18418 in k18415 in k18412 in k18409 in k18406 in k18403 in k18400 in k18397 in k18394 in k18391 in k18388 in k18385 in k18225 in k8543 */
static void C_ccall f_18738(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_18738,c,av);}
/* library.scm:3050: loop */
t2=((C_word*)((C_word*)t0)[2])[1];
f_18710(t2,((C_word*)t0)[3],t1);}

/* a18739 in k18728 in k18715 in loop in scheme#map in k18424 in k18421 in k18418 in k18415 in k18412 in k18409 in k18406 in k18403 in k18400 in k18397 in k18394 in k18391 in k18388 in k18385 in k18225 in k8543 */
static void C_ccall f_18740(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_18740,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_i_cdr(t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* a18745 in loop in scheme#map in k18424 in k18421 in k18418 in k18415 in k18412 in k18409 in k18406 in k18403 in k18400 in k18397 in k18394 in k18391 in k18388 in k18385 in k18225 in k8543 */
static void C_ccall f_18746(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_18746,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_i_car(t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* scheme#dynamic-wind in k18424 in k18421 in k18418 in k18415 in k18412 in k18409 in k18406 in k18403 in k18400 in k18397 in k18394 in k18391 in k18388 in k18385 in k18225 in k8543 */
static void C_ccall f_18753(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5;
C_word t6;
C_word *a;
if(c!=5) C_bad_argc_2(c,5,t0);
if(C_unlikely(!C_demand(C_calculate_demand(6,c,2)))){
C_save_and_reclaim((void *)f_18753,c,av);}
a=C_alloc(6);
t5=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_18757,a[2]=t2,a[3]=t4,a[4]=t1,a[5]=t3,tmp=(C_word)a,a+=6,tmp);
/* library.scm:3070: before */
t6=t2;{
C_word *av2=av;
av2[0]=t6;
av2[1]=t5;
((C_proc)C_fast_retrieve_proc(t6))(2,av2);}}

/* k18755 in scheme#dynamic-wind in k18424 in k18421 in k18418 in k18415 in k18412 in k18409 in k18406 in k18403 in k18400 in k18397 in k18394 in k18391 in k18388 in k18385 in k18225 in k8543 */
static void C_ccall f_18757(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(10,c,3)))){
C_save_and_reclaim((void *)f_18757,c,av);}
a=C_alloc(10);
t2=C_a_i_cons(&a,2,((C_word*)t0)[2],((C_word*)t0)[3]);
t3=C_a_i_cons(&a,2,t2,C_fast_retrieve(lf[690]));
t4=C_mutate((C_word*)lf[690]+1 /* (set! ##sys#dynamic-winds ...) */,t3);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_18766,a[2]=((C_word*)t0)[3],a[3]=((C_word)li533),tmp=(C_word)a,a+=4,tmp);
/* library.scm:3072: ##sys#call-with-values */{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=0;
av2[1]=((C_word*)t0)[4];
av2[2]=((C_word*)t0)[5];
av2[3]=t5;
C_call_with_values(4,av2);}}

/* a18765 in k18755 in scheme#dynamic-wind in k18424 in k18421 in k18418 in k18415 in k18412 in k18409 in k18406 in k18403 in k18400 in k18397 in k18394 in k18391 in k18388 in k18385 in k18225 in k8543 */
static void C_ccall f_18766(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand((c-2)*C_SIZEOF_PAIR +4,c,2)))){
C_save_and_reclaim((void*)f_18766,c,av);}
a=C_alloc((c-2)*C_SIZEOF_PAIR+4);
t2=C_build_rest(&a,c,2,av);
C_word t3;
C_word t4;
C_word t5;
C_word t6;
t3=C_slot(C_fast_retrieve(lf[690]),C_fix(1));
t4=C_mutate((C_word*)lf[690]+1 /* (set! ##sys#dynamic-winds ...) */,t3);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_18774,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* library.scm:3076: after */
t6=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t6;
av2[1]=t5;
((C_proc)C_fast_retrieve_proc(t6))(2,av2);}}

/* k18772 in a18765 in k18755 in scheme#dynamic-wind in k18424 in k18421 in k18418 in k18415 in k18412 in k18409 in k18406 in k18403 in k18400 in k18397 in k18394 in k18391 in k18388 in k18385 in k18225 in k8543 */
static void C_ccall f_18774(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_18774,c,av);}{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=0;
av2[1]=((C_word*)t0)[2];
av2[2]=((C_word*)t0)[3];
C_apply_values(3,av2);}}

/* scheme#call-with-current-continuation in k18424 in k18421 in k18418 in k18415 in k18412 in k18409 in k18406 in k18403 in k18400 in k18397 in k18394 in k18391 in k18388 in k18385 in k18225 in k8543 */
static void C_ccall f_18784(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(5,c,3)))){
C_save_and_reclaim((void *)f_18784,c,av);}
a=C_alloc(5);
t3=C_fast_retrieve(lf[690]);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_18790,a[2]=t3,a[3]=t2,a[4]=((C_word)li536),tmp=(C_word)a,a+=5,tmp);
/* library.scm:3084: ##sys#call-with-current-continuation */{
C_word *av2=av;
av2[0]=0;
av2[1]=t1;
av2[2]=t4;
C_call_cc(3,av2);}}

/* a18789 in scheme#call-with-current-continuation in k18424 in k18421 in k18418 in k18415 in k18412 in k18409 in k18406 in k18403 in k18400 in k18397 in k18394 in k18391 in k18388 in k18385 in k18225 in k8543 */
static void C_ccall f_18790(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(5,c,2)))){
C_save_and_reclaim((void *)f_18790,c,av);}
a=C_alloc(5);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_18793,a[2]=t2,a[3]=((C_word*)t0)[2],a[4]=((C_word)li535),tmp=(C_word)a,a+=5,tmp);
/* library.scm:3090: proc */
t4=((C_word*)t0)[3];{
C_word *av2=av;
av2[0]=t4;
av2[1]=t1;
av2[2]=t3;
((C_proc)C_fast_retrieve_proc(t4))(3,av2);}}

/* continuation in a18789 in scheme#call-with-current-continuation in k18424 in k18421 in k18418 in k18415 in k18412 in k18409 in k18406 in k18403 in k18400 in k18397 in k18394 in k18391 in k18388 in k18385 in k18225 in k8543 */
static void C_ccall f_18793(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand((c-2)*C_SIZEOF_PAIR +5,c,3)))){
C_save_and_reclaim((void*)f_18793,c,av);}
a=C_alloc((c-2)*C_SIZEOF_PAIR+5);
t2=C_build_rest(&a,c,2,av);
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_18797,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=t2,tmp=(C_word)a,a+=5,tmp);
t4=C_eqp(C_fast_retrieve(lf[690]),((C_word*)t0)[3]);
if(C_truep(t4)){{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=0;
av2[1]=t1;
av2[2]=((C_word*)t0)[2];
av2[3]=t2;
C_apply(4,av2);}}
else{
t5=C_i_length(C_fast_retrieve(lf[690]));
t6=C_i_length(((C_word*)t0)[3]);
/* library.scm:3088: ##sys#dynamic-unwind */
f_18824(t3,((C_word*)t0)[3],C_fixnum_difference(t5,t6));}}

/* k18795 in continuation in a18789 in scheme#call-with-current-continuation in k18424 in k18421 in k18418 in k18415 in k18412 in k18409 in k18406 in k18403 in k18400 in k18397 in k18394 in k18391 in k18388 in k18385 in k18225 in k8543 */
static void C_ccall f_18797(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_18797,c,av);}{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=0;
av2[1]=((C_word*)t0)[2];
av2[2]=((C_word*)t0)[3];
av2[3]=((C_word*)t0)[4];
C_apply(4,av2);}}

/* ##sys#dynamic-unwind in k18424 in k18421 in k18418 in k18415 in k18412 in k18409 in k18406 in k18403 in k18400 in k18397 in k18394 in k18391 in k18388 in k18385 in k18225 in k8543 */
static void C_fcall f_18824(C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word *a;
loop:
if(C_unlikely(!C_demand(C_calculate_demand(5,0,3)))){
C_save_and_reclaim_args((void *)trf_18824,3,t1,t2,t3);}
a=C_alloc(5);
t4=C_eqp(C_fast_retrieve(lf[690]),t2);
if(C_truep(t4)){
t5=t1;{
C_word av2[2];
av2[0]=t5;
av2[1]=t4;
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}
else{
if(C_truep(C_fixnum_lessp(t3,C_fix(0)))){
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_18840,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* library.scm:3097: ##sys#dynamic-unwind */
t11=t5;
t12=C_slot(t2,C_fix(1));
t13=C_fixnum_plus(t3,C_fix(1));
t1=t11;
t2=t12;
t3=t13;
goto loop;}
else{
t5=C_slot(C_fast_retrieve(lf[690]),C_fix(0));
t6=C_slot(t5,C_fix(1));
t7=C_slot(C_fast_retrieve(lf[690]),C_fix(1));
t8=C_mutate((C_word*)lf[690]+1 /* (set! ##sys#dynamic-winds ...) */,t7);
t9=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_18869,a[2]=t1,a[3]=t2,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
/* library.scm:3103: after */
t10=t6;{
C_word av2[2];
av2[0]=t10;
av2[1]=t9;
((C_proc)C_fast_retrieve_proc(t10))(2,av2);}}}}

/* k18838 in ##sys#dynamic-unwind in k18424 in k18421 in k18418 in k18415 in k18412 in k18409 in k18406 in k18403 in k18400 in k18397 in k18394 in k18391 in k18388 in k18385 in k18225 in k8543 */
static void C_ccall f_18840(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,2)))){
C_save_and_reclaim((void *)f_18840,c,av);}
a=C_alloc(4);
t2=C_slot(((C_word*)t0)[2],C_fix(0));
t3=C_slot(t2,C_fix(0));
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_18846,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* library.scm:3095: g3775 */
t5=t3;{
C_word *av2=av;
av2[0]=t5;
av2[1]=t4;
((C_proc)C_fast_retrieve_proc(t5))(2,av2);}}

/* k18844 in k18838 in ##sys#dynamic-unwind in k18424 in k18421 in k18418 in k18415 in k18412 in k18409 in k18406 in k18403 in k18400 in k18397 in k18394 in k18391 in k18388 in k18385 in k18225 in k8543 */
static void C_ccall f_18846(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_18846,c,av);}
t2=C_mutate((C_word*)lf[690]+1 /* (set! ##sys#dynamic-winds ...) */,((C_word*)t0)[2]);
t3=((C_word*)t0)[3];{
C_word *av2=av;
av2[0]=t3;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* k18867 in ##sys#dynamic-unwind in k18424 in k18421 in k18418 in k18415 in k18412 in k18409 in k18406 in k18403 in k18400 in k18397 in k18394 in k18391 in k18388 in k18385 in k18225 in k8543 */
static void C_ccall f_18869(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_18869,c,av);}
/* library.scm:3104: ##sys#dynamic-unwind */
f_18824(((C_word*)t0)[2],((C_word*)t0)[3],C_fixnum_difference(((C_word*)t0)[4],C_fix(1)));}

/* chicken.base#port? in k18424 in k18421 in k18418 in k18415 in k18412 in k18409 in k18406 in k18403 in k18400 in k18397 in k18394 in k18391 in k18388 in k18385 in k18225 in k8543 */
static void C_ccall f_18882(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_18882,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=(C_truep(C_blockp(t2))?C_portp(t2):C_SCHEME_FALSE);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* chicken.base#input-port-open? in k18424 in k18421 in k18418 in k18415 in k18412 in k18409 in k18406 in k18403 in k18400 in k18397 in k18394 in k18391 in k18388 in k18385 in k18225 in k8543 */
static void C_ccall f_18888(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_18888,c,av);}
t3=C_i_check_port(t2,C_fix(1),lf[693]);
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_input_port_openp(t2);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* chicken.base#output-port-open? in k18424 in k18421 in k18418 in k18415 in k18412 in k18409 in k18406 in k18403 in k18400 in k18397 in k18394 in k18391 in k18388 in k18385 in k18225 in k8543 */
static void C_ccall f_18893(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_18893,c,av);}
t3=C_i_check_port(t2,C_fix(2),lf[694]);
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_output_port_openp(t2);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* chicken.base#port-closed? in k18424 in k18421 in k18418 in k18415 in k18412 in k18409 in k18406 in k18403 in k18400 in k18397 in k18394 in k18391 in k18388 in k18385 in k18225 in k8543 */
static void C_ccall f_18898(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(4,c,3)))){
C_save_and_reclaim((void *)f_18898,c,av);}
a=C_alloc(4);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_18902,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* library.scm:3126: ##sys#check-port */
t4=*((C_word*)lf[695]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t4;
av2[1]=t3;
av2[2]=t2;
av2[3]=lf[696];
((C_proc)(void*)(*((C_word*)t4+1)))(4,av2);}}

/* k18900 in chicken.base#port-closed? in k18424 in k18421 in k18418 in k18415 in k18412 in k18409 in k18406 in k18403 in k18400 in k18397 in k18394 in k18391 in k18388 in k18385 in k18225 in k8543 */
static void C_ccall f_18902(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_18902,c,av);}
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_eqp(C_slot(((C_word*)t0)[3],C_fix(8)),C_fix(0));
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* ##sys#make-port in k18424 in k18421 in k18418 in k18415 in k18412 in k18409 in k18406 in k18403 in k18400 in k18397 in k18394 in k18391 in k18388 in k18385 in k18225 in k8543 */
static void C_ccall f_18911(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5=av[5];
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word *a;
if(c!=6) C_bad_argc_2(c,6,t0);
if(C_unlikely(!C_demand(C_calculate_demand(17,c,1)))){
C_save_and_reclaim((void *)f_18911,c,av);}
a=C_alloc(17);
t6=C_a_i_port(&a,0);
t7=C_i_set_i_slot(t6,C_fix(1),t2);
t8=C_i_setslot(t6,C_fix(2),t3);
t9=C_i_setslot(t6,C_fix(3),t4);
t10=C_i_set_i_slot(t6,C_fix(4),C_fix(1));
t11=C_i_set_i_slot(t6,C_fix(5),C_fix(0));
t12=C_i_setslot(t6,C_fix(7),t5);
t13=C_i_setslot(t6,C_fix(8),t2);
t14=t1;{
C_word *av2=av;
av2[0]=t14;
av2[1]=t6;
((C_proc)(void*)(*((C_word*)t14+1)))(2,av2);}}

/* k18940 in k18424 in k18421 in k18418 in k18415 in k18412 in k18409 in k18406 in k18403 in k18400 in k18397 in k18394 in k18391 in k18388 in k18385 in k18225 in k8543 */
static void C_ccall f_18942(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,c,5)))){
C_save_and_reclaim((void *)f_18942,c,av);}
a=C_alloc(3);
t2=C_mutate((C_word*)lf[713]+1 /* (set! ##sys#standard-input ...) */,t1);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_18946,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
/* library.scm:3272: ##sys#make-port */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[697]);
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=*((C_word*)lf[697]+1);
av2[1]=t3;
av2[2]=C_fix(2);
av2[3]=C_fast_retrieve(lf[711]);
av2[4]=lf[1388];
av2[5]=lf[730];
tp(6,av2);}}

/* k18944 in k18940 in k18424 in k18421 in k18418 in k18415 in k18412 in k18409 in k18406 in k18403 in k18400 in k18397 in k18394 in k18391 in k18388 in k18385 in k18225 in k8543 */
static void C_ccall f_18946(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,c,5)))){
C_save_and_reclaim((void *)f_18946,c,av);}
a=C_alloc(3);
t2=C_mutate((C_word*)lf[714]+1 /* (set! ##sys#standard-output ...) */,t1);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_18950,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
/* library.scm:3273: ##sys#make-port */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[697]);
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=*((C_word*)lf[697]+1);
av2[1]=t3;
av2[2]=C_fix(2);
av2[3]=C_fast_retrieve(lf[711]);
av2[4]=lf[1387];
av2[5]=lf[730];
tp(6,av2);}}

/* k18948 in k18944 in k18940 in k18424 in k18421 in k18418 in k18415 in k18412 in k18409 in k18406 in k18403 in k18400 in k18397 in k18394 in k18391 in k18388 in k18385 in k18225 in k8543 */
static void C_ccall f_18950(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,c,4)))){
C_save_and_reclaim((void *)f_18950,c,av);}
a=C_alloc(3);
t2=C_mutate((C_word*)lf[715]+1 /* (set! ##sys#standard-error ...) */,t1);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_18953,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
/* library.scm:3275: ##sys#open-file-port */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[712]);
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=*((C_word*)lf[712]+1);
av2[1]=t3;
av2[2]=*((C_word*)lf[713]+1);
av2[3]=C_fix(0);
av2[4]=C_SCHEME_FALSE;
tp(5,av2);}}

/* k18951 in k18948 in k18944 in k18940 in k18424 in k18421 in k18418 in k18415 in k18412 in k18409 in k18406 in k18403 in k18400 in k18397 in k18394 in k18391 in k18388 in k18385 in k18225 in k8543 */
static void C_ccall f_18953(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,c,4)))){
C_save_and_reclaim((void *)f_18953,c,av);}
a=C_alloc(3);
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_18956,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
/* library.scm:3276: ##sys#open-file-port */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[712]);
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=*((C_word*)lf[712]+1);
av2[1]=t2;
av2[2]=*((C_word*)lf[714]+1);
av2[3]=C_fix(1);
av2[4]=C_SCHEME_FALSE;
tp(5,av2);}}

/* k18954 in k18951 in k18948 in k18944 in k18940 in k18424 in k18421 in k18418 in k18415 in k18412 in k18409 in k18406 in k18403 in k18400 in k18397 in k18394 in k18391 in k18388 in k18385 in k18225 in k8543 */
static void C_ccall f_18956(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,c,4)))){
C_save_and_reclaim((void *)f_18956,c,av);}
a=C_alloc(3);
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_18959,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
/* library.scm:3277: ##sys#open-file-port */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[712]);
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=*((C_word*)lf[712]+1);
av2[1]=t2;
av2[2]=*((C_word*)lf[715]+1);
av2[3]=C_fix(2);
av2[4]=C_SCHEME_FALSE;
tp(5,av2);}}

/* k18957 in k18954 in k18951 in k18948 in k18944 in k18940 in k18424 in k18421 in k18418 in k18415 in k18412 in k18409 in k18406 in k18403 in k18400 in k18397 in k18394 in k18391 in k18388 in k18385 in k18225 in k8543 in ... */
static void C_ccall f_18959(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word t19;
C_word t20;
C_word t21;
C_word t22;
C_word t23;
C_word t24;
C_word t25;
C_word t26;
C_word t27;
C_word t28;
C_word t29;
C_word t30;
C_word t31;
C_word t32;
C_word t33;
C_word t34;
C_word t35;
C_word t36;
C_word t37;
C_word t38;
C_word t39;
C_word t40;
C_word t41;
C_word t42;
C_word t43;
C_word t44;
C_word t45;
C_word t46;
C_word t47;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(119,c,6)))){
C_save_and_reclaim((void *)f_18959,c,av);}
a=C_alloc(119);
t2=C_mutate((C_word*)lf[716]+1 /* (set! ##sys#check-input-port ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_18961,a[2]=((C_word)li560),tmp=(C_word)a,a+=3,tmp));
t3=C_mutate((C_word*)lf[717]+1 /* (set! ##sys#check-output-port ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_18972,a[2]=((C_word)li561),tmp=(C_word)a,a+=3,tmp));
t4=C_mutate((C_word*)lf[695]+1 /* (set! ##sys#check-port ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_18983,a[2]=((C_word)li562),tmp=(C_word)a,a+=3,tmp));
t5=C_mutate((C_word*)lf[718]+1 /* (set! ##sys#check-open-port ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_18994,a[2]=((C_word)li563),tmp=(C_word)a,a+=3,tmp));
t6=C_mutate((C_word*)lf[135]+1 /* (set! scheme#current-input-port ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_19005,a[2]=((C_word)li565),tmp=(C_word)a,a+=3,tmp));
t7=C_mutate((C_word*)lf[136]+1 /* (set! scheme#current-output-port ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_19066,a[2]=((C_word)li567),tmp=(C_word)a,a+=3,tmp));
t8=C_mutate((C_word*)lf[192]+1 /* (set! chicken.base#current-error-port ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_19127,a[2]=((C_word)li569),tmp=(C_word)a,a+=3,tmp));
t9=C_mutate((C_word*)lf[722]+1 /* (set! ##sys#tty-port? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_19188,a[2]=((C_word)li570),tmp=(C_word)a,a+=3,tmp));
t10=C_mutate((C_word*)lf[724]+1 /* (set! ##sys#port-data ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_19202,a[2]=((C_word)li571),tmp=(C_word)a,a+=3,tmp));
t11=C_mutate((C_word*)lf[725]+1 /* (set! ##sys#set-port-data! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_19208,a[2]=((C_word)li572),tmp=(C_word)a,a+=3,tmp));
t12=C_SCHEME_UNDEFINED;
t13=(*a=C_VECTOR_TYPE|1,a[1]=t12,tmp=(C_word)a,a+=2,tmp);
t14=C_SCHEME_UNDEFINED;
t15=(*a=C_VECTOR_TYPE|1,a[1]=t14,tmp=(C_word)a,a+=2,tmp);
t16=C_set_block_item(t13,0,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_19214,a[2]=((C_word)li574),tmp=(C_word)a,a+=3,tmp));
t17=C_set_block_item(t15,0,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_19312,a[2]=((C_word)li575),tmp=(C_word)a,a+=3,tmp));
t18=C_mutate((C_word*)lf[137]+1 /* (set! scheme#open-input-file ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_19349,a[2]=t13,a[3]=((C_word)li576),tmp=(C_word)a,a+=4,tmp));
t19=C_mutate((C_word*)lf[138]+1 /* (set! scheme#open-output-file ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_19355,a[2]=t13,a[3]=((C_word)li577),tmp=(C_word)a,a+=4,tmp));
t20=C_mutate((C_word*)lf[139]+1 /* (set! scheme#close-input-port ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_19361,a[2]=t15,a[3]=((C_word)li578),tmp=(C_word)a,a+=4,tmp));
t21=C_mutate((C_word*)lf[140]+1 /* (set! scheme#close-output-port ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_19367,a[2]=t15,a[3]=((C_word)li579),tmp=(C_word)a,a+=4,tmp));
t22=*((C_word*)lf[137]+1);
t23=C_mutate((C_word*)lf[141]+1 /* (set! scheme#call-with-input-file ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_19373,a[2]=t22,a[3]=((C_word)li582),tmp=(C_word)a,a+=4,tmp));
t24=*((C_word*)lf[138]+1);
t25=C_mutate((C_word*)lf[142]+1 /* (set! scheme#call-with-output-file ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_19397,a[2]=t24,a[3]=((C_word)li585),tmp=(C_word)a,a+=4,tmp));
t26=*((C_word*)lf[137]+1);
t27=C_mutate((C_word*)lf[143]+1 /* (set! scheme#with-input-from-file ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_19421,a[2]=t26,a[3]=((C_word)li590),tmp=(C_word)a,a+=4,tmp));
t28=*((C_word*)lf[138]+1);
t29=C_mutate((C_word*)lf[144]+1 /* (set! scheme#with-output-to-file ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_19455,a[2]=t28,a[3]=((C_word)li595),tmp=(C_word)a,a+=4,tmp));
t30=C_mutate((C_word*)lf[743]+1 /* (set! ##sys#file-exists? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_19489,a[2]=((C_word)li596),tmp=(C_word)a,a+=3,tmp));
t31=C_mutate((C_word*)lf[746]+1 /* (set! ##sys#flush-output ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_19515,a[2]=((C_word)li597),tmp=(C_word)a,a+=3,tmp));
t32=C_mutate((C_word*)lf[216]+1 /* (set! chicken.base#flush-output ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_19528,a[2]=((C_word)li598),tmp=(C_word)a,a+=3,tmp));
t33=C_mutate((C_word*)lf[748]+1 /* (set! ##sys#port-line ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_19546,a[2]=((C_word)li599),tmp=(C_word)a,a+=3,tmp));
t34=C_mutate((C_word*)lf[749]+1 /* (set! ##sys#decorate-lambda ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_19555,a[2]=((C_word)li602),tmp=(C_word)a,a+=3,tmp));
t35=C_mutate((C_word*)lf[750]+1 /* (set! ##sys#lambda-decoration ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_19630,a[2]=((C_word)li604),tmp=(C_word)a,a+=3,tmp));
t36=C_mutate((C_word*)lf[751]+1 /* (set! ##sys#make-lambda-info ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_19669,a[2]=((C_word)li605),tmp=(C_word)a,a+=3,tmp));
t37=C_mutate((C_word*)lf[752]+1 /* (set! ##sys#lambda-info? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_19678,a[2]=((C_word)li606),tmp=(C_word)a,a+=3,tmp));
t38=C_mutate((C_word*)lf[753]+1 /* (set! ##sys#lambda-info ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_19691,a[2]=((C_word)li607),tmp=(C_word)a,a+=3,tmp));
t39=C_mutate((C_word*)lf[754]+1 /* (set! ##sys#lambda-info->string ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_19697,a[2]=((C_word)li608),tmp=(C_word)a,a+=3,tmp));
t40=C_mutate((C_word*)lf[202]+1 /* (set! chicken.base#procedure-information ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_19706,a[2]=((C_word)li609),tmp=(C_word)a,a+=3,tmp));
t41=C_a_i_vector1(&a,1,lf[757]);
t42=C_mutate(&lf[758] /* (set! setter-tag ...) */,t41);
t43=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_19735,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t44=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_31953,a[2]=((C_word)li1001),tmp=(C_word)a,a+=3,tmp);
t45=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_31993,a[2]=((C_word)li1002),tmp=(C_word)a,a+=3,tmp);
t46=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_32009,a[2]=((C_word)li1006),tmp=(C_word)a,a+=3,tmp);
/* library.scm:3506: ##sys#decorate-lambda */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[749]);
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=*((C_word*)lf[749]+1);
av2[1]=t43;
av2[2]=t44;
av2[3]=t45;
av2[4]=t46;
tp(5,av2);}}

/* ##sys#check-input-port in k18957 in k18954 in k18951 in k18948 in k18944 in k18940 in k18424 in k18421 in k18418 in k18415 in k18412 in k18409 in k18406 in k18403 in k18400 in k18397 in k18394 in k18391 in k18388 in k18385 in k18225 in ... */
static void C_ccall f_18961(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c<4) C_bad_min_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-4)*C_SIZEOF_PAIR +0,c,1)))){
C_save_and_reclaim((void*)f_18961,c,av);}
a=C_alloc((c-4)*C_SIZEOF_PAIR+0);
t4=C_build_rest(&a,c,4,av);
C_word t5;
C_word t6;
t5=C_i_pairp(t4);
t6=t1;{
C_word *av2=av;
av2[0]=t6;
av2[1]=(C_truep(t5)?C_i_check_port_2(t2,C_fix(1),t3,C_get_rest_arg(c,4,av,4,t0)):C_i_check_port(t2,C_fix(1),t3));
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}

/* ##sys#check-output-port in k18957 in k18954 in k18951 in k18948 in k18944 in k18940 in k18424 in k18421 in k18418 in k18415 in k18412 in k18409 in k18406 in k18403 in k18400 in k18397 in k18394 in k18391 in k18388 in k18385 in k18225 in ... */
static void C_ccall f_18972(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c<4) C_bad_min_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-4)*C_SIZEOF_PAIR +0,c,1)))){
C_save_and_reclaim((void*)f_18972,c,av);}
a=C_alloc((c-4)*C_SIZEOF_PAIR+0);
t4=C_build_rest(&a,c,4,av);
C_word t5;
C_word t6;
t5=C_i_pairp(t4);
t6=t1;{
C_word *av2=av;
av2[0]=t6;
av2[1]=(C_truep(t5)?C_i_check_port_2(t2,C_fix(2),t3,C_get_rest_arg(c,4,av,4,t0)):C_i_check_port(t2,C_fix(2),t3));
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}

/* ##sys#check-port in k18957 in k18954 in k18951 in k18948 in k18944 in k18940 in k18424 in k18421 in k18418 in k18415 in k18412 in k18409 in k18406 in k18403 in k18400 in k18397 in k18394 in k18391 in k18388 in k18385 in k18225 in ... */
static void C_ccall f_18983(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +0,c,1)))){
C_save_and_reclaim((void*)f_18983,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+0);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
t4=C_i_pairp(t3);
t5=t1;{
C_word *av2=av;
av2[0]=t5;
av2[1]=(C_truep(t4)?C_i_check_port_2(t2,C_fix(0),C_SCHEME_FALSE,C_get_rest_arg(c,3,av,3,t0)):C_i_check_port(t2,C_fix(0),C_SCHEME_FALSE));
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}

/* ##sys#check-open-port in k18957 in k18954 in k18951 in k18948 in k18944 in k18940 in k18424 in k18421 in k18418 in k18415 in k18412 in k18409 in k18406 in k18403 in k18400 in k18397 in k18394 in k18391 in k18388 in k18385 in k18225 in ... */
static void C_ccall f_18994(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +0,c,1)))){
C_save_and_reclaim((void*)f_18994,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+0);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
t4=C_i_pairp(t3);
t5=t1;{
C_word *av2=av;
av2[0]=t5;
av2[1]=(C_truep(t4)?C_i_check_port_2(t2,C_fix(0),C_SCHEME_TRUE,C_get_rest_arg(c,3,av,3,t0)):C_i_check_port(t2,C_fix(0),C_SCHEME_TRUE));
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}

/* scheme#current-input-port in k18957 in k18954 in k18951 in k18948 in k18944 in k18940 in k18424 in k18421 in k18418 in k18415 in k18412 in k18409 in k18406 in k18403 in k18400 in k18397 in k18394 in k18391 in k18388 in k18385 in k18225 in ... */
static void C_ccall f_19005(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand((c-2)*C_SIZEOF_PAIR +5,c,3)))){
C_save_and_reclaim((void*)f_19005,c,av);}
a=C_alloc((c-2)*C_SIZEOF_PAIR+5);
t2=C_build_rest(&a,c,2,av);
C_word t3;
C_word t4;
C_word t5;
if(C_truep(C_i_nullp(t2))){
t3=*((C_word*)lf[713]+1);
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=*((C_word*)lf[713]+1);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t3=C_i_car(t2);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_19018,a[2]=t2,a[3]=t3,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
/* library.scm:3304: ##sys#check-port */
t5=*((C_word*)lf[695]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t5;
av2[1]=t4;
av2[2]=t3;
av2[3]=lf[719];
((C_proc)(void*)(*((C_word*)t5+1)))(4,av2);}}}

/* k19016 in scheme#current-input-port in k18957 in k18954 in k18951 in k18948 in k18944 in k18940 in k18424 in k18421 in k18418 in k18415 in k18412 in k18409 in k18406 in k18403 in k18400 in k18397 in k18394 in k18391 in k18388 in k18385 in ... */
static void C_ccall f_19018(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(10,c,2)))){
C_save_and_reclaim((void *)f_19018,c,av);}
a=C_alloc(10);
t2=C_u_i_cdr(((C_word*)t0)[2]);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_19020,a[2]=((C_word*)t0)[3],a[3]=((C_word)li564),tmp=(C_word)a,a+=4,tmp);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_19026,a[2]=t3,tmp=(C_word)a,a+=3,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_19031,a[2]=t4,tmp=(C_word)a,a+=3,tmp);
if(C_truep(C_i_nullp(t2))){
t6=(
/* library.scm:3305: def-convert?3897 */
  f_19031(t5)
);
t7=((C_word*)t0)[4];{
C_word *av2=av;
av2[0]=t7;
av2[1]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}
else{
t6=C_i_car(t2);
t7=C_u_i_cdr(t2);
if(C_truep(C_i_nullp(t7))){
t8=(
/* library.scm:3305: def-set?3898 */
  f_19026(t4)
);
t9=((C_word*)t0)[4];{
C_word *av2=av;
av2[0]=t9;
av2[1]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t9+1)))(2,av2);}}
else{
t8=C_i_car(t7);
t9=C_u_i_cdr(t7);
t10=(
/* library.scm:3305: body3895 */
  f_19020(t3,t8)
);
t11=((C_word*)t0)[4];{
C_word *av2=av;
av2[0]=t11;
av2[1]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t11+1)))(2,av2);}}}}

/* body3895 in k19016 in scheme#current-input-port in k18957 in k18954 in k18951 in k18948 in k18944 in k18940 in k18424 in k18421 in k18418 in k18415 in k18412 in k18409 in k18406 in k18403 in k18400 in k18397 in k18394 in k18391 in k18388 in ... */
static C_word C_fcall f_19020(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_stack_overflow_check;{}
if(C_truep(t1)){
t2=C_mutate((C_word*)lf[713]+1 /* (set! ##sys#standard-input ...) */,((C_word*)t0)[2]);
return(t2);}
else{
t2=C_SCHEME_UNDEFINED;
return(t2);}}

/* def-set?3898 in k19016 in scheme#current-input-port in k18957 in k18954 in k18951 in k18948 in k18944 in k18940 in k18424 in k18421 in k18418 in k18415 in k18412 in k18409 in k18406 in k18403 in k18400 in k18397 in k18394 in k18391 in k18388 in ... */
static C_word C_fcall f_19026(C_word t0){
C_word tmp;
C_word t1;
C_stack_overflow_check;{}
return((
/* library.scm:3305: body3895 */
  f_19020(((C_word*)t0)[2],C_SCHEME_TRUE)
));}

/* def-convert?3897 in k19016 in scheme#current-input-port in k18957 in k18954 in k18951 in k18948 in k18944 in k18940 in k18424 in k18421 in k18418 in k18415 in k18412 in k18409 in k18406 in k18403 in k18400 in k18397 in k18394 in k18391 in k18388 in ... */
static C_word C_fcall f_19031(C_word t0){
C_word tmp;
C_word t1;
C_stack_overflow_check;{}
return((
/* library.scm:3305: def-set?3898 */
  f_19026(((C_word*)t0)[2])
));}

/* scheme#current-output-port in k18957 in k18954 in k18951 in k18948 in k18944 in k18940 in k18424 in k18421 in k18418 in k18415 in k18412 in k18409 in k18406 in k18403 in k18400 in k18397 in k18394 in k18391 in k18388 in k18385 in k18225 in ... */
static void C_ccall f_19066(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand((c-2)*C_SIZEOF_PAIR +5,c,3)))){
C_save_and_reclaim((void*)f_19066,c,av);}
a=C_alloc((c-2)*C_SIZEOF_PAIR+5);
t2=C_build_rest(&a,c,2,av);
C_word t3;
C_word t4;
C_word t5;
if(C_truep(C_i_nullp(t2))){
t3=*((C_word*)lf[714]+1);
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=*((C_word*)lf[714]+1);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t3=C_i_car(t2);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_19079,a[2]=t2,a[3]=t3,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
/* library.scm:3314: ##sys#check-port */
t5=*((C_word*)lf[695]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t5;
av2[1]=t4;
av2[2]=t3;
av2[3]=lf[720];
((C_proc)(void*)(*((C_word*)t5+1)))(4,av2);}}}

/* k19077 in scheme#current-output-port in k18957 in k18954 in k18951 in k18948 in k18944 in k18940 in k18424 in k18421 in k18418 in k18415 in k18412 in k18409 in k18406 in k18403 in k18400 in k18397 in k18394 in k18391 in k18388 in k18385 in ... */
static void C_ccall f_19079(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(10,c,2)))){
C_save_and_reclaim((void *)f_19079,c,av);}
a=C_alloc(10);
t2=C_u_i_cdr(((C_word*)t0)[2]);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_19081,a[2]=((C_word*)t0)[3],a[3]=((C_word)li566),tmp=(C_word)a,a+=4,tmp);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_19087,a[2]=t3,tmp=(C_word)a,a+=3,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_19092,a[2]=t4,tmp=(C_word)a,a+=3,tmp);
if(C_truep(C_i_nullp(t2))){
t6=(
/* library.scm:3315: def-convert?3922 */
  f_19092(t5)
);
t7=((C_word*)t0)[4];{
C_word *av2=av;
av2[0]=t7;
av2[1]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}
else{
t6=C_i_car(t2);
t7=C_u_i_cdr(t2);
if(C_truep(C_i_nullp(t7))){
t8=(
/* library.scm:3315: def-set?3923 */
  f_19087(t4)
);
t9=((C_word*)t0)[4];{
C_word *av2=av;
av2[0]=t9;
av2[1]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t9+1)))(2,av2);}}
else{
t8=C_i_car(t7);
t9=C_u_i_cdr(t7);
t10=(
/* library.scm:3315: body3920 */
  f_19081(t3,t8)
);
t11=((C_word*)t0)[4];{
C_word *av2=av;
av2[0]=t11;
av2[1]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t11+1)))(2,av2);}}}}

/* body3920 in k19077 in scheme#current-output-port in k18957 in k18954 in k18951 in k18948 in k18944 in k18940 in k18424 in k18421 in k18418 in k18415 in k18412 in k18409 in k18406 in k18403 in k18400 in k18397 in k18394 in k18391 in k18388 in ... */
static C_word C_fcall f_19081(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_stack_overflow_check;{}
if(C_truep(t1)){
t2=C_mutate((C_word*)lf[714]+1 /* (set! ##sys#standard-output ...) */,((C_word*)t0)[2]);
return(t2);}
else{
t2=C_SCHEME_UNDEFINED;
return(t2);}}

/* def-set?3923 in k19077 in scheme#current-output-port in k18957 in k18954 in k18951 in k18948 in k18944 in k18940 in k18424 in k18421 in k18418 in k18415 in k18412 in k18409 in k18406 in k18403 in k18400 in k18397 in k18394 in k18391 in k18388 in ... */
static C_word C_fcall f_19087(C_word t0){
C_word tmp;
C_word t1;
C_stack_overflow_check;{}
return((
/* library.scm:3315: body3920 */
  f_19081(((C_word*)t0)[2],C_SCHEME_TRUE)
));}

/* def-convert?3922 in k19077 in scheme#current-output-port in k18957 in k18954 in k18951 in k18948 in k18944 in k18940 in k18424 in k18421 in k18418 in k18415 in k18412 in k18409 in k18406 in k18403 in k18400 in k18397 in k18394 in k18391 in k18388 in ... */
static C_word C_fcall f_19092(C_word t0){
C_word tmp;
C_word t1;
C_stack_overflow_check;{}
return((
/* library.scm:3315: def-set?3923 */
  f_19087(((C_word*)t0)[2])
));}

/* chicken.base#current-error-port in k18957 in k18954 in k18951 in k18948 in k18944 in k18940 in k18424 in k18421 in k18418 in k18415 in k18412 in k18409 in k18406 in k18403 in k18400 in k18397 in k18394 in k18391 in k18388 in k18385 in k18225 in ... */
static void C_ccall f_19127(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand((c-2)*C_SIZEOF_PAIR +5,c,3)))){
C_save_and_reclaim((void*)f_19127,c,av);}
a=C_alloc((c-2)*C_SIZEOF_PAIR+5);
t2=C_build_rest(&a,c,2,av);
C_word t3;
C_word t4;
C_word t5;
if(C_truep(C_i_nullp(t2))){
t3=*((C_word*)lf[715]+1);
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=*((C_word*)lf[715]+1);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t3=C_i_car(t2);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_19140,a[2]=t2,a[3]=t3,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
/* library.scm:3324: ##sys#check-port */
t5=*((C_word*)lf[695]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t5;
av2[1]=t4;
av2[2]=t3;
av2[3]=lf[721];
((C_proc)(void*)(*((C_word*)t5+1)))(4,av2);}}}

/* k19138 in chicken.base#current-error-port in k18957 in k18954 in k18951 in k18948 in k18944 in k18940 in k18424 in k18421 in k18418 in k18415 in k18412 in k18409 in k18406 in k18403 in k18400 in k18397 in k18394 in k18391 in k18388 in k18385 in ... */
static void C_ccall f_19140(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(10,c,2)))){
C_save_and_reclaim((void *)f_19140,c,av);}
a=C_alloc(10);
t2=C_u_i_cdr(((C_word*)t0)[2]);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_19142,a[2]=((C_word*)t0)[3],a[3]=((C_word)li568),tmp=(C_word)a,a+=4,tmp);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_19148,a[2]=t3,tmp=(C_word)a,a+=3,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_19153,a[2]=t4,tmp=(C_word)a,a+=3,tmp);
if(C_truep(C_i_nullp(t2))){
t6=(
/* library.scm:3325: def-convert?3947 */
  f_19153(t5)
);
t7=((C_word*)t0)[4];{
C_word *av2=av;
av2[0]=t7;
av2[1]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}
else{
t6=C_i_car(t2);
t7=C_u_i_cdr(t2);
if(C_truep(C_i_nullp(t7))){
t8=(
/* library.scm:3325: def-set?3948 */
  f_19148(t4)
);
t9=((C_word*)t0)[4];{
C_word *av2=av;
av2[0]=t9;
av2[1]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t9+1)))(2,av2);}}
else{
t8=C_i_car(t7);
t9=C_u_i_cdr(t7);
t10=(
/* library.scm:3325: body3945 */
  f_19142(t3,t8)
);
t11=((C_word*)t0)[4];{
C_word *av2=av;
av2[0]=t11;
av2[1]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t11+1)))(2,av2);}}}}

/* body3945 in k19138 in chicken.base#current-error-port in k18957 in k18954 in k18951 in k18948 in k18944 in k18940 in k18424 in k18421 in k18418 in k18415 in k18412 in k18409 in k18406 in k18403 in k18400 in k18397 in k18394 in k18391 in k18388 in ... */
static C_word C_fcall f_19142(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_stack_overflow_check;{}
if(C_truep(t1)){
t2=C_mutate((C_word*)lf[715]+1 /* (set! ##sys#standard-error ...) */,((C_word*)t0)[2]);
return(t2);}
else{
t2=C_SCHEME_UNDEFINED;
return(t2);}}

/* def-set?3948 in k19138 in chicken.base#current-error-port in k18957 in k18954 in k18951 in k18948 in k18944 in k18940 in k18424 in k18421 in k18418 in k18415 in k18412 in k18409 in k18406 in k18403 in k18400 in k18397 in k18394 in k18391 in k18388 in ... */
static C_word C_fcall f_19148(C_word t0){
C_word tmp;
C_word t1;
C_stack_overflow_check;{}
return((
/* library.scm:3325: body3945 */
  f_19142(((C_word*)t0)[2],C_SCHEME_TRUE)
));}

/* def-convert?3947 in k19138 in chicken.base#current-error-port in k18957 in k18954 in k18951 in k18948 in k18944 in k18940 in k18424 in k18421 in k18418 in k18415 in k18412 in k18409 in k18406 in k18403 in k18400 in k18397 in k18394 in k18391 in k18388 in ... */
static C_word C_fcall f_19153(C_word t0){
C_word tmp;
C_word t1;
C_stack_overflow_check;{}
return((
/* library.scm:3325: def-set?3948 */
  f_19148(((C_word*)t0)[2])
));}

/* ##sys#tty-port? in k18957 in k18954 in k18951 in k18948 in k18944 in k18940 in k18424 in k18421 in k18418 in k18415 in k18412 in k18409 in k18406 in k18403 in k18400 in k18397 in k18394 in k18391 in k18388 in k18385 in k18225 in ... */
static void C_ccall f_19188(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(4,c,3)))){
C_save_and_reclaim((void *)f_19188,c,av);}
a=C_alloc(4);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_19200,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* library.scm:3330: ##sys#peek-unsigned-integer */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[723]);
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[723]+1);
av2[1]=t3;
av2[2]=t2;
av2[3]=C_fix(0);
tp(4,av2);}}

/* k19198 in ##sys#tty-port? in k18957 in k18954 in k18951 in k18948 in k18944 in k18940 in k18424 in k18421 in k18418 in k18415 in k18412 in k18409 in k18406 in k18403 in k18400 in k18397 in k18394 in k18391 in k18388 in k18385 in ... */
static void C_ccall f_19200(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_19200,c,av);}
t2=C_i_not(C_i_zerop(t1));
t3=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t3;
av2[1]=(C_truep(t2)?C_tty_portp(((C_word*)t0)[3]):C_SCHEME_FALSE);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* ##sys#port-data in k18957 in k18954 in k18951 in k18948 in k18944 in k18940 in k18424 in k18421 in k18418 in k18415 in k18412 in k18409 in k18406 in k18403 in k18400 in k18397 in k18394 in k18391 in k18388 in k18385 in k18225 in ... */
static void C_ccall f_19202(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_19202,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_slot(t2,C_fix(9));
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* ##sys#set-port-data! in k18957 in k18954 in k18951 in k18948 in k18944 in k18940 in k18424 in k18421 in k18418 in k18415 in k18412 in k18409 in k18406 in k18403 in k18400 in k18397 in k18394 in k18391 in k18388 in k18385 in k18225 in ... */
static void C_ccall f_19208(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_19208,c,av);}
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_i_setslot(t2,C_fix(9),t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* open in k18957 in k18954 in k18951 in k18948 in k18944 in k18940 in k18424 in k18421 in k18418 in k18415 in k18412 in k18409 in k18406 in k18403 in k18400 in k18397 in k18394 in k18391 in k18388 in k18385 in k18225 in ... */
static void C_fcall f_19214(C_word t1,C_word t2,C_word t3,C_word t4,C_word t5){
C_word tmp;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(22,0,3)))){
C_save_and_reclaim_args((void *)trf_19214,5,t1,t2,t3,t4,t5);}
a=C_alloc(22);
t6=C_i_check_string_2(t2,t5);
t7=(C_truep(t3)?lf[726]:lf[727]);
t8=t7;
t9=(*a=C_VECTOR_TYPE|1,a[1]=t8,tmp=(C_word)a,a+=2,tmp);
t10=lf[728];
t11=(*a=C_VECTOR_TYPE|1,a[1]=t10,tmp=(C_word)a,a+=2,tmp);
t12=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_19224,a[2]=t1,a[3]=t5,a[4]=t2,a[5]=t9,a[6]=t11,a[7]=t3,tmp=(C_word)a,a+=8,tmp);
t13=C_SCHEME_UNDEFINED;
t14=(*a=C_VECTOR_TYPE|1,a[1]=t13,tmp=(C_word)a,a+=2,tmp);
t15=C_set_block_item(t14,0,(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_19257,a[2]=t14,a[3]=t11,a[4]=t3,a[5]=t5,a[6]=t9,a[7]=((C_word)li573),tmp=(C_word)a,a+=8,tmp));
t16=((C_word*)t14)[1];
f_19257(t16,t12,t4);}

/* k19222 in open in k18957 in k18954 in k18951 in k18948 in k18944 in k18940 in k18424 in k18421 in k18418 in k18415 in k18412 in k18409 in k18406 in k18403 in k18400 in k18397 in k18394 in k18391 in k18388 in k18385 in ... */
static void C_ccall f_19224(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(7,c,5)))){
C_save_and_reclaim((void *)f_19224,c,av);}
a=C_alloc(7);
t2=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_19227,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],tmp=(C_word)a,a+=7,tmp);
if(C_truep(((C_word*)t0)[7])){
/* library.scm:3352: ##sys#make-port */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[697]);
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=*((C_word*)lf[697]+1);
av2[1]=t2;
av2[2]=C_fix(1);
av2[3]=C_fast_retrieve(lf[711]);
av2[4]=((C_word*)t0)[4];
av2[5]=lf[730];
tp(6,av2);}}
else{
/* library.scm:3352: ##sys#make-port */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[697]);
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=*((C_word*)lf[697]+1);
av2[1]=t2;
av2[2]=C_fix(2);
av2[3]=C_fast_retrieve(lf[711]);
av2[4]=((C_word*)t0)[4];
av2[5]=lf[730];
tp(6,av2);}}}

/* k19225 in k19222 in open in k18957 in k18954 in k18951 in k18948 in k18944 in k18940 in k18424 in k18421 in k18418 in k18415 in k18412 in k18409 in k18406 in k18403 in k18400 in k18397 in k18394 in k18391 in k18388 in ... */
static void C_ccall f_19227(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(16,c,3)))){
C_save_and_reclaim((void *)f_19227,c,av);}
a=C_alloc(16);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_19230,a[2]=((C_word*)t0)[2],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t3=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_19233,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=t2,a[5]=((C_word*)t0)[3],a[6]=((C_word*)t0)[4],tmp=(C_word)a,a+=7,tmp);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_19251,a[2]=t3,a[3]=t1,a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
/* library.scm:3353: ##sys#string-append */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[415]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[415]+1);
av2[1]=t4;
av2[2]=((C_word*)((C_word*)t0)[5])[1];
av2[3]=((C_word*)((C_word*)t0)[6])[1];
tp(4,av2);}}

/* k19228 in k19225 in k19222 in open in k18957 in k18954 in k18951 in k18948 in k18944 in k18940 in k18424 in k18421 in k18418 in k18415 in k18412 in k18409 in k18406 in k18403 in k18400 in k18397 in k18394 in k18391 in ... */
static void C_ccall f_19230(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_19230,c,av);}
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* k19231 in k19225 in k19222 in open in k18957 in k18954 in k18951 in k18948 in k18944 in k18940 in k18424 in k18421 in k18418 in k18415 in k18412 in k18409 in k18406 in k18403 in k18400 in k18397 in k18394 in k18391 in ... */
static void C_ccall f_19233(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,c,2)))){
C_save_and_reclaim((void *)f_19233,c,av);}
a=C_alloc(5);
if(C_truep(t1)){
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}
else{
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_19236,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[6],tmp=(C_word)a,a+=5,tmp);
/* library.scm:3354: ##sys#update-errno */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[703]);
C_word *av2=av;
av2[0]=*((C_word*)lf[703]+1);
av2[1]=t2;
tp(2,av2);}}}

/* k19234 in k19231 in k19225 in k19222 in open in k18957 in k18954 in k18951 in k18948 in k18944 in k18940 in k18424 in k18421 in k18418 in k18415 in k18412 in k18409 in k18406 in k18403 in k18400 in k18397 in k18394 in ... */
static void C_ccall f_19236(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(11,c,3)))){
C_save_and_reclaim((void *)f_19236,c,av);}
a=C_alloc(11);
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_19243,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_19247,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
/* ##sys#peek-c-string */
t4=*((C_word*)lf[702]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t4;
av2[1]=t3;
av2[2]=C_mpointer(&a,(void*)strerror(errno));
av2[3]=C_fix(0);
((C_proc)(void*)(*((C_word*)t4+1)))(4,av2);}}

/* k19241 in k19234 in k19231 in k19225 in k19222 in open in k18957 in k18954 in k18951 in k18948 in k18944 in k18940 in k18424 in k18421 in k18418 in k18415 in k18412 in k18409 in k18406 in k18403 in k18400 in k18397 in ... */
static void C_ccall f_19243(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,5)))){
C_save_and_reclaim((void *)f_19243,c,av);}
/* library.scm:3355: ##sys#signal-hook */
t2=C_fast_retrieve(lf[194]);{
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=lf[699];
av2[3]=((C_word*)t0)[3];
av2[4]=t1;
av2[5]=((C_word*)t0)[4];
((C_proc)(void*)(*((C_word*)t2+1)))(6,av2);}}

/* k19245 in k19234 in k19231 in k19225 in k19222 in open in k18957 in k18954 in k18951 in k18948 in k18944 in k18940 in k18424 in k18421 in k18418 in k18415 in k18412 in k18409 in k18406 in k18403 in k18400 in k18397 in ... */
static void C_ccall f_19247(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_19247,c,av);}
/* library.scm:3355: ##sys#string-append */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[415]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[415]+1);
av2[1]=((C_word*)t0)[2];
av2[2]=lf[729];
av2[3]=t1;
tp(4,av2);}}

/* k19249 in k19225 in k19222 in open in k18957 in k18954 in k18951 in k18948 in k18944 in k18940 in k18424 in k18421 in k18418 in k18415 in k18412 in k18409 in k18406 in k18403 in k18400 in k18397 in k18394 in k18391 in ... */
static void C_ccall f_19251(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,4)))){
C_save_and_reclaim((void *)f_19251,c,av);}
/* library.scm:3353: ##sys#open-file-port */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[712]);
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=*((C_word*)lf[712]+1);
av2[1]=((C_word*)t0)[2];
av2[2]=((C_word*)t0)[3];
av2[3]=((C_word*)t0)[4];
av2[4]=t1;
tp(5,av2);}}

/* doloop3982 in open in k18957 in k18954 in k18951 in k18948 in k18944 in k18940 in k18424 in k18421 in k18418 in k18415 in k18412 in k18409 in k18406 in k18403 in k18400 in k18397 in k18394 in k18391 in k18388 in k18385 in ... */
static void C_fcall f_19257(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word *a;
loop:
if(C_unlikely(!C_demand(C_calculate_demand(5,0,4)))){
C_save_and_reclaim_args((void *)trf_19257,3,t0,t1,t2);}
a=C_alloc(5);
if(C_truep(C_i_nullp(t2))){
t3=C_SCHEME_UNDEFINED;
t4=t1;{
C_word av2[2];
av2[0]=t4;
av2[1]=t3;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t3=C_slot(t2,C_fix(0));
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_19270,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=t2,tmp=(C_word)a,a+=5,tmp);
t5=C_eqp(t3,lf[731]);
if(C_truep(t5)){
t6=C_mutate(((C_word *)((C_word*)t0)[3])+1,lf[732]);
t10=t1;
t11=C_slot(t2,C_fix(1));
t1=t10;
t2=t11;
goto loop;}
else{
t6=C_eqp(t3,lf[733]);
if(C_truep(t6)){
t7=C_mutate(((C_word *)((C_word*)t0)[3])+1,lf[734]);
t10=t1;
t11=C_slot(t2,C_fix(1));
t1=t10;
t2=t11;
goto loop;}
else{
t7=C_eqp(t3,lf[735]);
if(C_truep(t7)){
if(C_truep(((C_word*)t0)[4])){
/* library.scm:3349: ##sys#error */
t8=*((C_word*)lf[155]+1);{
C_word av2[4];
av2[0]=t8;
av2[1]=t4;
av2[2]=((C_word*)t0)[5];
av2[3]=lf[736];
((C_proc)(void*)(*((C_word*)t8+1)))(4,av2);}}
else{
t8=C_mutate(((C_word *)((C_word*)t0)[6])+1,lf[737]);
t10=t1;
t11=C_slot(t2,C_fix(1));
t1=t10;
t2=t11;
goto loop;}}
else{
/* library.scm:3351: ##sys#error */
t8=*((C_word*)lf[155]+1);{
C_word av2[5];
av2[0]=t8;
av2[1]=t4;
av2[2]=((C_word*)t0)[5];
av2[3]=lf[738];
av2[4]=t3;
((C_proc)(void*)(*((C_word*)t8+1)))(5,av2);}}}}}}

/* k19268 in doloop3982 in open in k18957 in k18954 in k18951 in k18948 in k18944 in k18940 in k18424 in k18421 in k18418 in k18415 in k18412 in k18409 in k18406 in k18403 in k18400 in k18397 in k18394 in k18391 in k18388 in ... */
static void C_ccall f_19270(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_19270,c,av);}
t2=((C_word*)((C_word*)t0)[2])[1];
f_19257(t2,((C_word*)t0)[3],C_slot(((C_word*)t0)[4],C_fix(1)));}

/* close in k18957 in k18954 in k18951 in k18948 in k18944 in k18940 in k18424 in k18421 in k18418 in k18415 in k18412 in k18409 in k18406 in k18403 in k18400 in k18397 in k18394 in k18391 in k18388 in k18385 in k18225 in ... */
static void C_fcall f_19312(C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,0,3)))){
C_save_and_reclaim_args((void *)trf_19312,4,t1,t2,t3,t4);}
a=C_alloc(5);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_19316,a[2]=t3,a[3]=t2,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
/* library.scm:3359: ##sys#check-port */
t6=*((C_word*)lf[695]+1);{
C_word av2[4];
av2[0]=t6;
av2[1]=t5;
av2[2]=t2;
av2[3]=t4;
((C_proc)(void*)(*((C_word*)t6+1)))(4,av2);}}

/* k19314 in close in k18957 in k18954 in k18951 in k18948 in k18944 in k18940 in k18424 in k18421 in k18418 in k18415 in k18412 in k18409 in k18406 in k18403 in k18400 in k18397 in k18394 in k18391 in k18388 in k18385 in ... */
static void C_ccall f_19316(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_19316,c,av);}
t2=(C_truep(((C_word*)t0)[2])?C_fix(1):C_fix(2));
if(C_truep(C_port_openp(((C_word*)t0)[3],t2))){
t3=C_slot(((C_word*)t0)[3],C_fix(8));
t4=C_fixnum_not(t2);
t5=C_fixnum_and(t3,t4);
t6=C_i_set_i_slot(((C_word*)t0)[3],C_fix(8),t5);
t7=C_slot(((C_word*)t0)[3],C_fix(2));
/* library.scm:3362: g4003 */
t8=C_slot(t7,C_fix(4));{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t8;
av2[1]=((C_word*)t0)[4];
av2[2]=((C_word*)t0)[3];
av2[3]=t2;
((C_proc)C_fast_retrieve_proc(t8))(4,av2);}}
else{
t3=C_SCHEME_UNDEFINED;
t4=((C_word*)t0)[4];{
C_word *av2=av;
av2[0]=t4;
av2[1]=t3;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}}

/* scheme#open-input-file in k18957 in k18954 in k18951 in k18948 in k18944 in k18940 in k18424 in k18421 in k18418 in k18415 in k18412 in k18409 in k18406 in k18403 in k18400 in k18397 in k18394 in k18391 in k18388 in k18385 in k18225 in ... */
static void C_ccall f_19349(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +0,c,5)))){
C_save_and_reclaim((void*)f_19349,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+0);
t3=C_build_rest(&a,c,3,av);
C_word t4;
/* library.scm:3366: open */
f_19214(t1,t2,C_SCHEME_TRUE,t3,lf[739]);}

/* scheme#open-output-file in k18957 in k18954 in k18951 in k18948 in k18944 in k18940 in k18424 in k18421 in k18418 in k18415 in k18412 in k18409 in k18406 in k18403 in k18400 in k18397 in k18394 in k18391 in k18388 in k18385 in k18225 in ... */
static void C_ccall f_19355(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +0,c,5)))){
C_save_and_reclaim((void*)f_19355,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+0);
t3=C_build_rest(&a,c,3,av);
C_word t4;
/* library.scm:3367: open */
f_19214(t1,t2,C_SCHEME_FALSE,t3,lf[740]);}

/* scheme#close-input-port in k18957 in k18954 in k18951 in k18948 in k18944 in k18940 in k18424 in k18421 in k18418 in k18415 in k18412 in k18409 in k18406 in k18403 in k18400 in k18397 in k18394 in k18391 in k18388 in k18385 in k18225 in ... */
static void C_ccall f_19361(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,4)))){
C_save_and_reclaim((void *)f_19361,c,av);}
/* library.scm:3368: close */
f_19312(t1,t2,C_SCHEME_TRUE,lf[741]);}

/* scheme#close-output-port in k18957 in k18954 in k18951 in k18948 in k18944 in k18940 in k18424 in k18421 in k18418 in k18415 in k18412 in k18409 in k18406 in k18403 in k18400 in k18397 in k18394 in k18391 in k18388 in k18385 in k18225 in ... */
static void C_ccall f_19367(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,4)))){
C_save_and_reclaim((void *)f_19367,c,av);}
/* library.scm:3369: close */
f_19312(t1,t2,C_SCHEME_FALSE,lf[742]);}

/* scheme#call-with-input-file in k18957 in k18954 in k18951 in k18948 in k18944 in k18940 in k18424 in k18421 in k18418 in k18415 in k18412 in k18409 in k18406 in k18403 in k18400 in k18397 in k18394 in k18391 in k18388 in k18385 in k18225 in ... */
static void C_ccall f_19373(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c<4) C_bad_min_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-4)*C_SIZEOF_PAIR +4,c,4)))){
C_save_and_reclaim((void*)f_19373,c,av);}
a=C_alloc((c-4)*C_SIZEOF_PAIR+4);
t4=C_build_rest(&a,c,4,av);
C_word t5;
C_word t6;
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_19377,a[2]=t3,a[3]=t1,tmp=(C_word)a,a+=4,tmp);{
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=0;
av2[1]=t5;
av2[2]=((C_word*)t0)[2];
av2[3]=t2;
av2[4]=t4;
C_apply(5,av2);}}

/* k19375 in scheme#call-with-input-file in k18957 in k18954 in k18951 in k18948 in k18944 in k18940 in k18424 in k18421 in k18418 in k18415 in k18412 in k18409 in k18406 in k18403 in k18400 in k18397 in k18394 in k18391 in k18388 in k18385 in ... */
static void C_ccall f_19377(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(9,c,3)))){
C_save_and_reclaim((void *)f_19377,c,av);}
a=C_alloc(9);
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_19382,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=((C_word)li580),tmp=(C_word)a,a+=5,tmp);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_19388,a[2]=t1,a[3]=((C_word)li581),tmp=(C_word)a,a+=4,tmp);
/* library.scm:3376: ##sys#call-with-values */{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=0;
av2[1]=((C_word*)t0)[3];
av2[2]=t2;
av2[3]=t3;
C_call_with_values(4,av2);}}

/* a19381 in k19375 in scheme#call-with-input-file in k18957 in k18954 in k18951 in k18948 in k18944 in k18940 in k18424 in k18421 in k18418 in k18415 in k18412 in k18409 in k18406 in k18403 in k18400 in k18397 in k18394 in k18391 in k18388 in ... */
static void C_ccall f_19382(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_19382,c,av);}
/* library.scm:3377: p */
t2=((C_word*)t0)[2];{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t2;
av2[1]=t1;
av2[2]=((C_word*)t0)[3];
((C_proc)C_fast_retrieve_proc(t2))(3,av2);}}

/* a19387 in k19375 in scheme#call-with-input-file in k18957 in k18954 in k18951 in k18948 in k18944 in k18940 in k18424 in k18421 in k18418 in k18415 in k18412 in k18409 in k18406 in k18403 in k18400 in k18397 in k18394 in k18391 in k18388 in ... */
static void C_ccall f_19388(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand((c-2)*C_SIZEOF_PAIR +4,c,2)))){
C_save_and_reclaim((void*)f_19388,c,av);}
a=C_alloc((c-2)*C_SIZEOF_PAIR+4);
t2=C_build_rest(&a,c,2,av);
C_word t3;
C_word t4;
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_19392,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* library.scm:3379: close-input-port */
t4=*((C_word*)lf[139]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t4;
av2[1]=t3;
av2[2]=((C_word*)t0)[2];
((C_proc)(void*)(*((C_word*)t4+1)))(3,av2);}}

/* k19390 in a19387 in k19375 in scheme#call-with-input-file in k18957 in k18954 in k18951 in k18948 in k18944 in k18940 in k18424 in k18421 in k18418 in k18415 in k18412 in k18409 in k18406 in k18403 in k18400 in k18397 in k18394 in k18391 in ... */
static void C_ccall f_19392(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_19392,c,av);}{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=0;
av2[1]=((C_word*)t0)[2];
av2[2]=((C_word*)t0)[3];
C_apply_values(3,av2);}}

/* scheme#call-with-output-file in k18957 in k18954 in k18951 in k18948 in k18944 in k18940 in k18424 in k18421 in k18418 in k18415 in k18412 in k18409 in k18406 in k18403 in k18400 in k18397 in k18394 in k18391 in k18388 in k18385 in k18225 in ... */
static void C_ccall f_19397(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c<4) C_bad_min_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-4)*C_SIZEOF_PAIR +4,c,4)))){
C_save_and_reclaim((void*)f_19397,c,av);}
a=C_alloc((c-4)*C_SIZEOF_PAIR+4);
t4=C_build_rest(&a,c,4,av);
C_word t5;
C_word t6;
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_19401,a[2]=t3,a[3]=t1,tmp=(C_word)a,a+=4,tmp);{
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=0;
av2[1]=t5;
av2[2]=((C_word*)t0)[2];
av2[3]=t2;
av2[4]=t4;
C_apply(5,av2);}}

/* k19399 in scheme#call-with-output-file in k18957 in k18954 in k18951 in k18948 in k18944 in k18940 in k18424 in k18421 in k18418 in k18415 in k18412 in k18409 in k18406 in k18403 in k18400 in k18397 in k18394 in k18391 in k18388 in k18385 in ... */
static void C_ccall f_19401(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(9,c,3)))){
C_save_and_reclaim((void *)f_19401,c,av);}
a=C_alloc(9);
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_19406,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=((C_word)li583),tmp=(C_word)a,a+=5,tmp);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_19412,a[2]=t1,a[3]=((C_word)li584),tmp=(C_word)a,a+=4,tmp);
/* library.scm:3387: ##sys#call-with-values */{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=0;
av2[1]=((C_word*)t0)[3];
av2[2]=t2;
av2[3]=t3;
C_call_with_values(4,av2);}}

/* a19405 in k19399 in scheme#call-with-output-file in k18957 in k18954 in k18951 in k18948 in k18944 in k18940 in k18424 in k18421 in k18418 in k18415 in k18412 in k18409 in k18406 in k18403 in k18400 in k18397 in k18394 in k18391 in k18388 in ... */
static void C_ccall f_19406(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_19406,c,av);}
/* library.scm:3388: p */
t2=((C_word*)t0)[2];{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t2;
av2[1]=t1;
av2[2]=((C_word*)t0)[3];
((C_proc)C_fast_retrieve_proc(t2))(3,av2);}}

/* a19411 in k19399 in scheme#call-with-output-file in k18957 in k18954 in k18951 in k18948 in k18944 in k18940 in k18424 in k18421 in k18418 in k18415 in k18412 in k18409 in k18406 in k18403 in k18400 in k18397 in k18394 in k18391 in k18388 in ... */
static void C_ccall f_19412(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand((c-2)*C_SIZEOF_PAIR +4,c,2)))){
C_save_and_reclaim((void*)f_19412,c,av);}
a=C_alloc((c-2)*C_SIZEOF_PAIR+4);
t2=C_build_rest(&a,c,2,av);
C_word t3;
C_word t4;
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_19416,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* library.scm:3390: close-output-port */
t4=*((C_word*)lf[140]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t4;
av2[1]=t3;
av2[2]=((C_word*)t0)[2];
((C_proc)(void*)(*((C_word*)t4+1)))(3,av2);}}

/* k19414 in a19411 in k19399 in scheme#call-with-output-file in k18957 in k18954 in k18951 in k18948 in k18944 in k18940 in k18424 in k18421 in k18418 in k18415 in k18412 in k18409 in k18406 in k18403 in k18400 in k18397 in k18394 in k18391 in ... */
static void C_ccall f_19416(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_19416,c,av);}{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=0;
av2[1]=((C_word*)t0)[2];
av2[2]=((C_word*)t0)[3];
C_apply_values(3,av2);}}

/* scheme#with-input-from-file in k18957 in k18954 in k18951 in k18948 in k18944 in k18940 in k18424 in k18421 in k18418 in k18415 in k18412 in k18409 in k18406 in k18403 in k18400 in k18397 in k18394 in k18391 in k18388 in k18385 in k18225 in ... */
static void C_ccall f_19421(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c<4) C_bad_min_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-4)*C_SIZEOF_PAIR +4,c,4)))){
C_save_and_reclaim((void*)f_19421,c,av);}
a=C_alloc((c-4)*C_SIZEOF_PAIR+4);
t4=C_build_rest(&a,c,4,av);
C_word t5;
C_word t6;
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_19425,a[2]=t3,a[3]=t1,tmp=(C_word)a,a+=4,tmp);{
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=0;
av2[1]=t5;
av2[2]=((C_word*)t0)[2];
av2[3]=t2;
av2[4]=t4;
C_apply(5,av2);}}

/* k19423 in scheme#with-input-from-file in k18957 in k18954 in k18951 in k18948 in k18944 in k18940 in k18424 in k18421 in k18418 in k18415 in k18412 in k18409 in k18406 in k18403 in k18400 in k18397 in k18394 in k18391 in k18388 in k18385 in ... */
static void C_ccall f_19425(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(19,c,4)))){
C_save_and_reclaim((void *)f_19425,c,av);}
a=C_alloc(19);
t2=t1;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_SCHEME_FALSE;
t5=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_19430,a[2]=t5,a[3]=t3,a[4]=((C_word)li586),tmp=(C_word)a,a+=5,tmp);
t7=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_19435,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word)li588),tmp=(C_word)a,a+=5,tmp);
t8=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_19450,a[2]=t3,a[3]=t5,a[4]=((C_word)li589),tmp=(C_word)a,a+=5,tmp);
/* library.scm:3398: ##sys#dynamic-wind */
t9=*((C_word*)lf[691]+1);{
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=t9;
av2[1]=((C_word*)t0)[3];
av2[2]=t6;
av2[3]=t7;
av2[4]=t8;
((C_proc)(void*)(*((C_word*)t9+1)))(5,av2);}}

/* a19429 in k19423 in scheme#with-input-from-file in k18957 in k18954 in k18951 in k18948 in k18944 in k18940 in k18424 in k18421 in k18418 in k18415 in k18412 in k18409 in k18406 in k18403 in k18400 in k18397 in k18394 in k18391 in k18388 in ... */
static void C_ccall f_19430(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_19430,c,av);}
t2=C_mutate(((C_word *)((C_word*)t0)[2])+1,*((C_word*)lf[713]+1));
t3=C_mutate((C_word*)lf[713]+1 /* (set! ##sys#standard-input ...) */,((C_word*)((C_word*)t0)[3])[1]);
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_SCHEME_UNDEFINED;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* a19434 in k19423 in scheme#with-input-from-file in k18957 in k18954 in k18951 in k18948 in k18944 in k18940 in k18424 in k18421 in k18418 in k18415 in k18412 in k18409 in k18406 in k18403 in k18400 in k18397 in k18394 in k18391 in k18388 in ... */
static void C_ccall f_19435(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(4,c,3)))){
C_save_and_reclaim((void *)f_19435,c,av);}
a=C_alloc(4);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_19441,a[2]=((C_word*)t0)[2],a[3]=((C_word)li587),tmp=(C_word)a,a+=4,tmp);
/* library.scm:3399: ##sys#call-with-values */{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=0;
av2[1]=t1;
av2[2]=((C_word*)t0)[3];
av2[3]=t2;
C_call_with_values(4,av2);}}

/* a19440 in a19434 in k19423 in scheme#with-input-from-file in k18957 in k18954 in k18951 in k18948 in k18944 in k18940 in k18424 in k18421 in k18418 in k18415 in k18412 in k18409 in k18406 in k18403 in k18400 in k18397 in k18394 in k18391 in ... */
static void C_ccall f_19441(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand((c-2)*C_SIZEOF_PAIR +4,c,2)))){
C_save_and_reclaim((void*)f_19441,c,av);}
a=C_alloc((c-2)*C_SIZEOF_PAIR+4);
t2=C_build_rest(&a,c,2,av);
C_word t3;
C_word t4;
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_19445,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* library.scm:3401: close-input-port */
t4=*((C_word*)lf[139]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t4;
av2[1]=t3;
av2[2]=((C_word*)t0)[2];
((C_proc)(void*)(*((C_word*)t4+1)))(3,av2);}}

/* k19443 in a19440 in a19434 in k19423 in scheme#with-input-from-file in k18957 in k18954 in k18951 in k18948 in k18944 in k18940 in k18424 in k18421 in k18418 in k18415 in k18412 in k18409 in k18406 in k18403 in k18400 in k18397 in k18394 in ... */
static void C_ccall f_19445(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_19445,c,av);}{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=0;
av2[1]=((C_word*)t0)[2];
av2[2]=((C_word*)t0)[3];
C_apply_values(3,av2);}}

/* a19449 in k19423 in scheme#with-input-from-file in k18957 in k18954 in k18951 in k18948 in k18944 in k18940 in k18424 in k18421 in k18418 in k18415 in k18412 in k18409 in k18406 in k18403 in k18400 in k18397 in k18394 in k18391 in k18388 in ... */
static void C_ccall f_19450(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_19450,c,av);}
t2=C_mutate(((C_word *)((C_word*)t0)[2])+1,*((C_word*)lf[713]+1));
t3=C_mutate((C_word*)lf[713]+1 /* (set! ##sys#standard-input ...) */,((C_word*)((C_word*)t0)[3])[1]);
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_SCHEME_UNDEFINED;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* scheme#with-output-to-file in k18957 in k18954 in k18951 in k18948 in k18944 in k18940 in k18424 in k18421 in k18418 in k18415 in k18412 in k18409 in k18406 in k18403 in k18400 in k18397 in k18394 in k18391 in k18388 in k18385 in k18225 in ... */
static void C_ccall f_19455(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c<4) C_bad_min_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-4)*C_SIZEOF_PAIR +4,c,4)))){
C_save_and_reclaim((void*)f_19455,c,av);}
a=C_alloc((c-4)*C_SIZEOF_PAIR+4);
t4=C_build_rest(&a,c,4,av);
C_word t5;
C_word t6;
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_19459,a[2]=t3,a[3]=t1,tmp=(C_word)a,a+=4,tmp);{
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=0;
av2[1]=t5;
av2[2]=((C_word*)t0)[2];
av2[3]=t2;
av2[4]=t4;
C_apply(5,av2);}}

/* k19457 in scheme#with-output-to-file in k18957 in k18954 in k18951 in k18948 in k18944 in k18940 in k18424 in k18421 in k18418 in k18415 in k18412 in k18409 in k18406 in k18403 in k18400 in k18397 in k18394 in k18391 in k18388 in k18385 in ... */
static void C_ccall f_19459(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(19,c,4)))){
C_save_and_reclaim((void *)f_19459,c,av);}
a=C_alloc(19);
t2=t1;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_SCHEME_FALSE;
t5=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_19464,a[2]=t5,a[3]=t3,a[4]=((C_word)li591),tmp=(C_word)a,a+=5,tmp);
t7=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_19469,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word)li593),tmp=(C_word)a,a+=5,tmp);
t8=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_19484,a[2]=t3,a[3]=t5,a[4]=((C_word)li594),tmp=(C_word)a,a+=5,tmp);
/* library.scm:3409: ##sys#dynamic-wind */
t9=*((C_word*)lf[691]+1);{
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=t9;
av2[1]=((C_word*)t0)[3];
av2[2]=t6;
av2[3]=t7;
av2[4]=t8;
((C_proc)(void*)(*((C_word*)t9+1)))(5,av2);}}

/* a19463 in k19457 in scheme#with-output-to-file in k18957 in k18954 in k18951 in k18948 in k18944 in k18940 in k18424 in k18421 in k18418 in k18415 in k18412 in k18409 in k18406 in k18403 in k18400 in k18397 in k18394 in k18391 in k18388 in ... */
static void C_ccall f_19464(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_19464,c,av);}
t2=C_mutate(((C_word *)((C_word*)t0)[2])+1,*((C_word*)lf[714]+1));
t3=C_mutate((C_word*)lf[714]+1 /* (set! ##sys#standard-output ...) */,((C_word*)((C_word*)t0)[3])[1]);
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_SCHEME_UNDEFINED;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* a19468 in k19457 in scheme#with-output-to-file in k18957 in k18954 in k18951 in k18948 in k18944 in k18940 in k18424 in k18421 in k18418 in k18415 in k18412 in k18409 in k18406 in k18403 in k18400 in k18397 in k18394 in k18391 in k18388 in ... */
static void C_ccall f_19469(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(4,c,3)))){
C_save_and_reclaim((void *)f_19469,c,av);}
a=C_alloc(4);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_19475,a[2]=((C_word*)t0)[2],a[3]=((C_word)li592),tmp=(C_word)a,a+=4,tmp);
/* library.scm:3410: ##sys#call-with-values */{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=0;
av2[1]=t1;
av2[2]=((C_word*)t0)[3];
av2[3]=t2;
C_call_with_values(4,av2);}}

/* a19474 in a19468 in k19457 in scheme#with-output-to-file in k18957 in k18954 in k18951 in k18948 in k18944 in k18940 in k18424 in k18421 in k18418 in k18415 in k18412 in k18409 in k18406 in k18403 in k18400 in k18397 in k18394 in k18391 in ... */
static void C_ccall f_19475(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand((c-2)*C_SIZEOF_PAIR +4,c,2)))){
C_save_and_reclaim((void*)f_19475,c,av);}
a=C_alloc((c-2)*C_SIZEOF_PAIR+4);
t2=C_build_rest(&a,c,2,av);
C_word t3;
C_word t4;
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_19479,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* library.scm:3412: close-output-port */
t4=*((C_word*)lf[140]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t4;
av2[1]=t3;
av2[2]=((C_word*)t0)[2];
((C_proc)(void*)(*((C_word*)t4+1)))(3,av2);}}

/* k19477 in a19474 in a19468 in k19457 in scheme#with-output-to-file in k18957 in k18954 in k18951 in k18948 in k18944 in k18940 in k18424 in k18421 in k18418 in k18415 in k18412 in k18409 in k18406 in k18403 in k18400 in k18397 in k18394 in ... */
static void C_ccall f_19479(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_19479,c,av);}{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=0;
av2[1]=((C_word*)t0)[2];
av2[2]=((C_word*)t0)[3];
C_apply_values(3,av2);}}

/* a19483 in k19457 in scheme#with-output-to-file in k18957 in k18954 in k18951 in k18948 in k18944 in k18940 in k18424 in k18421 in k18418 in k18415 in k18412 in k18409 in k18406 in k18403 in k18400 in k18397 in k18394 in k18391 in k18388 in ... */
static void C_ccall f_19484(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_19484,c,av);}
t2=C_mutate(((C_word *)((C_word*)t0)[2])+1,*((C_word*)lf[714]+1));
t3=C_mutate((C_word*)lf[714]+1 /* (set! ##sys#standard-output ...) */,((C_word*)((C_word*)t0)[3])[1]);
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_SCHEME_UNDEFINED;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* ##sys#file-exists? in k18957 in k18954 in k18951 in k18948 in k18944 in k18940 in k18424 in k18421 in k18418 in k18415 in k18412 in k18409 in k18406 in k18403 in k18400 in k18397 in k18394 in k18391 in k18388 in k18385 in k18225 in ... */
static void C_ccall f_19489(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5=av[5];
C_word t6;
C_word t7;
C_word *a;
if(c!=6) C_bad_argc_2(c,6,t0);
if(C_unlikely(!C_demand(C_calculate_demand(7,c,3)))){
C_save_and_reclaim((void *)f_19489,c,av);}
a=C_alloc(7);
t6=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_19494,a[2]=t3,a[3]=t4,a[4]=t1,a[5]=t5,a[6]=t2,tmp=(C_word)a,a+=7,tmp);
/* library.scm:3416: ##sys#make-c-string */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[745]);
C_word *av2=av;
av2[0]=*((C_word*)lf[745]+1);
av2[1]=t6;
av2[2]=t2;
av2[3]=t5;
tp(4,av2);}}

/* k19492 in ##sys#file-exists? in k18957 in k18954 in k18951 in k18948 in k18944 in k18940 in k18424 in k18421 in k18418 in k18415 in k18412 in k18409 in k18406 in k18403 in k18400 in k18397 in k18394 in k18391 in k18388 in k18385 in ... */
static void C_ccall f_19494(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,5)))){
C_save_and_reclaim((void *)f_19494,c,av);}
t2=C_i_file_exists_p(t1,((C_word*)t0)[2],((C_word*)t0)[3]);
switch(t2){
case C_SCHEME_FALSE:
t3=((C_word*)t0)[4];{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}
case C_SCHEME_TRUE:
t3=((C_word*)t0)[4];{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_SCHEME_TRUE;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}
default:
/* library.scm:3420: ##sys#signal-hook */
t3=C_fast_retrieve(lf[194]);{
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=t3;
av2[1]=((C_word*)t0)[4];
av2[2]=lf[699];
av2[3]=((C_word*)t0)[5];
av2[4]=lf[744];
av2[5]=((C_word*)t0)[6];
((C_proc)(void*)(*((C_word*)t3+1)))(6,av2);}}}

/* ##sys#flush-output in k18957 in k18954 in k18951 in k18948 in k18944 in k18940 in k18424 in k18421 in k18418 in k18415 in k18412 in k18409 in k18406 in k18403 in k18400 in k18397 in k18394 in k18391 in k18388 in k18385 in k18225 in ... */
static void C_ccall f_19515(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(3,c,2)))){
C_save_and_reclaim((void *)f_19515,c,av);}
a=C_alloc(3);
t3=C_slot(t2,C_fix(2));
t4=C_slot(t3,C_fix(5));
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_19522,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* library.scm:3424: g4083 */
t6=t4;{
C_word *av2=av;
av2[0]=t6;
av2[1]=t5;
av2[2]=t2;
((C_proc)C_fast_retrieve_proc(t6))(3,av2);}}

/* k19520 in ##sys#flush-output in k18957 in k18954 in k18951 in k18948 in k18944 in k18940 in k18424 in k18421 in k18418 in k18415 in k18412 in k18409 in k18406 in k18403 in k18400 in k18397 in k18394 in k18391 in k18388 in k18385 in ... */
static void C_ccall f_19522(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_19522,c,av);}
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_SCHEME_UNDEFINED;
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.base#flush-output in k18957 in k18954 in k18951 in k18948 in k18944 in k18940 in k18424 in k18421 in k18418 in k18415 in k18412 in k18409 in k18406 in k18403 in k18400 in k18397 in k18394 in k18391 in k18388 in k18385 in k18225 in ... */
static void C_ccall f_19528(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_19528,c,av);}
if(C_truep(C_rest_nullp(c,2))){
t2=*((C_word*)lf[714]+1);
t3=C_i_check_port_2(*((C_word*)lf[714]+1),C_fix(2),C_SCHEME_TRUE,lf[747]);
/* library.scm:3431: ##sys#flush-output */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[746]);
C_word av2[3];
av2[0]=*((C_word*)lf[746]+1);
av2[1]=t1;
av2[2]=*((C_word*)lf[714]+1);
tp(3,av2);}}
else{
t2=C_get_rest_arg(c,2,av,2,t0);
t3=C_i_check_port_2(t2,C_fix(2),C_SCHEME_TRUE,lf[747]);
/* library.scm:3431: ##sys#flush-output */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[746]);
C_word av2[3];
av2[0]=*((C_word*)lf[746]+1);
av2[1]=t1;
av2[2]=t2;
tp(3,av2);}}}

/* ##sys#port-line in k18957 in k18954 in k18951 in k18948 in k18944 in k18940 in k18424 in k18421 in k18418 in k18415 in k18412 in k18409 in k18406 in k18403 in k18400 in k18397 in k18394 in k18391 in k18388 in k18385 in k18225 in ... */
static void C_ccall f_19546(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_19546,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=(C_truep(C_input_portp(t2))?C_slot(t2,C_fix(4)):C_SCHEME_FALSE);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* ##sys#decorate-lambda in k18957 in k18954 in k18951 in k18948 in k18944 in k18940 in k18424 in k18421 in k18418 in k18415 in k18412 in k18409 in k18406 in k18403 in k18400 in k18397 in k18394 in k18391 in k18388 in k18385 in k18225 in ... */
static void C_ccall f_19555(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a;
if(c!=5) C_bad_argc_2(c,5,t0);
if(C_unlikely(!C_demand(C_calculate_demand(10,c,3)))){
C_save_and_reclaim((void *)f_19555,c,av);}
a=C_alloc(10);
t5=C_block_size(t2);
t6=C_fixnum_difference(t5,C_fix(1));
t7=C_SCHEME_UNDEFINED;
t8=(*a=C_VECTOR_TYPE|1,a[1]=t7,tmp=(C_word)a,a+=2,tmp);
t9=C_set_block_item(t8,0,(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_19568,a[2]=t5,a[3]=t2,a[4]=t4,a[5]=t8,a[6]=t3,a[7]=((C_word)li601),tmp=(C_word)a,a+=8,tmp));
t10=((C_word*)t8)[1];
f_19568(t10,t1,t6);}

/* loop in ##sys#decorate-lambda in k18957 in k18954 in k18951 in k18948 in k18944 in k18940 in k18424 in k18421 in k18418 in k18415 in k18412 in k18409 in k18406 in k18403 in k18400 in k18397 in k18394 in k18391 in k18388 in k18385 in ... */
static void C_fcall f_19568(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(7,0,2)))){
C_save_and_reclaim_args((void *)trf_19568,3,t0,t1,t2);}
a=C_alloc(7);
if(C_truep(C_i_zerop(t2))){
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_19576,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=t1,tmp=(C_word)a,a+=6,tmp);
/* library.scm:3445: scheme#make-vector */
t4=*((C_word*)lf[93]+1);{
C_word av2[3];
av2[0]=t4;
av2[1]=t3;
av2[2]=C_fixnum_plus(((C_word*)t0)[2],C_fix(1));
((C_proc)(void*)(*((C_word*)t4+1)))(3,av2);}}
else{
t3=C_slot(((C_word*)t0)[3],t2);
t4=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_19618,a[2]=((C_word*)t0)[4],a[3]=t1,a[4]=((C_word*)t0)[3],a[5]=t2,a[6]=((C_word*)t0)[5],tmp=(C_word)a,a+=7,tmp);
/* library.scm:3454: pred */
t5=((C_word*)t0)[6];{
C_word av2[3];
av2[0]=t5;
av2[1]=t4;
av2[2]=t3;
((C_proc)C_fast_retrieve_proc(t5))(3,av2);}}}

/* k19574 in loop in ##sys#decorate-lambda in k18957 in k18954 in k18951 in k18948 in k18944 in k18940 in k18424 in k18421 in k18418 in k18415 in k18412 in k18409 in k18406 in k18403 in k18400 in k18397 in k18394 in k18391 in k18388 in ... */
static void C_ccall f_19576(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(10,c,3)))){
C_save_and_reclaim((void *)f_19576,c,av);}
a=C_alloc(10);
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_19581,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=t3,a[7]=((C_word)li600),tmp=(C_word)a,a+=8,tmp));
t5=((C_word*)t3)[1];
f_19581(t5,((C_word*)t0)[5],C_fix(1));}

/* doloop4112 in k19574 in loop in ##sys#decorate-lambda in k18957 in k18954 in k18951 in k18948 in k18944 in k18940 in k18424 in k18421 in k18418 in k18415 in k18412 in k18409 in k18406 in k18403 in k18400 in k18397 in k18394 in k18391 in ... */
static void C_fcall f_19581(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
loop:
if(C_unlikely(!C_demand(C_calculate_demand(0,0,3)))){
C_save_and_reclaim_args((void *)trf_19581,3,t0,t1,t2);}
if(C_truep(C_fixnum_greater_or_equal_p(t2,((C_word*)t0)[2]))){
t3=C_vector_to_closure(((C_word*)t0)[3]);
t4=C_copy_pointer(((C_word*)t0)[4],((C_word*)t0)[3]);
/* library.scm:3450: decorator */
t5=((C_word*)t0)[5];{
C_word av2[4];
av2[0]=t5;
av2[1]=t1;
av2[2]=((C_word*)t0)[3];
av2[3]=t2;
((C_proc)C_fast_retrieve_proc(t5))(4,av2);}}
else{
t3=C_slot(((C_word*)t0)[4],t2);
t4=C_i_setslot(((C_word*)t0)[3],t2,t3);
t6=t1;
t7=C_fixnum_plus(t2,C_fix(1));
t1=t6;
t2=t7;
goto loop;}}

/* k19616 in loop in ##sys#decorate-lambda in k18957 in k18954 in k18951 in k18948 in k18944 in k18940 in k18424 in k18421 in k18418 in k18415 in k18412 in k18409 in k18406 in k18403 in k18400 in k18397 in k18394 in k18391 in k18388 in ... */
static void C_ccall f_19618(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_19618,c,av);}
if(C_truep(t1)){
/* library.scm:3455: decorator */
t2=((C_word*)t0)[2];{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[3];
av2[2]=((C_word*)t0)[4];
av2[3]=((C_word*)t0)[5];
((C_proc)C_fast_retrieve_proc(t2))(4,av2);}}
else{
/* library.scm:3456: loop */
t2=((C_word*)((C_word*)t0)[6])[1];
f_19568(t2,((C_word*)t0)[3],C_fixnum_difference(((C_word*)t0)[5],C_fix(1)));}}

/* ##sys#lambda-decoration in k18957 in k18954 in k18951 in k18948 in k18944 in k18940 in k18424 in k18421 in k18418 in k18415 in k18412 in k18409 in k18406 in k18403 in k18400 in k18397 in k18394 in k18391 in k18388 in k18385 in k18225 in ... */
static void C_ccall f_19630(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(8,c,3)))){
C_save_and_reclaim((void *)f_19630,c,av);}
a=C_alloc(8);
t4=C_block_size(t2);
t5=C_fixnum_difference(t4,C_fix(1));
t6=C_SCHEME_UNDEFINED;
t7=(*a=C_VECTOR_TYPE|1,a[1]=t6,tmp=(C_word)a,a+=2,tmp);
t8=C_set_block_item(t7,0,(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_19640,a[2]=t2,a[3]=t7,a[4]=t3,a[5]=((C_word)li603),tmp=(C_word)a,a+=6,tmp));
t9=((C_word*)t7)[1];
f_19640(t9,t1,t5);}

/* loop in ##sys#lambda-decoration in k18957 in k18954 in k18951 in k18948 in k18944 in k18940 in k18424 in k18421 in k18418 in k18415 in k18412 in k18409 in k18406 in k18403 in k18400 in k18397 in k18394 in k18391 in k18388 in k18385 in ... */
static void C_fcall f_19640(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(6,0,2)))){
C_save_and_reclaim_args((void *)trf_19640,3,t0,t1,t2);}
a=C_alloc(6);
if(C_truep(C_fixnum_greaterp(t2,C_fix(0)))){
t3=C_slot(((C_word*)t0)[2],t2);
t4=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_19656,a[2]=t1,a[3]=t3,a[4]=((C_word*)t0)[3],a[5]=t2,tmp=(C_word)a,a+=6,tmp);
/* library.scm:3462: pred */
t5=((C_word*)t0)[4];{
C_word av2[3];
av2[0]=t5;
av2[1]=t4;
av2[2]=t3;
((C_proc)C_fast_retrieve_proc(t5))(3,av2);}}
else{
t3=t1;{
C_word av2[2];
av2[0]=t3;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}}

/* k19654 in loop in ##sys#lambda-decoration in k18957 in k18954 in k18951 in k18948 in k18944 in k18940 in k18424 in k18421 in k18418 in k18415 in k18412 in k18409 in k18406 in k18403 in k18400 in k18397 in k18394 in k18391 in k18388 in ... */
static void C_ccall f_19656(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_19656,c,av);}
if(C_truep(t1)){
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}
else{
/* library.scm:3464: loop */
t2=((C_word*)((C_word*)t0)[4])[1];
f_19640(t2,((C_word*)t0)[2],C_fixnum_difference(((C_word*)t0)[5],C_fix(1)));}}

/* ##sys#make-lambda-info in k18957 in k18954 in k18951 in k18948 in k18944 in k18940 in k18424 in k18421 in k18418 in k18415 in k18412 in k18409 in k18406 in k18403 in k18400 in k18397 in k18394 in k18391 in k18388 in k18385 in k18225 in ... */
static void C_ccall f_19669(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(5,c,2)))){
C_save_and_reclaim((void *)f_19669,c,av);}
a=C_alloc(5);
t3=C_block_size(t2);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_19676,a[2]=t2,a[3]=t3,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
/* library.scm:3471: ##sys#make-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[379]+1));
C_word *av2=av;
av2[0]=*((C_word*)lf[379]+1);
av2[1]=t4;
av2[2]=t3;
tp(3,av2);}}

/* k19674 in ##sys#make-lambda-info in k18957 in k18954 in k18951 in k18948 in k18944 in k18940 in k18424 in k18421 in k18418 in k18415 in k18412 in k18409 in k18406 in k18403 in k18400 in k18397 in k18394 in k18391 in k18388 in k18385 in ... */
static void C_ccall f_19676(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_19676,c,av);}
t2=C_copy_memory(t1,((C_word*)t0)[2],((C_word*)t0)[3]);
t3=C_string_to_lambdainfo(t1);
t4=((C_word*)t0)[4];{
C_word *av2=av;
av2[0]=t4;
av2[1]=t1;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* ##sys#lambda-info? in k18957 in k18954 in k18951 in k18948 in k18944 in k18940 in k18424 in k18421 in k18418 in k18415 in k18412 in k18409 in k18406 in k18403 in k18400 in k18397 in k18394 in k18391 in k18388 in k18385 in k18225 in ... */
static void C_ccall f_19678(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_19678,c,av);}
t3=C_immp(t2);
t4=C_i_not(t3);
t5=t1;{
C_word *av2=av;
av2[0]=t5;
av2[1]=(C_truep(t4)?C_lambdainfop(t2):C_SCHEME_FALSE);
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}

/* ##sys#lambda-info in k18957 in k18954 in k18951 in k18948 in k18944 in k18940 in k18424 in k18421 in k18418 in k18415 in k18412 in k18409 in k18406 in k18403 in k18400 in k18397 in k18394 in k18391 in k18388 in k18385 in k18225 in ... */
static void C_ccall f_19691(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_19691,c,av);}
/* library.scm:3483: ##sys#lambda-decoration */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[750]);
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[750]+1);
av2[1]=t1;
av2[2]=t2;
av2[3]=C_fast_retrieve(lf[752]);
tp(4,av2);}}

/* ##sys#lambda-info->string in k18957 in k18954 in k18951 in k18948 in k18944 in k18940 in k18424 in k18421 in k18418 in k18415 in k18412 in k18409 in k18406 in k18403 in k18400 in k18397 in k18394 in k18391 in k18388 in k18385 in k18225 in ... */
static void C_ccall f_19697(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(5,c,2)))){
C_save_and_reclaim((void *)f_19697,c,av);}
a=C_alloc(5);
t3=C_block_size(t2);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_19704,a[2]=t2,a[3]=t3,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
/* library.scm:3487: ##sys#make-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[379]+1));
C_word *av2=av;
av2[0]=*((C_word*)lf[379]+1);
av2[1]=t4;
av2[2]=t3;
tp(3,av2);}}

/* k19702 in ##sys#lambda-info->string in k18957 in k18954 in k18951 in k18948 in k18944 in k18940 in k18424 in k18421 in k18418 in k18415 in k18412 in k18409 in k18406 in k18403 in k18400 in k18397 in k18394 in k18391 in k18388 in k18385 in ... */
static void C_ccall f_19704(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_19704,c,av);}
t2=C_copy_memory(t1,((C_word*)t0)[2],((C_word*)t0)[3]);
t3=((C_word*)t0)[4];{
C_word *av2=av;
av2[0]=t3;
av2[1]=t1;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* chicken.base#procedure-information in k18957 in k18954 in k18951 in k18948 in k18944 in k18940 in k18424 in k18421 in k18418 in k18415 in k18412 in k18409 in k18406 in k18403 in k18400 in k18397 in k18394 in k18391 in k18388 in k18385 in k18225 in ... */
static void C_ccall f_19706(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(4,c,3)))){
C_save_and_reclaim((void *)f_19706,c,av);}
a=C_alloc(4);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_19710,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* library.scm:3493: ##sys#check-closure */
t4=*((C_word*)lf[368]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t4;
av2[1]=t3;
av2[2]=t2;
av2[3]=lf[756];
((C_proc)(void*)(*((C_word*)t4+1)))(4,av2);}}

/* k19708 in chicken.base#procedure-information in k18957 in k18954 in k18951 in k18948 in k18944 in k18940 in k18424 in k18421 in k18418 in k18415 in k18412 in k18409 in k18406 in k18403 in k18400 in k18397 in k18394 in k18391 in k18388 in k18385 in ... */
static void C_ccall f_19710(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,c,2)))){
C_save_and_reclaim((void *)f_19710,c,av);}
a=C_alloc(3);
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_19713,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
/* library.scm:3494: ##sys#lambda-info */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[753]);
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=*((C_word*)lf[753]+1);
av2[1]=t2;
av2[2]=((C_word*)t0)[3];
tp(3,av2);}}

/* k19711 in k19708 in chicken.base#procedure-information in k18957 in k18954 in k18951 in k18948 in k18944 in k18940 in k18424 in k18421 in k18418 in k18415 in k18412 in k18409 in k18406 in k18403 in k18400 in k18397 in k18394 in k18391 in k18388 in ... */
static void C_ccall f_19713(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(6,c,2)))){
C_save_and_reclaim((void *)f_19713,c,av);}
a=C_alloc(6);
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_19723,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_19727,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
/* library.scm:3495: ##sys#lambda-info->string */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[754]);
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=*((C_word*)lf[754]+1);
av2[1]=t3;
av2[2]=t1;
tp(3,av2);}}
else{
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}}

/* k19721 in k19711 in k19708 in chicken.base#procedure-information in k18957 in k18954 in k18951 in k18948 in k18944 in k18940 in k18424 in k18421 in k18418 in k18415 in k18412 in k18409 in k18406 in k18403 in k18400 in k18397 in k18394 in k18391 in ... */
static void C_ccall f_19723(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_19723,c,av);}
/* library.scm:3495: ##sys#read */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[755]);
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[755]+1);
av2[1]=((C_word*)t0)[2];
av2[2]=t1;
av2[3]=C_SCHEME_FALSE;
tp(4,av2);}}

/* k19725 in k19711 in k19708 in chicken.base#procedure-information in k18957 in k18954 in k18951 in k18948 in k18944 in k18940 in k18424 in k18421 in k18418 in k18415 in k18412 in k18409 in k18406 in k18403 in k18400 in k18397 in k18394 in k18391 in ... */
static void C_ccall f_19727(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_19727,c,av);}
/* library.scm:3495: chicken.base#open-input-string */
t2=*((C_word*)lf[214]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=t1;
((C_proc)(void*)(*((C_word*)t2+1)))(3,av2);}}

/* k19733 in k18957 in k18954 in k18951 in k18948 in k18944 in k18940 in k18424 in k18421 in k18418 in k18415 in k18412 in k18409 in k18406 in k18403 in k18400 in k18397 in k18394 in k18391 in k18388 in k18385 in k18225 in ... */
static void C_ccall f_19735(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(6,c,4)))){
C_save_and_reclaim((void *)f_19735,c,av);}
a=C_alloc(6);
t2=C_mutate((C_word*)lf[203]+1 /* (set! chicken.base#setter ...) */,t1);
t3=C_mutate((C_word*)lf[759]+1 /* (set! ##sys#setter ...) */,*((C_word*)lf[203]+1));
t4=C_mutate((C_word*)lf[200]+1 /* (set! chicken.base#getter-with-setter ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_19738,a[2]=((C_word)li613),tmp=(C_word)a,a+=3,tmp));
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_19815,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
/* library.scm:3555: chicken.base#getter-with-setter */
t6=*((C_word*)lf[200]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t6;
av2[1]=t5;
av2[2]=*((C_word*)lf[9]+1);
av2[3]=*((C_word*)lf[11]+1);
((C_proc)(void*)(*((C_word*)t6+1)))(4,av2);}}

/* chicken.base#getter-with-setter in k19733 in k18957 in k18954 in k18951 in k18948 in k18944 in k18940 in k18424 in k18421 in k18418 in k18415 in k18412 in k18409 in k18406 in k18403 in k18400 in k18397 in k18394 in k18391 in k18388 in k18385 in ... */
static void C_ccall f_19738(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(c<4) C_bad_min_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(6,c,3)))){
C_save_and_reclaim((void *)f_19738,c,av);}
a=C_alloc(6);
t4=C_rest_nullp(c,4);
t5=(C_truep(t4)?C_SCHEME_FALSE:C_get_rest_arg(c,4,av,4,t0));
t6=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_19745,a[2]=t1,a[3]=t3,a[4]=t2,a[5]=t5,tmp=(C_word)a,a+=6,tmp);
/* library.scm:3534: ##sys#check-closure */
t7=*((C_word*)lf[368]+1);{
C_word *av2=av;
av2[0]=t7;
av2[1]=t6;
av2[2]=t2;
av2[3]=lf[760];
((C_proc)(void*)(*((C_word*)t7+1)))(4,av2);}}

/* k19743 in chicken.base#getter-with-setter in k19733 in k18957 in k18954 in k18951 in k18948 in k18944 in k18940 in k18424 in k18421 in k18418 in k18415 in k18412 in k18409 in k18406 in k18403 in k18400 in k18397 in k18394 in k18391 in k18388 in ... */
static void C_ccall f_19745(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(6,c,3)))){
C_save_and_reclaim((void *)f_19745,c,av);}
a=C_alloc(6);
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_19748,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],tmp=(C_word)a,a+=6,tmp);
/* library.scm:3535: ##sys#check-closure */
t3=*((C_word*)lf[368]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=((C_word*)t0)[3];
av2[3]=lf[760];
((C_proc)(void*)(*((C_word*)t3+1)))(4,av2);}}

/* k19746 in k19743 in chicken.base#getter-with-setter in k19733 in k18957 in k18954 in k18951 in k18948 in k18944 in k18940 in k18424 in k18421 in k18418 in k18415 in k18412 in k18409 in k18406 in k18403 in k18400 in k18397 in k18394 in k18391 in ... */
static void C_ccall f_19748(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,c,2)))){
C_save_and_reclaim((void *)f_19748,c,av);}
a=C_alloc(5);
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_19751,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
if(C_truep(((C_word*)t0)[5])){
t3=C_i_check_string_2(((C_word*)t0)[5],lf[760]);
/* library.scm:3538: ##sys#make-lambda-info */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[751]);
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=*((C_word*)lf[751]+1);
av2[1]=t2;
av2[2]=((C_word*)t0)[5];
tp(3,av2);}}
else{
/* library.scm:3539: ##sys#lambda-info */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[753]);
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=*((C_word*)lf[753]+1);
av2[1]=t2;
av2[2]=((C_word*)t0)[4];
tp(3,av2);}}}

/* k19749 in k19746 in k19743 in chicken.base#getter-with-setter in k19733 in k18957 in k18954 in k18951 in k18948 in k18944 in k18940 in k18424 in k18421 in k18418 in k18415 in k18412 in k18409 in k18406 in k18403 in k18400 in k18397 in k18394 in ... */
static void C_ccall f_19751(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(8,c,2)))){
C_save_and_reclaim((void *)f_19751,c,av);}
a=C_alloc(8);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_19754,a[2]=t1,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_19770,a[2]=((C_word*)t0)[3],a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* library.scm:3541: ##sys#copy-closure */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[334]+1));
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=*((C_word*)lf[334]+1);
av2[1]=t3;
av2[2]=((C_word*)t0)[4];
tp(3,av2);}}

/* k19752 in k19749 in k19746 in k19743 in chicken.base#getter-with-setter in k19733 in k18957 in k18954 in k18951 in k18948 in k18944 in k18940 in k18424 in k18421 in k18418 in k18415 in k18412 in k18409 in k18406 in k18403 in k18400 in k18397 in ... */
static void C_ccall f_19754(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,4)))){
C_save_and_reclaim((void *)f_19754,c,av);}
a=C_alloc(4);
if(C_truep(((C_word*)t0)[2])){
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_19762,a[2]=((C_word*)t0)[2],a[3]=((C_word)li610),tmp=(C_word)a,a+=4,tmp);
/* library.scm:3547: ##sys#decorate-lambda */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[749]);
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=*((C_word*)lf[749]+1);
av2[1]=((C_word*)t0)[3];
av2[2]=t1;
av2[3]=C_fast_retrieve(lf[752]);
av2[4]=t2;
tp(5,av2);}}
else{
t2=((C_word*)t0)[3];{
C_word *av2=av;
av2[0]=t2;
av2[1]=t1;
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}}

/* a19761 in k19752 in k19749 in k19746 in k19743 in chicken.base#getter-with-setter in k19733 in k18957 in k18954 in k18951 in k18948 in k18944 in k18940 in k18424 in k18421 in k18418 in k18415 in k18412 in k18409 in k18406 in k18403 in k18400 in ... */
static void C_ccall f_19762(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_19762,c,av);}
t4=C_i_setslot(t2,t3,((C_word*)t0)[2]);
t5=t1;{
C_word *av2=av;
av2[0]=t5;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}

/* k19768 in k19749 in k19746 in k19743 in chicken.base#getter-with-setter in k19733 in k18957 in k18954 in k18951 in k18948 in k18944 in k18940 in k18424 in k18421 in k18418 in k18415 in k18412 in k18409 in k18406 in k18403 in k18400 in k18397 in ... */
static void C_ccall f_19770(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(7,c,4)))){
C_save_and_reclaim((void *)f_19770,c,av);}
a=C_alloc(7);
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_19772,a[2]=((C_word)li611),tmp=(C_word)a,a+=3,tmp);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_19788,a[2]=((C_word*)t0)[2],a[3]=((C_word)li612),tmp=(C_word)a,a+=4,tmp);
/* library.scm:3540: ##sys#decorate-lambda */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[749]);
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=*((C_word*)lf[749]+1);
av2[1]=((C_word*)t0)[3];
av2[2]=t1;
av2[3]=t2;
av2[4]=t3;
tp(5,av2);}}

/* a19771 in k19768 in k19749 in k19746 in k19743 in chicken.base#getter-with-setter in k19733 in k18957 in k18954 in k18951 in k18948 in k18944 in k18940 in k18424 in k18421 in k18418 in k18415 in k18412 in k18409 in k18406 in k18403 in k18400 in ... */
static void C_ccall f_19772(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_19772,c,av);}
t3=C_i_pairp(t2);
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=(C_truep(t3)?C_eqp(C_retrieve2(lf[758],C_text("setter-tag")),C_slot(t2,C_fix(0))):C_SCHEME_FALSE);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* a19787 in k19768 in k19749 in k19746 in k19743 in chicken.base#getter-with-setter in k19733 in k18957 in k18954 in k18951 in k18948 in k18944 in k18940 in k18424 in k18421 in k18418 in k18415 in k18412 in k18409 in k18406 in k18403 in k18400 in ... */
static void C_ccall f_19788(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(3,c,1)))){
C_save_and_reclaim((void *)f_19788,c,av);}
a=C_alloc(3);
t4=C_a_i_cons(&a,2,C_retrieve2(lf[758],C_text("setter-tag")),((C_word*)t0)[2]);
t5=C_i_setslot(t2,t3,t4);
t6=t1;{
C_word *av2=av;
av2[0]=t6;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}

/* k19813 in k19733 in k18957 in k18954 in k18951 in k18948 in k18944 in k18940 in k18424 in k18421 in k18418 in k18415 in k18412 in k18409 in k18406 in k18403 in k18400 in k18397 in k18394 in k18391 in k18388 in k18385 in ... */
static void C_ccall f_19815(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,c,3)))){
C_save_and_reclaim((void *)f_19815,c,av);}
a=C_alloc(3);
t2=C_mutate((C_word*)lf[9]+1 /* (set! scheme#car ...) */,t1);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_19819,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
/* library.scm:3556: chicken.base#getter-with-setter */
t4=*((C_word*)lf[200]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t4;
av2[1]=t3;
av2[2]=*((C_word*)lf[10]+1);
av2[3]=*((C_word*)lf[12]+1);
((C_proc)(void*)(*((C_word*)t4+1)))(4,av2);}}

/* k19817 in k19813 in k19733 in k18957 in k18954 in k18951 in k18948 in k18944 in k18940 in k18424 in k18421 in k18418 in k18415 in k18412 in k18409 in k18406 in k18403 in k18400 in k18397 in k18394 in k18391 in k18388 in ... */
static void C_ccall f_19819(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(6,c,4)))){
C_save_and_reclaim((void *)f_19819,c,av);}
a=C_alloc(6);
t2=C_mutate((C_word*)lf[10]+1 /* (set! scheme#cdr ...) */,t1);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_19823,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_31943,a[2]=((C_word)li999),tmp=(C_word)a,a+=3,tmp);
/* library.scm:3557: chicken.base#getter-with-setter */
t5=*((C_word*)lf[200]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t5;
av2[1]=t3;
av2[2]=*((C_word*)lf[17]+1);
av2[3]=t4;
((C_proc)(void*)(*((C_word*)t5+1)))(4,av2);}}

/* k19821 in k19817 in k19813 in k19733 in k18957 in k18954 in k18951 in k18948 in k18944 in k18940 in k18424 in k18421 in k18418 in k18415 in k18412 in k18409 in k18406 in k18403 in k18400 in k18397 in k18394 in k18391 in ... */
static void C_ccall f_19823(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(6,c,4)))){
C_save_and_reclaim((void *)f_19823,c,av);}
a=C_alloc(6);
t2=C_mutate((C_word*)lf[17]+1 /* (set! scheme#caar ...) */,t1);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_19827,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_31933,a[2]=((C_word)li998),tmp=(C_word)a,a+=3,tmp);
/* library.scm:3558: chicken.base#getter-with-setter */
t5=*((C_word*)lf[200]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t5;
av2[1]=t3;
av2[2]=*((C_word*)lf[13]+1);
av2[3]=t4;
((C_proc)(void*)(*((C_word*)t5+1)))(4,av2);}}

/* k19825 in k19821 in k19817 in k19813 in k19733 in k18957 in k18954 in k18951 in k18948 in k18944 in k18940 in k18424 in k18421 in k18418 in k18415 in k18412 in k18409 in k18406 in k18403 in k18400 in k18397 in k18394 in ... */
static void C_ccall f_19827(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(6,c,4)))){
C_save_and_reclaim((void *)f_19827,c,av);}
a=C_alloc(6);
t2=C_mutate((C_word*)lf[13]+1 /* (set! scheme#cadr ...) */,t1);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_19831,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_31923,a[2]=((C_word)li997),tmp=(C_word)a,a+=3,tmp);
/* library.scm:3559: chicken.base#getter-with-setter */
t5=*((C_word*)lf[200]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t5;
av2[1]=t3;
av2[2]=*((C_word*)lf[18]+1);
av2[3]=t4;
((C_proc)(void*)(*((C_word*)t5+1)))(4,av2);}}

/* k19829 in k19825 in k19821 in k19817 in k19813 in k19733 in k18957 in k18954 in k18951 in k18948 in k18944 in k18940 in k18424 in k18421 in k18418 in k18415 in k18412 in k18409 in k18406 in k18403 in k18400 in k18397 in ... */
static void C_ccall f_19831(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(6,c,4)))){
C_save_and_reclaim((void *)f_19831,c,av);}
a=C_alloc(6);
t2=C_mutate((C_word*)lf[18]+1 /* (set! scheme#cdar ...) */,t1);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_19835,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_31913,a[2]=((C_word)li996),tmp=(C_word)a,a+=3,tmp);
/* library.scm:3560: chicken.base#getter-with-setter */
t5=*((C_word*)lf[200]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t5;
av2[1]=t3;
av2[2]=*((C_word*)lf[19]+1);
av2[3]=t4;
((C_proc)(void*)(*((C_word*)t5+1)))(4,av2);}}

/* k19833 in k19829 in k19825 in k19821 in k19817 in k19813 in k19733 in k18957 in k18954 in k18951 in k18948 in k18944 in k18940 in k18424 in k18421 in k18418 in k18415 in k18412 in k18409 in k18406 in k18403 in k18400 in ... */
static void C_ccall f_19835(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(6,c,4)))){
C_save_and_reclaim((void *)f_19835,c,av);}
a=C_alloc(6);
t2=C_mutate((C_word*)lf[19]+1 /* (set! scheme#cddr ...) */,t1);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_19839,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_31903,a[2]=((C_word)li995),tmp=(C_word)a,a+=3,tmp);
/* library.scm:3561: chicken.base#getter-with-setter */
t5=*((C_word*)lf[200]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t5;
av2[1]=t3;
av2[2]=*((C_word*)lf[20]+1);
av2[3]=t4;
((C_proc)(void*)(*((C_word*)t5+1)))(4,av2);}}

/* k19837 in k19833 in k19829 in k19825 in k19821 in k19817 in k19813 in k19733 in k18957 in k18954 in k18951 in k18948 in k18944 in k18940 in k18424 in k18421 in k18418 in k18415 in k18412 in k18409 in k18406 in k18403 in ... */
static void C_ccall f_19839(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(6,c,4)))){
C_save_and_reclaim((void *)f_19839,c,av);}
a=C_alloc(6);
t2=C_mutate((C_word*)lf[20]+1 /* (set! scheme#caaar ...) */,t1);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_19843,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_31893,a[2]=((C_word)li994),tmp=(C_word)a,a+=3,tmp);
/* library.scm:3562: chicken.base#getter-with-setter */
t5=*((C_word*)lf[200]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t5;
av2[1]=t3;
av2[2]=*((C_word*)lf[21]+1);
av2[3]=t4;
((C_proc)(void*)(*((C_word*)t5+1)))(4,av2);}}

/* k19841 in k19837 in k19833 in k19829 in k19825 in k19821 in k19817 in k19813 in k19733 in k18957 in k18954 in k18951 in k18948 in k18944 in k18940 in k18424 in k18421 in k18418 in k18415 in k18412 in k18409 in k18406 in ... */
static void C_ccall f_19843(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(6,c,4)))){
C_save_and_reclaim((void *)f_19843,c,av);}
a=C_alloc(6);
t2=C_mutate((C_word*)lf[21]+1 /* (set! scheme#caadr ...) */,t1);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_19847,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_31883,a[2]=((C_word)li993),tmp=(C_word)a,a+=3,tmp);
/* library.scm:3563: chicken.base#getter-with-setter */
t5=*((C_word*)lf[200]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t5;
av2[1]=t3;
av2[2]=*((C_word*)lf[22]+1);
av2[3]=t4;
((C_proc)(void*)(*((C_word*)t5+1)))(4,av2);}}

/* k19845 in k19841 in k19837 in k19833 in k19829 in k19825 in k19821 in k19817 in k19813 in k19733 in k18957 in k18954 in k18951 in k18948 in k18944 in k18940 in k18424 in k18421 in k18418 in k18415 in k18412 in k18409 in ... */
static void C_ccall f_19847(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(6,c,4)))){
C_save_and_reclaim((void *)f_19847,c,av);}
a=C_alloc(6);
t2=C_mutate((C_word*)lf[22]+1 /* (set! scheme#cadar ...) */,t1);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_19851,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_31873,a[2]=((C_word)li992),tmp=(C_word)a,a+=3,tmp);
/* library.scm:3564: chicken.base#getter-with-setter */
t5=*((C_word*)lf[200]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t5;
av2[1]=t3;
av2[2]=*((C_word*)lf[14]+1);
av2[3]=t4;
((C_proc)(void*)(*((C_word*)t5+1)))(4,av2);}}

/* k19849 in k19845 in k19841 in k19837 in k19833 in k19829 in k19825 in k19821 in k19817 in k19813 in k19733 in k18957 in k18954 in k18951 in k18948 in k18944 in k18940 in k18424 in k18421 in k18418 in k18415 in k18412 in ... */
static void C_ccall f_19851(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(6,c,4)))){
C_save_and_reclaim((void *)f_19851,c,av);}
a=C_alloc(6);
t2=C_mutate((C_word*)lf[14]+1 /* (set! scheme#caddr ...) */,t1);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_19855,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_31863,a[2]=((C_word)li991),tmp=(C_word)a,a+=3,tmp);
/* library.scm:3565: chicken.base#getter-with-setter */
t5=*((C_word*)lf[200]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t5;
av2[1]=t3;
av2[2]=*((C_word*)lf[23]+1);
av2[3]=t4;
((C_proc)(void*)(*((C_word*)t5+1)))(4,av2);}}

/* k19853 in k19849 in k19845 in k19841 in k19837 in k19833 in k19829 in k19825 in k19821 in k19817 in k19813 in k19733 in k18957 in k18954 in k18951 in k18948 in k18944 in k18940 in k18424 in k18421 in k18418 in k18415 in ... */
static void C_ccall f_19855(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(6,c,4)))){
C_save_and_reclaim((void *)f_19855,c,av);}
a=C_alloc(6);
t2=C_mutate((C_word*)lf[23]+1 /* (set! scheme#cdaar ...) */,t1);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_19859,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_31853,a[2]=((C_word)li990),tmp=(C_word)a,a+=3,tmp);
/* library.scm:3566: chicken.base#getter-with-setter */
t5=*((C_word*)lf[200]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t5;
av2[1]=t3;
av2[2]=*((C_word*)lf[24]+1);
av2[3]=t4;
((C_proc)(void*)(*((C_word*)t5+1)))(4,av2);}}

/* k19857 in k19853 in k19849 in k19845 in k19841 in k19837 in k19833 in k19829 in k19825 in k19821 in k19817 in k19813 in k19733 in k18957 in k18954 in k18951 in k18948 in k18944 in k18940 in k18424 in k18421 in k18418 in ... */
static void C_ccall f_19859(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(6,c,4)))){
C_save_and_reclaim((void *)f_19859,c,av);}
a=C_alloc(6);
t2=C_mutate((C_word*)lf[24]+1 /* (set! scheme#cdadr ...) */,t1);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_19863,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_31843,a[2]=((C_word)li989),tmp=(C_word)a,a+=3,tmp);
/* library.scm:3567: chicken.base#getter-with-setter */
t5=*((C_word*)lf[200]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t5;
av2[1]=t3;
av2[2]=*((C_word*)lf[25]+1);
av2[3]=t4;
((C_proc)(void*)(*((C_word*)t5+1)))(4,av2);}}

/* k19861 in k19857 in k19853 in k19849 in k19845 in k19841 in k19837 in k19833 in k19829 in k19825 in k19821 in k19817 in k19813 in k19733 in k18957 in k18954 in k18951 in k18948 in k18944 in k18940 in k18424 in k18421 in ... */
static void C_ccall f_19863(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(6,c,4)))){
C_save_and_reclaim((void *)f_19863,c,av);}
a=C_alloc(6);
t2=C_mutate((C_word*)lf[25]+1 /* (set! scheme#cddar ...) */,t1);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_19867,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_31833,a[2]=((C_word)li988),tmp=(C_word)a,a+=3,tmp);
/* library.scm:3568: chicken.base#getter-with-setter */
t5=*((C_word*)lf[200]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t5;
av2[1]=t3;
av2[2]=*((C_word*)lf[26]+1);
av2[3]=t4;
((C_proc)(void*)(*((C_word*)t5+1)))(4,av2);}}

/* k19865 in k19861 in k19857 in k19853 in k19849 in k19845 in k19841 in k19837 in k19833 in k19829 in k19825 in k19821 in k19817 in k19813 in k19733 in k18957 in k18954 in k18951 in k18948 in k18944 in k18940 in k18424 in ... */
static void C_ccall f_19867(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,c,3)))){
C_save_and_reclaim((void *)f_19867,c,av);}
a=C_alloc(3);
t2=C_mutate((C_word*)lf[26]+1 /* (set! scheme#cdddr ...) */,t1);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_19871,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
/* library.scm:3569: chicken.base#getter-with-setter */
t4=*((C_word*)lf[200]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t4;
av2[1]=t3;
av2[2]=*((C_word*)lf[58]+1);
av2[3]=*((C_word*)lf[59]+1);
((C_proc)(void*)(*((C_word*)t4+1)))(4,av2);}}

/* k19869 in k19865 in k19861 in k19857 in k19853 in k19849 in k19845 in k19841 in k19837 in k19833 in k19829 in k19825 in k19821 in k19817 in k19813 in k19733 in k18957 in k18954 in k18951 in k18948 in k18944 in k18940 in ... */
static void C_ccall f_19871(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,c,3)))){
C_save_and_reclaim((void *)f_19871,c,av);}
a=C_alloc(3);
t2=C_mutate((C_word*)lf[58]+1 /* (set! scheme#string-ref ...) */,t1);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_19875,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
/* library.scm:3570: chicken.base#getter-with-setter */
t4=*((C_word*)lf[200]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t4;
av2[1]=t3;
av2[2]=*((C_word*)lf[91]+1);
av2[3]=*((C_word*)lf[92]+1);
((C_proc)(void*)(*((C_word*)t4+1)))(4,av2);}}

/* k19873 in k19869 in k19865 in k19861 in k19857 in k19853 in k19849 in k19845 in k19841 in k19837 in k19833 in k19829 in k19825 in k19821 in k19817 in k19813 in k19733 in k18957 in k18954 in k18951 in k18948 in k18944 in ... */
static void C_ccall f_19875(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(6,c,5)))){
C_save_and_reclaim((void *)f_19875,c,av);}
a=C_alloc(6);
t2=C_mutate((C_word*)lf[91]+1 /* (set! scheme#vector-ref ...) */,t1);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_19879,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_31823,a[2]=((C_word)li987),tmp=(C_word)a,a+=3,tmp);
/* library.scm:3573: chicken.base#getter-with-setter */
t5=*((C_word*)lf[200]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t5;
av2[1]=t3;
av2[2]=*((C_word*)lf[45]+1);
av2[3]=t4;
((C_proc)(void*)(*((C_word*)t5+1)))(4,av2);}}

/* k19877 in k19873 in k19869 in k19865 in k19861 in k19857 in k19853 in k19849 in k19845 in k19841 in k19837 in k19833 in k19829 in k19825 in k19821 in k19817 in k19813 in k19733 in k18957 in k18954 in k18951 in k18948 in ... */
static void C_ccall f_19879(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word t19;
C_word t20;
C_word t21;
C_word t22;
C_word t23;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(56,c,4)))){
C_save_and_reclaim((void *)f_19879,c,av);}
a=C_alloc(56);
t2=C_mutate((C_word*)lf[45]+1 /* (set! scheme#list-ref ...) */,t1);
t3=C_SCHEME_UNDEFINED;
t4=C_a_i_vector(&a,16,t3,t3,t3,t3,t3,t3,t3,t3,t3,t3,t3,t3,t3,t3,t3,t3);
t5=C_mutate(&lf[761] /* (set! ##sys#default-parameter-vector ...) */,t4);
t6=C_mutate((C_word*)lf[762]+1 /* (set! ##sys#current-parameter-vector ...) */,lf[763]);
t7=C_fix(0);
t8=(*a=C_VECTOR_TYPE|1,a[1]=t7,tmp=(C_word)a,a+=2,tmp);
t9=C_mutate((C_word*)lf[201]+1 /* (set! chicken.base#make-parameter ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_19886,a[2]=t8,a[3]=((C_word)li621),tmp=(C_word)a,a+=4,tmp));
t10=C_mutate((C_word*)lf[146]+1 /* (set! scheme#char-ready? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_20050,a[2]=((C_word)li622),tmp=(C_word)a,a+=3,tmp));
t11=C_mutate((C_word*)lf[147]+1 /* (set! scheme#read-char ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_20075,a[2]=((C_word)li623),tmp=(C_word)a,a+=3,tmp));
t12=C_mutate((C_word*)lf[765]+1 /* (set! ##sys#read-char-0 ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_20093,a[2]=((C_word)li624),tmp=(C_word)a,a+=3,tmp));
t13=C_mutate((C_word*)lf[766]+1 /* (set! ##sys#read-char/port ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_20153,a[2]=((C_word)li625),tmp=(C_word)a,a+=3,tmp));
t14=C_mutate((C_word*)lf[767]+1 /* (set! ##sys#peek-char-0 ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_20162,a[2]=((C_word)li626),tmp=(C_word)a,a+=3,tmp));
t15=C_mutate((C_word*)lf[148]+1 /* (set! scheme#peek-char ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_20187,a[2]=((C_word)li627),tmp=(C_word)a,a+=3,tmp));
t16=C_mutate((C_word*)lf[149]+1 /* (set! scheme#read ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_20205,a[2]=((C_word)li628),tmp=(C_word)a,a+=3,tmp));
t17=C_set_block_item(lf[769] /* ##sys#default-read-info-hook */,0,C_SCHEME_FALSE);
t18=C_set_block_item(lf[770] /* ##sys#read-error-with-line-number */,0,C_SCHEME_FALSE);
t19=C_mutate((C_word*)lf[771]+1 /* (set! ##sys#read-prompt-hook ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_20225,a[2]=((C_word)li629),tmp=(C_word)a,a+=3,tmp));
t20=C_mutate((C_word*)lf[772]+1 /* (set! ##sys#infix-list-hook ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_20228,a[2]=((C_word)li630),tmp=(C_word)a,a+=3,tmp));
t21=C_mutate((C_word*)lf[773]+1 /* (set! ##sys#sharp-number-hook ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_20231,a[2]=((C_word)li631),tmp=(C_word)a,a+=3,tmp));
t22=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_20239,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
/* library.scm:3683: chicken.base#make-parameter */
t23=*((C_word*)lf[201]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t23;
av2[1]=t22;
av2[2]=C_SCHEME_TRUE;
((C_proc)(void*)(*((C_word*)t23+1)))(3,av2);}}

/* chicken.base#make-parameter in k19877 in k19873 in k19869 in k19865 in k19861 in k19857 in k19853 in k19849 in k19845 in k19841 in k19837 in k19833 in k19829 in k19825 in k19821 in k19817 in k19813 in k19733 in k18957 in k18954 in k18951 in ... */
static void C_ccall f_19886(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(8,c,3)))){
C_save_and_reclaim((void *)f_19886,c,av);}
a=C_alloc(8);
t3=C_rest_nullp(c,3);
t4=(C_truep(t3)?(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_20044,a[2]=((C_word)li614),tmp=(C_word)a,a+=3,tmp):C_get_rest_arg(c,3,av,3,t0));
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_19893,a[2]=((C_word*)t0)[2],a[3]=t4,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
/* library.scm:3586: guard */
t6=t4;{
C_word *av2=av;
av2[0]=t6;
av2[1]=t5;
av2[2]=t2;
((C_proc)C_fast_retrieve_proc(t6))(3,av2);}}

/* k19891 in chicken.base#make-parameter in k19877 in k19873 in k19869 in k19865 in k19861 in k19857 in k19853 in k19849 in k19845 in k19841 in k19837 in k19833 in k19829 in k19825 in k19821 in k19817 in k19813 in k19733 in k18957 in k18954 in ... */
static void C_ccall f_19893(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(14,c,6)))){
C_save_and_reclaim((void *)f_19893,c,av);}
a=C_alloc(14);
t2=((C_word*)((C_word*)t0)[2])[1];
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_19894,a[2]=t2,a[3]=((C_word*)t0)[3],a[4]=((C_word)li615),tmp=(C_word)a,a+=5,tmp);
t4=C_fixnum_plus(((C_word*)((C_word*)t0)[2])[1],C_fix(1));
t5=C_set_block_item(((C_word*)t0)[2],0,t4);
t6=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_19928,a[2]=t2,a[3]=t1,a[4]=t3,a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
t7=C_block_size(C_retrieve2(lf[761],C_text("##sys#default-parameter-vector")));
if(C_truep(C_fixnum_greater_or_equal_p(t2,t7))){
t8=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_20032,a[2]=t6,tmp=(C_word)a,a+=3,tmp);
/* library.scm:3603: ##sys#vector-resize */
f_18128(t8,C_retrieve2(lf[761],C_text("##sys#default-parameter-vector")),C_fixnum_plus(t2,C_fix(1)),C_SCHEME_UNDEFINED);}
else{
t8=t6;
f_19928(t8,C_SCHEME_UNDEFINED);}}

/* assign in k19891 in chicken.base#make-parameter in k19877 in k19873 in k19869 in k19865 in k19861 in k19857 in k19853 in k19849 in k19845 in k19841 in k19837 in k19833 in k19829 in k19825 in k19821 in k19817 in k19813 in k19733 in k18957 in ... */
static void C_fcall f_19894(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5){
C_word tmp;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(11,0,4)))){
C_save_and_reclaim_args((void *)trf_19894,6,t0,t1,t2,t3,t4,t5);}
a=C_alloc(11);
t6=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_19898,a[2]=t5,a[3]=((C_word*)t0)[2],a[4]=t1,a[5]=t4,a[6]=((C_word*)t0)[3],a[7]=t2,tmp=(C_word)a,a+=8,tmp);
if(C_truep(C_fixnum_greater_or_equal_p(((C_word*)t0)[2],t3))){
t7=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_19917,a[2]=t6,tmp=(C_word)a,a+=3,tmp);
/* library.scm:3591: ##sys#vector-resize */
f_18128(t7,C_fast_retrieve(lf[762]),C_fixnum_plus(((C_word*)t0)[2],C_fix(1)),*((C_word*)lf[627]+1));}
else{
t7=t6;
f_19898(t7,C_SCHEME_UNDEFINED);}}

/* k19896 in assign in k19891 in chicken.base#make-parameter in k19877 in k19873 in k19869 in k19865 in k19861 in k19857 in k19853 in k19849 in k19845 in k19841 in k19837 in k19833 in k19829 in k19825 in k19821 in k19817 in k19813 in k19733 in ... */
static void C_fcall f_19898(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,0,2)))){
C_save_and_reclaim_args((void *)trf_19898,2,t0,t1);}
a=C_alloc(5);
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_19901,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
if(C_truep(((C_word*)t0)[5])){
/* library.scm:3595: guard */
t3=((C_word*)t0)[6];{
C_word av2[3];
av2[0]=t3;
av2[1]=t2;
av2[2]=((C_word*)t0)[7];
((C_proc)C_fast_retrieve_proc(t3))(3,av2);}}
else{
t3=t2;{
C_word av2[2];
av2[0]=t3;
av2[1]=((C_word*)t0)[7];
f_19901(2,av2);}}}

/* k19899 in k19896 in assign in k19891 in chicken.base#make-parameter in k19877 in k19873 in k19869 in k19865 in k19861 in k19857 in k19853 in k19849 in k19845 in k19841 in k19837 in k19833 in k19829 in k19825 in k19821 in k19817 in k19813 in ... */
static void C_ccall f_19901(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_19901,c,av);}
if(C_truep(((C_word*)t0)[2])){
t2=C_i_setslot(C_fast_retrieve(lf[762]),((C_word*)t0)[3],t1);
t3=((C_word*)t0)[4];{
C_word *av2=av;
av2[0]=t3;
av2[1]=t1;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
t2=((C_word*)t0)[4];{
C_word *av2=av;
av2[0]=t2;
av2[1]=t1;
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}}

/* k19915 in assign in k19891 in chicken.base#make-parameter in k19877 in k19873 in k19869 in k19865 in k19861 in k19857 in k19853 in k19849 in k19845 in k19841 in k19837 in k19833 in k19829 in k19825 in k19821 in k19817 in k19813 in k19733 in ... */
static void C_ccall f_19917(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_19917,c,av);}
t2=C_mutate((C_word*)lf[762]+1 /* (set! ##sys#current-parameter-vector ...) */,t1);
t3=((C_word*)t0)[2];
f_19898(t3,t2);}

/* k19926 in k19891 in chicken.base#make-parameter in k19877 in k19873 in k19869 in k19865 in k19861 in k19857 in k19853 in k19849 in k19845 in k19841 in k19837 in k19833 in k19829 in k19825 in k19821 in k19817 in k19813 in k19733 in k18957 in ... */
static void C_fcall f_19928(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(9,0,3)))){
C_save_and_reclaim_args((void *)trf_19928,2,t0,t1);}
a=C_alloc(9);
t2=C_i_setslot(C_retrieve2(lf[761],C_text("##sys#default-parameter-vector")),((C_word*)t0)[2],((C_word*)t0)[3]);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_19936,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[2],a[4]=((C_word)li619),tmp=(C_word)a,a+=5,tmp);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_20018,a[2]=((C_word*)t0)[4],a[3]=((C_word)li620),tmp=(C_word)a,a+=4,tmp);
/* library.scm:3609: chicken.base#getter-with-setter */
t5=*((C_word*)lf[200]+1);{
C_word av2[4];
av2[0]=t5;
av2[1]=((C_word*)t0)[5];
av2[2]=t3;
av2[3]=t4;
((C_proc)(void*)(*((C_word*)t5+1)))(4,av2);}}

/* a19935 in k19926 in k19891 in chicken.base#make-parameter in k19877 in k19873 in k19869 in k19865 in k19861 in k19857 in k19853 in k19849 in k19845 in k19841 in k19837 in k19833 in k19829 in k19825 in k19821 in k19817 in k19813 in k19733 in ... */
static void C_ccall f_19936(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand((c-2)*C_SIZEOF_PAIR +14,c,4)))){
C_save_and_reclaim((void*)f_19936,c,av);}
a=C_alloc((c-2)*C_SIZEOF_PAIR+14);
t2=C_build_rest(&a,c,2,av);
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
t3=C_block_size(C_fast_retrieve(lf[762]));
if(C_truep(C_i_pairp(t2))){
t4=C_u_i_cdr(t2);
t5=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_19948,a[2]=((C_word*)t0)[2],a[3]=t2,a[4]=t3,a[5]=((C_word)li616),tmp=(C_word)a,a+=6,tmp);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_19957,a[2]=t5,a[3]=((C_word)li617),tmp=(C_word)a,a+=4,tmp);
t7=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_19962,a[2]=t6,a[3]=((C_word)li618),tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_nullp(t4))){
/* library.scm:3613: def-convert?4265 */
t8=t7;
f_19962(t8,t1);}
else{
t8=C_i_car(t4);
t9=C_u_i_cdr(t4);
if(C_truep(C_i_nullp(t9))){
/* library.scm:3613: def-set?4266 */
t10=t6;
f_19957(t10,t1,t8);}
else{
t10=C_i_car(t9);
t11=C_u_i_cdr(t9);
/* library.scm:3613: body4263 */
t12=t5;
f_19948(t12,t1,t8,t10);}}}
else{
if(C_truep(C_fixnum_greater_or_equal_p(((C_word*)t0)[3],t3))){
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_slot(C_retrieve2(lf[761],C_text("##sys#default-parameter-vector")),((C_word*)t0)[3]);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t4=C_slot(C_fast_retrieve(lf[762]),((C_word*)t0)[3]);
t5=C_eqp(t4,*((C_word*)lf[627]+1));
t6=t1;{
C_word *av2=av;
av2[0]=t6;
av2[1]=(C_truep(t5)?C_slot(C_retrieve2(lf[761],C_text("##sys#default-parameter-vector")),((C_word*)t0)[3]):t4);
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}}}

/* body4263 in a19935 in k19926 in k19891 in chicken.base#make-parameter in k19877 in k19873 in k19869 in k19865 in k19861 in k19857 in k19853 in k19849 in k19845 in k19841 in k19837 in k19833 in k19829 in k19825 in k19821 in k19817 in k19813 in ... */
static void C_fcall f_19948(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,0,5)))){
C_save_and_reclaim_args((void *)trf_19948,4,t0,t1,t2,t3);}
/* library.scm:3615: assign */
t4=((C_word*)t0)[2];
f_19894(t4,t1,C_i_car(((C_word*)t0)[3]),((C_word*)t0)[4],t2,t3);}

/* def-set?4266 in a19935 in k19926 in k19891 in chicken.base#make-parameter in k19877 in k19873 in k19869 in k19865 in k19861 in k19857 in k19853 in k19849 in k19845 in k19841 in k19837 in k19833 in k19829 in k19825 in k19821 in k19817 in k19813 in ... */
static void C_fcall f_19957(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,0,3)))){
C_save_and_reclaim_args((void *)trf_19957,3,t0,t1,t2);}
/* library.scm:3613: body4263 */
t3=((C_word*)t0)[2];
f_19948(t3,t1,t2,C_SCHEME_TRUE);}

/* def-convert?4265 in a19935 in k19926 in k19891 in chicken.base#make-parameter in k19877 in k19873 in k19869 in k19865 in k19861 in k19857 in k19853 in k19849 in k19845 in k19841 in k19837 in k19833 in k19829 in k19825 in k19821 in k19817 in k19813 in ... */
static void C_fcall f_19962(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,0,2)))){
C_save_and_reclaim_args((void *)trf_19962,2,t0,t1);}
/* library.scm:3613: def-set?4266 */
t2=((C_word*)t0)[2];
f_19957(t2,t1,C_SCHEME_TRUE);}

/* a20017 in k19926 in k19891 in chicken.base#make-parameter in k19877 in k19873 in k19869 in k19865 in k19861 in k19857 in k19853 in k19849 in k19845 in k19841 in k19837 in k19833 in k19829 in k19825 in k19821 in k19817 in k19813 in k19733 in ... */
static void C_ccall f_20018(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,5)))){
C_save_and_reclaim((void *)f_20018,c,av);}
/* library.scm:3625: assign */
t3=((C_word*)t0)[2];
f_19894(t3,t1,t2,C_block_size(C_fast_retrieve(lf[762])),C_SCHEME_FALSE,C_SCHEME_TRUE);}

/* k20030 in k19891 in chicken.base#make-parameter in k19877 in k19873 in k19869 in k19865 in k19861 in k19857 in k19853 in k19849 in k19845 in k19841 in k19837 in k19833 in k19829 in k19825 in k19821 in k19817 in k19813 in k19733 in k18957 in ... */
static void C_ccall f_20032(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_20032,c,av);}
t2=C_mutate(&lf[761] /* (set! ##sys#default-parameter-vector ...) */,t1);
t3=((C_word*)t0)[2];
f_19928(t3,t2);}

/* f_20044 in chicken.base#make-parameter in k19877 in k19873 in k19869 in k19865 in k19861 in k19857 in k19853 in k19849 in k19845 in k19841 in k19837 in k19833 in k19829 in k19825 in k19821 in k19817 in k19813 in k19733 in k18957 in k18954 in ... */
static void C_ccall f_20044(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_20044,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* scheme#char-ready? in k19877 in k19873 in k19869 in k19865 in k19861 in k19857 in k19853 in k19849 in k19845 in k19841 in k19837 in k19833 in k19829 in k19825 in k19821 in k19817 in k19813 in k19733 in k18957 in k18954 in k18951 in ... */
static void C_ccall f_20050(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_20050,c,av);}
t2=C_rest_nullp(c,2);
t3=(C_truep(t2)?*((C_word*)lf[713]+1):C_get_rest_arg(c,2,av,2,t0));
t4=C_i_check_port_2(t3,C_fix(1),C_SCHEME_TRUE,lf[764]);
t5=C_slot(t3,C_fix(2));
/* library.scm:3631: g4298 */
t6=C_slot(t5,C_fix(6));{
C_word av2[3];
av2[0]=t6;
av2[1]=t1;
av2[2]=t3;
((C_proc)C_fast_retrieve_proc(t6))(3,av2);}}

/* scheme#read-char in k19877 in k19873 in k19869 in k19865 in k19861 in k19857 in k19853 in k19849 in k19845 in k19841 in k19837 in k19833 in k19829 in k19825 in k19821 in k19817 in k19813 in k19733 in k18957 in k18954 in k18951 in ... */
static void C_ccall f_20075(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_20075,c,av);}
if(C_truep(C_rest_nullp(c,2))){
t2=*((C_word*)lf[713]+1);
t3=C_i_check_port_2(*((C_word*)lf[713]+1),C_fix(1),C_SCHEME_TRUE,lf[700]);
/* library.scm:3638: ##sys#read-char-0 */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[765]);
C_word av2[3];
av2[0]=*((C_word*)lf[765]+1);
av2[1]=t1;
av2[2]=*((C_word*)lf[713]+1);
tp(3,av2);}}
else{
t2=C_get_rest_arg(c,2,av,2,t0);
t3=C_i_check_port_2(t2,C_fix(1),C_SCHEME_TRUE,lf[700]);
/* library.scm:3638: ##sys#read-char-0 */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[765]);
C_word av2[3];
av2[0]=*((C_word*)lf[765]+1);
av2[1]=t1;
av2[2]=t2;
tp(3,av2);}}}

/* ##sys#read-char-0 in k19877 in k19873 in k19869 in k19865 in k19861 in k19857 in k19853 in k19849 in k19845 in k19841 in k19837 in k19833 in k19829 in k19825 in k19821 in k19817 in k19813 in k19733 in k18957 in k18954 in k18951 in ... */
static void C_ccall f_20093(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(4,c,2)))){
C_save_and_reclaim((void *)f_20093,c,av);}
a=C_alloc(4);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_20097,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_slot(t2,C_fix(6)))){
t4=C_i_set_i_slot(t2,C_fix(6),C_SCHEME_FALSE);
t5=t3;{
C_word *av2=av;
av2[0]=t5;
av2[1]=C_SCHEME_END_OF_FILE;
f_20097(2,av2);}}
else{
t4=C_slot(t2,C_fix(2));
/* library.scm:3641: g4316 */
t5=C_slot(t4,C_fix(0));{
C_word *av2=av;
av2[0]=t5;
av2[1]=t3;
av2[2]=t2;
((C_proc)C_fast_retrieve_proc(t5))(3,av2);}}}

/* k20095 in ##sys#read-char-0 in k19877 in k19873 in k19869 in k19865 in k19861 in k19857 in k19853 in k19849 in k19845 in k19841 in k19837 in k19833 in k19829 in k19825 in k19821 in k19817 in k19813 in k19733 in k18957 in k18954 in ... */
static void C_ccall f_20097(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_20097,c,av);}
t2=C_eqp(t1,C_make_character(10));
if(C_truep(t2)){
t3=C_slot(((C_word*)t0)[2],C_fix(4));
t4=C_fixnum_plus(t3,C_fix(1));
t5=C_i_set_i_slot(((C_word*)t0)[2],C_fix(4),t4);
t6=C_i_set_i_slot(((C_word*)t0)[2],C_fix(5),C_fix(0));
t7=((C_word*)t0)[3];{
C_word *av2=av;
av2[0]=t7;
av2[1]=t1;
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}
else{
if(C_truep(C_i_not(C_eofp(t1)))){
t3=C_slot(((C_word*)t0)[2],C_fix(5));
t4=C_fixnum_plus(t3,C_fix(1));
t5=C_i_set_i_slot(((C_word*)t0)[2],C_fix(5),t4);
t6=((C_word*)t0)[3];{
C_word *av2=av;
av2[0]=t6;
av2[1]=t1;
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}
else{
t3=((C_word*)t0)[3];{
C_word *av2=av;
av2[0]=t3;
av2[1]=t1;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}}}

/* ##sys#read-char/port in k19877 in k19873 in k19869 in k19865 in k19861 in k19857 in k19853 in k19849 in k19845 in k19841 in k19837 in k19833 in k19829 in k19825 in k19821 in k19817 in k19813 in k19733 in k18957 in k18954 in k18951 in ... */
static void C_ccall f_20153(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_20153,c,av);}
t3=C_i_check_port_2(t2,C_fix(1),C_SCHEME_TRUE,lf[700]);
/* library.scm:3655: ##sys#read-char-0 */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[765]);
C_word *av2=av;
av2[0]=*((C_word*)lf[765]+1);
av2[1]=t1;
av2[2]=t2;
tp(3,av2);}}

/* ##sys#peek-char-0 in k19877 in k19873 in k19869 in k19865 in k19861 in k19857 in k19853 in k19849 in k19845 in k19841 in k19837 in k19833 in k19829 in k19825 in k19821 in k19817 in k19813 in k19733 in k18957 in k18954 in k18951 in ... */
static void C_ccall f_20162(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(4,c,2)))){
C_save_and_reclaim((void *)f_20162,c,av);}
a=C_alloc(4);
if(C_truep(C_slot(t2,C_fix(6)))){
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_SCHEME_END_OF_FILE;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
t3=C_slot(t2,C_fix(2));
t4=C_slot(t3,C_fix(1));
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_20175,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* library.scm:3660: g4330 */
t6=t4;{
C_word *av2=av;
av2[0]=t6;
av2[1]=t5;
av2[2]=t2;
((C_proc)C_fast_retrieve_proc(t6))(3,av2);}}}

/* k20173 in ##sys#peek-char-0 in k19877 in k19873 in k19869 in k19865 in k19861 in k19857 in k19853 in k19849 in k19845 in k19841 in k19837 in k19833 in k19829 in k19825 in k19821 in k19817 in k19813 in k19733 in k18957 in k18954 in ... */
static void C_ccall f_20175(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_20175,c,av);}
if(C_truep(C_eofp(t1))){
t2=C_i_set_i_slot(((C_word*)t0)[2],C_fix(6),C_SCHEME_TRUE);
t3=((C_word*)t0)[3];{
C_word *av2=av;
av2[0]=t3;
av2[1]=t1;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
t2=((C_word*)t0)[3];{
C_word *av2=av;
av2[0]=t2;
av2[1]=t1;
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}}

/* scheme#peek-char in k19877 in k19873 in k19869 in k19865 in k19861 in k19857 in k19853 in k19849 in k19845 in k19841 in k19837 in k19833 in k19829 in k19825 in k19821 in k19817 in k19813 in k19733 in k18957 in k18954 in k18951 in ... */
static void C_ccall f_20187(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_20187,c,av);}
if(C_truep(C_rest_nullp(c,2))){
t2=*((C_word*)lf[713]+1);
t3=C_i_check_port_2(*((C_word*)lf[713]+1),C_fix(1),C_SCHEME_TRUE,lf[704]);
/* library.scm:3668: ##sys#peek-char-0 */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[767]);
C_word av2[3];
av2[0]=*((C_word*)lf[767]+1);
av2[1]=t1;
av2[2]=*((C_word*)lf[713]+1);
tp(3,av2);}}
else{
t2=C_get_rest_arg(c,2,av,2,t0);
t3=C_i_check_port_2(t2,C_fix(1),C_SCHEME_TRUE,lf[704]);
/* library.scm:3668: ##sys#peek-char-0 */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[767]);
C_word av2[3];
av2[0]=*((C_word*)lf[767]+1);
av2[1]=t1;
av2[2]=t2;
tp(3,av2);}}}

/* scheme#read in k19877 in k19873 in k19869 in k19865 in k19861 in k19857 in k19853 in k19849 in k19845 in k19841 in k19837 in k19833 in k19829 in k19825 in k19821 in k19817 in k19813 in k19733 in k18957 in k18954 in k18951 in ... */
static void C_ccall f_20205(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_20205,c,av);}
if(C_truep(C_rest_nullp(c,2))){
t2=*((C_word*)lf[713]+1);
t3=C_i_check_port_2(*((C_word*)lf[713]+1),C_fix(1),C_SCHEME_TRUE,lf[768]);
/* library.scm:3673: ##sys#read */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[755]);
C_word av2[4];
av2[0]=*((C_word*)lf[755]+1);
av2[1]=t1;
av2[2]=*((C_word*)lf[713]+1);
av2[3]=C_fast_retrieve(lf[769]);
tp(4,av2);}}
else{
t2=C_get_rest_arg(c,2,av,2,t0);
t3=C_i_check_port_2(t2,C_fix(1),C_SCHEME_TRUE,lf[768]);
/* library.scm:3673: ##sys#read */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[755]);
C_word av2[4];
av2[0]=*((C_word*)lf[755]+1);
av2[1]=t1;
av2[2]=t2;
av2[3]=C_fast_retrieve(lf[769]);
tp(4,av2);}}}

/* ##sys#read-prompt-hook in k19877 in k19873 in k19869 in k19865 in k19861 in k19857 in k19853 in k19849 in k19845 in k19841 in k19837 in k19833 in k19829 in k19825 in k19821 in k19817 in k19813 in k19733 in k18957 in k18954 in k18951 in ... */
static void C_ccall f_20225(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_20225,c,av);}
t2=t1;{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* ##sys#infix-list-hook in k19877 in k19873 in k19869 in k19865 in k19861 in k19857 in k19853 in k19849 in k19845 in k19841 in k19837 in k19833 in k19829 in k19825 in k19821 in k19817 in k19813 in k19733 in k18957 in k18954 in k18951 in ... */
static void C_ccall f_20228(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_20228,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* ##sys#sharp-number-hook in k19877 in k19873 in k19869 in k19865 in k19861 in k19857 in k19853 in k19849 in k19845 in k19841 in k19837 in k19833 in k19829 in k19825 in k19821 in k19817 in k19813 in k19733 in k18957 in k18954 in k18951 in ... */
static void C_ccall f_20231(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,4)))){
C_save_and_reclaim((void *)f_20231,c,av);}
/* library.scm:3681: ##sys#read-error */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[774]);
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=*((C_word*)lf[774]+1);
av2[1]=t1;
av2[2]=t2;
av2[3]=lf[775];
av2[4]=t3;
tp(5,av2);}}

/* k20237 in k19877 in k19873 in k19869 in k19865 in k19861 in k19857 in k19853 in k19849 in k19845 in k19841 in k19837 in k19833 in k19829 in k19825 in k19821 in k19817 in k19813 in k19733 in k18957 in k18954 in k18951 in ... */
static void C_ccall f_20239(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,c,2)))){
C_save_and_reclaim((void *)f_20239,c,av);}
a=C_alloc(3);
t2=C_mutate((C_word*)lf[232]+1 /* (set! chicken.base#case-sensitive ...) */,t1);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_20243,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
/* library.scm:3684: chicken.base#make-parameter */
t4=*((C_word*)lf[201]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t4;
av2[1]=t3;
av2[2]=C_SCHEME_TRUE;
((C_proc)(void*)(*((C_word*)t4+1)))(3,av2);}}

/* k20241 in k20237 in k19877 in k19873 in k19869 in k19865 in k19861 in k19857 in k19853 in k19849 in k19845 in k19841 in k19837 in k19833 in k19829 in k19825 in k19821 in k19817 in k19813 in k19733 in k18957 in k18954 in ... */
static void C_ccall f_20243(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,c,2)))){
C_save_and_reclaim((void *)f_20243,c,av);}
a=C_alloc(3);
t2=C_mutate((C_word*)lf[234]+1 /* (set! chicken.base#parentheses-synonyms ...) */,t1);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_20247,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
/* library.scm:3685: chicken.base#make-parameter */
t4=*((C_word*)lf[201]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t4;
av2[1]=t3;
av2[2]=C_SCHEME_TRUE;
((C_proc)(void*)(*((C_word*)t4+1)))(3,av2);}}

/* k20245 in k20241 in k20237 in k19877 in k19873 in k19869 in k19865 in k19861 in k19857 in k19853 in k19849 in k19845 in k19841 in k19837 in k19833 in k19829 in k19825 in k19821 in k19817 in k19813 in k19733 in k18957 in ... */
static void C_ccall f_20247(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(6,c,3)))){
C_save_and_reclaim((void *)f_20247,c,av);}
a=C_alloc(6);
t2=C_mutate((C_word*)lf[235]+1 /* (set! chicken.base#symbol-escape ...) */,t1);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_20251,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_31814,a[2]=((C_word)li986),tmp=(C_word)a,a+=3,tmp);
/* library.scm:3688: chicken.base#make-parameter */
t5=*((C_word*)lf[201]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t5;
av2[1]=t3;
av2[2]=lf[811];
av2[3]=t4;
((C_proc)(void*)(*((C_word*)t5+1)))(4,av2);}}

/* k20249 in k20245 in k20241 in k20237 in k19877 in k19873 in k19869 in k19865 in k19861 in k19857 in k19853 in k19849 in k19845 in k19841 in k19837 in k19833 in k19829 in k19825 in k19821 in k19817 in k19813 in k19733 in ... */
static void C_ccall f_20251(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(8,c,2)))){
C_save_and_reclaim((void *)f_20251,c,av);}
a=C_alloc(8);
t2=C_mutate((C_word*)lf[233]+1 /* (set! chicken.base#keyword-style ...) */,t1);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_20255,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t4=C_a_i_record4(&a,4,lf[1383],C_SCHEME_FALSE,C_SCHEME_FALSE,C_SCHEME_FALSE);
/* library.scm:3690: chicken.base#make-parameter */
t5=*((C_word*)lf[201]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t5;
av2[1]=t3;
av2[2]=t4;
((C_proc)(void*)(*((C_word*)t5+1)))(3,av2);}}

/* k20253 in k20249 in k20245 in k20241 in k20237 in k19877 in k19873 in k19869 in k19865 in k19861 in k19857 in k19853 in k19849 in k19845 in k19841 in k19837 in k19833 in k19829 in k19825 in k19821 in k19817 in k19813 in ... */
static void C_ccall f_20255(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word t19;
C_word t20;
C_word t21;
C_word t22;
C_word t23;
C_word t24;
C_word t25;
C_word t26;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(56,c,4)))){
C_save_and_reclaim((void *)f_20255,c,av);}
a=C_alloc(56);
t2=C_mutate((C_word*)lf[776]+1 /* (set! ##sys#current-read-table ...) */,t1);
t3=C_mutate((C_word*)lf[777]+1 /* (set! ##sys#read-warning ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_20257,a[2]=((C_word)li632),tmp=(C_word)a,a+=3,tmp));
t4=C_mutate((C_word*)lf[774]+1 /* (set! ##sys#read-error ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_20280,a[2]=((C_word)li633),tmp=(C_word)a,a+=3,tmp));
t5=*((C_word*)lf[233]+1);
t6=*((C_word*)lf[232]+1);
t7=*((C_word*)lf[234]+1);
t8=*((C_word*)lf[235]+1);
t9=C_fast_retrieve(lf[776]);
t10=C_mutate((C_word*)lf[755]+1 /* (set! ##sys#read ...) */,(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_20303,a[2]=t9,a[3]=t8,a[4]=t7,a[5]=t5,a[6]=t6,a[7]=((C_word)li689),tmp=(C_word)a,a+=8,tmp));
t11=C_mutate((C_word*)lf[789]+1 /* (set! ##sys#char->utf8-string ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_23151,a[2]=((C_word)li690),tmp=(C_word)a,a+=3,tmp));
t12=C_mutate((C_word*)lf[796]+1 /* (set! ##sys#unicode-surrogate? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_23316,a[2]=((C_word)li691),tmp=(C_word)a,a+=3,tmp));
t13=C_mutate((C_word*)lf[793]+1 /* (set! ##sys#surrogates->codepoint ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_23328,a[2]=((C_word)li692),tmp=(C_word)a,a+=3,tmp));
t14=C_mutate((C_word*)lf[843]+1 /* (set! ##sys#read-bytevector-literal ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_23390,a[2]=((C_word)li695),tmp=(C_word)a,a+=3,tmp));
t15=C_mutate((C_word*)lf[855]+1 /* (set! ##sys#user-read-hook ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_23538,a[2]=((C_word)li696),tmp=(C_word)a,a+=3,tmp));
t16=C_set_block_item(lf[853] /* ##sys#read-marks */,0,C_SCHEME_END_OF_LIST);
t17=C_mutate((C_word*)lf[862]+1 /* (set! ##sys#write-char-0 ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_23583,a[2]=((C_word)li697),tmp=(C_word)a,a+=3,tmp));
t18=C_mutate((C_word*)lf[863]+1 /* (set! ##sys#write-char/port ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_23599,a[2]=((C_word)li698),tmp=(C_word)a,a+=3,tmp));
t19=C_mutate((C_word*)lf[150]+1 /* (set! scheme#write-char ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_23611,a[2]=((C_word)li699),tmp=(C_word)a,a+=3,tmp));
t20=C_mutate((C_word*)lf[151]+1 /* (set! scheme#newline ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_23632,a[2]=((C_word)li700),tmp=(C_word)a,a+=3,tmp));
t21=C_mutate((C_word*)lf[152]+1 /* (set! scheme#