### README first

This section of the documentation contains a guide for Moby project users who want to
contribute code or documentation to the Moby Engine project. As a community, we
share rules of behavior and interaction. Make sure you are familiar with the <a
href="https://github.com/moby/moby/blob/master/CONTRIBUTING.md#moby-community-guidelines"
target="_blank">community guidelines</a> before continuing.

## Where and what you can contribute

The Moby project consists of not just one but several repositories on GitHub.
So, in addition to the `moby/moby` repository, there is the
`containerd/containerd` repo, the `moby/buildkit` repo, and several more.
Contribute to any of these and you contribute to the Moby project.

Not all Moby repositories use the Go language. Also, each repository has its
own focus area. So, if you are an experienced contributor, think about
contributing to a Moby project repository that has a language or a focus area you are
familiar with.

If you are new to the open source community, to Moby, or to formal
programming, you should start out contributing to the `moby/moby`
repository. Why? Because this guide is written for that repository specifically.

Finally, code or documentation isn't the only way to contribute. You can report
an issue, add to discussions in our community channel, write a blog post, or
take a usability test. You can even propose your own type of contribution.
Right now we don't have a lot written about this yet, but feel free to open an issue
to discuss other contributions.

## How to use this guide

This is written for the distracted, the overworked, the sloppy reader with fair
`git` skills and a failing memory for the GitHub GUI. The guide attempts to
explain how to use the Moby Engine development environment as precisely,
predictably, and procedurally as possible.

Users who are new to Engine development should start by setting up their
environment. Then, they should try a simple code change. After that, you should
find something to work on or propose a totally new change.

If you are a programming prodigy, you still may find this documentation useful.
Please feel free to skim past information you find obvious or boring.

## How to get started

Start by getting the software you require. If you are on Mac or Linux, go to
[get the required software for Linux or macOS](software-required.md). If you are
on Windows, see [get the required software for Windows](software-req-win.md).
