/*
 *  SPDX-License-Identifier: GPL-2.0-or-later
 *
 *  Refer to "imfc.cpp" for Copyright details.
 *
 *  This program is free software; you can redistribute it and/or modify it
 *  under the terms of the GNU General Public License as published by the Free
 *  Software Foundation; either version 2 of the License, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful, but WITHOUT
 *  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 *  FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 *  more details.
 *
 *  You should have received a copy of the GNU General Public License along with
 *  this program; if not, write to the Free Software Foundation, Inc., 51
 *  Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <stdint.h>

 // Read-only memory tables for the IBM Music Feature

static const uint8_t m_romPresetConfiguration16Binary[160] = {
	0x20, 0x20, 0x73, 0x69, 0x6E, 0x67, 0x6C, 0x65, 0x01, 0x66, 0x04, 0x00, 0x02, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x08, 0x00, 0x7F, 0x00, 0x02, 0x05, 0x00, 0x02, 0x7F, 0x40, 0x00, 0x00, 0x05, 0x00, 0x02, 0x00,
	0x00, 0x01, 0x7F, 0x00, 0x02, 0x00, 0x00, 0x02, 0x7F, 0x40, 0x00, 0x00, 0x02, 0x00, 0x02, 0x00,
	0x00, 0x02, 0x7F, 0x00, 0x02, 0x00, 0x00, 0x02, 0x7F, 0x40, 0x00, 0x00, 0x02, 0x00, 0x02, 0x00,
	0x00, 0x03, 0x7F, 0x00, 0x02, 0x00, 0x00, 0x02, 0x7F, 0x40, 0x00, 0x00, 0x02, 0x00, 0x02, 0x00,
	0x00, 0x04, 0x7F, 0x00, 0x02, 0x00, 0x00, 0x02, 0x7F, 0x40, 0x00, 0x00, 0x02, 0x00, 0x02, 0x00,
	0x00, 0x05, 0x7F, 0x00, 0x02, 0x00, 0x00, 0x02, 0x7F, 0x40, 0x00, 0x00, 0x02, 0x00, 0x02, 0x00,
	0x00, 0x06, 0x7F, 0x00, 0x02, 0x00, 0x00, 0x02, 0x7F, 0x40, 0x00, 0x00, 0x02, 0x00, 0x02, 0x00,
	0x00, 0x07, 0x7F, 0x00, 0x02, 0x00, 0x00, 0x02, 0x7F, 0x40, 0x00, 0x00, 0x02, 0x00, 0x02, 0x00
};

static const uint8_t m_romPresetConfiguration17Binary[160] = {
	0x20, 0x20, 0x6D, 0x6F, 0x6E, 0x6F, 0x20, 0x38, 0x01, 0x64, 0x00, 0x32, 0x02, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x01, 0x00, 0x7F, 0x00, 0x02, 0x00, 0x00, 0x02, 0x7F, 0x40, 0x00, 0x00, 0x02, 0x00, 0x02, 0x00,
	0x01, 0x01, 0x7F, 0x00, 0x02, 0x01, 0x00, 0x02, 0x7F, 0x40, 0x00, 0x00, 0x04, 0x00, 0x02, 0x00,
	0x01, 0x02, 0x7F, 0x00, 0x02, 0x02, 0x00, 0x02, 0x7F, 0x40, 0x00, 0x00, 0x04, 0x00, 0x02, 0x00,
	0x01, 0x03, 0x7F, 0x00, 0x02, 0x03, 0x00, 0x02, 0x7F, 0x40, 0x00, 0x00, 0x07, 0x00, 0x02, 0x00,
	0x01, 0x04, 0x7F, 0x00, 0x02, 0x04, 0x00, 0x02, 0x7F, 0x40, 0x00, 0x00, 0x02, 0x00, 0x02, 0x00,
	0x01, 0x05, 0x7F, 0x00, 0x02, 0x05, 0x00, 0x02, 0x7F, 0x40, 0x00, 0x00, 0x05, 0x00, 0x02, 0x00,
	0x01, 0x06, 0x7F, 0x00, 0x02, 0x06, 0x00, 0x02, 0x7F, 0x40, 0x00, 0x00, 0x02, 0x00, 0x02, 0x00,
	0x01, 0x07, 0x7F, 0x00, 0x02, 0x07, 0x00, 0x02, 0x7F, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

static const uint8_t m_romPresetConfiguration18Binary[160] = {
	0x20, 0x20, 0x20, 0x20, 0x64, 0x75, 0x61, 0x6C, 0x01, 0x64, 0x00, 0x32, 0x02, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x04, 0x00, 0x7F, 0x00, 0x02, 0x00, 0x00, 0x02, 0x7F, 0x40, 0x00, 0x00, 0x02, 0x00, 0x02, 0x00,
	0x04, 0x00, 0x7F, 0x00, 0x02, 0x00, 0x04, 0x02, 0x7F, 0x40, 0x00, 0x00, 0x02, 0x00, 0x02, 0x00,
	0x00, 0x02, 0x7F, 0x00, 0x02, 0x00, 0x00, 0x02, 0x7F, 0x40, 0x00, 0x00, 0x02, 0x00, 0x02, 0x00,
	0x00, 0x03, 0x7F, 0x00, 0x02, 0x00, 0x00, 0x02, 0x7F, 0x40, 0x00, 0x00, 0x02, 0x00, 0x02, 0x00,
	0x00, 0x04, 0x7F, 0x00, 0x02, 0x00, 0x00, 0x02, 0x7F, 0x40, 0x00, 0x00, 0x02, 0x00, 0x02, 0x00,
	0x00, 0x05, 0x7F, 0x00, 0x02, 0x00, 0x00, 0x02, 0x7F, 0x40, 0x00, 0x00, 0x02, 0x00, 0x02, 0x00,
	0x00, 0x06, 0x7F, 0x00, 0x02, 0x00, 0x00, 0x02, 0x7F, 0x40, 0x00, 0x00, 0x02, 0x00, 0x02, 0x00,
	0x00, 0x07, 0x7F, 0x00, 0x02, 0x00, 0x00, 0x02, 0x7F, 0x40, 0x00, 0x00, 0x02, 0x00, 0x02, 0x00
};

static const uint8_t m_romPresetConfiguration19Binary[160] = {
	0x20, 0x20, 0x20, 0x73, 0x70, 0x6C, 0x69, 0x74, 0x01, 0x64, 0x00, 0x32, 0x02, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x04, 0x00, 0x7F, 0x3C, 0x02, 0x00, 0x00, 0x02, 0x7F, 0x40, 0x00, 0x00, 0x02, 0x00, 0x02, 0x00,
	0x04, 0x00, 0x3B, 0x00, 0x02, 0x00, 0x00, 0x02, 0x7F, 0x40, 0x00, 0x00, 0x02, 0x00, 0x02, 0x00,
	0x00, 0x02, 0x7F, 0x00, 0x02, 0x00, 0x00, 0x02, 0x7F, 0x40, 0x00, 0x00, 0x02, 0x00, 0x02, 0x00,
	0x00, 0x03, 0x7F, 0x00, 0x02, 0x00, 0x00, 0x02, 0x7F, 0x40, 0x00, 0x00, 0x02, 0x00, 0x02, 0x00,
	0x00, 0x04, 0x7F, 0x00, 0x02, 0x00, 0x00, 0x02, 0x7F, 0x40, 0x00, 0x00, 0x02, 0x00, 0x02, 0x00,
	0x00, 0x05, 0x7F, 0x00, 0x02, 0x00, 0x00, 0x02, 0x7F, 0x40, 0x00, 0x00, 0x02, 0x00, 0x02, 0x00,
	0x00, 0x06, 0x7F, 0x00, 0x02, 0x00, 0x00, 0x02, 0x7F, 0x40, 0x00, 0x00, 0x02, 0x00, 0x02, 0x00,
	0x00, 0x07, 0x7F, 0x00, 0x02, 0x00, 0x00, 0x02, 0x7F, 0x40, 0x00, 0x00, 0x02, 0x00, 0x02, 0x00
};

static const uint8_t m_voiceDefinitionBankRom1Binary[3104] = {
	0x72, 0x6F, 0x6D, 0x31, 0x20, 0x20, 0x20, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x42, 0x72, 0x61, 0x73, 0x73, 0x20, 0x20, 0x00, 0xC8, 0x80, 0x32, 0x78, 0xFD, 0x30, 0x40, 0x00,
	0x12, 0x70, 0x50, 0x01, 0x8D, 0x09, 0x04, 0x18, 0x0F, 0x50, 0x44, 0x60, 0x4F, 0x88, 0x00, 0x18,
	0x00, 0x70, 0x44, 0x51, 0x15, 0x8E, 0x00, 0x28, 0x00, 0xF0, 0x24, 0x11, 0x52, 0x83, 0x00, 0x28,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x00,
	0x48, 0x6F, 0x72, 0x6E, 0x20, 0x20, 0x20, 0x00, 0xCD, 0x80, 0x00, 0x78, 0xFA, 0x30, 0x40, 0xF4,
	0x19, 0x70, 0x10, 0x41, 0x0E, 0x09, 0x00, 0x29, 0x29, 0x70, 0x10, 0x45, 0x5F, 0x11, 0x80, 0xCF,
	0x1C, 0x70, 0x00, 0x41, 0x0D, 0x0B, 0x00, 0x18, 0x01, 0x70, 0x00, 0x41, 0x12, 0x9F, 0x00, 0x0A,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x00, 0x00, 0x00, 0x00,
	0x54, 0x72, 0x75, 0x6D, 0x70, 0x65, 0x74, 0x00, 0xCD, 0x80, 0x16, 0x78, 0xFA, 0x30, 0x40, 0x00,
	0x10, 0x20, 0x10, 0x41, 0x11, 0x0E, 0x00, 0x15, 0x25, 0x30, 0x40, 0x42, 0x5F, 0x10, 0x80, 0xAF,
	0x15, 0x20, 0x00, 0x41, 0x11, 0x11, 0x00, 0x39, 0x00, 0x70, 0x04, 0x41, 0x55, 0x9F, 0x00, 0x0B,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x00, 0x00, 0x00, 0x00,
	0x4C, 0x6F, 0x53, 0x74, 0x72, 0x69, 0x67, 0x00, 0xCA, 0x80, 0x3C, 0x78, 0xFA, 0x30, 0x40, 0xF4,
	0x13, 0x20, 0x20, 0x11, 0x59, 0x0A, 0x00, 0x15, 0x07, 0x10, 0x50, 0x15, 0x59, 0x0B, 0x00, 0x58,
	0x27, 0x20, 0x40, 0x01, 0x5C, 0x0D, 0x00, 0x26, 0x00, 0xD0, 0x10, 0x11, 0x4E, 0x84, 0x00, 0x06,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x27, 0x00, 0x00, 0x00, 0x00,
	0x53, 0x74, 0x72, 0x69, 0x6E, 0x67, 0x73, 0x00, 0xCD, 0x80, 0x46, 0x78, 0xFA, 0x30, 0x40, 0x0C,
	0x12, 0xC0, 0x40, 0x20, 0x5E, 0x21, 0x00, 0x15, 0x00, 0x40, 0xF8, 0x32, 0x5F, 0x21, 0x00, 0x15,
	0x1B, 0x50, 0xF0, 0x31, 0x5E, 0x21, 0x00, 0x15, 0x00, 0x70, 0x80, 0x71, 0x4D, 0xA2, 0x00, 0x06,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x00, 0x00, 0x00, 0x00,
	0x50, 0x69, 0x61, 0x6E, 0x6F, 0x20, 0x20, 0x00, 0xCD, 0x84, 0x00, 0x78, 0xF2, 0x11, 0x40, 0x00,
	0x1C, 0x00, 0x70, 0xD1, 0x56, 0x05, 0x07, 0x94, 0x19, 0x70, 0xF0, 0xA3, 0x56, 0x00, 0x04, 0x45,
	0x0F, 0x50, 0xF0, 0xF1, 0x5D, 0x00, 0x04, 0x45, 0x00, 0xF0, 0x00, 0x11, 0x97, 0xA7, 0x06, 0x46,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x25, 0x00, 0x00, 0x00, 0x00,
	0x4E, 0x65, 0x77, 0x45, 0x50, 0x20, 0x20, 0x00, 0xCD, 0x80, 0x00, 0x78, 0xC4, 0x30, 0x40, 0x00,
	0x29, 0x50, 0x00, 0x37, 0x9F, 0x06, 0x84, 0x37, 0x00, 0x70, 0x08, 0x31, 0x5F, 0x8B, 0x08, 0x27,
	0x17, 0x50, 0x00, 0x31, 0x9B, 0x04, 0x03, 0x24, 0x00, 0x70, 0x08, 0x31, 0x9B, 0x84, 0x03, 0x26,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x00, 0x00, 0x00, 0x00,
	0x45, 0x47, 0x72, 0x61, 0x6E, 0x64, 0x20, 0x00, 0xCD, 0x80, 0x1C, 0x78, 0xFA, 0x00, 0x40, 0xF4,
	0x1E, 0x40, 0x20, 0x31, 0x5F, 0x08, 0x03, 0x25, 0x18, 0x70, 0xE0, 0xA5, 0x16, 0x05, 0x04, 0x25,
	0x15, 0x60, 0xC0, 0xF3, 0x1F, 0x04, 0x02, 0x15, 0x01, 0x70, 0x00, 0x41, 0x98, 0x9E, 0x06, 0x06,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x4A, 0x61, 0x7A, 0x7A, 0x20, 0x47, 0x74, 0x00, 0xC9, 0x80, 0x00, 0x78, 0xF8, 0x30, 0x40, 0x00,
	0x24, 0x70, 0x00, 0x4E, 0x1F, 0x0C, 0x00, 0xFF, 0x17, 0x70, 0xF0, 0x33, 0x1F, 0x0A, 0x00, 0xFF,
	0x19, 0x70, 0xF0, 0x43, 0x1C, 0x06, 0x00, 0xFF, 0x00, 0x70, 0x80, 0x41, 0x1F, 0x8A, 0x00, 0xFF,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x00, 0x00, 0x00, 0x00,
	0x45, 0x42, 0x61, 0x73, 0x73, 0x20, 0x20, 0x00, 0xC8, 0x80, 0x00, 0x78, 0xD8, 0x20, 0x40, 0xF4,
	0x25, 0x60, 0x40, 0x37, 0x9E, 0x0D, 0x08, 0xB6, 0x1B, 0x60, 0x40, 0x30, 0xDC, 0x06, 0x0A, 0xB6,
	0x0D, 0x60, 0x40, 0x30, 0x9C, 0x04, 0x03, 0x36, 0x00, 0x30, 0x00, 0x31, 0x9C, 0x81, 0x05, 0x26,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x00, 0x00, 0x00, 0x00,
	0x57, 0x6F, 0x64, 0x42, 0x61, 0x73, 0x73, 0x00, 0xCA, 0x83, 0x3C, 0x78, 0xFA, 0x31, 0x40, 0xF4,
	0x17, 0x40, 0x50, 0x10, 0xD7, 0x08, 0x00, 0x85, 0x0F, 0x10, 0xC0, 0x10, 0x08, 0x05, 0x00, 0xF8,
	0x0A, 0x20, 0xC0, 0x01, 0xD4, 0x29, 0x00, 0x76, 0x00, 0xD0, 0x10, 0x11, 0x94, 0xB3, 0x02, 0x16,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x00, 0x00, 0x00, 0x00,
	0x45, 0x4F, 0x72, 0x67, 0x61, 0x6E, 0x31, 0x00, 0xAF, 0x80, 0xA8, 0x78, 0xE4, 0x30, 0x40, 0x00,
	0x16, 0x20, 0x07, 0x71, 0x19, 0x12, 0x00, 0x0F, 0x00, 0x00, 0x07, 0x32, 0x1C, 0x84, 0x00, 0x0F,
	0x0F, 0x20, 0x17, 0x30, 0x14, 0x0F, 0x00, 0x0F, 0x00, 0x00, 0x17, 0x31, 0x1C, 0x8F, 0x00, 0x0F,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x27, 0x00, 0x00, 0x00, 0x00,
	0x45, 0x4F, 0x72, 0x67, 0x61, 0x6E, 0x32, 0x00, 0xD0, 0x80, 0x1C, 0x78, 0xDF, 0x20, 0x40, 0x00,
	0x00, 0x50, 0x0F, 0x33, 0x1F, 0x8D, 0x01, 0xFB, 0x00, 0x50, 0x0F, 0x33, 0x1F, 0x9F, 0x01, 0x0A,
	0x00, 0x50, 0x0F, 0x72, 0x1F, 0x9F, 0x01, 0x0A, 0x00, 0x50, 0x0F, 0x31, 0x1F, 0x9F, 0x01, 0x0A,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x00, 0x00, 0x00, 0x00,
	0x50, 0x4F, 0x72, 0x67, 0x61, 0x6E, 0x31, 0x00, 0xCD, 0x80, 0x1D, 0x78, 0xFC, 0x00, 0x40, 0xF4,
	0x19, 0x30, 0x00, 0x5A, 0x16, 0x00, 0x00, 0x0A, 0x00, 0x40, 0x08, 0x72, 0x8F, 0x80, 0x00, 0x08,
	0x00, 0x30, 0xD0, 0x70, 0x98, 0x00, 0x00, 0x05, 0x00, 0x40, 0x08, 0x30, 0x8C, 0x80, 0x00, 0x05,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x50, 0x4F, 0x72, 0x67, 0x61, 0x6E, 0x32, 0x00, 0xC8, 0x82, 0x1D, 0x78, 0xF4, 0x01, 0x40, 0x00,
	0x0B, 0x00, 0xC0, 0x73, 0x8F, 0x02, 0x00, 0x03, 0x11, 0xD0, 0xC0, 0x75, 0x90, 0x82, 0x00, 0x06,
	0x01, 0x20, 0xC0, 0x60, 0x8F, 0x02, 0x00, 0x03, 0x00, 0x50, 0xA0, 0x11, 0x8F, 0x82, 0x00, 0x07,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00,
	0x46, 0x6C, 0x75, 0x74, 0x65, 0x20, 0x20, 0x00, 0xC6, 0x80, 0x2D, 0x78, 0xFB, 0x30, 0x40, 0x0C,
	0x00, 0x70, 0x40, 0x71, 0x52, 0x0E, 0xC3, 0x65, 0x34, 0x50, 0x40, 0x02, 0x51, 0x10, 0x02, 0x55,
	0x1C, 0x70, 0x30, 0x31, 0x8B, 0x04, 0x00, 0x25, 0x00, 0x70, 0x08, 0x01, 0x4F, 0x84, 0x00, 0x08,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x00, 0x00, 0x00, 0x00,
	0x50, 0x69, 0x63, 0x63, 0x6F, 0x6C, 0x6F, 0x00, 0xCD, 0x84, 0x28, 0x78, 0xFE, 0x31, 0x40, 0x18,
	0x21, 0x70, 0x40, 0x01, 0x1F, 0x0A, 0x0F, 0x59, 0x07, 0x70, 0x28, 0x01, 0x14, 0x86, 0x00, 0xF9,
	0x02, 0x70, 0x68, 0x01, 0x14, 0x8B, 0x00, 0x19, 0x00, 0x70, 0x68, 0x01, 0x14, 0x8B, 0x00, 0x19,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x00, 0x00, 0x00, 0x00,
	0x4F, 0x62, 0x6F, 0x65, 0x20, 0x20, 0x20, 0x00, 0xC8, 0x83, 0x1E, 0x78, 0xFA, 0x31, 0x40, 0x00,
	0x18, 0x60, 0x60, 0x31, 0xD9, 0x0B, 0x00, 0x13, 0x1B, 0x60, 0x80, 0x39, 0xDC, 0x0C, 0x0C, 0x5B,
	0x25, 0x60, 0x60, 0x32, 0x56, 0x00, 0x00, 0x1B, 0x00, 0x50, 0x30, 0x34, 0x54, 0x86, 0x00, 0x0B,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x00, 0x00, 0x00, 0x00,
	0x43, 0x6C, 0x61, 0x72, 0x69, 0x6E, 0x65, 0x00, 0xCC, 0x80, 0x18, 0x78, 0xFA, 0x30, 0x40, 0x00,
	0x11, 0x10, 0x50, 0x42, 0x53, 0x12, 0x00, 0x29, 0x05, 0x40, 0xD0, 0x45, 0x1F, 0x11, 0x00, 0x36,
	0x1B, 0x40, 0x90, 0x41, 0x1F, 0x14, 0x00, 0x15, 0x06, 0x70, 0x06, 0x41, 0x50, 0x9F, 0x00, 0x0B,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x00, 0x00, 0x00, 0x00,
	0x47, 0x6C, 0x6F, 0x63, 0x6B, 0x65, 0x6E, 0x00, 0xCD, 0x80, 0x00, 0x78, 0xE4, 0x33, 0x40, 0x0C,
	0x12, 0x30, 0x60, 0x3F, 0x1F, 0x13, 0x04, 0x55, 0x00, 0x70, 0x08, 0x31, 0x58, 0x91, 0x08, 0x06,
	0x28, 0x60, 0x00, 0x75, 0x1F, 0x0E, 0x05, 0x62, 0x00, 0x70, 0x08, 0x71, 0x1F, 0x91, 0x08, 0x06,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x25, 0x00, 0x00, 0x00, 0x00,
	0x56, 0x69, 0x62, 0x65, 0x73, 0x20, 0x20, 0x00, 0xB9, 0x99, 0x07, 0x78, 0xE4, 0x31, 0x40, 0x00,
	0x2F, 0xF0, 0xC0, 0x39, 0x5F, 0x0F, 0x40, 0xB5, 0x05, 0x70, 0x00, 0x51, 0x9B, 0x84, 0x03, 0x83,
	0x2F, 0x70, 0x70, 0x05, 0x9E, 0x04, 0x0B, 0xF6, 0x00, 0xC0, 0x20, 0x01, 0x9E, 0x85, 0x0A, 0xF4,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x00, 0x00, 0x00, 0x00,
	0x58, 0x79, 0x6C, 0x6F, 0x70, 0x68, 0x6E, 0x00, 0xCD, 0x80, 0x1E, 0x78, 0xFC, 0x00, 0x40, 0x00,
	0x15, 0x70, 0x70, 0x46, 0x5F, 0x16, 0x09, 0x66, 0x00, 0x70, 0x08, 0x41, 0x9F, 0x9F, 0x0F, 0x06,
	0x0F, 0x70, 0x00, 0x47, 0x9F, 0x16, 0x16, 0xAC, 0x00, 0x70, 0x38, 0x44, 0x5F, 0x9F, 0x11, 0x08,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00,
	0x4B, 0x6F, 0x74, 0x6F, 0x20, 0x20, 0x20, 0x00, 0xCD, 0x00, 0x00, 0x78, 0xF8, 0x30, 0x40, 0x00,
	0x18, 0x40, 0x00, 0x33, 0xDA, 0x08, 0x05, 0x22, 0x18, 0x40, 0x00, 0x34, 0xDD, 0x05, 0x04, 0x12,
	0x17, 0x40, 0x00, 0x31, 0xDC, 0x04, 0x02, 0x32, 0x00, 0xE0, 0x24, 0x31, 0xDF, 0x8A, 0x03, 0x11,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x23, 0x00, 0x00, 0x00, 0x00,
	0x5A, 0x69, 0x74, 0x68, 0x65, 0x72, 0x20, 0x00, 0xC8, 0x80, 0x1E, 0x78, 0xC2, 0x20, 0x40, 0x00,
	0x16, 0x40, 0x40, 0x37, 0x9F, 0x06, 0x06, 0x01, 0x3F, 0x20, 0x40, 0x39, 0x9F, 0x06, 0x06, 0x01,
	0x17, 0x20, 0x40, 0x21, 0x9F, 0x0C, 0x06, 0x01, 0x00, 0x70, 0x44, 0x31, 0x9F, 0x8C, 0x06, 0x05,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x00, 0x00, 0x00, 0x00,
	0x43, 0x6C, 0x61, 0x76, 0x20, 0x20, 0x20, 0x00, 0xCD, 0x80, 0x1C, 0x78, 0xFB, 0x30, 0x40, 0x00,
	0x16, 0x20, 0x40, 0x3C, 0xD4, 0x04, 0x04, 0xF7, 0x19, 0x20, 0x40, 0x39, 0x9F, 0x08, 0x05, 0x27,
	0x07, 0x20, 0x40, 0x30, 0xDF, 0x07, 0x04, 0x37, 0x00, 0x60, 0x34, 0x31, 0x5F, 0x85, 0x02, 0xAC,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x00, 0x00, 0x00, 0x00,
	0x48, 0x61, 0x72, 0x70, 0x73, 0x69, 0x63, 0x00, 0xCD, 0x80, 0x1F, 0x78, 0xF2, 0x00, 0x40, 0x00,
	0x08, 0x00, 0x60, 0x40, 0xDF, 0x1D, 0x01, 0x34, 0x1C, 0x00, 0x00, 0x48, 0x9F, 0x1F, 0x05, 0x29,
	0x00, 0x00, 0x00, 0x41, 0x1F, 0x19, 0x03, 0x24, 0x00, 0x70, 0x00, 0x44, 0xDF, 0x9A, 0x01, 0x25,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x42, 0x65, 0x6C, 0x6C, 0x73, 0x20, 0x20, 0x00, 0xC7, 0x80, 0x8F, 0x78, 0xED, 0x30, 0x40, 0xF4,
	0x12, 0x40, 0x50, 0x33, 0x1D, 0x04, 0x81, 0x22, 0x07, 0x50, 0xF5, 0x22, 0x1D, 0x8F, 0x43, 0x13,
	0x11, 0x30, 0x45, 0x30, 0x5B, 0x8F, 0x40, 0x13, 0x00, 0x70, 0x45, 0x31, 0x5E, 0x82, 0x43, 0x13,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x00, 0x00, 0x00, 0x00,
	0x48, 0x61, 0x72, 0x70, 0x20, 0x20, 0x20, 0x00, 0xCD, 0x80, 0x1E, 0x78, 0xF9, 0x10, 0x40, 0x0C,
	0x0E, 0x70, 0xC0, 0x02, 0x5F, 0x0C, 0x00, 0xF4, 0x1C, 0x60, 0x40, 0x01, 0x5F, 0x0D, 0x06, 0x15,
	0x22, 0x60, 0xA0, 0x02, 0x1F, 0x06, 0x05, 0x15, 0x00, 0x60, 0x40, 0x01, 0x9F, 0x8C, 0x07, 0x14,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00,
	0x53, 0x6D, 0x61, 0x64, 0x53, 0x79, 0x6E, 0x00, 0xCD, 0x80, 0x00, 0x78, 0xC7, 0x50, 0x40, 0x00,
	0x00, 0x60, 0x0A, 0x04, 0x05, 0xA2, 0x05, 0x3A, 0x00, 0x60, 0x0A, 0x03, 0x0A, 0xA2, 0x07, 0x3A,
	0x00, 0x60, 0x0A, 0x02, 0x0F, 0xA2, 0x09, 0x3A, 0x00, 0x60, 0x0A, 0x01, 0x14, 0xA2, 0x0B, 0x3A,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x00, 0x00, 0x00, 0x00,
	0x48, 0x61, 0x72, 0x6D, 0x6F, 0x6E, 0x69, 0x00, 0xCD, 0x80, 0x0D, 0x78, 0xFB, 0x40, 0x40, 0x00,
	0x19, 0x10, 0x00, 0x41, 0x10, 0x1F, 0x00, 0x09, 0x22, 0x10, 0x00, 0x44, 0x10, 0x1F, 0x00, 0x09,
	0x15, 0x10, 0x00, 0x41, 0x0E, 0x1F, 0x00, 0x07, 0x00, 0x70, 0x04, 0x41, 0x10, 0x9F, 0x00, 0x09,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x00, 0x00, 0x00, 0x00,
	0x53, 0x74, 0x65, 0x65, 0x6C, 0x44, 0x72, 0x00, 0xCD, 0x80, 0x1E, 0x78, 0xC4, 0x10, 0x40, 0x00,
	0x19, 0x20, 0x30, 0x71, 0x56, 0x05, 0x06, 0x64, 0x00, 0x50, 0x00, 0x01, 0x99, 0x8C, 0x06, 0x15,
	0x12, 0x30, 0x70, 0x42, 0x54, 0x07, 0x46, 0x64, 0x07, 0x50, 0x00, 0x31, 0x99, 0x8C, 0x06, 0x65,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00,
	0x54, 0x69, 0x6D, 0x70, 0x61, 0x6E, 0x69, 0x00, 0xC0, 0x80, 0x1D, 0x78, 0xFA, 0x12, 0x40, 0x00,
	0x20, 0x70, 0x00, 0x40, 0x1D, 0x12, 0x00, 0xF3, 0x08, 0x70, 0x80, 0x40, 0x1F, 0x0F, 0x92, 0x33,
	0x24, 0x70, 0x00, 0x40, 0x1F, 0x19, 0x0C, 0x04, 0x00, 0x70, 0x00, 0x40, 0x1F, 0x99, 0x0C, 0x04,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00,
	0x4C, 0x6F, 0x53, 0x74, 0x72, 0x67, 0x32, 0x00, 0xC8, 0x80, 0xB4, 0x78, 0xF2, 0x40, 0x40, 0x00,
	0x10, 0xC0, 0x50, 0x30, 0x5E, 0x24, 0x02, 0x26, 0x11, 0x40, 0xF0, 0x75, 0x5F, 0x28, 0x00, 0xC8,
	0x11, 0x40, 0xF0, 0x30, 0x10, 0x25, 0x02, 0x26, 0x00, 0x60, 0x80, 0x70, 0x0B, 0xA5, 0x00, 0x06,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x00, 0x00, 0x00, 0x00,
	0x48, 0x6F, 0x72, 0x6E, 0x20, 0x4C, 0x6F, 0x00, 0xBE, 0x80, 0x28, 0x78, 0xFD, 0x30, 0x40, 0xF4,
	0x11, 0x40, 0x50, 0x01, 0x4C, 0x0B, 0x01, 0x28, 0x00, 0xC0, 0x26, 0x01, 0x0F, 0xA5, 0x00, 0x29,
	0x00, 0x40, 0x06, 0x02, 0x50, 0xA1, 0x00, 0x2A, 0x00, 0xD0, 0x26, 0x01, 0x12, 0xA2, 0x00, 0x19,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x00, 0x00, 0x00, 0x00,
	0x57, 0x68, 0x69, 0x73, 0x74, 0x6C, 0x65, 0x00, 0xC8, 0x8A, 0x46, 0x78, 0xFC, 0x50, 0x40, 0x0C,
	0x25, 0x20, 0x00, 0x31, 0x1F, 0x0F, 0xC0, 0xF9, 0x1B, 0x50, 0x20, 0x02, 0x0F, 0x88, 0x00, 0x09,
	0x25, 0x20, 0x40, 0x30, 0x19, 0x10, 0x40, 0x79, 0x07, 0x60, 0x40, 0x02, 0x0D, 0x88, 0x00, 0x19,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x00, 0x00, 0x00, 0x00,
	0x5A, 0x69, 0x6E, 0x67, 0x50, 0x6C, 0x70, 0x00, 0xCD, 0x80, 0x00, 0x78, 0xD4, 0x40, 0x40, 0xF4,
	0x08, 0x30, 0x00, 0x40, 0x8A, 0x08, 0x10, 0xF4, 0x05, 0x70, 0x05, 0x48, 0x9F, 0x84, 0x10, 0xD4,
	0x1E, 0x30, 0x00, 0x41, 0x1C, 0x08, 0x09, 0xEB, 0x00, 0x70, 0x15, 0x42, 0x53, 0x8F, 0x00, 0xF6,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2C, 0x00, 0x00, 0x00, 0x00,
	0x4D, 0x65, 0x74, 0x61, 0x6C, 0x20, 0x20, 0x00, 0xC9, 0x80, 0x1B, 0x78, 0xFA, 0x40, 0x40, 0x00,
	0x11, 0x70, 0x50, 0x75, 0x9F, 0x08, 0x06, 0x57, 0x07, 0x10, 0x60, 0x30, 0x06, 0x14, 0x02, 0x01,
	0x0A, 0x50, 0x50, 0x71, 0x5F, 0x0B, 0x04, 0x03, 0x00, 0x70, 0x00, 0x30, 0x1B, 0x94, 0x03, 0x28,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00,
	0x48, 0x65, 0x61, 0x76, 0x79, 0x20, 0x20, 0x00, 0xCD, 0x80, 0x1C, 0x78, 0xF0, 0x50, 0x40, 0x00,
	0x0A, 0x00, 0x70, 0x40, 0x1F, 0x06, 0x00, 0xFF, 0x12, 0x00, 0x00, 0x40, 0x1F, 0x1F, 0x00, 0x0F,
	0x0E, 0x00, 0x00, 0x40, 0x1F, 0x1F, 0x00, 0x0F, 0x00, 0x40, 0x00, 0x40, 0x1F, 0x9F, 0x00, 0x0F,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x00, 0x00, 0x00, 0x00,
	0x46, 0x75, 0x6E, 0x6B, 0x53, 0x79, 0x6E, 0x00, 0xCC, 0x80, 0x1A, 0x78, 0xDB, 0x50, 0x40, 0x0C,
	0x00, 0x00, 0x00, 0x35, 0x08, 0x0B, 0x02, 0x19, 0x25, 0x50, 0x80, 0x39, 0xDF, 0x06, 0x06, 0x5B,
	0x00, 0x30, 0x60, 0x30, 0x54, 0x04, 0x00, 0x1B, 0x00, 0x40, 0x30, 0x31, 0x5F, 0x86, 0x00, 0x1B,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x22, 0x00, 0x00, 0x00, 0x00,
	0x56, 0x6F, 0x69, 0x63, 0x65, 0x73, 0x20, 0x00, 0xCB, 0x80, 0x2C, 0x78, 0xE9, 0x40, 0x40, 0x00,
	0x26, 0x00, 0x80, 0x36, 0x13, 0x12, 0xC4, 0x54, 0x1B, 0x00, 0xF0, 0x74, 0x15, 0x0E, 0xC6, 0x6A,
	0x0B, 0x00, 0xD0, 0x71, 0x0B, 0x1F, 0x03, 0x0A, 0x00, 0x70, 0x00, 0x31, 0x0E, 0x9F, 0x01, 0x08,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x00, 0x00, 0x00, 0x00,
	0x4D, 0x61, 0x72, 0x69, 0x6D, 0x62, 0x61, 0x00, 0xCD, 0x80, 0x1F, 0x78, 0xC2, 0x00, 0x40, 0xF4,
	0x0F, 0x30, 0x00, 0x4D, 0x1F, 0x1B, 0x00, 0xF5, 0x18, 0x30, 0x00, 0x47, 0x1F, 0x0D, 0x00, 0xF5,
	0x18, 0x30, 0x00, 0x47, 0x1F, 0x12, 0x00, 0xF4, 0x00, 0x70, 0x00, 0x41, 0x1F, 0x8C, 0x00, 0xF6,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00,
	0x45, 0x42, 0x61, 0x73, 0x73, 0x20, 0x32, 0x00, 0xCC, 0x80, 0x00, 0x78, 0xFB, 0x30, 0x40, 0xF4,
	0x1A, 0x70, 0xF0, 0x4D, 0x9F, 0x0E, 0x00, 0xDF, 0x10, 0x70, 0x00, 0x41, 0x1F, 0x0D, 0x00, 0xDF,
	0x10, 0x70, 0x00, 0x40, 0x1F, 0x09, 0x00, 0xD7, 0x00, 0x60, 0x00, 0x40, 0x1F, 0x89, 0x00, 0xD8,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x00, 0x00, 0x00, 0x00,
	0x53, 0x6E, 0x61, 0x72, 0x65, 0x44, 0x72, 0x00, 0xCD, 0x00, 0x00, 0x78, 0xFC, 0x00, 0x40, 0x00,
	0x00, 0x00, 0x00, 0x0F, 0x1F, 0x17, 0x00, 0x18, 0x00, 0x50, 0x00, 0x00, 0x1A, 0x91, 0x0F, 0x9C,
	0x0F, 0x40, 0x00, 0x00, 0x18, 0x1A, 0x54, 0x98, 0x00, 0x70, 0x00, 0x00, 0x1C, 0x8E, 0x10, 0x29,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0C, 0x00, 0x00, 0x00, 0x00,
	0x52, 0x44, 0x20, 0x43, 0x79, 0x6D, 0x62, 0x00, 0xCD, 0x00, 0x00, 0x78, 0xFC, 0x00, 0x40, 0x00,
	0x05, 0x00, 0x00, 0x03, 0x1F, 0x1F, 0x40, 0x10, 0x1B, 0x50, 0x04, 0x05, 0x9F, 0x9F, 0x84, 0x12,
	0x05, 0x00, 0x00, 0x71, 0x19, 0x1C, 0x85, 0x33, 0x00, 0x50, 0x04, 0x07, 0x9F, 0x9F, 0xC5, 0x72,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0C, 0x00, 0x00, 0x00, 0x00,
	0x54, 0x6F, 0x6D, 0x20, 0x54, 0x6F, 0x6D, 0x00, 0xCD, 0x80, 0x00, 0x78, 0xF8, 0x50, 0x40, 0xF4,
	0x10, 0x70, 0x00, 0x70, 0x1F, 0x13, 0x85, 0x5A, 0x19, 0x70, 0x40, 0x43, 0x1F, 0x0D, 0x45, 0x2A,
	0x17, 0x70, 0x70, 0x42, 0x1F, 0x13, 0xCA, 0x25, 0x00, 0x70, 0x00, 0x42, 0x1F, 0x9C, 0x4F, 0x07,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00,
	0x4D, 0x61, 0x72, 0x73, 0x20, 0x74, 0x6F, 0x00, 0xD9, 0xFD, 0x00, 0x78, 0xF9, 0x03, 0x20, 0x00,
	0x01, 0x40, 0x00, 0x48, 0x9F, 0x0D, 0x10, 0x22, 0x00, 0x30, 0x00, 0x42, 0x9F, 0x04, 0x08, 0xD2,
	0x1C, 0x30, 0x00, 0x41, 0x1C, 0x08, 0x09, 0xE2, 0x00, 0x70, 0x10, 0x42, 0x53, 0x89, 0x00, 0xF2,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0C, 0x00, 0x00, 0x00, 0x00,
	0x53, 0x74, 0x6F, 0x72, 0x6D, 0x20, 0x20, 0x00, 0xD2, 0x80, 0xFF, 0x78, 0xF3, 0x70, 0x60, 0xE8,
	0x1B, 0x70, 0x00, 0x31, 0x08, 0x08, 0xC1, 0xA3, 0x00, 0x70, 0x00, 0x30, 0x14, 0x07, 0x41, 0xA4,
	0x11, 0x70, 0x00, 0x76, 0x0A, 0x09, 0x40, 0x61, 0x00, 0x70, 0x00, 0x70, 0x0F, 0x86, 0x00, 0x31,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x00,
	0x57, 0x69, 0x6E, 0x64, 0x62, 0x65, 0x6C, 0x00, 0xD8, 0x80, 0x2C, 0x78, 0xC4, 0x60, 0x60, 0x00,
	0x0A, 0x70, 0x00, 0x44, 0x1C, 0x08, 0x40, 0x13, 0x00, 0x70, 0x08, 0x51, 0x4E, 0x84, 0x00, 0x52,
	0x03, 0x70, 0x60, 0x49, 0x5C, 0x07, 0x40, 0x10, 0x00, 0x70, 0x08, 0x45, 0x4D, 0x89, 0x00, 0x32,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00
};

static const uint8_t m_voiceDefinitionBankRom2Binary[3104] = {
	0x72, 0x6F, 0x6D, 0x32, 0x20, 0x20, 0x20, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x55, 0x70, 0x50, 0x69, 0x61, 0x6E, 0x6F, 0x00, 0xCD, 0x80, 0x1B, 0x78, 0xFA, 0x00, 0x40, 0x00,
	0x21, 0x20, 0xC0, 0xE5, 0xD3, 0x02, 0x01, 0x34, 0x16, 0x20, 0xF0, 0xA5, 0xD3, 0x02, 0x01, 0x34,
	0x0D, 0x20, 0xF0, 0xF1, 0x93, 0x02, 0x01, 0x34, 0x00, 0x70, 0x04, 0xC1, 0xD3, 0x82, 0x01, 0x34,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00,
	0x53, 0x50, 0x69, 0x61, 0x6E, 0x6F, 0x20, 0x00, 0xCD, 0x80, 0x1C, 0x78, 0xF4, 0x00, 0x40, 0x00,
	0x08, 0x70, 0x70, 0xA1, 0x9E, 0x17, 0x01, 0x34, 0x00, 0x70, 0x06, 0x31, 0xD3, 0x82, 0x01, 0x07,
	0x0E, 0x70, 0x20, 0xB0, 0x96, 0x14, 0x4B, 0xDF, 0x09, 0x70, 0x06, 0x71, 0x5F, 0x84, 0x01, 0x17,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00,
	0x50, 0x69, 0x61, 0x6E, 0x6F, 0x32, 0x20, 0x00, 0xCD, 0x80, 0x1A, 0x78, 0xFA, 0x00, 0x40, 0x00,
	0x1B, 0x00, 0xF0, 0x30, 0x1F, 0x11, 0x8E, 0xFA, 0x19, 0x40, 0xF0, 0xA3, 0x55, 0x02, 0x01, 0x34,
	0x0B, 0x10, 0xF0, 0xF1, 0x9C, 0x02, 0x01, 0x34, 0x00, 0x70, 0x03, 0x41, 0xD5, 0xA2, 0x01, 0x34,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00,
	0x50, 0x69, 0x61, 0x6E, 0x6F, 0x33, 0x20, 0x00, 0xCD, 0x80, 0x1B, 0x78, 0xF9, 0x00, 0x40, 0x00,
	0x2B, 0x70, 0xB0, 0xF3, 0x00, 0x05, 0x02, 0x25, 0x28, 0x70, 0xF0, 0xF3, 0x18, 0x05, 0x02, 0x25,
	0x0A, 0x70, 0xC0, 0xB1, 0x18, 0x05, 0x02, 0x25, 0x00, 0x70, 0x04, 0x41, 0x95, 0x86, 0x05, 0x25,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00,
	0x50, 0x69, 0x61, 0x6E, 0x6F, 0x34, 0x20, 0x00, 0xCD, 0x80, 0x1E, 0x78, 0xFB, 0x00, 0x40, 0x00,
	0x11, 0x00, 0xF0, 0xB3, 0x98, 0x18, 0x03, 0x2F, 0x0A, 0x10, 0xF0, 0xF1, 0xD6, 0x0B, 0x01, 0x03,
	0x15, 0x10, 0xE0, 0xC1, 0x95, 0x13, 0x91, 0x02, 0x00, 0x50, 0x00, 0x31, 0xD7, 0x91, 0x01, 0x13,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x50, 0x69, 0x61, 0x6E, 0x6F, 0x35, 0x20, 0x00, 0xCD, 0x84, 0x1D, 0x78, 0xFB, 0x21, 0x40, 0x00,
	0x18, 0x70, 0xF0, 0x85, 0x5D, 0x06, 0x05, 0x54, 0x1B, 0x50, 0xF0, 0xA3, 0x5D, 0x07, 0x06, 0x45,
	0x15, 0x50, 0x50, 0xB1, 0x5E, 0x07, 0x06, 0x46, 0x00, 0x70, 0x40, 0x71, 0x5D, 0x86, 0x08, 0x37,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x25, 0x00, 0x00, 0x00, 0x00,
	0x50, 0x68, 0x47, 0x72, 0x61, 0x6E, 0x64, 0x00, 0xCD, 0x80, 0x00, 0x78, 0xF3, 0x30, 0x40, 0x00,
	0x0E, 0x00, 0xF0, 0xB3, 0x9D, 0x17, 0x02, 0x24, 0x0C, 0x40, 0xF0, 0xF1, 0x96, 0x0F, 0x00, 0x02,
	0x0E, 0x70, 0xF0, 0xB1, 0x95, 0x03, 0x00, 0x15, 0x00, 0x70, 0x00, 0x41, 0xD3, 0x9D, 0x01, 0x25,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x00, 0x00, 0x00, 0x00,
	0x47, 0x72, 0x61, 0x6E, 0x64, 0x20, 0x20, 0x00, 0xCD, 0x80, 0x1C, 0x78, 0xF2, 0x00, 0x40, 0x00,
	0x16, 0x20, 0x70, 0xA1, 0x58, 0x01, 0x01, 0xF3, 0x22, 0x40, 0xF0, 0xF7, 0x98, 0x05, 0x01, 0xF3,
	0x0C, 0x50, 0xF0, 0xC1, 0x56, 0x01, 0x01, 0x34, 0x00, 0x70, 0x05, 0x41, 0x94, 0x88, 0x01, 0x36,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x44, 0x70, 0x47, 0x72, 0x61, 0x6E, 0x64, 0x00, 0xCD, 0x80, 0x1B, 0x78, 0xF2, 0x00, 0x40, 0x00,
	0x18, 0x00, 0x50, 0xA1, 0x58, 0x01, 0x01, 0xF3, 0x22, 0x40, 0xF0, 0xF7, 0x58, 0x05, 0x01, 0xF3,
	0x06, 0x20, 0xF0, 0xC0, 0x96, 0x01, 0x01, 0x34, 0x00, 0x70, 0x04, 0x41, 0x94, 0x88, 0x01, 0x35,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x4C, 0x50, 0x69, 0x61, 0x6E, 0x6F, 0x31, 0x00, 0xCD, 0x80, 0x00, 0x78, 0xF2, 0x30, 0x40, 0xF4,
	0x14, 0x30, 0xF0, 0xB1, 0x5F, 0x08, 0x03, 0x25, 0x1B, 0x30, 0xF0, 0xAF, 0x1F, 0x05, 0x04, 0x25,
	0x11, 0x00, 0xF0, 0xD3, 0x1F, 0x03, 0x02, 0x15, 0x00, 0x70, 0x08, 0x41, 0x9D, 0x9E, 0x07, 0x09,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x00, 0x00, 0x00, 0x00,
	0x4C, 0x50, 0x69, 0x61, 0x6E, 0x6F, 0x32, 0x00, 0xCA, 0x80, 0x1D, 0x78, 0xF2, 0x00, 0x40, 0xF4,
	0x0F, 0x00, 0xE0, 0xF1, 0x19, 0x02, 0x04, 0x16, 0x13, 0x40, 0xA0, 0xB7, 0x15, 0x0A, 0x06, 0x24,
	0x11, 0x40, 0xF0, 0xB3, 0x19, 0x04, 0x05, 0xF5, 0x00, 0x50, 0x05, 0x01, 0x56, 0x8F, 0x04, 0x17,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x45, 0x47, 0x72, 0x61, 0x6E, 0x64, 0x32, 0x00, 0xCD, 0x80, 0x19, 0x78, 0xF4, 0x00, 0x40, 0xF4,
	0x17, 0x30, 0xF0, 0xB9, 0xDC, 0x08, 0x86, 0x53, 0x00, 0x70, 0xC8, 0xC1, 0xD9, 0x88, 0x1F, 0xF6,
	0x03, 0x30, 0xF0, 0xF3, 0x96, 0x03, 0x01, 0x33, 0x00, 0x70, 0x08, 0x41, 0x94, 0x83, 0x01, 0x36,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00,
	0x48, 0x6F, 0x6E, 0x6B, 0x65, 0x79, 0x31, 0x00, 0xCD, 0x80, 0x1F, 0x78, 0xF0, 0x00, 0x40, 0x00,
	0x2D, 0x00, 0xF0, 0xF5, 0x58, 0x01, 0x01, 0xF3, 0x22, 0x00, 0x40, 0xF5, 0x58, 0x1B, 0x44, 0x23,
	0x09, 0x20, 0xC0, 0xF1, 0x96, 0x03, 0x01, 0x34, 0x00, 0x70, 0x06, 0x31, 0x94, 0x88, 0x01, 0x35,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00,
	0x48, 0x6F, 0x6E, 0x6B, 0x65, 0x79, 0x32, 0x00, 0xCD, 0x80, 0x1C, 0x78, 0xF0, 0x00, 0x40, 0x00,
	0x2E, 0x00, 0xF0, 0xE5, 0x58, 0x01, 0x01, 0xF3, 0x19, 0x00, 0xF0, 0xF7, 0x58, 0x01, 0x01, 0xF3,
	0x02, 0x00, 0xF0, 0xA1, 0x96, 0x03, 0x01, 0x34, 0x00, 0x70, 0x05, 0x31, 0x94, 0x88, 0x01, 0x35,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00,
	0x50, 0x66, 0x62, 0x65, 0x6C, 0x6C, 0x20, 0x00, 0xBF, 0x80, 0x00, 0x78, 0xF4, 0x30, 0x40, 0xF4,
	0x0C, 0x20, 0xF0, 0xB3, 0x9B, 0x04, 0x00, 0xF6, 0x00, 0x70, 0x08, 0x41, 0x5F, 0x87, 0x00, 0xF7,
	0x1F, 0x20, 0x50, 0xFE, 0x1F, 0x07, 0x00, 0xE4, 0x04, 0x70, 0x08, 0x74, 0x1F, 0x88, 0x00, 0xF7,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x00, 0x00, 0x00, 0x00,
	0x50, 0x66, 0x56, 0x69, 0x62, 0x65, 0x20, 0x00, 0xBF, 0x95, 0x14, 0x78, 0xFC, 0x31, 0x40, 0xF4,
	0x24, 0x20, 0x00, 0x4C, 0x5F, 0x0C, 0x12, 0xF5, 0x00, 0x70, 0x0F, 0x71, 0x5F, 0x85, 0x00, 0xF5,
	0x28, 0x30, 0x00, 0x47, 0x5F, 0x08, 0x12, 0xF6, 0x00, 0x70, 0x0F, 0x31, 0x5F, 0x85, 0x12, 0xF6,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x21, 0x00, 0x00, 0x00, 0x00,
	0x4E, 0x65, 0x77, 0x45, 0x50, 0x32, 0x20, 0x00, 0xC1, 0x80, 0x00, 0x78, 0xF4, 0x30, 0x40, 0x00,
	0x38, 0x70, 0x00, 0x3F, 0x1F, 0x0E, 0x0F, 0x6E, 0x00, 0x70, 0x05, 0x41, 0x1F, 0x92, 0x06, 0x18,
	0x0B, 0x40, 0xF0, 0xC1, 0x5F, 0x0F, 0x05, 0x1B, 0x00, 0x70, 0x35, 0x41, 0x5F, 0x92, 0x06, 0x18,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x21, 0x00, 0x00, 0x00, 0x00,
	0x4E, 0x65, 0x77, 0x45, 0x50, 0x33, 0x20, 0x00, 0xCD, 0x80, 0x00, 0x78, 0xFC, 0x30, 0x40, 0x00,
	0x38, 0x20, 0x50, 0xB7, 0x98, 0x06, 0xC4, 0x37, 0x00, 0x70, 0x45, 0x31, 0x58, 0x8B, 0x08, 0x26,
	0x07, 0x20, 0xF0, 0xB1, 0x96, 0x04, 0x03, 0x24, 0x00, 0x70, 0x65, 0x71, 0x96, 0x84, 0x03, 0x25,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x00, 0x00, 0x00, 0x00,
	0x4E, 0x65, 0x77, 0x45, 0x50, 0x34, 0x20, 0x00, 0xC8, 0x82, 0x00, 0x78, 0xFC, 0x21, 0x40, 0x00,
	0x20, 0x70, 0x60, 0xF1, 0x9F, 0x04, 0x02, 0x0F, 0x00, 0x70, 0x30, 0x22, 0x5C, 0x9F, 0x05, 0x18,
	0x39, 0x70, 0x60, 0x8A, 0x9A, 0x03, 0xC3, 0x36, 0x00, 0x70, 0x40, 0x31, 0x98, 0x88, 0x06, 0x38,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x00, 0x00, 0x00, 0x00,
	0x4E, 0x65, 0x77, 0x45, 0x50, 0x35, 0x20, 0x00, 0xCD, 0x80, 0x00, 0x78, 0xFC, 0x20, 0x40, 0x00,
	0x24, 0x20, 0x30, 0xB7, 0x9A, 0x06, 0xC4, 0x37, 0x00, 0x70, 0x65, 0x21, 0x5A, 0x8B, 0x08, 0x26,
	0x0A, 0x00, 0xF0, 0xB1, 0x96, 0x04, 0x03, 0x24, 0x00, 0x70, 0x95, 0x71, 0x96, 0x84, 0x03, 0x25,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x00, 0x00, 0x00, 0x00,
	0x45, 0x50, 0x69, 0x61, 0x6E, 0x6F, 0x31, 0x00, 0xCD, 0x80, 0x00, 0x78, 0xC2, 0x30, 0x40, 0x00,
	0x3E, 0x20, 0x20, 0xCC, 0x1F, 0x11, 0x06, 0x99, 0x2B, 0x50, 0x30, 0x4C, 0x1F, 0x10, 0xC6, 0x7F,
	0x23, 0x20, 0x60, 0xC1, 0x1F, 0x0E, 0x05, 0x65, 0x00, 0x50, 0x30, 0x41, 0x9F, 0x9C, 0x04, 0x08,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x00, 0x00, 0x00, 0x00,
	0x45, 0x50, 0x69, 0x61, 0x6E, 0x6F, 0x32, 0x00, 0xB9, 0x99, 0x09, 0x78, 0xE6, 0x21, 0x40, 0x00,
	0x1B, 0xF0, 0xF0, 0x3E, 0x9F, 0x0C, 0xC0, 0xBA, 0x11, 0x70, 0x00, 0x53, 0x5F, 0x8C, 0x01, 0x88,
	0x00, 0x70, 0x00, 0x02, 0x57, 0x8F, 0x01, 0x7F, 0x00, 0xC0, 0x20, 0x01, 0x5E, 0x85, 0x01, 0x37,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x00, 0x00, 0x00, 0x00,
	0x45, 0x50, 0x69, 0x61, 0x6E, 0x6F, 0x33, 0x00, 0xC8, 0x88, 0x0A, 0x78, 0xFC, 0x21, 0x40, 0x00,
	0x1B, 0x70, 0x00, 0x3F, 0x96, 0x1C, 0x01, 0xA7, 0x11, 0x70, 0x00, 0x33, 0xD9, 0x86, 0x01, 0x27,
	0x11, 0x70, 0x00, 0x30, 0x97, 0x12, 0xC1, 0xE7, 0x07, 0x70, 0x00, 0x31, 0xD9, 0x84, 0x01, 0x17,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x00, 0x00, 0x00, 0x00,
	0x45, 0x50, 0x69, 0x61, 0x6E, 0x6F, 0x34, 0x00, 0xC0, 0xAD, 0x00, 0x78, 0xFB, 0x30, 0x40, 0x00,
	0x12, 0x10, 0x00, 0x40, 0x9C, 0x13, 0x8D, 0x34, 0x1F, 0x10, 0x00, 0x72, 0x1F, 0x1F, 0x00, 0x04,
	0x1F, 0x20, 0x00, 0x31, 0x1F, 0x1F, 0x00, 0x05, 0x01, 0x70, 0x00, 0x51, 0x9F, 0x89, 0x02, 0x16,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x21, 0x00, 0x00, 0x00, 0x00,
	0x45, 0x50, 0x69, 0x61, 0x6E, 0x6F, 0x35, 0x00, 0xC8, 0xA8, 0x23, 0x78, 0xDB, 0x31, 0x40, 0x00,
	0x25, 0x50, 0x40, 0x08, 0xD6, 0x11, 0x45, 0xAF, 0x2A, 0x50, 0x50, 0x04, 0xD9, 0x06, 0x02, 0xAF,
	0x11, 0x50, 0xF0, 0x02, 0x96, 0x0C, 0x02, 0xA5, 0x00, 0x30, 0x40, 0x01, 0x9F, 0x86, 0x01, 0x36,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x00, 0x00, 0x00, 0x00,
	0x48, 0x69, 0x67, 0x68, 0x54, 0x69, 0x6E, 0x00, 0xBB, 0x80, 0x08, 0x78, 0xE4, 0x30, 0x40, 0xF4,
	0x2C, 0x20, 0x60, 0xCB, 0x5F, 0x0B, 0x00, 0xF6, 0x00, 0x70, 0x04, 0x71, 0x1F, 0x89, 0x00, 0xFF,
	0x13, 0x30, 0x10, 0x41, 0x1F, 0x08, 0x00, 0xF7, 0x00, 0x70, 0x04, 0x71, 0x1F, 0x88, 0x15, 0xF8,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x21, 0x00, 0x00, 0x00, 0x00,
	0x48, 0x61, 0x72, 0x64, 0x54, 0x69, 0x6E, 0x00, 0xC0, 0x80, 0x14, 0x78, 0xE4, 0x30, 0x40, 0x00,
	0x0D, 0x30, 0x10, 0x40, 0x5F, 0x12, 0xC0, 0xF6, 0x00, 0x70, 0x04, 0x71, 0x1F, 0x91, 0xC0, 0xFF,
	0x04, 0x30, 0xC0, 0xC1, 0x5F, 0x08, 0x00, 0xF7, 0x00, 0x70, 0x54, 0x71, 0x5F, 0x88, 0x15, 0xE8,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x21, 0x00, 0x00, 0x00, 0x00,
	0x50, 0x65, 0x72, 0x63, 0x50, 0x66, 0x20, 0x00, 0xBB, 0x80, 0x00, 0x78, 0xF2, 0x30, 0x40, 0xF4,
	0x0C, 0x00, 0xF0, 0x41, 0x1F, 0x0D, 0x00, 0x0C, 0x23, 0x70, 0x00, 0x4D, 0x9F, 0x0B, 0x50, 0x26,
	0x31, 0x50, 0x60, 0x41, 0x5A, 0x12, 0x03, 0x35, 0x00, 0x70, 0x00, 0x41, 0x5D, 0x91, 0x07, 0x18,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x21, 0x00, 0x00, 0x00, 0x00,
	0x57, 0x6F, 0x6F, 0x64, 0x50, 0x66, 0x20, 0x00, 0xC3, 0x80, 0x10, 0x78, 0xF4, 0x30, 0x40, 0x00,
	0x15, 0x30, 0x00, 0x41, 0x1F, 0x0C, 0x07, 0xC8, 0x01, 0x70, 0x0F, 0x70, 0x5F, 0x89, 0x00, 0xF8,
	0x18, 0x30, 0x00, 0x41, 0x5F, 0x05, 0x07, 0x08, 0x01, 0x70, 0x0F, 0x40, 0x5F, 0x89, 0x00, 0xF8,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x21, 0x00, 0x00, 0x00, 0x00,
	0x45, 0x50, 0x53, 0x74, 0x72, 0x6E, 0x67, 0x00, 0xC9, 0x80, 0x3F, 0x78, 0xFC, 0x30, 0x40, 0x00,
	0x0C, 0x20, 0x40, 0x31, 0x9F, 0x6A, 0x01, 0x12, 0x09, 0x70, 0x08, 0x71, 0x84, 0xE1, 0x02, 0x23,
	0x23, 0x50, 0xF0, 0xBE, 0x96, 0x0C, 0x08, 0x44, 0x00, 0x70, 0x08, 0x71, 0x96, 0x84, 0x01, 0x25,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x00, 0x00, 0x00, 0x00,
	0x45, 0x50, 0x42, 0x72, 0x61, 0x73, 0x73, 0x00, 0xCD, 0x80, 0x00, 0x78, 0xFC, 0x40, 0x40, 0xF4,
	0x15, 0x50, 0x40, 0x31, 0x48, 0x63, 0x01, 0x27, 0x00, 0x70, 0x0A, 0x71, 0x8D, 0xE1, 0x01, 0x25,
	0x22, 0x50, 0x70, 0xBE, 0x96, 0x0C, 0x08, 0x44, 0x00, 0x70, 0x0B, 0x71, 0x96, 0x84, 0x01, 0x25,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x00, 0x00, 0x00, 0x00,
	0x43, 0x6C, 0x61, 0x76, 0x32, 0x20, 0x20, 0x00, 0xCD, 0x80, 0x1D, 0x78, 0xFA, 0x00, 0x40, 0x00,
	0x14, 0x10, 0x10, 0x43, 0x5F, 0x06, 0x00, 0x34, 0x2A, 0x20, 0x10, 0x49, 0x5F, 0x09, 0x04, 0x24,
	0x0B, 0x10, 0x00, 0x40, 0x5F, 0x1F, 0x00, 0x05, 0x01, 0x70, 0x06, 0x41, 0x58, 0x90, 0x09, 0x0B,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00,
	0x43, 0x6C, 0x61, 0x76, 0x33, 0x20, 0x20, 0x00, 0xCD, 0x80, 0x1E, 0x78, 0xFA, 0x00, 0x40, 0x00,
	0x0B, 0x20, 0x40, 0x20, 0x9E, 0x1C, 0x05, 0x30, 0x1E, 0x40, 0x70, 0x16, 0x5D, 0x01, 0xC1, 0xF0,
	0x0F, 0x30, 0x10, 0x10, 0x17, 0x1A, 0x01, 0x20, 0x00, 0x70, 0x00, 0x42, 0x98, 0x9B, 0x05, 0x37,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00,
	0x43, 0x6C, 0x61, 0x76, 0x34, 0x20, 0x20, 0x00, 0xCD, 0x80, 0x00, 0x78, 0xF0, 0x30, 0x40, 0x00,
	0x18, 0x70, 0x20, 0x46, 0x9F, 0x0B, 0x08, 0x6F, 0x1E, 0x70, 0xE0, 0x45, 0x1F, 0x10, 0x05, 0x06,
	0x0D, 0x70, 0x00, 0x40, 0x1F, 0x0C, 0x08, 0x05, 0x00, 0x70, 0x00, 0x41, 0x5C, 0x94, 0x08, 0x1C,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x00, 0x00, 0x00, 0x00,
	0x46, 0x75, 0x7A, 0x7A, 0x43, 0x6C, 0x76, 0x00, 0xCD, 0x80, 0x1F, 0x78, 0xDB, 0x00, 0x40, 0x00,
	0x0D, 0x40, 0x20, 0x2E, 0x9E, 0x1C, 0x05, 0x39, 0x1B, 0x70, 0x60, 0x1A, 0x9D, 0x01, 0x01, 0xFC,
	0x02, 0x40, 0x10, 0x60, 0x1E, 0x1B, 0x01, 0x29, 0x00, 0x70, 0x00, 0x43, 0x9E, 0x9C, 0x05, 0x39,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00,
	0x4D, 0x75, 0x74, 0x65, 0x43, 0x6C, 0x76, 0x00, 0xCD, 0x80, 0x1E, 0x78, 0xFA, 0x00, 0x40, 0x00,
	0x0B, 0x70, 0x40, 0x20, 0x9E, 0x1C, 0x0A, 0x30, 0x1E, 0x70, 0x70, 0x36, 0x9D, 0x01, 0xCB, 0xF0,
	0x0F, 0x70, 0x10, 0x10, 0x17, 0x1A, 0x0F, 0x20, 0x00, 0x70, 0x00, 0x42, 0x58, 0x93, 0x0F, 0x37,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00,
	0x4D, 0x75, 0x74, 0x65, 0x43, 0x6C, 0x32, 0x00, 0xCD, 0x80, 0x1E, 0x78, 0xFA, 0x00, 0x40, 0x00,
	0x00, 0x70, 0x40, 0x20, 0x9E, 0x15, 0x0A, 0xF0, 0x1E, 0x70, 0x70, 0x3F, 0x9D, 0x01, 0x0B, 0xF0,
	0x0F, 0x70, 0x10, 0x10, 0x17, 0x09, 0x0F, 0xF1, 0x00, 0x70, 0x00, 0x42, 0x58, 0x8D, 0x0F, 0xFA,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00,
	0x53, 0x79, 0x6E, 0x43, 0x6C, 0x76, 0x31, 0x00, 0xCD, 0x82, 0x00, 0x78, 0xE0, 0x31, 0x40, 0x00,
	0x05, 0x30, 0x00, 0x30, 0x47, 0x09, 0x05, 0x27, 0x11, 0x30, 0x00, 0x35, 0xDD, 0x05, 0x04, 0x14,
	0x17, 0x30, 0x00, 0x30, 0x9C, 0x06, 0x01, 0x36, 0x00, 0xE0, 0x20, 0x31, 0x5F, 0x94, 0x03, 0x1F,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x00, 0x00, 0x00, 0x00,
	0x53, 0x79, 0x6E, 0x43, 0x6C, 0x76, 0x32, 0x00, 0xCD, 0x80, 0x00, 0x78, 0xFB, 0x30, 0x40, 0x00,
	0x22, 0x40, 0x40, 0x3C, 0xDF, 0x04, 0x04, 0xF7, 0x19, 0x40, 0x40, 0x39, 0x1F, 0x05, 0x04, 0x07,
	0x08, 0x40, 0x40, 0x30, 0x1F, 0x04, 0x04, 0x17, 0x00, 0x70, 0x30, 0x31, 0xDF, 0x8F, 0x02, 0x4C,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x00, 0x00, 0x00, 0x00,
	0x53, 0x79, 0x6E, 0x43, 0x6C, 0x76, 0x33, 0x00, 0xCD, 0x80, 0x00, 0x78, 0xEA, 0x30, 0x40, 0x00,
	0x00, 0x20, 0xA0, 0x81, 0x47, 0x06, 0x04, 0x7A, 0x11, 0x10, 0x50, 0x1F, 0xDF, 0x14, 0x04, 0x56,
	0x14, 0x10, 0x40, 0x40, 0x1F, 0x0C, 0x04, 0x06, 0x00, 0x70, 0x04, 0x53, 0x9F, 0x85, 0x02, 0x2C,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x00, 0x00, 0x00, 0x00,
	0x53, 0x79, 0x6E, 0x43, 0x6C, 0x76, 0x34, 0x00, 0xCD, 0x80, 0x00, 0x78, 0xE2, 0x30, 0x40, 0x00,
	0x07, 0x20, 0x00, 0x00, 0x14, 0x02, 0x01, 0x3A, 0x11, 0x20, 0x00, 0x01, 0x14, 0x02, 0x01, 0x3A,
	0x00, 0x20, 0x00, 0x02, 0x14, 0x02, 0x01, 0x3A, 0x11, 0x70, 0x00, 0x01, 0x14, 0x82, 0x01, 0x3A,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x00, 0x00, 0x00, 0x00,
	0x48, 0x61, 0x72, 0x70, 0x73, 0x69, 0x32, 0x00, 0xCD, 0x80, 0x1E, 0x78, 0xCC, 0x00, 0x40, 0x0C,
	0x00, 0x00, 0x00, 0x12, 0xDD, 0x11, 0x00, 0x20, 0x04, 0x70, 0x08, 0x60, 0x97, 0x88, 0x06, 0x36,
	0x00, 0x00, 0x00, 0x10, 0xDD, 0x0E, 0x00, 0x20, 0x02, 0x70, 0x08, 0x54, 0x97, 0x88, 0x06, 0x36,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x48, 0x61, 0x72, 0x70, 0x73, 0x69, 0x33, 0x00, 0xCD, 0x80, 0x00, 0x78, 0xFA, 0x20, 0x40, 0x00,
	0x13, 0x00, 0x00, 0x01, 0xDF, 0x1D, 0x00, 0x2A, 0x0D, 0x00, 0x70, 0x48, 0x9F, 0x1F, 0x05, 0x2A,
	0x07, 0x00, 0x00, 0x71, 0x1F, 0x19, 0x03, 0x24, 0x00, 0x30, 0x00, 0x44, 0xDD, 0x9A, 0x03, 0x25,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x00, 0x00, 0x00, 0x00,
	0x48, 0x61, 0x72, 0x70, 0x73, 0x69, 0x34, 0x00, 0xCD, 0x80, 0x1E, 0x78, 0xDC, 0x00, 0x40, 0x00,
	0x00, 0x30, 0x00, 0x63, 0x9A, 0x13, 0x00, 0x20, 0x00, 0x70, 0x08, 0x31, 0x97, 0x88, 0x06, 0x35,
	0x00, 0x30, 0x00, 0x20, 0xCF, 0x10, 0x00, 0x20, 0x05, 0x70, 0x08, 0x14, 0x97, 0x88, 0x06, 0x35,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00,
	0x48, 0x61, 0x72, 0x70, 0x73, 0x69, 0x35, 0x00, 0xCD, 0x80, 0x1E, 0x78, 0xE2, 0x00, 0x40, 0x00,
	0x1B, 0x20, 0xA0, 0x00, 0x1F, 0x06, 0x04, 0x16, 0x07, 0x10, 0x50, 0x19, 0xDF, 0x18, 0x03, 0x26,
	0x15, 0x10, 0x40, 0x43, 0x5F, 0x18, 0x03, 0x18, 0x00, 0x20, 0x00, 0x51, 0x9F, 0x85, 0x07, 0x25,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00,
	0x43, 0x69, 0x72, 0x63, 0x75, 0x73, 0x74, 0x00, 0xCD, 0x80, 0x00, 0x78, 0xC4, 0x50, 0x40, 0x00,
	0x09, 0x70, 0x00, 0x45, 0x1D, 0x16, 0xCC, 0xF6, 0x07, 0x70, 0x28, 0x48, 0x9F, 0x8D, 0x10, 0xF4,
	0x3B, 0x70, 0x00, 0x42, 0x1C, 0x1F, 0x00, 0x0F, 0x01, 0x70, 0x08, 0x41, 0x10, 0x9F, 0x00, 0x0B,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x27, 0x00, 0x00, 0x00, 0x00,
	0x43, 0x65, 0x6C, 0x65, 0x73, 0x74, 0x65, 0x00, 0xCA, 0x80, 0x00, 0x78, 0xC4, 0x30, 0x40, 0x0C,
	0x16, 0x70, 0x00, 0x71, 0x59, 0x1C, 0xC0, 0xE6, 0x00, 0x70, 0x08, 0x31, 0x5F, 0x8A, 0x00, 0xE6,
	0x27, 0x70, 0x00, 0x37, 0x5F, 0x10, 0x00, 0xE6, 0x00, 0x70, 0x08, 0x71, 0x1F, 0x8D, 0x00, 0xE4,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x00,
	0x53, 0x71, 0x75, 0x65, 0x65, 0x7A, 0x65, 0x00, 0xCB, 0x80, 0x09, 0x78, 0xF9, 0x50, 0x40, 0x00,
	0x17, 0x30, 0x10, 0x73, 0x10, 0x06, 0x00, 0x15, 0x1E, 0x40, 0x00, 0x32, 0x1F, 0x0B, 0x00, 0x0A,
	0x1B, 0x20, 0x00, 0x74, 0x1F, 0x04, 0x00, 0x05, 0x01, 0x60, 0x06, 0x31, 0x0E, 0x9F, 0x00, 0x0A,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x00, 0x00, 0x00, 0x00
};

static const uint8_t m_voiceDefinitionBankRom3Binary[3104] = {
	0x72, 0x6F, 0x6D, 0x33, 0x20, 0x20, 0x20, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x48, 0x6F, 0x72, 0x6E, 0x32, 0x20, 0x20, 0x00, 0xCA, 0x80, 0x0C, 0x78, 0xFA, 0x40, 0x40, 0xF4,
	0x16, 0x50, 0x00, 0x41, 0x4E, 0x09, 0x00, 0x18, 0x3F, 0x50, 0x00, 0x42, 0x0F, 0x1F, 0x80, 0x0F,
	0x23, 0x50, 0x00, 0x41, 0x0E, 0x1F, 0x00, 0x08, 0x00, 0x70, 0x00, 0x41, 0x52, 0xBF, 0x00, 0x09,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x00, 0x00, 0x00, 0x00,
	0x48, 0x6F, 0x72, 0x6E, 0x33, 0x20, 0x20, 0x00, 0xCD, 0x80, 0x00, 0x78, 0xF4, 0x30, 0x40, 0xF4,
	0x10, 0x40, 0x00, 0x01, 0x0D, 0x28, 0x00, 0x38, 0x00, 0xD0, 0x21, 0x01, 0x10, 0xA2, 0x00, 0x18,
	0x16, 0x40, 0x00, 0x01, 0x10, 0x28, 0x00, 0x38, 0x00, 0xD0, 0x21, 0x01, 0x10, 0xA5, 0x00, 0x28,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x00, 0x00, 0x00, 0x00,
	0x48, 0x6F, 0x72, 0x6E, 0x73, 0x20, 0x20, 0x00, 0xCD, 0x80, 0x00, 0x78, 0xFD, 0x30, 0x40, 0xF4,
	0x15, 0x40, 0x00, 0x41, 0x0D, 0x1F, 0x0B, 0x07, 0x00, 0x70, 0x0C, 0x41, 0x10, 0xBF, 0x00, 0x09,
	0x13, 0x70, 0x0C, 0x31, 0x0E, 0x9F, 0x00, 0x08, 0x00, 0x70, 0x0C, 0x31, 0x0F, 0xBF, 0x00, 0x08,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x00, 0x00, 0x00, 0x00,
	0x46, 0x6C, 0x75, 0x67, 0x65, 0x6C, 0x68, 0x00, 0xCD, 0x80, 0x14, 0x78, 0xFA, 0x30, 0x40, 0x00,
	0x19, 0x60, 0x00, 0x41, 0x4C, 0x05, 0x00, 0xF8, 0x1F, 0x50, 0x00, 0x42, 0x1F, 0x0F, 0x80, 0xF8,
	0x29, 0x70, 0x00, 0x41, 0x0F, 0x1F, 0x00, 0x08, 0x06, 0x50, 0x00, 0x11, 0x50, 0x9F, 0x00, 0x09,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x00, 0x00, 0x00, 0x00,
	0x54, 0x72, 0x6F, 0x6D, 0x62, 0x6F, 0x6E, 0x00, 0xCD, 0x80, 0x00, 0x78, 0xFA, 0x40, 0x40, 0xF4,
	0x19, 0x60, 0x00, 0x41, 0x0F, 0x1F, 0x00, 0x08, 0x09, 0x20, 0x00, 0x42, 0x9F, 0x0E, 0x80, 0xF8,
	0x2D, 0x20, 0x00, 0x41, 0x0F, 0x1F, 0x00, 0x08, 0x01, 0x70, 0x00, 0x11, 0x13, 0x9F, 0x00, 0x08,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x00, 0x00, 0x00, 0x00,
	0x54, 0x72, 0x75, 0x6D, 0x70, 0x74, 0x32, 0x00, 0xCD, 0x80, 0x14, 0x78, 0xFA, 0x30, 0x40, 0x00,
	0x16, 0x10, 0x00, 0x41, 0x50, 0x1F, 0x00, 0x08, 0x3B, 0x20, 0x00, 0x42, 0x10, 0x1F, 0x80, 0x08,
	0x23, 0x20, 0x00, 0x41, 0x0E, 0x1F, 0x00, 0x08, 0x00, 0x40, 0x00, 0x41, 0x52, 0x9F, 0x00, 0x09,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x00, 0x00, 0x00, 0x00,
	0x42, 0x72, 0x61, 0x73, 0x73, 0x32, 0x20, 0x00, 0xCD, 0x80, 0x1B, 0x78, 0xFD, 0x30, 0x40, 0xF4,
	0x12, 0x30, 0x00, 0x41, 0x0F, 0x0A, 0x00, 0x25, 0x00, 0x60, 0x0C, 0x41, 0x15, 0x9F, 0x00, 0x0A,
	0x00, 0x60, 0x0C, 0x41, 0x15, 0x9F, 0x00, 0x0A, 0x00, 0x60, 0x0C, 0x41, 0x15, 0x9F, 0x00, 0x0A,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x00, 0x00, 0x00, 0x00,
	0x42, 0x72, 0x61, 0x73, 0x73, 0x33, 0x20, 0x00, 0xCD, 0x80, 0x00, 0x78, 0xF4, 0x30, 0x40, 0x00,
	0x0B, 0x10, 0x30, 0x30, 0x0C, 0x27, 0x03, 0x05, 0x00, 0x60, 0x08, 0x70, 0x57, 0xAD, 0x00, 0x05,
	0x04, 0x50, 0x50, 0x30, 0x0E, 0x27, 0x02, 0x16, 0x00, 0x60, 0x08, 0x70, 0x56, 0xAD, 0x00, 0x06,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x00, 0x00, 0x00, 0x00,
	0x48, 0x61, 0x72, 0x64, 0x42, 0x72, 0x31, 0x00, 0xCD, 0x80, 0x00, 0x78, 0xFA, 0x40, 0x40, 0x00,
	0x11, 0x10, 0x40, 0x41, 0x10, 0x1F, 0x00, 0x0A, 0x27, 0x00, 0x00, 0x41, 0x1F, 0x1F, 0x00, 0x0F,
	0x21, 0x10, 0x00, 0x41, 0x1F, 0x1F, 0x00, 0x0F, 0x00, 0x50, 0x00, 0x41, 0x19, 0x9F, 0x00, 0x0A,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x27, 0x00, 0x00, 0x00, 0x00,
	0x48, 0x61, 0x72, 0x64, 0x42, 0x72, 0x32, 0x00, 0xCB, 0x80, 0x99, 0x78, 0xFD, 0x40, 0x40, 0x00,
	0x0B, 0x10, 0x50, 0x01, 0x50, 0x0F, 0x04, 0x17, 0x00, 0x00, 0x50, 0x01, 0x52, 0x82, 0x00, 0x09,
	0x07, 0x00, 0x00, 0x03, 0x58, 0x82, 0x00, 0x19, 0x00, 0x00, 0x41, 0x01, 0x59, 0x82, 0x00, 0x19,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x27, 0x00, 0x00, 0x00, 0x00,
	0x48, 0x61, 0x72, 0x64, 0x42, 0x72, 0x33, 0x00, 0xCA, 0x80, 0x29, 0x78, 0xF8, 0x40, 0x40, 0xF4,
	0x1D, 0x20, 0x00, 0x33, 0x10, 0x0F, 0x00, 0x33, 0x1A, 0x30, 0x00, 0x41, 0x13, 0x1F, 0x00, 0x05,
	0x14, 0x20, 0x00, 0x41, 0x1A, 0x1F, 0x00, 0x03, 0x00, 0x50, 0x00, 0x41, 0x1B, 0x9F, 0x00, 0x0B,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x27, 0x00, 0x00, 0x00, 0x00,
	0x48, 0x61, 0x72, 0x64, 0x42, 0x72, 0x34, 0x00, 0xCD, 0x80, 0x00, 0x78, 0xF2, 0x40, 0x40, 0xF4,
	0x0E, 0x30, 0x10, 0x31, 0x11, 0x05, 0x00, 0x15, 0x0B, 0x30, 0x00, 0x31, 0x14, 0x0B, 0x0F, 0x0A,
	0x24, 0x30, 0x00, 0x71, 0x1F, 0x04, 0x00, 0x55, 0x00, 0x60, 0x00, 0x71, 0x14, 0x9F, 0x00, 0x0A,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x00, 0x00, 0x00, 0x00,
	0x48, 0x75, 0x66, 0x66, 0x42, 0x72, 0x73, 0x00, 0xCD, 0x80, 0x00, 0x78, 0xFC, 0x40, 0x40, 0x00,
	0x14, 0x50, 0x00, 0x31, 0x4D, 0x0D, 0x00, 0x27, 0x00, 0x70, 0x08, 0x71, 0x4D, 0x8D, 0x00, 0x48,
	0x09, 0x50, 0x60, 0x31, 0x4D, 0x0D, 0x00, 0x0A, 0x00, 0x70, 0x08, 0x61, 0x4D, 0x8D, 0x00, 0x48,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x00, 0x00, 0x00, 0x00,
	0x50, 0x65, 0x72, 0x63, 0x42, 0x72, 0x31, 0x00, 0xCD, 0x80, 0x31, 0x78, 0xF9, 0x40, 0x40, 0xF4,
	0x12, 0x50, 0x20, 0x4B, 0x1F, 0x11, 0x13, 0x4C, 0x00, 0x20, 0x40, 0x41, 0x1F, 0x11, 0x00, 0x13,
	0x20, 0x40, 0x40, 0x41, 0x1F, 0x0B, 0x00, 0x03, 0x01, 0x60, 0x00, 0x42, 0x19, 0x9F, 0x00, 0x05,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x00, 0x00, 0x00, 0x00,
	0x50, 0x65, 0x72, 0x63, 0x42, 0x72, 0x32, 0x00, 0xCD, 0x80, 0x32, 0x78, 0xFB, 0x40, 0x40, 0xF4,
	0x06, 0x70, 0x00, 0x41, 0x1F, 0x13, 0x00, 0x43, 0x13, 0x30, 0x40, 0x41, 0x1F, 0x1F, 0x00, 0x03,
	0x0A, 0x50, 0x40, 0x45, 0x1F, 0x15, 0x11, 0x33, 0x01, 0x50, 0x00, 0x41, 0x1F, 0x9F, 0x00, 0x05,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x00, 0x00, 0x00, 0x00,
	0x53, 0x74, 0x72, 0x69, 0x6E, 0x67, 0x31, 0x00, 0xCB, 0x80, 0x35, 0x78, 0xFA, 0x40, 0x40, 0xF4,
	0x14, 0x10, 0x30, 0x32, 0x5D, 0x1F, 0x00, 0x05, 0x17, 0x10, 0x60, 0x14, 0x5D, 0x1F, 0x00, 0x05,
	0x1D, 0x10, 0x50, 0x56, 0x5D, 0x1F, 0x00, 0x04, 0x00, 0x70, 0x00, 0x44, 0x4A, 0xBF, 0x00, 0x06,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x00, 0x00, 0x00, 0x00,
	0x53, 0x74, 0x72, 0x69, 0x6E, 0x67, 0x32, 0x00, 0xCB, 0x80, 0x35, 0x78, 0xFA, 0x40, 0x40, 0xE8,
	0x18, 0x20, 0x30, 0x32, 0x5D, 0x1F, 0x00, 0x02, 0x15, 0x70, 0x60, 0x44, 0x5D, 0x1F, 0x00, 0x03,
	0x1D, 0x20, 0x50, 0x76, 0x5D, 0x1F, 0x00, 0x03, 0x00, 0x70, 0x00, 0x44, 0x4B, 0xBF, 0x00, 0x06,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x00, 0x00, 0x00, 0x00,
	0x53, 0x74, 0x72, 0x69, 0x6E, 0x67, 0x33, 0x00, 0xC6, 0x80, 0x35, 0x78, 0xFA, 0x40, 0x40, 0x00,
	0x14, 0x20, 0x10, 0x40, 0x9F, 0x06, 0x00, 0x11, 0x18, 0x10, 0x00, 0x43, 0x9C, 0x05, 0x00, 0x55,
	0x12, 0x20, 0xD0, 0x40, 0x5B, 0x1F, 0x00, 0x03, 0x00, 0x70, 0x00, 0x40, 0x4D, 0x83, 0x00, 0x06,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x00, 0x00, 0x00, 0x00,
	0x53, 0x74, 0x72, 0x69, 0x6E, 0x67, 0x34, 0x00, 0xCB, 0x80, 0x35, 0x78, 0xFA, 0x40, 0x40, 0xF4,
	0x0E, 0x00, 0x30, 0x12, 0x5F, 0x0B, 0x00, 0x25, 0x16, 0x00, 0x30, 0x44, 0x5D, 0x1F, 0x00, 0x05,
	0x1B, 0x10, 0x50, 0x66, 0x5D, 0x1F, 0x00, 0x04, 0x01, 0x70, 0x00, 0x44, 0x4A, 0xBF, 0x00, 0x06,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x00, 0x00, 0x00, 0x00,
	0x53, 0x6F, 0x6C, 0x6F, 0x56, 0x69, 0x6F, 0x00, 0xCB, 0x80, 0x2A, 0x78, 0xFA, 0x40, 0x40, 0xF4,
	0x15, 0x20, 0x10, 0x12, 0x1B, 0x05, 0x00, 0x17, 0x18, 0x10, 0x00, 0x4C, 0x1C, 0x11, 0x90, 0x8D,
	0x16, 0x00, 0xD0, 0x44, 0x19, 0x0B, 0x06, 0x06, 0x01, 0x60, 0x00, 0x42, 0x8B, 0x8A, 0x00, 0x06,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x00, 0x00, 0x00, 0x00,
	0x52, 0x69, 0x63, 0x68, 0x53, 0x74, 0x31, 0x00, 0xCB, 0x80, 0x0E, 0x78, 0xFD, 0x40, 0x40, 0x00,
	0x10, 0x10, 0x00, 0x41, 0x1F, 0x07, 0x00, 0x13, 0x00, 0x70, 0x0C, 0x42, 0x0E, 0x9F, 0x00, 0x06,
	0x00, 0x70, 0x0C, 0x40, 0x0E, 0x9F, 0x00, 0x06, 0x00, 0x70, 0x0C, 0x41, 0x0E, 0x9F, 0x00, 0x06,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x00, 0x00, 0x00, 0x00,
	0x52, 0x69, 0x63, 0x68, 0x53, 0x74, 0x32, 0x00, 0xCB, 0x80, 0x0E, 0x78, 0xFD, 0x40, 0x40, 0x00,
	0x12, 0x20, 0x00, 0x40, 0x1F, 0x07, 0x00, 0x13, 0x00, 0x70, 0x0C, 0x40, 0x0E, 0x9F, 0x00, 0x06,
	0x00, 0x70, 0x0C, 0x40, 0x0E, 0x9F, 0x00, 0x06, 0x00, 0x70, 0x0C, 0x40, 0x0E, 0x9F, 0x00, 0x06,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x00, 0x00, 0x00, 0x00,
	0x52, 0x69, 0x63, 0x68, 0x53, 0x74, 0x33, 0x00, 0xCB, 0x80, 0x1C, 0x78, 0xFC, 0x40, 0x40, 0x00,
	0x15, 0x20, 0x00, 0x31, 0x1A, 0x05, 0x00, 0x11, 0x00, 0x70, 0x08, 0x31, 0x0C, 0x9F, 0x00, 0x06,
	0x0E, 0x20, 0x10, 0x71, 0x1A, 0x05, 0x00, 0x11, 0x00, 0x70, 0x08, 0x74, 0x0C, 0x9F, 0x00, 0x06,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x00, 0x00, 0x00, 0x00,
	0x52, 0x69, 0x63, 0x68, 0x53, 0x74, 0x34, 0x00, 0xC9, 0x80, 0x28, 0x78, 0xFC, 0x40, 0x40, 0x00,
	0x15, 0x20, 0x00, 0x71, 0x1F, 0x07, 0x00, 0x15, 0x00, 0x50, 0x08, 0x71, 0x0C, 0x9F, 0x00, 0x06,
	0x0C, 0x20, 0x20, 0x31, 0x1F, 0x07, 0x00, 0x15, 0x00, 0x50, 0x18, 0x33, 0x0C, 0x9F, 0x00, 0x07,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x27, 0x00, 0x00, 0x00, 0x00,
	0x43, 0x65, 0x6C, 0x6C, 0x6F, 0x31, 0x20, 0x00, 0xCA, 0x80, 0x2C, 0x78, 0xF2, 0x40, 0x40, 0xE8,
	0x10, 0x00, 0x20, 0x12, 0x1C, 0x05, 0x00, 0x16, 0x00, 0x00, 0xF0, 0x4E, 0x1F, 0x0F, 0x07, 0x3F,
	0x23, 0x00, 0xF0, 0x44, 0x19, 0x0B, 0x06, 0x0C, 0x00, 0x60, 0x00, 0x42, 0x8C, 0x8A, 0x00, 0x06,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x00, 0x00, 0x00, 0x00,
	0x43, 0x65, 0x6C, 0x6C, 0x6F, 0x32, 0x20, 0x00, 0xC9, 0x80, 0x28, 0x78, 0xFA, 0x40, 0x40, 0x00,
	0x11, 0x50, 0x00, 0x70, 0x9F, 0x09, 0x00, 0x13, 0x18, 0x00, 0x00, 0x60, 0x89, 0x09, 0x00, 0xF5,
	0x10, 0x00, 0xD0, 0x30, 0x5B, 0x1F, 0x00, 0x06, 0x00, 0x70, 0x00, 0x40, 0x4B, 0x83, 0x00, 0x06,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x00, 0x00, 0x00, 0x00,
	0x4C, 0x6F, 0x53, 0x74, 0x72, 0x67, 0x33, 0x00, 0xCA, 0x83, 0x38, 0x78, 0xFA, 0x30, 0x40, 0xF4,
	0x18, 0x20, 0x20, 0x11, 0x54, 0x02, 0x00, 0x15, 0x11, 0x10, 0x50, 0x15, 0x59, 0x06, 0x00, 0x38,
	0x2F, 0x20, 0x40, 0x01, 0x5C, 0x03, 0x00, 0x16, 0x00, 0xE0, 0x10, 0x21, 0x4C, 0x84, 0x00, 0x06,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x00, 0x00, 0x00, 0x00,
	0x4C, 0x6F, 0x53, 0x74, 0x72, 0x67, 0x34, 0x00, 0xC8, 0x80, 0xB4, 0x78, 0xF2, 0x30, 0x40, 0x00,
	0x10, 0x90, 0x50, 0x30, 0x5E, 0x04, 0x00, 0x16, 0x0C, 0x40, 0xF8, 0x75, 0x5F, 0x08, 0x00, 0x78,
	0x11, 0x20, 0xF0, 0x30, 0x10, 0x05, 0x00, 0x16, 0x00, 0x70, 0x80, 0x30, 0x0B, 0xA5, 0x00, 0x06,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x00, 0x00, 0x00, 0x00,
	0x4C, 0x6F, 0x53, 0x74, 0x72, 0x67, 0x35, 0x00, 0xCD, 0x82, 0x37, 0x78, 0xF1, 0x30, 0x40, 0x00,
	0x0E, 0x90, 0x50, 0x30, 0x5E, 0x04, 0x02, 0x26, 0x0A, 0x40, 0xF8, 0x35, 0x5F, 0x0C, 0x00, 0x74,
	0x0D, 0x20, 0xF0, 0x31, 0x1E, 0x0C, 0x02, 0x17, 0x00, 0x70, 0x80, 0x30, 0x0C, 0x85, 0x00, 0x06,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x00, 0x00, 0x00, 0x00,
	0x4F, 0x72, 0x63, 0x68, 0x65, 0x73, 0x74, 0x00, 0xC9, 0x80, 0x28, 0x78, 0xFC, 0x40, 0x40, 0xF4,
	0x14, 0x30, 0x00, 0x32, 0x1F, 0x07, 0x00, 0x12, 0x00, 0x70, 0x08, 0x32, 0x0B, 0xBF, 0x00, 0x05,
	0x0B, 0x30, 0x20, 0x71, 0x1F, 0x07, 0x00, 0x13, 0x00, 0x70, 0x18, 0x42, 0x0B, 0xBF, 0x00, 0x05,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x27, 0x00, 0x00, 0x00, 0x00,
	0x35, 0x74, 0x68, 0x20, 0x53, 0x74, 0x72, 0x00, 0xC9, 0x80, 0x28, 0x78, 0xFC, 0x40, 0x40, 0xF4,
	0x15, 0x20, 0x00, 0x72, 0x1F, 0x07, 0x00, 0x15, 0x00, 0x70, 0x08, 0x72, 0x0C, 0x9F, 0x00, 0x05,
	0x0C, 0x20, 0x20, 0x33, 0x1F, 0x07, 0x00, 0x15, 0x00, 0x70, 0x18, 0x33, 0x0C, 0x9F, 0x00, 0x05,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x00, 0x00, 0x00, 0x00,
	0x50, 0x69, 0x7A, 0x7A, 0x69, 0x63, 0x31, 0x00, 0xCD, 0x80, 0x21, 0x78, 0xFC, 0x00, 0x40, 0x00,
	0x0D, 0x70, 0x00, 0x41, 0x1B, 0x18, 0x15, 0x5F, 0x00, 0x70, 0x08, 0x41, 0x1F, 0x8D, 0x00, 0xF8,
	0x0C, 0x70, 0x00, 0x41, 0x1F, 0x1F, 0x00, 0x3F, 0x00, 0x70, 0x08, 0x41, 0x5F, 0x90, 0x00, 0xF6,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0C, 0x00, 0x00, 0x00, 0x00,
	0x50, 0x69, 0x7A, 0x7A, 0x69, 0x63, 0x32, 0x00, 0xCD, 0x84, 0x1D, 0x78, 0xFE, 0x21, 0x40, 0x0C,
	0x13, 0x70, 0x40, 0x01, 0x1F, 0x13, 0x00, 0xF9, 0x00, 0x70, 0x20, 0x01, 0x5C, 0x8C, 0x00, 0xF9,
	0x00, 0x70, 0x60, 0x01, 0x19, 0x8C, 0x00, 0xF7, 0x00, 0x70, 0x60, 0x00, 0x19, 0x99, 0x80, 0xF6,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2C, 0x00, 0x00, 0x00, 0x00,
	0x46, 0x6C, 0x75, 0x74, 0x65, 0x32, 0x20, 0x00, 0xCB, 0xA6, 0x20, 0x78, 0xFB, 0x40, 0x40, 0x00,
	0x0C, 0x40, 0x00, 0x43, 0x5F, 0x14, 0x53, 0x59, 0x22, 0x10, 0x60, 0x44, 0x1F, 0x11, 0x00, 0x26,
	0x17, 0x20, 0x60, 0x42, 0x1F, 0x1F, 0x00, 0x05, 0x00, 0x70, 0x10, 0x42, 0x50, 0x9F, 0x00, 0x0B,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x00, 0x00, 0x00, 0x00,
	0x46, 0x6C, 0x75, 0x74, 0x65, 0x33, 0x20, 0x00, 0xCA, 0x80, 0x2A, 0x78, 0xFB, 0x40, 0x40, 0x00,
	0x00, 0x20, 0x00, 0x4F, 0x53, 0x12, 0xC0, 0x19, 0x21, 0x30, 0x00, 0x42, 0x1F, 0x14, 0x00, 0xBF,
	0x15, 0x10, 0x50, 0x41, 0x1F, 0x14, 0x00, 0x15, 0x01, 0x70, 0x00, 0x41, 0x4F, 0x9F, 0x00, 0x0B,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x00, 0x00, 0x00, 0x00,
	0x46, 0x6C, 0x75, 0x74, 0x65, 0x34, 0x20, 0x00, 0xCD, 0x80, 0x10, 0x78, 0xFB, 0x40, 0x40, 0x00,
	0x21, 0x40, 0x00, 0x41, 0x10, 0x17, 0xC0, 0xF6, 0x29, 0x40, 0x00, 0x41, 0x10, 0x1F, 0x00, 0x00,
	0x12, 0x40, 0xA0, 0x41, 0x19, 0x1F, 0x00, 0x07, 0x05, 0x70, 0x00, 0x41, 0x0F, 0x9F, 0x00, 0x09,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x00, 0x00, 0x00, 0x00,
	0x50, 0x61, 0x6E, 0x20, 0x46, 0x6C, 0x74, 0x00, 0xC9, 0x80, 0x22, 0x78, 0xFA, 0x40, 0x40, 0x00,
	0x20, 0x50, 0x50, 0x74, 0x5B, 0x12, 0x00, 0x29, 0x06, 0x30, 0x00, 0x34, 0x19, 0x14, 0x40, 0x86,
	0x2A, 0x40, 0x50, 0x72, 0x1F, 0x14, 0x00, 0x15, 0x01, 0x70, 0x00, 0x31, 0x50, 0x9F, 0x00, 0x08,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x00, 0x00, 0x00, 0x00,
	0x53, 0x6C, 0x6F, 0x77, 0x46, 0x6C, 0x74, 0x00, 0xC9, 0x8B, 0x2D, 0x78, 0xFB, 0x31, 0x40, 0x0C,
	0x11, 0x70, 0x40, 0x72, 0xDF, 0x09, 0x43, 0xE5, 0x25, 0x70, 0x80, 0x02, 0x54, 0x07, 0x00, 0xF5,
	0x1C, 0x70, 0xA0, 0x31, 0xD0, 0x0B, 0x00, 0x25, 0x00, 0x70, 0x40, 0x01, 0x88, 0xA4, 0x00, 0x08,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x00, 0x00, 0x00, 0x00,
	0x35, 0x74, 0x68, 0x20, 0x46, 0x6C, 0x74, 0x00, 0xC8, 0x80, 0x1E, 0x78, 0xDC, 0x30, 0x40, 0xF4,
	0x13, 0x00, 0x00, 0x73, 0x08, 0x0A, 0x01, 0x3A, 0x00, 0x00, 0x00, 0x33, 0x0F, 0x88, 0x01, 0x3A,
	0x16, 0x60, 0x00, 0x32, 0x14, 0x0A, 0x01, 0x5A, 0x00, 0x50, 0x00, 0x72, 0x0F, 0x88, 0x01, 0x3A,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x00, 0x00, 0x00, 0x00,
	0x4F, 0x62, 0x6F, 0x65, 0x32, 0x20, 0x20, 0x00, 0xCC, 0x80, 0x22, 0x78, 0xEA, 0x40, 0x40, 0x00,
	0x07, 0x20, 0x50, 0x40, 0x53, 0x12, 0x00, 0x29, 0x0F, 0x20, 0x60, 0x43, 0x1F, 0x11, 0x00, 0x36,
	0x13, 0x10, 0x50, 0x40, 0x1F, 0x14, 0x00, 0x15, 0x01, 0x50, 0x00, 0x42, 0x50, 0x9F, 0x00, 0x0B,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x00, 0x00, 0x00, 0x00,
	0x42, 0x61, 0x73, 0x73, 0x6F, 0x6F, 0x6E, 0x00, 0xC9, 0x80, 0x14, 0x78, 0xF8, 0x40, 0x40, 0xF4,
	0x27, 0x40, 0x00, 0x40, 0x10, 0x17, 0x00, 0x06, 0x18, 0x30, 0x00, 0x41, 0x10, 0x1F, 0x00, 0x00,
	0x12, 0x30, 0xA0, 0x40, 0x19, 0x1F, 0x00, 0x07, 0x06, 0x70, 0x00, 0x42, 0x0F, 0x9F, 0x00, 0x09,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x00,
	0x52, 0x65, 0x65, 0x64, 0x20, 0x20, 0x20, 0x00, 0xCC, 0x80, 0x22, 0x78, 0xEA, 0x40, 0x40, 0x00,
	0x07, 0x30, 0x50, 0x40, 0x53, 0x12, 0x00, 0x29, 0x0F, 0x40, 0x60, 0x43, 0x1F, 0x11, 0x00, 0x36,
	0x13, 0x40, 0x50, 0x40, 0x1F, 0x14, 0x00, 0x15, 0x0B, 0x70, 0x00, 0x43, 0x50, 0x9F, 0x00, 0x0B,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x00, 0x00, 0x00, 0x00,
	0x48, 0x61, 0x72, 0x6D, 0x6F, 0x6E, 0x32, 0x00, 0xC9, 0x80, 0x0D, 0x78, 0xC0, 0x41, 0x40, 0x00,
	0x42, 0x40, 0x00, 0x79, 0x1F, 0x1F, 0x80, 0x09, 0x1C, 0x40, 0x00, 0x4A, 0x1F, 0x1F, 0x00, 0x09,
	0x26, 0x40, 0x00, 0x41, 0x1F, 0x1F, 0x00, 0x03, 0x00, 0x70, 0x00, 0x42, 0x0D, 0x9F, 0x00, 0x08,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x00, 0x00, 0x00, 0x00,
	0x48, 0x61, 0x72, 0x6D, 0x6F, 0x6E, 0x33, 0x00, 0xC9, 0x8E, 0x28, 0x78, 0xFB, 0x41, 0x40, 0x00,
	0x0F, 0x20, 0x40, 0x45, 0x1F, 0x1F, 0x00, 0x06, 0x2C, 0x20, 0x00, 0x76, 0x1F, 0x1F, 0x00, 0x05,
	0x15, 0x10, 0x00, 0x41, 0x1F, 0x1F, 0x00, 0x05, 0x01, 0x70, 0x00, 0x41, 0x0D, 0x9F, 0x00, 0x09,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x00, 0x00, 0x00, 0x00,
	0x48, 0x61, 0x72, 0x6D, 0x6F, 0x6E, 0x34, 0x00, 0xC9, 0x80, 0x00, 0x78, 0xF0, 0x40, 0x40, 0x00,
	0x12, 0x20, 0x40, 0x45, 0x1F, 0x1F, 0x00, 0x06, 0x2C, 0x10, 0x00, 0x33, 0x1F, 0x1F, 0x00, 0x05,
	0x15, 0x20, 0x00, 0x51, 0x1F, 0x1F, 0x00, 0x05, 0x01, 0x70, 0x00, 0x42, 0x0D, 0x9F, 0x00, 0x09,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x00, 0x00, 0x00, 0x00,
	0x4D, 0x6F, 0x6E, 0x6F, 0x53, 0x61, 0x78, 0x00, 0xCB, 0x80, 0x1E, 0x78, 0xFA, 0x40, 0x40, 0x00,
	0x14, 0x20, 0x00, 0x61, 0x5D, 0x04, 0x00, 0x16, 0x20, 0x20, 0x00, 0x48, 0x5D, 0x0F, 0x80, 0x58,
	0x1E, 0x10, 0x20, 0x71, 0x5D, 0x1F, 0x00, 0x03, 0x01, 0x70, 0x00, 0x42, 0x50, 0x9F, 0x00, 0x0A,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x8A, 0x22, 0x00, 0x00, 0x00, 0x00,
	0x53, 0x61, 0x78, 0x20, 0x31, 0x20, 0x20, 0x00, 0xC8, 0x8A, 0x39, 0x78, 0xE0, 0x31, 0x40, 0x00,
	0x1B, 0x50, 0x10, 0x32, 0x9C, 0x04, 0x42, 0x23, 0x39, 0xD0, 0x60, 0x38, 0x5C, 0x08, 0x04, 0x3B,
	0x09, 0x50, 0x40, 0x30, 0x57, 0x02, 0x00, 0x12, 0x00, 0x70, 0x30, 0x31, 0x12, 0x84, 0x00, 0x2B,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x00, 0x00, 0x00, 0x00,
	0x53, 0x61, 0x78, 0x20, 0x32, 0x20, 0x20, 0x00, 0xCB, 0x80, 0x00, 0x78, 0xFA, 0x40, 0x40, 0x00,
	0x18, 0x10, 0x00, 0x40, 0x10, 0x1F, 0x00, 0x09, 0x2B, 0x20, 0x00, 0x34, 0x10, 0x1F, 0x40, 0x09,
	0x16, 0x20, 0x60, 0x40, 0x10, 0x1F, 0x00, 0x09, 0x00, 0x70, 0x00, 0x41, 0x10, 0x9F, 0x00, 0x09,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x00, 0x00, 0x00, 0x00
};

static const uint8_t m_voiceDefinitionBankRom4Binary[3104] = {
	0x72, 0x6F, 0x6D, 0x34, 0x20, 0x20, 0x20, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x46, 0x6E, 0x6B, 0x53, 0x79, 0x6E, 0x32, 0x00, 0xC8, 0x80, 0x28, 0x78, 0xFB, 0x53, 0x40, 0x00,
	0x22, 0x20, 0x00, 0x33, 0x07, 0x07, 0x00, 0x78, 0x0E, 0x20, 0x00, 0x70, 0x1F, 0x06, 0x00, 0x37,
	0x02, 0x20, 0x10, 0x20, 0x1F, 0x09, 0x00, 0x58, 0x00, 0x40, 0x10, 0x32, 0x14, 0x8C, 0x00, 0x1A,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x22, 0x00, 0x00, 0x00, 0x00,
	0x46, 0x6E, 0x6B, 0x53, 0x79, 0x6E, 0x33, 0x00, 0xC8, 0x80, 0x9E, 0x78, 0xD9, 0x50, 0x40, 0x00,
	0x00, 0x00, 0x00, 0x30, 0x05, 0x03, 0x05, 0x3A, 0x00, 0x00, 0x00, 0x70, 0x1F, 0x07, 0x02, 0xAA,
	0x1B, 0x00, 0x00, 0x08, 0x16, 0x02, 0x01, 0x3A, 0x07, 0x00, 0x00, 0x05, 0x14, 0x82, 0x01, 0x3A,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x00, 0x00, 0x00, 0x00,
	0x53, 0x79, 0x6E, 0x4F, 0x72, 0x67, 0x6E, 0x00, 0xC8, 0x80, 0x9E, 0x78, 0xD9, 0x50, 0x40, 0x0C,
	0x07, 0x40, 0x00, 0x20, 0x12, 0x07, 0x05, 0x2C, 0x0F, 0xF0, 0x65, 0x39, 0x05, 0x05, 0x05, 0x2C,
	0x1B, 0x40, 0x00, 0x21, 0x19, 0x02, 0x00, 0x2C, 0x00, 0xF0, 0x65, 0x22, 0x17, 0x83, 0x00, 0x29,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x00, 0x00, 0x00, 0x00,
	0x53, 0x79, 0x6E, 0x46, 0x65, 0x65, 0x64, 0x00, 0xCD, 0x80, 0x0C, 0x78, 0xFB, 0x50, 0x40, 0xF4,
	0x28, 0x10, 0x20, 0x41, 0x1B, 0x03, 0x00, 0x1A, 0x0B, 0x00, 0xA0, 0x42, 0x12, 0x1F, 0x00, 0x0A,
	0x07, 0x00, 0x00, 0x52, 0x12, 0x1F, 0x00, 0x0A, 0x00, 0x40, 0x06, 0x42, 0x12, 0x9F, 0x00, 0x0A,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x00, 0x00, 0x00, 0x00,
	0x53, 0x79, 0x6E, 0x48, 0x61, 0x72, 0x6D, 0x00, 0xCD, 0x80, 0x00, 0x78, 0xF0, 0x50, 0x40, 0x00,
	0x11, 0x10, 0x10, 0x13, 0x10, 0x06, 0x00, 0x15, 0x2D, 0x10, 0x00, 0x42, 0x1F, 0x0B, 0x00, 0x0A,
	0x10, 0x10, 0x00, 0x51, 0x1F, 0x04, 0x00, 0x05, 0x00, 0x60, 0x00, 0x41, 0x10, 0x9F, 0x00, 0x0A,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x00, 0x00, 0x00, 0x00,
	0x53, 0x79, 0x6E, 0x43, 0x6C, 0x61, 0x72, 0x00, 0xC8, 0x80, 0x23, 0x78, 0xF3, 0x50, 0x40, 0x00,
	0x2F, 0x50, 0x40, 0x09, 0x5F, 0x04, 0x00, 0xF0, 0x07, 0x50, 0x50, 0x01, 0x14, 0x04, 0x01, 0x4B,
	0x07, 0x50, 0xF0, 0x01, 0x54, 0x0F, 0x00, 0x09, 0x00, 0x50, 0x40, 0x01, 0x58, 0x86, 0x00, 0x19,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x00, 0x00, 0x00, 0x00,
	0x53, 0x79, 0x6E, 0x4C, 0x65, 0x61, 0x64, 0x00, 0xCD, 0x80, 0x00, 0x78, 0xFC, 0x50, 0x40, 0xF4,
	0x14, 0x30, 0x00, 0x32, 0x1F, 0x1F, 0x00, 0x06, 0x01, 0x70, 0x08, 0x32, 0x12, 0x9F, 0x00, 0x0B,
	0x11, 0x70, 0x00, 0x71, 0x1F, 0x15, 0x00, 0x05, 0x01, 0x30, 0x08, 0x71, 0x12, 0x9F, 0x00, 0x0B,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x00, 0x00, 0x00, 0x00,
	0x48, 0x75, 0x66, 0x66, 0x54, 0x61, 0x6B, 0x00, 0xCD, 0x80, 0x15, 0x78, 0xE1, 0x50, 0x40, 0x00,
	0x3E, 0x20, 0x00, 0x73, 0x0E, 0x1F, 0x48, 0x0F, 0x06, 0x30, 0x00, 0x46, 0x1F, 0x1F, 0xCD, 0x8F,
	0x15, 0x30, 0x00, 0x21, 0x0D, 0x1F, 0x00, 0x0F, 0x04, 0x60, 0x00, 0x61, 0x15, 0x9F, 0x00, 0x0A,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x81, 0x22, 0x00, 0x00, 0x00, 0x00,
	0x53, 0x6F, 0x48, 0x65, 0x61, 0x76, 0x79, 0x00, 0xCD, 0x80, 0x00, 0x78, 0xF9, 0x50, 0x40, 0xF4,
	0x12, 0x10, 0x00, 0x41, 0x1F, 0x08, 0x00, 0x58, 0x15, 0x50, 0x00, 0x40, 0x0F, 0x04, 0x00, 0x5A,
	0x0F, 0x40, 0x00, 0x40, 0x1F, 0x10, 0x00, 0x04, 0x00, 0x40, 0x04, 0x41, 0x1F, 0x9F, 0x00, 0x0C,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x00, 0x00, 0x00, 0x00,
	0x48, 0x6F, 0x6C, 0x6C, 0x6F, 0x77, 0x20, 0x00, 0xCD, 0x80, 0x00, 0x78, 0xFD, 0x50, 0x40, 0x00,
	0x12, 0x50, 0x20, 0x42, 0x1F, 0x0D, 0x00, 0x4A, 0x00, 0x40, 0x0F, 0x41, 0x1F, 0x9F, 0x00, 0x0D,
	0x00, 0x40, 0x0F, 0x41, 0x1F, 0x9F, 0x00, 0x0D, 0x00, 0x40, 0x0F, 0x41, 0x1F, 0x9F, 0x00, 0x0D,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x27, 0x00, 0x00, 0x00, 0x00,
	0x53, 0x63, 0x68, 0x6D, 0x6F, 0x6F, 0x68, 0x00, 0xCB, 0x80, 0x2C, 0x78, 0xE4, 0x50, 0x40, 0x00,
	0x0C, 0x40, 0xD0, 0x32, 0x0C, 0x3F, 0x03, 0x05, 0x02, 0x60, 0x08, 0x71, 0x88, 0xDF, 0x01, 0x09,
	0x0C, 0x40, 0xD0, 0x72, 0x0C, 0x3F, 0x03, 0x05, 0x05, 0x60, 0x08, 0x31, 0x88, 0xDF, 0x01, 0x09,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x00, 0x00, 0x00, 0x00,
	0x4D, 0x6F, 0x6E, 0x6F, 0x53, 0x79, 0x6E, 0x00, 0xCD, 0x80, 0x00, 0x78, 0xFD, 0x50, 0x40, 0xF4,
	0x14, 0x50, 0x10, 0x41, 0x1F, 0x0B, 0x00, 0x2A, 0x00, 0x60, 0x09, 0x41, 0x1F, 0x9F, 0x00, 0x0D,
	0x00, 0x60, 0x09, 0x41, 0x1F, 0x9F, 0x00, 0x0D, 0x00, 0x60, 0x09, 0x41, 0x1F, 0x9F, 0x00, 0x0D,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x8B, 0x25, 0x00, 0x00, 0x00, 0x00,
	0x43, 0x68, 0x65, 0x65, 0x6B, 0x79, 0x20, 0x00, 0xCD, 0x80, 0x00, 0x78, 0xF2, 0x40, 0x40, 0x00,
	0x0A, 0x70, 0x00, 0x20, 0x9E, 0x1C, 0x01, 0x20, 0x21, 0x70, 0x70, 0x3F, 0x9F, 0x13, 0x07, 0x90,
	0x0B, 0x70, 0x10, 0x10, 0x17, 0x1A, 0x0A, 0x5F, 0x00, 0x70, 0x00, 0x42, 0x98, 0x93, 0x06, 0x2A,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x00, 0x00, 0x00, 0x00,
	0x53, 0x79, 0x6E, 0x42, 0x65, 0x6C, 0x6C, 0x00, 0xC8, 0x80, 0x31, 0x78, 0xFA, 0x30, 0x40, 0x00,
	0x16, 0x60, 0x15, 0x22, 0x09, 0x12, 0x00, 0x06, 0x07, 0x60, 0x05, 0x03, 0x03, 0x07, 0x00, 0x3F,
	0x07, 0x60, 0x15, 0x73, 0x1F, 0x07, 0x00, 0x53, 0x06, 0x40, 0x05, 0x22, 0x1F, 0x8F, 0x00, 0x05,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x00, 0x00, 0x00, 0x00,
	0x53, 0x79, 0x6E, 0x50, 0x6C, 0x75, 0x6B, 0x00, 0xCD, 0x80, 0x00, 0x78, 0xFB, 0x30, 0x40, 0xF4,
	0x14, 0x20, 0x00, 0x47, 0x1F, 0x15, 0x0B, 0x16, 0x10, 0x30, 0x00, 0x44, 0x94, 0x1F, 0x05, 0x16,
	0x0A, 0x30, 0x00, 0x41, 0x1F, 0x1F, 0x00, 0x0F, 0x00, 0x70, 0x07, 0x42, 0x9F, 0x8C, 0x05, 0x17,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x00, 0x00, 0x00, 0x00,
	0x45, 0x42, 0x61, 0x73, 0x73, 0x33, 0x20, 0x00, 0xCC, 0x80, 0x00, 0x78, 0xFB, 0x30, 0x40, 0xF4,
	0x12, 0x70, 0xF0, 0x4D, 0x9F, 0x11, 0x00, 0xDF, 0x10, 0x70, 0x00, 0x41, 0x1F, 0x0D, 0x00, 0xDF,
	0x10, 0x70, 0x00, 0x40, 0x1F, 0x09, 0x00, 0xD7, 0x00, 0x60, 0x03, 0x40, 0x1F, 0x89, 0x00, 0xD8,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x00, 0x00, 0x00, 0x00,
	0x52, 0x75, 0x62, 0x42, 0x61, 0x73, 0x73, 0x00, 0xCB, 0x80, 0x09, 0x78, 0xF5, 0x40, 0x40, 0xF4,
	0x0E, 0x70, 0x00, 0x41, 0x1F, 0x0E, 0x07, 0xF6, 0x20, 0x50, 0x08, 0x41, 0x1F, 0x8B, 0x00, 0xE9,
	0x0D, 0x50, 0x08, 0x41, 0x1F, 0x8C, 0x00, 0x19, 0x00, 0x50, 0x08, 0x41, 0x1F, 0x9F, 0x00, 0x09,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x27, 0x00, 0x00, 0x00, 0x00,
	0x53, 0x6F, 0x6C, 0x42, 0x61, 0x73, 0x73, 0x00, 0xC4, 0x80, 0x10, 0x78, 0xF9, 0x30, 0x40, 0xF4,
	0x15, 0x70, 0x00, 0x41, 0x1F, 0x10, 0x07, 0xC8, 0x1B, 0x50, 0x00, 0x71, 0x5F, 0x11, 0x00, 0xF8,
	0x18, 0x70, 0x00, 0x40, 0x5F, 0x09, 0x00, 0xF8, 0x00, 0x30, 0x00, 0x40, 0x5F, 0x89, 0x00, 0xF8,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x00, 0x00, 0x00, 0x00,
	0x50, 0x6C, 0x75, 0x6B, 0x42, 0x61, 0x73, 0x00, 0xC1, 0x80, 0x10, 0x78, 0xF9, 0x40, 0x40, 0xF4,
	0x20, 0x70, 0x00, 0x4A, 0x1F, 0x12, 0x07, 0xC8, 0x1B, 0x70, 0x00, 0x71, 0x5F, 0x11, 0x00, 0xF8,
	0x18, 0x70, 0x00, 0x40, 0x5F, 0x09, 0x00, 0xF8, 0x00, 0x60, 0x00, 0x40, 0x5F, 0x89, 0x00, 0xF8,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x00, 0x00, 0x00, 0x00,
	0x55, 0x70, 0x72, 0x74, 0x42, 0x61, 0x73, 0x00, 0xC5, 0x80, 0x10, 0x78, 0xFA, 0x40, 0x40, 0xE8,
	0x1C, 0x50, 0x00, 0x31, 0x89, 0x1F, 0x06, 0x05, 0x0A, 0x60, 0xF0, 0x71, 0x91, 0x0B, 0x05, 0x76,
	0x10, 0x60, 0xF0, 0x72, 0x9E, 0x0D, 0x0C, 0x78, 0x00, 0x70, 0xF0, 0x31, 0x99, 0x92, 0x06, 0x26,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x00, 0x00, 0x00, 0x00,
	0x46, 0x72, 0x65, 0x74, 0x6C, 0x65, 0x73, 0x00, 0xCB, 0x80, 0x1F, 0x78, 0xFA, 0x30, 0x40, 0xE8,
	0x10, 0x50, 0xF0, 0x31, 0x88, 0x06, 0x01, 0x15, 0x17, 0x50, 0xF0, 0x72, 0x9E, 0x0D, 0x0C, 0x78,
	0x07, 0x50, 0xF0, 0x71, 0x9B, 0x0D, 0x02, 0x18, 0x00, 0x50, 0xF0, 0x41, 0x99, 0x92, 0x05, 0x06,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x00, 0x00, 0x00, 0x00,
	0x46, 0x6C, 0x61, 0x70, 0x42, 0x61, 0x73, 0x00, 0xC6, 0x80, 0x00, 0x78, 0xF5, 0x30, 0x40, 0xF4,
	0x08, 0x30, 0x30, 0x10, 0x5F, 0x0E, 0x00, 0x46, 0x01, 0x50, 0x08, 0x51, 0x5F, 0x9F, 0x00, 0x07,
	0x0B, 0x70, 0x08, 0x40, 0x5F, 0x9F, 0x00, 0x07, 0x01, 0x50, 0x08, 0x11, 0x5F, 0x9F, 0x00, 0x07,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x00, 0x00, 0x00, 0x00,
	0x4D, 0x6F, 0x6E, 0x6F, 0x42, 0x61, 0x73, 0x00, 0xC4, 0x80, 0x07, 0x78, 0xF3, 0x30, 0x40, 0xF4,
	0x1C, 0x40, 0x00, 0x40, 0x1F, 0x0D, 0x19, 0xB8, 0x0A, 0x50, 0x00, 0x70, 0x5F, 0x0A, 0x0F, 0x48,
	0x1F, 0x50, 0x00, 0x30, 0x5F, 0x09, 0x00, 0xF8, 0x00, 0x40, 0x00, 0x40, 0x5F, 0x88, 0x00, 0xF8,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x8D, 0x22, 0x00, 0x00, 0x00, 0x00,
	0x53, 0x79, 0x6E, 0x42, 0x61, 0x73, 0x31, 0x00, 0xCD, 0x80, 0x00, 0x78, 0xF8, 0x30, 0x40, 0xF4,
	0x12, 0x50, 0x40, 0x70, 0x5F, 0x0D, 0x00, 0x58, 0x11, 0x30, 0x00, 0x30, 0x1F, 0x0C, 0x00, 0x5A,
	0x10, 0x40, 0x00, 0x70, 0x1F, 0x09, 0x00, 0xF9, 0x00, 0x40, 0x00, 0x40, 0x1F, 0x9F, 0x00, 0x0C,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x00, 0x00, 0x00, 0x00,
	0x53, 0x79, 0x6E, 0x42, 0x61, 0x73, 0x32, 0x00, 0xCD, 0x80, 0x00, 0x78, 0xF0, 0x30, 0x40, 0xF4,
	0x18, 0x30, 0x20, 0x46, 0x9F, 0x0B, 0x08, 0x6F, 0x1E, 0x40, 0xE0, 0x45, 0x1F, 0x10, 0x05, 0x06,
	0x0D, 0x40, 0x00, 0x40, 0x1F, 0x0C, 0x08, 0x05, 0x00, 0x70, 0x04, 0x41, 0x5C, 0x94, 0x08, 0x1C,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x00, 0x00, 0x00, 0x00,
	0x53, 0x79, 0x6E, 0x42, 0x61, 0x73, 0x33, 0x00, 0xCD, 0x80, 0x00, 0x78, 0xF8, 0x40, 0x40, 0xF4,
	0x12, 0x50, 0x40, 0x40, 0x5F, 0x0D, 0x00, 0x58, 0x11, 0x40, 0x00, 0x40, 0x1F, 0x0C, 0x00, 0x5A,
	0x1D, 0x40, 0x00, 0x41, 0x1F, 0x1F, 0x00, 0x09, 0x01, 0x50, 0x00, 0x40, 0x1F, 0x9F, 0x00, 0x0C,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x00, 0x00, 0x00, 0x00,
	0x53, 0x79, 0x6E, 0x42, 0x61, 0x73, 0x34, 0x00, 0xC8, 0x80, 0x28, 0x78, 0xFD, 0x30, 0x40, 0xF4,
	0x18, 0x70, 0x00, 0x30, 0x5F, 0x0A, 0x04, 0x3A, 0x1B, 0xF0, 0x05, 0x47, 0x9F, 0x8C, 0x0A, 0xAF,
	0x07, 0x70, 0x05, 0x31, 0x9E, 0x89, 0x04, 0x16, 0x00, 0x70, 0x05, 0x30, 0x5E, 0x87, 0x04, 0x17,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x00, 0x00, 0x00, 0x00,
	0x53, 0x79, 0x6E, 0x42, 0x61, 0x73, 0x35, 0x00, 0xC8, 0x80, 0x9E, 0x78, 0xE9, 0x30, 0x40, 0xF4,
	0x25, 0x40, 0x40, 0x35, 0x1E, 0x03, 0x05, 0xB6, 0x33, 0x40, 0x40, 0x30, 0xD0, 0x04, 0x08, 0xB6,
	0x0F, 0x40, 0x40, 0x30, 0xDC, 0x04, 0x06, 0xB6, 0x00, 0x40, 0x00, 0x31, 0xDC, 0x85, 0x03, 0xB7,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x00, 0x00, 0x00, 0x00,
	0x53, 0x79, 0x6E, 0x42, 0x61, 0x73, 0x36, 0x00, 0xCC, 0x80, 0x1E, 0x78, 0xF1, 0x30, 0x40, 0xF4,
	0x11, 0x70, 0x40, 0x31, 0x5F, 0x08, 0x04, 0xA6, 0x3E, 0x70, 0x80, 0x3F, 0x5F, 0x0F, 0x89, 0xFB,
	0x11, 0x70, 0x60, 0x31, 0x5F, 0x1A, 0x06, 0x14, 0x00, 0x60, 0x00, 0x31, 0x9C, 0x8C, 0x05, 0x25,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x00, 0x00, 0x00, 0x00,
	0x53, 0x79, 0x6E, 0x42, 0x61, 0x73, 0x37, 0x00, 0xCD, 0x80, 0x00, 0x78, 0xF0, 0x50, 0x40, 0xF4,
	0x0C, 0x20, 0x20, 0x41, 0x9F, 0x0F, 0x08, 0x6F, 0x11, 0x30, 0x00, 0x40, 0x1F, 0x10, 0x05, 0x0F,
	0x17, 0x20, 0x00, 0x40, 0x1F, 0x0D, 0x08, 0x07, 0x00, 0x40, 0x00, 0x41, 0x5C, 0x94, 0x08, 0x1C,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x00, 0x00, 0x00, 0x00,
	0x4D, 0x61, 0x72, 0x69, 0x6D, 0x62, 0x32, 0x00, 0xCD, 0x80, 0x00, 0x78, 0xFC, 0x20, 0x40, 0xF4,
	0x18, 0x10, 0x40, 0x45, 0x56, 0x0E, 0x09, 0x46, 0x00, 0x70, 0x08, 0x41, 0x5C, 0x91, 0x0A, 0x35,
	0x24, 0x10, 0x00, 0x4A, 0x5C, 0x11, 0x06, 0x36, 0x00, 0x70, 0x08, 0x41, 0x5C, 0x91, 0x0A, 0x35,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x00, 0x00, 0x00, 0x00,
	0x4D, 0x61, 0x72, 0x69, 0x6D, 0x62, 0x33, 0x00, 0xCD, 0x80, 0x00, 0x78, 0xEC, 0x20, 0x40, 0xF4,
	0x18, 0x20, 0x40, 0x45, 0x59, 0x17, 0x17, 0x47, 0x00, 0x70, 0x04, 0x41, 0x5C, 0x96, 0x11, 0x35,
	0x20, 0x20, 0x00, 0x45, 0x5C, 0x0E, 0x0B, 0x15, 0x00, 0x70, 0x04, 0x41, 0x5C, 0x91, 0x0A, 0x36,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x25, 0x00, 0x00, 0x00, 0x00,
	0x58, 0x79, 0x6C, 0x6F, 0x70, 0x68, 0x32, 0x00, 0xCD, 0x80, 0x00, 0x78, 0xEC, 0x20, 0x40, 0x00,
	0x12, 0x70, 0x00, 0x42, 0x1F, 0x16, 0x00, 0xA9, 0x00, 0x70, 0x08, 0x41, 0x1F, 0x9F, 0x12, 0x07,
	0x0C, 0x70, 0x30, 0x45, 0x9F, 0x13, 0x10, 0xA5, 0x00, 0x70, 0x08, 0x41, 0x1F, 0x9F, 0x0F, 0x07,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x00, 0x00, 0x00, 0x00,
	0x56, 0x69, 0x62, 0x65, 0x32, 0x20, 0x20, 0x00, 0xCB, 0x8E, 0x00, 0x78, 0xC2, 0x21, 0x40, 0x00,
	0x26, 0x20, 0x00, 0x3C, 0x1F, 0x0F, 0x0E, 0x5A, 0x26, 0x70, 0x00, 0x32, 0x98, 0x11, 0x05, 0x04,
	0x28, 0x70, 0x00, 0x75, 0x1F, 0x0E, 0x08, 0x66, 0x00, 0x70, 0x00, 0x71, 0x9F, 0x91, 0x05, 0x04,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x00, 0x00, 0x00, 0x00,
	0x56, 0x69, 0x62, 0x65, 0x33, 0x20, 0x20, 0x00, 0xC5, 0xA1, 0x00, 0x78, 0xC7, 0x41, 0x40, 0xF4,
	0x00, 0x70, 0x0A, 0x31, 0x1F, 0x94, 0x07, 0x27, 0x00, 0x70, 0x0A, 0x34, 0x1F, 0x94, 0x0B, 0x27,
	0x00, 0x50, 0x0A, 0x3E, 0x5F, 0x90, 0x15, 0xF6, 0x00, 0x70, 0x0A, 0x71, 0x1F, 0x94, 0x07, 0x27,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x00, 0x00, 0x00, 0x00,
	0x47, 0x6C, 0x6F, 0x63, 0x6B, 0x6E, 0x32, 0x00, 0xCD, 0x80, 0x00, 0x78, 0xE4, 0x30, 0x40, 0x00,
	0x23, 0x40, 0x40, 0x3E, 0x1F, 0x0F, 0x0E, 0x5A, 0x00, 0x70, 0x08, 0x31, 0x98, 0x91, 0x05, 0x04,
	0x28, 0x60, 0x00, 0x76, 0x1F, 0x0E, 0x08, 0x66, 0x00, 0x70, 0x08, 0x71, 0x9F, 0x91, 0x05, 0x04,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x00, 0x00, 0x00, 0x00,
	0x54, 0x75, 0x62, 0x65, 0x42, 0x65, 0x31, 0x00, 0xCD, 0x80, 0x22, 0x78, 0xE4, 0x30, 0x40, 0x0C,
	0x12, 0x50, 0x60, 0x41, 0x1A, 0x04, 0x41, 0x41, 0x00, 0x70, 0x0A, 0x31, 0x9C, 0x86, 0x04, 0x82,
	0x0F, 0x50, 0x00, 0x31, 0x95, 0x0E, 0x40, 0x20, 0x00, 0x70, 0x0A, 0x71, 0x98, 0x98, 0x03, 0x11,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x00, 0x00, 0x00, 0x00,
	0x54, 0x75, 0x62, 0x65, 0x42, 0x65, 0x32, 0x00, 0xCD, 0x80, 0x00, 0x78, 0xEC, 0x30, 0x40, 0x00,
	0x13, 0x50, 0x30, 0x43, 0x5F, 0x10, 0x47, 0x85, 0x00, 0x70, 0x08, 0x31, 0x5F, 0x9F, 0x09, 0x05,
	0x0A, 0x50, 0x60, 0x32, 0x1F, 0x0A, 0xC4, 0x13, 0x00, 0x70, 0x08, 0x71, 0x5F, 0x9F, 0x09, 0x04,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x00, 0x00, 0x00, 0x00,
	0x42, 0x65, 0x6C, 0x6C, 0x73, 0x20, 0x32, 0x00, 0xCD, 0x80, 0x22, 0x78, 0xE5, 0x30, 0x40, 0xE8,
	0x10, 0x00, 0x00, 0x42, 0x1D, 0x04, 0xC1, 0x22, 0x00, 0x70, 0xDC, 0x42, 0x1D, 0x8F, 0xC3, 0x13,
	0x00, 0x70, 0xDC, 0x7A, 0x5B, 0x8F, 0x00, 0x13, 0x00, 0x70, 0x0C, 0x31, 0x5E, 0x82, 0x43, 0x13,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x00, 0x00, 0x00, 0x00,
	0x54, 0x65, 0x6D, 0x70, 0x6C, 0x65, 0x47, 0x00, 0xCD, 0x80, 0x00, 0x78, 0xCB, 0x20, 0x40, 0xF4,
	0x10, 0x70, 0x00, 0x40, 0x06, 0x0B, 0xC4, 0x04, 0x0F, 0x70, 0x40, 0x43, 0x43, 0x02, 0x47, 0x32,
	0x1B, 0x70, 0x00, 0x41, 0x9F, 0x06, 0xC0, 0x22, 0x00, 0x70, 0x00, 0x41, 0x5F, 0x95, 0x06, 0x24,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x00, 0x00, 0x00, 0x00,
	0x53, 0x74, 0x65, 0x65, 0x6C, 0x44, 0x72, 0x00, 0xCD, 0x80, 0x00, 0x78, 0xFA, 0x20, 0x40, 0x00,
	0x22, 0x60, 0x00, 0x42, 0x14, 0x10, 0x80, 0xF3, 0x1C, 0x60, 0x00, 0x41, 0x14, 0x0A, 0x80, 0xF4,
	0x1F, 0x60, 0x00, 0x41, 0x14, 0x0A, 0x80, 0xF4, 0x00, 0x70, 0x00, 0x41, 0x14, 0x8A, 0x00, 0xF6,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x25, 0x00, 0x00, 0x00, 0x00,
	0x45, 0x6C, 0x65, 0x63, 0x74, 0x44, 0x72, 0x00, 0xCD, 0x80, 0x00, 0x78, 0xC3, 0x60, 0x40, 0x00,
	0x5B, 0x70, 0x00, 0x41, 0x18, 0x1F, 0x17, 0x0F, 0x5B, 0x70, 0x00, 0x31, 0x18, 0x1F, 0x10, 0x0F,
	0x00, 0x70, 0x00, 0x30, 0x15, 0x1F, 0x9B, 0x0F, 0x00, 0x70, 0x00, 0x70, 0x53, 0x96, 0x0D, 0x0A,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2C, 0x00, 0x00, 0x00, 0x00,
	0x48, 0x61, 0x6E, 0x64, 0x20, 0x44, 0x72, 0x00, 0xC6, 0x80, 0xAC, 0x78, 0xF9, 0x30, 0x40, 0x00,
	0x04, 0x40, 0x00, 0x70, 0x9A, 0x15, 0x40, 0x66, 0x11, 0x30, 0x00, 0x52, 0x1D, 0x1A, 0x46, 0xB4,
	0x18, 0x30, 0x50, 0x70, 0x9F, 0x18, 0xC3, 0x24, 0x00, 0x10, 0x00, 0x01, 0xDF, 0x80, 0x07, 0x03,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2C, 0x00, 0x00, 0x00, 0x00,
	0x53, 0x79, 0x6E, 0x54, 0x69, 0x6D, 0x70, 0x00, 0xCD, 0x80, 0x00, 0x78, 0xFB, 0x40, 0x40, 0x00,
	0x01, 0x40, 0x00, 0x42, 0x1F, 0x1F, 0x80, 0x00, 0x0D, 0x70, 0x00, 0x40, 0x1F, 0x12, 0x02, 0x55,
	0x06, 0x70, 0xA0, 0x40, 0x1F, 0x12, 0x0C, 0x75, 0x01, 0x70, 0x00, 0x40, 0x5F, 0x9F, 0x0C, 0x06,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x00, 0x00, 0x00, 0x00,
	0x43, 0x6C, 0x6F, 0x63, 0x6B, 0x20, 0x20, 0x00, 0xC9, 0x80, 0x1A, 0x78, 0xC4, 0x10, 0x40, 0xF4,
	0x00, 0x70, 0x00, 0x40, 0x1F, 0x12, 0x01, 0xF5, 0x00, 0x70, 0x08, 0x40, 0x19, 0x92, 0x57, 0xC3,
	0x00, 0x70, 0x00, 0x40, 0x1A, 0x1C, 0xC1, 0x33, 0x00, 0x70, 0x08, 0x44, 0x1F, 0x93, 0x8D, 0xA6,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x00, 0x00, 0x00, 0x00,
	0x48, 0x65, 0x69, 0x66, 0x65, 0x72, 0x20, 0x00, 0xCD, 0x80, 0x00, 0x78, 0xE8, 0x30, 0x40, 0x00,
	0x0C, 0x40, 0x00, 0x41, 0x9F, 0x10, 0x52, 0xA6, 0x12, 0x30, 0x00, 0x42, 0x1F, 0x10, 0x52, 0xA6,
	0x15, 0x30, 0x00, 0x42, 0x1F, 0x10, 0x12, 0xA6, 0x00, 0x60, 0x00, 0x43, 0x1F, 0x90, 0x12, 0xA8,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x25, 0x00, 0x00, 0x00, 0x00,
	0x53, 0x6E, 0x61, 0x72, 0x65, 0x44, 0x32, 0x00, 0xCD, 0x80, 0x00, 0x78, 0xFC, 0x20, 0x40, 0xE8,
	0x00, 0x70, 0x00, 0x72, 0x1F, 0x1F, 0x80, 0x00, 0x00, 0x70, 0x08, 0x41, 0x13, 0x9F, 0x11, 0x08,
	0x03, 0x70, 0x00, 0x43, 0x1F, 0x1A, 0x4A, 0x55, 0x00, 0x70, 0x08, 0x40, 0x1F, 0x9F, 0x10, 0x07,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x00, 0x00, 0x00, 0x00,
	0x53, 0x6E, 0x61, 0x72, 0x65, 0x44, 0x33, 0x00, 0xCD, 0x80, 0x00, 0x78, 0xF8, 0x40, 0x40, 0xF4,
	0x00, 0x70, 0x00, 0x76, 0x1F, 0x1F, 0x40, 0x03, 0x00, 0x50, 0x00, 0x43, 0x13, 0x16, 0x51, 0x28,
	0x05, 0x60, 0x00, 0x42, 0x1F, 0x1A, 0xCA, 0x55, 0x00, 0x70, 0x00, 0x42, 0x1F, 0x9F, 0xD0, 0x08,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x00, 0x00, 0x00, 0x00
};

static const uint8_t m_voiceDefinitionBankRom5Binary[3104] = {
	0x72, 0x6F, 0x6D, 0x35, 0x20, 0x20, 0x20, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x4A, 0x4F, 0x72, 0x67, 0x61, 0x6E, 0x31, 0x00, 0xBF, 0x80, 0x04, 0x78, 0xDF, 0x30, 0x40, 0xF4,
	0x00, 0x70, 0x0F, 0x33, 0x1F, 0x8D, 0x01, 0xFB, 0x00, 0x70, 0x0F, 0x36, 0x1F, 0x92, 0x0E, 0x0A,
	0x00, 0x70, 0x0F, 0x71, 0x1F, 0x9F, 0x01, 0x0A, 0x00, 0x70, 0x0F, 0x31, 0x1F, 0x9F, 0x01, 0x0A,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x27, 0x00, 0x00, 0x00, 0x00,
	0x4A, 0x4F, 0x72, 0x67, 0x61, 0x6E, 0x32, 0x00, 0xD0, 0x80, 0x06, 0x78, 0xDF, 0x30, 0x40, 0xF4,
	0x00, 0x70, 0x0F, 0x33, 0x1F, 0x8D, 0x01, 0xFB, 0x01, 0x70, 0x0F, 0x32, 0x1F, 0x9F, 0x01, 0x0A,
	0x00, 0x70, 0x0F, 0x71, 0x1F, 0x9F, 0x01, 0x0A, 0x01, 0x70, 0x0F, 0x31, 0x1F, 0x9F, 0x01, 0x0A,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x27, 0x00, 0x00, 0x00, 0x00,
	0x43, 0x4F, 0x72, 0x67, 0x61, 0x6E, 0x31, 0x00, 0xCD, 0x80, 0x00, 0x78, 0xFE, 0x40, 0x40, 0xF4,
	0x00, 0x00, 0x00, 0x41, 0x1F, 0x19, 0x1E, 0x3F, 0x01, 0x50, 0x0C, 0x33, 0x1F, 0x9F, 0x00, 0x0F,
	0x01, 0x50, 0x0C, 0x42, 0x1F, 0x9F, 0x00, 0x0F, 0x01, 0x50, 0x0C, 0x71, 0x1F, 0x9F, 0x00, 0x0F,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x27, 0x00, 0x00, 0x00, 0x00,
	0x43, 0x4F, 0x72, 0x67, 0x61, 0x6E, 0x32, 0x00, 0xC6, 0x85, 0x33, 0x78, 0xEF, 0x31, 0x40, 0x00,
	0x00, 0x60, 0x1F, 0x06, 0x1C, 0x92, 0x00, 0xFF, 0x00, 0x60, 0x0F, 0x31, 0x9A, 0x8F, 0x00, 0x0F,
	0x00, 0x60, 0x1F, 0x73, 0x1E, 0x8F, 0x00, 0x0F, 0x07, 0x60, 0x0F, 0x00, 0x19, 0x8F, 0x00, 0x0F,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x27, 0x00, 0x00, 0x00, 0x00,
	0x45, 0x4F, 0x72, 0x67, 0x61, 0x6E, 0x33, 0x00, 0xC6, 0x80, 0x10, 0x78, 0xFB, 0x30, 0x40, 0xF4,
	0x17, 0x10, 0x00, 0x22, 0x18, 0x1A, 0x49, 0x6F, 0x21, 0x10, 0x00, 0x61, 0x1F, 0x1F, 0x00, 0x0F,
	0x20, 0x10, 0x00, 0x71, 0x1F, 0x1F, 0x00, 0x0F, 0x08, 0x50, 0x00, 0x23, 0x1F, 0x9F, 0x00, 0x0F,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x27, 0x00, 0x00, 0x00, 0x00,
	0x45, 0x4F, 0x72, 0x67, 0x61, 0x6E, 0x34, 0x00, 0xCD, 0x80, 0x31, 0x78, 0xFE, 0x40, 0x40, 0xF4,
	0x1A, 0x20, 0x40, 0x44, 0x1F, 0x00, 0x00, 0x0A, 0x00, 0x70, 0x0C, 0x44, 0x1F, 0x80, 0x00, 0x0A,
	0x00, 0x70, 0x0C, 0x42, 0x1F, 0x80, 0x00, 0x0A, 0x00, 0x70, 0x0C, 0x41, 0x1F, 0x80, 0x00, 0x0A,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x27, 0x00, 0x00, 0x00, 0x00,
	0x45, 0x4F, 0x72, 0x67, 0x61, 0x6E, 0x35, 0x00, 0xB7, 0xD8, 0x3F, 0x78, 0xC6, 0x30, 0x40, 0xF4,
	0x1B, 0x10, 0x00, 0x43, 0x1F, 0x1F, 0x00, 0x0F, 0x01, 0x60, 0x0C, 0x76, 0x1F, 0x9F, 0x00, 0x0F,
	0x00, 0x60, 0x0C, 0x32, 0x1F, 0x9F, 0x00, 0x0F, 0x01, 0x60, 0x0C, 0x71, 0x1F, 0x9F, 0x00, 0x0F,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x27, 0x00, 0x00, 0x00, 0x00,
	0x45, 0x4F, 0x72, 0x67, 0x61, 0x6E, 0x36, 0x00, 0xCD, 0x80, 0x3E, 0x78, 0xF5, 0x40, 0x40, 0xF4,
	0x1B, 0x10, 0x30, 0x42, 0x1F, 0x1F, 0x01, 0x0A, 0x00, 0x50, 0x0D, 0x44, 0x1F, 0x9F, 0x01, 0x0A,
	0x03, 0x50, 0x0D, 0x41, 0x1F, 0x9F, 0x01, 0x0A, 0x00, 0x50, 0x0D, 0x41, 0x1F, 0x9F, 0x01, 0x0A,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x00, 0x00, 0x00, 0x00,
	0x45, 0x4F, 0x72, 0x67, 0x61, 0x6E, 0x37, 0x00, 0xCD, 0x80, 0x00, 0x78, 0xC4, 0x30, 0x40, 0xF4,
	0x21, 0x30, 0x00, 0x37, 0x1F, 0x1F, 0x00, 0x0F, 0x01, 0x70, 0x08, 0x11, 0x1F, 0x9F, 0x00, 0x0F,
	0x10, 0x30, 0x00, 0x41, 0x1F, 0x1F, 0x00, 0x0F, 0x01, 0x70, 0x08, 0x72, 0x1F, 0x9F, 0x00, 0x0F,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x00, 0x00, 0x00, 0x00,
	0x45, 0x4F, 0x72, 0x67, 0x61, 0x6E, 0x38, 0x00, 0xCD, 0x80, 0x00, 0x78, 0xC7, 0x30, 0x40, 0xF4,
	0x01, 0x70, 0x0F, 0x38, 0x1F, 0x9F, 0x00, 0x0F, 0x01, 0x70, 0x0F, 0x14, 0x1F, 0x9F, 0x00, 0x0F,
	0x01, 0x70, 0x0F, 0x42, 0x1F, 0x9F, 0x00, 0x0F, 0x01, 0x70, 0x0F, 0x71, 0x1F, 0x9F, 0x00, 0x0F,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x00, 0x00, 0x00, 0x00,
	0x53, 0x6D, 0x6C, 0x50, 0x69, 0x70, 0x65, 0x00, 0xCD, 0x80, 0x00, 0x78, 0xF4, 0x30, 0x40, 0x00,
	0x1E, 0x00, 0x00, 0x34, 0x1F, 0x11, 0x00, 0x2B, 0x01, 0x50, 0x08, 0x12, 0x53, 0x9F, 0x00, 0x0B,
	0x08, 0x00, 0x70, 0x70, 0x1F, 0x1F, 0x00, 0x09, 0x01, 0x50, 0x08, 0x70, 0x51, 0x9F, 0x00, 0x09,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x00, 0x00, 0x00, 0x00,
	0x4D, 0x69, 0x64, 0x50, 0x69, 0x70, 0x65, 0x00, 0xCD, 0x80, 0x00, 0x78, 0xF4, 0x30, 0x40, 0x00,
	0x14, 0x10, 0x00, 0x70, 0x1F, 0x11, 0x00, 0x18, 0x01, 0x50, 0x08, 0x70, 0x50, 0x9F, 0x00, 0x07,
	0x03, 0x10, 0x70, 0x32, 0x1F, 0x1F, 0x00, 0x09, 0x09, 0x50, 0x08, 0x32, 0x52, 0x9F, 0x00, 0x0A,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x00, 0x00, 0x00, 0x00,
	0x42, 0x69, 0x67, 0x50, 0x69, 0x70, 0x65, 0x00, 0xCD, 0x80, 0x00, 0x78, 0xF4, 0x30, 0x40, 0x00,
	0x0F, 0x20, 0x20, 0x70, 0x1F, 0x11, 0x00, 0x18, 0x01, 0x60, 0x08, 0x71, 0x8E, 0x9F, 0x00, 0x06,
	0x15, 0x20, 0x00, 0x33, 0x1F, 0x10, 0x00, 0x29, 0x06, 0x60, 0x08, 0x32, 0x52, 0x9F, 0x00, 0x0A,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x00, 0x00, 0x00, 0x00,
	0x53, 0x66, 0x74, 0x50, 0x69, 0x70, 0x65, 0x00, 0xCD, 0x80, 0x00, 0x78, 0xC7, 0x00, 0x40, 0x00,
	0x0F, 0x50, 0x9D, 0x38, 0x16, 0x80, 0x00, 0x0A, 0x03, 0x50, 0x0D, 0x31, 0x17, 0x80, 0x00, 0x0A,
	0x04, 0x50, 0xFD, 0x34, 0x11, 0x80, 0x00, 0x0A, 0x00, 0x50, 0x0D, 0x60, 0x17, 0x80, 0x00, 0x0A,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x00,
	0x4F, 0x72, 0x67, 0x61, 0x6E, 0x20, 0x20, 0x00, 0xCB, 0x80, 0x00, 0x78, 0xF8, 0x30, 0x40, 0x00,
	0x0F, 0x00, 0x40, 0x45, 0x1F, 0x1F, 0x00, 0x06, 0x35, 0x00, 0x00, 0x71, 0x1F, 0x1F, 0x00, 0x05,
	0x15, 0x10, 0x00, 0x41, 0x1F, 0x1F, 0x00, 0x05, 0x01, 0x50, 0x00, 0x41, 0x0D, 0x9F, 0x00, 0x09,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x00, 0x00, 0x00, 0x00,
	0x47, 0x75, 0x69, 0x74, 0x61, 0x72, 0x20, 0x00, 0xCD, 0x80, 0x00, 0x78, 0xF9, 0x30, 0x40, 0xF4,
	0x15, 0x30, 0x40, 0x43, 0x9F, 0x05, 0x04, 0x13, 0x22, 0x30, 0x70, 0x43, 0x1F, 0x08, 0x11, 0x06,
	0x1B, 0x40, 0x70, 0x41, 0x1F, 0x0C, 0x08, 0x05, 0x00, 0x70, 0x00, 0x41, 0x5B, 0x94, 0x06, 0x19,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x00, 0x00, 0x00, 0x00,
	0x46, 0x6F, 0x6C, 0x6B, 0x20, 0x47, 0x74, 0x00, 0xC9, 0x80, 0x0C, 0x78, 0xE8, 0x30, 0x40, 0xF4,
	0x17, 0x50, 0x50, 0x48, 0x5F, 0x09, 0x00, 0xF6, 0x16, 0x60, 0x90, 0x33, 0x5F, 0x0A, 0x00, 0xF9,
	0x1B, 0x40, 0x80, 0x43, 0x1C, 0x06, 0x00, 0xF8, 0x01, 0x70, 0x00, 0x41, 0x5F, 0x92, 0x08, 0x08,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x27, 0x00, 0x00, 0x00, 0x00,
	0x50, 0x6C, 0x75, 0x63, 0x6B, 0x47, 0x74, 0x00, 0xCD, 0x80, 0x00, 0x78, 0xFA, 0x30, 0x40, 0xF4,
	0x17, 0x30, 0x20, 0x41, 0xDF, 0x05, 0x01, 0x24, 0x04, 0x10, 0xF0, 0x4A, 0xDF, 0x08, 0x00, 0x3F,
	0x32, 0x70, 0xF0, 0x41, 0xDF, 0x05, 0x00, 0x4F, 0x01, 0x70, 0x50, 0x41, 0x9F, 0x86, 0x04, 0x85,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x00, 0x00, 0x00, 0x00,
	0x42, 0x72, 0x69, 0x74, 0x65, 0x47, 0x74, 0x00, 0xCD, 0x80, 0x1C, 0x78, 0xE3, 0x30, 0x40, 0xF4,
	0x0D, 0x00, 0x00, 0x47, 0x57, 0x1A, 0x05, 0x36, 0x10, 0x00, 0x00, 0x41, 0x16, 0x09, 0x09, 0x76,
	0x23, 0x00, 0x00, 0x4A, 0x07, 0x0B, 0x03, 0x08, 0x00, 0x70, 0x00, 0x44, 0x9F, 0x96, 0x04, 0x27,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x00, 0x00, 0x00, 0x00,
	0x46, 0x75, 0x7A, 0x7A, 0x20, 0x47, 0x74, 0x00, 0xCD, 0x80, 0x00, 0x78, 0xF8, 0x40, 0x40, 0xF4,
	0x11, 0x00, 0x30, 0x43, 0x1F, 0x1F, 0x00, 0x0F, 0x07, 0x00, 0x50, 0x43, 0x1F, 0x17, 0x05, 0x2F,
	0x12, 0x00, 0x00, 0x41, 0x1F, 0x1F, 0x00, 0x0F, 0x00, 0x50, 0x06, 0x41, 0x5F, 0x9F, 0x06, 0x0F,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x00, 0x00, 0x00, 0x00,
	0x5A, 0x69, 0x74, 0x68, 0x65, 0x72, 0x32, 0x00, 0xCD, 0x80, 0x00, 0x78, 0xF0, 0x30, 0x40, 0xF4,
	0x0D, 0x20, 0x40, 0x45, 0x5F, 0x0B, 0x06, 0x2A, 0x2A, 0x30, 0x30, 0x42, 0x1F, 0x0C, 0x03, 0x5A,
	0x0D, 0x20, 0x50, 0x41, 0x1F, 0x1F, 0x00, 0x03, 0x01, 0x70, 0x00, 0x41, 0x1F, 0x98, 0x06, 0x08,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x00, 0x00, 0x00, 0x00,
	0x4C, 0x75, 0x74, 0x65, 0x20, 0x20, 0x20, 0x00, 0xCD, 0x80, 0x00, 0x78, 0xF9, 0x30, 0x40, 0xF4,
	0x11, 0x20, 0x30, 0x43, 0x5F, 0x0C, 0x05, 0x35, 0x18, 0x70, 0x70, 0x4A, 0x1F, 0x13, 0x0E, 0x25,
	0x23, 0x50, 0x40, 0x41, 0x1F, 0x11, 0x02, 0x25, 0x00, 0x70, 0x00, 0x41, 0x9F, 0x9F, 0x08, 0x06,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x00, 0x00, 0x00, 0x00,
	0x42, 0x61, 0x6E, 0x6A, 0x6F, 0x20, 0x20, 0x00, 0xCD, 0x80, 0x00, 0x78, 0xEA, 0x30, 0x40, 0x00,
	0x07, 0x40, 0x00, 0x21, 0x9E, 0x17, 0x00, 0x34, 0x1D, 0x00, 0x00, 0x39, 0xDF, 0x1B, 0x08, 0x31,
	0x06, 0x00, 0x00, 0x31, 0x9F, 0x02, 0x03, 0x00, 0x00, 0x70, 0x00, 0x73, 0x9F, 0x8D, 0x0B, 0x66,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x27, 0x00, 0x00, 0x00, 0x00,
	0x53, 0x66, 0x74, 0x48, 0x61, 0x72, 0x70, 0x00, 0xC9, 0x80, 0x00, 0x78, 0xFB, 0x30, 0x40, 0x00,
	0x13, 0x50, 0x40, 0x43, 0x1F, 0x0D, 0x06, 0x54, 0x20, 0x50, 0x70, 0x42, 0x98, 0x0E, 0x05, 0x44,
	0x1F, 0x40, 0x80, 0x42, 0x1F, 0x0E, 0x08, 0x66, 0x01, 0x70, 0x50, 0x41, 0x9F, 0x91, 0x05, 0x04,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x00, 0x00, 0x00, 0x00,
	0x48, 0x61, 0x72, 0x70, 0x32, 0x20, 0x20, 0x00, 0xC9, 0x80, 0x00, 0x78, 0xF9, 0x30, 0x40, 0x00,
	0x16, 0x30, 0x00, 0x43, 0x1F, 0x0F, 0x0E, 0x5A, 0x1A, 0x60, 0x30, 0x45, 0x98, 0x0E, 0x05, 0x44,
	0x31, 0x70, 0x00, 0x41, 0x1F, 0x0E, 0x08, 0x66, 0x01, 0x70, 0x50, 0x41, 0x5F, 0x91, 0x05, 0x05,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x00, 0x00, 0x00, 0x00,
	0x48, 0x61, 0x72, 0x70, 0x33, 0x20, 0x20, 0x00, 0xCD, 0x80, 0x00, 0x78, 0xF9, 0x30, 0x40, 0x0C,
	0x0D, 0x60, 0xC3, 0x02, 0x5F, 0x0C, 0x10, 0x56, 0x11, 0x60, 0x40, 0x00, 0x98, 0x04, 0x03, 0x53,
	0x18, 0x60, 0xA4, 0x71, 0x5F, 0x06, 0x03, 0x12, 0x00, 0x60, 0x60, 0x30, 0x9F, 0x8C, 0x06, 0x13,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x00, 0x00, 0x00, 0x00,
	0x53, 0x66, 0x74, 0x4B, 0x6F, 0x74, 0x6F, 0x00, 0xC9, 0x80, 0x00, 0x78, 0xF0, 0x30, 0x40, 0x00,
	0x14, 0x10, 0x20, 0x35, 0x9F, 0x0C, 0x0E, 0x5A, 0x29, 0x10, 0x30, 0x32, 0x98, 0x0E, 0x05, 0x44,
	0x15, 0x10, 0x00, 0x71, 0x1F, 0x0D, 0x08, 0x61, 0x01, 0x70, 0x00, 0x71, 0x9F, 0x91, 0x08, 0x05,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x00, 0x00, 0x00, 0x00,
	0x48, 0x69, 0x74, 0x4B, 0x6F, 0x74, 0x6F, 0x00, 0xCD, 0x82, 0x00, 0x78, 0xF8, 0x21, 0x40, 0x00,
	0x09, 0x30, 0x60, 0x39, 0x1F, 0x14, 0x00, 0xF0, 0x11, 0x30, 0x00, 0x37, 0xDF, 0x08, 0x04, 0xF1,
	0x11, 0x30, 0x00, 0x33, 0x9F, 0x08, 0x02, 0xF3, 0x00, 0xC0, 0x24, 0x31, 0x9F, 0x85, 0x03, 0xF4,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x00, 0x00, 0x00, 0x00,
	0x53, 0x69, 0x74, 0x61, 0x72, 0x31, 0x20, 0x00, 0xCB, 0x80, 0x18, 0x78, 0xFB, 0x40, 0x40, 0x00,
	0x14, 0x10, 0x00, 0x41, 0xD7, 0x0E, 0x09, 0x10, 0x00, 0x10, 0x00, 0x31, 0x9F, 0x06, 0x04, 0x81,
	0x10, 0x10, 0x00, 0x32, 0x9F, 0x06, 0x03, 0xA0, 0x00, 0x70, 0x50, 0x72, 0xDF, 0x85, 0x08, 0x80,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x00, 0x00, 0x00, 0x00,
	0x53, 0x69, 0x74, 0x61, 0x72, 0x32, 0x20, 0x00, 0xCD, 0x80, 0x1B, 0x78, 0xC2, 0x00, 0x40, 0x00,
	0x07, 0x30, 0x90, 0x37, 0x5F, 0x07, 0x03, 0x72, 0x0F, 0x00, 0x30, 0x79, 0x46, 0x08, 0x06, 0x65,
	0x14, 0x00, 0x70, 0x01, 0x5F, 0x02, 0x02, 0x32, 0x00, 0x00, 0x00, 0x01, 0x5F, 0x85, 0x05, 0x43,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00,
	0x48, 0x75, 0x66, 0x66, 0x53, 0x79, 0x6E, 0x00, 0xCD, 0x80, 0x00, 0x78, 0xFC, 0x30, 0x40, 0x0C,
	0x00, 0x00, 0x40, 0x3F, 0x5F, 0x0C, 0xC0, 0xF8, 0x11, 0x70, 0x40, 0x32, 0x8C, 0x97, 0x08, 0x38,
	0x7D, 0x00, 0xA0, 0x30, 0x0F, 0x02, 0x01, 0x56, 0x00, 0xF0, 0xF0, 0x31, 0x0E, 0x8F, 0x01, 0x18,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x27, 0x00, 0x00, 0x00, 0x00,
	0x46, 0x61, 0x6E, 0x74, 0x61, 0x73, 0x79, 0x00, 0xCA, 0x80, 0x28, 0x78, 0xD6, 0x50, 0x40, 0x00,
	0x21, 0x20, 0x00, 0x42, 0x11, 0x1F, 0x00, 0x0F, 0x00, 0x70, 0x0C, 0x41, 0x1F, 0x9F, 0x00, 0x0F,
	0x00, 0x70, 0x0C, 0x41, 0x1F, 0x8A, 0x0A, 0x64, 0x00, 0x70, 0x0C, 0x31, 0x9F, 0x8A, 0x00, 0x0F,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2C, 0x00, 0x00, 0x00, 0x00,
	0x53, 0x79, 0x6E, 0x76, 0x6F, 0x69, 0x63, 0x00, 0xCB, 0x80, 0x2A, 0x78, 0xFA, 0x40, 0x40, 0x00,
	0x13, 0x00, 0x80, 0x33, 0x13, 0x12, 0x04, 0x54, 0x13, 0x00, 0xF0, 0x75, 0x15, 0x0E, 0x86, 0x6A,
	0x0B, 0x00, 0xD0, 0x71, 0x0B, 0x1F, 0x03, 0x09, 0x05, 0x70, 0x00, 0x31, 0x0E, 0x9F, 0x01, 0x09,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x00, 0x00, 0x00, 0x00,
	0x4D, 0x2E, 0x56, 0x6F, 0x69, 0x63, 0x65, 0x00, 0xCD, 0x83, 0x39, 0x78, 0xC2, 0x41, 0x40, 0xF4,
	0x11, 0x20, 0xF0, 0x31, 0x0E, 0x06, 0x00, 0x35, 0x20, 0x30, 0xF0, 0x3F, 0x18, 0x03, 0xC0, 0x75,
	0x25, 0x30, 0x70, 0x71, 0x4F, 0x08, 0x00, 0x55, 0x00, 0x40, 0x60, 0x74, 0x0D, 0x83, 0x00, 0x28,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x00, 0x00, 0x00, 0x00,
	0x56, 0x53, 0x41, 0x52, 0x20, 0x20, 0x20, 0x00, 0xCD, 0x80, 0x18, 0x78, 0xF2, 0x30, 0x40, 0x0C,
	0x16, 0x20, 0xF0, 0x21, 0x4B, 0x61, 0x01, 0xF3, 0x21, 0x40, 0xF0, 0x07, 0x89, 0x65, 0x01, 0xF4,
	0x08, 0x70, 0xF0, 0x20, 0x48, 0x61, 0x01, 0x34, 0x00, 0x70, 0x05, 0x71, 0x86, 0xE8, 0x01, 0x36,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00,
	0x52, 0x61, 0x63, 0x69, 0x6E, 0x67, 0x20, 0x00, 0x70, 0x80, 0x2A, 0x78, 0xFA, 0x70, 0x40, 0x00,
	0x14, 0x70, 0x00, 0x40, 0x1F, 0x1F, 0x00, 0x02, 0x00, 0x70, 0x00, 0x40, 0x1F, 0x1F, 0x40, 0x03,
	0x26, 0x70, 0x00, 0x41, 0x1F, 0x1F, 0x00, 0x01, 0x00, 0x70, 0x00, 0x41, 0x15, 0x9F, 0x00, 0x03,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0C, 0x00, 0x00, 0x00, 0x00,
	0x57, 0x61, 0x74, 0x65, 0x72, 0x20, 0x20, 0x00, 0xA0, 0xB2, 0xFF, 0x78, 0xF4, 0x70, 0x60, 0x7C,
	0x04, 0x00, 0x00, 0x00, 0x12, 0x03, 0x05, 0x01, 0x00, 0x00, 0x00, 0x0F, 0x14, 0x88, 0xC1, 0xB3,
	0x00, 0x00, 0x00, 0x00, 0x08, 0x02, 0x01, 0x02, 0x00, 0x00, 0x00, 0x0F, 0x14, 0x88, 0xC1, 0x93,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0C, 0x00, 0x00, 0x00, 0x00,
	0x57, 0x69, 0x6C, 0x64, 0x57, 0x61, 0x72, 0x00, 0xCD, 0x80, 0x00, 0x78, 0xD3, 0x40, 0x40, 0x0B,
	0x09, 0x70, 0x00, 0x48, 0x0F, 0x12, 0x00, 0x24, 0x25, 0x70, 0x00, 0x4C, 0x16, 0x12, 0x00, 0x04,
	0x5B, 0x70, 0x00, 0x4A, 0x00, 0x00, 0x00, 0xF0, 0x00, 0x70, 0x00, 0x41, 0x0F, 0x92, 0x00, 0x14,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x95, 0x21, 0x00, 0x00, 0x00, 0x00,
	0x47, 0x68, 0x6F, 0x73, 0x74, 0x69, 0x65, 0x00, 0xCD, 0xD8, 0x50, 0x78, 0xFC, 0x61, 0x40, 0x00,
	0x1D, 0x70, 0x00, 0x72, 0x1F, 0x0F, 0x00, 0x23, 0x00, 0x70, 0x08, 0x72, 0x0F, 0x9F, 0x09, 0x05,
	0x33, 0x70, 0x00, 0x34, 0x1F, 0x0F, 0x00, 0x34, 0x00, 0x70, 0x08, 0x32, 0x0F, 0x9F, 0x09, 0x05,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xD8, 0x0C, 0x00, 0x00, 0x00, 0x00,
	0x57, 0x61, 0x76, 0x65, 0x20, 0x20, 0x20, 0x00, 0x77, 0xF2, 0x53, 0x78, 0xF8, 0x62, 0x40, 0xE8,
	0x00, 0x70, 0x00, 0x4F, 0x1F, 0x1F, 0xC0, 0x00, 0x00, 0x70, 0x00, 0x4C, 0x1F, 0x1F, 0x80, 0x03,
	0x00, 0x70, 0x00, 0x48, 0x1F, 0x1F, 0xC0, 0x00, 0x00, 0x70, 0x00, 0x40, 0x0B, 0x96, 0x00, 0x07,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00,
	0x53, 0x70, 0x61, 0x63, 0x65, 0x20, 0x31, 0x00, 0xC8, 0x80, 0x9E, 0x78, 0xF8, 0x73, 0x00, 0x00,
	0x1B, 0x40, 0x40, 0x3F, 0x10, 0x06, 0xC1, 0x03, 0x00, 0x60, 0x40, 0x31, 0x12, 0x03, 0x06, 0x0C,
	0x1A, 0x40, 0x40, 0x30, 0x0A, 0x05, 0x06, 0xF2, 0x00, 0x60, 0x40, 0x31, 0x19, 0x8F, 0x04, 0x65,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0C, 0x00, 0x00, 0x00, 0x00,
	0x53, 0x70, 0x43, 0x68, 0x69, 0x6D, 0x65, 0x00, 0xCD, 0x80, 0x17, 0x78, 0xF4, 0x30, 0x40, 0x00,
	0x1D, 0x10, 0x30, 0x18, 0x0A, 0x1F, 0x83, 0x04, 0x00, 0x70, 0x08, 0x50, 0x1F, 0x8A, 0x07, 0x24,
	0x0C, 0x10, 0x90, 0x42, 0x1F, 0x08, 0xC5, 0x11, 0x00, 0x70, 0x08, 0x41, 0x1F, 0x93, 0x03, 0x24,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x00, 0x00, 0x00, 0x00,
	0x53, 0x70, 0x54, 0x61, 0x6C, 0x6B, 0x20, 0x00, 0xDC, 0x80, 0x7D, 0x78, 0xC5, 0x62, 0x20, 0x00,
	0x00, 0x70, 0xE0, 0x42, 0x05, 0x1F, 0x81, 0x01, 0x00, 0x70, 0x0C, 0x42, 0x03, 0x9F, 0x44, 0x01,
	0x00, 0x70, 0x0C, 0x41, 0x06, 0x9F, 0x83, 0x01, 0x00, 0x70, 0x0C, 0x41, 0x08, 0x9F, 0x02, 0x09,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4C, 0x05, 0x00, 0x00, 0x00, 0x00,
	0x57, 0x69, 0x6E, 0x64, 0x73, 0x20, 0x20, 0x00, 0x70, 0xE4, 0x53, 0x78, 0xFC, 0x62, 0x40, 0xE8,
	0x00, 0x70, 0x00, 0x40, 0x1F, 0x1F, 0x00, 0x00, 0x00, 0x70, 0x08, 0x44, 0x1F, 0x9F, 0x40, 0x03,
	0x1E, 0x70, 0x00, 0x40, 0x1F, 0x1F, 0x00, 0x00, 0x00, 0x70, 0x08, 0x4F, 0x0B, 0x96, 0xC0, 0x07,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00,
	0x53, 0x6D, 0x61, 0x73, 0x68, 0x20, 0x20, 0x00, 0xD4, 0x80, 0x34, 0x78, 0xFA, 0x70, 0x40, 0x02,
	0x00, 0x70, 0x00, 0x45, 0x1F, 0x13, 0xC6, 0x95, 0x22, 0x70, 0x00, 0x4F, 0x1F, 0x1F, 0xC0, 0x06,
	0x0B, 0x70, 0x00, 0x46, 0x1F, 0x0D, 0x80, 0x47, 0x00, 0x70, 0x00, 0x4F, 0x1F, 0x9F, 0xCF, 0x07,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x00,
	0x41, 0x6C, 0x61, 0x72, 0x6D, 0x20, 0x20, 0x00, 0xE5, 0xB2, 0x00, 0x78, 0xE2, 0x43, 0x20, 0x00,
	0x2A, 0x00, 0x00, 0x7F, 0x1F, 0x1F, 0xC0, 0x03, 0x24, 0x00, 0x00, 0x72, 0x1F, 0x1F, 0x80, 0x06,
	0x18, 0x00, 0x00, 0x33, 0x1F, 0x1F, 0xC0, 0x04, 0x00, 0x70, 0x00, 0x3A, 0x1F, 0x9F, 0x40, 0x06,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00,
	0x48, 0x65, 0x6C, 0x69, 0x63, 0x6F, 0x70, 0x00, 0xDD, 0xF3, 0x00, 0x78, 0xFC, 0x03, 0x40, 0xF4,
	0x00, 0x70, 0x60, 0x40, 0x0D, 0x1F, 0x00, 0x00, 0x00, 0x70, 0x16, 0x40, 0x0E, 0x9F, 0x40, 0x04,
	0x00, 0x70, 0x60, 0x40, 0x1F, 0x1F, 0x00, 0x00, 0x00, 0x70, 0x16, 0x40, 0x0E, 0x9F, 0x80, 0x04,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0C, 0x00, 0x00, 0x00, 0x00,
	0x53, 0x69, 0x6E, 0x65, 0x57, 0x61, 0x76, 0x00, 0xCD, 0x80, 0x00, 0x78, 0xC0, 0x00, 0x40, 0x00,
	0x7F, 0x00, 0x00, 0x01, 0x1F, 0x80, 0x00, 0x0F, 0x7F, 0x00, 0x00, 0x01, 0x1F, 0x80, 0x00, 0x0F,
	0x7F, 0x00, 0x00, 0x01, 0x1F, 0x80, 0x00, 0x0F, 0x00, 0x00, 0x00, 0x01, 0x1F, 0x80, 0x00, 0x0F,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};
