/********************* hmac_md5.h ***********************************
 *  to create an authentication tag,  first call                    *
 *  hmac_md5_key() to specify the key.  Note the key must be        *
 *  kept secret.  Call hmac_md5_digest() to compute the tag.        *
 *  Note that the same key will be used over and over, unless       *
 *  changed by another call to hmac_md5_key(), it is not necessary  *
 *  to call this routine each time a new tag is needed.             *
 ********************* hmac_md5.h ***********************************/
#ifndef _HMAC_MD5_H_
#define _HMAC_MD5_H_

#ifndef _MD5_H_
#include "md5.h"
#endif
 
 typedef struct {
   MD5_CTX context_inner;          /* precomputed starting point for inner MD5 */
   MD5_CTX context_outer;          /* precomputed starting point for outer MD5 */
   } HMAC_CTX;

void hmac_md5_key(HMAC_CTX *ctx, unsigned char* key, int key_len);                                /* specify/set key for hmac conversions */
void hmac_md5_digest(HMAC_CTX *ctx, unsigned char* text, int text_len, unsigned char* digest);    /* compute hmac digest, digest is 16 bytes */


/*******************************************************************
 *  hmac_md5() computes a tag from a key and text as a single call *
 *******************************************************************/

void hmac_md5(unsigned char* text, int text_len, unsigned char* key, int key_len, unsigned char* digest);  /* original (all in one) */
#endif
