
! Copyright (C) 2019 J. K. Dewhurst and S. Sharma.
! This file is distributed under the terms of the GNU General Public License.
! See the file COPYING for license details.

subroutine inithfb
use modmain
use modbog
use modrandom
implicit none
! local variables
integer ik,ist,jst
real(8), parameter :: rndevv=0.01d0
! allocatable arrays
complex(8), allocatable :: evecu(:,:),evecv(:,:)
! initialise the Bogoliubov eigenvectors and write to file
if (task.eq.800) then
  allocate(evecu(nstsv,nstsv),evecv(nstsv,nstsv))
  evecu(:,:)=0.d0
  do ist=1,nstsv
    evecu(ist,ist)=1.d0
  end do
  do jst=1,nstsv
    do ist=1,nstsv
      evecv(ist,jst)=rndevv*cmplx(randomu()-0.5d0,randomu()-0.5d0,8)
    end do
  end do
  do ik=1,nkpt
    call putevecuv(ik,evecu,evecv)
  end do
  deallocate(evecu,evecv)
end if
! allocate the Bogoliubov eigenvalue array
if (allocated(evaluv)) deallocate(evaluv)
allocate(evaluv(nstsv,nkpt))
! allocate the V-norm array
if (allocated(vnorm)) deallocate(vnorm)
allocate(vnorm(nstsv,nkpt))
end subroutine

