#include "SDL_opengl.h"
#include "station.h"


#include <iostream>

namespace models {

static GLuint station_dl=0;

void station::draw() {
	dldraw();
}
void station::dldraw() {
	if (station_dl==0) { sdraw(); return; }
	glCallList(station_dl);
}

void station::gen_dl() {
	station_dl=glGenLists(1);
	glNewList(station_dl,GL_COMPILE);
	sdraw();
	glEndList();
	std::cout << " loaded station " << station_dl << std::endl;
}
namespace mtl_station {
typedef enum MTL {
m_kuppel,
m_pfeiler,
m_streben,
m_last
};
} //namespace
void station::material (int id) {
	switch (id) {
		case mtl_station::m_kuppel:
static const GLfloat m_kuppel_diffuse[] = {0.526667,1.00000,1.00000};
			glMaterialfv(GL_FRONT,GL_DIFFUSE, m_kuppel_diffuse);
static const GLfloat m_kuppel_ambient[] = {0.589067,0.940000,0.940000};
			glMaterialfv(GL_FRONT,GL_AMBIENT, m_kuppel_ambient);
static const GLfloat m_kuppel_emissive[] = {0.00000e+0,0.00000e+0,0.00000e+0};
			glMaterialfv(GL_FRONT,GL_EMISSION, m_kuppel_emissive);
			break;
		case mtl_station::m_pfeiler:
static const GLfloat m_pfeiler_diffuse[] = {0.693640,0.693640,0.693640};
			glMaterialfv(GL_FRONT,GL_DIFFUSE, m_pfeiler_diffuse);
static const GLfloat m_pfeiler_ambient[] = {0.780220,0.780220,0.780220};
			glMaterialfv(GL_FRONT,GL_AMBIENT, m_pfeiler_ambient);
static const GLfloat m_pfeiler_emissive[] = {0.00000e+0,0.00000e+0,0.00000e+0};
			glMaterialfv(GL_FRONT,GL_EMISSION, m_pfeiler_emissive);
			break;
		case mtl_station::m_streben:
static const GLfloat m_streben_diffuse[] = {0.540000,0.290889,0.306667};
			glMaterialfv(GL_FRONT,GL_DIFFUSE, m_streben_diffuse);
static const GLfloat m_streben_ambient[] = {0.846667,0.386667,0.280000};
			glMaterialfv(GL_FRONT,GL_AMBIENT, m_streben_ambient);
static const GLfloat m_streben_emissive[] = {0.00000e+0,0.00000e+0,0.00000e+0};
			glMaterialfv(GL_FRONT,GL_EMISSION, m_streben_emissive);
			break;
	}
}
float station::minx() { return -8.83904 ; }
float station::miny() { return 0 ; }
float station::minz() { return -42.5341 ; }
float station::maxx() { return 16.1706; }
float station::maxy() { return 3.22896; }
float station::maxz() { return 11.6468; }
float station::radius() { return 43.4428; }
void station::sdraw() {
const float vertices[141][3]={
	{-3.99937309,0.0000000e+0,-1.31574034},
	{-2.76552404,2.33464763,-0.79190083},
	{-3.21778231,0.0000000e+0,-3.15669549},
	{-2.15414636,2.33464763,-2.23193686},
	{-3.07889552,0.0000000e+0,-0.92494495},
	{-2.29730474,0.0000000e+0,-2.76590010},
	{-2.78886983,0.75555556,-0.32862814},
	{-2.00727905,0.75555556,-2.16958328},
	{-2.89170720,1.57000000,-0.84547280},
	{-2.24373370,1.57000000,-2.37170644},
	{-2.77719694,1.50400000,-0.56026448},
	{-2.08071271,1.50400000,-2.20076007},
	{-0.31746280,0.0000000e+0,0.24744122},
	{-1.55131185,2.33464763,-0.27639829},
	{0.46412798,0.0000000e+0,-1.59351392},
	{-0.93993417,2.33464763,-1.71643431},
	{-1.23794037,0.0000000e+0,-0.14335417},
	{-0.45634959,0.0000000e+0,-1.98430932},
	{-1.86839226,0.75555556,6.2167255e-2},
	{-1.08680148,0.75555556,-1.77878789},
	{-1.42512869,1.57000000,-0.22282632},
	{-0.77715520,1.57000000,-1.74905996},
	{-1.70985205,1.50400000,-0.10711552},
	{-1.01336782,1.50400000,-1.74761110},
	{-4.64769680,0.75555556,4.04964390},
	{-3.72721922,0.75555556,4.44043929},
	{-3.65378557,1.50400000,4.47161608},
	{-3.58035191,2.25244444,4.50279286},
	{-4.79456411,2.25244444,3.98729032},
	{-4.72113045,1.50400000,4.01846711},
	{-8.05745322,0.0000000e+0,8.24264197},
	{-6.82360417,2.33464763,8.76648148},
	{-8.83904400,0.0000000e+0,10.08359711},
	{-7.43498185,2.33464763,10.20651750},
	{-7.13697565,0.0000000e+0,8.63343736},
	{-7.91856643,0.0000000e+0,10.47439250},
	{-6.50652376,0.75555556,8.42791593},
	{-7.28811454,0.75555556,10.26887108},
	{-6.94978733,1.57000000,8.71290951},
	{-7.59776083,1.57000000,10.23914314},
	{-6.66506397,1.50400000,8.59719870},
	{-7.36154820,1.50400000,10.23769429},
	{-4.37554293,0.0000000e+0,9.80582353},
	{-5.52036507,2.24934207,9.53223114},
	{-5.15713371,0.0000000e+0,11.64677867},
	{-5.98347280,2.24934207,10.62303286},
	{-5.29602050,0.0000000e+0,9.41502814},
	{-6.07761128,0.0000000e+0,11.25598328},
	{-5.58604619,0.75555556,8.81871132},
	{-6.36763697,0.75555556,10.65966647},
	{-4.53224482,1.65530556,9.96446154},
	{-5.01365047,1.65530556,11.09836207},
	{-5.59771908,1.50400000,9.05034767},
	{-6.29420331,1.50400000,10.69084326},
	{0.26149448,1.50400000,-7.71758354},
	{0.18806082,2.25244444,-7.74876033},
	{1.40227301,2.25244444,-7.23325778},
	{1.32883936,1.50400000,-7.26443457},
	{1.25540570,0.75555556,-7.29561136},
	{0.33492813,0.75555556,-7.68640675},
	{1.90779663,0.0000000e+0,-15.22945933},
	{3.14164568,2.33464763,-14.70561982},
	{1.12620585,0.0000000e+0,-13.38850418},
	{2.53026800,2.33464763,-13.26558380},
	{2.82827421,0.0000000e+0,-14.83866394},
	{2.04668342,0.0000000e+0,-12.99770879},
	{3.45872610,0.75555556,-15.04418537},
	{2.67713531,0.75555556,-13.20323022},
	{3.01546253,1.57000000,-14.75919179},
	{2.36748903,1.57000000,-13.23295815},
	{3.30018589,1.50400000,-14.87490259},
	{2.60370166,1.50400000,-13.23440701},
	{5.58970693,0.0000000e+0,-13.66627777},
	{4.35585788,2.33464763,-14.19011728},
	{4.80811614,0.0000000e+0,-11.82532262},
	{3.74448020,2.33464763,-12.75008125},
	{4.66922935,0.0000000e+0,-14.05707316},
	{3.88763857,0.0000000e+0,-12.21611801},
	{4.37920367,0.75555556,-14.65338997},
	{3.59761289,0.75555556,-12.81243483},
	{4.48204103,1.57000000,-14.13654531},
	{3.83406754,1.57000000,-12.61031167},
	{4.36753077,1.50400000,-14.42175363},
	{3.67104654,1.50400000,-12.78125804},
	{5.31755306,0.75555556,-19.42245740},
	{6.23803063,0.75555556,-19.03166201},
	{6.31146429,1.50400000,-19.00048522},
	{6.38489794,2.25244444,-18.96930843},
	{5.17068575,2.25244444,-19.48481097},
	{5.24411940,1.50400000,-19.45363419},
	{5.96587676,0.0000000e+0,-24.78784164},
	{7.19972581,2.33464763,-24.26400213},
	{6.74746755,0.0000000e+0,-26.62879678},
	{7.81110349,2.33464763,-25.70403815},
	{6.88635434,0.0000000e+0,-24.39704625},
	{7.66794512,0.0000000e+0,-26.23800139},
	{7.17638002,0.75555556,-23.80072943},
	{7.95797080,0.75555556,-25.64168458},
	{7.07354266,1.57000000,-24.31757410},
	{7.72151615,1.57000000,-25.84380773},
	{7.18805292,1.50400000,-24.03236578},
	{7.88453715,1.50400000,-25.67286137},
	{9.64778706,0.0000000e+0,-23.22466008},
	{8.41393801,2.33464763,-23.74849959},
	{10.42937784,0.0000000e+0,-25.06561522},
	{9.02531569,2.33464763,-25.18853561},
	{8.72730948,0.0000000e+0,-23.61545547},
	{9.50890027,0.0000000e+0,-25.45641061},
	{8.09685759,0.75555556,-23.40993404},
	{8.87844838,0.75555556,-25.25088919},
	{8.54012116,1.57000000,-23.69492762},
	{9.18809466,1.57000000,-25.22116125},
	{8.25539780,1.50400000,-23.57921681},
	{8.95188203,1.50400000,-25.21971240},
	{-5.45213847,3.04463423,9.72926217},
	{-5.79789203,3.04463423,10.54364845},
	{-5.07679432,2.66549843,10.88935915},
	{-4.72290835,2.66549843,10.05581784},
	{-5.91508082,2.33464763,10.00200203},
	{-4.94759550,1.91122222,9.56295449},
	{-5.57727109,1.91122222,11.04608932},
	{-4.60978577,1.57000000,10.60704177},
	{-5.75191894,3.22896351,10.07763200},
	{-5.52036507,2.77389582,9.53223114},
	{-5.49856164,2.97304685,10.86069746},
	{-5.98347280,2.77389582,10.62303286},
	{-4.77294765,2.71713018,10.53141180},
	{-5.01365047,2.26206248,11.09836207},
	{-5.02630495,2.97304685,9.74834634},
	{-4.53224482,2.26206248,9.96446154},
	{-5.26243329,3.12473608,10.30452190},
	{-5.91508082,2.85920137,10.00200203},
	{-5.57727109,2.51797915,11.04608932},
	{-4.60978577,2.17675693,10.60704177},
	{-4.94759550,2.51797915,9.56295449},
	{-7.12929301,2.33464763,9.48649949},
	{-4.76633832,0.0000000e+0,10.72630110},
	{14.95641742,2.33464763,-42.53407601},
	{16.17062961,2.33464763,-42.01857347},
	{16.02376230,0.75555556,-42.08092704},
	{15.10328473,0.75555556,-42.47172243},
};
const float normals[141][3]={
	{-0.82261930,-0.27227205,0.49916472},
	{-0.77562708,0.62264204,-0.10353515},
	{0.13388560,5.5773919e-2,-0.98942605},
	{-0.38878309,0.75700290,-0.52516124},
	{0.18044087,-0.86269431,0.47244007},
	{0.69222493,-0.65859256,-0.29509402},
	{-0.36069234,-0.84439342,0.39610705},
	{0.29552084,-0.76365722,-0.57401662},
	{-0.93558801,0.34201874,8.7739696e-2},
	{-0.11299367,0.35603192,-0.92761722},
	{-0.99612645,5.9933787e-2,6.4343194e-2},
	{-0.20022758,-7.4628931e-2,-0.97690298},
	{0.21223929,-0.27227205,0.93852140},
	{0.61320493,0.62264204,0.48610349},
	{0.61883819,5.5773919e-2,-0.78353593},
	{0.64785269,0.75700290,-8.5050045e-2},
	{-0.46521740,-0.86269431,0.19832119},
	{-0.26848882,-0.65859256,-0.70297197},
	{-3.4452259e-2,-0.84439342,0.53461463},
	{0.20771233,-0.76365722,-0.61129636},
	{0.58669690,0.34201874,0.73403673},
	{0.74584260,0.35603192,-0.56299209},
	{0.64557666,5.9933787e-2,0.76134008},
	{0.84188959,-7.4628931e-2,-0.53446463},
	{-0.61541652,-0.74363668,-0.26127952},
	{0.61541652,-0.74363668,0.26127952},
	{0.91408601,-0.13257009,0.38323876},
	{0.70625556,0.64324496,0.29570087},
	{-0.67928484,0.67619238,-0.28519464},
	{-0.91555164,-0.10331679,-0.38870405},
	{-0.21223929,-0.27227205,-0.93852140},
	{-0.59743751,0.62895064,-0.49748318},
	{-0.61883819,5.5773919e-2,0.78353593},
	{-0.51392227,0.53151718,0.67333007},
	{0.46521740,-0.86269431,-0.19832119},
	{0.26848882,-0.65859256,0.70297197},
	{3.4452259e-2,-0.84439342,-0.53461463},
	{-7.6161419e-3,-0.30953784,0.95085662},
	{-0.58669690,0.34201874,-0.73403673},
	{-0.74584260,0.35603192,0.56299209},
	{-0.64557666,5.9933787e-2,-0.76134008},
	{-0.14736171,3.3035670e-2,0.98853081},
	{0.73038756,-0.49987015,-0.46547164},
	{0.19278355,0.71703451,-0.66984776},
	{4.5902270e-2,-0.11650467,0.99212884},
	{-0.69259429,0.36059701,0.62472630},
	{-0.18044087,-0.86269431,-0.47244007},
	{-0.69222493,-0.65859256,0.29509402},
	{0.32461375,-0.84895947,-0.41700568},
	{-0.61857337,-0.25002166,0.74488667},
	{0.91078229,1.2603415e-2,-0.41269454},
	{0.21879359,-2.7156793e-2,0.97539319},
	{0.91272800,5.8748985e-2,-0.40432184},
	{-0.41361126,6.1160340e-2,0.90839702},
	{-0.91555695,-0.10326126,-0.38870630},
	{-0.68284112,0.67058409,-0.28990512},
	{0.68284112,0.67058409,0.28990512},
	{0.91555695,-0.10326126,0.38870630},
	{0.61541652,-0.74363668,0.26127952},
	{-0.61541652,-0.74363668,-0.26127952},
	{-0.21223929,-0.27227205,-0.93852140},
	{-0.61320493,0.62264204,-0.48610349},
	{-0.61883819,5.5773919e-2,0.78353593},
	{-0.64785269,0.75700290,8.5050045e-2},
	{0.46521740,-0.86269431,-0.19832119},
	{0.26848882,-0.65859256,0.70297197},
	{3.4452259e-2,-0.84439342,-0.53461463},
	{-0.20771233,-0.76365722,0.61129636},
	{-0.58669690,0.34201874,-0.73403673},
	{-0.74584260,0.35603192,0.56299209},
	{-0.64557666,5.9933787e-2,-0.76134008},
	{-0.84188959,-7.4628931e-2,0.53446463},
	{0.82261930,-0.27227205,-0.49916472},
	{0.77562708,0.62264204,0.10353515},
	{-0.13388560,5.5773919e-2,0.98942605},
	{0.38878309,0.75700290,0.52516124},
	{-0.18044087,-0.86269431,-0.47244007},
	{-0.69222493,-0.65859256,0.29509402},
	{0.36069234,-0.84439342,-0.39610705},
	{-0.29552084,-0.76365722,0.57401662},
	{0.93558801,0.34201874,-8.7739696e-2},
	{0.11299367,0.35603192,0.92761722},
	{0.99612645,5.9933787e-2,-6.4343194e-2},
	{0.20022758,-7.4628931e-2,0.97690298},
	{-0.61541652,-0.74363668,-0.26127952},
	{0.61541652,-0.74363668,0.26127952},
	{0.91555164,-0.10331679,0.38870405},
	{0.68288623,0.67052988,0.28992427},
	{-0.68288623,0.67052988,-0.28992427},
	{-0.91555164,-0.10331679,-0.38870405},
	{-0.82261930,-0.27227205,0.49916472},
	{-0.77562708,0.62264204,-0.10353515},
	{0.13388560,5.5773919e-2,-0.98942605},
	{-0.39117486,0.75817143,-0.52168794},
	{0.18044087,-0.86269431,0.47244007},
	{0.69222493,-0.65859256,-0.29509402},
	{-0.36069234,-0.84439342,0.39610705},
	{0.29578292,-0.76283865,-0.57496927},
	{-0.93558801,0.34201874,8.7739696e-2},
	{-0.11299367,0.35603192,-0.92761722},
	{-0.99612645,5.9933787e-2,6.4343194e-2},
	{0.24312136,-3.3706019e-2,-0.96941008},
	{0.21223929,-0.27227205,0.93852140},
	{0.61320493,0.62264204,0.48610349},
	{0.61883819,5.5773919e-2,-0.78353593},
	{0.64701510,0.75817143,-8.0916910e-2},
	{-0.46521740,-0.86269431,0.19832119},
	{-0.26848882,-0.65859256,-0.70297197},
	{-3.4452259e-2,-0.84439342,0.53461463},
	{0.20821568,-0.76283865,-0.61214658},
	{0.58669690,0.34201874,0.73403673},
	{0.74584260,0.35603192,-0.56299209},
	{0.64557666,5.9933787e-2,0.76134008},
	{0.52856741,-3.3706019e-2,-0.84822191},
	{-5.7277510e-2,0.73722420,-0.67321598},
	{-0.54913188,0.73001298,0.40686021},
	{0.48269473,0.54123450,0.68852815},
	{0.83943742,0.53103561,-0.11552488},
	{-0.62419267,0.73412678,-0.26728520},
	{0.46619566,0.10222590,-0.87875564},
	{-0.43246034,-1.4305276e-2,0.90153947},
	{0.92002475,4.2921615e-3,0.39183675},
	{-0.38701251,0.90691458,-0.16651507},
	{-0.31568623,0.27224406,-0.90896940},
	{2.6589165e-2,0.73568354,0.67680333},
	{-0.88834796,0.26484676,0.37509211},
	{0.74252179,0.59007705,0.31697077},
	{0.43841658,0.21322985,0.87311164},
	{0.53237301,0.72784406,-0.43222911},
	{0.94170539,0.20660707,-0.26552680},
	{0.36656414,0.91714827,0.15642818},
	{-0.88600676,0.26589637,-0.37985675},
	{-0.32922499,0.23936519,0.91340857},
	{0.90373482,0.18466020,0.38621754},
	{0.47707155,0.23743251,-0.84618469},
	{-0.35766536,0.92138696,-0.15205773},
	{0.82513311,-0.44339032,0.35008626},
	{-0.31377929,0.53761593,-0.78263125},
	{0.78099160,0.53761593,-0.31783838},
	{0.73029487,-0.61509165,-0.29720644},
	{-0.29341084,-0.61509165,-0.73182808},
};
//o cube1
material(mtl_station::m_kuppel);
glBegin(GL_POLYGON);
	glNormal3fv(normals[45]);
	glVertex3fv(vertices[45]);
	glNormal3fv(normals[120]);
	glVertex3fv(vertices[120]);
	glNormal3fv(normals[132]);
	glVertex3fv(vertices[132]);
	glNormal3fv(normals[125]);
	glVertex3fv(vertices[125]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[50]);
	glVertex3fv(vertices[50]);
	glNormal3fv(normals[129]);
	glVertex3fv(vertices[129]);
	glNormal3fv(normals[133]);
	glVertex3fv(vertices[133]);
	glNormal3fv(normals[121]);
	glVertex3fv(vertices[121]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[51]);
	glVertex3fv(vertices[51]);
	glNormal3fv(normals[121]);
	glVertex3fv(vertices[121]);
	glNormal3fv(normals[133]);
	glVertex3fv(vertices[133]);
	glNormal3fv(normals[127]);
	glVertex3fv(vertices[127]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[51]);
	glVertex3fv(vertices[51]);
	glNormal3fv(normals[127]);
	glVertex3fv(vertices[127]);
	glNormal3fv(normals[132]);
	glVertex3fv(vertices[132]);
	glNormal3fv(normals[120]);
	glVertex3fv(vertices[120]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[114]);
	glVertex3fv(vertices[114]);
	glNormal3fv(normals[122]);
	glVertex3fv(vertices[122]);
	glNormal3fv(normals[130]);
	glVertex3fv(vertices[130]);
	glNormal3fv(normals[128]);
	glVertex3fv(vertices[128]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[114]);
	glVertex3fv(vertices[114]);
	glNormal3fv(normals[123]);
	glVertex3fv(vertices[123]);
	glNormal3fv(normals[131]);
	glVertex3fv(vertices[131]);
	glNormal3fv(normals[122]);
	glVertex3fv(vertices[122]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[115]);
	glVertex3fv(vertices[115]);
	glNormal3fv(normals[124]);
	glVertex3fv(vertices[124]);
	glNormal3fv(normals[130]);
	glVertex3fv(vertices[130]);
	glNormal3fv(normals[122]);
	glVertex3fv(vertices[122]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[115]);
	glVertex3fv(vertices[115]);
	glNormal3fv(normals[125]);
	glVertex3fv(vertices[125]);
	glNormal3fv(normals[132]);
	glVertex3fv(vertices[132]);
	glNormal3fv(normals[124]);
	glVertex3fv(vertices[124]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[116]);
	glVertex3fv(vertices[116]);
	glNormal3fv(normals[126]);
	glVertex3fv(vertices[126]);
	glNormal3fv(normals[130]);
	glVertex3fv(vertices[130]);
	glNormal3fv(normals[124]);
	glVertex3fv(vertices[124]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[116]);
	glVertex3fv(vertices[116]);
	glNormal3fv(normals[127]);
	glVertex3fv(vertices[127]);
	glNormal3fv(normals[133]);
	glVertex3fv(vertices[133]);
	glNormal3fv(normals[126]);
	glVertex3fv(vertices[126]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[117]);
	glVertex3fv(vertices[117]);
	glNormal3fv(normals[128]);
	glVertex3fv(vertices[128]);
	glNormal3fv(normals[130]);
	glVertex3fv(vertices[130]);
	glNormal3fv(normals[126]);
	glVertex3fv(vertices[126]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[117]);
	glVertex3fv(vertices[117]);
	glNormal3fv(normals[129]);
	glVertex3fv(vertices[129]);
	glNormal3fv(normals[134]);
	glVertex3fv(vertices[134]);
	glNormal3fv(normals[128]);
	glVertex3fv(vertices[128]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[118]);
	glVertex3fv(vertices[118]);
	glNormal3fv(normals[131]);
	glVertex3fv(vertices[131]);
	glNormal3fv(normals[123]);
	glVertex3fv(vertices[123]);
	glNormal3fv(normals[43]);
	glVertex3fv(vertices[43]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[119]);
	glVertex3fv(vertices[119]);
	glNormal3fv(normals[134]);
	glVertex3fv(vertices[134]);
	glNormal3fv(normals[129]);
	glVertex3fv(vertices[129]);
	glNormal3fv(normals[50]);
	glVertex3fv(vertices[50]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[122]);
	glVertex3fv(vertices[122]);
	glNormal3fv(normals[131]);
	glVertex3fv(vertices[131]);
	glNormal3fv(normals[125]);
	glVertex3fv(vertices[125]);
	glNormal3fv(normals[115]);
	glVertex3fv(vertices[115]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[123]);
	glVertex3fv(vertices[123]);
	glNormal3fv(normals[134]);
	glVertex3fv(vertices[134]);
	glNormal3fv(normals[119]);
	glVertex3fv(vertices[119]);
	glNormal3fv(normals[43]);
	glVertex3fv(vertices[43]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[124]);
	glVertex3fv(vertices[124]);
	glNormal3fv(normals[132]);
	glVertex3fv(vertices[132]);
	glNormal3fv(normals[127]);
	glVertex3fv(vertices[127]);
	glNormal3fv(normals[116]);
	glVertex3fv(vertices[116]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[125]);
	glVertex3fv(vertices[125]);
	glNormal3fv(normals[131]);
	glVertex3fv(vertices[131]);
	glNormal3fv(normals[118]);
	glVertex3fv(vertices[118]);
	glNormal3fv(normals[45]);
	glVertex3fv(vertices[45]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[126]);
	glVertex3fv(vertices[126]);
	glNormal3fv(normals[133]);
	glVertex3fv(vertices[133]);
	glNormal3fv(normals[129]);
	glVertex3fv(vertices[129]);
	glNormal3fv(normals[117]);
	glVertex3fv(vertices[117]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[128]);
	glVertex3fv(vertices[128]);
	glNormal3fv(normals[134]);
	glVertex3fv(vertices[134]);
	glNormal3fv(normals[123]);
	glVertex3fv(vertices[123]);
	glNormal3fv(normals[114]);
	glVertex3fv(vertices[114]);
glEnd();
material(mtl_station::m_pfeiler);
glBegin(GL_POLYGON);
	glNormal3fv(normals[0]);
	glVertex3fv(vertices[0]);
	glNormal3fv(normals[2]);
	glVertex3fv(vertices[2]);
	glNormal3fv(normals[5]);
	glVertex3fv(vertices[5]);
	glNormal3fv(normals[4]);
	glVertex3fv(vertices[4]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[0]);
	glVertex3fv(vertices[0]);
	glNormal3fv(normals[6]);
	glVertex3fv(vertices[6]);
	glNormal3fv(normals[10]);
	glVertex3fv(vertices[10]);
	glNormal3fv(normals[8]);
	glVertex3fv(vertices[8]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[1]);
	glVertex3fv(vertices[1]);
	glNormal3fv(normals[8]);
	glVertex3fv(vertices[8]);
	glNormal3fv(normals[10]);
	glVertex3fv(vertices[10]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[1]);
	glVertex3fv(vertices[1]);
	glNormal3fv(normals[13]);
	glVertex3fv(vertices[13]);
	glNormal3fv(normals[15]);
	glVertex3fv(vertices[15]);
	glNormal3fv(normals[3]);
	glVertex3fv(vertices[3]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[2]);
	glVertex3fv(vertices[2]);
	glNormal3fv(normals[7]);
	glVertex3fv(vertices[7]);
	glNormal3fv(normals[5]);
	glVertex3fv(vertices[5]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[3]);
	glVertex3fv(vertices[3]);
	glNormal3fv(normals[9]);
	glVertex3fv(vertices[9]);
	glNormal3fv(normals[8]);
	glVertex3fv(vertices[8]);
	glNormal3fv(normals[1]);
	glVertex3fv(vertices[1]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[4]);
	glVertex3fv(vertices[4]);
	glNormal3fv(normals[5]);
	glVertex3fv(vertices[5]);
	glNormal3fv(normals[7]);
	glVertex3fv(vertices[7]);
	glNormal3fv(normals[6]);
	glVertex3fv(vertices[6]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[4]);
	glVertex3fv(vertices[4]);
	glNormal3fv(normals[6]);
	glVertex3fv(vertices[6]);
	glNormal3fv(normals[0]);
	glVertex3fv(vertices[0]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[7]);
	glVertex3fv(vertices[7]);
	glNormal3fv(normals[19]);
	glVertex3fv(vertices[19]);
	glNormal3fv(normals[18]);
	glVertex3fv(vertices[18]);
	glNormal3fv(normals[6]);
	glVertex3fv(vertices[6]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[8]);
	glVertex3fv(vertices[8]);
	glNormal3fv(normals[9]);
	glVertex3fv(vertices[9]);
	glNormal3fv(normals[2]);
	glVertex3fv(vertices[2]);
	glNormal3fv(normals[0]);
	glVertex3fv(vertices[0]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[9]);
	glVertex3fv(vertices[9]);
	glNormal3fv(normals[11]);
	glVertex3fv(vertices[11]);
	glNormal3fv(normals[7]);
	glVertex3fv(vertices[7]);
	glNormal3fv(normals[2]);
	glVertex3fv(vertices[2]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[11]);
	glVertex3fv(vertices[11]);
	glNormal3fv(normals[9]);
	glVertex3fv(vertices[9]);
	glNormal3fv(normals[3]);
	glVertex3fv(vertices[3]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[12]);
	glVertex3fv(vertices[12]);
	glNormal3fv(normals[14]);
	glVertex3fv(vertices[14]);
	glNormal3fv(normals[21]);
	glVertex3fv(vertices[21]);
	glNormal3fv(normals[20]);
	glVertex3fv(vertices[20]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[12]);
	glVertex3fv(vertices[12]);
	glNormal3fv(normals[18]);
	glVertex3fv(vertices[18]);
	glNormal3fv(normals[16]);
	glVertex3fv(vertices[16]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[13]);
	glVertex3fv(vertices[13]);
	glNormal3fv(normals[20]);
	glVertex3fv(vertices[20]);
	glNormal3fv(normals[21]);
	glVertex3fv(vertices[21]);
	glNormal3fv(normals[15]);
	glVertex3fv(vertices[15]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[14]);
	glVertex3fv(vertices[14]);
	glNormal3fv(normals[19]);
	glVertex3fv(vertices[19]);
	glNormal3fv(normals[23]);
	glVertex3fv(vertices[23]);
	glNormal3fv(normals[21]);
	glVertex3fv(vertices[21]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[15]);
	glVertex3fv(vertices[15]);
	glNormal3fv(normals[21]);
	glVertex3fv(vertices[21]);
	glNormal3fv(normals[23]);
	glVertex3fv(vertices[23]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[16]);
	glVertex3fv(vertices[16]);
	glNormal3fv(normals[17]);
	glVertex3fv(vertices[17]);
	glNormal3fv(normals[14]);
	glVertex3fv(vertices[14]);
	glNormal3fv(normals[12]);
	glVertex3fv(vertices[12]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[17]);
	glVertex3fv(vertices[17]);
	glNormal3fv(normals[19]);
	glVertex3fv(vertices[19]);
	glNormal3fv(normals[14]);
	glVertex3fv(vertices[14]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[18]);
	glVertex3fv(vertices[18]);
	glNormal3fv(normals[19]);
	glVertex3fv(vertices[19]);
	glNormal3fv(normals[17]);
	glVertex3fv(vertices[17]);
	glNormal3fv(normals[16]);
	glVertex3fv(vertices[16]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[20]);
	glVertex3fv(vertices[20]);
	glNormal3fv(normals[22]);
	glVertex3fv(vertices[22]);
	glNormal3fv(normals[18]);
	glVertex3fv(vertices[18]);
	glNormal3fv(normals[12]);
	glVertex3fv(vertices[12]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[22]);
	glVertex3fv(vertices[22]);
	glNormal3fv(normals[20]);
	glVertex3fv(vertices[20]);
	glNormal3fv(normals[13]);
	glVertex3fv(vertices[13]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[30]);
	glVertex3fv(vertices[30]);
	glNormal3fv(normals[32]);
	glVertex3fv(vertices[32]);
	glNormal3fv(normals[39]);
	glVertex3fv(vertices[39]);
	glNormal3fv(normals[38]);
	glVertex3fv(vertices[38]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[30]);
	glVertex3fv(vertices[30]);
	glNormal3fv(normals[36]);
	glVertex3fv(vertices[36]);
	glNormal3fv(normals[34]);
	glVertex3fv(vertices[34]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[32]);
	glVertex3fv(vertices[32]);
	glNormal3fv(normals[37]);
	glVertex3fv(vertices[37]);
	glNormal3fv(normals[41]);
	glVertex3fv(vertices[41]);
	glNormal3fv(normals[39]);
	glVertex3fv(vertices[39]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[33]);
	glVertex3fv(vertices[33]);
	glNormal3fv(normals[39]);
	glVertex3fv(vertices[39]);
	glNormal3fv(normals[41]);
	glVertex3fv(vertices[41]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[33]);
	glVertex3fv(vertices[33]);
	glNormal3fv(normals[45]);
	glVertex3fv(vertices[45]);
	glNormal3fv(normals[118]);
	glVertex3fv(vertices[118]);
	glNormal3fv(normals[135]);
	glVertex3fv(vertices[135]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[34]);
	glVertex3fv(vertices[34]);
	glNormal3fv(normals[35]);
	glVertex3fv(vertices[35]);
	glNormal3fv(normals[32]);
	glVertex3fv(vertices[32]);
	glNormal3fv(normals[30]);
	glVertex3fv(vertices[30]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[35]);
	glVertex3fv(vertices[35]);
	glNormal3fv(normals[37]);
	glVertex3fv(vertices[37]);
	glNormal3fv(normals[32]);
	glVertex3fv(vertices[32]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[36]);
	glVertex3fv(vertices[36]);
	glNormal3fv(normals[37]);
	glVertex3fv(vertices[37]);
	glNormal3fv(normals[35]);
	glVertex3fv(vertices[35]);
	glNormal3fv(normals[34]);
	glVertex3fv(vertices[34]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[36]);
	glVertex3fv(vertices[36]);
	glNormal3fv(normals[48]);
	glVertex3fv(vertices[48]);
	glNormal3fv(normals[49]);
	glVertex3fv(vertices[49]);
	glNormal3fv(normals[37]);
	glVertex3fv(vertices[37]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[38]);
	glVertex3fv(vertices[38]);
	glNormal3fv(normals[40]);
	glVertex3fv(vertices[40]);
	glNormal3fv(normals[36]);
	glVertex3fv(vertices[36]);
	glNormal3fv(normals[30]);
	glVertex3fv(vertices[30]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[40]);
	glVertex3fv(vertices[40]);
	glNormal3fv(normals[38]);
	glVertex3fv(vertices[38]);
	glNormal3fv(normals[31]);
	glVertex3fv(vertices[31]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[41]);
	glVertex3fv(vertices[41]);
	glNormal3fv(normals[37]);
	glVertex3fv(vertices[37]);
	glNormal3fv(normals[49]);
	glVertex3fv(vertices[49]);
	glNormal3fv(normals[53]);
	glVertex3fv(vertices[53]);
	glNormal3fv(normals[45]);
	glVertex3fv(vertices[45]);
	glNormal3fv(normals[33]);
	glVertex3fv(vertices[33]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[42]);
	glVertex3fv(vertices[42]);
	glNormal3fv(normals[48]);
	glVertex3fv(vertices[48]);
	glNormal3fv(normals[52]);
	glVertex3fv(vertices[52]);
	glNormal3fv(normals[50]);
	glVertex3fv(vertices[50]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[42]);
	glVertex3fv(vertices[42]);
	glNormal3fv(normals[136]);
	glVertex3fv(vertices[136]);
	glNormal3fv(normals[44]);
	glVertex3fv(vertices[44]);
	glNormal3fv(normals[47]);
	glVertex3fv(vertices[47]);
	glNormal3fv(normals[46]);
	glVertex3fv(vertices[46]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[43]);
	glVertex3fv(vertices[43]);
	glNormal3fv(normals[31]);
	glVertex3fv(vertices[31]);
	glNormal3fv(normals[135]);
	glVertex3fv(vertices[135]);
	glNormal3fv(normals[118]);
	glVertex3fv(vertices[118]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[43]);
	glVertex3fv(vertices[43]);
	glNormal3fv(normals[119]);
	glVertex3fv(vertices[119]);
	glNormal3fv(normals[52]);
	glVertex3fv(vertices[52]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[44]);
	glVertex3fv(vertices[44]);
	glNormal3fv(normals[49]);
	glVertex3fv(vertices[49]);
	glNormal3fv(normals[47]);
	glVertex3fv(vertices[47]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[44]);
	glVertex3fv(vertices[44]);
	glNormal3fv(normals[136]);
	glVertex3fv(vertices[136]);
	glNormal3fv(normals[121]);
	glVertex3fv(vertices[121]);
	glNormal3fv(normals[51]);
	glVertex3fv(vertices[51]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[46]);
	glVertex3fv(vertices[46]);
	glNormal3fv(normals[47]);
	glVertex3fv(vertices[47]);
	glNormal3fv(normals[49]);
	glVertex3fv(vertices[49]);
	glNormal3fv(normals[48]);
	glVertex3fv(vertices[48]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[46]);
	glVertex3fv(vertices[46]);
	glNormal3fv(normals[48]);
	glVertex3fv(vertices[48]);
	glNormal3fv(normals[42]);
	glVertex3fv(vertices[42]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[50]);
	glVertex3fv(vertices[50]);
	glNormal3fv(normals[52]);
	glVertex3fv(vertices[52]);
	glNormal3fv(normals[119]);
	glVertex3fv(vertices[119]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[50]);
	glVertex3fv(vertices[50]);
	glNormal3fv(normals[121]);
	glVertex3fv(vertices[121]);
	glNormal3fv(normals[136]);
	glVertex3fv(vertices[136]);
	glNormal3fv(normals[42]);
	glVertex3fv(vertices[42]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[51]);
	glVertex3fv(vertices[51]);
	glNormal3fv(normals[53]);
	glVertex3fv(vertices[53]);
	glNormal3fv(normals[49]);
	glVertex3fv(vertices[49]);
	glNormal3fv(normals[44]);
	glVertex3fv(vertices[44]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[53]);
	glVertex3fv(vertices[53]);
	glNormal3fv(normals[120]);
	glVertex3fv(vertices[120]);
	glNormal3fv(normals[45]);
	glVertex3fv(vertices[45]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[60]);
	glVertex3fv(vertices[60]);
	glNormal3fv(normals[62]);
	glVertex3fv(vertices[62]);
	glNormal3fv(normals[69]);
	glVertex3fv(vertices[69]);
	glNormal3fv(normals[68]);
	glVertex3fv(vertices[68]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[60]);
	glVertex3fv(vertices[60]);
	glNormal3fv(normals[66]);
	glVertex3fv(vertices[66]);
	glNormal3fv(normals[64]);
	glVertex3fv(vertices[64]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[61]);
	glVertex3fv(vertices[61]);
	glNormal3fv(normals[68]);
	glVertex3fv(vertices[68]);
	glNormal3fv(normals[69]);
	glVertex3fv(vertices[69]);
	glNormal3fv(normals[63]);
	glVertex3fv(vertices[63]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[62]);
	glVertex3fv(vertices[62]);
	glNormal3fv(normals[67]);
	glVertex3fv(vertices[67]);
	glNormal3fv(normals[71]);
	glVertex3fv(vertices[71]);
	glNormal3fv(normals[69]);
	glVertex3fv(vertices[69]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[63]);
	glVertex3fv(vertices[63]);
	glNormal3fv(normals[69]);
	glVertex3fv(vertices[69]);
	glNormal3fv(normals[71]);
	glVertex3fv(vertices[71]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[63]);
	glVertex3fv(vertices[63]);
	glNormal3fv(normals[75]);
	glVertex3fv(vertices[75]);
	glNormal3fv(normals[73]);
	glVertex3fv(vertices[73]);
	glNormal3fv(normals[61]);
	glVertex3fv(vertices[61]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[64]);
	glVertex3fv(vertices[64]);
	glNormal3fv(normals[65]);
	glVertex3fv(vertices[65]);
	glNormal3fv(normals[62]);
	glVertex3fv(vertices[62]);
	glNormal3fv(normals[60]);
	glVertex3fv(vertices[60]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[65]);
	glVertex3fv(vertices[65]);
	glNormal3fv(normals[67]);
	glVertex3fv(vertices[67]);
	glNormal3fv(normals[62]);
	glVertex3fv(vertices[62]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[66]);
	glVertex3fv(vertices[66]);
	glNormal3fv(normals[67]);
	glVertex3fv(vertices[67]);
	glNormal3fv(normals[65]);
	glVertex3fv(vertices[65]);
	glNormal3fv(normals[64]);
	glVertex3fv(vertices[64]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[66]);
	glVertex3fv(vertices[66]);
	glNormal3fv(normals[78]);
	glVertex3fv(vertices[78]);
	glNormal3fv(normals[79]);
	glVertex3fv(vertices[79]);
	glNormal3fv(normals[67]);
	glVertex3fv(vertices[67]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[68]);
	glVertex3fv(vertices[68]);
	glNormal3fv(normals[70]);
	glVertex3fv(vertices[70]);
	glNormal3fv(normals[66]);
	glVertex3fv(vertices[66]);
	glNormal3fv(normals[60]);
	glVertex3fv(vertices[60]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[70]);
	glVertex3fv(vertices[70]);
	glNormal3fv(normals[68]);
	glVertex3fv(vertices[68]);
	glNormal3fv(normals[61]);
	glVertex3fv(vertices[61]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[72]);
	glVertex3fv(vertices[72]);
	glNormal3fv(normals[74]);
	glVertex3fv(vertices[74]);
	glNormal3fv(normals[77]);
	glVertex3fv(vertices[77]);
	glNormal3fv(normals[76]);
	glVertex3fv(vertices[76]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[72]);
	glVertex3fv(vertices[72]);
	glNormal3fv(normals[78]);
	glVertex3fv(vertices[78]);
	glNormal3fv(normals[82]);
	glVertex3fv(vertices[82]);
	glNormal3fv(normals[80]);
	glVertex3fv(vertices[80]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[73]);
	glVertex3fv(vertices[73]);
	glNormal3fv(normals[80]);
	glVertex3fv(vertices[80]);
	glNormal3fv(normals[82]);
	glVertex3fv(vertices[82]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[74]);
	glVertex3fv(vertices[74]);
	glNormal3fv(normals[79]);
	glVertex3fv(vertices[79]);
	glNormal3fv(normals[77]);
	glVertex3fv(vertices[77]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[75]);
	glVertex3fv(vertices[75]);
	glNormal3fv(normals[81]);
	glVertex3fv(vertices[81]);
	glNormal3fv(normals[80]);
	glVertex3fv(vertices[80]);
	glNormal3fv(normals[73]);
	glVertex3fv(vertices[73]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[76]);
	glVertex3fv(vertices[76]);
	glNormal3fv(normals[77]);
	glVertex3fv(vertices[77]);
	glNormal3fv(normals[79]);
	glVertex3fv(vertices[79]);
	glNormal3fv(normals[78]);
	glVertex3fv(vertices[78]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[76]);
	glVertex3fv(vertices[76]);
	glNormal3fv(normals[78]);
	glVertex3fv(vertices[78]);
	glNormal3fv(normals[72]);
	glVertex3fv(vertices[72]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[80]);
	glVertex3fv(vertices[80]);
	glNormal3fv(normals[81]);
	glVertex3fv(vertices[81]);
	glNormal3fv(normals[74]);
	glVertex3fv(vertices[74]);
	glNormal3fv(normals[72]);
	glVertex3fv(vertices[72]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[81]);
	glVertex3fv(vertices[81]);
	glNormal3fv(normals[83]);
	glVertex3fv(vertices[83]);
	glNormal3fv(normals[79]);
	glVertex3fv(vertices[79]);
	glNormal3fv(normals[74]);
	glVertex3fv(vertices[74]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[83]);
	glVertex3fv(vertices[83]);
	glNormal3fv(normals[81]);
	glVertex3fv(vertices[81]);
	glNormal3fv(normals[75]);
	glVertex3fv(vertices[75]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[90]);
	glVertex3fv(vertices[90]);
	glNormal3fv(normals[92]);
	glVertex3fv(vertices[92]);
	glNormal3fv(normals[95]);
	glVertex3fv(vertices[95]);
	glNormal3fv(normals[94]);
	glVertex3fv(vertices[94]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[90]);
	glVertex3fv(vertices[90]);
	glNormal3fv(normals[96]);
	glVertex3fv(vertices[96]);
	glNormal3fv(normals[100]);
	glVertex3fv(vertices[100]);
	glNormal3fv(normals[98]);
	glVertex3fv(vertices[98]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[91]);
	glVertex3fv(vertices[91]);
	glNormal3fv(normals[98]);
	glVertex3fv(vertices[98]);
	glNormal3fv(normals[100]);
	glVertex3fv(vertices[100]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[91]);
	glVertex3fv(vertices[91]);
	glNormal3fv(normals[103]);
	glVertex3fv(vertices[103]);
	glNormal3fv(normals[105]);
	glVertex3fv(vertices[105]);
	glNormal3fv(normals[93]);
	glVertex3fv(vertices[93]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[92]);
	glVertex3fv(vertices[92]);
	glNormal3fv(normals[97]);
	glVertex3fv(vertices[97]);
	glNormal3fv(normals[95]);
	glVertex3fv(vertices[95]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[93]);
	glVertex3fv(vertices[93]);
	glNormal3fv(normals[99]);
	glVertex3fv(vertices[99]);
	glNormal3fv(normals[98]);
	glVertex3fv(vertices[98]);
	glNormal3fv(normals[91]);
	glVertex3fv(vertices[91]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[94]);
	glVertex3fv(vertices[94]);
	glNormal3fv(normals[95]);
	glVertex3fv(vertices[95]);
	glNormal3fv(normals[97]);
	glVertex3fv(vertices[97]);
	glNormal3fv(normals[96]);
	glVertex3fv(vertices[96]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[94]);
	glVertex3fv(vertices[94]);
	glNormal3fv(normals[96]);
	glVertex3fv(vertices[96]);
	glNormal3fv(normals[90]);
	glVertex3fv(vertices[90]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[97]);
	glVertex3fv(vertices[97]);
	glNormal3fv(normals[109]);
	glVertex3fv(vertices[109]);
	glNormal3fv(normals[108]);
	glVertex3fv(vertices[108]);
	glNormal3fv(normals[96]);
	glVertex3fv(vertices[96]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[98]);
	glVertex3fv(vertices[98]);
	glNormal3fv(normals[99]);
	glVertex3fv(vertices[99]);
	glNormal3fv(normals[92]);
	glVertex3fv(vertices[92]);
	glNormal3fv(normals[90]);
	glVertex3fv(vertices[90]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[99]);
	glVertex3fv(vertices[99]);
	glNormal3fv(normals[101]);
	glVertex3fv(vertices[101]);
	glNormal3fv(normals[97]);
	glVertex3fv(vertices[97]);
	glNormal3fv(normals[92]);
	glVertex3fv(vertices[92]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[101]);
	glVertex3fv(vertices[101]);
	glNormal3fv(normals[99]);
	glVertex3fv(vertices[99]);
	glNormal3fv(normals[93]);
	glVertex3fv(vertices[93]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[102]);
	glVertex3fv(vertices[102]);
	glNormal3fv(normals[104]);
	glVertex3fv(vertices[104]);
	glNormal3fv(normals[111]);
	glVertex3fv(vertices[111]);
	glNormal3fv(normals[110]);
	glVertex3fv(vertices[110]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[102]);
	glVertex3fv(vertices[102]);
	glNormal3fv(normals[108]);
	glVertex3fv(vertices[108]);
	glNormal3fv(normals[106]);
	glVertex3fv(vertices[106]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[103]);
	glVertex3fv(vertices[103]);
	glNormal3fv(normals[110]);
	glVertex3fv(vertices[110]);
	glNormal3fv(normals[111]);
	glVertex3fv(vertices[111]);
	glNormal3fv(normals[105]);
	glVertex3fv(vertices[105]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[104]);
	glVertex3fv(vertices[104]);
	glNormal3fv(normals[109]);
	glVertex3fv(vertices[109]);
	glNormal3fv(normals[113]);
	glVertex3fv(vertices[113]);
	glNormal3fv(normals[111]);
	glVertex3fv(vertices[111]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[105]);
	glVertex3fv(vertices[105]);
	glNormal3fv(normals[111]);
	glVertex3fv(vertices[111]);
	glNormal3fv(normals[113]);
	glVertex3fv(vertices[113]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[106]);
	glVertex3fv(vertices[106]);
	glNormal3fv(normals[107]);
	glVertex3fv(vertices[107]);
	glNormal3fv(normals[104]);
	glVertex3fv(vertices[104]);
	glNormal3fv(normals[102]);
	glVertex3fv(vertices[102]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[107]);
	glVertex3fv(vertices[107]);
	glNormal3fv(normals[109]);
	glVertex3fv(vertices[109]);
	glNormal3fv(normals[104]);
	glVertex3fv(vertices[104]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[108]);
	glVertex3fv(vertices[108]);
	glNormal3fv(normals[109]);
	glVertex3fv(vertices[109]);
	glNormal3fv(normals[107]);
	glVertex3fv(vertices[107]);
	glNormal3fv(normals[106]);
	glVertex3fv(vertices[106]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[110]);
	glVertex3fv(vertices[110]);
	glNormal3fv(normals[112]);
	glVertex3fv(vertices[112]);
	glNormal3fv(normals[108]);
	glVertex3fv(vertices[108]);
	glNormal3fv(normals[102]);
	glVertex3fv(vertices[102]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[112]);
	glVertex3fv(vertices[112]);
	glNormal3fv(normals[110]);
	glVertex3fv(vertices[110]);
	glNormal3fv(normals[103]);
	glVertex3fv(vertices[103]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[120]);
	glVertex3fv(vertices[120]);
	glNormal3fv(normals[53]);
	glVertex3fv(vertices[53]);
	glNormal3fv(normals[51]);
	glVertex3fv(vertices[51]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[135]);
	glVertex3fv(vertices[135]);
	glNormal3fv(normals[31]);
	glVertex3fv(vertices[31]);
	glNormal3fv(normals[38]);
	glVertex3fv(vertices[38]);
	glNormal3fv(normals[39]);
	glVertex3fv(vertices[39]);
	glNormal3fv(normals[33]);
	glVertex3fv(vertices[33]);
glEnd();
material(mtl_station::m_streben);
glBegin(GL_POLYGON);
	glNormal3fv(normals[1]);
	glVertex3fv(vertices[1]);
	glNormal3fv(normals[28]);
	glVertex3fv(vertices[28]);
	glNormal3fv(normals[27]);
	glVertex3fv(vertices[27]);
	glNormal3fv(normals[13]);
	glVertex3fv(vertices[13]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[3]);
	glVertex3fv(vertices[3]);
	glNormal3fv(normals[55]);
	glVertex3fv(vertices[55]);
	glNormal3fv(normals[54]);
	glVertex3fv(vertices[54]);
	glNormal3fv(normals[11]);
	glVertex3fv(vertices[11]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[6]);
	glVertex3fv(vertices[6]);
	glNormal3fv(normals[24]);
	glVertex3fv(vertices[24]);
	glNormal3fv(normals[29]);
	glVertex3fv(vertices[29]);
	glNormal3fv(normals[10]);
	glVertex3fv(vertices[10]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[7]);
	glVertex3fv(vertices[7]);
	glNormal3fv(normals[59]);
	glVertex3fv(vertices[59]);
	glNormal3fv(normals[58]);
	glVertex3fv(vertices[58]);
	glNormal3fv(normals[19]);
	glVertex3fv(vertices[19]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[10]);
	glVertex3fv(vertices[10]);
	glNormal3fv(normals[29]);
	glVertex3fv(vertices[29]);
	glNormal3fv(normals[28]);
	glVertex3fv(vertices[28]);
	glNormal3fv(normals[1]);
	glVertex3fv(vertices[1]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[11]);
	glVertex3fv(vertices[11]);
	glNormal3fv(normals[54]);
	glVertex3fv(vertices[54]);
	glNormal3fv(normals[59]);
	glVertex3fv(vertices[59]);
	glNormal3fv(normals[7]);
	glVertex3fv(vertices[7]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[13]);
	glVertex3fv(vertices[13]);
	glNormal3fv(normals[27]);
	glVertex3fv(vertices[27]);
	glNormal3fv(normals[26]);
	glVertex3fv(vertices[26]);
	glNormal3fv(normals[22]);
	glVertex3fv(vertices[22]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[15]);
	glVertex3fv(vertices[15]);
	glNormal3fv(normals[56]);
	glVertex3fv(vertices[56]);
	glNormal3fv(normals[55]);
	glVertex3fv(vertices[55]);
	glNormal3fv(normals[3]);
	glVertex3fv(vertices[3]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[18]);
	glVertex3fv(vertices[18]);
	glNormal3fv(normals[25]);
	glVertex3fv(vertices[25]);
	glNormal3fv(normals[24]);
	glVertex3fv(vertices[24]);
	glNormal3fv(normals[6]);
	glVertex3fv(vertices[6]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[19]);
	glVertex3fv(vertices[19]);
	glNormal3fv(normals[58]);
	glVertex3fv(vertices[58]);
	glNormal3fv(normals[57]);
	glVertex3fv(vertices[57]);
	glNormal3fv(normals[23]);
	glVertex3fv(vertices[23]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[22]);
	glVertex3fv(vertices[22]);
	glNormal3fv(normals[26]);
	glVertex3fv(vertices[26]);
	glNormal3fv(normals[25]);
	glVertex3fv(vertices[25]);
	glNormal3fv(normals[18]);
	glVertex3fv(vertices[18]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[23]);
	glVertex3fv(vertices[23]);
	glNormal3fv(normals[57]);
	glVertex3fv(vertices[57]);
	glNormal3fv(normals[56]);
	glVertex3fv(vertices[56]);
	glNormal3fv(normals[15]);
	glVertex3fv(vertices[15]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[24]);
	glVertex3fv(vertices[24]);
	glNormal3fv(normals[36]);
	glVertex3fv(vertices[36]);
	glNormal3fv(normals[40]);
	glVertex3fv(vertices[40]);
	glNormal3fv(normals[29]);
	glVertex3fv(vertices[29]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[25]);
	glVertex3fv(vertices[25]);
	glNormal3fv(normals[48]);
	glVertex3fv(vertices[48]);
	glNormal3fv(normals[36]);
	glVertex3fv(vertices[36]);
	glNormal3fv(normals[24]);
	glVertex3fv(vertices[24]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[26]);
	glVertex3fv(vertices[26]);
	glNormal3fv(normals[52]);
	glVertex3fv(vertices[52]);
	glNormal3fv(normals[48]);
	glVertex3fv(vertices[48]);
	glNormal3fv(normals[25]);
	glVertex3fv(vertices[25]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[27]);
	glVertex3fv(vertices[27]);
	glNormal3fv(normals[43]);
	glVertex3fv(vertices[43]);
	glNormal3fv(normals[52]);
	glVertex3fv(vertices[52]);
	glNormal3fv(normals[26]);
	glVertex3fv(vertices[26]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[28]);
	glVertex3fv(vertices[28]);
	glNormal3fv(normals[31]);
	glVertex3fv(vertices[31]);
	glNormal3fv(normals[43]);
	glVertex3fv(vertices[43]);
	glNormal3fv(normals[27]);
	glVertex3fv(vertices[27]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[29]);
	glVertex3fv(vertices[29]);
	glNormal3fv(normals[40]);
	glVertex3fv(vertices[40]);
	glNormal3fv(normals[31]);
	glVertex3fv(vertices[31]);
	glNormal3fv(normals[28]);
	glVertex3fv(vertices[28]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[54]);
	glVertex3fv(vertices[54]);
	glNormal3fv(normals[71]);
	glVertex3fv(vertices[71]);
	glNormal3fv(normals[67]);
	glVertex3fv(vertices[67]);
	glNormal3fv(normals[59]);
	glVertex3fv(vertices[59]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[55]);
	glVertex3fv(vertices[55]);
	glNormal3fv(normals[63]);
	glVertex3fv(vertices[63]);
	glNormal3fv(normals[71]);
	glVertex3fv(vertices[71]);
	glNormal3fv(normals[54]);
	glVertex3fv(vertices[54]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[56]);
	glVertex3fv(vertices[56]);
	glNormal3fv(normals[75]);
	glVertex3fv(vertices[75]);
	glNormal3fv(normals[63]);
	glVertex3fv(vertices[63]);
	glNormal3fv(normals[55]);
	glVertex3fv(vertices[55]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[57]);
	glVertex3fv(vertices[57]);
	glNormal3fv(normals[83]);
	glVertex3fv(vertices[83]);
	glNormal3fv(normals[75]);
	glVertex3fv(vertices[75]);
	glNormal3fv(normals[56]);
	glVertex3fv(vertices[56]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[58]);
	glVertex3fv(vertices[58]);
	glNormal3fv(normals[79]);
	glVertex3fv(vertices[79]);
	glNormal3fv(normals[83]);
	glVertex3fv(vertices[83]);
	glNormal3fv(normals[57]);
	glVertex3fv(vertices[57]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[59]);
	glVertex3fv(vertices[59]);
	glNormal3fv(normals[67]);
	glVertex3fv(vertices[67]);
	glNormal3fv(normals[79]);
	glVertex3fv(vertices[79]);
	glNormal3fv(normals[58]);
	glVertex3fv(vertices[58]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[61]);
	glVertex3fv(vertices[61]);
	glNormal3fv(normals[88]);
	glVertex3fv(vertices[88]);
	glNormal3fv(normals[89]);
	glVertex3fv(vertices[89]);
	glNormal3fv(normals[70]);
	glVertex3fv(vertices[70]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[66]);
	glVertex3fv(vertices[66]);
	glNormal3fv(normals[84]);
	glVertex3fv(vertices[84]);
	glNormal3fv(normals[85]);
	glVertex3fv(vertices[85]);
	glNormal3fv(normals[78]);
	glVertex3fv(vertices[78]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[70]);
	glVertex3fv(vertices[70]);
	glNormal3fv(normals[89]);
	glVertex3fv(vertices[89]);
	glNormal3fv(normals[84]);
	glVertex3fv(vertices[84]);
	glNormal3fv(normals[66]);
	glVertex3fv(vertices[66]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[73]);
	glVertex3fv(vertices[73]);
	glNormal3fv(normals[87]);
	glVertex3fv(vertices[87]);
	glNormal3fv(normals[88]);
	glVertex3fv(vertices[88]);
	glNormal3fv(normals[61]);
	glVertex3fv(vertices[61]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[78]);
	glVertex3fv(vertices[78]);
	glNormal3fv(normals[85]);
	glVertex3fv(vertices[85]);
	glNormal3fv(normals[86]);
	glVertex3fv(vertices[86]);
	glNormal3fv(normals[82]);
	glVertex3fv(vertices[82]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[82]);
	glVertex3fv(vertices[82]);
	glNormal3fv(normals[86]);
	glVertex3fv(vertices[86]);
	glNormal3fv(normals[87]);
	glVertex3fv(vertices[87]);
	glNormal3fv(normals[73]);
	glVertex3fv(vertices[73]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[84]);
	glVertex3fv(vertices[84]);
	glNormal3fv(normals[96]);
	glVertex3fv(vertices[96]);
	glNormal3fv(normals[108]);
	glVertex3fv(vertices[108]);
	glNormal3fv(normals[85]);
	glVertex3fv(vertices[85]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[85]);
	glVertex3fv(vertices[85]);
	glNormal3fv(normals[108]);
	glVertex3fv(vertices[108]);
	glNormal3fv(normals[112]);
	glVertex3fv(vertices[112]);
	glNormal3fv(normals[86]);
	glVertex3fv(vertices[86]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[86]);
	glVertex3fv(vertices[86]);
	glNormal3fv(normals[112]);
	glVertex3fv(vertices[112]);
	glNormal3fv(normals[103]);
	glVertex3fv(vertices[103]);
	glNormal3fv(normals[87]);
	glVertex3fv(vertices[87]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[87]);
	glVertex3fv(vertices[87]);
	glNormal3fv(normals[103]);
	glVertex3fv(vertices[103]);
	glNormal3fv(normals[91]);
	glVertex3fv(vertices[91]);
	glNormal3fv(normals[88]);
	glVertex3fv(vertices[88]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[88]);
	glVertex3fv(vertices[88]);
	glNormal3fv(normals[91]);
	glVertex3fv(vertices[91]);
	glNormal3fv(normals[100]);
	glVertex3fv(vertices[100]);
	glNormal3fv(normals[89]);
	glVertex3fv(vertices[89]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[89]);
	glVertex3fv(vertices[89]);
	glNormal3fv(normals[100]);
	glVertex3fv(vertices[100]);
	glNormal3fv(normals[96]);
	glVertex3fv(vertices[96]);
	glNormal3fv(normals[84]);
	glVertex3fv(vertices[84]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[93]);
	glVertex3fv(vertices[93]);
	glNormal3fv(normals[137]);
	glVertex3fv(vertices[137]);
	glNormal3fv(normals[140]);
	glVertex3fv(vertices[140]);
	glNormal3fv(normals[97]);
	glVertex3fv(vertices[97]);
	glNormal3fv(normals[101]);
	glVertex3fv(vertices[101]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[97]);
	glVertex3fv(vertices[97]);
	glNormal3fv(normals[140]);
	glVertex3fv(vertices[140]);
	glNormal3fv(normals[139]);
	glVertex3fv(vertices[139]);
	glNormal3fv(normals[109]);
	glVertex3fv(vertices[109]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[105]);
	glVertex3fv(vertices[105]);
	glNormal3fv(normals[138]);
	glVertex3fv(vertices[138]);
	glNormal3fv(normals[137]);
	glVertex3fv(vertices[137]);
	glNormal3fv(normals[93]);
	glVertex3fv(vertices[93]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[113]);
	glVertex3fv(vertices[113]);
	glNormal3fv(normals[109]);
	glVertex3fv(vertices[109]);
	glNormal3fv(normals[139]);
	glVertex3fv(vertices[139]);
	glNormal3fv(normals[138]);
	glVertex3fv(vertices[138]);
	glNormal3fv(normals[105]);
	glVertex3fv(vertices[105]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[138]);
	glVertex3fv(vertices[138]);
	glNormal3fv(normals[139]);
	glVertex3fv(vertices[139]);
	glNormal3fv(normals[140]);
	glVertex3fv(vertices[140]);
	glNormal3fv(normals[137]);
	glVertex3fv(vertices[137]);
glEnd();
}
} //namespace
