/******************************************************************************

	sock.h -- create and handle listening network sockets
	Copyright (C) 2004  Wessel Dankers <wsl@uvt.nl>

	This program is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program.  If not, see <http://www.gnu.org/licenses/>.

	$Id: sock.h 223 2011-12-02 10:53:44Z wsl $
	$URL: https://svn.fair.uvt.nl/branches/0.5/src/sock.h $

******************************************************************************/

#ifndef SOCK_H
#define SOCK_H

#include <sys/socket.h>
#include <avl.h>

#include "fd.h"

typedef void (*accept_hook_t)(void *, int, const struct sockaddr *, socklen_t);

typedef struct listener {
	avl_node_t node;
	avl_tree_t fds;
	accept_hook_t func;
	void *data;
} listener_t;

extern unsigned int listener_count(void);
extern const char *listener_new_tcp(const char *, accept_hook_t, void *);
extern const char *listener_new_udp(const char *, fd_hook_t, void *);
extern void listener_delete(listener_t *);

#endif
