/*
 * $Id: arch_ide_disk_gui.c,v 1.7 2012-02-22 09:27:19 siflkres Exp $
 *
 * Copyright (C) 2003-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include "config.h"

#include <assert.h>
#include <stdio.h>

#include "glue-gui.h"

#include "arch_ide_disk_gui.h"

#ifdef HAVE_GTK
#include "ide_gen_disk_gui_gtk.h"
#endif

void *
NAME_(gui_create)(
	unsigned int page,
	const char *name,
	const char *image,
#ifndef CYLINDERS
	const char *cylinders,
	const char *heads,
	const char *sectors,
#endif
	const char *unit,
#ifndef CYLINDERS
	const char *size,
#endif
	struct sig_manage *port_manage,
	struct sig_power_device *port_power,
	struct sig_ide_bus *port_ide
)
{
#ifdef CYLINDERS
	char cylinders[20];
	char heads[20];
	char sectors[20];
	char size[20];

	sprintf(cylinders, "%u", CYLINDERS);
	sprintf(heads, "%u", HEADS);
	sprintf(sectors, "%u", SECTORS);
	sprintf(size, "%u", LINEAR);
#endif

	switch (selected_gui) {
#ifdef HAVE_GTK
	case GUI_GTK:
		return ide_gen_disk_gui_gtk_create(page, name,
				image,
				cylinders, heads, sectors, unit, size,
				port_manage, port_power, port_ide);
		break;
#endif
	case GUI_NULL:
		return (void *) 1;
	default:
		assert(0);
	}

}

void
NAME_(gui_destroy)(void *_cpssp)
{
	switch (selected_gui) {
#ifdef HAVE_GTK
	case GUI_GTK:
		return ide_gen_disk_gui_gtk_destroy(_cpssp);
		break;
#endif
	case GUI_NULL:
		break;
	default:
		assert(0);
	}
}

void
NAME_(gui_suspend)(void *_cpssp, FILE *fComp)
{
	switch (selected_gui) {
#ifdef HAVE_GTK
	case GUI_GTK:
		ide_gen_disk_gui_gtk_suspend(_cpssp, fComp);
		break;
#endif
	case GUI_NULL:
		break;
	default:
		assert(0);
	}
}

void
NAME_(gui_resume)(void *_cpssp, FILE *fComp)
{
	switch (selected_gui) {
#ifdef HAVE_GTK
	case GUI_GTK:
		ide_gen_disk_gui_gtk_resume(_cpssp, fComp);
		break;
#endif
	case GUI_NULL:
		break;
	default:
		assert(0);
	}
}
