/*
 * Decompiled with CFR 0.152.
 */
package loci.formats;

import java.awt.image.BufferedImage;
import java.io.IOException;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.IFormatReader;
import loci.formats.ImageTools;
import loci.formats.ReaderWrapper;

public class ChannelMerger
extends ReaderWrapper {
    public ChannelMerger() {
    }

    public ChannelMerger(IFormatReader r) {
        super(r);
    }

    public boolean canMerge() {
        int c = this.getSizeC();
        return c > 1 && c <= 4 && !this.reader.isRGB() && !this.reader.isIndexed();
    }

    public int getImageCount() {
        FormatTools.assertId(this.getCurrentFile(), true, 2);
        int no = this.reader.getImageCount();
        if (this.canMerge()) {
            no /= this.getSizeC();
        }
        return no;
    }

    public String getDimensionOrder() {
        FormatTools.assertId(this.getCurrentFile(), true, 2);
        String order = this.reader.getDimensionOrder();
        if (this.canMerge()) {
            StringBuffer sb = new StringBuffer(order);
            while (order.indexOf("C") != 2) {
                char pre = order.charAt(order.indexOf("C") - 1);
                sb.setCharAt(order.indexOf("C"), pre);
                sb.setCharAt(order.indexOf(pre), 'C');
                order = sb.toString();
            }
        }
        return order;
    }

    public boolean isRGB() {
        FormatTools.assertId(this.getCurrentFile(), true, 2);
        return this.canMerge() || this.reader.isRGB();
    }

    public BufferedImage openImage(int no) throws FormatException, IOException {
        FormatTools.assertId(this.getCurrentFile(), true, 2);
        if (!this.canMerge()) {
            return super.openImage(no);
        }
        int sizeC = this.getSizeC();
        int[] nos = this.getZCTCoords(no);
        int z = nos[0];
        int t = nos[2];
        String order = this.reader.getDimensionOrder();
        int ic = order.indexOf("C") - 2;
        if (ic < 0 || ic > 2) {
            throw new FormatException("Invalid dimension order: " + order);
        }
        BufferedImage[] img = new BufferedImage[sizeC];
        for (int c = 0; c < sizeC; ++c) {
            img[c] = this.reader.openImage(this.reader.getIndex(z, c, t));
        }
        return ImageTools.mergeChannels(img);
    }

    public byte[] openBytes(int no) throws FormatException, IOException {
        FormatTools.assertId(this.getCurrentFile(), true, 2);
        if (!this.canMerge()) {
            return super.openBytes(no);
        }
        int sizeC = this.getSizeC();
        int[] nos = this.getZCTCoords(no);
        int z = nos[0];
        int t = nos[2];
        byte[] bytes = null;
        for (int c = 0; c < sizeC; ++c) {
            byte[] b = this.reader.openBytes(this.reader.getIndex(z, c, t));
            if (c == 0) {
                bytes = new byte[sizeC * b.length];
            }
            System.arraycopy(b, 0, bytes, c * b.length, b.length);
        }
        return bytes;
    }

    public BufferedImage openThumbImage(int no) throws FormatException, IOException {
        FormatTools.assertId(this.getCurrentFile(), true, 2);
        if (!this.canMerge()) {
            return super.openThumbImage(no);
        }
        return ImageTools.scale(this.openImage(no), this.getThumbSizeX(), this.getThumbSizeY(), true);
    }

    public int getIndex(int z, int c, int t) {
        return FormatTools.getIndex(this, z, c, t);
    }

    public int[] getZCTCoords(int index) {
        return FormatTools.getZCTCoords(this, index);
    }
}

