/*
 * Decompiled with CFR 0.152.
 */
package thredds.filesystem;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringBufferInputStream;
import java.util.Collections;
import java.util.Formatter;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import net.jcip.annotations.ThreadSafe;
import net.sf.ehcache.Cache;
import net.sf.ehcache.Element;
import net.sf.ehcache.Statistics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.filesystem.CacheDirectory;
import thredds.filesystem.CacheDirectoryProto;
import thredds.filesystem.CacheFile;
import thredds.filesystem.CacheFileProto;
import ucar.nc2.util.IO;
import ucar.unidata.util.StringUtil;

@ThreadSafe
public class CacheManager {
    private static Logger cacheLog = LoggerFactory.getLogger(CacheManager.class);
    private static net.sf.ehcache.CacheManager cacheManager;
    private static boolean debugConfig;
    private Cache cache;
    private AtomicLong addElements = new AtomicLong();
    private AtomicLong hits = new AtomicLong();
    private AtomicLong requests = new AtomicLong();
    private static String configReadOnly;
    private static String config;

    public static net.sf.ehcache.CacheManager getEhcache() {
        return cacheManager;
    }

    public static void makeStandardCacheManager(String configFile, String cacheDir) throws IOException {
        String config = IO.readFile(configFile);
        String configString = StringUtil.substitute(config, "${cacheDir}", cacheDir);
        cacheLog.info("thredds.filesystem.CacheManager configuraton " + configString);
        cacheManager = new net.sf.ehcache.CacheManager(new StringBufferInputStream(configString));
    }

    public static void makeTestCacheManager(String cacheDir) {
        String configString = StringUtil.substitute(config, "${cacheDir}", cacheDir);
        if (debugConfig) {
            System.out.printf("CacheManager test=%n %s %n", configString);
        }
        cacheManager = new net.sf.ehcache.CacheManager(new StringBufferInputStream(configString));
    }

    public static void makeReadOnlyCacheManager(String cacheDir, String cacheName) {
        String configString = StringUtil.substitute(configReadOnly, "${cacheDir}", cacheDir);
        configString = StringUtil.substitute(configString, "${cacheName}", cacheName);
        if (debugConfig) {
            System.out.printf("CacheManager readonly =%n %s %n", configString);
        }
        cacheManager = new net.sf.ehcache.CacheManager(new StringBufferInputStream(configString));
    }

    public static void shutdown() {
        if (cacheManager != null) {
            cacheLog.info("thredds.filesystem.CacheManager shutdown");
            cacheManager.shutdown();
        }
        cacheManager = null;
    }

    public CacheManager(String cacheName) {
        this.cache = cacheManager.getCache(cacheName);
        cacheLog.info("thredds.filesystem.CacheManager " + this.cache);
        cacheLog.info("thredds.filesystem.CacheManager " + this.cache.getStatistics().toString());
    }

    public void add(Serializable path, Serializable value) {
        if (this.cache == null) {
            return;
        }
        this.cache.put(new Element(path, value));
        this.addElements.incrementAndGet();
    }

    public static String show(String cacheName) {
        if (cacheManager == null) {
            return "no cacheManager set";
        }
        Cache cache = cacheManager.getCache(cacheName);
        if (cache == null) {
            return "no cache named " + cacheName;
        }
        Formatter f = new Formatter();
        f.format("Cache %s%n %s%n", cache, cache.getStatistics().toString());
        return f.toString();
    }

    public CacheDirectory get(String path, boolean recheck) {
        File p;
        this.requests.incrementAndGet();
        Element e = this.cache.get((Serializable)((Object)path));
        if (e != null) {
            boolean modified;
            if (cacheLog.isDebugEnabled()) {
                cacheLog.debug("thredds.filesystem.CacheManager found in cache; path =" + path);
            }
            CacheDirectory m = (CacheDirectory)e.getValue();
            if (!recheck) {
                return m;
            }
            File f = new File(m.getPath());
            if (!f.exists()) {
                this.cache.put(new Element((Serializable)((Object)path), null));
                return null;
            }
            boolean bl = modified = f.lastModified() > m.lastModified;
            if (cacheLog.isDebugEnabled()) {
                cacheLog.debug("thredds.filesystem.CacheManager modified diff = " + (f.lastModified() - m.lastModified) + "; path=" + path);
            }
            if (!modified) {
                this.hits.incrementAndGet();
                return m;
            }
            this.cache.put(new Element((Serializable)((Object)path), null));
        }
        if (!(p = new File(path)).exists()) {
            return null;
        }
        if (cacheLog.isDebugEnabled()) {
            cacheLog.debug("thredds.filesystem.CacheManager read from filesystem; path=" + path);
        }
        CacheDirectory m = new CacheDirectory(p);
        this.add((Serializable)((Object)path), m);
        return m;
    }

    public void close() {
        if (cacheManager != null) {
            cacheLog.info("thredds.filesystem.CacheManager shutdown");
            cacheManager.shutdown();
        }
        cacheManager = null;
    }

    public void showKeys() {
        List keys = this.cache.getKeys();
        Collections.sort(keys);
        for (Object key : keys) {
            Element elem = this.cache.get(key);
            System.out.printf(" %40s == %s%n", key, elem);
        }
    }

    public void stats() {
        System.out.printf(" elems added= %s%n", this.addElements.get());
        System.out.printf(" reqs= %d%n", this.requests.get());
        System.out.printf(" hits= %d%n", this.hits.get());
        if (this.cache != null) {
            System.out.printf(" cache= %s%n", this.cache.toString());
            System.out.printf(" cache.size= %d%n", this.cache.getSize());
            System.out.printf(" cache.memorySize= %d%n", this.cache.getMemoryStoreSize());
            Statistics stats = this.cache.getStatistics();
            System.out.printf(" stats= %s%n", stats.toString());
        }
    }

    public void populateFiles(String root) {
        long startCount = this.addElements.get();
        long start = System.nanoTime();
        this.addRecursiveFiles(new File(root));
        long end = System.nanoTime();
        long total = this.addElements.get() - startCount;
        System.out.printf("populate %n%-20s total %d took %d msecs %n", root, total, (end - start) / 1000L / 1000L);
    }

    private void addRecursiveFiles(File dir) {
        for (File f : dir.listFiles()) {
            if (f.isDirectory()) {
                this.addRecursiveFiles(f);
                continue;
            }
            this.add((Serializable)((Object)f.getPath()), new CacheFile(f));
        }
    }

    public void populateFilesProto(String root) {
        long startCount = this.addElements.get();
        long start = System.nanoTime();
        this.addRecursiveFilesProto(new File(root));
        long end = System.nanoTime();
        long total = this.addElements.get() - startCount;
        System.out.printf("populate %n%-20s total %d took %d msecs %n", root, total, (end - start) / 1000L / 1000L);
    }

    private void addRecursiveFilesProto(File dir) {
        for (File f : dir.listFiles()) {
            if (f.isDirectory()) {
                this.addRecursiveFilesProto(f);
                continue;
            }
            this.add((Serializable)((Object)f.getPath()), new CacheFileProto(f));
        }
    }

    public void populateDirs(String root) {
        long startCount = this.addElements.get();
        long start = System.nanoTime();
        this.addRecursiveDirs(new File(root));
        long end = System.nanoTime();
        long total = this.addElements.get() - startCount;
        System.out.printf("populate %n%-20s total %d took %d msecs %n", root, total, (end - start) / 1000L / 1000L);
    }

    private void addRecursiveDirs(File dir) {
        this.add((Serializable)((Object)dir.getPath()), new CacheDirectory(dir));
        for (File f : dir.listFiles()) {
            if (!f.isDirectory()) continue;
            this.addRecursiveDirs(f);
        }
    }

    public void populateDirsProto(String root) {
        long startCount = this.addElements.get();
        long start = System.nanoTime();
        this.addRecursiveDirsProto(new File(root));
        long end = System.nanoTime();
        long total = this.addElements.get() - startCount;
        System.out.printf("populate %n%-20s total %d took %d msecs %n", root, total, (end - start) / 1000L / 1000L);
    }

    private void addRecursiveDirsProto(File dir) {
        this.add((Serializable)((Object)dir.getPath()), new CacheDirectoryProto(dir));
        for (File f : dir.listFiles()) {
            if (!f.isDirectory()) continue;
            this.addRecursiveDirsProto(f);
        }
    }

    public static void main(String[] args) throws IOException {
        CacheManager.makeTestCacheManager("C:/data/ehcache/");
        System.out.printf("=====================%n", new Object[0]);
        CacheManager dirProto = new CacheManager("dirsProto");
        dirProto.populateDirsProto("C:/data/");
        dirProto.stats();
        CacheManager.shutdown();
        Formatter f = new Formatter(System.out);
        f.format(" Proto count = %d size = %d %n", CacheFileProto.countWrite, CacheFileProto.countWriteSize);
        int avg = CacheFileProto.countWrite == 0 ? 0 : CacheFileProto.countWriteSize / CacheFileProto.countWrite;
        f.format("       avg = %d %n", avg);
        f.flush();
    }

    static {
        debugConfig = false;
        configReadOnly = "<ehcache>\n    <diskStore path='${cacheDir}' />\n    <defaultCache\n              maxElementsInMemory='10000'\n              eternal='false'\n              timeToIdleSeconds='120'\n              timeToLiveSeconds='120'\n              overflowToDisk='true'\n              maxElementsOnDisk='10000000'\n              diskPersistent='false'\n              diskExpiryThreadIntervalSeconds='120'\n              memoryStoreEvictionPolicy='LRU'\n              />\n    <cache name='${cacheName}'\n            maxElementsInMemory='10000'\n            eternal='false'\n            timeToIdleSeconds='864000'\n            timeToLiveSeconds='0'\n            overflowToDisk='true'\n            maxElementsOnDisk='100000'\n            diskPersistent='true'\n            diskExpiryThreadIntervalSeconds='3600'\n            memoryStoreEvictionPolicy='LRU'\n            />\n</ehcache>";
        config = "<ehcache>\n    <diskStore path='${cacheDir}' />\n    <defaultCache\n              maxElementsInMemory='10000'\n              eternal='false'\n              timeToIdleSeconds='120'\n              timeToLiveSeconds='120'\n              overflowToDisk='true'\n              maxElementsOnDisk='10000000'\n              diskPersistent='false'\n              diskExpiryThreadIntervalSeconds='120'\n              memoryStoreEvictionPolicy='LRU'\n              />\n    <cache name='directories'\n            maxElementsInMemory='1000'\n            eternal='true'\n            timeToIdleSeconds='864000'\n            timeToLiveSeconds='0'\n            overflowToDisk='true'\n            maxElementsOnDisk='0'\n            diskPersistent='true'\n            diskExpiryThreadIntervalSeconds='3600'\n            memoryStoreEvictionPolicy='LRU'\n            />\n    <cache name='files'\n            maxElementsInMemory='1000'\n            eternal='true'\n            timeToIdleSeconds='864000'\n            timeToLiveSeconds='0'\n            overflowToDisk='true'\n            maxElementsOnDisk='0'\n            diskPersistent='true'\n            diskExpiryThreadIntervalSeconds='3600'\n            memoryStoreEvictionPolicy='LRU'\n            />\n    <cache name='filesProto'\n            maxElementsInMemory='1000'\n            eternal='true'\n            timeToIdleSeconds='864000'\n            timeToLiveSeconds='0'\n            overflowToDisk='true'\n            maxElementsOnDisk='0'\n            diskPersistent='true'\n            diskExpiryThreadIntervalSeconds='3600'\n            memoryStoreEvictionPolicy='LRU'\n            />\n    <cache name='dirsProto'\n            maxElementsInMemory='1000'\n            eternal='true'\n            timeToIdleSeconds='864000'\n            timeToLiveSeconds='0'\n            overflowToDisk='true'\n            maxElementsOnDisk='0'\n            diskPersistent='true'\n            diskExpiryThreadIntervalSeconds='3600'\n            memoryStoreEvictionPolicy='LRU'\n            />\n</ehcache>";
    }
}

