/*
 * Decompiled with CFR 0.152.
 */
package visad;

import visad.CommonUnit;
import visad.CoordinateSystem;
import visad.CoordinateSystemException;
import visad.Display;
import visad.DisplayRealType;
import visad.RealTupleType;
import visad.RealType;
import visad.Unit;
import visad.UnitException;
import visad.VisADException;

public class DisplayTupleType
extends RealTupleType {
    public DisplayTupleType(DisplayRealType[] types) throws VisADException {
        this(types, null);
    }

    public DisplayTupleType(DisplayRealType[] types, CoordinateSystem coord_sys) throws VisADException {
        super((RealType[])types, coord_sys, null);
        if (coord_sys != null) {
            RealTupleType ref = coord_sys.getReference();
            if (!(ref instanceof DisplayTupleType)) {
                throw new CoordinateSystemException("DisplayTupleType: CoordinateSystem.Reference must be a DisplayTupleType");
            }
            if (Display.DisplaySpatialOffsetTuple.equals(ref)) {
                throw new CoordinateSystemException("DisplayTupleType: CoordinateSystem.Reference cannot be DisplaySpatialOffsetTuple");
            }
            Unit[] default_units = this.getDefaultUnits();
            Unit[] coord_sys_units = coord_sys.getCoordinateSystemUnits();
            int n = default_units.length;
            boolean match = true;
            for (int i = 0; i < n; ++i) {
                if (default_units[i] == null) {
                    if (coord_sys_units[i] == null) continue;
                    match = false;
                    continue;
                }
                if (default_units[i].equals(coord_sys_units[i])) continue;
                match = false;
            }
            if (!match) {
                throw new UnitException("RealTupleType: CoordinateSystem Units must equal default Units");
            }
        }
        this.setTuples(types, coord_sys);
    }

    DisplayTupleType(DisplayRealType[] types, boolean b) {
        this(types, (CoordinateSystem)null, b);
    }

    DisplayTupleType(DisplayRealType[] types, CoordinateSystem coord_sys, boolean b) {
        super((RealType[])types, coord_sys, b);
        try {
            this.setTuples(types, coord_sys);
        }
        catch (VisADException e) {
            System.out.println(e);
        }
    }

    private void setTuples(DisplayRealType[] types, CoordinateSystem coord_sys) throws VisADException {
        int i;
        int n = types.length;
        boolean[] circulars = new boolean[n];
        for (i = 0; i < n; ++i) {
            circulars[i] = false;
        }
        if (coord_sys != null && coord_sys.getReference().equals(Display.DisplaySpatialCartesianTuple)) {
            int i2;
            double[] defaults = new double[n];
            for (i2 = 0; i2 < n; ++i2) {
                defaults[i2] = types[i2].getDefaultValue();
            }
            block2: for (i2 = 0; i2 < n; ++i2) {
                Unit u = types[i2].getDefaultUnit();
                if (u == null || !Unit.canConvert(CommonUnit.degree, u)) continue;
                double[][] test = new double[n][37];
                for (int j = 0; j < n; ++j) {
                    int k;
                    if (j == i2) {
                        for (k = 0; k < 37; ++k) {
                            test[j][k] = u.toThis(10.0 * (double)k, CommonUnit.degree);
                        }
                        continue;
                    }
                    for (k = 0; k < 37; ++k) {
                        test[j][k] = defaults[j];
                    }
                }
                double[][] tt = coord_sys.toReference(test);
                double diff180 = Math.sqrt((tt[0][18] - tt[0][0]) * (tt[0][18] - tt[0][0]) + (tt[1][18] - tt[1][0]) * (tt[1][18] - tt[1][0]) + (tt[2][18] - tt[2][0]) * (tt[2][18] - tt[2][0]));
                double diff360 = Math.sqrt((tt[0][36] - tt[0][0]) * (tt[0][36] - tt[0][0]) + (tt[1][36] - tt[1][0]) * (tt[1][36] - tt[1][0]) + (tt[2][36] - tt[2][0]) * (tt[2][36] - tt[2][0]));
                if (!(diff360 < 0.01 * diff180)) continue;
                circulars[i2] = true;
                double diff0 = 0.0;
                double difflast = 0.0;
                for (int k = 0; k < 37; ++k) {
                    if (k == 36) {
                        if (!(difflast < 0.1 * diff0) && !(diff0 < 0.1 * difflast)) continue;
                        circulars[i2] = false;
                        continue block2;
                    }
                    double diff = Math.sqrt((tt[0][k + 1] - tt[0][k]) * (tt[0][k + 1] - tt[0][k]) + (tt[1][k + 1] - tt[1][k]) * (tt[1][k + 1] - tt[1][k]) + (tt[2][k + 1] - tt[2][k]) * (tt[2][k + 1] - tt[2][k]));
                    if (k == 0) {
                        diff0 = diff;
                    } else if (difflast < 0.1 * diff || diff < 0.1 * difflast) {
                        circulars[i2] = false;
                        continue block2;
                    }
                    difflast = diff;
                }
            }
        }
        for (i = 0; i < n; ++i) {
            types[i].setTuple(this, i, circulars[i]);
        }
    }
}

