/*
 * Decompiled with CFR 0.152.
 */
package visad.data.visad.object;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.IOException;
import visad.MathType;
import visad.SampledSet;
import visad.SetType;
import visad.UnionSet;
import visad.VisADException;
import visad.data.visad.BinaryObjectCache;
import visad.data.visad.BinaryReader;
import visad.data.visad.BinaryWriter;
import visad.data.visad.Saveable;
import visad.data.visad.object.BinaryGeneric;
import visad.data.visad.object.BinaryObject;
import visad.data.visad.object.BinarySampledSet;
import visad.data.visad.object.BinarySetType;
import visad.data.visad.object.BinaryUnknown;

public class BinaryUnionSet
implements BinaryObject {
    public static final int computeBytes(SampledSet[] sets) {
        int setsLen = 5;
        for (int i = 0; i < sets.length; ++i) {
            int len = BinaryGeneric.computeBytes(sets[i]);
            if (len < 0) {
                return -1;
            }
            setsLen += len;
        }
        return 10 + BinarySampledSet.computeBytes(sets) + 1;
    }

    public static final UnionSet read(BinaryReader reader) throws IOException, VisADException {
        BinaryObjectCache cache = reader.getTypeCache();
        DataInput file = reader.getInput();
        int typeIndex = file.readInt();
        SetType st = (SetType)cache.get(typeIndex);
        SampledSet[] sets = null;
        boolean reading = true;
        block6: while (reading) {
            byte directive;
            try {
                directive = file.readByte();
            }
            catch (EOFException eofe) {
                return null;
            }
            switch (directive) {
                case 11: {
                    sets = BinarySampledSet.readList(reader);
                    continue block6;
                }
                case 80: {
                    reading = false;
                    continue block6;
                }
            }
            throw new IOException("Unknown UnionSet directive " + directive);
        }
        if (st == null) {
            throw new IOException("No SetType found for UnionSet");
        }
        if (sets == null) {
            throw new IOException("No sets found for UnionSet");
        }
        return new UnionSet((MathType)st, sets);
    }

    public static final void writeDependentData(BinaryWriter writer, SetType type, SampledSet[] sets, UnionSet set, Object token) throws IOException {
        if (!(set.getClass().equals(UnionSet.class) || set instanceof UnionSet && set instanceof Saveable)) {
            return;
        }
        Object dependToken = token == SAVE_DEPEND_BIG ? token : SAVE_DEPEND;
        BinarySetType.write(writer, type, set, SAVE_DATA);
        if (sets != null) {
            for (int i = 0; i < sets.length; ++i) {
                BinaryGeneric.write(writer, sets[i], dependToken);
            }
        }
    }

    public static final void write(BinaryWriter writer, SetType type, SampledSet[] sets, UnionSet set, Object token) throws IOException {
        BinaryUnionSet.writeDependentData(writer, type, sets, set, token);
        if (token == SAVE_DEPEND || token == SAVE_DEPEND_BIG) {
            return;
        }
        if (!(set.getClass().equals(UnionSet.class) || set instanceof UnionSet && set instanceof Saveable)) {
            BinaryUnknown.write(writer, set, token);
            return;
        }
        int typeIndex = writer.getTypeCache().getIndex(type);
        if (typeIndex < 0) {
            throw new IOException("SetType " + type + " not cached");
        }
        int objLen = BinaryUnionSet.computeBytes(sets);
        DataOutput file = writer.getOutput();
        file.writeByte(2);
        file.writeInt(objLen);
        file.writeByte(37);
        file.writeInt(typeIndex);
        BinarySampledSet.writeList(writer, sets, token);
        file.writeByte(80);
    }
}

