/*
 * Decompiled with CFR 0.152.
 */
package visad.java3d;

import java.util.Enumeration;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Point3f;
import visad.DataRenderer;
import visad.DisplayImpl;
import visad.MouseBehavior;
import visad.VisADException;
import visad.VisADRay;
import visad.java3d.ImmersaDeskDisplayRendererJ3D;
import visad.java3d.MouseBehaviorJ3D;
import visad.java3d.TrackdJNI;

public class WandBehaviorJ3D
extends MouseBehaviorJ3D
implements Runnable,
MouseBehavior {
    ImmersaDeskDisplayRendererJ3D display_renderer;
    DisplayImpl display;
    private Thread wandThread;
    private TransformGroup vpTrans;
    private Transform3D init_trans;
    private float[] head_position = new float[3];
    private float[] wand_position = new float[3];
    private float[] wand_vector = new float[3];
    private float[] travel_position = new float[3];
    private boolean left = false;
    private boolean center = false;
    private boolean right = false;
    private boolean last_right;
    private DataRenderer direct_renderer = null;
    private TrackdJNI hack;
    private static int DELAY = 50;
    private static int NSENSORS = 4;
    private static int NBUTTONS = 3;
    private static int HEAD = 0;
    private static int WAND = 1;
    private static int LEFT = 0;
    private static int CENTER = 1;
    private static int RIGHT = 2;
    private static int ELEVATION = 0;
    private static int AZIMUTH = 1;
    private static int ROLL = 2;
    private float TRAVEL_SPEED = 4.0f;
    private float HEAD_SCALE = 0.1f;
    private float WAND_SCALE = 1.5f;
    private float HEADX_OFFSET = 0.0f;
    private float HEADY_OFFSET = -3.0f;
    private float HEADZ_OFFSET = 5.0f;
    private float WANDX_OFFSET = -0.5f;
    private float WANDY_OFFSET = -2.0f;
    private float WANDZ_OFFSET = 0.0f;
    private float RAY_LENGTH = 2.0f;

    public WandBehaviorJ3D(ImmersaDeskDisplayRendererJ3D r, int tracker_shmkey, int controller_shmkey) throws VisADException {
        this.display_renderer = r;
        this.display = this.display_renderer.getDisplay();
        this.hack = new TrackdJNI(tracker_shmkey, controller_shmkey);
        this.last_right = false;
    }

    public void initialize() {
        this.wandThread = new Thread(this);
        this.wandThread.start();
        this.vpTrans = this.display_renderer.getViewTrans();
        this.init_trans = new Transform3D();
        this.vpTrans.getTransform(this.init_trans);
    }

    public void processStimulus(Enumeration criteria) {
    }

    public void stop() {
        this.wandThread = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Thread me = Thread.currentThread();
        int[] number_of_sensors = new int[1];
        float[] sensor_positions = new float[NSENSORS * 3];
        float[] sensor_angles = new float[NSENSORS * 3];
        float[] sensor_matrices = new float[NSENSORS * 4 * 4];
        int[] number_of_buttons = new int[1];
        int[] button_states = new int[NBUTTONS];
        int nprint = 1000 / DELAY;
        this.travel_position[0] = 0.0f;
        this.travel_position[1] = 0.0f;
        this.travel_position[2] = 0.0f;
        while (this.wandThread == me) {
            try {
                WandBehaviorJ3D wandBehaviorJ3D = this;
                synchronized (wandBehaviorJ3D) {
                    this.wait(DELAY);
                }
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            number_of_sensors[0] = NSENSORS;
            number_of_buttons[0] = NBUTTONS;
            this.hack.getTrackd(number_of_sensors, sensor_positions, sensor_angles, sensor_matrices, number_of_buttons, button_states);
            this.last_right = this.right;
            this.left = button_states[LEFT] != 0;
            this.center = button_states[CENTER] != 0;
            this.right = button_states[RIGHT] != 0;
            this.head_position[0] = sensor_positions[3 * HEAD];
            this.head_position[1] = sensor_positions[3 * HEAD + 1];
            this.head_position[2] = sensor_positions[3 * HEAD + 2];
            this.wand_position[0] = sensor_positions[3 * WAND];
            this.wand_position[1] = sensor_positions[3 * WAND + 1];
            this.wand_position[2] = sensor_positions[3 * WAND + 2];
            float elevation = (float)((double)sensor_angles[3 * WAND + ELEVATION] * (Math.PI / 180));
            float azimuth = (float)((double)sensor_angles[3 * WAND + AZIMUTH] * (Math.PI / 180));
            float roll = (float)((double)sensor_angles[3 * WAND + ROLL] * (Math.PI / 180));
            float x = 0.0f;
            float y = 0.0f;
            float z = -1.0f;
            float xx = x;
            float yy = (float)(Math.cos(elevation) * (double)y - Math.sin(elevation) * (double)z);
            float zz = (float)(Math.cos(elevation) * (double)z + Math.sin(elevation) * (double)y);
            x = (float)(Math.cos(azimuth) * (double)xx + Math.sin(azimuth) * (double)zz);
            y = yy;
            z = (float)(Math.cos(azimuth) * (double)zz - Math.sin(azimuth) * (double)xx);
            this.wand_vector[0] = x;
            this.wand_vector[1] = y;
            this.wand_vector[2] = z;
            if (this.left) {
                float increment = this.TRAVEL_SPEED * (float)DELAY / 1000.0f;
                this.travel_position[0] = this.travel_position[0] + increment * this.wand_vector[0];
                this.travel_position[1] = this.travel_position[1] + increment * this.wand_vector[1];
                this.travel_position[2] = this.travel_position[2] + increment * this.wand_vector[2];
            }
            double headx = this.HEAD_SCALE * (this.head_position[0] + this.travel_position[0] + this.HEADX_OFFSET);
            double heady = this.HEAD_SCALE * (this.head_position[1] + this.travel_position[1] + this.HEADY_OFFSET);
            double headz = this.HEAD_SCALE * (this.head_position[2] + this.travel_position[2] + this.HEADZ_OFFSET);
            double[] matrix = MouseBehaviorJ3D.static_make_matrix(0.0, 0.0, 0.0, 1.0, headx, heady, headz);
            Transform3D temp = new Transform3D(this.init_trans);
            Transform3D tm = new Transform3D(matrix);
            temp.mul(tm);
            this.vpTrans.setTransform(temp);
            Transform3D t3d = new Transform3D();
            this.display_renderer.getTrans().getTransform(t3d);
            float wandx = this.WAND_SCALE * (this.wand_position[0] + this.travel_position[0] + this.WANDX_OFFSET);
            float wandy = this.WAND_SCALE * (this.wand_position[1] + this.travel_position[1] + this.WANDY_OFFSET);
            float wandz = this.WAND_SCALE * (this.wand_position[2] + this.travel_position[2] + this.WANDZ_OFFSET);
            Point3f p3f = new Point3f(wandx, wandy, wandz);
            t3d.transform(p3f);
            wandx = p3f.x;
            wandy = p3f.y;
            wandz = p3f.z;
            this.display_renderer.setCursorOn(this.center);
            if (this.center) {
                this.display_renderer.setCursorLoc(wandx, wandy, wandz);
            }
            if (this.right && this.display_renderer.anyDirects()) {
                float wand_endx = wandx + this.WAND_SCALE * (this.RAY_LENGTH * this.wand_vector[0]);
                float wand_endy = wandy + this.WAND_SCALE * (this.RAY_LENGTH * this.wand_vector[1]);
                float wand_endz = wandz + this.WAND_SCALE * (this.RAY_LENGTH * this.wand_vector[2]);
                p3f = new Point3f(wand_endx, wand_endy, wand_endz);
                t3d.transform(p3f);
                wand_endx = p3f.x;
                wand_endy = p3f.y;
                wand_endz = p3f.z;
                float[] ray_verts = new float[]{wandx, wandy, wandz, wand_endx, wand_endy, wand_endz};
                this.display_renderer.setRayOn(true, ray_verts);
                VisADRay direct_ray = new VisADRay();
                direct_ray.position[0] = wandx;
                direct_ray.position[1] = wandy;
                direct_ray.position[2] = wandz;
                direct_ray.vector[0] = this.wand_vector[0];
                direct_ray.vector[1] = this.wand_vector[1];
                direct_ray.vector[2] = this.wand_vector[2];
                if (!this.last_right) {
                    this.direct_renderer = this.display_renderer.findDirect(direct_ray, 0);
                    if (this.direct_renderer == null) continue;
                    this.display_renderer.setDirectOn(true);
                    this.direct_renderer.drag_direct(direct_ray, true, 0);
                    continue;
                }
                if (this.direct_renderer == null) continue;
                this.direct_renderer.drag_direct(direct_ray, false, 0);
                continue;
            }
            this.display_renderer.setRayOn(false, null);
            this.direct_renderer = null;
        }
    }
}

