#!/usr/bin/env python

import sys

if not 1 < len(sys.argv) or int(sys.argv[1]) < 0:
    print 'Usage:', sys.argv[0], 'highest_signal_arity'
    sys.exit(1)

arity_to_generate = int(sys.argv[1])

for i in range(arity_to_generate + 1):
    filename = 'Signal' + str(i) + '.h'
    f = open(filename, 'w')
    f.write("""// -*- C++ -*-
/* GG is a GUI for SDL and OpenGL.
   Copyright (C) 2003-2008 T. Zachary Laine

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public License
   as published by the Free Software Foundation; either version 2.1
   of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
   02111-1307 USA

   If you do not wish to comply with the terms of the LGPL please
   contact the author as other terms are available for a fee.

   Zach Laine
   whatwasthataddress@gmail.com */

/* *** WARNING! ***
   This file is auto-generated by gen_signals.py.
   *** ALL CHANGES WILL BE LOST! *** */

""")
    sig_template_parms = ''
    sig_template_args = ''
    sig_parms = ''
    sig_args = ''
    bind_args = ''

    for j in range(i):
        sig_template_parms += (len(sig_template_parms) and ',' or '') + ' class A' + str(j + 1)
        sig_template_args += (len(sig_template_args) and ',' or '') + ' A' + str(j + 1)
        sig_parms += (len(sig_parms) and ',' or '') + ' A' + str(j + 1) + ' a' + str(j + 1)
        sig_args += (len(sig_args) and ',' or '') + ' a' + str(j + 1)
        bind_args += (len(bind_args) and ',' or '') + ' _' + str(j + 1)

    f.write('#define GG_SIGNALS_NUM_ARGS ' + str(i) + '\n')
    f.write('#define GG_SIGNALS_SIGNAL_TEMPLATE_PARMS' + sig_template_parms + '\n')
    f.write('#define GG_SIGNALS_SIGNAL_TEMPLATE_ARGS' + sig_template_args + '\n')
    f.write('#define GG_SIGNALS_SIGNAL_PARMS' + sig_parms + '\n')
    f.write('#define GG_SIGNALS_SIGNAL_ARGS' + sig_args + '\n')
    f.write('#define GG_SIGNALS_BIND_ARGS' + bind_args + '\n')
    f.write('\n')
    f.write('#include "SignalTemplate.h"' + '\n')
    f.write('\n')
    f.write('#undef GG_SIGNALS_NUM_ARGS' + '\n')
    f.write('#undef GG_SIGNALS_SIGNAL_TEMPLATE_PARMS' + '\n')
    f.write('#undef GG_SIGNALS_SIGNAL_TEMPLATE_ARGS' + '\n')
    f.write('#undef GG_SIGNALS_SIGNAL_PARMS' + '\n')
    f.write('#undef GG_SIGNALS_SIGNAL_ARGS' + '\n')
    f.write('#undef GG_SIGNALS_BIND_ARGS' + '\n')
