'''OpenGL extension NV.compute_program5

This module customises the behaviour of the 
OpenGL.raw.GL.NV.compute_program5 to provide a more 
Python-friendly API

Overview (from the spec)
	
	This extension builds on the ARB_compute_shader extension to provide new
	assembly compute program capability for OpenGL.  ARB_compute_shader adds
	the basic functionality, including the ability to dispatch compute work.
	This extension provides the ability to write a compute program in
	assembly, using the same basic syntax and capability set found in the
	NV_gpu_program4 and NV_gpu_program5 extensions.

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/NV/compute_program5.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
from OpenGL.GL import glget
import ctypes
from OpenGL.raw.GL import _types
from OpenGL.raw.GL.NV.compute_program5 import *
from OpenGL.raw.GL.NV.compute_program5 import _EXTENSION_NAME

def glInitComputeProgram5NV():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )

### END AUTOGENERATED SECTION