'''OpenGL extension ARB.shader_subroutine

This module customises the behaviour of the 
OpenGL.raw.GL.ARB.shader_subroutine to provide a more 
Python-friendly API

Overview (from the spec)
	
	This extension adds support to shaders for "indirect subroutine calls", 
	where a single shader can include many subroutines and dynamically select
	through the API which subroutine is called from each call site. 
	Switching subroutines dynamically in this fashion can avoid the cost of 
	recompiling and managing multiple shaders, while still retaining most of
	the performance of specialized shaders.

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/ARB/shader_subroutine.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
from OpenGL.GL import glget
import ctypes
from OpenGL.raw.GL import _types
from OpenGL.raw.GL.ARB.shader_subroutine import *
from OpenGL.raw.GL.ARB.shader_subroutine import _EXTENSION_NAME

def glInitShaderSubroutineARB():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )

### END AUTOGENERATED SECTION