#ifndef INCLUDED_PRECOMPOPTS_
#define INCLUDED_PRECOMPOPTS_

#include "../optbase/optbase.h"

    // OptBase provides PtrVect d_argv

class PreCompOpts: public OptBase
{
    char const *d_options;

    Action d_action;
    bool    d_preProcessed;

    StrVect d_define;
    StrVect d_eOptions;

    std::string d_scriptArg;                // -t's argument value

    public:
        PreCompOpts(PtrVect &argv, char const *options, Action type);  // 1.cc

        ~PreCompOpts() override;

        bool preProcessed() const;              // .f
        bool forced() const;                    // .f

        StrVect const &define() const;      // .f
        StrVect const &eOptions() const;    // .f

                                            // returns all d/e options 
                                            // each prefixed by ' '
        std::string defineStr() const;      // .f
        std::string eOptsStr() const;       // .f

        std::string const &scriptArg() const;       // .f
        void setScriptArg(std::string const &arg);  // .f

    private:
        void arguments(char const *options);

        void require(char const *option,                // may throw
                     std::string const &actions) const;

        static void mutuallyExclusive();                // throws
        static std::string catStr(StrVect const &strVect);
};

#include "precompopts.f"

#endif
