# SPDX-License-Identifier: Apache-2.0
# SPDX-FileCopyrightText: Zygmunt Krynicki
ROCKY_RELEASES += 9

.PHONY: all
all:: rocky-cloud-9.$(GARDEN_ARCH).qcow2 rocky-cloud-9.$(GARDEN_ARCH).run

.PHONY: fetch
fetch: $(GARDEN_DL_DIR)/rocky/Rocky-9-GenericCloud-Base.latest.$(GARDEN_ARCH).qcow2

$(GARDEN_DL_DIR)/rocky/Rocky-9-GenericCloud-Base.latest.x86_64.qcow2 $(GARDEN_DL_DIR)/rocky/Rocky-9-GenericCloud-Base.latest.aarch64.qcow2: $(GARDEN_DL_DIR)/rocky/Rocky-9-GenericCloud-Base.latest.%.qcow2  : | $(GARDEN_DL_DIR)/rocky
	$(strip $(WGET) \
		--no-clobber \
		--directory-prefix=$(firstword $|)/ \
		https://dl.rockylinux.org/pub/rocky/9/images/$*/Rocky-9-GenericCloud-Base.latest.$*.qcow2)

$(GARDEN_DL_DIR)/rocky/rocky-cloud-9.x86_64.qcow2: | $(GARDEN_DL_DIR)/rocky/ $(GARDEN_DL_DIR)/rocky/Rocky-9-GenericCloud-Base.latest.x86_64.qcow2
	ln -sf $(notdir $(word 2,$|)) $@

$(GARDEN_DL_DIR)/rocky/rocky-cloud-9.aarch64.qcow2: | $(GARDEN_DL_DIR)/rocky/ $(GARDEN_DL_DIR)/rocky/Rocky-9-GenericCloud-Base.latest.aarch64.qcow2
	ln -sf $(notdir $(word 2,$|)) $@

.PHONY: clean
clean::
	rm -f $(GARDEN_DL_DIR)/rocky/rocky-cloud-9.*.qcow2

.PHONY: distclean
distclean::
	rm -f $(GARDEN_DL_DIR)/rocky/Rocky-9-GenericCloud-Base.latest.*.qcow2

