/***************************************

  $Id: cm.h,v 1.3 2001/07/31 21:11:17 richard Exp $

  Header file for all local fns etc.


  ***************************************/

/**********************************************************************
 * Copyright (C) Richard P. Curnow  1998-2001
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of version 2 of the GNU General Public License as
 * published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 * 
 *********************************************************************/

#ifndef MTRAN_H
#define MTRAN_H    /*+ To stop multiple inclusions. +*/


#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#ifdef PLIST
#include <proplist.h>
#endif

#define new_string(s) strcpy((char *) malloc(1+strlen(s)), (s))
#define extend_string(s, x) strcat((char *) realloc(s, 1+strlen(s)+strlen(x)), x)
#define new(T) (T *) malloc(sizeof(T))
#define new_array(T, n) (T *) malloc(sizeof(T) * (n))

/* ================================================== */

typedef enum {
  OF_LATEX,
  OF_TEXT,
  OF_TEXTBLK
#ifdef PLIST
  ,OF_PLIST
#endif
} OutputFormat;

/*+ Flag indicating whether to generate latex blocked output instead
  of text. +*/
extern OutputFormat ofmt;

/*+ Line width to use +*/
extern int width;

/* ================================================== */

void gather_cmavo (const char *x);
void gather_brivla (const char *x);
void gather_cmene (const char *x);
void gather_whitespace(void); 
void gather_newline(void);
void gather_fallthru(const char *x);
void gather_paren(const char *x);
void do_trans(void);
void do_output(void);

char * translate(char *word);
char * translate_unknown(char *w);

void output(const char *lojban, const char *trans, const char *selmao);
void output_newline(void);
void output_paren(const char *text);
void start_output(void);
void end_output(void);

#endif /* MTRAN_H */
