/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/*
 * JSymphonicSettingsProfilePage.java
 *
 * Created on Jun 11, 2009, 10:03:38 PM
 */

package org.danizmax.jsymphonic.gui.settings;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import org.naurd.media.jsymphonic.device.sony.nw.NWGeneric;

/**
 *
 * @author danizmax
 */
public class SettingsProfilePage extends javax.swing.JPanel {

    private HashMap playerGenerations = NWGeneric.getGenerationMap();

    private Vector profiles;
    Vector localPaths;
    private ProfileElement currElement;
    private DefaultListModel localListmodel;

    private boolean profileModified = false;
    private int defaultProfile = 0;
    /** Creates new form JSymphonicSettingsProfilePage */
    public SettingsProfilePage(Vector profiles, int defaultProfile) {
        initComponents();
        this.defaultProfile = defaultProfile;
        localListmodel = (DefaultListModel) localPathsList.getModel();
        
        // Remove any item
        ((DefaultComboBoxModel)generationComboBox.getModel()).removeAllElements();

        // Add an entry for each generation available
        List<Integer> generationList = new ArrayList(playerGenerations.values());
        Collections.sort(generationList); // Sort element to display generation in ascending order
        Iterator it = generationList.iterator();
        while(it.hasNext()){
            generationComboBox.addItem(it.next());
        }

        setProfileModified(false);

        ((DefaultComboBoxModel)profileNameComboBox.getModel()).removeAllElements();
        if(profiles != null){
            this.profiles = profiles;
            it = this.profiles.iterator();
            while(it.hasNext()){
                profileNameComboBox.addItem(((ProfileElement)it.next()).getName());
            }

        }else{
            this.setEnabled(false);
        }

        updateGUIData();
        //setPageEnabled(profileNameComboBox.getItemCount()>0);
    }

    private void updateGUIData(){
        if(currElement != null){
            setPageEnabled(true);
            devPathLabelData.setText(currElement.getDevicePath());
            exportPathLabelData.setText(currElement.getExportPath());
            exportCheckBox.setSelected(currElement.isExportSameAsLocalPath());
            exportPathLabelData.setEnabled(!exportCheckBox.isSelected());
            exportBrowsButton.setEnabled(!exportCheckBox.isSelected());
            tempPathLabelData.setText(currElement.getTempPath());
            tempCheckBox.setSelected(currElement.isTempSameAsDevicePath());
            tempPathLabelData.setEnabled(!tempCheckBox.isSelected());
            tempBrowsButton.setEnabled(!tempCheckBox.isSelected());

            if(profileNameComboBox.getSelectedIndex() == getDefaultProfile()){
                defaultToggleButton.setEnabled(false);
                defaultToggleButton.setSelected(true);
            }else{
                defaultToggleButton.setEnabled(true);
                defaultToggleButton.setSelected(false);
            }

            Vector localPaths = currElement.getLocalPaths();
            Iterator it = localPaths.iterator();
            localListmodel.clear();

            while(it.hasNext()){
                localListmodel.addElement(it.next());
            }

            generationComboBox.setSelectedIndex(currElement.getDeviceGeneration());
        }else{
            setPageEnabled(false);
        }
        setProfileModified(false);
    }

    private void setPageEnabled(boolean enabled){
        removeProfileButton.setEnabled(enabled);
        defaultToggleButton.setEnabled(enabled);

        devPathLabelData.setEnabled(enabled);
        deviceBrowsButton.setEnabled(enabled);

        exportPathLabelData.setEnabled(enabled);
        exportCheckBox.setEnabled(enabled);
        exportBrowsButton.setEnabled(enabled);

        tempPathLabelData.setEnabled(enabled);
        tempCheckBox.setEnabled(enabled);
        tempBrowsButton.setEnabled(enabled);

        addLocalPathButton.setEnabled(enabled);
        removeLocalPathButton.setEnabled(enabled);
        localPathsList.setEnabled(enabled);

        generationComboBox.setEnabled(enabled);
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        profileNameComboBox = new javax.swing.JComboBox();
        removeProfileButton = new javax.swing.JButton();
        devPathLabel = new javax.swing.JLabel();
        devPathLabelData = new javax.swing.JLabel();
        deviceBrowsButton = new javax.swing.JButton();
        exportPathLabel = new javax.swing.JLabel();
        exportPathLabelData = new javax.swing.JLabel();
        exportBrowsButton = new javax.swing.JButton();
        tempBrowsButton = new javax.swing.JButton();
        addLocalPathButton = new javax.swing.JButton();
        tempPathLabelData = new javax.swing.JLabel();
        LocalPathLabel = new javax.swing.JLabel();
        tempPathLabel = new javax.swing.JLabel();
        exportCheckBox = new javax.swing.JCheckBox();
        tempCheckBox = new javax.swing.JCheckBox();
        jScrollPane1 = new javax.swing.JScrollPane();
        localPathsList = new javax.swing.JList();
        removeLocalPathButton = new javax.swing.JButton();
        deviceGenLabel = new javax.swing.JLabel();
        generationComboBox = new javax.swing.JComboBox();
        jSeparator1 = new javax.swing.JSeparator();
        jSeparator2 = new javax.swing.JSeparator();
        jSeparator3 = new javax.swing.JSeparator();
        jSeparator4 = new javax.swing.JSeparator();
        addProfileButton = new javax.swing.JButton();
        saveProfileButton = new javax.swing.JButton();
        defaultToggleButton = new javax.swing.JToggleButton();

        profileNameComboBox.setFont(new java.awt.Font("Dialog", 0, 12));
        profileNameComboBox.setModel(new DefaultComboBoxModel());
        profileNameComboBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                profileNameComboBoxActionPerformed(evt);
            }
        });

        removeProfileButton.setFont(new java.awt.Font("Dialog", 0, 12));
        removeProfileButton.setIcon(new javax.swing.ImageIcon(getClass().getResource("/org/danizmax/jsymphonic/resources/icons/list-remove.png"))); // NOI18N
        removeProfileButton.setToolTipText("Remove Profile");
        removeProfileButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                removeProfileButtonActionPerformed(evt);
            }
        });

        devPathLabel.setText("Device Path");

        devPathLabelData.setFont(new java.awt.Font("Dialog", 0, 12));
        devPathLabelData.setText("DEVICE_PATH");

        deviceBrowsButton.setIcon(new javax.swing.ImageIcon(getClass().getResource("/org/danizmax/jsymphonic/resources/icons/folder-blue.png"))); // NOI18N
        deviceBrowsButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                deviceBrowsButtonActionPerformed(evt);
            }
        });

        exportPathLabel.setText("Export Path");

        exportPathLabelData.setFont(new java.awt.Font("Dialog", 0, 12));
        exportPathLabelData.setText("EXPORT_PATH");

        exportBrowsButton.setIcon(new javax.swing.ImageIcon(getClass().getResource("/org/danizmax/jsymphonic/resources/icons/folder-blue.png"))); // NOI18N
        exportBrowsButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                exportBrowsButtonActionPerformed(evt);
            }
        });

        tempBrowsButton.setIcon(new javax.swing.ImageIcon(getClass().getResource("/org/danizmax/jsymphonic/resources/icons/folder-blue.png"))); // NOI18N
        tempBrowsButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                tempBrowsButtonActionPerformed(evt);
            }
        });

        addLocalPathButton.setIcon(new javax.swing.ImageIcon(getClass().getResource("/org/danizmax/jsymphonic/resources/icons/list-add.png"))); // NOI18N
        addLocalPathButton.setToolTipText("Add Local Path");
        addLocalPathButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                addLocalPathButtonActionPerformed(evt);
            }
        });

        tempPathLabelData.setFont(new java.awt.Font("Dialog", 0, 12));
        tempPathLabelData.setText("TEMP_PATH");

        LocalPathLabel.setText("Local Path");

        tempPathLabel.setText("Temporary Folder (for transcoded files)");

        exportCheckBox.setFont(new java.awt.Font("Dialog", 0, 12));
        java.util.ResourceBundle bundle = java.util.ResourceBundle.getBundle("localization/jsymphonicprofilesdialog"); // NOI18N
        exportCheckBox.setText(bundle.getString("JSymphonicProfilesDialog.exportCheckBox.text")); // NOI18N
        exportCheckBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                exportCheckBoxActionPerformed(evt);
            }
        });

        tempCheckBox.setFont(new java.awt.Font("Dialog", 0, 12));
        tempCheckBox.setText(bundle.getString("JSymphonicProfilesDialog.tempCheckBox.text")); // NOI18N
        tempCheckBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                tempCheckBoxActionPerformed(evt);
            }
        });

        localPathsList.setFont(new java.awt.Font("Dialog", 0, 12));
        localPathsList.setModel(new DefaultListModel());
        jScrollPane1.setViewportView(localPathsList);

        removeLocalPathButton.setIcon(new javax.swing.ImageIcon(getClass().getResource("/org/danizmax/jsymphonic/resources/icons/list-remove.png"))); // NOI18N
        removeLocalPathButton.setToolTipText("Remove Local Path");
        removeLocalPathButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                removeLocalPathButtonActionPerformed(evt);
            }
        });

        deviceGenLabel.setText("Device Generation");

        generationComboBox.setFont(new java.awt.Font("Dialog", 0, 12));
        generationComboBox.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "Item 1", "Item 2", "Item 3", "Item 4" }));
        generationComboBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                generationComboBoxActionPerformed(evt);
            }
        });

        addProfileButton.setFont(new java.awt.Font("Dialog", 0, 12));
        addProfileButton.setIcon(new javax.swing.ImageIcon(getClass().getResource("/org/danizmax/jsymphonic/resources/icons/list-add.png"))); // NOI18N
        addProfileButton.setToolTipText("Add Profile");
        addProfileButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                addProfileButtonActionPerformed(evt);
            }
        });

        saveProfileButton.setFont(new java.awt.Font("Dialog", 0, 12));
        saveProfileButton.setIcon(new javax.swing.ImageIcon(getClass().getResource("/org/danizmax/jsymphonic/resources/icons/save.png"))); // NOI18N
        saveProfileButton.setToolTipText("Save changes");
        saveProfileButton.setEnabled(false);
        saveProfileButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                saveProfileButtonActionPerformed(evt);
            }
        });

        defaultToggleButton.setIcon(new javax.swing.ImageIcon(getClass().getResource("/org/danizmax/jsymphonic/resources/icons/new-stuff.png"))); // NOI18N
        defaultToggleButton.setToolTipText("Default profile");
        defaultToggleButton.setMaximumSize(new java.awt.Dimension(50, 26));
        defaultToggleButton.setMinimumSize(new java.awt.Dimension(50, 26));
        defaultToggleButton.setPreferredSize(new java.awt.Dimension(50, 26));
        defaultToggleButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                defaultToggleButtonActionPerformed(evt);
            }
        });

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(layout.createSequentialGroup()
                        .addContainerGap()
                        .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                            .add(org.jdesktop.layout.GroupLayout.TRAILING, layout.createSequentialGroup()
                                .add(profileNameComboBox, 0, 269, Short.MAX_VALUE)
                                .addPreferredGap(org.jdesktop.layout.LayoutStyle.UNRELATED)
                                .add(removeProfileButton, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 30, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                                .add(addProfileButton, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 30, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                                .add(defaultToggleButton, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 30, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                                .add(saveProfileButton, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 30, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                            .add(devPathLabel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 419, Short.MAX_VALUE)))
                    .add(layout.createSequentialGroup()
                        .add(24, 24, 24)
                        .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                            .add(jSeparator2, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 407, Short.MAX_VALUE)
                            .add(layout.createSequentialGroup()
                                .add(devPathLabelData, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 367, Short.MAX_VALUE)
                                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                                .add(deviceBrowsButton, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 28, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))))
                    .add(layout.createSequentialGroup()
                        .addContainerGap()
                        .add(exportPathLabel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 419, Short.MAX_VALUE))
                    .add(layout.createSequentialGroup()
                        .add(24, 24, 24)
                        .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                            .add(exportCheckBox, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 407, Short.MAX_VALUE)
                            .add(layout.createSequentialGroup()
                                .add(exportPathLabelData, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 367, Short.MAX_VALUE)
                                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                                .add(exportBrowsButton, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 28, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                            .add(jSeparator1, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 407, Short.MAX_VALUE)))
                    .add(org.jdesktop.layout.GroupLayout.TRAILING, layout.createSequentialGroup()
                        .addContainerGap()
                        .add(tempPathLabel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 419, Short.MAX_VALUE))
                    .add(layout.createSequentialGroup()
                        .add(24, 24, 24)
                        .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                            .add(tempCheckBox, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 407, Short.MAX_VALUE)
                            .add(jSeparator3, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 407, Short.MAX_VALUE)
                            .add(layout.createSequentialGroup()
                                .add(tempPathLabelData, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 367, Short.MAX_VALUE)
                                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                                .add(tempBrowsButton, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 28, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))))
                    .add(layout.createSequentialGroup()
                        .addContainerGap()
                        .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                            .add(LocalPathLabel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 419, Short.MAX_VALUE)
                            .add(org.jdesktop.layout.GroupLayout.TRAILING, deviceGenLabel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 419, Short.MAX_VALUE)
                            .add(org.jdesktop.layout.GroupLayout.TRAILING, layout.createSequentialGroup()
                                .add(12, 12, 12)
                                .add(generationComboBox, 0, 407, Short.MAX_VALUE))
                            .add(org.jdesktop.layout.GroupLayout.TRAILING, layout.createSequentialGroup()
                                .add(12, 12, 12)
                                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING)
                                    .add(org.jdesktop.layout.GroupLayout.LEADING, jSeparator4, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 373, Short.MAX_VALUE)
                                    .add(org.jdesktop.layout.GroupLayout.LEADING, jScrollPane1, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 373, Short.MAX_VALUE))
                                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING)
                                    .add(removeLocalPathButton, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 28, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                                    .add(addLocalPathButton, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 28, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))))))
                .addContainerGap())
        );

        layout.linkSize(new java.awt.Component[] {addProfileButton, defaultToggleButton, removeProfileButton, saveProfileButton}, org.jdesktop.layout.GroupLayout.HORIZONTAL);

        layout.linkSize(new java.awt.Component[] {addLocalPathButton, removeLocalPathButton}, org.jdesktop.layout.GroupLayout.HORIZONTAL);

        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING)
                    .add(saveProfileButton)
                    .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING)
                        .add(addProfileButton)
                        .add(org.jdesktop.layout.GroupLayout.LEADING, removeProfileButton))
                    .add(defaultToggleButton, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(profileNameComboBox, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.UNRELATED)
                .add(devPathLabel)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.CENTER)
                    .add(devPathLabelData)
                    .add(deviceBrowsButton, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 19, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jSeparator2, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 10, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(exportPathLabel)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.CENTER)
                    .add(exportPathLabelData)
                    .add(exportBrowsButton, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 19, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(exportCheckBox)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jSeparator1, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 10, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(tempPathLabel)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.CENTER)
                    .add(tempPathLabelData)
                    .add(tempBrowsButton))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(tempCheckBox)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jSeparator3, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 10, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(LocalPathLabel)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.UNRELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(layout.createSequentialGroup()
                        .add(addLocalPathButton)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(removeLocalPathButton, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 19, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                    .add(jScrollPane1, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 73, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jSeparator4, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 10, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(deviceGenLabel)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.UNRELATED)
                .add(generationComboBox, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        layout.linkSize(new java.awt.Component[] {addLocalPathButton, removeLocalPathButton}, org.jdesktop.layout.GroupLayout.VERTICAL);

        layout.linkSize(new java.awt.Component[] {addProfileButton, defaultToggleButton, profileNameComboBox, removeProfileButton, saveProfileButton}, org.jdesktop.layout.GroupLayout.VERTICAL);

        layout.linkSize(new java.awt.Component[] {deviceBrowsButton, exportBrowsButton, tempBrowsButton}, org.jdesktop.layout.GroupLayout.VERTICAL);

    }// </editor-fold>//GEN-END:initComponents

    private void deviceBrowsButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_deviceBrowsButtonActionPerformed
        if(OpenChooserDialog(java.util.ResourceBundle.getBundle("localization/jsymphonicprofilesdialog").getString("JSymphonicProfilesDialog.Select_device_path"), devPathLabelData)){
            setProfileModified(true);
        }
}//GEN-LAST:event_deviceBrowsButtonActionPerformed

    private void exportBrowsButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_exportBrowsButtonActionPerformed
        if(OpenChooserDialog(java.util.ResourceBundle.getBundle("localization/jsymphonicprofilesdialog").getString("JSymphonicProfilesDialog.Select_export_path"), exportPathLabelData)){
            setProfileModified(true);
        }
}//GEN-LAST:event_exportBrowsButtonActionPerformed

    private void tempBrowsButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_tempBrowsButtonActionPerformed
        if(OpenChooserDialog(java.util.ResourceBundle.getBundle("localization/jsymphonicprofilesdialog").getString("JSymphonicProfilesDialog.Select_temp_path"), tempPathLabelData)){
            setProfileModified(true);
        }
}//GEN-LAST:event_tempBrowsButtonActionPerformed

    private void addLocalPathButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_addLocalPathButtonActionPerformed

        JFileChooser fc = new JFileChooser();
        fc.setDialogTitle("Choose local path...");
        fc.setDialogType(JFileChooser.OPEN_DIALOG);
        fc.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
        fc.setVisible(true);

        if(fc.showOpenDialog(this) == JFileChooser.APPROVE_OPTION){

            DefaultListModel dlm = (DefaultListModel) localPathsList.getModel();
            String newPath = fc.getSelectedFile().getAbsolutePath();
            boolean isNewPath = true;

            for(int i=0; i<dlm.getSize(); i++){
                if(localPathsList.getModel().getElementAt(i).equals(newPath)){
                    isNewPath = false;
                    break;
                }
            }

            if(isNewPath){
                dlm.addElement(newPath);
                localPathsList.ensureIndexIsVisible(dlm.getSize()-1);
                setProfileModified(true);
            }else{
                JOptionPane.showMessageDialog(this, "This path already exists!", "Same paths not allowed...", JOptionPane.ERROR_MESSAGE);
            }
        }
        
}//GEN-LAST:event_addLocalPathButtonActionPerformed

    private void exportCheckBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_exportCheckBoxActionPerformed
        exportPathLabelData.setEnabled(!exportCheckBox.isSelected());
        exportBrowsButton.setEnabled(!exportCheckBox.isSelected());
        setProfileModified(true);
}//GEN-LAST:event_exportCheckBoxActionPerformed

    private void tempCheckBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_tempCheckBoxActionPerformed
        tempPathLabelData.setEnabled(!tempCheckBox.isSelected());
        tempBrowsButton.setEnabled(!tempCheckBox.isSelected());
        setProfileModified(true);
}//GEN-LAST:event_tempCheckBoxActionPerformed

    private void removeLocalPathButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_removeLocalPathButtonActionPerformed
        if(localPathsList.getSelectedIndex() > -1){
            if(JOptionPane.YES_OPTION == JOptionPane.showConfirmDialog(this, "Do you really want to delete local path" + " " + localListmodel.getElementAt(localPathsList.getSelectedIndex()) +"?", "Confirming deletion...", JOptionPane.YES_NO_OPTION)){
                localListmodel.removeElementAt(localPathsList.getSelectedIndex());
                setProfileModified(true);
            }
        }
}//GEN-LAST:event_removeLocalPathButtonActionPerformed

    private void saveProfileButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_saveProfileButtonActionPerformed
        saveProfileData();
}//GEN-LAST:event_saveProfileButtonActionPerformed

    private void addProfileButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_addProfileButtonActionPerformed
        String name = JOptionPane.showInputDialog("Enter new profile name.");
        if(name != null && name.length() > 0 ){
            profiles.add(new ProfileElement(name, "undefDevPath", "undefExpPath", false, "undefTempPath", false, "{undefLocalPath}", 0));
            profileNameComboBox.addItem(name);
           // setPageEnabled(profileNameComboBox.getItemCount()>0);
        }
    }//GEN-LAST:event_addProfileButtonActionPerformed

    private void removeProfileButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_removeProfileButtonActionPerformed
        DefaultComboBoxModel model = (DefaultComboBoxModel) profileNameComboBox.getModel();
        if(model.getElementAt(profileNameComboBox.getSelectedIndex()) != null){
            if(JOptionPane.YES_OPTION == JOptionPane.showConfirmDialog(this, "Do you really want to delete profile" + " " + model.getElementAt(profileNameComboBox.getSelectedIndex()) +"?", "Confirming deletion...", JOptionPane.YES_NO_OPTION)){
                model.removeElementAt(profileNameComboBox.getSelectedIndex());
                if(profileNameComboBox.getSelectedIndex()>-1){
                    profiles.remove(profileNameComboBox.getSelectedIndex());
                }else{
                    profiles.remove(0);
                }
                //setPageEnabled(profileNameComboBox.getItemCount()>0);
            }
        }
    }//GEN-LAST:event_removeProfileButtonActionPerformed

    private void generationComboBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_generationComboBoxActionPerformed
        setProfileModified(true);
    }//GEN-LAST:event_generationComboBoxActionPerformed

    private void profileNameComboBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_profileNameComboBoxActionPerformed
        DefaultComboBoxModel model = (DefaultComboBoxModel) profileNameComboBox.getModel();
        if(profileModified){
            if(JOptionPane.YES_OPTION == JOptionPane.showConfirmDialog(this, "Do you want to save changes to profile" + " " + model.getElementAt(profileNameComboBox.getSelectedIndex()) +"?", "Changing profile...", JOptionPane.YES_NO_OPTION)){
                saveProfileData();
            }
        }

        if(profiles.size()>0){
            if(profileNameComboBox.getSelectedIndex()>-1){
                currElement = (ProfileElement) profiles.get(profileNameComboBox.getSelectedIndex());
            }else{
                currElement = null;
                //profileNameComboBox.setSelectedIndex(0);
            }
        }/*else{
                currElement = null;//(ProfileElement) profiles.get(0);
              //  profileNameComboBox.setSelec;
        }*/
            updateGUIData();
        //}
    }//GEN-LAST:event_profileNameComboBoxActionPerformed

    private void defaultToggleButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_defaultToggleButtonActionPerformed
        setProfileModified(true);
        defaultToggleButton.setEnabled(false);
        //defaultProfile = profileNameComboBox.getSelectedIndex();
    }//GEN-LAST:event_defaultToggleButtonActionPerformed

    public void saveProfileData(){
        currElement.setDevicePath(devPathLabelData.getText());
        currElement.setExportPath(exportPathLabelData.getText());
        currElement.setExportSameAsLocalPath(exportCheckBox.isSelected());
        currElement.setTempPath(tempPathLabelData.getText());
        currElement.setTempSameAsDevicePath(tempCheckBox.isSelected());

        if(defaultToggleButton.isSelected()){
            defaultProfile = profileNameComboBox.getSelectedIndex();
        }

        Vector localPaths = currElement.getLocalPaths();
        localPaths.clear();
        for(int i=0;i<localListmodel.size();i++){
            localPaths.add(localListmodel.get(i));
        }
        // 2010/3/4 Add by Michael for correct the generation Number problem. start
        Object sObject = generationComboBox.getSelectedItem();
        // Generation 0, 1 and 2 are not supported
        //if( sObject.equals(java.util.ResourceBundle.getBundle("localization/jsymphonicprofilesdialog").getString("JSymphonicProfilesDialog.generation0")))
            //currElement.setDeviceGeneration(0);
        if( sObject.equals(java.util.ResourceBundle.getBundle("localization/jsymphonicprofilesdialog").getString("JSymphonicProfilesDialog.generation1")))
            currElement.setDeviceGeneration(1);
        //if( sObject.equals(java.util.ResourceBundle.getBundle("localization/jsymphonicprofilesdialog").getString("JSymphonicProfilesDialog.generation2")))
            //currElement.setDeviceGeneration(2);
        if( sObject.equals(java.util.ResourceBundle.getBundle("localization/jsymphonicprofilesdialog").getString("JSymphonicProfilesDialog.generation3")))
            currElement.setDeviceGeneration(3);
        if( sObject.equals(java.util.ResourceBundle.getBundle("localization/jsymphonicprofilesdialog").getString("JSymphonicProfilesDialog.generation4")))
            currElement.setDeviceGeneration(4);
        if( sObject.equals(java.util.ResourceBundle.getBundle("localization/jsymphonicprofilesdialog").getString("JSymphonicProfilesDialog.generation5")))
            currElement.setDeviceGeneration(5);
        if( sObject.equals(java.util.ResourceBundle.getBundle("localization/jsymphonicprofilesdialog").getString("JSymphonicProfilesDialog.generation6")))
            currElement.setDeviceGeneration(6);
        if( sObject.equals(java.util.ResourceBundle.getBundle("localization/jsymphonicprofilesdialog").getString("JSymphonicProfilesDialog.generation7")))
            currElement.setDeviceGeneration(7);
        if( sObject.equals(java.util.ResourceBundle.getBundle("localization/jsymphonicprofilesdialog").getString("JSymphonicProfilesDialog.generationVaio")))
            currElement.setDeviceGeneration(8);

        // 2010/3/4 Add by Michael for correct the generation Number problem. end
        // 2010/3/4 del by Michael start
        //currElement.setDeviceGeneration(generationComboBox.getSelectedIndex());
        // 2010/3/4 del by Michael end

        setProfileModified(false);
    }
    /**
     * Opens a choose dialog for folders
     * @param dialogText the text you want to appera in the dialog
     * @param tf the JTextField you want to enter path into
     */
    private boolean OpenChooserDialog(String dialogText, JLabel tf){
        JFileChooser fc = new JFileChooser();
        fc.setDialogTitle(dialogText);
        fc.setCurrentDirectory(new File(tf.getText()));
        fc.setDialogType(JFileChooser.OPEN_DIALOG);
        fc.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
        fc.setVisible(true);

        if(fc.showOpenDialog(this) == JFileChooser.APPROVE_OPTION){
            tf.setText(fc.getSelectedFile().getAbsolutePath());
            return true;
        }

        return false;
    }

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel LocalPathLabel;
    private javax.swing.JButton addLocalPathButton;
    private javax.swing.JButton addProfileButton;
    private javax.swing.JToggleButton defaultToggleButton;
    private javax.swing.JLabel devPathLabel;
    private javax.swing.JLabel devPathLabelData;
    private javax.swing.JButton deviceBrowsButton;
    private javax.swing.JLabel deviceGenLabel;
    private javax.swing.JButton exportBrowsButton;
    private javax.swing.JCheckBox exportCheckBox;
    private javax.swing.JLabel exportPathLabel;
    private javax.swing.JLabel exportPathLabelData;
    private javax.swing.JComboBox generationComboBox;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JSeparator jSeparator1;
    private javax.swing.JSeparator jSeparator2;
    private javax.swing.JSeparator jSeparator3;
    private javax.swing.JSeparator jSeparator4;
    private javax.swing.JList localPathsList;
    private javax.swing.JComboBox profileNameComboBox;
    private javax.swing.JButton removeLocalPathButton;
    private javax.swing.JButton removeProfileButton;
    private javax.swing.JButton saveProfileButton;
    private javax.swing.JButton tempBrowsButton;
    private javax.swing.JCheckBox tempCheckBox;
    private javax.swing.JLabel tempPathLabel;
    private javax.swing.JLabel tempPathLabelData;
    // End of variables declaration//GEN-END:variables

    /**
     * @return the profileModified
     */
    public boolean isProfileModified() {
        return profileModified;
    }

    /**
     * @param profileModified the profileModified to set
     */
    public void setProfileModified(boolean profileModified) {
        this.profileModified = profileModified;
        saveProfileButton.setEnabled(profileModified);
    }

    /**
     * @return the defaultProfile
     */
    public int getDefaultProfile() {
        return defaultProfile;
    }

}
