
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2024 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQWizard.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QWizard>
#include <QAbstractButton>
#include <QAction>
#include <QActionEvent>
#include <QBitmap>
#include <QChildEvent>
#include <QCloseEvent>
#include <QContextMenuEvent>
#include <QCursor>
#include <QDragEnterEvent>
#include <QDragLeaveEvent>
#include <QDragMoveEvent>
#include <QDropEvent>
#include <QEvent>
#include <QFocusEvent>
#include <QFont>
#include <QFontInfo>
#include <QFontMetrics>
#include <QGraphicsEffect>
#include <QGraphicsProxyWidget>
#include <QHideEvent>
#include <QIcon>
#include <QInputContext>
#include <QInputMethodEvent>
#include <QKeyEvent>
#include <QKeySequence>
#include <QLayout>
#include <QLocale>
#include <QMargins>
#include <QMouseEvent>
#include <QMoveEvent>
#include <QObject>
#include <QPaintDevice>
#include <QPaintEngine>
#include <QPaintEvent>
#include <QPainter>
#include <QPalette>
#include <QPixmap>
#include <QPoint>
#include <QRect>
#include <QRegion>
#include <QResizeEvent>
#include <QShowEvent>
#include <QSize>
#include <QSizePolicy>
#include <QStyle>
#include <QTabletEvent>
#include <QThread>
#include <QTimerEvent>
#include <QWheelEvent>
#include <QWidget>
#include <QWizardPage>
#include "gsiQt.h"
#include "gsiQtGuiCommon.h"
#include <memory>

// -----------------------------------------------------------------------
// class QWizard

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QWizard::staticMetaObject);
}


// int QWizard::addPage(QWizardPage *page)


static void _init_f_addPage_1709 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("page");
  decl->add_arg<QWizardPage * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_f_addPage_1709 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWizardPage *arg1 = gsi::arg_reader<QWizardPage * >() (args, heap);
  ret.write<int > ((int)((QWizard *)cls)->addPage (arg1));
}


// void QWizard::back()


static void _init_f_back_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_back_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWizard *)cls)->back ();
}


// QAbstractButton *QWizard::button(QWizard::WizardButton which)


static void _init_f_button_c2519 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("which");
  decl->add_arg<const qt_gsi::Converter<QWizard::WizardButton>::target_type & > (argspec_0);
  decl->set_return<QAbstractButton * > ();
}

static void _call_f_button_c2519 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QWizard::WizardButton>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QWizard::WizardButton>::target_type & >() (args, heap);
  ret.write<QAbstractButton * > ((QAbstractButton *)((QWizard *)cls)->button (qt_gsi::QtToCppAdaptor<QWizard::WizardButton>(arg1).cref()));
}


// QString QWizard::buttonText(QWizard::WizardButton which)


static void _init_f_buttonText_c2519 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("which");
  decl->add_arg<const qt_gsi::Converter<QWizard::WizardButton>::target_type & > (argspec_0);
  decl->set_return<QString > ();
}

static void _call_f_buttonText_c2519 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QWizard::WizardButton>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QWizard::WizardButton>::target_type & >() (args, heap);
  ret.write<QString > ((QString)((QWizard *)cls)->buttonText (qt_gsi::QtToCppAdaptor<QWizard::WizardButton>(arg1).cref()));
}


// int QWizard::currentId()


static void _init_f_currentId_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_currentId_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QWizard *)cls)->currentId ());
}


// QWizardPage *QWizard::currentPage()


static void _init_f_currentPage_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QWizardPage * > ();
}

static void _call_f_currentPage_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QWizardPage * > ((QWizardPage *)((QWizard *)cls)->currentPage ());
}


// QVariant QWizard::field(const QString &name)


static void _init_f_field_c2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("name");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<QVariant > ();
}

static void _call_f_field_c2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ret.write<QVariant > ((QVariant)((QWizard *)cls)->field (arg1));
}


// bool QWizard::hasVisitedPage(int id)


static void _init_f_hasVisitedPage_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("id");
  decl->add_arg<int > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_hasVisitedPage_c767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ret.write<bool > ((bool)((QWizard *)cls)->hasVisitedPage (arg1));
}


// void QWizard::next()


static void _init_f_next_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_next_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWizard *)cls)->next ();
}


// int QWizard::nextId()


static void _init_f_nextId_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_nextId_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QWizard *)cls)->nextId ());
}


// QFlags<QWizard::WizardOption> QWizard::options()


static void _init_f_options_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QFlags<QWizard::WizardOption> > ();
}

static void _call_f_options_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QFlags<QWizard::WizardOption> > ((QFlags<QWizard::WizardOption>)((QWizard *)cls)->options ());
}


// QWizardPage *QWizard::page(int id)


static void _init_f_page_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("id");
  decl->add_arg<int > (argspec_0);
  decl->set_return<QWizardPage * > ();
}

static void _call_f_page_c767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ret.write<QWizardPage * > ((QWizardPage *)((QWizard *)cls)->page (arg1));
}


// QList<int> QWizard::pageIds()


static void _init_f_pageIds_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QList<int> > ();
}

static void _call_f_pageIds_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QList<int> > ((QList<int>)((QWizard *)cls)->pageIds ());
}


// QPixmap QWizard::pixmap(QWizard::WizardPixmap which)


static void _init_f_pixmap_c2506 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("which");
  decl->add_arg<const qt_gsi::Converter<QWizard::WizardPixmap>::target_type & > (argspec_0);
  decl->set_return<QPixmap > ();
}

static void _call_f_pixmap_c2506 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QWizard::WizardPixmap>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QWizard::WizardPixmap>::target_type & >() (args, heap);
  ret.write<QPixmap > ((QPixmap)((QWizard *)cls)->pixmap (qt_gsi::QtToCppAdaptor<QWizard::WizardPixmap>(arg1).cref()));
}


// void QWizard::removePage(int id)


static void _init_f_removePage_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("id");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_removePage_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWizard *)cls)->removePage (arg1);
}


// void QWizard::restart()


static void _init_f_restart_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_restart_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWizard *)cls)->restart ();
}


// void QWizard::setButton(QWizard::WizardButton which, QAbstractButton *button)


static void _init_f_setButton_4570 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("which");
  decl->add_arg<const qt_gsi::Converter<QWizard::WizardButton>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("button");
  decl->add_arg<QAbstractButton * > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setButton_4570 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QWizard::WizardButton>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QWizard::WizardButton>::target_type & >() (args, heap);
  QAbstractButton *arg2 = gsi::arg_reader<QAbstractButton * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWizard *)cls)->setButton (qt_gsi::QtToCppAdaptor<QWizard::WizardButton>(arg1).cref(), arg2);
}


// void QWizard::setButtonLayout(const QList<QWizard::WizardButton> &layout)


static void _init_f_setButtonLayout_4011 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("layout");
  decl->add_arg<const QList<QWizard::WizardButton> & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setButtonLayout_4011 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QList<QWizard::WizardButton> &arg1 = gsi::arg_reader<const QList<QWizard::WizardButton> & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWizard *)cls)->setButtonLayout (arg1);
}


// void QWizard::setButtonText(QWizard::WizardButton which, const QString &text)


static void _init_f_setButtonText_4436 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("which");
  decl->add_arg<const qt_gsi::Converter<QWizard::WizardButton>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("text");
  decl->add_arg<const QString & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setButtonText_4436 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QWizard::WizardButton>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QWizard::WizardButton>::target_type & >() (args, heap);
  const QString &arg2 = gsi::arg_reader<const QString & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWizard *)cls)->setButtonText (qt_gsi::QtToCppAdaptor<QWizard::WizardButton>(arg1).cref(), arg2);
}


// void QWizard::setDefaultProperty(const char *className, const char *property, const char *changedSignal)


static void _init_f_setDefaultProperty_4977 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("className");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("property");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("changedSignal");
  decl->add_arg<const char * > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_setDefaultProperty_4977 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg3 = gsi::arg_reader<const char * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWizard *)cls)->setDefaultProperty (arg1, arg2, arg3);
}


// void QWizard::setField(const QString &name, const QVariant &value)


static void _init_f_setField_4036 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("name");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("value");
  decl->add_arg<const QVariant & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setField_4036 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  const QVariant &arg2 = gsi::arg_reader<const QVariant & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWizard *)cls)->setField (arg1, arg2);
}


// void QWizard::setOption(QWizard::WizardOption option, bool on)


static void _init_f_setOption_3272 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("option");
  decl->add_arg<const qt_gsi::Converter<QWizard::WizardOption>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("on", true, "true");
  decl->add_arg<bool > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setOption_3272 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QWizard::WizardOption>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QWizard::WizardOption>::target_type & >() (args, heap);
  bool arg2 = args ? gsi::arg_reader<bool >() (args, heap) : gsi::arg_maker<bool >() (true, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWizard *)cls)->setOption (qt_gsi::QtToCppAdaptor<QWizard::WizardOption>(arg1).cref(), arg2);
}


// void QWizard::setOptions(QFlags<QWizard::WizardOption> options)


static void _init_f_setOptions_3212 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("options");
  decl->add_arg<QFlags<QWizard::WizardOption> > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setOptions_3212 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFlags<QWizard::WizardOption> arg1 = gsi::arg_reader<QFlags<QWizard::WizardOption> >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWizard *)cls)->setOptions (arg1);
}


// void QWizard::setPage(int id, QWizardPage *page)


static void _init_f_setPage_2368 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("id");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("page");
  decl->add_arg<QWizardPage * > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setPage_2368 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  QWizardPage *arg2 = gsi::arg_reader<QWizardPage * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWizard *)cls)->setPage (arg1, arg2);
}


// void QWizard::setPixmap(QWizard::WizardPixmap which, const QPixmap &pixmap)


static void _init_f_setPixmap_4415 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("which");
  decl->add_arg<const qt_gsi::Converter<QWizard::WizardPixmap>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("pixmap");
  decl->add_arg<const QPixmap & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setPixmap_4415 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QWizard::WizardPixmap>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QWizard::WizardPixmap>::target_type & >() (args, heap);
  const QPixmap &arg2 = gsi::arg_reader<const QPixmap & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWizard *)cls)->setPixmap (qt_gsi::QtToCppAdaptor<QWizard::WizardPixmap>(arg1).cref(), arg2);
}


// void QWizard::setStartId(int id)


static void _init_f_setStartId_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("id");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setStartId_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWizard *)cls)->setStartId (arg1);
}


// void QWizard::setSubTitleFormat(Qt::TextFormat format)


static void _init_f_setSubTitleFormat_1787 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("format");
  decl->add_arg<const qt_gsi::Converter<Qt::TextFormat>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setSubTitleFormat_1787 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<Qt::TextFormat>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<Qt::TextFormat>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWizard *)cls)->setSubTitleFormat (qt_gsi::QtToCppAdaptor<Qt::TextFormat>(arg1).cref());
}


// void QWizard::setTitleFormat(Qt::TextFormat format)


static void _init_f_setTitleFormat_1787 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("format");
  decl->add_arg<const qt_gsi::Converter<Qt::TextFormat>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setTitleFormat_1787 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<Qt::TextFormat>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<Qt::TextFormat>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWizard *)cls)->setTitleFormat (qt_gsi::QtToCppAdaptor<Qt::TextFormat>(arg1).cref());
}


// void QWizard::setVisible(bool visible)


static void _init_f_setVisible_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("visible");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setVisible_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWizard *)cls)->setVisible (arg1);
}


// void QWizard::setWizardStyle(QWizard::WizardStyle style)


static void _init_f_setWizardStyle_2412 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("style");
  decl->add_arg<const qt_gsi::Converter<QWizard::WizardStyle>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setWizardStyle_2412 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QWizard::WizardStyle>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QWizard::WizardStyle>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWizard *)cls)->setWizardStyle (qt_gsi::QtToCppAdaptor<QWizard::WizardStyle>(arg1).cref());
}


// QSize QWizard::sizeHint()


static void _init_f_sizeHint_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_f_sizeHint_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QSize > ((QSize)((QWizard *)cls)->sizeHint ());
}


// int QWizard::startId()


static void _init_f_startId_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_startId_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QWizard *)cls)->startId ());
}


// Qt::TextFormat QWizard::subTitleFormat()


static void _init_f_subTitleFormat_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<Qt::TextFormat>::target_type > ();
}

static void _call_f_subTitleFormat_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<Qt::TextFormat>::target_type > ((qt_gsi::Converter<Qt::TextFormat>::target_type)qt_gsi::CppToQtAdaptor<Qt::TextFormat>(((QWizard *)cls)->subTitleFormat ()));
}


// bool QWizard::testOption(QWizard::WizardOption option)


static void _init_f_testOption_c2516 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("option");
  decl->add_arg<const qt_gsi::Converter<QWizard::WizardOption>::target_type & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_testOption_c2516 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QWizard::WizardOption>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QWizard::WizardOption>::target_type & >() (args, heap);
  ret.write<bool > ((bool)((QWizard *)cls)->testOption (qt_gsi::QtToCppAdaptor<QWizard::WizardOption>(arg1).cref()));
}


// Qt::TextFormat QWizard::titleFormat()


static void _init_f_titleFormat_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<Qt::TextFormat>::target_type > ();
}

static void _call_f_titleFormat_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<Qt::TextFormat>::target_type > ((qt_gsi::Converter<Qt::TextFormat>::target_type)qt_gsi::CppToQtAdaptor<Qt::TextFormat>(((QWizard *)cls)->titleFormat ()));
}


// bool QWizard::validateCurrentPage()


static void _init_f_validateCurrentPage_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_validateCurrentPage_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QWizard *)cls)->validateCurrentPage ());
}


// QList<int> QWizard::visitedPages()


static void _init_f_visitedPages_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QList<int> > ();
}

static void _call_f_visitedPages_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QList<int> > ((QList<int>)((QWizard *)cls)->visitedPages ());
}


// QWizard::WizardStyle QWizard::wizardStyle()


static void _init_f_wizardStyle_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QWizard::WizardStyle>::target_type > ();
}

static void _call_f_wizardStyle_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QWizard::WizardStyle>::target_type > ((qt_gsi::Converter<QWizard::WizardStyle>::target_type)qt_gsi::CppToQtAdaptor<QWizard::WizardStyle>(((QWizard *)cls)->wizardStyle ()));
}


// static QString QWizard::tr(const char *s, const char *c)


static void _init_f_tr_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_tr_3354 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (0, heap);
  ret.write<QString > ((QString)QWizard::tr (arg1, arg2));
}


// static QString QWizard::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = gsi::arg_reader<const char * >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  ret.write<QString > ((QString)QWizard::tr (arg1, arg2, arg3));
}


// static QString QWizard::trUtf8(const char *s, const char *c)


static void _init_f_trUtf8_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_3354 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (0, heap);
  ret.write<QString > ((QString)QWizard::trUtf8 (arg1, arg2));
}


// static QString QWizard::trUtf8(const char *s, const char *c, int n)


static void _init_f_trUtf8_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = gsi::arg_reader<const char * >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  ret.write<QString > ((QString)QWizard::trUtf8 (arg1, arg2, arg3));
}


namespace gsi
{

static gsi::Methods methods_QWizard () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
  methods += new qt_gsi::GenericMethod ("addPage", "@brief Method int QWizard::addPage(QWizardPage *page)\n", false, &_init_f_addPage_1709, &_call_f_addPage_1709);
  methods += new qt_gsi::GenericMethod ("back", "@brief Method void QWizard::back()\n", false, &_init_f_back_0, &_call_f_back_0);
  methods += new qt_gsi::GenericMethod ("button", "@brief Method QAbstractButton *QWizard::button(QWizard::WizardButton which)\n", true, &_init_f_button_c2519, &_call_f_button_c2519);
  methods += new qt_gsi::GenericMethod ("buttonText", "@brief Method QString QWizard::buttonText(QWizard::WizardButton which)\n", true, &_init_f_buttonText_c2519, &_call_f_buttonText_c2519);
  methods += new qt_gsi::GenericMethod (":currentId", "@brief Method int QWizard::currentId()\n", true, &_init_f_currentId_c0, &_call_f_currentId_c0);
  methods += new qt_gsi::GenericMethod ("currentPage", "@brief Method QWizardPage *QWizard::currentPage()\n", true, &_init_f_currentPage_c0, &_call_f_currentPage_c0);
  methods += new qt_gsi::GenericMethod ("field", "@brief Method QVariant QWizard::field(const QString &name)\n", true, &_init_f_field_c2025, &_call_f_field_c2025);
  methods += new qt_gsi::GenericMethod ("hasVisitedPage", "@brief Method bool QWizard::hasVisitedPage(int id)\n", true, &_init_f_hasVisitedPage_c767, &_call_f_hasVisitedPage_c767);
  methods += new qt_gsi::GenericMethod ("next", "@brief Method void QWizard::next()\n", false, &_init_f_next_0, &_call_f_next_0);
  methods += new qt_gsi::GenericMethod ("nextId", "@brief Method int QWizard::nextId()\n", true, &_init_f_nextId_c0, &_call_f_nextId_c0);
  methods += new qt_gsi::GenericMethod (":options", "@brief Method QFlags<QWizard::WizardOption> QWizard::options()\n", true, &_init_f_options_c0, &_call_f_options_c0);
  methods += new qt_gsi::GenericMethod ("page", "@brief Method QWizardPage *QWizard::page(int id)\n", true, &_init_f_page_c767, &_call_f_page_c767);
  methods += new qt_gsi::GenericMethod ("pageIds", "@brief Method QList<int> QWizard::pageIds()\n", true, &_init_f_pageIds_c0, &_call_f_pageIds_c0);
  methods += new qt_gsi::GenericMethod ("pixmap", "@brief Method QPixmap QWizard::pixmap(QWizard::WizardPixmap which)\n", true, &_init_f_pixmap_c2506, &_call_f_pixmap_c2506);
  methods += new qt_gsi::GenericMethod ("removePage", "@brief Method void QWizard::removePage(int id)\n", false, &_init_f_removePage_767, &_call_f_removePage_767);
  methods += new qt_gsi::GenericMethod ("restart", "@brief Method void QWizard::restart()\n", false, &_init_f_restart_0, &_call_f_restart_0);
  methods += new qt_gsi::GenericMethod ("setButton", "@brief Method void QWizard::setButton(QWizard::WizardButton which, QAbstractButton *button)\n", false, &_init_f_setButton_4570, &_call_f_setButton_4570);
  methods += new qt_gsi::GenericMethod ("setButtonLayout", "@brief Method void QWizard::setButtonLayout(const QList<QWizard::WizardButton> &layout)\n", false, &_init_f_setButtonLayout_4011, &_call_f_setButtonLayout_4011);
  methods += new qt_gsi::GenericMethod ("setButtonText", "@brief Method void QWizard::setButtonText(QWizard::WizardButton which, const QString &text)\n", false, &_init_f_setButtonText_4436, &_call_f_setButtonText_4436);
  methods += new qt_gsi::GenericMethod ("setDefaultProperty", "@brief Method void QWizard::setDefaultProperty(const char *className, const char *property, const char *changedSignal)\n", false, &_init_f_setDefaultProperty_4977, &_call_f_setDefaultProperty_4977);
  methods += new qt_gsi::GenericMethod ("setField", "@brief Method void QWizard::setField(const QString &name, const QVariant &value)\n", false, &_init_f_setField_4036, &_call_f_setField_4036);
  methods += new qt_gsi::GenericMethod ("setOption", "@brief Method void QWizard::setOption(QWizard::WizardOption option, bool on)\n", false, &_init_f_setOption_3272, &_call_f_setOption_3272);
  methods += new qt_gsi::GenericMethod ("setOptions|options=", "@brief Method void QWizard::setOptions(QFlags<QWizard::WizardOption> options)\n", false, &_init_f_setOptions_3212, &_call_f_setOptions_3212);
  methods += new qt_gsi::GenericMethod ("setPage", "@brief Method void QWizard::setPage(int id, QWizardPage *page)\n", false, &_init_f_setPage_2368, &_call_f_setPage_2368);
  methods += new qt_gsi::GenericMethod ("setPixmap", "@brief Method void QWizard::setPixmap(QWizard::WizardPixmap which, const QPixmap &pixmap)\n", false, &_init_f_setPixmap_4415, &_call_f_setPixmap_4415);
  methods += new qt_gsi::GenericMethod ("setStartId|startId=", "@brief Method void QWizard::setStartId(int id)\n", false, &_init_f_setStartId_767, &_call_f_setStartId_767);
  methods += new qt_gsi::GenericMethod ("setSubTitleFormat|subTitleFormat=", "@brief Method void QWizard::setSubTitleFormat(Qt::TextFormat format)\n", false, &_init_f_setSubTitleFormat_1787, &_call_f_setSubTitleFormat_1787);
  methods += new qt_gsi::GenericMethod ("setTitleFormat|titleFormat=", "@brief Method void QWizard::setTitleFormat(Qt::TextFormat format)\n", false, &_init_f_setTitleFormat_1787, &_call_f_setTitleFormat_1787);
  methods += new qt_gsi::GenericMethod ("setVisible|visible=", "@brief Method void QWizard::setVisible(bool visible)\nThis is a reimplementation of QDialog::setVisible", false, &_init_f_setVisible_864, &_call_f_setVisible_864);
  methods += new qt_gsi::GenericMethod ("setWizardStyle|wizardStyle=", "@brief Method void QWizard::setWizardStyle(QWizard::WizardStyle style)\n", false, &_init_f_setWizardStyle_2412, &_call_f_setWizardStyle_2412);
  methods += new qt_gsi::GenericMethod (":sizeHint", "@brief Method QSize QWizard::sizeHint()\nThis is a reimplementation of QDialog::sizeHint", true, &_init_f_sizeHint_c0, &_call_f_sizeHint_c0);
  methods += new qt_gsi::GenericMethod (":startId", "@brief Method int QWizard::startId()\n", true, &_init_f_startId_c0, &_call_f_startId_c0);
  methods += new qt_gsi::GenericMethod (":subTitleFormat", "@brief Method Qt::TextFormat QWizard::subTitleFormat()\n", true, &_init_f_subTitleFormat_c0, &_call_f_subTitleFormat_c0);
  methods += new qt_gsi::GenericMethod ("testOption", "@brief Method bool QWizard::testOption(QWizard::WizardOption option)\n", true, &_init_f_testOption_c2516, &_call_f_testOption_c2516);
  methods += new qt_gsi::GenericMethod (":titleFormat", "@brief Method Qt::TextFormat QWizard::titleFormat()\n", true, &_init_f_titleFormat_c0, &_call_f_titleFormat_c0);
  methods += new qt_gsi::GenericMethod ("validateCurrentPage", "@brief Method bool QWizard::validateCurrentPage()\n", false, &_init_f_validateCurrentPage_0, &_call_f_validateCurrentPage_0);
  methods += new qt_gsi::GenericMethod ("visitedPages", "@brief Method QList<int> QWizard::visitedPages()\n", true, &_init_f_visitedPages_c0, &_call_f_visitedPages_c0);
  methods += new qt_gsi::GenericMethod (":wizardStyle", "@brief Method QWizard::WizardStyle QWizard::wizardStyle()\n", true, &_init_f_wizardStyle_c0, &_call_f_wizardStyle_c0);
  methods += gsi::qt_signal ("accepted()", "accepted", "@brief Signal declaration for QWizard::accepted()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<int > ("currentIdChanged(int)", "currentIdChanged", gsi::arg("id"), "@brief Signal declaration for QWizard::currentIdChanged(int id)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<int > ("customButtonClicked(int)", "customButtonClicked", gsi::arg("which"), "@brief Signal declaration for QWizard::customButtonClicked(int which)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QPoint & > ("customContextMenuRequested(const QPoint &)", "customContextMenuRequested", gsi::arg("pos"), "@brief Signal declaration for QWizard::customContextMenuRequested(const QPoint &pos)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<QObject * > ("destroyed(QObject *)", "destroyed", gsi::arg("arg1"), "@brief Signal declaration for QWizard::destroyed(QObject *)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<int > ("finished(int)", "finished", gsi::arg("result"), "@brief Signal declaration for QWizard::finished(int result)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("helpRequested()", "helpRequested", "@brief Signal declaration for QWizard::helpRequested()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("rejected()", "rejected", "@brief Signal declaration for QWizard::rejected()\nYou can bind a procedure to this signal.");
  methods += new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QWizard::tr(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_tr_3354, &_call_f_tr_3354);
  methods += new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QWizard::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
  methods += new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QWizard::trUtf8(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_3354, &_call_f_trUtf8_3354);
  methods += new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QWizard::trUtf8(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_4013, &_call_f_trUtf8_4013);
  return methods;
}

gsi::Class<QDialog> &qtdecl_QDialog ();

qt_gsi::QtNativeClass<QWizard> decl_QWizard (qtdecl_QDialog (), "QtGui", "QWizard_Native",
  methods_QWizard (),
  "@hide\n@alias QWizard");

GSI_QTGUI_PUBLIC gsi::Class<QWizard> &qtdecl_QWizard () { return decl_QWizard; }

}


class QWizard_Adaptor : public QWizard, public qt_gsi::QtObjectBase
{
public:

  virtual ~QWizard_Adaptor();

  //  [adaptor ctor] QWizard::QWizard(QWidget *parent, QFlags<Qt::WindowType> flags)
  QWizard_Adaptor() : QWizard()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QWizard::QWizard(QWidget *parent, QFlags<Qt::WindowType> flags)
  QWizard_Adaptor(QWidget *parent) : QWizard(parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QWizard::QWizard(QWidget *parent, QFlags<Qt::WindowType> flags)
  QWizard_Adaptor(QWidget *parent, QFlags<Qt::WindowType> flags) : QWizard(parent, flags)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [expose] void QWizard::adjustPosition(QWidget *)
  void fp_QWizard_adjustPosition_1315 (QWidget *arg1) {
    QWizard::adjustPosition(arg1);
  }

  //  [expose] void QWizard::create(WId, bool initializeWindow, bool destroyOldWindow)
  void fp_QWizard_create_2208 (const qt_gsi::Converter<WId>::target_type & arg1, bool initializeWindow, bool destroyOldWindow) {
    QWizard::create(qt_gsi::QtToCppAdaptor<WId>(arg1).cref(), initializeWindow, destroyOldWindow);
  }

  //  [expose] void QWizard::destroy(bool destroyWindow, bool destroySubWindows)
  void fp_QWizard_destroy_1620 (bool destroyWindow, bool destroySubWindows) {
    QWizard::destroy(destroyWindow, destroySubWindows);
  }

  //  [expose] bool QWizard::focusNextChild()
  bool fp_QWizard_focusNextChild_0 () {
    return QWizard::focusNextChild();
  }

  //  [expose] bool QWizard::focusPreviousChild()
  bool fp_QWizard_focusPreviousChild_0 () {
    return QWizard::focusPreviousChild();
  }

  //  [expose] int QWizard::receivers(const char *signal)
  int fp_QWizard_receivers_c1731 (const char *signal) const {
    return QWizard::receivers(signal);
  }

  //  [expose] void QWizard::resetInputContext()
  void fp_QWizard_resetInputContext_0 () {
    QWizard::resetInputContext();
  }

  //  [expose] QObject *QWizard::sender()
  QObject * fp_QWizard_sender_c0 () const {
    return QWizard::sender();
  }

  //  [expose] void QWizard::updateMicroFocus()
  void fp_QWizard_updateMicroFocus_0 () {
    QWizard::updateMicroFocus();
  }

  //  [adaptor impl] void QWizard::accept()
  void cbs_accept_0_0()
  {
    QWizard::accept();
  }

  virtual void accept()
  {
    if (cb_accept_0_0.can_issue()) {
      cb_accept_0_0.issue<QWizard_Adaptor>(&QWizard_Adaptor::cbs_accept_0_0);
    } else {
      QWizard::accept();
    }
  }

  //  [adaptor impl] int QWizard::heightForWidth(int)
  int cbs_heightForWidth_c767_0(int arg1) const
  {
    return QWizard::heightForWidth(arg1);
  }

  virtual int heightForWidth(int arg1) const
  {
    if (cb_heightForWidth_c767_0.can_issue()) {
      return cb_heightForWidth_c767_0.issue<QWizard_Adaptor, int, int>(&QWizard_Adaptor::cbs_heightForWidth_c767_0, arg1);
    } else {
      return QWizard::heightForWidth(arg1);
    }
  }

  //  [adaptor impl] QVariant QWizard::inputMethodQuery(Qt::InputMethodQuery)
  QVariant cbs_inputMethodQuery_c2420_0(const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & arg1) const
  {
    return QWizard::inputMethodQuery(qt_gsi::QtToCppAdaptor<Qt::InputMethodQuery>(arg1).cref());
  }

  virtual QVariant inputMethodQuery(Qt::InputMethodQuery arg1) const
  {
    if (cb_inputMethodQuery_c2420_0.can_issue()) {
      return cb_inputMethodQuery_c2420_0.issue<QWizard_Adaptor, QVariant, const qt_gsi::Converter<Qt::InputMethodQuery>::target_type &>(&QWizard_Adaptor::cbs_inputMethodQuery_c2420_0, qt_gsi::CppToQtAdaptor<Qt::InputMethodQuery>(arg1));
    } else {
      return QWizard::inputMethodQuery(arg1);
    }
  }

  //  [adaptor impl] QSize QWizard::minimumSizeHint()
  QSize cbs_minimumSizeHint_c0_0() const
  {
    return QWizard::minimumSizeHint();
  }

  virtual QSize minimumSizeHint() const
  {
    if (cb_minimumSizeHint_c0_0.can_issue()) {
      return cb_minimumSizeHint_c0_0.issue<QWizard_Adaptor, QSize>(&QWizard_Adaptor::cbs_minimumSizeHint_c0_0);
    } else {
      return QWizard::minimumSizeHint();
    }
  }

  //  [adaptor impl] int QWizard::nextId()
  int cbs_nextId_c0_0() const
  {
    return QWizard::nextId();
  }

  virtual int nextId() const
  {
    if (cb_nextId_c0_0.can_issue()) {
      return cb_nextId_c0_0.issue<QWizard_Adaptor, int>(&QWizard_Adaptor::cbs_nextId_c0_0);
    } else {
      return QWizard::nextId();
    }
  }

  //  [adaptor impl] QPaintEngine *QWizard::paintEngine()
  QPaintEngine * cbs_paintEngine_c0_0() const
  {
    return QWizard::paintEngine();
  }

  virtual QPaintEngine * paintEngine() const
  {
    if (cb_paintEngine_c0_0.can_issue()) {
      return cb_paintEngine_c0_0.issue<QWizard_Adaptor, QPaintEngine *>(&QWizard_Adaptor::cbs_paintEngine_c0_0);
    } else {
      return QWizard::paintEngine();
    }
  }

  //  [adaptor impl] void QWizard::reject()
  void cbs_reject_0_0()
  {
    QWizard::reject();
  }

  virtual void reject()
  {
    if (cb_reject_0_0.can_issue()) {
      cb_reject_0_0.issue<QWizard_Adaptor>(&QWizard_Adaptor::cbs_reject_0_0);
    } else {
      QWizard::reject();
    }
  }

  //  [adaptor impl] void QWizard::setVisible(bool visible)
  void cbs_setVisible_864_0(bool visible)
  {
    QWizard::setVisible(visible);
  }

  virtual void setVisible(bool visible)
  {
    if (cb_setVisible_864_0.can_issue()) {
      cb_setVisible_864_0.issue<QWizard_Adaptor, bool>(&QWizard_Adaptor::cbs_setVisible_864_0, visible);
    } else {
      QWizard::setVisible(visible);
    }
  }

  //  [adaptor impl] QSize QWizard::sizeHint()
  QSize cbs_sizeHint_c0_0() const
  {
    return QWizard::sizeHint();
  }

  virtual QSize sizeHint() const
  {
    if (cb_sizeHint_c0_0.can_issue()) {
      return cb_sizeHint_c0_0.issue<QWizard_Adaptor, QSize>(&QWizard_Adaptor::cbs_sizeHint_c0_0);
    } else {
      return QWizard::sizeHint();
    }
  }

  //  [adaptor impl] bool QWizard::validateCurrentPage()
  bool cbs_validateCurrentPage_0_0()
  {
    return QWizard::validateCurrentPage();
  }

  virtual bool validateCurrentPage()
  {
    if (cb_validateCurrentPage_0_0.can_issue()) {
      return cb_validateCurrentPage_0_0.issue<QWizard_Adaptor, bool>(&QWizard_Adaptor::cbs_validateCurrentPage_0_0);
    } else {
      return QWizard::validateCurrentPage();
    }
  }

  //  [emitter impl] void QWizard::accepted()
  void emitter_QWizard_accepted_0()
  {
    emit QWizard::accepted();
  }

  //  [adaptor impl] void QWizard::actionEvent(QActionEvent *)
  void cbs_actionEvent_1823_0(QActionEvent *arg1)
  {
    QWizard::actionEvent(arg1);
  }

  virtual void actionEvent(QActionEvent *arg1)
  {
    if (cb_actionEvent_1823_0.can_issue()) {
      cb_actionEvent_1823_0.issue<QWizard_Adaptor, QActionEvent *>(&QWizard_Adaptor::cbs_actionEvent_1823_0, arg1);
    } else {
      QWizard::actionEvent(arg1);
    }
  }

  //  [adaptor impl] void QWizard::changeEvent(QEvent *)
  void cbs_changeEvent_1217_0(QEvent *arg1)
  {
    QWizard::changeEvent(arg1);
  }

  virtual void changeEvent(QEvent *arg1)
  {
    if (cb_changeEvent_1217_0.can_issue()) {
      cb_changeEvent_1217_0.issue<QWizard_Adaptor, QEvent *>(&QWizard_Adaptor::cbs_changeEvent_1217_0, arg1);
    } else {
      QWizard::changeEvent(arg1);
    }
  }

  //  [adaptor impl] void QWizard::childEvent(QChildEvent *)
  void cbs_childEvent_1701_0(QChildEvent *arg1)
  {
    QWizard::childEvent(arg1);
  }

  virtual void childEvent(QChildEvent *arg1)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QWizard_Adaptor, QChildEvent *>(&QWizard_Adaptor::cbs_childEvent_1701_0, arg1);
    } else {
      QWizard::childEvent(arg1);
    }
  }

  //  [adaptor impl] void QWizard::cleanupPage(int id)
  void cbs_cleanupPage_767_0(int id)
  {
    QWizard::cleanupPage(id);
  }

  virtual void cleanupPage(int id)
  {
    if (cb_cleanupPage_767_0.can_issue()) {
      cb_cleanupPage_767_0.issue<QWizard_Adaptor, int>(&QWizard_Adaptor::cbs_cleanupPage_767_0, id);
    } else {
      QWizard::cleanupPage(id);
    }
  }

  //  [adaptor impl] void QWizard::closeEvent(QCloseEvent *)
  void cbs_closeEvent_1719_0(QCloseEvent *arg1)
  {
    QWizard::closeEvent(arg1);
  }

  virtual void closeEvent(QCloseEvent *arg1)
  {
    if (cb_closeEvent_1719_0.can_issue()) {
      cb_closeEvent_1719_0.issue<QWizard_Adaptor, QCloseEvent *>(&QWizard_Adaptor::cbs_closeEvent_1719_0, arg1);
    } else {
      QWizard::closeEvent(arg1);
    }
  }

  //  [adaptor impl] void QWizard::contextMenuEvent(QContextMenuEvent *)
  void cbs_contextMenuEvent_2363_0(QContextMenuEvent *arg1)
  {
    QWizard::contextMenuEvent(arg1);
  }

  virtual void contextMenuEvent(QContextMenuEvent *arg1)
  {
    if (cb_contextMenuEvent_2363_0.can_issue()) {
      cb_contextMenuEvent_2363_0.issue<QWizard_Adaptor, QContextMenuEvent *>(&QWizard_Adaptor::cbs_contextMenuEvent_2363_0, arg1);
    } else {
      QWizard::contextMenuEvent(arg1);
    }
  }

  //  [emitter impl] void QWizard::currentIdChanged(int id)
  void emitter_QWizard_currentIdChanged_767(int id)
  {
    emit QWizard::currentIdChanged(id);
  }

  //  [emitter impl] void QWizard::customButtonClicked(int which)
  void emitter_QWizard_customButtonClicked_767(int which)
  {
    emit QWizard::customButtonClicked(which);
  }

  //  [emitter impl] void QWizard::customContextMenuRequested(const QPoint &pos)
  void emitter_QWizard_customContextMenuRequested_1916(const QPoint &pos)
  {
    emit QWizard::customContextMenuRequested(pos);
  }

  //  [adaptor impl] void QWizard::customEvent(QEvent *)
  void cbs_customEvent_1217_0(QEvent *arg1)
  {
    QWizard::customEvent(arg1);
  }

  virtual void customEvent(QEvent *arg1)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QWizard_Adaptor, QEvent *>(&QWizard_Adaptor::cbs_customEvent_1217_0, arg1);
    } else {
      QWizard::customEvent(arg1);
    }
  }

  //  [emitter impl] void QWizard::destroyed(QObject *)
  void emitter_QWizard_destroyed_1302(QObject *arg1)
  {
    emit QWizard::destroyed(arg1);
  }

  //  [adaptor impl] void QWizard::disconnectNotify(const char *signal)
  void cbs_disconnectNotify_1731_0(const char *signal)
  {
    QWizard::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const char *signal)
  {
    if (cb_disconnectNotify_1731_0.can_issue()) {
      cb_disconnectNotify_1731_0.issue<QWizard_Adaptor, const char *>(&QWizard_Adaptor::cbs_disconnectNotify_1731_0, signal);
    } else {
      QWizard::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] void QWizard::done(int result)
  void cbs_done_767_0(int result)
  {
    QWizard::done(result);
  }

  virtual void done(int result)
  {
    if (cb_done_767_0.can_issue()) {
      cb_done_767_0.issue<QWizard_Adaptor, int>(&QWizard_Adaptor::cbs_done_767_0, result);
    } else {
      QWizard::done(result);
    }
  }

  //  [adaptor impl] void QWizard::dragEnterEvent(QDragEnterEvent *)
  void cbs_dragEnterEvent_2109_0(QDragEnterEvent *arg1)
  {
    QWizard::dragEnterEvent(arg1);
  }

  virtual void dragEnterEvent(QDragEnterEvent *arg1)
  {
    if (cb_dragEnterEvent_2109_0.can_issue()) {
      cb_dragEnterEvent_2109_0.issue<QWizard_Adaptor, QDragEnterEvent *>(&QWizard_Adaptor::cbs_dragEnterEvent_2109_0, arg1);
    } else {
      QWizard::dragEnterEvent(arg1);
    }
  }

  //  [adaptor impl] void QWizard::dragLeaveEvent(QDragLeaveEvent *)
  void cbs_dragLeaveEvent_2092_0(QDragLeaveEvent *arg1)
  {
    QWizard::dragLeaveEvent(arg1);
  }

  virtual void dragLeaveEvent(QDragLeaveEvent *arg1)
  {
    if (cb_dragLeaveEvent_2092_0.can_issue()) {
      cb_dragLeaveEvent_2092_0.issue<QWizard_Adaptor, QDragLeaveEvent *>(&QWizard_Adaptor::cbs_dragLeaveEvent_2092_0, arg1);
    } else {
      QWizard::dragLeaveEvent(arg1);
    }
  }

  //  [adaptor impl] void QWizard::dragMoveEvent(QDragMoveEvent *)
  void cbs_dragMoveEvent_2006_0(QDragMoveEvent *arg1)
  {
    QWizard::dragMoveEvent(arg1);
  }

  virtual void dragMoveEvent(QDragMoveEvent *arg1)
  {
    if (cb_dragMoveEvent_2006_0.can_issue()) {
      cb_dragMoveEvent_2006_0.issue<QWizard_Adaptor, QDragMoveEvent *>(&QWizard_Adaptor::cbs_dragMoveEvent_2006_0, arg1);
    } else {
      QWizard::dragMoveEvent(arg1);
    }
  }

  //  [adaptor impl] void QWizard::dropEvent(QDropEvent *)
  void cbs_dropEvent_1622_0(QDropEvent *arg1)
  {
    QWizard::dropEvent(arg1);
  }

  virtual void dropEvent(QDropEvent *arg1)
  {
    if (cb_dropEvent_1622_0.can_issue()) {
      cb_dropEvent_1622_0.issue<QWizard_Adaptor, QDropEvent *>(&QWizard_Adaptor::cbs_dropEvent_1622_0, arg1);
    } else {
      QWizard::dropEvent(arg1);
    }
  }

  //  [adaptor impl] void QWizard::enabledChange(bool)
  void cbs_enabledChange_864_0(bool arg1)
  {
    QWizard::enabledChange(arg1);
  }

  virtual void enabledChange(bool arg1)
  {
    if (cb_enabledChange_864_0.can_issue()) {
      cb_enabledChange_864_0.issue<QWizard_Adaptor, bool>(&QWizard_Adaptor::cbs_enabledChange_864_0, arg1);
    } else {
      QWizard::enabledChange(arg1);
    }
  }

  //  [adaptor impl] void QWizard::enterEvent(QEvent *)
  void cbs_enterEvent_1217_0(QEvent *arg1)
  {
    QWizard::enterEvent(arg1);
  }

  virtual void enterEvent(QEvent *arg1)
  {
    if (cb_enterEvent_1217_0.can_issue()) {
      cb_enterEvent_1217_0.issue<QWizard_Adaptor, QEvent *>(&QWizard_Adaptor::cbs_enterEvent_1217_0, arg1);
    } else {
      QWizard::enterEvent(arg1);
    }
  }

  //  [adaptor impl] bool QWizard::event(QEvent *event)
  bool cbs_event_1217_0(QEvent *_event)
  {
    return QWizard::event(_event);
  }

  virtual bool event(QEvent *_event)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QWizard_Adaptor, bool, QEvent *>(&QWizard_Adaptor::cbs_event_1217_0, _event);
    } else {
      return QWizard::event(_event);
    }
  }

  //  [adaptor impl] bool QWizard::eventFilter(QObject *, QEvent *)
  bool cbs_eventFilter_2411_0(QObject *arg1, QEvent *arg2)
  {
    return QWizard::eventFilter(arg1, arg2);
  }

  virtual bool eventFilter(QObject *arg1, QEvent *arg2)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QWizard_Adaptor, bool, QObject *, QEvent *>(&QWizard_Adaptor::cbs_eventFilter_2411_0, arg1, arg2);
    } else {
      return QWizard::eventFilter(arg1, arg2);
    }
  }

  //  [emitter impl] void QWizard::finished(int result)
  void emitter_QWizard_finished_767(int result)
  {
    emit QWizard::finished(result);
  }

  //  [adaptor impl] void QWizard::focusInEvent(QFocusEvent *)
  void cbs_focusInEvent_1729_0(QFocusEvent *arg1)
  {
    QWizard::focusInEvent(arg1);
  }

  virtual void focusInEvent(QFocusEvent *arg1)
  {
    if (cb_focusInEvent_1729_0.can_issue()) {
      cb_focusInEvent_1729_0.issue<QWizard_Adaptor, QFocusEvent *>(&QWizard_Adaptor::cbs_focusInEvent_1729_0, arg1);
    } else {
      QWizard::focusInEvent(arg1);
    }
  }

  //  [adaptor impl] bool QWizard::focusNextPrevChild(bool next)
  bool cbs_focusNextPrevChild_864_0(bool next)
  {
    return QWizard::focusNextPrevChild(next);
  }

  virtual bool focusNextPrevChild(bool next)
  {
    if (cb_focusNextPrevChild_864_0.can_issue()) {
      return cb_focusNextPrevChild_864_0.issue<QWizard_Adaptor, bool, bool>(&QWizard_Adaptor::cbs_focusNextPrevChild_864_0, next);
    } else {
      return QWizard::focusNextPrevChild(next);
    }
  }

  //  [adaptor impl] void QWizard::focusOutEvent(QFocusEvent *)
  void cbs_focusOutEvent_1729_0(QFocusEvent *arg1)
  {
    QWizard::focusOutEvent(arg1);
  }

  virtual void focusOutEvent(QFocusEvent *arg1)
  {
    if (cb_focusOutEvent_1729_0.can_issue()) {
      cb_focusOutEvent_1729_0.issue<QWizard_Adaptor, QFocusEvent *>(&QWizard_Adaptor::cbs_focusOutEvent_1729_0, arg1);
    } else {
      QWizard::focusOutEvent(arg1);
    }
  }

  //  [adaptor impl] void QWizard::fontChange(const QFont &)
  void cbs_fontChange_1801_0(const QFont &arg1)
  {
    QWizard::fontChange(arg1);
  }

  virtual void fontChange(const QFont &arg1)
  {
    if (cb_fontChange_1801_0.can_issue()) {
      cb_fontChange_1801_0.issue<QWizard_Adaptor, const QFont &>(&QWizard_Adaptor::cbs_fontChange_1801_0, arg1);
    } else {
      QWizard::fontChange(arg1);
    }
  }

  //  [emitter impl] void QWizard::helpRequested()
  void emitter_QWizard_helpRequested_0()
  {
    emit QWizard::helpRequested();
  }

  //  [adaptor impl] void QWizard::hideEvent(QHideEvent *)
  void cbs_hideEvent_1595_0(QHideEvent *arg1)
  {
    QWizard::hideEvent(arg1);
  }

  virtual void hideEvent(QHideEvent *arg1)
  {
    if (cb_hideEvent_1595_0.can_issue()) {
      cb_hideEvent_1595_0.issue<QWizard_Adaptor, QHideEvent *>(&QWizard_Adaptor::cbs_hideEvent_1595_0, arg1);
    } else {
      QWizard::hideEvent(arg1);
    }
  }

  //  [adaptor impl] void QWizard::initializePage(int id)
  void cbs_initializePage_767_0(int id)
  {
    QWizard::initializePage(id);
  }

  virtual void initializePage(int id)
  {
    if (cb_initializePage_767_0.can_issue()) {
      cb_initializePage_767_0.issue<QWizard_Adaptor, int>(&QWizard_Adaptor::cbs_initializePage_767_0, id);
    } else {
      QWizard::initializePage(id);
    }
  }

  //  [adaptor impl] void QWizard::inputMethodEvent(QInputMethodEvent *)
  void cbs_inputMethodEvent_2354_0(QInputMethodEvent *arg1)
  {
    QWizard::inputMethodEvent(arg1);
  }

  virtual void inputMethodEvent(QInputMethodEvent *arg1)
  {
    if (cb_inputMethodEvent_2354_0.can_issue()) {
      cb_inputMethodEvent_2354_0.issue<QWizard_Adaptor, QInputMethodEvent *>(&QWizard_Adaptor::cbs_inputMethodEvent_2354_0, arg1);
    } else {
      QWizard::inputMethodEvent(arg1);
    }
  }

  //  [adaptor impl] void QWizard::keyPressEvent(QKeyEvent *)
  void cbs_keyPressEvent_1514_0(QKeyEvent *arg1)
  {
    QWizard::keyPressEvent(arg1);
  }

  virtual void keyPressEvent(QKeyEvent *arg1)
  {
    if (cb_keyPressEvent_1514_0.can_issue()) {
      cb_keyPressEvent_1514_0.issue<QWizard_Adaptor, QKeyEvent *>(&QWizard_Adaptor::cbs_keyPressEvent_1514_0, arg1);
    } else {
      QWizard::keyPressEvent(arg1);
    }
  }

  //  [adaptor impl] void QWizard::keyReleaseEvent(QKeyEvent *)
  void cbs_keyReleaseEvent_1514_0(QKeyEvent *arg1)
  {
    QWizard::keyReleaseEvent(arg1);
  }

  virtual void keyReleaseEvent(QKeyEvent *arg1)
  {
    if (cb_keyReleaseEvent_1514_0.can_issue()) {
      cb_keyReleaseEvent_1514_0.issue<QWizard_Adaptor, QKeyEvent *>(&QWizard_Adaptor::cbs_keyReleaseEvent_1514_0, arg1);
    } else {
      QWizard::keyReleaseEvent(arg1);
    }
  }

  //  [adaptor impl] void QWizard::languageChange()
  void cbs_languageChange_0_0()
  {
    QWizard::languageChange();
  }

  virtual void languageChange()
  {
    if (cb_languageChange_0_0.can_issue()) {
      cb_languageChange_0_0.issue<QWizard_Adaptor>(&QWizard_Adaptor::cbs_languageChange_0_0);
    } else {
      QWizard::languageChange();
    }
  }

  //  [adaptor impl] void QWizard::leaveEvent(QEvent *)
  void cbs_leaveEvent_1217_0(QEvent *arg1)
  {
    QWizard::leaveEvent(arg1);
  }

  virtual void leaveEvent(QEvent *arg1)
  {
    if (cb_leaveEvent_1217_0.can_issue()) {
      cb_leaveEvent_1217_0.issue<QWizard_Adaptor, QEvent *>(&QWizard_Adaptor::cbs_leaveEvent_1217_0, arg1);
    } else {
      QWizard::leaveEvent(arg1);
    }
  }

  //  [adaptor impl] int QWizard::metric(QPaintDevice::PaintDeviceMetric)
  int cbs_metric_c3445_0(const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & arg1) const
  {
    return QWizard::metric(qt_gsi::QtToCppAdaptor<QPaintDevice::PaintDeviceMetric>(arg1).cref());
  }

  virtual int metric(QPaintDevice::PaintDeviceMetric arg1) const
  {
    if (cb_metric_c3445_0.can_issue()) {
      return cb_metric_c3445_0.issue<QWizard_Adaptor, int, const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type &>(&QWizard_Adaptor::cbs_metric_c3445_0, qt_gsi::CppToQtAdaptor<QPaintDevice::PaintDeviceMetric>(arg1));
    } else {
      return QWizard::metric(arg1);
    }
  }

  //  [adaptor impl] void QWizard::mouseDoubleClickEvent(QMouseEvent *)
  void cbs_mouseDoubleClickEvent_1738_0(QMouseEvent *arg1)
  {
    QWizard::mouseDoubleClickEvent(arg1);
  }

  virtual void mouseDoubleClickEvent(QMouseEvent *arg1)
  {
    if (cb_mouseDoubleClickEvent_1738_0.can_issue()) {
      cb_mouseDoubleClickEvent_1738_0.issue<QWizard_Adaptor, QMouseEvent *>(&QWizard_Adaptor::cbs_mouseDoubleClickEvent_1738_0, arg1);
    } else {
      QWizard::mouseDoubleClickEvent(arg1);
    }
  }

  //  [adaptor impl] void QWizard::mouseMoveEvent(QMouseEvent *)
  void cbs_mouseMoveEvent_1738_0(QMouseEvent *arg1)
  {
    QWizard::mouseMoveEvent(arg1);
  }

  virtual void mouseMoveEvent(QMouseEvent *arg1)
  {
    if (cb_mouseMoveEvent_1738_0.can_issue()) {
      cb_mouseMoveEvent_1738_0.issue<QWizard_Adaptor, QMouseEvent *>(&QWizard_Adaptor::cbs_mouseMoveEvent_1738_0, arg1);
    } else {
      QWizard::mouseMoveEvent(arg1);
    }
  }

  //  [adaptor impl] void QWizard::mousePressEvent(QMouseEvent *)
  void cbs_mousePressEvent_1738_0(QMouseEvent *arg1)
  {
    QWizard::mousePressEvent(arg1);
  }

  virtual void mousePressEvent(QMouseEvent *arg1)
  {
    if (cb_mousePressEvent_1738_0.can_issue()) {
      cb_mousePressEvent_1738_0.issue<QWizard_Adaptor, QMouseEvent *>(&QWizard_Adaptor::cbs_mousePressEvent_1738_0, arg1);
    } else {
      QWizard::mousePressEvent(arg1);
    }
  }

  //  [adaptor impl] void QWizard::mouseReleaseEvent(QMouseEvent *)
  void cbs_mouseReleaseEvent_1738_0(QMouseEvent *arg1)
  {
    QWizard::mouseReleaseEvent(arg1);
  }

  virtual void mouseReleaseEvent(QMouseEvent *arg1)
  {
    if (cb_mouseReleaseEvent_1738_0.can_issue()) {
      cb_mouseReleaseEvent_1738_0.issue<QWizard_Adaptor, QMouseEvent *>(&QWizard_Adaptor::cbs_mouseReleaseEvent_1738_0, arg1);
    } else {
      QWizard::mouseReleaseEvent(arg1);
    }
  }

  //  [adaptor impl] void QWizard::moveEvent(QMoveEvent *)
  void cbs_moveEvent_1624_0(QMoveEvent *arg1)
  {
    QWizard::moveEvent(arg1);
  }

  virtual void moveEvent(QMoveEvent *arg1)
  {
    if (cb_moveEvent_1624_0.can_issue()) {
      cb_moveEvent_1624_0.issue<QWizard_Adaptor, QMoveEvent *>(&QWizard_Adaptor::cbs_moveEvent_1624_0, arg1);
    } else {
      QWizard::moveEvent(arg1);
    }
  }

  //  [adaptor impl] void QWizard::paintEvent(QPaintEvent *event)
  void cbs_paintEvent_1725_0(QPaintEvent *event)
  {
    QWizard::paintEvent(event);
  }

  virtual void paintEvent(QPaintEvent *event)
  {
    if (cb_paintEvent_1725_0.can_issue()) {
      cb_paintEvent_1725_0.issue<QWizard_Adaptor, QPaintEvent *>(&QWizard_Adaptor::cbs_paintEvent_1725_0, event);
    } else {
      QWizard::paintEvent(event);
    }
  }

  //  [adaptor impl] void QWizard::paletteChange(const QPalette &)
  void cbs_paletteChange_2113_0(const QPalette &arg1)
  {
    QWizard::paletteChange(arg1);
  }

  virtual void paletteChange(const QPalette &arg1)
  {
    if (cb_paletteChange_2113_0.can_issue()) {
      cb_paletteChange_2113_0.issue<QWizard_Adaptor, const QPalette &>(&QWizard_Adaptor::cbs_paletteChange_2113_0, arg1);
    } else {
      QWizard::paletteChange(arg1);
    }
  }

  //  [emitter impl] void QWizard::rejected()
  void emitter_QWizard_rejected_0()
  {
    emit QWizard::rejected();
  }

  //  [adaptor impl] void QWizard::resizeEvent(QResizeEvent *event)
  void cbs_resizeEvent_1843_0(QResizeEvent *event)
  {
    QWizard::resizeEvent(event);
  }

  virtual void resizeEvent(QResizeEvent *event)
  {
    if (cb_resizeEvent_1843_0.can_issue()) {
      cb_resizeEvent_1843_0.issue<QWizard_Adaptor, QResizeEvent *>(&QWizard_Adaptor::cbs_resizeEvent_1843_0, event);
    } else {
      QWizard::resizeEvent(event);
    }
  }

  //  [adaptor impl] void QWizard::showEvent(QShowEvent *)
  void cbs_showEvent_1634_0(QShowEvent *arg1)
  {
    QWizard::showEvent(arg1);
  }

  virtual void showEvent(QShowEvent *arg1)
  {
    if (cb_showEvent_1634_0.can_issue()) {
      cb_showEvent_1634_0.issue<QWizard_Adaptor, QShowEvent *>(&QWizard_Adaptor::cbs_showEvent_1634_0, arg1);
    } else {
      QWizard::showEvent(arg1);
    }
  }

  //  [adaptor impl] void QWizard::styleChange(QStyle &)
  void cbs_styleChange_1228_0(QStyle &arg1)
  {
    QWizard::styleChange(arg1);
  }

  virtual void styleChange(QStyle &arg1)
  {
    if (cb_styleChange_1228_0.can_issue()) {
      cb_styleChange_1228_0.issue<QWizard_Adaptor, QStyle &>(&QWizard_Adaptor::cbs_styleChange_1228_0, arg1);
    } else {
      QWizard::styleChange(arg1);
    }
  }

  //  [adaptor impl] void QWizard::tabletEvent(QTabletEvent *)
  void cbs_tabletEvent_1821_0(QTabletEvent *arg1)
  {
    QWizard::tabletEvent(arg1);
  }

  virtual void tabletEvent(QTabletEvent *arg1)
  {
    if (cb_tabletEvent_1821_0.can_issue()) {
      cb_tabletEvent_1821_0.issue<QWizard_Adaptor, QTabletEvent *>(&QWizard_Adaptor::cbs_tabletEvent_1821_0, arg1);
    } else {
      QWizard::tabletEvent(arg1);
    }
  }

  //  [adaptor impl] void QWizard::timerEvent(QTimerEvent *)
  void cbs_timerEvent_1730_0(QTimerEvent *arg1)
  {
    QWizard::timerEvent(arg1);
  }

  virtual void timerEvent(QTimerEvent *arg1)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QWizard_Adaptor, QTimerEvent *>(&QWizard_Adaptor::cbs_timerEvent_1730_0, arg1);
    } else {
      QWizard::timerEvent(arg1);
    }
  }

  //  [adaptor impl] void QWizard::wheelEvent(QWheelEvent *)
  void cbs_wheelEvent_1718_0(QWheelEvent *arg1)
  {
    QWizard::wheelEvent(arg1);
  }

  virtual void wheelEvent(QWheelEvent *arg1)
  {
    if (cb_wheelEvent_1718_0.can_issue()) {
      cb_wheelEvent_1718_0.issue<QWizard_Adaptor, QWheelEvent *>(&QWizard_Adaptor::cbs_wheelEvent_1718_0, arg1);
    } else {
      QWizard::wheelEvent(arg1);
    }
  }

  //  [adaptor impl] void QWizard::windowActivationChange(bool)
  void cbs_windowActivationChange_864_0(bool arg1)
  {
    QWizard::windowActivationChange(arg1);
  }

  virtual void windowActivationChange(bool arg1)
  {
    if (cb_windowActivationChange_864_0.can_issue()) {
      cb_windowActivationChange_864_0.issue<QWizard_Adaptor, bool>(&QWizard_Adaptor::cbs_windowActivationChange_864_0, arg1);
    } else {
      QWizard::windowActivationChange(arg1);
    }
  }

  gsi::Callback cb_accept_0_0;
  gsi::Callback cb_heightForWidth_c767_0;
  gsi::Callback cb_inputMethodQuery_c2420_0;
  gsi::Callback cb_minimumSizeHint_c0_0;
  gsi::Callback cb_nextId_c0_0;
  gsi::Callback cb_paintEngine_c0_0;
  gsi::Callback cb_reject_0_0;
  gsi::Callback cb_setVisible_864_0;
  gsi::Callback cb_sizeHint_c0_0;
  gsi::Callback cb_validateCurrentPage_0_0;
  gsi::Callback cb_actionEvent_1823_0;
  gsi::Callback cb_changeEvent_1217_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_cleanupPage_767_0;
  gsi::Callback cb_closeEvent_1719_0;
  gsi::Callback cb_contextMenuEvent_2363_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_1731_0;
  gsi::Callback cb_done_767_0;
  gsi::Callback cb_dragEnterEvent_2109_0;
  gsi::Callback cb_dragLeaveEvent_2092_0;
  gsi::Callback cb_dragMoveEvent_2006_0;
  gsi::Callback cb_dropEvent_1622_0;
  gsi::Callback cb_enabledChange_864_0;
  gsi::Callback cb_enterEvent_1217_0;
  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_focusInEvent_1729_0;
  gsi::Callback cb_focusNextPrevChild_864_0;
  gsi::Callback cb_focusOutEvent_1729_0;
  gsi::Callback cb_fontChange_1801_0;
  gsi::Callback cb_hideEvent_1595_0;
  gsi::Callback cb_initializePage_767_0;
  gsi::Callback cb_inputMethodEvent_2354_0;
  gsi::Callback cb_keyPressEvent_1514_0;
  gsi::Callback cb_keyReleaseEvent_1514_0;
  gsi::Callback cb_languageChange_0_0;
  gsi::Callback cb_leaveEvent_1217_0;
  gsi::Callback cb_metric_c3445_0;
  gsi::Callback cb_mouseDoubleClickEvent_1738_0;
  gsi::Callback cb_mouseMoveEvent_1738_0;
  gsi::Callback cb_mousePressEvent_1738_0;
  gsi::Callback cb_mouseReleaseEvent_1738_0;
  gsi::Callback cb_moveEvent_1624_0;
  gsi::Callback cb_paintEvent_1725_0;
  gsi::Callback cb_paletteChange_2113_0;
  gsi::Callback cb_resizeEvent_1843_0;
  gsi::Callback cb_showEvent_1634_0;
  gsi::Callback cb_styleChange_1228_0;
  gsi::Callback cb_tabletEvent_1821_0;
  gsi::Callback cb_timerEvent_1730_0;
  gsi::Callback cb_wheelEvent_1718_0;
  gsi::Callback cb_windowActivationChange_864_0;
};

QWizard_Adaptor::~QWizard_Adaptor() { }

//  Constructor QWizard::QWizard(QWidget *parent, QFlags<Qt::WindowType> flags) (adaptor class)

static void _init_ctor_QWizard_Adaptor_3702 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "0");
  decl->add_arg<QWidget * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("flags", true, "0");
  decl->add_arg<QFlags<Qt::WindowType> > (argspec_1);
  decl->set_return_new<QWizard_Adaptor> ();
}

static void _call_ctor_QWizard_Adaptor_3702 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWidget *arg1 = args ? gsi::arg_reader<QWidget * >() (args, heap) : gsi::arg_maker<QWidget * >() (0, heap);
  QFlags<Qt::WindowType> arg2 = args ? gsi::arg_reader<QFlags<Qt::WindowType> >() (args, heap) : gsi::arg_maker<QFlags<Qt::WindowType> >() (0, heap);
  ret.write<QWizard_Adaptor *> (new QWizard_Adaptor (arg1, arg2));
}


// void QWizard::accept()

static void _init_cbs_accept_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_accept_0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWizard_Adaptor *)cls)->cbs_accept_0_0 ();
}

static void _set_callback_cbs_accept_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QWizard_Adaptor *)cls)->cb_accept_0_0 = cb;
}


// emitter void QWizard::accepted()

static void _init_emitter_accepted_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_accepted_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QWizard_Adaptor *)cls)->emitter_QWizard_accepted_0 ();
}


// void QWizard::actionEvent(QActionEvent *)

static void _init_cbs_actionEvent_1823_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QActionEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_actionEvent_1823_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QActionEvent *arg1 = args.read<QActionEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWizard_Adaptor *)cls)->cbs_actionEvent_1823_0 (arg1);
}

static void _set_callback_cbs_actionEvent_1823_0 (void *cls, const gsi::Callback &cb)
{
  ((QWizard_Adaptor *)cls)->cb_actionEvent_1823_0 = cb;
}


// exposed void QWizard::adjustPosition(QWidget *)

static void _init_fp_adjustPosition_1315 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QWidget * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_adjustPosition_1315 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWidget *arg1 = gsi::arg_reader<QWidget * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWizard_Adaptor *)cls)->fp_QWizard_adjustPosition_1315 (arg1);
}


// void QWizard::changeEvent(QEvent *)

static void _init_cbs_changeEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_changeEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWizard_Adaptor *)cls)->cbs_changeEvent_1217_0 (arg1);
}

static void _set_callback_cbs_changeEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QWizard_Adaptor *)cls)->cb_changeEvent_1217_0 = cb;
}


// void QWizard::childEvent(QChildEvent *)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QChildEvent *arg1 = args.read<QChildEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWizard_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QWizard_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}


// void QWizard::cleanupPage(int id)

static void _init_cbs_cleanupPage_767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("id");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_cleanupPage_767_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWizard_Adaptor *)cls)->cbs_cleanupPage_767_0 (arg1);
}

static void _set_callback_cbs_cleanupPage_767_0 (void *cls, const gsi::Callback &cb)
{
  ((QWizard_Adaptor *)cls)->cb_cleanupPage_767_0 = cb;
}


// void QWizard::closeEvent(QCloseEvent *)

static void _init_cbs_closeEvent_1719_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QCloseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_closeEvent_1719_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QCloseEvent *arg1 = args.read<QCloseEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWizard_Adaptor *)cls)->cbs_closeEvent_1719_0 (arg1);
}

static void _set_callback_cbs_closeEvent_1719_0 (void *cls, const gsi::Callback &cb)
{
  ((QWizard_Adaptor *)cls)->cb_closeEvent_1719_0 = cb;
}


// void QWizard::contextMenuEvent(QContextMenuEvent *)

static void _init_cbs_contextMenuEvent_2363_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QContextMenuEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_contextMenuEvent_2363_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QContextMenuEvent *arg1 = args.read<QContextMenuEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWizard_Adaptor *)cls)->cbs_contextMenuEvent_2363_0 (arg1);
}

static void _set_callback_cbs_contextMenuEvent_2363_0 (void *cls, const gsi::Callback &cb)
{
  ((QWizard_Adaptor *)cls)->cb_contextMenuEvent_2363_0 = cb;
}


// exposed void QWizard::create(WId, bool initializeWindow, bool destroyOldWindow)

static void _init_fp_create_2208 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1", true, "0");
  decl->add_arg<const qt_gsi::Converter<WId>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("initializeWindow", true, "true");
  decl->add_arg<bool > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("destroyOldWindow", true, "true");
  decl->add_arg<bool > (argspec_2);
  decl->set_return<void > ();
}

static void _call_fp_create_2208 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<WId>::target_type & arg1 = args ? gsi::arg_reader<const qt_gsi::Converter<WId>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<WId>::target_type & >() (qt_gsi::CppToQtReadAdaptor<WId>(heap, 0), heap);
  bool arg2 = args ? gsi::arg_reader<bool >() (args, heap) : gsi::arg_maker<bool >() (true, heap);
  bool arg3 = args ? gsi::arg_reader<bool >() (args, heap) : gsi::arg_maker<bool >() (true, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWizard_Adaptor *)cls)->fp_QWizard_create_2208 (arg1, arg2, arg3);
}


// emitter void QWizard::currentIdChanged(int id)

static void _init_emitter_currentIdChanged_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("id");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_currentIdChanged_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ((QWizard_Adaptor *)cls)->emitter_QWizard_currentIdChanged_767 (arg1);
}


// emitter void QWizard::customButtonClicked(int which)

static void _init_emitter_customButtonClicked_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("which");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_customButtonClicked_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ((QWizard_Adaptor *)cls)->emitter_QWizard_customButtonClicked_767 (arg1);
}


// emitter void QWizard::customContextMenuRequested(const QPoint &pos)

static void _init_emitter_customContextMenuRequested_1916 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pos");
  decl->add_arg<const QPoint & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_customContextMenuRequested_1916 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPoint &arg1 = gsi::arg_reader<const QPoint & >() (args, heap);
  ((QWizard_Adaptor *)cls)->emitter_QWizard_customContextMenuRequested_1916 (arg1);
}


// void QWizard::customEvent(QEvent *)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWizard_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QWizard_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}


// exposed void QWizard::destroy(bool destroyWindow, bool destroySubWindows)

static void _init_fp_destroy_1620 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("destroyWindow", true, "true");
  decl->add_arg<bool > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("destroySubWindows", true, "true");
  decl->add_arg<bool > (argspec_1);
  decl->set_return<void > ();
}

static void _call_fp_destroy_1620 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = args ? gsi::arg_reader<bool >() (args, heap) : gsi::arg_maker<bool >() (true, heap);
  bool arg2 = args ? gsi::arg_reader<bool >() (args, heap) : gsi::arg_maker<bool >() (true, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWizard_Adaptor *)cls)->fp_QWizard_destroy_1620 (arg1, arg2);
}


// emitter void QWizard::destroyed(QObject *)

static void _init_emitter_destroyed_1302 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1", true, "0");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_destroyed_1302 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (0, heap);
  ((QWizard_Adaptor *)cls)->emitter_QWizard_destroyed_1302 (arg1);
}


// void QWizard::disconnectNotify(const char *signal)

static void _init_cbs_disconnectNotify_1731_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_1731_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = args.read<const char * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWizard_Adaptor *)cls)->cbs_disconnectNotify_1731_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_1731_0 (void *cls, const gsi::Callback &cb)
{
  ((QWizard_Adaptor *)cls)->cb_disconnectNotify_1731_0 = cb;
}


// void QWizard::done(int result)

static void _init_cbs_done_767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("result");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_done_767_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWizard_Adaptor *)cls)->cbs_done_767_0 (arg1);
}

static void _set_callback_cbs_done_767_0 (void *cls, const gsi::Callback &cb)
{
  ((QWizard_Adaptor *)cls)->cb_done_767_0 = cb;
}


// void QWizard::dragEnterEvent(QDragEnterEvent *)

static void _init_cbs_dragEnterEvent_2109_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QDragEnterEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dragEnterEvent_2109_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QDragEnterEvent *arg1 = args.read<QDragEnterEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWizard_Adaptor *)cls)->cbs_dragEnterEvent_2109_0 (arg1);
}

static void _set_callback_cbs_dragEnterEvent_2109_0 (void *cls, const gsi::Callback &cb)
{
  ((QWizard_Adaptor *)cls)->cb_dragEnterEvent_2109_0 = cb;
}


// void QWizard::dragLeaveEvent(QDragLeaveEvent *)

static void _init_cbs_dragLeaveEvent_2092_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QDragLeaveEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dragLeaveEvent_2092_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QDragLeaveEvent *arg1 = args.read<QDragLeaveEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWizard_Adaptor *)cls)->cbs_dragLeaveEvent_2092_0 (arg1);
}

static void _set_callback_cbs_dragLeaveEvent_2092_0 (void *cls, const gsi::Callback &cb)
{
  ((QWizard_Adaptor *)cls)->cb_dragLeaveEvent_2092_0 = cb;
}


// void QWizard::dragMoveEvent(QDragMoveEvent *)

static void _init_cbs_dragMoveEvent_2006_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QDragMoveEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dragMoveEvent_2006_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QDragMoveEvent *arg1 = args.read<QDragMoveEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWizard_Adaptor *)cls)->cbs_dragMoveEvent_2006_0 (arg1);
}

static void _set_callback_cbs_dragMoveEvent_2006_0 (void *cls, const gsi::Callback &cb)
{
  ((QWizard_Adaptor *)cls)->cb_dragMoveEvent_2006_0 = cb;
}


// void QWizard::dropEvent(QDropEvent *)

static void _init_cbs_dropEvent_1622_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QDropEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dropEvent_1622_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QDropEvent *arg1 = args.read<QDropEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWizard_Adaptor *)cls)->cbs_dropEvent_1622_0 (arg1);
}

static void _set_callback_cbs_dropEvent_1622_0 (void *cls, const gsi::Callback &cb)
{
  ((QWizard_Adaptor *)cls)->cb_dropEvent_1622_0 = cb;
}


// void QWizard::enabledChange(bool)

static void _init_cbs_enabledChange_864_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_enabledChange_864_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = args.read<bool > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWizard_Adaptor *)cls)->cbs_enabledChange_864_0 (arg1);
}

static void _set_callback_cbs_enabledChange_864_0 (void *cls, const gsi::Callback &cb)
{
  ((QWizard_Adaptor *)cls)->cb_enabledChange_864_0 = cb;
}


// void QWizard::enterEvent(QEvent *)

static void _init_cbs_enterEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_enterEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWizard_Adaptor *)cls)->cbs_enterEvent_1217_0 (arg1);
}

static void _set_callback_cbs_enterEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QWizard_Adaptor *)cls)->cb_enterEvent_1217_0 = cb;
}


// bool QWizard::event(QEvent *event)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QWizard_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QWizard_Adaptor *)cls)->cb_event_1217_0 = cb;
}


// bool QWizard::eventFilter(QObject *, QEvent *)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args.read<QObject * > (heap);
  QEvent *arg2 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QWizard_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QWizard_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}


// emitter void QWizard::finished(int result)

static void _init_emitter_finished_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("result");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_finished_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ((QWizard_Adaptor *)cls)->emitter_QWizard_finished_767 (arg1);
}


// void QWizard::focusInEvent(QFocusEvent *)

static void _init_cbs_focusInEvent_1729_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QFocusEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_focusInEvent_1729_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFocusEvent *arg1 = args.read<QFocusEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWizard_Adaptor *)cls)->cbs_focusInEvent_1729_0 (arg1);
}

static void _set_callback_cbs_focusInEvent_1729_0 (void *cls, const gsi::Callback &cb)
{
  ((QWizard_Adaptor *)cls)->cb_focusInEvent_1729_0 = cb;
}


// exposed bool QWizard::focusNextChild()

static void _init_fp_focusNextChild_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_fp_focusNextChild_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QWizard_Adaptor *)cls)->fp_QWizard_focusNextChild_0 ());
}


// bool QWizard::focusNextPrevChild(bool next)

static void _init_cbs_focusNextPrevChild_864_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("next");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_focusNextPrevChild_864_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = args.read<bool > (heap);
  ret.write<bool > ((bool)((QWizard_Adaptor *)cls)->cbs_focusNextPrevChild_864_0 (arg1));
}

static void _set_callback_cbs_focusNextPrevChild_864_0 (void *cls, const gsi::Callback &cb)
{
  ((QWizard_Adaptor *)cls)->cb_focusNextPrevChild_864_0 = cb;
}


// void QWizard::focusOutEvent(QFocusEvent *)

static void _init_cbs_focusOutEvent_1729_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QFocusEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_focusOutEvent_1729_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFocusEvent *arg1 = args.read<QFocusEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWizard_Adaptor *)cls)->cbs_focusOutEvent_1729_0 (arg1);
}

static void _set_callback_cbs_focusOutEvent_1729_0 (void *cls, const gsi::Callback &cb)
{
  ((QWizard_Adaptor *)cls)->cb_focusOutEvent_1729_0 = cb;
}


// exposed bool QWizard::focusPreviousChild()

static void _init_fp_focusPreviousChild_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_fp_focusPreviousChild_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QWizard_Adaptor *)cls)->fp_QWizard_focusPreviousChild_0 ());
}


// void QWizard::fontChange(const QFont &)

static void _init_cbs_fontChange_1801_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QFont & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_fontChange_1801_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QFont &arg1 = args.read<const QFont & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWizard_Adaptor *)cls)->cbs_fontChange_1801_0 (arg1);
}

static void _set_callback_cbs_fontChange_1801_0 (void *cls, const gsi::Callback &cb)
{
  ((QWizard_Adaptor *)cls)->cb_fontChange_1801_0 = cb;
}


// int QWizard::heightForWidth(int)

static void _init_cbs_heightForWidth_c767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<int > (argspec_0);
  decl->set_return<int > ();
}

static void _call_cbs_heightForWidth_c767_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  ret.write<int > ((int)((QWizard_Adaptor *)cls)->cbs_heightForWidth_c767_0 (arg1));
}

static void _set_callback_cbs_heightForWidth_c767_0 (void *cls, const gsi::Callback &cb)
{
  ((QWizard_Adaptor *)cls)->cb_heightForWidth_c767_0 = cb;
}


// emitter void QWizard::helpRequested()

static void _init_emitter_helpRequested_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_helpRequested_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QWizard_Adaptor *)cls)->emitter_QWizard_helpRequested_0 ();
}


// void QWizard::hideEvent(QHideEvent *)

static void _init_cbs_hideEvent_1595_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QHideEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_hideEvent_1595_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QHideEvent *arg1 = args.read<QHideEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWizard_Adaptor *)cls)->cbs_hideEvent_1595_0 (arg1);
}

static void _set_callback_cbs_hideEvent_1595_0 (void *cls, const gsi::Callback &cb)
{
  ((QWizard_Adaptor *)cls)->cb_hideEvent_1595_0 = cb;
}


// void QWizard::initializePage(int id)

static void _init_cbs_initializePage_767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("id");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_initializePage_767_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWizard_Adaptor *)cls)->cbs_initializePage_767_0 (arg1);
}

static void _set_callback_cbs_initializePage_767_0 (void *cls, const gsi::Callback &cb)
{
  ((QWizard_Adaptor *)cls)->cb_initializePage_767_0 = cb;
}


// void QWizard::inputMethodEvent(QInputMethodEvent *)

static void _init_cbs_inputMethodEvent_2354_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QInputMethodEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_inputMethodEvent_2354_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QInputMethodEvent *arg1 = args.read<QInputMethodEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWizard_Adaptor *)cls)->cbs_inputMethodEvent_2354_0 (arg1);
}

static void _set_callback_cbs_inputMethodEvent_2354_0 (void *cls, const gsi::Callback &cb)
{
  ((QWizard_Adaptor *)cls)->cb_inputMethodEvent_2354_0 = cb;
}


// QVariant QWizard::inputMethodQuery(Qt::InputMethodQuery)

static void _init_cbs_inputMethodQuery_c2420_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & > (argspec_0);
  decl->set_return<QVariant > ();
}

static void _call_cbs_inputMethodQuery_c2420_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & arg1 = args.read<const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & > (heap);
  ret.write<QVariant > ((QVariant)((QWizard_Adaptor *)cls)->cbs_inputMethodQuery_c2420_0 (arg1));
}

static void _set_callback_cbs_inputMethodQuery_c2420_0 (void *cls, const gsi::Callback &cb)
{
  ((QWizard_Adaptor *)cls)->cb_inputMethodQuery_c2420_0 = cb;
}


// void QWizard::keyPressEvent(QKeyEvent *)

static void _init_cbs_keyPressEvent_1514_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QKeyEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_keyPressEvent_1514_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QKeyEvent *arg1 = args.read<QKeyEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWizard_Adaptor *)cls)->cbs_keyPressEvent_1514_0 (arg1);
}

static void _set_callback_cbs_keyPressEvent_1514_0 (void *cls, const gsi::Callback &cb)
{
  ((QWizard_Adaptor *)cls)->cb_keyPressEvent_1514_0 = cb;
}


// void QWizard::keyReleaseEvent(QKeyEvent *)

static void _init_cbs_keyReleaseEvent_1514_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QKeyEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_keyReleaseEvent_1514_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QKeyEvent *arg1 = args.read<QKeyEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWizard_Adaptor *)cls)->cbs_keyReleaseEvent_1514_0 (arg1);
}

static void _set_callback_cbs_keyReleaseEvent_1514_0 (void *cls, const gsi::Callback &cb)
{
  ((QWizard_Adaptor *)cls)->cb_keyReleaseEvent_1514_0 = cb;
}


// void QWizard::languageChange()

static void _init_cbs_languageChange_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_languageChange_0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWizard_Adaptor *)cls)->cbs_languageChange_0_0 ();
}

static void _set_callback_cbs_languageChange_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QWizard_Adaptor *)cls)->cb_languageChange_0_0 = cb;
}


// void QWizard::leaveEvent(QEvent *)

static void _init_cbs_leaveEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_leaveEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWizard_Adaptor *)cls)->cbs_leaveEvent_1217_0 (arg1);
}

static void _set_callback_cbs_leaveEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QWizard_Adaptor *)cls)->cb_leaveEvent_1217_0 = cb;
}


// int QWizard::metric(QPaintDevice::PaintDeviceMetric)

static void _init_cbs_metric_c3445_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & > (argspec_0);
  decl->set_return<int > ();
}

static void _call_cbs_metric_c3445_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & arg1 = args.read<const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & > (heap);
  ret.write<int > ((int)((QWizard_Adaptor *)cls)->cbs_metric_c3445_0 (arg1));
}

static void _set_callback_cbs_metric_c3445_0 (void *cls, const gsi::Callback &cb)
{
  ((QWizard_Adaptor *)cls)->cb_metric_c3445_0 = cb;
}


// QSize QWizard::minimumSizeHint()

static void _init_cbs_minimumSizeHint_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_cbs_minimumSizeHint_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QSize > ((QSize)((QWizard_Adaptor *)cls)->cbs_minimumSizeHint_c0_0 ());
}

static void _set_callback_cbs_minimumSizeHint_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QWizard_Adaptor *)cls)->cb_minimumSizeHint_c0_0 = cb;
}


// void QWizard::mouseDoubleClickEvent(QMouseEvent *)

static void _init_cbs_mouseDoubleClickEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mouseDoubleClickEvent_1738_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QMouseEvent *arg1 = args.read<QMouseEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWizard_Adaptor *)cls)->cbs_mouseDoubleClickEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mouseDoubleClickEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QWizard_Adaptor *)cls)->cb_mouseDoubleClickEvent_1738_0 = cb;
}


// void QWizard::mouseMoveEvent(QMouseEvent *)

static void _init_cbs_mouseMoveEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mouseMoveEvent_1738_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QMouseEvent *arg1 = args.read<QMouseEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWizard_Adaptor *)cls)->cbs_mouseMoveEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mouseMoveEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QWizard_Adaptor *)cls)->cb_mouseMoveEvent_1738_0 = cb;
}


// void QWizard::mousePressEvent(QMouseEvent *)

static void _init_cbs_mousePressEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mousePressEvent_1738_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QMouseEvent *arg1 = args.read<QMouseEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWizard_Adaptor *)cls)->cbs_mousePressEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mousePressEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QWizard_Adaptor *)cls)->cb_mousePressEvent_1738_0 = cb;
}


// void QWizard::mouseReleaseEvent(QMouseEvent *)

static void _init_cbs_mouseReleaseEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mouseReleaseEvent_1738_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QMouseEvent *arg1 = args.read<QMouseEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWizard_Adaptor *)cls)->cbs_mouseReleaseEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mouseReleaseEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QWizard_Adaptor *)cls)->cb_mouseReleaseEvent_1738_0 = cb;
}


// void QWizard::moveEvent(QMoveEvent *)

static void _init_cbs_moveEvent_1624_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QMoveEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_moveEvent_1624_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QMoveEvent *arg1 = args.read<QMoveEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWizard_Adaptor *)cls)->cbs_moveEvent_1624_0 (arg1);
}

static void _set_callback_cbs_moveEvent_1624_0 (void *cls, const gsi::Callback &cb)
{
  ((QWizard_Adaptor *)cls)->cb_moveEvent_1624_0 = cb;
}


// int QWizard::nextId()

static void _init_cbs_nextId_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_cbs_nextId_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QWizard_Adaptor *)cls)->cbs_nextId_c0_0 ());
}

static void _set_callback_cbs_nextId_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QWizard_Adaptor *)cls)->cb_nextId_c0_0 = cb;
}


// QPaintEngine *QWizard::paintEngine()

static void _init_cbs_paintEngine_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPaintEngine * > ();
}

static void _call_cbs_paintEngine_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QPaintEngine * > ((QPaintEngine *)((QWizard_Adaptor *)cls)->cbs_paintEngine_c0_0 ());
}

static void _set_callback_cbs_paintEngine_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QWizard_Adaptor *)cls)->cb_paintEngine_c0_0 = cb;
}


// void QWizard::paintEvent(QPaintEvent *event)

static void _init_cbs_paintEvent_1725_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QPaintEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_paintEvent_1725_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QPaintEvent *arg1 = args.read<QPaintEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWizard_Adaptor *)cls)->cbs_paintEvent_1725_0 (arg1);
}

static void _set_callback_cbs_paintEvent_1725_0 (void *cls, const gsi::Callback &cb)
{
  ((QWizard_Adaptor *)cls)->cb_paintEvent_1725_0 = cb;
}


// void QWizard::paletteChange(const QPalette &)

static void _init_cbs_paletteChange_2113_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QPalette & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_paletteChange_2113_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPalette &arg1 = args.read<const QPalette & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWizard_Adaptor *)cls)->cbs_paletteChange_2113_0 (arg1);
}

static void _set_callback_cbs_paletteChange_2113_0 (void *cls, const gsi::Callback &cb)
{
  ((QWizard_Adaptor *)cls)->cb_paletteChange_2113_0 = cb;
}


// exposed int QWizard::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  ret.write<int > ((int)((QWizard_Adaptor *)cls)->fp_QWizard_receivers_c1731 (arg1));
}


// void QWizard::reject()

static void _init_cbs_reject_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_reject_0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWizard_Adaptor *)cls)->cbs_reject_0_0 ();
}

static void _set_callback_cbs_reject_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QWizard_Adaptor *)cls)->cb_reject_0_0 = cb;
}


// emitter void QWizard::rejected()

static void _init_emitter_rejected_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_rejected_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QWizard_Adaptor *)cls)->emitter_QWizard_rejected_0 ();
}


// exposed void QWizard::resetInputContext()

static void _init_fp_resetInputContext_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_resetInputContext_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWizard_Adaptor *)cls)->fp_QWizard_resetInputContext_0 ();
}


// void QWizard::resizeEvent(QResizeEvent *event)

static void _init_cbs_resizeEvent_1843_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QResizeEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_resizeEvent_1843_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QResizeEvent *arg1 = args.read<QResizeEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWizard_Adaptor *)cls)->cbs_resizeEvent_1843_0 (arg1);
}

static void _set_callback_cbs_resizeEvent_1843_0 (void *cls, const gsi::Callback &cb)
{
  ((QWizard_Adaptor *)cls)->cb_resizeEvent_1843_0 = cb;
}


// exposed QObject *QWizard::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QObject * > ((QObject *)((QWizard_Adaptor *)cls)->fp_QWizard_sender_c0 ());
}


// void QWizard::setVisible(bool visible)

static void _init_cbs_setVisible_864_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("visible");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setVisible_864_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = args.read<bool > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWizard_Adaptor *)cls)->cbs_setVisible_864_0 (arg1);
}

static void _set_callback_cbs_setVisible_864_0 (void *cls, const gsi::Callback &cb)
{
  ((QWizard_Adaptor *)cls)->cb_setVisible_864_0 = cb;
}


// void QWizard::showEvent(QShowEvent *)

static void _init_cbs_showEvent_1634_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QShowEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_showEvent_1634_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QShowEvent *arg1 = args.read<QShowEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWizard_Adaptor *)cls)->cbs_showEvent_1634_0 (arg1);
}

static void _set_callback_cbs_showEvent_1634_0 (void *cls, const gsi::Callback &cb)
{
  ((QWizard_Adaptor *)cls)->cb_showEvent_1634_0 = cb;
}


// QSize QWizard::sizeHint()

static void _init_cbs_sizeHint_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_cbs_sizeHint_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QSize > ((QSize)((QWizard_Adaptor *)cls)->cbs_sizeHint_c0_0 ());
}

static void _set_callback_cbs_sizeHint_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QWizard_Adaptor *)cls)->cb_sizeHint_c0_0 = cb;
}


// void QWizard::styleChange(QStyle &)

static void _init_cbs_styleChange_1228_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QStyle & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_styleChange_1228_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QStyle &arg1 = args.read<QStyle & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWizard_Adaptor *)cls)->cbs_styleChange_1228_0 (arg1);
}

static void _set_callback_cbs_styleChange_1228_0 (void *cls, const gsi::Callback &cb)
{
  ((QWizard_Adaptor *)cls)->cb_styleChange_1228_0 = cb;
}


// void QWizard::tabletEvent(QTabletEvent *)

static void _init_cbs_tabletEvent_1821_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QTabletEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_tabletEvent_1821_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTabletEvent *arg1 = args.read<QTabletEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWizard_Adaptor *)cls)->cbs_tabletEvent_1821_0 (arg1);
}

static void _set_callback_cbs_tabletEvent_1821_0 (void *cls, const gsi::Callback &cb)
{
  ((QWizard_Adaptor *)cls)->cb_tabletEvent_1821_0 = cb;
}


// void QWizard::timerEvent(QTimerEvent *)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTimerEvent *arg1 = args.read<QTimerEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWizard_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QWizard_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}


// exposed void QWizard::updateMicroFocus()

static void _init_fp_updateMicroFocus_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_updateMicroFocus_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWizard_Adaptor *)cls)->fp_QWizard_updateMicroFocus_0 ();
}


// bool QWizard::validateCurrentPage()

static void _init_cbs_validateCurrentPage_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_cbs_validateCurrentPage_0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QWizard_Adaptor *)cls)->cbs_validateCurrentPage_0_0 ());
}

static void _set_callback_cbs_validateCurrentPage_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QWizard_Adaptor *)cls)->cb_validateCurrentPage_0_0 = cb;
}


// void QWizard::wheelEvent(QWheelEvent *)

static void _init_cbs_wheelEvent_1718_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QWheelEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_wheelEvent_1718_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWheelEvent *arg1 = args.read<QWheelEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWizard_Adaptor *)cls)->cbs_wheelEvent_1718_0 (arg1);
}

static void _set_callback_cbs_wheelEvent_1718_0 (void *cls, const gsi::Callback &cb)
{
  ((QWizard_Adaptor *)cls)->cb_wheelEvent_1718_0 = cb;
}


// void QWizard::windowActivationChange(bool)

static void _init_cbs_windowActivationChange_864_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_windowActivationChange_864_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = args.read<bool > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWizard_Adaptor *)cls)->cbs_windowActivationChange_864_0 (arg1);
}

static void _set_callback_cbs_windowActivationChange_864_0 (void *cls, const gsi::Callback &cb)
{
  ((QWizard_Adaptor *)cls)->cb_windowActivationChange_864_0 = cb;
}


namespace gsi
{

gsi::Class<QWizard> &qtdecl_QWizard ();

static gsi::Methods methods_QWizard_Adaptor () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QWizard::QWizard(QWidget *parent, QFlags<Qt::WindowType> flags)\nThis method creates an object of class QWizard.", &_init_ctor_QWizard_Adaptor_3702, &_call_ctor_QWizard_Adaptor_3702);
  methods += new qt_gsi::GenericMethod ("accept", "@brief Virtual method void QWizard::accept()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_accept_0_0, &_call_cbs_accept_0_0);
  methods += new qt_gsi::GenericMethod ("accept", "@hide", false, &_init_cbs_accept_0_0, &_call_cbs_accept_0_0, &_set_callback_cbs_accept_0_0);
  methods += new qt_gsi::GenericMethod ("emit_accepted", "@brief Emitter for signal void QWizard::accepted()\nCall this method to emit this signal.", false, &_init_emitter_accepted_0, &_call_emitter_accepted_0);
  methods += new qt_gsi::GenericMethod ("*actionEvent", "@brief Virtual method void QWizard::actionEvent(QActionEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_actionEvent_1823_0, &_call_cbs_actionEvent_1823_0);
  methods += new qt_gsi::GenericMethod ("*actionEvent", "@hide", false, &_init_cbs_actionEvent_1823_0, &_call_cbs_actionEvent_1823_0, &_set_callback_cbs_actionEvent_1823_0);
  methods += new qt_gsi::GenericMethod ("*adjustPosition", "@brief Method void QWizard::adjustPosition(QWidget *)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_adjustPosition_1315, &_call_fp_adjustPosition_1315);
  methods += new qt_gsi::GenericMethod ("*changeEvent", "@brief Virtual method void QWizard::changeEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_changeEvent_1217_0, &_call_cbs_changeEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*changeEvent", "@hide", false, &_init_cbs_changeEvent_1217_0, &_call_cbs_changeEvent_1217_0, &_set_callback_cbs_changeEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QWizard::childEvent(QChildEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*cleanupPage", "@brief Virtual method void QWizard::cleanupPage(int id)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_cleanupPage_767_0, &_call_cbs_cleanupPage_767_0);
  methods += new qt_gsi::GenericMethod ("*cleanupPage", "@hide", false, &_init_cbs_cleanupPage_767_0, &_call_cbs_cleanupPage_767_0, &_set_callback_cbs_cleanupPage_767_0);
  methods += new qt_gsi::GenericMethod ("*closeEvent", "@brief Virtual method void QWizard::closeEvent(QCloseEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_closeEvent_1719_0, &_call_cbs_closeEvent_1719_0);
  methods += new qt_gsi::GenericMethod ("*closeEvent", "@hide", false, &_init_cbs_closeEvent_1719_0, &_call_cbs_closeEvent_1719_0, &_set_callback_cbs_closeEvent_1719_0);
  methods += new qt_gsi::GenericMethod ("*contextMenuEvent", "@brief Virtual method void QWizard::contextMenuEvent(QContextMenuEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_contextMenuEvent_2363_0, &_call_cbs_contextMenuEvent_2363_0);
  methods += new qt_gsi::GenericMethod ("*contextMenuEvent", "@hide", false, &_init_cbs_contextMenuEvent_2363_0, &_call_cbs_contextMenuEvent_2363_0, &_set_callback_cbs_contextMenuEvent_2363_0);
  methods += new qt_gsi::GenericMethod ("*qt_create", "@brief Method void QWizard::create(WId, bool initializeWindow, bool destroyOldWindow)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_create_2208, &_call_fp_create_2208);
  methods += new qt_gsi::GenericMethod ("emit_currentIdChanged", "@brief Emitter for signal void QWizard::currentIdChanged(int id)\nCall this method to emit this signal.", false, &_init_emitter_currentIdChanged_767, &_call_emitter_currentIdChanged_767);
  methods += new qt_gsi::GenericMethod ("emit_customButtonClicked", "@brief Emitter for signal void QWizard::customButtonClicked(int which)\nCall this method to emit this signal.", false, &_init_emitter_customButtonClicked_767, &_call_emitter_customButtonClicked_767);
  methods += new qt_gsi::GenericMethod ("emit_customContextMenuRequested", "@brief Emitter for signal void QWizard::customContextMenuRequested(const QPoint &pos)\nCall this method to emit this signal.", false, &_init_emitter_customContextMenuRequested_1916, &_call_emitter_customContextMenuRequested_1916);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QWizard::customEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*qt_destroy", "@brief Method void QWizard::destroy(bool destroyWindow, bool destroySubWindows)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_destroy_1620, &_call_fp_destroy_1620);
  methods += new qt_gsi::GenericMethod ("emit_destroyed", "@brief Emitter for signal void QWizard::destroyed(QObject *)\nCall this method to emit this signal.", false, &_init_emitter_destroyed_1302, &_call_emitter_destroyed_1302);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QWizard::disconnectNotify(const char *signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_1731_0, &_call_cbs_disconnectNotify_1731_0);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_1731_0, &_call_cbs_disconnectNotify_1731_0, &_set_callback_cbs_disconnectNotify_1731_0);
  methods += new qt_gsi::GenericMethod ("*done", "@brief Virtual method void QWizard::done(int result)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_done_767_0, &_call_cbs_done_767_0);
  methods += new qt_gsi::GenericMethod ("*done", "@hide", false, &_init_cbs_done_767_0, &_call_cbs_done_767_0, &_set_callback_cbs_done_767_0);
  methods += new qt_gsi::GenericMethod ("*dragEnterEvent", "@brief Virtual method void QWizard::dragEnterEvent(QDragEnterEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dragEnterEvent_2109_0, &_call_cbs_dragEnterEvent_2109_0);
  methods += new qt_gsi::GenericMethod ("*dragEnterEvent", "@hide", false, &_init_cbs_dragEnterEvent_2109_0, &_call_cbs_dragEnterEvent_2109_0, &_set_callback_cbs_dragEnterEvent_2109_0);
  methods += new qt_gsi::GenericMethod ("*dragLeaveEvent", "@brief Virtual method void QWizard::dragLeaveEvent(QDragLeaveEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dragLeaveEvent_2092_0, &_call_cbs_dragLeaveEvent_2092_0);
  methods += new qt_gsi::GenericMethod ("*dragLeaveEvent", "@hide", false, &_init_cbs_dragLeaveEvent_2092_0, &_call_cbs_dragLeaveEvent_2092_0, &_set_callback_cbs_dragLeaveEvent_2092_0);
  methods += new qt_gsi::GenericMethod ("*dragMoveEvent", "@brief Virtual method void QWizard::dragMoveEvent(QDragMoveEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dragMoveEvent_2006_0, &_call_cbs_dragMoveEvent_2006_0);
  methods += new qt_gsi::GenericMethod ("*dragMoveEvent", "@hide", false, &_init_cbs_dragMoveEvent_2006_0, &_call_cbs_dragMoveEvent_2006_0, &_set_callback_cbs_dragMoveEvent_2006_0);
  methods += new qt_gsi::GenericMethod ("*dropEvent", "@brief Virtual method void QWizard::dropEvent(QDropEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dropEvent_1622_0, &_call_cbs_dropEvent_1622_0);
  methods += new qt_gsi::GenericMethod ("*dropEvent", "@hide", false, &_init_cbs_dropEvent_1622_0, &_call_cbs_dropEvent_1622_0, &_set_callback_cbs_dropEvent_1622_0);
  methods += new qt_gsi::GenericMethod ("*enabledChange", "@brief Virtual method void QWizard::enabledChange(bool)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_enabledChange_864_0, &_call_cbs_enabledChange_864_0);
  methods += new qt_gsi::GenericMethod ("*enabledChange", "@hide", false, &_init_cbs_enabledChange_864_0, &_call_cbs_enabledChange_864_0, &_set_callback_cbs_enabledChange_864_0);
  methods += new qt_gsi::GenericMethod ("*enterEvent", "@brief Virtual method void QWizard::enterEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_enterEvent_1217_0, &_call_cbs_enterEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*enterEvent", "@hide", false, &_init_cbs_enterEvent_1217_0, &_call_cbs_enterEvent_1217_0, &_set_callback_cbs_enterEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*event", "@brief Virtual method bool QWizard::event(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("*event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("*eventFilter", "@brief Virtual method bool QWizard::eventFilter(QObject *, QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("*eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("emit_finished", "@brief Emitter for signal void QWizard::finished(int result)\nCall this method to emit this signal.", false, &_init_emitter_finished_767, &_call_emitter_finished_767);
  methods += new qt_gsi::GenericMethod ("*focusInEvent", "@brief Virtual method void QWizard::focusInEvent(QFocusEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_focusInEvent_1729_0, &_call_cbs_focusInEvent_1729_0);
  methods += new qt_gsi::GenericMethod ("*focusInEvent", "@hide", false, &_init_cbs_focusInEvent_1729_0, &_call_cbs_focusInEvent_1729_0, &_set_callback_cbs_focusInEvent_1729_0);
  methods += new qt_gsi::GenericMethod ("*focusNextChild", "@brief Method bool QWizard::focusNextChild()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_focusNextChild_0, &_call_fp_focusNextChild_0);
  methods += new qt_gsi::GenericMethod ("*focusNextPrevChild", "@brief Virtual method bool QWizard::focusNextPrevChild(bool next)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_focusNextPrevChild_864_0, &_call_cbs_focusNextPrevChild_864_0);
  methods += new qt_gsi::GenericMethod ("*focusNextPrevChild", "@hide", false, &_init_cbs_focusNextPrevChild_864_0, &_call_cbs_focusNextPrevChild_864_0, &_set_callback_cbs_focusNextPrevChild_864_0);
  methods += new qt_gsi::GenericMethod ("*focusOutEvent", "@brief Virtual method void QWizard::focusOutEvent(QFocusEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_focusOutEvent_1729_0, &_call_cbs_focusOutEvent_1729_0);
  methods += new qt_gsi::GenericMethod ("*focusOutEvent", "@hide", false, &_init_cbs_focusOutEvent_1729_0, &_call_cbs_focusOutEvent_1729_0, &_set_callback_cbs_focusOutEvent_1729_0);
  methods += new qt_gsi::GenericMethod ("*focusPreviousChild", "@brief Method bool QWizard::focusPreviousChild()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_focusPreviousChild_0, &_call_fp_focusPreviousChild_0);
  methods += new qt_gsi::GenericMethod ("*fontChange", "@brief Virtual method void QWizard::fontChange(const QFont &)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_fontChange_1801_0, &_call_cbs_fontChange_1801_0);
  methods += new qt_gsi::GenericMethod ("*fontChange", "@hide", false, &_init_cbs_fontChange_1801_0, &_call_cbs_fontChange_1801_0, &_set_callback_cbs_fontChange_1801_0);
  methods += new qt_gsi::GenericMethod ("heightForWidth", "@brief Virtual method int QWizard::heightForWidth(int)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_heightForWidth_c767_0, &_call_cbs_heightForWidth_c767_0);
  methods += new qt_gsi::GenericMethod ("heightForWidth", "@hide", true, &_init_cbs_heightForWidth_c767_0, &_call_cbs_heightForWidth_c767_0, &_set_callback_cbs_heightForWidth_c767_0);
  methods += new qt_gsi::GenericMethod ("emit_helpRequested", "@brief Emitter for signal void QWizard::helpRequested()\nCall this method to emit this signal.", false, &_init_emitter_helpRequested_0, &_call_emitter_helpRequested_0);
  methods += new qt_gsi::GenericMethod ("*hideEvent", "@brief Virtual method void QWizard::hideEvent(QHideEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_hideEvent_1595_0, &_call_cbs_hideEvent_1595_0);
  methods += new qt_gsi::GenericMethod ("*hideEvent", "@hide", false, &_init_cbs_hideEvent_1595_0, &_call_cbs_hideEvent_1595_0, &_set_callback_cbs_hideEvent_1595_0);
  methods += new qt_gsi::GenericMethod ("*initializePage", "@brief Virtual method void QWizard::initializePage(int id)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_initializePage_767_0, &_call_cbs_initializePage_767_0);
  methods += new qt_gsi::GenericMethod ("*initializePage", "@hide", false, &_init_cbs_initializePage_767_0, &_call_cbs_initializePage_767_0, &_set_callback_cbs_initializePage_767_0);
  methods += new qt_gsi::GenericMethod ("*inputMethodEvent", "@brief Virtual method void QWizard::inputMethodEvent(QInputMethodEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_inputMethodEvent_2354_0, &_call_cbs_inputMethodEvent_2354_0);
  methods += new qt_gsi::GenericMethod ("*inputMethodEvent", "@hide", false, &_init_cbs_inputMethodEvent_2354_0, &_call_cbs_inputMethodEvent_2354_0, &_set_callback_cbs_inputMethodEvent_2354_0);
  methods += new qt_gsi::GenericMethod ("inputMethodQuery", "@brief Virtual method QVariant QWizard::inputMethodQuery(Qt::InputMethodQuery)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_inputMethodQuery_c2420_0, &_call_cbs_inputMethodQuery_c2420_0);
  methods += new qt_gsi::GenericMethod ("inputMethodQuery", "@hide", true, &_init_cbs_inputMethodQuery_c2420_0, &_call_cbs_inputMethodQuery_c2420_0, &_set_callback_cbs_inputMethodQuery_c2420_0);
  methods += new qt_gsi::GenericMethod ("*keyPressEvent", "@brief Virtual method void QWizard::keyPressEvent(QKeyEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_keyPressEvent_1514_0, &_call_cbs_keyPressEvent_1514_0);
  methods += new qt_gsi::GenericMethod ("*keyPressEvent", "@hide", false, &_init_cbs_keyPressEvent_1514_0, &_call_cbs_keyPressEvent_1514_0, &_set_callback_cbs_keyPressEvent_1514_0);
  methods += new qt_gsi::GenericMethod ("*keyReleaseEvent", "@brief Virtual method void QWizard::keyReleaseEvent(QKeyEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_keyReleaseEvent_1514_0, &_call_cbs_keyReleaseEvent_1514_0);
  methods += new qt_gsi::GenericMethod ("*keyReleaseEvent", "@hide", false, &_init_cbs_keyReleaseEvent_1514_0, &_call_cbs_keyReleaseEvent_1514_0, &_set_callback_cbs_keyReleaseEvent_1514_0);
  methods += new qt_gsi::GenericMethod ("*languageChange", "@brief Virtual method void QWizard::languageChange()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_languageChange_0_0, &_call_cbs_languageChange_0_0);
  methods += new qt_gsi::GenericMethod ("*languageChange", "@hide", false, &_init_cbs_languageChange_0_0, &_call_cbs_languageChange_0_0, &_set_callback_cbs_languageChange_0_0);
  methods += new qt_gsi::GenericMethod ("*leaveEvent", "@brief Virtual method void QWizard::leaveEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_leaveEvent_1217_0, &_call_cbs_leaveEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*leaveEvent", "@hide", false, &_init_cbs_leaveEvent_1217_0, &_call_cbs_leaveEvent_1217_0, &_set_callback_cbs_leaveEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*metric", "@brief Virtual method int QWizard::metric(QPaintDevice::PaintDeviceMetric)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_metric_c3445_0, &_call_cbs_metric_c3445_0);
  methods += new qt_gsi::GenericMethod ("*metric", "@hide", true, &_init_cbs_metric_c3445_0, &_call_cbs_metric_c3445_0, &_set_callback_cbs_metric_c3445_0);
  methods += new qt_gsi::GenericMethod ("minimumSizeHint", "@brief Virtual method QSize QWizard::minimumSizeHint()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_minimumSizeHint_c0_0, &_call_cbs_minimumSizeHint_c0_0);
  methods += new qt_gsi::GenericMethod ("minimumSizeHint", "@hide", true, &_init_cbs_minimumSizeHint_c0_0, &_call_cbs_minimumSizeHint_c0_0, &_set_callback_cbs_minimumSizeHint_c0_0);
  methods += new qt_gsi::GenericMethod ("*mouseDoubleClickEvent", "@brief Virtual method void QWizard::mouseDoubleClickEvent(QMouseEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mouseDoubleClickEvent_1738_0, &_call_cbs_mouseDoubleClickEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mouseDoubleClickEvent", "@hide", false, &_init_cbs_mouseDoubleClickEvent_1738_0, &_call_cbs_mouseDoubleClickEvent_1738_0, &_set_callback_cbs_mouseDoubleClickEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mouseMoveEvent", "@brief Virtual method void QWizard::mouseMoveEvent(QMouseEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mouseMoveEvent_1738_0, &_call_cbs_mouseMoveEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mouseMoveEvent", "@hide", false, &_init_cbs_mouseMoveEvent_1738_0, &_call_cbs_mouseMoveEvent_1738_0, &_set_callback_cbs_mouseMoveEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mousePressEvent", "@brief Virtual method void QWizard::mousePressEvent(QMouseEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mousePressEvent_1738_0, &_call_cbs_mousePressEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mousePressEvent", "@hide", false, &_init_cbs_mousePressEvent_1738_0, &_call_cbs_mousePressEvent_1738_0, &_set_callback_cbs_mousePressEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mouseReleaseEvent", "@brief Virtual method void QWizard::mouseReleaseEvent(QMouseEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mouseReleaseEvent_1738_0, &_call_cbs_mouseReleaseEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mouseReleaseEvent", "@hide", false, &_init_cbs_mouseReleaseEvent_1738_0, &_call_cbs_mouseReleaseEvent_1738_0, &_set_callback_cbs_mouseReleaseEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*moveEvent", "@brief Virtual method void QWizard::moveEvent(QMoveEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_moveEvent_1624_0, &_call_cbs_moveEvent_1624_0);
  methods += new qt_gsi::GenericMethod ("*moveEvent", "@hide", false, &_init_cbs_moveEvent_1624_0, &_call_cbs_moveEvent_1624_0, &_set_callback_cbs_moveEvent_1624_0);
  methods += new qt_gsi::GenericMethod ("nextId", "@brief Virtual method int QWizard::nextId()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_nextId_c0_0, &_call_cbs_nextId_c0_0);
  methods += new qt_gsi::GenericMethod ("nextId", "@hide", true, &_init_cbs_nextId_c0_0, &_call_cbs_nextId_c0_0, &_set_callback_cbs_nextId_c0_0);
  methods += new qt_gsi::GenericMethod ("paintEngine", "@brief Virtual method QPaintEngine *QWizard::paintEngine()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_paintEngine_c0_0, &_call_cbs_paintEngine_c0_0);
  methods += new qt_gsi::GenericMethod ("paintEngine", "@hide", true, &_init_cbs_paintEngine_c0_0, &_call_cbs_paintEngine_c0_0, &_set_callback_cbs_paintEngine_c0_0);
  methods += new qt_gsi::GenericMethod ("*paintEvent", "@brief Virtual method void QWizard::paintEvent(QPaintEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_paintEvent_1725_0, &_call_cbs_paintEvent_1725_0);
  methods += new qt_gsi::GenericMethod ("*paintEvent", "@hide", false, &_init_cbs_paintEvent_1725_0, &_call_cbs_paintEvent_1725_0, &_set_callback_cbs_paintEvent_1725_0);
  methods += new qt_gsi::GenericMethod ("*paletteChange", "@brief Virtual method void QWizard::paletteChange(const QPalette &)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_paletteChange_2113_0, &_call_cbs_paletteChange_2113_0);
  methods += new qt_gsi::GenericMethod ("*paletteChange", "@hide", false, &_init_cbs_paletteChange_2113_0, &_call_cbs_paletteChange_2113_0, &_set_callback_cbs_paletteChange_2113_0);
  methods += new qt_gsi::GenericMethod ("*receivers", "@brief Method int QWizard::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
  methods += new qt_gsi::GenericMethod ("reject", "@brief Virtual method void QWizard::reject()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_reject_0_0, &_call_cbs_reject_0_0);
  methods += new qt_gsi::GenericMethod ("reject", "@hide", false, &_init_cbs_reject_0_0, &_call_cbs_reject_0_0, &_set_callback_cbs_reject_0_0);
  methods += new qt_gsi::GenericMethod ("emit_rejected", "@brief Emitter for signal void QWizard::rejected()\nCall this method to emit this signal.", false, &_init_emitter_rejected_0, &_call_emitter_rejected_0);
  methods += new qt_gsi::GenericMethod ("*resetInputContext", "@brief Method void QWizard::resetInputContext()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_resetInputContext_0, &_call_fp_resetInputContext_0);
  methods += new qt_gsi::GenericMethod ("*resizeEvent", "@brief Virtual method void QWizard::resizeEvent(QResizeEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_resizeEvent_1843_0, &_call_cbs_resizeEvent_1843_0);
  methods += new qt_gsi::GenericMethod ("*resizeEvent", "@hide", false, &_init_cbs_resizeEvent_1843_0, &_call_cbs_resizeEvent_1843_0, &_set_callback_cbs_resizeEvent_1843_0);
  methods += new qt_gsi::GenericMethod ("*sender", "@brief Method QObject *QWizard::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
  methods += new qt_gsi::GenericMethod ("setVisible", "@brief Virtual method void QWizard::setVisible(bool visible)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setVisible_864_0, &_call_cbs_setVisible_864_0);
  methods += new qt_gsi::GenericMethod ("setVisible", "@hide", false, &_init_cbs_setVisible_864_0, &_call_cbs_setVisible_864_0, &_set_callback_cbs_setVisible_864_0);
  methods += new qt_gsi::GenericMethod ("*showEvent", "@brief Virtual method void QWizard::showEvent(QShowEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_showEvent_1634_0, &_call_cbs_showEvent_1634_0);
  methods += new qt_gsi::GenericMethod ("*showEvent", "@hide", false, &_init_cbs_showEvent_1634_0, &_call_cbs_showEvent_1634_0, &_set_callback_cbs_showEvent_1634_0);
  methods += new qt_gsi::GenericMethod ("sizeHint", "@brief Virtual method QSize QWizard::sizeHint()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_sizeHint_c0_0, &_call_cbs_sizeHint_c0_0);
  methods += new qt_gsi::GenericMethod ("sizeHint", "@hide", true, &_init_cbs_sizeHint_c0_0, &_call_cbs_sizeHint_c0_0, &_set_callback_cbs_sizeHint_c0_0);
  methods += new qt_gsi::GenericMethod ("*styleChange", "@brief Virtual method void QWizard::styleChange(QStyle &)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_styleChange_1228_0, &_call_cbs_styleChange_1228_0);
  methods += new qt_gsi::GenericMethod ("*styleChange", "@hide", false, &_init_cbs_styleChange_1228_0, &_call_cbs_styleChange_1228_0, &_set_callback_cbs_styleChange_1228_0);
  methods += new qt_gsi::GenericMethod ("*tabletEvent", "@brief Virtual method void QWizard::tabletEvent(QTabletEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_tabletEvent_1821_0, &_call_cbs_tabletEvent_1821_0);
  methods += new qt_gsi::GenericMethod ("*tabletEvent", "@hide", false, &_init_cbs_tabletEvent_1821_0, &_call_cbs_tabletEvent_1821_0, &_set_callback_cbs_tabletEvent_1821_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QWizard::timerEvent(QTimerEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("*updateMicroFocus", "@brief Method void QWizard::updateMicroFocus()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_updateMicroFocus_0, &_call_fp_updateMicroFocus_0);
  methods += new qt_gsi::GenericMethod ("validateCurrentPage", "@brief Virtual method bool QWizard::validateCurrentPage()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_validateCurrentPage_0_0, &_call_cbs_validateCurrentPage_0_0);
  methods += new qt_gsi::GenericMethod ("validateCurrentPage", "@hide", false, &_init_cbs_validateCurrentPage_0_0, &_call_cbs_validateCurrentPage_0_0, &_set_callback_cbs_validateCurrentPage_0_0);
  methods += new qt_gsi::GenericMethod ("*wheelEvent", "@brief Virtual method void QWizard::wheelEvent(QWheelEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_wheelEvent_1718_0, &_call_cbs_wheelEvent_1718_0);
  methods += new qt_gsi::GenericMethod ("*wheelEvent", "@hide", false, &_init_cbs_wheelEvent_1718_0, &_call_cbs_wheelEvent_1718_0, &_set_callback_cbs_wheelEvent_1718_0);
  methods += new qt_gsi::GenericMethod ("*windowActivationChange", "@brief Virtual method void QWizard::windowActivationChange(bool)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_windowActivationChange_864_0, &_call_cbs_windowActivationChange_864_0);
  methods += new qt_gsi::GenericMethod ("*windowActivationChange", "@hide", false, &_init_cbs_windowActivationChange_864_0, &_call_cbs_windowActivationChange_864_0, &_set_callback_cbs_windowActivationChange_864_0);
  return methods;
}

gsi::Class<QWizard_Adaptor> decl_QWizard_Adaptor (qtdecl_QWizard (), "QtGui", "QWizard",
  methods_QWizard_Adaptor (),
  "@qt\n@brief Binding of QWizard");

}


//  Implementation of the enum wrapper class for QWizard::WizardButton
namespace qt_gsi
{

static gsi::Enum<QWizard::WizardButton> decl_QWizard_WizardButton_Enum ("QtGui", "QWizard_WizardButton",
    gsi::enum_const ("BackButton", QWizard::BackButton, "@brief Enum constant QWizard::BackButton") +
    gsi::enum_const ("NextButton", QWizard::NextButton, "@brief Enum constant QWizard::NextButton") +
    gsi::enum_const ("CommitButton", QWizard::CommitButton, "@brief Enum constant QWizard::CommitButton") +
    gsi::enum_const ("FinishButton", QWizard::FinishButton, "@brief Enum constant QWizard::FinishButton") +
    gsi::enum_const ("CancelButton", QWizard::CancelButton, "@brief Enum constant QWizard::CancelButton") +
    gsi::enum_const ("HelpButton", QWizard::HelpButton, "@brief Enum constant QWizard::HelpButton") +
    gsi::enum_const ("CustomButton1", QWizard::CustomButton1, "@brief Enum constant QWizard::CustomButton1") +
    gsi::enum_const ("CustomButton2", QWizard::CustomButton2, "@brief Enum constant QWizard::CustomButton2") +
    gsi::enum_const ("CustomButton3", QWizard::CustomButton3, "@brief Enum constant QWizard::CustomButton3") +
    gsi::enum_const ("Stretch", QWizard::Stretch, "@brief Enum constant QWizard::Stretch") +
    gsi::enum_const ("NoButton", QWizard::NoButton, "@brief Enum constant QWizard::NoButton") +
    gsi::enum_const ("NStandardButtons", QWizard::NStandardButtons, "@brief Enum constant QWizard::NStandardButtons") +
    gsi::enum_const ("NButtons", QWizard::NButtons, "@brief Enum constant QWizard::NButtons"),
  "@qt\n@brief This class represents the QWizard::WizardButton enum");

static gsi::QFlagsClass<QWizard::WizardButton > decl_QWizard_WizardButton_Enums ("QtGui", "QWizard_QFlags_WizardButton",
  "@qt\n@brief This class represents the QFlags<QWizard::WizardButton> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QWizard> inject_QWizard_WizardButton_Enum_in_parent (decl_QWizard_WizardButton_Enum.defs ());
static gsi::ClassExt<QWizard> decl_QWizard_WizardButton_Enum_as_child (decl_QWizard_WizardButton_Enum, "WizardButton");
static gsi::ClassExt<QWizard> decl_QWizard_WizardButton_Enums_as_child (decl_QWizard_WizardButton_Enums, "QFlags_WizardButton");

}


//  Implementation of the enum wrapper class for QWizard::WizardOption
namespace qt_gsi
{

static gsi::Enum<QWizard::WizardOption> decl_QWizard_WizardOption_Enum ("QtGui", "QWizard_WizardOption",
    gsi::enum_const ("IndependentPages", QWizard::IndependentPages, "@brief Enum constant QWizard::IndependentPages") +
    gsi::enum_const ("IgnoreSubTitles", QWizard::IgnoreSubTitles, "@brief Enum constant QWizard::IgnoreSubTitles") +
    gsi::enum_const ("ExtendedWatermarkPixmap", QWizard::ExtendedWatermarkPixmap, "@brief Enum constant QWizard::ExtendedWatermarkPixmap") +
    gsi::enum_const ("NoDefaultButton", QWizard::NoDefaultButton, "@brief Enum constant QWizard::NoDefaultButton") +
    gsi::enum_const ("NoBackButtonOnStartPage", QWizard::NoBackButtonOnStartPage, "@brief Enum constant QWizard::NoBackButtonOnStartPage") +
    gsi::enum_const ("NoBackButtonOnLastPage", QWizard::NoBackButtonOnLastPage, "@brief Enum constant QWizard::NoBackButtonOnLastPage") +
    gsi::enum_const ("DisabledBackButtonOnLastPage", QWizard::DisabledBackButtonOnLastPage, "@brief Enum constant QWizard::DisabledBackButtonOnLastPage") +
    gsi::enum_const ("HaveNextButtonOnLastPage", QWizard::HaveNextButtonOnLastPage, "@brief Enum constant QWizard::HaveNextButtonOnLastPage") +
    gsi::enum_const ("HaveFinishButtonOnEarlyPages", QWizard::HaveFinishButtonOnEarlyPages, "@brief Enum constant QWizard::HaveFinishButtonOnEarlyPages") +
    gsi::enum_const ("NoCancelButton", QWizard::NoCancelButton, "@brief Enum constant QWizard::NoCancelButton") +
    gsi::enum_const ("CancelButtonOnLeft", QWizard::CancelButtonOnLeft, "@brief Enum constant QWizard::CancelButtonOnLeft") +
    gsi::enum_const ("HaveHelpButton", QWizard::HaveHelpButton, "@brief Enum constant QWizard::HaveHelpButton") +
    gsi::enum_const ("HelpButtonOnRight", QWizard::HelpButtonOnRight, "@brief Enum constant QWizard::HelpButtonOnRight") +
    gsi::enum_const ("HaveCustomButton1", QWizard::HaveCustomButton1, "@brief Enum constant QWizard::HaveCustomButton1") +
    gsi::enum_const ("HaveCustomButton2", QWizard::HaveCustomButton2, "@brief Enum constant QWizard::HaveCustomButton2") +
    gsi::enum_const ("HaveCustomButton3", QWizard::HaveCustomButton3, "@brief Enum constant QWizard::HaveCustomButton3"),
  "@qt\n@brief This class represents the QWizard::WizardOption enum");

static gsi::QFlagsClass<QWizard::WizardOption > decl_QWizard_WizardOption_Enums ("QtGui", "QWizard_QFlags_WizardOption",
  "@qt\n@brief This class represents the QFlags<QWizard::WizardOption> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QWizard> inject_QWizard_WizardOption_Enum_in_parent (decl_QWizard_WizardOption_Enum.defs ());
static gsi::ClassExt<QWizard> decl_QWizard_WizardOption_Enum_as_child (decl_QWizard_WizardOption_Enum, "WizardOption");
static gsi::ClassExt<QWizard> decl_QWizard_WizardOption_Enums_as_child (decl_QWizard_WizardOption_Enums, "QFlags_WizardOption");

}


//  Implementation of the enum wrapper class for QWizard::WizardPixmap
namespace qt_gsi
{

static gsi::Enum<QWizard::WizardPixmap> decl_QWizard_WizardPixmap_Enum ("QtGui", "QWizard_WizardPixmap",
    gsi::enum_const ("WatermarkPixmap", QWizard::WatermarkPixmap, "@brief Enum constant QWizard::WatermarkPixmap") +
    gsi::enum_const ("LogoPixmap", QWizard::LogoPixmap, "@brief Enum constant QWizard::LogoPixmap") +
    gsi::enum_const ("BannerPixmap", QWizard::BannerPixmap, "@brief Enum constant QWizard::BannerPixmap") +
    gsi::enum_const ("BackgroundPixmap", QWizard::BackgroundPixmap, "@brief Enum constant QWizard::BackgroundPixmap") +
    gsi::enum_const ("NPixmaps", QWizard::NPixmaps, "@brief Enum constant QWizard::NPixmaps"),
  "@qt\n@brief This class represents the QWizard::WizardPixmap enum");

static gsi::QFlagsClass<QWizard::WizardPixmap > decl_QWizard_WizardPixmap_Enums ("QtGui", "QWizard_QFlags_WizardPixmap",
  "@qt\n@brief This class represents the QFlags<QWizard::WizardPixmap> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QWizard> inject_QWizard_WizardPixmap_Enum_in_parent (decl_QWizard_WizardPixmap_Enum.defs ());
static gsi::ClassExt<QWizard> decl_QWizard_WizardPixmap_Enum_as_child (decl_QWizard_WizardPixmap_Enum, "WizardPixmap");
static gsi::ClassExt<QWizard> decl_QWizard_WizardPixmap_Enums_as_child (decl_QWizard_WizardPixmap_Enums, "QFlags_WizardPixmap");

}


//  Implementation of the enum wrapper class for QWizard::WizardStyle
namespace qt_gsi
{

static gsi::Enum<QWizard::WizardStyle> decl_QWizard_WizardStyle_Enum ("QtGui", "QWizard_WizardStyle",
    gsi::enum_const ("ClassicStyle", QWizard::ClassicStyle, "@brief Enum constant QWizard::ClassicStyle") +
    gsi::enum_const ("ModernStyle", QWizard::ModernStyle, "@brief Enum constant QWizard::ModernStyle") +
    gsi::enum_const ("MacStyle", QWizard::MacStyle, "@brief Enum constant QWizard::MacStyle") +
    gsi::enum_const ("AeroStyle", QWizard::AeroStyle, "@brief Enum constant QWizard::AeroStyle") +
    gsi::enum_const ("NStyles", QWizard::NStyles, "@brief Enum constant QWizard::NStyles"),
  "@qt\n@brief This class represents the QWizard::WizardStyle enum");

static gsi::QFlagsClass<QWizard::WizardStyle > decl_QWizard_WizardStyle_Enums ("QtGui", "QWizard_QFlags_WizardStyle",
  "@qt\n@brief This class represents the QFlags<QWizard::WizardStyle> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QWizard> inject_QWizard_WizardStyle_Enum_in_parent (decl_QWizard_WizardStyle_Enum.defs ());
static gsi::ClassExt<QWizard> decl_QWizard_WizardStyle_Enum_as_child (decl_QWizard_WizardStyle_Enum, "WizardStyle");
static gsi::ClassExt<QWizard> decl_QWizard_WizardStyle_Enums_as_child (decl_QWizard_WizardStyle_Enums, "QFlags_WizardStyle");

}

