import collections


_SHORT_ORDINAL_STRING_IT = {
    1: 'primo',
    2: 'secondo',
    3: 'terzo',
    4: 'quarto',
    5: 'quinto',
    6: 'sesto',
    7: 'settimo',
    8: 'ottavo',
    9: 'nono',
    10: 'decimo',
    11: 'undicesimo',
    12: 'dodicesimo',
    13: 'tredicesimo',
    14: 'quattordicesimo',
    15: 'quindicesimo',
    16: 'sedicesimo',
    17: 'diciassettesimo',
    18: 'diciottesimo',
    19: 'diciannovesimo',
    20: 'ventesimo',
    30: 'trentesimo',
    40: 'quarantesimo',
    50: 'cinquantesimo',
    60: 'sessantesimo',
    70: 'settantesimo',
    80: 'ottantesimo',
    90: 'novantesimo',
    1e2: 'centesimo',
    1e3: 'millesimo',
    1e6: 'milionesimo',
    1e9: 'miliardesimo',
    1e12: 'trilionesimo',
    1e15: 'quadrilionesimo',
    1e18: 'quintilionesim',
    1e21: 'sestilionesimo',
    1e24: 'settilionesimo',
    1e27: 'ottilionesimo',
    1e30: 'nonilionesimo',
    1e33: 'decilionesimo'
    # TODO > 1e-33
}

#  per i > 10e12 modificata solo la desinenza: da sistemare a fine debug
_LONG_ORDINAL_STRING_IT = {
    1: 'primo',
    2: 'secondo',
    3: 'terzo',
    4: 'quarto',
    5: 'quinto',
    6: 'sesto',
    7: 'settimo',
    8: 'ottavo',
    9: 'nono',
    10: 'decimo',
    11: 'undicesimo',
    12: 'dodicesimo',
    13: 'tredicesimo',
    14: 'quattordicesimo',
    15: 'quindicesimo',
    16: 'sedicesimo',
    17: 'diciassettesimo',
    18: 'diciottesimo',
    19: 'diciannovesimo',
    20: 'ventesimo',
    30: 'trentesimo',
    40: 'quarantesimo',
    50: 'cinquantesimo',
    60: 'sessantesimo',
    70: 'settantesimo',
    80: 'ottantesimo',
    90: 'novantesimo',
    1e2: 'centesimo',
    1e3: 'millesimo',
    1e6: 'milionesimo',
    1e12: 'bilionesimo',
    1e18: 'trilionesimo',
    1e24: 'quadrilionesimo',
    1e30: 'quintilionesimo',
    1e36: 'sestilionesimo',
    1e42: 'settilionesimo',
    1e48: 'ottilionesimo',
    1e54: 'nonilionesimo',
    1e60: 'decilionesimo'
    # TODO > 1e60
}

# Undefined articles ['un', 'una', 'un\''] can not be supressed,
# in Italian, 'un cavallo' means 'a horse' or 'one horse'.
_ARTICLES_IT = ['il', 'lo', 'la', 'i', 'gli', 'le']

_STRING_NUM_IT = {
    'zero': 0,
    'un': 1,
    'uno': 1,
    'una': 1,
    'un\'': 1,
    'due': 2,
    'tre': 3,
    'quattro': 4,
    'cinque': 5,
    'sei': 6,
    'sette': 7,
    'otto': 8,
    'nove': 9,
    'dieci': 10,
    'undici': 11,
    'dodici': 12,
    'tredici': 13,
    'quattordici': 14,
    'quindici': 15,
    'sedici': 16,
    'diciassette': 17,
    'diciotto': 18,
    'diciannove': 19,
    'venti': 20,
    'vent': 20,
    'trenta': 30,
    'trent': 30,
    'quaranta': 40,
    'quarant': 40,
    'cinquanta': 50,
    'cinquant': 50,
    'sessanta': 60,
    'sessant': 60,
    'settanta': 70,
    'settant': 70,
    'ottanta': 80,
    'ottant': 80,
    'novanta': 90,
    'novant': 90,
    'cento': 100,
    'duecento': 200,
    'trecento': 300,
    'quattrocento': 400,
    'cinquecento': 500,
    'seicento': 600,
    'settecento': 700,
    'ottocento': 800,
    'novecento': 900,
    'mille': 1000,
    'mila': 1000,
    'centomila': 100000,
    'milione': 1000000,
    'miliardo': 1000000000,
    'primo': 1,
    'secondo': 2,
    'mezzo': 0.5,
    'mezza': 0.5,
    'paio': 2,
    'decina': 10,
    'decine': 10,
    'dozzina': 12,
    'dozzine': 12,
    'centinaio': 100,
    'centinaia': 100,
    'migliaio': 1000,
    'migliaia': 1000
}

_NUM_STRING_IT = {
    0: 'zero',
    1: 'uno',
    2: 'due',
    3: 'tre',
    4: 'quattro',
    5: 'cinque',
    6: 'sei',
    7: 'sette',
    8: 'otto',
    9: 'nove',
    10: 'dieci',
    11: 'undici',
    12: 'dodici',
    13: 'tredici',
    14: 'quattordici',
    15: 'quindici',
    16: 'sedici',
    17: 'diciassette',
    18: 'diciotto',
    19: 'diciannove',
    20: 'venti',
    30: 'trenta',
    40: 'quaranta',
    50: 'cinquanta',
    60: 'sessanta',
    70: 'settanta',
    80: 'ottanta',
    90: 'novanta'
}

_FRACTION_STRING_IT = {
    2: 'mezz',
    3: 'terz',
    4: 'quart',
    5: 'quint',
    6: 'sest',
    7: 'settim',
    8: 'ottav',
    9: 'non',
    10: 'decim',
    11: 'undicesim',
    12: 'dodicesim',
    13: 'tredicesim',
    14: 'quattordicesim',
    15: 'quindicesim',
    16: 'sedicesim',
    17: 'diciassettesim',
    18: 'diciottesim',
    19: 'diciannovesim',
    20: 'ventesim'
}

# fonte: http://tulengua.es/numeros-texto/default.aspx
_LONG_SCALE_IT = collections.OrderedDict([
    (100, 'cento'),
    (1000, 'mila'),
    (1000000, 'milioni'),
    (1e9, "miliardi"),
    (1e12, "bilioni"),
    (1e18, 'trilioni'),
    (1e24, "quadrilioni"),
    (1e30, "quintilioni"),
    (1e36, "sestilioni"),
    (1e42, "settilioni"),
    (1e48, "ottillioni"),
    (1e54, "nonillioni"),
    (1e60, "decemillioni"),
    (1e66, "undicilione"),
    (1e72, "dodicilione"),
    (1e78, "tredicilione"),
    (1e84, "quattordicilione"),
    (1e90, "quindicilione"),
    (1e96, "sedicilione"),
    (1e102, "diciasettilione"),
    (1e108, "diciottilione"),
    (1e114, "dicianovilione"),
    (1e120, "vintilione"),
    (1e306, "unquinquagintilione"),
    (1e312, "duoquinquagintilione"),
    (1e336, "sesquinquagintilione"),
    (1e366, "unsexagintilione")
])


_SHORT_SCALE_IT = collections.OrderedDict([
    (100, 'cento'),
    (1000, 'mila'),
    (1000000, 'milioni'),
    (1e9, "miliardi"),
    (1e12, 'bilioni'),
    (1e15, "biliardi"),
    (1e18, "trilioni"),
    (1e21, "triliardi"),
    (1e24, "quadrilioni"),
    (1e27, "quadriliardi"),
    (1e30, "quintilioni"),
    (1e33, "quintiliardi"),
    (1e36, "sestilioni"),
    (1e39, "sestiliardi"),
    (1e42, "settilioni"),
    (1e45, "settiliardi"),
    (1e48, "ottilioni"),
    (1e51, "ottiliardi"),
    (1e54, "nonilioni"),
    (1e57, "noniliardi"),
    (1e60, "decilioni"),
    (1e63, "deciliardi"),
    (1e66, "undicilioni"),
    (1e69, "undiciliardi"),
    (1e72, "dodicilioni"),
    (1e75, "dodiciliardi"),
    (1e78, "tredicilioni"),
    (1e81, "trediciliardi"),
    (1e84, "quattordicilioni"),
    (1e87, "quattordiciliardi"),
    (1e90, "quindicilioni"),
    (1e93, "quindiciliardi"),
    (1e96, "sedicilioni"),
    (1e99, "sediciliardi"),
    (1e102, "diciassettilioni"),
    (1e105, "diciassettiliardi"),
    (1e108, "diciottilioni"),
    (1e111, "diciottiliardi"),
    (1e114, "dicianovilioni"),
    (1e117, "dicianoviliardi"),
    (1e120, "vintilioni"),
    (1e123, "vintiliardi"),
    (1e153, "quinquagintillion"),
    (1e183, "sexagintillion"),
    (1e213, "septuagintillion"),
    (1e243, "ottogintilioni"),
    (1e273, "nonigintillioni"),
    (1e303, "centilioni"),
    (1e306, "uncentilioni"),
    (1e309, "duocentilioni"),
    (1e312, "trecentilioni"),
    (1e333, "decicentilioni"),
    (1e336, "undicicentilioni"),
    (1e363, "viginticentilioni"),
    (1e366, "unviginticentilioni"),
    (1e393, "trigintacentilioni"),
    (1e423, "quadragintacentillion"),
    (1e453, "quinquagintacentillion"),
    (1e483, "sexagintacentillion"),
    (1e513, "septuagintacentillion"),
    (1e543, "ctogintacentillion"),
    (1e573, "nonagintacentillion"),
    (1e603, "ducentillion"),
    (1e903, "trecentillion"),
    (1e1203, "quadringentillion"),
    (1e1503, "quingentillion"),
    (1e1803, "sescentillion"),
    (1e2103, "septingentillion"),
    (1e2403, "octingentillion"),
    (1e2703, "nongentillion"),
    (1e3003, "millinillion")
])
