* E0.F
* the scalar four-point function
* this file is part of LoopTools
* written by M. Rauch
* last modified 15 Sep 12 th

#include "externals.h"
#include "types.h"

#define npoint 5
#include "defs.h"


	ComplexType function XE0(p1, p2, p3, p4, p5, 
     &    p1p2, p2p3, p3p4, p4p5, p5p1, m1, m2, m3, m4, m5)
	implicit none
	DVAR p1, p2, p3, p4, p5
	DVAR p1p2, p2p3, p3p4, p4p5, p5p1
	DVAR m1, m2, m3, m4, m5

#include "lt.h"

	DVAR para(1,Pee)

	P(1) = p1
	P(2) = p2
	P(3) = p3
	P(4) = p4
	P(5) = p5
	P(6) = p1p2
	P(7) = p2p3
	P(8) = p3p4
	P(9) = p4p5
	P(10) = p5p1

	M(1) = m1
	if( abs(M(1)) .lt. minmass ) M(1) = 0
	M(2) = m2
	if( abs(M(2)) .lt. minmass ) M(2) = 0
	M(3) = m3
	if( abs(M(3)) .lt. minmass ) M(3) = 0
	M(4) = m4
	if( abs(M(4)) .lt. minmass ) M(4) = 0
	M(5) = m5
	if( abs(M(5)) .lt. minmass ) M(5) = 0

	call XE0para(XE0, para)
	end

************************************************************************
* subroutine version for C++

	subroutine XE0sub(res, p1, p2, p3, p4, p5,
     &    p1p2, p2p3, p3p4, p4p5, p5p1, m1, m2, m3, m4, m5)
	implicit none
	ComplexType res
	DVAR p1, p2, p3, p4, p5
	DVAR p1p2, p2p3, p3p4, p4p5, p5p1
	DVAR m1, m2, m3, m4, m5

#include "lt.h"

	DVAR para(1,Pee)

	P(1) = p1
	P(2) = p2
	P(3) = p3
	P(4) = p4
	P(5) = p5
	P(6) = p1p2
	P(7) = p2p3
	P(8) = p3p4
	P(9) = p4p5
	P(10) = p5p1

	M(1) = m1
	if( abs(M(1)) .lt. minmass ) M(1) = 0
	M(2) = m2
	if( abs(M(2)) .lt. minmass ) M(2) = 0
	M(3) = m3
	if( abs(M(3)) .lt. minmass ) M(3) = 0
	M(4) = m4
	if( abs(M(4)) .lt. minmass ) M(4) = 0
	M(5) = m5
	if( abs(M(5)) .lt. minmass ) M(5) = 0

	call XE0para(res, para)
	end

************************************************************************

#ifndef COMPLEXPARA
	subroutine E0para(res, para)
	implicit none
	ComplexType res
	RealType para(1,*)

#include "lt.h"

	ComplexType d0(5), alt
	integer key, ier

	key = ibits(versionkey, KeyE0, 2)

	if( key .ne. 1 ) then
	  call E0parab(res, para)
	  if( key .eq. 0 ) return
	  alt = res
	endif

	call ffxe0(res, d0, para, ier)

	if( key .gt. 1 .and.
     &      abs(res - alt) .gt. maxdev*abs(alt) ) then
	  print *, "Discrepancy in E0:"
	  print *, "  p1   =", P(1)
	  print *, "  p2   =", P(2)
	  print *, "  p3   =", P(3)
	  print *, "  p4   =", P(4)
	  print *, "  p5   =", P(5)
	  print *, "  p1p2 =", P(6)
	  print *, "  p2p3 =", P(7)
	  print *, "  p3p4 =", P(8)
	  print *, "  p4p5 =", P(9)
	  print *, "  p5p1 =", P(10)
	  print *, "  m1   =", M(1)
	  print *, "  m2   =", M(2)
	  print *, "  m3   =", M(3)
	  print *, "  m4   =", M(4)
	  print *, "  m5   =", M(5)
	  print *, "E0 a   =", alt
	  print *, "E0 b   =", res
	  if( ier .gt. errdigits ) alt = res
	endif

	if( .not. btest(key, 0) ) res = alt
	end
#endif

************************************************************************

#ifdef COMPLEXPARA
	subroutine E0Cpara(res, para)
#else
	subroutine E0parab(res, para)
#endif
	implicit none
	ComplexType res
	DVAR para(1,*)

#include "lt.h"

	DVAR p1, p2, p3, p4, p5
	DVAR p1p2, p2p3, p3p4, p4p5, p5p1
	DVAR m1, m2, m3, m4, m5

	QVAR Y(5,5), Yi(5,5), eta(5), detY
	integer i, j

	QVAR Yflat(25), Yiflat(25)
	equivalence (Y, Yflat)
	equivalence (Yi, Yiflat)

	ComplexType XD0
	external XD0

	m1 = M(1)
	m2 = M(2)
	m3 = M(3)
	m4 = M(4)
	m5 = M(5)
	p1 = P(1)
	p2 = P(2)
	p3 = P(3)
	p4 = P(4)
	p5 = P(5)
	p1p2 = P(6)
	p2p3 = P(7)
	p3p4 = P(8)
	p4p5 = P(9)
	p5p1 = P(10)

	Y(1,1) = 2*m1
	Y(2,2) = 2*m2
	Y(3,3) = 2*m3
	Y(4,4) = 2*m4
	Y(5,5) = 2*m5
	Y(1,2) = m1
	  Y(1,2) = Y(1,2) + m2
	  Y(1,2) = Y(1,2) - p1
	Y(2,1) = Y(1,2)
	Y(1,3) = m1
	  Y(1,3) = Y(1,3) + m3
	  Y(1,3) = Y(1,3) - p1p2
	Y(3,1) = Y(1,3)
	Y(1,4) = m1
	  Y(1,4) = Y(1,4) + m4
	  Y(1,4) = Y(1,4) - p4p5
	Y(4,1) = Y(1,4)
	Y(1,5) = m1
	  Y(1,5) = Y(1,5) + m5
	  Y(1,5) = Y(1,5) - p5
	Y(5,1) = Y(1,5)
	Y(2,3) = m2
	  Y(2,3) = Y(2,3) + m3
	  Y(2,3) = Y(2,3) - p2
	Y(3,2) = Y(2,3)
	Y(2,4) = m2
	  Y(2,4) = Y(2,4) + m4
	  Y(2,4) = Y(2,4) - p2p3
	Y(4,2) = Y(2,4)
	Y(2,5) = m2
	  Y(2,5) = Y(2,5) + m5
	  Y(2,5) = Y(2,5) - p5p1
	Y(5,2) = Y(2,5)
	Y(3,4) = m3
	  Y(3,4) = Y(3,4) + m4
	  Y(3,4) = Y(3,4) - p3
	Y(4,3) = Y(3,4)
	Y(3,5) = m3
	  Y(3,5) = Y(3,5) + m5
	  Y(3,5) = Y(3,5) - p3p4
	Y(5,3) = Y(3,5)
	Y(4,5) = m4
	  Y(4,5) = Y(4,5) + m5
	  Y(4,5) = Y(4,5) - p4
	Y(5,4) = Y(4,5)

	do i = 1, 5
	  do j = 1, 25
	    Yiflat(j) = Yflat(j)
	  enddo
	  do j = 1, 5
	    Yi(j,i) = 1
	  enddo
	  call XDet(5, Yi,5, eta(i))
	enddo

	call XDet(5, Y,5, detY)

	res = -(
     &    eta(1)*XD0(p2, p3, p4, p5p1, p2p3, p3p4, m2, m3, m4, m5) +
     &    eta(2)*XD0(p1p2, p3, p4, p5, p4p5, p3p4, m1, m3, m4, m5) +
     &    eta(3)*XD0(p1, p2p3, p4, p5, p4p5, p5p1, m1, m2, m4, m5) +
     &    eta(4)*XD0(p1, p2, p3p4, p5, p1p2, p5p1, m1, m2, m3, m5) +
     &    eta(5)*XD0(p1, p2, p3, p4p5, p1p2, p2p3, m1, m2, m3, m4)
     &  )/detY
	end

