/*! 
* This Source Code Form is subject to the terms of the Mozilla Public
* License, v. 2.0. If a copy of the MPL was not distributed with this file,
* You can obtain one at http://mozilla.org/MPL/2.0/.
*
* Copyright(c) 2009 Apogee Instruments, Inc. 
* \class UdpSocketBase 
* \brief Base class for a upd socket that finds apogee devices on a subnet 
* 
*/ 


#ifndef UDPSOCKETBASE_INCLUDE_H__ 
#define UDPSOCKETBASE_INCLUDE_H__ 

#include <string>
#include <vector>
#include <stdint.h>

class UdpSocketBase 
{ 
    public: 
        virtual ~UdpSocketBase(); 

        std::vector<std::string> Search4ApogeeDevices(const std::string & subnet,
            uint16_t portNum);

        int32_t GetElapsedSecs() { return m_elapsedSec;}
        int32_t GetTimeout() {return m_timeout;}

    protected:
        UdpSocketBase();
        virtual void CloseSocket() = 0;
        int32_t m_SocketDescriptor;

    private:
        void CreateSocket(uint16_t portNum);
        void SetSocketOptions();
        void CreateUpdPacket();
        
        void BroadcastMsg(const std::string & subnet,
            uint16_t portNum);

        std::string FetchMsgFromSocket();
        std::vector<std::string> GetReturnedMsgs();

        
        std::string m_udpPacket;
        const std::string m_fileName;
        int32_t m_timeout;
        int32_t m_elapsedSec;

        //disabling the copy ctor and assignment operator
        //generated by the compiler - don't want them
        //Effective C++ Item 6
        UdpSocketBase(const UdpSocketBase&);
        UdpSocketBase& operator=(UdpSocketBase&);
}; 

#endif
