package Business::EDI::CodeList::MeasuredAttributeCode;

use base 'Business::EDI::CodeList';
my $VERSION     = 0.02;
sub list_number {6313;}
my $usage       = 'C';

# *    6313  Measured attribute code                                 [C]
# Desc: Code specifying the attribute measured.
# Repr: an..3

my %code_hash = (
'A' => [ 'Consolidated weight',
    'The measured consolidated weight.' ],
'AAA' => [ 'Net weight',
    '[6160] Weight of goods including any packaging that normally going with the goods.' ],
'AAB' => [ 'Goods item gross weight',
    "[6292] Weight (mass) of goods including packing but excluding the carrier's equipment." ],
'AAC' => [ 'Total net weight',
    'Total weight of goods excluding packaging.' ],
'AAD' => [ 'Consignment gross weight',
    '[6012] Total gross weight (mass) of all goods items referred to as one consignment including packaging but excluding any transport equipment.' ],
'AAF' => [ 'Net net weight',
    '[6048] Weight (mass) if goods without any packaging.' ],
'AAG' => [ 'Stern thrust',
    'Force exerted by a thruster installed at the stern of a vessel.' ],
'AAH' => [ 'Bow thrust',
    'Force exerted by a thruster installed at the bow of a vessel.' ],
'AAI' => [ 'Hydrate content of an alcoholic product at bottling',
    'The hydrate content of an alcoholic product at the moment of bottling.' ],
'AAJ' => [ 'Number of units per pallet',
    'The number of units contained on a pallet.' ],
'AAK' => [ 'Fat content',
    'An indication of the fat content of a product.' ],
'AAM' => [ 'Transport means gross weight',
    '[6300] The measure of the overall size of a ship determined in accordance with the provisions of the International Convention on Tonnage Measurement of Ships, 1969.' ],
'AAN' => [ 'Net tonnage of the vessel',
    '[6302] The measure of the useful capacity of a ship determined in accordance with the provisions of the International Convention on Tonnage Measurement of Ships, 1969.' ],
'AAO' => [ 'Humidity',
    'Degree of moisture.' ],
'AAP' => [ 'Voltage',
    'Electromotive force, or difference of electronic potential between two points.' ],
'AAQ' => [ 'Power consumption',
    'Value of energy consumption.' ],
'AAR' => [ 'Heat dissipation',
    'Measurement of the rate of dispersal of heat.' ],
'AAS' => [ 'Air flow',
    'Measurement of the flow of air.' ],
'AAT' => [ 'Shock impact',
    'Measurement of the impact of a shock.' ],
'AAU' => [ 'Operative temperature',
    'Temperature identified system or process works according to specifications.' ],
'AAV' => [ 'Non operative temperature',
    'Temperature identified system or process does not work according to specifications.' ],
'AAW' => [ 'Gross volume',
    'The volume unadjusted for factors such as temperature or gravity.' ],
'AAX' => [ 'Net volume',
    'The volume after adjustment for factors such as temperature or gravity.' ],
'AAY' => [ 'Water content',
    'Water content in product.' ],
'AAZ' => [ 'Tensile stress',
    'The measured tensile stress.' ],
'ABA' => [ 'Fibrosity',
    'The measured fibrosity.' ],
'ABB' => [ 'Gauge length',
    'The measured gauge length.' ],
'ABC' => [ 'Radius',
    'The measured radius.' ],
'ABD' => [ 'Straightness',
    'Straightness of the item.' ],
'ABE' => [ 'Strain',
    'The measured strain.' ],
'ABF' => [ 'Item width when unrolled',
    'The width of an item when unrolled.' ],
'ABG' => [ 'Item length when unrolled',
    'The length of an item when unrolled.' ],
'ABH' => [ 'Item area when unrolled',
    'The area occupied by an item when unrolled.' ],
'ABI' => [ 'Original wort',
    'Measure of the malt and hops content of beer, before fermentation has taken place.' ],
'ABJ' => [ 'Volume',
    'The amount of air space taken up by the entity identified in the 6311 qualifier.' ],
'ABK' => [ 'Angle',
    'The angle of an object.' ],
'ABL' => [ 'Peg hole horizontal distance from package leftmost edge',
    'Horizontal distance from the left most edge of the package to the center of the hole into which the peg is inserted.' ],
'ABM' => [ 'Peg hole vertical distance from package top',
    'Vertical distance from the top of the package to the top of the hole into which the peg is inserted.' ],
'ABN' => [ 'Number of layers per pallet',
    'The number of layers per pallet.' ],
'ABO' => [ 'Product strengh, chemical',
    'The amount of the single active chemical ingredient within a product.' ],
'ABP' => [ 'Product strength basis, chemical',
    'Amount of product used as the basis for the specification of the chemical product strenght.' ],
'ABS' => [ 'Item weight',
    'Weight at line item level.' ],
'ABT' => [ 'Payload weight, maximum',
    'The maximum weight of a payload.' ],
'ABX' => [ 'Weight of conveyance',
    'Tonnage of conveyance.' ],
'ABY' => [ 'Conveyance summer dead weight',
    'Registered summer dead weight total tonnage of the vessel.' ],
'ABZ' => [ "Containerized cargo on vessel's weight",
    'Total weight of containerized cargo on vessel.' ],
'ACA' => [ "Non-containerized cargo on vessel's weight",
    'Total weight of non-containerized cargo on vessel.' ],
'ACE' => [ 'Ascertained weight',
    '[4240] Endorsement of the true weight (mass) as ascertained or verified.' ],
'ACG' => [ 'Chargeable weight',
    'The weight on which charges are based.' ],
'ACN' => [ 'Estimated gross weight',
    "Estimated weight (mass) of goods, including packing and excluding carrier's." ],
'ACP' => [ 'Estimated volume',
    'Estimated size or measure of anything in three dimensions.' ],
'ACS' => [ 'Vessel overall length',
    'Total overall length of the vessel.' ],
'ACV' => [ 'Loading meters',
    'The length in a vehicle, whereby the complete width and height over that length is needed for the goods.' ],
'ACW' => [ 'Number of axles',
    'Number of axles of movable equipment or means of transport on wheels.' ],
'ACX' => [ 'Payload',
    'The revenue-producing load carried by a means of transport.' ],
'ADR' => [ 'Start position in the length',
    'The starting position from the beginning of an item located in the length direction.' ],
'ADS' => [ 'End position in the length',
    'The end position from the beginning of an item located in the length direction.' ],
'ADT' => [ 'Start position in the width',
    'The start position from the beginning of an item located in the width direction.' ],
'ADU' => [ 'End position in the width',
    'The end position from the beginning of an item located in the width direction.' ],
'ADV' => [ 'Start position in the thickness',
    'The start position from the beginning of an item located in the thickness direction.' ],
'ADW' => [ 'End position in the thickness',
    'The end position from the beginning of an item located in the thickness direction.' ],
'ADX' => [ 'Transport container actual filling weight',
    'Actual filling weight of a transport container.' ],
'ADY' => [ 'Transport container maximum capacity',
    'Maximum capacity of a transport container.' ],
'ADZ' => [ 'Declared net weight',
    'The declared net weight of a product or products used for invoicing, customs or transport purposes.' ],
'AEA' => [ 'Loading height',
    'Maximum height of products or packages loaded onto a given transportation device or equipment such as a pallet.' ],
'AEB' => [ 'Stacking height',
    'Maximum height up to which the same product or package may be placed one upon the other for storage purposes.' ],
'AEC' => [ 'Calculated weight',
    'The calculated weight of the item based on the ordered dimensions.' ],
'AED' => [ 'Ferrite',
    'The chemical composition ferrite.' ],
'AEE' => [ 'Impurity',
    'The impurity of the product i.e. the measurement of other chemical elements not normally appearing in a product.' ],
'AEF' => [ 'Grain size',
    'The grain size.' ],
'AEG' => [ 'Lanthanides',
    'The chemical element Lanthanides.' ],
'AEH' => [ 'Elasticity',
    'The value of the elasticity.' ],
'AEI' => [ 'Drained weight',
    'The weight of a product when all liquids used in the packaging of the product have been removed.' ],
'AEJ' => [ 'Gallium',
    'Measurement of the gallium component.' ],
'AEK' => [ 'Strontium',
    'Measurement of the strontium component.' ],
'AEL' => [ 'Area',
    'Extent or measure of a surface.' ],
'AEM' => [ 'Equipment storage limitation',
    'Maximum storage limit of the equipment.' ],
'AEN' => [ 'Radioactive index of transport',
    'The index of transport determines the maximum radiation level at a distance of 1m from the external surface.' ],
'AEO' => [ 'Radioactivity',
    'Activity of radioactive material.' ],
'AEP' => [ 'Average gross weight',
    'Weight which is the outcome of the division of the total gross weight by the number of units.' ],
'AEQ' => [ 'Forward draft',
    'Depth of water from the surface of water to the bottom of the vessel measured at the draft mark of the bow.' ],
'AER' => [ 'After draft',
    'Depth of water from the surface of water to the bottom of the vessel measured at the draft mark of the stern.' ],
'AES' => [ 'Acidity',
    'The quality, state, or degree of being acid.' ],
'AET' => [ 'Transport equipment gross weight',
    "Weight of a transport equipment including the cargo and carrier's equipment." ],
'AEU' => [ 'Total transport equipment gross weight',
    "Total weight of all transport equipment including the cargo and carrier's equipment." ],
'AEV' => [ 'Acidity of juice',
    'Acid measurement of juice.' ],
'AEW' => [ 'Penetrometry',
    'Measurement of force required to drive a standard penetrating stamp.' ],
'AEX' => [ 'Durofel',
    'Measurement of the elastic force using a standard penetrating stamp.' ],
'AEY' => [ 'Juice weight per 100 grams',
    'Measurement of weight of juice, based on 100 grams of the entire weight.' ],
'AEZ' => [ 'Fruit skin colour',
    'Measurement of the colouring of the epidermis of a fruit.' ],
'AF' => [ 'Angle of bend',
    'The measured angle of bend.' ],
'AFA' => [ 'Fixed incremental measurement',
    'The measurement of the fixed increment.' ],
'AFB' => [ 'Durofel D10',
    'Measure of the elastic force of the pulp of a fruit. It is measured with a penetrating stamp with diameter 10.' ],
'AFC' => [ 'Durofel D25',
    'Measure of the elastic force of the pulp of a fruit. It is measured with a penetrating stamp with diameter 25.' ],
'AFD' => [ 'Durofel D50',
    'Measure of the elastic force of the pulp of a fruit. It is measured with a penetrating stamp with diameter 50.' ],
'AFE' => [ 'Maximum stacking weight',
    'The maximum weight which may be stacked upon a product or package without the product or packaging being crushed.' ],
'AFF' => [ 'Gross measure cube',
    'The total cubic space occupied by an item, taking into account any protruding components, arrived at by multiplying the maximum length, width and height.' ],
'AFG' => [ 'Percentage fat content in dry matter',
    'The percentage of fat content in dry matter.' ],
'AFH' => [ 'Saccharometric content',
    'Measurement of the sugar content of a solution.' ],
'AFI' => [ 'Hydrate content of an alcoholic product after bottling',
    'The hydrate content which occurs in an alcoholic product after bottling.' ],
'AFJ' => [ 'Anhydrous content',
    'The non-water content.' ],
'AFK' => [ 'Certified weight',
    'Weight which has been certified.' ],
'AFL' => [ 'Freeboard',
    'The vertical distance between the waterline and the upper edge of the deck line.' ],
'AFM' => [ 'Maximum vessel draught',
    'The depth of water needed to float the ship (Maximum vessel draught according to Load Line Certificate IMO, MSC/Circ. 920 15 June 1999).' ],
'AFN' => [ 'Net explosive weight',
    'Mass of the explosive part or substance of goods without any packing.' ],
'AFO' => [ 'Radioactive criticality safety index',
    'A number, assigned to fissile material i.e. material capable of sustaining a nuclear chain reaction, which is used to provide control over the accumulation of packages containing such material.' ],
'AFP' => [ 'Waste currently on board',
    'Amount of waste on board at the moment of the notification.' ],
'AFQ' => [ 'Waste to be delivered at waste reception facility',
    'Amount of waste to be delivered to a waste reception facility, e.g. in the port of call.' ],
'AFR' => [ 'Waste to be generated until next port of call, estimated',
    'Estimated amount of waste to be generated between creation of the current notification and arrival in the next port of call, irrespective of use of incinerator or compactor or disposal at sea.' ],
'AFS' => [ 'Waste remaining on board at departure',
    'Amount of waste remaining on board when leaving the port of call.' ],
'AFT' => [ 'Colour depth',
    'The number of distinct colours represented, e.g. in an image or in a display.' ],
'AFU' => [ 'Colour depth, maximum',
    'The maximum number of distinct colours that can be represented, e.g. in an image or in a display.' ],
'AFV' => [ 'Image resolution',
    'The level of detail of an image.' ],
'AFW' => [ 'Device resolution, maximum',
    'The maximum level of detail produced by a device.' ],
'AFX' => [ 'Acoustic absorption coefficient',
    'The portion of sound energy a surface absorbs, measured at different frequencies.' ],
'B' => [ 'Billed weight',
    'The measured billed weight.' ],
'BL' => [ 'Breaking load',
    'The measured breaking load.' ],
'BMY' => [ 'Platinum',
    'The measurement of the platinum component.' ],
'BMZ' => [ 'Silver',
    'The measurement of the silver component.' ],
'BNA' => [ 'List',
    'The leaning or inclination of a vessel expressed in degrees port or starboard.' ],
'BNB' => [ 'Trim',
    'The condition of a vessel with reference to its longitudinal axis.' ],
'BNC' => [ 'Free water',
    'The volume of water present in a container that is not in suspension in the contained liquid.' ],
'BND' => [ 'Bands',
    'The measured bands.' ],
'BNE' => [ 'API (American Petroleum Institute) gravity',
    'The relative density of petroleum liquids as specified by a standard developed by the API.' ],
'BNF' => [ 'Petroleum gross observed volume',
    'The total volume of all petroleum liquids and sediment and water, excluding free water, at observed temperature and pressure.' ],
'BNG' => [ 'Petroleum gross standard volume',
    'The total volume of all petroleum liquids, sediment, and water excluding free water, corrected by the appropriate volume correction factor for the observed temperature and American Petroleum Institute relative density, or density to a standard temperature.' ],
'BNH' => [ 'Volume variance',
    'The change in the volume measurement.' ],
'BNI' => [ 'Petroleum net standard volume',
    'The total volume of all petroleum liquids, excluding sediment and water and free water, corrected by the appropriate volume correction factor for the observed temperature and American Petroleum Institute gravity relative to density or to a standard temperature.' ],
'BNJ' => [ 'Material on-board quantity, after discharge',
    'The material in vessel tanks, void spaces, and pipelines after discharge.' ],
'BNK' => [ 'Petroleum total calculated volume',
    'The total volume of all petroleum liquids, sediment and water corrected by the appropriate volume correction factor for the observed temperature and American Petroleum Institute (API) gravity, relative density, or density to a standard temperature.' ],
'BNL' => [ 'Petroleum total observed volume',
    'The total volume of all petroleum liquids, sediment and water and free water at observed temperature and pressure.' ],
'BNM' => [ 'Innage gauge distance',
    'The measured distance from the surface of the liquid to a fixed datum plate or to the tank bottom.' ],
'BNN' => [ 'Petroleum net standard weight',
    'The total weight of all petroleum liquids excluding sediments, water and free water.' ],
'BNO' => [ 'Sediment and water in petroleum',
    'The measurement of non-hydrocarbon solid material and water in suspension in petroleum liquid.' ],
'BNP' => [ 'Observed reference height, tank',
    'The observed distance from the tank bottom or datum plate to the established reference point.' ],
'BNQ' => [ 'Reference height, tank',
    'The measured distance from the tank bottom or datum plate to the established reference point.' ],
'BNR' => [ 'Ullage gauge distance',
    'The measured distance from the cargo liquid surface to the reference point.' ],
'BNS' => [ 'Trim correction',
    'The correction applied to the observed gauge or observed volume when a vessel is not on an even keel.' ],
'BNT' => [ 'Bow to bridge distance',
    'The distance between the bow and the bridge of a vessel.' ],
'BNU' => [ 'Peg hole number',
    'Used to identify the peg hole if more than one hole is present in the product or packaging.' ],
'BNV' => [ 'Number of inner packs',
    'Indicates the number of non coded physical groupings (inner packs) of next lower level trade items within the current trade item level.' ],
'BNW' => [ 'Number of next level trade items within inner pack',
    'The number of next lower level trade items contained within the physical non-coded grouping (inner pack).' ],
'BNX' => [ 'Number of trade items per pallet layer',
    'The number of trade items contained on a single layer of a pallet.' ],
'BNY' => [ 'Packed items layer height',
    'The height of a single layer of packed items.' ],
'BNZ' => [ 'Packing material weight, skin tight covering',
    'The weight measurement of the packing material used for skin tight covering (e.g. when packaging prepared meats, poultry, cheese, and other food products).' ],
'BR' => [ 'Brightness',
    'The measured brightness.' ],
'BRA' => [ 'Brakes',
    'The measured brakes.' ],
'BRB' => [ 'Components labelled for recycling percentage',
    'Percentage of trade item components that clearly label how to facilitate product disassembly and recycling.' ],
'BRC' => [ 'Renewable plastic components percentage, by net weight',
    'The percentage of the plastic components only made from rapidly renewable plant-based material by net weight of product.' ],
'BRD' => [ 'Clamp pressure, required',
    'The pressure that should be applied by a clamp.' ],
'BRE' => [ 'Break',
    'The measured break.' ],
'BS' => [ 'Breaking strength',
    'The measured breaking strength.' ],
'BSW' => [ 'Breaking strength wet',
    'The measured breaking strength when wet.' ],
'BW' => [ 'Basis weight',
    'The measured basis weight.' ],
'CHN' => [ 'Change',
    'The measured change.' ],
'CM' => [ 'Colour',
    'The measured colour.' ],
'CT' => [ 'Contents of package',
    'In combination with the other data elements of the actual segment this code indicates the measured content of a package.' ],
'CV' => [ 'Commercial weight',
    'Item weight considering its maximum possible humidity.' ],
'CZ' => [ 'Core length',
    'To specify length of core on which product is to be placed.' ],
'D' => [ 'Destination weight agreement',
    'The agreed weight of despatched goods whose weight may change during transport.' ],
'DI' => [ 'Diameter',
    'Diameter of an article.' ],
'DL' => [ 'Delta value L',
    'The measured delta value L.' ],
'DN' => [ 'Density',
    'The measured density.' ],
'DP' => [ 'Depth',
    'The measured depth.' ],
'DR' => [ 'Denier',
    'The measured fineness of a material.' ],
'DS' => [ 'Distance between points',
    'The measured distance between points.' ],
'DW' => [ 'Width, boxcar door',
    'The measured width of a boxcar door.' ],
'E' => [ 'Estimated new weight',
    'The measured estimated new weight.' ],
'EA' => [ 'Elongation',
    'The measured elongation.' ],
'F' => [ 'Deficit weight',
    'The measured deficit weight.' ],
'FI' => [ 'Filament count',
    'Used e.g. in textile, print industries.' ],
'FL' => [ 'Longitudinal flatness',
    'The measured longitudinal flatness.' ],
'FN' => [ 'Flatness',
    'The measured flatness.' ],
'FV' => [ 'Transverse flatness',
    'The measured transverse flatness.' ],
'GG' => [ 'Gauge',
    'The measured gauge.' ],
'GW' => [ 'Gross weight, maximum',
    'The measured maximum gross weight.' ],
'HF' => [ 'Hardness',
    'The measured hardness.' ],
'HM' => [ 'Height, maximum',
    'The measured maximum height.' ],
'HT' => [ 'Height dimension',
    'Numeric value of height.' ],
'IB' => [ 'Impact energy',
    'The measured impact energy.' ],
'ID' => [ 'Inside diameter',
    'The measured inside diameter.' ],
'L' => [ 'Legal weight',
    'The measured legal weight.' ],
'LM' => [ 'Length, maximum',
    'The measured maximum length.' ],
'LN' => [ 'Length',
    '[6168] To specify the value of a length dimension.' ],
'LND' => [ 'Lost end',
    'The measured lost end.' ],
'M' => [ 'Minimum weight',
    'The measured minimum weight.' ],
'MO' => [ 'Moisture',
    'Measurement application is the moisture content of the item.' ],
'MW' => [ 'Maximum weight',
    'The measured maximum weight.' ],
'N' => [ 'Actual net weight',
    'The actual weight of the goods excluding packaging.' ],
'OD' => [ 'Outside diameter',
    'The measured outside diameter.' ],
'PRS' => [ 'Pre stretch',
    'Measurement identifying the amount an item has been stretched prior to use.' ],
'PTN' => [ 'Per tonne',
    'A measurement per tonne.' ],
'RA' => [ 'Relative humidity',
    'The measured relative humidity.' ],
'RF' => [ 'Resistivity',
    'The measured resistivity.' ],
'RJ' => [ 'Rockwell C',
    'Hardness in the Rockwell C scale.' ],
'RMW' => [ 'Ream weight',
    'Measurement indication for paper.' ],
'RP' => [ 'Reduction of area',
    'The measured reduction of area.' ],
'RUN' => [ 'Run (process)',
    'The measured run (process).' ],
'RY' => [ 'Ratio',
    'The measured ratio.' ],
'SQ' => [ 'Shipped quantity',
    'The measured shipped quantity.' ],
'T' => [ 'Tare weight',
    'Weight excluding goods and loose accessories.' ],
'TC' => [ 'Temperature',
    'A measurement in relation to temperature.' ],
'TH' => [ 'Thickness',
    'The measured thickness.' ],
'TN' => [ 'Time period',
    'Measurement of a specific length of time.' ],
'TT' => [ 'Time',
    'The measured time.' ],
'VH' => [ 'Height, van door',
    'The height of the door of a van or container.' ],
'VW' => [ 'Width, van door',
    'The width of the door of a van or container.' ],
'WA' => [ 'Weight per unit of area',
    'The weight per unit of an area.' ],
'WD' => [ 'Width dimension',
    'Numeric value of width.' ],
'WM' => [ 'Width, maximum',
    'The maximum distance from side to side.' ],
'WU' => [ 'Weight per unit of length',
    'The weight per unit of length.' ],
'XH' => [ 'Side height, flat bed with removable sides',
    'The height of the removable sides of a flat bed truck.' ],
'XQ' => [ 'Squareness',
    'The measured squareness.' ],
'XZ' => [ 'Spool size',
    'The measured spool size.' ],
'YS' => [ 'Yield stress',
    'The measured yield stress.' ],
'ZAL' => [ 'Aluminium',
    'The measured chemical element aluminium.' ],
'ZAS' => [ 'Arsenic',
    'The measured chemical element arsenic.' ],
'ZB' => [ 'Boron',
    'The measured chemical element boron.' ],
'ZBI' => [ 'Bismuth',
    'The measured chemical element bismuth.' ],
'ZC' => [ 'Carbon',
    'The measured chemical element carbon.' ],
'ZCA' => [ 'Calcium',
    'The measured chemical element calcium.' ],
'ZCB' => [ 'Columbium',
    'The measured chemical element columbium.' ],
'ZCE' => [ 'Cerium',
    'The measured chemical element cerium.' ],
'ZCL' => [ 'Chlorine',
    'The measured chemical element chlorine.' ],
'ZCO' => [ 'Cobalt',
    'The measured chemical element cobalt.' ],
'ZCR' => [ 'Chromium',
    'The measured chemical element chromium.' ],
'ZCU' => [ 'Copper',
    'The measured chemical element copper.' ],
'ZFE' => [ 'Iron',
    'The measured chemical element iron.' ],
'ZFS' => [ 'Iron plus silicon',
    'The measured substance iron plus silicon.' ],
'ZGE' => [ 'Germanium',
    'The measured chemical element germanium.' ],
'ZH' => [ 'Hydrogen',
    'The measured chemical element hydrogen.' ],
'ZK' => [ 'Potassium',
    'The measured chemical element potassium.' ],
'ZMG' => [ 'Magnesium',
    'The measured chemical element magnesium.' ],
'ZMN' => [ 'Manganese',
    'The measured chemical element manganese.' ],
'ZMO' => [ 'Molybdenum',
    'The measured chemical element molybdenum.' ],
'ZN' => [ 'Nitrogen',
    'The measured chemical element nitrogen.' ],
'ZNA' => [ 'Sodium',
    'The measured chemical element sodium.' ],
'ZNB' => [ 'Niobium',
    'The chemical element niobium.' ],
'ZNI' => [ 'Nickel',
    'The measured chemical element nickel.' ],
'ZO' => [ 'Oxygen',
    'The measured chemical element oxygen.' ],
'ZP' => [ 'Phosphorus',
    'The measured chemical element phosphorus.' ],
'ZPB' => [ 'Lead',
    'The measured chemical element lead.' ],
'ZS' => [ 'Sulphur',
    'The measured chemical element sulphur.' ],
'ZSB' => [ 'Antimony',
    'The measured chemical element antimony.' ],
'ZSE' => [ 'Selenium',
    'The measured chemical element selenium.' ],
'ZSI' => [ 'Silicon',
    'The measured chemical element silicon.' ],
'ZSL' => [ 'Silicium oxyd',
    'The measured substance silicium oxyd.' ],
'ZSN' => [ 'Tin',
    'The measured chemical element tin.' ],
'ZTA' => [ 'Tantalium',
    'The measured chemical element tantalium.' ],
'ZTE' => [ 'Tellurium',
    'The measured chemical element tellurium.' ],
'ZTI' => [ 'Titanium',
    'The measured chemical element titanium.' ],
'ZV' => [ 'Vanadium',
    'The measured chemical element vanadium.' ],
'ZW' => [ 'Tungsten',
    'The measured chemical element tungsten.' ],
'ZWA' => [ 'Waste content',
    'The measured waste content.' ],
'ZZN' => [ 'Zinc',
    'The measured chemical element zinc.' ],
'ZZR' => [ 'Zirconium',
    'The measured chemical element zirconium.' ],
'ZZZ' => [ 'Mutually defined',
    'A code assigned within a code list to be used on an interim basis and as defined among trading partners until a precise code can be assigned to the code list.' ],
);
sub get_codes { return \%code_hash; }

1;
