/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.ByteBufferImpl;
import java.nio.IntBuffer;
import java.nio.IntBufferImpl;

class DirectIntBuffer
extends IntBufferImpl {
    DirectIntBuffer(ByteBufferImpl byteBufferImpl, int n, int n2) {
        super(byteBufferImpl, n, null, n2);
    }

    public boolean isDirect() {
        return true;
    }

    public IntBuffer slice() {
        return new DirectIntBuffer(this.parent, this.limit - this.position, this.arrayOffset + (this.position << 2));
    }

    public int get(int n) {
        return ByteBufferImpl._getInt(this.arrayOffset + (this.checkIndex(n) << 2));
    }

    final void copyToArray(int[] nArray, int n, int n2) {
        ByteBufferImpl.memoryToIntArray(this.arrayOffset + (this.position << 2), nArray, n, n2);
    }

    public IntBuffer put(int n, int n2) {
        ByteBufferImpl._putInt(this.arrayOffset + (this.checkIndex(n) << 2), n2);
        return this;
    }

    void copyFromArray(int[] nArray, int n, int n2) {
        ByteBufferImpl.intArrayToMemory(nArray, n, this.arrayOffset + (this.position << 2), n2);
    }

    void copyToIntBuffer(int n, IntBuffer intBuffer) {
        intBuffer.copyFromDirectIntBuffer(this, n);
    }

    void copyFromHeapIntBuffer(IntBuffer intBuffer, int n) {
        ByteBufferImpl.intArrayToMemory(intBuffer.array, intBuffer.arrayOffset + intBuffer.position, this.arrayOffset + (this.position << 2), n);
    }

    void copyFromByteBufferAsIntBuffer(IntBuffer intBuffer, int n) {
        byte[] byArray = intBuffer.parent.array;
        int n2 = intBuffer.parent.arrayOffset + intBuffer.arrayOffset + (intBuffer.position << 2);
        int n3 = this.arrayOffset + (this.position << 2);
        ByteBufferImpl.byteArrayToMemory(byArray, n2, n3, 4 * n);
    }

    void copyFromDirectIntBuffer(IntBuffer intBuffer, int n) {
        int n2 = intBuffer.arrayOffset + (intBuffer.position << 2);
        int n3 = this.arrayOffset + (this.position << 2);
        ByteBufferImpl._copyBytes(n2, n3, n << 2);
    }
}

