/*
 * Decompiled with CFR 0.152.
 */
package org.boehn.kmlframework.kml;

import java.util.List;
import org.boehn.kmlframework.kml.AltitudeModeEnum;
import org.boehn.kmlframework.kml.Geometry;
import org.boehn.kmlframework.kml.Kml;
import org.boehn.kmlframework.kml.KmlException;
import org.boehn.kmlframework.kml.LinearRing;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Polygon
extends Geometry {
    private Boolean extrude;
    private Boolean tessellate;
    private AltitudeModeEnum altitudeMode;
    private LinearRing outerBoundary;
    private List<LinearRing> innerBoundaries;

    public Polygon() {
    }

    public Polygon(Boolean extrude, Boolean tessellate, AltitudeModeEnum altitudeMode, LinearRing outerBoundary, List<LinearRing> innerBoundaries) {
        this.extrude = extrude;
        this.tessellate = tessellate;
        this.altitudeMode = altitudeMode;
        this.outerBoundary = outerBoundary;
        this.innerBoundaries = innerBoundaries;
    }

    public Boolean getExtrude() {
        return this.extrude;
    }

    public void setExtrude(Boolean extrude) {
        this.extrude = extrude;
    }

    public Boolean getTessellate() {
        return this.tessellate;
    }

    public void setTessellate(Boolean tessellate) {
        this.tessellate = tessellate;
    }

    public AltitudeModeEnum getAltitudeMode() {
        return this.altitudeMode;
    }

    public void setAltitudeMode(AltitudeModeEnum altitudeMode) {
        this.altitudeMode = altitudeMode;
    }

    public LinearRing getOuterBoundary() {
        return this.outerBoundary;
    }

    public void setOuterBoundary(LinearRing outerBoundary) {
        this.outerBoundary = outerBoundary;
    }

    public List<LinearRing> getInnerBoundaries() {
        return this.innerBoundaries;
    }

    public void setInnerBoundaries(List<LinearRing> innerBoundaries) {
        this.innerBoundaries = innerBoundaries;
    }

    @Override
    public void write(Kml kml) throws KmlException {
        if (this.outerBoundary == null) {
            throw new KmlException("An outerBoundary is required in a Polygon");
        }
        kml.println("<Polygon" + this.getIdAndTargetIdFormatted(kml) + ">", 1);
        if (this.extrude != null) {
            kml.println("<extrude>" + Polygon.booleanToInt(this.extrude) + "</extrude>");
        }
        if (this.tessellate != null) {
            kml.println("<tessellate>" + Polygon.booleanToInt(this.tessellate) + "</tessellate>");
        }
        if (this.altitudeMode != null) {
            kml.println("<altitudeMode>" + (Object)((Object)this.altitudeMode) + "</altitudeMode>");
        }
        kml.println("<outerBoundaryIs>", 1);
        this.outerBoundary.write(kml);
        kml.println(-1, "</outerBoundaryIs>");
        if (this.innerBoundaries != null) {
            for (LinearRing innerBounadry : this.innerBoundaries) {
                kml.println("<innerBoundaryIs>", 1);
                innerBounadry.write(kml);
                kml.println(-1, "</innerBoundaryIs>");
            }
        }
        kml.println(-1, "</Polygon>");
    }

    @Override
    public void writeDelete(Kml kml) throws KmlException {
        kml.println("<Polygon" + this.getIdAndTargetIdFormatted(kml) + "></>");
    }
}

